+++
title = "Cylinder"
+++

### Cylinder

An upright circular cylinder.

<img src="/img/draw/ff/3d/Cylinder.png" width="30%" >
<img src="/img/draw/ff/2d/Cylinder_xy.svg" width="30%">
<img src="/img/draw/ff/2d/Cylinder_xz.svg" width="30%">

#### Constructor

```python
Cylinder(R, H)
```

Parameters:
- R, radius
- H, height

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "Cylinder" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.

Form factor is computed as

$$ F(\mathbf{q})=2\pi R^2H \space \exp\Big(iq_z\dfrac{H}{2}\Big) \text{sinc}\Big(q_z\dfrac{H}{2}\Big)
\dfrac{J_1(q_{\parallel}R)}{q_{\parallel}R} , $$
with the notation 
$$ q_{||} := \sqrt{q_x^2 + q_y^2}. $$

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$V=\pi R^2H.$$

#### Related shapes

More general:
- [Cone](/ref/sample/particle/ff/hard/cone), if radius varies with z.
- [EllipsoidalCylinder](/ref/sample/particle/ff/hard/ellipsoidalcylinder), if base is an ellipse.
- [HorizontalCylinder](/ref/sample/particle/ff/hard/horizontalcylinder), if horizontal and truncated.
 
#### Example

Scattering by uncorrelated, oriented cylinders for horizontal incidence. Rotation around $y$ axis:

<img src="/img/auto/ff/Cylinder.png">

Generated by {{% ref-ex "ff/Cylinder.py" %}}.

#### History

This form factor is well known; it goes back to Lord Rayleigh.

In IsGISAXS and FitGISAXS, it has been implemented as form factor "Cylinder"
[[manual](/lit/lazzari2006), Eq. 2.26; [Renaud 2009](/lit/renaud2009), Eq. 223; [Babonneau 2013](/lit/babonneau2013)].
