{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAxisRotation: TVector4;
    procedure SetAxisRotation(const Value: TVector4);
    function GetMaxPosition: TVector2;
    procedure SetMaxPosition(const Value: TVector2);
    function GetMinPosition: TVector2;
    procedure SetMinPosition(const Value: TVector2);
    function GetOffset: TVector3;
    procedure SetOffset(const Value: TVector3);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdAxisRotation: TSFRotation;
    { Internal wrapper for property @code(AxisRotation). This wrapper API may change, we advise to access simpler @code(AxisRotation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAxisRotation: TSFRotation read FFdAxisRotation;
    {  }
    property AxisRotation: TVector4 read GetAxisRotation write SetAxisRotation;

    strict private FFdMaxPosition: TSFVec2f;
    { Internal wrapper for property @code(MaxPosition). This wrapper API may change, we advise to access simpler @code(MaxPosition) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMaxPosition: TSFVec2f read FFdMaxPosition;
    {  }
    property MaxPosition: TVector2 read GetMaxPosition write SetMaxPosition;

    strict private FFdMinPosition: TSFVec2f;
    { Internal wrapper for property @code(MinPosition). This wrapper API may change, we advise to access simpler @code(MinPosition) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMinPosition: TSFVec2f read FFdMinPosition;
    {  }
    property MinPosition: TVector2 read GetMinPosition write SetMinPosition;

    strict private FFdOffset: TSFVec3f;
    { Internal wrapper for property @code(Offset). This wrapper API may change, we advise to access simpler @code(Offset) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdOffset: TSFVec3f read FFdOffset;
    {  }
    property Offset: TVector3 read GetOffset write SetOffset;

    strict private FEventTranslation_changed: TSFVec3fEvent;
    {  }
    public property EventTranslation_changed: TSFVec3fEvent read FEventTranslation_changed;

{$endif read_interface}

{$ifdef read_implementation}

{ TPlaneSensorNode ----------------------------------------------- }

function TPlaneSensorNode.GetAxisRotation: TVector4;
begin
  Result := FdAxisRotation.Value;
end;

procedure TPlaneSensorNode.SetAxisRotation(const Value: TVector4);
begin
  FdAxisRotation.Send(Value);
end;

function TPlaneSensorNode.GetMaxPosition: TVector2;
begin
  Result := FdMaxPosition.Value;
end;

procedure TPlaneSensorNode.SetMaxPosition(const Value: TVector2);
begin
  FdMaxPosition.Send(Value);
end;

function TPlaneSensorNode.GetMinPosition: TVector2;
begin
  Result := FdMinPosition.Value;
end;

procedure TPlaneSensorNode.SetMinPosition(const Value: TVector2);
begin
  FdMinPosition.Send(Value);
end;

function TPlaneSensorNode.GetOffset: TVector3;
begin
  Result := FdOffset.Value;
end;

procedure TPlaneSensorNode.SetOffset(const Value: TVector3);
begin
  FdOffset.Send(Value);
end;

class function TPlaneSensorNode.ClassX3DType: String;
begin
  Result := 'PlaneSensor';
end;

procedure TPlaneSensorNode.CreateNode;
begin
  inherited;

  FFdAxisRotation := TSFRotation.Create(Self, True, 'axisRotation', Vector3(0, 0, 1), 0);
   FdAxisRotation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAxisRotation);

  FFdMaxPosition := TSFVec2f.Create(Self, True, 'maxPosition', Vector2(-1, -1));
   FdMaxPosition.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMaxPosition);

  FFdMinPosition := TSFVec2f.Create(Self, True, 'minPosition', Vector2(0, 0));
   FdMinPosition.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMinPosition);

  FFdOffset := TSFVec3f.Create(Self, True, 'offset', Vector3(0, 0, 0));
   FdOffset.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdOffset);

  FEventTranslation_changed := TSFVec3fEvent.Create(Self, 'translation_changed', false);
  AddEvent(FEventTranslation_changed);
end;

{$endif read_implementation}
