(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[     51309,       1416]
NotebookOptionsPosition[     48239,       1307]
NotebookOutlinePosition[     48596,       1323]
CellTagsIndexPosition[     48553,       1320]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["This is a linear model. Therefore the Hessians \
computed later should agree with the Gauss-Newton approximation.", \
"Subsection"]], "Text",
 CellChangeTimes->{{3.45344526166114*^9, 3.453445311697339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "/", "10"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "9"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noise", "=", 
   RowBox[{"10", "^", 
    RowBox[{"-", "5"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yos", "=", 
   RowBox[{"MapIndexed", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "i"}], "}"}], ",", 
       RowBox[{
        RowBox[{"2", 
         RowBox[{"x", "^", "2"}], 
         RowBox[{"(", 
          RowBox[{"1", "-", "x"}], ")"}]}], "+", 
        RowBox[{"noise", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"First", "[", "i", "]"}], "+", "1"}], ")"}]}]}]}]}], 
      "]"}], ",", "xs"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yc", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_", ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"x", "^", "3"}]}], "+", 
   RowBox[{"a", " ", 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"b", " ", "x"}], " ", "+", " ", "c"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"residuals", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_", ",", "K_"}], "]"}], ":=", 
  RowBox[{"MapThread", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "yo"}], "}"}], ",", " ", 
      RowBox[{"yo", "-", 
       RowBox[{"K", " ", 
        RowBox[{"yc", "[", 
         RowBox[{"a", ",", "b", ",", "c", ",", "x"}], "]"}]}]}]}], "]"}], ",",
     
    RowBox[{"{", 
     RowBox[{"xs", ",", "yos"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_", ",", "K_"}], "]"}], ":=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"Plus", "@@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"residuals", "[", 
        RowBox[{"a", ",", "b", ",", "c", ",", "K"}], "]"}], "^", "2"}], 
      ")"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4531361544679813`*^9, 3.453136258427608*^9}, {
   3.45313630806728*^9, 3.453136352377912*^9}, {3.453136452529217*^9, 
   3.453136489430821*^9}, {3.4531367766703*^9, 3.4531367814929247`*^9}, {
   3.453136867608466*^9, 3.4531368688308887`*^9}, 3.453137022021336*^9, {
   3.453137126629039*^9, 3.453137162024404*^9}, {3.453137247461596*^9, 
   3.453137366084495*^9}, {3.453138167025906*^9, 3.453138182759507*^9}, {
   3.453138428241067*^9, 3.4531384799637327`*^9}, {3.4531385317167673`*^9, 
   3.4531385451891623`*^9}, {3.453138680628734*^9, 3.4531388627407103`*^9}, {
   3.4531389820811234`*^9, 3.453139002504006*^9}, {3.453139124181665*^9, 
   3.453139131517535*^9}, 3.453139206833242*^9, {3.453139281057641*^9, 
   3.453139365646186*^9}, {3.453139415985647*^9, 3.453139439860258*^9}, {
   3.4531842228662252`*^9, 3.45318422587681*^9}, {3.453225283238909*^9, 
   3.4532252862761717`*^9}, {3.453442496732595*^9, 3.453442549995037*^9}, {
   3.453442584058855*^9, 3.453442627939434*^9}, {3.453445124167849*^9, 
   3.4534451282047367`*^9}, 3.465112118899756*^9, {3.4651259562693663`*^9, 
   3.465125984481524*^9}, {3.465126055300674*^9, 3.465126073167531*^9}, {
   3.4988110512928743`*^9, 3.498811051659313*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vals", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "0.5"}], ",", 
    RowBox[{"b", "->", "0.3"}], ",", 
    RowBox[{"c", "->", "0.2"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.453443216800362*^9, 3.453443299104192*^9}, {
  3.453443453638317*^9, 3.4534434631170883`*^9}, {3.453443989215129*^9, 
  3.453443993847789*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.5`"}], ",", 
   RowBox[{"b", "\[Rule]", "0.3`"}], ",", 
   RowBox[{"c", "\[Rule]", "0.2`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.453443239018257*^9, 3.45344326444168*^9}, 
   3.453443300119232*^9, 3.453443464294207*^9, {3.453443995338179*^9, 
   3.453444006996067*^9}, 3.4647003242851677`*^9, 3.465062919135676*^9, 
   3.465065074705576*^9, 3.4651121243957148`*^9, 3.465123377594952*^9, 
   3.486392342768692*^9, 3.498810602323654*^9, 3.498811056290299*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"J", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"x", ",", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"yc", "[", 
           RowBox[{"a", ",", "b", ",", "c", ",", "x"}], "]"}], ",", 
          "\[Alpha]"}], "]"}]}], "]"}], ",", "xs"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"J", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], ".", 
     RowBox[{
      RowBox[{"J", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], "\[Transpose]"}]}], "/.", 
    "vals"}], "//", "N"}], "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.465125067291018*^9, 3.465125127823572*^9}, {
  3.4651251590739107`*^9, 3.4651252094158154`*^9}, {3.465125277817699*^9, 
  3.4651253153796167`*^9}, {3.465125412468603*^9, 3.465125449049811*^9}, {
  3.4651255041925983`*^9, 3.465125545818165*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.5333`", "2.025`", "2.85`"},
     {"2.025`", "2.85`", "4.5`"},
     {"2.85`", "4.5`", "10.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.4651252111890697`*^9, {3.465125282720212*^9, 3.465125320170917*^9}, {
   3.4651254374755993`*^9, 3.465125450693618*^9}, 3.465125550366375*^9, 
   3.465126081476706*^9, 3.4863923430709143`*^9, 3.498810629875525*^9, 
   3.498811058649261*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"diffKstar", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"Kstar", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "\[Alpha]"}], "]"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"diffKstar", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "/.", "vals"}], "//", 
  "N"}]}], "Input",
 CellChangeTimes->{{3.4651255788645477`*^9, 3.4651256240072308`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["Kstar", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"0.5`", ",", "0.3`", ",", "0.2`"}], "]"}], ",", 
   RowBox[{
    SuperscriptBox["Kstar", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"0.5`", ",", "0.3`", ",", "0.2`"}], "]"}], ",", 
   RowBox[{
    SuperscriptBox["Kstar", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"0.5`", ",", "0.3`", ",", "0.2`"}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.4651256251166267`*^9, 3.465126084068766*^9, 
  3.4863923432222567`*^9, 3.49881107198964*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Lstar", "[", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ",", 
     RowBox[{"ruleKstar", "[", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}]}], "}"}], "=", 
   RowBox[{
    RowBox[{"Minimize", "[", 
     RowBox[{
      RowBox[{"L", "[", 
       RowBox[{"a", ",", "b", ",", "c", ",", "K"}], "]"}], ",", "K"}], "]"}], 
    "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Kstar", "[", 
    RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "=", 
   RowBox[{"K", "/.", 
    RowBox[{"ruleKstar", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hgn", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"residuals", "[", 
        RowBox[{"a", ",", "b", ",", "c", ",", 
         RowBox[{"Kstar", "[", 
          RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}], ",", 
       "\[Alpha]"}], "]"}], ".", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"residuals", "[", 
        RowBox[{"a", ",", "b", ",", "c", ",", 
         RowBox[{"Kstar", "[", 
          RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}], ",", "\[Beta]"}],
       "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Beta]", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bgn", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"residuals", "[", 
       RowBox[{"a", ",", "b", ",", "c", ",", 
        RowBox[{"Kstar", "[", 
         RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}], ".", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"residuals", "[", 
         RowBox[{"a", ",", "b", ",", "c", ",", 
          RowBox[{"Kstar", "[", 
           RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}], ",", 
        "\[Alpha]"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.453442473592211*^9, 3.4534424836818113`*^9}, {
   3.453442631127253*^9, 3.453442632801585*^9}, {3.4534426672920837`*^9, 
   3.453442901017519*^9}, {3.453442932980752*^9, 3.4534429861197653`*^9}, {
   3.45344301943437*^9, 3.4534430269074306`*^9}, {3.4534438871134367`*^9, 
   3.4534439228250637`*^9}, {3.453444276664835*^9, 3.453444287631013*^9}, 
   3.465112263000457*^9, {3.4651229429129553`*^9, 3.465123112174398*^9}, {
   3.465123175697773*^9, 3.46512322525319*^9}, {3.465123360503191*^9, 
   3.46512338421434*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Kstar", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "/.", "vals"}], "//", 
  "InputForm"}]], "Input",
 CellChangeTimes->{{3.453444664286344*^9, 3.453444669741934*^9}, {
  3.4650648200652533`*^9, 3.465064822151106*^9}}],

Cell["0.6148971786833856", "Output",
 CellChangeTimes->{3.4534446719043694`*^9, 3.464700330273992*^9, 
  3.465062924772167*^9, 3.465064823319159*^9, 3.465123145965283*^9, 
  3.465123387032711*^9, 3.4651260898398247`*^9, 3.486392344108849*^9, 
  3.498811090798326*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"L", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", 
     RowBox[{"Kstar", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}], "/.", "vals"}], "//",
   "InputForm"}]], "Input",
 CellChangeTimes->{{3.464700369026559*^9, 3.464700391915563*^9}, {
  3.464700476193534*^9, 3.4647004781543837`*^9}, {3.464977930165423*^9, 
  3.464977955549013*^9}, {3.486392223761733*^9, 3.486392226192182*^9}}],

Cell["0.039642707534326034", "Output",
 CellChangeTimes->{3.4647003941214323`*^9, 3.464700479043138*^9, 
  3.4649779584161463`*^9, 3.465062926996952*^9, 3.4651231518352423`*^9, 
  3.465123389736532*^9, 3.465126092381175*^9, 3.486392344171486*^9, 
  3.498811093921275*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"AA", "=", 
   RowBox[{
    RowBox[{"Hgn", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], "/.", "vals"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AA", "//", "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{"AA", "//", "InputForm"}]}], "Input",
 CellChangeTimes->{{3.453442994932844*^9, 3.453443006865198*^9}, {
  3.4534430541469316`*^9, 3.4534431077287073`*^9}, {3.453443166471696*^9, 
  3.4534431829158773`*^9}, {3.453443279545011*^9, 3.4534432835785027`*^9}, {
  3.4534433383425417`*^9, 3.453443348565353*^9}, {3.45344358883284*^9, 
  3.4534435926422243`*^9}, {3.453443931921545*^9, 3.453444033643894*^9}, {
  3.4650650110665503`*^9, 3.465065019456649*^9}, {3.465065063341125*^9, 
  3.465065082355199*^9}, {3.46506527895463*^9, 3.465065281802389*^9}, {
  3.465123124629485*^9, 3.46512316636141*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.371944193675858`", "0.39066546997866547`", "0.10797294655500618`"},
     {"0.39066546997866547`", "0.41859250354804045`", 
      "0.08077629438075473`"},
     {"0.10797294655500618`", "0.08077629438075473`", "0.19767268057900367`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.4534429987892714`*^9, 3.453443032014927*^9}, {
   3.453443101954441*^9, 3.453443137304242*^9}, 3.4534431844065123`*^9, {
   3.453443243602984*^9, 3.4534433029174147`*^9}, 3.453443349635892*^9, 
   3.453443467433073*^9, 3.453443593670631*^9, {3.453443973370163*^9, 
   3.4534440345568933`*^9}, 3.464700333301503*^9, 3.4650629302285852`*^9, 
   3.4650646645676613`*^9, 3.465065030451441*^9, {3.465065070314095*^9, 
   3.465065078486861*^9}, 3.465065283946866*^9, {3.4651231545726633`*^9, 
   3.4651231677313137`*^9}, 3.465123392872607*^9, 3.465126007798403*^9, 
   3.465126094941845*^9, 3.486392344226912*^9, 3.498811168230983*^9}],

Cell["\<\
{{0.371944193675858, 0.39066546997866547, 0.10797294655500618}, 
 {0.39066546997866547, 0.41859250354804045, 0.08077629438075473}, 
 {0.10797294655500618, 0.08077629438075473, 0.19767268057900367}}\
\>", "Output",
 CellChangeTimes->{{3.4534429987892714`*^9, 3.453443032014927*^9}, {
   3.453443101954441*^9, 3.453443137304242*^9}, 3.4534431844065123`*^9, {
   3.453443243602984*^9, 3.4534433029174147`*^9}, 3.453443349635892*^9, 
   3.453443467433073*^9, 3.453443593670631*^9, {3.453443973370163*^9, 
   3.4534440345568933`*^9}, 3.464700333301503*^9, 3.4650629302285852`*^9, 
   3.4650646645676613`*^9, 3.465065030451441*^9, {3.465065070314095*^9, 
   3.465065078486861*^9}, 3.465065283946866*^9, {3.4651231545726633`*^9, 
   3.4651231677313137`*^9}, 3.465123392872607*^9, 3.465126007798403*^9, 
   3.465126094941845*^9, 3.486392344226912*^9, 3.4988111682352037`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"bb", "=", 
   RowBox[{
    RowBox[{"bgn", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], "/.", "vals"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"bb", "//", "InputForm"}]}], "Input",
 CellChangeTimes->{
  3.453445475503276*^9, {3.453445653478529*^9, 3.453445668838719*^9}, {
   3.465065023752152*^9, 3.465065051751319*^9}, {3.465123241392338*^9, 
   3.465123261753868*^9}, {3.465123347694818*^9, 3.4651233524664173`*^9}}],

Cell["\<\
{0.12149917297914861, 0.13803759252793774, -0.025190641142579157}\
\>", "Output",
 CellChangeTimes->{
  3.45344403973453*^9, 3.4534454778374157`*^9, 3.453445670732955*^9, 
   3.464700336857732*^9, 3.465062939860379*^9, {3.465065033057658*^9, 
   3.4650650535927553`*^9}, 3.465065084826363*^9, {3.465123265361904*^9, 
   3.4651232820649242`*^9}, 3.4651233986230717`*^9, 3.465126180267791*^9, 
   3.4863923444321947`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "x"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", "AA", "]"}]}], 
  ";"}], "\[IndentingNewLine]", "\[Lambda]", "\[IndentingNewLine]", 
 RowBox[{"x", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.465065090528837*^9, 3.465065092851303*^9}, {
  3.465065126216236*^9, 3.465065143974214*^9}, {3.4650654568680897`*^9, 
  3.465065519015175*^9}, {3.465123424794545*^9, 3.465123463584491*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.8152318213540329`", ",", "0.172156941879259`", ",", 
   "0.0008206145696094124`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.46506514636651*^9, {3.4650654642116547`*^9, 3.465065520835248*^9}, 
   3.465123415797257*^9, 3.4651234655480556`*^9, 3.465126218969634*^9, 
   3.48639234479499*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.6747172592486393`", "0.7074232850320691`", "0.21049683101282118`"},
     {
      RowBox[{"-", "0.0463615198712832`"}], 
      RowBox[{"-", "0.24401184824678565`"}], "0.9686634231715433`"},
     {"0.7366187816959522`", 
      RowBox[{"-", "0.6633328830305517`"}], 
      RowBox[{"-", "0.1318417867868433`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.46506514636651*^9, {3.4650654642116547`*^9, 3.465065520835248*^9}, 
   3.465123415797257*^9, 3.4651234655480556`*^9, 3.465126218969634*^9, 
   3.4863923448397207`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"CholeskyDecomposition", "[", "AA", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"U", "//", "InputForm"}], "\[IndentingNewLine]", 
 RowBox[{"U", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.4651234923072033`*^9, 3.465123506461123*^9}, {
  3.465123564718144*^9, 3.46512356757972*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.6098722765266986`", "0.6405693208478925`", "0.1770418999366983`"},
     {"0.`", "0.09090351333425013`", 
      RowBox[{"-", "0.3589664912436558`"}]},
     {"0.`", "0.`", "0.19357661121640218`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.4651235074495287`*^9, {3.4651235683507967`*^9, 3.465123573971908*^9}, 
   3.465126224641378*^9, 3.486392344933779*^9}],

Cell["\<\
{{0.6098722765266986, 0.6405693208478925, 0.1770418999366983}, {0., \
0.09090351333425013, 
-0.3589664912436558}, {0., 0., 0.19357661121640218}}\
\>", "Output",
 CellChangeTimes->{
  3.4651235074495287`*^9, {3.4651235683507967`*^9, 3.465123573971908*^9}, 
   3.465126224641378*^9, 3.486392344957247*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"AA", ",", "bb"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"s", "//", "InputForm"}]}], "Input",
 CellChangeTimes->{{3.4651235357483892`*^9, 3.465123560612335*^9}, {
  3.46512674192733*^9, 3.4651267711229057`*^9}}],

Cell["\<\
{1.2878697604109028, -0.7727798877778043, -0.5151113342942297}\
\>", "Output",
 CellChangeTimes->{{3.465123553697804*^9, 3.465123561493222*^9}, 
   3.465126296148737*^9, 3.465126745518462*^9, 3.486392345059029*^9}]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"Now", " ", 
    RowBox[{"let", "'"}], "s", " ", "add", " ", "a", " ", "quadratic", " ", 
    "penalty"}], "..."}], "Subsubsection"]], "Input",
 CellChangeTimes->{{3.499103596762151*^9, 3.4991036195628767`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"q", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"1", "/", "2"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "b", "+", "c", "-", "2"}], ")"}], "^", 
    "2"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L1", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Lstar", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "+", 
   RowBox[{"q", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"L1", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "/.", "vals"}], "//", 
  "InputForm"}]}], "Input",
 CellChangeTimes->{{3.4991036267379503`*^9, 3.4991036969849377`*^9}, {
  3.4991037996239557`*^9, 3.499103851326066*^9}, {3.499103897817835*^9, 
  3.499104103758906*^9}}],

Cell["1.3196427075343262", "Output",
 CellChangeTimes->{{3.499103811113962*^9, 3.499103823692149*^9}, 
   3.499103853834239*^9, {3.499104030521552*^9, 3.499104105105275*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"b1gn", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"bgn", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "-", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"q", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], "}"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b1gn", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "/.", "vals"}], "//", 
  "InputForm"}]}], "Input",
 CellChangeTimes->{{3.4991041556763144`*^9, 3.499104156416039*^9}}],

Cell["\<\
{1.7214991729791487, -1.4619624074720623, 1.5748093588574208}\
\>", "Output",
 CellChangeTimes->{3.4991041094915857`*^9, 3.499104165341917*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"H1gn", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Hgn", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "+", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"q", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], "}"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H1gn", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "/.", "vals"}], "//", 
  "InputForm"}]}], "Input",
 CellChangeTimes->{{3.499104181476906*^9, 3.499104205038045*^9}, {
  3.499104594550055*^9, 3.499104618072616*^9}}],

Cell["\<\
{{1.371944193675858, -0.6093345300213344, 1.107972946555006}, 
 {-0.6093345300213344, 1.4185925035480405, -0.9192237056192452}, 
 {1.107972946555006, -0.9192237056192452, 1.1976726805790037}}\
\>", "Output",
 CellChangeTimes->{3.4991046330059958`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["This is a linear model. Therefore the Hessians \
computed later should agree with the Gauss - Newton approximation.", \
"Subsection"]], "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ClearAll", "[", 
  RowBox[{"x", ",", "a", ",", "L"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"noise", "=", 
  RowBox[{"10", "^", 
   RowBox[{"-", "5"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ts", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "/", "10"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "9"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "t_", "]"}], ":=", 
  RowBox[{"t", "-", 
   RowBox[{"t", "^", "2"}], "+", 
   RowBox[{"2", 
    RowBox[{"t", "^", "3"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yos", "=", 
   RowBox[{"MapIndexed", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "i"}], "}"}], ",", 
       RowBox[{
        RowBox[{"f", "[", "t", "]"}], "+", 
        RowBox[{"f", "[", 
         RowBox[{"1", "-", "t"}], "]"}], "+", 
        RowBox[{"f", "[", 
         RowBox[{"-", "t"}], "]"}], "+", 
        RowBox[{"noise", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"First", "[", "i", "]"}], "+", "1"}], ")"}]}]}]}]}], 
      "]"}], ",", "ts"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yc", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", "i", "]"}], "]"}], 
     RowBox[{"t", "^", "i"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"residuals", "[", 
   RowBox[{"x_", ",", "a_"}], "]"}], ":=", 
  RowBox[{"MapThread", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t", ",", "yo"}], "}"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"yo", "-", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"[", "1", "]"}], "]"}], " ", 
          RowBox[{"yc", "[", 
           RowBox[{"x", ",", "t"}], "]"}]}], "-", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"[", "2", "]"}], "]"}], " ", 
          RowBox[{"yc", "[", 
           RowBox[{"x", ",", 
            RowBox[{"1", "-", "t"}]}], "]"}]}], "-", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"[", "3", "]"}], "]"}], " ", 
          RowBox[{"yc", "[", 
           RowBox[{"x", ",", 
            RowBox[{"-", "t"}]}], "]"}]}]}], ")"}], "^", "2"}]}], "]"}], ",", 
    
    RowBox[{"{", 
     RowBox[{"ts", ",", "yos"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "[", 
   RowBox[{"x_", ",", "a_"}], "]"}], ":=", 
  RowBox[{"Plus", "@@", 
   RowBox[{"residuals", "[", 
    RowBox[{"x", ",", "a"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"xx", "=", 
  RowBox[{"{", 
   RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4"}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"aa", "=", 
  RowBox[{"{", 
   RowBox[{"a1", ",", "a2", ",", "a3"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"L", "[", 
    RowBox[{"xx", ",", "aa"}], "]"}], "//", "Simplify"}], ";"}]}], "Input",
 CellChangeTimes->{{3.453545827950409*^9, 3.453545871339635*^9}, {
   3.453545944212686*^9, 3.4535460904176292`*^9}, {3.453546169861903*^9, 
   3.45354652364076*^9}, {3.453546760470612*^9, 3.453546802741297*^9}, {
   3.453546847194674*^9, 3.453546902465476*^9}, {3.453546959491557*^9, 
   3.45354696341579*^9}, {3.453547104356781*^9, 3.453547127116691*^9}, {
   3.4535472688314543`*^9, 3.453547271066773*^9}, {3.453547397081917*^9, 
   3.4535474607672567`*^9}, 3.453548674410898*^9, {3.4536356852178173`*^9, 
   3.4536357028686323`*^9}, {3.4536359659063396`*^9, 
   3.4536359881056643`*^9}, {3.453698957307619*^9, 3.453699014043758*^9}, {
   3.45369909669751*^9, 3.453699248983328*^9}, {3.453699285234579*^9, 
   3.453699464958539*^9}, {3.4536995261605263`*^9, 3.4536995535221777`*^9}, {
   3.453699873186549*^9, 3.4536999241471*^9}, {3.4536999556883793`*^9, 
   3.453699981746502*^9}, {3.454238713989191*^9, 3.454238714524435*^9}, {
   3.4544874298932*^9, 3.4544874306530247`*^9}}],

Cell[BoxData[
 FractionBox["1", "100000"]], "Output",
 CellChangeTimes->{{3.453699977933587*^9, 3.453699982615786*^9}, {
   3.4542386725694103`*^9, 3.454238715835148*^9}, 3.454487346542604*^9, 
   3.4544874320105457`*^9, 3.4863923464327383`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4"}], "}"}]], "Output",
 CellChangeTimes->{{3.453699977933587*^9, 3.453699982615786*^9}, {
   3.4542386725694103`*^9, 3.454238715835148*^9}, 3.454487346542604*^9, 
   3.4544874320105457`*^9, 3.4863923464615297`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a1", ",", "a2", ",", "a3"}], "}"}]], "Output",
 CellChangeTimes->{{3.453699977933587*^9, 3.453699982615786*^9}, {
   3.4542386725694103`*^9, 3.454238715835148*^9}, 3.454487346542604*^9, 
   3.4544874320105457`*^9, 3.4863923465065527`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vals", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x1", "\[Rule]", "1"}], ",", 
    RowBox[{"x2", "\[Rule]", "2"}], ",", 
    RowBox[{"x3", "\[Rule]", "3"}], ",", 
    RowBox[{"x4", "\[Rule]", "4"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.45354654047404*^9, 3.453546558163372*^9}, {
  3.45354699698342*^9, 3.4535469976016483`*^9}, {3.4536995860042963`*^9, 
  3.453699591839527*^9}, {3.453699998437311*^9, 3.453700007278576*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x1", "\[Rule]", "1"}], ",", 
   RowBox[{"x2", "\[Rule]", "2"}], ",", 
   RowBox[{"x3", "\[Rule]", "3"}], ",", 
   RowBox[{"x4", "\[Rule]", "4"}]}], "}"}]], "Output",
 CellChangeTimes->{3.454487446077423*^9, 3.4863923467069187`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ClearAll", "[", 
  RowBox[{"AA", ",", "bb"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Yc", "[", "x_", "]"}], ":=", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{"t", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"yc", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", 
        RowBox[{"yc", "[", 
         RowBox[{"x", ",", 
          RowBox[{"1", "-", "t"}]}], "]"}], ",", 
        RowBox[{"yc", "[", 
         RowBox[{"x", ",", 
          RowBox[{"-", "t"}]}], "]"}]}], "}"}]}], "]"}], ",", "ts"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AA", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Yc", "[", "xx", "]"}], "\[Transpose]"}], ".", 
    RowBox[{"Yc", "[", "xx", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bb", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Yc", "[", "xx", "]"}], "\[Transpose]"}], ".", "yos"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"AA", "/.", "vals"}], ",", "15"}], "]"}], "//", 
  "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"bb", "/.", "vals"}], ",", "15"}], "]"}], "//", 
  "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"astar", "=", 
   RowBox[{
    RowBox[{"LinearSolve", "[", 
     RowBox[{"AA", ",", "bb"}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"CholeskyDecomposition", "[", "AA", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"astar", "/.", "vals"}], ",", "15"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"astarrule", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a1", "\[Rule]", 
      RowBox[{"astar", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ",", 
     RowBox[{"a2", "\[Rule]", 
      RowBox[{"astar", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ",", 
     RowBox[{"a3", "\[Rule]", 
      RowBox[{"astar", "[", 
       RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"L", "[", 
        RowBox[{"xx", ",", "aa"}], "]"}], ",", "a1"}], "]"}], ",", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"L", "[", 
        RowBox[{"xx", ",", "aa"}], "]"}], ",", "a2"}], "]"}], ",", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"L", "[", 
        RowBox[{"xx", ",", "aa"}], "]"}], ",", "a3"}], "]"}]}], "}"}], "/.", 
   "astarrule"}], "/.", "vals"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.453546574429196*^9, 3.453546647274122*^9}, {
   3.453546813649713*^9, 3.453546817149027*^9}, {3.453547001827058*^9, 
   3.453547015124682*^9}, 3.453547182075713*^9, {3.453547301839652*^9, 
   3.453547303624569*^9}, 3.453547336051469*^9, {3.4535474757656116`*^9, 
   3.453547561901223*^9}, {3.45354764390154*^9, 3.4535476989636908`*^9}, {
   3.453547731228484*^9, 3.453547820617856*^9}, {3.4535478915925837`*^9, 
   3.453547908439589*^9}, {3.453547938530057*^9, 3.453548140830576*^9}, {
   3.4535487890858593`*^9, 3.453548834008988*^9}, {3.453548869446924*^9, 
   3.4535489220598288`*^9}, {3.453549026811969*^9, 3.453549029797245*^9}, {
   3.453632993669001*^9, 3.4536331007304697`*^9}, {3.4536996094348*^9, 
   3.453699833132066*^9}, {3.453700021397932*^9, 3.453700084844948*^9}, {
   3.453700137683445*^9, 3.453700204997356*^9}, {3.453701760865938*^9, 
   3.453701763376382*^9}, {3.454238968836652*^9, 3.4542389770251617`*^9}, {
   3.454239129237*^9, 3.45423915118574*^9}, {3.4545805611717157`*^9, 
   3.454580611868085*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"105.13815828`14.999999999999996", "17.11119828`14.999999999999996", 
      "11.76924828`15.000000000000004"},
     {"17.11119828`14.999999999999996", "205.13815828`15.000000000000004", 
      RowBox[{"-", "2.13275172`14.999999999999996"}]},
     {"11.76924828`15.000000000000004", 
      RowBox[{"-", "2.13275172`14.999999999999996"}], 
      "1.82211828`14.999999999999996"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.453546703690188*^9, 3.4535468335133677`*^9, 3.4535470233461933`*^9, 
   3.453547264297694*^9, 3.453547323998046*^9, 3.453547700617062*^9, 
   3.4535477355437727`*^9, {3.453547813595783*^9, 3.453547822157159*^9}, {
   3.453547893947351*^9, 3.4535479096906843`*^9}, {3.453547960210923*^9, 
   3.453547989355603*^9}, {3.453548077268029*^9, 3.453548081387787*^9}, {
   3.453548111663156*^9, 3.4535481428517237`*^9}, 3.4535488961402807`*^9, {
   3.453548997572557*^9, 3.45354903128601*^9}, {3.453633030113673*^9, 
   3.453633101808145*^9}, 3.45369983635499*^9, 3.453700093232979*^9, 
   3.453700146023456*^9, {3.453700176984374*^9, 3.4537002066272917`*^9}, 
   3.453701764980631*^9, 3.454238723383972*^9, {3.4542389711898937`*^9, 
   3.4542389784022837`*^9}, 3.454239152742811*^9, 3.4544873962357893`*^9, 
   3.454487448391451*^9, 3.454580587125313*^9, 3.4545806282096024`*^9, 
   3.486392346811122*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"-", "19.19260277`15.000000000000004"}]},
      {"39.19261723`15.000000000000004"},
      {
       RowBox[{"-", "3.01800727`14.999999999999996"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.453546703690188*^9, 3.4535468335133677`*^9, 3.4535470233461933`*^9, 
   3.453547264297694*^9, 3.453547323998046*^9, 3.453547700617062*^9, 
   3.4535477355437727`*^9, {3.453547813595783*^9, 3.453547822157159*^9}, {
   3.453547893947351*^9, 3.4535479096906843`*^9}, {3.453547960210923*^9, 
   3.453547989355603*^9}, {3.453548077268029*^9, 3.453548081387787*^9}, {
   3.453548111663156*^9, 3.4535481428517237`*^9}, 3.4535488961402807`*^9, {
   3.453548997572557*^9, 3.45354903128601*^9}, {3.453633030113673*^9, 
   3.453633101808145*^9}, 3.45369983635499*^9, 3.453700093232979*^9, 
   3.453700146023456*^9, {3.453700176984374*^9, 3.4537002066272917`*^9}, 
   3.453701764980631*^9, 3.454238723383972*^9, {3.4542389711898937`*^9, 
   3.4542389784022837`*^9}, 3.454239152742811*^9, 3.4544873962357893`*^9, 
   3.454487448391451*^9, 3.454580587125313*^9, 3.4545806282096024`*^9, 
   3.4863923468474197`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.2103236698335254737630057040497571391`15."}], ",", 
   "0.20803376425290701363445844265742602012`14.999999999999996", ",", 
   RowBox[{"-", "0.05431667808087106356762157895483055087`15."}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.453546703690188*^9, 3.4535468335133677`*^9, 3.4535470233461933`*^9, 
   3.453547264297694*^9, 3.453547323998046*^9, 3.453547700617062*^9, 
   3.4535477355437727`*^9, {3.453547813595783*^9, 3.453547822157159*^9}, {
   3.453547893947351*^9, 3.4535479096906843`*^9}, {3.453547960210923*^9, 
   3.453547989355603*^9}, {3.453548077268029*^9, 3.453548081387787*^9}, {
   3.453548111663156*^9, 3.4535481428517237`*^9}, 3.4535488961402807`*^9, {
   3.453548997572557*^9, 3.45354903128601*^9}, {3.453633030113673*^9, 
   3.453633101808145*^9}, 3.45369983635499*^9, 3.453700093232979*^9, 
   3.453700146023456*^9, {3.453700176984374*^9, 3.4537002066272917`*^9}, 
   3.453701764980631*^9, 3.454238723383972*^9, {3.4542389711898937`*^9, 
   3.4542389784022837`*^9}, 3.454239152742811*^9, 3.4544873962357893`*^9, 
   3.454487448391451*^9, 3.454580587125313*^9, 3.4545806282096024`*^9, 
   3.4863923483024*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.453546703690188*^9, 3.4535468335133677`*^9, 3.4535470233461933`*^9, 
   3.453547264297694*^9, 3.453547323998046*^9, 3.453547700617062*^9, 
   3.4535477355437727`*^9, {3.453547813595783*^9, 3.453547822157159*^9}, {
   3.453547893947351*^9, 3.4535479096906843`*^9}, {3.453547960210923*^9, 
   3.453547989355603*^9}, {3.453548077268029*^9, 3.453548081387787*^9}, {
   3.453548111663156*^9, 3.4535481428517237`*^9}, 3.4535488961402807`*^9, {
   3.453548997572557*^9, 3.45354903128601*^9}, {3.453633030113673*^9, 
   3.453633101808145*^9}, 3.45369983635499*^9, 3.453700093232979*^9, 
   3.453700146023456*^9, {3.453700176984374*^9, 3.4537002066272917`*^9}, 
   3.453701764980631*^9, 3.454238723383972*^9, {3.4542389711898937`*^9, 
   3.4542389784022837`*^9}, 3.454239152742811*^9, 3.4544873962357893`*^9, 
   3.454487448391451*^9, 3.454580587125313*^9, 3.4545806282096024`*^9, 
   3.486392348342183*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Hs", "=", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"L", "[", 
            RowBox[{"xx", ",", "aa"}], "]"}], "/.", "astarrule"}], ",", "u", 
          ",", "v"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"u", ",", 
          RowBox[{"{", 
           RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4"}], "}"}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", 
          RowBox[{"{", 
           RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4"}], "}"}]}], "}"}]}], 
       "]"}], "/.", "vals"}], ",", "15"}], "]"}], "/", 
   "2"}]}], "\[IndentingNewLine]", 
 RowBox[{"Hs", "//", "MatrixForm"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.454238981355742*^9, 3.4542391249330273`*^9}, {
  3.454239160067216*^9, 3.454239186845043*^9}, {3.454239223860325*^9, 
  3.4542392254461403`*^9}, {3.454239363172694*^9, 3.4542395688779287`*^9}, {
  3.454240158483385*^9, 3.4542401594824743`*^9}, {3.4542403743532753`*^9, 
  3.4542404256254683`*^9}, {3.454581344604982*^9, 3.454581346190488*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.00300136362055690597085339824812733631`14.999999999999996", ",", 
     "0.00227988574887291991263388491211430372`14.999999999999996", ",", 
     "0.00052035616983586886104756304546020371`14.999999999999996", ",", 
     RowBox[{
     "-", "0.00092418988375792518201080596219832102`14.999999999999996"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.00227988574887291991263388491211430372`14.999999999999996", ",", 
     "0.00222887407045410720564358511837726994`14.999999999999996", ",", 
     "0.00062528321652818462661292934755311924`14.999999999999996", ",", 
     RowBox[{
     "-", "0.00080356169817410886317781186272481797`14.999999999999996"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.00052035616983586886104756304546020371`14.999999999999996", ",", 
     "0.00062528321652818462661292934755311924`14.999999999999996", ",", 
     "0.00007430954904712438769862123738494021`14.999999999999996", ",", 
     RowBox[{
     "-", "0.0004168962893953135274455555184931139`14.999999999999996"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
     "-", "0.00092418988375792518201080596219832102`14.999999999999996"}], 
     ",", 
     RowBox[{
     "-", "0.00080356169817410886317781186272481797`14.999999999999996"}], 
     ",", 
     RowBox[{
     "-", "0.0004168962893953135274455555184931139`14.999999999999996"}], ",",
      
     RowBox[{
     "-", "0.0001296692043941184183291643753086473`14.999999999999996"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.454239189036285*^9, 3.454239232586947*^9, {3.454239380975555*^9, 
   3.454239420260501*^9}, {3.454239453690591*^9, 3.454239497263447*^9}, {
   3.4542395479267197`*^9, 3.4542395732042627`*^9}, 3.454240164028632*^9, 
   3.4542404299337482`*^9, 3.4545813731233997`*^9, 3.486392353395789*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.00300136362055690597085339824812733631`14.999999999999996", 
      "0.00227988574887291991263388491211430372`14.999999999999996", 
      "0.00052035616983586886104756304546020371`14.999999999999996", 
      RowBox[{
      "-", "0.00092418988375792518201080596219832102`14.999999999999996"}]},
     {"0.00227988574887291991263388491211430372`14.999999999999996", 
      "0.00222887407045410720564358511837726994`14.999999999999996", 
      "0.00062528321652818462661292934755311924`14.999999999999996", 
      RowBox[{
      "-", "0.00080356169817410886317781186272481797`14.999999999999996"}]},
     {"0.00052035616983586886104756304546020371`14.999999999999996", 
      "0.00062528321652818462661292934755311924`14.999999999999996", 
      "0.00007430954904712438769862123738494021`14.999999999999996", 
      RowBox[{
      "-", "0.0004168962893953135274455555184931139`14.999999999999996"}]},
     {
      RowBox[{
      "-", "0.00092418988375792518201080596219832102`14.999999999999996"}], 
      RowBox[{
      "-", "0.00080356169817410886317781186272481797`14.999999999999996"}], 
      RowBox[{
      "-", "0.0004168962893953135274455555184931139`14.999999999999996"}], 
      RowBox[{
      "-", "0.0001296692043941184183291643753086473`14.999999999999996"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.454239189036285*^9, 3.454239232586947*^9, {3.454239380975555*^9, 
   3.454239420260501*^9}, {3.454239453690591*^9, 3.454239497263447*^9}, {
   3.4542395479267197`*^9, 3.4542395732042627`*^9}, 3.454240164028632*^9, 
   3.4542404299337482`*^9, 3.4545813731233997`*^9, 3.486392353429566*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"L", "[", 
             RowBox[{"xx", ",", "aa"}], "]"}], "/.", "astarrule"}], ",", 
           "u"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"u", ",", 
           RowBox[{"{", 
            RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4"}], "}"}]}], "}"}]}],
         "]"}], "/.", "vals"}], ",", "15"}], "]"}]}], "/", "2"}]}]], "Input",
 CellChangeTimes->{{3.4542406631543827`*^9, 3.454240705251038*^9}, {
  3.454580968440674*^9, 3.45458098297834*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00542544409277865165122063335994327078`15.", ",", 
   "0.00539923674666925275104859574062892943`15.000000000000004", ",", 
   "0.00032626609245235716758706337874880724`15.", ",", 
   RowBox[{
   "-", "0.00430067896586855716401975374436188784`15.000000000000004"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.4542407090168753`*^9, {3.454580970736146*^9, 3.454580984417369*^9}, 
   3.486392353825384*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"index", "[", 
   RowBox[{"i_", ",", "j_", ",", "n_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"i", "-", "1"}], ")"}], "n"}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"i", "-", "1"}], ")"}], 
    RowBox[{"i", "/", "2"}]}], "+", "j"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PackedUAsMat", "[", 
   RowBox[{"u_", ",", "i_", ",", "j_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"i", ">", "j"}], ",", 
    RowBox[{"u", "[", 
     RowBox[{"[", 
      RowBox[{"index", "[", 
       RowBox[{"j", ",", "i", ",", "n"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"u", "[", 
     RowBox[{"[", 
      RowBox[{"index", "[", 
       RowBox[{"i", ",", "j", ",", "n"}], "]"}], "]"}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SymmetricMatrixFromUpperDiagonal", "[", "u_", "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", "n", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "+", 
           RowBox[{"8", 
            RowBox[{"Length", "[", "u", "]"}]}]}], "]"}], "-", "1"}], ")"}], 
       "/", "2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"PackedUAsMat", "[", 
        RowBox[{"u", ",", "i", ",", "j", ",", "n"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"1", "n"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "n"}], "}"}]}], "]"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.454086107674911*^9, 3.4540861229994097`*^9}}]
}, Open  ]]
},
WindowToolbars->{},
WindowSize->{808, 917},
WindowMargins->{{184, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[423, 14, 230, 3, 45, "Text"],
Cell[656, 19, 3412, 87, 103, "Input"],
Cell[CellGroupData[{
Cell[4093, 110, 364, 9, 27, "Input"],
Cell[4460, 121, 533, 10, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5030, 136, 1173, 33, 43, "Input"],
Cell[6206, 171, 917, 23, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7160, 199, 670, 21, 43, "Input"],
Cell[7833, 222, 887, 28, 33, "Output"]
}, Open  ]],
Cell[8735, 253, 2962, 82, 133, "Input"],
Cell[CellGroupData[{
Cell[11722, 339, 273, 7, 27, "Input"],
Cell[11998, 348, 267, 4, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12302, 357, 446, 10, 27, "Input"],
Cell[12751, 369, 271, 4, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13059, 378, 848, 16, 58, "Input"],
Cell[13910, 396, 1443, 28, 73, "Output"],
Cell[15356, 426, 877, 13, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16270, 444, 468, 11, 43, "Input"],
Cell[16741, 457, 429, 8, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17207, 470, 477, 10, 58, "Input"],
Cell[17687, 482, 335, 8, 27, "Output"],
Cell[18025, 492, 1059, 26, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19121, 523, 357, 8, 58, "Input"],
Cell[19481, 533, 896, 22, 61, "Output"],
Cell[20380, 557, 313, 7, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20730, 569, 312, 7, 43, "Input"],
Cell[21045, 578, 224, 4, 27, "Output"]
}, Open  ]],
Cell[21284, 585, 258, 6, 28, "Input"],
Cell[CellGroupData[{
Cell[21567, 595, 855, 25, 58, "Input"],
Cell[22425, 622, 174, 2, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22636, 629, 651, 20, 43, "Input"],
Cell[23290, 651, 153, 3, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23480, 659, 799, 24, 43, "Input"],
Cell[24282, 685, 261, 5, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24580, 695, 174, 2, 39, "Subsubtitle"],
Cell[CellGroupData[{
Cell[24779, 701, 4167, 115, 208, "Input"],
Cell[28949, 818, 245, 4, 45, "Output"],
Cell[29197, 824, 289, 5, 27, "Output"],
Cell[29489, 831, 278, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29804, 841, 459, 10, 27, "Input"],
Cell[30266, 853, 283, 7, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30586, 865, 3680, 101, 193, "Input"],
Cell[34269, 968, 1856, 36, 61, "Output"],
Cell[36128, 1006, 1695, 36, 61, "Output"],
Cell[37826, 1044, 1192, 20, 27, "Output"],
Cell[39021, 1066, 1006, 16, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40064, 1087, 1194, 30, 73, "Input"],
Cell[41261, 1119, 1885, 45, 73, "Output"],
Cell[43149, 1166, 2140, 44, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45326, 1215, 713, 21, 27, "Input"],
Cell[46042, 1238, 451, 11, 27, "Output"]
}, Open  ]],
Cell[46508, 1252, 1715, 52, 88, "Input"]
}, Open  ]]
}
]
*)

