DACS_NOTICES(8)            DACS Web Services Manual            DACS_NOTICES(8)



[1mNAME[0m
       dacs_notices - [1mDACS [22mnotice presentation and acknowledgement handler

[1mSYNOPSIS[0m
       [1mdacs_notices [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This web service is part of the [1mDACS [22msuite.

       Some web service providers have a requirement that users must
       acknowledge a notice of some sort before access can be granted to an
       associated resource. A user attempting to access such a resource is
       shown a web page containing the notice and asked to acknowledge it or
       accept its conditions, typically by pressing an "I Accept" button on
       the web page. These notices are commonly legal notices, such as
       copyright notices, licensing notices, restricted access notices, and
       terms-of-use notices. This can also be applied to alert users to news
       (a warning about upcoming system maintenance, for example).

       [34m[1mdacs_acs(8)[0m[1m[22m[2] (the [1mDACS [22maccess control service, or [1mACS[22m) can be
       configured to invoke [1mdacs_notices [22mwhen access control processing
       determines that one or more notices have not been acknowledged.
       [1mdacs_notices [22macts as both a generic notice presentation handler (it
       retrieves notices, presents them to the user, and requests the user to
       acknowledge the notices) and a matching notice acknowledgement handler
       (executed to process the user's response and take appropriate action).
       The presentation aspect of the program can be customized. It takes
       steps to defeat attempts to bypass notice presentation.

       In the [1mDACS [22mimplementation, a notice (N) is usually some text,
       identified by a URL. A notice is associated with one or more resources
       (R) such that an attempt to access any of these resources requires the
       user to first explicitly acknowledge the textual material. A [1mDACS [22mevent
       handler (H) is responsible for presenting the notice to the user. The
       basic flow of control is roughly as follows:

                   USER                  |  Apache/DACS

             a)    --- Request for R --->|---> (DACS Access Control Service)
             b)    <--- Redirect to H ---|<--

             c)    --- Request for H --->|---> (a notice presentation handler)
             d)        <--- Return N ----|<---

             e)     --- Submit Ack N --->|-->  (a notice acknowledgement handler)
             f)    <--- Redirect to R ---|<--

             g)    --- Request for R --->|---> (DACS access control service)
             h)                <--- R ---|<--

       More than one notice can be associated with a resource, in which case
       they are effectively concatenated for presentation purposes and
       collectively acknowledged (so N may be N1, N2, ..., Nn and Ack N
       acknowledges all of them).

       Having already acknowledged N in a session, a user should not need to
       do so again.  [1mdacs_notices [22muses a purely client-side approach; cookies
       are issued to remember that resources have been acknowledged. These
       cookies are called notice acknowledgement tokens or NATs. The
       implementation handles both authenticated and unauthenticated
       (anonymous) users. The cookie name consists of a prefix, the federation
       name, the jurisdiction name, and a unique component; see
       [34m[1mdacs.conf(5)[0m[1m[22m[3] for a description of configuration directives used by
       this program, including the [34m[1mNOTICES_NAT_NAME_PREFIX[0m[1m[22m[4] directive.

       The program accepts the standard [4mFORMAT[24m argument (see [34m[1mdacs(1)[0m[1m[22m[5]) to
       select between generation of an HTML presentation page intended for
       display by a browser (the default) or XML output intended for
       middleware. Output customization applies only to the former. When
       generating HTML output, [1mdacs_notices [22memits instructions, the content of
       the notices, and an HTML form by which the user submits a response.

           [1mNote[0m
           Of course, apart from answering a skill-testing question or the
           like, there's no way of knowing that a user has actually read and
           understood the notices. It is unclear to what extent it is
           necessary to go in this regard with respect to providing support.
           [1mDACS [22mcannot guarantee that a human user has actually read these
           notices and indicated acceptance of them, but it can guarantee
           (optionally, using [34m[1msecure mode[0m[1m[22m[6]) that a NAT cannot be obtained by
           a client without the client having received a copy of the notices.
           If the client wants to "trick the system" by not actually
           presenting the notices to the user or soliciting a response it can,
           and in this event the service provider might consider legal
           recourse.

       In future versions of [1mDACS[22m, the idea of notice/acknowledgement
       processing may be generalized so that an arbitrary condition can be
       tested for by access control rules, remembered through client-side
       state (for example), and made available via a seamless workflow.

   [1mOperation[0m
       Configuring notice acknowledgement processing involves:

       +o   Configuring an [34m[1mACS_ERROR_HANDLER[0m[1m[22m[7] directive to catch ACK_NEEDED
           (error code 905) events and invoke [1mdacs_notices[22m;

       +o   Calling the [34m[1mack[0m[1m[22m[8] predicate from an access control rule to specify
           the notices that must be acknowledged; and

       +o   Configuring [1mdacs_notices[22m.


       The following configuration directives are examined by [1mdacs_notices[22m.
       All of these directives are optional. Refer to the individual
       directives for additional details.

       +o    [34m[1mNOTICES_ACK_HANDLER[0m[1m[22m[9]: the URL of the notice acknowledgement
           handler, if not [1mdacs_notices[22m.

       +o    [34m[1mNOTICES_ACCEPT_HANDLER[0m[1m[22m[10]: the URL (absolute or relative) to
           which a user agent will be redirected after a positive
           acknowledgement to a notice has been received (i.e., the notice or
           notices were "accepted"), if it is not possible to redirect the
           user agent to the request that initiated notice acknowledgement
           processing (e.g., if that request used the POST method).

       +o    [34m[1mNOTICES_DECLINE_HANDLER[0m[1m[22m[11]: the URL (absolute or relative) to
           which a user agent will be redirected after a negative
           acknowledgement to a notice has been received (i.e., the notice or
           notices were "declined").


           [1mNote[0m
           When determining whether a resource has already been acknowledged,
           the query component of a resource URI is not considered.

       When emitting HTML, the web page generated by [1mdacs_notices [22mcan be
       customized through the notices VFS item type. The following items are
       emitted if they exist:

       +o   header: Initial HTML to emit.

       +o   prologue: HTML to emit immediately after the header.

       +o   instructions: HTML to emit immediately after the prologue and
           before the notices.

       +o   epilogue: HTML to emit immediately after the form that follows the
           notices.

       +o   trailer: Final HTML to emit.

       For example, given the configuration directives:

           VFS "[notices]dacs-fs:${Conf::DACS_HOME}/notices"

       files named header and trailer in the directory
       ${Conf::DACS_HOME}/notices would be expected to contain the initial and
       final HTML content, respectively. Note that these consist of text and
       HTML markup but are not complete HTML documents.

       Customization of the form is possible using configuration variables:

       +o   [4mnotices_prompt_text[24m: This label appears immediately before the HTML
           form. The default is something like "Your response to the preceding
           notices is requested:<p>".

       +o   [4mnotices_accept_label[24m: This label appears next to the radio button
           corresponding to the "accepted" response. The default is something
           like "I Accept".

       +o   [4mnotices_decline_label[24m: This label appears next to the radio button
           corresponding to the "declined" response. The default is something
           like "I Decline".

       +o   [4mnotices_submit_label[24m: This label appears in the submit button. The
           default is something like "Send".

       Here are some examples of how these variables might be set to customize
       the form:

           EVAL ${Conf::notices_prompt_text} = "My &lt;b&gt;custom&lt;/b&gt; prompt:"
           EVAL ${Conf::notices_accept_label} = "I really do accept&lt;br&gt;"
           EVAL ${Conf::notices_submit_label} = "Submit me!"


   [1mWeb Service Arguments[0m
       In addition to the [34m[1mstandard CGI arguments[0m[1m[22m[12], [1mdacs_notices [22munderstands
       the following CGI arguments:

       [4mACCEPT_LABEL[0m
           The value of this optional parameter is used by the notice
           presentation handler and overrides the value of the
           [4m${Conf::notices_accept_label}[24m variable, if any.

       [4mDECLINE_LABEL[0m
           The value of this optional parameter is used by the notice
           presentation handler and overrides the value of the
           [4m${Conf::notices_decline_label}[24m variable, if any.

       [4mHMAC[0m
           This value is a secure keyed hash. It is computed by [1mdacs_acs [22mfor
           use by the notice presentation handler. A hash is also computed
           (over different material) by the presentation handler and passed to
           the notice acknowledgement handler with the user's response and
           other information. Its purpose is to make it difficult to obtain a
           notice acknowledgement token directly by side-stepping notice
           acknowledgement processing. The federation-wide HMAC key is used.
           Please refer to the description of [34m[1mSecure Mode[0m[1m[22m[6].

           Neither this argument nor the [34m[1mTIME[0m[1m[22m[13] argument are used or
           required if the [34m[1mNOTICES_SECURE_HANDLER[0m[1m[22m[14] configuration directive
           has the value "no".

       [4mNOTICE_URIS[0m
           The value of this argument is a space-separated list of URIs, each
           of which is invoked using the GET method and is expected to return
           a notice document.

               [1mNote[0m
               The notices are expected to be fragments of HTML text, not
               complete HTML documents; each notice is "pasted" into the
               presentation page exactly as obtained from its URI.

       [4mTIME[0m
           This is the Unix time at which [1mdacs_acs [22minvoked the notice
           presentation handler for this workflow. It is used to limit the
           lifetime of the workflow so that it cannot easily be rerun to
           obtain notice acknowledgement tokens at will.

       [4mRESOURCE_URIS[0m
           The value of this argument is a space-separated list of URIs, each
           of which is associated with the notice(s).

       [4mRESPONSE[0m
           Passed to the notice acknowledgement handler, this argument is the
           user's response and must either be accepted or declined.

   [1mMiddleware Support[0m
       [1mdacs_notices [22mcan be asked to emit various flavours of XML in support of
       middleware or thick clients. This is useful when middleware would
       prefer to prompt the user itself (acting as a notice presentation
       handler) and then invoke a acknowledgement handler (such as
       [1mdacs_notices[22m) to obtain a NAT. Any customizations specified for HTML
       output are ignored when XML is being produced and are not passed to
       middleware.

       The XML emitted by [1mdacs_notices [22mconforms to the DTD
       [34m[1mdacs_notices.dtd[0m[1m[22m[15]. When acting as a notice presentation handler, it
       returns a presentation_reply element and when acting as a notice
       acknowledgement handler, it returns a ack_reply element; in either mode
       of operation an error reply is possible (via the common_status
       element).

       In conjunction with [34m[1mdacs_acs(8)[0m[1m[22m[2], [1mdacs_notices [22mcan optionally operate
       in a "secure" mode, where a particular control flow is enforced.

       The simple (non-secure) mode will be described first.

       [1mSimple Mode[0m
           The presentation_reply element lists one or more notices that must
           be acknowledged by the user. It includes a space-separated list of
           the URIs of the notices and a space-separated list of the URIs of
           resources that require these notices to be acknowledged. The text
           of the notices are base-64 encoded within the notice element, as
           specified by [34m[1mRFC 2045[0m[1m[22m[16] (Section 6.8). The notice's URI is
           included as an attribute.

           The ack_reply element returns the user's response and, optionally,
           a URI to which the user can be redirected (depending on the
           context, this may be the URI of the request that required notices
           to be acknowledged, the value of the [34m[1mNOTICES_ACCEPT_HANDLER[0m[1m[22m[10]
           directive, or the value of the [34m[1mNOTICES_DECLINE_HANDLER[0m[1m[22m[11]
           directive). If a NAT is issued, it is returned (as an HTTP cookie)
           by the notice presentation handler.

       [1mSecure Mode[0m
           The secure mode of operation, which may not be necessary in some
           environments, serves two main purposes:

            1. a NAT can be cryptographically protected against forgery and
               alteration. Refer to [34m[1mdacs.nat(5)[0m[1m[22m[17].

            2. [1mDACS [22mcan enforce a flow of control so that a client cannot
               obtain a NAT without having received a copy of the notice(s);
               this is the purpose of the hmac and time attributes. That is,
               [1mDACS [22mcan make it necessary for the client to first call
               [34m[1mdacs_acs(8)[0m[1m[22m[2] with [4m-check_only[24m or [4m-check_fail[24m, then call the
               notice presentation handler to get the text of the notices, and
               then call the notice acknowledgement handler to request the
               NAT. No other control flow is possible (ignoring errors).

           When combined, these protections make it difficult for an attacker
           or unfriendly user to bypass having to acknowledge notices by
           manufacturing NATs or having [1mDACS [22msimply issue arbitrary NATs.

           The value of the [34m[1mNOTICES_SECURE_HANDLER[0m[1m[22m[14] configuration directive
           determines whether the secure mode is disabled; it is enabled by
           default (see [34m[1mdacs.conf(5)[0m[1m[22m[3]).

           In secure mode, the total duration of the work flow is limited to
           120 seconds by default. This limit can be set using the
           [34m[1mNOTICES_WORKFLOW_LIFETIME_SECS[0m[1m[22m[18] directive.

           Regardless of the selected output format, the required flow of
           control is:

            1. [1mdacs_acs [22mreceives a service request

               Access to the requested resource will not be granted by
               [34m[1mdacs_acs(8)[0m[1m[22m[2] until one or more notices have been acknowledged
               by the user.  [1mdacs_acs [22meither redirects the client to the
               notice presentation handler or returns an XML document
               ([34m[1mdacs_acs.dtd[0m[1m[22m[19]) that describes which notices must be
               displayed and acknowledged; the behaviour depends on the
               service request. The notice presentation handler must be
               invoked and will expect to be passed the [34m[1mHMAC[0m[1m[22m[20] and [34m[1mTIME[0m[1m[22m[13]
               arguments.

               Provided they are in the same federation, the notice
               presentation handler may be in a different jurisdiction from
               [1mdacs_acs[22m.

            2. Notice presentation handler is invoked

               The user is expected to be presented with the notices and asked
               to accept or decline them. The handler either returns a web
               page containing an HTML form or an XML document
               ([34m[1mdacs_notices.dtd[0m[1m[22m[15]). In either case, the handler will verify
               that [1mdacs_acs [22mhad been called "recently" (the security-related
               arguments expire after a set amount of time and cannot be
               reused). Its output will include [34m[1mHMAC[0m[1m[22m[20] and [34m[1mTIME[0m[1m[22m[13]
               arguments, either of which may differ from the values passed
               into the program; the notice acknowledgement handler expects to
               be passed these arguments.

            3. Notice acknowledgement handler is invoked

               The user's response is directed to the notice acknowledgement
               handler, which verifies that the notice presentation handler
               has been called. The handler either redirects the user
               appropriately or returns an XML document
               ([34m[1mdacs_notices.dtd[0m[1m[22m[15]). If no error has occurred and the user
               has accepted the notices, a NAT will also be returned.


           [1mNote[0m
           In secure mode, presentation handling and acknowledgement handling
           are "matched". If [1mdacs_notices [22mprovides the latter functionality
           but not the former, presentation handling must behave as
           [1mdacs_notices [22mexpects (in its acknowledgement handling mode) with
           respect to security. When secure mode is used with middleware that
           performs its own presentation handling, for example, middleware
           will likely need to invoke [1mdacs_notices [22min its presentation
           handling mode solely to obtain security parameters to pass to
           [1mdacs_notices [22min its acknowledgement handling mode.

           When [1mdacs_notices [22macts as a notice presentation handler, it will
           validate its arguments (which originate from [1mdacs_acs[22m) and emit
           values that may be validated by the notice acknowledgement handler.
           When [1mdacs_notices [22macts as a notice acknowledgement handler, it will
           validate its arguments. Therefore, if the notice acknowledgement
           handler runs in secure mode, the notice presentation handler must
           also run in secure mode.

           The presentation handling mode and the acknowledgement handling
           mode of [1mdacs_notices [22mmust agree on the URL of the acknowledgement
           handler. This means that either the identical URL must be used for
           both modes or both modes must find the NOTICES_ACK_HANDLER
           directive configured to the same value (as when two different
           jurisdictions are involved).

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mBUGS[0m
       A client-side approach is used to note that resources have been
       acknowledged. While this is probably the simplest approach that works
       with both authenticated and unauthenticated users, it does not offer
       much support if one wants acknowledgements by authenticated users to be
       remembered across sessions (i.e., permanently). One possible solution
       is to allow persistent notice acknowledgements to be enabled for
       authenticated users, suppressing NAT cookies and causing a record to be
       written to a configured VFS item type when an authenticated user has
       accepted a notice. The [1mack() [22mpredicate would be extended so that the
       existence of persistent acknowledgement records could be checked, and
       some means of maintaining the persistent records might be added.

       The method used for generation of custom web pages is clunky and should
       be reconsidered.

[1mSEE ALSO[0m
       [34m[1mdacs.nat(5)[0m[1m[22m[17], [34m[1mdacs_acs(8)[0m[1m[22m[2]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[21])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[22] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        3. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        4. NOTICES_NAT_NAME_PREFIX
           http://dacs.dss.ca/man/dacs.conf.5.html#NOTICES_NAT_NAME_PREFIX

        5. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        6. secure mode
           http://dacs.dss.ca/man/#secure_mode

        7. ACS_ERROR_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ERROR_HANDLER

        8. ack
           http://dacs.dss.ca/man/dacs.exprs.5.html#ack

        9. NOTICES_ACK_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#NOTICES_ACK_HANDLER

       10. NOTICES_ACCEPT_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#NOTICES_ACCEPT_HANDLER

       11. NOTICES_DECLINE_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#NOTICES_DECLINE_HANDLER

       12. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

       13. TIME
           http://dacs.dss.ca/man/#TIME

       14. NOTICES_SECURE_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#NOTICES_SECURE_HANDLER

       15. dacs_notices.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_notices.dtd

       16. RFC 2045
           http://www.rfc-editor.org/rfc/rfc2045.txt

       17. dacs.nat(5)
           http://dacs.dss.ca/man/dacs.nat.5.html

       18. NOTICES_WORKFLOW_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#NOTICES_WORKFLOW_LIFETIME_SECS

       19. dacs_acs.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_acs.dtd

       20. HMAC
           http://dacs.dss.ca/man/#HMAC

       21. www.dss.ca
           http://www.dss.ca

       22. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.38a                      11/23/2016                   DACS_NOTICES(8)
