/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "ColorManager.h"

#include <lcms.h>

#include <QByteArray>
#include <QFile>

#include <KComponentData>
#include <KStandardDirs>

struct ColorManager::Private {
  QByteArray sRGBLinearProfile;
  static ColorManager* s_colorManager;
  cmsHTRANSFORM RGB16linearToSRGB16Transform;
  cmsHPROFILE sRGBLcmsProfile;
  cmsHPROFILE sRGBLinearLcmsProfile;
};

ColorManager* ColorManager::Private::s_colorManager = 0;

ColorManager::ColorManager() : d(new Private)
{
  QString ressource = KGlobal::mainComponent().dirs()->findResource("icc_profiles", "darkroom/sRGB_linear.icc");
  QFile ressourceFile( ressource );
  ressourceFile.open( QIODevice::ReadOnly );
  d->sRGBLinearProfile = ressourceFile.readAll();
  d->sRGBLinearLcmsProfile = cmsOpenProfileFromMem((void*)d->sRGBLinearProfile.constData(), (DWORD)d->sRGBLinearProfile.size());
  
  d->sRGBLcmsProfile = cmsCreate_sRGBProfile();
  d->RGB16linearToSRGB16Transform = cmsCreateTransform(
                    d->sRGBLinearLcmsProfile, TYPE_RGB_16,
                    d->sRGBLcmsProfile, TYPE_RGB_16, INTENT_PERCEPTUAL, 0);
}

ColorManager::~ColorManager()
{
  delete d;
}

const QByteArray& ColorManager::sRGBLinearProfile() const
{
  return d->sRGBLinearProfile;
}

void ColorManager::RGB16linearToSRGB16(quint16* src, quint16* dst, int count) const
{
  cmsDoTransform(d->RGB16linearToSRGB16Transform, src, dst, count);
}

const ColorManager* ColorManager::instance()
{
  if( not Private::s_colorManager)
  {
    Private::s_colorManager = new ColorManager;
  }
  return Private::s_colorManager;
}

