// ------------------------------------------------------------------------
//
// SPDX-License-Identifier: LGPL-2.1-or-later
// Copyright (C) 2013 - 2024 by the deal.II authors
//
// This file is part of the deal.II library.
//
// Part of the source code is dual licensed under Apache-2.0 WITH
// LLVM-exception OR LGPL-2.1-or-later. Detailed license information
// governing the source code and code contributions can be found in
// LICENSE.md and CONTRIBUTING.md at the top level directory of deal.II.
//
// ------------------------------------------------------------------------

/**
@page changes_between_8_1_and_8_2 Changes between Version 8.1 and 8.2

<p>
This is the list of changes made between the release of deal.II version
8.1.0 and that of 8.2.0. All entries are signed with the names of the
authors.
</p>



<!-- ----------- INCOMPATIBILITIES ----------------- -->

<a name="810-820-incompatible"></a>
<h3 style="color:red">Incompatibilities</h3>

<p style="color:red">
Following are a few modifications to the library that unfortunately
are incompatible with previous versions of the library, but which we
deem necessary for the future maintainability of the
library. Unfortunately, some of these changes will require
modifications to application programs. We apologize for the
inconvenience this causes.
</p>

<ol>
  <li> Removed: The base class to the iterative linear solvers, Solver,
  received a SolverControl object upon construction and had a member
  function <code>control()</code> that returned a reference to the
  object previously passed in. The class now no longer stores such
  a reference, and consequently, the function has been removed.
  <br>
  (Wolfgang Bangerth, 2014/10/24)
  </li>

  <li> Removed: The constructor of the Utilities::MPI::MPI_InitFinalize
  class used to interpret a last argument equal to numbers::invalid_unsigned_int
  as @"<i>create as many threads as there are processor cores on the current
  system</i>@" for each MPI process. If there were multiple MPI processes on a
  given node, this would lead to (sometimes massive) overallocation of resources
  because <i>every</i> MPI process would create as many threads as there are cores.
  This has now been changed: an argument equal to numbers::invalid_unsigned_int
  is now interpreted as @"<i>subdivide the available cores between all MPI
  processes running on the current system and let each process create as many
  threads as cores were allocated to it</i>@".
  <br>
  (Wolfgang Bangerth, 2014/09/16)
  </li>

  <li> Removed: CMake's configure phase no longer calls back into testsuite
  subprojects. If a build directory is reconfigured the testsuite has to be
  regenerated by hand using <code>make regen_tests</code>.
  <br>
  (Matthias Maier, 2014/07/16)
  </li>

  <li> Removed: Class PointerMatrixBase (and, consequently, the various
  classes derived from it) had comparison operators that were intended to
  work generically for any kind of derived class. However, the implementation
  used a scheme that was not robust enough to handle the various situations
  that derived classes implemented and, consequently, was not always correct.
  These operators were not previously used inside the library and, likely,
  were not widely used in applications either. They have now been removed.
  <br>
  (Wolfgang Bangerth, 2014/02/15)
  </li>

  <li> The change from functionparser to muparser introduced a small number of
  incompatibilities: units, use_degress, and recursion with 'eval' are no
  longer supported. Comparing for equality is done using '==' instead of '='.
  <br>
  (Timo Heister, 2014/02/10)
  </li>

  <li> Changed: The various classes generating graphical output, such
  as DataOut or DataOutStack, are all derived from a common interface
  class DataOutInterface which, in turn was derived from DataOutBase
  through <i>private</i> inheritance. Because we frequently also
  access the (public) members of this private base class this has tripped
  up most every compiler we know of at one point or another. Furthermore,
  because DataOutBase was a class that only defined static member functions
  and had not member variables, there was really no reason for this
  construct.
  <br>
  For these reasons, DataOutBase is now just a regular namespace and the
  inheritance is gone. For the most part, this should not lead to any
  incompatibilities except in cases where you accessed members of
  DataOutBase through their derived classes. For example, it was possible
  to write DataOut::Patch even though the
  Patch class is actually declared in DataOutBase. Since
  the inheritance is now gone, this is no longer possible and one
  actually has to write DataOutBase::Patch instead. Using this form
  turns out to be compatible also with older versions of deal.II.
  <br>
  (Wolfgang Bangerth, 2014/02/01)
  </li>
</ol>


<!-- ----------- GENERAL IMPROVEMENTS ----------------- -->

<a name="810-820-general"></a>
<h3>General</h3>


<ol>
  <li> New: Several parts of the library have been adjusted to allow
  compilation with Microsoft Visual Studio. Unfortunately, not all
  of the library can be compiled yet.
  <br>
  (Lukas Korous, 2014/12/03)
  </li>

  <li> New: Added support for OpenCASCADE (www.opencascade.org)
  library, which allows the use of arbitrary IGES files to describe
  the boundary of a mesh. The use of the new classes is described in
  the new Step-54.
  <br>
  (Luca Heltai, Andrea Mola, 2014/10/31)
  </li>

  <li> New: The classes implementing iterative solvers have gained
  a mechanism by which it is possible to observe the progress of
  the iterations, or to influence when to stop the iteration. The
  documentation of the Solver class now contains an extended
  discussion and example of this functionality.
  <br>
  (Wolfgang Bangerth, 2014/10/24)
  </li>

  <li> New: There is now a section in the introduction of step-36 that
  discusses the interaction of Dirichlet boundary values and the solution
  of eigenvalue problems.
  <br>
  (Denis Davydov, Wolfgang Bangerth, 2014/09/28)
  </li>

  <li> New: The glossary now contains an extensive entry on ghosted and
  non-ghosted vectors (see @ref GlossGhostedVector ).
  <br>
  (Wolfgang Bangerth, 2014/09/27)
  </li>

  <li> New: MappingQ is now aware of
  Manifold, i.e., we can use high order mappings that
  actually follow the geometry also on the interior of codimension
  zero meshes.
  <br>
  (Luca Heltai, 2014/09/13)
  </li>

  <li> New: The new tutorial program step 52 explains how to use the
  new time stepping methods.
  <br>
  (Bruno Turcksin, Damien Lebrun-Grandie, 2014/09/12)
  </li>

  <li> New: The new tutorial program step-53 explains how to deal with
  complicated geometries.
  <br>
  (Wolfgang Bangerth, Luca Heltai, 2014/09/02)
  </li>

  <li> Changed: Namespace std_cxx1x has been renamed to namespace
  std_cxx11 to match the fact that the corresponding C++ standard
  was approved back in 2011. The old namespace name was retained for
  backward compatibility but is now deprecated.
  <br>
  (Wolfgang Bangerth, 2014/09/01)
  </li>

  <li> New: Most of the operations done on Vector (like add, sadd, etc.)
  are now vectorized (SIMD) using OpenMP 4.0.
  <br>
  (Bruno Turcksin, 2014/08/25)
  </li>

  <li> Updated: The version of BOOST that comes bundled with deal.II has
  been updated to 1.56.0.
  <br>
  (Wolfgang Bangerth, 2014/08/19)
  </li>

  <li> Fixed: Newer versions of GCC (e.g. 4.9.x) are no longer compatible
  with BOOST 1.46. Consequently, the CMake scripts now require at least
  BOOST 1.48 in order to use a BOOST version found on the system. If no
  installed BOOST library is found, or if the version is older than 1.48,
  CMake will simply take the one that comes bundled with deal.II.
  <br>
  (Wolfgang Bangerth, 2014/08/19)
  </li>

  <li> New: There is now a documentation module that describes
  deal.II's support for and interaction with the
  @ref CPP11 "C++11 standard".
  <br>
  (Wolfgang Bangerth, 2014/08/14)
  </li>

  <li> New: Added support for curved interior cells for all Triangulation
  dimensions.
  <br>
  A new Manifold<dim,spacedim> class was introduced which only contains the
  interface needed by Triangulation to refine objects, leaving all boundary
  related functions in the class Boundary<dim,spacedim>, which was made
  derived from Manifold<dim,spacedim>.
  <br>
  This new construction allows for curved interior cells, and custom refinement
  strategies (see, for example, the new tutorial program step-53).
  At the moment the following Manifolds are supported:
  <ul>
  <li> FlatManifold<dim,spacedim>: This class replaces the old
  StraightBoundary<dim,spacedim>, and it adds support for periodic
  manifolds. This is the simplest class one can use to create new Manifold classes;
  </li>
  <li> ManifoldChart<dim,spacedim,chartdim>: This is one of the most general Manifold
  one can think of. The user can overload the functions ManifoldChart::pull_back() and
  ManifoldChart::push_forward(), to obtain a very general curved geometry, following
  concepts typical of elasticity;
  </li>
  <li> SphericalManifold<dim,spacedim>: A simple implementation of spherical coordinates
  transformations. This manifold allows hyper shells with curved interior cells which
  follow the natural shape of the shell;
  </li>
  </ul>
  <br>
  The functions
  Triangulation::set_boundary() and Triangulation::get_boundary() can still be used to
  set and get Boundary objects instead of Manifold ones. For the get function, an exception
  is thrown if a conversion to a valid Boundary class cannot be made on the fly.
  <br>
  (Luca Heltai, 2014/08/06)
  </li>

  <li> Ported: The build system now supports CMake 3.0.
  <br>
  (Matthias Maier, 2014/07/15)
  </li>

  <li> New: Added support for curved interior boundaries, and general
  manifold id description.
  <br>
  A new attribute was added to each triangulation object
  (types::manifold_id) which allows one to specify a manifold
  description, much in the same way we do for boundaries, also for
  interior edges and faces. At the moment this information is used
  only for objects of topological dimension less than spacedim, but a
  generalization of the class Boundary<dim,spacedim> is on its way to
  allow also curved cells.
  <br>
  For the moment, full backward compatibility is granted, and one can
  keep using the old Boundary<dim,spacedim>, together with
  Triangulation::set_boundary(), and Triangulation::get_boundary()
  methods. However, this change suggests to use the types::boundary_id associated
  with each boundary face to indicate only boundary condition types, and
  it allows to separate the geometric meaning from the physical meaning. The
  suggested usage is
  - types::boundary_id is used for the physical meaning
  - types::manifold_id is used for the geometric meaning.
  <br>
  (Luca Heltai, 2014/07/14)
  </li>

  <li> New: Tutorial programs (and a few other places) are now cross-linked
  to their corresponding video lectures.
  <br>
  (Wolfgang Bangerth, 2014/07/10)
  </li>

  <li> Changed: The functionparser library bundled with deal.II got replaced
  by the <a href="https://muparser.beltoforion.de/">muparser</a> library.
  <br>
  (Timo Heister, 2014/02/10)
  </li>

  <li> Changed: It was possible to call DoFCellAccessor::set_active_fe_index()
  on non-active cells. However, this made no sense: Since degrees of
  freedoms only exist on active cells
  for hp::DoFHandler (i.e., there is currently no implementation
  of multilevel hp::DoFHandler objects), it does not make sense
  to assign active FE indices to non-active cells since they
  do not have finite element spaces associated with them without
  having any degrees of freedom.
  <br>
  The same of course is true for asking for the finite element active
  on a non-active cell, i.e. using the functions
  DoFAccessor::active_fe_index() and
  DoFAccessor::get_fe(). All of these functions now produce exceptions on
  non-active cells.
  <br>
  (Wolfgang Bangerth, 2014/01/24)
  </li>

  <li> New: deal.II now links with the
  <a href="https://www.boost.org/doc/libs/1_55_0/libs/iostreams/doc/index.html">BOOST
  Iostreams</a> library (at least if the libz and libbz2 libraries
  can be found that are necessary for BOOST Iostreams).
  Among many other things, this allows to easily
  read files that have been compressed, as in the following code snippet:
  @code
    #include <boost/iostreams/filtering_stream.hpp>
    #include <boost/iostreams/filter/gzip.hpp>
    #include <boost/iostreams/device/file.hpp>

    ...

    boost::iostreams::filtering_istream in;
    in.push(boost::iostreams::basic_gzip_decompressor<>());
    in.push(boost::iostreams::file_source("myfile.gz"));

    int i;
    in >> i;
  @endcode
  More documentation on how to use BOOST Iostream can be found
  in the documentation link referenced above.
  <br>
  (Wolfgang Bangerth, 2013/12/21)
  </li>
</ol>


<!-- ----------- SPECIFIC IMPROVEMENTS ----------------- -->

<a name="810-820-specific"></a>
<h3>Specific improvements</h3>

<ol>
  <li>Fixed: CMake now correctly detects -Wno-... support for gcc.
  <br>
  (Matthias Maier, 2014/12/11)
  </li>

  <li> New: The FE_Q and FE_Q_Hierarchical classes now include pictures
  of their 2d shape functions in the class documentation.
  <br>
  (Manuel Quezada de Luna, Wolfgang Bangerth, 2014/12/09)
  </li>

  <li> Fixed: Calling DoFRenumbering::Cuthill_McKee threw an exception
  whenever one of the processors of a parallel triangulation did not own
  any degrees of freedom.
  <br>
  (Michal Wichrowski, Wolfgang Bangerth, 2014/12/04)
  </li>

  <li> Fixed: Serializing an object of type DoFHandler did not work without
  including additional header files.
  <br>
  (David Wells, Wolfgang Bangerth, 2014/11/26)
  </li>

  <li> New: The class FEEvaluation with its fast tensor evaluation routines
  can now be initialized from a mapping, a finite element, a quadrature, and
  update flags on the fly similar to FEValues. This provides an alternative
  entry point to these routines without the need to create a MatrixFree data
  object.
  <br>
  (Martin Kronbichler, 2014/11/20)
  </li>

  <li> New: Complete the interface for periodic boundary conditions.
  Now, it is possible to specify an additional (geometric) rotation matrix along
  with vector components that should be rotated when applying periodic boundary
  conditions (or alternatively, directly a transformation matrix working
  directly on dofs). With this it is now possible to e.g. compute Stokes flow
  on a quarter pie with periodic boundary conditions and the velocity correctly
  transformed.
  <br>
  (Daniel Arndt, Matthias Maier, 2014/11/19)
  </li>

  <li> Improved: Vector updates in PreconditionChebyshev based on deal.II's own
  vectors are now vectorized with OpenMP 4.0 SIMD pragmas.
  <br>
  (Martin Kronbichler, Bruno Turcksin, 2014/11/17)
  </li>

  <li> New: Added support for STEP files in the OpenCASCADE
  wrappers. STEP files can now be imported and exported respectively
  with the OpenCASCADE::read_STEP() and OpenCASCADE::write_STEP() functions.
  <br>
  (Andrea Mola, 2014/11/12)
  </li>

  <li> New: Timer now has get_lap_time() which returns the time
  lapsed between the last start()/stop() cycle.
  <br>
  (Fahad Alrashed, 2014/11/09)
  </li>

  <li> New: GridTools::get_locally_owned_vertices() allows to query
  which vertices of a triangulation are owned by the current
  processor.
  <br>
  (Wolfgang Bangerth, 2014/11/09)
  </li>

  <li> New: parallel::distributed::Triangulation::communicate_locally_moved_vertices()
  allows to
  update vertex positions that have been moved just locally on distributed
  meshes. GridTools::distort_random now works for distributed meshes and
  hanging nodes in 3D as well.
  <br>
  (Daniel Arndt, 2014/11/06)
  </li>

  <li> New: TableHandler objects can be cleared - i.e. reset to a
  zero-sized state.
  <br>
  (Fahad Alrashed, 2014/11/09)
  </li>

  <li> New: The FE_Nothing class now has a second template argument
  corresponding to the space dimension in which the mesh is embedded,
  like many other classes. This allows to use this element in codimension
  one cases as well now.
  <br>
  (Wolfgang Bangerth, 2014/11/05)
  </li>

  <li> Fixed: Using the FEEvaluation framework did not work for
  scalar elements in 1d because there were conflicting partial
  specializations. This is now fixed.
  <br>
  (Shiva Rudraraju, 2014/11/04)
  </li>

  <li> New: There is now a macro <code>DEAL_II_VERSION_GTE</code>
  that can be used to test whether the deal.II version is greater
  than or equal a particular version number. This is useful if you
  need to make application programs compatible with different
  deal.II releases.
  <br>
  (Wolfgang Bangerth, 2014/10/31)
  </li>

  <li> New: The vector classes in deal.II (including Trilinos and PETSc
  wrappers) now have a new method x.add_and_dot(factor,v,w) which performs
  x.add(factor,v) and subsequent inner product of x with another vector
  w. This operation occurs in some iterative solvers; by a combined operation,
  reduced memory transfer and thus higher performance are enabled.
  <br>
  (Martin Kronbichler, 2014/10/27)
  </li>

  <li> Improved: Inner products and norms on deal.II's own vector classes now
  use vectorization through VectorizedArray if available.
  <br>
  (Martin Kronbichler, 2014/10/27)
  </li>

  <li> Changed: PETSc and Trilinos vectors with ghost entries can now be reset to zero
  using = 0.0;
  <br>
  (Timo Heister, 2014/10/14)
  </li>

  <li> New: The new function FiniteElement::get_associated_geometry_primitive() allows to
  query whether a given degree of freedom is associated with a vertex, line,
  quad, or hex.
  <br>
  (Wolfgang Bangerth, 2014/09/26)
  </li>

  <li> Fixed: The vector and array versions of Utilities::MPI::sum() and
  Utilities::MPI::max() produced segmentation faults with some MPI implementations
  if the input and output arguments were the same. This is now fixed.
  <br>
  (Wolfgang Bangerth, 2014/09/29)
  </li>

  <li> Fixed: Trying to have FE_Q(p) and FE_DGQ(r) elements next to each
  other in an hp::DoFHandler object led to assertions saying that these two
  elements don't know how to compute interface constraints where such
  elements touch. This has now been fixed: FE_DGQ is a discontinuous element,
  so there cannot be any interface constraints at all.
  <br>
  (Wolfgang Bangerth, 2014/09/26)
  </li>

  <li> Fixed: The function TrilinosWrappers::VectorBase::sadd(double factor,
  VectorBase &v) erroneously added factor*v instead of scaling the calling
  vector by factor. This is now fixed.
  <br>
  (Martin Kronbichler, 2014/09/26)
  </li>

  <li> Fixed: The function TrilinosWrappers::SparseMatrix::add(double factor,
  SparseMatrix &rhs) produced wrong results and ran into an exception if the
  rhs matrix included off-processor column entries. This is now fixed.
  <br>
  (Martin Kronbichler, 2014/09/21)
  </li>

  <li> New: The function Threads::Task::joinable() can be used to verify whether
  a task object can be joined or not.
  <br>
  (Wolfgang Bangerth, 2014/09/17)
  </li>

  <li> New: Added two optional parameters to TriaAccessor::center()
  and a new method TriaAccessor::intermediate_point().
  They allow to query for a
  geometrically coherent center, or ask for arbitrary points on the
  underlying Manifold, given the dim coordinates in the reference
  element.
  Triangulation was refactored internally to use the new
  TriaAccessor::center() interface when querying for new points.
  <br>
  (Luca Heltai, 2014/09/13)
  </li>

  <li> Improved: Optimize construction of high-order FE_Nedelec by moving out some
  non-essential computations. Namely, construct restriction and prolongation
  matrices on first request. This reduces time spent in FE_Nedelec constructor
  substantially.
  <br>
  (Alexander Grayver, 2014/08/22)
  </li>

  <li> New: There is now a GridGenerator::flatten_triangulation()
  taking a Triangulation<dim, spacedim_1> as input and returning
  a Triangulation<dim, spacedim_2> as output. The output
  triangulation will contain a single level with all active
  cells of the input triangulation, and will be topologically
  equivalent to the input triangulation. If the two space dimensions
  are equal, then this function will copy the triangulation
  removing all levels, e.g., flattening it. If the two space dimensions
  are different, then this function will copy the vertices only
  up to the smallest space dimension parameter. <br>
  Using this function, you can create a Triangulation<2,3> from
  a Triangulation<2,2> or project to the plane z=0 your
  Triangulation<2,3>. No checks are performed on the validity of
  the resulting Triangulation.
  <br>
  (Luca Heltai, 2014/08/19)
  </li>

  <li> Changed: The functions GridTools::extract_boundary_mesh() and
  GridTools::create_union_triangulation() have been moved to
  GridGenerator::extract_boundary_mesh() and
  GridGenerator::create_union_triangulation() since, conceptually, they
  generate meshes. The old functions have been retained but are now
  deprecated.
  <br>
  (Wolfgang Bangerth, 2014/08/19)
  </li>

  <li> New: TriaAccessor::measure() is now also implemented for faces of
  3d cells as long as the face is planar.
  <br>
  (Kevin Drzycimski, 2014/08/19)
  </li>

  <li> Fixed: Support SLEPc 3.5 by disabling SDFOLD spectrum transformation type
  that has been removed from SLEPc. Therefore, TransformationSpectrumFolding
  cannot be used with newer SLEPc versions.
  <br>
  (Alexander Grayver, 2014/08/15)
  </li>

  <li> New: To better support applications that want to use C++11's
  <a href="https://en.wikipedia.org/wiki/C%2B%2B11#Range-based_for_loop">range-based
  for loops</a>, there are now functions Triangulation::cell_iterators(),
  Triangulation::all_cell_iterators() and similarly in classes DoFHandler
  and hp::DoFHandler
  that return a range object that can then be used in range-based for loops.
  The underlying implementation uses the new IteratorRange class.
  <br>
  See the new @ref CPP11 "C++11" page for more information.
  <br>
  (Wolfgang Bangerth, 2014/08/07)
  </li>

  <li> New: The new class FunctionManifold allows arbitrary manifold descriptions, in which you have
  an explicit Function<chartdim> for the ManifoldChart::push_forward()
  method, and an explicit Function<spacedim> for ManifoldChart::pull_back()
  method (or an expression for both). In these cases, you can construct a
  Manifold description on the fly.
  <br>
  (Luca Heltai, 2014/08/07)
  </li>

  <li> New: Added CylindricalManifold description.
  <br>
  This class allows refinement of cylindrical manifolds. It is a good
  companion for GridGenerator::cylinder() and the perfect companion
  for GridGenerator::cylinder_shell().
  <br>
  (Luca Heltai, 2014/08/06)
  </li>

  <li> New: TrilinosWrappers::PreconditionAMG can now be initialized from an
  object of type Epetra_RowMatrix, which allows using it with more arbitrary
  matrix objects, including matrix-free methods.
  <br>
  (Martin Kronbichler, 2014/08/06)
  </li>

  <li> Fixed: The FE_Nedelec element computed face interpolation matrices
  wrongly for elements of order p>1. This also led to trouble computing
  hanging node constraints in the context of hp adaptivity. This is now fixed.
  <br>
  (Alexander Grayver, 2014/08/05)
  </li>

  <li> New: The function GridTools::get_patch_around_cell() extracts
  the set of cells that surround a single cell. The new functions
  DoFTools::count_dofs_on_patch() and DoFTools::get_dofs_on_patch()
  then help set up local problem on patches.
  <br>
  (Arezou Ghesmati, Wolfgang Bangerth, 2014/07/29)
  </li>

  <li> Fixed: Utilities::string_to_int() and
  Utilities::string_to_double() did not catch if the
  string given started with an integer or double but contained additional
  text. They now throw an exception if this happens.
  <br>
  (Wolfgang Bangerth, 2014/07/20)
  </li>

  <li> New: The function GridOut::write can now be used also in
  the codimension one case.
  <br>
  (Luca Heltai, 2014/07/18)
  </li>

  <li> New: The Function classes now take an additional optional
  template argument, specifying the type of number to use, which defaults
  to double.
  <br>
  (Luca Heltai, 2014/07/18)
  </li>

  <li> New: The GridReordering::reorder_cells() function used a
  numbering format for the vertices in a cell that was last used in
  deal.II version 5.2. This format is still used internally, but
  the function now also understands the numbering that has been
  used in deal.II ever since. The choice is made by an additional
  argument to the function that defaults to the old-style
  format for backward compatibility.
  <br>
  (Wolfgang Bangerth, 2014/07/14)
  </li>

  <li> New: There are now functions GridOut::write_vtk() and
   GridOut::write_vtu() that can
  write a mesh in VTK/VTU format.
  <br>
  (Wolfgang Bangerth, 2014/07/14)
  </li>

  <li> Fixed: PETSc up to at least version 3.5 has a bug where it does
  not zero-initialize the ghost elements of a newly created ghosted
  parallel vector. This is now worked around inside deal.II.
  <br>
  (Wolfgang Bangerth, Michal Wichrowski, 2014/07/12)
  </li>

  <li> Improved: The Trilinos direct solver, TrilinosWrappers::SolverDirect,
  now takes a string to select among the available Amesos solvers. Moreover,
  the solver now also supports deal.II's distributed vectors.
  <br>
  (Uwe K&ouml;cher, Martin Kronbichler, 2014/07/09)
  </li>

  <li> New: There are now three new preconditioner classes
  TrilinosWrappers::PreconditionBlockJacobi,
  TrilinosWrappers::PreconditionBlockSSOR, and
  TrilinosWrappers::PreconditionBlockSOR that work on small dense blocks of
  the global matrix instead of the point-wise relaxation methods in
  TrilinosWrappers::Precondition{Jacobi,SSOR,SOR} that work on each row
  separately.
  <br>
  (Martin Kronbichler, 2014/07/04)
  </li>

  <li> Fixed: Some versions of DoFTools::extract_boundary_dofs() were
  not instantiated for some combinations of arguments. This could lead
  to missing symbol errors during linking of applications on some
  platforms and with some compiler versions. This is now
  fixed.
  <br>
  (Wolfgang Bangerth, 2014/07/04)
  </li>

  <li> Fixed: GridGenerator::merge_triangulations sometimes produced invalid
  orientations of faces. This is now fixed.
  <br>
  (Daniel Arndt, 2014/06/30)
  </li>

  <li> Fixed: TrilinosWrappers::PreconditionAMG did not read user-provided
  constant modes (aka null space) when the null space dimension is one but not
  just the trivial one vector. This is now fixed.
  <br>
  (Martin Kronbichler, 2014/06/30)
  </li>

  <li> Simplified interfaces for FEEvaluation: Previously, the user had to
  select the appropriate kernel (FEEvaluation, FEEvaluationGeneral,
  FEEvaluationDGP, FEEvaluationGL) for the matrix-free evaluation
  routines. This made it difficult to write compact code that needs to select
  between different elements. Therefore, all the functionality has been merged
  into FEEvaluation and one should only use FEEvaluation, while the other
  interfaces have been marked deprecated and will be removed in a future
  version. The internal data structures for the various special cases have
  been kept in order to provide for the most efficient routines, and are
  selected at construction of FEEvaluation.
  <br>
  (Martin Kronbichler, 2014/06/27)
  </li>

  <li> Bugfix: TBB specific include directories have to be added to the
  list of user include directories because of direct inclusion of header
  files in base/thread_local_storage.h.
  <br>
  (Matthias Maier, Kainan Wang, 2014/06/25)
  </li>

  <li> Improved: GridGenerator::hyper_cube() accepts a
  <code>colorize</code> argument.
  <br>
  (Guido Kanschat, 2014/06/23)
  </li>

  <li> New: %Functions DoFTools::extract_locally_relevant_dofs(),
  parallel::distributed::GridRefinement::refine_and_coarsen_fixed_number() and
  parallel::distributed::GridRefinement::refine_and_coarsen_fixed_fraction() are
  now also instantiated for objects of codimension 1.
  <br>
  (Michal Wichrowski, 2014/06/15)
  </li>

  <li> New: There are now functions Triangulation::has_hanging_nodes()
  and parallel::distributed::Triangulation::has_hanging_nodes().
  <br>
  (Denis Davydov, 2014/06/15)
  </li>

  <li> New: There is now function Triangulation::n_global_active_cells().
  <br>
  (Denis Davydov, 2014/06/19)
  </li>

  <li> New: The class FEEvaluation now provides optimized matrix-free
  evaluation routines for FE_Q_DG0 elements.
  <br>
  (Martin Kronbichler, 2014/06/13)
  </li>

  <li> Bugfix: Filter libclang_rt* from the PETSc link line.
  <br>
  (Matthias Maier, 2014/06/04)
  </li>

  <li> Improved: ParameterHandler parsing added to DoFOutputOperator
  <br>
  (Guido Kanschat, 2014/06/03)
  </li>

  <li> Improved: Algorithms::ThetaTimestepping and other operators now use AnyData
  to communicate with operators they rely on. This way, time step data
  can be forwarded using the same mechanism, and no complicated back
  access to member data is required
  anymore. MeshWorker::IntegrationInfo uses AnyData as well.
  <br>
  (Guido Kanschat, 2014/06/03)
  </li>

  <li> Bugfix: CMake: Also clean CMAKE_MODULE_PATH prior to call to
  FIND_PACKAGE(Boost) inside FindBOOST.cmake because apparently
  "Boost" == "BOOST" for the Mac file system...
  <br>
  (Matthias Maier, 2014/05/28)
  </li>

  <li> Improved: CMake: Search results and error conditions for external
  libraries are now much more verbose. Added an MPI sanity check.
  <br>
  (Matthias Maier, 2014/05/28)
  </li>

  <li> Fixed: The MatrixTools::apply_boundary_values() variant that works
  on PETSc matrices could produce a deadlock in parallel if one processor
  had no boundary values to apply. This is now fixed.
  <br>
  (Michal Wichrowski, 2014/05/19)
  </li>

  <li> New: AnyData::try_read() is a function that allows users to check
  whether an entry exists and get a pointer to it without throwing an
  exception in case of failure.
  <br>
  (Guido Kanschat, 2014/05/16)
  </li>

  <li> New: The GMRES solver of deal.II can now write an estimate of
  eigenvalues to the log file, in analogy to the CG solver. This is enabled
  by the flag SolverGMRES::AdditionalData::compute_eigenvalues.
  <br>
  (Martin Kronbichler, 2014/05/11)
  </li>

  <li> New: The GridIn::read_vtk() function places fewer restrictions
  on the VTK files it wants to read and should, consequently, be able
  to read more correctly formatted VTK files than before.
  <br>
  (Giorgos Kourakos, 2014/05/08)
  </li>

  <li> New: There is now a QSorted quadrature which takes an
  arbitrary quadrature at construction time and reorders the quadrature
  points according to the weights, from smaller to bigger. This should
  improve stability of higher order polynomial integration.
  <br>
  (Luca Heltai, 2014/05/07)
  </li>

  <li> New: The class VectorizedArray<Number> now provides methods
  VectorizedArray::load(ptr) to read from arbitrary pointer addresses and
  VectorizedArray::store(ptr) to write to arbitrary pointer addresses,
  as opposed to the data layout of VectorizedArray that requires pointers
  to be aligned by the size of the array in bytes. This also circumvents
  a (rare) compiler optimization bug with gcc-4.6 on SSE code in combination
  with function calls, e.g. to std::sin.
  <br>
  (Martin Kronbichler, 2014/05/05)
  </li>

  <li> Changed: Namespace SparsityTools had a local typedef <code>size_type</code>
  that was set equal to types::global_dof_index. This typedef has been removed
  and we now use SparsityPattern::size_type wherever applicable as this is the
  type we really want to use. (The code worked previously because
  types::global_dof_index and SparsityPattern::size_type happen to be the same
  as far as the underlying type is concerned; however, they are different
  semantically.)
  <br>
  (Wolfgang Bangerth, 2014/05/04)
  </li>

  <li> Updated: The step-16 tutorial program was updated to the new layout
  multigrid objects and thus avoids using deprecated interfaces.
  <br>
  (Martin Kronbichler, 2014/05/03)
  </li>

  <li> Fixed: FE_DGQArbitraryNodes::has_support_on_face was broken when
  polynomials with support points not on the element boundary were used.
  This is now fixed.
  <br>
  (Martin Kronbichler, 2014/04/30)
  </li>

  <li> Fixed: parallel::distributed::Triangulation::load now has an
  additional parameter <code>autopartition</code> to control p4est's behavior of
  rebalancing triangulations between MPI nodes upon reading. It is
  particularly useful to disable this behavior when data is stored
  separately (examples for this are in the regression tests mpi/p4est_save_0?).
  <br>
  (Alexander Grayver, Matthias Maier, 2014/04/26)
  </li>

  <li> Fixed: GridTools::find_active_cell_around_point() could get into an infinite
  loop if the point we are looking for is in fact not within the domain. This is now
  fixed.
  <br>
  (Giorgos Kourakos, Timo Heister, Wolfgang Bangerth, 2014/04/14)
  </li>

  <li> Changed: TableBase now uses AlignedVector for storing data
  instead of std::vector, which allows its use for VectorizedArray<Number>
  data fields which require more alignment.
  <br>
  (Martin Kronbichler, 2014/04/09)
  </li>

  <li> Improved: Piola transformation for FE_BDM is now active.
  <br>
  (Guido Kanschat, 2014/04/09)
  </li>

  <li> Changed: operator< for cell iterators no longer looks at
  (level-)subdomain ids but only compares level() and index(). This makes the
  ordering inconsistent between processes on a
  parallel::distributed::Triangulation, but fixes the problem that the
  ordering of cells changes under mesh refinement or other causes for changing
  the subdomain id.
  <br>
  (Timo Heister, 2014/04/08)
  </li>

  <li> New: GridTools::laplace_transform() now takes an additional, optional
  parameter that indicates the "stiffness" of the mapping.
  <br>
  (Denis Davydov, Jean-Paul Pelteret, 2014/04/07)
  </li>

  <li> Fixed: DoFTools::extract_constant_modes now correctly identifies both
  constant modes in the scalar element FE_Q_DG0, which has been realized by a
  few modifications in how the constant modes propagate from the element to
  the extract_constant_modes() function.
  <br>
  (Martin Kronbichler, 2014/04/04)
  </li>

  <li> Fixed: GridTools::laplace_transform had previously announced in
  the documentation that one can also set the location of interior points,
  but this was not in fact what was implemented. This has now been fixed:
  the code can now do that.
  <br>
  (Denis Davydov, Wolfgang Bangerth, 2014/03/23)
  </li>

  <li> Improved: Inhomogeneous tangential and normal flow constraints can
       now be treated via VectorTools::compute_nonzero_normal_flux_constraints
       and VectorTools::compute_nonzero_tangential_flux_constraints.
  <br>
  (Daniel Arndt, 2014/03/16)
  </li>

  <li> Changed: Class TriaAccessor had a function parent_index(), but this function
  could only work for cell accessors. The function has consequently been moved
  to class CellAccessor.
  <br>
  (Wolfgang Bangerth, 2014/03/15)
  </li>

  <li> Fixed: step-32 had a piece of code where we accessed an internal
  representation of how Trilinos vectors are actually stored. This is poor
  style and has been rewritten.
  <br>
  (Wolfgang Bangerth, 2014/03/14)
  </li>

  <li> Fixed: VectorTools::project_boundary_values_curl_conforming contained
  a bug for some cases. This is now fixed.
  <br>
  (Markus B&uuml;rg, 2014/03/10)
  </li>

  <li> Fixed: ParameterHandler will no longer output an error if the file
  to be read ends with "end" without a newline.
  <br>
  (Timo Heister, 2014/02/28)
  </li>

  <li>Improved: DoFRenumbering::Cuthill_McKee can now run with distributed
  triangulations with the renumbering only done within each processor's
  subdomain.
  <br>
  (Martin Kronbichler, 2014/02/20)

  <li>Fixed: There was an indexing error in GridIn::read_vtk() that triggered
  for some input files. This is now fixed.
  <br>
  (Mayank Sabharwal, 2014/02/19)

  <li>New: There is a new namespace TimeStepping for the algorithms that do time
  integrations. In this new namespace, several Runge-Kutta methods have been
  implemented: explicit methods, implicit methods, and embedded explicit methods.
  <br>
  (Damien Lebrun-Grandie, Bruno Turcksin, 2014/02/17)

  <li>New: There is now a class FEEvaluationDGP that implements matrix-free
  evaluation routines by truncated tensor products for FE_DGP elements.
  <br>
  (Martin Kronbichler, 2014/02/17)

  <li>Changed: The InverseMatrixRichardson used to eat all exceptions
  that may have been produced by the underlying Richardson solver, leaving
  no trace that the underlying solver may have failed when you call functions
  such as InverseMatrixRichardson::vmult(). These exceptions are now propagated
  out to the caller.
  <br>
  (Wolfgang Bangerth, 2014/02/16)


  <li>New: FE_TraceQ implements finite elements on faces, which
  correspond to the traces of H<sup>1</sup>-conforming elements.
  <br>
  (Angela Klewinghaus, 2014/02/14)

  <li>New: FE_FaceQ and FE_FaceP now also work in 1D (with a single dof
  on each vertex).
  <br>
  (Martin Kronbichler, 2014/02/11)

  <li>Fixed: FE_DGQ::has_support_on_face returned a wrong number for element
  degree larger than 1 in 1D. This is now fixed.
  <br>
  (Martin Kronbichler, 2014/02/10)

  <li>Changed: DerivativeApproximation used to be a class that only had
  static members. It is now a namespace.
  <br>
  (Wolfgang Bangerth, 2014/02/08)

  <li>New: Threads::ThreadLocalStorage::clear() clears out all objects allocated on the
  current and all other threads.
  <br>
  (Wolfgang Bangerth, 2014/02/06)

  <li>Fixed: A configuration error on Debian Testing where accidentally a
  non-pic libSuiteSparse_config.a was picked up when building a shared
  library up resulting in a link error.
  <br>
  (Matthias Maier, 2014/02/04)

  <li> Changed: GridTools::transform() can now deal with meshes with hanging nodes.
  <br>
  (Timo Heister, 2014/02/04)
  </li>

  <li>Fixed: Calling FEValuesViews::Vector::get_function_curls() computed
  wrong results in some cases (see https://code.google.com/p/dealii/issues/detail?id=182).
  This is now fixed.
  <br>
  (Christoph Heiniger, Wolfgang Bangerth, 2014/02/03)

  <li>Added: The class LAPACKFullMatrix now implements interfaces to
  matrix-matrix multiplication. Also, LAPACKFullMatrix::apply_lu_factorization
  now also operates on multiple right hand sides in form of another
  LAPACKFullMatrix.
  <br>
  (Martin Kronbichler, 2014/02/03)

  <li>Fixed: The build system does no longer record full paths to system
  libraries but uses the appropriate short names instead.
  <br>
  (Matthias Maier, 2014/02/01)

  <li>Reworked: External feature setup. Disabling a feature now cleans up
  associated internal, cached variables. A per-feature linkage test now spots
  common linking inconsistencies early in the configuration stage (and not
  just after a complete compilation).
  <br>
  (Matthias Maier, 2014/02/01)

  <li>New/fixed: The ParameterHandler::print_parameters_section
  method did not work for XML output. There is now a flag
  include_top_level_elements which prints all higher
  subsection elements, default is false.
  For XML output setting this flag to true is required
  to ensure that the output is a valid XML document,
  starting with one root element ParameterHandler and
  compatible with read_input_from_xml and the parameterGUI.
  <br>
  (Martin Steigemann, 2014/02/01)

  <li>New: There is now a method to copy the content from a
  PETScWrappers::MPI::Vector and TrilinosWrappers::MPI::Vector to
  deal.II's parallel distributed vector.
  <br>
  (Ben Thompson, Martin Kronbichler, 2014/01/31)

  <li>Fixed: The SolutionTransfer class had all sorts of problems when
  used with hp::DoFHandler that made its results at least questionable.
  Several parts of this class have been rewritten to make the results
  more predictable and, likely, more correct.
  <br>
  (Wolfgang Bangerth, 2014/01/26)

  <li>Fixed: A regression where a single whitespace accidentally added to
  DEAL_II_LINKER_FLAGS internally prevented cmake-2.8.8 from configuring
  successfully.
  <br>
  (Matthias Maier, Krysztof Bzowski, 2014/01/26)

  <li> Fixed: SparsityPattern::max_entries_per_row() forgot to consider
  the last row of the matrix and consequently sometimes returned
  wrong values. This is now fixed.
  <br>
  (Martin Kronbichler, 2014/01/22)
  </li>

  <li> Improved: In rare cases when the vector of error indicators
  has entries equal to zero the adjust_interesting_range method
  produces a negative lower bound. As a result the
  parallel::distributed::GridRefinement::refine_and_coarsen_fixed_*
  methods flagged the wrong number of cells for coarsening and refinement.
  This is now changed by adjusting the lower bound in adjust_interesting_range
  only, if not equal to zero.
  <br>
  (Martin Steigemann, 2014/01/22)
  </li>

  <li> Changed: It was previously possible to set the
  <code>active_fe_index</code> on non-active cells of an hp::DoFHandler.
  However, this was prone to mistakes because it may lead to the assumption
  that a finite element space out of the ones described by the hp::FECollection
  associated with this hp::DoFHandler was actually associated with such
  a cell. Since we do not actually distribute degrees of freedom for such
  hp::DoFHandler objects on non-active cells, this is not the case. Consequently,
  it no longer has any effect to assign active FE indices to non-active cells:
  these values are simply reset later on.
  <br>
  (Wolfgang Bangerth, 2014/01/20)
  </li>

  <li> Fixed: The method DoFTools::extract_constant_modes only worked for
  elements where the constant function 1 is represented by all ones. This
  is now fixed by querying the element for its constant modes on each cell.
  <br>
  (Martin Kronbichler, 2014/01/19)
  </li>

  <li> Fixed: PETScWrappers::MPI::Vector::all_zero() was broken with more than
  one processor (illegal memory access) and did not communicate between all
  processors. Documentation for many vector types of all_zero() has been extended.
  <br>
  (Timo Heister, 2014/01/17)
  </li>

  <li> Fixed/new: DoFCellAccessor::set_dof_values_by_interpolation and
  DoFCellAccessor::get_interpolated_dof_values could previously be
  called for hp::DoFHandler objects on cells that are non-active. This
  makes no sense since these cells have no associated finite element
  space. Doing so now raises an exception.
  <br>
  However, there are legitimate cases where one may want to interpolate
  from children to a parent's finite element space or the other way around.
  Since in the hp
  case no finite element space is naturally associated with an inactive
  cell, it is now possible to pass an explicit finite element index
  argument to these functions specifying which element of an hp::FECollection
  object describes the space onto which you want to interpolate.
  <br>
  (Mihai Alexe, Wolfgang Bangerth, 2014/01/18)
  </li>

  <li> Fixed: The methods IndexSet::do_compress() and
  IndexSet::add_indices(IndexSet&) had quadratic complexity in the number of
  ranges. The algorithms have been changed into linear complexity ones.
  <br>
  (Martin Kronbichler, 2014/01/15)
  </li>

  <li> Fixed: There were several bugs in functions like
  FEValues::get_function_values() where the code did not properly handle the
  case of FE_Nothing. This is now fixed.
  <br>
  (Wolfgang Bangerth, 2014/01/08)
  </li>

  <li> Fixed: DataOut got confused in some situations where one uses FE_Nothing.
  This is now fixed.
  <br>
  (Minh Do-Quang, Wolfgang Bangerth, 2014/01/08)
  </li>

  <li> Fixed: FESystem::get_interpolation_matrix, a function that is among
  other places used by SolutionTransfer, had a bug that prevented it from
  running correctly in some situations where one uses FE_Nothing.
  This is now fixed.
  <br>
  (Minh Do-Quang, Wolfgang Bangerth, 2014/01/08)
  </li>

  <li> Improved: When you call WorkStream::run with an empty function object
  for the copier, operations on individual cells are essentially all independent.
  In other words, you have a massively parallel collection of jobs. In this
  case, a parallel for loop over all elements is better suited than the
  pipeline approach currently used. This has now been implemented.
  <br>
  (Wolfgang Bangerth, 2013/12/26)
  </li>

  <li> New: The new function VectorTools::interpolate_based_on_material_id()
  can be used to interpolate several functions onto a mesh, based on the
  material id of each cell individually.
  <br>
  (Valentin Zingan, 2013/12/26)
  </li>

  <li> New: A new reinit() method has been introduced to
  TrilinosWrappers::SparsityPattern that takes all rows that are possibly
  written into as an optional argument. This allows for pre-allocating all
  possible entries right away, which makes writing into the matrix from
  several threads possible (otherwise, only one processor at a time can write
  off-processor data). Similarly, TrilinosWrappers::MPI::Vector objects can
  be initialized with hints to ghost elements for a writable vector that can
  be added into from multiple threads.
  <br>
  (Martin Kronbichler, 2013/12/23)
  </li>

  <li> New: The TableBase::fill function has become more powerful in that
  it now doesn't just take pointers to initializing elements but can deal
  with arbitrary input iterators. It now also takes a flag that denotes the
  order in which table elements are initialized, allowing to switch between
  C- and Fortran-style table layouts.
  <br>
  Along with the TableBase::fill function, the Table classes of various
  ranks have also gotten constructors that allow the in-place construction
  not only of a table of correct size, but already initialized from
  somewhere. This finally allows to mark Table objects as const by creating
  them already with the correct content.
  <br>
  (Wolfgang Bangerth, 2013/12/21)
  </li>

  <li> New: There is now a new class Functions::InterpolatedTensorProductGridData that can
  be used to (bi-/tri-)linearly interpolate data given on a tensor product
  mesh of $x$ (and $y$ and $z$) values, for example to evaluate experimentally
  determined coefficients, or to assess the accuracy of a solution by
  comparing with a solution generated by a different code and written in
  gridded data. There is also a new class Functions::InterpolatedUniformGridData that
  can perform the same task more efficiently if the data is stored on meshes
  that are uniform in each coordinate direction.
  <br>
  (Wolfgang Bangerth, 2013/12/20)
  </li>

  <li> Fixed: ParameterHandler::get_double() and ParameterHandler::get_integer()
  had bugs in that they didn't detect if they were asked to return a number
  for a parameter whose value was in fact not a number but some general
  text. This is now fixed.
  <br>
  (Wolfgang Bangerth, 2013/12/19)
  </li>

  <li> Fixed: VectorTools::project_boundary_values could not deal with
  function values close to (but not exactly equal to) zero. This is now fixed.
  <br>
  (Martin Kronbichler, 2013/12/16)
  </li>

  <li> New: It is now possible to select between different smoothers and coarse
  solvers in the Trilinos AMG preconditioners by a string to the smoother's name.
  <br>
  (Andrew Baker, 2013/12/14)
  </li>

</ol>


*/
