/////////////////////////////////////////////////////////////////////////////
// Name:        ProgressDlg.h
// Purpose:     Progress of generation/burning dialog
// Author:      Alex Thuering
// Created:     14.08.2004
// RCS-ID:      $Id: ProgressDlg.h,v 1.38 2013/08/18 08:46:00 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef PROGRESS_DLG_H
#define PROGRESS_DLG_H

#include "DVD.h"
#include "Cache.h"
#include "BurnDlg.h"
#include <wx/ffile.h>

// begin wxGlade: dependencies
// end wxGlade

class MainWin;

class ProgressDlg : public wxDialog {
public:
    // begin wxGlade: ProgressDlg::ids
    enum {
        HIDE_BT_ID = 1001,
        ICONIZE_BT_ID = 1002
    };
    // end wxGlade

public:
	/** Constructor */
	ProgressDlg(MainWin* parent, Cache* cache, bool autoStart);
	/** starts the generating of DVD */
	bool Start(BurnDlg* burnDlg, DVD* dvd);

	/** Adds the given message to summary textbox */
	void AddSummaryMsg(const wxString& message, const wxString& details = wxEmptyString,
			const wxColour& colour = wxNullColour);
	/** Add the given message to details textbox */
	void AddDetailMsg(const wxString& message,
			const wxColour& colour = wxNullColour);
	/** Add the given text to details textbox */
	void AddDetailText(const wxString& text);

	/** Sets the step count of generating process */
	void SetSteps(int stepCount);
	/** Increments the step */
	void IncStep() {
		m_step ++;
		m_subStep = 0;
		UpdateGauge();
	}

	/** Sets the sub-step count of current step */
	void SetSubSteps(int value) {
		m_subStepCount = value;
		m_subStep = 0;
	}
	/** Sets the sub-step */
	void SetSubStep(int value) {
		m_subStep = value;
		UpdateGauge();
	}
	/** increments the sub-step */
	void IncSubStep(int value = 1) {
		SetSubStep(GetSubStep() + value);
	}
	/** Returns the sub-step */
	int GetSubStep() {
		return m_subStep;
	}

	bool IsCanceled();

private:
    // begin wxGlade: ProgressDlg::methods
    void set_properties();
    void do_layout();
    // end wxGlade
    // begin wxGlade: ProgressDlg::attributes
    wxStaticText* m_summaryLabel;
    wxTextCtrl* m_summaryText;
    wxGauge* m_gauge;
    wxStaticText* m_detailsLabel;
    wxTextCtrl* m_detailsText;
    wxButton* m_detailsBt;
    wxButton* m_minimizeBt;
    wxButton* m_cancelBt;
    // end wxGlade
	wxSizer* m_panelSizer;
	wxWindowDisabler* m_winDisabler;
	wxString m_detailsBtLabel;
	
	bool m_autoStart;
	int m_step;
	int m_stepCount;
	int m_subStepCount;
	int m_subStep;
	bool m_cancel;
	bool m_end;
	
	Cache* m_cache;
	wxFFile m_logFile;
	
	void UpdateGauge();

	void Failed(const wxString& message = wxEmptyString);
	void End();

	void OnCancel(wxCommandEvent& event);
	void OnHideDetails(wxCommandEvent& event);
	void OnMinimize(wxCommandEvent& event);

	void Run(BurnDlg* burnDlg, DVD* dvd);
	
	int GetMenuSubSteps(wxArrayPtrVoid& menuVobs, wxArrayInt& menuWSTypes, DVD* dvd, wxString dvdTmpDir);
	int GetTitleSubSteps(wxArrayPtrVoid& titleVobs, wxArrayInt& titleAspects, DVD* dvd, Cache* cache);
	int GetSlideshowSubSteps(wxArrayPtrVoid& slideshowVobs, DVD* dvd, wxString dvdTmpDir);
	int GetSubtitleSubSteps(wxArrayPtrVoid& subtitleVobs, wxArrayInt& subtitleAspects, DVD* dvd, wxString dvdTmpDir);
	bool CleanTemp(const wxString& tmpDir, const wxString& dvdTmpDir, const wxString& dvdOutDir);
	
	bool GenerateMenus(wxArrayPtrVoid& menuVobs, wxArrayInt& menuWSTypes, int menuSubSteps, DVD* dvd);
	bool Transcode(wxArrayPtrVoid& titleVobs, wxArrayInt& titleAspects, int titleSubSteps, DVD* dvd);
	bool Multiplex(const wxString& videoFile, const wxArrayString& audioFiles, const wxString& vobFile);
	bool GenerateSlideshow(wxArrayPtrVoid& slideshowVobs, int slideshowSubSteps, DVD* dvd);
	bool MultiplexSubtitles(wxArrayPtrVoid& subtitleVobs, wxArrayInt& subtitleAspects, int subtitleSubSteps, DVD* dvd);
	bool GenerateDvdFilesystem(DVD* dvd, const wxString& dvdTmpDir, const wxString& dvdOutDir, const wxString& tmpDir);
	bool Preview(BurnDlg* burnDlg, const wxString& dvdOutDir);
	bool CreateIsoImage(BurnDlg* burnDlg, DVD* dvd, const wxString& dvdDir, const wxString& tmpDir);
	bool AddEccData(BurnDlg* burnDlg, const wxString& tmpDir);
	bool FormatDvd(BurnDlg* burnDlg);
	bool BurnDvd(BurnDlg* burnDlg, DVD* dvd, const wxString& dvdOutDir, const wxString& tmpDir);
	
	bool GenerateMenu(Menu* menu, WidescreenType widescreenType, const wxString& menuFile, AudioFormat audioFormat,
			wxString audioFile, int audioBitrate);
    bool GenerateSlideshow(Slideshow* slideshow, const wxString& vobFile, AudioFormat audioFormat, wxString audioFile,
    		int audioBitrate);
	bool Transcode(Vob* vob, AspectRatio aspect, int videoBitrate, int audioBitrate, bool useMplex,
			AudioFormat defAudioFormat = afAC3);
	bool MultiplexSubtitles(const wxString& vobFile, TextSub* textSub, unsigned int streamIdx, VideoFormat videoFormat,
			const wxString& resultFile);
	/** removes given file and print error message if it failed */
	bool DeleteFile(wxString fname);
	/** removes given directory and all files in it */
	bool DeleteDir(wxString dir, bool subdirs = false);
	/** removes given temporary directory and all temporary files in it */
	bool DeleteTempFiles(const wxString& tmpDir, const wxString& dvdTmpDir, const wxString& dvdOutDir, bool delOutDir);
	/** executes given command */
	bool Exec(wxString command, wxString inputFile = wxEmptyString, wxString outputFile = wxEmptyString);

private:
	DECLARE_EVENT_TABLE()
}; // wxGlade: end class

#endif // PROGRESS_DLG_H
