/*
// $Id: //open/dev/farrago/src/net/sf/farrago/ddl/DdlCreateStmt.java#17 $
// Farrago is an extensible data management system.
// Copyright (C) 2005-2009 The Eigenbase Project
// Copyright (C) 2005-2009 SQLstream, Inc.
// Copyright (C) 2005-2009 LucidEra, Inc.
// Portions Copyright (C) 2003-2009 John V. Sichi
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package net.sf.farrago.ddl;

import java.util.*;

import net.sf.farrago.cwm.core.*;
import net.sf.farrago.fem.sql2003.*;
import net.sf.farrago.session.*;

import org.eigenbase.sql.*;


/**
 * DdlCreateStmt represents a DDL CREATE statement of any kind.
 *
 * @author John V. Sichi
 * @version $Id: //open/dev/farrago/src/net/sf/farrago/ddl/DdlCreateStmt.java#17 $
 */
public class DdlCreateStmt
    extends DdlStmt
{
    //~ Instance fields --------------------------------------------------------

    DdlReplaceOptions replaceOptions;

    //~ Constructors -----------------------------------------------------------

    /**
     * Constructs a new DdlCreateStmt.
     *
     * @param createdElement top-level element created by this stmt
     */
    public DdlCreateStmt(
        CwmModelElement createdElement,
        DdlReplaceOptions replaceOptions)
    {
        super(createdElement);
        this.replaceOptions = replaceOptions;
    }

    //~ Methods ----------------------------------------------------------------

    // implement DdlStmt
    public void visit(DdlVisitor visitor)
    {
        visitor.visit(this);
    }

    public DdlReplaceOptions getReplaceOptions()
    {
        return replaceOptions;
    }

    // refine DdlStmt
    public void postCommit(FarragoSessionDdlValidator ddlValidator)
    {
        if (ddlValidator instanceof DdlValidator) {
            DdlValidator val = (DdlValidator) ddlValidator;
            val.handlePostCommit(getModelElement(), "Create");
        }
    }
}

// End DdlCreateStmt.java
