/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;

class SpanWeight
implements Weight {
    private Searcher searcher;
    private float value;
    private float idf;
    private float queryNorm;
    private float queryWeight;
    private Collection terms;
    private SpanQuery query;

    public SpanWeight(SpanQuery query, Searcher searcher) {
        this.searcher = searcher;
        this.query = query;
        this.terms = query.getTerms();
    }

    public Query getQuery() {
        return this.query;
    }

    public float getValue() {
        return this.value;
    }

    public float sumOfSquaredWeights() throws IOException {
        this.idf = this.query.getSimilarity(this.searcher).idf(this.terms, this.searcher);
        this.queryWeight = this.idf * this.query.getBoost();
        return this.queryWeight * this.queryWeight;
    }

    public void normalize(float queryNorm) {
        this.queryNorm = queryNorm;
        this.queryWeight *= queryNorm;
        this.value = this.queryWeight * this.idf;
    }

    public Scorer scorer(IndexReader reader) throws IOException {
        return new SpanScorer(this.query.getSpans(reader), this, this.query.getSimilarity(this.searcher), reader.norms(this.query.getField()));
    }

    public Explanation explain(IndexReader reader, int doc) throws IOException {
        Explanation result = new Explanation();
        result.setDescription("weight(" + this.getQuery() + " in " + doc + "), product of:");
        String field = ((SpanQuery)this.getQuery()).getField();
        StringBuffer docFreqs = new StringBuffer();
        Iterator i = this.terms.iterator();
        while (i.hasNext()) {
            Term term = (Term)i.next();
            docFreqs.append(term.text());
            docFreqs.append("=");
            docFreqs.append(this.searcher.docFreq(term));
            if (!i.hasNext()) continue;
            docFreqs.append(" ");
        }
        Explanation idfExpl = new Explanation(this.idf, "idf(" + field + ": " + docFreqs + ")");
        Explanation queryExpl = new Explanation();
        queryExpl.setDescription("queryWeight(" + this.getQuery() + "), product of:");
        Explanation boostExpl = new Explanation(this.getQuery().getBoost(), "boost");
        if (this.getQuery().getBoost() != 1.0f) {
            queryExpl.addDetail(boostExpl);
        }
        queryExpl.addDetail(idfExpl);
        Explanation queryNormExpl = new Explanation(this.queryNorm, "queryNorm");
        queryExpl.addDetail(queryNormExpl);
        queryExpl.setValue(boostExpl.getValue() * idfExpl.getValue() * queryNormExpl.getValue());
        result.addDetail(queryExpl);
        Explanation fieldExpl = new Explanation();
        fieldExpl.setDescription("fieldWeight(" + field + ":" + this.query.toString(field) + " in " + doc + "), product of:");
        Explanation tfExpl = this.scorer(reader).explain(doc);
        fieldExpl.addDetail(tfExpl);
        fieldExpl.addDetail(idfExpl);
        Explanation fieldNormExpl = new Explanation();
        byte[] fieldNorms = reader.norms(field);
        float fieldNorm = fieldNorms != null ? Similarity.decodeNorm(fieldNorms[doc]) : 0.0f;
        fieldNormExpl.setValue(fieldNorm);
        fieldNormExpl.setDescription("fieldNorm(field=" + field + ", doc=" + doc + ")");
        fieldExpl.addDetail(fieldNormExpl);
        fieldExpl.setValue(tfExpl.getValue() * idfExpl.getValue() * fieldNormExpl.getValue());
        result.addDetail(fieldExpl);
        result.setValue(queryExpl.getValue() * fieldExpl.getValue());
        if (queryExpl.getValue() == 1.0f) {
            return fieldExpl;
        }
        return result;
    }
}

