/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.core.CollectionFactory;

public abstract class FactoryBeanRegistrySupport
extends DefaultSingletonBeanRegistry {
    private final Map factoryBeanObjectCache = CollectionFactory.createConcurrentMapIfPossible(16);

    protected Class getTypeForFactoryBean(FactoryBean factoryBean) {
        try {
            return factoryBean.getObjectType();
        }
        catch (Throwable ex) {
            this.logger.warn("FactoryBean threw exception from getObjectType, despite the contract saying that it should return null if the type of its object cannot be determined yet", ex);
            return null;
        }
    }

    protected Object getCachedObjectForFactoryBean(String beanName) {
        Object object = this.factoryBeanObjectCache.get(beanName);
        return object != NULL_OBJECT ? object : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectFromFactoryBean(FactoryBean factory, String beanName, boolean shouldPostProcess) {
        if (factory.isSingleton() && this.containsSingleton(beanName)) {
            Object object = this.getSingletonMutex();
            synchronized (object) {
                Object object2 = this.factoryBeanObjectCache.get(beanName);
                if (object2 == null) {
                    object2 = this.doGetObjectFromFactoryBean(factory, beanName, shouldPostProcess);
                    this.factoryBeanObjectCache.put(beanName, object2 != null ? object2 : NULL_OBJECT);
                }
                return object2 != NULL_OBJECT ? object2 : null;
            }
        }
        return this.doGetObjectFromFactoryBean(factory, beanName, shouldPostProcess);
    }

    private Object doGetObjectFromFactoryBean(final FactoryBean factory, final String beanName, final boolean shouldPostProcess) throws BeanCreationException {
        AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object object;
                try {
                    object = factory.getObject();
                }
                catch (FactoryBeanNotInitializedException ex) {
                    throw new BeanCurrentlyInCreationException(beanName, ex.toString());
                }
                catch (Throwable ex) {
                    throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
                }
                if (object == null && FactoryBeanRegistrySupport.this.isSingletonCurrentlyInCreation(beanName)) {
                    throw new BeanCurrentlyInCreationException(beanName, "FactoryBean which is currently in creation returned null from getObject");
                }
                if (object != null && shouldPostProcess) {
                    try {
                        object = FactoryBeanRegistrySupport.this.postProcessObjectFromFactoryBean(object, beanName);
                    }
                    catch (Throwable ex) {
                        throw new BeanCreationException(beanName, "Post-processing of the FactoryBean's object failed", ex);
                    }
                }
                return object;
            }
        }, acc);
    }

    protected Object postProcessObjectFromFactoryBean(Object object, String beanName) throws BeansException {
        return object;
    }

    protected FactoryBean getFactoryBean(String beanName, Object beanInstance) throws BeansException {
        if (!(beanInstance instanceof FactoryBean)) {
            throw new BeanCreationException(beanName, "Bean instance of type [" + beanInstance.getClass() + "] is not a FactoryBean");
        }
        return (FactoryBean)beanInstance;
    }

    protected void removeSingleton(String beanName) {
        super.removeSingleton(beanName);
        this.factoryBeanObjectCache.remove(beanName);
    }
}

