/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef TNT_MATERIALLEXEME_H
#define TNT_MATERIALLEXEME_H

#include "Lexeme.h"

namespace matc {

enum MaterialType {
    BLOCK,
    IDENTIFIER,
    UNKNOWN
};

class MaterialLexeme final: public Lexeme<MaterialType> {
public:
    MaterialLexeme(MaterialType type, const char* start, const char* end, size_t line, size_t pos) :
            Lexeme(type, start, end, line, pos) {
    }

    MaterialLexeme trimBlockMarkers() const {
        return { mType, mStart + 1, mEnd - 1, mLineNumber, mPosition };
    }
};

} // namespace matc

#endif //TNT_MATERIALLEXEME_H
