/* cartoonguy.c
**
**    code for high quality cartoon guy
**
**    Updated Version foobillard++ started at 12/2010
**    Copyright (C) 2010 - 2013 Holger Schaekel (foobillardplus@go4more.de)
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License Version 2 as
**    published by the Free Software Foundation;
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include "cartoonguy.h"

static int cartoonguy_id = -1;

/***********************************************************************
 *        This is a general routine to make a new material active      *
 ***********************************************************************/

void cartoonguy_Material_Parameters(float shininess, float r_diffuseColor, float g_diffuseColor, float b_diffuseColor, float r_specularColor, float g_specularColor, float b_specularColor) {
	GLfloat glfModelSpecular[4];
	// This causes the polygon's ambient & diffuse colors to be derived from the glColor() value.
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, shininess-40.0);
	/* Set the specular shading color. */
	glfModelSpecular[0] = r_specularColor;
	glfModelSpecular[1] = g_specularColor;
	glfModelSpecular[2] = b_specularColor;
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, glfModelSpecular);
	glColor3f(r_diffuseColor, g_diffuseColor, b_diffuseColor);
}

/***********************************************************************
 *                          Make an glcallist                          *
 ***********************************************************************/

void init_cartoonguy(void) {
	 if(cartoonguy_id != -1) {
	 	glDeleteLists(cartoonguy_id,1);
	 }
  fprintf(stderr,"Initialize cartoonguy graphics\n");
  cartoonguy_id = glGenLists(1);
  glNewList(cartoonguy_id, GL_COMPILE);
  cartoonguy();
  glEndList();
}

/***********************************************************************
 *                         display the guy                             *
 ***********************************************************************/

void display_cartoonguy(void) {
	 if(cartoonguy_id == -1) {
	 	init_cartoonguy();
	 } else {
	 	glCallList(cartoonguy_id);
	 }
}

/***********************************************************************
 *                           build the guy                             *
 *               Polygons for object (8098 polygons)                   *
 ***********************************************************************/

void cartoonguy(void) {
	static const GLfloat VertexData[] = {
		1.90001f, -0.850983f, -2.96807f, 1.90001f, -0.850983f, -2.96807f, 1.90001f, -0.850983f, -2.96807f, 
		1.90001f, -0.850983f, -2.96807f, 1.90021f, -0.863505f, -2.96902f, 
		1.90021f, -0.863505f, -2.96902f, 1.90021f, -0.863505f, -2.96902f, 
		1.90994f, -0.134627f, -3.07274f, 1.90994f, -0.134627f, -3.07274f, 
		1.90994f, -0.134627f, -3.07274f, 1.90994f, -0.134627f, -3.07274f, 
		1.90994f, -0.134627f, -3.07274f, 1.91068f, -0.839224f, -2.96709f, 
		1.91068f, -0.839224f, -2.96709f, 1.91068f, -0.839224f, -2.96709f, 
		1.91091f, -0.145017f, -3.06507f, 1.91091f, -0.145017f, -3.06507f, 
		1.91091f, -0.145017f, -3.06507f, 1.91150f, -0.132363f, -3.06691f, 
		1.91150f, -0.132363f, -3.06691f, 1.91150f, -0.132363f, -3.06691f, 
		1.91167f, -0.120606f, -3.07745f, 1.91167f, -0.120606f, -3.07745f, 
		1.91167f, -0.120606f, -3.07745f, 1.91231f, -0.141036f, -3.06006f, 
		1.91231f, -0.141036f, -3.06006f, 1.91231f, -0.141036f, -3.06006f, 
		1.91231f, -0.141036f, -3.06006f, 1.91237f, -0.103698f, -3.08170f, 
		1.91237f, -0.103698f, -3.08170f, 1.91237f, -0.103698f, -3.08170f, 
		1.91288f, -0.137270f, -3.07725f, 1.91288f, -0.137270f, -3.07725f, 
		1.91288f, -0.137270f, -3.07725f, 1.91288f, -0.137270f, -3.07725f, 
		1.91288f, -0.137270f, -3.07725f, 1.91330f, -0.119522f, -3.07116f, 
		1.91392f, -0.0887790f, -3.08584f, 1.91395f, 0.982062f, -2.95949f, 
		1.91395f, 0.982062f, -2.95949f, 1.91395f, 0.982062f, -2.95949f, 
		1.91428f, -0.151700f, -3.05599f, 1.91428f, -0.151700f, -3.05599f, 
		1.91428f, -0.151700f, -3.05599f, 1.91428f, -0.151700f, -3.05599f, 
		1.91428f, -0.151700f, -3.05599f, 1.91436f, -0.100245f, -3.08935f, 
		1.91436f, -0.100245f, -3.08935f, 1.91436f, -0.100245f, -3.08935f, 
		1.91444f, -0.148177f, -3.06934f, 1.91447f, -0.117031f, -3.08394f, 
		1.91447f, -0.117031f, -3.08394f, 1.91447f, -0.117031f, -3.08394f, 
		1.91447f, -0.117031f, -3.08394f, 1.91484f, -0.108443f, -3.07362f, 
		1.91484f, -0.108443f, -3.07362f, 1.91484f, -0.108443f, -3.07362f, 
		1.91515f, -0.0986140f, -3.07600f, 1.91515f, -0.0986140f, -3.07600f, 
		1.91515f, -0.0986140f, -3.07600f, 1.91559f, -0.0892657f, -3.09267f, 
		1.91628f, -0.0868277f, -3.07810f, 1.91628f, -0.0868277f, -3.07810f, 
		1.91628f, -0.0868277f, -3.07810f, 1.91628f, -0.0868277f, -3.07810f, 
		1.91628f, -0.0868277f, -3.07810f, 1.91633f, -0.157586f, -3.04920f, 
		1.91633f, -0.157586f, -3.04920f, 1.91633f, -0.157586f, -3.04920f, 
		1.91683f, -0.131182f, -3.06364f, 1.91683f, -0.131182f, -3.06364f, 
		1.91746f, -0.137839f, -3.05847f, 1.91746f, -0.137839f, -3.05847f, 
		1.91795f, -0.154736f, -3.06052f, 1.91795f, -0.0777703f, -3.08818f, 
		1.91836f, -0.138454f, -3.07840f, 1.91836f, -0.138454f, -3.07840f, 
		1.91836f, -0.138454f, -3.07840f, 1.91853f, -0.156071f, -3.04068f, 
		1.91853f, -0.156071f, -3.04068f, 1.91919f, -0.120944f, -3.06653f, 
		1.91919f, -0.120944f, -3.06653f, 1.91919f, -0.120944f, -3.06653f, 
		1.91944f, -0.150296f, -3.08321f, 1.91944f, -0.150296f, -3.08321f, 
		1.91944f, -0.150296f, -3.08321f, 1.91944f, -0.150296f, -3.08321f, 
		1.91944f, -0.150296f, -3.08321f, 1.91944f, -0.150296f, -3.08321f, 
		1.92003f, -0.163407f, -3.03908f, 1.92003f, -0.163407f, -3.03908f, 
		1.92003f, -0.163407f, -3.03908f, 1.92003f, -0.163407f, -3.03908f, 
		1.92015f, -0.123719f, -3.08357f, 1.92015f, -0.123719f, -3.08357f, 
		1.92015f, -0.123719f, -3.08357f, 1.92039f, -0.149023f, -3.07119f, 
		1.92039f, -0.149023f, -3.07119f, 1.92039f, -0.149023f, -3.07119f, 
		1.92039f, -0.149023f, -3.07119f, 1.92048f, -0.161007f, -3.05353f, 
		1.92081f, -0.0931427f, -3.09875f, 1.92108f, -0.148325f, -3.07668f, 
		1.92108f, -0.148325f, -3.07668f, 1.92108f, -0.148325f, -3.07668f, 
		1.92124f, -0.103745f, -3.09533f, 1.92124f, -0.103745f, -3.09533f, 
		1.92124f, -0.103745f, -3.09533f, 1.92126f, -0.110404f, -3.08872f, 
		1.92126f, -0.110404f, -3.08872f, 1.92126f, -0.110404f, -3.08872f, 
		1.92126f, -0.110404f, -3.08872f, 1.92126f, -0.110404f, -3.08872f, 
		1.92126f, -0.110404f, -3.08872f, 1.92127f, -0.107790f, -3.07095f, 
		1.92127f, -0.107790f, -3.07095f, 1.92127f, -0.107790f, -3.07095f, 
		1.92132f, -0.162383f, -3.07338f, 1.92132f, -0.162383f, -3.07338f, 
		1.92132f, -0.162383f, -3.07338f, 1.92132f, -0.162383f, -3.07338f, 
		1.92132f, -0.162383f, -3.07338f, 1.92157f, -0.0754740f, -3.07901f, 
		1.92157f, -0.0754740f, -3.07901f, 1.92157f, -0.0754740f, -3.07901f, 
		1.92157f, -0.0754740f, -3.07901f, 1.92188f, -0.150360f, -3.04402f, 
		1.92188f, -0.150360f, -3.04402f, 1.92202f, -0.870433f, -2.96777f, 
		1.92225f, -0.0514300f, -3.06803f, 1.92225f, -0.0514300f, -3.06803f, 
		1.92225f, -0.0514300f, -3.06803f, 1.92229f, -0.164123f, -3.03479f, 
		1.92229f, -0.164123f, -3.03479f, 1.92243f, -0.0731110f, -3.09744f, 
		1.92252f, -0.0930678f, -3.07248f, 1.92252f, -0.0930678f, -3.07248f, 
		1.92261f, -0.157473f, -3.06889f, 1.92261f, -0.157473f, -3.06889f, 
		1.92277f, -0.0570520f, -3.08382f, 1.92277f, -0.0570520f, -3.08382f, 
		1.92277f, -0.0570520f, -3.08382f, 1.92277f, -0.0570520f, -3.08382f, 
		1.92282f, -0.152634f, -3.08845f, 1.92282f, -0.152634f, -3.08845f, 
		1.92282f, -0.152634f, -3.08845f, 1.92282f, -0.152634f, -3.08845f, 
		1.92284f, -0.159046f, -3.03167f, 1.92284f, -0.159046f, -3.03167f, 
		1.92284f, -0.0634660f, -3.09022f, 1.92293f, -0.0670540f, -3.08031f, 
		1.92293f, -0.0670540f, -3.08031f, 1.92297f, -0.106464f, -3.09859f, 
		1.92304f, -0.0858545f, -3.10154f, 1.92327f, -0.122567f, -3.09142f, 
		1.92327f, -0.122567f, -3.09142f, 1.92327f, -0.122567f, -3.09142f, 
		1.92327f, -0.122567f, -3.09142f, 1.92335f, -0.132975f, -3.06557f, 
		1.92335f, -0.132975f, -3.06557f, 1.92335f, -0.132975f, -3.06557f, 
		1.92335f, -0.132975f, -3.06557f, 1.92335f, -0.132975f, -3.06557f, 
		1.92335f, -0.132975f, -3.06557f, 1.92377f, -0.110145f, -3.09065f, 
		1.92377f, -0.110145f, -3.09065f, 1.92384f, -0.114263f, -3.09377f, 
		1.92384f, -0.114263f, -3.09377f, 1.92384f, -0.114263f, -3.09377f, 
		1.92384f, -0.114263f, -3.09377f, 1.92384f, -0.114263f, -3.09377f, 
		1.92389f, -0.138091f, -3.07557f, 1.92409f, -0.139013f, -3.06093f, 
		1.92410f, -0.130206f, -3.08239f, 1.92410f, -0.130206f, -3.08239f, 
		1.92410f, -0.130206f, -3.08239f, 1.92410f, -0.130206f, -3.08239f, 
		1.92410f, -0.130206f, -3.08239f, 1.92417f, -0.155762f, -3.06269f, 
		1.92417f, -0.155762f, -3.06269f, 1.92417f, -0.155762f, -3.06269f, 
		1.92417f, -0.155762f, -3.06269f, 1.92443f, -0.0615030f, -3.05755f, 
		1.92444f, -0.863676f, -2.90674f, 1.92444f, -0.863676f, -2.90674f, 
		1.92444f, -0.863676f, -2.90674f, 1.92471f, -0.0623950f, -3.07111f, 
		1.92471f, -0.0623950f, -3.07111f, 1.92471f, -0.0623950f, -3.07111f, 
		1.92471f, -0.0623950f, -3.07111f, 1.92471f, -0.0623950f, -3.07111f, 
		1.92482f, -0.153355f, -3.03805f, 1.92482f, -0.153355f, -3.03805f, 
		1.92482f, -0.153355f, -3.03805f, 1.92512f, -0.165889f, -3.07785f, 
		1.92525f, -0.167232f, -3.04353f, 1.92527f, -0.166685f, -3.02847f, 
		1.92527f, -0.166685f, -3.02847f, 1.92536f, -0.0869390f, -3.07346f, 
		1.92536f, -0.0869390f, -3.07346f, 1.92541f, -0.125798f, -3.06677f, 
		1.92541f, -0.125798f, -3.06677f, 1.92541f, -0.125798f, -3.06677f, 
		1.92541f, -0.125798f, -3.06677f, 1.92554f, -0.0468160f, -3.07858f, 
		1.92554f, -0.0468160f, -3.07858f, 1.92554f, -0.0468160f, -3.07858f, 
		1.92554f, -0.0468160f, -3.07858f, 1.92554f, -0.0468160f, -3.07858f, 
		1.92554f, -0.0468160f, -3.07858f, 1.92568f, -0.125801f, -3.07959f, 
		1.92581f, 1.01614f, -2.91185f, 1.92581f, 1.01614f, -2.91185f, 
		1.92582f, -0.146802f, -3.06949f, 1.92582f, -0.146802f, -3.06949f, 
		1.92582f, -0.146802f, -3.06949f, 1.92591f, -0.130810f, -3.09462f, 
		1.92600f, -0.0521930f, -3.09108f, 1.92608f, -0.0687610f, -3.06486f, 
		1.92608f, -0.0687610f, -3.06486f, 1.92616f, -0.847858f, -2.90419f, 
		1.92616f, -0.847858f, -2.90419f, 1.92616f, -0.847858f, -2.90419f, 
		1.92616f, -0.847858f, -2.90419f, 1.92637f, -0.108970f, -3.10278f, 
		1.92664f, -0.117604f, -3.09886f, 1.92664f, -0.117604f, -3.09886f, 
		1.92664f, -0.117604f, -3.09886f, 1.92664f, -0.117604f, -3.09886f, 
		1.92664f, -0.117604f, -3.09886f, 1.92667f, -0.135704f, -3.07056f, 
		1.92667f, -0.135704f, -3.07056f, 1.92673f, -0.161829f, -3.05633f, 
		1.92673f, -0.161829f, -3.05633f, 1.92675f, -0.170175f, -3.06102f, 
		1.92675f, -0.170175f, -3.06102f, 1.92675f, -0.170175f, -3.06102f, 
		1.92679f, -0.115917f, -3.08330f, 1.92687f, -0.146917f, -3.07338f, 
		1.92687f, -0.146917f, -3.07338f, 1.92687f, -0.117414f, -3.06944f, 
		1.92687f, -0.117414f, -3.06944f, 1.92687f, -0.117414f, -3.06944f, 
		1.92717f, 0.895938f, -2.96553f, 1.92717f, 0.895938f, -2.96553f, 
		1.92717f, 0.895938f, -2.96553f, 1.92730f, -0.110457f, -3.07298f, 
		1.92735f, -0.0982730f, -3.10678f, 1.92740f, -0.167424f, -3.04080f, 
		1.92745f, -0.162100f, -3.02473f, 1.92745f, -0.162100f, -3.02473f, 
		1.92745f, -0.162100f, -3.02473f, 1.92745f, -0.162100f, -3.02473f, 
		1.92755f, -0.114754f, -3.08584f, 1.92755f, -0.114754f, -3.08584f, 
		1.92755f, -0.114754f, -3.08584f, 1.92755f, -0.114754f, -3.08584f, 
		1.92755f, -0.114754f, -3.08584f, 1.92755f, -0.114754f, -3.08584f, 
		1.92755f, -0.114754f, -3.08584f, 1.92755f, -0.114754f, -3.08584f, 
		1.92774f, -0.0735760f, -3.04995f, 1.92780f, -0.0817145f, -3.07441f, 
		1.92780f, -0.0817145f, -3.07441f, 1.92786f, -0.864625f, -3.01998f, 
		1.92786f, -0.864625f, -3.01998f, 1.92799f, -0.153411f, -3.06780f, 
		1.92799f, -0.153411f, -3.06780f, 1.92801f, -0.142485f, -3.06541f, 
		1.92801f, -0.142485f, -3.06541f, 1.92809f, -0.0409970f, -3.06353f, 
		1.92809f, -0.0409970f, -3.06353f, 1.92809f, -0.0409970f, -3.06353f, 
		1.92822f, -0.0614500f, -3.07455f, 1.92822f, -0.0614500f, -3.07455f, 
		1.92822f, -0.0614500f, -3.07455f, 1.92823f, -0.105370f, -3.07457f, 
		1.92831f, -0.112332f, -3.08476f, 1.92831f, -0.112332f, -3.08476f, 
		1.92831f, -0.112332f, -3.08476f, 1.92839f, -0.155142f, -3.03162f, 
		1.92839f, -0.155142f, -3.03162f, 1.92839f, -0.155142f, -3.03162f, 
		1.92848f, -0.0872380f, -3.04192f, 1.92848f, -0.0872380f, -3.04192f, 
		1.92848f, -0.0872380f, -3.04192f, 1.92851f, -0.849577f, -3.02048f, 
		1.92851f, -0.849577f, -3.02048f, 1.92851f, -0.849577f, -3.02048f, 
		1.92862f, -0.151154f, -3.04712f, 1.92883f, -0.138263f, -3.07577f, 
		1.92883f, -0.138263f, -3.07577f, 1.92883f, -0.138263f, -3.07577f, 
		1.92883f, -0.138263f, -3.07577f, 1.92887f, -0.835609f, -2.91507f, 
		1.92887f, -0.835609f, -2.91507f, 1.92887f, -0.835609f, -2.91507f, 
		1.92887f, -0.835609f, -2.91507f, 1.92903f, -0.154277f, -3.08972f, 
		1.92903f, -0.154277f, -3.08972f, 1.92903f, -0.154277f, -3.08972f, 
		1.92914f, -0.0550890f, -3.05086f, 1.92914f, -0.0550890f, -3.05086f, 
		1.92914f, -0.0550890f, -3.05086f, 1.92924f, -0.0783610f, -3.05659f, 
		1.92924f, -0.0783610f, -3.05659f, 1.92937f, -0.0903976f, -3.10895f, 
		1.92937f, -0.0658100f, -3.07617f, 1.92937f, -0.0658100f, -3.07617f, 
		1.92937f, -0.0658100f, -3.07617f, 1.92937f, -0.0658100f, -3.07617f, 
		1.92939f, -0.121742f, -3.07416f, 1.92939f, -0.121742f, -3.07416f, 
		1.92940f, -0.0998760f, -3.03679f, 1.92940f, -0.0998760f, -3.03679f, 
		1.92940f, -0.0998760f, -3.03679f, 1.92940f, -0.0998760f, -3.03679f, 
		1.92963f, -0.0768590f, -3.07435f, 1.92963f, -0.0768590f, -3.07435f, 
		1.92979f, -0.0904440f, -3.04870f, 1.92979f, -0.0904440f, -3.04870f, 
		1.92995f, -0.0508230f, -3.10136f, 1.93022f, -0.176327f, -3.05267f, 
		1.93022f, -0.176327f, -3.05267f, 1.93037f, -0.834494f, -3.01629f, 
		1.93037f, -0.834494f, -3.01629f, 1.93062f, -0.173581f, -3.06575f, 
		1.93066f, -0.0720290f, -3.07426f, 1.93066f, -0.0720290f, -3.07426f, 
		1.93071f, -0.170690f, -3.04949f, 1.93071f, -0.170690f, -3.04949f, 
		1.93072f, -0.170616f, -3.02341f, 1.93072f, -0.170616f, -3.02341f, 
		1.93072f, -0.170616f, -3.02341f, 1.93089f, -0.111139f, -3.07877f, 
		1.93089f, -0.111139f, -3.07877f, 1.93089f, -0.111139f, -3.07877f, 
		1.93089f, -0.111139f, -3.07877f, 1.93089f, -0.111139f, -3.07877f, 
		1.93100f, -0.106000f, -3.03509f, 1.93100f, -0.106000f, -3.03509f, 
		1.93100f, -0.106000f, -3.03509f, 1.93115f, -0.0322800f, -3.07753f, 
		1.93123f, -0.105688f, -3.04324f, 1.93123f, -0.105688f, -3.04324f, 
		1.93138f, -0.158504f, -3.05618f, 1.93138f, -0.158504f, -3.05618f, 
		1.93138f, -0.158504f, -3.05618f, 1.93138f, -0.158504f, -3.05618f, 
		1.93153f, -0.166418f, -3.08042f, 1.93153f, -0.166418f, -3.08042f, 
		1.93153f, -0.166418f, -3.08042f, 1.93153f, -0.166418f, -3.08042f, 
		1.93163f, -0.167809f, -3.04690f, 1.93163f, -0.167809f, -3.04690f, 
		1.93172f, -0.133164f, -3.09610f, 1.93172f, -0.133164f, -3.09610f, 
		1.93172f, -0.133164f, -3.09610f, 1.93172f, -0.133164f, -3.09610f, 
		1.93172f, -0.133164f, -3.09610f, 1.93179f, -0.153574f, -3.04178f, 
		1.93182f, -0.0960200f, -3.07631f, 1.93192f, -0.827952f, -2.96581f, 
		1.93192f, -0.0696860f, -3.04359f, 1.93217f, -0.114105f, -3.03245f, 
		1.93236f, -0.158551f, -3.02517f, 1.93236f, -0.158551f, -3.02517f, 
		1.93236f, -0.158551f, -3.02517f, 1.93263f, -0.110710f, -3.08157f, 
		1.93263f, -0.110710f, -3.08157f, 1.93263f, -0.110710f, -3.08157f, 
		1.93272f, -0.118968f, -3.08181f, 1.93272f, -0.118968f, -3.08181f, 
		1.93272f, -0.118968f, -3.08181f, 1.93272f, -0.118968f, -3.08181f, 
		1.93272f, -0.118968f, -3.08181f, 1.93272f, -0.118968f, -3.08181f, 
		1.93272f, -0.118968f, -3.08181f, 1.93302f, -0.870433f, -2.93208f, 
		1.93304f, -0.0850210f, -3.03515f, 1.93314f, -0.155404f, -3.05140f, 
		1.93314f, -0.155404f, -3.05140f, 1.93314f, -0.155404f, -3.05140f, 
		1.93314f, -0.155404f, -3.05140f, 1.93341f, -0.0550330f, -3.10820f, 
		1.93344f, -0.166470f, -3.01938f, 1.93344f, -0.166470f, -3.01938f, 
		1.93344f, -0.166470f, -3.01938f, 1.93344f, -0.166470f, -3.01938f, 
		1.93355f, -0.118893f, -3.10093f, 1.93355f, -0.118893f, -3.10093f, 
		1.93355f, -0.118893f, -3.10093f, 1.93355f, -0.118893f, -3.10093f, 
		1.93355f, -0.118893f, -3.10093f, 1.93355f, -0.118893f, -3.10093f, 
		1.93381f, -0.148590f, -3.07575f, 1.93381f, -0.148590f, -3.07575f, 
		1.93381f, -0.148590f, -3.07575f, 1.93381f, -0.148590f, -3.07575f, 
		1.93385f, -0.168880f, -3.04303f, 1.93385f, -0.168880f, -3.04303f, 
		1.93386f, -0.117042f, -3.03774f, 1.93386f, -0.117042f, -3.03774f, 
		1.93392f, 0.940114f, -2.91259f, 1.93417f, 0.914936f, -2.95172f, 
		1.93425f, -0.0747034f, -3.11207f, 1.93428f, -0.0265136f, -3.09245f, 
		1.93433f, -0.173507f, -3.04226f, 1.93433f, -0.173507f, -3.04226f, 
		1.93450f, -0.113276f, -3.08248f, 1.93450f, -0.113276f, -3.08248f, 
		1.93450f, -0.113276f, -3.08248f, 1.93450f, -0.113276f, -3.08248f, 
		1.93469f, -0.180082f, -3.05712f, 1.93483f, -0.118946f, -3.02688f, 
		1.93484f, -0.0701940f, -3.06946f, 1.93484f, -0.0701940f, -3.06946f, 
		1.93484f, -0.0701940f, -3.06946f, 1.93486f, -0.0975960f, -3.03025f, 
		1.93497f, -0.154187f, -3.07088f, 1.93498f, -0.153837f, -3.08678f, 
		1.93509f, -0.103919f, -3.08030f, 1.93509f, -0.103919f, -3.08030f, 
		1.93509f, -0.103919f, -3.08030f, 1.93510f, 0.972884f, -2.94488f, 
		1.93546f, -0.179833f, -3.04240f, 1.93546f, -0.179833f, -3.04240f, 
		1.93547f, -0.167434f, -3.04872f, 1.93547f, -0.167434f, -3.04872f, 
		1.93549f, -0.0926551f, -3.05053f, 1.93549f, -0.0926551f, -3.05053f, 
		1.93549f, -0.0926551f, -3.05053f, 1.93549f, -0.0926551f, -3.05053f, 
		1.93549f, -0.0926551f, -3.05053f, 1.93549f, -0.0926551f, -3.05053f, 
		1.93557f, -0.162642f, -3.02056f, 1.93557f, -0.162642f, -3.02056f, 
		1.93557f, -0.162642f, -3.02056f, 1.93557f, -0.121554f, -3.02766f, 
		1.93567f, -0.0801510f, -3.05927f, 1.93567f, -0.0801510f, -3.05927f, 
		1.93568f, -0.155455f, -3.03501f, 1.93578f, -0.174481f, -3.02516f, 
		1.93578f, -0.174481f, -3.02516f, 1.93578f, -0.174481f, -3.02516f, 
		1.93578f, -0.174481f, -3.02516f, 1.93578f, -0.174481f, -3.02516f, 
		1.93590f, -0.0379730f, -3.10577f, 1.93621f, -0.101371f, -3.11052f, 
		1.93628f, -0.102122f, -3.03044f, 1.93634f, -0.139894f, -3.07711f, 
		1.93634f, -0.139894f, -3.07711f, 1.93634f, -0.139894f, -3.07711f, 
		1.93653f, 0.893462f, -2.92259f, 1.93677f, -0.0637660f, -3.07137f, 
		1.93677f, -0.0637660f, -3.07137f, 1.93677f, -0.0637660f, -3.07137f, 
		1.93677f, -0.0637660f, -3.07137f, 1.93679f, -0.0460250f, -3.11001f, 
		1.93698f, -0.110004f, -3.10741f, 1.93698f, -0.110004f, -3.10741f, 
		1.93698f, -0.110004f, -3.10741f, 1.93707f, -0.124214f, -3.03155f, 
		1.93707f, -0.124214f, -3.03155f, 1.93724f, -0.174305f, -3.06856f, 
		1.93724f, -0.174305f, -3.06856f, 1.93724f, -0.174305f, -3.06856f, 
		1.93724f, -0.174305f, -3.06856f, 1.93724f, -0.163515f, -3.07908f, 
		1.93724f, -0.163515f, -3.07908f, 1.93724f, -0.163515f, -3.07908f, 
		1.93729f, -0.171776f, -3.03690f, 1.93729f, -0.171776f, -3.03690f, 
		1.93729f, -0.171776f, -3.03690f, 1.93729f, -0.171776f, -3.03690f, 
		1.93749f, -0.164432f, -3.04526f, 1.93749f, -0.164432f, -3.04526f, 
		1.93749f, -0.164432f, -3.04526f, 1.93749f, -0.164432f, -3.04526f, 
		1.93764f, -0.109343f, -3.04463f, 1.93764f, -0.109343f, -3.04463f, 
		1.93764f, -0.109343f, -3.04463f, 1.93769f, -0.151355f, -3.08113f, 
		1.93769f, -0.151355f, -3.08113f, 1.93771f, -0.173130f, -3.02273f, 
		1.93771f, -0.173130f, -3.02273f, 1.93805f, -0.173211f, -3.03636f, 
		1.93805f, -0.173211f, -3.03636f, 1.93809f, -0.132681f, -3.09310f, 
		1.93809f, -0.132681f, -3.09310f, 1.93809f, -0.132681f, -3.09310f, 
		1.93813f, -0.0929190f, -3.08142f, 1.93833f, -0.179085f, -3.03796f, 
		1.93833f, -0.179085f, -3.03796f, 1.93833f, -0.179085f, -3.03796f, 
		1.93833f, -0.128120f, -3.08077f, 1.93833f, -0.128120f, -3.08077f, 
		1.93837f, -0.824871f, -2.93683f, 1.93837f, -0.824871f, -2.93683f, 
		1.93837f, -0.824871f, -2.93683f, 1.93874f, -0.168797f, -3.04426f, 
		1.93874f, -0.168797f, -3.04426f, 1.93874f, -0.168797f, -3.04426f, 
		1.93874f, -0.168797f, -3.04426f, 1.93892f, -0.0374590f, -3.06067f, 
		1.93892f, -0.0374590f, -3.06067f, 1.93892f, -0.0374590f, -3.06067f, 
		1.93905f, -0.0256610f, -3.07593f, 1.93905f, -0.0256610f, -3.07593f, 
		1.93905f, -0.0256610f, -3.07593f, 1.93909f, -0.173500f, -3.03049f, 
		1.93916f, -0.117508f, -3.03998f, 1.93916f, -0.117508f, -3.03998f, 
		1.93916f, -0.117508f, -3.03998f, 1.93919f, -0.119004f, -3.08399f, 
		1.93919f, -0.119004f, -3.08399f, 1.93919f, -0.119004f, -3.08399f, 
		1.93919f, -0.119004f, -3.08399f, 1.93919f, -0.119004f, -3.08399f, 
		1.93931f, -0.158073f, -3.07554f, 1.93931f, -0.158073f, -3.07554f, 
		1.93934f, -0.117014f, -3.10191f, 1.93934f, -0.117014f, -3.10191f, 
		1.93944f, -0.159076f, -3.02771f, 1.93945f, -0.119556f, -3.02141f, 
		1.93945f, -0.119556f, -3.02141f, 1.93945f, -0.119556f, -3.02141f, 
		1.93957f, -0.0528060f, -3.04827f, 1.93957f, -0.0528060f, -3.04827f, 
		1.93957f, -0.0528060f, -3.04827f, 1.93957f, -0.0528060f, -3.04827f, 
		1.93957f, -0.0528060f, -3.04827f, 1.93971f, -0.0251130f, -3.10617f, 
		1.93999f, -0.123500f, -3.03411f, 1.94014f, -0.0868490f, -3.08230f, 
		1.94022f, -0.159456f, -3.03960f, 1.94022f, -0.159456f, -3.03960f, 
		1.94049f, 0.880739f, -2.91180f, 1.94049f, 0.880739f, -2.91180f, 
		1.94049f, 0.880739f, -2.91180f, 1.94049f, 0.880739f, -2.91180f, 
		1.94049f, 0.880739f, -2.91180f, 1.94065f, -0.134945f, -3.08509f, 
		1.94065f, -0.134945f, -3.08509f, 1.94086f, -0.0687510f, -3.04021f, 
		1.94086f, -0.0687510f, -3.04021f, 1.94086f, -0.0687510f, -3.04021f, 
		1.94092f, -0.169891f, -3.02029f, 1.94092f, -0.169891f, -3.02029f, 
		1.94092f, -0.169891f, -3.02029f, 1.94092f, -0.169891f, -3.02029f, 
		1.94107f, -0.123247f, -3.02184f, 1.94107f, -0.123247f, -3.02184f, 
		1.94107f, -0.123247f, -3.02184f, 1.94107f, -0.123247f, -3.02184f, 
		1.94109f, -0.112773f, -3.10958f, 1.94113f, -0.183939f, -3.04689f, 
		1.94119f, -0.120840f, -3.09626f, 1.94119f, -0.120840f, -3.09626f, 
		1.94119f, -0.120840f, -3.09626f, 1.94119f, -0.120840f, -3.09626f, 
		1.94119f, -0.120840f, -3.09626f, 1.94124f, -0.0889170f, -3.11479f, 
		1.94127f, -0.180950f, -3.06016f, 1.94127f, -0.180950f, -3.06016f, 
		1.94130f, -0.0504517f, -3.11520f, 1.94135f, -0.106115f, -3.08569f, 
		1.94135f, -0.0166640f, -3.09071f, 1.94135f, -0.0166640f, -3.09071f, 
		1.94135f, -0.0166640f, -3.09071f, 1.94135f, -0.0166640f, -3.09071f, 
		1.94135f, -0.0166640f, -3.09071f, 1.94166f, -0.0837360f, -3.03144f, 
		1.94166f, -0.0837360f, -3.03144f, 1.94166f, -0.0837360f, -3.03144f, 
		1.94171f, -0.151708f, -3.09271f, 1.94171f, -0.151708f, -3.09271f, 
		1.94171f, -0.151708f, -3.09271f, 1.94171f, -0.151708f, -3.09271f, 
		1.94171f, -0.151708f, -3.09271f, 1.94176f, -0.164107f, -3.02188f, 
		1.94176f, -0.164107f, -3.02188f, 1.94176f, -0.164107f, -3.02188f, 
		1.94176f, -0.164107f, -3.02188f, 1.94176f, -0.164107f, -3.02188f, 
		1.94176f, -0.164107f, -3.02188f, 1.94177f, -0.0629310f, -3.07356f, 
		1.94177f, -0.0629310f, -3.07356f, 1.94177f, -0.0629310f, -3.07356f, 
		1.94177f, -0.0629310f, -3.07356f, 1.94217f, 0.987030f, -3.03798f, 
		1.94221f, -0.120465f, -3.10367f, 1.94221f, -0.120465f, -3.10367f, 
		1.94221f, -0.120465f, -3.10367f, 1.94237f, -0.0831290f, -3.08226f, 
		1.94249f, 0.873512f, -2.90666f, 1.94253f, -0.167908f, -3.05246f, 
		1.94272f, -0.119381f, -3.09674f, 1.94272f, -0.119381f, -3.09674f, 
		1.94295f, -0.178291f, -3.02950f, 1.94295f, -0.135362f, -3.09830f, 
		1.94295f, -0.135362f, -3.09830f, 1.94295f, -0.135362f, -3.09830f, 
		1.94296f, -0.167995f, -3.03523f, 1.94296f, -0.167995f, -3.03523f, 
		1.94296f, -0.167995f, -3.03523f, 1.94296f, -0.167995f, -3.03523f, 
		1.94299f, 0.908495f, -2.89254f, 1.94300f, -0.168457f, -3.03778f, 
		1.94300f, -0.168457f, -3.03778f, 1.94300f, -0.168457f, -3.03778f, 
		1.94301f, 0.881576f, -2.91629f, 1.94301f, 0.881576f, -2.91629f, 
		1.94301f, 0.881576f, -2.91629f, 1.94306f, 0.873485f, -2.90540f, 
		1.94306f, 0.873485f, -2.90540f, 1.94309f, -0.0722910f, -3.11675f, 
		1.94316f, -0.162422f, -3.03295f, 1.94316f, -0.162422f, -3.03295f, 
		1.94316f, -0.162422f, -3.03295f, 1.94316f, -0.162422f, -3.03295f, 
		1.94328f, -0.126470f, -3.10120f, 1.94328f, -0.126470f, -3.10120f, 
		1.94328f, -0.126470f, -3.10120f, 1.94328f, -0.126470f, -3.10120f, 
		1.94334f, -0.148920f, -3.08675f, 1.94334f, -0.148920f, -3.08675f, 
		1.94334f, -0.148920f, -3.08675f, 1.94334f, -0.148920f, -3.08675f, 
		1.94334f, -0.148920f, -3.08675f, 1.94349f, -0.180391f, -3.03094f, 
		1.94360f, -0.119043f, -3.08969f, 1.94360f, -0.119043f, -3.08969f, 
		1.94360f, -0.119043f, -3.08969f, 1.94360f, -0.119043f, -3.08969f, 
		1.94360f, -0.119043f, -3.08969f, 1.94369f, -0.182927f, -3.04437f, 
		1.94395f, -0.0670570f, -3.07850f, 1.94395f, -0.0670570f, -3.07850f, 
		1.94395f, -0.0670570f, -3.07850f, 1.94396f, -0.0960780f, -3.02624f, 
		1.94396f, -0.0960780f, -3.02624f, 1.94396f, -0.0960780f, -3.02624f, 
		1.94396f, -0.0960780f, -3.02624f, 1.94404f, 0.872545f, -2.90774f, 
		1.94404f, 0.872545f, -2.90774f, 1.94404f, 0.872545f, -2.90774f, 
		1.94406f, -0.173844f, -3.02838f, 1.94406f, -0.173844f, -3.02838f, 
		1.94406f, -0.173844f, -3.02838f, 1.94406f, -0.173844f, -3.02838f, 
		1.94406f, -0.173844f, -3.02838f, 1.94406f, -0.173844f, -3.02838f, 
		1.94434f, -0.170483f, -3.02743f, 1.94434f, -0.170483f, -3.02743f, 
		1.94434f, -0.170483f, -3.02743f, 1.94434f, -0.170483f, -3.02743f, 
		1.94440f, -0.0782200f, -3.05644f, 1.94452f, -0.126178f, -3.02451f, 
		1.94452f, -0.126178f, -3.02451f, 1.94452f, -0.126178f, -3.02451f, 
		1.94453f, -0.0911789f, -3.04753f, 1.94457f, -0.0663400f, -3.06703f, 
		1.94458f, -0.165772f, -3.02750f, 1.94458f, -0.165772f, -3.02750f, 
		1.94458f, -0.165772f, -3.02750f, 1.94466f, -0.131939f, -3.09173f, 
		1.94466f, -0.131939f, -3.09173f, 1.94466f, -0.131939f, -3.09173f, 
		1.94466f, -0.131939f, -3.09173f, 1.94484f, -0.121436f, -3.09494f, 
		1.94484f, -0.121436f, -3.09494f, 1.94484f, -0.121436f, -3.09494f, 
		1.94484f, -0.121436f, -3.09494f, 1.94484f, -0.121436f, -3.09494f, 
		1.94484f, -0.121436f, -3.09494f, 1.94499f, -0.153889f, -3.09779f, 
		1.94499f, -0.153889f, -3.09779f, 1.94499f, -0.153889f, -3.09779f, 
		1.94499f, -0.153889f, -3.09779f, 1.94520f, 0.924447f, -2.99807f, 
		1.94522f, -0.161342f, -3.08276f, 1.94522f, -0.161342f, -3.08276f, 
		1.94522f, -0.161342f, -3.08276f, 1.94522f, -0.161342f, -3.08276f, 
		1.94533f, -0.0605980f, -3.07241f, 1.94533f, -0.0605980f, -3.07241f, 
		1.94533f, -0.0605980f, -3.07241f, 1.94533f, -0.0605980f, -3.07241f, 
		1.94533f, -0.0605980f, -3.07241f, 1.94533f, -0.0605980f, -3.07241f, 
		1.94538f, 0.854920f, -2.92533f, 1.94554f, -0.143192f, -3.10168f, 
		1.94554f, -0.143192f, -3.10168f, 1.94554f, -0.143192f, -3.10168f, 
		1.94554f, -0.143192f, -3.10168f, 1.94560f, -0.168789f, -3.04902f, 
		1.94564f, -0.117671f, -3.01931f, 1.94564f, -0.117671f, -3.01931f, 
		1.94564f, -0.117671f, -3.01931f, 1.94564f, -0.117671f, -3.01931f, 
		1.94564f, -0.117671f, -3.01931f, 1.94585f, 0.897150f, -2.88030f, 
		1.94585f, 0.897150f, -2.88030f, 1.94585f, 0.897150f, -2.88030f, 
		1.94585f, 0.897150f, -2.88030f, 1.94586f, -0.176862f, -3.06088f, 
		1.94586f, -0.176862f, -3.06088f, 1.94586f, -0.176862f, -3.06088f, 
		1.94586f, -0.176862f, -3.06088f, 1.94587f, -0.109418f, -3.02188f, 
		1.94590f, -0.156141f, -3.07954f, 1.94590f, -0.156141f, -3.07954f, 
		1.94594f, -0.0764770f, -3.08186f, 1.94601f, -0.102450f, -3.02476f, 
		1.94601f, -0.102450f, -3.02476f, 1.94601f, -0.102450f, -3.02476f, 
		1.94602f, -0.118273f, -3.09251f, 1.94602f, -0.118273f, -3.09251f, 
		1.94602f, -0.118273f, -3.09251f, 1.94602f, -0.113538f, -3.11372f, 
		1.94614f, 0.959306f, -2.96253f, 1.94614f, 0.959306f, -2.96253f, 
		1.94649f, -0.121581f, -3.10978f, 1.94649f, -0.121581f, -3.10978f, 
		1.94649f, -0.121581f, -3.10978f, 1.94661f, -0.102780f, -3.11732f, 
		1.94665f, -0.00987100f, -3.10350f, 1.94665f, -0.00987100f, -3.10350f, 
		1.94669f, -0.114928f, -3.09130f, 1.94669f, -0.114928f, -3.09130f, 
		1.94669f, -0.114928f, -3.09130f, 1.94691f, -0.0723710f, -3.08015f, 
		1.94691f, -0.0723710f, -3.08015f, 1.94691f, -0.0723710f, -3.08015f, 
		1.94703f, -0.130893f, -3.10566f, 1.94703f, -0.130893f, -3.10566f, 
		1.94703f, -0.130893f, -3.10566f, 1.94705f, -0.171826f, -3.05770f, 
		1.94705f, -0.171826f, -3.05770f, 1.94721f, -0.124083f, -3.02964f, 
		1.94721f, -0.124083f, -3.02964f, 1.94721f, -0.124083f, -3.02964f, 
		1.94721f, -0.124083f, -3.02964f, 1.94728f, -0.107115f, -3.04169f, 
		1.94774f, -0.0700750f, -3.04309f, 1.94774f, -0.0700750f, -3.04309f, 
		1.94786f, -0.0545370f, -3.05203f, 1.94786f, -0.0545370f, -3.05203f, 
		1.94790f, -0.184458f, -3.04996f, 1.94790f, -0.184458f, -3.04996f, 
		1.94812f, -0.116235f, -3.03640f, 1.94830f, -0.169697f, -3.03027f, 
		1.94830f, -0.169697f, -3.03027f, 1.94830f, -0.169697f, -3.03027f, 
		1.94830f, -0.110147f, -3.02114f, 1.94831f, 0.899917f, -2.89102f, 
		1.94831f, 0.899917f, -2.89102f, 1.94835f, -0.0858315f, -3.03312f, 
		1.94835f, -0.0858315f, -3.03312f, 1.94858f, -0.870433f, -2.99541f, 
		1.94863f, -0.181342f, -3.02602f, 1.94863f, -0.181342f, -3.02602f, 
		1.94863f, -0.181342f, -3.02602f, 1.94863f, -0.181342f, -3.02602f, 
		1.94863f, -0.181342f, -3.02602f, 1.94873f, -0.0409000f, -3.06106f, 
		1.94873f, -0.0409000f, -3.06106f, 1.94873f, -0.0409000f, -3.06106f, 
		1.94873f, -0.0409000f, -3.06106f, 1.94891f, -0.164487f, -3.08682f, 
		1.94891f, -0.164487f, -3.08682f, 1.94891f, -0.164487f, -3.08682f, 
		1.94906f, -0.147236f, -3.08328f, 1.94906f, -0.147236f, -3.08328f, 
		1.94925f, 0.886906f, -2.87406f, 1.94925f, 0.886906f, -2.87406f, 
		1.94935f, 0.859312f, -3.00364f, 1.94935f, 0.859312f, -3.00364f, 
		1.94935f, 0.859312f, -3.00364f, 1.94935f, 0.859312f, -3.00364f, 
		1.94943f, -0.0397750f, -3.11941f, 1.94959f, -0.0742160f, -3.05011f, 
		1.94959f, -0.0742160f, -3.05011f, 1.94980f, 0.858956f, -2.95882f, 
		1.94986f, -0.0878667f, -3.04073f, 1.94986f, -0.0878667f, -3.04073f, 
		1.94991f, -0.0278400f, -3.07120f, 1.94991f, -0.0278400f, -3.07120f, 
		1.94991f, -0.0278400f, -3.07120f, 1.95005f, -0.168386f, -3.04237f, 
		1.95015f, 0.866727f, -2.90015f, 1.95026f, -0.139511f, -3.08534f, 
		1.95026f, -0.139511f, -3.08534f, 1.95026f, -0.139511f, -3.08534f, 
		1.95026f, -0.139511f, -3.08534f, 1.95033f, -0.0604860f, -3.06024f, 
		1.95033f, -0.0604860f, -3.06024f, 1.95056f, -0.151777f, -3.07915f, 
		1.95056f, -0.151777f, -3.07915f, 1.95056f, -0.104321f, -3.09326f, 
		1.95059f, -0.184030f, -3.04602f, 1.95059f, -0.184030f, -3.04602f, 
		1.95059f, -0.184030f, -3.04602f, 1.95065f, 0.825207f, -3.12247f, 
		1.95065f, 0.825207f, -3.12247f, 1.95065f, 0.825207f, -3.12247f, 
		1.95067f, -0.175913f, -3.02389f, 1.95067f, -0.175913f, -3.02389f, 
		1.95067f, -0.175913f, -3.02389f, 1.95067f, -0.175913f, -3.02389f, 
		1.95095f, -0.164695f, -3.07299f, 1.95095f, -0.164695f, -3.07299f, 
		1.95095f, -0.164695f, -3.07299f, 1.95095f, -0.119180f, -3.09237f, 
		1.95095f, -0.119180f, -3.09237f, 1.95095f, -0.119180f, -3.09237f, 
		1.95095f, -0.119180f, -3.09237f, 1.95095f, -0.119180f, -3.09237f, 
		1.95095f, -0.119180f, -3.09237f, 1.95097f, -0.120200f, -3.02113f, 
		1.95097f, -0.120200f, -3.02113f, 1.95097f, -0.120200f, -3.02113f, 
		1.95097f, -0.120200f, -3.02113f, 1.95098f, -0.173239f, -3.05255f, 
		1.95098f, -0.173239f, -3.05255f, 1.95115f, -0.154432f, -3.09954f, 
		1.95115f, -0.154432f, -3.09954f, 1.95115f, -0.154432f, -3.09954f, 
		1.95122f, 0.996436f, -2.91401f, 1.95122f, 0.996436f, -2.91401f, 
		1.95122f, 0.996436f, -2.91401f, 1.95122f, 0.996436f, -2.91401f, 
		1.95122f, 0.996436f, -2.91401f, 1.95129f, -0.0274660f, -3.12019f, 
		1.95162f, -0.0678840f, -3.12180f, 1.95170f, -0.130931f, -3.08847f, 
		1.95183f, -0.179582f, -3.05246f, 1.95183f, -0.179582f, -3.05246f, 
		1.95183f, -0.179582f, -3.05246f, 1.95183f, -0.179582f, -3.05246f, 
		1.95195f, 0.851435f, -2.91393f, 1.95198f, -0.0508170f, -3.06551f, 
		1.95198f, -0.0508170f, -3.06551f, 1.95210f, 0.891301f, -2.96010f, 
		1.95210f, 0.891301f, -2.96010f, 1.95214f, -0.172138f, -3.02594f, 
		1.95214f, -0.172138f, -3.02594f, 1.95214f, -0.172138f, -3.02594f, 
		1.95214f, -0.172138f, -3.02594f, 1.95215f, 0.923137f, -3.05686f, 
		1.95227f, -0.113029f, -3.11658f, 1.95230f, -0.0199210f, -3.07942f, 
		1.95230f, -0.0199210f, -3.07942f, 1.95230f, -0.0199210f, -3.07942f, 
		1.95231f, -0.119745f, -3.02560f, 1.95231f, -0.119745f, -3.02560f, 
		1.95231f, -0.119745f, -3.02560f, 1.95234f, 0.985643f, -2.92441f, 
		1.95245f, -0.136710f, -3.10555f, 1.95245f, -0.136710f, -3.10555f, 
		1.95245f, -0.136710f, -3.10555f, 1.95246f, -0.102556f, -3.02715f, 
		1.95246f, -0.102556f, -3.02715f, 1.95260f, 0.886800f, -2.88022f, 
		1.95264f, -0.0507680f, -3.12201f, 1.95308f, -0.819993f, -2.98471f, 
		1.95317f, 0.859230f, -3.07598f, 1.95317f, 0.859230f, -3.07598f, 
		1.95317f, 0.859230f, -3.07598f, 1.95320f, 0.817610f, -3.10575f, 
		1.95320f, 0.817610f, -3.10575f, 1.95320f, 0.817610f, -3.10575f, 
		1.95333f, -0.104343f, -3.03421f, 1.95333f, -0.104343f, -3.03421f, 
		1.95333f, -0.104343f, -3.03421f, 1.95333f, -0.104343f, -3.03421f, 
		1.95333f, -0.104343f, -3.03421f, 1.95333f, -0.104343f, -3.03421f, 
		1.95366f, -0.184745f, -3.02826f, 1.95366f, -0.184745f, -3.02826f, 
		1.95366f, -0.184745f, -3.02826f, 1.95366f, -0.184745f, -3.02826f, 
		1.95386f, -0.112775f, -3.02976f, 1.95386f, -0.112775f, -3.02976f, 
		1.95386f, -0.112775f, -3.02976f, 1.95390f, -0.110964f, -3.02463f, 
		1.95390f, -0.110964f, -3.02463f, 1.95431f, -0.122109f, -3.11147f, 
		1.95431f, -0.122109f, -3.11147f, 1.95431f, -0.122109f, -3.11147f, 
		1.95434f, -0.0552500f, -3.07271f, 1.95434f, -0.0552500f, -3.07271f, 
		1.95434f, -0.0552500f, -3.07271f, 1.95436f, 0.952958f, -2.88306f, 
		1.95436f, -0.0947150f, -3.12124f, 1.95449f, -0.162271f, -3.06441f, 
		1.95449f, -0.162271f, -3.06441f, 1.95479f, -0.168129f, -3.07677f, 
		1.95486f, -0.164807f, -3.08956f, 1.95486f, -0.164807f, -3.08956f, 
		1.95486f, -0.164807f, -3.08956f, 1.95486f, -0.164807f, -3.08956f, 
		1.95490f, -0.0124680f, -3.12078f, 1.95490f, -0.0124680f, -3.12078f, 
		1.95490f, -0.0124680f, -3.12078f, 1.95490f, -0.168326f, -3.06532f, 
		1.95490f, -0.168326f, -3.06532f, 1.95490f, -0.168326f, -3.06532f, 
		1.95490f, -0.168326f, -3.06532f, 1.95497f, -0.102245f, -3.12050f, 
		1.95506f, -0.0913638f, -3.09477f, 1.95520f, -0.169702f, -3.03375f, 
		1.95528f, 0.830265f, -2.92949f, 1.95538f, 0.828724f, -2.94536f, 
		1.95543f, -0.172788f, -3.04589f, 1.95543f, -0.172788f, -3.04589f, 
		1.95550f, -0.182484f, -3.02670f, 1.95550f, -0.182484f, -3.02670f, 
		1.95550f, -0.182484f, -3.02670f, 1.95568f, 0.881930f, -2.88306f, 
		1.95568f, 0.881930f, -2.88306f, 1.95569f, 0.850843f, -2.90869f, 
		1.95574f, 1.03187f, -2.88119f, 1.95574f, 1.03187f, -2.88119f, 
		1.95616f, -0.183964f, -3.03915f, 1.95633f, -0.148223f, -3.08586f, 
		1.95633f, -0.148223f, -3.08586f, 1.95633f, -0.148223f, -3.08586f, 
		1.95633f, -0.148223f, -3.08586f, 1.95633f, -0.148223f, -3.08586f, 
		1.95633f, -0.148223f, -3.08586f, 1.95640f, 0.839353f, -3.07772f, 
		1.95640f, 0.839353f, -3.07772f, 1.95640f, 0.839353f, -3.07772f, 
		1.95694f, 0.00328300f, -3.10698f, 1.95694f, 0.00328300f, -3.10698f, 
		1.95701f, -0.185086f, -3.03328f, 1.95701f, -0.185086f, -3.03328f, 
		1.95701f, -0.185086f, -3.03328f, 1.95702f, 0.832129f, -2.92330f, 
		1.95711f, -0.152092f, -3.08230f, 1.95735f, -0.153416f, -3.09682f, 
		1.95744f, -0.0417830f, -3.06982f, 1.95744f, -0.0417830f, -3.06982f, 
		1.95744f, -0.0417830f, -3.06982f, 1.95744f, -0.0417830f, -3.06982f, 
		1.95744f, -0.0417830f, -3.06982f, 1.95789f, -0.140391f, -3.08743f, 
		1.95789f, -0.140391f, -3.08743f, 1.95789f, -0.140391f, -3.08743f, 
		1.95812f, -0.178252f, -3.02577f, 1.95812f, -0.178252f, -3.02577f, 
		1.95812f, -0.178252f, -3.02577f, 1.95812f, -0.178252f, -3.02577f, 
		1.95812f, -0.178252f, -3.02577f, 1.95812f, -0.178252f, -3.02577f, 
		1.95814f, 0.840424f, -3.07680f, 1.95814f, 0.840424f, -3.07680f, 
		1.95814f, 0.840424f, -3.07680f, 1.95814f, 0.840424f, -3.07680f, 
		1.95826f, -0.172916f, -3.02802f, 1.95826f, -0.172916f, -3.02802f, 
		1.95826f, -0.172916f, -3.02802f, 1.95826f, -0.172916f, -3.02802f, 
		1.95826f, -0.172916f, -3.02802f, 1.95828f, 1.03880f, -3.01069f, 
		1.95832f, -0.0838910f, -3.09460f, 1.95844f, 0.863116f, -2.89586f, 
		1.95845f, 0.850544f, -2.90477f, 1.95849f, 0.828545f, -2.97023f, 
		1.95852f, 0.818746f, -3.10655f, 1.95852f, 0.818746f, -3.10655f, 
		1.95852f, 0.818746f, -3.10655f, 1.95852f, 0.851298f, -2.92493f, 
		1.95864f, 0.844460f, -2.92840f, 1.95872f, -0.110160f, -3.11820f, 
		1.95872f, -0.110160f, -3.11820f, 1.95872f, -0.110160f, -3.11820f, 
		1.95883f, 0.00169700f, -3.12291f, 1.95883f, 0.00169700f, -3.12291f, 
		1.95883f, 0.00169700f, -3.12291f, 1.95883f, 0.00169700f, -3.12291f, 
		1.95883f, 0.00169700f, -3.12291f, 1.95883f, 0.00169700f, -3.12291f, 
		1.95888f, 0.847342f, -2.93805f, 1.95889f, -0.118835f, -3.09605f, 
		1.95891f, -0.163354f, -3.05591f, 1.95891f, -0.163354f, -3.05591f, 
		1.95891f, -0.158876f, -3.06363f, 1.95891f, -0.158876f, -3.06363f, 
		1.95902f, 0.856362f, -2.93773f, 1.95905f, -0.131233f, -3.09073f, 
		1.95905f, -0.131233f, -3.09073f, 1.95905f, -0.131233f, -3.09073f, 
		1.95908f, -0.136469f, -3.10226f, 1.95911f, 0.848296f, -3.05458f, 
		1.95911f, 0.848296f, -3.05458f, 1.95911f, 0.848296f, -3.05458f, 
		1.95940f, 0.802165f, -2.92025f, 1.95950f, 0.837996f, -2.93453f, 
		1.95951f, -0.173676f, -3.03814f, 1.95951f, -0.173676f, -3.03814f, 
		1.95951f, -0.173676f, -3.03814f, 1.95951f, -0.173676f, -3.03814f, 
		1.95951f, -0.173676f, -3.03814f, 1.95951f, -0.173676f, -3.03814f, 
		1.95953f, -0.172258f, -3.06842f, 1.95958f, -0.0123570f, -3.08957f, 
		1.95958f, -0.0123570f, -3.08957f, 1.95979f, 0.834838f, -2.91373f, 
		1.95982f, -0.161294f, -3.08937f, 1.95982f, -0.161294f, -3.08937f, 
		1.95982f, -0.161294f, -3.08937f, 1.95982f, -0.161294f, -3.08937f, 
		1.95982f, -0.161294f, -3.08937f, 1.95994f, 0.841866f, -2.91881f, 
		1.96003f, 0.863018f, -2.92856f, 1.96005f, 0.861247f, -2.99418f, 
		1.96024f, -0.179801f, -3.03903f, 1.96024f, -0.179801f, -3.03903f, 
		1.96024f, -0.179801f, -3.03903f, 1.96024f, -0.179801f, -3.03903f, 
		1.96033f, -0.0518810f, -3.12599f, 1.96037f, -0.150806f, -3.09137f, 
		1.96037f, -0.150806f, -3.09137f, 1.96061f, 0.838222f, -2.94454f, 
		1.96066f, 0.850311f, -2.94752f, 1.96072f, 0.832217f, -2.92781f, 
		1.96074f, 0.850958f, -2.91288f, 1.96076f, 0.862660f, -2.91906f, 
		1.96077f, -0.115880f, -3.11277f, 1.96077f, -0.115880f, -3.11277f, 
		1.96077f, -0.115880f, -3.11277f, 1.96077f, -0.115880f, -3.11277f, 
		1.96080f, 0.876933f, -2.87890f, 1.96085f, 0.859837f, -2.94445f, 
		1.96099f, -0.168817f, -3.05418f, 1.96099f, -0.168817f, -3.05418f, 
		1.96099f, -0.168817f, -3.05418f, 1.96099f, -0.168817f, -3.05418f, 
		1.96100f, 0.863447f, -2.89423f, 1.96100f, 0.863447f, -2.89423f, 
		1.96100f, 0.863447f, -2.89423f, 1.96105f, -0.168877f, -3.07929f, 
		1.96105f, -0.168877f, -3.07929f, 1.96111f, -0.122174f, -3.10691f, 
		1.96111f, -0.122174f, -3.10691f, 1.96111f, -0.122174f, -3.10691f, 
		1.96121f, 0.866152f, -2.93806f, 1.96138f, -0.175454f, -3.03286f, 
		1.96138f, -0.175454f, -3.03286f, 1.96142f, 0.833060f, -2.91834f, 
		1.96144f, -0.155720f, -3.08659f, 1.96144f, -0.155720f, -3.08659f, 
		1.96158f, 0.831623f, -2.94051f, 1.96197f, -0.180097f, -3.03177f, 
		1.96197f, -0.180097f, -3.03177f, 1.96197f, -0.180097f, -3.03177f, 
		1.96197f, -0.180097f, -3.03177f, 1.96197f, -0.180097f, -3.03177f, 
		1.96197f, -0.180097f, -3.03177f, 1.96203f, 0.918875f, -2.86466f, 
		1.96207f, -0.104679f, -3.09887f, 1.96207f, -0.159055f, -3.05926f, 
		1.96207f, -0.159055f, -3.05926f, 1.96207f, -0.159055f, -3.05926f, 
		1.96207f, -0.159055f, -3.05926f, 1.96207f, -0.159055f, -3.05926f, 
		1.96207f, -0.159055f, -3.05926f, 1.96214f, 0.768853f, -3.10849f, 
		1.96214f, 0.768853f, -3.10849f, 1.96221f, -0.0556110f, -3.08112f, 
		1.96227f, 0.816631f, -2.90613f, 1.96231f, 0.837511f, -2.90562f, 
		1.96234f, -0.135935f, -3.09535f, 1.96234f, -0.135935f, -3.09535f, 
		1.96250f, -0.160856f, -3.05074f, 1.96250f, -0.160856f, -3.05074f, 
		1.96270f, 0.776210f, -3.09047f, 1.96270f, 0.776210f, -3.09047f, 
		1.96279f, 0.825846f, -2.93373f, 1.96292f, 0.909898f, -2.85307f, 
		1.96292f, 0.909898f, -2.85307f, 1.96315f, 0.986275f, -3.03149f, 
		1.96336f, 0.782470f, -2.93739f, 1.96339f, 0.842772f, -2.90660f, 
		1.96362f, 0.796705f, -3.05007f, 1.96362f, 0.796705f, -3.05007f, 
		1.96362f, 0.796705f, -3.05007f, 1.96363f, -0.120133f, -3.10107f, 
		1.96363f, -0.120133f, -3.10107f, 1.96366f, -0.166474f, -3.05039f, 
		1.96366f, -0.166474f, -3.05039f, 1.96366f, 0.860707f, -2.89208f, 
		1.96370f, 0.843873f, -2.95644f, 1.96370f, 0.875065f, -2.93138f, 
		1.96388f, 0.868916f, -2.94737f, 1.96392f, -0.117666f, -3.10761f, 
		1.96392f, -0.117666f, -3.10761f, 1.96392f, -0.117666f, -3.10761f, 
		1.96392f, -0.117666f, -3.10761f, 1.96392f, -0.117666f, -3.10761f, 
		1.96392f, -0.117666f, -3.10761f, 1.96392f, -0.117666f, -3.10761f, 
		1.96398f, 0.822287f, -2.90088f, 1.96412f, 0.862497f, -2.95360f, 
		1.96415f, 0.855660f, -2.95710f, 1.96418f, 0.861110f, -2.90638f, 
		1.96448f, 0.874041f, -2.91869f, 1.96448f, -0.0353920f, -3.07674f, 
		1.96448f, -0.0353920f, -3.07674f, 1.96448f, -0.0353920f, -3.07674f, 
		1.96459f, 0.837448f, -2.90854f, 1.96471f, -0.115674f, -3.11511f, 
		1.96471f, -0.115674f, -3.11511f, 1.96471f, -0.115674f, -3.11511f, 
		1.96471f, -0.115674f, -3.11511f, 1.96471f, 0.834796f, -2.90616f, 
		1.96476f, -0.114122f, -3.10067f, 1.96483f, 0.875067f, -2.94089f, 
		1.96504f, 0.827053f, -2.89707f, 1.96505f, 0.912322f, -2.86203f, 
		1.96505f, 0.912322f, -2.86203f, 1.96511f, 0.820626f, -2.92685f, 
		1.96524f, 0.834804f, -2.95598f, 1.96525f, 0.922876f, -3.05310f, 
		1.96538f, -0.159179f, -3.06659f, 1.96538f, -0.159179f, -3.06659f, 
		1.96538f, -0.159179f, -3.06659f, 1.96540f, 0.851067f, -2.90104f, 
		1.96541f, 0.00226900f, -3.09641f, 1.96541f, 0.00226900f, -3.09641f, 
		1.96541f, 0.839818f, -2.89998f, 1.96541f, 0.839818f, -2.89998f, 
		1.96541f, 0.839818f, -2.89998f, 1.96549f, 0.826637f, -2.95053f, 
		1.96551f, 0.782424f, -2.89507f, 1.96551f, 0.782424f, -2.89507f, 
		1.96551f, 0.782424f, -2.89507f, 1.96556f, 0.868011f, -2.90760f, 
		1.96563f, -0.172915f, -3.07138f, 1.96563f, -0.172915f, -3.07138f, 
		1.96564f, 0.821900f, -2.91742f, 1.96569f, 0.848531f, -2.90380f, 
		1.96582f, 0.767057f, -2.89671f, 1.96582f, 0.767057f, -2.89671f, 
		1.96582f, 0.767057f, -2.89671f, 1.96582f, 0.767057f, -2.89671f, 
		1.96582f, 0.767057f, -2.89671f, 1.96582f, 0.847234f, -2.89523f, 
		1.96582f, 0.847234f, -2.89523f, 1.96585f, 0.863976f, -3.02168f, 
		1.96591f, -0.0448910f, -3.12815f, 1.96597f, 0.857623f, -2.89004f, 
		1.96605f, 0.871913f, -2.87950f, 1.96605f, 0.871913f, -2.87950f, 
		1.96605f, 0.871913f, -2.87950f, 1.96605f, 0.871913f, -2.87950f, 
		1.96610f, 0.897925f, -2.84829f, 1.96610f, 0.897925f, -2.84829f, 
		1.96611f, 0.832056f, -2.89460f, 1.96626f, -0.156203f, -3.05369f, 
		1.96626f, -0.156203f, -3.05369f, 1.96626f, -0.156203f, -3.05369f, 
		1.96626f, -0.156203f, -3.05369f, 1.96626f, -0.156203f, -3.05369f, 
		1.96644f, 0.819656f, -2.94269f, 1.96678f, 0.839565f, -2.90203f, 
		1.96678f, 0.839565f, -2.90203f, 1.96678f, 0.839565f, -2.90203f, 
		1.96680f, 0.810081f, -3.00435f, 1.96680f, 0.810081f, -3.00435f, 
		1.96682f, -0.0318400f, -3.12872f, 1.96722f, -0.164786f, -3.04425f, 
		1.96722f, -0.164786f, -3.04425f, 1.96722f, -0.172798f, -3.05696f, 
		1.96727f, -0.115740f, -3.10335f, 1.96727f, -0.115740f, -3.10335f, 
		1.96727f, 0.834647f, -2.89373f, 1.96727f, 0.834647f, -2.89373f, 
		1.96749f, 0.796973f, -2.89083f, 1.96749f, 0.796973f, -2.89083f, 
		1.96749f, 0.796973f, -2.89083f, 1.96750f, -0.116605f, -3.10769f, 
		1.96750f, -0.116605f, -3.10769f, 1.96750f, -0.116605f, -3.10769f, 
		1.96750f, -0.116605f, -3.10769f, 1.96768f, -0.110703f, -3.12319f, 
		1.96768f, -0.110703f, -3.12319f, 1.96768f, -0.110703f, -3.12319f, 
		1.96770f, -0.123880f, -3.11128f, 1.96770f, -0.123880f, -3.11128f, 
		1.96770f, -0.123880f, -3.11128f, 1.96770f, -0.123880f, -3.11128f, 
		1.96771f, -0.0576250f, -3.08782f, 1.96772f, 0.783184f, -3.04783f, 
		1.96772f, 0.783184f, -3.04783f, 1.96772f, 0.783184f, -3.04783f, 
		1.96784f, 0.841187f, -2.89787f, 1.96791f, -0.158833f, -3.04407f, 
		1.96791f, -0.158833f, -3.04407f, 1.96791f, -0.158833f, -3.04407f, 
		1.96791f, -0.158833f, -3.04407f, 1.96791f, -0.158833f, -3.04407f, 
		1.96791f, -0.158833f, -3.04407f, 1.96791f, -0.100426f, -3.12635f, 
		1.96799f, 0.874305f, -2.95321f, 1.96800f, 0.776825f, -3.09133f, 
		1.96800f, 0.776825f, -3.09133f, 1.96822f, -0.0787829f, -3.12766f, 
		1.96825f, 0.854143f, -2.88880f, 1.96825f, 0.854143f, -2.88880f, 
		1.96837f, 0.814590f, -2.93259f, 1.96855f, 0.824616f, -2.90532f, 
		1.96857f, -0.159118f, -3.06359f, 1.96859f, 0.898957f, -2.85511f, 
		1.96863f, 0.855670f, -2.96509f, 1.96877f, 0.847621f, -2.89827f, 
		1.96877f, 0.847621f, -2.89827f, 1.96877f, 0.864655f, -2.96221f, 
		1.96881f, -0.0622000f, -3.09174f, 1.96895f, 0.880453f, -2.94679f, 
		1.96915f, 0.826221f, -2.95830f, 1.96917f, 0.829704f, -2.90053f, 
		1.96919f, -0.139754f, -3.10333f, 1.96919f, -0.139754f, -3.10333f, 
		1.96919f, -0.139754f, -3.10333f, 1.96919f, -0.139754f, -3.10333f, 
		1.96919f, -0.139754f, -3.10333f, 1.96919f, -0.139754f, -3.10333f, 
		1.96920f, 0.872969f, -2.87988f, 1.96920f, 0.872969f, -2.87988f, 
		1.96922f, 0.856665f, -2.89598f, 1.96925f, -0.0610800f, -3.12895f, 
		1.96925f, 0.877613f, -2.90914f, 1.96927f, -0.0176110f, -3.13001f, 
		1.96944f, 0.864703f, -2.99394f, 1.96944f, 0.864703f, -2.99394f, 
		1.96944f, 0.864703f, -2.99394f, 1.96955f, -0.171012f, -3.05485f, 
		1.96957f, 0.754455f, -2.93745f, 1.96959f, -0.108218f, -3.10228f, 
		1.96965f, 0.784055f, -2.97044f, 1.96968f, 0.863219f, -2.89654f, 
		1.96968f, 0.885351f, -2.93600f, 1.96969f, 0.828537f, -2.99724f, 
		1.96974f, -0.168962f, -3.07232f, 1.96974f, -0.168962f, -3.07232f, 
		1.96974f, -0.168962f, -3.07232f, 1.96974f, -0.168962f, -3.07232f, 
		1.96992f, 0.829460f, -3.04616f, 1.96992f, 0.829460f, -3.04616f, 
		1.96992f, 0.829460f, -3.04616f, 1.96992f, 0.829460f, -3.04616f, 
		1.96993f, 0.846868f, -2.96762f, 1.96997f, 0.885648f, -2.92740f, 
		1.97009f, -0.864353f, -3.05327f, 1.97009f, -0.864353f, -3.05327f, 
		1.97025f, 0.833992f, -2.89643f, 1.97025f, 0.833992f, -2.89643f, 
		1.97027f, 0.796569f, -3.05875f, 1.97027f, 0.796569f, -3.05875f, 
		1.97027f, 0.796569f, -3.05875f, 1.97028f, -0.163369f, -3.07038f, 
		1.97028f, -0.163369f, -3.07038f, 1.97031f, 0.884472f, -2.91797f, 
		1.97037f, -0.124127f, -3.11592f, 1.97037f, -0.124127f, -3.11592f, 
		1.97037f, -0.124127f, -3.11592f, 1.97037f, -0.124127f, -3.11592f, 
		1.97037f, -0.124127f, -3.11592f, 1.97050f, 0.808587f, -2.88611f, 
		1.97051f, -0.137030f, -3.09884f, 1.97051f, -0.137030f, -3.09884f, 
		1.97051f, -0.137030f, -3.09884f, 1.97051f, 0.838354f, -2.96738f, 
		1.97054f, -0.127300f, -3.10270f, 1.97054f, -0.127300f, -3.10270f, 
		1.97054f, -0.127300f, -3.10270f, 1.97055f, -0.841929f, -3.05363f, 
		1.97063f, -0.00254800f, -3.13253f, 1.97110f, 0.857666f, -2.89279f, 
		1.97120f, -0.0993800f, -3.10383f, 1.97123f, -0.154862f, -3.04707f, 
		1.97123f, -0.154862f, -3.04707f, 1.97123f, -0.154862f, -3.04707f, 
		1.97133f, 0.854134f, -2.89156f, 1.97133f, 0.854134f, -2.89156f, 
		1.97141f, 0.815807f, -2.91043f, 1.97143f, 0.811273f, -3.04234f, 
		1.97143f, 0.811273f, -3.04234f, 1.97143f, 0.811273f, -3.04234f, 
		1.97143f, 0.811273f, -3.04234f, 1.97145f, 0.811635f, -2.94172f, 
		1.97154f, 0.891962f, -2.85806f, 1.97154f, 0.891962f, -2.85806f, 
		1.97154f, 0.810449f, -2.92243f, 1.97156f, 0.873147f, -2.96198f, 
		1.97159f, -0.142075f, -3.10738f, 1.97159f, -0.142075f, -3.10738f, 
		1.97159f, -0.142075f, -3.10738f, 1.97159f, -0.142075f, -3.10738f, 
		1.97187f, 0.749611f, -2.89550f, 1.97187f, 0.749611f, -2.89550f, 
		1.97187f, 0.749611f, -2.89550f, 1.97190f, -0.0324590f, -3.08505f, 
		1.97190f, -0.0324590f, -3.08505f, 1.97190f, -0.0324590f, -3.08505f, 
		1.97190f, -0.0324590f, -3.08505f, 1.97207f, 0.875296f, -2.90044f, 
		1.97222f, 0.814698f, -2.95128f, 1.97224f, -0.146732f, -3.09559f, 
		1.97224f, -0.146732f, -3.09559f, 1.97224f, -0.146732f, -3.09559f, 
		1.97224f, -0.146732f, -3.09559f, 1.97224f, -0.146732f, -3.09559f, 
		1.97224f, -0.146732f, -3.09559f, 1.97228f, 0.757813f, -3.05777f, 
		1.97228f, 0.757813f, -3.05777f, 1.97228f, 0.757813f, -3.05777f, 
		1.97228f, 0.757813f, -3.05777f, 1.97241f, 0.869617f, -2.87955f, 
		1.97249f, 0.815143f, -2.88487f, 1.97249f, 0.847694f, -2.88997f, 
		1.97255f, -0.141670f, -3.09361f, 1.97255f, -0.141670f, -3.09361f, 
		1.97255f, -0.141670f, -3.09361f, 1.97256f, 0.919658f, -3.11608f, 
		1.97262f, -0.0936490f, -3.10505f, 1.97271f, 0.830764f, -3.12604f, 
		1.97271f, 0.830764f, -3.12604f, 1.97271f, 0.830764f, -3.12604f, 
		1.97275f, 0.829525f, -2.89454f, 1.97289f, -0.113475f, -3.10427f, 
		1.97289f, -0.113475f, -3.10427f, 1.97289f, -0.113475f, -3.10427f, 
		1.97329f, -0.156118f, -3.05779f, 1.97330f, -0.172981f, -3.06031f, 
		1.97330f, -0.172981f, -3.06031f, 1.97335f, 0.850772f, -3.09041f, 
		1.97335f, 0.850772f, -3.09041f, 1.97335f, 0.850772f, -3.09041f, 
		1.97339f, -0.820649f, -3.04912f, 1.97339f, -0.820649f, -3.04912f, 
		1.97340f, -0.164355f, -3.03939f, 1.97340f, -0.164355f, -3.03939f, 
		1.97340f, -0.164355f, -3.03939f, 1.97346f, 0.888541f, -2.94299f, 
		1.97350f, 0.827264f, -2.96666f, 1.97386f, 0.822553f, -2.88366f, 
		1.97394f, 0.831171f, -3.07076f, 1.97394f, 0.831171f, -3.07076f, 
		1.97394f, 0.831171f, -3.07076f, 1.97400f, 0.855077f, -2.97288f, 
		1.97406f, 0.885128f, -2.95245f, 1.97425f, 0.846858f, -3.03661f, 
		1.97425f, 0.846858f, -3.03661f, 1.97425f, 0.846858f, -3.03661f, 
		1.97425f, 0.846858f, -3.03661f, 1.97425f, -0.162998f, -3.06574f, 
		1.97425f, -0.162998f, -3.06574f, 1.97441f, 0.805118f, -3.08001f, 
		1.97442f, 0.862692f, -3.08338f, 1.97442f, 0.862692f, -3.08338f, 
		1.97442f, 0.862692f, -3.08338f, 1.97442f, 0.862692f, -3.08338f, 
		1.97448f, -0.820039f, -2.95833f, 1.97451f, 0.782920f, -3.05650f, 
		1.97451f, 0.782920f, -3.05650f, 1.97451f, 0.782920f, -3.05650f, 
		1.97455f, 0.779817f, -3.04121f, 1.97455f, 0.779817f, -3.04121f, 
		1.97458f, 0.789733f, -3.00302f, 1.97458f, 0.789733f, -3.00302f, 
		1.97458f, 0.789733f, -3.00302f, 1.97464f, 0.836838f, -2.88913f, 
		1.97468f, 0.829304f, -2.88377f, 1.97468f, 0.829304f, -2.88377f, 
		1.97468f, 0.829304f, -2.88377f, 1.97469f, -0.158531f, -3.03873f, 
		1.97469f, -0.158531f, -3.03873f, 1.97469f, -0.158531f, -3.03873f, 
		1.97480f, -0.0854780f, -3.10462f, 1.97490f, -0.113767f, -3.12287f, 
		1.97490f, -0.113767f, -3.12287f, 1.97490f, -0.113767f, -3.12287f, 
		1.97519f, 0.866024f, -2.87913f, 1.97525f, 0.816007f, -2.95975f, 
		1.97530f, -0.134839f, -3.09624f, 1.97530f, -0.134839f, -3.09624f, 
		1.97539f, 0.816566f, -2.90132f, 1.97544f, -0.155376f, -3.04175f, 
		1.97544f, -0.155376f, -3.04175f, 1.97544f, -0.155376f, -3.04175f, 
		1.97544f, -0.155376f, -3.04175f, 1.97550f, 1.01043f, -2.89023f, 
		1.97554f, -0.150115f, -3.09823f, 1.97554f, -0.150115f, -3.09823f, 
		1.97554f, -0.150115f, -3.09823f, 1.97554f, -0.150115f, -3.09823f, 
		1.97562f, 0.826923f, -3.01528f, 1.97568f, 0.828784f, -3.05007f, 
		1.97568f, 0.828784f, -3.05007f, 1.97568f, 0.828784f, -3.05007f, 
		1.97574f, 0.888246f, -2.91022f, 1.97580f, 0.831214f, -2.88440f, 
		1.97580f, 0.831214f, -2.88440f, 1.97591f, -0.171203f, -3.05687f, 
		1.97591f, -0.171203f, -3.05687f, 1.97591f, -0.171203f, -3.05687f, 
		1.97596f, -0.101577f, -3.12677f, 1.97601f, 0.0556130f, -3.11479f, 
		1.97601f, 0.0556130f, -3.11479f, 1.97601f, 0.0556130f, -3.11479f, 
		1.97601f, 0.0556130f, -3.11479f, 1.97601f, 0.0556130f, -3.11479f, 
		1.97601f, 0.0556130f, -3.11479f, 1.97601f, 0.804659f, -2.93113f, 
		1.97616f, 0.812835f, -3.00059f, 1.97616f, 0.812835f, -3.00059f, 
		1.97639f, -0.0203120f, -3.09689f, 1.97639f, -0.0203120f, -3.09689f, 
		1.97639f, -0.0203120f, -3.09689f, 1.97639f, 0.997491f, -2.89910f, 
		1.97640f, 0.865727f, -2.97271f, 1.97641f, -0.137600f, -3.09346f, 
		1.97641f, -0.137600f, -3.09346f, 1.97645f, -0.126491f, -3.09885f, 
		1.97645f, -0.126491f, -3.09885f, 1.97651f, 1.03350f, -3.00726f, 
		1.97652f, 0.881634f, -2.89988f, 1.97656f, 0.809071f, -2.90941f, 
		1.97666f, -0.168335f, -3.06346f, 1.97666f, -0.168335f, -3.06346f, 
		1.97666f, -0.168335f, -3.06346f, 1.97666f, -0.168335f, -3.06346f, 
		1.97676f, -0.0602020f, -3.09861f, 1.97687f, -0.142674f, -3.10868f, 
		1.97687f, -0.142674f, -3.10868f, 1.97687f, -0.142674f, -3.10868f, 
		1.97687f, -0.142674f, -3.10868f, 1.97687f, -0.142674f, -3.10868f, 
		1.97696f, -0.147428f, -3.08810f, 1.97696f, -0.147428f, -3.08810f, 
		1.97696f, -0.147428f, -3.08810f, 1.97717f, 0.810724f, -3.04968f, 
		1.97717f, 0.810724f, -3.04968f, 1.97717f, 0.810724f, -3.04968f, 
		1.97717f, 0.810724f, -3.04968f, 1.97717f, 0.810724f, -3.04968f, 
		1.97717f, 0.804000f, -3.03222f, 1.97717f, 0.804000f, -3.03222f, 
		1.97720f, 0.804155f, -2.94061f, 1.97725f, -0.0931235f, -3.12771f, 
		1.97740f, 0.883575f, -2.96124f, 1.97742f, 0.863730f, -3.06239f, 
		1.97744f, 0.733094f, -3.05588f, 1.97744f, 0.733094f, -3.05588f, 
		1.97744f, 0.733094f, -3.05588f, 1.97749f, 0.862346f, -2.87917f, 
		1.97749f, 0.862346f, -2.87917f, 1.97752f, 0.885304f, -2.85867f, 
		1.97762f, -0.870433f, -2.95496f, 1.97771f, 0.0541990f, -3.13055f, 
		1.97771f, 0.0541990f, -3.13055f, 1.97795f, -0.0353840f, -3.09289f, 
		1.97795f, -0.0353840f, -3.09289f, 1.97795f, -0.0353840f, -3.09289f, 
		1.97797f, 0.895559f, -2.92947f, 1.97809f, -0.154692f, -3.05036f, 
		1.97812f, 0.862315f, -2.88564f, 1.97814f, -0.00294200f, -3.09627f, 
		1.97817f, -0.104156f, -3.10697f, 1.97831f, 0.831197f, -2.88731f, 
		1.97831f, 0.831197f, -2.88731f, 1.97832f, 0.893948f, -2.91729f, 
		1.97843f, 0.841472f, -2.97746f, 1.97849f, 0.820291f, -2.89324f, 
		1.97856f, 0.845197f, -3.05402f, 1.97856f, 0.845197f, -3.05402f, 
		1.97856f, 0.845197f, -3.05402f, 1.97856f, 0.845197f, -3.05402f, 
		1.97856f, 0.827069f, -2.89006f, 1.97870f, 0.873813f, -2.89028f, 
		1.97873f, 0.783348f, -2.99639f, 1.97877f, 0.892953f, -2.94810f, 
		1.97881f, -0.160056f, -3.06021f, 1.97881f, -0.160056f, -3.06021f, 
		1.97883f, 0.850386f, -2.88315f, 1.97887f, -0.167379f, -3.04112f, 
		1.97887f, -0.167379f, -3.04112f, 1.97909f, 0.786638f, -3.01515f, 
		1.97909f, 0.786638f, -3.01515f, 1.97909f, 0.786638f, -3.01515f, 
		1.97917f, 0.758427f, -3.05955f, 1.97917f, 0.758427f, -3.05955f, 
		1.97917f, 0.758427f, -3.05955f, 1.97935f, 0.791135f, -3.00111f, 
		1.97935f, 0.791135f, -3.00111f, 1.97935f, 0.791135f, -3.00111f, 
		1.97935f, 0.783193f, -3.07914f, 1.97953f, 0.823849f, -3.03010f, 
		1.97953f, 0.823849f, -3.03010f, 1.97965f, 0.978098f, -3.11242f, 
		1.97985f, 0.864933f, -2.88492f, 1.97986f, -0.143780f, -3.08152f, 
		1.97986f, -0.143780f, -3.08152f, 1.97986f, -0.143780f, -3.08152f, 
		1.97986f, -0.143780f, -3.08152f, 1.97992f, 0.801535f, -2.92087f, 
		1.98005f, 0.812748f, -3.07839f, 1.98005f, 0.812748f, -3.07839f, 
		1.98012f, -0.164655f, -3.04023f, 1.98012f, -0.164655f, -3.04023f, 
		1.98012f, -0.164655f, -3.04023f, 1.98016f, 0.963502f, -2.86286f, 
		1.98020f, 0.896518f, -2.94096f, 1.98036f, -0.112453f, -3.10685f, 
		1.98036f, -0.112453f, -3.10685f, 1.98036f, -0.112453f, -3.10685f, 
		1.98036f, -0.112453f, -3.10685f, 1.98036f, -0.112453f, -3.10685f, 
		1.98044f, -0.138537f, -3.08695f, 1.98044f, -0.138537f, -3.08695f, 
		1.98047f, 0.779317f, -3.04850f, 1.98047f, 0.779317f, -3.04850f, 
		1.98047f, 0.779317f, -3.04850f, 1.98047f, 0.779317f, -3.04850f, 
		1.98050f, 0.822506f, -2.97204f, 1.98052f, -0.151157f, -3.09114f, 
		1.98055f, 0.805206f, -2.95289f, 1.98065f, 0.831538f, -2.97687f, 
		1.98069f, -0.169021f, -3.05168f, 1.98079f, 0.875699f, -2.97220f, 
		1.98096f, -0.0655240f, -3.13048f, 1.98099f, -0.150182f, -3.10081f, 
		1.98099f, -0.150182f, -3.10081f, 1.98099f, -0.150182f, -3.10081f, 
		1.98099f, -0.150182f, -3.10081f, 1.98101f, 0.861513f, -2.88246f, 
		1.98101f, 0.861513f, -2.88246f, 1.98133f, -0.155808f, -3.04394f, 
		1.98133f, -0.155808f, -3.04394f, 1.98133f, -0.155808f, -3.04394f, 
		1.98133f, -0.155808f, -3.04394f, 1.98133f, -0.155808f, -3.04394f, 
		1.98135f, 1.04238f, -2.86149f, 1.98135f, 1.04238f, -2.86149f, 
		1.98137f, -0.149675f, -3.08016f, 1.98137f, -0.149675f, -3.08016f, 
		1.98137f, -0.149675f, -3.08016f, 1.98137f, -0.149675f, -3.08016f, 
		1.98137f, 0.827202f, -2.88623f, 1.98139f, -0.122355f, -3.11456f, 
		1.98139f, -0.122355f, -3.11456f, 1.98139f, -0.122355f, -3.11456f, 
		1.98142f, -0.135501f, -3.09816f, 1.98142f, -0.135501f, -3.09816f, 
		1.98142f, -0.135501f, -3.09816f, 1.98142f, -0.135501f, -3.09816f, 
		1.98184f, -0.168437f, -3.04589f, 1.98184f, -0.168437f, -3.04589f, 
		1.98184f, -0.168437f, -3.04589f, 1.98193f, 0.812168f, -2.96497f, 
		1.98197f, -0.140893f, -3.10708f, 1.98201f, -0.160167f, -3.04046f, 
		1.98201f, -0.160167f, -3.04046f, 1.98201f, -0.160167f, -3.04046f, 
		1.98201f, -0.160167f, -3.04046f, 1.98201f, -0.160167f, -3.04046f, 
		1.98201f, -0.160167f, -3.04046f, 1.98204f, -0.110456f, -3.12056f, 
		1.98222f, -0.0365090f, -3.09759f, 1.98224f, 0.891110f, -2.90302f, 
		1.98224f, -0.137731f, -3.09613f, 1.98224f, -0.137731f, -3.09613f, 
		1.98224f, -0.137731f, -3.09613f, 1.98224f, -0.137731f, -3.09613f, 
		1.98225f, 0.744813f, -2.96615f, 1.98226f, -0.0513670f, -3.13096f, 
		1.98233f, 0.739185f, -2.88934f, 1.98242f, 0.771896f, -3.11190f, 
		1.98242f, 0.771896f, -3.11190f, 1.98255f, 0.808945f, -2.89999f, 
		1.98258f, -0.126109f, -3.10059f, 1.98258f, -0.126109f, -3.10059f, 
		1.98258f, -0.126109f, -3.10059f, 1.98258f, -0.126109f, -3.10059f, 
		1.98265f, -0.158682f, -3.05355f, 1.98265f, -0.158682f, -3.05355f, 
		1.98265f, -0.158682f, -3.05355f, 1.98265f, -0.158682f, -3.05355f, 
		1.98265f, -0.158682f, -3.05355f, 1.98265f, -0.158682f, -3.05355f, 
		1.98273f, -0.0762420f, -3.10608f, 1.98274f, 0.837603f, -2.88099f, 
		1.98289f, 0.890652f, -2.95993f, 1.98294f, 1.06415f, -2.98901f, 
		1.98303f, 0.855536f, -2.98161f, 1.98318f, 0.788553f, -3.01141f, 
		1.98318f, 0.788553f, -3.01141f, 1.98318f, 0.788553f, -3.01141f, 
		1.98329f, 0.821259f, -3.09743f, 1.98329f, 0.821259f, -3.09743f, 
		1.98330f, 0.843395f, -2.98195f, 1.98342f, 0.784376f, -3.01430f, 
		1.98342f, 0.784376f, -3.01430f, 1.98360f, 0.765022f, -3.03750f, 
		1.98360f, 0.765022f, -3.03750f, 1.98360f, 0.765022f, -3.03750f, 
		1.98369f, -0.140622f, -3.08126f, 1.98369f, -0.140622f, -3.08126f, 
		1.98371f, -0.104286f, -3.12338f, 1.98371f, -0.104286f, -3.12338f, 
		1.98371f, -0.104286f, -3.12338f, 1.98373f, -0.0583930f, -3.10218f, 
		1.98406f, -0.116465f, -3.11043f, 1.98406f, -0.116465f, -3.11043f, 
		1.98410f, 0.813407f, -2.89293f, 1.98445f, 0.0545460f, -3.10411f, 
		1.98445f, 0.0545460f, -3.10411f, 1.98445f, -0.164409f, -3.05264f, 
		1.98445f, -0.164409f, -3.05264f, 1.98445f, -0.164409f, -3.05264f, 
		1.98445f, -0.164409f, -3.05264f, 1.98458f, -0.143188f, -3.07420f, 
		1.98458f, -0.143188f, -3.07420f, 1.98458f, -0.143188f, -3.07420f, 
		1.98458f, -0.143188f, -3.07420f, 1.98459f, 0.919583f, -3.10929f, 
		1.98462f, -0.158839f, -3.04799f, 1.98462f, -0.158839f, -3.04799f, 
		1.98462f, -0.158839f, -3.04799f, 1.98467f, 0.879144f, -2.86207f, 
		1.98467f, 0.879144f, -2.86207f, 1.98467f, 0.879144f, -2.86207f, 
		1.98469f, 0.797204f, -3.07518f, 1.98469f, 0.797204f, -3.07518f, 
		1.98469f, -0.138043f, -3.10270f, 1.98469f, -0.138043f, -3.10270f, 
		1.98485f, 0.795811f, -2.86816f, 1.98488f, -0.110666f, -3.11311f, 
		1.98488f, -0.110666f, -3.11311f, 1.98492f, 0.900518f, -2.92157f, 
		1.98495f, 0.887182f, -2.89454f, 1.98506f, 0.839493f, -3.06976f, 
		1.98506f, 0.839493f, -3.06976f, 1.98506f, 0.839493f, -3.06976f, 
		1.98506f, 0.839493f, -3.06976f, 1.98512f, -0.146502f, -3.10138f, 
		1.98512f, -0.146502f, -3.10138f, 1.98512f, -0.146502f, -3.10138f, 
		1.98513f, 0.801561f, -2.90785f, 1.98514f, -0.0226771f, -3.13220f, 
		1.98514f, -0.0226771f, -3.13220f, 1.98514f, -0.0226771f, -3.13220f, 
		1.98521f, 0.807764f, -3.02489f, 1.98521f, 0.807764f, -3.02489f, 
		1.98522f, -0.126489f, -3.10617f, 1.98522f, -0.126489f, -3.10617f, 
		1.98543f, 0.923865f, -2.83552f, 1.98543f, 0.923865f, -2.83552f, 
		1.98543f, 0.851860f, -2.87770f, 1.98566f, 0.795994f, -2.93261f, 
		1.98580f, 0.881632f, -2.88877f, 1.98591f, -0.162768f, -3.04579f, 
		1.98591f, -0.162768f, -3.04579f, 1.98591f, -0.162768f, -3.04579f, 
		1.98591f, -0.162768f, -3.04579f, 1.98596f, -0.153465f, -3.08254f, 
		1.98596f, -0.153465f, -3.08254f, 1.98596f, -0.153465f, -3.08254f, 
		1.98596f, -0.153465f, -3.08254f, 1.98596f, -0.153465f, -3.08254f, 
		1.98598f, 0.865131f, -2.98170f, 1.98599f, -0.0957921f, -3.12511f, 
		1.98599f, -0.0957921f, -3.12511f, 1.98618f, 0.803837f, -2.86908f, 
		1.98627f, -0.104350f, -3.11580f, 1.98627f, -0.104350f, -3.11580f, 
		1.98627f, 0.785466f, -3.02573f, 1.98627f, 0.785466f, -3.02573f, 
		1.98633f, 0.783947f, -2.86666f, 1.98636f, -0.139875f, -3.07854f, 
		1.98636f, -0.139875f, -3.07854f, 1.98636f, -0.139875f, -3.07854f, 
		1.98636f, -0.139875f, -3.07854f, 1.98636f, -0.141149f, -3.09951f, 
		1.98636f, -0.141149f, -3.09951f, 1.98637f, 0.721734f, -2.93388f, 
		1.98642f, -0.138869f, -3.08955f, 1.98656f, -0.00941100f, -3.13093f, 
		1.98656f, -0.00941100f, -3.13093f, 1.98669f, 0.929696f, -2.84619f, 
		1.98701f, 0.819717f, -2.97620f, 1.98703f, 0.884626f, -2.97137f, 
		1.98708f, 0.850731f, -3.04031f, 1.98708f, 0.850731f, -3.04031f, 
		1.98708f, 0.850731f, -3.04031f, 1.98726f, 0.796249f, -2.91904f, 
		1.98736f, -0.0978955f, -3.11634f, 1.98736f, -0.0978955f, -3.11634f, 
		1.98739f, -0.147091f, -3.07147f, 1.98739f, -0.147091f, -3.07147f, 
		1.98739f, -0.147091f, -3.07147f, 1.98739f, -0.147091f, -3.07147f, 
		1.98744f, -0.0388160f, -3.10066f, 1.98746f, 0.720187f, -2.90929f, 
		1.98750f, 0.898165f, -2.95368f, 1.98757f, -0.0234100f, -3.10518f, 
		1.98757f, -0.0234100f, -3.10518f, 1.98757f, -0.0234100f, -3.10518f, 
		1.98757f, -0.0234100f, -3.10518f, 1.98757f, -0.0234100f, -3.10518f, 
		1.98761f, 0.796458f, -2.94474f, 1.98781f, 0.899082f, -2.90943f, 
		1.98788f, 0.806052f, -2.96436f, 1.98800f, 0.924788f, -2.84410f, 
		1.98800f, 0.924788f, -2.84410f, 1.98821f, 0.903389f, -2.93119f, 
		1.98830f, 0.810645f, -2.86978f, 1.98842f, 0.878215f, -2.86490f, 
		1.98842f, 0.878215f, -2.86490f, 1.98842f, 0.878215f, -2.86490f, 
		1.98846f, 0.814310f, -3.05958f, 1.98846f, 0.814310f, -3.05958f, 
		1.98850f, 0.871318f, -2.88042f, 1.98884f, 0.829027f, -2.87171f, 
		1.98884f, 0.829027f, -2.87171f, 1.98884f, 0.829027f, -2.87171f, 
		1.98894f, 0.824832f, -2.88097f, 1.98913f, 0.829368f, -2.98267f, 
		1.98915f, 0.770224f, -2.86592f, 1.98919f, 0.0500600f, -3.13981f, 
		1.98927f, 0.859652f, -2.87601f, 1.98934f, -0.0813520f, -3.12664f, 
		1.98934f, -0.0813520f, -3.12664f, 1.98938f, 0.815622f, -2.88627f, 
		1.98952f, 0.903594f, -2.94067f, 1.98953f, 0.816492f, -2.87071f, 
		1.98960f, -0.0876590f, -3.11738f, 1.98960f, -0.0876590f, -3.11738f, 
		1.98964f, 0.765415f, -3.04110f, 1.98964f, 0.765415f, -3.04110f, 
		1.98964f, 0.765415f, -3.04110f, 1.98970f, 0.800490f, -2.95801f, 
		1.98975f, -0.143423f, -3.06933f, 1.98975f, -0.143423f, -3.06933f, 
		1.98977f, 0.830664f, -2.87298f, 1.98977f, 0.830664f, -2.87298f, 
		1.98989f, -0.831291f, -2.93772f, 1.98989f, -0.831291f, -2.93772f, 
		1.98989f, -0.831291f, -2.93772f, 1.99012f, -0.00787600f, -3.10545f, 
		1.99012f, -0.134882f, -3.07522f, 1.99012f, -0.134882f, -3.07522f, 
		1.99012f, -0.134882f, -3.07522f, 1.99012f, -0.134882f, -3.07522f, 
		1.99012f, -0.134882f, -3.07522f, 1.99013f, 0.873542f, -2.98119f, 
		1.99016f, -0.870433f, -3.02961f, 1.99036f, -0.141017f, -3.08357f, 
		1.99036f, -0.141017f, -3.08357f, 1.99036f, -0.141017f, -3.08357f, 
		1.99053f, 0.910022f, -2.83278f, 1.99053f, 0.910022f, -2.83278f, 
		1.99062f, -0.0298640f, -3.10461f, 1.99092f, -0.142418f, -3.09285f, 
		1.99092f, -0.142418f, -3.09285f, 1.99119f, 0.841411f, -2.98702f, 
		1.99121f, 0.874504f, -2.86640f, 1.99145f, 0.819306f, -3.07788f, 
		1.99145f, 0.819306f, -3.07788f, 1.99150f, 0.804282f, -2.89579f, 
		1.99158f, 0.830607f, -2.87635f, 1.99158f, 0.830607f, -2.87635f, 
		1.99163f, 0.807939f, -2.97029f, 1.99165f, -0.134891f, -3.06759f, 
		1.99165f, -0.134891f, -3.06759f, 1.99165f, -0.134891f, -3.06759f, 
		1.99165f, -0.134891f, -3.06759f, 1.99165f, -0.134891f, -3.06759f, 
		1.99182f, -0.0710940f, -3.12733f, 1.99182f, -0.0710940f, -3.12733f, 
		1.99187f, -0.153347f, -3.08547f, 1.99187f, -0.153347f, -3.08547f, 
		1.99187f, -0.153347f, -3.08547f, 1.99187f, -0.153347f, -3.08547f, 
		1.99200f, 0.894530f, -2.96504f, 1.99213f, 0.780172f, -3.05854f, 
		1.99213f, 0.780172f, -3.05854f, 1.99250f, 0.796923f, -2.90709f, 
		1.99253f, 0.975094f, -3.10528f, 1.99259f, 0.831607f, -2.87591f, 
		1.99269f, 0.905433f, -2.92094f, 1.99276f, 0.735447f, -2.88024f, 
		1.99280f, 0.870395f, -2.86759f, 1.99294f, -0.150538f, -3.07379f, 
		1.99294f, -0.150538f, -3.07379f, 1.99294f, -0.150538f, -3.07379f, 
		1.99294f, -0.150538f, -3.07379f, 1.99301f, 0.845310f, -2.87299f, 
		1.99319f, -0.846564f, -2.93471f, 1.99322f, -0.139301f, -3.06502f, 
		1.99322f, -0.139301f, -3.06502f, 1.99324f, -0.864794f, -2.93475f, 
		1.99324f, -0.864794f, -2.93475f, 1.99352f, 0.897673f, -2.90004f, 
		1.99358f, 0.760725f, -3.06106f, 1.99358f, 0.760725f, -3.06106f, 
		1.99361f, 0.857317f, -2.98826f, 1.99376f, 0.855625f, -2.87297f, 
		1.99379f, 0.867034f, -2.86917f, 1.99379f, 0.867034f, -2.86917f, 
		1.99379f, 0.867034f, -2.86917f, 1.99380f, 0.826295f, -2.87771f, 
		1.99380f, 0.743661f, -2.99509f, 1.99392f, 0.862259f, -3.10296f, 
		1.99393f, 0.818081f, -2.97997f, 1.99405f, -0.0566490f, -3.12667f, 
		1.99405f, -0.0566490f, -3.12667f, 1.99430f, -0.0758170f, -3.11719f, 
		1.99430f, -0.0758170f, -3.11719f, 1.99449f, 0.909843f, -2.83896f, 
		1.99458f, 0.720050f, -2.89111f, 1.99463f, -0.149400f, -3.08808f, 
		1.99463f, -0.149400f, -3.08808f, 1.99463f, -0.149400f, -3.08808f, 
		1.99463f, -0.149400f, -3.08808f, 1.99485f, 0.110330f, -3.12240f, 
		1.99490f, 0.892859f, -2.89207f, 1.99495f, -0.0412620f, -3.12466f, 
		1.99495f, -0.0412620f, -3.12466f, 1.99495f, -0.0412620f, -3.12466f, 
		1.99497f, -0.144687f, -3.08622f, 1.99497f, -0.144687f, -3.08622f, 
		1.99497f, -0.144687f, -3.08622f, 1.99498f, 0.793803f, -2.95029f, 
		1.99498f, 0.880173f, -2.88113f, 1.99498f, 0.879726f, -2.98067f, 
		1.99505f, 0.796869f, -3.09759f, 1.99505f, 0.796869f, -3.09759f, 
		1.99509f, -0.147238f, -3.07253f, 1.99523f, 0.791723f, -2.91818f, 
		1.99527f, -0.0252190f, -3.12043f, 1.99527f, -0.0252190f, -3.12043f, 
		1.99527f, -0.0252190f, -3.12043f, 1.99527f, -0.0252190f, -3.12043f, 
		1.99528f, -0.00989500f, -3.11947f, 1.99528f, -0.00989500f, -3.11947f, 
		1.99531f, 0.902855f, -2.90781f, 1.99578f, -0.134992f, -3.07933f, 
		1.99586f, 0.827588f, -2.98585f, 1.99612f, 0.757571f, -2.86518f, 
		1.99623f, -0.807897f, -3.01899f, 1.99630f, 0.802555f, -3.07488f, 
		1.99630f, 0.802555f, -3.07488f, 1.99630f, 0.886401f, -2.88484f, 
		1.99632f, 0.848150f, -2.99011f, 1.99638f, 0.890540f, -2.97268f, 
		1.99641f, 0.108947f, -3.13874f, 1.99641f, 0.108947f, -3.13874f, 
		1.99642f, 0.903039f, -2.84227f, 1.99642f, 0.903039f, -2.84227f, 
		1.99655f, 0.789750f, -2.93071f, 1.99657f, 0.735981f, -3.06266f, 
		1.99657f, 0.735981f, -3.06266f, 1.99657f, 0.735981f, -3.06266f, 
		1.99674f, 0.908129f, -2.93256f, 1.99675f, 0.749770f, -3.02551f, 
		1.99675f, 0.749770f, -3.02551f, 1.99675f, 0.749770f, -3.02551f, 
		1.99689f, 0.869779f, -2.87561f, 1.99692f, 0.0493730f, -3.10367f, 
		1.99716f, 1.03149f, -3.10182f, 1.99720f, 0.865948f, -2.87402f, 
		1.99720f, 0.865948f, -2.87402f, 1.99744f, -0.129728f, -3.06745f, 
		1.99744f, -0.129728f, -3.06745f, 1.99744f, -0.129728f, -3.06745f, 
		1.99751f, -0.0586960f, -3.11539f, 1.99751f, -0.0586960f, -3.11539f, 
		1.99766f, 0.810072f, -2.88534f, 1.99774f, -0.0315060f, -3.11259f, 
		1.99774f, -0.0315060f, -3.11259f, 1.99779f, 0.904785f, -2.95213f, 
		1.99806f, -0.150469f, -3.07720f, 1.99806f, -0.150469f, -3.07720f, 
		1.99825f, 1.00493f, -2.88227f, 1.99830f, 0.789973f, -2.94011f, 
		1.99832f, 0.801439f, -2.89419f, 1.99836f, 1.05659f, -2.98783f, 
		1.99836f, 0.817920f, -2.87934f, 1.99851f, 0.710819f, -2.96284f, 
		1.99851f, 0.835722f, -2.98938f, 1.99858f, -0.0422940f, -3.11296f, 
		1.99858f, -0.0422940f, -3.11296f, 1.99900f, -0.136012f, -3.06183f, 
		1.99900f, -0.136012f, -3.06183f, 1.99900f, -0.136012f, -3.06183f, 
		1.99900f, -0.136012f, -3.06183f, 1.99900f, 0.872023f, -2.87474f, 
		1.99900f, -0.131055f, -3.06322f, 1.99900f, -0.131055f, -3.06322f, 
		1.99900f, -0.131055f, -3.06322f, 1.99900f, -0.131055f, -3.06322f, 
		1.99903f, 0.797262f, -2.96187f, 1.99929f, 1.02055f, -2.87246f, 
		1.99957f, -0.147089f, -3.08185f, 1.99957f, -0.147089f, -3.08185f, 
		1.99957f, -0.147089f, -3.08185f, 1.99957f, -0.147089f, -3.08185f, 
		1.99997f, 0.870266f, -2.98786f, 2.00016f, 0.810980f, -2.97836f, 
		2.00018f, -0.147438f, -3.07503f, 2.00018f, -0.147438f, -3.07503f, 
		2.00018f, -0.147438f, -3.07503f, 2.00025f, -0.131111f, -3.07399f, 
		2.00044f, 0.793770f, -2.90519f, 2.00048f, 0.825396f, -2.87445f, 
		2.00073f, -0.138213f, -3.08120f, 2.00073f, -0.138213f, -3.08120f, 
		2.00073f, -0.138213f, -3.08120f, 2.00073f, -0.138213f, -3.08120f, 
		2.00099f, 0.853608f, -2.86952f, 2.00110f, 0.886024f, -2.97946f, 
		2.00121f, 0.856231f, -3.07744f, 2.00121f, 0.856231f, -3.07744f, 
		2.00144f, 0.834868f, -2.87091f, 2.00159f, 0.900710f, -2.96359f, 
		2.00175f, 0.970529f, -2.84771f, 2.00185f, 0.866127f, -2.87161f, 
		2.00202f, 0.804385f, -2.97304f, 2.00219f, 0.750850f, -3.01913f, 
		2.00219f, 0.750850f, -3.01913f, 2.00219f, 0.750850f, -3.01913f, 
		2.00228f, 0.908827f, -2.94467f, 2.00322f, 0.906025f, -2.90707f, 
		2.00336f, 0.790069f, -2.94937f, 2.00349f, 0.826059f, -2.98847f, 
		2.00360f, 0.896237f, -2.89071f, 2.00364f, 0.109070f, -3.11108f, 
		2.00364f, 0.109070f, -3.11108f, 2.00364f, -0.137294f, -3.06225f, 
		2.00364f, -0.137294f, -3.06225f, 2.00364f, -0.137294f, -3.06225f, 
		2.00368f, 0.733379f, -2.87757f, 2.00368f, 0.733379f, -2.87757f, 
		2.00368f, 0.733379f, -2.87757f, 2.00368f, 0.733379f, -2.87757f, 
		2.00370f, 0.748514f, -2.86724f, 2.00382f, -0.129224f, -3.06880f, 
		2.00382f, -0.129224f, -3.06880f, 2.00382f, -0.129224f, -3.06880f, 
		2.00382f, -0.129224f, -3.06880f, 2.00406f, 0.909900f, -2.91918f, 
		2.00407f, -0.143190f, -3.07190f, 2.00416f, 0.875404f, -2.87428f, 
		2.00429f, 0.841972f, -2.86889f, 2.00440f, 0.844204f, -2.99303f, 
		2.00480f, 0.0432150f, -3.13784f, 2.00480f, 0.0432150f, -3.13784f, 
		2.00487f, 0.891390f, -2.84253f, 2.00489f, 0.724553f, -2.88199f, 
		2.00489f, 0.724553f, -2.88199f, 2.00489f, 0.724553f, -2.88199f, 
		2.00489f, 0.724553f, -2.88199f, 2.00514f, 0.816393f, -2.98421f, 
		2.00519f, -0.131182f, -3.06464f, 2.00519f, -0.131182f, -3.06464f, 
		2.00519f, -0.131182f, -3.06464f, 2.00519f, -0.131182f, -3.06464f, 
		2.00519f, -0.131182f, -3.06464f, 2.00525f, 1.04858f, -2.84717f, 
		2.00525f, 1.04858f, -2.84717f, 2.00538f, 0.798873f, -2.89341f, 
		2.00548f, 0.691546f, -2.90884f, 2.00564f, 0.911445f, -2.93174f, 
		2.00565f, -0.139957f, -3.06699f, 2.00565f, -0.139957f, -3.06699f, 
		2.00565f, -0.139957f, -3.06699f, 2.00566f, 0.807371f, -2.88398f, 
		2.00576f, 0.764154f, -3.06056f, 2.00576f, 0.764154f, -3.06056f, 
		2.00576f, 0.764154f, -3.06056f, 2.00576f, 0.764154f, -3.06056f, 
		2.00576f, 0.764154f, -3.06056f, 2.00578f, 0.747599f, -3.04182f, 
		2.00578f, 0.747599f, -3.04182f, 2.00578f, 0.747599f, -3.04182f, 
		2.00627f, 0.830176f, -3.11288f, 2.00629f, 0.903450f, -2.89952f, 
		2.00635f, 0.928525f, -2.82566f, 2.00635f, 0.928525f, -2.82566f, 
		2.00635f, 0.928525f, -2.82566f, 2.00636f, 0.860996f, -2.86886f, 
		2.00636f, -0.132357f, -3.07263f, 2.00636f, -0.132357f, -3.07263f, 
		2.00636f, -0.132357f, -3.07263f, 2.00636f, -0.132357f, -3.07263f, 
		2.00636f, -0.132357f, -3.07263f, 2.00665f, 0.885216f, -2.87940f, 
		2.00671f, -0.138758f, -3.07418f, 2.00671f, -0.138758f, -3.07418f, 
		2.00671f, -0.138758f, -3.07418f, 2.00671f, -0.138758f, -3.07418f, 
		2.00671f, -0.138758f, -3.07418f, 2.00671f, -0.138758f, -3.07418f, 
		2.00673f, 0.700893f, -2.89195f, 2.00676f, 0.831773f, -2.86442f, 
		2.00676f, 0.831773f, -2.86442f, 2.00678f, 0.787864f, -2.91619f, 
		2.00685f, 0.793905f, -2.96102f, 2.00702f, 0.855574f, -2.99362f, 
		2.00706f, 0.828209f, -2.86345f, 2.00714f, 0.832781f, -2.86626f, 
		2.00714f, 0.832781f, -2.86626f, 2.00714f, 0.832781f, -2.86626f, 
		2.00714f, 0.810004f, -2.85759f, 2.00735f, 0.898744f, -2.96960f, 
		2.00764f, 0.801176f, -2.85519f, 2.00778f, 0.787033f, -2.94228f, 
		2.00779f, 0.815504f, -2.85939f, 2.00786f, 0.832825f, -2.86999f, 
		2.00786f, 0.832825f, -2.86999f, 2.00791f, 0.785928f, -2.92827f, 
		2.00801f, 0.906224f, -2.95721f, 2.00812f, 0.104707f, -3.14809f, 
		2.00824f, 0.814540f, -2.87768f, 2.00829f, -0.134607f, -3.06898f, 
		2.00829f, -0.134607f, -3.06898f, 2.00829f, -0.134607f, -3.06898f, 
		2.00829f, -0.134607f, -3.06898f, 2.00831f, 0.800503f, -2.97149f, 
		2.00839f, 0.938468f, -2.83373f, 2.00848f, 0.878618f, -2.98688f, 
		2.00849f, 1.02376f, -3.09563f, 2.00858f, 0.0445510f, -3.11249f, 
		2.00864f, 0.821244f, -2.86174f, 2.00869f, 0.866520f, -2.99182f, 
		2.00869f, 0.791401f, -2.85420f, 2.00888f, 1.07806f, -2.97358f, 
		2.00908f, 0.833712f, -2.99260f, 2.00945f, 0.882796f, -2.84815f, 
		2.00945f, 0.882796f, -2.84815f, 2.00945f, 0.882796f, -2.84815f, 
		2.00961f, 0.915504f, -2.82488f, 2.00961f, 0.915504f, -2.82488f, 
		2.00961f, 0.915504f, -2.82488f, 2.00991f, 0.832777f, -3.08224f, 
		2.01011f, 0.892007f, -2.97781f, 2.01061f, 0.789852f, -2.95437f, 
		2.01064f, 0.729309f, -2.88491f, 2.01064f, 0.729309f, -2.88491f, 
		2.01064f, 0.729309f, -2.88491f, 2.01081f, 0.713157f, -2.88216f, 
		2.01081f, 0.713157f, -2.88216f, 2.01081f, 0.713157f, -2.88216f, 
		2.01093f, 0.678621f, -2.93070f, 2.01114f, 0.878771f, -2.85273f, 
		2.01140f, 0.739421f, -2.86894f, 2.01140f, 0.739421f, -2.86894f, 
		2.01140f, 0.739421f, -2.86894f, 2.01150f, 0.890913f, -2.88244f, 
		2.01151f, 0.791279f, -2.90333f, 2.01173f, 0.824278f, -2.87142f, 
		2.01175f, 0.829235f, -2.87012f, 2.01226f, 0.909769f, -2.91110f, 
		2.01230f, 0.909797f, -2.95040f, 2.01237f, 0.874791f, -2.85669f, 
		2.01268f, 0.785129f, -2.93499f, 2.01278f, 0.759380f, -3.08461f, 
		2.01278f, 0.759380f, -3.08461f, 2.01286f, 0.744181f, -2.92548f, 
		2.01286f, 0.744181f, -2.92548f, 2.01286f, 0.744181f, -2.92548f, 
		2.01286f, 0.744181f, -2.92548f, 2.01286f, 0.744181f, -2.92548f, 
		2.01288f, 0.872280f, -2.87075f, 2.01321f, 0.808092f, -2.98041f, 
		2.01323f, 0.710083f, -2.99036f, 2.01324f, 0.0717810f, -3.03703f, 
		2.01331f, 0.729752f, -2.87814f, 2.01331f, 0.729752f, -2.87814f, 
		2.01331f, 0.729752f, -2.87814f, 2.01331f, 0.729752f, -2.87814f, 
		2.01331f, 0.729752f, -2.87814f, 2.01333f, 0.932868f, -2.83348f, 
		2.01333f, 0.932868f, -2.83348f, 2.01333f, 0.932868f, -2.83348f, 
		2.01345f, 0.871446f, -2.86014f, 2.01352f, 0.0427110f, -3.12628f, 
		2.01352f, 0.0427110f, -3.12628f, 2.01364f, 0.850165f, -2.86617f, 
		2.01372f, 0.838815f, -2.86705f, 2.01372f, 0.779285f, -2.85225f, 
		2.01374f, 0.918095f, -2.82987f, 2.01385f, 0.816746f, -2.98659f, 
		2.01387f, 0.912678f, -2.92340f, 2.01392f, 0.794929f, -2.96556f, 
		2.01399f, 0.164203f, -3.13016f, 2.01419f, 0.868622f, -2.86277f, 
		2.01430f, 0.912122f, -2.94277f, 2.01441f, 0.897422f, -2.88830f, 
		2.01476f, 0.848457f, -2.99544f, 2.01491f, 0.866955f, -2.86887f, 
		2.01491f, 0.866955f, -2.86887f, 2.01504f, 0.786805f, -2.94738f, 
		2.01516f, 0.905300f, -2.96195f, 2.01538f, 0.862257f, -2.86740f, 
		2.01538f, 0.162898f, -3.14664f, 2.01538f, 0.162898f, -3.14664f, 
		2.01566f, 0.725771f, -2.88353f, 2.01566f, 0.725771f, -2.88353f, 
		2.01566f, 0.725771f, -2.88353f, 2.01644f, 0.824914f, -2.99099f, 
		2.01647f, 0.103712f, -3.11031f, 2.01653f, 0.876750f, -2.98930f, 
		2.01656f, 0.883260f, -2.87586f, 2.01661f, 0.804889f, -3.11009f, 
		2.01671f, 0.804061f, -2.88422f, 2.01677f, -0.808018f, -2.99368f, 
		2.01678f, 0.797801f, -2.89118f, 2.01703f, 0.719674f, -2.88091f, 
		2.01703f, 0.719674f, -2.88091f, 2.01703f, 0.719674f, -2.88091f, 
		2.01724f, 0.122363f, -3.03377f, 2.01725f, 0.907874f, -2.90433f, 
		2.01728f, 0.862752f, -2.99422f, 2.01748f, 1.00976f, -2.87078f, 
		2.01757f, 0.889182f, -2.98167f, 2.01760f, 0.909284f, -2.83250f, 
		2.01760f, 0.909284f, -2.83250f, 2.01760f, 0.909284f, -2.83250f, 
		2.01772f, 0.790862f, -2.95916f, 2.01775f, 0.727315f, -2.86536f, 
		2.01782f, 0.832557f, -2.86784f, 2.01787f, 0.784436f, -2.92768f, 
		2.01793f, 0.737568f, -2.89207f, 2.01793f, 0.737568f, -2.89207f, 
		2.01793f, 0.737568f, -2.89207f, 2.01793f, 0.737568f, -2.89207f, 
		2.01795f, 0.724747f, -2.87644f, 2.01826f, 0.160520f, -3.03156f, 
		2.01838f, 0.870935f, -2.86809f, 2.01845f, 0.809064f, -2.87961f, 
		2.01886f, 0.816883f, -2.87433f, 2.01887f, 0.786358f, -2.91419f, 
		2.01899f, -0.870433f, -2.98928f, 2.01902f, 0.913505f, -2.93606f, 
		2.01904f, 0.715492f, -2.92646f, 2.01904f, 0.715492f, -2.92646f, 
		2.01904f, 0.715492f, -2.92646f, 2.01908f, 0.911992f, -2.91624f, 
		2.01911f, 0.835382f, -2.99440f, 2.01917f, 0.0212890f, -3.03379f, 
		2.01917f, 0.0212890f, -3.03379f, 2.01917f, 0.0212890f, -3.03379f, 
		2.01923f, 0.159006f, -2.99982f, 2.01940f, 0.974449f, -2.83995f, 
		2.01950f, 0.908850f, -2.95540f, 2.01955f, 0.764769f, -2.84950f, 
		2.01956f, 0.724550f, -2.88888f, 2.01956f, 0.724550f, -2.88888f, 
		2.01956f, 0.724550f, -2.88888f, 2.01959f, 0.718441f, -2.87842f, 
		2.01959f, 0.718441f, -2.87842f, 2.01976f, 0.813053f, -3.08292f, 
		2.01984f, 1.02608f, -2.86364f, 2.01998f, 0.784908f, -2.94024f, 
		2.02026f, 0.727710f, -2.89767f, 2.02026f, 0.727710f, -2.89767f, 
		2.02048f, 0.207783f, -3.00066f, 2.02051f, 0.891092f, -2.83373f, 
		2.02067f, 0.721046f, -2.86436f, 2.02067f, 0.721046f, -2.86436f, 
		2.02067f, 0.721046f, -2.86436f, 2.02077f, 0.767548f, -2.80482f, 
		2.02077f, 0.767548f, -2.80482f, 2.02077f, 0.767548f, -2.80482f, 
		2.02078f, 0.899550f, -2.97151f, 2.02080f, 0.119692f, -3.00463f, 
		2.02094f, 0.670440f, -2.95571f, 2.02108f, 0.208553f, -3.03403f, 
		2.02116f, 0.913566f, -2.92925f, 2.02151f, 0.744502f, -2.88123f, 
		2.02151f, 0.744502f, -2.88123f, 2.02151f, 0.744502f, -2.88123f, 
		2.02156f, -0.802228f, -3.07141f, 2.02156f, -0.802228f, -3.07141f, 
		2.02159f, 0.791466f, -2.90073f, 2.02168f, 0.751921f, -2.80362f, 
		2.02168f, 0.751921f, -2.80362f, 2.02180f, 0.941601f, -2.82871f, 
		2.02182f, 1.06916f, -2.97387f, 2.02184f, 0.679814f, -2.88623f, 
		2.02211f, 0.787799f, -2.95189f, 2.02228f, 0.501979f, -3.10776f, 
		2.02228f, 0.501979f, -3.10776f, 2.02228f, 0.501979f, -3.10776f, 
		2.02228f, 0.501979f, -3.10776f, 2.02228f, 0.501979f, -3.10776f, 
		2.02228f, 0.501979f, -3.10776f, 2.02240f, 0.748827f, -2.89318f, 
		2.02243f, 0.723445f, -2.88081f, 2.02243f, 0.723445f, -2.88081f, 
		2.02259f, 0.899405f, -2.89012f, 2.02270f, 0.833513f, -2.86023f, 
		2.02277f, 0.726071f, -2.88446f, 2.02277f, 0.726071f, -2.88446f, 
		2.02277f, 0.726071f, -2.88446f, 2.02277f, 0.726071f, -2.88446f, 
		2.02287f, 0.749614f, -2.89309f, 2.02287f, 0.749614f, -2.89309f, 
		2.02290f, 0.162814f, -3.11852f, 2.02290f, 0.162814f, -3.11852f, 
		2.02291f, 0.836694f, -2.86732f, 2.02291f, 0.836694f, -2.86732f, 
		2.02297f, 0.846542f, -2.99598f, 2.02301f, 0.904901f, -2.89771f, 
		2.02302f, 0.830147f, -2.85857f, 2.02308f, 0.796379f, -2.96899f, 
		2.02320f, 0.836505f, -2.86186f, 2.02320f, 0.836505f, -2.86186f, 
		2.02320f, 0.836505f, -2.86186f, 2.02320f, 0.836505f, -2.86186f, 
		2.02326f, 0.801346f, -2.97527f, 2.02338f, 0.259595f, -3.00408f, 
		2.02351f, 0.826072f, -2.85645f, 2.02364f, 0.854656f, -2.86577f, 
		2.02366f, 0.705364f, -2.87055f, 2.02366f, 0.705364f, -2.87055f, 
		2.02366f, 0.705364f, -2.87055f, 2.02366f, 0.705364f, -2.87055f, 
		2.02366f, 0.705364f, -2.87055f, 2.02406f, 0.258644f, -3.03810f, 
		2.02416f, 0.822062f, -2.85351f, 2.02420f, 0.0976160f, -3.14564f, 
		2.02420f, 0.0976160f, -3.14564f, 2.02427f, 0.708892f, -2.86870f, 
		2.02427f, 0.708892f, -2.86870f, 2.02444f, 0.854357f, -2.99579f, 
		2.02446f, 0.872437f, -2.86993f, 2.02464f, 0.810273f, -2.98312f, 
		2.02464f, 0.906443f, -2.96091f, 2.02465f, 0.0649750f, -3.00660f, 
		2.02465f, 0.753203f, -2.92337f, 2.02467f, 0.925937f, -3.16899f, 
		2.02467f, 0.722096f, -2.84639f, 2.02471f, 0.816433f, -2.85031f, 
		2.02478f, 0.711910f, -2.89599f, 2.02486f, 0.702733f, -2.92638f, 
		2.02488f, 0.733865f, -2.84776f, 2.02499f, 0.921080f, -2.82636f, 
		2.02502f, 0.892522f, -2.88259f, 2.02505f, 0.695466f, -2.87684f, 
		2.02511f, 0.753976f, -2.92318f, 2.02511f, 0.753976f, -2.92318f, 
		2.02513f, 0.724657f, -2.87285f, 2.02543f, 0.456990f, -3.11545f, 
		2.02543f, 0.456990f, -3.11545f, 2.02543f, 0.456990f, -3.11545f, 
		2.02556f, 0.763753f, -2.82885f, 2.02571f, 0.0753700f, -3.06519f, 
		2.02575f, 0.971743f, -3.16631f, 2.02578f, 0.863792f, -2.86739f, 
		2.02581f, 0.714012f, -2.88735f, 2.02597f, 0.713010f, -2.88148f, 
		2.02597f, 0.828965f, -2.86877f, 2.02602f, 0.805880f, -2.84638f, 
		2.02602f, 0.719981f, -2.87097f, 2.02602f, 0.719981f, -2.87097f, 
		2.02602f, 0.719981f, -2.87097f, 2.02610f, 0.776736f, -2.81487f, 
		2.02618f, 0.842852f, -2.86593f, 2.02625f, 0.913004f, -2.92138f, 
		2.02628f, 0.745588f, -2.86302f, 2.02632f, 0.880902f, -2.98750f, 
		2.02640f, -0.855783f, -3.08012f, 2.02640f, -0.855783f, -3.08012f, 
		2.02640f, -0.833167f, -3.08012f, 2.02643f, 0.747490f, -2.91727f, 
		2.02643f, 0.747490f, -2.91727f, 2.02643f, 0.747490f, -2.91727f, 
		2.02643f, 0.747490f, -2.91727f, 2.02643f, 0.747490f, -2.91727f, 
		2.02643f, 1.06056f, -3.09103f, 2.02659f, 0.795016f, -2.84299f, 
		2.02664f, 0.785122f, -2.91970f, 2.02664f, 0.821059f, -2.98960f, 
		2.02668f, 0.771975f, -2.78467f, 2.02668f, 0.771975f, -2.78467f, 
		2.02668f, 0.771975f, -2.78467f, 2.02668f, 0.771975f, -2.78467f, 
		2.02668f, 0.771975f, -2.78467f, 2.02673f, 0.789063f, -2.90622f, 
		2.02673f, 0.746391f, -2.86308f, 2.02673f, 0.746391f, -2.86308f, 
		2.02675f, 0.462799f, -3.14112f, 2.02675f, 0.462799f, -3.14112f, 
		2.02676f, 0.657423f, -2.89740f, 2.02676f, 0.657423f, -2.89740f, 
		2.02676f, 0.657423f, -2.89740f, 2.02679f, 1.05243f, -2.83774f, 
		2.02679f, 1.05243f, -2.83774f, 2.02691f, 0.869418f, -2.99259f, 
		2.02692f, 0.306940f, -3.04292f, 2.02699f, 0.158687f, -3.15581f, 
		2.02705f, 0.715579f, -2.84722f, 2.02705f, 0.715579f, -2.84722f, 
		2.02707f, 0.742369f, -3.04347f, 2.02707f, 0.742369f, -3.04347f, 
		2.02707f, 0.742369f, -3.04347f, 2.02708f, 0.878367f, -3.16591f, 
		2.02710f, 0.910039f, -2.90920f, 2.02724f, 0.790194f, -2.95807f, 
		2.02727f, 0.206213f, -2.96838f, 2.02732f, -0.0123730f, -3.02893f, 
		2.02732f, -0.0123730f, -3.02893f, 2.02732f, -0.0123730f, -3.02893f, 
		2.02735f, 0.911552f, -2.94744f, 2.02737f, 0.309113f, -3.00859f, 
		2.02751f, 0.881428f, -2.87455f, 2.02764f, 0.891489f, -2.97978f, 
		2.02764f, 0.517063f, -3.13511f, 2.02764f, 0.517063f, -3.13511f, 
		2.02764f, 0.517063f, -3.13511f, 2.02764f, 0.517063f, -3.13511f, 
		2.02764f, 0.517063f, -3.13511f, 2.02778f, 0.861008f, -2.86086f, 
		2.02780f, 0.753553f, -2.78296f, 2.02780f, 0.753553f, -2.78296f, 
		2.02780f, 0.753553f, -2.78296f, 2.02780f, 0.753553f, -2.78296f, 
		2.02780f, 0.753553f, -2.78296f, 2.02786f, 0.157091f, -2.96941f, 
		2.02801f, 0.859639f, -2.86704f, 2.02801f, 0.859639f, -2.86704f, 
		2.02811f, 0.751139f, -2.82827f, 2.02811f, 0.751139f, -2.82827f, 
		2.02811f, 0.751139f, -2.82827f, 2.02811f, 0.751139f, -2.82827f, 
		2.02811f, 0.751139f, -2.82827f, 2.02811f, 0.751139f, -2.82827f, 
		2.02813f, 0.864615f, -2.85498f, 2.02817f, 0.745895f, -2.86237f, 
		2.02817f, 0.745895f, -2.86237f, 2.02819f, 0.868179f, -2.84951f, 
		2.02823f, 0.784275f, -2.93186f, 2.02826f, 0.871856f, -2.84078f, 
		2.02826f, 0.871856f, -2.84078f, 2.02826f, 0.871856f, -2.84078f, 
		2.02830f, 0.355266f, -3.05009f, 2.02836f, 0.0987680f, -3.11919f, 
		2.02836f, 0.913475f, -2.93395f, 2.02843f, 0.833457f, -2.86695f, 
		2.02848f, 0.474702f, -3.08679f, 2.02848f, 0.474702f, -3.08679f, 
		2.02848f, 0.474702f, -3.08679f, 2.02848f, 0.474702f, -3.08679f, 
		2.02855f, 0.803467f, -2.88471f, 2.02863f, 0.745953f, -2.84219f, 
		2.02882f, 0.797097f, -2.89203f, 2.02882f, 0.399259f, -3.06055f, 
		2.02882f, 0.780713f, -2.83819f, 2.02882f, 0.780713f, -2.83819f, 
		2.02882f, 0.780713f, -2.83819f, 2.02890f, 0.122544f, -3.06155f, 
		2.02894f, -0.00650600f, -3.06640f, 2.02894f, -0.00650600f, -3.06640f, 
		2.02894f, -0.00650600f, -3.06640f, 2.02911f, 0.767484f, -2.83687f, 
		2.02911f, 0.767484f, -2.83687f, 2.02911f, 0.767484f, -2.83687f, 
		2.02911f, 0.767484f, -2.83687f, 2.02911f, 0.767484f, -2.83687f, 
		2.02912f, 0.718067f, -3.01800f, 2.02927f, 0.818689f, -2.87352f, 
		2.02929f, 0.924898f, -3.16127f, 2.02935f, 0.0297300f, -3.06718f, 
		2.02958f, 0.259489f, -2.97053f, 2.02962f, 0.837259f, -2.99470f, 
		2.02974f, 0.404178f, -3.11972f, 2.02991f, 0.443031f, -3.07219f, 
		2.02991f, 0.443031f, -3.07219f, 2.02991f, 0.443031f, -3.07219f, 
		2.02991f, 0.704012f, -2.87752f, 2.02997f, 0.721440f, -2.85596f, 
		2.02998f, 0.829178f, -2.99248f, 2.03016f, 0.785874f, -2.94437f, 
		2.03031f, 0.968353f, -3.15873f, 2.03051f, -0.819612f, -2.97345f, 
		2.03051f, -0.819612f, -2.97345f, 2.03051f, -0.819612f, -2.97345f, 
		2.03051f, -0.819612f, -2.97345f, 2.03052f, 0.715515f, -2.85449f, 
		2.03052f, 0.715515f, -2.85449f, 2.03074f, 0.160006f, -3.05892f, 
		2.03076f, 0.408950f, -3.14422f, 2.03076f, 0.408950f, -3.14422f, 
		2.03083f, 0.900303f, -2.96987f, 2.03097f, 0.215075f, -3.13729f, 
		2.03105f, 0.788981f, -2.82541f, 2.03117f, 0.782374f, -2.79806f, 
		2.03135f, 0.812483f, -2.87766f, 2.03141f, 0.758329f, -2.95292f, 
		2.03141f, 0.758329f, -2.95292f, 2.03150f, 0.768895f, -3.09248f, 
		2.03158f, 0.879771f, -3.15834f, 2.03158f, 0.758992f, -2.95231f, 
		2.03158f, 0.758992f, -2.95231f, 2.03158f, 0.758992f, -2.95231f, 
		2.03169f, 0.358345f, -3.01577f, 2.03177f, 0.851054f, -2.86621f, 
		2.03179f, 0.695540f, -2.88750f, 2.03180f, 0.893294f, -2.82665f, 
		2.03190f, 0.907078f, -2.95823f, 2.03205f, 0.841313f, -2.86795f, 
		2.03205f, 0.841313f, -2.86795f, 2.03205f, 0.841313f, -2.86795f, 
		2.03206f, 0.116920f, -2.97608f, 2.03214f, 0.859443f, -2.99452f, 
		2.03223f, 0.841616f, -2.86100f, 2.03223f, 0.841616f, -2.86100f, 
		2.03223f, 0.841616f, -2.86100f, 2.03223f, 0.841616f, -2.86100f, 
		2.03223f, 0.841616f, -2.86100f, 2.03223f, 0.841616f, -2.86100f, 
		2.03224f, 0.702477f, -2.90024f, 2.03232f, -0.790094f, -3.04936f, 
		2.03239f, 0.809260f, -2.98153f, 2.03241f, 0.748062f, -2.83358f, 
		2.03241f, 0.748062f, -2.83358f, 2.03241f, 0.748062f, -2.83358f, 
		2.03241f, 0.748062f, -2.83358f, 2.03241f, 0.748062f, -2.83358f, 
		2.03241f, 0.748062f, -2.83358f, 2.03242f, 0.213673f, -3.15508f, 
		2.03242f, 0.213673f, -3.15508f, 2.03259f, 0.863955f, -2.86807f, 
		2.03265f, 1.01492f, -3.15327f, 2.03271f, 0.694871f, -2.85423f, 
		2.03271f, 0.694871f, -2.85423f, 2.03285f, 0.355263f, -3.12599f, 
		2.03291f, 0.840166f, -2.85767f, 2.03291f, 0.840166f, -2.85767f, 
		2.03291f, 0.840166f, -2.85767f, 2.03301f, 0.899333f, -2.89099f, 
		2.03307f, 0.817193f, -2.98680f, 2.03316f, 0.796167f, -2.96734f, 
		2.03329f, 0.0969330f, -3.13340f, 2.03329f, 0.0969330f, -3.13340f, 
		2.03331f, 0.839586f, -2.85493f, 2.03331f, 0.839586f, -2.85493f, 
		2.03331f, 0.839586f, -2.85493f, 2.03338f, 0.699678f, -2.90062f, 
		2.03338f, 0.699678f, -2.90062f, 2.03347f, -0.842576f, -2.96988f, 
		2.03355f, 0.687732f, -2.85448f, 2.03361f, 0.744609f, -2.84523f, 
		2.03364f, 0.840318f, -3.16153f, 2.03375f, 0.836427f, -2.84760f, 
		2.03376f, 0.679929f, -2.98443f, 2.03377f, 1.08611f, -2.96174f, 
		2.03378f, -0.864530f, -2.97013f, 2.03378f, -0.864530f, -2.97013f, 
		2.03395f, 0.207681f, -3.06097f, 2.03397f, 0.827752f, -2.84315f, 
		2.03399f, 0.801109f, -2.83293f, 2.03400f, 0.745420f, -2.84542f, 
		2.03400f, 0.745420f, -2.84542f, 2.03404f, 0.793032f, -2.89968f, 
		2.03405f, 0.359424f, -3.14795f, 2.03405f, 0.359424f, -3.14795f, 
		2.03435f, 0.863063f, -2.86578f, 2.03437f, 0.839119f, -2.86725f, 
		2.03449f, 0.706826f, -2.93028f, 2.03453f, 0.310307f, -2.97476f, 
		2.03459f, 0.852048f, -2.85280f, 2.03462f, -0.849238f, -2.61783f, 
		2.03462f, -0.849238f, -2.61783f, 2.03462f, -0.849238f, -2.61783f, 
		2.03462f, -0.849238f, -2.61783f, 2.03465f, 0.888766f, -2.88064f, 
		2.03474f, 0.782204f, -3.07318f, 2.03476f, 0.815028f, -2.83956f, 
		2.03477f, 0.912090f, -2.92159f, 2.03492f, 0.850624f, -2.86831f, 
		2.03492f, 0.850624f, -2.86831f, 2.03492f, 0.850624f, -2.86831f, 
		2.03499f, 0.698262f, -2.90279f, 2.03504f, 0.701133f, -2.90244f, 
		2.03504f, 0.701133f, -2.90244f, 2.03511f, 0.851223f, -2.85939f, 
		2.03511f, 0.851223f, -2.85939f, 2.03511f, 0.851223f, -2.85939f, 
		2.03511f, 0.851223f, -2.85939f, 2.03511f, 0.851223f, -2.85939f, 
		2.03517f, 1.05025f, -3.08579f, 2.03522f, 0.846416f, -2.99499f, 
		2.03522f, 0.854257f, -2.84304f, 2.03522f, 0.854257f, -2.84304f, 
		2.03522f, 0.854257f, -2.84304f, 2.03524f, 0.795564f, -2.80870f, 
		2.03537f, 0.403806f, -3.02539f, 2.03537f, -0.105412f, -3.07101f, 
		2.03537f, -0.105412f, -3.07101f, 2.03543f, 0.944633f, -2.82187f, 
		2.03544f, 0.977417f, -2.83369f, 2.03557f, 0.695728f, -2.86074f, 
		2.03557f, 0.695728f, -2.86074f, 2.03557f, 0.695728f, -2.86074f, 
		2.03557f, 0.695728f, -2.86074f, 2.03559f, 0.876064f, -2.87297f, 
		2.03560f, 0.704024f, -2.93056f, 2.03560f, 0.704024f, -2.93056f, 
		2.03572f, 0.157373f, -3.11743f, 2.03603f, 0.824988f, -2.87172f, 
		2.03609f, 0.699260f, -2.87030f, 2.03613f, 0.256828f, -3.06399f, 
		2.03614f, 0.893388f, -2.97622f, 2.03629f, -0.862477f, -3.06791f, 
		2.03639f, -0.109783f, -3.03559f, 2.03648f, 0.886327f, -2.98234f, 
		2.03658f, 0.306243f, -3.13243f, 2.03681f, 0.691014f, -2.86300f, 
		2.03683f, 0.675284f, -2.86323f, 2.03683f, 0.905282f, -2.90156f, 
		2.03685f, 1.00931f, -3.14635f, 2.03705f, 0.755199f, -2.90784f, 
		2.03705f, 0.755199f, -2.90784f, 2.03705f, 0.755199f, -2.90784f, 
		2.03707f, 0.788660f, -2.91126f, 2.03708f, 1.02944f, -2.85683f, 
		2.03712f, 0.702386f, -2.93135f, 2.03716f, 0.705228f, -2.93089f, 
		2.03716f, 0.705228f, -2.93089f, 2.03722f, 0.696471f, -2.87082f, 
		2.03722f, 0.696471f, -2.87082f, 2.03724f, 0.806849f, -2.88336f, 
		2.03725f, -0.865056f, -2.61623f, 2.03725f, -0.865056f, -2.61623f, 
		2.03725f, -0.865056f, -2.61623f, 2.03732f, 0.790582f, -2.95545f, 
		2.03742f, 0.923411f, -2.81949f, 2.03765f, 0.873700f, -2.83042f, 
		2.03777f, 0.912134f, -2.93296f, 2.03779f, 0.809226f, -2.81795f, 
		2.03780f, 0.843675f, -3.15419f, 2.03785f, 0.236690f, -3.14027f, 
		2.03785f, 0.236690f, -3.14027f, 2.03785f, 0.236690f, -3.14027f, 
		2.03786f, 0.304270f, -3.06788f, 2.03792f, 0.309737f, -3.15129f, 
		2.03792f, 0.309737f, -3.15129f, 2.03822f, 0.0627660f, -2.98217f, 
		2.03838f, 0.659508f, -2.87466f, 2.03852f, 0.718200f, -2.82521f, 
		2.03859f, 0.839260f, -2.86715f, 2.03864f, 0.695225f, -2.87433f, 
		2.03868f, 0.639872f, -2.91870f, 2.03869f, 0.698117f, -2.87411f, 
		2.03869f, 0.698117f, -2.87411f, 2.03870f, 0.253520f, -3.13889f, 
		2.03876f, 0.740971f, -2.80601f, 2.03878f, 0.352011f, -3.07428f, 
		2.03895f, 0.748765f, -2.86395f, 2.03895f, 0.748765f, -2.86395f, 
		2.03901f, 0.775447f, -2.77036f, 2.03901f, 0.775447f, -2.77036f, 
		2.03901f, 0.775447f, -2.77036f, 2.03901f, 0.775447f, -2.77036f, 
		2.03901f, 0.775447f, -2.77036f, 2.03901f, 0.775447f, -2.77036f, 
		2.03901f, 0.775447f, -2.77036f, 2.03901f, 0.775447f, -2.77036f, 
		2.03909f, 0.822501f, -2.82484f, 2.03912f, 0.835026f, -2.82844f, 
		2.03912f, 0.235627f, -3.15829f, 2.03912f, 0.235627f, -3.15829f, 
		2.03913f, 0.728225f, -2.82573f, 2.03913f, 0.805381f, -2.97638f, 
		2.03920f, 0.787444f, -2.94346f, 2.03944f, 0.910048f, -2.94544f, 
		2.03945f, 0.877522f, -2.98694f, 2.03956f, 0.786598f, -2.92361f, 
		2.03968f, 0.748197f, -2.86402f, 2.03971f, 0.845698f, -2.83114f, 
		2.03975f, 0.853913f, -2.86788f, 2.03976f, 0.448441f, -3.03587f, 
		2.03978f, 0.858327f, -2.83093f, 2.03985f, 0.869212f, -2.99047f, 
		2.04004f, 0.256271f, -3.15584f, 2.04004f, 0.256271f, -3.15584f, 
		2.04013f, 0.909085f, -2.91327f, 2.04031f, 0.731926f, -3.08504f, 
		2.04031f, 0.731926f, -3.08504f, 2.04047f, 0.905629f, -2.95733f, 
		2.04054f, 0.797668f, -2.96660f, 2.04056f, 0.213479f, -3.12458f, 
		2.04056f, 0.213479f, -3.12458f, 2.04058f, 0.827148f, -2.98972f, 
		2.04066f, 0.391930f, -3.08296f, 2.04067f, 0.451947f, -3.09549f, 
		2.04067f, 0.451947f, -3.09549f, 2.04067f, 0.451947f, -3.09549f, 
		2.04068f, 0.203830f, -2.94423f, 2.04070f, 0.492731f, -3.04761f, 
		2.04071f, 1.01350f, -2.86073f, 2.04080f, 0.711793f, -2.95919f, 
		2.04080f, 0.711793f, -2.95919f, 2.04084f, 0.899043f, -2.96821f, 
		2.04089f, 0.676304f, -2.87296f, 2.04096f, 0.786847f, -2.93307f, 
		2.04105f, 0.711217f, -2.82737f, 2.04105f, 0.711217f, -2.82737f, 
		2.04108f, 0.857873f, -2.99268f, 2.04128f, 0.747237f, -2.84901f, 
		2.04128f, 0.747237f, -2.84901f, 2.04128f, 0.747237f, -2.84901f, 
		2.04128f, 0.747237f, -2.84901f, 2.04166f, 0.837975f, -2.99232f, 
		2.04172f, 0.708729f, -2.95896f, 2.04172f, 0.708729f, -2.95896f, 
		2.04172f, 0.708729f, -2.95896f, 2.04173f, 0.894818f, -2.82063f, 
		2.04186f, 0.755118f, -2.77061f, 2.04186f, 0.755118f, -2.77061f, 
		2.04192f, 0.815666f, -2.87822f, 2.04214f, 0.741579f, -2.84279f, 
		2.04214f, 0.741579f, -2.84279f, 2.04216f, 0.154260f, -2.94631f, 
		2.04218f, 0.752868f, -2.89068f, 2.04218f, 0.752868f, -2.89068f, 
		2.04220f, 0.850571f, -2.86695f, 2.04223f, 0.895217f, -2.88939f, 
		2.04252f, 0.787055f, -2.78388f, 2.04252f, 0.787055f, -2.78388f, 
		2.04258f, 0.735141f, -2.82272f, 2.04258f, 0.735141f, -2.82272f, 
		2.04258f, 0.735141f, -2.82272f, 2.04268f, 0.258633f, -2.94540f, 
		2.04273f, 0.360147f, -2.98349f, 2.04274f, 0.871858f, -2.87315f, 
		2.04285f, 0.831735f, -2.87124f, 2.04289f, 0.810745f, -3.15547f, 
		2.04293f, 0.709952f, -2.95785f, 2.04293f, 0.709952f, -2.95785f, 
		2.04293f, 0.709952f, -2.95785f, 2.04296f, 0.842787f, -2.86930f, 
		2.04302f, 0.752379f, -2.89160f, 2.04308f, 0.151517f, -3.15295f, 
		2.04308f, 0.151517f, -3.15295f, 2.04308f, 0.151517f, -3.15295f, 
		2.04313f, 0.707074f, -2.95883f, 2.04313f, 0.707074f, -2.95883f, 
		2.04334f, 0.698293f, -2.85271f, 2.04365f, 0.430447f, -3.09162f, 
		2.04388f, 0.401608f, -3.10105f, 2.04388f, 0.401608f, -3.10105f, 
		2.04388f, 0.401608f, -3.10105f, 2.04418f, 0.738210f, -2.81790f, 
		2.04418f, 0.738210f, -2.81790f, 2.04418f, 0.738210f, -2.81790f, 
		2.04425f, 0.864942f, -2.87133f, 2.04432f, 1.07644f, -2.96317f, 
		2.04433f, 0.889501f, -2.97700f, 2.04434f, 0.688125f, -2.92239f, 
		2.04436f, 0.717365f, -2.83690f, 2.04439f, 0.731899f, -3.04313f, 
		2.04440f, 0.695514f, -2.85339f, 2.04440f, 0.695514f, -2.85339f, 
		2.04463f, 0.797197f, -2.89803f, 2.04466f, 0.653614f, -2.91472f, 
		2.04479f, 0.209365f, -3.16471f, 2.04479f, 0.209365f, -3.16471f, 
		2.04479f, 0.209365f, -3.16471f, 2.04497f, -0.197303f, -3.03939f, 
		2.04500f, 0.711140f, -2.83529f, 2.04500f, 0.711140f, -2.83529f, 
		2.04500f, 0.663638f, -2.94075f, 2.04521f, 0.848897f, -2.99216f, 
		2.04523f, -0.193791f, -3.07019f, 2.04523f, -0.193791f, -3.07019f, 
		2.04536f, 0.353045f, -3.10934f, 2.04536f, 0.353045f, -3.10934f, 
		2.04536f, 0.353045f, -3.10934f, 2.04537f, -0.836989f, -2.62103f, 
		2.04537f, -0.836989f, -2.62103f, 2.04537f, -0.836989f, -2.62103f, 
		2.04537f, -0.836989f, -2.62103f, 2.04538f, 0.653144f, -2.91491f, 
		2.04538f, 0.653144f, -2.91491f, 2.04541f, 0.881849f, -2.87927f, 
		2.04549f, 0.800882f, -2.79676f, 2.04549f, 0.800882f, -2.79676f, 
		2.04551f, 0.697215f, -2.85753f, 2.04551f, 0.697215f, -2.85753f, 
		2.04553f, 0.694316f, -2.85762f, 2.04560f, 0.0769520f, -3.08431f, 
		2.04560f, 0.909416f, -2.92460f, 2.04561f, 0.802098f, -2.89175f, 
		2.04571f, 0.663136f, -2.94084f, 2.04571f, 0.663136f, -2.94084f, 
		2.04573f, 0.816418f, -2.98253f, 2.04582f, 0.744708f, -2.82877f, 
		2.04582f, 0.744708f, -2.82877f, 2.04582f, 0.744708f, -2.82877f, 
		2.04582f, 0.744708f, -2.82877f, 2.04587f, 0.880982f, -2.98269f, 
		2.04593f, 0.874989f, -2.82468f, 2.04608f, 0.745516f, -2.82914f, 
		2.04608f, 0.745516f, -2.82914f, 2.04617f, 0.627997f, -2.87698f, 
		2.04617f, 0.627997f, -2.87698f, 2.04617f, 0.627997f, -2.87698f, 
		2.04617f, 0.627997f, -2.87698f, 2.04619f, 0.465165f, -3.15485f, 
		2.04619f, 0.465165f, -3.15485f, 2.04619f, 0.465165f, -3.15485f, 
		2.04657f, 0.815621f, -3.14844f, 2.04696f, 0.824711f, -2.87539f, 
		2.04717f, 0.304417f, -3.11824f, 2.04717f, 0.304417f, -3.11824f, 
		2.04717f, 0.113147f, -2.95322f, 2.04721f, 0.900646f, -2.89977f, 
		2.04736f, 0.813415f, -2.80627f, 2.04736f, 0.813415f, -2.80627f, 
		2.04747f, 0.908677f, -2.93718f, 2.04751f, 0.152437f, -3.12612f, 
		2.04769f, 0.799488f, -2.96503f, 2.04774f, 0.698576f, -2.87149f, 
		2.04774f, 0.698576f, -2.87149f, 2.04775f, 0.701525f, -2.87110f, 
		2.04776f, 0.235514f, -3.12713f, 2.04776f, 0.235514f, -3.12713f, 
		2.04787f, 0.789928f, -2.94156f, 2.04800f, 0.411181f, -3.15665f, 
		2.04800f, 0.411181f, -3.15665f, 2.04803f, 0.122100f, -3.08042f, 
		2.04817f, 0.643278f, -2.94530f, 2.04818f, 0.252043f, -3.12619f, 
		2.04818f, 0.252043f, -3.12619f, 2.04820f, 0.860057f, -2.82533f, 
		2.04824f, 0.310699f, -2.94928f, 2.04827f, 0.793661f, -2.95375f, 
		2.04835f, 0.526351f, -3.06629f, 2.04837f, 0.683418f, -2.83656f, 
		2.04837f, 0.683418f, -2.83656f, 2.04838f, 0.900454f, -2.96114f, 
		2.04841f, 0.905647f, -2.94953f, 2.04844f, 0.793124f, -2.90950f, 
		2.04869f, 0.841408f, -2.87166f, 2.04878f, 0.826486f, -2.81475f, 
		2.04878f, 0.826486f, -2.81475f, 2.04882f, 0.806123f, -2.97243f, 
		2.04889f, 0.672817f, -2.96345f, 2.04889f, 0.672817f, -2.96345f, 
		2.04889f, 0.672817f, -2.96345f, 2.04896f, 0.848233f, -2.82309f, 
		2.04902f, 0.699976f, -2.87437f, 2.04902f, 0.699976f, -2.87437f, 
		2.04905f, 0.837785f, -2.81956f, 2.04905f, 0.837785f, -2.81956f, 
		2.04905f, 0.837785f, -2.81956f, 2.04905f, 0.837785f, -2.81956f, 
		2.04918f, 0.674835f, -2.83644f, 2.04927f, 0.159304f, -3.07719f, 
		2.04930f, 0.825963f, -2.98587f, 2.04931f, 0.0336410f, -3.08594f, 
		2.04932f, 0.646097f, -2.88704f, 2.04932f, 0.646097f, -2.88704f, 
		2.04932f, 0.646097f, -2.88704f, 2.04932f, 0.646097f, -2.88704f, 
		2.04941f, 1.05457f, -2.83057f, 2.04941f, 1.05457f, -2.83057f, 
		2.04948f, 0.789781f, -2.92906f, 2.04948f, 0.406562f, -2.99335f, 
		2.04957f, -0.790584f, -3.02720f, 2.04972f, 0.361354f, -3.15918f, 
		2.04972f, 0.361354f, -3.15918f, 2.04985f, 0.852263f, -2.87158f, 
		2.05001f, 0.645661f, -2.88736f, 2.05001f, 0.645661f, -2.88736f, 
		2.05002f, 0.746901f, -2.83409f, 2.05002f, 0.746901f, -2.83409f, 
		2.05003f, 0.697099f, -2.85617f, 2.05003f, 0.697099f, -2.85617f, 
		2.05013f, 0.810245f, -2.88610f, 2.05014f, 0.872556f, -2.98509f, 
		2.05037f, 0.514312f, -3.15255f, 2.05037f, 0.514312f, -3.15255f, 
		2.05037f, 0.514312f, -3.15255f, 2.05037f, 0.514312f, -3.15255f, 
		2.05039f, 0.946774f, -2.81801f, 2.05050f, -0.262821f, -3.07355f, 
		2.05050f, -0.262821f, -3.07355f, 2.05053f, 0.791664f, -2.91868f, 
		2.05060f, 0.860382f, -2.98887f, 2.05068f, -0.265945f, -3.04626f, 
		2.05078f, 0.698385f, -2.85992f, 2.05078f, 0.698385f, -2.85992f, 
		2.05095f, 0.702670f, -2.89836f, 2.05095f, 0.702670f, -2.89836f, 
		2.05098f, 0.705633f, -2.89788f, 2.05119f, 0.812149f, -2.97648f, 
		2.05123f, 0.0617470f, -2.96478f, 2.05124f, 0.904108f, -2.91133f, 
		2.05134f, 0.926027f, -2.81651f, 2.05138f, 0.888255f, -2.88740f, 
		2.05162f, 0.311343f, -3.16106f, 2.05162f, 0.311343f, -3.16106f, 
		2.05170f, 0.684532f, -2.84360f, 2.05170f, 0.684532f, -2.84360f, 
		2.05176f, 0.703903f, -2.90030f, 2.05176f, 0.703903f, -2.90030f, 
		2.05182f, 0.979241f, -2.82794f, 2.05189f, 0.818382f, -2.88120f, 
		2.05189f, 0.873213f, -2.87779f, 2.05207f, 0.206803f, -3.07853f, 
		2.05227f, 0.150607f, -3.14036f, 2.05227f, 0.150607f, -3.14036f, 
		2.05234f, 0.740917f, -2.79335f, 2.05234f, 0.235278f, -3.16796f, 
		2.05234f, 0.235278f, -3.16796f, 2.05238f, 0.894782f, -2.96647f, 
		2.05241f, 1.07356f, -3.08244f, 2.05242f, 0.837815f, -2.98798f, 
		2.05273f, 0.257651f, -3.16480f, 2.05273f, 0.257651f, -3.16480f, 
		2.05279f, 0.701256f, -2.90056f, 2.05292f, 0.761915f, -2.94452f, 
		2.05292f, 0.761915f, -2.94452f, 2.05292f, 0.761915f, -2.94452f, 
		2.05292f, 0.454626f, -3.09321f, 2.05292f, 0.454626f, -3.09321f, 
		2.05292f, 0.454626f, -3.09321f, 2.05292f, 0.454626f, -3.09321f, 
		2.05316f, 0.896442f, -2.81862f, 2.05324f, 0.660414f, -2.84475f, 
		2.05329f, 0.678944f, -2.84556f, 2.05349f, 0.905107f, -2.92055f, 
		2.05364f, 0.904954f, -2.94242f, 2.05367f, 0.761388f, -2.94487f, 
		2.05367f, 0.761388f, -2.94487f, 2.05370f, 0.830492f, -2.87645f, 
		2.05370f, 0.255436f, -3.08086f, 2.05373f, 0.900989f, -2.95454f, 
		2.05393f, 0.861563f, -2.87490f, 2.05404f, -0.00297600f, -3.08994f, 
		2.05404f, -0.00297600f, -3.08994f, 2.05404f, -0.00297600f, -3.08994f, 
		2.05436f, 0.799406f, -2.90301f, 2.05469f, 0.00783600f, -2.99172f, 
		2.05469f, 0.00783600f, -2.99172f, 2.05469f, 0.00783600f, -2.99172f, 
		2.05469f, 0.00783600f, -2.99172f, 2.05469f, 0.00783600f, -2.99172f, 
		2.05470f, 0.703050f, -3.01255f, 2.05477f, 1.03082f, -2.85051f, 
		2.05484f, 0.886783f, -2.97312f, 2.05500f, 0.706486f, -2.97011f, 
		2.05514f, 0.881212f, -2.97739f, 2.05525f, 0.905326f, -2.92996f, 
		2.05526f, 0.302247f, -3.08472f, 2.05528f, 0.845596f, -2.87434f, 
		2.05535f, 0.698387f, -2.83650f, 2.05545f, -0.0174780f, -2.99785f, 
		2.05545f, -0.0174780f, -2.99785f, 2.05576f, -0.329275f, -3.05166f, 
		2.05594f, 0.850548f, -2.98711f, 2.05596f, 0.876184f, -2.82353f, 
		2.05610f, 0.710033f, -2.92424f, 2.05630f, 0.695586f, -2.83736f, 
		2.05630f, 0.695586f, -2.83736f, 2.05647f, 0.894053f, -2.89810f, 
		2.05655f, 0.638436f, -2.85280f, 2.05656f, 0.805021f, -2.89678f, 
		2.05664f, 0.716031f, -2.96876f, 2.05670f, -0.326850f, -3.07565f, 
		2.05670f, -0.326850f, -3.07565f, 2.05680f, 0.642840f, -2.87064f, 
		2.05680f, 0.642840f, -2.87064f, 2.05680f, 0.642840f, -2.87064f, 
		2.05680f, 0.642840f, -2.87064f, 2.05681f, 0.697334f, -2.84230f, 
		2.05681f, 0.697334f, -2.84230f, 2.05686f, 0.451870f, -3.00376f, 
		2.05694f, 0.694414f, -2.84221f, 2.05695f, 0.348942f, -3.09203f, 
		2.05728f, 0.674456f, -2.91368f, 2.05729f, 0.873083f, -2.98065f, 
		2.05737f, -0.112094f, -3.01235f, 2.05737f, -0.112094f, -3.01235f, 
		2.05737f, -0.112094f, -3.01235f, 2.05743f, 0.642430f, -2.87109f, 
		2.05743f, 0.642430f, -2.87109f, 2.05767f, 0.705428f, -2.92561f, 
		2.05771f, 0.751094f, -2.89012f, 2.05773f, 0.794182f, -2.92725f, 
		2.05803f, 0.821447f, -2.97834f, 2.05804f, 0.796727f, -2.91491f, 
		2.05818f, 0.876597f, -2.88383f, 2.05824f, 0.776450f, -2.77288f, 
		2.05824f, 0.776450f, -2.77288f, 2.05824f, 0.776450f, -2.77288f, 
		2.05824f, 0.776450f, -2.77288f, 2.05824f, 0.776450f, -2.77288f, 
		2.05825f, 0.663669f, -2.97554f, 2.05827f, 0.360765f, -2.95825f, 
		2.05827f, 0.661313f, -2.85415f, 2.05827f, 0.661313f, -2.85415f, 
		2.05827f, 0.661313f, -2.85415f, 2.05827f, 0.661313f, -2.85415f, 
		2.05834f, 0.860843f, -2.82396f, 2.05839f, 0.625197f, -2.90563f, 
		2.05839f, 0.625197f, -2.90563f, 2.05839f, 0.625197f, -2.90563f, 
		2.05842f, 0.798821f, -2.95218f, 2.05862f, 0.862864f, -2.98358f, 
		2.05867f, 0.819568f, -2.88506f, 2.05871f, 0.737862f, -2.80920f, 
		2.05871f, 0.737862f, -2.80920f, 2.05871f, 0.737862f, -2.80920f, 
		2.05876f, 0.795481f, -2.93989f, 2.05885f, 1.06210f, -3.07796f, 
		2.05891f, 1.02930f, -3.16645f, 2.05892f, 0.804674f, -2.96228f, 
		2.05892f, 0.766519f, -3.06543f, 2.05904f, 0.696859f, -2.84089f, 
		2.05904f, 0.696859f, -2.84089f, 2.05904f, 0.388774f, -3.10185f, 
		2.05912f, -0.102955f, -3.09193f, 2.05912f, -0.102955f, -3.09193f, 
		2.05915f, -0.364996f, -3.05433f, 2.05915f, 0.697875f, -2.96894f, 
		2.05922f, 0.810092f, -2.96837f, 2.05931f, 0.750858f, -3.08357f, 
		2.05935f, 0.698065f, -2.84540f, 2.05935f, 0.698065f, -2.84540f, 
		2.05936f, 0.776096f, -3.14594f, 2.05987f, 0.840561f, -2.87776f, 
		2.06005f, -0.361995f, -3.07697f, 2.06005f, -0.361995f, -3.07697f, 
		2.06018f, 0.735876f, -2.81064f, 2.06018f, 0.735876f, -2.81064f, 
		2.06018f, 0.735876f, -2.81064f, 2.06018f, 0.735876f, -2.81064f, 
		2.06018f, 0.735876f, -2.81064f, 2.06026f, 0.683129f, -2.89460f, 
		2.06026f, 0.683129f, -2.89460f, 2.06026f, 0.152285f, -2.92691f, 
		2.06032f, 0.202118f, -2.92292f, 2.06037f, 0.867346f, -2.88083f, 
		2.06050f, 0.680565f, -2.88013f, 2.06050f, 0.680565f, -2.88013f, 
		2.06064f, 0.758213f, -2.77070f, 2.06064f, 0.758213f, -2.77070f, 
		2.06064f, 0.758213f, -2.77070f, 2.06064f, 0.758213f, -2.77070f, 
		2.06064f, 0.758213f, -2.77070f, 2.06071f, 0.812409f, -2.89283f, 
		2.06079f, 0.888634f, -2.96595f, 2.06102f, 0.544025f, -3.09790f, 
		2.06102f, 0.544025f, -3.09790f, 2.06102f, 0.544025f, -3.09790f, 
		2.06110f, 0.896351f, -2.95378f, 2.06114f, 0.883886f, -2.89141f, 
		2.06118f, 0.801628f, -2.90815f, 2.06119f, 0.897033f, -2.90957f, 
		2.06123f, 0.786635f, -2.78683f, 2.06128f, 0.428566f, -3.11133f, 
		2.06128f, 0.428566f, -3.11133f, 2.06128f, 0.428566f, -3.11133f, 
		2.06138f, -0.199018f, -3.02059f, 2.06145f, 0.648763f, -2.88800f, 
		2.06145f, 0.648763f, -2.88800f, 2.06148f, 0.848649f, -2.82295f, 
		2.06157f, 0.900114f, -2.94160f, 2.06164f, 0.746497f, -2.82011f, 
		2.06164f, 0.746497f, -2.82011f, 2.06164f, 0.746497f, -2.82011f, 
		2.06164f, 0.746497f, -2.82011f, 2.06166f, 0.727382f, -2.81018f, 
		2.06168f, 0.711510f, -2.95160f, 2.06168f, 0.711510f, -2.95160f, 
		2.06168f, 0.711510f, -2.95160f, 2.06171f, 0.747282f, -2.82058f, 
		2.06171f, 0.747282f, -2.82058f, 2.06175f, 0.943063f, -2.81572f, 
		2.06175f, 0.943063f, -2.81572f, 2.06175f, 0.943063f, -2.81572f, 
		2.06177f, 0.201683f, -3.16116f, 2.06177f, 0.201683f, -3.16116f, 
		2.06177f, 0.201683f, -3.16116f, 2.06177f, 0.201683f, -3.16116f, 
		2.06177f, 0.201683f, -3.16116f, 2.06177f, 0.201683f, -3.16116f, 
		2.06178f, 1.02296f, -3.15885f, 2.06185f, 0.649510f, -2.88779f, 
		2.06185f, 0.649510f, -2.88779f, 2.06185f, 0.649510f, -2.88779f, 
		2.06186f, 0.714671f, -2.95150f, 2.06186f, 0.714671f, -2.95150f, 
		2.06189f, -0.862477f, -3.03175f, 2.06189f, 0.799178f, -2.79868f, 
		2.06192f, 0.712496f, -2.95087f, 2.06192f, 0.712496f, -2.95087f, 
		2.06192f, 0.712496f, -2.95087f, 2.06200f, 0.229449f, -3.12557f, 
		2.06202f, 0.833894f, -2.98089f, 2.06203f, -0.847944f, -2.68619f, 
		2.06207f, -0.866174f, -2.68624f, 2.06207f, -0.866174f, -2.68624f, 
		2.06217f, -0.871814f, -2.62596f, 2.06220f, 0.782751f, -3.13939f, 
		2.06228f, 0.677985f, -2.86490f, 2.06228f, 0.677985f, -2.86490f, 
		2.06244f, 0.447216f, -3.09354f, 2.06244f, 0.447216f, -3.09354f, 
		2.06244f, 0.447216f, -3.09354f, 2.06247f, 0.685620f, -2.90801f, 
		2.06247f, 0.685620f, -2.90801f, 2.06248f, 0.928094f, -2.81166f, 
		2.06256f, 0.249927f, -3.12473f, 2.06262f, 0.857034f, -2.87977f, 
		2.06265f, 0.838217f, -2.81959f, 2.06270f, 0.719459f, -2.80871f, 
		2.06275f, 0.939802f, -2.80490f, 2.06275f, 0.939802f, -2.80490f, 
		2.06275f, 0.939802f, -2.80490f, 2.06278f, 0.0140500f, -2.98304f, 
		2.06278f, 0.0140500f, -2.98304f, 2.06278f, 0.0140500f, -2.98304f, 
		2.06285f, 0.812624f, -2.80853f, 2.06288f, -0.398959f, -3.05697f, 
		2.06293f, 0.926363f, -2.80527f, 2.06293f, 0.926363f, -2.80527f, 
		2.06293f, 0.926363f, -2.80527f, 2.06294f, 0.258284f, -2.92289f, 
		2.06296f, 0.302281f, -3.11646f, 2.06314f, 0.709821f, -2.95151f, 
		2.06314f, 0.709821f, -2.95151f, 2.06324f, 0.110639f, -2.93599f, 
		2.06327f, 0.825781f, -2.81575f, 2.06334f, 0.807258f, -2.90170f, 
		2.06336f, 0.919142f, -2.81523f, 2.06336f, 0.919142f, -2.81523f, 
		2.06336f, 0.919142f, -2.81523f, 2.06338f, 0.692613f, -2.87995f, 
		2.06338f, 0.692613f, -2.87995f, 2.06338f, 0.692613f, -2.87995f, 
		2.06338f, 0.692613f, -2.87995f, 2.06338f, 0.692613f, -2.87995f, 
		2.06360f, 0.657097f, -2.91272f, 2.06360f, 0.657097f, -2.91272f, 
		2.06360f, 0.657097f, -2.91272f, 2.06362f, 0.748354f, -2.82606f, 
		2.06362f, 0.748354f, -2.82606f, 2.06368f, 0.350654f, -3.10711f, 
		2.06369f, 1.09152f, -2.94999f, 2.06377f, -0.395915f, -3.07933f, 
		2.06377f, -0.395915f, -3.07933f, 2.06398f, 0.657550f, -2.91192f, 
		2.06398f, 0.657550f, -2.91192f, 2.06407f, 0.949187f, -2.81286f, 
		2.06414f, 0.645126f, -2.87426f, 2.06414f, 0.645126f, -2.87426f, 
		2.06427f, 0.398948f, -3.09844f, 2.06434f, 0.696670f, -2.89292f, 
		2.06434f, 0.696670f, -2.89292f, 2.06434f, 0.696670f, -2.89292f, 
		2.06434f, 0.696670f, -2.89292f, 2.06434f, 0.800049f, -2.92040f, 
		2.06447f, -0.803843f, -3.01037f, 2.06447f, -0.803843f, -3.01037f, 
		2.06447f, -0.803843f, -3.01037f, 2.06449f, 0.719931f, -3.04163f, 
		2.06452f, 0.970508f, -3.19373f, 2.06461f, 0.712525f, -2.81135f, 
		2.06461f, 0.712525f, -2.81135f, 2.06485f, 0.861334f, -2.97917f, 
		2.06487f, 0.848192f, -2.98087f, 2.06487f, 0.687049f, -2.86549f, 
		2.06493f, 1.01619f, -2.85295f, 2.06502f, 0.897407f, -2.92067f, 
		2.06505f, 0.832270f, -2.88400f, 2.06505f, 0.498660f, -3.01577f, 
		2.06512f, 0.822291f, -2.97282f, 2.06518f, 0.898311f, -2.92868f, 
		2.06519f, -0.832671f, -2.68303f, 2.06519f, -0.832671f, -2.68303f, 
		2.06519f, -0.832671f, -2.68303f, 2.06539f, 0.877000f, -2.97110f, 
		2.06543f, 0.728463f, -2.96468f, 2.06544f, 0.822214f, -2.88943f, 
		2.06550f, -0.267374f, -3.02876f, 2.06550f, -0.267374f, -3.02876f, 
		2.06550f, -0.267374f, -3.02876f, 2.06564f, 0.886279f, -2.89941f, 
		2.06586f, 0.869463f, -2.97539f, 2.06586f, 0.802498f, -2.94561f, 
		2.06588f, 0.923810f, -3.20152f, 2.06605f, -0.862038f, -3.10759f, 
		2.06605f, -0.862038f, -3.10759f, 2.06605f, -0.824912f, -3.10759f, 
		2.06608f, 0.688742f, -2.92377f, 2.06608f, 0.688742f, -2.92377f, 
		2.06613f, 0.619693f, -2.85970f, 2.06613f, 0.619693f, -2.85970f, 
		2.06613f, 0.619693f, -2.85970f, 2.06613f, 0.619693f, -2.85970f, 
		2.06613f, 0.619693f, -2.85970f, 2.06613f, 0.742035f, -2.82605f, 
		2.06613f, 0.742035f, -2.82605f, 2.06621f, 0.675095f, -2.88114f, 
		2.06624f, 0.700045f, -2.90495f, 2.06624f, 0.700045f, -2.90495f, 
		2.06647f, 0.407257f, -2.96764f, 2.06647f, 0.897926f, -2.81642f, 
		2.06662f, 0.202376f, -3.13215f, 2.06666f, -0.826250f, -2.63153f, 
		2.06666f, -0.826250f, -2.63153f, 2.06666f, -0.826250f, -2.63153f, 
		2.06676f, 1.08071f, -2.95427f, 2.06676f, 0.721463f, -3.07815f, 
		2.06676f, 0.721463f, -3.07815f, 2.06685f, 0.673443f, -2.86624f, 
		2.06687f, 0.874679f, -2.89029f, 2.06698f, 0.0587130f, -2.94805f, 
		2.06709f, 0.967181f, -3.18473f, 2.06729f, 0.813830f, -2.96296f, 
		2.06741f, -0.191760f, -3.08902f, 2.06741f, -0.191760f, -3.08902f, 
		2.06742f, 0.718578f, -2.82102f, 2.06746f, 0.804957f, -2.91354f, 
		2.06753f, 0.881299f, -3.19626f, 2.06756f, 0.883942f, -2.96272f, 
		2.06777f, 0.712419f, -2.81971f, 2.06777f, 0.712419f, -2.81971f, 
		2.06782f, 0.890486f, -2.90893f, 2.06789f, 0.311503f, -2.92737f, 
		2.06796f, 0.843562f, -2.88410f, 2.06799f, 0.807002f, -2.95175f, 
		2.06808f, 0.676269f, -2.89493f, 2.06826f, 0.802351f, -2.93216f, 
		2.06829f, 0.855403f, -2.88449f, 2.06834f, -0.330287f, -3.03601f, 
		2.06838f, 0.922881f, -3.19212f, 2.06853f, 0.894108f, -2.94088f, 
		2.06863f, 0.0155360f, -2.97244f, 2.06880f, 0.641098f, -2.85541f, 
		2.06880f, 0.641098f, -2.85541f, 2.06880f, 0.641098f, -2.85541f, 
		2.06880f, 0.641098f, -2.85541f, 2.06883f, 0.814340f, -2.90039f, 
		2.06897f, 0.703496f, -2.91799f, 2.06897f, 0.703496f, -2.91799f, 
		2.06909f, 0.633772f, -2.93423f, 2.06930f, -0.488400f, -3.06107f, 
		2.06930f, 0.640702f, -2.85601f, 2.06930f, 0.640702f, -2.85601f, 
		2.06963f, -0.764760f, -3.06787f, 2.06963f, -0.764760f, -3.06787f, 
		2.06963f, -0.764760f, -3.06787f, 2.06963f, -0.764760f, -3.06787f, 
		2.06963f, -0.764760f, -3.06787f, 2.06967f, 0.888836f, -2.95222f, 
		2.06991f, 0.877503f, -2.82512f, 2.06991f, 0.877503f, -2.82512f, 
		2.06991f, 0.877503f, -2.82512f, 2.06995f, 0.882551f, -3.18714f, 
		2.06997f, 0.675729f, -2.95579f, 2.06997f, 0.675729f, -2.95579f, 
		2.06997f, 0.675729f, -2.95579f, 2.07015f, 0.677032f, -2.90707f, 
		2.07023f, -0.485406f, -3.08284f, 2.07023f, -0.485406f, -3.08284f, 
		2.07036f, 0.837014f, -2.97387f, 2.07044f, 0.859032f, -2.82980f, 
		2.07044f, 0.859032f, -2.82980f, 2.07044f, 0.859032f, -2.82980f, 
		2.07051f, -0.260801f, -3.08984f, 2.07051f, -0.260801f, -3.08984f, 
		2.07057f, 0.745482f, -2.79413f, 2.07066f, 0.980836f, -2.82226f, 
		2.07078f, 0.229165f, -3.16467f, 2.07078f, 0.229165f, -3.16467f, 
		2.07078f, 0.229165f, -3.16467f, 2.07078f, 0.229165f, -3.16467f, 
		2.07095f, 0.254442f, -3.16153f, 2.07114f, 0.872577f, -2.96776f, 
		2.07119f, 0.690455f, -2.86151f, 2.07120f, -0.365846f, -3.03965f, 
		2.07135f, 0.806803f, -2.92205f, 2.07143f, 0.862870f, -2.88958f, 
		2.07146f, 0.697401f, -2.82854f, 2.07146f, 0.697401f, -2.82854f, 
		2.07160f, 0.307881f, -3.15720f, 2.07164f, 0.200579f, -3.14740f, 
		2.07164f, 0.200579f, -3.14740f, 2.07181f, 0.876396f, -2.89819f, 
		2.07229f, 0.842263f, -3.19072f, 2.07232f, 0.808231f, -2.94106f, 
		2.07244f, 0.701014f, -2.83243f, 2.07247f, 0.696499f, -2.87483f, 
		2.07249f, 0.682117f, -2.82135f, 2.07249f, 0.682117f, -2.82135f, 
		2.07250f, 0.858645f, -2.97203f, 2.07262f, 0.860146f, -2.88894f, 
		2.07276f, 0.677370f, -2.85114f, 2.07276f, 0.677370f, -2.85114f, 
		2.07276f, 0.677370f, -2.85114f, 2.07276f, 0.677370f, -2.85114f, 
		2.07279f, 0.698079f, -2.83232f, 2.07279f, 0.698079f, -2.83232f, 
		2.07281f, -0.776337f, -3.09650f, 2.07281f, -0.776337f, -3.09650f, 
		2.07281f, -0.776337f, -3.09650f, 2.07281f, -0.776337f, -3.09650f, 
		2.07281f, -0.776337f, -3.09650f, 2.07285f, 0.642984f, -2.86048f, 
		2.07285f, 0.642984f, -2.86048f, 2.07293f, 0.357494f, -3.15448f, 
		2.07310f, 0.888969f, -2.92025f, 2.07313f, 0.826498f, -2.96583f, 
		2.07314f, 0.699207f, -2.83365f, 2.07314f, 0.699207f, -2.83365f, 
		2.07314f, 0.871978f, -2.88211f, 2.07314f, 0.882986f, -2.90733f, 
		2.07322f, 0.120802f, -3.08909f, 2.07325f, 0.869036f, -2.89488f, 
		2.07330f, 0.812285f, -2.91216f, 2.07341f, 0.158174f, -3.08578f, 
		2.07342f, 0.816350f, -2.95582f, 2.07346f, 0.696324f, -2.83347f, 
		2.07347f, 0.450867f, -3.11212f, 2.07347f, 0.450867f, -3.11212f, 
		2.07347f, 0.450867f, -3.11212f, 2.07350f, 0.831849f, -2.89360f, 
		2.07352f, 0.678928f, -2.92044f, 2.07352f, 0.678928f, -2.92044f, 
		2.07352f, 0.678928f, -2.92044f, 2.07362f, 0.853843f, -2.88498f, 
		2.07362f, 0.673140f, -2.82110f, 2.07368f, 0.690168f, -2.96442f, 
		2.07375f, -0.834951f, -3.01276f, 2.07380f, 0.863070f, -2.87581f, 
		2.07385f, 0.0757660f, -3.09474f, 2.07385f, 0.0757660f, -3.09474f, 
		2.07385f, 0.0757660f, -3.09474f, 2.07386f, 0.406869f, -3.15127f, 
		2.07395f, 0.849956f, -2.97139f, 2.07404f, 0.859479f, -2.90115f, 
		2.07428f, 0.888478f, -2.92973f, 2.07431f, 0.699763f, -2.83696f, 
		2.07431f, 0.699763f, -2.83696f, 2.07435f, 0.878388f, -2.89463f, 
		2.07438f, 0.854553f, -2.87555f, 2.07447f, 0.845521f, -3.18188f, 
		2.07460f, 0.850323f, -2.89436f, 2.07467f, 0.824766f, -2.89965f, 
		2.07468f, 0.887463f, -2.93921f, 2.07475f, 0.671902f, -2.86226f, 
		2.07479f, -0.399860f, -3.04247f, 2.07480f, 0.672807f, -2.85357f, 
		2.07480f, 0.672807f, -2.85357f, 2.07480f, 0.672807f, -2.85357f, 
		2.07484f, -0.580376f, -3.06487f, 2.07484f, 0.453205f, -2.97712f, 
		2.07500f, 0.702276f, -2.89243f, 2.07500f, 0.742580f, -2.80640f, 
		2.07500f, 0.742580f, -2.80640f, 2.07500f, 0.742580f, -2.80640f, 
		2.07500f, 0.742580f, -2.80640f, 2.07509f, 0.683441f, -2.82873f, 
		2.07509f, 0.683441f, -2.82873f, 2.07517f, 0.683899f, -3.01210f, 
		2.07518f, 0.226695f, -3.13482f, 2.07541f, 0.683949f, -2.85099f, 
		2.07543f, 0.871453f, -2.86959f, 2.07550f, 0.205686f, -3.08665f, 
		2.07558f, 0.703735f, -2.93136f, 2.07558f, 0.703735f, -2.93136f, 
		2.07558f, 0.703735f, -2.93136f, 2.07558f, 0.764266f, -3.11230f, 
		2.07559f, 0.250227f, -3.13334f, 2.07567f, 0.866323f, -2.90787f, 
		2.07568f, 0.876756f, -2.95708f, 2.07572f, 0.459919f, -3.14869f, 
		2.07572f, 0.459919f, -3.14869f, 2.07572f, 0.459919f, -3.14869f, 
		2.07573f, 0.883835f, -2.88469f, 2.07575f, 0.740812f, -2.96016f, 
		2.07578f, -0.577300f, -3.08714f, 2.07578f, -0.577300f, -3.08714f, 
		2.07591f, 0.845361f, -2.88119f, 2.07592f, -0.326065f, -3.09039f, 
		2.07592f, -0.326065f, -3.09039f, 2.07605f, 0.254533f, -3.08833f, 
		2.07605f, 0.673133f, -2.87712f, 2.07610f, 0.842504f, -2.89384f, 
		2.07614f, 0.813948f, -2.94411f, 2.07625f, -0.855981f, -3.01471f, 
		2.07625f, -0.855981f, -3.01471f, 2.07630f, 0.851045f, -2.89401f, 
		2.07631f, 0.882286f, -2.87484f, 2.07633f, 0.878418f, -2.90401f, 
		2.07639f, 0.811899f, -2.93102f, 2.07644f, 0.691379f, -2.94257f, 
		2.07644f, 0.691379f, -2.94257f, 2.07644f, 0.691379f, -2.94257f, 
		2.07644f, 0.691379f, -2.94257f, 2.07645f, 0.0131920f, -2.96213f, 
		2.07648f, 0.874726f, -2.83136f, 2.07653f, -0.737683f, -3.07119f, 
		2.07653f, -0.737683f, -3.07119f, 2.07653f, -0.737683f, -3.07119f, 
		2.07653f, -0.737683f, -3.07119f, 2.07653f, -0.737683f, -3.07119f, 
		2.07661f, 0.361713f, -2.93837f, 2.07662f, 0.840475f, -2.96683f, 
		2.07663f, 0.677662f, -2.83074f, 2.07667f, 1.03104f, -2.84337f, 
		2.07673f, 0.541025f, -3.03531f, 2.07680f, 0.863909f, -2.96429f, 
		2.07685f, -0.870433f, -3.09328f, 2.07700f, 0.880471f, -2.94789f, 
		2.07704f, 0.841229f, -2.89361f, 2.07708f, 0.775935f, -2.78409f, 
		2.07708f, 0.775935f, -2.78409f, 2.07708f, 0.775935f, -2.78409f, 
		2.07708f, 0.862490f, -2.86360f, 2.07710f, 0.303021f, -3.12582f, 
		2.07720f, 0.874774f, -2.90651f, 2.07721f, 0.806969f, -2.81668f, 
		2.07730f, 0.756941f, -3.05993f, 2.07746f, 1.05541f, -2.82537f, 
		2.07746f, 1.05541f, -2.82537f, 2.07753f, 0.784378f, -2.79590f, 
		2.07759f, 0.795596f, -2.80808f, 2.07762f, 0.833669f, -2.82674f, 
		2.07767f, 0.751057f, -3.12656f, 2.07770f, 0.820850f, -2.82342f, 
		2.07773f, 0.300784f, -3.09211f, 2.07775f, 0.857899f, -2.83657f, 
		2.07777f, 0.846927f, -2.90663f, 2.07783f, 0.866186f, -2.90043f, 
		2.07793f, -0.739018f, -3.09545f, 2.07793f, -0.739018f, -3.09545f, 
		2.07793f, -0.739018f, -3.09545f, 2.07796f, -0.657534f, -3.06754f, 
		2.07811f, 0.829557f, -2.95965f, 2.07815f, 0.890342f, -2.89374f, 
		2.07821f, 0.888699f, -2.87787f, 2.07823f, 0.823606f, -2.90841f, 
		2.07823f, 0.691719f, -2.85886f, 2.07824f, 0.657957f, -2.82881f, 
		2.07836f, 0.661899f, -2.89741f, 2.07839f, 0.856341f, -2.91313f, 
		2.07848f, 0.616070f, -2.88894f, 2.07858f, 0.817174f, -2.92109f, 
		2.07863f, 0.858841f, -2.89870f, 2.07864f, 0.842512f, -2.83073f, 
		2.07875f, 0.843524f, -2.86938f, 2.07886f, 0.878094f, -2.91584f, 
		2.07887f, -0.360188f, -3.09148f, 2.07887f, -0.360188f, -3.09148f, 
		2.07888f, -0.655066f, -3.08981f, 2.07888f, -0.655066f, -3.08981f, 
		2.07895f, 0.850596f, -2.86302f, 2.07896f, 1.08296f, -3.07180f, 
		2.07899f, 0.749977f, -2.81677f, 2.07899f, 0.749977f, -2.81677f, 
		2.07901f, 0.837041f, -2.88026f, 2.07902f, 0.750833f, -2.82319f, 
		2.07902f, 0.750833f, -2.82319f, 2.07913f, 0.749224f, -2.81625f, 
		2.07913f, 0.749224f, -2.81625f, 2.07913f, 0.749224f, -2.81625f, 
		2.07913f, 0.749224f, -2.81625f, 2.07914f, 0.880798f, -2.92555f, 
		2.07914f, 0.652220f, -2.96225f, 2.07920f, 0.878223f, -2.91314f, 
		2.07921f, 0.150478f, -2.90830f, 2.07924f, 0.346595f, -3.09985f, 
		2.07927f, 0.865698f, -2.91624f, 2.07927f, 0.674682f, -2.89093f, 
		2.07930f, 0.760507f, -2.78242f, 2.07930f, 0.760507f, -2.78242f, 
		2.07930f, 0.878909f, -2.86237f, 2.07962f, 0.835876f, -2.90217f, 
		2.07975f, 0.707829f, -3.03939f, 2.07987f, 0.351524f, -3.11788f, 
		2.07988f, 0.887475f, -2.90645f, 2.08006f, 0.868172f, -2.95544f, 
		2.08008f, 0.108299f, -2.91951f, 2.08014f, 0.817363f, -3.18144f, 
		2.08031f, 0.823678f, -2.94817f, 2.08037f, 0.708369f, -2.91385f, 
		2.08037f, 0.862894f, -2.85652f, 2.08044f, 0.739845f, -3.07723f, 
		2.08048f, 0.894939f, -2.88354f, 2.08051f, 0.850736f, -2.96069f, 
		2.08062f, 0.253102f, -3.14777f, 2.08062f, 0.253102f, -3.14777f, 
		2.08076f, 0.227615f, -3.15040f, 2.08076f, 0.227615f, -3.15040f, 
		2.08080f, 0.388805f, -3.11135f, 2.08086f, -0.489454f, -3.04697f, 
		2.08087f, 0.498774f, -3.15217f, 2.08087f, 0.498774f, -3.15217f, 
		2.08087f, 0.498774f, -3.15217f, 2.08087f, 0.498774f, -3.15217f, 
		2.08087f, 0.498774f, -3.15217f, 2.08088f, 0.673046f, -2.85003f, 
		2.08088f, 0.673046f, -2.85003f, 2.08093f, 0.872184f, -2.83521f, 
		2.08109f, 0.838068f, -2.90570f, 2.08111f, 0.847915f, -2.90217f, 
		2.08111f, 0.200558f, -2.90273f, 2.08119f, 0.877059f, -2.93792f, 
		2.08119f, 0.823878f, -2.91649f, 2.08142f, 0.866215f, -2.90878f, 
		2.08146f, 0.830523f, -2.95197f, 2.08153f, 0.741997f, -2.80875f, 
		2.08153f, 0.741997f, -2.80875f, 2.08153f, 0.741997f, -2.80875f, 
		2.08157f, 0.894104f, -2.87304f, 2.08166f, 0.448304f, -3.10670f, 
		2.08166f, 0.448304f, -3.10670f, 2.08166f, 0.448304f, -3.10670f, 
		2.08166f, 0.448304f, -3.10670f, 2.08166f, 0.448304f, -3.10670f, 
		2.08176f, 0.855699f, -2.85205f, 2.08180f, 0.431287f, -3.12284f, 
		2.08180f, 0.431287f, -3.12284f, 2.08180f, 0.431287f, -3.12284f, 
		2.08189f, 0.857639f, -2.84190f, 2.08189f, 0.857639f, -2.84190f, 
		2.08189f, 0.857639f, -2.84190f, 2.08189f, 0.857639f, -2.84190f, 
		2.08189f, 0.857639f, -2.84190f, 2.08189f, 0.857639f, -2.84190f, 
		2.08191f, 0.821899f, -3.17307f, 2.08207f, 0.675361f, -2.90316f, 
		2.08210f, 0.400016f, -3.11036f, 2.08215f, 0.822840f, -2.92708f, 
		2.08218f, 0.659463f, -2.83896f, 2.08218f, 0.659463f, -2.83896f, 
		2.08228f, 0.697999f, -2.87058f, 2.08238f, 0.306416f, -3.14178f, 
		2.08238f, 0.306416f, -3.14178f, 2.08238f, 0.832186f, -2.91111f, 
		2.08239f, -0.394009f, -3.09370f, 2.08239f, -0.394009f, -3.09370f, 
		2.08239f, -0.394009f, -3.09370f, 2.08239f, 0.823168f, -2.93660f, 
		2.08242f, 0.848727f, -2.85679f, 2.08252f, 0.830010f, -2.89207f, 
		2.08262f, 0.751109f, -2.87538f, 2.08265f, 0.857944f, -2.95517f, 
		2.08272f, 0.847286f, -2.91839f, 2.08278f, 0.840955f, -2.95521f, 
		2.08297f, 0.903883f, -2.81248f, 2.08297f, -0.871814f, -2.67156f, 
		2.08297f, 0.846320f, -2.83626f, 2.08297f, 0.846320f, -2.83626f, 
		2.08297f, 0.846320f, -2.83626f, 2.08305f, 1.07067f, -3.06826f, 
		2.08305f, 0.873226f, -2.92582f, 2.08308f, 0.832552f, -2.87210f, 
		2.08311f, 0.682764f, -2.94382f, 2.08311f, 0.682764f, -2.94382f, 
		2.08311f, 0.682764f, -2.94382f, 2.08311f, 0.869411f, -2.94467f, 
		2.08316f, 0.869364f, -2.91819f, 2.08317f, 0.841546f, -2.90798f, 
		2.08323f, 0.672429f, -2.85842f, 2.08327f, 0.634122f, -2.83449f, 
		2.08345f, 0.0562520f, -2.93209f, 2.08349f, 0.853972f, -2.90819f, 
		2.08356f, 0.890250f, -2.86216f, 2.08359f, 0.896168f, -2.90555f, 
		2.08372f, 0.0330660f, -3.09752f, 2.08372f, 0.0330660f, -3.09752f, 
		2.08374f, 0.870003f, -2.84731f, 2.08375f, 0.679341f, -2.84569f, 
		2.08375f, 0.679341f, -2.84569f, 2.08375f, 0.679341f, -2.84569f, 
		2.08375f, 0.879686f, -2.85426f, 2.08385f, 0.865526f, -2.92459f, 
		2.08393f, 0.692050f, -2.85672f, 2.08402f, -0.765105f, -3.05032f, 
		2.08402f, -0.765105f, -3.05032f, 2.08402f, -0.765105f, -3.05032f, 
		2.08402f, -0.765105f, -3.05032f, 2.08414f, 0.901312f, -2.89227f, 
		2.08430f, 0.408033f, -2.94885f, 2.08441f, 0.884775f, -2.91934f, 
		2.08452f, 0.932008f, -2.79822f, 2.08452f, 0.932008f, -2.79822f, 
		2.08455f, 0.829687f, -2.90142f, 2.08470f, 0.868696f, -2.93402f, 
		2.08487f, 0.836834f, -2.86134f, 2.08489f, 0.847284f, -2.83809f, 
		2.08489f, 0.847284f, -2.83809f, 2.08489f, 0.847284f, -2.83809f, 
		2.08493f, 0.539809f, -3.11916f, 2.08496f, 0.257898f, -2.90204f, 
		2.08500f, 0.834241f, -2.94363f, 2.08517f, 0.854739f, -2.92518f, 
		2.08521f, 0.501540f, -2.99101f, 2.08525f, 0.702662f, -2.88331f, 
		2.08535f, 0.834884f, -2.92035f, 2.08542f, 0.876860f, -2.92476f, 
		2.08545f, 0.831795f, -2.92993f, 2.08546f, 0.930544f, -2.80575f, 
		2.08549f, 0.846952f, -2.94876f, 2.08562f, 0.859692f, -2.91709f, 
		2.08568f, 0.355557f, -3.13641f, 2.08568f, 0.355557f, -3.13641f, 
		2.08568f, 0.642615f, -2.84661f, 2.08568f, 0.642615f, -2.84661f, 
		2.08568f, 0.642615f, -2.84661f, 2.08568f, 0.642615f, -2.84661f, 
		2.08569f, 0.825352f, -2.88425f, 2.08572f, 0.0104000f, -2.95182f, 
		2.08576f, 0.893141f, -2.81946f, 2.08584f, 0.863128f, -2.92408f, 
		2.08593f, 0.838719f, -2.91746f, 2.08596f, 0.687587f, -2.96056f, 
		2.08600f, 0.642205f, -2.84731f, 2.08600f, 0.642205f, -2.84731f, 
		2.08600f, 0.673074f, -2.87382f, 2.08602f, 0.841709f, -2.91666f, 
		2.08603f, 0.869480f, -2.83940f, 2.08608f, 0.859073f, -2.94296f, 
		2.08632f, 0.850699f, -2.91728f, 2.08635f, 0.677250f, -2.91699f, 
		2.08649f, -0.821420f, -2.66858f, 2.08657f, 0.898718f, -2.86697f, 
		2.08662f, 0.861761f, -2.84709f, 2.08667f, -0.581488f, -3.05044f, 
		2.08675f, 0.946844f, -2.79820f, 2.08675f, 0.946844f, -2.79820f, 
		2.08684f, 0.859625f, -2.93348f, 2.08687f, 0.846266f, -2.85110f, 
		2.08704f, 0.904427f, -2.87873f, 2.08715f, 0.841043f, -2.92664f, 
		2.08716f, 0.849301f, -2.84027f, 2.08716f, 0.849301f, -2.84027f, 
		2.08716f, 0.849301f, -2.84027f, 2.08716f, 0.849301f, -2.84027f, 
		2.08716f, 0.849301f, -2.84027f, 2.08716f, 0.849301f, -2.84027f, 
		2.08718f, 0.845933f, -2.84885f, 2.08726f, 0.560602f, -3.07226f, 
		2.08726f, 0.560602f, -3.07226f, 2.08726f, 0.560602f, -3.07226f, 
		2.08731f, 0.841060f, -2.93617f, 2.08737f, 0.829847f, -2.91057f, 
		2.08742f, 0.706237f, -2.89569f, 2.08744f, 1.01702f, -2.84874f, 
		2.08748f, 0.853650f, -2.92685f, 2.08754f, 0.850263f, -2.93631f, 
		2.08761f, 0.644165f, -2.85230f, 2.08761f, 0.644165f, -2.85230f, 
		2.08786f, 0.857845f, -2.84840f, 2.08786f, 0.857845f, -2.84840f, 
		2.08786f, 0.857845f, -2.84840f, 2.08804f, 0.924704f, -2.80860f, 
		2.08804f, 0.924704f, -2.80860f, 2.08806f, 0.702821f, -2.82420f, 
		2.08812f, 0.709375f, -2.93149f, 2.08812f, 0.709375f, -2.93149f, 
		2.08812f, 0.709375f, -2.93149f, 2.08812f, 0.709375f, -2.93149f, 
		2.08827f, 0.404593f, -3.13101f, 2.08827f, 0.404593f, -3.13101f, 
		2.08833f, 0.695393f, -2.86962f, 2.08833f, 0.695393f, -2.86962f, 
		2.08833f, 0.695393f, -2.86962f, 2.08834f, -0.199578f, -3.01790f, 
		2.08834f, -0.199578f, -3.01790f, 2.08834f, 0.876821f, -2.84677f, 
		2.08835f, 0.895133f, -2.91734f, 2.08839f, -0.483758f, -3.09686f, 
		2.08845f, 0.889251f, -2.82367f, 2.08859f, 0.699964f, -2.82522f, 
		2.08859f, 0.699964f, -2.82522f, 2.08859f, 0.700864f, -2.82978f, 
		2.08859f, 0.700864f, -2.82978f, 2.08878f, 0.619384f, -2.84647f, 
		2.08878f, 0.619384f, -2.84647f, 2.08878f, 0.619384f, -2.84647f, 
		2.08878f, 0.619384f, -2.84647f, 2.08882f, 0.685901f, -2.84623f, 
		2.08883f, -0.330215f, -3.03115f, 2.08883f, -0.330215f, -3.03115f, 
		2.08903f, -0.267089f, -3.02440f, 2.08903f, -0.267089f, -3.02440f, 
		2.08918f, 0.824155f, -2.87140f, 2.08918f, -0.113845f, -3.00944f, 
		2.08918f, -0.113845f, -3.00944f, 2.08929f, -0.738919f, -3.05561f, 
		2.08929f, -0.738919f, -3.05561f, 2.08929f, -0.738919f, -3.05561f, 
		2.08930f, 0.312003f, -2.90718f, 2.08931f, 0.822024f, -2.89740f, 
		2.08948f, 0.789370f, -2.81564f, 2.08948f, 0.789370f, -2.81564f, 
		2.08948f, 0.789370f, -2.81564f, 2.08949f, 0.738429f, -2.80829f, 
		2.08952f, 0.693248f, -2.85462f, 2.08956f, 0.455707f, -3.12856f, 
		2.08956f, 0.455707f, -3.12856f, 2.08956f, 0.455707f, -3.12856f, 
		2.08967f, 0.664460f, -2.98804f, 2.08967f, 0.664460f, -2.98804f, 
		2.08967f, 0.664460f, -2.98804f, 2.08979f, 1.08261f, -2.94607f, 
		2.08979f, 0.842562f, -2.92589f, 2.08982f, -0.658876f, -3.05305f, 
		2.08993f, 0.868631f, -2.84385f, 2.08993f, 0.868631f, -2.84385f, 
		2.08998f, 0.906527f, -2.90068f, 2.09000f, 0.465589f, -3.13264f, 
		2.09000f, 0.465589f, -3.13264f, 2.09000f, 0.465589f, -3.13264f, 
		2.09000f, 0.465589f, -3.13264f, 2.09025f, 0.947893f, -2.80644f, 
		2.09025f, 0.947893f, -2.80644f, 2.09029f, 0.784584f, -3.16485f, 
		2.09040f, 0.870988f, -2.93195f, 2.09042f, 1.03925f, -3.16740f, 
		2.09047f, 0.674915f, -2.88725f, 2.09056f, -0.00517300f, -2.99436f, 
		2.09056f, -0.00517300f, -2.99436f, 2.09056f, -0.00517300f, -2.99436f, 
		2.09056f, -0.00517300f, -2.99436f, 2.09059f, 0.814634f, -2.82210f, 
		2.09063f, -0.364875f, -3.03488f, 2.09063f, -0.364875f, -3.03488f, 
		2.09066f, 0.674439f, -2.84696f, 2.09066f, 0.674439f, -2.84696f, 
		2.09066f, 0.674439f, -2.84696f, 2.09066f, 0.674439f, -2.84696f, 
		2.09068f, 0.890021f, -2.85053f, 2.09080f, 0.774306f, -2.80535f, 
		2.09083f, 0.951399f, -2.80808f, 2.09087f, 0.632151f, -2.92256f, 
		2.09088f, 0.804200f, -2.81911f, 2.09094f, 0.828776f, -2.85968f, 
		2.09101f, 0.701971f, -2.82944f, 2.09101f, 0.701971f, -2.82944f, 
		2.09102f, 0.702359f, -2.83350f, 2.09102f, 0.702359f, -2.83350f, 
		2.09105f, 0.885864f, -2.82722f, 2.09120f, 0.694867f, -2.94387f, 
		2.09123f, 0.673353f, -2.85633f, 2.09140f, 0.838829f, -2.84962f, 
		2.09141f, 0.819020f, -2.88264f, 2.09145f, 0.744158f, -2.95418f, 
		2.09151f, 0.761374f, -2.80541f, 2.09151f, 0.761374f, -2.80541f, 
		2.09151f, 0.761374f, -2.80541f, 2.09151f, 0.761374f, -2.80541f, 
		2.09153f, 0.883252f, -2.92979f, 2.09154f, 0.790803f, -3.15734f, 
		2.09154f, 0.699104f, -2.82921f, 2.09162f, 0.825505f, -2.82515f, 
		2.09165f, 0.904877f, -2.86562f, 2.09166f, 1.03240f, -3.15975f, 
		2.09191f, 0.849670f, -2.84540f, 2.09191f, 0.849670f, -2.84540f, 
		2.09191f, 0.849670f, -2.84540f, 2.09192f, -0.00401100f, -2.99034f, 
		2.09192f, -0.00401100f, -2.99034f, 2.09192f, -0.00401100f, -2.99034f, 
		2.09207f, 0.453976f, -2.95913f, 2.09208f, 0.910865f, -2.89027f, 
		2.09220f, 0.860147f, -2.93435f, 2.09222f, 0.710500f, -2.90934f, 
		2.09223f, -0.0231420f, -2.99835f, 2.09223f, -0.0231420f, -2.99835f, 
		2.09223f, -0.0231420f, -2.99835f, 2.09223f, -0.0231420f, -2.99835f, 
		2.09229f, 0.849081f, -2.84352f, 2.09250f, 0.757731f, -2.81187f, 
		2.09250f, 0.757731f, -2.81187f, 2.09250f, 0.757731f, -2.81187f, 
		2.09250f, 0.757731f, -2.81187f, 2.09250f, 0.757731f, -2.81187f, 
		2.09250f, 0.757731f, -2.81187f, 2.09253f, 0.777722f, -2.81400f, 
		2.09253f, 0.777722f, -2.81400f, 2.09253f, 0.777722f, -2.81400f, 
		2.09253f, 0.777722f, -2.81400f, 2.09253f, 0.777722f, -2.81400f, 
		2.09272f, 0.699415f, -2.86666f, 2.09276f, 0.906147f, -2.90983f, 
		2.09278f, 0.831365f, -2.82771f, 2.09282f, 0.729816f, -2.80662f, 
		2.09292f, 0.898571f, -2.85485f, 2.09305f, 0.831388f, -2.92189f, 
		2.09307f, 0.822397f, -2.90957f, 2.09309f, 0.680132f, -2.84417f, 
		2.09309f, 0.680132f, -2.84417f, 2.09309f, 0.680132f, -2.84417f, 
		2.09309f, 0.680132f, -2.84417f, 2.09320f, 0.910577f, -2.87665f, 
		2.09331f, 0.883187f, -2.83034f, 2.09353f, -0.0105090f, -2.99765f, 
		2.09353f, -0.0105090f, -2.99765f, 2.09353f, -0.0105090f, -2.99765f, 
		2.09353f, -0.0105090f, -2.99765f, 2.09353f, -0.0105090f, -2.99765f, 
		2.09354f, 0.851507f, -2.93411f, 2.09391f, 0.675484f, -2.89916f, 
		2.09392f, 0.722435f, -2.80924f, 2.09392f, 0.722435f, -2.80924f, 
		2.09399f, -0.398944f, -3.03777f, 2.09399f, -0.398944f, -3.03777f, 
		2.09421f, 0.835657f, -2.82987f, 2.09425f, 1.09431f, -2.93900f, 
		2.09439f, -0.575901f, -3.10149f, 2.09495f, 0.754512f, -2.82884f, 
		2.09495f, 0.754512f, -2.82884f, 2.09495f, 0.754512f, -2.82884f, 
		2.09495f, 0.754512f, -2.82884f, 2.09496f, -0.00433500f, -3.09169f, 
		2.09496f, -0.00433500f, -3.09169f, 2.09496f, -0.00433500f, -3.09169f, 
		2.09496f, -0.00433500f, -3.09169f, 2.09497f, 0.840045f, -2.83148f, 
		2.09499f, 0.892906f, -2.92799f, 2.09504f, 0.882449f, -2.83959f, 
		2.09507f, 0.858614f, -2.83860f, 2.09529f, 0.842975f, -2.93240f, 
		2.09532f, -0.843955f, -2.72804f, 2.09534f, 0.880787f, -2.83280f, 
		2.09536f, 0.846751f, -2.83461f, 2.09536f, 0.846751f, -2.83461f, 
		2.09536f, 0.846751f, -2.83461f, 2.09536f, 0.846751f, -2.83461f, 
		2.09544f, 0.843709f, -2.83280f, 2.09555f, -0.865911f, -2.72836f, 
		2.09555f, -0.865911f, -2.72836f, 2.09565f, 0.842974f, -2.84156f, 
		2.09567f, 0.815251f, -2.89508f, 2.09573f, 0.872117f, -2.83832f, 
		2.09592f, -0.829332f, -2.62641f, 2.09601f, 0.362564f, -2.91957f, 
		2.09611f, 0.753041f, -2.82432f, 2.09611f, 0.753041f, -2.82432f, 
		2.09612f, 0.721972f, -2.81772f, 2.09612f, 0.721972f, -2.81772f, 
		2.09618f, 0.701904f, -2.89286f, 2.09618f, 0.701904f, -2.89286f, 
		2.09621f, 0.728358f, -2.81910f, 2.09633f, -0.00706900f, -2.98372f, 
		2.09636f, 0.00664600f, -2.94392f, 2.09636f, 0.00664600f, -2.94392f, 
		2.09636f, 0.00664600f, -2.94392f, 2.09636f, 0.878335f, -2.93627f, 
		2.09664f, 0.693905f, -2.85194f, 2.09668f, 0.682743f, -2.94515f, 
		2.09668f, 0.682743f, -2.94515f, 2.09671f, 0.863519f, -2.93860f, 
		2.09683f, 0.711826f, -3.07888f, 2.09683f, 0.711826f, -3.07888f, 
		2.09698f, 0.543631f, -3.00725f, 2.09698f, 0.674453f, -2.87038f, 
		2.09703f, 0.677081f, -2.84715f, 2.09708f, 0.913324f, -2.90157f, 
		2.09743f, 0.885689f, -2.84109f, 2.09755f, -0.654130f, -3.10420f, 
		2.09760f, 0.816652f, -2.86913f, 2.09767f, -0.104529f, -3.08823f, 
		2.09767f, -0.104529f, -3.08823f, 2.09767f, -0.104529f, -3.08823f, 
		2.09767f, -0.104529f, -3.08823f, 2.09769f, 0.831603f, -2.84818f, 
		2.09773f, 0.704352f, -2.87862f, 2.09813f, 0.981760f, -2.81973f, 
		2.09817f, -0.840603f, -2.60525f, 2.09817f, -0.840603f, -2.60525f, 
		2.09817f, -0.840603f, -2.60525f, 2.09818f, 0.904053f, -2.92118f, 
		2.09830f, 0.813029f, -2.88132f, 2.09832f, 0.754139f, -2.82125f, 
		2.09832f, 0.754139f, -2.82125f, 2.09832f, -0.871814f, -2.61661f, 
		2.09837f, 0.815540f, -2.90426f, 2.09842f, 0.822109f, -2.85765f, 
		2.09853f, 0.824376f, -2.92090f, 2.09855f, 0.119111f, -3.08315f, 
		2.09857f, 0.895963f, -2.84627f, 2.09858f, 0.748334f, -3.05591f, 
		2.09861f, 0.661126f, -2.88546f, 2.09866f, 0.753429f, -2.82077f, 
		2.09866f, 0.753429f, -2.82077f, 2.09866f, 0.753429f, -2.82077f, 
		2.09889f, 0.675174f, -2.85319f, 2.09893f, 0.677302f, -2.91298f, 
		2.09901f, -0.820992f, -2.72524f, 2.09901f, -0.820992f, -2.72524f, 
		2.09901f, -0.820992f, -2.72524f, 2.09901f, -0.820992f, -2.72524f, 
		2.09904f, 0.879558f, -2.83753f, 2.09904f, 0.879558f, -2.83753f, 
		2.09910f, 0.847479f, -2.83857f, 2.09910f, 0.847479f, -2.83857f, 
		2.09936f, -0.738627f, -3.11165f, 2.09951f, -0.261120f, -3.08512f, 
		2.09951f, -0.261120f, -3.08512f, 2.09951f, -0.261120f, -3.08512f, 
		2.09953f, -0.488949f, -3.04239f, 2.09953f, -0.488949f, -3.04239f, 
		2.09964f, -0.852363f, -2.59463f, 2.09964f, -0.852363f, -2.59463f, 
		2.09964f, -0.852363f, -2.59463f, 2.09964f, -0.852363f, -2.59463f, 
		2.09964f, 0.157171f, -3.07960f, 2.09971f, 0.818738f, -2.91423f, 
		2.09996f, 0.914201f, -2.86937f, 2.10001f, -0.820075f, -3.13372f, 
		2.10017f, 0.872501f, -2.94051f, 2.10024f, 0.757980f, -3.11918f, 
		2.10025f, 0.712256f, -2.92789f, 2.10025f, 0.712256f, -2.92789f, 
		2.10025f, 0.712256f, -2.92789f, 2.10025f, 0.712256f, -2.92789f, 
		2.10025f, 0.648917f, -2.94968f, 2.10029f, -0.775872f, -3.11646f, 
		2.10034f, 0.910086f, -2.86062f, 2.10043f, 0.615181f, -2.87595f, 
		2.10044f, 0.669401f, -3.02251f, 2.10044f, 0.669401f, -3.02251f, 
		2.10044f, 0.669401f, -3.02251f, 2.10047f, 0.0549600f, -2.91890f, 
		2.10051f, 0.837899f, -2.84126f, 2.10056f, 0.835411f, -2.93278f, 
		2.10056f, 0.905485f, -2.85348f, 2.10058f, -0.864886f, -2.59488f, 
		2.10058f, -0.864886f, -2.59488f, 2.10058f, -0.864886f, -2.59488f, 
		2.10068f, -0.192571f, -3.08560f, 2.10068f, -0.192571f, -3.08560f, 
		2.10078f, 0.917688f, -2.88161f, 2.10086f, 0.0738510f, -3.08811f, 
		2.10086f, 0.0738510f, -3.08811f, 2.10086f, 0.0738510f, -3.08811f, 
		2.10107f, 0.694597f, -2.81849f, 2.10107f, 0.694597f, -2.81849f, 
		2.10113f, 0.689612f, -2.95525f, 2.10119f, -0.327031f, -3.08576f, 
		2.10128f, 0.704971f, -2.90754f, 2.10128f, 0.704971f, -2.90754f, 
		2.10136f, 0.565963f, -3.03153f, 2.10139f, 0.911898f, -2.91348f, 
		2.10163f, -0.0100250f, -2.97579f, 2.10170f, 0.828964f, -2.92861f, 
		2.10184f, 0.848225f, -2.93984f, 2.10186f, 0.877355f, -2.83468f, 
		2.10191f, 0.843733f, -2.83723f, 2.10195f, 0.852829f, -2.83421f, 
		2.10203f, 0.149522f, -2.89333f, 2.10241f, 0.918756f, -2.89093f, 
		2.10250f, 0.686143f, -2.81819f, 2.10258f, 0.205070f, -3.08035f, 
		2.10272f, 0.106538f, -2.90368f, 2.10280f, 0.409067f, -2.93053f, 
		2.10283f, 0.759585f, -2.81646f, 2.10283f, 0.759585f, -2.81646f, 
		2.10283f, 0.759585f, -2.81646f, 2.10285f, -0.360175f, -3.08736f, 
		2.10287f, 0.695373f, -2.82602f, 2.10287f, 0.695373f, -2.82602f, 
		2.10294f, 0.700630f, -2.86338f, 2.10295f, 0.502505f, -2.97236f, 
		2.10296f, 0.676610f, -2.88272f, 2.10309f, 0.870471f, -2.83263f, 
		2.10319f, 0.889389f, -2.93718f, 2.10335f, 0.708396f, -2.88970f, 
		2.10340f, 0.572427f, -3.05787f, 2.10340f, 0.572427f, -3.05787f, 
		2.10340f, 0.572427f, -3.05787f, 2.10366f, 0.744430f, -3.13381f, 
		2.10388f, 0.728862f, -3.06949f, 2.10388f, 0.647192f, -2.84881f, 
		2.10388f, 0.647192f, -2.84881f, 2.10397f, 0.645866f, -2.84219f, 
		2.10397f, 0.645866f, -2.84219f, 2.10397f, 0.645866f, -2.84219f, 
		2.10397f, 0.645866f, -2.84219f, 2.10409f, 0.645418f, -2.84293f, 
		2.10409f, 0.645418f, -2.84293f, 2.10417f, 0.892993f, -2.83972f, 
		2.10429f, 0.689746f, -2.82804f, 2.10434f, 0.899139f, -2.93182f, 
		2.10442f, 0.254617f, -3.08193f, 2.10448f, 0.826725f, -2.84635f, 
		2.10460f, 0.692435f, -2.85056f, 2.10460f, 0.919077f, -2.90023f, 
		2.10486f, 0.703142f, -3.00495f, 2.10493f, -0.859842f, -3.13756f, 
		2.10493f, -0.859842f, -3.13756f, 2.10498f, 0.199927f, -2.88863f, 
		2.10498f, 0.704549f, -2.83551f, 2.10498f, 0.704549f, -2.83551f, 
		2.10510f, 0.698170f, -2.94088f, 2.10510f, 0.698170f, -2.94088f, 
		2.10510f, 0.698170f, -2.94088f, 2.10510f, 0.698170f, -2.94088f, 
		2.10510f, 0.698170f, -2.94088f, 2.10511f, 0.808418f, -2.88924f, 
		2.10518f, 0.693456f, -2.99793f, 2.10521f, 0.870155f, -2.94416f, 
		2.10557f, 0.856763f, -2.83144f, 2.10557f, 0.656537f, -3.00594f, 
		2.10557f, 0.656537f, -3.00594f, 2.10557f, 0.656537f, -3.00594f, 
		2.10562f, 0.757136f, -2.83923f, 2.10565f, 0.821808f, -2.92506f, 
		2.10577f, -0.581280f, -3.04572f, 2.10577f, -0.581280f, -3.04572f, 
		2.10596f, 0.757848f, -2.83876f, 2.10596f, 0.757848f, -2.83876f, 
		2.10598f, 0.903733f, -2.84664f, 2.10605f, -0.0135360f, -2.97164f, 
		2.10605f, -0.0135360f, -2.97164f, 2.10605f, -0.0135360f, -2.97164f, 
		2.10605f, -0.0135360f, -2.97164f, 2.10605f, -0.0135360f, -2.97164f, 
		2.10605f, -0.0135360f, -2.97164f, 2.10612f, 1.08947f, -3.06212f, 
		2.10631f, -0.000367000f, -2.92717f, 2.10631f, -0.000367000f, -2.92717f, 
		2.10631f, -0.000367000f, -2.92717f, 2.10631f, -0.000367000f, -2.92717f, 
		2.10631f, -0.000367000f, -2.92717f, 2.10632f, 0.812759f, -2.91189f, 
		2.10648f, -0.393980f, -3.08996f, 2.10656f, 0.705946f, -2.83895f, 
		2.10656f, 0.705946f, -2.83895f, 2.10663f, 0.884424f, -2.94159f, 
		2.10668f, 0.301295f, -3.08536f, 2.10683f, 0.678861f, -2.85121f, 
		2.10699f, 1.07649f, -3.05975f, 2.10702f, 0.817077f, -2.85535f, 
		2.10708f, 0.908653f, -2.92441f, 2.10723f, 0.975823f, -3.20158f, 
		2.10726f, 0.917976f, -2.86699f, 2.10728f, 0.810997f, -2.86654f, 
		2.10729f, 0.677368f, -2.86538f, 2.10730f, 0.706964f, -2.82867f, 
		2.10734f, 0.807918f, -2.89853f, 2.10761f, 0.972223f, -3.19218f, 
		2.10762f, 0.704084f, -2.82962f, 2.10762f, 0.704084f, -2.82962f, 
		2.10767f, 0.671487f, -2.82601f, 2.10773f, 0.712602f, -2.90352f, 
		2.10774f, 0.853912f, -2.94483f, 2.10775f, 0.707258f, -2.92558f, 
		2.10775f, 0.707258f, -2.92558f, 2.10775f, 0.707258f, -2.92558f, 
		2.10775f, 0.707258f, -2.92558f, 2.10775f, 0.707258f, -2.92558f, 
		2.10777f, 0.711473f, -3.01048f, 2.10780f, 1.02836f, -2.84050f, 
		2.10792f, -0.870433f, -3.12162f, 2.10808f, 0.677406f, -2.89383f, 
		2.10820f, 0.684210f, -2.84764f, 2.10820f, 0.684210f, -2.84764f, 
		2.10868f, 0.806974f, -2.87854f, 2.10875f, -0.777874f, -3.04573f, 
		2.10875f, -0.777874f, -3.04573f, 2.10875f, -0.777874f, -3.04573f, 
		2.10880f, 0.917417f, -2.91216f, 2.10881f, 0.839311f, -2.94062f, 
		2.10895f, -0.659181f, -3.04828f, 2.10895f, -0.659181f, -3.04828f, 
		2.10905f, 0.684281f, -2.94219f, 2.10905f, 0.684281f, -2.94219f, 
		2.10909f, 0.658356f, -2.97260f, 2.10909f, 0.658356f, -2.97260f, 
		2.10909f, 0.658356f, -2.97260f, 2.10909f, 0.658356f, -2.97260f, 
		2.10910f, 0.705836f, -2.83363f, 2.10910f, 0.705836f, -2.83363f, 
		2.10929f, 0.868605f, -2.82903f, 2.10943f, 0.913423f, -2.85558f, 
		2.10948f, 0.746133f, -2.94725f, 2.10949f, 0.346691f, -3.09225f, 
		2.10951f, 0.686993f, -3.04111f, 2.10963f, -0.328941f, -3.04694f, 
		2.10963f, -0.328941f, -3.04694f, 2.10963f, -0.328941f, -3.04694f, 
		2.10970f, 0.258081f, -2.88830f, 2.10973f, 0.826658f, -2.81983f, 
		2.10983f, 0.703033f, -2.83345f, 2.10994f, 0.455013f, -2.94120f, 
		2.10995f, 0.781963f, -2.81854f, 2.10995f, 0.781963f, -2.81854f, 
		2.10995f, 0.781963f, -2.81854f, 2.10999f, -0.264383f, -3.04133f, 
		2.10999f, -0.264383f, -3.04133f, 2.10999f, -0.264383f, -3.04133f, 
		2.11008f, 0.846375f, -2.82542f, 2.11008f, 0.846375f, -2.82542f, 
		2.11010f, 0.842597f, -2.82459f, 2.11013f, -0.742806f, -3.05068f, 
		2.11013f, -0.742806f, -3.05068f, 2.11026f, 0.833449f, -2.82307f, 
		2.11037f, 0.838205f, -2.82401f, 2.11044f, 0.672378f, -2.83625f, 
		2.11044f, 0.672378f, -2.83625f, 2.11044f, 0.672378f, -2.83625f, 
		2.11044f, 0.672378f, -2.83625f, 2.11051f, 0.557309f, -3.09398f, 
		2.11051f, 0.557309f, -3.09398f, 2.11051f, 0.557309f, -3.09398f, 
		2.11052f, 0.883575f, -2.83151f, 2.11059f, 0.861878f, -2.94686f, 
		2.11060f, 0.828121f, -2.93462f, 2.11061f, 0.565411f, -3.01240f, 
		2.11076f, 0.843210f, -2.83272f, 2.11076f, 0.847413f, -2.82716f, 
		2.11076f, 0.847413f, -2.82716f, 2.11076f, 0.847413f, -2.82716f, 
		2.11089f, -0.196642f, -3.03690f, 2.11102f, 0.678703f, -2.90820f, 
		2.11116f, 0.707180f, -2.87884f, 2.11122f, 0.688014f, -2.99204f, 
		2.11124f, 1.05295f, -2.82273f, 2.11124f, 1.05295f, -2.82273f, 
		2.11126f, -0.0245410f, -2.96377f, 2.11126f, -0.0245410f, -2.96377f, 
		2.11126f, -0.0245410f, -2.96377f, 2.11130f, -0.362591f, -3.05065f, 
		2.11130f, -0.362591f, -3.05065f, 2.11130f, -0.362591f, -3.05065f, 
		2.11141f, 0.832776f, -2.83729f, 2.11141f, 0.817016f, -2.81699f, 
		2.11145f, 0.923263f, -2.87885f, 2.11146f, 0.761070f, -2.87127f, 
		2.11173f, 0.816171f, -2.92292f, 2.11175f, 0.631655f, -2.91214f, 
		2.11176f, 0.797061f, -2.81793f, 2.11177f, 0.874866f, -2.94672f, 
		2.11214f, 0.927343f, -3.20698f, 2.11214f, 0.641473f, -3.02808f, 
		2.11214f, 0.641473f, -3.02808f, 2.11214f, 0.641473f, -3.02808f, 
		2.11227f, 0.926231f, -3.19731f, 2.11263f, -0.110081f, -3.02995f, 
		2.11265f, 0.847597f, -2.83044f, 2.11265f, 0.847597f, -2.83044f, 
		2.11269f, -0.484365f, -3.09392f, 2.11269f, -0.484365f, -3.09392f, 
		2.11269f, -0.484365f, -3.09392f, 2.11272f, -0.870433f, -3.05128f, 
		2.11274f, -0.0243520f, -2.91615f, 2.11274f, -0.0243520f, -2.91615f, 
		2.11276f, 0.389091f, -3.10166f, 2.11277f, 0.891453f, -2.82088f, 
		2.11286f, -0.328430f, -3.06980f, 2.11286f, -0.328430f, -3.06980f, 
		2.11286f, -0.328430f, -3.06980f, 2.11293f, 0.895096f, -2.81810f, 
		2.11302f, 0.808970f, -2.81665f, 2.11313f, 0.844494f, -2.83059f, 
		2.11316f, 0.898686f, -2.81354f, 2.11325f, -0.0391440f, -2.95161f, 
		2.11325f, -0.0391440f, -2.95161f, 2.11325f, -0.0391440f, -2.95161f, 
		2.11325f, -0.0391440f, -2.95161f, 2.11326f, 0.895486f, -2.93963f, 
		2.11329f, 0.822705f, -2.84416f, 2.11332f, -0.262749f, -3.06722f, 
		2.11332f, -0.262749f, -3.06722f, 2.11332f, -0.262749f, -3.06722f, 
		2.11332f, -0.262749f, -3.06722f, 2.11333f, 0.882002f, -3.20632f, 
		2.11335f, 0.887804f, -2.82262f, 2.11340f, 0.883219f, -3.19668f, 
		2.11348f, 0.699489f, -2.93802f, 2.11348f, 0.699489f, -2.93802f, 
		2.11352f, 0.714054f, -2.92290f, 2.11352f, 0.714054f, -2.92290f, 
		2.11352f, 0.714054f, -2.92290f, 2.11352f, 0.714054f, -2.92290f, 
		2.11354f, 0.679329f, -2.87804f, 2.11369f, 0.626141f, -2.84182f, 
		2.11369f, 0.626141f, -2.84182f, 2.11369f, 0.626141f, -2.84182f, 
		2.11370f, 0.906873f, -2.84465f, 2.11374f, 0.699441f, -2.86102f, 
		2.11374f, 0.699441f, -2.86102f, 2.11374f, 0.699441f, -2.86102f, 
		2.11374f, 0.699441f, -2.86102f, 2.11374f, 0.699441f, -2.86102f, 
		2.11383f, -0.821373f, -2.64841f, 2.11392f, 0.903713f, -2.93394f, 
		2.11397f, 0.924878f, -2.89125f, 2.11406f, -0.361468f, -3.07241f, 
		2.11408f, 0.913720f, -2.92317f, 2.11416f, 0.814195f, -2.85394f, 
		2.11422f, 0.909174f, -2.80616f, 2.11440f, 0.884798f, -2.82445f, 
		2.11443f, -0.396553f, -3.05338f, 2.11443f, -0.396553f, -3.05338f, 
		2.11443f, -0.396553f, -3.05338f, 2.11444f, 0.717700f, -3.01299f, 
		2.11444f, 0.717700f, -3.01299f, 2.11444f, 0.717700f, -3.01299f, 
		2.11444f, 0.312766f, -2.89284f, 2.11473f, 1.08176f, -2.93894f, 
		2.11476f, 0.651301f, -2.99345f, 2.11476f, 0.651301f, -2.99345f, 
		2.11476f, 0.651301f, -2.99345f, 2.11476f, 0.651301f, -2.99345f, 
		2.11476f, 0.651301f, -2.99345f, 2.11476f, 0.651301f, -2.99345f, 
		2.11477f, 0.899720f, -2.83807f, 2.11481f, 0.758331f, -2.82997f, 
		2.11481f, 0.758331f, -2.82997f, 2.11490f, 0.753506f, -2.81845f, 
		2.11492f, 0.613315f, -3.03345f, 2.11492f, 0.613315f, -3.03345f, 
		2.11492f, 0.613315f, -3.03345f, 2.11502f, 0.694647f, -2.94934f, 
		2.11502f, 0.694647f, -2.94934f, 2.11502f, 0.694647f, -2.94934f, 
		2.11502f, 0.694647f, -2.94934f, 2.11502f, 0.694647f, -2.94934f, 
		2.11505f, 0.921164f, -2.86547f, 2.11508f, 0.649750f, -2.83254f, 
		2.11515f, 0.635248f, -3.01325f, 2.11524f, 0.585463f, -3.04112f, 
		2.11524f, 0.585463f, -3.04112f, 2.11524f, 0.585463f, -3.04112f, 
		2.11524f, 0.585463f, -3.04112f, 2.11524f, 0.585463f, -3.04112f, 
		2.11524f, 0.585463f, -3.04112f, 2.11525f, 0.891795f, -2.83299f, 
		2.11527f, 0.710677f, -2.84572f, 2.11529f, 0.757656f, -2.82956f, 
		2.11529f, 0.757656f, -2.82956f, 2.11529f, 0.757656f, -2.82956f, 
		2.11530f, 0.807916f, -2.86495f, 2.11536f, -0.871814f, -2.71447f, 
		2.11536f, 0.883333f, -2.83003f, 2.11536f, 0.883333f, -2.83003f, 
		2.11561f, 0.544981f, -2.98703f, 2.11569f, 0.514852f, -3.12891f, 
		2.11569f, 0.514852f, -3.12891f, 2.11569f, 0.514852f, -3.12891f, 
		2.11569f, 0.514852f, -3.12891f, 2.11574f, 0.887236f, -2.83145f, 
		2.11591f, 0.822677f, -2.93269f, 2.11592f, 0.430912f, -3.11059f, 
		2.11593f, 1.01641f, -2.84665f, 2.11594f, -0.194534f, -3.06625f, 
		2.11594f, -0.194534f, -3.06625f, 2.11610f, 0.934738f, -2.79387f, 
		2.11610f, 0.934738f, -2.79387f, 2.11621f, 0.684878f, -2.94001f, 
		2.11621f, 0.684878f, -2.94001f, 2.11622f, 0.707859f, -2.84575f, 
		2.11622f, 0.707859f, -2.84575f, 2.11641f, 0.915256f, -2.85332f, 
		2.11654f, 0.924352f, -2.90045f, 2.11655f, 0.584366f, -3.02331f, 
		2.11657f, 0.681923f, -2.86221f, 2.11666f, 0.684990f, -2.98778f, 
		2.11670f, 0.806702f, -2.90911f, 2.11683f, 0.709168f, -2.84888f, 
		2.11683f, 0.709168f, -2.84888f, 2.11696f, 0.802863f, -2.88938f, 
		2.11728f, 0.853293f, -2.82665f, 2.11729f, 0.803803f, -2.87683f, 
		2.11733f, 0.610228f, -3.01796f, 2.11736f, 0.846076f, -2.94706f, 
		2.11737f, -0.107182f, -3.06434f, 2.11737f, -0.107182f, -3.06434f, 
		2.11748f, 1.03883f, -3.15511f, 2.11755f, -0.395321f, -3.07520f, 
		2.11755f, -0.395321f, -3.07520f, 2.11755f, -0.395321f, -3.07520f, 
		2.11763f, 1.04603f, -3.16250f, 2.11765f, -0.0182540f, -3.02255f, 
		2.11787f, 0.848306f, -3.18743f, 2.11805f, 0.845199f, -3.19657f, 
		2.11820f, 0.743625f, -2.81645f, 2.11820f, 0.743625f, -2.81645f, 
		2.11820f, 0.743625f, -2.81645f, 2.11826f, -0.861411f, -3.03357f, 
		2.11826f, -0.861411f, -3.03357f, 2.11837f, 0.933660f, -2.80104f, 
		2.11839f, -0.827272f, -3.03340f, 2.11841f, 0.736330f, -2.81785f, 
		2.11841f, 0.736330f, -2.81785f, 2.11841f, 0.736330f, -2.81785f, 
		2.11841f, 0.736330f, -2.81785f, 2.11859f, -0.00142800f, -3.02259f, 
		2.11859f, -0.00142800f, -3.02259f, 2.11863f, 0.652514f, -2.85378f, 
		2.11863f, 0.652514f, -2.85378f, 2.11876f, 0.688462f, -2.85822f, 
		2.11876f, 0.688462f, -2.85822f, 2.11890f, -0.00558000f, -3.02295f, 
		2.11891f, 0.947483f, -2.79664f, 2.11891f, 0.947483f, -2.79664f, 
		2.11892f, 0.833940f, -2.94224f, 2.11901f, 0.883612f, -2.94733f, 
		2.11926f, 0.868162f, -2.95033f, 2.11928f, 0.680405f, -2.88917f, 
		2.11945f, 0.831055f, -2.83500f, 2.11946f, 0.922989f, -2.90942f, 
		2.11947f, -0.486960f, -3.05762f, 2.11951f, 0.864949f, -2.82501f, 
		2.11966f, 0.884396f, -2.82844f, 2.11973f, 0.713706f, -2.89906f, 
		2.11981f, 0.928551f, -2.80419f, 2.11981f, 0.928551f, -2.80419f, 
		2.11984f, 0.571095f, -3.07590f, 2.11984f, 0.571095f, -3.07590f, 
		2.11984f, 0.571095f, -3.07590f, 2.11985f, -0.809398f, -2.71246f, 
		2.12000f, 0.763418f, -2.86143f, 2.12000f, 0.763418f, -2.86143f, 
		2.12010f, 0.762830f, -2.86263f, 2.12021f, 0.877694f, -2.82623f, 
		2.12023f, 0.648445f, -2.94063f, 2.12024f, -0.577017f, -3.09924f, 
		2.12024f, -0.577017f, -3.09924f, 2.12026f, 0.908155f, -2.93279f, 
		2.12038f, 0.766891f, -2.83279f, 2.12038f, 0.766891f, -2.83279f, 
		2.12052f, 0.704286f, -2.87180f, 2.12052f, 0.704286f, -2.87180f, 
		2.12052f, 0.704286f, -2.87180f, 2.12052f, 0.704286f, -2.87180f, 
		2.12055f, 0.735880f, -2.82548f, 2.12055f, 0.735880f, -2.82548f, 
		2.12055f, 0.741963f, -2.82681f, 2.12060f, 0.855858f, -2.95022f, 
		2.12064f, 0.803160f, -2.90110f, 2.12084f, 0.363890f, -2.90346f, 
		2.12086f, 0.632406f, -3.00132f, 2.12114f, -0.125992f, -2.91928f, 
		2.12114f, -0.125992f, -2.91928f, 2.12121f, 0.650280f, -3.04279f, 
		2.12124f, 0.824867f, -3.17802f, 2.12130f, 0.722105f, -3.01400f, 
		2.12130f, 0.722105f, -3.01400f, 2.12140f, 0.810527f, -2.92034f, 
		2.12142f, 0.503529f, -2.95396f, 2.12146f, 0.899810f, -2.93994f, 
		2.12153f, 0.583998f, -3.00911f, 2.12153f, 0.583998f, -3.00911f, 
		2.12153f, 0.583998f, -3.00911f, 2.12160f, 0.820492f, -3.18665f, 
		2.12162f, 0.917494f, -2.92171f, 2.12167f, 0.669861f, -2.88205f, 
		2.12172f, 0.700424f, -2.93463f, 2.12172f, 0.700424f, -2.93463f, 
		2.12172f, 0.700424f, -2.93463f, 2.12172f, 0.700424f, -2.93463f, 
		2.12172f, 0.700424f, -2.93463f, 2.12183f, 1.09337f, -2.93112f, 
		2.12186f, 0.804288f, -2.86929f, 2.12189f, 4.90000e-005f, -3.01965f, 
		2.12189f, 4.90000e-005f, -3.01965f, 2.12189f, 4.90000e-005f, -3.01965f, 
		2.12206f, 0.816867f, -2.84625f, 2.12207f, 0.651192f, -2.84679f, 
		2.12207f, 0.651192f, -2.84679f, 2.12213f, 0.651697f, -2.84608f, 
		2.12213f, 0.651697f, -2.84608f, 2.12213f, 0.651697f, -2.84608f, 
		2.12213f, 0.651697f, -2.84608f, 2.12247f, 0.818594f, -2.93142f, 
		2.12265f, 0.950117f, -2.80500f, 2.12265f, 0.950117f, -2.80500f, 
		2.12266f, 0.927558f, -2.88842f, 2.12271f, 0.608663f, -3.00576f, 
		2.12274f, 0.467899f, -3.11984f, 2.12283f, 0.756979f, -3.11948f, 
		2.12285f, 0.115654f, -3.07044f, 2.12294f, 0.840896f, -2.82878f, 
		2.12294f, 0.926578f, -2.87586f, 2.12296f, 0.686166f, -2.93696f, 
		2.12296f, 0.686166f, -2.93696f, 2.12301f, -0.00972000f, -3.06221f, 
		2.12301f, -0.00972000f, -3.06221f, 2.12305f, 0.0188700f, -3.06301f, 
		2.12305f, 0.0188700f, -3.06301f, 2.12305f, 0.0188700f, -3.06301f, 
		2.12305f, 0.0188700f, -3.06301f, 2.12305f, 0.0188700f, -3.06301f, 
		2.12305f, 0.0188700f, -3.06301f, 2.12306f, 0.823807f, -2.83909f, 
		2.12343f, -0.485834f, -3.07956f, 2.12343f, -0.485834f, -3.07956f, 
		2.12360f, 0.809534f, -2.85588f, 2.12367f, 0.916776f, -2.85187f, 
		2.12367f, 0.715505f, -2.82498f, 2.12367f, 0.715505f, -2.82498f, 
		2.12372f, 0.711140f, -2.83735f, 2.12387f, 0.683834f, -2.87395f, 
		2.12388f, 0.747434f, -3.05171f, 2.12390f, 0.708222f, -2.83824f, 
		2.12390f, 0.708222f, -2.83824f, 2.12395f, 0.684665f, -2.98420f, 
		2.12428f, 0.793316f, -3.16053f, 2.12439f, 0.617934f, -3.04795f, 
		2.12452f, 0.801252f, -2.88137f, 2.12454f, -0.655146f, -3.10277f, 
		2.12454f, -0.655146f, -3.10277f, 2.12454f, 0.952976f, -2.80608f, 
		2.12455f, 0.622314f, -2.87162f, 2.12455f, 0.910684f, -2.84399f, 
		2.12458f, 0.709762f, -2.84182f, 2.12458f, 0.709762f, -2.84182f, 
		2.12459f, -0.115637f, -2.88921f, 2.12459f, -0.115637f, -2.88921f, 
		2.12459f, -0.115637f, -2.88921f, 2.12470f, 0.0566330f, -2.90527f, 
		2.12471f, 0.682451f, -2.90257f, 2.12472f, -0.871814f, -2.64441f, 
		2.12480f, 0.787233f, -3.16822f, 2.12484f, 0.898461f, -2.83380f, 
		2.12496f, 0.154133f, -3.06693f, 2.12506f, 0.0700470f, -3.07302f, 
		2.12506f, 0.708498f, -2.82519f, 2.12531f, 0.714417f, -2.91751f, 
		2.12531f, 0.714417f, -2.91751f, 2.12531f, 0.714417f, -2.91751f, 
		2.12531f, 0.714417f, -2.91751f, 2.12544f, 0.706991f, -2.84171f, 
		2.12554f, 0.892341f, -2.94545f, 2.12557f, 0.716086f, -2.83174f, 
		2.12557f, 0.716086f, -2.83174f, 2.12557f, 0.716086f, -2.83174f, 
		2.12557f, 0.716086f, -2.83174f, 2.12583f, -0.00297500f, -3.01465f, 
		2.12599f, 0.878560f, -2.95035f, 2.12601f, 0.923180f, -2.86261f, 
		2.12605f, 0.905951f, -2.83903f, 2.12615f, 0.708167f, -2.88243f, 
		2.12615f, 0.708167f, -2.88243f, 2.12618f, 0.842882f, -2.94827f, 
		2.12620f, -0.579647f, -3.06130f, 2.12630f, 0.827885f, -2.94052f, 
		2.12630f, 0.805979f, -2.86205f, 2.12633f, -0.208233f, -2.89399f, 
		2.12633f, -0.208233f, -2.89399f, 2.12726f, 0.711500f, -2.83388f, 
		2.12728f, 0.566199f, -2.99558f, 2.12729f, 0.831324f, -2.83277f, 
		2.12733f, 0.587322f, -3.05703f, 2.12733f, 0.587322f, -3.05703f, 
		2.12733f, 0.587322f, -3.05703f, 2.12748f, 0.743375f, -3.13413f, 
		2.12749f, 0.749044f, -2.94063f, 2.12772f, 0.692275f, -2.86924f, 
		2.12772f, 0.692275f, -2.86924f, 2.12777f, 0.662784f, -2.96586f, 
		2.12777f, 0.662784f, -2.96586f, 2.12803f, 0.658482f, -2.86291f, 
		2.12803f, 0.658482f, -2.86291f, 2.12803f, 0.658482f, -2.86291f, 
		2.12807f, 0.410593f, -2.91295f, 2.12825f, 0.850021f, -2.82078f, 
		2.12825f, 0.850021f, -2.82078f, 2.12827f, 0.695904f, -3.05377f, 
		2.12829f, 0.927753f, -2.89740f, 2.12835f, 0.652375f, -2.98558f, 
		2.12839f, 0.874548f, -2.82400f, 2.12846f, 0.848547f, -2.81907f, 
		2.12846f, 0.848547f, -2.81907f, 2.12846f, 0.848547f, -2.81907f, 
		2.12864f, 0.657872f, -2.86274f, 2.12864f, 0.657872f, -2.86274f, 
		2.12864f, 0.864861f, -2.95241f, 2.12883f, 0.723892f, -3.01135f, 
		2.12883f, 0.723892f, -3.01135f, 2.12896f, 0.202108f, -3.06762f, 
		2.12898f, 0.886712f, -2.82705f, 2.12906f, 0.801728f, -2.87372f, 
		2.12910f, 0.685501f, -2.98214f, 2.12913f, 0.849816f, -2.82449f, 
		2.12913f, 0.849816f, -2.82449f, 2.12916f, 0.920684f, -2.91927f, 
		2.12934f, 0.716255f, -2.86843f, 2.12935f, 0.855358f, -2.82370f, 
		2.12939f, 0.845236f, -2.82656f, 2.12947f, -0.657855f, -3.06391f, 
		2.12954f, 0.901738f, -2.94060f, 2.13002f, -0.200361f, -2.86833f, 
		2.13002f, -0.200361f, -2.86833f, 2.13002f, -0.200361f, -2.86833f, 
		2.13006f, 0.685154f, -2.88455f, 2.13007f, 0.804593f, -2.91193f, 
		2.13008f, 0.695850f, -2.83305f, 2.13014f, -0.740062f, -3.11173f, 
		2.13014f, -0.740062f, -3.11173f, 2.13023f, 0.799986f, -2.88698f, 
		2.13032f, 0.835506f, -2.81776f, 2.13033f, -0.273348f, -2.87533f, 
		2.13033f, -0.273348f, -2.87533f, 2.13036f, 0.713435f, -2.86851f, 
		2.13036f, 0.713435f, -2.86851f, 2.13039f, 0.913596f, -2.92988f, 
		2.13074f, 0.714609f, -2.87061f, 2.13074f, 0.714609f, -2.87061f, 
		2.13077f, 0.711827f, -2.87124f, 2.13084f, 0.693387f, -2.94330f, 
		2.13097f, 0.926305f, -2.90644f, 2.13099f, 0.103551f, -2.89173f, 
		2.13121f, 1.07720f, -3.05016f, 2.13123f, -0.578749f, -3.08452f, 
		2.13123f, -0.578749f, -3.08452f, 2.13174f, 0.810790f, -2.92392f, 
		2.13179f, 0.813117f, -2.84842f, 2.13181f, 0.712015f, -2.89436f, 
		2.13181f, 0.712015f, -2.89436f, 2.13183f, 0.0155080f, -3.05175f, 
		2.13183f, 0.0155080f, -3.05175f, 2.13183f, 0.0155080f, -3.05175f, 
		2.13183f, 0.0155080f, -3.05175f, 2.13183f, 0.0155080f, -3.05175f, 
		2.13188f, 0.929092f, -2.88660f, 2.13198f, 0.830124f, -2.81577f, 
		2.13198f, -0.00815700f, -3.00493f, 2.13200f, 0.632618f, -2.99369f, 
		2.13205f, 0.252393f, -3.06892f, 2.13219f, 0.147477f, -2.88392f, 
		2.13220f, 0.849359f, -2.82455f, 2.13224f, 0.800636f, -2.89853f, 
		2.13231f, 0.674491f, -3.00903f, 2.13281f, 0.980420f, -2.81819f, 
		2.13287f, 0.839328f, -2.82793f, 2.13296f, 0.836963f, -2.94679f, 
		2.13313f, 0.821210f, -2.93624f, 2.13331f, 0.852436f, -2.95176f, 
		2.13331f, -0.742014f, -3.06873f, 2.13354f, 0.748926f, -2.82959f, 
		2.13356f, 0.916586f, -2.84928f, 2.13357f, 0.873652f, -2.95227f, 
		2.13359f, 0.883446f, -2.82546f, 2.13359f, 0.883446f, -2.82546f, 
		2.13359f, 1.09037f, -3.05126f, 2.13361f, 0.637945f, -2.90649f, 
		2.13369f, 0.866480f, -2.82265f, 2.13372f, 0.884821f, -2.82092f, 
		2.13372f, 0.884821f, -2.82092f, 2.13372f, 0.884821f, -2.82092f, 
		2.13372f, 0.814715f, -2.92965f, 2.13400f, 0.728912f, -3.06779f, 
		2.13412f, 0.584190f, -2.99916f, 2.13415f, 0.746145f, -2.83741f, 
		2.13415f, 0.746145f, -2.83741f, 2.13415f, 0.746145f, -2.83741f, 
		2.13420f, 0.687830f, -2.93105f, 2.13420f, 0.687830f, -2.93105f, 
		2.13423f, 0.695351f, -2.88103f, 2.13423f, 0.695351f, -2.88103f, 
		2.13433f, 0.805969f, -2.85981f, 2.13434f, -0.805223f, -2.76087f, 
		2.13434f, -0.805223f, -2.76087f, 2.13434f, -0.805223f, -2.76087f, 
		2.13436f, 0.697675f, -2.84306f, 2.13440f, 0.885280f, -2.94948f, 
		2.13440f, 0.685872f, -2.97972f, 2.13450f, 0.700736f, -2.92760f, 
		2.13454f, 0.927626f, -2.87330f, 2.13462f, 0.888570f, -2.81952f, 
		2.13462f, -0.334146f, -2.85638f, 2.13462f, -0.334146f, -2.85638f, 
		2.13483f, 0.756759f, -2.82943f, 2.13483f, 0.756759f, -2.82943f, 
		2.13483f, 0.756759f, -2.82943f, 2.13488f, 0.825185f, -2.81326f, 
		2.13493f, 0.608670f, -2.99737f, 2.13493f, 0.299715f, -3.07170f, 
		2.13494f, 0.821737f, -2.83883f, 2.13495f, 0.751423f, -2.83887f, 
		2.13514f, -0.0128200f, -2.99901f, 2.13514f, -0.0128200f, -2.99901f, 
		2.13514f, -0.0128200f, -2.99901f, 2.13515f, 0.545887f, -2.96802f, 
		2.13530f, 0.887185f, -2.82692f, 2.13534f, 0.909478f, -2.84124f, 
		2.13547f, 0.724400f, -3.00855f, 2.13547f, 0.724400f, -3.00855f, 
		2.13549f, 0.675788f, -3.01419f, 2.13556f, -0.656890f, -3.08802f, 
		2.13556f, -0.656890f, -3.08802f, 2.13564f, 0.711877f, -2.90878f, 
		2.13564f, 0.711877f, -2.90878f, 2.13564f, 0.711877f, -2.90878f, 
		2.13585f, 0.687377f, -2.89701f, 2.13585f, 0.687377f, -2.89701f, 
		2.13585f, 0.687377f, -2.89701f, 2.13588f, 0.456260f, -2.92253f, 
		2.13603f, -0.267330f, -2.85289f, 2.13603f, -0.267330f, -2.85289f, 
		2.13603f, -0.267330f, -2.85289f, 2.13608f, 0.892201f, -2.81819f, 
		2.13623f, 0.673195f, -3.00456f, 2.13629f, 0.921322f, -2.85695f, 
		2.13629f, -0.836332f, -2.77025f, 2.13631f, 0.764993f, -2.85045f, 
		2.13631f, 0.764993f, -2.85045f, 2.13658f, 0.736564f, -2.83407f, 
		2.13658f, 0.736564f, -2.83407f, 2.13667f, -0.777091f, -3.11850f, 
		2.13667f, -0.777091f, -3.11850f, 2.13689f, 0.764349f, -2.85014f, 
		2.13700f, 0.770247f, -2.82837f, 2.13700f, 0.770247f, -2.82837f, 
		2.13700f, 0.770247f, -2.82837f, 2.13700f, 0.770247f, -2.82837f, 
		2.13707f, 0.198350f, -2.88101f, 2.13714f, -0.0247040f, -2.98948f, 
		2.13714f, -0.0247040f, -2.98948f, 2.13714f, -0.0247040f, -2.98948f, 
		2.13714f, -0.0247040f, -2.98948f, 2.13714f, -0.0247040f, -2.98948f, 
		2.13714f, -0.0247040f, -2.98948f, 2.13723f, 0.657485f, -2.85457f, 
		2.13723f, 0.657485f, -2.85457f, 2.13723f, 0.713055f, -3.07383f, 
		2.13723f, 0.713055f, -3.07383f, 2.13728f, 0.654040f, -3.05123f, 
		2.13740f, 0.778748f, -2.82077f, 2.13740f, 0.778748f, -2.82077f, 
		2.13740f, 0.778748f, -2.82077f, 2.13740f, 0.778748f, -2.82077f, 
		2.13740f, -0.369158f, -2.84896f, 2.13740f, -0.369158f, -2.84896f, 
		2.13742f, 0.640368f, -2.84268f, 2.13742f, 0.640368f, -2.84268f, 
		2.13743f, 0.658042f, -2.85392f, 2.13743f, 0.658042f, -2.85392f, 
		2.13743f, 0.658042f, -2.85392f, 2.13743f, 0.658042f, -2.85392f, 
		2.13747f, 0.733404f, -2.84148f, 2.13758f, 0.820085f, -2.81097f, 
		2.13760f, -0.776761f, -3.06920f, 2.13779f, 0.895825f, -2.81650f, 
		2.13793f, -0.0413970f, -2.97733f, 2.13793f, -0.0413970f, -2.97733f, 
		2.13793f, -0.0413970f, -2.97733f, 2.13793f, 0.801819f, -2.87082f, 
		2.13794f, 0.345650f, -3.07710f, 2.13794f, 0.680060f, -3.01524f, 
		2.13806f, 0.899991f, -2.94246f, 2.13807f, 0.775888f, -2.87397f, 
		2.13813f, 0.786791f, -2.81356f, 2.13813f, -0.857361f, -2.77284f, 
		2.13813f, -0.857361f, -2.77284f, 2.13835f, 0.896285f, -2.83099f, 
		2.13836f, 0.910768f, -2.93355f, 2.13837f, 0.773865f, -2.84536f, 
		2.13837f, 0.773865f, -2.84536f, 2.13851f, 0.977067f, -3.18784f, 
		2.13874f, 0.680911f, -2.84164f, 2.13878f, 0.810518f, -2.80979f, 
		2.13895f, 0.872825f, -2.82322f, 2.13902f, 0.925290f, -2.86529f, 
		2.13907f, 0.734169f, -2.83507f, 2.13907f, 0.734169f, -2.83507f, 
		2.13923f, 0.808895f, -2.92148f, 2.13928f, 0.829623f, -2.83293f, 
		2.13933f, 0.730635f, -2.84364f, 2.13949f, 0.822723f, -2.93775f, 
		2.13963f, 0.864256f, -2.95310f, 2.13972f, 0.899390f, -2.81413f, 
		2.13981f, 0.980929f, -3.19700f, 2.13983f, 0.927003f, -2.90409f, 
		2.13991f, 0.845161f, -2.82559f, 2.13993f, 0.799883f, -2.88223f, 
		2.13997f, 0.798832f, -2.80998f, 2.14026f, 0.667893f, -2.88325f, 
		2.14026f, 0.667893f, -2.88325f, 2.14028f, 0.620607f, -3.05581f, 
		2.14040f, 0.922915f, -2.91593f, 2.14043f, -0.870433f, -3.11985f, 
		2.14047f, 0.654368f, -2.93457f, 2.14063f, 0.887274f, -2.82697f, 
		2.14070f, 0.807584f, -2.85675f, 2.14100f, 0.909119f, -2.80989f, 
		2.14111f, 0.698915f, -2.89557f, 2.14111f, 0.698915f, -2.89557f, 
		2.14113f, 0.918999f, -2.92287f, 2.14113f, 0.814580f, -2.84638f, 
		2.14114f, 0.915352f, -2.84776f, 2.14115f, 0.667609f, -2.88356f, 
		2.14115f, 0.667609f, -2.88356f, 2.14115f, 0.667609f, -2.88356f, 
		2.14122f, 0.800210f, -2.89559f, 2.14126f, 0.929059f, -2.88472f, 
		2.14129f, -0.329015f, -2.83707f, 2.14131f, 0.878106f, -2.95143f, 
		2.14142f, -0.129657f, -2.94294f, 2.14142f, -0.129657f, -2.94294f, 
		2.14142f, -0.129657f, -2.94294f, 2.14153f, -0.404193f, -2.84676f, 
		2.14153f, -0.404193f, -2.84676f, 2.14157f, 0.928588f, -2.89673f, 
		2.14158f, 0.803172f, -2.90889f, 2.14168f, 0.721634f, -2.89207f, 
		2.14181f, -0.741717f, -3.09597f, 2.14181f, -0.741717f, -3.09597f, 
		2.14183f, 0.652738f, -2.97742f, 2.14183f, 0.652738f, -2.97742f, 
		2.14183f, 0.652738f, -2.97742f, 2.14192f, 0.0131480f, -3.04877f, 
		2.14192f, 0.0131480f, -3.04877f, 2.14195f, 0.844432f, -2.94974f, 
		2.14197f, 0.388826f, -3.08435f, 2.14217f, 0.687971f, -2.97697f, 
		2.14221f, 0.725706f, -3.00632f, 2.14221f, 0.725706f, -3.00632f, 
		2.14231f, 0.756947f, -2.83819f, 2.14231f, 0.753951f, -2.84403f, 
		2.14231f, 0.753951f, -2.84403f, 2.14251f, 0.716930f, -2.89371f, 
		2.14269f, 0.890168f, -2.94747f, 2.14278f, 0.723773f, -2.83939f, 
		2.14278f, 0.723773f, -2.83939f, 2.14278f, 0.723773f, -2.83939f, 
		2.14282f, 0.903908f, -2.83636f, 2.14308f, 0.257491f, -2.88124f, 
		2.14317f, 0.690907f, -2.92125f, 2.14317f, 0.690907f, -2.92125f, 
		2.14317f, 0.690907f, -2.92125f, 2.14323f, 0.674546f, -3.00094f, 
		2.14326f, 0.867431f, -2.82281f, 2.14327f, 0.853982f, -2.82375f, 
		2.14332f, 0.567045f, -2.98145f, 2.14346f, 0.633105f, -2.98657f, 
		2.14353f, 0.750002f, -2.93468f, 2.14372f, 1.07629f, -2.93318f, 
		2.14380f, 0.757008f, -2.84732f, 2.14380f, 0.757008f, -2.84732f, 
		2.14380f, 0.879192f, -2.82462f, 2.14382f, -0.0123690f, -2.88851f, 
		2.14382f, -0.0123690f, -2.88851f, 2.14382f, -0.0123690f, -2.88851f, 
		2.14388f, 0.750618f, -2.84019f, 2.14388f, 0.750618f, -2.84019f, 
		2.14388f, 0.750618f, -2.84019f, 2.14388f, 0.750618f, -2.84019f, 
		2.14389f, -0.365925f, -2.83029f, 2.14408f, 1.02258f, -2.84151f, 
		2.14408f, 1.02258f, -2.84151f, 2.14408f, 1.02258f, -2.84151f, 
		2.14408f, 1.02258f, -2.84151f, 2.14408f, 1.02258f, -2.84151f, 
		2.14409f, 0.113139f, -3.05317f, 2.14427f, 0.746223f, -2.84636f, 
		2.14437f, 1.04380f, -3.14739f, 2.14459f, -0.212486f, -2.91695f, 
		2.14459f, -0.212486f, -2.91695f, 2.14459f, -0.212486f, -2.91695f, 
		2.14467f, 0.836279f, -2.82966f, 2.14467f, 0.757963f, -3.11587f, 
		2.14481f, 0.773743f, -2.91061f, 2.14481f, 0.773743f, -2.91061f, 
		2.14488f, 0.716024f, -2.86114f, 2.14488f, 0.716024f, -2.86114f, 
		2.14501f, 0.774401f, -2.90991f, 2.14501f, 0.774401f, -2.90991f, 
		2.14501f, 0.774401f, -2.90991f, 2.14516f, 0.700695f, -2.91673f, 
		2.14516f, 0.700695f, -2.91673f, 2.14516f, 0.700695f, -2.91673f, 
		2.14516f, 0.700695f, -2.91673f, 2.14517f, 0.717787f, -2.85778f, 
		2.14526f, 0.714845f, -2.85857f, 2.14526f, 0.714845f, -2.85857f, 
		2.14530f, 0.856719f, -2.95212f, 2.14537f, 0.830521f, -2.94296f, 
		2.14538f, 0.764700f, -2.83721f, 2.14538f, 0.764700f, -2.83721f, 
		2.14538f, 0.764700f, -2.83721f, 2.14538f, 0.764700f, -2.83721f, 
		2.14538f, 0.764700f, -2.83721f, 2.14559f, 0.749529f, -3.04454f, 
		2.14560f, 0.824066f, -2.83779f, 2.14565f, 0.927795f, -2.87696f, 
		2.14570f, 0.430982f, -3.09139f, 2.14571f, 0.0662080f, -3.05853f, 
		2.14577f, 0.854692f, -2.82046f, 2.14577f, 0.854692f, -2.82046f, 
		2.14582f, 0.854323f, -2.82428f, 2.14582f, 0.854323f, -2.82428f, 
		2.14583f, 0.713288f, -2.86113f, 2.14587f, 0.588143f, -3.06466f, 
		2.14587f, 0.588143f, -3.06466f, 2.14587f, 0.588143f, -3.06466f, 
		2.14587f, 0.503981f, -2.93287f, 2.14593f, 0.561173f, -3.08330f, 
		2.14593f, 0.561173f, -3.08330f, 2.14593f, 0.561173f, -3.08330f, 
		2.14597f, 1.05127f, -3.15437f, 2.14605f, 0.692084f, -2.88376f, 
		2.14608f, -0.809278f, -2.69310f, 2.14610f, -0.277379f, -2.89698f, 
		2.14610f, -0.277379f, -2.89698f, 2.14610f, -0.277379f, -2.89698f, 
		2.14623f, -0.870433f, -3.07303f, 2.14626f, 0.528685f, -3.10547f, 
		2.14626f, 0.528685f, -3.10547f, 2.14626f, 0.528685f, -3.10547f, 
		2.14626f, 0.528685f, -3.10547f, 2.14626f, 0.528685f, -3.10547f, 
		2.14630f, 0.744745f, -2.85038f, 2.14641f, -0.835873f, -2.62718f, 
		2.14641f, -0.835873f, -2.62718f, 2.14645f, 0.724080f, -2.85225f, 
		2.14655f, 0.695360f, -2.93664f, 2.14659f, 0.853048f, -2.81909f, 
		2.14659f, 0.853048f, -2.81909f, 2.14659f, 0.853048f, -2.81909f, 
		2.14660f, 0.152385f, -3.04922f, 2.14669f, 0.814122f, -2.92763f, 
		2.14672f, 0.663458f, -2.95846f, 2.14672f, 0.663458f, -2.95846f, 
		2.14672f, 0.663458f, -2.95846f, 2.14672f, 0.663458f, -2.95846f, 
		2.14677f, 0.637049f, -2.87208f, 2.14677f, 0.637049f, -2.87208f, 
		2.14677f, 0.637049f, -2.87208f, 2.14687f, 0.930630f, -3.19269f, 
		2.14695f, 0.753746f, -2.84050f, 2.14695f, 0.753746f, -2.84050f, 
		2.14695f, 0.753746f, -2.84050f, 2.14695f, 0.753746f, -2.84050f, 
		2.14707f, 0.694981f, -3.05035f, 2.14710f, 0.808287f, -2.91888f, 
		2.14717f, 0.584924f, -2.98986f, 2.14717f, 0.584924f, -2.98986f, 
		2.14717f, 0.584924f, -2.98986f, 2.14734f, 0.924936f, -2.90898f, 
		2.14760f, 0.759246f, -2.84404f, 2.14760f, 0.759246f, -2.84404f, 
		2.14768f, 0.609438f, -2.98941f, 2.14775f, 0.817514f, -2.84423f, 
		2.14791f, 0.679695f, -3.01161f, 2.14799f, 0.920475f, -2.85681f, 
		2.14799f, -0.401708f, -2.82822f, 2.14805f, 0.912485f, -2.84544f, 
		2.14812f, 0.879033f, -2.82525f, 2.14812f, 0.879033f, -2.82525f, 
		2.14820f, -0.108526f, -2.86978f, 2.14820f, -0.108526f, -2.86978f, 
		2.14820f, -0.108526f, -2.86978f, 2.14822f, 0.312491f, -2.88468f, 
		2.14829f, 0.873675f, -2.95150f, 2.14834f, 0.850473f, -2.82615f, 
		2.14845f, 0.820376f, -2.93437f, 2.14850f, 0.692431f, -2.97640f, 
		2.14852f, -0.339169f, -2.87795f, 2.14852f, -0.339169f, -2.87795f, 
		2.14852f, -0.339169f, -2.87795f, 2.14857f, 0.879546f, -2.82124f, 
		2.14857f, 0.879546f, -2.82124f, 2.14862f, 0.931978f, -3.20212f, 
		2.14862f, 0.846474f, -2.81790f, 2.14864f, 0.769764f, -2.82749f, 
		2.14864f, 0.769764f, -2.82749f, 2.14864f, 0.769764f, -2.82749f, 
		2.14864f, 0.769764f, -2.82749f, 2.14880f, 0.885783f, -3.19308f, 
		2.14880f, 0.676419f, -3.00211f, 2.14893f, 0.800592f, -2.88756f, 
		2.14896f, 0.928191f, -2.88925f, 2.14917f, 0.758928f, -2.84890f, 
		2.14917f, 0.758928f, -2.84890f, 2.14917f, 0.758928f, -2.84890f, 
		2.14918f, 0.772328f, -2.85113f, 2.14918f, 0.772328f, -2.85113f, 
		2.14933f, 0.932047f, -2.80220f, 2.14933f, 0.932047f, -2.80220f, 
		2.14943f, -0.777962f, -3.10106f, 2.14943f, -0.777962f, -3.10106f, 
		2.14944f, 0.912184f, -2.93029f, 2.14945f, -0.195003f, -2.85351f, 
		2.14968f, 0.803978f, -2.86774f, 2.14970f, 0.925349f, -2.86940f, 
		2.14975f, 0.902522f, -2.93918f, 2.14981f, 0.0220660f, -2.88979f, 
		2.14981f, 0.0220660f, -2.88979f, 2.14981f, 0.0220660f, -2.88979f, 
		2.14981f, 0.0220660f, -2.88979f, 2.14981f, 0.0220660f, -2.88979f, 
		2.14986f, 0.725941f, -3.00317f, 2.14986f, 0.725941f, -3.00317f, 
		2.14987f, 0.919332f, -2.92014f, 2.14995f, 0.888477f, -2.82879f, 
		2.15004f, 0.677399f, -3.00828f, 2.15004f, 0.677399f, -3.00828f, 
		2.15004f, 0.677399f, -3.00828f, 2.15021f, -0.866004f, -2.62484f, 
		2.15021f, -0.866004f, -2.62484f, 2.15030f, 0.883271f, -2.82092f, 
		2.15050f, 0.930355f, -2.80920f, 2.15050f, 0.744413f, -3.13032f, 
		2.15057f, -0.493933f, -2.83910f, 2.15057f, -0.493933f, -2.83910f, 
		2.15065f, 0.884704f, -3.20252f, 2.15069f, -0.850958f, -2.62552f, 
		2.15069f, -0.850958f, -2.62552f, 2.15069f, -0.850958f, -2.62552f, 
		2.15070f, 0.809978f, -2.85512f, 2.15105f, 0.00883100f, -3.03748f, 
		2.15105f, 0.00883100f, -3.03748f, 2.15107f, 0.200712f, -3.04942f, 
		2.15123f, -0.371584f, -2.87096f, 2.15123f, -0.371584f, -2.87096f, 
		2.15123f, -0.371584f, -2.87096f, 2.15124f, 0.767341f, -2.83967f, 
		2.15124f, 0.767341f, -2.83967f, 2.15124f, 0.767341f, -2.83967f, 
		2.15124f, 0.767341f, -2.83967f, 2.15124f, 0.767341f, -2.83967f, 
		2.15124f, 0.767341f, -2.83967f, 2.15130f, 0.805832f, -2.91190f, 
		2.15134f, 0.477461f, -3.09869f, 2.15141f, 0.748379f, -2.83435f, 
		2.15141f, 0.748379f, -2.83435f, 2.15141f, 0.748379f, -2.83435f, 
		2.15141f, 0.748379f, -2.83435f, 2.15141f, 0.748379f, -2.83435f, 
		2.15141f, 0.748379f, -2.83435f, 2.15142f, 0.852866f, -2.95045f, 
		2.15152f, 0.926542f, -2.81258f, 2.15152f, 0.926542f, -2.81258f, 
		2.15160f, 0.796138f, -3.15625f, 2.15166f, 0.852562f, -3.18273f, 
		2.15179f, 0.802309f, -2.89986f, 2.15182f, 0.866773f, -2.82434f, 
		2.15184f, -0.791963f, -2.74676f, 2.15192f, 0.831972f, -2.83339f, 
		2.15202f, 0.882222f, -2.82748f, 2.15210f, 0.841477f, -2.94701f, 
		2.15217f, 0.839502f, -2.81732f, 2.15217f, 0.655110f, -3.04869f, 
		2.15226f, -0.819245f, -3.13462f, 2.15226f, -0.819245f, -3.13462f, 
		2.15232f, 0.828596f, -3.17359f, 2.15240f, 0.802539f, -2.87678f, 
		2.15254f, 1.01278f, -2.84915f, 2.15255f, 0.761631f, -2.83050f, 
		2.15255f, 0.761631f, -2.83050f, 2.15255f, 0.761631f, -2.83050f, 
		2.15255f, 0.761631f, -2.83050f, 2.15258f, 0.898114f, -2.83436f, 
		2.15261f, 0.886581f, -2.82116f, 2.15270f, -0.860131f, -3.13496f, 
		2.15270f, -0.860131f, -3.13496f, 2.15270f, -0.860131f, -3.13496f, 
		2.15270f, 0.833366f, -2.94301f, 2.15274f, 0.709373f, -2.84110f, 
		2.15290f, 0.745521f, -2.85633f, 2.15293f, 0.364045f, -2.89154f, 
		2.15308f, 0.894506f, -2.94338f, 2.15310f, 0.774430f, -2.87312f, 
		2.15310f, 0.774430f, -2.87312f, 2.15310f, 0.774430f, -2.87312f, 
		2.15310f, 0.774430f, -2.87312f, 2.15310f, 0.774430f, -2.87312f, 
		2.15318f, 0.771338f, -2.87504f, 2.15318f, 0.771338f, -2.87504f, 
		2.15322f, 0.852055f, -2.82593f, 2.15333f, 0.763123f, -2.85591f, 
		2.15333f, 0.763123f, -2.85591f, 2.15355f, -0.870433f, -3.10194f, 
		2.15359f, 0.790208f, -3.16371f, 2.15366f, 0.849686f, -3.19162f, 
		2.15380f, 0.943263f, -2.80595f, 2.15380f, 0.943263f, -2.80595f, 
		2.15380f, 0.943263f, -2.80595f, 2.15382f, 0.770716f, -2.87482f, 
		2.15389f, 1.08733f, -2.92475f, 2.15409f, 0.727175f, -2.91683f, 
		2.15409f, 0.727175f, -2.91683f, 2.15416f, 0.724999f, -2.91620f, 
		2.15416f, 0.724999f, -2.91620f, 2.15416f, 0.724999f, -2.91620f, 
		2.15419f, 0.886276f, -2.94698f, 2.15431f, 0.722180f, -2.91724f, 
		2.15431f, 0.722180f, -2.91724f, 2.15436f, 0.824423f, -3.18198f, 
		2.15439f, -0.262714f, -2.83987f, 2.15439f, -0.262714f, -2.83987f, 
		2.15439f, -0.262714f, -2.83987f, 2.15443f, 0.730705f, -3.06125f, 
		2.15447f, 0.820733f, -2.84294f, 2.15471f, 0.925761f, -2.90020f, 
		2.15473f, 0.252182f, -3.05015f, 2.15486f, -0.828652f, -2.81579f, 
		2.15493f, 0.621272f, -3.05326f, 2.15503f, -0.862791f, -2.81567f, 
		2.15503f, -0.862791f, -2.81567f, 2.15503f, 0.724167f, -2.91651f, 
		2.15503f, 0.724167f, -2.91651f, 2.15503f, 0.724167f, -2.91651f, 
		2.15510f, -0.404881f, -2.86874f, 2.15510f, -0.404881f, -2.86874f, 
		2.15510f, -0.404881f, -2.86874f, 2.15518f, 0.723000f, -2.99710f, 
		2.15518f, 0.723000f, -2.99710f, 2.15518f, 0.723000f, -2.99710f, 
		2.15541f, 0.0567220f, -2.89250f, 2.15541f, 0.0567220f, -2.89250f, 
		2.15541f, 0.0567220f, -2.89250f, 2.15541f, 0.0567220f, -2.89250f, 
		2.15541f, 0.0567220f, -2.89250f, 2.15576f, 0.812726f, -2.92263f, 
		2.15581f, -0.863857f, -2.75927f, 2.15589f, 0.771697f, -2.82001f, 
		2.15589f, 0.771697f, -2.82001f, 2.15589f, 0.771697f, -2.82001f, 
		2.15589f, 0.890705f, -2.82115f, 2.15590f, 0.862926f, -2.95055f, 
		2.15592f, 0.878437f, -2.82708f, 2.15595f, 0.833728f, -2.81640f, 
		2.15599f, 0.699597f, -2.97692f, 2.15601f, 0.873413f, -2.82796f, 
		2.15601f, 0.873413f, -2.82796f, 2.15616f, 0.926078f, -2.88019f, 
		2.15622f, 0.873554f, -2.82380f, 2.15622f, 0.873554f, -2.82380f, 
		2.15631f, -0.821613f, -3.06231f, 2.15648f, 0.740684f, -2.93014f, 
		2.15648f, 0.740684f, -2.93014f, 2.15649f, 1.04742f, -2.82513f, 
		2.15649f, 1.04742f, -2.82513f, 2.15654f, 0.636528f, -2.98624f, 
		2.15657f, 0.645631f, -2.90135f, 2.15663f, 0.907455f, -2.84314f, 
		2.15669f, 0.821005f, -2.93222f, 2.15670f, 0.668236f, -2.87306f, 
		2.15670f, 0.668236f, -2.87306f, 2.15675f, 0.659257f, -2.97565f, 
		2.15675f, 0.659257f, -2.97565f, 2.15675f, 0.659257f, -2.97565f, 
		2.15686f, 0.859446f, -2.82626f, 2.15686f, 0.859446f, -2.82626f, 
		2.15690f, 0.921474f, -2.91200f, 2.15697f, -0.871814f, -2.68752f, 
		2.15698f, -0.491310f, -2.82116f, 2.15699f, 0.668843f, -2.87250f, 
		2.15701f, 0.845648f, -2.82867f, 2.15703f, 1.07541f, -3.04105f, 
		2.15715f, 0.860584f, -2.82232f, 2.15715f, 0.860584f, -2.82232f, 
		2.15752f, 0.700979f, -2.93148f, 2.15771f, 0.711913f, -2.88399f, 
		2.15802f, -0.325447f, -2.82651f, 2.15802f, 0.922188f, -2.86661f, 
		2.15806f, -0.585895f, -2.83125f, 2.15806f, -0.585895f, -2.83125f, 
		2.15818f, 0.915867f, -2.85412f, 2.15820f, 0.300378f, -3.05237f, 
		2.15838f, 0.874291f, -2.94880f, 2.15838f, 0.946298f, -2.81588f, 
		2.15838f, 0.946298f, -2.81588f, 2.15842f, 0.886484f, -2.83036f, 
		2.15844f, 0.864643f, -2.82630f, 2.15854f, 0.813564f, -2.85366f, 
		2.15859f, 0.848535f, -2.94736f, 2.15871f, 0.714937f, -3.06695f, 
		2.15871f, 0.714937f, -3.06695f, 2.15876f, 0.828829f, -2.93789f, 
		2.15915f, 0.858381f, -2.82199f, 2.15935f, 0.709880f, -2.98281f, 
		2.15951f, 0.681904f, -2.84890f, 2.15951f, 0.681904f, -2.84890f, 
		2.15951f, 0.681904f, -2.84890f, 2.15953f, 0.718052f, -2.98991f, 
		2.15959f, -0.362624f, -2.82008f, 2.15968f, 0.807722f, -2.91025f, 
		2.15985f, 0.410589f, -2.89792f, 2.15992f, 0.925161f, -2.89128f, 
		2.16009f, 0.101473f, -2.88739f, 2.16011f, 0.687949f, -2.92190f, 
		2.16011f, 0.687949f, -2.92190f, 2.16011f, 0.687949f, -2.92190f, 
		2.16028f, 0.951193f, -2.81465f, 2.16050f, 0.695333f, -3.04370f, 
		2.16054f, 0.896425f, -2.93959f, 2.16076f, 0.804014f, -2.88447f, 
		2.16082f, 0.808459f, -2.86488f, 2.16084f, 0.721995f, -2.88440f, 
		2.16084f, 0.721995f, -2.88440f, 2.16084f, 0.910845f, -2.92698f, 
		2.16107f, 0.611581f, -2.98942f, 2.16110f, -0.860587f, -3.06633f, 
		2.16110f, -0.860587f, -3.06633f, 2.16121f, 0.840982f, -2.94353f, 
		2.16125f, 0.855779f, -2.82827f, 2.16130f, 0.866412f, -2.82633f, 
		2.16130f, 0.866412f, -2.82633f, 2.16130f, 0.866412f, -2.82633f, 
		2.16136f, 0.880730f, -2.94619f, 2.16144f, 0.917285f, -2.91712f, 
		2.16147f, 0.833402f, -2.83610f, 2.16161f, 0.735674f, -2.83535f, 
		2.16165f, 0.875191f, -2.83021f, 2.16170f, 0.865958f, -2.82873f, 
		2.16170f, 0.865958f, -2.82873f, 2.16170f, 0.865958f, -2.82873f, 
		2.16183f, 0.719293f, -2.88447f, 2.16192f, 1.08841f, -3.04127f, 
		2.16194f, 0.346629f, -3.05708f, 2.16200f, 0.588357f, -3.06072f, 
		2.16201f, 0.724114f, -2.88234f, 2.16204f, 0.721166f, -2.88303f, 
		2.16204f, 0.721166f, -2.88303f, 2.16208f, 0.903247f, -2.93389f, 
		2.16216f, 0.586013f, -2.98906f, 2.16216f, 0.586013f, -2.98906f, 
		2.16216f, 0.586013f, -2.98906f, 2.16266f, 0.853899f, -2.82274f, 
		2.16267f, 0.546809f, -2.94711f, 2.16273f, 0.569345f, -2.97356f, 
		2.16294f, 0.663537f, -2.93064f, 2.16302f, 0.00217600f, -3.02365f, 
		2.16302f, 0.00217600f, -3.02365f, 2.16312f, 0.0593230f, -3.04163f, 
		2.16330f, 0.805628f, -2.89686f, 2.16346f, -0.398403f, -2.81810f, 
		2.16350f, 0.655490f, -3.04305f, 2.16365f, -0.494578f, -2.86060f, 
		2.16365f, -0.494578f, -2.86060f, 2.16365f, -0.494578f, -2.86060f, 
		2.16389f, 0.145656f, -2.88216f, 2.16404f, 0.110285f, -3.03446f, 
		2.16404f, 0.892526f, -2.83558f, 2.16406f, 0.921438f, -2.90347f, 
		2.16412f, 0.824834f, -2.81697f, 2.16412f, 0.824834f, -2.81697f, 
		2.16412f, 0.824834f, -2.81697f, 2.16412f, 0.824834f, -2.81697f, 
		2.16412f, 0.824834f, -2.81697f, 2.16413f, 0.901202f, -2.84146f, 
		2.16435f, -0.663160f, -2.82252f, 2.16435f, -0.663160f, -2.82252f, 
		2.16467f, 0.828052f, -2.84136f, 2.16469f, 0.823282f, -2.93013f, 
		2.16472f, -0.582902f, -2.81298f, 2.16485f, 0.902126f, -2.81817f, 
		2.16503f, 0.853505f, -2.94589f, 2.16509f, 0.806934f, -2.87629f, 
		2.16512f, 0.757491f, -2.82781f, 2.16512f, 0.757491f, -2.82781f, 
		2.16512f, 0.757491f, -2.82781f, 2.16512f, 0.757491f, -2.82781f, 
		2.16512f, 0.757491f, -2.82781f, 2.16529f, 0.815461f, -2.92015f, 
		2.16532f, 0.818587f, -2.85137f, 2.16534f, 0.980681f, -3.18044f, 
		2.16542f, 0.911180f, -2.85271f, 2.16563f, 0.656799f, -2.87025f, 
		2.16604f, 0.871120f, -2.82979f, 2.16620f, 0.777242f, -2.90170f, 
		2.16620f, 0.777242f, -2.90170f, 2.16620f, 0.777242f, -2.90170f, 
		2.16633f, 0.000785000f, -3.01145f, 2.16633f, 0.000785000f, -3.01145f, 
		2.16645f, 0.150414f, -3.03060f, 2.16647f, 0.753209f, -3.03570f, 
		2.16660f, 0.389756f, -3.06360f, 2.16663f, 0.858687f, -2.83005f, 
		2.16674f, 0.841131f, -2.83478f, 2.16678f, 0.834884f, -2.93788f, 
		2.16681f, 0.877487f, -2.82653f, 2.16688f, 0.776693f, -2.90200f, 
		2.16688f, 0.776693f, -2.90200f, 2.16704f, 0.849816f, -2.82454f, 
		2.16720f, 0.621600f, -3.04696f, 2.16734f, 0.561840f, -3.06861f, 
		2.16755f, 0.455956f, -2.90453f, 2.16765f, 0.775155f, -2.82012f, 
		2.16765f, 0.775155f, -2.82012f, 2.16765f, 0.775155f, -2.82012f, 
		2.16766f, -0.779381f, -2.80645f, 2.16766f, -0.779381f, -2.80645f, 
		2.16766f, -0.779381f, -2.80645f, 2.16768f, 0.730680f, -2.92598f, 
		2.16772f, 0.865169f, -2.82837f, 2.16785f, 0.869294f, -2.94531f, 
		2.16796f, 0.864708f, -2.83203f, 2.16798f, 0.920360f, -2.87593f, 
		2.16799f, 0.761676f, -3.10849f, 2.16804f, 0.883040f, -2.94224f, 
		2.16809f, 0.984739f, -3.18920f, 2.16842f, 0.916128f, -2.86384f, 
		2.16872f, 0.921117f, -2.88393f, 2.16924f, 0.675205f, -2.95802f, 
		2.16934f, 0.781362f, -2.86872f, 2.16934f, 0.781362f, -2.86872f, 
		2.16934f, 0.781362f, -2.86872f, 2.16940f, 0.712179f, -2.92586f, 
		2.16962f, 0.891659f, -2.93748f, 2.16983f, 0.881088f, -2.83402f, 
		2.16984f, 0.733488f, -2.87359f, 2.16984f, 0.733488f, -2.87359f, 
		2.16984f, 0.733488f, -2.87359f, 2.16984f, 0.916853f, -2.90801f, 
		2.16985f, 0.911028f, -2.91931f, 2.16989f, 0.974812f, -2.82660f, 
		2.17001f, 1.04595f, -3.13537f, 2.17005f, 0.811909f, -2.90757f, 
		2.17011f, 0.905668f, -2.84990f, 2.17041f, 0.196471f, -2.88079f, 
		2.17045f, 0.849757f, -2.83388f, 2.17072f, 0.198950f, -3.03120f, 
		2.17078f, 0.859535f, -2.94359f, 2.17089f, 0.815106f, -2.86228f, 
		2.17093f, 0.680112f, -2.89376f, 2.17093f, 0.680112f, -2.89376f, 
		2.17101f, -0.340610f, -2.88301f, 2.17101f, -0.340610f, -2.88301f, 
		2.17101f, -0.340610f, -2.88301f, 2.17103f, 0.747571f, -2.87055f, 
		2.17103f, 0.747571f, -2.87055f, 2.17110f, 0.848065f, -2.94112f, 
		2.17110f, 0.824572f, -2.84940f, 2.17112f, -0.659650f, -2.80434f, 
		2.17113f, -0.745623f, -2.81069f, 2.17113f, -0.745623f, -2.81069f, 
		2.17125f, 0.643385f, -2.98973f, 2.17125f, 0.643385f, -2.98973f, 
		2.17125f, 0.643385f, -2.98973f, 2.17127f, 0.680756f, -2.89328f, 
		2.17131f, 0.919195f, -2.89579f, 2.17132f, 0.809588f, -2.89423f, 
		2.17137f, -0.586971f, -2.85328f, 2.17144f, 0.880092f, -2.82758f, 
		2.17147f, 0.721685f, -2.92483f, 2.17154f, -0.820676f, -3.10830f, 
		2.17154f, -0.820676f, -3.10830f, 2.17172f, 0.432601f, -3.06933f, 
		2.17179f, 0.826250f, -2.92762f, 2.17180f, -0.277997f, -2.90182f, 
		2.17180f, -0.277997f, -2.90182f, 2.17180f, -0.277997f, -2.90182f, 
		2.17180f, -0.277997f, -2.90182f, 2.17207f, -0.487932f, -2.81145f, 
		2.17214f, 0.814052f, -2.81754f, 2.17214f, 0.814052f, -2.81754f, 
		2.17214f, 0.814052f, -2.81754f, 2.17249f, 0.811695f, -2.87431f, 
		2.17260f, -0.860239f, -3.10913f, 2.17260f, -0.860239f, -3.10913f, 
		2.17260f, -0.860239f, -3.10913f, 2.17265f, -0.371308f, -2.87583f, 
		2.17265f, -0.371308f, -2.87583f, 2.17265f, -0.371308f, -2.87583f, 
		2.17268f, 0.673241f, -2.97974f, 2.17268f, 0.673241f, -2.97974f, 
		2.17268f, 0.673241f, -2.97974f, 2.17276f, 0.902877f, -2.92657f, 
		2.17276f, 0.696346f, -3.03515f, 2.17298f, -0.871814f, -2.81094f, 
		2.17301f, 0.845201f, -2.82690f, 2.17301f, 1.05354f, -3.14169f, 
		2.17304f, 0.727591f, -2.90894f, 2.17304f, 0.727591f, -2.90894f, 
		2.17304f, 0.727591f, -2.90894f, 2.17308f, 0.533331f, -3.08140f, 
		2.17323f, 0.655761f, -3.03495f, 2.17346f, 0.891436f, -2.84111f, 
		2.17352f, -0.766140f, -2.78216f, 2.17352f, -0.766140f, -2.78216f, 
		2.17352f, -0.766140f, -2.78216f, 2.17352f, -0.766140f, -2.78216f, 
		2.17352f, -0.766140f, -2.78216f, 2.17352f, -0.766140f, -2.78216f, 
		2.17354f, 0.935445f, -3.18594f, 2.17367f, 0.810710f, -2.88666f, 
		2.17380f, -0.213148f, -2.92312f, 2.17380f, -0.213148f, -2.92312f, 
		2.17389f, 0.734321f, -3.05280f, 2.17413f, 0.820062f, -2.91787f, 
		2.17420f, 0.724843f, -2.90956f, 2.17420f, 0.724843f, -2.90956f, 
		2.17444f, 0.251770f, -3.03166f, 2.17461f, 0.896531f, -2.93043f, 
		2.17476f, -0.791475f, -2.73054f, 2.17482f, 0.588609f, -3.05314f, 
		2.17492f, 0.726483f, -2.84577f, 2.17492f, 0.726788f, -2.90889f, 
		2.17492f, 0.726788f, -2.90889f, 2.17492f, 0.726788f, -2.90889f, 
		2.17502f, 0.729988f, -2.90874f, 2.17502f, 0.729988f, -2.90874f, 
		2.17503f, 0.910152f, -2.86150f, 2.17508f, 0.748325f, -3.12254f, 
		2.17522f, 0.840365f, -2.93502f, 2.17527f, 0.864007f, -2.83254f, 
		2.17533f, 0.878010f, -2.93907f, 2.17582f, -0.129522f, -2.94844f, 
		2.17582f, -0.129522f, -2.94844f, 2.17607f, 0.615208f, -2.99354f, 
		2.17612f, 0.830679f, -2.84819f, 2.17619f, 0.904511f, -2.85482f, 
		2.17631f, 0.906778f, -2.91808f, 2.17636f, 0.785770f, -2.81897f, 
		2.17636f, 0.785770f, -2.81897f, 2.17636f, 0.785770f, -2.81897f, 
		2.17647f, -0.403600f, -2.87412f, 2.17647f, -0.403600f, -2.87412f, 
		2.17647f, -0.403600f, -2.87412f, 2.17667f, 0.660693f, -2.89699f, 
		2.17667f, 0.482435f, -3.07751f, 2.17673f, 0.851765f, -2.83767f, 
		2.17673f, 0.937054f, -3.19500f, 2.17697f, 0.873168f, -2.83710f, 
		2.17701f, 0.801714f, -2.81757f, 2.17701f, 0.801714f, -2.81757f, 
		2.17701f, 0.801714f, -2.81757f, 2.17701f, 0.801714f, -2.81757f, 
		2.17701f, 0.801714f, -2.81757f, 2.17708f, 0.255955f, -2.88106f, 
		2.17713f, 0.912231f, -2.90661f, 2.17720f, 0.821469f, -2.86014f, 
		2.17723f, -0.822030f, -2.67167f, 2.17723f, -0.822030f, -2.67167f, 
		2.17737f, 0.831773f, -2.92743f, 2.17739f, 0.840585f, -2.84254f, 
		2.17740f, 0.502145f, -2.90729f, 2.17740f, 0.882000f, -2.82918f, 
		2.17744f, 0.800279f, -3.14757f, 2.17746f, 0.913685f, -2.87449f, 
		2.17755f, 1.06076f, -2.93169f, 2.17761f, -0.664566f, -2.84465f, 
		2.17768f, 0.300904f, -3.03415f, 2.17781f, 0.621985f, -3.03823f, 
		2.17796f, 0.863544f, -2.83714f, 2.17810f, -0.738566f, -2.79125f, 
		2.17810f, -0.738566f, -2.79125f, 2.17810f, -0.738566f, -2.79125f, 
		2.17824f, 0.918471f, -2.82275f, 2.17824f, 0.918471f, -2.82275f, 
		2.17828f, 0.896153f, -2.84866f, 2.17830f, -0.0365040f, -2.98240f, 
		2.17830f, -0.0365040f, -2.98240f, 2.17830f, -0.0365040f, -2.98240f, 
		2.17839f, 0.862034f, -2.93848f, 2.17912f, 0.819337f, -2.90821f, 
		2.17917f, 0.718739f, -3.05807f, 2.17917f, 0.718739f, -3.05807f, 
		2.17918f, 0.891634f, -3.18514f, 2.17925f, -0.00501500f, -2.99465f, 
		2.17925f, -0.00501500f, -2.99465f, 2.17925f, -0.00501500f, -2.99465f, 
		2.17925f, -0.00501500f, -2.99465f, 2.17931f, 0.816185f, -2.89910f, 
		2.17931f, 0.917716f, -2.82484f, 2.17943f, 0.0537060f, -3.02438f, 
		2.17957f, 0.587786f, -2.99283f, 2.17957f, 0.587786f, -2.99283f, 
		2.17960f, 0.913240f, -2.88380f, 2.17970f, 0.917297f, -2.82622f, 
		2.17970f, 0.917297f, -2.82622f, 2.17970f, 0.917297f, -2.82622f, 
		2.17981f, 0.817656f, -2.87301f, 2.17983f, 0.832023f, -3.16536f, 
		2.17998f, 0.873619f, -2.93621f, 2.18003f, 0.824892f, -2.91633f, 
		2.18015f, 0.855165f, -3.17457f, 2.18021f, -0.579412f, -2.80311f, 
		2.18032f, -0.193057f, -2.85551f, 2.18032f, -0.193057f, -2.85551f, 
		2.18048f, 0.886843f, -2.93122f, 2.18048f, 0.652114f, -3.00411f, 
		2.18078f, 0.879671f, -2.84201f, 2.18084f, 0.794573f, -3.15456f, 
		2.18089f, 0.850099f, -2.93421f, 2.18100f, 0.347275f, -3.03967f, 
		2.18103f, 0.690731f, -2.91377f, 2.18103f, 0.690731f, -2.91377f, 
		2.18103f, 0.690731f, -2.91377f, 2.18107f, 0.912132f, -2.89316f, 
		2.18128f, 1.00626f, -2.85233f, 2.18151f, -0.00836300f, -2.89066f, 
		2.18151f, -0.00836300f, -2.89066f, 2.18151f, -0.00836300f, -2.89066f, 
		2.18152f, -0.865733f, -2.66855f, 2.18152f, -0.865733f, -2.66855f, 
		2.18153f, 0.758549f, -2.83683f, 2.18159f, 0.655411f, -3.02232f, 
		2.18166f, 0.906495f, -2.86617f, 2.18173f, -0.261002f, -2.84183f, 
		2.18173f, -0.261002f, -2.84183f, 2.18186f, -0.843309f, -2.66903f, 
		2.18189f, -0.324491f, -2.82998f, 2.18189f, -0.324491f, -2.82998f, 
		2.18198f, 0.888532f, -2.84765f, 2.18200f, -0.822993f, -2.85500f, 
		2.18202f, -0.360118f, -2.82363f, 2.18202f, -0.360118f, -2.82363f, 
		2.18204f, 1.07017f, -3.03058f, 2.18206f, 0.897452f, -2.92159f, 
		2.18225f, 0.107483f, -3.01408f, 2.18264f, 0.818016f, -2.88545f, 
		2.18266f, 0.310985f, -2.88324f, 2.18268f, 0.890872f, -3.19416f, 
		2.18285f, 0.562307f, -3.05725f, 2.18294f, 0.926595f, -2.82689f, 
		2.18294f, 0.926595f, -2.82689f, 2.18294f, 0.926595f, -2.82689f, 
		2.18294f, 0.926595f, -2.82689f, 2.18314f, 0.828453f, -2.85919f, 
		2.18315f, 0.835816f, -2.85189f, 2.18326f, 0.690938f, -2.99752f, 
		2.18336f, 0.828035f, -3.17331f, 2.18367f, 0.0263120f, -2.90100f, 
		2.18370f, 0.852429f, -3.18301f, 2.18377f, -0.105433f, -2.87017f, 
		2.18377f, -0.105433f, -2.87017f, 2.18384f, 0.927241f, -2.83199f, 
		2.18384f, 0.927241f, -2.83199f, 2.18384f, 0.927241f, -2.83199f, 
		2.18408f, 0.0572400f, -2.90429f, 2.18421f, 0.680743f, -2.92817f, 
		2.18431f, 0.862943f, -2.83785f, 2.18456f, 0.148510f, -3.01028f, 
		2.18458f, 0.869076f, -2.84381f, 2.18465f, 0.698901f, -3.02039f, 
		2.18478f, 0.902726f, -2.91036f, 2.18480f, 0.898376f, -2.85937f, 
		2.18500f, -0.493302f, -2.86697f, 2.18500f, -0.493302f, -2.86697f, 
		2.18510f, 0.847222f, -2.84740f, 2.18524f, 0.589195f, -3.04328f, 
		2.18527f, 0.390520f, -3.04656f, 2.18533f, 0.619821f, -3.00818f, 
		2.18539f, 0.824033f, -2.90362f, 2.18542f, 0.906865f, -2.87833f, 
		2.18550f, 0.905552f, -2.90133f, 2.18550f, -0.394942f, -2.82165f, 
		2.18550f, -0.394942f, -2.82165f, 2.18551f, 0.830250f, -2.91497f, 
		2.18553f, 0.840213f, -2.92429f, 2.18560f, 0.860574f, -2.93109f, 
		2.18579f, -0.861967f, -2.85997f, 2.18579f, -0.861967f, -2.85997f, 
		2.18583f, 0.824897f, -2.87150f, 2.18596f, -0.108424f, -2.82494f, 
		2.18596f, -0.108424f, -2.82494f, 2.18596f, -0.108424f, -2.82494f, 
		2.18596f, -0.108424f, -2.82494f, 2.18596f, -0.108424f, -2.82494f, 
		2.18601f, 0.622027f, -3.02588f, 2.18626f, 0.875075f, -2.92959f, 
		2.18634f, 0.709364f, -2.86438f, 2.18639f, -0.747864f, -2.83576f, 
		2.18665f, 0.857751f, -2.84611f, 2.18670f, -0.655929f, -2.79455f, 
		2.18672f, 0.880766f, -2.84932f, 2.18730f, 0.362644f, -2.88717f, 
		2.18731f, 0.760363f, -3.02255f, 2.18739f, -0.100751f, -2.82741f, 
		2.18751f, 0.824013f, -2.89387f, 2.18770f, 0.890047f, -2.92005f, 
		2.18778f, -0.100755f, -2.82485f, 2.18784f, 0.834340f, -2.83443f, 
		2.18790f, 0.992081f, -2.87165f, 2.18790f, 0.992081f, -2.87165f, 
		2.18797f, -0.336921f, -2.87345f, 2.18797f, -0.336921f, -2.87345f, 
		2.18797f, -0.336921f, -2.87345f, 2.18798f, -0.110285f, -2.81872f, 
		2.18798f, -0.110285f, -2.81872f, 2.18798f, -0.110285f, -2.81872f, 
		2.18800f, 0.0992740f, -2.89853f, 2.18810f, 0.851800f, -2.92661f, 
		2.18810f, -0.110733f, -2.83025f, 2.18810f, -0.110733f, -2.83025f, 
		2.18810f, -0.110733f, -2.83025f, 2.18810f, -0.110733f, -2.83025f, 
		2.18841f, 0.577339f, -2.97766f, 2.18853f, -0.367758f, -2.86655f, 
		2.18853f, -0.367758f, -2.86655f, 2.18853f, -0.367758f, -2.86655f, 
		2.18870f, -0.113911f, -2.82038f, 2.18870f, -0.113911f, -2.82038f, 
		2.18870f, -0.113911f, -2.82038f, 2.18870f, -0.113911f, -2.82038f, 
		2.18874f, 0.887912f, -2.83385f, 2.18880f, -0.157337f, -2.81354f, 
		2.18880f, -0.157337f, -2.81354f, 2.18880f, -0.157337f, -2.81354f, 
		2.18880f, -0.157337f, -2.81354f, 2.18889f, 0.197653f, -3.01061f, 
		2.18893f, -0.780515f, -2.83586f, 2.18893f, -0.780515f, -2.83586f, 
		2.18893f, -0.780515f, -2.83586f, 2.18921f, 0.936859f, -2.83553f, 
		2.18932f, 0.903227f, -2.89092f, 2.18936f, 1.08265f, -3.02978f, 
		2.18941f, 0.845379f, -2.85451f, 2.18951f, 0.899292f, -2.87120f, 
		2.18979f, -0.153401f, -2.81557f, 2.18979f, -0.153401f, -2.81557f, 
		2.18979f, -0.153401f, -2.81557f, 2.18989f, 0.433806f, -3.05350f, 
		2.19002f, 0.862089f, -2.84124f, 2.19016f, 0.887372f, -2.85787f, 
		2.19017f, -0.160553f, -2.82105f, 2.19017f, -0.160553f, -2.82105f, 
		2.19017f, -0.160553f, -2.82105f, 2.19017f, -0.160553f, -2.82105f, 
		2.19024f, 0.839033f, -2.86064f, 2.19027f, 0.831491f, -2.90539f, 
		2.19042f, -0.0928816f, -2.82488f, 2.19042f, -0.0928816f, -2.82488f, 
		2.19042f, -0.0928816f, -2.82488f, 2.19043f, 0.984105f, -3.16832f, 
		2.19045f, 0.893034f, -2.91155f, 2.19049f, 0.868740f, -2.85080f, 
		2.19051f, -0.273487f, -2.88984f, 2.19051f, -0.273487f, -2.88984f, 
		2.19051f, -0.273487f, -2.88984f, 2.19051f, -0.273487f, -2.88984f, 
		2.19054f, 0.764181f, -3.09863f, 2.19059f, 0.827577f, -2.88346f, 
		2.19061f, 0.898007f, -2.90291f, 2.19087f, 0.699539f, -2.96849f, 
		2.19109f, -0.101239f, -2.83291f, 2.19109f, -0.101239f, -2.83291f, 
		2.19112f, 0.838204f, -2.91322f, 2.19114f, 0.832715f, -2.87017f, 
		2.19127f, 0.868409f, -2.92418f, 2.19139f, 0.589635f, -3.00894f, 
		2.19139f, 0.589635f, -3.00894f, 2.19139f, 0.589635f, -3.00894f, 
		2.19139f, 0.589635f, -3.00894f, 2.19139f, 0.589635f, -3.00894f, 
		2.19140f, -0.154665f, -2.82175f, 2.19140f, -0.154665f, -2.82175f, 
		2.19140f, -0.154665f, -2.82175f, 2.19140f, -0.154665f, -2.82175f, 
		2.19140f, -0.154665f, -2.82175f, 2.19140f, -0.154665f, -2.82175f, 
		2.19142f, -0.0864670f, -2.82268f, 2.19142f, -0.0864670f, -2.82268f, 
		2.19142f, -0.0864670f, -2.82268f, 2.19142f, -0.0864670f, -2.82268f, 
		2.19143f, 0.143605f, -2.89406f, 2.19153f, 0.875371f, -2.85422f, 
		2.19154f, 0.898980f, -2.88054f, 2.19157f, 0.829792f, -2.89648f, 
		2.19166f, -0.116600f, -2.82379f, 2.19166f, -0.116600f, -2.82379f, 
		2.19166f, -0.116600f, -2.82379f, 2.19174f, 1.07045f, -2.92293f, 
		2.19181f, -0.765421f, -2.76876f, 2.19181f, -0.765421f, -2.76876f, 
		2.19181f, -0.765421f, -2.76876f, 2.19181f, -0.765421f, -2.76876f, 
		2.19181f, -0.765421f, -2.76876f, 2.19189f, 0.847066f, -2.91876f, 
		2.19198f, 0.857221f, -2.85395f, 2.19211f, -0.399994f, -2.86491f, 
		2.19211f, -0.399994f, -2.86491f, 2.19211f, -0.399994f, -2.86491f, 
		2.19242f, 0.251520f, -3.01146f, 2.19257f, -0.109968f, -2.83143f, 
		2.19257f, -0.109968f, -2.83143f, 2.19257f, -0.109968f, -2.83143f, 
		2.19271f, -0.163687f, -2.81782f, 2.19271f, -0.163687f, -2.81782f, 
		2.19285f, 0.536308f, -3.06196f, 2.19292f, 0.878514f, -2.91861f, 
		2.19294f, 0.858592f, -2.92078f, 2.19300f, -0.161266f, -2.81077f, 
		2.19300f, -0.161266f, -2.81077f, 2.19300f, -0.161266f, -2.81077f, 
		2.19302f, -0.0927140f, -2.83125f, 2.19302f, -0.0927140f, -2.83125f, 
		2.19311f, -0.863857f, -2.73536f, 2.19317f, -0.871814f, -2.84542f, 
		2.19323f, 1.04617f, -3.12157f, 2.19346f, -0.484337f, -2.81511f, 
		2.19346f, -0.484337f, -2.81511f, 2.19350f, 0.0524980f, -3.00368f, 
		2.19352f, 0.589864f, -3.02889f, 2.19353f, -0.109251f, -2.81374f, 
		2.19366f, -0.152744f, -2.80731f, 2.19366f, -0.152744f, -2.80731f, 
		2.19366f, -0.152744f, -2.80731f, 2.19366f, -0.152744f, -2.80731f, 
		2.19375f, -0.207892f, -2.90949f, 2.19375f, -0.207892f, -2.90949f, 
		2.19377f, 0.538281f, -2.91686f, 2.19380f, 0.887839f, -2.86667f, 
		2.19387f, -0.586054f, -2.86088f, 2.19387f, -0.586054f, -2.86088f, 
		2.19403f, -0.149083f, -2.81215f, 2.19403f, -0.149083f, -2.81215f, 
		2.19403f, -0.149083f, -2.81215f, 2.19422f, -0.111949f, -2.81467f, 
		2.19431f, 0.883352f, -2.91279f, 2.19445f, -0.166151f, -2.83078f, 
		2.19445f, -0.166151f, -2.83078f, 2.19445f, -0.166151f, -2.83078f, 
		2.19445f, -0.166151f, -2.83078f, 2.19453f, 0.988347f, -3.17643f, 
		2.19478f, -0.362596f, -2.84361f, 2.19478f, -0.362596f, -2.84361f, 
		2.19485f, 0.484900f, -3.06113f, 2.19485f, 0.841415f, -2.86928f, 
		2.19487f, -0.329520f, -2.84982f, 2.19487f, -0.329520f, -2.84982f, 
		2.19487f, -0.734983f, -2.78065f, 2.19487f, -0.734983f, -2.78065f, 
		2.19487f, -0.734983f, -2.78065f, 2.19506f, 0.890820f, -2.90171f, 
		2.19511f, 0.408694f, -2.89029f, 2.19516f, -0.164916f, -2.81583f, 
		2.19516f, -0.164916f, -2.81583f, 2.19516f, -0.164916f, -2.81583f, 
		2.19516f, -0.164916f, -2.81583f, 2.19516f, -0.164916f, -2.81583f, 
		2.19523f, -0.0878940f, -2.81348f, 2.19526f, 0.890767f, -2.87620f, 
		2.19529f, 0.878729f, -2.86293f, 2.19540f, 0.301678f, -3.01423f, 
		2.19553f, 0.850663f, -2.86259f, 2.19565f, 0.842389f, -2.90605f, 
		2.19572f, 0.892825f, -2.88914f, 2.19574f, -0.0738620f, -2.82001f, 
		2.19574f, -0.0738620f, -2.82001f, 2.19574f, -0.0738620f, -2.82001f, 
		2.19575f, -0.0923704f, -2.81497f, 2.19579f, 0.563149f, -3.04306f, 
		2.19630f, -0.162225f, -2.83211f, 2.19630f, -0.162225f, -2.83211f, 
		2.19630f, -0.162225f, -2.83211f, 2.19630f, -0.162225f, -2.83211f, 
		2.19633f, -0.102718f, -2.83273f, 2.19633f, -0.102718f, -2.83273f, 
		2.19633f, -0.102718f, -2.83273f, 2.19641f, 0.852729f, -2.91232f, 
		2.19658f, 0.838546f, -2.88197f, 2.19665f, 0.860016f, -2.86241f, 
		2.19671f, -0.168226f, -2.83820f, 2.19671f, -0.168226f, -2.83820f, 
		2.19671f, -0.168226f, -2.83820f, 2.19671f, -0.168226f, -2.83820f, 
		2.19671f, -0.168226f, -2.83820f, 2.19671f, -0.168226f, -2.83820f, 
		2.19673f, -0.114131f, -2.82627f, 2.19673f, -0.114131f, -2.82627f, 
		2.19673f, -0.114131f, -2.82627f, 2.19673f, -0.114131f, -2.82627f, 
		2.19681f, -0.149314f, -2.81915f, 2.19683f, 0.741461f, -3.03455f, 
		2.19685f, 0.869444f, -2.86242f, 2.19686f, -0.171467f, -2.82876f, 
		2.19686f, -0.171467f, -2.82876f, 2.19686f, -0.171467f, -2.82876f, 
		2.19686f, -0.171467f, -2.82876f, 2.19686f, -0.171467f, -2.82876f, 
		2.19690f, -0.265390f, -2.86232f, 2.19690f, -0.265390f, -2.86232f, 
		2.19700f, 0.839702f, -2.89467f, 2.19703f, 0.757525f, -2.85499f, 
		2.19720f, -0.155914f, -2.82440f, 2.19720f, -0.155914f, -2.82440f, 
		2.19720f, -0.155914f, -2.82440f, 2.19725f, 0.696753f, -2.88953f, 
		2.19728f, -0.803607f, -2.72081f, 2.19728f, -0.803607f, -2.72081f, 
		2.19741f, 0.348573f, -3.02085f, 2.19743f, -0.160623f, -2.82424f, 
		2.19743f, -0.160623f, -2.82424f, 2.19743f, -0.160623f, -2.82424f, 
		2.19743f, -0.160623f, -2.82424f, 2.19748f, 1.05377f, -3.12714f, 
		2.19755f, 0.194446f, -2.89307f, 2.19762f, -0.157121f, -2.80509f, 
		2.19762f, -0.157121f, -2.80509f, 2.19764f, 0.862871f, -2.91209f, 
		2.19776f, -0.0757211f, -2.82667f, 2.19776f, -0.0757211f, -2.82667f, 
		2.19777f, 0.873487f, -2.90946f, 2.19783f, -0.172438f, -2.83562f, 
		2.19783f, -0.172438f, -2.83562f, 2.19783f, -0.172438f, -2.83562f, 
		2.19791f, 0.924626f, -2.86769f, 2.19791f, 0.924626f, -2.86769f, 
		2.19802f, -0.395831f, -2.84163f, 2.19802f, -0.395831f, -2.84163f, 
		2.19831f, 0.568457f, -2.95812f, 2.19831f, 0.568457f, -2.95812f, 
		2.19831f, 0.568457f, -2.95812f, 2.19832f, -0.114328f, -2.81608f, 
		2.19832f, -0.114328f, -2.81608f, 2.19837f, 0.937612f, -3.17333f, 
		2.19839f, -0.198067f, -2.87785f, 2.19839f, -0.198067f, -2.87785f, 
		2.19856f, -0.104597f, -2.81105f, 2.19857f, 0.881911f, -2.87524f, 
		2.19859f, -0.163920f, -2.82399f, 2.19859f, -0.163920f, -2.82399f, 
		2.19859f, -0.163920f, -2.82399f, 2.19859f, -0.163920f, -2.82399f, 
		2.19859f, -0.163920f, -2.82399f, 2.19859f, -0.163920f, -2.82399f, 
		2.19862f, -0.162755f, -2.83817f, 2.19862f, -0.162755f, -2.83817f, 
		2.19862f, -0.162755f, -2.83817f, 2.19862f, -0.162755f, -2.83817f, 
		2.19862f, -0.162755f, -2.83817f, 2.19885f, 0.750967f, -3.11215f, 
		2.19899f, 0.881062f, -2.89962f, 2.19900f, 0.104422f, -2.99242f, 
		2.19924f, -0.0750660f, -2.81129f, 2.19935f, 0.850385f, -2.87477f, 
		2.19947f, -0.174627f, -2.83376f, 2.19947f, -0.174627f, -2.83376f, 
		2.19947f, -0.174627f, -2.83376f, 2.19947f, -0.174627f, -2.83376f, 
		2.19947f, -0.174627f, -2.83376f, 2.19971f, 0.882339f, -2.88694f, 
		2.19972f, 0.724093f, -2.99429f, 2.19973f, 0.869398f, -2.87154f, 
		2.19979f, 0.851447f, -2.90012f, 2.19995f, -0.168306f, -2.82291f, 
		2.20008f, -0.122467f, -2.93035f, 2.20008f, -0.122467f, -2.93035f, 
		2.20008f, -0.122467f, -2.93035f, 2.20008f, -0.122467f, -2.93035f, 
		2.20011f, -0.145343f, -2.80791f, 2.20011f, -0.145343f, -2.80791f, 
		2.20011f, -0.145343f, -2.80791f, 2.20021f, -0.0940290f, -2.83192f, 
		2.20021f, -0.0940290f, -2.83192f, 2.20021f, -0.0940290f, -2.83192f, 
		2.20021f, -0.0940290f, -2.83192f, 2.20021f, -0.0940290f, -2.83192f, 
		2.20021f, -0.0940290f, -2.83192f, 2.20025f, -0.489634f, -2.85816f, 
		2.20025f, -0.489634f, -2.85816f, 2.20034f, -0.159583f, -2.82809f, 
		2.20034f, -0.159583f, -2.82809f, 2.20034f, -0.159583f, -2.82809f, 
		2.20034f, 0.873781f, -2.90062f, 2.20047f, 0.859863f, -2.87456f, 
		2.20048f, -0.0960388f, -2.80960f, 2.20048f, -0.0960388f, -2.80960f, 
		2.20048f, -0.0960388f, -2.80960f, 2.20051f, -0.163534f, -2.81894f, 
		2.20061f, 0.861970f, -2.85317f, 2.20068f, 0.850180f, -2.88795f, 
		2.20085f, -0.663733f, -2.85351f, 2.20085f, -0.663733f, -2.85351f, 
		2.20090f, 0.817082f, -2.84819f, 2.20092f, -0.113397f, -2.81890f, 
		2.20112f, 0.875046f, -2.89075f, 2.20116f, 0.862864f, -2.89986f, 
		2.20147f, 0.856766f, -2.88409f, 2.20155f, -0.170300f, -2.82344f, 
		2.20158f, 0.722962f, -2.95733f, 2.20159f, 0.951855f, -2.85539f, 
		2.20169f, 0.146302f, -2.98822f, 2.20171f, 0.869272f, -2.88092f, 
		2.20173f, -0.0898490f, -2.80785f, 2.20173f, -0.0898490f, -2.80785f, 
		2.20173f, -0.0898490f, -2.80785f, 2.20173f, -0.0898490f, -2.80785f, 
		2.20199f, 0.862953f, -2.89041f, 2.20208f, -0.575733f, -2.80695f, 
		2.20208f, -0.575733f, -2.80695f, 2.20237f, -0.152248f, -2.82276f, 
		2.20237f, -0.152248f, -2.82276f, 2.20237f, -0.152248f, -2.82276f, 
		2.20237f, -0.152248f, -2.82276f, 2.20277f, 0.803076f, -3.13701f, 
		2.20290f, 0.0239700f, -2.92075f, 2.20291f, 0.939338f, -3.18171f, 
		2.20291f, -0.148493f, -2.80059f, 2.20291f, -0.148493f, -2.80059f, 
		2.20294f, -0.169611f, -2.84188f, 2.20294f, -0.169611f, -2.84188f, 
		2.20294f, -0.169611f, -2.84188f, 2.20294f, -0.169611f, -2.84188f, 
		2.20294f, -0.169611f, -2.84188f, 2.20294f, -0.169611f, -2.84188f, 
		2.20299f, -0.105851f, -2.82684f, 2.20325f, 0.253891f, -2.89249f, 
		2.20333f, 0.774027f, -3.01255f, 2.20343f, 0.790981f, -2.84973f, 
		2.20349f, -0.0583630f, -2.81867f, 2.20349f, -0.0583630f, -2.81867f, 
		2.20349f, -0.0583630f, -2.81867f, 2.20367f, -0.154214f, -2.80186f, 
		2.20367f, -0.154214f, -2.80186f, 2.20370f, -0.164919f, -2.84118f, 
		2.20370f, -0.164919f, -2.84118f, 2.20372f, 0.0569890f, -2.92373f, 
		2.20375f, -0.145303f, -2.81509f, 2.20391f, 0.453681f, -2.89359f, 
		2.20391f, 0.453681f, -2.89359f, 2.20391f, 0.453681f, -2.89359f, 
		2.20393f, -0.106833f, -2.81255f, 2.20393f, -0.106833f, -2.81255f, 
		2.20393f, 0.703000f, -2.92045f, 2.20393f, 1.02137f, -2.85048f, 
		2.20393f, 1.02137f, -2.85048f, 2.20393f, 1.02137f, -2.85048f, 
		2.20403f, -0.159237f, -2.83488f, 2.20424f, -0.174188f, -2.83726f, 
		2.20424f, -0.174188f, -2.83726f, 2.20424f, -0.174188f, -2.83726f, 
		2.20441f, -0.110449f, -2.89375f, 2.20441f, -0.110449f, -2.89375f, 
		2.20501f, -0.157666f, -2.82257f, 2.20501f, -0.157666f, -2.82257f, 
		2.20501f, -0.157666f, -2.82257f, 2.20501f, -0.157666f, -2.82257f, 
		2.20543f, 0.576206f, -2.99514f, 2.20552f, -0.485082f, -2.83468f, 
		2.20552f, -0.485082f, -2.83468f, 2.20552f, -0.485082f, -2.83468f, 
		2.20553f, -0.0772380f, -2.82796f, 2.20553f, -0.0772380f, -2.82796f, 
		2.20559f, -0.0126380f, -2.91512f, 2.20559f, -0.0126380f, -2.91512f, 
		2.20559f, -0.0126380f, -2.91512f, 2.20576f, -0.857164f, -2.72604f, 
		2.20576f, -0.857164f, -2.72604f, 2.20576f, -0.834548f, -2.72604f, 
		2.20585f, 0.434588f, -3.03473f, 2.20590f, 0.835860f, -3.15345f, 
		2.20601f, -0.0769280f, -2.80655f, 2.20601f, -0.0769280f, -2.80655f, 
		2.20601f, -0.0769280f, -2.80655f, 2.20630f, 0.893730f, -2.86239f, 
		2.20630f, -0.143214f, -2.80411f, 2.20630f, -0.143214f, -2.80411f, 
		2.20630f, -0.143214f, -2.80411f, 2.20631f, -0.162889f, -2.81771f, 
		2.20631f, -0.162889f, -2.81771f, 2.20636f, -0.107057f, -2.81778f, 
		2.20636f, -0.107057f, -2.81778f, 2.20636f, -0.107057f, -2.81778f, 
		2.20650f, 0.195835f, -2.98805f, 2.20664f, -0.0592450f, -2.80964f, 
		2.20667f, -0.0593720f, -2.82548f, 2.20667f, -0.0593720f, -2.82548f, 
		2.20670f, 0.860025f, -3.16204f, 2.20673f, -0.161437f, -2.81691f, 
		2.20673f, -0.161437f, -2.81691f, 2.20673f, -0.161437f, -2.81691f, 
		2.20673f, -0.161437f, -2.81691f, 2.20726f, 0.0987930f, -2.91726f, 
		2.20754f, 0.797522f, -3.14342f, 2.20758f, -0.157963f, -2.82254f, 
		2.20758f, -0.157963f, -2.82254f, 2.20758f, -0.157963f, -2.82254f, 
		2.20765f, -0.0964280f, -2.82567f, 2.20771f, 0.893769f, -3.17093f, 
		2.20779f, 0.308919f, -2.89366f, 2.20782f, -0.153266f, -2.79945f, 
		2.20782f, -0.153266f, -2.79945f, 2.20782f, -0.153266f, -2.79945f, 
		2.20782f, -0.153266f, -2.79945f, 2.20799f, -0.0252830f, -2.95403f, 
		2.20799f, -0.0252830f, -2.95403f, 2.20799f, -0.0252830f, -2.95403f, 
		2.20799f, -0.0252830f, -2.95403f, 2.20809f, 0.0529310f, -2.97985f, 
		2.20836f, -0.168643f, -2.81799f, 2.20836f, -0.168643f, -2.81799f, 
		2.20836f, -0.168643f, -2.81799f, 2.20859f, -0.652856f, -2.79836f, 
		2.20859f, -0.652856f, -2.79836f, 2.20859f, -0.0952054f, -2.80956f, 
		2.20859f, -0.0952054f, -2.80956f, 2.20869f, 0.741725f, -2.88393f, 
		2.20872f, -0.148916f, -2.81955f, 2.20872f, -0.148916f, -2.81955f, 
		2.20879f, -0.162841f, -2.83910f, 2.20879f, -0.162841f, -2.83910f, 
		2.20879f, -0.162841f, -2.83910f, 2.20879f, -0.162841f, -2.83910f, 
		2.20879f, -0.162841f, -2.83910f, 2.20879f, -0.162841f, -2.83910f, 
		2.20889f, -0.147411f, -2.85401f, 2.20889f, -0.147411f, -2.85401f, 
		2.20889f, -0.147411f, -2.85401f, 2.20893f, 0.768652f, -3.08712f, 
		2.20939f, 0.739574f, -2.98716f, 2.20952f, -0.582078f, -2.85197f, 
		2.20952f, -0.582078f, -2.85197f, 2.20982f, -0.174079f, -2.83511f, 
		2.20982f, -0.174079f, -2.83511f, 2.20982f, -0.174079f, -2.83511f, 
		2.20982f, -0.174079f, -2.83511f, 2.20988f, -0.153202f, -2.85279f, 
		2.20988f, -0.153202f, -2.85279f, 2.20988f, -0.153202f, -2.85279f, 
		2.21004f, -0.157027f, -2.80683f, 2.21010f, 0.142890f, -2.91220f, 
		2.21010f, -0.168882f, -2.83991f, 2.21010f, -0.168882f, -2.83991f, 
		2.21010f, -0.168882f, -2.83991f, 2.21010f, -0.168882f, -2.83991f, 
		2.21025f, -0.143065f, -2.81095f, 2.21042f, -0.0986410f, -2.81598f, 
		2.21042f, -0.0986410f, -2.81598f, 2.21042f, -0.0986410f, -2.81598f, 
		2.21046f, -0.0419600f, -2.81686f, 2.21046f, -0.0419600f, -2.81686f, 
		2.21046f, -0.0419600f, -2.81686f, 2.21046f, -0.0419600f, -2.81686f, 
		2.21046f, -0.0419600f, -2.81686f, 2.21059f, 0.251013f, -2.98832f, 
		2.21084f, 0.832080f, -3.16075f, 2.21094f, -0.153325f, -2.85949f, 
		2.21094f, -0.153325f, -2.85949f, 2.21094f, -0.153325f, -2.85949f, 
		2.21095f, -0.148797f, -2.86129f, 2.21095f, -0.148797f, -2.86129f, 
		2.21095f, -0.148797f, -2.86129f, 2.21095f, -0.148797f, -2.86129f, 
		2.21095f, -0.148797f, -2.86129f, 2.21095f, -0.148797f, -2.86129f, 
		2.21120f, 0.485056f, -3.04218f, 2.21125f, 0.102564f, -2.96766f, 
		2.21169f, 0.857552f, -3.16981f, 2.21172f, -0.144056f, -2.85460f, 
		2.21172f, -0.144056f, -2.85460f, 2.21172f, -0.144056f, -2.85460f, 
		2.21172f, -0.144056f, -2.85460f, 2.21180f, 0.536171f, -3.04170f, 
		2.21186f, 0.565286f, -3.02109f, 2.21188f, 0.359995f, -2.89690f, 
		2.21197f, -0.139898f, -2.80092f, 2.21197f, -0.139898f, -2.80092f, 
		2.21198f, -0.156009f, -2.85825f, 2.21198f, -0.156009f, -2.85825f, 
		2.21198f, -0.156009f, -2.85825f, 2.21198f, -0.156009f, -2.85825f, 
		2.21200f, 0.727442f, -3.03558f, 2.21200f, 0.727442f, -3.03558f, 
		2.21210f, -0.162876f, -2.81381f, 2.21210f, -0.162876f, -2.81381f, 
		2.21236f, -0.0802036f, -2.82247f, 2.21238f, -0.157467f, -2.82943f, 
		2.21251f, -0.747913f, -2.84730f, 2.21251f, -0.747913f, -2.84730f, 
		2.21256f, -0.158217f, -2.81322f, 2.21256f, -0.158217f, -2.81322f, 
		2.21268f, -0.156701f, -2.80458f, 2.21269f, -0.169157f, -2.81503f, 
		2.21269f, -0.169157f, -2.81503f, 2.21275f, 0.893124f, -3.17918f, 
		2.21286f, -0.0442660f, -2.80639f, 2.21286f, -0.0442660f, -2.80639f, 
		2.21286f, -0.0442660f, -2.80639f, 2.21301f, -0.0796680f, -2.80769f, 
		2.21301f, -0.0796680f, -2.80769f, 2.21311f, -0.0627960f, -2.80532f, 
		2.21350f, 0.897791f, -2.90220f, 2.21350f, 0.897791f, -2.90220f, 
		2.21350f, 0.897791f, -2.90220f, 2.21382f, 0.145517f, -2.96246f, 
		2.21392f, -0.157966f, -2.81807f, 2.21392f, -0.157966f, -2.81807f, 
		2.21392f, -0.157966f, -2.81807f, 2.21392f, -0.157966f, -2.81807f, 
		2.21394f, 1.05161f, -3.01839f, 2.21398f, 1.02028f, -2.93720f, 
		2.21399f, -0.0630200f, -2.82717f, 2.21399f, -0.0630200f, -2.82717f, 
		2.21402f, -0.147496f, -2.84706f, 2.21402f, -0.147496f, -2.84706f, 
		2.21402f, -0.147496f, -2.84706f, 2.21402f, -0.147496f, -2.84706f, 
		2.21402f, -0.147496f, -2.84706f, 2.21402f, -0.147496f, -2.84706f, 
		2.21412f, -0.144237f, -2.86042f, 2.21412f, -0.144237f, -2.86042f, 
		2.21412f, -0.144237f, -2.86042f, 2.21412f, -0.144237f, -2.86042f, 
		2.21412f, -0.144237f, -2.86042f, 2.21416f, 0.302270f, -2.99048f, 
		2.21435f, -0.576795f, -2.82701f, 2.21439f, -0.141454f, -2.79580f, 
		2.21439f, -0.141454f, -2.79580f, 2.21445f, 0.777499f, -2.87891f, 
		2.21452f, 0.863254f, -2.87398f, 2.21456f, -0.153435f, -2.84646f, 
		2.21456f, -0.153435f, -2.84646f, 2.21458f, -0.0432940f, -2.82505f, 
		2.21458f, -0.0432940f, -2.82505f, 2.21460f, 0.0551960f, -2.95179f, 
		2.21460f, 0.0551960f, -2.95179f, 2.21460f, 0.0551960f, -2.95179f, 
		2.21482f, 0.0133670f, -2.95416f, 2.21482f, 0.0133670f, -2.95416f, 
		2.21511f, -0.171964f, -2.82323f, 2.21516f, -0.0816543f, -2.81336f, 
		2.21516f, -0.0816543f, -2.81336f, 2.21516f, -0.0816543f, -2.81336f, 
		2.21516f, -0.0816543f, -2.81336f, 2.21516f, -0.0816543f, -2.81336f, 
		2.21516f, -0.0816543f, -2.81336f, 2.21533f, -0.140365f, -2.80757f, 
		2.21551f, 0.193579f, -2.91080f, 2.21560f, 0.737517f, -2.91428f, 
		2.21587f, -0.153058f, -2.81590f, 2.21587f, -0.153058f, -2.81590f, 
		2.21587f, -0.153058f, -2.81590f, 2.21587f, -0.153058f, -2.81590f, 
		2.21626f, 0.758260f, -3.02618f, 2.21628f, -0.156943f, -2.81086f, 
		2.21628f, -0.156943f, -2.81086f, 2.21635f, -0.161534f, -2.83476f, 
		2.21635f, -0.161534f, -2.83476f, 2.21651f, 0.0998020f, -2.94227f, 
		2.21651f, 1.04393f, -3.10069f, 2.21656f, -0.156203f, -2.86128f, 
		2.21656f, -0.150978f, -2.86506f, 2.21656f, -0.150978f, -2.86506f, 
		2.21656f, -0.150978f, -2.86506f, 2.21656f, -0.150978f, -2.86506f, 
		2.21658f, -0.871814f, -2.77705f, 2.21658f, -0.659741f, -2.84464f, 
		2.21658f, -0.659741f, -2.84464f, 2.21677f, 0.987021f, -3.15114f, 
		2.21686f, -0.143280f, -2.85021f, 2.21686f, -0.143280f, -2.85021f, 
		2.21686f, -0.143280f, -2.85021f, 2.21699f, -0.172841f, -2.83014f, 
		2.21699f, -0.172841f, -2.83014f, 2.21719f, 0.818820f, -2.87743f, 
		2.21741f, 0.349463f, -2.99567f, 2.21742f, -0.146879f, -2.79533f, 
		2.21742f, -0.146879f, -2.79533f, 2.21761f, -0.172861f, -2.82062f, 
		2.21797f, 0.788080f, -3.00565f, 2.21818f, -0.156381f, -2.81464f, 
		2.21818f, -0.156381f, -2.81464f, 2.21824f, 0.755679f, -3.10001f, 
		2.21836f, 0.402300f, -2.90130f, 2.21841f, 0.935422f, -2.85605f, 
		2.21841f, 0.935422f, -2.85605f, 2.21841f, 0.935422f, -2.85605f, 
		2.21846f, -0.146942f, -2.86363f, 2.21846f, -0.146942f, -2.86363f, 
		2.21846f, -0.146942f, -2.86363f, 2.21865f, 0.195679f, -2.96123f, 
		2.21888f, -0.735640f, -2.78472f, 2.21888f, -0.735640f, -2.78472f, 
		2.21888f, -0.735640f, -2.78472f, 2.21889f, -0.157527f, -2.82477f, 
		2.21896f, 0.489191f, -2.89358f, 2.21896f, 0.489191f, -2.89358f, 
		2.21896f, 0.489191f, -2.89358f, 2.21896f, 0.489191f, -2.89358f, 
		2.21896f, 0.489191f, -2.89358f, 2.21902f, -0.159667f, -2.80991f, 
		2.21902f, -0.159667f, -2.80991f, 2.21926f, 0.143289f, -2.93614f, 
		2.21972f, -0.782194f, -2.85008f, 2.21972f, -0.782194f, -2.85008f, 
		2.21978f, 0.961672f, -2.89485f, 2.21979f, -0.0503250f, -2.80156f, 
		2.22001f, -0.144248f, -2.81202f, 2.22001f, -0.144248f, -2.81202f, 
		2.22001f, -0.144248f, -2.81202f, 2.22001f, -0.144248f, -2.81202f, 
		2.22008f, -0.0671160f, -2.80669f, 2.22008f, -0.0671160f, -2.80669f, 
		2.22014f, 0.743964f, -2.94620f, 2.22026f, -0.777013f, -2.77325f, 
		2.22026f, -0.777013f, -2.77325f, 2.22026f, -0.777013f, -2.77325f, 
		2.22034f, -0.142772f, -2.85696f, 2.22040f, -0.0667060f, -2.82184f, 
		2.22054f, 0.252504f, -2.90964f, 2.22063f, -0.149188f, -2.84147f, 
		2.22063f, -0.149188f, -2.84147f, 2.22068f, -0.154794f, -2.84273f, 
		2.22068f, -0.154794f, -2.84273f, 2.22081f, 0.565363f, -2.98063f, 
		2.22083f, -0.654397f, -2.81847f, 2.22092f, -0.173057f, -2.82729f, 
		2.22092f, -0.173057f, -2.82729f, 2.22127f, 0.896659f, -2.89598f, 
		2.22171f, -0.871814f, -2.85406f, 2.22182f, -0.0258640f, -2.81555f, 
		2.22182f, -0.0258640f, -2.81555f, 2.22182f, -0.0258640f, -2.81555f, 
		2.22197f, -0.157863f, -2.85909f, 2.22197f, -0.157863f, -2.85909f, 
		2.22197f, -0.157863f, -2.85909f, 2.22197f, -0.157863f, -2.85909f, 
		2.22202f, 1.05141f, -3.10513f, 2.22210f, -0.149936f, -2.79939f, 
		2.22212f, 0.393149f, -3.00223f, 2.22213f, 0.755995f, -2.97631f, 
		2.22217f, -0.156482f, -2.82157f, 2.22229f, 0.991421f, -3.15832f, 
		2.22254f, -0.165099f, -2.80940f, 2.22254f, -0.165099f, -2.80940f, 
		2.22274f, -0.0290910f, -2.82540f, 2.22274f, -0.0290910f, -2.82540f, 
		2.22274f, -0.0290910f, -2.82540f, 2.22274f, -0.0290910f, -2.82540f, 
		2.22284f, 0.252428f, -2.96075f, 2.22287f, -0.161639f, -2.83010f, 
		2.22287f, -0.161639f, -2.83010f, 2.22307f, -0.0686120f, -2.81306f, 
		2.22307f, -0.0686120f, -2.81306f, 2.22322f, -0.167959f, -2.83106f, 
		2.22322f, -0.167959f, -2.83106f, 2.22322f, -0.167959f, -2.83106f, 
		2.22322f, -0.167959f, -2.83106f, 2.22324f, -0.0486570f, -2.82735f, 
		2.22324f, -0.0486570f, -2.82735f, 2.22340f, -0.144285f, -2.84506f, 
		2.22340f, -0.144285f, -2.84506f, 2.22340f, -0.144285f, -2.84506f, 
		2.22340f, -0.144285f, -2.84506f, 2.22340f, -0.144285f, -2.84506f, 
		2.22345f, -0.152204f, -2.86340f, 2.22345f, -0.152204f, -2.86340f, 
		2.22345f, -0.152204f, -2.86340f, 2.22345f, -0.152204f, -2.86340f, 
		2.22375f, -0.140609f, -2.79296f, 2.22375f, -0.140609f, -2.79296f, 
		2.22375f, -0.140609f, -2.79296f, 2.22388f, 0.557985f, -2.93058f, 
		2.22391f, 0.863002f, -2.90167f, 2.22393f, -0.146465f, -2.86147f, 
		2.22393f, -0.146465f, -2.86147f, 2.22393f, -0.146465f, -2.86147f, 
		2.22393f, -0.146465f, -2.86147f, 2.22393f, -0.146465f, -2.86147f, 
		2.22393f, -0.146465f, -2.86147f, 2.22420f, 0.193656f, -2.93405f, 
		2.22436f, 1.06230f, -3.01641f, 2.22451f, 0.774644f, -2.90762f, 
		2.22452f, -0.156938f, -2.83998f, 2.22452f, -0.156938f, -2.83998f, 
		2.22452f, -0.156938f, -2.83998f, 2.22452f, -0.156938f, -2.83998f, 
		2.22455f, -0.0294130f, -2.80470f, 2.22455f, -0.0294130f, -2.80470f, 
		2.22455f, -0.0294130f, -2.80470f, 2.22488f, 0.774877f, -3.07233f, 
		2.22492f, -0.147065f, -2.81015f, 2.22492f, -0.147065f, -2.81015f, 
		2.22492f, -0.147065f, -2.81015f, 2.22492f, -0.147065f, -2.81015f, 
		2.22507f, 0.846579f, -2.90702f, 2.22507f, 0.846579f, -2.90702f, 
		2.22509f, 0.442302f, -2.90673f, 2.22511f, 0.306893f, -2.91058f, 
		2.22514f, -0.150462f, -2.80556f, 2.22514f, -0.150462f, -2.80556f, 
		2.22543f, -0.126560f, -2.79583f, 2.22543f, -0.126560f, -2.79583f, 
		2.22560f, -0.158925f, -2.84855f, 2.22583f, -0.151415f, -2.83775f, 
		2.22583f, -0.151415f, -2.83775f, 2.22600f, 0.807105f, -3.12230f, 
		2.22676f, 0.469242f, -2.91764f, 2.22676f, 0.469242f, -2.91764f, 
		2.22676f, 0.469242f, -2.91764f, 2.22676f, 0.469242f, -2.91764f, 
		2.22706f, 0.304876f, -2.96194f, 2.22714f, 0.462034f, -2.92844f, 
		2.22714f, 0.462034f, -2.92844f, 2.22714f, 0.462034f, -2.92844f, 
		2.22714f, 0.435700f, -3.00833f, 2.22724f, -0.822057f, -2.87232f, 
		2.22724f, -0.822057f, -2.87232f, 2.22736f, -0.168476f, -2.81379f, 
		2.22738f, 0.817057f, -2.90292f, 2.22741f, -0.129518f, -2.79054f, 
		2.22741f, -0.129518f, -2.79054f, 2.22741f, -0.129518f, -2.79054f, 
		2.22741f, -0.129518f, -2.79054f, 2.22747f, 0.941849f, -3.15400f, 
		2.22761f, -0.0570670f, -2.80310f, 2.22761f, -0.0570670f, -2.80310f, 
		2.22770f, -0.143808f, -2.85195f, 2.22775f, -0.160616f, -2.84618f, 
		2.22779f, -0.159973f, -2.82598f, 2.22779f, -0.159973f, -2.82598f, 
		2.22783f, -0.158868f, -2.85484f, 2.22783f, -0.158868f, -2.85484f, 
		2.22791f, -0.0386410f, -2.82866f, 2.22791f, -0.0386410f, -2.82866f, 
		2.22802f, -0.861619f, -2.87342f, 2.22802f, -0.861619f, -2.87342f, 
		2.22802f, -0.861619f, -2.87342f, 2.22816f, -0.127451f, -2.80239f, 
		2.22817f, 0.824868f, -2.90757f, 2.22817f, 0.824868f, -2.90757f, 
		2.22817f, 0.824868f, -2.90757f, 2.22830f, 0.251614f, -2.93337f, 
		2.22858f, -0.143278f, -2.79653f, 2.22893f, 0.466700f, -2.90679f, 
		2.22893f, 0.466700f, -2.90679f, 2.22893f, 0.466700f, -2.90679f, 
		2.22893f, 0.466700f, -2.90679f, 2.22893f, 0.466700f, -2.90679f, 
		2.22900f, -0.146851f, -2.84073f, 2.22900f, -0.146851f, -2.84073f, 
		2.22900f, -0.146851f, -2.84073f, 2.22900f, -0.146851f, -2.84073f, 
		2.22900f, -0.146851f, -2.84073f, 2.22900f, -0.146851f, -2.84073f, 
		2.22934f, -0.743987f, -2.83793f, 2.22934f, -0.743987f, -2.83793f, 
		2.22953f, -0.0396420f, -2.79889f, 2.22953f, -0.0396420f, -2.79889f, 
		2.22953f, -0.0396420f, -2.79889f, 2.22965f, 1.03545f, -3.07388f, 
		2.23014f, -0.119598f, -2.79492f, 2.23014f, -0.119598f, -2.79492f, 
		2.23020f, -0.0541690f, -2.82147f, 2.23021f, 0.356935f, -2.91448f, 
		2.23036f, -0.158488f, -2.80556f, 2.23036f, -0.158488f, -2.80556f, 
		2.23036f, -0.158488f, -2.80556f, 2.23055f, -0.147479f, -2.85745f, 
		2.23055f, -0.147479f, -2.85745f, 2.23065f, -0.169026f, -2.82027f, 
		2.23065f, -0.169026f, -2.82027f, 2.23101f, -0.144049f, -2.80269f, 
		2.23101f, -0.144049f, -2.80269f, 2.23101f, -0.144049f, -2.80269f, 
		2.23101f, -0.144049f, -2.80269f, 2.23106f, 0.743737f, -3.01638f, 
		2.23106f, 0.743737f, -3.01638f, 2.23124f, -0.123012f, -2.87717f, 
		2.23124f, -0.123012f, -2.87717f, 2.23124f, -0.123012f, -2.87717f, 
		2.23124f, -0.123012f, -2.87717f, 2.23125f, -0.164817f, -2.82477f, 
		2.23125f, -0.164817f, -2.82477f, 2.23125f, -0.164817f, -2.82477f, 
		2.23125f, -0.164817f, -2.82477f, 2.23130f, -0.160472f, -2.85215f, 
		2.23130f, -0.160472f, -2.85215f, 2.23138f, -0.863418f, -2.76692f, 
		2.23138f, -0.863418f, -2.76692f, 2.23138f, -0.826292f, -2.76692f, 
		2.23169f, 0.861638f, -2.91901f, 2.23180f, -0.0292510f, -2.83383f, 
		2.23180f, -0.0292510f, -2.83383f, 2.23180f, -0.0292510f, -2.83383f, 
		2.23180f, -0.0292510f, -2.83383f, 2.23180f, -0.0292510f, -2.83383f, 
		2.23180f, 0.352480f, -2.96692f, 2.23189f, -0.124177f, -2.88182f, 
		2.23189f, -0.124177f, -2.88182f, 2.23189f, -0.124177f, -2.88182f, 
		2.23189f, -0.124177f, -2.88182f, 2.23189f, -0.124177f, -2.88182f, 
		2.23202f, 0.801769f, -3.12791f, 2.23204f, -0.0153890f, -2.82603f, 
		2.23204f, -0.0153890f, -2.82603f, 2.23204f, -0.0153890f, -2.82603f, 
		2.23213f, 0.483662f, -3.01606f, 2.23217f, 0.839905f, -3.13632f, 
		2.23227f, -0.133420f, -2.78918f, 2.23227f, -0.133420f, -2.78918f, 
		2.23227f, -0.133420f, -2.78918f, 2.23231f, -0.117978f, -2.87705f, 
		2.23231f, -0.117978f, -2.87705f, 2.23231f, -0.117978f, -2.87705f, 
		2.23231f, -0.117978f, -2.87705f, 2.23238f, -0.121142f, -2.80141f, 
		2.23238f, -0.121142f, -2.80141f, 2.23238f, -0.121142f, -2.80141f, 
		2.23238f, -0.121142f, -2.80141f, 2.23238f, -0.121142f, -2.80141f, 
		2.23238f, -0.121142f, -2.80141f, 2.23243f, -0.109159f, -2.79701f, 
		2.23243f, -0.109159f, -2.79701f, 2.23243f, -0.109159f, -2.79701f, 
		2.23243f, -0.109159f, -2.79701f, 2.23243f, -0.109159f, -2.79701f, 
		2.23246f, 0.770212f, -2.96627f, 2.23246f, 0.770212f, -2.96627f, 
		2.23246f, 0.770212f, -2.96627f, 2.23256f, -0.737847f, -2.80802f, 
		2.23257f, -0.0580390f, -2.81172f, 2.23257f, -0.0580390f, -2.81172f, 
		2.23257f, -0.0580390f, -2.81172f, 2.23268f, 0.822378f, -2.91762f, 
		2.23268f, 0.822378f, -2.91762f, 2.23268f, 0.822378f, -2.91762f, 
		2.23272f, 0.782104f, -2.93246f, 2.23272f, 0.782104f, -2.93246f, 
		2.23272f, 0.782104f, -2.93246f, 2.23299f, -0.130555f, -2.80622f, 
		2.23299f, -0.130555f, -2.80622f, 2.23309f, 0.305123f, -2.93282f, 
		2.23311f, 0.774420f, -3.01823f, 2.23318f, -0.113866f, -2.80330f, 
		2.23318f, -0.113866f, -2.80330f, 2.23318f, -0.113866f, -2.80330f, 
		2.23318f, -0.113866f, -2.80330f, 2.23319f, 0.824793f, -2.90580f, 
		2.23319f, 0.824793f, -2.90580f, 2.23319f, 0.824793f, -2.90580f, 
		2.23322f, 1.02649f, -2.92857f, 2.23325f, -0.146450f, -2.83743f, 
		2.23325f, -0.146450f, -2.83743f, 2.23331f, -0.120666f, -2.78951f, 
		2.23339f, -0.0503410f, -2.80142f, 2.23339f, -0.0503410f, -2.80142f, 
		2.23339f, -0.0503410f, -2.80142f, 2.23339f, -0.0503410f, -2.80142f, 
		2.23339f, -0.0503410f, -2.80142f, 2.23353f, -0.146517f, -2.84708f, 
		2.23358f, 0.943806f, -3.16133f, 2.23392f, -0.117898f, -2.88319f, 
		2.23392f, -0.117898f, -2.88319f, 2.23392f, -0.117898f, -2.88319f, 
		2.23392f, -0.117898f, -2.88319f, 2.23392f, -0.117898f, -2.88319f, 
		2.23405f, 0.884213f, -2.94747f, 2.23405f, 0.884213f, -2.94747f, 
		2.23405f, 0.884213f, -2.94747f, 2.23410f, -0.149872f, -2.83304f, 
		2.23410f, -0.149872f, -2.83304f, 2.23412f, -0.0514680f, -2.81349f, 
		2.23412f, -0.0514680f, -2.81349f, 2.23412f, -0.0514680f, -2.81349f, 
		2.23412f, -0.0514680f, -2.81349f, 2.23425f, -0.155572f, -2.85532f, 
		2.23425f, -0.155572f, -2.85532f, 2.23425f, -0.155572f, -2.85532f, 
		2.23425f, -0.155572f, -2.85532f, 2.23425f, 0.900364f, -2.92078f, 
		2.23446f, -0.126197f, -2.87135f, 2.23446f, -0.126197f, -2.87135f, 
		2.23493f, 0.846431f, -2.90355f, 2.23493f, 0.846431f, -2.90355f, 
		2.23505f, 0.762241f, -3.08442f, 2.23512f, 0.414294f, -2.93155f, 
		2.23522f, -0.0480810f, -2.82195f, 2.23522f, -0.0480810f, -2.82195f, 
		2.23522f, -0.0480810f, -2.82195f, 2.23522f, -0.0480810f, -2.82195f, 
		2.23522f, -0.0480810f, -2.82195f, 2.23522f, -0.0480810f, -2.82195f, 
		2.23522f, 0.535508f, -3.01416f, 2.23522f, 0.535508f, -3.01416f, 
		2.23522f, 0.535508f, -3.01416f, 2.23522f, 0.535508f, -3.01416f, 
		2.23522f, 0.535508f, -3.01416f, 2.23522f, 0.864215f, -3.14331f, 
		2.23535f, -0.105304f, -2.80454f, 2.23535f, -0.105304f, -2.80454f, 
		2.23535f, -0.105304f, -2.80454f, 2.23535f, 0.818530f, -2.91959f, 
		2.23535f, 0.818530f, -2.91959f, 2.23542f, -0.161512f, -2.80933f, 
		2.23542f, -0.155846f, -2.83352f, 2.23542f, -0.155846f, -2.83352f, 
		2.23542f, -0.155846f, -2.83352f, 2.23542f, -0.155846f, -2.83352f, 
		2.23545f, 0.841688f, -2.93082f, 2.23545f, 0.841688f, -2.93082f, 
		2.23546f, -0.0425600f, -2.83086f, 2.23546f, -0.0425600f, -2.83086f, 
		2.23546f, -0.0425600f, -2.83086f, 2.23561f, 0.898120f, -2.89603f, 
		2.23561f, 0.898120f, -2.89603f, 2.23561f, 0.898120f, -2.89603f, 
		2.23561f, 0.898120f, -2.89603f, 2.23588f, 1.04247f, -3.07687f, 
		2.23606f, -0.0957096f, -2.79873f, 2.23606f, -0.0957096f, -2.79873f, 
		2.23606f, -0.0957096f, -2.79873f, 2.23608f, -0.141305f, -2.80630f, 
		2.23608f, -0.141305f, -2.80630f, 2.23610f, -0.150146f, -2.85276f, 
		2.23610f, -0.150146f, -2.85276f, 2.23628f, -0.0131140f, -2.81499f, 
		2.23628f, -0.0131140f, -2.81499f, 2.23628f, -0.0131140f, -2.81499f, 
		2.23629f, 0.899880f, -3.15048f, 2.23639f, -0.116410f, -2.87533f, 
		2.23639f, -0.116410f, -2.87533f, 2.23639f, -0.116410f, -2.87533f, 
		2.23640f, -0.0504020f, -2.81840f, 2.23640f, -0.0504020f, -2.81840f, 
		2.23640f, -0.0504020f, -2.81840f, 2.23640f, -0.0504020f, -2.81840f, 
		2.23642f, -0.146445f, -2.84380f, 2.23642f, -0.146445f, -2.84380f, 
		2.23642f, -0.146445f, -2.84380f, 2.23667f, -0.0808999f, -2.79969f, 
		2.23667f, -0.0808999f, -2.79969f, 2.23668f, -0.121661f, -2.86963f, 
		2.23668f, -0.121661f, -2.86963f, 2.23668f, -0.121661f, -2.86963f, 
		2.23668f, -0.121661f, -2.86963f, 2.23668f, -0.121661f, -2.86963f, 
		2.23668f, -0.125866f, -2.88384f, 2.23681f, -0.107179f, -2.79094f, 
		2.23681f, 0.786125f, -3.05169f, 2.23684f, 0.809603f, -2.99721f, 
		2.23685f, -0.136235f, -2.79262f, 2.23687f, -0.0491110f, -2.80480f, 
		2.23687f, -0.0491110f, -2.80480f, 2.23687f, -0.0491110f, -2.80480f, 
		2.23726f, -0.145387f, -2.80096f, 2.23726f, -0.145387f, -2.80096f, 
		2.23726f, -0.134642f, -2.80397f, 2.23726f, -0.134642f, -2.80397f, 
		2.23726f, -0.134642f, -2.80397f, 2.23734f, -0.0746670f, -2.80240f, 
		2.23734f, -0.0746670f, -2.80240f, 2.23734f, -0.0596410f, -2.80742f, 
		2.23734f, -0.0596410f, -2.80742f, 2.23743f, 0.416824f, -2.91111f, 
		2.23743f, 0.416824f, -2.91111f, 2.23743f, 0.416824f, -2.91111f, 
		2.23764f, -0.123484f, -2.80460f, 2.23764f, -0.123484f, -2.80460f, 
		2.23771f, -0.0644740f, -2.80647f, 2.23771f, -0.0644740f, -2.80647f, 
		2.23777f, 0.399099f, -2.91896f, 2.23791f, -0.115704f, -2.88166f, 
		2.23791f, -0.115704f, -2.88166f, 2.23791f, -0.115704f, -2.88166f, 
		2.23791f, -0.115704f, -2.88166f, 2.23798f, 0.518236f, -2.88803f, 
		2.23798f, 0.518236f, -2.88803f, 2.23798f, 0.518236f, -2.88803f, 
		2.23798f, 0.518236f, -2.88803f, 2.23798f, 0.518236f, -2.88803f, 
		2.23798f, 0.518236f, -2.88803f, 2.23803f, -0.0693487f, -2.80472f, 
		2.23803f, -0.0693487f, -2.80472f, 2.23805f, -0.0197610f, -2.80715f, 
		2.23810f, -0.779940f, -2.83890f, 2.23810f, -0.779940f, -2.83890f, 
		2.23845f, -0.0981270f, -2.80474f, 2.23848f, -0.161932f, -2.81586f, 
		2.23848f, -0.161932f, -2.81586f, 2.23848f, -0.161932f, -2.81586f, 
		2.23848f, -0.161932f, -2.81586f, 2.23851f, 0.821808f, -2.91762f, 
		2.23851f, 0.821808f, -2.91762f, 2.23851f, 0.821808f, -2.91762f, 
		2.23851f, -0.0223000f, -2.84054f, 2.23851f, -0.0223000f, -2.84054f, 
		2.23851f, -0.0223000f, -2.84054f, 2.23852f, 0.836344f, -3.14270f, 
		2.23858f, -0.120980f, -2.88620f, 2.23858f, -0.120980f, -2.88620f, 
		2.23858f, -0.120980f, -2.88620f, 2.23858f, -0.120980f, -2.88620f, 
		2.23861f, -0.0964690f, -2.79215f, 2.23861f, -0.0964690f, -2.79215f, 
		2.23861f, -0.0964690f, -2.79215f, 2.23868f, 0.354002f, -2.93648f, 
		2.23874f, 0.396060f, -2.97266f, 2.23881f, -0.0533360f, -2.80597f, 
		2.23881f, -0.0533360f, -2.80597f, 2.23881f, -0.0533360f, -2.80597f, 
		2.23881f, -0.0533360f, -2.80597f, 2.23890f, -0.130097f, -2.86781f, 
		2.23890f, -0.130097f, -2.86781f, 2.23891f, -0.159485f, -2.83811f, 
		2.23893f, -0.775878f, -2.80261f, 2.23894f, -0.136849f, -2.79853f, 
		2.23894f, -0.136849f, -2.79853f, 2.23894f, -0.136849f, -2.79853f, 
		2.23894f, -0.136849f, -2.79853f, 2.23918f, 0.859051f, -2.93249f, 
		2.23918f, 0.859051f, -2.93249f, 2.23921f, -0.122580f, -2.78780f, 
		2.23921f, -0.122580f, -2.78780f, 2.23921f, -0.122580f, -2.78780f, 
		2.23942f, -0.141752f, -2.81319f, 2.23974f, -0.0929280f, -2.80554f, 
		2.23980f, -0.00691700f, -2.82803f, 2.23980f, -0.00691700f, -2.82803f, 
		2.23980f, -0.00691700f, -2.82803f, 2.23987f, -0.0343020f, -2.80175f, 
		2.23987f, -0.0343020f, -2.80175f, 2.23987f, -0.0343020f, -2.80175f, 
		2.23987f, -0.0343020f, -2.80175f, 2.23987f, -0.0343020f, -2.80175f, 
		2.23987f, -0.0343020f, -2.80175f, 2.24008f, 0.464009f, -2.94753f, 
		2.24008f, 0.464009f, -2.94753f, 2.24008f, 0.464009f, -2.94753f, 
		2.24008f, 0.464009f, -2.94753f, 2.24008f, 0.464009f, -2.94753f, 
		2.24021f, -0.871814f, -2.84178f, 2.24031f, -0.0863410f, -2.79231f, 
		2.24031f, -0.0863410f, -2.79231f, 2.24031f, -0.0863410f, -2.79231f, 
		2.24042f, -0.109274f, -2.80697f, 2.24042f, -0.109274f, -2.80697f, 
		2.24044f, 0.819923f, -2.93018f, 2.24044f, 0.819923f, -2.93018f, 
		2.24063f, -0.150292f, -2.84864f, 2.24063f, -0.150292f, -2.84864f, 
		2.24097f, -0.0834250f, -2.80891f, 2.24105f, 0.782891f, -2.93367f, 
		2.24105f, 0.782891f, -2.93367f, 2.24105f, 0.782891f, -2.93367f, 
		2.24113f, -0.130098f, -2.88166f, 2.24113f, -0.130098f, -2.88166f, 
		2.24113f, -0.130098f, -2.88166f, 2.24119f, -0.134488f, -2.80489f, 
		2.24119f, -0.134488f, -2.80489f, 2.24120f, -0.133664f, -2.86544f, 
		2.24120f, -0.133664f, -2.86544f, 2.24120f, -0.133664f, -2.86544f, 
		2.24120f, -0.133664f, -2.86544f, 2.24129f, 0.960298f, -2.94934f, 
		2.24166f, -0.0541620f, -2.82048f, 2.24166f, -0.0541620f, -2.82048f, 
		2.24166f, -0.0541620f, -2.82048f, 2.24167f, -0.0744297f, -2.79317f, 
		2.24167f, -0.0744297f, -2.79317f, 2.24167f, -0.0744297f, -2.79317f, 
		2.24167f, -0.0744297f, -2.79317f, 2.24167f, -0.0744297f, -2.79317f, 
		2.24175f, 0.861970f, -3.15006f, 2.24185f, 0.883136f, -2.93601f, 
		2.24185f, 0.883136f, -2.93601f, 2.24185f, 0.883136f, -2.93601f, 
		2.24185f, 0.883136f, -2.93601f, 2.24201f, -0.118537f, -2.88412f, 
		2.24201f, -0.118537f, -2.88412f, 2.24201f, -0.118537f, -2.88412f, 
		2.24201f, -0.118537f, -2.88412f, 2.24201f, -0.118537f, -2.88412f, 
		2.24201f, -0.150023f, -2.79961f, 2.24201f, -0.150023f, -2.79961f, 
		2.24201f, -0.150023f, -2.79961f, 2.24201f, -0.150023f, -2.79961f, 
		2.24201f, -0.150023f, -2.79961f, 2.24201f, -0.0629420f, -2.79824f, 
		2.24201f, -0.0629420f, -2.79824f, 2.24201f, -0.0629420f, -2.79824f, 
		2.24201f, -0.0629420f, -2.79824f, 2.24209f, -0.159838f, -2.84412f, 
		2.24209f, -0.159838f, -2.84412f, 2.24248f, 0.990958f, -3.11880f, 
		2.24251f, -0.133599f, -2.87310f, 2.24271f, -0.151806f, -2.82926f, 
		2.24271f, -0.151806f, -2.82926f, 2.24271f, -0.151806f, -2.82926f, 
		2.24271f, -0.125597f, -2.80170f, 2.24281f, -0.0544330f, -2.79942f, 
		2.24281f, -0.0544330f, -2.79942f, 2.24288f, 0.899564f, -3.15762f, 
		2.24291f, -0.155758f, -2.84814f, 2.24291f, -0.155758f, -2.84814f, 
		2.24291f, -0.155758f, -2.84814f, 2.24291f, -0.155758f, -2.84814f, 
		2.24307f, -0.108259f, -2.78914f, 2.24307f, -0.108259f, -2.78914f, 
		2.24307f, -0.108259f, -2.78914f, 2.24307f, -0.125664f, -2.80663f, 
		2.24307f, -0.125664f, -2.80663f, 2.24307f, -0.125664f, -2.80663f, 
		2.24307f, -0.125664f, -2.80663f, 2.24309f, -0.117320f, -2.87794f, 
		2.24314f, 1.00907f, -3.01107f, 2.24347f, -0.871814f, -2.80939f, 
		2.24358f, -0.129647f, -2.86248f, 2.24358f, -0.129647f, -2.86248f, 
		2.24358f, -0.129647f, -2.86248f, 2.24358f, -0.129647f, -2.86248f, 
		2.24375f, -0.0593040f, -2.82347f, 2.24375f, -0.0593040f, -2.82347f, 
		2.24375f, -0.0593040f, -2.82347f, 2.24388f, -0.135878f, -2.81178f, 
		2.24388f, -0.135878f, -2.81178f, 2.24388f, -0.135878f, -2.81178f, 
		2.24388f, -0.135878f, -2.81178f, 2.24392f, -0.136851f, -2.87097f, 
		2.24392f, -0.136851f, -2.87097f, 2.24392f, -0.136851f, -2.87097f, 
		2.24392f, -0.136851f, -2.87097f, 2.24398f, -0.124818f, -2.88452f, 
		2.24398f, -0.124818f, -2.88452f, 2.24398f, -0.124818f, -2.88452f, 
		2.24398f, -0.124818f, -2.88452f, 2.24398f, -0.124818f, -2.88452f, 
		2.24398f, -0.124818f, -2.88452f, 2.24398f, -0.124874f, -2.79063f, 
		2.24398f, -0.124874f, -2.79063f, 2.24398f, -0.124874f, -2.79063f, 
		2.24398f, -0.124874f, -2.79063f, 2.24398f, -0.124874f, -2.79063f, 
		2.24412f, -0.0422360f, -2.83846f, 2.24424f, -0.121192f, -2.86784f, 
		2.24424f, -0.121192f, -2.86784f, 2.24424f, -0.121192f, -2.86784f, 
		2.24424f, -0.121192f, -2.86784f, 2.24424f, -0.121192f, -2.86784f, 
		2.24438f, -0.0983718f, -2.80814f, 2.24438f, -0.0983718f, -2.80814f, 
		2.24438f, -0.0983718f, -2.80814f, 2.24438f, -0.0983718f, -2.80814f, 
		2.24438f, -0.0983718f, -2.80814f, 2.24439f, -0.135788f, -2.79903f, 
		2.24439f, -0.135788f, -2.79903f, 2.24439f, -0.135788f, -2.79903f, 
		2.24445f, -0.145251f, -2.81745f, 2.24445f, -0.145251f, -2.81745f, 
		2.24475f, -0.127067f, -2.81412f, 2.24475f, -0.127067f, -2.81412f, 
		2.24475f, -0.127067f, -2.81412f, 2.24518f, -0.133545f, -2.87811f, 
		2.24518f, -0.133545f, -2.87811f, 2.24520f, 0.440186f, -2.92371f, 
		2.24520f, 0.440186f, -2.92371f, 2.24520f, 0.440186f, -2.92371f, 
		2.24537f, -0.125880f, -2.79609f, 2.24537f, -0.125880f, -2.79609f, 
		2.24537f, -0.125880f, -2.79609f, 2.24554f, 0.438609f, -2.97834f, 
		2.24557f, -0.0909907f, -2.81218f, 2.24557f, -0.0909907f, -2.81218f, 
		2.24557f, -0.0909907f, -2.81218f, 2.24559f, 0.780109f, -2.95167f, 
		2.24559f, 0.780109f, -2.95167f, 2.24559f, 0.780109f, -2.95167f, 
		2.24567f, -0.0442300f, -2.79897f, 2.24567f, -0.0442300f, -2.79897f, 
		2.24567f, -0.0442300f, -2.79897f, 2.24567f, -0.0442300f, -2.79897f, 
		2.24570f, -0.0633070f, -2.82252f, 2.24594f, 0.466079f, -2.93735f, 
		2.24594f, 0.466079f, -2.93735f, 2.24594f, 0.466079f, -2.93735f, 
		2.24598f, -0.113046f, -2.80315f, 2.24607f, -0.0798860f, -2.81500f, 
		2.24608f, 0.554094f, -2.95374f, 2.24623f, -0.0911061f, -2.78942f, 
		2.24623f, -0.0911061f, -2.78942f, 2.24623f, -0.0911061f, -2.78942f, 
		2.24641f, -0.0699860f, -2.81904f, 2.24659f, 0.889498f, -2.98519f, 
		2.24659f, 0.889498f, -2.98519f, 2.24661f, -0.0737380f, -2.81687f, 
		2.24680f, 0.843833f, -2.99757f, 2.24682f, -0.154919f, -2.83303f, 
		2.24682f, -0.153163f, -2.80331f, 2.24685f, -0.0187040f, -2.84764f, 
		2.24685f, -0.0187040f, -2.84764f, 2.24685f, -0.0187040f, -2.84764f, 
		2.24685f, -0.0187040f, -2.84764f, 2.24689f, 0.366656f, -2.93179f, 
		2.24691f, 0.840568f, -2.93082f, 2.24691f, 0.840568f, -2.93082f, 
		2.24704f, 0.416377f, -2.94928f, 2.24720f, -0.0977299f, -2.80979f, 
		2.24720f, -0.0977299f, -2.80979f, 2.24720f, -0.0977299f, -2.80979f, 
		2.24747f, -0.136470f, -2.87597f, 2.24747f, -0.136470f, -2.87597f, 
		2.24763f, 0.774098f, -3.06267f, 2.24770f, -0.115047f, -2.81580f, 
		2.24770f, -0.115047f, -2.81580f, 2.24772f, 0.398288f, -2.94050f, 
		2.24775f, -0.126030f, -2.86406f, 2.24775f, -0.126030f, -2.86406f, 
		2.24775f, -0.126030f, -2.86406f, 2.24775f, -0.126030f, -2.86406f, 
		2.24797f, -0.105957f, -2.81001f, 2.24797f, -0.105957f, -2.81001f, 
		2.24797f, -0.105957f, -2.81001f, 2.24797f, -0.105957f, -2.81001f, 
		2.24797f, -0.105957f, -2.81001f, 2.24797f, -0.105957f, -2.81001f, 
		2.24797f, -0.105957f, -2.81001f, 2.24800f, -0.138529f, -2.82846f, 
		2.24800f, -0.138529f, -2.82846f, 2.24824f, 0.812048f, -3.09843f, 
		2.24827f, -0.150492f, -2.81534f, 2.24827f, -0.150492f, -2.81534f, 
		2.24827f, -0.150492f, -2.81534f, 2.24833f, -0.100199f, -2.81167f, 
		2.24833f, -0.100199f, -2.81167f, 2.24833f, -0.100199f, -2.81167f, 
		2.24833f, -0.100199f, -2.81167f, 2.24852f, -0.142945f, -2.82386f, 
		2.24852f, -0.142945f, -2.82386f, 2.24853f, -0.120932f, -2.87337f, 
		2.24862f, 0.472830f, -2.89167f, 2.24862f, 0.472830f, -2.89167f, 
		2.24862f, 0.472830f, -2.89167f, 2.24873f, 0.368902f, -2.91341f, 
		2.24873f, 0.368902f, -2.91341f, 2.24873f, 0.368902f, -2.91341f, 
		2.24889f, 0.865176f, -2.99240f, 2.24900f, -0.117290f, -2.80156f, 
		2.24900f, -0.117290f, -2.80156f, 2.24900f, -0.117290f, -2.80156f, 
		2.24900f, -0.117290f, -2.80156f, 2.24900f, -0.117290f, -2.80156f, 
		2.24907f, -0.102923f, -2.80398f, 2.24921f, -0.112268f, -2.79729f, 
		2.24921f, -0.112268f, -2.79729f, 2.24921f, -0.112268f, -2.79729f, 
		2.24939f, 0.995572f, -3.12423f, 2.24945f, -0.0759220f, -2.79059f, 
		2.24954f, -0.138220f, -2.81552f, 2.24954f, -0.138220f, -2.81552f, 
		2.24958f, -0.155388f, -2.83922f, 2.24958f, -0.155388f, -2.83922f, 
		2.24961f, -0.153409f, -2.80964f, 2.24961f, -0.153409f, -2.80964f, 
		2.24961f, -0.153409f, -2.80964f, 2.24961f, -0.153409f, -2.80964f, 
		2.24967f, 0.00141500f, -2.83484f, 2.24967f, 0.00141500f, -2.83484f, 
		2.24976f, -0.102941f, -2.79170f, 2.24976f, -0.102941f, -2.79170f, 
		2.24976f, -0.102941f, -2.79170f, 2.24976f, -0.102941f, -2.79170f, 
		2.24985f, -0.135796f, -2.85918f, 2.24985f, -0.135796f, -2.85918f, 
		2.24985f, -0.135796f, -2.85918f, 2.24985f, -0.135796f, -2.85918f, 
		2.25035f, -0.0992240f, -2.80539f, 2.25035f, -0.0992240f, -2.80539f, 
		2.25035f, -0.0992240f, -2.80539f, 2.25035f, -0.105731f, -2.81640f, 
		2.25035f, -0.105731f, -2.81640f, 2.25035f, -0.105731f, -2.81640f, 
		2.25035f, -0.105731f, -2.81640f, 2.25035f, -0.105731f, -2.81640f, 
		2.25040f, 0.882050f, -2.95182f, 2.25040f, 0.882050f, -2.95182f, 
		2.25040f, 0.882050f, -2.95182f, 2.25040f, 0.882050f, -2.95182f, 
		2.25043f, -0.126649f, -2.86132f, 2.25043f, -0.126649f, -2.86132f, 
		2.25051f, -0.00314700f, -2.81666f, 2.25051f, -0.00314700f, -2.81666f, 
		2.25051f, -0.00314700f, -2.81666f, 2.25051f, -0.00314700f, -2.81666f, 
		2.25051f, -0.00314700f, -2.81666f, 2.25076f, -0.123935f, -2.87830f, 
		2.25076f, -0.123935f, -2.87830f, 2.25076f, -0.123935f, -2.87830f, 
		2.25076f, -0.123935f, -2.87830f, 2.25078f, -0.129853f, -2.85753f, 
		2.25078f, -0.129853f, -2.85753f, 2.25078f, -0.129853f, -2.85753f, 
		2.25078f, -0.129853f, -2.85753f, 2.25098f, -0.137369f, -2.79720f, 
		2.25098f, -0.137369f, -2.79720f, 2.25098f, -0.137369f, -2.79720f, 
		2.25098f, -0.137369f, -2.79720f, 2.25098f, -0.137369f, -2.79720f, 
		2.25098f, -0.137369f, -2.79720f, 2.25110f, -0.0437140f, -2.84376f, 
		2.25120f, -0.0647064f, -2.79436f, 2.25128f, -0.0927230f, -2.81829f, 
		2.25137f, -0.138520f, -2.83490f, 2.25156f, -0.101585f, -2.80464f, 
		2.25156f, -0.101585f, -2.80464f, 2.25156f, -0.101585f, -2.80464f, 
		2.25156f, -0.101585f, -2.80464f, 2.25156f, -0.101585f, -2.80464f, 
		2.25156f, -0.101585f, -2.80464f, 2.25156f, -0.101585f, -2.80464f, 
		2.25156f, -0.101585f, -2.80464f, 2.25178f, -0.133760f, -2.82675f, 
		2.25178f, -0.133760f, -2.82675f, 2.25194f, -0.132772f, -2.87727f, 
		2.25194f, -0.132772f, -2.87727f, 2.25194f, -0.132772f, -2.87727f, 
		2.25194f, -0.132772f, -2.87727f, 2.25199f, 0.998405f, -3.07539f, 
		2.25205f, -0.147940f, -2.82316f, 2.25205f, -0.147940f, -2.82316f, 
		2.25205f, -0.147940f, -2.82316f, 2.25205f, -0.147940f, -2.82316f, 
		2.25205f, -0.147940f, -2.82316f, 2.25205f, -0.147940f, -2.82316f, 
		2.25225f, 0.760659f, -3.00536f, 2.25225f, 0.760659f, -3.00536f, 
		2.25232f, 0.900999f, -2.95905f, 2.25244f, -0.0372213f, -2.80224f, 
		2.25246f, -0.0502190f, -2.79894f, 2.25252f, -0.121551f, -2.81809f, 
		2.25252f, -0.121551f, -2.81809f, 2.25261f, -0.139340f, -2.86375f, 
		2.25261f, -0.139340f, -2.86375f, 2.25261f, -0.139340f, -2.86375f, 
		2.25261f, -0.139340f, -2.86375f, 2.25261f, -0.139340f, -2.86375f, 
		2.25265f, 0.801072f, -2.94223f, 2.25265f, 0.801072f, -2.94223f, 
		2.25265f, 0.801072f, -2.94223f, 2.25267f, -0.0126930f, -2.80988f, 
		2.25298f, -0.126772f, -2.86791f, 2.25298f, -0.126772f, -2.86791f, 
		2.25298f, -0.126772f, -2.86791f, 2.25298f, 0.479677f, -2.98651f, 
		2.25315f, 0.963942f, -2.94371f, 2.25337f, -0.125900f, -2.82775f, 
		2.25337f, -0.125900f, -2.82775f, 2.25337f, -0.125900f, -2.82775f, 
		2.25337f, -0.125900f, -2.82775f, 2.25371f, -0.0871280f, -2.79110f, 
		2.25371f, -0.0871280f, -2.79110f, 2.25371f, -0.0871280f, -2.79110f, 
		2.25377f, 0.866485f, -2.94553f, 2.25377f, 0.866485f, -2.94553f, 
		2.25377f, 0.866485f, -2.94553f, 2.25388f, 0.797773f, -2.96724f, 
		2.25388f, 0.797773f, -2.96724f, 2.25388f, 0.797773f, -2.96724f, 
		2.25388f, 0.797773f, -2.96724f, 2.25388f, 0.797773f, -2.96724f, 
		2.25395f, -0.0971767f, -2.79819f, 2.25395f, -0.0971767f, -2.79819f, 
		2.25395f, -0.0971767f, -2.79819f, 2.25395f, -0.0971767f, -2.79819f, 
		2.25395f, -0.0971767f, -2.79819f, 2.25395f, -0.0971767f, -2.79819f, 
		2.25406f, 0.850317f, -2.95974f, 2.25406f, 0.850317f, -2.95974f, 
		2.25442f, -0.820625f, -2.85428f, 2.25442f, -0.820625f, -2.85428f, 
		2.25465f, -0.134446f, -2.83395f, 2.25465f, -0.134446f, -2.83395f, 
		2.25465f, -0.134446f, -2.83395f, 2.25465f, -0.134446f, -2.83395f, 
		2.25465f, -0.134446f, -2.83395f, 2.25465f, -0.134446f, -2.83395f, 
		2.25474f, -0.861511f, -2.85473f, 2.25474f, -0.861511f, -2.85473f, 
		2.25474f, -0.861511f, -2.85473f, 2.25479f, 0.801787f, -2.93556f, 
		2.25479f, 0.801787f, -2.93556f, 2.25479f, 0.801787f, -2.93556f, 
		2.25482f, 0.799169f, -3.00853f, 2.25505f, -0.0210070f, -2.85347f, 
		2.25505f, -0.0210070f, -2.85347f, 2.25505f, -0.0210070f, -2.85347f, 
		2.25517f, -0.135326f, -2.82095f, 2.25517f, -0.135326f, -2.82095f, 
		2.25517f, -0.135326f, -2.82095f, 2.25525f, 0.868142f, -2.93890f, 
		2.25525f, 0.868142f, -2.93890f, 2.25525f, 0.868142f, -2.93890f, 
		2.25525f, 0.868142f, -2.93890f, 2.25525f, -0.140384f, -2.81267f, 
		2.25535f, -0.0480060f, -2.84481f, 2.25548f, 0.806979f, -3.10275f, 
		2.25571f, -0.138926f, -2.86956f, 2.25571f, -0.138926f, -2.86956f, 
		2.25571f, -0.138926f, -2.86956f, 2.25571f, -0.138926f, -2.86956f, 
		2.25572f, 0.0165550f, -2.84020f, 2.25572f, 0.0165550f, -2.84020f, 
		2.25576f, -0.126502f, -2.83533f, 2.25576f, -0.126502f, -2.83533f, 
		2.25576f, -0.126502f, -2.83533f, 2.25582f, 0.420384f, -2.89682f, 
		2.25588f, -0.124264f, -2.85785f, 2.25588f, -0.124264f, -2.85785f, 
		2.25592f, -0.821455f, -2.80204f, 2.25593f, 0.849843f, -2.93539f, 
		2.25593f, 0.849843f, -2.93539f, 2.25593f, 0.849843f, -2.93539f, 
		2.25593f, 0.849843f, -2.93539f, 2.25593f, -0.0967490f, -2.80063f, 
		2.25593f, -0.0967490f, -2.80063f, 2.25598f, -0.117112f, -2.82895f, 
		2.25600f, -0.130179f, -2.87249f, 2.25600f, -0.130179f, -2.87249f, 
		2.25600f, -0.130179f, -2.87249f, 2.25602f, -0.141785f, -2.83915f, 
		2.25602f, -0.141785f, -2.83915f, 2.25618f, -0.105324f, -2.82062f, 
		2.25618f, -0.105324f, -2.82062f, 2.25618f, -0.105324f, -2.82062f, 
		2.25618f, -0.105324f, -2.82062f, 2.25618f, -0.105324f, -2.82062f, 
		2.25633f, 0.0115820f, -2.85301f, 2.25635f, -0.0759341f, -2.79204f, 
		2.25640f, 1.01562f, -3.00838f, 2.25642f, -0.150749f, -2.82677f, 
		2.25642f, -0.150749f, -2.82677f, 2.25642f, -0.150749f, -2.82677f, 
		2.25646f, -0.139303f, -2.80045f, 2.25646f, -0.139303f, -2.80045f, 
		2.25646f, -0.139303f, -2.80045f, 2.25646f, -0.139303f, -2.80045f, 
		2.25665f, 0.848614f, -2.94462f, 2.25665f, 0.848614f, -2.94462f, 
		2.25665f, 0.848614f, -2.94462f, 2.25665f, 0.848614f, -2.94462f, 
		2.25665f, 0.848614f, -2.94462f, 2.25669f, 0.948411f, -3.12133f, 
		2.25693f, 0.441860f, -2.94411f, 2.25693f, 0.441860f, -2.94411f, 
		2.25693f, 0.441860f, -2.94411f, 2.25693f, 0.441860f, -2.94411f, 
		2.25723f, 0.876390f, -2.96744f, 2.25723f, 0.876390f, -2.96744f, 
		2.25723f, 0.876390f, -2.96744f, 2.25723f, 0.876390f, -2.96744f, 
		2.25748f, -0.133127f, -2.85448f, 2.25748f, -0.133127f, -2.85448f, 
		2.25748f, -0.133127f, -2.85448f, 2.25749f, -0.109099f, -2.80031f, 
		2.25749f, -0.109099f, -2.80031f, 2.25749f, -0.109099f, -2.80031f, 
		2.25749f, -0.109099f, -2.80031f, 2.25762f, -0.101057f, -2.82359f, 
		2.25762f, -0.101057f, -2.82359f, 2.25762f, -0.101057f, -2.82359f, 
		2.25779f, 0.368465f, -2.94781f, 2.25802f, -0.00574100f, -2.85153f, 
		2.25802f, -0.00574100f, -2.85153f, 2.25802f, -0.00574100f, -2.85153f, 
		2.25808f, -0.140641f, -2.80655f, 2.25808f, -0.140641f, -2.80655f, 
		2.25808f, -0.140641f, -2.80655f, 2.25815f, 0.845792f, -3.10682f, 
		2.25815f, -0.134768f, -2.87217f, 2.25815f, -0.134768f, -2.87217f, 
		2.25815f, -0.134768f, -2.87217f, 2.25815f, -0.134768f, -2.87217f, 
		2.25849f, -0.117131f, -2.83623f, 2.25849f, -0.117131f, -2.83623f, 
		2.25849f, -0.117131f, -2.83623f, 2.25864f, 0.527997f, -2.98242f, 
		2.25864f, 0.527997f, -2.98242f, 2.25864f, 0.527997f, -2.98242f, 
		2.25864f, 0.527997f, -2.98242f, 2.25867f, -0.124319f, -2.86374f, 
		2.25870f, 0.816312f, -2.95833f, 2.25870f, 0.816312f, -2.95833f, 
		2.25901f, -0.0902760f, -2.82722f, 2.25902f, -0.104328f, -2.82293f, 
		2.25902f, -0.104328f, -2.82293f, 2.25902f, -0.104328f, -2.82293f, 
		2.25908f, -0.118038f, -2.82183f, 2.25908f, -0.118038f, -2.82183f, 
		2.25908f, -0.118038f, -2.82183f, 2.25908f, -0.118038f, -2.82183f, 
		2.25909f, -0.105150f, -2.82788f, 2.25909f, -0.105150f, -2.82788f, 
		2.25909f, -0.105150f, -2.82788f, 2.25909f, -0.105150f, -2.82788f, 
		2.25909f, -0.105150f, -2.82788f, 2.25909f, -0.105150f, -2.82788f, 
		2.25910f, -0.147197f, -2.83753f, 2.25910f, -0.147197f, -2.83753f, 
		2.25910f, -0.147197f, -2.83753f, 2.25910f, -0.147197f, -2.83753f, 
		2.25910f, -0.147197f, -2.83753f, 2.25927f, -0.0696610f, -2.83459f, 
		2.25932f, -0.100656f, -2.80066f, 2.25932f, -0.100656f, -2.80066f, 
		2.25932f, -0.100656f, -2.80066f, 2.25932f, -0.100656f, -2.80066f, 
		2.25932f, -0.100656f, -2.80066f, 2.25935f, 0.318982f, -2.93182f, 
		2.25937f, -0.150784f, -2.83263f, 2.25937f, -0.150784f, -2.83263f, 
		2.25937f, -0.150784f, -2.83263f, 2.25937f, -0.150784f, -2.83263f, 
		2.25942f, 1.00342f, -3.07847f, 2.25954f, -0.861223f, -2.80713f, 
		2.25954f, -0.861223f, -2.80713f, 2.25975f, 0.809533f, -3.06513f, 
		2.25982f, -0.0771682f, -2.83145f, 2.25994f, -0.0217500f, -2.85759f, 
		2.26011f, -0.0901110f, -2.79784f, 2.26011f, -0.0901110f, -2.79784f, 
		2.26011f, -0.0901110f, -2.79784f, 2.26029f, 0.818553f, -2.93380f, 
		2.26029f, 0.818553f, -2.93380f, 2.26029f, -0.118812f, -2.81523f, 
		2.26029f, -0.118812f, -2.81523f, 2.26029f, -0.118812f, -2.81523f, 
		2.26038f, -0.0583869f, -2.79880f, 2.26044f, -0.136596f, -2.83785f, 
		2.26044f, -0.136596f, -2.83785f, 2.26063f, 0.0695620f, -2.85812f, 
		2.26063f, 0.0695620f, -2.85812f, 2.26067f, 0.320963f, -2.91597f, 
		2.26067f, 0.320963f, -2.91597f, 2.26067f, 0.320963f, -2.91597f, 
		2.26084f, 0.817327f, -2.94311f, 2.26084f, 0.817327f, -2.94311f, 
		2.26084f, 0.817327f, -2.94311f, 2.26084f, 0.817327f, -2.94311f, 
		2.26086f, -0.136587f, -2.85799f, 2.26092f, 0.0646020f, -2.87068f, 
		2.26104f, 0.838446f, -2.97536f, 2.26104f, 0.838446f, -2.97536f, 
		2.26130f, -0.117073f, -2.80298f, 2.26132f, 0.473014f, -2.95572f, 
		2.26132f, 0.473014f, -2.95572f, 2.26132f, 0.473014f, -2.95572f, 
		2.26132f, 0.473014f, -2.95572f, 2.26132f, 0.473014f, -2.95572f, 
		2.26161f, -0.107349f, -2.82172f, 2.26161f, -0.107349f, -2.82172f, 
		2.26161f, -0.107349f, -2.82172f, 2.26161f, -0.107349f, -2.82172f, 
		2.26161f, -0.107349f, -2.82172f, 2.26161f, -0.107349f, -2.82172f, 
		2.26163f, -0.137222f, -2.81903f, 2.26163f, -0.137222f, -2.81903f, 
		2.26163f, -0.137222f, -2.81903f, 2.26163f, -0.137222f, -2.81903f, 
		2.26163f, -0.137222f, -2.81903f, 2.26175f, 0.908554f, -3.11504f, 
		2.26218f, -0.122987f, -2.85359f, 2.26218f, -0.122987f, -2.85359f, 
		2.26232f, -0.0454270f, -2.85250f, 2.26234f, -0.127565f, -2.86820f, 
		2.26234f, -0.127565f, -2.86820f, 2.26246f, -0.127111f, -2.84979f, 
		2.26246f, -0.127111f, -2.84979f, 2.26246f, -0.127111f, -2.84979f, 
		2.26258f, 0.856063f, -2.97596f, 2.26258f, 0.856063f, -2.97596f, 
		2.26278f, -0.106739f, -2.81802f, 2.26278f, -0.106739f, -2.81802f, 
		2.26278f, -0.106739f, -2.81802f, 2.26278f, -0.106739f, -2.81802f, 
		2.26278f, -0.106739f, -2.81802f, 2.26278f, -0.106739f, -2.81802f, 
		2.26282f, -0.0793194f, -2.79712f, 2.26298f, -0.0367580f, -2.80548f, 
		2.26300f, 0.00454800f, -2.82142f, 2.26300f, 0.00454800f, -2.82142f, 
		2.26300f, -0.104422f, -2.83569f, 2.26320f, -0.105223f, -2.81952f, 
		2.26320f, -0.105223f, -2.81952f, 2.26332f, -0.0237580f, -2.86275f, 
		2.26351f, -0.121478f, -2.83944f, 2.26351f, -0.121478f, -2.83944f, 
		2.26359f, -0.0925820f, -2.79951f, 2.26373f, 0.871179f, -3.11074f, 
		2.26373f, 0.535618f, -2.89391f, 2.26373f, 0.535618f, -2.89391f, 
		2.26373f, 0.535618f, -2.89391f, 2.26373f, 0.535618f, -2.89391f, 
		2.26373f, 0.535618f, -2.89391f, 2.26373f, 0.535618f, -2.89391f, 
		2.26383f, 0.797363f, -2.95947f, 2.26383f, 0.797363f, -2.95947f, 
		2.26414f, 0.889649f, -2.93992f, 2.26414f, 0.889649f, -2.93992f, 
		2.26414f, 0.889649f, -2.93992f, 2.26431f, -0.114302f, -2.80939f, 
		2.26431f, -0.114302f, -2.80939f, 2.26431f, -0.114302f, -2.80939f, 
		2.26431f, -0.114302f, -2.80939f, 2.26431f, -0.114302f, -2.80939f, 
		2.26438f, 0.950722f, -3.12689f, 2.26448f, 0.957528f, -3.00408f, 
		2.26454f, 0.956791f, -3.07283f, 2.26465f, 0.119608f, -2.88911f, 
		2.26466f, 0.124766f, -2.87617f, 2.26466f, 0.124766f, -2.87617f, 
		2.26470f, -0.103618f, -2.80335f, 2.26470f, -0.103618f, -2.80335f, 
		2.26470f, -0.103618f, -2.80335f, 2.26470f, -0.103618f, -2.80335f, 
		2.26470f, -0.103618f, -2.80335f, 2.26473f, -0.120075f, -2.85235f, 
		2.26473f, -0.120075f, -2.85235f, 2.26476f, -0.132039f, -2.84950f, 
		2.26476f, -0.132039f, -2.84950f, 2.26476f, -0.132039f, -2.84950f, 
		2.26476f, -0.132039f, -2.84950f, 2.26476f, -0.132039f, -2.84950f, 
		2.26476f, -0.132039f, -2.84950f, 2.26484f, -0.0714816f, -2.79894f, 
		2.26499f, -0.0900590f, -2.83854f, 2.26499f, 0.481746f, -2.95474f, 
		2.26499f, 0.481746f, -2.95474f, 2.26499f, 0.481746f, -2.95474f, 
		2.26503f, -0.122839f, -2.85933f, 2.26503f, -0.122839f, -2.85933f, 
		2.26503f, -0.122839f, -2.85933f, 2.26503f, -0.122839f, -2.85933f, 
		2.26504f, 0.371989f, -2.90064f, 2.26550f, 0.793641f, -2.98960f, 
		2.26550f, 0.793641f, -2.98960f, 2.26591f, 0.842549f, -3.11160f, 
		2.26593f, 0.0180870f, -2.83137f, 2.26593f, 0.0180870f, -2.83137f, 
		2.26598f, -0.0432630f, -2.85932f, 2.26618f, 0.00747000f, -2.86476f, 
		2.26627f, -0.138161f, -2.83487f, 2.26642f, -0.0106160f, -2.81465f, 
		2.26655f, -0.139545f, -2.82231f, 2.26655f, -0.139545f, -2.82231f, 
		2.26655f, -0.139545f, -2.82231f, 2.26655f, -0.139545f, -2.82231f, 
		2.26674f, -0.0235440f, -2.81107f, 2.26678f, -0.0145130f, -2.86566f, 
		2.26684f, -0.111556f, -2.85327f, 2.26684f, -0.111556f, -2.85327f, 
		2.26684f, -0.00809500f, -2.86248f, 2.26684f, -0.00809500f, -2.86248f, 
		2.26684f, -0.00809500f, -2.86248f, 2.26684f, -0.00809500f, -2.86248f, 
		2.26684f, -0.00809500f, -2.86248f, 2.26689f, -0.120500f, -2.85841f, 
		2.26689f, -0.120500f, -2.85841f, 2.26689f, -0.120500f, -2.85841f, 
		2.26689f, -0.120500f, -2.85841f, 2.26701f, 0.899281f, -3.00030f, 
		2.26732f, -0.122184f, -2.84751f, 2.26732f, -0.122184f, -2.84751f, 
		2.26732f, -0.122184f, -2.84751f, 2.26734f, -0.104220f, -2.81051f, 
		2.26734f, -0.104220f, -2.81051f, 2.26734f, -0.104220f, -2.81051f, 
		2.26738f, 0.422355f, -2.95526f, 2.26738f, 0.422355f, -2.95526f, 
		2.26748f, -0.0993160f, -2.84133f, 2.26761f, 0.804328f, -3.06765f, 
		2.26771f, -0.135185f, -2.85277f, 2.26771f, -0.135185f, -2.85277f, 
		2.26771f, -0.135185f, -2.85277f, 2.26771f, -0.135185f, -2.85277f, 
		2.26781f, -0.113274f, -2.82021f, 2.26781f, -0.113274f, -2.82021f, 
		2.26781f, -0.113274f, -2.82021f, 2.26781f, -0.113274f, -2.82021f, 
		2.26788f, 0.871020f, -2.96026f, 2.26788f, 0.871020f, -2.96026f, 
		2.26788f, 0.871020f, -2.96026f, 2.26804f, -0.0947510f, -2.80281f, 
		2.26811f, -0.102592f, -2.81593f, 2.26811f, -0.102592f, -2.81593f, 
		2.26823f, -0.105310f, -2.84028f, 2.26823f, -0.105310f, -2.84028f, 
		2.26835f, 0.902540f, -2.97288f, 2.26835f, 0.902540f, -2.97288f, 
		2.26835f, 0.902540f, -2.97288f, 2.26835f, 0.902540f, -2.97288f, 
		2.26849f, 0.772844f, -2.96044f, 2.26849f, 0.772844f, -2.96044f, 
		2.26849f, 0.772844f, -2.96044f, 2.26853f, -0.139861f, -2.82843f, 
		2.26853f, -0.139861f, -2.82843f, 2.26853f, -0.139861f, -2.82843f, 
		2.26861f, 0.839051f, -3.01536f, 2.26874f, -0.110951f, -2.85933f, 
		2.26874f, -0.110951f, -2.85933f, 2.26874f, -0.110951f, -2.85933f, 
		2.26874f, -0.110951f, -2.85933f, 2.26874f, 0.823993f, -2.93467f, 
		2.26874f, 0.823993f, -2.93467f, 2.26874f, 0.823993f, -2.93467f, 
		2.26876f, -0.125956f, -2.86340f, 2.26876f, -0.125956f, -2.86340f, 
		2.26886f, -0.0932322f, -2.84600f, 2.26889f, 0.173962f, -2.90723f, 
		2.26894f, 0.320556f, -2.94575f, 2.26921f, 0.179224f, -2.89429f, 
		2.26921f, 0.179224f, -2.89429f, 2.26925f, 0.845809f, -3.06473f, 
		2.26951f, 0.822912f, -2.94560f, 2.26951f, 0.822912f, -2.94560f, 
		2.26951f, 0.822912f, -2.94560f, 2.26971f, 0.908708f, -3.12026f, 
		2.26976f, -0.128612f, -2.82257f, 2.26976f, -0.128612f, -2.82257f, 
		2.26976f, -0.128612f, -2.82257f, 2.26988f, -0.0842860f, -2.84741f, 
		2.26988f, -0.0702970f, -2.85076f, 2.27000f, 0.838241f, -2.93490f, 
		2.27000f, 0.838241f, -2.93490f, 2.27000f, 0.838241f, -2.93490f, 
		2.27008f, -0.0437897f, -2.80797f, 2.27017f, -0.105871f, -2.81880f, 
		2.27017f, -0.105871f, -2.81880f, 2.27017f, -0.105871f, -2.81880f, 
		2.27034f, -0.100713f, -2.84377f, 2.27034f, -0.100713f, -2.84377f, 
		2.27040f, 0.0605720f, -2.88212f, 2.27047f, -0.134986f, -2.85813f, 
		2.27047f, -0.134986f, -2.85813f, 2.27047f, -0.134986f, -2.85813f, 
		2.27047f, -0.134986f, -2.85813f, 2.27054f, -0.112224f, -2.84725f, 
		2.27054f, -0.112224f, -2.84725f, 2.27054f, -0.112224f, -2.84725f, 
		2.27067f, -0.119425f, -2.83611f, 2.27078f, -0.0784630f, -2.84870f, 
		2.27084f, 0.837318f, -2.94576f, 2.27084f, 0.837318f, -2.94576f, 
		2.27084f, 0.837318f, -2.94576f, 2.27090f, 0.836007f, -2.96759f, 
		2.27090f, 0.836007f, -2.96759f, 2.27093f, -0.131202f, -2.86218f, 
		2.27093f, -0.131202f, -2.86218f, 2.27093f, -0.131202f, -2.86218f, 
		2.27095f, 0.0711540f, -2.84931f, 2.27095f, 0.0711540f, -2.84931f, 
		2.27095f, 0.0711540f, -2.84931f, 2.27095f, 0.0711540f, -2.84931f, 
		2.27099f, -0.0608420f, -2.85849f, 2.27104f, 0.267276f, -2.93228f, 
		2.27128f, -0.0982894f, -2.84933f, 2.27128f, -0.0982894f, -2.84933f, 
		2.27128f, -0.0982894f, -2.84933f, 2.27137f, -0.0838030f, -2.80348f, 
		2.27151f, -0.0312910f, -2.81195f, 2.27154f, 0.912302f, -3.06814f, 
		2.27168f, -0.122684f, -2.86157f, 2.27168f, -0.122684f, -2.86157f, 
		2.27180f, 0.869310f, -3.11573f, 2.27190f, 0.269214f, -2.91783f, 
		2.27190f, 0.269214f, -2.91783f, 2.27193f, -0.124637f, -2.84609f, 
		2.27193f, -0.124637f, -2.84609f, 2.27193f, -0.124637f, -2.84609f, 
		2.27193f, -0.124637f, -2.84609f, 2.27193f, -0.124637f, -2.84609f, 
		2.27193f, -0.124637f, -2.84609f, 2.27200f, 0.866201f, -3.01299f, 
		2.27255f, 0.230491f, -2.91091f, 2.27255f, 0.230491f, -2.91091f, 
		2.27265f, 0.959556f, -3.07577f, 2.27271f, 0.852424f, -2.96837f, 
		2.27271f, 0.852424f, -2.96837f, 2.27278f, 0.875531f, -3.06586f, 
		2.27298f, -0.116074f, -2.82372f, 2.27298f, -0.116074f, -2.82372f, 
		2.27298f, -0.116074f, -2.82372f, 2.27298f, -0.116074f, -2.82372f, 
		2.27298f, -0.116074f, -2.82372f, 2.27300f, -0.0748305f, -2.80516f, 
		2.27306f, -0.0952904f, -2.81327f, 2.27306f, -0.0952904f, -2.81327f, 
		2.27306f, -0.0952904f, -2.81327f, 2.27318f, 0.246887f, -2.93204f, 
		2.27354f, -0.0887200f, -2.85436f, 2.27379f, 0.480275f, -2.89306f, 
		2.27379f, 0.480275f, -2.89306f, 2.27383f, 0.798373f, -2.94878f, 
		2.27383f, 0.798373f, -2.94878f, 2.27383f, 0.798373f, -2.94878f, 
		2.27386f, -0.119906f, -2.82955f, 2.27386f, -0.119906f, -2.82955f, 
		2.27386f, -0.119906f, -2.82955f, 2.27386f, -0.119906f, -2.82955f, 
		2.27386f, -0.119906f, -2.82955f, 2.27389f, 0.252773f, -2.91766f, 
		2.27389f, 0.252773f, -2.91766f, 2.27403f, -0.0969656f, -2.85669f, 
		2.27403f, -0.0969656f, -2.85669f, 2.27403f, -0.0969656f, -2.85669f, 
		2.27403f, -0.0969656f, -2.85669f, 2.27403f, -0.0969656f, -2.85669f, 
		2.27411f, -0.107018f, -2.83761f, 2.27411f, -0.107018f, -2.83761f, 
		2.27411f, -0.107018f, -2.83761f, 2.27420f, 0.115464f, -2.90077f, 
		2.27441f, -0.110930f, -2.86180f, 2.27441f, -0.110930f, -2.86180f, 
		2.27450f, 0.323519f, -2.90505f, 2.27461f, -0.102423f, -2.84032f, 
		2.27461f, -0.102423f, -2.84032f, 2.27461f, -0.102423f, -2.84032f, 
		2.27461f, -0.102423f, -2.84032f, 2.27461f, -0.102423f, -2.84032f, 
		2.27461f, -0.102423f, -2.84032f, 2.27461f, -0.102423f, -2.84032f, 
		2.27473f, -0.101292f, -2.84388f, 2.27473f, -0.101292f, -2.84388f, 
		2.27473f, -0.101292f, -2.84388f, 2.27473f, -0.101292f, -2.84388f, 
		2.27507f, -0.0155100f, -2.87253f, 2.27507f, -0.0155100f, -2.87253f, 
		2.27534f, -0.0598517f, -2.80981f, 2.27547f, -0.0867401f, -2.81221f, 
		2.27553f, -0.0978380f, -2.81736f, 2.27559f, 0.126585f, -2.86699f, 
		2.27610f, 0.373766f, -2.95330f, 2.27610f, 0.373766f, -2.95330f, 
		2.27615f, -0.125298f, -2.85876f, 2.27617f, -0.0262350f, -2.87354f, 
		2.27617f, -0.0262350f, -2.87354f, 2.27620f, -0.126651f, -2.84839f, 
		2.27620f, -0.126651f, -2.84839f, 2.27620f, -0.126651f, -2.84839f, 
		2.27620f, -0.126651f, -2.84839f, 2.27646f, 0.891865f, -2.97646f, 
		2.27646f, 0.891865f, -2.97646f, 2.27646f, 0.891865f, -2.97646f, 
		2.27647f, -0.106513f, -2.82290f, 2.27647f, -0.106513f, -2.82290f, 
		2.27647f, -0.106513f, -2.82290f, 2.27712f, -0.0352971f, -2.81635f, 
		2.27758f, 0.961008f, -3.00142f, 2.27762f, 0.842568f, -3.06723f, 
		2.27769f, -0.127066f, -2.85364f, 2.27769f, -0.127066f, -2.85364f, 
		2.27769f, -0.127066f, -2.85364f, 2.27769f, -0.127066f, -2.85364f, 
		2.27769f, -0.127066f, -2.85364f, 2.27782f, 0.799234f, -2.94291f, 
		2.27782f, 0.799234f, -2.94291f, 2.27782f, 0.799234f, -2.94291f, 
		2.27782f, 0.799234f, -2.94291f, 2.27797f, -0.100670f, -2.86033f, 
		2.27797f, -0.100670f, -2.86033f, 2.27800f, 0.835229f, -2.99122f, 
		2.27800f, 0.835229f, -2.99122f, 2.27825f, 0.169812f, -2.91881f, 
		2.27844f, -0.106789f, -2.83066f, 2.27844f, -0.106789f, -2.83066f, 
		2.27844f, -0.106789f, -2.83066f, 2.27863f, 0.773927f, -2.94266f, 
		2.27863f, 0.773927f, -2.94266f, 2.27863f, 0.773927f, -2.94266f, 
		2.27879f, -0.108304f, -2.84407f, 2.27879f, -0.108304f, -2.84407f, 
		2.27879f, -0.108304f, -2.84407f, 2.27879f, -0.108304f, -2.84407f, 
		2.27915f, -0.0772650f, -2.81681f, 2.27954f, -0.100368f, -2.83697f, 
		2.27954f, -0.100368f, -2.83697f, 2.27954f, -0.100368f, -2.83697f, 
		2.27954f, -0.100368f, -2.83697f, 2.27961f, -0.0424630f, -2.87266f, 
		2.27961f, -0.0424630f, -2.87266f, 2.27962f, 0.846495f, -2.96527f, 
		2.27976f, 0.903504f, -2.95321f, 2.27976f, 0.903504f, -2.95321f, 
		2.27976f, 0.903504f, -2.95321f, 2.27987f, -0.0982440f, -2.82217f, 
		2.27997f, 0.426732f, -2.89760f, 2.27997f, 0.426732f, -2.89760f, 
		2.28001f, 0.268367f, -2.94503f, 2.28003f, 0.912659f, -3.07082f, 
		2.28013f, -0.0569490f, -2.81846f, 2.28030f, -0.0946990f, -2.86098f, 
		2.28030f, -0.0946990f, -2.86098f, 2.28046f, 0.181190f, -2.88498f, 
		2.28046f, 0.00644900f, -2.86950f, 2.28046f, 0.00644900f, -2.86950f, 
		2.28061f, 0.824035f, -2.96588f, 2.28066f, 0.00321900f, -2.82914f, 
		2.28066f, 0.00321900f, -2.82914f, 2.28066f, 0.00321900f, -2.82914f, 
		2.28072f, 0.861580f, -2.98562f, 2.28072f, 0.861580f, -2.98562f, 
		2.28088f, -0.0242190f, -2.82417f, 2.28092f, -0.0118530f, -2.82580f, 
		2.28108f, 0.884205f, -2.95539f, 2.28108f, 0.884205f, -2.95539f, 
		2.28108f, 0.884205f, -2.95539f, 2.28108f, 0.884205f, -2.95539f, 
		2.28125f, 0.478489f, -2.94209f, 2.28125f, 0.478489f, -2.94209f, 
		2.28125f, 0.478489f, -2.94209f, 2.28133f, 0.873897f, -3.06842f, 
		2.28136f, 0.533666f, -2.91650f, 2.28136f, 0.533666f, -2.91650f, 
		2.28136f, 0.533666f, -2.91650f, 2.28136f, 0.533666f, -2.91650f, 
		2.28164f, 0.220380f, -2.93688f, 2.28198f, -0.0999400f, -2.84083f, 
		2.28198f, -0.0999400f, -2.84083f, 2.28198f, -0.0999400f, -2.84083f, 
		2.28198f, -0.0999400f, -2.84083f, 2.28199f, 0.0175610f, -2.83277f, 
		2.28199f, 0.0175610f, -2.83277f, 2.28199f, 0.0175610f, -2.83277f, 
		2.28199f, 0.0175610f, -2.83277f, 2.28199f, 0.0175610f, -2.83277f, 
		2.28199f, 0.0175610f, -2.83277f, 2.28228f, 0.517139f, -2.94667f, 
		2.28228f, 0.517139f, -2.94667f, 2.28228f, 0.517139f, -2.94667f, 
		2.28228f, 0.517139f, -2.94667f, 2.28228f, 0.517139f, -2.94667f, 
		2.28240f, -0.106331f, -2.85762f, 2.28240f, -0.106331f, -2.85762f, 
		2.28240f, -0.106331f, -2.85762f, 2.28241f, -0.00878000f, -2.86970f, 
		2.28241f, -0.00878000f, -2.86970f, 2.28241f, -0.00878000f, -2.86970f, 
		2.28241f, -0.00878000f, -2.86970f, 2.28242f, -0.0594900f, -2.86967f, 
		2.28242f, -0.0594900f, -2.86967f, 2.28262f, -0.0881980f, -2.86216f, 
		2.28262f, -0.0881980f, -2.86216f, 2.28278f, -0.0816942f, -2.86313f, 
		2.28278f, -0.0816942f, -2.86313f, 2.28278f, -0.0872719f, -2.82246f, 
		2.28278f, -0.0872719f, -2.82246f, 2.28278f, -0.0872719f, -2.82246f, 
		2.28288f, -0.0974380f, -2.82831f, 2.28300f, 0.244976f, -2.94495f, 
		2.28319f, 0.883656f, -2.95487f, 2.28319f, 0.883656f, -2.95487f, 
		2.28319f, 0.883656f, -2.95487f, 2.28322f, -0.0713810f, -2.86517f, 
		2.28322f, -0.0713810f, -2.86517f, 2.28352f, -0.108215f, -2.84660f, 
		2.28352f, -0.108215f, -2.84660f, 2.28352f, -0.108215f, -2.84660f, 
		2.28352f, -0.108215f, -2.84660f, 2.28352f, -0.108215f, -2.84660f, 
		2.28417f, 0.271326f, -2.90792f, 2.28429f, -0.0349610f, -2.82747f, 
		2.28442f, 0.0597110f, -2.88664f, 2.28442f, 0.0597110f, -2.88664f, 
		2.28452f, -0.0943500f, -2.83465f, 2.28452f, -0.0943500f, -2.83465f, 
		2.28452f, -0.0943500f, -2.83465f, 2.28475f, 0.325055f, -2.95063f, 
		2.28475f, 0.325055f, -2.95063f, 2.28482f, 0.232720f, -2.90088f, 
		2.28515f, -0.0520705f, -2.82675f, 2.28618f, -0.0863815f, -2.83070f, 
		2.28641f, -0.0788270f, -2.82995f, 2.28641f, -0.0788270f, -2.82995f, 
		2.28641f, -0.0788270f, -2.82995f, 2.28661f, 0.254605f, -2.90731f, 
		2.28661f, 0.254605f, -2.90731f, 2.28661f, 0.254605f, -2.90731f, 
		2.28670f, 0.377567f, -2.90147f, 2.28670f, 0.377567f, -2.90147f, 
		2.28681f, 0.0707840f, -2.85052f, 2.28681f, 0.0707840f, -2.85052f, 
		2.28722f, 0.483753f, -2.91252f, 2.28722f, 0.483753f, -2.91252f, 
		2.28722f, 0.483753f, -2.91252f, 2.28737f, 0.425720f, -2.94069f, 
		2.28763f, -0.0940643f, -2.85789f, 2.28766f, -0.0245210f, -2.86952f, 
		2.28766f, -0.0245210f, -2.86952f, 2.28766f, -0.0245210f, -2.86952f, 
		2.28858f, -0.0356730f, -2.83504f, 2.28865f, 0.114635f, -2.90527f, 
		2.28865f, 0.114635f, -2.90527f, 2.28982f, -0.0944096f, -2.84345f, 
		2.28982f, -0.0944096f, -2.84345f, 2.28982f, -0.0944096f, -2.84345f, 
		2.28992f, -0.0973516f, -2.85073f, 2.28992f, -0.0973516f, -2.85073f, 
		2.28992f, -0.0973516f, -2.85073f, 2.29009f, -0.0876960f, -2.85936f, 
		2.29009f, -0.0876960f, -2.85936f, 2.29009f, -0.0876960f, -2.85936f, 
		2.29020f, -0.0153820f, -2.84112f, 2.29045f, -0.0284570f, -2.84044f, 
		2.29063f, -0.0397620f, -2.86880f, 2.29063f, -0.0397620f, -2.86880f, 
		2.29065f, -0.00105700f, -2.84329f, 2.29135f, -0.0790593f, -2.86145f, 
		2.29135f, -0.0790593f, -2.86145f, 2.29158f, 0.00750400f, -2.86040f, 
		2.29158f, 0.00750400f, -2.86040f, 2.29204f, 0.126282f, -2.86805f, 
		2.29204f, 0.126282f, -2.86805f, 2.29204f, -0.0644990f, -2.86450f, 
		2.29204f, -0.0644990f, -2.86450f, 2.29215f, -0.0541740f, -2.86679f, 
		2.29215f, -0.0541740f, -2.86679f, 2.29223f, 0.0141610f, -2.84432f, 
		2.29230f, -0.0624350f, -2.84374f, 2.29230f, -0.0624350f, -2.84374f, 
		2.29230f, -0.0624350f, -2.84374f, 2.29231f, -0.0839431f, -2.84341f, 
		2.29233f, 0.429999f, -2.91473f, 2.29233f, 0.429999f, -2.91473f, 
		2.29240f, -0.0444970f, -2.84402f, 2.29272f, 0.168988f, -2.92313f, 
		2.29272f, 0.168988f, -2.92313f, 2.29306f, -0.0849190f, -2.85146f, 
		2.29312f, 0.328237f, -2.90593f, 2.29312f, 0.328237f, -2.90593f, 
		2.29349f, -0.0764128f, -2.85258f, 2.29367f, -0.00567564f, -2.85916f, 
		2.29367f, -0.00567564f, -2.85916f, 2.29367f, -0.00567564f, -2.85916f, 
		2.29384f, 0.376661f, -2.94028f, 2.29419f, -0.0344350f, -2.85680f, 
		2.29438f, 0.272254f, -2.94953f, 2.29438f, 0.272254f, -2.94953f, 
		2.29458f, -0.0486160f, -2.85575f, 2.29565f, 0.0607940f, -2.87754f, 
		2.29565f, 0.0607940f, -2.87754f, 2.29668f, 0.0674610f, -2.86176f, 
		2.29702f, 0.180970f, -2.88585f, 2.29702f, 0.180970f, -2.88585f, 
		2.29713f, 0.219659f, -2.94144f, 2.29713f, 0.219659f, -2.94144f, 
		2.29798f, 0.380455f, -2.91695f, 2.29798f, 0.380455f, -2.91695f, 
		2.29822f, 0.821592f, -2.96719f, 2.29822f, 0.821592f, -2.96719f, 
		2.29866f, 0.246994f, -2.95000f, 2.29866f, 0.246994f, -2.95000f, 
		2.29982f, 0.327325f, -2.93950f, 2.30052f, 0.115933f, -2.89577f, 
		2.30052f, 0.115933f, -2.89577f, 2.30094f, 0.275181f, -2.90866f, 
		2.30094f, 0.275181f, -2.90866f, 2.30166f, 0.822164f, -2.96305f, 
		2.30166f, 0.822164f, -2.96305f, 2.30200f, 0.122868f, -2.87951f, 
		2.30227f, 0.815258f, -2.99166f, 2.30227f, 0.815258f, -2.99166f, 
		2.30269f, 0.232488f, -2.90177f, 2.30269f, 0.232488f, -2.90177f, 
		2.30304f, 0.330694f, -2.91939f, 2.30304f, 0.330694f, -2.91939f, 
		2.30469f, 0.254723f, -2.90800f, 2.30469f, 0.254723f, -2.90800f, 
		2.30471f, 0.875773f, -3.00124f, 2.30471f, 0.875773f, -3.00124f, 
		2.30471f, 0.875773f, -3.00124f, 2.30492f, 0.170530f, -2.91352f, 
		2.30492f, 0.170530f, -2.91352f, 2.30492f, 0.170530f, -2.91352f, 
		2.30517f, 0.865742f, -2.97624f, 2.30517f, 0.865742f, -2.97624f, 
		2.30517f, 0.865742f, -2.97624f, 2.30681f, 0.177570f, -2.89723f, 
		2.30771f, 0.274294f, -2.93939f, 2.30876f, 0.865814f, -2.97208f, 
		2.30876f, 0.865814f, -2.97208f, 2.30876f, 0.865814f, -2.97208f, 
		2.31019f, 0.277368f, -2.92103f, 2.31019f, 0.277368f, -2.92103f, 
		2.31046f, 0.221458f, -2.93110f, 2.31046f, 0.221458f, -2.93110f, 
		2.31046f, 0.221458f, -2.93110f, 2.31046f, 0.221458f, -2.93110f, 
		2.31046f, 0.221458f, -2.93110f, 2.31046f, 0.221458f, -2.93110f, 
		2.31247f, 0.249272f, -2.93953f, 2.31247f, 0.249272f, -2.93953f, 
		2.31247f, 0.249272f, -2.93953f, 2.31247f, 0.249272f, -2.93953f, 
		2.31297f, 0.229037f, -2.91389f, 2.31297f, 0.229037f, -2.91389f, 
		2.31297f, 0.229037f, -2.91389f, 2.31478f, 0.255240f, -2.92090f, 
		2.31478f, 0.255240f, -2.92090f, 2.31547f, 0.816753f, -2.97567f, 
		2.31547f, 0.816753f, -2.97567f, 2.31968f, 0.875237f, -2.98374f, 
		2.31968f, 0.875237f, -2.98374f, 2.31968f, 0.875237f, -2.98374f
	};
	static const GLfloat NormalData[] = {
		-0.897080f, 0.290990f, 0.332524f, -0.855102f, 0.241924f, -0.458555f, -0.900480f, 0.385572f, 0.201171f, 
		-0.897665f, 0.404459f, -0.174957f, -0.281915f, -0.958967f, -0.0301181f, 
		-0.931131f, -0.0426590f, 0.362180f, -0.878502f, 0.0220756f, -0.477228f, 
		-0.990811f, -0.0440538f, -0.127880f, -0.990649f, -0.0695227f, -0.117397f, 
		-0.997471f, -0.00182393f, 0.0710506f, -0.998450f, -0.0161942f, -0.0532470f, 
		-0.996957f, 0.0718708f, 0.0301748f, -0.661303f, 0.741974f, -0.110239f, 
		-0.827393f, 0.534293f, -0.173065f, -0.576061f, 0.815489f, -0.0559575f, 
		-0.951773f, -0.294473f, -0.0860990f, -0.830178f, -0.462099f, -0.311880f, 
		-0.991191f, -0.118448f, 0.0592508f, -0.850523f, 0.276877f, 0.447157f, 
		-0.753799f, 0.364557f, 0.546704f, -0.805358f, 0.321054f, 0.498320f, 
		-0.950476f, -0.00708319f, -0.310717f, -0.996208f, 0.0730437f, -0.0472675f, 
		-0.990048f, 0.0492370f, -0.131839f, -0.930418f, 0.119510f, 0.346467f, 
		-0.660394f, 0.471359f, 0.584551f, -0.968198f, 0.00392753f, 0.250155f, 
		-0.503139f, 0.561315f, 0.657097f, -0.994642f, 0.0274132f, -0.0996830f, 
		-0.993618f, 0.0801637f, 0.0793583f, -0.983097f, 0.100622f, 0.152956f, 
		-0.720718f, -0.264834f, -0.640647f, -0.445552f, -0.329554f, -0.832393f, 
		-0.874664f, -0.224730f, -0.429488f, -0.793952f, -0.313687f, -0.520808f, 
		-0.545174f, -0.415757f, -0.727964f, -0.786908f, 0.254655f, 0.562073f, 
		-0.980637f, 0.186295f, -0.0603800f, -0.938811f, 0.151271f, -0.309437f, 
		-0.459721f, -0.678979f, 0.572401f, 0.0502575f, -0.0622552f, 0.996794f, 
		-0.888472f, -0.454327f, -0.0648403f, -0.960751f, -0.0606588f, 0.270698f, 
		-0.915569f, -0.402077f, -0.00824454f, -0.950804f, -0.297731f, 0.0856071f, 
		-0.841123f, -0.525018f, -0.129875f, -0.882833f, -0.152255f, -0.444324f, 
		-0.656420f, -0.294578f, -0.694504f, -0.830331f, -0.178447f, -0.527927f, 
		-0.575544f, -0.652651f, -0.492743f, -0.919910f, -0.0807468f, -0.383725f, 
		-0.593843f, -0.224118f, -0.772737f, -0.311623f, -0.297508f, -0.902430f, 
		-0.826672f, -0.141795f, -0.544525f, -0.823012f, 0.200478f, 0.531470f, 
		-0.583577f, 0.272129f, 0.765104f, -0.672746f, 0.246069f, 0.697756f, 
		-0.768771f, 0.156002f, 0.620205f, -0.703100f, 0.174400f, 0.689373f, 
		-0.481403f, 0.186285f, 0.856475f, -0.884013f, 0.114792f, -0.453149f, 
		-0.829437f, 0.293804f, 0.475093f, -0.883051f, 0.274793f, 0.380408f, 
		-0.785044f, 0.296282f, 0.543987f, -0.688994f, 0.295022f, 0.662004f, 
		-0.614434f, 0.249369f, 0.748522f, -0.960472f, -0.0879423f, 0.264122f, 
		-0.864101f, -0.500854f, -0.0497425f, -0.919347f, -0.392167f, 0.0317101f, 
		-0.537521f, 0.387744f, 0.748816f, 0.364836f, 0.468374f, 0.804687f, 
		-0.531047f, 0.511792f, 0.675321f, 0.353623f, 0.707424f, 0.611966f, 
		-0.507899f, -0.754535f, -0.415590f, -0.938141f, 0.345250f, -0.0263376f, 
		-0.113698f, -0.507064f, -0.854376f, 0.284217f, -0.374615f, -0.882544f, 
		0.0864513f, -0.467954f, -0.879514f, -0.496187f, 0.677072f, 0.543482f, 
		-0.951435f, -0.0899721f, 0.294408f, -0.352225f, 0.280415f, 0.892919f, 
		0.111184f, 0.248446f, 0.962244f, -0.0854960f, 0.276420f, 0.957226f, 
		-0.991890f, 0.0991986f, 0.0794555f, -0.992907f, 0.0173160f, 0.117625f, 
		-0.972833f, -0.0922188f, -0.212347f, -0.965539f, 0.125482f, 0.228009f, 
		-0.936914f, -0.0761804f, -0.341158f, -0.854893f, -0.169503f, -0.490334f, 
		-0.761853f, -0.646963f, 0.0319389f, -0.920693f, -0.291988f, 0.258972f, 
		-0.637283f, -0.768923f, -0.0512730f, -0.918602f, -0.135985f, 0.371050f, 
		-0.281568f, -0.298327f, -0.911987f, 0.0933523f, -0.350093f, -0.932052f, 
		0.179129f, -0.348951f, -0.919862f, -0.303544f, -0.744589f, -0.594516f, 
		-0.00859917f, -0.682654f, -0.730691f, 0.438386f, -0.499500f, -0.747206f, 
		0.263786f, -0.548972f, -0.793125f, -0.578216f, -0.738687f, -0.346421f, 
		-0.801564f, -0.109565f, -0.587785f, -0.668021f, 0.412042f, 0.619653f, 
		-0.755879f, 0.344484f, 0.556757f, -0.970319f, 0.126647f, 0.206014f, 
		-0.967310f, -0.215399f, -0.133846f, -0.840279f, -0.365377f, -0.400539f, 
		-0.770063f, -0.379545f, -0.512785f, 0.0317058f, -0.387150f, -0.921471f, 
		-0.411440f, -0.588249f, -0.696190f, -0.316657f, -0.484126f, -0.815690f, 
		-0.463011f, -0.454478f, -0.760967f, -0.279305f, -0.833189f, -0.477268f, 
		0.391440f, -0.415685f, -0.820963f, -0.278521f, 0.258588f, 0.924964f, 
		0.381874f, 0.234277f, 0.894028f, 0.0346435f, 0.257526f, 0.965650f, 
		-0.952189f, -0.0607973f, 0.299398f, -0.951059f, -0.308667f, 0.0145562f, 
		-0.976768f, -0.159123f, 0.143540f, -0.933546f, -0.353869f, -0.0571623f, 
		-0.886090f, -0.444170f, -0.132503f, -0.928322f, 0.316968f, 0.194291f, 
		-0.759087f, 0.291870f, 0.581893f, -0.427745f, 0.241751f, 0.870971f, 
		-0.549204f, 0.276051f, 0.788778f, 0.268973f, 0.876648f, 0.398926f, 
		-0.500427f, 0.607347f, 0.617011f, -0.199098f, -0.978214f, -0.0587961f, 
		-0.988111f, 0.0614815f, -0.140913f, -0.954677f, 0.218505f, 0.202109f, 
		-0.983883f, 0.153852f, 0.0911260f, -0.486606f, -0.868345f, 0.0958727f, 
		-0.883312f, -0.105519f, 0.456756f, -0.871015f, 0.221877f, -0.438296f, 
		0.402758f, 0.0174859f, 0.915139f, -0.493134f, 0.221152f, 0.841374f, 
		-0.526263f, 0.552927f, 0.646002f, -0.962398f, 0.00223814f, 0.271634f, 
		-0.974079f, 0.122336f, 0.190274f, -0.970041f, 0.193721f, -0.146603f, 
		-0.812921f, 0.0678937f, 0.578402f, -0.680846f, 0.0906221f, 0.726799f, 
		-0.555971f, -0.422734f, -0.715676f, -0.751742f, -0.401640f, -0.523039f, 
		-0.674164f, -0.293846f, -0.677612f, -0.465580f, -0.300681f, -0.832362f, 
		-0.468308f, 0.680067f, 0.564090f, -0.884090f, -0.157940f, 0.439818f, 
		-0.967439f, 0.221312f, -0.122816f, -0.996287f, 0.0775751f, 0.0373429f, 
		-0.502669f, 0.201007f, 0.840785f, -0.867061f, -0.215957f, -0.448963f, 
		-0.766139f, 0.0703377f, -0.638814f, -0.946684f, -0.00212071f, -0.322156f, 
		-0.915688f, 0.221588f, 0.335281f, -0.975717f, 0.160409f, 0.149149f, 
		-0.868533f, -0.0721196f, -0.490356f, 0.760515f, 0.347506f, 0.548503f, 
		0.689218f, 0.323296f, 0.648427f, 0.540473f, 0.262106f, 0.799493f, 
		0.287997f, 0.312641f, 0.905159f, 0.754005f, 0.240366f, 0.611311f, 
		0.551830f, 0.382750f, 0.740936f, -0.889568f, -0.179404f, 0.420098f, 
		-0.279305f, -0.833189f, -0.477268f, -0.925935f, -0.111609f, 0.360816f, 
		-0.978627f, -0.191650f, -0.0745689f, -0.954783f, -0.250253f, -0.160508f, 
		-0.965038f, -0.158160f, 0.209017f, -0.935817f, -0.228570f, -0.268332f, 
		0.698348f, -0.330488f, -0.634892f, 0.607353f, 0.613540f, 0.504669f, 
		-0.600803f, 0.326871f, 0.729514f, -0.734443f, 0.306115f, 0.605711f, 
		-0.820615f, 0.290044f, 0.492408f, -0.676349f, 0.314367f, 0.666128f, 
		-0.776443f, 0.304549f, 0.551713f, -0.155071f, -0.771327f, -0.617258f, 
		0.139707f, -0.719574f, -0.680217f, 0.425400f, -0.584765f, -0.690714f, 
		-0.328146f, -0.771016f, -0.545760f, -0.977692f, -0.0761029f, 0.195772f, 
		-0.124735f, -0.968389f, 0.216019f, 0.367840f, -0.186722f, 0.910949f, 
		-0.929076f, -0.00147430f, 0.369885f, -0.0946352f, -0.836656f, -0.539491f, 
		-0.501337f, -0.558754f, -0.660647f, -0.931135f, -0.228084f, -0.284543f, 
		-0.241758f, -0.746386f, -0.620049f, -0.975451f, -0.184988f, -0.119477f, 
		-0.00694905f, 0.946200f, 0.323509f, -0.117515f, 0.913477f, 0.389550f, 
		-0.512981f, 0.676887f, 0.527897f, -0.569825f, -0.696968f, -0.435357f, 
		-0.384314f, -0.917066f, -0.106270f, -0.590233f, -0.806809f, -0.0261476f, 
		-0.795820f, -0.0995360f, 0.597296f, 0.488024f, 0.0182285f, 0.872640f, 
		-0.399240f, 0.307814f, 0.863631f, 0.418983f, 0.0918911f, 0.903333f, 
		0.187486f, 0.192283f, 0.963263f, 0.752504f, 0.0183571f, 0.658331f, 
		0.859299f, -0.0632092f, 0.507553f, -0.882943f, -0.222822f, -0.413234f, 
		-0.961892f, 0.165791f, -0.217433f, -0.979977f, 0.195072f, -0.0399114f, 
		-0.964528f, 0.228505f, -0.132181f, -0.981904f, 0.141406f, -0.125972f, 
		-0.983772f, 0.0222848f, 0.178035f, 0.688575f, -0.323646f, -0.648936f, 
		-0.750712f, 0.645306f, -0.141462f, -0.424571f, -0.627731f, 0.652451f, 
		0.570699f, -0.460740f, -0.679721f, 0.715697f, -0.343325f, -0.608199f, 
		0.767473f, -0.280803f, -0.576312f, -0.627667f, -0.165312f, -0.760728f, 
		-0.922402f, 0.283808f, -0.261969f, -0.378449f, -0.565355f, -0.732905f, 
		-0.966147f, -0.257835f, 0.00895819f, 0.399625f, 0.0242243f, 0.916359f, 
		-0.898434f, 0.258141f, 0.355218f, 0.362530f, 0.302895f, 0.881377f, 
		0.372566f, 0.181088f, 0.910166f, -0.664005f, -0.299284f, -0.685220f, 
		-0.729471f, -0.220069f, -0.647643f, -0.606682f, -0.278622f, -0.744518f, 
		-0.510019f, -0.324879f, -0.796451f, -0.808222f, -0.197678f, -0.554707f, 
		-0.671601f, -0.268860f, -0.690411f, 0.903422f, -0.162083f, -0.396936f, 
		0.875733f, 0.0809760f, 0.475956f, 0.445535f, -0.591472f, -0.672056f, 
		-0.313713f, -0.831381f, -0.458682f, -0.808356f, -0.587083f, -0.0435289f, 
		-0.873984f, -0.481920f, 0.0624932f, -0.855724f, -0.517056f, 0.0197545f, 
		0.615652f, -0.406429f, -0.675121f, -0.525066f, 0.392838f, 0.754973f, 
		0.380898f, 0.505012f, 0.774519f, 0.593244f, 0.229612f, 0.771583f, 
		0.304652f, 0.309253f, 0.900861f, 0.792163f, 0.180995f, 0.582854f, 
		-0.946621f, -0.233002f, -0.222751f, -0.0806426f, -0.0230433f, 0.996477f, 
		-0.269527f, -0.767907f, 0.581097f, 0.731263f, 0.176777f, 0.658790f, 
		-0.690282f, -0.116406f, -0.714115f, -0.370027f, -0.927866f, -0.0463164f, 
		-0.611156f, 0.346563f, 0.711606f, -0.391076f, 0.574886f, 0.718725f, 
		-0.767160f, 0.0340077f, 0.640553f, -0.837147f, -0.112578f, 0.535268f, 
		-0.675598f, 0.0423596f, 0.736052f, -0.751819f, 0.0708998f, 0.655546f, 
		-0.713100f, 0.136460f, 0.687654f, -0.779394f, 0.118035f, 0.615316f, 
		-0.713760f, -0.00524107f, 0.700371f, -0.781279f, -0.104142f, 0.615433f, 
		-0.636758f, -0.168413f, 0.752447f, -0.666357f, -0.0485521f, 0.744050f, 
		-0.958876f, -0.0119596f, 0.283573f, -0.405936f, 0.243438f, 0.880883f, 
		0.480486f, -0.145351f, 0.864874f, -0.137161f, -0.982853f, -0.123237f, 
		-0.806769f, 0.0149617f, -0.590678f, -0.528478f, 0.521883f, 0.669589f, 
		0.330389f, 0.766525f, 0.550710f, 0.820332f, 0.469386f, 0.326699f, 
		0.921423f, -0.0549383f, -0.384659f, -0.856862f, 0.484804f, 0.175366f, 
		-0.543829f, 0.615989f, 0.569918f, -0.686213f, 0.593890f, 0.420007f, 
		-0.0778888f, -0.938343f, -0.336816f, -0.848933f, -0.279125f, -0.448778f, 
		-0.00394696f, -0.582910f, 0.812527f, 0.583017f, -0.00724490f, 0.812427f, 
		0.631789f, -0.507567f, -0.585849f, -0.676510f, -0.111192f, 0.727991f, 
		0.107525f, -0.987684f, -0.113660f, -0.104467f, 0.909881f, 0.401501f, 
		-0.169709f, 0.877721f, 0.448112f, -0.231274f, 0.838823f, 0.492838f, 
		-0.975158f, 0.0228835f, 0.220327f, -0.824355f, 0.170815f, 0.539686f, 
		-0.990739f, -0.0120453f, 0.135243f, -0.811876f, 0.303136f, -0.498965f, 
		-0.763977f, 0.203824f, -0.612204f, -0.756229f, 0.105766f, -0.645703f, 
		0.499023f, 0.798716f, 0.336198f, -0.516249f, 0.341922f, 0.785224f, 
		0.258615f, 0.173581f, 0.950257f, -0.289381f, 0.333525f, 0.897229f, 
		0.0707766f, 0.232099f, 0.970114f, -0.692639f, 0.698467f, 0.179987f, 
		0.179508f, 0.757171f, 0.628068f, -0.0438237f, 0.869523f, 0.491945f, 
		-0.564187f, 0.784311f, 0.257969f, 0.211651f, -0.376354f, -0.901976f, 
		-0.0112156f, -0.501665f, -0.864990f, -0.131294f, -0.532545f, -0.836156f, 
		-0.585113f, 0.413197f, 0.697790f, -0.730467f, 0.262829f, 0.630349f, 
		-0.681410f, 0.323341f, 0.656606f, -0.445088f, -0.587347f, -0.675958f, 
		-0.978090f, -0.190121f, -0.0848182f, -0.566847f, -0.0430172f, -0.822699f, 
		-0.954029f, -0.160414f, 0.253173f, -0.902553f, -0.0843570f, 0.422234f, 
		-0.762786f, -0.0106332f, 0.646563f, 0.204504f, -0.0716685f, 0.976239f, 
		0.882186f, -0.272670f, -0.383926f, 0.890313f, 0.0434867f, 0.453268f, 
		-0.843770f, -0.0801528f, 0.530686f, -0.733149f, -0.0118586f, 0.679964f, 
		-0.978426f, -0.177620f, -0.105513f, -0.973245f, -0.209125f, 0.0951918f, 
		-0.502630f, 0.160624f, 0.849448f, 0.399954f, -0.245824f, 0.882954f, 
		-0.431896f, -0.453930f, -0.779368f, -0.981783f, -0.132873f, -0.135821f, 
		-0.874807f, 0.232416f, -0.425082f, -0.680175f, -0.729844f, -0.0684812f, 
		-0.917470f, -0.136670f, 0.373592f, -0.744968f, 0.249763f, -0.618581f, 
		-0.418873f, 0.901030f, -0.112650f, -0.478955f, -0.811626f, -0.334462f, 
		-0.592345f, 0.154438f, 0.790744f, 0.340183f, 0.128133f, 0.931589f, 
		-0.512743f, 0.639580f, 0.572741f, -0.931608f, -0.115625f, 0.344582f, 
		-0.486890f, -0.798271f, 0.354544f, -0.458881f, -0.598783f, 0.656420f, 
		-0.387417f, -0.501689f, 0.773444f, 0.907440f, -0.378568f, -0.182318f, 
		0.879737f, -0.210346f, 0.426400f, 0.316342f, -0.947202f, 0.0523115f, 
		0.859105f, -0.345460f, -0.377619f, 0.813155f, -0.126113f, 0.568221f, 
		-0.769641f, 0.111556f, 0.628656f, -0.900490f, 0.00441199f, 0.434855f, 
		-0.982129f, -0.138565f, 0.127367f, -0.820549f, 0.556394f, 0.130863f, 
		-0.409989f, -0.389504f, -0.824740f, -0.972898f, -0.212845f, -0.0903636f, 
		0.452034f, -0.595912f, -0.663742f, 0.756927f, -0.309449f, -0.575589f, 
		0.568009f, -0.510860f, -0.645281f, 0.916147f, 0.0285551f, -0.399823f, 
		0.258387f, -0.593963f, -0.761869f, 0.437019f, -0.540530f, -0.718917f, 
		-0.120709f, -0.764570f, -0.633136f, -0.291546f, -0.791481f, -0.537177f, 
		-0.216538f, -0.960278f, -0.176002f, 0.506279f, -0.635843f, -0.582568f, 
		0.201122f, -0.313264f, -0.928125f, -0.0147355f, -0.295803f, -0.955135f, 
		0.302939f, -0.322691f, -0.896716f, 0.122367f, -0.311514f, -0.942330f, 
		0.0641167f, -0.307988f, -0.949227f, 0.421113f, 0.901255f, 0.101996f, 
		0.550855f, -0.0299237f, 0.834064f, -0.497998f, 0.867170f, 0.00384592f, 
		-0.650383f, 0.283363f, 0.704775f, -0.966094f, -0.245045f, 0.0813299f, 
		-0.00514497f, 0.803957f, 0.594665f, -0.0861638f, 0.788226f, 0.609324f, 
		-0.167067f, 0.767852f, 0.618460f, -0.236767f, -0.327255f, 0.914793f, 
		0.811016f, -0.376880f, 0.447453f, 0.316342f, -0.947202f, 0.0523115f, 
		-0.201474f, 0.295380f, 0.933895f, 0.273222f, 0.202818f, 0.940327f, 
		-0.114205f, 0.300349f, 0.946968f, 0.137177f, 0.229441f, 0.963607f, 
		-0.310195f, 0.297391f, 0.902960f, -0.0491517f, 0.261122f, 0.964054f, 
		0.0339099f, 0.238678f, 0.970507f, -0.0765102f, -0.989711f, 0.120903f, 
		-0.623687f, 0.292726f, 0.724794f, 0.791684f, 0.610826f, -0.0112940f, 
		0.899231f, 0.261400f, -0.350789f, 0.903691f, 0.0752702f, -0.421518f, 
		0.715742f, 0.691932f, 0.0945754f, -0.766539f, 0.144266f, -0.625784f, 
		-0.321644f, 0.115086f, 0.939841f, -0.569332f, -0.143931f, 0.809410f, 
		-0.582731f, -0.343771f, 0.736374f, 0.0285678f, 0.298801f, 0.953888f, 
		0.0860182f, -0.537901f, -0.838608f, -0.239006f, -0.412574f, -0.879010f, 
		-0.107164f, -0.412701f, -0.904540f, -0.0623548f, -0.490546f, -0.869181f, 
		-0.163319f, -0.506450f, -0.846661f, 0.0824776f, -0.584579f, -0.807134f, 
		0.654584f, 0.243948f, 0.715548f, 0.461826f, 0.214535f, 0.860635f, 
		0.562258f, 0.413544f, 0.716134f, 0.746947f, 0.398650f, 0.532117f, 
		-0.291939f, -0.933268f, -0.209245f, 0.500247f, -0.678982f, -0.537342f, 
		-0.917585f, -0.390077f, -0.0766626f, -0.382186f, -0.564411f, -0.731693f, 
		-0.960045f, 0.0873030f, 0.265880f, -0.981560f, -0.121514f, -0.147559f, 
		-0.584070f, 0.0340100f, -0.810991f, -0.896801f, 0.402081f, -0.184607f, 
		-0.569934f, 0.713040f, 0.408350f, -0.881588f, -0.157755f, 0.444876f, 
		-0.406799f, -0.137237f, 0.903150f, 0.244914f, -0.188501f, 0.951044f, 
		-0.220461f, -0.177458f, 0.959117f, 0.366165f, -0.0970933f, 0.925471f, 
		-0.524714f, -0.824528f, -0.211728f, -0.867043f, -0.129109f, 0.481214f, 
		-0.0203311f, -0.531813f, -0.846618f, -0.326540f, -0.376050f, -0.867155f, 
		0.285976f, -0.547689f, -0.786292f, -0.638301f, 0.0319261f, 0.769125f, 
		0.589331f, 0.678095f, 0.439176f, 0.677080f, -0.337081f, -0.654171f, 
		0.545169f, -0.189017f, 0.816739f, 0.675172f, -0.216556f, 0.705157f, 
		0.600742f, -0.224844f, 0.767173f, -0.965659f, 0.223754f, -0.132047f, 
		-0.515666f, -0.842797f, 0.154212f, -0.849752f, -0.173204f, 0.497918f, 
		-0.527338f, 0.594697f, 0.606837f, 0.197223f, 0.941132f, 0.274543f, 
		-0.411077f, -0.403246f, -0.817563f, 0.177511f, -0.450135f, -0.875139f, 
		0.354205f, -0.450832f, -0.819322f, -0.117251f, -0.435321f, -0.892607f, 
		-0.235379f, -0.393212f, -0.888809f, 0.0566462f, -0.440471f, -0.895978f, 
		-0.0242343f, 0.739453f, 0.672772f, -0.0508760f, 0.551883f, 0.832368f, 
		-0.171769f, 0.422793f, 0.889799f, -0.793708f, -0.542592f, 0.274995f, 
		-0.440353f, -0.588608f, -0.677960f, 0.381668f, -0.599243f, -0.703731f, 
		0.422810f, 0.898672f, 0.116710f, -0.259704f, -0.958577f, -0.116979f, 
		-0.389385f, -0.907386f, -0.158205f, -0.396226f, -0.917860f, -0.0231882f, 
		-0.531386f, -0.818720f, 0.217544f, 0.195146f, -0.978994f, -0.0590618f, 
		-0.797695f, 0.264212f, -0.542102f, -0.491774f, -0.226321f, -0.840795f, 
		-0.612377f, 0.0828362f, 0.786214f, 0.585668f, 0.0761425f, 0.806967f, 
		0.852732f, -0.0609191f, 0.518784f, 0.375965f, 0.123910f, 0.918312f, 
		-0.980606f, -0.159629f, 0.113714f, 0.353191f, -0.786902f, 0.506005f, 
		-0.0747128f, -0.631555f, -0.771723f, -0.186584f, -0.520539f, -0.833202f, 
		-0.207417f, -0.391231f, -0.896614f, -0.730858f, 0.217133f, -0.647070f, 
		-0.550802f, -0.441407f, -0.708362f, -0.401751f, -0.457539f, -0.793256f, 
		-0.472960f, -0.477644f, -0.740382f, -0.748555f, -0.645053f, 0.153531f, 
		-0.155273f, -0.863763f, -0.479379f, -0.301610f, -0.831167f, -0.467111f, 
		0.153813f, -0.765633f, -0.624618f, 0.428639f, -0.619975f, -0.657191f, 
		-0.134484f, -0.828206f, -0.544049f, 0.774372f, -0.291458f, -0.561604f, 
		0.431215f, -0.588264f, -0.684104f, 0.722097f, -0.360438f, -0.590475f, 
		0.177220f, -0.902558f, -0.392405f, -0.206743f, -0.947218f, -0.245020f, 
		0.545795f, -0.677017f, -0.493717f, 0.407718f, -0.792778f, -0.453065f, 
		0.882868f, 0.0908245f, -0.460756f, 0.810399f, -0.205747f, -0.548563f, 
		0.627131f, -0.534132f, -0.566930f, 0.523188f, -0.645554f, -0.556358f, 
		0.0590686f, -0.391695f, -0.918197f, -0.0290856f, -0.414252f, -0.909698f, 
		-0.399136f, -0.446206f, -0.800994f, 0.916837f, -0.148143f, -0.370761f, 
		0.863857f, 0.104085f, 0.492867f, -0.280404f, -0.572546f, 0.770432f, 
		0.483160f, -0.854620f, 0.190214f, -0.549047f, 0.719158f, 0.425862f, 
		-0.811014f, -0.181783f, 0.556068f, 0.906032f, -0.272579f, -0.323738f, 
		0.760608f, -0.313576f, -0.568458f, 0.702983f, -0.308760f, -0.640689f, 
		0.594544f, -0.0522981f, 0.802360f, -0.424271f, -0.824117f, 0.375266f, 
		-0.666957f, -0.557459f, 0.494376f, -0.825485f, -0.200921f, 0.527452f, 
		0.897959f, 0.0273622f, 0.439227f, 0.272111f, 0.271820f, 0.923076f, 
		-0.389167f, 0.920113f, 0.0440515f, -0.0570274f, 0.967536f, 0.246216f, 
		-0.191739f, 0.956854f, 0.218325f, -0.368318f, 0.879454f, 0.301501f, 
		-0.140205f, 0.981709f, 0.128803f, -0.545662f, 0.681477f, 0.487690f, 
		0.0253436f, 0.998801f, 0.0418824f, 0.317922f, 0.629393f, 0.709077f, 
		0.0377119f, 0.682237f, 0.730158f, -0.0691723f, 0.690824f, 0.719707f, 
		-0.143237f, 0.761349f, 0.632321f, -0.302274f, 0.772218f, 0.558846f, 
		-0.394036f, 0.747846f, 0.534286f, 0.428177f, -0.891720f, -0.146629f, 
		0.193745f, -0.526920f, -0.827538f, 0.00204729f, -0.607617f, -0.794228f, 
		-0.192370f, -0.663271f, -0.723233f, 0.569065f, 0.00606175f, 0.822270f, 
		0.517945f, 0.0767363f, 0.851965f, 0.676995f, -0.0353568f, 0.735138f, 
		0.736872f, -0.0444959f, 0.674566f, 0.632670f, 0.0137872f, 0.774299f, 
		0.911900f, -0.0400617f, -0.408453f, 0.794161f, 0.534784f, 0.288641f, 
		-0.791000f, -0.611344f, 0.0240472f, 0.226864f, -0.702224f, -0.674843f, 
		0.512717f, 0.805766f, 0.296414f, -0.539725f, 0.166779f, 0.825155f, 
		-0.621077f, 0.00515086f, 0.783733f, -0.677994f, -0.125244f, 0.724319f, 
		0.202743f, 0.584481f, 0.785670f, -0.149903f, 0.581910f, 0.799318f, 
		-0.334304f, 0.538356f, 0.773573f, -0.147138f, 0.544414f, 0.825811f, 
		0.206459f, 0.508366f, 0.836026f, -0.815905f, 0.340058f, -0.467611f, 
		0.108551f, -0.790426f, -0.602862f, 0.547959f, -0.206779f, 0.810545f, 
		0.618068f, 0.784327f, -0.0531352f, 0.894327f, 0.0809199f, -0.440034f, 
		-0.935857f, -0.349341f, -0.0461818f, -0.790692f, -0.510676f, -0.337662f, 
		-0.817707f, 0.542396f, -0.192776f, -0.975984f, 0.215648f, 0.0308572f, 
		-0.994708f, -0.0816725f, 0.0623308f, 0.873459f, 0.00813583f, 0.486829f, 
		0.902843f, -0.251272f, -0.348907f, 0.0267800f, 0.476281f, 0.878885f, 
		-0.226040f, 0.445320f, 0.866369f, 0.277627f, 0.475956f, 0.834499f, 
		-0.214504f, -0.524139f, 0.824176f, 0.539598f, -0.777551f, 0.322877f, 
		0.220086f, 0.228465f, 0.948349f, 0.896687f, -0.0231996f, 0.442056f, 
		-0.210516f, -0.449102f, 0.868326f, -0.549126f, -0.527040f, 0.648606f, 
		-0.646791f, -0.632119f, 0.426716f, -0.0173940f, -0.435455f, 0.900043f, 
		-0.649045f, -0.368523f, -0.665531f, -0.234883f, -0.963213f, 0.130575f, 
		0.728349f, -0.605923f, -0.319946f, 0.376998f, -0.552592f, -0.743314f, 
		0.463034f, -0.620804f, -0.632615f, 0.562903f, -0.584461f, -0.584419f, 
		0.604331f, -0.684396f, -0.407905f, -0.478169f, -0.0635011f, -0.875969f, 
		-0.245845f, -0.918504f, -0.309694f, 0.465763f, -0.632854f, -0.618515f, 
		-0.613056f, 0.151867f, -0.775306f, 0.609490f, -0.0845897f, 0.788268f, 
		-0.805658f, 0.592374f, -0.00267973f, -0.358259f, 0.836167f, 0.415300f, 
		-0.494688f, 0.801589f, 0.335765f, -0.648311f, 0.743972f, 0.161857f, 
		-0.727011f, 0.679162f, 0.100968f, 0.102257f, 0.481704f, 0.870347f, 
		-0.413128f, 0.366868f, 0.833507f, -0.0346745f, 0.443703f, 0.895503f, 
		-0.944938f, -0.174286f, -0.276979f, -0.987136f, -0.136961f, -0.0824934f, 
		-0.998335f, -0.0412653f, -0.0403037f, -0.996565f, -0.0147918f, 0.0814815f, 
		-0.866695f, -0.269775f, -0.419597f, 0.426882f, 0.663718f, 0.614207f, 
		0.401022f, 0.575225f, 0.712950f, 0.624134f, 0.611153f, 0.486773f, 
		0.255709f, 0.412760f, 0.874210f, 0.274956f, 0.530981f, 0.801535f, 
		0.882692f, 0.314289f, 0.349397f, 0.415584f, -0.783579f, 0.461839f, 
		-0.0925770f, -0.888221f, -0.449992f, 0.195391f, -0.762106f, 0.617265f, 
		0.284499f, -0.809670f, 0.513318f, -0.900884f, 0.259165f, -0.348197f, 
		-0.893853f, -0.446360f, 0.0423011f, -0.777693f, -0.523571f, -0.347948f, 
		-0.849044f, -0.464741f, -0.251275f, 0.487580f, -0.284870f, 0.825297f, 
		-0.881470f, -0.320498f, 0.346831f, 0.453660f, 0.878311f, 0.150869f, 
		-0.788635f, -0.416620f, 0.452197f, 0.509448f, -0.830188f, -0.226386f, 
		-0.715285f, -0.235396f, 0.657994f, -0.855616f, -0.100567f, -0.507747f, 
		-0.995396f, 0.0467506f, -0.0836701f, -0.985606f, 0.0127973f, -0.168573f, 
		0.940727f, 0.0639178f, -0.333088f, 0.904958f, -0.116272f, -0.409306f, 
		0.592999f, -0.691809f, -0.412011f, 0.709304f, -0.539836f, -0.453282f, 
		-0.882953f, -0.0329608f, 0.468302f, -0.345321f, 0.887245f, 0.305860f, 
		-0.294472f, 0.922354f, 0.250101f, -0.237994f, 0.951718f, 0.193887f, 
		0.934421f, -0.00201499f, -0.356165f, -0.686780f, -0.539578f, -0.487020f, 
		-0.729275f, 0.617279f, -0.295170f, 0.0409776f, -0.921373f, 0.386512f, 
		-0.951052f, -0.307055f, 0.0348825f, -0.482746f, -0.0228576f, -0.875462f, 
		0.715569f, 0.694945f, 0.0708057f, 0.874928f, 0.479513f, -0.0675879f, 
		0.962315f, 0.0305906f, -0.270211f, 0.968201f, 0.184365f, -0.169102f, 
		-0.973970f, 0.0399276f, 0.223132f, -0.961943f, -0.124598f, -0.243189f, 
		-0.997892f, -0.0355014f, 0.0543160f, -0.827054f, -0.250051f, -0.503445f, 
		-0.783800f, 0.268360f, 0.560036f, -0.661467f, 0.349397f, 0.663614f, 
		-0.818859f, 0.222733f, 0.529018f, -0.733707f, 0.287575f, 0.615609f, 
		-0.863004f, 0.206942f, 0.460867f, -0.555435f, -0.760110f, 0.337231f, 
		0.776130f, -0.222495f, 0.590016f, 0.821676f, -0.562710f, 0.0905845f, 
		0.507702f, -0.861254f, -0.0219045f, 0.805253f, -0.376019f, 0.458451f, 
		0.861760f, -0.452451f, -0.229472f, -0.199682f, -0.955884f, 0.215435f, 
		0.261441f, -0.589261f, 0.764474f, 0.351656f, -0.458543f, 0.816135f, 
		0.286359f, -0.521207f, 0.803954f, 0.355919f, 0.375525f, 0.855747f, 
		-0.243829f, 0.253314f, 0.936151f, -0.419407f, 0.214155f, 0.882177f, 
		0.0490761f, 0.365365f, 0.929570f, 0.911784f, -0.222476f, -0.345188f, 
		-0.790692f, -0.510676f, -0.337662f, -0.0456565f, -0.916350f, 0.397766f, 
		-0.688063f, 0.249009f, 0.681589f, -0.697705f, 0.105907f, 0.708513f, 
		-0.556136f, 0.544026f, 0.628291f, -0.579623f, 0.431054f, 0.691541f, 
		-0.407440f, 0.654513f, 0.636872f, -0.767484f, -0.0531621f, 0.638860f, 
		0.970701f, -0.219367f, -0.0980671f, 0.721427f, -0.690709f, -0.0496429f, 
		0.554084f, -0.831629f, 0.0372101f, 0.999754f, -0.0217740f, -0.00425127f, 
		0.566809f, -0.501186f, -0.653866f, -0.517850f, -0.804966f, 0.289587f, 
		0.122090f, -0.585177f, 0.801662f, 0.399145f, -0.902837f, -0.159901f, 
		0.610472f, -0.314924f, -0.726737f, 0.682866f, -0.508054f, -0.524953f, 
		0.890159f, 0.307904f, 0.335876f, 0.976274f, -0.0354150f, 0.213623f, 
		0.945900f, 0.242600f, 0.215449f, -0.919201f, 0.153667f, 0.362570f, 
		-0.470742f, 0.306368f, 0.827370f, -0.639754f, 0.273186f, 0.718390f, 
		-0.976510f, 0.101345f, 0.190150f, -0.912511f, -0.206680f, 0.352997f, 
		-0.895522f, -0.312367f, 0.316966f, -0.847374f, -0.405492f, 0.342831f, 
		-0.468733f, -0.421513f, 0.776284f, -0.772260f, -0.223948f, 0.594527f, 
		-0.567767f, 0.109131f, 0.815924f, -0.507944f, -0.435793f, -0.743019f, 
		-0.735232f, -0.428098f, -0.525515f, -0.571222f, -0.595563f, -0.564811f, 
		-0.716108f, -0.537654f, -0.445105f, -0.954441f, -0.102030f, -0.280413f, 
		-0.883804f, -0.333272f, 0.328358f, -0.909725f, -0.150591f, 0.386941f, 
		-0.813579f, -0.581396f, -0.00830589f, -0.737369f, -0.657083f, -0.156616f, 
		0.284689f, -0.553849f, 0.782434f, 0.387316f, -0.700973f, 0.598851f, 
		0.707265f, -0.701849f, 0.0847641f, 0.213349f, -0.492875f, -0.843538f, 
		0.619859f, -0.542454f, -0.567027f, 0.717929f, -0.658365f, -0.226129f, 
		-0.940206f, -0.329844f, 0.0849472f, -0.263984f, -0.292731f, -0.919033f, 
		-0.866295f, -0.0963806f, -0.490146f, -0.677994f, -0.187534f, -0.710743f, 
		-0.539447f, -0.231364f, -0.809610f, 0.289217f, 0.950118f, -0.116745f, 
		-0.285782f, 0.123580f, 0.950293f, -0.124895f, 0.121901f, 0.984653f, 
		-0.00108886f, -0.0789527f, 0.996878f, -0.0846729f, -0.00192583f, 0.996407f, 
		0.0670059f, -0.208407f, 0.975744f, -0.741497f, 0.670941f, 0.00456078f, 
		-0.892052f, 0.415330f, 0.178169f, -0.940787f, 0.0860023f, 0.327907f, 
		-0.894308f, -0.0445654f, 0.445227f, 0.567400f, -0.551753f, -0.611249f, 
		0.885993f, 0.0416189f, -0.461826f, 0.742962f, -0.332186f, -0.581085f, 
		0.452830f, -0.646189f, -0.614316f, -0.338281f, 0.331853f, 0.880590f, 
		-0.559063f, 0.560453f, 0.611016f, -0.936795f, -0.0876173f, 0.338731f, 
		0.499270f, -0.371184f, 0.782912f, -0.398872f, 0.159042f, 0.903109f, 
		-0.0571976f, 0.279001f, 0.958586f, 0.265098f, 0.390368f, 0.881666f, 
		-0.342121f, -0.395334f, 0.852446f, 0.310458f, -0.950562f, 0.00693346f, 
		0.755024f, -0.352237f, 0.553053f, -0.510024f, -0.326633f, -0.795730f, 
		-0.443612f, -0.702012f, 0.557124f, -0.0806426f, -0.0230433f, 0.996477f, 
		-0.698941f, -0.383490f, -0.603670f, -0.519761f, -0.441752f, -0.731235f, 
		-0.576847f, -0.419488f, -0.700911f, -0.492413f, -0.119304f, -0.862146f, 
		-0.819326f, 0.388886f, -0.421275f, -0.340057f, 0.799961f, 0.494392f, 
		0.112980f, -0.134075f, 0.984510f, 0.552919f, -0.191888f, 0.810839f, 
		0.655696f, -0.154165f, 0.739119f, 0.410811f, -0.291217f, 0.863960f, 
		0.305243f, -0.0116251f, 0.952203f, 0.408957f, -0.204036f, 0.889451f, 
		-0.428920f, -0.298985f, -0.852429f, -0.665903f, -0.224007f, -0.711613f, 
		-0.598936f, -0.260826f, -0.757129f, 0.857592f, 0.0896557f, -0.506456f, 
		0.690830f, 0.720832f, 0.0561782f, 0.681512f, -0.662885f, -0.310041f, 
		0.447423f, -0.760388f, -0.470769f, 0.385247f, -0.891400f, -0.238728f, 
		0.540335f, -0.805712f, -0.242625f, 0.603973f, -0.265314f, -0.751549f, 
		0.976136f, 0.127111f, 0.176072f, 0.416621f, 0.474393f, 0.775486f, 
		0.972050f, 0.0999971f, 0.212415f, 0.381736f, 0.500935f, 0.776751f, 
		-0.0744693f, -0.992698f, 0.0948910f, 0.541860f, -0.680305f, -0.493531f, 
		0.606529f, -0.460200f, -0.648336f, -0.242376f, 0.855415f, 0.457732f, 
		0.0384734f, 0.916078f, 0.399150f, -0.162287f, 0.882715f, 0.440995f, 
		0.227354f, 0.301291f, 0.926031f, 0.859130f, 0.156285f, -0.487310f, 
		-0.772092f, 0.625284f, -0.113551f, 0.970136f, 0.215470f, 0.111392f, 
		0.375623f, 0.449758f, 0.810324f, -0.0827853f, -0.994137f, -0.0695645f, 
		-0.109304f, -0.347568f, 0.931262f, -0.277193f, -0.505023f, 0.817384f, 
		-0.226775f, -0.403714f, 0.886334f, -0.387869f, -0.698547f, 0.601324f, 
		-0.452473f, -0.567596f, 0.687824f, 0.102422f, 0.654608f, 0.748998f, 
		0.695860f, 0.335354f, 0.635072f, 0.256184f, 0.617697f, 0.743519f, 
		0.842313f, 0.134037f, 0.522057f, -0.400470f, -0.787801f, -0.467967f, 
		-0.533505f, -0.818985f, -0.211271f, -0.491712f, -0.820873f, -0.290494f, 
		-0.558871f, 0.373898f, 0.740178f, 0.351731f, 0.538114f, 0.765976f, 
		-0.0579155f, -0.909817f, 0.410948f, -0.934107f, -0.0836066f, 0.347066f, 
		-0.913033f, -0.398095f, -0.0888303f, -0.352846f, -0.377598f, 0.856107f, 
		-0.171327f, -0.788819f, 0.590264f, -0.288554f, -0.504722f, 0.813629f, 
		-0.584715f, 0.0923947f, -0.805960f, 0.824634f, -0.343878f, -0.449139f, 
		0.973751f, 0.116833f, 0.195344f, -0.957266f, -0.222273f, -0.185029f, 
		0.808780f, -0.158021f, -0.566484f, 0.972583f, 0.176143f, 0.151842f, 
		0.563407f, 0.434328f, 0.702802f, 0.177472f, 0.597653f, 0.781866f, 
		0.288056f, 0.574277f, 0.766309f, 0.269851f, 0.954996f, -0.123137f, 
		-0.683463f, -0.502808f, 0.529209f, 0.304513f, 0.204409f, 0.930316f, 
		-0.211680f, 0.297623f, 0.930920f, -0.510944f, 0.314293f, 0.800098f, 
		0.126661f, 0.261146f, 0.956953f, 0.841298f, -0.355755f, -0.407008f, 
		0.949725f, 0.0961216f, 0.297963f, -0.556991f, 0.509640f, 0.655765f, 
		0.247386f, 0.866654f, 0.433256f, 0.507617f, -0.0211493f, 0.861323f, 
		-0.0304522f, -0.999391f, -0.0170582f, 0.188282f, -0.970179f, -0.152650f, 
		0.487520f, -0.805504f, -0.336880f, -0.983279f, -0.129626f, 0.127904f, 
		-0.0911658f, -0.257165f, -0.962058f, -0.301867f, 0.773097f, -0.557851f, 
		0.116484f, 0.443150f, 0.888847f, -0.366845f, -0.203202f, 0.907818f, 
		-0.383765f, -0.00623705f, 0.923410f, -0.185009f, 0.247275f, 0.951119f, 
		-0.889454f, -0.182553f, 0.418982f, -0.768808f, -0.615235f, 0.174416f, 
		-0.710362f, -0.693745f, 0.118756f, 0.351690f, 0.206802f, 0.912988f, 
		-0.108262f, -0.452952f, 0.884937f, 0.0640693f, -0.0359544f, 0.997298f, 
		0.273959f, 0.103907f, 0.956112f, -0.0910881f, 0.0919059f, 0.991593f, 
		0.154074f, 0.135705f, 0.978696f, 0.346749f, -0.0790019f, 0.934625f, 
		0.297467f, -0.218319f, 0.929435f, 0.198609f, -0.335927f, 0.920710f, 
		0.777612f, -0.612293f, 0.142889f, 0.814028f, 0.100390f, -0.572083f, 
		0.496892f, 0.828144f, -0.259375f, 0.158073f, -0.384347f, -0.909555f, 
		0.0267734f, -0.508482f, -0.860656f, -0.146394f, -0.560314f, -0.815240f, 
		-0.856585f, 0.498882f, 0.131829f, -0.855329f, 0.469627f, 0.218776f, 
		-0.790214f, 0.424373f, 0.442118f, -0.836815f, 0.418361f, 0.353148f, 
		-0.837385f, 0.466013f, 0.285690f, -0.674111f, 0.160615f, -0.720956f, 
		-0.451803f, -0.0272037f, -0.891703f, -0.0818814f, 0.321251f, 0.943447f, 
		0.748045f, -0.388805f, -0.537829f, 0.831588f, -0.0462971f, -0.553459f, 
		0.575627f, -0.688942f, -0.440468f, 0.826345f, 0.102216f, -0.553810f, 
		-0.797914f, -0.445861f, 0.405637f, 0.864588f, -0.434553f, -0.252291f, 
		0.809617f, 0.00226994f, 0.586954f, -0.210037f, 0.0165990f, 0.977553f, 
		-0.171327f, -0.788819f, 0.590264f, -0.00228373f, 0.478061f, 0.878324f, 
		-0.123559f, 0.552013f, 0.824630f, -0.165433f, 0.760477f, 0.627939f, 
		-0.0622963f, 0.844594f, 0.531770f, -0.941865f, -0.0911154f, -0.323402f, 
		-0.231708f, -0.385713f, -0.893049f, -0.210725f, 0.840402f, 0.499318f, 
		0.0312349f, 0.791756f, 0.610038f, 0.304649f, 0.621988f, 0.721332f, 
		0.895904f, -0.418507f, 0.149025f, 0.847344f, -0.518577f, -0.114393f, 
		0.895506f, -0.444817f, -0.0143649f, -0.440413f, -0.661859f, 0.606613f, 
		0.458397f, -0.343865f, -0.819530f, 0.0973843f, -0.343922f, -0.933935f, 
		0.00610532f, -0.327824f, -0.944719f, 0.984372f, 0.173594f, 0.0296134f, 
		0.352968f, 0.343648f, 0.870241f, -0.820478f, -0.276237f, 0.500508f, 
		-0.481161f, 0.0403752f, -0.875702f, -0.329310f, 0.943241f, -0.0430333f, 
		-0.934787f, -0.130171f, 0.330497f, -0.317196f, 0.773413f, -0.548834f, 
		0.263894f, 0.921823f, 0.283905f, 0.0859166f, 0.359739f, 0.929089f, 
		0.253106f, -0.778221f, 0.574726f, -0.985636f, -0.133612f, 0.103295f, 
		0.939009f, -0.0430628f, -0.341186f, 0.985306f, 0.144838f, -0.0905246f, 
		0.974148f, 0.207029f, 0.0904138f, 0.978797f, 0.0646978f, -0.194346f, 
		0.795179f, -0.189636f, -0.575959f, 0.893663f, -0.120832f, -0.432165f, 
		0.0348795f, -0.811252f, 0.583655f, 0.285195f, -0.691229f, 0.663978f, 
		-0.252874f, -0.928274f, 0.272693f, -0.294557f, -0.949311f, 0.109748f, 
		0.949719f, -0.193865f, -0.245867f, 0.999156f, 0.0265094f, 0.0313692f, 
		0.915672f, -0.253796f, -0.311661f, 0.992839f, -0.0793632f, 0.0892884f, 
		0.469190f, 0.323032f, 0.821895f, 0.0894709f, -0.498130f, -0.862474f, 
		0.160511f, -0.519122f, -0.839493f, -0.191552f, -0.437174f, -0.878742f, 
		0.469337f, -0.752407f, 0.462176f, 0.453936f, -0.496427f, 0.739934f, 
		0.484813f, -0.593731f, 0.642215f, -0.758298f, 0.227601f, 0.610886f, 
		-0.449710f, -0.00570242f, -0.893156f, -0.577071f, 0.667201f, 0.470991f, 
		-0.887837f, -0.162179f, 0.430631f, -0.395546f, -0.905798f, -0.151895f, 
		0.265642f, -0.661750f, -0.701086f, 0.442578f, -0.592660f, -0.672962f, 
		-0.240065f, -0.892688f, -0.381414f, -0.0800119f, -0.861422f, -0.501548f, 
		-0.883907f, 0.313003f, -0.347473f, -0.741345f, 0.185415f, -0.645003f, 
		-0.666775f, 0.165567f, -0.726635f, -0.596558f, -0.794039f, 0.116708f, 
		-0.846170f, -0.331626f, 0.417158f, -0.735454f, -0.629718f, 0.250124f, 
		-0.886453f, -0.144369f, 0.439725f, -0.302746f, -0.245363f, -0.920946f, 
		0.531088f, -0.112967f, 0.839752f, 0.395112f, 0.914610f, 0.0858737f, 
		-0.945870f, -0.237981f, 0.220669f, -0.971544f, -0.227968f, -0.0642868f, 
		0.852197f, 0.111768f, -0.511143f, 0.480659f, 0.824184f, -0.299480f, 
		0.243302f, -0.474723f, 0.845838f, 0.393927f, -0.601412f, 0.695072f, 
		0.463212f, -0.664206f, 0.586741f, 0.903342f, 0.0294255f, -0.427911f, 
		-0.122907f, -0.893730f, 0.431440f, -0.753251f, -0.427354f, 0.499981f, 
		-0.569575f, 0.819097f, 0.0682981f, -0.364922f, -0.587117f, 0.722583f, 
		0.552789f, -0.765396f, -0.329534f, 0.657849f, 0.283110f, 0.697914f, 
		0.555508f, 0.319945f, 0.767494f, 0.471382f, 0.259056f, 0.843024f, 
		0.552845f, 0.437925f, 0.708932f, 0.724414f, 0.440174f, 0.530538f, 
		0.665210f, 0.399092f, 0.631048f, 0.217239f, -0.786554f, 0.578048f, 
		0.628915f, -0.623149f, -0.464920f, -0.966984f, -0.128704f, 0.219947f, 
		-0.658864f, 0.454466f, 0.599466f, -0.902498f, 0.355235f, -0.243526f, 
		0.607039f, -0.793792f, 0.0373870f, 0.0792917f, -0.989365f, -0.121938f, 
		0.498898f, -0.866179f, 0.0288832f, -0.913668f, -0.205260f, 0.350826f, 
		0.526515f, 0.771847f, 0.356417f, 0.696544f, -0.353138f, -0.624596f, 
		0.699676f, 0.0333681f, 0.713681f, 0.602179f, -0.108058f, 0.791015f, 
		0.868758f, -0.402543f, 0.288476f, 0.627393f, -0.0157428f, 0.778544f, 
		0.707896f, -0.101703f, 0.698956f, 0.658965f, 0.104464f, 0.744884f, 
		0.532289f, 0.161117f, 0.831089f, 0.601802f, 0.138499f, 0.786545f, 
		0.746302f, 0.0651932f, 0.662407f, 0.721456f, 0.265428f, 0.639569f, 
		0.596482f, 0.144250f, 0.789557f, 0.475478f, -0.282063f, 0.833283f, 
		0.282299f, -0.411440f, 0.866616f, 0.314224f, -0.223073f, 0.922769f, 
		-0.815577f, -0.291413f, 0.499912f, 0.181075f, -0.793813f, 0.580580f, 
		0.628915f, -0.623149f, -0.464920f, -0.287548f, -0.857032f, -0.427566f, 
		0.623427f, 0.453322f, 0.637054f, 0.483031f, 0.492084f, 0.724248f, 
		0.549589f, 0.761074f, 0.344554f, 0.382417f, 0.884906f, 0.265891f, 
		0.396755f, 0.726439f, 0.561135f, -0.749685f, 0.622963f, -0.223362f, 
		0.535385f, -0.315830f, 0.783336f, -0.524688f, -0.590636f, 0.613067f, 
		-0.769725f, -0.329115f, 0.546998f, -0.945546f, -0.213911f, -0.245326f, 
		-0.857822f, -0.183780f, 0.479966f, 0.0653650f, 0.353690f, 0.933076f, 
		0.217239f, -0.786554f, 0.578048f, -0.996424f, 0.0413920f, 0.0736647f, 
		-0.993150f, -0.108986f, 0.0421353f, -0.185860f, -0.526194f, -0.829805f, 
		-0.0776349f, -0.523038f, -0.848766f, -0.279351f, -0.502771f, -0.818037f, 
		-0.732506f, 0.0803201f, -0.676006f, -0.883568f, 0.198543f, -0.424132f, 
		-0.597624f, 0.0185210f, -0.801563f, -0.945608f, 0.294947f, -0.137228f, 
		-0.911348f, 0.261487f, -0.317915f, -0.801434f, 0.135167f, -0.582609f, 
		-0.994432f, -0.0337222f, -0.0998428f, 0.618705f, 0.108700f, 0.778067f, 
		-0.670600f, 0.698137f, 0.250799f, -0.850994f, -0.140186f, 0.506120f, 
		-0.580546f, 0.615696f, 0.532808f, 0.0816800f, 0.991544f, 0.100841f, 
		-0.987908f, 0.115029f, -0.103948f, 0.740473f, 0.226702f, 0.632698f, 
		0.575422f, 0.268229f, 0.772621f, 0.474723f, 0.277839f, 0.835131f, 
		0.704934f, -0.290254f, -0.647163f, -0.930338f, -0.296053f, -0.216387f, 
		0.457550f, -0.244905f, -0.854792f, 0.101124f, -0.994465f, -0.0285171f, 
		-0.976336f, -0.124433f, 0.176873f, -0.981290f, -0.183714f, -0.0576186f, 
		0.872773f, 0.414782f, -0.257337f, 0.935685f, 0.121758f, -0.331163f, 
		0.920687f, 0.290535f, -0.260625f, 0.781871f, 0.580108f, -0.228368f, 
		0.704966f, 0.673830f, -0.221306f, 0.594346f, 0.793539f, -0.130568f, 
		-0.430927f, -0.902176f, -0.0194936f, -0.504792f, 0.669021f, 0.545523f, 
		0.566727f, 0.416467f, 0.710898f, -0.916944f, -0.175804f, 0.358199f, 
		0.843179f, -0.239335f, -0.481423f, 0.776268f, -0.313381f, -0.546992f, 
		0.670650f, -0.436822f, -0.599513f, 0.593568f, -0.534706f, -0.601470f, 
		0.731822f, -0.386363f, -0.561391f, -0.972960f, -0.108892f, 0.203692f, 
		-0.971608f, 0.234503f, 0.0313863f, -0.934249f, -0.224659f, -0.276961f, 
		0.779296f, -0.507442f, -0.367697f, 0.696131f, -0.658935f, -0.284966f, 
		0.906248f, 0.128215f, -0.402835f, 0.898404f, -0.0667027f, -0.434076f, 
		-0.393157f, -0.00337070f, -0.919465f, 0.910822f, -0.154558f, -0.382773f, 
		0.850074f, 0.168299f, 0.499048f, -0.961371f, -0.159737f, -0.224165f, 
		-0.968092f, 0.0218803f, -0.249638f, -0.960359f, -0.273557f, 0.0536376f, 
		-0.960692f, 0.0296556f, 0.276029f, -0.959099f, 0.206830f, 0.193261f, 
		-0.0182001f, -0.807938f, -0.588987f, 0.312156f, -0.639394f, -0.702662f, 
		-0.226563f, -0.859676f, -0.457851f, 0.499712f, -0.556131f, -0.664083f, 
		-0.573018f, -0.546576f, 0.610660f, -0.955936f, 0.173076f, -0.237130f, 
		-0.400294f, -0.832512f, 0.382999f, -0.789984f, -0.327627f, 0.518253f, 
		-0.813517f, -0.137732f, 0.564995f, -0.554197f, -0.711964f, 0.431247f, 
		-0.573931f, -0.500732f, 0.647974f, -0.421654f, -0.632360f, 0.649869f, 
		0.0475181f, -0.873040f, 0.485327f, 0.473606f, -0.664288f, -0.578290f, 
		-0.234765f, -0.926128f, -0.295249f, 0.706798f, -0.473767f, -0.525339f, 
		0.617656f, -0.426162f, -0.660974f, 0.667858f, -0.455897f, -0.588322f, 
		-0.954739f, 0.272958f, -0.118185f, 0.946096f, 0.0450207f, -0.320741f, 
		0.824036f, 0.498858f, 0.268524f, -0.951025f, -0.243431f, 0.190504f, 
		0.903220f, -0.0130508f, -0.428979f, 0.758728f, 0.603110f, 0.246149f, 
		-0.946181f, -0.289783f, -0.144111f, 0.970994f, 0.196543f, 0.136164f, 
		0.614546f, -0.615485f, 0.493469f, 0.690526f, -0.668180f, 0.276967f, 
		0.862515f, -0.504291f, -0.0419222f, 0.948674f, -0.168097f, -0.267883f, 
		0.988752f, 0.147664f, -0.0237706f, -0.711598f, 0.118295f, 0.692557f, 
		0.465638f, 0.0183018f, 0.884786f, -0.495801f, 0.820869f, 0.283472f, 
		-0.559479f, 0.805876f, 0.193770f, -0.293285f, 0.949165f, -0.114321f, 
		-0.127868f, 0.969406f, -0.209529f, -0.255573f, 0.964839f, -0.0613768f, 
		-0.630451f, 0.693878f, 0.347943f, -0.974841f, -0.199870f, 0.0986778f, 
		-0.0658616f, -0.470489f, -0.879945f, 0.680275f, -0.389267f, 0.621045f, 
		-0.940257f, -0.0235200f, 0.339651f, -0.913413f, -0.0668806f, 0.401502f, 
		0.890492f, -0.220257f, -0.398134f, 0.840173f, 0.118411f, 0.529234f, 
		-0.655020f, 0.710167f, 0.258095f, -0.773455f, -0.114755f, 0.623377f, 
		0.0468953f, 0.739620f, 0.671389f, -0.970056f, -0.201397f, 0.135762f, 
		-0.933266f, -0.356026f, -0.0475340f, -0.562348f, 0.826269f, 0.0323316f, 
		-0.687184f, 0.0314941f, 0.725800f, -0.910296f, 0.299688f, -0.285567f, 
		-0.976873f, -0.200604f, -0.0740103f, -0.928055f, -0.0928565f, 0.360682f, 
		-0.753594f, -0.323376f, -0.572297f, -0.614365f, 0.607866f, -0.503045f, 
		-0.637660f, -0.0657709f, 0.767505f, 0.854726f, -0.432787f, -0.286600f, 
		0.708988f, -0.0591983f, 0.702731f, -0.199300f, -0.789292f, 0.580773f, 
		-0.807357f, -0.0498457f, 0.587954f, -0.735363f, -0.286725f, 0.614028f, 
		-0.908568f, -0.0646519f, -0.412705f, -0.910463f, 0.413550f, 0.00576856f, 
		-0.914661f, 0.318660f, -0.248698f, 0.477020f, -0.865400f, -0.153413f, 
		0.217381f, -0.976086f, 0.00145557f, 0.427366f, -0.901261f, -0.0713172f, 
		0.325456f, -0.944335f, -0.0480590f, 0.641454f, -0.700754f, -0.312219f, 
		0.602955f, -0.763981f, -0.229736f, 0.565336f, -0.815032f, -0.126955f, 
		-0.921887f, -0.0475295f, 0.384531f, -0.901515f, 0.247762f, -0.354803f, 
		-0.915278f, 0.110977f, -0.387233f, -0.915490f, 0.171061f, 0.364166f, 
		-0.909815f, 0.375162f, 0.177457f, 0.690564f, 0.106986f, 0.715314f, 
		0.640567f, 0.255654f, 0.724096f, 0.514284f, 0.468507f, 0.718340f, 
		0.922908f, 0.128414f, -0.362974f, -0.927150f, -0.185492f, 0.325555f, 
		-0.567749f, -0.606120f, -0.557027f, -0.376830f, -0.786174f, -0.489825f, 
		-0.141816f, -0.882765f, -0.447900f, -0.904642f, -0.206019f, 0.373067f, 
		0.599880f, -0.139163f, 0.787895f, -0.900468f, 0.404470f, -0.159881f, 
		-0.898153f, -0.0357762f, 0.438224f, 0.725428f, 0.0984443f, -0.681222f, 
		-0.611480f, 0.788456f, 0.0665574f, -0.899843f, -0.432497f, 0.0568234f, 
		-0.884395f, -0.231297f, -0.405397f, -0.942462f, -0.0207106f, -0.333671f, 
		0.384310f, 0.893543f, -0.232134f, 0.311556f, 0.949391f, 0.0398652f, 
		0.331596f, 0.942393f, -0.0440283f, -0.886591f, 0.0339198f, 0.461308f, 
		-0.681110f, 0.436427f, 0.587896f, 0.131544f, 0.113279f, 0.984817f, 
		-0.866510f, -0.0318729f, 0.498141f, 0.657881f, 0.664529f, 0.354392f, 
		0.702368f, -0.427092f, 0.569449f, -0.891287f, -0.340896f, -0.298993f, 
		-0.917554f, -0.0152151f, 0.397319f, -0.971327f, 0.00231025f, 0.237735f, 
		-0.947950f, -0.0146080f, 0.318083f, -0.884225f, 0.311451f, 0.348058f, 
		-0.127460f, -0.986953f, -0.0983765f, 0.532505f, -0.676662f, -0.508495f, 
		-0.889608f, -0.415374f, 0.189899f, 0.900415f, 0.0458778f, -0.432605f, 
		-0.968890f, -0.219220f, 0.114869f, -0.954914f, -0.194867f, 0.223978f, 
		-0.848324f, -0.202976f, 0.489026f, -0.908733f, -0.168559f, 0.381829f, 
		-0.932211f, -0.201517f, 0.300620f, -0.788510f, -0.276749f, 0.549238f, 
		0.582195f, -0.605715f, 0.542363f, -0.937565f, -0.254977f, -0.236557f, 
		-0.344545f, 0.0202991f, -0.938550f, -0.734535f, -0.248167f, 0.631563f, 
		-0.398049f, -0.687977f, 0.606832f, -0.263676f, -0.762045f, 0.591407f, 
		0.0268978f, -0.900220f, 0.434603f, 0.333225f, -0.917379f, 0.217662f, 
		-0.0570315f, -0.874982f, 0.480784f, -0.771976f, 0.0664043f, 0.632173f, 
		-0.828502f, 0.168821f, 0.533932f, -0.480927f, 0.872142f, 0.0898741f, 
		-0.370932f, 0.928414f, -0.0213983f, -0.439187f, 0.898239f, 0.0167858f, 
		-0.685886f, 0.691040f, 0.228088f, -0.289325f, 0.950620f, -0.112302f, 
		-0.877622f, -0.447271f, -0.172419f, 0.913519f, 0.0857474f, -0.397655f, 
		0.597180f, 0.705231f, 0.382133f, 0.727129f, -0.430201f, 0.534986f, 
		-0.901835f, -0.385541f, -0.195067f, -0.346947f, -0.0934139f, 0.933221f, 
		-0.356603f, -0.00202619f, -0.934254f, -0.715926f, 0.0621063f, 0.695409f, 
		-0.314821f, -0.840511f, 0.440941f, -0.104579f, -0.925494f, 0.364040f, 
		0.555390f, -0.829345f, -0.0610612f, 0.515093f, -0.230282f, 0.825620f, 
		-0.799437f, 0.165319f, 0.577555f, 0.508135f, 0.810421f, 0.291575f, 
		-0.895829f, -0.00429467f, 0.444378f, -0.855074f, -0.0305737f, 0.517604f, 
		-0.927513f, 0.0222093f, 0.373131f, -0.873822f, -0.0608297f, 0.482426f, 
		-0.812792f, 0.0123377f, 0.582423f, 0.285111f, -0.954773f, 0.0843780f, 
		-0.733022f, 0.0698460f, 0.676610f, -0.458424f, -0.498915f, -0.735480f, 
		-0.249168f, -0.427953f, -0.868776f, -0.339534f, -0.439879f, -0.831398f, 
		-0.805007f, -0.394868f, -0.442768f, -0.980664f, -0.151214f, 0.124229f, 
		-0.914991f, -0.335587f, -0.223992f, -0.946718f, -0.0850279f, 0.310635f, 
		0.638130f, -0.325763f, 0.697616f, -0.751167f, -0.325470f, -0.574297f, 
		-0.279518f, -0.941112f, -0.190207f, -0.672737f, -0.0553406f, 0.737809f, 
		-0.854647f, -0.127913f, 0.503207f, -0.732880f, 0.309651f, 0.605808f, 
		-0.726638f, 0.182009f, 0.662472f, -0.651671f, 0.591082f, 0.475340f, 
		-0.666781f, 0.493491f, 0.558453f, -0.533804f, 0.721361f, 0.441239f, 
		-0.761382f, 0.00673000f, 0.648269f, -0.268131f, -0.185987f, -0.945259f, 
		-0.843739f, 0.405749f, -0.351386f, -0.766655f, 0.287466f, 0.574111f, 
		0.0538084f, 0.555355f, 0.829871f, -0.318411f, -0.0184469f, -0.947773f, 
		-0.656042f, -0.272131f, 0.703956f, 0.357216f, -0.807822f, 0.468850f, 
		-0.838666f, -0.543178f, -0.0399573f, -0.837985f, -0.383768f, 0.387948f, 
		0.137933f, 0.925315f, -0.353223f, -0.663041f, -0.225272f, 0.713883f, 
		-0.849632f, 0.0847451f, -0.520523f, 0.888687f, 0.0484710f, -0.455945f, 
		0.662708f, -0.520981f, 0.537956f, -0.837781f, 0.223307f, -0.498254f, 
		0.646674f, -0.306406f, 0.698518f, -0.843582f, 0.479514f, -0.241734f, 
		-0.833191f, -0.368208f, -0.412571f, 0.808243f, 0.302622f, -0.505137f, 
		-0.978233f, -0.205425f, -0.0293366f, -0.860714f, -0.373547f, -0.345880f, 
		-0.953359f, 0.0129785f, 0.301561f, -0.960250f, -0.266024f, -0.0845587f, 
		-0.984493f, -0.132419f, 0.115057f, -0.984425f, -0.0404351f, 0.171092f, 
		-0.605284f, -0.375146f, 0.702066f, 0.226854f, -0.939729f, 0.255826f, 
		0.874135f, -0.0520400f, -0.482887f, -0.230497f, -0.0279112f, -0.972673f, 
		-0.821350f, 0.462039f, 0.334520f, -0.338652f, -0.0270571f, -0.940522f, 
		-0.392043f, -0.166728f, 0.904712f, 0.939403f, 0.0789413f, 0.333603f, 
		-0.0713855f, -0.801713f, 0.593431f, -0.0536684f, -0.890038f, 0.452717f, 
		-0.943765f, -0.305179f, -0.127178f, 0.415603f, -0.0832444f, 0.905729f, 
		-0.924890f, -0.259841f, -0.277599f, -0.822495f, 0.236147f, 0.517433f, 
		-0.828643f, 0.552424f, -0.0904328f, -0.922203f, -0.231194f, -0.309987f, 
		0.624902f, -0.576610f, -0.526326f, 0.847640f, 0.0710614f, -0.525791f, 
		0.765885f, -0.336148f, -0.548111f, 0.527053f, -0.686877f, -0.500415f, 
		0.628915f, -0.623149f, -0.464920f, -0.267385f, -0.935264f, -0.231919f, 
		-0.565916f, -0.214141f, -0.796168f, -0.912646f, -0.0688385f, 0.402913f, 
		-0.822777f, -0.0247599f, -0.567824f, -0.811320f, 0.581032f, 0.0645087f, 
		-0.0704082f, -0.958733f, -0.275451f, -0.559087f, -0.00181361f, -0.829107f, 
		0.866896f, 0.229172f, -0.442686f, 0.341013f, 0.914208f, 0.218937f, 
		-0.751167f, -0.325470f, -0.574297f, -0.621626f, 0.614401f, -0.485893f, 
		0.791472f, 0.111150f, -0.601015f, 0.812018f, 0.0918582f, -0.576358f, 
		0.578938f, 0.804025f, -0.135551f, -0.824221f, 0.536620f, 0.180825f, 
		-0.604934f, -0.432769f, -0.668405f, -0.470241f, -0.479053f, -0.741203f, 
		-0.542337f, -0.457392f, -0.704744f, -0.810860f, -0.369217f, -0.454077f, 
		-0.667385f, -0.411633f, -0.620609f, -0.822859f, 0.0609111f, 0.564972f, 
		-0.817826f, 0.212913f, 0.534630f, -0.700845f, 0.357843f, 0.617061f, 
		-0.773329f, 0.278178f, 0.569719f, -0.812017f, -0.170990f, -0.558024f, 
		-0.960568f, 0.00878060f, 0.277907f, -0.755143f, 0.216358f, 0.618827f, 
		-0.808171f, 0.155476f, 0.568056f, -0.539484f, 0.128196f, -0.832179f, 
		-0.382931f, -0.0385310f, -0.922973f, -0.803389f, 0.114907f, 0.584262f, 
		0.564722f, 0.108004f, 0.818183f, -0.380720f, 0.895315f, 0.231222f, 
		-0.116749f, 0.984317f, 0.132251f, -0.304447f, 0.931410f, 0.199469f, 
		0.831211f, -0.146457f, -0.536320f, 0.462646f, -0.756992f, 0.461435f, 
		-0.803456f, -0.509742f, 0.307605f, -0.745811f, 0.279464f, -0.604703f, 
		-0.685686f, -0.148210f, -0.712649f, -0.708749f, 0.111511f, -0.696592f, 
		-0.787322f, -0.0380393f, 0.615368f, -0.789549f, -0.584858f, -0.185886f, 
		0.701367f, 0.102835f, -0.705343f, -0.0336742f, -0.846324f, 0.531603f, 
		-0.803395f, -0.580385f, 0.133081f, -0.802742f, 0.358612f, -0.476447f, 
		-0.252155f, -0.619515f, -0.743383f, -0.842893f, -0.473466f, -0.255658f, 
		-0.728586f, -0.583368f, -0.358948f, -0.573812f, -0.648955f, -0.499598f, 
		-0.893514f, -0.395733f, 0.212196f, -0.795456f, -0.354976f, 0.491164f, 
		-0.836844f, -0.360502f, 0.411983f, 0.811054f, -0.0598717f, 0.581899f, 
		0.765086f, -0.0705603f, 0.640050f, 0.781366f, 0.302915f, 0.545627f, 
		0.764083f, 0.0872959f, 0.639184f, -0.792195f, 0.400128f, 0.460787f, 
		-0.799017f, -0.513099f, -0.313531f, -0.858516f, -0.487154f, 0.160100f, 
		-0.840395f, -0.538288f, 0.0631047f, -0.840140f, -0.504327f, 0.199548f, 
		-0.915460f, -0.346726f, 0.204240f, -0.846818f, -0.324066f, 0.421758f, 
		-0.870422f, -0.383938f, 0.308153f, -0.109860f, 0.993919f, -0.00740849f, 
		-0.176450f, 0.951950f, -0.250312f, -0.0822980f, 0.987340f, 0.135598f, 
		-0.875422f, -0.196005f, 0.441835f, -0.547551f, -0.374321f, 0.748379f, 
		-0.804416f, 0.0380217f, 0.592849f, -0.787133f, -0.00437471f, 0.616768f, 
		-0.870195f, 0.195395f, 0.452306f, -0.716867f, 0.407511f, 0.565717f, 
		-0.828914f, 0.254321f, 0.498219f, -0.845170f, -0.0406530f, -0.532949f, 
		0.568693f, -0.0715677f, 0.819430f, 0.980381f, 0.168635f, -0.102055f, 
		-0.107311f, -0.254162f, -0.961190f, -0.286443f, 0.772535f, -0.566692f, 
		-0.785831f, -0.292191f, 0.545063f, -0.595251f, 0.164822f, 0.786454f, 
		0.332480f, -0.909787f, 0.248485f, 0.273774f, 0.135651f, 0.952180f, 
		0.105077f, 0.916154f, -0.386808f, 0.105154f, -0.948011f, 0.300362f, 
		0.634470f, -0.692767f, -0.342815f, -0.839924f, -0.157210f, -0.519435f, 
		0.160450f, -0.986028f, -0.0447628f, -0.345812f, -0.325830f, 0.879914f, 
		-0.519891f, 0.219301f, -0.825603f, -0.381134f, 0.917293f, -0.115376f, 
		0.140626f, -0.170382f, 0.975292f, -0.619279f, 0.0486812f, 0.783660f, 
		-0.309718f, -0.827920f, 0.467572f, -0.765848f, 0.617018f, -0.181014f, 
		-0.779329f, -0.323895f, -0.536413f, -0.754540f, 0.0164078f, 0.656048f, 
		0.343308f, -0.353516f, -0.870153f, 0.910965f, 0.141425f, 0.387482f, 
		-0.154886f, 0.330058f, -0.931167f, -0.757243f, 0.0847272f, -0.647614f, 
		-0.760221f, 0.559383f, -0.330386f, -0.982792f, -0.129001f, 0.132209f, 
		-0.877258f, -0.0176192f, 0.479696f, 0.463374f, 0.885648f, 0.0301952f, 
		-0.988517f, -0.147014f, 0.0349342f, 0.754655f, 0.0609109f, -0.653288f, 
		0.354444f, 0.797933f, -0.487516f, -0.815574f, -0.286939f, 0.502499f, 
		0.343308f, -0.353516f, -0.870153f, 0.954512f, 0.254779f, 0.154900f, 
		-0.301867f, 0.773097f, -0.557851f, 0.0365817f, 0.860774f, 0.507671f, 
		-0.0412796f, 0.970071f, 0.239287f, -0.748730f, -0.327559f, -0.576288f, 
		-0.295036f, -0.936559f, -0.189237f, 0.824796f, 0.166972f, -0.540215f, 
		-0.440857f, -0.842376f, -0.309914f, -0.756994f, -0.112525f, 0.643659f, 
		0.157092f, -0.941359f, 0.298607f, -0.901443f, -0.351983f, -0.252011f, 
		-0.352701f, -0.0740921f, 0.932798f, -0.741513f, -0.175148f, 0.647674f, 
		-0.632388f, 0.407871f, 0.658580f, -0.675379f, 0.323282f, 0.662836f, 
		-0.703944f, 0.238398f, 0.669051f, 0.311289f, 0.619246f, 0.720856f, 
		0.194546f, -0.152645f, 0.968943f, -0.603347f, 0.266623f, 0.751588f, 
		0.537723f, -0.256487f, 0.803162f, 0.257628f, -0.408303f, -0.875737f, 
		0.0377492f, -0.412221f, -0.910301f, 0.178205f, -0.420964f, -0.889400f, 
		-0.529394f, -0.312470f, 0.788736f, -0.743838f, -0.493700f, -0.450517f, 
		-0.562507f, 0.360642f, 0.743991f, 0.308355f, 0.579674f, 0.754251f, 
		-0.731093f, -0.513944f, 0.448737f, 0.313807f, 0.616127f, 0.722435f, 
		-0.483370f, 0.707295f, 0.515837f, -0.317402f, 0.868042f, 0.381783f, 
		-0.215393f, 0.940833f, 0.261610f, -0.695153f, 0.561522f, 0.448837f, 
		-0.540372f, -0.822817f, -0.175984f, -0.529669f, -0.845047f, 0.0731196f, 
		-0.363655f, -0.844323f, -0.393540f, -0.381758f, -0.911058f, -0.155673f, 
		-0.943686f, -0.219664f, -0.247396f, -0.846135f, -0.0585459f, 0.529743f, 
		-0.267385f, -0.935264f, -0.231919f, -0.685686f, -0.148210f, -0.712649f, 
		-0.741271f, 0.583594f, 0.331565f, -0.626967f, 0.395647f, 0.671101f, 
		0.164092f, 0.982919f, 0.0833368f, 0.146058f, -0.964037f, 0.222034f, 
		0.345220f, -0.935614f, 0.0738135f, 0.593816f, -0.789969f, -0.152747f, 
		0.0812438f, -0.237428f, -0.968002f, -0.822853f, 0.353840f, 0.444646f, 
		-0.722340f, 0.338976f, 0.602760f, -0.919942f, 0.351884f, 0.172874f, 
		-0.939531f, 0.315123f, -0.134087f, -0.873402f, 0.354271f, 0.334157f, 
		-0.939334f, 0.338928f, 0.0527225f, -0.732922f, -0.680308f, -0.00236785f, 
		-0.360317f, -0.124392f, 0.924499f, 0.939190f, 0.112243f, 0.324535f, 
		0.471309f, 0.0814819f, 0.878196f, 0.592360f, 0.126508f, 0.795679f, 
		0.517447f, 0.106300f, 0.849087f, -0.384193f, -0.605416f, 0.697042f, 
		-0.725692f, 0.251700f, -0.640327f, 0.162260f, 0.944745f, 0.284830f, 
		-0.595414f, 0.519799f, 0.612611f, -0.566626f, 0.234088f, 0.790024f, 
		0.265381f, 0.295698f, 0.917679f, -0.799244f, 0.580433f, -0.155909f, 
		-0.721719f, 0.517541f, 0.459644f, -0.718139f, -0.615634f, 0.324454f, 
		0.729384f, -0.576699f, -0.367991f, 0.804004f, -0.0756827f, -0.589787f, 
		0.663369f, -0.690231f, -0.289002f, 0.774428f, 0.0707667f, -0.628692f, 
		0.562899f, -0.196435f, 0.802843f, 0.449324f, -0.408579f, -0.794462f, 
		-0.0495071f, -0.591074f, -0.805097f, -0.140324f, -0.626118f, -0.766998f, 
		0.0408135f, -0.568213f, -0.821869f, 0.167075f, -0.448382f, -0.878089f, 
		-0.662073f, -0.693169f, 0.284913f, -0.721022f, -0.612677f, 0.323658f, 
		-0.738254f, -0.566817f, 0.365648f, -0.846135f, -0.0585459f, 0.529743f, 
		-0.563116f, -0.331045f, -0.757172f, -0.692450f, 0.0400622f, -0.720353f, 
		0.751876f, 0.0544464f, -0.657052f, -0.709689f, 0.203874f, -0.674372f, 
		-0.888986f, -0.389078f, -0.241501f, 0.639380f, -0.327733f, -0.695546f, 
		-0.714250f, -0.686839f, -0.134534f, 0.115220f, -0.132134f, -0.984513f, 
		-0.717590f, 0.517333f, -0.466295f, -0.934958f, -0.182945f, -0.303947f, 
		-0.935375f, -0.185382f, 0.301177f, -0.0257836f, -0.820700f, -0.570777f, 
		0.291681f, -0.895570f, 0.335972f, -0.450320f, -0.374988f, 0.810306f, 
		0.145803f, -0.918768f, 0.366887f, -0.395196f, -0.562588f, 0.726164f, 
		0.0799289f, -0.990921f, 0.108108f, -0.942357f, 0.310313f, -0.125179f, 
		-0.604496f, 0.0980986f, -0.790545f, 0.690362f, -0.0201442f, 0.723184f, 
		0.685685f, 0.364822f, 0.629874f, 0.723770f, 0.0790996f, 0.685493f, 
		-0.706606f, 0.707603f, 0.00249827f, 0.252508f, 0.955334f, -0.153547f, 
		-0.692663f, 0.189135f, 0.696021f, 0.369105f, -0.0385268f, 0.928589f, 
		0.593586f, 0.199637f, 0.779616f, 0.688294f, 0.414445f, -0.595389f, 
		0.0804592f, 0.995208f, 0.0555652f, -0.695938f, 0.688425f, 0.204305f, 
		-0.699516f, -0.113852f, -0.705490f, -0.694598f, -0.435209f, 0.572824f, 
		0.686523f, 0.719302f, 0.106262f, 0.263894f, 0.921823f, 0.283905f, 
		0.498849f, 0.826020f, 0.262375f, -0.936028f, -0.170128f, -0.308070f, 
		0.623146f, 0.465356f, -0.628596f, -0.689066f, 0.398530f, 0.605278f, 
		-0.918031f, -0.264340f, -0.295540f, -0.687976f, 0.667268f, -0.285380f, 
		0.317911f, 0.774884f, -0.546340f, 0.802746f, 0.0876876f, -0.589839f, 
		-0.691523f, -0.00640670f, 0.722326f, 0.420176f, -0.453341f, 0.786088f, 
		-0.139883f, -0.927072f, 0.347807f, 0.162466f, -0.940559f, 0.298251f, 
		-0.905430f, -0.344134f, -0.248531f, 0.707031f, -0.454750f, -0.541580f, 
		-0.794927f, 0.454990f, 0.401341f, -0.154706f, 0.949789f, -0.271970f, 
		0.0135061f, 0.869886f, 0.493068f, 0.162466f, -0.940559f, 0.298251f, 
		-0.352572f, -0.0739976f, 0.932854f, 0.939492f, 0.130465f, 0.316756f, 
		-0.826409f, 0.00376392f, 0.563057f, -0.803127f, -0.0509553f, 0.593625f, 
		-0.946363f, -0.249711f, -0.205042f, -0.791533f, 0.255141f, -0.555319f, 
		0.696391f, -0.290977f, -0.656028f, -0.853115f, -0.148798f, 0.500054f, 
		-0.780223f, 0.360665f, 0.511051f, -0.852094f, -0.00240233f, 0.523384f, 
		-0.601577f, 0.665277f, 0.442166f, -0.670356f, -0.726218f, 0.152416f, 
		0.980849f, 0.178039f, 0.0789789f, 0.0269152f, 0.00834981f, -0.999603f, 
		0.332887f, -0.220199f, 0.916896f, 0.499478f, -0.349495f, 0.792701f, 
		0.573834f, -0.424376f, 0.700442f, -0.644668f, 0.292811f, 0.706162f, 
		-0.651833f, 0.743801f, -0.147896f, 0.594189f, 0.196606f, 0.779927f, 
		0.681271f, 0.274979f, 0.678422f, 0.750702f, 0.233042f, 0.618173f, 
		0.644890f, 0.218315f, 0.732431f, 0.537636f, 0.170130f, 0.825835f, 
		0.133074f, 0.971206f, 0.197609f, -0.615626f, 0.601954f, 0.508582f, 
		-0.562201f, -0.489764f, -0.666380f, -0.476713f, -0.708713f, -0.520068f, 
		0.791472f, 0.111150f, -0.601015f, -0.531978f, -0.605484f, -0.591936f, 
		-0.670031f, -0.423533f, -0.609654f, -0.312883f, -0.949703f, 0.0130142f, 
		-0.670117f, -0.658702f, -0.342132f, -0.666289f, -0.280369f, -0.690979f, 
		0.639488f, -0.752700f, -0.156515f, -0.656494f, 0.405827f, -0.635861f, 
		0.00891630f, -0.0707417f, -0.997455f, 0.0709208f, -0.857943f, -0.508825f, 
		-0.166790f, -0.947523f, -0.272728f, 0.446994f, -0.591526f, -0.671039f, 
		0.278267f, -0.672080f, -0.686204f, 0.599041f, -0.293004f, -0.745184f, 
		0.220890f, -0.892150f, 0.394050f, 0.562211f, 0.686447f, 0.461205f, 
		0.415317f, 0.731992f, 0.540093f, 0.427210f, 0.897402f, 0.110274f, 
		0.242311f, 0.970133f, 0.0113051f, 0.293949f, 0.897720f, 0.328166f, 
		-0.453462f, 0.876593f, 0.161108f, -0.322587f, -0.565857f, 0.758778f, 
		-0.503976f, -0.806021f, 0.310385f, -0.644937f, -0.627598f, 0.436093f, 
		-0.771686f, -0.304330f, 0.558465f, -0.837615f, -0.120855f, 0.532725f, 
		-0.651029f, -0.340970f, 0.678159f, 0.800503f, -0.260980f, -0.539523f, 
		0.708012f, -0.277409f, -0.649433f, 0.752236f, -0.276916f, -0.597878f, 
		0.706580f, 0.524722f, 0.474777f, 0.522548f, 0.520713f, 0.675131f, 
		0.451133f, 0.324193f, 0.831492f, 0.647594f, 0.378638f, 0.661253f, 
		0.714536f, -0.668447f, 0.206440f, 0.220315f, -0.967421f, 0.124734f, 
		0.619207f, -0.753740f, 0.220133f, -0.627509f, -0.564430f, -0.536332f, 
		0.672955f, -0.317896f, -0.667887f, 0.737383f, 0.345093f, 0.580670f, 
		0.681875f, 0.528695f, 0.505498f, 0.585515f, 0.427198f, 0.688965f, 
		0.530532f, 0.000659844f, 0.847665f, 0.362663f, -0.147082f, 0.920240f, 
		0.372139f, 0.0569950f, 0.926425f, 0.752280f, -0.385439f, -0.534333f, 
		0.607110f, 0.0953241f, 0.788879f, -0.628551f, 0.660265f, 0.411064f, 
		0.522380f, 0.809931f, 0.266703f, 0.376256f, 0.804129f, 0.460227f, 
		0.374440f, 0.900572f, 0.220827f, 0.500957f, 0.865299f, 0.0173110f, 
		-0.892971f, -0.344925f, -0.289188f, 0.105415f, -0.0151629f, -0.994313f, 
		-0.698279f, -0.445325f, 0.560439f, 0.975275f, 0.141513f, -0.169744f, 
		-0.0617937f, -0.667713f, -0.741850f, -0.633373f, -0.619862f, 0.463260f, 
		0.240494f, 0.360452f, 0.901242f, 0.408161f, 0.297009f, 0.863244f, 
		0.674900f, 0.240247f, 0.697704f, 0.872647f, 0.151247f, 0.464340f, 
		0.800952f, 0.469876f, -0.371068f, 0.909036f, 0.187341f, -0.372233f, 
		0.868446f, 0.359493f, -0.341419f, 0.684100f, 0.618890f, -0.385983f, 
		0.593849f, 0.694661f, -0.405942f, 0.468561f, 0.816137f, -0.338186f, 
		0.576328f, -0.262169f, 0.774024f, -0.615481f, -0.175983f, 0.768253f, 
		-0.631190f, 0.641765f, -0.435588f, -0.558711f, 0.825373f, -0.0812433f, 
		-0.616013f, 0.0932557f, -0.782196f, 0.167835f, -0.939731f, 0.297887f, 
		0.938665f, 0.128847f, 0.319853f, 0.707013f, -0.454754f, -0.541600f, 
		-0.717955f, -0.261841f, -0.644965f, -0.376061f, -0.282779f, 0.882391f, 
		-0.624654f, -0.0747743f, -0.777313f, -0.641231f, -0.448564f, 0.622586f, 
		-0.915957f, -0.278949f, -0.288463f, -0.198027f, 0.953211f, -0.228417f, 
		-0.531236f, -0.586554f, -0.611345f, -0.768481f, -0.256332f, 0.586285f, 
		0.0633531f, 0.997917f, 0.0121795f, -0.578813f, 0.664074f, 0.473266f, 
		0.330217f, -0.301160f, -0.894572f, 0.643006f, -0.324541f, -0.693697f, 
		0.840415f, -0.346835f, -0.416422f, 0.623519f, -0.184783f, 0.759658f, 
		0.920168f, -0.169799f, -0.352788f, 0.796590f, 0.239213f, 0.555177f, 
		-0.613485f, -0.559614f, 0.557196f, -0.718428f, 0.344258f, 0.604440f, 
		0.0101167f, 0.127669f, 0.991765f, 0.828396f, -0.493298f, -0.265362f, 
		0.768165f, -0.625828f, -0.135132f, 0.892817f, -0.0507310f, -0.447554f, 
		0.872741f, 0.153855f, -0.463306f, -0.776503f, -0.0773842f, 0.625343f, 
		-0.835672f, 0.0883474f, 0.542077f, -0.824896f, 0.477740f, 0.302178f, 
		-0.752797f, 0.628794f, 0.194715f, -0.867599f, -0.0114001f, -0.497134f, 
		0.816975f, 0.576476f, 0.0151065f, 0.955680f, 0.293859f, 0.0179497f, 
		0.739589f, 0.664676f, 0.105897f, 0.105594f, -0.969064f, 0.223080f, 
		-0.101353f, -0.870871f, 0.480948f, -0.184710f, -0.815305f, 0.548780f, 
		0.973812f, 0.191446f, -0.122630f, 0.134416f, -0.270604f, -0.953261f, 
		0.873638f, -0.0803475f, -0.479896f, 0.870090f, 0.261812f, 0.417609f, 
		-0.683606f, 0.0877797f, 0.724553f, 0.908750f, -0.272432f, -0.316157f, 
		0.757560f, 0.168887f, 0.630540f, -0.591455f, 0.794924f, 0.135188f, 
		-0.584413f, 0.591297f, 0.555724f, 0.343308f, -0.353516f, -0.870153f, 
		0.852517f, 0.493070f, 0.173482f, -0.158838f, 0.324913f, -0.932310f, 
		-0.910343f, -0.156881f, -0.382966f, 0.678429f, -0.427137f, -0.597736f, 
		0.743024f, -0.274104f, -0.610559f, 0.713679f, -0.354696f, -0.604030f, 
		-0.591376f, -0.726864f, 0.349205f, 0.0166246f, -0.0179481f, -0.999701f, 
		0.296728f, 0.0119807f, -0.954887f, 0.685836f, 0.0153846f, -0.727594f, 
		0.939132f, 0.0950605f, 0.330143f, 0.713369f, -0.393131f, -0.580132f, 
		0.879432f, -0.141443f, -0.454524f, 0.866353f, 0.238179f, 0.438979f, 
		-0.376887f, 0.924108f, 0.0630866f, -0.469286f, -0.0239167f, 0.882722f, 
		-0.586816f, 0.0379217f, 0.808832f, -0.581809f, -0.813322f, -0.00230660f, 
		-0.559943f, 0.491652f, 0.666890f, 0.922517f, 0.382136f, 0.0541646f, 
		0.778972f, -0.475886f, 0.408331f, 0.936585f, 0.188678f, -0.295312f, 
		0.950522f, 0.299987f, -0.0807170f, -0.318920f, -0.931051f, 0.177297f, 
		-0.422792f, -0.875678f, 0.233313f, -0.375326f, -0.868863f, 0.322811f, 
		-0.333635f, -0.912549f, 0.236522f, -0.265567f, -0.933172f, 0.242205f, 
		-0.585594f, 0.260323f, -0.767666f, 0.221281f, -0.202755f, -0.953900f, 
		0.945300f, -0.254991f, -0.203438f, -0.666933f, 0.196060f, 0.718861f, 
		0.898323f, -0.299801f, -0.321146f, 0.681960f, 0.217975f, 0.698153f, 
		-0.765667f, -0.191355f, 0.614116f, -0.946102f, -0.215621f, -0.241659f, 
		-0.658230f, -0.0599029f, 0.750430f, -0.464376f, 0.816783f, -0.342375f, 
		-0.663514f, 0.743768f, 0.0809784f, -0.683415f, 0.676564f, 0.274236f, 
		-0.299780f, 0.834621f, -0.462105f, 0.703864f, 0.700942f, 0.115134f, 
		0.839931f, 0.0138403f, -0.542516f, -0.888080f, -0.454902f, -0.0661732f, 
		0.350165f, 0.936565f, 0.0151629f, 0.775949f, -0.106307f, -0.621773f, 
		0.00464489f, -0.0908793f, -0.995851f, -0.580582f, 0.161294f, 0.798066f, 
		-0.567034f, -0.452448f, -0.688305f, -0.555995f, 0.552307f, -0.621149f, 
		0.939403f, 0.0789413f, 0.333603f, 0.594254f, -0.257795f, -0.761842f, 
		0.160450f, -0.986028f, -0.0447628f, -0.549343f, -0.813568f, 0.190601f, 
		0.940079f, -0.236462f, -0.245635f, 0.608011f, -0.0236012f, 0.793578f, 
		-0.394673f, -0.623623f, 0.674779f, -0.222895f, -0.732013f, 0.643797f, 
		-0.721632f, -0.0483534f, 0.690586f, -0.682131f, -0.248157f, 0.687834f, 
		0.626651f, -0.0443143f, 0.778039f, -0.829044f, -0.520968f, 0.203171f, 
		-0.540808f, 0.766355f, -0.346738f, 0.738050f, 0.109185f, 0.665854f, 
		0.782477f, 0.0685900f, 0.618890f, 0.755334f, 0.193463f, 0.626133f, 
		0.723270f, 0.314484f, 0.614801f, 0.709182f, 0.249290f, 0.659481f, 
		-0.542132f, -0.815411f, -0.202972f, -0.549045f, 0.774393f, 0.314429f, 
		-0.558736f, -0.671180f, -0.487167f, 0.471223f, 0.0661337f, -0.879531f, 
		-0.449379f, 0.893144f, 0.0187664f, -0.556533f, 0.830806f, -0.00566116f, 
		-0.609936f, 0.219886f, 0.761333f, -0.271866f, -0.748139f, 0.605290f, 
		-0.385970f, -0.587027f, 0.711637f, -0.218369f, -0.802858f, 0.554738f, 
		-0.779891f, -0.201742f, 0.592512f, -0.504375f, -0.449239f, -0.737421f, 
		-0.550208f, 0.352107f, 0.757161f, -0.493168f, 0.406971f, 0.768869f, 
		-0.367998f, 0.755117f, 0.542564f, -0.508612f, 0.310823f, 0.802934f, 
		-0.523171f, -0.371971f, 0.766766f, -0.546678f, -0.282303f, -0.788320f, 
		-0.583014f, -0.141547f, 0.800037f, -0.297433f, -0.0333866f, -0.954159f, 
		-0.513683f, 0.201771f, 0.833917f, 0.216568f, -0.134555f, -0.966950f, 
		0.923043f, -0.279120f, -0.264734f, -0.534531f, -0.505320f, 0.677443f, 
		-0.505125f, 0.847484f, -0.163152f, -0.563601f, 0.104359f, 0.819428f, 
		0.936024f, -0.274458f, -0.220300f, 0.621121f, -0.229218f, 0.749445f, 
		-0.828426f, 0.480226f, 0.288259f, -0.176450f, 0.951950f, -0.250312f, 
		-0.425427f, -0.627648f, -0.651974f, -0.508960f, -0.752603f, -0.417791f, 
		0.0545493f, -0.564664f, 0.823516f, -0.741770f, 0.0290145f, 0.670026f, 
		-0.443231f, 0.639583f, 0.628076f, -0.00954854f, 0.999834f, -0.0155071f, 
		0.257733f, 0.727499f, 0.635861f, 0.139993f, 0.851252f, 0.505740f, 
		0.417590f, 0.394033f, 0.818753f, 0.774542f, -0.163299f, 0.611080f, 
		-0.770722f, 0.623727f, 0.130200f, -0.684721f, 0.728570f, 0.0185284f, 
		-0.532755f, 0.813387f, -0.233610f, -0.433812f, 0.846293f, -0.309184f, 
		-0.595392f, 0.785946f, -0.166725f, -0.512407f, 0.370791f, -0.774566f, 
		-0.00610170f, -0.993544f, -0.113287f, 0.228192f, 0.972613f, 0.0441866f, 
		0.0838063f, 0.939346f, -0.332573f, -0.104812f, 0.764495f, -0.636051f, 
		0.0142121f, -0.818298f, 0.574619f, -0.527670f, 0.0473966f, 0.848126f, 
		0.637490f, 0.224516f, 0.737020f, 0.542507f, 0.825636f, -0.154960f, 
		0.848492f, 0.0955394f, -0.520513f, -0.500230f, -0.105142f, -0.859485f, 
		-0.394323f, -0.498286f, 0.772153f, -0.0639100f, 0.179572f, -0.981667f, 
		-0.845050f, -0.274968f, -0.458566f, -0.493889f, -0.691179f, 0.527584f, 
		0.477819f, 0.472146f, -0.740788f, -0.0616165f, 0.997774f, -0.0255139f, 
		-0.477975f, -0.637507f, -0.604255f, -0.701747f, 0.204337f, 0.682494f, 
		-0.746856f, 0.488129f, 0.451593f, -0.752449f, 0.354634f, 0.555027f, 
		-0.703864f, 0.665760f, 0.247669f, -0.742722f, 0.274112f, 0.610923f, 
		0.251161f, -0.0763789f, -0.964927f, 0.932878f, -0.173350f, -0.315734f, 
		0.201958f, -0.965229f, -0.165969f, 0.437068f, -0.803132f, -0.404909f, 
		0.0167713f, -0.999356f, 0.0317351f, 0.579642f, -0.685440f, -0.440667f, 
		-0.467990f, 0.702553f, -0.536101f, -0.825020f, 0.305362f, 0.475497f, 
		-0.610936f, -0.286321f, -0.738090f, -0.477630f, -0.804947f, 0.352038f, 
		-0.831082f, 0.255348f, -0.494065f, -0.475233f, -0.255343f, 0.841994f, 
		-0.456761f, 0.873341f, 0.169249f, -0.481493f, -0.450904f, 0.751565f, 
		-0.356599f, -0.471199f, 0.806727f, 0.0480911f, -0.812085f, 0.581554f, 
		0.105509f, -0.625336f, 0.773190f, 0.122922f, -0.890370f, 0.438327f, 
		0.212553f, -0.756013f, 0.619085f, -0.458846f, -0.0740861f, 0.885422f, 
		0.547011f, 0.148966f, 0.823765f, -0.0724711f, -0.664455f, 0.743806f, 
		-0.660673f, 0.177124f, 0.729478f, 0.116093f, -0.969753f, 0.214712f, 
		0.532639f, -0.0473173f, 0.845019f, -0.471382f, 0.745507f, 0.471188f, 
		0.949540f, 0.146097f, -0.277542f, 0.187769f, -0.546935f, -0.815846f, 
		-0.467281f, 0.144410f, -0.872235f, -0.450738f, 0.104012f, 0.886576f, 
		-0.128091f, -0.819534f, 0.558531f, -0.268168f, -0.555661f, 0.786973f, 
		-0.0205601f, -0.926078f, 0.376772f, 0.389520f, 0.434746f, -0.811955f, 
		-0.832593f, -0.423637f, -0.356821f, -0.874335f, -0.175535f, -0.452466f, 
		-0.450143f, -0.471990f, -0.758022f, 0.359120f, 0.0442843f, -0.932240f, 
		0.951598f, -0.0558724f, -0.302226f, 0.920990f, -0.247489f, -0.300876f, 
		0.677394f, -0.223676f, 0.700790f, -0.466316f, -0.136714f, 0.873990f, 
		-0.650938f, -0.480143f, 0.587999f, 0.836906f, -0.0552756f, -0.544549f, 
		0.714952f, -0.542484f, -0.441083f, 0.628263f, -0.688927f, -0.361475f, 
		0.814198f, 0.102962f, -0.571384f, -0.900224f, 0.350686f, 0.258101f, 
		-0.427318f, 0.701096f, 0.570845f, 0.763504f, 0.0434043f, -0.644343f, 
		0.562434f, 0.0550810f, -0.825006f, 0.836348f, 0.0273906f, -0.547513f, 
		0.583371f, 0.807506f, -0.0872456f, 0.0201567f, 0.601196f, -0.798847f, 
		0.768384f, 0.101415f, -0.631902f, -0.430755f, -0.851032f, -0.300323f, 
		-0.424138f, 0.477427f, 0.769526f, -0.436022f, 0.497611f, -0.749845f, 
		-0.645020f, -0.434149f, -0.628859f, -0.448379f, -0.130277f, 0.884299f, 
		0.184862f, -0.666053f, 0.722634f, -0.436031f, -0.880199f, 0.187418f, 
		0.976483f, 0.207603f, 0.0581502f, 0.867339f, 0.0637709f, -0.493616f, 
		0.932943f, 0.0513165f, -0.356348f, 0.859129f, 0.325219f, 0.395132f, 
		0.773598f, -0.213381f, -0.596669f, 0.906639f, -0.146310f, 0.395725f, 
		-0.420509f, 0.831935f, 0.362018f, -0.0987180f, 0.750521f, -0.653432f, 
		-0.419222f, -0.330855f, -0.845451f, -0.555352f, -0.392902f, 0.732948f, 
		-0.324272f, 0.945787f, 0.0183116f, 0.132118f, -0.207134f, -0.969350f, 
		-0.745106f, -0.416145f, -0.521192f, -0.403109f, 0.599881f, 0.691120f, 
		-0.402076f, -0.0249395f, -0.915267f, -0.416671f, 0.634314f, -0.651177f, 
		-0.943027f, 0.313083f, -0.112604f, -0.602439f, 0.0905046f, -0.793017f, 
		0.447063f, 0.0982468f, -0.889091f, -0.0226153f, -0.804711f, 0.593236f, 
		-0.410700f, -0.911768f, 0.00224880f, 0.935207f, 0.134197f, -0.327688f, 
		-0.0797427f, -0.816098f, -0.572385f, 0.267270f, -0.887064f, 0.376410f, 
		-0.411200f, 0.911398f, -0.0163920f, -0.765604f, -0.268447f, 0.584625f, 
		0.172919f, -0.959257f, 0.223440f, -0.926783f, -0.273619f, -0.257306f, 
		0.454305f, -0.337550f, -0.824419f, 0.313909f, 0.0132506f, 0.949361f, 
		-0.671298f, 0.557110f, -0.488862f, 0.376245f, -0.233741f, -0.896552f, 
		0.0598300f, -0.959142f, 0.276528f, -0.295725f, 0.954540f, -0.0374262f, 
		-0.453257f, 0.836216f, 0.308709f, -0.374145f, 0.925120f, 0.0645716f, 
		0.947996f, -0.0987619f, -0.302572f, 0.679482f, -0.176037f, 0.712260f, 
		-0.388432f, -0.603842f, 0.696057f, 0.967713f, 0.0840141f, -0.237639f, 
		0.769241f, 0.286328f, 0.571214f, -0.397354f, 0.855977f, -0.330777f, 
		0.743485f, -0.630295f, -0.223514f, 0.321633f, -0.772824f, 0.547079f, 
		-0.337319f, -0.575200f, 0.745226f, -0.377122f, -0.915228f, -0.141902f, 
		-0.374797f, -0.728937f, 0.572868f, -0.594301f, 0.803852f, -0.0250688f, 
		-0.392250f, -0.482822f, 0.782958f, -0.835016f, -0.479086f, -0.270602f, 
		-0.374047f, -0.196089f, -0.906442f, 0.959372f, 0.0265970f, -0.280889f, 
		0.713690f, -0.100957f, 0.693148f, -0.0941060f, -0.603588f, 0.791723f, 
		-0.212237f, 0.293246f, 0.932181f, 0.196688f, 0.291446f, 0.936148f, 
		-0.0619795f, 0.289038f, 0.955309f, -0.407361f, 0.345666f, 0.845324f, 
		-0.380559f, 0.687565f, 0.618408f, -0.607275f, 0.391478f, 0.691348f, 
		0.219933f, 0.263447f, 0.939268f, -0.180184f, 0.898324f, 0.400683f, 
		-0.371280f, -0.794454f, -0.480618f, -0.538290f, 0.627902f, 0.562124f, 
		0.728099f, 0.0399520f, -0.684307f, 0.827956f, -0.302910f, -0.471948f, 
		0.813472f, -0.515194f, -0.269886f, 0.781779f, -0.602937f, -0.159027f, 
		-0.359908f, 0.337927f, -0.869639f, -0.347865f, -0.592849f, -0.726306f, 
		0.548442f, -0.761752f, 0.344883f, 0.352458f, -0.769250f, 0.532943f, 
		0.754431f, -0.655338f, 0.0369607f, -0.0291107f, 0.887291f, -0.460291f, 
		-0.357702f, -0.841730f, 0.404400f, -0.354299f, -0.382833f, 0.853177f, 
		0.0982294f, 0.632405f, -0.768384f, 0.281085f, 0.556474f, -0.781875f, 
		0.655857f, 0.225623f, -0.720379f, 0.736304f, 0.0355229f, -0.675718f, 
		-0.337655f, 0.0665078f, 0.938917f, -0.334525f, 0.572114f, -0.748851f, 
		0.219158f, -0.973791f, -0.0608359f, -0.354994f, -0.320212f, 0.878318f, 
		-0.307275f, -0.225988f, 0.924398f, -0.364724f, 0.801882f, -0.473245f, 
		-0.528459f, 0.304885f, 0.792323f, -0.340552f, 0.252556f, 0.905671f, 
		-0.324486f, -0.691367f, -0.645539f, -0.641231f, -0.448564f, 0.622586f, 
		-0.103062f, -0.986787f, 0.125021f, -0.728170f, -0.506470f, -0.461797f, 
		-0.315931f, 0.925725f, -0.207897f, -0.321309f, 0.890185f, 0.323004f, 
		-0.314651f, -0.899459f, -0.303262f, -0.284157f, -0.356617f, -0.889988f, 
		-0.298330f, 0.717752f, 0.629152f, -0.724326f, 0.335964f, 0.602063f, 
		-0.0105339f, 0.135490f, 0.990723f, 0.0913034f, -0.735323f, 0.671538f, 
		0.173180f, 0.319056f, 0.931779f, 0.837925f, -0.110107f, 0.534564f, 
		0.611229f, -0.285820f, 0.738042f, -0.337305f, -0.697957f, 0.631729f, 
		-0.313393f, -0.554850f, 0.770666f, -0.330656f, -0.653961f, 0.680443f, 
		-0.526684f, -0.430264f, 0.733128f, 0.0667359f, 0.997663f, -0.0146910f, 
		0.351697f, 0.895989f, -0.271134f, -0.0114781f, 0.988111f, 0.153312f, 
		0.578298f, 0.776030f, -0.251691f, -0.301572f, 0.939138f, 0.164541f, 
		0.778136f, -0.627487f, 0.0276352f, -0.275479f, 0.430777f, 0.859385f, 
		-0.289869f, -0.0872670f, 0.953079f, -0.290069f, -0.0793417f, -0.953711f, 
		0.743403f, -0.337902f, -0.577213f, 0.0621308f, -0.161661f, -0.984889f, 
		-0.360155f, -0.495477f, 0.790437f, -0.280932f, -0.213000f, 0.935793f, 
		-0.0121479f, 0.186614f, 0.982358f, 0.611229f, -0.285820f, 0.738042f, 
		-0.353315f, -0.361835f, 0.862696f, -0.299540f, -0.492874f, -0.816916f, 
		0.434384f, 0.214084f, 0.874916f, 0.196688f, 0.291446f, 0.936148f, 
		0.560362f, 0.150234f, 0.814509f, 0.108580f, 0.912954f, 0.393351f, 
		0.771210f, 0.636288f, 0.0192865f, -0.338706f, 0.916362f, 0.213443f, 
		-0.270565f, -0.560232f, 0.782901f, -0.254455f, -0.775524f, 0.577768f, 
		-0.836420f, -0.504961f, 0.213109f, -0.251504f, 0.967537f, -0.0248807f, 
		0.747628f, -0.583798f, 0.316594f, 0.428014f, -0.788147f, 0.442299f, 
		0.833758f, -0.498599f, 0.237165f, -0.258503f, -0.655787f, 0.709309f, 
		-0.0273600f, -0.621700f, -0.782777f, 0.0789829f, -0.551128f, -0.830674f, 
		-0.463548f, -0.658407f, -0.592978f, -0.149983f, -0.604785f, -0.782139f, 
		-0.299290f, -0.710641f, -0.636722f, 0.875994f, 0.135760f, -0.462821f, 
		0.0976156f, -0.966556f, 0.237152f, 0.00136176f, -0.749427f, -0.662085f, 
		-0.803941f, -0.257557f, -0.536044f, -0.265099f, 0.833915f, 0.484055f, 
		0.727255f, 0.191016f, 0.659252f, -0.314069f, 0.920832f, 0.231147f, 
		-0.416643f, -0.0499336f, 0.907698f, -0.240103f, 0.189781f, 0.952015f, 
		0.512528f, 0.761401f, -0.396967f, 0.410247f, 0.633528f, -0.656003f, 
		0.861977f, 0.432819f, -0.263939f, 0.597379f, 0.468361f, -0.650981f, 
		0.751283f, 0.617551f, -0.232820f, -0.273014f, 0.550004f, 0.789278f, 
		0.909677f, -0.153646f, -0.385850f, 0.819310f, 0.0965826f, -0.565157f, 
		0.869367f, -0.0742415f, -0.488558f, 0.928013f, -0.354401f, -0.114855f, 
		0.868013f, -0.496353f, -0.0136416f, 0.924074f, -0.301239f, -0.235250f, 
		-0.733913f, -0.428793f, 0.526791f, -0.304612f, 0.861007f, 0.407281f, 
		-0.307568f, 0.226097f, 0.924274f, -0.267547f, -0.938444f, 0.218496f, 
		-0.258755f, -0.849633f, -0.459532f, -0.274782f, 0.115331f, -0.954565f, 
		-0.347857f, 0.217384f, 0.911997f, -0.270029f, 0.916123f, 0.296316f, 
		-0.242667f, 0.940920f, 0.236181f, -0.216862f, 0.965387f, 0.144913f, 
		-0.485997f, 0.273940f, 0.829918f, -0.265111f, 0.758472f, -0.595346f, 
		-0.480384f, 0.132093f, 0.867054f, -0.247941f, -0.953177f, -0.173147f, 
		-0.476520f, 0.359665f, 0.802228f, 0.242148f, 0.323834f, -0.914601f, 
		-0.201808f, 0.979425f, 0.000983287f, -0.239981f, -0.970351f, 0.0287688f, 
		-0.245371f, 0.880719f, -0.405126f, -0.285937f, -0.0403802f, -0.957397f, 
		-0.243067f, -0.528047f, 0.813686f, 0.981621f, 0.147072f, -0.121614f, 
		0.969166f, -0.138629f, 0.203715f, 0.893073f, -0.223196f, 0.390646f, 
		0.880706f, 0.428559f, -0.201726f, -0.222294f, -0.757962f, -0.613253f, 
		-0.464417f, 0.161818f, 0.870708f, -0.227841f, 0.477932f, -0.848333f, 
		-0.696682f, 0.565684f, -0.441175f, 0.768408f, -0.195997f, 0.609208f, 
		-0.421107f, 0.297655f, 0.856779f, -0.217381f, 0.290531f, -0.931846f, 
		-0.494185f, 0.0197552f, 0.869132f, -0.387727f, 0.921770f, 0.00282957f, 
		-0.219542f, -0.218461f, -0.950829f, -0.427785f, -0.656371f, 0.621431f, 
		-0.326601f, -0.769226f, 0.549203f, -0.368449f, -0.726471f, 0.580073f, 
		0.758445f, 0.226342f, 0.611172f, -0.0276432f, -0.802478f, 0.596041f, 
		-0.404548f, -0.00631144f, 0.914495f, -0.389155f, -0.248337f, 0.887067f, 
		-0.198624f, 0.656935f, -0.727314f, -0.193417f, -0.912300f, -0.360969f, 
		0.611229f, -0.285820f, 0.738042f, -0.573874f, -0.792749f, 0.205470f, 
		0.0619632f, 0.417568f, 0.906530f, -0.633730f, -0.365801f, 0.681598f, 
		-0.512574f, -0.161016f, 0.843411f, -0.560858f, -0.212610f, 0.800147f, 
		-0.844558f, -0.534045f, -0.0389614f, -0.437881f, -0.717091f, 0.542255f, 
		-0.545979f, -0.551836f, 0.630384f, -0.686473f, -0.448555f, 0.572322f, 
		-0.759562f, -0.380181f, 0.527758f, -0.191645f, 0.649197f, 0.736081f, 
		-0.179650f, -0.888015f, 0.423267f, -0.170803f, -0.380894f, 0.908706f, 
		0.197789f, 0.231474f, -0.952523f, -0.178050f, 0.937460f, 0.299110f, 
		-0.170097f, 0.931726f, -0.320863f, -0.408524f, -0.670445f, 0.619364f, 
		-0.153700f, -0.984358f, -0.0861089f, -0.596387f, -0.534701f, -0.598680f, 
		-0.425808f, -0.0573605f, 0.902994f, 0.963006f, 0.245568f, -0.110977f, 
		0.615040f, -0.211206f, 0.759683f, 0.289413f, -0.895845f, 0.337197f, 
		0.457521f, -0.529371f, 0.714452f, 0.193431f, -0.978287f, 0.0744268f, 
		-0.151167f, 0.340232f, 0.928111f, -0.174460f, -0.635248f, -0.752346f, 
		-0.714226f, -0.526556f, -0.461108f, -0.997775f, -0.0327329f, -0.0580819f, 
		-0.461218f, -0.777352f, 0.427787f, -0.683108f, -0.672921f, 0.283796f, 
		-0.762912f, -0.580514f, 0.284550f, -0.814093f, -0.540241f, 0.213056f, 
		-0.865630f, -0.455122f, 0.208683f, 0.378460f, 0.0300877f, -0.925129f, 
		0.692769f, 0.154823f, 0.704345f, -0.312884f, 0.941982f, 0.121545f, 
		-0.336543f, -0.664708f, 0.667009f, 0.743646f, -0.342041f, -0.574456f, 
		0.893191f, -0.269182f, 0.360209f, -0.154610f, 0.0179213f, 0.987813f, 
		-0.156615f, -0.148131f, 0.976488f, -0.569832f, -0.0307288f, 0.821186f, 
		-0.392310f, -0.0873694f, 0.915674f, -0.133131f, -0.493113f, -0.859718f, 
		-0.144217f, 0.983679f, 0.107593f, -0.141748f, -0.833300f, -0.534339f, 
		-0.900436f, 0.346748f, 0.262641f, -0.376515f, -0.830473f, 0.410550f, 
		-0.131842f, 0.971565f, -0.196672f, -0.124134f, 0.763614f, 0.633628f, 
		-0.134866f, -0.0161397f, -0.990732f, 0.205849f, 0.0154720f, -0.978461f, 
		-0.176039f, -0.958756f, 0.223155f, -0.119093f, -0.959731f, -0.254427f, 
		-0.124477f, 0.872624f, -0.472264f, -0.106905f, 0.199563f, 0.974036f, 
		-0.946289f, 0.306436f, -0.103124f, -0.599296f, 0.0862507f, -0.795868f, 
		0.693084f, 0.623420f, 0.361916f, -0.411237f, -0.911500f, 0.00719189f, 
		-0.329191f, 0.308840f, 0.892329f, -0.100610f, -0.358038f, -0.928271f, 
		0.299619f, 0.0144792f, 0.953949f, -0.0967476f, 0.415476f, -0.904444f, 
		-0.104110f, 0.524502f, 0.845020f, -0.719639f, -0.433770f, -0.542183f, 
		-0.117969f, -0.705916f, 0.698403f, -0.0777468f, 0.941475f, 0.327995f, 
		-0.0857205f, -0.797017f, 0.597842f, -0.237015f, 0.289852f, 0.927259f, 
		-0.391948f, 0.233124f, 0.889961f, -0.313011f, 0.274030f, 0.909358f, 
		-0.987069f, 0.0477874f, -0.153008f, -0.0881628f, 0.917132f, 0.388712f, 
		-0.0797269f, 0.209240f, -0.974609f, -0.292667f, -0.562905f, 0.772971f, 
		-0.0838769f, 0.607923f, -0.789553f, 0.388776f, 0.0538086f, -0.919760f, 
		0.727255f, 0.191016f, 0.659252f, -0.0440099f, -0.795942f, 0.603771f, 
		-0.0746921f, -0.903881f, -0.421214f, -0.916254f, -0.213250f, 0.339122f, 
		-0.0723222f, -0.239676f, 0.968156f, -0.0742657f, -0.996077f, 0.0481137f, 
		0.987238f, 0.0779650f, -0.138862f, 0.956278f, 0.229063f, -0.181830f, 
		0.636427f, -0.766405f, -0.0870874f, 0.819681f, -0.540459f, -0.189810f, 
		-0.552892f, -0.833242f, -0.00428621f, -0.978822f, 0.0446823f, -0.199778f, 
		0.262829f, -0.117513f, -0.957659f, -0.0571667f, -0.604770f, 0.794346f, 
		-0.0614534f, -0.486639f, 0.871439f, -0.0866472f, -0.963532f, 0.253176f, 
		0.139476f, -0.988912f, 0.0509948f, -0.0691629f, 0.995439f, -0.0657148f, 
		0.945079f, 0.324466f, 0.0393418f, 0.938791f, 0.213595f, 0.270276f, 
		0.764754f, 0.0921475f, 0.637700f, -0.0563982f, 0.974227f, 0.218407f, 
		-0.0604183f, -0.205931f, -0.976700f, -0.988421f, -0.119905f, -0.0929923f, 
		-0.976856f, -0.149317f, 0.153153f, -0.906989f, -0.181480f, 0.380047f, 
		-0.987776f, -0.0105083f, 0.155527f, -0.433854f, 0.328870f, 0.838818f, 
		-0.0569650f, 0.934707f, -0.350824f, -0.633779f, -0.152424f, 0.758347f, 
		-0.319239f, -0.947538f, -0.0160643f, 0.697491f, -0.659579f, -0.280111f, 
		0.838069f, 0.523020f, 0.155213f, 0.696922f, 0.630822f, 0.341121f, 
		-0.745599f, 0.135389f, 0.652497f, -0.473576f, -0.0485931f, 0.879412f, 
		-0.419987f, 0.662262f, 0.620499f, -0.0372744f, -0.988939f, -0.143561f, 
		0.642010f, -0.736407f, -0.213373f, 0.960502f, 0.270016f, -0.0672855f, 
		-0.993869f, 0.0477947f, 0.0996976f, -0.440132f, -0.366006f, 0.819953f, 
		-0.471024f, -0.871272f, -0.137918f, -0.573449f, -0.815708f, -0.0760003f, 
		-0.624770f, -0.779035f, -0.0525954f, -0.995743f, -0.00657368f, -0.0919383f, 
		-0.991388f, 0.119967f, -0.0525065f, -0.953164f, 0.296736f, 0.0585316f, 
		-0.0500634f, 0.774465f, -0.630632f, -0.963292f, -0.0615130f, 0.261314f, 
		-0.717626f, -0.611614f, -0.333079f, -0.972787f, 0.0448388f, -0.227323f, 
		-0.0289159f, 0.997971f, 0.0567332f, 0.966779f, -0.121372f, -0.224959f, 
		0.640169f, -0.768222f, -0.00425605f, 0.894368f, -0.410337f, -0.178129f, 
		-0.489956f, 0.857254f, -0.158297f, -0.527171f, 0.188540f, -0.828579f, 
		-0.0186548f, -0.887542f, 0.460350f, 0.0844775f, -0.994983f, 0.0535895f, 
		-0.992516f, -0.0486929f, 0.111987f, -0.439501f, 0.158528f, 0.884143f, 
		-0.409030f, 0.910421f, 0.0618680f, -0.802193f, -0.354270f, 0.480603f, 
		-0.0136000f, -0.952426f, -0.304466f, -0.990028f, 0.120407f, 0.0731247f, 
		-0.907690f, 0.0800843f, 0.411929f, -0.988198f, -0.143342f, -0.0540214f, 
		-0.983055f, 0.0727325f, 0.168263f, -0.953979f, 0.168489f, 0.248062f, 
		-0.956872f, 0.247787f, 0.151648f, -0.986166f, 0.160242f, 0.0424151f, 
		0.656019f, -0.640496f, -0.399254f, -0.350929f, -0.933647f, -0.0717793f, 
		0.00539429f, 0.776606f, 0.629963f, -0.329211f, 0.391410f, 0.859313f, 
		0.793553f, -0.515339f, -0.323574f, 0.974131f, 0.0362901f, -0.223050f, 
		0.654538f, -0.675947f, -0.338638f, 0.957975f, 0.237067f, -0.161500f, 
		-0.859082f, 0.508132f, 0.0614859f, -0.180299f, 0.975257f, 0.127927f, 
		-0.726735f, 0.337526f, 0.598275f, -0.0369921f, 0.135570f, 0.990077f, 
		0.0913451f, 0.0662789f, -0.993611f, -0.404390f, 0.914230f, 0.0255240f, 
		0.00186155f, -0.0568979f, -0.998378f, -0.00744893f, 0.857642f, 0.514193f, 
		-0.456721f, 0.441801f, 0.772151f, -0.00377274f, -0.833437f, -0.552601f, 
		-0.318693f, 0.547531f, 0.773721f, -0.360321f, 0.851986f, 0.379854f, 
		-0.327208f, 0.937033f, 0.122086f, -0.304904f, 0.413823f, 0.857779f, 
		0.00169899f, -0.732976f, -0.680253f, -0.993357f, 0.0778779f, 0.0847210f, 
		-0.549117f, 0.442196f, 0.709178f, 0.00456674f, 0.0841669f, 0.996441f, 
		-0.883740f, -0.218429f, 0.413876f, -0.856966f, -0.124630f, 0.500076f, 
		-0.767608f, 0.123348f, 0.628939f, -0.781907f, 0.00734422f, 0.623352f, 
		-0.821763f, -0.0458380f, 0.567983f, -0.973735f, 0.0409446f, -0.223974f, 
		-0.623582f, 0.399826f, 0.671778f, 0.743724f, -0.343989f, -0.573190f, 
		0.0837877f, -0.167682f, -0.982274f, 0.667966f, 0.677892f, 0.307057f, 
		-0.903461f, -0.0840497f, 0.420350f, 0.0145523f, 0.0835022f, -0.996401f, 
		0.0284434f, 0.375243f, 0.926490f, 0.00863337f, -0.583574f, -0.812014f, 
		0.0230592f, 0.885976f, -0.463157f, -0.891424f, -0.165622f, 0.421820f, 
		-0.975304f, 0.186109f, -0.118938f, -0.672551f, -0.00626276f, -0.740024f, 
		-0.887614f, -0.163805f, 0.430475f, -0.618951f, 0.266926f, 0.738682f, 
		0.930900f, 0.351084f, -0.100824f, 0.797360f, 0.560867f, 0.222813f, 
		-0.857027f, -0.00160908f, 0.515269f, -0.401590f, -0.0478340f, 0.914569f, 
		0.0143305f, 0.672182f, 0.740247f, -0.809000f, -0.318326f, 0.494153f, 
		-0.877657f, 0.472993f, -0.0774353f, -0.180261f, 0.975262f, 0.127946f, 
		0.964654f, 0.102211f, -0.242891f, -0.987535f, -0.0753562f, 0.138188f, 
		-0.994677f, -0.0396056f, -0.0951235f, -0.974210f, -0.0832386f, 0.209727f, 
		-0.936117f, -0.00311082f, -0.351674f, -0.819896f, 0.0311176f, -0.571666f, 
		-0.661434f, 0.204529f, -0.721577f, 0.0262917f, 0.223450f, 0.974361f, 
		0.909479f, 0.408851f, -0.0754303f, 0.812366f, 0.563639f, 0.149572f, 
		0.0379441f, -0.339356f, 0.939892f, -0.606990f, 0.170353f, 0.776236f, 
		0.558424f, -0.697328f, -0.449329f, 0.972047f, 0.0989852f, -0.212902f, 
		-0.396539f, -0.903091f, -0.164871f, -0.917966f, 0.394253f, -0.0436248f, 
		0.0178517f, -0.0891525f, 0.995858f, 0.0459740f, 0.989763f, 0.135114f, 
		-0.956252f, 0.135784f, 0.259123f, 0.0729150f, 0.488722f, -0.869387f, 
		-0.195478f, -0.918038f, -0.344957f, -0.500969f, -0.00142985f, -0.865464f, 
		-0.502629f, 0.110398f, -0.857424f, 0.359755f, -0.895565f, 0.261801f, 
		0.465404f, -0.821614f, 0.329165f, 0.458188f, -0.857406f, 0.234349f, 
		0.443710f, -0.885002f, 0.141039f, 0.543776f, -0.815775f, 0.197023f, 
		-0.413824f, 0.836731f, -0.358652f, -0.704735f, 0.133326f, 0.696831f, 
		0.0690485f, -0.981713f, 0.177406f, 0.0500315f, -0.436605f, -0.898261f, 
		-0.926803f, 0.219533f, 0.304698f, -0.930520f, 0.116765f, 0.347129f, 
		-0.893408f, 0.314397f, 0.320900f, -0.897205f, 0.369857f, 0.241309f, 
		-0.771562f, 0.607917f, 0.187425f, 0.0646266f, -0.933050f, 0.353894f, 
		-0.841704f, 0.489086f, 0.228756f, -0.180310f, 0.975256f, 0.127921f, 
		-0.998083f, -0.0243174f, -0.0569051f, -0.586292f, 0.0491475f, -0.808608f, 
		-0.811139f, -0.561233f, 0.164533f, -0.827064f, -0.470326f, 0.307829f, 
		-0.829875f, -0.513365f, 0.218548f, -0.223494f, 0.940676f, 0.255301f, 
		-0.226113f, -0.554057f, 0.801183f, 0.0541371f, 0.324629f, -0.944291f, 
		-0.981249f, 0.0291189f, -0.190531f, -0.276474f, -0.0543957f, -0.959481f, 
		-0.244272f, -0.963538f, -0.109203f, -0.868029f, -0.392107f, 0.304594f, 
		-0.387745f, -0.876951f, -0.283921f, -0.422247f, -0.787373f, -0.449166f, 
		-0.442362f, -0.715251f, -0.541047f, -0.667918f, -0.164634f, -0.725797f, 
		0.0737425f, 0.944654f, 0.319672f, 0.0633910f, -0.907496f, -0.415250f, 
		-0.933745f, 0.0236875f, 0.357155f, -0.907918f, -0.116573f, 0.402612f, 
		-0.958234f, -0.145097f, 0.246443f, -0.935443f, -0.141882f, 0.323753f, 
		0.0661771f, 0.967492f, -0.244088f, -0.986927f, 0.108465f, 0.119210f, 
		0.0668693f, 0.521268f, 0.850769f, 0.0728890f, 0.666777f, -0.741685f, 
		-0.949869f, 0.187367f, -0.250284f, -0.842639f, 0.0349443f, -0.537344f, 
		-0.497331f, 0.850680f, -0.170309f, -0.779196f, 0.624148f, -0.0573931f, 
		-0.938854f, 0.344269f, 0.00570902f, -0.688158f, -0.683614f, 0.243125f, 
		-0.0760981f, -0.972047f, 0.222113f, -0.736141f, -0.621646f, 0.267680f, 
		-0.851763f, -0.222301f, 0.474428f, -0.813204f, -0.0403755f, 0.580577f, 
		-0.315622f, -0.933914f, 0.167892f, -0.911473f, -0.0812593f, 0.403254f, 
		0.152544f, 0.161946f, -0.974938f, -0.602870f, -0.783230f, 0.151981f, 
		-0.291883f, -0.956453f, -0.00127690f, -0.876857f, -0.466533f, -0.116054f, 
		-0.883495f, -0.417579f, -0.212284f, -0.919480f, -0.306707f, -0.245941f, 
		-0.931990f, -0.158887f, -0.325807f, -0.641489f, -0.766201f, -0.0377855f, 
		-0.674984f, -0.622921f, 0.395431f, 0.853409f, -0.0639976f, -0.517299f, 
		0.141586f, -0.974958f, -0.171494f, -0.742719f, -0.581392f, 0.332193f, 
		0.0925731f, -0.995573f, -0.0162851f, -0.586140f, -0.531274f, 0.611709f, 
		-0.680831f, -0.525152f, 0.510573f, -0.646862f, -0.519899f, 0.557920f, 
		-0.989881f, 0.00788210f, -0.141680f, 0.768663f, -0.199742f, 0.607669f, 
		0.0808151f, 0.996344f, -0.0277091f, 0.0720090f, -0.0457149f, -0.996356f, 
		-0.989421f, -0.137117f, -0.0473767f, -0.0839717f, -0.394865f, 0.914894f, 
		-0.742659f, -0.404250f, -0.533891f, -0.987389f, -0.0564754f, 0.147899f, 
		0.0590227f, -0.699267f, 0.712420f, -0.808027f, -0.174494f, 0.562712f, 
		0.129841f, -0.792773f, 0.595527f, -0.992507f, 0.00804304f, -0.121924f, 
		-0.817323f, 0.0216203f, 0.575774f, -0.931801f, 0.0891686f, 0.351846f, 
		-0.867764f, 0.0611527f, 0.493199f, -0.821514f, 0.0844598f, -0.563899f, 
		-0.883422f, -0.0605250f, -0.464653f, -0.750223f, -0.00826887f, -0.661133f, 
		-0.857185f, -0.0530491f, -0.512270f, -0.885964f, -0.0460146f, 0.461466f, 
		-0.990482f, 0.0178324f, 0.136480f, -0.995959f, 0.0441773f, -0.0781935f, 
		-0.941007f, 0.00451776f, 0.338356f, -0.975762f, 0.0756865f, -0.205328f, 
		-0.480146f, -0.650005f, -0.589028f, 0.0961528f, -0.483374f, 0.870117f, 
		-0.700186f, -0.00250670f, -0.713956f, -0.858748f, -0.0435343f, -0.510545f, 
		-0.939280f, 0.0905759f, 0.330982f, 0.116971f, -0.190622f, -0.974670f, 
		-0.954713f, -0.0972910f, 0.281173f, -0.771398f, -0.0784830f, -0.631494f, 
		-0.930366f, -0.0263990f, -0.365681f, -0.999503f, 0.0237453f, 0.0207184f, 
		0.930971f, 0.355538f, -0.0829872f, 0.887778f, -0.0324274f, -0.459129f, 
		0.0751846f, -0.310904f, -0.947463f, 0.112762f, -0.971294f, -0.209460f, 
		-0.694452f, 0.203765f, -0.690084f, 0.106054f, 0.872598f, 0.476787f, 
		0.242655f, 0.773455f, 0.585565f, 0.552504f, 0.404081f, 0.729012f, 
		0.634499f, 0.224224f, 0.739686f, 0.923996f, 0.0100479f, -0.382269f, 
		-0.304471f, -0.943450f, -0.131144f, -0.815875f, 0.0565187f, -0.575460f, 
		-0.995827f, -0.0697530f, -0.0588399f, -0.585197f, 0.0154072f, -0.810745f, 
		0.129842f, 0.800944f, -0.584492f, -0.906014f, 0.330823f, 0.263997f, 
		-0.969975f, 0.239372f, 0.0430001f, -0.772641f, 0.561700f, 0.295837f, 
		0.121926f, -0.579340f, 0.805915f, -0.950898f, 0.258060f, -0.170873f, 
		0.276632f, 0.351468f, -0.894396f, -0.531925f, -0.671655f, -0.515688f, 
		-0.685789f, -0.157042f, -0.710656f, -0.920046f, 0.365414f, -0.141378f, 
		0.171063f, 0.668846f, -0.723452f, -0.180253f, 0.975262f, 0.127956f, 
		-0.971883f, 0.120478f, 0.202307f, 0.130273f, 0.0530874f, 0.990056f, 
		0.889443f, 0.454781f, -0.0454540f, -0.509356f, -0.244635f, 0.825051f, 
		0.144665f, 0.902053f, -0.406661f, 0.0548173f, -0.116599f, -0.991665f, 
		-0.957069f, 0.289788f, 0.00644847f, -0.452432f, 0.891390f, -0.0270120f, 
		-0.876880f, -0.150575f, 0.456519f, 0.130795f, 0.173514f, -0.976107f, 
		-0.449914f, 0.527772f, 0.720441f, -0.676991f, 0.621442f, 0.394325f, 
		-0.885508f, 0.394067f, 0.246145f, -0.818013f, 0.537244f, 0.205482f, 
		-0.555218f, 0.818039f, 0.150151f, -0.689635f, 0.714066f, 0.120474f, 
		-0.956454f, -0.291689f, -0.0106232f, -0.465386f, 0.885047f, 0.0103260f, 
		0.157514f, -0.615188f, -0.772485f, -0.869711f, -0.219736f, 0.441949f, 
		-0.831397f, -0.207700f, -0.515402f, -0.777641f, -0.544055f, -0.315086f, 
		-0.860057f, -0.382860f, 0.337224f, -0.731018f, -0.646647f, -0.217854f, 
		-0.841190f, -0.536792f, 0.0652218f, -0.952235f, 0.290132f, -0.0952461f, 
		-0.599696f, 0.0685038f, -0.797290f, 0.161568f, 0.236456f, 0.958115f, 
		-0.614594f, 0.373793f, -0.694660f, 0.526716f, 0.789649f, 0.314681f, 
		-0.826133f, -0.0997737f, 0.554571f, -0.956326f, -0.103085f, 0.273523f, 
		-0.752521f, 0.469701f, 0.461621f, -0.862101f, 0.417653f, 0.286965f, 
		-0.807664f, 0.423696f, 0.410074f, 0.138527f, 0.772087f, 0.620236f, 
		0.163504f, -0.495986f, -0.852798f, 0.147932f, -0.813861f, -0.561913f, 
		0.745822f, -0.341299f, -0.572071f, 0.894490f, -0.277994f, 0.350152f, 
		-0.944867f, 0.296476f, 0.139028f, -0.884728f, 0.356864f, 0.299840f, 
		-0.917373f, 0.320629f, 0.235846f, -0.925956f, -0.377467f, 0.0111750f, 
		0.183784f, -0.974615f, -0.127861f, 0.680413f, 0.0932183f, 0.726876f, 
		-0.886729f, -0.248376f, 0.389898f, -0.865574f, 0.119338f, 0.486354f, 
		-0.647569f, -0.271590f, -0.711964f, -0.927529f, 0.187113f, 0.323540f, 
		-0.438988f, -0.668140f, -0.600732f, -0.269637f, 0.961530f, 0.0525028f, 
		0.192083f, -0.971140f, 0.141387f, 0.703347f, 0.00845378f, 0.710796f, 
		-0.813185f, 0.0167677f, -0.581763f, -0.864501f, 0.147055f, 0.480638f, 
		-0.945800f, 0.202145f, 0.254165f, -0.775634f, 0.476077f, 0.414420f, 
		-0.180339f, 0.975249f, 0.127936f, 0.179999f, -0.871420f, 0.456319f, 
		-0.996052f, -0.0634076f, -0.0621309f, -0.582787f, 0.0133630f, -0.812515f, 
		0.148055f, 0.0878790f, -0.985067f, 0.171449f, -0.159635f, 0.972174f, 
		-0.949535f, -0.258140f, -0.178176f, -0.925082f, 0.169375f, 0.339904f, 
		-0.982165f, -0.170101f, 0.0801153f, -0.933750f, 0.0242156f, -0.357107f, 
		-0.313555f, 0.258130f, 0.913812f, -0.897108f, 0.302870f, -0.321662f, 
		-0.926323f, 0.181071f, -0.330363f, 0.186672f, 0.613698f, 0.767156f, 
		-0.393798f, -0.156923f, 0.905703f, -0.882363f, 0.145594f, 0.447479f, 
		0.174154f, 0.975368f, 0.135378f, 0.155882f, 0.0537942f, -0.986310f, 
		-0.955573f, 0.294754f, 0.000163191f, -0.793109f, -0.603594f, 0.0815612f, 
		-0.994798f, -0.100858f, 0.0143336f, -0.997985f, 0.0125340f, 0.0622074f, 
		-0.176220f, 0.976068f, 0.127429f, -0.834531f, -0.533117f, 0.139085f, 
		-0.992177f, -0.0584296f, 0.110318f, -0.997595f, 0.0145601f, 0.0677596f, 
		-0.990527f, 0.119901f, 0.0669286f, -0.918101f, -0.387206f, 0.0846294f, 
		-0.421079f, 0.842073f, -0.337055f, 0.179080f, -0.0132381f, -0.983746f, 
		-0.957622f, -0.145783f, 0.248410f, -0.908320f, -0.219005f, 0.356359f, 
		-0.932183f, -0.178604f, 0.314857f, -0.857194f, 0.432383f, 0.279757f, 
		-0.949942f, 0.145984f, 0.276221f, -0.996007f, -0.0889949f, -0.00703315f, 
		-0.652068f, -0.0574325f, -0.755982f, -0.372765f, 0.221499f, 0.901102f, 
		-0.370252f, 0.364249f, 0.854539f, 0.845690f, 0.384872f, -0.369704f, 
		0.835979f, 0.510183f, -0.202119f, 0.417756f, 0.854905f, 0.307600f, 
		0.591846f, 0.779641f, 0.204642f, 0.196313f, 0.409869f, 0.890768f, 
		-0.921484f, -0.351809f, -0.164612f, 0.180649f, -0.975499f, -0.125567f, 
		0.284706f, 0.0151015f, 0.958496f, 0.211640f, -0.366308f, 0.906106f, 
		-0.922092f, -0.318853f, 0.219272f, -0.816120f, -0.00550107f, -0.577857f, 
		0.199826f, 0.694035f, -0.691653f, -0.133721f, -0.970829f, -0.199021f, 
		-0.928421f, -0.112692f, 0.354027f, 0.205333f, 0.578093f, -0.789713f, 
		-0.959202f, -0.0898376f, 0.268069f, 0.872765f, 0.397403f, -0.283465f, 
		-0.840462f, -0.374043f, 0.392065f, 0.208661f, 0.860865f, 0.464081f, 
		-0.637331f, 0.392937f, -0.662880f, 0.285280f, -0.953492f, 0.0973015f, 
		0.120236f, -0.988163f, 0.0952709f, 0.204491f, -0.975415f, 0.0821479f, 
		0.227130f, -0.931049f, 0.285587f, -0.316697f, 0.759133f, 0.568700f, 
		-0.985917f, -0.0715675f, -0.151149f, -0.992876f, 0.0342191f, -0.114133f, 
		-0.179737f, 0.975145f, 0.129562f, -0.881837f, -0.401717f, 0.246955f, 
		0.186591f, -0.973856f, -0.129572f, 0.230419f, -0.661068f, 0.714070f, 
		-0.210090f, -0.968383f, 0.134525f, -0.926887f, -0.186713f, -0.325606f, 
		-0.326802f, -0.00144305f, 0.945092f, 0.230648f, -0.891018f, -0.391010f, 
		-0.348319f, -0.0195556f, 0.937172f, -0.647515f, -0.255904f, 0.717801f, 
		0.220682f, 0.973959f, -0.0519873f, -0.884788f, 0.334702f, 0.324231f, 
		-0.652988f, -0.271585f, -0.706999f, -0.964443f, 0.249390f, 0.0874850f, 
		-0.946735f, 0.166124f, 0.275853f, -0.926277f, 0.136165f, 0.351384f, 
		-0.822453f, -0.0372063f, -0.567615f, -0.995488f, -0.0568309f, -0.0759839f, 
		-0.581378f, 0.0334449f, -0.812946f, -0.788171f, -0.256706f, 0.559365f, 
		-0.832586f, -0.327688f, 0.446566f, -0.657478f, -0.180950f, 0.731423f, 
		0.118249f, -0.0893984f, -0.988952f, -0.960009f, -0.137587f, 0.243829f, 
		-0.723122f, -0.687306f, -0.0685934f, -0.954417f, -0.00875078f, 0.298348f, 
		-0.172627f, 0.976992f, 0.125247f, -0.961157f, -0.0246261f, 0.274900f, 
		-0.415125f, -0.898331f, 0.143781f, -0.819447f, -0.0777329f, -0.567859f, 
		0.621473f, 0.778438f, 0.0883466f, -0.180325f, 0.975251f, 0.127935f, 
		-0.753731f, 0.191900f, 0.628541f, -0.503661f, -0.0350668f, 0.863190f, 
		0.0893772f, 0.307555f, 0.947324f, -0.187175f, 0.00781592f, 0.982296f, 
		-0.452427f, 0.762444f, 0.462590f, -0.733642f, 0.479785f, 0.481223f, 
		-0.160345f, 0.803343f, 0.573524f, 0.0993448f, 0.595394f, 0.797268f, 
		-0.877303f, 0.215241f, 0.428965f, -0.848098f, 0.150967f, 0.507876f, 
		-0.988557f, 0.130213f, -0.0761581f, -0.590534f, 0.0857557f, -0.802444f, 
		-0.707952f, 0.0444727f, 0.704859f, 0.247287f, -0.678410f, -0.691816f, 
		0.258493f, -0.943924f, -0.205400f, 0.243436f, 0.940441f, -0.237297f, 
		0.248026f, 0.442932f, -0.861565f, 0.254642f, -0.960714f, 0.110388f, 
		0.862125f, 0.503445f, 0.0572981f, -0.880728f, 0.0753574f, 0.467589f, 
		0.264888f, 0.0600428f, 0.962408f, -0.944407f, 0.120198f, 0.306018f, 
		-0.721847f, -0.0438926f, 0.690659f, 0.244138f, 0.311187f, -0.918455f, 
		-0.997042f, -0.00344207f, -0.0767768f, -0.582124f, 0.0971738f, -0.807273f, 
		0.272225f, 0.918211f, 0.287718f, -0.370130f, -0.715667f, -0.592304f, 
		-0.343050f, -0.271252f, 0.899299f, 0.260151f, 0.868661f, -0.421603f, 
		0.276155f, -0.783771f, -0.556274f, -0.0547111f, 0.134872f, 0.989351f, 
		-0.734829f, 0.321801f, 0.597051f, 0.254862f, -0.333084f, -0.907800f, 
		-0.801496f, -0.0938341f, -0.590592f, -0.802350f, -0.127865f, 0.582997f, 
		-0.891030f, -0.386039f, -0.238827f, -0.111067f, -0.243684f, 0.963474f, 
		-0.807411f, -0.000169287f, 0.589990f, -0.886004f, 0.227672f, 0.403933f, 
		-0.225717f, -0.555120f, 0.800559f, -0.946831f, -0.207409f, -0.245953f, 
		0.333702f, 0.0775664f, -0.939482f, 0.281300f, 0.766230f, -0.577721f, 
		0.818023f, 0.575147f, -0.00658896f, 0.255184f, -0.965433f, -0.0531066f, 
		-0.0377721f, -0.999240f, -0.00958153f, -0.710451f, -0.405559f, 0.575136f, 
		0.274100f, 0.135991f, -0.952038f, 0.852948f, 0.518745f, -0.0581666f, 
		0.878992f, 0.376658f, -0.292406f, 0.906420f, 0.210819f, -0.366004f, 
		-0.180717f, 0.975167f, 0.128028f, 0.285887f, -0.168887f, -0.943263f, 
		-0.914963f, -0.315490f, -0.251612f, 0.341877f, 0.0314354f, -0.939219f, 
		0.181142f, -0.975779f, -0.122653f, -0.318184f, -0.207426f, 0.925059f, 
		-0.343946f, -0.0598967f, 0.937077f, -0.0578039f, -0.874622f, 0.481347f, 
		0.279868f, -0.510784f, 0.812880f, 0.654612f, -0.120622f, -0.746280f, 
		0.0659562f, -0.983209f, -0.170148f, -0.793573f, -0.119385f, 0.596649f, 
		0.644932f, 0.734447f, 0.211307f, -0.180310f, 0.975256f, 0.127921f, 
		0.158530f, 0.130782f, -0.978654f, 0.294875f, 0.713193f, 0.635928f, 
		-0.717687f, 0.582017f, 0.382336f, 0.126528f, 0.699885f, 0.702959f, 
		-0.799785f, -0.104061f, 0.591199f, -0.757472f, -0.218819f, 0.615105f, 
		-0.698658f, -0.365787f, 0.614880f, -0.815421f, 0.0876040f, 0.572202f, 
		-0.893994f, 0.206595f, 0.397609f, 0.334691f, 0.352715f, 0.873827f, 
		0.322011f, -0.244514f, 0.914616f, -0.560220f, -0.402773f, -0.723829f, 
		-0.977999f, 0.0252746f, -0.207073f, 0.287446f, 0.325762f, -0.900696f, 
		-0.179252f, 0.974842f, 0.132486f, 0.321239f, -0.0907256f, 0.942642f, 
		0.884457f, 0.415527f, 0.212306f, 0.621020f, -0.330221f, -0.710836f, 
		0.457488f, -0.292362f, -0.839779f, 0.0987076f, -0.190063f, -0.976797f, 
		-0.970764f, -0.0896460f, -0.222668f, 0.295582f, 0.283399f, -0.912313f, 
		-0.824157f, -0.333962f, 0.457421f, -0.738514f, 0.0864118f, -0.668678f, 
		-0.506294f, -0.137282f, 0.851364f, -0.674275f, -0.142331f, 0.724634f, 
		-0.133435f, -0.130889f, 0.982376f, -0.556921f, -0.599883f, 0.574438f, 
		-0.506221f, -0.772863f, 0.382653f, -0.385863f, -0.857841f, 0.339439f, 
		0.310070f, 0.236919f, 0.920720f, -0.295813f, 0.948745f, 0.111255f, 
		0.340575f, 0.631082f, -0.696954f, 0.591693f, 0.765476f, 0.252875f, 
		0.687347f, -0.116167f, -0.716979f, -0.375771f, -0.750186f, -0.544074f, 
		-0.776831f, -0.412576f, 0.475726f, 0.199714f, -0.970727f, -0.133429f, 
		0.313887f, -0.806591f, 0.500884f, -0.835411f, -0.537674f, -0.113994f, 
		-0.263063f, -0.0646214f, -0.962612f, 0.109452f, -0.187845f, -0.976081f, 
		-0.449645f, 0.00120923f, -0.893207f, -0.934076f, -0.103387f, 0.341779f, 
		0.720687f, -0.104074f, -0.685404f, -0.113415f, -0.992489f, -0.0458504f, 
		-0.830433f, -0.484964f, -0.274211f, 0.354121f, -0.00228126f, -0.935197f, 
		-0.995520f, -0.0942797f, -0.00722974f, -0.639521f, -0.0363081f, -0.767916f, 
		-0.511571f, -0.166902f, 0.842875f, -0.143728f, -0.175702f, 0.973895f, 
		-0.675729f, -0.150660f, 0.721590f, -0.147967f, 0.698454f, 0.700191f, 
		-0.635669f, 0.757154f, -0.150474f, -0.489423f, 0.869518f, 0.0663596f, 
		-0.231772f, 0.784303f, 0.575456f, -0.575307f, -0.781015f, -0.242977f, 
		0.236758f, -0.920756f, -0.310087f, 0.348572f, 0.516195f, 0.782330f, 
		0.146716f, 0.639875f, 0.754344f, -0.747814f, 0.514899f, 0.419109f, 
		-0.849548f, -0.0192397f, 0.527160f, -0.165931f, 0.978540f, 0.122178f, 
		-0.860842f, -0.162582f, 0.482202f, -0.527856f, 0.0438632f, -0.848201f, 
		0.353394f, 0.929524f, 0.105347f, 0.347689f, -0.727627f, 0.591330f, 
		-0.569187f, -0.745747f, -0.346250f, 0.243308f, -0.904943f, -0.349114f, 
		0.331138f, -0.506880f, -0.795877f, -0.555623f, 0.319408f, 0.767634f, 
		-0.727141f, -0.0758101f, 0.682289f, -0.639585f, 0.0480411f, 0.767217f, 
		-0.694989f, 0.200738f, 0.690431f, 0.365911f, 0.491109f, -0.790520f, 
		-0.331540f, -0.141056f, 0.932837f, -0.635813f, 0.479039f, 0.605197f, 
		-0.180587f, 0.975161f, 0.128255f, -0.496181f, -0.860051f, -0.118816f, 
		-0.570714f, -0.819850f, 0.0461607f, -0.749513f, -0.536744f, 0.387474f, 
		-0.801332f, -0.345082f, 0.488657f, -0.393553f, 0.0486265f, -0.918015f, 
		0.160595f, 0.00295961f, -0.987016f, -0.0932369f, 0.0191809f, -0.995459f, 
		-0.561463f, -0.407012f, -0.720487f, 0.356718f, -0.384145f, 0.851578f, 
		-0.136211f, -0.173530f, 0.975363f, -0.803084f, -0.114941f, 0.584674f, 
		-0.777095f, -0.189633f, 0.600135f, 0.371779f, 0.796234f, 0.477275f, 
		0.149856f, 0.562729f, 0.812945f, -0.767206f, 0.438403f, 0.468186f, 
		0.370603f, 0.923382f, -0.100100f, 0.767381f, -0.207543f, 0.606673f, 
		0.373713f, -0.781781f, -0.499156f, 0.999541f, -0.00976013f, 0.0286941f, 
		0.191714f, -0.973105f, -0.127724f, 0.994834f, 0.0963641f, 0.0319105f, 
		-0.0952710f, 0.0135875f, 0.995359f, -0.770134f, 0.207430f, 0.603213f, 
		0.396941f, -0.902768f, -0.165676f, 0.210081f, 0.0519447f, -0.976303f, 
		-0.583005f, 0.0106414f, -0.812399f, -0.524964f, 0.0978640f, -0.845479f, 
		-0.370683f, -0.816669f, -0.442319f, -0.120621f, -0.119775f, 0.985446f, 
		-0.802135f, -0.0423100f, 0.595643f, -0.355137f, 0.0288810f, 0.934368f, 
		-0.804971f, 0.194791f, 0.560427f, 0.389745f, -0.850598f, -0.352962f, 
		-0.766291f, 0.566707f, 0.302723f, 0.214093f, 0.947129f, 0.238981f, 
		-0.658611f, -0.0509170f, 0.750759f, 0.380839f, 0.808949f, -0.447842f, 
		0.380809f, 0.878289f, -0.289125f, 0.375129f, -0.862657f, 0.339265f, 
		0.397770f, -0.127889f, 0.908528f, 0.105037f, 0.465539f, 0.878772f, 
		-0.754699f, 0.348998f, 0.555545f, 0.398391f, -0.677514f, -0.618272f, 
		-0.823010f, -0.463495f, -0.328370f, 0.315078f, 0.179158f, -0.932002f, 
		0.250343f, -0.901873f, -0.352071f, -0.367932f, 0.190516f, 0.910126f, 
		0.961605f, 0.258552f, 0.0920173f, -0.170775f, 0.977133f, 0.126677f, 
		-0.280134f, 0.309387f, 0.908738f, -0.458465f, 0.285217f, 0.841701f, 
		0.0223377f, 0.335090f, 0.941921f, -0.705174f, 0.236418f, 0.668458f, 
		-0.710052f, -0.256434f, 0.655795f, -0.526431f, 0.0500747f, -0.848742f, 
		0.429896f, -0.345321f, -0.834232f, -0.508544f, -0.0293292f, -0.860536f, 
		-0.659618f, -0.745769f, 0.0934500f, -0.832684f, -0.534175f, 0.145927f, 
		-0.902043f, -0.416739f, 0.112458f, -0.761280f, -0.646991f, 0.0430725f, 
		-0.107180f, 0.947744f, 0.300488f, -0.180531f, -0.548045f, 0.816735f, 
		0.405684f, -0.913886f, 0.0152389f, -0.866627f, 0.223025f, 0.446338f, 
		-0.168416f, 0.879776f, 0.444556f, 0.203311f, 0.0496718f, -0.977854f, 
		-0.584567f, 0.0171160f, -0.811165f, 0.400233f, 0.0420809f, 0.915447f, 
		-0.552114f, -0.831410f, -0.0626674f, 0.235269f, -0.927215f, -0.291411f, 
		0.619479f, 0.214797f, -0.755055f, -0.180910f, 0.975051f, 0.128639f, 
		0.965471f, 0.153094f, -0.210781f, 0.218094f, -0.965462f, -0.142543f, 
		0.428362f, -0.595163f, 0.679917f, 0.408052f, 0.352849f, -0.842016f, 
		-0.401577f, 0.0802818f, -0.912300f, -0.236598f, 0.227127f, -0.944688f, 
		-0.0325126f, 0.670853f, -0.740877f, -0.0527205f, 0.819699f, -0.570364f, 
		-0.302711f, 0.187377f, 0.934482f, -0.996369f, -0.0847419f, -0.00823832f, 
		-0.622299f, -0.0295924f, -0.782220f, 0.404526f, -0.896173f, 0.182296f, 
		0.407783f, 0.181227f, -0.894913f, -0.936943f, -0.110233f, 0.331642f, 
		0.931083f, 0.292995f, -0.217343f, -0.158015f, 0.980450f, 0.117260f, 
		0.985869f, -0.0145143f, 0.166889f, 0.181030f, -0.975252f, -0.126934f, 
		0.987205f, 0.0405224f, 0.154219f, 0.429703f, -0.570219f, -0.700146f, 
		-0.754447f, -0.290506f, 0.588571f, 0.435493f, 0.848170f, 0.301586f, 
		-0.286038f, -0.0269039f, 0.957840f, 0.442056f, 0.616690f, 0.651367f, 
		0.195795f, 0.0643878f, -0.978529f, -0.582544f, 0.0208260f, -0.812532f, 
		0.608559f, 0.408303f, -0.680400f, 0.0769136f, 0.976721f, 0.200249f, 
		0.925072f, 0.318974f, 0.206148f, -0.179363f, 0.975371f, 0.128373f, 
		-0.308563f, 0.349418f, 0.884701f, 0.439728f, -0.458642f, 0.772197f, 
		0.452171f, 0.369923f, 0.811603f, -0.525058f, -0.00818172f, -0.851027f, 
		0.742557f, -0.357663f, -0.566292f, 0.896809f, -0.282946f, 0.340111f, 
		-0.00494878f, -0.932386f, 0.361432f, 0.157895f, -0.0649884f, -0.985315f, 
		-0.584689f, 0.105094f, -0.804422f, 0.453274f, 0.712230f, -0.535976f, 
		-0.269255f, 0.922742f, -0.275772f, 0.451014f, -0.166505f, -0.876848f, 
		0.200486f, 0.108272f, -0.973695f, -0.581824f, 0.0715829f, -0.810158f, 
		0.944265f, 0.270007f, 0.188308f, 0.651559f, 0.715933f, 0.250819f, 
		0.162698f, 0.689895f, -0.705389f, -0.180277f, 0.975261f, 0.127934f, 
		0.451195f, 0.548316f, 0.704111f, 0.249537f, 0.965113f, 0.0793004f, 
		-0.109105f, -0.306143f, 0.945713f, -0.654019f, 0.0181249f, -0.756261f, 
		-0.104561f, -0.185510f, 0.977063f, -0.686634f, -0.433713f, 0.583462f, 
		0.654413f, 0.447773f, -0.609297f, 0.506524f, 0.847182f, 0.160364f, 
		0.476140f, 0.860400f, -0.181666f, 0.902372f, 0.354980f, 0.244365f, 
		0.225447f, 0.525699f, -0.820253f, 0.477828f, -0.274696f, 0.834400f, 
		-0.520905f, -0.0361343f, -0.852850f, 0.486380f, 0.802149f, -0.346397f, 
		0.475104f, 0.201147f, 0.856631f, 0.00447698f, 0.0309492f, -0.999511f, 
		-0.290866f, 0.0137150f, -0.956665f, -0.386872f, 0.0104265f, -0.922074f, 
		0.473238f, -0.770081f, 0.427809f, -0.268881f, -0.434628f, 0.859535f, 
		-0.752354f, -0.236620f, 0.614796f, -0.686464f, -0.323709f, 0.651137f, 
		-0.603557f, -0.323715f, 0.728648f, -0.566381f, -0.361570f, 0.740594f, 
		-0.380764f, -0.674823f, -0.632166f, -0.252798f, 0.684928f, 0.683349f, 
		0.503733f, 0.580026f, -0.640175f, 0.687527f, 0.179401f, 0.703649f, 
		0.509320f, 0.490734f, -0.706946f, 0.496174f, 0.868223f, 0.000463604f, 
		-0.521880f, -0.0806246f, -0.849200f, 0.497667f, -0.0408580f, 0.866405f, 
		-0.608295f, -0.333097f, 0.720433f, 0.0109320f, -0.147785f, 0.988959f, 
		-0.744545f, -0.136323f, 0.653505f, -0.945453f, -0.107162f, 0.307628f, 
		0.505099f, 0.0286424f, -0.862586f, 0.0645073f, -0.158301f, 0.985281f, 
		0.976904f, 0.0543600f, 0.206648f, -0.591039f, -0.411470f, 0.693805f, 
		0.206981f, -0.966661f, -0.150746f, 0.520896f, 0.699865f, 0.488730f, 
		-0.685474f, -0.384235f, 0.618457f, 0.518056f, -0.677267f, 0.522424f, 
		0.617198f, -0.296673f, 0.728733f, -0.995533f, -0.0883662f, -0.0332589f, 
		-0.607882f, -0.0293393f, -0.793485f, -0.676041f, -0.688070f, 0.263684f, 
		-0.813434f, -0.461465f, 0.354084f, -0.559864f, -0.776944f, 0.287942f, 
		-0.731422f, -0.570975f, 0.372841f, -0.592799f, -0.00456374f, 0.805338f, 
		-0.162021f, 0.981032f, 0.106417f, -0.845069f, 0.229460f, 0.482914f, 
		-0.636036f, -0.165682f, 0.753663f, -0.535551f, -0.140716f, -0.832697f, 
		0.410033f, 0.864362f, 0.291119f, 0.529125f, 0.365762f, -0.765666f, 
		-0.0677403f, -0.122634f, 0.990137f, -0.440159f, -0.122786f, 0.889485f, 
		-0.521200f, -0.113502f, 0.845854f, -0.481160f, -0.868714f, 0.117565f, 
		0.235105f, -0.927261f, -0.291399f, 0.940408f, 0.250703f, 0.229739f, 
		-0.0191601f, -0.997795f, -0.0635458f, 0.539285f, -0.839354f, 0.0682355f, 
		0.522246f, -0.440346f, -0.730311f, 0.523947f, -0.814806f, 0.248136f, 
		0.530209f, 0.447804f, 0.719965f, 0.409062f, 0.407887f, 0.816270f, 
		0.411561f, 0.303352f, 0.859416f, 0.352293f, 0.489959f, 0.797389f, 
		0.391926f, 0.552774f, 0.735415f, 0.274396f, 0.760078f, 0.589057f, 
		-0.221689f, -0.765364f, -0.604212f, -0.779450f, 0.252793f, 0.573196f, 
		0.707841f, 0.604059f, -0.366161f, 0.709580f, 0.475824f, -0.519700f, 
		0.331329f, 0.933281f, 0.138590f, 0.484291f, 0.874841f, 0.0107280f, 
		0.0855615f, 0.0655359f, 0.994175f, -0.510098f, -0.846589f, -0.151941f, 
		-0.452671f, -0.872119f, -0.185734f, -0.394909f, -0.880416f, -0.262516f, 
		0.541174f, -0.783091f, -0.306430f, 0.544732f, 0.201806f, -0.813966f, 
		0.549745f, -0.447006f, 0.705668f, 0.0302252f, -0.844189f, 0.535193f, 
		-0.0354471f, -0.949957f, 0.310364f, -0.0257106f, -0.911446f, 0.410615f, 
		0.544839f, -0.829087f, -0.125556f, -0.272742f, 0.924209f, -0.267301f, 
		-0.439067f, 0.587127f, -0.680075f, 0.538737f, -0.697673f, -0.472245f, 
		-0.404196f, -0.292277f, 0.866718f, 0.696747f, 0.173000f, -0.696142f, 
		0.222311f, -0.959464f, -0.173226f, -0.565865f, -0.165802f, -0.807655f, 
		0.0974130f, -0.00831932f, -0.995209f, -0.665958f, -0.0379485f, -0.745024f, 
		-0.944798f, -0.121206f, 0.304409f, 0.522838f, 0.670067f, 0.526926f, 
		0.553320f, -0.575132f, -0.602545f, -0.301628f, -0.810585f, -0.501969f, 
		0.712653f, 0.343060f, -0.611911f, -0.157207f, 0.982220f, 0.102620f, 
		-0.469178f, -0.572167f, -0.672679f, 0.591160f, -0.0969061f, 0.800712f, 
		-0.994048f, -0.0962322f, -0.0510654f, -0.609554f, -0.0171338f, -0.792559f, 
		-0.269948f, -0.151338f, 0.950907f, -0.372752f, -0.287220f, 0.882361f, 
		-0.310924f, -0.532779f, 0.787066f, -0.144935f, -0.716266f, 0.682611f, 
		-0.132111f, -0.508712f, 0.850740f, -0.667767f, -0.724909f, -0.169098f, 
		-0.958317f, 0.283394f, -0.0362802f, -0.716671f, -0.150513f, 0.680976f, 
		-0.717111f, -0.0245137f, 0.696527f, 0.588053f, 0.293774f, 0.753585f, 
		-0.966224f, 0.247229f, 0.0727262f, -0.701891f, -0.709192f, -0.0663018f, 
		0.149010f, -0.945754f, 0.288697f, 0.507999f, -0.448618f, 0.735309f, 
		0.360828f, -0.0557623f, 0.930964f, 0.219021f, 0.0997065f, 0.970613f, 
		0.349317f, -0.845299f, 0.404286f, 0.584106f, -0.563615f, 0.584088f, 
		0.596486f, 0.611084f, -0.520366f, -0.417634f, 0.885569f, -0.203348f, 
		-0.467962f, 0.873438f, -0.134604f, -0.654430f, 0.737201f, 0.168093f, 
		0.593506f, 0.723438f, -0.352687f, 0.602816f, 0.534551f, 0.592341f, 
		0.587780f, -0.730409f, 0.347874f, 0.582560f, 0.743870f, 0.327540f, 
		0.223336f, 0.704990f, 0.673135f, -0.640219f, 0.0221339f, -0.767873f, 
		-0.571067f, -0.0657564f, -0.818265f, -0.784369f, 0.234815f, -0.574132f, 
		-0.460884f, -0.119314f, 0.879403f, 0.885866f, -0.428633f, -0.177526f, 
		0.235431f, -0.927128f, -0.291557f, 0.317385f, 0.237785f, 0.918001f, 
		0.581452f, 0.796121f, -0.167646f, -0.435224f, 0.141489f, 0.889135f, 
		-0.294160f, 0.160615f, 0.942164f, -0.362444f, -0.0824200f, 0.928354f, 
		-0.319968f, -0.0766245f, 0.944325f, -0.349539f, 0.0772220f, 0.933734f, 
		0.979868f, -0.0216893f, 0.198467f, 0.341849f, 0.0215991f, -0.939507f, 
		0.179768f, -0.975815f, -0.124370f, -0.363290f, 0.500321f, 0.785939f, 
		-0.180244f, 0.975290f, 0.127758f, 0.309367f, 0.00135974f, -0.950942f, 
		-0.995213f, -0.0656676f, 0.0723788f, -0.253692f, 0.919393f, 0.300593f, 
		0.745787f, -0.351791f, -0.565725f, 0.535423f, -0.305897f, -0.787241f, 
		0.292153f, -0.237076f, -0.926521f, 0.627566f, -0.322261f, -0.708737f, 
		0.121516f, -0.175678f, -0.976919f, 0.401401f, -0.262358f, -0.877522f, 
		-0.449523f, 0.613370f, -0.649389f, 0.996614f, -0.0253636f, -0.0782090f, 
		0.874225f, -0.461176f, -0.151812f, 0.989769f, -0.115553f, -0.0836896f, 
		0.976449f, 0.0368973f, 0.212571f, 0.323678f, 0.129595f, -0.937250f, 
		0.0424403f, -0.995175f, 0.0884638f, 0.328622f, 0.603180f, 0.726761f, 
		0.917712f, 0.314671f, 0.242460f, 0.284023f, 0.334510f, -0.898573f, 
		-0.180632f, 0.974819f, 0.130767f, 0.260038f, 0.00426988f, 0.965589f, 
		0.590967f, -0.248087f, -0.767601f, -0.848033f, 0.148947f, -0.508582f, 
		-0.219863f, -0.969741f, -0.106122f, -0.868599f, -0.0473229f, -0.493251f, 
		-0.117279f, -0.989710f, 0.0819800f, -0.397132f, -0.682859f, -0.613180f, 
		-0.909439f, 0.261021f, 0.323711f, -0.682510f, -0.678002f, 0.272934f, 
		0.139958f, 0.0110998f, 0.990095f, 0.536284f, 0.256239f, 0.804202f, 
		0.0473804f, -0.131197f, 0.990223f, -0.698115f, -0.673777f, -0.242199f, 
		-0.951519f, 0.276966f, -0.133794f, -0.272167f, -0.0442673f, 0.961231f, 
		0.230408f, -0.0997931f, 0.967964f, 0.609135f, 0.116616f, 0.784446f, 
		0.249991f, 0.299872f, 0.920642f, -0.304958f, -0.141174f, 0.941844f, 
		-0.999056f, -0.0390768f, 0.0189643f, -0.271046f, 0.950287f, 0.153262f, 
		-0.260263f, -0.0305356f, 0.965055f, -0.584552f, -0.547170f, 0.599086f, 
		-0.332935f, -0.626519f, 0.704718f, -0.500611f, -0.560271f, 0.659913f, 
		0.350215f, 0.506144f, 0.788142f, -0.945643f, -0.106066f, 0.307425f, 
		-0.999328f, -0.0123462f, -0.0345180f, 0.0195398f, -0.808830f, 0.587718f, 
		-0.291077f, 0.00819931f, 0.956664f, -0.713618f, 0.0656031f, 0.697456f, 
		0.225471f, -0.170328f, 0.959245f, 0.935157f, 0.259079f, 0.241578f, 
		0.304572f, 0.234615f, -0.923142f, -0.714825f, -0.203772f, 0.668956f, 
		0.307269f, 0.375863f, 0.874250f, 0.638703f, -0.636628f, 0.432161f, 
		0.277258f, 0.0342084f, -0.960186f, -0.999056f, -0.0390768f, 0.0189643f, 
		0.0233679f, -0.810992f, 0.584590f, -0.801850f, 0.555105f, 0.221121f, 
		-0.665508f, 0.690570f, 0.283218f, -0.850002f, 0.481065f, 0.214648f, 
		-0.906433f, 0.381333f, 0.181563f, -0.746814f, 0.610890f, 0.262836f, 
		0.550533f, -0.796205f, -0.250941f, 0.860295f, -0.501318f, -0.0925865f, 
		0.475947f, -0.835293f, -0.275246f, 0.323703f, 0.185177f, -0.927861f, 
		-0.180458f, 0.975170f, 0.128367f, 0.221481f, -0.180833f, 0.958251f, 
		-0.149286f, 0.987951f, 0.0408233f, -0.994265f, -0.0933870f, -0.0521074f, 
		-0.610149f, -0.0125770f, -0.792187f, 0.963303f, 0.197047f, 0.182261f, 
		0.846551f, -0.522771f, -0.100309f, -0.275753f, 0.209068f, 0.938217f, 
		0.927638f, 0.141002f, -0.345840f, 0.233755f, -0.927693f, -0.291108f, 
		0.223762f, -0.129232f, 0.966038f, -0.629219f, 0.756058f, 0.180166f, 
		-0.472012f, 0.857494f, 0.204717f, -0.896572f, 0.438781f, 0.0602411f, 
		-0.962932f, 0.269744f, -0.000301961f, 0.640927f, -0.749504f, 0.165700f, 
		0.0919744f, 0.756083f, 0.647981f, 0.413326f, 0.498869f, 0.761768f, 
		0.567203f, 0.292991f, 0.769700f, -0.422501f, -0.690439f, -0.587186f, 
		-0.382118f, 0.295127f, -0.875720f, 0.175192f, -0.981390f, 0.0786205f, 
		-0.233559f, -0.395127f, 0.888440f, 0.639380f, 0.199952f, -0.742437f, 
		0.642735f, -0.00561124f, -0.766068f, -0.765843f, 0.427464f, 0.480374f, 
		-0.157420f, -0.544585f, 0.823800f, 0.640066f, 0.746664f, 0.181131f, 
		0.655438f, -0.255060f, 0.710877f, -0.764094f, 0.368532f, 0.529476f, 
		0.654382f, -0.403876f, -0.639271f, 0.664311f, 0.747119f, 0.0224303f, 
		-0.647034f, 0.727495f, -0.228248f, -0.511632f, 0.851255f, -0.116607f, 
		-0.837088f, 0.393997f, -0.379540f, 0.628900f, 0.470687f, -0.618821f, 
		0.401703f, -0.667724f, 0.626722f, 0.671728f, -0.418546f, 0.611229f, 
		-0.423041f, -0.123149f, 0.897703f, -0.565274f, -0.118914f, 0.816287f, 
		-0.492809f, -0.122005f, 0.861542f, 0.657923f, 0.589399f, 0.468772f, 
		0.653038f, 0.339186f, -0.677123f, 0.662329f, -0.720974f, -0.203754f, 
		-0.387324f, 0.0323203f, -0.921377f, -0.296084f, -0.909322f, -0.292348f, 
		-0.596764f, 0.000342400f, -0.802417f, -0.581914f, 0.135732f, -0.801844f, 
		-0.707962f, -0.593767f, -0.382401f, -0.926707f, 0.287629f, -0.241835f, 
		-0.343369f, -0.894359f, 0.286741f, -0.240606f, -0.947205f, 0.211925f, 
		-0.536584f, -0.578520f, 0.614322f, -0.387458f, -0.847551f, 0.362675f, 
		-0.520744f, -0.707760f, 0.477391f, 0.359072f, -0.176778f, -0.916415f, 
		0.234057f, -0.967101f, -0.0996626f, -0.428588f, -0.896126f, -0.115196f, 
		-0.448993f, 0.879521f, 0.157632f, -0.954720f, 0.273033f, -0.118163f, 
		-0.763950f, 0.255096f, 0.592711f, -0.126575f, -0.303950f, 0.944242f, 
		0.768519f, -0.208024f, 0.605066f, -0.0261075f, 0.920108f, 0.390793f, 
		-0.243318f, 0.967541f, 0.0682695f, -0.209267f, 0.956858f, 0.201570f, 
		-0.161172f, 0.984162f, 0.0738208f, -0.173049f, -0.850316f, -0.497008f, 
		-0.298573f, -0.353723f, 0.886417f, -0.449843f, -0.892627f, 0.0292943f, 
		0.685311f, 0.381436f, 0.620367f, -0.728494f, -0.293928f, 0.618792f, 
		-0.382118f, 0.295127f, -0.875720f, 0.681123f, -0.542305f, -0.491912f, 
		0.121432f, -0.00428109f, -0.992591f, -0.647045f, -0.0613746f, -0.759978f, 
		0.359458f, -0.177061f, -0.916209f, 0.686884f, -0.674035f, 0.271785f, 
		-0.359003f, -0.141588f, -0.922535f, 0.694138f, 0.521938f, -0.495736f, 
		0.360111f, -0.180556f, -0.915270f, 0.174848f, -0.981375f, 0.0795672f, 
		0.689758f, 0.647600f, 0.323803f, -0.706788f, 0.172825f, 0.685989f, 
		0.712585f, -0.0690448f, 0.698180f, 0.695263f, -0.641729f, -0.323718f, 
		-0.414833f, -0.898384f, -0.144289f, 0.691779f, -0.721758f, -0.0225237f, 
		0.697792f, 0.0605836f, 0.713734f, -0.523785f, -0.122457f, 0.843003f, 
		-0.387324f, 0.0323203f, -0.921377f, 0.693546f, 0.700508f, -0.168175f, 
		-0.640366f, -0.623560f, 0.448446f, -0.307606f, -0.789189f, 0.531563f, 
		-0.496340f, -0.591507f, 0.635426f, -0.494257f, -0.714310f, 0.495450f, 
		-0.637281f, -0.485990f, 0.598069f, 0.717987f, -0.518040f, 0.464897f, 
		-0.406842f, 0.912329f, 0.0462109f, -0.895846f, 0.299928f, -0.327878f, 
		-0.0316239f, -0.887921f, -0.458908f, -0.947902f, -0.0759976f, 0.309364f, 
		-0.334152f, -0.891468f, 0.305986f, 0.233644f, -0.928123f, -0.289825f, 
		-0.614124f, 0.743200f, 0.265529f, -0.775218f, 0.631294f, 0.0224979f, 
		-0.905370f, 0.372456f, -0.203916f, -0.928761f, 0.370568f, 0.00907275f, 
		-0.707049f, 0.617843f, 0.344023f, 0.721313f, 0.608895f, -0.330082f, 
		0.283699f, -0.392620f, 0.874851f, 0.151974f, -0.427791f, 0.891010f, 
		0.228203f, -0.398256f, 0.888435f, -0.359003f, -0.141588f, -0.922535f, 
		0.959905f, 0.174565f, 0.219341f, 0.314062f, 0.179630f, -0.932254f, 
		0.592796f, -0.767376f, -0.244390f, -0.364952f, -0.913655f, -0.179011f, 
		-0.996569f, -0.0656597f, -0.0503836f, -0.610598f, -0.00425924f, -0.791929f, 
		0.726076f, -0.187419f, -0.661580f, 0.566857f, 0.0608773f, 0.821564f, 
		0.513027f, 0.0173128f, 0.858198f, 0.478270f, -0.0310323f, 0.877664f, 
		0.167532f, 0.0186918f, -0.985689f, -0.635095f, -0.0253035f, -0.772020f, 
		0.426915f, -0.778989f, 0.459260f, -0.205798f, 0.360706f, 0.909691f, 
		0.792841f, -0.194950f, -0.577405f, 0.179449f, 0.0296105f, -0.983322f, 
		0.601050f, -0.0704506f, -0.796100f, 0.361624f, 0.0408501f, -0.931428f, 
		0.547220f, 0.0778398f, -0.833361f, 0.739487f, 0.364449f, -0.565982f, 
		-0.493339f, 0.745544f, 0.448085f, -0.528109f, -0.128435f, 0.839408f, 
		0.756045f, -0.640180f, 0.136256f, 0.740861f, 0.212595f, 0.637125f, 
		-0.299670f, -0.300465f, 0.905493f, 0.175297f, -0.977935f, -0.113638f, 
		0.549874f, 0.0451641f, -0.834025f, 0.897484f, -0.289852f, 0.332428f, 
		0.753120f, -0.335594f, -0.565851f, 0.746739f, 0.441485f, 0.497465f, 
		-0.345190f, -0.298285f, -0.889871f, 0.752092f, -0.640751f, -0.154257f, 
		0.334176f, 0.125280f, -0.934147f, -0.389460f, 0.872051f, 0.296391f, 
		-0.225769f, 0.970724f, 0.0819998f, -0.328970f, -0.0129349f, 0.944252f, 
		0.747606f, 0.168526f, -0.642405f, -0.997972f, -0.0636556f, 0.000503128f, 
		-0.669694f, 0.241132f, 0.702399f, -0.501453f, -0.369896f, 0.782126f, 
		-0.481431f, -0.528246f, 0.699414f, -0.597048f, -0.0613386f, 0.799857f, 
		0.351226f, 0.00537679f, -0.936275f, 0.188526f, -0.970299f, -0.151587f, 
		-0.697673f, 0.274487f, -0.661747f, -0.582945f, 0.763495f, -0.277940f, 
		-0.695671f, 0.372226f, -0.614401f, -0.609738f, 0.291105f, -0.737209f, 
		-0.729923f, 0.276146f, -0.625264f, 0.582259f, 0.344139f, -0.736575f, 
		0.232649f, -0.928510f, -0.289387f, 0.551936f, 0.0364489f, -0.833090f, 
		0.774707f, 0.610713f, 0.163888f, 0.765331f, -0.351099f, -0.539442f, 
		-0.353987f, 0.0184073f, 0.935069f, -0.171929f, 0.979596f, 0.104075f, 
		-0.989973f, 0.120581f, 0.0735832f, 0.775212f, 0.519582f, 0.359279f, 
		-0.0445648f, 0.107258f, -0.993232f, -0.991198f, 0.0665664f, -0.114437f, 
		0.779647f, -0.555807f, 0.288494f, -0.0524794f, 0.0374673f, -0.997919f, 
		0.785608f, -0.487009f, -0.381632f, -0.340477f, -0.0850591f, 0.936397f, 
		0.648731f, 0.265435f, 0.713227f, 0.160415f, 0.963730f, 0.213285f, 
		-0.733476f, 0.336586f, -0.590528f, 0.776064f, -0.263291f, 0.573064f, 
		-0.230667f, -0.948989f, -0.214971f, -0.404982f, -0.874695f, -0.266268f, 
		-0.478727f, -0.831728f, -0.281158f, -0.978386f, -0.204774f, 0.0287980f, 
		-0.250720f, -0.347692f, 0.903465f, 0.311287f, 0.889150f, 0.335428f, 
		0.572974f, 0.0791425f, 0.815743f, -0.983711f, -0.0159096f, 0.179050f, 
		0.402207f, -0.00353309f, -0.915542f, 0.0234562f, 0.0339709f, -0.999148f, 
		-0.118373f, -0.00437032f, -0.992960f, 0.551354f, 0.0324353f, -0.833641f, 
		0.796611f, 0.0151121f, -0.604303f, -0.974253f, -0.0904755f, -0.206506f, 
		0.801779f, 0.597539f, 0.00989098f, 0.295191f, 0.319469f, -0.900446f, 
		-0.170250f, 0.980382f, 0.0993252f, -0.973516f, 0.199854f, -0.111020f, 
		-0.970195f, -0.153684f, 0.187357f, -0.345190f, -0.298285f, -0.889871f, 
		-0.972304f, -0.210072f, -0.102449f, 0.810369f, -0.359485f, 0.462680f, 
		0.788390f, 0.602553f, -0.123980f, -0.0554026f, -0.998464f, 0.000444031f, 
		-0.530296f, -0.101196f, 0.841751f, -0.219148f, -0.961896f, 0.163492f, 
		-0.507651f, -0.741583f, 0.438572f, -0.348166f, -0.875599f, 0.334824f, 
		-0.948423f, -0.0594475f, 0.311385f, -0.762820f, 0.285929f, 0.579957f, 
		-0.354200f, 0.911742f, 0.208011f, 0.189522f, -0.326546f, 0.925985f, 
		0.204023f, -0.636990f, 0.743383f, 0.365488f, -0.808383f, 0.461449f, 
		0.285760f, -0.770024f, 0.570442f, 0.240990f, 0.375439f, -0.894969f, 
		-0.229508f, 0.968841f, 0.0931305f, -0.451089f, -0.690389f, -0.565581f, 
		0.826865f, -0.109641f, 0.551609f, -0.471831f, 0.527531f, 0.706461f, 
		-0.959318f, 0.106101f, 0.261631f, -0.0512410f, -0.0276325f, -0.998304f, 
		-0.518826f, 0.761996f, -0.387533f, -0.364566f, 0.862981f, -0.349792f, 
		-0.611902f, 0.507418f, -0.606715f, -0.242149f, -0.806653f, -0.539143f, 
		0.794545f, -0.0736473f, 0.602722f, -0.955489f, 0.0562432f, -0.289617f, 
		0.803997f, 0.431250f, -0.409403f, 0.709907f, -0.0811353f, -0.699607f, 
		0.587193f, -0.108129f, -0.802192f, 0.634914f, -0.0887372f, -0.767470f, 
		-0.949331f, 0.310924f, 0.0458006f, 0.243654f, -0.845944f, 0.474353f, 
		-0.997464f, -0.0513048f, -0.0493324f, -0.610550f, 0.00194496f, -0.791976f, 
		-0.953289f, -0.286083f, 0.0969390f, 0.177462f, 0.0419712f, -0.983232f, 
		-0.614476f, -0.0351389f, -0.788153f, -0.0497711f, -0.0562265f, -0.997177f, 
		-0.0547209f, -0.992691f, -0.107561f, 0.810901f, -0.112365f, 0.574295f, 
		0.817602f, -0.539634f, -0.200804f, 0.163288f, -0.953593f, 0.252978f, 
		0.574611f, -0.00770943f, 0.818391f, 0.810558f, 0.0381452f, 0.584415f, 
		-0.934400f, 0.286339f, 0.211913f, -0.942228f, 0.234398f, -0.239298f, 
		0.826374f, -0.563109f, -0.00366679f, -0.514028f, 0.435606f, -0.738933f, 
		-0.211657f, 0.455577f, -0.864668f, -0.729432f, -0.495156f, -0.471963f, 
		-0.702901f, 0.451996f, -0.549209f, -0.681621f, -0.657812f, 0.320431f, 
		0.476890f, -0.423075f, 0.770444f, -0.919544f, 0.106513f, 0.378276f, 
		-0.849393f, 0.111521f, 0.515843f, -0.929598f, 0.215022f, 0.299355f, 
		-0.894507f, 0.137345f, 0.425434f, -0.843350f, 0.157517f, 0.513760f, 
		-0.695710f, 0.264211f, 0.667967f, 0.833268f, -0.136684f, -0.535708f, 
		0.231354f, 0.405863f, -0.884167f, -0.121183f, 0.684444f, 0.718923f, 
		-0.715624f, 0.593381f, 0.368485f, 0.838120f, 0.208050f, -0.504253f, 
		-0.213239f, -0.964946f, -0.152999f, 0.844392f, 0.468589f, -0.259664f, 
		-0.929417f, -0.358021f, -0.0894729f, 0.766472f, 0.244217f, 0.594035f, 
		0.706013f, 0.363397f, 0.607855f, 0.558553f, 0.521390f, 0.645113f, 
		-0.938630f, -0.0219041f, 0.344229f, 0.797523f, -0.123594f, 0.590492f, 
		0.842316f, 0.390860f, 0.371123f, 0.471150f, 0.401706f, 0.785271f, 
		-0.297552f, -0.413917f, 0.860311f, 0.0191708f, 0.940669f, 0.338784f, 
		-0.125846f, -0.539186f, 0.832731f, 0.570190f, 0.627110f, 0.530675f, 
		0.607963f, 0.481369f, 0.631400f, 0.280410f, 0.302272f, 0.911044f, 
		-0.314518f, -0.686685f, -0.655395f, 0.313274f, 0.308428f, 0.898182f, 
		-0.0520953f, -0.119042f, -0.991522f, 0.702629f, 0.0599842f, 0.709024f, 
		-0.926002f, -0.259462f, -0.274227f, 0.839868f, 0.279298f, 0.465418f, 
		-0.774930f, 0.107874f, -0.622773f, -0.931824f, 0.104321f, -0.347594f, 
		-0.991136f, 0.103389f, -0.0834301f, -0.949711f, -0.0223908f, 0.312327f, 
		0.855842f, -0.301937f, -0.419962f, -0.915236f, 0.387120f, -0.111720f, 
		-0.915326f, 0.382063f, 0.127300f, 0.840908f, -0.408454f, 0.355020f, 
		-0.188478f, 0.865091f, 0.464859f, -0.247675f, -0.369882f, 0.895457f, 
		0.0455711f, 0.970516f, 0.236691f, -0.906918f, -0.113051f, -0.405855f, 
		-0.111360f, -0.975049f, -0.192040f, 0.847179f, -0.512046f, 0.141763f, 
		0.864036f, 0.125632f, 0.487503f, 0.418586f, 0.369574f, 0.829579f, 
		-0.903047f, -0.328140f, 0.277183f, 0.868234f, 0.437933f, 0.233206f, 
		0.163521f, 0.0733694f, -0.983808f, -0.608708f, -0.0222525f, -0.793083f, 
		-0.998807f, -0.0210513f, -0.0440646f, -0.608252f, 0.0398975f, -0.792740f, 
		-0.910288f, -0.187519f, 0.369069f, -0.151297f, 0.945898f, -0.287029f, 
		-0.0437925f, 0.559767f, 0.827492f, -0.180288f, 0.975198f, 0.128396f, 
		-0.898390f, -0.427711f, 0.0997919f, -0.00956437f, 0.129523f, -0.991530f, 
		-0.180289f, 0.975131f, 0.128900f, -0.169768f, 0.371899f, 0.912617f, 
		0.00901611f, 0.296331f, 0.955043f, 0.102252f, 0.0366893f, 0.994082f, 
		-0.0451870f, 0.128729f, 0.990650f, 0.860209f, 0.504174f, 0.0764759f, 
		-0.00710321f, -0.865202f, -0.501374f, -0.898818f, 0.199523f, -0.390277f, 
		-0.630904f, -0.135128f, 0.764003f, -0.0647031f, -0.205392f, -0.976539f, 
		-0.893351f, 0.0401432f, -0.447563f, -0.0402691f, -0.995573f, -0.0849316f, 
		0.147243f, -0.988254f, 0.0409183f, 0.647795f, 0.174764f, 0.741498f, 
		-0.901968f, 0.193341f, 0.386101f, 0.875801f, -0.196830f, 0.440717f, 
		-0.386013f, -0.656407f, -0.648170f, 0.802493f, -0.133145f, 0.581616f, 
		-0.883777f, 0.354090f, -0.305874f, 0.881313f, 0.313950f, -0.353162f, 
		-0.642460f, -0.211044f, 0.736686f, -0.286209f, -0.444435f, -0.848859f, 
		0.882384f, -0.384970f, -0.270549f, -0.313213f, 0.948651f, 0.0442591f, 
		-0.871769f, -0.000874885f, 0.489916f, -0.260101f, -0.800357f, -0.540163f, 
		-0.884073f, 0.462918f, 0.0641971f, 0.886341f, 0.0256985f, -0.462319f, 
		0.944850f, -0.0443674f, 0.324485f, 0.819809f, 0.0455848f, -0.570819f, 
		0.924564f, -0.195882f, 0.326822f, 0.813792f, -0.0646525f, -0.577548f, 
		-0.0768169f, -0.246976f, -0.965972f, -0.532609f, -0.0720203f, 0.843291f, 
		0.399916f, 0.127139f, -0.907691f, 0.303911f, 0.184893f, -0.934587f, 
		0.546054f, -0.186589f, -0.816706f, 0.428361f, -0.131492f, -0.893989f, 
		0.203146f, 0.294732f, -0.933737f, -0.313602f, -0.497656f, 0.808698f, 
		0.0630016f, -0.993275f, 0.0971391f, 0.422646f, -0.483622f, 0.766472f, 
		-0.864225f, -0.407789f, -0.294658f, 0.893421f, -0.0231482f, 0.448624f, 
		-0.611901f, -0.0137474f, 0.790815f, 0.887242f, 0.453768f, -0.0830446f, 
		0.896257f, -0.386532f, 0.217524f, 0.904728f, 0.277979f, 0.322791f, 
		0.909814f, -0.268262f, -0.316661f, 0.214519f, 0.0699199f, 0.974214f, 
		0.218137f, -0.0762872f, 0.972932f, 0.313052f, -0.469214f, 0.825734f, 
		-0.863306f, 0.453956f, 0.220514f, 0.679125f, 0.111034f, 0.725576f, 
		0.720241f, -0.0476998f, 0.692083f, 0.273854f, 0.874060f, 0.401276f, 
		0.477386f, 0.397093f, 0.783849f, 0.160415f, 0.963730f, 0.213285f, 
		0.484779f, 0.165550f, -0.858827f, 0.0664939f, -0.262199f, -0.962720f, 
		-0.229160f, -0.219630f, -0.948287f, 0.324111f, -0.274891f, -0.905200f, 
		0.659929f, 0.174996f, 0.730664f, 0.669636f, 0.249521f, 0.699519f, 
		0.637276f, 0.254340f, 0.727455f, 0.639532f, 0.348211f, 0.685381f, 
		0.621247f, -0.0215254f, 0.783319f, 0.709930f, -0.155163f, 0.686967f, 
		-0.286199f, -0.444423f, -0.848869f, -0.0318298f, -0.994329f, -0.101476f, 
		0.800996f, -0.0890830f, 0.592005f, 0.916244f, -0.393965f, 0.0727231f, 
		0.212527f, 0.461476f, -0.861320f, -0.172798f, 0.984145f, -0.0400039f, 
		0.0282729f, 0.922564f, 0.384807f, 0.949738f, -0.0775304f, 0.303294f, 
		0.819520f, 0.0181280f, -0.572764f, 0.911732f, -0.258776f, 0.319031f, 
		0.142231f, 0.0590895f, -0.988068f, -0.254097f, 0.0255382f, -0.966842f, 
		-0.452496f, 0.00180416f, -0.891764f, 0.913073f, -0.398493f, -0.0866062f, 
		-0.849429f, -0.239011f, 0.470472f, -0.848901f, -0.523971f, -0.0694416f, 
		0.196915f, -0.979936f, -0.0308075f, 0.921734f, 0.147038f, -0.358869f, 
		-0.846683f, -0.282230f, -0.451080f, 0.916592f, -0.137620f, -0.375392f, 
		-0.116421f, -0.390390f, 0.913259f, -0.111688f, -0.990918f, -0.0748856f, 
		0.518429f, 0.494791f, 0.697433f, 0.356221f, 0.524552f, 0.773274f, 
		0.430746f, 0.503009f, 0.749293f, -0.157079f, 0.948304f, -0.275762f, 
		0.923323f, 0.374921f, 0.0831247f, -0.830154f, -0.498391f, 0.249901f, 
		-0.100149f, 0.0630057f, -0.992976f, -0.0180552f, -0.985436f, -0.169088f, 
		-0.702804f, -0.568656f, -0.427431f, 0.923531f, 0.311693f, -0.223468f, 
		0.927078f, 0.313879f, 0.204953f, 0.933695f, -0.0898771f, 0.346605f, 
		0.0715235f, -0.996880f, 0.0333763f, -0.230976f, -0.481629f, 0.845390f, 
		-0.654592f, -0.271077f, 0.705710f, 0.931799f, 0.0906577f, 0.351472f, 
		-0.830283f, 0.397120f, 0.391057f, -0.823574f, 0.504613f, -0.259020f, 
		-0.328390f, -0.0832919f, -0.940863f, 0.681761f, 0.146547f, -0.716747f, 
		0.505282f, 0.122403f, -0.854229f, -0.273493f, -0.198878f, 0.941089f, 
		-0.295056f, -0.105376f, 0.949651f, -0.335264f, 0.245719f, 0.909517f, 
		-0.828019f, 0.235971f, 0.508627f, -0.827212f, 0.00207016f, -0.561886f, 
		-0.281940f, 0.849051f, 0.446790f, -0.0997865f, 0.666660f, 0.738652f, 
		-0.398883f, 0.625460f, 0.670590f, -0.542582f, 0.445716f, 0.711999f, 
		-0.325619f, 0.482002f, 0.813416f, -0.819890f, 0.568362f, -0.0688924f, 
		-0.695849f, 0.264141f, 0.667850f, -0.806860f, 0.334588f, -0.486855f, 
		0.0128498f, -0.813794f, 0.581012f, -0.176311f, 0.0993749f, 0.979305f, 
		-0.832867f, -0.514543f, -0.203907f, 0.957495f, 0.284165f, -0.0495386f, 
		-0.810198f, -0.409717f, 0.419179f, 0.114636f, 0.579925f, 0.806564f, 
		0.319929f, 0.576169f, 0.752114f, 0.199474f, 0.555485f, 0.807246f, 
		0.0310429f, 0.790974f, -0.611062f, -0.592559f, 0.0779633f, 0.801745f, 
		0.952596f, -0.233247f, -0.195336f, -0.804502f, -0.155962f, -0.573107f, 
		-0.714982f, 0.378610f, 0.587755f, 0.0590683f, 0.945229f, 0.321019f, 
		0.956762f, -0.250255f, 0.148255f, -0.816992f, 0.171061f, -0.550692f, 
		0.964787f, -0.262841f, 0.0100440f, -0.168960f, -0.00553714f, 0.985607f, 
		0.964371f, -0.0221666f, -0.263625f, 0.963049f, 0.164996f, 0.212868f, 
		0.954215f, -0.0925428f, 0.284447f, 0.817237f, 0.0168347f, -0.576056f, 
		-0.260952f, -0.637315f, 0.725075f, -0.131993f, -0.619831f, 0.773555f, 
		-0.285698f, -0.430646f, 0.856108f, -0.247339f, -0.425448f, 0.870527f, 
		-0.791015f, -0.609615f, 0.0516199f, -0.673871f, -0.563823f, 0.477495f, 
		0.0575669f, -0.611032f, 0.789510f, 0.970733f, 0.225313f, 0.0831324f, 
		-0.798527f, -0.402872f, -0.447267f, 0.0834490f, 0.971556f, 0.221620f, 
		-0.0640281f, -0.872227f, 0.484892f, 0.234513f, -0.928132f, -0.289094f, 
		0.0824455f, -0.994315f, -0.0673788f, 0.973673f, -0.104800f, 0.202430f, 
		0.523914f, -0.502934f, 0.687438f, 0.972688f, 0.154265f, -0.173436f, 
		0.973015f, 0.0177606f, 0.230058f, 0.00463029f, -0.985808f, -0.167814f, 
		-0.237123f, 0.970075f, 0.0522253f, -0.783738f, 0.530295f, 0.323329f, 
		-0.778705f, -0.0613291f, 0.624385f, -0.534006f, -0.0568824f, 0.843565f, 
		-0.130908f, 0.982820f, 0.130106f, -0.211612f, 0.00747892f, 0.977325f, 
		0.986840f, 0.159388f, -0.0272319f, -0.781336f, -0.275031f, 0.560243f, 
		-0.785792f, 0.601701f, 0.143136f, 0.990142f, -0.121564f, 0.0695832f, 
		-0.291866f, 0.528379f, 0.797264f, 0.0679969f, 0.721931f, 0.688616f, 
		0.371434f, 0.566066f, 0.735939f, 0.316522f, 0.695728f, 0.644807f, 
		0.0951767f, 0.910788f, 0.401754f, 0.239390f, 0.846136f, 0.476179f, 
		0.580258f, -0.0291809f, -0.813910f, -0.352986f, 0.893297f, -0.278247f, 
		-0.487239f, 0.864094f, -0.126251f, -0.541197f, 0.838215f, -0.0670904f, 
		0.992420f, -0.105052f, -0.0637620f, -0.777748f, -0.531434f, -0.335688f, 
		-0.0190796f, 0.959775f, 0.280122f, -0.104237f, -0.543589f, 0.832854f, 
		0.996812f, 0.0444523f, 0.0662587f, 0.995877f, 0.0328339f, -0.0845579f, 
		0.295267f, 0.319155f, -0.900532f, 0.234372f, -0.928304f, -0.288653f, 
		0.513418f, 0.0957932f, -0.852775f, 0.619922f, 0.522193f, 0.585672f, 
		0.670404f, -0.385088f, 0.634244f, 0.186357f, 0.0736684f, -0.979716f, 
		0.0166070f, -0.828728f, 0.559406f, 0.0515848f, -0.243600f, 0.968503f, 
		-0.147034f, 0.639709f, -0.754422f, -0.224356f, 0.744684f, -0.628577f, 
		-0.270971f, 0.961210f, -0.0514852f, -0.284326f, 0.890446f, -0.355338f, 
		0.958667f, -0.0683031f, 0.276210f, 0.818479f, 0.00881274f, -0.574469f, 
		-0.224344f, 0.939806f, 0.257747f, 0.0497942f, 0.944344f, 0.325168f, 
		-0.467719f, 0.874170f, 0.130631f, 0.653128f, -0.0734262f, 0.753679f, 
		-0.127684f, -0.105721f, 0.986164f, -0.759661f, 0.181820f, 0.624385f, 
		-0.764004f, 0.472668f, -0.439185f, -0.269768f, 0.0250968f, -0.962598f, 
		0.150793f, -0.661519f, 0.734612f, 0.0746459f, -0.321019f, 0.944126f, 
		0.173762f, -0.971170f, -0.163201f, -0.0939753f, 0.0658278f, -0.993396f, 
		0.175580f, -0.965824f, -0.190672f, -0.0877631f, -0.933230f, 0.348397f, 
		0.0579707f, -0.916076f, 0.396791f, -0.157383f, -0.819742f, 0.550685f, 
		-0.0514791f, -0.805390f, 0.590505f, -0.219160f, 0.560379f, 0.798714f, 
		0.615005f, -0.0702221f, 0.785390f, -0.229665f, -0.112127f, 0.966789f, 
		0.637447f, -0.0698806f, 0.767319f, -0.196587f, -0.106487f, 0.974687f, 
		-0.732232f, -0.630123f, 0.258421f, -0.0980041f, -0.104176f, 0.989718f, 
		0.674718f, -0.0953942f, 0.731885f, -0.463876f, 0.0725200f, 0.882927f, 
		-0.310888f, 0.118943f, 0.942975f, -0.400582f, 0.0980914f, 0.910995f, 
		-0.586816f, 0.194263f, 0.786072f, -0.742490f, -0.647900f, -0.170100f, 
		0.353992f, 0.286107f, 0.890411f, 0.241686f, 0.171100f, 0.955150f, 
		0.317618f, 0.229946f, 0.919915f, 0.0480085f, 0.182335f, 0.982064f, 
		-0.367651f, 0.839677f, 0.399719f, 0.802850f, -0.135688f, -0.580535f, 
		0.0671393f, 0.937391f, 0.341747f, 0.884769f, 0.0731913f, 0.460247f, 
		-0.394563f, -0.870968f, -0.292806f, -0.231076f, -0.921884f, -0.311021f, 
		-0.315224f, -0.894669f, -0.316545f, -0.0796138f, 0.978057f, 0.192527f, 
		-0.746968f, -0.327139f, -0.578808f, -0.535400f, -0.0345112f, 0.843893f, 
		0.478483f, 0.191300f, -0.857006f, 0.534450f, -0.608602f, 0.586487f, 
		-0.740217f, 0.644320f, -0.192173f, 0.648731f, 0.265435f, 0.713227f, 
		-0.470754f, -0.136406f, -0.871656f, -0.826858f, 0.439522f, -0.350895f, 
		0.592504f, -0.237894f, -0.769639f, 0.183412f, 0.0264301f, -0.982681f, 
		-0.205344f, 0.969390f, 0.134599f, -0.221457f, -0.577128f, -0.786054f, 
		-0.726420f, 0.105054f, -0.679174f, -0.176918f, 0.720619f, -0.670379f, 
		0.0961514f, -0.992584f, -0.0743710f, -0.155868f, -0.862912f, 0.480716f, 
		-0.192635f, -0.927054f, 0.321657f, -0.304316f, -0.773899f, 0.555403f, 
		0.709763f, -0.0226169f, 0.704077f, -0.0940963f, 0.225960f, 0.969581f, 
		0.607699f, -0.0395390f, 0.793182f, -0.231597f, -0.108520f, 0.966740f, 
		0.236414f, -0.890037f, 0.389798f, -0.0257568f, -0.475723f, 0.879218f, 
		0.219217f, -0.952473f, 0.211518f, 0.0771019f, -0.602503f, 0.794384f, 
		-0.726062f, 0.380079f, 0.573039f, 0.897510f, 0.265963f, 0.351766f, 
		-0.135457f, 0.261320f, 0.955701f, 0.173771f, -0.887825f, -0.426110f, 
		0.0437425f, 0.220665f, 0.974368f, -0.723230f, -0.541040f, 0.429202f, 
		-0.0915141f, 0.0635146f, 0.993776f, -0.180955f, 0.978464f, 0.0993139f, 
		-0.199868f, 0.219347f, -0.954955f, -0.182256f, 0.978820f, 0.0932394f, 
		0.0974709f, -0.650462f, 0.753259f, -0.0317940f, 0.395652f, -0.917850f, 
		0.144423f, -0.987287f, 0.0663821f, -0.706890f, -0.403890f, 0.580672f, 
		-0.702268f, -0.705683f, 0.0939749f, -0.0133550f, -0.969347f, 0.245333f, 
		0.147243f, -0.988254f, 0.0409183f, 0.872677f, -0.174200f, 0.456169f, 
		0.893267f, -0.0585999f, 0.445691f, 0.764967f, -0.361693f, 0.532920f, 
		-0.705811f, 0.286225f, -0.648002f, -0.201503f, -0.664766f, -0.719363f, 
		0.0109421f, -0.0778176f, 0.996908f, -0.0933243f, 0.337153f, 0.936813f, 
		-0.691666f, 0.635952f, 0.342291f, -0.185551f, 0.734164f, -0.653127f, 
		0.636205f, -0.0424479f, -0.770352f, 0.617025f, 0.514112f, 0.595793f, 
		0.122533f, 0.975280f, 0.183888f, -0.220785f, -0.966645f, 0.129816f, 
		-0.467053f, -0.878760f, 0.0982021f, -0.00170764f, -0.994212f, 0.107426f, 
		-0.689962f, 0.298797f, 0.659297f, -0.691576f, 0.721590f, -0.0320964f, 
		-0.703377f, -0.0661447f, -0.707733f, 0.100316f, 0.972828f, 0.208666f, 
		-0.0340544f, -0.108595f, 0.993503f, 0.279131f, -0.104245f, 0.954578f, 
		0.701125f, -0.0892389f, 0.707432f, 0.452298f, -0.102489f, 0.885958f, 
		-0.690508f, -0.252059f, 0.677986f, 0.985895f, 0.0367011f, 0.163289f, 
		0.898085f, -0.309995f, 0.312003f, 0.383504f, -0.0216486f, 0.923285f, 
		0.488878f, -0.174612f, 0.854698f, 0.827331f, -0.425970f, 0.366160f, 
		0.762178f, -0.364220f, 0.535190f, 0.622813f, 0.263836f, 0.736542f, 
		0.748557f, 0.315542f, 0.583178f, 0.371984f, 0.143574f, 0.917068f, 
		0.468238f, 0.221190f, 0.855470f, 0.807986f, 0.358283f, 0.467751f, 
		-0.485686f, 0.852879f, 0.191591f, -0.694133f, 0.635687f, -0.337760f, 
		-0.0291650f, 0.496715f, 0.867423f, 0.0928041f, -0.0585112f, 0.993964f, 
		-0.702711f, 0.523708f, 0.481587f, -0.684657f, -0.497603f, -0.532575f, 
		-0.681160f, -0.644163f, -0.347960f, 0.0685060f, -0.299702f, 0.951570f, 
		0.146202f, -0.452693f, 0.879599f, -0.0241509f, 0.155710f, 0.987508f, 
		0.00810165f, 0.331283f, 0.943497f, -0.677886f, 0.716211f, 0.165871f, 
		0.0266885f, -0.679742f, 0.732965f, 0.229429f, -0.312142f, 0.921916f, 
		0.112505f, -0.342915f, 0.932605f, 0.519791f, -0.136793f, 0.843270f, 
		-0.0525769f, -0.395002f, 0.917174f, 0.396092f, -0.119030f, 0.910463f, 
		-0.692011f, -0.210694f, -0.690456f, 0.0978156f, -0.993940f, -0.0501540f, 
		0.386430f, -0.910241f, 0.148772f, 0.309939f, -0.246882f, 0.918143f, 
		0.607261f, -0.00626998f, 0.794477f, -0.233969f, -0.0779117f, 0.969117f, 
		-0.164010f, 0.488704f, 0.856895f, -0.0634649f, 0.989479f, 0.130014f, 
		-0.285835f, 0.0259709f, -0.957927f, -0.701628f, 0.307973f, -0.642551f, 
		-0.535390f, 0.184911f, -0.824115f, -0.468774f, 0.0243968f, -0.882981f, 
		-0.180003f, 0.975261f, 0.128316f, 0.724272f, 0.0101345f, -0.689440f, 
		0.605467f, 0.0305401f, -0.795284f, 0.0761903f, -0.0221823f, -0.996846f, 
		-0.134616f, -0.0576340f, -0.989220f, -0.316619f, 0.403802f, 0.858310f, 
		-0.664969f, 0.437660f, -0.605202f, 0.454550f, -0.108897f, -0.884039f, 
		-0.650697f, -0.0989156f, 0.752867f, -0.653803f, -0.351461f, -0.670087f, 
		-0.757376f, 0.0932025f, -0.646293f, 0.236694f, -0.754769f, 0.611800f, 
		-0.413258f, 0.519731f, 0.747728f, -0.446905f, 0.371654f, 0.813726f, 
		-0.198392f, 0.873045f, 0.445459f, -0.0683023f, 0.974471f, 0.213873f, 
		-0.434727f, 0.346699f, 0.831151f, -0.150085f, -0.971134f, -0.185399f, 
		-0.742367f, 0.00841660f, -0.669941f, 0.609757f, 0.0211665f, -0.792305f, 
		-0.644423f, -0.759990f, -0.0844606f, -0.659948f, 0.116240f, 0.742265f, 
		0.0190389f, 0.867166f, 0.497655f, -0.602963f, 0.261016f, 0.753860f, 
		0.0156349f, -0.205593f, -0.978513f, 0.394644f, -0.918305f, -0.0311816f, 
		-0.0797974f, -0.210806f, -0.974266f, 0.461181f, -0.870487f, 0.171941f, 
		0.363672f, 0.860906f, 0.355785f, -0.695492f, 0.717283f, -0.0423886f, 
		-0.0298207f, -0.211624f, -0.976896f, -0.370006f, -0.911886f, -0.177651f, 
		-0.724422f, -0.446308f, 0.525378f, -0.797840f, -0.472414f, 0.374534f, 
		-0.772842f, -0.453704f, 0.443699f, -0.635070f, 0.205511f, -0.744615f, 
		-0.107375f, 0.797728f, 0.593381f, 0.0949463f, 0.131402f, -0.986772f, 
		0.0222507f, -0.984510f, -0.173908f, -0.620625f, -0.00383012f, -0.784098f, 
		-0.0899233f, -0.842596f, -0.530986f, -0.185814f, -0.484398f, 0.854887f, 
		-0.679026f, 0.481868f, 0.553828f, 0.192860f, -0.980700f, -0.0321315f, 
		0.338419f, -0.675329f, 0.655289f, -0.627191f, 0.752363f, -0.201446f, 
		-0.616043f, 0.322029f, 0.718880f, -0.305062f, 0.0523732f, -0.950891f, 
		-0.610725f, -0.737308f, 0.288777f, 0.0490472f, -0.0125008f, -0.998718f, 
		0.368732f, -0.00809485f, -0.929500f, 0.776338f, 0.00286205f, -0.630311f, 
		0.643343f, 0.00883575f, -0.765527f, -0.620975f, -0.519377f, 0.587058f, 
		-0.471920f, 0.873246f, 0.121382f, -0.0582419f, 0.395212f, 0.916742f, 
		0.140501f, 0.741972f, 0.655543f, 0.210907f, 0.534262f, 0.818586f, 
		0.0823573f, 0.815494f, 0.572876f, -0.612184f, 0.602859f, -0.511656f, 
		-0.584740f, -0.804065f, 0.107508f, 0.181577f, 0.606798f, 0.773839f, 
		-0.180225f, 0.975264f, 0.127979f, 0.0678764f, -0.978215f, 0.196184f, 
		-0.606674f, -0.752700f, -0.255713f, -0.610520f, -0.646597f, 0.457360f, 
		-0.606824f, -0.615934f, -0.502384f, 0.366677f, 0.0919494f, -0.925793f, 
		-0.601752f, 0.490982f, 0.629945f, -0.198494f, -0.533863f, 0.821943f, 
		-0.245339f, 0.940262f, 0.236041f, 0.285801f, 0.354611f, 0.890264f, 
		0.283841f, 0.275609f, 0.918408f, 0.288043f, 0.196450f, 0.937251f, 
		0.295790f, -0.939760f, 0.171346f, 0.103600f, -0.984053f, -0.144594f, 
		-0.481164f, 0.872593f, -0.0840415f, -0.596107f, 0.773444f, -0.215499f, 
		-0.768063f, 0.224195f, -0.599846f, -0.753634f, 0.404052f, -0.518438f, 
		0.477522f, 0.0357823f, -0.877891f, 0.216509f, -0.898020f, 0.382994f, 
		0.565616f, 0.125253f, -0.815101f, 0.0514648f, 0.980101f, 0.191710f, 
		-0.418695f, 0.0920428f, -0.903450f, 0.141175f, 0.00800714f, -0.989952f, 
		0.507456f, 0.00919670f, -0.861629f, 0.582575f, 0.0128221f, -0.812676f, 
		0.606808f, 0.00181945f, 0.794846f, -0.237074f, -0.0556306f, 0.969897f, 
		-0.290950f, 0.290993f, 0.911412f, 0.497368f, 0.241931f, 0.833123f, 
		-0.159577f, 0.385571f, 0.908774f, 0.216023f, 0.404453f, 0.888680f, 
		0.344774f, 0.0185411f, -0.938503f, -0.563891f, -0.712521f, -0.417541f, 
		-0.572122f, 0.775468f, 0.267068f, -0.338953f, 0.195328f, -0.920303f, 
		-0.578247f, 0.144131f, -0.803030f, -0.216461f, -0.812616f, -0.541111f, 
		0.124205f, 0.981350f, 0.146716f, 0.225531f, 0.690413f, -0.687362f, 
		0.251002f, 0.948036f, 0.195511f, 0.465894f, 0.840299f, 0.277200f, 
		0.130303f, -0.898345f, -0.419520f, -0.325048f, 0.228427f, -0.917695f, 
		-0.562491f, 0.717922f, 0.410112f, 0.168744f, -0.981047f, -0.0952528f, 
		-0.790496f, -0.478908f, -0.381791f, -0.701096f, -0.487326f, -0.520555f, 
		-0.757055f, -0.480531f, -0.442671f, -0.610262f, -0.226879f, 0.759017f, 
		-0.576696f, -0.421705f, 0.699705f, -0.565456f, -0.444269f, -0.694899f, 
		-0.578459f, 0.633679f, 0.513649f, 0.0430451f, -0.958964f, 0.280241f, 
		-0.319017f, -0.0425990f, 0.946791f, 0.517092f, 0.0220847f, 0.855645f, 
		0.0992158f, -0.0194574f, -0.994876f, 0.786794f, -0.0102443f, -0.617131f, 
		-0.554794f, 0.828043f, 0.0809244f, 0.351673f, -0.0504856f, -0.934761f, 
		0.478501f, 0.0288575f, -0.877613f, 0.437406f, -0.0350737f, -0.898580f, 
		-0.601536f, 0.795253f, -0.0756803f, 0.0540969f, 0.0447772f, 0.997531f, 
		-0.183882f, 0.979814f, 0.0784370f, 0.528232f, 0.0474368f, -0.847774f, 
		0.458543f, 0.838501f, 0.294371f, -0.719154f, 0.678835f, -0.148324f, 
		-0.755672f, 0.608625f, 0.241941f, -0.557124f, 0.738184f, -0.380391f, 
		-0.490624f, -0.867002f, -0.0871469f, -0.555330f, -0.555105f, -0.619247f, 
		-0.569713f, -0.237676f, -0.786726f, -0.551867f, 0.218904f, 0.804689f, 
		-0.556186f, -0.313060f, 0.769838f, -0.548127f, -0.160298f, 0.820890f, 
		-0.438373f, -0.130708f, 0.889238f, -0.550859f, 0.832626f, -0.0573421f, 
		0.216448f, -0.127257f, 0.967965f, 0.331200f, -0.0401063f, -0.942708f, 
		-0.493201f, -0.216317f, 0.842591f, -0.622870f, 0.263536f, 0.736602f, 
		0.389765f, -0.163284f, 0.906323f, 0.276768f, 0.0695023f, 0.958420f, 
		0.309176f, -0.0303436f, 0.950521f, 0.523777f, 0.0945262f, -0.846594f, 
		-0.173211f, 0.290393f, -0.941100f, -0.500647f, 0.865373f, -0.0219616f, 
		-0.113849f, 0.909415f, 0.400003f, -0.669910f, 0.388946f, 0.632410f, 
		0.203332f, -0.978904f, -0.0200713f, -0.539013f, 0.0601743f, 0.840146f, 
		-0.553327f, 0.383244f, -0.739563f, -0.392226f, 0.909176f, 0.139852f, 
		-0.635648f, 0.764634f, -0.106237f, -0.438811f, 0.851522f, -0.286977f, 
		-0.581309f, 0.797118f, -0.163349f, -0.204874f, -0.761860f, -0.614488f, 
		-0.119900f, -0.650652f, -0.749851f, -0.0248160f, 0.261839f, -0.964792f, 
		0.236115f, -0.928032f, -0.288108f, 0.0627608f, -0.738978f, 0.670800f, 
		0.0859686f, -0.512530f, 0.854355f, 0.203926f, -0.619659f, 0.757916f, 
		0.187660f, -0.374195f, 0.908164f, 0.252148f, -0.811980f, 0.526412f, 
		0.235580f, -0.927855f, -0.289114f, -0.492969f, 0.449103f, 0.745176f, 
		-0.261617f, 0.307970f, -0.914719f, -0.508704f, 0.540992f, -0.669737f, 
		0.325000f, -0.0653105f, -0.943456f, -0.507267f, -0.583117f, 0.634550f, 
		0.145356f, 0.550299f, 0.822218f, -0.493497f, 0.845807f, -0.202662f, 
		0.551754f, 0.404876f, 0.729138f, -0.208084f, -0.860538f, -0.464947f, 
		-0.201917f, 0.0365265f, -0.978721f, -0.381616f, -0.0139899f, 0.924215f, 
		-0.598722f, -0.0589037f, -0.798788f, 0.160082f, -0.973322f, -0.164374f, 
		0.235634f, 0.488770f, -0.839988f, 0.173649f, 0.305615f, -0.936187f, 
		0.248587f, 0.639660f, -0.727351f, 0.217500f, 0.763594f, -0.607962f, 
		0.268931f, 0.392482f, -0.879565f, -0.499626f, -0.866071f, -0.0171909f, 
		0.521521f, 0.704272f, 0.481682f, -0.499345f, 0.0683840f, -0.863700f, 
		-0.471728f, -0.105296f, 0.875435f, -0.711227f, -0.700490f, 0.0588977f, 
		-0.817229f, -0.575143f, 0.0367110f, -0.756718f, -0.652058f, 0.0468844f, 
		-0.779496f, 0.281170f, -0.559757f, -0.486784f, -0.654485f, -0.578524f, 
		0.606155f, 0.00781634f, 0.795308f, -0.240261f, -0.0450992f, 0.969660f, 
		-0.689601f, 0.600651f, -0.404560f, -0.180261f, 0.975262f, 0.127946f, 
		-0.479375f, 0.600098f, 0.640377f, -0.659769f, -0.745962f, -0.0908090f, 
		-0.736552f, -0.653739f, 0.173538f, -0.563187f, -0.740811f, -0.366087f, 
		-0.712559f, -0.687252f, -0.141222f, -0.621250f, -0.670289f, -0.405907f, 
		-0.653363f, -0.695734f, -0.298449f, -0.0486045f, 0.973855f, -0.221908f, 
		-0.910905f, -0.326200f, 0.252677f, -0.734218f, -0.122781f, 0.667719f, 
		-0.688296f, -0.0310435f, 0.724765f, -0.794054f, -0.145733f, 0.590119f, 
		-0.871070f, -0.279575f, 0.403826f, -0.461903f, -0.807180f, -0.367567f, 
		0.517659f, 0.0936675f, -0.850444f, -0.602254f, 0.0851112f, -0.793755f, 
		-0.190735f, 0.976015f, 0.104954f, -0.476123f, 0.281474f, -0.833114f, 
		0.329771f, -0.123958f, -0.935887f, 0.514625f, -0.758388f, 0.400011f, 
		-0.0509091f, 0.975033f, -0.216147f, -0.481606f, -0.725302f, 0.491928f, 
		-0.472364f, 0.688675f, -0.550090f, -0.0566049f, 0.299960f, -0.952271f, 
		-0.471709f, 0.818229f, 0.328620f, -0.471153f, -0.820982f, 0.322495f, 
		0.340735f, -0.939263f, 0.0410374f, 0.378708f, -0.170979f, 0.909586f, 
		-0.462211f, -0.869266f, -0.175323f, -0.0566049f, 0.299960f, -0.952271f, 
		0.350949f, -0.259770f, 0.899641f, 0.168661f, -0.974925f, -0.145172f, 
		0.298685f, -0.291044f, 0.908890f, -0.435461f, 0.900179f, 0.00724811f, 
		-0.459888f, -0.151128f, -0.875022f, 0.251689f, 0.818673f, -0.516166f, 
		-0.0391087f, 0.779257f, -0.625483f, 0.125858f, 0.778138f, -0.615355f, 
		0.472693f, 0.836998f, 0.275674f, -0.716912f, 0.675746f, -0.171480f, 
		0.533515f, 0.0455894f, 0.844561f, 0.0816165f, 0.666766f, 0.740785f, 
		-0.0534011f, -0.970928f, -0.233339f, 0.208863f, -0.977931f, -0.00519371f, 
		0.484078f, -0.519844f, 0.703868f, 0.388414f, 0.436969f, 0.811291f, 
		-0.436360f, -0.888011f, 0.145003f, 0.424432f, 0.301476f, 0.853797f, 
		0.351289f, 0.288117f, 0.890834f, 0.0753895f, 0.341909f, 0.936704f, 
		-0.433820f, 0.821609f, -0.369810f, -0.440953f, -0.379174f, -0.813504f, 
		0.606399f, -0.00560154f, 0.795141f, -0.240245f, -0.0341192f, 0.970113f, 
		0.120764f, -0.976925f, -0.176166f, 0.259722f, 0.167992f, -0.950959f, 
		-0.158021f, -0.986702f, -0.0380542f, -0.303021f, -0.934024f, 0.189148f, 
		0.0467053f, -0.988521f, -0.143681f, 0.161920f, -0.915002f, -0.369531f, 
		0.278177f, 0.134022f, 0.951134f, -0.187768f, 0.975582f, 0.113941f, 
		-0.411073f, 0.0564477f, 0.909853f, -0.443351f, 0.748210f, 0.493580f, 
		0.0697449f, -0.975790f, 0.207291f, 0.351809f, -0.196831f, -0.915144f, 
		-0.507999f, -0.396046f, -0.764908f, 0.990748f, 0.00152136f, 0.135705f, 
		0.864306f, -0.0322401f, 0.501932f, 0.819125f, -0.0349495f, 0.572549f, 
		-0.354905f, 0.0685524f, 0.932386f, -0.255555f, 0.362691f, 0.896185f, 
		0.349123f, 0.00156952f, 0.937076f, -0.616864f, 0.291998f, 0.730901f, 
		-0.00885871f, -0.207775f, 0.978137f, 0.0459479f, -0.0106335f, 0.998887f, 
		0.0378595f, -0.110048f, 0.993205f, 0.906231f, -0.0478861f, 0.420061f, 
		0.867861f, -0.0530754f, 0.493964f, 0.750583f, -0.0629501f, 0.657771f, 
		-0.431314f, 0.192049f, 0.881525f, -0.246283f, 0.871379f, 0.424315f, 
		-0.395010f, 0.183924f, 0.900077f, 0.615602f, 0.0295403f, 0.787503f, 
		-0.219919f, 0.0568989f, 0.973857f, -0.301911f, 0.315277f, 0.899694f, 
		-0.366863f, 0.187442f, 0.911196f, -0.362047f, 0.311694f, -0.878504f, 
		-0.482941f, 0.411134f, -0.773135f, -0.611864f, 0.759915f, -0.219434f, 
		-0.610070f, 0.606498f, -0.509876f, 0.0789639f, 0.781357f, -0.619069f, 
		-0.0722640f, 0.818848f, -0.569443f, -0.00374270f, 0.803157f, -0.595756f, 
		-0.431572f, 0.279634f, 0.857642f, -0.402240f, -0.0198499f, -0.915319f, 
		-0.413523f, -0.554267f, -0.722348f, -0.698553f, 0.462117f, 0.546326f, 
		0.421539f, 0.257258f, -0.869554f, -0.211612f, 0.925868f, 0.313032f, 
		-0.197731f, 0.948472f, 0.247596f, -0.163289f, 0.973621f, 0.159373f, 
		0.869848f, -0.0487038f, 0.490910f, 0.226280f, -0.969957f, -0.0893326f, 
		-0.0913711f, 0.947380f, 0.306794f, 0.396974f, 0.899721f, 0.181419f, 
		0.176924f, 0.920297f, 0.348928f, -0.0667833f, -0.546684f, 0.834671f, 
		-0.874060f, -0.462525f, -0.148627f, -0.937383f, -0.339208f, 0.0790699f, 
		-0.713922f, -0.576994f, -0.396729f, 0.865229f, 0.0122593f, 0.501226f, 
		0.990086f, 0.0467529f, 0.132454f, 0.744823f, -0.0102399f, 0.667183f, 
		-0.408830f, -0.497647f, 0.764987f, -0.255021f, 0.136801f, 0.957209f, 
		-0.403620f, 0.902417f, 0.150779f, 0.373153f, -0.922040f, 0.102953f, 
		-0.399576f, -0.742803f, -0.537199f, 0.268889f, -0.876408f, -0.399508f, 
		-0.0986301f, -0.00143505f, 0.995123f, -0.393339f, 0.147755f, -0.907443f, 
		-0.0129518f, 0.0314751f, -0.999421f, -0.961420f, -0.192452f, -0.196557f, 
		-0.942021f, -0.197392f, -0.271353f, -0.911847f, -0.208220f, -0.353807f, 
		-0.0129518f, 0.0314751f, -0.999421f, 0.880743f, -0.0720202f, 0.468086f, 
		0.343142f, 0.332351f, -0.878519f, -0.0859452f, 0.995518f, 0.0394576f, 
		0.507483f, 0.0801081f, -0.857930f, 0.678059f, 0.0881135f, -0.729707f, 
		0.131717f, 0.0544850f, -0.989789f, 0.0341483f, -0.975525f, 0.217219f, 
		-0.986894f, -0.158072f, 0.0324699f, -0.675279f, 0.128988f, 0.726195f, 
		0.392369f, -0.224230f, -0.892058f, -0.0807846f, -0.529501f, 0.844454f, 
		0.898359f, 0.0385677f, -0.437565f, 0.985847f, 0.0319544f, -0.164574f, 
		0.968393f, 0.0300853f, -0.247608f, -0.0217821f, -0.662237f, 0.748978f, 
		-0.213355f, 0.00590812f, 0.976957f, -0.364800f, -0.309110f, 0.878278f, 
		-0.0101624f, -0.646956f, 0.762460f, -0.993808f, -0.0901933f, 0.0648841f, 
		-0.858420f, -0.340733f, -0.383426f, -0.980849f, -0.153132f, -0.120360f, 
		-0.652629f, -0.447227f, -0.611607f, -0.373298f, 0.462491f, -0.804208f, 
		-0.373988f, -0.655127f, 0.656462f, 0.789172f, -0.00685710f, -0.614133f, 
		0.939064f, -0.0166194f, -0.343340f, 0.983697f, -0.0147135f, -0.179230f, 
		0.991190f, -0.0229598f, 0.130443f, 0.0166126f, -0.138358f, -0.990243f, 
		-0.131664f, -0.523868f, 0.841562f, 0.0166126f, -0.138358f, -0.990243f, 
		0.0727609f, 0.860683f, -0.503915f, 0.324348f, 0.181756f, -0.928312f, 
		-0.414585f, 0.908296f, -0.0558295f, 0.120780f, 0.676214f, -0.726737f, 
		-0.530290f, 0.842113f, -0.0981797f, -0.713761f, 0.680376f, -0.166233f, 
		0.316823f, -0.947195f, 0.0494484f, 0.259357f, -0.881176f, 0.395301f, 
		0.135527f, -0.459914f, 0.877560f, 0.250650f, -0.751047f, 0.610822f, 
		-0.347832f, 0.670685f, 0.655129f, 0.227898f, 0.743034f, 0.629256f, 
		0.137148f, 0.799388f, 0.584953f, 0.364254f, 0.645682f, 0.671129f, 
		0.449913f, 0.565211f, 0.691458f, 0.307855f, 0.705550f, 0.638299f, 
		0.0581149f, 0.943247f, 0.326966f, -0.370826f, 0.617395f, -0.693767f, 
		-0.376539f, 0.924565f, -0.0582835f, 0.965766f, 0.0847192f, -0.245191f, 
		-0.357281f, 0.763340f, -0.538203f, -0.358818f, -0.783242f, 0.507722f, 
		-0.00937193f, -0.373930f, 0.927409f, -0.0584700f, -0.836613f, 0.544665f, 
		0.987478f, 0.0729183f, 0.139892f, 0.862211f, 0.0367612f, 0.505214f, 
		0.817245f, 0.0265333f, 0.575679f, 0.316178f, -0.0255008f, 0.948357f, 
		0.398525f, -0.230240f, 0.887788f, 0.530519f, -0.506162f, 0.679963f, 
		-0.369145f, 0.173344f, 0.913063f, 0.0434218f, 0.971757f, 0.231957f, 
		-0.244549f, -0.915950f, 0.318169f, -0.420465f, -0.784105f, 0.456495f, 
		-0.520757f, -0.776617f, 0.354512f, -0.608951f, -0.599233f, 0.519711f, 
		-0.706535f, -0.569956f, 0.419474f, -0.617429f, -0.652256f, 0.439709f, 
		-0.353430f, 0.553169f, 0.754382f, 0.346665f, 0.651022f, 0.675273f, 
		-0.180310f, 0.975256f, 0.127921f, 0.299346f, 0.201901f, 0.932538f, 
		-0.828733f, 0.0830078f, -0.553453f, -0.989558f, -0.0404956f, -0.138330f, 
		-0.975126f, -0.00675669f, -0.221547f, -0.0306705f, 0.991661f, -0.125173f, 
		-0.105080f, 0.993292f, -0.0482621f, -0.103221f, 0.983238f, -0.150298f, 
		-0.211340f, 0.976381f, 0.0449025f, -0.0831960f, 0.996481f, 0.0101879f, 
		-0.329659f, 0.872288f, 0.361162f, 0.227480f, -0.234113f, 0.945222f, 
		-0.927794f, -0.289502f, 0.235345f, -0.887088f, 0.324798f, -0.327995f, 
		-0.974187f, 0.197308f, 0.109676f, -0.977828f, 0.195609f, -0.0747588f, 
		-0.697623f, 0.628574f, -0.343827f, -0.615550f, 0.752107f, -0.235441f, 
		-0.866026f, 0.488784f, -0.105307f, -0.323238f, 0.428225f, 0.843884f, 
		-0.764084f, -0.142002f, -0.629294f, 0.503890f, 0.255320f, 0.825171f, 
		0.492955f, 0.332802f, 0.803890f, 0.485820f, 0.410506f, 0.771663f, 
		-0.345107f, -0.876415f, 0.335854f, -0.0573500f, -0.988910f, -0.136996f, 
		0.361350f, -0.254126f, -0.897132f, -0.00418309f, -0.963047f, 0.269299f, 
		-0.639018f, 0.488708f, 0.593987f, 0.498663f, 0.0401757f, -0.865864f, 
		0.544157f, -0.150517f, -0.825371f, 0.386123f, 0.362606f, -0.848190f, 
		0.264177f, 0.618677f, -0.739899f, 0.282629f, -0.379981f, -0.880758f, 
		-0.341568f, -0.646850f, -0.681848f, 0.477794f, -0.235219f, -0.846395f, 
		-0.0319909f, -0.557648f, 0.829461f, 0.987734f, -0.0278921f, 0.153633f, 
		0.780462f, -0.00388984f, -0.625191f, 0.0289710f, -0.839670f, 0.542324f, 
		0.126662f, 0.205234f, 0.970482f, 0.187446f, -0.968567f, -0.163532f, 
		0.323395f, 0.186752f, -0.927653f, -0.740625f, -0.245509f, -0.625460f, 
		0.171338f, -0.975860f, -0.135429f, -0.316758f, 0.779416f, 0.540532f, 
		-0.332569f, 0.920224f, -0.206364f, -0.926563f, 0.300325f, 0.226464f, 
		0.594745f, -0.757419f, 0.269434f, 0.259760f, 0.960908f, -0.0958112f, 
		-0.320858f, -0.887902f, -0.329667f, -0.816855f, 0.0174620f, -0.576579f, 
		-0.186862f, 0.974955f, 0.120602f, -0.308921f, -0.950812f, -0.0229058f, 
		-0.307164f, -0.160358f, 0.938049f, -0.315794f, -0.933106f, 0.172009f, 
		-0.962583f, -0.0839454f, 0.257656f, -0.322767f, -0.294405f, -0.899526f, 
		0.988838f, -0.0368561f, 0.144361f, 0.755575f, -0.00880247f, -0.655003f, 
		0.00323844f, 0.700296f, -0.713845f, 0.967298f, 0.0967315f, -0.234473f, 
		0.985523f, 0.0643843f, 0.156841f, 0.942236f, 0.103514f, -0.318554f, 
		0.00741461f, 0.690975f, -0.722841f, 0.855785f, -0.0869024f, 0.509981f, 
		0.0163605f, -0.293941f, -0.955683f, 0.0163705f, -0.293931f, -0.955687f, 
		0.202275f, 0.417398f, 0.885925f, 0.359289f, 0.167823f, 0.918013f, 
		0.414525f, 0.0561164f, 0.908306f, 0.226400f, -0.879168f, 0.419294f, 
		0.480581f, -0.0164785f, 0.876796f, 0.0991955f, 0.0102223f, 0.995015f, 
		0.517982f, 0.116787f, 0.847381f, 0.687692f, -0.569079f, 0.450809f, 
		0.601223f, -0.771266f, 0.208994f, 0.662809f, -0.296585f, 0.687547f, 
		0.594316f, -0.157402f, 0.788678f, 0.894953f, 0.0292598f, 0.445201f, 
		0.348585f, -0.933776f, -0.0809447f, -0.480800f, -0.0501479f, -0.875395f, 
		0.236191f, -0.927356f, -0.290214f, 0.717386f, -0.516804f, 0.467194f, 
		0.595117f, 0.458912f, 0.659724f, 0.876358f, -0.0350988f, 0.480379f, 
		0.130188f, 0.928057f, 0.348942f, 0.0238882f, 0.134297f, 0.990653f, 
		-0.277024f, -0.458267f, -0.844540f, -0.283193f, 0.295971f, -0.912252f, 
		-0.288742f, 0.0732871f, -0.954598f, 0.320996f, -0.946582f, 0.0307373f, 
		-0.284794f, -0.494160f, 0.821400f, -0.271683f, 0.899594f, -0.341934f, 
		0.854789f, 0.0338521f, 0.517871f, -0.249679f, 0.0142879f, 0.968223f, 
		-0.275715f, 0.329211f, 0.903106f, -0.0235409f, 0.987924f, 0.153142f, 
		-0.0956013f, -0.00800633f, -0.995387f, 0.0554315f, -0.858034f, 0.510593f, 
		-0.174349f, 0.778618f, -0.602791f, 0.00582419f, 0.738538f, -0.674187f, 
		-0.272802f, 0.776477f, -0.568033f, -0.324061f, 0.941477f, 0.0927643f, 
		-0.775547f, 0.542784f, -0.322354f, -0.180311f, 0.975254f, 0.127938f, 
		-0.875641f, 0.177272f, -0.449253f, -0.275471f, 0.201681f, 0.939915f, 
		0.262814f, -0.887276f, -0.379038f, 0.803327f, 0.0803656f, -0.590091f, 
		0.0997650f, 0.0574658f, -0.993350f, -0.251952f, 0.684880f, -0.683710f, 
		-0.302939f, -0.215440f, -0.928339f, 0.437159f, -0.899303f, -0.0120644f, 
		0.162321f, 0.863386f, 0.477720f, 0.00878414f, 0.922695f, 0.385432f, 
		0.507978f, 0.629209f, 0.588263f, 0.634836f, 0.486369f, 0.600357f, 
		-0.457722f, -0.175233f, -0.871656f, 0.665260f, -0.706363f, 0.241827f, 
		-0.373375f, -0.198947f, -0.906096f, -0.264295f, -0.132454f, -0.955303f, 
		-0.257484f, -0.944822f, -0.202518f, -0.429163f, 0.230338f, 0.873363f, 
		-0.731691f, -0.310632f, 0.606743f, -0.990574f, -0.0307206f, 0.133487f, 
		-0.736811f, -0.268337f, -0.620568f, -0.653492f, -0.0609286f, -0.754478f, 
		0.0475785f, -0.424264f, -0.904288f, -0.0854166f, -0.0629519f, 0.994355f, 
		0.359520f, -0.743200f, 0.564269f, -0.251890f, -0.825843f, -0.504515f, 
		-0.629820f, 0.382698f, 0.675921f, -0.258062f, 0.552878f, -0.792294f, 
		-0.828963f, 0.303022f, 0.470105f, -0.774209f, 0.184367f, 0.605483f, 
		-0.748229f, 0.107099f, 0.654739f, 0.0475931f, -0.424254f, -0.904292f, 
		-0.245161f, 0.811283f, -0.530769f, -0.468519f, 0.882781f, 0.0344572f, 
		0.259568f, 0.492048f, -0.830971f, 0.409657f, 0.337656f, -0.847449f, 
		0.141905f, 0.625220f, -0.767439f, 0.0580421f, 0.741989f, -0.667895f, 
		0.283611f, 0.394514f, -0.874027f, 0.0636131f, 0.982952f, 0.172506f, 
		-0.241793f, -0.926902f, 0.287033f, -0.0645781f, -0.952711f, -0.296937f, 
		0.0434365f, -0.955517f, -0.291720f, 0.104797f, -0.955673f, -0.275150f, 
		-0.223557f, -0.736846f, 0.638028f, 0.475597f, -0.738755f, 0.477544f, 
		0.235315f, -0.927223f, -0.291349f, 0.479788f, -0.531402f, 0.698151f, 
		0.467767f, -0.287774f, 0.835691f, 0.400668f, -0.646754f, 0.648979f, 
		0.421778f, -0.414671f, 0.806319f, -0.226458f, -0.713034f, -0.663550f, 
		-0.123643f, -0.0206306f, -0.992112f, 0.0359754f, 0.965515f, 0.257850f, 
		-0.238938f, 0.971032f, 0.00243662f, -0.775549f, -0.116779f, 0.620392f, 
		0.494518f, -0.193848f, -0.847275f, -0.00146219f, -0.826819f, -0.562466f, 
		0.542885f, 0.0697586f, -0.836905f, -0.215018f, -0.372585f, 0.902744f, 
		-0.220034f, 0.957962f, 0.184102f, 0.253586f, -0.959038f, -0.126257f, 
		0.389058f, 0.185567f, -0.902330f, 0.991634f, -0.0541349f, 0.117184f, 
		0.722073f, -0.0235343f, -0.691416f, 0.990888f, 0.0387105f, -0.129006f, 
		0.569469f, -0.217458f, -0.792727f, 0.645123f, -0.00459948f, -0.764065f, 
		0.825916f, 0.0677731f, -0.559705f, 0.991968f, 0.0322721f, 0.122307f, 
		0.217426f, -0.657528f, -0.721376f, -0.236386f, -0.617678f, 0.750063f, 
		0.979464f, 0.0632046f, 0.191457f, 0.801668f, 0.0868129f, -0.591432f, 
		-0.219328f, -0.852060f, 0.475278f, -0.216588f, 0.823315f, 0.524635f, 
		-0.816451f, 0.539141f, -0.206723f, 0.329971f, 0.0563395f, 0.942308f, 
		0.600528f, -0.112442f, 0.791658f, 0.604186f, -0.760227f, 0.238777f, 
		-0.185751f, -0.582020f, 0.791675f, 0.572781f, -0.204636f, 0.793755f, 
		0.176436f, -0.975225f, -0.133443f, 0.0240184f, 0.949115f, -0.314014f, 
		0.0636243f, -0.619254f, -0.782609f, -0.665810f, 0.101155f, -0.739233f, 
		-0.208618f, -0.970840f, 0.118104f, 0.803391f, 0.0998806f, -0.587016f, 
		0.0666034f, 0.0650513f, -0.995657f, 0.0353049f, 0.275792f, 0.960569f, 
		0.437027f, -0.899338f, 0.0140657f, -0.197549f, 0.728045f, 0.656449f, 
		0.500170f, 0.188464f, 0.845169f, -0.184583f, 0.975376f, 0.120711f, 
		-0.993264f, -0.0646164f, 0.0961819f, -0.886980f, 0.0399741f, 0.460074f, 
		-0.839555f, 0.0728386f, 0.538369f, -0.457549f, -0.133769f, 0.879065f, 
		0.334545f, -0.941376f, -0.0434778f, 0.0733086f, -0.994135f, 0.0795097f, 
		0.0625796f, -0.541359f, -0.838459f, -0.189696f, 0.514876f, 0.836013f, 
		0.541131f, -0.00406532f, -0.840928f, 0.479659f, -0.0900354f, -0.872823f, 
		0.530081f, -0.0554188f, 0.846134f, 0.446069f, 0.720117f, -0.531464f, 
		0.395976f, 0.828778f, -0.395386f, 0.00496855f, 0.998623f, 0.0522209f, 
		0.228195f, 0.959929f, -0.162676f, 0.569729f, 0.0697111f, 0.818870f, 
		-0.181377f, 0.443277f, -0.877843f, -0.526375f, 0.178317f, -0.831344f, 
		-0.647277f, 0.269317f, -0.713093f, -0.788092f, 0.534423f, -0.305456f, 
		-0.752331f, 0.643311f, -0.141949f, -0.0807355f, -0.905739f, -0.416076f, 
		-0.178202f, 0.195553f, -0.964366f, -0.150036f, 0.906840f, 0.393866f, 
		-0.157014f, 0.627125f, 0.762929f, 0.0175237f, 0.942774f, 0.332973f, 
		0.704529f, 0.498011f, 0.505593f, -0.181023f, -0.318477f, -0.930485f, 
		0.845714f, 0.0316970f, 0.532694f, -0.185368f, -0.576926f, -0.795484f, 
		-0.149728f, -0.921202f, 0.359122f, -0.774328f, -0.221364f, -0.592802f, 
		-0.982885f, -0.0196742f, 0.183168f, -0.595327f, 0.170524f, -0.785180f, 
		-0.616119f, 0.500924f, 0.607843f, -0.139302f, -0.521159f, 0.842015f, 
		-0.331592f, 0.595860f, -0.731436f, -0.636743f, 0.365636f, -0.678873f, 
		-0.534689f, 0.453963f, -0.712759f, -0.00252410f, -0.777717f, -0.628609f, 
		0.0884668f, -0.945252f, 0.314121f, 0.762948f, -0.531025f, 0.368678f, 
		0.651641f, 0.501684f, 0.568926f, -0.130545f, -0.885730f, 0.445467f, 
		0.272875f, -0.869200f, -0.412348f, -0.665311f, -0.251052f, -0.703089f, 
		-0.426763f, -0.638031f, -0.640929f, -0.635734f, -0.336217f, -0.694838f, 
		-0.481100f, 0.243768f, 0.842093f, -0.230441f, 0.672324f, 0.703475f, 
		-0.210510f, 0.972679f, -0.0978851f, -0.0552582f, -0.234782f, -0.970476f, 
		-0.171379f, 0.973764f, -0.149710f, -0.400986f, -0.593236f, 0.698056f, 
		-0.129047f, 0.157051f, 0.979123f, -0.233595f, 0.437621f, 0.868286f, 
		-0.221574f, 0.343328f, 0.912705f, -0.258262f, 0.772987f, 0.579476f, 
		-0.425855f, -0.607281f, -0.670714f, 0.235175f, -0.927154f, -0.291682f, 
		-0.142835f, 0.00968211f, -0.989699f, -0.337785f, -0.155054f, 0.928364f, 
		0.0283614f, -0.935163f, 0.353081f, 0.533164f, -0.0548904f, -0.844229f, 
		-0.117827f, 0.335471f, 0.934653f, -0.113077f, -0.972165f, 0.205203f, 
		0.0503234f, 0.923317f, -0.380727f, 0.0255026f, 0.405483f, -0.913747f, 
		-0.167956f, 0.983192f, -0.0715780f, -0.117355f, 0.873827f, -0.471862f, 
		-0.824778f, -0.205099f, -0.526948f, -0.131565f, -0.117491f, 0.984320f, 
		0.144171f, 0.396313f, -0.906725f, 0.838248f, 0.0130828f, 0.545133f, 
		-0.130223f, 0.602855f, -0.787152f, -0.905226f, 0.0338584f, 0.423579f, 
		-0.865758f, 0.0516761f, 0.497788f, -0.614130f, 0.129719f, 0.778471f, 
		0.594084f, -0.783641f, 0.181578f, -0.121766f, -0.920212f, -0.371999f, 
		0.505353f, -0.177758f, 0.844405f, 0.799330f, 0.178809f, -0.573672f, 
		0.00309842f, 0.124048f, -0.992271f, -0.101561f, -0.994752f, 0.0124438f, 
		-0.161833f, 0.157355f, 0.974192f, -0.800201f, -0.210703f, -0.561500f, 
		-0.962472f, 0.00819389f, 0.271256f, -0.819139f, -0.259249f, -0.511665f, 
		0.179141f, -0.975504f, -0.127672f, -0.116644f, 0.760665f, -0.638578f, 
		-0.878526f, 0.0745768f, -0.471838f, -0.181331f, 0.975105f, 0.127632f, 
		-0.869413f, 0.0241584f, -0.493496f, -0.141985f, 0.986503f, 0.0815613f, 
		-0.0860409f, 0.955009f, -0.283822f, -0.300156f, -0.177779f, 0.937177f, 
		0.0708774f, 0.979209f, -0.190069f, 0.973350f, 0.0489081f, 0.224048f, 
		0.802829f, 0.0896090f, -0.589436f, -0.105719f, -0.842305f, -0.528532f, 
		-0.0767262f, -0.801762f, 0.592698f, 0.0515803f, 0.974464f, 0.218539f, 
		0.791547f, 0.528727f, 0.306434f, 0.657585f, -0.114934f, -0.744562f, 
		0.517054f, -0.196678f, -0.833050f, 0.314946f, -0.534669f, -0.784180f, 
		0.236038f, -0.895082f, -0.378304f, 0.239532f, -0.798973f, -0.551603f, 
		-0.0858585f, 0.996134f, 0.0185702f, -0.102452f, 0.314592f, 0.943682f, 
		-0.0820619f, -0.913370f, -0.398775f, -0.521639f, -0.265479f, 0.810810f, 
		0.533361f, -0.0695129f, -0.843027f, -0.186989f, -0.0998397f, 0.977275f, 
		-0.0874456f, -0.212771f, 0.973181f, -0.0988546f, -0.981238f, -0.165528f, 
		0.566112f, 0.814914f, 0.124229f, 0.106787f, 0.399739f, 0.910388f, 
		-0.0562025f, -0.405544f, 0.912346f, -0.0709820f, -0.436559f, -0.896871f, 
		-0.0912813f, -0.666875f, -0.739557f, -0.0648842f, -0.191525f, -0.979341f, 
		0.874548f, 0.0674241f, 0.480229f, 0.768713f, -0.497020f, 0.402557f, 
		-0.0742537f, 0.810385f, 0.581173f, -0.0628990f, 0.151070f, -0.986520f, 
		0.116383f, -0.376500f, -0.919077f, -0.225828f, -0.943008f, 0.244414f, 
		0.0745566f, 0.976517f, -0.202127f, 0.358048f, -0.862746f, -0.357030f, 
		-0.0490049f, 0.00150512f, 0.998797f, -0.124644f, -0.402235f, 0.907012f, 
		-0.147501f, -0.744492f, 0.651134f, -0.151559f, -0.889005f, 0.432088f, 
		-0.0415253f, -0.765248f, -0.642395f, 0.179539f, -0.738760f, -0.649614f, 
		-0.618738f, 0.230308f, 0.751080f, 0.243917f, -0.762792f, -0.598876f, 
		-0.623683f, -0.119347f, -0.772513f, 0.759056f, -0.588765f, 0.277829f, 
		0.540195f, 0.191808f, -0.819390f, 0.326811f, -0.943219f, -0.0594430f, 
		0.820403f, -0.467862f, 0.328701f, 0.711413f, 0.502455f, 0.491356f, 
		-0.0359900f, -0.903359f, 0.427372f, -0.653003f, 0.754667f, -0.0637523f, 
		-0.779999f, 0.497858f, -0.379129f, -0.794094f, 0.291781f, -0.533178f, 
		-0.767177f, 0.317536f, -0.557324f, -0.0718411f, 0.332437f, -0.940385f, 
		0.0163475f, 0.947881f, -0.318204f, 0.525563f, 0.471224f, -0.708330f, 
		-0.0456852f, 0.977263f, 0.207049f, -0.0690603f, -0.308567f, 0.948692f, 
		-0.945582f, 0.00691365f, 0.325312f, -0.832969f, -0.196253f, -0.517347f, 
		0.542753f, 0.000660670f, 0.839892f, 0.178621f, 0.567731f, 0.803602f, 
		0.424502f, 0.214388f, 0.879679f, 0.00865370f, 0.348143f, 0.937402f, 
		-0.561729f, -0.0920572f, 0.822183f, 0.541359f, -0.112475f, -0.833234f, 
		-0.0343815f, -0.670112f, 0.741463f, -0.601820f, -0.109999f, -0.791021f, 
		-0.212543f, -0.767847f, -0.604348f, -0.0524590f, -0.822042f, -0.567006f, 
		-0.142613f, -0.797342f, -0.586436f, -0.586231f, 0.501928f, 0.635926f, 
		-0.0141906f, -0.403707f, -0.914778f, -0.0204376f, 0.707380f, 0.706538f, 
		-0.329346f, -0.155203f, 0.931366f, 0.00392158f, -0.943956f, 0.330048f, 
		0.478595f, 0.333761f, 0.812127f, 0.963930f, 0.0384163f, 0.263369f, 
		0.803249f, 0.0853747f, -0.589494f, 0.449051f, 0.893192f, -0.0236870f, 
		0.289215f, 0.951597f, -0.104008f, 0.718081f, 0.687727f, -0.106728f, 
		0.389157f, -0.921066f, -0.0139778f, 0.670567f, -0.728883f, 0.138091f, 
		0.723599f, -0.668733f, 0.170881f, -0.521707f, 0.242685f, 0.817879f, 
		-0.975810f, -0.0200293f, 0.217699f, -0.834708f, 0.0655840f, 0.546773f, 
		-0.782422f, 0.0890470f, 0.616350f, -0.0116509f, -0.360176f, 0.932811f, 
		0.197153f, 0.909926f, -0.364919f, -0.00647927f, 0.875686f, 0.482838f, 
		-0.840958f, 0.0796948f, -0.535199f, 0.463464f, 0.687875f, 0.558596f, 
		-0.180325f, 0.975251f, 0.127935f, -0.884536f, 0.372937f, -0.280206f, 
		0.473523f, 0.0997513f, 0.875115f, 0.773323f, 0.318731f, -0.548072f, 
		-0.0371646f, 0.296205f, -0.954401f, 0.649402f, 0.382461f, 0.657267f, 
		0.490903f, -0.189878f, 0.850271f, 0.0930227f, -0.747939f, 0.657217f, 
		0.489423f, -0.0339580f, 0.871385f, 0.317324f, -0.547907f, 0.774018f, 
		-0.124430f, -0.0114239f, 0.992163f, -0.408331f, -0.565398f, -0.716653f, 
		-0.489069f, -0.586108f, -0.645979f, -0.198489f, -0.575884f, -0.793070f, 
		-0.327064f, -0.583370f, -0.743444f, -0.387157f, -0.608471f, -0.692729f, 
		-0.189394f, -0.592115f, -0.783282f, 0.635390f, -0.669597f, 0.384603f, 
		0.235227f, -0.927211f, -0.291457f, 0.173350f, -0.876489f, -0.449128f, 
		-0.148163f, -0.563365f, 0.812815f, -0.165309f, 0.0154649f, -0.986121f, 
		-0.131529f, -0.704494f, 0.697416f, 0.0583969f, -0.666841f, 0.742909f, 
		-0.0198008f, -0.704615f, 0.709313f, 0.0378758f, 0.0698423f, 0.996839f, 
		-0.939733f, -0.0607205f, 0.336474f, -0.844434f, -0.162227f, -0.510503f, 
		0.651555f, -0.697484f, 0.298315f, 0.332487f, -0.148054f, 0.931414f, 
		0.591809f, -0.575615f, 0.564296f, 0.633603f, -0.335184f, 0.697280f, 
		0.678102f, -0.202251f, 0.706592f, 0.674970f, -0.451854f, 0.583304f, 
		-0.822309f, 0.264213f, -0.503983f, -0.00486368f, 0.233815f, 0.972269f, 
		0.785309f, 0.248155f, 0.567194f, 0.0404855f, -0.500192f, 0.864967f, 
		-0.575867f, -0.367938f, -0.730068f, -0.476069f, -0.426720f, -0.768940f, 
		-0.391701f, -0.460740f, -0.796423f, 0.0163656f, -0.964955f, 0.261905f, 
		0.556668f, -0.166489f, -0.813881f, -0.0688110f, -0.0470205f, 0.996521f, 
		-0.00211949f, 0.527075f, -0.849816f, 0.177969f, -0.970963f, 0.159869f, 
		0.00448101f, -0.434473f, 0.900674f, -0.260228f, -0.953588f, -0.151498f, 
		-0.843936f, -0.00774837f, -0.536387f, 0.0197993f, 0.497715f, 0.867115f, 
		0.0257180f, 0.703038f, -0.710687f, -0.523153f, -0.174391f, -0.834206f, 
		0.00612183f, -0.995728f, -0.0921280f, 0.143922f, 0.318735f, -0.936854f, 
		0.414218f, -0.133327f, 0.900359f, -0.0163345f, 0.0170188f, 0.999722f, 
		-0.00421011f, 0.169712f, 0.985485f, 0.0353042f, 0.937819f, 0.345324f, 
		0.477524f, -0.0335280f, 0.877979f, -0.403713f, 0.391616f, 0.826833f, 
		0.0253305f, -0.860800f, -0.508313f, 0.0346899f, -0.537632f, 0.842466f, 
		-0.742485f, 0.101331f, -0.662154f, 0.0134409f, -0.626354f, -0.779423f, 
		0.0433168f, 0.0129528f, -0.998977f, 0.0818718f, -0.510134f, 0.856189f, 
		0.143922f, 0.318735f, -0.936854f, 0.0379819f, 0.961203f, -0.273216f, 
		0.0857614f, -0.305408f, 0.948352f, 0.0393561f, -0.994850f, 0.0934023f, 
		-0.0937978f, -0.116599f, 0.988740f, -0.862224f, -0.0504465f, -0.504008f, 
		-0.426280f, -0.695202f, -0.578774f, -0.150261f, 0.180894f, -0.971956f, 
		0.0402894f, 0.912385f, -0.407345f, 0.202038f, -0.935812f, -0.288856f, 
		0.388076f, -0.863355f, -0.322515f, 0.0540229f, 0.359559f, 0.931557f, 
		0.0583696f, -0.872519f, 0.485082f, 0.191283f, -0.290745f, 0.937485f, 
		0.899744f, -0.375752f, 0.221973f, 0.760984f, 0.516477f, 0.392626f, 
		0.0452267f, 0.827956f, -0.558967f, 0.0637356f, -0.780012f, 0.622510f, 
		0.0566286f, 0.797700f, 0.600390f, -0.0499910f, -0.877656f, -0.476677f, 
		-0.445933f, -0.678595f, -0.583654f, 0.0288118f, -0.895891f, -0.443338f, 
		0.0548815f, -0.992820f, -0.106283f, 0.0540740f, 0.997228f, 0.0511124f, 
		-0.799846f, 0.0712824f, 0.595957f, 0.0708256f, 0.222616f, -0.972330f, 
		-0.401103f, -0.320936f, -0.857972f, -0.551861f, -0.287975f, -0.782637f, 
		-0.476545f, -0.307206f, -0.823729f, -0.937605f, -0.0739438f, 0.339748f, 
		-0.845409f, -0.131421f, -0.517698f, 0.0515685f, 0.988446f, -0.142535f, 
		0.0646118f, -0.945355f, -0.319576f, -0.854542f, -0.193900f, -0.481831f, 
		0.949539f, 0.0996472f, 0.297399f, 0.798219f, 0.179390f, -0.575036f, 
		0.0148525f, -0.729957f, 0.683332f, -0.154649f, -0.628927f, 0.761928f, 
		-0.0720294f, -0.690091f, 0.720129f, 0.505812f, -0.241055f, -0.828279f, 
		-0.0344857f, -0.897764f, -0.439124f, 0.0871893f, -0.325558f, -0.941493f, 
		0.574753f, -0.190526f, -0.795838f, -0.296347f, 0.896416f, -0.329572f, 
		-0.329463f, -0.147972f, 0.932501f, -0.0333823f, -0.943089f, 0.330861f, 
		0.725821f, -0.520066f, 0.450238f, 0.158982f, -0.757980f, -0.632606f, 
		0.709562f, -0.637775f, 0.299608f, -0.888969f, 0.00269399f, -0.457960f, 
		0.0982939f, 0.411919f, -0.905903f, 0.0922098f, -0.139885f, 0.985865f, 
		0.306467f, -0.138454f, 0.941758f, 0.497747f, -0.111612f, 0.860111f, 
		0.0835432f, 0.624397f, 0.776626f, -0.110417f, 0.0466358f, 0.992791f, 
		0.701592f, 0.171717f, -0.691579f, 0.353162f, -0.935094f, -0.0296116f, 
		0.919338f, -0.348690f, 0.182300f, -0.0588708f, 0.880626f, -0.470141f, 
		0.0735163f, 0.0201414f, 0.997091f, 0.100694f, -0.139986f, 0.985020f, 
		-0.494303f, 0.538395f, 0.682491f, -0.233622f, -0.290754f, 0.927838f, 
		-0.278740f, -0.896397f, 0.344638f, 0.258945f, 0.919522f, 0.295680f, 
		0.172399f, -0.807441f, -0.564197f, -0.687443f, 0.0106419f, -0.726161f, 
		0.111250f, 0.225418f, 0.967890f, -0.357188f, 0.148898f, 0.922088f, 
		0.0274956f, 0.142528f, 0.989409f, -0.544364f, 0.155250f, 0.824358f, 
		0.155539f, 0.128410f, 0.979448f, -0.921461f, 0.343783f, -0.180891f, 
		0.360314f, -0.000376972f, 0.932831f, -0.0231499f, 0.120926f, 0.992392f, 
		-0.787736f, -0.00253660f, 0.616008f, 0.421557f, 0.670450f, 0.610563f, 
		0.370705f, 0.634484f, 0.678239f, 0.191166f, 0.555547f, 0.809211f, 
		0.283256f, 0.568440f, 0.772426f, 0.315740f, 0.620763f, 0.717608f, 
		0.666101f, 0.0674925f, -0.742802f, -0.860875f, 0.266203f, -0.433624f, 
		0.128887f, 0.772715f, -0.621530f, -0.452350f, -0.277038f, -0.847720f, 
		-0.592529f, -0.253072f, -0.764764f, -0.523566f, -0.265990f, -0.809399f, 
		0.115493f, -0.421333f, 0.899522f, 0.207817f, -0.786720f, -0.581278f, 
		0.245615f, 0.528140f, -0.812860f, -0.895262f, 0.111005f, -0.431491f, 
		0.679912f, 0.239888f, 0.692945f, -0.183164f, 0.975128f, 0.124805f, 
		0.178615f, 0.691051f, -0.700389f, -0.801943f, 0.519208f, -0.295483f, 
		-0.180330f, 0.975253f, 0.127919f, 0.749659f, 0.606937f, -0.263890f, 
		0.607434f, 0.566629f, -0.556736f, 0.950307f, -0.267395f, 0.159428f, 
		0.759678f, 0.650299f, 0.000592237f, 0.768122f, -0.0578706f, 0.637683f, 
		0.751949f, -0.149985f, 0.641932f, 0.177572f, -0.975451f, -0.130246f, 
		0.107970f, -0.131375f, -0.985435f, 0.127181f, -0.532388f, -0.836892f, 
		0.450553f, -0.770929f, 0.450190f, -0.0837912f, 0.752026f, 0.653785f, 
		0.217461f, -0.893587f, 0.392700f, 0.667757f, -0.347594f, 0.658239f, 
		0.670925f, -0.231850f, 0.704347f, -0.213916f, -0.587041f, 0.780784f, 
		0.133797f, -0.627657f, 0.766906f, 0.125240f, 0.977976f, 0.166965f, 
		0.607732f, -0.186600f, -0.771908f, 0.649245f, -0.0488650f, -0.759008f, 
		-0.0656608f, 0.476642f, 0.876642f, -0.390780f, 0.910609f, -0.134468f, 
		-0.207985f, 0.288892f, -0.934496f, -0.316389f, 0.943187f, -0.101466f, 
		0.735115f, 0.133647f, 0.664639f, -0.156083f, 0.325271f, -0.932651f, 
		-0.0464682f, 0.368778f, -0.928355f, 0.313042f, 0.376254f, -0.872031f, 
		-0.581349f, 0.376035f, 0.721548f, -0.0926085f, 0.625938f, -0.774355f, 
		0.221307f, 0.576585f, -0.786494f, 0.329289f, 0.562756f, -0.758205f, 
		0.134702f, 0.762165f, -0.633214f, -0.724750f, 0.674398f, -0.141155f, 
		-0.00339574f, 0.945786f, 0.324774f, -0.468902f, -0.280046f, -0.837678f, 
		-0.545839f, -0.268872f, -0.793579f, -0.821004f, -0.201459f, -0.534198f, 
		0.229880f, -0.953118f, 0.196778f, 0.574253f, 0.206804f, -0.792127f, 
		0.626840f, 0.0885926f, -0.774095f, 0.365143f, 0.489340f, -0.791970f, 
		0.284113f, 0.599826f, -0.747990f, 0.467756f, 0.343276f, -0.814473f, 
		-0.793069f, 0.174149f, -0.583706f, 0.652168f, 0.249730f, 0.715760f, 
		0.131777f, 0.901041f, 0.413231f, -0.751309f, 0.194785f, -0.630551f, 
		-0.421148f, 0.906944f, 0.00935726f, -0.0556257f, 0.485804f, 0.872296f, 
		-0.00810204f, 0.412966f, 0.910711f, 0.0283131f, 0.335912f, 0.941468f, 
		0.658890f, -0.0159768f, -0.752069f, 0.146667f, -0.780198f, -0.608096f, 
		0.194725f, -0.862280f, 0.467498f, 0.298012f, -0.934511f, 0.194624f, 
		0.373854f, -0.927375f, -0.0144641f, 0.336455f, -0.891316f, -0.303899f, 
		0.670962f, -0.728153f, 0.140011f, 0.669861f, -0.630231f, 0.392549f, 
		0.655741f, -0.712894f, 0.248566f, 0.176136f, 0.0744590f, -0.981546f, 
		-0.693632f, 0.261142f, 0.671327f, -0.803062f, 0.212657f, 0.556658f, 
		-0.0231499f, 0.120926f, 0.992392f, -0.207016f, 0.234848f, 0.949732f, 
		0.295676f, -0.210626f, -0.931779f, 0.148793f, -0.866033f, -0.477334f, 
		-0.280705f, 0.417960f, 0.864011f, -0.437542f, 0.178902f, 0.881221f, 
		-0.387768f, 0.273471f, 0.880255f, 0.151823f, 0.936555f, -0.315934f, 
		0.690626f, -0.634863f, 0.346388f, -0.911707f, 0.306882f, -0.273153f, 
		-0.275563f, -0.0879958f, 0.957247f, 0.148536f, -0.722520f, 0.675205f, 
		-0.520243f, -0.126893f, 0.844539f, 0.158559f, 0.867366f, 0.471736f, 
		-0.782733f, -0.0417811f, 0.620954f, 0.159205f, 0.743545f, 0.649457f, 
		-0.220519f, -0.303338f, -0.927015f, -0.482008f, -0.866946f, 0.126778f, 
		-0.269770f, 0.172243f, 0.947395f, -0.426316f, 0.155881f, 0.891042f, 
		-0.348348f, 0.163896f, 0.922925f, -0.148677f, 0.118481f, 0.981762f, 
		0.174980f, 0.145226f, -0.973803f, -0.150664f, 0.356367f, -0.922119f, 
		0.159320f, -0.676761f, -0.718757f, -0.577215f, 0.787505f, -0.216007f, 
		-0.213258f, -0.265809f, -0.940142f, -0.643684f, -0.224623f, -0.731584f, 
		-0.573073f, -0.241873f, -0.782997f, 0.0489744f, -0.204773f, 0.977583f, 
		-0.397263f, -0.894898f, 0.203319f, 0.176149f, 0.0744580f, -0.981544f, 
		0.122677f, 0.126409f, 0.984363f, -0.911085f, -0.395663f, -0.115647f, 
		0.117502f, -0.839769f, 0.530076f, -0.118389f, -0.802283f, 0.585086f, 
		-0.266536f, -0.735142f, 0.623318f, 0.202795f, -0.101636f, -0.973932f, 
		-0.627201f, 0.678974f, -0.381593f, 0.203870f, -0.978986f, -0.00487129f, 
		0.188715f, 0.981949f, -0.0127449f, 0.682874f, -0.680605f, 0.265444f, 
		0.135661f, -0.827480f, -0.544861f, -0.839752f, 0.157929f, -0.519495f, 
		-0.648370f, 0.0113618f, -0.761240f, 0.0995234f, -0.992045f, -0.0770880f, 
		0.0129952f, -0.872593f, 0.488275f, 0.491266f, 0.104783f, 0.864684f, 
		0.921636f, 0.222939f, 0.317625f, 0.751721f, 0.392448f, -0.530000f, 
		0.194235f, 0.733623f, -0.651207f, -0.311075f, 0.174347f, 0.934257f, 
		0.184852f, -0.929467f, 0.319249f, 0.189418f, 0.938553f, 0.288512f, 
		0.186234f, 0.586012f, -0.788610f, -0.0782331f, 0.0747744f, 0.994127f, 
		-0.572731f, 0.0608280f, 0.817484f, 0.0676381f, 0.116035f, 0.990939f, 
		-0.193590f, 0.0905996f, 0.976890f, -0.431567f, 0.0547230f, 0.900420f, 
		-0.588535f, -0.120954f, 0.799373f, -0.472612f, -0.843478f, 0.255309f, 
		0.203900f, 0.846256f, -0.492216f, 0.187340f, 0.373943f, 0.908334f, 
		-0.948245f, 0.102730f, 0.300462f, -0.966590f, 0.218136f, 0.134611f, 
		-0.960852f, 0.169464f, 0.219192f, 0.129447f, -0.982844f, 0.131382f, 
		0.627127f, 0.0149854f, 0.778773f, 0.158468f, -0.149910f, 0.975918f, 
		0.395760f, -0.0124761f, 0.918269f, 0.217115f, -0.720459f, -0.658635f, 
		-0.937099f, -0.0534106f, 0.344953f, -0.848407f, -0.123329f, -0.514778f, 
		0.202808f, -0.101637f, -0.973930f, 0.535752f, 0.303114f, 0.788094f, 
		0.646666f, 0.203822f, 0.735037f, 0.679771f, 0.105767f, 0.725758f, 
		0.209676f, -0.829519f, 0.517624f, 0.681001f, -0.208221f, -0.702056f, 
		0.0403650f, -0.905028f, -0.423432f, 0.655424f, -0.0616059f, -0.752745f, 
		-0.730474f, -0.176973f, -0.659612f, -0.576710f, -0.179251f, -0.797041f, 
		-0.220629f, -0.182788f, -0.958077f, -0.911085f, -0.395663f, -0.115647f, 
		0.612998f, -0.705424f, 0.355823f, 0.595908f, -0.594398f, 0.539987f, 
		0.507047f, -0.347978f, 0.788552f, 0.360821f, -0.216068f, 0.907261f, 
		-0.926486f, 0.340359f, 0.160558f, 0.218140f, -0.902809f, -0.370608f, 
		0.626326f, -0.130001f, -0.768645f, -0.481063f, -0.0210056f, 0.876434f, 
		-0.0950459f, -0.249602f, 0.963673f, -0.517638f, -0.0522592f, 0.854002f, 
		-0.264171f, -0.230527f, 0.936521f, -0.323293f, -0.119242f, 0.938756f, 
		-0.193472f, -0.120294f, 0.973703f, 0.212419f, -0.203589f, -0.955735f, 
		-0.428830f, -0.105289f, -0.897228f, -0.0747965f, -0.915888f, 0.394404f, 
		0.258738f, -0.599645f, -0.757285f, 0.233212f, -0.297805f, -0.925702f, 
		0.220220f, -0.955311f, -0.197191f, 0.223681f, 0.0289388f, 0.974233f, 
		-0.439194f, 0.878057f, 0.190066f, 0.231648f, -0.522560f, 0.820531f, 
		-0.306748f, -0.227093f, -0.924302f, 0.232675f, -0.344785f, -0.909388f, 
		0.191636f, 0.169260f, 0.966761f, 0.309899f, 0.0723567f, -0.948012f, 
		0.772137f, 0.320697f, -0.548596f, 0.00475953f, 0.152777f, -0.988249f, 
		0.249114f, -0.405825f, -0.879345f, 0.215540f, -0.961862f, 0.168417f, 
		0.0805876f, -0.591222f, 0.802473f, -0.748988f, -0.307536f, 0.586888f, 
		-0.898705f, 0.0955955f, 0.428008f, -0.939592f, -0.257280f, 0.225774f, 
		-0.536140f, -0.385762f, 0.750827f, 0.245896f, 0.513444f, 0.822138f, 
		0.181705f, -0.193138f, 0.964200f, 0.146901f, -0.867320f, -0.475580f, 
		0.799555f, 0.0239162f, -0.600117f, 0.0544439f, 0.00898325f, -0.998476f, 
		0.250327f, -0.457665f, -0.853158f, 0.297057f, -0.174993f, 0.938688f, 
		-0.696647f, 0.104906f, -0.709702f, -0.232829f, 0.160247f, 0.959224f, 
		0.226528f, 0.468151f, -0.854119f, 0.109326f, -0.971026f, 0.212499f, 
		-0.275468f, -0.949993f, 0.147073f, -0.0771053f, -0.978437f, 0.191615f, 
		0.0438113f, -0.988693f, 0.143413f, -0.139879f, -0.983192f, 0.117333f, 
		0.576094f, 0.669433f, 0.469014f, -0.180343f, 0.975251f, 0.127914f, 
		0.252279f, -0.169544f, 0.952686f, 0.195355f, -0.888308f, -0.415627f, 
		-0.703993f, 0.0440969f, -0.708836f, 0.288477f, -0.957481f, -0.00320072f, 
		0.262796f, -0.519476f, -0.813070f, 0.233212f, -0.297805f, -0.925702f, 
		0.497451f, 0.493982f, 0.713109f, 0.522233f, 0.768886f, 0.368899f, 
		0.481700f, 0.243206f, 0.841912f, 0.740271f, 0.418745f, 0.525977f, 
		0.264528f, 0.936982f, 0.228231f, -0.853993f, -0.211120f, -0.475525f, 
		0.342754f, 0.132231f, -0.930072f, -0.895718f, 0.0687837f, -0.439269f, 
		0.298586f, 0.336316f, -0.893162f, -0.181835f, 0.974657f, 0.130306f, 
		0.262763f, 0.327879f, -0.907442f, -0.894767f, 0.0108653f, -0.446401f, 
		0.322951f, 0.237059f, -0.916246f, 0.249124f, -0.405816f, -0.879347f, 
		-0.360703f, 0.161394f, 0.918611f, -0.201000f, 0.183776f, 0.962198f, 
		-0.279369f, 0.173720f, 0.944338f, 0.404288f, -0.531039f, -0.744681f, 
		0.271084f, -0.683377f, 0.677871f, 0.254468f, 0.948103f, -0.190651f, 
		0.658504f, -0.0694431f, -0.749367f, -0.870230f, 0.118206f, -0.478255f, 
		0.311368f, 0.211650f, -0.926420f, -0.429277f, -0.879152f, -0.206914f, 
		-0.897953f, -0.0164730f, -0.439783f, -0.833640f, -0.267418f, -0.483251f, 
		0.356368f, 0.0233927f, -0.934053f, 0.178525f, -0.975986f, -0.124822f, 
		-0.649625f, -0.124752f, -0.749949f, -0.231908f, -0.0932980f, -0.968253f, 
		-0.583533f, -0.120728f, -0.803065f, -0.838155f, -0.364585f, 0.405677f, 
		-0.741438f, -0.639188f, 0.204224f, -0.856392f, -0.275606f, 0.436617f, 
		0.113102f, 0.00213318f, 0.993581f, 0.114371f, -0.0707085f, 0.990919f, 
		-0.0470935f, -0.0120534f, 0.998818f, 0.0283201f, -0.0358232f, 0.998957f, 
		-0.0467851f, -0.0627468f, 0.996932f, 0.288275f, -0.797876f, -0.529425f, 
		-0.0903226f, -0.995175f, -0.0383281f, -0.289042f, -0.613774f, 0.734667f, 
		0.0604299f, -0.174031f, 0.982884f, -0.244210f, -0.496150f, 0.833184f, 
		0.186951f, -0.322127f, 0.928054f, 0.277135f, -0.0342357f, -0.960221f, 
		0.286627f, 0.201009f, 0.936718f, 0.211282f, 0.210485f, 0.954493f, 
		-0.831343f, 0.551278f, -0.0704337f, -0.358107f, -0.130728f, -0.924483f, 
		-0.730574f, -0.682048f, 0.0327522f, 0.299953f, 0.945108f, 0.129613f, 
		0.256361f, -0.136045f, 0.956959f, -0.655865f, -0.748809f, 0.0955348f, 
		0.800300f, 0.206741f, 0.562830f, 0.219017f, -0.833944f, 0.506526f, 
		-0.657232f, -0.691410f, 0.299995f, 0.484791f, 0.812805f, 0.322995f, 
		0.0314021f, -0.565897f, 0.823878f, 0.187583f, -0.257672f, 0.947849f, 
		0.529762f, -0.812118f, -0.244575f, 0.308418f, 0.666868f, 0.678355f, 
		0.283937f, -0.690585f, -0.665186f, 0.757322f, -0.599673f, 0.258565f, 
		0.244741f, -0.919669f, -0.307101f, 0.424914f, -0.632530f, 0.647575f, 
		0.355737f, -0.590448f, 0.724447f, 0.479669f, -0.807906f, 0.342352f, 
		-0.394869f, 0.0574151f, -0.916942f, -0.591191f, 0.794366f, -0.139554f, 
		0.289249f, 0.889723f, -0.353168f, 0.113465f, -0.993542f, 0.000896382f, 
		-0.781940f, -0.0197794f, 0.623040f, 0.804946f, -0.314741f, 0.502991f, 
		0.306606f, -0.310951f, 0.899612f, 0.154832f, 0.982176f, -0.106570f, 
		0.174786f, 0.301468f, 0.937319f, -0.740734f, 0.645042f, -0.187709f, 
		-0.641242f, 0.765414f, -0.0543073f, -0.793374f, 0.537206f, -0.286300f, 
		-0.231005f, 0.175109f, 0.957065f, 0.323653f, 0.887807f, 0.327181f, 
		-0.935779f, -0.0404929f, 0.350253f, -0.851770f, -0.117167f, -0.510646f, 
		0.318848f, 0.794794f, 0.516371f, 0.659563f, -0.105703f, -0.744180f, 
		0.315444f, 0.159055f, -0.935520f, -0.358200f, -0.0107953f, -0.933583f, 
		0.390868f, 0.813258f, 0.431084f, 0.341228f, 0.329893f, 0.880190f, 
		0.335512f, 0.00627684f, 0.942015f, 0.342114f, -0.785578f, 0.515582f, 
		0.325694f, -0.239288f, -0.914694f, 0.278888f, -0.857282f, -0.432769f, 
		-0.214143f, -0.586452f, 0.781164f, 0.303293f, -0.571080f, -0.762811f, 
		0.224133f, 0.313762f, 0.922669f, -0.962899f, 0.240771f, 0.121884f, 
		0.547281f, -0.287331f, 0.786082f, 0.715660f, -0.419600f, 0.558360f, 
		0.460888f, -0.250656f, 0.851325f, -0.960540f, -0.110340f, 0.255319f, 
		-0.217753f, 0.0955915f, 0.971312f, 0.346651f, -0.873805f, -0.341024f, 
		-0.310097f, 0.180794f, 0.933356f, 0.358315f, 0.931740f, -0.0589186f, 
		0.123828f, -0.141198f, 0.982207f, -0.878548f, -0.0746694f, -0.471781f, 
		0.334824f, 0.182469f, -0.924445f, -0.0917544f, -0.860158f, -0.501706f, 
		0.372465f, 0.183075f, 0.909809f, 0.509644f, -0.148139f, -0.847536f, 
		0.352947f, 0.469374f, -0.809393f, 0.376173f, -0.925784f, 0.0376513f, 
		0.370921f, -0.858279f, 0.354648f, 0.785417f, 0.275329f, 0.554359f, 
		-0.181778f, 0.974869f, 0.128790f, 0.362304f, 0.724225f, -0.586715f, 
		0.129050f, -0.0367546f, 0.990957f, 0.460479f, -0.856049f, 0.234816f, 
		0.761946f, 0.0272698f, 0.647066f, 0.378481f, -0.353570f, -0.855418f, 
		-0.328570f, 0.147118f, -0.932951f, 0.311797f, 0.134109f, 0.940637f, 
		-0.799803f, -0.599914f, 0.0204511f, -0.860784f, 0.453487f, -0.231084f, 
		0.385469f, 0.242871f, -0.890184f, 0.379622f, 0.817456f, -0.433188f, 
		0.361946f, -0.458494f, 0.811652f, 0.153665f, -0.287065f, 0.945506f, 
		-0.384681f, -0.133045f, -0.913411f, -0.426989f, -0.0953163f, -0.899219f, 
		-0.795382f, -0.605798f, -0.0193836f, -0.841887f, 0.512891f, -0.167835f, 
		0.829091f, 0.174567f, 0.531164f, 0.158161f, 0.980682f, -0.115101f, 
		0.654772f, -0.156923f, -0.739357f, 0.358059f, 0.298983f, -0.884536f, 
		0.863884f, -0.0122096f, 0.503543f, 0.856669f, -0.110672f, 0.503856f, 
		0.178587f, -0.975778f, -0.126352f, 0.386788f, 0.595242f, -0.704331f, 
		-0.0494217f, 0.734470f, 0.676839f, 0.00163763f, 0.404088f, 0.914719f, 
		-0.00557091f, 0.295399f, 0.955358f, 0.379544f, 0.134944f, 0.915279f, 
		-0.430566f, 0.631887f, 0.644462f, -0.227290f, 0.700023f, 0.676984f, 
		0.531829f, -0.792249f, -0.299165f, 0.796119f, -0.306154f, -0.521981f, 
		0.0818140f, -0.926189f, -0.368077f, 0.707830f, -0.0119364f, -0.706282f, 
		0.379725f, -0.914553f, -0.139292f, -0.212611f, 0.0403605f, 0.976303f, 
		0.531582f, 0.0634729f, -0.844625f, -0.665349f, -0.118458f, -0.737074f, 
		-0.534862f, -0.118433f, -0.836598f, -0.600182f, -0.119051f, -0.790954f, 
		0.171948f, -0.0899407f, 0.980992f, 0.718117f, 0.0441844f, -0.694518f, 
		0.414134f, 0.432493f, 0.800901f, 0.405411f, 0.881307f, -0.242775f, 
		0.287723f, 0.155879f, 0.944943f, 0.289578f, 0.279058f, 0.915572f, 
		0.401278f, 0.142943f, 0.904734f, 0.356208f, 0.209876f, 0.910532f, 
		0.417753f, 0.257638f, 0.871266f, 0.435091f, 0.555578f, 0.708540f, 
		-0.935855f, -0.0292360f, 0.351170f, -0.853073f, -0.131300f, -0.505002f, 
		0.435026f, -0.551398f, 0.711838f, 0.411205f, -0.642730f, -0.646380f, 
		-0.780260f, -0.00136555f, 0.625453f, 0.329649f, -0.231018f, 0.915403f, 
		0.419669f, -0.163408f, -0.892847f, 0.399975f, -0.897258f, 0.186942f, 
		-0.0623879f, -0.407080f, 0.911259f, -0.196563f, -0.401313f, 0.894601f, 
		0.210314f, -0.381985f, 0.899920f, 0.0301022f, -0.416190f, 0.908779f, 
		0.110791f, -0.361493f, 0.925769f, 0.439326f, -0.751102f, -0.492787f, 
		0.441919f, -0.699979f, 0.561014f, 0.303269f, 0.284642f, -0.909399f, 
		0.441399f, 0.723100f, 0.531313f, 0.718640f, -0.468959f, 0.513452f, 
		0.454174f, 0.113845f, 0.883609f, 0.188878f, 0.670877f, -0.717112f, 
		0.673947f, 0.579944f, 0.457668f, -0.180330f, 0.975253f, 0.127919f, 
		0.815898f, -0.327308f, -0.476634f, 0.168653f, -0.886103f, -0.431714f, 
		0.713804f, -0.0383944f, -0.699292f, -0.242581f, -0.589720f, 0.770314f, 
		0.653205f, -0.179926f, -0.735493f, 0.454923f, -0.101860f, 0.884686f, 
		0.465109f, -0.377885f, 0.800547f, 0.454140f, -0.465328f, -0.759754f, 
		0.308925f, -0.140570f, 0.940641f, 0.297179f, 0.354359f, -0.886631f, 
		0.739827f, 0.486599f, 0.464627f, 0.431250f, 0.134044f, 0.892219f, 
		0.533328f, 0.195154f, -0.823090f, 0.489133f, 0.399361f, -0.775409f, 
		-0.336771f, 0.150159f, 0.929536f, 0.237068f, -0.290721f, 0.926974f, 
		0.183567f, -0.361706f, 0.914041f, 0.218892f, -0.441695f, 0.870053f, 
		-0.874614f, 0.292804f, -0.386414f, -0.909831f, 0.279917f, -0.306357f, 
		-0.940961f, 0.337898f, -0.0204533f, -0.873546f, -0.428983f, 0.229978f, 
		0.420546f, 0.117774f, 0.899594f, 0.465333f, 0.0781841f, -0.881676f, 
		-0.465405f, -0.0582471f, -0.883179f, 0.456884f, 0.865975f, 0.203331f, 
		0.309540f, -0.781606f, -0.541550f, 0.444939f, 0.306391f, -0.841519f, 
		0.303269f, 0.284642f, -0.909399f, 0.472812f, 0.800228f, 0.368895f, 
		0.509261f, 0.859168f, 0.0498255f, 0.601045f, -0.798683f, 0.0291589f, 
		-0.654168f, 0.0438985f, -0.755074f, -0.894875f, -0.321064f, 0.310027f, 
		0.320533f, -0.912297f, 0.254899f, -0.868339f, 0.495145f, -0.0286114f, 
		0.508871f, 0.418091f, -0.752496f, 0.508502f, 0.271071f, 0.817280f, 
		-0.853685f, 0.315613f, -0.414258f, -0.884195f, 0.329694f, -0.330910f, 
		-0.801757f, 0.354722f, -0.480996f, 0.497974f, 0.808206f, -0.314364f, 
		0.503668f, 0.727130f, -0.466477f, 0.526895f, 0.317830f, 0.788267f, 
		0.296727f, 0.740086f, -0.603512f, 0.512241f, -0.806026f, -0.296531f, 
		0.497891f, 0.640578f, 0.584606f, 0.202613f, -0.0340545f, 0.978667f, 
		0.498770f, -0.245421f, 0.831262f, 0.712664f, -0.0622474f, -0.698738f, 
		0.517093f, -0.0861567f, -0.851582f, 0.506022f, -0.768955f, 0.390705f, 
		0.811498f, -0.558138f, 0.173069f, 0.261583f, -0.902466f, -0.342242f, 
		0.530866f, -0.216100f, -0.819440f, 0.166478f, -0.249426f, -0.953977f, 
		0.0770942f, -0.244580f, -0.966559f, -0.991820f, -0.110113f, 0.0645546f, 
		-0.625566f, 0.0868786f, -0.775319f, 0.524357f, -0.253050f, -0.813029f, 
		0.528406f, -0.621333f, 0.578560f, -0.779614f, 0.0229230f, 0.625841f, 
		-0.844656f, -0.0855306f, -0.528432f, -0.945989f, 0.0534920f, 0.319754f, 
		0.591857f, -0.139382f, 0.793900f, 0.651127f, -0.150665f, 0.743864f, 
		0.715766f, -0.160943f, 0.679541f, 0.892891f, -0.251002f, 0.373823f, 
		0.521480f, 0.842758f, -0.133482f, 0.513640f, -0.852188f, -0.0997449f, 
		-0.617467f, -0.121884f, -0.777096f, 0.321957f, -0.239119f, 0.916060f, 
		-0.995389f, -0.00851545f, 0.0955421f, 0.908837f, 0.278454f, 0.310609f, 
		0.793825f, 0.174069f, -0.582703f, 0.655035f, -0.180741f, -0.733663f, 
		0.519036f, -0.604108f, -0.604694f, 0.292132f, -0.296602f, -0.909223f, 
		0.572955f, -0.258237f, -0.777840f, 0.115286f, -0.298883f, -0.947300f, 
		-0.198405f, -0.291742f, -0.935693f, -0.210260f, 0.0611215f, 0.975733f, 
		0.412902f, 0.232344f, 0.880641f, 0.487291f, 0.250446f, 0.836555f, 
		0.551858f, 0.288724f, 0.782363f, 0.530245f, -0.817625f, 0.224342f, 
		0.426773f, -0.892030f, -0.148822f, 0.956283f, 0.0552688f, 0.287172f, 
		0.791816f, 0.0341560f, -0.609803f, 0.238467f, -0.141431f, -0.960797f, 
		0.156475f, -0.132705f, -0.978726f, -0.0449325f, -0.103121f, -0.993653f, 
		0.783183f, -0.216770f, 0.582782f, 0.817998f, -0.451891f, 0.355913f, 
		0.852843f, -0.463371f, 0.240719f, 0.532629f, 0.610051f, -0.586639f, 
		0.643259f, -0.201209f, -0.738737f, -0.218576f, -0.975522f, -0.0241332f, 
		0.463834f, 0.171113f, 0.869240f, 0.301733f, 0.730874f, -0.612193f, 
		0.836916f, 0.271514f, 0.475239f, 0.299526f, 0.327250f, -0.896210f, 
		-0.183951f, 0.974206f, 0.130708f, 0.628353f, 0.221751f, -0.745653f, 
		0.730896f, 0.0769033f, -0.678143f, 0.567190f, 0.407389f, 0.715772f, 
		-0.717900f, 0.586237f, 0.375427f, -0.737473f, 0.661951f, 0.133996f, 
		-0.635034f, 0.649951f, 0.417487f, -0.683322f, 0.548551f, 0.481833f, 
		-0.568038f, 0.611116f, 0.551244f, -0.812787f, 0.535472f, 0.229450f, 
		0.341563f, 0.0777491f, -0.936637f, 0.563364f, -0.825172f, 0.0413813f, 
		0.601655f, -0.247090f, -0.759577f, -0.197297f, -0.291044f, -0.936145f, 
		0.462084f, -0.705736f, -0.537043f, 0.577649f, -0.675846f, -0.457771f, 
		0.868694f, 0.159807f, 0.468863f, 0.311053f, 0.285391f, -0.906531f, 
		0.714220f, -0.0734716f, -0.696054f, 0.568199f, 0.497595f, -0.655400f, 
		0.00914133f, 0.882782f, 0.469694f, 0.554717f, 0.280638f, -0.783283f, 
		0.551071f, -0.304609f, 0.776875f, 0.899839f, -0.0692427f, 0.430692f, 
		0.353943f, 0.0325782f, -0.934699f, 0.176378f, -0.976428f, -0.124412f, 
		0.893985f, 0.0422613f, 0.446100f, 0.349152f, 0.0795457f, -0.933684f, 
		0.568212f, 0.709204f, 0.417330f, 0.324603f, -0.731425f, -0.599709f, 
		0.597335f, -0.372862f, -0.710046f, 0.475924f, 0.0167963f, 0.879326f, 
		0.578877f, 0.207810f, -0.788490f, -0.167167f, -0.305573f, -0.937379f, 
		0.656188f, -0.243423f, -0.714257f, 0.576290f, 0.0420986f, 0.816160f, 
		0.600756f, -0.534430f, 0.594539f, 0.618761f, 0.614302f, 0.489660f, 
		0.612228f, 0.648946f, -0.451714f, 0.591280f, -0.209056f, 0.778899f, 
		0.318443f, -0.228286f, 0.920043f, 0.406195f, -0.212491f, 0.888737f, 
		0.224554f, -0.0395617f, -0.973658f, 0.137950f, -0.0517239f, -0.989088f, 
		-0.251628f, -0.0974381f, -0.962907f, 0.749997f, -0.661431f, -0.00370741f, 
		0.666121f, -0.0952431f, -0.739738f, 0.622280f, -0.180778f, 0.761634f, 
		0.341563f, 0.0777491f, -0.936637f, 0.612365f, 0.128137f, 0.780122f, 
		0.453395f, 0.0429677f, 0.890273f, 0.532247f, 0.0211553f, 0.846325f, 
		0.799773f, -0.00477780f, 0.600284f, 0.598262f, 0.0456576f, 0.799999f, 
		0.344781f, -0.0286349f, 0.938246f, 0.197888f, 0.00315328f, 0.980220f, 
		0.617771f, 0.732492f, -0.286031f, 0.603019f, -0.657910f, 0.451135f, 
		0.848623f, 0.219291f, 0.481406f, 0.132769f, 0.917295f, 0.375423f, 
		0.621742f, -0.519405f, -0.586221f, 0.599181f, -0.374404f, 0.707675f, 
		-0.441617f, 0.240027f, 0.864501f, 0.430449f, -0.213139f, 0.877089f, 
		0.358181f, -0.549940f, -0.754501f, 0.609017f, 0.764465f, 0.211405f, 
		0.544490f, 0.762610f, 0.349224f, -0.631641f, -0.140789f, -0.762370f, 
		0.713288f, -0.114055f, -0.691528f, 0.730366f, 0.217707f, -0.647432f, 
		0.622326f, -0.0142172f, 0.782629f, -0.830070f, 0.108951f, 0.546912f, 
		-0.956983f, 0.0718479f, 0.281107f, -0.867867f, 0.127199f, 0.480236f, 
		-0.147473f, -0.926084f, 0.347305f, 0.753608f, -0.105500f, 0.648803f, 
		0.632217f, 0.494385f, 0.596561f, -0.0489386f, -0.417166f, -0.907512f, 
		0.225608f, -0.396953f, -0.889679f, 0.528292f, -0.316144f, -0.788010f, 
		0.633924f, -0.0206300f, -0.773120f, 0.646289f, -0.692254f, -0.321084f, 
		0.370495f, -0.849760f, -0.375021f, -0.287884f, -0.582307f, 0.760290f, 
		0.366240f, -0.159426f, -0.916761f, 0.645717f, -0.304116f, -0.700402f, 
		0.798919f, -0.201386f, -0.566720f, 0.152456f, -0.637865f, -0.754908f, 
		0.415433f, -0.505668f, -0.756118f, 0.651780f, -0.742270f, -0.155622f, 
		0.542208f, -0.0213858f, 0.839972f, 0.762235f, -0.0859272f, -0.641572f, 
		0.288663f, 0.851299f, 0.438137f, 0.441963f, 0.0692046f, 0.894360f, 
		0.663899f, 0.745798f, 0.0549857f, -0.490551f, -0.275670f, -0.826660f, 
		0.909569f, -0.295974f, 0.291690f, -0.196189f, -0.950971f, 0.239091f, 
		0.654258f, -0.716233f, 0.242810f, 0.370072f, -0.383546f, -0.846132f, 
		0.664423f, 0.150057f, -0.732137f, 0.670346f, -0.613458f, -0.417499f, 
		0.371037f, -0.299108f, -0.879128f, -0.209038f, 0.0808002f, 0.974564f, 
		0.0330334f, 0.182936f, 0.982570f, 0.793260f, 0.109069f, 0.599035f, 
		0.666256f, 0.342410f, -0.662464f, 0.961268f, -0.0149675f, 0.275209f, 
		0.682421f, 0.236354f, 0.691692f, 0.363754f, -0.494964f, -0.789110f, 
		0.675049f, -0.218841f, -0.704569f, 0.701989f, -0.161106f, -0.693726f, 
		0.917607f, -0.227235f, 0.326132f, 0.334036f, 0.181753f, -0.924871f, 
		0.257695f, -0.900880f, -0.349297f, 0.661593f, 0.745764f, -0.0782994f, 
		0.735053f, 0.452248f, 0.505143f, 0.652335f, 0.177176f, 0.736931f, 
		0.446906f, 0.168711f, 0.878528f, 0.499214f, 0.167792f, 0.850077f, 
		0.278394f, -0.958733f, 0.0576871f, 0.853923f, -0.00177597f, 0.520396f, 
		0.561146f, -0.348993f, 0.750546f, 0.964315f, 0.0474540f, -0.260472f, 
		0.687613f, 0.645371f, 0.332693f, 0.0556196f, 0.194230f, 0.979378f, 
		0.821666f, 0.106643f, 0.559903f, 0.856091f, 0.128205f, 0.500672f, 
		0.108480f, 0.190647f, 0.975646f, 0.844149f, 0.0981033f, 0.527056f, 
		0.698910f, 0.363558f, 0.615915f, -0.596581f, 0.215061f, -0.773201f, 
		0.139336f, 0.140087f, 0.980286f, 0.844198f, 0.108284f, 0.524981f, 
		0.326771f, 0.943448f, -0.0559166f, 0.678559f, 0.512674f, -0.526045f, 
		0.769302f, 0.0474750f, -0.637119f, 0.709997f, -0.702671f, 0.0464562f, 
		0.166392f, 0.0487238f, 0.984855f, 0.366240f, -0.159426f, -0.916761f, 
		0.603941f, 0.322469f, -0.728882f, 0.909569f, -0.295974f, 0.291690f, 
		0.800940f, -0.131396f, 0.584149f, 0.592104f, 0.779793f, 0.203312f, 
		0.704836f, -0.0590040f, 0.706912f, 0.716150f, -0.561076f, 0.415118f, 
		0.723885f, -0.419297f, 0.547887f, 0.956459f, -0.291794f, 0.00645518f, 
		0.370071f, -0.383560f, -0.846126f, 0.494873f, 0.123416f, 0.860156f, 
		0.371027f, -0.299109f, -0.879132f, 0.767671f, 0.0965680f, 0.633527f, 
		0.00813485f, 0.187812f, 0.982171f, -0.509155f, -0.121340f, -0.852078f, 
		0.939579f, -0.318503f, 0.125490f, 0.658788f, 0.665733f, 0.350424f, 
		0.552480f, -0.0444942f, 0.832337f, 0.730415f, -0.636761f, -0.247042f, 
		0.482404f, -0.0153563f, 0.875814f, 0.766770f, -0.0277617f, -0.641322f, 
		0.724587f, 0.0716129f, 0.685452f, 0.915919f, -0.165579f, -0.365618f, 
		0.738401f, 0.574493f, -0.353161f, 0.744720f, 0.513469f, 0.426313f, 
		0.505441f, -0.0160020f, -0.862713f, -0.291237f, -0.0979543f, -0.951623f, 
		0.745511f, -0.259614f, 0.613852f, 0.748722f, 0.281080f, -0.600341f, 
		0.707080f, -0.180248f, -0.683776f, 0.933906f, 0.142662f, 0.327823f, 
		0.739275f, -0.622793f, -0.256127f, 0.743524f, 0.653008f, 0.144060f, 
		0.743531f, 0.638226f, -0.199574f, 0.147146f, 0.0754614f, 0.986232f, 
		0.845454f, 0.113078f, 0.521940f, 0.738630f, -0.532135f, -0.413834f, 
		0.736041f, -0.373659f, -0.564466f, 0.746259f, -0.0468655f, -0.664004f, 
		-0.255735f, -0.856035f, -0.449225f, -0.681389f, 0.0272869f, -0.731413f, 
		0.749428f, -0.619998f, 0.232295f, -0.966998f, 0.0524633f, 0.249322f, 
		-0.994643f, 0.0525597f, 0.0890151f, -0.988872f, -0.143869f, -0.0378656f, 
		-0.996408f, -0.0701371f, 0.0474584f, -0.957648f, -0.269189f, -0.102214f, 
		0.949294f, 0.202904f, -0.240148f, 0.754042f, 0.157457f, -0.637674f, 
		0.744262f, -0.311013f, 0.591054f, -0.572032f, -0.0885010f, -0.815443f, 
		0.753216f, -0.0889240f, 0.651734f, -0.207585f, 0.120805f, 0.970729f, 
		0.769436f, 0.246158f, 0.589385f, 0.117311f, 0.0699942f, 0.990626f, 
		-0.264227f, -0.542783f, 0.797227f, -0.935834f, 0.243584f, -0.254719f, 
		0.761577f, -0.641523f, -0.0919200f, 0.780760f, 0.386230f, -0.491162f, 
		-0.912001f, 0.265520f, 0.312657f, 0.616680f, 0.107263f, 0.779872f, 
		0.124392f, -0.625027f, 0.770628f, -0.582207f, -0.0910437f, 0.807927f, 
		0.967851f, -0.0712958f, -0.241207f, 0.801944f, -0.142923f, -0.580050f, 
		0.746293f, -0.150843f, -0.648300f, -0.850450f, 0.100227f, 0.516419f, 
		-0.800075f, -0.0539338f, 0.597471f, -0.734046f, -0.178181f, 0.655308f, 
		0.538177f, -0.148739f, 0.829603f, 0.788676f, -0.168338f, -0.591314f, 
		-0.916191f, -0.132199f, -0.378308f, -0.903561f, -0.271820f, -0.331197f, 
		-0.890391f, -0.390450f, -0.233993f, -0.0783745f, -0.605690f, -0.791831f, 
		0.152544f, 0.874742f, 0.459953f, 0.900995f, -0.0468817f, -0.431289f, 
		0.795649f, -0.0273033f, -0.605142f, 0.742914f, -0.0218807f, -0.669029f, 
		-0.843705f, -0.507617f, 0.174607f, -0.630163f, -0.577617f, 0.518897f, 
		-0.405116f, -0.670007f, 0.622070f, -0.870124f, -0.492458f, -0.0192054f, 
		0.697320f, -0.0821448f, 0.712037f, -0.954995f, 0.0484241f, 0.292643f, 
		-0.815966f, -0.206113f, 0.540109f, -0.730640f, -0.401000f, 0.552598f, 
		-0.969910f, 0.237240f, -0.0547016f, 0.764669f, -0.0665161f, -0.640982f, 
		-0.564381f, 0.249674f, -0.786853f, -0.626812f, 0.198505f, -0.753461f, 
		-0.677673f, 0.145234f, -0.720879f, 0.710311f, 0.0772722f, 0.699634f, 
		0.800533f, 0.597417f, -0.0473206f, 0.336753f, 0.938481f, -0.0764969f, 
		0.811326f, -0.289442f, 0.507910f, 0.809801f, 0.526767f, 0.258338f, 
		-0.719422f, 0.694426f, 0.0142946f, -0.867534f, 0.496302f, 0.0327095f, 
		-0.920313f, 0.361457f, 0.149576f, 0.705145f, -0.178069f, -0.686339f, 
		0.596545f, -0.0245615f, 0.802204f, 0.802724f, 0.349631f, 0.483107f, 
		-0.794905f, -0.579784f, 0.178817f, -0.254627f, -0.786653f, -0.562444f, 
		-0.953775f, 0.171156f, -0.247019f, -0.410928f, -0.0349495f, -0.910998f, 
		0.819834f, -0.392580f, 0.416837f, 0.828774f, -0.494292f, -0.262313f, 
		-0.922990f, 0.0931447f, 0.373382f, -0.975941f, 0.215733f, 0.0315909f, 
		-0.896973f, 0.337491f, -0.285551f, 0.428565f, 0.357315f, -0.829854f, 
		0.822027f, 0.450221f, -0.348673f, 0.820869f, 0.0674812f, 0.567116f, 
		0.981149f, -0.0814963f, -0.175226f, 0.877158f, -0.161832f, -0.452112f, 
		0.773733f, -0.193700f, -0.603174f, 0.548071f, -0.246833f, -0.799182f, 
		0.410210f, -0.759285f, -0.505186f, 0.815934f, -0.573612f, 0.0722531f, 
		0.817089f, 0.529936f, -0.227008f, 0.832226f, -0.550193f, -0.0684682f, 
		-0.0525580f, -0.0664596f, -0.996404f, -0.825813f, 0.278346f, -0.490466f, 
		0.824743f, -0.411202f, -0.388216f, 0.829438f, -0.488127f, 0.271595f, 
		0.844780f, 0.0342606f, -0.534016f, 0.886046f, 0.376119f, 0.271029f, 
		0.828210f, 0.471711f, 0.302585f, 0.776619f, 0.616190f, 0.131041f, 
		0.668374f, 0.731820f, 0.133100f, 0.889675f, 0.283610f, 0.357832f, 
		-0.641965f, 0.630830f, -0.435815f, -0.735624f, 0.535649f, -0.414653f, 
		-0.505131f, 0.590158f, -0.629727f, -0.890642f, 0.360393f, -0.277261f, 
		-0.825135f, 0.483470f, -0.292247f, -0.340693f, 0.307396f, -0.888502f, 
		-0.866590f, 0.326417f, -0.377458f, -0.957810f, 0.188269f, 0.217153f, 
		-0.907011f, 0.149463f, 0.393691f, -0.949235f, 0.305875f, -0.0734445f, 
		0.551495f, -0.103779f, 0.827697f, 0.844363f, 0.190628f, 0.500712f, 
		0.841230f, 0.529763f, 0.108093f, 0.839208f, -0.531968f, -0.112874f, 
		-0.253150f, -0.831266f, 0.494886f, -0.757883f, -0.633011f, -0.157832f, 
		0.230380f, -0.883218f, -0.408474f, 0.542371f, 0.798125f, 0.262355f, 
		-0.233799f, 0.752600f, 0.615573f, 0.0312226f, 0.666739f, 0.744637f, 
		0.274007f, 0.443036f, 0.853604f, 0.0646561f, 0.451060f, 0.890149f, 
		-0.291005f, 0.657854f, 0.694654f, 0.848306f, -0.263676f, -0.459187f, 
		0.844770f, -0.129561f, 0.519208f, 0.838886f, 0.0496602f, -0.542037f, 
		0.792362f, 0.0380673f, -0.608863f, 0.653417f, 0.0170750f, -0.756806f, 
		0.764809f, -0.0701679f, -0.640424f, -0.0932638f, -0.410447f, -0.907103f, 
		0.174430f, -0.494339f, -0.851588f, 0.0714197f, -0.426236f, -0.901788f, 
		-0.740288f, -0.625835f, 0.245571f, -0.119269f, -0.855948f, -0.503119f, 
		0.684160f, 0.197236f, -0.702156f, 0.852411f, 0.211356f, -0.478251f, 
		0.862269f, -0.101239f, -0.496228f, -0.317439f, -0.828236f, 0.461799f, 
		-0.630498f, -0.648028f, 0.427238f, -0.751243f, -0.557320f, 0.353594f, 
		-0.00968824f, 0.189464f, -0.981840f, -0.879109f, 0.293577f, -0.375472f, 
		0.204953f, -0.970830f, 0.124434f, -0.207143f, -0.953113f, -0.220608f, 
		0.386232f, 0.811678f, -0.438183f, 0.149990f, 0.0916732f, 0.984428f, 
		0.847922f, 0.121330f, 0.516049f, 0.859866f, -0.155789f, -0.486169f, 
		0.909053f, 0.348394f, -0.228570f, -0.481830f, -0.179394f, 0.857705f, 
		-0.746847f, 0.292744f, 0.597094f, -0.759252f, 0.526690f, 0.382276f, 
		-0.665393f, -0.0220193f, 0.746168f, -0.553066f, -0.162911f, 0.817054f, 
		0.990169f, -0.0894248f, -0.107554f, 0.581629f, -0.254411f, -0.772647f, 
		-0.373988f, 0.586121f, 0.718746f, 0.867266f, 0.379135f, 0.322655f, 
		0.499823f, -0.0180454f, -0.865940f, -0.326199f, -0.113922f, -0.938412f, 
		-0.640252f, 0.768163f, 0.00187557f, -0.661311f, 0.744607f, 0.0907109f, 
		-0.701129f, 0.572795f, 0.424646f, -0.260338f, -0.573446f, 0.776778f, 
		0.891898f, 0.292004f, -0.345328f, -0.911490f, 0.387394f, -0.138246f, 
		-0.903926f, -0.267658f, 0.333582f, -0.932732f, -0.0724681f, 0.353212f, 
		-0.970475f, 0.182406f, 0.157818f, 0.428565f, 0.357315f, -0.829854f, 
		0.844112f, 0.102503f, 0.526278f, 0.963589f, 0.0401834f, -0.264352f, 
		0.712853f, -0.111872f, -0.692334f, 0.891744f, -0.351160f, 0.285446f, 
		0.832894f, 0.0949157f, 0.545233f, 0.964304f, -0.0576669f, -0.258441f, 
		-0.203786f, 0.192076f, 0.959988f, -0.335270f, 0.251472f, 0.907940f, 
		-0.430655f, 0.256602f, 0.865270f, 0.881454f, 0.424341f, -0.207299f, 
		0.0957762f, 0.0724896f, 0.992760f, 0.170435f, -0.953761f, 0.247570f, 
		0.204174f, -0.902431f, 0.379383f, 0.0699479f, -0.921667f, 0.381624f, 
		0.128264f, -0.969397f, -0.209326f, -0.180833f, -0.840699f, 0.510417f, 
		-0.789360f, -0.0292934f, 0.613231f, 0.896655f, 0.410975f, 0.164650f, 
		0.903142f, 0.223517f, 0.366572f, 0.763282f, -0.101726f, -0.638006f, 
		0.899289f, -0.213115f, 0.381917f, 0.896471f, -0.339687f, -0.284521f, 
		0.903525f, 0.428286f, -0.0145840f, -0.896017f, 0.426722f, -0.122725f, 
		-0.868130f, 0.304925f, 0.391626f, -0.922977f, 0.384647f, 0.0126656f, 
		-0.808620f, 0.0209893f, 0.587957f, 0.723073f, 0.353797f, -0.593290f, 
		-0.907055f, 0.420598f, -0.0186754f, -0.862103f, 0.495624f, 0.105527f, 
		-0.680686f, 0.715499f, 0.157250f, -0.586908f, 0.807524f, 0.0586825f, 
		0.287711f, -0.160092f, -0.944242f, -0.00146643f, 0.0429212f, -0.999077f, 
		0.356130f, -0.216285f, -0.909061f, 0.912107f, -0.180061f, -0.368291f, 
		0.910404f, -0.403350f, 0.0920542f, 0.912855f, -0.0584345f, 0.404080f, 
		-0.641349f, 0.0364995f, -0.766380f, -0.632316f, 0.237282f, -0.737478f, 
		-0.778013f, 0.104417f, -0.619510f, -0.797914f, -0.325940f, -0.507046f, 
		-0.828846f, -0.460821f, -0.317267f, -0.896036f, -0.275824f, -0.347909f, 
		0.373592f, -0.628933f, -0.681815f, 0.532818f, -0.720217f, -0.444290f, 
		0.307865f, -0.866989f, -0.391854f, 0.311136f, -0.778354f, -0.545307f, 
		-0.331535f, 0.794450f, -0.508855f, 0.767194f, -0.537187f, -0.350490f, 
		0.919391f, 0.0668788f, 0.387617f, -0.909813f, -0.408538f, 0.0730533f, 
		-0.791384f, -0.561400f, 0.241955f, -0.865093f, -0.463831f, 0.190982f, 
		-0.566916f, -0.742665f, 0.356447f, -0.663672f, -0.618762f, 0.420324f, 
		0.801778f, 0.114069f, 0.586634f, 0.972032f, -0.0801522f, -0.220748f, 
		0.916479f, -0.381716f, -0.119830f, 0.783355f, -0.234759f, 0.575538f, 
		-0.326710f, 0.302083f, -0.895548f, -0.179853f, -0.0310366f, -0.983204f, 
		-0.200645f, 0.245665f, -0.948362f, 0.873900f, -0.385779f, 0.295760f, 
		0.851830f, 0.186168f, 0.489619f, 0.178923f, 0.856180f, 0.484709f, 
		0.761740f, -0.157095f, -0.628548f, 0.142569f, -0.194613f, -0.970464f, 
		0.116887f, -0.672659f, -0.730662f, 0.0341026f, -0.821912f, -0.568593f, 
		0.0371687f, -0.00297212f, -0.999305f, 0.394341f, 0.798060f, -0.455626f, 
		0.559095f, -0.0712701f, 0.826035f, 0.0596687f, -0.814297f, 0.577373f, 
		-0.614446f, -0.152363f, 0.774107f, 0.931176f, -0.0295831f, -0.363367f, 
		-0.0943675f, 0.225806f, -0.969591f, -0.825418f, 0.403787f, -0.394514f, 
		0.930302f, 0.120123f, -0.346566f, -0.805241f, -0.523394f, -0.278648f, 
		-0.642964f, -0.636305f, -0.426279f, -0.529064f, -0.690630f, -0.493074f, 
		-0.485439f, -0.0207320f, 0.874025f, -0.0741308f, -0.775642f, 0.626805f, 
		0.844156f, 0.113147f, 0.524021f, 0.966032f, 0.0701808f, -0.248709f, 
		0.0900201f, 0.941628f, 0.324395f, 0.0304112f, 0.922651f, 0.384435f, 
		-0.0227849f, 0.899183f, 0.436979f, -0.135144f, -0.667245f, 0.732476f, 
		0.529120f, -0.833968f, 0.156615f, 0.491304f, 0.117180f, -0.863069f, 
		0.985702f, -0.0810057f, -0.147748f, 0.775834f, 0.0870205f, 0.624907f, 
		-0.0792199f, -0.278796f, 0.957077f, 0.943254f, 0.255108f, 0.212583f, 
		-0.717697f, 0.191972f, 0.669371f, -0.735625f, 0.0472611f, 0.675739f, 
		-0.679466f, 0.492235f, 0.544087f, -0.735958f, 0.375066f, 0.563642f, 
		-0.690377f, 0.604707f, 0.397126f, -0.658086f, -0.108286f, 0.745115f, 
		-0.645052f, 0.423105f, -0.636309f, -0.738920f, 0.453564f, -0.498274f, 
		-0.375620f, 0.747459f, -0.547918f, -0.310443f, 0.872923f, -0.376340f, 
		-0.594124f, 0.696175f, -0.402935f, 0.438121f, -0.690492f, -0.575561f, 
		0.948746f, 0.274204f, -0.157141f, 0.855664f, 0.0175041f, -0.517236f, 
		-0.761517f, 0.234076f, 0.604401f, 0.956331f, -0.221173f, 0.191084f, 
		-0.528982f, -0.846007f, -0.0667124f, -0.408323f, -0.879227f, -0.245421f, 
		-0.176063f, -0.967045f, 0.183920f, -0.0385431f, -0.975957f, 0.214527f, 
		-0.0968780f, -0.991593f, 0.0857761f, 0.959975f, 0.278597f, 0.0288423f, 
		0.848145f, -0.496667f, -0.184315f, 0.960302f, 0.0980156f, 0.261176f, 
		0.960179f, -0.193717f, -0.201319f, -0.663805f, -0.290257f, 0.689285f, 
		0.966521f, -0.115599f, -0.229072f, 0.751971f, -0.196690f, -0.629168f, 
		0.612666f, -0.235200f, -0.754534f, 0.997270f, -0.0638683f, -0.0370612f, 
		-0.496638f, 0.861764f, 0.103509f, -0.425062f, 0.905153f, -0.00450807f, 
		-0.611923f, 0.614282f, 0.498205f, 0.372705f, -0.00375463f, -0.927942f, 
		0.112059f, 0.168536f, -0.979305f, -0.0727871f, 0.218766f, -0.973059f, 
		0.220584f, 0.0951088f, -0.970720f, 0.611796f, -0.137602f, -0.778955f, 
		0.467036f, -0.0763621f, -0.880935f, 0.968090f, 0.0711808f, -0.240281f, 
		0.500565f, -0.0121359f, -0.865614f, -0.519512f, 0.819672f, 0.241341f, 
		-0.456122f, 0.889169f, -0.0364771f, -0.502042f, 0.849483f, 0.162274f, 
		0.971827f, 0.139602f, -0.189905f, 0.968883f, -0.0629070f, 0.239394f, 
		-0.649221f, 0.0485234f, 0.759050f, -0.454133f, -0.0461716f, 0.889737f, 
		-0.134193f, -0.172756f, 0.975781f, 0.217338f, -0.872380f, -0.437856f, 
		0.798528f, 0.0178778f, 0.601691f, 0.979182f, -0.202599f, -0.0124806f, 
		0.496385f, -0.0233311f, -0.867789f, -0.366720f, -0.125987f, -0.921761f, 
		0.806153f, 0.0617359f, 0.588478f, 0.655844f, -0.748003f, -0.101783f, 
		0.987930f, 0.146905f, -0.0491146f, 0.982668f, -0.0277689f, -0.183280f, 
		0.992166f, -0.0972363f, 0.0784347f, -0.305000f, -0.790449f, 0.531192f, 
		0.843226f, -0.509194f, -0.172314f, 0.843264f, 0.135296f, 0.520193f, 
		0.852564f, -0.0385607f, -0.521198f, 0.992113f, 0.0741908f, 0.101033f, 
		-0.550779f, -0.129630f, 0.824524f, 0.0856571f, -0.188545f, 0.978322f, 
		-0.700571f, -0.0690665f, 0.710232f, -0.112260f, -0.232820f, 0.966019f, 
		0.999094f, -0.00785016f, -0.0418395f, 0.152473f, 0.109115f, 0.982266f, 
		0.849911f, 0.127195f, 0.511344f, -0.0930966f, 0.702114f, -0.705953f, 
		0.0639067f, 0.498969f, -0.864261f, 0.297826f, 0.0655949f, -0.952364f, 
		0.187184f, 0.212638f, -0.959035f, 0.443666f, -0.574574f, -0.687768f, 
		0.850925f, 0.0523987f, 0.522667f, 0.491304f, 0.117180f, -0.863069f, 
		-0.610235f, 0.638210f, 0.469362f, -0.399917f, -0.180170f, 0.898669f, 
		-0.117819f, 0.205069f, -0.971630f, -0.435079f, -0.632092f, -0.641222f, 
		-0.213379f, -0.675254f, -0.706046f, -0.0461974f, -0.715585f, -0.696997f, 
		0.296173f, 0.131483f, -0.946041f, 0.0454514f, 0.166873f, -0.984930f, 
		0.695517f, -0.406417f, -0.592521f, 0.556314f, -0.0430220f, 0.829858f, 
		-0.245366f, -0.406858f, 0.879922f, 0.843172f, -0.0460967f, 0.535664f, 
		-0.906556f, 0.419384f, -0.0476741f, -0.900046f, 0.384596f, 0.204946f, 
		-0.854319f, 0.426555f, -0.296967f, -0.0548310f, -0.881597f, 0.468808f, 
		-0.473844f, -0.162930f, 0.865405f, 0.346987f, 0.0827148f, -0.934215f, 
		-0.274192f, 0.495798f, -0.824016f, 0.835155f, -0.0728388f, 0.545171f, 
		-0.161147f, 0.897041f, -0.411521f, -0.0473949f, 0.0800001f, 0.995667f, 
		0.341270f, 0.0350730f, 0.939311f, 0.613209f, -0.0152084f, 0.789774f, 
		0.754217f, -0.523332f, 0.396585f, 0.0787471f, -0.407267f, 0.909908f, 
		0.865566f, -0.490052f, -0.103174f, 0.845495f, 0.393177f, 0.361318f, 
		0.120772f, -0.600284f, 0.790615f, -0.668102f, -0.159655f, 0.726739f, 
		-0.132385f, 0.914386f, -0.382586f, -0.0409602f, -0.728922f, -0.683371f, 
		-0.0240832f, -0.816637f, -0.576648f, -0.101356f, -0.844393f, -0.526049f, 
		0.991976f, -0.0730220f, -0.103205f, 0.745915f, 0.119253f, 0.655278f, 
		0.358818f, 0.101902f, -0.927828f, 0.445165f, -0.0734750f, -0.892429f, 
		0.474482f, -0.652771f, -0.590557f, 0.510087f, -0.496659f, -0.702240f, 
		0.601974f, 0.791583f, 0.104992f, 0.927197f, 0.112561f, 0.357261f, 
		0.991955f, 0.0990061f, 0.0788826f, 0.981690f, 0.102933f, 0.160277f, 
		0.600764f, -0.106358f, -0.792320f, -0.132079f, 0.184035f, -0.974005f, 
		0.999975f, -0.00590693f, 0.00376881f, 0.953297f, 0.0603425f, 0.295946f, 
		0.914952f, 0.0840983f, 0.394704f, 0.353543f, -0.918054f, 0.179399f, 
		0.887572f, -0.00142191f, 0.460667f, 0.879616f, 0.110386f, 0.462699f, 
		0.756860f, -0.174567f, -0.629833f, 0.484460f, -0.373910f, -0.790879f, 
		-0.252051f, -0.00929648f, 0.967669f, -0.575322f, 0.120616f, 0.808985f, 
		-0.165439f, -0.0389775f, 0.985449f, 0.869034f, 0.0232409f, 0.494206f, 
		-0.480867f, 0.859667f, 0.172451f, -0.588597f, 0.655456f, 0.473214f, 
		-0.438076f, 0.893136f, 0.101970f, -0.488584f, 0.680037f, 0.546659f, 
		-0.568533f, -0.232241f, 0.789199f, 0.865576f, -0.469126f, -0.175209f, 
		0.758189f, -0.618966f, 0.205013f, 0.831536f, -0.555295f, 0.0139546f, 
		0.853169f, -0.0719475f, -0.516649f, -0.741718f, 0.225473f, 0.631678f, 
		-0.152975f, 0.133629f, -0.979154f, -0.790916f, 0.431319f, -0.434068f, 
		0.500788f, -0.261518f, -0.825118f, 0.453761f, -0.873838f, -0.174664f, 
		0.299063f, -0.933231f, 0.199102f, 0.552986f, -0.638191f, -0.535648f, 
		0.515149f, -0.757252f, -0.401485f, 0.828881f, -0.130854f, 0.543905f, 
		0.458164f, -0.492987f, -0.739628f, -0.373363f, 0.859221f, 0.349770f, 
		-0.318416f, 0.898778f, 0.301346f, -0.262459f, 0.932736f, 0.247222f, 
		0.785821f, -0.205364f, -0.583362f, 0.508242f, -0.0602240f, -0.859106f, 
		0.549231f, -0.00793766f, 0.835633f, -0.0545247f, -0.683126f, 0.728263f, 
		-0.219374f, -0.379339f, 0.898875f, -0.386593f, -0.182590f, 0.903995f, 
		0.0807546f, -0.775759f, 0.625841f, 0.710719f, -0.225639f, -0.666308f, 
		0.984716f, -0.0483175f, 0.167332f, 0.996527f, -0.0762198f, -0.0335399f, 
		0.873620f, -0.159674f, -0.459665f, 0.907849f, -0.153622f, -0.390141f, 
		-0.335196f, -0.854041f, 0.397817f, -0.478626f, -0.600230f, 0.640812f, 
		-0.539347f, -0.249745f, 0.804197f, 0.149821f, 0.141030f, 0.978603f, 
		0.851137f, 0.165524f, 0.498163f, 0.834827f, -0.343394f, 0.430285f, 
		0.0752419f, -0.225452f, 0.971344f, 0.886595f, -0.247422f, 0.390810f, 
		0.0217065f, 0.797523f, -0.602898f, 0.462429f, 0.126217f, -0.877627f, 
		0.257479f, 0.446375f, -0.857003f, 0.352069f, 0.159760f, -0.922239f, 
		0.270317f, 0.323442f, -0.906815f, 0.215007f, 0.607863f, -0.764378f, 
		0.199459f, 0.699539f, -0.686193f, 0.0976929f, 0.811167f, -0.576597f, 
		-0.749190f, 0.577496f, -0.324365f, -0.950398f, -0.210818f, -0.228691f, 
		-0.785921f, 0.206782f, 0.582726f, 0.559028f, -0.750833f, -0.351764f, 
		0.848129f, -0.518376f, -0.109378f, 0.973880f, 0.0759726f, -0.213977f, 
		0.498362f, -0.0273015f, -0.866539f, 0.414371f, -0.665200f, -0.621132f, 
		0.0579973f, -0.997526f, 0.0397195f, 0.240585f, -0.919383f, -0.311213f, 
		0.339608f, -0.791214f, -0.508573f, -0.957299f, -0.229976f, -0.175185f, 
		-0.804383f, -0.0131587f, 0.593966f, -0.422838f, -0.861638f, 0.280690f, 
		0.0944571f, -0.929709f, 0.355976f, 0.831570f, -0.108367f, 0.544746f, 
		0.418859f, -0.482961f, -0.768965f, 0.340465f, -0.642672f, -0.686336f, 
		0.465415f, -0.0287156f, -0.884627f, 0.422154f, 0.170277f, -0.890389f, 
		-0.146729f, 0.900520f, -0.409310f, 0.942999f, -0.330903f, -0.0354551f, 
		0.933194f, -0.355591f, 0.0519916f, 0.815143f, -0.401298f, 0.417733f, 
		-0.815012f, 0.536596f, -0.218679f, -0.839590f, 0.526620f, 0.133269f, 
		-0.816903f, 0.481400f, 0.317686f, -0.863495f, 0.487573f, 0.129031f, 
		-0.860196f, 0.457499f, -0.225295f, 0.854801f, -0.0731970f, -0.513768f, 
		0.484477f, -0.373927f, -0.790861f, -0.889816f, -0.272292f, -0.366176f, 
		-0.754166f, -0.388456f, -0.529467f, -0.655776f, -0.455705f, -0.601907f, 
		-0.578231f, 0.320809f, -0.750154f, -0.516848f, 0.507739f, -0.689253f, 
		-0.696303f, 0.393000f, -0.600593f, -0.828760f, -0.0437713f, -0.557890f, 
		-0.896946f, -0.198832f, -0.394910f, -0.915968f, 0.00448460f, -0.401227f, 
		0.761267f, -0.0857277f, -0.642746f, 0.940008f, -0.000576357f, -0.341152f, 
		0.500792f, -0.261531f, -0.825112f, -0.750396f, 0.574547f, -0.326805f, 
		-0.575502f, 0.663748f, 0.477741f, -0.446983f, 0.835750f, 0.318948f, 
		-0.328713f, 0.917927f, 0.222168f, 0.744928f, 0.197015f, -0.637390f, 
		0.782615f, 0.537551f, -0.313930f, 0.551269f, 0.000358909f, 0.834327f, 
		-0.669802f, 0.547184f, 0.501951f, -0.446093f, 0.854100f, -0.267423f, 
		-0.743919f, -0.494650f, -0.449340f, -0.591669f, -0.699417f, -0.400929f, 
		-0.333643f, -0.939425f, -0.0785092f, -0.277571f, -0.959073f, 0.0559799f, 
		0.606401f, -0.748201f, -0.269210f, -0.306328f, -0.500751f, 0.809575f, 
		-0.461371f, -0.202285f, 0.863839f, -0.471460f, 0.674600f, 0.568014f, 
		0.764457f, -0.256335f, -0.591522f, 0.0696528f, 0.965763f, -0.249899f, 
		0.483896f, 0.0792784f, -0.871527f, -0.403087f, -0.0667139f, -0.912727f, 
		0.259735f, -0.923205f, 0.283251f, 0.595398f, -0.637197f, -0.489369f, 
		0.153111f, -0.915322f, 0.372483f, -0.115926f, -0.860456f, 0.496161f, 
		-0.512358f, -0.220529f, 0.829973f, 0.508223f, -0.0602239f, -0.859117f, 
		-0.741141f, 0.356757f, 0.568713f, -0.668772f, 0.208332f, 0.713682f, 
		-0.697318f, 0.267934f, 0.664800f, 0.793097f, -0.410949f, 0.449575f, 
		0.112909f, -0.142019f, 0.983403f, -0.312328f, -0.0479009f, 0.948766f, 
		-0.263491f, -0.149290f, 0.953040f, -0.915412f, -0.172509f, -0.363678f, 
		-0.145594f, -0.811774f, 0.565531f, 0.945435f, -0.0505080f, -0.321872f, 
		-0.369190f, 0.851338f, 0.372723f, -0.196282f, 0.968684f, 0.152066f, 
		-0.547734f, 0.638541f, 0.540605f, -0.105411f, 0.994376f, -0.0102818f, 
		0.658562f, 0.749421f, 0.0682954f, 0.774659f, 0.528117f, 0.347845f, 
		-0.171642f, 0.122085f, -0.977566f, 0.496228f, -0.299042f, -0.815065f, 
		-0.647309f, 0.256680f, 0.717709f, -0.695398f, 0.125853f, 0.707518f, 
		-0.532833f, 0.547290f, 0.645417f, -0.609902f, 0.444331f, 0.656193f, 
		-0.503575f, 0.681603f, 0.530877f, -0.671007f, -0.0487784f, 0.739845f, 
		-0.486611f, 0.665719f, -0.565710f, -0.572927f, 0.703426f, -0.420650f, 
		-0.154537f, 0.896193f, -0.415880f, -0.0663752f, 0.971720f, -0.226614f, 
		-0.376094f, 0.880128f, -0.289702f, 0.849375f, -0.101449f, -0.517947f, 
		0.979503f, 0.104976f, 0.171915f, -0.301043f, -0.105455f, 0.947762f, 
		-0.639135f, 0.608470f, 0.470394f, 0.918585f, -0.0965292f, 0.383255f, 
		0.894490f, 0.0393652f, 0.445351f, -0.720198f, 0.00425544f, 0.693755f, 
		-0.395492f, -0.872695f, 0.286339f, -0.187665f, 0.104160f, -0.976695f, 
		-0.795044f, 0.457096f, -0.398708f, 0.980348f, -0.138596f, 0.140388f, 
		0.917974f, -0.124233f, -0.376682f, 0.993539f, -0.113488f, -0.000534455f, 
		0.931739f, -0.0564302f, 0.358716f, 0.761302f, -0.0487443f, -0.646562f, 
		-0.159639f, -0.971159f, 0.177106f, 0.828536f, -0.357531f, 0.430928f, 
		0.907582f, -0.389746f, -0.156180f, 0.857533f, -0.390739f, -0.334606f, 
		0.914742f, -0.379308f, 0.139189f, 0.904498f, -0.339715f, 0.257831f, 
		0.923924f, -0.381013f, -0.0345581f, -0.371248f, 0.784592f, -0.496579f, 
		0.834396f, -0.0926477f, 0.543322f, 0.938719f, -0.301972f, 0.166189f, 
		0.481366f, 0.135719f, -0.865948f, 0.540590f, -0.0451025f, -0.840076f, 
		0.622783f, -0.489118f, -0.610659f, 0.615483f, -0.602871f, -0.507668f, 
		0.725782f, -0.666703f, -0.169550f, 0.641543f, -0.588614f, -0.491889f, 
		0.230660f, -0.950892f, 0.206398f, 0.529542f, 0.159889f, -0.833079f, 
		0.260626f, 0.850468f, -0.456923f, 0.995621f, -0.0624443f, 0.0695636f, 
		0.603316f, 0.756109f, -0.253594f, -0.207427f, -0.686723f, -0.696696f, 
		-0.0496177f, 0.395118f, -0.917290f, -0.355885f, -0.490559f, -0.795423f, 
		0.311708f, 0.224788f, -0.923205f, 0.0909794f, 0.322411f, -0.942217f, 
		0.162636f, -0.964942f, 0.206002f, 0.978348f, 0.0885210f, -0.187080f, 
		0.491159f, -0.00970044f, -0.871016f, 0.588264f, 0.387385f, -0.709844f, 
		-0.300579f, 0.871409f, 0.387682f, -0.199342f, 0.971461f, 0.128556f, 
		-0.268853f, 0.910872f, 0.313097f, 0.00682636f, -0.991822f, 0.127446f, 
		0.451175f, -0.683148f, -0.574238f, 0.912923f, -0.00860966f, 0.408041f, 
		0.834504f, -0.148574f, -0.530593f, 0.223529f, -0.638048f, 0.736837f, 
		-0.313370f, -0.0971585f, 0.944648f, -0.0759798f, -0.973719f, 0.214707f, 
		-0.200688f, -0.264701f, 0.943217f, -0.660332f, 0.544769f, 0.516903f, 
		-0.328510f, 0.925059f, -0.190650f, 0.591194f, -0.697229f, -0.405415f, 
		0.576289f, -0.00822975f, 0.817204f, 0.884807f, 0.0152858f, 0.465707f, 
		-0.582207f, -0.0910437f, 0.807927f, -0.00191416f, -0.731624f, 0.681706f, 
		-0.0266164f, 0.589361f, -0.807431f, -0.00690001f, 0.309847f, -0.950761f, 
		-0.125232f, 0.670034f, -0.731691f, 0.947180f, -0.0759270f, -0.311584f, 
		0.701382f, 0.219711f, 0.678079f, 0.443321f, 0.240295f, 0.863553f, 
		0.184372f, 0.244948f, 0.951844f, 0.0640981f, 0.960842f, -0.269583f, 
		-0.288780f, 0.0847638f, 0.953636f, 0.306468f, -0.266003f, 0.913958f, 
		-0.894279f, -0.441097f, 0.0754909f, -0.145901f, -0.0315557f, 0.988796f, 
		0.573033f, -0.368075f, 0.732225f, -0.628796f, 0.591948f, 0.504196f, 
		-0.365595f, -0.154786f, 0.917814f, 0.993688f, -0.0827885f, 0.0756965f, 
		0.464497f, 0.382543f, -0.798689f, -0.405208f, 0.122192f, -0.906022f, 
		0.897227f, 0.148997f, 0.415673f, -0.221237f, -0.106639f, 0.969372f, 
		-0.00365605f, 0.624005f, -0.781411f, 0.360293f, 0.299790f, -0.883354f, 
		0.442782f, 0.118736f, -0.888732f, -0.116420f, 0.697535f, -0.707030f, 
		0.698203f, -0.550993f, 0.457076f, 0.0659570f, -0.202299f, 0.977100f, 
		0.881749f, -0.465383f, -0.0770608f, 0.700154f, 0.322913f, 0.636798f, 
		0.298345f, 0.619520f, 0.726075f, 0.649207f, 0.412003f, 0.639362f, 
		0.0993677f, 0.967703f, -0.231681f, 0.702482f, -0.447637f, -0.553299f, 
		0.843361f, -0.0674753f, 0.533095f, -0.324098f, 0.679808f, 0.657892f, 
		-0.638773f, -0.168678f, 0.750677f, -0.608661f, -0.102235f, 0.786816f, 
		-0.534336f, -0.828514f, 0.167483f, 0.534191f, 0.844067f, -0.0468093f, 
		0.973844f, 0.134039f, 0.183472f, -0.0325776f, -0.997915f, 0.0557144f, 
		0.553450f, -0.637060f, -0.536514f, 0.909033f, 0.0250444f, 0.415970f, 
		-0.0100579f, -0.957476f, -0.288338f, -0.737857f, 0.588444f, -0.330607f, 
		-0.771163f, 0.634645f, -0.0503431f, -0.764659f, 0.641912f, 0.0569622f, 
		0.261769f, -0.660001f, -0.704185f, 0.0186097f, -0.897451f, -0.440721f, 
		0.154141f, -0.771715f, -0.617006f, -0.190416f, -0.975505f, -0.110149f, 
		0.621740f, 0.730966f, -0.281297f, 0.375020f, -0.725557f, 0.576999f, 
		0.827858f, -0.178373f, -0.531821f, 0.800392f, -0.590749f, -0.101922f, 
		-0.193075f, 0.875054f, -0.443849f, 0.588264f, 0.387385f, -0.709844f, 
		0.0940926f, -0.736435f, 0.669933f, -0.392705f, -0.177365f, 0.902399f, 
		-0.633125f, 0.306791f, -0.710656f, -0.773422f, 0.573427f, -0.270185f, 
		-0.502796f, 0.115868f, -0.856604f, -0.786121f, 0.607067f, -0.116117f, 
		0.949726f, -0.0762608f, -0.303651f, 0.589828f, 0.151890f, -0.793116f, 
		0.220751f, 0.852159f, -0.474441f, 0.700389f, -0.552013f, 0.452478f, 
		0.752741f, -0.545716f, -0.368205f, 0.539368f, -0.529223f, -0.654985f, 
		0.581576f, -0.000298765f, -0.813492f, 0.499990f, -0.654483f, -0.567153f, 
		0.571853f, 0.152718f, -0.806016f, -0.273412f, 0.0944116f, -0.957252f, 
		0.455555f, -0.313317f, -0.833248f, -0.161292f, 0.855496f, 0.492049f, 
		-0.0504476f, 0.920836f, 0.386672f, -0.0887444f, 0.887013f, 0.453137f, 
		-0.293962f, 0.662084f, 0.689370f, 0.0413633f, 0.950349f, 0.308424f, 
		0.310933f, -0.471357f, -0.825314f, 0.183413f, -0.614036f, -0.767672f, 
		0.476437f, -0.00988117f, -0.879153f, 0.479732f, 0.199343f, -0.854470f, 
		0.0654937f, -0.474444f, 0.877846f, 0.135756f, -0.540627f, 0.830237f, 
		-0.0302267f, -0.389300f, 0.920615f, 0.0360177f, 0.917204f, 0.396786f, 
		0.923891f, 0.0200240f, 0.382131f, 0.364904f, 0.507499f, -0.780570f, 
		0.387736f, 0.227774f, -0.893185f, 0.344554f, 0.396737f, -0.850813f, 
		0.366539f, 0.654901f, -0.660873f, 0.378702f, 0.730112f, -0.568790f, 
		0.299286f, 0.844664f, -0.443813f, 0.993865f, -0.0875154f, 0.0676267f, 
		0.673087f, 0.739379f, 0.0165278f, 0.933104f, -0.184281f, 0.308801f, 
		-0.520669f, -0.374677f, 0.767152f, -0.580318f, -0.188611f, 0.792248f, 
		-0.401557f, -0.748300f, 0.528015f, -0.340773f, -0.862647f, 0.373783f, 
		-0.233340f, 0.456644f, 0.858504f, -0.625413f, 0.568020f, 0.534988f, 
		-0.478968f, 0.552946f, 0.681792f, 0.697628f, -0.688705f, -0.197488f, 
		0.716774f, -0.545770f, -0.434017f, 0.620050f, -0.260652f, -0.739999f, 
		0.696731f, -0.459954f, -0.550462f, 0.424975f, 0.0696780f, -0.902519f, 
		-0.309153f, -0.117484f, 0.943728f, -0.917160f, -0.139426f, -0.373332f, 
		0.642603f, 0.138937f, 0.753498f, 0.840032f, -0.0515558f, 0.540082f, 
		0.722657f, -0.538786f, -0.432986f, 0.501273f, -0.805932f, 0.314959f, 
		-0.722641f, 0.452070f, 0.522899f, -0.644991f, 0.673166f, -0.361709f, 
		-0.395326f, -0.918215f, 0.0244691f, -0.316573f, 0.668008f, 0.673458f, 
		-0.522594f, -0.187992f, 0.831598f, 0.606066f, -0.545721f, -0.578682f, 
		-0.699223f, 0.583173f, -0.413517f, -0.0271821f, 0.982536f, -0.184079f, 
		-0.931836f, -0.347363f, 0.104980f, 0.734551f, 0.0547916f, 0.676338f, 
		0.946679f, -0.104426f, -0.304784f, -0.990790f, -0.0257299f, -0.132943f, 
		-0.811912f, 0.258426f, -0.523465f, -0.981823f, -0.183729f, -0.0476159f, 
		0.797379f, -0.174671f, -0.577648f, 0.543902f, 0.186726f, -0.818110f, 
		-0.358230f, 0.288997f, -0.887779f, 0.247924f, -0.818836f, 0.517726f, 
		0.920002f, -0.0157928f, 0.391595f, -0.486686f, 0.205141f, 0.849149f, 
		-0.275175f, 0.00847714f, 0.961357f, -0.630141f, 0.403018f, 0.663701f, 
		-0.706383f, 0.487213f, 0.513465f, 0.649963f, 0.121340f, -0.750217f, 
		0.755617f, -0.524140f, 0.392836f, -0.0227331f, -0.275863f, 0.960928f, 
		0.329876f, 0.940854f, -0.0773078f, -0.306227f, -0.948781f, 0.0777217f, 
		0.526395f, 0.137775f, -0.839003f, -0.0808316f, 0.728430f, -0.680335f, 
		0.297795f, -0.677376f, -0.672666f, -0.227147f, -0.972071f, -0.0590048f, 
		0.306998f, -0.401430f, -0.862906f, -0.560016f, -0.0203984f, -0.828230f, 
		0.129070f, -0.892012f, -0.433192f, 0.572793f, 0.0341731f, -0.818988f, 
		-0.330803f, 0.0552751f, -0.942080f, -0.523823f, 0.591054f, -0.613405f, 
		-0.0912902f, -0.974946f, 0.202846f, -0.332179f, -0.0711871f, 0.940526f, 
		-0.916599f, -0.121185f, -0.380998f, 0.994867f, -0.0785700f, 0.0637697f, 
		0.447233f, -0.735678f, 0.508685f, -0.709547f, -0.204712f, 0.674268f, 
		-0.571194f, -0.173771f, 0.802210f, 0.314913f, -0.373047f, 0.872735f, 
		-0.950275f, -0.291310f, 0.110073f, -0.912902f, -0.276932f, 0.299866f, 
		-0.351485f, 0.791656f, 0.499738f, -0.263081f, 0.781263f, 0.566054f, 
		0.0433975f, 0.948968f, 0.312373f, 0.142300f, 0.978318f, 0.150485f, 
		-0.00920886f, 0.961903f, 0.273235f, -0.411848f, 0.658280f, 0.630118f, 
		0.979183f, 0.159619f, -0.125391f, 0.472693f, 0.0696956f, -0.878467f, 
		0.105380f, 0.0520948f, 0.993066f, -0.245856f, 0.187465f, 0.951006f, 
		-0.131908f, 0.129506f, 0.982766f, 0.799682f, 0.587760f, -0.122664f, 
		-0.791564f, 0.327082f, 0.516182f, -0.821397f, 0.422507f, -0.383138f, 
		0.578012f, -0.460627f, -0.673592f, 0.826731f, -0.0613096f, 0.559246f, 
		0.0558498f, -0.597946f, 0.799588f, -0.0587874f, -0.501055f, 0.863416f, 
		-0.0132836f, -0.533023f, 0.845996f, 0.504822f, 0.814089f, -0.287078f, 
		0.607970f, 0.140092f, -0.781503f, 0.360515f, -0.901162f, 0.240700f, 
		0.672514f, -0.583309f, -0.455495f, 0.660580f, -0.732937f, 0.162596f, 
		0.729385f, -0.671810f, -0.129108f, 0.740175f, -0.531332f, -0.412101f, 
		0.583758f, -0.740396f, 0.333227f, 0.646394f, -0.739236f, -0.188956f, 
		-0.275628f, -0.350627f, 0.895036f, -0.753630f, -0.654715f, 0.0582240f, 
		-0.955405f, 0.228930f, 0.186525f, -0.946390f, 0.234405f, -0.222264f, 
		-0.973483f, 0.225982f, 0.0355273f, 0.663230f, -0.500866f, -0.556110f, 
		0.485891f, 0.0875224f, -0.869626f, 0.668777f, -0.597021f, -0.443061f, 
		0.624494f, -0.280475f, -0.728932f, 0.406735f, -0.657502f, -0.634238f, 
		-0.234408f, -0.963379f, -0.130203f, 0.305652f, -0.909316f, 0.282350f, 
		0.828989f, 0.000353014f, 0.559265f, 0.828585f, 0.133814f, 0.543637f, 
		0.895536f, 0.0296890f, 0.443998f, -0.691926f, 0.000465516f, -0.721968f, 
		-0.762954f, -0.147432f, -0.629417f, -0.234325f, -0.404082f, -0.884200f, 
		-0.755700f, -0.0540440f, -0.652685f, -0.668233f, -0.133225f, -0.731926f, 
		0.932671f, -0.160201f, -0.323202f, -0.609161f, -0.727553f, -0.315577f, 
		-0.601099f, -0.778189f, -0.181941f, -0.944548f, 0.261894f, -0.198091f, 
		-0.500855f, -0.125181f, -0.856431f, -0.519790f, -0.352138f, -0.778342f, 
		0.624806f, -0.465127f, -0.627116f, -0.711291f, 0.398760f, -0.578841f, 
		-0.812880f, 0.549507f, -0.193049f, -0.792367f, 0.529228f, -0.303435f, 
		0.795007f, -0.110109f, -0.596524f, 0.650976f, -0.342453f, -0.677464f, 
		0.174067f, -0.402396f, 0.898765f, -0.126409f, -0.144296f, 0.981427f, 
		0.0173671f, -0.281373f, 0.959441f, -0.673286f, 0.639345f, 0.371381f, 
		-0.733998f, 0.335051f, 0.590752f, -0.946960f, 0.206600f, -0.246138f, 
		-0.463489f, 0.867276f, 0.181687f, -0.545496f, 0.325606f, -0.772279f, 
		-0.645865f, 0.293729f, -0.704686f, -0.797292f, 0.220250f, -0.561975f, 
		-0.913954f, 0.259231f, -0.312229f, -0.601416f, 0.214536f, -0.769593f, 
		-0.746330f, 0.344573f, -0.569439f, -0.977081f, 0.210973f, -0.0283518f, 
		-0.920473f, 0.217387f, 0.324765f, -0.972450f, 0.188517f, -0.137123f, 
		-0.975239f, 0.213618f, 0.0572370f, -0.951396f, 0.224561f, 0.210754f, 
		0.669984f, -0.733626f, 0.113644f, 0.781213f, -0.624256f, 0.00320189f, 
		0.838489f, -0.541650f, -0.0595951f, 0.935963f, 0.177142f, 0.304292f, 
		0.878169f, -0.476738f, 0.0392365f, 0.878917f, -0.325665f, 0.348493f, 
		0.828689f, -0.490764f, -0.269121f, -0.0952066f, -0.975375f, 0.198947f, 
		-0.917627f, -0.122827f, -0.377987f, -0.0548183f, -0.558055f, -0.827991f, 
		0.165904f, -0.339152f, 0.925987f, 0.224370f, -0.942385f, 0.248130f, 
		0.944999f, -0.279394f, 0.170045f, -0.330172f, 0.462485f, -0.822857f, 
		0.416169f, -0.0129652f, -0.909195f, 0.992670f, -0.0917797f, 0.0786286f, 
		0.733486f, -0.670272f, -0.112846f, -0.893693f, 0.0415768f, -0.446748f, 
		-0.967264f, 0.133652f, -0.215723f, -0.634051f, -0.00988876f, -0.773228f, 
		-0.475043f, -0.0796893f, -0.876347f, -0.0873710f, -0.974487f, 0.206738f, 
		0.898834f, -0.107942f, 0.424789f, -0.332266f, -0.0711546f, 0.940498f, 
		0.817916f, 0.492183f, 0.297941f, -0.589554f, 0.569374f, 0.572922f, 
		-0.161995f, 0.984399f, -0.0686804f, -0.541508f, 0.270076f, 0.796133f, 
		0.589234f, -0.801943f, 0.0984395f, 0.679194f, -0.524534f, 0.513380f, 
		0.269191f, -0.226655f, 0.936036f, 0.659093f, -0.709449f, 0.249556f, 
		0.100362f, -0.195050f, 0.975645f, 0.296925f, 0.948416f, -0.111098f, 
		0.649963f, 0.121340f, -0.750217f, -0.872783f, 0.165555f, -0.459174f, 
		-0.946390f, 0.234405f, -0.222264f, -0.804373f, 0.107997f, -0.584227f, 
		-0.447762f, 0.887837f, -0.106088f, -0.0359923f, 0.647853f, -0.760914f, 
		-0.915415f, -0.172516f, -0.363666f, 0.123672f, -0.321601f, -0.938764f, 
		0.143286f, -0.988355f, -0.0512191f, -0.531121f, 0.624793f, 0.572315f, 
		-0.447089f, -0.205739f, 0.870507f, -0.442620f, -0.811045f, -0.382484f, 
		0.808159f, -0.582129f, 0.0894669f, 0.858798f, -0.469454f, 0.205129f, 
		0.913056f, -0.336689f, 0.230149f, 0.425579f, -0.542766f, -0.724077f, 
		0.617879f, -0.0264460f, -0.785829f, 0.351313f, -0.662617f, -0.661451f, 
		0.646955f, 0.125123f, -0.752192f, 0.892334f, -0.00690219f, 0.451323f, 
		-0.701219f, -0.711980f, 0.0371071f, -0.759809f, 0.117878f, 0.639371f, 
		0.870057f, -0.145316f, 0.471046f, -0.331873f, -0.0913466f, 0.938891f, 
		0.724939f, -0.635816f, -0.264955f, -0.954946f, -0.185594f, -0.231587f, 
		-0.735528f, -0.597536f, -0.319296f, -0.0170466f, -0.692625f, -0.721096f, 
		-0.539859f, -0.730538f, -0.418170f, 0.290574f, -0.629157f, -0.720922f, 
		0.879958f, -0.433734f, -0.193776f, 0.620160f, -0.493438f, -0.609853f, 
		0.798840f, 0.204255f, -0.565804f, 0.784194f, 0.0817241f, -0.615110f, 
		0.732911f, 0.601782f, -0.317332f, 0.808853f, 0.348621f, -0.473520f, 
		0.780084f, 0.492647f, -0.385703f, 0.676450f, -0.204438f, -0.707545f, 
		-0.765687f, 0.190712f, -0.614291f, -0.908870f, 0.256550f, -0.328841f, 
		-0.568096f, 0.157936f, -0.807665f, 0.165904f, -0.339152f, 0.925987f, 
		0.915502f, -0.0311622f, 0.401105f, 0.370898f, -0.797230f, 0.476298f, 
		-0.421344f, -0.373249f, 0.826532f, -0.231966f, -0.657976f, 0.716421f, 
		-0.457243f, -0.188584f, 0.869117f, -0.0838940f, -0.810828f, 0.579241f, 
		-0.916738f, -0.156537f, -0.367542f, -0.0487578f, -0.496471f, -0.866683f, 
		-0.397763f, -0.771569f, -0.496454f, -0.691586f, -0.534348f, -0.485985f, 
		-0.586953f, -0.624543f, -0.515202f, 0.812249f, -0.164200f, 0.559723f, 
		-0.211054f, -0.358377f, 0.909408f, -0.0741308f, -0.775642f, 0.626805f, 
		-0.200392f, -0.492772f, 0.846770f, 0.808277f, 0.566710f, -0.159774f, 
		-0.978896f, 0.195321f, -0.0601019f, -0.947375f, 0.192741f, 0.255600f, 
		-0.894806f, 0.183544f, -0.406981f, -0.718274f, 0.468035f, 0.514807f, 
		-0.588408f, 0.735647f, -0.335558f, 0.671505f, 0.116396f, -0.731801f, 
		0.446016f, 0.833898f, -0.325092f, -0.684400f, 0.716495f, 0.135028f, 
		-0.616846f, 0.729096f, 0.296512f, -0.593676f, 0.704642f, 0.388625f, 
		0.662293f, -0.0508240f, -0.747519f, -0.0338601f, 0.949367f, 0.312339f, 
		-0.376454f, 0.806156f, 0.456503f, -0.136156f, 0.912002f, 0.386929f, 
		-0.397069f, -0.803655f, -0.443255f, 0.503396f, -0.859078f, 0.0926174f, 
		-0.560296f, -0.796301f, -0.227977f, -0.450853f, -0.835401f, -0.314384f, 
		0.186034f, 0.913538f, -0.361718f, -0.0912442f, 0.950499f, -0.297029f, 
		-0.00643704f, 0.949264f, -0.314415f, -0.901231f, -0.0338037f, -0.432018f, 
		-0.869101f, 0.157522f, 0.468881f, -0.715999f, 0.147283f, 0.682387f, 
		-0.505497f, 0.444329f, 0.739625f, -0.600203f, 0.304441f, 0.739643f, 
		-0.312331f, 0.635360f, 0.706235f, -0.650434f, 0.220722f, 0.726786f, 
		-0.251691f, -0.498175f, -0.829743f, -0.602558f, 0.203171f, 0.771780f, 
		0.713585f, -0.677083f, -0.179876f, -0.265131f, -0.139488f, 0.954069f, 
		0.515465f, -0.630323f, 0.580507f, 0.394502f, -0.915955f, 0.0734547f, 
		0.438890f, -0.265547f, 0.858406f, -0.772949f, -0.633651f, -0.0321888f, 
		-0.696691f, 0.500573f, 0.513857f, -0.301524f, -0.0329236f, 0.952890f, 
		0.725779f, -0.405574f, -0.555657f, 0.651393f, -0.290286f, -0.701015f, 
		0.617162f, -0.228964f, -0.752786f, -0.856137f, -0.0286903f, -0.515951f, 
		-0.893955f, 0.244293f, 0.375720f, -0.817331f, 0.0924724f, 0.568699f, 
		-0.926706f, 0.0744033f, -0.368347f, -0.843139f, -0.198628f, 0.499664f, 
		-0.972372f, -0.194077f, 0.129718f, -0.718925f, -0.198931f, 0.666013f, 
		0.434814f, -0.119510f, -0.892555f, -0.452314f, 0.0664298f, -0.889381f, 
		-0.873520f, 0.0965702f, 0.477114f, -0.852111f, -0.294502f, -0.432637f, 
		0.802840f, -0.0796066f, 0.590856f, -0.0478303f, 0.997609f, -0.0498939f, 
		0.223557f, 0.917893f, -0.327864f, -0.217238f, 0.975857f, 0.0225984f, 
		0.219095f, 0.801183f, -0.556869f, -0.0350402f, 0.00424840f, 0.999377f, 
		-0.428758f, 0.0745860f, 0.900335f, 0.0862361f, -0.132732f, 0.987393f, 
		-0.172397f, 0.0789079f, 0.981862f, -0.268640f, 0.172961f, 0.947585f, 
		-0.313373f, 0.348375f, 0.883421f, -0.907194f, 0.178905f, 0.380777f, 
		-0.838049f, -0.191513f, -0.510878f, -0.191707f, 0.531896f, 0.824824f, 
		0.945684f, 0.322175f, -0.0434176f, 0.463075f, 0.260421f, -0.847197f, 
		-0.645456f, 0.147667f, -0.749387f, 0.510082f, -0.804978f, 0.303028f, 
		0.677323f, -0.721088f, -0.145828f, 0.709075f, -0.568601f, -0.417021f, 
		0.591913f, -0.794001f, 0.138570f, -0.0912902f, -0.974946f, 0.202846f, 
		0.897634f, -0.0997290f, 0.429310f, -0.0547788f, -0.558052f, -0.827996f, 
		-0.698536f, 0.0736859f, -0.711771f, -0.718501f, 0.220536f, -0.659637f, 
		-0.730517f, 0.430956f, -0.529738f, 0.650976f, -0.342453f, -0.677464f, 
		0.137194f, 0.166369f, -0.976473f, -0.169212f, -0.136902f, -0.976025f, 
		-0.353486f, -0.235218f, -0.905384f, 0.201193f, 0.456700f, -0.866572f, 
		-0.731654f, 0.190345f, 0.654561f, -0.569322f, 0.155534f, 0.807268f, 
		-0.798053f, 0.212997f, 0.563687f, 0.985488f, -0.141139f, 0.0943033f, 
		0.912374f, -0.193364f, -0.360812f, -0.272171f, -0.194028f, 0.942484f, 
		-0.444121f, -0.127954f, 0.886783f, -0.668213f, -0.0661478f, 0.741023f, 
		-0.962615f, -0.130357f, -0.237444f, -0.783140f, -0.615179f, -0.0908150f, 
		-0.693413f, -0.0274332f, 0.720018f, 0.0641218f, -0.906921f, 0.416392f, 
		0.933342f, 0.262540f, 0.244837f, 0.631515f, -0.710495f, 0.310461f, 
		0.772652f, -0.634476f, 0.0211835f, 0.791394f, -0.442363f, -0.421912f, 
		0.834879f, -0.492017f, -0.246772f, 0.209045f, 0.0862844f, 0.974092f, 
		0.877059f, -0.00250109f, 0.480377f, 0.0924392f, -0.0800226f, 0.992498f, 
		0.0244043f, -0.0311418f, 0.999217f, -0.0639838f, 0.0513635f, 0.996628f, 
		-0.463265f, 0.659385f, -0.592112f, -0.791479f, -0.0485578f, -0.609264f, 
		-0.558990f, 0.802631f, 0.208119f, -0.658652f, 0.751482f, -0.0381105f, 
		-0.750057f, 0.580024f, -0.317783f, 0.398706f, -0.212262f, 0.892176f, 
		0.173265f, 0.161488f, 0.971546f, -0.00623201f, 0.178906f, 0.983846f, 
		0.0838171f, 0.218501f, 0.972230f, 0.0831904f, 0.130889f, 0.987900f, 
		-0.210027f, -0.00743706f, 0.977667f, -0.732156f, 0.0997293f, -0.673796f, 
		-0.692629f, -0.0752580f, -0.717357f, -0.397570f, 0.894698f, -0.203599f, 
		-0.805665f, 0.387767f, -0.447817f, -0.208233f, 0.974941f, -0.0782943f, 
		0.279290f, -0.935802f, -0.215110f, -0.652363f, 0.102768f, 0.750907f, 
		-0.720061f, 0.116835f, 0.684005f, -0.880914f, 0.120712f, 0.457624f, 
		0.428417f, -0.231136f, -0.873519f, -0.426811f, 0.0308651f, -0.903814f, 
		0.201408f, -0.0602596f, 0.977652f, 0.892646f, 0.0336598f, 0.449500f, 
		0.594621f, 0.143536f, -0.791090f, 0.101502f, 0.821680f, -0.560838f, 
		-0.812603f, -0.0731680f, -0.578206f, 0.238499f, -0.132310f, 0.962088f, 
		-0.0458395f, -0.988915f, 0.141232f, 0.902358f, -0.0256505f, 0.430224f, 
		-0.141897f, -0.702771f, -0.697122f, -0.501282f, -0.792162f, -0.348132f, 
		-0.0311726f, -0.623452f, -0.781240f, -0.794975f, 0.333862f, 0.506509f, 
		-0.793114f, 0.461346f, -0.397656f, -0.645193f, -0.672793f, 0.362044f, 
		-0.601839f, -0.775780f, 0.189617f, -0.708450f, -0.105740f, 0.697794f, 
		-0.691556f, -0.304211f, 0.655138f, 0.904064f, 0.229625f, 0.360473f, 
		-0.716185f, -0.632069f, -0.295919f, -0.773278f, -0.503326f, -0.385621f, 
		-0.759153f, -0.566255f, -0.321002f, -0.519094f, 0.247279f, 0.818165f, 
		-0.425106f, 0.233398f, 0.874534f, -0.586577f, 0.246158f, 0.771579f, 
		-0.701194f, 0.239089f, 0.671687f, -0.782187f, 0.189357f, 0.593572f, 
		0.676460f, -0.204461f, -0.707530f, 0.656565f, 0.0932450f, 0.748483f, 
		0.328762f, 0.145880f, 0.933078f, -0.562363f, 0.746605f, -0.355427f, 
		0.727982f, 0.0856878f, 0.680220f, 0.362912f, 0.794603f, -0.486725f, 
		0.626311f, 0.681747f, -0.378095f, 0.262467f, 0.464704f, -0.845672f, 
		0.637871f, 0.520086f, -0.568006f, 0.215945f, 0.644974f, -0.733060f, 
		-0.324746f, -0.0975383f, 0.940758f, -0.0245803f, -0.326584f, 0.944848f, 
		-0.163693f, -0.186138f, 0.968792f, 0.0504315f, -0.366776f, 0.928941f, 
		0.132920f, -0.451172f, 0.882483f, -0.623250f, 0.239923f, 0.744309f, 
		-0.243543f, 0.286642f, 0.926565f, -0.897894f, 0.177492f, 0.402844f, 
		-0.821963f, 0.214749f, 0.527504f, 0.567699f, -0.632847f, -0.526520f, 
		0.157870f, -0.980811f, 0.114396f, 0.775608f, 0.452084f, -0.440514f, 
		-0.671895f, -0.707416f, -0.219362f, -0.434240f, -0.225314f, 0.872163f, 
		-0.158502f, -0.639253f, 0.752484f, -0.0960538f, -0.712946f, 0.694609f, 
		0.676630f, -0.276103f, -0.682597f, -0.0736510f, 0.0566363f, 0.995675f, 
		-0.867453f, 0.137413f, 0.478167f, 0.662293f, -0.0508240f, -0.747519f, 
		0.581970f, -0.530053f, -0.616729f, 0.546600f, 0.120324f, -0.828704f, 
		0.592609f, -0.286121f, -0.752960f, 0.560155f, -0.643555f, -0.521597f, 
		0.277360f, -0.00459719f, 0.960755f, 0.0112986f, 0.0558993f, 0.998372f, 
		0.0971680f, 0.0379488f, 0.994544f, -0.821583f, 0.281309f, 0.495850f, 
		-0.950839f, 0.117083f, -0.286700f, -0.925600f, 0.269954f, 0.265310f, 
		-0.980365f, 0.170731f, -0.0986712f, 0.400738f, 0.914307f, 0.0587508f, 
		0.862795f, 0.484997f, 0.142701f, 0.235546f, -0.970928f, 0.0426163f, 
		-0.643303f, -0.131594f, 0.754218f, -0.572838f, 0.0380199f, 0.818786f, 
		-0.358448f, 0.442124f, 0.822217f, -0.258791f, 0.601051f, 0.756152f, 
		-0.829865f, -0.338453f, -0.443591f, -0.939331f, -0.0670835f, -0.336387f, 
		-0.860998f, -0.253130f, -0.441145f, -0.708754f, 0.209713f, -0.673564f, 
		-0.857660f, 0.167470f, -0.486181f, -0.723206f, 0.377216f, -0.578516f, 
		-0.532829f, 0.377579f, -0.757316f, -0.526038f, -0.846649f, -0.0804266f, 
		-0.375805f, -0.914186f, -0.151769f, -0.727421f, -0.671540f, -0.141041f, 
		-0.561924f, -0.790062f, -0.245038f, 0.462186f, 0.00242352f, -0.886780f, 
		0.583310f, 0.147805f, -0.798688f, 0.517101f, -0.0297077f, -0.855409f, 
		0.151285f, -0.335337f, -0.929872f, 0.0531117f, -0.485226f, -0.872774f, 
		0.223642f, -0.386466f, -0.894778f, 0.632985f, -0.237114f, 0.736958f, 
		0.837865f, -0.284348f, 0.465969f, 0.413958f, -0.212964f, 0.885034f, 
		0.513643f, -0.294409f, 0.805912f, 0.736090f, -0.378758f, 0.560994f, 
		-0.572804f, -0.415617f, -0.706511f, -0.194624f, 0.599771f, 0.776142f, 
		-0.0873041f, 0.713104f, 0.695601f, 0.163425f, 0.816697f, 0.553442f, 
		0.239821f, 0.856196f, 0.457618f, 0.0965270f, 0.783875f, 0.613370f, 
		0.234993f, -0.349321f, -0.907057f, -0.383926f, -0.220999f, -0.896527f, 
		0.0194185f, -0.942442f, -0.333805f, -0.532915f, -0.147242f, -0.833260f, 
		0.426114f, -0.304668f, -0.851824f, -0.665793f, 0.359037f, 0.654073f, 
		-0.601484f, 0.294082f, 0.742788f, -0.244467f, 0.0953088f, 0.964962f, 
		-0.297329f, 0.529870f, -0.794250f, 0.438801f, 0.00314186f, -0.898579f, 
		-0.791324f, 0.0350808f, -0.610390f, -0.486586f, -0.0782805f, -0.870119f, 
		-0.912077f, 0.0717376f, -0.403695f, -0.547208f, -0.791745f, -0.271482f, 
		0.165184f, -0.551952f, -0.817352f, 0.757602f, 0.0775131f, 0.648098f, 
		0.663639f, 0.182136f, 0.725541f, 0.806047f, 0.00454946f, 0.591834f, 
		0.881364f, -0.453297f, 0.133117f, 0.913932f, -0.311369f, -0.260343f, 
		0.910468f, -0.408486f, -0.0647136f, 0.873353f, -0.203602f, -0.442495f, 
		-0.785254f, -0.230845f, -0.574532f, -0.668043f, -0.248804f, -0.701295f, 
		-0.731734f, -0.262400f, -0.629056f, -0.366401f, -0.0326534f, -0.929884f, 
		0.00152578f, -0.979577f, 0.201062f, 0.603198f, -0.667667f, -0.436318f, 
		-0.231779f, 0.0896908f, 0.968625f, 0.0972040f, 0.181578f, 0.978561f, 
		-0.606888f, 0.0156750f, 0.794633f, -0.752207f, 0.0312631f, 0.658185f, 
		-0.741078f, -0.411339f, -0.530663f, -0.774539f, 0.383086f, -0.503324f, 
		-0.208233f, 0.974941f, -0.0782943f, 0.589327f, 0.334913f, 0.735205f, 
		0.690724f, -0.268337f, -0.671488f, -0.778108f, -0.0925490f, -0.621275f, 
		0.525571f, 0.846046f, -0.0893324f, 0.0661979f, 0.0145024f, 0.997701f, 
		-0.188570f, 0.0726739f, 0.979367f, -0.115074f, 0.0568727f, 0.991727f, 
		-0.789348f, -0.328045f, -0.518956f, 0.108315f, -0.988818f, -0.102500f, 
		-0.237313f, -0.304250f, 0.922559f, -0.777784f, -0.248059f, -0.577511f, 
		-0.215608f, -0.0136289f, 0.976385f, 0.197509f, -0.901380f, 0.385364f, 
		0.461169f, -0.678091f, 0.572290f, -0.550921f, -0.0820094f, -0.830518f, 
		-0.609652f, -0.0972463f, -0.786681f, -0.539101f, 0.281736f, -0.793722f, 
		-0.619049f, 0.0602814f, -0.783035f, -0.941736f, -0.238169f, -0.237503f, 
		0.891670f, -0.147676f, 0.427921f, 0.0643747f, -0.405699f, -0.911737f, 
		-0.583669f, -0.112623f, -0.804143f, -0.898720f, -0.389532f, 0.201414f, 
		-0.396267f, -0.389762f, -0.831299f, 0.0194185f, -0.942442f, -0.333805f, 
		-0.485649f, -0.800158f, -0.351983f, 0.287223f, -0.600849f, -0.745978f, 
		0.813340f, -0.533784f, -0.231413f, -0.411515f, 0.0158226f, -0.911266f, 
		-0.929705f, 0.217145f, -0.297485f, 0.977357f, -0.180883f, 0.109792f, 
		0.273811f, 0.828391f, 0.488668f, -0.149990f, 0.724683f, 0.672560f, 
		-0.339047f, 0.644875f, 0.684970f, 0.397304f, 0.856909f, 0.328415f, 
		-0.956921f, 0.231136f, 0.175721f, -0.942383f, 0.147194f, -0.300412f, 
		-0.967526f, 0.236897f, 0.0881636f, -0.971612f, 0.169749f, -0.164787f, 
		-0.929634f, 0.233127f, 0.285363f, -0.979983f, 0.197868f, 0.0219299f, 
		-0.982351f, 0.176594f, -0.0616484f, -0.704607f, 0.456041f, 0.543650f, 
		-0.480355f, 0.841522f, -0.247185f, 0.767800f, -0.533356f, -0.354984f, 
		0.734003f, -0.535122f, -0.418191f, 0.635086f, -0.308368f, -0.708220f, 
		0.603490f, -0.240413f, -0.760264f, -0.904718f, -0.202229f, 0.374951f, 
		-0.928713f, -0.244393f, -0.278861f, -0.952106f, -0.242481f, 0.186270f, 
		-0.905255f, -0.149343f, -0.397755f, -0.663301f, 0.509647f, 0.547988f, 
		-0.360354f, -0.127091f, 0.924117f, 0.600051f, 0.788931f, 0.132388f, 
		-0.125959f, -0.0916007f, 0.987797f, 0.105046f, -0.0410673f, 0.993619f, 
		-0.200619f, -0.104659f, 0.974063f, -0.919415f, -0.239946f, 0.311612f, 
		-0.719290f, -0.207324f, 0.663053f, -0.836959f, -0.228659f, 0.497207f, 
		-0.235049f, -0.227454f, 0.944995f, -0.767718f, 0.268288f, 0.581919f, 
		-0.647136f, 0.253027f, 0.719161f, -0.535825f, 0.242646f, 0.808712f, 
		-0.706077f, 0.258472f, 0.659278f, -0.594510f, 0.254143f, 0.762869f, 
		0.719302f, -0.351183f, -0.599396f, 0.919912f, -0.243339f, 0.307486f, 
		0.955583f, -0.287047f, -0.0668218f, 0.945777f, -0.285906f, -0.154153f, 
		0.775608f, 0.452084f, -0.440514f, 0.0172270f, 0.171600f, 0.985016f, 
		-0.470988f, 0.0882479f, -0.877714f, 0.408341f, -0.107011f, -0.906536f, 
		0.634664f, -0.616952f, -0.465373f, 0.346861f, -0.909535f, 0.228983f, 
		0.806906f, -0.538973f, -0.241684f, 0.766719f, -0.485153f, -0.420438f, 
		0.677291f, -0.724134f, 0.130027f, 0.577635f, -0.760774f, 0.295908f, 
		-0.603276f, 0.623234f, 0.497632f, -0.718084f, 0.380456f, -0.582759f, 
		0.355853f, -0.0741960f, 0.931592f, 0.764832f, -0.184308f, 0.617303f, 
		0.909478f, -0.243520f, 0.336968f, 0.524121f, -0.122789f, 0.842745f, 
		-0.273420f, -0.833411f, 0.480279f, -0.414799f, -0.666051f, 0.619934f, 
		-0.561744f, -0.353653f, 0.747913f, -0.550013f, -0.170145f, 0.817641f, 
		0.637027f, -0.457303f, -0.620540f, -0.740274f, -0.170448f, 0.650340f, 
		0.180729f, -0.976170f, -0.120122f, -0.802537f, -0.0359935f, -0.595515f, 
		-0.838327f, 0.0316071f, -0.544250f, -0.709533f, -0.0697529f, -0.701211f, 
		-0.646640f, -0.0738638f, -0.759211f, -0.753175f, -0.0240441f, -0.657380f, 
		-0.734502f, 0.526642f, -0.427966f, -0.590767f, 0.805976f, -0.0373761f, 
		-0.724678f, 0.660153f, -0.197585f, 0.917727f, 0.0812201f, 0.388819f, 
		-0.0747573f, 0.996071f, -0.0474712f, -0.533343f, 0.621570f, 0.573756f, 
		-0.479583f, 0.801061f, 0.358192f, -0.0609975f, 0.577159f, 0.814351f, 
		-0.402538f, 0.769155f, 0.496351f, -0.229933f, 0.720444f, 0.654287f, 
		-0.167509f, 0.658370f, 0.733819f, 0.728612f, 0.682049f, -0.0627193f, 
		0.752746f, 0.610534f, -0.246215f, 0.724665f, 0.283474f, -0.628095f, 
		0.694965f, 0.0924627f, -0.713073f, -0.516119f, -0.196237f, 0.833734f, 
		-0.557754f, 0.312711f, 0.768845f, -0.548811f, -0.0516424f, 0.834350f, 
		-0.503116f, 0.624355f, 0.597541f, -0.117046f, 0.0755410f, 0.990249f, 
		-0.149853f, -0.00863214f, 0.988671f, 0.187029f, -0.0964274f, 0.977610f, 
		-0.266106f, 0.0927609f, 0.959470f, 0.315606f, -0.0715674f, 0.946188f, 
		0.473059f, -0.153613f, 0.867536f, -0.654593f, -0.357941f, -0.665872f, 
		-0.0253767f, 0.328763f, 0.944071f, -0.761495f, -0.123641f, -0.636270f, 
		-0.388790f, 0.757017f, -0.525136f, -0.758205f, -0.0174920f, 0.651782f, 
		-0.682197f, 0.0147023f, 0.731020f, -0.717233f, 0.0787527f, 0.692369f, 
		-0.645975f, 0.0638650f, 0.760683f, -0.720754f, -0.0633887f, 0.690287f, 
		-0.631792f, -0.157884f, 0.758888f, -0.759686f, -0.228121f, 0.608964f, 
		-0.760014f, -0.108531f, 0.640781f, -0.780038f, 0.315215f, 0.540536f, 
		-0.787661f, 0.494285f, -0.367793f, 0.702971f, 0.0972576f, -0.704537f, 
		0.514572f, -0.259061f, -0.817376f, 0.325338f, -0.483764f, -0.812482f, 
		0.218668f, -0.579119f, -0.785369f, 0.902940f, 0.420326f, -0.0895852f, 
		-0.404557f, -0.191430f, 0.894253f, -0.213470f, -0.421359f, 0.881412f, 
		-0.249280f, -0.297868f, 0.921485f, 0.0187213f, -0.592107f, 0.805642f, 
		-0.0528440f, -0.501544f, 0.863517f, 0.173620f, -0.656498f, 0.734075f, 
		0.819509f, -0.554395f, -0.145089f, -0.271028f, -0.261500f, 0.926370f, 
		0.917286f, 0.0681570f, 0.392352f, 0.211361f, 0.283096f, 0.935512f, 
		0.0781400f, 0.210530f, 0.974459f, -0.458529f, -0.00689462f, -0.888653f, 
		0.392736f, -0.211672f, -0.894960f, -0.126738f, -0.946236f, 0.297615f, 
		-0.189457f, -0.896502f, 0.400487f, -0.277677f, -0.894553f, 0.350244f, 
		-0.187470f, -0.931840f, 0.310692f, -0.189670f, -0.951520f, 0.242145f, 
		0.301158f, 0.633330f, 0.712880f, 0.0676297f, 0.985027f, -0.158581f, 
		0.877678f, -0.450996f, -0.162124f, 0.128166f, 0.399130f, 0.907893f, 
		-0.0997747f, 0.971812f, -0.213605f, 0.273587f, 0.960125f, -0.0575312f, 
		0.581601f, 0.801679f, 0.138027f, 0.874191f, -0.152791f, -0.460918f, 
		0.913432f, 0.160406f, 0.374048f, -0.931508f, 0.149970f, -0.331363f, 
		-0.954419f, 0.233402f, 0.186033f, -0.834448f, 0.252889f, 0.489636f, 
		-0.967356f, 0.201588f, -0.153574f, 0.425493f, -0.140517f, 0.893986f, 
		0.691214f, -0.261480f, 0.673685f, 0.512256f, -0.160173f, 0.843764f, 
		0.283336f, 0.0945906f, 0.954345f, 0.562790f, -0.822702f, 0.0801842f, 
		0.993506f, 0.0794466f, -0.0814471f, 0.672055f, -0.526955f, -0.520251f, 
		0.609414f, -0.479201f, -0.631650f, 0.874218f, -0.477082f, -0.0902002f, 
		0.756702f, -0.481969f, -0.441711f, 0.795687f, -0.562191f, -0.225439f, 
		0.945494f, -0.325587f, -0.00579231f, 0.719291f, -0.548804f, 0.425951f, 
		0.834814f, -0.435485f, 0.336806f, 0.773415f, -0.411745f, 0.481971f, 
		0.520949f, -0.805941f, 0.281197f, 0.858030f, -0.355410f, -0.370766f, 
		0.228111f, -0.0650728f, 0.971458f, 0.948574f, -0.252256f, -0.191245f, 
		0.985377f, 0.162882f, -0.0500199f, 0.490827f, 0.333600f, -0.804860f, 
		-0.693672f, 0.249890f, -0.675555f, -0.768661f, 0.280279f, -0.574981f, 
		-0.842702f, 0.213123f, -0.494400f, -0.717958f, 0.401714f, -0.568473f, 
		-0.534777f, 0.418572f, -0.734037f, -0.634220f, 0.370046f, -0.678845f, 
		0.468344f, -0.867307f, -0.168617f, 0.994918f, 0.00900314f, -0.100281f, 
		0.562755f, 0.0239273f, -0.826277f, 0.0687764f, 0.989377f, -0.128077f, 
		0.918382f, -0.390067f, -0.0664941f, 0.236668f, -0.120052f, 0.964145f, 
		0.876772f, -0.480707f, 0.0138365f, -0.698206f, -0.0536636f, -0.713883f, 
		-0.630203f, 0.336306f, -0.699816f, -0.665984f, 0.0483874f, -0.744395f, 
		-0.642394f, 0.267613f, 0.718132f, -0.523564f, 0.122109f, 0.843190f, 
		-0.603439f, 0.217252f, 0.767243f, -0.00864344f, -0.709534f, -0.704619f, 
		0.562790f, -0.822702f, 0.0801842f, 0.976282f, -0.00503750f, -0.216445f, 
		0.416147f, 0.111284f, 0.902462f, 0.655944f, -0.284982f, -0.698944f, 
		-0.656459f, -0.338536f, -0.674133f, 0.805008f, -0.437963f, -0.400188f, 
		0.234279f, -0.948727f, -0.212203f, 0.469596f, -0.767312f, -0.436706f, 
		0.0334206f, -0.998858f, -0.0341354f, 0.502158f, -0.644950f, -0.576087f, 
		-0.636089f, 0.385183f, 0.668600f, -0.985428f, 0.0523358f, -0.161840f, 
		-0.728940f, 0.0686491f, -0.681126f, -0.822581f, 0.117335f, -0.556411f, 
		-0.774494f, 0.0989071f, -0.624802f, -0.278581f, -0.128864f, 0.951728f, 
		-0.255630f, 0.958842f, -0.123596f, -0.565602f, 0.556696f, 0.608428f, 
		0.937056f, 0.198489f, 0.287276f, 0.867113f, 0.498108f, 0.00158547f, 
		0.993506f, 0.0794466f, -0.0814471f, 0.939087f, 0.334904f, -0.0771700f, 
		0.180421f, 0.0931630f, 0.979168f, -0.435538f, -0.222399f, 0.872264f, 
		0.520949f, -0.805941f, 0.281197f, -0.964356f, 0.258544f, 0.0563254f, 
		0.0532176f, 0.822106f, -0.566842f, 0.758494f, 0.651488f, 0.0157788f, 
		0.647991f, 0.155957f, -0.745510f, 0.457223f, 0.0312134f, -0.888804f, 
		-0.260586f, 0.600051f, -0.756329f, 0.285454f, -0.420620f, -0.861159f, 
		-0.549587f, -0.245184f, -0.798648f, -0.0278757f, -0.551824f, -0.833495f, 
		0.0939182f, -0.848326f, -0.521078f, -0.407456f, -0.389381f, -0.826052f, 
		-0.912023f, -0.0911175f, -0.399889f, 0.416335f, 0.129009f, 0.900012f, 
		0.873906f, 0.480918f, 0.0707618f, 0.505004f, -0.763449f, 0.402637f, 
		0.246820f, -0.813453f, 0.526663f, 0.327278f, -0.809495f, 0.487449f, 
		0.721311f, -0.384541f, 0.576054f, 0.523846f, -0.381164f, 0.761774f, 
		0.670893f, -0.260538f, 0.694278f, 0.832366f, -0.253530f, 0.492838f, 
		0.283336f, 0.0945906f, 0.954345f, 0.976308f, -0.122349f, -0.178478f, 
		0.959389f, 0.263990f, -0.0994076f, -0.131516f, -0.0653098f, -0.989160f, 
		0.903774f, 0.422597f, -0.0678590f, 0.870430f, 0.202844f, -0.448561f, 
		0.965071f, -0.220601f, -0.141325f, 0.866313f, -0.0928504f, 0.490795f, 
		0.930132f, -0.226386f, -0.289143f, 0.954347f, -0.144702f, 0.261312f, 
		0.398115f, -0.346101f, -0.849540f, -0.845473f, 0.262821f, -0.464866f, 
		0.643628f, 0.433690f, -0.630599f, 0.944586f, 0.0946177f, 0.314334f, 
		-0.260284f, -0.722110f, 0.640944f, -0.305999f, -0.645359f, 0.699911f, 
		-0.351384f, -0.602612f, 0.716511f, 0.291569f, 0.000995501f, 0.956549f, 
		-0.377708f, 0.182625f, 0.907736f, -0.189962f, 0.132385f, 0.972825f, 
		0.466332f, -0.0566232f, 0.882796f, -0.969699f, -0.195012f, -0.147156f, 
		-0.778843f, -0.233185f, -0.582262f, -0.706500f, -0.188945f, -0.682024f, 
		-0.561434f, -0.157452f, -0.812405f, -0.866294f, 0.0337378f, -0.498394f, 
		-0.783086f, 0.0861855f, -0.615913f, -0.837409f, 0.0612165f, -0.543138f, 
		0.864191f, -0.479300f, 0.153117f, 0.922297f, -0.299816f, -0.243884f, 
		0.907192f, -0.418221f, -0.0457667f, 0.861622f, -0.288814f, -0.417365f, 
		0.573211f, -0.00477561f, -0.819394f, 0.497642f, -0.499822f, -0.708894f, 
		0.424946f, -0.652640f, -0.627281f, 0.589027f, 0.154418f, -0.793223f, 
		-0.622208f, 0.199352f, -0.757045f, -0.769781f, 0.228765f, -0.595905f, 
		-0.835976f, 0.232482f, -0.497087f, 0.869378f, 0.0752355f, -0.488387f, 
		0.846503f, -0.123888f, -0.517770f, 0.788118f, 0.512841f, -0.340387f, 
		0.675463f, 0.668956f, -0.310237f, -0.0646142f, 0.939976f, -0.335068f, 
		0.218159f, 0.446750f, 0.867653f, 0.988129f, -0.0695451f, -0.136982f, 
		-0.841700f, -0.0669041f, -0.535785f, -0.835367f, -0.455592f, 0.307568f, 
		0.0647449f, -0.943016f, -0.326386f, -0.504836f, -0.372697f, -0.778613f, 
		-0.219021f, 0.0705016f, 0.973170f, -0.859899f, 0.243945f, 0.448403f, 
		-0.753036f, 0.223197f, 0.618967f, -0.454165f, 0.127138f, 0.881799f, 
		-0.980088f, 0.0754438f, -0.183674f, -0.912908f, 0.154343f, -0.377860f, 
		-0.856636f, -0.510881f, 0.0719377f, -0.990364f, -0.0987165f, -0.0971329f, 
		-0.951727f, 0.0473841f, -0.303265f, -0.997837f, 0.0262497f, 0.0602605f, 
		0.514029f, -0.191521f, -0.836118f, 0.584775f, -0.262282f, -0.767624f, 
		0.642492f, -0.384560f, -0.662811f, 0.647593f, -0.483994f, -0.588535f, 
		0.603568f, -0.335351f, -0.723357f, -0.744010f, -0.355349f, -0.565842f, 
		-0.381995f, -0.151612f, 0.911643f, 0.0558584f, -0.204538f, 0.977264f, 
		0.146134f, -0.257043f, 0.955287f, -0.228805f, -0.189039f, 0.954941f, 
		0.252901f, -0.228144f, 0.940208f, -0.941364f, -0.227414f, -0.249233f, 
		0.751136f, -0.608972f, -0.254849f, 0.724046f, -0.537916f, -0.431746f, 
		0.430519f, -0.870696f, 0.237786f, 0.553691f, -0.828813f, 0.0805919f, 
		0.899262f, 0.416098f, -0.134869f, 0.474013f, -0.860539f, 0.186505f, 
		0.986964f, 0.0365559f, 0.156733f, 0.844943f, -0.514467f, -0.146270f, 
		-0.813513f, -0.156659f, -0.560049f, -0.773852f, 0.0558088f, -0.630903f, 
		0.116809f, -0.224216f, 0.967514f, 0.396548f, -0.354447f, 0.846828f, 
		0.511642f, -0.360105f, 0.780094f, 0.717282f, -0.685411f, 0.125372f, 
		0.157568f, 0.0114756f, 0.987441f, 0.520184f, -0.250987f, -0.816342f, 
		0.666101f, -0.263815f, -0.697647f, 0.728284f, -0.255756f, -0.635760f, 
		0.393933f, 0.233530f, 0.888977f, -0.481839f, 0.151653f, -0.863037f, 
		0.401975f, -0.110455f, -0.908964f, -0.647819f, 0.291450f, 0.703838f, 
		-0.997129f, 0.0640245f, -0.0404392f, -0.844832f, -0.219067f, 0.488128f, 
		-0.964591f, -0.237389f, 0.114939f, -0.726881f, -0.197775f, 0.657669f, 
		0.953879f, -0.284257f, -0.0964981f, 0.848238f, -0.529155f, -0.0220814f, 
		-0.209767f, -0.0245974f, -0.977442f, 0.910754f, -0.409954f, -0.0496575f, 
		0.0385134f, -0.954204f, 0.296669f, -0.937833f, -0.0418187f, -0.344558f, 
		0.581100f, -0.146549f, -0.800529f, 0.975093f, -0.182911f, 0.125446f, 
		0.704771f, -0.108153f, 0.701142f, -0.499974f, 0.116007f, -0.858235f, 
		-0.312260f, -0.0293377f, -0.949544f, 0.573313f, -0.0498577f, -0.817818f, 
		-0.380115f, 0.924421f, 0.0309372f, -0.605033f, 0.196182f, -0.771652f, 
		-0.363472f, -0.244951f, 0.898826f, -0.320919f, -0.347943f, 0.880878f, 
		-0.343087f, -0.440432f, 0.829645f, -0.761800f, -0.479052f, 0.436085f, 
		-0.601150f, -0.275599f, 0.750109f, -0.838811f, 0.0460154f, 0.542475f, 
		-0.0395582f, -0.138768f, 0.989534f, 0.200788f, -0.177361f, 0.963446f, 
		-0.119461f, -0.0241061f, 0.992546f, 0.133451f, -0.135257f, 0.981782f, 
		0.442766f, -0.204134f, 0.873091f, 0.891318f, 0.0279198f, -0.452518f, 
		-0.663407f, 0.468403f, 0.583515f, -0.339989f, 0.927400f, -0.156000f, 
		-0.770309f, -0.237014f, -0.591987f, 0.118295f, 0.843768f, -0.523509f, 
		0.539852f, 0.144413f, -0.829280f, -0.491182f, 0.149885f, 0.858065f, 
		-0.613236f, 0.357139f, 0.704551f, -0.539489f, 0.206525f, 0.816272f, 
		0.640785f, 0.275114f, -0.716734f, 0.973899f, -0.0283645f, 0.225202f, 
		0.720913f, -0.481015f, -0.498908f, 0.526284f, -0.520479f, -0.672404f, 
		0.784605f, -0.504701f, -0.360101f, 0.681609f, -0.576422f, -0.450719f, 
		0.635115f, -0.540592f, -0.551714f, 0.470572f, -0.647757f, -0.599143f, 
		0.576285f, -0.0673026f, 0.814473f, 0.384683f, 0.240293f, 0.891223f, 
		-0.555539f, 0.760205f, 0.336846f, 0.369155f, 0.399841f, 0.838959f, 
		-0.763512f, 0.0700546f, -0.641983f, -0.448727f, -0.459664f, 0.766389f, 
		0.295795f, -0.804133f, -0.515631f, -0.753385f, -0.0824677f, -0.652388f, 
		0.439498f, -0.173556f, -0.881317f, -0.508910f, 0.0997512f, -0.855021f, 
		0.434399f, -0.202747f, 0.877605f, 0.896775f, -0.129920f, -0.422983f, 
		0.0200436f, 0.214241f, 0.976575f, 0.384028f, 0.0551047f, 0.921676f, 
		0.544181f, 0.0689801f, 0.836127f, 0.0846964f, 0.888926f, 0.450153f, 
		-0.0256625f, 0.814271f, 0.579918f, -0.130919f, 0.486037f, 0.864076f, 
		-0.542258f, -0.0561318f, -0.838335f, 0.519307f, -0.501557f, -0.691925f, 
		0.883616f, -0.0501287f, 0.465521f, 0.279882f, -0.269013f, -0.921574f, 
		0.177706f, -0.984084f, 0.000258948f, 0.966982f, -0.236327f, 0.0953744f, 
		0.955585f, -0.265390f, -0.128159f, 0.963470f, -0.264193f, -0.0439118f, 
		0.967802f, -0.251064f, 0.0180688f, 0.920385f, -0.201181f, 0.335287f, 
		0.870430f, 0.202844f, -0.448561f, 0.953615f, 0.235498f, 0.187509f, 
		0.970796f, 0.224039f, -0.0858042f, -0.942953f, -0.0411334f, -0.330376f, 
		-0.645108f, 0.283223f, 0.709662f, -0.997247f, 0.0714989f, -0.0196779f, 
		0.635445f, -0.194053f, 0.747364f, 0.777844f, -0.243562f, 0.579341f, 
		0.727624f, -0.239981f, 0.642630f, 0.826157f, -0.275205f, 0.491657f, 
		0.540582f, -0.176616f, 0.822544f, -0.783165f, 0.301692f, 0.543722f, 
		-0.779912f, 0.535872f, -0.323385f, -0.155326f, -0.512107f, 0.844760f, 
		-0.0546924f, -0.556581f, 0.828991f, -0.193036f, -0.531458f, 0.824796f, 
		-0.210241f, -0.375909f, 0.902492f, -0.426439f, -0.366024f, 0.827150f, 
		-0.310033f, -0.418868f, 0.853481f, 0.602840f, 0.110343f, 0.790195f, 
		-0.868953f, -0.0298279f, -0.493994f, -0.774539f, 0.383086f, -0.503324f, 
		0.681038f, 0.201242f, 0.704052f, 0.787146f, -0.178658f, -0.590325f, 
		-0.301713f, 0.800745f, -0.517472f, -0.498949f, 0.779895f, -0.377907f, 
		-0.0572791f, 0.871526f, -0.486992f, -0.266564f, 0.891356f, -0.366644f, 
		-0.278668f, -0.135445f, 0.950788f, 0.945279f, -0.325700f, -0.0191491f, 
		-0.263459f, -0.0353602f, 0.964022f, 0.861622f, -0.288803f, -0.417373f, 
		-0.648090f, 0.402845f, 0.646294f, 0.191398f, 0.353323f, 0.915713f, 
		-0.726072f, -0.221512f, -0.650963f, -0.574502f, -0.187744f, -0.796681f, 
		0.699831f, -0.289476f, -0.653024f, 0.417943f, 0.354727f, 0.836357f, 
		0.760102f, -0.397640f, 0.513932f, 0.535134f, -0.406837f, 0.740348f, 
		0.582878f, -0.566827f, 0.582203f, 0.462847f, -0.520971f, 0.717190f, 
		0.498909f, 0.283783f, 0.818876f, -0.729473f, 0.188649f, -0.657481f, 
		-0.821044f, 0.172459f, 0.544192f, -0.926010f, 0.241178f, -0.290411f, 
		-0.647870f, 0.0800058f, -0.757537f, -0.596970f, 0.0433146f, -0.801094f, 
		-0.610677f, 0.287847f, -0.737711f, -0.651476f, 0.219655f, -0.726176f, 
		-0.613155f, 0.166941f, -0.772122f, -0.484963f, 0.506291f, -0.713078f, 
		-0.690404f, 0.486056f, -0.535809f, -0.835968f, 0.278626f, -0.472784f, 
		-0.663462f, 0.347455f, -0.662641f, 0.967911f, 0.0742248f, 0.240080f, 
		-0.572773f, 0.162942f, 0.803356f, -0.660713f, 0.304477f, 0.686114f, 
		-0.610597f, 0.226686f, 0.758805f, 0.805290f, -0.555239f, -0.207889f, 
		0.845522f, -0.516505f, 0.135336f, 0.873418f, -0.486532f, 0.0206889f, 
		-0.263596f, -0.0715213f, -0.961978f, 0.571985f, 0.0586771f, -0.818163f, 
		-0.757925f, -0.178199f, -0.627531f, 0.909842f, -0.385208f, -0.154282f, 
		0.211667f, -0.819694f, 0.532258f, -0.0350647f, -0.857630f, 0.513070f, 
		0.435612f, -0.823943f, 0.362435f, 0.202124f, -0.906111f, 0.371629f, 
		0.493415f, -0.216224f, 0.842490f, -0.00403752f, -0.0289155f, 0.999574f, 
		-0.250974f, 0.0432166f, 0.967028f, 0.337303f, -0.161154f, 0.927500f, 
		0.398115f, -0.346101f, -0.849540f, -0.944343f, -0.110109f, -0.309987f, 
		0.638787f, 0.437676f, -0.632765f, 0.682023f, -0.266994f, 0.680851f, 
		-0.00934934f, -0.626240f, 0.779574f, 0.725442f, -0.654641f, -0.212551f, 
		0.342676f, -0.401386f, -0.849389f, -0.674734f, -0.0909283f, -0.732438f, 
		0.398115f, -0.346101f, -0.849540f, -0.851614f, 0.00989999f, -0.524076f, 
		0.399621f, 0.868210f, -0.294134f, -0.556852f, 0.780326f, 0.284618f, 
		-0.496575f, -0.0598872f, -0.865925f, 0.619695f, -0.721269f, -0.309434f, 
		-0.230289f, -0.954508f, 0.189425f, 0.940613f, -0.334595f, -0.0573941f, 
		0.876466f, -0.476769f, 0.0670789f, 0.846045f, -0.508347f, 0.160594f, 
		0.974368f, -0.204091f, 0.0946268f, -0.914614f, 0.306346f, -0.263881f, 
		-0.867308f, 0.248590f, -0.431253f, -0.690143f, 0.207467f, -0.693297f, 
		-0.445399f, 0.137275f, -0.884746f, 0.992699f, -0.0890714f, 0.0813327f, 
		0.546000f, -0.829119f, 0.120192f, 0.0220106f, 0.0388431f, 0.999003f, 
		-0.137745f, 0.705032f, -0.695670f, 0.566855f, 0.0641066f, -0.821319f, 
		-0.884879f, -0.133351f, -0.446327f, -0.948001f, -0.0410802f, -0.315605f, 
		-0.564437f, -0.147632f, -0.812167f, -0.641491f, 0.284987f, 0.712230f, 
		-0.997444f, 0.0711327f, 0.00680471f, 0.969092f, -0.199502f, -0.145120f, 
		0.992712f, -0.0914225f, 0.0785098f, 0.555402f, -0.821291f, 0.130424f, 
		-0.286357f, 0.0163098f, -0.957984f, 0.891318f, 0.0279198f, -0.452518f, 
		0.804203f, -0.187230f, 0.564095f, 0.465284f, -0.0770402f, 0.881802f, 
		0.866778f, -0.221122f, 0.446992f, -0.805205f, 0.0657397f, -0.589341f, 
		-0.767536f, -0.297407f, -0.567836f, 0.992672f, -0.0867192f, 0.0841544f, 
		0.629189f, 0.776438f, -0.0355713f, -0.0203621f, 0.0178648f, 0.999633f, 
		0.591229f, 0.167562f, 0.788905f, -0.229517f, -0.413681f, 0.881016f, 
		0.357312f, -0.511540f, 0.781444f, 0.254507f, -0.459413f, 0.850979f, 
		0.132234f, -0.813295f, -0.566627f, -0.792366f, -0.273079f, -0.545512f, 
		-0.570686f, -0.220377f, -0.791044f, 0.565209f, -0.822119f, -0.0682547f, 
		0.327974f, -0.931018f, 0.160122f, 0.721675f, -0.538920f, -0.434455f, 
		0.736694f, -0.621436f, -0.266643f, -0.308001f, -0.0269549f, 0.951004f, 
		-0.655076f, 0.162182f, 0.737952f, -0.602147f, 0.103700f, 0.791622f, 
		0.628545f, -0.225835f, -0.744264f, -0.794722f, -0.113417f, -0.596282f, 
		0.992699f, -0.0890714f, 0.0813327f, 0.621796f, 0.782962f, -0.0184528f, 
		-0.209767f, -0.0245974f, -0.977442f, -0.670879f, -0.0315478f, -0.740896f, 
		0.583154f, -0.209927f, -0.784769f, 0.645211f, -0.375301f, -0.665472f, 
		0.650163f, -0.220596f, -0.727066f, 0.647937f, -0.301975f, -0.699278f, 
		-0.645931f, 0.286218f, 0.707709f, 0.0837600f, 0.305621f, 0.948462f, 
		-0.383743f, 0.315907f, 0.867724f, -0.104117f, 0.317408f, 0.942556f, 
		-0.736878f, -0.300521f, -0.605556f, -0.952189f, -0.157640f, -0.261696f, 
		-0.813892f, 0.102995f, 0.571815f, -0.178176f, -0.917550f, -0.355466f, 
		-0.949842f, 0.0794230f, -0.302478f, 0.742667f, -0.105789f, 0.661252f, 
		0.609485f, 0.242799f, 0.754703f, 0.994359f, 0.0707245f, -0.0790486f, 
		0.511362f, -0.0332809f, -0.858721f, -0.406012f, 0.250534f, -0.878855f, 
		0.896775f, -0.129920f, -0.422983f, -0.978636f, -0.184844f, 0.0900290f, 
		-0.616578f, -0.0959931f, 0.781420f, 0.0117368f, -0.221221f, 0.975153f, 
		0.341955f, -0.366496f, 0.865302f, -0.331605f, -0.0240959f, 0.943111f, 
		0.0712980f, -0.277788f, 0.957993f, -0.137246f, -0.157718f, 0.977900f, 
		-0.199043f, -0.0695822f, 0.977517f, 0.990269f, -0.0143049f, 0.138429f, 
		-0.997232f, 0.0701735f, 0.0245805f, -0.639519f, 0.269226f, 0.720092f, 
		0.968554f, 0.216221f, -0.123091f, -0.803536f, -0.0638924f, -0.591817f, 
		0.626621f, 0.0896414f, -0.774151f, 0.995001f, -0.0481742f, -0.0874754f, 
		0.696588f, -0.184889f, 0.693240f, 0.859575f, -0.248961f, 0.446261f, 
		0.468547f, -0.119789f, 0.875279f, 0.748602f, -0.218773f, 0.625886f, 
		0.797278f, -0.254105f, 0.547520f, 0.740191f, 0.0277951f, 0.671822f, 
		0.717419f, -0.406878f, 0.565473f, 0.754361f, -0.439272f, 0.487832f, 
		0.808034f, -0.414672f, 0.418482f, -0.955158f, -0.0527907f, -0.291354f, 
		-0.771740f, 0.160285f, -0.615407f, 0.0628147f, -0.0257138f, 0.997694f, 
		0.804134f, 0.0975208f, 0.586394f, 0.209466f, 0.591123f, 0.778908f, 
		0.0664186f, 0.979741f, -0.188934f, -0.532873f, 0.795809f, 0.287636f, 
		0.961766f, -0.273679f, 0.0103277f, 0.908385f, -0.279532f, -0.310964f, 
		0.949672f, -0.282412f, -0.135524f, 0.937199f, -0.275355f, -0.214096f, 
		0.960143f, -0.270685f, -0.0696795f, -0.996666f, -0.0520100f, 0.0628702f, 
		-0.639471f, 0.153983f, 0.753237f, -0.771885f, 0.157241f, -0.616011f, 
		-0.607969f, 0.206861f, -0.766539f, -0.672961f, 0.243544f, -0.698434f, 
		-0.724312f, 0.182876f, -0.664778f, -0.817732f, 0.126856f, -0.561446f, 
		0.699328f, -0.377759f, -0.606826f, 0.631120f, -0.409787f, -0.658606f, 
		0.575399f, -0.429407f, -0.696079f, -0.568896f, -0.224017f, -0.791311f, 
		0.490303f, -0.0957694f, -0.866274f, -0.426003f, 0.225507f, -0.876167f, 
		-0.281814f, -0.123110f, 0.951538f, 0.224160f, -0.844751f, -0.485950f, 
		0.0687115f, -0.969936f, -0.233458f, 0.143056f, -0.886717f, -0.439622f, 
		0.119441f, -0.933078f, -0.339262f, 0.377000f, -0.667263f, -0.642364f, 
		0.297645f, -0.736338f, -0.607630f, 0.197310f, -0.794551f, -0.574244f, 
		-0.504754f, -0.107931f, 0.856490f, -0.607344f, -0.0401626f, 0.793423f, 
		-0.0131959f, -0.952709f, -0.303597f, -0.702529f, 0.0126603f, 0.711542f, 
		0.261951f, 0.117039f, -0.957958f, -0.563880f, 0.263379f, -0.782733f, 
		0.787409f, 0.0765049f, 0.611665f, 0.825466f, -0.205218f, 0.525825f, 
		0.666882f, -0.337480f, 0.664362f, -0.308520f, 0.316700f, 0.896949f, 
		-0.262978f, -0.0958169f, -0.960032f, 0.582225f, 0.0669052f, -0.810270f, 
		0.707972f, -0.261963f, -0.655859f, 0.308712f, 0.0623203f, -0.949112f, 
		-0.662314f, -0.131892f, -0.737526f, 0.773593f, -0.575173f, 0.265951f, 
		0.258853f, -0.471525f, 0.843006f, 0.372656f, -0.572502f, 0.730321f, 
		0.522134f, -0.626095f, 0.579122f, 0.982111f, 0.0897985f, 0.165510f, 
		0.143286f, -0.988355f, -0.0512191f, -0.243671f, -0.311955f, 0.918318f, 
		0.606188f, -0.353705f, 0.712340f, 0.742381f, -0.400787f, 0.536881f, 
		0.708991f, -0.381958f, 0.592823f, 0.744732f, 0.189843f, 0.639792f, 
		0.967422f, 0.205081f, 0.148448f, 0.969366f, -0.195391f, -0.148835f, 
		0.833064f, -0.348461f, -0.429627f, 0.839671f, -0.539055f, 0.0661227f, 
		0.801071f, -0.578148f, 0.155013f, 0.857770f, -0.513509f, -0.0232212f, 
		0.910080f, -0.388028f, -0.145563f, -0.147943f, 0.988757f, -0.0217507f, 
		0.0676297f, 0.985027f, -0.158581f, -0.259106f, 0.963371f, 0.0691418f, 
		0.393692f, -0.0239384f, 0.918931f, -0.544145f, 0.217863f, -0.810211f, 
		0.392040f, -0.129795f, -0.910746f, 0.976576f, -0.214310f, -0.0192776f, 
		-0.217943f, -0.0990462f, 0.970923f, -0.567459f, -0.231752f, -0.790115f, 
		0.901297f, -0.423170f, 0.0926843f, 0.893669f, -0.442820f, -0.0725634f, 
		0.875561f, -0.461994f, -0.141263f, 0.525847f, 0.0127099f, 0.850484f, 
		0.580606f, -0.738494f, -0.342818f, -0.219766f, -0.964904f, 0.143749f, 
		0.441847f, -0.380658f, 0.812324f, -0.144942f, -0.177211f, 0.973441f, 
		0.216364f, -0.337555f, 0.916102f, -0.334128f, -0.122441f, 0.934541f, 
		0.863627f, -0.0303985f, 0.503214f, 0.639206f, -0.768656f, 0.0241449f, 
		0.752059f, -0.587103f, -0.299530f, 0.505168f, -0.832576f, 0.227203f, 
		0.714108f, -0.503034f, -0.486833f, 0.338144f, -0.0615680f, -0.939078f, 
		-0.677559f, -0.208741f, -0.705224f, 0.332249f, -0.131309f, 0.934007f, 
		0.493498f, 0.0634252f, 0.867431f, 0.404813f, 0.871311f, -0.277385f, 
		-0.590767f, 0.805976f, -0.0373761f, 0.798703f, -0.284398f, 0.530275f, 
		0.0615434f, -0.0788434f, 0.994986f, 0.803546f, 0.0569978f, 0.592507f, 
		-0.572778f, -0.0979687f, -0.813835f, 0.993000f, 0.0605305f, -0.101422f, 
		0.859205f, 0.0254694f, 0.510998f, -0.615936f, 0.142256f, -0.774846f, 
		0.361640f, -0.234794f, -0.902268f, -0.312797f, 0.312477f, 0.896948f, 
		0.633304f, -0.160338f, -0.757112f, -0.356648f, -0.154543f, -0.921368f, 
		0.232889f, 0.147360f, 0.961274f, 0.298407f, 0.318191f, 0.899838f, 
		0.692984f, 0.199402f, 0.692830f, 0.607922f, 0.212589f, 0.765008f, 
		0.999580f, -0.0289771f, 0.000681285f, -0.233445f, -0.263442f, 0.936003f, 
		0.779433f, 0.133034f, 0.612198f, 0.687409f, 0.193971f, 0.699889f, 
		0.334976f, -0.135410f, 0.932446f, -0.322019f, -0.862027f, 0.391425f, 
		-0.00864344f, -0.709534f, -0.704619f, 0.685942f, -0.725044f, -0.0615951f, 
		0.690475f, -0.0117806f, -0.723260f, 0.797861f, -0.0350592f, -0.601821f, 
		0.761315f, -0.0186904f, -0.648113f, 0.994294f, -0.0489988f, -0.0947582f, 
		0.904554f, 0.142435f, 0.401863f, 0.927634f, 0.292419f, 0.232350f, 
		0.678619f, 0.734485f, 0.00286374f, 0.491712f, 0.870631f, 0.0148472f, 
		-0.565803f, -0.232091f, -0.791202f, -0.341862f, -0.223375f, 0.912816f, 
		0.576802f, -0.579605f, 0.575637f, 0.527479f, -0.760024f, 0.379644f, 
		0.499350f, -0.854721f, 0.141781f, 0.382332f, 0.208923f, 0.900096f, 
		0.779446f, 0.0587680f, 0.623707f, 0.645953f, 0.109881f, 0.755427f, 
		0.271434f, 0.264399f, 0.925428f, 0.0879579f, 0.285564f, 0.954315f, 
		0.547067f, 0.157346f, 0.822168f, 0.892151f, 0.184747f, -0.412231f, 
		0.919347f, 0.241994f, -0.310226f, 0.823274f, -0.141207f, -0.549800f, 
		0.899118f, -0.0777471f, -0.430747f, 0.907364f, 0.358569f, -0.219361f, 
		0.580320f, -0.211035f, -0.786571f, 0.688092f, -0.222089f, -0.690801f, 
		0.638044f, -0.224089f, -0.736671f, -0.0406516f, 0.221478f, -0.974318f, 
		0.515594f, 0.111312f, -0.849572f, 0.381555f, 0.0913042f, -0.919826f, 
		-0.388034f, 0.315033f, -0.866131f, 0.345214f, -0.210617f, -0.914586f, 
		-0.663107f, -0.255545f, -0.703552f, -0.688898f, 0.185407f, -0.700745f, 
		0.367995f, -0.261899f, -0.892182f, -0.770788f, -0.0632183f, -0.633947f, 
		0.289900f, -0.202731f, -0.935338f, 0.862270f, -0.121596f, 0.491635f, 
		0.790321f, 0.0505571f, 0.610604f, 0.842762f, -0.0582870f, 0.535121f, 
		0.908350f, -0.331890f, 0.254460f, -0.516996f, -0.129429f, -0.846146f, 
		-0.348303f, -0.863231f, 0.365399f, -0.00864344f, -0.709534f, -0.704619f, 
		0.588165f, 0.0820874f, 0.804564f, 0.267020f, -0.242449f, -0.932694f, 
		-0.713060f, -0.265244f, -0.648992f, 0.675554f, -0.400221f, 0.619233f, 
		0.755390f, -0.439219f, 0.486284f, 0.715380f, -0.421308f, 0.557432f, 
		0.451169f, -0.354371f, 0.819065f, 0.624552f, -0.383359f, 0.680420f, 
		-0.301020f, -0.0601851f, 0.951717f, 0.855639f, 0.0875137f, 0.510121f, 
		0.618553f, -0.290695f, -0.729993f, -0.313694f, -0.275122f, -0.908792f, 
		0.855830f, -0.475246f, 0.204196f, 0.877967f, -0.468854f, 0.0966979f, 
		0.839621f, -0.454380f, 0.297617f, -0.274469f, -0.0809247f, -0.958185f, 
		0.584902f, 0.0691465f, -0.808152f, -0.313327f, 0.296373f, 0.902214f, 
		0.877654f, 0.0214264f, 0.478816f, 0.924882f, -0.191410f, 0.328566f, 
		0.915983f, -0.0432895f, 0.398875f, 0.818324f, 0.139274f, 0.557628f, 
		0.853583f, 0.0861688f, 0.513780f, -0.133807f, 0.225359f, 0.965043f, 
		-0.388535f, 0.0961948f, 0.916399f, -0.315774f, 0.130539f, 0.939812f, 
		0.0554791f, -0.0738572f, 0.995724f, 0.800971f, 0.0550534f, 0.596166f, 
		0.0751059f, 0.300199f, 0.950915f, 0.763073f, 0.137351f, 0.631549f, 
		0.913695f, 0.107895f, 0.391815f, 0.984628f, 0.0686691f, -0.160600f, 
		0.992225f, 0.0838081f, 0.0920082f, 0.832624f, 0.0931869f, -0.545943f, 
		0.581564f, -0.336432f, -0.740673f, 0.837056f, 0.118254f, -0.534185f, 
		0.663978f, 0.0987401f, -0.741204f, 0.570753f, 0.0779103f, -0.817417f, 
		0.904920f, 0.0467852f, 0.423003f, -0.303043f, -0.283253f, -0.909908f, 
		0.616186f, -0.290083f, -0.732234f, 0.751318f, -0.459172f, 0.474007f, 
		0.886314f, -0.375914f, 0.270437f, 0.846940f, -0.391889f, 0.359328f, 
		0.935781f, -0.352275f, -0.0147445f, 0.907990f, -0.346509f, -0.235553f, 
		0.919928f, -0.359741f, -0.155946f, 0.922131f, -0.237018f, -0.305772f, 
		0.733139f, -0.267403f, -0.625303f, 0.464237f, -0.303758f, -0.831995f, 
		0.920697f, 0.0512229f, 0.386902f, 0.923932f, 0.0740444f, 0.375324f, 
		0.938271f, 0.110580f, -0.327748f, 0.335138f, -0.0187369f, -0.941983f, 
		0.929142f, 0.0270009f, 0.368736f, 0.971522f, -0.137052f, -0.193293f, 
		0.249197f, -0.223854f, -0.942226f, 0.651526f, -0.0518836f, -0.756850f, 
		0.999291f, -0.0267785f, 0.0264594f, 0.0623029f, 0.302135f, 0.951227f, 
		0.766086f, 0.129963f, 0.629462f, 0.979991f, -0.0682857f, -0.186964f, 
		0.311260f, -0.244480f, -0.918339f, 0.975294f, -0.00975672f, -0.220694f, 
		0.355621f, -0.135440f, -0.924765f, 0.910986f, 0.0136217f, 0.412211f, 
		0.869624f, 0.0945656f, 0.484573f, 0.955546f, -0.00336174f, 0.294824f, 
		0.929350f, 0.0564128f, 0.364864f, 0.946553f, -0.129349f, 0.295476f, 
		0.972885f, 0.115626f, -0.200314f, 0.809071f, 0.0541100f, 0.585215f, 
		0.964454f, 0.0291021f, 0.262644f, -0.292607f, -0.287518f, -0.911984f, 
		0.611360f, -0.306832f, -0.729447f, 0.983423f, -0.173285f, -0.0534077f, 
		0.0614165f, -0.0675288f, 0.995825f, 0.794939f, 0.0745070f, 0.602097f, 
		0.994124f, -0.0666993f, -0.0852612f, 0.961012f, 0.0786348f, -0.265089f, 
		0.998794f, 0.0464906f, 0.0157657f, 0.746404f, 0.0746547f, -0.661292f, 
		0.836130f, 0.0982261f, -0.539665f, 0.996046f, 0.0505321f, -0.0730622f, 
		-0.290795f, -0.0481614f, -0.955572f, 0.589246f, 0.0971011f, -0.802097f, 
		0.999724f, -0.00660933f, 0.0225245f, 0.621008f, -0.286396f, -0.729607f, 
		0.994749f, -0.0970310f, -0.0325356f, 0.944446f, 0.0223284f, 0.327906f, 
		0.0532044f, 0.294840f, 0.954064f, 0.769260f, 0.125988f, 0.626391f, 
		-0.284469f, -0.293897f, -0.912525f, 0.609867f, -0.284632f, -0.739626f, 
		0.975815f, 0.114331f, -0.186315f, 0.802176f, 0.0601120f, 0.594055f, 
		0.116131f, 0.407102f, 0.905970f, -0.706833f, 0.452239f, 0.543937f, 
		-0.284155f, -0.199264f, -0.937843f, 0.605939f, -0.0124443f, -0.795414f, 
		0.840717f, 0.107974f, -0.530600f, 0.617421f, -0.292725f, -0.730139f, 
		0.993211f, -0.102824f, -0.0543908f, 0.0490268f, -0.0164364f, 0.998662f, 
		0.780661f, 0.137189f, 0.609711f, -0.642163f, 0.646200f, 0.412373f, 
		0.661957f, 0.0198618f, 0.749279f, 0.948494f, 0.0157675f, 0.316403f, 
		-0.629732f, -0.0760726f, -0.773078f, 0.681835f, -0.566903f, -0.462301f, 
		0.0462303f, 0.277938f, 0.959486f, 0.771806f, 0.108367f, 0.626556f, 
		0.976905f, 0.129525f, -0.169943f, 0.798865f, 0.0635123f, 0.598148f, 
		0.0364101f, 0.116524f, 0.992520f, 0.776138f, 0.126040f, 0.617838f, 
		-0.683641f, -0.0569775f, -0.727590f, 0.760337f, -0.136539f, -0.635015f, 
		0.394301f, 0.864833f, -0.310790f, 0.749937f, -0.272447f, -0.602800f, 
		0.870937f, -0.229435f, -0.434544f, 0.989669f, -0.125219f, -0.0698287f, 
		0.353367f, -0.0195698f, 0.935280f, -0.735017f, 0.245209f, 0.632157f, 
		-0.348303f, -0.863231f, 0.365399f, 0.951771f, 0.00210533f, 0.306802f, 
		0.842526f, 0.140743f, -0.519943f, -0.748655f, 0.246603f, 0.615388f, 
		-0.374110f, -0.863254f, 0.338872f, 0.678441f, 0.0919965f, 0.728872f, 
		0.970657f, 0.173384f, -0.166621f, 0.787363f, 0.112679f, 0.606104f, 
		0.610531f, -0.300935f, -0.732591f, 0.821884f, -0.244847f, -0.514350f, 
		0.948674f, -0.171756f, -0.265551f, 0.747543f, -0.264499f, -0.609278f, 
		0.989585f, -0.110423f, -0.0923516f, 0.904886f, -0.198096f, -0.376749f, 
		0.613559f, -0.142834f, -0.776623f, 0.984524f, 0.0958911f, -0.146689f, 
		0.817576f, -0.00814742f, -0.575763f, 0.937792f, 0.107143f, -0.330252f, 
		0.955977f, -0.00765268f, 0.293343f, 0.989153f, -0.122846f, -0.0805291f, 
		0.876595f, 0.0501316f, 0.478610f, 0.991950f, 0.00123117f, -0.126626f, 
		0.777065f, 0.145586f, 0.612352f, 0.689101f, 0.0257288f, 0.724209f, 
		0.728199f, -0.362844f, -0.581439f, 0.659851f, 0.0931166f, 0.745605f, 
		0.749916f, -0.143137f, -0.645862f, 0.399621f, 0.868210f, -0.294134f
	};
	static const GLint Indices[] = {
		4895, 5208, 4895, 4915, 2831, 2815, 2761, 2939, 3256, 2939, 3222, 2939, 3067, 2801, 3000, 2761, 
		3064, 2831, 2898, 2815, 2898, 3007, 2898, 3042, 2898, 3173, 3064, 4419, 4421, 4419, 4180, 3222, 
		3256, 3567, 3256, 3892, 3657, 4210, 3946, 4374, 4180, 4590, 4421, 4634, 4419, 4634, 4896, 4634, 
		4900, 4634, 4996, 4590, 5088, 5208, 5088, 4895, 5088, 4675, 5076, 4675, 4679, 2988, 2712, 2988, 
		2706, 2988, 2980, 3378, 3373, 3378, 2988, 3378, 2981, 2519, 2277, 2429, 2204, 2477, 2247, 2982, 
		2708, 2982, 2867, 3197, 2867, 2874, 2867, 2671, 2657, 2538, 2519, 2456, 2429, 2515, 2477, 2623, 
		2477, 2610, 2247, 2406, 2247, 2257, 2247, 2213, 2204, 2297, 2277, 2470, 2277, 2460, 2519, 2460, 
		2657, 2707, 2867, 3058, 3376, 3058, 3205, 3058, 2785, 4151, 4128, 4151, 3792, 4151, 3802, 4313, 
		4150, 4313, 3803, 3958, 2470, 2460, 2470, 2712, 2712, 2460, 2712, 2709, 3803, 3792, 3803, 3373, 
		3803, 3379, 3958, 3804, 3958, 3380, 3574, 2651, 2587, 2651, 2734, 2651, 2805, 2873, 2587, 2619, 
		2587, 2787, 2734, 2732, 2805, 2803, 2873, 2985, 2873, 3003, 2873, 2844, 2651, 2832, 2651, 2633, 
		2587, 2567, 2587, 2618, 4399, 4416, 4399, 4172, 4149, 4172, 3911, 3911, 3729, 3911, 3925, 4149, 
		4235, 4399, 4618, 4416, 4618, 4914, 4618, 4894, 4618, 4676, 4235, 4680, 4235, 4233, 3925, 3929, 
		3925, 3728, 3376, 3730, 3376, 3592, 3205, 3215, 3205, 2930, 2785, 2930, 2620, 2930, 2787, 3592, 
		3730, 3592, 3911, 4686, 4687, 4686, 5028, 5027, 5204, 5207, 5207, 5089, 5207, 4892, 5027, 4524, 
		4686, 4151, 4686, 4313, 4687, 4313, 4316, 3958, 3961, 3574, 3590, 3574, 3197, 3574, 2983, 3574, 
		3381, 2406, 2257, 2406, 2410, 4128, 4152, 4128, 4524, 4518, 4892, 4881, 5089, 4881, 5077, 3004, 
		2986, 3004, 2611, 3004, 2407, 2845, 2411, 2845, 2833, 2611, 2986, 2611, 2624, 4898, 5005, 4898, 
		5181, 4915, 5208, 4915, 5205, 4916, 5206, 4916, 5029, 4417, 4688, 4173, 4317, 4173, 3962, 3912, 
		3591, 3593, 3591, 3216, 3198, 3216, 2875, 2931, 2875, 2788, 2672, 2733, 2539, 2733, 2457, 2804, 
		2516, 2987, 2516, 2625, 3533, 3523, 3533, 3152, 3533, 3161, 3894, 3524, 3894, 3533, 3894, 3898, 
		3236, 2889, 3525, 2889, 3153, 3671, 3236, 3671, 3526, 3671, 3895, 2896, 2882, 2896, 2771, 2896, 
		2783, 4549, 4282, 4549, 4280, 4549, 4536, 2699, 2560, 2883, 2560, 2772, 4344, 4003, 4344, 4283, 
		4344, 4550, 3161, 3154, 3161, 2884, 3161, 2896, 4284, 3896, 4284, 3898, 4284, 4280, 2889, 2699, 
		3155, 2699, 2885, 4003, 3671, 4003, 3897, 4003, 4285, 2976, 3002, 2976, 3067, 2703, 2692, 2703, 
		2681, 2757, 2655, 3001, 3055, 3065, 3055, 3175, 3002, 2976, 3002, 3056, 4604, 4375, 4604, 4591, 
		4604, 4998, 4605, 4387, 4376, 4387, 4210, 2773, 2560, 2773, 2491, 2674, 2535, 2692, 2783, 2692, 
		2674, 2681, 2535, 2655, 2535, 2647, 2535, 2536, 2491, 2492, 2560, 2562, 2699, 2697, 2889, 2886, 
		3236, 3227, 3236, 3655, 3671, 3991, 4003, 4327, 4344, 4677, 4705, 5004, 5023, 5179, 5023, 5197, 
		5146, 5293, 5146, 5131, 5146, 4952, 5146, 4962, 5023, 4962, 4705, 4551, 4344, 2674, 2783, 2674, 
		2774, 4952, 4962, 4952, 4536, 4536, 4962, 4536, 4552, 2656, 2648, 2656, 3008, 2656, 3043, 2758, 
		3043, 3174, 4897, 5180, 4897, 5198, 4901, 5294, 4901, 4997, 5005, 4898, 5005, 4420, 4678, 4181, 
		4328, 4181, 3992, 3947, 3656, 3658, 3656, 3257, 3228, 3257, 2887, 2940, 2887, 2802, 2698, 2762, 
		2563, 2762, 2493, 2816, 2537, 3009, 2537, 2649, 2137, 2275, 2137, 2095, 1929, 1959, 1802, 1925, 
		1812, 1925, 1932, 1996, 2079, 2110, 2266, 2230, 2414, 2230, 2275, 4459, 4645, 4459, 4575, 4383, 
		4393, 4236, 4225, 4236, 4025, 3993, 3884, 3993, 3921, 4183, 4074, 4183, 4443, 4400, 4443, 4459, 
		4443, 4645, 6297, 5966, 6297, 5606, 6296, 5606, 6296, 5883, 845, 245, 845, 780, 845, 779, 
		845, 1239, 5965, 5726, 5965, 5382, 5965, 5605, 722, 40, 722, 244, 722, 844, 5725, 4861, 
		5725, 5381, 4947, 4861, 4947, 5725, 4165, 4861, 4165, 4947, 4165, 4038, 3564, 3339, 3085, 2776, 
		2609, 2305, 2609, 1975, 2130, 1548, 1889, 924, 1424, 212, 858, 39, 858, 721, 7288, 7230, 
		7288, 6573, 7288, 6625, 7249, 6575, 7023, 6330, 6714, 5959, 6157, 5707, 5862, 5375, 5264, 5082, 
		4983, 4696, 4983, 4315, 4539, 3800, 3772, 3337, 3127, 2929, 2597, 2485, 2073, 2168, 1842, 2050, 
		1604, 1928, 1604, 1342, 7229, 6987, 7229, 6249, 7229, 6572, 1699, 998, 1699, 1341, 1699, 1927, 
		6248, 6986, 6248, 6584, 6290, 6374, 6290, 6216, 1452, 997, 1452, 1698, 1452, 1658, 1494, 1658, 
		1602, 5882, 6247, 5882, 6289, 6076, 6215, 6076, 6121, 1657, 1697, 1657, 1238, 1657, 1420, 1601, 
		1420, 1500, 6295, 5881, 6295, 6075, 6264, 6120, 6264, 6230, 1419, 1237, 1419, 778, 1419, 1172, 
		1499, 1172, 1375, 6583, 6229, 6583, 6373, 6263, 6229, 6263, 6583, 6263, 6985, 6294, 6985, 5964, 
		6733, 5724, 6231, 4946, 5470, 4037, 4893, 3338, 4274, 2775, 3726, 2304, 3061, 2464, 3372, 2827, 
		3636, 2287, 2927, 1875, 2441, 2265, 3079, 3103, 3954, 4053, 4585, 4776, 5107, 5229, 5696, 5874, 
		6482, 5847, 6453, 5835, 6378, 5773, 6183, 5630, 5962, 5263, 5962, 5861, 5962, 6156, 6265, 6713, 
		6591, 7058, 6784, 7236, 7024, 7298, 7151, 7276, 7104, 7163, 6993, 6901, 6635, 6298, 6017, 6061, 
		5414, 4893, 5414, 4274, 5024, 3726, 4457, 3061, 3938, 3372, 4713, 4193, 4585, 4193, 3954, 3636, 
		3079, 2927, 2441, 6733, 6985, 6733, 7228, 7235, 7276, 7235, 7163, 6817, 6901, 6061, 6298, 6733, 
		7235, 6231, 6817, 5470, 6061, 4893, 5107, 4585, 5107, 4713, 5522, 5178, 6022, 5594, 6635, 5594, 
		6017, 5594, 5414, 5594, 5024, 5594, 4457, 5178, 4457, 4713, 3938, 6022, 6635, 6022, 6993, 6241, 
		7104, 6482, 7104, 6453, 7151, 6378, 7024, 6183, 6784, 5962, 6784, 6265, 6591, 5696, 6241, 6482, 
		5522, 6022, 5522, 6241, 5522, 5696, 5107, 3372, 4193, 3636, 6713, 7058, 7022, 7058, 7248, 7236, 
		7287, 7298, 7228, 7276, 2304, 2464, 1974, 2042, 1547, 1598, 923, 966, 211, 590, 38, 850, 
		243, 996, 777, 996, 1171, 1451, 1374, 1451, 1493, 996, 850, 1340, 1328, 2314, 2248, 3137, 
		3103, 3137, 4053, 4086, 4776, 4819, 5229, 5320, 5874, 5320, 5847, 5331, 5329, 4888, 4902, 4196, 
		4266, 3203, 3398, 2461, 2646, 1603, 2646, 1841, 2941, 2072, 2941, 2596, 3343, 3890, 3634, 4368, 
		4335, 4816, 4887, 5210, 5290, 5773, 5290, 5835, 5329, 5847, 850, 590, 1328, 1504, 2248, 2265, 
		3103, 590, 966, 1504, 1875, 2265, 2042, 2464, 2042, 2827, 2042, 2287, 1598, 1875, 966, 3126, 
		2596, 3126, 3890, 3126, 4368, 3771, 4368, 4538, 4816, 4538, 5210, 4982, 5210, 5263, 5210, 5630, 
		5773, 3343, 2941, 3634, 2646, 3634, 3398, 4335, 4266, 4887, 4902, 5290, 5329, 5320, 5331, 5320, 
		4888, 4819, 4888, 4086, 4196, 3137, 3203, 2314, 2461, 1340, 1603, 6372, 6228, 6372, 6119, 6372, 
		6214, 1498, 1373, 1498, 1492, 1498, 1600, 1295, 920, 1295, 756, 1295, 1122, 1295, 1718, 1863, 
		1718, 2132, 1718, 2088, 756, 920, 756, 611, 611, 920, 611, 644, 3572, 3047, 3572, 3632, 
		4227, 4287, 4227, 4976, 4845, 5334, 4845, 5276, 3632, 3047, 3632, 2990, 537, 645, 537, 615, 
		538, 612, 538, 645, 5322, 5277, 5322, 5335, 5323, 5256, 5323, 5277, 1993, 2047, 1993, 2133, 
		1993, 2089, 3029, 2991, 3029, 3048, 3029, 3037, 1296, 1864, 1296, 1765, 1296, 1159, 921, 775, 
		646, 775, 614, 1765, 1864, 1765, 2048, 2048, 1864, 2048, 2134, 3501, 3038, 3501, 3049, 3501, 
		3573, 4168, 4228, 4791, 4846, 5255, 4846, 5278, 1719, 1123, 1719, 1082, 1719, 1661, 2090, 1661, 
		1994, 1082, 1123, 1082, 702, 702, 1123, 702, 757, 4215, 4890, 4215, 4977, 4215, 4288, 3545, 
		3633, 3030, 3633, 2992, 539, 757, 539, 613, 540, 703, 540, 757, 4889, 5336, 4889, 4977, 
		4890, 5324, 4890, 5336, 541, 615, 541, 776, 541, 704, 704, 776, 704, 1160, 4216, 3546, 
		4216, 3502, 4216, 4169, 4891, 4792, 5325, 4792, 5256, 3502, 3546, 3502, 3039, 3039, 3546, 3039, 
		3031, 1766, 2049, 1766, 1662, 1766, 1083, 1160, 1083, 705, 1662, 2049, 1662, 1995, 4116, 3971, 
		4116, 4501, 4116, 4562, 4258, 4562, 4390, 4757, 4499, 4629, 4629, 4757, 4629, 4805, 4805, 4757, 
		4805, 4922, 4922, 4757, 4922, 4809, 2171, 2211, 2171, 2164, 4651, 4884, 4651, 4787, 2139, 2186, 
		2259, 2186, 2388, 2346, 2669, 2630, 3135, 3114, 3135, 3755, 3761, 4241, 4249, 4570, 4492, 4789, 
		4652, 4789, 4885, 5111, 4885, 5137, 4885, 4873, 4788, 4725, 2151, 2251, 2252, 2415, 2668, 2613, 
		2668, 2891, 2668, 3246, 2668, 2936, 2252, 2911, 2613, 2526, 2613, 2387, 2415, 2267, 2251, 2165, 
		2251, 2172, 2151, 2172, 2074, 2172, 2140, 2212, 2140, 2259, 3901, 4018, 3901, 3449, 3323, 3449, 
		2841, 2912, 2841, 2526, 4422, 4479, 4134, 4395, 4318, 4135, 4318, 4395, 4515, 4395, 4644, 4479, 
		4628, 4422, 4628, 4729, 4628, 4770, 4628, 4783, 4644, 3857, 4318, 4178, 4515, 4445, 4318, 3857, 
		4318, 4136, 3294, 4259, 4391, 4630, 4806, 4649, 2879, 3971, 2879, 4117, 4873, 5117, 4873, 4728, 
		4725, 4581, 4990, 4986, 5151, 5114, 5117, 4968, 4728, 4477, 4581, 4477, 4362, 4019, 4362, 3901, 
		5118, 5136, 5151, 5100, 4990, 5100, 4920, 5100, 4945, 5100, 5112, 5136, 4729, 4422, 4268, 4268, 
		4422, 3801, 2913, 3450, 2913, 3359, 2891, 3532, 3246, 4036, 3246, 3919, 2936, 3907, 2936, 2862, 
		2252, 2862, 2152, 2879, 2075, 2879, 2153, 2879, 2862, 3971, 3907, 4501, 3919, 4445, 4036, 4178, 
		3532, 3857, 3359, 3801, 3450, 4268, 4020, 4268, 4714, 4729, 4967, 4770, 4937, 4783, 4937, 4810, 
		3095, 2282, 3095, 2076, 5113, 4876, 5113, 4944, 2532, 3294, 3664, 4391, 4500, 3294, 2283, 3294, 
		3095, 4259, 3095, 4118, 3095, 2879, 3095, 2077, 3294, 2532, 3294, 2284, 4877, 4649, 4945, 4806, 
		4945, 4921, 3857, 3801, 3857, 4137, 3801, 4422, 3801, 4138, 3461, 2899, 3461, 3995, 4048, 4369, 
		4564, 2891, 2613, 2891, 2914, 4021, 4477, 4714, 4968, 4967, 5114, 4937, 4986, 4811, 4990, 4811, 
		4922, 2530, 2187, 2530, 2284, 2347, 2532, 2347, 2899, 2631, 3461, 3115, 3461, 3756, 4048, 4242, 
		4564, 4571, 4564, 4878, 4564, 4649, 4369, 4630, 4369, 4500, 3995, 3664, 2899, 3664, 2531, 2532, 
		2347, 2532, 2187, 2285, 2141, 2285, 2078, 2286, 2188, 2286, 2142, 4790, 4879, 4790, 5113, 4790, 
		4571, 4790, 4880, 4873, 5137, 4873, 5119, 7350, 7119, 7378, 7198, 7412, 7250, 7431, 7303, 7437, 
		7336, 7423, 7275, 7354, 7097, 7219, 7097, 6849, 7097, 6896, 7097, 7142, 7275, 7176, 7336, 7176, 
		7303, 7096, 7250, 6996, 7198, 6928, 7119, 935, 1131, 935, 1620, 935, 1412, 1413, 1620, 1413, 
		1942, 6997, 6918, 7137, 6918, 7025, 6918, 6789, 982, 1414, 982, 1464, 983, 936, 983, 1415, 
		7138, 7026, 7138, 7311, 3121, 3010, 3121, 2517, 2730, 2117, 2354, 1874, 2038, 2215, 2601, 2215, 
		2101, 2215, 1830, 1942, 1830, 1416, 7280, 7356, 7280, 7162, 7280, 7098, 7218, 6997, 7218, 7139, 
		2652, 2821, 2652, 2451, 2238, 2092, 1961, 1849, 1961, 1692, 2821, 2993, 2821, 3201, 2821, 2652, 
		2821, 2994, 7471, 7413, 7471, 7432, 7472, 7458, 7413, 7458, 7379, 7440, 7349, 7426, 7281, 7426, 
		7396, 2308, 2654, 2308, 2239, 2028, 1962, 1734, 1693, 1281, 2653, 2676, 2653, 2995, 2654, 2308, 
		2654, 2675, 7482, 7459, 7482, 7473, 7481, 7464, 7460, 7464, 7441, 7446, 7427, 7428, 7397, 7404, 
		2402, 2438, 2111, 2685, 3069, 2685, 2659, 6266, 6624, 6266, 6344, 6266, 6582, 6622, 6582, 6920, 
		6094, 6266, 6094, 6345, 6094, 6127, 6582, 6266, 6585, 3447, 3430, 3447, 3069, 3060, 2686, 2723, 
		3069, 3430, 3069, 3019, 6585, 6266, 6585, 6416, 6416, 6266, 6416, 6092, 3279, 3407, 3279, 3405, 
		3287, 3452, 3334, 3452, 3521, 3521, 3579, 3521, 3394, 3334, 3041, 3334, 3025, 3287, 3010, 3279, 
		3121, 3407, 3121, 3200, 2730, 2822, 2354, 2452, 2038, 2452, 2093, 7219, 6849, 7219, 7055, 3579, 
		3618, 3579, 3447, 3394, 3060, 3041, 2723, 3041, 2742, 3025, 2735, 3010, 2600, 3010, 2216, 2517, 
		1943, 2117, 1621, 1874, 1132, 1874, 1472, 2038, 1754, 2093, 1754, 1850, 3447, 3618, 3447, 3431, 
		6932, 6585, 6932, 6417, 6933, 7055, 6585, 6849, 6582, 6896, 6921, 6896, 7152, 7142, 7188, 7176, 
		7161, 7176, 7099, 7096, 6998, 6996, 6919, 6928, 6790, 6928, 6815, 7119, 7028, 7350, 7028, 7282, 
		6124, 6346, 6794, 6346, 7021, 6623, 7201, 3580, 3290, 3580, 3616, 7295, 7056, 7295, 6934, 2601, 
		2736, 2601, 2402, 2101, 2111, 2101, 1861, 1830, 1464, 1830, 1417, 2402, 2736, 2402, 2551, 7162, 
		7356, 7162, 7189, 7189, 7356, 7189, 7364, 3201, 2996, 3201, 3187, 3201, 3408, 7477, 7474, 7477, 
		7432, 7477, 7438, 2997, 2824, 2997, 3188, 2998, 2676, 2998, 2824, 7484, 7475, 7484, 7478, 7484, 
		7482, 7484, 7476, 2438, 2402, 2438, 2550, 7362, 7356, 7449, 7356, 7429, 7280, 7398, 7218, 7367, 
		7140, 7367, 7312, 7153, 7189, 7153, 7363, 7153, 7347, 6922, 7201, 6922, 6624, 3190, 2824, 3190, 
		2829, 3191, 2811, 3199, 2780, 3224, 2738, 3252, 2719, 3252, 3292, 3252, 3580, 3252, 3522, 3224, 
		3453, 3199, 3406, 3191, 3408, 3191, 3189, 7469, 7484, 7469, 7480, 7469, 7465, 7451, 7439, 7433, 
		7421, 7409, 7372, 7370, 7372, 7297, 7372, 7056, 7372, 7220, 7421, 7355, 7439, 7424, 7465, 7438, 
		7465, 7479, 5036, 5035, 5036, 5611, 5035, 5036, 5035, 4647, 4496, 4363, 4157, 3773, 3882, 3513, 
		3681, 3270, 3119, 2778, 2643, 2413, 2322, 2307, 2236, 2520, 2467, 2820, 2768, 3234, 3231, 3234, 
		3798, 3825, 4293, 4337, 4667, 4733, 5048, 5081, 5340, 5408, 5763, 5834, 6029, 6091, 6222, 6386, 
		6144, 6351, 5963, 6077, 5720, 6090, 5720, 5979, 3773, 4363, 3773, 4028, 3325, 3861, 3325, 3560, 
		3325, 2966, 5036, 5610, 5395, 6004, 5737, 6004, 6277, 3559, 3861, 3559, 3889, 5853, 6276, 5853, 
		5852, 5550, 5487, 5321, 5487, 5092, 5182, 4712, 5182, 4724, 4024, 3559, 4024, 3888, 4023, 3889, 
		4023, 4231, 5737, 6275, 5737, 5853, 4723, 4022, 4723, 4230, 4723, 4229, 4723, 4711, 5035, 6052, 
		5035, 5610, 5509, 6361, 5509, 6982, 5509, 6981, 5509, 6052, 5509, 5035, 4709, 4261, 4004, 3681, 
		3874, 3499, 3754, 3321, 3609, 3142, 3510, 3040, 3421, 2953, 3385, 2952, 3397, 2952, 3044, 2952, 
		2725, 2632, 2421, 2336, 2182, 2159, 2127, 2144, 2368, 2398, 2740, 2768, 2740, 3231, 2329, 2203, 
		2329, 2747, 2328, 2747, 2965, 2747, 3325, 3088, 3513, 3088, 3270, 2888, 2778, 2505, 2413, 2353, 
		2307, 2553, 2520, 2847, 2820, 3282, 3234, 3282, 3825, 3872, 4337, 4392, 4733, 4826, 5081, 5128, 
		5408, 5481, 5834, 5904, 6091, 6177, 6386, 6594, 6351, 6594, 6546, 6594, 6834, 5609, 6052, 6567, 
		6052, 7302, 6052, 6980, 6567, 6004, 6567, 5610, 3509, 2964, 3509, 3558, 3559, 4024, 3509, 4024, 
		4161, 4024, 4722, 2794, 2327, 2794, 2964, 2794, 3509, 6004, 6567, 6004, 6867, 6004, 6275, 6567, 
		7301, 6567, 7318, 6567, 6866, 3415, 2793, 3415, 3509, 3415, 4160, 6865, 7317, 6865, 7016, 6864, 
		7016, 6732, 6833, 6550, 6387, 6019, 5955, 5589, 5542, 5249, 5199, 4974, 4909, 4490, 4441, 3949, 
		3903, 3345, 3300, 2865, 2847, 2865, 2553, 2566, 2353, 2364, 2505, 2590, 2888, 2608, 3088, 2608, 
		2747, 2608, 2202, 3631, 3414, 3631, 4159, 6274, 6865, 6274, 6732, 6273, 6732, 6187, 6550, 6095, 
		6019, 6095, 5589, 5749, 5349, 5420, 5154, 5525, 5227, 5487, 5227, 5182, 4837, 5182, 4721, 4291, 
		4158, 4291, 4721, 4158, 4291, 3631, 4291, 3438, 4164, 4067, 4627, 4561, 5025, 4974, 5025, 5249, 
		5292, 5589, 5292, 5349, 5083, 5154, 4699, 5227, 4699, 4837, 4164, 4837, 4291, 4837, 4720, 6360, 
		5509, 5243, 4709, 4510, 4004, 4377, 3874, 4252, 3754, 4119, 3609, 4001, 3510, 3910, 3421, 3869, 
		3385, 3873, 3397, 6359, 5243, 6359, 5978, 2608, 2201, 2608, 2360, 2590, 2386, 2364, 5852, 6274, 
		5852, 6187, 5845, 6095, 5845, 5749, 5525, 5420, 4157, 3882, 4496, 4261, 5035, 3773, 3325, 3513, 
		5852, 5845, 5487, 5525, 3882, 3681, 4261, 7015, 6564, 7015, 6545, 7015, 6544, 7015, 6832, 2974, 
		3239, 2974, 3630, 2973, 3629, 2973, 3437, 2973, 3409, 2932, 3386, 2890, 3345, 2890, 2865, 2890, 
		2566, 2603, 2364, 2603, 2385, 6090, 6077, 6564, 6077, 6544, 6351, 2384, 2359, 2384, 2838, 2658, 
		3239, 2658, 2972, 2658, 2932, 2603, 2890, 6094, 6128, 6094, 6089, 6127, 5977, 6127, 6089, 2837, 
		2358, 2837, 2606, 3021, 2661, 3021, 3069, 6088, 6563, 6088, 6420, 6087, 6419, 6087, 6093, 3434, 
		3238, 3434, 2836, 3433, 2835, 3433, 3020, 6562, 7014, 6562, 6936, 6563, 6935, 6563, 6418, 3618, 
		3628, 3618, 3237, 3617, 3238, 3617, 3432, 6358, 5976, 6358, 6126, 6357, 6125, 6621, 6125, 6794, 
		2605, 2357, 2605, 2200, 2604, 2199, 2604, 2262, 2604, 2383, 2660, 2444, 2687, 2525, 2724, 2564, 
		2743, 2552, 2743, 2736, 7016, 7316, 7016, 7297, 7016, 6934, 3292, 3413, 3292, 3631, 3292, 3616, 
		7315, 7300, 7315, 7371, 7314, 7370, 7314, 7296, 2720, 2792, 2720, 3412, 2719, 3411, 2719, 3291, 
		7299, 6979, 7299, 7179, 7369, 7179, 7410, 7274, 7434, 7366, 7452, 7416, 7470, 7443, 7485, 7454, 
		7483, 7450, 7464, 7430, 7446, 7399, 7428, 7368, 7404, 7368, 7313, 2300, 2326, 2300, 2791, 2300, 
		2718, 2300, 2739, 2400, 2781, 2474, 2812, 2555, 2830, 2594, 2825, 2580, 2677, 2439, 2308, 2112, 
		2028, 1862, 1734, 1465, 1281, 1465, 984, 6978, 6356, 6978, 6620, 6977, 6619, 7178, 6619, 7273, 
		6794, 7365, 7021, 7415, 7201, 7442, 7347, 7453, 7364, 7453, 7449, 2261, 2198, 2261, 2325, 2260, 
		2329, 2260, 2299, 2260, 2399, 2383, 2473, 2444, 2554, 2525, 2593, 2564, 2579, 2551, 2579, 2438, 
		4490, 4561, 4974, 3345, 3386, 3949, 3996, 4490, 3996, 4561, 3996, 4067, 3409, 4067, 3436, 5317, 
		5048, 5317, 5340, 5681, 5763, 5970, 6029, 6122, 6222, 6078, 6144, 5854, 5963, 5533, 5963, 5719, 
		5632, 5317, 5632, 5681, 5884, 5970, 6060, 6122, 5999, 6078, 5779, 5854, 5374, 5533, 4993, 5093, 
		4510, 5093, 5243, 5093, 5975, 5093, 5718, 5533, 3869, 3873, 3869, 4424, 4442, 4995, 5047, 5389, 
		5463, 5772, 5820, 5938, 5982, 5846, 5884, 5846, 5632, 5025, 5083, 5292, 3499, 3681, 3499, 3119, 
		2910, 2643, 2478, 2322, 2228, 2236, 2184, 2467, 2398, 2768, 3321, 3499, 3321, 2910, 2745, 2478, 
		2381, 2228, 2173, 2184, 2144, 2398, 3142, 3321, 3142, 2745, 2642, 2381, 2317, 2173, 2159, 2144, 
		4627, 5083, 5025, 4627, 4699, 5083, 4377, 4993, 4510, 4164, 4699, 4627, 6831, 6594, 6387, 6177, 
		5955, 5904, 5542, 5481, 5199, 5128, 4909, 4826, 4441, 4392, 3903, 3872, 3300, 3282, 2847, 3386, 
		3409, 3996, 2384, 2658, 2384, 2603, 5982, 5884, 5982, 6060, 5927, 5999, 5706, 5779, 5319, 5374, 
		4874, 4993, 4874, 4377, 4874, 4252, 4766, 4119, 4640, 4001, 4529, 3910, 4442, 3869, 4766, 5319, 
		4874, 5820, 5982, 5820, 5927, 5595, 5706, 5236, 5319, 5236, 4766, 5236, 4640, 5126, 4529, 5047, 
		4442, 5463, 5820, 5463, 5595, 5126, 5236, 5047, 5463, 5126, 2336, 2317, 2159, 3040, 3142, 3040, 
		2642, 2607, 2317, 2607, 2336, 2607, 2632, 2953, 2952, 2953, 3040, 2607, 3604, 2894, 3604, 2975, 
		3585, 2975, 3097, 3686, 2868, 3686, 2893, 2894, 3604, 2894, 3685, 4329, 4065, 4329, 4078, 4076, 
		4254, 4330, 4254, 4404, 4361, 4404, 4511, 4763, 4796, 5285, 4796, 5306, 4905, 5306, 5309, 4654, 
		4765, 5333, 4765, 5285, 2895, 2869, 2895, 2523, 2895, 2678, 2975, 2800, 3099, 2870, 2523, 2869, 
		2523, 2318, 4764, 4656, 4764, 4066, 4066, 4331, 4765, 4331, 4796, 4405, 4796, 4903, 5435, 5507, 
		5435, 5615, 5615, 5580, 5436, 5580, 5383, 3133, 2933, 3133, 3849, 3133, 3816, 3849, 2933, 3849, 
		3780, 5615, 5507, 5615, 5731, 5731, 5507, 5731, 5648, 3780, 2851, 3780, 3735, 3781, 2933, 3781, 
		2850, 5743, 5731, 5743, 5645, 3818, 4083, 3818, 4069, 3850, 4167, 3850, 4082, 4083, 3818, 4083, 
		3850, 5508, 5437, 5156, 5437, 5133, 4167, 3850, 4167, 3782, 5646, 5193, 5646, 5215, 5647, 5508, 
		5193, 5508, 5157, 4084, 4008, 4084, 3998, 4008, 4084, 4008, 4166, 5214, 5194, 4672, 5194, 4716, 
		5158, 4716, 4771, 4298, 4194, 4298, 4058, 4187, 4033, 4166, 4009, 5258, 4611, 5258, 4558, 5258, 
		5214, 4613, 5214, 4670, 4671, 4717, 4414, 4717, 4484, 4612, 4672, 4360, 4672, 4414, 4558, 4255, 
		4558, 4077, 4557, 4613, 4255, 4613, 4360, 5142, 5254, 5057, 5140, 4971, 5061, 4817, 4961, 4614, 
		4759, 4545, 4661, 4483, 4609, 4415, 4512, 4415, 4361, 3351, 3316, 3351, 3352, 3369, 3269, 3295, 
		3160, 3177, 3036, 3062, 2935, 2943, 2870, 2880, 2800, 2796, 2678, 2683, 2523, 2506, 2320, 2506, 
		2369, 5372, 5529, 5372, 5973, 5372, 5792, 5284, 5688, 5160, 5498, 5042, 5354, 4991, 5313, 4969, 
		5309, 4969, 4904, 3317, 3606, 3317, 3624, 3352, 3544, 3269, 3410, 3160, 3265, 3036, 3194, 2935, 
		3148, 2870, 3148, 3098, 5140, 5252, 5140, 5530, 5140, 5372, 5061, 5284, 4961, 5160, 4759, 5042, 
		4661, 4991, 4609, 4969, 4513, 4905, 4513, 4406, 4061, 3455, 3945, 3367, 3878, 3298, 3858, 3183, 
		3817, 3183, 3133, 5355, 5738, 5355, 5607, 5314, 5523, 5310, 5527, 5307, 5579, 5286, 5616, 5332, 
		5732, 5332, 5298, 5345, 5223, 5345, 5479, 4190, 4114, 4190, 4223, 5046, 4972, 5046, 4818, 4917, 
		4615, 4827, 4546, 4772, 4484, 4772, 4718, 5044, 5149, 4972, 5149, 5058, 5248, 5141, 5370, 5528, 
		5397, 5528, 5384, 5528, 5580, 5528, 5524, 5528, 5396, 5385, 5397, 5385, 5168, 5385, 5134, 5385, 
		5438, 4042, 4070, 3999, 4070, 4085, 5135, 4828, 5135, 4773, 5135, 5159, 5524, 5479, 5524, 5397, 
		5524, 5608, 5478, 5608, 5658, 5739, 5658, 5810, 5479, 5223, 5479, 5398, 5398, 5223, 5398, 5169, 
		4113, 4108, 4043, 4071, 4114, 4190, 4114, 4108, 5169, 4918, 5169, 4829, 5169, 5135, 5170, 5224, 
		4919, 5224, 5045, 2868, 3714, 2868, 2854, 2868, 3686, 2868, 3715, 4078, 4065, 4078, 4040, 4040, 
		4065, 4040, 3939, 3687, 4214, 3687, 3716, 4530, 4079, 4530, 4041, 4531, 4558, 4531, 4079, 4298, 
		4300, 4298, 4214, 4194, 3688, 4194, 3605, 4058, 3584, 4033, 3601, 4009, 3601, 3599, 4533, 5258, 
		4533, 4559, 4532, 5269, 4532, 5259, 3732, 4302, 3732, 4299, 3732, 4188, 3783, 4188, 4167, 3486, 
		4302, 3486, 3733, 5266, 5784, 5260, 5784, 5215, 5784, 5647, 3734, 2851, 3734, 2770, 5785, 5917, 
		5785, 5695, 5695, 5744, 5786, 5744, 5648, 2371, 2770, 2371, 2852, 2371, 2934, 2369, 2319, 2369, 
		2157, 4800, 4655, 5299, 4655, 5333, 2320, 2855, 2320, 2158, 2320, 2869, 2320, 2856, 4066, 4656, 
		4066, 3941, 3941, 4656, 3941, 4801, 220, 184, 220, 1807, 3014, 2542, 3014, 2480, 185, 221, 
		185, 0, 185, 5, 3821, 2481, 3821, 2543, 3821, 3847, 1, 287, 1, 265, 1, 6, 
		4813, 4821, 4813, 3822, 4813, 3848, 362, 294, 362, 497, 2688, 3753, 2688, 3122, 294, 12, 
		294, 2, 294, 221, 3823, 3787, 3823, 2688, 3823, 2481, 222, 1751, 222, 295, 3091, 2482, 
		3091, 2689, 12, 286, 12, 3, 4820, 3787, 4820, 3824, 3104, 3908, 3104, 3327, 2522, 3005, 
		1761, 2149, 760, 1463, 2279, 3104, 2279, 2522, 1257, 1761, 264, 760, 264, 4, 3973, 4719, 
		4064, 4719, 3973, 4886, 4594, 378, 1806, 378, 183, 4, 3846, 3015, 3794, 4334, 3846, 4334, 
		4812, 4960, 5301, 5495, 5746, 5495, 6168, 5945, 6902, 6496, 6765, 6421, 6115, 6009, 5359, 5496, 
		4912, 5176, 4566, 4929, 4154, 4960, 4154, 4334, 3466, 3015, 3013, 3015, 2541, 3846, 6009, 6421, 
		6009, 6496, 5496, 6496, 5176, 5945, 4929, 5495, 4960, 4566, 4154, 3748, 3466, 3748, 3013, 4232, 
		3807, 4232, 3092, 3541, 3092, 3123, 3092, 2690, 5748, 5587, 5748, 5239, 5308, 4726, 4821, 4726, 
		3788, 6170, 6797, 6395, 6135, 6395, 6365, 6797, 6757, 6797, 6903, 6797, 6169, 6170, 6169, 5747, 
		5971, 5994, 5971, 6210, 5793, 6005, 5689, 5905, 5689, 5499, 5308, 4822, 5308, 5302, 5308, 5747, 
		5748, 6170, 5587, 6170, 5994, 6395, 6210, 6135, 6005, 5946, 5905, 5810, 5905, 5740, 5499, 5740, 
		5355, 5302, 4822, 5302, 4813, 3978, 4203, 3978, 4943, 3978, 4555, 4014, 4451, 4014, 4402, 3983, 
		4357, 3927, 4223, 3819, 4115, 3723, 4044, 3643, 4000, 3599, 4000, 4010, 3247, 2458, 3247, 2466, 
		3247, 3305, 3247, 4201, 4203, 5009, 4943, 5166, 4943, 5152, 4555, 4793, 4451, 4619, 4451, 4502, 
		4402, 4426, 4357, 4307, 4223, 4307, 4191, 2466, 2458, 2466, 1807, 2779, 2122, 2392, 2122, 1752, 
		1367, 1752, 498, 1752, 296, 3807, 4232, 3807, 4851, 2190, 2281, 1343, 1280, 324, 287, 324, 
		13, 6757, 6903, 6757, 6766, 4794, 5153, 4794, 4857, 4794, 4522, 4620, 4410, 4620, 4322, 4503, 
		4238, 4427, 4062, 4308, 3945, 4192, 3878, 4108, 3858, 4071, 3858, 3818, 4857, 5153, 4857, 4869, 
		4869, 5153, 4869, 5167, 6758, 6767, 6758, 6096, 6758, 5983, 6366, 5867, 6136, 5867, 5947, 5671, 
		5811, 5511, 5659, 5345, 5659, 5480, 6096, 6767, 6096, 6116, 4411, 4523, 4411, 3836, 4411, 3815, 
		4411, 3778, 4323, 3727, 4239, 3588, 4063, 3588, 3456, 4523, 4858, 4523, 3828, 3836, 3106, 3836, 
		3217, 3815, 3349, 3815, 3370, 3778, 3296, 3727, 3178, 3588, 3063, 3457, 2944, 3368, 2881, 3299, 
		2797, 3184, 2684, 3134, 2507, 2934, 2507, 2370, 2280, 3106, 3105, 3828, 3909, 4858, 3909, 4870, 
		3075, 3494, 3075, 2779, 3075, 2393, 3076, 3979, 3076, 3494, 5185, 4474, 4851, 4474, 3808, 5186, 
		5098, 5186, 4475, 2779, 3495, 2779, 3163, 2779, 2430, 2122, 1855, 1367, 866, 499, 362, 5471, 
		5187, 5471, 4851, 5201, 4232, 4715, 3541, 4105, 3124, 3753, 2430, 3218, 2430, 2189, 1855, 1344, 
		866, 325, 866, 14, 362, 14, 297, 2430, 3164, 2430, 3219, 5269, 4535, 5269, 4495, 5268, 
		4494, 5268, 5080, 4436, 4209, 4436, 4305, 4208, 4214, 4208, 4304, 4534, 4041, 4534, 3937, 4533, 
		3936, 4533, 4493, 3641, 3718, 3641, 4214, 3641, 4208, 4040, 3943, 4040, 3765, 4039, 3764, 4039, 
		3935, 3034, 2858, 3034, 3717, 3033, 3717, 3033, 3640, 4278, 4209, 4278, 4435, 4277, 4435, 4277, 
		4625, 4350, 4825, 4350, 5039, 4439, 5080, 4439, 4495, 3863, 4495, 3934, 3680, 3639, 3680, 4209, 
		3680, 4277, 3933, 3765, 3528, 3481, 3130, 3044, 2807, 2725, 2556, 2421, 2246, 2182, 2082, 2127, 
		2264, 2368, 2700, 2740, 3251, 2740, 3231, 3932, 3528, 3863, 3314, 3762, 3314, 3679, 3314, 3151, 
		3130, 3151, 2807, 3032, 2556, 3151, 3034, 3151, 3638, 3151, 3678, 3863, 3762, 4439, 3762, 4350, 
		3762, 4276, 3762, 3678, 3762, 4277, 3481, 3763, 3481, 3842, 3397, 3842, 3873, 4332, 4424, 4332, 
		4927, 3481, 3397, 3044, 3314, 3528, 3130, 4624, 4434, 4624, 4338, 4700, 4293, 4700, 4667, 5040, 
		5048, 5040, 5317, 5272, 5632, 5500, 5846, 5788, 5938, 5788, 5916, 5788, 5267, 4624, 4700, 4824, 
		5040, 4824, 5272, 5038, 5500, 5079, 5788, 5079, 5266, 3842, 3765, 3842, 3942, 3941, 4332, 3941, 
		3842, 2857, 3034, 2857, 2556, 2556, 2246, 2856, 2246, 2158, 5995, 5201, 5588, 4715, 5240, 4105, 
		4727, 4105, 3789, 3753, 3789, 2691, 5996, 5472, 5996, 5201, 2190, 3220, 2190, 3106, 2281, 2280, 
		1280, 1258, 288, 1258, 265, 3247, 3978, 3247, 3077, 2458, 2395, 2458, 1803, 1807, 1803, 223, 
		1803, 1753, 1803, 2394, 3247, 4203, 3247, 3979, 5097, 4517, 4476, 3741, 3809, 3012, 4910, 4517, 
		4910, 5098, 5409, 6097, 5312, 6117, 5360, 5984, 5410, 5984, 5370, 5868, 5370, 5672, 5248, 5512, 
		5149, 5346, 5046, 5346, 5225, 5410, 5984, 5410, 6097, 3165, 3350, 3165, 3221, 3166, 3318, 3166, 
		3351, 5972, 5473, 5972, 5996, 5973, 5530, 5973, 5474, 3496, 3319, 3496, 3167, 3496, 3608, 3496, 
		3320, 5531, 5188, 5531, 5475, 5531, 5252, 5531, 5189, 5141, 5410, 5097, 5312, 4910, 5360, 4910, 
		4913, 4517, 4567, 4517, 3749, 3741, 3014, 3012, 2483, 3012, 3093, 3012, 3810, 5141, 5370, 5141, 
		5411, 3979, 3607, 3979, 3497, 3980, 4015, 3608, 3984, 3624, 3928, 3544, 3820, 3410, 3724, 3265, 
		3644, 3194, 3600, 3148, 3602, 3099, 3602, 3585, 5253, 5098, 5253, 5190, 5254, 5142, 5254, 5099, 
		2264, 2700, 2264, 2770, 2380, 2371, 2380, 2156, 2380, 2082, 2264, 2700, 3251, 2700, 3485, 2770, 
		3485, 3735, 4923, 5330, 5337, 5695, 5716, 5917, 5914, 4926, 4802, 5330, 5300, 5695, 5300, 5745, 
		5300, 5732, 4995, 4924, 4995, 5337, 5389, 5716, 5772, 5914, 5772, 5938, 4301, 3250, 4301, 3852, 
		4302, 3486, 4302, 3249, 5915, 5918, 5267, 5918, 5787, 3854, 3250, 3854, 3231, 3798, 4432, 4303, 
		4432, 3853, 3798, 4293, 3798, 4338, 3854, 4338, 4433, 2246, 2082, 2246, 2157, 4332, 4803, 4332, 
		4925, 4332, 3940, 4332, 4804, 378, 4, 128, 760, 378, 1463, 1806, 1463, 2465, 2149, 3304, 
		3005, 4064, 3327, 3973, 3908, 3973, 4868, 4594, 5165, 4886, 5008, 4719, 4200, 4064, 4200, 3304, 
		4424, 4926, 4424, 4995, 4606, 4998, 4606, 5295, 4606, 5132, 4606, 4953, 4388, 4537, 4388, 4281, 
		4211, 3899, 3893, 3899, 3568, 3534, 3568, 3162, 3223, 3162, 3068, 2897, 2977, 2784, 2977, 2693, 
		3057, 2704, 3057, 2759, 3057, 3175, 2412, 2258, 2834, 2214, 2634, 2214, 2568, 2298, 2568, 2471, 
		2621, 2713, 2786, 2713, 3059, 2989, 3059, 3374, 3377, 3374, 3731, 3793, 3930, 4129, 3930, 4519, 
		4234, 4519, 4681, 4519, 4882, 4681, 4882, 4681, 5078, 3881, 4101, 3881, 4243, 3775, 3645, 3775, 
		3805, 3950, 3388, 3446, 3720, 3708, 3488, 3646, 3488, 3416, 3212, 3416, 3267, 3647, 3417, 3647, 
		3661, 3647, 3805, 3709, 3648, 3709, 3775, 3975, 3950, 4212, 3950, 4177, 3950, 3957, 3805, 3774, 
		3661, 3479, 3417, 3479, 3266, 3479, 3264, 3479, 3535, 3774, 3598, 3489, 3598, 3710, 3832, 3913, 
		3832, 3660, 3832, 3575, 4480, 4269, 4480, 4092, 4480, 4340, 3576, 3310, 3576, 3283, 4682, 4341, 
		4682, 4504, 3914, 3986, 3914, 3768, 3660, 3473, 3660, 3311, 3660, 3576, 4469, 4297, 4469, 4270, 
		4469, 4480, 4641, 4480, 4683, 4480, 4341, 3684, 3831, 3684, 3577, 3684, 3400, 3563, 3271, 4342, 
		4091, 4342, 3964, 4226, 3886, 4035, 3400, 3578, 3400, 3284, 3400, 3157, 3271, 3117, 3271, 3071, 
		3206, 4505, 4343, 4505, 4226, 4430, 4035, 4354, 4035, 4244, 3881, 3241, 3474, 3241, 3769, 4470, 
		4642, 4470, 4507, 3759, 3514, 3759, 3451, 3582, 3357, 3701, 3785, 3701, 3760, 3701, 3583, 3615, 
		3267, 3213, 3267, 3018, 3070, 3051, 3070, 3206, 4102, 3976, 4102, 4213, 3116, 2956, 3116, 2950, 
		3145, 3022, 3176, 3242, 3540, 3769, 3540, 3985, 3806, 4170, 4034, 4296, 4333, 4470, 4333, 4508, 
		4333, 4407, 4333, 4220, 4034, 3974, 4034, 3720, 3806, 3446, 3540, 3446, 3176, 3446, 3145, 3388, 
		3116, 4212, 4177, 4212, 4370, 2955, 3072, 2955, 2951, 2955, 3053, 2955, 3073, 4245, 4213, 4245, 
		4371, 4246, 4103, 4246, 4213, 3489, 3280, 3489, 3214, 3598, 3280, 3598, 3490, 3966, 3915, 3966, 
		3832, 4271, 3967, 4271, 4092, 4272, 4089, 3968, 4089, 3916, 4090, 4171, 4090, 3986, 4090, 3917, 
		4171, 4090, 4171, 4297, 4297, 4090, 4297, 4273, 3859, 3833, 3859, 3684, 3759, 3563, 3514, 3271, 
		3451, 3206, 3357, 3206, 3193, 3206, 3054, 3859, 3969, 3859, 3834, 4093, 3860, 3964, 3760, 3886, 
		3785, 4035, 3701, 3881, 3615, 3767, 3598, 3905, 3711, 3905, 3976, 3905, 4104, 3767, 4094, 3970, 
		4094, 3860, 3107, 3312, 3107, 3475, 3107, 3243, 3107, 3022, 4643, 4684, 4643, 4599, 4509, 4471, 
		4407, 4314, 4220, 4095, 3974, 3883, 3720, 3637, 3388, 3301, 3116, 3128, 2956, 3128, 3018, 3128, 
		3268, 3128, 3264, 3301, 3535, 3637, 3774, 3883, 3957, 4095, 4177, 4314, 4370, 4471, 3158, 3285, 
		3158, 3313, 3158, 3108, 3118, 3023, 3118, 2951, 3118, 3073, 4685, 4506, 4685, 4431, 4600, 4355, 
		4472, 4355, 4371, 4355, 4246, 4100, 3881, 4100, 3767, 3017, 3052, 3017, 2955, 3084, 3050, 3084, 
		3017, 3084, 3211, 3280, 3050, 3084, 3193, 3280, 3357, 3493, 3581, 3493, 3615, 3493, 3598, 3280, 
		1084, 1793, 1084, 1630, 1126, 1818, 1456, 1482, 1456, 1359, 1152, 1503, 1401, 1682, 1607, 1682, 
		1872, 1152, 680, 1456, 680, 1126, 424, 1084, 3402, 3830, 4292, 3402, 2938, 3830, 3260, 3172, 
		3260, 4195, 3260, 4257, 3445, 4319, 3670, 2408, 2670, 2408, 2312, 2408, 1987, 6209, 6747, 6209, 
		6556, 1986, 2313, 1986, 1990, 6218, 6207, 6218, 6555, 6433, 6555, 7256, 6555, 7081, 1989, 2311, 
		1989, 1935, 1989, 1871, 1989, 1459, 1989, 1868, 6771, 6930, 6771, 6746, 7085, 6930, 6771, 1857, 
		2408, 1857, 1985, 2120, 2408, 2120, 1857, 2120, 1773, 1991, 1649, 1818, 1649, 1482, 6958, 6930, 
		7085, 6282, 6217, 6282, 6432, 1870, 1934, 1870, 1606, 6665, 6456, 6665, 7271, 6664, 7271, 6664, 
		7078, 869, 1358, 869, 1481, 869, 1480, 869, 1366, 7077, 7270, 7077, 7490, 7077, 7457, 806, 
		868, 806, 1365, 806, 1332, 7456, 7489, 7456, 7487, 7448, 7255, 7448, 7080, 1071, 805, 1071, 
		1331, 1071, 1583, 1458, 1583, 1867, 6455, 6400, 6801, 6911, 6801, 7092, 6801, 7112, 6454, 6801, 
		6454, 6781, 7269, 7339, 7488, 7468, 7486, 7445, 7254, 7245, 6432, 6770, 6427, 6911, 6427, 6400, 
		1293, 1502, 1293, 1357, 1293, 1356, 1254, 867, 934, 804, 872, 1070, 1080, 1457, 1321, 1870, 
		1610, 1681, 1372, 1502, 1372, 1293, 1198, 1293, 1089, 6769, 6926, 6769, 6910, 6727, 6926, 6727, 
		6769, 1528, 1609, 1528, 1371, 1745, 1609, 1745, 1528, 1745, 1791, 6800, 6829, 6800, 6743, 6799, 
		6743, 6799, 6780, 1404, 1450, 1404, 1292, 1404, 1291, 1404, 1253, 6779, 6742, 6779, 7294, 6778, 
		7293, 6778, 7338, 960, 1403, 960, 1252, 959, 1251, 959, 933, 7337, 7292, 7337, 7463, 7337, 
		7467, 973, 958, 973, 932, 973, 871, 7466, 7462, 7466, 7436, 7444, 7182, 7444, 7244, 1209, 
		972, 1209, 870, 1209, 1079, 1497, 1079, 1320, 7243, 7181, 7243, 6726, 7242, 6726, 7242, 6768, 
		1744, 1496, 1744, 1319, 1744, 1318, 1744, 1608, 6957, 6837, 6957, 7069, 6957, 7165, 6929, 7133, 
		6745, 7133, 6984, 1353, 1648, 1353, 1772, 1512, 1856, 1638, 1984, 1638, 1810, 7076, 7164, 7076, 
		7068, 7455, 7164, 7455, 7076, 7132, 7164, 7132, 7455, 7132, 7447, 6983, 7079, 6983, 6554, 1511, 
		1364, 1511, 1352, 1330, 1364, 1330, 1511, 1330, 1637, 1582, 1809, 1866, 1809, 1988, 6836, 6663, 
		6836, 7076, 6835, 7075, 6835, 7067, 1479, 1647, 1479, 1364, 1646, 1351, 1646, 1363, 6556, 6744, 
		6556, 6984, 1810, 1983, 1810, 1990, 6925, 6828, 6925, 7131, 6925, 7103, 1263, 1449, 1263, 1527, 
		1263, 1370, 6829, 6798, 6829, 7111, 6829, 7130, 1088, 1290, 1088, 1450, 1088, 1262, 6910, 6924, 
		6910, 7102, 6910, 7091, 1369, 1526, 1369, 1371, 1369, 1197, 7090, 7101, 7090, 7129, 7090, 7110, 
		1261, 1368, 1261, 1196, 1261, 1087, 6827, 6923, 6827, 6870, 6827, 6756, 1791, 1525, 1791, 1448, 
		1791, 1726, 6826, 6756, 6826, 7294, 6825, 7291, 6825, 6741, 960, 1726, 960, 1447, 957, 1446, 
		957, 1402, 6725, 7180, 6869, 7435, 7283, 7461, 7268, 7291, 7268, 6755, 7283, 6755, 6869, 6870, 
		6926, 6870, 6727, 1790, 1495, 1790, 1743, 1208, 1495, 1208, 1790, 1501, 1725, 1362, 957, 1362, 
		971, 1501, 971, 1208, 2165, 2113, 2165, 2166, 2268, 2240, 2268, 2442, 2268, 2513, 4205, 3758, 
		4205, 4248, 3721, 3758, 3721, 4205, 4452, 4204, 4452, 4248, 4468, 2397, 2309, 2397, 2175, 2309, 
		2397, 2309, 2680, 2615, 3140, 3080, 3140, 3721, 3140, 3758, 2176, 2273, 2176, 2397, 3855, 4311, 
		3855, 4349, 3855, 3880, 3207, 3277, 3207, 2814, 2748, 2512, 2748, 2442, 4311, 4553, 4311, 4348, 
		4520, 4553, 4520, 4311, 4553, 4362, 4553, 4347, 4581, 4362, 4581, 4553, 4668, 4520, 4668, 4658, 
		4668, 4754, 4725, 4754, 4788, 2526, 2268, 2526, 2511, 2387, 2268, 2387, 2526, 4346, 4362, 4346, 
		3901, 3879, 3323, 3276, 3323, 2813, 2841, 2510, 2841, 2526, 4467, 4492, 4467, 4652, 4492, 4467, 
		4492, 4247, 4249, 3757, 3761, 3139, 3135, 3139, 2669, 2679, 2388, 2396, 2259, 2272, 2259, 2210, 
		4466, 4651, 4632, 4651, 4787, 2211, 2271, 2211, 2205, 2164, 2209, 2164, 2205, 4725, 4581, 4668, 
		2267, 2268, 2267, 2387, 2165, 2268, 2165, 2267, 3614, 3704, 3614, 4198, 4130, 4198, 4487, 4692, 
		4486, 4692, 4197, 4485, 4525, 4485, 4130, 4779, 4691, 4779, 4831, 4778, 4830, 4778, 4864, 2054, 
		2084, 2054, 1948, 2053, 1947, 2053, 1966, 4863, 4835, 4863, 4744, 4862, 4744, 4862, 4840, 2124, 
		2055, 2124, 1965, 2126, 1964, 2126, 2057, 2126, 2233, 4577, 4637, 4577, 4839, 4578, 4838, 4578, 
		4743, 2056, 2256, 2056, 2232, 2256, 2459, 2256, 2231, 4525, 4485, 4525, 4695, 2086, 2136, 2086, 
		2063, 2083, 2061, 2083, 1950, 2490, 2498, 2490, 2330, 2338, 2102, 2107, 1815, 1877, 1461, 1541, 
		1212, 1288, 1151, 1219, 1135, 1219, 1170, 4032, 4379, 4397, 4379, 4704, 4702, 4958, 4966, 5022, 
		4966, 5014, 4031, 4397, 4031, 4060, 3746, 3814, 3746, 3556, 1776, 1750, 1776, 2018, 1750, 1776, 
		1750, 1475, 1407, 1260, 1180, 1169, 1180, 1134, 1776, 2017, 2025, 2225, 2218, 2225, 2428, 5013, 
		4939, 5013, 5021, 4942, 4939, 4942, 5013, 4762, 4939, 4762, 4942, 4762, 4775, 4456, 4462, 4156, 
		4112, 4156, 3812, 3555, 3814, 3555, 3677, 2218, 2427, 2218, 2420, 3442, 3554, 3442, 3676, 3442, 
		3570, 2419, 2426, 2419, 2497, 2419, 2489, 3441, 3508, 3441, 3553, 2447, 2497, 2447, 2425, 3440, 
		3346, 3440, 3467, 3441, 3469, 3441, 3507, 2453, 2479, 2453, 2496, 2455, 2497, 2455, 2446, 2045, 
		1635, 1724, 1635, 1232, 1723, 1231, 1322, 1094, 1154, 969, 1150, 969, 1133, 1074, 1161, 1121, 
		1161, 1379, 1634, 1158, 1634, 1232, 3725, 3736, 3725, 3506, 3725, 3508, 3725, 3469, 2445, 2221, 
		2229, 2039, 2023, 2447, 2229, 2447, 2455, 3736, 3552, 3736, 3508, 2424, 2221, 2424, 2447, 1043, 
		1232, 1043, 1157, 1042, 1156, 1042, 968, 1094, 1231, 1094, 1041, 969, 968, 922, 791, 841, 
		595, 691, 453, 784, 404, 784, 1018, 970, 1246, 1243, 1485, 1579, 1817, 1579, 1894, 1579, 
		1241, 1085, 1139, 1085, 1183, 1243, 1579, 1243, 1085, 970, 914, 784, 914, 691, 913, 841, 
		940, 922, 1010, 969, 1010, 1074, 1010, 1121, 1105, 1350, 1323, 1740, 1272, 1721, 1272, 1182, 
		404, 453, 403, 453, 607, 864, 1216, 1035, 1462, 1035, 1155, 1035, 968, 1035, 791, 864, 
		595, 453, 1010, 940, 1105, 1073, 1323, 1073, 1272, 999, 1181, 999, 1085, 999, 914, 999, 
		913, 1073, 940, 1350, 1740, 1350, 1730, 1350, 1378, 1121, 3181, 3315, 3181, 3169, 3346, 3315, 
		3346, 3181, 2348, 2503, 2348, 2351, 2479, 2503, 2479, 2348, 2345, 2070, 2091, 1797, 1814, 1797, 
		1460, 1387, 1211, 1154, 1211, 1150, 1387, 1322, 1154, 3346, 3439, 3346, 3418, 3315, 2495, 2479, 
		2495, 2345, 1133, 1161, 1179, 1161, 1406, 1378, 1406, 1749, 2091, 1813, 2091, 2102, 2345, 2330, 
		2345, 2494, 4087, 4112, 4087, 4461, 5034, 4985, 5034, 4732, 3745, 4012, 4031, 4012, 4386, 2010, 
		2224, 2010, 2017, 2010, 1729, 3744, 4013, 4011, 4013, 4385, 4413, 4777, 4855, 5090, 5177, 5339, 
		5421, 5244, 5403, 5271, 5412, 4815, 4999, 4815, 4202, 4598, 4111, 4584, 4075, 4556, 4072, 4514, 
		4068, 4482, 4087, 4482, 4460, 4482, 4774, 4814, 4941, 5087, 5012, 5101, 4985, 5101, 5034, 5212, 
		5090, 5212, 5339, 5150, 5244, 5062, 5271, 5062, 4815, 5062, 4598, 4933, 4584, 4933, 4556, 4867, 
		4514, 4814, 4482, 5122, 4999, 5122, 5412, 5680, 5754, 6008, 5909, 6053, 5954, 6099, 5954, 5908, 
		5673, 5708, 5673, 5162, 5673, 5055, 5954, 5909, 5673, 5669, 5380, 5421, 5380, 5177, 4936, 4855, 
		4936, 4413, 4438, 4016, 4002, 4016, 3725, 4016, 3736, 4017, 3747, 4013, 3747, 3743, 3747, 3551, 
		3736, 5909, 5754, 5669, 5403, 5421, 5754, 5412, 5403, 5212, 5087, 5101, 5150, 5087, 5212, 5034, 
		4777, 5090, 4814, 5087, 4867, 5087, 4933, 5150, 5062, 4017, 4016, 4017, 4413, 4013, 4965, 4985, 
		4965, 5012, 4731, 4777, 4731, 5034, 4985, 4965, 4985, 4701, 4731, 4701, 4378, 4384, 4378, 4384, 
		4030, 2016, 1749, 1728, 1749, 1377, 4731, 4385, 4777, 4378, 4384, 4378, 4730, 5172, 5145, 5172, 
		5288, 5328, 5304, 5342, 5183, 5175, 5043, 5000, 4747, 4906, 4464, 4906, 5105, 4906, 5195, 5175, 
		5572, 5342, 5572, 5328, 5641, 5328, 5442, 5328, 5173, 4256, 4056, 4256, 3841, 4256, 3997, 4540, 
		4380, 4856, 4747, 4856, 5043, 5091, 5183, 5250, 5304, 5367, 5288, 5350, 5144, 5350, 5216, 5452, 
		5216, 5274, 5007, 5033, 4755, 5033, 4751, 4955, 5144, 4955, 5171, 4948, 5144, 4948, 4955, 4948, 
		4623, 4948, 4648, 5007, 4648, 4755, 4440, 4489, 4290, 4489, 4265, 4489, 4465, 4489, 4750, 4755, 
		4055, 4141, 3924, 4141, 4126, 4055, 3923, 4055, 3839, 4141, 4253, 4141, 4125, 4382, 4648, 4382, 
		4622, 4440, 4648, 4440, 4382, 4253, 4382, 4124, 4751, 4647, 4751, 5036, 4647, 4751, 4647, 4465, 
		4363, 4465, 4028, 4264, 4028, 3861, 4749, 5036, 5032, 5036, 5395, 3861, 4263, 3861, 4176, 3887, 
		4176, 4147, 5031, 5395, 5273, 5737, 5273, 5451, 5092, 4712, 5092, 4708, 4229, 3889, 4229, 4146, 
		4231, 4145, 4231, 4367, 5450, 5737, 5450, 5853, 5449, 5853, 5501, 5550, 5348, 5321, 5202, 5026, 
		4911, 4592, 4540, 4592, 4256, 4320, 4055, 4320, 4133, 4320, 4366, 5092, 5026, 5092, 5321, 4707, 
		5026, 4707, 5092, 4711, 4229, 4711, 4365, 4710, 4367, 4706, 4320, 4706, 4592, 4440, 4253, 4290, 
		4185, 4176, 4185, 4144, 4253, 4141, 4185, 4132, 4185, 4143, 4264, 4290, 4264, 4176, 5007, 5216, 
		4948, 5216, 5143, 4132, 4141, 4132, 4054, 4540, 4856, 4911, 5091, 5202, 5250, 5348, 5367, 5501, 
		5350, 5501, 5448, 4707, 4592, 5026, 4366, 4142, 4366, 4131, 2350, 2416, 2174, 2416, 2254, 2545, 
		2174, 2044, 2174, 2352, 1636, 1462, 1636, 1156, 5054, 5380, 5054, 4936, 5673, 5380, 5673, 5053, 
		4438, 4488, 4438, 5052, 5051, 4936, 5051, 4438, 1678, 1721, 1678, 1181, 1678, 1137, 4488, 5161, 
		4488, 5054, 4488, 4438, 4488, 4002, 4554, 4046, 4554, 4574, 4554, 5231, 4554, 5162, 4488, 6391, 
		6447, 6391, 6503, 6391, 6502, 6391, 6343, 734, 639, 310, 639, 275, 733, 310, 733, 328, 
		6446, 6688, 6446, 6503, 1195, 638, 1195, 734, 6377, 6409, 6377, 6646, 6376, 6646, 6376, 6581, 
		1009, 854, 1112, 854, 789, 1009, 1111, 1009, 1309, 5585, 5593, 5585, 5426, 5585, 5458, 550, 
		656, 550, 665, 550, 585, 5457, 5425, 5457, 5407, 5456, 5407, 5456, 5419, 388, 549, 388, 
		584, 388, 583, 388, 437, 5592, 5486, 5592, 5424, 5668, 5486, 5668, 5592, 485, 655, 485, 
		548, 510, 655, 510, 485, 510, 446, 5423, 5485, 5423, 5492, 5423, 5406, 333, 484, 333, 
		547, 333, 387, 6646, 6852, 6646, 6774, 6646, 6773, 6646, 6580, 1468, 1423, 1009, 1423, 1132, 
		1467, 1009, 1467, 1308, 6579, 6772, 6783, 6951, 7109, 7141, 7341, 7141, 7327, 7027, 7267, 7027, 
		7223, 6972, 7214, 7036, 7214, 7043, 6578, 6783, 6688, 6783, 6501, 6561, 6350, 6571, 6363, 6574, 
		6566, 6905, 6871, 7013, 6969, 7057, 7074, 7057, 7118, 7095, 7145, 7095, 7194, 1221, 1466, 1221, 
		1307, 1221, 1306, 1221, 1195, 1221, 732, 713, 318, 594, 263, 534, 491, 911, 800, 1063, 
		986, 1119, 1091, 1119, 1178, 1242, 1336, 1242, 1522, 5570, 5469, 5570, 5394, 5570, 5484, 823, 
		660, 823, 743, 823, 857, 5569, 5613, 5569, 5469, 5674, 5613, 5674, 5569, 463, 742, 463, 
		660, 533, 742, 533, 463, 513, 463, 402, 5393, 5468, 5393, 5402, 5392, 5402, 5392, 5366, 
		554, 659, 554, 822, 554, 821, 554, 701, 5516, 5401, 5516, 5467, 5516, 5612, 5516, 5722, 
		5617, 5795, 5667, 5795, 5686, 658, 553, 658, 438, 462, 438, 401, 364, 344, 341, 344, 
		316, 6447, 6316, 6447, 6293, 6447, 6523, 6688, 6523, 6579, 6523, 6375, 6523, 6176, 893, 589, 
		893, 639, 1072, 1195, 1072, 1307, 1072, 1110, 1072, 947, 6523, 6292, 6523, 6175, 946, 892, 
		946, 1072, 6447, 6391, 6447, 6334, 6445, 6334, 6445, 6315, 275, 637, 275, 588, 6376, 6175, 
		6376, 6186, 6186, 6409, 6186, 6377, 789, 946, 789, 1111, 5711, 5833, 5711, 5913, 5711, 5766, 
		5711, 5600, 748, 531, 748, 546, 746, 546, 759, 5710, 5764, 5710, 5877, 5709, 5877, 5709, 
		5832, 303, 363, 545, 379, 545, 574, 303, 544, 303, 530, 6906, 7042, 6906, 7036, 6906, 
		6972, 6951, 7027, 7141, 1767, 1714, 1767, 1573, 1707, 1437, 1616, 1595, 1823, 1595, 1742, 1383, 
		1329, 911, 1283, 1063, 1473, 1242, 1473, 1521, 1643, 1521, 1618, 1742, 1329, 1702, 1283, 1680, 
		1473, 1680, 1643, 7041, 7325, 7041, 7214, 1885, 1848, 1885, 1713, 1885, 1712, 1885, 1767, 1885, 
		1707, 1897, 1616, 1882, 1823, 6906, 6951, 6906, 6772, 1437, 1573, 1437, 1466, 1437, 1221, 1383, 
		967, 911, 967, 534, 967, 594, 967, 713, 1221, 7222, 7213, 7222, 7324, 7222, 7376, 7222, 
		7392, 7266, 7403, 7326, 7401, 7340, 7395, 7331, 7388, 7329, 7373, 7279, 7373, 7321, 7373, 7385, 
		1847, 1884, 1847, 1896, 1834, 1896, 1821, 1881, 1784, 1822, 1737, 1741, 1677, 1701, 1615, 1679, 
		1572, 1642, 1572, 1556, 1572, 1386, 6852, 7043, 6852, 6906, 6851, 6906, 6851, 6774, 1573, 1712, 
		1573, 1423, 1573, 1422, 1573, 1468, 6342, 6481, 6342, 6560, 6342, 6559, 6342, 6390, 142, 151, 
		327, 151, 317, 125, 317, 262, 141, 327, 141, 309, 1383, 1595, 1437, 6481, 6342, 6481, 
		6349, 6471, 6349, 6362, 6503, 6350, 6503, 6343, 318, 734, 318, 328, 6389, 6559, 6389, 6415, 
		6388, 6414, 6388, 6333, 209, 141, 209, 308, 208, 307, 208, 274, 6364, 6728, 6364, 6673, 
		6364, 6672, 6364, 6308, 6364, 6069, 571, 406, 342, 406, 207, 217, 140, 217, 149, 321, 
		134, 384, 153, 405, 306, 562, 448, 726, 555, 720, 725, 720, 851, 726, 910, 895, 
		1206, 1210, 1454, 1535, 1783, 1580, 1820, 1580, 1833, 570, 342, 509, 342, 272, 6408, 6185, 
		6307, 6185, 6028, 6407, 6307, 6407, 6671, 508, 788, 508, 853, 508, 852, 508, 569, 7375, 
		7323, 7420, 7323, 7396, 7323, 7281, 1656, 1846, 1656, 1832, 5491, 5485, 5491, 5538, 445, 484, 
		445, 332, 5486, 5668, 5486, 5537, 5932, 5870, 5932, 5771, 5931, 5770, 5931, 5736, 474, 400, 
		478, 400, 354, 473, 477, 473, 606, 5735, 5771, 5735, 5668, 5735, 5591, 510, 474, 510, 
		605, 510, 654, 5798, 5930, 5798, 5734, 5798, 5733, 5693, 5733, 5593, 604, 476, 604, 536, 
		603, 536, 603, 620, 603, 656, 5692, 5590, 5692, 5584, 653, 619, 653, 664, 5713, 5698, 
		5713, 5506, 5713, 5505, 5597, 5405, 5597, 5492, 252, 148, 133, 148, 92, 148, 79, 251, 
		133, 251, 197, 386, 197, 333, 5697, 5651, 5697, 5515, 5697, 5514, 5504, 5514, 5418, 367, 
		282, 367, 147, 366, 147, 366, 250, 366, 436, 5503, 5419, 5503, 5404, 437, 249, 437, 
		385, 5571, 5691, 5571, 5583, 5571, 5455, 663, 618, 663, 523, 663, 582, 5513, 5571, 5513, 
		5454, 5571, 5513, 5571, 5650, 5717, 5757, 5825, 5856, 5926, 6082, 6118, 6142, 6118, 6201, 5690, 
		5571, 5690, 5717, 5797, 5825, 5797, 5990, 5513, 5453, 5513, 5417, 581, 523, 366, 523, 281, 
		523, 441, 617, 441, 535, 360, 535, 383, 580, 365, 580, 435, 5536, 5596, 5536, 5490, 
		5596, 5536, 5596, 5819, 5712, 5871, 5783, 5871, 6018, 6080, 6018, 6155, 331, 196, 444, 196, 
		248, 132, 195, 91, 195, 100, 233, 100, 181, 5869, 5535, 5869, 5769, 5819, 5535, 5819, 
		5869, 5819, 5935, 5871, 5935, 6080, 443, 399, 443, 472, 248, 399, 248, 443, 5768, 5534, 
		5768, 5668, 442, 471, 442, 510, 5907, 5855, 5907, 5756, 5907, 5755, 5697, 5755, 5649, 193, 
		127, 78, 127, 27, 281, 192, 281, 78, 281, 147, 5957, 5698, 5957, 5782, 5906, 5698, 
		5906, 5957, 5906, 6051, 79, 68, 79, 90, 5698, 5713, 5698, 5781, 5929, 5798, 5929, 5989, 
		382, 536, 382, 475, 5929, 5988, 5929, 6074, 381, 475, 381, 348, 5870, 5932, 5934, 6073, 
		6079, 6073, 6154, 347, 477, 347, 354, 347, 232, 347, 180, 191, 280, 191, 441, 191, 
		360, 126, 289, 72, 172, 70, 172, 163, 5825, 5926, 5825, 5987, 289, 360, 289, 380, 
		399, 248, 353, 195, 353, 233, 5780, 6018, 5956, 6018, 6050, 100, 89, 100, 67, 100, 
		45, 5516, 5388, 5516, 5400, 5502, 5388, 5502, 5516, 5502, 5617, 5502, 5666, 526, 438, 526, 
		552, 414, 438, 414, 526, 5399, 5387, 5399, 5365, 700, 525, 700, 551, 5705, 5762, 5705, 
		5674, 5705, 5568, 533, 512, 533, 751, 533, 741, 5828, 5794, 5828, 5721, 5827, 5721, 5827, 
		5762, 402, 343, 402, 481, 402, 480, 402, 512, 5761, 5721, 5761, 5613, 5761, 5674, 5376, 
		5444, 5376, 5391, 5444, 5376, 5444, 5431, 5494, 5431, 5462, 5376, 5392, 5376, 5364, 820, 887, 
		755, 887, 716, 863, 716, 643, 821, 755, 821, 699, 5657, 5777, 5705, 5777, 5760, 5777, 
		5826, 5865, 5826, 5925, 5656, 5705, 5557, 5567, 5557, 5483, 751, 744, 751, 878, 744, 751, 
		744, 511, 744, 479, 661, 479, 434, 751, 877, 751, 885, 740, 885, 856, 5493, 5655, 
		5493, 5556, 5493, 5555, 5443, 5555, 5484, 884, 876, 884, 862, 883, 862, 883, 886, 883, 
		857, 1149, 1683, 1641, 2021, 2019, 2250, 2019, 2237, 2023, 2237, 2229, 2237, 2454, 855, 886, 
		855, 823, 364, 438, 364, 414, 364, 340, 5363, 5379, 5376, 5379, 5430, 710, 698, 710, 
		755, 710, 715, 5386, 5379, 5386, 5362, 5379, 5386, 5379, 5549, 5429, 5539, 5429, 5461, 697, 
		710, 524, 710, 449, 714, 418, 714, 642, 5665, 5387, 5665, 5502, 5549, 5387, 5549, 5665, 
		5549, 5685, 525, 339, 525, 414, 449, 339, 449, 525, 5599, 5742, 5599, 5654, 5599, 5653, 
		5599, 5493, 875, 786, 758, 786, 745, 783, 747, 797, 769, 843, 769, 946, 874, 758, 
		874, 862, 5741, 5777, 5741, 5652, 5865, 5777, 5865, 5741, 5865, 5892, 5998, 6143, 6033, 6143, 
		6213, 6143, 6272, 6039, 6143, 6039, 5892, 744, 785, 744, 873, 661, 785, 744, 5879, 5684, 
		5879, 5795, 5753, 5684, 5753, 5879, 5753, 5992, 5880, 6106, 5986, 6239, 5986, 6139, 5880, 5986, 
		5880, 5876, 5880, 5764, 5633, 5710, 5633, 5548, 315, 320, 315, 344, 285, 320, 285, 315, 
		3653, 3613, 4051, 418, 284, 418, 314, 5539, 5549, 5539, 5683, 449, 418, 449, 313, 314, 
		339, 314, 449, 5633, 5547, 5633, 5460, 5633, 5539, 5633, 5751, 5880, 641, 573, 641, 379, 
		418, 379, 283, 379, 261, 363, 261, 302, 261, 182, 219, 182, 190, 182, 131, 305, 
		261, 305, 219, 5459, 5600, 5459, 5494, 5600, 5459, 5600, 5546, 5600, 5709, 863, 759, 640, 
		759, 572, 759, 544, 5924, 5878, 5924, 5794, 343, 319, 343, 433, 5923, 5794, 5923, 5827, 
		343, 432, 343, 480, 6141, 6328, 6141, 6206, 6234, 6404, 6234, 6489, 23, 11, 23, 20, 
		6227, 6426, 6227, 6348, 6226, 6348, 6226, 6200, 231, 312, 203, 312, 242, 312, 246, 338, 
		276, 423, 361, 566, 491, 566, 800, 566, 731, 566, 518, 566, 412, 423, 231, 202, 
		231, 162, 6205, 6225, 6205, 6199, 6204, 6198, 6204, 6142, 161, 201, 161, 82, 160, 81, 
		160, 70, 44, 66, 44, 79, 43, 79, 43, 26, 6347, 6339, 6221, 6339, 6072, 215, 
		230, 215, 269, 215, 346, 6221, 6074, 6221, 5989, 348, 269, 348, 382, 6479, 6549, 6479, 
		6399, 6479, 6338, 6479, 6347, 6479, 6425, 6565, 6533, 6565, 6631, 6634, 6631, 6754, 6565, 6634, 
		6565, 6548, 6479, 99, 77, 99, 171, 214, 171, 230, 171, 311, 210, 337, 210, 237, 
		95, 237, 113, 95, 210, 76, 171, 6338, 6398, 6338, 6154, 6337, 6153, 6337, 6071, 180, 
		98, 180, 214, 179, 213, 179, 345, 5855, 5907, 5855, 6103, 5855, 6102, 6081, 6234, 6141, 
		6234, 6328, 6488, 6328, 6570, 25, 127, 25, 71, 19, 27, 19, 71, 20, 71, 20, 
		69, 36, 80, 36, 56, 36, 30, 20, 36, 22, 36, 29, 5906, 6049, 5906, 6191, 
		5906, 6190, 6101, 6190, 6403, 17, 42, 17, 26, 17, 10, 6100, 6403, 6100, 6234, 9, 
		24, 9, 18, 6331, 6397, 6331, 6547, 6331, 6522, 75, 97, 75, 49, 75, 35, 6050, 
		6123, 6331, 6123, 6396, 6123, 6152, 6123, 6018, 6123, 6049, 6049, 6331, 6189, 6331, 6521, 49, 
		73, 49, 45, 73, 49, 73, 96, 73, 178, 73, 100, 73, 41, 49, 41, 49, 
		16, 49, 34, 6191, 6521, 6191, 6402, 34, 15, 34, 8, 5926, 6118, 5990, 6118, 6220, 
		6118, 6197, 172, 289, 172, 383, 172, 268, 172, 159, 6220, 6196, 6220, 6348, 158, 268, 
		158, 231, 6650, 6489, 6650, 6520, 23, 53, 23, 33, 6633, 6649, 6633, 6519, 6633, 6549, 
		32, 52, 32, 94, 32, 77, 6426, 6227, 6426, 6281, 6426, 6367, 6532, 6406, 6553, 6431, 
		6690, 6566, 6690, 6871, 6690, 6848, 6690, 6662, 6690, 6615, 6553, 6204, 6280, 6204, 6224, 200, 
		241, 81, 241, 116, 5998, 6033, 5998, 5922, 5921, 5865, 5921, 5998, 431, 440, 657, 662, 
		782, 662, 796, 662, 842, 690, 842, 945, 662, 440, 662, 417, 662, 689, 430, 657, 
		661, 782, 785, 6032, 5878, 6032, 5920, 5991, 5878, 5991, 6032, 6105, 6212, 6105, 6255, 319, 
		439, 319, 429, 304, 439, 304, 319, 439, 304, 439, 218, 416, 218, 457, 261, 305, 
		285, 305, 320, 5742, 5599, 5742, 5765, 5891, 5912, 6038, 6027, 6114, 6027, 6175, 6271, 6254, 
		6271, 6211, 415, 456, 415, 688, 6254, 6238, 6254, 6105, 218, 189, 218, 456, 6068, 6012, 
		6068, 5831, 6068, 5830, 6068, 5875, 529, 506, 271, 506, 508, 528, 271, 528, 301, 6011, 
		6026, 6011, 5913, 6010, 5913, 6010, 5829, 748, 768, 505, 768, 507, 748, 504, 748, 527, 
		6138, 6069, 6138, 5877, 6138, 5986, 303, 272, 303, 130, 303, 182, 6143, 6039, 6143, 6113, 
		6270, 6113, 6174, 6605, 6593, 6605, 6541, 6604, 6541, 6604, 6493, 452, 496, 452, 377, 452, 
		376, 452, 293, 6992, 6931, 6992, 6824, 6991, 6824, 6991, 6855, 146, 216, 146, 359, 6931, 
		6845, 6931, 6687, 6931, 6686, 6931, 6823, 88, 157, 216, 157, 229, 87, 216, 87, 145, 
		6914, 6990, 6914, 6854, 6913, 6854, 6913, 6782, 6719, 6782, 6638, 6611, 6538, 6611, 6165, 358, 
		490, 358, 420, 6630, 6685, 6630, 6844, 156, 86, 156, 177, 6492, 6629, 6492, 6603, 176, 
		292, 176, 375, 6537, 6507, 6537, 6637, 6405, 6507, 6405, 6537, 6405, 6110, 6021, 6031, 5974, 
		5937, 5866, 5937, 5804, 398, 520, 398, 483, 419, 520, 419, 398, 739, 520, 739, 419, 
		596, 267, 596, 428, 696, 428, 503, 6405, 6439, 6405, 6506, 6303, 6439, 6303, 6405, 6303, 
		6021, 5961, 5974, 5961, 5888, 267, 419, 239, 419, 397, 6467, 6577, 6467, 6822, 6466, 6822, 
		6466, 6684, 144, 194, 121, 194, 236, 326, 413, 326, 467, 326, 352, 194, 144, 120, 
		144, 85, 6577, 6467, 6577, 6147, 6284, 6098, 6284, 6371, 6284, 6644, 6577, 6577, 6643, 6577, 
		6853, 6577, 6821, 300, 351, 300, 194, 300, 143, 6336, 6465, 6336, 6683, 6336, 6536, 84, 
		119, 84, 138, 84, 104, 5981, 6147, 5981, 6464, 5981, 6463, 5981, 6336, 118, 236, 118, 
		330, 117, 330, 117, 138, 6610, 6642, 6610, 6370, 6609, 6369, 6609, 6164, 466, 350, 470, 
		350, 420, 465, 469, 465, 709, 6782, 6855, 6782, 6641, 6642, 6610, 6642, 6782, 349, 299, 
		349, 420, 6538, 6163, 6109, 6037, 6030, 6037, 5936, 708, 468, 519, 468, 482, 420, 543, 
		489, 543, 635, 707, 519, 707, 738, 707, 840, 5981, 6024, 5981, 6146, 235, 323, 330, 
		323, 408, 426, 487, 494, 487, 652, 6162, 6370, 6162, 6151, 6162, 6007, 6036, 5953, 6036, 
		5815, 564, 466, 564, 706, 750, 839, 803, 839, 925, 6491, 6541, 6491, 6505, 6491, 6439, 
		396, 452, 396, 291, 396, 239, 6540, 6718, 6540, 6637, 6718, 6540, 6718, 6592, 6718, 6661, 
		6539, 6637, 6539, 6504, 483, 542, 451, 542, 495, 542, 517, 483, 450, 483, 395, 6535, 
		6682, 6535, 6628, 83, 103, 83, 175, 6438, 6627, 6438, 6490, 6534, 6627, 6534, 6438, 6534, 
		6302, 6335, 5960, 5980, 5887, 5980, 5864, 174, 238, 174, 290, 102, 238, 102, 174, 266, 
		238, 266, 102, 266, 137, 427, 329, 502, 329, 407, 298, 357, 298, 420, 825, 739, 
		825, 596, 825, 696, 916, 790, 916, 1006, 5866, 5776, 5866, 5886, 5974, 501, 610, 501, 
		790, 501, 696, 738, 824, 838, 915, 838, 1022, 6024, 5981, 6024, 5863, 5873, 5759, 5791, 
		5759, 5624, 5864, 5885, 5864, 5775, 5864, 5758, 609, 500, 609, 407, 609, 486, 802, 925, 
		802, 939, 5678, 5644, 5678, 5578, 765, 599, 630, 599, 493, 5644, 5678, 5644, 5790, 5814, 
		5639, 5814, 5730, 5952, 5638, 5952, 5813, 882, 801, 882, 938, 5637, 5678, 5637, 5577, 764, 
		630, 764, 881, 5662, 5727, 5662, 5629, 5661, 5628, 5661, 5554, 965, 912, 754, 912, 609, 
		912, 790, 912, 1005, 964, 753, 964, 849, 5727, 5662, 5727, 5775, 5727, 5866, 5727, 5803, 
		5727, 5802, 5727, 5715, 5727, 5627, 1051, 1004, 1051, 912, 1051, 963, 5623, 5662, 5623, 5553, 
		5622, 5552, 5622, 5521, 848, 754, 848, 651, 847, 650, 847, 810, 5758, 5774, 5758, 5660, 
		5758, 5621, 752, 608, 752, 486, 752, 649, 5644, 5620, 5644, 5520, 5644, 5576, 809, 648, 
		809, 599, 809, 763, 5791, 5619, 5791, 5644, 647, 494, 647, 599, 5801, 5824, 5801, 5704, 
		5800, 5703, 5800, 5714, 1061, 1021, 1061, 1003, 1060, 1002, 1060, 1050, 5936, 6035, 5936, 5823, 
		5936, 5824, 5936, 5799, 1021, 915, 1021, 1001, 5822, 5815, 5822, 5729, 5822, 5728, 5822, 5702, 
		937, 925, 937, 1020, 937, 1059, 6034, 5812, 6034, 5821, 925, 837, 925, 1019, 5604, 5729, 
		5604, 5636, 937, 919, 937, 880, 5575, 5603, 5575, 5635, 879, 918, 879, 762, 5566, 5602, 
		5566, 5574, 5565, 5574, 5565, 5519, 761, 917, 761, 956, 761, 955, 761, 808, 5729, 5604, 
		5729, 5701, 5700, 5603, 5700, 5564, 919, 937, 919, 1058, 918, 1057, 918, 954, 5626, 5563, 
		5626, 5518, 5626, 5551, 807, 953, 807, 962, 807, 846, 5715, 5699, 5715, 5562, 3402, 3078, 
		3402, 2670, 2938, 2408, 3016, 2120, 2721, 1991, 2549, 1818, 2409, 1630, 2379, 1793, 2379, 2391, 
		3149, 3131, 3149, 3960, 3149, 4057, 3172, 4088, 4195, 4848, 4195, 4859, 4257, 4847, 4319, 4674, 
		4319, 4292, 3670, 3830, 3286, 2938, 3286, 3016, 3670, 2721, 3445, 2549, 3260, 2409, 3172, 2379, 
		3149, 952, 1056, 952, 1051, 951, 1051, 951, 961, 6804, 6863, 6804, 6793, 6804, 6792, 6804, 
		6737, 950, 994, 836, 994, 819, 949, 836, 949, 795, 6862, 6974, 6862, 6793, 1076, 993, 
		1076, 950, 7187, 7171, 7187, 7107, 695, 737, 861, 737, 890, 7170, 7066, 7170, 6947, 7169, 
		6946, 7169, 7106, 602, 736, 602, 694, 7127, 7186, 7127, 7029, 6973, 7029, 6917, 7029, 6889, 
		6777, 6945, 6777, 7065, 6777, 6878, 601, 629, 601, 669, 6736, 6777, 6736, 6877, 6735, 6876, 
		6804, 6942, 6804, 6884, 668, 628, 668, 794, 667, 793, 667, 836, 675, 836, 818, 6809, 
		6691, 6809, 6764, 6809, 6763, 6809, 6916, 931, 941, 1054, 941, 1265, 1129, 1265, 1361, 930, 
		1054, 930, 1025, 6691, 6809, 6691, 6430, 6319, 6430, 6305, 6691, 6701, 6691, 6762, 6607, 6701, 
		6607, 6691, 6607, 6318, 6607, 6233, 774, 941, 774, 929, 799, 941, 799, 774, 799, 990, 
		799, 1128, 941, 6712, 6820, 6712, 7034, 6711, 7034, 6711, 6944, 679, 772, 679, 684, 679, 
		579, 6478, 6819, 6478, 6710, 6576, 6819, 6576, 6478, 6394, 6478, 6288, 771, 813, 771, 683, 
		898, 813, 898, 771, 6820, 6900, 6820, 7084, 6818, 7084, 6818, 7033, 828, 902, 828, 772, 
		828, 770, 828, 678, 6576, 6899, 6576, 6820, 6640, 6899, 6640, 6576, 6640, 6394, 6473, 6108, 
		6167, 6083, 6112, 5860, 6112, 6016, 901, 898, 901, 772, 1045, 898, 1045, 901, 6617, 6709, 
		6617, 6943, 6617, 6776, 578, 712, 578, 627, 682, 712, 682, 578, 6251, 6477, 6251, 6708, 
		6251, 6707, 6251, 6617, 681, 812, 681, 897, 897, 712, 897, 682, 6606, 6775, 6606, 6700, 
		6616, 6775, 6616, 6606, 6616, 6232, 6250, 6232, 6134, 626, 711, 798, 711, 989, 896, 989, 
		1069, 625, 798, 625, 773, 625, 794, 6889, 6898, 6889, 6639, 6888, 6639, 6888, 6486, 1044, 
		900, 1044, 1015, 1044, 1014, 1044, 1250, 7029, 7083, 7029, 6897, 7029, 6898, 7029, 6887, 899, 
		827, 899, 942, 900, 942, 900, 1013, 6808, 6886, 6808, 6485, 6808, 6484, 6429, 6259, 6304, 
		6259, 6149, 1249, 1012, 1249, 1053, 1248, 1053, 1248, 1264, 1436, 1360, 1436, 1488, 6917, 6885, 
		6917, 6808, 1015, 942, 1024, 942, 1075, 995, 1090, 995, 1048, 1011, 1024, 1011, 1053, 6251, 
		6287, 6251, 6476, 811, 909, 897, 909, 988, 6483, 6639, 6483, 6472, 6483, 6166, 6258, 6111, 
		6258, 6015, 1142, 1044, 1142, 1247, 1339, 1435, 1410, 1435, 1533, 6737, 6793, 6737, 6761, 6734, 
		6760, 6734, 6701, 928, 950, 928, 795, 927, 792, 927, 774, 6791, 6974, 6791, 6916, 6793, 
		6916, 6793, 6759, 1025, 1076, 1025, 948, 1025, 950, 1025, 926, 601, 577, 601, 625, 6777, 
		6736, 6777, 6700, 7029, 7185, 7029, 7082, 995, 942, 995, 826, 995, 860, 995, 1047, 6108, 
		6394, 6108, 6066, 6108, 6003, 6083, 5911, 5860, 5911, 5818, 6065, 6394, 6065, 6286, 1007, 1040, 
		1007, 908, 6305, 6240, 6305, 6317, 1127, 1215, 1361, 1215, 1487, 1337, 1487, 1594, 6240, 6305, 
		6240, 6148, 6107, 6148, 6059, 6240, 6133, 6240, 6233, 6240, 6319, 990, 1068, 990, 1215, 990, 
		1129, 6107, 6044, 6107, 6132, 6131, 6240, 6131, 6107, 1067, 1166, 1067, 1337, 1337, 1215, 1337, 
		1066, 6064, 6085, 6064, 6001, 6002, 6001, 5898, 1078, 988, 1078, 1039, 1078, 1093, 1078, 1205, 
		6287, 6251, 6287, 6085, 6285, 6085, 6285, 6063, 988, 907, 988, 1038, 6084, 6130, 6084, 6043, 
		6084, 6042, 6084, 6000, 1165, 1065, 1165, 987, 1164, 987, 1164, 1077, 6250, 6129, 6250, 6084, 
		1064, 896, 1064, 987, 1409, 1533, 1409, 1563, 6014, 5859, 6014, 5940, 1491, 1408, 1491, 1562, 
		1347, 1175, 1491, 1240, 1408, 1240, 1338, 1176, 1141, 1007, 1045, 1007, 898, 1007, 813, 1007, 
		906, 1007, 1176, 1037, 1176, 1092, 1240, 1092, 1175, 5951, 5997, 5951, 5903, 5950, 5902, 5950, 
		5851, 1546, 1470, 1286, 1470, 1163, 1470, 1337, 1470, 1593, 1545, 1285, 1545, 1395, 5997, 5951, 
		5997, 6041, 5997, 6107, 5997, 6058, 5997, 6057, 5997, 5969, 5997, 5901, 1633, 1592, 1633, 1470, 
		1633, 1544, 5897, 5951, 5897, 5850, 5896, 5849, 5896, 5807, 1394, 1286, 1394, 1204, 1393, 1203, 
		1393, 1382, 6000, 6040, 6000, 5949, 6000, 5895, 1284, 1162, 1284, 1077, 1284, 1202, 5910, 5894, 
		5910, 5807, 5910, 5817, 1382, 1201, 1382, 1174, 1382, 1346, 6002, 5893, 6002, 5910, 1200, 1093, 
		1200, 1174, 6056, 6048, 6056, 5944, 6055, 5943, 6055, 5968, 1669, 1625, 1669, 1591, 1668, 1590, 
		1668, 1632, 6149, 6257, 6149, 6047, 6149, 6048, 6149, 6054, 1624, 1434, 1624, 1488, 1625, 1488, 
		1625, 1589, 6046, 6015, 6046, 5940, 5942, 5940, 5838, 5940, 5858, 1561, 1533, 1561, 1623, 1561, 
		1667, 1561, 1515, 1561, 1490, 6256, 6013, 6256, 6045, 1533, 1433, 1533, 1622, 5816, 5837, 5816, 
		5857, 1490, 1514, 1490, 1345, 5844, 5836, 5844, 5816, 5843, 5816, 5843, 5806, 1345, 1513, 1345, 
		1571, 1345, 1570, 1345, 1381, 5942, 5837, 5942, 5842, 1514, 1667, 1514, 1569, 5900, 5841, 5900, 
		5805, 5900, 5848, 1380, 1568, 1380, 1543, 1380, 1392, 5969, 5941, 5969, 5840, 5967, 5839, 5967, 
		5899, 1567, 1666, 1567, 1633, 1566, 1631, 1566, 1542, 6462, 6382, 6462, 6246, 6462, 6355, 1973, 
		2033, 1973, 2001, 1973, 1955, 6354, 6245, 6354, 6195, 6354, 6312, 1906, 1972, 1906, 1954, 1906, 
		1880, 6381, 6327, 6381, 6182, 6381, 6181, 6381, 6244, 1946, 1981, 1946, 2032, 1946, 1971, 6243, 
		6180, 6243, 6161, 6242, 6160, 6242, 6194, 1901, 1945, 1901, 1970, 1900, 1969, 1900, 1905, 6705, 
		6543, 6705, 6437, 6704, 6437, 6704, 6517, 1957, 1917, 1957, 1912, 1957, 1911, 1957, 2008, 6516, 
		6437, 6516, 6327, 6515, 6327, 6515, 6380, 1981, 1957, 1981, 2007, 1981, 2006, 1981, 2031, 6677, 
		6703, 6677, 6514, 6676, 6513, 6676, 6461, 2005, 1910, 2005, 1924, 2004, 1923, 2004, 2000, 6460, 
		6512, 6460, 6379, 2030, 2003, 2030, 1999, 6393, 6326, 6262, 6193, 6262, 6159, 1782, 1748, 1782, 
		1805, 1904, 1805, 1899, 6325, 6528, 6325, 6312, 1880, 1759, 1880, 1781, 6324, 6311, 6324, 6192, 
		1879, 1780, 1879, 1903, 6618, 6675, 6618, 6459, 6618, 6494, 6618, 6527, 6618, 6598, 1998, 1922, 
		1998, 1852, 1918, 1852, 1758, 1852, 1687, 6494, 6458, 6494, 6353, 1997, 1918, 1997, 1953, 6526, 
		6494, 6310, 6494, 6352, 1918, 1757, 1918, 1878, 1918, 1952, 6179, 6261, 6179, 6158, 1898, 1804, 
		1944, 1843, 1916, 1843, 1888, 1843, 1801, 1747, 1843, 1747, 1804, 6542, 6179, 6542, 6436, 1944, 
		1916, 1944, 1980, 6435, 6178, 6435, 6327, 1915, 1957, 1915, 1979, 6681, 6597, 6681, 6500, 6668, 
		6597, 6668, 6681, 6668, 6796, 1686, 1509, 1686, 1629, 1612, 1509, 1612, 1686, 6500, 6596, 6500, 
		6525, 6499, 6524, 6499, 6323, 1756, 1685, 1756, 1629, 1755, 1628, 1755, 1779, 6654, 6680, 6654, 
		6498, 6653, 6497, 6653, 6443, 1627, 1508, 1552, 1508, 1445, 1626, 1551, 1626, 1706, 6442, 6497, 
		6442, 6322, 6442, 6393, 1778, 1626, 1778, 1705, 1778, 1748, 6702, 6677, 6702, 6807, 6860, 6953, 
		6860, 7094, 1837, 1924, 1837, 1909, 1837, 1829, 1769, 1829, 1689, 6543, 6704, 6590, 6704, 6859, 
		1911, 1917, 1911, 1887, 1911, 1828, 6590, 6858, 6590, 6788, 1827, 1887, 1827, 1788, 6618, 6595, 
		6618, 6731, 6674, 6731, 6806, 1684, 1852, 1764, 1921, 1764, 1836, 6730, 6598, 6730, 6667, 1611, 
		1687, 1611, 1763, 6475, 6589, 6475, 6511, 6542, 6589, 6542, 6475, 6179, 6475, 6261, 6475, 6392, 
		6510, 6392, 6441, 6509, 6589, 6509, 6787, 6509, 6724, 1787, 1888, 1787, 1800, 1787, 1674, 1843, 
		1747, 1799, 1747, 1704, 6441, 6508, 6441, 6723, 6440, 6722, 6440, 6652, 1673, 1798, 1673, 1704, 
		1672, 1703, 1672, 1550, 7320, 7241, 7320, 7221, 1442, 1555, 1442, 1565, 7051, 7159, 7051, 7126, 
		1230, 1275, 1230, 1279, 7089, 7200, 7089, 7150, 7088, 7150, 7088, 7047, 1640, 1660, 1588, 1660, 
		1520, 1640, 1587, 1640, 1560, 7038, 7087, 7038, 7046, 7038, 7005, 1559, 1586, 1559, 1429, 1559, 
		1390, 1509, 1612, 1509, 1524, 6680, 6654, 6680, 6841, 6729, 6667, 6729, 6795, 6868, 6950, 6868, 
		7020, 1523, 1611, 1523, 1762, 1691, 1835, 1691, 1768, 1578, 1768, 1688, 6729, 6868, 6805, 6868, 
		6952, 7019, 6952, 7093, 7149, 7136, 7149, 7094, 1652, 1639, 1652, 1689, 7094, 7135, 7094, 6857, 
		1826, 1651, 1826, 1689, 7221, 7240, 7221, 7123, 7221, 7136, 7221, 7149, 7221, 7199, 7321, 7199, 
		7247, 1539, 1441, 1539, 1565, 1652, 1565, 1639, 1565, 1659, 1556, 1659, 1617, 7136, 7122, 7136, 
		6786, 7134, 6786, 7134, 6859, 1786, 1538, 1786, 1652, 1786, 1650, 1786, 1828, 6796, 6679, 6796, 
		6956, 6796, 6949, 1327, 1507, 1327, 1524, 1327, 1427, 6949, 6955, 6949, 7050, 6949, 7051, 7004, 
		7125, 7037, 7125, 7212, 1274, 1326, 1274, 1427, 1275, 1427, 1275, 1389, 1278, 1428, 1278, 1187, 
		6678, 6840, 6678, 7011, 6680, 7010, 6680, 6956, 1317, 1444, 1317, 1506, 1316, 1508, 1316, 1327, 
		6954, 7009, 6954, 7158, 6954, 7049, 1229, 1315, 1229, 1325, 1229, 1273, 6927, 6787, 6927, 7121, 
		6927, 7062, 1537, 1787, 1537, 1530, 1537, 1400, 7061, 7120, 7061, 7239, 7061, 7227, 1440, 1536, 
		1440, 1399, 1440, 1302, 6840, 7060, 6840, 7008, 6927, 7060, 6927, 6840, 6927, 6721, 1398, 1444, 
		1398, 1314, 1530, 1444, 1530, 1398, 7007, 7059, 7007, 7226, 7006, 7226, 7006, 7157, 1301, 1397, 
		1301, 1313, 1301, 1312, 1301, 1228, 1523, 1691, 1426, 1691, 1577, 7018, 6950, 7018, 7005, 7018, 
		7045, 1390, 1426, 1390, 1576, 1390, 1558, 7093, 7017, 7093, 7044, 7093, 7150, 1557, 1575, 1557, 
		1688, 1557, 1640, 7126, 7156, 7126, 7260, 1194, 1227, 1194, 1279, 7346, 7259, 7346, 7155, 7345, 
		7154, 7345, 7225, 1226, 1193, 1226, 1271, 1225, 1270, 1225, 1300, 7238, 7344, 7238, 7224, 1299, 
		1269, 1439, 1269, 1385, 6341, 6452, 6341, 6471, 6341, 6470, 6341, 6362, 125, 65, 125, 199, 
		124, 199, 124, 262, 6451, 6341, 6451, 6321, 136, 199, 136, 64, 6363, 6566, 6340, 6431, 
		6320, 6406, 6301, 6367, 6301, 6279, 491, 263, 491, 198, 361, 135, 276, 115, 246, 115, 
		240, 6660, 6848, 6814, 6848, 6874, 731, 516, 731, 634, 731, 719, 6871, 6969, 6871, 6883, 
		6871, 6847, 986, 800, 817, 800, 730, 7095, 7057, 7095, 7013, 7177, 7108, 7328, 7108, 7330, 
		7128, 7341, 7128, 7109, 6905, 6890, 6574, 6890, 6571, 6890, 6561, 6890, 6783, 7109, 7128, 7108, 
		6905, 7013, 1242, 1063, 1119, 7095, 7177, 7193, 7278, 7193, 7246, 7328, 7278, 7177, 6657, 6803, 
		6657, 6753, 165, 279, 165, 112, 6531, 6588, 6531, 6657, 279, 370, 279, 336, 6530, 6552, 
		6530, 6587, 369, 422, 369, 335, 6699, 6656, 6699, 6586, 6698, 6586, 6698, 6614, 368, 278, 
		368, 260, 368, 259, 368, 411, 6551, 6613, 6551, 6586, 368, 410, 368, 421, 6813, 6873, 
		6813, 6971, 6812, 6971, 6812, 6964, 598, 718, 598, 633, 598, 632, 598, 561, 6963, 6971, 
		6963, 7072, 6962, 7072, 7054, 7072, 7175, 522, 598, 522, 560, 522, 559, 522, 394, 6882, 
		6872, 6882, 6846, 729, 717, 729, 816, 6941, 6970, 6941, 6872, 6940, 6872, 6940, 6881, 717, 
		597, 717, 674, 717, 673, 717, 815, 7073, 7117, 7073, 7208, 7073, 7207, 7073, 7197, 1104, 
		1177, 1104, 1090, 1103, 1090, 1103, 1046, 7196, 7206, 7196, 7265, 7196, 7253, 7196, 7184, 1034, 
		1102, 1034, 1048, 889, 1048, 859, 7144, 7211, 7144, 7205, 7144, 7204, 7144, 7117, 1101, 1186, 
		1101, 1335, 1100, 1335, 1100, 1177, 6300, 6385, 6300, 6424, 6300, 6423, 6321, 6423, 6450, 59, 
		55, 114, 55, 82, 58, 114, 58, 136, 58, 63, 6895, 7003, 6895, 7070, 6975, 7146, 
		6965, 7172, 7012, 7215, 7113, 7234, 7147, 7035, 6966, 6716, 6717, 6716, 6558, 6716, 6413, 6728, 
		6413, 6364, 224, 228, 224, 170, 224, 152, 247, 101, 153, 60, 134, 74, 149, 74, 
		123, 7002, 7053, 7002, 7174, 7001, 7174, 7070, 7216, 7146, 7261, 7172, 7261, 7215, 7277, 7348, 
		7357, 7377, 7407, 7377, 7411, 7390, 7422, 7389, 7419, 7393, 7397, 7393, 7404, 7393, 7310, 461, 
		393, 461, 227, 461, 229, 461, 224, 448, 247, 306, 153, 6939, 7116, 6939, 7071, 6938, 
		7071, 6938, 6970, 521, 593, 521, 672, 521, 671, 521, 597, 6697, 6894, 6697, 6802, 6696, 
		6802, 6696, 6656, 164, 169, 164, 258, 164, 257, 164, 278, 7307, 7264, 7307, 7203, 7307, 
		7202, 7307, 7211, 1099, 1033, 1099, 1117, 1098, 1117, 1098, 1186, 7306, 7382, 7353, 7382, 7408, 
		1190, 1116, 1190, 978, 1190, 1206, 6752, 6909, 6740, 6965, 6816, 7012, 6915, 7113, 6966, 7147, 
		6751, 6739, 6751, 6648, 48, 107, 48, 111, 47, 110, 47, 51, 6570, 6647, 6570, 6738, 
		6636, 6816, 6689, 6915, 6717, 6966, 46, 50, 46, 29, 37, 62, 37, 74, 37, 60, 
		46, 461, 448, 461, 555, 592, 725, 592, 624, 6975, 6965, 6975, 6908, 6975, 6893, 101, 
		152, 106, 152, 168, 6892, 6907, 6892, 6802, 105, 167, 105, 164, 6750, 6803, 6750, 6909, 
		107, 165, 107, 109, 460, 522, 460, 392, 7115, 7173, 7115, 7071, 593, 521, 593, 459, 
		7252, 7263, 7252, 7352, 977, 1032, 977, 889, 7306, 7351, 7306, 7262, 976, 1116, 976, 1031, 
		6569, 6422, 6569, 6384, 57, 30, 57, 54, 6422, 6569, 6422, 6450, 6570, 6636, 6449, 6689, 
		30, 57, 30, 63, 7387, 7384, 7387, 7373, 1384, 1614, 1384, 1572, 7361, 7408, 7361, 7407, 
		7377, 7390, 7348, 7289, 7234, 7289, 7035, 7030, 6728, 7030, 6670, 7030, 6968, 7290, 6968, 7286, 
		6968, 7026, 7289, 7290, 7030, 7289, 7390, 7289, 7389, 7290, 7389, 7285, 7393, 7285, 7309, 6716, 
		7035, 6728, 6469, 6448, 6469, 6689, 74, 61, 74, 122, 7375, 7418, 7375, 7422, 7374, 7422, 
		7391, 7422, 7402, 7425, 7417, 7406, 7417, 7408, 7414, 7381, 7414, 7385, 7414, 7386, 7417, 7394, 
		7417, 7400, 7402, 1580, 1655, 1580, 1832, 7357, 7277, 7357, 7261, 7334, 7216, 7348, 7234, 7215, 
		7406, 7425, 7411, 7422, 7333, 7360, 7333, 7405, 7407, 7357, 7407, 7334, 895, 726, 1210, 835, 
		1023, 865, 1153, 781, 1173, 834, 1173, 905, 1236, 905, 981, 726, 562, 835, 616, 865, 
		616, 405, 562, 6689, 6717, 6689, 6468, 6469, 6717, 6480, 6717, 6557, 149, 122, 149, 150, 
		149, 139, 1454, 1783, 1454, 1736, 1454, 1676, 1454, 1613, 1411, 1386, 1411, 1189, 1411, 1206, 
		1454, 6203, 6328, 6383, 6328, 6569, 6385, 6300, 6385, 6205, 6568, 6489, 6568, 6650, 28, 53, 
		28, 23, 6751, 6649, 6751, 6632, 52, 110, 52, 93, 6299, 6280, 6299, 6202, 6602, 6659, 
		6602, 6593, 496, 515, 496, 374, 6662, 6811, 6662, 6718, 542, 631, 542, 518, 6991, 7002, 
		6991, 6931, 216, 226, 216, 391, 216, 390, 216, 356, 6845, 6931, 6845, 7001, 6990, 6914, 
		6990, 6961, 355, 389, 355, 558, 558, 490, 558, 358, 6810, 6960, 6810, 6912, 6913, 6719, 
		6913, 6810, 488, 557, 488, 635, 6627, 6843, 6627, 6695, 155, 174, 155, 256, 6601, 6626, 
		6601, 6694, 255, 173, 255, 373, 6880, 6969, 6880, 6862, 6863, 6804, 6863, 6879, 993, 986, 
		993, 814, 6969, 7074, 6969, 6974, 6969, 6861, 1091, 986, 1076, 986, 992, 7251, 7171, 7251, 
		7183, 600, 624, 600, 737, 7195, 7185, 7195, 7127, 7073, 7196, 7073, 7127, 7073, 6973, 6875, 
		7064, 6875, 6937, 623, 601, 623, 666, 623, 669, 623, 670, 7037, 7210, 7037, 7143, 1185, 
		1428, 1185, 1334, 7124, 7258, 7124, 7209, 1192, 1277, 1192, 1184, 7321, 7384, 7321, 7237, 1438, 
		1384, 1438, 1556, 7344, 7238, 7344, 7383, 7192, 7246, 7192, 7200, 7200, 7089, 7200, 7191, 1660, 
		1618, 1660, 1519, 7145, 7190, 7145, 7087, 7145, 7086, 7145, 7038, 1586, 1518, 1586, 1336, 1585, 
		1336, 1585, 1429, 6407, 6669, 6407, 6967, 6645, 7025, 6645, 6789, 728, 568, 728, 852, 728, 
		1008, 935, 1008, 1131, 60, 101, 48, 101, 107, 7332, 7216, 7217, 7174, 7217, 7115, 7233, 
		7115, 7063, 7334, 7217, 7272, 7233, 7272, 7335, 7332, 7358, 7332, 7359, 976, 910, 976, 1206, 
		851, 910, 851, 976, 851, 888, 724, 888, 735, 7358, 7408, 7358, 7361, 7408, 7358, 7351, 
		7335, 7252, 7232, 7252, 7168, 299, 146, 299, 358, 6098, 6145, 6098, 6023, 6098, 5872, 5958, 
		5789, 5919, 5678, 5919, 5638, 5919, 5952, 5919, 6006, 5958, 6150, 6098, 6150, 6368, 234, 413, 
		322, 413, 425, 556, 492, 636, 630, 636, 882, 636, 801, 636, 749, 556, 563, 413, 
		563, 464, 6403, 6518, 6403, 6487, 31, 7, 31, 21, 7105, 6947, 7105, 7032, 576, 602, 
		576, 693, 575, 694, 575, 677, 7107, 7031, 7107, 7083, 7107, 7185, 827, 676, 827, 695, 
		827, 692, 827, 861, 6839, 6651, 6839, 6723, 1673, 1549, 1673, 1443, 1444, 1530, 1444, 1671, 
		6785, 6927, 6785, 6720, 1670, 1530, 1670, 1785, 6412, 6364, 6412, 6067, 6413, 6067, 6413, 6139, 
		270, 342, 270, 206, 270, 207, 270, 131, 6411, 6137, 6411, 6237, 6410, 6236, 6410, 6333, 
		188, 129, 188, 205, 187, 204, 187, 274, 6314, 6332, 6314, 6235, 6314, 6238, 6314, 6253, 
		186, 273, 186, 587, 189, 587, 189, 455, 6252, 6269, 6252, 6316, 6268, 6291, 6268, 6313, 
		891, 687, 891, 586, 686, 454, 686, 589, 6173, 6292, 6173, 6267, 685, 892, 685, 944, 
		6172, 6025, 6172, 6184, 767, 943, 767, 787, 6026, 6011, 6026, 6306, 788, 508, 788, 766, 
		6012, 6068, 6012, 6307, 6749, 6631, 6655, 6631, 6529, 237, 108, 237, 277, 237, 334, 6658, 
		6600, 6658, 6615, 372, 514, 372, 412, 6959, 7052, 6959, 6989, 7000, 6988, 7000, 7053, 6999, 
		6895, 6999, 6842, 154, 170, 154, 225, 6693, 6843, 6693, 6891, 155, 254, 155, 166, 6692, 
		6612, 6692, 6599, 371, 409, 371, 253, 7231, 7066, 7231, 7167, 622, 723, 622, 736, 6938, 
		7065, 6938, 7114, 621, 671, 621, 591, 7279, 7319, 7279, 7247, 1554, 1642, 1554, 1617, 7385, 
		7382, 7385, 7343, 1268, 1190, 1268, 1386, 7305, 7257, 7305, 7342, 7305, 7380, 1267, 1191, 1267, 
		1115, 1267, 1188, 7304, 7210, 7304, 7260, 1185, 1114, 1185, 1194, 7026, 7284, 7026, 7308, 904, 
		727, 904, 936, 727, 904, 727, 834, 532, 781, 447, 565, 458, 384, 458, 321, 447, 
		217, 447, 406, 532, 567, 727, 781, 865, 565, 405, 384, 903, 936, 903, 980, 1236, 
		979, 1236, 1281, 1236, 1693, 1236, 1654, 1173, 1580, 1153, 1234, 1023, 1234, 1210, 1234, 1535, 
		1580, 1846, 1656, 1846, 1692, 1846, 1849, 7282, 7322, 7282, 7043, 7282, 7040, 7282, 7028, 1712, 
		1845, 1712, 1850, 1711, 1850, 1711, 1754, 6790, 6815, 6790, 6850, 6852, 6646, 6852, 6790, 1421, 
		1472, 1421, 1132, 7028, 7039, 7028, 6852, 7028, 6815, 1423, 1710, 1423, 1754, 1423, 1472, 3393, 
		3891, 3997, 3891, 4380, 3891, 4747, 4464, 5175, 5000, 4906, 3841, 3924, 3841, 3619, 4736, 4621, 
		4736, 4954, 4736, 5110, 3924, 4123, 3924, 3988, 3922, 3987, 3922, 3621, 4372, 4623, 4372, 4735, 
		4382, 4623, 4382, 4372, 4382, 4122, 4121, 4372, 4121, 3987, 2367, 2469, 2288, 2486, 2270, 2468, 
		2250, 2462, 2237, 2462, 2455, 2462, 2479, 2462, 2501, 2403, 2469, 2403, 2366, 3613, 3653, 3613, 
		3336, 3336, 3341, 3336, 3611, 3336, 3653, 3344, 4325, 4949, 4739, 4949, 5226, 5338, 5226, 5074, 
		5226, 4741, 4565, 5095, 4565, 5221, 4565, 4589, 4007, 4589, 4051, 4073, 3653, 3642, 3344, 3642, 
		3342, 3672, 3364, 3703, 3364, 3469, 3364, 3346, 3364, 3180, 1690, 1708, 1305, 1581, 2303, 2561, 
		2303, 2916, 4987, 4740, 4987, 5074, 4987, 5203, 3361, 2714, 2917, 2714, 2301, 3361, 3109, 3361, 
		2715, 4096, 4325, 4547, 4741, 4547, 4988, 3838, 3594, 3838, 3110, 3838, 3361, 3652, 3361, 3159, 
		3361, 2918, 4096, 3595, 4096, 3838, 4325, 4458, 4949, 5037, 5338, 5037, 5442, 5110, 5173, 5110, 
		4956, 1977, 1708, 2059, 1690, 1894, 1690, 1241, 1690, 1149, 2367, 2162, 2372, 2162, 2362, 1951, 
		2062, 1951, 1950, 1951, 1796, 1581, 1825, 1708, 2009, 1977, 2009, 2196, 2256, 2527, 2459, 2767, 
		4006, 3613, 4006, 3698, 4007, 4051, 4007, 3612, 2373, 2403, 2373, 2367, 2274, 2403, 2274, 2374, 
		3341, 3696, 3341, 3613, 2744, 2760, 2915, 2760, 2978, 2760, 3027, 2763, 3045, 3340, 3341, 3006, 
		3341, 3035, 3336, 3045, 3344, 3027, 3342, 2978, 3364, 2978, 3181, 2915, 2872, 2915, 2711, 2744, 
		2591, 2760, 2588, 2760, 2578, 2764, 2577, 3341, 3340, 3341, 3697, 2638, 2971, 2638, 2695, 4544, 
		4931, 4544, 5094, 4140, 4097, 4140, 4548, 4573, 4989, 4872, 5203, 4872, 5018, 4636, 5018, 4843, 
		4097, 4140, 4097, 3480, 3111, 3480, 2877, 3480, 3358, 4140, 3963, 4573, 4409, 4872, 4409, 4637, 
		3112, 3596, 3112, 3480, 3480, 3597, 3480, 4098, 2716, 3113, 2716, 2877, 2302, 2717, 2557, 2877, 
		2840, 3358, 3245, 3963, 3871, 4409, 4339, 4638, 4577, 5095, 5067, 5095, 5303, 5222, 5303, 5582, 
		5369, 5796, 5586, 5928, 5723, 5993, 5679, 5993, 5809, 6020, 5933, 6223, 6070, 6329, 6608, 6904, 
		7100, 7085, 7160, 6958, 7160, 6838, 7048, 6666, 6715, 6457, 6260, 6401, 6171, 6428, 6283, 6428, 
		6434, 5095, 4932, 5095, 5068, 2176, 2086, 2176, 2143, 2273, 2206, 7085, 6771, 6904, 4694, 4452, 
		4631, 4468, 4633, 2143, 2085, 2143, 2054, 2143, 2114, 2206, 2114, 2163, 4832, 4631, 4753, 4633, 
		4753, 4786, 4833, 4695, 4833, 4631, 2339, 2331, 2339, 2192, 2340, 2565, 2340, 2332, 2957, 3665, 
		2957, 3389, 2958, 3185, 2958, 3666, 4005, 4543, 4565, 4543, 5096, 4006, 3876, 4006, 4544, 2115, 
		2125, 2115, 2167, 2115, 2055, 2115, 2126, 4657, 4745, 4657, 4834, 4754, 4658, 4754, 4835, 2167, 
		2126, 2167, 2234, 2767, 3208, 2767, 2749, 2767, 2443, 2459, 2241, 2235, 2241, 2167, 4577, 4659, 
		4577, 4521, 4339, 4312, 3871, 3856, 3871, 3208, 3245, 2767, 2840, 2527, 2557, 2196, 2303, 1977, 
		2561, 2059, 2183, 1894, 2081, 1817, 1936, 1817, 1607, 1485, 1401, 1246, 1152, 1018, 680, 404, 
		424, 403, 833, 403, 894, 607, 1062, 1216, 1824, 1462, 1963, 1636, 1963, 2046, 1963, 2174, 
		2097, 2254, 2035, 2194, 1931, 2160, 1908, 2169, 2195, 2666, 2926, 3470, 3674, 4189, 3960, 4572, 
		4057, 4742, 4088, 4782, 4848, 5265, 5283, 5767, 5280, 5750, 5245, 5694, 5105, 5439, 5195, 5808, 
		5572, 5933, 5641, 5809, 5442, 5679, 5338, 5723, 5226, 5586, 5074, 5369, 5203, 5303, 5018, 5303, 
		5069, 4578, 4746, 4578, 4660, 2310, 2086, 2310, 2177, 4695, 4199, 4695, 4206, 4695, 4452, 2616, 
		2249, 2310, 2249, 2087, 2249, 2136, 2253, 2136, 2062, 2616, 3081, 2616, 2558, 2249, 2581, 2253, 
		2639, 2253, 2362, 2253, 2063, 3722, 3704, 3081, 3028, 2558, 2984, 2581, 2946, 2581, 2640, 3704, 
		3722, 3704, 4199, 4199, 3722, 4199, 4207, 2502, 2546, 2352, 2546, 2416, 2626, 2545, 2839, 2809, 
		2839, 3120, 2839, 3170, 2341, 2178, 2341, 2263, 6086, 6188, 6856, 6188, 6278, 6188, 6976, 6856, 
		7166, 2342, 2193, 2342, 2178, 3330, 3666, 3330, 3650, 3330, 3390, 3330, 3667, 2362, 2432, 2362, 
		2375, 3698, 3877, 3698, 4007, 3699, 3692, 3699, 3877, 2263, 2433, 2263, 2343, 2263, 2376, 2263, 
		2434, 3690, 3650, 3690, 3667, 2291, 2179, 2291, 2193, 2291, 2333, 3390, 3331, 3390, 2904, 3390, 
		2959, 2334, 2569, 2334, 2292, 2334, 2627, 2334, 2570, 2571, 2960, 2571, 2905, 2572, 2627, 2572, 
		2960, 2376, 2263, 2376, 2274, 2274, 2263, 2274, 2179, 3700, 3340, 3700, 3650, 3700, 3691, 3650, 
		3340, 3650, 3331, 2435, 2362, 2435, 2640, 2435, 2662, 3426, 3692, 3426, 3272, 3427, 3877, 3427, 
		3693, 2947, 2924, 2947, 2663, 2947, 2641, 3275, 2948, 3275, 3428, 3273, 2922, 3273, 2949, 2565, 
		2436, 2565, 2664, 2565, 2923, 2565, 2823, 2565, 2628, 2565, 2335, 2565, 2344, 2565, 2437, 4848, 
		5283, 4848, 5280, 4859, 5245, 4847, 5105, 4674, 4464, 4292, 3891, 3402, 3393, 3078, 3393, 3278, 
		3997, 3278, 3840, 6329, 6904, 6223, 6771, 6020, 6771, 6208, 6771, 6748, 6070, 5808, 6608, 5808, 
		6070, 5933, 6140, 5939, 5889, 4572, 4189, 4669, 3470, 3960, 3131, 3674, 6309, 6104, 6948, 4425, 
		3951, 4425, 3125, 3622, 2534, 2860, 2509, 2817, 2508, 2817, 2795, 2817, 3186, 3324, 3972, 3324, 
		4650, 4120, 5315, 4964, 5497, 4964, 4425, 4964, 3622, 4120, 2860, 3324, 2817, 6715, 7048, 6444, 
		7048, 6994, 7148, 6995, 6948, 6830, 6104, 5948, 5432, 5123, 5432, 4669, 5072, 4572, 5072, 4742, 
		5191, 4782, 5191, 5265, 5778, 5767, 6309, 6278, 6948, 6976, 7148, 7166, 7048, 7166, 7160, 7166, 
		7100, 6856, 6608, 6086, 5808, 6086, 5439, 6086, 5694, 6188, 5750, 6278, 5767, 1084, 424, 1084, 
		829, 5297, 5890, 5297, 4662, 1430, 833, 1430, 1396, 1430, 1892, 2037, 2499, 2037, 2999, 2529, 
		3972, 4666, 3972, 5247, 4650, 5889, 5315, 5939, 5497, 5939, 6474, 6140, 6706, 5889, 6495, 5247, 
		5890, 5247, 4663, 2097, 2035, 1694, 2035, 1516, 1931, 1396, 1908, 1892, 2195, 2499, 2926, 2499, 
		3674, 2999, 3131, 2529, 2391, 2037, 1793, 1430, 1084, 1430, 830, 1516, 831, 1516, 894, 1694, 
		1062, 1694, 1824, 2097, 1963, 1516, 1396, 1516, 832, 3651, 3786, 3651, 3066, 3024, 2809, 3120, 
		4664, 3786, 4446, 3651, 4324, 3651, 3518, 3024, 3465, 3120, 3529, 3171, 3589, 3315, 3659, 3418, 
		3713, 3418, 3742, 3418, 3537, 3418, 3443, 2254, 2545, 2194, 4665, 3972, 3786, 3186, 3066, 2795, 
		2809, 2795, 2545, 2508, 2194, 2508, 2160, 2509, 2169, 2534, 2666, 3125, 3470, 3951, 4669, 4425, 
		5123, 5497, 5948, 6474, 6830, 6706, 6995, 6495, 6994, 5890, 6444, 5297, 6444, 5985, 6715, 6260, 
		3621, 3383, 3621, 3278, 3621, 3841, 3652, 3159, 3383, 2909, 3278, 2859, 3078, 2377, 2670, 2377, 
		2313, 2377, 1936, 2377, 2081, 2463, 2183, 2741, 2561, 2741, 2917, 2741, 3159, 2741, 2909, 2463, 
		2859, 2377, 4050, 4458, 4050, 3838, 4050, 3652, 3835, 3383, 3835, 3620, 3621, 3989, 3835, 4237, 
		4050, 4595, 4458, 4595, 5037, 4595, 5110, 4595, 4737, 4237, 4373, 4237, 4373, 3990, 4237, 4373, 
		4237, 4738, 5928, 5993, 6219, 5993, 6209, 6020, 5796, 5928, 6062, 6219, 6283, 4543, 4526, 4780, 
		4526, 4693, 5068, 4841, 5068, 5018, 5065, 4865, 5065, 4842, 1967, 1949, 1967, 1796, 1967, 1825, 
		2058, 2009, 2058, 2256, 4781, 4865, 4781, 4930, 4781, 4541, 4930, 4865, 4930, 5066, 4527, 3876, 
		4130, 3426, 3614, 2945, 3614, 2984, 3704, 3028, 4528, 4542, 4528, 3875, 1690, 1303, 1690, 1145, 
		5232, 5582, 5708, 5796, 5908, 6062, 6099, 6283, 6099, 6171, 6053, 6260, 6008, 5985, 5680, 5297, 
		5122, 4666, 5122, 4446, 4999, 4324, 4202, 3518, 4111, 3465, 4075, 3529, 4072, 3589, 4068, 3659, 
		4087, 3713, 4112, 3742, 3812, 3742, 3626, 3537, 3571, 3537, 3444, 5233, 5220, 5233, 5582, 1241, 
		1146, 1241, 1138, 5163, 5234, 5163, 5708, 1304, 1683, 1304, 1147, 2041, 2288, 2270, 1305, 1733, 
		1683, 2041, 2021, 2270, 2250, 4574, 5221, 4574, 5235, 4589, 4574, 4073, 4046, 3642, 4046, 3672, 
		4002, 3703, 3725, 3703, 3468, 4574, 4589, 4574, 5222, 5715, 5561, 5715, 5625, 1148, 1641, 1139, 
		1641, 1678, 2019, 1678, 2023, 1721, 2039, 1740, 2015, 1730, 2015, 2011, 2015, 2226, 3694, 3185, 
		3694, 3274, 3695, 3668, 3695, 3185, 2823, 2924, 2823, 3185, 2628, 3185, 2961, 3185, 2924, 3185, 
		3275, 2274, 2293, 2274, 2404, 2274, 2504, 2403, 2548, 2469, 2577, 2486, 2578, 2468, 2588, 2462, 
		2588, 2503, 2591, 2546, 2711, 2626, 2872, 2839, 2872, 3171, 2872, 3182, 2274, 2180, 2274, 2294, 
		2906, 3340, 2971, 3006, 2695, 3006, 2727, 3035, 2754, 3045, 2754, 2765, 2907, 3332, 2907, 3340, 
		2573, 2404, 2573, 2295, 2574, 2637, 2404, 2696, 2504, 2728, 2548, 2755, 2577, 2755, 2766, 2971, 
		2575, 2971, 2908, 2971, 2638, 2971, 2576, 5752, 5539, 5752, 5685, 2096, 2162, 2096, 2365, 2096, 
		2288, 2041, 2096, 2041, 2096, 1733, 2162, 1854, 1951, 1854, 1581, 1854, 1304, 1733, 5072, 5432, 
		5614, 6104, 5614, 6309, 5614, 5778, 5614, 5191, 5072, 3811, 3487, 3811, 3738, 4155, 4162, 4455, 
		4497, 4761, 4853, 4938, 5019, 5020, 5103, 4957, 5011, 4703, 4768, 4396, 4401, 4059, 4029, 3813, 
		3750, 3675, 3557, 3569, 3435, 3625, 3487, 3625, 3811, 2475, 2106, 2145, 1876, 1873, 1540, 1505, 
		1287, 1233, 1218, 1144, 1168, 1113, 1259, 1224, 1474, 1483, 1775, 1816, 2024, 2067, 2217, 2356, 
		2418, 2559, 2488, 2635, 2337, 2475, 2337, 2106, 1722, 1322, 1771, 1387, 1771, 1797, 1771, 2070, 
		2060, 2348, 2060, 2352, 2060, 2046, 2060, 1722, 1771, 2015, 2208, 2223, 2208, 2423, 2208, 2221, 
		2208, 2039, 2015, 5443, 5482, 5443, 5394, 2094, 2275, 2094, 2230, 2094, 2110, 2094, 1996, 2094, 
		1925, 2094, 1959, 2094, 2095, 2275, 4459, 4224, 4400, 4224, 4183, 4224, 3993, 4224, 4236, 4224, 
		4383, 4459, 5219, 5237, 5343, 5219, 5121, 5237, 5121, 5120, 5016, 5326, 5361, 5326, 5446, 5427, 
		5526, 5427, 5543, 5427, 5415, 5427, 5327, 5326, 5217, 5017, 5059, 5085, 5242, 5075, 5084, 5251, 
		4294, 4447, 4294, 4443, 4294, 4074, 4221, 4045, 4306, 4081, 4279, 4110, 4309, 4153, 4275, 4184, 
		4321, 4184, 4182, 3977, 3918, 3791, 3751, 3663, 3527, 3603, 3472, 3654, 3505, 3662, 3548, 3689, 
		3543, 3739, 3752, 3884, 3866, 4025, 3777, 3900, 3799, 3931, 3845, 3931, 3994, 4099, 4174, 4326, 
		4310, 4453, 4352, 4516, 4576, 4758, 4798, 4970, 4940, 4970, 5104, 4970, 5108, 4973, 5073, 4973, 
		4950, 4760, 4639, 4498, 4353, 4326, 4353, 4099, 4127, 3931, 4127, 3900, 4148, 4025, 4148, 4225, 
		4148, 4393, 4336, 4568, 4353, 4568, 4639, 4866, 4950, 4758, 4973, 4970, 4760, 4973, 4760, 4758, 
		4603, 4516, 4603, 4453, 4498, 4326, 4603, 4498, 4760, 4127, 4336, 4353, 3994, 4174, 4139, 4310, 
		4139, 4352, 4295, 4481, 4437, 4608, 4616, 4608, 4785, 4698, 4940, 4698, 4798, 4698, 4576, 4481, 
		4352, 4608, 4481, 4698, 4336, 4127, 4148, 3845, 3705, 3799, 3649, 3777, 3586, 3752, 3586, 3543, 
		3401, 3459, 3371, 3365, 3259, 3297, 3244, 3329, 3261, 3347, 3254, 3360, 3254, 3288, 3232, 3258, 
		3229, 3293, 3229, 3307, 3281, 3391, 3333, 3401, 3333, 3371, 3333, 3259, 3248, 3210, 3229, 3210, 
		3232, 3210, 3254, 3210, 3261, 3210, 3244, 3259, 3649, 3705, 3649, 3483, 3491, 3391, 3491, 3401, 
		3491, 3586, 3649, 3752, 3866, 3777, 3391, 3483, 3307, 3354, 3258, 3293, 3308, 3258, 3354, 3308, 
		3288, 3258, 3281, 3229, 3281, 3248, 3333, 3459, 3548, 3543, 3505, 3548, 3505, 3459, 3505, 3365, 
		3472, 3375, 3527, 3460, 3610, 3503, 3562, 3419, 3531, 3463, 3623, 3512, 3623, 3719, 3623, 3740, 
		3623, 3706, 3531, 3706, 3562, 3707, 3610, 3795, 3751, 3959, 3918, 3959, 4182, 3959, 4251, 3959, 
		4179, 3959, 3944, 3795, 3826, 3707, 3797, 3706, 3360, 3512, 3360, 3463, 3347, 3419, 3329, 3503, 
		3329, 3460, 3329, 3375, 3297, 3365, 3527, 3610, 3751, 4184, 4153, 3977, 3956, 3791, 3779, 3663, 
		3779, 3603, 3796, 3654, 3784, 3662, 3843, 3689, 3867, 3739, 3868, 3884, 3868, 3921, 3868, 4074, 
		3867, 4045, 3843, 3904, 3784, 3904, 3796, 3952, 3779, 3952, 3956, 4110, 4153, 4045, 3904, 4081, 
		3952, 4110, 4279, 4309, 4279, 4429, 4491, 4602, 4491, 4756, 4491, 4697, 4491, 4580, 4364, 4447, 
		4364, 4294, 4364, 4221, 4364, 4306, 4491, 4279, 5261, 5368, 5358, 5447, 5390, 5489, 5476, 5558, 
		5544, 5643, 5544, 5581, 5428, 5466, 5351, 5377, 5351, 5270, 5262, 5124, 5196, 5070, 5155, 5060, 
		5086, 4984, 4871, 4690, 4626, 4448, 4450, 4356, 4250, 4186, 3965, 3982, 3865, 3982, 3844, 4027, 
		3864, 4027, 3926, 4163, 4049, 4286, 4260, 4286, 4463, 4449, 4582, 4358, 4448, 4217, 4356, 4217, 
		4186, 4217, 3982, 4217, 4027, 4358, 4163, 4358, 4286, 4449, 4448, 4690, 4582, 4769, 4463, 4734, 
		4579, 4748, 4617, 4836, 4849, 4992, 5041, 5124, 5148, 5270, 4690, 4984, 4769, 4951, 4734, 4928, 
		4748, 4928, 4836, 4928, 4992, 5070, 5124, 4984, 5060, 4951, 5060, 4928, 5070, 5558, 5598, 5643, 
		5489, 5598, 5558, 5489, 5447, 5598, 5281, 5368, 5281, 5261, 5213, 5102, 5106, 5015, 4899, 4975, 
		4767, 4934, 4583, 4689, 4450, 4689, 4626, 4844, 4854, 4981, 5010, 5063, 5138, 5129, 5261, 5129, 
		5102, 5063, 4934, 4981, 4934, 4844, 4689, 5618, 5640, 5540, 5545, 5465, 5413, 4975, 5102, 4934, 
		5287, 5115, 5200, 5115, 5030, 5001, 4799, 4875, 5102, 4975, 5015, 4799, 4795, 5030, 4569, 4795, 
		4799, 4569, 4601, 4795, 4418, 4601, 4569, 4601, 4418, 4398, 4267, 4222, 4218, 4345, 4478, 4080, 
		3948, 4080, 3885, 3902, 4026, 4250, 3965, 4219, 4250, 4026, 4626, 4854, 4871, 5010, 5086, 5138, 
		5211, 5291, 5357, 5390, 5357, 5476, 5445, 5544, 5445, 5428, 5356, 5351, 5282, 5262, 5282, 5196, 
		5241, 5155, 5241, 5086, 5241, 5211, 5241, 5357, 5356, 5445, 5282, 5241, 5356, 5138, 5261, 5291, 
		5358, 5390, 4389, 4450, 4389, 4250, 4389, 4219, 4389, 4351, 4389, 4454, 4389, 4583, 4450, 5209, 
		5125, 5218, 5257, 5344, 5257, 5422, 5311, 5373, 5289, 5434, 5289, 5341, 5289, 5230, 5289, 5116, 
		5184, 5049, 5184, 5056, 5257, 5125, 5422, 5373, 5464, 5434, 5257, 5184, 5311, 5289, 5305, 5218, 
		5344, 5218, 5305, 5209, 5413, 5353, 5296, 5217, 5139, 5217, 5238, 5326, 5279, 5361, 5318, 5361, 
		5440, 5446, 5559, 5526, 5634, 5543, 5634, 5664, 5677, 5682, 5687, 5675, 5663, 5631, 5517, 5532, 
		5433, 5441, 5343, 5353, 5237, 5296, 5237, 5147, 5120, 5050, 5016, 4959, 5016, 4807, 5016, 5006, 
		5121, 5174, 5219, 5316, 5343, 5378, 5433, 5378, 5517, 5488, 5517, 5601, 5663, 5676, 5687, 5670, 
		5677, 5670, 5634, 5559, 4808, 4596, 4808, 4653, 4935, 4850, 4979, 4883, 4673, 4963, 4587, 4883, 
		4646, 4850, 4645, 4653, 4575, 4653, 4393, 4596, 4568, 4808, 4866, 4808, 4978, 4935, 5075, 4979, 
		5084, 4883, 5084, 4963, 5084, 5127, 5084, 5228, 5251, 5371, 4963, 4673, 4852, 5318, 5279, 5192, 
		4359, 4394, 4359, 4560, 4473, 4797, 4597, 4797, 4823, 5003, 4823, 4980, 4907, 4394, 4412, 4394, 
		4588, 4560, 4860, 4797, 5064, 5003, 5164, 5003, 5130, 4980, 5071, 4907, 5059, 4852, 5017, 4963, 
		5085, 5127, 5242, 5228, 5347, 5371, 5477, 3851, 4047, 3851, 4107, 3851, 3870, 3682, 4107, 4047, 
		4289, 4107, 4289, 4381, 5209, 5305, 5246, 4752, 4616, 4908, 4785, 4994, 4940, 5109, 5104, 5246, 
		5108, 5209, 5073, 5125, 4950, 5056, 4866, 5049, 4978, 5116, 5075, 5230, 5251, 5341, 5371, 5434, 
		5477, 5434, 5560, 5434, 5573, 5464, 5541, 5422, 5510, 5344, 5416, 5305, 5352, 5246, 5275, 5109, 
		4616, 4752, 4586, 4412, 4444, 4412, 4607, 4588, 4784, 4860, 5002, 5064, 5192, 5164, 5279, 5130, 
		5238, 5071, 5139, 5059, 5217, 5242, 5327, 5347, 5415, 5477, 5543, 5560, 5664, 5573, 5642, 5541, 
		5618, 5510, 5540, 5416, 5465, 5352, 5413, 5275, 5296, 5109, 5147, 4994, 5050, 4908, 4959, 4752, 
		4807, 4752, 4593, 4586, 4423, 4616, 4381, 4437, 4289, 4295, 4047, 4139, 3955, 3994, 3837, 3845, 
		3673, 3705, 3542, 3483, 3429, 3307, 3355, 3293, 3403, 3354, 3403, 3498, 3549, 3682, 3712, 3851, 
		3827, 4047, 3827, 3955, 3827, 3837, 3827, 3673, 3712, 3673, 3549, 3542, 3549, 3429, 3403, 3355, 
		4646, 4645, 4646, 4443, 4587, 4447, 4673, 4580, 4852, 4697, 4907, 4756, 4823, 4602, 4597, 4429, 
		4473, 4309, 4359, 4275, 4394, 4321, 4412, 4182, 4444, 4251, 4408, 4179, 4260, 3944, 4049, 3826, 
		3926, 3797, 3864, 3706, 3844, 3740, 3865, 3719, 3683, 3512, 3492, 3360, 3387, 3288, 3384, 3308, 
		3395, 3354, 3484, 3498, 3627, 3682, 3776, 3870, 3906, 4107, 4175, 4381, 4222, 4423, 4398, 4593, 
		4601, 4807, 4795, 5006, 5030, 5174, 5200, 5316, 5287, 5378, 5368, 5488, 5447, 5601, 5598, 5676, 
		5643, 5670, 5581, 5559, 5466, 5440, 5377, 5318, 5270, 5192, 5148, 5002, 5041, 4784, 4849, 4607, 
		4617, 4444, 4617, 4408, 4579, 4428, 4463, 4428, 4260, 4408, 5287, 5368, 5287, 5281, 5287, 5213, 
		5115, 5106, 5001, 4899, 4875, 4635, 4799, 4563, 4569, 4403, 4418, 4240, 4267, 4109, 4222, 3981, 
		4175, 3981, 3906, 3862, 3776, 3702, 3627, 3702, 3484, 3587, 3395, 3500, 3384, 3516, 3387, 3516, 
		3492, 3635, 3683, 3770, 3865, 3770, 3965, 3920, 4026, 4052, 4219, 4218, 4351, 4478, 4454, 4610, 
		4583, 4610, 4767, 4610, 4899, 4610, 4635, 4478, 4563, 4345, 4403, 4262, 4240, 4106, 4109, 3953, 
		3981, 3953, 3862, 3790, 3702, 3790, 3587, 3737, 3500, 3669, 3516, 3669, 3635, 3766, 3770, 3829, 
		3920, 3948, 4052, 3948, 4218, 4080, 4345, 4080, 4262, 4080, 4106, 3902, 3953, 3902, 3790, 3902, 
		3737, 3885, 3669, 3885, 3766, 3948, 3829, 5441, 5353, 5441, 5413, 5532, 5545, 5631, 5640, 5675, 
		5640, 5682, 5618, 5682, 5642, 5664, 2414, 2476, 2589, 2650, 2782, 2753, 2866, 2846, 2942, 3087, 
		3143, 3302, 3306, 3420, 3363, 3482, 3348, 3424, 3335, 3366, 3230, 3225, 3141, 3086, 2970, 2842, 
		2808, 2701, 2595, 2487, 2315, 2276, 2154, 2185, 2099, 2150, 1978, 2103, 1937, 2069, 2027, 2109, 
		2020, 2181, 2051, 2131, 2036, 2118, 2040, 2129, 2014, 2105, 1960, 2043, 1895, 1940, 1853, 1968, 
		1819, 1914, 1777, 1933, 1907, 2034, 2013, 2100, 2052, 2135, 2108, 2197, 2170, 2390, 2349, 2614, 
		2586, 2777, 2798, 2900, 2902, 3074, 2969, 3136, 3046, 3233, 3156, 3356, 3262, 3454, 3392, 3478, 
		3420, 3478, 3482, 3539, 3520, 3565, 3530, 3547, 3504, 3538, 3476, 3462, 3396, 3326, 3289, 3192, 
		3138, 3094, 2963, 2861, 2826, 2667, 2612, 2521, 2401, 2324, 2181, 2324, 2131, 2278, 2118, 2306, 
		2129, 2422, 2242, 2500, 2219, 2382, 2155, 2389, 2116, 2290, 2098, 2244, 2080, 2227, 2034, 2227, 
		2100, 2222, 2135, 2316, 2197, 2316, 2390, 2544, 2583, 2746, 2737, 2919, 2925, 3102, 3146, 3204, 
		3309, 3303, 3458, 3399, 3511, 3425, 3464, 3353, 3322, 3226, 3179, 3089, 3011, 2901, 2769, 2705, 
		2602, 2449, 2290, 2449, 2244, 2431, 2227, 2582, 2450, 2599, 2544, 2731, 2746, 2928, 2919, 3144, 
		3102, 3144, 3204, 3144, 3303, 3235, 3399, 3353, 3425, 3424, 3482, 3424, 3520, 3477, 3530, 3471, 
		3504, 3422, 3476, 3328, 3396, 3328, 3289, 3168, 3138, 3168, 2963, 2967, 2826, 2848, 2750, 2751, 
		2598, 2584, 2417, 2321, 2245, 2161, 2109, 2161, 2069, 2161, 2103, 2321, 2150, 2355, 2185, 2355, 
		2276, 2355, 2487, 2547, 2701, 2729, 2864, 2843, 2979, 2848, 2979, 2967, 3150, 3168, 3263, 3328, 
		3263, 3422, 3255, 3382, 3225, 3382, 3366, 3471, 3366, 3477, 3424, 3422, 3382, 3471, 2842, 2864, 
		2701, 2843, 2848, 2843, 2751, 2729, 2584, 2547, 2321, 2355, 2612, 2750, 2826, 2612, 2598, 2750, 
		2612, 2401, 2598, 2401, 2417, 2401, 2245, 2181, 2109, 2129, 2242, 2105, 2219, 2105, 2155, 2043, 
		2116, 1940, 2098, 1968, 2080, 1914, 2080, 1933, 2034, 2450, 2544, 2450, 2316, 2450, 2222, 2227, 
		2602, 2290, 2602, 2389, 2602, 2382, 2622, 2500, 2682, 2617, 2799, 2592, 2790, 2585, 2710, 2524, 
		2667, 2524, 2521, 2524, 2324, 2524, 2278, 2585, 2278, 2592, 2306, 2592, 2422, 2617, 2500, 2705, 
		2431, 2449, 2431, 2705, 2582, 2806, 2756, 2937, 2928, 3132, 3144, 3132, 3235, 3226, 3353, 2582, 
		2756, 2599, 2756, 2731, 2928, 2390, 2583, 2614, 2737, 2777, 2925, 2900, 3146, 3074, 3195, 3136, 
		3195, 3233, 3362, 3423, 3448, 3515, 3517, 3550, 3561, 3565, 3566, 3547, 3566, 3538, 3519, 3462, 
		3404, 3326, 3253, 3209, 3083, 3082, 2920, 2892, 2790, 2892, 2710, 2863, 2667, 2863, 2861, 2863, 
		3094, 3101, 3192, 3209, 3326, 3209, 3082, 3101, 2892, 2863, 2920, 2799, 2790, 2705, 2901, 2806, 
		2901, 2937, 3089, 3132, 3226, 3309, 3195, 3146, 3362, 3195, 3362, 3309, 3448, 3458, 3517, 3511, 
		3561, 3519, 3566, 3423, 3356, 3233, 3454, 3356, 3454, 3423, 3454, 3515, 3536, 3550, 3536, 3565, 
		3536, 3539, 3536, 3478, 3454, 3519, 3511, 3519, 3464, 3404, 3322, 3253, 3179, 3083, 3011, 2828, 
		2769, 2828, 2602, 2828, 2622, 2828, 2682, 2871, 2799, 2871, 2920, 2871, 3083, 2828, 3420, 3302, 
		3392, 3240, 3262, 3096, 3156, 2962, 3046, 2878, 2969, 2853, 2902, 2752, 2798, 2533, 2586, 2289, 
		2349, 2138, 2170, 2071, 2108, 2022, 2052, 1939, 2013, 1939, 1907, 1838, 1746, 1715, 1531, 1453, 
		1294, 1213, 1167, 1081, 1055, 1000, 1026, 985, 1027, 991, 1036, 1049, 1097, 1120, 1222, 1245, 
		1348, 1469, 1517, 1720, 1739, 1869, 1937, 1869, 1978, 1956, 2099, 2068, 2154, 2128, 2315, 2220, 
		2528, 2448, 2636, 2484, 2694, 2514, 2644, 2665, 2849, 2782, 2849, 2866, 3026, 2942, 3147, 3143, 
		3147, 3306, 3196, 3363, 3196, 3348, 3129, 3202, 2968, 3100, 2876, 2970, 2876, 2808, 2726, 2595, 
		2528, 2315, 3147, 3196, 3026, 2954, 2849, 2819, 2644, 2819, 2694, 2903, 2810, 2968, 2810, 2876, 
		2810, 2726, 2636, 2528, 2782, 2665, 2589, 2440, 2414, 2440, 2266, 2243, 2079, 2119, 1958, 2002, 
		1839, 1858, 1665, 1645, 1484, 1431, 1310, 1235, 1140, 1109, 1030, 1017, 974, 991, 974, 985, 
		975, 1000, 1028, 1081, 1124, 1213, 1297, 1418, 1510, 1664, 1700, 1844, 1792, 1919, 1774, 1891, 
		1883, 1982, 2029, 2146, 2147, 2378, 2269, 2518, 2476, 2645, 2650, 2645, 2753, 2645, 2846, 2722, 
		2818, 2629, 2789, 2540, 2702, 2363, 2673, 2472, 2752, 2472, 2533, 2296, 2289, 2148, 2138, 2026, 
		2071, 2026, 2022, 1890, 1939, 1890, 1838, 1890, 1715, 1865, 1664, 1865, 1844, 2012, 1919, 2065, 
		1976, 2123, 2121, 2361, 2146, 2405, 2378, 2629, 2518, 2722, 2645, 3196, 3129, 2954, 2903, 2819, 
		3202, 3348, 3202, 3335, 3202, 3230, 3100, 3141, 2970, 3129, 2968, 2903, 2514, 2440, 2665, 2243, 
		2440, 2243, 2514, 2323, 2484, 2255, 2448, 2207, 2220, 2104, 1992, 1941, 1831, 1858, 1831, 1645, 
		1808, 1574, 1716, 1476, 1644, 1469, 1644, 1720, 1795, 1869, 1795, 1956, 1938, 2068, 1992, 2128, 
		2220, 2694, 2810, 2636, 2119, 2243, 2119, 2323, 2119, 2255, 2064, 2104, 2064, 1941, 2064, 1858, 
		2064, 2002, 2119, 2104, 2255, 2207, 1992, 1808, 1831, 1716, 1795, 1644, 1574, 1431, 1645, 1017, 
		1049, 991, 1453, 1418, 1213, 1453, 1664, 1418, 1715, 1664, 1453, 1746, 1777, 1907, 1976, 1891, 
		1919, 1976, 1982, 1891, 2026, 1865, 1890, 2026, 2012, 1865, 2148, 2012, 2026, 2148, 2065, 2012, 
		2121, 1982, 1976, 2121, 2146, 1982, 2673, 2752, 2673, 2853, 2702, 2878, 2789, 2962, 2921, 3096, 
		3087, 3240, 3302, 2405, 2540, 2629, 2361, 2540, 2405, 2361, 2363, 2540, 2123, 2363, 2361, 2789, 
		2921, 2818, 2921, 2846, 3087, 2079, 1958, 1932, 1902, 1735, 1727, 1471, 1484, 1244, 1310, 1244, 
		1140, 1108, 1030, 1029, 974, 1016, 975, 1052, 1028, 1143, 1124, 1143, 1297, 1289, 1432, 1391, 
		1584, 1619, 1774, 1738, 1883, 1893, 2029, 1920, 2066, 1929, 2066, 2137, 2269, 2137, 2476, 2275, 
		2414, 1839, 1902, 1958, 1839, 1727, 1902, 1484, 1727, 1665, 1839, 1432, 1297, 1432, 1510, 1653, 
		1700, 1653, 1792, 1653, 1774, 1653, 1584, 1432, 2066, 2029, 2066, 2147, 2269, 1932, 1735, 1812, 
		1663, 1802, 1596, 1794, 1731, 1920, 1731, 1893, 1731, 1738, 1553, 1478, 1333, 1214, 1118, 1052, 
		1118, 1016, 1086, 1029, 1130, 1108, 1130, 1244, 1282, 1471, 1324, 1489, 1376, 1596, 1553, 1731, 
		1471, 1663, 1735, 1471, 1489, 1663, 1596, 1324, 1282, 1324, 1130, 1199, 1086, 1199, 1118, 1199, 
		1333, 1376, 1553, 1376, 1324, 1199, 1052, 1143, 1214, 1289, 1214, 1391, 1478, 1619, 1738, 1802, 
		1794, 1929, 1920, 2472, 2363, 2191, 2123, 2191, 2065, 2191, 2148, 2191, 2296, 2472, 1777, 1746, 
		1717, 1531, 1564, 1388, 1529, 1349, 1532, 1276, 1477, 1255, 1354, 1217, 1220, 1107, 1106, 1036, 
		1106, 1097, 1207, 1222, 1355, 1348, 1486, 1517, 1709, 1739, 1886, 1937, 1886, 2027, 1930, 2020, 
		1789, 1860, 1696, 1840, 1760, 1913, 1811, 2014, 1859, 1960, 1859, 1895, 1770, 1853, 1732, 1819, 
		1695, 1777, 1564, 1717, 1886, 1930, 1709, 1789, 1597, 1696, 1455, 1534, 1298, 1425, 1220, 1425, 
		1354, 1599, 1605, 1770, 1605, 1732, 1477, 1732, 1532, 1695, 1529, 1564, 1486, 1709, 1486, 1597, 
		1355, 1455, 1207, 1298, 1106, 1220, 1534, 1696, 1534, 1760, 1675, 1811, 1599, 1811, 1770, 1859, 
		1599, 1425, 1675, 1534, 1913, 2040, 2014, 1913, 2036, 2040, 1107, 1027, 1036, 1477, 1354, 1605, 
		1311, 1531, 1311, 1294, 1311, 1167, 1136, 1055, 1136, 1026, 1125, 1095, 1276, 1095, 1255, 1095, 
		1217, 1095, 1107, 1095, 1027, 1026, 1276, 1349, 1125, 1223, 1136, 1223, 1311, 1388, 1531, 1349, 
		1388, 1223, 1049, 1017, 1096, 1109, 1266, 1235, 1405, 1431, 1405, 1574, 1405, 1476, 1266, 1256, 
		1096, 1245, 1096, 1120, 1049, 1469, 1256, 1476, 1245, 1256, 1469, 1926, 2036, 1926, 1913, 1926, 
		1840, 1926, 1860, 1926, 2020, 1926, 2051, 2036, 1851, 1938, 1851, 1795, 1851, 1716, 1851, 1808, 
		1851, 1992, 1938, 3090, 2864, 3090, 2842, 3090, 3086, 3090, 3225, 3090, 3255, 3090, 3263, 3090, 
		3150, 3090, 2979, 2864
	};

	glEnableClientState(GL_NORMAL_ARRAY);
	glNormalPointer(GL_FLOAT, 0, NormalData);
	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(3, GL_FLOAT, 0, VertexData);


	// Material attributes for surface 'Teeth.001'
	cartoonguy_Material_Parameters(35.0000f, 0.200000f, 0.200000f, 0.200000f, 0.200000f, 0.200000f, 0.200000f);

	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[0]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[4]);
	glDrawElements(GL_TRIANGLE_STRIP, 20, GL_UNSIGNED_INT, &Indices[7]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[27]);
	glDrawElements(GL_TRIANGLE_STRIP, 21, GL_UNSIGNED_INT, &Indices[31]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[52]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[61]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[67]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[73]);
	glDrawElements(GL_TRIANGLE_STRIP, 36, GL_UNSIGNED_INT, &Indices[79]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[115]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[121]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[127]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[132]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[136]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[140]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[146]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[151]);
	glDrawElements(GL_TRIANGLE_STRIP, 22, GL_UNSIGNED_INT, &Indices[158]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[180]);
	glDrawElements(GL_TRIANGLE_STRIP, 23, GL_UNSIGNED_INT, &Indices[187]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[210]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[223]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[227]);
	glDrawElements(GL_TRIANGLE_STRIP, 23, GL_UNSIGNED_INT, &Indices[234]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[257]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[261]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[271]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[281]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[285]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[289]);
	glDrawElements(GL_TRIANGLE_STRIP, 31, GL_UNSIGNED_INT, &Indices[293]);
 glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[324]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[330]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[336]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[341]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[347]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[353]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[359]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[364]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[370]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[376]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[382]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[387]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[393]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[397]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[403]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[408]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[412]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[418]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[423]);
	glDrawElements(GL_TRIANGLE_STRIP, 48, GL_UNSIGNED_INT, &Indices[429]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[477]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[481]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[485]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[489]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[498]);
	glDrawElements(GL_TRIANGLE_STRIP, 30, GL_UNSIGNED_INT, &Indices[506]);

	// Material attributes for surface 'Material'
	cartoonguy_Material_Parameters(128.000f, 0.111236f, 0.200000f, 0.115283f, 0.200000f, 0.200000f, 0.200000f);

	glDrawElements(GL_TRIANGLE_STRIP, 19, GL_UNSIGNED_INT, &Indices[536]);
	glDrawElements(GL_TRIANGLE_STRIP, 23, GL_UNSIGNED_INT, &Indices[555]);

	// Material attributes for surface 'Hair'
	cartoonguy_Material_Parameters(35.0000f, 0.200000f, 0.144238f, 0.0938018f, 0.200000f, 0.200000f, 0.200000f);

	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[578]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[582]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[586]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[590]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[594]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[600]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[606]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[610]);
	glDrawElements(GL_TRIANGLE_STRIP, 24, GL_UNSIGNED_INT, &Indices[614]);
	glDrawElements(GL_TRIANGLE_STRIP, 38, GL_UNSIGNED_INT, &Indices[638]);
 glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[676]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[682]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[688]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[696]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[705]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[713]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[722]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[730]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[739]);
	glDrawElements(GL_TRIANGLE_STRIP, 92, GL_UNSIGNED_INT, &Indices[743]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[835]);
 glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[847]);
	glDrawElements(GL_TRIANGLE_STRIP, 21, GL_UNSIGNED_INT, &Indices[854]);
 glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[875]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[893]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[896]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[903]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[906]);
	glDrawElements(GL_TRIANGLE_STRIP, 21, GL_UNSIGNED_INT, &Indices[916]);
	glDrawElements(GL_TRIANGLE_STRIP, 49, GL_UNSIGNED_INT, &Indices[937]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[986]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[993]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[998]);
	glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[1007]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[1025]);
	glDrawElements(GL_TRIANGLE_STRIP, 14, GL_UNSIGNED_INT, &Indices[1037]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[1051]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[1057]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[1063]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1076]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1080]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[1084]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1096]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1100]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1104]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1108]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1112]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[1116]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[1122]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[1128]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1139]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1143]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[1147]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[1160]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1169]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1173]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[1177]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1188]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1192]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1196]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1200]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[1204]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1210]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[1214]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1225]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1229]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[1233]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1242]);

	// Material attributes for surface 'Mouth'
	cartoonguy_Material_Parameters(35.0000f, 0.200000f, 0.0631415f, 0.0529461f, 0.200000f, 0.200000f, 0.200000f);

	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[1246]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1258]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1262]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1266]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1270]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1274]);
	glDrawElements(GL_TRIANGLE_STRIP, 28, GL_UNSIGNED_INT, &Indices[1278]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[1306]);
	glDrawElements(GL_TRIANGLE_STRIP, 19, GL_UNSIGNED_INT, &Indices[1319]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[1338]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1348]);
	glDrawElements(GL_TRIANGLE_STRIP, 17, GL_UNSIGNED_INT, &Indices[1352]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[1369]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1374]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[1378]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1384]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[1388]);
	glDrawElements(GL_TRIANGLE_STRIP, 14, GL_UNSIGNED_INT, &Indices[1394]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[1408]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[1420]);
	glDrawElements(GL_TRIANGLE_STRIP, 17, GL_UNSIGNED_INT, &Indices[1426]);
	glDrawElements(GL_TRIANGLE_STRIP, 29, GL_UNSIGNED_INT, &Indices[1443]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1472]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1476]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[1480]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[1485]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1496]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[1500]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1506]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1510]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[1514]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1521]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[1525]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1537]);
	glDrawElements(GL_TRIANGLE_STRIP, 26, GL_UNSIGNED_INT, &Indices[1541]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1567]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1571]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1575]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1579]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1583]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1587]);

	// Material attributes for surface 'Material'
	cartoonguy_Material_Parameters(92.0000f, 0.200000f, 0.200000f, 0.200000f, 0.200000f, 0.200000f, 0.200000f);

	glDrawElements(GL_TRIANGLE_STRIP, 32, GL_UNSIGNED_INT, &Indices[1591]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[1623]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1629]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[1633]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1640]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1644]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1648]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[1652]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[1661]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[1670]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[1680]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1690]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1694]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1698]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[1702]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[1713]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1722]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1726]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1730]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[1734]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[1744]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1747]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1751]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[1755]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[1760]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[1766]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[1769]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1776]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1780]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1784]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[1788]);
	glDrawElements(GL_TRIANGLE_STRIP, 22, GL_UNSIGNED_INT, &Indices[1797]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1819]);
	glDrawElements(GL_TRIANGLE_STRIP, 29, GL_UNSIGNED_INT, &Indices[1823]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1852]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1856]);
	glDrawElements(GL_TRIANGLE_STRIP, 28, GL_UNSIGNED_INT, &Indices[1860]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[1888]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1895]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1899]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[1903]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1915]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1919]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1923]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[1927]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[1933]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1939]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1943]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1947]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1951]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[1955]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[1959]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[1971]);
	glDrawElements(GL_TRIANGLE_STRIP, 26, GL_UNSIGNED_INT, &Indices[1981]);
	glDrawElements(GL_TRIANGLE_STRIP, 27, GL_UNSIGNED_INT, &Indices[2007]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2034]);
	glDrawElements(GL_TRIANGLE_STRIP, 50, GL_UNSIGNED_INT, &Indices[2038]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[2088]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[2098]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2105]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[2109]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2122]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2126]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2130]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2134]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2138]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2142]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2146]);
	glDrawElements(GL_TRIANGLE_STRIP, 40, GL_UNSIGNED_INT, &Indices[2150]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2190]);
	glDrawElements(GL_TRIANGLE_STRIP, 43, GL_UNSIGNED_INT, &Indices[2194]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[2237]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2244]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2248]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[2252]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[2259]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[2265]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[2271]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[2277]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2283]);
	glDrawElements(GL_TRIANGLE_STRIP, 36, GL_UNSIGNED_INT, &Indices[2287]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2323]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2327]);
	glDrawElements(GL_TRIANGLE_STRIP, 20, GL_UNSIGNED_INT, &Indices[2331]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2351]);
	glDrawElements(GL_TRIANGLE_STRIP, 28, GL_UNSIGNED_INT, &Indices[2355]);
	glDrawElements(GL_TRIANGLE_STRIP, 20, GL_UNSIGNED_INT, &Indices[2383]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2403]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[2407]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[2414]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[2424]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[2429]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2432]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[2436]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2439]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2443]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2447]);
	glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[2451]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[2469]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[2475]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2487]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2491]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[2495]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2503]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2507]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2511]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2515]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2519]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2523]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2527]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2531]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2535]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[2539]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2544]);
	glDrawElements(GL_TRIANGLE_STRIP, 16, GL_UNSIGNED_INT, &Indices[2548]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[2564]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[2570]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2576]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2580]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2584]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2588]);
	glDrawElements(GL_TRIANGLE_STRIP, 27, GL_UNSIGNED_INT, &Indices[2592]);
	glDrawElements(GL_TRIANGLE_STRIP, 28, GL_UNSIGNED_INT, &Indices[2619]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2647]);
	glDrawElements(GL_TRIANGLE_STRIP, 16, GL_UNSIGNED_INT, &Indices[2651]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2667]);
	glDrawElements(GL_TRIANGLE_STRIP, 17, GL_UNSIGNED_INT, &Indices[2671]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[2688]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[2691]);
	glDrawElements(GL_TRIANGLE_STRIP, 17, GL_UNSIGNED_INT, &Indices[2703]);
	glDrawElements(GL_TRIANGLE_STRIP, 24, GL_UNSIGNED_INT, &Indices[2720]);
	glDrawElements(GL_TRIANGLE_STRIP, 17, GL_UNSIGNED_INT, &Indices[2744]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[2761]);
	glDrawElements(GL_TRIANGLE_STRIP, 14, GL_UNSIGNED_INT, &Indices[2764]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[2778]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[2790]);
	glDrawElements(GL_TRIANGLES, 12, GL_UNSIGNED_INT, &Indices[2800]);
	glDrawElements(GL_TRIANGLE_STRIP, 19, GL_UNSIGNED_INT, &Indices[2812]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[2831]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2834]);
	glDrawElements(GL_TRIANGLE_STRIP, 24, GL_UNSIGNED_INT, &Indices[2838]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[2862]);
	glDrawElements(GL_TRIANGLE_STRIP, 16, GL_UNSIGNED_INT, &Indices[2865]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[2881]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[2887]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[2893]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[2905]);

	// Material attributes for surface 'Material'
	cartoonguy_Material_Parameters(92.0000f, 0.107547f, 0.148793f, 0.200000f, 0.200000f, 0.200000f, 0.200000f);

	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[2908]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2915]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2919]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2923]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[2927]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[2935]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[2943]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[2948]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2958]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2962]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[2966]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2974]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[2978]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[2983]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2989]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2993]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[2997]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3001]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3005]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3009]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3013]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3017]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3021]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[3025]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3030]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3034]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[3038]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3043]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3047]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[3051]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[3059]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3067]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[3071]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[3076]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[3081]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3086]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[3090]);
	glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[3095]);
	glDrawElements(GL_TRIANGLE_STRIP, 24, GL_UNSIGNED_INT, &Indices[3113]);
	glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[3137]);
	glDrawElements(GL_TRIANGLE_STRIP, 17, GL_UNSIGNED_INT, &Indices[3155]);
	glDrawElements(GL_TRIANGLE_STRIP, 20, GL_UNSIGNED_INT, &Indices[3172]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[3192]);
	glDrawElements(GL_TRIANGLE_STRIP, 16, GL_UNSIGNED_INT, &Indices[3203]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3219]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3223]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[3227]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[3239]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3247]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3253]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[3257]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[3265]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3270]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3276]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[3280]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3288]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3292]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3296]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3300]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3304]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[3310]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3315]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3319]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3323]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3327]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3331]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3335]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3339]);
	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[3343]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3358]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3362]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[3366]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3375]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[3379]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3386]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3390]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[3394]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3399]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3405]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[3409]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3414]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3418]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3422]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3426]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3430]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3434]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3438]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3444]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3450]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3456]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3462]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3466]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3470]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3476]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3482]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3486]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3490]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3494]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[3498]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[3508]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[3518]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3521]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[3525]);
	glDrawElements(GL_TRIANGLE_STRIP, 36, GL_UNSIGNED_INT, &Indices[3530]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[3566]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3577]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[3583]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[3592]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[3601]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[3604]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[3616]);
	glDrawElements(GL_TRIANGLE_STRIP, 23, GL_UNSIGNED_INT, &Indices[3626]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3649]);
	glDrawElements(GL_TRIANGLE_STRIP, 23, GL_UNSIGNED_INT, &Indices[3653]);
	glDrawElements(GL_TRIANGLE_STRIP, 27, GL_UNSIGNED_INT, &Indices[3676]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3703]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[3707]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3717]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[3721]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3729]);
	glDrawElements(GL_TRIANGLE_STRIP, 23, GL_UNSIGNED_INT, &Indices[3733]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3756]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3760]);
	glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[3764]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3782]);
	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[3786]);
	glDrawElements(GL_TRIANGLE_STRIP, 31, GL_UNSIGNED_INT, &Indices[3801]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[3832]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3840]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3846]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[3850]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3855]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[3859]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[3871]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[3882]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3895]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3899]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3903]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3907]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3911]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3915]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3919]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3923]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3929]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3933]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3937]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3941]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[3945]);
	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[3949]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[3964]);
	glDrawElements(GL_TRIANGLE_STRIP, 21, GL_UNSIGNED_INT, &Indices[3970]);
	glDrawElements(GL_TRIANGLE_STRIP, 14, GL_UNSIGNED_INT, &Indices[3991]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[4005]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[4011]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4018]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[4022]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[4033]);
	glDrawElements(GL_TRIANGLE_STRIP, 22, GL_UNSIGNED_INT, &Indices[4039]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[4061]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4073]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4077]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4081]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[4085]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[4090]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4102]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[4106]);
	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[4117]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4132]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[4136]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4142]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[4146]);
	glDrawElements(GL_TRIANGLE_STRIP, 14, GL_UNSIGNED_INT, &Indices[4151]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4165]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4169]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4173]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4177]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4181]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4185]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4189]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4193]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4197]);
	glDrawElements(GL_TRIANGLE_STRIP, 20, GL_UNSIGNED_INT, &Indices[4201]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4221]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4225]);
	glDrawElements(GL_TRIANGLE_STRIP, 19, GL_UNSIGNED_INT, &Indices[4229]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4248]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4252]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[4256]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[4267]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[4274]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[4281]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[4290]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4300]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4304]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[4308]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[4313]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4318]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[4322]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4329]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4333]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4337]);
	glDrawElements(GL_TRIANGLE_STRIP, 27, GL_UNSIGNED_INT, &Indices[4341]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4368]);

	// Material attributes for surface 'Gums'
	cartoonguy_Material_Parameters(128.000f, 0.200000f, 0.0844119f, 0.0742133f, 0.200000f, 0.200000f, 0.200000f);

	glDrawElements(GL_TRIANGLE_STRIP, 34, GL_UNSIGNED_INT, &Indices[4372]);
	glDrawElements(GL_TRIANGLE_STRIP, 31, GL_UNSIGNED_INT, &Indices[4406]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4437]);

	// Material attributes for surface 'Material'
	cartoonguy_Material_Parameters(35.0000f, 0.200000f, 0.0844119f, 0.0742133f, 0.200000f, 0.200000f, 0.200000f);

	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4441]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[4445]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[4450]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[4453]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[4461]);
	glDrawElements(GL_TRIANGLE_STRIP, 23, GL_UNSIGNED_INT, &Indices[4467]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4490]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[4494]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[4500]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4506]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4510]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[4514]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[4524]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[4535]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[4543]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[4550]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[4561]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4571]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4575]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[4579]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[4585]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4592]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4596]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4600]);
	glDrawElements(GL_TRIANGLE_STRIP, 37, GL_UNSIGNED_INT, &Indices[4604]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4641]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4645]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4649]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4653]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4657]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4661]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4665]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4669]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4673]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[4677]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[4682]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4688]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4692]);
	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[4696]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4711]);
	glDrawElements(GL_TRIANGLE_STRIP, 19, GL_UNSIGNED_INT, &Indices[4715]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4734]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[4738]);
	glDrawElements(GL_TRIANGLE_STRIP, 36, GL_UNSIGNED_INT, &Indices[4746]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[4782]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[4794]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4805]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4809]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[4813]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[4820]);

	// Material attributes for surface 'skin'
	cartoonguy_Material_Parameters(35.0000f, 0.200000f, 0.134396f, 0.0843147f, 0.200000f, 0.200000f, 0.200000f);

	glDrawElements(GL_TRIANGLE_STRIP, 17, GL_UNSIGNED_INT, &Indices[4832]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[4849]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[4856]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[4862]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[4871]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4877]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4881]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[4885]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[4894]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4904]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[4908]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4911]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[4915]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[4926]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4929]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4933]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4937]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4941]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4945]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[4949]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[4953]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[4959]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[4965]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[4973]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[4982]);
	glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[4990]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5008]);
	glDrawElements(GL_TRIANGLE_STRIP, 21, GL_UNSIGNED_INT, &Indices[5012]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5033]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5037]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5041]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5045]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5051]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5055]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5059]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5063]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5067]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5071]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5075]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5079]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5083]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5089]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[5095]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[5103]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5112]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5116]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5120]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5124]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[5128]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[5139]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5149]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5153]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[5157]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5167]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[5171]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5182]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5186]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5190]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5194]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5198]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5202]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5206]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5212]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5218]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5224]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5230]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5236]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5242]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5248]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5254]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5260]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5266]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5270]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5274]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5278]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[5282]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5295]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5299]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[5303]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[5316]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5326]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5330]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[5334]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5339]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[5343]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5354]);
	glDrawElements(GL_TRIANGLE_STRIP, 14, GL_UNSIGNED_INT, &Indices[5358]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5372]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5376]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5380]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[5384]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5397]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5401]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[5405]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5418]);
	glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[5422]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[5440]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5445]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5449]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[5453]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5456]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5460]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[5464]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5471]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5475]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5479]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5483]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5487]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5491]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5495]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5499]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5503]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5507]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5513]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5517]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5521]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5525]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5529]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5533]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5537]);
	glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[5541]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[5559]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[5570]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5578]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[5582]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[5592]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5599]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5603]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[5607]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5619]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5623]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5627]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5633]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5639]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5643]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5647]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5651]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5655]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5659]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[5663]);
	glDrawElements(GL_TRIANGLE_STRIP, 14, GL_UNSIGNED_INT, &Indices[5668]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5682]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5686]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5690]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[5694]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5699]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5703]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5707]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5711]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5715]);
	glDrawElements(GL_TRIANGLE_STRIP, 30, GL_UNSIGNED_INT, &Indices[5719]);
	glDrawElements(GL_TRIANGLE_STRIP, 27, GL_UNSIGNED_INT, &Indices[5749]);
	glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[5776]);
	glDrawElements(GL_TRIANGLE_STRIP, 17, GL_UNSIGNED_INT, &Indices[5794]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[5811]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5818]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5822]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5826]);
	glDrawElements(GL_TRIANGLE_STRIP, 16, GL_UNSIGNED_INT, &Indices[5830]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[5846]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[5849]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5854]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[5858]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[5866]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5874]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[5878]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[5882]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5887]);
	glDrawElements(GL_TRIANGLE_STRIP, 62, GL_UNSIGNED_INT, &Indices[5893]);
	glDrawElements(GL_TRIANGLE_STRIP, 19, GL_UNSIGNED_INT, &Indices[5955]);
	glDrawElements(GL_TRIANGLE_STRIP, 27, GL_UNSIGNED_INT, &Indices[5974]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[6001]);
	glDrawElements(GL_TRIANGLES, 12, GL_UNSIGNED_INT, &Indices[6006]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[6018]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[6025]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6030]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6034]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[6038]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6045]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[6049]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[6054]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6057]);
	glDrawElements(GL_TRIANGLE_STRIP, 28, GL_UNSIGNED_INT, &Indices[6061]);
	glDrawElements(GL_TRIANGLE_STRIP, 30, GL_UNSIGNED_INT, &Indices[6089]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6119]);
	glDrawElements(GL_TRIANGLE_STRIP, 21, GL_UNSIGNED_INT, &Indices[6123]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[6144]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6149]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6153]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6157]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[6161]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6168]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[6172]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[6182]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[6187]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6194]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6200]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6204]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6208]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6212]);
	glDrawElements(GL_TRIANGLE_STRIP, 19, GL_UNSIGNED_INT, &Indices[6216]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6235]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6239]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6243]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6247]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[6253]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6260]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6266]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[6270]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6275]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[6279]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[6291]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6294]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6298]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6304]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6308]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6312]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6316]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6320]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6324]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6328]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6334]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[6338]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6351]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6355]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[6359]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6364]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6368]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6372]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6376]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6380]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[6384]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6389]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6393]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6399]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6405]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6409]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6413]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6417]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6421]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6425]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6429]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6433]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6439]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6445]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6451]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6455]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[6459]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6464]);
	glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[6468]);
	glDrawElements(GL_TRIANGLE_STRIP, 23, GL_UNSIGNED_INT, &Indices[6486]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6509]);
	glDrawElements(GL_TRIANGLE_STRIP, 24, GL_UNSIGNED_INT, &Indices[6513]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6537]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6543]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6549]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6553]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6557]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[6561]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6568]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6572]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6576]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6580]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[6584]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[6597]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[6609]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[6622]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6634]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6638]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6642]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6646]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6650]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6654]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6658]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6662]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[6666]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[6674]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6681]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6685]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6689]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6695]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[6699]);
	glDrawElements(GL_TRIANGLE_STRIP, 23, GL_UNSIGNED_INT, &Indices[6708]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[6731]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6739]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6743]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[6747]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6757]);
	glDrawElements(GL_TRIANGLE_STRIP, 16, GL_UNSIGNED_INT, &Indices[6761]);
	glDrawElements(GL_TRIANGLE_STRIP, 23, GL_UNSIGNED_INT, &Indices[6777]);
	glDrawElements(GL_TRIANGLE_STRIP, 22, GL_UNSIGNED_INT, &Indices[6800]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6822]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6826]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6830]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6834]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6838]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6842]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[6846]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6854]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[6858]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[6861]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6868]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6872]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6876]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6880]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6884]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6888]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6892]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6896]);
	glDrawElements(GL_TRIANGLE_STRIP, 35, GL_UNSIGNED_INT, &Indices[6902]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[6937]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[6942]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6947]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6951]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6955]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[6959]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6966]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6970]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6974]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6978]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6982]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6986]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[6990]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[6995]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6999]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7005]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7011]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[7015]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7020]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7024]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7030]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7034]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7038]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7042]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[7048]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[7055]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7062]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[7066]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7071]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7075]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7081]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7085]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7089]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7095]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7101]);
	glDrawElements(GL_TRIANGLE_STRIP, 14, GL_UNSIGNED_INT, &Indices[7105]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[7119]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7127]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[7131]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7144]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7148]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[7152]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[7164]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7177]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[7181]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7190]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7194]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7198]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7202]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7206]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[7210]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[7215]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7220]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7226]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7230]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7236]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7240]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7244]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7248]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7252]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7256]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[7260]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[7267]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[7275]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7288]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7292]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7296]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[7302]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7307]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7313]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[7317]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7325]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7329]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7333]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7337]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7341]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7347]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7353]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7357]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7361]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7365]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7369]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7375]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[7379]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7386]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[7390]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7398]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[7402]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7412]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7418]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[7422]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[7431]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7438]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[7442]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7447]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7451]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[7457]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7470]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7474]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[7480]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7485]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7491]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[7495]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[7503]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7512]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7516]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7522]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7526]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7530]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7534]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[7538]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7550]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7554]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[7558]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7571]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7575]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[7579]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7582]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[7586]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[7598]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7608]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7612]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[7616]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7619]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7623]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7627]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7631]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[7635]);
	glDrawElements(GL_TRIANGLE_STRIP, 19, GL_UNSIGNED_INT, &Indices[7644]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7663]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7667]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7671]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[7677]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7684]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7688]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7692]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7696]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7700]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7704]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7708]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7712]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7716]);
	glDrawElements(GL_TRIANGLE_STRIP, 22, GL_UNSIGNED_INT, &Indices[7720]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7742]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7746]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7750]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7754]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7758]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7762]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7766]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[7770]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7775]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7781]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7785]);
	glDrawElements(GL_TRIANGLE_STRIP, 17, GL_UNSIGNED_INT, &Indices[7789]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[7806]);
	glDrawElements(GL_TRIANGLE_STRIP, 16, GL_UNSIGNED_INT, &Indices[7811]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7827]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7831]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7835]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7839]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7843]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7847]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[7851]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7861]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7865]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[7869]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[7879]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7884]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[7888]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7893]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7899]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7903]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7907]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7913]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[7919]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[7930]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7935]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[7939]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7949]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7955]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7959]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[7963]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[7970]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7978]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7982]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7986]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[7990]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7994]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8000]);
	glDrawElements(GL_TRIANGLE_STRIP, 21, GL_UNSIGNED_INT, &Indices[8006]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8027]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[8031]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8036]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8040]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[8044]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8056]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[8062]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8067]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[8071]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8079]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8083]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[8087]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[8094]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[8099]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8110]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8114]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8118]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8122]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8126]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8130]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[8134]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8139]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8143]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8147]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[8151]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8156]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8160]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8166]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[8172]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8179]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8183]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8187]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8191]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8195]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8199]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8203]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8207]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8211]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[8215]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8220]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8224]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[8228]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8239]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8243]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8247]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8251]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8255]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8259]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[8263]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8276]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8280]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[8284]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8295]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[8299]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[8309]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8314]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8318]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[8322]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8334]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[8338]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8349]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8355]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8361]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8367]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8373]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8377]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8381]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8385]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8389]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8393]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[8397]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8402]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8406]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8410]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8414]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[8418]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[8425]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8435]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8441]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[8445]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[8455]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[8465]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8474]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8480]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8486]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8490]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8496]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[8500]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8507]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8511]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8515]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8519]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[8523]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8535]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8539]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[8543]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8554]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[8558]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[8568]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8573]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8579]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[8585]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8594]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8600]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8606]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8610]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[8614]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8619]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8623]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8627]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8631]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8635]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8639]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8643]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8647]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[8651]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8660]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[8664]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8672]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8678]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8684]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8688]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8692]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8696]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8700]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8706]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8712]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8718]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8724]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8728]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8732]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8736]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8740]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8744]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8748]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8752]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8756]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8760]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8764]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8768]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8774]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8778]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8782]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8786]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8790]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8794]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8798]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8802]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8806]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8810]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8814]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8818]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8822]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8826]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8830]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8836]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8842]);
	glDrawElements(GL_TRIANGLE_STRIP, 51, GL_UNSIGNED_INT, &Indices[8846]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8897]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8901]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8905]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8909]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[8913]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8918]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8922]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8926]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8930]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[8934]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8939]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8943]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8947]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[8951]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8960]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8966]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8970]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8974]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8980]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[8984]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8991]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8995]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[8999]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9007]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[9011]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9018]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[9022]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9030]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9034]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[9038]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9043]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9047]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9051]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9057]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[9061]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9068]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9072]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9076]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9080]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9084]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9088]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9092]);
	glDrawElements(GL_TRIANGLE_STRIP, 14, GL_UNSIGNED_INT, &Indices[9096]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9110]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9114]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9118]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9124]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9128]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9132]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9136]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9140]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9144]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9148]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[9152]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[9161]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9169]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9175]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9179]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9183]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9187]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9191]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9195]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9199]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9203]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9207]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[9211]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9218]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[9222]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9230]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[9234]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9243]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9247]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[9251]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[9256]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[9266]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9275]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9279]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9283]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9287]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9291]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9295]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9299]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9303]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9307]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9311]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9315]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[9319]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[9327]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9338]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9342]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9346]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[9350]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[9358]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9365]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9371]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9377]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9381]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9385]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9389]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[9393]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[9400]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9408]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9412]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9416]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9420]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9424]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9428]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9432]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9436]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9440]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9444]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9448]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9452]);
	glDrawElements(GL_TRIANGLE_STRIP, 17, GL_UNSIGNED_INT, &Indices[9456]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[9473]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9481]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9485]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[9489]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9498]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[9502]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9510]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9516]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9522]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9526]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9530]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9534]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9538]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9544]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9550]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9556]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9562]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9566]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9570]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9574]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9578]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9582]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9586]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9590]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9594]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9598]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[9602]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[9611]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9621]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9625]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9629]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9633]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9637]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9641]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9645]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9649]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9653]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9657]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9661]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9667]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9673]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9677]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9681]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9685]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9689]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9695]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9701]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9707]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9713]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9717]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9721]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9727]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9731]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9735]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9739]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9743]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9747]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9751]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9755]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9759]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9763]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9767]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9771]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9775]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9779]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9783]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9787]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9791]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9795]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9799]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[9805]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9812]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9816]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9820]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9824]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[9828]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[9838]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9847]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9851]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[9855]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9860]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9866]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[9870]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9879]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9883]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9887]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9891]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9895]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9899]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9903]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9909]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9913]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9917]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9921]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9925]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9929]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9933]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9937]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[9941]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9946]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9950]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9956]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[9962]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[9970]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[9979]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9984]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9990]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9994]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[9998]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10005]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10011]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10015]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10019]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[10023]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10035]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10041]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[10047]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10052]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10056]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10060]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10064]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10068]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10072]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10076]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10080]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10084]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10088]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[10092]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10097]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10101]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10107]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10113]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10117]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[10121]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[10129]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[10140]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10148]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10152]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10156]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10160]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[10164]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[10177]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10189]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10193]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10197]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10201]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10205]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10211]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10217]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[10221]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10228]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[10232]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10240]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10244]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10248]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10252]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10256]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10262]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10268]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10274]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10280]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10286]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10292]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10296]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10302]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10306]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10310]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10314]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10318]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10322]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[10326]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10331]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10337]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10343]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10349]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10355]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10359]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10363]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10367]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10371]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10375]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10379]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[10383]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10388]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10392]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10396]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10400]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10404]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10408]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[10412]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[10422]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[10433]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10438]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10444]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[10450]);
	glDrawElements(GL_TRIANGLE_STRIP, 23, GL_UNSIGNED_INT, &Indices[10455]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10478]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[10482]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10485]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[10491]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10494]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10498]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10502]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10506]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10510]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10514]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10518]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10522]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10526]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10530]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10534]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10538]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10542]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10546]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10550]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10554]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10558]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[10562]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10567]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10571]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10575]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10579]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10583]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10587]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10591]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10595]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10599]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10603]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10607]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10611]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[10615]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[10623]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10630]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10634]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10638]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10642]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10646]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[10650]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[10655]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10660]);
	glDrawElements(GL_TRIANGLE_STRIP, 24, GL_UNSIGNED_INT, &Indices[10666]);
	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[10690]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10705]);
	glDrawElements(GL_TRIANGLE_STRIP, 26, GL_UNSIGNED_INT, &Indices[10709]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10735]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[10739]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10747]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10751]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10755]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10759]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10763]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10767]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10771]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10775]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10779]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10783]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10787]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10791]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[10795]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10800]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[10806]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10816]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10820]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10824]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[10828]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[10838]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[10849]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10857]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[10863]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10868]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10872]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10876]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10880]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10884]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10888]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10892]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10896]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10900]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10904]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10908]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10912]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10916]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10920]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10924]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10928]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10932]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10936]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10940]);
	glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[10944]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[10962]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[10965]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[10975]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10978]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10982]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10986]);
	glDrawElements(GL_TRIANGLE_STRIP, 21, GL_UNSIGNED_INT, &Indices[10990]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11011]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11015]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[11021]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11024]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11028]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11032]);
	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[11036]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[11051]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11059]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[11063]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11068]);
	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[11074]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[11089]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11094]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11098]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11102]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11106]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11110]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11114]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11118]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11122]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11126]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11130]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11134]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11138]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11142]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11146]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11150]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11154]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11158]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11162]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11166]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11170]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11174]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11178]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11182]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11186]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11190]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11194]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11198]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11202]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[11208]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11213]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11217]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11221]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11225]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11231]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11235]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11239]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11243]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11247]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11251]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11255]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11259]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11263]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11267]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11271]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11275]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11279]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11283]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11287]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11291]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11295]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[11299]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[11307]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[11316]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[11321]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[11330]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11340]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[11344]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11353]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[11357]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11365]);
	glDrawElements(GL_TRIANGLE_STRIP, 21, GL_UNSIGNED_INT, &Indices[11369]);
	glDrawElements(GL_TRIANGLE_STRIP, 20, GL_UNSIGNED_INT, &Indices[11390]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11410]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11414]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11418]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11422]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11426]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11430]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11436]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11440]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11444]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11448]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11452]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11456]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11460]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11464]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11468]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11472]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11476]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11480]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11484]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11488]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11492]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11496]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11500]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11504]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11508]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11512]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11516]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11520]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11524]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11528]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11532]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11536]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11540]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11544]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11548]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11552]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[11556]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11561]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11567]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11571]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11575]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11579]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11583]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11587]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11591]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11595]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11599]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11603]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11607]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11611]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11615]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11619]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11623]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11627]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11631]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11635]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11639]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11645]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11651]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11655]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11659]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11663]);
	glDrawElements(GL_TRIANGLE_STRIP, 19, GL_UNSIGNED_INT, &Indices[11667]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[11686]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11691]);
	glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[11695]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11713]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11719]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11723]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11727]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11731]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11735]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11739]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11743]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11747]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11753]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[11759]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[11767]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11770]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11774]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11780]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11784]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11788]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11792]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11798]);
	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[11802]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11817]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11821]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11825]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[11829]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11832]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11838]);
	glDrawElements(GL_TRIANGLE_STRIP, 24, GL_UNSIGNED_INT, &Indices[11842]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11866]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11870]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11874]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[11880]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11885]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11889]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[11895]);
	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[11906]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[11921]);
	glDrawElements(GL_TRIANGLE_STRIP, 22, GL_UNSIGNED_INT, &Indices[11930]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11952]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11956]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11960]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11964]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11968]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[11972]);
	glDrawElements(GL_TRIANGLE_STRIP, 26, GL_UNSIGNED_INT, &Indices[11981]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12007]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12011]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12015]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[12019]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12032]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[12036]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12048]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12052]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12056]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[12060]);
	glDrawElements(GL_TRIANGLE_STRIP, 40, GL_UNSIGNED_INT, &Indices[12073]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12113]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12117]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[12123]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[12126]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[12131]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12140]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12146]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12150]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12154]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12158]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12162]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[12166]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12171]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12175]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12179]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12183]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12187]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12191]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[12195]);
	glDrawElements(GL_TRIANGLE_STRIP, 99, GL_UNSIGNED_INT, &Indices[12206]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12305]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12309]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12313]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[12319]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[12329]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[12341]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12351]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12355]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[12359]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12372]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[12376]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12379]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12385]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12389]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12393]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12397]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12401]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12405]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12409]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12413]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12417]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12421]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12427]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12433]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12437]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12441]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12445]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12449]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12453]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12457]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12463]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12467]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12473]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12477]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12481]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12487]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12491]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[12495]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12507]);
	glDrawElements(GL_TRIANGLE_STRIP, 20, GL_UNSIGNED_INT, &Indices[12511]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[12531]);
	glDrawElements(GL_TRIANGLES, 9, GL_UNSIGNED_INT, &Indices[12540]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12549]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[12553]);
	glDrawElements(GL_TRIANGLE_STRIP, 30, GL_UNSIGNED_INT, &Indices[12559]);
	glDrawElements(GL_TRIANGLE_STRIP, 48, GL_UNSIGNED_INT, &Indices[12589]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12637]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12641]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[12645]);
	glDrawElements(GL_TRIANGLE_STRIP, 19, GL_UNSIGNED_INT, &Indices[12656]);
	glDrawElements(GL_TRIANGLE_STRIP, 24, GL_UNSIGNED_INT, &Indices[12675]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[12699]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12709]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[12713]);
	glDrawElements(GL_TRIANGLE_STRIP, 23, GL_UNSIGNED_INT, &Indices[12720]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[12743]);
	glDrawElements(GL_TRIANGLE_STRIP, 38, GL_UNSIGNED_INT, &Indices[12746]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12784]);
	glDrawElements(GL_TRIANGLE_STRIP, 28, GL_UNSIGNED_INT, &Indices[12790]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[12818]);
	glDrawElements(GL_TRIANGLE_STRIP, 14, GL_UNSIGNED_INT, &Indices[12828]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12842]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12846]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12850]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[12856]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[12861]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12866]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12870]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[12874]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12884]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12890]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[12894]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12904]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12908]);
	glDrawElements(GL_TRIANGLE_STRIP, 43, GL_UNSIGNED_INT, &Indices[12912]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12955]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12959]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12963]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12967]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[12971]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[12974]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12981]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[12985]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12997]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13001]);
	glDrawElements(GL_TRIANGLE_STRIP, 17, GL_UNSIGNED_INT, &Indices[13005]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13022]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13026]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[13030]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13037]);
	glDrawElements(GL_TRIANGLE_STRIP, 27, GL_UNSIGNED_INT, &Indices[13041]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13068]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[13072]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13084]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13088]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[13092]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13103]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13107]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13111]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[13115]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[13122]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[13134]);
	glDrawElements(GL_TRIANGLE_STRIP, 32, GL_UNSIGNED_INT, &Indices[13145]);
	glDrawElements(GL_TRIANGLE_STRIP, 31, GL_UNSIGNED_INT, &Indices[13177]);
	glDrawElements(GL_TRIANGLE_STRIP, 17, GL_UNSIGNED_INT, &Indices[13208]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[13225]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13235]);

	// Material attributes for surface 'Material'
	cartoonguy_Material_Parameters(128.000f, 0.000000f, 0.000000f, 0.000000f, 0.200000f, 0.200000f, 0.200000f);

	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[13239]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[13254]);

	// Material attributes for surface 'EyeWhite'
	cartoonguy_Material_Parameters(128.000f, 0.200000f, 0.200000f, 0.200000f, 0.200000f, 0.200000f, 0.200000f);

	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[13266]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13269]);
	glDrawElements(GL_TRIANGLE_STRIP, 14, GL_UNSIGNED_INT, &Indices[13275]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13289]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[13293]);
	glDrawElements(GL_TRIANGLE_STRIP, 89, GL_UNSIGNED_INT, &Indices[13296]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[13385]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[13388]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[13398]);
	glDrawElements(GL_TRIANGLE_STRIP, 21, GL_UNSIGNED_INT, &Indices[13404]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[13425]);
	glDrawElements(GL_TRIANGLE_STRIP, 49, GL_UNSIGNED_INT, &Indices[13431]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[13480]);
	glDrawElements(GL_TRIANGLES, 15, GL_UNSIGNED_INT, &Indices[13491]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[13506]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[13511]);
	glDrawElements(GL_TRIANGLE_STRIP, 46, GL_UNSIGNED_INT, &Indices[13514]);
	glDrawElements(GL_TRIANGLE_STRIP, 14, GL_UNSIGNED_INT, &Indices[13560]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[13574]);
	glDrawElements(GL_TRIANGLE_STRIP, 36, GL_UNSIGNED_INT, &Indices[13577]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[13613]);
	glDrawElements(GL_TRIANGLE_STRIP, 22, GL_UNSIGNED_INT, &Indices[13618]);
	glDrawElements(GL_TRIANGLE_STRIP, 66, GL_UNSIGNED_INT, &Indices[13640]);
	glDrawElements(GL_TRIANGLE_STRIP, 16, GL_UNSIGNED_INT, &Indices[13706]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[13722]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13735]);
	glDrawElements(GL_TRIANGLES, 9, GL_UNSIGNED_INT, &Indices[13741]);
	glDrawElements(GL_TRIANGLE_STRIP, 33, GL_UNSIGNED_INT, &Indices[13750]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13783]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[13789]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[13792]);
	glDrawElements(GL_TRIANGLES, 15, GL_UNSIGNED_INT, &Indices[13800]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[13815]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[13820]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[13823]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[13828]);
	glDrawElements(GL_TRIANGLE_STRIP, 32, GL_UNSIGNED_INT, &Indices[13834]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[13866]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[13869]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[13874]);
	glDrawElements(GL_TRIANGLE_STRIP, 23, GL_UNSIGNED_INT, &Indices[13887]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13910]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[13914]);
	glDrawElements(GL_TRIANGLES, 9, GL_UNSIGNED_INT, &Indices[13918]);
	glDrawElements(GL_TRIANGLE_STRIP, 61, GL_UNSIGNED_INT, &Indices[13927]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[13988]);
	glDrawElements(GL_TRIANGLE_STRIP, 30, GL_UNSIGNED_INT, &Indices[13996]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[14026]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[14032]);
	glDrawElements(GL_TRIANGLE_STRIP, 26, GL_UNSIGNED_INT, &Indices[14045]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[14071]);
	glDrawElements(GL_TRIANGLES, 9, GL_UNSIGNED_INT, &Indices[14078]);
	glDrawElements(GL_TRIANGLE_STRIP, 41, GL_UNSIGNED_INT, &Indices[14087]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[14128]);
	glDrawElements(GL_TRIANGLE_STRIP, 93, GL_UNSIGNED_INT, &Indices[14131]);
	glDrawElements(GL_TRIANGLE_STRIP, 106, GL_UNSIGNED_INT, &Indices[14224]);
	glDrawElements(GL_TRIANGLE_STRIP, 109, GL_UNSIGNED_INT, &Indices[14330]);
	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[14439]);
	glDrawElements(GL_TRIANGLE_STRIP, 195, GL_UNSIGNED_INT, &Indices[14454]);
	glDrawElements(GL_TRIANGLE_STRIP, 66, GL_UNSIGNED_INT, &Indices[14649]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[14715]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[14721]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[14730]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[14736]);
	glDrawElements(GL_TRIANGLE_STRIP, 16, GL_UNSIGNED_INT, &Indices[14745]);
	glDrawElements(GL_TRIANGLE_STRIP, 7, GL_UNSIGNED_INT, &Indices[14761]);
	glDrawElements(GL_TRIANGLE_STRIP, 31, GL_UNSIGNED_INT, &Indices[14768]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[14799]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[14802]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[14815]);
	glDrawElements(GL_TRIANGLE_STRIP, 48, GL_UNSIGNED_INT, &Indices[14821]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[14869]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[14874]);
	glDrawElements(GL_TRIANGLE_STRIP, 8, GL_UNSIGNED_INT, &Indices[14877]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[14885]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[14888]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[14899]);
	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[14902]);
	glDrawElements(GL_TRIANGLE_STRIP, 25, GL_UNSIGNED_INT, &Indices[14917]);
	glDrawElements(GL_TRIANGLE_STRIP, 100, GL_UNSIGNED_INT, &Indices[14942]);
	glDrawElements(GL_TRIANGLE_STRIP, 18, GL_UNSIGNED_INT, &Indices[15042]);
	glDrawElements(GL_TRIANGLE_STRIP, 103, GL_UNSIGNED_INT, &Indices[15060]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[15163]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[15168]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[15177]);
	glDrawElements(GL_TRIANGLE_STRIP, 34, GL_UNSIGNED_INT, &Indices[15183]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[15217]);
	glDrawElements(GL_TRIANGLE_STRIP, 15, GL_UNSIGNED_INT, &Indices[15220]);
	glDrawElements(GL_TRIANGLES, 51, GL_UNSIGNED_INT, &Indices[15235]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[15286]);
	glDrawElements(GL_TRIANGLES, 12, GL_UNSIGNED_INT, &Indices[15299]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[15311]);
	glDrawElements(GL_TRIANGLE_STRIP, 44, GL_UNSIGNED_INT, &Indices[15317]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[15361]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[15367]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[15371]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[15384]);
	glDrawElements(GL_TRIANGLE_STRIP, 35, GL_UNSIGNED_INT, &Indices[15389]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[15424]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[15427]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[15431]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[15443]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[15446]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[15455]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[15459]);
	glDrawElements(GL_TRIANGLE_STRIP, 54, GL_UNSIGNED_INT, &Indices[15470]);
	glDrawElements(GL_TRIANGLE_STRIP, 24, GL_UNSIGNED_INT, &Indices[15524]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[15548]);
	glDrawElements(GL_TRIANGLE_STRIP, 10, GL_UNSIGNED_INT, &Indices[15558]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[15568]);
	glDrawElements(GL_TRIANGLES, 12, GL_UNSIGNED_INT, &Indices[15572]);
	glDrawElements(GL_TRIANGLE_STRIP, 22, GL_UNSIGNED_INT, &Indices[15584]);
	glDrawElements(GL_TRIANGLE_STRIP, 9, GL_UNSIGNED_INT, &Indices[15606]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[15615]);
	glDrawElements(GL_TRIANGLE_STRIP, 19, GL_UNSIGNED_INT, &Indices[15618]);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, &Indices[15637]);
	glDrawElements(GL_TRIANGLE_STRIP, 13, GL_UNSIGNED_INT, &Indices[15643]);
	glDrawElements(GL_TRIANGLE_STRIP, 11, GL_UNSIGNED_INT, &Indices[15656]);
	glDrawElements(GL_TRIANGLE_STRIP, 17, GL_UNSIGNED_INT, &Indices[15667]);
}	// End of polygons for object 'cartoonguy'
