/******************************************************************************
 * This file is part of MPlayer Audio Visualization.                          *
 *                                                                            *
 *                                                                            *
 *  MPlayer Audio Visualization is free software; you can redistribute it     *
 *  and/or modify it under the terms of the GNU General Public License as     *
 *  published by the Free Software Foundation; either version 2 of the        *
 *  License, or (at your option) any later version.                           *
 *                                                                            *
 *  MPlayer Audio Visualization is distributed in the hope that it will be    *
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General *
 *  Public License for more details.                                          *
 *                                                                            * 
 *  You should have received a copy of the GNU General Public License         *
 *  along with MPlayer Audio Visualization; if not, write to the Free         *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA         *
 *  02111-1307  USA                                                           *
 ******************************************************************************/
#ifndef _H_RENDER_
#define _H_RENDER_

/* Common area */

#include <config.h>
#include <inttypes.h>


/* Global Functions */

/**
 * Init data render. It will launch a thread that render data to the screen
 *
 * @return 0 on success, -1 otherwise
 */
int render_init();

/**
 * Stop the render thread and clean up things.
 */
void render_quit();

/**
 * Change render resolution to the same as screen resolution
 * 
 * @return 0 on success.
 */
int render_change_resolution();

/**
 * Do the render
 *
 * @return 0 if nothing was rendered, 1 if something was.
 */
int render_func();


typedef struct plugin_render_s {
  char     *name;
  void     *p;
  int      (*init)( int width, int height );
  void     (*quit)();
  int      (*set_resolution)( int width, int height );
  uint32_t *(*render)( int16_t data[ 2 ][ 512 ] );
} plugin_render_t;


#ifndef _C_RENDER_

/*
 * Global Area
 */

/* Global Vars */
extern plugin_render_t plugin_render;      /**< plugin (dl) used to render screns */

#else // _C_RENDER_

/*
 * Local Area: use only in render.c 
 */

#include <SDL.h>
#include <SDL/SDL_thread.h>
#include <unistd.h>
#include <sys/time.h>
#include <fastmemcpy.h>
#include <screen.h>
#include <data_import.h>
#include <errno.h>
#include <mpav.h>
#include <dlfcn.h>

/* Local Vars */
static int __width = 0; /**< remember last screen size */
static int __height = 0; /**< remember last screen size */
plugin_render_t plugin_render = { NULL, NULL, NULL, NULL, NULL, NULL };

#endif // _C_RENDER_

#endif // _H_RENDER_
