/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphEvent;
import hypergraph.graphApi.Node;
import hypergraph.hyperbolic.Complex;
import hypergraph.hyperbolic.ComplexVector;
import hypergraph.hyperbolic.Isometry;
import hypergraph.hyperbolic.Model;
import hypergraph.hyperbolic.PoincareModel;
import hypergraph.hyperbolic.PropertyManager;
import hypergraph.visualnet.DefaultGraphLayoutModel;
import hypergraph.visualnet.ForceDirectedWeight;
import hypergraph.visualnet.IteratingGraphLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GenericMDSLayout
extends IteratingGraphLayout {
    NodeIndex nodeIndex;
    Complex[] nodePositions;
    Complex[] tempPositions;
    ComplexVector[] gradient;
    ComplexVector[] previousGradient;
    double[][] distances;
    private double stepWidth = 1.0;
    private double gradientNorm2 = 0.0;
    private double previousGradientNorm2 = 0.0;
    private double energy = 0.0;
    private double lastEnergy = 0.0;
    private Complex z1 = new Complex();
    private Complex z2 = new Complex();
    private Complex z3 = new Complex();
    private Complex z4 = new Complex();
    private static final Complex zero = new Complex();
    private ComplexVector v1 = new ComplexVector();
    private ComplexVector v2 = new ComplexVector();
    private Isometry isom1;
    private MDSWeight weight;

    public GenericMDSLayout(MDSWeight mDSWeight, Model model, Graph graph, PropertyManager propertyManager) {
        this.setModel(model);
        this.setProperties(propertyManager);
        if (mDSWeight == null) {
            mDSWeight = new ForceDirectedWeight();
            Double d = this.getProperties().getDouble("visualnet.GenericMDSLayout.repulsingForce", new Double(0.01));
            ((ForceDirectedWeight)mDSWeight).setRepulsingForce(d);
            d = this.getProperties().getDouble("visualnet.GenericMDSLayout.repulsingForceCutOff", new Double(100.0));
            ((ForceDirectedWeight)mDSWeight).setRepulsingForceCutOff(d);
            d = this.getProperties().getDouble("visualnet.GenericMDSLayout.connectedDisparity", new Double(0.2));
            ((ForceDirectedWeight)mDSWeight).setConnectedDisparity(d);
        }
        this.weight = mDSWeight;
        this.setGraph(graph);
    }

    public void setGraph(Graph graph) {
        this.weight.setGraph(graph);
        this.nodeIndex = new NodeIndex(graph);
        super.setGraph(graph);
    }

    public Graph getGraph() {
        return super.getGraph();
    }

    public void setWeight(MDSWeight mDSWeight) {
        this.weight = mDSWeight;
    }

    private Complex getBarycenter(Node node) {
        Complex complex = new Complex();
        double d = 0.0;
        Iterator iterator = this.getGraph().getEdges(node).iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            complex.add((Complex)this.getGraphLayoutModel().getNodePosition(edge.getOtherNode(node)));
            d += 1.0;
        }
        if (d == 0.0) {
            return (Complex)this.getGraphLayoutModel().getNodePosition(node);
        }
        complex.multiply(1.0 / d);
        return complex;
    }

    private void translateRandomly(Complex[] complexArray, int n) {
        this.translateRandomly(complexArray[n], 0.01, 0.05);
    }

    private void translateRandomly(Complex complex, double d, double d2) {
        double d3 = Math.PI * 2 * Math.random();
        double d4 = d + (d2 - d) * Math.random();
        ComplexVector complexVector = new ComplexVector();
        complexVector.setBase(complex);
        complexVector.v.setReal(d4 * Math.cos(d3));
        complexVector.v.setImag(d4 * Math.sin(d3));
        Isometry isometry = this.getModel().getTranslation(complexVector, d4);
        isometry.apply(complex);
    }

    public synchronized void elementsAdded(GraphEvent graphEvent) {
        Object object;
        if (graphEvent.getElement().getElementType() == 1) {
            object = new Complex[this.getGraph().getNodes().size()];
            for (int i = 0; i < this.nodePositions.length; ++i) {
                object[i] = this.nodePositions[i];
            }
            object[this.nodePositions.length] = new Complex();
            this.translateRandomly((Complex)object[this.nodePositions.length], 0.1, 1.0);
            this.nodePositions = object;
            this.nodeIndex.addNode((Node)graphEvent.getElement());
        }
        if (graphEvent.getElement().getElementType() == 2) {
            object = (Edge)graphEvent.getElement();
            Node node = object.getSource();
            if (this.getGraph().getEdges(node).size() != 1) {
                node = object.getTarget();
                if (this.getGraph().getEdges(node).size() != 1) {
                    return;
                }
            }
            int n = this.nodeIndex.getIndex(node);
            int n2 = this.nodeIndex.getIndex(object.getOtherNode(node));
            this.nodePositions[n].setTo(this.nodePositions[n2]);
            this.translateRandomly(this.nodePositions[n], 0.01, 0.05);
        }
        this.invalidate();
    }

    public synchronized void elementsRemoved(GraphEvent graphEvent) {
        if (graphEvent.getElement().getElementType() == 1) {
            NodeIndex nodeIndex = new NodeIndex(this.getGraph());
            Complex[] complexArray = new Complex[this.getGraph().getNodes().size()];
            Iterator iterator = this.getGraph().getNodes().iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                int n = this.nodeIndex.getIndex(node);
                int n2 = nodeIndex.getIndex(node);
                complexArray[n2] = this.nodePositions[n];
            }
            this.nodePositions = complexArray;
            this.nodeIndex = nodeIndex;
        }
        this.invalidate();
    }

    public void invalidate() {
        super.invalidate();
        this.distances = null;
        this.gradient = null;
        this.previousGradient = null;
        this.tempPositions = null;
        this.stepWidth = 0.05;
    }

    public void initializeRandomly(Complex[] complexArray) {
        Iterator iterator = this.getGraph().getNodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Complex complex = new Complex();
            this.translateRandomly(complex, 0.0, 5.0);
            complexArray[this.nodeIndex.getIndex((Node)node)] = complex;
        }
    }

    private void setLayoutModelPositions(Complex[] complexArray) {
        for (int i = 0; i < complexArray.length; ++i) {
            this.getGraphLayoutModel().setNodePosition(this.nodeIndex.getNode(i), complexArray[i]);
        }
    }

    private double getEnergy(double[][] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.nodeIndex.getSize(); ++i) {
            for (int j = i + 1; j < this.nodeIndex.getSize(); ++j) {
                d += this.weight.getWeight(this.nodeIndex.getNode(j), this.nodeIndex.getNode(i), this.getDistance(i, j));
            }
        }
        return d;
    }

    private void computeDistances(Complex[] complexArray) {
        for (int i = 0; i < this.nodeIndex.getSize(); ++i) {
            for (int j = i + 1; j < this.nodeIndex.getSize(); ++j) {
                this.distances[i][j] = ((PoincareModel)this.getModel()).dist(complexArray[i], complexArray[j]);
            }
        }
    }

    private double getDistance(int n, int n2) {
        if (n2 < n) {
            return this.distances[n2][n];
        }
        return this.distances[n][n2];
    }

    private double computeGradient(Complex[] complexArray, ComplexVector[] complexVectorArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.nodeIndex.getSize(); ++i) {
            complexVectorArray[i].scale(0.0);
            for (int j = 0; j < this.nodeIndex.getSize(); ++j) {
                double d3;
                if (i == j || !(Math.abs(d3 = this.weight.getWeightDerivative(this.nodeIndex.getNode(i), this.nodeIndex.getNode(j), this.getDistance(j, i))) > 0.001)) continue;
                this.getModel().distanceGradient(complexArray[i], complexArray[j], this.v1);
                this.v1.v.multiply(d3);
                complexVectorArray[i].v.add(this.v1.v);
            }
            d2 = this.getModel().length2(complexVectorArray[i]);
            d += d2;
        }
        return d;
    }

    protected void iteration(IteratingGraphLayout.IterationThread iterationThread) {
        int n;
        if (this.getGraph().getNodes().size() == 0) {
            iterationThread.stopIterating();
            return;
        }
        if (this.isom1 == null) {
            this.isom1 = this.getModel().getIdentity();
        }
        if (this.gradient == null) {
            this.gradient = new ComplexVector[this.nodeIndex.getSize()];
            for (n = 0; n < this.nodeIndex.getSize(); ++n) {
                this.gradient[n] = new ComplexVector(this.nodePositions[n], new Complex());
            }
        }
        if (this.tempPositions == null) {
            this.tempPositions = new Complex[this.nodeIndex.getSize()];
            for (n = 0; n < this.nodeIndex.getSize(); ++n) {
                this.tempPositions[n] = new Complex();
            }
        }
        if (this.distances == null) {
            this.distances = new double[this.nodeIndex.getSize()][this.nodeIndex.getSize()];
        }
        for (n = 0; n < 10; ++n) {
            this.computeDistances(this.nodePositions);
            this.gradientNorm2 = this.computeGradient(this.nodePositions, this.gradient);
            if (this.previousGradient == null) {
                this.previousGradient = new ComplexVector[this.nodeIndex.getSize()];
                for (int i = 0; i < this.nodeIndex.getSize(); ++i) {
                    this.previousGradient[i] = (ComplexVector)this.gradient[i].clone();
                }
                this.previousGradientNorm2 = this.gradientNorm2;
            }
            double d = 0.0;
            for (int i = 0; i < this.gradient.length; ++i) {
                d += this.getModel().product(this.gradient[i], this.previousGradient[i]);
            }
            double d2 = d / Math.sqrt(this.gradientNorm2 * this.previousGradientNorm2);
            this.stepWidth = d2 > 0.9 ? (this.stepWidth *= 1.1) : (d2 > 0.8 ? (this.stepWidth *= 1.05) : (d2 > 0.5 ? (this.stepWidth *= 1.0) : (d2 > 0.3 ? (this.stepWidth *= 0.7) : (d2 > 0.2 ? (this.stepWidth *= 0.4) : (d2 > 0.1 ? (this.stepWidth *= 0.2) : (this.stepWidth *= 0.1))))));
            if (this.stepWidth < 1.0E-9) {
                iterationThread.stopIterating();
            }
            for (int i = 0; i < this.nodeIndex.getSize(); ++i) {
                double d3 = this.stepWidth * this.getModel().length(this.gradient[i]);
                if (d3 > 0.2) {
                    d3 = 0.2;
                }
                this.tempPositions[i].setTo(this.nodePositions[i]);
                this.getModel().getTranslation(this.isom1, this.gradient[i], -d3);
                this.isom1.apply(this.tempPositions[i]);
                this.isom1.apply(this.gradient[i]);
                this.previousGradient[i].setTo(this.gradient[i]);
                this.nodePositions[i].setTo(this.tempPositions[i]);
            }
            this.energy = this.getEnergy(this.distances);
            if (this.energy < 0.01 || Math.abs((this.energy - this.lastEnergy) / this.energy) < 1.0E-9) {
                iterationThread.stopIterating();
            }
            this.previousGradientNorm2 = this.gradientNorm2;
            this.lastEnergy = this.energy;
        }
        this.setLayoutModelPositions(this.nodePositions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void layout() {
        Graph graph = this.getGraph();
        synchronized (graph) {
            if (this.getGraphLayoutModel() == null) {
                this.setGraphLayoutModel(new DefaultGraphLayoutModel());
            }
            if (this.nodePositions == null) {
                this.nodePositions = new Complex[this.nodeIndex.getSize()];
                this.initializeRandomly(this.nodePositions);
                this.setLayoutModelPositions(this.nodePositions);
            }
            super.layout();
        }
    }

    public boolean isExpandingEnabled() {
        return false;
    }

    public static interface MDSWeight {
        public void setGraph(Graph var1);

        public double getWeight(Node var1);

        public double getWeight(Node var1, Node var2, double var3);

        public double getWeightDerivative(Node var1, Node var2, double var3);
    }

    public static class NodeIndex {
        private List list;
        private Map map;
        private Graph graph;

        NodeIndex(Graph graph) {
            this.graph = graph;
            this.buildIndex();
        }

        void buildIndex() {
            this.list = new ArrayList();
            this.map = new HashMap();
            int n = 0;
            Iterator iterator = this.graph.getNodes().iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                this.list.add(node);
                this.map.put(node, new Integer(n));
                ++n;
            }
        }

        void addNode(Node node) {
            this.list.add(node);
            this.map.put(node, new Integer(this.list.size() - 1));
        }

        void removeNode(Node node) {
            this.buildIndex();
        }

        int getSize() {
            return this.list.size();
        }

        int getIndex(Node node) {
            Integer n = (Integer)this.map.get(node);
            if (n == null) {
                return -1;
            }
            return n;
        }

        Node getNode(int n) {
            return (Node)this.list.get(n);
        }
    }
}

