/*
 * Copyright (C) 2007  Enrico Zini <enrico@debian.org>
 * Copyright (C) 2007  Miriam Ruiz <little_miry@yahoo.es>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _games_common_h
#define _games_common_h

#include "config.h"

#ifdef USE_GETTEXT
#include <libintl.h>
#define _(String) gettext (String)
#else
#define _(String) String
#endif

#ifndef DATADIR
#define DATADIR "/usr/share/goplay"
#endif

#ifndef HTMLDIR
#define HTMLDIR DATADIR "/html"
#endif

#ifndef FILE_NO_SCREENSHOT
#define FILE_NO_SCREENSHOT DATADIR "/no_screenshot.png"
#endif

#ifndef FILE_STARS_ON
#define FILE_STARS_ON DATADIR "/stars_on.png"
#endif

#ifndef FILE_STARS_OFF
#define FILE_STARS_OFF DATADIR "/stars_off.png"
#endif

#ifndef FILE_PEOPLE_ON
#define FILE_PEOPLE_ON DATADIR "/people_on.png"
#endif

#ifndef FILE_PEOPLE_OFF
#define FILE_PEOPLE_OFF DATADIR "/people_off.png"
#endif

#ifndef THUMBNAILSDIR
#define THUMBNAILSDIR "/usr/share/games/thumbnails"
#endif

#include <stdlib.h>
#include <stdio.h>

#define ERROR_PRINTF(...) { fprintf(stderr, "%s:%s:%u Error: ", __FILE__, __PRETTY_FUNCTION__, __LINE__); fprintf(stderr,__VA_ARGS__); fflush(stderr); }

#endif
