/*
   Copyright 2014-now by Alain Stalder. Made in Switzerland.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       https://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package ch.artecat.grengine.source;

import java.net.URL;

import static java.util.Objects.requireNonNull;


/**
 * URL-based script source with content considered static,
 * default implementation of the {@link UrlSource} interface.
 * <p>
 * The ID is the URL as a string.
 * <p>
 * The method {@link #getLastModified()} always returns 0.
 * 
 * @since 1.0
 * 
 * @author Alain Stalder
 * @author Made in Switzerland.
 */
public class DefaultUrlSource extends BaseSource implements UrlSource {
    
    private final URL url;
    
    /**
     * constructor from URL.
     *
     * @param url URL
     *
     * @throws NullPointerException if URL is null
     * 
     * @since 1.0
     */
    public DefaultUrlSource(final URL url) {
        requireNonNull(url, "URL is null.");
        id = url.toString();
        this.url = url;
    }
    
    @Override
    public URL getUrl() {
        return url;
    }

}
