/*
 *  gstvaapiutils_core.h - VA-API utilities (Core, MT-safe)
 *
 *  Copyright (C) 2010-2011 Splitted-Desktop Systems
 *    Author: Gwenole Beauchesne <gwenole.beauchesne@splitted-desktop.com>
 *  Copyright (C) 2011-2013 Intel Corporation
 *    Author: Gwenole Beauchesne <gwenole.beauchesne@intel.com>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301 USA
 */

#ifndef GST_VAAPI_UTILS_CORE_H
#define GST_VAAPI_UTILS_CORE_H

#include <gst/vaapi/gstvaapidisplay.h>

G_BEGIN_DECLS

/* Gets attribute value for the supplied profile/entrypoint pair (MT-safe) */
G_GNUC_INTERNAL
gboolean
gst_vaapi_get_config_attribute (GstVaapiDisplay * display, VAProfile profile,
    VAEntrypoint entrypoint, VAConfigAttribType type, guint * out_value_ptr);

/* Gets the available GstVideoFormats of a surface in a VAConfig */
G_GNUC_INTERNAL
GArray *
gst_vaapi_get_surface_formats (GstVaapiDisplay * display, VAConfigID config);

G_END_DECLS

#endif /* GST_VAAPI_UTILS_CORE_H */
