# maps_marker.py
#
# Copyright 2024 Christopher Talbot
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

from gi.repository import Adw
from gi.repository import Gtk
from gi.repository import Gdk
from gi.repository import Shumate

@Gtk.Template(resource_path='/org/kop316/meshtastic/ui/maps_marker.ui')
class NodeMarker(Shumate.Marker):
    __gtype_name__ = 'NodeMarker'

    marker_image = Gtk.Template.Child()
    marker_label = Gtk.Template.Child()
    marker_long_name_label = Gtk.Template.Child()
    marker_last_heard_label = Gtk.Template.Child()
    marker_hops_away_label = Gtk.Template.Child()
    popover = Gtk.Template.Child()

    def set_marker_hops_away_label(self, text):
        self.marker_hops_away_label.set_label(text)

    def set_marker_long_name_label(self, text):
        self.marker_long_name_label.set_label(text)

    def set_marker_last_heard_label(self, text):
        self.marker_last_heard_label.set_label(text)

    def set_marker_label(self, text):
        text = "<span foreground=\"black\" size=\"medium\"><b>" + str(text) + "</b></span>"

        self.marker_label.set_markup(text)

    def primary_button_clicked_cb(self, gesture, n_press, x, y, primary_button_gesture):
        primary_button_gesture.set_state(Gtk.EventSequenceState.CLAIMED)
        self.popover.show()

    def long_pressed_cb(self, gesture, x, y, long_press_gesture):
        long_press_gesture.set_state(Gtk.EventSequenceState.CLAIMED)
        self.popover.show()

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        app = Gtk.Application.get_default()
        self.logger = app.logger

        primary_button_gesture = Gtk.GestureClick(button=Gdk.BUTTON_PRIMARY)
        primary_button_gesture.connect("released", self.primary_button_clicked_cb, primary_button_gesture)
        self.add_controller(primary_button_gesture)

        self.popover.set_parent(self.marker_image)
