/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.util.concurrent;
public class FuturesTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.util.concurrent.testModule";
}
public void testAllAsList() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_cancelled() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_cancelled();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_doneFutures() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_doneFutures();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_emptyArray() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_emptyArray();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_failure() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_failure();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_logging_error() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_logging_error();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_logging_exception() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_logging_exception();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_logging_multipleExceptions_alreadyDone() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_logging_multipleExceptions_alreadyDone();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_logging_multipleExceptions_doneLater() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_logging_multipleExceptions_doneLater();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_logging_same_cause() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_logging_same_cause();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_logging_same_exception() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_logging_same_exception();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_logging_seenExceptionUpdateCancelRace() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_logging_seenExceptionUpdateCancelRace();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_logging_seenExceptionUpdateRace() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_logging_seenExceptionUpdateRace();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_resultCancelled() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_resultCancelled();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_resultCancelledInterrupted_withSecondaryListFuture() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_resultCancelledInterrupted_withSecondaryListFuture();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_resultCancelled_withSecondaryListFuture() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_resultCancelled_withSecondaryListFuture();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testAllAsList_resultInterrupted() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testAllAsList_resultInterrupted();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatchingAsync_Throwable() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatchingAsync_Throwable();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatchingAsync_fallbackGeneratesCheckedException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatchingAsync_fallbackGeneratesCheckedException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatchingAsync_fallbackGeneratesError() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatchingAsync_fallbackGeneratesError();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatchingAsync_fallbackGeneratesRuntimeException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatchingAsync_fallbackGeneratesRuntimeException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatchingAsync_fallbackNotReady() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatchingAsync_fallbackNotReady();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatchingAsync_fallbackReturnsCheckedException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatchingAsync_fallbackReturnsCheckedException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatchingAsync_fallbackReturnsRuntimeException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatchingAsync_fallbackReturnsRuntimeException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatchingAsync_inputDoesNotRaiseException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatchingAsync_inputDoesNotRaiseException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatchingAsync_inputRaisesException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatchingAsync_inputRaisesException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatchingAsync_nullInsteadOfFuture() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatchingAsync_nullInsteadOfFuture();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatchingAsync_resultCancelledBeforeFallback() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatchingAsync_resultCancelledBeforeFallback();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatchingAsync_resultInterruptedBeforeFallback() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatchingAsync_resultInterruptedBeforeFallback();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatching_Throwable() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatching_Throwable();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatching_fallbackGeneratesError() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatching_fallbackGeneratesError();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatching_fallbackGeneratesRuntimeException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatching_fallbackGeneratesRuntimeException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatching_inputDoesNotRaiseException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatching_inputDoesNotRaiseException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatching_inputRaisesException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatching_inputRaisesException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatching_resultCancelledBeforeFallback() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatching_resultCancelledBeforeFallback();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testCatching_resultInterruptedBeforeFallback() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testCatching_resultInterruptedBeforeFallback();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testDereference_genericsHierarchy() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testDereference_genericsHierarchy();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testDereference_genericsWildcard() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testDereference_genericsWildcard();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testDereference_innerCancelsResult() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testDereference_innerCancelsResult();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testDereference_outerCancelsResult() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testDereference_outerCancelsResult();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testDereference_resultCancelsInner() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testDereference_resultCancelsInner();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testDereference_resultCancelsOuter() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testDereference_resultCancelsOuter();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testImmediateFailedFuture() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testImmediateFailedFuture();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testImmediateFailedFuture_cancellationException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testImmediateFailedFuture_cancellationException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testImmediateFuture() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testImmediateFuture();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testMultipleImmediateFutures() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testMultipleImmediateFutures();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testSuccessfulAsList_logging_error() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testSuccessfulAsList_logging_error();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testSuccessfulAsList_logging_exception() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testSuccessfulAsList_logging_exception();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransformAsync_asyncFunction_error() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransformAsync_asyncFunction_error();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransformAsync_asyncFunction_nullInsteadOfFuture() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransformAsync_asyncFunction_nullInsteadOfFuture();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransformAsync_cancelPropagatesToAsyncOutput() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransformAsync_cancelPropagatesToAsyncOutput();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransformAsync_cancelPropagatesToInput() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransformAsync_cancelPropagatesToInput();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransformAsync_genericsHierarchy_AsyncFunction() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransformAsync_genericsHierarchy_AsyncFunction();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransformAsync_genericsWildcard_AsyncFunction() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransformAsync_genericsWildcard_AsyncFunction();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransformAsync_interruptPropagatesToAsyncOutput() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransformAsync_interruptPropagatesToAsyncOutput();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransformAsync_interruptPropagatesToInput() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransformAsync_interruptPropagatesToInput();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransformValueRemainsMemoized() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransformValueRemainsMemoized();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransform_Executor() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransform_Executor();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransform_asyncFunction_error() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransform_asyncFunction_error();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransform_asyncFunction_nullInsteadOfFuture() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransform_asyncFunction_nullInsteadOfFuture();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransform_cancelPropagatesToAsyncOutput() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransform_cancelPropagatesToAsyncOutput();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransform_cancelPropagatesToInput() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransform_cancelPropagatesToInput();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransform_genericsHierarchy() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransform_genericsHierarchy();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransform_genericsHierarchy_AsyncFunction() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransform_genericsHierarchy_AsyncFunction();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransform_genericsNull() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransform_genericsNull();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransform_genericsWildcard_AsyncFunction() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransform_genericsWildcard_AsyncFunction();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransform_interruptPropagatesToAsyncOutput() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransform_interruptPropagatesToAsyncOutput();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testTransform_interruptPropagatesToInput() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testTransform_interruptPropagatesToInput();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testWithFallback_fallbackGeneratesCheckedException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testWithFallback_fallbackGeneratesCheckedException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testWithFallback_fallbackGeneratesError() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testWithFallback_fallbackGeneratesError();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testWithFallback_fallbackGeneratesRuntimeException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testWithFallback_fallbackGeneratesRuntimeException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testWithFallback_fallbackNotReady() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testWithFallback_fallbackNotReady();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testWithFallback_fallbackReturnsCheckedException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testWithFallback_fallbackReturnsCheckedException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testWithFallback_fallbackReturnsRuntimeException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testWithFallback_fallbackReturnsRuntimeException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testWithFallback_inputDoesNotRaiseException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testWithFallback_inputDoesNotRaiseException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testWithFallback_inputRaisesException() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testWithFallback_inputRaisesException();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testWithFallback_nullInsteadOfFuture() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testWithFallback_nullInsteadOfFuture();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testWithFallback_resultCancelledBeforeFallback() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testWithFallback_resultCancelledBeforeFallback();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}

public void testWithFallback_resultInterruptedBeforeFallback() throws Exception {
  com.google.common.util.concurrent.FuturesTest testCase = new com.google.common.util.concurrent.FuturesTest();
  testCase.setUp();
  Throwable failure = null;
  try {
    testCase.testWithFallback_resultInterruptedBeforeFallback();
  } catch (Throwable t) {
    failure = t;
  }
  try {
    testCase.tearDown();
  } catch (Throwable t) {
    if (failure == null) {
      failure = t;
    }
  }
  if (failure instanceof Exception) {
    throw (Exception) failure;
  }
  if (failure instanceof Error) {
    throw (Error) failure;
  }
  if (failure != null) {
    throw new RuntimeException(failure);
  }
}
}
