#ifndef SPLICE_SITE_MEM_H_
#define SPLICE_SITE_MEM_H_

static const float background_bp_prob[4] = {0.27f, 0.23f, 0.23f, 0.27f};
static const float donor_cons1[4] = {0.004f, 0.0032f, 0.9896f, 0.0032f};
static const float donor_cons2[4] = {0.0034f, 0.0039f, 0.0042f, 0.9884f};
static const float acceptor_cons1[4] = {0.9903f, 0.0032f, 0.0034f, 0.0030f};
static const float acceptor_cons2[4] = {0.0027f, 0.0037f, 0.9905f, 0.0030f};

static const float donor_me2x5[16384] = {
0.143596f, 0.204157f, 0.192979f, 1.061763f, 0.231687f, 0.483900f, 0.466345f, 1.279266f, 7.648993f, 10.067296f, 6.140895f, 53.603145f, 0.119893f, 0.098323f, 0.141841f, 0.789030f,
0.017593f, 0.048968f, 0.034133f, 0.188161f, 0.040230f, 0.164498f, 0.116904f, 0.321303f, 1.594035f, 4.107312f, 1.847533f, 16.157861f, 0.022057f, 0.035412f, 0.037672f, 0.209963f,
0.007744f, 0.021649f, 0.006671f, 0.075685f, 0.008285f, 0.034023f, 0.010689f, 0.060461f, 0.786409f, 2.035123f, 0.404707f, 7.283977f, 0.003849f, 0.006207f, 0.002919f, 0.033480f,
0.019657f, 0.048412f, 0.030548f, 0.172960f, 0.023873f, 0.086370f, 0.055565f, 0.156854f, 0.930388f, 2.121214f, 0.863749f, 7.758677f, 0.014753f, 0.020958f, 0.020183f, 0.115538f,
0.000036f, 0.000079f, 0.000033f, 0.000718f, 0.000041f, 0.000132f, 0.000057f, 0.000609f, 0.013171f, 0.027007f, 0.007361f, 0.251065f, 0.000045f, 0.000058f, 0.000037f, 0.000809f,
0.000001f, 0.000004f, 0.000001f, 0.000026f, 0.000001f, 0.000009f, 0.000003f, 0.000032f, 0.000570f, 0.002290f, 0.000460f, 0.015726f, 0.000002f, 0.000004f, 0.000002f, 0.000045f,
0.000001f, 0.000005f, 0.000001f, 0.000029f, 0.000001f, 0.000005f, 0.000001f, 0.000016f, 0.000759f, 0.003059f, 0.000272f, 0.019118f, 0.000001f, 0.000002f, 0.000000f, 0.000019f,
0.000002f, 0.000009f, 0.000003f, 0.000057f, 0.000002f, 0.000011f, 0.000003f, 0.000036f, 0.000778f, 0.002763f, 0.000503f, 0.017645f, 0.000003f, 0.000006f, 0.000003f, 0.000058f,
0.005656f, 0.019340f, 0.010995f, 0.107534f, 0.010056f, 0.050509f, 0.029277f, 0.142761f, 1.189892f, 3.766273f, 1.381765f, 21.439941f, 0.003482f, 0.006868f, 0.005959f, 0.058922f,
0.000416f, 0.002786f, 0.001168f, 0.011444f, 0.001049f, 0.010311f, 0.004407f, 0.021532f, 0.148908f, 0.922725f, 0.249638f, 3.880905f, 0.000385f, 0.001485f, 0.000950f, 0.009416f,
0.000106f, 0.000710f, 0.000132f, 0.002652f, 0.000124f, 0.001229f, 0.000232f, 0.002335f, 0.042330f, 0.263445f, 0.031510f, 1.008098f, 0.000039f, 0.000150f, 0.000042f, 0.000865f,
0.000125f, 0.000743f, 0.000282f, 0.002838f, 0.000168f, 0.001461f, 0.000565f, 0.002836f, 0.023448f, 0.128565f, 0.031487f, 0.502760f, 0.000069f, 0.000237f, 0.000137f, 0.001398f,
0.000345f, 0.000440f, 0.000464f, 0.010163f, 0.000033f, 0.000062f, 0.000067f, 0.000728f, 0.043093f, 0.050775f, 0.034547f, 1.201494f, 0.000144f, 0.000106f, 0.000171f, 0.003780f,
0.000047f, 0.000117f, 0.000091f, 0.002005f, 0.000006f, 0.000023f, 0.000019f, 0.000204f, 0.009996f, 0.023059f, 0.011570f, 0.403146f, 0.000030f, 0.000042f, 0.000050f, 0.001120f,
0.000029f, 0.000072f, 0.000025f, 0.001123f, 0.000002f, 0.000007f, 0.000002f, 0.000053f, 0.006867f, 0.015910f, 0.003529f, 0.253063f, 0.000007f, 0.000010f, 0.000005f, 0.000249f,
0.000066f, 0.000145f, 0.000102f, 0.002301f, 0.000005f, 0.000015f, 0.000011f, 0.000124f, 0.007286f, 0.014872f, 0.006755f, 0.241743f, 0.000025f, 0.000031f, 0.000034f, 0.000769f,
0.009874f, 0.008446f, 0.012943f, 0.086116f, 1.028860f, 1.292943f, 2.020043f, 6.700973f, 13.092332f, 10.367984f, 10.252782f, 108.224270f, 0.271467f, 0.133951f, 0.313275f, 2.107366f,
0.001717f, 0.002876f, 0.003250f, 0.021663f, 0.253596f, 0.623901f, 0.718808f, 2.389038f, 3.872948f, 6.004407f, 4.378581f, 46.307291f, 0.070892f, 0.068483f, 0.118107f, 0.796016f,
0.000362f, 0.000609f, 0.000304f, 0.004171f, 0.024999f, 0.061770f, 0.031462f, 0.215197f, 0.914634f, 1.424157f, 0.459131f, 9.992836f, 0.005922f, 0.005746f, 0.004381f, 0.060761f,
0.001131f, 0.001676f, 0.001715f, 0.011741f, 0.088727f, 0.193148f, 0.201444f, 0.687660f, 1.332838f, 1.828380f, 1.206975f, 13.110603f, 0.027958f, 0.023897f, 0.037309f, 0.258268f,
0.000014f, 0.000019f, 0.000013f, 0.000342f, 0.001058f, 0.002070f, 0.001445f, 0.018734f, 0.132319f, 0.163239f, 0.072129f, 2.975054f, 0.000601f, 0.000462f, 0.000482f, 0.012681f,
0.000001f, 0.000001f, 0.000001f, 0.000018f, 0.000054f, 0.000208f, 0.000107f, 0.001388f, 0.008134f, 0.019645f, 0.006401f, 0.264521f, 0.000033f, 0.000049f, 0.000038f, 0.000995f,
0.000000f, 0.000001f, 0.000000f, 0.000009f, 0.000014f, 0.000055f, 0.000013f, 0.000337f, 0.005180f, 0.012565f, 0.001810f, 0.153938f, 0.000007f, 0.000011f, 0.000004f, 0.000205f,
0.000001f, 0.000002f, 0.000001f, 0.000023f, 0.000044f, 0.000150f, 0.000070f, 0.000933f, 0.006540f, 0.013977f, 0.004123f, 0.174993f, 0.000030f, 0.000040f, 0.000028f, 0.000755f,
0.000424f, 0.000872f, 0.000804f, 0.009508f, 0.048683f, 0.147128f, 0.138255f, 0.815245f, 2.220356f, 4.228586f, 2.515052f, 47.191117f, 0.008596f, 0.010200f, 0.014348f, 0.171564f,
0.000044f, 0.000178f, 0.000121f, 0.001436f, 0.007206f, 0.042633f, 0.029543f, 0.174538f, 0.394424f, 1.470576f, 0.644992f, 12.125531f, 0.001348f, 0.003131f, 0.003248f, 0.038916f,
0.000005f, 0.000022f, 0.000007f, 0.000159f, 0.000409f, 0.002432f, 0.000745f, 0.009059f, 0.053673f, 0.200983f, 0.038971f, 1.507736f, 0.000065f, 0.000151f, 0.000069f, 0.001712f,
0.000008f, 0.000028f, 0.000017f, 0.000210f, 0.000680f, 0.003561f, 0.002234f, 0.013554f, 0.036620f, 0.120811f, 0.047967f, 0.926186f, 0.000143f, 0.000295f, 0.000277f, 0.003406f,
0.000002f, 0.000001f, 0.000002f, 0.000057f, 0.000010f, 0.000011f, 0.000020f, 0.000264f, 0.005100f, 0.003615f, 0.003988f, 0.167719f, 0.000023f, 0.000010f, 0.000026f, 0.000698f,
0.000000f, 0.000000f, 0.000001f, 0.000016f, 0.000003f, 0.000006f, 0.000008f, 0.000105f, 0.001679f, 0.002331f, 0.001896f, 0.079883f, 0.000007f, 0.000006f, 0.000011f, 0.000293f,
0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000000f, 0.000001f, 0.000000f, 0.000013f, 0.000552f, 0.000770f, 0.000277f, 0.024003f, 0.000001f, 0.000001f, 0.000001f, 0.000031f,
0.000000f, 0.000000f, 0.000000f, 0.000011f, 0.000001f, 0.000002f, 0.000003f, 0.000038f, 0.000722f, 0.000886f, 0.000653f, 0.028243f, 0.000003f, 0.000002f, 0.000004f, 0.000119f,
21.087740f, 17.884734f, 33.983089f, 30.001875f, 30.794886f, 38.367558f, 74.327616f, 32.716865f, 96.319545f, 75.623049f, 92.727039f, 129.877440f, 22.803677f, 11.155706f, 32.350456f, 28.876139f,
7.196053f, 11.948074f, 16.741476f, 14.808539f, 14.893460f, 36.327235f, 51.895990f, 22.886975f, 55.907610f, 85.933372f, 77.701565f, 109.041030f, 11.684721f, 11.190815f, 23.930992f, 21.401897f,
5.105855f, 8.514407f, 5.274309f, 9.601089f, 4.943664f, 12.110663f, 7.648645f, 6.941859f, 44.457961f, 68.631388f, 27.435065f, 79.232364f, 3.286688f, 3.161432f, 2.988811f, 5.500807f,
8.617404f, 12.660210f, 16.058510f, 14.589219f, 9.471986f, 20.442712f, 26.436794f, 11.974895f, 34.973513f, 47.565386f, 38.933860f, 56.117203f, 8.376484f, 7.098487f, 13.741478f, 12.622157f,
0.224340f, 0.296405f, 0.251652f, 0.868142f, 0.230635f, 0.447648f, 0.387487f, 0.666474f, 7.092942f, 8.675464f, 4.753135f, 26.014280f, 0.367579f, 0.280137f, 0.362985f, 1.266052f,
0.015908f, 0.041147f, 0.025762f, 0.089042f, 0.023178f, 0.088074f, 0.056219f, 0.096882f, 0.855508f, 2.048525f, 0.827646f, 4.538465f, 0.039139f, 0.058395f, 0.055797f, 0.194987f,
0.030439f, 0.079076f, 0.021887f, 0.155686f, 0.020748f, 0.079182f, 0.022345f, 0.079246f, 1.834633f, 4.412133f, 0.788074f, 8.893401f, 0.029689f, 0.044488f, 0.018793f, 0.135153f,
0.044512f, 0.101876f, 0.057739f, 0.204976f, 0.034444f, 0.115808f, 0.066918f, 0.118444f, 1.250488f, 2.649462f, 0.969013f, 5.457610f, 0.065560f, 0.086550f, 0.074863f, 0.268704f,
1.443648f, 2.944485f, 3.365064f, 5.280921f, 2.322943f, 6.960168f, 8.109783f, 6.345439f, 26.041123f, 49.169426f, 36.261952f, 90.283603f, 1.151068f, 1.354219f, 2.361979f, 3.747706f,
0.295829f, 1.181246f, 0.995497f, 1.565269f, 0.674639f, 3.957341f, 3.400234f, 2.665594f, 9.076784f, 33.552007f, 18.246950f, 45.517779f, 0.354185f, 0.815773f, 1.049233f, 1.667994f,
0.120948f, 0.485045f, 0.180716f, 0.584766f, 0.129036f, 0.760194f, 0.288765f, 0.465872f, 4.159065f, 15.440613f, 3.712374f, 19.058065f, 0.057406f, 0.132793f, 0.075508f, 0.247032f,
0.095576f, 0.337681f, 0.257618f, 0.416038f, 0.115755f, 0.600805f, 0.467313f, 0.376271f, 1.531878f, 5.010390f, 2.466674f, 6.319914f, 0.068501f, 0.139604f, 0.162543f, 0.265399f,
0.412315f, 0.313054f, 0.663504f, 2.333879f, 0.035808f, 0.039940f, 0.086304f, 0.151357f, 4.410267f, 3.099863f, 4.239736f, 23.660012f, 0.223138f, 0.097724f, 0.316104f, 1.124185f,
0.156618f, 0.232800f, 0.363850f, 1.282300f, 0.019277f, 0.042094f, 0.067075f, 0.117860f, 2.849501f, 3.921005f, 3.954662f, 22.111508f, 0.127272f, 0.109123f, 0.260290f, 0.927466f,
0.154738f, 0.231004f, 0.159616f, 1.157655f, 0.008910f, 0.019540f, 0.013766f, 0.049778f, 3.155214f, 4.360536f, 1.944316f, 22.372388f, 0.049849f, 0.042926f, 0.045266f, 0.331935f,
0.234212f, 0.308044f, 0.435833f, 1.577597f, 0.015310f, 0.029581f, 0.042670f, 0.077008f, 2.225993f, 2.710274f, 2.474535f, 14.210571f, 0.113937f, 0.086438f, 0.186645f, 0.683072f,
0.036979f, 0.059113f, 0.094671f, 0.327429f, 0.578785f, 1.359172f, 2.219282f, 3.826934f, 2.983161f, 4.414563f, 4.562388f, 25.034352f, 0.022719f, 0.020948f, 0.051202f, 0.179045f,
0.003656f, 0.011441f, 0.013511f, 0.046821f, 0.081095f, 0.372820f, 0.448903f, 0.775576f, 0.501638f, 1.453291f, 1.107573f, 6.089051f, 0.003373f, 0.006088f, 0.010973f, 0.038444f,
0.001295f, 0.004071f, 0.002126f, 0.015159f, 0.013442f, 0.062067f, 0.033039f, 0.117474f, 0.199204f, 0.579618f, 0.195289f, 2.209485f, 0.000474f, 0.000859f, 0.000684f, 0.004934f,
0.005193f, 0.014380f, 0.015374f, 0.054717f, 0.061178f, 0.248867f, 0.271262f, 0.481359f, 0.372237f, 0.954207f, 0.658311f, 3.717211f, 0.002868f, 0.004581f, 0.007474f, 0.026895f,
0.000019f, 0.000047f, 0.000034f, 0.000456f, 0.000209f, 0.000764f, 0.000557f, 0.003754f, 0.010577f, 0.024384f, 0.011260f, 0.241434f, 0.000018f, 0.000025f, 0.000028f, 0.000378f,
0.000000f, 0.000002f, 0.000001f, 0.000014f, 0.000006f, 0.000044f, 0.000023f, 0.000158f, 0.000370f, 0.001668f, 0.000568f, 0.012203f, 0.000001f, 0.000002f, 0.000001f, 0.000017f,
0.000000f, 0.000002f, 0.000000f, 0.000012f, 0.000003f, 0.000020f, 0.000005f, 0.000065f, 0.000396f, 0.001794f, 0.000270f, 0.011941f, 0.000000f, 0.000001f, 0.000000f, 0.000006f,
0.000001f, 0.000006f, 0.000003f, 0.000037f, 0.000011f, 0.000068f, 0.000033f, 0.000229f, 0.000641f, 0.002559f, 0.000789f, 0.017406f, 0.000001f, 0.000003f, 0.000002f, 0.000028f,
0.002055f, 0.007900f, 0.007609f, 0.046783f, 0.035439f, 0.200142f, 0.196553f, 0.602490f, 0.654683f, 2.329900f, 1.448256f, 14.126038f, 0.000931f, 0.002064f, 0.003035f, 0.018862f,
0.000122f, 0.000918f, 0.000652f, 0.004017f, 0.002982f, 0.032967f, 0.023875f, 0.073323f, 0.066109f, 0.460594f, 0.211126f, 2.063238f, 0.000083f, 0.000360f, 0.000391f, 0.002432f,
0.000025f, 0.000188f, 0.000059f, 0.000749f, 0.000285f, 0.003162f, 0.001013f, 0.006399f, 0.015127f, 0.105850f, 0.021450f, 0.431396f, 0.000007f, 0.000029f, 0.000014f, 0.000180f,
0.000047f, 0.000311f, 0.000200f, 0.001267f, 0.000607f, 0.005937f, 0.003892f, 0.012277f, 0.013235f, 0.081589f, 0.033855f, 0.339814f, 0.000019f, 0.000073f, 0.000072f, 0.000459f,
0.000003f, 0.000004f, 0.000007f, 0.000100f, 0.000003f, 0.000006f, 0.000010f, 0.000069f, 0.000536f, 0.000710f, 0.000818f, 0.017891f, 0.000001f, 0.000001f, 0.000002f, 0.000027f,
0.000000f, 0.000001f, 0.000001f, 0.000016f, 0.000000f, 0.000002f, 0.000002f, 0.000016f, 0.000100f, 0.000260f, 0.000221f, 0.004844f, 0.000000f, 0.000000f, 0.000000f, 0.000007f,
0.000000f, 0.000000f, 0.000000f, 0.000007f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000055f, 0.000144f, 0.000054f, 0.002447f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000001f, 0.000001f, 0.000002f, 0.000023f, 0.000000f, 0.000001f, 0.000002f, 0.000012f, 0.000093f, 0.000213f, 0.000164f, 0.003693f, 0.000000f, 0.000000f, 0.000000f, 0.000006f,
0.019499f, 0.020735f, 0.022501f, 0.237798f, 0.024483f, 0.038246f, 0.042315f, 0.222967f, 3.952008f, 3.890416f, 2.724379f, 45.679610f, 0.012357f, 0.007580f, 0.012553f, 0.134133f,
0.002053f, 0.004275f, 0.003421f, 0.036220f, 0.003654f, 0.011175f, 0.009117f, 0.048132f, 0.707871f, 1.364217f, 0.704483f, 11.834727f, 0.001954f, 0.002346f, 0.002866f, 0.030678f,
0.000548f, 0.001146f, 0.000406f, 0.008838f, 0.000456f, 0.001402f, 0.000506f, 0.005494f, 0.211845f, 0.410043f, 0.093612f, 3.236357f, 0.000207f, 0.000249f, 0.000135f, 0.002967f,
0.001696f, 0.003124f, 0.002263f, 0.024613f, 0.001603f, 0.004337f, 0.003203f, 0.017370f, 0.305428f, 0.520834f, 0.243475f, 4.200982f, 0.000966f, 0.001027f, 0.001135f, 0.012480f,
0.000002f, 0.000003f, 0.000001f, 0.000058f, 0.000002f, 0.000004f, 0.000002f, 0.000038f, 0.002463f, 0.003777f, 0.001182f, 0.077429f, 0.000002f, 0.000002f, 0.000001f, 0.000050f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000092f, 0.000275f, 0.000064f, 0.004168f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000074f, 0.000223f, 0.000023f, 0.003074f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000092f, 0.000246f, 0.000051f, 0.003457f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000865f, 0.002212f, 0.001444f, 0.027121f, 0.001197f, 0.004496f, 0.002992f, 0.028021f, 0.692321f, 1.639010f, 0.690330f, 20.575120f, 0.000404f, 0.000596f, 0.000594f, 0.011280f,
0.000055f, 0.000274f, 0.000132f, 0.002481f, 0.000107f, 0.000789f, 0.000387f, 0.003632f, 0.074466f, 0.345132f, 0.107195f, 3.201062f, 0.000038f, 0.000111f, 0.000081f, 0.001549f,
0.000008f, 0.000042f, 0.000009f, 0.000349f, 0.000008f, 0.000057f, 0.000012f, 0.000239f, 0.012841f, 0.059775f, 0.008208f, 0.504403f, 0.000002f, 0.000007f, 0.000002f, 0.000086f,
0.000012f, 0.000054f, 0.000024f, 0.000455f, 0.000013f, 0.000083f, 0.000037f, 0.000354f, 0.008668f, 0.035549f, 0.009995f, 0.306557f, 0.000005f, 0.000013f, 0.000009f, 0.000170f,
0.000012f, 0.000011f, 0.000014f, 0.000577f, 0.000001f, 0.000001f, 0.000002f, 0.000032f, 0.005644f, 0.004974f, 0.003885f, 0.259533f, 0.000004f, 0.000002f, 0.000004f, 0.000163f,
0.000001f, 0.000003f, 0.000002f, 0.000098f, 0.000000f, 0.000000f, 0.000000f, 0.000008f, 0.001125f, 0.001941f, 0.001118f, 0.074847f, 0.000001f, 0.000001f, 0.000001f, 0.000041f,
0.000001f, 0.000001f, 0.000000f, 0.000033f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000469f, 0.000813f, 0.000207f, 0.028501f, 0.000000f, 0.000000f, 0.000000f, 0.000006f,
0.000001f, 0.000002f, 0.000002f, 0.000083f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000606f, 0.000926f, 0.000483f, 0.033178f, 0.000000f, 0.000000f, 0.000000f, 0.000021f,
0.001269f, 0.000812f, 0.001429f, 0.018259f, 0.102928f, 0.096744f, 0.173524f, 1.105688f, 6.403900f, 3.793073f, 4.306173f, 87.311341f, 0.026488f, 0.009776f, 0.026247f, 0.339154f,
0.000190f, 0.000238f, 0.000308f, 0.003948f, 0.021805f, 0.040124f, 0.053071f, 0.338813f, 1.628216f, 1.888035f, 1.580613f, 32.109815f, 0.005945f, 0.004296f, 0.008505f, 0.110109f,
0.000024f, 0.000031f, 0.000017f, 0.000461f, 0.001304f, 0.002410f, 0.001409f, 0.018513f, 0.233255f, 0.271651f, 0.100541f, 4.203303f, 0.000301f, 0.000219f, 0.000191f, 0.005098f,
0.000092f, 0.000102f, 0.000120f, 0.001582f, 0.005640f, 0.009183f, 0.010995f, 0.072094f, 0.414225f, 0.425006f, 0.322092f, 6.720473f, 0.001733f, 0.001108f, 0.001986f, 0.026409f,
0.000001f, 0.000001f, 0.000001f, 0.000026f, 0.000038f, 0.000056f, 0.000045f, 0.001119f, 0.023423f, 0.021613f, 0.010963f, 0.868612f, 0.000021f, 0.000012f, 0.000015f, 0.000739f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000005f, 0.000003f, 0.000071f, 0.001237f, 0.002235f, 0.000836f, 0.066380f, 0.000001f, 0.000001f, 0.000001f, 0.000050f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000010f, 0.000478f, 0.000867f, 0.000143f, 0.023433f, 0.000000f, 0.000000f, 0.000000f, 0.000006f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000003f, 0.000001f, 0.000035f, 0.000736f, 0.001176f, 0.000398f, 0.032463f, 0.000001f, 0.000001f, 0.000001f, 0.000028f,
0.000061f, 0.000094f, 0.000100f, 0.002270f, 0.005485f, 0.012397f, 0.013374f, 0.151485f, 1.223030f, 1.742125f, 1.189552f, 42.873926f, 0.000944f, 0.000838f, 0.001354f, 0.031094f,
0.000006f, 0.000017f, 0.000013f, 0.000295f, 0.000698f, 0.003088f, 0.002456f, 0.027875f, 0.186733f, 0.520731f, 0.262200f, 9.468390f, 0.000127f, 0.000221f, 0.000263f, 0.006062f,
0.000000f, 0.000001f, 0.000000f, 0.000020f, 0.000024f, 0.000107f, 0.000038f, 0.000878f, 0.015414f, 0.043172f, 0.009610f, 0.714191f, 0.000004f, 0.000006f, 0.000003f, 0.000162f,
0.000001f, 0.000002f, 0.000001f, 0.000032f, 0.000049f, 0.000191f, 0.000137f, 0.001600f, 0.012816f, 0.031624f, 0.014415f, 0.534641f, 0.000010f, 0.000015f, 0.000017f, 0.000392f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000000f, 0.000000f, 0.000011f, 0.000632f, 0.000335f, 0.000425f, 0.034298f, 0.000001f, 0.000000f, 0.000001f, 0.000028f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000179f, 0.000186f, 0.000173f, 0.014040f, 0.000000f, 0.000000f, 0.000000f, 0.000010f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000036f, 0.000037f, 0.000015f, 0.002559f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000057f, 0.000052f, 0.000044f, 0.003670f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
5.883660f, 3.732242f, 8.141462f, 13.806528f, 6.686468f, 6.230917f, 13.857669f, 11.716778f, 102.254810f, 60.047269f, 84.527496f, 227.416240f, 4.829313f, 1.767043f, 5.882782f, 10.086437f,
1.725656f, 2.143027f, 3.447274f, 5.857208f, 2.779433f, 5.070635f, 8.316031f, 7.044777f, 51.013235f, 58.646675f, 60.878462f, 164.104410f, 2.126872f, 1.523541f, 3.740293f, 6.425304f,
0.742749f, 0.926398f, 0.658811f, 2.303627f, 0.559658f, 1.025442f, 0.743499f, 1.296189f, 24.607926f, 28.413038f, 13.039277f, 72.334638f, 0.362907f, 0.261090f, 0.283372f, 1.001800f,
1.527654f, 1.678646f, 2.444420f, 4.265789f, 1.306744f, 2.109392f, 3.131698f, 2.724829f, 23.590641f, 23.997232f, 22.550174f, 62.433122f, 1.127128f, 0.714409f, 1.587694f, 2.801326f,
0.022652f, 0.022385f, 0.021819f, 0.144581f, 0.018123f, 0.026309f, 0.026145f, 0.086378f, 2.725090f, 2.492968f, 1.568037f, 16.484824f, 0.028172f, 0.016058f, 0.023888f, 0.160042f,
0.001381f, 0.002671f, 0.001920f, 0.012746f, 0.001565f, 0.004449f, 0.003260f, 0.010792f, 0.282501f, 0.505950f, 0.234673f, 2.471862f, 0.002578f, 0.002877f, 0.003156f, 0.021185f,
0.001602f, 0.003114f, 0.000989f, 0.013518f, 0.000850f, 0.002426f, 0.000786f, 0.005355f, 0.367501f, 0.661040f, 0.135550f, 2.938301f, 0.001186f, 0.001330f, 0.000645f, 0.008908f,
0.002856f, 0.004888f, 0.003181f, 0.021690f, 0.001720f, 0.004325f, 0.002869f, 0.009754f, 0.305256f, 0.483740f, 0.203113f, 2.197385f, 0.003193f, 0.003152f, 0.003130f, 0.021582f,
0.453592f, 0.691964f, 0.907862f, 2.736732f, 0.567994f, 1.272900f, 1.702692f, 2.559086f, 31.132643f, 43.966405f, 37.224543f, 178.026050f, 0.274516f, 0.241560f, 0.483688f, 1.474182f,
0.079889f, 0.238592f, 0.230839f, 0.697195f, 0.141781f, 0.622043f, 0.613590f, 0.923973f, 9.326760f, 25.786173f, 16.099448f, 77.143294f, 0.072601f, 0.125069f, 0.184673f, 0.563926f,
0.019813f, 0.059431f, 0.025420f, 0.158001f, 0.016450f, 0.072486f, 0.031610f, 0.097959f, 2.592435f, 7.198571f, 1.986945f, 19.593366f, 0.007138f, 0.012350f, 0.008062f, 0.050663f,
0.019080f, 0.050421f, 0.044160f, 0.136989f, 0.017984f, 0.069813f, 0.062340f, 0.096417f, 1.163622f, 2.846612f, 1.608872f, 7.918023f, 0.010380f, 0.015822f, 0.021149f, 0.066331f,
0.029160f, 0.016559f, 0.040292f, 0.272241f, 0.001971f, 0.001644f, 0.004079f, 0.013740f, 1.186788f, 0.623908f, 0.979646f, 10.501258f, 0.011978f, 0.003924f, 0.014570f, 0.099535f,
0.009520f, 0.010584f, 0.018991f, 0.128560f, 0.000912f, 0.001489f, 0.002724f, 0.009196f, 0.659052f, 0.678293f, 0.785383f, 8.435041f, 0.005872f, 0.003766f, 0.010312f, 0.070579f,
0.005706f, 0.006371f, 0.005054f, 0.070406f, 0.000256f, 0.000419f, 0.000339f, 0.002356f, 0.442683f, 0.457587f, 0.234236f, 5.177198f, 0.001395f, 0.000899f, 0.001088f, 0.015323f,
0.010524f, 0.010353f, 0.016816f, 0.116924f, 0.000535f, 0.000774f, 0.001281f, 0.004442f, 0.380595f, 0.346595f, 0.363291f, 4.007457f, 0.003886f, 0.002205f, 0.005466f, 0.038427f,
0.005764f, 0.006891f, 0.012670f, 0.084173f, 0.070203f, 0.123305f, 0.231138f, 0.765608f, 1.769152f, 1.958149f, 2.323285f, 24.487426f, 0.002688f, 0.001854f, 0.005201f, 0.034937f,
0.000490f, 0.001146f, 0.001554f, 0.010345f, 0.008454f, 0.029070f, 0.040184f, 0.133359f, 0.255694f, 0.554055f, 0.484758f, 5.119162f, 0.000343f, 0.000463f, 0.000958f, 0.006448f,
0.000105f, 0.000247f, 0.000148f, 0.002032f, 0.000850f, 0.002936f, 0.001794f, 0.012253f, 0.061595f, 0.134047f, 0.051849f, 1.126818f, 0.000029f, 0.000040f, 0.000036f, 0.000502f,
0.000514f, 0.001065f, 0.001307f, 0.008937f, 0.004715f, 0.014345f, 0.017951f, 0.061187f, 0.140262f, 0.268925f, 0.212997f, 2.310229f, 0.000216f, 0.000258f, 0.000482f, 0.003334f,
0.000001f, 0.000002f, 0.000002f, 0.000042f, 0.000009f, 0.000025f, 0.000021f, 0.000272f, 0.002270f, 0.003914f, 0.002075f, 0.085465f, 0.000001f, 0.000001f, 0.000001f, 0.000027f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000001f, 0.000001f, 0.000010f, 0.000068f, 0.000230f, 0.000090f, 0.003713f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000044f, 0.000150f, 0.000026f, 0.002204f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000001f, 0.000001f, 0.000011f, 0.000087f, 0.000261f, 0.000092f, 0.003915f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000361f, 0.001037f, 0.001147f, 0.013543f, 0.004841f, 0.020447f, 0.023053f, 0.135735f, 0.437226f, 1.163810f, 0.830506f, 15.560163f, 0.000124f, 0.000206f, 0.000347f, 0.004145f,
0.000018f, 0.000104f, 0.000084f, 0.001000f, 0.000350f, 0.002895f, 0.002407f, 0.014198f, 0.037947f, 0.197745f, 0.104059f, 1.953374f, 0.000010f, 0.000031f, 0.000038f, 0.000459f,
0.000002f, 0.000013f, 0.000005f, 0.000113f, 0.000020f, 0.000168f, 0.000062f, 0.000752f, 0.005267f, 0.027567f, 0.006413f, 0.247757f, 0.000000f, 0.000002f, 0.000001f, 0.000021f,
0.000005f, 0.000026f, 0.000019f, 0.000233f, 0.000053f, 0.000385f, 0.000290f, 0.001757f, 0.005616f, 0.025895f, 0.012335f, 0.237829f, 0.000002f, 0.000005f, 0.000005f, 0.000064f,
0.000000f, 0.000000f, 0.000000f, 0.000007f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000081f, 0.000080f, 0.000106f, 0.004436f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000013f, 0.000025f, 0.000025f, 0.001032f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000008f, 0.000004f, 0.000316f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000009f, 0.000015f, 0.000013f, 0.000582f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.011136f, 0.017969f, 0.015051f, 0.144626f, 0.016183f, 0.038363f, 0.032760f, 0.156952f, 3.374181f, 5.040423f, 2.724399f, 41.533249f, 0.016767f, 0.015607f, 0.019950f, 0.193821f,
0.000662f, 0.002090f, 0.001291f, 0.012429f, 0.001363f, 0.006324f, 0.003982f, 0.019116f, 0.340995f, 0.997237f, 0.397482f, 6.071219f, 0.001496f, 0.002726f, 0.002569f, 0.025011f,
0.000193f, 0.000612f, 0.000167f, 0.003311f, 0.000186f, 0.000866f, 0.000241f, 0.002382f, 0.111409f, 0.327229f, 0.057662f, 1.812512f, 0.000173f, 0.000316f, 0.000132f, 0.002641f,
0.000815f, 0.002278f, 0.001274f, 0.012596f, 0.000892f, 0.003661f, 0.002087f, 0.010289f, 0.219431f, 0.567818f, 0.204879f, 3.214132f, 0.001103f, 0.001779f, 0.001518f, 0.015174f,
0.000001f, 0.000001f, 0.000001f, 0.000020f, 0.000001f, 0.000002f, 0.000001f, 0.000015f, 0.001197f, 0.002786f, 0.000673f, 0.040083f, 0.000001f, 0.000002f, 0.000001f, 0.000041f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000025f, 0.000115f, 0.000020f, 0.001218f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000022f, 0.000101f, 0.000008f, 0.000980f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000038f, 0.000152f, 0.000025f, 0.001506f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000275f, 0.001067f, 0.000538f, 0.009185f, 0.000440f, 0.002511f, 0.001290f, 0.010984f, 0.329159f, 1.182497f, 0.384421f, 10.417490f, 0.000305f, 0.000684f, 0.000526f, 0.009077f,
0.000010f, 0.000075f, 0.000028f, 0.000474f, 0.000022f, 0.000249f, 0.000094f, 0.000803f, 0.019976f, 0.140491f, 0.033680f, 0.914448f, 0.000016f, 0.000072f, 0.000041f, 0.000703f,
0.000002f, 0.000013f, 0.000002f, 0.000073f, 0.000002f, 0.000020f, 0.000003f, 0.000058f, 0.003761f, 0.026564f, 0.002815f, 0.157307f, 0.000001f, 0.000005f, 0.000001f, 0.000043f,
0.000003f, 0.000022f, 0.000007f, 0.000130f, 0.000004f, 0.000039f, 0.000013f, 0.000117f, 0.003468f, 0.021581f, 0.004684f, 0.130608f, 0.000003f, 0.000013f, 0.000006f, 0.000115f,
0.000003f, 0.000005f, 0.000005f, 0.000176f, 0.000000f, 0.000001f, 0.000001f, 0.000011f, 0.002415f, 0.003230f, 0.001947f, 0.118269f, 0.000003f, 0.000002f, 0.000003f, 0.000118f,
0.000000f, 0.000001f, 0.000000f, 0.000017f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000272f, 0.000711f, 0.000316f, 0.019244f, 0.000000f, 0.000000f, 0.000000f, 0.000017f,
0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000124f, 0.000325f, 0.000064f, 0.008000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000001f, 0.000001f, 0.000021f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000218f, 0.000506f, 0.000204f, 0.012723f, 0.000000f, 0.000000f, 0.000000f, 0.000013f,
0.000624f, 0.000606f, 0.000823f, 0.009558f, 0.058561f, 0.083525f, 0.115634f, 0.669929f, 4.706149f, 4.229924f, 3.706510f, 68.330523f, 0.030936f, 0.017326f, 0.035905f, 0.421824f,
0.000053f, 0.000100f, 0.000100f, 0.001166f, 0.007000f, 0.019545f, 0.019954f, 0.115824f, 0.675114f, 1.187942f, 0.767615f, 14.178356f, 0.003918f, 0.004295f, 0.006564f, 0.077268f,
0.000007f, 0.000014f, 0.000006f, 0.000149f, 0.000457f, 0.001282f, 0.000578f, 0.006909f, 0.105585f, 0.186596f, 0.053305f, 2.026216f, 0.000217f, 0.000239f, 0.000161f, 0.003906f,
0.000038f, 0.000064f, 0.000058f, 0.000697f, 0.002700f, 0.006671f, 0.006165f, 0.036757f, 0.256151f, 0.398819f, 0.233288f, 4.425712f, 0.001703f, 0.001653f, 0.002286f, 0.027640f,
0.000000f, 0.000000f, 0.000000f, 0.000008f, 0.000012f, 0.000028f, 0.000017f, 0.000386f, 0.009800f, 0.013723f, 0.005373f, 0.387043f, 0.000014f, 0.000012f, 0.000011f, 0.000523f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000014f, 0.000292f, 0.000801f, 0.000231f, 0.016688f, 0.000000f, 0.000001f, 0.000000f, 0.000020f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000123f, 0.000339f, 0.000043f, 0.006432f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000010f, 0.000259f, 0.000628f, 0.000164f, 0.012172f, 0.000000f, 0.000001f, 0.000000f, 0.000017f,
0.000017f, 0.000039f, 0.000032f, 0.000662f, 0.001738f, 0.005960f, 0.004963f, 0.051111f, 0.500501f, 1.081852f, 0.570170f, 18.684623f, 0.000614f, 0.000827f, 0.001031f, 0.021535f,
0.000001f, 0.000004f, 0.000002f, 0.000048f, 0.000125f, 0.000838f, 0.000514f, 0.005306f, 0.043115f, 0.182451f, 0.070909f, 2.328152f, 0.000047f, 0.000123f, 0.000113f, 0.002369f,
0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000005f, 0.000032f, 0.000009f, 0.000182f, 0.003885f, 0.016514f, 0.002837f, 0.191715f, 0.000001f, 0.000004f, 0.000002f, 0.000069f,
0.000000f, 0.000001f, 0.000000f, 0.000008f, 0.000013f, 0.000077f, 0.000043f, 0.000454f, 0.004413f, 0.016525f, 0.005814f, 0.196062f, 0.000005f, 0.000013f, 0.000011f, 0.000229f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000233f, 0.000187f, 0.000183f, 0.013453f, 0.000000f, 0.000000f, 0.000000f, 0.000018f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000037f, 0.000059f, 0.000042f, 0.003107f, 0.000000f, 0.000000f, 0.000000f, 0.000004f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000008f, 0.000013f, 0.000004f, 0.000618f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000018f, 0.000025f, 0.000016f, 0.001211f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
1.443791f, 1.389783f, 2.339979f, 3.607981f, 1.899073f, 2.685451f, 4.609860f, 3.543856f, 37.512581f, 33.427714f, 36.319829f, 88.845948f, 2.815587f, 1.563331f, 4.017161f, 6.262456f,
0.238922f, 0.450245f, 0.559023f, 0.863604f, 0.445395f, 1.233025f, 1.560839f, 1.202207f, 10.558935f, 18.420481f, 14.758886f, 36.172664f, 0.699631f, 0.760506f, 1.441074f, 2.250840f,
0.112266f, 0.212484f, 0.116633f, 0.370803f, 0.097908f, 0.272225f, 0.152345f, 0.241483f, 5.560564f, 9.742758f, 3.451040f, 17.406571f, 0.130325f, 0.142280f, 0.119191f, 0.383123f,
0.315443f, 0.525988f, 0.591187f, 0.938034f, 0.312302f, 0.765001f, 0.876631f, 0.693500f, 7.282361f, 11.241228f, 8.153332f, 20.524410f, 0.552963f, 0.531851f, 0.912311f, 1.463557f,
0.003165f, 0.004746f, 0.003570f, 0.021512f, 0.002931f, 0.006456f, 0.004952f, 0.014875f, 0.569197f, 0.790167f, 0.383611f, 3.666820f, 0.009352f, 0.008089f, 0.009288f, 0.056576f,
0.000109f, 0.000319f, 0.000177f, 0.001070f, 0.000143f, 0.000616f, 0.000348f, 0.001049f, 0.033293f, 0.090480f, 0.032392f, 0.310223f, 0.000483f, 0.000818f, 0.000692f, 0.004225f,
0.000138f, 0.000407f, 0.000100f, 0.001239f, 0.000085f, 0.000367f, 0.000092f, 0.000568f, 0.047282f, 0.129057f, 0.020426f, 0.402580f, 0.000243f, 0.000413f, 0.000154f, 0.001940f,
0.000336f, 0.000872f, 0.000438f, 0.002716f, 0.000234f, 0.000893f, 0.000457f, 0.001413f, 0.053652f, 0.129019f, 0.041813f, 0.411292f, 0.000892f, 0.001336f, 0.001024f, 0.006420f,
0.061983f, 0.143485f, 0.145304f, 0.398253f, 0.089833f, 0.305497f, 0.315414f, 0.431023f, 6.359984f, 13.629546f, 8.906814f, 38.729945f, 0.089125f, 0.119008f, 0.183928f, 0.509688f,
0.006159f, 0.027914f, 0.020845f, 0.057243f, 0.012652f, 0.084232f, 0.064131f, 0.087805f, 1.075016f, 4.510157f, 2.173442f, 9.469028f, 0.013299f, 0.034765f, 0.039622f, 0.110007f,
0.001668f, 0.007591f, 0.002506f, 0.014162f, 0.001603f, 0.010716f, 0.003607f, 0.010163f, 0.326211f, 1.374540f, 0.292839f, 2.625569f, 0.001427f, 0.003748f, 0.001888f, 0.010789f,
0.002194f, 0.008798f, 0.005947f, 0.016775f, 0.002393f, 0.014099f, 0.009717f, 0.013665f, 0.200028f, 0.742554f, 0.323932f, 1.449504f, 0.002836f, 0.006559f, 0.006767f, 0.019298f,
0.003586f, 0.003090f, 0.005804f, 0.035656f, 0.000281f, 0.000355f, 0.000680f, 0.002083f, 0.218209f, 0.174076f, 0.210970f, 2.056189f, 0.003500f, 0.001740f, 0.004987f, 0.030973f,
0.000661f, 0.001114f, 0.001543f, 0.009500f, 0.000073f, 0.000182f, 0.000256f, 0.000787f, 0.068369f, 0.106778f, 0.095428f, 0.931865f, 0.000968f, 0.000942f, 0.001991f, 0.012392f,
0.000432f, 0.000732f, 0.000448f, 0.005680f, 0.000022f, 0.000056f, 0.000035f, 0.000220f, 0.050135f, 0.078640f, 0.031071f, 0.624406f, 0.000251f, 0.000245f, 0.000229f, 0.002937f,
0.001089f, 0.001626f, 0.002038f, 0.012886f, 0.000064f, 0.000141f, 0.000180f, 0.000567f, 0.058885f, 0.081373f, 0.065833f, 0.660283f, 0.000956f, 0.000823f, 0.001574f, 0.010062f,
0.003296f, 0.005979f, 0.008485f, 0.051254f, 0.046460f, 0.123830f, 0.179163f, 0.539578f, 1.512300f, 2.540030f, 2.326098f, 22.291478f, 0.003651f, 0.003821f, 0.008276f, 0.050544f,
0.000158f, 0.000561f, 0.000587f, 0.003554f, 0.003157f, 0.016472f, 0.017574f, 0.053029f, 0.123321f, 0.405499f, 0.273839f, 2.629291f, 0.000263f, 0.000539f, 0.000860f, 0.005263f,
0.000037f, 0.000132f, 0.000061f, 0.000762f, 0.000347f, 0.001816f, 0.000857f, 0.005319f, 0.032431f, 0.107103f, 0.031976f, 0.631830f, 0.000024f, 0.000050f, 0.000036f, 0.000447f,
0.000247f, 0.000778f, 0.000737f, 0.004579f, 0.002626f, 0.012122f, 0.011708f, 0.036286f, 0.100891f, 0.293538f, 0.179448f, 1.769661f, 0.000246f, 0.000447f, 0.000646f, 0.004059f,
0.000000f, 0.000001f, 0.000001f, 0.000015f, 0.000003f, 0.000014f, 0.000009f, 0.000109f, 0.001105f, 0.002891f, 0.001183f, 0.044297f, 0.000001f, 0.000001f, 0.000001f, 0.000022f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000019f, 0.000096f, 0.000029f, 0.001086f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000013f, 0.000068f, 0.000009f, 0.000704f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000001f, 0.000000f, 0.000004f, 0.000036f, 0.000162f, 0.000044f, 0.001707f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000115f, 0.000501f, 0.000428f, 0.004592f, 0.001784f, 0.011435f, 0.009951f, 0.053270f, 0.208126f, 0.840664f, 0.463037f, 7.887816f, 0.000094f, 0.000236f, 0.000308f, 0.003339f,
0.000003f, 0.000028f, 0.000018f, 0.000191f, 0.000073f, 0.000913f, 0.000586f, 0.003144f, 0.010192f, 0.080592f, 0.032734f, 0.558692f, 0.000004f, 0.000020f, 0.000019f, 0.000209f,
0.000000f, 0.000004f, 0.000001f, 0.000024f, 0.000005f, 0.000058f, 0.000016f, 0.000182f, 0.001544f, 0.012265f, 0.002202f, 0.077361f, 0.000000f, 0.000001f, 0.000000f, 0.000010f,
0.000001f, 0.000011f, 0.000006f, 0.000066f, 0.000016f, 0.000181f, 0.000105f, 0.000580f, 0.002249f, 0.015739f, 0.005787f, 0.101449f, 0.000001f, 0.000004f, 0.000004f, 0.000043f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000035f, 0.000052f, 0.000053f, 0.002024f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000009f, 0.000007f, 0.000266f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000003f, 0.000001f, 0.000089f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000008f, 0.000006f, 0.000223f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.005649f, 0.008779f, 0.007132f, 0.089865f, 0.006571f, 0.015002f, 0.012425f, 0.078059f, 1.693550f, 2.436380f, 1.277219f, 25.532425f, 0.005202f, 0.004663f, 0.005782f, 0.073655f,
0.000379f, 0.001152f, 0.000690f, 0.008712f, 0.000624f, 0.002790f, 0.001704f, 0.010725f, 0.193067f, 0.543759f, 0.210205f, 4.210195f, 0.000524f, 0.000919f, 0.000840f, 0.010722f,
0.000094f, 0.000287f, 0.000076f, 0.001973f, 0.000072f, 0.000325f, 0.000088f, 0.001136f, 0.053620f, 0.151674f, 0.025922f, 1.068457f, 0.000051f, 0.000091f, 0.000037f, 0.000962f,
0.000283f, 0.000761f, 0.000413f, 0.005351f, 0.000247f, 0.000979f, 0.000541f, 0.003498f, 0.075294f, 0.187636f, 0.065663f, 1.350797f, 0.000234f, 0.000363f, 0.000301f, 0.003942f,
0.000000f, 0.000001f, 0.000000f, 0.000014f, 0.000000f, 0.000001f, 0.000000f, 0.000009f, 0.000668f, 0.001497f, 0.000351f, 0.027394f, 0.000000f, 0.000001f, 0.000000f, 0.000017f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000016f, 0.000069f, 0.000012f, 0.000939f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000012f, 0.000052f, 0.000004f, 0.000642f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000014f, 0.000056f, 0.000009f, 0.000704f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000173f, 0.000647f, 0.000316f, 0.007076f, 0.000222f, 0.001217f, 0.000606f, 0.006772f, 0.204815f, 0.708603f, 0.223423f, 7.939340f, 0.000117f, 0.000253f, 0.000189f, 0.004276f,
0.000007f, 0.000051f, 0.000018f, 0.000412f, 0.000013f, 0.000136f, 0.000050f, 0.000559f, 0.014021f, 0.094969f, 0.022081f, 0.786159f, 0.000007f, 0.000030f, 0.000016f, 0.000374f,
0.000001f, 0.000007f, 0.000001f, 0.000054f, 0.000001f, 0.000009f, 0.000001f, 0.000034f, 0.002244f, 0.015264f, 0.001569f, 0.114961f, 0.000000f, 0.000002f, 0.000000f, 0.000019f,
0.000001f, 0.000009f, 0.000003f, 0.000068f, 0.000001f, 0.000013f, 0.000004f, 0.000049f, 0.001475f, 0.008841f, 0.001861f, 0.068049f, 0.000001f, 0.000003f, 0.000002f, 0.000037f,
0.000005f, 0.000007f, 0.000006f, 0.000306f, 0.000000f, 0.000001f, 0.000001f, 0.000016f, 0.003395f, 0.004372f, 0.002556f, 0.203620f, 0.000002f, 0.000002f, 0.000002f, 0.000126f,
0.000000f, 0.000001f, 0.000001f, 0.000033f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000431f, 0.001086f, 0.000468f, 0.037375f, 0.000000f, 0.000000f, 0.000000f, 0.000020f,
0.000000f, 0.000000f, 0.000000f, 0.000010f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000167f, 0.000422f, 0.000080f, 0.013207f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000000f, 0.000001f, 0.000000f, 0.000025f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000210f, 0.000468f, 0.000183f, 0.014974f, 0.000000f, 0.000000f, 0.000000f, 0.000009f,
0.000665f, 0.000621f, 0.000818f, 0.012470f, 0.049925f, 0.068577f, 0.092080f, 0.699534f, 4.959286f, 4.292740f, 3.648243f, 88.193099f, 0.020153f, 0.010869f, 0.021846f, 0.336558f,
0.000063f, 0.000116f, 0.000112f, 0.001716f, 0.006732f, 0.018102f, 0.017924f, 0.136430f, 0.802529f, 1.359965f, 0.852300f, 20.643154f, 0.002879f, 0.003040f, 0.004506f, 0.069544f,
0.000007f, 0.000014f, 0.000006f, 0.000186f, 0.000374f, 0.001009f, 0.000442f, 0.006918f, 0.106693f, 0.181587f, 0.050311f, 2.507760f, 0.000135f, 0.000144f, 0.000094f, 0.002988f,
0.000028f, 0.000045f, 0.000040f, 0.000621f, 0.001574f, 0.003744f, 0.003356f, 0.026239f, 0.184536f, 0.276699f, 0.156979f, 3.905110f, 0.000759f, 0.000709f, 0.000951f, 0.015076f,
0.000000f, 0.000000f, 0.000000f, 0.000011f, 0.000012f, 0.000025f, 0.000015f, 0.000448f, 0.011481f, 0.015482f, 0.005879f, 0.555362f, 0.000010f, 0.000009f, 0.000008f, 0.000464f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000018f, 0.000386f, 0.001019f, 0.000285f, 0.027012f, 0.000000f, 0.000000f, 0.000000f, 0.000020f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000138f, 0.000367f, 0.000045f, 0.008849f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000008f, 0.000207f, 0.000485f, 0.000123f, 0.011940f, 0.000000f, 0.000000f, 0.000000f, 0.000010f,
0.000022f, 0.000050f, 0.000040f, 0.001070f, 0.001837f, 0.006067f, 0.004899f, 0.066164f, 0.653859f, 1.361116f, 0.695741f, 29.897121f, 0.000496f, 0.000643f, 0.000778f, 0.021301f,
0.000001f, 0.000006f, 0.000003f, 0.000088f, 0.000149f, 0.000962f, 0.000573f, 0.007749f, 0.063539f, 0.258943f, 0.097605f, 4.202296f, 0.000043f, 0.000108f, 0.000096f, 0.002643f,
0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000005f, 0.000031f, 0.000008f, 0.000226f, 0.004867f, 0.019923f, 0.003320f, 0.294158f, 0.000001f, 0.000003f, 0.000001f, 0.000065f,
0.000000f, 0.000001f, 0.000000f, 0.000009f, 0.000009f, 0.000054f, 0.000029f, 0.000402f, 0.003942f, 0.014214f, 0.004850f, 0.214471f, 0.000003f, 0.000007f, 0.000005f, 0.000155f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000000f, 0.000000f, 0.000010f, 0.000687f, 0.000533f, 0.000505f, 0.048628f, 0.000001f, 0.000000f, 0.000001f, 0.000040f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000124f, 0.000188f, 0.000131f, 0.012670f, 0.000000f, 0.000000f, 0.000000f, 0.000009f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000023f, 0.000035f, 0.000011f, 0.002143f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000036f, 0.000048f, 0.000030f, 0.002993f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
1.760054f, 1.631611f, 2.664394f, 5.387062f, 1.853002f, 2.523479f, 4.201332f, 4.235227f, 45.242902f, 38.826538f, 40.914995f, 131.243450f, 2.099186f, 1.122488f, 2.797476f, 5.718645f,
0.328554f, 0.596278f, 0.718036f, 1.454563f, 0.490241f, 1.307027f, 1.604676f, 1.620728f, 14.365604f, 24.135327f, 18.755239f, 60.276885f, 0.588412f, 0.615975f, 1.132044f, 2.318586f,
0.131236f, 0.239208f, 0.127347f, 0.530898f, 0.091608f, 0.245296f, 0.133140f, 0.276737f, 6.430918f, 10.851366f, 3.727941f, 24.656634f, 0.093173f, 0.097962f, 0.079592f, 0.335481f,
0.262889f, 0.422159f, 0.460195f, 0.957495f, 0.208324f, 0.491445f, 0.546193f, 0.566601f, 6.004489f, 8.926187f, 6.279194f, 20.727201f, 0.281844f, 0.261066f, 0.434330f, 0.913667f,
0.004289f, 0.006194f, 0.004520f, 0.035708f, 0.003179f, 0.006744f, 0.005017f, 0.019763f, 0.763191f, 1.020324f, 0.480426f, 6.021803f, 0.007751f, 0.006457f, 0.007190f, 0.057435f,
0.000166f, 0.000470f, 0.000253f, 0.002003f, 0.000175f, 0.000726f, 0.000398f, 0.001572f, 0.050356f, 0.131796f, 0.045762f, 0.574699f, 0.000451f, 0.000736f, 0.000605f, 0.004839f,
0.000179f, 0.000509f, 0.000121f, 0.001972f, 0.000088f, 0.000367f, 0.000089f, 0.000724f, 0.060792f, 0.159801f, 0.024530f, 0.633972f, 0.000193f, 0.000316f, 0.000115f, 0.001888f,
0.000311f, 0.000778f, 0.000379f, 0.003082f, 0.000174f, 0.000638f, 0.000317f, 0.001284f, 0.049180f, 0.113895f, 0.035799f, 0.461761f, 0.000505f, 0.000729f, 0.000542f, 0.004456f,
0.093673f, 0.208835f, 0.205111f, 0.737178f, 0.108666f, 0.355889f, 0.356373f, 0.638595f, 9.509443f, 19.625861f, 12.439028f, 70.927112f, 0.082377f, 0.105933f, 0.158789f, 0.577004f,
0.010501f, 0.045830f, 0.033193f, 0.119528f, 0.017264f, 0.110692f, 0.081738f, 0.146749f, 1.813193f, 7.326033f, 3.424067f, 19.561450f, 0.013866f, 0.034908f, 0.038586f, 0.140483f,
0.002417f, 0.010594f, 0.003392f, 0.025138f, 0.001859f, 0.011970f, 0.003908f, 0.014438f, 0.467711f, 1.897952f, 0.392169f, 4.610722f, 0.001265f, 0.003199f, 0.001563f, 0.011713f,
0.002267f, 0.008754f, 0.005739f, 0.021227f, 0.001979f, 0.011229f, 0.007506f, 0.013841f, 0.204466f, 0.730980f, 0.309277f, 1.814742f, 0.001792f, 0.003992f, 0.003994f, 0.014935f,
0.012244f, 0.010161f, 0.018509f, 0.149100f, 0.000767f, 0.000935f, 0.001736f, 0.006971f, 0.737052f, 0.566258f, 0.665597f, 8.506593f, 0.007308f, 0.003499f, 0.009726f, 0.079212f,
0.002544f, 0.004134f, 0.005552f, 0.044813f, 0.000226f, 0.000539f, 0.000738f, 0.002970f, 0.260507f, 0.391819f, 0.339625f, 4.348865f, 0.002280f, 0.002137f, 0.004381f, 0.035749f,
0.001415f, 0.002309f, 0.001371f, 0.022775f, 0.000059f, 0.000141f, 0.000085f, 0.000706f, 0.162386f, 0.245300f, 0.094000f, 2.477081f, 0.000503f, 0.000473f, 0.000429f, 0.007203f,
0.002542f, 0.003655f, 0.004444f, 0.036838f, 0.000120f, 0.000253f, 0.000314f, 0.001296f, 0.135975f, 0.180961f, 0.141993f, 1.867466f, 0.001364f, 0.001131f, 0.002099f, 0.017592f,
0.002887f, 0.005045f, 0.006944f, 0.055002f, 0.032581f, 0.083630f, 0.117355f, 0.463457f, 1.310890f, 2.120391f, 1.883310f, 23.666499f, 0.001957f, 0.001972f, 0.004142f, 0.033172f,
0.000156f, 0.000534f, 0.000542f, 0.004302f, 0.002497f, 0.012549f, 0.012986f, 0.051381f, 0.120586f, 0.381854f, 0.250103f, 3.148938f, 0.000159f, 0.000313f, 0.000486f, 0.003896f,
0.000031f, 0.000107f, 0.000048f, 0.000784f, 0.000233f, 0.001176f, 0.000538f, 0.004381f, 0.026957f, 0.085735f, 0.024825f, 0.643244f, 0.000013f, 0.000025f, 0.000017f, 0.000282f,
0.000148f, 0.000449f, 0.000412f, 0.003360f, 0.001259f, 0.005597f, 0.005243f, 0.021307f, 0.059787f, 0.167522f, 0.099326f, 1.284444f, 0.000090f, 0.000158f, 0.000221f, 0.001821f,
0.000000f, 0.000001f, 0.000001f, 0.000018f, 0.000003f, 0.000011f, 0.000007f, 0.000104f, 0.001065f, 0.002683f, 0.001065f, 0.052284f, 0.000000f, 0.000001f, 0.000001f, 0.000016f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000020f, 0.000100f, 0.000029f, 0.001446f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000012f, 0.000061f, 0.000008f, 0.000796f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000024f, 0.000103f, 0.000027f, 0.001378f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000125f, 0.000524f, 0.000434f, 0.006109f, 0.001551f, 0.009574f, 0.008080f, 0.056724f, 0.223655f, 0.870011f, 0.464766f, 10.381913f, 0.000062f, 0.000151f, 0.000191f, 0.002717f,
0.000004f, 0.000033f, 0.000020f, 0.000287f, 0.000071f, 0.000863f, 0.000537f, 0.003776f, 0.012355f, 0.094085f, 0.037064f, 0.829513f, 0.000003f, 0.000014f, 0.000013f, 0.000192f,
0.000000f, 0.000004f, 0.000001f, 0.000030f, 0.000004f, 0.000047f, 0.000013f, 0.000186f, 0.001591f, 0.012172f, 0.002120f, 0.097638f, 0.000000f, 0.000001f, 0.000000f, 0.000008f,
0.000001f, 0.000008f, 0.000004f, 0.000060f, 0.000010f, 0.000104f, 0.000058f, 0.000422f, 0.001653f, 0.011136f, 0.003971f, 0.091285f, 0.000000f, 0.000002f, 0.000002f, 0.000024f,
0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000084f, 0.000121f, 0.000120f, 0.006018f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000009f, 0.000024f, 0.000018f, 0.000891f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000008f, 0.000002f, 0.000254f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000005f, 0.000013f, 0.000009f, 0.000454f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.235649f, 0.231419f, 0.409699f, 1.377262f, 0.316991f, 0.457313f, 0.825440f, 1.383481f, 12.383959f, 11.258506f, 12.862312f, 68.598140f, 0.176751f, 0.100123f, 0.270523f, 0.919451f,
0.029861f, 0.057410f, 0.074950f, 0.252439f, 0.056930f, 0.160790f, 0.214015f, 0.359390f, 2.669267f, 4.750776f, 4.002381f, 21.386739f, 0.033632f, 0.037297f, 0.074312f, 0.253057f,
0.013955f, 0.026945f, 0.015552f, 0.107796f, 0.012446f, 0.035305f, 0.020775f, 0.071795f, 1.398008f, 2.498989f, 0.930751f, 10.235197f, 0.006231f, 0.006940f, 0.006113f, 0.042838f,
0.035896f, 0.061065f, 0.072167f, 0.249651f, 0.036345f, 0.090828f, 0.109440f, 0.188758f, 1.676164f, 2.639670f, 2.013132f, 11.048593f, 0.024202f, 0.023748f, 0.042834f, 0.149815f,
0.000077f, 0.000119f, 0.000094f, 0.001232f, 0.000073f, 0.000165f, 0.000133f, 0.000871f, 0.028191f, 0.039926f, 0.020381f, 0.424740f, 0.000088f, 0.000078f, 0.000094f, 0.001246f,
0.000002f, 0.000006f, 0.000004f, 0.000047f, 0.000003f, 0.000012f, 0.000007f, 0.000047f, 0.001263f, 0.003501f, 0.001318f, 0.027517f, 0.000003f, 0.000006f, 0.000005f, 0.000071f,
0.000003f, 0.000008f, 0.000002f, 0.000054f, 0.000002f, 0.000007f, 0.000002f, 0.000025f, 0.001783f, 0.004966f, 0.000826f, 0.035514f, 0.000002f, 0.000003f, 0.000001f, 0.000033f,
0.000006f, 0.000015f, 0.000008f, 0.000108f, 0.000004f, 0.000016f, 0.000009f, 0.000058f, 0.001853f, 0.004545f, 0.001549f, 0.033216f, 0.000006f, 0.000009f, 0.000007f, 0.000099f,
0.011748f, 0.027746f, 0.029544f, 0.176544f, 0.017413f, 0.060415f, 0.065587f, 0.195406f, 2.438254f, 5.330844f, 3.663010f, 34.726567f, 0.006497f, 0.008851f, 0.014384f, 0.086902f,
0.000894f, 0.004133f, 0.003246f, 0.019432f, 0.001878f, 0.012756f, 0.010212f, 0.030482f, 0.315593f, 1.350813f, 0.684468f, 6.501448f, 0.000742f, 0.001980f, 0.002373f, 0.014363f,
0.000241f, 0.001118f, 0.000388f, 0.004781f, 0.000237f, 0.001614f, 0.000571f, 0.003509f, 0.095242f, 0.409431f, 0.091718f, 1.792861f, 0.000079f, 0.000212f, 0.000112f, 0.001401f,
0.000290f, 0.001186f, 0.000843f, 0.005185f, 0.000323f, 0.001944f, 0.001409f, 0.004319f, 0.053466f, 0.202490f, 0.092882f, 0.906142f, 0.000144f, 0.000340f, 0.000369f, 0.002294f,
0.000436f, 0.000383f, 0.000757f, 0.010138f, 0.000035f, 0.000045f, 0.000091f, 0.000606f, 0.053657f, 0.043670f, 0.055651f, 1.182530f, 0.000164f, 0.000083f, 0.000250f, 0.003387f,
0.000061f, 0.000106f, 0.000154f, 0.002068f, 0.000007f, 0.000018f, 0.000026f, 0.000175f, 0.012874f, 0.020513f, 0.019276f, 0.410385f, 0.000035f, 0.000034f, 0.000076f, 0.001038f,
0.000040f, 0.000069f, 0.000045f, 0.001230f, 0.000002f, 0.000005f, 0.000004f, 0.000049f, 0.009389f, 0.015025f, 0.006242f, 0.273480f, 0.000009f, 0.000009f, 0.000009f, 0.000245f,
0.000092f, 0.000141f, 0.000185f, 0.002555f, 0.000006f, 0.000012f, 0.000017f, 0.000115f, 0.010095f, 0.014233f, 0.012108f, 0.264753f, 0.000031f, 0.000027f, 0.000055f, 0.000767f,
0.008469f, 0.005004f, 0.014363f, 0.058388f, 0.735788f, 0.638688f, 1.868913f, 3.787922f, 11.079567f, 6.060557f, 11.224824f, 72.393137f, 0.209188f, 0.071298f, 0.312303f, 1.283588f,
0.001523f, 0.001762f, 0.003730f, 0.015191f, 0.187576f, 0.318760f, 0.687828f, 1.396770f, 3.389899f, 3.630177f, 4.958045f, 32.037658f, 0.056501f, 0.037701f, 0.121777f, 0.501472f,
0.000341f, 0.000396f, 0.000370f, 0.003105f, 0.019630f, 0.033504f, 0.031961f, 0.133569f, 0.849883f, 0.914076f, 0.551925f, 7.339511f, 0.005011f, 0.003358f, 0.004795f, 0.040636f,
0.001080f, 0.001105f, 0.002117f, 0.008858f, 0.070607f, 0.106168f, 0.207387f, 0.432548f, 1.255107f, 1.189275f, 1.470393f, 9.758710f, 0.023973f, 0.014154f, 0.041387f, 0.175046f,
0.000016f, 0.000015f, 0.000019f, 0.000307f, 0.001000f, 0.001352f, 0.001768f, 0.014000f, 0.148028f, 0.126142f, 0.104391f, 2.630773f, 0.000612f, 0.000325f, 0.000636f, 0.010210f,
0.000001f, 0.000001f, 0.000001f, 0.000017f, 0.000053f, 0.000140f, 0.000135f, 0.001073f, 0.009411f, 0.015701f, 0.009581f, 0.241929f, 0.000034f, 0.000036f, 0.000052f, 0.000829f,
0.000000f, 0.000001f, 0.000000f, 0.000009f, 0.000015f, 0.000040f, 0.000017f, 0.000277f, 0.006363f, 0.010661f, 0.002876f, 0.149465f, 0.000008f, 0.000009f, 0.000005f, 0.000181f,
0.000001f, 0.000002f, 0.000001f, 0.000023f, 0.000047f, 0.000109f, 0.000095f, 0.000776f, 0.008142f, 0.012019f, 0.006640f, 0.172190f, 0.000034f, 0.000031f, 0.000041f, 0.000676f,
0.000460f, 0.000654f, 0.001129f, 0.008159f, 0.044065f, 0.091986f, 0.161892f, 0.583267f, 2.378180f, 3.128458f, 3.484988f, 39.952996f, 0.008383f, 0.006871f, 0.018103f, 0.132260f,
0.000050f, 0.000138f, 0.000176f, 0.001275f, 0.006746f, 0.027568f, 0.035779f, 0.129154f, 0.436943f, 1.125281f, 0.924374f, 10.617655f, 0.001360f, 0.002182f, 0.004239f, 0.031029f,
0.000006f, 0.000018f, 0.000010f, 0.000150f, 0.000407f, 0.001670f, 0.000958f, 0.007117f, 0.063122f, 0.163268f, 0.059293f, 1.401586f, 0.000069f, 0.000112f, 0.000096f, 0.001449f,
0.000010f, 0.000023f, 0.000027f, 0.000201f, 0.000685f, 0.002477f, 0.002910f, 0.010790f, 0.043646f, 0.099458f, 0.073960f, 0.872538f, 0.000156f, 0.000221f, 0.000389f, 0.002922f,
0.000001f, 0.000001f, 0.000002f, 0.000030f, 0.000006f, 0.000004f, 0.000014f, 0.000115f, 0.003319f, 0.001625f, 0.003358f, 0.086283f, 0.000013f, 0.000004f, 0.000020f, 0.000327f,
0.000000f, 0.000000f, 0.000001f, 0.000009f, 0.000002f, 0.000002f, 0.000006f, 0.000047f, 0.001130f, 0.001084f, 0.001651f, 0.042504f, 0.000004f, 0.000002f, 0.000009f, 0.000142f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000395f, 0.000380f, 0.000256f, 0.013559f, 0.000000f, 0.000000f, 0.000000f, 0.000016f,
0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000001f, 0.000001f, 0.000002f, 0.000018f, 0.000523f, 0.000443f, 0.000611f, 0.016168f, 0.000002f, 0.000001f, 0.000004f, 0.000062f,
24.539969f, 14.376040f, 51.160990f, 27.596817f, 29.877612f, 25.712497f, 93.293089f, 25.090290f, 110.583720f, 59.971320f, 137.725780f, 117.862900f, 23.839366f, 8.055631f, 43.752438f, 23.861386f,
8.661184f, 9.933300f, 26.068064f, 14.088412f, 14.945191f, 25.179736f, 67.370839f, 18.153531f, 66.387528f, 70.483941f, 119.365130f, 102.346320f, 12.634184f, 8.358017f, 33.475072f, 18.291440f,
6.524064f, 7.514790f, 8.718618f, 9.696986f, 5.266496f, 8.911556f, 10.541190f, 5.845417f, 56.044366f, 59.761002f, 44.742512f, 78.949931f, 3.772716f, 2.506642f, 4.438396f, 4.991015f,
11.158807f, 11.323868f, 26.901622f, 14.932763f, 10.225994f, 15.244584f, 36.923689f, 10.218864f, 44.680001f, 41.973722f, 64.347764f, 56.667848f, 9.744261f, 5.703817f, 20.680100f, 11.606135f,
0.345117f, 0.314962f, 0.500833f, 1.055643f, 0.295806f, 0.396581f, 0.642942f, 0.675668f, 10.765114f, 9.094895f, 9.332643f, 31.208355f, 0.507992f, 0.267416f, 0.648972f, 1.383005f,
0.025311f, 0.045222f, 0.053028f, 0.111985f, 0.030747f, 0.080701f, 0.096480f, 0.101585f, 1.342936f, 2.221188f, 1.680768f, 5.631277f, 0.055944f, 0.057654f, 0.103178f, 0.220301f,
0.051416f, 0.092262f, 0.047829f, 0.207865f, 0.029219f, 0.077024f, 0.040710f, 0.088212f, 3.057363f, 5.078776f, 1.699014f, 11.714746f, 0.045051f, 0.046630f, 0.036892f, 0.162108f,
0.076197f, 0.120460f, 0.127868f, 0.277349f, 0.049158f, 0.114165f, 0.123554f, 0.133616f, 2.111879f, 3.090722f, 2.117147f, 7.285488f, 0.100818f, 0.091935f, 0.148938f, 0.326621f,
2.126286f, 2.995591f, 6.411885f, 6.148037f, 2.852476f, 5.903588f, 12.883233f, 6.159023f, 37.840132f, 49.351565f, 68.167332f, 103.697620f, 1.523025f, 1.237677f, 4.043099f, 3.919567f,
0.450651f, 1.242947f, 1.961875f, 1.884755f, 0.856828f, 3.471671f, 5.586800f, 2.675982f, 13.641554f, 34.830774f, 35.477601f, 54.072886f, 0.484703f, 0.771129f, 1.857587f, 1.804289f,
0.195599f, 0.541827f, 0.378090f, 0.747507f, 0.173980f, 0.707988f, 0.503693f, 0.496503f, 6.635819f, 17.016723f, 7.662708f, 24.034994f, 0.083400f, 0.133260f, 0.141918f, 0.283682f,
0.156641f, 0.382276f, 0.546217f, 0.538961f, 0.158169f, 0.567058f, 0.826077f, 0.406395f, 2.476934f, 5.595957f, 5.159816f, 8.077332f, 0.100856f, 0.141975f, 0.309602f, 0.308866f,
0.369014f, 0.193529f, 0.768226f, 1.651042f, 0.026719f, 0.020585f, 0.083311f, 0.089270f, 3.894129f, 1.890605f, 4.843021f, 16.513048f, 0.179404f, 0.054272f, 0.328792f, 0.714435f,
0.144975f, 0.148849f, 0.435718f, 0.938227f, 0.014877f, 0.022439f, 0.066968f, 0.071897f, 2.602274f, 2.473401f, 4.672245f, 15.961343f, 0.105835f, 0.062679f, 0.280019f, 0.609625f,
0.152060f, 0.156802f, 0.202921f, 0.899217f, 0.007300f, 0.011058f, 0.014590f, 0.032236f, 3.059006f, 2.920141f, 2.438655f, 17.144722f, 0.044007f, 0.026176f, 0.051698f, 0.231625f,
0.233249f, 0.211902f, 0.561516f, 1.241861f, 0.012712f, 0.016965f, 0.045834f, 0.050540f, 2.187089f, 1.839368f, 3.145347f, 11.036224f, 0.101934f, 0.053416f, 0.216025f, 0.483046f,
0.038207f, 0.042188f, 0.126542f, 0.267407f, 0.498575f, 0.808723f, 2.473187f, 2.605736f, 3.040875f, 3.108296f, 6.016532f, 20.170898f, 0.021087f, 0.013431f, 0.061483f, 0.131360f,
0.003907f, 0.008445f, 0.018679f, 0.039549f, 0.072251f, 0.229437f, 0.517412f, 0.546189f, 0.528873f, 1.058342f, 1.510655f, 5.074314f, 0.003238f, 0.004037f, 0.013628f, 0.029172f,
0.001470f, 0.003190f, 0.003120f, 0.013594f, 0.012714f, 0.040550f, 0.040428f, 0.087827f, 0.222959f, 0.448108f, 0.282773f, 1.954725f, 0.000483f, 0.000605f, 0.000902f, 0.003975f,
0.005970f, 0.011420f, 0.022866f, 0.049725f, 0.058642f, 0.164774f, 0.336381f, 0.364708f, 0.422220f, 0.747609f, 0.966013f, 3.332752f, 0.002962f, 0.003268f, 0.009987f, 0.021957f,
0.000026f, 0.000045f, 0.000060f, 0.000493f, 0.000238f, 0.000601f, 0.000821f, 0.003379f, 0.014253f, 0.022697f, 0.019630f, 0.257160f, 0.000022f, 0.000021f, 0.000044f, 0.000367f,
0.000001f, 0.000002f, 0.000002f, 0.000015f, 0.000007f, 0.000035f, 0.000036f, 0.000147f, 0.000515f, 0.001606f, 0.001024f, 0.013443f, 0.000001f, 0.000001f, 0.000002f, 0.000017f,
0.000001f, 0.000002f, 0.000001f, 0.000014f, 0.000003f, 0.000017f, 0.000008f, 0.000064f, 0.000586f, 0.001834f, 0.000517f, 0.013965f, 0.000000f, 0.000001f, 0.000000f, 0.000006f,
0.000002f, 0.000006f, 0.000005f, 0.000044f, 0.000014f, 0.000059f, 0.000054f, 0.000230f, 0.000961f, 0.002651f, 0.001530f, 0.020630f, 0.000001f, 0.000003f, 0.000003f, 0.000030f,
0.002687f, 0.007136f, 0.012873f, 0.048357f, 0.038638f, 0.150723f, 0.277231f, 0.519213f, 0.844635f, 2.076292f, 2.417219f, 14.405401f, 0.001094f, 0.001675f, 0.004612f, 0.017515f,
0.000165f, 0.000858f, 0.001141f, 0.004295f, 0.003362f, 0.025678f, 0.034829f, 0.065354f, 0.088214f, 0.424529f, 0.364461f, 2.176173f, 0.000101f, 0.000302f, 0.000614f, 0.002336f,
0.000036f, 0.000187f, 0.000110f, 0.000851f, 0.000341f, 0.002615f, 0.001568f, 0.006055f, 0.021429f, 0.103574f, 0.039310f, 0.483044f, 0.000009f, 0.000026f, 0.000023f, 0.000183f,
0.000068f, 0.000313f, 0.000377f, 0.001457f, 0.000736f, 0.004975f, 0.006109f, 0.011773f, 0.019000f, 0.080906f, 0.062877f, 0.385605f, 0.000025f, 0.000066f, 0.000121f, 0.000474f,
0.000002f, 0.000002f, 0.000007f, 0.000063f, 0.000002f, 0.000003f, 0.000009f, 0.000036f, 0.000420f, 0.000384f, 0.000830f, 0.011086f, 0.000001f, 0.000000f, 0.000002f, 0.000015f,
0.000000f, 0.000000f, 0.000001f, 0.000010f, 0.000000f, 0.000001f, 0.000002f, 0.000008f, 0.000081f, 0.000146f, 0.000232f, 0.003104f, 0.000000f, 0.000000f, 0.000000f, 0.000004f,
0.000000f, 0.000000f, 0.000000f, 0.000005f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000048f, 0.000086f, 0.000060f, 0.001665f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000001f, 0.000002f, 0.000016f, 0.000000f, 0.000001f, 0.000002f, 0.000007f, 0.000081f, 0.000129f, 0.000185f, 0.002546f, 0.000000f, 0.000000f, 0.000000f, 0.000004f,
0.018963f, 0.013928f, 0.028309f, 0.182797f, 0.019851f, 0.021420f, 0.044385f, 0.142898f, 3.791790f, 2.578310f, 3.381629f, 34.643010f, 0.010796f, 0.004574f, 0.014188f, 0.092628f,
0.002065f, 0.002970f, 0.004451f, 0.028797f, 0.003064f, 0.006473f, 0.009891f, 0.031905f, 0.702456f, 0.935107f, 0.904415f, 9.283040f, 0.001766f, 0.001464f, 0.003350f, 0.021912f,
0.000585f, 0.000846f, 0.000560f, 0.007460f, 0.000406f, 0.000862f, 0.000582f, 0.003866f, 0.223177f, 0.298383f, 0.127584f, 2.694977f, 0.000198f, 0.000165f, 0.000167f, 0.002250f,
0.001835f, 0.002335f, 0.003168f, 0.021053f, 0.001446f, 0.002703f, 0.003739f, 0.012388f, 0.326086f, 0.384092f, 0.336287f, 3.545205f, 0.000939f, 0.000689f, 0.001427f, 0.009590f,
0.000002f, 0.000003f, 0.000002f, 0.000059f, 0.000002f, 0.000003f, 0.000003f, 0.000033f, 0.003124f, 0.003309f, 0.001939f, 0.077627f, 0.000002f, 0.000001f, 0.000002f, 0.000045f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000120f, 0.000249f, 0.000108f, 0.004322f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000103f, 0.000215f, 0.000041f, 0.003384f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000130f, 0.000239f, 0.000094f, 0.003857f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.001065f, 0.001881f, 0.002299f, 0.026387f, 0.001228f, 0.003187f, 0.003972f, 0.022729f, 0.840718f, 1.374793f, 1.084505f, 19.749299f, 0.000447f, 0.000455f, 0.000850f, 0.009859f,
0.000070f, 0.000241f, 0.000217f, 0.002496f, 0.000114f, 0.000578f, 0.000531f, 0.003047f, 0.093528f, 0.299419f, 0.174176f, 3.177915f, 0.000044f, 0.000088f, 0.000120f, 0.001400f,
0.000011f, 0.000040f, 0.000016f, 0.000373f, 0.000009f, 0.000044f, 0.000018f, 0.000213f, 0.017122f, 0.055053f, 0.014158f, 0.531609f, 0.000003f, 0.000006f, 0.000003f, 0.000083f,
0.000017f, 0.000051f, 0.000042f, 0.000492f, 0.000014f, 0.000065f, 0.000054f, 0.000319f, 0.011713f, 0.033180f, 0.017473f, 0.327429f, 0.000006f, 0.000011f, 0.000014f, 0.000165f,
0.000009f, 0.000006f, 0.000013f, 0.000341f, 0.000001f, 0.000001f, 0.000001f, 0.000016f, 0.004164f, 0.002535f, 0.003709f, 0.151375f, 0.000003f, 0.000001f, 0.000003f, 0.000086f,
0.000001f, 0.000001f, 0.000002f, 0.000060f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000859f, 0.001023f, 0.001104f, 0.045152f, 0.000000f, 0.000000f, 0.000001f, 0.000023f,
0.000000f, 0.000001f, 0.000000f, 0.000022f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000380f, 0.000455f, 0.000217f, 0.018253f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000001f, 0.000001f, 0.000002f, 0.000055f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000498f, 0.000525f, 0.000513f, 0.021533f, 0.000000f, 0.000000f, 0.000000f, 0.000012f,
0.000645f, 0.000285f, 0.000940f, 0.007336f, 0.043621f, 0.028321f, 0.095139f, 0.370396f, 3.211601f, 1.313957f, 2.793835f, 34.611020f, 0.012096f, 0.003084f, 0.015506f, 0.122420f,
0.000100f, 0.000086f, 0.000210f, 0.001641f, 0.009558f, 0.012149f, 0.030095f, 0.117391f, 0.844555f, 0.676455f, 1.060654f, 13.164993f, 0.002808f, 0.001401f, 0.005197f, 0.041107f,
0.000014f, 0.000012f, 0.000013f, 0.000203f, 0.000607f, 0.000775f, 0.000848f, 0.006810f, 0.128444f, 0.103325f, 0.071624f, 1.829533f, 0.000151f, 0.000076f, 0.000124f, 0.002021f,
0.000052f, 0.000040f, 0.000088f, 0.000707f, 0.002660f, 0.002991f, 0.006708f, 0.026874f, 0.231159f, 0.163826f, 0.232534f, 2.964428f, 0.000881f, 0.000389f, 0.001306f, 0.010607f,
0.000000f, 0.000000f, 0.000000f, 0.000014f, 0.000021f, 0.000022f, 0.000033f, 0.000495f, 0.015528f, 0.009897f, 0.009403f, 0.455182f, 0.000013f, 0.000005f, 0.000011f, 0.000352f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000002f, 0.000002f, 0.000033f, 0.000849f, 0.001059f, 0.000742f, 0.035978f, 0.000001f, 0.000000f, 0.000001f, 0.000025f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000005f, 0.000348f, 0.000436f, 0.000135f, 0.013483f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000001f, 0.000001f, 0.000017f, 0.000543f, 0.000599f, 0.000380f, 0.018930f, 0.000000f, 0.000000f, 0.000000f, 0.000015f,
0.000039f, 0.000042f, 0.000083f, 0.001155f, 0.002942f, 0.004593f, 0.009281f, 0.064227f, 0.776302f, 0.763810f, 0.976807f, 21.510634f, 0.000546f, 0.000335f, 0.001012f, 0.014205f,
0.000004f, 0.000008f, 0.000011f, 0.000155f, 0.000387f, 0.001183f, 0.001763f, 0.012224f, 0.122589f, 0.236134f, 0.222688f, 4.913320f, 0.000076f, 0.000091f, 0.000204f, 0.002864f,
0.000000f, 0.000001f, 0.000000f, 0.000011f, 0.000014f, 0.000043f, 0.000029f, 0.000409f, 0.010743f, 0.020783f, 0.008665f, 0.393441f, 0.000002f, 0.000003f, 0.000003f, 0.000081f,
0.000001f, 0.000001f, 0.000001f, 0.000018f, 0.000029f, 0.000079f, 0.000106f, 0.000755f, 0.009052f, 0.015429f, 0.013171f, 0.298483f, 0.000006f, 0.000007f, 0.000014f, 0.000199f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000244f, 0.000089f, 0.000212f, 0.010456f, 0.000000f, 0.000000f, 0.000000f, 0.000008f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000071f, 0.000051f, 0.000090f, 0.004427f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000015f, 0.000011f, 0.000008f, 0.000857f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000024f, 0.000015f, 0.000025f, 0.001245f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
4.057542f, 1.777860f, 7.263562f, 7.526035f, 3.844458f, 2.474589f, 10.307672f, 5.324924f, 69.571535f, 28.219790f, 74.400866f, 122.302770f, 2.991895f, 0.756172f, 4.714939f, 4.939303f,
1.230860f, 1.055831f, 3.180987f, 3.302262f, 1.652850f, 2.082823f, 6.397727f, 3.311396f, 35.897955f, 28.506439f, 55.422038f, 91.279604f, 1.362829f, 0.674321f, 3.100543f, 3.254319f,
0.562423f, 0.484542f, 0.645378f, 1.378795f, 0.353319f, 0.447165f, 0.607235f, 0.646813f, 18.383520f, 14.661686f, 12.601986f, 42.713651f, 0.246866f, 0.122679f, 0.249377f, 0.538660f,
1.172297f, 0.889783f, 2.426726f, 2.587489f, 0.836038f, 0.932193f, 2.592074f, 1.377976f, 17.860140f, 12.549284f, 22.086516f, 37.361711f, 0.777019f, 0.340187f, 1.415981f, 1.526471f,
0.020651f, 0.014096f, 0.025733f, 0.104186f, 0.013775f, 0.013813f, 0.025708f, 0.051895f, 2.451005f, 1.548791f, 1.824534f, 11.719646f, 0.023072f, 0.009084f, 0.025310f, 0.103604f,
0.001302f, 0.001740f, 0.002342f, 0.009499f, 0.001231f, 0.002416f, 0.003316f, 0.006706f, 0.262799f, 0.325104f, 0.282421f, 1.817579f, 0.002184f, 0.001683f, 0.003458f, 0.014184f,
0.001604f, 0.002153f, 0.001281f, 0.010696f, 0.000709f, 0.001399f, 0.000849f, 0.003532f, 0.362934f, 0.450931f, 0.173181f, 2.293677f, 0.001067f, 0.000826f, 0.000750f, 0.006332f,
0.002897f, 0.003425f, 0.004174f, 0.017392f, 0.001454f, 0.002526f, 0.003139f, 0.006521f, 0.305510f, 0.334415f, 0.262984f, 1.738335f, 0.002909f, 0.001984f, 0.003691f, 0.015546f,
0.395911f, 0.417184f, 1.025141f, 1.888125f, 0.413331f, 0.639825f, 1.602961f, 1.471995f, 26.808972f, 26.151573f, 41.469212f, 121.175430f, 0.215251f, 0.130833f, 0.490653f, 0.913682f,
0.072120f, 0.148778f, 0.269595f, 0.497498f, 0.106712f, 0.323390f, 0.597453f, 0.549693f, 8.306802f, 15.863632f, 18.550098f, 54.308500f, 0.058878f, 0.070061f, 0.193755f, 0.361498f,
0.018989f, 0.039342f, 0.031517f, 0.119692f, 0.013144f, 0.040006f, 0.032675f, 0.061869f, 2.451194f, 4.701416f, 2.430454f, 14.643528f, 0.006146f, 0.007345f, 0.008980f, 0.034478f,
0.018532f, 0.033826f, 0.055487f, 0.105168f, 0.014562f, 0.039048f, 0.065305f, 0.061713f, 1.114995f, 1.884094f, 1.994412f, 5.997151f, 0.009057f, 0.009536f, 0.023872f, 0.045746f,
0.015466f, 0.006067f, 0.027646f, 0.114131f, 0.000871f, 0.000502f, 0.002333f, 0.004802f, 0.620997f, 0.225502f, 0.663159f, 4.343349f, 0.005707f, 0.001291f, 0.008981f, 0.037486f,
0.005222f, 0.004010f, 0.013477f, 0.055744f, 0.000417f, 0.000470f, 0.001612f, 0.003324f, 0.356677f, 0.253563f, 0.549882f, 3.608357f, 0.002894f, 0.001282f, 0.006574f, 0.027492f,
0.003323f, 0.002563f, 0.003807f, 0.032409f, 0.000124f, 0.000141f, 0.000213f, 0.000904f, 0.254340f, 0.181597f, 0.174103f, 2.351168f, 0.000730f, 0.000325f, 0.000736f, 0.006336f,
0.006211f, 0.004220f, 0.012839f, 0.054544f, 0.000263f, 0.000263f, 0.000816f, 0.001727f, 0.221604f, 0.139395f, 0.273653f, 1.844375f, 0.002060f, 0.000808f, 0.003749f, 0.016104f,
0.003529f, 0.002914f, 0.010036f, 0.040738f, 0.035838f, 0.043479f, 0.152647f, 0.308928f, 1.068706f, 0.817056f, 1.815633f, 11.692378f, 0.001478f, 0.000704f, 0.003701f, 0.015190f,
0.000310f, 0.000501f, 0.001273f, 0.005178f, 0.004464f, 0.010602f, 0.027448f, 0.055656f, 0.159755f, 0.239110f, 0.391823f, 2.528120f, 0.000195f, 0.000182f, 0.000705f, 0.002899f,
0.000071f, 0.000115f, 0.000129f, 0.001080f, 0.000476f, 0.001137f, 0.001301f, 0.005429f, 0.040855f, 0.061414f, 0.044491f, 0.590771f, 0.000018f, 0.000017f, 0.000028f, 0.000240f,
0.000350f, 0.000501f, 0.001152f, 0.004813f, 0.002678f, 0.005629f, 0.013191f, 0.027473f, 0.094282f, 0.124863f, 0.185223f, 1.227473f, 0.000132f, 0.000109f, 0.000382f, 0.001613f,
0.000001f, 0.000001f, 0.000002f, 0.000027f, 0.000006f, 0.000012f, 0.000018f, 0.000145f, 0.001813f, 0.002159f, 0.002144f, 0.053947f, 0.000001f, 0.000000f, 0.000001f, 0.000015f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000001f, 0.000001f, 0.000005f, 0.000056f, 0.000131f, 0.000096f, 0.002424f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000039f, 0.000091f, 0.000029f, 0.001527f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000001f, 0.000001f, 0.000006f, 0.000078f, 0.000160f, 0.000106f, 0.002750f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000280f, 0.000555f, 0.001150f, 0.008296f, 0.003128f, 0.009125f, 0.019269f, 0.069320f, 0.334284f, 0.614617f, 0.821456f, 9.403515f, 0.000086f, 0.000099f, 0.000313f, 0.002281f,
0.000015f, 0.000057f, 0.000088f, 0.000633f, 0.000234f, 0.001336f, 0.002081f, 0.007499f, 0.030007f, 0.108011f, 0.106454f, 1.220958f, 0.000007f, 0.000015f, 0.000036f, 0.000261f,
0.000002f, 0.000008f, 0.000005f, 0.000076f, 0.000014f, 0.000083f, 0.000057f, 0.000422f, 0.004422f, 0.015985f, 0.006965f, 0.164402f, 0.000000f, 0.000001f, 0.000001f, 0.000012f,
0.000004f, 0.000015f, 0.000021f, 0.000159f, 0.000038f, 0.000191f, 0.000270f, 0.000999f, 0.004778f, 0.015217f, 0.013577f, 0.159933f, 0.000001f, 0.000002f, 0.000005f, 0.000039f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000037f, 0.000026f, 0.000063f, 0.001629f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000008f, 0.000015f, 0.000392f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000003f, 0.000002f, 0.000128f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000005f, 0.000005f, 0.000009f, 0.000238f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.024761f, 0.027599f, 0.043295f, 0.254189f, 0.030001f, 0.049124f, 0.078568f, 0.229986f, 7.401957f, 7.637613f, 7.731806f, 72.017974f, 0.033493f, 0.021533f, 0.051555f, 0.306026f,
0.001522f, 0.003320f, 0.003841f, 0.022594f, 0.002613f, 0.008376f, 0.009879f, 0.028972f, 0.773688f, 1.562889f, 1.166721f, 10.888291f, 0.003090f, 0.003890f, 0.006868f, 0.040845f,
0.000471f, 0.001032f, 0.000528f, 0.006389f, 0.000378f, 0.001218f, 0.000635f, 0.003833f, 0.268351f, 0.544438f, 0.179681f, 3.450892f, 0.000379f, 0.000479f, 0.000374f, 0.004579f,
0.002017f, 0.003894f, 0.004077f, 0.024635f, 0.001839f, 0.005216f, 0.005569f, 0.016777f, 0.535641f, 0.957408f, 0.647000f, 6.201630f, 0.002452f, 0.002731f, 0.004364f, 0.026660f,
0.000002f, 0.000003f, 0.000002f, 0.000047f, 0.000001f, 0.000004f, 0.000003f, 0.000030f, 0.003472f, 0.005581f, 0.002524f, 0.091881f, 0.000003f, 0.000003f, 0.000004f, 0.000085f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000075f, 0.000237f, 0.000079f, 0.002887f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000071f, 0.000223f, 0.000033f, 0.002467f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000122f, 0.000340f, 0.000103f, 0.003842f, 0.000000f, 0.000000f, 0.000000f, 0.000004f,
0.000774f, 0.002075f, 0.001958f, 0.020433f, 0.001033f, 0.004070f, 0.003915f, 0.020370f, 0.913903f, 2.267811f, 1.380810f, 22.862533f, 0.000772f, 0.001194f, 0.001719f, 0.018138f,
0.000029f, 0.000150f, 0.000104f, 0.001091f, 0.000054f, 0.000417f, 0.000296f, 0.001541f, 0.057363f, 0.278672f, 0.125122f, 2.075673f, 0.000043f, 0.000129f, 0.000138f, 0.001454f,
0.000005f, 0.000027f, 0.000008f, 0.000178f, 0.000005f, 0.000035f, 0.000011f, 0.000117f, 0.011465f, 0.055937f, 0.011103f, 0.379067f, 0.000003f, 0.000009f, 0.000004f, 0.000094f,
0.000010f, 0.000047f, 0.000030f, 0.000321f, 0.000010f, 0.000070f, 0.000045f, 0.000241f, 0.010714f, 0.046056f, 0.018720f, 0.318955f, 0.000009f, 0.000025f, 0.000024f, 0.000256f,
0.000006f, 0.000006f, 0.000010f, 0.000238f, 0.000000f, 0.000001f, 0.000001f, 0.000013f, 0.004074f, 0.003764f, 0.004250f, 0.157719f, 0.000004f, 0.000002f, 0.000006f, 0.000143f,
0.000000f, 0.000001f, 0.000001f, 0.000024f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000474f, 0.000857f, 0.000714f, 0.026543f, 0.000000f, 0.000000f, 0.000001f, 0.000021f,
0.000000f, 0.000000f, 0.000000f, 0.000009f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000229f, 0.000416f, 0.000153f, 0.011714f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000001f, 0.000001f, 0.000001f, 0.000032f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000410f, 0.000656f, 0.000494f, 0.018879f, 0.000000f, 0.000000f, 0.000001f, 0.000017f,
0.000725f, 0.000486f, 0.001237f, 0.008781f, 0.056745f, 0.055905f, 0.144956f, 0.513115f, 5.396280f, 3.350226f, 5.498271f, 61.931317f, 0.032301f, 0.012495f, 0.048498f, 0.348129f,
0.000063f, 0.000083f, 0.000156f, 0.001108f, 0.007015f, 0.013530f, 0.025871f, 0.091754f, 0.800654f, 0.973140f, 1.177724f, 13.291087f, 0.004231f, 0.003204f, 0.009171f, 0.065955f,
0.000009f, 0.000012f, 0.000010f, 0.000150f, 0.000486f, 0.000942f, 0.000796f, 0.005811f, 0.132934f, 0.162275f, 0.086823f, 2.016447f, 0.000248f, 0.000189f, 0.000239f, 0.003539f,
0.000049f, 0.000057f, 0.000097f, 0.000712f, 0.002911f, 0.004969f, 0.008600f, 0.031327f, 0.326831f, 0.351491f, 0.385080f, 4.463507f, 0.001979f, 0.001326f, 0.003436f, 0.025383f,
0.000000f, 0.000000f, 0.000000f, 0.000009f, 0.000016f, 0.000024f, 0.000028f, 0.000391f, 0.014856f, 0.014368f, 0.010536f, 0.463735f, 0.000019f, 0.000012f, 0.000020f, 0.000571f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000015f, 0.000458f, 0.000867f, 0.000469f, 0.020681f, 0.000001f, 0.000001f, 0.000001f, 0.000022f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000205f, 0.000390f, 0.000093f, 0.008461f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000012f, 0.000437f, 0.000732f, 0.000358f, 0.016228f, 0.000001f, 0.000001f, 0.000001f, 0.000020f,
0.000025f, 0.000040f, 0.000061f, 0.000770f, 0.002131f, 0.005049f, 0.007874f, 0.049547f, 0.726358f, 1.084490f, 1.070487f, 21.433650f, 0.000812f, 0.000755f, 0.001763f, 0.022495f,
0.000001f, 0.000004f, 0.000005f, 0.000058f, 0.000158f, 0.000734f, 0.000844f, 0.005320f, 0.064717f, 0.189166f, 0.137694f, 2.762245f, 0.000064f, 0.000116f, 0.000200f, 0.002559f,
0.000000f, 0.000000f, 0.000000f, 0.000005f, 0.000006f, 0.000029f, 0.000015f, 0.000194f, 0.006191f, 0.018176f, 0.005849f, 0.241476f, 0.000002f, 0.000004f, 0.000003f, 0.000079f,
0.000000f, 0.000001f, 0.000001f, 0.000010f, 0.000018f, 0.000073f, 0.000076f, 0.000490f, 0.007127f, 0.018433f, 0.012146f, 0.250266f, 0.000008f, 0.000013f, 0.000020f, 0.000266f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000205f, 0.000114f, 0.000209f, 0.009377f, 0.000000f, 0.000000f, 0.000000f, 0.000011f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000034f, 0.000037f, 0.000050f, 0.002240f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000008f, 0.000009f, 0.000005f, 0.000473f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000017f, 0.000017f, 0.000020f, 0.000939f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
2.276520f, 1.513654f, 4.773215f, 4.496740f, 2.496502f, 2.438484f, 7.839895f, 3.682418f, 58.354794f, 35.918570f, 73.092905f, 109.245580f, 3.988245f, 1.529595f, 7.361466f, 7.011718f,
0.389638f, 0.507186f, 1.179417f, 1.113235f, 0.605584f, 1.158013f, 2.745485f, 1.292038f, 16.988638f, 20.471621f, 30.720207f, 46.002957f, 1.024993f, 0.769604f, 2.731303f, 2.606531f,
0.194367f, 0.254104f, 0.261232f, 0.507437f, 0.141324f, 0.271416f, 0.284483f, 0.275518f, 9.497822f, 11.494766f, 7.625837f, 23.500938f, 0.202697f, 0.152854f, 0.239825f, 0.471003f,
0.553459f, 0.637459f, 1.341904f, 1.300917f, 0.456838f, 0.772969f, 1.658961f, 0.801864f, 12.605762f, 13.440742f, 18.258464f, 28.082391f, 0.871578f, 0.579046f, 1.860308f, 1.823418f,
0.006597f, 0.006833f, 0.009628f, 0.035443f, 0.005093f, 0.007750f, 0.011133f, 0.020433f, 1.170518f, 1.122398f, 1.020560f, 5.960347f, 0.017511f, 0.010463f, 0.022499f, 0.083739f,
0.000235f, 0.000476f, 0.000494f, 0.001823f, 0.000257f, 0.000765f, 0.000810f, 0.001490f, 0.070811f, 0.132929f, 0.089131f, 0.521548f, 0.000935f, 0.001094f, 0.001735f, 0.006469f,
0.000316f, 0.000643f, 0.000295f, 0.002241f, 0.000162f, 0.000483f, 0.000226f, 0.000857f, 0.106761f, 0.201287f, 0.059667f, 0.718522f, 0.000499f, 0.000586f, 0.000411f, 0.003152f,
0.000779f, 0.001397f, 0.001314f, 0.004979f, 0.000453f, 0.001193f, 0.001144f, 0.002160f, 0.122772f, 0.203929f, 0.123781f, 0.743926f, 0.001858f, 0.001923f, 0.002761f, 0.010573f,
0.123695f, 0.197790f, 0.375138f, 0.628216f, 0.149466f, 0.351096f, 0.678921f, 0.566856f, 12.521954f, 18.535747f, 22.686649f, 60.273942f, 0.159782f, 0.147373f, 0.426589f, 0.722272f,
0.012713f, 0.039798f, 0.055663f, 0.093393f, 0.021772f, 0.100123f, 0.142772f, 0.119435f, 2.189123f, 6.343940f, 5.725785f, 15.241474f, 0.024659f, 0.044527f, 0.095045f, 0.161233f,
0.003654f, 0.011489f, 0.007104f, 0.024530f, 0.002928f, 0.013522f, 0.008524f, 0.014675f, 0.705213f, 2.052541f, 0.818999f, 4.486540f, 0.002810f, 0.005096f, 0.004809f, 0.016788f,
0.004872f, 0.013495f, 0.017086f, 0.029444f, 0.004431f, 0.018030f, 0.023275f, 0.019998f, 0.438232f, 1.123710f, 0.918119f, 2.510148f, 0.005657f, 0.009038f, 0.017465f, 0.030430f,
0.004349f, 0.002589f, 0.009106f, 0.034178f, 0.000284f, 0.000248f, 0.000889f, 0.001664f, 0.261060f, 0.143854f, 0.326528f, 1.944455f, 0.003813f, 0.001309f, 0.007028f, 0.026671f,
0.000829f, 0.000966f, 0.002504f, 0.009418f, 0.000077f, 0.000131f, 0.000347f, 0.000650f, 0.084600f, 0.091264f, 0.152763f, 0.911438f, 0.001091f, 0.000733f, 0.002903f, 0.011036f,
0.000576f, 0.000674f, 0.000772f, 0.005978f, 0.000025f, 0.000043f, 0.000050f, 0.000193f, 0.065859f, 0.071356f, 0.052803f, 0.648348f, 0.000300f, 0.000203f, 0.000355f, 0.002777f,
0.001470f, 0.001515f, 0.003558f, 0.013744f, 0.000072f, 0.000109f, 0.000262f, 0.000504f, 0.078391f, 0.074827f, 0.113382f, 0.694804f, 0.001158f, 0.000689f, 0.002469f, 0.009641f,
0.004614f, 0.005782f, 0.015368f, 0.056717f, 0.054227f, 0.099833f, 0.270530f, 0.497802f, 2.088733f, 2.423240f, 4.156285f, 24.336084f, 0.004592f, 0.003320f, 0.013465f, 0.050245f,
0.000229f, 0.000561f, 0.001100f, 0.004068f, 0.003811f, 0.013735f, 0.027446f, 0.050601f, 0.176166f, 0.400117f, 0.506070f, 2.968857f, 0.000342f, 0.000484f, 0.001447f, 0.005411f,
0.000057f, 0.000140f, 0.000122f, 0.000926f, 0.000444f, 0.001608f, 0.001420f, 0.005388f, 0.049183f, 0.112192f, 0.062734f, 0.757387f, 0.000034f, 0.000048f, 0.000063f, 0.000488f,
0.000385f, 0.000837f, 0.001485f, 0.005639f, 0.003410f, 0.010875f, 0.019673f, 0.037251f, 0.155058f, 0.311616f, 0.356790f, 2.149805f, 0.000345f, 0.000432f, 0.001169f, 0.004490f,
0.000001f, 0.000001f, 0.000001f, 0.000022f, 0.000005f, 0.000015f, 0.000018f, 0.000133f, 0.002017f, 0.003646f, 0.002794f, 0.063930f, 0.000001f, 0.000001f, 0.000002f, 0.000029f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000035f, 0.000125f, 0.000071f, 0.001621f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000027f, 0.000095f, 0.000024f, 0.001115f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000001f, 0.000001f, 0.000005f, 0.000073f, 0.000228f, 0.000116f, 0.002742f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000203f, 0.000613f, 0.000980f, 0.006432f, 0.002635f, 0.011668f, 0.019017f, 0.062202f, 0.363820f, 1.015071f, 1.047150f, 10.898956f, 0.000149f, 0.000260f, 0.000633f, 0.004201f,
0.000006f, 0.000036f, 0.000042f, 0.000277f, 0.000111f, 0.000964f, 0.001159f, 0.003797f, 0.018426f, 0.100647f, 0.076565f, 0.798435f, 0.000007f, 0.000023f, 0.000041f, 0.000272f,
0.000001f, 0.000005f, 0.000003f, 0.000036f, 0.000007f, 0.000065f, 0.000035f, 0.000233f, 0.002964f, 0.016262f, 0.005469f, 0.117369f, 0.000000f, 0.000001f, 0.000001f, 0.000014f,
0.000003f, 0.000014f, 0.000015f, 0.000104f, 0.000027f, 0.000206f, 0.000224f, 0.000754f, 0.004376f, 0.021147f, 0.014563f, 0.155981f, 0.000002f, 0.000005f, 0.000009f, 0.000061f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000037f, 0.000038f, 0.000073f, 0.001699f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000007f, 0.000010f, 0.000231f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000003f, 0.000002f, 0.000082f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000007f, 0.000009f, 0.000209f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.007918f, 0.008499f, 0.012931f, 0.099554f, 0.007679f, 0.012108f, 0.018783f, 0.072097f, 2.341719f, 2.326990f, 2.284726f, 27.905854f, 0.006550f, 0.004056f, 0.009417f, 0.073303f,
0.000549f, 0.001153f, 0.001294f, 0.009982f, 0.000754f, 0.002329f, 0.002664f, 0.010245f, 0.276111f, 0.537149f, 0.388911f, 4.759316f, 0.000682f, 0.000826f, 0.001415f, 0.011036f,
0.000144f, 0.000305f, 0.000151f, 0.002400f, 0.000093f, 0.000288f, 0.000146f, 0.001152f, 0.081409f, 0.159062f, 0.050914f, 1.282231f, 0.000071f, 0.000087f, 0.000066f, 0.001052f,
0.000441f, 0.000820f, 0.000833f, 0.006596f, 0.000322f, 0.000879f, 0.000910f, 0.003595f, 0.115849f, 0.199418f, 0.130704f, 1.642823f, 0.000328f, 0.000352f, 0.000545f, 0.004366f,
0.000001f, 0.000001f, 0.000001f, 0.000020f, 0.000000f, 0.000001f, 0.000001f, 0.000010f, 0.001221f, 0.001890f, 0.000829f, 0.039580f, 0.000001f, 0.000001f, 0.000001f, 0.000023f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000030f, 0.000091f, 0.000029f, 0.001403f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000024f, 0.000072f, 0.000010f, 0.001019f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000029f, 0.000079f, 0.000023f, 0.001131f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000307f, 0.000792f, 0.000725f, 0.009921f, 0.000328f, 0.001244f, 0.001160f, 0.007917f, 0.358437f, 0.856582f, 0.505839f, 10.982575f, 0.000187f, 0.000279f, 0.000389f, 0.005386f,
0.000013f, 0.000065f, 0.000044f, 0.000597f, 0.000019f, 0.000144f, 0.000099f, 0.000676f, 0.025379f, 0.118737f, 0.051706f, 1.124783f, 0.000012f, 0.000034f, 0.000035f, 0.000487f,
0.000002f, 0.000010f, 0.000003f, 0.000083f, 0.000001f, 0.000010f, 0.000003f, 0.000044f, 0.004312f, 0.020260f, 0.003900f, 0.174613f, 0.000001f, 0.000002f, 0.000001f, 0.000027f,
0.000003f, 0.000012f, 0.000008f, 0.000106f, 0.000002f, 0.000015f, 0.000009f, 0.000064f, 0.002873f, 0.011893f, 0.004688f, 0.104746f, 0.000002f, 0.000004f, 0.000004f, 0.000052f,
0.000005f, 0.000005f, 0.000009f, 0.000261f, 0.000000f, 0.000000f, 0.000001f, 0.000011f, 0.003610f, 0.003211f, 0.003517f, 0.171156f, 0.000002f, 0.000001f, 0.000003f, 0.000096f,
0.000000f, 0.000001f, 0.000001f, 0.000029f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000474f, 0.000825f, 0.000666f, 0.032493f, 0.000000f, 0.000000f, 0.000001f, 0.000016f,
0.000000f, 0.000000f, 0.000000f, 0.000010f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000195f, 0.000340f, 0.000121f, 0.012190f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000001f, 0.000001f, 0.000024f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000248f, 0.000383f, 0.000280f, 0.014006f, 0.000000f, 0.000000f, 0.000000f, 0.000008f,
0.000487f, 0.000314f, 0.000776f, 0.007221f, 0.030493f, 0.028932f, 0.072757f, 0.337718f, 3.584317f, 2.143061f, 3.411170f, 50.383549f, 0.013263f, 0.004941f, 0.018600f, 0.175076f,
0.000048f, 0.000061f, 0.000110f, 0.001028f, 0.004252f, 0.007899f, 0.014648f, 0.068123f, 0.599912f, 0.702209f, 0.824235f, 12.197456f, 0.001960f, 0.001429f, 0.003967f, 0.037417f,
0.000006f, 0.000008f, 0.000006f, 0.000118f, 0.000251f, 0.000467f, 0.000383f, 0.003667f, 0.084670f, 0.099539f, 0.051652f, 1.573061f, 0.000098f, 0.000072f, 0.000088f, 0.001707f,
0.000023f, 0.000025f, 0.000042f, 0.000400f, 0.001070f, 0.001758f, 0.002951f, 0.014096f, 0.148411f, 0.153711f, 0.163327f, 2.482474f, 0.000556f, 0.000359f, 0.000901f, 0.008727f,
0.000000f, 0.000000f, 0.000000f, 0.000009f, 0.000009f, 0.000014f, 0.000016f, 0.000286f, 0.010970f, 0.010218f, 0.007267f, 0.419417f, 0.000009f, 0.000005f, 0.000009f, 0.000319f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000012f, 0.000382f, 0.000696f, 0.000365f, 0.021099f, 0.000000f, 0.000000f, 0.000000f, 0.000014f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000145f, 0.000266f, 0.000062f, 0.007338f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000221f, 0.000356f, 0.000169f, 0.010034f, 0.000000f, 0.000000f, 0.000000f, 0.000008f,
0.000021f, 0.000032f, 0.000047f, 0.000784f, 0.001420f, 0.003239f, 0.004900f, 0.040428f, 0.598119f, 0.860026f, 0.823349f, 21.617223f, 0.000413f, 0.000370f, 0.000838f, 0.014025f,
0.000001f, 0.000004f, 0.000004f, 0.000067f, 0.000119f, 0.000531f, 0.000592f, 0.004897f, 0.060115f, 0.169223f, 0.119467f, 3.142650f, 0.000037f, 0.000064f, 0.000107f, 0.001800f,
0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000004f, 0.000018f, 0.000009f, 0.000152f, 0.004889f, 0.013822f, 0.004314f, 0.233538f, 0.000001f, 0.000002f, 0.000001f, 0.000047f,
0.000000f, 0.000000f, 0.000000f, 0.000007f, 0.000008f, 0.000032f, 0.000032f, 0.000273f, 0.004012f, 0.009994f, 0.006387f, 0.172558f, 0.000003f, 0.000004f, 0.000007f, 0.000113f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000382f, 0.000204f, 0.000363f, 0.021365f, 0.000000f, 0.000000f, 0.000000f, 0.000016f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000071f, 0.000075f, 0.000098f, 0.005758f, 0.000000f, 0.000000f, 0.000000f, 0.000004f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000014f, 0.000015f, 0.000009f, 0.001034f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000022f, 0.000020f, 0.000024f, 0.001463f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
1.749249f, 1.120095f, 3.425753f, 4.231986f, 1.535411f, 1.444313f, 4.503681f, 2.773909f, 44.361767f, 26.296606f, 51.900643f, 101.719130f, 1.874229f, 0.692254f, 3.231244f, 4.035813f,
0.337731f, 0.423376f, 0.954867f, 1.181854f, 0.420143f, 0.773722f, 1.779128f, 1.097904f, 14.568709f, 16.906857f, 24.606607f, 48.318620f, 0.543365f, 0.392904f, 1.352402f, 1.692389f,
0.143213f, 0.180310f, 0.179784f, 0.457941f, 0.083347f, 0.154155f, 0.156709f, 0.199016f, 6.923678f, 8.069766f, 5.192363f, 20.982843f, 0.091342f, 0.066335f, 0.100944f, 0.259963f,
0.290734f, 0.322486f, 0.658410f, 0.837001f, 0.192081f, 0.312992f, 0.651515f, 0.412943f, 6.551360f, 6.727198f, 8.863221f, 17.875694f, 0.280012f, 0.179156f, 0.558240f, 0.717503f,
0.005635f, 0.005621f, 0.007682f, 0.037083f, 0.003482f, 0.005103f, 0.007110f, 0.017112f, 0.989253f, 0.913534f, 0.805625f, 6.169743f, 0.009149f, 0.005264f, 0.010979f, 0.053583f,
0.000226f, 0.000442f, 0.000445f, 0.002152f, 0.000198f, 0.000568f, 0.000584f, 0.001407f, 0.067509f, 0.122047f, 0.079369f, 0.609004f, 0.000551f, 0.000621f, 0.000955f, 0.004669f,
0.000259f, 0.000507f, 0.000226f, 0.002249f, 0.000106f, 0.000305f, 0.000139f, 0.000688f, 0.086521f, 0.157099f, 0.045166f, 0.713208f, 0.000250f, 0.000283f, 0.000192f, 0.001934f,
0.000455f, 0.000786f, 0.000717f, 0.003561f, 0.000212f, 0.000537f, 0.000499f, 0.001237f, 0.070935f, 0.113472f, 0.066801f, 0.526448f, 0.000664f, 0.000661f, 0.000921f, 0.004625f,
0.117831f, 0.181450f, 0.333781f, 0.732961f, 0.113962f, 0.257805f, 0.483507f, 0.529368f, 11.801297f, 16.823481f, 19.970677f, 69.574990f, 0.093088f, 0.082686f, 0.232135f, 0.515386f,
0.013661f, 0.041185f, 0.055868f, 0.122918f, 0.018726f, 0.082934f, 0.114698f, 0.125819f, 2.327327f, 6.495237f, 5.685749f, 19.846364f, 0.016206f, 0.028182f, 0.058343f, 0.129783f,
0.003338f, 0.010107f, 0.006061f, 0.027444f, 0.002141f, 0.009521f, 0.005821f, 0.013142f, 0.637321f, 1.786398f, 0.691331f, 4.966104f, 0.001570f, 0.002742f, 0.002509f, 0.011487f,
0.003173f, 0.008464f, 0.010393f, 0.023486f, 0.002310f, 0.009051f, 0.011332f, 0.012767f, 0.282353f, 0.697253f, 0.552524f, 1.980857f, 0.002253f, 0.003467f, 0.006497f, 0.014844f,
0.009359f, 0.005365f, 0.018302f, 0.090082f, 0.000489f, 0.000411f, 0.001431f, 0.003511f, 0.555808f, 0.294954f, 0.649338f, 5.070484f, 0.005018f, 0.001659f, 0.008639f, 0.042993f,
0.002011f, 0.002257f, 0.005679f, 0.028003f, 0.000149f, 0.000245f, 0.000629f, 0.001547f, 0.203182f, 0.211088f, 0.342686f, 2.681072f, 0.001619f, 0.001048f, 0.004025f, 0.020068f,
0.001188f, 0.001339f, 0.001489f, 0.015109f, 0.000041f, 0.000068f, 0.000077f, 0.000390f, 0.134456f, 0.140295f, 0.100691f, 1.621211f, 0.000379f, 0.000246f, 0.000418f, 0.004292f,
0.002162f, 0.002147f, 0.004890f, 0.024766f, 0.000085f, 0.000124f, 0.000288f, 0.000727f, 0.114099f, 0.104887f, 0.154143f, 1.238636f, 0.001042f, 0.000597f, 0.002075f, 0.010625f,
0.002548f, 0.003075f, 0.007927f, 0.038363f, 0.023970f, 0.042498f, 0.111694f, 0.269507f, 1.141222f, 1.275065f, 2.121082f, 16.285615f, 0.001551f, 0.001080f, 0.004248f, 0.020785f,
0.000143f, 0.000337f, 0.000640f, 0.003104f, 0.001900f, 0.006596f, 0.012783f, 0.030903f, 0.108577f, 0.237494f, 0.291336f, 2.241162f, 0.000130f, 0.000178f, 0.000515f, 0.002525f,
0.000030f, 0.000072f, 0.000060f, 0.000601f, 0.000188f, 0.000656f, 0.000562f, 0.002797f, 0.025768f, 0.056608f, 0.030700f, 0.486017f, 0.000011f, 0.000015f, 0.000019f, 0.000194f,
0.000146f, 0.000304f, 0.000524f, 0.002607f, 0.001030f, 0.003165f, 0.005553f, 0.013788f, 0.057918f, 0.112095f, 0.124479f, 0.983519f, 0.000080f, 0.000096f, 0.000252f, 0.001270f,
0.000000f, 0.000001f, 0.000001f, 0.000016f, 0.000003f, 0.000007f, 0.000008f, 0.000080f, 0.001225f, 0.002133f, 0.001585f, 0.047561f, 0.000000f, 0.000000f, 0.000001f, 0.000013f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000024f, 0.000083f, 0.000045f, 0.001360f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000016f, 0.000053f, 0.000013f, 0.000795f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000030f, 0.000091f, 0.000045f, 0.001395f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000139f, 0.000404f, 0.000627f, 0.005393f, 0.001444f, 0.006158f, 0.009734f, 0.041749f, 0.246433f, 0.662151f, 0.662501f, 9.041985f, 0.000063f, 0.000105f, 0.000248f, 0.002155f,
0.000005f, 0.000027f, 0.000030f, 0.000262f, 0.000069f, 0.000574f, 0.000669f, 0.002875f, 0.014079f, 0.074062f, 0.054643f, 0.747220f, 0.000003f, 0.000010f, 0.000018f, 0.000157f,
0.000001f, 0.000003f, 0.000002f, 0.000029f, 0.000004f, 0.000033f, 0.000017f, 0.000150f, 0.001925f, 0.010172f, 0.003318f, 0.093371f, 0.000000f, 0.000001f, 0.000000f, 0.000007f,
0.000001f, 0.000006f, 0.000007f, 0.000059f, 0.000010f, 0.000074f, 0.000078f, 0.000346f, 0.002026f, 0.009431f, 0.006299f, 0.088467f, 0.000001f, 0.000002f, 0.000002f, 0.000021f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000056f, 0.000056f, 0.000104f, 0.003185f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000012f, 0.000016f, 0.000488f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000004f, 0.000002f, 0.000147f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000007f, 0.000008f, 0.000267f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.068940f, 0.107256f, 0.112069f, 0.763365f, 0.132477f, 0.302777f, 0.322545f, 1.095401f, 5.449895f, 7.849200f, 5.292483f, 57.193660f, 0.083617f, 0.075039f, 0.119660f, 0.824080f,
0.005469f, 0.016658f, 0.012835f, 0.087597f, 0.014895f, 0.066648f, 0.052356f, 0.178150f, 0.735429f, 2.073619f, 1.031048f, 11.163492f, 0.009961f, 0.017500f, 0.020579f, 0.141997f,
0.002267f, 0.006934f, 0.002362f, 0.033172f, 0.002888f, 0.012978f, 0.004507f, 0.031561f, 0.341582f, 0.967309f, 0.212633f, 4.737923f, 0.001637f, 0.002888f, 0.001501f, 0.021317f,
0.009088f, 0.024492f, 0.017084f, 0.119747f, 0.013145f, 0.052041f, 0.037008f, 0.129337f, 0.638355f, 1.592618f, 0.716853f, 7.971863f, 0.009908f, 0.015403f, 0.016397f, 0.116202f,
0.000008f, 0.000020f, 0.000009f, 0.000248f, 0.000011f, 0.000040f, 0.000019f, 0.000250f, 0.004505f, 0.010107f, 0.003045f, 0.128580f, 0.000015f, 0.000021f, 0.000015f, 0.000406f,
0.000000f, 0.000001f, 0.000000f, 0.000006f, 0.000000f, 0.000002f, 0.000001f, 0.000008f, 0.000126f, 0.000555f, 0.000123f, 0.005215f, 0.000000f, 0.000001f, 0.000001f, 0.000015f,
0.000000f, 0.000001f, 0.000000f, 0.000006f, 0.000000f, 0.000001f, 0.000000f, 0.000004f, 0.000158f, 0.000698f, 0.000069f, 0.005969f, 0.000000f, 0.000000f, 0.000000f, 0.000006f,
0.000001f, 0.000002f, 0.000001f, 0.000019f, 0.000001f, 0.000003f, 0.000001f, 0.000014f, 0.000256f, 0.000996f, 0.000200f, 0.008702f, 0.000001f, 0.000002f, 0.000001f, 0.000028f,
0.001892f, 0.007079f, 0.004449f, 0.053868f, 0.004006f, 0.022020f, 0.014109f, 0.085173f, 0.590708f, 2.046002f, 0.829744f, 15.939069f, 0.001692f, 0.003652f, 0.003503f, 0.042878f,
0.000090f, 0.000660f, 0.000306f, 0.003712f, 0.000271f, 0.002911f, 0.001375f, 0.008318f, 0.047868f, 0.324583f, 0.097069f, 1.868233f, 0.000121f, 0.000511f, 0.000362f, 0.004437f,
0.000022f, 0.000158f, 0.000032f, 0.000810f, 0.000030f, 0.000327f, 0.000068f, 0.000849f, 0.012811f, 0.087246f, 0.011535f, 0.456882f, 0.000011f, 0.000049f, 0.000015f, 0.000384f,
0.000040f, 0.000262f, 0.000110f, 0.001369f, 0.000064f, 0.000613f, 0.000262f, 0.001629f, 0.011210f, 0.067256f, 0.018208f, 0.359927f, 0.000032f, 0.000121f, 0.000078f, 0.000980f,
0.000060f, 0.000083f, 0.000097f, 0.002639f, 0.000007f, 0.000014f, 0.000017f, 0.000225f, 0.011090f, 0.014300f, 0.010755f, 0.463059f, 0.000036f, 0.000029f, 0.000052f, 0.001426f,
0.000005f, 0.000014f, 0.000012f, 0.000337f, 0.000001f, 0.000003f, 0.000003f, 0.000041f, 0.001666f, 0.004205f, 0.002332f, 0.100609f, 0.000005f, 0.000008f, 0.000010f, 0.000273f,
0.000003f, 0.000008f, 0.000003f, 0.000178f, 0.000000f, 0.000001f, 0.000000f, 0.000010f, 0.001077f, 0.002731f, 0.000670f, 0.059457f, 0.000001f, 0.000002f, 0.000001f, 0.000057f,
0.000011f, 0.000026f, 0.000021f, 0.000575f, 0.000001f, 0.000003f, 0.000003f, 0.000037f, 0.001806f, 0.004033f, 0.002025f, 0.089719f, 0.000006f, 0.000008f, 0.000010f, 0.000279f,
0.005100f, 0.004774f, 0.008087f, 0.066611f, 0.632926f, 0.870370f, 1.503144f, 6.173163f, 10.035947f, 8.696888f, 9.506641f, 124.233770f, 0.203693f, 0.109985f, 0.284334f, 2.367955f,
0.000574f, 0.001053f, 0.001315f, 0.010850f, 0.101018f, 0.271956f, 0.346347f, 1.425120f, 1.922393f, 3.261362f, 2.628921f, 34.420970f, 0.034444f, 0.036411f, 0.069412f, 0.579180f,
0.000114f, 0.000210f, 0.000116f, 0.001967f, 0.009375f, 0.025349f, 0.014272f, 0.120856f, 0.427416f, 0.728266f, 0.259528f, 6.993037f, 0.002709f, 0.002876f, 0.002424f, 0.041622f,
0.000563f, 0.000912f, 0.001032f, 0.008745f, 0.052561f, 0.125207f, 0.144348f, 0.610039f, 0.983861f, 1.476900f, 1.077701f, 14.492809f, 0.020202f, 0.018895f, 0.032609f, 0.279459f,
0.000004f, 0.000005f, 0.000004f, 0.000127f, 0.000312f, 0.000669f, 0.000516f, 0.008284f, 0.048685f, 0.065724f, 0.032101f, 1.639230f, 0.000216f, 0.000182f, 0.000210f, 0.006839f,
0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000010f, 0.000043f, 0.000025f, 0.000397f, 0.001938f, 0.005122f, 0.001845f, 0.094377f, 0.000008f, 0.000013f, 0.000011f, 0.000348f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000003f, 0.000011f, 0.000003f, 0.000091f, 0.001162f, 0.003084f, 0.000491f, 0.051707f, 0.000002f, 0.000003f, 0.000001f, 0.000067f,
0.000000f, 0.000000f, 0.000000f, 0.000008f, 0.000013f, 0.000047f, 0.000024f, 0.000397f, 0.002317f, 0.005419f, 0.001767f, 0.092850f, 0.000010f, 0.000015f, 0.000012f, 0.000392f,
0.000153f, 0.000344f, 0.000350f, 0.005124f, 0.020867f, 0.069008f, 0.071681f, 0.523287f, 1.185894f, 2.471424f, 1.624853f, 37.744795f, 0.004494f, 0.005835f, 0.009073f, 0.134320f,
0.000010f, 0.000045f, 0.000034f, 0.000501f, 0.002000f, 0.012948f, 0.009918f, 0.072544f, 0.136410f, 0.556542f, 0.269824f, 6.279953f, 0.000456f, 0.001160f, 0.001330f, 0.019729f,
0.000001f, 0.000005f, 0.000002f, 0.000052f, 0.000107f, 0.000695f, 0.000236f, 0.003545f, 0.017476f, 0.071610f, 0.015349f, 0.735164f, 0.000021f, 0.000053f, 0.000027f, 0.000817f,
0.000003f, 0.000011f, 0.000007f, 0.000109f, 0.000281f, 0.001608f, 0.001115f, 0.008378f, 0.018835f, 0.067994f, 0.029842f, 0.713361f, 0.000072f, 0.000162f, 0.000169f, 0.002568f,
0.000000f, 0.000000f, 0.000000f, 0.000016f, 0.000002f, 0.000003f, 0.000005f, 0.000088f, 0.001412f, 0.001095f, 0.001336f, 0.069543f, 0.000006f, 0.000003f, 0.000009f, 0.000283f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000001f, 0.000001f, 0.000023f, 0.000301f, 0.000457f, 0.000411f, 0.021448f, 0.000001f, 0.000001f, 0.000002f, 0.000077f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000093f, 0.000142f, 0.000057f, 0.006067f, 0.000000f, 0.000000f, 0.000000f, 0.000008f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000001f, 0.000001f, 0.000012f, 0.000192f, 0.000259f, 0.000210f, 0.011277f, 0.000001f, 0.000001f, 0.000001f, 0.000046f,
10.030623f, 9.309129f, 19.552601f, 21.370745f, 17.445536f, 23.784745f, 50.933032f, 27.755622f, 67.993187f, 58.416260f, 79.177418f, 137.296140f, 15.757024f, 8.435193f, 27.039182f, 29.880098f,
2.216414f, 4.027012f, 6.237263f, 6.830342f, 5.463364f, 14.582276f, 23.027246f, 12.572636f, 25.555280f, 42.983350f, 42.961887f, 74.640287f, 5.228131f, 5.479217f, 12.951873f, 14.340162f,
1.480568f, 2.701735f, 1.849989f, 4.169210f, 1.707327f, 4.576822f, 3.195185f, 3.590186f, 19.132096f, 32.319465f, 14.281130f, 51.060985f, 1.384490f, 1.457283f, 1.522907f, 3.470015f,
3.947199f, 6.345737f, 8.897366f, 10.007329f, 5.167272f, 12.203577f, 17.445060f, 9.782852f, 23.774144f, 35.382219f, 32.013772f, 57.126176f, 5.573728f, 5.168662f, 11.060153f, 12.577405f,
0.051219f, 0.074053f, 0.069498f, 0.296819f, 0.062713f, 0.133199f, 0.127449f, 0.271389f, 2.403297f, 3.216639f, 1.948072f, 13.199778f, 0.121913f, 0.101671f, 0.145624f, 0.628817f,
0.002352f, 0.006657f, 0.004607f, 0.019713f, 0.004081f, 0.016969f, 0.011973f, 0.025545f, 0.187700f, 0.491824f, 0.219648f, 1.491154f, 0.008406f, 0.013723f, 0.014495f, 0.062710f,
0.004237f, 0.012044f, 0.003685f, 0.032450f, 0.003439f, 0.014363f, 0.004480f, 0.019672f, 0.378959f, 0.997287f, 0.196904f, 2.750962f, 0.006003f, 0.009843f, 0.004596f, 0.040922f,
0.009786f, 0.024510f, 0.015355f, 0.067487f, 0.009019f, 0.033183f, 0.021195f, 0.046445f, 0.408014f, 0.945980f, 0.382445f, 2.666685f, 0.020939f, 0.030249f, 0.028922f, 0.128517f,
0.478455f, 1.067868f, 1.349015f, 2.620974f, 0.916909f, 3.006324f, 3.872046f, 3.750789f, 12.808327f, 26.464059f, 21.573860f, 66.499051f, 0.554182f, 0.713458f, 1.375533f, 2.702029f,
0.063486f, 0.277401f, 0.258418f, 0.503038f, 0.172432f, 1.106823f, 1.051233f, 1.020267f, 2.890836f, 11.693339f, 7.029520f, 21.709316f, 0.110418f, 0.278297f, 0.395663f, 0.778714f,
0.024437f, 0.107239f, 0.044165f, 0.176928f, 0.031050f, 0.200171f, 0.084050f, 0.167876f, 1.247069f, 5.066263f, 1.346450f, 8.557502f, 0.016849f, 0.042650f, 0.026807f, 0.108578f,
0.030503f, 0.117932f, 0.099452f, 0.198839f, 0.043999f, 0.249899f, 0.214859f, 0.214179f, 0.725557f, 2.596854f, 1.413198f, 4.482619f, 0.031759f, 0.070826f, 0.091155f, 0.184263f,
0.070841f, 0.058858f, 0.137893f, 0.600492f, 0.007327f, 0.008943f, 0.021362f, 0.046381f, 1.124536f, 0.864927f, 1.307649f, 9.034351f, 0.055693f, 0.026691f, 0.095433f, 0.420183f,
0.017424f, 0.028342f, 0.048964f, 0.213637f, 0.002554f, 0.006103f, 0.010751f, 0.023386f, 0.470475f, 0.708424f, 0.789806f, 5.467127f, 0.020569f, 0.019299f, 0.050885f, 0.224470f,
0.016207f, 0.026477f, 0.020223f, 0.181581f, 0.001111f, 0.002667f, 0.002077f, 0.009299f, 0.490455f, 0.741718f, 0.365579f, 5.207827f, 0.007585f, 0.007147f, 0.008331f, 0.075634f,
0.038751f, 0.055771f, 0.087224f, 0.390877f, 0.003017f, 0.006378f, 0.010171f, 0.022724f, 0.546571f, 0.728224f, 0.734955f, 5.225260f, 0.027385f, 0.022734f, 0.054263f, 0.245856f,
0.023394f, 0.040922f, 0.072444f, 0.310194f, 0.436082f, 1.120607f, 2.022584f, 4.317926f, 2.800738f, 4.535365f, 5.181218f, 35.197017f, 0.020879f, 0.021067f, 0.056917f, 0.246405f,
0.001498f, 0.005128f, 0.006695f, 0.028722f, 0.039564f, 0.199039f, 0.264915f, 0.566640f, 0.304961f, 0.966798f, 0.814462f, 5.543422f, 0.002007f, 0.003964f, 0.007898f, 0.034259f,
0.000500f, 0.001718f, 0.000992f, 0.008755f, 0.006174f, 0.031196f, 0.018356f, 0.080803f, 0.114013f, 0.363018f, 0.135201f, 1.893749f, 0.000265f, 0.000527f, 0.000464f, 0.004140f,
0.003164f, 0.009586f, 0.011329f, 0.049917f, 0.044388f, 0.197588f, 0.238066f, 0.523008f, 0.336535f, 0.944021f, 0.719922f, 5.032701f, 0.002538f, 0.004436f, 0.008001f, 0.035643f,
0.000006f, 0.000016f, 0.000012f, 0.000207f, 0.000075f, 0.000302f, 0.000244f, 0.002033f, 0.004766f, 0.012024f, 0.006138f, 0.162929f, 0.000008f, 0.000012f, 0.000015f, 0.000250f,
0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000001f, 0.000011f, 0.000007f, 0.000055f, 0.000108f, 0.000533f, 0.000200f, 0.005332f, 0.000000f, 0.000000f, 0.000000f, 0.000007f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000001f, 0.000005f, 0.000001f, 0.000021f, 0.000109f, 0.000539f, 0.000090f, 0.004912f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000002f, 0.000001f, 0.000016f, 0.000004f, 0.000026f, 0.000014f, 0.000120f, 0.000278f, 0.001215f, 0.000414f, 0.011312f, 0.000000f, 0.000001f, 0.000001f, 0.000018f,
0.000906f, 0.003810f, 0.004057f, 0.030881f, 0.018605f, 0.114974f, 0.124812f, 0.473648f, 0.428261f, 1.667798f, 1.145954f, 13.837949f, 0.000596f, 0.001446f, 0.002350f, 0.018087f,
0.000035f, 0.000287f, 0.000225f, 0.001717f, 0.001014f, 0.012263f, 0.009817f, 0.037325f, 0.028002f, 0.213493f, 0.108174f, 1.308758f, 0.000034f, 0.000163f, 0.000196f, 0.001510f,
0.000007f, 0.000055f, 0.000019f, 0.000302f, 0.000091f, 0.001108f, 0.000392f, 0.003067f, 0.006032f, 0.046191f, 0.010347f, 0.257626f, 0.000003f, 0.000013f, 0.000007f, 0.000105f,
0.000020f, 0.000145f, 0.000103f, 0.000805f, 0.000307f, 0.003284f, 0.002380f, 0.009295f, 0.008337f, 0.056241f, 0.025796f, 0.320558f, 0.000012f, 0.000049f, 0.000054f, 0.000424f,
0.000001f, 0.000001f, 0.000002f, 0.000034f, 0.000001f, 0.000002f, 0.000003f, 0.000028f, 0.000182f, 0.000263f, 0.000336f, 0.009086f, 0.000000f, 0.000000f, 0.000001f, 0.000014f,
0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000022f, 0.000063f, 0.000059f, 0.001593f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000011f, 0.000033f, 0.000014f, 0.000758f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000008f, 0.000000f, 0.000000f, 0.000001f, 0.000005f, 0.000030f, 0.000076f, 0.000065f, 0.001806f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.006535f, 0.007605f, 0.009122f, 0.119356f, 0.009773f, 0.016707f, 0.020432f, 0.133286f, 1.965775f, 2.117584f, 1.639182f, 34.026089f, 0.006017f, 0.004038f, 0.007393f, 0.097801f,
0.000446f, 0.001015f, 0.000898f, 0.011772f, 0.000944f, 0.003161f, 0.002851f, 0.018631f, 0.227997f, 0.480825f, 0.274466f, 5.708296f, 0.000616f, 0.000809f, 0.001093f, 0.014484f,
0.000112f, 0.000256f, 0.000100f, 0.002704f, 0.000111f, 0.000373f, 0.000149f, 0.002002f, 0.064239f, 0.136062f, 0.034336f, 1.469629f, 0.000061f, 0.000081f, 0.000048f, 0.001319f,
0.000547f, 0.001103f, 0.000884f, 0.011896f, 0.000616f, 0.001824f, 0.001490f, 0.009999f, 0.146298f, 0.272997f, 0.141068f, 3.013388f, 0.000453f, 0.000527f, 0.000644f, 0.008762f,
0.000000f, 0.000001f, 0.000000f, 0.000014f, 0.000000f, 0.000001f, 0.000000f, 0.000011f, 0.000588f, 0.000987f, 0.000341f, 0.027684f, 0.000000f, 0.000000f, 0.000000f, 0.000017f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000014f, 0.000047f, 0.000012f, 0.000965f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000011f, 0.000036f, 0.000004f, 0.000670f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000021f, 0.000062f, 0.000014f, 0.001190f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000202f, 0.000565f, 0.000408f, 0.009485f, 0.000333f, 0.001368f, 0.001006f, 0.011671f, 0.239942f, 0.621596f, 0.289400f, 10.678587f, 0.000137f, 0.000221f, 0.000244f, 0.005731f,
0.000008f, 0.000045f, 0.000024f, 0.000562f, 0.000019f, 0.000155f, 0.000084f, 0.000980f, 0.016712f, 0.084756f, 0.029099f, 1.075781f, 0.000008f, 0.000027f, 0.000022f, 0.000510f,
0.000001f, 0.000007f, 0.000002f, 0.000074f, 0.000001f, 0.000011f, 0.000003f, 0.000061f, 0.002713f, 0.013820f, 0.002098f, 0.159592f, 0.000000f, 0.000002f, 0.000001f, 0.000027f,
0.000003f, 0.000013f, 0.000006f, 0.000153f, 0.000003f, 0.000024f, 0.000012f, 0.000142f, 0.002893f, 0.012983f, 0.004035f, 0.153213f, 0.000002f, 0.000005f, 0.000003f, 0.000083f,
0.000001f, 0.000001f, 0.000002f, 0.000105f, 0.000000f, 0.000000f, 0.000000f, 0.000007f, 0.001014f, 0.000978f, 0.000844f, 0.069830f, 0.000001f, 0.000000f, 0.000001f, 0.000043f,
0.000000f, 0.000000f, 0.000000f, 0.000011f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000131f, 0.000247f, 0.000157f, 0.013040f, 0.000000f, 0.000000f, 0.000000f, 0.000007f,
0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000051f, 0.000097f, 0.000027f, 0.004675f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000014f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000105f, 0.000175f, 0.000101f, 0.008596f, 0.000000f, 0.000000f, 0.000000f, 0.000005f,
0.000458f, 0.000320f, 0.000623f, 0.009860f, 0.044204f, 0.045465f, 0.090143f, 0.711106f, 3.427032f, 2.221229f, 2.787462f, 69.970954f, 0.013875f, 0.005604f, 0.016631f, 0.266049f,
0.000044f, 0.000061f, 0.000087f, 0.001380f, 0.006064f, 0.012210f, 0.017852f, 0.141098f, 0.564215f, 0.715930f, 0.662525f, 16.662633f, 0.002017f, 0.001594f, 0.003490f, 0.055930f,
0.000005f, 0.000007f, 0.000005f, 0.000152f, 0.000341f, 0.000690f, 0.000446f, 0.007259f, 0.076097f, 0.096978f, 0.039675f, 2.053523f, 0.000096f, 0.000076f, 0.000074f, 0.002438f,
0.000032f, 0.000039f, 0.000051f, 0.000822f, 0.002332f, 0.004156f, 0.005500f, 0.044649f, 0.213464f, 0.239669f, 0.200776f, 5.186346f, 0.000874f, 0.000612f, 0.001212f, 0.019950f,
0.000000f, 0.000000f, 0.000000f, 0.000007f, 0.000008f, 0.000013f, 0.000011f, 0.000345f, 0.006016f, 0.006075f, 0.003406f, 0.334120f, 0.000005f, 0.000003f, 0.000004f, 0.000278f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000014f, 0.000206f, 0.000407f, 0.000168f, 0.016534f, 0.000000f, 0.000000f, 0.000000f, 0.000012f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000075f, 0.000149f, 0.000027f, 0.005495f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000011f, 0.000182f, 0.000318f, 0.000119f, 0.012025f, 0.000000f, 0.000000f, 0.000000f, 0.000010f,
0.000015f, 0.000026f, 0.000030f, 0.000854f, 0.001641f, 0.004059f, 0.004841f, 0.067882f, 0.456029f, 0.710826f, 0.536516f, 23.939884f, 0.000345f, 0.000335f, 0.000598f, 0.016995f,
0.000001f, 0.000003f, 0.000003f, 0.000072f, 0.000135f, 0.000655f, 0.000576f, 0.008088f, 0.045085f, 0.137580f, 0.076576f, 3.423448f, 0.000030f, 0.000057f, 0.000075f, 0.002145f,
0.000000f, 0.000000f, 0.000000f, 0.000005f, 0.000004f, 0.000021f, 0.000008f, 0.000240f, 0.003504f, 0.010739f, 0.002642f, 0.243111f, 0.000001f, 0.000002f, 0.000001f, 0.000054f,
0.000000f, 0.000001f, 0.000000f, 0.000012f, 0.000014f, 0.000060f, 0.000048f, 0.000691f, 0.004602f, 0.012426f, 0.006261f, 0.287479f, 0.000004f, 0.000006f, 0.000007f, 0.000206f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000122f, 0.000071f, 0.000099f, 0.009928f, 0.000000f, 0.000000f, 0.000000f, 0.000008f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000022f, 0.000025f, 0.000026f, 0.002632f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000005f, 0.000002f, 0.000452f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000011f, 0.000011f, 0.000010f, 0.001023f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
1.953789f, 1.356214f, 3.270213f, 6.865748f, 2.644444f, 2.696611f, 6.629360f, 6.939361f, 50.392641f, 32.382087f, 50.387742f, 167.833310f, 2.329629f, 0.932776f, 3.432639f, 7.286399f,
0.371059f, 0.504249f, 0.896620f, 1.886049f, 0.711791f, 1.420978f, 2.576063f, 2.701701f, 16.278884f, 20.479235f, 23.498994f, 78.421591f, 0.664357f, 0.520766f, 1.413219f, 3.005574f,
0.150360f, 0.205219f, 0.161323f, 0.698357f, 0.134934f, 0.270545f, 0.216832f, 0.467995f, 7.392990f, 9.340955f, 4.738514f, 32.543545f, 0.106723f, 0.084020f, 0.100801f, 0.441182f,
0.488506f, 0.587398f, 0.945506f, 2.042760f, 0.497671f, 0.879100f, 1.442700f, 1.554050f, 11.195345f, 12.461984f, 12.944685f, 44.369664f, 0.523588f, 0.363155f, 0.892127f, 1.948736f,
0.003611f, 0.003904f, 0.004207f, 0.034510f, 0.003440f, 0.005465f, 0.006003f, 0.024555f, 0.644605f, 0.645295f, 0.448656f, 5.839439f, 0.006523f, 0.004069f, 0.006690f, 0.055493f,
0.000142f, 0.000302f, 0.000240f, 0.001970f, 0.000192f, 0.000598f, 0.000485f, 0.001987f, 0.043271f, 0.084802f, 0.043479f, 0.566982f, 0.000387f, 0.000472f, 0.000572f, 0.004757f,
0.000156f, 0.000331f, 0.000116f, 0.001967f, 0.000098f, 0.000307f, 0.000110f, 0.000928f, 0.052995f, 0.104311f, 0.023644f, 0.634519f, 0.000167f, 0.000205f, 0.000110f, 0.001883f,
0.000438f, 0.000821f, 0.000591f, 0.004985f, 0.000314f, 0.000865f, 0.000634f, 0.002670f, 0.069533f, 0.120578f, 0.055964f, 0.749562f, 0.000712f, 0.000769f, 0.000844f, 0.007206f,
0.104949f, 0.175196f, 0.254083f, 0.948239f, 0.156518f, 0.383833f, 0.567544f, 1.056034f, 10.690077f, 16.520164f, 15.461020f, 91.542361f, 0.092268f, 0.088846f, 0.196649f, 0.742006f,
0.011969f, 0.039116f, 0.041833f, 0.156422f, 0.025299f, 0.121458f, 0.132434f, 0.246895f, 2.073741f, 6.273920f, 4.329906f, 25.685934f, 0.015801f, 0.029786f, 0.048617f, 0.183797f,
0.002795f, 0.009173f, 0.004337f, 0.033374f, 0.002763f, 0.013325f, 0.006423f, 0.024643f, 0.542669f, 1.648927f, 0.503102f, 6.141993f, 0.001463f, 0.002769f, 0.001998f, 0.015546f,
0.004251f, 0.012293f, 0.011902f, 0.045707f, 0.004772f, 0.020272f, 0.020010f, 0.038315f, 0.384761f, 1.029998f, 0.643494f, 3.920756f, 0.003360f, 0.005604f, 0.008280f, 0.032150f,
0.003498f, 0.002174f, 0.005846f, 0.048901f, 0.000282f, 0.000257f, 0.000705f, 0.002939f, 0.211258f, 0.121532f, 0.210937f, 2.799339f, 0.002087f, 0.000748f, 0.003071f, 0.025972f,
0.000739f, 0.000900f, 0.001784f, 0.014953f, 0.000084f, 0.000151f, 0.000305f, 0.001274f, 0.075966f, 0.085555f, 0.109503f, 1.455996f, 0.000663f, 0.000465f, 0.001407f, 0.011925f,
0.000417f, 0.000510f, 0.000447f, 0.007710f, 0.000022f, 0.000040f, 0.000036f, 0.000307f, 0.048039f, 0.054338f, 0.030747f, 0.841338f, 0.000148f, 0.000104f, 0.000140f, 0.002437f,
0.001216f, 0.001309f, 0.002350f, 0.020224f, 0.000074f, 0.000116f, 0.000213f, 0.000915f, 0.065241f, 0.065014f, 0.075328f, 1.028720f, 0.000652f, 0.000405f, 0.001109f, 0.009656f,
0.002545f, 0.003330f, 0.006768f, 0.055670f, 0.036926f, 0.070973f, 0.147061f, 0.603063f, 1.159560f, 1.404437f, 1.841935f, 24.035034f, 0.001724f, 0.001301f, 0.004036f, 0.033566f,
0.000140f, 0.000359f, 0.000538f, 0.004430f, 0.002879f, 0.010835f, 0.016555f, 0.068020f, 0.108519f, 0.257317f, 0.248860f, 3.253562f, 0.000142f, 0.000210f, 0.000481f, 0.004011f,
0.000028f, 0.000073f, 0.000048f, 0.000819f, 0.000273f, 0.001030f, 0.000696f, 0.005884f, 0.024611f, 0.058610f, 0.025060f, 0.674244f, 0.000011f, 0.000017f, 0.000017f, 0.000294f,
0.000219f, 0.000496f, 0.000673f, 0.005692f, 0.002388f, 0.007951f, 0.010998f, 0.046412f, 0.088528f, 0.185739f, 0.162614f, 2.183589f, 0.000133f, 0.000174f, 0.000361f, 0.003085f,
0.000000f, 0.000000f, 0.000000f, 0.000013f, 0.000002f, 0.000007f, 0.000006f, 0.000103f, 0.000714f, 0.001348f, 0.000790f, 0.040264f, 0.000000f, 0.000000f, 0.000000f, 0.000012f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000014f, 0.000051f, 0.000022f, 0.001133f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000008f, 0.000032f, 0.000006f, 0.000633f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000026f, 0.000087f, 0.000034f, 0.001776f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000111f, 0.000349f, 0.000427f, 0.006241f, 0.001774f, 0.008200f, 0.010220f, 0.074495f, 0.199671f, 0.581595f, 0.458771f, 10.641363f, 0.000055f, 0.000101f, 0.000188f, 0.002775f,
0.000004f, 0.000023f, 0.000020f, 0.000298f, 0.000083f, 0.000752f, 0.000691f, 0.005046f, 0.011221f, 0.063989f, 0.037221f, 0.865022f, 0.000003f, 0.000010f, 0.000013f, 0.000199f,
0.000000f, 0.000003f, 0.000001f, 0.000032f, 0.000005f, 0.000041f, 0.000017f, 0.000252f, 0.001466f, 0.008398f, 0.002160f, 0.103293f, 0.000000f, 0.000000f, 0.000000f, 0.000008f,
0.000002f, 0.000008f, 0.000007f, 0.000103f, 0.000019f, 0.000149f, 0.000124f, 0.000929f, 0.002470f, 0.012461f, 0.006562f, 0.156626f, 0.000001f, 0.000002f, 0.000003f, 0.000041f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000019f, 0.000021f, 0.000030f, 0.001573f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000004f, 0.000005f, 0.000237f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000001f, 0.000068f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000004f, 0.000004f, 0.000199f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.002908f, 0.005136f, 0.004755f, 0.056567f, 0.005034f, 0.013058f, 0.012327f, 0.073113f, 1.307874f, 2.137928f, 1.277357f, 24.108343f, 0.006362f, 0.006480f, 0.009156f, 0.110126f,
0.000112f, 0.000387f, 0.000264f, 0.003148f, 0.000274f, 0.001394f, 0.000970f, 0.005766f, 0.085586f, 0.273895f, 0.120675f, 2.281949f, 0.000368f, 0.000733f, 0.000764f, 0.009202f,
0.000031f, 0.000107f, 0.000032f, 0.000789f, 0.000035f, 0.000180f, 0.000055f, 0.000677f, 0.026326f, 0.084613f, 0.016481f, 0.641378f, 0.000040f, 0.000080f, 0.000037f, 0.000915f,
0.000205f, 0.000627f, 0.000388f, 0.004744f, 0.000267f, 0.001200f, 0.000756f, 0.004615f, 0.081905f, 0.231926f, 0.092502f, 1.796593f, 0.000403f, 0.000711f, 0.000671f, 0.008302f,
0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000223f, 0.000567f, 0.000151f, 0.011168f, 0.000000f, 0.000000f, 0.000000f, 0.000011f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000015f, 0.000003f, 0.000220f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000013f, 0.000001f, 0.000166f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000007f, 0.000030f, 0.000005f, 0.000404f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000050f, 0.000213f, 0.000118f, 0.002503f, 0.000095f, 0.000596f, 0.000338f, 0.003565f, 0.088897f, 0.349468f, 0.125583f, 4.213239f, 0.000081f, 0.000198f, 0.000168f, 0.003593f,
0.000001f, 0.000010f, 0.000004f, 0.000084f, 0.000003f, 0.000038f, 0.000016f, 0.000169f, 0.003493f, 0.026885f, 0.007124f, 0.239481f, 0.000003f, 0.000013f, 0.000008f, 0.000180f,
0.000000f, 0.000002f, 0.000000f, 0.000012f, 0.000000f, 0.000003f, 0.000001f, 0.000011f, 0.000619f, 0.004786f, 0.000561f, 0.038785f, 0.000000f, 0.000001f, 0.000000f, 0.000010f,
0.000001f, 0.000004f, 0.000002f, 0.000034f, 0.000001f, 0.000009f, 0.000003f, 0.000036f, 0.000902f, 0.006142f, 0.001473f, 0.050867f, 0.000001f, 0.000004f, 0.000002f, 0.000044f,
0.000000f, 0.000001f, 0.000001f, 0.000025f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000338f, 0.000495f, 0.000330f, 0.024797f, 0.000000f, 0.000000f, 0.000001f, 0.000024f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000025f, 0.000071f, 0.000035f, 0.002613f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000011f, 0.000030f, 0.000007f, 0.001023f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000029f, 0.000075f, 0.000033f, 0.002569f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000175f, 0.000186f, 0.000280f, 0.004022f, 0.019598f, 0.030588f, 0.046810f, 0.335747f, 1.962550f, 1.930263f, 1.869667f, 42.672059f, 0.012628f, 0.007739f, 0.017728f, 0.257857f,
0.000010f, 0.000020f, 0.000022f, 0.000318f, 0.001517f, 0.004635f, 0.005230f, 0.037587f, 0.182302f, 0.351025f, 0.250727f, 5.733420f, 0.001036f, 0.001242f, 0.002099f, 0.030585f,
0.000001f, 0.000003f, 0.000001f, 0.000038f, 0.000093f, 0.000286f, 0.000143f, 0.002111f, 0.026842f, 0.051910f, 0.016392f, 0.771394f, 0.000054f, 0.000065f, 0.000049f, 0.001456f,
0.000010f, 0.000019f, 0.000019f, 0.000282f, 0.000870f, 0.002353f, 0.002403f, 0.017739f, 0.102865f, 0.175256f, 0.113320f, 2.661500f, 0.000670f, 0.000711f, 0.001087f, 0.016270f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000002f, 0.000005f, 0.000003f, 0.000093f, 0.001962f, 0.003006f, 0.001301f, 0.116016f, 0.000003f, 0.000003f, 0.000003f, 0.000153f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000038f, 0.000114f, 0.000036f, 0.003239f, 0.000000f, 0.000000f, 0.000000f, 0.000004f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000015f, 0.000045f, 0.000006f, 0.001175f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000050f, 0.000133f, 0.000038f, 0.003513f, 0.000000f, 0.000000f, 0.000000f, 0.000005f,
0.000003f, 0.000008f, 0.000008f, 0.000194f, 0.000405f, 0.001521f, 0.001400f, 0.017848f, 0.145426f, 0.343980f, 0.200394f, 8.130085f, 0.000175f, 0.000257f, 0.000355f, 0.009172f,
0.000000f, 0.000001f, 0.000000f, 0.000009f, 0.000019f, 0.000138f, 0.000094f, 0.001200f, 0.008112f, 0.037564f, 0.016138f, 0.655965f, 0.000009f, 0.000025f, 0.000025f, 0.000653f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000005f, 0.000001f, 0.000039f, 0.000688f, 0.003201f, 0.000608f, 0.050854f, 0.000000f, 0.000001f, 0.000000f, 0.000018f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000003f, 0.000019f, 0.000012f, 0.000153f, 0.001235f, 0.005060f, 0.001968f, 0.082152f, 0.000002f, 0.000004f, 0.000004f, 0.000094f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000035f, 0.000031f, 0.000033f, 0.003035f, 0.000000f, 0.000000f, 0.000000f, 0.000004f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000006f, 0.000005f, 0.000454f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000000f, 0.000085f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000004f, 0.000003f, 0.000263f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.373608f, 0.393538f, 0.732432f, 1.398136f, 0.585277f, 0.905660f, 1.718506f, 1.635570f, 14.405942f, 14.047531f, 16.871454f, 51.094719f, 1.058406f, 0.643077f, 1.826612f, 3.525344f,
0.040034f, 0.082556f, 0.113304f, 0.216700f, 0.088884f, 0.269264f, 0.376773f, 0.359278f, 2.625691f, 5.012485f, 4.439367f, 13.470311f, 0.170299f, 0.202569f, 0.424299f, 0.820465f,
0.017710f, 0.036680f, 0.022256f, 0.087597f, 0.018395f, 0.055968f, 0.034622f, 0.067943f, 1.301804f, 2.495957f, 0.977283f, 6.102581f, 0.029866f, 0.035679f, 0.033039f, 0.131479f,
0.078605f, 0.143427f, 0.178195f, 0.350041f, 0.092685f, 0.248442f, 0.314698f, 0.308215f, 2.693095f, 4.549059f, 3.647190f, 11.366410f, 0.200168f, 0.210677f, 0.399470f, 0.793379f,
0.000393f, 0.000645f, 0.000536f, 0.004001f, 0.000434f, 0.001045f, 0.000886f, 0.003295f, 0.104920f, 0.159383f, 0.085532f, 1.012181f, 0.001687f, 0.001597f, 0.002027f, 0.015287f,
0.000009f, 0.000028f, 0.000017f, 0.000129f, 0.000014f, 0.000065f, 0.000040f, 0.000150f, 0.003974f, 0.011818f, 0.004677f, 0.055450f, 0.000056f, 0.000105f, 0.000098f, 0.000739f,
0.000010f, 0.000034f, 0.000009f, 0.000140f, 0.000008f, 0.000036f, 0.000010f, 0.000077f, 0.005313f, 0.015870f, 0.002776f, 0.067746f, 0.000027f, 0.000050f, 0.000021f, 0.000319f,
0.000040f, 0.000114f, 0.000063f, 0.000486f, 0.000033f, 0.000139f, 0.000079f, 0.000302f, 0.009523f, 0.025061f, 0.008978f, 0.109329f, 0.000155f, 0.000254f, 0.000215f, 0.001670f,
0.011175f, 0.028309f, 0.031689f, 0.107529f, 0.019290f, 0.071785f, 0.081927f, 0.138604f, 1.701777f, 3.990770f, 2.882788f, 15.519116f, 0.023343f, 0.034109f, 0.058272f, 0.199914f,
0.000719f, 0.003566f, 0.002944f, 0.010008f, 0.001759f, 0.012816f, 0.010786f, 0.018283f, 0.186260f, 0.855117f, 0.455509f, 2.456882f, 0.002255f, 0.006452f, 0.008128f, 0.027939f,
0.000183f, 0.000913f, 0.000333f, 0.002331f, 0.000210f, 0.001535f, 0.000571f, 0.001992f, 0.053212f, 0.245355f, 0.057781f, 0.641365f, 0.000228f, 0.000655f, 0.000365f, 0.002580f,
0.000381f, 0.001672f, 0.001249f, 0.004361f, 0.000495f, 0.003190f, 0.002431f, 0.004232f, 0.051541f, 0.209372f, 0.100962f, 0.559312f, 0.000715f, 0.001810f, 0.002065f, 0.007289f,
0.000335f, 0.000316f, 0.000656f, 0.004991f, 0.000031f, 0.000043f, 0.000092f, 0.000347f, 0.030269f, 0.026423f, 0.035399f, 0.427129f, 0.000475f, 0.000259f, 0.000819f, 0.006298f,
0.000040f, 0.000074f, 0.000113f, 0.000861f, 0.000005f, 0.000014f, 0.000022f, 0.000085f, 0.006141f, 0.010495f, 0.010368f, 0.125345f, 0.000085f, 0.000091f, 0.000212f, 0.001632f,
0.000025f, 0.000046f, 0.000031f, 0.000485f, 0.000002f, 0.000004f, 0.000003f, 0.000022f, 0.004240f, 0.007277f, 0.003178f, 0.079072f, 0.000021f, 0.000022f, 0.000023f, 0.000364f,
0.000098f, 0.000160f, 0.000222f, 0.001737f, 0.000007f, 0.000016f, 0.000023f, 0.000091f, 0.007866f, 0.011894f, 0.010637f, 0.132081f, 0.000125f, 0.000118f, 0.000249f, 0.001970f,
0.001134f, 0.002252f, 0.003532f, 0.026416f, 0.019043f, 0.055542f, 0.088829f, 0.331201f, 0.772409f, 1.419636f, 1.437082f, 17.049910f, 0.001825f, 0.002091f, 0.005005f, 0.037841f,
0.000035f, 0.000137f, 0.000158f, 0.001186f, 0.000838f, 0.004784f, 0.005642f, 0.021077f, 0.040786f, 0.146753f, 0.109549f, 1.302209f, 0.000085f, 0.000191f, 0.000337f, 0.002551f,
0.000008f, 0.000030f, 0.000016f, 0.000239f, 0.000087f, 0.000497f, 0.000259f, 0.001990f, 0.010098f, 0.036492f, 0.012043f, 0.294609f, 0.000007f, 0.000017f, 0.000013f, 0.000204f,
0.000082f, 0.000282f, 0.000295f, 0.002273f, 0.001036f, 0.005236f, 0.005590f, 0.021448f, 0.049622f, 0.157985f, 0.106759f, 1.303430f, 0.000119f, 0.000235f, 0.000376f, 0.002927f,
0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000001f, 0.000003f, 0.000002f, 0.000032f, 0.000271f, 0.000776f, 0.000351f, 0.016263f, 0.000000f, 0.000000f, 0.000000f, 0.000008f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000017f, 0.000006f, 0.000258f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000011f, 0.000002f, 0.000157f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000008f, 0.000042f, 0.000013f, 0.000604f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000028f, 0.000131f, 0.000124f, 0.001649f, 0.000509f, 0.003574f, 0.003437f, 0.022783f, 0.074066f, 0.327372f, 0.199320f, 4.203605f, 0.000033f, 0.000090f, 0.000130f, 0.001742f,
0.000001f, 0.000005f, 0.000003f, 0.000044f, 0.000013f, 0.000185f, 0.000131f, 0.000871f, 0.002349f, 0.020322f, 0.009124f, 0.192795f, 0.000001f, 0.000005f, 0.000005f, 0.000071f,
0.000000f, 0.000001f, 0.000000f, 0.000005f, 0.000001f, 0.000011f, 0.000003f, 0.000047f, 0.000335f, 0.002912f, 0.000578f, 0.025133f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000000f, 0.000003f, 0.000002f, 0.000023f, 0.000004f, 0.000055f, 0.000035f, 0.000239f, 0.000771f, 0.005902f, 0.002399f, 0.052063f, 0.000000f, 0.000002f, 0.000002f, 0.000022f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000010f, 0.000012f, 0.000559f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000048f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000015f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000001f, 0.000059f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.001626f, 0.002765f, 0.002483f, 0.038729f, 0.002252f, 0.005627f, 0.005151f, 0.040066f, 0.723305f, 1.138668f, 0.659831f, 16.330100f, 0.002175f, 0.002133f, 0.002924f, 0.046113f,
0.000071f, 0.000235f, 0.000156f, 0.002431f, 0.000139f, 0.000678f, 0.000457f, 0.003565f, 0.053394f, 0.164557f, 0.070318f, 1.743644f, 0.000142f, 0.000272f, 0.000275f, 0.004347f,
0.000016f, 0.000055f, 0.000016f, 0.000518f, 0.000015f, 0.000074f, 0.000022f, 0.000355f, 0.013961f, 0.043214f, 0.008164f, 0.416597f, 0.000013f, 0.000025f, 0.000011f, 0.000367f,
0.000078f, 0.000231f, 0.000138f, 0.002221f, 0.000082f, 0.000353f, 0.000216f, 0.001729f, 0.030967f, 0.084447f, 0.032667f, 0.831958f, 0.000094f, 0.000160f, 0.000146f, 0.002377f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000137f, 0.000336f, 0.000087f, 0.008410f, 0.000000f, 0.000000f, 0.000000f, 0.000005f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000010f, 0.000002f, 0.000187f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000007f, 0.000001f, 0.000120f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000012f, 0.000002f, 0.000208f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000035f, 0.000142f, 0.000077f, 0.002125f, 0.000053f, 0.000318f, 0.000175f, 0.002422f, 0.060949f, 0.230747f, 0.080422f, 3.538043f, 0.000034f, 0.000081f, 0.000067f, 0.001865f,
0.000001f, 0.000007f, 0.000003f, 0.000080f, 0.000002f, 0.000023f, 0.000009f, 0.000129f, 0.002702f, 0.020025f, 0.005147f, 0.226855f, 0.000001f, 0.000006f, 0.000004f, 0.000106f,
0.000000f, 0.000001f, 0.000000f, 0.000010f, 0.000000f, 0.000001f, 0.000000f, 0.000007f, 0.000407f, 0.003030f, 0.000344f, 0.031231f, 0.000000f, 0.000000f, 0.000000f, 0.000005f,
0.000000f, 0.000002f, 0.000001f, 0.000020f, 0.000000f, 0.000003f, 0.000001f, 0.000017f, 0.000423f, 0.002772f, 0.000645f, 0.029202f, 0.000000f, 0.000001f, 0.000001f, 0.000016f,
0.000001f, 0.000001f, 0.000001f, 0.000048f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000524f, 0.000738f, 0.000477f, 0.047041f, 0.000000f, 0.000000f, 0.000000f, 0.000028f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000043f, 0.000119f, 0.000057f, 0.005591f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000016f, 0.000043f, 0.000009f, 0.001860f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000031f, 0.000076f, 0.000033f, 0.003331f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000206f, 0.000211f, 0.000306f, 0.005782f, 0.018410f, 0.027672f, 0.041072f, 0.386294f, 2.278767f, 2.158460f, 2.027722f, 60.686092f, 0.009064f, 0.005350f, 0.011886f, 0.226690f,
0.000013f, 0.000025f, 0.000027f, 0.000515f, 0.001607f, 0.004730f, 0.005177f, 0.048784f, 0.238782f, 0.442788f, 0.306744f, 9.197915f, 0.000838f, 0.000969f, 0.001587f, 0.030331f,
0.000001f, 0.000003f, 0.000001f, 0.000053f, 0.000084f, 0.000248f, 0.000120f, 0.002329f, 0.029887f, 0.055662f, 0.017047f, 1.051967f, 0.000037f, 0.000043f, 0.000031f, 0.001227f,
0.000008f, 0.000015f, 0.000014f, 0.000277f, 0.000559f, 0.001455f, 0.001442f, 0.013953f, 0.081654f, 0.133977f, 0.084020f, 2.587630f, 0.000329f, 0.000336f, 0.000498f, 0.009779f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000002f, 0.000005f, 0.000003f, 0.000119f, 0.002532f, 0.003737f, 0.001568f, 0.183426f, 0.000002f, 0.000002f, 0.000002f, 0.000150f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000055f, 0.000159f, 0.000049f, 0.005777f, 0.000000f, 0.000000f, 0.000000f, 0.000004f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000019f, 0.000054f, 0.000007f, 0.001782f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000044f, 0.000113f, 0.000032f, 0.003798f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000005f, 0.000012f, 0.000010f, 0.000346f, 0.000472f, 0.001706f, 0.001523f, 0.025457f, 0.209337f, 0.476855f, 0.269435f, 14.333949f, 0.000155f, 0.000221f, 0.000295f, 0.009997f,
0.000000f, 0.000001f, 0.000001f, 0.000019f, 0.000025f, 0.000175f, 0.000115f, 0.001931f, 0.013172f, 0.058743f, 0.024476f, 1.304613f, 0.000009f, 0.000024f, 0.000024f, 0.000803f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000005f, 0.000002f, 0.000053f, 0.000950f, 0.004255f, 0.000784f, 0.085976f, 0.000000f, 0.000001f, 0.000000f, 0.000019f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000002f, 0.000015f, 0.000009f, 0.000149f, 0.001215f, 0.004795f, 0.001809f, 0.099019f, 0.000001f, 0.000002f, 0.000002f, 0.000070f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000114f, 0.000097f, 0.000101f, 0.012086f, 0.000000f, 0.000000f, 0.000000f, 0.000010f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000013f, 0.000022f, 0.000017f, 0.002039f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000004f, 0.000001f, 0.000325f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000008f, 0.000006f, 0.000716f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.501838f, 0.509076f, 0.918924f, 2.300186f, 0.629247f, 0.937721f, 1.725742f, 2.153751f, 19.144367f, 17.978261f, 20.941934f, 83.165222f, 0.869481f, 0.508767f, 1.401584f, 3.547118f,
0.060660f, 0.120469f, 0.160356f, 0.402163f, 0.107799f, 0.314497f, 0.426810f, 0.533688f, 3.936163f, 7.236538f, 6.216064f, 24.732814f, 0.157815f, 0.180784f, 0.367261f, 0.931246f,
0.022811f, 0.045499f, 0.026775f, 0.138192f, 0.018964f, 0.055568f, 0.033340f, 0.085792f, 1.658919f, 3.063128f, 1.163229f, 9.524881f, 0.023527f, 0.027068f, 0.024310f, 0.126856f,
0.072181f, 0.126840f, 0.152840f, 0.393697f, 0.068124f, 0.175858f, 0.216048f, 0.277466f, 2.446701f, 3.980150f, 3.094943f, 12.647923f, 0.112417f, 0.113947f, 0.209550f, 0.545739f,
0.000587f, 0.000928f, 0.000748f, 0.007318f, 0.000518f, 0.001203f, 0.000989f, 0.004824f, 0.155008f, 0.226771f, 0.118030f, 1.831558f, 0.001541f, 0.001405f, 0.001729f, 0.017100f,
0.000015f, 0.000046f, 0.000027f, 0.000266f, 0.000018f, 0.000084f, 0.000051f, 0.000248f, 0.006623f, 0.018968f, 0.007280f, 0.113186f, 0.000058f, 0.000104f, 0.000094f, 0.000933f,
0.000015f, 0.000046f, 0.000012f, 0.000246f, 0.000009f, 0.000040f, 0.000011f, 0.000108f, 0.007527f, 0.021652f, 0.003674f, 0.117551f, 0.000023f, 0.000042f, 0.000017f, 0.000343f,
0.000041f, 0.000112f, 0.000060f, 0.000608f, 0.000027f, 0.000110f, 0.000060f, 0.000302f, 0.009619f, 0.024376f, 0.008469f, 0.135247f, 0.000097f, 0.000153f, 0.000126f, 0.001277f,
0.018610f, 0.045399f, 0.049289f, 0.219313f, 0.025711f, 0.092145f, 0.101994f, 0.226270f, 2.803673f, 6.331834f, 4.436110f, 31.315380f, 0.023774f, 0.033454f, 0.055431f, 0.249369f,
0.001351f, 0.006451f, 0.005165f, 0.023026f, 0.002645f, 0.018558f, 0.015148f, 0.033669f, 0.346159f, 1.530482f, 0.790709f, 5.592492f, 0.002591f, 0.007139f, 0.008722f, 0.039314f,
0.000293f, 0.001404f, 0.000497f, 0.004559f, 0.000268f, 0.001889f, 0.000682f, 0.003119f, 0.084064f, 0.373291f, 0.085261f, 1.241013f, 0.000223f, 0.000616f, 0.000333f, 0.003086f,
0.000434f, 0.001833f, 0.001328f, 0.006081f, 0.000451f, 0.002800f, 0.002069f, 0.004723f, 0.058051f, 0.227102f, 0.106213f, 0.771569f, 0.000498f, 0.001214f, 0.001343f, 0.006216f,
0.001261f, 0.001145f, 0.002306f, 0.022996f, 0.000094f, 0.000125f, 0.000258f, 0.001281f, 0.112654f, 0.094709f, 0.123056f, 1.947050f, 0.001093f, 0.000573f, 0.001760f, 0.017747f,
0.000170f, 0.000302f, 0.000448f, 0.004475f, 0.000018f, 0.000047f, 0.000071f, 0.000353f, 0.025783f, 0.042435f, 0.040658f, 0.644550f, 0.000221f, 0.000227f, 0.000513f, 0.005186f,
0.000089f, 0.000159f, 0.000104f, 0.002141f, 0.000004f, 0.000012f, 0.000008f, 0.000079f, 0.015131f, 0.025011f, 0.010594f, 0.345640f, 0.000046f, 0.000047f, 0.000047f, 0.000984f,
0.000252f, 0.000397f, 0.000533f, 0.005471f, 0.000014f, 0.000033f, 0.000045f, 0.000229f, 0.020013f, 0.029146f, 0.025280f, 0.411613f, 0.000197f, 0.000178f, 0.000366f, 0.003796f,
0.001095f, 0.002094f, 0.003185f, 0.031234f, 0.014715f, 0.041332f, 0.064112f, 0.313453f, 0.737738f, 1.305810f, 1.282038f, 19.945409f, 0.001078f, 0.001189f, 0.002760f, 0.027365f,
0.000038f, 0.000144f, 0.000161f, 0.001582f, 0.000730f, 0.004016f, 0.004594f, 0.022502f, 0.043943f, 0.152272f, 0.110244f, 1.718429f, 0.000057f, 0.000122f, 0.000210f, 0.002081f,
0.000007f, 0.000027f, 0.000013f, 0.000271f, 0.000064f, 0.000354f, 0.000179f, 0.001806f, 0.009249f, 0.032187f, 0.010302f, 0.330481f, 0.000004f, 0.000009f, 0.000007f, 0.000142f,
0.000054f, 0.000179f, 0.000182f, 0.001837f, 0.000547f, 0.002664f, 0.002758f, 0.013877f, 0.032401f, 0.099346f, 0.065111f, 1.042410f, 0.000048f, 0.000091f, 0.000142f, 0.001447f,
0.000000f, 0.000000f, 0.000000f, 0.000005f, 0.000001f, 0.000003f, 0.000002f, 0.000034f, 0.000288f, 0.000793f, 0.000348f, 0.021150f, 0.000000f, 0.000000f, 0.000000f, 0.000006f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000004f, 0.000019f, 0.000006f, 0.000379f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000011f, 0.000002f, 0.000196f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000006f, 0.000029f, 0.000009f, 0.000537f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000033f, 0.000152f, 0.000139f, 0.002417f, 0.000488f, 0.003297f, 0.003076f, 0.026731f, 0.087699f, 0.373311f, 0.220443f, 6.096321f, 0.000024f, 0.000063f, 0.000089f, 0.001562f,
0.000001f, 0.000006f, 0.000004f, 0.000074f, 0.000015f, 0.000192f, 0.000132f, 0.001152f, 0.003137f, 0.026141f, 0.011383f, 0.315408f, 0.000001f, 0.000004f, 0.000004f, 0.000071f,
0.000000f, 0.000001f, 0.000000f, 0.000007f, 0.000001f, 0.000010f, 0.000003f, 0.000053f, 0.000380f, 0.003184f, 0.000613f, 0.034952f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000000f, 0.000002f, 0.000001f, 0.000023f, 0.000003f, 0.000034f, 0.000021f, 0.000192f, 0.000624f, 0.004601f, 0.001814f, 0.051618f, 0.000000f, 0.000001f, 0.000001f, 0.000013f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000017f, 0.000027f, 0.000030f, 0.001832f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000004f, 0.000003f, 0.000176f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000047f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000003f, 0.000002f, 0.000133f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.022480f, 0.034207f, 0.035268f, 0.176851f, 0.029065f, 0.064972f, 0.068297f, 0.170749f, 2.280677f, 3.212719f, 2.137542f, 17.005023f, 0.030674f, 0.026923f, 0.042364f, 0.214781f,
0.001166f, 0.003473f, 0.002641f, 0.013268f, 0.002137f, 0.009350f, 0.007248f, 0.018155f, 0.201205f, 0.554880f, 0.272243f, 2.169964f, 0.002389f, 0.004105f, 0.004763f, 0.024195f,
0.000594f, 0.001777f, 0.000597f, 0.006176f, 0.000509f, 0.002238f, 0.000767f, 0.003954f, 0.114881f, 0.318194f, 0.069018f, 1.132130f, 0.000482f, 0.000833f, 0.000427f, 0.004465f,
0.001903f, 0.005017f, 0.003453f, 0.017818f, 0.001852f, 0.007172f, 0.005033f, 0.012949f, 0.171575f, 0.418673f, 0.185952f, 1.522318f, 0.002334f, 0.003549f, 0.003728f, 0.019452f,
0.000003f, 0.000007f, 0.000003f, 0.000062f, 0.000003f, 0.000009f, 0.000004f, 0.000042f, 0.002024f, 0.004442f, 0.001320f, 0.041048f, 0.000006f, 0.000008f, 0.000006f, 0.000113f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000037f, 0.000159f, 0.000035f, 0.001088f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000057f, 0.000247f, 0.000024f, 0.001531f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000074f, 0.000281f, 0.000056f, 0.001784f, 0.000000f, 0.000001f, 0.000000f, 0.000005f,
0.000715f, 0.002615f, 0.001621f, 0.014453f, 0.001018f, 0.005472f, 0.003460f, 0.015376f, 0.286290f, 0.969863f, 0.388111f, 5.488444f, 0.000719f, 0.001517f, 0.001436f, 0.012942f,
0.000022f, 0.000159f, 0.000073f, 0.000651f, 0.000045f, 0.000473f, 0.000220f, 0.000982f, 0.015167f, 0.100589f, 0.029683f, 0.420572f, 0.000034f, 0.000139f, 0.000097f, 0.000876f,
0.000007f, 0.000047f, 0.000010f, 0.000175f, 0.000006f, 0.000065f, 0.000013f, 0.000123f, 0.004990f, 0.033238f, 0.004336f, 0.126436f, 0.000004f, 0.000016f, 0.000005f, 0.000093f,
0.000010f, 0.000062f, 0.000026f, 0.000236f, 0.000011f, 0.000098f, 0.000041f, 0.000189f, 0.003489f, 0.020476f, 0.005470f, 0.079601f, 0.000009f, 0.000032f, 0.000020f, 0.000190f,
0.000017f, 0.000023f, 0.000026f, 0.000518f, 0.000001f, 0.000003f, 0.000003f, 0.000030f, 0.003934f, 0.004962f, 0.003682f, 0.116715f, 0.000011f, 0.000009f, 0.000016f, 0.000315f,
0.000001f, 0.000003f, 0.000002f, 0.000043f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000386f, 0.000954f, 0.000522f, 0.016579f, 0.000001f, 0.000002f, 0.000002f, 0.000040f,
0.000001f, 0.000002f, 0.000001f, 0.000028f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000307f, 0.000762f, 0.000184f, 0.012044f, 0.000000f, 0.000000f, 0.000000f, 0.000010f,
0.000002f, 0.000005f, 0.000004f, 0.000073f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000411f, 0.000899f, 0.000445f, 0.014524f, 0.000001f, 0.000002f, 0.000002f, 0.000040f,
0.001771f, 0.001621f, 0.002710f, 0.016430f, 0.147843f, 0.198849f, 0.338866f, 1.024494f, 4.471477f, 3.789906f, 4.087888f, 39.326566f, 0.079555f, 0.042014f, 0.107176f, 0.657077f,
0.000130f, 0.000234f, 0.000288f, 0.001750f, 0.015427f, 0.040620f, 0.051046f, 0.154624f, 0.559961f, 0.929151f, 0.739048f, 7.123484f, 0.008795f, 0.009093f, 0.017105f, 0.105070f,
0.000032f, 0.000057f, 0.000031f, 0.000390f, 0.001760f, 0.004654f, 0.002586f, 0.016119f, 0.153046f, 0.255055f, 0.089688f, 1.779062f, 0.000850f, 0.000883f, 0.000734f, 0.009282f,
0.000125f, 0.000199f, 0.000222f, 0.001385f, 0.007886f, 0.018372f, 0.020900f, 0.065024f, 0.281541f, 0.413363f, 0.297637f, 2.946556f, 0.005067f, 0.004636f, 0.007894f, 0.049805f,
0.000001f, 0.000002f, 0.000001f, 0.000034f, 0.000078f, 0.000164f, 0.000125f, 0.001476f, 0.023290f, 0.030752f, 0.014821f, 0.557150f, 0.000091f, 0.000075f, 0.000085f, 0.002038f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000007f, 0.000004f, 0.000046f, 0.000606f, 0.001567f, 0.000557f, 0.020971f, 0.000002f, 0.000003f, 0.000003f, 0.000068f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000001f, 0.000013f, 0.000447f, 0.001160f, 0.000182f, 0.014124f, 0.000001f, 0.000001f, 0.000000f, 0.000016f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000007f, 0.000004f, 0.000045f, 0.000712f, 0.001629f, 0.000524f, 0.020269f, 0.000003f, 0.000004f, 0.000003f, 0.000075f,
0.000061f, 0.000135f, 0.000136f, 0.001464f, 0.005645f, 0.018259f, 0.018715f, 0.100577f, 0.611921f, 1.247292f, 0.809176f, 13.837591f, 0.002033f, 0.002582f, 0.003961f, 0.043166f,
0.000003f, 0.000012f, 0.000009f, 0.000094f, 0.000354f, 0.002240f, 0.001693f, 0.009116f, 0.046017f, 0.183629f, 0.087848f, 1.505159f, 0.000135f, 0.000336f, 0.000380f, 0.004145f,
0.000000f, 0.000002f, 0.000001f, 0.000012f, 0.000023f, 0.000148f, 0.000049f, 0.000548f, 0.007247f, 0.029045f, 0.006143f, 0.216604f, 0.000008f, 0.000019f, 0.000009f, 0.000211f,
0.000001f, 0.000003f, 0.000002f, 0.000020f, 0.000049f, 0.000273f, 0.000187f, 0.001034f, 0.006242f, 0.022040f, 0.009545f, 0.167969f, 0.000021f, 0.000046f, 0.000047f, 0.000530f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000001f, 0.000001f, 0.000012f, 0.000533f, 0.000405f, 0.000487f, 0.018662f, 0.000002f, 0.000001f, 0.000003f, 0.000067f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000074f, 0.000110f, 0.000098f, 0.003763f, 0.000000f, 0.000000f, 0.000000f, 0.000012f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000028f, 0.000042f, 0.000017f, 0.001309f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000047f, 0.000061f, 0.000049f, 0.001944f, 0.000000f, 0.000000f, 0.000000f, 0.000007f,
4.128192f, 3.747249f, 7.766324f, 6.248925f, 4.830865f, 6.441848f, 13.611917f, 5.460661f, 35.912903f, 30.177995f, 40.361351f, 51.522498f, 7.295512f, 3.819866f, 12.082431f, 9.829178f,
0.596356f, 1.059765f, 1.619676f, 1.305722f, 0.989062f, 2.582025f, 4.023321f, 1.617124f, 8.824472f, 14.517097f, 14.317613f, 18.311965f, 1.582527f, 1.622163f, 3.783695f, 3.083985f,
0.489710f, 0.874028f, 0.590553f, 0.979757f, 0.379958f, 0.996220f, 0.686270f, 0.567662f, 8.121320f, 13.418374f, 5.850676f, 15.399504f, 0.515170f, 0.530366f, 0.546907f, 0.917372f,
1.043367f, 1.640594f, 2.269806f, 1.879403f, 0.919005f, 2.122831f, 2.994391f, 1.236163f, 8.065029f, 11.739719f, 10.481350f, 13.768606f, 1.657461f, 1.503306f, 3.174226f, 2.657310f,
0.022633f, 0.032006f, 0.029639f, 0.093189f, 0.018646f, 0.038735f, 0.036571f, 0.057329f, 1.362944f, 1.784203f, 1.066240f, 5.318517f, 0.060606f, 0.049435f, 0.069868f, 0.222098f,
0.000679f, 0.001881f, 0.001284f, 0.004046f, 0.000793f, 0.003226f, 0.002246f, 0.003528f, 0.069592f, 0.178351f, 0.078596f, 0.392798f, 0.002732f, 0.004362f, 0.004547f, 0.014480f,
0.001505f, 0.004183f, 0.001263f, 0.008188f, 0.000822f, 0.003357f, 0.001033f, 0.003340f, 0.172719f, 0.444571f, 0.086613f, 0.890815f, 0.002398f, 0.003846f, 0.001772f, 0.011616f,
0.002778f, 0.006804f, 0.004206f, 0.013608f, 0.001722f, 0.006198f, 0.003906f, 0.006301f, 0.148615f, 0.337008f, 0.134442f, 0.690100f, 0.006685f, 0.009446f, 0.008912f, 0.029154f,
0.228050f, 0.497826f, 0.620561f, 0.887575f, 0.294051f, 0.942985f, 1.198443f, 0.854621f, 7.834913f, 15.833245f, 12.736472f, 28.900865f, 0.297160f, 0.374178f, 0.711850f, 1.029395f,
0.019783f, 0.084546f, 0.077716f, 0.111370f, 0.036152f, 0.226971f, 0.212715f, 0.151980f, 1.156081f, 4.573778f, 2.713125f, 6.168290f, 0.038708f, 0.095420f, 0.133865f, 0.193951f,
0.009361f, 0.040178f, 0.016328f, 0.048153f, 0.008003f, 0.050460f, 0.020907f, 0.030741f, 0.613072f, 2.436016f, 0.638837f, 2.988970f, 0.007261f, 0.017977f, 0.011149f, 0.033244f,
0.009338f, 0.035311f, 0.029383f, 0.043247f, 0.009063f, 0.050344f, 0.042712f, 0.031343f, 0.285056f, 0.997877f, 0.535846f, 1.251249f, 0.010937f, 0.023857f, 0.030298f, 0.045087f,
0.024716f, 0.020085f, 0.046432f, 0.148851f, 0.001720f, 0.002053f, 0.004840f, 0.007736f, 0.503521f, 0.378787f, 0.565086f, 2.874054f, 0.021860f, 0.010246f, 0.036151f, 0.117174f,
0.003974f, 0.006323f, 0.010779f, 0.034621f, 0.000392f, 0.000916f, 0.001592f, 0.002550f, 0.137722f, 0.202830f, 0.223135f, 1.137051f, 0.005278f, 0.004844f, 0.012602f, 0.040924f,
0.004544f, 0.007261f, 0.005472f, 0.036174f, 0.000210f, 0.000492f, 0.000378f, 0.001246f, 0.176491f, 0.261056f, 0.126965f, 1.331476f, 0.002393f, 0.002205f, 0.002536f, 0.016951f,
0.008683f, 0.012223f, 0.018863f, 0.062230f, 0.000455f, 0.000941f, 0.001480f, 0.002434f, 0.157184f, 0.204832f, 0.203986f, 1.067633f, 0.006903f, 0.005605f, 0.013202f, 0.044034f,
0.004790f, 0.008195f, 0.014315f, 0.045123f, 0.060075f, 0.150990f, 0.268912f, 0.422623f, 0.735938f, 1.165608f, 1.313953f, 6.570953f, 0.004809f, 0.004746f, 0.012653f, 0.040324f,
0.000200f, 0.000671f, 0.000865f, 0.002732f, 0.003563f, 0.017533f, 0.023027f, 0.036258f, 0.052389f, 0.162442f, 0.135034f, 0.676586f, 0.000302f, 0.000584f, 0.001148f, 0.003665f,
0.000082f, 0.000277f, 0.000157f, 0.001024f, 0.000684f, 0.003378f, 0.001961f, 0.006356f, 0.024077f, 0.074980f, 0.027555f, 0.284134f, 0.000049f, 0.000095f, 0.000083f, 0.000544f,
0.000416f, 0.001233f, 0.001438f, 0.004664f, 0.003927f, 0.017099f, 0.020329f, 0.032878f, 0.056796f, 0.155825f, 0.117260f, 0.603448f, 0.000375f, 0.000642f, 0.001142f, 0.003746f,
0.000001f, 0.000003f, 0.000003f, 0.000032f, 0.000011f, 0.000044f, 0.000035f, 0.000214f, 0.001345f, 0.003318f, 0.001671f, 0.032659f, 0.000002f, 0.000003f, 0.000004f, 0.000044f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000004f, 0.000020f, 0.000096f, 0.000036f, 0.000699f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000002f, 0.000025f, 0.000120f, 0.000020f, 0.000791f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000002f, 0.000001f, 0.000008f, 0.000050f, 0.000215f, 0.000072f, 0.001456f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000215f, 0.000884f, 0.000928f, 0.005202f, 0.002968f, 0.017941f, 0.019218f, 0.053690f, 0.130327f, 0.496410f, 0.336567f, 2.991927f, 0.000159f, 0.000377f, 0.000605f, 0.003428f,
0.000005f, 0.000043f, 0.000034f, 0.000189f, 0.000106f, 0.001251f, 0.000988f, 0.002766f, 0.005571f, 0.041543f, 0.020771f, 0.184996f, 0.000006f, 0.000028f, 0.000033f, 0.000187f,
0.000001f, 0.000010f, 0.000004f, 0.000041f, 0.000012f, 0.000139f, 0.000049f, 0.000279f, 0.001475f, 0.011049f, 0.002442f, 0.044766f, 0.000001f, 0.000003f, 0.000001f, 0.000016f,
0.000003f, 0.000022f, 0.000015f, 0.000087f, 0.000031f, 0.000329f, 0.000235f, 0.000677f, 0.001629f, 0.010751f, 0.004866f, 0.044515f, 0.000002f, 0.000008f, 0.000009f, 0.000052f,
0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000040f, 0.000057f, 0.000072f, 0.001438f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000009f, 0.000008f, 0.000165f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000006f, 0.000002f, 0.000096f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000011f, 0.000009f, 0.000184f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.007529f, 0.008569f, 0.010143f, 0.097693f, 0.007575f, 0.012666f, 0.015285f, 0.073403f, 2.906381f, 3.062181f, 2.338973f, 35.742443f, 0.007798f, 0.005119f, 0.009247f, 0.090056f,
0.000336f, 0.000748f, 0.000653f, 0.006299f, 0.000479f, 0.001567f, 0.001394f, 0.006708f, 0.220379f, 0.454569f, 0.256041f, 3.920142f, 0.000522f, 0.000671f, 0.000894f, 0.008719f,
0.000104f, 0.000232f, 0.000090f, 0.001779f, 0.000069f, 0.000227f, 0.000089f, 0.000886f, 0.076330f, 0.158127f, 0.039376f, 1.240678f, 0.000064f, 0.000083f, 0.000049f, 0.000976f,
0.000405f, 0.000799f, 0.000631f, 0.006254f, 0.000307f, 0.000888f, 0.000716f, 0.003537f, 0.138923f, 0.253550f, 0.129283f, 2.033028f, 0.000377f, 0.000429f, 0.000517f, 0.005182f,
0.000000f, 0.000001f, 0.000000f, 0.000012f, 0.000000f, 0.000001f, 0.000000f, 0.000007f, 0.000933f, 0.001532f, 0.000523f, 0.031223f, 0.000001f, 0.000001f, 0.000000f, 0.000017f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000015f, 0.000047f, 0.000012f, 0.000712f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000014f, 0.000044f, 0.000005f, 0.000607f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000022f, 0.000062f, 0.000014f, 0.000862f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000269f, 0.000738f, 0.000525f, 0.008991f, 0.000299f, 0.001201f, 0.000872f, 0.007444f, 0.410848f, 1.041011f, 0.478248f, 12.991014f, 0.000206f, 0.000325f, 0.000353f, 0.006111f,
0.000007f, 0.000039f, 0.000020f, 0.000348f, 0.000011f, 0.000089f, 0.000048f, 0.000408f, 0.018707f, 0.092798f, 0.031438f, 0.855611f, 0.000008f, 0.000026f, 0.000020f, 0.000355f,
0.000001f, 0.000007f, 0.000002f, 0.000057f, 0.000001f, 0.000007f, 0.000002f, 0.000031f, 0.003734f, 0.018601f, 0.002786f, 0.156034f, 0.000001f, 0.000002f, 0.000001f, 0.000023f,
0.000002f, 0.000011f, 0.000005f, 0.000093f, 0.000002f, 0.000014f, 0.000007f, 0.000058f, 0.003182f, 0.013965f, 0.004283f, 0.119713f, 0.000002f, 0.000004f, 0.000003f, 0.000057f,
0.000001f, 0.000001f, 0.000002f, 0.000073f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.001271f, 0.001199f, 0.001021f, 0.062183f, 0.000001f, 0.000000f, 0.000001f, 0.000033f,
0.000000f, 0.000000f, 0.000000f, 0.000005f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000107f, 0.000198f, 0.000124f, 0.007592f, 0.000000f, 0.000000f, 0.000000f, 0.000004f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000052f, 0.000096f, 0.000027f, 0.003346f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000084f, 0.000138f, 0.000078f, 0.004917f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000561f, 0.000384f, 0.000738f, 0.008592f, 0.036480f, 0.036698f, 0.071796f, 0.416945f, 5.394532f, 3.419800f, 4.234710f, 78.254084f, 0.019146f, 0.007563f, 0.022148f, 0.260824f,
0.000036f, 0.000048f, 0.000067f, 0.000786f, 0.003272f, 0.006443f, 0.009296f, 0.054086f, 0.580635f, 0.720611f, 0.658021f, 12.183050f, 0.001819f, 0.001407f, 0.003038f, 0.035847f,
0.000005f, 0.000007f, 0.000004f, 0.000106f, 0.000226f, 0.000448f, 0.000286f, 0.003420f, 0.096268f, 0.119994f, 0.048441f, 1.845729f, 0.000107f, 0.000083f, 0.000079f, 0.001921f,
0.000025f, 0.000030f, 0.000038f, 0.000460f, 0.001236f, 0.002154f, 0.002814f, 0.016814f, 0.215812f, 0.236993f, 0.195903f, 3.725349f, 0.000775f, 0.000530f, 0.001037f, 0.012561f,
0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000007f, 0.000011f, 0.000010f, 0.000217f, 0.010169f, 0.010042f, 0.005556f, 0.401216f, 0.000008f, 0.000005f, 0.000006f, 0.000293f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000227f, 0.000440f, 0.000179f, 0.012980f, 0.000000f, 0.000000f, 0.000000f, 0.000008f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000102f, 0.000197f, 0.000036f, 0.005303f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000198f, 0.000338f, 0.000125f, 0.009274f, 0.000000f, 0.000000f, 0.000000f, 0.000007f,
0.000022f, 0.000036f, 0.000042f, 0.000862f, 0.001569f, 0.003795f, 0.004465f, 0.046095f, 0.831352f, 1.267440f, 0.943962f, 31.007593f, 0.000551f, 0.000523f, 0.000922f, 0.019296f,
0.000001f, 0.000003f, 0.000002f, 0.000047f, 0.000084f, 0.000400f, 0.000347f, 0.003591f, 0.053734f, 0.160377f, 0.088082f, 2.898897f, 0.000031f, 0.000058f, 0.000076f, 0.001593f,
0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000003f, 0.000016f, 0.000006f, 0.000131f, 0.005133f, 0.015388f, 0.003736f, 0.253064f, 0.000001f, 0.000002f, 0.000001f, 0.000049f,
0.000000f, 0.000000f, 0.000000f, 0.000007f, 0.000009f, 0.000036f, 0.000028f, 0.000301f, 0.005388f, 0.014230f, 0.007075f, 0.239149f, 0.000004f, 0.000006f, 0.000007f, 0.000151f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000163f, 0.000093f, 0.000128f, 0.009413f, 0.000000f, 0.000000f, 0.000000f, 0.000007f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000020f, 0.000022f, 0.000022f, 0.001631f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000005f, 0.000005f, 0.000002f, 0.000344f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000009f, 0.000009f, 0.000008f, 0.000623f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
2.840877f, 1.928744f, 4.589127f, 7.092776f, 2.587129f, 2.580316f, 6.259421f, 4.823436f, 94.036158f, 59.102306f, 90.746952f, 222.515210f, 3.810756f, 1.492358f, 5.419157f, 8.468197f,
0.352729f, 0.468829f, 0.822593f, 1.273809f, 0.455259f, 0.888926f, 1.590165f, 1.227715f, 19.859839f, 24.436346f, 27.668112f, 67.973572f, 0.710475f, 0.544706f, 1.458599f, 2.283643f,
0.175706f, 0.234554f, 0.181941f, 0.579809f, 0.106093f, 0.208053f, 0.164538f, 0.261431f, 11.087327f, 13.701550f, 6.858488f, 34.675709f, 0.140301f, 0.108033f, 0.127893f, 0.412074f,
0.456206f, 0.536531f, 0.852186f, 1.355382f, 0.312710f, 0.540268f, 0.874892f, 0.693774f, 13.417803f, 14.608405f, 14.973204f, 37.781915f, 0.550085f, 0.373167f, 0.904579f, 1.454612f,
0.005637f, 0.005962f, 0.006338f, 0.038279f, 0.003614f, 0.005615f, 0.006086f, 0.018326f, 1.291538f, 1.264570f, 0.867573f, 8.312621f, 0.011457f, 0.006989f, 0.011341f, 0.069247f,
0.000145f, 0.000301f, 0.000236f, 0.001429f, 0.000132f, 0.000402f, 0.000321f, 0.000969f, 0.056680f, 0.108647f, 0.054966f, 0.527666f, 0.000444f, 0.000530f, 0.000634f, 0.003880f,
0.000195f, 0.000406f, 0.000141f, 0.001754f, 0.000083f, 0.000254f, 0.000090f, 0.000557f, 0.085335f, 0.164284f, 0.036744f, 0.725923f, 0.000236f, 0.000284f, 0.000150f, 0.001888f,
0.000440f, 0.000805f, 0.000571f, 0.003552f, 0.000212f, 0.000571f, 0.000413f, 0.001280f, 0.089479f, 0.151764f, 0.069505f, 0.685315f, 0.000803f, 0.000849f, 0.000919f, 0.005775f,
0.176730f, 0.288554f, 0.412939f, 1.134496f, 0.177339f, 0.425357f, 0.620610f, 0.850103f, 23.102855f, 34.919711f, 32.247964f, 140.559580f, 0.174796f, 0.164623f, 0.359545f, 0.998717f,
0.013177f, 0.042119f, 0.044448f, 0.122351f, 0.018740f, 0.087996f, 0.094677f, 0.129936f, 2.929962f, 8.669982f, 5.904259f, 25.784375f, 0.019570f, 0.036082f, 0.058113f, 0.161732f,
0.003782f, 0.012142f, 0.005665f, 0.032090f, 0.002516f, 0.011867f, 0.005645f, 0.015943f, 0.942537f, 2.801152f, 0.843333f, 7.579262f, 0.002227f, 0.004124f, 0.002936f, 0.016816f,
0.004598f, 0.013004f, 0.012423f, 0.035123f, 0.003473f, 0.014429f, 0.014053f, 0.019809f, 0.534062f, 1.398327f, 0.862034f, 3.866555f, 0.004088f, 0.006669f, 0.009723f, 0.027793f,
0.004311f, 0.002620f, 0.006955f, 0.042825f, 0.000233f, 0.000208f, 0.000564f, 0.001732f, 0.334196f, 0.188039f, 0.322047f, 3.146271f, 0.002894f, 0.001015f, 0.004110f, 0.025588f,
0.000596f, 0.000709f, 0.001388f, 0.008561f, 0.000046f, 0.000080f, 0.000160f, 0.000491f, 0.078565f, 0.086542f, 0.109299f, 1.069852f, 0.000601f, 0.000412f, 0.001231f, 0.007681f,
0.000413f, 0.000494f, 0.000427f, 0.005426f, 0.000015f, 0.000026f, 0.000023f, 0.000146f, 0.061075f, 0.067568f, 0.037726f, 0.759959f, 0.000165f, 0.000114f, 0.000150f, 0.001930f,
0.000962f, 0.001013f, 0.001795f, 0.011376f, 0.000039f, 0.000061f, 0.000110f, 0.000346f, 0.066286f, 0.064607f, 0.073865f, 0.742599f, 0.000581f, 0.000353f, 0.000954f, 0.006110f,
0.001841f, 0.002356f, 0.004725f, 0.028611f, 0.017972f, 0.033786f, 0.069079f, 0.208537f, 1.076477f, 1.275221f, 1.650310f, 15.852941f, 0.001403f, 0.001036f, 0.003170f, 0.019407f,
0.000066f, 0.000166f, 0.000245f, 0.001489f, 0.000916f, 0.003372f, 0.005084f, 0.015377f, 0.065863f, 0.152748f, 0.145770f, 1.402967f, 0.000076f, 0.000110f, 0.000247f, 0.001516f,
0.000016f, 0.000041f, 0.000027f, 0.000338f, 0.000107f, 0.000394f, 0.000263f, 0.001635f, 0.018362f, 0.042770f, 0.018045f, 0.357406f, 0.000007f, 0.000011f, 0.000011f, 0.000137f,
0.000102f, 0.000225f, 0.000302f, 0.001879f, 0.000747f, 0.002431f, 0.003318f, 0.010308f, 0.052785f, 0.108318f, 0.093576f, 0.925022f, 0.000070f, 0.000089f, 0.000182f, 0.001146f,
0.000000f, 0.000000f, 0.000000f, 0.000007f, 0.000001f, 0.000004f, 0.000003f, 0.000038f, 0.000712f, 0.001314f, 0.000760f, 0.028515f, 0.000000f, 0.000000f, 0.000000f, 0.000008f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000009f, 0.000033f, 0.000014f, 0.000524f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000007f, 0.000025f, 0.000005f, 0.000360f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000017f, 0.000054f, 0.000021f, 0.000808f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000093f, 0.000286f, 0.000345f, 0.003715f, 0.001000f, 0.004521f, 0.005560f, 0.029834f, 0.214676f, 0.611590f, 0.476041f, 8.128668f, 0.000052f, 0.000093f, 0.000171f, 0.001858f,
0.000002f, 0.000012f, 0.000011f, 0.000116f, 0.000031f, 0.000271f, 0.000246f, 0.001321f, 0.007887f, 0.043991f, 0.025250f, 0.431989f, 0.000002f, 0.000006f, 0.000008f, 0.000087f,
0.000000f, 0.000002f, 0.000001f, 0.000015f, 0.000002f, 0.000018f, 0.000007f, 0.000081f, 0.001267f, 0.007098f, 0.001801f, 0.063412f, 0.000000f, 0.000000f, 0.000000f, 0.000005f,
0.000001f, 0.000004f, 0.000004f, 0.000040f, 0.000007f, 0.000053f, 0.000043f, 0.000239f, 0.001705f, 0.008416f, 0.004373f, 0.076843f, 0.000000f, 0.000001f, 0.000002f, 0.000018f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000015f, 0.000016f, 0.000023f, 0.000879f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000002f, 0.000087f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000031f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000002f, 0.000071f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.003794f, 0.006552f, 0.005986f, 0.052423f, 0.004418f, 0.011209f, 0.010441f, 0.045589f, 2.189400f, 3.500450f, 2.063719f, 28.673458f, 0.009335f, 0.009300f, 0.012967f, 0.114815f,
0.000095f, 0.000323f, 0.000217f, 0.001907f, 0.000157f, 0.000782f, 0.000537f, 0.002351f, 0.093667f, 0.293182f, 0.127462f, 1.774360f, 0.000353f, 0.000688f, 0.000707f, 0.006272f,
0.000032f, 0.000109f, 0.000033f, 0.000588f, 0.000025f, 0.000124f, 0.000038f, 0.000339f, 0.035417f, 0.111340f, 0.021400f, 0.613064f, 0.000047f, 0.000092f, 0.000042f, 0.000767f,
0.000172f, 0.000514f, 0.000313f, 0.002824f, 0.000151f, 0.000662f, 0.000411f, 0.001848f, 0.088062f, 0.243892f, 0.095986f, 1.372393f, 0.000380f, 0.000656f, 0.000610f, 0.005559f,
0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000400f, 0.000997f, 0.000263f, 0.014261f, 0.000000f, 0.000001f, 0.000000f, 0.000013f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000017f, 0.000003f, 0.000183f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000018f, 0.000002f, 0.000171f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000008f, 0.000034f, 0.000006f, 0.000331f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000076f, 0.000314f, 0.000173f, 0.002687f, 0.000097f, 0.000592f, 0.000332f, 0.002574f, 0.172346f, 0.662667f, 0.234977f, 5.803444f, 0.000137f, 0.000329f, 0.000276f, 0.004339f,
0.000001f, 0.000009f, 0.000004f, 0.000059f, 0.000002f, 0.000025f, 0.000010f, 0.000080f, 0.004428f, 0.033329f, 0.008715f, 0.215657f, 0.000003f, 0.000015f, 0.000009f, 0.000142f,
0.000000f, 0.000002f, 0.000000f, 0.000010f, 0.000000f, 0.000002f, 0.000000f, 0.000007f, 0.000965f, 0.007293f, 0.000843f, 0.042935f, 0.000000f, 0.000001f, 0.000000f, 0.000010f,
0.000001f, 0.000004f, 0.000001f, 0.000023f, 0.000001f, 0.000006f, 0.000002f, 0.000017f, 0.001123f, 0.007480f, 0.001771f, 0.045001f, 0.000001f, 0.000004f, 0.000002f, 0.000034f,
0.000000f, 0.000001f, 0.000001f, 0.000020f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000480f, 0.000687f, 0.000452f, 0.025002f, 0.000000f, 0.000000f, 0.000001f, 0.000021f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000023f, 0.000064f, 0.000031f, 0.001722f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000012f, 0.000034f, 0.000007f, 0.000829f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000027f, 0.000067f, 0.000029f, 0.001663f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000243f, 0.000253f, 0.000375f, 0.003969f, 0.018312f, 0.027955f, 0.042213f, 0.222893f, 3.497816f, 3.364839f, 3.216027f, 54.034762f, 0.019729f, 0.011826f, 0.026731f, 0.286223f,
0.000009f, 0.000018f, 0.000019f, 0.000205f, 0.000927f, 0.002769f, 0.003084f, 0.016314f, 0.212417f, 0.400045f, 0.281955f, 4.746422f, 0.001058f, 0.001241f, 0.002069f, 0.022195f,
0.000001f, 0.000003f, 0.000001f, 0.000030f, 0.000070f, 0.000210f, 0.000103f, 0.001126f, 0.038448f, 0.072724f, 0.022660f, 0.785028f, 0.000068f, 0.000080f, 0.000059f, 0.001298f,
0.000009f, 0.000017f, 0.000016f, 0.000179f, 0.000522f, 0.001381f, 0.001392f, 0.007564f, 0.117749f, 0.196217f, 0.125192f, 2.164574f, 0.000672f, 0.000698f, 0.001053f, 0.011599f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000002f, 0.000005f, 0.000003f, 0.000066f, 0.003754f, 0.005626f, 0.002403f, 0.157737f, 0.000005f, 0.000004f, 0.000004f, 0.000183f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000047f, 0.000139f, 0.000044f, 0.002879f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000023f, 0.000068f, 0.000009f, 0.001284f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000061f, 0.000159f, 0.000045f, 0.003068f, 0.000000f, 0.000000f, 0.000000f, 0.000004f,
0.000005f, 0.000013f, 0.000012f, 0.000222f, 0.000438f, 0.001610f, 0.001462f, 0.013722f, 0.300176f, 0.694445f, 0.399206f, 11.922890f, 0.000316f, 0.000456f, 0.000620f, 0.011791f,
0.000000f, 0.000001f, 0.000000f, 0.000007f, 0.000013f, 0.000096f, 0.000064f, 0.000603f, 0.010947f, 0.049579f, 0.021017f, 0.628913f, 0.000010f, 0.000029f, 0.000029f, 0.000549f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000004f, 0.000001f, 0.000024f, 0.001142f, 0.005193f, 0.000973f, 0.059937f, 0.000000f, 0.000001f, 0.000000f, 0.000019f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000002f, 0.000013f, 0.000008f, 0.000075f, 0.001637f, 0.006561f, 0.002518f, 0.077379f, 0.000002f, 0.000004f, 0.000004f, 0.000077f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000053f, 0.000046f, 0.000049f, 0.003258f, 0.000000f, 0.000000f, 0.000000f, 0.000004f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000006f, 0.000005f, 0.000319f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000001f, 0.000073f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000004f, 0.000003f, 0.000181f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.615080f, 0.633686f, 1.163756f, 1.635378f, 0.648314f, 0.981207f, 1.837190f, 1.287202f, 30.437582f, 29.029524f, 34.403300f, 76.700467f, 1.960275f, 1.164929f, 3.265054f, 4.638952f,
0.043089f, 0.086908f, 0.117696f, 0.165711f, 0.064368f, 0.190720f, 0.263334f, 0.184855f, 3.626895f, 6.771986f, 5.918226f, 13.219732f, 0.206205f, 0.239901f, 0.495837f, 0.705832f,
0.023432f, 0.047467f, 0.028419f, 0.082345f, 0.016376f, 0.048732f, 0.029747f, 0.042973f, 2.210513f, 4.145302f, 1.601575f, 7.362316f, 0.044455f, 0.051944f, 0.047463f, 0.139045f,
0.083115f, 0.148331f, 0.181847f, 0.262968f, 0.065940f, 0.172877f, 0.216080f, 0.155793f, 3.654567f, 6.037786f, 4.776636f, 10.958761f, 0.238109f, 0.245115f, 0.458611f, 0.670525f,
0.000695f, 0.001115f, 0.000915f, 0.005025f, 0.000516f, 0.001216f, 0.001017f, 0.002785f, 0.238019f, 0.353645f, 0.187268f, 1.631419f, 0.003355f, 0.003106f, 0.003890f, 0.021598f,
0.000010f, 0.000032f, 0.000019f, 0.000106f, 0.000011f, 0.000049f, 0.000030f, 0.000083f, 0.005894f, 0.017143f, 0.006694f, 0.058429f, 0.000073f, 0.000133f, 0.000123f, 0.000683f,
0.000015f, 0.000047f, 0.000013f, 0.000142f, 0.000007f, 0.000034f, 0.000009f, 0.000052f, 0.009687f, 0.028299f, 0.004885f, 0.087754f, 0.000043f, 0.000078f, 0.000032f, 0.000363f,
0.000046f, 0.000127f, 0.000069f, 0.000392f, 0.000025f, 0.000104f, 0.000058f, 0.000164f, 0.013876f, 0.035714f, 0.012624f, 0.113177f, 0.000198f, 0.000317f, 0.000265f, 0.001516f,
0.021308f, 0.052793f, 0.058313f, 0.145664f, 0.024747f, 0.090072f, 0.101435f, 0.126331f, 4.164166f, 9.551099f, 6.807964f, 26.980241f, 0.050071f, 0.071559f, 0.120631f, 0.304662f,
0.000896f, 0.004348f, 0.003541f, 0.008863f, 0.001475f, 0.010513f, 0.008731f, 0.010895f, 0.297967f, 1.337966f, 0.703274f, 2.792455f, 0.003163f, 0.008849f, 0.011001f, 0.027837f,
0.000281f, 0.001368f, 0.000493f, 0.002538f, 0.000216f, 0.001548f, 0.000568f, 0.001459f, 0.104643f, 0.471922f, 0.109664f, 0.896114f, 0.000393f, 0.001104f, 0.000607f, 0.003160f,
0.000466f, 0.002002f, 0.001476f, 0.003795f, 0.000408f, 0.002571f, 0.001933f, 0.002477f, 0.081002f, 0.321833f, 0.153137f, 0.624524f, 0.000985f, 0.002439f, 0.002745f, 0.007134f,
0.000468f, 0.000431f, 0.000884f, 0.004949f, 0.000029f, 0.000040f, 0.000083f, 0.000232f, 0.054215f, 0.046290f, 0.061192f, 0.543551f, 0.000746f, 0.000397f, 0.001241f, 0.007026f,
0.000036f, 0.000066f, 0.000100f, 0.000558f, 0.000003f, 0.000009f, 0.000013f, 0.000037f, 0.007191f, 0.012020f, 0.011717f, 0.104283f, 0.000087f, 0.000091f, 0.000210f, 0.001190f,
0.000028f, 0.000050f, 0.000033f, 0.000386f, 0.000001f, 0.000003f, 0.000002f, 0.000012f, 0.006103f, 0.010246f, 0.004415f, 0.080870f, 0.000026f, 0.000027f, 0.000028f, 0.000326f,
0.000088f, 0.000140f, 0.000192f, 0.001106f, 0.000004f, 0.000010f, 0.000014f, 0.000039f, 0.009049f, 0.013383f, 0.011810f, 0.107954f, 0.000126f, 0.000116f, 0.000242f, 0.001412f,
0.000929f, 0.001804f, 0.002792f, 0.015371f, 0.010494f, 0.029936f, 0.047244f, 0.129674f, 0.811895f, 1.459488f, 1.457850f, 12.732915f, 0.001682f, 0.001884f, 0.004451f, 0.024773f,
0.000019f, 0.000072f, 0.000082f, 0.000451f, 0.000302f, 0.001686f, 0.001962f, 0.005395f, 0.028027f, 0.098636f, 0.072654f, 0.635784f, 0.000051f, 0.000112f, 0.000196f, 0.001092f,
0.000005f, 0.000020f, 0.000010f, 0.000112f, 0.000038f, 0.000215f, 0.000111f, 0.000626f, 0.008530f, 0.030151f, 0.009819f, 0.176820f, 0.000006f, 0.000012f, 0.000009f, 0.000107f,
0.000043f, 0.000145f, 0.000150f, 0.000849f, 0.000367f, 0.001813f, 0.001910f, 0.005394f, 0.033500f, 0.104317f, 0.069559f, 0.625187f, 0.000070f, 0.000136f, 0.000215f, 0.001231f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000002f, 0.000001f, 0.000014f, 0.000306f, 0.000856f, 0.000382f, 0.013040f, 0.000000f, 0.000000f, 0.000000f, 0.000006f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000012f, 0.000004f, 0.000135f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000010f, 0.000001f, 0.000101f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000030f, 0.000009f, 0.000311f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000026f, 0.000122f, 0.000114f, 0.001111f, 0.000325f, 0.002231f, 0.002117f, 0.010331f, 0.090163f, 0.389783f, 0.234174f, 3.635670f, 0.000035f, 0.000094f, 0.000133f, 0.001321f,
0.000000f, 0.000003f, 0.000002f, 0.000020f, 0.000006f, 0.000075f, 0.000053f, 0.000258f, 0.001869f, 0.015819f, 0.007008f, 0.109014f, 0.000001f, 0.000003f, 0.000004f, 0.000035f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000006f, 0.000002f, 0.000017f, 0.000328f, 0.002786f, 0.000546f, 0.017470f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000002f, 0.000001f, 0.000010f, 0.000002f, 0.000022f, 0.000014f, 0.000070f, 0.000603f, 0.004514f, 0.001810f, 0.028921f, 0.000000f, 0.000001f, 0.000001f, 0.000011f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000006f, 0.000009f, 0.000010f, 0.000354f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000020f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000008f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000024f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.001531f, 0.002547f, 0.002257f, 0.025915f, 0.001427f, 0.003487f, 0.003150f, 0.018039f, 0.874254f, 1.346123f, 0.769712f, 14.023580f, 0.002304f, 0.002211f, 0.002990f, 0.034713f,
0.000043f, 0.000141f, 0.000092f, 0.001064f, 0.000057f, 0.000275f, 0.000183f, 0.001049f, 0.042192f, 0.127183f, 0.053627f, 0.978928f, 0.000098f, 0.000184f, 0.000184f, 0.002139f,
0.000012f, 0.000041f, 0.000012f, 0.000279f, 0.000008f, 0.000037f, 0.000011f, 0.000129f, 0.013562f, 0.041057f, 0.007654f, 0.287518f, 0.000011f, 0.000021f, 0.000009f, 0.000222f,
0.000047f, 0.000137f, 0.000081f, 0.000954f, 0.000033f, 0.000141f, 0.000085f, 0.000500f, 0.024040f, 0.064119f, 0.024475f, 0.458868f, 0.000064f, 0.000107f, 0.000096f, 0.001149f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000178f, 0.000426f, 0.000109f, 0.007754f, 0.000000f, 0.000000f, 0.000000f, 0.000004f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000008f, 0.000002f, 0.000112f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000007f, 0.000001f, 0.000089f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000010f, 0.000002f, 0.000123f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000038f, 0.000151f, 0.000081f, 0.001647f, 0.000039f, 0.000228f, 0.000124f, 0.001263f, 0.085318f, 0.315923f, 0.108650f, 3.518762f, 0.000042f, 0.000097f, 0.000079f, 0.001626f,
0.000001f, 0.000005f, 0.000002f, 0.000041f, 0.000001f, 0.000011f, 0.000004f, 0.000044f, 0.002473f, 0.017924f, 0.004546f, 0.147502f, 0.000001f, 0.000005f, 0.000003f, 0.000060f,
0.000000f, 0.000001f, 0.000000f, 0.000006f, 0.000000f, 0.000001f, 0.000000f, 0.000003f, 0.000458f, 0.003334f, 0.000374f, 0.024963f, 0.000000f, 0.000000f, 0.000000f, 0.000004f,
0.000000f, 0.000001f, 0.000000f, 0.000010f, 0.000000f, 0.000001f, 0.000001f, 0.000006f, 0.000380f, 0.002438f, 0.000560f, 0.018653f, 0.000000f, 0.000001f, 0.000000f, 0.000009f,
0.000000f, 0.000001f, 0.000001f, 0.000027f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000537f, 0.000740f, 0.000472f, 0.034245f, 0.000000f, 0.000000f, 0.000000f, 0.000018f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000029f, 0.000078f, 0.000037f, 0.002661f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000013f, 0.000035f, 0.000007f, 0.001088f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000021f, 0.000049f, 0.000021f, 0.001558f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000206f, 0.000206f, 0.000297f, 0.004119f, 0.012421f, 0.018260f, 0.026743f, 0.185166f, 2.932469f, 2.716746f, 2.518379f, 55.485052f, 0.010225f, 0.005902f, 0.012940f, 0.181684f,
0.000008f, 0.000016f, 0.000017f, 0.000240f, 0.000709f, 0.002041f, 0.002204f, 0.015288f, 0.200889f, 0.364354f, 0.249064f, 5.497933f, 0.000618f, 0.000699f, 0.001130f, 0.015893f,
0.000001f, 0.000002f, 0.000001f, 0.000030f, 0.000046f, 0.000132f, 0.000063f, 0.000897f, 0.030909f, 0.056304f, 0.017015f, 0.772980f, 0.000034f, 0.000038f, 0.000027f, 0.000790f,
0.000005f, 0.000009f, 0.000009f, 0.000127f, 0.000242f, 0.000617f, 0.000603f, 0.004296f, 0.067488f, 0.108306f, 0.067021f, 1.519516f, 0.000238f, 0.000238f, 0.000348f, 0.005034f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000002f, 0.000003f, 0.000002f, 0.000061f, 0.003499f, 0.005050f, 0.002092f, 0.180066f, 0.000003f, 0.000002f, 0.000002f, 0.000129f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000050f, 0.000141f, 0.000043f, 0.003708f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000021f, 0.000059f, 0.000008f, 0.001406f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000039f, 0.000098f, 0.000027f, 0.002394f, 0.000000f, 0.000000f, 0.000000f, 0.000002f,
0.000006f, 0.000013f, 0.000012f, 0.000285f, 0.000369f, 0.001304f, 0.001148f, 0.014132f, 0.311987f, 0.695101f, 0.387547f, 15.177824f, 0.000203f, 0.000282f, 0.000372f, 0.009279f,
0.000000f, 0.000001f, 0.000000f, 0.000010f, 0.000013f, 0.000087f, 0.000057f, 0.000701f, 0.012834f, 0.055981f, 0.023016f, 0.903126f, 0.000007f, 0.000020f, 0.000019f, 0.000487f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000003f, 0.000001f, 0.000024f, 0.001138f, 0.004985f, 0.000906f, 0.073165f, 0.000000f, 0.000001f, 0.000000f, 0.000014f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000007f, 0.000004f, 0.000053f, 0.001163f, 0.004489f, 0.001671f, 0.067341f, 0.000001f, 0.000002f, 0.000002f, 0.000042f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000124f, 0.000103f, 0.000107f, 0.009368f, 0.000000f, 0.000000f, 0.000000f, 0.000007f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000009f, 0.000015f, 0.000012f, 0.001033f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000003f, 0.000001f, 0.000202f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000004f, 0.000006f, 0.000004f, 0.000357f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.596535f, 0.591870f, 1.054219f, 1.942625f, 0.503271f, 0.733544f, 1.332097f, 1.223855f, 29.205627f, 26.825310f, 30.833405f, 90.140684f, 1.162738f, 0.665446f, 1.808924f, 3.370164f,
0.047141f, 0.091567f, 0.120271f, 0.222050f, 0.056366f, 0.160839f, 0.215386f, 0.198265f, 3.925741f, 7.059129f, 5.983335f, 17.525716f, 0.137973f, 0.154588f, 0.309884f, 0.578446f,
0.021792f, 0.042513f, 0.024687f, 0.093797f, 0.012190f, 0.034935f, 0.020682f, 0.039180f, 2.033900f, 3.673173f, 1.376414f, 8.296937f, 0.025285f, 0.028453f, 0.025215f, 0.096865f,
0.055108f, 0.094714f, 0.112617f, 0.213552f, 0.034994f, 0.088355f, 0.107109f, 0.101265f, 2.397302f, 3.814282f, 2.926669f, 8.804693f, 0.096554f, 0.095722f, 0.173702f, 0.333025f,
0.000749f, 0.001158f, 0.000922f, 0.006636f, 0.000445f, 0.001010f, 0.000820f, 0.002943f, 0.253901f, 0.363304f, 0.186587f, 2.131500f, 0.002213f, 0.001973f, 0.002396f, 0.017444f,
0.000012f, 0.000037f, 0.000022f, 0.000158f, 0.000010f, 0.000046f, 0.000028f, 0.000099f, 0.007092f, 0.019866f, 0.007524f, 0.086115f, 0.000055f, 0.000095f, 0.000085f, 0.000622f,
0.000015f, 0.000047f, 0.000012f, 0.000180f, 0.000006f, 0.000027f, 0.000007f, 0.000053f, 0.009909f, 0.027877f, 0.004668f, 0.109943f, 0.000027f, 0.000047f, 0.000019f, 0.000281f,
0.000034f, 0.000090f, 0.000048f, 0.000354f, 0.000015f, 0.000059f, 0.000032f, 0.000118f, 0.010119f, 0.025082f, 0.008599f, 0.101090f, 0.000089f, 0.000138f, 0.000112f, 0.000837f,
0.025619f, 0.061130f, 0.065488f, 0.214510f, 0.023816f, 0.083479f, 0.091179f, 0.148908f, 4.953470f, 10.941667f, 7.564215f, 39.309171f, 0.036819f, 0.050676f, 0.082854f, 0.274394f,
0.001216f, 0.005679f, 0.004486f, 0.014724f, 0.001602f, 0.010992f, 0.008853f, 0.014486f, 0.399835f, 1.729042f, 0.881458f, 4.589490f, 0.002624f, 0.007069f, 0.008523f, 0.028282f,
0.000324f, 0.001519f, 0.000531f, 0.003584f, 0.000200f, 0.001376f, 0.000490f, 0.001649f, 0.119364f, 0.518419f, 0.116840f, 1.251963f, 0.000277f, 0.000750f, 0.000400f, 0.002729f,
0.000383f, 0.001585f, 0.001133f, 0.003820f, 0.000268f, 0.001629f, 0.001188f, 0.001996f, 0.065873f, 0.252053f, 0.116320f, 0.622053f, 0.000495f, 0.001181f, 0.001289f, 0.004393f,
0.001271f, 0.001129f, 0.002242f, 0.016464f, 0.000064f, 0.000083f, 0.000169f, 0.000617f, 0.145690f, 0.119797f, 0.153592f, 1.789021f, 0.001240f, 0.000635f, 0.001926f, 0.014294f,
0.000112f, 0.000194f, 0.000285f, 0.002095f, 0.000008f, 0.000020f, 0.000030f, 0.000111f, 0.021799f, 0.035091f, 0.033177f, 0.387184f, 0.000164f, 0.000164f, 0.000367f, 0.002731f,
0.000072f, 0.000126f, 0.000081f, 0.001232f, 0.000002f, 0.000006f, 0.000004f, 0.000031f, 0.015726f, 0.025426f, 0.010627f, 0.255235f, 0.000042f, 0.000042f, 0.000042f, 0.000637f,
0.000163f, 0.000251f, 0.000333f, 0.002516f, 0.000006f, 0.000014f, 0.000019f, 0.000071f, 0.016623f, 0.023678f, 0.020265f, 0.242909f, 0.000143f, 0.000127f, 0.000257f, 0.001963f,
0.000648f, 0.001211f, 0.001818f, 0.013123f, 0.005855f, 0.016085f, 0.024620f, 0.088612f, 0.559901f, 0.969306f, 0.939052f, 10.754886f, 0.000717f, 0.000773f, 0.001772f, 0.012935f,
0.000015f, 0.000054f, 0.000060f, 0.000435f, 0.000190f, 0.001022f, 0.001153f, 0.004159f, 0.021803f, 0.073897f, 0.052792f, 0.605784f, 0.000025f, 0.000052f, 0.000088f, 0.000643f,
0.000003f, 0.000013f, 0.000006f, 0.000092f, 0.000021f, 0.000111f, 0.000055f, 0.000410f, 0.005641f, 0.019202f, 0.006065f, 0.143215f, 0.000002f, 0.000005f, 0.000004f, 0.000054f,
0.000021f, 0.000067f, 0.000067f, 0.000496f, 0.000140f, 0.000666f, 0.000680f, 0.002520f, 0.015794f, 0.047364f, 0.030631f, 0.361009f, 0.000020f, 0.000038f, 0.000058f, 0.000439f,
0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000000f, 0.000001f, 0.000001f, 0.000010f, 0.000234f, 0.000632f, 0.000274f, 0.012245f, 0.000000f, 0.000000f, 0.000000f, 0.000003f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000010f, 0.000003f, 0.000143f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000007f, 0.000001f, 0.000091f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000015f, 0.000004f, 0.000200f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000023f, 0.000102f, 0.000092f, 0.001176f, 0.000225f, 0.001486f, 0.001368f, 0.008752f, 0.077084f, 0.320928f, 0.187000f, 3.807040f, 0.000018f, 0.000048f, 0.000066f, 0.000855f,
0.000000f, 0.000003f, 0.000002f, 0.000023f, 0.000004f, 0.000057f, 0.000038f, 0.000247f, 0.001803f, 0.014692f, 0.006313f, 0.128770f, 0.000000f, 0.000002f, 0.000002f, 0.000026f,
0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000000f, 0.000004f, 0.000001f, 0.000014f, 0.000269f, 0.002200f, 0.000418f, 0.017542f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.000000f, 0.000001f, 0.000001f, 0.000007f, 0.000001f, 0.000010f, 0.000006f, 0.000040f, 0.000352f, 0.002541f, 0.000988f, 0.020703f, 0.000000f, 0.000000f, 0.000000f, 0.000005f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000011f, 0.000017f, 0.000018f, 0.000837f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000053f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000017f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000039f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
};

static const float acceptor_me2x3acc1[16384] = {
0.194114f, 0.254369f, 0.059224f, 0.479611f, 0.184195f, 0.431590f, 0.364757f, 0.677230f, 0.039156f, 0.074210f, 0.046061f, 0.142616f, 0.263375f, 0.540027f, 0.492918f, 0.741151f,
0.196628f, 0.370974f, 0.085338f, 0.772998f, 0.163797f, 0.552574f, 0.461409f, 0.958220f, 0.116240f, 0.317182f, 0.194511f, 0.673638f, 0.250918f, 0.740738f, 0.668017f, 1.123481f,
0.052415f, 0.117194f, 0.024461f, 0.180371f, 0.066584f, 0.266197f, 0.201679f, 0.340960f, 0.037786f, 0.122190f, 0.067988f, 0.191682f, 0.081306f, 0.284450f, 0.232751f, 0.318665f,
0.304223f, 0.440426f, 0.084923f, 0.930491f, 0.255470f, 0.661310f, 0.462862f, 1.162744f, 0.211373f, 0.442572f, 0.227494f, 0.953032f, 0.335322f, 0.759586f, 0.574182f, 1.168105f,
0.145656f, 0.232551f, 0.041391f, 0.372302f, 0.134074f, 0.382754f, 0.247288f, 0.509960f, 0.039260f, 0.090656f, 0.043015f, 0.147930f, 0.246315f, 0.615336f, 0.429361f, 0.717061f,
0.207366f, 0.476669f, 0.083824f, 0.843342f, 0.167569f, 0.688744f, 0.439648f, 1.014110f, 0.163806f, 0.544582f, 0.255300f, 0.982053f, 0.329812f, 1.186261f, 0.817813f, 1.527686f,
0.121829f, 0.331880f, 0.052954f, 0.433706f, 0.150127f, 0.731262f, 0.423528f, 0.795293f, 0.117358f, 0.462374f, 0.196672f, 0.615874f, 0.235539f, 1.003979f, 0.628002f, 0.955004f,
0.292668f, 0.516223f, 0.076092f, 0.926038f, 0.238406f, 0.751906f, 0.402310f, 1.122523f, 0.271717f, 0.693156f, 0.272375f, 1.267379f, 0.402058f, 1.109644f, 0.641221f, 1.448911f,
0.050828f, 0.081012f, 0.015369f, 0.126731f, 0.072420f, 0.206391f, 0.142132f, 0.268697f, 0.018783f, 0.043298f, 0.021898f, 0.069037f, 0.110917f, 0.276615f, 0.205733f, 0.314974f,
0.067112f, 0.154005f, 0.028867f, 0.266243f, 0.083945f, 0.344441f, 0.234358f, 0.495561f, 0.072683f, 0.241225f, 0.120539f, 0.425059f, 0.137740f, 0.494574f, 0.363432f, 0.622358f,
0.036190f, 0.098419f, 0.016738f, 0.125675f, 0.069030f, 0.335666f, 0.207222f, 0.356712f, 0.047796f, 0.187988f, 0.085231f, 0.244672f, 0.090289f, 0.384196f, 0.256158f, 0.357099f,
0.128070f, 0.225511f, 0.035431f, 0.395288f, 0.161483f, 0.508429f, 0.289965f, 0.741681f, 0.163015f, 0.415145f, 0.173882f, 0.741704f, 0.227034f, 0.625525f, 0.385289f, 0.798100f,
0.181327f, 0.197654f, 0.051343f, 0.382130f, 0.162262f, 0.316260f, 0.298206f, 0.508848f, 0.033636f, 0.053028f, 0.036721f, 0.104494f, 0.317780f, 0.542005f, 0.551954f, 0.762736f,
0.185977f, 0.291874f, 0.074909f, 0.623605f, 0.146101f, 0.409990f, 0.381952f, 0.728999f, 0.101106f, 0.229489f, 0.157014f, 0.499759f, 0.306545f, 0.752769f, 0.757400f, 1.170692f,
0.137800f, 0.256290f, 0.059681f, 0.404458f, 0.165079f, 0.548985f, 0.464044f, 0.721011f, 0.091354f, 0.245734f, 0.152547f, 0.395267f, 0.276097f, 0.803487f, 0.733508f, 0.922968f,
0.325774f, 0.392314f, 0.084396f, 0.849869f, 0.257985f, 0.555515f, 0.433793f, 1.001508f, 0.208150f, 0.362533f, 0.207909f, 0.800479f, 0.463802f, 0.873942f, 0.737048f, 1.378058f,
0.238641f, 0.435520f, 0.076985f, 0.625056f, 0.257179f, 0.839233f, 0.538490f, 1.002384f, 0.052200f, 0.137781f, 0.064927f, 0.201551f, 0.405784f, 1.158756f, 0.802996f, 1.210514f,
0.262777f, 0.690465f, 0.120588f, 1.095123f, 0.248610f, 1.168038f, 0.740484f, 1.541765f, 0.168456f, 0.640166f, 0.298051f, 1.034899f, 0.420250f, 1.727808f, 1.182990f, 1.994727f,
0.070265f, 0.218797f, 0.034671f, 0.256324f, 0.101372f, 0.564427f, 0.324660f, 0.550295f, 0.054929f, 0.247376f, 0.104501f, 0.295387f, 0.136596f, 0.665542f, 0.413450f, 0.567532f,
0.392706f, 0.791780f, 0.115909f, 1.273298f, 0.374527f, 1.350221f, 0.717486f, 1.807051f, 0.295878f, 0.862784f, 0.336706f, 1.414204f, 0.542464f, 1.711359f, 0.982147f, 2.003241f,
0.171132f, 0.380517f, 0.051419f, 0.463701f, 0.178902f, 0.711285f, 0.348891f, 0.721353f, 0.050020f, 0.160857f, 0.057946f, 0.199796f, 0.362680f, 1.261832f, 0.668458f, 1.119263f,
0.264845f, 0.847867f, 0.113199f, 1.141831f, 0.243062f, 1.391353f, 0.674291f, 1.559378f, 0.226868f, 1.050416f, 0.373861f, 1.441848f, 0.527905f, 2.644385f, 1.384080f, 2.592180f,
0.156080f, 0.592148f, 0.071731f, 0.589022f, 0.218435f, 1.481805f, 0.651574f, 1.226682f, 0.163040f, 0.894602f, 0.288896f, 0.907016f, 0.378173f, 2.244954f, 1.066121f, 1.625455f,
0.361048f, 0.886915f, 0.099254f, 1.211045f, 0.334021f, 1.467157f, 0.595986f, 1.667228f, 0.363489f, 1.291404f, 0.385267f, 1.797316f, 0.621599f, 2.389248f, 1.048209f, 2.374685f,
0.124872f, 0.277183f, 0.039924f, 0.330054f, 0.202063f, 0.801998f, 0.419312f, 0.794753f, 0.050040f, 0.160646f, 0.061684f, 0.194972f, 0.341499f, 1.186109f, 0.669754f, 1.028041f,
0.179231f, 0.572805f, 0.081515f, 0.753764f, 0.254610f, 1.454968f, 0.751591f, 1.593392f, 0.210491f, 0.972925f, 0.369102f, 1.304946f, 0.461008f, 2.305337f, 1.286143f, 2.208158f,
0.096950f, 0.367187f, 0.047411f, 0.356897f, 0.210019f, 1.422280f, 0.666616f, 1.150486f, 0.138845f, 0.760547f, 0.261792f, 0.753470f, 0.303124f, 1.796368f, 0.909311f, 1.270919f,
0.330366f, 0.810160f, 0.096639f, 1.080946f, 0.473089f, 2.074448f, 0.898216f, 2.303435f, 0.455997f, 1.617298f, 0.514289f, 2.199416f, 0.733960f, 2.816313f, 1.317000f, 2.735148f,
0.230008f, 0.349173f, 0.068862f, 0.513845f, 0.233756f, 0.634522f, 0.454236f, 0.777101f, 0.046267f, 0.101584f, 0.053407f, 0.152370f, 0.505171f, 1.199972f, 0.927753f, 1.285370f,
0.256445f, 0.560512f, 0.109216f, 0.911560f, 0.228800f, 0.894192f, 0.632455f, 1.210240f, 0.151180f, 0.477902f, 0.248243f, 0.792180f, 0.529737f, 1.811692f, 1.383917f, 2.144627f,
0.190599f, 0.493697f, 0.087282f, 0.593045f, 0.259318f, 1.201039f, 0.770759f, 1.200673f, 0.137021f, 0.513311f, 0.241925f, 0.628481f, 0.478594f, 1.939724f, 1.344399f, 1.696033f,
0.433894f, 0.727706f, 0.118853f, 1.199945f, 0.390238f, 1.170273f, 0.693802f, 1.605950f, 0.300629f, 0.729217f, 0.317501f, 1.225592f, 0.774163f, 2.031601f, 1.300811f, 2.438428f,
0.071432f, 0.135133f, 0.021986f, 0.200242f, 0.083200f, 0.281432f, 0.166209f, 0.347063f, 0.018481f, 0.050564f, 0.021931f, 0.076369f, 0.130629f, 0.386669f, 0.246630f, 0.417061f,
0.066959f, 0.182377f, 0.029317f, 0.298658f, 0.068467f, 0.333445f, 0.194567f, 0.454431f, 0.050770f, 0.199995f, 0.085705f, 0.333817f, 0.115167f, 0.490816f, 0.309307f, 0.585046f,
0.020121f, 0.064948f, 0.009473f, 0.078559f, 0.031374f, 0.181079f, 0.095868f, 0.182280f, 0.018605f, 0.086852f, 0.033770f, 0.107077f, 0.042068f, 0.212467f, 0.121486f, 0.187063f,
0.107373f, 0.224407f, 0.030237f, 0.372602f, 0.110675f, 0.413595f, 0.202288f, 0.571510f, 0.095684f, 0.289224f, 0.103888f, 0.489470f, 0.159512f, 0.521636f, 0.275543f, 0.630439f,
0.045260f, 0.104318f, 0.012975f, 0.131252f, 0.051137f, 0.210749f, 0.095147f, 0.220675f, 0.015647f, 0.052158f, 0.017294f, 0.066889f, 0.103157f, 0.372032f, 0.181400f, 0.340717f,
0.059628f, 0.197874f, 0.024316f, 0.275134f, 0.059144f, 0.350942f, 0.156542f, 0.406100f, 0.060413f, 0.289948f, 0.094985f, 0.410924f, 0.127822f, 0.663711f, 0.319743f, 0.671742f,
0.039491f, 0.155304f, 0.017316f, 0.159502f, 0.059732f, 0.420032f, 0.169996f, 0.359009f, 0.048791f, 0.277512f, 0.082486f, 0.290502f, 0.102904f, 0.633220f, 0.276783f, 0.473375f,
0.087222f, 0.222098f, 0.022877f, 0.313117f, 0.087211f, 0.397081f, 0.148465f, 0.465886f, 0.103860f, 0.382494f, 0.105029f, 0.549629f, 0.161497f, 0.643457f, 0.259831f, 0.660309f,
0.032530f, 0.074849f, 0.009923f, 0.092021f, 0.056891f, 0.234062f, 0.112637f, 0.239482f, 0.015418f, 0.051308f, 0.018133f, 0.064294f, 0.095675f, 0.344459f, 0.179025f, 0.308252f,
0.039747f, 0.131674f, 0.017247f, 0.178901f, 0.061025f, 0.361482f, 0.171870f, 0.408732f, 0.055211f, 0.264529f, 0.092369f, 0.366327f, 0.109950f, 0.569933f, 0.292660f, 0.563640f,
0.024162f, 0.094858f, 0.011273f, 0.095195f, 0.056569f, 0.397110f, 0.171312f, 0.331657f, 0.040927f, 0.232387f, 0.073625f, 0.237703f, 0.081245f, 0.499088f, 0.232531f, 0.364571f,
0.078612f, 0.199834f, 0.021940f, 0.275286f, 0.121668f, 0.553018f, 0.220395f, 0.634009f, 0.128338f, 0.471831f, 0.138099f, 0.662502f, 0.187828f, 0.747091f, 0.321562f, 0.749129f,
0.076356f, 0.120156f, 0.021811f, 0.182566f, 0.083869f, 0.235988f, 0.155493f, 0.298403f, 0.018167f, 0.041346f, 0.020007f, 0.064031f, 0.180357f, 0.444089f, 0.316022f, 0.491146f,
0.072472f, 0.164197f, 0.029448f, 0.275708f, 0.069883f, 0.283106f, 0.184304f, 0.395616f, 0.050533f, 0.165584f, 0.079167f, 0.283391f, 0.161002f, 0.570768f, 0.401301f, 0.697606f,
0.060533f, 0.162530f, 0.026448f, 0.201578f, 0.089010f, 0.427335f, 0.252415f, 0.441082f, 0.051470f, 0.199872f, 0.086704f, 0.252666f, 0.163467f, 0.686764f, 0.438108f, 0.619990f,
0.131572f, 0.228739f, 0.034386f, 0.389429f, 0.127893f, 0.397566f, 0.216942f, 0.563297f, 0.107823f, 0.271106f, 0.108646f, 0.470448f, 0.252468f, 0.686779f, 0.404742f, 0.851082f,
0.254579f, 0.420878f, 0.067651f, 0.623936f, 0.315714f, 0.933283f, 0.544539f, 1.151427f, 0.057210f, 0.136790f, 0.058615f, 0.206692f, 0.412654f, 1.067467f, 0.672662f, 1.151872f,
0.257672f, 0.613327f, 0.097404f, 1.004814f, 0.280530f, 1.193958f, 0.688285f, 1.627880f, 0.169700f, 0.584199f, 0.247332f, 0.975524f, 0.392826f, 1.463052f, 0.910890f, 1.744695f,
0.064821f, 0.182847f, 0.026347f, 0.221263f, 0.107616f, 0.542796f, 0.283909f, 0.546635f, 0.052059f, 0.212385f, 0.081584f, 0.261956f, 0.120124f, 0.530196f, 0.299506f, 0.467007f,
0.374581f, 0.684154f, 0.091073f, 1.136453f, 0.411096f, 1.342566f, 0.648732f, 1.855980f, 0.289940f, 0.765894f, 0.271793f, 1.296732f, 0.493245f, 1.409626f, 0.735631f, 1.704385f,
0.206179f, 0.415299f, 0.051031f, 0.522753f, 0.248034f, 0.893329f, 0.398454f, 0.935810f, 0.061912f, 0.180361f, 0.059081f, 0.231399f, 0.416536f, 1.312808f, 0.632404f, 1.202828f,
0.293298f, 0.850581f, 0.103264f, 1.183210f, 0.309753f, 1.606227f, 0.707844f, 1.859487f, 0.258111f, 1.082596f, 0.350378f, 1.534958f, 0.557296f, 2.528867f, 1.203603f, 2.560581f,
0.162615f, 0.558876f, 0.061562f, 0.574233f, 0.261889f, 1.609376f, 0.643503f, 1.376165f, 0.174511f, 0.867425f, 0.254721f, 0.908425f, 0.375593f, 2.019788f, 0.872219f, 1.510585f,
0.388937f, 0.865503f, 0.088075f, 1.220728f, 0.414067f, 1.647573f, 0.608591f, 1.933904f, 0.402276f, 1.294690f, 0.351225f, 1.861230f, 0.638321f, 2.222600f, 0.886684f, 2.281802f,
0.179228f, 0.360395f, 0.047203f, 0.443272f, 0.333742f, 1.199963f, 0.570496f, 1.228284f, 0.073786f, 0.214585f, 0.074925f, 0.269014f, 0.467245f, 1.470114f, 0.754853f, 1.316160f,
0.236460f, 0.684575f, 0.088588f, 0.930513f, 0.386546f, 2.001013f, 0.939937f, 2.263555f, 0.285295f, 1.194569f, 0.412097f, 1.654994f, 0.579782f, 2.626411f, 1.332411f, 2.598545f,
0.120333f, 0.412856f, 0.048475f, 0.414502f, 0.299972f, 1.840257f, 0.784314f, 1.537611f, 0.177047f, 0.878526f, 0.274983f, 0.899015f, 0.358653f, 1.925397f, 0.886255f, 1.407067f,
0.423972f, 0.941855f, 0.102162f, 1.298043f, 0.698661f, 2.775221f, 1.092689f, 3.183046f, 0.601203f, 1.931614f, 0.558546f, 2.713375f, 0.897900f, 3.121101f, 1.327191f, 3.130975f,
0.282684f, 0.388752f, 0.069716f, 0.590928f, 0.330601f, 0.812942f, 0.529194f, 1.028400f, 0.058419f, 0.116191f, 0.055548f, 0.180020f, 0.591850f, 1.273549f, 0.895361f, 1.409110f,
0.289705f, 0.573611f, 0.101635f, 0.963586f, 0.297440f, 1.053041f, 0.677275f, 1.472170f, 0.175458f, 0.502445f, 0.237327f, 0.860292f, 0.570474f, 1.767384f, 1.227658f, 2.161077f,
0.202572f, 0.475324f, 0.076415f, 0.589780f, 0.317157f, 1.330664f, 0.776517f, 1.374068f, 0.149611f, 0.507723f, 0.217595f, 0.642112f, 0.484886f, 1.780260f, 1.121999f, 1.607865f,
0.476809f, 0.724415f, 0.107588f, 1.233857f, 0.493482f, 1.340603f, 0.722720f, 1.900279f, 0.339398f, 0.745771f, 0.295267f, 1.294692f, 0.810973f, 1.927895f, 1.122484f, 2.390160f,
0.230052f, 0.301463f, 0.070189f, 0.568405f, 0.279227f, 0.654260f, 0.552945f, 1.026632f, 0.054683f, 0.103637f, 0.064326f, 0.199170f, 0.343024f, 0.703341f, 0.641985f, 0.965288f,
0.311947f, 0.588545f, 0.135388f, 1.226351f, 0.332394f, 1.121339f, 0.936339f, 1.944517f, 0.217310f, 0.592967f, 0.363636f, 1.259359f, 0.437472f, 1.291464f, 1.164676f, 1.958770f,
0.064795f, 0.144873f, 0.030238f, 0.222971f, 0.105284f, 0.420916f, 0.318900f, 0.539134f, 0.055043f, 0.177993f, 0.099038f, 0.279222f, 0.110456f, 0.386429f, 0.316195f, 0.432910f,
0.503707f, 0.729221f, 0.140608f, 1.540629f, 0.541048f, 1.400559f, 0.980274f, 2.462522f, 0.412404f, 0.863489f, 0.443856f, 1.859429f, 0.610140f, 1.382114f, 1.044761f, 2.125442f,
0.233699f, 0.373118f, 0.066410f, 0.597343f, 0.275159f, 0.785520f, 0.507505f, 1.046585f, 0.074228f, 0.171400f, 0.081327f, 0.279687f, 0.434310f, 1.084980f, 0.757062f, 1.264344f,
0.445382f, 1.023793f, 0.180038f, 1.811339f, 0.460361f, 1.892185f, 1.207844f, 2.786064f, 0.414584f, 1.378306f, 0.646148f, 2.485518f, 0.778474f, 2.799995f, 1.930329f, 3.605879f,
0.203889f, 0.555421f, 0.088621f, 0.725833f, 0.321374f, 1.565397f, 0.906639f, 1.702468f, 0.231441f, 0.911846f, 0.387856f, 1.214562f, 0.433197f, 1.846492f, 1.155005f, 1.756419f,
0.656025f, 1.157131f, 0.170563f, 2.075746f, 0.683553f, 2.155852f, 1.153497f, 3.218479f, 0.717708f, 1.830891f, 0.719448f, 3.347636f, 0.990409f, 2.733444f, 1.579553f, 3.569178f,
0.069707f, 0.111102f, 0.021078f, 0.173801f, 0.127039f, 0.362051f, 0.249328f, 0.471349f, 0.030355f, 0.069972f, 0.035389f, 0.111568f, 0.167166f, 0.416896f, 0.310067f, 0.474708f,
0.123207f, 0.282731f, 0.052996f, 0.488783f, 0.197125f, 0.808840f, 0.550336f, 1.163711f, 0.157238f, 0.521851f, 0.260766f, 0.919545f, 0.277894f, 0.997815f, 0.733233f, 1.255622f,
0.051770f, 0.140787f, 0.023944f, 0.179776f, 0.126308f, 0.614188f, 0.379166f, 0.652696f, 0.080568f, 0.316884f, 0.143671f, 0.412433f, 0.141938f, 0.603974f, 0.402692f, 0.561376f,
0.245377f, 0.432070f, 0.067885f, 0.757358f, 0.395753f, 1.246029f, 0.710630f, 1.817669f, 0.368045f, 0.937288f, 0.392580f, 1.674573f, 0.478035f, 1.317082f, 0.811251f, 1.680452f,
0.398167f, 0.434019f, 0.112742f, 0.839099f, 0.455751f, 0.888293f, 0.837584f, 1.429224f, 0.087036f, 0.137212f, 0.095018f, 0.270384f, 0.766850f, 1.307938f, 1.331945f, 1.840593f,
0.546677f, 0.857957f, 0.220194f, 1.833072f, 0.549330f, 1.541534f, 1.436115f, 2.740989f, 0.350212f, 0.794912f, 0.543870f, 1.731081f, 0.990251f, 2.431719f, 2.446676f, 3.781761f,
0.315620f, 0.587014f, 0.136695f, 0.926380f, 0.483636f, 1.608373f, 1.359520f, 2.112359f, 0.246565f, 0.663235f, 0.411724f, 1.066824f, 0.694959f, 2.022443f, 1.846298f, 2.323185f,
0.999393f, 1.203519f, 0.258907f, 2.607183f, 1.012334f, 2.179845f, 1.702206f, 3.929924f, 0.752460f, 1.310549f, 0.751587f, 2.893715f, 1.563627f, 2.946345f, 2.484830f, 4.645885f,
0.302687f, 0.552404f, 0.097646f, 0.792808f, 0.417248f, 1.361577f, 0.873649f, 1.626273f, 0.078021f, 0.205933f, 0.097042f, 0.301245f, 0.565622f, 1.615186f, 1.119294f, 1.687331f,
0.446174f, 1.172353f, 0.204749f, 1.859430f, 0.539939f, 2.536787f, 1.608210f, 3.348462f, 0.337046f, 1.280843f, 0.596340f, 2.070625f, 0.784162f, 3.223991f, 2.207391f, 3.722045f,
0.092961f, 0.289471f, 0.045870f, 0.339119f, 0.171551f, 0.955170f, 0.549417f, 0.931256f, 0.085635f, 0.385663f, 0.162918f, 0.460511f, 0.198602f, 0.967653f, 0.601129f, 0.825153f,
0.695880f, 1.403043f, 0.205392f, 2.256299f, 0.848907f, 3.060423f, 1.626261f, 4.095879f, 0.617825f, 1.801587f, 0.703078f, 2.953009f, 1.056377f, 3.332643f, 1.912601f, 3.901044f,
0.293859f, 0.653406f, 0.088294f, 0.796245f, 0.392947f, 1.562293f, 0.766316f, 1.584406f, 0.101213f, 0.325487f, 0.117252f, 0.404279f, 0.684406f, 2.381175f, 1.261432f, 2.112135f,
0.608792f, 1.948965f, 0.260207f, 2.624690f, 0.714667f, 4.090946f, 1.982592f, 4.584984f, 0.614519f, 2.845273f, 1.012682f, 3.905548f, 1.333562f, 6.680086f, 3.496379f, 6.548210f,
0.279556f, 1.060603f, 0.128478f, 1.055003f, 0.500443f, 3.394872f, 1.492779f, 2.810375f, 0.344114f, 1.888159f, 0.609748f, 1.914360f, 0.744378f, 4.418866f, 2.098505f, 3.199472f,
0.866144f, 2.127686f, 0.238107f, 2.905266f, 1.024967f, 4.502072f, 1.828825f, 5.116002f, 1.027552f, 3.650684f, 1.089114f, 5.080852f, 1.638767f, 6.298951f, 2.763470f, 6.260556f,
0.183280f, 0.406834f, 0.058598f, 0.484436f, 0.379356f, 1.505684f, 0.787223f, 1.492083f, 0.086547f, 0.277848f, 0.106687f, 0.337217f, 0.550835f, 1.913182f, 1.080307f, 1.658219f,
0.352153f, 1.125446f, 0.160161f, 1.480996f, 0.639888f, 3.656637f, 1.888903f, 4.004525f, 0.487347f, 2.252598f, 0.854577f, 3.021322f, 0.995423f, 4.977758f, 2.777081f, 4.767925f,
0.148426f, 0.562149f, 0.072585f, 0.546396f, 0.411276f, 2.785219f, 1.305419f, 2.252970f, 0.250485f, 1.372070f, 0.472288f, 1.359304f, 0.509995f, 3.022321f, 1.529882f, 2.138273f,
0.677428f, 1.661262f, 0.198162f, 2.216520f, 1.240854f, 5.441021f, 2.355908f, 6.041625f, 1.101834f, 3.907904f, 1.242686f, 5.314487f, 1.653946f, 6.346435f, 2.967800f, 6.163532f,
0.540536f, 0.820585f, 0.161831f, 1.207576f, 0.702677f, 1.907390f, 1.365445f, 2.335987f, 0.128128f, 0.281316f, 0.147900f, 0.421959f, 1.304676f, 3.099097f, 2.396054f, 3.319651f,
0.806761f, 1.763336f, 0.343588f, 2.867716f, 0.920696f, 3.598249f, 2.545013f, 4.870036f, 0.560444f, 1.771640f, 0.920267f, 2.936706f, 1.831439f, 6.263488f, 4.784557f, 7.414530f,
0.467216f, 1.210199f, 0.213955f, 1.453732f, 0.813092f, 3.765855f, 2.416712f, 3.764709f, 0.395796f, 1.482733f, 0.698818f, 1.815410f, 1.289275f, 5.225378f, 3.621645f, 4.568904f,
1.424570f, 2.389220f, 0.390220f, 3.939683f, 1.638853f, 4.914702f, 2.913708f, 6.744384f, 1.163102f, 2.821260f, 1.228377f, 4.741681f, 2.793276f, 7.330266f, 4.693484f, 8.798148f,
0.149690f, 0.283178f, 0.046073f, 0.419618f, 0.223014f, 0.754368f, 0.445516f, 0.930288f, 0.045636f, 0.124861f, 0.054156f, 0.188584f, 0.300829f, 0.890471f, 0.567972f, 0.960462f,
0.187836f, 0.511608f, 0.082240f, 0.837802f, 0.245673f, 1.196467f, 0.698144f, 1.630592f, 0.167827f, 0.661110f, 0.283307f, 1.103473f, 0.355038f, 1.513098f, 0.953538f, 1.803590f,
0.043981f, 0.141963f, 0.020706f, 0.171714f, 0.087720f, 0.506279f, 0.268038f, 0.509637f, 0.047920f, 0.223706f, 0.086981f, 0.275799f, 0.101052f, 0.510370f, 0.291823f, 0.449348f,
0.314349f, 0.656981f, 0.088522f, 1.090841f, 0.414454f, 1.548824f, 0.757524f, 2.140181f, 0.330098f, 0.997783f, 0.358402f, 1.688607f, 0.513206f, 1.678284f, 0.886516f, 2.028339f,
0.128401f, 0.295949f, 0.036809f, 0.372360f, 0.185567f, 0.764777f, 0.345276f, 0.800795f, 0.052308f, 0.174368f, 0.057815f, 0.223613f, 0.321616f, 1.159898f, 0.565559f, 1.062265f,
0.226451f, 0.751474f, 0.092345f, 1.044890f, 0.287308f, 1.704794f, 0.760444f, 1.972736f, 0.270359f, 1.297575f, 0.425077f, 1.838965f, 0.533474f, 2.770042f, 1.334469f, 2.803560f,
0.116860f, 0.459574f, 0.051241f, 0.471997f, 0.226095f, 1.589879f, 0.643461f, 1.358901f, 0.170137f, 0.967698f, 0.287632f, 1.012996f, 0.334647f, 2.059244f, 0.900103f, 1.539424f,
0.345700f, 0.880280f, 0.090672f, 1.241029f, 0.442138f, 2.013094f, 0.752678f, 2.361920f, 0.485078f, 1.786431f, 0.490536f, 2.567034f, 0.703430f, 2.802697f, 1.131744f, 2.876098f,
0.078882f, 0.181504f, 0.024062f, 0.223145f, 0.176462f, 0.726006f, 0.349374f, 0.742818f, 0.044057f, 0.146614f, 0.051816f, 0.183722f, 0.254965f, 0.917951f, 0.477085f, 0.821462f,
0.129024f, 0.427434f, 0.055987f, 0.580739f, 0.253386f, 1.500944f, 0.713638f, 1.697136f, 0.211192f, 1.011875f, 0.353330f, 1.401274f, 0.392232f, 2.033165f, 1.044030f, 2.010719f,
0.061114f, 0.239932f, 0.028515f, 0.240784f, 0.183023f, 1.284797f, 0.554257f, 1.073035f, 0.121987f, 0.692647f, 0.219446f, 0.708492f, 0.225836f, 1.387305f, 0.646361f, 1.013392f,
0.266322f, 0.676996f, 0.074328f, 0.932615f, 0.527233f, 2.396440f, 0.955059f, 2.747406f, 0.512340f, 1.883608f, 0.551307f, 2.644788f, 0.699294f, 2.781457f, 1.197189f, 2.789042f,
0.296466f, 0.466528f, 0.084684f, 0.708846f, 0.416528f, 1.172013f, 0.772240f, 1.481993f, 0.083117f, 0.189168f, 0.091539f, 0.292958f, 0.769569f, 1.894890f, 1.348439f, 2.095677f,
0.376679f, 0.853425f, 0.153057f, 1.433010f, 0.464602f, 1.882175f, 1.225305f, 2.630170f, 0.309498f, 1.014156f, 0.484874f, 1.735692f, 0.919631f, 3.260177f, 2.292199f, 3.984662f,
0.245153f, 0.658233f, 0.107110f, 0.816376f, 0.461102f, 2.213731f, 1.307591f, 2.284944f, 0.245634f, 0.953860f, 0.413782f, 1.205812f, 0.727544f, 3.056577f, 1.949885f, 2.759386f,
0.713696f, 1.240766f, 0.186522f, 2.112409f, 0.887377f, 2.758478f, 1.505234f, 3.908387f, 0.689202f, 1.732910f, 0.694464f, 3.007101f, 1.505006f, 4.094003f, 2.412734f, 5.073442f,
0.240658f, 0.397863f, 0.063952f, 0.589817f, 0.381752f, 1.128498f, 0.658440f, 1.392272f, 0.063728f, 0.152377f, 0.065294f, 0.230243f, 0.428692f, 1.108953f, 0.698804f, 1.196638f,
0.326071f, 0.776135f, 0.123260f, 1.271542f, 0.454082f, 1.932611f, 1.114099f, 2.634983f, 0.253054f, 0.871148f, 0.368817f, 1.454686f, 0.546295f, 2.034633f, 1.266754f, 2.426308f,
0.063915f, 0.180293f, 0.025979f, 0.218173f, 0.135731f, 0.684602f, 0.358080f, 0.689443f, 0.060489f, 0.246775f, 0.094794f, 0.304372f, 0.130167f, 0.574525f, 0.324547f, 0.506053f,
0.494698f, 0.903542f, 0.120277f, 1.500880f, 0.694461f, 2.267986f, 1.095898f, 3.135292f, 0.451221f, 1.191927f, 0.422979f, 2.018047f, 0.715877f, 2.045878f, 1.067668f, 2.473681f,
0.263865f, 0.531493f, 0.065308f, 0.669011f, 0.406030f, 1.462374f, 0.652266f, 1.531914f, 0.093368f, 0.271998f, 0.089099f, 0.348968f, 0.585828f, 1.846371f, 0.889431f, 1.691693f,
0.502474f, 1.457203f, 0.176911f, 2.027058f, 0.678782f, 3.519828f, 1.551143f, 4.074811f, 0.521072f, 2.185532f, 0.707338f, 3.098755f, 1.049232f, 4.761147f, 2.266047f, 4.820856f,
0.217075f, 0.746046f, 0.082179f, 0.766547f, 0.447175f, 2.748007f, 1.098781f, 2.349800f, 0.274512f, 1.364485f, 0.400683f, 1.428978f, 0.550996f, 2.963038f, 1.279550f, 2.216035f,
0.695398f, 1.547470f, 0.157473f, 2.182592f, 0.946967f, 3.767980f, 1.391840f, 4.422816f, 0.847548f, 2.727759f, 0.739990f, 3.921392f, 1.254221f, 4.367132f, 1.742223f, 4.483457f,
0.196058f, 0.394238f, 0.051635f, 0.484897f, 0.466981f, 1.679023f, 0.798254f, 1.718651f, 0.095113f, 0.276608f, 0.096580f, 0.346769f, 0.561700f, 1.767303f, 0.907450f, 1.582226f,
0.346261f, 1.002461f, 0.129724f, 1.362601f, 0.724032f, 3.748058f, 1.760577f, 4.239820f, 0.492296f, 2.061312f, 0.711102f, 2.855807f, 0.933024f, 4.226590f, 2.144202f, 4.181747f,
0.137302f, 0.471076f, 0.055310f, 0.472954f, 0.437808f, 2.685844f, 1.144701f, 2.244134f, 0.238050f, 1.181227f, 0.369730f, 1.208775f, 0.449726f, 2.414314f, 1.111302f, 1.764364f,
0.647938f, 1.439394f, 0.156129f, 1.983741f, 1.365754f, 5.425046f, 2.136005f, 6.222269f, 1.082688f, 3.478584f, 1.005868f, 4.886432f, 1.508013f, 5.241852f, 2.229002f, 5.258436f,
0.495123f, 0.680900f, 0.122108f, 1.035013f, 0.740671f, 1.821296f, 1.185594f, 2.304004f, 0.120572f, 0.239812f, 0.114648f, 0.371551f, 1.139211f, 2.451365f, 1.723417f, 2.712297f,
0.679258f, 1.344919f, 0.238298f, 2.259276f, 0.892047f, 3.158159f, 2.031204f, 4.415164f, 0.484774f, 1.388206f, 0.655712f, 2.376899f, 1.469927f, 4.553977f, 3.163277f, 5.568397f,
0.370088f, 0.868390f, 0.139605f, 1.077493f, 0.741154f, 3.109590f, 1.814619f, 3.211020f, 0.322088f, 1.093045f, 0.468446f, 1.382363f, 0.973522f, 3.574285f, 2.252673f, 3.228163f,
1.166735f, 1.772621f, 0.263263f, 3.019208f, 1.544579f, 4.196029f, 2.262081f, 5.947790f, 0.978641f, 2.150404f, 0.851391f, 3.733199f, 2.180799f, 5.184333f, 3.018487f, 6.427416f,
0.071176f, 0.093269f, 0.021716f, 0.175859f, 0.080048f, 0.187560f, 0.158516f, 0.294310f, 0.015816f, 0.029975f, 0.018605f, 0.057606f, 0.105376f, 0.216063f, 0.197215f, 0.296532f,
0.099120f, 0.187009f, 0.043019f, 0.389670f, 0.097863f, 0.330144f, 0.275676f, 0.572503f, 0.064550f, 0.176137f, 0.108016f, 0.374084f, 0.138020f, 0.407449f, 0.367448f, 0.617980f,
0.024064f, 0.053803f, 0.011230f, 0.082808f, 0.036230f, 0.144844f, 0.109739f, 0.185525f, 0.019110f, 0.061796f, 0.034384f, 0.096941f, 0.040730f, 0.142495f, 0.116597f, 0.159635f,
0.141717f, 0.205166f, 0.039560f, 0.433455f, 0.141047f, 0.365116f, 0.255551f, 0.641962f, 0.108469f, 0.227112f, 0.116741f, 0.489060f, 0.170445f, 0.386099f, 0.291858f, 0.593750f,
0.073057f, 0.116640f, 0.020760f, 0.186735f, 0.079702f, 0.227533f, 0.147003f, 0.303152f, 0.021692f, 0.050090f, 0.023767f, 0.081736f, 0.134807f, 0.336770f, 0.234987f, 0.392443f,
0.142992f, 0.328693f, 0.057802f, 0.581538f, 0.136950f, 0.562893f, 0.359313f, 0.828807f, 0.124431f, 0.413677f, 0.193932f, 0.745990f, 0.248160f, 0.892575f, 0.615345f, 1.149473f,
0.076509f, 0.208421f, 0.033255f, 0.272367f, 0.111741f, 0.544286f, 0.315237f, 0.591945f, 0.081189f, 0.319873f, 0.136059f, 0.426065f, 0.161404f, 0.687978f, 0.430340f, 0.654418f,
0.186493f, 0.328946f, 0.048487f, 0.590087f, 0.180052f, 0.567864f, 0.303838f, 0.847766f, 0.190733f, 0.486566f, 0.191196f, 0.889646f, 0.279554f, 0.771544f, 0.445846f, 1.007440f,
0.023719f, 0.037804f, 0.007172f, 0.059138f, 0.040053f, 0.114148f, 0.078609f, 0.148608f, 0.009656f, 0.022258f, 0.011257f, 0.035489f, 0.056477f, 0.140848f, 0.104756f, 0.160380f,
0.043055f, 0.098802f, 0.018520f, 0.170808f, 0.063829f, 0.261901f, 0.178198f, 0.376808f, 0.051367f, 0.170481f, 0.085188f, 0.300401f, 0.096423f, 0.346218f, 0.254415f, 0.435671f,
0.021145f, 0.057503f, 0.009780f, 0.073428f, 0.047802f, 0.232443f, 0.143498f, 0.247016f, 0.030763f, 0.120995f, 0.054858f, 0.157479f, 0.057562f, 0.244939f, 0.163310f, 0.227664f,
0.075926f, 0.133693f, 0.021005f, 0.234345f, 0.113465f, 0.357245f, 0.203742f, 0.521138f, 0.106462f, 0.271122f, 0.113559f, 0.484391f, 0.146867f, 0.404647f, 0.249240f, 0.516285f,
0.106184f, 0.115745f, 0.030066f, 0.223773f, 0.112618f, 0.219500f, 0.206970f, 0.353166f, 0.021698f, 0.034208f, 0.023688f, 0.067408f, 0.203055f, 0.346330f, 0.352687f, 0.487373f,
0.149727f, 0.234983f, 0.060308f, 0.502054f, 0.139408f, 0.391208f, 0.364455f, 0.695603f, 0.089668f, 0.203529f, 0.139252f, 0.443226f, 0.269293f, 0.661291f, 0.665359f, 1.028427f,
0.101036f, 0.187914f, 0.043758f, 0.296551f, 0.143454f, 0.477068f, 0.403255f, 0.626559f, 0.073787f, 0.198479f, 0.123212f, 0.319257f, 0.220891f, 0.642829f, 0.586842f, 0.738419f,
0.242365f, 0.291868f, 0.062788f, 0.632274f, 0.227479f, 0.489827f, 0.382498f, 0.883083f, 0.170590f, 0.297115f, 0.170392f, 0.656035f, 0.376509f, 0.709457f, 0.598328f, 1.118693f,
0.082246f, 0.150100f, 0.026533f, 0.215423f, 0.105051f, 0.342807f, 0.219960f, 0.409450f, 0.019818f, 0.052310f, 0.024650f, 0.076521f, 0.152601f, 0.435767f, 0.301979f, 0.455232f,
0.124510f, 0.327158f, 0.057137f, 0.518895f, 0.139614f, 0.655945f, 0.415840f, 0.865822f, 0.087928f, 0.334143f, 0.155572f, 0.540180f, 0.217277f, 0.893310f, 0.611628f, 1.031312f,
0.030321f, 0.094416f, 0.014961f, 0.110609f, 0.051846f, 0.288671f, 0.166045f, 0.281444f, 0.026111f, 0.117594f, 0.049676f, 0.140416f, 0.064318f, 0.313377f, 0.194678f, 0.267228f,
0.171948f, 0.346684f, 0.050751f, 0.557518f, 0.194360f, 0.700693f, 0.372337f, 0.937764f, 0.142714f, 0.416155f, 0.162407f, 0.682126f, 0.259173f, 0.817636f, 0.469241f, 0.957089f,
0.080679f, 0.179392f, 0.024241f, 0.218608f, 0.099963f, 0.397435f, 0.194945f, 0.403060f, 0.025977f, 0.083539f, 0.030094f, 0.103762f, 0.186570f, 0.649113f, 0.343869f, 0.575772f,
0.171658f, 0.549541f, 0.073369f, 0.740072f, 0.186717f, 1.068817f, 0.517980f, 1.197892f, 0.161983f, 0.749993f, 0.266935f, 1.029474f, 0.373352f, 1.870195f, 0.978866f, 1.833274f,
0.092131f, 0.349533f, 0.042341f, 0.347688f, 0.152818f, 1.036675f, 0.455843f, 0.858191f, 0.106017f, 0.581717f, 0.187855f, 0.589789f, 0.243578f, 1.445957f, 0.686680f, 1.046942f,
0.216247f, 0.531211f, 0.059447f, 0.725345f, 0.237112f, 1.041490f, 0.423073f, 1.183514f, 0.239828f, 0.852061f, 0.254197f, 1.185859f, 0.406242f, 1.561479f, 0.685051f, 1.551961f,
0.054771f, 0.121576f, 0.017511f, 0.144767f, 0.105042f, 0.416917f, 0.217979f, 0.413151f, 0.024178f, 0.077620f, 0.029804f, 0.094206f, 0.163442f, 0.567672f, 0.320544f, 0.492020f,
0.108079f, 0.345408f, 0.049155f, 0.454529f, 0.181969f, 1.039858f, 0.537158f, 1.138789f, 0.139825f, 0.646293f, 0.245187f, 0.866847f, 0.303337f, 1.516879f, 0.846264f, 1.452937f,
0.053242f, 0.201651f, 0.026037f, 0.196000f, 0.136699f, 0.925745f, 0.433892f, 0.748837f, 0.083998f, 0.460110f, 0.158377f, 0.455829f, 0.181645f, 1.076459f, 0.544898f, 0.761588f,
0.184092f, 0.451450f, 0.053851f, 0.602342f, 0.312447f, 1.370047f, 0.593217f, 1.521279f, 0.279914f, 0.992779f, 0.315697f, 1.350113f, 0.446274f, 1.712419f, 0.800783f, 1.663068f,
0.126601f, 0.192192f, 0.037903f, 0.282830f, 0.152493f, 0.413938f, 0.296326f, 0.506951f, 0.028054f, 0.061595f, 0.032383f, 0.092389f, 0.303405f, 0.720702f, 0.557208f, 0.771992f,
0.194058f, 0.424153f, 0.082647f, 0.689801f, 0.205205f, 0.801978f, 0.567233f, 1.085434f, 0.126025f, 0.398383f, 0.206937f, 0.660367f, 0.437410f, 1.495935f, 1.142716f, 1.770843f,
0.131355f, 0.340239f, 0.060152f, 0.408707f, 0.211812f, 0.981013f, 0.629559f, 0.980714f, 0.104025f, 0.389698f, 0.183666f, 0.477133f, 0.359900f, 1.458660f, 1.010979f, 1.275406f,
0.303413f, 0.508870f, 0.083111f, 0.839097f, 0.323426f, 0.969911f, 0.575017f, 1.330996f, 0.231583f, 0.561735f, 0.244579f, 0.944105f, 0.590709f, 1.550170f, 0.992556f, 1.860591f,
0.049383f, 0.093420f, 0.015199f, 0.138431f, 0.068170f, 0.230594f, 0.136185f, 0.284369f, 0.014074f, 0.038507f, 0.016702f, 0.058160f, 0.098539f, 0.291682f, 0.186044f, 0.314608f,
0.063641f, 0.173338f, 0.027864f, 0.283856f, 0.077126f, 0.375614f, 0.219172f, 0.511901f, 0.053157f, 0.209396f, 0.089733f, 0.349507f, 0.119438f, 0.509018f, 0.320778f, 0.606742f,
0.017417f, 0.056218f, 0.008199f, 0.067999f, 0.032187f, 0.185768f, 0.098351f, 0.187000f, 0.017740f, 0.082816f, 0.032200f, 0.102100f, 0.039733f, 0.200674f, 0.114743f, 0.176681f,
0.094305f, 0.197094f, 0.026557f, 0.327252f, 0.115208f, 0.430532f, 0.210572f, 0.594914f, 0.092576f, 0.279830f, 0.100514f, 0.473572f, 0.152869f, 0.499913f, 0.264068f, 0.604185f,
0.042800f, 0.098649f, 0.012270f, 0.124120f, 0.057314f, 0.236209f, 0.106642f, 0.247333f, 0.016300f, 0.054335f, 0.018016f, 0.069681f, 0.106445f, 0.383889f, 0.187182f, 0.351576f,
0.077523f, 0.257257f, 0.031613f, 0.357704f, 0.091135f, 0.540766f, 0.241215f, 0.625758f, 0.086523f, 0.415263f, 0.136037f, 0.588524f, 0.181333f, 0.941562f, 0.453598f, 0.952955f,
0.046758f, 0.183886f, 0.020503f, 0.188857f, 0.083824f, 0.589442f, 0.238561f, 0.503808f, 0.063640f, 0.361968f, 0.107589f, 0.378912f, 0.132950f, 0.818107f, 0.357598f, 0.611590f,
0.104789f, 0.266832f, 0.027484f, 0.376183f, 0.124182f, 0.565411f, 0.211402f, 0.663385f, 0.137457f, 0.506221f, 0.139003f, 0.727421f, 0.211713f, 0.843532f, 0.340623f, 0.865624f,
0.028620f, 0.065853f, 0.008730f, 0.080961f, 0.059323f, 0.244070f, 0.117453f, 0.249722f, 0.014943f, 0.049728f, 0.017575f, 0.062314f, 0.091850f, 0.330688f, 0.171868f, 0.295928f,
0.048077f, 0.159270f, 0.020862f, 0.216395f, 0.087485f, 0.518220f, 0.246393f, 0.585958f, 0.073567f, 0.352477f, 0.123079f, 0.488120f, 0.145117f, 0.752225f, 0.386267f, 0.743920f,
0.026616f, 0.104495f, 0.012419f, 0.104866f, 0.073857f, 0.518471f, 0.223666f, 0.433015f, 0.049666f, 0.282004f, 0.089345f, 0.288455f, 0.097658f, 0.599911f, 0.279505f, 0.438220f,
0.087869f, 0.223365f, 0.024524f, 0.307703f, 0.161182f, 0.732621f, 0.291973f, 0.839916f, 0.158025f, 0.580974f, 0.170044f, 0.815751f, 0.229086f, 0.911193f, 0.392194f, 0.913678f,
0.084303f, 0.132662f, 0.024081f, 0.201568f, 0.109748f, 0.308806f, 0.203473f, 0.390480f, 0.022095f, 0.050287f, 0.024334f, 0.077878f, 0.217283f, 0.535011f, 0.380723f, 0.591701f,
0.110006f, 0.249236f, 0.044699f, 0.418499f, 0.125722f, 0.509318f, 0.331569f, 0.711726f, 0.084497f, 0.276877f, 0.132377f, 0.473866f, 0.266666f, 0.945356f, 0.664671f, 1.155436f,
0.083680f, 0.224680f, 0.036561f, 0.278660f, 0.145837f, 0.700154f, 0.413562f, 0.722677f, 0.078381f, 0.304374f, 0.132036f, 0.384771f, 0.246577f, 1.035927f, 0.660850f, 0.935204f,
0.184553f, 0.320847f, 0.048232f, 0.546244f, 0.212618f, 0.660940f, 0.360658f, 0.936461f, 0.166607f, 0.418911f, 0.167879f, 0.726932f, 0.386416f, 1.051152f, 0.619479f, 1.302627f,
0.082191f, 0.135880f, 0.021841f, 0.201437f, 0.120806f, 0.357114f, 0.208364f, 0.440586f, 0.020347f, 0.048650f, 0.020847f, 0.073510f, 0.145371f, 0.376049f, 0.236966f, 0.405783f,
0.114369f, 0.272230f, 0.043233f, 0.445994f, 0.147576f, 0.628097f, 0.362081f, 0.856367f, 0.082975f, 0.285646f, 0.120933f, 0.476986f, 0.190254f, 0.708587f, 0.441164f, 0.844993f,
0.026203f, 0.073913f, 0.010650f, 0.089441f, 0.051559f, 0.260052f, 0.136020f, 0.261891f, 0.023182f, 0.094575f, 0.036329f, 0.116649f, 0.052984f, 0.233860f, 0.132107f, 0.205988f,
0.153639f, 0.280614f, 0.037355f, 0.466130f, 0.199845f, 0.652658f, 0.315366f, 0.902242f, 0.131005f, 0.346058f, 0.122805f, 0.585909f, 0.220754f, 0.630885f, 0.329235f, 0.762806f,
0.091054f, 0.183407f, 0.022537f, 0.230862f, 0.129826f, 0.467585f, 0.208558f, 0.489820f, 0.030120f, 0.087745f, 0.028743f, 0.112575f, 0.200723f, 0.632626f, 0.304747f, 0.579628f,
0.178077f, 0.516434f, 0.062697f, 0.718391f, 0.222899f, 1.155846f, 0.509367f, 1.338092f, 0.172635f, 0.724085f, 0.234347f, 1.026643f, 0.369212f, 1.675388f, 0.797393f, 1.696398f,
0.089918f, 0.309030f, 0.034041f, 0.317522f, 0.171631f, 1.054718f, 0.421725f, 0.901881f, 0.106300f, 0.528373f, 0.155158f, 0.553347f, 0.226617f, 1.218655f, 0.526260f, 0.911423f,
0.218218f, 0.485602f, 0.049416f, 0.684905f, 0.275345f, 1.095596f, 0.404698f, 1.285999f, 0.248633f, 0.800205f, 0.217081f, 1.150365f, 0.390788f, 1.360702f, 0.542838f, 1.396947f,
0.073640f, 0.148078f, 0.019394f, 0.182129f, 0.162523f, 0.584348f, 0.277815f, 0.598140f, 0.033397f, 0.097126f, 0.033912f, 0.121761f, 0.209481f, 0.659099f, 0.338425f, 0.590077f,
0.133571f, 0.386700f, 0.050041f, 0.525625f, 0.258791f, 1.339668f, 0.629283f, 1.515439f, 0.177530f, 0.743341f, 0.256435f, 1.029849f, 0.357362f, 1.618849f, 0.821262f, 1.601673f,
0.061905f, 0.212392f, 0.024938f, 0.213239f, 0.182900f, 1.122048f, 0.478215f, 0.937518f, 0.100335f, 0.497872f, 0.155836f, 0.509483f, 0.201328f, 1.080811f, 0.497494f, 0.789849f,
0.221311f, 0.491643f, 0.053328f, 0.677572f, 0.432242f, 1.716949f, 0.676015f, 1.969259f, 0.345709f, 1.110734f, 0.321180f, 1.560269f, 0.511428f, 1.777723f, 0.755944f, 1.783347f,
0.145755f, 0.200444f, 0.035946f, 0.304689f, 0.202032f, 0.496792f, 0.323393f, 0.628460f, 0.033182f, 0.065996f, 0.031551f, 0.102251f, 0.332984f, 0.716518f, 0.503744f, 0.792787f,
0.205363f, 0.406614f, 0.072046f, 0.683055f, 0.249895f, 0.884717f, 0.569015f, 1.236851f, 0.137014f, 0.392354f, 0.185326f, 0.671792f, 0.441257f, 1.367056f, 0.949582f, 1.671574f,
0.130777f, 0.306860f, 0.049332f, 0.380751f, 0.242671f, 1.018154f, 0.594149f, 1.051364f, 0.106399f, 0.361079f, 0.154748f, 0.456652f, 0.341571f, 1.254078f, 0.790376f, 1.132637f,
0.312336f, 0.474532f, 0.070476f, 0.808244f, 0.383128f, 1.040811f, 0.561102f, 1.475330f, 0.244912f, 0.538155f, 0.213067f, 0.934261f, 0.579661f, 1.378007f, 0.802321f, 1.708422f,
0.232215f, 0.304297f, 0.070849f, 0.573750f, 0.280382f, 0.656966f, 0.555233f, 1.030879f, 0.047375f, 0.089786f, 0.055729f, 0.172552f, 0.306063f, 0.627554f, 0.572810f, 0.861276f,
0.364753f, 0.688174f, 0.158306f, 1.433946f, 0.386634f, 1.304318f, 1.089130f, 2.261821f, 0.218086f, 0.595086f, 0.364935f, 1.263859f, 0.452157f, 1.334816f, 1.203772f, 2.024522f,
0.079495f, 0.177742f, 0.037098f, 0.273559f, 0.128497f, 0.513719f, 0.389211f, 0.658003f, 0.057961f, 0.187429f, 0.104288f, 0.294024f, 0.119788f, 0.419076f, 0.342909f, 0.469484f,
0.515465f, 0.746243f, 0.143890f, 1.576591f, 0.550788f, 1.425774f, 0.997923f, 2.506857f, 0.362222f, 0.758418f, 0.389847f, 1.633171f, 0.551914f, 1.250218f, 0.945059f, 1.922610f,
0.186872f, 0.298355f, 0.053103f, 0.477652f, 0.218877f, 0.624846f, 0.403698f, 0.832512f, 0.050943f, 0.117633f, 0.055815f, 0.191951f, 0.306978f, 0.766885f, 0.535106f, 0.893663f,
0.412547f, 0.948317f, 0.166765f, 1.677803f, 0.424198f, 1.743546f, 1.112962f, 2.567206f, 0.329598f, 1.095766f, 0.513694f, 1.976010f, 0.637391f, 2.292554f, 1.580496f, 2.952388f,
0.198162f, 0.539819f, 0.086132f, 0.705444f, 0.310717f, 1.513487f, 0.876574f, 1.646012f, 0.193062f, 0.760638f, 0.323540f, 1.013156f, 0.372162f, 1.586332f, 0.992272f, 1.508950f,
0.531820f, 0.938052f, 0.138270f, 1.682746f, 0.551245f, 1.738567f, 0.930227f, 2.595513f, 0.499370f, 1.273907f, 0.500581f, 2.329235f, 0.709708f, 1.958733f, 1.131877f, 2.557604f,
0.040615f, 0.064734f, 0.012281f, 0.101267f, 0.073634f, 0.209851f, 0.144515f, 0.273202f, 0.015180f, 0.034992f, 0.017697f, 0.055794f, 0.086096f, 0.214715f, 0.159695f, 0.244490f,
0.083158f, 0.190828f, 0.035769f, 0.329901f, 0.132354f, 0.543073f, 0.369508f, 0.781342f, 0.091087f, 0.302304f, 0.151060f, 0.532686f, 0.165794f, 0.595303f, 0.437452f, 0.749113f,
0.036663f, 0.099704f, 0.016957f, 0.127316f, 0.088984f, 0.432695f, 0.267122f, 0.459824f, 0.048972f, 0.192612f, 0.087327f, 0.250690f, 0.088853f, 0.378086f, 0.252084f, 0.351420f,
0.144946f, 0.255226f, 0.040100f, 0.447375f, 0.232553f, 0.732195f, 0.417582f, 1.068103f, 0.186596f, 0.475198f, 0.199035f, 0.848995f, 0.249604f, 0.687708f, 0.423591f, 0.877439f,
0.339413f, 0.369974f, 0.096106f, 0.715280f, 0.386473f, 0.753265f, 0.710264f, 1.211969f, 0.063678f, 0.100389f, 0.069518f, 0.197822f, 0.577822f, 0.985533f, 1.003622f, 1.386889f,
0.539818f, 0.847192f, 0.217432f, 1.810073f, 0.539608f, 1.514251f, 1.410698f, 2.692478f, 0.296810f, 0.673700f, 0.460938f, 1.467117f, 0.864336f, 2.122515f, 2.135570f, 3.300893f,
0.327014f, 0.608204f, 0.141629f, 0.959821f, 0.498480f, 1.657738f, 1.401248f, 2.177194f, 0.219262f, 0.589793f, 0.366132f, 0.948691f, 0.636475f, 1.852244f, 1.690923f, 2.127677f,
0.863685f, 1.040094f, 0.223750f, 2.253154f, 0.870305f, 1.874017f, 1.463389f, 3.378562f, 0.558128f, 0.972084f, 0.557480f, 2.146378f, 1.194465f, 2.250733f, 1.898178f, 3.549023f,
0.217452f, 0.396849f, 0.070150f, 0.569557f, 0.298189f, 0.973059f, 0.624358f, 1.162226f, 0.048107f, 0.126977f, 0.059836f, 0.185746f, 0.359183f, 1.025681f, 0.710777f, 1.071495f,
0.371301f, 0.975620f, 0.170390f, 1.547399f, 0.446988f, 2.100075f, 1.331354f, 2.772019f, 0.240736f, 0.914849f, 0.425939f, 1.478954f, 0.576832f, 2.371577f, 1.623763f, 2.737947f,
0.081172f, 0.252762f, 0.040053f, 0.296114f, 0.149014f, 0.829690f, 0.477240f, 0.808917f, 0.064179f, 0.289032f, 0.122097f, 0.345126f, 0.153289f, 0.746874f, 0.463976f, 0.636887f,
0.506827f, 1.021872f, 0.149592f, 1.643319f, 0.615055f, 2.217354f, 1.178267f, 2.967568f, 0.386209f, 1.126189f, 0.439501f, 1.845955f, 0.680088f, 2.145532f, 1.231319f, 2.511465f,
0.167236f, 0.371856f, 0.050249f, 0.453147f, 0.222461f, 0.884469f, 0.433839f, 0.896988f, 0.049438f, 0.158985f, 0.057272f, 0.197471f, 0.344292f, 1.197855f, 0.634566f, 1.062514f,
0.401342f, 1.284841f, 0.171539f, 1.730309f, 0.468681f, 2.682858f, 1.300191f, 3.006850f, 0.347706f, 1.609905f, 0.572993f, 2.209828f, 0.777105f, 3.892679f, 2.037441f, 3.815831f,
0.193374f, 0.733640f, 0.088871f, 0.729766f, 0.344360f, 2.336048f, 1.027198f, 1.933850f, 0.204297f, 1.120984f, 0.362002f, 1.136539f, 0.455139f, 2.701854f, 1.283101f, 1.956272f,
0.499734f, 1.227598f, 0.137379f, 1.676233f, 0.588284f, 2.583980f, 1.049661f, 2.936348f, 0.508842f, 1.807813f, 0.539328f, 2.516030f, 0.835770f, 3.212459f, 1.409367f, 3.192878f,
0.076003f, 0.168708f, 0.024300f, 0.200888f, 0.156493f, 0.621127f, 0.324746f, 0.615516f, 0.030804f, 0.098891f, 0.037972f, 0.120021f, 0.201911f, 0.701286f, 0.395992f, 0.607828f,
0.169162f, 0.540625f, 0.076936f, 0.711419f, 0.305777f, 1.747358f, 0.902630f, 1.913599f, 0.200928f, 0.928723f, 0.352333f, 1.245660f, 0.422669f, 2.113617f, 1.179183f, 2.024520f,
0.074811f, 0.283340f, 0.036585f, 0.275400f, 0.206214f, 1.396509f, 0.654537f, 1.129640f, 0.108360f, 0.593558f, 0.204312f, 0.588035f, 0.227218f, 1.346535f, 0.681608f, 0.952665f,
0.284799f, 0.698414f, 0.083310f, 0.931850f, 0.518948f, 2.275533f, 0.985284f, 2.526717f, 0.397577f, 1.410098f, 0.448401f, 1.917638f, 0.614634f, 2.358442f, 1.102885f, 2.290473f,
0.327938f, 0.497841f, 0.098182f, 0.732625f, 0.424083f, 1.151158f, 0.824081f, 1.409827f, 0.066718f, 0.146485f, 0.077014f, 0.219719f, 0.699666f, 1.661970f, 1.284945f, 1.780248f,
0.566978f, 1.239242f, 0.241468f, 2.015380f, 0.643673f, 2.515593f, 1.779259f, 3.404719f, 0.338052f, 1.068630f, 0.555093f, 1.771382f, 1.137717f, 3.890971f, 2.972237f, 4.606015f,
0.344527f, 0.892405f, 0.157771f, 1.071988f, 0.596449f, 2.762468f, 1.772795f, 2.761627f, 0.250500f, 0.938424f, 0.442283f, 1.148976f, 0.840372f, 3.405995f, 2.360653f, 2.978093f,
0.876208f, 1.469535f, 0.240012f, 2.423176f, 1.002748f, 3.007109f, 1.782781f, 4.126619f, 0.614006f, 1.489353f, 0.648464f, 2.503150f, 1.518653f, 3.985330f, 2.551761f, 4.783391f,
0.200458f, 0.379219f, 0.061699f, 0.561933f, 0.297092f, 1.004945f, 0.593502f, 1.239300f, 0.052453f, 0.143512f, 0.062246f, 0.216754f, 0.356099f, 1.054075f, 0.672324f, 1.136926f,
0.291382f, 0.793636f, 0.127576f, 1.299648f, 0.379115f, 1.846349f, 1.077353f, 2.516275f, 0.223448f, 0.880215f, 0.377201f, 1.469188f, 0.486834f, 2.074782f, 1.307505f, 2.473109f,
0.071588f, 0.231071f, 0.033702f, 0.279496f, 0.142035f, 0.819762f, 0.434005f, 0.825199f, 0.066945f, 0.312520f, 0.121513f, 0.385295f, 0.145390f, 0.734303f, 0.419864f, 0.646507f,
0.426776f, 0.891950f, 0.120182f, 1.480979f, 0.559748f, 2.091788f, 1.023086f, 2.890455f, 0.384646f, 1.162665f, 0.417627f, 1.967646f, 0.615885f, 2.014067f, 1.063886f, 2.434158f,
0.136214f, 0.313957f, 0.039049f, 0.395019f, 0.195832f, 0.807081f, 0.364375f, 0.845092f, 0.047627f, 0.158764f, 0.052641f, 0.203602f, 0.301587f, 1.087664f, 0.530338f, 0.996112f,
0.278280f, 0.923467f, 0.113480f, 1.284040f, 0.351224f, 2.084049f, 0.929615f, 2.411598f, 0.285154f, 1.368583f, 0.448338f, 1.939600f, 0.579485f, 3.008950f, 1.449563f, 3.045359f,
0.150681f, 0.592580f, 0.066071f, 0.608599f, 0.290009f, 2.039316f, 0.825358f, 1.743045f, 0.188288f, 1.070934f, 0.318317f, 1.121065f, 0.381416f, 2.347042f, 1.025901f, 1.754572f,
0.371800f, 0.946742f, 0.097517f, 1.334728f, 0.473039f, 2.153788f, 0.805283f, 2.526994f, 0.447768f, 1.649027f, 0.452807f, 2.369589f, 0.668733f, 2.664450f, 1.075919f, 2.734231f,
0.060976f, 0.140302f, 0.018600f, 0.172491f, 0.135693f, 0.558276f, 0.268657f, 0.571204f, 0.029230f, 0.097271f, 0.034377f, 0.121891f, 0.174213f, 0.627221f, 0.325984f, 0.561292f,
0.115533f, 0.382739f, 0.050133f, 0.520014f, 0.225707f, 1.336985f, 0.635682f, 1.511746f, 0.162309f, 0.777663f, 0.271547f, 1.076930f, 0.310454f, 1.609264f, 0.826357f, 1.591498f,
0.057420f, 0.225427f, 0.026791f, 0.226227f, 0.171061f, 1.200829f, 0.518033f, 1.002906f, 0.098370f, 0.558549f, 0.176961f, 0.571326f, 0.187557f, 1.152156f, 0.536802f, 0.841621f,
0.208710f, 0.530546f, 0.058249f, 0.730868f, 0.411025f, 1.868235f, 0.744552f, 2.141844f, 0.344609f, 1.266946f, 0.370818f, 1.778928f, 0.484415f, 1.926770f, 0.829316f, 1.932024f,
0.335278f, 0.527603f, 0.095771f, 0.801643f, 0.468600f, 1.318530f, 0.868781f, 1.667261f, 0.080677f, 0.183615f, 0.088852f, 0.284358f, 0.769304f, 1.894237f, 1.347973f, 2.094954f,
0.493463f, 1.118017f, 0.200511f, 1.877294f, 0.605469f, 2.452851f, 1.596819f, 3.427639f, 0.347994f, 1.140299f, 0.545183f, 1.951580f, 1.064921f, 3.775244f, 2.654338f, 4.614189f,
0.336980f, 0.904788f, 0.147231f, 1.122168f, 0.630512f, 3.027057f, 1.788000f, 3.124434f, 0.289793f, 1.125338f, 0.488168f, 1.422584f, 0.883990f, 3.713844f, 2.369176f, 3.352747f,
0.818275f, 1.422577f, 0.213853f, 2.421943f, 1.012098f, 3.146181f, 1.716794f, 4.457709f, 0.678208f, 1.705268f, 0.683387f, 2.959134f, 1.525264f, 4.149110f, 2.445210f, 5.141732f,
0.237338f, 0.392375f, 0.063070f, 0.581681f, 0.374522f, 1.107124f, 0.645969f, 1.365902f, 0.053942f, 0.128979f, 0.055268f, 0.194888f, 0.373709f, 0.966721f, 0.609177f, 1.043160f,
0.372505f, 0.886662f, 0.140813f, 1.452619f, 0.516040f, 2.196310f, 1.266115f, 2.994519f, 0.248122f, 0.854169f, 0.361629f, 1.426334f, 0.551657f, 2.054603f, 1.279188f, 2.450122f,
0.076615f, 0.216115f, 0.031141f, 0.261520f, 0.161850f, 0.816341f, 0.426986f, 0.822114f, 0.062231f, 0.253885f, 0.097526f, 0.313142f, 0.137920f, 0.608745f, 0.343878f, 0.536194f,
0.494612f, 0.903384f, 0.120256f, 1.500617f, 0.690717f, 2.255759f, 1.089989f, 3.118388f, 0.387207f, 1.022832f, 0.362972f, 1.731753f, 0.632679f, 1.808108f, 0.943585f, 2.186193f,
0.206145f, 0.415229f, 0.051022f, 0.522665f, 0.315556f, 1.136520f, 0.506925f, 1.190565f, 0.062606f, 0.182384f, 0.059744f, 0.233995f, 0.404559f, 1.275059f, 0.614220f, 1.168242f,
0.454734f, 1.318755f, 0.160103f, 1.834468f, 0.611086f, 3.168793f, 1.396447f, 3.668427f, 0.404737f, 1.697587f, 0.549417f, 2.406923f, 0.839337f, 3.808699f, 1.812733f, 3.856463f,
0.206129f, 0.708426f, 0.078035f, 0.727893f, 0.422411f, 2.595821f, 1.037930f, 2.219667f, 0.223728f, 1.112060f, 0.326558f, 1.164622f, 0.462485f, 2.487063f, 1.074006f, 1.860057f,
0.550783f, 1.225658f, 0.124725f, 1.728700f, 0.746123f, 2.968821f, 1.096641f, 3.484771f, 0.576159f, 1.854316f, 0.503042f, 2.665742f, 0.878096f, 3.057484f, 1.219752f, 3.138925f,
0.111610f, 0.224427f, 0.029394f, 0.276036f, 0.264450f, 0.950827f, 0.452050f, 0.973268f, 0.046471f, 0.135149f, 0.047189f, 0.169429f, 0.282645f, 0.889300f, 0.456625f, 0.796170f,
0.228336f, 0.661055f, 0.085544f, 0.898543f, 0.474959f, 2.458696f, 1.154924f, 2.781288f, 0.278630f, 1.166661f, 0.402470f, 1.616330f, 0.543856f, 2.463662f, 1.249847f, 2.437524f,
0.095002f, 0.325946f, 0.038270f, 0.327246f, 0.301347f, 1.848688f, 0.787907f, 1.544656f, 0.141369f, 0.701486f, 0.219568f, 0.717845f, 0.275057f, 1.476622f, 0.679685f, 1.079105f,
0.373944f, 0.830716f, 0.090107f, 1.144875f, 0.784104f, 3.114618f, 1.226320f, 3.572318f, 0.536299f, 1.723084f, 0.498247f, 2.420448f, 0.769306f, 2.674106f, 1.137115f, 2.682567f,
0.412362f, 0.567086f, 0.101697f, 0.862008f, 0.613648f, 1.508949f, 0.982268f, 1.908874f, 0.086188f, 0.171423f, 0.081953f, 0.265592f, 0.838669f, 1.804656f, 1.268752f, 1.996750f,
0.655321f, 1.297525f, 0.229900f, 2.179659f, 0.856121f, 3.030970f, 1.949401f, 4.237352f, 0.401411f, 1.149487f, 0.542954f, 1.968163f, 1.253534f, 3.883570f, 2.697599f, 4.748653f,
0.374635f, 0.879060f, 0.141320f, 1.090733f, 0.746346f, 3.131377f, 1.827332f, 3.233517f, 0.279840f, 0.949670f, 0.407000f, 1.201038f, 0.871105f, 3.198261f, 2.015686f, 2.888552f,
0.985132f, 1.496711f, 0.222286f, 2.549266f, 1.297360f, 3.524431f, 1.900023f, 4.995813f, 0.709213f, 1.558379f, 0.616996f, 2.705417f, 1.627642f, 3.869332f, 2.252851f, 4.797109f,
0.167408f, 0.219374f, 0.051077f, 0.413628f, 0.158854f, 0.372213f, 0.314575f, 0.584059f, 0.033769f, 0.064000f, 0.039724f, 0.122995f, 0.227141f, 0.465732f, 0.425104f, 0.639186f,
0.224094f, 0.422794f, 0.097259f, 0.880975f, 0.186677f, 0.629761f, 0.525862f, 1.092070f, 0.132477f, 0.361487f, 0.221681f, 0.767736f, 0.285968f, 0.844209f, 0.761329f, 1.280415f,
0.050903f, 0.113812f, 0.023755f, 0.175166f, 0.064663f, 0.258514f, 0.195859f, 0.331121f, 0.036696f, 0.118664f, 0.066026f, 0.186150f, 0.078960f, 0.276241f, 0.226034f, 0.309468f,
0.311615f, 0.451127f, 0.086986f, 0.953098f, 0.261677f, 0.677377f, 0.474108f, 1.190994f, 0.216509f, 0.453325f, 0.233021f, 0.976187f, 0.343469f, 0.778041f, 0.588133f, 1.196486f,
0.169161f, 0.270078f, 0.048070f, 0.432381f, 0.155710f, 0.444519f, 0.287193f, 0.592253f, 0.045596f, 0.105285f, 0.049956f, 0.171802f, 0.286063f, 0.714633f, 0.498647f, 0.832774f,
0.318253f, 0.731564f, 0.128648f, 1.294314f, 0.257175f, 1.057045f, 0.674747f, 1.556399f, 0.251401f, 0.835794f, 0.391819f, 1.507199f, 0.506177f, 1.820607f, 1.255134f, 2.344607f,
0.159326f, 0.434024f, 0.069251f, 0.567189f, 0.196333f, 0.956326f, 0.553880f, 1.040064f, 0.153478f, 0.604681f, 0.257203f, 0.805424f, 0.308032f, 1.312978f, 0.821286f, 1.248930f,
0.403693f, 0.712055f, 0.104958f, 1.277336f, 0.328846f, 1.037146f, 0.554929f, 1.548358f, 0.374794f, 0.956109f, 0.375702f, 1.748166f, 0.554580f, 1.530594f, 0.884472f, 1.998564f,
0.050982f, 0.081258f, 0.015416f, 0.127115f, 0.072640f, 0.207016f, 0.142563f, 0.269511f, 0.018840f, 0.043429f, 0.021965f, 0.069247f, 0.111253f, 0.277454f, 0.206357f, 0.315929f,
0.088957f, 0.204134f, 0.038264f, 0.352905f, 0.111269f, 0.456556f, 0.310642f, 0.656866f, 0.096341f, 0.319744f, 0.159774f, 0.563415f, 0.182574f, 0.655557f, 0.481729f, 0.824935f,
0.040876f, 0.111162f, 0.018905f, 0.141946f, 0.077968f, 0.379127f, 0.234052f, 0.402897f, 0.053984f, 0.212328f, 0.096266f, 0.276351f, 0.101979f, 0.433940f, 0.289324f, 0.403335f,
0.152569f, 0.268650f, 0.042209f, 0.470905f, 0.192374f, 0.605690f, 0.345435f, 0.883562f, 0.194199f, 0.494561f, 0.207145f, 0.883589f, 0.270465f, 0.745185f, 0.458993f, 0.950774f,
0.191110f, 0.208318f, 0.054113f, 0.402746f, 0.171016f, 0.333322f, 0.314294f, 0.536301f, 0.035451f, 0.055889f, 0.038702f, 0.110132f, 0.334925f, 0.571247f, 0.581732f, 0.803886f,
0.259028f, 0.406519f, 0.104333f, 0.868550f, 0.203488f, 0.571029f, 0.531979f, 1.015342f, 0.140819f, 0.319630f, 0.218687f, 0.696059f, 0.426952f, 1.048449f, 1.054898f, 1.630527f,
0.163543f, 0.304169f, 0.070830f, 0.480016f, 0.195918f, 0.651543f, 0.550734f, 0.855705f, 0.108421f, 0.291641f, 0.181045f, 0.469108f, 0.327676f, 0.953590f, 0.870537f, 1.095391f,
0.407795f, 0.491088f, 0.105645f, 1.063843f, 0.322939f, 0.695379f, 0.543010f, 1.253661f, 0.260557f, 0.453809f, 0.260255f, 1.002018f, 0.580575f, 1.093978f, 0.922617f, 1.725017f,
0.235787f, 0.430312f, 0.076065f, 0.617582f, 0.254104f, 0.829199f, 0.532051f, 0.990399f, 0.051576f, 0.136134f, 0.064150f, 0.199141f, 0.400933f, 1.144901f, 0.793395f, 1.196040f,
0.343106f, 0.901534f, 0.157451f, 1.429893f, 0.324607f, 1.525098f, 0.966844f, 2.013071f, 0.219951f, 0.835860f, 0.389163f, 1.351260f, 0.548717f, 2.255986f, 1.544620f, 2.604499f,
0.078177f, 0.243433f, 0.038575f, 0.285186f, 0.112787f, 0.627980f, 0.361216f, 0.612257f, 0.061114f, 0.275230f, 0.116267f, 0.328646f, 0.151977f, 0.740480f, 0.460004f, 0.631434f,
0.460839f, 0.929150f, 0.136019f, 1.494209f, 0.439506f, 1.584477f, 0.841966f, 2.120565f, 0.347211f, 1.012473f, 0.395122f, 1.659561f, 0.636579f, 2.008271f, 1.152545f, 2.350792f,
0.227697f, 0.506292f, 0.068415f, 0.616971f, 0.238035f, 0.946391f, 0.464212f, 0.959786f, 0.066553f, 0.214025f, 0.077099f, 0.265836f, 0.482559f, 1.678913f, 0.889407f, 1.489219f,
0.465676f, 1.490799f, 0.199037f, 2.007674f, 0.427374f, 2.446407f, 1.185601f, 2.741845f, 0.398900f, 1.846939f, 0.657358f, 2.535191f, 0.928212f, 4.649604f, 2.433618f, 4.557812f,
0.233849f, 0.887195f, 0.107472f, 0.882511f, 0.327273f, 2.220136f, 0.976229f, 1.837895f, 0.244277f, 1.340351f, 0.432843f, 1.358950f, 0.566603f, 3.363535f, 1.597332f, 2.435361f,
0.570553f, 1.401566f, 0.156848f, 1.913780f, 0.527845f, 2.318506f, 0.941820f, 2.634672f, 0.574412f, 2.040769f, 0.608826f, 2.840247f, 0.982295f, 3.775661f, 1.656455f, 3.752647f,
0.143494f, 0.318520f, 0.045878f, 0.379276f, 0.232197f, 0.921602f, 0.481845f, 0.913277f, 0.057502f, 0.184604f, 0.070883f, 0.224049f, 0.392428f, 1.362997f, 0.769636f, 1.181355f,
0.272175f, 0.869844f, 0.123787f, 1.144644f, 0.386644f, 2.209472f, 1.141344f, 2.419678f, 0.319645f, 1.477454f, 0.560508f, 1.981652f, 0.700073f, 3.500816f, 1.953098f, 3.353242f,
0.125452f, 0.475137f, 0.061350f, 0.461823f, 0.271763f, 1.840422f, 0.862597f, 1.488721f, 0.179665f, 0.984143f, 0.338757f, 0.974986f, 0.392241f, 2.324488f, 1.176643f, 1.644561f,
0.450890f, 1.105722f, 0.131895f, 1.475296f, 0.645681f, 2.831248f, 1.225903f, 3.143774f, 0.622354f, 2.207320f, 0.701912f, 3.001806f, 1.001723f, 3.843760f, 1.797468f, 3.732984f,
0.277727f, 0.421616f, 0.083149f, 0.620452f, 0.282253f, 0.766166f, 0.548476f, 0.938326f, 0.055866f, 0.122660f, 0.064488f, 0.183983f, 0.609979f, 1.448929f, 1.120234f, 1.552045f,
0.409200f, 0.894387f, 0.174272f, 1.454542f, 0.365087f, 1.426827f, 1.009184f, 1.931134f, 0.241233f, 0.762570f, 0.396112f, 1.264051f, 0.845282f, 2.890848f, 2.208263f, 3.422100f,
0.259155f, 0.671272f, 0.118676f, 0.806355f, 0.352591f, 1.633033f, 1.047988f, 1.632536f, 0.186306f, 0.697940f, 0.328942f, 0.854535f, 0.650737f, 2.637413f, 1.827958f, 2.306069f,
0.622250f, 1.043608f, 0.170448f, 1.720848f, 0.559643f, 1.678295f, 0.994986f, 2.303103f, 0.431134f, 1.045775f, 0.455330f, 1.757629f, 1.110232f, 2.913531f, 1.865500f, 3.496965f,
0.073437f, 0.138926f, 0.022603f, 0.205862f, 0.085535f, 0.289332f, 0.170874f, 0.356805f, 0.019000f, 0.051983f, 0.022547f, 0.078513f, 0.134295f, 0.397523f, 0.253553f, 0.428768f,
0.090970f, 0.247775f, 0.039830f, 0.405753f, 0.093018f, 0.453014f, 0.264335f, 0.617384f, 0.068976f, 0.271711f, 0.116437f, 0.453519f, 0.156464f, 0.666816f, 0.420220f, 0.794835f,
0.023294f, 0.075188f, 0.010966f, 0.090945f, 0.036321f, 0.209629f, 0.110983f, 0.211020f, 0.021538f, 0.100546f, 0.039094f, 0.123959f, 0.048701f, 0.245966f, 0.140640f, 0.216558f,
0.131106f, 0.274009f, 0.036920f, 0.454960f, 0.135138f, 0.505014f, 0.247000f, 0.697833f, 0.116834f, 0.353152f, 0.126851f, 0.597659f, 0.194770f, 0.636936f, 0.336447f, 0.769787f,
0.062659f, 0.144421f, 0.017963f, 0.181710f, 0.070796f, 0.291769f, 0.131726f, 0.305510f, 0.021662f, 0.072210f, 0.023942f, 0.092603f, 0.142814f, 0.515054f, 0.251137f, 0.471701f,
0.109090f, 0.362014f, 0.044486f, 0.503364f, 0.108205f, 0.642057f, 0.286397f, 0.742969f, 0.110526f, 0.530466f, 0.173777f, 0.751794f, 0.233854f, 1.214274f, 0.584977f, 1.228967f,
0.061564f, 0.242113f, 0.026995f, 0.248658f, 0.093120f, 0.654813f, 0.265018f, 0.559681f, 0.076063f, 0.432630f, 0.128592f, 0.452881f, 0.160423f, 0.987165f, 0.431493f, 0.737972f,
0.143417f, 0.365194f, 0.037616f, 0.514855f, 0.143400f, 0.652915f, 0.244119f, 0.766051f, 0.170776f, 0.628930f, 0.172698f, 0.903749f, 0.265548f, 1.058029f, 0.427238f, 1.085738f,
0.038895f, 0.089496f, 0.011865f, 0.110028f, 0.068023f, 0.279864f, 0.134678f, 0.286344f, 0.018435f, 0.061348f, 0.021682f, 0.076876f, 0.114397f, 0.411865f, 0.214058f, 0.368572f,
0.062804f, 0.208057f, 0.027252f, 0.282679f, 0.096424f, 0.571173f, 0.271570f, 0.645833f, 0.087238f, 0.417978f, 0.145951f, 0.578829f, 0.173730f, 0.900544f, 0.462429f, 0.890601f,
0.032532f, 0.127718f, 0.015179f, 0.128172f, 0.076166f, 0.534674f, 0.230656f, 0.446548f, 0.055105f, 0.312889f, 0.099130f, 0.320047f, 0.109390f, 0.671979f, 0.313082f, 0.490864f,
0.111638f, 0.283786f, 0.031157f, 0.390937f, 0.172781f, 0.785345f, 0.312986f, 0.900362f, 0.182254f, 0.670052f, 0.196115f, 0.940825f, 0.266737f, 1.060951f, 0.456652f, 1.063844f,
0.095932f, 0.150962f, 0.027403f, 0.229373f, 0.105372f, 0.296491f, 0.195358f, 0.374909f, 0.022824f, 0.051946f, 0.025137f, 0.080447f, 0.226598f, 0.557947f, 0.397045f, 0.617068f,
0.120326f, 0.272617f, 0.048892f, 0.457758f, 0.116027f, 0.470042f, 0.306000f, 0.656842f, 0.083899f, 0.274919f, 0.131440f, 0.470515f, 0.267312f, 0.947648f, 0.666282f, 1.158236f,
0.085640f, 0.229942f, 0.037417f, 0.285186f, 0.125929f, 0.604579f, 0.357108f, 0.624027f, 0.072818f, 0.282772f, 0.122666f, 0.357463f, 0.231268f, 0.971611f, 0.619821f, 0.877141f,
0.196332f, 0.341325f, 0.051311f, 0.581107f, 0.190843f, 0.593249f, 0.323722f, 0.840553f, 0.160893f, 0.404546f, 0.162122f, 0.702004f, 0.376734f, 1.024813f, 0.603957f, 1.269987f,
0.284882f, 0.470976f, 0.075704f, 0.698204f, 0.353294f, 1.044373f, 0.609356f, 1.288484f, 0.064019f, 0.153073f, 0.065592f, 0.231295f, 0.461774f, 1.194529f, 0.752730f, 1.288981f,
0.381043f, 0.906983f, 0.144040f, 1.485911f, 0.414845f, 1.765617f, 1.017831f, 2.407298f, 0.250951f, 0.863908f, 0.365752f, 1.442597f, 0.580909f, 2.163550f, 1.347017f, 2.580042f,
0.081681f, 0.230406f, 0.033200f, 0.278813f, 0.135607f, 0.683977f, 0.357753f, 0.688813f, 0.065599f, 0.267626f, 0.102804f, 0.330090f, 0.151368f, 0.668099f, 0.377407f, 0.588475f,
0.497844f, 0.909288f, 0.121042f, 1.510424f, 0.546375f, 1.784364f, 0.862210f, 2.466726f, 0.385350f, 1.017926f, 0.361231f, 1.723447f, 0.655556f, 1.873490f, 0.977705f, 2.265247f,
0.310698f, 0.625826f, 0.076900f, 0.787752f, 0.373770f, 1.346185f, 0.600442f, 1.410199f, 0.093297f, 0.271791f, 0.089031f, 0.348703f, 0.627690f, 1.978309f, 0.952988f, 1.812578f,
0.584073f, 1.693844f, 0.205640f, 2.356240f, 0.616841f, 3.198636f, 1.409598f, 3.702975f, 0.514002f, 2.155878f, 0.697741f, 3.056711f, 1.109797f, 5.035978f, 2.396851f, 5.099133f,
0.275940f, 0.948354f, 0.104464f, 0.974414f, 0.444398f, 2.730942f, 1.091957f, 2.335208f, 0.296128f, 1.471930f, 0.432235f, 1.541502f, 0.637341f, 3.427368f, 1.480065f, 2.563304f,
0.696110f, 1.549054f, 0.157635f, 2.184826f, 0.741087f, 2.948784f, 1.089240f, 3.461251f, 0.719983f, 2.317203f, 0.628614f, 3.331182f, 1.142450f, 3.977951f, 1.586963f, 4.083910f,
0.233262f, 0.469047f, 0.061434f, 0.576909f, 0.434357f, 1.561725f, 0.742488f, 1.598584f, 0.096031f, 0.279278f, 0.097513f, 0.350116f, 0.608109f, 1.913320f, 0.982425f, 1.712952f,
0.406685f, 1.177396f, 0.152362f, 1.600382f, 0.664817f, 3.441528f, 1.616591f, 3.893072f, 0.490677f, 2.054530f, 0.708763f, 2.846411f, 0.997164f, 4.517144f, 2.291604f, 4.469219f,
0.176354f, 0.605059f, 0.071042f, 0.607471f, 0.439622f, 2.696976f, 1.149446f, 2.253435f, 0.259470f, 1.287518f, 0.402999f, 1.317545f, 0.525621f, 2.821752f, 1.298844f, 2.062118f,
0.655359f, 1.455880f, 0.157917f, 2.006462f, 1.079961f, 4.289822f, 1.689033f, 4.920222f, 0.929315f, 2.985810f, 0.863377f, 4.194223f, 1.387937f, 4.824469f, 2.051517f, 4.839732f,
0.386584f, 0.531636f, 0.095340f, 0.808123f, 0.452113f, 1.111737f, 0.723698f, 1.406387f, 0.079890f, 0.158897f, 0.075965f, 0.246186f, 0.809384f, 1.741640f, 1.224449f, 1.927026f,
0.523556f, 1.036633f, 0.183675f, 1.741397f, 0.537534f, 1.903060f, 1.223974f, 2.660513f, 0.317089f, 0.908022f, 0.428899f, 1.554723f, 1.030964f, 3.194025f, 2.218629f, 3.905509f,
0.311950f, 0.731972f, 0.117674f, 0.908227f, 0.488403f, 2.049147f, 1.195791f, 2.115986f, 0.230393f, 0.781865f, 0.335084f, 0.988816f, 0.746697f, 2.741498f, 1.727814f, 2.476020f,
0.774447f, 1.176618f, 0.174747f, 2.004068f, 0.801530f, 2.177449f, 1.173864f, 3.086492f, 0.551260f, 1.211304f, 0.479582f, 2.102880f, 1.317207f, 3.131347f, 1.823172f, 3.882172f,
0.143729f, 0.188344f, 0.043852f, 0.355121f, 0.174452f, 0.408760f, 0.345462f, 0.641406f, 0.034164f, 0.064749f, 0.040189f, 0.124435f, 0.214310f, 0.439424f, 0.401091f, 0.603081f,
0.257552f, 0.485918f, 0.111780f, 1.012506f, 0.274433f, 0.925806f, 0.773065f, 1.605443f, 0.179416f, 0.489569f, 0.300227f, 1.039759f, 0.361188f, 1.066265f, 0.961586f, 1.617210f,
0.045585f, 0.101922f, 0.021273f, 0.156866f, 0.074070f, 0.296125f, 0.224354f, 0.379295f, 0.038724f, 0.125223f, 0.069676f, 0.196440f, 0.077709f, 0.271863f, 0.222451f, 0.304563f,
0.373768f, 0.541106f, 0.104336f, 1.143198f, 0.401475f, 1.039261f, 0.727396f, 1.827274f, 0.306017f, 0.640738f, 0.329356f, 1.379759f, 0.452744f, 1.025575f, 0.775248f, 1.577149f,
0.196620f, 0.313917f, 0.055873f, 0.502565f, 0.231501f, 0.660885f, 0.426982f, 0.880529f, 0.062451f, 0.144205f, 0.068423f, 0.235310f, 0.365400f, 0.912831f, 0.636943f, 1.063737f,
0.495183f, 1.138272f, 0.200169f, 2.013879f, 0.511838f, 2.103765f, 1.342902f, 3.097595f, 0.460942f, 1.532425f, 0.718399f, 2.763444f, 0.865521f, 3.113085f, 2.146174f, 4.009081f,
0.193163f, 0.526203f, 0.083959f, 0.687650f, 0.304468f, 1.483049f, 0.858945f, 1.612909f, 0.219266f, 0.863878f, 0.367453f, 1.150670f, 0.410409f, 1.749356f, 1.094246f, 1.664022f,
0.655533f, 1.156263f, 0.170435f, 2.074189f, 0.683040f, 2.154235f, 1.152631f, 3.216064f, 0.717169f, 1.829518f, 0.718908f, 3.345124f, 0.989666f, 2.731393f, 1.578368f, 3.566500f,
0.050651f, 0.080730f, 0.015316f, 0.126289f, 0.092311f, 0.263077f, 0.181169f, 0.342495f, 0.022057f, 0.050844f, 0.025714f, 0.081069f, 0.121468f, 0.302928f, 0.225304f, 0.344936f,
0.118308f, 0.271488f, 0.050889f, 0.469347f, 0.189286f, 0.776676f, 0.528452f, 1.117436f, 0.150985f, 0.501099f, 0.250397f, 0.882978f, 0.266844f, 0.958136f, 0.704076f, 1.205692f,
0.042359f, 0.115196f, 0.019592f, 0.147098f, 0.103349f, 0.502546f, 0.310245f, 0.534054f, 0.065923f, 0.259283f, 0.117555f, 0.337465f, 0.116138f, 0.494188f, 0.329494f, 0.459334f,
0.211764f, 0.372882f, 0.058586f, 0.653610f, 0.341540f, 1.075340f, 0.613283f, 1.568673f, 0.317628f, 0.808893f, 0.338802f, 1.445179f, 0.412551f, 1.136660f, 0.700121f, 1.450252f,
0.304007f, 0.331381f, 0.086080f, 0.640666f, 0.347974f, 0.678226f, 0.639509f, 1.091236f, 0.066453f, 0.104764f, 0.072548f, 0.206443f, 0.585502f, 0.998632f, 1.016962f, 1.405323f,
0.551587f, 0.865662f, 0.222172f, 1.849536f, 0.554264f, 1.555379f, 1.449014f, 2.765607f, 0.353358f, 0.802052f, 0.548754f, 1.746628f, 0.999145f, 2.453560f, 2.468651f, 3.815727f,
0.271360f, 0.504695f, 0.117526f, 0.796471f, 0.415814f, 1.382825f, 1.168869f, 1.816136f, 0.211988f, 0.570228f, 0.353986f, 0.917220f, 0.597503f, 1.738828f, 1.587385f, 1.997396f,
0.906275f, 1.091382f, 0.234784f, 2.364259f, 0.918010f, 1.976739f, 1.543603f, 3.563754f, 0.682350f, 1.188439f, 0.681558f, 2.624094f, 1.417936f, 2.671820f, 2.253307f, 4.213006f,
0.216654f, 0.395395f, 0.069892f, 0.567469f, 0.298654f, 0.974577f, 0.625332f, 1.164038f, 0.055845f, 0.147401f, 0.069460f, 0.215623f, 0.404855f, 1.156103f, 0.801157f, 1.207742f,
0.422030f, 1.108912f, 0.193669f, 1.758808f, 0.510721f, 2.399510f, 1.521182f, 3.167262f, 0.318807f, 1.211531f, 0.564070f, 1.958575f, 0.741728f, 3.049527f, 2.087939f, 3.520629f,
0.074927f, 0.233314f, 0.036971f, 0.273331f, 0.138270f, 0.769868f, 0.442831f, 0.750594f, 0.069022f, 0.310845f, 0.131312f, 0.371173f, 0.160073f, 0.779930f, 0.484511f, 0.665074f,
0.591580f, 1.192752f, 0.174608f, 1.918119f, 0.721671f, 2.601720f, 1.382513f, 3.481979f, 0.525224f, 1.531561f, 0.597699f, 2.510405f, 0.898044f, 2.833139f, 1.625936f, 3.316346f,
0.283246f, 0.629807f, 0.085105f, 0.767487f, 0.378755f, 1.505868f, 0.738639f, 1.527182f, 0.097558f, 0.313731f, 0.113017f, 0.389678f, 0.659687f, 2.295174f, 1.215873f, 2.035851f,
0.775457f, 2.482522f, 0.331442f, 3.343237f, 0.910317f, 5.210902f, 2.525356f, 5.840190f, 0.782753f, 3.624207f, 1.289918f, 4.974749f, 1.698644f, 8.508857f, 4.453563f, 8.340877f,
0.303428f, 1.151169f, 0.139449f, 1.145091f, 0.543176f, 3.684764f, 1.620250f, 3.050357f, 0.373498f, 2.049392f, 0.661815f, 2.077830f, 0.807941f, 4.796199f, 2.277699f, 3.472679f,
0.991561f, 2.435775f, 0.272585f, 3.325948f, 1.173382f, 5.153971f, 2.093639f, 5.856797f, 1.176341f, 4.179302f, 1.246818f, 5.816558f, 1.876060f, 7.211038f, 3.163620f, 7.167084f,
0.152575f, 0.338676f, 0.048781f, 0.403277f, 0.315802f, 1.253435f, 0.655339f, 1.242112f, 0.072048f, 0.231299f, 0.088813f, 0.280723f, 0.458553f, 1.592665f, 0.899322f, 1.380416f,
0.387404f, 1.238105f, 0.176194f, 1.629245f, 0.703942f, 4.022671f, 2.077985f, 4.405384f, 0.536131f, 2.478086f, 0.940121f, 3.323760f, 1.095066f, 5.476039f, 3.055071f, 5.245201f,
0.139136f, 0.526964f, 0.068042f, 0.512197f, 0.385535f, 2.610895f, 1.223714f, 2.111959f, 0.234808f, 1.286194f, 0.442727f, 1.274226f, 0.478075f, 2.833156f, 1.434128f, 2.004440f,
0.669786f, 1.642522f, 0.195927f, 2.191516f, 1.226856f, 5.379643f, 2.329333f, 5.973473f, 1.089404f, 3.863821f, 1.228668f, 5.254537f, 1.635289f, 6.274844f, 2.934322f, 6.094005f,
0.472823f, 0.717790f, 0.141559f, 1.056303f, 0.614653f, 1.668451f, 1.194396f, 2.043357f, 0.112077f, 0.246076f, 0.129373f, 0.369100f, 1.141239f, 2.710872f, 2.095900f, 2.903797f,
0.932575f, 2.038327f, 0.397171f, 3.314934f, 1.064278f, 4.159393f, 2.941906f, 5.629514f, 0.647845f, 2.047926f, 1.063782f, 3.394683f, 2.117051f, 7.240274f, 5.530705f, 8.570820f,
0.460208f, 1.192045f, 0.210746f, 1.431925f, 0.800896f, 3.709365f, 2.380460f, 3.708236f, 0.389859f, 1.460491f, 0.688335f, 1.788178f, 1.269935f, 5.146994f, 3.567318f, 4.500367f,
1.480004f, 2.482191f, 0.405405f, 4.092987f, 1.702625f, 5.105947f, 3.027089f, 7.006828f, 1.208362f, 2.931044f, 1.276176f, 4.926193f, 2.901970f, 7.615507f, 4.876121f, 9.140509f,
0.111484f, 0.210901f, 0.034313f, 0.312517f, 0.166093f, 0.561828f, 0.331805f, 0.692847f, 0.033988f, 0.092992f, 0.040334f, 0.140451f, 0.224047f, 0.663193f, 0.423006f, 0.715320f,
0.184869f, 0.503526f, 0.080941f, 0.824568f, 0.241792f, 1.177568f, 0.687116f, 1.604834f, 0.165176f, 0.650666f, 0.278832f, 1.086042f, 0.349430f, 1.489196f, 0.938476f, 1.775100f,
0.036885f, 0.119058f, 0.017365f, 0.144009f, 0.073567f, 0.424592f, 0.224791f, 0.427409f, 0.040188f, 0.187612f, 0.072947f, 0.231300f, 0.084748f, 0.428024f, 0.244738f, 0.376847f,
0.278060f, 0.581137f, 0.078303f, 0.964910f, 0.366608f, 1.370021f, 0.670072f, 1.893110f, 0.291990f, 0.882595f, 0.317026f, 1.493668f, 0.453959f, 1.484536f, 0.784173f, 1.794179f,
0.128777f, 0.296816f, 0.036917f, 0.373451f, 0.186111f, 0.767018f, 0.346287f, 0.803142f, 0.052461f, 0.174879f, 0.057984f, 0.224268f, 0.322559f, 1.163296f, 0.567216f, 1.065378f,
0.300130f, 0.995977f, 0.122391f, 1.384861f, 0.380788f, 2.259474f, 1.007866f, 2.614595f, 0.358324f, 1.719761f, 0.563382f, 2.437300f, 0.707048f, 3.671317f, 1.768658f, 3.715740f,
0.131977f, 0.519024f, 0.057870f, 0.533054f, 0.255343f, 1.795547f, 0.726699f, 1.534690f, 0.192146f, 1.092880f, 0.324840f, 1.144038f, 0.377937f, 2.325629f, 1.016542f, 1.738565f,
0.411789f, 1.048568f, 0.108006f, 1.478284f, 0.526664f, 2.397949f, 0.896572f, 2.813463f, 0.577813f, 2.127954f, 0.584315f, 3.057789f, 0.837909f, 3.338505f, 1.348106f, 3.425939f,
0.068327f, 0.157217f, 0.020843f, 0.193286f, 0.152850f, 0.628861f, 0.302625f, 0.643423f, 0.038162f, 0.126996f, 0.044883f, 0.159138f, 0.220849f, 0.795122f, 0.413247f, 0.711544f,
0.147690f, 0.489269f, 0.064086f, 0.664753f, 0.290043f, 1.718081f, 0.816878f, 1.942655f, 0.241744f, 1.158260f, 0.404444f, 1.603992f, 0.448974f, 2.327297f, 1.195067f, 2.301603f,
0.059610f, 0.234026f, 0.027813f, 0.234857f, 0.178517f, 1.253173f, 0.540614f, 1.046622f, 0.118984f, 0.675598f, 0.214044f, 0.691053f, 0.220277f, 1.353157f, 0.630451f, 0.988448f,
0.273985f, 0.696475f, 0.076467f, 0.959449f, 0.542403f, 2.465392f, 0.982539f, 2.826457f, 0.527082f, 1.937805f, 0.567170f, 2.720886f, 0.719415f, 2.861487f, 1.231635f, 2.869291f,
0.269833f, 0.424618f, 0.077077f, 0.645167f, 0.379110f, 1.066725f, 0.702866f, 1.348858f, 0.075651f, 0.172174f, 0.083316f, 0.266641f, 0.700435f, 1.724663f, 1.227302f, 1.907412f,
0.453061f, 1.026480f, 0.184094f, 1.723592f, 0.558812f, 2.263836f, 1.473769f, 3.163508f, 0.372257f, 1.219803f, 0.583195f, 2.087650f, 1.106111f, 3.921266f, 2.757004f, 4.792660f,
0.251258f, 0.674624f, 0.109778f, 0.836705f, 0.472585f, 2.268857f, 1.340152f, 2.341844f, 0.251751f, 0.977613f, 0.424086f, 1.235839f, 0.745661f, 3.132691f, 1.998441f, 2.828100f,
0.771505f, 1.341268f, 0.201630f, 2.283513f, 0.959254f, 2.981913f, 1.627157f, 4.224964f, 0.745027f, 1.873274f, 0.750715f, 3.250674f, 1.626911f, 4.425616f, 2.608164f, 5.484388f,
0.195092f, 0.322533f, 0.051844f, 0.478143f, 0.309472f, 0.914832f, 0.533773f, 1.128663f, 0.051662f, 0.123526f, 0.052932f, 0.186650f, 0.347525f, 0.898987f, 0.566494f, 0.970070f,
0.349315f, 0.831462f, 0.132046f, 1.362184f, 0.486451f, 2.070377f, 1.193518f, 2.822818f, 0.271093f, 0.933248f, 0.395108f, 1.558384f, 0.585237f, 2.179672f, 1.357055f, 2.599268f,
0.058346f, 0.164582f, 0.023715f, 0.199160f, 0.123903f, 0.624943f, 0.326875f, 0.629362f, 0.055217f, 0.225270f, 0.086534f, 0.277848f, 0.118824f, 0.524459f, 0.296265f, 0.461953f,
0.476306f, 0.869949f, 0.115805f, 1.445079f, 0.668641f, 2.183665f, 1.055153f, 3.018725f, 0.434445f, 1.147612f, 0.407253f, 1.943018f, 0.689261f, 1.969814f, 1.027973f, 2.381712f,
0.288053f, 0.580214f, 0.071295f, 0.730338f, 0.443250f, 1.596427f, 0.712058f, 1.672342f, 0.101927f, 0.296931f, 0.097266f, 0.380957f, 0.639530f, 2.015626f, 0.970964f, 1.846768f,
0.724885f, 2.102208f, 0.255218f, 2.924299f, 0.979232f, 5.077817f, 2.237729f, 5.878454f, 0.751715f, 3.152918f, 1.020429f, 4.470363f, 1.513656f, 6.868584f, 3.269072f, 6.954721f,
0.266848f, 0.917104f, 0.101022f, 0.942305f, 0.549706f, 3.378086f, 1.350715f, 2.888575f, 0.337453f, 1.677342f, 0.492554f, 1.756623f, 0.677332f, 3.642421f, 1.572932f, 2.724140f,
0.901632f, 2.006404f, 0.204175f, 2.829884f, 1.227810f, 4.885451f, 1.804618f, 5.734491f, 1.098905f, 3.536731f, 0.959450f, 5.084360f, 1.626185f, 5.662293f, 2.258914f, 5.813117f,
0.184850f, 0.371700f, 0.048683f, 0.457176f, 0.440284f, 1.583036f, 0.752620f, 1.620399f, 0.089675f, 0.260795f, 0.091059f, 0.326945f, 0.529589f, 1.666270f, 0.855573f, 1.491773f,
0.431422f, 1.249012f, 0.161629f, 1.697727f, 0.902104f, 4.669877f, 2.193584f, 5.282587f, 0.613375f, 2.568283f, 0.885995f, 3.558182f, 1.162497f, 5.266103f, 2.671560f, 5.210231f,
0.145772f, 0.500135f, 0.058722f, 0.502129f, 0.464815f, 2.851525f, 1.215314f, 2.382568f, 0.252734f, 1.254093f, 0.392537f, 1.283340f, 0.477468f, 2.563245f, 1.179854f, 1.873202f,
0.725559f, 1.611830f, 0.174833f, 2.221389f, 1.529368f, 6.074954f, 2.391894f, 6.967683f, 1.212391f, 3.895311f, 1.126369f, 5.471816f, 1.688669f, 5.869814f, 2.496031f, 5.888384f,
0.490516f, 0.674565f, 0.120972f, 1.025383f, 0.733780f, 1.804351f, 1.174563f, 2.282568f, 0.119451f, 0.237581f, 0.113581f, 0.368094f, 1.128612f, 2.428557f, 1.707382f, 2.687061f,
0.889283f, 1.760765f, 0.311979f, 2.957838f, 1.167866f, 4.134654f, 2.659248f, 5.780323f, 0.634665f, 1.817436f, 0.858456f, 3.111831f, 1.924425f, 5.962056f, 4.141355f, 7.290132f,
0.412864f, 0.968762f, 0.155741f, 1.202034f, 0.826820f, 3.469010f, 2.024360f, 3.582164f, 0.359317f, 1.219384f, 0.522591f, 1.542142f, 1.086046f, 3.987417f, 2.513047f, 3.601288f,
1.372833f, 2.085746f, 0.309767f, 3.552537f, 1.817421f, 4.937239f, 2.661668f, 6.998440f, 1.151513f, 2.530263f, 1.001786f, 4.392652f, 2.566027f, 6.100122f, 3.551689f, 7.562790f,
0.111522f, 0.146140f, 0.034026f, 0.275546f, 0.125423f, 0.293880f, 0.248371f, 0.461142f, 0.024782f, 0.046966f, 0.029151f, 0.090260f, 0.165108f, 0.338541f, 0.309008f, 0.464624f,
0.205238f, 0.387219f, 0.089075f, 0.806847f, 0.202635f, 0.683593f, 0.570813f, 1.185420f, 0.133657f, 0.364708f, 0.223656f, 0.774575f, 0.285782f, 0.843661f, 0.760835f, 1.279584f,
0.042457f, 0.094929f, 0.019814f, 0.146104f, 0.063923f, 0.255560f, 0.193620f, 0.327336f, 0.033717f, 0.109032f, 0.060667f, 0.171041f, 0.071864f, 0.251415f, 0.205720f, 0.281657f,
0.263729f, 0.381803f, 0.073619f, 0.806637f, 0.262482f, 0.679462f, 0.475567f, 1.194659f, 0.201855f, 0.422643f, 0.217250f, 0.910117f, 0.317189f, 0.718510f, 0.543133f, 1.104939f,
0.154149f, 0.246110f, 0.043804f, 0.394009f, 0.168171f, 0.480091f, 0.310175f, 0.639648f, 0.045771f, 0.105689f, 0.050148f, 0.172461f, 0.284440f, 0.710580f, 0.495819f, 0.828051f,
0.398709f, 0.916507f, 0.161171f, 1.621523f, 0.381862f, 1.569535f, 1.001886f, 2.310992f, 0.346955f, 1.153470f, 0.540746f, 2.080070f, 0.691953f, 2.488799f, 1.715788f, 3.205115f,
0.181783f, 0.495202f, 0.079013f, 0.647138f, 0.265495f, 1.293209f, 0.748995f, 1.406446f, 0.192903f, 0.760010f, 0.323273f, 1.012320f, 0.383491f, 1.634620f, 1.022477f, 1.554882f,
0.467356f, 0.824346f, 0.121510f, 1.478772f, 0.451215f, 1.423082f, 0.761425f, 2.124523f, 0.477982f, 1.219346f, 0.479141f, 2.229475f, 0.700569f, 1.933509f, 1.117301f, 2.524668f,
0.043223f, 0.068891f, 0.013070f, 0.107769f, 0.072990f, 0.208014f, 0.143250f, 0.270810f, 0.017595f, 0.040560f, 0.020514f, 0.064672f, 0.102919f, 0.256670f, 0.190899f, 0.292263f,
0.103685f, 0.237932f, 0.044599f, 0.411335f, 0.153711f, 0.630705f, 0.429133f, 0.907420f, 0.123701f, 0.410547f, 0.205148f, 0.723419f, 0.232203f, 0.833755f, 0.612676f, 1.049174f,
0.043390f, 0.117999f, 0.020068f, 0.150677f, 0.098091f, 0.476982f, 0.294463f, 0.506887f, 0.063127f, 0.248287f, 0.112570f, 0.323153f, 0.118120f, 0.502624f, 0.335118f, 0.467175f,
0.164330f, 0.289359f, 0.045463f, 0.507205f, 0.245579f, 0.773205f, 0.440971f, 1.127928f, 0.230421f, 0.586805f, 0.245781f, 1.048394f, 0.317872f, 0.875800f, 0.539445f, 1.117424f,
0.203324f, 0.221632f, 0.057572f, 0.428486f, 0.215643f, 0.420305f, 0.396311f, 0.676252f, 0.041549f, 0.065502f, 0.045359f, 0.129075f, 0.388815f, 0.663163f, 0.675335f, 0.933234f,
0.378875f, 0.594607f, 0.152606f, 1.270412f, 0.352762f, 0.989924f, 0.922227f, 1.760175f, 0.226900f, 0.515017f, 0.352368f, 1.121552f, 0.681426f, 1.673351f, 1.683644f, 2.602363f,
0.217855f, 0.405182f, 0.094353f, 0.639427f, 0.309317f, 1.028661f, 0.869503f, 1.350994f, 0.159100f, 0.427964f, 0.265672f, 0.688386f, 0.476289f, 1.386076f, 1.265356f, 1.592189f,
0.551194f, 0.663776f, 0.142795f, 1.437937f, 0.517340f, 1.113981f, 0.869890f, 2.008336f, 0.387962f, 0.675708f, 0.387512f, 1.491975f, 0.856270f, 1.613470f, 1.360736f, 2.544168f,
0.147639f, 0.269442f, 0.047628f, 0.386702f, 0.188576f, 0.615367f, 0.394847f, 0.734997f, 0.035576f, 0.093901f, 0.044249f, 0.137362f, 0.273932f, 0.782240f, 0.542077f, 0.817180f,
0.295361f, 0.776082f, 0.135541f, 1.230918f, 0.331190f, 1.556027f, 0.986451f, 2.053896f, 0.208581f, 0.792652f, 0.369046f, 1.281410f, 0.515423f, 2.119102f, 1.450900f, 2.446469f,
0.061290f, 0.190849f, 0.030242f, 0.223583f, 0.104800f, 0.583513f, 0.335639f, 0.568904f, 0.052781f, 0.237701f, 0.100414f, 0.283834f, 0.130011f, 0.633454f, 0.393516f, 0.540169f,
0.366596f, 0.739135f, 0.108202f, 1.188637f, 0.414378f, 1.493888f, 0.793829f, 1.999326f, 0.304268f, 0.887249f, 0.346253f, 1.454303f, 0.552561f, 1.743213f, 1.000428f, 2.040528f,
0.195027f, 0.433649f, 0.058599f, 0.528448f, 0.241642f, 0.960731f, 0.471245f, 0.974329f, 0.062796f, 0.201942f, 0.072746f, 0.250827f, 0.451001f, 1.569118f, 0.831243f, 1.391829f,
0.548359f, 1.755497f, 0.234377f, 2.364146f, 0.596463f, 3.414316f, 1.654678f, 3.826642f, 0.517451f, 2.395838f, 0.852720f, 3.288634f, 1.192665f, 5.974302f, 3.126969f, 5.856359f,
0.250785f, 0.951450f, 0.115256f, 0.946426f, 0.415979f, 2.821891f, 1.240831f, 2.336045f, 0.288584f, 1.583467f, 0.511353f, 1.605440f, 0.663034f, 3.935980f, 1.869184f, 2.849839f,
0.620854f, 1.525132f, 0.170676f, 2.082503f, 0.680759f, 2.990170f, 1.214663f, 3.397928f, 0.688558f, 2.446309f, 0.729811f, 3.404659f, 1.166342f, 4.483084f, 1.966814f, 4.455758f,
0.114348f, 0.253821f, 0.036559f, 0.302237f, 0.219302f, 0.870420f, 0.455085f, 0.862557f, 0.050478f, 0.162052f, 0.062224f, 0.196679f, 0.341226f, 1.185159f, 0.669218f, 1.027217f,
0.298184f, 0.952965f, 0.135615f, 1.254024f, 0.502042f, 2.868916f, 1.481992f, 3.141861f, 0.385769f, 1.783090f, 0.676458f, 2.391589f, 0.836891f, 4.184995f, 2.334800f, 4.008580f,
0.125170f, 0.474068f, 0.061212f, 0.460783f, 0.321371f, 2.176368f, 1.020053f, 1.760469f, 0.197473f, 1.081690f, 0.372334f, 1.071626f, 0.427035f, 2.530688f, 1.281020f, 1.790446f,
0.456477f, 1.119422f, 0.133529f, 1.493576f, 0.774747f, 3.397190f, 1.470950f, 3.772187f, 0.694079f, 2.461711f, 0.782807f, 3.347761f, 1.106588f, 4.246142f, 1.985635f, 4.123769f,
0.277729f, 0.421619f, 0.083150f, 0.620456f, 0.334531f, 0.908072f, 0.650062f, 1.112118f, 0.061543f, 0.135123f, 0.071040f, 0.202677f, 0.665592f, 1.581032f, 1.222369f, 1.693550f,
0.562578f, 1.229625f, 0.239594f, 1.999741f, 0.594891f, 2.324945f, 1.644415f, 3.146687f, 0.365349f, 1.154916f, 0.599914f, 1.914412f, 1.268058f, 4.336733f, 3.312747f, 5.133695f,
0.324483f, 0.840487f, 0.148593f, 1.009622f, 0.523237f, 2.423382f, 1.555189f, 2.422645f, 0.256970f, 0.962664f, 0.453707f, 1.178655f, 0.889055f, 3.603306f, 2.497407f, 3.150616f,
0.790542f, 1.325859f, 0.216546f, 2.186263f, 0.842684f, 2.527098f, 1.498204f, 3.467905f, 0.603387f, 1.463597f, 0.637250f, 2.459862f, 1.539089f, 4.038961f, 2.586100f, 4.847762f,
0.092237f, 0.174490f, 0.028389f, 0.258563f, 0.127329f, 0.430704f, 0.254366f, 0.531146f, 0.026288f, 0.071924f, 0.031196f, 0.108631f, 0.184052f, 0.544805f, 0.347495f, 0.587627f,
0.157084f, 0.427849f, 0.068776f, 0.700639f, 0.190368f, 0.927124f, 0.540981f, 1.263521f, 0.131206f, 0.516849f, 0.221487f, 0.862685f, 0.294807f, 1.256404f, 0.791772f, 1.497614f,
0.036632f, 0.118240f, 0.017246f, 0.143020f, 0.067697f, 0.390719f, 0.206857f, 0.393310f, 0.037312f, 0.174183f, 0.067725f, 0.214744f, 0.083569f, 0.422070f, 0.241334f, 0.371606f,
0.209204f, 0.437230f, 0.058913f, 0.725969f, 0.255574f, 0.955086f, 0.467129f, 1.319748f, 0.205370f, 0.620769f, 0.222979f, 1.050565f, 0.339123f, 1.108999f, 0.585804f, 1.340313f,
0.107653f, 0.248128f, 0.030861f, 0.312193f, 0.144160f, 0.594125f, 0.268231f, 0.622106f, 0.040998f, 0.136667f, 0.045314f, 0.175264f, 0.267736f, 0.965579f, 0.470810f, 0.884303f,
0.257676f, 0.855094f, 0.105079f, 1.188970f, 0.302923f, 1.797446f, 0.801772f, 2.079950f, 0.287593f, 1.380289f, 0.452173f, 1.956191f, 0.602730f, 3.129649f, 1.507709f, 3.167518f,
0.132436f, 0.520826f, 0.058070f, 0.534904f, 0.237417f, 1.669495f, 0.675683f, 1.426951f, 0.180249f, 1.025214f, 0.304728f, 1.073204f, 0.376559f, 2.317149f, 1.012835f, 1.732225f,
0.313042f, 0.797122f, 0.082106f, 1.123792f, 0.370976f, 1.689085f, 0.631534f, 1.981768f, 0.410632f, 1.512264f, 0.415253f, 2.173065f, 0.632461f, 2.519932f, 1.017562f, 2.585928f,
0.062172f, 0.143054f, 0.018965f, 0.175874f, 0.128869f, 0.530200f, 0.255146f, 0.542477f, 0.032461f, 0.108026f, 0.038178f, 0.135367f, 0.199528f, 0.718362f, 0.373353f, 0.642854f,
0.138016f, 0.457220f, 0.059888f, 0.621208f, 0.251144f, 1.487663f, 0.707323f, 1.682119f, 0.211189f, 1.011860f, 0.353324f, 1.401253f, 0.416589f, 2.159424f, 1.108864f, 2.135583f,
0.065108f, 0.255612f, 0.030378f, 0.256520f, 0.180668f, 1.268270f, 0.547127f, 1.059231f, 0.121491f, 0.689831f, 0.218554f, 0.705612f, 0.238889f, 1.467487f, 0.683718f, 1.071963f,
0.226708f, 0.576296f, 0.063272f, 0.793893f, 0.415859f, 1.890210f, 0.753310f, 2.167038f, 0.407714f, 1.498952f, 0.438723f, 2.104690f, 0.591056f, 2.350937f, 1.011886f, 2.357348f,
0.192431f, 0.302816f, 0.054967f, 0.460100f, 0.250512f, 0.704883f, 0.464448f, 0.891314f, 0.050435f, 0.114785f, 0.055545f, 0.177764f, 0.495972f, 1.221220f, 0.869042f, 1.350622f,
0.331828f, 0.751808f, 0.134833f, 1.262382f, 0.379233f, 1.536333f, 1.000160f, 2.146887f, 0.254880f, 0.835187f, 0.399308f, 1.429393f, 0.804385f, 2.851620f, 2.004947f, 3.485315f,
0.215088f, 0.577508f, 0.093974f, 0.716257f, 0.374852f, 1.799647f, 1.063002f, 1.857539f, 0.201467f, 0.782349f, 0.339381f, 0.988998f, 0.633792f, 2.662703f, 1.698621f, 2.403809f,
0.500332f, 0.869831f, 0.130760f, 1.480891f, 0.576417f, 1.791836f, 0.977761f, 2.538788f, 0.451678f, 1.135686f, 0.455127f, 1.970745f, 1.047592f, 2.849720f, 1.679436f, 3.531480f,
0.167099f, 0.276253f, 0.044405f, 0.409535f, 0.245606f, 0.726036f, 0.423617f, 0.895739f, 0.041366f, 0.098908f, 0.042382f, 0.149451f, 0.295548f, 0.764532f, 0.481768f, 0.824984f,
0.307274f, 0.731395f, 0.116154f, 1.198244f, 0.396490f, 1.687496f, 0.972797f, 2.300786f, 0.222928f, 0.767439f, 0.324910f, 1.281508f, 0.511153f, 1.903749f, 1.185266f, 2.270228f,
0.059987f, 0.169212f, 0.024383f, 0.204763f, 0.118036f, 0.595351f, 0.311398f, 0.599561f, 0.053072f, 0.216516f, 0.083171f, 0.267051f, 0.121300f, 0.535389f, 0.302439f, 0.471581f,
0.370987f, 0.677589f, 0.090199f, 1.125548f, 0.482558f, 1.575950f, 0.761504f, 2.178612f, 0.316333f, 0.835613f, 0.296534f, 1.414773f, 0.533047f, 1.523375f, 0.794993f, 1.841920f,
0.249289f, 0.502132f, 0.061701f, 0.632054f, 0.355437f, 1.280156f, 0.570991f, 1.341031f, 0.082462f, 0.240228f, 0.078692f, 0.308208f, 0.549541f, 1.732003f, 0.834338f, 1.586906f,
0.644281f, 1.868451f, 0.226838f, 2.599128f, 0.806446f, 4.181834f, 1.842881f, 4.841198f, 0.624592f, 2.619727f, 0.847864f, 3.714379f, 1.335802f, 6.061528f, 2.884957f, 6.137544f,
0.277210f, 0.952718f, 0.104945f, 0.978897f, 0.529127f, 3.251623f, 1.300150f, 2.780438f, 0.327715f, 1.628938f, 0.478341f, 1.705932f, 0.698644f, 3.757031f, 1.622425f, 2.809856f,
0.709576f, 1.579019f, 0.160684f, 2.227089f, 0.895332f, 3.562522f, 1.315946f, 4.181651f, 0.808475f, 2.602007f, 0.705876f, 3.740613f, 1.270715f, 4.424563f, 1.765134f, 4.542418f,
0.174125f, 0.350134f, 0.045859f, 0.430651f, 0.384290f, 1.381711f, 0.656904f, 1.414321f, 0.078968f, 0.229657f, 0.080187f, 0.287908f, 0.495325f, 1.558463f, 0.800218f, 1.395257f,
0.417370f, 1.208329f, 0.156365f, 1.642428f, 0.808647f, 4.186081f, 1.966330f, 4.735315f, 0.554730f, 2.322730f, 0.801285f, 3.217984f, 1.116655f, 5.058440f, 2.566210f, 5.004772f,
0.164829f, 0.565517f, 0.066399f, 0.567772f, 0.486992f, 2.987577f, 1.273299f, 2.496245f, 0.267153f, 1.325639f, 0.414931f, 1.356555f, 0.536057f, 2.877778f, 1.324633f, 2.103060f,
0.621519f, 1.380704f, 0.149763f, 1.902857f, 1.213884f, 4.821790f, 1.898485f, 5.530363f, 0.970871f, 3.119328f, 0.901985f, 4.381778f, 1.436267f, 4.992462f, 2.122953f, 5.008257f,
0.362139f, 0.498018f, 0.089311f, 0.757021f, 0.501963f, 1.234316f, 0.803493f, 1.561454f, 0.082442f, 0.163972f, 0.078391f, 0.254049f, 0.827323f, 1.780242f, 1.251588f, 1.969737f,
0.674276f, 1.335055f, 0.236550f, 2.242705f, 0.820492f, 2.904830f, 1.868273f, 4.061006f, 0.449862f, 1.288232f, 0.608490f, 2.205724f, 1.448798f, 4.488515f, 3.117806f, 5.488354f,
0.365885f, 0.858528f, 0.138020f, 1.065257f, 0.678941f, 2.848570f, 1.662299f, 2.941485f, 0.297682f, 1.010219f, 0.432949f, 1.277613f, 0.955640f, 3.508634f, 2.211297f, 3.168869f,
0.921677f, 1.400304f, 0.207968f, 2.385061f, 1.130577f, 3.071346f, 1.655764f, 4.353573f, 0.722715f, 1.588049f, 0.628743f, 2.756925f, 1.710532f, 4.066383f, 2.367581f, 5.041408f,
0.196952f, 0.258088f, 0.060090f, 0.486623f, 0.237805f, 0.557203f, 0.470918f, 0.874335f, 0.040181f, 0.076152f, 0.047266f, 0.146349f, 0.259586f, 0.532257f, 0.485826f, 0.730487f,
0.408822f, 0.771317f, 0.177433f, 1.607192f, 0.433346f, 1.461903f, 1.220716f, 2.535089f, 0.244435f, 0.666983f, 0.409026f, 1.416555f, 0.506785f, 1.496085f, 1.349209f, 2.269120f,
0.075923f, 0.169755f, 0.035431f, 0.261266f, 0.122723f, 0.490635f, 0.371721f, 0.628434f, 0.055357f, 0.179007f, 0.099602f, 0.280812f, 0.114405f, 0.400244f, 0.327500f, 0.448387f,
0.519248f, 0.751719f, 0.144946f, 1.588161f, 0.554830f, 1.436237f, 1.005246f, 2.525253f, 0.364880f, 0.763984f, 0.392708f, 1.645155f, 0.555964f, 1.259393f, 0.951994f, 1.936719f,
0.213435f, 0.340765f, 0.060652f, 0.545547f, 0.249989f, 0.713664f, 0.461081f, 0.950848f, 0.058185f, 0.134354f, 0.063749f, 0.219235f, 0.350614f, 0.875892f, 0.611168f, 1.020692f,
0.622672f, 1.431328f, 0.251704f, 2.532366f, 0.640257f, 2.631594f, 1.679832f, 3.874773f, 0.497474f, 1.653877f, 0.775336f, 2.982460f, 0.962037f, 3.460231f, 2.385498f, 4.456141f,
0.254860f, 0.694274f, 0.110776f, 0.907288f, 0.399621f, 1.946532f, 1.127382f, 2.116975f, 0.248302f, 0.978275f, 0.416112f, 1.303044f, 0.478647f, 2.040219f, 1.276184f, 1.940696f,
0.721424f, 1.272485f, 0.187566f, 2.282677f, 0.747774f, 2.358400f, 1.261870f, 3.520862f, 0.677405f, 1.728079f, 0.679048f, 3.159651f, 0.962733f, 2.657059f, 1.535413f, 3.469439f,
0.040064f, 0.063856f, 0.012114f, 0.099892f, 0.072635f, 0.207003f, 0.142553f, 0.269494f, 0.014974f, 0.034517f, 0.017457f, 0.055036f, 0.084927f, 0.211800f, 0.157527f, 0.241171f,
0.108401f, 0.248754f, 0.046627f, 0.430044f, 0.172530f, 0.707925f, 0.481674f, 1.018521f, 0.118736f, 0.394070f, 0.196915f, 0.694385f, 0.216121f, 0.776010f, 0.570243f, 0.976509f,
0.040724f, 0.110749f, 0.018835f, 0.141420f, 0.098841f, 0.480627f, 0.296713f, 0.510761f, 0.054396f, 0.213949f, 0.097001f, 0.278460f, 0.098696f, 0.419969f, 0.280009f, 0.390349f,
0.169814f, 0.299016f, 0.046980f, 0.524132f, 0.272453f, 0.857820f, 0.489228f, 1.251361f, 0.218611f, 0.556729f, 0.233184f, 0.994660f, 0.292429f, 0.805700f, 0.496267f, 1.027985f,
0.351802f, 0.383479f, 0.099614f, 0.741389f, 0.400580f, 0.780760f, 0.736190f, 1.256209f, 0.066003f, 0.104054f, 0.072056f, 0.205043f, 0.598914f, 1.021507f, 1.040256f, 1.437513f,
0.739405f, 1.160425f, 0.297823f, 2.479312f, 0.739117f, 2.074116f, 1.932276f, 3.687969f, 0.406550f, 0.922787f, 0.631360f, 2.009555f, 1.183907f, 2.907274f, 2.925156f, 4.521334f,
0.381679f, 0.709874f, 0.165305f, 1.120270f, 0.581809f, 1.934855f, 1.635488f, 2.541145f, 0.255915f, 0.688386f, 0.427337f, 1.107279f, 0.742871f, 2.161874f, 1.973586f, 2.483351f,
1.063239f, 1.280407f, 0.275448f, 2.773744f, 1.071389f, 2.307007f, 1.801504f, 4.159177f, 0.687083f, 1.196683f, 0.686286f, 2.642297f, 1.470446f, 2.770763f, 2.336752f, 4.369022f,
0.211295f, 0.385613f, 0.068163f, 0.553430f, 0.289746f, 0.945507f, 0.606680f, 1.129318f, 0.046745f, 0.123382f, 0.058141f, 0.180487f, 0.349013f, 0.996639f, 0.690652f, 1.041156f,
0.476779f, 1.252770f, 0.218794f, 1.986977f, 0.573966f, 2.696654f, 1.709558f, 3.559481f, 0.309124f, 1.174735f, 0.546938f, 1.899089f, 0.740696f, 3.045283f, 2.085034f, 3.515730f,
0.088817f, 0.276566f, 0.043825f, 0.324002f, 0.163048f, 0.907828f, 0.522186f, 0.885099f, 0.070223f, 0.316252f, 0.133596f, 0.377629f, 0.167725f, 0.817213f, 0.507672f, 0.696867f,
0.584912f, 1.179308f, 0.172640f, 1.896500f, 0.709814f, 2.558975f, 1.359799f, 3.424772f, 0.445710f, 1.299697f, 0.507213f, 2.130355f, 0.784867f, 2.476087f, 1.421024f, 2.898398f,
0.218830f, 0.486576f, 0.065751f, 0.592946f, 0.291092f, 1.157335f, 0.567681f, 1.173716f, 0.064690f, 0.208033f, 0.074941f, 0.258393f, 0.450508f, 1.567402f, 0.830334f, 1.390307f,
0.693993f, 2.221726f, 0.296623f, 2.992021f, 0.810436f, 4.639153f, 2.248269f, 5.199394f, 0.601247f, 2.783821f, 0.990810f, 3.821197f, 1.343757f, 6.731155f, 3.523108f, 6.598270f,
0.284929f, 1.080988f, 0.130948f, 1.075281f, 0.507401f, 3.442072f, 1.513534f, 2.849449f, 0.301024f, 1.651725f, 0.533396f, 1.674645f, 0.670629f, 3.981072f, 1.890598f, 2.882488f,
0.776640f, 1.907821f, 0.213502f, 2.605048f, 0.914257f, 4.015786f, 1.631287f, 4.563404f, 0.790796f, 2.809538f, 0.838174f, 3.910185f, 1.298877f, 4.992511f, 2.190310f, 4.962079f,
0.085892f, 0.190658f, 0.027461f, 0.227025f, 0.176853f, 0.701940f, 0.366998f, 0.695599f, 0.034811f, 0.111757f, 0.042912f, 0.135637f, 0.228181f, 0.792529f, 0.447513f, 0.686911f,
0.252632f, 0.807385f, 0.114898f, 1.062454f, 0.456656f, 2.609555f, 1.348014f, 2.857825f, 0.300072f, 1.386982f, 0.526185f, 1.860305f, 0.631226f, 3.156537f, 1.761026f, 3.023476f,
0.095202f, 0.360570f, 0.046557f, 0.350466f, 0.262422f, 1.777157f, 0.832945f, 1.437546f, 0.137896f, 0.755345f, 0.260001f, 0.748317f, 0.289151f, 1.713560f, 0.867395f, 1.212333f,
0.382263f, 0.937427f, 0.111820f, 1.250752f, 0.696544f, 3.054276f, 1.322471f, 3.391420f, 0.533637f, 1.892667f, 0.601855f, 2.573900f, 0.824977f, 3.165558f, 1.480318f, 3.074327f,
0.389420f, 0.591176f, 0.116589f, 0.869977f, 0.503590f, 1.366976f, 0.978578f, 1.674140f, 0.079226f, 0.173948f, 0.091452f, 0.260912f, 0.830838f, 1.973554f, 1.525845f, 2.114006f,
0.889726f, 1.944673f, 0.378922f, 3.162624f, 1.010081f, 3.947580f, 2.792092f, 5.342837f, 0.530487f, 1.676941f, 0.871076f, 2.779731f, 1.785356f, 6.105884f, 4.664167f, 7.227963f,
0.460692f, 1.193300f, 0.210968f, 1.433434f, 0.797557f, 3.693899f, 2.370535f, 3.692775f, 0.334962f, 1.254836f, 0.591409f, 1.536381f, 1.123724f, 4.554406f, 3.156603f, 3.982227f,
1.235772f, 2.072578f, 0.338504f, 3.417559f, 1.414240f, 4.241117f, 2.514369f, 5.820032f, 0.865971f, 2.100529f, 0.914570f, 3.530351f, 2.141852f, 5.620764f, 3.598910f, 6.746319f,
0.202673f, 0.383409f, 0.062380f, 0.568142f, 0.300374f, 1.016048f, 0.600060f, 1.252993f, 0.053032f, 0.145098f, 0.062933f, 0.219149f, 0.360034f, 1.065721f, 0.679752f, 1.149487f,
0.389314f, 1.060372f, 0.170454f, 1.736452f, 0.506533f, 2.466895f, 1.439444f, 3.361979f, 0.298548f, 1.176050f, 0.503976f, 1.962972f, 0.650455f, 2.772102f, 1.746949f, 3.304304f,
0.081503f, 0.263074f, 0.038370f, 0.318207f, 0.161707f, 0.933301f, 0.494115f, 0.939492f, 0.076217f, 0.355805f, 0.138343f, 0.438659f, 0.165527f, 0.836006f, 0.478017f, 0.736050f,
0.512480f, 1.071070f, 0.144317f, 1.778387f, 0.672155f, 2.511857f, 1.228540f, 3.470911f, 0.461890f, 1.396149f, 0.501494f, 2.362785f, 0.739566f, 2.418528f, 1.277533f, 2.922982f,
0.185458f, 0.427458f, 0.053165f, 0.537824f, 0.266628f, 1.098853f, 0.496102f, 1.150605f, 0.064844f, 0.216159f, 0.071671f, 0.277207f, 0.410616f, 1.480871f, 0.722063f, 1.356221f,
0.500691f, 1.661532f, 0.204178f, 2.310286f, 0.631933f, 3.749689f, 1.672594f, 4.339027f, 0.513058f, 2.462399f, 0.806665f, 3.489792f, 1.042628f, 5.413803f, 2.608101f, 5.479310f,
0.231017f, 0.908514f, 0.101296f, 0.933073f, 0.444628f, 3.126577f, 1.265398f, 2.672349f, 0.288673f, 1.641903f, 0.488028f, 1.718761f, 0.584769f, 3.598367f, 1.572860f, 2.690022f,
0.601226f, 1.530944f, 0.157692f, 2.158343f, 0.764935f, 3.482818f, 1.302195f, 4.086316f, 0.724071f, 2.666586f, 0.732218f, 3.831782f, 1.081385f, 4.308592f, 1.739833f, 4.421433f,
0.071701f, 0.164980f, 0.021872f, 0.202831f, 0.159560f, 0.656470f, 0.315911f, 0.671672f, 0.034371f, 0.114380f, 0.040424f, 0.143330f, 0.204855f, 0.737541f, 0.383321f, 0.660017f,
0.179530f, 0.594749f, 0.077903f, 0.808064f, 0.350733f, 2.077579f, 0.987805f, 2.349144f, 0.252216f, 1.208433f, 0.421964f, 1.673473f, 0.482423f, 2.500681f, 1.284099f, 2.473073f,
0.076031f, 0.298493f, 0.035474f, 0.299553f, 0.226506f, 1.590045f, 0.685939f, 1.327971f, 0.130254f, 0.739587f, 0.234318f, 0.756506f, 0.248348f, 1.525595f, 0.710792f, 1.114410f,
0.291484f, 0.740959f, 0.081351f, 1.020729f, 0.574036f, 2.609173f, 1.039840f, 2.991295f, 0.481280f, 1.769414f, 0.517884f, 2.484448f, 0.676533f, 2.690923f, 1.158221f, 2.698261f,
0.414263f, 0.651898f, 0.118333f, 0.990497f, 0.578994f, 1.629154f, 1.073451f, 2.060041f, 0.099684f, 0.226872f, 0.109784f, 0.351349f, 0.950539f, 2.340488f, 1.665534f, 2.588491f,
0.805733f, 1.825515f, 0.327397f, 3.065274f, 0.988619f, 4.005053f, 2.607309f, 5.596701f, 0.568209f, 1.861896f, 0.890183f, 3.186570f, 1.738819f, 6.164275f, 4.334042f, 7.534117f,
0.468855f, 1.258871f, 0.204848f, 1.561320f, 0.877258f, 4.211675f, 2.487722f, 4.347160f, 0.403201f, 1.565731f, 0.679210f, 1.979302f, 1.229933f, 5.167230f, 3.296337f, 4.664821f,
1.200817f, 2.087628f, 0.313828f, 3.554195f, 1.485251f, 4.617012f, 2.519390f, 6.541676f, 0.995269f, 2.502476f, 1.002868f, 4.342522f, 2.238321f, 6.088808f, 3.588340f, 7.545479f,
0.261192f, 0.431811f, 0.069409f, 0.640143f, 0.412163f, 1.218396f, 0.710893f, 1.503183f, 0.059364f, 0.141942f, 0.060823f, 0.214475f, 0.411269f, 1.063882f, 0.670403f, 1.148003f,
0.541738f, 1.289482f, 0.204786f, 2.112558f, 0.750482f, 3.194116f, 1.841324f, 4.354959f, 0.360846f, 1.242226f, 0.525920f, 2.074332f, 0.802280f, 2.988030f, 1.860335f, 3.563237f,
0.094944f, 0.267818f, 0.038591f, 0.324086f, 0.200570f, 1.011640f, 0.529137f, 1.018794f, 0.077119f, 0.314624f, 0.120857f, 0.388057f, 0.170916f, 0.754379f, 0.426146f, 0.664471f,
0.646490f, 1.180782f, 0.157182f, 1.961404f, 0.902812f, 2.948424f, 1.424687f, 4.075938f, 0.506105f, 1.336909f, 0.474429f, 2.263515f, 0.826952f, 2.363316f, 1.233327f, 2.857497f,
0.305503f, 0.615362f, 0.075614f, 0.774580f, 0.467649f, 1.684301f, 0.751253f, 1.764395f, 0.092781f, 0.270289f, 0.088539f, 0.346776f, 0.599548f, 1.889614f, 0.910262f, 1.731313f,
0.890564f, 2.582686f, 0.313550f, 3.592673f, 1.196768f, 6.205851f, 2.734839f, 7.184349f, 0.792647f, 3.324601f, 1.075993f, 4.713784f, 1.643781f, 7.459060f, 3.550107f, 7.552603f,
0.343988f, 1.182222f, 0.130226f, 1.214708f, 0.704920f, 4.331911f, 1.732099f, 3.704183f, 0.373357f, 1.855807f, 0.544961f, 1.943524f, 0.771796f, 4.150415f, 1.792303f, 3.104065f,
0.969457f, 2.157333f, 0.219534f, 3.042758f, 1.313283f, 5.225548f, 1.930245f, 6.133694f, 1.014121f, 3.263862f, 0.885425f, 4.692087f, 1.545574f, 5.381609f, 2.146938f, 5.524956f,
0.142852f, 0.287251f, 0.037623f, 0.353307f, 0.338478f, 1.216992f, 0.578592f, 1.245715f, 0.059480f, 0.172981f, 0.060398f, 0.216857f, 0.361766f, 1.138242f, 0.584448f, 1.019042f,
0.386211f, 1.118121f, 0.144691f, 1.519812f, 0.803354f, 4.158683f, 1.953460f, 4.704322f, 0.471280f, 1.973312f, 0.680744f, 2.733890f, 0.919888f, 4.167084f, 2.114014f, 4.122873f,
0.136925f, 0.469779f, 0.055158f, 0.471652f, 0.434325f, 2.664477f, 1.135595f, 2.226282f, 0.203752f, 1.011037f, 0.316459f, 1.034616f, 0.396435f, 2.128225f, 0.979616f, 1.555293f,
0.568457f, 1.262828f, 0.136977f, 1.740402f, 1.191970f, 4.734741f, 1.864211f, 5.430522f, 0.815265f, 2.619376f, 0.757419f, 3.679487f, 1.169474f, 4.065090f, 1.728605f, 4.077951f,
0.554589f, 0.762678f, 0.136773f, 1.159321f, 0.825300f, 2.029396f, 1.321059f, 2.567258f, 0.115914f, 0.230547f, 0.110219f, 0.357196f, 1.127932f, 2.427095f, 1.706354f, 2.685444f,
1.164692f, 2.306071f, 0.408599f, 3.873875f, 1.521572f, 5.386898f, 3.464642f, 7.530983f, 0.713422f, 2.042966f, 0.964984f, 3.497986f, 2.227887f, 6.902210f, 4.794403f, 8.439710f,
0.567365f, 1.331290f, 0.214023f, 1.651858f, 1.130303f, 4.742307f, 2.767400f, 4.896993f, 0.423803f, 1.438226f, 0.616380f, 1.818909f, 1.319243f, 4.843600f, 3.052652f, 4.374561f,
1.573591f, 2.390758f, 0.355067f, 4.072046f, 2.072326f, 5.629717f, 3.034983f, 7.980014f, 1.132854f, 2.489262f, 0.985553f, 4.321472f, 2.599898f, 6.180641f, 3.598570f, 7.662616f,
0.148224f, 0.194234f, 0.045223f, 0.366227f, 0.140650f, 0.329558f, 0.278525f, 0.517127f, 0.029899f, 0.056666f, 0.035172f, 0.108900f, 0.201111f, 0.412360f, 0.376388f, 0.565937f,
0.136090f, 0.256759f, 0.059064f, 0.535007f, 0.113367f, 0.382447f, 0.319351f, 0.663203f, 0.080452f, 0.219528f, 0.134625f, 0.466239f, 0.173666f, 0.512679f, 0.462348f, 0.777583f,
0.035985f, 0.080458f, 0.016793f, 0.123831f, 0.045713f, 0.182754f, 0.138461f, 0.234083f, 0.025942f, 0.083888f, 0.046677f, 0.131597f, 0.055820f, 0.195286f, 0.159793f, 0.218776f,
0.253532f, 0.367040f, 0.070773f, 0.775448f, 0.212902f, 0.551119f, 0.385738f, 0.969002f, 0.176153f, 0.368829f, 0.189588f, 0.794233f, 0.279449f, 0.633020f, 0.478509f, 0.973470f,
0.154229f, 0.246238f, 0.043827f, 0.394215f, 0.141966f, 0.405281f, 0.261842f, 0.539975f, 0.041571f, 0.095992f, 0.045547f, 0.156637f, 0.260812f, 0.651553f, 0.454631f, 0.759265f,
0.199019f, 0.457482f, 0.080450f, 0.809397f, 0.160824f, 0.661022f, 0.421952f, 0.973292f, 0.157213f, 0.522662f, 0.245024f, 0.942525f, 0.316537f, 1.138513f, 0.784896f, 1.466196f,
0.115983f, 0.315953f, 0.050412f, 0.412892f, 0.142923f, 0.696168f, 0.403203f, 0.757127f, 0.111726f, 0.440185f, 0.187234f, 0.586318f, 0.224235f, 0.955797f, 0.597864f, 0.909173f,
0.338215f, 0.596560f, 0.087934f, 1.070153f, 0.275508f, 0.868922f, 0.464920f, 1.297216f, 0.314002f, 0.801028f, 0.314764f, 1.464615f, 0.464628f, 1.282333f, 0.741011f, 1.674398f,
0.039597f, 0.063112f, 0.011973f, 0.098729f, 0.056418f, 0.160786f, 0.110726f, 0.209325f, 0.014633f, 0.033731f, 0.017060f, 0.053783f, 0.086409f, 0.215495f, 0.160274f, 0.245378f,
0.047389f, 0.108747f, 0.020384f, 0.188001f, 0.059275f, 0.243218f, 0.165486f, 0.349927f, 0.051323f, 0.170334f, 0.085115f, 0.300144f, 0.097261f, 0.349230f, 0.256628f, 0.439461f,
0.025349f, 0.068935f, 0.011724f, 0.088026f, 0.048351f, 0.235110f, 0.145144f, 0.249851f, 0.033478f, 0.131672f, 0.059698f, 0.171375f, 0.063241f, 0.269102f, 0.179421f, 0.250123f,
0.108890f, 0.191737f, 0.030125f, 0.336088f, 0.137299f, 0.432285f, 0.246539f, 0.630604f, 0.138601f, 0.352971f, 0.147841f, 0.630623f, 0.193033f, 0.531844f, 0.327587f, 0.678574f,
0.182021f, 0.198411f, 0.051540f, 0.383592f, 0.162883f, 0.317470f, 0.299347f, 0.510795f, 0.033765f, 0.053231f, 0.036862f, 0.104894f, 0.318996f, 0.544080f, 0.554066f, 0.765655f,
0.169215f, 0.265567f, 0.068158f, 0.567399f, 0.132933f, 0.373037f, 0.347527f, 0.663295f, 0.091993f, 0.208806f, 0.142862f, 0.454716f, 0.278916f, 0.684922f, 0.689135f, 1.065178f,
0.124369f, 0.231310f, 0.053864f, 0.365036f, 0.148989f, 0.495477f, 0.418815f, 0.650736f, 0.082450f, 0.221783f, 0.137679f, 0.356741f, 0.249187f, 0.725173f, 0.662015f, 0.833009f,
0.356907f, 0.429806f, 0.092462f, 0.931087f, 0.282639f, 0.608603f, 0.475249f, 1.097218f, 0.228043f, 0.397179f, 0.227778f, 0.876977f, 0.508125f, 0.957461f, 0.807485f, 1.509754f,
0.243180f, 0.443803f, 0.078449f, 0.636945f, 0.262070f, 0.855195f, 0.548732f, 1.021449f, 0.053193f, 0.140402f, 0.066162f, 0.205384f, 0.413502f, 1.180795f, 0.818269f, 1.233538f,
0.242711f, 0.637741f, 0.111380f, 1.011500f, 0.229626f, 1.078847f, 0.683941f, 1.424038f, 0.155592f, 0.591284f, 0.275292f, 0.955875f, 0.388160f, 1.595875f, 1.092658f, 1.842411f,
0.064376f, 0.200460f, 0.031765f, 0.234842f, 0.092877f, 0.517124f, 0.297451f, 0.504177f, 0.050326f, 0.226644f, 0.095743f, 0.270631f, 0.125148f, 0.609765f, 0.378800f, 0.519968f,
0.436747f, 0.880576f, 0.128908f, 1.416095f, 0.416529f, 1.501645f, 0.797950f, 2.009707f, 0.329060f, 0.959543f, 0.374466f, 1.572803f, 0.603300f, 1.903283f, 1.092292f, 2.227898f,
0.241818f, 0.537692f, 0.072658f, 0.655235f, 0.252798f, 1.005085f, 0.493002f, 1.019311f, 0.070681f, 0.227299f, 0.081881f, 0.282323f, 0.512487f, 1.783038f, 0.944568f, 1.581579f,
0.339213f, 1.085944f, 0.144984f, 1.462451f, 0.311313f, 1.782038f, 0.863628f, 1.997244f, 0.290571f, 1.345367f, 0.478840f, 1.846711f, 0.676138f, 3.386914f, 1.772722f, 3.320051f,
0.198294f, 0.752305f, 0.091132f, 0.748333f, 0.277514f, 1.882584f, 0.827802f, 1.558458f, 0.207136f, 1.136562f, 0.367033f, 1.152334f, 0.480455f, 2.852138f, 1.354471f, 2.065085f,
0.556805f, 1.367794f, 0.153068f, 1.867665f, 0.515125f, 2.262639f, 0.919126f, 2.571186f, 0.560571f, 1.991594f, 0.594155f, 2.771808f, 0.958625f, 3.684681f, 1.616540f, 3.662222f,
0.129822f, 0.288170f, 0.041507f, 0.343137f, 0.210072f, 0.833787f, 0.435932f, 0.826255f, 0.052023f, 0.167014f, 0.064129f, 0.202701f, 0.355035f, 1.233123f, 0.696301f, 1.068789f,
0.168895f, 0.539770f, 0.076814f, 0.710293f, 0.239926f, 1.371058f, 0.708245f, 1.501499f, 0.198352f, 0.916814f, 0.347815f, 1.229687f, 0.434420f, 2.172384f, 1.211968f, 2.080809f,
0.090622f, 0.343220f, 0.044317f, 0.333602f, 0.196311f, 1.329447f, 0.623105f, 1.075393f, 0.129783f, 0.710905f, 0.244704f, 0.704291f, 0.283339f, 1.679117f, 0.849960f, 1.187965f,
0.374849f, 0.919246f, 0.109651f, 1.226493f, 0.536790f, 2.353769f, 1.019159f, 2.613589f, 0.517396f, 1.835064f, 0.583538f, 2.495563f, 0.832787f, 3.195525f, 1.494332f, 3.103431f,
0.308122f, 0.467758f, 0.092249f, 0.688355f, 0.313144f, 0.850016f, 0.608502f, 1.041017f, 0.061980f, 0.136084f, 0.071545f, 0.204118f, 0.676736f, 1.607502f, 1.242834f, 1.721904f,
0.311383f, 0.680590f, 0.132614f, 1.106845f, 0.277816f, 1.085755f, 0.767946f, 1.469510f, 0.183568f, 0.580283f, 0.301424f, 0.961889f, 0.643223f, 2.199812f, 1.680394f, 2.604072f,
0.229565f, 0.594627f, 0.105126f, 0.714287f, 0.312333f, 1.446577f, 0.928331f, 1.446137f, 0.165034f, 0.618251f, 0.291384f, 0.756966f, 0.576438f, 2.336279f, 1.619246f, 2.042768f,
0.634372f, 1.063938f, 0.173768f, 1.754371f, 0.570545f, 1.710989f, 1.014369f, 2.347969f, 0.439533f, 1.066147f, 0.464200f, 1.791868f, 1.131860f, 2.970289f, 1.901841f, 3.565088f,
0.076664f, 0.145030f, 0.023596f, 0.214907f, 0.089293f, 0.302044f, 0.178382f, 0.372482f, 0.019834f, 0.054267f, 0.023537f, 0.081963f, 0.140196f, 0.414989f, 0.264693f, 0.447607f,
0.065137f, 0.177414f, 0.028519f, 0.290531f, 0.066604f, 0.324371f, 0.189272f, 0.442065f, 0.049389f, 0.194553f, 0.083372f, 0.324733f, 0.112033f, 0.477459f, 0.300890f, 0.569124f,
0.019416f, 0.062671f, 0.009141f, 0.075804f, 0.030274f, 0.174730f, 0.092507f, 0.175889f, 0.017952f, 0.083807f, 0.032586f, 0.103322f, 0.040593f, 0.205018f, 0.117226f, 0.180505f,
0.125769f, 0.262853f, 0.035417f, 0.436437f, 0.129636f, 0.484453f, 0.236944f, 0.669423f, 0.112077f, 0.338774f, 0.121687f, 0.573327f, 0.186840f, 0.611004f, 0.322750f, 0.738447f,
0.067357f, 0.155250f, 0.019309f, 0.195334f, 0.076104f, 0.313646f, 0.141602f, 0.328417f, 0.023286f, 0.077624f, 0.025737f, 0.099546f, 0.153522f, 0.553673f, 0.269967f, 0.507069f,
0.080434f, 0.266920f, 0.032801f, 0.371141f, 0.079782f, 0.473401f, 0.211166f, 0.547806f, 0.081493f, 0.391124f, 0.128129f, 0.554313f, 0.172425f, 0.895309f, 0.431315f, 0.906142f,
0.052841f, 0.207807f, 0.023170f, 0.213424f, 0.079926f, 0.562030f, 0.227466f, 0.480378f, 0.065286f, 0.371329f, 0.110371f, 0.388711f, 0.137693f, 0.847290f, 0.370354f, 0.633406f,
0.141670f, 0.360743f, 0.037158f, 0.508580f, 0.141653f, 0.644958f, 0.241144f, 0.756715f, 0.168695f, 0.621266f, 0.170593f, 0.892735f, 0.262311f, 1.045135f, 0.422031f, 1.072506f,
0.035618f, 0.081956f, 0.010865f, 0.100759f, 0.062292f, 0.256287f, 0.123332f, 0.262221f, 0.016882f, 0.056180f, 0.019855f, 0.070399f, 0.104760f, 0.377167f, 0.196024f, 0.337522f,
0.039448f, 0.130682f, 0.017117f, 0.177554f, 0.060565f, 0.358759f, 0.170575f, 0.405653f, 0.054795f, 0.262536f, 0.091673f, 0.363567f, 0.109121f, 0.565640f, 0.290456f, 0.559395f,
0.023786f, 0.093384f, 0.011098f, 0.093716f, 0.055690f, 0.390940f, 0.168650f, 0.326505f, 0.040292f, 0.228777f, 0.072482f, 0.234010f, 0.079983f, 0.491334f, 0.228918f, 0.358907f,
0.093943f, 0.238805f, 0.026219f, 0.328973f, 0.145395f, 0.660868f, 0.263377f, 0.757654f, 0.153366f, 0.563848f, 0.165031f, 0.791704f, 0.224459f, 0.892789f, 0.384273f, 0.895224f,
0.107730f, 0.169527f, 0.030773f, 0.257581f, 0.118330f, 0.332954f, 0.219384f, 0.421015f, 0.025631f, 0.058334f, 0.028228f, 0.090340f, 0.254465f, 0.626563f, 0.445874f, 0.692955f,
0.092680f, 0.209981f, 0.037659f, 0.352585f, 0.089369f, 0.362047f, 0.235694f, 0.505928f, 0.064623f, 0.211755f, 0.101241f, 0.362411f, 0.205896f, 0.729919f, 0.513199f, 0.892124f,
0.076787f, 0.206173f, 0.033549f, 0.255707f, 0.112912f, 0.542085f, 0.320195f, 0.559523f, 0.065291f, 0.253543f, 0.109986f, 0.320513f, 0.207363f, 0.871178f, 0.555751f, 0.786473f,
0.202599f, 0.352220f, 0.052948f, 0.599657f, 0.196935f, 0.612187f, 0.334055f, 0.867385f, 0.166029f, 0.417459f, 0.167297f, 0.724413f, 0.388760f, 1.057527f, 0.623236f, 1.310527f,
0.205142f, 0.339147f, 0.054514f, 0.502772f, 0.254405f, 0.752046f, 0.438793f, 0.927829f, 0.046100f, 0.110227f, 0.047233f, 0.166554f, 0.332520f, 0.860173f, 0.542036f, 0.928187f,
0.188199f, 0.447965f, 0.071142f, 0.733901f, 0.204895f, 0.872049f, 0.502714f, 1.188980f, 0.123946f, 0.426690f, 0.180647f, 0.712508f, 0.286915f, 1.068591f, 0.665301f, 1.274299f,
0.046962f, 0.132472f, 0.019088f, 0.160304f, 0.077967f, 0.393253f, 0.205691f, 0.396034f, 0.037717f, 0.153872f, 0.059107f, 0.189785f, 0.087029f, 0.384124f, 0.216991f, 0.338344f,
0.329425f, 0.601679f, 0.080094f, 0.999453f, 0.361538f, 1.180719f, 0.570527f, 1.632241f, 0.254987f, 0.673565f, 0.239028f, 1.140411f, 0.433784f, 1.239695f, 0.646951f, 1.498921f,
0.230384f, 0.464054f, 0.057022f, 0.584123f, 0.277153f, 0.998204f, 0.445231f, 1.045672f, 0.069180f, 0.201535f, 0.066017f, 0.258565f, 0.465436f, 1.466929f, 0.706646f, 1.344037f,
0.297055f, 0.861478f, 0.104587f, 1.198368f, 0.313721f, 1.626804f, 0.716912f, 1.883308f, 0.261418f, 1.096465f, 0.354866f, 1.554622f, 0.564435f, 2.561264f, 1.219022f, 2.593384f,
0.163370f, 0.561471f, 0.061848f, 0.576900f, 0.263105f, 1.616849f, 0.646491f, 1.382555f, 0.175322f, 0.871453f, 0.255904f, 0.912643f, 0.377337f, 2.029166f, 0.876269f, 1.517599f,
0.474315f, 1.055494f, 0.107409f, 1.488696f, 0.504962f, 2.009241f, 0.742186f, 2.358426f, 0.490582f, 1.578895f, 0.428325f, 2.269799f, 0.778442f, 2.710495f, 1.081325f, 2.782693f,
0.147345f, 0.296285f, 0.038806f, 0.364419f, 0.274373f, 0.986502f, 0.469011f, 1.009786f, 0.060660f, 0.176413f, 0.061596f, 0.221160f, 0.384127f, 1.208597f, 0.620573f, 1.082029f,
0.176201f, 0.510120f, 0.066012f, 0.693383f, 0.288039f, 1.491079f, 0.700406f, 1.686716f, 0.212591f, 0.890147f, 0.307079f, 1.233239f, 0.432032f, 1.957102f, 0.992862f, 1.936338f,
0.088945f, 0.305164f, 0.035830f, 0.306381f, 0.221725f, 1.360232f, 0.579728f, 1.136530f, 0.130865f, 0.649365f, 0.203255f, 0.664510f, 0.265099f, 1.423163f, 0.655078f, 1.040038f,
0.380406f, 0.845072f, 0.091664f, 1.164660f, 0.626869f, 2.490047f, 0.980407f, 2.855965f, 0.539425f, 1.733127f, 0.501151f, 2.434556f, 0.805634f, 2.800385f, 1.190813f, 2.809244f,
0.299455f, 0.411814f, 0.073852f, 0.625985f, 0.350214f, 0.861170f, 0.560589f, 1.089410f, 0.061884f, 0.123084f, 0.058843f, 0.190700f, 0.626962f, 1.349103f, 0.948478f, 1.492706f,
0.278167f, 0.550766f, 0.097587f, 0.925210f, 0.285594f, 1.011102f, 0.650301f, 1.413539f, 0.168471f, 0.482435f, 0.227876f, 0.826029f, 0.547754f, 1.696996f, 1.178765f, 2.075010f,
0.192936f, 0.452713f, 0.072780f, 0.561724f, 0.302070f, 1.267365f, 0.739578f, 1.308705f, 0.142494f, 0.483571f, 0.207244f, 0.611568f, 0.461821f, 1.695574f, 1.068626f, 1.531380f,
0.551256f, 0.837523f, 0.124386f, 1.426506f, 0.570533f, 1.549920f, 0.835562f, 2.196981f, 0.392390f, 0.862213f, 0.341369f, 1.496841f, 0.937595f, 2.228909f, 1.297744f, 2.763350f,
0.098139f, 0.128602f, 0.029942f, 0.242478f, 0.119117f, 0.279104f, 0.235883f, 0.437955f, 0.023328f, 0.044211f, 0.027441f, 0.084965f, 0.146332f, 0.300041f, 0.273867f, 0.411786f,
0.120619f, 0.227570f, 0.052350f, 0.474188f, 0.128525f, 0.433583f, 0.362050f, 0.751878f, 0.084026f, 0.229280f, 0.140605f, 0.486951f, 0.169155f, 0.499365f, 0.450340f, 0.757389f,
0.024852f, 0.055566f, 0.011598f, 0.085520f, 0.040381f, 0.161441f, 0.122313f, 0.206783f, 0.021112f, 0.068269f, 0.037986f, 0.107095f, 0.042365f, 0.148214f, 0.121276f, 0.166042f,
0.234516f, 0.339511f, 0.065464f, 0.717287f, 0.251901f, 0.652073f, 0.456396f, 1.146502f, 0.192007f, 0.402023f, 0.206651f, 0.865714f, 0.284069f, 0.643485f, 0.486420f, 0.989564f,
0.138245f, 0.220718f, 0.039285f, 0.353358f, 0.162770f, 0.464674f, 0.300215f, 0.619107f, 0.043910f, 0.101391f, 0.048109f, 0.165448f, 0.256916f, 0.641819f, 0.447840f, 0.747923f,
0.238806f, 0.548939f, 0.096533f, 0.971207f, 0.246837f, 1.014555f, 0.647624f, 1.493836f, 0.222292f, 0.739022f, 0.346453f, 1.332689f, 0.417403f, 1.501306f, 1.035007f, 1.933406f,
0.108440f, 0.295405f, 0.047134f, 0.386040f, 0.170926f, 0.832569f, 0.482203f, 0.905471f, 0.123094f, 0.484972f, 0.206284f, 0.645975f, 0.230399f, 0.982071f, 0.614299f, 0.934165f,
0.423537f, 0.747057f, 0.110117f, 1.340125f, 0.441309f, 1.391842f, 0.744710f, 2.077886f, 0.463360f, 1.182044f, 0.464484f, 2.161271f, 0.639419f, 1.764742f, 1.019777f, 2.304301f,
0.030338f, 0.048354f, 0.009174f, 0.075643f, 0.055291f, 0.157574f, 0.108514f, 0.205143f, 0.013211f, 0.030454f, 0.015402f, 0.048557f, 0.072755f, 0.181444f, 0.134949f, 0.206605f,
0.048604f, 0.111534f, 0.020906f, 0.192820f, 0.077763f, 0.319078f, 0.217101f, 0.459071f, 0.062028f, 0.205864f, 0.102869f, 0.362750f, 0.109626f, 0.393627f, 0.289252f, 0.495329f,
0.020258f, 0.055091f, 0.009369f, 0.070348f, 0.049425f, 0.240337f, 0.148371f, 0.255405f, 0.031527f, 0.123999f, 0.056219f, 0.161388f, 0.055541f, 0.236340f, 0.157576f, 0.219671f,
0.116554f, 0.205233f, 0.032245f, 0.359745f, 0.187982f, 0.591864f, 0.337549f, 0.863393f, 0.174821f, 0.445212f, 0.186476f, 0.795422f, 0.227067f, 0.625614f, 0.385344f, 0.798215f,
0.223295f, 0.243401f, 0.063226f, 0.470572f, 0.255588f, 0.498160f, 0.469723f, 0.801518f, 0.048810f, 0.076950f, 0.053287f, 0.151633f, 0.430054f, 0.733500f, 0.746963f, 1.032216f,
0.277884f, 0.436113f, 0.111928f, 0.931779f, 0.279233f, 0.783586f, 0.730000f, 1.393288f, 0.178018f, 0.404066f, 0.276458f, 0.879935f, 0.503360f, 1.236081f, 1.243684f, 1.922328f,
0.159141f, 0.295982f, 0.068924f, 0.467096f, 0.243857f, 0.810968f, 0.685492f, 1.065086f, 0.124322f, 0.334414f, 0.207598f, 0.537910f, 0.350410f, 1.019749f, 0.930934f, 1.171388f,
0.611686f, 0.736624f, 0.158466f, 1.595747f, 0.619607f, 1.334192f, 1.041849f, 2.405341f, 0.460549f, 0.802132f, 0.460015f, 1.771122f, 0.957030f, 1.803334f, 1.520860f, 2.843551f,
0.172318f, 0.314480f, 0.055590f, 0.451341f, 0.237537f, 0.775138f, 0.497363f, 0.925828f, 0.044417f, 0.117236f, 0.055245f, 0.171497f, 0.322005f, 0.919516f, 0.637207f, 0.960588f,
0.230230f, 0.604945f, 0.105652f, 0.959483f, 0.278614f, 1.309005f, 0.829851f, 1.727837f, 0.173919f, 0.660927f, 0.307717f, 1.068461f, 0.404635f, 1.663608f, 1.139034f, 1.920609f,
0.047582f, 0.148165f, 0.023479f, 0.173577f, 0.087808f, 0.488902f, 0.281218f, 0.476661f, 0.043832f, 0.197401f, 0.083389f, 0.235712f, 0.101654f, 0.495291f, 0.307687f, 0.422353f,
0.432365f, 0.871741f, 0.127615f, 1.401887f, 0.527444f, 1.901507f, 1.010431f, 2.544857f, 0.383868f, 1.119365f, 0.436837f, 1.834768f, 0.656350f, 2.070643f, 1.188340f, 2.423803f,
0.231981f, 0.515818f, 0.069702f, 0.628579f, 0.310204f, 1.233319f, 0.604952f, 1.250776f, 0.079901f, 0.256949f, 0.092562f, 0.319150f, 0.540290f, 1.879769f, 0.995811f, 1.667381f,
0.435615f, 1.394561f, 0.186188f, 1.878070f, 0.511372f, 2.927234f, 1.418623f, 3.280738f, 0.439713f, 2.035905f, 0.724614f, 2.794575f, 0.954217f, 4.779866f, 2.501798f, 4.685504f,
0.198420f, 0.752783f, 0.091190f, 0.748809f, 0.355199f, 2.409576f, 1.059529f, 1.994718f, 0.244241f, 1.340158f, 0.432781f, 1.358754f, 0.528337f, 3.136376f, 1.489454f, 2.270887f,
0.746247f, 1.833160f, 0.205147f, 2.503103f, 0.883086f, 3.878869f, 1.575669f, 4.407816f, 0.885312f, 3.145336f, 0.938353f, 4.377531f, 1.411920f, 5.427014f, 2.380935f, 5.393935f,
0.106451f, 0.236294f, 0.034035f, 0.281366f, 0.220335f, 0.874520f, 0.457229f, 0.866620f, 0.050268f, 0.161377f, 0.061965f, 0.195860f, 0.319932f, 1.111200f, 0.627455f, 0.963114f,
0.185391f, 0.592490f, 0.084317f, 0.779669f, 0.336869f, 1.925033f, 0.994411f, 2.108178f, 0.256563f, 1.185878f, 0.449891f, 1.590572f, 0.524039f, 2.620536f, 1.461991f, 2.510069f,
0.077509f, 0.293556f, 0.037904f, 0.285330f, 0.214770f, 1.454451f, 0.681695f, 1.176509f, 0.130804f, 0.716500f, 0.246630f, 0.709833f, 0.266321f, 1.578267f, 0.798910f, 1.116614f,
0.429416f, 1.053061f, 0.125613f, 1.405034f, 0.786567f, 3.449020f, 1.493392f, 3.829738f, 0.698444f, 2.477190f, 0.787729f, 3.368811f, 1.048424f, 4.022955f, 1.881265f, 3.907014f,
0.404538f, 0.614127f, 0.121115f, 0.903752f, 0.525885f, 1.427494f, 1.021901f, 1.748256f, 0.095891f, 0.210538f, 0.110689f, 0.315794f, 0.976422f, 2.319369f, 1.793211f, 2.484432f,
0.547268f, 1.196163f, 0.233074f, 1.945321f, 0.624556f, 2.440880f, 1.726415f, 3.303600f, 0.380178f, 1.201796f, 0.624265f, 1.992121f, 1.242361f, 4.248851f, 3.245615f, 5.029663f,
0.314381f, 0.814321f, 0.143966f, 0.978190f, 0.547115f, 2.533975f, 1.626162f, 2.533204f, 0.266324f, 0.997704f, 0.470222f, 1.221557f, 0.867530f, 3.516062f, 2.436939f, 3.074332f,
1.163585f, 1.951509f, 0.318731f, 3.217923f, 1.338611f, 4.014316f, 2.379909f, 5.508795f, 0.950019f, 2.304398f, 1.003335f, 3.872992f, 2.281540f, 5.987342f, 3.833626f, 7.186304f,
0.089752f, 0.169789f, 0.027625f, 0.251597f, 0.133716f, 0.452308f, 0.267125f, 0.557787f, 0.027363f, 0.074865f, 0.032471f, 0.113072f, 0.180372f, 0.533913f, 0.340547f, 0.575879f,
0.102082f, 0.278041f, 0.044695f, 0.455316f, 0.133515f, 0.650238f, 0.379417f, 0.886169f, 0.091208f, 0.359290f, 0.153967f, 0.599699f, 0.192951f, 0.822315f, 0.518214f, 0.980187f,
0.023710f, 0.076530f, 0.011162f, 0.092568f, 0.047288f, 0.272926f, 0.144495f, 0.274736f, 0.025833f, 0.120596f, 0.046890f, 0.148678f, 0.054475f, 0.275131f, 0.157316f, 0.242236f,
0.205704f, 0.429916f, 0.057927f, 0.713826f, 0.271211f, 1.013520f, 0.495709f, 1.400493f, 0.216010f, 0.652930f, 0.234531f, 1.104992f, 0.335832f, 1.098237f, 0.580119f, 1.327306f,
0.106757f, 0.246062f, 0.030604f, 0.309593f, 0.154287f, 0.635860f, 0.287073f, 0.665807f, 0.043490f, 0.144975f, 0.048069f, 0.185919f, 0.267402f, 0.964377f, 0.470224f, 0.883202f,
0.170656f, 0.566319f, 0.069592f, 0.787442f, 0.216519f, 1.284753f, 0.573079f, 1.486677f, 0.203745f, 0.977868f, 0.320343f, 1.385866f, 0.402033f, 2.087537f, 1.005672f, 2.112797f,
0.087357f, 0.343547f, 0.038304f, 0.352834f, 0.169014f, 1.188490f, 0.481009f, 1.015826f, 0.127183f, 0.723388f, 0.215015f, 0.757250f, 0.250160f, 1.539356f, 0.672859f, 1.150773f,
0.313694f, 0.798781f, 0.082277f, 1.126131f, 0.401203f, 1.826716f, 0.682993f, 2.143247f, 0.440168f, 1.621038f, 0.445121f, 2.329370f, 0.638305f, 2.543214f, 1.026964f, 2.609820f,
0.048254f, 0.111029f, 0.014719f, 0.136501f, 0.107944f, 0.444110f, 0.213717f, 0.454394f, 0.026950f, 0.089686f, 0.031697f, 0.112385f, 0.155966f, 0.561525f, 0.291840f, 0.502502f,
0.071539f, 0.236995f, 0.031043f, 0.321997f, 0.140493f, 0.832214f, 0.395684f, 0.940994f, 0.117097f, 0.561044f, 0.195907f, 0.776951f, 0.217477f, 1.127309f, 0.578873f, 1.114863f,
0.033612f, 0.131960f, 0.015683f, 0.132428f, 0.100660f, 0.706624f, 0.304835f, 0.590157f, 0.067092f, 0.380948f, 0.120693f, 0.389663f, 0.124207f, 0.763003f, 0.355491f, 0.557354f,
0.177802f, 0.451976f, 0.049623f, 0.622633f, 0.351992f, 1.599912f, 0.637617f, 1.834224f, 0.342049f, 1.257535f, 0.368064f, 1.765714f, 0.466863f, 1.856957f, 0.799268f, 1.862021f,
0.233681f, 0.367728f, 0.066750f, 0.558728f, 0.328317f, 0.923807f, 0.608697f, 1.168140f, 0.065515f, 0.149107f, 0.072153f, 0.230916f, 0.606592f, 1.493595f, 1.062870f, 1.651859f,
0.269117f, 0.609726f, 0.109351f, 1.023808f, 0.331933f, 1.344712f, 0.875414f, 1.879114f, 0.221119f, 0.724560f, 0.346416f, 1.240058f, 0.657026f, 2.329220f, 1.637652f, 2.846826f,
0.173736f, 0.466479f, 0.075907f, 0.578553f, 0.326776f, 1.568837f, 0.926669f, 1.619305f, 0.174077f, 0.675986f, 0.293241f, 0.854540f, 0.515599f, 2.166149f, 1.381853f, 1.955534f,
0.613963f, 1.067378f, 0.160457f, 1.817216f, 0.763373f, 2.373001f, 1.294888f, 3.362219f, 0.592891f, 1.490748f, 0.597418f, 2.586881f, 1.294693f, 3.521897f, 2.075572f, 4.364466f,
0.108339f, 0.179110f, 0.028790f, 0.265523f, 0.171857f, 0.508026f, 0.296416f, 0.626772f, 0.028689f, 0.068597f, 0.029394f, 0.103651f, 0.192988f, 0.499227f, 0.314587f, 0.538702f,
0.133051f, 0.316696f, 0.050295f, 0.518844f, 0.185285f, 0.788588f, 0.454601f, 1.075186f, 0.103257f, 0.355466f, 0.150493f, 0.593575f, 0.222912f, 0.830218f, 0.516890f, 0.990038f,
0.025870f, 0.072974f, 0.010515f, 0.088306f, 0.054937f, 0.277094f, 0.144934f, 0.279054f, 0.024483f, 0.099883f, 0.038368f, 0.123195f, 0.052685f, 0.232540f, 0.131361f, 0.204826f,
0.243056f, 0.443929f, 0.059095f, 0.737413f, 0.341203f, 1.114309f, 0.538437f, 1.540434f, 0.221694f, 0.585619f, 0.207818f, 0.991508f, 0.351725f, 1.005182f, 0.524567f, 1.215371f,
0.164719f, 0.331787f, 0.040769f, 0.417633f, 0.253466f, 0.912894f, 0.407180f, 0.956304f, 0.058285f, 0.169796f, 0.055620f, 0.217845f, 0.365706f, 1.152606f, 0.555232f, 1.056047f,
0.284312f, 0.824522f, 0.100101f, 1.146961f, 0.384072f, 1.991608f, 0.877676f, 2.305631f, 0.294836f, 1.236629f, 0.400230f, 1.753354f, 0.593682f, 2.693978f, 1.282187f, 2.727762f,
0.121836f, 0.418728f, 0.046124f, 0.430234f, 0.250983f, 1.542353f, 0.616704f, 1.318854f, 0.154073f, 0.765834f, 0.224888f, 0.802032f, 0.309253f, 1.663042f, 0.718163f, 1.243777f,
0.473778f, 1.054299f, 0.107287f, 1.487010f, 0.645173f, 2.567143f, 0.948267f, 3.013286f, 0.577438f, 1.858435f, 0.504159f, 2.671663f, 0.854507f, 2.975348f, 1.186985f, 3.054601f,
0.090047f, 0.181068f, 0.023715f, 0.222707f, 0.214478f, 0.771154f, 0.366628f, 0.789354f, 0.043684f, 0.127043f, 0.044358f, 0.159267f, 0.257982f, 0.811700f, 0.416780f, 0.726696f,
0.144148f, 0.417323f, 0.054004f, 0.567249f, 0.301413f, 1.560311f, 0.732926f, 1.765031f, 0.204942f, 0.858121f, 0.296031f, 1.188869f, 0.388416f, 1.759524f, 0.892628f, 1.740856f,
0.056698f, 0.194527f, 0.022840f, 0.195302f, 0.180789f, 1.109096f, 0.472695f, 0.926696f, 0.098301f, 0.487777f, 0.152677f, 0.499153f, 0.185710f, 0.996970f, 0.458903f, 0.728579f,
0.324786f, 0.721512f, 0.078261f, 0.994372f, 0.684599f, 2.719365f, 1.070696f, 3.118982f, 0.542709f, 1.743679f, 0.504202f, 2.449379f, 0.755908f, 2.627537f, 1.117312f, 2.635850f,
0.293019f, 0.402964f, 0.072265f, 0.612533f, 0.438338f, 1.077864f, 0.701648f, 1.363536f, 0.071356f, 0.141924f, 0.067850f, 0.219888f, 0.674198f, 1.450746f, 1.019938f, 1.605168f,
0.364367f, 0.721440f, 0.127828f, 1.211918f, 0.478511f, 1.694096f, 1.089576f, 2.368377f, 0.260042f, 0.744660f, 0.351736f, 1.275013f, 0.788497f, 2.442839f, 1.696841f, 2.986993f,
0.196921f, 0.462064f, 0.074283f, 0.573326f, 0.394363f, 1.654591f, 0.965546f, 1.708561f, 0.171381f, 0.581602f, 0.249257f, 0.735545f, 0.518004f, 1.901852f, 1.198632f, 1.717683f,
0.753590f, 1.144930f, 0.170041f, 1.950096f, 0.997638f, 2.710201f, 1.461071f, 3.841658f, 0.632101f, 1.388939f, 0.549911f, 2.411261f, 1.408571f, 3.348543f, 1.949631f, 4.151447f,
0.051926f, 0.068044f, 0.015843f, 0.128296f, 0.058398f, 0.136833f, 0.115644f, 0.214711f, 0.011538f, 0.021868f, 0.013573f, 0.042026f, 0.076876f, 0.157627f, 0.143876f, 0.216333f,
0.065544f, 0.123661f, 0.028447f, 0.257672f, 0.064713f, 0.218310f, 0.182293f, 0.378572f, 0.042684f, 0.116472f, 0.071426f, 0.247366f, 0.091267f, 0.269429f, 0.242978f, 0.408644f,
0.015784f, 0.035291f, 0.007366f, 0.054316f, 0.023764f, 0.095007f, 0.071980f, 0.121690f, 0.012535f, 0.040534f, 0.022554f, 0.063586f, 0.026716f, 0.093466f, 0.076479f, 0.104709f,
0.112837f, 0.163356f, 0.031498f, 0.345122f, 0.112304f, 0.290710f, 0.203473f, 0.511139f, 0.086364f, 0.180829f, 0.092951f, 0.389396f, 0.135710f, 0.307417f, 0.232381f, 0.472752f,
0.073907f, 0.117998f, 0.021002f, 0.188909f, 0.080630f, 0.230181f, 0.148714f, 0.306681f, 0.021945f, 0.050673f, 0.024044f, 0.082687f, 0.136376f, 0.340690f, 0.237722f, 0.397012f,
0.131117f, 0.301396f, 0.053002f, 0.533243f, 0.125577f, 0.516146f, 0.329473f, 0.759977f, 0.114097f, 0.379322f, 0.177826f, 0.684037f, 0.227551f, 0.818449f, 0.564242f, 1.054012f,
0.069589f, 0.189571f, 0.030247f, 0.247734f, 0.101635f, 0.495059f, 0.286726f, 0.538408f, 0.073846f, 0.290943f, 0.123753f, 0.387531f, 0.146806f, 0.625756f, 0.391419f, 0.595232f,
0.205906f, 0.363187f, 0.053534f, 0.651511f, 0.198794f, 0.626976f, 0.335466f, 0.936014f, 0.210588f, 0.537214f, 0.211098f, 0.982253f, 0.308654f, 0.851857f, 0.492256f, 1.112308f,
0.017654f, 0.028137f, 0.005338f, 0.044017f, 0.029812f, 0.084961f, 0.058508f, 0.110609f, 0.007187f, 0.016566f, 0.008379f, 0.026414f, 0.042036f, 0.104834f, 0.077970f, 0.119371f,
0.029047f, 0.066655f, 0.012494f, 0.115233f, 0.043061f, 0.176688f, 0.120219f, 0.254208f, 0.034654f, 0.115012f, 0.057471f, 0.202661f, 0.065050f, 0.233571f, 0.171637f, 0.293920f,
0.014150f, 0.038481f, 0.006545f, 0.049138f, 0.031989f, 0.155550f, 0.096028f, 0.165302f, 0.020587f, 0.080970f, 0.036710f, 0.105384f, 0.038520f, 0.163912f, 0.109286f, 0.152352f,
0.061676f, 0.108602f, 0.017063f, 0.190363f, 0.092170f, 0.290198f, 0.165505f, 0.423332f, 0.086481f, 0.220239f, 0.092246f, 0.393481f, 0.119303f, 0.328704f, 0.202463f, 0.419390f,
0.101837f, 0.111007f, 0.028836f, 0.214613f, 0.108008f, 0.210515f, 0.198497f, 0.338709f, 0.020810f, 0.032807f, 0.022719f, 0.064649f, 0.194743f, 0.332153f, 0.338250f, 0.467422f,
0.130158f, 0.204270f, 0.052426f, 0.436434f, 0.121187f, 0.340076f, 0.316819f, 0.604686f, 0.077948f, 0.176927f, 0.121052f, 0.385295f, 0.234095f, 0.574859f, 0.578395f, 0.894009f,
0.087122f, 0.162035f, 0.037732f, 0.255712f, 0.123699f, 0.411370f, 0.347722f, 0.540274f, 0.063625f, 0.171146f, 0.106244f, 0.275291f, 0.190472f, 0.554303f, 0.506026f, 0.636729f,
0.253686f, 0.305502f, 0.065721f, 0.661809f, 0.238105f, 0.512709f, 0.400366f, 0.924334f, 0.178559f, 0.310994f, 0.178352f, 0.686680f, 0.394097f, 0.742598f, 0.626277f, 1.170950f,
0.080074f, 0.146134f, 0.025832f, 0.209731f, 0.102276f, 0.333750f, 0.214149f, 0.398632f, 0.019295f, 0.050928f, 0.023999f, 0.074499f, 0.148570f, 0.424254f, 0.294000f, 0.443205f,
0.109874f, 0.288702f, 0.050421f, 0.457901f, 0.123203f, 0.578841f, 0.366959f, 0.764048f, 0.077592f, 0.294866f, 0.137285f, 0.476684f, 0.191737f, 0.788305f, 0.539734f, 0.910085f,
0.026541f, 0.082645f, 0.013096f, 0.096821f, 0.045383f, 0.252685f, 0.145345f, 0.246359f, 0.022856f, 0.102934f, 0.043483f, 0.122912f, 0.056300f, 0.274311f, 0.170409f, 0.233915f,
0.182704f, 0.368370f, 0.053926f, 0.592394f, 0.206518f, 0.744525f, 0.395629f, 0.996425f, 0.151641f, 0.442187f, 0.172566f, 0.724796f, 0.275386f, 0.868783f, 0.498594f, 1.016959f,
0.108920f, 0.242187f, 0.032727f, 0.295131f, 0.134954f, 0.536555f, 0.263184f, 0.544149f, 0.035070f, 0.112782f, 0.040628f, 0.140083f, 0.251878f, 0.876331f, 0.464238f, 0.777317f,
0.210055f, 0.672463f, 0.089781f, 0.905613f, 0.228482f, 1.307892f, 0.633843f, 1.465838f, 0.198215f, 0.917753f, 0.326644f, 1.259748f, 0.456864f, 2.288524f, 1.197821f, 2.243344f,
0.111829f, 0.424268f, 0.051395f, 0.422028f, 0.185492f, 1.258331f, 0.553308f, 1.041684f, 0.128685f, 0.706096f, 0.228021f, 0.715894f, 0.295658f, 1.755123f, 0.833502f, 1.270793f,
0.318623f, 0.782698f, 0.087591f, 1.068741f, 0.349366f, 1.534556f, 0.623365f, 1.743818f, 0.353368f, 1.255447f, 0.374539f, 1.747272f, 0.598567f, 2.300720f, 1.009370f, 2.286696f,
0.054402f, 0.120759f, 0.017394f, 0.143793f, 0.104336f, 0.414114f, 0.216513f, 0.410374f, 0.024016f, 0.077099f, 0.029604f, 0.093573f, 0.162343f, 0.563856f, 0.318390f, 0.488713f,
0.097304f, 0.310974f, 0.044254f, 0.409217f, 0.163828f, 0.936192f, 0.483608f, 1.025261f, 0.125885f, 0.581863f, 0.220744f, 0.780430f, 0.273096f, 1.365659f, 0.761898f, 1.308091f,
0.047548f, 0.180084f, 0.023252f, 0.175037f, 0.122079f, 0.826734f, 0.387487f, 0.668747f, 0.075014f, 0.410900f, 0.141438f, 0.407077f, 0.162217f, 0.961329f, 0.486620f, 0.680134f,
0.199565f, 0.489395f, 0.058377f, 0.652970f, 0.338709f, 1.485203f, 0.643078f, 1.649146f, 0.303441f, 1.076225f, 0.342232f, 1.463593f, 0.483785f, 1.856352f, 0.868091f, 1.802853f,
0.162034f, 0.245983f, 0.048511f, 0.361989f, 0.195173f, 0.529791f, 0.379262f, 0.648837f, 0.035906f, 0.078834f, 0.041446f, 0.118247f, 0.388323f, 0.922412f, 0.713159f, 0.988058f,
0.225125f, 0.492054f, 0.095877f, 0.800228f, 0.238055f, 0.930364f, 0.658039f, 1.259197f, 0.146200f, 0.462158f, 0.240065f, 0.766083f, 0.507434f, 1.735413f, 1.325649f, 2.054330f,
0.151154f, 0.391523f, 0.069219f, 0.470311f, 0.243739f, 1.128882f, 0.724452f, 1.128538f, 0.119704f, 0.448437f, 0.211350f, 0.549052f, 0.414148f, 1.678525f, 1.163365f, 1.467648f,
0.423822f, 0.710814f, 0.116094f, 1.172091f, 0.451777f, 1.354818f, 0.803211f, 1.859200f, 0.323486f, 0.784658f, 0.341640f, 1.318772f, 0.825131f, 2.165352f, 1.386450f, 2.598963f,
0.050636f, 0.095791f, 0.015585f, 0.141945f, 0.069901f, 0.236447f, 0.139641f, 0.291587f, 0.014431f, 0.039485f, 0.017126f, 0.059636f, 0.101040f, 0.299086f, 0.190767f, 0.322594f,
0.059148f, 0.161102f, 0.025897f, 0.263818f, 0.071681f, 0.349099f, 0.203701f, 0.475765f, 0.049404f, 0.194614f, 0.083398f, 0.324835f, 0.111006f, 0.473085f, 0.298133f, 0.563910f,
0.016057f, 0.051828f, 0.007559f, 0.062689f, 0.029674f, 0.171262f, 0.090671f, 0.172398f, 0.016355f, 0.076349f, 0.029686f, 0.094128f, 0.036630f, 0.185004f, 0.105783f, 0.162884f,
0.105535f, 0.220566f, 0.029719f, 0.366224f, 0.128928f, 0.481805f, 0.235649f, 0.665763f, 0.103601f, 0.313155f, 0.112485f, 0.529971f, 0.171075f, 0.559448f, 0.295516f, 0.676137f,
0.060857f, 0.140267f, 0.017446f, 0.176483f, 0.081494f, 0.335860f, 0.151631f, 0.351678f, 0.023176f, 0.077258f, 0.025616f, 0.099077f, 0.151351f, 0.545844f, 0.266150f, 0.499898f,
0.099910f, 0.331551f, 0.040743f, 0.461006f, 0.117454f, 0.696934f, 0.310876f, 0.806471f, 0.111510f, 0.535188f, 0.175324f, 0.758485f, 0.233700f, 1.213477f, 0.584593f, 1.228160f,
0.059776f, 0.235079f, 0.026211f, 0.241434f, 0.107161f, 0.753542f, 0.304976f, 0.644067f, 0.081357f, 0.462740f, 0.137542f, 0.484401f, 0.169963f, 1.045867f, 0.457152f, 0.781856f,
0.162614f, 0.414075f, 0.042651f, 0.583768f, 0.192708f, 0.877417f, 0.328059f, 1.029455f, 0.213308f, 0.785565f, 0.215708f, 1.128827f, 0.328540f, 1.309012f, 0.528586f, 1.343294f,
0.029940f, 0.068891f, 0.009133f, 0.084696f, 0.062060f, 0.255328f, 0.122871f, 0.261241f, 0.015632f, 0.052022f, 0.018385f, 0.065189f, 0.096087f, 0.345942f, 0.179796f, 0.309579f,
0.045587f, 0.151022f, 0.019781f, 0.205188f, 0.082954f, 0.491382f, 0.233632f, 0.555612f, 0.069757f, 0.334222f, 0.116705f, 0.462841f, 0.137601f, 0.713268f, 0.366263f, 0.705394f,
0.025034f, 0.098284f, 0.011681f, 0.098633f, 0.069468f, 0.487655f, 0.210373f, 0.407279f, 0.046714f, 0.265243f, 0.084035f, 0.271311f, 0.091854f, 0.564255f, 0.262893f, 0.412174f,
0.100323f, 0.255023f, 0.027999f, 0.351314f, 0.184026f, 0.836457f, 0.333355f, 0.958959f, 0.180422f, 0.663318f, 0.194144f, 0.931369f, 0.261555f, 1.040338f, 0.447780f, 1.043176f,
0.113639f, 0.178826f, 0.032461f, 0.271709f, 0.147939f, 0.416264f, 0.274277f, 0.526360f, 0.029784f, 0.067786f, 0.032802f, 0.104978f, 0.292893f, 0.721184f, 0.513208f, 0.797602f,
0.134407f, 0.304519f, 0.054614f, 0.511327f, 0.153608f, 0.622291f, 0.405114f, 0.869595f, 0.103239f, 0.338292f, 0.161739f, 0.578975f, 0.325816f, 1.155047f, 0.812102f, 1.411725f,
0.101417f, 0.272303f, 0.044310f, 0.337725f, 0.176748f, 0.848558f, 0.501220f, 0.875855f, 0.094995f, 0.368888f, 0.160023f, 0.466326f, 0.298841f, 1.255501f, 0.800923f, 1.133429f,
0.271510f, 0.472021f, 0.070958f, 0.803618f, 0.312798f, 0.972355f, 0.530590f, 1.377695f, 0.245107f, 0.616290f, 0.246978f, 1.069442f, 0.568485f, 1.546425f, 0.911360f, 1.916388f,
0.063276f, 0.104611f, 0.016815f, 0.155082f, 0.093005f, 0.274933f, 0.160414f, 0.339196f, 0.015664f, 0.037454f, 0.016049f, 0.056594f, 0.111917f, 0.289511f, 0.182434f, 0.312402f,
0.079809f, 0.189966f, 0.030169f, 0.311222f, 0.102981f, 0.438296f, 0.252666f, 0.597587f, 0.057902f, 0.199328f, 0.084389f, 0.332848f, 0.132762f, 0.494464f, 0.307851f, 0.589650f,
0.018137f, 0.051161f, 0.007372f, 0.061910f, 0.035688f, 0.180005f, 0.094151f, 0.181278f, 0.016046f, 0.065464f, 0.025147f, 0.080743f, 0.036675f, 0.161875f, 0.091443f, 0.142583f,
0.129093f, 0.235782f, 0.031387f, 0.391658f, 0.167916f, 0.548385f, 0.264981f, 0.758094f, 0.110075f, 0.290769f, 0.103185f, 0.492300f, 0.185485f, 0.530091f, 0.276635f, 0.640935f,
0.097207f, 0.195800f, 0.024059f, 0.246461f, 0.138598f, 0.499181f, 0.222651f, 0.522918f, 0.032155f, 0.093674f, 0.030685f, 0.120182f, 0.214286f, 0.675373f, 0.325339f, 0.618794f,
0.172316f, 0.499726f, 0.060669f, 0.695149f, 0.215688f, 1.118452f, 0.492887f, 1.294802f, 0.167050f, 0.700659f, 0.226765f, 0.993429f, 0.357267f, 1.621185f, 0.771596f, 1.641516f,
0.086307f, 0.296620f, 0.032674f, 0.304771f, 0.164739f, 1.012365f, 0.404790f, 0.865665f, 0.102031f, 0.507156f, 0.148927f, 0.531127f, 0.217517f, 1.169719f, 0.505128f, 0.874825f,
0.254254f, 0.565792f, 0.057576f, 0.798007f, 0.320814f, 1.276517f, 0.471528f, 1.498363f, 0.289692f, 0.932347f, 0.252929f, 1.340331f, 0.455321f, 1.585402f, 0.632480f, 1.627632f,
0.057841f, 0.116308f, 0.015233f, 0.143054f, 0.127654f, 0.458977f, 0.218210f, 0.469809f, 0.026232f, 0.076287f, 0.026637f, 0.095637f, 0.164537f, 0.517691f, 0.265816f, 0.463477f,
0.095093f, 0.275305f, 0.035626f, 0.374210f, 0.184242f, 0.953756f, 0.448008f, 1.078893f, 0.126389f, 0.529210f, 0.182565f, 0.733185f, 0.254418f, 1.152514f, 0.584685f, 1.140286f,
0.043717f, 0.149990f, 0.017611f, 0.150588f, 0.129163f, 0.792383f, 0.337712f, 0.662069f, 0.070856f, 0.351594f, 0.110050f, 0.359793f, 0.142176f, 0.763261f, 0.351327f, 0.557786f,
0.189715f, 0.421453f, 0.045714f, 0.580837f, 0.370532f, 1.471826f, 0.579503f, 1.688114f, 0.296353f, 0.952158f, 0.275326f, 1.337515f, 0.438413f, 1.523923f, 0.648020f, 1.528744f,
0.147517f, 0.202867f, 0.036381f, 0.308372f, 0.204474f, 0.502798f, 0.327302f, 0.636057f, 0.033583f, 0.066794f, 0.031932f, 0.103487f, 0.337009f, 0.725180f, 0.509833f, 0.802370f,
0.188391f, 0.373011f, 0.066092f, 0.626606f, 0.229243f, 0.811602f, 0.521991f, 1.134635f, 0.125690f, 0.359929f, 0.170011f, 0.616274f, 0.404790f, 1.254080f, 0.871107f, 1.533432f,
0.119002f, 0.279231f, 0.044890f, 0.346468f, 0.220821f, 0.926479f, 0.540652f, 0.956699f, 0.096819f, 0.328567f, 0.140814f, 0.415535f, 0.310816f, 1.141161f, 0.719210f, 1.030655f,
0.345001f, 0.524160f, 0.077846f, 0.892772f, 0.423196f, 1.149661f, 0.619783f, 1.629622f, 0.270526f, 0.594436f, 0.235350f, 1.031968f, 0.640283f, 1.522122f, 0.886229f, 1.887091f,
0.154099f, 0.201933f, 0.047016f, 0.380743f, 0.186063f, 0.435966f, 0.368455f, 0.684096f, 0.031438f, 0.059583f, 0.036982f, 0.114506f, 0.203105f, 0.416448f, 0.380119f, 0.571547f,
0.219396f, 0.413931f, 0.095220f, 0.862508f, 0.232557f, 0.784538f, 0.655104f, 1.360469f, 0.131177f, 0.357940f, 0.219506f, 0.760202f, 0.271969f, 0.802882f, 0.724060f, 1.217735f,
0.047430f, 0.106048f, 0.022134f, 0.163217f, 0.076667f, 0.306507f, 0.232219f, 0.392592f, 0.034582f, 0.111828f, 0.062223f, 0.175427f, 0.071470f, 0.250038f, 0.204594f, 0.280114f,
0.373326f, 0.540467f, 0.104213f, 1.141849f, 0.398909f, 1.032619f, 0.722747f, 1.815595f, 0.262340f, 0.549285f, 0.282347f, 1.182826f, 0.399724f, 0.905473f, 0.684460f, 1.392453f,
0.171962f, 0.274549f, 0.048866f, 0.439539f, 0.201412f, 0.574989f, 0.371486f, 0.766084f, 0.046878f, 0.108247f, 0.051361f, 0.176635f, 0.282484f, 0.705694f, 0.492409f, 0.822356f,
0.344097f, 0.790970f, 0.139095f, 1.399419f, 0.353814f, 1.454253f, 0.928297f, 2.141250f, 0.274911f, 0.913954f, 0.428461f, 1.648146f, 0.531634f, 1.912169f, 1.318257f, 2.462522f,
0.163949f, 0.446620f, 0.071261f, 0.583650f, 0.257072f, 1.252186f, 0.725235f, 1.361831f, 0.159730f, 0.629316f, 0.267681f, 0.838237f, 0.307909f, 1.312455f, 0.820958f, 1.248433f,
0.534110f, 0.942091f, 0.138866f, 1.689990f, 0.553618f, 1.746052f, 0.934232f, 2.606687f, 0.501520f, 1.279391f, 0.502736f, 2.339263f, 0.712764f, 1.967166f, 1.136750f, 2.568615f,
0.027498f, 0.043827f, 0.008315f, 0.068561f, 0.049853f, 0.142076f, 0.097841f, 0.184966f, 0.010277f, 0.023691f, 0.011982f, 0.037774f, 0.058290f, 0.145369f, 0.108118f, 0.165527f,
0.051031f, 0.117104f, 0.021950f, 0.202448f, 0.081220f, 0.333263f, 0.226753f, 0.479480f, 0.055896f, 0.185513f, 0.092700f, 0.326889f, 0.101741f, 0.365315f, 0.268448f, 0.459702f,
0.022317f, 0.060691f, 0.010322f, 0.077499f, 0.054166f, 0.263387f, 0.162601f, 0.279901f, 0.029810f, 0.117245f, 0.053157f, 0.152598f, 0.054086f, 0.230146f, 0.153447f, 0.213914f,
0.107101f, 0.188587f, 0.029630f, 0.330567f, 0.171835f, 0.541022f, 0.308553f, 0.789226f, 0.137877f, 0.351126f, 0.147068f, 0.627326f, 0.184433f, 0.508150f, 0.312993f, 0.648344f,
0.296098f, 0.322760f, 0.083841f, 0.623999f, 0.337153f, 0.657136f, 0.619623f, 1.057303f, 0.055552f, 0.087578f, 0.060647f, 0.172577f, 0.504083f, 0.859763f, 0.875543f, 1.209899f,
0.426850f, 0.669900f, 0.171930f, 1.431279f, 0.426684f, 1.197364f, 1.115481f, 2.129023f, 0.234697f, 0.532715f, 0.364477f, 1.160093f, 0.683456f, 1.678336f, 1.688659f, 2.610116f,
0.256494f, 0.477047f, 0.111087f, 0.752839f, 0.390985f, 1.300253f, 1.099073f, 1.707690f, 0.171979f, 0.462606f, 0.287177f, 0.744109f, 0.499221f, 1.452814f, 1.326281f, 1.668851f,
0.822324f, 0.990284f, 0.213035f, 2.145252f, 0.828627f, 1.784271f, 1.393308f, 3.216764f, 0.531399f, 0.925531f, 0.530783f, 2.043588f, 1.137263f, 2.142946f, 1.807275f, 3.379061f,
0.192572f, 0.351445f, 0.062124f, 0.504392f, 0.264072f, 0.861729f, 0.552924f, 1.029253f, 0.042603f, 0.112449f, 0.052990f, 0.164495f, 0.318088f, 0.908330f, 0.629456f, 0.948902f,
0.298043f, 0.783128f, 0.136772f, 1.242094f, 0.358796f, 1.685725f, 1.068674f, 2.225093f, 0.193239f, 0.734347f, 0.341900f, 1.187153f, 0.463022f, 1.903659f, 1.303391f, 2.197744f,
0.064631f, 0.201255f, 0.031891f, 0.235774f, 0.118649f, 0.660620f, 0.379991f, 0.644080f, 0.051101f, 0.230134f, 0.097217f, 0.274798f, 0.122052f, 0.594680f, 0.369429f, 0.507105f,
0.489859f, 0.987660f, 0.144584f, 1.588302f, 0.594463f, 2.143119f, 1.138820f, 2.868216f, 0.373279f, 1.088485f, 0.424787f, 1.784153f, 0.657319f, 2.073701f, 1.190095f, 2.427382f,
0.205371f, 0.456649f, 0.061707f, 0.556476f, 0.273188f, 1.086152f, 0.532766f, 1.101525f, 0.060711f, 0.195238f, 0.070331f, 0.242500f, 0.422799f, 1.470998f, 0.779264f, 1.304795f,
0.446727f, 1.430138f, 0.190938f, 1.925981f, 0.521682f, 2.986249f, 1.447224f, 3.346880f, 0.387026f, 1.791962f, 0.637790f, 2.459727f, 0.864984f, 4.332883f, 2.267845f, 4.247344f,
0.213506f, 0.810018f, 0.098123f, 0.805741f, 0.380211f, 2.579252f, 1.134138f, 2.135181f, 0.225567f, 1.237689f, 0.399690f, 1.254864f, 0.502524f, 2.983141f, 1.416684f, 2.159938f,
0.669771f, 1.645294f, 0.184123f, 2.246580f, 0.788450f, 3.463193f, 1.406813f, 3.935455f, 0.681978f, 2.422931f, 0.722837f, 3.372122f, 1.120144f, 4.305515f, 1.888912f, 4.279271f,
0.068669f, 0.152428f, 0.021955f, 0.181503f, 0.141392f, 0.561191f, 0.293410f, 0.556121f, 0.027831f, 0.089348f, 0.034308f, 0.108440f, 0.182428f, 0.633615f, 0.357780f, 0.549176f,
0.138533f, 0.442738f, 0.063006f, 0.582608f, 0.250412f, 1.430977f, 0.739198f, 1.567119f, 0.164548f, 0.760567f, 0.288539f, 1.020118f, 0.346139f, 1.730921f, 0.965677f, 1.657956f,
0.060772f, 0.230166f, 0.029719f, 0.223717f, 0.167515f, 1.134432f, 0.531703f, 0.917645f, 0.088025f, 0.482168f, 0.165969f, 0.477681f, 0.184577f, 1.093836f, 0.553694f, 0.773882f,
0.280833f, 0.688688f, 0.082150f, 0.918874f, 0.511721f, 2.243847f, 0.971564f, 2.491533f, 0.392041f, 1.390463f, 0.442157f, 1.890936f, 0.606076f, 2.325602f, 1.087527f, 2.258578f,
0.381787f, 0.579589f, 0.114304f, 0.852926f, 0.493720f, 1.340184f, 0.959399f, 1.641327f, 0.077673f, 0.170539f, 0.089660f, 0.255798f, 0.814554f, 1.934873f, 1.495940f, 2.072573f,
0.598295f, 1.307693f, 0.254806f, 2.126703f, 0.679228f, 2.654547f, 1.877540f, 3.592785f, 0.356725f, 1.127657f, 0.585754f, 1.869227f, 1.200561f, 4.105896f, 3.136415f, 4.860437f,
0.360626f, 0.934105f, 0.165143f, 1.122079f, 0.624320f, 2.891550f, 1.855633f, 2.890670f, 0.262205f, 0.982274f, 0.462950f, 1.202665f, 0.879641f, 3.565147f, 2.470960f, 3.117251f,
1.113311f, 1.867192f, 0.304960f, 3.078889f, 1.274093f, 3.820835f, 2.265203f, 5.243284f, 0.780156f, 1.892373f, 0.823939f, 3.180504f, 1.929601f, 5.063763f, 3.242269f, 6.077779f,
0.186969f, 0.353701f, 0.057547f, 0.524119f, 0.277100f, 0.937320f, 0.553564f, 1.155905f, 0.048923f, 0.133855f, 0.058057f, 0.202168f, 0.332136f, 0.983144f, 0.627082f, 1.060420f,
0.246337f, 0.670946f, 0.107854f, 1.098733f, 0.320506f, 1.560917f, 0.910802f, 2.127278f, 0.188905f, 0.744141f, 0.318888f, 1.242062f, 0.411573f, 1.754036f, 1.105375f, 2.090785f,
0.060033f, 0.193773f, 0.028262f, 0.234383f, 0.119109f, 0.687444f, 0.363952f, 0.692004f, 0.056139f, 0.262076f, 0.101900f, 0.323104f, 0.121923f, 0.615779f, 0.352094f, 0.542154f,
0.434435f, 0.907958f, 0.122339f, 1.507559f, 0.569794f, 2.129330f, 1.041447f, 2.942331f, 0.391549f, 1.183531f, 0.425122f, 2.002960f, 0.626939f, 2.050213f, 1.082979f, 2.477845f,
0.176175f, 0.406062f, 0.050504f, 0.510904f, 0.253283f, 1.043852f, 0.471270f, 1.093014f, 0.061599f, 0.205340f, 0.068084f, 0.263332f, 0.390063f, 1.406749f, 0.685922f, 1.288338f,
0.326230f, 1.082590f, 0.133034f, 1.505293f, 0.411743f, 2.443152f, 1.089797f, 2.827141f, 0.334288f, 1.604404f, 0.525591f, 2.273813f, 0.679336f, 3.527423f, 1.699337f, 3.570105f,
0.175221f, 0.689086f, 0.076831f, 0.707713f, 0.337239f, 2.371432f, 0.959773f, 2.026911f, 0.218951f, 1.245343f, 0.370157f, 1.303638f, 0.443533f, 2.729273f, 1.192976f, 2.040316f,
0.524821f, 1.336390f, 0.137652f, 1.884058f, 0.667726f, 3.040217f, 1.136711f, 3.567022f, 0.632055f, 2.327713f, 0.639167f, 3.344835f, 0.943961f, 3.761051f, 1.518733f, 3.859552f,
0.058024f, 0.133509f, 0.017700f, 0.164139f, 0.129123f, 0.531243f, 0.255648f, 0.543545f, 0.027814f, 0.092561f, 0.032713f, 0.115989f, 0.165778f, 0.596850f, 0.310200f, 0.534113f,
0.099649f, 0.330117f, 0.043240f, 0.448518f, 0.194675f, 1.153166f, 0.548284f, 1.303899f, 0.139993f, 0.670744f, 0.234212f, 0.928865f, 0.267770f, 1.388010f, 0.712743f, 1.372686f,
0.049126f, 0.192866f, 0.022921f, 0.193550f, 0.146352f, 1.027377f, 0.443207f, 0.858043f, 0.084161f, 0.477870f, 0.151400f, 0.488802f, 0.160465f, 0.985734f, 0.459265f, 0.720055f,
0.216754f, 0.550994f, 0.060494f, 0.759037f, 0.426866f, 1.940241f, 0.773249f, 2.224396f, 0.357891f, 1.315777f, 0.385111f, 1.847492f, 0.503085f, 2.001032f, 0.861280f, 2.006489f,
0.411100f, 0.646920f, 0.117429f, 0.982935f, 0.574573f, 1.616715f, 1.065255f, 2.044312f, 0.098923f, 0.225139f, 0.108946f, 0.348666f, 0.943281f, 2.322618f, 1.652817f, 2.568727f,
0.548426f, 1.242546f, 0.222844f, 2.086394f, 0.672909f, 2.726060f, 1.774678f, 3.809423f, 0.386755f, 1.267309f, 0.605908f, 2.168955f, 1.183536f, 4.195746f, 2.949988f, 5.128135f,
0.371494f, 0.997458f, 0.162310f, 1.237102f, 0.695089f, 3.337093f, 1.971130f, 3.444444f, 0.319474f, 1.240597f, 0.538167f, 1.568287f, 0.974530f, 4.094221f, 2.611831f, 3.696141f,
1.095021f, 1.903702f, 0.286179f, 3.241060f, 1.354396f, 4.210240f, 2.297424f, 5.965335f, 0.907583f, 2.282001f, 0.914513f, 3.959933f, 2.041118f, 5.552366f, 3.272196f, 6.880700f,
0.166206f, 0.274778f, 0.044167f, 0.407347f, 0.262275f, 0.775312f, 0.452368f, 0.956533f, 0.037776f, 0.090323f, 0.038704f, 0.136479f, 0.261706f, 0.676989f, 0.426603f, 0.730518f,
0.236447f, 0.562806f, 0.089381f, 0.922045f, 0.327555f, 1.394102f, 0.803663f, 1.900762f, 0.157495f, 0.542181f, 0.229543f, 0.905361f, 0.350162f, 1.304153f, 0.811961f, 1.555208f,
0.048239f, 0.136072f, 0.019607f, 0.164661f, 0.101905f, 0.513992f, 0.268843f, 0.517626f, 0.039183f, 0.159853f, 0.061405f, 0.197163f, 0.086838f, 0.383283f, 0.216515f, 0.337603f,
0.378028f, 0.690450f, 0.091911f, 1.146911f, 0.527910f, 1.724060f, 0.833071f, 2.383362f, 0.295940f, 0.781743f, 0.277417f, 1.323567f, 0.483552f, 1.381924f, 0.721175f, 1.670891f,
0.200184f, 0.403222f, 0.049547f, 0.507552f, 0.306432f, 1.103656f, 0.492266f, 1.156138f, 0.060796f, 0.177110f, 0.058016f, 0.227229f, 0.392860f, 1.238189f, 0.596459f, 1.134460f,
0.400253f, 1.160757f, 0.140921f, 1.614683f, 0.537873f, 2.789144f, 1.229140f, 3.228918f, 0.356246f, 1.494202f, 0.483592f, 2.118553f, 0.738777f, 3.352384f, 1.595552f, 3.394425f,
0.179970f, 0.618522f, 0.068132f, 0.635518f, 0.368804f, 2.266394f, 0.906210f, 1.937976f, 0.195335f, 0.970932f, 0.285116f, 1.016824f, 0.403793f, 2.171438f, 0.937708f, 1.624003f,
0.583736f, 1.298989f, 0.132188f, 1.832128f, 0.790763f, 3.146445f, 1.162253f, 3.693264f, 0.610630f, 1.965260f, 0.533139f, 2.825233f, 0.930632f, 3.240413f, 1.292730f, 3.326727f,
0.079741f, 0.160344f, 0.021001f, 0.197217f, 0.188940f, 0.679330f, 0.322972f, 0.695363f, 0.033202f, 0.096559f, 0.033714f, 0.121051f, 0.201939f, 0.635371f, 0.326241f, 0.568833f,
0.147868f, 0.428092f, 0.055398f, 0.581887f, 0.307578f, 1.592225f, 0.747917f, 1.801132f, 0.180438f, 0.755517f, 0.260635f, 1.046718f, 0.352195f, 1.595442f, 0.809387f, 1.578514f,
0.061026f, 0.209377f, 0.024584f, 0.210212f, 0.193575f, 1.187537f, 0.506126f, 0.992236f, 0.090811f, 0.450611f, 0.141043f, 0.461120f, 0.176688f, 0.948533f, 0.436607f, 0.693182f,
0.291585f, 0.647756f, 0.070261f, 0.892723f, 0.611410f, 2.428642f, 0.956230f, 2.785537f, 0.418183f, 1.343585f, 0.388511f, 1.887359f, 0.599871f, 2.085151f, 0.886672f, 2.091748f,
0.379627f, 0.522068f, 0.093624f, 0.793578f, 0.564934f, 1.389161f, 0.904291f, 1.757338f, 0.079346f, 0.157814f, 0.075447f, 0.244508f, 0.772092f, 1.661394f, 1.168033f, 1.838239f,
0.546831f, 1.082715f, 0.191840f, 1.818810f, 0.714388f, 2.529183f, 1.626672f, 3.535845f, 0.334956f, 0.959186f, 0.453066f, 1.642327f, 1.046007f, 3.240632f, 2.251003f, 3.962499f,
0.310092f, 0.727614f, 0.116973f, 0.902819f, 0.617764f, 2.591896f, 1.512515f, 2.676439f, 0.231628f, 0.786059f, 0.336881f, 0.994120f, 0.721029f, 2.647258f, 1.668419f, 2.390906f,
0.989811f, 1.503820f, 0.223342f, 2.561374f, 1.303522f, 3.541170f, 1.909047f, 5.019540f, 0.712581f, 1.565780f, 0.619926f, 2.718266f, 1.635372f, 3.887709f, 2.263551f, 4.819892f,
0.323132f, 0.423436f, 0.098588f, 0.798385f, 0.306621f, 0.718447f, 0.607193f, 1.127351f, 0.065181f, 0.123533f, 0.076675f, 0.237406f, 0.438428f, 0.898958f, 0.820537f, 1.233759f,
0.273041f, 0.515142f, 0.118502f, 1.073400f, 0.227452f, 0.767315f, 0.640722f, 1.330603f, 0.161413f, 0.440445f, 0.270101f, 0.935427f, 0.348430f, 1.028603f, 0.927621f, 1.560087f,
0.065452f, 0.146342f, 0.030544f, 0.225232f, 0.083145f, 0.332404f, 0.251841f, 0.425764f, 0.047184f, 0.152581f, 0.084898f, 0.239356f, 0.101529f, 0.355198f, 0.290640f, 0.397922f,
0.419613f, 0.607477f, 0.117133f, 1.283420f, 0.352368f, 0.912141f, 0.638422f, 1.603765f, 0.291546f, 0.610437f, 0.313781f, 1.314510f, 0.462508f, 1.047691f, 0.791966f, 1.611160f,
0.320376f, 0.511503f, 0.091041f, 0.818890f, 0.294901f, 0.841878f, 0.543916f, 1.121673f, 0.086354f, 0.199400f, 0.094612f, 0.325377f, 0.541776f, 1.353450f, 0.944391f, 1.577197f,
0.380475f, 0.874594f, 0.153801f, 1.547369f, 0.307456f, 1.263711f, 0.806668f, 1.860694f, 0.300553f, 0.999202f, 0.468425f, 1.801875f, 0.605141f, 2.176558f, 1.500528f, 2.803006f,
0.201013f, 0.547585f, 0.087371f, 0.715593f, 0.247703f, 1.206546f, 0.698801f, 1.312194f, 0.193635f, 0.762895f, 0.324499f, 1.016162f, 0.388628f, 1.656515f, 1.036173f, 1.575710f,
0.533382f, 0.940807f, 0.138676f, 1.687688f, 0.434490f, 1.370335f, 0.733203f, 2.045778f, 0.495198f, 1.263264f, 0.496399f, 2.309776f, 0.732742f, 2.022306f, 1.168614f, 2.640614f,
0.078857f, 0.125686f, 0.023845f, 0.196616f, 0.112355f, 0.320203f, 0.220509f, 0.416867f, 0.029141f, 0.067174f, 0.033974f, 0.107107f, 0.172081f, 0.429153f, 0.319183f, 0.488665f,
0.086855f, 0.199311f, 0.037360f, 0.344568f, 0.108640f, 0.445770f, 0.303302f, 0.641347f, 0.094065f, 0.312189f, 0.155999f, 0.550103f, 0.178261f, 0.640069f, 0.470348f, 0.805445f,
0.042118f, 0.114539f, 0.019480f, 0.146260f, 0.080337f, 0.390647f, 0.241164f, 0.415139f, 0.055625f, 0.218780f, 0.099192f, 0.284748f, 0.105078f, 0.447126f, 0.298116f, 0.415591f,
0.164633f, 0.289892f, 0.045547f, 0.508139f, 0.207585f, 0.653581f, 0.372748f, 0.953425f, 0.209554f, 0.533665f, 0.223524f, 0.953453f, 0.291850f, 0.804106f, 0.495286f, 1.025951f,
0.292258f, 0.318574f, 0.082754f, 0.615905f, 0.261528f, 0.509738f, 0.480639f, 0.820146f, 0.054214f, 0.085469f, 0.059186f, 0.168421f, 0.512189f, 0.873589f, 0.889623f, 1.229356f,
0.250048f, 0.392427f, 0.100716f, 0.838442f, 0.196434f, 0.551234f, 0.513538f, 0.980145f, 0.135937f, 0.308550f, 0.211107f, 0.671930f, 0.412152f, 1.012105f, 1.018330f, 1.574005f,
0.166607f, 0.309868f, 0.072157f, 0.489010f, 0.199589f, 0.663751f, 0.561053f, 0.871738f, 0.110452f, 0.297105f, 0.184437f, 0.477898f, 0.333816f, 0.971457f, 0.886848f, 1.115915f,
0.435064f, 0.523926f, 0.112710f, 1.134981f, 0.344533f, 0.741878f, 0.579321f, 1.337492f, 0.277981f, 0.484155f, 0.277658f, 1.069022f, 0.619397f, 1.167131f, 0.984312f, 1.840367f,
0.326398f, 0.595677f, 0.105296f, 0.854913f, 0.351753f, 1.147851f, 0.736513f, 1.370998f, 0.071396f, 0.188448f, 0.088803f, 0.275669f, 0.555007f, 1.584874f, 1.098288f, 1.655665f,
0.299813f, 0.787779f, 0.137584f, 1.249470f, 0.283649f, 1.332661f, 0.844847f, 1.759062f, 0.192198f, 0.730391f, 0.340058f, 1.180758f, 0.479480f, 1.971326f, 1.349720f, 2.275864f,
0.072091f, 0.224484f, 0.035572f, 0.262987f, 0.104007f, 0.579097f, 0.333099f, 0.564599f, 0.056357f, 0.253806f, 0.107217f, 0.303064f, 0.140147f, 0.682841f, 0.424197f, 0.582283f,
0.445045f, 0.897306f, 0.131357f, 1.443000f, 0.424443f, 1.530175f, 0.813111f, 2.047890f, 0.335312f, 0.977774f, 0.381581f, 1.602685f, 0.614762f, 1.939444f, 1.113045f, 2.270227f,
0.309271f, 0.687676f, 0.092925f, 0.838007f, 0.323314f, 1.285444f, 0.630520f, 1.303638f, 0.090396f, 0.290702f, 0.104721f, 0.361074f, 0.655441f, 2.280399f, 1.208046f, 2.022746f,
0.399265f, 1.278195f, 0.170652f, 1.721358f, 0.366426f, 2.097523f, 1.016521f, 2.350828f, 0.342013f, 1.583546f, 0.563612f, 2.173646f, 0.795839f, 3.986520f, 2.086558f, 3.907820f,
0.211591f, 0.802751f, 0.097243f, 0.798513f, 0.296123f, 2.008823f, 0.883312f, 1.662963f, 0.221026f, 1.212776f, 0.391645f, 1.229605f, 0.512673f, 3.043392f, 1.445297f, 2.203562f,
0.540639f, 1.328081f, 0.148624f, 1.813439f, 0.500169f, 2.196946f, 0.892440f, 2.496534f, 0.544295f, 1.933770f, 0.576905f, 2.691331f, 0.930793f, 3.577701f, 1.569606f, 3.555893f,
0.159177f, 0.353331f, 0.050892f, 0.420727f, 0.257574f, 1.022323f, 0.534505f, 1.013089f, 0.063787f, 0.204779f, 0.078630f, 0.248535f, 0.435316f, 1.511958f, 0.853749f, 1.310464f,
0.190585f, 0.609090f, 0.086679f, 0.801513f, 0.270739f, 1.547136f, 0.799202f, 1.694329f, 0.223825f, 1.034557f, 0.392484f, 1.387610f, 0.490211f, 2.451373f, 1.367616f, 2.348038f,
0.092705f, 0.351110f, 0.045336f, 0.341271f, 0.200824f, 1.360008f, 0.637429f, 1.100113f, 0.132766f, 0.727247f, 0.250330f, 0.720480f, 0.289852f, 1.717716f, 0.869498f, 1.215273f,
0.348935f, 0.855695f, 0.102071f, 1.141701f, 0.499679f, 2.191043f, 0.948700f, 2.432901f, 0.481627f, 1.708198f, 0.543195f, 2.323035f, 0.775213f, 2.974605f, 1.391023f, 2.888878f,
0.304596f, 0.462406f, 0.091193f, 0.680479f, 0.309561f, 0.840291f, 0.601540f, 1.029106f, 0.061271f, 0.134527f, 0.070727f, 0.201783f, 0.668993f, 1.589110f, 1.228614f, 1.702202f,
0.283294f, 0.619195f, 0.120651f, 1.006998f, 0.252754f, 0.987810f, 0.698670f, 1.336948f, 0.167008f, 0.527936f, 0.274233f, 0.875118f, 0.585199f, 2.001370f, 1.528808f, 2.369162f,
0.189341f, 0.490438f, 0.086706f, 0.589131f, 0.257607f, 1.193111f, 0.765671f, 1.192748f, 0.136117f, 0.509922f, 0.240328f, 0.624333f, 0.475436f, 1.926922f, 1.335526f, 1.684839f,
0.476102f, 0.798495f, 0.130414f, 1.316672f, 0.428199f, 1.284113f, 0.761293f, 1.762172f, 0.329874f, 0.800153f, 0.348387f, 1.344814f, 0.849471f, 2.229229f, 1.427349f, 2.675631f,
0.085535f, 0.161812f, 0.026327f, 0.239776f, 0.099626f, 0.336996f, 0.199024f, 0.415584f, 0.022130f, 0.060547f, 0.026261f, 0.091447f, 0.156419f, 0.463010f, 0.295323f, 0.499403f,
0.066884f, 0.182172f, 0.029284f, 0.298322f, 0.068390f, 0.333070f, 0.194348f, 0.453920f, 0.050713f, 0.199770f, 0.085608f, 0.333442f, 0.115037f, 0.490264f, 0.308959f, 0.584387f,
0.018074f, 0.058338f, 0.008509f, 0.070564f, 0.028182f, 0.162652f, 0.086113f, 0.163731f, 0.016711f, 0.078014f, 0.030333f, 0.096180f, 0.037787f, 0.190846f, 0.109123f, 0.168028f,
0.106532f, 0.222649f, 0.030000f, 0.369683f, 0.109808f, 0.410355f, 0.200703f, 0.567033f, 0.094935f, 0.286958f, 0.103075f, 0.485636f, 0.158263f, 0.517550f, 0.273384f, 0.625500f,
0.071609f, 0.165050f, 0.020528f, 0.207665f, 0.080908f, 0.333445f, 0.150541f, 0.349149f, 0.024756f, 0.082524f, 0.027362f, 0.105830f, 0.163214f, 0.588624f, 0.287009f, 0.539077f,
0.078698f, 0.261159f, 0.032093f, 0.363130f, 0.078060f, 0.463184f, 0.206609f, 0.535982f, 0.079734f, 0.382682f, 0.125364f, 0.542349f, 0.168704f, 0.875985f, 0.422006f, 0.886585f,
0.046870f, 0.184324f, 0.020552f, 0.189307f, 0.070894f, 0.498518f, 0.201762f, 0.426093f, 0.057908f, 0.329367f, 0.097899f, 0.344785f, 0.122133f, 0.751542f, 0.328502f, 0.561828f,
0.114344f, 0.291163f, 0.029991f, 0.410485f, 0.114331f, 0.520559f, 0.194632f, 0.610760f, 0.136157f, 0.501436f, 0.137689f, 0.720545f, 0.211717f, 0.843549f, 0.340630f, 0.865641f,
0.036303f, 0.083531f, 0.011074f, 0.102695f, 0.063490f, 0.261212f, 0.125702f, 0.267261f, 0.017206f, 0.057260f, 0.020237f, 0.071752f, 0.106773f, 0.384416f, 0.199792f, 0.344009f,
0.037002f, 0.122581f, 0.016056f, 0.166547f, 0.056810f, 0.336519f, 0.160001f, 0.380506f, 0.051398f, 0.246261f, 0.085990f, 0.341030f, 0.102357f, 0.530575f, 0.272450f, 0.524717f,
0.020227f, 0.079411f, 0.009438f, 0.079693f, 0.047357f, 0.332442f, 0.143414f, 0.277648f, 0.034262f, 0.194543f, 0.061636f, 0.198994f, 0.068015f, 0.417812f, 0.194663f, 0.305202f,
0.072692f, 0.184784f, 0.020288f, 0.254555f, 0.112505f, 0.511371f, 0.203798f, 0.586263f, 0.118673f, 0.436298f, 0.127699f, 0.612610f, 0.173683f, 0.690829f, 0.297345f, 0.692713f,
0.088527f, 0.139308f, 0.025287f, 0.211666f, 0.097237f, 0.273603f, 0.180277f, 0.345967f, 0.021062f, 0.047936f, 0.023196f, 0.074237f, 0.209105f, 0.514875f, 0.366394f, 0.569432f,
0.070091f, 0.158802f, 0.028480f, 0.266649f, 0.067587f, 0.273805f, 0.178248f, 0.382617f, 0.048872f, 0.160143f, 0.076565f, 0.274080f, 0.155712f, 0.552015f, 0.388116f, 0.674685f,
0.052646f, 0.141353f, 0.023002f, 0.175314f, 0.077413f, 0.371656f, 0.219527f, 0.383611f, 0.044764f, 0.173830f, 0.075407f, 0.219745f, 0.142169f, 0.597283f, 0.381025f, 0.539209f,
0.126394f, 0.219738f, 0.033033f, 0.374104f, 0.122861f, 0.381922f, 0.208405f, 0.541131f, 0.103580f, 0.260438f, 0.104371f, 0.451935f, 0.242534f, 0.659753f, 0.388815f, 0.817591f,
0.471845f, 0.780071f, 0.125387f, 1.156424f, 0.585156f, 1.729779f, 1.009267f, 2.134095f, 0.106034f, 0.253532f, 0.108640f, 0.383090f, 0.764828f, 1.978480f, 1.246734f, 2.134919f,
0.398386f, 0.948264f, 0.150596f, 1.553541f, 0.433727f, 1.845978f, 1.064158f, 2.516865f, 0.262373f, 0.903229f, 0.382399f, 1.508257f, 0.607348f, 2.262023f, 1.408326f, 2.697472f,
0.090122f, 0.254219f, 0.036631f, 0.307629f, 0.149622f, 0.754667f, 0.394728f, 0.760003f, 0.072379f, 0.295285f, 0.113429f, 0.364205f, 0.167012f, 0.737148f, 0.416413f, 0.649294f,
0.575250f, 1.050665f, 0.139862f, 1.745267f, 0.631326f, 2.061799f, 0.996268f, 2.850257f, 0.445265f, 1.176195f, 0.417396f, 1.991412f, 0.757483f, 2.164784f, 1.129720f, 2.617451f,
0.504927f, 1.017055f, 0.124973f, 1.280208f, 0.607429f, 2.187739f, 0.975802f, 2.291772f, 0.151620f, 0.441698f, 0.144688f, 0.566690f, 1.020085f, 3.215030f, 1.548739f, 2.945693f,
0.599174f, 1.737639f, 0.210957f, 2.417161f, 0.632790f, 3.281337f, 1.446043f, 3.798717f, 0.527291f, 2.211619f, 0.715781f, 3.135742f, 1.138491f, 5.166184f, 2.458822f, 5.230972f,
0.298734f, 1.026692f, 0.113094f, 1.054905f, 0.481108f, 2.956531f, 1.182158f, 2.528107f, 0.320589f, 1.593518f, 0.467940f, 1.668837f, 0.689989f, 3.710485f, 1.602325f, 2.775046f,
0.789218f, 1.756247f, 0.178719f, 2.477057f, 0.840211f, 3.343197f, 1.234930f, 3.924209f, 0.816284f, 2.627139f, 0.712694f, 3.776742f, 1.295258f, 4.510020f, 1.799227f, 4.630151f,
0.309597f, 0.622542f, 0.081538f, 0.765702f, 0.576501f, 2.072800f, 0.985467f, 2.121722f, 0.127457f, 0.370672f, 0.129424f, 0.464691f, 0.807113f, 2.539456f, 1.303924f, 2.273517f,
0.340727f, 0.986440f, 0.127651f, 1.340824f, 0.556994f, 2.883364f, 1.354404f, 3.261674f, 0.411096f, 1.721316f, 0.593812f, 2.384766f, 0.835439f, 3.784532f, 1.919940f, 3.744379f,
0.155925f, 0.534970f, 0.062812f, 0.537103f, 0.388697f, 2.384565f, 1.016297f, 1.992403f, 0.229414f, 1.138375f, 0.356317f, 1.164924f, 0.464734f, 2.494888f, 1.148389f, 1.823247f,
0.606821f, 1.348052f, 0.146221f, 1.857856f, 0.999976f, 3.972102f, 1.563937f, 4.555812f, 0.860486f, 2.764670f, 0.799432f, 3.883584f, 1.285141f, 4.467151f, 1.899574f, 4.481284f,
0.507293f, 0.697637f, 0.125109f, 1.060455f, 0.593283f, 1.458871f, 0.949669f, 1.845524f, 0.104835f, 0.208512f, 0.099684f, 0.323056f, 1.062110f, 2.285457f, 1.606776f, 2.528729f,
0.433684f, 0.858687f, 0.152145f, 1.442474f, 0.445263f, 1.576386f, 1.013870f, 2.203817f, 0.262659f, 0.752153f, 0.355276f, 1.287844f, 0.853991f, 2.645747f, 1.837785f, 3.235100f,
0.272696f, 0.639865f, 0.102867f, 0.793941f, 0.426945f, 1.791294f, 1.045320f, 1.849723f, 0.201402f, 0.683480f, 0.292919f, 0.864390f, 0.652737f, 2.396525f, 1.510396f, 2.164453f,
0.708981f, 1.077156f, 0.159975f, 1.834660f, 0.733774f, 1.993384f, 1.074634f, 2.825583f, 0.504661f, 1.108910f, 0.439041f, 1.925118f, 1.205860f, 2.866647f, 1.669055f, 3.554003f,
0.290119f, 0.380175f, 0.088516f, 0.716816f, 0.352134f, 0.825087f, 0.697320f, 1.294686f, 0.068961f, 0.130697f, 0.081122f, 0.251173f, 0.432588f, 0.886984f, 0.809608f, 1.217325f,
0.328164f, 0.619141f, 0.142426f, 1.290103f, 0.349674f, 1.179633f, 0.985015f, 2.045604f, 0.228607f, 0.623793f, 0.382539f, 1.324827f, 0.460214f, 1.358601f, 1.225222f, 2.060597f,
0.061296f, 0.137050f, 0.028605f, 0.210931f, 0.099599f, 0.398186f, 0.301679f, 0.510020f, 0.052071f, 0.168382f, 0.093690f, 0.264144f, 0.104491f, 0.365561f, 0.299120f, 0.409532f,
0.526334f, 0.761978f, 0.146924f, 1.609834f, 0.565351f, 1.463472f, 1.024308f, 2.573139f, 0.430929f, 0.902277f, 0.463794f, 1.942955f, 0.637547f, 1.444199f, 1.091692f, 2.220917f,
0.389416f, 0.621731f, 0.110660f, 0.995359f, 0.458501f, 1.308921f, 0.845662f, 1.743937f, 0.123687f, 0.285605f, 0.135516f, 0.466045f, 0.723695f, 1.807914f, 1.261501f, 2.106791f,
0.619083f, 1.423077f, 0.250254f, 2.517769f, 0.639905f, 2.630146f, 1.678909f, 3.872641f, 0.576274f, 1.915851f, 0.898149f, 3.454882f, 1.082082f, 3.892006f, 2.683166f, 5.012189f,
0.254854f, 0.694256f, 0.110773f, 0.907265f, 0.401706f, 1.956690f, 1.133266f, 2.128023f, 0.289293f, 1.139774f, 0.484806f, 1.518159f, 0.541481f, 2.308048f, 1.443715f, 2.195460f,
0.905754f, 1.597615f, 0.235491f, 2.865919f, 0.943760f, 2.976519f, 1.592597f, 4.443654f, 0.990917f, 2.527855f, 0.993319f, 4.621977f, 1.367427f, 3.773982f, 2.180840f, 4.927854f,
0.081929f, 0.130582f, 0.024774f, 0.204275f, 0.149314f, 0.425531f, 0.293044f, 0.553993f, 0.035677f, 0.082241f, 0.041594f, 0.131130f, 0.196476f, 0.489993f, 0.364433f, 0.557941f,
0.120798f, 0.277202f, 0.051960f, 0.479224f, 0.193269f, 0.793021f, 0.539573f, 1.140951f, 0.154162f, 0.511644f, 0.255666f, 0.901560f, 0.272459f, 0.978300f, 0.718893f, 1.231065f,
0.045644f, 0.124127f, 0.021110f, 0.158502f, 0.111361f, 0.541508f, 0.334297f, 0.575459f, 0.071034f, 0.279385f, 0.126669f, 0.363628f, 0.125142f, 0.532502f, 0.355039f, 0.494945f,
0.238963f, 0.420774f, 0.066110f, 0.737558f, 0.385406f, 1.213454f, 0.692052f, 1.770150f, 0.358423f, 0.912785f, 0.382317f, 1.630794f, 0.465538f, 1.282650f, 0.790042f, 1.636520f,
0.486178f, 0.529955f, 0.137662f, 1.024573f, 0.556490f, 1.084641f, 1.022724f, 1.745140f, 0.106274f, 0.167542f, 0.116020f, 0.330150f, 0.936354f, 1.597044f, 1.626357f, 2.247437f,
0.556827f, 0.873887f, 0.224283f, 1.867108f, 0.559530f, 1.570156f, 1.462780f, 2.791882f, 0.356715f, 0.809671f, 0.553968f, 1.763222f, 1.008637f, 2.476870f, 2.492104f, 3.851978f,
0.289092f, 0.537674f, 0.125205f, 0.848516f, 0.442985f, 1.473186f, 1.245250f, 1.934812f, 0.225841f, 0.607489f, 0.377118f, 0.977156f, 0.636547f, 1.852453f, 1.691114f, 2.127917f,
1.011112f, 1.217632f, 0.261943f, 2.637756f, 1.024205f, 2.205407f, 1.722167f, 3.976008f, 0.761284f, 1.325917f, 0.760401f, 2.927649f, 1.581963f, 2.980895f, 2.513969f, 4.700365f,
0.313634f, 0.572382f, 0.101178f, 0.821481f, 0.432338f, 1.410819f, 0.905245f, 1.685088f, 0.080842f, 0.213380f, 0.100552f, 0.312140f, 0.586078f, 1.673600f, 1.159773f, 1.748354f,
0.385650f, 1.013322f, 0.176975f, 1.607197f, 0.466696f, 2.192670f, 1.390055f, 2.894240f, 0.291325f, 1.107096f, 0.515446f, 1.789743f, 0.677790f, 2.786654f, 1.907956f, 3.217147f,
0.072256f, 0.224996f, 0.035653f, 0.263586f, 0.133341f, 0.742422f, 0.427044f, 0.723835f, 0.066561f, 0.299763f, 0.126631f, 0.357940f, 0.154367f, 0.752125f, 0.467238f, 0.641364f,
0.597444f, 1.204574f, 0.176338f, 1.937132f, 0.728824f, 2.627508f, 1.396217f, 3.516492f, 0.530430f, 1.546742f, 0.603623f, 2.535288f, 0.906946f, 2.861221f, 1.642052f, 3.349218f,
0.402323f, 0.894579f, 0.120884f, 1.090141f, 0.537984f, 2.138938f, 1.049165f, 2.169213f, 0.138571f, 0.445625f, 0.160529f, 0.553500f, 0.937021f, 3.260071f, 1.727028f, 2.891728f,
0.695287f, 2.225869f, 0.297176f, 2.997601f, 0.816205f, 4.672179f, 2.264275f, 5.236409f, 0.701829f, 3.249523f, 1.156562f, 4.460440f, 1.523032f, 7.629179f, 3.993137f, 7.478566f,
0.287108f, 1.089255f, 0.131949f, 1.083504f, 0.513963f, 3.486585f, 1.533107f, 2.886298f, 0.353410f, 1.939168f, 0.626220f, 1.966077f, 0.764487f, 4.538242f, 2.155196f, 3.285906f,
0.982560f, 2.413663f, 0.270110f, 3.295756f, 1.162731f, 5.107184f, 2.074633f, 5.803630f, 1.165662f, 4.141363f, 1.235500f, 5.763756f, 1.859029f, 7.145577f, 3.134901f, 7.102022f,
0.176993f, 0.392879f, 0.056588f, 0.467819f, 0.366344f, 1.454036f, 0.760220f, 1.440902f, 0.083578f, 0.268317f, 0.103027f, 0.325650f, 0.531940f, 1.847557f, 1.043250f, 1.601339f,
0.283683f, 0.906621f, 0.129020f, 1.193041f, 0.515473f, 2.945664f, 1.521637f, 3.225911f, 0.392590f, 1.814618f, 0.688419f, 2.433875f, 0.801879f, 4.009915f, 2.237123f, 3.840881f,
0.107521f, 0.407224f, 0.052581f, 0.395813f, 0.297931f, 2.017632f, 0.945654f, 1.632067f, 0.181453f, 0.993937f, 0.342128f, 0.984689f, 0.369444f, 2.189390f, 1.108257f, 1.548979f,
0.542048f, 1.329269f, 0.158561f, 1.773562f, 0.992877f, 4.353666f, 1.885095f, 4.834243f, 0.881639f, 3.126934f, 0.994343f, 4.252419f, 1.323415f, 5.078139f, 2.374704f, 4.931788f,
0.542293f, 0.823252f, 0.162357f, 1.211501f, 0.704961f, 1.913590f, 1.369883f, 2.343579f, 0.128544f, 0.282231f, 0.148381f, 0.423330f, 1.308916f, 3.109169f, 2.403842f, 3.330440f,
0.675172f, 1.475722f, 0.287546f, 2.399968f, 0.770523f, 3.011345f, 2.129900f, 4.075693f, 0.469031f, 1.482671f, 0.770164f, 2.457705f, 1.532716f, 5.241861f, 4.004157f, 6.205159f,
0.351616f, 0.910767f, 0.161018f, 1.094044f, 0.611914f, 2.834092f, 1.818760f, 2.833230f, 0.297866f, 1.115869f, 0.525914f, 1.366234f, 0.970277f, 3.932495f, 2.725564f, 3.438448f,
1.184204f, 1.986089f, 0.324379f, 3.274944f, 1.362331f, 4.085449f, 2.422081f, 5.606411f, 0.966853f, 2.345232f, 1.021114f, 3.941622f, 2.321969f, 6.093437f, 3.901557f, 7.313645f,
0.135791f, 0.256884f, 0.041795f, 0.380655f, 0.202306f, 0.684322f, 0.404148f, 0.843907f, 0.041398f, 0.113267f, 0.049127f, 0.171073f, 0.272896f, 0.807788f, 0.515234f, 0.871280f,
0.142140f, 0.387146f, 0.062233f, 0.633985f, 0.185907f, 0.905396f, 0.528303f, 1.233908f, 0.126999f, 0.500278f, 0.214385f, 0.835025f, 0.268666f, 1.144997f, 0.721565f, 1.364820f,
0.029929f, 0.096604f, 0.014090f, 0.116849f, 0.059692f, 0.344515f, 0.182396f, 0.346801f, 0.032609f, 0.152229f, 0.059189f, 0.187677f, 0.068764f, 0.347299f, 0.198581f, 0.305775f,
0.236278f, 0.493815f, 0.066537f, 0.819922f, 0.311521f, 1.164160f, 0.569387f, 1.608649f, 0.248115f, 0.749975f, 0.269390f, 1.269228f, 0.385747f, 1.261468f, 0.666342f, 1.524584f,
0.153905f, 0.354732f, 0.044120f, 0.446321f, 0.222426f, 0.916682f, 0.413857f, 0.959855f, 0.062697f, 0.209002f, 0.069298f, 0.268029f, 0.385498f, 1.390284f, 0.677894f, 1.273260f,
0.226422f, 0.751377f, 0.092333f, 1.044756f, 0.287271f, 1.704574f, 0.760346f, 1.972481f, 0.270324f, 1.297408f, 0.425022f, 1.838728f, 0.533406f, 2.769685f, 1.334297f, 2.803199f,
0.105073f, 0.413219f, 0.046073f, 0.424389f, 0.203290f, 1.429517f, 0.578558f, 1.221837f, 0.152976f, 0.870092f, 0.258620f, 0.910821f, 0.300893f, 1.851539f, 0.809315f, 1.384150f,
0.343334f, 0.874255f, 0.090051f, 1.232536f, 0.439112f, 1.999316f, 0.747527f, 2.345755f, 0.481758f, 1.774205f, 0.487179f, 2.549464f, 0.698616f, 2.783514f, 1.123998f, 2.856414f,
0.066691f, 0.153453f, 0.020344f, 0.188659f, 0.149190f, 0.613805f, 0.295379f, 0.628018f, 0.037248f, 0.123955f, 0.043808f, 0.155328f, 0.215561f, 0.776084f, 0.403353f, 0.694508f,
0.090996f, 0.301452f, 0.039485f, 0.409572f, 0.178703f, 1.058557f, 0.503301f, 1.196923f, 0.148945f, 0.713636f, 0.249189f, 0.988263f, 0.276626f, 1.433912f, 0.736313f, 1.418081f,
0.038759f, 0.152167f, 0.018084f, 0.152707f, 0.116074f, 0.814827f, 0.351513f, 0.680526f, 0.077365f, 0.439281f, 0.139174f, 0.449331f, 0.143227f, 0.879838f, 0.409926f, 0.642700f,
0.186565f, 0.474252f, 0.052069f, 0.653319f, 0.369340f, 1.678764f, 0.669042f, 1.924624f, 0.358907f, 1.319513f, 0.386204f, 1.852738f, 0.489872f, 1.948477f, 0.838660f, 1.953791f,
0.260395f, 0.409766f, 0.074381f, 0.622600f, 0.365849f, 1.029413f, 0.678282f, 1.301678f, 0.073005f, 0.166152f, 0.080402f, 0.257314f, 0.675935f, 1.664338f, 1.184374f, 1.840695f,
0.275987f, 0.625292f, 0.112143f, 1.049946f, 0.340407f, 1.379042f, 0.897763f, 1.927087f, 0.226765f, 0.743057f, 0.355260f, 1.271716f, 0.673800f, 2.388684f, 1.679461f, 2.919504f,
0.161523f, 0.433689f, 0.070572f, 0.537884f, 0.303806f, 1.458558f, 0.861530f, 1.505478f, 0.161841f, 0.628468f, 0.272628f, 0.794471f, 0.479355f, 2.013882f, 1.284718f, 1.818073f,
0.519403f, 0.902986f, 0.135744f, 1.537337f, 0.645802f, 2.007522f, 1.095456f, 2.844385f, 0.501577f, 1.261150f, 0.505406f, 2.188462f, 1.095290f, 2.979471f, 1.755902f, 3.692272f,
0.337912f, 0.558647f, 0.089796f, 0.828173f, 0.536025f, 1.584545f, 0.924528f, 1.954914f, 0.089482f, 0.213955f, 0.091681f, 0.323289f, 0.601934f, 1.557101f, 0.981203f, 1.680221f,
0.381923f, 0.909078f, 0.144373f, 1.489342f, 0.531860f, 2.263644f, 1.304931f, 3.086324f, 0.296399f, 1.020365f, 0.431991f, 1.703857f, 0.639868f, 2.383141f, 1.483734f, 2.841905f,
0.067321f, 0.189900f, 0.027363f, 0.229797f, 0.142963f, 0.721079f, 0.377159f, 0.726178f, 0.063712f, 0.259923f, 0.099845f, 0.320590f, 0.137103f, 0.605137f, 0.341840f, 0.533016f,
0.575543f, 1.051200f, 0.139933f, 1.746156f, 0.807951f, 2.638624f, 1.274991f, 3.647666f, 0.524960f, 1.386714f, 0.492103f, 2.347839f, 0.832866f, 2.380218f, 1.242147f, 2.877933f,
0.489544f, 0.986069f, 0.121165f, 1.241205f, 0.753301f, 2.713117f, 1.210138f, 2.842133f, 0.173224f, 0.504633f, 0.165303f, 0.647434f, 1.086877f, 3.425542f, 1.650146f, 3.138569f,
0.777649f, 2.255227f, 0.273795f, 3.137157f, 1.050510f, 5.447430f, 2.400613f, 6.306345f, 0.806432f, 3.382418f, 1.094706f, 4.795760f, 1.623834f, 7.368546f, 3.507027f, 7.460953f,
0.302108f, 1.038286f, 0.114371f, 1.066817f, 0.622342f, 3.824452f, 1.529193f, 3.270259f, 0.382043f, 1.898978f, 0.557638f, 1.988735f, 0.766831f, 4.123715f, 1.780773f, 3.084097f,
1.068998f, 2.378843f, 0.242076f, 3.355182f, 1.455722f, 5.792315f, 2.139601f, 6.798959f, 1.302890f, 4.193238f, 1.137548f, 6.028147f, 1.928047f, 6.713359f, 2.678226f, 6.892179f,
0.256567f, 0.515910f, 0.067571f, 0.634549f, 0.611104f, 2.197214f, 1.044617f, 2.249072f, 0.124467f, 0.361977f, 0.126388f, 0.453791f, 0.735056f, 2.312740f, 1.187513f, 2.070543f,
0.377989f, 1.094317f, 0.141611f, 1.487457f, 0.790375f, 4.091496f, 1.921901f, 4.628320f, 0.537406f, 2.250192f, 0.776261f, 3.117488f, 1.018517f, 4.613877f, 2.340677f, 4.564925f,
0.134783f, 0.462432f, 0.054296f, 0.464276f, 0.429774f, 2.636561f, 1.123697f, 2.202956f, 0.233682f, 1.159552f, 0.362945f, 1.186595f, 0.441474f, 2.370013f, 1.090910f, 1.731990f,
0.702559f, 1.560734f, 0.169290f, 2.150969f, 1.480886f, 5.882374f, 2.316069f, 6.746802f, 1.173958f, 3.771827f, 1.090662f, 5.298356f, 1.635137f, 5.683737f, 2.416905f, 5.701719f,
0.673126f, 0.925693f, 0.166007f, 1.407115f, 1.006953f, 2.476078f, 1.611832f, 3.132327f, 0.163920f, 0.326028f, 0.155866f, 0.505129f, 1.548774f, 3.332665f, 2.343009f, 3.687406f,
0.770333f, 1.525247f, 0.270249f, 2.562200f, 1.011653f, 3.581605f, 2.303548f, 5.007151f, 0.549773f, 1.574337f, 0.743630f, 2.695594f, 1.667015f, 5.164575f, 3.587410f, 6.315009f,
0.377424f, 0.885604f, 0.142373f, 1.098852f, 0.755846f, 3.171232f, 1.850590f, 3.274673f, 0.328473f, 1.114713f, 0.477733f, 1.409765f, 0.992820f, 3.645139f, 2.297329f, 3.292156f,
1.314284f, 1.996793f, 0.296556f, 3.401027f, 1.739911f, 4.726674f, 2.548152f, 6.699968f, 1.102403f, 2.422351f, 0.959061f, 4.205312f, 2.456591f, 5.839962f, 3.400216f, 7.240250f,
0.282075f, 0.369634f, 0.086062f, 0.696942f, 0.317235f, 0.743315f, 0.628210f, 1.166373f, 0.062680f, 0.118793f, 0.073733f, 0.228297f, 0.417612f, 0.856276f, 0.781579f, 1.175181f,
0.327685f, 0.618237f, 0.142218f, 1.288219f, 0.323528f, 1.091430f, 0.911364f, 1.892651f, 0.213398f, 0.582295f, 0.357091f, 1.236693f, 0.456282f, 1.346996f, 1.214756f, 2.042995f,
0.071538f, 0.159949f, 0.033385f, 0.246175f, 0.107707f, 0.430601f, 0.326237f, 0.551539f, 0.056812f, 0.183712f, 0.102220f, 0.288193f, 0.121086f, 0.423618f, 0.346625f, 0.474572f,
0.465361f, 0.673706f, 0.129904f, 1.423343f, 0.463160f, 1.198937f, 0.839156f, 2.108023f, 0.356182f, 0.745771f, 0.383346f, 1.605937f, 0.559693f, 1.267840f, 0.958379f, 1.949709f,
0.382560f, 0.610785f, 0.108712f, 0.977835f, 0.417359f, 1.191470f, 0.769779f, 1.587451f, 0.113592f, 0.262295f, 0.124455f, 0.428007f, 0.705912f, 1.763487f, 1.230502f, 2.055020f,
0.624612f, 1.435788f, 0.252489f, 2.540257f, 0.598220f, 2.458813f, 1.569541f, 3.620369f, 0.543536f, 1.807011f, 0.847125f, 3.258609f, 1.084004f, 3.898919f, 2.687931f, 5.021091f,
0.300533f, 0.818693f, 0.130628f, 1.069881f, 0.438929f, 2.137998f, 1.238275f, 2.325206f, 0.318916f, 1.256486f, 0.534450f, 1.673617f, 0.634006f, 2.702435f, 1.690409f, 2.570608f,
0.809161f, 1.427240f, 0.210377f, 2.560287f, 0.781215f, 2.463867f, 1.318301f, 3.678314f, 0.827560f, 2.111127f, 0.829566f, 3.860024f, 1.212936f, 3.347600f, 1.934450f, 4.371108f,
0.087606f, 0.139631f, 0.026490f, 0.218431f, 0.147939f, 0.421613f, 0.290345f, 0.548891f, 0.035663f, 0.082209f, 0.041578f, 0.131080f, 0.208601f, 0.520231f, 0.386923f, 0.592373f,
0.132658f, 0.304418f, 0.057061f, 0.526275f, 0.196662f, 0.806943f, 0.549045f, 1.160981f, 0.158267f, 0.525267f, 0.262473f, 0.925564f, 0.297087f, 1.066731f, 0.783876f, 1.342345f,
0.058586f, 0.159323f, 0.027096f, 0.203446f, 0.132444f, 0.644024f, 0.397585f, 0.684403f, 0.085235f, 0.335239f, 0.151993f, 0.436323f, 0.159487f, 0.678647f, 0.452479f, 0.630783f,
0.232363f, 0.409154f, 0.064285f, 0.717189f, 0.347248f, 1.093312f, 0.623534f, 1.594891f, 0.325815f, 0.829742f, 0.347535f, 1.482429f, 0.449471f, 1.238381f, 0.762775f, 1.580038f,
0.407448f, 0.444136f, 0.115370f, 0.858658f, 0.432135f, 0.842262f, 0.794181f, 1.355163f, 0.083261f, 0.131262f, 0.090897f, 0.258658f, 0.779160f, 1.328934f, 1.353326f, 1.870139f,
0.479263f, 0.752157f, 0.193041f, 1.607026f, 0.446232f, 1.252218f, 1.166585f, 2.226560f, 0.287020f, 0.651478f, 0.445734f, 1.418724f, 0.861980f, 2.116730f, 2.129750f, 3.291897f,
0.290823f, 0.540894f, 0.125955f, 0.853598f, 0.412921f, 1.373203f, 1.160736f, 1.803498f, 0.212390f, 0.571307f, 0.354656f, 0.918956f, 0.635818f, 1.850330f, 1.689176f, 2.125479f,
0.770577f, 0.927968f, 0.199629f, 2.010255f, 0.723248f, 1.557361f, 1.216118f, 2.807680f, 0.542376f, 0.944649f, 0.541747f, 2.085801f, 1.197076f, 2.255653f, 1.902328f, 3.556781f,
0.267812f, 0.488756f, 0.086396f, 0.701461f, 0.342069f, 1.116250f, 0.716236f, 1.333254f, 0.064533f, 0.170333f, 0.080266f, 0.249169f, 0.496902f, 1.418950f, 0.983306f, 1.482330f,
0.338202f, 0.888649f, 0.155201f, 1.409456f, 0.379228f, 1.781720f, 1.129531f, 2.351802f, 0.238835f, 0.907622f, 0.422575f, 1.467272f, 0.590183f, 2.426467f, 1.661345f, 2.801317f,
0.074062f, 0.230620f, 0.036545f, 0.270175f, 0.126639f, 0.705110f, 0.405582f, 0.687457f, 0.063780f, 0.287235f, 0.121339f, 0.342981f, 0.157103f, 0.765458f, 0.475520f, 0.652733f,
0.463919f, 0.935361f, 0.136928f, 1.504197f, 0.524387f, 1.890486f, 1.004575f, 2.530108f, 0.385045f, 1.122796f, 0.438176f, 1.840392f, 0.699255f, 2.206002f, 1.266022f, 2.582248f,
0.347118f, 0.771830f, 0.104297f, 0.940558f, 0.430087f, 1.709955f, 0.838746f, 1.734158f, 0.111767f, 0.359426f, 0.129478f, 0.446434f, 0.802715f, 2.792793f, 1.479487f, 2.477246f,
0.616089f, 1.972325f, 0.263325f, 2.656151f, 0.670135f, 3.836032f, 1.859053f, 4.299285f, 0.581363f, 2.691757f, 0.958043f, 3.694826f, 1.339975f, 6.712211f, 3.513193f, 6.579701f,
0.297347f, 1.128102f, 0.136655f, 1.122146f, 0.493212f, 3.345821f, 1.471211f, 2.769769f, 0.342164f, 1.877463f, 0.606294f, 1.903516f, 0.786136f, 4.666758f, 2.216228f, 3.378957f,
0.770906f, 1.893733f, 0.211925f, 2.585812f, 0.845288f, 3.712849f, 1.508228f, 4.219156f, 0.854973f, 3.037545f, 0.906196f, 4.227513f, 1.448229f, 5.566577f, 2.442164f, 5.532647f,
0.166216f, 0.368955f, 0.053143f, 0.439332f, 0.318778f, 1.265244f, 0.661513f, 1.253815f, 0.073375f, 0.235560f, 0.090449f, 0.285893f, 0.496006f, 1.722749f, 0.972776f, 1.493164f,
0.273605f, 0.874414f, 0.124437f, 1.150659f, 0.460660f, 2.632439f, 1.359835f, 2.882886f, 0.353971f, 1.636115f, 0.620699f, 2.194457f, 0.767908f, 3.840037f, 2.142349f, 3.678164f,
0.121206f, 0.459055f, 0.059273f, 0.446191f, 0.311194f, 2.107448f, 0.987751f, 1.704719f, 0.191220f, 1.047436f, 0.360543f, 1.037690f, 0.413512f, 2.450547f, 1.240453f, 1.733747f,
0.462906f, 1.135187f, 0.135410f, 1.514610f, 0.785658f, 3.445033f, 1.491665f, 3.825311f, 0.703854f, 2.496379f, 0.793831f, 3.394907f, 1.122172f, 4.305940f, 2.013598f, 4.181843f,
0.399143f, 0.605937f, 0.119500f, 0.891699f, 0.480777f, 1.305050f, 0.934248f, 1.598299f, 0.088447f, 0.194194f, 0.102096f, 0.291280f, 0.956567f, 2.272207f, 1.756748f, 2.433914f,
0.510370f, 1.115514f, 0.217359f, 1.814162f, 0.539685f, 2.109187f, 1.491811f, 2.854670f, 0.331444f, 1.047738f, 0.544241f, 1.736752f, 1.150380f, 3.934279f, 3.005319f, 4.657281f,
0.310655f, 0.804669f, 0.142260f, 0.966597f, 0.500939f, 2.320108f, 1.488914f, 2.319402f, 0.246019f, 0.921640f, 0.434372f, 1.128426f, 0.851168f, 3.449749f, 2.390978f, 3.016350f,
0.792611f, 1.329329f, 0.217113f, 2.191986f, 0.844890f, 2.533713f, 1.502126f, 3.476983f, 0.604967f, 1.467429f, 0.638918f, 2.466301f, 1.543118f, 4.049534f, 2.592870f, 4.860451f,
0.140778f, 0.266318f, 0.043330f, 0.394635f, 0.194337f, 0.657368f, 0.388230f, 0.810667f, 0.040122f, 0.109776f, 0.047613f, 0.165800f, 0.280912f, 0.831515f, 0.530368f, 0.896873f,
0.151341f, 0.412206f, 0.066262f, 0.675024f, 0.183408f, 0.893228f, 0.521203f, 1.217325f, 0.126409f, 0.497953f, 0.213389f, 0.831145f, 0.284028f, 1.210469f, 0.762824f, 1.442860f,
0.037245f, 0.120219f, 0.017534f, 0.145414f, 0.068830f, 0.397258f, 0.210319f, 0.399893f, 0.037936f, 0.177098f, 0.068859f, 0.218338f, 0.084967f, 0.429134f, 0.245373f, 0.377825f,
0.222755f, 0.465551f, 0.062729f, 0.772993f, 0.272129f, 1.016951f, 0.497387f, 1.405233f, 0.218672f, 0.660979f, 0.237422f, 1.118614f, 0.361089f, 1.180833f, 0.623749f, 1.427130f,
0.161218f, 0.371588f, 0.046216f, 0.467529f, 0.215889f, 0.889740f, 0.401693f, 0.931644f, 0.061397f, 0.204667f, 0.067861f, 0.262470f, 0.400951f, 1.446016f, 0.705068f, 1.324300f,
0.243588f, 0.808340f, 0.099333f, 1.123961f, 0.286360f, 1.699168f, 0.757934f, 1.966226f, 0.271868f, 1.304820f, 0.427450f, 1.849233f, 0.569775f, 2.958530f, 1.425273f, 2.994328f,
0.132120f, 0.519585f, 0.057932f, 0.533630f, 0.236852f, 1.665518f, 0.674073f, 1.423552f, 0.179820f, 1.022772f, 0.304002f, 1.070648f, 0.375662f, 2.311629f, 1.010422f, 1.728099f,
0.327052f, 0.832795f, 0.085780f, 1.174084f, 0.387578f, 1.764676f, 0.659797f, 2.070457f, 0.429009f, 1.579941f, 0.433836f, 2.270315f, 0.660765f, 2.632705f, 1.063100f, 2.701654f,
0.076040f, 0.174964f, 0.023195f, 0.215105f, 0.157615f, 0.648466f, 0.312059f, 0.663482f, 0.039702f, 0.132122f, 0.046694f, 0.165562f, 0.244035f, 0.878599f, 0.456633f, 0.786248f,
0.106554f, 0.352994f, 0.046237f, 0.479601f, 0.193894f, 1.148542f, 0.546085f, 1.298671f, 0.163047f, 0.781201f, 0.272782f, 1.081830f, 0.321625f, 1.667172f, 0.856092f, 1.648766f,
0.053047f, 0.208261f, 0.024751f, 0.209000f, 0.147200f, 1.033328f, 0.445773f, 0.863012f, 0.098985f, 0.562042f, 0.178068f, 0.574900f, 0.194635f, 1.195640f, 0.557062f, 0.873386f,
0.193438f, 0.491724f, 0.053987f, 0.677388f, 0.354831f, 1.612819f, 0.642760f, 1.849021f, 0.347881f, 1.278978f, 0.374340f, 1.795823f, 0.504317f, 2.005933f, 0.863390f, 2.011403f,
0.232694f, 0.366174f, 0.066468f, 0.556367f, 0.302927f, 0.852366f, 0.561625f, 1.077804f, 0.060987f, 0.138802f, 0.067167f, 0.214958f, 0.599745f, 1.476736f, 1.050872f, 1.633214f,
0.253290f, 0.573867f, 0.102920f, 0.963597f, 0.289475f, 1.172708f, 0.763439f, 1.638753f, 0.194554f, 0.637512f, 0.304798f, 1.091078f, 0.614000f, 2.176687f, 1.530408f, 2.660397f,
0.173262f, 0.465207f, 0.075700f, 0.576975f, 0.301959f, 1.449691f, 0.856293f, 1.496326f, 0.162291f, 0.630215f, 0.273386f, 0.796680f, 0.510546f, 2.144920f, 1.368311f, 1.936370f,
0.422081f, 0.733791f, 0.110309f, 1.249282f, 0.486267f, 1.511596f, 0.824841f, 2.141725f, 0.381036f, 0.958067f, 0.383946f, 1.662523f, 0.883750f, 2.404028f, 1.416775f, 2.979161f,
0.362667f, 0.599574f, 0.096375f, 0.888845f, 0.533058f, 1.575773f, 0.919410f, 1.944092f, 0.089780f, 0.214667f, 0.091986f, 0.324364f, 0.641450f, 1.659323f, 1.045618f, 1.790526f,
0.420975f, 1.002034f, 0.159135f, 1.641632f, 0.543204f, 2.311922f, 1.332762f, 3.152148f, 0.305419f, 1.051416f, 0.445137f, 1.755706f, 0.700295f, 2.608195f, 1.623852f, 3.110283f,
0.086730f, 0.244650f, 0.035253f, 0.296051f, 0.170659f, 0.860771f, 0.450225f, 0.866858f, 0.076732f, 0.313043f, 0.120250f, 0.386107f, 0.175378f, 0.774076f, 0.437273f, 0.681821f,
0.561723f, 1.025959f, 0.136573f, 1.704227f, 0.730656f, 2.386194f, 1.153016f, 3.298704f, 0.478969f, 1.265228f, 0.448991f, 2.142152f, 0.807103f, 2.306589f, 1.203723f, 2.788908f,
0.530877f, 1.069324f, 0.131395f, 1.346000f, 0.756927f, 2.726177f, 1.215963f, 2.855815f, 0.175609f, 0.511581f, 0.167579f, 0.656348f, 1.170283f, 3.688416f, 1.776778f, 3.379421f,
0.866087f, 2.511702f, 0.304932f, 3.493930f, 1.084081f, 5.621514f, 2.477329f, 6.507877f, 0.839620f, 3.521620f, 1.139758f, 4.993127f, 1.795678f, 8.148329f, 3.878161f, 8.250515f,
0.393260f, 1.351558f, 0.148879f, 1.388697f, 0.750638f, 4.612864f, 1.844437f, 3.944424f, 0.464908f, 2.310867f, 0.678590f, 2.420092f, 0.991120f, 5.329851f, 2.301627f, 3.986158f,
1.054188f, 2.345885f, 0.238722f, 3.308697f, 1.330158f, 5.292696f, 1.955049f, 6.212511f, 1.201119f, 3.865698f, 1.048692f, 5.557279f, 1.887850f, 6.573395f, 2.622389f, 6.748488f,
0.302841f, 0.608959f, 0.079759f, 0.748995f, 0.668364f, 2.403092f, 1.142497f, 2.459809f, 0.137343f, 0.399422f, 0.139462f, 0.500734f, 0.861477f, 2.710503f, 1.391751f, 2.426651f,
0.458215f, 1.326580f, 0.171667f, 1.803162f, 0.887784f, 4.595748f, 2.158763f, 5.198732f, 0.609018f, 2.550041f, 0.879702f, 3.532909f, 1.225936f, 5.553479f, 2.817350f, 5.494559f,
0.190970f, 0.655206f, 0.076930f, 0.657819f, 0.564227f, 3.461398f, 1.475241f, 2.892142f, 0.309522f, 1.535881f, 0.480738f, 1.571700f, 0.621074f, 3.334185f, 1.534716f, 2.436600f,
0.754112f, 1.675260f, 0.181713f, 2.308807f, 1.472851f, 5.850457f, 2.303502f, 6.710195f, 1.177994f, 3.784796f, 1.094412f, 5.316574f, 1.742675f, 6.057539f, 2.575858f, 6.076704f,
0.622716f, 0.856368f, 0.153575f, 1.301737f, 0.863151f, 2.122470f, 1.381647f, 2.685000f, 0.141763f, 0.281959f, 0.134797f, 0.436850f, 1.422625f, 3.061217f, 2.152170f, 3.387064f,
0.731894f, 1.449138f, 0.256764f, 2.434348f, 0.890604f, 3.153052f, 2.027920f, 4.408025f, 0.488304f, 1.398314f, 0.660486f, 2.394206f, 1.572600f, 4.872066f, 3.384227f, 5.957341f,
0.419120f, 0.983442f, 0.158101f, 1.220250f, 0.777725f, 3.263031f, 1.904160f, 3.369466f, 0.340994f, 1.157203f, 0.495943f, 1.463503f, 1.094684f, 4.019133f, 2.533036f, 3.629933f,
1.105661f, 1.679831f, 0.249482f, 2.861164f, 1.356262f, 3.684445f, 1.986286f, 5.222630f, 0.866983f, 1.905054f, 0.754252f, 3.307260f, 2.051986f, 4.878111f, 2.840195f, 6.047769f,
0.445386f, 0.583638f, 0.135888f, 1.100445f, 0.537770f, 1.260054f, 1.064930f, 1.977214f, 0.090865f, 0.172209f, 0.106888f, 0.330952f, 0.587024f, 1.203642f, 1.098642f, 1.651918f,
0.583587f, 1.101043f, 0.253282f, 2.294240f, 0.618594f, 2.086842f, 1.742552f, 3.618797f, 0.348926f, 0.952107f, 0.583877f, 2.022109f, 0.723427f, 2.135636f, 1.925973f, 3.239131f,
0.114375f, 0.255727f, 0.053375f, 0.393585f, 0.184876f, 0.739117f, 0.559979f, 0.946705f, 0.083392f, 0.269665f, 0.150045f, 0.423029f, 0.172345f, 0.602948f, 0.493362f, 0.675473f,
0.819179f, 1.185931f, 0.228671f, 2.505524f, 0.875314f, 2.265844f, 1.585902f, 3.983904f, 0.575644f, 1.205280f, 0.619546f, 2.595439f, 0.877103f, 1.986851f, 1.501891f, 3.055418f,
0.473585f, 0.756112f, 0.134578f, 1.210497f, 0.554693f, 1.583528f, 1.023078f, 2.109809f, 0.129104f, 0.298113f, 0.141450f, 0.486455f, 0.777966f, 1.943491f, 1.356102f, 2.264781f,
0.872140f, 2.004777f, 0.352548f, 3.546937f, 0.896770f, 3.685919f, 2.352843f, 5.427167f, 0.696783f, 2.316489f, 1.085968f, 4.177357f, 1.347469f, 4.846543f, 3.341227f, 6.241456f,
0.376715f, 1.026223f, 0.163741f, 1.341084f, 0.590689f, 2.877215f, 1.666411f, 3.129152f, 0.367021f, 1.446012f, 0.615065f, 1.926062f, 0.707499f, 3.015698f, 1.886359f, 2.868590f,
1.116737f, 1.969757f, 0.290345f, 3.533494f, 1.157525f, 3.650711f, 1.953326f, 5.450157f, 1.048597f, 2.674998f, 1.051139f, 4.891016f, 1.490272f, 4.113023f, 2.376759f, 5.370555f,
0.072602f, 0.115716f, 0.021953f, 0.181019f, 0.131625f, 0.375120f, 0.258328f, 0.488362f, 0.027135f, 0.062550f, 0.031635f, 0.099734f, 0.153901f, 0.383814f, 0.285462f, 0.437038f,
0.124000f, 0.284551f, 0.053337f, 0.491928f, 0.197358f, 0.809798f, 0.550988f, 1.165089f, 0.135823f, 0.450778f, 0.225251f, 0.794309f, 0.247221f, 0.887680f, 0.652302f, 1.117032f,
0.049162f, 0.133694f, 0.022738f, 0.170719f, 0.119319f, 0.580205f, 0.358187f, 0.616582f, 0.065666f, 0.258275f, 0.117098f, 0.336152f, 0.119144f, 0.506979f, 0.338022f, 0.471223f,
0.214682f, 0.378021f, 0.059393f, 0.662617f, 0.344440f, 1.084471f, 0.618491f, 1.581994f, 0.276372f, 0.703827f, 0.294796f, 1.257467f, 0.369694f, 1.018581f, 0.627390f, 1.299597f,
0.630310f, 0.687065f, 0.178474f, 1.328318f, 0.717704f, 1.398858f, 1.319003f, 2.250700f, 0.118254f, 0.186429f, 0.129100f, 0.367368f, 1.073050f, 1.830194f, 1.863786f, 2.575536f,
0.836244f, 1.312405f, 0.336828f, 2.804027f, 0.835920f, 2.345762f, 2.185346f, 4.170981f, 0.459796f, 1.043644f, 0.714049f, 2.272745f, 1.338963f, 3.288038f, 3.308262f, 5.113492f,
0.455547f, 0.847259f, 0.197297f, 1.337080f, 0.694409f, 2.309315f, 1.952010f, 3.032944f, 0.305443f, 0.821612f, 0.510041f, 1.321576f, 0.886643f, 2.580271f, 2.355543f, 2.963964f,
1.328969f, 1.600412f, 0.344289f, 3.466972f, 1.339156f, 2.883586f, 2.251745f, 5.198659f, 0.858802f, 1.495764f, 0.857806f, 3.302673f, 1.837947f, 3.463246f, 2.920764f, 5.460950f,
0.342680f, 0.625390f, 0.110548f, 0.897558f, 0.469912f, 1.533433f, 0.983919f, 1.831538f, 0.075811f, 0.200101f, 0.094294f, 0.292716f, 0.566032f, 1.616359f, 1.120106f, 1.688556f,
0.488104f, 1.282527f, 0.223991f, 2.034173f, 0.587599f, 2.760707f, 1.750165f, 3.644027f, 0.316466f, 1.202638f, 0.559929f, 1.944197f, 0.758289f, 3.117616f, 2.134559f, 3.599237f,
0.095957f, 0.298798f, 0.047348f, 0.350047f, 0.176155f, 0.980805f, 0.564162f, 0.956249f, 0.075868f, 0.341674f, 0.144336f, 0.407985f, 0.181208f, 0.882905f, 0.548482f, 0.752885f,
0.661788f, 1.334305f, 0.195330f, 2.145758f, 0.803106f, 2.895303f, 1.538519f, 3.874892f, 0.504290f, 1.470518f, 0.573877f, 2.410349f, 0.888022f, 2.801521f, 1.607790f, 3.279336f,
0.348227f, 0.774296f, 0.104630f, 0.943563f, 0.463218f, 1.841682f, 0.903359f, 1.867749f, 0.102942f, 0.331046f, 0.119254f, 0.411184f, 0.716900f, 2.494228f, 1.321322f, 2.212415f,
0.697118f, 2.231729f, 0.297959f, 3.005493f, 0.814085f, 4.660040f, 2.258392f, 5.222804f, 0.603954f, 2.796355f, 0.995271f, 3.838402f, 1.349807f, 6.761461f, 3.538971f, 6.627979f,
0.302045f, 1.145924f, 0.138814f, 1.139874f, 0.537881f, 3.648841f, 1.604454f, 3.020618f, 0.319107f, 1.750946f, 0.565437f, 1.775242f, 0.710915f, 4.220219f, 2.004168f, 3.055641f,
0.862192f, 2.117978f, 0.237020f, 2.892010f, 1.014968f, 4.458149f, 1.810983f, 5.066089f, 0.877907f, 3.119025f, 0.930504f, 4.340914f, 1.441956f, 5.542465f, 2.431585f, 5.508681f,
0.111628f, 0.247784f, 0.035690f, 0.295047f, 0.229843f, 0.912258f, 0.476960f, 0.904018f, 0.045242f, 0.145242f, 0.055769f, 0.176277f, 0.296550f, 1.029990f, 0.581599f, 0.892726f,
0.207253f, 0.662360f, 0.094260f, 0.871612f, 0.374630f, 2.140817f, 1.105878f, 2.344492f, 0.246172f, 1.137847f, 0.431669f, 1.526150f, 0.517843f, 2.589548f, 1.444704f, 2.480388f,
0.082422f, 0.312167f, 0.040307f, 0.303419f, 0.227194f, 1.538589f, 0.721129f, 1.244568f, 0.119385f, 0.653946f, 0.225098f, 0.647862f, 0.250335f, 1.483530f, 0.750955f, 1.049588f,
0.346584f, 0.849931f, 0.101383f, 1.134011f, 0.631531f, 2.769199f, 1.199036f, 3.074876f, 0.483830f, 1.716012f, 0.545680f, 2.333661f, 0.747976f, 2.870095f, 1.342150f, 2.787380f,
0.500377f, 0.759620f, 0.149808f, 1.117860f, 0.647078f, 1.756469f, 1.257405f, 2.151153f, 0.101800f, 0.223511f, 0.117509f, 0.335253f, 1.067570f, 2.535880f, 1.960605f, 2.716351f,
0.721658f, 1.577326f, 0.307344f, 2.565207f, 0.819277f, 3.201887f, 2.264669f, 4.333581f, 0.430279f, 1.360169f, 0.706531f, 2.254643f, 1.448104f, 4.952489f, 3.783111f, 5.862609f,
0.394339f, 1.021430f, 0.180582f, 1.226977f, 0.682685f, 3.161869f, 2.029109f, 3.160907f, 0.286717f, 1.074103f, 0.506229f, 1.315097f, 0.961874f, 3.898438f, 2.701959f, 3.408670f,
1.107762f, 1.857885f, 0.303440f, 3.063542f, 1.267742f, 3.801790f, 2.253912f, 5.217149f, 0.776267f, 1.882941f, 0.819832f, 3.164651f, 1.919983f, 5.038523f, 3.226108f, 6.047485f,
0.276565f, 0.523196f, 0.085123f, 0.775280f, 0.409887f, 1.386488f, 0.818835f, 1.709820f, 0.072367f, 0.197999f, 0.085878f, 0.299048f, 0.491298f, 1.454271f, 0.927582f, 1.568577f,
0.335349f, 0.913388f, 0.146826f, 1.495752f, 0.436319f, 2.124945f, 1.239915f, 2.895956f, 0.257165f, 1.013031f, 0.434117f, 1.690873f, 0.560292f, 2.387846f, 1.504795f, 2.846276f,
0.074089f, 0.239144f, 0.034880f, 0.289262f, 0.146998f, 0.848404f, 0.449169f, 0.854031f, 0.069284f, 0.323439f, 0.125759f, 0.398757f, 0.150470f, 0.759959f, 0.434534f, 0.669095f,
0.487873f, 1.019642f, 0.137387f, 1.692997f, 0.639881f, 2.391249f, 1.169551f, 3.304254f, 0.439712f, 1.329112f, 0.477414f, 2.249335f, 0.704056f, 2.302401f, 1.216192f, 2.782633f,
0.248315f, 0.572336f, 0.071185f, 0.720108f, 0.356997f, 1.471286f, 0.664245f, 1.540580f, 0.086822f, 0.289422f, 0.095963f, 0.371161f, 0.549786f, 1.982782f, 0.966792f, 1.815885f,
0.423177f, 1.404306f, 0.172569f, 1.952625f, 0.534102f, 3.169190f, 1.413655f, 3.667290f, 0.433630f, 2.081188f, 0.681783f, 2.949528f, 0.881216f, 4.575677f, 2.204334f, 4.631043f,
0.206054f, 0.810343f, 0.090351f, 0.832248f, 0.396582f, 2.788727f, 1.128662f, 2.383581f, 0.257480f, 1.464483f, 0.435293f, 1.533036f, 0.521580f, 3.209537f, 1.402901f, 2.399345f,
0.561596f, 1.430030f, 0.147297f, 2.016074f, 0.714513f, 3.253244f, 1.216360f, 3.816962f, 0.676343f, 2.490815f, 0.683953f, 3.579206f, 1.010104f, 4.024587f, 1.625150f, 4.129989f,
0.078405f, 0.180406f, 0.023917f, 0.221796f, 0.174480f, 0.717852f, 0.345449f, 0.734475f, 0.037585f, 0.125075f, 0.044204f, 0.156732f, 0.224010f, 0.806504f, 0.419163f, 0.721730f,
0.123923f, 0.410533f, 0.053773f, 0.557777f, 0.242098f, 1.434077f, 0.681846f, 1.621529f, 0.174096f, 0.834137f, 0.291266f, 1.155137f, 0.332999f, 1.726130f, 0.886367f, 1.707072f,
0.055385f, 0.217437f, 0.025841f, 0.218209f, 0.164998f, 1.158266f, 0.499671f, 0.967358f, 0.094883f, 0.538751f, 0.170688f, 0.551076f, 0.180909f, 1.111318f, 0.517775f, 0.811790f,
0.222363f, 0.565252f, 0.062060f, 0.778679f, 0.437912f, 1.990448f, 0.793258f, 2.281956f, 0.367152f, 1.349825f, 0.395076f, 1.895299f, 0.516103f, 2.052812f, 0.883567f, 2.058410f,
0.447876f, 0.704792f, 0.127934f, 1.070866f, 0.625973f, 1.761342f, 1.160550f, 2.227191f, 0.107772f, 0.245280f, 0.118692f, 0.379857f, 1.027665f, 2.530394f, 1.800674f, 2.798519f,
0.549880f, 1.245840f, 0.223435f, 2.091925f, 0.674693f, 2.733286f, 1.779383f, 3.819522f, 0.387780f, 1.270669f, 0.607514f, 2.174705f, 1.186673f, 4.206869f, 2.957808f, 5.141730f,
0.337675f, 0.906655f, 0.147535f, 1.124483f, 0.631812f, 3.033302f, 1.791689f, 3.130880f, 0.290390f, 1.127660f, 0.489175f, 1.425519f, 0.885814f, 3.721505f, 2.374064f, 3.359664f,
0.905705f, 1.574574f, 0.236702f, 2.680718f, 1.120236f, 3.482338f, 1.900226f, 4.933997f, 0.750672f, 1.887469f, 0.756404f, 3.275306f, 1.688232f, 4.592426f, 2.706471f, 5.691106f,
0.506835f, 0.837917f, 0.134686f, 1.242180f, 0.799792f, 2.364266f, 1.379469f, 2.916887f, 0.115194f, 0.275434f, 0.118025f, 0.416183f, 0.798056f, 2.064435f, 1.300899f, 2.227670f,
0.663579f, 1.579495f, 0.250843f, 2.587686f, 0.919270f, 3.912494f, 2.255450f, 5.334418f, 0.442003f, 1.521612f, 0.644203f, 2.540863f, 0.982718f, 3.660058f, 2.278737f, 4.364633f,
0.122731f, 0.346200f, 0.049885f, 0.418935f, 0.259271f, 1.307714f, 0.683998f, 1.316962f, 0.099690f, 0.406704f, 0.156228f, 0.501629f, 0.220937f, 0.975161f, 0.550865f, 0.858940f,
0.875181f, 1.598474f, 0.212784f, 2.655236f, 1.222175f, 3.991407f, 1.928660f, 5.517769f, 0.685136f, 1.809830f, 0.642254f, 3.064216f, 1.119480f, 3.199321f, 1.669607f, 3.868314f,
0.581673f, 1.171640f, 0.143968f, 1.474790f, 0.890396f, 3.206886f, 1.430375f, 3.359383f, 0.176654f, 0.514627f, 0.168577f, 0.660257f, 1.141532f, 3.597799f, 1.733126f, 3.296395f,
1.070346f, 3.104064f, 0.376848f, 4.317941f, 1.438364f, 7.458652f, 3.286933f, 8.634684f, 0.952662f, 3.995753f, 1.293209f, 5.665375f, 1.975618f, 8.964852f, 4.266782f, 9.077278f,
0.436302f, 1.499484f, 0.165173f, 1.540689f, 0.894092f, 5.494428f, 2.196927f, 4.698242f, 0.473552f, 2.353834f, 0.691207f, 2.465090f, 0.978917f, 5.264224f, 2.273287f, 3.937076f,
1.287717f, 2.865558f, 0.291605f, 4.041656f, 1.744416f, 6.941028f, 2.563920f, 8.147307f, 1.347044f, 4.335345f, 1.176099f, 6.232438f, 2.052966f, 7.148322f, 2.851750f, 7.338728f,
0.222133f, 0.446670f, 0.058503f, 0.549386f, 0.526327f, 1.892402f, 0.899701f, 1.937067f, 0.092491f, 0.268983f, 0.093918f, 0.337209f, 0.562541f, 1.769948f, 0.908808f, 1.584594f,
0.379093f, 1.097513f, 0.142024f, 1.491801f, 0.788548f, 4.082037f, 1.917457f, 4.617619f, 0.462594f, 1.936943f, 0.668198f, 2.683503f, 0.902934f, 4.090283f, 2.075052f, 4.046886f,
0.141836f, 0.486630f, 0.057137f, 0.488570f, 0.449904f, 2.760050f, 1.176328f, 2.306137f, 0.211060f, 1.047302f, 0.327811f, 1.071727f, 0.410654f, 2.204564f, 1.014754f, 1.611080f,
0.616669f, 1.369929f, 0.148594f, 1.888007f, 1.293062f, 5.136299f, 2.022317f, 5.891090f, 0.884408f, 2.841528f, 0.821657f, 3.991548f, 1.268658f, 4.409854f, 1.875210f, 4.423806f,
0.852626f, 1.172543f, 0.210276f, 1.782344f, 1.268818f, 3.120000f, 2.031001f, 3.946911f, 0.178207f, 0.354444f, 0.169451f, 0.549155f, 1.734087f, 3.731424f, 2.623354f, 4.128609f,
1.130301f, 2.237977f, 0.396533f, 3.759487f, 1.476643f, 5.227833f, 3.362337f, 7.308607f, 0.692356f, 1.982641f, 0.936490f, 3.394697f, 2.162102f, 6.698401f, 4.652834f, 8.190502f,
0.581071f, 1.363451f, 0.219193f, 1.691763f, 1.157608f, 4.856871f, 2.834254f, 5.015293f, 0.434041f, 1.472970f, 0.631271f, 1.862850f, 1.351113f, 4.960611f, 3.126397f, 4.480241f,
1.687749f, 2.564198f, 0.380825f, 4.367457f, 2.222665f, 6.038130f, 3.255159f, 8.558932f, 1.215038f, 2.669848f, 1.057051f, 4.634978f, 2.788510f, 6.629022f, 3.859632f, 8.218508f,
};

static const float acceptor_me2x3acc2[16384] = {
0.028739f, 0.051428f, 0.000313f, 0.073324f, 0.034680f, 0.087951f, 0.021917f, 0.102035f, 0.000252f, 0.000765f, 0.000211f, 0.001303f, 0.086087f, 0.188764f, 0.066268f, 0.215400f,
0.034283f, 0.056280f, 0.000377f, 0.081658f, 0.058641f, 0.136431f, 0.037455f, 0.161069f, 0.023430f, 0.065190f, 0.019763f, 0.112954f, 0.091516f, 0.184088f, 0.071197f, 0.213767f,
0.000407f, 0.000736f, 0.000005f, 0.000961f, 0.000959f, 0.002458f, 0.000722f, 0.002610f, 0.000251f, 0.000770f, 0.000250f, 0.001200f, 0.001973f, 0.004369f, 0.001807f, 0.004564f,
0.056136f, 0.110463f, 0.000789f, 0.143996f, 0.140495f, 0.391797f, 0.114664f, 0.415578f, 0.037582f, 0.125335f, 0.040506f, 0.195116f, 0.152611f, 0.367964f, 0.151713f, 0.383898f,
0.035291f, 0.086949f, 0.000364f, 0.110031f, 0.040326f, 0.140805f, 0.024134f, 0.144985f, 0.000333f, 0.001390f, 0.000263f, 0.002100f, 0.096583f, 0.291575f, 0.070407f, 0.295308f,
0.059092f, 0.133562f, 0.000615f, 0.171997f, 0.095713f, 0.306585f, 0.057892f, 0.321253f, 0.043382f, 0.166183f, 0.034652f, 0.255569f, 0.144117f, 0.399132f, 0.106178f, 0.411368f,
0.026513f, 0.065985f, 0.000325f, 0.076430f, 0.059155f, 0.208640f, 0.042131f, 0.196639f, 0.017575f, 0.074131f, 0.016530f, 0.102541f, 0.117347f, 0.357850f, 0.101800f, 0.331735f,
0.084513f, 0.228965f, 0.001124f, 0.264913f, 0.200288f, 0.768999f, 0.154800f, 0.723963f, 0.060777f, 0.279067f, 0.062035f, 0.385591f, 0.209909f, 0.696825f, 0.197614f, 0.645258f,
0.000302f, 0.001475f, 0.000005f, 0.001613f, 0.000400f, 0.002769f, 0.000416f, 0.002464f, 0.000003f, 0.000028f, 0.000005f, 0.000037f, 0.001070f, 0.006402f, 0.001353f, 0.005604f,
0.000430f, 0.001928f, 0.000008f, 0.002146f, 0.000808f, 0.005130f, 0.000848f, 0.004646f, 0.000376f, 0.002852f, 0.000521f, 0.003791f, 0.001358f, 0.007457f, 0.001737f, 0.006643f,
0.000177f, 0.000874f, 0.000004f, 0.000875f, 0.000458f, 0.003203f, 0.000566f, 0.002609f, 0.000140f, 0.001167f, 0.000228f, 0.001395f, 0.001014f, 0.006133f, 0.001527f, 0.004914f,
0.000826f, 0.004438f, 0.000019f, 0.004438f, 0.002270f, 0.017278f, 0.003045f, 0.014059f, 0.000707f, 0.006432f, 0.001252f, 0.007681f, 0.002656f, 0.017481f, 0.004340f, 0.013991f,
0.091342f, 0.202450f, 0.001093f, 0.214612f, 0.085940f, 0.269942f, 0.059752f, 0.232843f, 0.000775f, 0.002911f, 0.000711f, 0.003685f, 0.256620f, 0.696928f, 0.217328f, 0.591287f,
0.156262f, 0.317725f, 0.001890f, 0.342749f, 0.208397f, 0.600508f, 0.146437f, 0.527108f, 0.103177f, 0.355557f, 0.095746f, 0.458055f, 0.391221f, 0.974695f, 0.334848f, 0.841529f,
0.064571f, 0.144564f, 0.000920f, 0.140269f, 0.118620f, 0.376366f, 0.098146f, 0.297145f, 0.038496f, 0.146072f, 0.042064f, 0.169259f, 0.293377f, 0.804820f, 0.295672f, 0.624993f,
0.163052f, 0.397389f, 0.002520f, 0.385156f, 0.318167f, 1.098934f, 0.285680f, 0.866659f, 0.105462f, 0.435623f, 0.125055f, 0.504214f, 0.415736f, 1.241521f, 0.454686f, 0.963052f,
0.026316f, 0.066875f, 0.000385f, 0.071194f, 0.027083f, 0.097539f, 0.023015f, 0.084491f, 0.000232f, 0.000998f, 0.000260f, 0.001268f, 0.068795f, 0.214218f, 0.071208f, 0.182519f,
0.047793f, 0.111420f, 0.000706f, 0.120706f, 0.069721f, 0.230352f, 0.059878f, 0.203055f, 0.032741f, 0.129366f, 0.037134f, 0.167367f, 0.111340f, 0.318055f, 0.116473f, 0.275767f,
0.000575f, 0.001475f, 0.000010f, 0.001438f, 0.001155f, 0.004202f, 0.001168f, 0.003331f, 0.000356f, 0.001547f, 0.000475f, 0.001800f, 0.002430f, 0.007643f, 0.002993f, 0.005961f,
0.074404f, 0.207915f, 0.001405f, 0.202370f, 0.158812f, 0.628929f, 0.174283f, 0.498102f, 0.049930f, 0.236471f, 0.072362f, 0.274867f, 0.176525f, 0.604427f, 0.235963f, 0.470846f,
0.054146f, 0.189449f, 0.000750f, 0.179006f, 0.052768f, 0.261648f, 0.042464f, 0.201163f, 0.000512f, 0.003036f, 0.000544f, 0.003425f, 0.129323f, 0.554431f, 0.126764f, 0.419274f,
0.138031f, 0.443047f, 0.001932f, 0.426005f, 0.190673f, 0.867340f, 0.155075f, 0.678594f, 0.101575f, 0.552570f, 0.109099f, 0.634505f, 0.293786f, 1.155453f, 0.291040f, 0.889184f,
0.062705f, 0.221615f, 0.001034f, 0.191664f, 0.119315f, 0.597617f, 0.114264f, 0.420552f, 0.041664f, 0.249567f, 0.052693f, 0.257758f, 0.242201f, 1.048876f, 0.282525f, 0.726005f,
0.187688f, 0.722103f, 0.003357f, 0.623820f, 0.379347f, 2.068363f, 0.394237f, 1.453927f, 0.135296f, 0.882213f, 0.185688f, 0.910157f, 0.406828f, 1.917883f, 0.514992f, 1.326040f,
0.016347f, 0.113386f, 0.000393f, 0.092596f, 0.018467f, 0.181521f, 0.025793f, 0.120620f, 0.000184f, 0.002160f, 0.000339f, 0.002107f, 0.050532f, 0.429464f, 0.085970f, 0.280696f,
0.035459f, 0.225629f, 0.000862f, 0.187508f, 0.056779f, 0.512010f, 0.080149f, 0.346225f, 0.031026f, 0.334591f, 0.057839f, 0.332064f, 0.097679f, 0.761570f, 0.167950f, 0.506534f,
0.014776f, 0.103528f, 0.000423f, 0.077385f, 0.032592f, 0.323613f, 0.054173f, 0.196826f, 0.011674f, 0.138621f, 0.025625f, 0.123741f, 0.073868f, 0.634155f, 0.149554f, 0.379377f,
0.064742f, 0.493788f, 0.002010f, 0.368689f, 0.151681f, 1.639505f, 0.273598f, 0.996066f, 0.055491f, 0.717295f, 0.132184f, 0.639588f, 0.181625f, 1.697372f, 0.399048f, 1.014311f,
0.080868f, 0.254532f, 0.001301f, 0.201467f, 0.064889f, 0.289445f, 0.060664f, 0.186416f, 0.000688f, 0.003668f, 0.000849f, 0.003467f, 0.198274f, 0.764682f, 0.225784f, 0.484414f,
0.210619f, 0.608155f, 0.003425f, 0.489853f, 0.239556f, 0.980286f, 0.226344f, 0.642480f, 0.139400f, 0.682192f, 0.173941f, 0.656207f, 0.460188f, 1.628172f, 0.529620f, 1.049605f,
0.088118f, 0.280163f, 0.001687f, 0.202973f, 0.138058f, 0.622059f, 0.153596f, 0.366703f, 0.052660f, 0.283761f, 0.077371f, 0.245506f, 0.349402f, 1.361186f, 0.473493f, 0.789258f,
0.208946f, 0.723173f, 0.004342f, 0.523345f, 0.347723f, 1.705565f, 0.419819f, 1.004315f, 0.135468f, 0.794642f, 0.215996f, 0.686752f, 0.464936f, 1.971734f, 0.683739f, 1.142007f,
0.000383f, 0.000697f, 0.000006f, 0.001236f, 0.000447f, 0.001154f, 0.000387f, 0.001666f, 0.000005f, 0.000014f, 0.000005f, 0.000030f, 0.001259f, 0.002809f, 0.001326f, 0.003989f,
0.000625f, 0.001044f, 0.000009f, 0.001886f, 0.001036f, 0.002452f, 0.000905f, 0.003603f, 0.000582f, 0.001647f, 0.000671f, 0.003551f, 0.001833f, 0.003753f, 0.001952f, 0.005424f,
0.000008f, 0.000015f, 0.000000f, 0.000025f, 0.000019f, 0.000049f, 0.000020f, 0.000065f, 0.000007f, 0.000022f, 0.000009f, 0.000042f, 0.000044f, 0.000100f, 0.000055f, 0.000129f,
0.000883f, 0.001769f, 0.000017f, 0.002870f, 0.002141f, 0.006077f, 0.002392f, 0.008022f, 0.000805f, 0.002732f, 0.001188f, 0.005293f, 0.002638f, 0.006474f, 0.003590f, 0.008406f,
0.000702f, 0.001760f, 0.000010f, 0.002771f, 0.000777f, 0.002760f, 0.000636f, 0.003537f, 0.000009f, 0.000038f, 0.000010f, 0.000072f, 0.002110f, 0.006482f, 0.002105f, 0.008171f,
0.001610f, 0.003703f, 0.000023f, 0.005935f, 0.002526f, 0.008233f, 0.002091f, 0.010736f, 0.001609f, 0.006271f, 0.001759f, 0.012004f, 0.004314f, 0.012158f, 0.004350f, 0.015595f,
0.000808f, 0.002046f, 0.000014f, 0.002949f, 0.001745f, 0.006265f, 0.001702f, 0.007348f, 0.000729f, 0.003128f, 0.000938f, 0.005385f, 0.003928f, 0.012188f, 0.004664f, 0.014062f,
0.001987f, 0.005479f, 0.000036f, 0.007889f, 0.004561f, 0.017820f, 0.004825f, 0.020880f, 0.001945f, 0.009089f, 0.002718f, 0.015629f, 0.005422f, 0.018317f, 0.006987f, 0.021110f,
0.000168f, 0.000834f, 0.000004f, 0.001135f, 0.000215f, 0.001516f, 0.000306f, 0.001679f, 0.000003f, 0.000022f, 0.000005f, 0.000035f, 0.000653f, 0.003977f, 0.001131f, 0.004332f,
0.000328f, 0.001494f, 0.000008f, 0.002069f, 0.000596f, 0.003849f, 0.000856f, 0.004338f, 0.000389f, 0.003008f, 0.000739f, 0.004975f, 0.001136f, 0.006346f, 0.001988f, 0.007036f,
0.000151f, 0.000757f, 0.000004f, 0.000943f, 0.000378f, 0.002687f, 0.000639f, 0.002724f, 0.000162f, 0.001376f, 0.000361f, 0.002047f, 0.000949f, 0.005836f, 0.001955f, 0.005820f,
0.000543f, 0.002967f, 0.000017f, 0.003693f, 0.001444f, 0.011187f, 0.002652f, 0.011329f, 0.000632f, 0.005852f, 0.001532f, 0.008698f, 0.001917f, 0.012839f, 0.004288f, 0.012789f,
0.002140f, 0.004828f, 0.000035f, 0.006369f, 0.001950f, 0.006234f, 0.001856f, 0.006693f, 0.000025f, 0.000094f, 0.000031f, 0.000149f, 0.006606f, 0.018258f, 0.007658f, 0.019279f,
0.005017f, 0.010381f, 0.000083f, 0.013937f, 0.006480f, 0.019001f, 0.006233f, 0.020758f, 0.004509f, 0.015811f, 0.005727f, 0.025351f, 0.013799f, 0.034985f, 0.016166f, 0.037592f,
0.002318f, 0.005281f, 0.000045f, 0.006378f, 0.004124f, 0.013316f, 0.004671f, 0.013084f, 0.001881f, 0.007263f, 0.002813f, 0.010475f, 0.011571f, 0.032301f, 0.015962f, 0.031219f,
0.004518f, 0.011204f, 0.000096f, 0.013515f, 0.008537f, 0.030008f, 0.010493f, 0.029453f, 0.003977f, 0.016717f, 0.006455f, 0.024082f, 0.012655f, 0.038456f, 0.018944f, 0.037126f,
0.051204f, 0.124938f, 0.000859f, 0.177101f, 0.062222f, 0.215159f, 0.060612f, 0.248166f, 0.000471f, 0.001948f, 0.000606f, 0.003298f, 0.120455f, 0.360131f, 0.142925f, 0.408566f,
0.064977f, 0.145444f, 0.001101f, 0.209803f, 0.111920f, 0.355038f, 0.110186f, 0.416723f, 0.046539f, 0.176557f, 0.060508f, 0.304147f, 0.136214f, 0.373602f, 0.163346f, 0.431320f,
0.000826f, 0.002036f, 0.000016f, 0.002641f, 0.001960f, 0.006846f, 0.002272f, 0.007227f, 0.000534f, 0.002231f, 0.000818f, 0.003458f, 0.003143f, 0.009491f, 0.004437f, 0.009855f,
0.097248f, 0.260922f, 0.002106f, 0.338160f, 0.245088f, 0.931919f, 0.308324f, 0.982755f, 0.068231f, 0.310267f, 0.113356f, 0.480209f, 0.207619f, 0.682565f, 0.318142f, 0.707995f,
0.123843f, 0.416040f, 0.001966f, 0.523432f, 0.142502f, 0.678440f, 0.131459f, 0.694533f, 0.001224f, 0.006970f, 0.001491f, 0.010472f, 0.266168f, 1.095634f, 0.299083f, 1.103229f,
0.220589f, 0.679821f, 0.003540f, 0.870383f, 0.359788f, 1.571398f, 0.335440f, 1.637032f, 0.169718f, 0.886471f, 0.208965f, 1.355387f, 0.422487f, 1.595411f, 0.479789f, 1.634793f,
0.105928f, 0.359457f, 0.002002f, 0.413942f, 0.237989f, 1.144517f, 0.261266f, 1.072431f, 0.073587f, 0.423221f, 0.106686f, 0.582025f, 0.368181f, 1.530900f, 0.492330f, 1.410954f,
0.288361f, 1.065216f, 0.005913f, 1.225316f, 0.688157f, 3.602606f, 0.819830f, 3.371965f, 0.217329f, 1.360643f, 0.341926f, 1.869123f, 0.562453f, 2.545868f, 0.816190f, 2.343803f,
0.029090f, 0.193726f, 0.000802f, 0.210656f, 0.038800f, 0.366191f, 0.062123f, 0.324003f, 0.000342f, 0.003859f, 0.000723f, 0.005011f, 0.080916f, 0.660285f, 0.157807f, 0.574634f,
0.044089f, 0.269356f, 0.001228f, 0.298059f, 0.083355f, 0.721709f, 0.134884f, 0.649819f, 0.040332f, 0.417618f, 0.086190f, 0.551871f, 0.109287f, 0.818122f, 0.215410f, 0.724548f,
0.019421f, 0.130645f, 0.000637f, 0.130030f, 0.050577f, 0.482183f, 0.096370f, 0.390498f, 0.016041f, 0.182893f, 0.040365f, 0.217385f, 0.087364f, 0.720122f, 0.202761f, 0.573629f,
0.077388f, 0.566718f, 0.002754f, 0.563426f, 0.214078f, 2.221724f, 0.442657f, 1.797280f, 0.069349f, 0.860709f, 0.189371f, 1.021902f, 0.195362f, 1.752986f, 0.492044f, 1.394835f,
0.171461f, 0.518168f, 0.003163f, 0.546113f, 0.162447f, 0.695738f, 0.174095f, 0.596641f, 0.001524f, 0.007807f, 0.002157f, 0.009826f, 0.378295f, 1.400827f, 0.493826f, 1.181600f,
0.312025f, 0.865059f, 0.005817f, 0.927784f, 0.419036f, 1.646399f, 0.453866f, 1.436787f, 0.215918f, 1.014543f, 0.308847f, 1.299435f, 0.613483f, 2.084043f, 0.809371f, 1.788885f,
0.137994f, 0.421254f, 0.003029f, 0.406369f, 0.255274f, 1.104375f, 0.325567f, 0.866861f, 0.086220f, 0.446086f, 0.145219f, 0.513900f, 0.492375f, 1.841731f, 0.764890f, 1.421929f,
0.297591f, 0.988932f, 0.007089f, 0.952935f, 0.584750f, 2.753875f, 0.809309f, 2.159218f, 0.201723f, 1.136130f, 0.368705f, 1.307397f, 0.595873f, 2.426320f, 1.004539f, 1.871195f,
0.047557f, 0.085104f, 0.000517f, 0.121339f, 0.078073f, 0.197998f, 0.049340f, 0.229704f, 0.000441f, 0.001336f, 0.000368f, 0.002275f, 0.126792f, 0.278017f, 0.097602f, 0.317246f,
0.046567f, 0.076447f, 0.000512f, 0.110918f, 0.108363f, 0.252109f, 0.069212f, 0.297636f, 0.033582f, 0.093436f, 0.028326f, 0.161897f, 0.110637f, 0.222552f, 0.086073f, 0.258432f,
0.000479f, 0.000866f, 0.000006f, 0.001130f, 0.001536f, 0.003934f, 0.001155f, 0.004178f, 0.000312f, 0.000956f, 0.000310f, 0.001490f, 0.002066f, 0.004576f, 0.001893f, 0.004779f,
0.078339f, 0.154152f, 0.001100f, 0.200948f, 0.266726f, 0.743814f, 0.217687f, 0.788962f, 0.055340f, 0.184561f, 0.059647f, 0.287315f, 0.189548f, 0.457024f, 0.188432f, 0.476814f,
0.067036f, 0.165163f, 0.000691f, 0.209008f, 0.104209f, 0.363863f, 0.062367f, 0.374666f, 0.000667f, 0.002786f, 0.000527f, 0.004210f, 0.163286f, 0.492947f, 0.119032f, 0.499258f,
0.092136f, 0.208250f, 0.000959f, 0.268179f, 0.203022f, 0.650316f, 0.122798f, 0.681428f, 0.071374f, 0.273414f, 0.057012f, 0.420478f, 0.199994f, 0.553885f, 0.147345f, 0.570865f,
0.035811f, 0.089124f, 0.000439f, 0.103231f, 0.108695f, 0.383369f, 0.077414f, 0.361318f, 0.025048f, 0.105652f, 0.023559f, 0.146143f, 0.141066f, 0.430180f, 0.122377f, 0.398787f,
0.135380f, 0.366775f, 0.001801f, 0.424361f, 0.436472f, 1.675822f, 0.337344f, 1.577679f, 0.102731f, 0.471707f, 0.104857f, 0.651764f, 0.299270f, 0.993471f, 0.281741f, 0.919951f,
0.000415f, 0.002027f, 0.000007f, 0.002217f, 0.000748f, 0.005176f, 0.000777f, 0.004606f, 0.000005f, 0.000041f, 0.000007f, 0.000053f, 0.001308f, 0.007829f, 0.001655f, 0.006853f,
0.000485f, 0.002174f, 0.000009f, 0.002420f, 0.001240f, 0.007871f, 0.001301f, 0.007128f, 0.000447f, 0.003394f, 0.000620f, 0.004512f, 0.001363f, 0.007485f, 0.001743f, 0.006668f,
0.000173f, 0.000854f, 0.000004f, 0.000855f, 0.000609f, 0.004256f, 0.000753f, 0.003467f, 0.000144f, 0.001203f, 0.000235f, 0.001438f, 0.000882f, 0.005333f, 0.001328f, 0.004273f,
0.000957f, 0.005142f, 0.000022f, 0.005142f, 0.003578f, 0.027236f, 0.004800f, 0.022161f, 0.000864f, 0.007864f, 0.001530f, 0.009391f, 0.002739f, 0.018027f, 0.004476f, 0.014428f,
0.168930f, 0.374418f, 0.002022f, 0.396911f, 0.216224f, 0.679172f, 0.150335f, 0.585830f, 0.001512f, 0.005680f, 0.001388f, 0.007191f, 0.422406f, 1.147167f, 0.357730f, 0.973279f,
0.237216f, 0.482329f, 0.002869f, 0.520318f, 0.430383f, 1.240170f, 0.302421f, 1.088586f, 0.165276f, 0.569552f, 0.153371f, 0.733740f, 0.528584f, 1.316924f, 0.452419f, 1.137001f,
0.084913f, 0.190107f, 0.001209f, 0.184459f, 0.212210f, 0.673317f, 0.175583f, 0.531590f, 0.053418f, 0.202693f, 0.058369f, 0.234868f, 0.343371f, 0.941970f, 0.346058f, 0.731498f,
0.254301f, 0.619779f, 0.003930f, 0.600700f, 0.675066f, 2.331647f, 0.606138f, 1.838821f, 0.173560f, 0.716908f, 0.205804f, 0.829789f, 0.577083f, 1.723355f, 0.631149f, 1.336812f,
0.060412f, 0.153524f, 0.000884f, 0.163438f, 0.084583f, 0.304622f, 0.071876f, 0.263872f, 0.000561f, 0.002416f, 0.000630f, 0.003072f, 0.140562f, 0.437691f, 0.145492f, 0.372922f,
0.090059f, 0.209956f, 0.001331f, 0.227455f, 0.178731f, 0.590510f, 0.153498f, 0.520534f, 0.065101f, 0.257227f, 0.073837f, 0.332786f, 0.186732f, 0.533416f, 0.195339f, 0.462495f,
0.000938f, 0.002408f, 0.000016f, 0.002347f, 0.002565f, 0.009331f, 0.002594f, 0.007398f, 0.000612f, 0.002664f, 0.000818f, 0.003100f, 0.003530f, 0.011104f, 0.004349f, 0.008660f,
0.144041f, 0.402512f, 0.002721f, 0.391778f, 0.418260f, 1.656399f, 0.459005f, 1.311843f, 0.101997f, 0.483062f, 0.147821f, 0.561496f, 0.304157f, 1.041446f, 0.406572f, 0.811283f,
0.142685f, 0.499232f, 0.001976f, 0.471713f, 0.189168f, 0.937989f, 0.152229f, 0.721155f, 0.001423f, 0.008441f, 0.001513f, 0.009524f, 0.303310f, 1.300342f, 0.297308f, 0.983348f,
0.298566f, 0.958325f, 0.004180f, 0.921463f, 0.561077f, 2.552250f, 0.456327f, 1.996843f, 0.231837f, 1.261195f, 0.249009f, 1.448206f, 0.565581f, 2.224413f, 0.560295f, 1.711808f,
0.117492f, 0.415250f, 0.001937f, 0.359129f, 0.304142f, 1.523361f, 0.291264f, 1.072012f, 0.082376f, 0.493434f, 0.104182f, 0.509627f, 0.403911f, 1.749175f, 0.471157f, 1.210734f,
0.417088f, 1.604688f, 0.007461f, 1.386280f, 1.146828f, 6.253006f, 1.191843f, 4.395464f, 0.317254f, 2.068696f, 0.435419f, 2.134223f, 0.804642f, 3.793268f, 1.018574f, 2.622698f,
0.031159f, 0.216123f, 0.000749f, 0.176496f, 0.047885f, 0.470696f, 0.066882f, 0.312774f, 0.000370f, 0.004345f, 0.000682f, 0.004237f, 0.085725f, 0.728566f, 0.145844f, 0.476188f,
0.055479f, 0.353013f, 0.001348f, 0.293370f, 0.120852f, 1.089795f, 0.170595f, 0.736928f, 0.051222f, 0.552386f, 0.095487f, 0.548214f, 0.136018f, 1.060489f, 0.233871f, 0.705351f,
0.020027f, 0.140314f, 0.000573f, 0.104882f, 0.060093f, 0.596676f, 0.099883f, 0.362906f, 0.016695f, 0.198245f, 0.036647f, 0.176965f, 0.089105f, 0.764959f, 0.180402f, 0.457628f,
0.104067f, 0.793717f, 0.003231f, 0.592632f, 0.331686f, 3.585154f, 0.598285f, 2.178127f, 0.094119f, 1.216619f, 0.224200f, 1.084818f, 0.259837f, 2.428296f, 0.570887f, 1.451095f,
0.207479f, 0.653042f, 0.003339f, 0.516895f, 0.226485f, 1.010265f, 0.211738f, 0.650657f, 0.001862f, 0.009931f, 0.002298f, 0.009387f, 0.452756f, 1.746143f, 0.515576f, 1.106154f,
0.443557f, 1.280758f, 0.007214f, 1.031616f, 0.686326f, 2.808508f, 0.648472f, 1.840697f, 0.309776f, 1.515972f, 0.386534f, 1.458227f, 0.862556f, 3.051776f, 0.992697f, 1.967334f,
0.160755f, 0.511104f, 0.003078f, 0.370285f, 0.342633f, 1.543835f, 0.381196f, 0.910088f, 0.101371f, 0.546239f, 0.148940f, 0.472599f, 0.567315f, 2.210121f, 0.768797f, 1.281496f,
0.452080f, 1.564671f, 0.009395f, 1.132320f, 1.023492f, 5.020184f, 1.235700f, 2.956115f, 0.309279f, 1.814195f, 0.493126f, 1.567880f, 0.895310f, 3.796899f, 1.316652f, 2.199124f,
0.023864f, 0.043458f, 0.000355f, 0.077115f, 0.037942f, 0.097919f, 0.032822f, 0.141382f, 0.000301f, 0.000929f, 0.000344f, 0.001968f, 0.069898f, 0.155966f, 0.073649f, 0.221500f,
0.032016f, 0.053485f, 0.000482f, 0.096581f, 0.072153f, 0.170824f, 0.063080f, 0.250995f, 0.031425f, 0.088975f, 0.036282f, 0.191872f, 0.083565f, 0.171058f, 0.088988f, 0.247216f,
0.000368f, 0.000678f, 0.000007f, 0.001101f, 0.001143f, 0.002981f, 0.001177f, 0.003940f, 0.000326f, 0.001018f, 0.000444f, 0.001974f, 0.001745f, 0.003933f, 0.002188f, 0.005112f,
0.046480f, 0.093073f, 0.000894f, 0.151000f, 0.153264f, 0.434937f, 0.171217f, 0.574164f, 0.044690f, 0.151669f, 0.065932f, 0.293855f, 0.123551f, 0.303147f, 0.168120f, 0.393624f,
0.050260f, 0.126014f, 0.000709f, 0.198466f, 0.075668f, 0.268863f, 0.061987f, 0.344552f, 0.000681f, 0.002893f, 0.000737f, 0.005441f, 0.134494f, 0.413185f, 0.134203f, 0.520820f,
0.094646f, 0.217692f, 0.001349f, 0.348900f, 0.201977f, 0.658371f, 0.167221f, 0.858588f, 0.099791f, 0.389010f, 0.109109f, 0.744564f, 0.225698f, 0.636089f, 0.227607f, 0.815925f,
0.041133f, 0.104174f, 0.000690f, 0.150173f, 0.120913f, 0.433980f, 0.117875f, 0.509049f, 0.039159f, 0.168084f, 0.050415f, 0.289363f, 0.178007f, 0.552401f, 0.211375f, 0.637328f,
0.120013f, 0.330872f, 0.002185f, 0.476445f, 0.374728f, 1.464117f, 0.396436f, 1.715475f, 0.123953f, 0.579181f, 0.173178f, 0.995979f, 0.291457f, 0.984588f, 0.375578f, 1.134704f,
0.008693f, 0.043205f, 0.000213f, 0.058811f, 0.015170f, 0.106854f, 0.021569f, 0.118351f, 0.000140f, 0.001179f, 0.000263f, 0.001917f, 0.030105f, 0.183347f, 0.052139f, 0.199745f,
0.013929f, 0.063509f, 0.000345f, 0.087974f, 0.034455f, 0.222643f, 0.049511f, 0.250947f, 0.017461f, 0.134939f, 0.033137f, 0.223223f, 0.042988f, 0.240174f, 0.075243f, 0.266267f,
0.005553f, 0.027878f, 0.000162f, 0.034734f, 0.018921f, 0.134624f, 0.032014f, 0.136481f, 0.006285f, 0.053483f, 0.014045f, 0.079578f, 0.031101f, 0.191327f, 0.064098f, 0.190785f,
0.023715f, 0.129614f, 0.000750f, 0.161311f, 0.085835f, 0.664832f, 0.157608f, 0.673256f, 0.029123f, 0.269767f, 0.070622f, 0.400945f, 0.074540f, 0.499183f, 0.166715f, 0.497218f,
0.149244f, 0.336616f, 0.002445f, 0.444108f, 0.185004f, 0.591352f, 0.176067f, 0.634828f, 0.001818f, 0.006950f, 0.002285f, 0.010951f, 0.409977f, 1.133039f, 0.475253f, 1.196392f,
0.287136f, 0.594121f, 0.004754f, 0.797661f, 0.504530f, 1.479453f, 0.485271f, 1.616221f, 0.272292f, 0.954877f, 0.345868f, 1.530997f, 0.702907f, 1.782102f, 0.823501f, 1.914921f,
0.114927f, 0.261840f, 0.002240f, 0.316196f, 0.278166f, 0.898143f, 0.315036f, 0.882513f, 0.098405f, 0.379978f, 0.147182f, 0.547976f, 0.510568f, 1.425329f, 0.704333f, 1.377557f,
0.265639f, 0.658824f, 0.005620f, 0.794710f, 0.682935f, 2.400403f, 0.839353f, 2.356019f, 0.246761f, 1.037240f, 0.400516f, 1.494174f, 0.662252f, 2.012556f, 0.991419f, 1.942950f,
0.095690f, 0.233483f, 0.001604f, 0.330964f, 0.158188f, 0.547003f, 0.154095f, 0.630917f, 0.000929f, 0.003842f, 0.001195f, 0.006504f, 0.200347f, 0.598991f, 0.237722f, 0.679550f,
0.099671f, 0.223105f, 0.001689f, 0.321829f, 0.233557f, 0.740899f, 0.229938f, 0.869623f, 0.075329f, 0.285778f, 0.097940f, 0.492298f, 0.185967f, 0.510061f, 0.223009f, 0.588861f,
0.001098f, 0.002705f, 0.000022f, 0.003510f, 0.003543f, 0.012375f, 0.004107f, 0.013065f, 0.000749f, 0.003129f, 0.001147f, 0.004848f, 0.003717f, 0.011224f, 0.005248f, 0.011655f,
0.153258f, 0.411199f, 0.003319f, 0.532922f, 0.525452f, 1.997976f, 0.661027f, 2.106966f, 0.113463f, 0.515952f, 0.188503f, 0.798553f, 0.291212f, 0.957383f, 0.446234f, 0.993051f,
0.265663f, 0.892469f, 0.004218f, 1.122843f, 0.415864f, 1.979887f, 0.383635f, 2.026851f, 0.002771f, 0.015776f, 0.003376f, 0.023703f, 0.508176f, 2.091818f, 0.571018f, 2.106319f,
0.388414f, 1.197035f, 0.006233f, 1.532577f, 0.861846f, 3.764163f, 0.803522f, 3.921386f, 0.315334f, 1.647056f, 0.388256f, 2.518297f, 0.662103f, 2.500256f, 0.751904f, 2.561973f,
0.161573f, 0.548284f, 0.003053f, 0.631389f, 0.493839f, 2.374929f, 0.542140f, 2.225347f, 0.118439f, 0.681173f, 0.171711f, 0.936767f, 0.499826f, 2.078283f, 0.668366f, 1.915449f,
0.521647f, 1.926983f, 0.010697f, 2.216606f, 1.693552f, 8.865998f, 2.017598f, 8.298391f, 0.414848f, 2.597265f, 0.652685f, 3.567877f, 0.905580f, 4.098983f, 1.314110f, 3.773647f,
0.045137f, 0.300593f, 0.001244f, 0.326862f, 0.081901f, 0.772984f, 0.131135f, 0.683929f, 0.000560f, 0.006318f, 0.001184f, 0.008204f, 0.111744f, 0.911849f, 0.217931f, 0.793565f,
0.056153f, 0.343062f, 0.001564f, 0.379618f, 0.144427f, 1.250482f, 0.233710f, 1.125921f, 0.054204f, 0.561250f, 0.115834f, 0.741676f, 0.123884f, 0.927391f, 0.244180f, 0.821320f,
0.021427f, 0.144140f, 0.000703f, 0.143461f, 0.075913f, 0.723725f, 0.144645f, 0.586111f, 0.018675f, 0.212921f, 0.046993f, 0.253077f, 0.085787f, 0.707126f, 0.199102f, 0.563277f,
0.101263f, 0.741550f, 0.003604f, 0.737243f, 0.381079f, 3.954886f, 0.787972f, 3.199335f, 0.095751f, 1.188397f, 0.261468f, 1.410960f, 0.227516f, 2.041511f, 0.573030f, 1.624412f,
0.358106f, 1.082227f, 0.006606f, 1.140591f, 0.461562f, 1.976805f, 0.494658f, 1.695240f, 0.003359f, 0.017206f, 0.004754f, 0.021656f, 0.703198f, 2.603947f, 0.917955f, 2.196435f,
0.534922f, 1.483019f, 0.009973f, 1.590553f, 0.977289f, 3.839784f, 1.058520f, 3.350919f, 0.390590f, 1.835284f, 0.558697f, 2.350648f, 0.936060f, 3.179858f, 1.234948f, 2.729503f,
0.204931f, 0.625592f, 0.004499f, 0.603488f, 0.515732f, 2.231179f, 0.657746f, 1.751328f, 0.135110f, 0.699033f, 0.227563f, 0.805300f, 0.650793f, 2.434296f, 1.010988f, 1.879426f,
0.524143f, 1.741791f, 0.012486f, 1.678389f, 1.401105f, 6.598486f, 1.939163f, 5.173643f, 0.374902f, 2.111492f, 0.685236f, 2.429791f, 0.934079f, 3.803449f, 1.574694f, 2.933247f,
0.000875f, 0.001566f, 0.000010f, 0.002233f, 0.001468f, 0.003722f, 0.000927f, 0.004318f, 0.000010f, 0.000029f, 0.000008f, 0.000050f, 0.002960f, 0.006490f, 0.002279f, 0.007406f,
0.001133f, 0.001860f, 0.000012f, 0.002699f, 0.002692f, 0.006264f, 0.001720f, 0.007395f, 0.000980f, 0.002725f, 0.000826f, 0.004722f, 0.003414f, 0.006867f, 0.002656f, 0.007974f,
0.000013f, 0.000023f, 0.000000f, 0.000030f, 0.000042f, 0.000108f, 0.000032f, 0.000115f, 0.000010f, 0.000031f, 0.000010f, 0.000048f, 0.000070f, 0.000156f, 0.000065f, 0.000163f,
0.002086f, 0.004105f, 0.000029f, 0.005351f, 0.007254f, 0.020229f, 0.005920f, 0.021457f, 0.001767f, 0.005893f, 0.001904f, 0.009173f, 0.006402f, 0.015436f, 0.006364f, 0.016104f,
0.001527f, 0.003763f, 0.000016f, 0.004762f, 0.002425f, 0.008466f, 0.001451f, 0.008717f, 0.000018f, 0.000076f, 0.000014f, 0.000115f, 0.004718f, 0.014243f, 0.003439f, 0.014426f,
0.002774f, 0.006271f, 0.000029f, 0.008075f, 0.006243f, 0.019999f, 0.003776f, 0.020955f, 0.002577f, 0.009871f, 0.002058f, 0.015180f, 0.007638f, 0.021153f, 0.005627f, 0.021802f,
0.001192f, 0.002966f, 0.000015f, 0.003436f, 0.003694f, 0.013030f, 0.002631f, 0.012280f, 0.000999f, 0.004216f, 0.000940f, 0.005831f, 0.005954f, 0.018158f, 0.005165f, 0.016833f,
0.004462f, 0.012089f, 0.000059f, 0.013987f, 0.014692f, 0.056409f, 0.011355f, 0.053105f, 0.004060f, 0.018640f, 0.004144f, 0.025755f, 0.012510f, 0.041530f, 0.011777f, 0.038456f,
0.000014f, 0.000069f, 0.000000f, 0.000075f, 0.000026f, 0.000179f, 0.000027f, 0.000160f, 0.000000f, 0.000002f, 0.000000f, 0.000002f, 0.000056f, 0.000337f, 0.000071f, 0.000295f,
0.000022f, 0.000097f, 0.000000f, 0.000109f, 0.000057f, 0.000360f, 0.000060f, 0.000326f, 0.000024f, 0.000182f, 0.000033f, 0.000243f, 0.000078f, 0.000426f, 0.000099f, 0.000379f,
0.000009f, 0.000042f, 0.000000f, 0.000042f, 0.000031f, 0.000215f, 0.000038f, 0.000175f, 0.000009f, 0.000071f, 0.000014f, 0.000085f, 0.000055f, 0.000335f, 0.000083f, 0.000269f,
0.000047f, 0.000252f, 0.000001f, 0.000252f, 0.000179f, 0.001365f, 0.000241f, 0.001111f, 0.000051f, 0.000463f, 0.000090f, 0.000553f, 0.000171f, 0.001122f, 0.000279f, 0.000898f,
0.003783f, 0.008386f, 0.000045f, 0.008889f, 0.004946f, 0.015534f, 0.003439f, 0.013399f, 0.000041f, 0.000153f, 0.000037f, 0.000193f, 0.011998f, 0.032585f, 0.010161f, 0.027646f,
0.007022f, 0.014278f, 0.000085f, 0.015403f, 0.013011f, 0.037493f, 0.009143f, 0.032910f, 0.005866f, 0.020214f, 0.005443f, 0.026041f, 0.019845f, 0.049443f, 0.016986f, 0.042688f,
0.002778f, 0.006220f, 0.000040f, 0.006035f, 0.007091f, 0.022497f, 0.005867f, 0.017762f, 0.002095f, 0.007951f, 0.002290f, 0.009213f, 0.014248f, 0.039087f, 0.014360f, 0.030354f,
0.008240f, 0.020082f, 0.000127f, 0.019464f, 0.022338f, 0.077156f, 0.020057f, 0.060848f, 0.006742f, 0.027850f, 0.007995f, 0.032235f, 0.023715f, 0.070821f, 0.025937f, 0.054936f,
0.001094f, 0.002780f, 0.000016f, 0.002959f, 0.001564f, 0.005632f, 0.001329f, 0.004879f, 0.000012f, 0.000052f, 0.000014f, 0.000067f, 0.003228f, 0.010050f, 0.003341f, 0.008563f,
0.002155f, 0.005024f, 0.000032f, 0.005443f, 0.004368f, 0.014432f, 0.003751f, 0.012721f, 0.001868f, 0.007380f, 0.002118f, 0.009548f, 0.005667f, 0.016190f, 0.005929f, 0.014037f,
0.000025f, 0.000064f, 0.000000f, 0.000062f, 0.000069f, 0.000252f, 0.000070f, 0.000200f, 0.000019f, 0.000084f, 0.000026f, 0.000098f, 0.000118f, 0.000372f, 0.000146f, 0.000290f,
0.003773f, 0.010543f, 0.000071f, 0.010262f, 0.011189f, 0.044309f, 0.012278f, 0.035092f, 0.003203f, 0.015170f, 0.004642f, 0.017633f, 0.010104f, 0.034598f, 0.013507f, 0.026952f,
0.003197f, 0.011187f, 0.000044f, 0.010570f, 0.004329f, 0.021466f, 0.003484f, 0.016504f, 0.000038f, 0.000227f, 0.000041f, 0.000256f, 0.008620f, 0.036956f, 0.008450f, 0.027947f,
0.008843f, 0.028384f, 0.000124f, 0.027293f, 0.016972f, 0.077201f, 0.013803f, 0.060401f, 0.008233f, 0.044786f, 0.008842f, 0.051427f, 0.021246f, 0.083560f, 0.021048f, 0.064304f,
0.003846f, 0.013593f, 0.000063f, 0.011756f, 0.010168f, 0.050928f, 0.009737f, 0.035838f, 0.003233f, 0.019366f, 0.004089f, 0.020001f, 0.016769f, 0.072622f, 0.019561f, 0.050267f,
0.013522f, 0.052024f, 0.000242f, 0.044943f, 0.037970f, 0.207029f, 0.039460f, 0.145528f, 0.012331f, 0.080408f, 0.016924f, 0.082955f, 0.033085f, 0.155969f, 0.041881f, 0.107839f,
0.001040f, 0.007211f, 0.000025f, 0.005889f, 0.001632f, 0.016039f, 0.002279f, 0.010658f, 0.000015f, 0.000174f, 0.000027f, 0.000170f, 0.003628f, 0.030831f, 0.006172f, 0.020151f,
0.002447f, 0.015568f, 0.000059f, 0.012938f, 0.005443f, 0.049083f, 0.007683f, 0.033190f, 0.002708f, 0.029207f, 0.005049f, 0.028986f, 0.007608f, 0.059317f, 0.013081f, 0.039453f,
0.000976f, 0.006839f, 0.000028f, 0.005112f, 0.002991f, 0.029701f, 0.004972f, 0.018065f, 0.000976f, 0.011585f, 0.002142f, 0.010341f, 0.005508f, 0.047289f, 0.011152f, 0.028290f,
0.005024f, 0.038314f, 0.000156f, 0.028608f, 0.016351f, 0.176740f, 0.029494f, 0.107377f, 0.005447f, 0.070411f, 0.012975f, 0.062783f, 0.015908f, 0.148667f, 0.034951f, 0.088840f,
0.004571f, 0.014386f, 0.000074f, 0.011387f, 0.005095f, 0.022729f, 0.004764f, 0.014638f, 0.000049f, 0.000262f, 0.000061f, 0.000248f, 0.012650f, 0.048786f, 0.014405f, 0.030905f,
0.012915f, 0.037293f, 0.000210f, 0.030038f, 0.020409f, 0.083515f, 0.019283f, 0.054736f, 0.010814f, 0.052922f, 0.013494f, 0.050906f, 0.031854f, 0.112700f, 0.036660f, 0.072652f,
0.005173f, 0.016448f, 0.000099f, 0.011916f, 0.011261f, 0.050738f, 0.012528f, 0.029910f, 0.003911f, 0.021076f, 0.005747f, 0.018234f, 0.023155f, 0.090206f, 0.031378f, 0.052304f,
0.014408f, 0.049868f, 0.000299f, 0.036088f, 0.033313f, 0.163399f, 0.040220f, 0.096217f, 0.011818f, 0.069322f, 0.018843f, 0.059910f, 0.036190f, 0.153476f, 0.053221f, 0.088892f,
0.000322f, 0.000586f, 0.000005f, 0.001039f, 0.000522f, 0.001347f, 0.000452f, 0.001945f, 0.000005f, 0.000015f, 0.000006f, 0.000032f, 0.001194f, 0.002665f, 0.001259f, 0.003785f,
0.000570f, 0.000953f, 0.000009f, 0.001720f, 0.001312f, 0.003107f, 0.001147f, 0.004565f, 0.000671f, 0.001900f, 0.000775f, 0.004097f, 0.001887f, 0.003864f, 0.002010f, 0.005584f,
0.000007f, 0.000013f, 0.000000f, 0.000022f, 0.000023f, 0.000060f, 0.000024f, 0.000079f, 0.000008f, 0.000024f, 0.000010f, 0.000047f, 0.000044f, 0.000098f, 0.000055f, 0.000128f,
0.000906f, 0.001814f, 0.000017f, 0.002943f, 0.003051f, 0.008658f, 0.003408f, 0.011430f, 0.001044f, 0.003545f, 0.001541f, 0.006868f, 0.003054f, 0.007495f, 0.004156f, 0.009731f,
0.000838f, 0.002101f, 0.000012f, 0.003310f, 0.001289f, 0.004579f, 0.001056f, 0.005868f, 0.000014f, 0.000058f, 0.000015f, 0.000109f, 0.002845f, 0.008739f, 0.002838f, 0.011015f,
0.002086f, 0.004798f, 0.000030f, 0.007690f, 0.004547f, 0.014820f, 0.003764f, 0.019327f, 0.002637f, 0.010280f, 0.002883f, 0.019676f, 0.006310f, 0.017782f, 0.006363f, 0.022810f,
0.001002f, 0.002538f, 0.000017f, 0.003658f, 0.003008f, 0.010797f, 0.002933f, 0.012665f, 0.001144f, 0.004909f, 0.001472f, 0.008452f, 0.005500f, 0.017068f, 0.006531f, 0.019692f,
0.002895f, 0.007983f, 0.000053f, 0.011495f, 0.009233f, 0.036075f, 0.009768f, 0.042268f, 0.003585f, 0.016753f, 0.005009f, 0.028809f, 0.008918f, 0.030128f, 0.011492f, 0.034721f,
0.000216f, 0.001073f, 0.000005f, 0.001460f, 0.000385f, 0.002710f, 0.000547f, 0.003001f, 0.000004f, 0.000035f, 0.000008f, 0.000057f, 0.000948f, 0.005774f, 0.001642f, 0.006290f,
0.000457f, 0.002084f, 0.000011f, 0.002887f, 0.001155f, 0.007462f, 0.001659f, 0.008411f, 0.000687f, 0.005310f, 0.001304f, 0.008784f, 0.001789f, 0.009997f, 0.003132f, 0.011083f,
0.000201f, 0.001011f, 0.000006f, 0.001260f, 0.000701f, 0.004987f, 0.001186f, 0.005056f, 0.000273f, 0.002326f, 0.000611f, 0.003461f, 0.001431f, 0.008802f, 0.002949f, 0.008777f,
0.000852f, 0.004656f, 0.000027f, 0.005795f, 0.003149f, 0.024391f, 0.005782f, 0.024700f, 0.001254f, 0.011619f, 0.003042f, 0.017269f, 0.003396f, 0.022743f, 0.007596f, 0.022654f,
0.002447f, 0.005519f, 0.000040f, 0.007281f, 0.003097f, 0.009901f, 0.002948f, 0.010629f, 0.000036f, 0.000137f, 0.000045f, 0.000215f, 0.008524f, 0.023559f, 0.009882f, 0.024876f,
0.006222f, 0.012874f, 0.000103f, 0.017285f, 0.011165f, 0.032739f, 0.010739f, 0.035766f, 0.007074f, 0.024807f, 0.008985f, 0.039775f, 0.019318f, 0.048976f, 0.022632f, 0.052627f,
0.002752f, 0.006271f, 0.000054f, 0.007573f, 0.006803f, 0.021967f, 0.007705f, 0.021584f, 0.002826f, 0.010910f, 0.004226f, 0.015734f, 0.015508f, 0.043293f, 0.021394f, 0.041842f,
0.006300f, 0.015626f, 0.000133f, 0.018849f, 0.016542f, 0.058143f, 0.020331f, 0.057068f, 0.007017f, 0.029495f, 0.011389f, 0.042489f, 0.019921f, 0.060540f, 0.029823f, 0.058446f,
0.002303f, 0.005620f, 0.000039f, 0.007966f, 0.003888f, 0.013445f, 0.003788f, 0.015508f, 0.000027f, 0.000111f, 0.000034f, 0.000188f, 0.006116f, 0.018284f, 0.007257f, 0.020743f,
0.003171f, 0.007097f, 0.000054f, 0.010238f, 0.007588f, 0.024071f, 0.007470f, 0.028253f, 0.002873f, 0.010900f, 0.003735f, 0.018777f, 0.007503f, 0.020579f, 0.008998f, 0.023759f,
0.000039f, 0.000095f, 0.000001f, 0.000123f, 0.000127f, 0.000444f, 0.000147f, 0.000469f, 0.000032f, 0.000132f, 0.000048f, 0.000204f, 0.000166f, 0.000501f, 0.000234f, 0.000520f,
0.005337f, 0.014318f, 0.000116f, 0.018557f, 0.018685f, 0.071049f, 0.023507f, 0.074925f, 0.004737f, 0.021540f, 0.007869f, 0.033337f, 0.012861f, 0.042280f, 0.019707f, 0.043856f,
0.007914f, 0.026586f, 0.000126f, 0.033449f, 0.012651f, 0.060233f, 0.011671f, 0.061661f, 0.000099f, 0.000563f, 0.000121f, 0.000847f, 0.019199f, 0.079031f, 0.021574f, 0.079579f,
0.015293f, 0.047132f, 0.000245f, 0.060344f, 0.034655f, 0.151360f, 0.032310f, 0.157682f, 0.014886f, 0.077752f, 0.018328f, 0.118880f, 0.033064f, 0.124856f, 0.037548f, 0.127938f,
0.007031f, 0.023860f, 0.000133f, 0.027476f, 0.021947f, 0.105546f, 0.024094f, 0.098898f, 0.006179f, 0.035539f, 0.008959f, 0.048875f, 0.027586f, 0.114704f, 0.036888f, 0.105717f,
0.022482f, 0.083048f, 0.000461f, 0.095530f, 0.074539f, 0.390222f, 0.088801f, 0.365240f, 0.021435f, 0.134202f, 0.033725f, 0.184354f, 0.049499f, 0.224049f, 0.071829f, 0.206267f,
0.002002f, 0.013333f, 0.000055f, 0.014498f, 0.003710f, 0.035014f, 0.005940f, 0.030980f, 0.000030f, 0.000336f, 0.000063f, 0.000436f, 0.006286f, 0.051296f, 0.012260f, 0.044642f,
0.003292f, 0.020113f, 0.000092f, 0.022256f, 0.008647f, 0.074870f, 0.013993f, 0.067412f, 0.003810f, 0.039450f, 0.008142f, 0.052132f, 0.009211f, 0.068956f, 0.018156f, 0.061069f,
0.001388f, 0.009340f, 0.000046f, 0.009296f, 0.005023f, 0.047891f, 0.009572f, 0.038784f, 0.001451f, 0.016541f, 0.003651f, 0.019660f, 0.007050f, 0.058111f, 0.016362f, 0.046290f,
0.006498f, 0.047586f, 0.000231f, 0.047309f, 0.024974f, 0.259181f, 0.051639f, 0.209667f, 0.007367f, 0.091430f, 0.020116f, 0.108553f, 0.018517f, 0.166152f, 0.046637f, 0.132206f,
0.010487f, 0.031693f, 0.000193f, 0.033402f, 0.013804f, 0.059121f, 0.014794f, 0.050700f, 0.000118f, 0.000604f, 0.000167f, 0.000760f, 0.026118f, 0.096715f, 0.034094f, 0.081579f,
0.020706f, 0.057404f, 0.000386f, 0.061567f, 0.038632f, 0.151787f, 0.041844f, 0.132463f, 0.018126f, 0.085171f, 0.025928f, 0.109088f, 0.045953f, 0.156106f, 0.060626f, 0.133997f,
0.008767f, 0.026763f, 0.000192f, 0.025818f, 0.022532f, 0.097479f, 0.028737f, 0.076515f, 0.006930f, 0.035854f, 0.011672f, 0.041304f, 0.035311f, 0.132080f, 0.054854f, 0.101974f,
0.022207f, 0.073796f, 0.000529f, 0.071110f, 0.060624f, 0.285506f, 0.083904f, 0.223855f, 0.019044f, 0.107256f, 0.034807f, 0.123424f, 0.050192f, 0.204377f, 0.084616f, 0.157617f,
0.048474f, 0.086744f, 0.000527f, 0.123678f, 0.065505f, 0.166124f, 0.041397f, 0.192725f, 0.000420f, 0.001274f, 0.000351f, 0.002170f, 0.132829f, 0.291256f, 0.102249f, 0.332353f,
0.071728f, 0.117753f, 0.000789f, 0.170849f, 0.137395f, 0.319653f, 0.087754f, 0.377377f, 0.048394f, 0.134648f, 0.040820f, 0.233304f, 0.175156f, 0.352333f, 0.136268f, 0.409137f,
0.000576f, 0.001042f, 0.000007f, 0.001359f, 0.001520f, 0.003895f, 0.001143f, 0.004136f, 0.000351f, 0.001075f, 0.000349f, 0.001676f, 0.002553f, 0.005656f, 0.002339f, 0.005907f,
0.085202f, 0.167657f, 0.001197f, 0.218553f, 0.238790f, 0.665910f, 0.194887f, 0.706329f, 0.056310f, 0.187795f, 0.060692f, 0.292350f, 0.211886f, 0.510884f, 0.210639f, 0.533007f,
0.061546f, 0.151637f, 0.000634f, 0.191891f, 0.078755f, 0.274984f, 0.047133f, 0.283148f, 0.000573f, 0.002393f, 0.000453f, 0.003616f, 0.154082f, 0.465160f, 0.112323f, 0.471116f,
0.127833f, 0.288932f, 0.001331f, 0.372080f, 0.231863f, 0.742701f, 0.140243f, 0.778232f, 0.092645f, 0.354898f, 0.074003f, 0.545791f, 0.285194f, 0.789844f, 0.210116f, 0.814059f,
0.038789f, 0.096535f, 0.000476f, 0.111816f, 0.096912f, 0.341812f, 0.069022f, 0.322151f, 0.025383f, 0.107064f, 0.023874f, 0.148096f, 0.157045f, 0.478910f, 0.136239f, 0.443960f,
0.132626f, 0.359312f, 0.001764f, 0.415726f, 0.351971f, 1.351382f, 0.272034f, 1.272239f, 0.094156f, 0.432331f, 0.096104f, 0.597358f, 0.301333f, 1.000318f, 0.283682f, 0.926292f,
0.000503f, 0.002459f, 0.000009f, 0.002689f, 0.000747f, 0.005169f, 0.000776f, 0.004600f, 0.000006f, 0.000046f, 0.000008f, 0.000060f, 0.001631f, 0.009762f, 0.002064f, 0.008546f,
0.000890f, 0.003987f, 0.000016f, 0.004437f, 0.001871f, 0.011879f, 0.001964f, 0.010758f, 0.000767f, 0.005822f, 0.001063f, 0.007739f, 0.002569f, 0.014105f, 0.003285f, 0.012565f,
0.000248f, 0.001222f, 0.000005f, 0.001223f, 0.000717f, 0.005015f, 0.000887f, 0.004085f, 0.000193f, 0.001611f, 0.000315f, 0.001926f, 0.001298f, 0.007845f, 0.001954f, 0.006286f,
0.001240f, 0.006657f, 0.000029f, 0.006657f, 0.003813f, 0.029023f, 0.005115f, 0.023615f, 0.001046f, 0.009524f, 0.001854f, 0.011374f, 0.003645f, 0.023987f, 0.005956f, 0.019197f,
0.171470f, 0.380046f, 0.002052f, 0.402877f, 0.180660f, 0.567463f, 0.125608f, 0.489474f, 0.001436f, 0.005394f, 0.001318f, 0.006829f, 0.440678f, 1.196790f, 0.373204f, 1.015380f,
0.363868f, 0.739849f, 0.004401f, 0.798121f, 0.543416f, 1.565882f, 0.381848f, 1.374486f, 0.237181f, 0.817345f, 0.220098f, 1.052965f, 0.833345f, 2.076212f, 0.713265f, 1.792552f,
0.101684f, 0.227656f, 0.001448f, 0.220892f, 0.209183f, 0.663710f, 0.173078f, 0.524006f, 0.059847f, 0.227087f, 0.065393f, 0.263134f, 0.422626f, 1.159389f, 0.425932f, 0.900337f,
0.275428f, 0.671270f, 0.004257f, 0.650606f, 0.601846f, 2.078747f, 0.540394f, 1.639374f, 0.175866f, 0.726435f, 0.208538f, 0.840815f, 0.642407f, 1.918433f, 0.702593f, 1.488134f,
0.092645f, 0.235435f, 0.001355f, 0.250638f, 0.106771f, 0.384532f, 0.090731f, 0.333093f, 0.000805f, 0.003467f, 0.000903f, 0.004408f, 0.221551f, 0.689878f, 0.229321f, 0.587792f,
0.208709f, 0.486566f, 0.003085f, 0.527118f, 0.340950f, 1.126468f, 0.292815f, 0.992980f, 0.141148f, 0.557702f, 0.160087f, 0.721525f, 0.444777f, 1.270548f, 0.465280f, 1.101619f,
0.001697f, 0.004357f, 0.000030f, 0.004246f, 0.003820f, 0.013896f, 0.003863f, 0.011018f, 0.001037f, 0.004510f, 0.001384f, 0.005248f, 0.006565f, 0.020649f, 0.008086f, 0.016103f,
0.235701f, 0.658647f, 0.004452f, 0.641082f, 0.563377f, 2.231093f, 0.618258f, 1.766991f, 0.156147f, 0.739520f, 0.226299f, 0.859595f, 0.511545f, 1.751549f, 0.683790f, 1.364451f,
0.197093f, 0.689597f, 0.002730f, 0.651584f, 0.215089f, 1.066520f, 0.173089f, 0.819974f, 0.001839f, 0.010908f, 0.001955f, 0.012308f, 0.430617f, 1.846127f, 0.422096f, 1.396084f,
0.623236f, 2.000441f, 0.008725f, 1.923494f, 0.964081f, 4.385450f, 0.784092f, 3.431112f, 0.452761f, 2.463017f, 0.486296f, 2.828234f, 1.213441f, 4.772428f, 1.202100f, 3.672645f,
0.191471f, 0.676711f, 0.003156f, 0.585254f, 0.407988f, 2.043502f, 0.390714f, 1.438043f, 0.125594f, 0.752307f, 0.158840f, 0.776996f, 0.676536f, 2.929803f, 0.789171f, 2.027934f,
0.614754f, 2.365181f, 0.010997f, 2.043264f, 1.391394f, 7.586488f, 1.446009f, 5.332817f, 0.437476f, 2.852613f, 0.600418f, 2.942971f, 1.218955f, 5.746435f, 1.543041f, 3.973134f,
0.056877f, 0.394501f, 0.001367f, 0.322168f, 0.071949f, 0.707238f, 0.100493f, 0.469954f, 0.000631f, 0.007420f, 0.001164f, 0.007236f, 0.160830f, 1.366870f, 0.273619f, 0.893381f,
0.153036f, 0.973772f, 0.003718f, 0.809248f, 0.274410f, 2.474513f, 0.387358f, 1.673285f, 0.132188f, 1.425548f, 0.246425f, 1.414781f, 0.385633f, 3.006659f, 0.663063f, 1.999784f,
0.043128f, 0.302168f, 0.001234f, 0.225865f, 0.106524f, 1.057705f, 0.177059f, 0.643310f, 0.033636f, 0.399414f, 0.073834f, 0.356539f, 0.197224f, 1.693156f, 0.399300f, 1.012912f,
0.202694f, 1.545942f, 0.006293f, 1.154285f, 0.531782f, 5.747959f, 0.959210f, 3.492118f, 0.171505f, 2.216943f, 0.408540f, 1.976774f, 0.520164f, 4.861167f, 1.142850f, 2.904923f,
0.316851f, 0.997293f, 0.005099f, 0.789376f, 0.284708f, 1.269974f, 0.266170f, 0.817922f, 0.002660f, 0.014188f, 0.003284f, 0.013411f, 0.710652f, 2.740769f, 0.809255f, 1.736234f,
1.023648f, 2.955754f, 0.016648f, 2.380780f, 1.303797f, 5.335254f, 1.231887f, 3.496727f, 0.668839f, 3.273142f, 0.834567f, 3.148464f, 2.045973f, 7.238776f, 2.354667f, 4.666493f,
0.289632f, 0.920855f, 0.005546f, 0.667142f, 0.508147f, 2.289610f, 0.565339f, 1.349721f, 0.170871f, 0.920742f, 0.251053f, 0.796614f, 1.050552f, 4.092697f, 1.423657f, 2.373073f,
0.736678f, 2.549677f, 0.015309f, 1.845148f, 1.372856f, 6.733798f, 1.657500f, 3.965170f, 0.471504f, 2.765786f, 0.751783f, 2.390273f, 1.499502f, 6.359202f, 2.205183f, 3.683182f,
0.030926f, 0.056317f, 0.000460f, 0.099933f, 0.040474f, 0.104453f, 0.035012f, 0.150815f, 0.000365f, 0.001126f, 0.000417f, 0.002386f, 0.093099f, 0.207737f, 0.098097f, 0.295025f,
0.062699f, 0.104744f, 0.000943f, 0.189141f, 0.116312f, 0.275373f, 0.101686f, 0.404610f, 0.057576f, 0.163018f, 0.066475f, 0.351542f, 0.168202f, 0.344309f, 0.179118f, 0.497601f,
0.000563f, 0.001036f, 0.000010f, 0.001683f, 0.001439f, 0.003752f, 0.001481f, 0.004958f, 0.000467f, 0.001456f, 0.000635f, 0.002824f, 0.002742f, 0.006180f, 0.003438f, 0.008033f,
0.064271f, 0.128699f, 0.001236f, 0.208800f, 0.174450f, 0.495062f, 0.194885f, 0.653536f, 0.057814f, 0.196211f, 0.085295f, 0.380154f, 0.175594f, 0.430843f, 0.238939f, 0.559432f,
0.058668f, 0.147092f, 0.000827f, 0.231664f, 0.072705f, 0.258334f, 0.059559f, 0.331060f, 0.000743f, 0.003159f, 0.000804f, 0.005942f, 0.161357f, 0.495712f, 0.161007f, 0.624845f,
0.166953f, 0.384004f, 0.002379f, 0.615452f, 0.293273f, 0.955965f, 0.242807f, 1.246682f, 0.164687f, 0.641987f, 0.180064f, 1.228760f, 0.409196f, 1.153245f, 0.412658f, 1.479293f,
0.056645f, 0.143461f, 0.000951f, 0.206808f, 0.137065f, 0.491951f, 0.133621f, 0.577048f, 0.050452f, 0.216557f, 0.064954f, 0.372812f, 0.251955f, 0.781880f, 0.299185f, 0.902087f,
0.149479f, 0.412110f, 0.002722f, 0.593426f, 0.384192f, 1.501093f, 0.406448f, 1.758800f, 0.144438f, 0.674902f, 0.201799f, 1.160584f, 0.373112f, 1.260433f, 0.480801f, 1.452605f,
0.013408f, 0.066644f, 0.000328f, 0.090717f, 0.019261f, 0.135674f, 0.027386f, 0.150272f, 0.000202f, 0.001702f, 0.000379f, 0.002767f, 0.047729f, 0.290678f, 0.082661f, 0.316675f,
0.032468f, 0.148042f, 0.000803f, 0.205070f, 0.066111f, 0.427204f, 0.095000f, 0.481513f, 0.038080f, 0.294278f, 0.072265f, 0.486809f, 0.102992f, 0.575418f, 0.180269f, 0.637934f,
0.010105f, 0.050734f, 0.000294f, 0.063210f, 0.028343f, 0.201664f, 0.047957f, 0.204446f, 0.010701f, 0.091058f, 0.023912f, 0.135486f, 0.058171f, 0.357862f, 0.119891f, 0.356848f,
0.039034f, 0.213334f, 0.001234f, 0.265505f, 0.116292f, 0.900737f, 0.213533f, 0.912149f, 0.044846f, 0.415403f, 0.108747f, 0.617398f, 0.126098f, 0.844460f, 0.282030f, 0.841136f,
0.192601f, 0.434406f, 0.003155f, 0.573126f, 0.196527f, 0.628183f, 0.187033f, 0.674366f, 0.002195f, 0.008392f, 0.002759f, 0.013222f, 0.543792f, 1.502858f, 0.630373f, 1.586889f,
0.559976f, 1.158660f, 0.009271f, 1.555608f, 0.809928f, 2.374985f, 0.779011f, 2.594540f, 0.496808f, 1.742214f, 0.631051f, 2.793369f, 1.408934f, 3.572114f, 1.650656f, 3.838342f,
0.174979f, 0.398656f, 0.003411f, 0.481414f, 0.348614f, 1.125606f, 0.394822f, 1.106017f, 0.140170f, 0.541245f, 0.209647f, 0.780542f, 0.798965f, 2.230432f, 1.102179f, 2.155675f,
0.365793f, 0.907219f, 0.007738f, 1.094337f, 0.774106f, 2.720851f, 0.951405f, 2.670542f, 0.317900f, 1.336270f, 0.515983f, 1.924935f, 0.937296f, 2.848405f, 1.403172f, 2.749890f,
0.121444f, 0.296324f, 0.002036f, 0.420043f, 0.165258f, 0.571453f, 0.160983f, 0.659118f, 0.001103f, 0.004562f, 0.001419f, 0.007723f, 0.261340f, 0.781347f, 0.310093f, 0.886432f,
0.191162f, 0.427899f, 0.003239f, 0.617245f, 0.368725f, 1.169686f, 0.363012f, 1.372907f, 0.135166f, 0.512783f, 0.175738f, 0.883350f, 0.366588f, 1.005461f, 0.439607f, 1.160797f,
0.001643f, 0.004051f, 0.000033f, 0.005256f, 0.004367f, 0.015252f, 0.005062f, 0.016102f, 0.001049f, 0.004383f, 0.001606f, 0.006791f, 0.005720f, 0.017273f, 0.008076f, 0.017937f,
0.207547f, 0.556859f, 0.004494f, 0.721700f, 0.585740f, 2.227211f, 0.736869f, 2.348706f, 0.143754f, 0.653694f, 0.238827f, 1.011740f, 0.405334f, 1.332570f, 0.621108f, 1.382216f,
0.303699f, 1.020246f, 0.004822f, 1.283603f, 0.391328f, 1.863073f, 0.361001f, 1.907267f, 0.002963f, 0.016873f, 0.003610f, 0.025351f, 0.597086f, 2.457800f, 0.670923f, 2.474839f,
0.671006f, 2.067940f, 0.010768f, 2.647607f, 1.225572f, 5.352762f, 1.142634f, 5.576338f, 0.509653f, 2.662025f, 0.627512f, 4.070151f, 1.175622f, 4.439428f, 1.335073f, 4.549011f,
0.217911f, 0.739465f, 0.004118f, 0.851549f, 0.548246f, 2.636581f, 0.601869f, 2.470519f, 0.149444f, 0.859492f, 0.216662f, 1.181997f, 0.692855f, 2.880901f, 0.926484f, 2.655182f,
0.636310f, 2.350553f, 0.013048f, 2.703838f, 1.700470f, 8.902214f, 2.025840f, 8.332289f, 0.473427f, 2.964019f, 0.744849f, 4.071689f, 1.135351f, 5.139012f, 1.647537f, 4.731128f,
0.068186f, 0.454093f, 0.001879f, 0.493776f, 0.101844f, 0.961200f, 0.163065f, 0.850462f, 0.000791f, 0.008929f, 0.001673f, 0.011595f, 0.173500f, 1.415792f, 0.338373f, 1.232138f,
0.128191f, 0.783172f, 0.003570f, 0.866627f, 0.271402f, 2.349854f, 0.439177f, 2.115785f, 0.115768f, 1.198710f, 0.247396f, 1.584061f, 0.290677f, 2.176002f, 0.572937f, 1.927119f,
0.038188f, 0.256892f, 0.001252f, 0.255683f, 0.111369f, 1.061740f, 0.212202f, 0.859854f, 0.031139f, 0.355024f, 0.078355f, 0.421980f, 0.157144f, 1.295312f, 0.364715f, 1.031810f,
0.163228f, 1.195326f, 0.005809f, 1.188383f, 0.505638f, 5.247571f, 1.045527f, 4.245062f, 0.144399f, 1.792174f, 0.394310f, 2.127812f, 0.376938f, 3.382276f, 0.949368f, 2.691247f,
0.452597f, 1.367787f, 0.008349f, 1.441551f, 0.480185f, 2.056563f, 0.514616f, 1.763638f, 0.003972f, 0.020345f, 0.005622f, 0.025606f, 0.913459f, 3.382543f, 1.192430f, 2.853182f,
1.021669f, 2.832478f, 0.019047f, 3.037861f, 1.536460f, 6.036773f, 1.664168f, 5.268195f, 0.697933f, 3.279409f, 0.998317f, 4.200296f, 1.837532f, 6.242215f, 2.424263f, 5.358147f,
0.305569f, 0.932807f, 0.006708f, 0.899848f, 0.632999f, 2.738505f, 0.807305f, 2.149545f, 0.188479f, 0.975149f, 0.317450f, 1.123392f, 0.997367f, 3.730659f, 1.549381f, 2.880298f,
0.706856f, 2.348967f, 0.016839f, 2.263463f, 1.555355f, 7.324926f, 2.152650f, 5.743220f, 0.473010f, 2.664052f, 0.864556f, 3.065647f, 1.294719f, 5.271930f, 2.182671f, 4.065750f,
0.060585f, 0.108418f, 0.000659f, 0.154579f, 0.073111f, 0.185414f, 0.046204f, 0.215104f, 0.000532f, 0.001613f, 0.000444f, 0.002747f, 0.181486f, 0.397944f, 0.139704f, 0.454096f,
0.090159f, 0.148010f, 0.000991f, 0.214750f, 0.154220f, 0.358797f, 0.098501f, 0.423590f, 0.061618f, 0.171440f, 0.051974f, 0.297055f, 0.240675f, 0.484129f, 0.187240f, 0.562181f,
0.000728f, 0.001316f, 0.000009f, 0.001717f, 0.001715f, 0.004393f, 0.001290f, 0.004665f, 0.000449f, 0.001376f, 0.000446f, 0.002144f, 0.003526f, 0.007810f, 0.003230f, 0.008157f,
0.104947f, 0.206511f, 0.001474f, 0.269203f, 0.262657f, 0.732468f, 0.214366f, 0.776927f, 0.070259f, 0.234316f, 0.075727f, 0.364771f, 0.285308f, 0.687913f, 0.283628f, 0.717701f,
0.061109f, 0.150560f, 0.000630f, 0.190528f, 0.069828f, 0.243817f, 0.041791f, 0.251055f, 0.000576f, 0.002407f, 0.000456f, 0.003637f, 0.167241f, 0.504889f, 0.121916f, 0.511353f,
0.127646f, 0.288509f, 0.001329f, 0.371535f, 0.206751f, 0.662261f, 0.125054f, 0.693944f, 0.093709f, 0.358974f, 0.074853f, 0.552060f, 0.311310f, 0.862173f, 0.229356f, 0.888605f,
0.038925f, 0.096874f, 0.000477f, 0.112208f, 0.086846f, 0.306308f, 0.061853f, 0.288689f, 0.025802f, 0.108833f, 0.024268f, 0.150542f, 0.172280f, 0.525366f, 0.149455f, 0.487026f,
0.129776f, 0.351593f, 0.001726f, 0.406794f, 0.307557f, 1.180856f, 0.237707f, 1.111700f, 0.093328f, 0.428529f, 0.095259f, 0.592104f, 0.322331f, 1.070026f, 0.303451f, 0.990841f,
0.000608f, 0.002969f, 0.000011f, 0.003247f, 0.000805f, 0.005574f, 0.000836f, 0.004960f, 0.000007f, 0.000056f, 0.000009f, 0.000074f, 0.002153f, 0.012886f, 0.002724f, 0.011280f,
0.001080f, 0.004841f, 0.000020f, 0.005388f, 0.002029f, 0.012882f, 0.002130f, 0.011666f, 0.000943f, 0.007162f, 0.001308f, 0.009520f, 0.003410f, 0.018724f, 0.004361f, 0.016679f,
0.000302f, 0.001491f, 0.000006f, 0.001493f, 0.000782f, 0.005465f, 0.000966f, 0.004452f, 0.000238f, 0.001992f, 0.000389f, 0.002381f, 0.001731f, 0.010466f, 0.002607f, 0.008386f,
0.001475f, 0.007922f, 0.000034f, 0.007922f, 0.004052f, 0.030842f, 0.005436f, 0.025095f, 0.001261f, 0.011481f, 0.002234f, 0.013710f, 0.004742f, 0.031204f, 0.007748f, 0.024973f,
0.146126f, 0.323874f, 0.001749f, 0.343330f, 0.137484f, 0.431845f, 0.095589f, 0.372495f, 0.001240f, 0.004656f, 0.001138f, 0.005895f, 0.410534f, 1.114925f, 0.347675f, 0.945924f,
0.311848f, 0.634076f, 0.003772f, 0.684017f, 0.415894f, 1.198420f, 0.292240f, 1.051938f, 0.205909f, 0.709577f, 0.191078f, 0.914131f, 0.780751f, 1.945176f, 0.668249f, 1.679419f,
0.087581f, 0.196080f, 0.001247f, 0.190254f, 0.160891f, 0.510486f, 0.133121f, 0.403034f, 0.052214f, 0.198126f, 0.057054f, 0.229576f, 0.397923f, 1.091622f, 0.401036f, 0.847712f,
0.231319f, 0.563767f, 0.003575f, 0.546412f, 0.451376f, 1.559032f, 0.405288f, 1.229509f, 0.149617f, 0.618008f, 0.177412f, 0.715317f, 0.589795f, 1.761317f, 0.645052f, 1.366258f,
0.067482f, 0.171491f, 0.000987f, 0.182565f, 0.069451f, 0.250124f, 0.059017f, 0.216664f, 0.000594f, 0.002558f, 0.000667f, 0.003252f, 0.176414f, 0.549328f, 0.182601f, 0.468040f,
0.152887f, 0.356428f, 0.002260f, 0.386134f, 0.223034f, 0.736886f, 0.191547f, 0.649564f, 0.104737f, 0.413836f, 0.118791f, 0.535398f, 0.356173f, 1.017442f, 0.372591f, 0.882166f,
0.001250f, 0.003208f, 0.000022f, 0.003126f, 0.002511f, 0.009135f, 0.002539f, 0.007243f, 0.000773f, 0.003363f, 0.001032f, 0.003913f, 0.005283f, 0.016618f, 0.006508f, 0.012960f,
0.169198f, 0.472810f, 0.003196f, 0.460201f, 0.361147f, 1.430219f, 0.396328f, 1.132712f, 0.113544f, 0.537748f, 0.164555f, 0.625062f, 0.401427f, 1.374500f, 0.536593f, 1.070731f,
0.114048f, 0.399035f, 0.001580f, 0.377039f, 0.111144f, 0.551107f, 0.089441f, 0.423709f, 0.001078f, 0.006394f, 0.001146f, 0.007215f, 0.272393f, 1.167795f, 0.267003f, 0.883113f,
0.362684f, 1.164129f, 0.005077f, 1.119350f, 0.501003f, 2.278981f, 0.407468f, 1.783042f, 0.266894f, 1.451906f, 0.286663f, 1.667195f, 0.771939f, 3.036012f, 0.764724f, 2.336378f,
0.111978f, 0.395762f, 0.001846f, 0.342275f, 0.213074f, 1.067229f, 0.204052f, 0.751025f, 0.074404f, 0.445679f, 0.094099f, 0.460305f, 0.432525f, 1.873088f, 0.504535f, 1.296504f,
0.350574f, 1.348786f, 0.006271f, 1.165208f, 0.708566f, 3.863412f, 0.736379f, 2.715732f, 0.252713f, 1.647849f, 0.346839f, 1.700046f, 0.759898f, 3.582335f, 0.961933f, 2.476857f,
0.040025f, 0.277616f, 0.000962f, 0.226715f, 0.045214f, 0.444440f, 0.063152f, 0.295328f, 0.000450f, 0.005289f, 0.000830f, 0.005158f, 0.123724f, 1.051509f, 0.210490f, 0.687262f,
0.108306f, 0.689150f, 0.002632f, 0.572714f, 0.173423f, 1.563858f, 0.244805f, 1.057493f, 0.094764f, 1.021960f, 0.176659f, 1.014241f, 0.298345f, 2.326104f, 0.512980f, 1.547135f,
0.030674f, 0.214912f, 0.000878f, 0.160643f, 0.067657f, 0.671781f, 0.112456f, 0.408586f, 0.024233f, 0.287760f, 0.053194f, 0.256871f, 0.153342f, 1.316430f, 0.310456f, 0.787540f,
0.140572f, 1.072144f, 0.004364f, 0.800521f, 0.329340f, 3.559793f, 0.594053f, 2.162719f, 0.120485f, 1.557436f, 0.287006f, 1.388714f, 0.394356f, 3.685439f, 0.866439f, 2.202335f,
0.157364f, 0.495306f, 0.002532f, 0.392044f, 0.126270f, 0.563245f, 0.118049f, 0.362756f, 0.001338f, 0.007138f, 0.001652f, 0.006747f, 0.385830f, 1.488031f, 0.439364f, 0.942644f,
0.511282f, 1.476312f, 0.008315f, 1.189129f, 0.581529f, 2.379668f, 0.549455f, 1.559635f, 0.338398f, 1.656039f, 0.422247f, 1.592959f, 1.117117f, 3.952428f, 1.285666f, 2.547941f,
0.145383f, 0.462229f, 0.002784f, 0.334876f, 0.227775f, 1.026310f, 0.253411f, 0.605008f, 0.086882f, 0.468166f, 0.127652f, 0.405051f, 0.576464f, 2.245765f, 0.781196f, 1.302164f,
0.360571f, 1.247954f, 0.007493f, 0.903119f, 0.600053f, 2.943235f, 0.724467f, 1.733113f, 0.233773f, 1.371286f, 0.372736f, 1.185105f, 0.802324f, 3.402554f, 1.179905f, 1.970723f,
0.001129f, 0.002056f, 0.000017f, 0.003648f, 0.001319f, 0.003405f, 0.001141f, 0.004917f, 0.000013f, 0.000042f, 0.000015f, 0.000088f, 0.003715f, 0.008290f, 0.003915f, 0.011774f,
0.002302f, 0.003846f, 0.000035f, 0.006944f, 0.003813f, 0.009028f, 0.003334f, 0.013265f, 0.002141f, 0.006063f, 0.002472f, 0.013074f, 0.006751f, 0.013819f, 0.007189f, 0.019971f,
0.000021f, 0.000038f, 0.000000f, 0.000062f, 0.000047f, 0.000124f, 0.000049f, 0.000163f, 0.000017f, 0.000054f, 0.000024f, 0.000106f, 0.000111f, 0.000249f, 0.000139f, 0.000324f,
0.002312f, 0.004630f, 0.000044f, 0.007512f, 0.005605f, 0.015905f, 0.006261f, 0.020997f, 0.002107f, 0.007151f, 0.003108f, 0.013854f, 0.006906f, 0.016945f, 0.009397f, 0.022002f,
0.001701f, 0.004266f, 0.000024f, 0.006719f, 0.001883f, 0.006690f, 0.001542f, 0.008574f, 0.000022f, 0.000093f, 0.000024f, 0.000175f, 0.005116f, 0.015716f, 0.005104f, 0.019810f,
0.004869f, 0.011200f, 0.000069f, 0.017950f, 0.007638f, 0.024898f, 0.006324f, 0.032470f, 0.004866f, 0.018967f, 0.005320f, 0.036303f, 0.013047f, 0.036769f, 0.013157f, 0.047165f,
0.001660f, 0.004205f, 0.000028f, 0.006062f, 0.003588f, 0.012877f, 0.003497f, 0.015104f, 0.001498f, 0.006430f, 0.001929f, 0.011069f, 0.008073f, 0.025053f, 0.009586f, 0.028905f,
0.004272f, 0.011779f, 0.000078f, 0.016961f, 0.009806f, 0.038312f, 0.010374f, 0.044890f, 0.004182f, 0.019540f, 0.005842f, 0.033601f, 0.011658f, 0.039381f, 0.015022f, 0.045385f,
0.000473f, 0.002350f, 0.000012f, 0.003200f, 0.000607f, 0.004273f, 0.000863f, 0.004733f, 0.000007f, 0.000061f, 0.000014f, 0.000099f, 0.001840f, 0.011207f, 0.003187f, 0.012210f,
0.001152f, 0.005251f, 0.000028f, 0.007274f, 0.002094f, 0.013531f, 0.003009f, 0.015252f, 0.001368f, 0.010573f, 0.002596f, 0.017491f, 0.003993f, 0.022311f, 0.006990f, 0.024735f,
0.000360f, 0.001808f, 0.000010f, 0.002253f, 0.000902f, 0.006419f, 0.001527f, 0.006508f, 0.000386f, 0.003288f, 0.000863f, 0.004892f, 0.002267f, 0.013945f, 0.004672f, 0.013905f,
0.001357f, 0.007415f, 0.000043f, 0.009228f, 0.003610f, 0.027958f, 0.006628f, 0.028312f, 0.001579f, 0.014626f, 0.003829f, 0.021738f, 0.004791f, 0.032087f, 0.010716f, 0.031961f,
0.004794f, 0.010813f, 0.000079f, 0.014266f, 0.004368f, 0.013963f, 0.004157f, 0.014990f, 0.000055f, 0.000212f, 0.000070f, 0.000333f, 0.014797f, 0.040894f, 0.017153f, 0.043180f,
0.014018f, 0.029004f, 0.000232f, 0.038941f, 0.018105f, 0.053091f, 0.017414f, 0.057999f, 0.012598f, 0.044178f, 0.016002f, 0.070833f, 0.038556f, 0.097751f, 0.045170f, 0.105037f,
0.004402f, 0.010029f, 0.000086f, 0.012111f, 0.007832f, 0.025287f, 0.008870f, 0.024847f, 0.003572f, 0.013793f, 0.005343f, 0.019891f, 0.021973f, 0.061340f, 0.030311f, 0.059284f,
0.008973f, 0.022255f, 0.000190f, 0.026845f, 0.016958f, 0.059603f, 0.020841f, 0.058501f, 0.007899f, 0.033205f, 0.012822f, 0.047833f, 0.025135f, 0.076384f, 0.037628f, 0.073742f,
0.136094f, 0.332070f, 0.002282f, 0.470713f, 0.165378f, 0.571866f, 0.161100f, 0.659594f, 0.001252f, 0.005179f, 0.001611f, 0.008767f, 0.320153f, 0.957184f, 0.379877f, 1.085917f,
0.215439f, 0.482239f, 0.003651f, 0.695631f, 0.371087f, 1.177179f, 0.365337f, 1.381702f, 0.154307f, 0.585398f, 0.200624f, 1.008441f, 0.451636f, 1.238728f, 0.541596f, 1.430101f,
0.001861f, 0.004588f, 0.000037f, 0.005952f, 0.004416f, 0.015427f, 0.005120f, 0.016286f, 0.001204f, 0.005029f, 0.001843f, 0.007791f, 0.007082f, 0.021387f, 0.009999f, 0.022208f,
0.229214f, 0.614994f, 0.004963f, 0.797044f, 0.577672f, 2.196536f, 0.726720f, 2.316357f, 0.160820f, 0.731300f, 0.267181f, 1.131854f, 0.489358f, 1.608808f, 0.749863f, 1.668746f,
0.270365f, 0.908265f, 0.004293f, 1.142717f, 0.311100f, 1.481116f, 0.286990f, 1.516250f, 0.002672f, 0.015216f, 0.003256f, 0.022861f, 0.581077f, 2.391901f, 0.652934f, 2.408483f,
0.600750f, 1.851421f, 0.009641f, 2.370395f, 0.979845f, 4.279534f, 0.913536f, 4.458283f, 0.462208f, 2.414210f, 0.569095f, 3.691251f, 1.150598f, 4.344933f, 1.306655f, 4.452183f,
0.196066f, 0.665336f, 0.003705f, 0.766183f, 0.440504f, 2.118437f, 0.483589f, 1.985010f, 0.136206f, 0.783359f, 0.197470f, 1.077296f, 0.681482f, 2.833611f, 0.911275f, 2.611597f,
0.558264f, 2.062248f, 0.011448f, 2.372201f, 1.332266f, 6.974614f, 1.587184f, 6.528095f, 0.420746f, 2.634193f, 0.661965f, 3.618605f, 1.088905f, 4.928778f, 1.580137f, 4.537581f,
0.073821f, 0.491625f, 0.002034f, 0.534587f, 0.098463f, 0.929296f, 0.157653f, 0.822233f, 0.000868f, 0.009793f, 0.001835f, 0.012716f, 0.205342f, 1.675626f, 0.400473f, 1.458267f,
0.139574f, 0.852718f, 0.003888f, 0.943583f, 0.263883f, 2.284759f, 0.427011f, 2.057173f, 0.127682f, 1.322081f, 0.272859f, 1.747092f, 0.345977f, 2.589978f, 0.681936f, 2.293747f,
0.041786f, 0.281096f, 0.001370f, 0.279773f, 0.108822f, 1.037464f, 0.207350f, 0.840194f, 0.034515f, 0.393512f, 0.086850f, 0.467726f, 0.187971f, 1.549413f, 0.436261f, 1.234220f,
0.174159f, 1.275376f, 0.006199f, 1.267968f, 0.481773f, 4.999900f, 0.996181f, 4.044707f, 0.156067f, 1.936991f, 0.426172f, 2.299750f, 0.439653f, 3.945024f, 1.107325f, 3.139021f,
0.345824f, 1.045107f, 0.006379f, 1.101470f, 0.327644f, 1.403253f, 0.351137f, 1.203381f, 0.003074f, 0.015747f, 0.004351f, 0.019819f, 0.762993f, 2.825366f, 0.996011f, 2.383203f,
0.785077f, 2.176549f, 0.014636f, 2.334370f, 1.054325f, 4.142457f, 1.141959f, 3.615057f, 0.543264f, 2.552661f, 0.777080f, 3.269471f, 1.543567f, 5.243599f, 2.036434f, 4.500962f,
0.235976f, 0.720360f, 0.005180f, 0.694907f, 0.436528f, 1.888524f, 0.556733f, 1.482367f, 0.147440f, 0.762824f, 0.248330f, 0.878789f, 0.841979f, 3.149431f, 1.307991f, 2.431554f,
0.532275f, 1.768815f, 0.012680f, 1.704429f, 1.045891f, 4.925611f, 1.447539f, 3.862000f, 0.360804f, 2.032095f, 0.659469f, 2.338425f, 1.065786f, 4.339743f, 1.796729f, 3.346840f,
0.131161f, 0.234713f, 0.001427f, 0.334649f, 0.215324f, 0.546074f, 0.136079f, 0.633517f, 0.001215f, 0.003686f, 0.001014f, 0.006275f, 0.349688f, 0.766762f, 0.269183f, 0.874955f,
0.160214f, 0.263017f, 0.001761f, 0.381614f, 0.372822f, 0.867383f, 0.238123f, 1.024018f, 0.115539f, 0.321467f, 0.097456f, 0.557007f, 0.380648f, 0.765690f, 0.296136f, 0.889135f,
0.001120f, 0.002025f, 0.000015f, 0.002643f, 0.003591f, 0.009200f, 0.002701f, 0.009769f, 0.000730f, 0.002235f, 0.000725f, 0.003483f, 0.004831f, 0.010700f, 0.004425f, 0.011175f,
0.191598f, 0.377019f, 0.002692f, 0.491473f, 0.652349f, 1.819196f, 0.532411f, 1.929617f, 0.135349f, 0.451392f, 0.145882f, 0.702704f, 0.463590f, 1.117773f, 0.460861f, 1.166176f,
0.151859f, 0.374150f, 0.001564f, 0.473474f, 0.236069f, 0.824272f, 0.141282f, 0.848744f, 0.001511f, 0.006311f, 0.001194f, 0.009537f, 0.369897f, 1.116691f, 0.269648f, 1.130987f,
0.260373f, 0.588505f, 0.002711f, 0.757862f, 0.573731f, 1.837764f, 0.347023f, 1.925685f, 0.201700f, 0.772655f, 0.161114f, 1.188251f, 0.565175f, 1.565253f, 0.416391f, 1.613239f,
0.068780f, 0.171176f, 0.000843f, 0.198271f, 0.208765f, 0.736318f, 0.148684f, 0.693964f, 0.048108f, 0.202921f, 0.045249f, 0.280690f, 0.270938f, 0.826225f, 0.235043f, 0.765929f,
0.271966f, 0.736815f, 0.003618f, 0.852498f, 0.876828f, 3.366557f, 0.677691f, 3.169397f, 0.206376f, 0.947612f, 0.210647f, 1.309327f, 0.601203f, 1.995782f, 0.565988f, 1.848088f,
0.001093f, 0.005337f, 0.000020f, 0.005837f, 0.001969f, 0.013629f, 0.002045f, 0.012129f, 0.000013f, 0.000107f, 0.000018f, 0.000140f, 0.003445f, 0.020616f, 0.004358f, 0.018046f,
0.001594f, 0.007143f, 0.000029f, 0.007950f, 0.004072f, 0.025856f, 0.004275f, 0.023417f, 0.001468f, 0.011151f, 0.002036f, 0.014821f, 0.004479f, 0.024589f, 0.005727f, 0.021903f,
0.000386f, 0.001906f, 0.000008f, 0.001908f, 0.001359f, 0.009503f, 0.001680f, 0.007741f, 0.000321f, 0.002686f, 0.000524f, 0.003212f, 0.001969f, 0.011906f, 0.002965f, 0.009539f,
0.002236f, 0.012009f, 0.000052f, 0.012008f, 0.008356f, 0.063601f, 0.011209f, 0.051750f, 0.002017f, 0.018363f, 0.003574f, 0.021929f, 0.006397f, 0.042098f, 0.010453f, 0.033692f,
0.353552f, 0.783613f, 0.004231f, 0.830688f, 0.452531f, 1.421428f, 0.314633f, 1.226074f, 0.003165f, 0.011888f, 0.002906f, 0.015049f, 0.884047f, 2.400888f, 0.748687f, 2.036960f,
0.619330f, 1.259276f, 0.007491f, 1.358460f, 1.123654f, 3.237866f, 0.789569f, 2.842106f, 0.431505f, 1.487000f, 0.400426f, 1.915665f, 1.380041f, 3.438258f, 1.181185f, 2.968511f,
0.150672f, 0.337333f, 0.002146f, 0.327311f, 0.376554f, 1.194759f, 0.311561f, 0.943273f, 0.094787f, 0.359666f, 0.103572f, 0.416758f, 0.609291f, 1.671467f, 0.614058f, 1.297998f,
0.471975f, 1.150290f, 0.007294f, 1.114881f, 1.252902f, 4.327464f, 1.124973f, 3.412793f, 0.322121f, 1.330559f, 0.381965f, 1.540061f, 1.071048f, 3.198493f, 1.171393f, 2.481080f,
0.202670f, 0.515039f, 0.002964f, 0.548298f, 0.283756f, 1.021936f, 0.241128f, 0.885230f, 0.001882f, 0.008107f, 0.002112f, 0.010306f, 0.471554f, 1.468353f, 0.488092f, 1.251069f,
0.376897f, 0.878666f, 0.005571f, 0.951897f, 0.747988f, 2.471284f, 0.642388f, 2.178433f, 0.272449f, 1.076494f, 0.309006f, 1.392710f, 0.781472f, 2.232347f, 0.817494f, 1.935540f,
0.002669f, 0.006850f, 0.000046f, 0.006675f, 0.007295f, 0.026539f, 0.007377f, 0.021042f, 0.001742f, 0.007578f, 0.002326f, 0.008818f, 0.010041f, 0.031584f, 0.012369f, 0.024631f,
0.428525f, 1.197476f, 0.008095f, 1.165542f, 1.244329f, 4.927804f, 1.365544f, 3.902745f, 0.303441f, 1.437114f, 0.439768f, 1.670457f, 0.904871f, 3.098311f, 1.209555f, 2.413574f,
0.393174f, 1.375651f, 0.005446f, 1.299821f, 0.521258f, 2.584662f, 0.419474f, 1.987169f, 0.003922f, 0.023259f, 0.004168f, 0.026245f, 0.835781f, 3.583137f, 0.819244f, 2.709651f,
1.026310f, 3.294211f, 0.014367f, 3.167499f, 1.928685f, 8.773274f, 1.568608f, 6.864082f, 0.796933f, 4.335316f, 0.855961f, 4.978159f, 1.944165f, 7.646346f, 1.925995f, 5.884282f,
0.274493f, 0.970132f, 0.004525f, 0.839019f, 0.710554f, 3.558971f, 0.680470f, 2.504501f, 0.192453f, 1.152790f, 0.243397f, 1.190623f, 0.943642f, 4.086531f, 1.100747f, 2.828592f,
1.019199f, 3.921228f, 0.018232f, 3.387524f, 2.802398f, 15.279900f, 2.912398f, 10.740790f, 0.775245f, 5.055082f, 1.063993f, 5.215204f, 1.966230f, 9.269260f, 2.488994f, 6.408845f,
0.099807f, 0.692269f, 0.002399f, 0.565340f, 0.153382f, 1.507697f, 0.214232f, 1.001855f, 0.001184f, 0.013917f, 0.002184f, 0.013572f, 0.274589f, 2.333689f, 0.467157f, 1.525290f,
0.221684f, 1.410578f, 0.005386f, 1.172254f, 0.482904f, 4.354630f, 0.681669f, 2.944635f, 0.204673f, 2.207238f, 0.381551f, 2.190567f, 0.543503f, 4.237529f, 0.934509f, 2.818459f,
0.054388f, 0.381057f, 0.001556f, 0.284833f, 0.163197f, 1.620421f, 0.271258f, 0.985562f, 0.045340f, 0.538385f, 0.099524f, 0.480591f, 0.241986f, 2.077435f, 0.489926f, 1.242803f,
0.295605f, 2.254577f, 0.009178f, 1.683390f, 0.942165f, 10.183740f, 1.699446f, 6.187035f, 0.267347f, 3.455843f, 0.636846f, 3.081460f, 0.738075f, 6.897650f, 1.621623f, 4.121879f,
0.528192f, 1.662493f, 0.008500f, 1.315895f, 0.576579f, 2.571898f, 0.539036f, 1.656421f, 0.004739f, 0.025281f, 0.005851f, 0.023897f, 1.152611f, 4.445271f, 1.312535f, 2.816009f,
1.408641f, 4.067410f, 0.022909f, 3.276189f, 2.179624f, 8.919215f, 2.059408f, 5.845656f, 0.983781f, 4.814400f, 1.227547f, 4.631013f, 2.739292f, 9.691783f, 3.152593f, 6.247829f,
0.346975f, 1.103171f, 0.006645f, 0.799226f, 0.739543f, 3.332230f, 0.822777f, 1.964344f, 0.218800f, 1.179009f, 0.321473f, 1.020063f, 1.224498f, 4.770348f, 1.659380f, 2.765995f,
1.020609f, 3.532376f, 0.021210f, 2.556307f, 2.310620f, 11.333490f, 2.789697f, 6.673681f, 0.698223f, 4.095698f, 1.113273f, 3.539622f, 2.021239f, 8.571822f, 2.972454f, 4.964708f,
0.092148f, 0.167806f, 0.001372f, 0.297766f, 0.146508f, 0.378101f, 0.126736f, 0.545925f, 0.001162f, 0.003586f, 0.001327f, 0.007600f, 0.269899f, 0.602240f, 0.284386f, 0.855289f,
0.154218f, 0.257635f, 0.002321f, 0.465226f, 0.347556f, 0.822852f, 0.303853f, 1.209028f, 0.151372f, 0.428590f, 0.174769f, 0.924238f, 0.402529f, 0.823978f, 0.428653f, 1.190827f,
0.001206f, 0.002218f, 0.000021f, 0.003603f, 0.003744f, 0.009759f, 0.003854f, 0.012897f, 0.001069f, 0.003332f, 0.001453f, 0.006463f, 0.005712f, 0.012875f, 0.007162f, 0.016736f,
0.159158f, 0.318704f, 0.003060f, 0.517060f, 0.524812f, 1.489332f, 0.586288f, 1.966080f, 0.153029f, 0.519350f, 0.225767f, 1.006230f, 0.423068f, 1.038048f, 0.575686f, 1.347864f,
0.159407f, 0.399669f, 0.002248f, 0.629460f, 0.239990f, 0.852734f, 0.196599f, 1.092792f, 0.002159f, 0.009175f, 0.002336f, 0.017257f, 0.426567f, 1.310471f, 0.425642f, 1.651849f,
0.374469f, 0.861307f, 0.005336f, 1.380435f, 0.799128f, 2.604870f, 0.661616f, 3.397032f, 0.394828f, 1.539132f, 0.431694f, 2.945892f, 0.892982f, 2.516707f, 0.900536f, 3.228235f,
0.110608f, 0.280128f, 0.001856f, 0.403823f, 0.325141f, 1.166992f, 0.316971f, 1.368856f, 0.105300f, 0.451986f, 0.135568f, 0.778111f, 0.478670f, 1.485432f, 0.568398f, 1.713804f,
0.337548f, 0.930610f, 0.006147f, 1.340049f, 1.053959f, 4.117975f, 1.115016f, 4.824947f, 0.348629f, 1.629005f, 0.487080f, 2.801292f, 0.819752f, 2.769254f, 1.056352f, 3.191468f,
0.032048f, 0.159288f, 0.000784f, 0.216826f, 0.055928f, 0.393950f, 0.079520f, 0.436339f, 0.000516f, 0.004348f, 0.000969f, 0.007068f, 0.110993f, 0.675965f, 0.192225f, 0.736421f,
0.064060f, 0.292093f, 0.001584f, 0.404612f, 0.158465f, 1.023983f, 0.227710f, 1.154160f, 0.080309f, 0.620614f, 0.152402f, 1.026649f, 0.197710f, 1.104609f, 0.346056f, 1.224618f,
0.017357f, 0.087143f, 0.000506f, 0.108574f, 0.059143f, 0.420813f, 0.100071f, 0.426617f, 0.019647f, 0.167180f, 0.043902f, 0.248749f, 0.097216f, 0.598057f, 0.200361f, 0.596363f,
0.077536f, 0.423768f, 0.002451f, 0.527400f, 0.280633f, 2.173641f, 0.515294f, 2.201182f, 0.095218f, 0.881994f, 0.230894f, 1.310874f, 0.243706f, 1.632060f, 0.545069f, 1.625635f,
0.437313f, 0.986346f, 0.007164f, 1.301318f, 0.542096f, 1.732771f, 0.515908f, 1.860163f, 0.005328f, 0.020366f, 0.006696f, 0.032088f, 1.201310f, 3.320014f, 1.392579f, 3.505651f,
1.049580f, 2.171712f, 0.017376f, 2.915722f, 1.844227f, 5.407901f, 1.773828f, 5.907834f, 0.995319f, 3.490399f, 1.264266f, 5.596312f, 2.569363f, 6.514186f, 3.010173f, 6.999686f,
0.285518f, 0.650499f, 0.005566f, 0.785536f, 0.691059f, 2.231291f, 0.782656f, 2.192460f, 0.244472f, 0.943994f, 0.365649f, 1.361357f, 1.268424f, 3.540998f, 1.749801f, 3.422316f,
0.690261f, 1.711947f, 0.014602f, 2.065044f, 1.774599f, 6.237416f, 2.181048f, 6.122086f, 0.641205f, 2.695255f, 1.040736f, 3.882592f, 1.720853f, 5.229602f, 2.576189f, 5.048730f,
0.332726f, 0.811852f, 0.005579f, 1.150810f, 0.550041f, 1.902007f, 0.535811f, 2.193787f, 0.003231f, 0.013360f, 0.004156f, 0.022616f, 0.696635f, 2.082776f, 0.826591f, 2.362891f,
0.432339f, 0.967751f, 0.007326f, 1.395982f, 1.013087f, 3.213761f, 0.997390f, 3.772121f, 0.326752f, 1.239606f, 0.424830f, 2.135418f, 0.806658f, 2.212466f, 0.967334f, 2.554274f,
0.003236f, 0.007975f, 0.000065f, 0.010348f, 0.010445f, 0.036483f, 0.012108f, 0.038515f, 0.002208f, 0.009224f, 0.003381f, 0.014292f, 0.010957f, 0.033089f, 0.015471f, 0.034360f,
0.472575f, 1.267943f, 0.010233f, 1.643279f, 1.620246f, 6.160810f, 2.038294f, 6.496883f, 0.349866f, 1.590950f, 0.581254f, 2.462357f, 0.897958f, 2.952115f, 1.375976f, 3.062100f,
0.758747f, 2.548934f, 0.012048f, 3.206892f, 1.187726f, 5.654646f, 1.095679f, 5.788779f, 0.007914f, 0.045058f, 0.009641f, 0.067698f, 1.451374f, 5.974327f, 1.630855f, 6.015744f,
1.383863f, 4.264857f, 0.022208f, 5.460343f, 3.070627f, 13.411150f, 2.862829f, 13.971320f, 1.123489f, 5.868216f, 1.383298f, 8.972316f, 2.358973f, 8.908041f, 2.678922f, 9.127928f,
0.391244f, 1.327658f, 0.007393f, 1.528895f, 1.195819f, 5.750839f, 1.312781f, 5.388630f, 0.286797f, 1.649445f, 0.415795f, 2.268362f, 1.210318f, 5.032519f, 1.618433f, 4.638220f,
1.321195f, 4.880548f, 0.027092f, 5.614088f, 4.289327f, 22.455270f, 5.110052f, 21.017670f, 1.050702f, 6.578199f, 1.653082f, 9.036506f, 2.293599f, 10.381660f, 3.328299f, 9.557668f,
0.149851f, 0.997958f, 0.004130f, 1.085170f, 0.271910f, 2.566275f, 0.435362f, 2.270619f, 0.001858f, 0.020975f, 0.003929f, 0.027238f, 0.370985f, 3.027304f, 0.723523f, 2.634606f,
0.232561f, 1.420815f, 0.006478f, 1.572217f, 0.598156f, 5.178967f, 0.967926f, 4.663089f, 0.224489f, 2.324460f, 0.479735f, 3.071707f, 0.513073f, 3.840859f, 1.011291f, 3.401557f,
0.060312f, 0.405726f, 0.001978f, 0.403817f, 0.213681f, 2.037146f, 0.407149f, 1.649790f, 0.052567f, 0.599332f, 0.132275f, 0.712363f, 0.241474f, 1.990423f, 0.560434f, 1.585517f,
0.298131f, 2.183227f, 0.010611f, 2.170546f, 1.121951f, 11.643740f, 2.319901f, 9.419293f, 0.281905f, 3.498809f, 0.769799f, 4.154064f, 0.669840f, 6.010496f, 1.687080f, 4.782499f,
0.944908f, 2.855591f, 0.017430f, 3.009593f, 1.217889f, 5.216046f, 1.305216f, 4.473102f, 0.008864f, 0.045400f, 0.012545f, 0.057142f, 1.855477f, 6.870838f, 2.422140f, 5.795567f,
1.760763f, 4.881541f, 0.032826f, 5.235502f, 3.216869f, 12.639130f, 3.484251f, 11.029960f, 1.285676f, 6.041065f, 1.839019f, 7.737449f, 3.081158f, 10.466900f, 4.064984f, 8.984497f,
0.458460f, 1.399536f, 0.010064f, 1.350086f, 1.153765f, 4.991460f, 1.471471f, 3.917966f, 0.302261f, 1.563834f, 0.509091f, 1.801569f, 1.455915f, 5.445861f, 2.261722f, 4.204539f,
1.226459f, 4.075673f, 0.029217f, 3.927316f, 3.278489f, 15.440010f, 4.537510f, 12.105970f, 0.877244f, 4.940747f, 1.603405f, 5.685545f, 2.185681f, 8.899812f, 3.684677f, 6.863598f,
0.027976f, 0.050063f, 0.000304f, 0.071378f, 0.046903f, 0.118949f, 0.029641f, 0.137996f, 0.000311f, 0.000942f, 0.000259f, 0.001605f, 0.094596f, 0.207421f, 0.072818f, 0.236689f,
0.045168f, 0.074150f, 0.000497f, 0.107585f, 0.107340f, 0.249730f, 0.068558f, 0.294827f, 0.039052f, 0.108657f, 0.032940f, 0.188269f, 0.136103f, 0.273776f, 0.105885f, 0.317915f,
0.000349f, 0.000631f, 0.000005f, 0.000824f, 0.001143f, 0.002928f, 0.000859f, 0.003109f, 0.000273f, 0.000835f, 0.000271f, 0.001301f, 0.001909f, 0.004228f, 0.001749f, 0.004416f,
0.059124f, 0.116341f, 0.000831f, 0.151659f, 0.205580f, 0.573298f, 0.167783f, 0.608096f, 0.050074f, 0.166999f, 0.053971f, 0.259976f, 0.181434f, 0.437460f, 0.180366f, 0.456403f,
0.040090f, 0.098773f, 0.000413f, 0.124993f, 0.063645f, 0.222225f, 0.038090f, 0.228823f, 0.000478f, 0.001997f, 0.000378f, 0.003019f, 0.123847f, 0.373886f, 0.090283f, 0.378673f,
0.090853f, 0.205349f, 0.000946f, 0.264443f, 0.204448f, 0.654883f, 0.123661f, 0.686214f, 0.084380f, 0.323235f, 0.067401f, 0.497098f, 0.250115f, 0.692695f, 0.184272f, 0.713932f,
0.026525f, 0.066014f, 0.000325f, 0.076463f, 0.082221f, 0.289994f, 0.058558f, 0.273313f, 0.022244f, 0.093823f, 0.020921f, 0.129781f, 0.132519f, 0.404116f, 0.114962f, 0.374624f,
0.103872f, 0.281411f, 0.001382f, 0.325594f, 0.342003f, 1.313112f, 0.264331f, 1.236210f, 0.094501f, 0.433916f, 0.096457f, 0.599547f, 0.291220f, 0.966746f, 0.274162f, 0.895204f,
0.000430f, 0.002098f, 0.000008f, 0.002294f, 0.000790f, 0.005471f, 0.000821f, 0.004869f, 0.000006f, 0.000050f, 0.000008f, 0.000066f, 0.001717f, 0.010278f, 0.002173f, 0.008997f,
0.000828f, 0.003711f, 0.000015f, 0.004131f, 0.002161f, 0.013719f, 0.002268f, 0.012425f, 0.000915f, 0.006946f, 0.001268f, 0.009232f, 0.002951f, 0.016202f, 0.003774f, 0.014433f,
0.000222f, 0.001094f, 0.000005f, 0.001096f, 0.000797f, 0.005573f, 0.000985f, 0.004539f, 0.000221f, 0.001849f, 0.000361f, 0.002211f, 0.001434f, 0.008671f, 0.002160f, 0.006947f,
0.001272f, 0.006829f, 0.000029f, 0.006829f, 0.004853f, 0.036937f, 0.006510f, 0.030055f, 0.001375f, 0.012520f, 0.002437f, 0.014951f, 0.004614f, 0.030363f, 0.007539f, 0.024300f,
0.091755f, 0.203366f, 0.001098f, 0.215583f, 0.119938f, 0.376734f, 0.083390f, 0.324957f, 0.000985f, 0.003699f, 0.000904f, 0.004683f, 0.290984f, 0.790251f, 0.246430f, 0.670465f,
0.212447f, 0.431966f, 0.002570f, 0.465989f, 0.393635f, 1.134279f, 0.276599f, 0.995638f, 0.177463f, 0.611549f, 0.164681f, 0.787844f, 0.600394f, 1.495833f, 0.513881f, 1.291467f,
0.057123f, 0.127890f, 0.000814f, 0.124091f, 0.145793f, 0.462584f, 0.120630f, 0.365214f, 0.043084f, 0.163482f, 0.047077f, 0.189432f, 0.292967f, 0.803696f, 0.295259f, 0.624120f,
0.177210f, 0.431895f, 0.002739f, 0.418599f, 0.480419f, 1.659343f, 0.431365f, 1.308617f, 0.145005f, 0.598958f, 0.171943f, 0.693266f, 0.510029f, 1.523112f, 0.557813f, 1.181482f,
0.042520f, 0.108054f, 0.000622f, 0.115031f, 0.060796f, 0.218955f, 0.051663f, 0.189665f, 0.000473f, 0.002039f, 0.000531f, 0.002592f, 0.125472f, 0.390702f, 0.129873f, 0.332887f,
0.104514f, 0.243655f, 0.001545f, 0.263962f, 0.211825f, 0.699851f, 0.181920f, 0.616918f, 0.090579f, 0.357894f, 0.102733f, 0.463024f, 0.274840f, 0.785107f, 0.287509f, 0.680721f,
0.000818f, 0.002099f, 0.000014f, 0.002046f, 0.002283f, 0.008307f, 0.002309f, 0.006586f, 0.000640f, 0.002784f, 0.000855f, 0.003240f, 0.003903f, 0.012277f, 0.004808f, 0.009574f,
0.130067f, 0.363462f, 0.002457f, 0.353769f, 0.385709f, 1.527490f, 0.423283f, 1.209748f, 0.110423f, 0.522969f, 0.160032f, 0.607882f, 0.348333f, 1.192707f, 0.465623f, 0.929114f,
0.102094f, 0.357209f, 0.001414f, 0.337519f, 0.138229f, 0.685410f, 0.111238f, 0.526965f, 0.001221f, 0.007241f, 0.001298f, 0.008171f, 0.275247f, 1.180032f, 0.269801f, 0.892367f,
0.352244f, 1.130621f, 0.004931f, 1.087131f, 0.676019f, 3.075103f, 0.549809f, 2.405915f, 0.327929f, 1.783932f, 0.352218f, 2.048454f, 0.846282f, 3.328401f, 0.838372f, 2.561387f,
0.104123f, 0.367998f, 0.001716f, 0.318263f, 0.275261f, 1.378706f, 0.263607f, 0.970216f, 0.087525f, 0.524272f, 0.110693f, 0.541478f, 0.453982f, 1.966011f, 0.529564f, 1.360822f,
0.382883f, 1.473090f, 0.006849f, 1.272593f, 1.075151f, 5.862190f, 1.117353f, 4.120745f, 0.349171f, 2.276812f, 0.479223f, 2.348931f, 0.936823f, 4.416399f, 1.185898f, 3.053536f,
0.038589f, 0.267655f, 0.000928f, 0.218580f, 0.060563f, 0.595315f, 0.084590f, 0.395582f, 0.000549f, 0.006451f, 0.001012f, 0.006291f, 0.134648f, 1.144351f, 0.229075f, 0.747943f,
0.113289f, 0.720856f, 0.002753f, 0.599063f, 0.252026f, 2.272663f, 0.355760f, 1.536792f, 0.125402f, 1.352360f, 0.233773f, 1.342146f, 0.352265f, 2.746503f, 0.605691f, 1.826750f,
0.030719f, 0.215224f, 0.000879f, 0.160876f, 0.094134f, 0.934676f, 0.156464f, 0.568483f, 0.030702f, 0.364573f, 0.067394f, 0.325438f, 0.173343f, 1.488142f, 0.350951f, 0.890265f,
0.165350f, 1.261125f, 0.005134f, 0.941624f, 0.538211f, 5.817449f, 0.970807f, 3.534336f, 0.179292f, 2.317601f, 0.427090f, 2.066528f, 0.523612f, 4.893394f, 1.150426f, 2.924181f,
0.134832f, 0.424386f, 0.002170f, 0.335910f, 0.150311f, 0.670482f, 0.140524f, 0.431822f, 0.001450f, 0.007737f, 0.001791f, 0.007314f, 0.373164f, 1.439181f, 0.424941f, 0.911699f,
0.475284f, 1.372367f, 0.007730f, 1.105405f, 0.751046f, 3.073346f, 0.709622f, 2.014272f, 0.397963f, 1.947540f, 0.496572f, 1.873356f, 1.172214f, 4.147365f, 1.349076f, 2.673608f,
0.129390f, 0.411382f, 0.002478f, 0.298038f, 0.281642f, 1.269022f, 0.313341f, 0.748086f, 0.097823f, 0.527122f, 0.143727f, 0.456059f, 0.579130f, 2.256150f, 0.784809f, 1.308186f,
0.376924f, 1.304551f, 0.007833f, 0.944076f, 0.871475f, 4.274547f, 1.052164f, 2.517050f, 0.309158f, 1.813484f, 0.492933f, 1.567266f, 0.946734f, 4.014979f, 1.392276f, 2.325433f,
0.014387f, 0.026199f, 0.000214f, 0.046490f, 0.023360f, 0.060287f, 0.020208f, 0.087046f, 0.000218f, 0.000671f, 0.000248f, 0.001423f, 0.053444f, 0.119253f, 0.056313f, 0.169361f,
0.031825f, 0.053167f, 0.000479f, 0.096006f, 0.073247f, 0.173416f, 0.064037f, 0.254802f, 0.037452f, 0.106040f, 0.043240f, 0.228670f, 0.105353f, 0.215658f, 0.112191f, 0.311673f,
0.000275f, 0.000506f, 0.000005f, 0.000822f, 0.000872f, 0.002273f, 0.000898f, 0.003004f, 0.000292f, 0.000911f, 0.000397f, 0.001767f, 0.001652f, 0.003724f, 0.002072f, 0.004841f,
0.035950f, 0.071989f, 0.000691f, 0.116793f, 0.121063f, 0.343558f, 0.135244f, 0.453534f, 0.041442f, 0.140646f, 0.061140f, 0.272499f, 0.121200f, 0.297379f, 0.164922f, 0.386134f,
0.030804f, 0.077232f, 0.000434f, 0.121637f, 0.047361f, 0.168284f, 0.038798f, 0.215659f, 0.000500f, 0.002126f, 0.000541f, 0.003998f, 0.104544f, 0.321175f, 0.104318f, 0.404841f,
0.095646f, 0.219992f, 0.001363f, 0.352586f, 0.208448f, 0.679466f, 0.172579f, 0.886097f, 0.120906f, 0.471322f, 0.132196f, 0.902107f, 0.289273f, 0.815264f, 0.291720f, 1.045757f,
0.031224f, 0.079078f, 0.000524f, 0.113996f, 0.093735f, 0.336433f, 0.091380f, 0.394629f, 0.035639f, 0.152973f, 0.045882f, 0.263349f, 0.171376f, 0.531824f, 0.203502f, 0.613587f,
0.094368f, 0.260171f, 0.001718f, 0.374638f, 0.300917f, 1.175729f, 0.318350f, 1.377577f, 0.116855f, 0.546016f, 0.163261f, 0.938948f, 0.290663f, 0.981906f, 0.374555f, 1.131612f,
0.009221f, 0.045832f, 0.000226f, 0.062387f, 0.016434f, 0.115760f, 0.023367f, 0.128216f, 0.000178f, 0.001500f, 0.000334f, 0.002438f, 0.040504f, 0.246674f, 0.070147f, 0.268736f,
0.024363f, 0.111085f, 0.000603f, 0.153877f, 0.061546f, 0.397704f, 0.088440f, 0.448263f, 0.036618f, 0.282975f, 0.069489f, 0.468111f, 0.095363f, 0.532795f, 0.166916f, 0.590679f,
0.007296f, 0.036628f, 0.000212f, 0.045636f, 0.025387f, 0.180637f, 0.042956f, 0.183128f, 0.009901f, 0.084248f, 0.022124f, 0.125354f, 0.051825f, 0.318818f, 0.106810f, 0.317915f,
0.032276f, 0.176402f, 0.001020f, 0.219542f, 0.119302f, 0.924053f, 0.219060f, 0.935761f, 0.047521f, 0.440184f, 0.115234f, 0.654229f, 0.128665f, 0.861646f, 0.287770f, 0.858254f,
0.083076f, 0.187376f, 0.001361f, 0.247211f, 0.105170f, 0.336170f, 0.100090f, 0.360884f, 0.001213f, 0.004639f, 0.001525f, 0.007308f, 0.289438f, 0.799910f, 0.335522f, 0.844636f,
0.263543f, 0.545304f, 0.004363f, 0.732120f, 0.472915f, 1.386747f, 0.454863f, 1.514945f, 0.299634f, 1.050759f, 0.380598f, 1.684729f, 0.818235f, 2.074496f, 0.958614f, 2.229107f,
0.079235f, 0.180523f, 0.001545f, 0.217998f, 0.195854f, 0.632374f, 0.221814f, 0.621369f, 0.081341f, 0.314085f, 0.121658f, 0.452949f, 0.446443f, 1.246314f, 0.615872f, 1.204542f,
0.189710f, 0.470509f, 0.004013f, 0.567554f, 0.498093f, 1.750713f, 0.612175f, 1.718342f, 0.211284f, 0.888116f, 0.342934f, 1.279356f, 0.599843f, 1.822899f, 0.897990f, 1.759852f,
0.092796f, 0.226422f, 0.001556f, 0.320956f, 0.156664f, 0.541734f, 0.152611f, 0.624839f, 0.001080f, 0.004467f, 0.001390f, 0.007562f, 0.246413f, 0.736716f, 0.292381f, 0.835798f,
0.159374f, 0.356744f, 0.002701f, 0.514604f, 0.381393f, 1.209870f, 0.375483f, 1.420074f, 0.144412f, 0.547859f, 0.187759f, 0.943774f, 0.377136f, 1.034393f, 0.452257f, 1.194199f,
0.001318f, 0.003249f, 0.000026f, 0.004216f, 0.004346f, 0.015180f, 0.005038f, 0.016025f, 0.001079f, 0.004506f, 0.001651f, 0.006981f, 0.005662f, 0.017098f, 0.007994f, 0.017755f,
0.190680f, 0.511604f, 0.004129f, 0.663049f, 0.667649f, 2.538661f, 0.839912f, 2.677145f, 0.169250f, 0.769632f, 0.281185f, 1.191180f, 0.459523f, 1.510720f, 0.704144f, 1.567004f,
0.261911f, 0.879862f, 0.004159f, 1.106982f, 0.418702f, 1.993398f, 0.386253f, 2.040683f, 0.003275f, 0.018647f, 0.003990f, 0.028017f, 0.635407f, 2.615540f, 0.713983f, 2.633672f,
0.631394f, 1.945862f, 0.010132f, 2.491309f, 1.430761f, 6.248937f, 1.333937f, 6.509945f, 0.614565f, 3.210005f, 0.756685f, 4.907995f, 1.365044f, 5.154731f, 1.550186f, 5.281971f,
0.197290f, 0.669489f, 0.003728f, 0.770965f, 0.615822f, 2.961561f, 0.676054f, 2.775031f, 0.173390f, 0.997210f, 0.251379f, 1.371391f, 0.774056f, 3.218537f, 1.035066f, 2.966364f,
0.659806f, 2.437349f, 0.013530f, 2.803680f, 2.187614f, 11.452490f, 2.606195f, 10.719290f, 0.629101f, 3.938657f, 0.989773f, 5.410553f, 1.452723f, 6.575552f, 2.108083f, 6.053650f,
0.077020f, 0.512926f, 0.002123f, 0.557750f, 0.142725f, 1.347031f, 0.228521f, 1.191842f, 0.001145f, 0.012925f, 0.002421f, 0.016784f, 0.241833f, 1.973396f, 0.471640f, 1.717410f,
0.157990f, 0.965230f, 0.004401f, 1.068085f, 0.414992f, 3.593097f, 0.671534f, 3.235188f, 0.182844f, 1.893247f, 0.390739f, 2.501872f, 0.442068f, 3.309314f, 0.871336f, 2.930808f,
0.045284f, 0.304632f, 0.001485f, 0.303198f, 0.163848f, 1.562058f, 0.312196f, 1.265039f, 0.047320f, 0.539513f, 0.119073f, 0.641263f, 0.229947f, 1.895415f, 0.533683f, 1.509836f,
0.221688f, 1.623431f, 0.007890f, 1.614002f, 0.852003f, 8.842192f, 1.761720f, 7.152958f, 0.251322f, 3.119228f, 0.686285f, 3.703395f, 0.631717f, 5.668412f, 1.591061f, 4.510306f,
0.320651f, 0.969034f, 0.005915f, 1.021294f, 0.422069f, 1.807661f, 0.452333f, 1.550188f, 0.003606f, 0.018471f, 0.005104f, 0.023248f, 0.798574f, 2.957121f, 1.042458f, 2.494338f,
0.789760f, 2.189533f, 0.014724f, 2.348296f, 1.473534f, 5.789538f, 1.596013f, 5.052438f, 0.691382f, 3.248627f, 0.988946f, 4.160871f, 1.752769f, 5.954271f, 2.312435f, 5.110983f,
0.227272f, 0.693790f, 0.004989f, 0.669276f, 0.584109f, 2.526992f, 0.744951f, 1.983522f, 0.179646f, 0.929451f, 0.302574f, 1.070747f, 0.915369f, 3.423944f, 1.421999f, 2.643495f,
0.602129f, 2.000946f, 0.014344f, 1.928111f, 1.643775f, 7.741337f, 2.275025f, 6.069713f, 0.516355f, 2.908176f, 0.943781f, 3.346572f, 1.360940f, 5.541573f, 2.294308f, 4.273701f,
0.125678f, 0.224900f, 0.001367f, 0.320657f, 0.169833f, 0.430707f, 0.107330f, 0.499676f, 0.001089f, 0.003304f, 0.000909f, 0.005625f, 0.344385f, 0.755133f, 0.265101f, 0.861686f,
0.231992f, 0.380851f, 0.002550f, 0.552581f, 0.444377f, 1.033858f, 0.283825f, 1.220555f, 0.156521f, 0.435493f, 0.132023f, 0.754579f, 0.566508f, 1.139556f, 0.440731f, 1.323278f,
0.001267f, 0.002289f, 0.000016f, 0.002988f, 0.003342f, 0.008561f, 0.002513f, 0.009091f, 0.000772f, 0.002364f, 0.000766f, 0.003684f, 0.005613f, 0.012432f, 0.005142f, 0.012985f,
0.195896f, 0.385475f, 0.002752f, 0.502495f, 0.549023f, 1.531054f, 0.448082f, 1.623985f, 0.129468f, 0.431777f, 0.139543f, 0.672168f, 0.487167f, 1.174620f, 0.484299f, 1.225485f,
0.131067f, 0.322922f, 0.001350f, 0.408646f, 0.167714f, 0.585599f, 0.100373f, 0.602984f, 0.001220f, 0.005096f, 0.000965f, 0.007701f, 0.328128f, 0.990593f, 0.239200f, 1.003275f,
0.339600f, 0.767576f, 0.003536f, 0.988464f, 0.615967f, 1.973054f, 0.372569f, 2.067447f, 0.246121f, 0.942820f, 0.196597f, 1.449945f, 0.757643f, 2.098296f, 0.558191f, 2.162624f,
0.070035f, 0.174299f, 0.000859f, 0.201888f, 0.174980f, 0.617157f, 0.124622f, 0.581658f, 0.045830f, 0.193309f, 0.043105f, 0.267394f, 0.283552f, 0.864693f, 0.245986f, 0.801590f,
0.250464f, 0.678563f, 0.003332f, 0.785101f, 0.664698f, 2.552091f, 0.513738f, 2.402630f, 0.177813f, 0.816460f, 0.181493f, 1.128113f, 0.569068f, 1.889106f, 0.535736f, 1.749306f,
0.001246f, 0.006087f, 0.000022f, 0.006658f, 0.001849f, 0.012795f, 0.001920f, 0.011387f, 0.000014f, 0.000114f, 0.000019f, 0.000149f, 0.004038f, 0.024167f, 0.005109f, 0.021154f,
0.002748f, 0.012311f, 0.000050f, 0.013703f, 0.005777f, 0.036684f, 0.006065f, 0.033222f, 0.002368f, 0.017980f, 0.003283f, 0.023899f, 0.007934f, 0.043558f, 0.010145f, 0.038801f,
0.000520f, 0.002564f, 0.000011f, 0.002567f, 0.001505f, 0.010525f, 0.001861f, 0.008574f, 0.000404f, 0.003382f, 0.000660f, 0.004043f, 0.002724f, 0.016466f, 0.004101f, 0.013192f,
0.002721f, 0.014614f, 0.000063f, 0.014614f, 0.008371f, 0.063713f, 0.011229f, 0.051841f, 0.002297f, 0.020908f, 0.004069f, 0.024968f, 0.008002f, 0.052657f, 0.013074f, 0.042143f,
0.337359f, 0.747724f, 0.004037f, 0.792643f, 0.355440f, 1.116459f, 0.247128f, 0.963019f, 0.002825f, 0.010612f, 0.002594f, 0.013435f, 0.867014f, 2.354631f, 0.734262f, 1.997715f,
0.893062f, 1.815852f, 0.010801f, 1.958873f, 1.333738f, 3.843232f, 0.937190f, 3.373479f, 0.582128f, 2.006056f, 0.540200f, 2.584352f, 2.045327f, 5.095763f, 1.750607f, 4.399562f,
0.169619f, 0.379752f, 0.002416f, 0.368469f, 0.348936f, 1.107131f, 0.288710f, 0.874091f, 0.099830f, 0.378802f, 0.109082f, 0.438931f, 0.704980f, 1.933970f, 0.710495f, 1.501848f,
0.480551f, 1.171192f, 0.007427f, 1.135138f, 1.050064f, 3.626871f, 0.942846f, 2.860281f, 0.306840f, 1.267439f, 0.363845f, 1.467003f, 1.120832f, 3.347165f, 1.225842f, 2.596406f,
0.292175f, 0.742495f, 0.004274f, 0.790442f, 0.336727f, 1.212707f, 0.286140f, 1.050480f, 0.002539f, 0.010934f, 0.002849f, 0.013900f, 0.698710f, 2.175682f, 0.723214f, 1.853729f,
0.821101f, 1.914245f, 0.012138f, 2.073783f, 1.341362f, 4.431740f, 1.151990f, 3.906573f, 0.555304f, 2.194106f, 0.629814f, 2.838616f, 1.749839f, 4.998578f, 1.830499f, 4.333980f,
0.004539f, 0.011651f, 0.000079f, 0.011353f, 0.010213f, 0.037156f, 0.010328f, 0.029459f, 0.002772f, 0.012058f, 0.003701f, 0.014031f, 0.017553f, 0.055212f, 0.021622f, 0.043058f,
0.659190f, 1.842049f, 0.012452f, 1.792926f, 1.575607f, 6.239734f, 1.729093f, 4.941774f, 0.436698f, 2.068227f, 0.632894f, 2.404043f, 1.430646f, 4.898586f, 1.912368f, 3.815982f,
0.510550f, 1.786328f, 0.007072f, 1.687861f, 0.557166f, 2.762708f, 0.448369f, 2.124056f, 0.004765f, 0.028256f, 0.005064f, 0.031884f, 1.115467f, 4.782199f, 1.093396f, 3.616409f,
2.013962f, 6.464340f, 0.028193f, 6.215688f, 3.115388f, 14.171400f, 2.533759f, 11.087490f, 1.463076f, 7.959136f, 1.571444f, 9.139321f, 3.921183f, 15.421900f, 3.884535f, 11.868000f,
0.420519f, 1.486226f, 0.006932f, 1.285363f, 0.896044f, 4.488038f, 0.858106f, 3.158299f, 0.275836f, 1.652253f, 0.348852f, 1.706477f, 1.485842f, 6.434575f, 1.733216f, 4.453848f,
1.412189f, 5.433201f, 0.025261f, 4.693707f, 3.196257f, 17.427390f, 3.321717f, 12.250340f, 1.004952f, 6.552912f, 1.379256f, 6.760479f, 2.800136f, 13.200490f, 3.544613f, 9.126930f,
0.171265f, 1.187905f, 0.004117f, 0.970100f, 0.216650f, 2.129606f, 0.302601f, 1.415109f, 0.001901f, 0.022342f, 0.003506f, 0.021789f, 0.484284f, 4.115865f, 0.823912f, 2.690113f,
0.574859f, 3.657832f, 0.013967f, 3.039823f, 1.030780f, 9.295144f, 1.455052f, 6.285448f, 0.496546f, 5.354863f, 0.925659f, 5.314418f, 1.448572f, 11.294070f, 2.490701f, 7.511896f,
0.110105f, 0.771433f, 0.003150f, 0.576632f, 0.271955f, 2.700312f, 0.452031f, 1.642366f, 0.085873f, 1.019701f, 0.188498f, 0.910241f, 0.503512f, 4.322614f, 1.019410f, 2.585957f,
0.541253f, 4.128124f, 0.016804f, 3.082282f, 1.420015f, 15.348750f, 2.561375f, 9.324990f, 0.457968f, 5.919895f, 1.090924f, 5.278573f, 1.388991f, 12.980760f, 3.051748f, 7.757006f,
0.758287f, 2.386719f, 0.012202f, 1.889134f, 0.681362f, 3.039300f, 0.636997f, 1.957449f, 0.006365f, 0.033955f, 0.007859f, 0.032096f, 1.700730f, 6.559202f, 1.936706f, 4.155151f,
3.056059f, 8.824279f, 0.049701f, 7.107718f, 3.892432f, 15.928180f, 3.677747f, 10.439330f, 1.996790f, 9.771830f, 2.491564f, 9.399609f, 6.108166f, 21.611070f, 7.029759f, 13.931620f,
0.587680f, 1.868467f, 0.011254f, 1.353668f, 1.031060f, 4.645747f, 1.147104f, 2.738660f, 0.346706f, 1.868237f, 0.509401f, 1.616374f, 2.131629f, 8.304312f, 2.888681f, 4.815098f,
1.563441f, 5.411145f, 0.032490f, 3.915933f, 2.913593f, 14.291050f, 3.517690f, 8.415227f, 1.000666f, 5.869790f, 1.595499f, 5.072845f, 3.182374f, 13.496050f, 4.680029f, 7.816768f,
0.112259f, 0.204428f, 0.001671f, 0.362752f, 0.146917f, 0.379158f, 0.127090f, 0.547451f, 0.001324f, 0.004087f, 0.001513f, 0.008662f, 0.337945f, 0.754075f, 0.356085f, 1.070923f,
0.283915f, 0.474307f, 0.004272f, 0.856481f, 0.526691f, 1.246963f, 0.460464f, 1.832180f, 0.260719f, 0.738190f, 0.301016f, 1.591878f, 0.761662f, 1.559123f, 0.811092f, 2.253272f,
0.001733f, 0.003188f, 0.000031f, 0.005178f, 0.004429f, 0.011546f, 0.004559f, 0.015259f, 0.001437f, 0.004480f, 0.001954f, 0.008690f, 0.008438f, 0.019019f, 0.010581f, 0.024723f,
0.206891f, 0.414287f, 0.003978f, 0.672134f, 0.561561f, 1.593619f, 0.627341f, 2.103750f, 0.186107f, 0.631608f, 0.274566f, 1.223727f, 0.565244f, 1.386895f, 0.769150f, 1.800827f,
0.174921f, 0.438564f, 0.002466f, 0.690719f, 0.216773f, 0.770238f, 0.177580f, 0.987071f, 0.002217f, 0.009420f, 0.002398f, 0.017717f, 0.481096f, 1.477991f, 0.480052f, 1.863008f,
0.620967f, 1.428272f, 0.008849f, 2.289122f, 1.090806f, 3.555635f, 0.903102f, 4.636932f, 0.612538f, 2.387819f, 0.669733f, 4.570274f, 1.521972f, 4.289403f, 1.534847f, 5.502110f,
0.143193f, 0.362653f, 0.002403f, 0.522787f, 0.346484f, 1.243599f, 0.337778f, 1.458713f, 0.127537f, 0.547433f, 0.164196f, 0.942428f, 0.636915f, 1.976506f, 0.756307f, 2.280376f,
0.395229f, 1.089636f, 0.007197f, 1.569042f, 1.015818f, 3.968952f, 1.074665f, 4.650339f, 0.381901f, 1.784468f, 0.533564f, 3.068632f, 0.986524f, 3.332637f, 1.271259f, 3.840746f,
0.046472f, 0.230978f, 0.001137f, 0.314412f, 0.066757f, 0.470226f, 0.094917f, 0.520822f, 0.000700f, 0.005899f, 0.001315f, 0.009589f, 0.165422f, 1.007448f, 0.286490f, 1.097551f,
0.140377f, 0.640070f, 0.003472f, 0.886636f, 0.285837f, 1.847047f, 0.410740f, 2.081857f, 0.164643f, 1.272333f, 0.312443f, 2.104754f, 0.445294f, 2.487864f, 0.779408f, 2.758155f,
0.029694f, 0.149081f, 0.000865f, 0.185744f, 0.083285f, 0.592591f, 0.140921f, 0.600764f, 0.031446f, 0.267574f, 0.070266f, 0.398126f, 0.170937f, 1.051579f, 0.352299f, 1.048600f,
0.119970f, 0.655686f, 0.003792f, 0.816034f, 0.357424f, 2.768432f, 0.656298f, 2.803509f, 0.137834f, 1.276749f, 0.334236f, 1.897584f, 0.387566f, 2.595465f, 0.866824f, 2.585248f,
0.530535f, 1.196606f, 0.008691f, 1.578720f, 0.541348f, 1.730378f, 0.515196f, 1.857594f, 0.006047f, 0.023116f, 0.007600f, 0.036420f, 1.497918f, 4.139738f, 1.736412f, 4.371209f,
1.924229f, 3.981473f, 0.031857f, 5.345491f, 2.783133f, 8.161094f, 2.676894f, 8.915545f, 1.707168f, 5.986721f, 2.168464f, 9.598775f, 4.841480f, 12.274760f, 5.672104f, 13.189590f,
0.408654f, 0.931041f, 0.007966f, 1.124317f, 0.814172f, 2.628797f, 0.922086f, 2.583048f, 0.327359f, 1.264050f, 0.489620f, 1.822918f, 1.865942f, 5.209062f, 2.574083f, 5.034472f,
0.893544f, 2.216117f, 0.018903f, 2.673201f, 1.890953f, 6.646383f, 2.324052f, 6.523490f, 0.776554f, 3.264185f, 1.260421f, 4.702152f, 2.289589f, 6.957966f, 3.427609f, 6.717317f,
0.396972f, 0.968610f, 0.006656f, 1.373016f, 0.540189f, 1.867938f, 0.526214f, 2.154492f, 0.003606f, 0.014912f, 0.004639f, 0.025244f, 0.854257f, 2.554030f, 1.013618f, 2.897525f,
0.779500f, 1.744840f, 0.013209f, 2.516934f, 1.503547f, 4.769620f, 1.480250f, 5.598295f, 0.551167f, 2.090971f, 0.716605f, 3.602031f, 1.494833f, 4.099962f, 1.792584f, 4.733373f,
0.004555f, 0.011226f, 0.000091f, 0.014565f, 0.012102f, 0.042270f, 0.014029f, 0.044626f, 0.002908f, 0.012147f, 0.004452f, 0.018821f, 0.015851f, 0.047871f, 0.022382f, 0.049709f,
0.601622f, 1.614183f, 0.013027f, 2.092012f, 1.697900f, 6.456081f, 2.135984f, 6.808261f, 0.416703f, 1.894882f, 0.692295f, 2.932760f, 1.174953f, 3.862758f, 1.800425f, 4.006670f,
0.815395f, 2.739239f, 0.012947f, 3.446321f, 1.050669f, 5.002131f, 0.969244f, 5.120786f, 0.007957f, 0.045301f, 0.009693f, 0.068064f, 1.603106f, 6.598902f, 1.801350f, 6.644649f,
2.247420f, 6.926210f, 0.036066f, 8.867703f, 4.104843f, 17.928150f, 3.827057f, 18.676980f, 1.706995f, 8.915995f, 2.101742f, 13.632270f, 3.937544f, 14.869100f, 4.471596f, 15.236130f,
0.496044f, 1.683289f, 0.009373f, 1.938430f, 1.248004f, 6.001804f, 1.370070f, 5.623788f, 0.340188f, 1.956513f, 0.493201f, 2.690649f, 1.577187f, 6.557963f, 2.109009f, 6.044146f,
1.515023f, 5.596554f, 0.031067f, 6.437709f, 4.048737f, 21.195740f, 4.823427f, 19.838780f, 1.127208f, 7.057187f, 1.773450f, 9.694495f, 2.703217f, 12.235740f, 3.922706f, 11.264590f,
0.212807f, 1.417222f, 0.005865f, 1.541072f, 0.317854f, 2.999900f, 0.508926f, 2.654286f, 0.002469f, 0.027868f, 0.005221f, 0.036188f, 0.541494f, 4.418680f, 1.056060f, 3.845496f,
0.499093f, 3.049177f, 0.013901f, 3.374097f, 1.056666f, 9.148849f, 1.709880f, 8.237530f, 0.450726f, 4.667019f, 0.963206f, 6.167334f, 1.131712f, 8.471977f, 2.230655f, 7.502987f,
0.101049f, 0.679766f, 0.003314f, 0.676566f, 0.294694f, 2.809484f, 0.561510f, 2.275271f, 0.082397f, 0.939434f, 0.207337f, 1.116607f, 0.415822f, 3.427543f, 0.965078f, 2.730287f,
0.451766f, 3.308301f, 0.016079f, 3.289085f, 1.399452f, 14.523690f, 2.893701f, 11.749050f, 0.399652f, 4.960195f, 1.091330f, 5.889138f, 1.043250f, 9.361116f, 2.627562f, 7.448558f,
1.122664f, 3.392782f, 0.020709f, 3.575755f, 1.191093f, 5.101285f, 1.276499f, 4.374687f, 0.009853f, 0.050465f, 0.013945f, 0.063517f, 2.265827f, 8.390367f, 2.957811f, 7.077293f,
3.161408f, 8.764692f, 0.058939f, 9.400221f, 4.754352f, 18.679920f, 5.149528f, 16.301670f, 2.159651f, 10.147660f, 3.089147f, 12.997210f, 5.685976f, 19.315630f, 7.501530f, 16.580010f,
0.642632f, 1.961756f, 0.014107f, 1.892441f, 1.331240f, 5.759260f, 1.697817f, 4.520638f, 0.396383f, 2.050804f, 0.667619f, 2.362568f, 2.097530f, 7.845826f, 3.258452f, 6.057460f,
1.554869f, 5.167019f, 0.037041f, 4.978936f, 3.421312f, 16.112630f, 4.735180f, 12.633350f, 1.040480f, 5.860111f, 1.901763f, 6.743499f, 2.847992f, 11.596660f, 4.801218f, 8.943424f,
0.015396f, 0.027551f, 0.000167f, 0.039281f, 0.018579f, 0.047117f, 0.011741f, 0.054662f, 0.000135f, 0.000410f, 0.000113f, 0.000698f, 0.046119f, 0.101125f, 0.035501f, 0.115394f,
0.029089f, 0.047754f, 0.000320f, 0.069287f, 0.049757f, 0.115762f, 0.031780f, 0.136666f, 0.019880f, 0.055313f, 0.016769f, 0.095842f, 0.077651f, 0.156199f, 0.060411f, 0.181382f,
0.000342f, 0.000618f, 0.000004f, 0.000806f, 0.000805f, 0.002063f, 0.000606f, 0.002190f, 0.000211f, 0.000646f, 0.000209f, 0.001007f, 0.001656f, 0.003667f, 0.001517f, 0.003830f,
0.045868f, 0.090257f, 0.000644f, 0.117656f, 0.114796f, 0.320129f, 0.093690f, 0.339560f, 0.030707f, 0.102409f, 0.033097f, 0.159425f, 0.124695f, 0.300656f, 0.123961f, 0.313675f,
0.015907f, 0.039192f, 0.000164f, 0.049596f, 0.018177f, 0.063467f, 0.010878f, 0.065352f, 0.000150f, 0.000626f, 0.000119f, 0.000947f, 0.043534f, 0.131426f, 0.031736f, 0.133109f,
0.042187f, 0.095352f, 0.000439f, 0.122791f, 0.068331f, 0.218875f, 0.041330f, 0.229347f, 0.030971f, 0.118640f, 0.024739f, 0.182454f, 0.102887f, 0.284946f, 0.075802f, 0.293681f,
0.018721f, 0.046592f, 0.000229f, 0.053967f, 0.041769f, 0.147320f, 0.029748f, 0.138846f, 0.012410f, 0.052344f, 0.011672f, 0.072404f, 0.082858f, 0.252677f, 0.071881f, 0.234237f,
0.058101f, 0.157408f, 0.000773f, 0.182122f, 0.137693f, 0.528669f, 0.106422f, 0.497708f, 0.041783f, 0.191852f, 0.042647f, 0.265085f, 0.144308f, 0.479051f, 0.135855f, 0.443599f,
0.000123f, 0.000603f, 0.000002f, 0.000659f, 0.000163f, 0.001131f, 0.000170f, 0.001007f, 0.000001f, 0.000011f, 0.000002f, 0.000015f, 0.000437f, 0.002615f, 0.000553f, 0.002289f,
0.000278f, 0.001247f, 0.000005f, 0.001388f, 0.000523f, 0.003319f, 0.000549f, 0.003006f, 0.000243f, 0.001846f, 0.000337f, 0.002453f, 0.000879f, 0.004825f, 0.001124f, 0.004298f,
0.000113f, 0.000559f, 0.000002f, 0.000560f, 0.000293f, 0.002049f, 0.000362f, 0.001669f, 0.000089f, 0.000747f, 0.000146f, 0.000893f, 0.000649f, 0.003925f, 0.000977f, 0.003144f,
0.000515f, 0.002765f, 0.000012f, 0.002765f, 0.001414f, 0.010765f, 0.001897f, 0.008759f, 0.000440f, 0.004007f, 0.000780f, 0.004785f, 0.001655f, 0.010892f, 0.002704f, 0.008717f,
0.044706f, 0.099087f, 0.000535f, 0.105040f, 0.042063f, 0.132121f, 0.029245f, 0.113963f, 0.000379f, 0.001425f, 0.000348f, 0.001803f, 0.125601f, 0.341106f, 0.106370f, 0.289401f,
0.121134f, 0.246301f, 0.001465f, 0.265700f, 0.161550f, 0.465515f, 0.113518f, 0.408616f, 0.079983f, 0.275629f, 0.074223f, 0.355085f, 0.303275f, 0.755585f, 0.259575f, 0.652355f,
0.049507f, 0.110839f, 0.000705f, 0.107546f, 0.090948f, 0.288565f, 0.075250f, 0.227825f, 0.029516f, 0.111996f, 0.032251f, 0.129774f, 0.224936f, 0.617067f, 0.226696f, 0.479191f,
0.121718f, 0.296649f, 0.001881f, 0.287517f, 0.237510f, 0.820349f, 0.213259f, 0.646957f, 0.078727f, 0.325191f, 0.093353f, 0.376393f, 0.310345f, 0.926790f, 0.339421f, 0.718913f,
0.012459f, 0.031661f, 0.000182f, 0.033706f, 0.012822f, 0.046179f, 0.010896f, 0.040001f, 0.000110f, 0.000472f, 0.000123f, 0.000600f, 0.032570f, 0.101419f, 0.033712f, 0.086411f,
0.035838f, 0.083549f, 0.000530f, 0.090512f, 0.052280f, 0.172730f, 0.044900f, 0.152261f, 0.024551f, 0.097005f, 0.027845f, 0.125500f, 0.083489f, 0.238494f, 0.087337f, 0.206784f,
0.000426f, 0.001094f, 0.000007f, 0.001066f, 0.000857f, 0.003116f, 0.000866f, 0.002471f, 0.000264f, 0.001147f, 0.000352f, 0.001335f, 0.001802f, 0.005669f, 0.002220f, 0.004421f,
0.053726f, 0.150132f, 0.001015f, 0.146128f, 0.114675f, 0.454139f, 0.125846f, 0.359671f, 0.036054f, 0.170752f, 0.052251f, 0.198477f, 0.127465f, 0.436446f, 0.170385f, 0.339990f,
0.021569f, 0.075465f, 0.000299f, 0.071306f, 0.021019f, 0.104225f, 0.016915f, 0.080132f, 0.000204f, 0.001209f, 0.000217f, 0.001364f, 0.051515f, 0.220853f, 0.050495f, 0.167014f,
0.087086f, 0.279524f, 0.001219f, 0.268772f, 0.120298f, 0.547216f, 0.097839f, 0.428134f, 0.064085f, 0.348623f, 0.068832f, 0.400317f, 0.185353f, 0.728990f, 0.183621f, 0.560998f,
0.039128f, 0.138289f, 0.000645f, 0.119599f, 0.074453f, 0.372916f, 0.071301f, 0.262426f, 0.025999f, 0.155731f, 0.032881f, 0.160842f, 0.151135f, 0.654503f, 0.176297f, 0.453030f,
0.114030f, 0.438713f, 0.002040f, 0.379001f, 0.230472f, 1.256632f, 0.239518f, 0.883332f, 0.082199f, 0.535987f, 0.112815f, 0.552965f, 0.247168f, 1.165208f, 0.312883f, 0.805634f,
0.005902f, 0.040934f, 0.000142f, 0.033428f, 0.006667f, 0.065532f, 0.009312f, 0.043545f, 0.000066f, 0.000780f, 0.000122f, 0.000761f, 0.018243f, 0.155042f, 0.031036f, 0.101335f,
0.020275f, 0.129012f, 0.000493f, 0.107215f, 0.032466f, 0.292762f, 0.045829f, 0.197968f, 0.017740f, 0.191316f, 0.033072f, 0.189871f, 0.055852f, 0.435459f, 0.096032f, 0.289632f,
0.008357f, 0.058548f, 0.000239f, 0.043764f, 0.018432f, 0.183013f, 0.030636f, 0.111311f, 0.006602f, 0.078394f, 0.014492f, 0.069979f, 0.041775f, 0.358634f, 0.084577f, 0.214549f,
0.035648f, 0.271888f, 0.001107f, 0.203007f, 0.083518f, 0.902739f, 0.150648f, 0.548450f, 0.030554f, 0.394955f, 0.072783f, 0.352168f, 0.100006f, 0.934601f, 0.219723f, 0.558497f,
0.034978f, 0.110095f, 0.000563f, 0.087142f, 0.028067f, 0.125196f, 0.026239f, 0.080632f, 0.000297f, 0.001587f, 0.000367f, 0.001500f, 0.085761f, 0.330754f, 0.097660f, 0.209528f,
0.144290f, 0.416632f, 0.002347f, 0.335586f, 0.164114f, 0.671570f, 0.155062f, 0.440147f, 0.095500f, 0.467353f, 0.119163f, 0.449551f, 0.315263f, 1.115420f, 0.362830f, 0.719058f,
0.059707f, 0.189831f, 0.001143f, 0.137529f, 0.093544f, 0.421491f, 0.104072f, 0.248468f, 0.035681f, 0.192269f, 0.052425f, 0.166349f, 0.236746f, 0.922304f, 0.320826f, 0.534781f,
0.137843f, 0.477081f, 0.002865f, 0.345254f, 0.229395f, 1.125172f, 0.276957f, 0.662553f, 0.089369f, 0.524230f, 0.142494f, 0.453055f, 0.306721f, 1.300765f, 0.451067f, 0.753389f,
0.000319f, 0.000582f, 0.000005f, 0.001032f, 0.000373f, 0.000963f, 0.000323f, 0.001391f, 0.000004f, 0.000012f, 0.000004f, 0.000025f, 0.001051f, 0.002345f, 0.001107f, 0.003331f,
0.000827f, 0.001381f, 0.000012f, 0.002494f, 0.001370f, 0.003243f, 0.001197f, 0.004764f, 0.000769f, 0.002177f, 0.000888f, 0.004696f, 0.002425f, 0.004963f, 0.002582f, 0.007173f,
0.000011f, 0.000020f, 0.000000f, 0.000032f, 0.000025f, 0.000065f, 0.000026f, 0.000085f, 0.000009f, 0.000028f, 0.000012f, 0.000055f, 0.000058f, 0.000130f, 0.000072f, 0.000169f,
0.001125f, 0.002253f, 0.000022f, 0.003655f, 0.002727f, 0.007738f, 0.003046f, 0.010216f, 0.001025f, 0.003479f, 0.001512f, 0.006741f, 0.003360f, 0.008244f, 0.004572f, 0.010705f,
0.000493f, 0.001236f, 0.000007f, 0.001947f, 0.000546f, 0.001939f, 0.000447f, 0.002484f, 0.000006f, 0.000027f, 0.000007f, 0.000051f, 0.001482f, 0.004554f, 0.001479f, 0.005740f,
0.001791f, 0.004121f, 0.000026f, 0.006604f, 0.002810f, 0.009160f, 0.002327f, 0.011946f, 0.001790f, 0.006978f, 0.001957f, 0.013356f, 0.004800f, 0.013528f, 0.004841f, 0.017352f,
0.000889f, 0.002251f, 0.000015f, 0.003245f, 0.001921f, 0.006894f, 0.001873f, 0.008087f, 0.000802f, 0.003443f, 0.001033f, 0.005926f, 0.004322f, 0.013413f, 0.005133f, 0.015476f,
0.002129f, 0.005870f, 0.000039f, 0.008453f, 0.004887f, 0.019094f, 0.005170f, 0.022372f, 0.002084f, 0.009738f, 0.002912f, 0.016746f, 0.005810f, 0.019627f, 0.007487f, 0.022619f,
0.000107f, 0.000531f, 0.000003f, 0.000723f, 0.000137f, 0.000965f, 0.000195f, 0.001069f, 0.000002f, 0.000014f, 0.000003f, 0.000022f, 0.000416f, 0.002532f, 0.000720f, 0.002758f,
0.000330f, 0.001506f, 0.000008f, 0.002086f, 0.000601f, 0.003881f, 0.000863f, 0.004375f, 0.000392f, 0.003033f, 0.000745f, 0.005017f, 0.001145f, 0.006400f, 0.002005f, 0.007095f,
0.000150f, 0.000755f, 0.000004f, 0.000941f, 0.000377f, 0.002680f, 0.000637f, 0.002717f, 0.000161f, 0.001372f, 0.000360f, 0.002042f, 0.000946f, 0.005821f, 0.001950f, 0.005804f,
0.000527f, 0.002881f, 0.000017f, 0.003586f, 0.001403f, 0.010864f, 0.002575f, 0.011001f, 0.000614f, 0.005683f, 0.001488f, 0.008447f, 0.001862f, 0.012468f, 0.004164f, 0.012419f,
0.001633f, 0.003683f, 0.000027f, 0.004859f, 0.001488f, 0.004756f, 0.001416f, 0.005105f, 0.000019f, 0.000072f, 0.000024f, 0.000114f, 0.005040f, 0.013928f, 0.005842f, 0.014706f,
0.006061f, 0.012542f, 0.000100f, 0.016839f, 0.007829f, 0.022957f, 0.007530f, 0.025080f, 0.005447f, 0.019103f, 0.006919f, 0.030629f, 0.016672f, 0.042269f, 0.019532f, 0.045419f,
0.002770f, 0.006311f, 0.000054f, 0.007621f, 0.004928f, 0.015912f, 0.005582f, 0.015636f, 0.002248f, 0.008679f, 0.003362f, 0.012517f, 0.013827f, 0.038599f, 0.019074f, 0.037305f,
0.005256f, 0.013036f, 0.000111f, 0.015725f, 0.009933f, 0.034913f, 0.012208f, 0.034268f, 0.004627f, 0.019450f, 0.007510f, 0.028018f, 0.014723f, 0.044743f, 0.022041f, 0.043195f,
0.030336f, 0.074020f, 0.000509f, 0.104924f, 0.036864f, 0.127472f, 0.035910f, 0.147027f, 0.000279f, 0.001154f, 0.000359f, 0.001954f, 0.071364f, 0.213361f, 0.084677f, 0.242056f,
0.060971f, 0.136478f, 0.001033f, 0.196870f, 0.105021f, 0.333153f, 0.103394f, 0.391035f, 0.043670f, 0.165673f, 0.056779f, 0.285398f, 0.127817f, 0.350572f, 0.153277f, 0.404732f,
0.000767f, 0.001889f, 0.000015f, 0.002452f, 0.001819f, 0.006353f, 0.002109f, 0.006707f, 0.000496f, 0.002071f, 0.000759f, 0.003209f, 0.002917f, 0.008808f, 0.004118f, 0.009146f,
0.087874f, 0.235771f, 0.001903f, 0.305564f, 0.221463f, 0.842090f, 0.278604f, 0.888026f, 0.061654f, 0.280360f, 0.102430f, 0.433921f, 0.187606f, 0.616772f, 0.287476f, 0.639750f,
0.061734f, 0.207388f, 0.000980f, 0.260921f, 0.071035f, 0.338189f, 0.065530f, 0.346211f, 0.000610f, 0.003474f, 0.000743f, 0.005220f, 0.132680f, 0.546153f, 0.149087f, 0.549939f,
0.174159f, 0.536732f, 0.002795f, 0.687184f, 0.284060f, 1.240648f, 0.264836f, 1.292468f, 0.133995f, 0.699886f, 0.164982f, 1.070103f, 0.333561f, 1.259607f, 0.378803f, 1.290700f,
0.082716f, 0.280691f, 0.001563f, 0.323236f, 0.185839f, 0.893723f, 0.204016f, 0.837433f, 0.057462f, 0.330482f, 0.083309f, 0.454488f, 0.287502f, 1.195440f, 0.384447f, 1.101777f,
0.219235f, 0.809864f, 0.004496f, 0.931586f, 0.523193f, 2.738996f, 0.623302f, 2.563644f, 0.165231f, 1.034472f, 0.259960f, 1.421060f, 0.427623f, 1.935577f, 0.620535f, 1.781951f,
0.013142f, 0.087519f, 0.000362f, 0.095168f, 0.017529f, 0.165434f, 0.028065f, 0.146375f, 0.000154f, 0.001743f, 0.000327f, 0.002264f, 0.036555f, 0.298296f, 0.071293f, 0.259602f,
0.031547f, 0.192734f, 0.000879f, 0.213271f, 0.059644f, 0.516408f, 0.096514f, 0.464968f, 0.028859f, 0.298820f, 0.061672f, 0.394883f, 0.078199f, 0.585394f, 0.154133f, 0.518439f,
0.013744f, 0.092458f, 0.000451f, 0.092022f, 0.035794f, 0.341241f, 0.068201f, 0.276355f, 0.011352f, 0.129433f, 0.028566f, 0.153843f, 0.061827f, 0.509630f, 0.143494f, 0.405957f,
0.053323f, 0.390490f, 0.001898f, 0.388221f, 0.147508f, 1.530850f, 0.305007f, 1.238393f, 0.047784f, 0.593061f, 0.130484f, 0.704129f, 0.134611f, 1.207872f, 0.339036f, 0.961093f,
0.092807f, 0.280471f, 0.001712f, 0.295597f, 0.087928f, 0.376585f, 0.094233f, 0.322947f, 0.000825f, 0.004226f, 0.001168f, 0.005319f, 0.204761f, 0.758232f, 0.267295f, 0.639570f,
0.267498f, 0.741613f, 0.004987f, 0.795387f, 0.359239f, 1.411454f, 0.389098f, 1.231754f, 0.185106f, 0.869765f, 0.264774f, 1.114003f, 0.525938f, 1.786645f, 0.693872f, 1.533607f,
0.117007f, 0.357185f, 0.002569f, 0.344565f, 0.216449f, 0.936411f, 0.276052f, 0.735021f, 0.073107f, 0.378241f, 0.123133f, 0.435741f, 0.417490f, 1.561623f, 0.648558f, 1.205669f,
0.245677f, 0.816414f, 0.005853f, 0.786696f, 0.482741f, 2.273464f, 0.668126f, 1.782544f, 0.166533f, 0.937933f, 0.304384f, 1.079323f, 0.491924f, 2.003051f, 0.829298f, 1.544767f,
0.036121f, 0.064639f, 0.000393f, 0.092161f, 0.059299f, 0.150387f, 0.037475f, 0.174468f, 0.000335f, 0.001015f, 0.000279f, 0.001728f, 0.096303f, 0.211163f, 0.074132f, 0.240959f,
0.056020f, 0.091965f, 0.000616f, 0.133433f, 0.130359f, 0.303285f, 0.083261f, 0.358052f, 0.040399f, 0.112403f, 0.034076f, 0.194760f, 0.133095f, 0.267727f, 0.103545f, 0.310890f,
0.000570f, 0.001031f, 0.000007f, 0.001345f, 0.001827f, 0.004681f, 0.001374f, 0.004971f, 0.000371f, 0.001137f, 0.000369f, 0.001772f, 0.002458f, 0.005444f, 0.002252f, 0.005686f,
0.090751f, 0.178575f, 0.001275f, 0.232786f, 0.308986f, 0.861664f, 0.252177f, 0.913964f, 0.064108f, 0.213802f, 0.069097f, 0.332836f, 0.219580f, 0.529434f, 0.218287f, 0.552360f,
0.042840f, 0.105549f, 0.000441f, 0.133569f, 0.066596f, 0.232530f, 0.039856f, 0.239434f, 0.000426f, 0.001780f, 0.000337f, 0.002690f, 0.104349f, 0.315022f, 0.076069f, 0.319055f,
0.093258f, 0.210785f, 0.000971f, 0.271444f, 0.205494f, 0.658233f, 0.124293f, 0.689724f, 0.072243f, 0.276742f, 0.057706f, 0.425597f, 0.202429f, 0.560628f, 0.149139f, 0.577815f,
0.035850f, 0.089221f, 0.000439f, 0.103344f, 0.108813f, 0.383788f, 0.077498f, 0.361712f, 0.025075f, 0.105768f, 0.023585f, 0.146303f, 0.141220f, 0.430649f, 0.122510f, 0.399222f,
0.131954f, 0.357493f, 0.001755f, 0.413621f, 0.425426f, 1.633410f, 0.328807f, 1.537751f, 0.100131f, 0.459769f, 0.102204f, 0.635269f, 0.291696f, 0.968328f, 0.274610f, 0.896668f,
0.000240f, 0.001174f, 0.000004f, 0.001284f, 0.000433f, 0.002998f, 0.000450f, 0.002668f, 0.000003f, 0.000024f, 0.000004f, 0.000031f, 0.000758f, 0.004534f, 0.000959f, 0.003969f,
0.000445f, 0.001995f, 0.000008f, 0.002220f, 0.001137f, 0.007220f, 0.001194f, 0.006539f, 0.000410f, 0.003114f, 0.000568f, 0.004139f, 0.001251f, 0.006866f, 0.001599f, 0.006116f,
0.000157f, 0.000774f, 0.000003f, 0.000775f, 0.000552f, 0.003862f, 0.000683f, 0.003146f, 0.000131f, 0.001092f, 0.000213f, 0.001305f, 0.000800f, 0.004838f, 0.001205f, 0.003876f,
0.000846f, 0.004543f, 0.000020f, 0.004542f, 0.003161f, 0.024059f, 0.004240f, 0.019576f, 0.000763f, 0.006946f, 0.001352f, 0.008295f, 0.002420f, 0.015925f, 0.003954f, 0.012745f,
0.117224f, 0.259817f, 0.001403f, 0.275425f, 0.150042f, 0.471292f, 0.104320f, 0.406520f, 0.001049f, 0.003942f, 0.000963f, 0.004990f, 0.293117f, 0.796044f, 0.248236f, 0.675379f,
0.260717f, 0.530112f, 0.003153f, 0.571865f, 0.473020f, 1.363031f, 0.332381f, 1.196429f, 0.181649f, 0.625976f, 0.168566f, 0.806429f, 0.580950f, 1.447389f, 0.497239f, 1.249641f,
0.092303f, 0.206653f, 0.001315f, 0.200513f, 0.230680f, 0.731918f, 0.190864f, 0.577856f, 0.058067f, 0.220334f, 0.063449f, 0.255309f, 0.373256f, 1.023953f, 0.376176f, 0.795163f,
0.269144f, 0.655954f, 0.004160f, 0.635762f, 0.714468f, 2.467740f, 0.641517f, 1.946148f, 0.183690f, 0.758753f, 0.217816f, 0.878221f, 0.610766f, 1.823943f, 0.667988f, 1.414838f,
0.040551f, 0.103050f, 0.000593f, 0.109704f, 0.056774f, 0.204471f, 0.048245f, 0.177118f, 0.000377f, 0.001622f, 0.000423f, 0.002062f, 0.094349f, 0.293791f, 0.097658f, 0.250316f,
0.095744f, 0.223210f, 0.001415f, 0.241813f, 0.190013f, 0.627786f, 0.163187f, 0.553392f, 0.069211f, 0.273464f, 0.078497f, 0.353793f, 0.198519f, 0.567088f, 0.207670f, 0.491690f,
0.000987f, 0.002532f, 0.000017f, 0.002468f, 0.002697f, 0.009811f, 0.002727f, 0.007779f, 0.000644f, 0.002801f, 0.000860f, 0.003260f, 0.003712f, 0.011676f, 0.004572f, 0.009106f,
0.147463f, 0.412074f, 0.002785f, 0.401085f, 0.428197f, 1.695749f, 0.469909f, 1.343007f, 0.104420f, 0.494538f, 0.151333f, 0.574835f, 0.311383f, 1.066187f, 0.416231f, 0.830556f,
0.080583f, 0.281947f, 0.001116f, 0.266405f, 0.106835f, 0.529740f, 0.085973f, 0.407280f, 0.000804f, 0.004767f, 0.000854f, 0.005379f, 0.171297f, 0.734382f, 0.167908f, 0.555357f,
0.267066f, 0.857218f, 0.003739f, 0.824245f, 0.501882f, 2.282978f, 0.408183f, 1.786169f, 0.207378f, 1.128134f, 0.222738f, 1.295415f, 0.505910f, 1.989729f, 0.501182f, 1.531206f,
0.103946f, 0.367372f, 0.001713f, 0.317722f, 0.269075f, 1.347721f, 0.257682f, 0.948411f, 0.072879f, 0.436542f, 0.092170f, 0.450868f, 0.357341f, 1.547498f, 0.416834f, 1.071139f,
0.359268f, 1.382233f, 0.006427f, 1.194102f, 0.987846f, 5.386165f, 1.026621f, 3.786130f, 0.273274f, 1.781917f, 0.375058f, 1.838360f, 0.693096f, 3.267415f, 0.877371f, 2.259119f,
0.015949f, 0.110620f, 0.000383f, 0.090338f, 0.024509f, 0.240920f, 0.034233f, 0.160090f, 0.000189f, 0.002224f, 0.000349f, 0.002169f, 0.043877f, 0.372908f, 0.074649f, 0.243731f,
0.044975f, 0.286179f, 0.001093f, 0.237827f, 0.097972f, 0.883469f, 0.138297f, 0.597409f, 0.041524f, 0.447806f, 0.077409f, 0.444423f, 0.110266f, 0.859712f, 0.189594f, 0.571810f,
0.016057f, 0.112504f, 0.000459f, 0.084094f, 0.048182f, 0.478414f, 0.080086f, 0.290978f, 0.013386f, 0.158953f, 0.029383f, 0.141890f, 0.071444f, 0.613342f, 0.144646f, 0.366926f,
0.081240f, 0.619619f, 0.002522f, 0.462641f, 0.258932f, 2.798767f, 0.467054f, 1.700364f, 0.073474f, 0.949759f, 0.175022f, 0.846868f, 0.202843f, 1.895660f, 0.445666f, 1.132804f,
0.127235f, 0.400475f, 0.002047f, 0.316983f, 0.138891f, 0.619540f, 0.129847f, 0.399012f, 0.001142f, 0.006090f, 0.001409f, 0.005756f, 0.277650f, 1.070813f, 0.316174f, 0.678343f,
0.430821f, 1.243984f, 0.007007f, 1.001995f, 0.666620f, 2.727868f, 0.629853f, 1.787846f, 0.300881f, 1.472444f, 0.375435f, 1.416357f, 0.837790f, 2.964152f, 0.964195f, 1.910847f,
0.154430f, 0.490993f, 0.002957f, 0.355715f, 0.329151f, 1.483088f, 0.366197f, 0.874278f, 0.097382f, 0.524746f, 0.143079f, 0.454003f, 0.544992f, 2.123157f, 0.738547f, 1.231072f,
0.422839f, 1.463467f, 0.008787f, 1.059081f, 0.957292f, 4.695476f, 1.155774f, 2.764912f, 0.289274f, 1.696851f, 0.461230f, 1.466469f, 0.837401f, 3.551314f, 1.231490f, 2.056883f,
0.028250f, 0.051445f, 0.000421f, 0.091287f, 0.044915f, 0.115916f, 0.038854f, 0.167366f, 0.000356f, 0.001099f, 0.000407f, 0.002330f, 0.082744f, 0.184630f, 0.087185f, 0.262209f,
0.060028f, 0.100281f, 0.000903f, 0.181084f, 0.135282f, 0.320285f, 0.118271f, 0.470600f, 0.058920f, 0.166823f, 0.068027f, 0.359748f, 0.156680f, 0.320723f, 0.166848f, 0.463515f,
0.000683f, 0.001256f, 0.000012f, 0.002041f, 0.002120f, 0.005528f, 0.002183f, 0.007306f, 0.000605f, 0.001887f, 0.000823f, 0.003661f, 0.003236f, 0.007293f, 0.004057f, 0.009480f,
0.083919f, 0.168043f, 0.001614f, 0.272631f, 0.276719f, 0.785282f, 0.309133f, 1.036658f, 0.080688f, 0.273839f, 0.119040f, 0.530556f, 0.223072f, 0.547333f, 0.303543f, 0.710690f,
0.050060f, 0.125512f, 0.000706f, 0.197676f, 0.075366f, 0.267792f, 0.061740f, 0.343180f, 0.000678f, 0.002881f, 0.000734f, 0.005420f, 0.133959f, 0.411540f, 0.133668f, 0.518746f,
0.149308f, 0.343419f, 0.002128f, 0.550405f, 0.318627f, 1.038609f, 0.263798f, 1.354459f, 0.157425f, 0.613680f, 0.172124f, 1.174581f, 0.356048f, 1.003457f, 0.359060f, 1.287156f,
0.064178f, 0.162539f, 0.001077f, 0.234311f, 0.188657f, 0.677126f, 0.183917f, 0.794254f, 0.061099f, 0.262256f, 0.078661f, 0.451485f, 0.277739f, 0.861895f, 0.329803f, 0.994404f,
0.182314f, 0.502635f, 0.003320f, 0.723779f, 0.569258f, 2.224176f, 0.602236f, 2.606021f, 0.188300f, 0.879848f, 0.263079f, 1.513017f, 0.442760f, 1.495713f, 0.570550f, 1.723756f,
0.007847f, 0.039000f, 0.000192f, 0.053088f, 0.013694f, 0.096455f, 0.019470f, 0.106834f, 0.000126f, 0.001065f, 0.000237f, 0.001731f, 0.027176f, 0.165504f, 0.047065f, 0.180307f,
0.019914f, 0.090800f, 0.000493f, 0.125778f, 0.049261f, 0.318317f, 0.070786f, 0.358783f, 0.024965f, 0.192925f, 0.047376f, 0.319145f, 0.061460f, 0.343380f, 0.107575f, 0.380686f,
0.007852f, 0.039422f, 0.000229f, 0.049117f, 0.026755f, 0.190366f, 0.045270f, 0.192992f, 0.008888f, 0.075629f, 0.019860f, 0.112528f, 0.043978f, 0.270548f, 0.090639f, 0.269782f,
0.032651f, 0.178449f, 0.001032f, 0.222088f, 0.118175f, 0.915321f, 0.216990f, 0.926918f, 0.040096f, 0.371408f, 0.097230f, 0.552009f, 0.102625f, 0.687261f, 0.229529f, 0.684555f,
0.161411f, 0.364058f, 0.002644f, 0.480314f, 0.200087f, 0.639562f, 0.190421f, 0.686582f, 0.001966f, 0.007517f, 0.002472f, 0.011844f, 0.443401f, 1.225410f, 0.513998f, 1.293928f,
0.491856f, 1.017713f, 0.008143f, 1.366372f, 0.864246f, 2.534262f, 0.831255f, 2.768542f, 0.466429f, 1.635679f, 0.592463f, 2.622556f, 1.204061f, 3.052692f, 1.410634f, 3.280208f,
0.194711f, 0.443613f, 0.003796f, 0.535704f, 0.471274f, 1.521649f, 0.533739f, 1.495168f, 0.166720f, 0.643765f, 0.249358f, 0.928390f, 0.865013f, 2.414815f, 1.193293f, 2.333879f,
0.438183f, 1.086757f, 0.009270f, 1.310905f, 1.126529f, 3.959558f, 1.384546f, 3.886346f, 0.407042f, 1.710968f, 0.660667f, 2.464699f, 1.092411f, 3.319790f, 1.635384f, 3.204972f,
0.080377f, 0.196119f, 0.001348f, 0.278000f, 0.132873f, 0.459467f, 0.129436f, 0.529952f, 0.000780f, 0.003227f, 0.001004f, 0.005463f, 0.168286f, 0.503135f, 0.199679f, 0.570802f,
0.132601f, 0.296816f, 0.002247f, 0.428157f, 0.310721f, 0.985682f, 0.305906f, 1.156935f, 0.100217f, 0.380195f, 0.130298f, 0.654947f, 0.247408f, 0.678578f, 0.296688f, 0.783413f,
0.001444f, 0.003560f, 0.000029f, 0.004619f, 0.004662f, 0.016283f, 0.005404f, 0.017191f, 0.000986f, 0.004117f, 0.001509f, 0.006379f, 0.004890f, 0.014769f, 0.006905f, 0.015336f,
0.196342f, 0.526796f, 0.004252f, 0.682737f, 0.673168f, 2.559648f, 0.846855f, 2.699277f, 0.145360f, 0.660996f, 0.241495f, 1.023042f, 0.373077f, 1.226523f, 0.571680f, 1.272219f,
0.187754f, 0.630741f, 0.002981f, 0.793555f, 0.293906f, 1.399260f, 0.271129f, 1.432451f, 0.001958f, 0.011150f, 0.002386f, 0.016752f, 0.359147f, 1.478366f, 0.403560f, 1.488614f,
0.434778f, 1.339920f, 0.006977f, 1.715514f, 0.964720f, 4.213475f, 0.899435f, 4.389465f, 0.352974f, 1.843658f, 0.434600f, 2.818894f, 0.741135f, 2.798701f, 0.841655f, 2.867784f,
0.178878f, 0.607010f, 0.003380f, 0.699016f, 0.546733f, 2.629304f, 0.600208f, 2.463701f, 0.131124f, 0.754132f, 0.190103f, 1.037103f, 0.553362f, 2.300885f, 0.739954f, 2.120611f,
0.562290f, 2.077122f, 0.011530f, 2.389311f, 1.825503f, 9.556782f, 2.174797f, 8.944952f, 0.447170f, 2.799629f, 0.703538f, 3.845864f, 0.976137f, 4.418351f, 1.416497f, 4.067667f,
0.028910f, 0.192533f, 0.000797f, 0.209359f, 0.052459f, 0.495104f, 0.083993f, 0.438064f, 0.000359f, 0.004047f, 0.000758f, 0.005255f, 0.071573f, 0.584049f, 0.139587f, 0.508287f,
0.056965f, 0.348026f, 0.001587f, 0.385112f, 0.146517f, 1.268579f, 0.237092f, 1.142216f, 0.054988f, 0.569372f, 0.117510f, 0.752409f, 0.125676f, 0.940812f, 0.247714f, 0.833206f,
0.021499f, 0.144625f, 0.000705f, 0.143944f, 0.076169f, 0.726159f, 0.145132f, 0.588083f, 0.018738f, 0.213638f, 0.047151f, 0.253928f, 0.086076f, 0.709505f, 0.199772f, 0.565172f,
0.098924f, 0.724423f, 0.003521f, 0.720216f, 0.372278f, 3.863547f, 0.769773f, 3.125445f, 0.093540f, 1.160951f, 0.255429f, 1.378373f, 0.222262f, 1.994362f, 0.559795f, 1.586896f,
0.274814f, 0.830511f, 0.005069f, 0.875301f, 0.354207f, 1.517019f, 0.379605f, 1.300943f, 0.002578f, 0.013204f, 0.003649f, 0.016619f, 0.539641f, 1.998293f, 0.704448f, 1.685565f,
0.650177f, 1.802552f, 0.012121f, 1.933255f, 1.187857f, 4.667109f, 1.286591f, 4.072912f, 0.474747f, 2.230717f, 0.679074f, 2.857122f, 1.137745f, 3.864994f, 1.501031f, 3.317605f,
0.246359f, 0.752057f, 0.005408f, 0.725484f, 0.619989f, 2.682217f, 0.790711f, 2.105363f, 0.162423f, 0.840344f, 0.273566f, 0.968094f, 0.782352f, 2.926394f, 1.215361f, 2.259356f,
0.613484f, 2.038682f, 0.014615f, 1.964473f, 1.639925f, 7.723205f, 2.269696f, 6.055497f, 0.438804f, 2.471398f, 0.802035f, 2.843952f, 1.093294f, 4.451752f, 1.843103f, 3.433223f,
0.007730f, 0.013833f, 0.000084f, 0.019722f, 0.012960f, 0.032866f, 0.008190f, 0.038129f, 0.000086f, 0.000260f, 0.000072f, 0.000443f, 0.026137f, 0.057311f, 0.020120f, 0.065398f,
0.015845f, 0.026012f, 0.000174f, 0.037742f, 0.037656f, 0.087607f, 0.024051f, 0.103428f, 0.013700f, 0.038118f, 0.011556f, 0.066046f, 0.047746f, 0.096043f, 0.037145f, 0.111527f,
0.000178f, 0.000322f, 0.000002f, 0.000420f, 0.000583f, 0.001495f, 0.000439f, 0.001587f, 0.000139f, 0.000426f, 0.000138f, 0.000664f, 0.000975f, 0.002159f, 0.000893f, 0.002255f,
0.028096f, 0.055287f, 0.000395f, 0.072070f, 0.097695f, 0.272439f, 0.079733f, 0.288976f, 0.023796f, 0.079360f, 0.025648f, 0.123544f, 0.086220f, 0.207887f, 0.085712f, 0.216889f,
0.011347f, 0.027956f, 0.000117f, 0.035377f, 0.018014f, 0.062897f, 0.010781f, 0.064765f, 0.000135f, 0.000565f, 0.000107f, 0.000854f, 0.035053f, 0.105823f, 0.025553f, 0.107177f,
0.032648f, 0.073793f, 0.000340f, 0.095028f, 0.073469f, 0.235334f, 0.044438f, 0.246593f, 0.030322f, 0.116156f, 0.024221f, 0.178633f, 0.089880f, 0.248922f, 0.066219f, 0.256553f,
0.013871f, 0.034522f, 0.000170f, 0.039986f, 0.042997f, 0.151651f, 0.030623f, 0.142928f, 0.011632f, 0.049064f, 0.010941f, 0.067868f, 0.069300f, 0.211330f, 0.060119f, 0.195908f,
0.050564f, 0.136988f, 0.000673f, 0.158496f, 0.166483f, 0.639208f, 0.128673f, 0.601773f, 0.046002f, 0.211225f, 0.046954f, 0.291853f, 0.141762f, 0.470601f, 0.133459f, 0.435775f,
0.000095f, 0.000463f, 0.000002f, 0.000506f, 0.000174f, 0.001207f, 0.000181f, 0.001074f, 0.000001f, 0.000011f, 0.000002f, 0.000015f, 0.000379f, 0.002268f, 0.000479f, 0.001985f,
0.000232f, 0.001040f, 0.000004f, 0.001157f, 0.000605f, 0.003844f, 0.000635f, 0.003481f, 0.000256f, 0.001946f, 0.000355f, 0.002587f, 0.000827f, 0.004539f, 0.001057f, 0.004044f,
0.000090f, 0.000446f, 0.000002f, 0.000447f, 0.000325f, 0.002272f, 0.000402f, 0.001851f, 0.000090f, 0.000754f, 0.000147f, 0.000901f, 0.000585f, 0.003535f, 0.000880f, 0.002832f,
0.000483f, 0.002592f, 0.000011f, 0.002592f, 0.001842f, 0.014019f, 0.002471f, 0.011407f, 0.000522f, 0.004752f, 0.000925f, 0.005674f, 0.001751f, 0.011523f, 0.002861f, 0.009223f,
0.030523f, 0.067651f, 0.000365f, 0.071715f, 0.039898f, 0.125323f, 0.027740f, 0.108099f, 0.000328f, 0.001230f, 0.000301f, 0.001558f, 0.096798f, 0.262883f, 0.081977f, 0.223035f,
0.089728f, 0.182443f, 0.001085f, 0.196813f, 0.166254f, 0.479069f, 0.116823f, 0.420513f, 0.074952f, 0.258291f, 0.069554f, 0.332750f, 0.253580f, 0.631773f, 0.217040f, 0.545458f,
0.035110f, 0.078605f, 0.000500f, 0.076270f, 0.089609f, 0.284318f, 0.074142f, 0.224471f, 0.026481f, 0.100481f, 0.028935f, 0.116431f, 0.180066f, 0.493975f, 0.181475f, 0.383602f,
0.101388f, 0.247101f, 0.001567f, 0.239494f, 0.274863f, 0.949364f, 0.246798f, 0.748703f, 0.082962f, 0.342684f, 0.098374f, 0.396641f, 0.291805f, 0.871422f, 0.319144f, 0.675965f,
0.008535f, 0.021691f, 0.000125f, 0.023092f, 0.012204f, 0.043954f, 0.010371f, 0.038074f, 0.000095f, 0.000409f, 0.000107f, 0.000520f, 0.025188f, 0.078430f, 0.026071f, 0.066824f,
0.026638f, 0.062100f, 0.000394f, 0.067276f, 0.053988f, 0.178372f, 0.046366f, 0.157234f, 0.023086f, 0.091217f, 0.026184f, 0.118011f, 0.070049f, 0.200101f, 0.073278f, 0.173496f,
0.000303f, 0.000779f, 0.000005f, 0.000759f, 0.000847f, 0.003081f, 0.000856f, 0.002443f, 0.000237f, 0.001033f, 0.000317f, 0.001202f, 0.001448f, 0.004553f, 0.001783f, 0.003551f,
0.044906f, 0.125487f, 0.000848f, 0.122140f, 0.133168f, 0.527373f, 0.146140f, 0.417671f, 0.038124f, 0.180557f, 0.055252f, 0.209874f, 0.120264f, 0.411787f, 0.160758f, 0.320781f,
0.020994f, 0.073453f, 0.000291f, 0.069404f, 0.028424f, 0.140942f, 0.022874f, 0.108360f, 0.000251f, 0.001489f, 0.000267f, 0.001680f, 0.056599f, 0.242652f, 0.055480f, 0.183499f,
0.091963f, 0.295181f, 0.001287f, 0.283827f, 0.176494f, 0.802843f, 0.143543f, 0.628133f, 0.085615f, 0.465746f, 0.091956f, 0.534807f, 0.220946f, 0.868974f, 0.218881f, 0.668723f,
0.039560f, 0.139815f, 0.000652f, 0.120919f, 0.104581f, 0.523815f, 0.100153f, 0.368617f, 0.033254f, 0.199188f, 0.042056f, 0.205725f, 0.172482f, 0.746951f, 0.201199f, 0.517020f,
0.135412f, 0.520978f, 0.002422f, 0.450070f, 0.380242f, 2.073243f, 0.395167f, 1.457357f, 0.123489f, 0.805225f, 0.169484f, 0.830731f, 0.331320f, 1.561919f, 0.419409f, 1.079924f,
0.006187f, 0.042911f, 0.000149f, 0.035043f, 0.009709f, 0.095441f, 0.013561f, 0.063420f, 0.000088f, 0.001034f, 0.000162f, 0.001009f, 0.021587f, 0.183463f, 0.036726f, 0.119911f,
0.023060f, 0.146730f, 0.000560f, 0.121939f, 0.051300f, 0.462601f, 0.072415f, 0.312814f, 0.025526f, 0.275273f, 0.047585f, 0.273194f, 0.071704f, 0.559051f, 0.123288f, 0.371835f,
0.009099f, 0.063753f, 0.000260f, 0.047654f, 0.027884f, 0.276865f, 0.046347f, 0.168393f, 0.009094f, 0.107992f, 0.019963f, 0.096400f, 0.051347f, 0.440809f, 0.103957f, 0.263709f,
0.045593f, 0.347735f, 0.001416f, 0.259638f, 0.148403f, 1.604069f, 0.267684f, 0.974537f, 0.049437f, 0.639042f, 0.117763f, 0.569812f, 0.144378f, 1.349275f, 0.317212f, 0.806296f,
0.032587f, 0.102567f, 0.000524f, 0.081184f, 0.036328f, 0.162044f, 0.033962f, 0.104364f, 0.000351f, 0.001870f, 0.000433f, 0.001768f, 0.090187f, 0.347826f, 0.102701f, 0.220342f,
0.145841f, 0.421113f, 0.002372f, 0.339195f, 0.230459f, 0.943060f, 0.217748f, 0.618082f, 0.122116f, 0.597605f, 0.152374f, 0.574842f, 0.359695f, 1.272624f, 0.413966f, 0.820400f,
0.057778f, 0.183699f, 0.001106f, 0.133087f, 0.125765f, 0.566673f, 0.139920f, 0.334053f, 0.043682f, 0.235382f, 0.064180f, 0.203650f, 0.258606f, 1.007468f, 0.350451f, 0.584161f,
0.156675f, 0.542260f, 0.003256f, 0.392423f, 0.362245f, 1.776794f, 0.437351f, 1.046258f, 0.128507f, 0.753808f, 0.204897f, 0.651463f, 0.393527f, 1.668900f, 0.578725f, 0.966609f,
0.004425f, 0.008059f, 0.000066f, 0.014300f, 0.007185f, 0.018543f, 0.006216f, 0.026774f, 0.000067f, 0.000206f, 0.000076f, 0.000438f, 0.016439f, 0.036680f, 0.017321f, 0.052093f,
0.012428f, 0.020763f, 0.000187f, 0.037493f, 0.028605f, 0.067723f, 0.025008f, 0.099506f, 0.014626f, 0.041411f, 0.016886f, 0.089301f, 0.041143f, 0.084219f, 0.043813f, 0.121715f,
0.000156f, 0.000288f, 0.000003f, 0.000467f, 0.000496f, 0.001292f, 0.000510f, 0.001707f, 0.000166f, 0.000518f, 0.000226f, 0.001004f, 0.000939f, 0.002117f, 0.001177f, 0.002751f,
0.019018f, 0.038083f, 0.000366f, 0.061785f, 0.064044f, 0.181746f, 0.071546f, 0.239925f, 0.021923f, 0.074404f, 0.032344f, 0.144155f, 0.064116f, 0.157317f, 0.087246f, 0.204270f,
0.009706f, 0.024334f, 0.000137f, 0.038325f, 0.014922f, 0.053022f, 0.012224f, 0.067949f, 0.000158f, 0.000670f, 0.000171f, 0.001260f, 0.032939f, 0.101195f, 0.032868f, 0.127556f,
0.038262f, 0.088004f, 0.000545f, 0.141047f, 0.083386f, 0.271810f, 0.069037f, 0.354469f, 0.048367f, 0.188545f, 0.052883f, 0.360874f, 0.115719f, 0.326133f, 0.116698f, 0.418339f,
0.018177f, 0.046035f, 0.000305f, 0.066362f, 0.054568f, 0.195854f, 0.053197f, 0.229732f, 0.020747f, 0.089053f, 0.026710f, 0.153308f, 0.099766f, 0.309599f, 0.118468f, 0.357198f,
0.051138f, 0.140986f, 0.000931f, 0.203015f, 0.163066f, 0.637123f, 0.172513f, 0.746504f, 0.063323f, 0.295884f, 0.088471f, 0.508812f, 0.157509f, 0.532091f, 0.202970f, 0.613217f,
0.002265f, 0.011259f, 0.000055f, 0.015325f, 0.004037f, 0.028436f, 0.005740f, 0.031496f, 0.000044f, 0.000368f, 0.000082f, 0.000599f, 0.009950f, 0.060595f, 0.017232f, 0.066015f,
0.007598f, 0.034646f, 0.000188f, 0.047992f, 0.019195f, 0.124039f, 0.027583f, 0.139808f, 0.011421f, 0.088256f, 0.021673f, 0.145998f, 0.029743f, 0.166172f, 0.052059f, 0.184225f,
0.003311f, 0.016625f, 0.000096f, 0.020713f, 0.011523f, 0.081986f, 0.019497f, 0.083117f, 0.004494f, 0.038238f, 0.010041f, 0.056894f, 0.023522f, 0.144703f, 0.048478f, 0.144292f,
0.013636f, 0.074528f, 0.000431f, 0.092754f, 0.050404f, 0.390403f, 0.092551f, 0.395350f, 0.020077f, 0.185973f, 0.048685f, 0.276405f, 0.054360f, 0.364037f, 0.121580f, 0.362604f,
0.030764f, 0.069388f, 0.000504f, 0.091546f, 0.038946f, 0.124489f, 0.037065f, 0.133641f, 0.000449f, 0.001718f, 0.000565f, 0.002706f, 0.107184f, 0.296219f, 0.124249f, 0.312782f,
0.123910f, 0.256385f, 0.002051f, 0.344220f, 0.222350f, 0.652005f, 0.213862f, 0.712280f, 0.140878f, 0.494034f, 0.178945f, 0.792107f, 0.384708f, 0.975363f, 0.450711f, 1.048057f,
0.054214f, 0.123516f, 0.001057f, 0.149156f, 0.134005f, 0.432677f, 0.151767f, 0.425147f, 0.055654f, 0.214900f, 0.083240f, 0.309912f, 0.305461f, 0.852740f, 0.421386f, 0.824159f,
0.120827f, 0.299669f, 0.002556f, 0.361477f, 0.317237f, 1.115034f, 0.389896f, 1.094417f, 0.134567f, 0.565643f, 0.218416f, 0.814825f, 0.382042f, 1.161009f, 0.571932f, 1.120854f,
0.022491f, 0.054877f, 0.000377f, 0.077789f, 0.037970f, 0.131298f, 0.036988f, 0.151440f, 0.000262f, 0.001083f, 0.000337f, 0.001833f, 0.059722f, 0.178556f, 0.070863f, 0.202570f,
0.049042f, 0.109777f, 0.000831f, 0.158353f, 0.117362f, 0.372300f, 0.115543f, 0.436984f, 0.044438f, 0.168587f, 0.057777f, 0.290417f, 0.116052f, 0.318302f, 0.139168f, 0.367478f,
0.000590f, 0.001455f, 0.000012f, 0.001888f, 0.001946f, 0.006798f, 0.002256f, 0.007176f, 0.000483f, 0.002018f, 0.000739f, 0.003126f, 0.002535f, 0.007657f, 0.003580f, 0.007951f,
0.079484f, 0.213259f, 0.001721f, 0.276388f, 0.278305f, 1.058225f, 0.350112f, 1.115952f, 0.070551f, 0.320816f, 0.117210f, 0.496536f, 0.191549f, 0.629734f, 0.293518f, 0.653196f,
0.065024f, 0.218443f, 0.001032f, 0.274830f, 0.103951f, 0.494901f, 0.095895f, 0.506640f, 0.000813f, 0.004630f, 0.000991f, 0.006956f, 0.157752f, 0.649360f, 0.177260f, 0.653861f,
0.199024f, 0.613363f, 0.003194f, 0.785295f, 0.450996f, 1.969751f, 0.420476f, 2.052025f, 0.193719f, 1.011838f, 0.238518f, 1.547068f, 0.430281f, 1.624842f, 0.488640f, 1.664950f,
0.090499f, 0.307103f, 0.001710f, 0.353651f, 0.282485f, 1.358505f, 0.310115f, 1.272941f, 0.079536f, 0.457433f, 0.115310f, 0.629074f, 0.355069f, 1.476383f, 0.474798f, 1.360709f,
0.281735f, 1.040740f, 0.005777f, 1.197162f, 0.934104f, 4.890174f, 1.112836f, 4.577102f, 0.268624f, 1.681793f, 0.422630f, 2.310288f, 0.620308f, 2.807738f, 0.900144f, 2.584888f,
0.014908f, 0.099284f, 0.000411f, 0.107960f, 0.027626f, 0.260736f, 0.044233f, 0.230697f, 0.000222f, 0.002502f, 0.000469f, 0.003249f, 0.046810f, 0.381978f, 0.091292f, 0.332428f,
0.038827f, 0.237212f, 0.001081f, 0.262489f, 0.101987f, 0.883028f, 0.165034f, 0.795069f, 0.044935f, 0.465278f, 0.096027f, 0.614852f, 0.108641f, 0.813286f, 0.214137f, 0.720266f,
0.016195f, 0.108947f, 0.000531f, 0.108435f, 0.058598f, 0.558648f, 0.111653f, 0.452423f, 0.016923f, 0.192949f, 0.042585f, 0.229339f, 0.082237f, 0.677868f, 0.190864f, 0.539971f,
0.073802f, 0.540454f, 0.002627f, 0.537315f, 0.283639f, 2.943639f, 0.586491f, 2.381279f, 0.083667f, 1.038417f, 0.228470f, 1.232891f, 0.210304f, 1.887061f, 0.529677f, 1.501518f,
0.093565f, 0.282761f, 0.001726f, 0.298010f, 0.123158f, 0.527470f, 0.131989f, 0.452340f, 0.001052f, 0.005390f, 0.001489f, 0.006784f, 0.233021f, 0.862878f, 0.304186f, 0.727840f,
0.292588f, 0.811173f, 0.005455f, 0.869991f, 0.545911f, 2.144894f, 0.591287f, 1.871815f, 0.256141f, 1.203544f, 0.366382f, 1.541509f, 0.649362f, 2.205924f, 0.856705f, 1.893505f,
0.122530f, 0.374046f, 0.002690f, 0.360830f, 0.314913f, 1.362389f, 0.401629f, 1.069385f, 0.096853f, 0.501099f, 0.163128f, 0.577277f, 0.493507f, 1.845967f, 0.766649f, 1.425200f,
0.302183f, 1.004192f, 0.007199f, 0.967638f, 0.824942f, 3.885054f, 1.141740f, 3.046136f, 0.259137f, 1.459492f, 0.473644f, 1.679505f, 0.682999f, 2.781085f, 1.151417f, 2.144792f,
0.050497f, 0.090365f, 0.000549f, 0.128840f, 0.068239f, 0.173058f, 0.043125f, 0.200769f, 0.000438f, 0.001327f, 0.000365f, 0.002260f, 0.138373f, 0.303412f, 0.106517f, 0.346225f,
0.118349f, 0.194288f, 0.001301f, 0.281894f, 0.226695f, 0.527414f, 0.144791f, 0.622655f, 0.079848f, 0.222163f, 0.067351f, 0.384942f, 0.288999f, 0.581334f, 0.224835f, 0.675058f,
0.000940f, 0.001700f, 0.000012f, 0.002218f, 0.002481f, 0.006356f, 0.001866f, 0.006749f, 0.000573f, 0.001755f, 0.000569f, 0.002735f, 0.004167f, 0.009229f, 0.003817f, 0.009640f,
0.135374f, 0.266383f, 0.001902f, 0.347249f, 0.379403f, 1.058034f, 0.309647f, 1.122254f, 0.089469f, 0.298379f, 0.096431f, 0.464502f, 0.336657f, 0.811721f, 0.334675f, 0.846871f,
0.053945f, 0.132910f, 0.000556f, 0.168193f, 0.069028f, 0.241024f, 0.041312f, 0.248179f, 0.000502f, 0.002097f, 0.000397f, 0.003170f, 0.135053f, 0.407714f, 0.098451f, 0.412933f,
0.177463f, 0.401109f, 0.001848f, 0.516538f, 0.321883f, 1.031051f, 0.194692f, 1.080378f, 0.128614f, 0.492686f, 0.102735f, 0.757692f, 0.395919f, 1.096498f, 0.291692f, 1.130114f,
0.053259f, 0.132548f, 0.000653f, 0.153528f, 0.133065f, 0.469324f, 0.094770f, 0.442328f, 0.034852f, 0.147004f, 0.032780f, 0.203342f, 0.215630f, 0.657564f, 0.187062f, 0.609577f,
0.177299f, 0.480342f, 0.002359f, 0.555758f, 0.470527f, 1.806577f, 0.363666f, 1.700776f, 0.125871f, 0.577956f, 0.128476f, 0.798570f, 0.402833f, 1.337263f, 0.379237f, 1.238301f,
0.000400f, 0.001953f, 0.000007f, 0.002136f, 0.000593f, 0.004106f, 0.000616f, 0.003654f, 0.000004f, 0.000037f, 0.000006f, 0.000048f, 0.001296f, 0.007755f, 0.001640f, 0.006788f,
0.001119f, 0.005016f, 0.000020f, 0.005583f, 0.002354f, 0.014946f, 0.002471f, 0.013535f, 0.000965f, 0.007326f, 0.001337f, 0.009737f, 0.003232f, 0.017746f, 0.004133f, 0.015808f,
0.000308f, 0.001520f, 0.000007f, 0.001522f, 0.000893f, 0.006240f, 0.001103f, 0.005083f, 0.000240f, 0.002005f, 0.000391f, 0.002397f, 0.001615f, 0.009762f, 0.002431f, 0.007822f,
0.001502f, 0.008066f, 0.000035f, 0.008065f, 0.004620f, 0.035163f, 0.006197f, 0.028611f, 0.001268f, 0.011539f, 0.002246f, 0.013780f, 0.004416f, 0.029061f, 0.007216f, 0.023259f,
0.163196f, 0.361708f, 0.001953f, 0.383437f, 0.171942f, 0.540082f, 0.119547f, 0.465855f, 0.001367f, 0.005134f, 0.001255f, 0.006499f, 0.419414f, 1.139041f, 0.355195f, 0.966385f,
0.548504f, 1.115266f, 0.006634f, 1.203107f, 0.819159f, 2.360449f, 0.575606f, 2.071934f, 0.357533f, 1.232086f, 0.331782f, 1.587265f, 1.256205f, 3.129732f, 1.075194f, 2.702137f,
0.151603f, 0.339417f, 0.002159f, 0.329332f, 0.311874f, 0.989538f, 0.258045f, 0.781250f, 0.089227f, 0.338568f, 0.097496f, 0.392311f, 0.630101f, 1.728554f, 0.635030f, 1.342330f,
0.399812f, 0.974418f, 0.006179f, 0.944422f, 0.873641f, 3.017514f, 0.784437f, 2.379720f, 0.255288f, 1.054494f, 0.302715f, 1.220529f, 0.932519f, 2.784802f, 1.019886f, 2.160178f,
0.085291f, 0.216747f, 0.001248f, 0.230743f, 0.098296f, 0.354009f, 0.083529f, 0.306653f, 0.000741f, 0.003192f, 0.000832f, 0.004058f, 0.203965f, 0.635118f, 0.211118f, 0.541134f,
0.304325f, 0.709476f, 0.004499f, 0.768606f, 0.497149f, 1.642535f, 0.426962f, 1.447892f, 0.205812f, 0.813201f, 0.233428f, 1.052075f, 0.648542f, 1.852622f, 0.678437f, 1.606302f,
0.002448f, 0.006284f, 0.000043f, 0.006123f, 0.005509f, 0.020040f, 0.005571f, 0.015889f, 0.001495f, 0.006504f, 0.001996f, 0.007568f, 0.009468f, 0.029779f, 0.011662f, 0.023224f,
0.330956f, 0.924827f, 0.006252f, 0.900164f, 0.791056f, 3.132748f, 0.868116f, 2.481088f, 0.219251f, 1.038383f, 0.317753f, 1.206984f, 0.718276f, 2.459405f, 0.960132f, 1.915869f,
0.152668f, 0.534160f, 0.002115f, 0.504715f, 0.166607f, 0.826123f, 0.134074f, 0.635149f, 0.001425f, 0.008449f, 0.001514f, 0.009534f, 0.333554f, 1.430005f, 0.326954f, 1.081403f,
0.764614f, 2.454231f, 0.010704f, 2.359829f, 1.182778f, 5.380267f, 0.961959f, 4.209443f, 0.555467f, 3.021740f, 0.596610f, 3.469806f, 1.488704f, 5.855030f, 1.474790f, 4.505767f,
0.232333f, 0.821129f, 0.003830f, 0.710154f, 0.495058f, 2.479609f, 0.474097f, 1.744937f, 0.152397f, 0.912858f, 0.192738f, 0.942816f, 0.820917f, 3.555056f, 0.957589f, 2.460719f,
0.726279f, 2.794256f, 0.012992f, 2.413940f, 1.643812f, 8.962779f, 1.708335f, 6.300261f, 0.516840f, 3.370115f, 0.709342f, 3.476865f, 1.440090f, 6.788916f, 1.822969f, 4.693914f,
0.039928f, 0.276944f, 0.000960f, 0.226166f, 0.050509f, 0.496489f, 0.070547f, 0.329913f, 0.000443f, 0.005209f, 0.000817f, 0.005080f, 0.112904f, 0.959558f, 0.192084f, 0.627163f,
0.170158f, 1.082718f, 0.004134f, 0.899787f, 0.305111f, 2.751361f, 0.430695f, 1.860491f, 0.146978f, 1.585038f, 0.273995f, 1.573067f, 0.428777f, 3.343043f, 0.737247f, 2.223519f,
0.047428f, 0.332296f, 0.001357f, 0.248385f, 0.117145f, 1.163163f, 0.194713f, 0.707452f, 0.036990f, 0.439238f, 0.081196f, 0.392087f, 0.216888f, 1.861972f, 0.439113f, 1.113905f,
0.217025f, 1.655249f, 0.006738f, 1.235899f, 0.569382f, 6.154371f, 1.027032f, 3.739030f, 0.183631f, 2.373693f, 0.437426f, 2.116543f, 0.556942f, 5.204878f, 1.223656f, 3.110317f,
0.266502f, 0.838818f, 0.004288f, 0.663941f, 0.239466f, 1.068169f, 0.223874f, 0.687950f, 0.002237f, 0.011934f, 0.002762f, 0.011280f, 0.597726f, 2.305247f, 0.680660f, 1.460338f,
1.363671f, 3.937560f, 0.022178f, 3.171598f, 1.736877f, 7.107454f, 1.641080f, 4.658227f, 0.891005f, 4.360375f, 1.111783f, 4.194283f, 2.725579f, 9.643265f, 3.136811f, 6.216552f,
0.381614f, 1.213301f, 0.007308f, 0.879014f, 0.669525f, 3.016747f, 0.744880f, 1.778367f, 0.225136f, 1.213152f, 0.330783f, 1.049603f, 1.384188f, 5.392460f, 1.875784f, 3.126716f,
0.945037f, 3.270817f, 0.019639f, 2.367022f, 1.761149f, 8.638358f, 2.126300f, 5.086663f, 0.604862f, 3.548050f, 0.964414f, 3.066329f, 1.923615f, 8.157813f, 2.828887f, 4.724918f,
0.050212f, 0.091438f, 0.000748f, 0.162254f, 0.065714f, 0.169592f, 0.056845f, 0.244867f, 0.000592f, 0.001828f, 0.000677f, 0.003874f, 0.151158f, 0.337287f, 0.159272f, 0.479008f,
0.161234f, 0.269355f, 0.002426f, 0.486390f, 0.299104f, 0.708141f, 0.261494f, 1.040482f, 0.148060f, 0.419212f, 0.170945f, 0.904016f, 0.432542f, 0.885414f, 0.460614f, 1.279617f,
0.001432f, 0.002635f, 0.000025f, 0.004279f, 0.003660f, 0.009542f, 0.003768f, 0.012610f, 0.001188f, 0.003703f, 0.001615f, 0.007182f, 0.006973f, 0.015718f, 0.008744f, 0.020431f,
0.159158f, 0.318704f, 0.003060f, 0.517061f, 0.431999f, 1.225942f, 0.482602f, 1.618377f, 0.143168f, 0.485884f, 0.211219f, 0.941391f, 0.434832f, 1.066913f, 0.591694f, 1.385344f,
0.080145f, 0.200941f, 0.001130f, 0.316474f, 0.099321f, 0.352907f, 0.081363f, 0.452256f, 0.001016f, 0.004316f, 0.001099f, 0.008117f, 0.220428f, 0.677186f, 0.219950f, 0.853592f,
0.361232f, 0.830861f, 0.005148f, 1.331638f, 0.634548f, 2.068400f, 0.525357f, 2.697417f, 0.356328f, 1.389052f, 0.389600f, 2.658640f, 0.885369f, 2.495250f, 0.892858f, 3.200712f,
0.121220f, 0.307004f, 0.002034f, 0.442565f, 0.293316f, 1.052769f, 0.285946f, 1.234874f, 0.107967f, 0.463430f, 0.139000f, 0.797812f, 0.539180f, 1.673211f, 0.640251f, 1.930453f,
0.311448f, 0.858654f, 0.005671f, 1.236435f, 0.800484f, 3.127608f, 0.846856f, 3.664554f, 0.300945f, 1.406194f, 0.420458f, 2.418139f, 0.777400f, 2.626180f, 1.001775f, 3.026579f,
0.016601f, 0.082510f, 0.000406f, 0.112314f, 0.023847f, 0.167974f, 0.033906f, 0.186048f, 0.000250f, 0.002107f, 0.000470f, 0.003425f, 0.059092f, 0.359881f, 0.102340f, 0.392068f,
0.063667f, 0.290299f, 0.001575f, 0.402126f, 0.129639f, 0.837713f, 0.186288f, 0.944210f, 0.074672f, 0.577057f, 0.141706f, 0.954594f, 0.201960f, 1.128351f, 0.353494f, 1.250939f,
0.019598f, 0.098395f, 0.000571f, 0.122594f, 0.054969f, 0.391118f, 0.093010f, 0.396512f, 0.020755f, 0.176603f, 0.046377f, 0.262769f, 0.112821f, 0.694056f, 0.232522f, 0.692090f,
0.073707f, 0.402840f, 0.002330f, 0.501354f, 0.219594f, 1.700867f, 0.403216f, 1.722418f, 0.084683f, 0.784408f, 0.205348f, 1.165837f, 0.238112f, 1.594600f, 0.532559f, 1.588323f,
0.285698f, 0.644382f, 0.004680f, 0.850155f, 0.291520f, 0.931823f, 0.277437f, 1.000330f, 0.003256f, 0.012448f, 0.004093f, 0.019613f, 0.806642f, 2.229284f, 0.935073f, 2.353934f,
1.315621f, 2.722186f, 0.021781f, 3.654783f, 1.902865f, 5.579848f, 1.830228f, 6.095677f, 1.167213f, 4.093201f, 1.482608f, 6.562810f, 3.310184f, 8.392414f, 3.878093f, 9.017897f,
0.406598f, 0.926357f, 0.007926f, 1.118660f, 0.810075f, 2.615570f, 0.917447f, 2.570052f, 0.325712f, 1.257690f, 0.487157f, 1.813746f, 1.856554f, 5.182854f, 2.561132f, 5.009141f,
0.827578f, 2.052513f, 0.017507f, 2.475853f, 1.751354f, 6.155715f, 2.152480f, 6.041895f, 0.719225f, 3.023207f, 1.167371f, 4.355017f, 2.120561f, 6.444296f, 3.174567f, 6.221413f,
0.139911f, 0.341383f, 0.002346f, 0.483915f, 0.190388f, 0.658348f, 0.185462f, 0.759343f, 0.001271f, 0.005256f, 0.001635f, 0.008897f, 0.301080f, 0.900159f, 0.357246f, 1.021222f,
0.348811f, 0.780782f, 0.005911f, 1.126280f, 0.672808f, 2.134313f, 0.662383f, 2.505130f, 0.246637f, 0.935670f, 0.320667f, 1.611840f, 0.668909f, 1.834654f, 0.802147f, 2.118093f,
0.002966f, 0.007310f, 0.000059f, 0.009485f, 0.007880f, 0.027526f, 0.009135f, 0.029060f, 0.001894f, 0.007910f, 0.002899f, 0.012256f, 0.010322f, 0.031173f, 0.014575f, 0.032370f,
0.364684f, 0.978467f, 0.007897f, 1.268113f, 1.029214f, 3.913475f, 1.294767f, 4.126955f, 0.252592f, 1.148618f, 0.419648f, 1.777748f, 0.712220f, 2.341483f, 1.091361f, 2.428718f,
0.294383f, 0.988949f, 0.004674f, 1.244227f, 0.379324f, 1.805922f, 0.349927f, 1.848760f, 0.002873f, 0.016355f, 0.003500f, 0.024573f, 0.578770f, 2.382406f, 0.650342f, 2.398921f,
1.030172f, 3.174834f, 0.016532f, 4.064776f, 1.881577f, 8.217902f, 1.754245f, 8.561150f, 0.782452f, 4.086911f, 0.963396f, 6.248757f, 1.804890f, 6.815694f, 2.049689f, 6.983933f,
0.330888f, 1.122844f, 0.006252f, 1.293037f, 0.832486f, 4.003525f, 0.913910f, 3.751368f, 0.226924f, 1.305099f, 0.328992f, 1.794807f, 1.052068f, 4.374513f, 1.406822f, 4.031770f,
0.940727f, 3.475084f, 0.019291f, 3.997385f, 2.513993f, 13.161130f, 2.995024f, 12.318550f, 0.699920f, 4.382039f, 1.101193f, 6.019630f, 1.678516f, 7.597572f, 2.435737f, 6.994553f,
0.059901f, 0.398917f, 0.001651f, 0.433778f, 0.089469f, 0.844405f, 0.143251f, 0.747123f, 0.000695f, 0.007844f, 0.001470f, 0.010186f, 0.152419f, 1.243761f, 0.297258f, 1.082422f,
0.178364f, 1.089703f, 0.004968f, 1.205822f, 0.377627f, 3.269581f, 0.611070f, 2.943897f, 0.161079f, 1.667882f, 0.344227f, 2.204058f, 0.404447f, 3.027683f, 0.797183f, 2.681389f,
0.052552f, 0.353525f, 0.001724f, 0.351861f, 0.153261f, 1.461125f, 0.292024f, 1.183298f, 0.042852f, 0.488571f, 0.107830f, 0.580712f, 0.216256f, 1.782559f, 0.501907f, 1.419938f,
0.218705f, 1.601584f, 0.007784f, 1.592281f, 0.677490f, 7.031073f, 1.400872f, 5.687840f, 0.193476f, 2.401284f, 0.528324f, 2.850995f, 0.505049f, 4.531817f, 1.272031f, 3.605927f,
0.476377f, 1.439649f, 0.008788f, 1.517289f, 0.505413f, 2.164613f, 0.541653f, 1.856298f, 0.004181f, 0.021414f, 0.005917f, 0.026952f, 0.961452f, 3.560260f, 1.255079f, 3.003087f,
1.703188f, 4.721922f, 0.031753f, 5.064309f, 2.561377f, 10.063690f, 2.774275f, 8.782419f, 1.163498f, 5.466984f, 1.664258f, 7.002162f, 3.063283f, 10.406170f, 4.041401f, 8.932374f,
0.503825f, 1.538022f, 0.011060f, 1.483679f, 1.043696f, 4.515275f, 1.331093f, 3.544192f, 0.310766f, 1.607835f, 0.523415f, 1.852260f, 1.644469f, 6.151148f, 2.554634f, 4.749064f,
1.134737f, 3.770868f, 0.027032f, 3.633606f, 2.496859f, 11.758930f, 3.455714f, 9.219766f, 0.759338f, 4.276684f, 1.387898f, 4.921376f, 2.078452f, 8.463190f, 3.503908f, 6.526872f,
0.080934f, 0.144832f, 0.000880f, 0.206498f, 0.097667f, 0.247690f, 0.061723f, 0.287353f, 0.000711f, 0.002155f, 0.000593f, 0.003670f, 0.242442f, 0.531603f, 0.186627f, 0.606615f,
0.114702f, 0.188301f, 0.001261f, 0.273208f, 0.196201f, 0.456468f, 0.125314f, 0.538898f, 0.078391f, 0.218110f, 0.066122f, 0.377919f, 0.306191f, 0.615917f, 0.238210f, 0.715217f,
0.001175f, 0.002124f, 0.000015f, 0.002772f, 0.002769f, 0.007093f, 0.002082f, 0.007532f, 0.000725f, 0.002222f, 0.000720f, 0.003462f, 0.005693f, 0.012609f, 0.005215f, 0.013169f,
0.157937f, 0.310783f, 0.002219f, 0.405128f, 0.395278f, 1.102306f, 0.322604f, 1.169214f, 0.105735f, 0.352627f, 0.113963f, 0.548952f, 0.429366f, 1.035254f, 0.426838f, 1.080083f,
0.078451f, 0.193287f, 0.000808f, 0.244598f, 0.089645f, 0.313009f, 0.053650f, 0.322302f, 0.000740f, 0.003090f, 0.000585f, 0.004669f, 0.214702f, 0.648170f, 0.156514f, 0.656469f,
0.156061f, 0.352735f, 0.001625f, 0.454243f, 0.252776f, 0.809688f, 0.152892f, 0.848425f, 0.114570f, 0.438886f, 0.091517f, 0.674955f, 0.380611f, 1.054103f, 0.280414f, 1.086419f,
0.060394f, 0.150304f, 0.000740f, 0.174095f, 0.134746f, 0.475252f, 0.095967f, 0.447915f, 0.040033f, 0.168859f, 0.037653f, 0.233574f, 0.267300f, 0.815131f, 0.231886f, 0.755645f,
0.187688f, 0.508488f, 0.002497f, 0.588323f, 0.444801f, 1.707803f, 0.343782f, 1.607787f, 0.134974f, 0.619756f, 0.137767f, 0.856325f, 0.466169f, 1.547517f, 0.438864f, 1.432996f,
0.000721f, 0.003523f, 0.000013f, 0.003853f, 0.000955f, 0.006613f, 0.000992f, 0.005885f, 0.000008f, 0.000067f, 0.000011f, 0.000087f, 0.002555f, 0.015290f, 0.003232f, 0.013384f,
0.001221f, 0.005471f, 0.000022f, 0.006089f, 0.002292f, 0.014556f, 0.002406f, 0.013182f, 0.001066f, 0.008093f, 0.001478f, 0.010757f, 0.003854f, 0.021158f, 0.004928f, 0.018847f,
0.000433f, 0.002138f, 0.000009f, 0.002141f, 0.001121f, 0.007837f, 0.001386f, 0.006384f, 0.000342f, 0.002856f, 0.000558f, 0.003415f, 0.002483f, 0.015008f, 0.003738f, 0.012025f,
0.001972f, 0.010589f, 0.000046f, 0.010589f, 0.005416f, 0.041225f, 0.007266f, 0.033543f, 0.001686f, 0.015345f, 0.002987f, 0.018326f, 0.006338f, 0.041708f, 0.010356f, 0.033381f,
0.209801f, 0.465004f, 0.002511f, 0.492938f, 0.197393f, 0.620025f, 0.137242f, 0.534812f, 0.001780f, 0.006685f, 0.001634f, 0.008463f, 0.589427f, 1.600761f, 0.499177f, 1.358117f,
0.426402f, 0.866997f, 0.005157f, 0.935284f, 0.568668f, 1.638647f, 0.399592f, 1.438357f, 0.281547f, 0.970233f, 0.261269f, 1.249927f, 1.067552f, 2.659717f, 0.913724f, 2.296337f,
0.151971f, 0.340241f, 0.002164f, 0.330132f, 0.279180f, 0.885803f, 0.230993f, 0.699350f, 0.090603f, 0.343791f, 0.099001f, 0.398363f, 0.690481f, 1.894197f, 0.695883f, 1.470962f,
0.374144f, 0.911860f, 0.005782f, 0.883790f, 0.730075f, 2.521643f, 0.655530f, 1.988658f, 0.241996f, 0.999593f, 0.286954f, 1.156983f, 0.953958f, 2.848827f, 1.043334f, 2.209843f,
0.081931f, 0.208209f, 0.001198f, 0.221655f, 0.084321f, 0.303678f, 0.071653f, 0.263055f, 0.000721f, 0.003106f, 0.000809f, 0.003948f, 0.214187f, 0.666946f, 0.221698f, 0.568253f,
0.176777f, 0.412123f, 0.002613f, 0.446470f, 0.257885f, 0.852030f, 0.221477f, 0.751063f, 0.121103f, 0.478501f, 0.137353f, 0.619058f, 0.411828f, 1.176425f, 0.430812f, 1.020011f,
0.001834f, 0.004707f, 0.000032f, 0.004587f, 0.003685f, 0.013405f, 0.003726f, 0.010628f, 0.001134f, 0.004935f, 0.001515f, 0.005742f, 0.007752f, 0.024384f, 0.009549f, 0.019016f,
0.231421f, 0.646685f, 0.004371f, 0.629440f, 0.493959f, 1.956182f, 0.542078f, 1.549266f, 0.155299f, 0.735505f, 0.225070f, 0.854929f, 0.549051f, 1.879972f, 0.733926f, 1.464492f,
0.133068f, 0.465583f, 0.001843f, 0.439919f, 0.129680f, 0.643017f, 0.104358f, 0.494372f, 0.001258f, 0.007460f, 0.001337f, 0.008418f, 0.317820f, 1.362551f, 0.311532f, 1.030393f,
0.403005f, 1.293549f, 0.005642f, 1.243793f, 0.556701f, 2.532344f, 0.452768f, 1.981269f, 0.296566f, 1.613320f, 0.318532f, 1.852544f, 0.857758f, 3.373537f, 0.849741f, 2.596122f,
0.157904f, 0.558075f, 0.002603f, 0.482652f, 0.300461f, 1.504929f, 0.287740f, 1.059041f, 0.104919f, 0.628464f, 0.132692f, 0.649089f, 0.609915f, 2.641294f, 0.711458f, 1.828236f,
0.460802f, 1.772872f, 0.008243f, 1.531572f, 0.931354f, 5.078146f, 0.967911f, 3.569612f, 0.332172f, 2.165966f, 0.455892f, 2.234574f, 0.998825f, 4.708693f, 1.264385f, 3.255630f,
0.043161f, 0.299370f, 0.001038f, 0.244480f, 0.048757f, 0.479266f, 0.068100f, 0.318469f, 0.000485f, 0.005703f, 0.000895f, 0.005562f, 0.133418f, 1.133904f, 0.226984f, 0.741115f,
0.111227f, 0.707738f, 0.002703f, 0.588162f, 0.178101f, 1.606040f, 0.251408f, 1.086016f, 0.097321f, 1.049525f, 0.181424f, 1.041598f, 0.306392f, 2.388846f, 0.526816f, 1.588866f,
0.039977f, 0.280089f, 0.001144f, 0.209362f, 0.088175f, 0.875514f, 0.146561f, 0.532500f, 0.031583f, 0.375030f, 0.069327f, 0.334773f, 0.199846f, 1.715668f, 0.404609f, 1.026380f,
0.170770f, 1.302459f, 0.005302f, 0.972487f, 0.400088f, 4.324500f, 0.721666f, 2.627309f, 0.146367f, 1.892001f, 0.348660f, 1.687034f, 0.479071f, 4.477136f, 1.052565f, 2.675435f,
0.205343f, 0.646320f, 0.003304f, 0.511574f, 0.164769f, 0.734972f, 0.154041f, 0.473356f, 0.001746f, 0.009314f, 0.002156f, 0.008804f, 0.503466f, 1.941717f, 0.573322f, 1.230047f,
0.635375f, 1.834627f, 0.010333f, 1.477743f, 0.722672f, 2.957237f, 0.682813f, 1.938174f, 0.420530f, 2.057976f, 0.524731f, 1.979585f, 1.388252f, 4.911721f, 1.597710f, 3.166351f,
0.229276f, 0.728959f, 0.004391f, 0.528117f, 0.359214f, 1.618545f, 0.399643f, 0.954130f, 0.137017f, 0.738322f, 0.201314f, 0.638786f, 0.909114f, 3.541689f, 1.231987f, 2.053581f,
0.530045f, 1.834512f, 0.011015f, 1.327598f, 0.882087f, 4.326601f, 1.064977f, 2.547702f, 0.343650f, 2.015811f, 0.547928f, 1.742123f, 1.179428f, 5.001806f, 1.734478f, 2.896993f,
0.001478f, 0.002692f, 0.000022f, 0.004777f, 0.001728f, 0.004459f, 0.001495f, 0.006438f, 0.000018f, 0.000055f, 0.000020f, 0.000116f, 0.004865f, 0.010856f, 0.005126f, 0.015417f,
0.002871f, 0.004795f, 0.000043f, 0.008659f, 0.004755f, 0.011258f, 0.004157f, 0.016542f, 0.002670f, 0.007560f, 0.003083f, 0.016303f, 0.008418f, 0.017232f, 0.008965f, 0.024904f,
0.000033f, 0.000060f, 0.000001f, 0.000098f, 0.000075f, 0.000196f, 0.000077f, 0.000259f, 0.000028f, 0.000086f, 0.000038f, 0.000167f, 0.000175f, 0.000394f, 0.000219f, 0.000513f,
0.003411f, 0.006830f, 0.000066f, 0.011081f, 0.008268f, 0.023462f, 0.009236f, 0.030973f, 0.003108f, 0.010548f, 0.004585f, 0.020437f, 0.010187f, 0.024996f, 0.013862f, 0.032456f,
0.002141f, 0.005368f, 0.000030f, 0.008454f, 0.002369f, 0.008419f, 0.001941f, 0.010789f, 0.000027f, 0.000117f, 0.000030f, 0.000220f, 0.006437f, 0.019776f, 0.006423f, 0.024928f,
0.005835f, 0.013422f, 0.000083f, 0.021512f, 0.009154f, 0.029838f, 0.007579f, 0.038912f, 0.005831f, 0.022730f, 0.006375f, 0.043505f, 0.015635f, 0.044064f, 0.015767f, 0.056522f,
0.002525f, 0.006395f, 0.000042f, 0.009219f, 0.005456f, 0.019583f, 0.005319f, 0.022971f, 0.002278f, 0.009779f, 0.002933f, 0.016834f, 0.012278f, 0.038101f, 0.014579f, 0.043959f,
0.006056f, 0.016697f, 0.000110f, 0.024044f, 0.013901f, 0.054312f, 0.014706f, 0.063636f, 0.005928f, 0.027699f, 0.008282f, 0.047633f, 0.016526f, 0.055827f, 0.021295f, 0.064338f,
0.000550f, 0.002734f, 0.000013f, 0.003721f, 0.000706f, 0.004970f, 0.001003f, 0.005504f, 0.000008f, 0.000071f, 0.000016f, 0.000115f, 0.002140f, 0.013034f, 0.003707f, 0.014200f,
0.001276f, 0.005816f, 0.000032f, 0.008056f, 0.002319f, 0.014987f, 0.003333f, 0.016893f, 0.001515f, 0.011711f, 0.002876f, 0.019373f, 0.004423f, 0.024712f, 0.007742f, 0.027397f,
0.000506f, 0.002542f, 0.000015f, 0.003167f, 0.001268f, 0.009023f, 0.002146f, 0.009147f, 0.000543f, 0.004621f, 0.001214f, 0.006876f, 0.003186f, 0.019601f, 0.006567f, 0.019545f,
0.001778f, 0.009715f, 0.000056f, 0.012091f, 0.004729f, 0.036630f, 0.008684f, 0.037094f, 0.002069f, 0.019163f, 0.005017f, 0.028481f, 0.006278f, 0.042040f, 0.014040f, 0.041874f,
0.006747f, 0.015217f, 0.000111f, 0.020077f, 0.006148f, 0.019651f, 0.005851f, 0.021096f, 0.000078f, 0.000298f, 0.000098f, 0.000469f, 0.020824f, 0.057551f, 0.024140f, 0.060769f,
0.018787f, 0.038874f, 0.000311f, 0.052192f, 0.024266f, 0.071156f, 0.023340f, 0.077734f, 0.016884f, 0.059210f, 0.021447f, 0.094934f, 0.051675f, 0.131013f, 0.060540f, 0.140777f,
0.007487f, 0.017058f, 0.000146f, 0.020599f, 0.013321f, 0.043010f, 0.015086f, 0.042262f, 0.006076f, 0.023460f, 0.009087f, 0.033832f, 0.037372f, 0.104330f, 0.051555f, 0.100833f,
0.014226f, 0.035283f, 0.000301f, 0.042560f, 0.026885f, 0.094496f, 0.033042f, 0.092748f, 0.012524f, 0.052644f, 0.020328f, 0.075835f, 0.039849f, 0.121100f, 0.059656f, 0.116912f,
0.177968f, 0.434240f, 0.002984f, 0.615541f, 0.216261f, 0.747817f, 0.210666f, 0.862537f, 0.001638f, 0.006772f, 0.002107f, 0.011464f, 0.418658f, 1.251688f, 0.496757f, 1.420029f,
0.268300f, 0.600564f, 0.004547f, 0.866314f, 0.462139f, 1.466016f, 0.454978f, 1.720723f, 0.192169f, 0.729034f, 0.249850f, 1.255877f, 0.562452f, 1.542668f, 0.674485f, 1.780997f,
0.002942f, 0.007251f, 0.000059f, 0.009407f, 0.006980f, 0.024380f, 0.008091f, 0.025739f, 0.001903f, 0.007947f, 0.002913f, 0.012314f, 0.011192f, 0.033800f, 0.015803f, 0.035098f,
0.337668f, 0.905981f, 0.007312f, 1.174169f, 0.851001f, 3.235838f, 1.070572f, 3.412353f, 0.236913f, 1.077319f, 0.393599f, 1.667396f, 0.720901f, 2.370024f, 1.104664f, 2.458322f,
0.339765f, 1.141408f, 0.005395f, 1.436041f, 0.390956f, 1.861304f, 0.360658f, 1.905456f, 0.003358f, 0.019121f, 0.004091f, 0.028729f, 0.730234f, 3.005879f, 0.820536f, 3.026717f,
0.718981f, 2.215792f, 0.011538f, 2.836903f, 1.172685f, 5.121773f, 1.093326f, 5.335701f, 0.553174f, 2.889342f, 0.681097f, 4.417712f, 1.377043f, 5.200043f, 1.563813f, 5.328401f,
0.297785f, 1.010511f, 0.005627f, 1.163678f, 0.669037f, 3.217480f, 0.734475f, 3.014831f, 0.206870f, 1.189765f, 0.299918f, 1.636197f, 1.035034f, 4.303685f, 1.384044f, 3.966491f,
0.790342f, 2.919556f, 0.016207f, 3.358362f, 1.886110f, 9.874069f, 2.247001f, 9.241925f, 0.595657f, 3.729268f, 0.937154f, 5.122915f, 1.541579f, 6.977747f, 2.237025f, 6.423924f,
0.085741f, 0.571003f, 0.002363f, 0.620903f, 0.114362f, 1.079342f, 0.183108f, 0.954993f, 0.001008f, 0.011374f, 0.002131f, 0.014770f, 0.238497f, 1.946177f, 0.465134f, 1.693722f,
0.154385f, 0.943205f, 0.004300f, 1.043713f, 0.291886f, 2.527209f, 0.472324f, 2.275474f, 0.141232f, 1.462375f, 0.301813f, 1.932487f, 0.382691f, 2.864818f, 0.754301f, 2.537152f,
0.058655f, 0.394577f, 0.001924f, 0.392720f, 0.152755f, 1.456299f, 0.291059f, 1.179389f, 0.048449f, 0.552376f, 0.121912f, 0.656551f, 0.263857f, 2.174926f, 0.612384f, 1.732486f,
0.227877f, 1.668750f, 0.008110f, 1.659057f, 0.630370f, 6.542058f, 1.303440f, 5.292247f, 0.204204f, 2.534432f, 0.557619f, 3.009079f, 0.575259f, 5.161817f, 1.448865f, 4.107212f,
0.486038f, 1.468848f, 0.008966f, 1.548063f, 0.460487f, 1.972204f, 0.493506f, 1.691294f, 0.004321f, 0.022131f, 0.006115f, 0.027855f, 1.072350f, 3.970915f, 1.399845f, 3.349476f,
1.050809f, 2.913265f, 0.019590f, 3.124506f, 1.411192f, 5.544592f, 1.528488f, 4.838677f, 0.727148f, 3.416684f, 1.040106f, 4.376118f, 2.066032f, 7.018447f, 2.725724f, 6.024443f,
0.400825f, 1.223595f, 0.008799f, 1.180361f, 0.741482f, 3.207824f, 0.945659f, 2.517930f, 0.250440f, 1.295724f, 0.421810f, 1.492701f, 1.430176f, 5.349585f, 2.221737f, 4.130208f,
0.842752f, 2.800567f, 0.020077f, 2.698625f, 1.655961f, 7.798727f, 2.291891f, 6.114711f, 0.571262f, 3.217419f, 1.044139f, 3.702432f, 1.687460f, 6.871121f, 2.844764f, 5.299058f,
0.170010f, 0.304233f, 0.001849f, 0.433767f, 0.279100f, 0.707814f, 0.176383f, 0.821156f, 0.001575f, 0.004777f, 0.001315f, 0.008134f, 0.453261f, 0.993866f, 0.348911f, 1.134106f,
0.197772f, 0.324673f, 0.002174f, 0.471072f, 0.460220f, 1.070716f, 0.293944f, 1.264069f, 0.142624f, 0.396826f, 0.120301f, 0.687581f, 0.469880f, 0.945183f, 0.365557f, 1.097568f,
0.001755f, 0.003173f, 0.000023f, 0.004140f, 0.005626f, 0.014412f, 0.004231f, 0.015304f, 0.001143f, 0.003501f, 0.001135f, 0.005457f, 0.007568f, 0.016762f, 0.006932f, 0.017507f,
0.279774f, 0.550527f, 0.003930f, 0.717654f, 0.952567f, 2.656409f, 0.777432f, 2.817646f, 0.197638f, 0.659127f, 0.213018f, 1.026096f, 0.676939f, 1.632184f, 0.672954f, 1.702862f,
0.189163f, 0.466059f, 0.001949f, 0.589782f, 0.294059f, 1.026753f, 0.175988f, 1.057235f, 0.001883f, 0.007861f, 0.001488f, 0.011880f, 0.460761f, 1.391003f, 0.335887f, 1.408811f,
0.308878f, 0.698138f, 0.003216f, 0.899044f, 0.680611f, 2.180121f, 0.411669f, 2.284421f, 0.239274f, 0.916592f, 0.191128f, 1.409610f, 0.670461f, 1.856843f, 0.493960f, 1.913769f,
0.103545f, 0.257697f, 0.001269f, 0.298487f, 0.314286f, 1.108493f, 0.223837f, 1.044731f, 0.072425f, 0.305489f, 0.068120f, 0.422565f, 0.407884f, 1.243843f, 0.353846f, 1.153071f,
0.381643f, 1.033954f, 0.005077f, 1.196290f, 1.230431f, 4.724207f, 0.950987f, 4.447537f, 0.289603f, 1.329760f, 0.295596f, 1.837347f, 0.843653f, 2.800632f, 0.794237f, 2.593377f,
0.001258f, 0.006144f, 0.000022f, 0.006720f, 0.002267f, 0.015691f, 0.002355f, 0.013964f, 0.000015f, 0.000123f, 0.000020f, 0.000161f, 0.003966f, 0.023734f, 0.005018f, 0.020776f,
0.001748f, 0.007832f, 0.000032f, 0.008717f, 0.004464f, 0.028349f, 0.004687f, 0.025674f, 0.001610f, 0.012226f, 0.002232f, 0.016250f, 0.004910f, 0.026959f, 0.006279f, 0.024015f,
0.000537f, 0.002652f, 0.000011f, 0.002655f, 0.001891f, 0.013222f, 0.002338f, 0.010770f, 0.000447f, 0.003738f, 0.000730f, 0.004468f, 0.002740f, 0.016565f, 0.004126f, 0.013273f,
0.002900f, 0.015574f, 0.000067f, 0.015574f, 0.010837f, 0.082486f, 0.014538f, 0.067117f, 0.002616f, 0.023816f, 0.004635f, 0.028441f, 0.008297f, 0.054598f, 0.013556f, 0.043697f,
0.492533f, 1.091653f, 0.005894f, 1.157232f, 0.630422f, 1.980194f, 0.438316f, 1.708046f, 0.004409f, 0.016561f, 0.004048f, 0.020965f, 1.231567f, 3.344681f, 1.042996f, 2.837692f,
0.821676f, 1.670704f, 0.009938f, 1.802292f, 1.490772f, 4.295734f, 1.047535f, 3.770672f, 0.572486f, 1.972829f, 0.531252f, 2.541547f, 1.830924f, 4.561597f, 1.567099f, 3.938375f,
0.253681f, 0.567955f, 0.003613f, 0.551081f, 0.633990f, 2.011570f, 0.524563f, 1.588154f, 0.159589f, 0.605555f, 0.174380f, 0.701679f, 1.025840f, 2.814186f, 1.033865f, 2.185390f,
0.740712f, 1.805253f, 0.011448f, 1.749681f, 1.966291f, 6.791474f, 1.765521f, 5.356000f, 0.505534f, 2.088165f, 0.599451f, 2.416955f, 1.680890f, 5.019680f, 1.838372f, 3.893780f,
0.238754f, 0.606738f, 0.003492f, 0.645918f, 0.334277f, 1.203884f, 0.284058f, 1.042838f, 0.002217f, 0.009550f, 0.002488f, 0.012141f, 0.555511f, 1.729782f, 0.574994f, 1.473812f,
0.422844f, 0.985781f, 0.006251f, 1.067939f, 0.839172f, 2.772549f, 0.720699f, 2.443998f, 0.305662f, 1.207726f, 0.346676f, 1.562490f, 0.876738f, 2.504484f, 0.917152f, 2.171495f,
0.003799f, 0.009753f, 0.000066f, 0.009504f, 0.010387f, 0.037786f, 0.010503f, 0.029959f, 0.002480f, 0.010789f, 0.003312f, 0.012555f, 0.014296f, 0.044968f, 0.017610f, 0.035069f,
0.568702f, 1.589189f, 0.010742f, 1.546809f, 1.651368f, 6.539765f, 1.812234f, 5.179393f, 0.402701f, 1.907217f, 0.583623f, 2.216889f, 1.200868f, 4.111816f, 1.605220f, 3.203091f,
0.445116f, 1.557387f, 0.006166f, 1.471540f, 0.590121f, 2.926120f, 0.474890f, 2.249693f, 0.004440f, 0.026331f, 0.004719f, 0.029712f, 0.946195f, 4.056503f, 0.927473f, 3.067621f,
1.106528f, 3.551694f, 0.015490f, 3.415077f, 2.079435f, 9.459011f, 1.691213f, 7.400592f, 0.859223f, 4.674173f, 0.922864f, 5.367262f, 2.096125f, 8.243999f, 2.076534f, 6.344209f,
0.375571f, 1.327368f, 0.006191f, 1.147975f, 0.972205f, 4.869507f, 0.931042f, 3.426744f, 0.263321f, 1.577287f, 0.333024f, 1.629051f, 1.291124f, 5.591332f, 1.506080f, 3.870177f,
1.299856f, 5.001016f, 0.023252f, 4.320346f, 3.574094f, 19.487520f, 3.714385f, 13.698480f, 0.988725f, 6.447099f, 1.356985f, 6.651314f, 2.507670f, 11.821740f, 3.174388f, 8.173648f,
0.104430f, 0.724336f, 0.002511f, 0.591528f, 0.160487f, 1.577537f, 0.224156f, 1.048263f, 0.001239f, 0.014561f, 0.002285f, 0.014201f, 0.287308f, 2.441791f, 0.488796f, 1.595944f,
0.220900f, 1.405589f, 0.005367f, 1.168107f, 0.481196f, 4.339227f, 0.679258f, 2.934219f, 0.203949f, 2.199431f, 0.380201f, 2.182819f, 0.541581f, 4.222540f, 0.931204f, 2.808489f,
0.068776f, 0.481868f, 0.001968f, 0.360187f, 0.206371f, 2.049111f, 0.343020f, 1.246297f, 0.057334f, 0.680817f, 0.125853f, 0.607734f, 0.306005f, 2.627029f, 0.619537f, 1.571592f,
0.348438f, 2.657531f, 0.010818f, 1.984257f, 1.110555f, 12.003850f, 2.003183f, 7.292824f, 0.315129f, 4.073494f, 0.750668f, 3.632199f, 0.869989f, 8.130445f, 1.911450f, 4.858570f,
0.668757f, 2.104921f, 0.010761f, 1.666085f, 0.730020f, 3.256340f, 0.682486f, 2.097233f, 0.006000f, 0.032009f, 0.007408f, 0.030256f, 1.459347f, 5.628262f, 1.661832f, 3.565415f,
1.698526f, 4.904443f, 0.027623f, 3.950396f, 2.628169f, 10.754700f, 2.483214f, 7.048634f, 1.186234f, 5.805155f, 1.480164f, 5.584030f, 3.303011f, 11.686260f, 3.801365f, 7.533570f,
0.530942f, 1.688073f, 0.010167f, 1.222976f, 1.131648f, 5.098977f, 1.259014f, 3.005839f, 0.334807f, 1.804119f, 0.491918f, 1.560900f, 1.873726f, 7.299585f, 2.539183f, 4.232526f,
1.455738f, 5.038378f, 0.030252f, 3.646170f, 3.295735f, 16.165440f, 3.979064f, 9.518954f, 0.995905f, 5.841868f, 1.587909f, 5.048714f, 2.882979f, 12.226350f, 4.239737f, 7.081374f,
0.117076f, 0.213201f, 0.001743f, 0.378319f, 0.186141f, 0.480386f, 0.161020f, 0.693610f, 0.001476f, 0.004557f, 0.001687f, 0.009656f, 0.342913f, 0.765159f, 0.361318f, 1.086664f,
0.186601f, 0.311733f, 0.002808f, 0.562914f, 0.420535f, 0.995634f, 0.367656f, 1.462899f, 0.183157f, 0.518585f, 0.211467f, 1.118308f, 0.487052f, 0.996996f, 0.518661f, 1.440876f,
0.001852f, 0.003406f, 0.000033f, 0.005532f, 0.005748f, 0.014985f, 0.005918f, 0.019804f, 0.001641f, 0.005116f, 0.002231f, 0.009924f, 0.008771f, 0.019770f, 0.010998f, 0.025698f,
0.227802f, 0.456160f, 0.004380f, 0.740067f, 0.751163f, 2.131678f, 0.839153f, 2.814047f, 0.219030f, 0.743345f, 0.323140f, 1.440215f, 0.605536f, 1.485757f, 0.823978f, 1.929195f,
0.194633f, 0.487989f, 0.002744f, 0.768560f, 0.293024f, 1.041173f, 0.240044f, 1.334280f, 0.002636f, 0.011203f, 0.002852f, 0.021071f, 0.520831f, 1.600063f, 0.519701f, 2.016879f,
0.435433f, 1.001529f, 0.006205f, 1.605171f, 0.929227f, 3.028945f, 0.769327f, 3.950072f, 0.459106f, 1.789705f, 0.501974f, 3.425486f, 1.038360f, 2.926429f, 1.047144f, 3.753795f,
0.163219f, 0.413370f, 0.002739f, 0.595899f, 0.479793f, 1.722066f, 0.467736f, 2.019945f, 0.155386f, 0.666970f, 0.200050f, 1.148215f, 0.706347f, 2.191970f, 0.838754f, 2.528966f,
0.464294f, 1.280045f, 0.008455f, 1.843225f, 1.449711f, 5.664235f, 1.533694f, 6.636667f, 0.479536f, 2.240680f, 0.669974f, 3.853150f, 1.127561f, 3.809082f, 1.453002f, 4.389833f,
0.036165f, 0.179751f, 0.000885f, 0.244680f, 0.063113f, 0.444557f, 0.089736f, 0.492392f, 0.000582f, 0.004907f, 0.001094f, 0.007976f, 0.125251f, 0.762800f, 0.216919f, 0.831023f,
0.068845f, 0.313909f, 0.001703f, 0.434831f, 0.170300f, 1.100462f, 0.244717f, 1.240362f, 0.086307f, 0.666967f, 0.163785f, 1.103327f, 0.212477f, 1.187110f, 0.371903f, 1.316082f,
0.023672f, 0.118848f, 0.000689f, 0.148076f, 0.080661f, 0.573915f, 0.136480f, 0.581831f, 0.026795f, 0.228004f, 0.059875f, 0.339250f, 0.132585f, 0.815646f, 0.273257f, 0.813335f,
0.098569f, 0.538719f, 0.003115f, 0.670463f, 0.356757f, 2.763264f, 0.655073f, 2.798276f, 0.121046f, 1.121243f, 0.293527f, 1.666462f, 0.309814f, 2.074773f, 0.692925f, 2.066606f,
0.597159f, 1.346873f, 0.009782f, 1.776974f, 0.740242f, 2.366129f, 0.704482f, 2.540085f, 0.007275f, 0.027810f, 0.009144f, 0.043817f, 1.640410f, 4.533539f, 1.901591f, 4.787029f,
1.364924f, 2.824199f, 0.022597f, 3.791746f, 2.398321f, 7.032695f, 2.306772f, 7.682831f, 1.294361f, 4.539084f, 1.644112f, 7.277714f, 3.341324f, 8.471362f, 3.914574f, 9.102728f,
0.471197f, 1.073535f, 0.009185f, 1.296391f, 1.140472f, 3.682356f, 1.291636f, 3.618272f, 0.403459f, 1.557897f, 0.603439f, 2.246682f, 2.093312f, 5.843799f, 2.887741f, 5.647934f,
1.061839f, 2.633513f, 0.022463f, 3.176687f, 2.729892f, 9.595109f, 3.355138f, 9.417694f, 0.986375f, 4.146150f, 1.600980f, 5.972649f, 2.647214f, 8.044773f, 3.962989f, 7.766535f,
0.422173f, 1.030100f, 0.007079f, 1.460180f, 0.697908f, 2.413320f, 0.679852f, 2.783539f, 0.004099f, 0.016951f, 0.005273f, 0.028696f, 0.883910f, 2.642684f, 1.048802f, 2.998103f,
0.522424f, 1.169397f, 0.008853f, 1.686857f, 1.224180f, 3.883399f, 1.205211f, 4.558102f, 0.394836f, 1.497897f, 0.513350f, 2.580367f, 0.974738f, 2.673468f, 1.168893f, 3.086497f,
0.004962f, 0.012230f, 0.000099f, 0.015868f, 0.016016f, 0.055945f, 0.018567f, 0.059062f, 0.003386f, 0.014145f, 0.005184f, 0.021917f, 0.016802f, 0.050741f, 0.023724f, 0.052690f,
0.675493f, 1.812384f, 0.014627f, 2.348885f, 2.315963f, 8.806197f, 2.913515f, 9.286575f, 0.500094f, 2.274088f, 0.830838f, 3.519668f, 1.283532f, 4.219722f, 1.966805f, 4.376933f,
0.925182f, 3.108055f, 0.014691f, 3.910340f, 1.448260f, 6.895022f, 1.336022f, 7.058577f, 0.009650f, 0.054941f, 0.011756f, 0.082548f, 1.769741f, 7.284826f, 1.988591f, 7.335328f,
1.607011f, 4.952567f, 0.025789f, 6.340826f, 3.565767f, 15.573710f, 3.324462f, 16.224200f, 1.304652f, 6.814469f, 1.606356f, 10.419100f, 2.739358f, 10.344470f, 3.110899f, 10.599810f,
0.576568f, 1.956539f, 0.010895f, 2.253098f, 1.762252f, 8.474880f, 1.934615f, 7.941101f, 0.422645f, 2.430750f, 0.612748f, 3.342832f, 1.783618f, 7.416307f, 2.385048f, 6.835239f,
1.814868f, 6.704194f, 0.037216f, 7.711826f, 5.892060f, 30.845820f, 7.019453f, 28.871050f, 1.443303f, 9.036182f, 2.270766f, 12.413050f, 3.150616f, 14.260830f, 4.571938f, 13.128950f,
0.168876f, 1.124656f, 0.004654f, 1.222939f, 0.306430f, 2.892081f, 0.490634f, 2.558889f, 0.002094f, 0.023638f, 0.004428f, 0.030696f, 0.418084f, 3.411640f, 0.815379f, 2.969087f,
0.249597f, 1.524897f, 0.006952f, 1.687390f, 0.641974f, 5.558352f, 1.038832f, 5.004683f, 0.240934f, 2.494738f, 0.514878f, 3.296725f, 0.550659f, 4.122221f, 1.085373f, 3.650738f,
0.082146f, 0.552602f, 0.002694f, 0.550001f, 0.291036f, 2.774607f, 0.554539f, 2.247026f, 0.071597f, 0.816295f, 0.180160f, 0.970244f, 0.328889f, 2.710971f, 0.763316f, 2.159485f,
0.378497f, 2.771750f, 0.013471f, 2.755650f, 1.424390f, 14.782490f, 2.945265f, 11.958410f, 0.357897f, 4.441966f, 0.977310f, 5.273855f, 0.850406f, 7.630716f, 2.141858f, 6.071694f,
1.288569f, 3.894161f, 0.023770f, 4.104172f, 1.660831f, 7.113105f, 1.779919f, 6.099955f, 0.012088f, 0.061912f, 0.017108f, 0.077924f, 2.530308f, 9.369741f, 3.303064f, 7.903397f,
2.286727f, 6.339726f, 0.042632f, 6.799419f, 4.177793f, 16.414610f, 4.525046f, 14.324770f, 1.669725f, 7.845615f, 2.388360f, 10.048730f, 4.001543f, 13.593500f, 5.279252f, 11.668290f,
0.755599f, 2.306610f, 0.016587f, 2.225110f, 1.901548f, 8.226547f, 2.425167f, 6.457295f, 0.498164f, 2.577394f, 0.839045f, 2.969211f, 2.399529f, 8.975457f, 3.727599f, 6.929604f,
1.884164f, 6.261307f, 0.044886f, 6.033392f, 5.036622f, 23.719910f, 6.970810f, 18.597960f, 1.347678f, 7.590289f, 2.463252f, 8.734494f, 3.357782f, 13.672450f, 5.660634f, 10.544290f,
0.051774f, 0.092650f, 0.000563f, 0.132098f, 0.086803f, 0.220136f, 0.054857f, 0.255387f, 0.000575f, 0.001744f, 0.000480f, 0.002970f, 0.175067f, 0.383871f, 0.134763f, 0.438036f,
0.079608f, 0.130689f, 0.000875f, 0.189618f, 0.189186f, 0.440148f, 0.120834f, 0.519631f, 0.068830f, 0.191507f, 0.058057f, 0.331824f, 0.239880f, 0.482530f, 0.186622f, 0.560324f,
0.000781f, 0.001411f, 0.000010f, 0.001842f, 0.002556f, 0.006548f, 0.001922f, 0.006953f, 0.000610f, 0.001867f, 0.000605f, 0.002910f, 0.004270f, 0.009457f, 0.003911f, 0.009878f,
0.123265f, 0.242556f, 0.001732f, 0.316190f, 0.428609f, 1.195256f, 0.349807f, 1.267805f, 0.104399f, 0.348173f, 0.112523f, 0.542018f, 0.378267f, 0.912050f, 0.376041f, 0.951545f,
0.071300f, 0.175670f, 0.000734f, 0.222304f, 0.113194f, 0.395233f, 0.067744f, 0.406967f, 0.000851f, 0.003552f, 0.000672f, 0.005369f, 0.220266f, 0.664966f, 0.160570f, 0.673479f,
0.153884f, 0.347815f, 0.001602f, 0.447907f, 0.346288f, 1.109225f, 0.209453f, 1.162291f, 0.142921f, 0.547488f, 0.114162f, 0.841972f, 0.423639f, 1.173270f, 0.312115f, 1.209240f,
0.057015f, 0.141895f, 0.000699f, 0.164355f, 0.176731f, 0.623335f, 0.125870f, 0.587480f, 0.047812f, 0.201671f, 0.044970f, 0.278960f, 0.284845f, 0.868636f, 0.247108f, 0.805245f,
0.208116f, 0.563832f, 0.002769f, 0.652356f, 0.685232f, 2.630931f, 0.529609f, 2.476853f, 0.189340f, 0.869387f, 0.193259f, 1.201244f, 0.583483f, 1.936959f, 0.549306f, 1.793618f,
0.000706f, 0.003448f, 0.000013f, 0.003772f, 0.001299f, 0.008993f, 0.001350f, 0.008004f, 0.000010f, 0.000083f, 0.000014f, 0.000108f, 0.002823f, 0.016894f, 0.003572f, 0.014788f,
0.001297f, 0.005810f, 0.000023f, 0.006466f, 0.003382f, 0.021476f, 0.003551f, 0.019450f, 0.001432f, 0.010873f, 0.001985f, 0.014452f, 0.004620f, 0.025363f, 0.005907f, 0.022593f,
0.000441f, 0.002174f, 0.000009f, 0.002176f, 0.001583f, 0.011071f, 0.001957f, 0.009018f, 0.000439f, 0.003674f, 0.000717f, 0.004392f, 0.002849f, 0.017225f, 0.004290f, 0.013801f,
0.002355f, 0.012646f, 0.000054f, 0.012646f, 0.008986f, 0.068399f, 0.012055f, 0.055654f, 0.002547f, 0.023184f, 0.004512f, 0.027687f, 0.008544f, 0.056225f, 0.013960f, 0.044998f,
0.182506f, 0.404508f, 0.002184f, 0.428808f, 0.238565f, 0.749346f, 0.165868f, 0.646359f, 0.001959f, 0.007357f, 0.001798f, 0.009314f, 0.578784f, 1.571857f, 0.490164f, 1.333594f,
0.402434f, 0.818263f, 0.004867f, 0.882711f, 0.745653f, 2.148638f, 0.523955f, 1.886013f, 0.336163f, 1.158443f, 0.311951f, 1.492394f, 1.137313f, 2.833521f, 0.973433f, 2.446396f,
0.137319f, 0.307437f, 0.001956f, 0.298304f, 0.350475f, 1.112014f, 0.289983f, 0.877946f, 0.103571f, 0.392997f, 0.113170f, 0.455379f, 0.704269f, 1.932021f, 0.709779f, 1.500334f,
0.397086f, 0.967772f, 0.006137f, 0.937981f, 1.076503f, 3.718189f, 0.966585f, 2.932298f, 0.324921f, 1.342121f, 0.385284f, 1.553444f, 1.142854f, 3.412929f, 1.249927f, 2.647419f,
0.071518f, 0.181746f, 0.001046f, 0.193483f, 0.102259f, 0.368283f, 0.086897f, 0.319017f, 0.000796f, 0.003430f, 0.000894f, 0.004360f, 0.211044f, 0.657161f, 0.218446f, 0.559916f,
0.167415f, 0.390298f, 0.002475f, 0.422826f, 0.339312f, 1.121056f, 0.291408f, 0.988209f, 0.145094f, 0.573292f, 0.164563f, 0.741694f, 0.440252f, 1.257622f, 0.460546f, 1.090412f,
0.001663f, 0.004268f, 0.000029f, 0.004159f, 0.004642f, 0.016886f, 0.004694f, 0.013388f, 0.001301f, 0.005660f, 0.001738f, 0.006587f, 0.007934f, 0.024957f, 0.009773f, 0.019463f,
0.246457f, 0.688704f, 0.004655f, 0.670338f, 0.730859f, 2.894355f, 0.802055f, 2.292285f, 0.209234f, 0.990944f, 0.303237f, 1.151843f, 0.660038f, 2.259994f, 0.882283f, 1.760527f,
0.165026f, 0.577399f, 0.002286f, 0.545571f, 0.223436f, 1.107908f, 0.179806f, 0.851794f, 0.001974f, 0.011704f, 0.002098f, 0.013207f, 0.444914f, 1.907423f, 0.436111f, 1.442437f,
0.542242f, 1.740467f, 0.007591f, 1.673520f, 1.040658f, 4.733785f, 0.846372f, 3.703644f, 0.504810f, 2.746168f, 0.542201f, 3.153371f, 1.302758f, 5.123709f, 1.290582f, 3.942975f,
0.203410f, 0.718905f, 0.003353f, 0.621745f, 0.537737f, 2.693377f, 0.514969f, 1.895370f, 0.170985f, 1.024194f, 0.216246f, 1.057807f, 0.886878f, 3.840707f, 1.034532f, 2.658439f,
0.697216f, 2.682442f, 0.012472f, 2.317344f, 1.957809f, 10.674830f, 2.034657f, 7.503724f, 0.635827f, 4.145990f, 0.872648f, 4.277316f, 1.705920f, 8.042098f, 2.159475f, 5.560375f,
0.057649f, 0.399857f, 0.001386f, 0.326543f, 0.090477f, 0.889358f, 0.126371f, 0.590973f, 0.000820f, 0.009637f, 0.001512f, 0.009399f, 0.201154f, 1.709580f, 0.342223f, 1.117374f,
0.161180f, 1.025591f, 0.003916f, 0.852312f, 0.358567f, 3.233411f, 0.506155f, 2.186457f, 0.178414f, 1.924059f, 0.332599f, 1.909527f, 0.501182f, 3.907563f, 0.861742f, 2.598992f,
0.055463f, 0.388592f, 0.001587f, 0.290465f, 0.169960f, 1.687576f, 0.282499f, 1.026407f, 0.055434f, 0.658245f, 0.121681f, 0.587585f, 0.312975f, 2.686870f, 0.633650f, 1.607391f,
0.278281f, 2.122443f, 0.008640f, 1.584731f, 0.905796f, 9.790629f, 1.633845f, 5.948205f, 0.301744f, 3.900469f, 0.718782f, 3.477918f, 0.881227f, 8.235467f, 1.936140f, 4.921328f,
0.243744f, 0.767188f, 0.003922f, 0.607244f, 0.271727f, 1.212071f, 0.254034f, 0.780630f, 0.002622f, 0.013987f, 0.003237f, 0.013221f, 0.674591f, 2.601695f, 0.768191f, 1.648133f,
0.818256f, 2.362691f, 0.013307f, 1.903084f, 1.293013f, 5.291125f, 1.221698f, 3.467805f, 0.685140f, 3.352919f, 0.854908f, 3.225202f, 2.018104f, 7.140174f, 2.322593f, 4.602929f,
0.282692f, 0.898789f, 0.005413f, 0.651155f, 0.615333f, 2.772568f, 0.684589f, 1.634424f, 0.213724f, 1.151659f, 0.314016f, 0.996400f, 1.265287f, 4.929252f, 1.714656f, 2.858133f,
0.767612f, 2.656744f, 0.015952f, 1.922630f, 1.774776f, 8.705200f, 2.142753f, 5.126023f, 0.629606f, 3.693197f, 1.003867f, 3.191770f, 1.928042f, 8.176586f, 2.835397f, 4.735792f,
0.026099f, 0.047527f, 0.000389f, 0.084335f, 0.042376f, 0.109363f, 0.036657f, 0.157905f, 0.000395f, 0.001218f, 0.000451f, 0.002581f, 0.096950f, 0.216330f, 0.102154f, 0.307227f,
0.054981f, 0.091851f, 0.000827f, 0.165860f, 0.126542f, 0.299593f, 0.110630f, 0.440196f, 0.064702f, 0.183194f, 0.074702f, 0.395051f, 0.182008f, 0.372571f, 0.193820f, 0.538446f,
0.000603f, 0.001109f, 0.000011f, 0.001802f, 0.001912f, 0.004984f, 0.001968f, 0.006586f, 0.000641f, 0.001998f, 0.000871f, 0.003874f, 0.003623f, 0.008165f, 0.004542f, 0.010614f,
0.073468f, 0.147116f, 0.001413f, 0.238678f, 0.247404f, 0.702094f, 0.276385f, 0.926840f, 0.084691f, 0.287424f, 0.124946f, 0.556879f, 0.247684f, 0.607722f, 0.337033f, 0.789103f,
0.053701f, 0.134639f, 0.000757f, 0.212051f, 0.082565f, 0.293372f, 0.067637f, 0.375961f, 0.000872f, 0.003706f, 0.000943f, 0.006970f, 0.182254f, 0.559907f, 0.181858f, 0.705763f,
0.158795f, 0.365239f, 0.002263f, 0.585377f, 0.346073f, 1.128075f, 0.286522f, 1.471132f, 0.200733f, 0.782506f, 0.219476f, 1.497712f, 0.480262f, 1.353532f, 0.484325f, 1.736205f,
0.065786f, 0.166610f, 0.001104f, 0.240180f, 0.197492f, 0.708836f, 0.192529f, 0.831449f, 0.075087f, 0.322301f, 0.096670f, 0.554854f, 0.361075f, 1.120507f, 0.428760f, 1.292775f,
0.185331f, 0.510953f, 0.003375f, 0.735757f, 0.590976f, 2.309029f, 0.625211f, 2.705442f, 0.229493f, 1.072328f, 0.320631f, 1.844012f, 0.570837f, 1.928379f, 0.735594f, 2.222388f,
0.014857f, 0.073845f, 0.000364f, 0.100519f, 0.026479f, 0.186513f, 0.037648f, 0.206582f, 0.000287f, 0.002417f, 0.000539f, 0.003929f, 0.065260f, 0.397444f, 0.113022f, 0.432990f,
0.037383f, 0.170453f, 0.000925f, 0.236114f, 0.094438f, 0.610250f, 0.135705f, 0.687829f, 0.056187f, 0.434206f, 0.106627f, 0.718284f, 0.146328f, 0.817537f, 0.256121f, 0.906357f,
0.014206f, 0.071325f, 0.000414f, 0.088866f, 0.049436f, 0.351746f, 0.083647f, 0.356598f, 0.019280f, 0.164053f, 0.043081f, 0.244096f, 0.100916f, 0.620822f, 0.207987f, 0.619063f,
0.058584f, 0.320187f, 0.001852f, 0.398489f, 0.216544f, 1.677244f, 0.397616f, 1.698496f, 0.086255f, 0.798975f, 0.209161f, 1.187487f, 0.233539f, 1.563970f, 0.522329f, 1.557813f,
0.161972f, 0.365323f, 0.002653f, 0.481982f, 0.205048f, 0.655421f, 0.195142f, 0.703608f, 0.002366f, 0.009044f, 0.002973f, 0.014249f, 0.564311f, 1.559564f, 0.654159f, 1.646766f,
0.489339f, 1.012503f, 0.008101f, 1.359378f, 0.878094f, 2.574870f, 0.844575f, 2.812903f, 0.556350f, 1.951018f, 0.706683f, 3.128153f, 1.519273f, 3.851860f, 1.779926f, 4.138937f,
0.186704f, 0.425370f, 0.003640f, 0.513673f, 0.461496f, 1.490077f, 0.522665f, 1.464145f, 0.191665f, 0.740084f, 0.286666f, 1.067294f, 1.051963f, 2.936716f, 1.451192f, 2.838287f,
0.416679f, 1.033423f, 0.008815f, 1.246571f, 1.094008f, 3.845254f, 1.344577f, 3.774155f, 0.464063f, 1.950652f, 0.753218f, 2.809970f, 1.317492f, 4.003803f, 1.972340f, 3.865327f,
0.168111f, 0.410191f, 0.002819f, 0.581450f, 0.283816f, 0.981417f, 0.276473f, 1.131973f, 0.001957f, 0.008093f, 0.002518f, 0.013700f, 0.446407f, 1.334652f, 0.529683f, 1.514151f,
0.274967f, 0.615488f, 0.004660f, 0.887843f, 0.658014f, 2.087383f, 0.647819f, 2.450046f, 0.249153f, 0.945218f, 0.323939f, 1.628288f, 0.650672f, 1.784633f, 0.780277f, 2.060345f,
0.002886f, 0.007114f, 0.000058f, 0.009231f, 0.009515f, 0.033235f, 0.011030f, 0.035087f, 0.002362f, 0.009865f, 0.003615f, 0.015285f, 0.012396f, 0.037436f, 0.017503f, 0.038873f,
0.389153f, 1.044118f, 0.008427f, 1.353198f, 1.362584f, 5.181079f, 1.714151f, 5.463707f, 0.345417f, 1.570719f, 0.573863f, 2.431045f, 0.937826f, 3.083184f, 1.437066f, 3.198052f,
0.455982f, 1.531827f, 0.007240f, 1.927239f, 0.728954f, 3.470477f, 0.672461f, 3.552799f, 0.005702f, 0.032465f, 0.006947f, 0.048778f, 1.106234f, 4.553617f, 1.243033f, 4.585185f,
1.046867f, 3.226286f, 0.016800f, 4.130649f, 2.372236f, 10.360890f, 2.211700f, 10.793640f, 1.018964f, 5.322264f, 1.254602f, 8.137572f, 2.263276f, 8.546666f, 2.570245f, 8.757633f,
0.415119f, 1.408674f, 0.007844f, 1.622191f, 1.295753f, 6.231432f, 1.422489f, 5.838953f, 0.364829f, 2.098235f, 0.528927f, 2.885549f, 1.628695f, 6.772138f, 2.177887f, 6.241540f,
1.294074f, 4.780361f, 0.026536f, 5.498843f, 4.290557f, 22.461710f, 5.111517f, 21.023700f, 1.233853f, 7.724867f, 1.941236f, 10.611690f, 2.849218f, 12.896600f, 4.134572f, 11.872990f,
0.123930f, 0.825328f, 0.003415f, 0.897453f, 0.229652f, 2.167454f, 0.367703f, 1.917744f, 0.001843f, 0.020797f, 0.003896f, 0.027007f, 0.389123f, 3.175311f, 0.758896f, 2.763414f,
0.242101f, 1.479104f, 0.006743f, 1.636717f, 0.635928f, 5.506006f, 1.029048f, 4.957552f, 0.280187f, 2.901183f, 0.598762f, 3.833831f, 0.677418f, 5.071141f, 1.335222f, 4.491125f,
0.088063f, 0.592407f, 0.002888f, 0.589619f, 0.318630f, 3.037676f, 0.607117f, 2.460073f, 0.092022f, 1.049172f, 0.231557f, 1.247040f, 0.447170f, 3.685943f, 1.037834f, 2.936121f,
0.401849f, 2.942753f, 0.014302f, 2.925660f, 1.544405f, 16.028020f, 3.193425f, 12.965990f, 0.455564f, 5.654146f, 1.244011f, 6.713051f, 1.145097f, 10.274990f, 2.884076f, 8.175718f,
0.624332f, 1.886783f, 0.011517f, 1.988537f, 0.821799f, 3.519652f, 0.880726f, 3.018333f, 0.007022f, 0.035965f, 0.009938f, 0.045266f, 1.554883f, 5.757736f, 2.029744f, 4.856663f,
1.464447f, 4.060036f, 0.027302f, 4.354429f, 2.732365f, 10.735500f, 2.959476f, 9.368701f, 1.282024f, 6.023908f, 1.833796f, 7.715474f, 3.250148f, 11.040960f, 4.287932f, 9.477262f,
0.534811f, 1.632612f, 0.011740f, 1.574927f, 1.374512f, 5.946464f, 1.753004f, 4.667581f, 0.422739f, 2.187164f, 0.712010f, 2.519659f, 2.154026f, 8.057151f, 3.346217f, 6.220616f,
1.320747f, 4.389004f, 0.031464f, 4.229242f, 3.605561f, 16.980350f, 4.990185f, 13.313700f, 1.132607f, 6.378980f, 2.070150f, 7.340585f, 2.985174f, 12.155240f, 5.032482f, 9.374209f,
0.134803f, 0.241230f, 0.001466f, 0.343940f, 0.182164f, 0.461980f, 0.115123f, 0.535957f, 0.001168f, 0.003544f, 0.000975f, 0.006034f, 0.369390f, 0.809963f, 0.284349f, 0.924252f,
0.236979f, 0.389038f, 0.002605f, 0.564460f, 0.453930f, 1.056083f, 0.289927f, 1.246793f, 0.159886f, 0.444855f, 0.134862f, 0.770800f, 0.578686f, 1.164053f, 0.450206f, 1.351724f,
0.001642f, 0.002968f, 0.000021f, 0.003873f, 0.004332f, 0.011098f, 0.003258f, 0.011784f, 0.001000f, 0.003064f, 0.000993f, 0.004776f, 0.007276f, 0.016116f, 0.006665f, 0.016832f,
0.236708f, 0.465785f, 0.003325f, 0.607185f, 0.663407f, 1.850033f, 0.541436f, 1.962326f, 0.156441f, 0.521733f, 0.168615f, 0.812208f, 0.588663f, 1.419341f, 0.585198f, 1.480802f,
0.135102f, 0.332863f, 0.001392f, 0.421227f, 0.172877f, 0.603627f, 0.103463f, 0.621548f, 0.001258f, 0.005253f, 0.000994f, 0.007938f, 0.338230f, 1.021090f, 0.246564f, 1.034163f,
0.333374f, 0.753504f, 0.003471f, 0.970344f, 0.604675f, 1.936883f, 0.365739f, 2.029546f, 0.241609f, 0.925536f, 0.192993f, 1.423364f, 0.743754f, 2.059829f, 0.547959f, 2.122978f,
0.087248f, 0.217138f, 0.001070f, 0.251508f, 0.217986f, 0.768842f, 0.155252f, 0.724617f, 0.057093f, 0.240820f, 0.053700f, 0.333113f, 0.353243f, 1.077216f, 0.306444f, 0.998603f,
0.290846f, 0.787965f, 0.003869f, 0.911679f, 0.771864f, 2.963553f, 0.596566f, 2.789995f, 0.206482f, 0.948094f, 0.210755f, 1.309994f, 0.660817f, 2.193678f, 0.622110f, 2.031339f,
0.001187f, 0.005799f, 0.000021f, 0.006343f, 0.001761f, 0.012190f, 0.001829f, 0.010848f, 0.000013f, 0.000109f, 0.000018f, 0.000142f, 0.003847f, 0.023023f, 0.004867f, 0.020153f,
0.002493f, 0.011170f, 0.000045f, 0.012432f, 0.005241f, 0.033282f, 0.005502f, 0.030142f, 0.002148f, 0.016313f, 0.002978f, 0.021683f, 0.007198f, 0.039519f, 0.009204f, 0.035203f,
0.000598f, 0.002953f, 0.000013f, 0.002956f, 0.001733f, 0.012119f, 0.002143f, 0.009872f, 0.000466f, 0.003894f, 0.000760f, 0.004655f, 0.003136f, 0.018958f, 0.004722f, 0.015190f,
0.002920f, 0.015684f, 0.000067f, 0.015684f, 0.008984f, 0.068378f, 0.012051f, 0.055638f, 0.002465f, 0.022439f, 0.004367f, 0.026796f, 0.008588f, 0.056513f, 0.014032f, 0.045229f,
0.388910f, 0.861981f, 0.004654f, 0.913764f, 0.409754f, 1.287062f, 0.284891f, 1.110174f, 0.003257f, 0.012234f, 0.002990f, 0.015488f, 0.999500f, 2.714435f, 0.846462f, 2.302979f,
0.980469f, 1.993575f, 0.011859f, 2.150594f, 1.464275f, 4.219381f, 1.028916f, 3.703652f, 0.639102f, 2.202394f, 0.593071f, 2.837290f, 2.245509f, 5.594501f, 1.921945f, 4.830161f,
0.236321f, 0.529088f, 0.003366f, 0.513369f, 0.486155f, 1.542509f, 0.402245f, 1.217826f, 0.139088f, 0.527765f, 0.151979f, 0.611541f, 0.982212f, 2.694501f, 0.989896f, 2.092447f,
0.624085f, 1.521011f, 0.009645f, 1.474189f, 1.363704f, 4.710168f, 1.224462f, 3.714608f, 0.398489f, 1.646006f, 0.472520f, 1.905177f, 1.455609f, 4.346918f, 1.591984f, 3.371917f,
0.284825f, 0.723816f, 0.004166f, 0.770557f, 0.328255f, 1.182199f, 0.278942f, 1.024053f, 0.002475f, 0.010658f, 0.002777f, 0.013551f, 0.681132f, 2.120948f, 0.705020f, 1.807094f,
0.762302f, 1.777165f, 0.011269f, 1.925279f, 1.245307f, 4.114382f, 1.069496f, 3.626822f, 0.515539f, 2.036986f, 0.584713f, 2.635341f, 1.624532f, 4.640628f, 1.699416f, 4.023622f,
0.005347f, 0.013727f, 0.000093f, 0.013376f, 0.012033f, 0.043776f, 0.012169f, 0.034708f, 0.003265f, 0.014206f, 0.004361f, 0.016531f, 0.020681f, 0.065049f, 0.025474f, 0.050729f,
0.723924f, 2.022943f, 0.013674f, 1.968995f, 1.730335f, 6.852491f, 1.898894f, 5.427068f, 0.479583f, 2.271332f, 0.695045f, 2.640126f, 1.571139f, 5.379639f, 2.100167f, 4.190721f,
0.478300f, 1.673491f, 0.006625f, 1.581243f, 0.521971f, 2.588195f, 0.420047f, 1.989885f, 0.004464f, 0.026471f, 0.004744f, 0.029870f, 1.045006f, 4.480120f, 1.024329f, 3.387970f,
1.796838f, 5.767424f, 0.025154f, 5.545580f, 2.779520f, 12.643590f, 2.260596f, 9.892159f, 1.305343f, 7.101067f, 1.402028f, 8.154017f, 3.498443f, 13.759280f, 3.465746f, 10.588520f,
0.476123f, 1.682748f, 0.007848f, 1.455325f, 1.014527f, 5.081486f, 0.971572f, 3.575917f, 0.312310f, 1.870728f, 0.394980f, 1.932122f, 1.682313f, 7.285411f, 1.962397f, 5.042775f,
1.490399f, 5.734105f, 0.026660f, 4.953656f, 3.373274f, 18.392560f, 3.505682f, 12.928790f, 1.060609f, 6.915828f, 1.455643f, 7.134890f, 2.955214f, 13.931560f, 3.740922f, 9.632401f,
0.148289f, 1.028539f, 0.003565f, 0.839954f, 0.187585f, 1.843904f, 0.262005f, 1.225262f, 0.001646f, 0.019344f, 0.003035f, 0.018866f, 0.419314f, 3.563692f, 0.713378f, 2.329215f,
0.474019f, 3.016189f, 0.011517f, 2.506588f, 0.849964f, 7.664624f, 1.199812f, 5.182878f, 0.409444f, 4.415532f, 0.763284f, 4.382182f, 1.194469f, 9.312908f, 2.053791f, 6.194186f,
0.115218f, 0.807253f, 0.003296f, 0.603406f, 0.284583f, 2.825694f, 0.473020f, 1.718625f, 0.089860f, 1.067048f, 0.197251f, 0.952505f, 0.526891f, 4.523323f, 1.066744f, 2.706030f,
0.527943f, 4.026610f, 0.016391f, 3.006486f, 1.385095f, 14.971310f, 2.498389f, 9.095681f, 0.446706f, 5.774320f, 1.064097f, 5.148769f, 1.354835f, 12.661550f, 2.976703f, 7.566255f,
0.794481f, 2.500639f, 0.012785f, 1.979303f, 0.713884f, 3.184368f, 0.667402f, 2.050880f, 0.006669f, 0.035576f, 0.008234f, 0.033628f, 1.781907f, 6.872278f, 2.029147f, 4.353480f,
3.049349f, 8.804904f, 0.049592f, 7.092112f, 3.883886f, 15.893210f, 3.669672f, 10.416410f, 1.992406f, 9.750374f, 2.486093f, 9.378970f, 6.094754f, 21.563610f, 7.014324f, 13.901030f,
0.744154f, 2.365959f, 0.014250f, 1.714092f, 1.305587f, 5.882709f, 1.452529f, 3.467847f, 0.439019f, 2.365668f, 0.645033f, 2.046745f, 2.699190f, 10.515390f, 3.657812f, 6.097151f,
1.845351f, 6.386850f, 0.038349f, 4.622030f, 3.438954f, 16.867920f, 4.151978f, 9.932609f, 1.181099f, 6.928195f, 1.883189f, 5.987549f, 3.756200f, 15.929570f, 5.523903f, 9.226239f,
0.118026f, 0.214930f, 0.001757f, 0.381387f, 0.154465f, 0.398636f, 0.133619f, 0.575574f, 0.001392f, 0.004297f, 0.001591f, 0.009107f, 0.355306f, 0.792812f, 0.374377f, 1.125937f,
0.284276f, 0.474909f, 0.004278f, 0.857570f, 0.527361f, 1.248548f, 0.461049f, 1.834509f, 0.261050f, 0.739128f, 0.301399f, 1.593901f, 0.762630f, 1.561104f, 0.812123f, 2.256136f,
0.002202f, 0.004051f, 0.000039f, 0.006580f, 0.005628f, 0.014671f, 0.005793f, 0.019388f, 0.001826f, 0.005693f, 0.002482f, 0.011042f, 0.010722f, 0.024167f, 0.013444f, 0.031414f,
0.245045f, 0.490688f, 0.004712f, 0.796085f, 0.665121f, 1.887505f, 0.743032f, 2.491712f, 0.220427f, 0.748085f, 0.325200f, 1.449400f, 0.669483f, 1.642658f, 0.910993f, 2.132926f,
0.176736f, 0.443115f, 0.002492f, 0.697887f, 0.219022f, 0.778230f, 0.179422f, 0.997314f, 0.002240f, 0.009517f, 0.002423f, 0.017901f, 0.486088f, 1.493328f, 0.485034f, 1.882340f,
0.597514f, 1.374327f, 0.008515f, 2.202663f, 1.049606f, 3.421340f, 0.868992f, 4.461797f, 0.589403f, 2.297632f, 0.644437f, 4.397656f, 1.464488f, 4.127394f, 1.476876f, 5.294298f,
0.174855f, 0.442839f, 0.002934f, 0.638381f, 0.423096f, 1.518573f, 0.412465f, 1.781252f, 0.155737f, 0.668477f, 0.200502f, 1.150810f, 0.777744f, 2.413535f, 0.923535f, 2.784595f,
0.449863f, 1.240260f, 0.008192f, 1.785936f, 1.156238f, 4.517592f, 1.223220f, 5.293169f, 0.434692f, 2.031140f, 0.607320f, 3.492818f, 1.122895f, 3.793317f, 1.446988f, 4.371664f,
0.043396f, 0.215691f, 0.001062f, 0.293602f, 0.062339f, 0.439103f, 0.088635f, 0.486351f, 0.000654f, 0.005508f, 0.001228f, 0.008954f, 0.154473f, 0.940769f, 0.267528f, 1.024909f,
0.124840f, 0.569225f, 0.003088f, 0.788499f, 0.254199f, 1.642608f, 0.365278f, 1.851429f, 0.146420f, 1.131506f, 0.277861f, 1.871791f, 0.396007f, 2.212498f, 0.693140f, 2.452871f,
0.033512f, 0.168250f, 0.000976f, 0.209627f, 0.093994f, 0.668786f, 0.159041f, 0.678010f, 0.035489f, 0.301979f, 0.079301f, 0.449318f, 0.192916f, 1.186791f, 0.397598f, 1.183429f,
0.126206f, 0.689769f, 0.003989f, 0.858453f, 0.376004f, 2.912340f, 0.690414f, 2.949241f, 0.144999f, 1.343117f, 0.351610f, 1.996224f, 0.407712f, 2.730382f, 0.911883f, 2.719634f,
0.599494f, 1.352141f, 0.009820f, 1.783924f, 0.611712f, 1.955294f, 0.582161f, 2.099046f, 0.006833f, 0.026120f, 0.008588f, 0.041154f, 1.692618f, 4.677824f, 1.962112f, 4.939382f,
2.070731f, 4.284602f, 0.034282f, 5.752470f, 2.995027f, 8.782438f, 2.880699f, 9.594329f, 1.837143f, 6.442520f, 2.333560f, 10.329580f, 5.210086f, 13.209290f, 6.103949f, 14.193780f,
0.558083f, 1.271488f, 0.010879f, 1.535437f, 1.111883f, 3.590047f, 1.259258f, 3.527570f, 0.447062f, 1.726265f, 0.668655f, 2.489489f, 2.548247f, 7.113818f, 3.515327f, 6.875386f,
1.137456f, 2.821055f, 0.024063f, 3.402911f, 2.407131f, 8.460659f, 2.958453f, 8.304220f, 0.988532f, 4.155216f, 1.604481f, 5.985708f, 2.914583f, 8.857296f, 4.363251f, 8.550956f,
0.416808f, 1.017010f, 0.006989f, 1.441624f, 0.567181f, 1.961277f, 0.552508f, 2.262150f, 0.003786f, 0.015658f, 0.004871f, 0.026505f, 0.896944f, 2.681652f, 1.064267f, 3.042312f,
0.779450f, 1.744728f, 0.013208f, 2.516773f, 1.503451f, 4.769313f, 1.480155f, 5.597936f, 0.551131f, 2.090837f, 0.716559f, 3.601800f, 1.494737f, 4.099699f, 1.792469f, 4.733069f,
0.005780f, 0.014245f, 0.000115f, 0.018483f, 0.015357f, 0.053640f, 0.017802f, 0.056628f, 0.003690f, 0.015414f, 0.005649f, 0.023883f, 0.020114f, 0.060746f, 0.028402f, 0.063079f,
0.711619f, 1.909312f, 0.015409f, 2.474506f, 2.008336f, 7.636480f, 2.526517f, 8.053051f, 0.492891f, 2.241333f, 0.818871f, 3.468972f, 1.389775f, 4.569006f, 2.129606f, 4.739230f,
0.822758f, 2.763973f, 0.013064f, 3.477440f, 1.060156f, 5.047298f, 0.977995f, 5.167024f, 0.008028f, 0.045710f, 0.009781f, 0.068679f, 1.617581f, 6.658487f, 1.817615f, 6.704647f,
2.159652f, 6.655723f, 0.034657f, 8.521395f, 3.944538f, 17.228010f, 3.677600f, 17.947600f, 1.640333f, 8.567801f, 2.019664f, 13.099890f, 3.783772f, 14.288420f, 4.296968f, 14.641120f,
0.604918f, 2.052743f, 0.011431f, 2.363883f, 1.521921f, 7.319102f, 1.670778f, 6.858118f, 0.414853f, 2.385936f, 0.601451f, 3.281203f, 1.923353f, 7.997330f, 2.571902f, 7.370738f,
1.722149f, 6.361689f, 0.035314f, 7.317842f, 4.602261f, 24.093520f, 5.482863f, 22.551040f, 1.281315f, 8.022012f, 2.015908f, 11.019880f, 3.072788f, 13.908550f, 4.459000f, 12.804630f,
0.198457f, 1.321657f, 0.005469f, 1.437156f, 0.296421f, 2.797614f, 0.474608f, 2.475305f, 0.002303f, 0.025989f, 0.004869f, 0.033748f, 0.504980f, 4.120724f, 0.984849f, 3.586190f,
0.443259f, 2.708066f, 0.012346f, 2.996637f, 0.938457f, 8.125368f, 1.518596f, 7.315998f, 0.400303f, 4.144920f, 0.855452f, 5.477394f, 1.005107f, 7.524218f, 1.981112f, 6.663628f,
0.113890f, 0.766148f, 0.003735f, 0.762541f, 0.332142f, 3.166501f, 0.632864f, 2.564402f, 0.092868f, 1.058813f, 0.233685f, 1.258500f, 0.468663f, 3.863100f, 1.087715f, 3.077240f,
0.474616f, 3.475632f, 0.016892f, 3.455443f, 1.470235f, 15.258280f, 3.040062f, 12.343300f, 0.419866f, 5.211077f, 1.146528f, 6.187004f, 1.096017f, 9.834592f, 2.760461f, 7.825298f,
1.266897f, 3.828666f, 0.023370f, 4.035146f, 1.344118f, 5.756667f, 1.440496f, 4.936720f, 0.011119f, 0.056949f, 0.015736f, 0.071677f, 2.556927f, 9.468311f, 3.337812f, 7.986541f,
3.397565f, 9.419414f, 0.063342f, 10.102420f, 5.109502f, 20.075310f, 5.534197f, 17.519400f, 2.320977f, 10.905680f, 3.319906f, 13.968100f, 6.110718f, 20.758510f, 8.061894f, 17.818540f,
0.876448f, 2.675523f, 0.019240f, 2.580989f, 1.815600f, 7.854714f, 2.315552f, 6.165431f, 0.540604f, 2.796970f, 0.910526f, 3.222167f, 2.860697f, 10.700460f, 4.444009f, 8.261411f,
1.976665f, 6.568699f, 0.047089f, 6.329595f, 4.349427f, 20.483570f, 6.019714f, 16.060460f, 1.322736f, 7.449810f, 2.417663f, 8.572838f, 3.620580f, 14.742530f, 6.103666f, 11.369550f,
};

static const float acceptor_me2x3acc3[16384] = {
0.036350f, 0.044079f, 0.017386f, 0.046962f, 0.031088f, 0.045756f, 0.024587f, 0.034370f, 0.025195f, 0.034486f, 0.017536f, 0.034052f, 0.076383f, 0.099866f, 0.073811f, 0.086068f,
0.047550f, 0.057744f, 0.028229f, 0.064311f, 0.043775f, 0.064522f, 0.042972f, 0.050664f, 0.064784f, 0.088804f, 0.055968f, 0.091663f, 0.081233f, 0.106361f, 0.097434f, 0.095823f,
0.243824f, 0.254641f, 0.117527f, 0.282971f, 0.147646f, 0.187151f, 0.117680f, 0.146631f, 0.160177f, 0.188823f, 0.112355f, 0.194472f, 0.391222f, 0.440520f, 0.380999f, 0.395997f,
0.023217f, 0.027583f, 0.011848f, 0.035175f, 0.032216f, 0.046454f, 0.027185f, 0.041768f, 0.034881f, 0.046775f, 0.025903f, 0.055285f, 0.052301f, 0.066993f, 0.053925f, 0.069110f,
0.845246f, 1.058768f, 0.485224f, 0.886728f, 0.769988f, 1.170633f, 0.730911f, 0.691241f, 0.573267f, 0.810543f, 0.478904f, 0.629150f, 1.393519f, 1.882007f, 1.616261f, 1.275036f,
0.529473f, 0.664187f, 0.377275f, 0.581493f, 0.519190f, 0.790481f, 0.611732f, 0.487938f, 0.705887f, 0.999501f, 0.731951f, 0.811009f, 0.709682f, 0.959845f, 1.021687f, 0.679778f,
2.480488f, 2.675926f, 1.435063f, 2.337585f, 1.599884f, 2.094809f, 1.530535f, 1.290199f, 1.594530f, 1.941649f, 1.342452f, 1.571999f, 3.122639f, 3.632029f, 3.650020f, 2.566577f,
0.344638f, 0.422943f, 0.211095f, 0.423992f, 0.509371f, 0.758703f, 0.515904f, 0.536249f, 0.506656f, 0.701830f, 0.451605f, 0.652073f, 0.609120f, 0.805956f, 0.753799f, 0.653580f,
0.000004f, 0.000005f, 0.000008f, 0.000022f, 0.000003f, 0.000004f, 0.000009f, 0.000013f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000003f, 0.000011f, 0.000013f,
0.000003f, 0.000004f, 0.000008f, 0.000020f, 0.000002f, 0.000004f, 0.000010f, 0.000013f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000002f, 0.000009f, 0.000009f,
0.000022f, 0.000023f, 0.000046f, 0.000113f, 0.000011f, 0.000014f, 0.000038f, 0.000048f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000011f, 0.000012f, 0.000046f, 0.000049f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.441540f, 0.580346f, 0.242142f, 0.576465f, 0.392887f, 0.626763f, 0.356277f, 0.438944f, 0.287594f, 0.426675f, 0.229515f, 0.392801f, 0.643154f, 0.911428f, 0.712614f, 0.732353f,
0.289517f, 0.381084f, 0.197074f, 0.395705f, 0.277302f, 0.443015f, 0.312126f, 0.324331f, 0.370682f, 0.550742f, 0.367189f, 0.530015f, 0.342855f, 0.486571f, 0.471526f, 0.408705f,
1.929791f, 2.184471f, 1.066560f, 2.263273f, 1.215789f, 1.670371f, 1.111102f, 1.220176f, 1.191355f, 1.522222f, 0.958182f, 1.461696f, 2.146398f, 2.619611f, 2.396761f, 2.195528f,
0.175285f, 0.225716f, 0.102565f, 0.268371f, 0.253054f, 0.395503f, 0.244844f, 0.331544f, 0.247474f, 0.359707f, 0.210726f, 0.396378f, 0.273716f, 0.380021f, 0.323589f, 0.365504f,
0.019208f, 0.024062f, 0.010894f, 0.022668f, 0.014719f, 0.022378f, 0.013803f, 0.014864f, 0.014026f, 0.019833f, 0.011577f, 0.017316f, 0.037260f, 0.050324f, 0.042695f, 0.038350f,
0.016945f, 0.021258f, 0.011929f, 0.020935f, 0.013977f, 0.021281f, 0.016270f, 0.014776f, 0.024323f, 0.034443f, 0.024918f, 0.031436f, 0.026723f, 0.036145f, 0.038009f, 0.028794f,
0.137628f, 0.148482f, 0.078666f, 0.145900f, 0.074667f, 0.097772f, 0.070571f, 0.067735f, 0.095254f, 0.115998f, 0.079231f, 0.105638f, 0.203849f, 0.237119f, 0.235411f, 0.188478f,
0.013467f, 0.016528f, 0.008149f, 0.018637f, 0.016742f, 0.024939f, 0.016753f, 0.019827f, 0.021315f, 0.029529f, 0.018771f, 0.030860f, 0.028004f, 0.037056f, 0.034239f, 0.033802f,
0.439889f, 0.569215f, 0.299447f, 0.421534f, 0.359023f, 0.563863f, 0.404129f, 0.294408f, 0.314317f, 0.459095f, 0.311371f, 0.315099f, 0.669467f, 0.934012f, 0.920758f, 0.559527f,
0.185830f, 0.240811f, 0.157017f, 0.186422f, 0.163258f, 0.256777f, 0.228102f, 0.140151f, 0.261010f, 0.381786f, 0.320939f, 0.273924f, 0.229928f, 0.321250f, 0.392521f, 0.201176f,
1.378923f, 1.536710f, 0.946001f, 1.187005f, 0.796836f, 1.077804f, 0.903945f, 0.586975f, 0.933870f, 1.174734f, 0.932331f, 0.840985f, 1.602435f, 1.925409f, 2.221119f, 1.203082f,
0.196878f, 0.249591f, 0.142997f, 0.221244f, 0.260703f, 0.401141f, 0.313111f, 0.250703f, 0.304928f, 0.436346f, 0.322300f, 0.358478f, 0.321212f, 0.439051f, 0.471370f, 0.314825f,
0.000025f, 0.000032f, 0.000061f, 0.000131f, 0.000016f, 0.000024f, 0.000064f, 0.000070f, 0.000000f, 0.000001f, 0.000001f, 0.000002f, 0.000015f, 0.000020f, 0.000074f, 0.000068f,
0.000014f, 0.000018f, 0.000043f, 0.000077f, 0.000010f, 0.000015f, 0.000048f, 0.000044f, 0.000000f, 0.000001f, 0.000002f, 0.000002f, 0.000007f, 0.000009f, 0.000042f, 0.000033f,
0.000152f, 0.000164f, 0.000372f, 0.000706f, 0.000067f, 0.000089f, 0.000274f, 0.000269f, 0.000002f, 0.000003f, 0.000008f, 0.000011f, 0.000069f, 0.000081f, 0.000344f, 0.000281f,
0.000001f, 0.000001f, 0.000003f, 0.000006f, 0.000001f, 0.000002f, 0.000005f, 0.000006f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000004f, 0.000004f,
0.425449f, 0.577669f, 0.276672f, 0.507379f, 0.339174f, 0.558950f, 0.364721f, 0.346135f, 0.291949f, 0.447446f, 0.276285f, 0.364236f, 0.572068f, 0.837472f, 0.751632f, 0.595026f,
0.188132f, 0.255814f, 0.151858f, 0.234878f, 0.161443f, 0.266440f, 0.215484f, 0.172479f, 0.253771f, 0.389496f, 0.298090f, 0.331444f, 0.205662f, 0.301513f, 0.335404f, 0.223942f,
1.986234f, 2.322637f, 1.301736f, 2.127841f, 1.121130f, 1.591204f, 1.214981f, 1.027785f, 1.291850f, 1.705156f, 1.232074f, 1.447805f, 2.039324f, 2.571151f, 2.700340f, 1.905447f,
0.185394f, 0.246620f, 0.128638f, 0.259279f, 0.239795f, 0.387161f, 0.275128f, 0.286980f, 0.275760f, 0.414061f, 0.278443f, 0.403453f, 0.267243f, 0.383291f, 0.374643f, 0.325972f,
0.004930f, 0.005477f, 0.002425f, 0.006531f, 0.004481f, 0.006043f, 0.003645f, 0.005080f, 0.003602f, 0.004518f, 0.002579f, 0.004992f, 0.009529f, 0.011416f, 0.009473f, 0.011011f,
0.004830f, 0.005374f, 0.002950f, 0.006698f, 0.004725f, 0.006382f, 0.004772f, 0.005608f, 0.006937f, 0.008713f, 0.006165f, 0.010065f, 0.007590f, 0.009106f, 0.009365f, 0.009181f,
0.023858f, 0.022830f, 0.011830f, 0.028393f, 0.015354f, 0.017832f, 0.012589f, 0.015636f, 0.016524f, 0.017848f, 0.011923f, 0.020572f, 0.035215f, 0.036332f, 0.035279f, 0.036551f,
0.002212f, 0.002408f, 0.001161f, 0.003436f, 0.003262f, 0.004309f, 0.002831f, 0.004336f, 0.003503f, 0.004304f, 0.002676f, 0.005694f, 0.004583f, 0.005379f, 0.004861f, 0.006210f,
0.164161f, 0.188414f, 0.096944f, 0.176597f, 0.158929f, 0.221392f, 0.155193f, 0.146303f, 0.117379f, 0.152066f, 0.100872f, 0.132097f, 0.248967f, 0.308086f, 0.297050f, 0.233591f,
0.077016f, 0.088522f, 0.056453f, 0.086734f, 0.080259f, 0.111965f, 0.097279f, 0.077346f, 0.108247f, 0.140439f, 0.115466f, 0.127530f, 0.094960f, 0.117680f, 0.140633f, 0.093272f,
0.347589f, 0.343578f, 0.206866f, 0.335893f, 0.238258f, 0.285842f, 0.234473f, 0.197025f, 0.235562f, 0.262825f, 0.204015f, 0.238139f, 0.402523f, 0.428984f, 0.484009f, 0.339256f,
0.047018f, 0.052870f, 0.029626f, 0.059315f, 0.073853f, 0.100792f, 0.076947f, 0.079727f, 0.072872f, 0.092492f, 0.066818f, 0.096172f, 0.076444f, 0.092678f, 0.097317f, 0.084110f,
0.000000f, 0.000001f, 0.000001f, 0.000003f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f,
0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f,
0.000002f, 0.000002f, 0.000004f, 0.000010f, 0.000001f, 0.000001f, 0.000003f, 0.000004f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000004f, 0.000004f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.068159f, 0.082084f, 0.038451f, 0.091249f, 0.064454f, 0.094212f, 0.060126f, 0.073841f, 0.046803f, 0.063623f, 0.038423f, 0.065550f, 0.091328f, 0.118587f, 0.104096f, 0.106639f,
0.033472f, 0.040369f, 0.023438f, 0.046911f, 0.034071f, 0.049874f, 0.039450f, 0.040863f, 0.045180f, 0.061506f, 0.046039f, 0.066243f, 0.036463f, 0.047414f, 0.051587f, 0.044571f,
0.214933f, 0.222926f, 0.122199f, 0.258484f, 0.143906f, 0.181158f, 0.135290f, 0.148098f, 0.139887f, 0.163771f, 0.115737f, 0.175994f, 0.219909f, 0.245919f, 0.252607f, 0.230662f,
0.019007f, 0.022426f, 0.011441f, 0.029841f, 0.029162f, 0.041761f, 0.029025f, 0.039178f, 0.028291f, 0.037677f, 0.024781f, 0.046465f, 0.027303f, 0.034733f, 0.033204f, 0.037386f,
0.022710f, 0.028287f, 0.010148f, 0.033733f, 0.015326f, 0.023169f, 0.011325f, 0.019480f, 0.020172f, 0.028361f, 0.013118f, 0.031346f, 0.048390f, 0.064985f, 0.043689f, 0.062689f,
0.018143f, 0.022631f, 0.010063f, 0.028212f, 0.013179f, 0.019953f, 0.012088f, 0.017537f, 0.031678f, 0.044603f, 0.025570f, 0.051533f, 0.031429f, 0.042269f, 0.035222f, 0.042625f,
0.151193f, 0.162189f, 0.068091f, 0.201740f, 0.072241f, 0.094057f, 0.053798f, 0.082486f, 0.127289f, 0.154129f, 0.083422f, 0.177682f, 0.245993f, 0.284514f, 0.223831f, 0.286277f,
0.014170f, 0.017292f, 0.006756f, 0.024683f, 0.015515f, 0.022979f, 0.012232f, 0.023126f, 0.027283f, 0.037580f, 0.018930f, 0.049717f, 0.032368f, 0.042587f, 0.031181f, 0.049175f,
0.387044f, 0.497985f, 0.207595f, 0.466834f, 0.278207f, 0.434453f, 0.246743f, 0.287149f, 0.336411f, 0.488571f, 0.262579f, 0.424485f, 0.647045f, 0.897597f, 0.701182f, 0.680674f,
0.148070f, 0.190789f, 0.098578f, 0.186966f, 0.114566f, 0.179168f, 0.126122f, 0.123791f, 0.252986f, 0.367945f, 0.245098f, 0.334181f, 0.201249f, 0.279582f, 0.270698f, 0.221631f,
1.127349f, 1.249205f, 0.609382f, 1.221471f, 0.573742f, 0.771633f, 0.512824f, 0.531960f, 0.928732f, 1.161627f, 0.730556f, 1.052700f, 1.439090f, 1.719308f, 1.571660f, 1.359925f,
0.154169f, 0.194336f, 0.088228f, 0.218065f, 0.179794f, 0.275074f, 0.170140f, 0.217621f, 0.290458f, 0.413276f, 0.241895f, 0.429794f, 0.276300f, 0.375516f, 0.319471f, 0.340856f,
0.000007f, 0.000009f, 0.000013f, 0.000046f, 0.000004f, 0.000006f, 0.000012f, 0.000022f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000005f, 0.000006f, 0.000018f, 0.000026f,
0.000004f, 0.000004f, 0.000008f, 0.000024f, 0.000002f, 0.000003f, 0.000008f, 0.000012f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000003f, 0.000009f, 0.000011f,
0.000039f, 0.000042f, 0.000076f, 0.000229f, 0.000015f, 0.000020f, 0.000049f, 0.000077f, 0.000001f, 0.000001f, 0.000002f, 0.000004f, 0.000020f, 0.000023f, 0.000077f, 0.000100f,
0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f,
0.310022f, 0.418551f, 0.158851f, 0.465362f, 0.217669f, 0.356674f, 0.184423f, 0.279597f, 0.258785f, 0.394362f, 0.192961f, 0.406375f, 0.457913f, 0.666544f, 0.474045f, 0.599492f,
0.124150f, 0.167853f, 0.078958f, 0.195091f, 0.093828f, 0.153969f, 0.098675f, 0.126171f, 0.203709f, 0.310881f, 0.188536f, 0.334881f, 0.149082f, 0.217321f, 0.191566f, 0.204324f,
1.344863f, 1.563696f, 0.694464f, 1.813422f, 0.668547f, 0.943464f, 0.570855f, 0.771420f, 1.064009f, 1.396434f, 0.799557f, 1.500913f, 1.516780f, 1.901461f, 1.582466f, 1.783799f,
0.120233f, 0.159031f, 0.065732f, 0.211646f, 0.136962f, 0.219874f, 0.123815f, 0.206311f, 0.217544f, 0.324790f, 0.173074f, 0.400609f, 0.190382f, 0.271501f, 0.210289f, 0.292288f,
0.041624f, 0.050475f, 0.019908f, 0.053776f, 0.044059f, 0.064847f, 0.034845f, 0.048710f, 0.035672f, 0.048827f, 0.024828f, 0.048212f, 0.097631f, 0.127647f, 0.094344f, 0.110010f,
0.046012f, 0.055876f, 0.027315f, 0.062231f, 0.052425f, 0.077271f, 0.051463f, 0.060675f, 0.077511f, 0.106249f, 0.066963f, 0.109670f, 0.087740f, 0.114881f, 0.105239f, 0.103499f,
0.209913f, 0.219226f, 0.101181f, 0.243616f, 0.157318f, 0.199411f, 0.125389f, 0.156236f, 0.170505f, 0.200998f, 0.119600f, 0.207011f, 0.375953f, 0.423327f, 0.366129f, 0.380542f,
0.021525f, 0.025573f, 0.010985f, 0.032612f, 0.036966f, 0.053303f, 0.031193f, 0.047926f, 0.039985f, 0.053620f, 0.029694f, 0.063374f, 0.054124f, 0.069329f, 0.055805f, 0.071519f,
0.737929f, 0.924342f, 0.423617f, 0.774144f, 0.831970f, 1.264867f, 0.789747f, 0.746884f, 0.618818f, 0.874947f, 0.516956f, 0.679140f, 1.357974f, 1.834002f, 1.575035f, 1.242513f,
0.390616f, 0.490001f, 0.278333f, 0.428994f, 0.474050f, 0.721755f, 0.558547f, 0.445516f, 0.643896f, 0.911724f, 0.667670f, 0.739785f, 0.584410f, 0.790414f, 0.841340f, 0.559784f,
1.628124f, 1.756404f, 0.941936f, 1.534326f, 1.299664f, 1.701715f, 1.243329f, 1.048092f, 1.294067f, 1.575777f, 1.089489f, 1.275782f, 2.287805f, 2.661011f, 2.674192f, 1.880406f,
0.243606f, 0.298955f, 0.149211f, 0.299696f, 0.445605f, 0.663724f, 0.451321f, 0.469118f, 0.442803f, 0.613380f, 0.394690f, 0.569893f, 0.480588f, 0.635890f, 0.594739f, 0.515667f,
0.000025f, 0.000030f, 0.000051f, 0.000141f, 0.000022f, 0.000032f, 0.000073f, 0.000105f, 0.000000f, 0.000001f, 0.000001f, 0.000003f, 0.000018f, 0.000024f, 0.000075f, 0.000089f,
0.000017f, 0.000021f, 0.000045f, 0.000104f, 0.000016f, 0.000024f, 0.000069f, 0.000083f, 0.000001f, 0.000001f, 0.000002f, 0.000004f, 0.000010f, 0.000014f, 0.000053f, 0.000053f,
0.000105f, 0.000110f, 0.000217f, 0.000535f, 0.000064f, 0.000082f, 0.000221f, 0.000281f, 0.000002f, 0.000002f, 0.000006f, 0.000010f, 0.000058f, 0.000066f, 0.000243f, 0.000258f,
0.000001f, 0.000001f, 0.000002f, 0.000005f, 0.000001f, 0.000002f, 0.000004f, 0.000006f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000003f, 0.000003f,
0.537709f, 0.706748f, 0.294881f, 0.702023f, 0.592158f, 0.944654f, 0.536980f, 0.661574f, 0.433043f, 0.642464f, 0.345591f, 0.591458f, 0.874258f, 1.238931f, 0.968677f, 0.995509f,
0.297939f, 0.392169f, 0.202807f, 0.407216f, 0.353182f, 0.564239f, 0.397534f, 0.413079f, 0.471659f, 0.700769f, 0.467214f, 0.674395f, 0.393831f, 0.558916f, 0.541633f, 0.469471f,
1.766879f, 2.000059f, 0.976521f, 2.072208f, 1.377675f, 1.892787f, 1.259049f, 1.382647f, 1.348688f, 1.723250f, 1.084722f, 1.654730f, 2.193581f, 2.677196f, 2.449447f, 2.243791f,
0.172829f, 0.222553f, 0.101128f, 0.264610f, 0.308799f, 0.482627f, 0.298779f, 0.404579f, 0.301699f, 0.438523f, 0.256898f, 0.483229f, 0.301243f, 0.418239f, 0.356132f, 0.402262f,
0.027198f, 0.034071f, 0.015425f, 0.032096f, 0.025793f, 0.039216f, 0.024189f, 0.026047f, 0.024556f, 0.034722f, 0.020267f, 0.030316f, 0.058888f, 0.079536f, 0.067479f, 0.060611f,
0.020275f, 0.025435f, 0.014273f, 0.025048f, 0.020697f, 0.031514f, 0.024093f, 0.021881f, 0.035984f, 0.050955f, 0.036864f, 0.046507f, 0.035690f, 0.048274f, 0.050763f, 0.038456f,
0.146509f, 0.158064f, 0.083742f, 0.155315f, 0.098374f, 0.128815f, 0.092978f, 0.089242f, 0.125376f, 0.152680f, 0.104286f, 0.139044f, 0.242223f, 0.281756f, 0.279726f, 0.223958f,
0.015438f, 0.018947f, 0.009342f, 0.021365f, 0.023754f, 0.035383f, 0.023769f, 0.028131f, 0.030214f, 0.041855f, 0.026607f, 0.043742f, 0.035835f, 0.047418f, 0.043813f, 0.043253f,
0.474865f, 0.614474f, 0.323257f, 0.455051f, 0.479669f, 0.753344f, 0.539932f, 0.393341f, 0.419536f, 0.612778f, 0.415603f, 0.420580f, 0.806683f, 1.125451f, 1.109480f, 0.674209f,
0.169518f, 0.219674f, 0.143235f, 0.170059f, 0.184319f, 0.289901f, 0.257527f, 0.158230f, 0.294397f, 0.430622f, 0.361991f, 0.308962f, 0.234121f, 0.327109f, 0.399680f, 0.204845f,
1.119143f, 1.247204f, 0.767781f, 0.963381f, 0.800400f, 1.082625f, 0.907987f, 0.589600f, 0.937143f, 1.178851f, 0.935599f, 0.843933f, 1.451688f, 1.744278f, 2.012170f, 1.089903f,
0.172074f, 0.218147f, 0.124982f, 0.193371f, 0.282005f, 0.433919f, 0.338695f, 0.271188f, 0.329526f, 0.471546f, 0.348300f, 0.387396f, 0.313370f, 0.428333f, 0.459863f, 0.307139f,
0.000196f, 0.000247f, 0.000477f, 0.001016f, 0.000152f, 0.000232f, 0.000613f, 0.000675f, 0.000004f, 0.000005f, 0.000014f, 0.000021f, 0.000131f, 0.000178f, 0.000644f, 0.000592f,
0.000093f, 0.000117f, 0.000281f, 0.000504f, 0.000078f, 0.000119f, 0.000389f, 0.000361f, 0.000004f, 0.000005f, 0.000016f, 0.000020f, 0.000050f, 0.000069f, 0.000308f, 0.000239f,
0.000885f, 0.000959f, 0.002173f, 0.004121f, 0.000487f, 0.000640f, 0.001977f, 0.001940f, 0.000016f, 0.000020f, 0.000059f, 0.000080f, 0.000452f, 0.000527f, 0.002240f, 0.001834f,
0.000007f, 0.000008f, 0.000017f, 0.000041f, 0.000008f, 0.000013f, 0.000036f, 0.000044f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000005f, 0.000006f, 0.000025f, 0.000025f,
0.640649f, 0.869866f, 0.416618f, 0.764022f, 0.632103f, 1.041690f, 0.679715f, 0.645077f, 0.543569f, 0.833081f, 0.514404f, 0.678156f, 0.961542f, 1.407637f, 1.263356f, 1.000129f,
0.239393f, 0.325516f, 0.193235f, 0.298876f, 0.254250f, 0.419604f, 0.339355f, 0.271630f, 0.399267f, 0.612809f, 0.468996f, 0.521473f, 0.292112f, 0.428254f, 0.476390f, 0.318076f,
2.248652f, 2.629500f, 1.473720f, 2.408968f, 1.570869f, 2.229512f, 1.702369f, 1.440080f, 1.808331f, 2.386875f, 1.724657f, 2.026636f, 2.577063f, 3.249126f, 3.412380f, 2.407886f,
0.226027f, 0.300672f, 0.156832f, 0.316106f, 0.361825f, 0.584184f, 0.415137f, 0.433020f, 0.415691f, 0.624171f, 0.419735f, 0.608180f, 0.363679f, 0.521604f, 0.509835f, 0.443601f,
0.049872f, 0.055413f, 0.024538f, 0.066070f, 0.056101f, 0.075657f, 0.045643f, 0.063601f, 0.045059f, 0.056511f, 0.032262f, 0.062448f, 0.107606f, 0.128909f, 0.106967f, 0.124333f,
0.041288f, 0.045942f, 0.025215f, 0.057262f, 0.049995f, 0.067519f, 0.050487f, 0.059334f, 0.073327f, 0.092098f, 0.065167f, 0.106389f, 0.072426f, 0.086890f, 0.089365f, 0.087607f,
0.181463f, 0.173645f, 0.089979f, 0.215953f, 0.144530f, 0.167861f, 0.118503f, 0.147186f, 0.155393f, 0.167844f, 0.112128f, 0.193460f, 0.298966f, 0.308452f, 0.299511f, 0.310310f,
0.018116f, 0.019721f, 0.009510f, 0.028145f, 0.033064f, 0.043685f, 0.028702f, 0.043957f, 0.035478f, 0.043593f, 0.027103f, 0.057662f, 0.041904f, 0.049181f, 0.044445f, 0.056779f,
1.266162f, 1.453215f, 0.747718f, 1.362077f, 1.517095f, 2.113355f, 1.481436f, 1.396571f, 1.119390f, 1.450184f, 0.961972f, 1.259746f, 2.143413f, 2.652389f, 2.557375f, 2.011039f,
0.501966f, 0.576958f, 0.367942f, 0.565302f, 0.647410f, 0.903167f, 0.784702f, 0.623912f, 0.872337f, 1.131761f, 0.930509f, 1.027731f, 0.690847f, 0.856135f, 1.023118f, 0.678563f,
2.015591f, 1.992334f, 1.199571f, 1.947770f, 1.709922f, 2.051422f, 1.682756f, 1.414000f, 1.688946f, 1.884415f, 1.462755f, 1.707420f, 2.605397f, 2.776670f, 3.132833f, 2.195894f,
0.293614f, 0.330155f, 0.185003f, 0.370404f, 0.570782f, 0.778987f, 0.594696f, 0.616179f, 0.562657f, 0.714144f, 0.515917f, 0.742561f, 0.532847f, 0.646002f, 0.678337f, 0.586278f,
0.000025f, 0.000028f, 0.000053f, 0.000147f, 0.000023f, 0.000032f, 0.000081f, 0.000116f, 0.000000f, 0.000001f, 0.000002f, 0.000003f, 0.000017f, 0.000020f, 0.000072f, 0.000085f,
0.000013f, 0.000015f, 0.000035f, 0.000081f, 0.000013f, 0.000018f, 0.000057f, 0.000069f, 0.000001f, 0.000001f, 0.000002f, 0.000003f, 0.000007f, 0.000009f, 0.000038f, 0.000038f,
0.000077f, 0.000074f, 0.000164f, 0.000403f, 0.000050f, 0.000059f, 0.000177f, 0.000225f, 0.000001f, 0.000002f, 0.000004f, 0.000008f, 0.000039f, 0.000041f, 0.000169f, 0.000179f,
0.000001f, 0.000001f, 0.000001f, 0.000004f, 0.000001f, 0.000001f, 0.000003f, 0.000005f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000002f,
0.733306f, 0.883131f, 0.413690f, 0.981734f, 0.858233f, 1.254481f, 0.800601f, 0.983222f, 0.622605f, 0.846357f, 0.511134f, 0.871988f, 1.096774f, 1.424123f, 1.250105f, 1.280642f,
0.304309f, 0.367015f, 0.213089f, 0.426498f, 0.383369f, 0.561182f, 0.443898f, 0.459787f, 0.507879f, 0.691400f, 0.517532f, 0.744649f, 0.370031f, 0.481168f, 0.523507f, 0.452316f,
1.738541f, 1.803199f, 0.988438f, 2.090819f, 1.440640f, 1.813564f, 1.354381f, 1.482602f, 1.399051f, 1.637923f, 1.157525f, 1.760169f, 1.985508f, 2.220348f, 2.280741f, 2.082598f,
0.165565f, 0.195348f, 0.099658f, 0.259934f, 0.314382f, 0.450212f, 0.312913f, 0.422368f, 0.304699f, 0.405800f, 0.266899f, 0.500443f, 0.265466f, 0.337707f, 0.322844f, 0.363502f,
0.039616f, 0.049345f, 0.017703f, 0.058845f, 0.033087f, 0.050021f, 0.024449f, 0.042057f, 0.043509f, 0.061172f, 0.028294f, 0.067610f, 0.094222f, 0.126536f, 0.085070f, 0.122065f,
0.026744f, 0.033361f, 0.014835f, 0.041588f, 0.024044f, 0.036402f, 0.022053f, 0.031995f, 0.057739f, 0.081296f, 0.046605f, 0.093926f, 0.051714f, 0.069550f, 0.057955f, 0.070136f,
0.198291f, 0.212713f, 0.089302f, 0.264585f, 0.117260f, 0.152671f, 0.087323f, 0.133890f, 0.206414f, 0.249937f, 0.135278f, 0.288130f, 0.360116f, 0.416508f, 0.327673f, 0.419089f,
0.020013f, 0.024423f, 0.009542f, 0.034861f, 0.027120f, 0.040167f, 0.021382f, 0.040425f, 0.047644f, 0.065627f, 0.033058f, 0.086820f, 0.051028f, 0.067139f, 0.049157f, 0.077524f,
0.514755f, 0.662304f, 0.276094f, 0.620873f, 0.457932f, 0.715115f, 0.406142f, 0.472651f, 0.553204f, 0.803420f, 0.431791f, 0.698034f, 0.960556f, 1.332506f, 1.040923f, 1.010477f,
0.166412f, 0.214422f, 0.110789f, 0.210126f, 0.159355f, 0.249212f, 0.175427f, 0.172186f, 0.351549f, 0.511295f, 0.340588f, 0.464377f, 0.252462f, 0.350729f, 0.339584f, 0.278031f,
1.127243f, 1.249088f, 0.609325f, 1.221357f, 0.710016f, 0.954909f, 0.634629f, 0.658310f, 1.148216f, 1.436150f, 0.903206f, 1.301481f, 1.606180f, 1.918934f, 1.754143f, 1.517823f,
0.166008f, 0.209260f, 0.095004f, 0.234811f, 0.239607f, 0.366585f, 0.226742f, 0.290019f, 0.386714f, 0.550233f, 0.322057f, 0.572225f, 0.332094f, 0.451344f, 0.383982f, 0.409686f,
0.000067f, 0.000084f, 0.000129f, 0.000437f, 0.000046f, 0.000070f, 0.000146f, 0.000256f, 0.000002f, 0.000002f, 0.000004f, 0.000011f, 0.000049f, 0.000066f, 0.000191f, 0.000280f,
0.000029f, 0.000036f, 0.000069f, 0.000197f, 0.000021f, 0.000032f, 0.000084f, 0.000124f, 0.000001f, 0.000002f, 0.000005f, 0.000010f, 0.000017f, 0.000023f, 0.000083f, 0.000102f,
0.000281f, 0.000303f, 0.000544f, 0.001649f, 0.000136f, 0.000178f, 0.000436f, 0.000684f, 0.000006f, 0.000008f, 0.000018f, 0.000039f, 0.000158f, 0.000183f, 0.000616f, 0.000806f,
0.000002f, 0.000003f, 0.000004f, 0.000016f, 0.000002f, 0.000003f, 0.000008f, 0.000015f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000002f, 0.000007f, 0.000011f,
0.575148f, 0.776489f, 0.294698f, 0.863332f, 0.499777f, 0.818937f, 0.423443f, 0.641966f, 0.593608f, 0.904599f, 0.442618f, 0.932153f, 0.948237f, 1.380266f, 0.981644f, 1.241415f,
0.194629f, 0.263143f, 0.123783f, 0.305843f, 0.182048f, 0.298736f, 0.191451f, 0.244802f, 0.394861f, 0.602601f, 0.365451f, 0.649121f, 0.260877f, 0.380285f, 0.335218f, 0.357543f,
1.875786f, 2.181010f, 0.968625f, 2.529324f, 1.154064f, 1.628633f, 0.985424f, 1.331646f, 1.834951f, 2.408240f, 1.378887f, 2.588420f, 2.361430f, 2.960329f, 2.463695f, 2.777144f,
0.180594f, 0.238869f, 0.098732f, 0.317899f, 0.254607f, 0.408738f, 0.230167f, 0.383524f, 0.404017f, 0.603192f, 0.321428f, 0.744000f, 0.319191f, 0.455194f, 0.352567f, 0.490046f,
0.000585f, 0.000709f, 0.000280f, 0.000755f, 0.000573f, 0.000844f, 0.000453f, 0.000634f, 0.000446f, 0.000611f, 0.000311f, 0.000603f, 0.002206f, 0.002884f, 0.002131f, 0.002485f,
0.000790f, 0.000959f, 0.000469f, 0.001068f, 0.000834f, 0.001229f, 0.000818f, 0.000965f, 0.001186f, 0.001625f, 0.001024f, 0.001678f, 0.002423f, 0.003172f, 0.002906f, 0.002858f,
0.003562f, 0.003720f, 0.001717f, 0.004133f, 0.002473f, 0.003135f, 0.001971f, 0.002456f, 0.002578f, 0.003039f, 0.001808f, 0.003130f, 0.010262f, 0.011555f, 0.009993f, 0.010387f,
0.000437f, 0.000519f, 0.000223f, 0.000662f, 0.000695f, 0.001003f, 0.000587f, 0.000902f, 0.000724f, 0.000970f, 0.000537f, 0.001147f, 0.001768f, 0.002265f, 0.001823f, 0.002336f,
0.016567f, 0.020752f, 0.009510f, 0.017380f, 0.017304f, 0.026308f, 0.016426f, 0.015535f, 0.012381f, 0.017506f, 0.010343f, 0.013588f, 0.049044f, 0.066236f, 0.056883f, 0.044874f,
0.010718f, 0.013445f, 0.007637f, 0.011771f, 0.012051f, 0.018348f, 0.014199f, 0.011326f, 0.015746f, 0.022295f, 0.016327f, 0.018091f, 0.025797f, 0.034890f, 0.037138f, 0.024710f,
0.044160f, 0.047639f, 0.025548f, 0.041616f, 0.032658f, 0.042761f, 0.031243f, 0.026337f, 0.031280f, 0.038090f, 0.026335f, 0.030838f, 0.099823f, 0.116107f, 0.116682f, 0.082047f,
0.007908f, 0.009704f, 0.004843f, 0.009728f, 0.013401f, 0.019960f, 0.013573f, 0.014108f, 0.012810f, 0.017744f, 0.011418f, 0.016486f, 0.025096f, 0.033205f, 0.031057f, 0.026928f,
0.000002f, 0.000003f, 0.000005f, 0.000012f, 0.000002f, 0.000003f, 0.000006f, 0.000009f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000003f, 0.000003f, 0.000011f, 0.000013f,
0.000002f, 0.000002f, 0.000005f, 0.000011f, 0.000002f, 0.000002f, 0.000007f, 0.000008f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000002f, 0.000009f, 0.000009f,
0.000011f, 0.000012f, 0.000023f, 0.000057f, 0.000006f, 0.000008f, 0.000022f, 0.000028f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000010f, 0.000011f, 0.000042f, 0.000044f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f,
0.009855f, 0.012953f, 0.005404f, 0.012866f, 0.010055f, 0.016040f, 0.009118f, 0.011233f, 0.007073f, 0.010494f, 0.005645f, 0.009661f, 0.025776f, 0.036528f, 0.028560f, 0.029351f,
0.006674f, 0.008785f, 0.004543f, 0.009122f, 0.007330f, 0.011710f, 0.008250f, 0.008573f, 0.009416f, 0.013990f, 0.009327f, 0.013463f, 0.014192f, 0.020141f, 0.019518f, 0.016918f,
0.039123f, 0.044286f, 0.021623f, 0.045884f, 0.028262f, 0.038829f, 0.025828f, 0.028364f, 0.026614f, 0.034005f, 0.021405f, 0.032653f, 0.078136f, 0.095363f, 0.087250f, 0.079924f,
0.004580f, 0.005898f, 0.002680f, 0.007012f, 0.007581f, 0.011849f, 0.007335f, 0.009933f, 0.007125f, 0.010356f, 0.006067f, 0.011412f, 0.012842f, 0.017829f, 0.015182f, 0.017148f,
0.000367f, 0.000459f, 0.000208f, 0.000433f, 0.000322f, 0.000490f, 0.000302f, 0.000325f, 0.000295f, 0.000417f, 0.000244f, 0.000364f, 0.001277f, 0.001725f, 0.001464f, 0.001315f,
0.000334f, 0.000419f, 0.000235f, 0.000413f, 0.000316f, 0.000481f, 0.000368f, 0.000334f, 0.000528f, 0.000748f, 0.000541f, 0.000683f, 0.000946f, 0.001280f, 0.001346f, 0.001019f,
0.002387f, 0.002575f, 0.001364f, 0.002530f, 0.001485f, 0.001944f, 0.001403f, 0.001347f, 0.001820f, 0.002216f, 0.001514f, 0.002018f, 0.006347f, 0.007383f, 0.007330f, 0.005869f,
0.000301f, 0.000369f, 0.000182f, 0.000417f, 0.000429f, 0.000639f, 0.000429f, 0.000508f, 0.000525f, 0.000727f, 0.000462f, 0.000760f, 0.001124f, 0.001487f, 0.001374f, 0.001356f,
0.010235f, 0.013244f, 0.006967f, 0.009808f, 0.009578f, 0.015043f, 0.010781f, 0.007854f, 0.008058f, 0.011770f, 0.007983f, 0.008079f, 0.027970f, 0.039022f, 0.038468f, 0.023376f,
0.004466f, 0.005787f, 0.003773f, 0.004480f, 0.004498f, 0.007075f, 0.006285f, 0.003862f, 0.006911f, 0.010110f, 0.008498f, 0.007253f, 0.009921f, 0.013862f, 0.016937f, 0.008681f,
0.029142f, 0.032476f, 0.019993f, 0.025086f, 0.019309f, 0.026118f, 0.021905f, 0.014224f, 0.021747f, 0.027357f, 0.021712f, 0.019584f, 0.060810f, 0.073066f, 0.084288f, 0.045655f,
0.005362f, 0.006798f, 0.003895f, 0.006026f, 0.008142f, 0.012528f, 0.009779f, 0.007830f, 0.009152f, 0.013096f, 0.009673f, 0.010759f, 0.015710f, 0.021473f, 0.023054f, 0.015398f,
0.000017f, 0.000021f, 0.000041f, 0.000086f, 0.000012f, 0.000018f, 0.000048f, 0.000053f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000018f, 0.000024f, 0.000088f, 0.000081f,
0.000010f, 0.000012f, 0.000029f, 0.000052f, 0.000007f, 0.000011f, 0.000037f, 0.000035f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000008f, 0.000011f, 0.000052f, 0.000040f,
0.000091f, 0.000098f, 0.000223f, 0.000423f, 0.000046f, 0.000061f, 0.000188f, 0.000184f, 0.000001f, 0.000002f, 0.000005f, 0.000007f, 0.000075f, 0.000087f, 0.000370f, 0.000303f,
0.000001f, 0.000001f, 0.000002f, 0.000005f, 0.000001f, 0.000001f, 0.000004f, 0.000005f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000005f, 0.000005f,
0.011272f, 0.015306f, 0.007331f, 0.013443f, 0.010304f, 0.016981f, 0.011080f, 0.010516f, 0.008524f, 0.013063f, 0.008066f, 0.010634f, 0.027217f, 0.039844f, 0.035760f, 0.028309f,
0.005148f, 0.007000f, 0.004156f, 0.006427f, 0.005066f, 0.008360f, 0.006761f, 0.005412f, 0.007652f, 0.011745f, 0.008989f, 0.009994f, 0.010106f, 0.014816f, 0.016481f, 0.011004f,
0.047801f, 0.055897f, 0.031328f, 0.051209f, 0.030937f, 0.043909f, 0.033527f, 0.028361f, 0.034258f, 0.045219f, 0.032673f, 0.038394f, 0.088128f, 0.111110f, 0.116693f, 0.082342f,
0.005750f, 0.007649f, 0.003990f, 0.008042f, 0.008528f, 0.013769f, 0.009785f, 0.010206f, 0.009425f, 0.014152f, 0.009517f, 0.013789f, 0.014884f, 0.021347f, 0.020866f, 0.018155f,
0.000472f, 0.000525f, 0.000232f, 0.000625f, 0.000492f, 0.000664f, 0.000400f, 0.000558f, 0.000380f, 0.000477f, 0.000272f, 0.000527f, 0.001639f, 0.001963f, 0.001629f, 0.001893f,
0.000478f, 0.000532f, 0.000292f, 0.000663f, 0.000536f, 0.000724f, 0.000541f, 0.000636f, 0.000756f, 0.000950f, 0.000672f, 0.001097f, 0.001348f, 0.001617f, 0.001663f, 0.001631f,
0.002075f, 0.001986f, 0.001029f, 0.002470f, 0.001531f, 0.001779f, 0.001256f, 0.001560f, 0.001584f, 0.001711f, 0.001143f, 0.001972f, 0.005500f, 0.005675f, 0.005510f, 0.005709f,
0.000248f, 0.000270f, 0.000130f, 0.000385f, 0.000419f, 0.000554f, 0.000364f, 0.000557f, 0.000433f, 0.000532f, 0.000331f, 0.000703f, 0.000923f, 0.001083f, 0.000979f, 0.001250f,
0.019160f, 0.021991f, 0.011315f, 0.020612f, 0.021269f, 0.029628f, 0.020769f, 0.019579f, 0.015096f, 0.019557f, 0.012973f, 0.016989f, 0.052178f, 0.064568f, 0.062256f, 0.048956f,
0.009284f, 0.010671f, 0.006805f, 0.010455f, 0.011093f, 0.015476f, 0.013446f, 0.010691f, 0.014379f, 0.018655f, 0.015338f, 0.016940f, 0.020555f, 0.025473f, 0.030441f, 0.020189f,
0.036850f, 0.036424f, 0.021931f, 0.035610f, 0.028962f, 0.034746f, 0.028502f, 0.023950f, 0.027518f, 0.030703f, 0.023833f, 0.027819f, 0.076626f, 0.081663f, 0.092138f, 0.064582f,
0.006424f, 0.007224f, 0.004048f, 0.008104f, 0.011570f, 0.015791f, 0.012055f, 0.012490f, 0.010971f, 0.013925f, 0.010060f, 0.014479f, 0.018755f, 0.022738f, 0.023876f, 0.020636f,
0.000002f, 0.000002f, 0.000003f, 0.000009f, 0.000001f, 0.000002f, 0.000004f, 0.000006f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000002f, 0.000007f, 0.000008f,
0.000001f, 0.000001f, 0.000003f, 0.000006f, 0.000001f, 0.000001f, 0.000004f, 0.000005f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000004f, 0.000004f,
0.000006f, 0.000005f, 0.000012f, 0.000029f, 0.000003f, 0.000004f, 0.000012f, 0.000015f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000005f, 0.000005f, 0.000020f, 0.000021f,
0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.009059f, 0.010910f, 0.005111f, 0.012128f, 0.009823f, 0.014358f, 0.009163f, 0.011253f, 0.006855f, 0.009318f, 0.005627f, 0.009600f, 0.021796f, 0.028302f, 0.024844f, 0.025451f,
0.004595f, 0.005542f, 0.003217f, 0.006440f, 0.005363f, 0.007850f, 0.006210f, 0.006432f, 0.006834f, 0.009304f, 0.006964f, 0.010020f, 0.008988f, 0.011687f, 0.012716f, 0.010987f,
0.025948f, 0.026913f, 0.014753f, 0.031206f, 0.019920f, 0.025077f, 0.018728f, 0.020501f, 0.018609f, 0.021786f, 0.015396f, 0.023412f, 0.047672f, 0.053310f, 0.054760f, 0.050003f,
0.002957f, 0.003489f, 0.001780f, 0.004643f, 0.005203f, 0.007450f, 0.005178f, 0.006990f, 0.004850f, 0.006460f, 0.004249f, 0.007966f, 0.007628f, 0.009704f, 0.009277f, 0.010445f,
0.000348f, 0.000434f, 0.000156f, 0.000517f, 0.000270f, 0.000408f, 0.000199f, 0.000343f, 0.000341f, 0.000479f, 0.000222f, 0.000530f, 0.001333f, 0.001790f, 0.001203f, 0.001727f,
0.000287f, 0.000359f, 0.000159f, 0.000447f, 0.000239f, 0.000362f, 0.000220f, 0.000319f, 0.000553f, 0.000779f, 0.000446f, 0.000900f, 0.000894f, 0.001203f, 0.001002f, 0.001213f,
0.002107f, 0.002260f, 0.000949f, 0.002811f, 0.001154f, 0.001503f, 0.000859f, 0.001318f, 0.001954f, 0.002366f, 0.001281f, 0.002728f, 0.006155f, 0.007118f, 0.005600f, 0.007163f,
0.000254f, 0.000311f, 0.000121f, 0.000443f, 0.000319f, 0.000473f, 0.000252f, 0.000476f, 0.000540f, 0.000744f, 0.000375f, 0.000984f, 0.001044f, 0.001373f, 0.001005f, 0.001586f,
0.007236f, 0.009310f, 0.003881f, 0.008728f, 0.005964f, 0.009313f, 0.005289f, 0.006156f, 0.006931f, 0.010065f, 0.005409f, 0.008745f, 0.021722f, 0.030133f, 0.023539f, 0.022851f,
0.002859f, 0.003684f, 0.001904f, 0.003610f, 0.002537f, 0.003967f, 0.002792f, 0.002741f, 0.005383f, 0.007829f, 0.005215f, 0.007111f, 0.006978f, 0.009694f, 0.009386f, 0.007685f,
0.019144f, 0.021214f, 0.010348f, 0.020743f, 0.011172f, 0.015025f, 0.009986f, 0.010358f, 0.017379f, 0.021737f, 0.013671f, 0.019699f, 0.043882f, 0.052427f, 0.047925f, 0.041468f,
0.003374f, 0.004253f, 0.001931f, 0.004773f, 0.004512f, 0.006903f, 0.004270f, 0.005461f, 0.007005f, 0.009967f, 0.005834f, 0.010365f, 0.010859f, 0.014758f, 0.012555f, 0.013396f,
0.000004f, 0.000005f, 0.000007f, 0.000024f, 0.000002f, 0.000004f, 0.000007f, 0.000013f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000004f, 0.000006f, 0.000017f, 0.000025f,
0.000002f, 0.000002f, 0.000005f, 0.000013f, 0.000001f, 0.000002f, 0.000005f, 0.000008f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000003f, 0.000009f, 0.000011f,
0.000019f, 0.000020f, 0.000036f, 0.000110f, 0.000008f, 0.000011f, 0.000027f, 0.000042f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000017f, 0.000020f, 0.000066f, 0.000087f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f,
0.006600f, 0.008911f, 0.003382f, 0.009908f, 0.005314f, 0.008707f, 0.004502f, 0.006825f, 0.006071f, 0.009252f, 0.004527f, 0.009533f, 0.017506f, 0.025482f, 0.018122f, 0.022918f,
0.002730f, 0.003691f, 0.001736f, 0.004290f, 0.002366f, 0.003882f, 0.002488f, 0.003181f, 0.004936f, 0.007533f, 0.004568f, 0.008114f, 0.005886f, 0.008581f, 0.007564f, 0.008068f,
0.026007f, 0.030239f, 0.013430f, 0.035068f, 0.014824f, 0.020920f, 0.012658f, 0.017105f, 0.022673f, 0.029757f, 0.017038f, 0.031983f, 0.052669f, 0.066027f, 0.054950f, 0.061941f,
0.002997f, 0.003964f, 0.001638f, 0.005275f, 0.003914f, 0.006283f, 0.003538f, 0.005896f, 0.005974f, 0.008920f, 0.004753f, 0.011002f, 0.008520f, 0.012151f, 0.009411f, 0.013081f,
0.048876f, 0.059269f, 0.023377f, 0.063145f, 0.038519f, 0.056692f, 0.030464f, 0.042585f, 0.032304f, 0.044217f, 0.022484f, 0.043660f, 0.111628f, 0.145947f, 0.107869f, 0.125782f,
0.079289f, 0.096289f, 0.047071f, 0.107239f, 0.067262f, 0.099141f, 0.066029f, 0.077848f, 0.103012f, 0.141205f, 0.088994f, 0.145752f, 0.147225f, 0.192767f, 0.176588f, 0.173668f,
0.295126f, 0.308219f, 0.142255f, 0.342511f, 0.164678f, 0.208740f, 0.131255f, 0.163546f, 0.184877f, 0.217940f, 0.129681f, 0.224460f, 0.514680f, 0.579535f, 0.501230f, 0.520962f,
0.026937f, 0.032002f, 0.013746f, 0.040811f, 0.034443f, 0.049665f, 0.029064f, 0.044654f, 0.038590f, 0.051750f, 0.028658f, 0.061164f, 0.065953f, 0.084481f, 0.068001f, 0.087150f,
0.828230f, 1.037454f, 0.475456f, 0.868877f, 0.695237f, 1.056988f, 0.659953f, 0.624135f, 0.535644f, 0.757347f, 0.447474f, 0.587859f, 1.484100f, 2.004341f, 1.721321f, 1.357916f,
0.643406f, 0.807109f, 0.458458f, 0.706620f, 0.581365f, 0.885145f, 0.684990f, 0.546371f, 0.817952f, 1.158179f, 0.848154f, 0.939762f, 0.937321f, 1.267726f, 1.349405f, 0.897824f,
2.187975f, 2.360366f, 1.265832f, 2.061925f, 1.300394f, 1.702671f, 1.244027f, 1.048680f, 1.341185f, 1.633153f, 1.129158f, 1.322235f, 2.993709f, 3.482067f, 3.499315f, 2.460606f,
0.291395f, 0.357602f, 0.178482f, 0.358488f, 0.396857f, 0.591113f, 0.401946f, 0.417797f, 0.408490f, 0.565850f, 0.364106f, 0.525733f, 0.559761f, 0.740648f, 0.692717f, 0.600619f,
0.000058f, 0.000070f, 0.000119f, 0.000328f, 0.000037f, 0.000055f, 0.000127f, 0.000181f, 0.000001f, 0.000001f, 0.000002f, 0.000005f, 0.000041f, 0.000054f, 0.000169f, 0.000202f,
0.000060f, 0.000073f, 0.000152f, 0.000355f, 0.000042f, 0.000061f, 0.000175f, 0.000211f, 0.000002f, 0.000002f, 0.000006f, 0.000010f, 0.000034f, 0.000045f, 0.000176f, 0.000177f,
0.000293f, 0.000307f, 0.000606f, 0.001493f, 0.000134f, 0.000170f, 0.000458f, 0.000584f, 0.000004f, 0.000005f, 0.000012f, 0.000021f, 0.000158f, 0.000178f, 0.000659f, 0.000701f,
0.000002f, 0.000002f, 0.000004f, 0.000013f, 0.000002f, 0.000003f, 0.000007f, 0.000011f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000006f, 0.000008f,
0.582809f, 0.766025f, 0.319614f, 0.760904f, 0.477865f, 0.762326f, 0.433337f, 0.533883f, 0.361982f, 0.537037f, 0.288881f, 0.494401f, 0.922686f, 1.307559f, 1.022335f, 1.050653f,
0.473920f, 0.623808f, 0.322597f, 0.647742f, 0.418278f, 0.668235f, 0.470805f, 0.489215f, 0.578606f, 0.859666f, 0.573153f, 0.827312f, 0.609991f, 0.865684f, 0.838915f, 0.727147f,
2.293001f, 2.595614f, 1.267299f, 2.689247f, 1.331169f, 1.828891f, 1.216547f, 1.335972f, 1.349851f, 1.724737f, 1.085657f, 1.656158f, 2.771957f, 3.383086f, 3.095287f, 2.835406f,
0.199642f, 0.257081f, 0.116817f, 0.305663f, 0.265583f, 0.415085f, 0.256966f, 0.347959f, 0.268774f, 0.390666f, 0.228862f, 0.430494f, 0.338836f, 0.470432f, 0.400574f, 0.452461f,
0.046959f, 0.058826f, 0.026633f, 0.055417f, 0.033157f, 0.050413f, 0.031096f, 0.033484f, 0.032698f, 0.046235f, 0.026987f, 0.040368f, 0.099004f, 0.133718f, 0.113448f, 0.101901f,
0.051375f, 0.064451f, 0.036167f, 0.063470f, 0.039047f, 0.059454f, 0.045453f, 0.041280f, 0.070319f, 0.099575f, 0.072038f, 0.090883f, 0.088059f, 0.119107f, 0.125248f, 0.094884f,
0.302882f, 0.326769f, 0.173122f, 0.321087f, 0.151418f, 0.198273f, 0.143113f, 0.137361f, 0.199894f, 0.243427f, 0.166269f, 0.221686f, 0.487595f, 0.567175f, 0.563090f, 0.450827f,
0.028408f, 0.034865f, 0.017191f, 0.039315f, 0.032544f, 0.048477f, 0.032565f, 0.038541f, 0.042877f, 0.059398f, 0.037759f, 0.062077f, 0.064208f, 0.084962f, 0.078503f, 0.077500f,
0.783695f, 1.014099f, 0.533488f, 0.750995f, 0.589396f, 0.925676f, 0.663446f, 0.483320f, 0.533978f, 0.779933f, 0.528972f, 0.535306f, 1.296330f, 1.808585f, 1.782921f, 1.083446f,
0.410575f, 0.532053f, 0.346917f, 0.411885f, 0.332380f, 0.522775f, 0.464395f, 0.285335f, 0.549904f, 0.804358f, 0.676163f, 0.577110f, 0.552143f, 0.771443f, 0.942592f, 0.483100f,
2.211472f, 2.464526f, 1.517166f, 1.903680f, 1.177583f, 1.592805f, 1.335871f, 0.867445f, 1.428166f, 1.796519f, 1.425813f, 1.286117f, 2.793216f, 3.356193f, 3.871648f, 2.097100f,
0.302657f, 0.383693f, 0.219827f, 0.340115f, 0.369301f, 0.568241f, 0.443540f, 0.355136f, 0.446994f, 0.639640f, 0.472460f, 0.525493f, 0.536695f, 0.733587f, 0.787587f, 0.526025f,
0.000672f, 0.000845f, 0.001636f, 0.003480f, 0.000388f, 0.000593f, 0.001565f, 0.001723f, 0.000010f, 0.000014f, 0.000036f, 0.000055f, 0.000437f, 0.000592f, 0.002150f, 0.001974f,
0.000467f, 0.000589f, 0.001413f, 0.002536f, 0.000291f, 0.000445f, 0.001455f, 0.001351f, 0.000014f, 0.000020f, 0.000061f, 0.000079f, 0.000247f, 0.000336f, 0.001510f, 0.001170f,
0.003631f, 0.003933f, 0.008914f, 0.016905f, 0.001487f, 0.001955f, 0.006037f, 0.005925f, 0.000052f, 0.000063f, 0.000185f, 0.000253f, 0.001804f, 0.002106f, 0.008946f, 0.007324f,
0.000025f, 0.000030f, 0.000064f, 0.000149f, 0.000023f, 0.000034f, 0.000099f, 0.000120f, 0.000001f, 0.000001f, 0.000003f, 0.000005f, 0.000017f, 0.000023f, 0.000090f, 0.000091f,
1.021033f, 1.386346f, 0.663984f, 1.217659f, 0.750060f, 1.236081f, 0.806557f, 0.765455f, 0.668115f, 1.023962f, 0.632268f, 0.833539f, 1.492187f, 2.184467f, 1.960562f, 1.552069f,
0.559925f, 0.761361f, 0.451963f, 0.699052f, 0.442759f, 0.730714f, 0.590965f, 0.473026f, 0.720209f, 1.105403f, 0.845988f, 0.940648f, 0.665279f, 0.975338f, 1.084968f, 0.724411f,
4.291018f, 5.017776f, 2.812244f, 4.596942f, 2.231860f, 3.167647f, 2.418692f, 2.046037f, 2.661295f, 3.512731f, 2.538153f, 2.982572f, 4.788490f, 6.037263f, 6.340607f, 4.474138f,
0.383918f, 0.510705f, 0.266385f, 0.536921f, 0.457578f, 0.738781f, 0.524998f, 0.547614f, 0.544534f, 0.817632f, 0.549831f, 0.796684f, 0.601493f, 0.862688f, 0.843224f, 0.733677f,
0.062173f, 0.069081f, 0.030590f, 0.082367f, 0.052073f, 0.070224f, 0.042365f, 0.059033f, 0.043321f, 0.054332f, 0.031018f, 0.060040f, 0.130622f, 0.156482f, 0.129847f, 0.150927f,
0.075539f, 0.084053f, 0.046132f, 0.104764f, 0.068102f, 0.091973f, 0.068772f, 0.080824f, 0.103463f, 0.129949f, 0.091950f, 0.150113f, 0.129025f, 0.154793f, 0.159201f, 0.156070f,
0.270865f, 0.259196f, 0.134308f, 0.322348f, 0.160624f, 0.186554f, 0.131699f, 0.163576f, 0.178885f, 0.193218f, 0.129079f, 0.222707f, 0.434533f, 0.448320f, 0.435324f, 0.451021f,
0.024070f, 0.026201f, 0.012636f, 0.037394f, 0.032707f, 0.043214f, 0.028392f, 0.043483f, 0.036353f, 0.044668f, 0.027772f, 0.059084f, 0.054212f, 0.063627f, 0.057499f, 0.073457f,
1.508767f, 1.731662f, 0.890987f, 1.623061f, 1.345969f, 1.874971f, 1.314331f, 1.239040f, 1.028707f, 1.332703f, 0.884042f, 1.157693f, 2.486993f, 3.077555f, 2.967311f, 2.333399f,
0.877823f, 1.008965f, 0.643444f, 0.988582f, 0.842948f, 1.175951f, 1.021706f, 0.812352f, 1.176504f, 1.526385f, 1.254960f, 1.386081f, 1.176385f, 1.457839f, 1.742182f, 1.155467f,
2.875770f, 2.842588f, 1.711504f, 2.779006f, 1.816423f, 2.179193f, 1.787565f, 1.502070f, 1.858423f, 2.073507f, 1.609535f, 1.878751f, 3.619605f, 3.857550f, 4.352357f, 3.050694f,
0.372879f, 0.419284f, 0.234948f, 0.470399f, 0.539697f, 0.736563f, 0.562308f, 0.582622f, 0.551077f, 0.699446f, 0.505298f, 0.727278f, 0.658914f, 0.798841f, 0.838826f, 0.724987f,
0.000062f, 0.000070f, 0.000132f, 0.000364f, 0.000043f, 0.000058f, 0.000150f, 0.000213f, 0.000001f, 0.000001f, 0.000003f, 0.000006f, 0.000041f, 0.000049f, 0.000173f, 0.000206f,
0.000048f, 0.000054f, 0.000127f, 0.000294f, 0.000036f, 0.000048f, 0.000155f, 0.000186f, 0.000001f, 0.000002f, 0.000005f, 0.000009f, 0.000025f, 0.000031f, 0.000135f, 0.000135f,
0.000228f, 0.000219f, 0.000486f, 0.001193f, 0.000111f, 0.000129f, 0.000391f, 0.000496f, 0.000003f, 0.000004f, 0.000010f, 0.000018f, 0.000113f, 0.000117f, 0.000486f, 0.000515f,
0.000001f, 0.000002f, 0.000003f, 0.000010f, 0.000002f, 0.000002f, 0.000006f, 0.000009f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000005f, 0.000006f,
0.843841f, 1.016250f, 0.476048f, 1.129716f, 0.735309f, 1.074802f, 0.685931f, 0.842396f, 0.552542f, 0.751114f, 0.453615f, 0.773861f, 1.228933f, 1.595726f, 1.400740f, 1.434957f,
0.513913f, 0.619810f, 0.359861f, 0.720264f, 0.482037f, 0.705614f, 0.558144f, 0.578122f, 0.661472f, 0.900495f, 0.674045f, 0.969846f, 0.608482f, 0.791237f, 0.860860f, 0.743793f,
2.395406f, 2.484494f, 1.361895f, 2.880784f, 1.477877f, 1.860442f, 1.389389f, 1.520925f, 1.486637f, 1.740462f, 1.229990f, 1.870362f, 2.663798f, 2.978864f, 3.059888f, 2.794055f,
0.203049f, 0.239575f, 0.122221f, 0.318784f, 0.287065f, 0.411092f, 0.285723f, 0.385668f, 0.288191f, 0.383815f, 0.252440f, 0.473332f, 0.317014f, 0.403282f, 0.385533f, 0.434086f,
0.090902f, 0.113226f, 0.040622f, 0.135024f, 0.056527f, 0.085457f, 0.041770f, 0.071851f, 0.076995f, 0.108252f, 0.050070f, 0.119644f, 0.210520f, 0.282719f, 0.190071f, 0.272730f,
0.090062f, 0.112341f, 0.049955f, 0.140046f, 0.060284f, 0.091269f, 0.055292f, 0.080218f, 0.149950f, 0.211129f, 0.121037f, 0.243932f, 0.169570f, 0.228055f, 0.190032f, 0.229976f,
0.544789f, 0.584411f, 0.245350f, 0.726925f, 0.239862f, 0.312299f, 0.178624f, 0.273880f, 0.437361f, 0.529580f, 0.286636f, 0.610507f, 0.963391f, 1.114253f, 0.876598f, 1.121156f,
0.048942f, 0.059725f, 0.023336f, 0.085253f, 0.049378f, 0.073135f, 0.038931f, 0.073603f, 0.089856f, 0.123772f, 0.062347f, 0.163743f, 0.121510f, 0.159872f, 0.117055f, 0.184603f,
1.128999f, 1.452613f, 0.605550f, 1.361744f, 0.747795f, 1.167771f, 0.663223f, 0.771831f, 0.935740f, 1.358979f, 0.730372f, 1.180719f, 2.051402f, 2.845756f, 2.223038f, 2.158017f,
0.535643f, 0.690177f, 0.356605f, 0.676349f, 0.381897f, 0.597241f, 0.420415f, 0.412647f, 0.872680f, 1.269231f, 0.845471f, 1.152761f, 0.791268f, 1.099256f, 1.064326f, 0.871406f,
2.960255f, 3.280231f, 1.600149f, 3.207407f, 1.388252f, 1.867078f, 1.240853f, 1.287155f, 2.325477f, 2.908630f, 1.829260f, 2.635884f, 4.107156f, 4.906898f, 4.485512f, 3.881220f,
0.388043f, 0.489144f, 0.222071f, 0.548869f, 0.417003f, 0.637991f, 0.394613f, 0.504737f, 0.697136f, 0.991916f, 0.580578f, 1.031561f, 0.755870f, 1.027292f, 0.873972f, 0.932475f,
0.000305f, 0.000382f, 0.000586f, 0.001991f, 0.000156f, 0.000236f, 0.000494f, 0.000868f, 0.000006f, 0.000008f, 0.000016f, 0.000038f, 0.000218f, 0.000294f, 0.000846f, 0.001241f,
0.000192f, 0.000241f, 0.000458f, 0.001314f, 0.000106f, 0.000160f, 0.000416f, 0.000617f, 0.000007f, 0.000010f, 0.000024f, 0.000050f, 0.000112f, 0.000151f, 0.000538f, 0.000666f,
0.001534f, 0.001652f, 0.002967f, 0.008988f, 0.000553f, 0.000723f, 0.001770f, 0.002774f, 0.000027f, 0.000032f, 0.000075f, 0.000163f, 0.000837f, 0.000972f, 0.003271f, 0.004278f,
0.000010f, 0.000012f, 0.000020f, 0.000076f, 0.000008f, 0.000012f, 0.000028f, 0.000054f, 0.000000f, 0.000001f, 0.000001f, 0.000003f, 0.000008f, 0.000010f, 0.000031f, 0.000051f,
1.218191f, 1.644639f, 0.624184f, 1.828578f, 0.788135f, 1.291441f, 0.667758f, 1.012363f, 0.969644f, 1.477639f, 0.723005f, 1.522648f, 1.955634f, 2.846646f, 2.024531f, 2.560282f,
0.604981f, 0.817948f, 0.384764f, 0.950677f, 0.421316f, 0.691371f, 0.443080f, 0.566549f, 0.946577f, 1.444578f, 0.876074f, 1.556098f, 0.789596f, 1.151010f, 1.014605f, 1.082177f,
4.757045f, 5.531101f, 2.456458f, 6.414434f, 2.179078f, 3.075147f, 1.860655f, 2.514384f, 3.588851f, 4.710106f, 2.696868f, 5.062509f, 5.831288f, 7.310202f, 6.083818f, 6.857845f,
0.407660f, 0.539204f, 0.222869f, 0.717599f, 0.427910f, 0.686953f, 0.386835f, 0.644578f, 0.703347f, 1.050089f, 0.559569f, 1.295220f, 0.701583f, 1.000519f, 0.774944f, 1.077124f,
0.075643f, 0.091728f, 0.036179f, 0.097727f, 0.064694f, 0.095218f, 0.051165f, 0.071523f, 0.052429f, 0.071764f, 0.036492f, 0.070861f, 0.158951f, 0.207820f, 0.153599f, 0.179106f,
0.080989f, 0.098353f, 0.048080f, 0.109537f, 0.074559f, 0.109896f, 0.073192f, 0.086293f, 0.110343f, 0.151254f, 0.095328f, 0.156125f, 0.138359f, 0.181159f, 0.165954f, 0.163210f,
0.455765f, 0.475984f, 0.219686f, 0.528941f, 0.275986f, 0.349830f, 0.219972f, 0.274089f, 0.299409f, 0.352954f, 0.210019f, 0.363514f, 0.731287f, 0.823437f, 0.712178f, 0.740213f,
0.039308f, 0.046699f, 0.020059f, 0.059553f, 0.054543f, 0.078649f, 0.046026f, 0.070715f, 0.059055f, 0.079193f, 0.043856f, 0.093600f, 0.088548f, 0.113423f, 0.091297f, 0.117006f,
2.226413f, 2.788840f, 1.278100f, 2.335679f, 2.028182f, 3.083498f, 1.925249f, 1.820758f, 1.510010f, 2.135005f, 1.261453f, 1.657207f, 3.670587f, 4.957286f, 4.257299f, 3.358498f,
1.141498f, 1.431931f, 0.813373f, 1.253649f, 1.119329f, 1.704211f, 1.318843f, 1.051953f, 1.521833f, 2.154839f, 1.578024f, 1.748466f, 1.530015f, 2.069345f, 2.202671f, 1.465543f,
5.868896f, 6.331307f, 3.395395f, 5.530785f, 3.785366f, 4.956370f, 3.621285f, 3.052643f, 3.772697f, 4.593989f, 3.176274f, 3.719389f, 7.388242f, 8.593471f, 8.636039f, 6.072585f,
0.738564f, 0.906372f, 0.452378f, 0.908619f, 1.091589f, 1.625910f, 1.105589f, 1.149188f, 1.085769f, 1.504031f, 0.967795f, 1.397400f, 1.305351f, 1.727173f, 1.615401f, 1.400629f,
0.000043f, 0.000052f, 0.000088f, 0.000243f, 0.000030f, 0.000044f, 0.000102f, 0.000146f, 0.000001f, 0.000001f, 0.000002f, 0.000004f, 0.000028f, 0.000036f, 0.000115f, 0.000137f,
0.000029f, 0.000036f, 0.000074f, 0.000173f, 0.000022f, 0.000033f, 0.000093f, 0.000112f, 0.000001f, 0.000001f, 0.000003f, 0.000005f, 0.000015f, 0.000020f, 0.000079f, 0.000080f,
0.000216f, 0.000227f, 0.000448f, 0.001102f, 0.000107f, 0.000137f, 0.000367f, 0.000468f, 0.000003f, 0.000004f, 0.000009f, 0.000016f, 0.000107f, 0.000121f, 0.000448f, 0.000476f,
0.000001f, 0.000002f, 0.000003f, 0.000009f, 0.000002f, 0.000002f, 0.000006f, 0.000009f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000004f, 0.000005f,
0.970578f, 1.275696f, 0.532268f, 1.267167f, 0.863630f, 1.377728f, 0.783157f, 0.964871f, 0.632179f, 0.937902f, 0.504513f, 0.863441f, 1.413759f, 2.003470f, 1.566444f, 1.609834f,
0.520888f, 0.685630f, 0.354568f, 0.711937f, 0.498911f, 0.797054f, 0.561564f, 0.583523f, 0.666917f, 0.990873f, 0.660631f, 0.953581f, 0.616851f, 0.875419f, 0.848350f, 0.735325f,
3.810373f, 4.313239f, 2.105922f, 4.468833f, 2.400575f, 3.298148f, 2.193871f, 2.409238f, 2.352330f, 3.005628f, 1.891931f, 2.886118f, 4.238063f, 5.172422f, 4.732404f, 4.335070f,
0.313479f, 0.403669f, 0.183427f, 0.479953f, 0.452560f, 0.707313f, 0.437876f, 0.592930f, 0.442581f, 0.643296f, 0.376860f, 0.708879f, 0.489511f, 0.679626f, 0.578704f, 0.653664f,
0.041395f, 0.051856f, 0.023478f, 0.048851f, 0.031719f, 0.048227f, 0.029747f, 0.032032f, 0.030228f, 0.042742f, 0.024948f, 0.037318f, 0.080297f, 0.108452f, 0.092012f, 0.082647f,
0.029889f, 0.037497f, 0.021041f, 0.036926f, 0.024653f, 0.037538f, 0.028698f, 0.026063f, 0.042903f, 0.060753f, 0.043952f, 0.055449f, 0.047136f, 0.063756f, 0.067043f, 0.050790f,
0.266418f, 0.287429f, 0.152280f, 0.282431f, 0.144539f, 0.189266f, 0.136611f, 0.131121f, 0.184391f, 0.224547f, 0.153373f, 0.204492f, 0.394608f, 0.459012f, 0.455706f, 0.364852f,
0.023612f, 0.028979f, 0.014288f, 0.032677f, 0.029354f, 0.043726f, 0.029373f, 0.034763f, 0.037373f, 0.051773f, 0.032912f, 0.054108f, 0.049100f, 0.064972f, 0.060032f, 0.059265f,
1.199936f, 1.552713f, 0.816836f, 1.149867f, 0.979348f, 1.538115f, 1.102389f, 0.803091f, 0.857400f, 1.252326f, 0.849361f, 0.859532f, 1.826181f, 2.547811f, 2.511657f, 1.526285f,
0.414896f, 0.537651f, 0.350567f, 0.416219f, 0.364501f, 0.573297f, 0.509275f, 0.312910f, 0.582749f, 0.852402f, 0.716550f, 0.611581f, 0.513352f, 0.717245f, 0.876370f, 0.449159f,
3.378714f, 3.765333f, 2.317945f, 2.908466f, 1.952453f, 2.640897f, 2.214896f, 1.438239f, 2.288221f, 2.878398f, 2.284451f, 2.060629f, 3.926377f, 4.717746f, 5.442311f, 2.947859f,
0.436931f, 0.553919f, 0.317354f, 0.491009f, 0.578578f, 0.890254f, 0.694887f, 0.556386f, 0.676727f, 0.968384f, 0.715282f, 0.795571f, 0.712866f, 0.974388f, 1.046114f, 0.698693f,
0.000283f, 0.000356f, 0.000689f, 0.001467f, 0.000178f, 0.000271f, 0.000716f, 0.000788f, 0.000004f, 0.000006f, 0.000016f, 0.000024f, 0.000169f, 0.000230f, 0.000834f, 0.000766f,
0.000130f, 0.000164f, 0.000393f, 0.000705f, 0.000088f, 0.000134f, 0.000439f, 0.000408f, 0.000004f, 0.000006f, 0.000018f, 0.000023f, 0.000063f, 0.000086f, 0.000386f, 0.000299f,
0.001527f, 0.001654f, 0.003749f, 0.007109f, 0.000679f, 0.000892f, 0.002755f, 0.002704f, 0.000023f, 0.000028f, 0.000082f, 0.000111f, 0.000698f, 0.000815f, 0.003461f, 0.002834f,
0.000010f, 0.000012f, 0.000025f, 0.000059f, 0.000010f, 0.000015f, 0.000043f, 0.000052f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000006f, 0.000008f, 0.000033f, 0.000033f,
0.968501f, 1.315018f, 0.629822f, 1.155010f, 0.772103f, 1.272407f, 0.830260f, 0.787950f, 0.664600f, 1.018575f, 0.628942f, 0.829154f, 1.302269f, 1.906440f, 1.711032f, 1.354530f,
0.350530f, 0.476635f, 0.282943f, 0.437627f, 0.300803f, 0.496434f, 0.401491f, 0.321365f, 0.472828f, 0.725713f, 0.555404f, 0.617549f, 0.383192f, 0.561782f, 0.624927f, 0.417252f,
4.061437f, 4.749312f, 2.661781f, 4.350994f, 2.292479f, 3.253682f, 2.484385f, 2.101608f, 2.641566f, 3.486690f, 2.519337f, 2.960461f, 4.169995f, 5.257472f, 5.521635f, 3.896246f,
0.343361f, 0.456754f, 0.238244f, 0.480200f, 0.444115f, 0.717045f, 0.509552f, 0.531503f, 0.510724f, 0.766865f, 0.515692f, 0.747218f, 0.494949f, 0.709877f, 0.693861f, 0.603719f,
0.010920f, 0.012134f, 0.005373f, 0.014467f, 0.009926f, 0.013386f, 0.008075f, 0.011252f, 0.007980f, 0.010008f, 0.005713f, 0.011059f, 0.021109f, 0.025288f, 0.020984f, 0.024390f,
0.008757f, 0.009744f, 0.005348f, 0.012145f, 0.008567f, 0.011570f, 0.008652f, 0.010168f, 0.012578f, 0.015798f, 0.011178f, 0.018249f, 0.013761f, 0.016510f, 0.016980f, 0.016646f,
0.047473f, 0.045428f, 0.023539f, 0.056496f, 0.030551f, 0.035483f, 0.025049f, 0.031112f, 0.032879f, 0.035513f, 0.023724f, 0.040933f, 0.070070f, 0.072293f, 0.070198f, 0.072729f,
0.003986f, 0.004339f, 0.002093f, 0.006193f, 0.005878f, 0.007766f, 0.005103f, 0.007815f, 0.006314f, 0.007758f, 0.004823f, 0.010261f, 0.008260f, 0.009695f, 0.008761f, 0.011193f,
0.460295f, 0.528296f, 0.271822f, 0.495163f, 0.445623f, 0.620765f, 0.435149f, 0.410221f, 0.329120f, 0.426380f, 0.282837f, 0.370387f, 0.698081f, 0.863848f, 0.832903f, 0.654968f,
0.176749f, 0.203154f, 0.129557f, 0.199050f, 0.184191f, 0.256955f, 0.223251f, 0.177506f, 0.248423f, 0.322301f, 0.264989f, 0.292676f, 0.217930f, 0.270070f, 0.322745f, 0.214054f,
0.875442f, 0.865340f, 0.521016f, 0.845985f, 0.600080f, 0.719926f, 0.590546f, 0.496229f, 0.593290f, 0.661954f, 0.513834f, 0.599779f, 1.013799f, 1.080444f, 1.219032f, 0.854455f,
0.107259f, 0.120608f, 0.067583f, 0.135311f, 0.168475f, 0.229930f, 0.175533f, 0.181874f, 0.166237f, 0.210993f, 0.152427f, 0.219389f, 0.174386f, 0.211419f, 0.222001f, 0.191873f,
0.000005f, 0.000006f, 0.000011f, 0.000031f, 0.000004f, 0.000005f, 0.000014f, 0.000019f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000003f, 0.000004f, 0.000013f, 0.000016f,
0.000003f, 0.000003f, 0.000007f, 0.000016f, 0.000002f, 0.000003f, 0.000009f, 0.000011f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000002f, 0.000007f, 0.000007f,
0.000019f, 0.000018f, 0.000041f, 0.000100f, 0.000010f, 0.000012f, 0.000036f, 0.000045f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000009f, 0.000009f, 0.000037f, 0.000040f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
0.159487f, 0.192072f, 0.089973f, 0.213517f, 0.150817f, 0.220450f, 0.140690f, 0.172782f, 0.109516f, 0.148874f, 0.089908f, 0.153382f, 0.213702f, 0.277485f, 0.243578f, 0.249528f,
0.064104f, 0.077314f, 0.044888f, 0.089844f, 0.065253f, 0.095518f, 0.075555f, 0.078260f, 0.086529f, 0.117795f, 0.088173f, 0.126867f, 0.069833f, 0.090808f, 0.098798f, 0.085363f,
0.451753f, 0.468555f, 0.256842f, 0.543292f, 0.302468f, 0.380765f, 0.284358f, 0.311279f, 0.294020f, 0.344220f, 0.243261f, 0.369911f, 0.462212f, 0.516881f, 0.530940f, 0.484814f,
0.036184f, 0.042693f, 0.021780f, 0.056808f, 0.055516f, 0.079501f, 0.055256f, 0.074584f, 0.053857f, 0.071728f, 0.047176f, 0.088456f, 0.051977f, 0.066121f, 0.063211f, 0.071172f,
0.032611f, 0.040619f, 0.014573f, 0.048439f, 0.022007f, 0.033270f, 0.016262f, 0.027973f, 0.028967f, 0.040726f, 0.018837f, 0.045012f, 0.069486f, 0.093317f, 0.062737f, 0.090020f,
0.021324f, 0.026599f, 0.011828f, 0.033158f, 0.015490f, 0.023451f, 0.014207f, 0.020612f, 0.037232f, 0.052423f, 0.030053f, 0.060568f, 0.036939f, 0.049680f, 0.041397f, 0.050098f,
0.195018f, 0.209201f, 0.087828f, 0.260217f, 0.093181f, 0.121321f, 0.069391f, 0.106396f, 0.164186f, 0.198805f, 0.107603f, 0.229185f, 0.317297f, 0.366984f, 0.288711f, 0.369258f,
0.016555f, 0.020202f, 0.007893f, 0.028837f, 0.018126f, 0.026846f, 0.014291f, 0.027018f, 0.031874f, 0.043904f, 0.022116f, 0.058083f, 0.037815f, 0.049754f, 0.036429f, 0.057451f,
0.703495f, 0.905143f, 0.377327f, 0.848522f, 0.505672f, 0.789667f, 0.448483f, 0.521926f, 0.611465f, 0.888033f, 0.477266f, 0.771548f, 1.176077f, 1.631483f, 1.274476f, 1.237200f,
0.220282f, 0.283833f, 0.146653f, 0.278147f, 0.170438f, 0.266545f, 0.187629f, 0.184162f, 0.376363f, 0.547385f, 0.364629f, 0.497154f, 0.299394f, 0.415929f, 0.402712f, 0.329717f,
1.840585f, 2.039535f, 0.994918f, 1.994256f, 0.936729f, 1.259819f, 0.837271f, 0.868514f, 1.516310f, 1.896550f, 1.192755f, 1.718708f, 2.349554f, 2.807058f, 2.565998f, 2.220304f,
0.227982f, 0.287380f, 0.130470f, 0.322469f, 0.265875f, 0.406774f, 0.251599f, 0.321813f, 0.429522f, 0.611144f, 0.357708f, 0.635570f, 0.408586f, 0.555304f, 0.472427f, 0.504051f,
0.000052f, 0.000065f, 0.000100f, 0.000342f, 0.000029f, 0.000044f, 0.000092f, 0.000162f, 0.000001f, 0.000001f, 0.000003f, 0.000007f, 0.000034f, 0.000046f, 0.000133f, 0.000196f,
0.000022f, 0.000027f, 0.000052f, 0.000149f, 0.000013f, 0.000020f, 0.000051f, 0.000076f, 0.000001f, 0.000001f, 0.000003f, 0.000006f, 0.000012f, 0.000016f, 0.000056f, 0.000069f,
0.000263f, 0.000283f, 0.000508f, 0.001538f, 0.000103f, 0.000134f, 0.000329f, 0.000515f, 0.000005f, 0.000006f, 0.000013f, 0.000029f, 0.000132f, 0.000153f, 0.000515f, 0.000674f,
0.000002f, 0.000002f, 0.000003f, 0.000012f, 0.000001f, 0.000002f, 0.000005f, 0.000009f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000001f, 0.000005f, 0.000008f,
0.470253f, 0.634874f, 0.240951f, 0.705879f, 0.330169f, 0.541016f, 0.279740f, 0.424104f, 0.392535f, 0.598183f, 0.292690f, 0.616404f, 0.694579f, 1.011039f, 0.719050f, 0.909331f,
0.154132f, 0.208390f, 0.098027f, 0.242206f, 0.116487f, 0.191153f, 0.122505f, 0.156642f, 0.252905f, 0.385960f, 0.234068f, 0.415756f, 0.185086f, 0.269804f, 0.237830f, 0.253669f,
1.832371f, 2.130530f, 0.946205f, 2.470782f, 0.910894f, 1.285467f, 0.777787f, 1.051058f, 1.449708f, 1.902637f, 1.089394f, 2.044989f, 2.066608f, 2.590735f, 2.156104f, 2.430420f,
0.148377f, 0.196255f, 0.081118f, 0.261187f, 0.169021f, 0.271341f, 0.152796f, 0.254603f, 0.268465f, 0.400815f, 0.213585f, 0.494381f, 0.234945f, 0.335051f, 0.259512f, 0.360705f,
0.309617f, 0.375455f, 0.148085f, 0.400008f, 0.327728f, 0.482353f, 0.259191f, 0.362322f, 0.265340f, 0.363192f, 0.184680f, 0.358621f, 0.726214f, 0.949485f, 0.701762f, 0.818296f,
0.280126f, 0.340185f, 0.166301f, 0.378870f, 0.319170f, 0.470438f, 0.313317f, 0.369400f, 0.471898f, 0.646861f, 0.407682f, 0.667689f, 0.534174f, 0.699416f, 0.640714f, 0.630119f,
1.402535f, 1.464757f, 0.676043f, 1.627722f, 1.051118f, 1.332362f, 0.837786f, 1.043893f, 1.139232f, 1.342966f, 0.799107f, 1.383146f, 2.511931f, 2.828462f, 2.446291f, 2.542591f,
0.130263f, 0.154759f, 0.066476f, 0.197357f, 0.223707f, 0.322576f, 0.188773f, 0.290033f, 0.241977f, 0.324495f, 0.179699f, 0.383525f, 0.327545f, 0.419560f, 0.337715f, 0.432815f,
6.947791f, 8.702914f, 3.988465f, 7.288769f, 7.833216f, 11.909050f, 7.435672f, 7.032106f, 5.826327f, 8.237849f, 4.867278f, 6.394279f, 12.785670f, 17.267600f, 14.829360f, 11.698580f,
3.010170f, 3.776050f, 2.144892f, 3.305917f, 3.653135f, 5.562004f, 4.304287f, 3.433242f, 4.962000f, 7.025939f, 5.145213f, 5.700945f, 4.503587f, 6.091100f, 6.483545f, 4.313815f,
13.769440f, 14.854330f, 7.966178f, 12.976170f, 10.991570f, 14.391820f, 10.515130f, 8.863966f, 10.944240f, 13.326730f, 9.214072f, 10.789600f, 19.348530f, 22.504810f, 22.616290f, 15.903050f,
1.866041f, 2.290021f, 1.142970f, 2.295700f, 3.413380f, 5.084189f, 3.457158f, 3.593489f, 3.391912f, 4.698549f, 3.023363f, 4.365437f, 3.681352f, 4.870977f, 4.555757f, 3.950057f,
0.000961f, 0.001170f, 0.001974f, 0.005452f, 0.000833f, 0.001231f, 0.002830f, 0.004045f, 0.000018f, 0.000024f, 0.000053f, 0.000106f, 0.000695f, 0.000913f, 0.002886f, 0.003441f,
0.000553f, 0.000674f, 0.001410f, 0.003285f, 0.000516f, 0.000764f, 0.002177f, 0.002624f, 0.000020f, 0.000028f, 0.000075f, 0.000125f, 0.000325f, 0.000428f, 0.001677f, 0.001686f,
0.003649f, 0.003827f, 0.007555f, 0.018599f, 0.002241f, 0.002852f, 0.007670f, 0.009772f, 0.000064f, 0.000076f, 0.000193f, 0.000342f, 0.002017f, 0.002280f, 0.008435f, 0.008964f,
0.000024f, 0.000029f, 0.000053f, 0.000162f, 0.000034f, 0.000050f, 0.000124f, 0.000195f, 0.000001f, 0.000001f, 0.000003f, 0.000007f, 0.000019f, 0.000024f, 0.000084f, 0.000110f,
4.224910f, 5.553086f, 2.316954f, 5.515960f, 4.652723f, 7.422377f, 4.219181f, 5.198149f, 3.402521f, 5.047993f, 2.715395f, 4.647225f, 6.869253f, 9.734575f, 7.611129f, 7.821954f,
1.916048f, 2.522040f, 1.304252f, 2.618806f, 2.271315f, 3.628624f, 2.556547f, 2.656515f, 3.033243f, 4.506650f, 3.004656f, 4.337041f, 2.532731f, 3.594390f, 3.483244f, 3.019174f,
12.470200f, 14.115930f, 6.892046f, 14.625140f, 9.723295f, 13.358830f, 8.886060f, 9.758383f, 9.518709f, 12.162280f, 7.655701f, 11.678680f, 15.481760f, 18.895000f, 17.287600f, 15.836130f,
1.104810f, 1.422671f, 0.646460f, 1.691521f, 1.974000f, 3.085199f, 1.909953f, 2.586277f, 1.928617f, 2.803265f, 1.642225f, 3.089053f, 1.925700f, 2.673600f, 2.276580f, 2.571467f,
0.209508f, 0.262451f, 0.118824f, 0.247244f, 0.198685f, 0.302087f, 0.186333f, 0.200646f, 0.189160f, 0.267472f, 0.156122f, 0.233531f, 0.453624f, 0.612681f, 0.519803f, 0.466900f,
0.127832f, 0.160368f, 0.089991f, 0.157928f, 0.130493f, 0.198693f, 0.151903f, 0.137957f, 0.226874f, 0.321265f, 0.232422f, 0.293220f, 0.225022f, 0.304364f, 0.320055f, 0.242464f,
1.013751f, 1.093701f, 0.579442f, 1.074683f, 0.680686f, 0.891319f, 0.643349f, 0.617495f, 0.867523f, 1.056450f, 0.721592f, 0.962097f, 1.676029f, 1.949571f, 1.935529f, 1.549646f,
0.096754f, 0.118746f, 0.058550f, 0.133900f, 0.148869f, 0.221754f, 0.148965f, 0.176301f, 0.189353f, 0.262314f, 0.166749f, 0.274141f, 0.224581f, 0.297175f, 0.274582f, 0.271074f,
4.630146f, 5.991390f, 3.151894f, 4.436947f, 4.676983f, 7.345436f, 5.264580f, 3.835246f, 4.090663f, 5.974858f, 4.052312f, 4.100838f, 7.865519f, 10.973640f, 10.817920f, 6.573840f,
1.352852f, 1.753122f, 1.143096f, 1.357167f, 1.470967f, 2.313573f, 2.055209f, 1.262768f, 2.349454f, 3.436605f, 2.888893f, 2.465694f, 1.868417f, 2.610513f, 3.189669f, 1.634778f,
9.801819f, 10.923420f, 6.724476f, 8.437606f, 7.010163f, 9.481977f, 7.952448f, 5.163907f, 8.207805f, 10.324760f, 8.194282f, 7.391436f, 12.714350f, 15.276950f, 17.623240f, 9.545726f,
1.365028f, 1.730513f, 0.991455f, 1.533973f, 2.237087f, 3.442190f, 2.686799f, 2.151279f, 2.614062f, 3.740676f, 2.762991f, 3.073132f, 2.485900f, 3.397875f, 3.647999f, 2.436474f,
0.007855f, 0.009879f, 0.019133f, 0.040705f, 0.006102f, 0.009315f, 0.024580f, 0.027062f, 0.000153f, 0.000218f, 0.000544f, 0.000832f, 0.005247f, 0.007116f, 0.025825f, 0.023718f,
0.003049f, 0.003841f, 0.009219f, 0.016543f, 0.002550f, 0.003898f, 0.012749f, 0.011839f, 0.000117f, 0.000166f, 0.000515f, 0.000665f, 0.001656f, 0.002249f, 0.010117f, 0.007837f,
0.031865f, 0.034515f, 0.078224f, 0.148340f, 0.017528f, 0.023044f, 0.071153f, 0.069827f, 0.000590f, 0.000721f, 0.002108f, 0.002873f, 0.016255f, 0.018983f, 0.080623f, 0.065999f,
0.000219f, 0.000270f, 0.000569f, 0.001330f, 0.000276f, 0.000413f, 0.001186f, 0.001435f, 0.000009f, 0.000013f, 0.000035f, 0.000059f, 0.000157f, 0.000208f, 0.000823f, 0.000831f,
5.212938f, 7.078063f, 3.390005f, 6.216820f, 5.143397f, 8.476192f, 5.530812f, 5.248964f, 4.422999f, 6.778751f, 4.185687f, 5.518129f, 7.824029f, 11.453890f, 10.279880f, 8.138012f,
1.594347f, 2.167921f, 1.286933f, 1.990499f, 1.693291f, 2.794545f, 2.260090f, 1.809042f, 2.659100f, 4.081278f, 3.123489f, 3.472986f, 1.945456f, 2.852151f, 3.172737f, 2.118374f,
16.435430f, 19.219060f, 10.771440f, 17.607180f, 11.481510f, 16.295540f, 12.442640f, 10.525560f, 13.217110f, 17.445710f, 12.605540f, 14.812710f, 18.835790f, 23.747910f, 24.941130f, 17.599270f,
1.496322f, 1.990477f, 1.038239f, 2.092653f, 2.395314f, 3.867350f, 2.748248f, 2.866636f, 2.751912f, 4.132069f, 2.778683f, 4.026205f, 2.407588f, 3.453066f, 3.375158f, 2.936679f,
0.394890f, 0.438765f, 0.194291f, 0.523148f, 0.444215f, 0.599057f, 0.361402f, 0.503594f, 0.356777f, 0.447460f, 0.255449f, 0.494464f, 0.852030f, 1.020708f, 0.846974f, 0.984478f,
0.267580f, 0.297741f, 0.163412f, 0.371104f, 0.324006f, 0.437579f, 0.327194f, 0.384532f, 0.475218f, 0.596868f, 0.422334f, 0.689484f, 0.469379f, 0.563117f, 0.579154f, 0.567764f,
1.290638f, 1.235035f, 0.639963f, 1.535946f, 1.027952f, 1.193896f, 0.842838f, 1.046844f, 1.105216f, 1.193776f, 0.797498f, 1.375967f, 2.126369f, 2.193835f, 2.130241f, 2.207051f,
0.116704f, 0.127041f, 0.061266f, 0.181310f, 0.212998f, 0.281417f, 0.184895f, 0.283170f, 0.228551f, 0.280828f, 0.174601f, 0.371456f, 0.269945f, 0.316827f, 0.286316f, 0.365774f,
12.690050f, 14.564790f, 7.493976f, 13.651360f, 15.205020f, 21.181020f, 14.847630f, 13.997080f, 11.219040f, 14.534410f, 9.641323f, 12.625750f, 21.482270f, 26.583460f, 25.631180f, 20.155550f,
4.117730f, 4.732900f, 3.018298f, 4.637284f, 5.310836f, 7.408858f, 6.437068f, 5.118074f, 7.155954f, 9.284063f, 7.633153f, 8.430681f, 5.667156f, 7.023041f, 8.392842f, 5.566384f,
18.145680f, 17.936300f, 10.799330f, 17.535110f, 15.393850f, 18.468260f, 15.149280f, 12.729760f, 15.205010f, 16.964750f, 13.168690f, 15.371320f, 23.455500f, 24.997420f, 28.203830f, 19.768890f,
2.394157f, 2.692115f, 1.508537f, 3.020309f, 4.654214f, 6.351938f, 4.849207f, 5.024387f, 4.587963f, 5.823204f, 4.206836f, 6.054916f, 4.344888f, 5.267568f, 5.531228f, 4.780569f,
0.001041f, 0.001161f, 0.002199f, 0.006055f, 0.000959f, 0.001299f, 0.003351f, 0.004775f, 0.000020f, 0.000026f, 0.000063f, 0.000124f, 0.000693f, 0.000833f, 0.002958f, 0.003516f,
0.000449f, 0.000501f, 0.001177f, 0.002733f, 0.000445f, 0.000604f, 0.001930f, 0.002320f, 0.000017f, 0.000022f, 0.000066f, 0.000110f, 0.000243f, 0.000293f, 0.001287f, 0.001290f,
0.002852f, 0.002740f, 0.006073f, 0.014904f, 0.001861f, 0.002170f, 0.006553f, 0.008322f, 0.000053f, 0.000057f, 0.000164f, 0.000289f, 0.001450f, 0.001502f, 0.006238f, 0.006608f,
0.000019f, 0.000020f, 0.000042f, 0.000127f, 0.000028f, 0.000037f, 0.000103f, 0.000162f, 0.000001f, 0.000001f, 0.000003f, 0.000006f, 0.000013f, 0.000016f, 0.000060f, 0.000079f,
6.133343f, 7.386472f, 3.460087f, 8.211186f, 7.178230f, 10.492430f, 6.696197f, 8.223635f, 5.207445f, 7.078894f, 4.275104f, 7.293275f, 9.173376f, 11.911310f, 10.455830f, 10.711240f,
2.083226f, 2.512493f, 1.458752f, 2.919700f, 2.624446f, 3.841714f, 3.038812f, 3.147585f, 3.476812f, 4.733155f, 3.542897f, 5.097679f, 2.533138f, 3.293956f, 3.583798f, 3.096442f,
13.061520f, 13.547290f, 7.426055f, 15.708150f, 10.823410f, 13.625160f, 10.175360f, 11.138670f, 10.510960f, 12.305580f, 8.696391f, 13.224010f, 14.916960f, 16.681290f, 17.135020f, 15.646390f,
1.126632f, 1.329297f, 0.678151f, 1.768793f, 2.139302f, 3.063592f, 2.129303f, 2.874120f, 2.073407f, 2.761376f, 1.816189f, 3.405406f, 1.806438f, 2.298019f, 2.196884f, 2.473548f,
0.203340f, 0.253277f, 0.090867f, 0.302038f, 0.169831f, 0.256749f, 0.125494f, 0.215871f, 0.223325f, 0.313986f, 0.145229f, 0.347028f, 0.483624f, 0.649486f, 0.436647f, 0.626539f,
0.112357f, 0.140152f, 0.062321f, 0.174715f, 0.101012f, 0.152930f, 0.092648f, 0.134414f, 0.242566f, 0.341532f, 0.195795f, 0.394595f, 0.217257f, 0.292189f, 0.243474f, 0.294651f,
0.914231f, 0.980723f, 0.411731f, 1.219880f, 0.540631f, 0.703898f, 0.402605f, 0.617305f, 0.951680f, 1.152345f, 0.623708f, 1.328439f, 1.660333f, 1.920331f, 1.510751f, 1.932228f,
0.083575f, 0.101988f, 0.039849f, 0.145580f, 0.113251f, 0.167738f, 0.089289f, 0.168812f, 0.198960f, 0.274055f, 0.138050f, 0.362559f, 0.213093f, 0.280370f, 0.205280f, 0.323740f,
3.344346f, 4.302962f, 1.793774f, 4.033789f, 2.975166f, 4.646077f, 2.638691f, 3.070796f, 3.594147f, 5.219791f, 2.805333f, 4.535102f, 6.240695f, 8.657247f, 6.762838f, 6.565035f,
0.884918f, 1.140219f, 0.589135f, 1.117374f, 0.847392f, 1.325221f, 0.932862f, 0.915625f, 1.869413f, 2.718888f, 1.811128f, 2.469391f, 1.342504f, 1.865052f, 1.805788f, 1.478472f,
6.578467f, 7.289539f, 3.555952f, 7.127703f, 4.143573f, 5.572745f, 3.703626f, 3.841826f, 6.700861f, 8.381214f, 5.271012f, 7.595297f, 9.373489f, 11.198690f, 10.236990f, 8.857850f,
0.877490f, 1.106111f, 0.502173f, 1.241168f, 1.266520f, 1.937704f, 1.198516f, 1.532986f, 2.044099f, 2.908435f, 1.702335f, 3.024681f, 1.755387f, 2.385723f, 2.029661f, 2.165527f,
0.001790f, 0.002239f, 0.003436f, 0.011679f, 0.001225f, 0.001859f, 0.003888f, 0.006838f, 0.000043f, 0.000060f, 0.000119f, 0.000290f, 0.001314f, 0.001772f, 0.005095f, 0.007475f,
0.000629f, 0.000788f, 0.001500f, 0.004298f, 0.000464f, 0.000705f, 0.001826f, 0.002709f, 0.000029f, 0.000042f, 0.000102f, 0.000210f, 0.000376f, 0.000507f, 0.001808f, 0.002237f,
0.006749f, 0.007269f, 0.013054f, 0.039546f, 0.003270f, 0.004274f, 0.010458f, 0.016395f, 0.000152f, 0.000185f, 0.000428f, 0.000932f, 0.003782f, 0.004392f, 0.014780f, 0.019328f,
0.000044f, 0.000054f, 0.000091f, 0.000340f, 0.000049f, 0.000073f, 0.000167f, 0.000323f, 0.000002f, 0.000003f, 0.000007f, 0.000018f, 0.000035f, 0.000046f, 0.000145f, 0.000233f,
3.118375f, 4.210014f, 1.597812f, 4.680868f, 2.709721f, 4.440161f, 2.295847f, 3.480652f, 3.218460f, 4.904609f, 2.399814f, 5.054003f, 5.141208f, 7.483608f, 5.322334f, 6.730781f,
0.863704f, 1.167747f, 0.549310f, 1.357239f, 0.807872f, 1.325700f, 0.849603f, 1.086355f, 1.752274f, 2.674158f, 1.621761f, 2.880600f, 1.157690f, 1.687589f, 1.487594f, 1.586667f,
9.135415f, 10.621910f, 4.717375f, 12.318260f, 5.620499f, 7.931733f, 4.799191f, 6.485356f, 8.936540f, 11.728560f, 6.715427f, 12.606070f, 11.500590f, 14.417330f, 11.998630f, 13.525190f,
0.796626f, 1.053683f, 0.435518f, 1.402294f, 1.123106f, 1.802998f, 1.015299f, 1.691778f, 1.782172f, 2.660762f, 1.417861f, 3.281886f, 1.407994f, 2.007922f, 1.555221f, 2.161660f,
0.034844f, 0.042253f, 0.016665f, 0.045017f, 0.034170f, 0.050291f, 0.027024f, 0.037777f, 0.026612f, 0.036426f, 0.018522f, 0.035968f, 0.131474f, 0.171895f, 0.127047f, 0.148144f,
0.038531f, 0.046792f, 0.022874f, 0.052113f, 0.040673f, 0.059949f, 0.039927f, 0.047074f, 0.057846f, 0.079294f, 0.049975f, 0.081847f, 0.118198f, 0.154761f, 0.141772f, 0.139428f,
0.190693f, 0.199153f, 0.091917f, 0.221311f, 0.132403f, 0.167830f, 0.105531f, 0.131493f, 0.138040f, 0.162727f, 0.096828f, 0.167596f, 0.549415f, 0.618648f, 0.535058f, 0.556122f,
0.021196f, 0.025182f, 0.010817f, 0.032114f, 0.033724f, 0.048629f, 0.028458f, 0.043723f, 0.035090f, 0.047056f, 0.026059f, 0.055617f, 0.085739f, 0.109826f, 0.088402f, 0.113295f,
1.249919f, 1.565669f, 0.717532f, 1.311262f, 1.305569f, 1.984892f, 1.239310f, 1.172048f, 0.934119f, 1.320752f, 0.780358f, 1.025178f, 3.700241f, 4.997336f, 4.291694f, 3.385631f,
0.661879f, 0.830281f, 0.471621f, 0.726908f, 0.744180f, 1.133035f, 0.876826f, 0.699385f, 0.972336f, 1.376779f, 1.008238f, 1.117138f, 1.593005f, 2.154539f, 2.293355f, 1.525879f,
2.992750f, 3.228549f, 1.731427f, 2.820335f, 2.213291f, 2.897974f, 2.117354f, 1.784871f, 2.119884f, 2.581369f, 1.784753f, 2.089930f, 6.765085f, 7.868660f, 7.907637f, 5.560397f,
0.485391f, 0.595676f, 0.297307f, 0.597153f, 0.822583f, 1.225228f, 0.833133f, 0.865988f, 0.786299f, 1.089198f, 0.700863f, 1.011977f, 1.540456f, 2.038252f, 1.906349f, 1.652895f,
0.000681f, 0.000829f, 0.001399f, 0.003864f, 0.000547f, 0.000809f, 0.001859f, 0.002656f, 0.000011f, 0.000015f, 0.000034f, 0.000067f, 0.000793f, 0.001041f, 0.003291f, 0.003923f,
0.000479f, 0.000584f, 0.001222f, 0.002846f, 0.000414f, 0.000613f, 0.001747f, 0.002106f, 0.000016f, 0.000021f, 0.000058f, 0.000097f, 0.000454f, 0.000596f, 0.002336f, 0.002349f,
0.003125f, 0.003277f, 0.006469f, 0.015926f, 0.001778f, 0.002262f, 0.006085f, 0.007752f, 0.000049f, 0.000058f, 0.000147f, 0.000261f, 0.002778f, 0.003141f, 0.011620f, 0.012348f,
0.000025f, 0.000030f, 0.000055f, 0.000166f, 0.000033f, 0.000047f, 0.000118f, 0.000186f, 0.000001f, 0.000001f, 0.000003f, 0.000006f, 0.000031f, 0.000040f, 0.000138f, 0.000181f,
0.620495f, 0.815559f, 0.340282f, 0.810107f, 0.633072f, 1.009924f, 0.574082f, 0.707285f, 0.445343f, 0.660712f, 0.355407f, 0.608257f, 1.622938f, 2.299902f, 1.798214f, 1.848024f,
0.343938f, 0.452715f, 0.234118f, 0.470085f, 0.377725f, 0.603448f, 0.425159f, 0.441784f, 0.485236f, 0.720941f, 0.480663f, 0.693808f, 0.731364f, 1.037934f, 1.005839f, 0.871832f,
2.212654f, 2.504664f, 1.222893f, 2.595016f, 1.598373f, 2.196003f, 1.460743f, 1.604141f, 1.505187f, 1.923213f, 1.210591f, 1.846742f, 4.419077f, 5.393344f, 4.934532f, 4.520228f,
0.234609f, 0.302107f, 0.137277f, 0.359198f, 0.388354f, 0.606966f, 0.375754f, 0.508811f, 0.364985f, 0.530509f, 0.310786f, 0.584594f, 0.657834f, 0.913323f, 0.777697f, 0.878433f,
0.022636f, 0.028356f, 0.012838f, 0.026713f, 0.019888f, 0.030238f, 0.018651f, 0.020084f, 0.018214f, 0.025754f, 0.015032f, 0.022486f, 0.078842f, 0.106488f, 0.090345f, 0.081150f,
0.016881f, 0.021177f, 0.011884f, 0.020855f, 0.015965f, 0.024308f, 0.018584f, 0.016878f, 0.026700f, 0.037808f, 0.027352f, 0.034507f, 0.047802f, 0.064656f, 0.067989f, 0.051507f,
0.132326f, 0.142761f, 0.075635f, 0.140279f, 0.082316f, 0.107788f, 0.077801f, 0.074674f, 0.100917f, 0.122895f, 0.083941f, 0.111919f, 0.351937f, 0.409376f, 0.406428f, 0.325399f,
0.015115f, 0.018550f, 0.009147f, 0.020918f, 0.021546f, 0.032094f, 0.021559f, 0.025516f, 0.026362f, 0.036519f, 0.023215f, 0.038166f, 0.056438f, 0.074681f, 0.069004f, 0.068122f,
0.799688f, 1.034793f, 0.544374f, 0.766320f, 0.748370f, 1.175352f, 0.842392f, 0.613682f, 0.629639f, 0.919657f, 0.623736f, 0.631205f, 2.185367f, 3.048932f, 3.005667f, 1.826485f,
0.285580f, 0.370075f, 0.241302f, 0.286491f, 0.287677f, 0.452466f, 0.401938f, 0.246960f, 0.441995f, 0.646517f, 0.543478f, 0.463863f, 0.634487f, 0.886493f, 1.083165f, 0.555147f,
2.045274f, 2.279310f, 1.403147f, 1.760613f, 1.355181f, 1.833024f, 1.537341f, 0.998269f, 1.526315f, 1.919981f, 1.523800f, 1.374504f, 4.267860f, 5.128055f, 5.915637f, 3.204239f,
0.340881f, 0.432152f, 0.247591f, 0.383071f, 0.517569f, 0.796380f, 0.621614f, 0.497717f, 0.581767f, 0.832499f, 0.614912f, 0.683935f, 0.998656f, 1.365022f, 1.465504f, 0.978800f,
0.005345f, 0.006722f, 0.013019f, 0.027697f, 0.003847f, 0.005872f, 0.015495f, 0.017060f, 0.000093f, 0.000132f, 0.000330f, 0.000504f, 0.005744f, 0.007789f, 0.028268f, 0.025962f,
0.002536f, 0.003194f, 0.007667f, 0.013758f, 0.001965f, 0.003004f, 0.009823f, 0.009122f, 0.000087f, 0.000123f, 0.000382f, 0.000493f, 0.002216f, 0.003009f, 0.013536f, 0.010484f,
0.026195f, 0.028373f, 0.064306f, 0.121945f, 0.013350f, 0.017550f, 0.054191f, 0.053181f, 0.000432f, 0.000528f, 0.001544f, 0.002105f, 0.021497f, 0.025105f, 0.106620f, 0.087281f,
0.000215f, 0.000265f, 0.000560f, 0.001309f, 0.000251f, 0.000376f, 0.001081f, 0.001308f, 0.000008f, 0.000011f, 0.000031f, 0.000052f, 0.000248f, 0.000330f, 0.001303f, 0.001315f,
0.735012f, 0.997990f, 0.477983f, 0.876557f, 0.671872f, 1.107228f, 0.722479f, 0.685662f, 0.555777f, 0.851792f, 0.525958f, 0.693387f, 1.774652f, 2.597980f, 2.331690f, 1.845870f,
0.274756f, 0.373600f, 0.221779f, 0.343025f, 0.270346f, 0.446169f, 0.360840f, 0.288826f, 0.408386f, 0.626805f, 0.479707f, 0.533383f, 0.539332f, 0.790692f, 0.879567f, 0.587270f,
2.799702f, 3.273879f, 1.834866f, 2.999304f, 1.811983f, 2.571721f, 1.963666f, 1.661118f, 2.006502f, 2.648448f, 1.913658f, 2.248731f, 5.161616f, 6.507694f, 6.834676f, 4.822769f,
0.305051f, 0.405793f, 0.211663f, 0.426623f, 0.452412f, 0.730441f, 0.519072f, 0.541432f, 0.499981f, 0.750736f, 0.504845f, 0.731502f, 0.789588f, 1.132461f, 1.106910f, 0.963108f,
0.029955f, 0.033283f, 0.014738f, 0.039684f, 0.031218f, 0.042100f, 0.025399f, 0.035391f, 0.024119f, 0.030250f, 0.017269f, 0.033427f, 0.103973f, 0.124557f, 0.103356f, 0.120135f,
0.024808f, 0.027605f, 0.015151f, 0.034407f, 0.027831f, 0.037586f, 0.028104f, 0.033030f, 0.039265f, 0.049317f, 0.034896f, 0.056969f, 0.070007f, 0.083988f, 0.086380f, 0.084681f,
0.118282f, 0.113186f, 0.058650f, 0.140763f, 0.087279f, 0.101369f, 0.071562f, 0.088883f, 0.090268f, 0.097501f, 0.065135f, 0.112381f, 0.313489f, 0.323436f, 0.314060f, 0.325384f,
0.012800f, 0.013934f, 0.006720f, 0.019886f, 0.021644f, 0.028596f, 0.018788f, 0.028774f, 0.022340f, 0.027450f, 0.017067f, 0.036309f, 0.047629f, 0.055901f, 0.050518f, 0.064538f,
1.538826f, 1.766161f, 0.908737f, 1.655396f, 1.708196f, 2.379564f, 1.668045f, 1.572491f, 1.212422f, 1.570709f, 1.041922f, 1.364444f, 4.190611f, 5.185716f, 4.999952f, 3.931805f,
0.610290f, 0.701465f, 0.447343f, 0.687293f, 0.729232f, 1.017312f, 0.883875f, 0.702764f, 0.945188f, 1.226277f, 1.008218f, 1.113559f, 1.351184f, 1.674460f, 2.001053f, 1.327158f,
2.658387f, 2.627714f, 1.582129f, 2.568938f, 2.089377f, 2.506660f, 2.056182f, 1.727786f, 1.985199f, 2.214954f, 1.719332f, 2.006913f, 5.527910f, 5.891303f, 6.646979f, 4.659062f,
0.419773f, 0.472014f, 0.264495f, 0.529557f, 0.756019f, 1.031792f, 0.787693f, 0.816148f, 0.716892f, 0.909905f, 0.657339f, 0.946111f, 1.225494f, 1.485740f, 1.560107f, 1.348380f,
0.000497f, 0.000555f, 0.001051f, 0.002892f, 0.000425f, 0.000575f, 0.001483f, 0.002113f, 0.000009f, 0.000011f, 0.000027f, 0.000053f, 0.000532f, 0.000640f, 0.002273f, 0.002702f,
0.000262f, 0.000293f, 0.000687f, 0.001596f, 0.000241f, 0.000326f, 0.001044f, 0.001255f, 0.000009f, 0.000011f, 0.000034f, 0.000057f, 0.000228f, 0.000275f, 0.001209f, 0.001212f,
0.001646f, 0.001581f, 0.003505f, 0.008602f, 0.000995f, 0.001160f, 0.003504f, 0.004450f, 0.000027f, 0.000029f, 0.000084f, 0.000149f, 0.001346f, 0.001394f, 0.005792f, 0.006135f,
0.000013f, 0.000014f, 0.000029f, 0.000087f, 0.000018f, 0.000024f, 0.000066f, 0.000104f, 0.000000f, 0.000001f, 0.000002f, 0.000003f, 0.000015f, 0.000017f, 0.000067f, 0.000088f,
0.607169f, 0.731222f, 0.342530f, 0.812864f, 0.658346f, 0.962305f, 0.614136f, 0.754224f, 0.459419f, 0.624525f, 0.377165f, 0.643438f, 1.460873f, 1.896892f, 1.665106f, 1.705780f,
0.252058f, 0.303997f, 0.176500f, 0.353266f, 0.294189f, 0.430639f, 0.340638f, 0.352831f, 0.374902f, 0.510372f, 0.382028f, 0.549679f, 0.493054f, 0.641141f, 0.697556f, 0.602696f,
1.562156f, 1.620255f, 0.888156f, 1.878694f, 1.199277f, 1.509723f, 1.127470f, 1.234209f, 1.120329f, 1.311612f, 0.926920f, 1.409504f, 2.870004f, 3.209459f, 3.296755f, 3.010344f,
0.161261f, 0.190270f, 0.097067f, 0.253177f, 0.283690f, 0.406259f, 0.282364f, 0.381133f, 0.264487f, 0.352245f, 0.231676f, 0.434399f, 0.415951f, 0.529142f, 0.505854f, 0.569559f,
0.014329f, 0.017848f, 0.006403f, 0.021284f, 0.011087f, 0.016762f, 0.008193f, 0.014093f, 0.014025f, 0.019718f, 0.009120f, 0.021793f, 0.054824f, 0.073626f, 0.049498f, 0.071024f,
0.009677f, 0.012071f, 0.005368f, 0.015048f, 0.008060f, 0.012203f, 0.007393f, 0.010725f, 0.018618f, 0.026215f, 0.015028f, 0.030288f, 0.030101f, 0.040483f, 0.033734f, 0.040824f,
0.077833f, 0.083494f, 0.035053f, 0.103854f, 0.042642f, 0.055519f, 0.031755f, 0.048689f, 0.072206f, 0.087430f, 0.047322f, 0.100791f, 0.227391f, 0.262999f, 0.206905f, 0.264629f,
0.008515f, 0.010391f, 0.004060f, 0.014833f, 0.010690f, 0.015834f, 0.008428f, 0.015935f, 0.018066f, 0.024885f, 0.012535f, 0.032921f, 0.034927f, 0.045954f, 0.033647f, 0.053063f,
0.376732f, 0.484717f, 0.202064f, 0.454396f, 0.310496f, 0.484877f, 0.275381f, 0.320477f, 0.360819f, 0.524018f, 0.281629f, 0.455282f, 1.130902f, 1.568815f, 1.225522f, 1.189677f,
0.121836f, 0.156986f, 0.081113f, 0.153841f, 0.108089f, 0.169039f, 0.118991f, 0.116793f, 0.229377f, 0.333608f, 0.222226f, 0.302995f, 0.297344f, 0.413081f, 0.399955f, 0.327459f,
0.895292f, 0.992064f, 0.483945f, 0.970039f, 0.522443f, 0.702641f, 0.466973f, 0.484398f, 0.812723f, 1.016527f, 0.639302f, 0.921206f, 2.052165f, 2.451761f, 2.241213f, 1.939274f,
0.142922f, 0.180158f, 0.081792f, 0.202156f, 0.191114f, 0.292394f, 0.180853f, 0.231323f, 0.296709f, 0.422171f, 0.247100f, 0.439044f, 0.459939f, 0.625097f, 0.531803f, 0.567402f,
0.000795f, 0.000994f, 0.001525f, 0.005183f, 0.000504f, 0.000765f, 0.001599f, 0.002812f, 0.000017f, 0.000024f, 0.000047f, 0.000115f, 0.000938f, 0.001265f, 0.003637f, 0.005337f,
0.000341f, 0.000428f, 0.000813f, 0.002331f, 0.000233f, 0.000354f, 0.000918f, 0.001361f, 0.000014f, 0.000020f, 0.000049f, 0.000102f, 0.000328f, 0.000442f, 0.001577f, 0.001952f,
0.003619f, 0.003897f, 0.006999f, 0.021204f, 0.001624f, 0.002123f, 0.005195f, 0.008144f, 0.000073f, 0.000088f, 0.000204f, 0.000445f, 0.003262f, 0.003788f, 0.012748f, 0.016671f,
0.000028f, 0.000035f, 0.000058f, 0.000218f, 0.000029f, 0.000044f, 0.000099f, 0.000192f, 0.000001f, 0.000002f, 0.000004f, 0.000010f, 0.000036f, 0.000048f, 0.000149f, 0.000241f,
0.286771f, 0.387160f, 0.146937f, 0.430460f, 0.230864f, 0.378294f, 0.195602f, 0.296546f, 0.263771f, 0.401960f, 0.196678f, 0.414204f, 0.760577f, 1.107105f, 0.787372f, 0.995734f,
0.097079f, 0.131252f, 0.061741f, 0.152551f, 0.084125f, 0.138048f, 0.088471f, 0.113124f, 0.175523f, 0.267867f, 0.162449f, 0.288545f, 0.209326f, 0.305138f, 0.268977f, 0.286890f,
1.014972f, 1.180126f, 0.524114f, 1.368595f, 0.578529f, 0.816429f, 0.493990f, 0.667550f, 0.884845f, 1.161295f, 0.664923f, 1.248181f, 2.055497f, 2.576806f, 2.144513f, 2.417353f,
0.105925f, 0.140104f, 0.057909f, 0.186458f, 0.138353f, 0.222107f, 0.125072f, 0.208406f, 0.211185f, 0.315298f, 0.168015f, 0.388900f, 0.301172f, 0.429497f, 0.332664f, 0.462382f,
0.177993f, 0.215843f, 0.085131f, 0.229958f, 0.140275f, 0.206458f, 0.110940f, 0.155082f, 0.117641f, 0.161025f, 0.081880f, 0.158998f, 0.406517f, 0.531499f, 0.392830f, 0.458062f,
0.236337f, 0.287007f, 0.140305f, 0.319645f, 0.200488f, 0.295508f, 0.196812f, 0.232041f, 0.307046f, 0.420887f, 0.265263f, 0.434439f, 0.438830f, 0.574578f, 0.526353f, 0.517649f,
0.965408f, 1.008238f, 0.465341f, 1.120412f, 0.538689f, 0.682824f, 0.429358f, 0.534986f, 0.604765f, 0.712918f, 0.424209f, 0.734248f, 1.683607f, 1.895760f, 1.639612f, 1.704157f,
0.079810f, 0.094818f, 0.040729f, 0.120917f, 0.102048f, 0.147149f, 0.086113f, 0.132304f, 0.114337f, 0.153328f, 0.084910f, 0.181221f, 0.195408f, 0.250303f, 0.201476f, 0.258211f,
3.817794f, 4.782230f, 2.191652f, 4.005161f, 3.204754f, 4.872273f, 3.042109f, 2.877001f, 2.469094f, 3.491055f, 2.062666f, 2.709783f, 6.841082f, 9.239177f, 7.934572f, 6.259424f,
2.427481f, 3.045107f, 1.729698f, 2.665979f, 2.193408f, 3.339527f, 2.584371f, 2.061380f, 3.086019f, 4.369645f, 3.199964f, 3.545591f, 3.536378f, 4.782951f, 5.091113f, 3.387363f,
9.059423f, 9.773217f, 5.241244f, 8.537504f, 5.384347f, 7.049997f, 5.150957f, 4.342115f, 5.553247f, 6.762153f, 4.675338f, 5.474780f, 12.395600f, 14.417680f, 14.489090f, 10.188270f,
1.092810f, 1.341106f, 0.669358f, 1.344432f, 1.488323f, 2.216839f, 1.507411f, 1.566855f, 1.531952f, 2.122093f, 1.365498f, 1.971644f, 2.099261f, 2.777635f, 2.597883f, 2.252488f,
0.001096f, 0.001334f, 0.002251f, 0.006218f, 0.000708f, 0.001046f, 0.002404f, 0.003436f, 0.000016f, 0.000022f, 0.000047f, 0.000093f, 0.000772f, 0.001014f, 0.003206f, 0.003822f,
0.000926f, 0.001129f, 0.002361f, 0.005499f, 0.000644f, 0.000952f, 0.002713f, 0.003271f, 0.000026f, 0.000036f, 0.000097f, 0.000162f, 0.000530f, 0.000697f, 0.002733f, 0.002748f,
0.004984f, 0.005226f, 0.010318f, 0.025401f, 0.002278f, 0.002900f, 0.007799f, 0.009936f, 0.000068f, 0.000080f, 0.000204f, 0.000360f, 0.002682f, 0.003032f, 0.011218f, 0.011921f,
0.000030f, 0.000035f, 0.000065f, 0.000197f, 0.000031f, 0.000045f, 0.000113f, 0.000177f, 0.000001f, 0.000001f, 0.000003f, 0.000006f, 0.000022f, 0.000029f, 0.000099f, 0.000130f,
2.241948f, 2.946745f, 1.229492f, 2.927044f, 1.838249f, 2.932514f, 1.666960f, 2.053741f, 1.392470f, 2.065874f, 1.111266f, 1.901862f, 3.549385f, 5.029914f, 3.932717f, 4.041651f,
1.492153f, 1.964080f, 1.015708f, 2.039438f, 1.316962f, 2.103962f, 1.482346f, 1.540310f, 1.821761f, 2.706687f, 1.804591f, 2.604820f, 1.920576f, 2.725635f, 2.641353f, 2.289447f,
7.923192f, 8.968837f, 4.379000f, 9.292375f, 4.599696f, 6.319517f, 4.203634f, 4.616294f, 4.664250f, 5.959623f, 3.751360f, 5.722657f, 9.578170f, 11.689850f, 10.695400f, 9.797409f,
0.624818f, 0.804583f, 0.365601f, 0.956629f, 0.831193f, 1.299087f, 0.804225f, 1.089005f, 0.841180f, 1.222664f, 0.716268f, 1.347313f, 1.060450f, 1.472305f, 1.253673f, 1.416062f,
0.177101f, 0.221854f, 0.100444f, 0.209000f, 0.125047f, 0.190126f, 0.117273f, 0.126281f, 0.123318f, 0.174371f, 0.101780f, 0.152244f, 0.373380f, 0.504300f, 0.427853f, 0.384307f,
0.158584f, 0.198946f, 0.111639f, 0.195919f, 0.120530f, 0.183523f, 0.140305f, 0.127424f, 0.217061f, 0.307368f, 0.222368f, 0.280537f, 0.271819f, 0.367660f, 0.386615f, 0.292888f,
1.026053f, 1.106972f, 0.586473f, 1.087723f, 0.512949f, 0.671676f, 0.484812f, 0.465330f, 0.677168f, 0.824639f, 0.563257f, 0.750990f, 1.651791f, 1.921378f, 1.907539f, 1.527236f,
0.087166f, 0.106978f, 0.052748f, 0.120631f, 0.099855f, 0.148744f, 0.099920f, 0.118255f, 0.131561f, 0.182254f, 0.115856f, 0.190471f, 0.197009f, 0.260691f, 0.240871f, 0.237794f,
3.741116f, 4.840989f, 2.546702f, 3.585013f, 2.813592f, 4.418887f, 3.167080f, 2.307218f, 2.549044f, 3.723155f, 2.525145f, 2.555384f, 6.188271f, 8.633617f, 8.511103f, 5.172030f,
1.604190f, 2.078823f, 1.355464f, 1.609307f, 1.298665f, 2.042573f, 1.814473f, 1.114854f, 2.148570f, 3.142766f, 2.641885f, 2.254871f, 2.157320f, 3.014163f, 3.682871f, 1.887555f,
9.482695f, 10.567780f, 6.505543f, 8.162897f, 5.049426f, 6.829877f, 5.728155f, 3.719567f, 6.123915f, 7.703394f, 6.113826f, 5.514815f, 11.977190f, 14.391210f, 16.601460f, 8.992273f,
1.175455f, 1.490182f, 0.853763f, 1.320937f, 1.434287f, 2.206927f, 1.722616f, 1.379272f, 1.736030f, 2.484228f, 1.834936f, 2.040904f, 2.084411f, 2.849096f, 3.058824f, 2.042968f,
0.013173f, 0.016568f, 0.032089f, 0.068269f, 0.007620f, 0.011632f, 0.030693f, 0.033793f, 0.000198f, 0.000282f, 0.000704f, 0.001076f, 0.008570f, 0.011620f, 0.042175f, 0.038733f,
0.007505f, 0.009453f, 0.022693f, 0.040718f, 0.004673f, 0.007144f, 0.023365f, 0.021696f, 0.000222f, 0.000316f, 0.000978f, 0.001261f, 0.003969f, 0.005390f, 0.024248f, 0.018782f,
0.063989f, 0.069311f, 0.157087f, 0.297889f, 0.026208f, 0.034454f, 0.106385f, 0.104403f, 0.000914f, 0.001117f, 0.003264f, 0.004450f, 0.031785f, 0.037120f, 0.157650f, 0.129054f,
0.000391f, 0.000482f, 0.001017f, 0.002377f, 0.000367f, 0.000549f, 0.001578f, 0.001909f, 0.000013f, 0.000018f, 0.000048f, 0.000081f, 0.000273f, 0.000362f, 0.001433f, 0.001446f,
4.067536f, 5.522850f, 2.645143f, 4.850842f, 2.988049f, 4.924232f, 3.213117f, 3.049378f, 2.661599f, 4.079205f, 2.518794f, 3.320609f, 5.944492f, 8.702362f, 7.810380f, 6.183048f,
1.825705f, 2.482511f, 1.473682f, 2.279343f, 1.443671f, 2.382581f, 1.926914f, 1.542358f, 2.348332f, 3.604301f, 2.758448f, 3.067100f, 2.169225f, 3.180209f, 3.537670f, 2.362032f,
15.354960f, 17.955580f, 10.063320f, 16.449670f, 7.986476f, 11.335090f, 8.655035f, 7.321528f, 9.523162f, 12.569940f, 9.082511f, 10.672820f, 17.135110f, 21.603710f, 22.689190f, 16.010230f,
1.244319f, 1.655251f, 0.863384f, 1.740219f, 1.483058f, 2.394468f, 1.701576f, 1.774876f, 1.764893f, 2.650034f, 1.782062f, 2.582140f, 1.949505f, 2.796064f, 2.732979f, 2.377928f,
0.241019f, 0.267798f, 0.118584f, 0.319301f, 0.201864f, 0.272228f, 0.164231f, 0.228847f, 0.167938f, 0.210623f, 0.120242f, 0.232749f, 0.506368f, 0.606614f, 0.503363f, 0.585082f,
0.239678f, 0.266694f, 0.146372f, 0.332407f, 0.216081f, 0.291823f, 0.218207f, 0.256446f, 0.328280f, 0.412316f, 0.291748f, 0.476295f, 0.409387f, 0.491144f, 0.505131f, 0.495197f,
0.943189f, 0.902555f, 0.467680f, 1.122459f, 0.559314f, 0.649605f, 0.458593f, 0.569594f, 0.622900f, 0.672813f, 0.449470f, 0.775496f, 1.513102f, 1.561111f, 1.515858f, 1.570515f,
0.075914f, 0.082637f, 0.039852f, 0.117939f, 0.103157f, 0.136293f, 0.089546f, 0.137142f, 0.114655f, 0.140881f, 0.087590f, 0.186345f, 0.170980f, 0.200674f, 0.181349f, 0.231676f,
7.403310f, 8.497022f, 4.371947f, 7.964131f, 6.604479f, 9.200220f, 6.449239f, 6.079793f, 5.047719f, 6.539386f, 4.337867f, 5.680635f, 12.203320f, 15.101130f, 14.560180f, 11.449660f,
3.525489f, 4.052182f, 2.584185f, 3.970317f, 3.385426f, 4.722823f, 4.103350f, 3.262548f, 4.725047f, 6.130229f, 5.040140f, 5.566744f, 4.724568f, 5.854937f, 6.996906f, 4.640557f,
12.675190f, 12.528940f, 7.543589f, 12.248690f, 8.006030f, 9.604968f, 7.878834f, 6.620495f, 8.191150f, 9.139148f, 7.094156f, 8.280747f, 15.953700f, 17.002460f, 19.183360f, 13.446180f,
1.488583f, 1.673840f, 0.937943f, 1.877898f, 2.154545f, 2.940462f, 2.244813f, 2.325907f, 2.199974f, 2.792284f, 2.017219f, 2.903392f, 2.630477f, 3.189085f, 3.348710f, 2.894246f,
0.001260f, 0.001406f, 0.002663f, 0.007332f, 0.000865f, 0.001171f, 0.003022f, 0.004305f, 0.000019f, 0.000024f, 0.000058f, 0.000116f, 0.000817f, 0.000983f, 0.003488f, 0.004145f,
0.000797f, 0.000891f, 0.002092f, 0.004856f, 0.000589f, 0.000799f, 0.002554f, 0.003069f, 0.000024f, 0.000030f, 0.000090f, 0.000151f, 0.000420f, 0.000506f, 0.002227f, 0.002232f,
0.004135f, 0.003973f, 0.008806f, 0.021610f, 0.002009f, 0.002342f, 0.007074f, 0.008984f, 0.000059f, 0.000064f, 0.000183f, 0.000323f, 0.002047f, 0.002120f, 0.008807f, 0.009329f,
0.000024f, 0.000026f, 0.000054f, 0.000163f, 0.000027f, 0.000035f, 0.000099f, 0.000156f, 0.000001f, 0.000001f, 0.000003f, 0.000006f, 0.000017f, 0.000020f, 0.000076f, 0.000099f,
3.455431f, 4.161424f, 1.949360f, 4.626055f, 3.011003f, 4.401187f, 2.808808f, 3.449512f, 2.262594f, 3.075724f, 1.857499f, 3.168871f, 5.032335f, 6.534312f, 5.735866f, 5.875980f,
1.722425f, 2.077345f, 1.206106f, 2.414027f, 1.615587f, 2.364927f, 1.870668f, 1.937627f, 2.216982f, 3.018086f, 2.259121f, 3.250525f, 2.039380f, 2.651900f, 2.885246f, 2.492885f,
8.810837f, 9.138522f, 5.009354f, 10.596160f, 5.435962f, 6.843119f, 5.110484f, 5.594300f, 5.468181f, 6.401808f, 4.524178f, 6.879608f, 9.798044f, 10.956930f, 11.254950f, 10.277160f,
0.676464f, 0.798150f, 0.407183f, 1.062037f, 0.956365f, 1.369565f, 0.951895f, 1.284863f, 0.960118f, 1.278691f, 0.841010f, 1.576917f, 1.056140f, 1.343544f, 1.284415f, 1.446167f,
0.228433f, 0.284531f, 0.102080f, 0.339311f, 0.142050f, 0.214750f, 0.104965f, 0.180559f, 0.193486f, 0.272033f, 0.125825f, 0.300661f, 0.529028f, 0.710461f, 0.477641f, 0.685360f,
0.185240f, 0.231065f, 0.102748f, 0.288048f, 0.123993f, 0.187723f, 0.113725f, 0.164994f, 0.308420f, 0.434253f, 0.248950f, 0.501722f, 0.348774f, 0.469066f, 0.390861f, 0.473018f,
1.229731f, 1.319169f, 0.553819f, 1.640859f, 0.541431f, 0.704941f, 0.403202f, 0.618219f, 0.987239f, 1.195401f, 0.647012f, 1.378074f, 2.174626f, 2.515159f, 1.978710f, 2.530742f,
0.100062f, 0.122107f, 0.047710f, 0.174299f, 0.100954f, 0.149525f, 0.079594f, 0.150482f, 0.183711f, 0.253051f, 0.127469f, 0.334772f, 0.248427f, 0.326859f, 0.239318f, 0.377420f,
3.591150f, 4.620509f, 1.926149f, 4.331472f, 2.378605f, 3.714476f, 2.109598f, 2.455060f, 2.976427f, 4.322674f, 2.323185f, 3.755662f, 6.525153f, 9.051854f, 7.071096f, 6.864277f,
1.394519f, 1.796840f, 0.928402f, 1.760840f, 0.994248f, 1.554886f, 1.094529f, 1.074305f, 2.271976f, 3.304378f, 2.201140f, 3.001154f, 2.060024f, 2.861856f, 2.770917f, 2.268661f,
8.457960f, 9.372188f, 4.571901f, 9.164115f, 3.966475f, 5.334564f, 3.545332f, 3.677625f, 6.644290f, 8.310457f, 5.226512f, 7.531175f, 11.734850f, 14.019860f, 12.815880f, 11.089310f,
1.004205f, 1.265840f, 0.574689f, 1.420400f, 1.079148f, 1.651036f, 1.021205f, 1.306193f, 1.804094f, 2.566945f, 1.502458f, 2.669542f, 1.956089f, 2.658494f, 2.261722f, 2.413121f,
0.003991f, 0.004991f, 0.007659f, 0.026031f, 0.002033f, 0.003086f, 0.006452f, 0.011348f, 0.000073f, 0.000103f, 0.000204f, 0.000499f, 0.002852f, 0.003845f, 0.011058f, 0.016223f,
0.002059f, 0.002579f, 0.004905f, 0.014060f, 0.001129f, 0.001716f, 0.004448f, 0.006598f, 0.000074f, 0.000105f, 0.000257f, 0.000530f, 0.001196f, 0.001615f, 0.005757f, 0.007124f,
0.018012f, 0.019399f, 0.034839f, 0.105541f, 0.006497f, 0.008493f, 0.020780f, 0.032577f, 0.000313f, 0.000380f, 0.000881f, 0.001918f, 0.009828f, 0.011412f, 0.038407f, 0.050226f,
0.000105f, 0.000129f, 0.000216f, 0.000807f, 0.000087f, 0.000130f, 0.000295f, 0.000571f, 0.000004f, 0.000006f, 0.000012f, 0.000034f, 0.000081f, 0.000107f, 0.000334f, 0.000539f,
3.233650f, 4.365643f, 1.656877f, 4.853903f, 2.092079f, 3.428091f, 1.772542f, 2.687287f, 2.573889f, 3.922348f, 1.919196f, 4.041823f, 5.191171f, 7.556333f, 5.374056f, 6.796191f,
1.314403f, 1.777102f, 0.835951f, 2.065475f, 0.915366f, 1.502096f, 0.962650f, 1.230904f, 2.056567f, 3.138541f, 1.903389f, 3.380832f, 1.715502f, 2.500725f, 2.204366f, 2.351175f,
11.342570f, 13.188210f, 5.857114f, 15.294410f, 5.195736f, 7.332300f, 4.436497f, 5.995231f, 8.557162f, 11.230650f, 6.430341f, 12.070910f, 13.903970f, 17.430250f, 14.506100f, 16.351670f,
0.880394f, 1.164482f, 0.481314f, 1.549750f, 0.924129f, 1.483566f, 0.835421f, 1.392050f, 1.518970f, 2.267805f, 1.208463f, 2.797197f, 1.515161f, 2.160751f, 1.673594f, 2.326191f,
0.021046f, 0.025521f, 0.010066f, 0.027190f, 0.018000f, 0.026492f, 0.014236f, 0.019900f, 0.014587f, 0.019967f, 0.010153f, 0.019715f, 0.044225f, 0.057821f, 0.042736f, 0.049832f,
0.031997f, 0.038857f, 0.018995f, 0.043276f, 0.029457f, 0.043418f, 0.028917f, 0.034093f, 0.043594f, 0.059757f, 0.037662f, 0.061682f, 0.054663f, 0.071572f, 0.065565f, 0.064481f,
0.140039f, 0.146252f, 0.067501f, 0.162524f, 0.084800f, 0.107490f, 0.067589f, 0.084217f, 0.091997f, 0.108450f, 0.064531f, 0.111694f, 0.224697f, 0.253011f, 0.218825f, 0.227439f,
0.016690f, 0.019829f, 0.008517f, 0.025287f, 0.023160f, 0.033395f, 0.019543f, 0.030026f, 0.025075f, 0.033626f, 0.018622f, 0.039743f, 0.037598f, 0.048160f, 0.038766f, 0.049682f,
0.439727f, 0.550810f, 0.252431f, 0.461308f, 0.400576f, 0.609006f, 0.380246f, 0.359609f, 0.298235f, 0.421674f, 0.249143f, 0.327307f, 0.724959f, 0.979089f, 0.840838f, 0.663320f,
0.320138f, 0.401591f, 0.228114f, 0.351591f, 0.313920f, 0.477953f, 0.369875f, 0.295024f, 0.426804f, 0.604333f, 0.442563f, 0.490364f, 0.429099f, 0.580356f, 0.617748f, 0.411017f,
1.280099f, 1.380958f, 0.740589f, 1.206351f, 0.825648f, 1.081062f, 0.789859f, 0.665830f, 0.822885f, 1.002021f, 0.692795f, 0.811257f, 1.611492f, 1.874371f, 1.883656f, 1.324526f,
0.222616f, 0.273196f, 0.136354f, 0.273873f, 0.329024f, 0.490077f, 0.333244f, 0.346385f, 0.327269f, 0.453341f, 0.291710f, 0.421200f, 0.393455f, 0.520599f, 0.486909f, 0.422174f,
0.000023f, 0.000029f, 0.000048f, 0.000133f, 0.000016f, 0.000024f, 0.000056f, 0.000080f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000015f, 0.000020f, 0.000063f, 0.000075f,
0.000023f, 0.000028f, 0.000058f, 0.000135f, 0.000017f, 0.000025f, 0.000072f, 0.000087f, 0.000001f, 0.000001f, 0.000002f, 0.000004f, 0.000012f, 0.000016f, 0.000062f, 0.000062f,
0.000131f, 0.000137f, 0.000271f, 0.000666f, 0.000065f, 0.000083f, 0.000222f, 0.000283f, 0.000002f, 0.000002f, 0.000006f, 0.000010f, 0.000065f, 0.000073f, 0.000271f, 0.000288f,
0.000001f, 0.000001f, 0.000002f, 0.000007f, 0.000001f, 0.000002f, 0.000005f, 0.000007f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000003f, 0.000005f,
0.241574f, 0.317516f, 0.132480f, 0.315394f, 0.214955f, 0.342912f, 0.194925f, 0.240153f, 0.157347f, 0.233441f, 0.125572f, 0.214908f, 0.351880f, 0.498657f, 0.389883f, 0.400682f,
0.184097f, 0.242322f, 0.125315f, 0.251619f, 0.176330f, 0.281702f, 0.198473f, 0.206234f, 0.235708f, 0.350204f, 0.233486f, 0.337024f, 0.218013f, 0.309399f, 0.299832f, 0.259885f,
1.047359f, 1.185582f, 0.578856f, 1.228350f, 0.659847f, 0.906564f, 0.603031f, 0.662229f, 0.646586f, 0.826159f, 0.520036f, 0.793309f, 1.164919f, 1.421746f, 1.300798f, 1.191583f,
0.119074f, 0.153333f, 0.069674f, 0.182309f, 0.171903f, 0.268671f, 0.166326f, 0.225223f, 0.168113f, 0.244354f, 0.143149f, 0.269266f, 0.185939f, 0.258154f, 0.219819f, 0.248292f,
0.010686f, 0.013386f, 0.006060f, 0.012610f, 0.008188f, 0.012449f, 0.007679f, 0.008269f, 0.007803f, 0.011033f, 0.006440f, 0.009633f, 0.020728f, 0.027996f, 0.023752f, 0.021334f,
0.010956f, 0.013744f, 0.007713f, 0.013535f, 0.009037f, 0.013759f, 0.010519f, 0.009554f, 0.015726f, 0.022269f, 0.016111f, 0.020325f, 0.017278f, 0.023370f, 0.024575f, 0.018617f,
0.075950f, 0.081939f, 0.043411f, 0.080515f, 0.041205f, 0.053955f, 0.038945f, 0.037380f, 0.052566f, 0.064013f, 0.043723f, 0.058296f, 0.112494f, 0.130854f, 0.129911f, 0.104011f,
0.009302f, 0.011416f, 0.005629f, 0.012873f, 0.011564f, 0.017226f, 0.011572f, 0.013695f, 0.014723f, 0.020396f, 0.012966f, 0.021316f, 0.019343f, 0.025596f, 0.023650f, 0.023348f,
0.219882f, 0.284526f, 0.149681f, 0.210707f, 0.179460f, 0.281851f, 0.202007f, 0.147162f, 0.157114f, 0.229482f, 0.155641f, 0.157505f, 0.334638f, 0.466873f, 0.460248f, 0.279683f,
0.107958f, 0.139899f, 0.091219f, 0.108302f, 0.094845f, 0.149174f, 0.132516f, 0.081421f, 0.151634f, 0.221799f, 0.186449f, 0.159136f, 0.133576f, 0.186630f, 0.228035f, 0.116873f,
0.683741f, 0.761980f, 0.469076f, 0.588578f, 0.395112f, 0.534431f, 0.448222f, 0.291052f, 0.463061f, 0.582493f, 0.462298f, 0.417004f, 0.794570f, 0.954717f, 1.101345f, 0.596550f,
0.122190f, 0.154906f, 0.088749f, 0.137313f, 0.161802f, 0.248963f, 0.194328f, 0.155595f, 0.189249f, 0.270813f, 0.200031f, 0.222485f, 0.199356f, 0.272491f, 0.292550f, 0.195392f,
0.000144f, 0.000181f, 0.000350f, 0.000745f, 0.000090f, 0.000138f, 0.000363f, 0.000400f, 0.000002f, 0.000003f, 0.000008f, 0.000012f, 0.000086f, 0.000117f, 0.000423f, 0.000389f,
0.000094f, 0.000118f, 0.000283f, 0.000509f, 0.000063f, 0.000097f, 0.000317f, 0.000294f, 0.000003f, 0.000004f, 0.000013f, 0.000017f, 0.000046f, 0.000062f, 0.000279f, 0.000216f,
0.000856f, 0.000927f, 0.002102f, 0.003986f, 0.000381f, 0.000500f, 0.001545f, 0.001516f, 0.000013f, 0.000016f, 0.000046f, 0.000062f, 0.000391f, 0.000457f, 0.001941f, 0.001589f,
0.000008f, 0.000009f, 0.000020f, 0.000046f, 0.000008f, 0.000011f, 0.000033f, 0.000040f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000005f, 0.000006f, 0.000025f, 0.000026f,
0.223652f, 0.303672f, 0.145442f, 0.266722f, 0.178298f, 0.293831f, 0.191728f, 0.181958f, 0.153473f, 0.235215f, 0.145239f, 0.191473f, 0.300727f, 0.440246f, 0.395121f, 0.312796f,
0.114943f, 0.156294f, 0.092780f, 0.143503f, 0.098637f, 0.162786f, 0.131653f, 0.105379f, 0.155046f, 0.237969f, 0.182123f, 0.202501f, 0.125653f, 0.184215f, 0.204921f, 0.136821f,
1.035765f, 1.211189f, 0.678819f, 1.109609f, 0.584638f, 0.829767f, 0.633578f, 0.535961f, 0.673663f, 0.889190f, 0.642492f, 0.754989f, 1.063449f, 1.340782f, 1.408151f, 0.993637f,
0.121008f, 0.160970f, 0.083962f, 0.169233f, 0.156516f, 0.252702f, 0.179577f, 0.187313f, 0.179990f, 0.270260f, 0.181741f, 0.263336f, 0.174431f, 0.250176f, 0.244531f, 0.212763f,
0.004201f, 0.004668f, 0.002067f, 0.005566f, 0.003818f, 0.005150f, 0.003107f, 0.004329f, 0.003070f, 0.003850f, 0.002198f, 0.004255f, 0.008121f, 0.009728f, 0.008073f, 0.009383f,
0.004784f, 0.005323f, 0.002921f, 0.006634f, 0.004680f, 0.006321f, 0.004726f, 0.005554f, 0.006871f, 0.008630f, 0.006106f, 0.009969f, 0.007518f, 0.009019f, 0.009276f, 0.009093f,
0.020169f, 0.019300f, 0.010001f, 0.024003f, 0.012980f, 0.015075f, 0.010642f, 0.013218f, 0.013969f, 0.015088f, 0.010079f, 0.017391f, 0.029770f, 0.030714f, 0.029824f, 0.030899f,
0.002340f, 0.002548f, 0.001229f, 0.003636f, 0.003451f, 0.004560f, 0.002996f, 0.004588f, 0.003707f, 0.004555f, 0.002832f, 0.006025f, 0.004850f, 0.005692f, 0.005144f, 0.006571f,
0.125703f, 0.144273f, 0.074232f, 0.135225f, 0.121696f, 0.169526f, 0.118835f, 0.112028f, 0.089880f, 0.116441f, 0.077240f, 0.101150f, 0.190640f, 0.235910f, 0.227459f, 0.178867f,
0.068541f, 0.078780f, 0.050240f, 0.077189f, 0.071427f, 0.099644f, 0.086574f, 0.068834f, 0.096335f, 0.124984f, 0.102759f, 0.113496f, 0.084510f, 0.104729f, 0.125156f, 0.083007f,
0.264025f, 0.260979f, 0.157134f, 0.255141f, 0.180978f, 0.217123f, 0.178103f, 0.149658f, 0.178931f, 0.199639f, 0.154968f, 0.180888f, 0.305752f, 0.325852f, 0.367649f, 0.257696f,
0.044703f, 0.050266f, 0.028167f, 0.056394f, 0.070216f, 0.095828f, 0.073157f, 0.075800f, 0.069283f, 0.087936f, 0.063527f, 0.091435f, 0.072679f, 0.088113f, 0.092524f, 0.079967f,
0.000004f, 0.000004f, 0.000008f, 0.000023f, 0.000003f, 0.000004f, 0.000010f, 0.000015f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000002f, 0.000003f, 0.000010f, 0.000012f,
0.000003f, 0.000003f, 0.000008f, 0.000018f, 0.000002f, 0.000003f, 0.000010f, 0.000012f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000002f, 0.000007f, 0.000007f,
0.000016f, 0.000015f, 0.000034f, 0.000084f, 0.000008f, 0.000010f, 0.000030f, 0.000038f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000007f, 0.000008f, 0.000031f, 0.000033f,
0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f,
0.054888f, 0.066102f, 0.030964f, 0.073482f, 0.051904f, 0.075868f, 0.048419f, 0.059463f, 0.037690f, 0.051235f, 0.030942f, 0.052787f, 0.073546f, 0.095497f, 0.083828f, 0.085876f,
0.031327f, 0.037782f, 0.021936f, 0.043906f, 0.031888f, 0.046679f, 0.036923f, 0.038245f, 0.042286f, 0.057565f, 0.043089f, 0.061999f, 0.034127f, 0.044377f, 0.048282f, 0.041716f,
0.171696f, 0.178082f, 0.097617f, 0.206487f, 0.114958f, 0.144716f, 0.108075f, 0.118306f, 0.111747f, 0.130826f, 0.092455f, 0.140591f, 0.175671f, 0.196449f, 0.201792f, 0.184261f,
0.019005f, 0.022423f, 0.011439f, 0.029837f, 0.029158f, 0.041755f, 0.029021f, 0.039173f, 0.028287f, 0.037673f, 0.024778f, 0.046459f, 0.027299f, 0.034728f, 0.033200f, 0.037381f,
0.013775f, 0.017158f, 0.006156f, 0.020461f, 0.009296f, 0.014054f, 0.006869f, 0.011816f, 0.012236f, 0.017203f, 0.007957f, 0.019013f, 0.029352f, 0.039418f, 0.026500f, 0.038025f,
0.012790f, 0.015954f, 0.007094f, 0.019889f, 0.009291f, 0.014066f, 0.008522f, 0.012363f, 0.022332f, 0.031444f, 0.018026f, 0.036329f, 0.022157f, 0.029799f, 0.024830f, 0.030050f,
0.090974f, 0.097590f, 0.040971f, 0.121388f, 0.043468f, 0.056595f, 0.032370f, 0.049633f, 0.076591f, 0.092740f, 0.050196f, 0.106912f, 0.148016f, 0.171194f, 0.134681f, 0.172255f,
0.010672f, 0.013023f, 0.005088f, 0.018590f, 0.011685f, 0.017306f, 0.009212f, 0.017417f, 0.020547f, 0.028303f, 0.014257f, 0.037443f, 0.024378f, 0.032074f, 0.023484f, 0.037035f,
0.210946f, 0.271411f, 0.113143f, 0.254433f, 0.151628f, 0.236785f, 0.134480f, 0.156502f, 0.183351f, 0.266281f, 0.143110f, 0.231352f, 0.352652f, 0.489208f, 0.382157f, 0.370980f,
0.093793f, 0.120853f, 0.062443f, 0.118432f, 0.072571f, 0.113492f, 0.079890f, 0.078414f, 0.160251f, 0.233070f, 0.155255f, 0.211683f, 0.127479f, 0.177098f, 0.171470f, 0.140390f,
0.609503f, 0.675384f, 0.329463f, 0.660390f, 0.310194f, 0.417184f, 0.277259f, 0.287605f, 0.502120f, 0.628035f, 0.394976f, 0.569144f, 0.778046f, 0.929546f, 0.849720f, 0.735245f,
0.104328f, 0.131509f, 0.059705f, 0.147567f, 0.121668f, 0.186146f, 0.115136f, 0.147267f, 0.196556f, 0.279669f, 0.163693f, 0.290847f, 0.186975f, 0.254116f, 0.216190f, 0.230661f,
0.000044f, 0.000054f, 0.000083f, 0.000284f, 0.000024f, 0.000037f, 0.000076f, 0.000134f, 0.000001f, 0.000001f, 0.000002f, 0.000006f, 0.000029f, 0.000039f, 0.000111f, 0.000163f,
0.000026f, 0.000032f, 0.000061f, 0.000175f, 0.000015f, 0.000023f, 0.000060f, 0.000089f, 0.000001f, 0.000001f, 0.000003f, 0.000007f, 0.000014f, 0.000019f, 0.000066f, 0.000082f,
0.000241f, 0.000259f, 0.000466f, 0.001411f, 0.000094f, 0.000123f, 0.000302f, 0.000473f, 0.000004f, 0.000005f, 0.000012f, 0.000027f, 0.000121f, 0.000140f, 0.000473f, 0.000618f,
0.000002f, 0.000002f, 0.000004f, 0.000016f, 0.000002f, 0.000003f, 0.000006f, 0.000012f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000002f, 0.000006f, 0.000010f,
0.177699f, 0.239905f, 0.091050f, 0.266736f, 0.124764f, 0.204438f, 0.105708f, 0.160259f, 0.148330f, 0.226040f, 0.110601f, 0.232926f, 0.262466f, 0.382049f, 0.271713f, 0.343616f,
0.082704f, 0.111818f, 0.052600f, 0.129963f, 0.062505f, 0.102569f, 0.065734f, 0.084051f, 0.135704f, 0.207099f, 0.125596f, 0.223086f, 0.099314f, 0.144772f, 0.127615f, 0.136114f,
0.764670f, 0.889096f, 0.394863f, 1.031087f, 0.380127f, 0.536441f, 0.324580f, 0.438619f, 0.604981f, 0.793993f, 0.454617f, 0.853398f, 0.862420f, 1.081145f, 0.899768f, 1.014243f,
0.085567f, 0.113178f, 0.046780f, 0.150623f, 0.097473f, 0.156479f, 0.088116f, 0.146826f, 0.154821f, 0.231146f, 0.123172f, 0.285104f, 0.135490f, 0.193220f, 0.149657f, 0.208015f,
0.031166f, 0.037793f, 0.014906f, 0.040264f, 0.032989f, 0.048553f, 0.026090f, 0.036471f, 0.026709f, 0.036559f, 0.018590f, 0.036098f, 0.073100f, 0.095574f, 0.070639f, 0.082369f,
0.040040f, 0.048624f, 0.023770f, 0.054154f, 0.045620f, 0.067242f, 0.044784f, 0.052800f, 0.067450f, 0.092459f, 0.058272f, 0.095436f, 0.076352f, 0.099970f, 0.091580f, 0.090066f,
0.155911f, 0.162827f, 0.075151f, 0.180943f, 0.116846f, 0.148110f, 0.093131f, 0.116043f, 0.126641f, 0.149289f, 0.088831f, 0.153755f, 0.279235f, 0.314422f, 0.271938f, 0.282643f,
0.020011f, 0.023774f, 0.010212f, 0.030318f, 0.034365f, 0.049553f, 0.028999f, 0.044554f, 0.037172f, 0.049848f, 0.027605f, 0.058916f, 0.050317f, 0.064452f, 0.051879f, 0.066488f,
0.496452f, 0.621864f, 0.284994f, 0.520817f, 0.559720f, 0.850957f, 0.531313f, 0.502477f, 0.416318f, 0.588633f, 0.347790f, 0.456901f, 0.913596f, 1.233851f, 1.059627f, 0.835918f,
0.305425f, 0.383135f, 0.217630f, 0.335433f, 0.370663f, 0.564346f, 0.436732f, 0.348352f, 0.503467f, 0.712883f, 0.522056f, 0.578443f, 0.456954f, 0.618030f, 0.657850f, 0.437699f,
1.086565f, 1.172176f, 0.628622f, 1.023968f, 0.867360f, 1.135678f, 0.829764f, 0.699468f, 0.863625f, 1.051631f, 0.727095f, 0.851422f, 1.526819f, 1.775886f, 1.784683f, 1.254932f,
0.203489f, 0.249724f, 0.124639f, 0.250343f, 0.372225f, 0.554424f, 0.376999f, 0.391865f, 0.369884f, 0.512371f, 0.329694f, 0.476045f, 0.401447f, 0.531174f, 0.496799f, 0.430749f,
0.000190f, 0.000232f, 0.000391f, 0.001079f, 0.000165f, 0.000244f, 0.000560f, 0.000801f, 0.000004f, 0.000005f, 0.000011f, 0.000021f, 0.000138f, 0.000181f, 0.000571f, 0.000681f,
0.000156f, 0.000190f, 0.000397f, 0.000924f, 0.000145f, 0.000215f, 0.000612f, 0.000738f, 0.000006f, 0.000008f, 0.000021f, 0.000035f, 0.000092f, 0.000120f, 0.000471f, 0.000474f,
0.000798f, 0.000837f, 0.001652f, 0.004067f, 0.000490f, 0.000623f, 0.001677f, 0.002137f, 0.000014f, 0.000017f, 0.000042f, 0.000075f, 0.000441f, 0.000499f, 0.001844f, 0.001960f,
0.000007f, 0.000009f, 0.000016f, 0.000049f, 0.000010f, 0.000015f, 0.000038f, 0.000059f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000006f, 0.000007f, 0.000025f, 0.000033f,
0.380443f, 0.500042f, 0.208636f, 0.496699f, 0.418966f, 0.668367f, 0.379927f, 0.468081f, 0.306389f, 0.454559f, 0.244515f, 0.418471f, 0.618559f, 0.876575f, 0.685363f, 0.704348f,
0.244998f, 0.322483f, 0.166770f, 0.334856f, 0.290424f, 0.463978f, 0.326896f, 0.339678f, 0.387849f, 0.576248f, 0.384194f, 0.554560f, 0.323850f, 0.459601f, 0.445389f, 0.386050f,
1.240093f, 1.403752f, 0.685376f, 1.454390f, 0.966928f, 1.328462f, 0.883670f, 0.970418f, 0.946583f, 1.209472f, 0.761317f, 1.161381f, 1.539576f, 1.879004f, 1.719157f, 1.574816f,
0.151827f, 0.195509f, 0.088839f, 0.232455f, 0.271274f, 0.423980f, 0.262473f, 0.355416f, 0.265038f, 0.385235f, 0.225681f, 0.424509f, 0.264637f, 0.367416f, 0.312856f, 0.353380f,
0.019566f, 0.024511f, 0.011097f, 0.023090f, 0.018555f, 0.028212f, 0.017402f, 0.018739f, 0.017666f, 0.024979f, 0.014580f, 0.021810f, 0.042364f, 0.057219f, 0.048545f, 0.043604f,
0.016952f, 0.021267f, 0.011934f, 0.020943f, 0.017305f, 0.026349f, 0.020144f, 0.018295f, 0.030087f, 0.042604f, 0.030822f, 0.038885f, 0.029841f, 0.040363f, 0.042444f, 0.032154f,
0.104555f, 0.112801f, 0.059762f, 0.110840f, 0.070204f, 0.091928f, 0.066353f, 0.063687f, 0.089474f, 0.108959f, 0.074423f, 0.099228f, 0.172861f, 0.201073f, 0.199625f, 0.159826f,
0.013790f, 0.016924f, 0.008345f, 0.019084f, 0.021218f, 0.031606f, 0.021231f, 0.025128f, 0.026988f, 0.037387f, 0.023766f, 0.039072f, 0.032009f, 0.042355f, 0.039135f, 0.038635f,
0.306958f, 0.397202f, 0.208956f, 0.294150f, 0.310063f, 0.486969f, 0.349018f, 0.254259f, 0.271192f, 0.396106f, 0.268650f, 0.271867f, 0.521448f, 0.727503f, 0.717179f, 0.435816f,
0.127356f, 0.165036f, 0.107609f, 0.127762f, 0.138475f, 0.217796f, 0.193474f, 0.118875f, 0.221174f, 0.323517f, 0.271956f, 0.232117f, 0.175890f, 0.245750f, 0.300271f, 0.153896f,
0.717628f, 0.799745f, 0.492324f, 0.617749f, 0.513240f, 0.694211f, 0.582229f, 0.378069f, 0.600924f, 0.755915f, 0.599934f, 0.541155f, 0.930866f, 1.118484f, 1.290264f, 0.698879f,
0.138107f, 0.175085f, 0.100311f, 0.155200f, 0.226337f, 0.348264f, 0.271837f, 0.217656f, 0.264478f, 0.378463f, 0.279546f, 0.310924f, 0.251511f, 0.343780f, 0.369087f, 0.246510f,
0.001443f, 0.001815f, 0.003515f, 0.007477f, 0.001121f, 0.001711f, 0.004515f, 0.004971f, 0.000028f, 0.000040f, 0.000100f, 0.000153f, 0.000964f, 0.001307f, 0.004744f, 0.004357f,
0.000795f, 0.001002f, 0.002405f, 0.004315f, 0.000665f, 0.001017f, 0.003326f, 0.003088f, 0.000031f, 0.000043f, 0.000134f, 0.000173f, 0.000432f, 0.000587f, 0.002639f, 0.002044f,
0.006464f, 0.007002f, 0.015869f, 0.030093f, 0.003556f, 0.004675f, 0.014434f, 0.014165f, 0.000120f, 0.000146f, 0.000428f, 0.000583f, 0.003298f, 0.003851f, 0.016355f, 0.013389f,
0.000061f, 0.000076f, 0.000159f, 0.000373f, 0.000077f, 0.000116f, 0.000332f, 0.000402f, 0.000003f, 0.000004f, 0.000010f, 0.000017f, 0.000044f, 0.000058f, 0.000231f, 0.000233f,
0.435520f, 0.591343f, 0.283221f, 0.519390f, 0.429710f, 0.708151f, 0.462077f, 0.438529f, 0.369523f, 0.566337f, 0.349697f, 0.461017f, 0.653665f, 0.956925f, 0.858841f, 0.679897f,
0.189143f, 0.257189f, 0.152674f, 0.236141f, 0.200882f, 0.331527f, 0.268123f, 0.214614f, 0.315459f, 0.484178f, 0.370551f, 0.412013f, 0.230797f, 0.338361f, 0.376394f, 0.251311f,
1.516405f, 1.773234f, 0.993820f, 1.624515f, 1.059334f, 1.503497f, 1.148012f, 0.971135f, 1.219469f, 1.609617f, 1.163042f, 1.366686f, 1.737873f, 2.191086f, 2.301178f, 1.623786f,
0.190783f, 0.253788f, 0.132377f, 0.266816f, 0.305406f, 0.493092f, 0.350405f, 0.365500f, 0.350872f, 0.526845f, 0.354286f, 0.513347f, 0.306971f, 0.440271f, 0.430337f, 0.374431f,
0.054962f, 0.061068f, 0.027042f, 0.072813f, 0.061827f, 0.083378f, 0.050301f, 0.070091f, 0.049657f, 0.062278f, 0.035554f, 0.068821f, 0.118587f, 0.142064f, 0.117884f, 0.137022f,
0.052884f, 0.058844f, 0.032296f, 0.073344f, 0.064035f, 0.086482f, 0.064665f, 0.075998f, 0.093920f, 0.117963f, 0.083469f, 0.136267f, 0.092766f, 0.111293f, 0.114462f, 0.112211f,
0.198380f, 0.189833f, 0.098367f, 0.236085f, 0.158003f, 0.183510f, 0.129550f, 0.160907f, 0.169879f, 0.183491f, 0.122581f, 0.211495f, 0.326837f, 0.337207f, 0.327432f, 0.339238f,
0.024789f, 0.026985f, 0.013013f, 0.038512f, 0.045243f, 0.059776f, 0.039274f, 0.060148f, 0.048546f, 0.059650f, 0.037087f, 0.078901f, 0.057339f, 0.067297f, 0.060816f, 0.077694f,
1.253790f, 1.439016f, 0.740412f, 1.348768f, 1.502272f, 2.092706f, 1.466961f, 1.382926f, 1.108452f, 1.436014f, 0.952573f, 1.247437f, 2.122470f, 2.626473f, 2.532387f, 1.991389f,
0.577700f, 0.664006f, 0.423455f, 0.650592f, 0.745088f, 1.039432f, 0.903094f, 0.718045f, 1.003951f, 1.302516f, 1.070900f, 1.182790f, 0.795079f, 0.985304f, 1.177481f, 0.780941f,
1.979902f, 1.957057f, 1.178331f, 1.913282f, 1.679646f, 2.015099f, 1.652960f, 1.388964f, 1.659041f, 1.851049f, 1.436855f, 1.677188f, 2.559265f, 2.727505f, 3.077362f, 2.157013f,
0.360997f, 0.405924f, 0.227461f, 0.455410f, 0.701775f, 0.957762f, 0.731176f, 0.757590f, 0.691785f, 0.878038f, 0.634318f, 0.912976f, 0.655134f, 0.794258f, 0.834013f, 0.720827f,
0.000285f, 0.000318f, 0.000602f, 0.001657f, 0.000263f, 0.000355f, 0.000917f, 0.001307f, 0.000006f, 0.000007f, 0.000017f, 0.000034f, 0.000190f, 0.000228f, 0.000810f, 0.000962f,
0.000174f, 0.000195f, 0.000457f, 0.001062f, 0.000173f, 0.000235f, 0.000750f, 0.000902f, 0.000007f, 0.000008f, 0.000026f, 0.000043f, 0.000094f, 0.000114f, 0.000500f, 0.000501f,
0.000862f, 0.000828f, 0.001836f, 0.004506f, 0.000563f, 0.000656f, 0.001981f, 0.002516f, 0.000016f, 0.000017f, 0.000050f, 0.000087f, 0.000438f, 0.000454f, 0.001886f, 0.001998f,
0.000008f, 0.000008f, 0.000017f, 0.000053f, 0.000012f, 0.000015f, 0.000043f, 0.000068f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000006f, 0.000007f, 0.000025f, 0.000033f,
0.763660f, 0.919686f, 0.430814f, 1.022371f, 0.893758f, 1.306407f, 0.833740f, 1.023921f, 0.648377f, 0.881390f, 0.532291f, 0.908082f, 1.142173f, 1.483072f, 1.301851f, 1.333652f,
0.368318f, 0.444213f, 0.257910f, 0.516208f, 0.464006f, 0.679221f, 0.537267f, 0.556498f, 0.614706f, 0.836829f, 0.626390f, 0.901278f, 0.447863f, 0.582377f, 0.633621f, 0.547456f,
1.795996f, 1.862791f, 1.021104f, 2.159916f, 1.488249f, 1.873498f, 1.399140f, 1.531599f, 1.445286f, 1.692052f, 1.195778f, 1.818339f, 2.051125f, 2.293725f, 2.356114f, 2.151423f,
0.214079f, 0.252589f, 0.128860f, 0.336101f, 0.406504f, 0.582135f, 0.404604f, 0.546132f, 0.393983f, 0.524709f, 0.345107f, 0.647085f, 0.343254f, 0.436663f, 0.417445f, 0.470016f,
0.031075f, 0.038706f, 0.013886f, 0.046158f, 0.025954f, 0.039237f, 0.019178f, 0.032990f, 0.034129f, 0.047984f, 0.022194f, 0.053033f, 0.073908f, 0.099256f, 0.066729f, 0.095749f,
0.024382f, 0.030414f, 0.013524f, 0.037914f, 0.021920f, 0.033187f, 0.020105f, 0.029168f, 0.052638f, 0.074114f, 0.042488f, 0.085629f, 0.047146f, 0.063406f, 0.052835f, 0.063941f,
0.154295f, 0.165516f, 0.069488f, 0.205879f, 0.091242f, 0.118797f, 0.067948f, 0.104182f, 0.160615f, 0.194481f, 0.105263f, 0.224200f, 0.280214f, 0.324094f, 0.254969f, 0.326102f,
0.019492f, 0.023786f, 0.009294f, 0.033953f, 0.026413f, 0.039121f, 0.020825f, 0.039371f, 0.046402f, 0.063917f, 0.032197f, 0.084558f, 0.049699f, 0.065389f, 0.047877f, 0.075504f,
0.362806f, 0.466800f, 0.194595f, 0.437599f, 0.322756f, 0.504022f, 0.286254f, 0.333130f, 0.389905f, 0.566261f, 0.304332f, 0.491983f, 0.677012f, 0.939168f, 0.733656f, 0.712197f,
0.136317f, 0.175645f, 0.090753f, 0.172125f, 0.130536f, 0.204143f, 0.143702f, 0.141047f, 0.287973f, 0.418830f, 0.278995f, 0.380397f, 0.206806f, 0.287301f, 0.278172f, 0.227751f,
0.788129f, 0.873318f, 0.426018f, 0.853929f, 0.496418f, 0.667639f, 0.443710f, 0.460267f, 0.802792f, 1.004105f, 0.631490f, 0.909949f, 1.122984f, 1.341651f, 1.226435f, 1.061208f,
0.145276f, 0.183127f, 0.083139f, 0.205487f, 0.209684f, 0.320805f, 0.198425f, 0.253800f, 0.338419f, 0.481518f, 0.281837f, 0.500764f, 0.290621f, 0.394978f, 0.336029f, 0.358523f,
0.000538f, 0.000673f, 0.001033f, 0.003510f, 0.000368f, 0.000559f, 0.001169f, 0.002055f, 0.000013f, 0.000018f, 0.000036f, 0.000087f, 0.000395f, 0.000533f, 0.001532f, 0.002247f,
0.000269f, 0.000336f, 0.000640f, 0.001835f, 0.000198f, 0.000301f, 0.000780f, 0.001156f, 0.000013f, 0.000018f, 0.000044f, 0.000090f, 0.000160f, 0.000216f, 0.000772f, 0.000955f,
0.002240f, 0.002413f, 0.004334f, 0.013128f, 0.001085f, 0.001419f, 0.003472f, 0.005442f, 0.000050f, 0.000061f, 0.000142f, 0.000309f, 0.001255f, 0.001458f, 0.004906f, 0.006416f,
0.000020f, 0.000025f, 0.000042f, 0.000156f, 0.000023f, 0.000034f, 0.000077f, 0.000148f, 0.000001f, 0.000001f, 0.000003f, 0.000008f, 0.000016f, 0.000021f, 0.000066f, 0.000107f,
0.426317f, 0.575557f, 0.218439f, 0.639928f, 0.370450f, 0.607020f, 0.313868f, 0.475845f, 0.440000f, 0.670516f, 0.328082f, 0.690940f, 0.702861f, 1.023094f, 0.727623f, 0.920174f,
0.167669f, 0.226692f, 0.106636f, 0.263478f, 0.156830f, 0.257355f, 0.164932f, 0.210892f, 0.340165f, 0.519129f, 0.314829f, 0.559205f, 0.224740f, 0.327608f, 0.288784f, 0.308016f,
1.379246f, 1.603674f, 0.712220f, 1.859786f, 0.848572f, 1.197517f, 0.724572f, 0.979146f, 1.349220f, 1.770754f, 1.013881f, 1.903239f, 1.736335f, 2.176699f, 1.811529f, 2.042005f,
0.166207f, 0.219839f, 0.090866f, 0.292573f, 0.234323f, 0.376175f, 0.211830f, 0.352970f, 0.371830f, 0.555137f, 0.295820f, 0.684728f, 0.293762f, 0.418930f, 0.324479f, 0.451006f,
0.009544f, 0.011573f, 0.004565f, 0.012330f, 0.009359f, 0.013775f, 0.007402f, 0.010347f, 0.007289f, 0.009977f, 0.005073f, 0.009851f, 0.036011f, 0.047082f, 0.034798f, 0.040577f,
0.014986f, 0.018199f, 0.008897f, 0.020268f, 0.015819f, 0.023316f, 0.015529f, 0.018308f, 0.022498f, 0.030840f, 0.019437f, 0.031833f, 0.045971f, 0.060192f, 0.055140f, 0.054228f,
0.057681f, 0.060240f, 0.027803f, 0.066942f, 0.040050f, 0.050765f, 0.031921f, 0.039774f, 0.041755f, 0.049222f, 0.029289f, 0.050695f, 0.166188f, 0.187130f, 0.161846f, 0.168217f,
0.008860f, 0.010526f, 0.004521f, 0.013424f, 0.014097f, 0.020327f, 0.011896f, 0.018276f, 0.014668f, 0.019670f, 0.010893f, 0.023248f, 0.035839f, 0.045908f, 0.036952f, 0.047358f,
0.243025f, 0.304417f, 0.139511f, 0.254952f, 0.253845f, 0.385927f, 0.240962f, 0.227884f, 0.181623f, 0.256797f, 0.151727f, 0.199328f, 0.719446f, 0.971643f, 0.834444f, 0.658276f,
0.182739f, 0.229233f, 0.130210f, 0.200693f, 0.205461f, 0.312821f, 0.242083f, 0.193094f, 0.268453f, 0.380116f, 0.278365f, 0.308431f, 0.439814f, 0.594848f, 0.633174f, 0.421281f,
0.642610f, 0.693242f, 0.371776f, 0.605589f, 0.475243f, 0.622260f, 0.454643f, 0.383252f, 0.455187f, 0.554278f, 0.383227f, 0.448755f, 1.452616f, 1.689578f, 1.697947f, 1.193942f,
0.144029f, 0.176754f, 0.088219f, 0.177192f, 0.244083f, 0.363559f, 0.247214f, 0.256963f, 0.233317f, 0.323195f, 0.207966f, 0.300282f, 0.457096f, 0.604806f, 0.565667f, 0.490460f,
0.000367f, 0.000447f, 0.000754f, 0.002082f, 0.000295f, 0.000436f, 0.001001f, 0.001431f, 0.000006f, 0.000008f, 0.000018f, 0.000036f, 0.000427f, 0.000561f, 0.001773f, 0.002114f,
0.000367f, 0.000447f, 0.000935f, 0.002177f, 0.000317f, 0.000469f, 0.001337f, 0.001611f, 0.000012f, 0.000016f, 0.000044f, 0.000074f, 0.000347f, 0.000456f, 0.001787f, 0.001797f,
0.001859f, 0.001949f, 0.003849f, 0.009475f, 0.001058f, 0.001346f, 0.003620f, 0.004612f, 0.000029f, 0.000034f, 0.000088f, 0.000155f, 0.001653f, 0.001869f, 0.006913f, 0.007347f,
0.000021f, 0.000025f, 0.000045f, 0.000137f, 0.000027f, 0.000039f, 0.000097f, 0.000153f, 0.000001f, 0.000001f, 0.000002f, 0.000005f, 0.000026f, 0.000033f, 0.000114f, 0.000149f,
0.152037f, 0.199832f, 0.083377f, 0.198496f, 0.155118f, 0.247456f, 0.140664f, 0.173302f, 0.109120f, 0.161891f, 0.087084f, 0.149038f, 0.397659f, 0.563532f, 0.440607f, 0.452811f,
0.119667f, 0.157514f, 0.081457f, 0.163557f, 0.131422f, 0.209958f, 0.147926f, 0.153710f, 0.168829f, 0.250838f, 0.167237f, 0.241397f, 0.254464f, 0.361129f, 0.349963f, 0.303337f,
0.598732f, 0.677748f, 0.330908f, 0.702197f, 0.432511f, 0.594226f, 0.395269f, 0.434071f, 0.407295f, 0.520410f, 0.327579f, 0.499718f, 1.195777f, 1.459408f, 1.335256f, 1.223148f,
0.087729f, 0.112969f, 0.051333f, 0.134318f, 0.145221f, 0.226968f, 0.140509f, 0.190264f, 0.136482f, 0.198378f, 0.116215f, 0.218602f, 0.245989f, 0.341526f, 0.290811f, 0.328479f,
0.005752f, 0.007206f, 0.003262f, 0.006788f, 0.005054f, 0.007684f, 0.004740f, 0.005104f, 0.004628f, 0.006545f, 0.003820f, 0.005714f, 0.020036f, 0.027061f, 0.022959f, 0.020622f,
0.006091f, 0.007642f, 0.004288f, 0.007525f, 0.005761f, 0.008772f, 0.006706f, 0.006090f, 0.009635f, 0.013643f, 0.009870f, 0.012452f, 0.017249f, 0.023331f, 0.024534f, 0.018586f,
0.037136f, 0.040065f, 0.021226f, 0.039368f, 0.023101f, 0.030250f, 0.021834f, 0.020957f, 0.028322f, 0.034489f, 0.023557f, 0.031409f, 0.098768f, 0.114888f, 0.114061f, 0.091321f,
0.005862f, 0.007194f, 0.003547f, 0.008112f, 0.008356f, 0.012447f, 0.008361f, 0.009896f, 0.010224f, 0.014163f, 0.009003f, 0.014802f, 0.021888f, 0.028963f, 0.026761f, 0.026419f,
0.144259f, 0.186670f, 0.098202f, 0.138239f, 0.135001f, 0.212026f, 0.151962f, 0.110704f, 0.113583f, 0.165900f, 0.112518f, 0.113865f, 0.394227f, 0.550008f, 0.542204f, 0.329487f,
0.073153f, 0.094797f, 0.061811f, 0.073387f, 0.073690f, 0.115902f, 0.102959f, 0.063260f, 0.113220f, 0.165609f, 0.139215f, 0.118821f, 0.162528f, 0.227081f, 0.277460f, 0.142204f,
0.407457f, 0.454082f, 0.279533f, 0.350747f, 0.269978f, 0.365173f, 0.306267f, 0.198874f, 0.304071f, 0.382497f, 0.303570f, 0.273827f, 0.850239f, 1.021606f, 1.178507f, 0.638345f,
0.093846f, 0.118973f, 0.068163f, 0.105461f, 0.142489f, 0.219246f, 0.171132f, 0.137023f, 0.160163f, 0.229190f, 0.169287f, 0.188289f, 0.274933f, 0.375795f, 0.403458f, 0.269467f,
0.002671f, 0.003360f, 0.006507f, 0.013844f, 0.001923f, 0.002935f, 0.007745f, 0.008527f, 0.000047f, 0.000066f, 0.000165f, 0.000252f, 0.002871f, 0.003893f, 0.014130f, 0.012977f,
0.001800f, 0.002267f, 0.005442f, 0.009765f, 0.001395f, 0.002132f, 0.006972f, 0.006474f, 0.000062f, 0.000088f, 0.000271f, 0.000350f, 0.001573f, 0.002136f, 0.009607f, 0.007441f,
0.014460f, 0.015662f, 0.035497f, 0.067314f, 0.007369f, 0.009688f, 0.029913f, 0.029356f, 0.000239f, 0.000292f, 0.000852f, 0.001162f, 0.011866f, 0.013858f, 0.058855f, 0.048179f,
0.000164f, 0.000202f, 0.000427f, 0.000998f, 0.000192f, 0.000287f, 0.000824f, 0.000998f, 0.000006f, 0.000009f, 0.000023f, 0.000039f, 0.000189f, 0.000251f, 0.000994f, 0.001003f,
0.167093f, 0.226876f, 0.108661f, 0.199270f, 0.152739f, 0.251710f, 0.164243f, 0.155874f, 0.126347f, 0.193641f, 0.119568f, 0.157630f, 0.403437f, 0.590607f, 0.530070f, 0.419627f,
0.088694f, 0.120602f, 0.071592f, 0.110732f, 0.087270f, 0.144028f, 0.116482f, 0.093236f, 0.131831f, 0.202339f, 0.154854f, 0.172181f, 0.174101f, 0.255243f, 0.283933f, 0.189576f,
0.702884f, 0.821929f, 0.460655f, 0.752995f, 0.454910f, 0.645648f, 0.492992f, 0.417035f, 0.503746f, 0.664911f, 0.480437f, 0.564559f, 1.295858f, 1.633800f, 1.715891f, 1.210788f,
0.105834f, 0.140785f, 0.073434f, 0.148012f, 0.156959f, 0.253418f, 0.180086f, 0.187844f, 0.173463f, 0.260459f, 0.175150f, 0.253786f, 0.273938f, 0.392894f, 0.384030f, 0.334139f,
0.011345f, 0.012605f, 0.005582f, 0.015029f, 0.011823f, 0.015944f, 0.009619f, 0.013404f, 0.009134f, 0.011456f, 0.006540f, 0.012660f, 0.039377f, 0.047172f, 0.039143f, 0.045498f,
0.013341f, 0.014845f, 0.008148f, 0.018503f, 0.014967f, 0.020213f, 0.015114f, 0.017763f, 0.021116f, 0.026522f, 0.018766f, 0.030637f, 0.037648f, 0.045167f, 0.046453f, 0.045540f,
0.049471f, 0.047339f, 0.024530f, 0.058873f, 0.036504f, 0.042397f, 0.029930f, 0.037175f, 0.037754f, 0.040779f, 0.027242f, 0.047003f, 0.131115f, 0.135275f, 0.131354f, 0.136090f,
0.007398f, 0.008053f, 0.003884f, 0.011494f, 0.012509f, 0.016528f, 0.010859f, 0.016631f, 0.012912f, 0.015865f, 0.009864f, 0.020986f, 0.027529f, 0.032310f, 0.029198f, 0.037301f,
0.413703f, 0.474820f, 0.244308f, 0.445042f, 0.459237f, 0.639730f, 0.448443f, 0.422754f, 0.325952f, 0.422275f, 0.280114f, 0.366822f, 1.126618f, 1.394145f, 1.344204f, 1.057039f,
0.232980f, 0.267786f, 0.170774f, 0.262376f, 0.278387f, 0.388362f, 0.337422f, 0.268282f, 0.360828f, 0.468135f, 0.384891f, 0.425105f, 0.515819f, 0.639230f, 0.763908f, 0.506647f,
0.789272f, 0.780165f, 0.469732f, 0.762714f, 0.620333f, 0.744224f, 0.610478f, 0.512977f, 0.589403f, 0.657617f, 0.510467f, 0.595850f, 1.641229f, 1.749120f, 1.973479f, 1.383269f,
0.172228f, 0.193662f, 0.108519f, 0.217271f, 0.310186f, 0.423332f, 0.323181f, 0.334856f, 0.294132f, 0.373323f, 0.269698f, 0.388178f, 0.502806f, 0.609582f, 0.640093f, 0.553224f,
0.000370f, 0.000413f, 0.000783f, 0.002155f, 0.000316f, 0.000428f, 0.001105f, 0.001574f, 0.000006f, 0.000008f, 0.000020f, 0.000039f, 0.000397f, 0.000477f, 0.001693f, 0.002013f,
0.000277f, 0.000310f, 0.000727f, 0.001688f, 0.000255f, 0.000345f, 0.001105f, 0.001327f, 0.000009f, 0.000012f, 0.000036f, 0.000060f, 0.000241f, 0.000291f, 0.001279f, 0.001282f,
0.001354f, 0.001301f, 0.002884f, 0.007076f, 0.000819f, 0.000955f, 0.002883f, 0.003661f, 0.000022f, 0.000024f, 0.000069f, 0.000122f, 0.001107f, 0.001147f, 0.004765f, 0.005047f,
0.000015f, 0.000016f, 0.000033f, 0.000099f, 0.000020f, 0.000027f, 0.000075f, 0.000118f, 0.000001f, 0.000001f, 0.000002f, 0.000004f, 0.000017f, 0.000020f, 0.000076f, 0.000100f,
0.205707f, 0.247736f, 0.116048f, 0.275396f, 0.223046f, 0.326026f, 0.208068f, 0.255529f, 0.155650f, 0.211588f, 0.127782f, 0.217995f, 0.494940f, 0.642663f, 0.564134f, 0.577914f,
0.121262f, 0.146249f, 0.084912f, 0.169952f, 0.141531f, 0.207175f, 0.163876f, 0.169742f, 0.180361f, 0.245534f, 0.183789f, 0.264443f, 0.237202f, 0.308445f, 0.335585f, 0.289949f,
0.584486f, 0.606224f, 0.332306f, 0.702919f, 0.448713f, 0.564867f, 0.421847f, 0.461783f, 0.419175f, 0.490744f, 0.346810f, 0.527370f, 1.073821f, 1.200829f, 1.233491f, 1.126330f,
0.083380f, 0.098378f, 0.050188f, 0.130905f, 0.146681f, 0.210055f, 0.145996f, 0.197064f, 0.136752f, 0.182127f, 0.119787f, 0.224605f, 0.215066f, 0.273591f, 0.261551f, 0.294489f,
0.005958f, 0.007422f, 0.002663f, 0.008851f, 0.004611f, 0.006970f, 0.003407f, 0.005860f, 0.005832f, 0.008200f, 0.003793f, 0.009063f, 0.022798f, 0.030616f, 0.020583f, 0.029535f,
0.005714f, 0.007128f, 0.003169f, 0.008885f, 0.004759f, 0.007206f, 0.004365f, 0.006333f, 0.010994f, 0.015479f, 0.008874f, 0.017884f, 0.017774f, 0.023905f, 0.019919f, 0.024106f,
0.035743f, 0.038343f, 0.016097f, 0.047693f, 0.019582f, 0.025496f, 0.014583f, 0.022360f, 0.033159f, 0.040151f, 0.021732f, 0.046286f, 0.104425f, 0.120778f, 0.095018f, 0.121526f,
0.005404f, 0.006595f, 0.002577f, 0.009413f, 0.006784f, 0.010048f, 0.005349f, 0.010113f, 0.011465f, 0.015792f, 0.007955f, 0.020892f, 0.022166f, 0.029164f, 0.021353f, 0.033675f,
0.111207f, 0.143084f, 0.059647f, 0.134133f, 0.091655f, 0.143131f, 0.081290f, 0.094601f, 0.106510f, 0.154685f, 0.083134f, 0.134394f, 0.333830f, 0.463098f, 0.361761f, 0.351180f,
0.051069f, 0.065803f, 0.034000f, 0.064485f, 0.045307f, 0.070855f, 0.049877f, 0.048955f, 0.096147f, 0.139837f, 0.093149f, 0.127005f, 0.124636f, 0.173149f, 0.167647f, 0.137259f,
0.291860f, 0.323407f, 0.157763f, 0.316227f, 0.170314f, 0.229057f, 0.152230f, 0.157911f, 0.264943f, 0.331382f, 0.208409f, 0.300308f, 0.668994f, 0.799260f, 0.730623f, 0.632193f,
0.064386f, 0.081161f, 0.036847f, 0.091070f, 0.086096f, 0.131722f, 0.081473f, 0.104210f, 0.133666f, 0.190186f, 0.111318f, 0.197788f, 0.207201f, 0.281604f, 0.239575f, 0.255612f,
0.000650f, 0.000813f, 0.001247f, 0.004239f, 0.000412f, 0.000625f, 0.001308f, 0.002300f, 0.000014f, 0.000019f, 0.000038f, 0.000094f, 0.000767f, 0.001034f, 0.002975f, 0.004365f,
0.000397f, 0.000497f, 0.000945f, 0.002708f, 0.000271f, 0.000411f, 0.001066f, 0.001581f, 0.000017f, 0.000023f, 0.000057f, 0.000118f, 0.000381f, 0.000514f, 0.001832f, 0.002267f,
0.003269f, 0.003520f, 0.006322f, 0.019153f, 0.001467f, 0.001918f, 0.004692f, 0.007356f, 0.000066f, 0.000080f, 0.000185f, 0.000402f, 0.002947f, 0.003422f, 0.011515f, 0.015058f,
0.000036f, 0.000044f, 0.000073f, 0.000272f, 0.000037f, 0.000054f, 0.000124f, 0.000239f, 0.000002f, 0.000002f, 0.000005f, 0.000013f, 0.000045f, 0.000059f, 0.000186f, 0.000300f,
0.106679f, 0.144023f, 0.054661f, 0.160131f, 0.085881f, 0.140725f, 0.072764f, 0.110315f, 0.098123f, 0.149529f, 0.073164f, 0.154084f, 0.282934f, 0.411843f, 0.292902f, 0.370412f,
0.051280f, 0.069332f, 0.032614f, 0.080583f, 0.044438f, 0.072921f, 0.046733f, 0.059756f, 0.092717f, 0.141496f, 0.085811f, 0.152419f, 0.110573f, 0.161184f, 0.142082f, 0.151545f,
0.416970f, 0.484819f, 0.215316f, 0.562246f, 0.237671f, 0.335405f, 0.202941f, 0.274243f, 0.363512f, 0.477083f, 0.273164f, 0.512777f, 0.844439f, 1.058603f, 0.881008f, 0.993096f,
0.060135f, 0.079540f, 0.032876f, 0.105856f, 0.078545f, 0.126094f, 0.071006f, 0.118316f, 0.119894f, 0.179000f, 0.095385f, 0.220785f, 0.170980f, 0.243833f, 0.188859f, 0.262502f,
0.033065f, 0.040096f, 0.015814f, 0.042718f, 0.026058f, 0.038352f, 0.020609f, 0.028809f, 0.021853f, 0.029912f, 0.015210f, 0.029536f, 0.075516f, 0.098733f, 0.072973f, 0.085091f,
0.062341f, 0.075707f, 0.037010f, 0.084316f, 0.052885f, 0.077949f, 0.051915f, 0.061208f, 0.080993f, 0.111022f, 0.069971f, 0.114597f, 0.115755f, 0.151562f, 0.138842f, 0.136546f,
0.198052f, 0.206838f, 0.095464f, 0.229851f, 0.110511f, 0.140080f, 0.088082f, 0.109752f, 0.124067f, 0.146254f, 0.087026f, 0.150630f, 0.345389f, 0.388912f, 0.336364f, 0.349605f,
0.022626f, 0.026881f, 0.011546f, 0.034280f, 0.028930f, 0.041716f, 0.024413f, 0.037508f, 0.032414f, 0.043468f, 0.024072f, 0.051376f, 0.055398f, 0.070960f, 0.057118f, 0.073202f,
0.503442f, 0.630620f, 0.289007f, 0.528150f, 0.422602f, 0.642493f, 0.401155f, 0.379382f, 0.325593f, 0.460356f, 0.271998f, 0.357332f, 0.902115f, 1.218345f, 1.046310f, 0.825413f,
0.454544f, 0.570194f, 0.323885f, 0.499203f, 0.410714f, 0.625324f, 0.483922f, 0.385992f, 0.577855f, 0.818214f, 0.599191f, 0.663910f, 0.662185f, 0.895605f, 0.953308f, 0.634282f,
1.319309f, 1.423258f, 0.763274f, 1.243303f, 0.784114f, 1.026680f, 0.750126f, 0.632335f, 0.808710f, 0.984761f, 0.680862f, 0.797283f, 1.805152f, 2.099623f, 2.110023f, 1.483701f,
0.219923f, 0.269892f, 0.134706f, 0.270561f, 0.299519f, 0.446130f, 0.303360f, 0.315323f, 0.308299f, 0.427062f, 0.274801f, 0.396785f, 0.422467f, 0.558987f, 0.522813f, 0.453304f,
0.000400f, 0.000488f, 0.000823f, 0.002272f, 0.000259f, 0.000382f, 0.000878f, 0.001255f, 0.000006f, 0.000008f, 0.000017f, 0.000034f, 0.000282f, 0.000370f, 0.001171f, 0.001396f,
0.000480f, 0.000586f, 0.001225f, 0.002853f, 0.000334f, 0.000494f, 0.001408f, 0.001697f, 0.000014f, 0.000019f, 0.000050f, 0.000084f, 0.000275f, 0.000362f, 0.001418f, 0.001426f,
0.002011f, 0.002109f, 0.004163f, 0.010250f, 0.000919f, 0.001170f, 0.003147f, 0.004009f, 0.000027f, 0.000032f, 0.000082f, 0.000145f, 0.001082f, 0.001223f, 0.004526f, 0.004810f,
0.000017f, 0.000020f, 0.000036f, 0.000110f, 0.000017f, 0.000025f, 0.000063f, 0.000099f, 0.000001f, 0.000001f, 0.000002f, 0.000004f, 0.000012f, 0.000016f, 0.000055f, 0.000072f,
0.372567f, 0.489689f, 0.204317f, 0.486416f, 0.305480f, 0.487324f, 0.277015f, 0.341290f, 0.231400f, 0.343307f, 0.184670f, 0.316051f, 0.589836f, 0.835870f, 0.653538f, 0.671641f,
0.352107f, 0.463469f, 0.239679f, 0.481251f, 0.310767f, 0.496478f, 0.349793f, 0.363471f, 0.429886f, 0.638704f, 0.425834f, 0.614666f, 0.453203f, 0.643175f, 0.623287f, 0.540247f,
1.454077f, 1.645975f, 0.803641f, 1.705352f, 0.844144f, 1.159768f, 0.771458f, 0.847190f, 0.855991f, 1.093720f, 0.688456f, 1.050231f, 1.757801f, 2.145341f, 1.962836f, 1.798036f,
0.158461f, 0.204051f, 0.092721f, 0.242612f, 0.210800f, 0.329463f, 0.203960f, 0.276184f, 0.213333f, 0.310081f, 0.181653f, 0.341693f, 0.268942f, 0.373393f, 0.317945f, 0.359129f,
0.030523f, 0.038237f, 0.017312f, 0.036021f, 0.021552f, 0.032768f, 0.020212f, 0.021765f, 0.021254f, 0.030053f, 0.017542f, 0.026239f, 0.064352f, 0.086916f, 0.073741f, 0.066236f,
0.038811f, 0.048689f, 0.027322f, 0.047948f, 0.029498f, 0.044914f, 0.034338f, 0.031185f, 0.053122f, 0.075224f, 0.054421f, 0.068657f, 0.066524f, 0.089979f, 0.094618f, 0.071680f,
0.195295f, 0.210697f, 0.111627f, 0.207033f, 0.097633f, 0.127844f, 0.092277f, 0.088569f, 0.128889f, 0.156959f, 0.107208f, 0.142941f, 0.314396f, 0.365708f, 0.363074f, 0.290688f,
0.022927f, 0.028138f, 0.013874f, 0.031729f, 0.026265f, 0.039124f, 0.026282f, 0.031105f, 0.034604f, 0.047938f, 0.030473f, 0.050099f, 0.051819f, 0.068569f, 0.063356f, 0.062547f,
0.457711f, 0.592276f, 0.311579f, 0.438612f, 0.344232f, 0.540634f, 0.387480f, 0.282279f, 0.311866f, 0.455514f, 0.308942f, 0.312641f, 0.757111f, 1.056289f, 1.041300f, 0.632778f,
0.278695f, 0.361153f, 0.235484f, 0.279584f, 0.225616f, 0.354855f, 0.315227f, 0.193683f, 0.373270f, 0.545991f, 0.458973f, 0.391738f, 0.374790f, 0.523649f, 0.639823f, 0.327924f,
1.281242f, 1.427851f, 0.878988f, 1.102919f, 0.682246f, 0.922809f, 0.773952f, 0.502564f, 0.827425f, 1.040834f, 0.826061f, 0.745127f, 1.618281f, 1.944449f, 2.243083f, 1.214979f,
0.219475f, 0.278240f, 0.159411f, 0.246639f, 0.267803f, 0.412067f, 0.321639f, 0.257531f, 0.324143f, 0.463844f, 0.342611f, 0.381068f, 0.389192f, 0.531970f, 0.571129f, 0.381454f,
0.004466f, 0.005617f, 0.010878f, 0.023143f, 0.002583f, 0.003943f, 0.010405f, 0.011456f, 0.000067f, 0.000096f, 0.000238f, 0.000365f, 0.002905f, 0.003939f, 0.014297f, 0.013131f,
0.003613f, 0.004551f, 0.010924f, 0.019601f, 0.002250f, 0.003439f, 0.011247f, 0.010444f, 0.000107f, 0.000152f, 0.000471f, 0.000607f, 0.001911f, 0.002595f, 0.011672f, 0.009041f,
0.023956f, 0.025948f, 0.058810f, 0.111523f, 0.009812f, 0.012899f, 0.039828f, 0.039086f, 0.000342f, 0.000418f, 0.001222f, 0.001666f, 0.011900f, 0.013897f, 0.059021f, 0.048315f,
0.000202f, 0.000249f, 0.000526f, 0.001230f, 0.000190f, 0.000284f, 0.000816f, 0.000988f, 0.000007f, 0.000009f, 0.000025f, 0.000042f, 0.000141f, 0.000188f, 0.000741f, 0.000748f,
0.627138f, 0.851520f, 0.407831f, 0.747908f, 0.460701f, 0.759224f, 0.495402f, 0.470157f, 0.410369f, 0.628937f, 0.388351f, 0.511975f, 0.916529f, 1.341740f, 1.204214f, 0.953310f,
0.399710f, 0.543508f, 0.322640f, 0.499028f, 0.316070f, 0.521630f, 0.421869f, 0.337676f, 0.514132f, 0.789107f, 0.603920f, 0.671495f, 0.474919f, 0.696259f, 0.774519f, 0.517131f,
2.614502f, 3.057313f, 1.713490f, 2.800900f, 1.359864f, 1.930036f, 1.473700f, 1.246643f, 1.621517f, 2.140294f, 1.546487f, 1.817270f, 2.917610f, 3.678482f, 3.863309f, 2.726076f,
0.292788f, 0.389480f, 0.203154f, 0.409473f, 0.348963f, 0.563418f, 0.400380f, 0.417628f, 0.415278f, 0.623552f, 0.419318f, 0.607576f, 0.458718f, 0.657913f, 0.643069f, 0.559526f,
0.061907f, 0.068786f, 0.030459f, 0.082014f, 0.051850f, 0.069923f, 0.042184f, 0.058781f, 0.043136f, 0.054100f, 0.030885f, 0.059783f, 0.130064f, 0.155812f, 0.129292f, 0.150282f,
0.087418f, 0.097272f, 0.053387f, 0.121240f, 0.078812f, 0.106437f, 0.079587f, 0.093534f, 0.119734f, 0.150385f, 0.106410f, 0.173720f, 0.149316f, 0.179136f, 0.184237f, 0.180614f,
0.267545f, 0.256019f, 0.132662f, 0.318397f, 0.158655f, 0.184267f, 0.130085f, 0.161571f, 0.176692f, 0.190851f, 0.127497f, 0.219977f, 0.429207f, 0.442825f, 0.429989f, 0.445493f,
0.029758f, 0.032393f, 0.015622f, 0.046231f, 0.040437f, 0.053426f, 0.035102f, 0.053759f, 0.044944f, 0.055224f, 0.034335f, 0.073046f, 0.067023f, 0.078663f, 0.071088f, 0.090816f,
1.349875f, 1.549296f, 0.797155f, 1.452132f, 1.204221f, 1.677513f, 1.175916f, 1.108553f, 0.920371f, 1.192353f, 0.790941f, 1.035773f, 2.225081f, 2.753450f, 2.654816f, 2.087663f,
0.912790f, 1.049156f, 0.669075f, 1.027961f, 0.876525f, 1.222793f, 1.062404f, 0.844711f, 1.223369f, 1.587186f, 1.304950f, 1.441294f, 1.223245f, 1.515910f, 1.811579f, 1.201493f,
2.552297f, 2.522848f, 1.518990f, 2.466417f, 1.612108f, 1.934073f, 1.586495f, 1.333114f, 1.649384f, 1.840274f, 1.428491f, 1.667425f, 3.212464f, 3.423644f, 3.862794f, 2.707545f,
0.414220f, 0.465770f, 0.260996f, 0.522552f, 0.599533f, 0.818226f, 0.624651f, 0.647217f, 0.612174f, 0.776993f, 0.561320f, 0.807911f, 0.731968f, 0.887409f, 0.931827f, 0.805366f,
0.000637f, 0.000710f, 0.001345f, 0.003704f, 0.000437f, 0.000592f, 0.001527f, 0.002175f, 0.000010f, 0.000012f, 0.000030f, 0.000058f, 0.000413f, 0.000496f, 0.001762f, 0.002094f,
0.000572f, 0.000639f, 0.001500f, 0.003484f, 0.000423f, 0.000573f, 0.001833f, 0.002202f, 0.000017f, 0.000021f, 0.000065f, 0.000108f, 0.000301f, 0.000363f, 0.001598f, 0.001601f,
0.002307f, 0.002216f, 0.004913f, 0.012057f, 0.001121f, 0.001307f, 0.003947f, 0.005012f, 0.000033f, 0.000036f, 0.000102f, 0.000180f, 0.001142f, 0.001183f, 0.004914f, 0.005205f,
0.000018f, 0.000020f, 0.000042f, 0.000126f, 0.000021f, 0.000027f, 0.000077f, 0.000120f, 0.000001f, 0.000001f, 0.000002f, 0.000004f, 0.000013f, 0.000015f, 0.000058f, 0.000076f,
0.793983f, 0.956205f, 0.447920f, 1.062967f, 0.691863f, 1.011297f, 0.645403f, 0.792623f, 0.519895f, 0.706735f, 0.426813f, 0.728138f, 1.156321f, 1.501443f, 1.317977f, 1.350173f,
0.561995f, 0.677799f, 0.393530f, 0.787652f, 0.527136f, 0.771632f, 0.610364f, 0.632212f, 0.723360f, 0.984746f, 0.737109f, 1.060586f, 0.665412f, 0.865266f, 0.941403f, 0.813382f,
2.235811f, 2.318964f, 1.271159f, 2.688851f, 1.379413f, 1.736489f, 1.296821f, 1.419593f, 1.387589f, 1.624504f, 1.148042f, 1.745749f, 2.486322f, 2.780397f, 2.856022f, 2.607901f,
0.237216f, 0.279888f, 0.142787f, 0.372425f, 0.335369f, 0.480266f, 0.333801f, 0.450563f, 0.336685f, 0.448399f, 0.294917f, 0.552978f, 0.370357f, 0.471141f, 0.450406f, 0.507128f,
0.064424f, 0.080246f, 0.028789f, 0.095695f, 0.040062f, 0.060565f, 0.029603f, 0.050923f, 0.054568f, 0.076721f, 0.035486f, 0.084795f, 0.149201f, 0.200370f, 0.134708f, 0.193291f,
0.074184f, 0.092536f, 0.041148f, 0.115356f, 0.049656f, 0.075178f, 0.045544f, 0.066076f, 0.123514f, 0.173907f, 0.099698f, 0.200927f, 0.139675f, 0.187849f, 0.156530f, 0.189432f,
0.383011f, 0.410867f, 0.172492f, 0.511060f, 0.168634f, 0.219560f, 0.125581f, 0.192550f, 0.307484f, 0.372318f, 0.201518f, 0.429214f, 0.677307f, 0.783369f, 0.616287f, 0.788222f,
0.043068f, 0.052556f, 0.020535f, 0.075020f, 0.043451f, 0.064357f, 0.034258f, 0.064769f, 0.079071f, 0.108916f, 0.054864f, 0.144089f, 0.106925f, 0.140683f, 0.103005f, 0.162445f,
0.718958f, 0.925038f, 0.385620f, 0.867172f, 0.476203f, 0.743648f, 0.422347f, 0.491509f, 0.595888f, 0.865410f, 0.465108f, 0.751893f, 1.306352f, 1.812204f, 1.415652f, 1.374246f,
0.396440f, 0.510814f, 0.263930f, 0.500579f, 0.282649f, 0.442030f, 0.311158f, 0.305408f, 0.645887f, 0.939383f, 0.625750f, 0.853182f, 0.585633f, 0.813581f, 0.787729f, 0.644945f,
1.870012f, 2.072143f, 1.010824f, 2.026139f, 0.876967f, 1.179445f, 0.783855f, 0.813104f, 1.469019f, 1.837400f, 1.155555f, 1.665104f, 2.594516f, 3.099718f, 2.833526f, 2.451791f,
0.306819f, 0.386757f, 0.175587f, 0.433980f, 0.329716f, 0.504448f, 0.312013f, 0.399086f, 0.551212f, 0.784289f, 0.459052f, 0.815636f, 0.597652f, 0.812260f, 0.691033f, 0.737291f,
0.002214f, 0.002768f, 0.004249f, 0.014440f, 0.001128f, 0.001712f, 0.003579f, 0.006295f, 0.000041f, 0.000057f, 0.000113f, 0.000277f, 0.001582f, 0.002133f, 0.006134f, 0.008999f,
0.001622f, 0.002031f, 0.003864f, 0.011075f, 0.000889f, 0.001352f, 0.003504f, 0.005197f, 0.000058f, 0.000083f, 0.000203f, 0.000417f, 0.000942f, 0.001272f, 0.004535f, 0.005612f,
0.011034f, 0.011884f, 0.021343f, 0.064656f, 0.003980f, 0.005203f, 0.012730f, 0.019957f, 0.000192f, 0.000233f, 0.000539f, 0.001175f, 0.006021f, 0.006991f, 0.023529f, 0.030769f,
0.000089f, 0.000109f, 0.000183f, 0.000683f, 0.000074f, 0.000110f, 0.000250f, 0.000483f, 0.000004f, 0.000005f, 0.000011f, 0.000028f, 0.000068f, 0.000090f, 0.000283f, 0.000456f,
0.815838f, 1.101436f, 0.418024f, 1.224622f, 0.527824f, 0.864895f, 0.447206f, 0.677993f, 0.649383f, 0.989594f, 0.484206f, 1.019737f, 1.309713f, 1.906435f, 1.355854f, 1.714654f,
0.470894f, 0.636659f, 0.299485f, 0.739970f, 0.327936f, 0.538136f, 0.344876f, 0.440980f, 0.736779f, 1.124403f, 0.681902f, 1.211206f, 0.614590f, 0.895901f, 0.789729f, 0.842324f,
3.160323f, 3.674564f, 1.631938f, 4.261402f, 1.447661f, 2.042961f, 1.236118f, 1.670421f, 2.384238f, 3.129139f, 1.791653f, 3.363256f, 3.873992f, 4.856502f, 4.041759f, 4.555981f,
0.338983f, 0.448367f, 0.185323f, 0.596709f, 0.355822f, 0.571225f, 0.321667f, 0.535988f, 0.584857f, 0.873185f, 0.465301f, 1.077020f, 0.583391f, 0.831966f, 0.644393f, 0.895666f,
0.131035f, 0.158899f, 0.062672f, 0.169290f, 0.112068f, 0.164943f, 0.088632f, 0.123898f, 0.090822f, 0.124315f, 0.063213f, 0.122751f, 0.275347f, 0.360001f, 0.266076f, 0.310260f,
0.165189f, 0.200605f, 0.098067f, 0.223418f, 0.152075f, 0.224150f, 0.149286f, 0.176008f, 0.225062f, 0.308506f, 0.194435f, 0.318440f, 0.282204f, 0.369501f, 0.338489f, 0.332892f,
0.716717f, 0.748513f, 0.345468f, 0.831791f, 0.434003f, 0.550128f, 0.345919f, 0.431020f, 0.470839f, 0.555041f, 0.330267f, 0.571647f, 1.149991f, 1.294903f, 1.119940f, 1.164028f,
0.079260f, 0.094165f, 0.040448f, 0.120084f, 0.109982f, 0.158589f, 0.092807f, 0.142590f, 0.119079f, 0.159686f, 0.088431f, 0.188735f, 0.178549f, 0.228708f, 0.184093f, 0.235933f,
2.296289f, 2.876369f, 1.318213f, 2.408985f, 2.091837f, 3.180274f, 1.985674f, 1.877903f, 1.557403f, 2.202013f, 1.301044f, 1.709219f, 3.785789f, 5.112872f, 4.390916f, 3.463905f,
1.386233f, 1.738933f, 0.987758f, 1.522429f, 1.359310f, 2.069589f, 1.601600f, 1.277489f, 1.848111f, 2.616831f, 1.916349f, 2.123333f, 1.858047f, 2.513008f, 2.674919f, 1.779752f,
5.495001f, 5.927953f, 3.179081f, 5.178430f, 3.544208f, 4.640610f, 3.390581f, 2.858166f, 3.532347f, 4.301316f, 2.973921f, 3.482435f, 6.917552f, 8.045999f, 8.085855f, 5.685714f,
0.886691f, 1.088155f, 0.543108f, 1.090853f, 1.310520f, 1.952004f, 1.327328f, 1.379670f, 1.303533f, 1.805681f, 1.161897f, 1.677665f, 1.567153f, 2.073577f, 1.939388f, 1.681541f,
0.000122f, 0.000149f, 0.000251f, 0.000693f, 0.000086f, 0.000126f, 0.000291f, 0.000415f, 0.000002f, 0.000003f, 0.000005f, 0.000011f, 0.000079f, 0.000104f, 0.000329f, 0.000392f,
0.000098f, 0.000119f, 0.000250f, 0.000582f, 0.000074f, 0.000109f, 0.000311f, 0.000375f, 0.000003f, 0.000004f, 0.000011f, 0.000018f, 0.000052f, 0.000068f, 0.000266f, 0.000267f,
0.000560f, 0.000587f, 0.001159f, 0.002854f, 0.000278f, 0.000354f, 0.000951f, 0.001212f, 0.000008f, 0.000009f, 0.000024f, 0.000042f, 0.000277f, 0.000313f, 0.001160f, 0.001232f,
0.000004f, 0.000005f, 0.000010f, 0.000030f, 0.000005f, 0.000007f, 0.000018f, 0.000029f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000003f, 0.000004f, 0.000014f, 0.000018f,
0.856945f, 1.126341f, 0.469951f, 1.118811f, 0.762519f, 1.216428f, 0.691467f, 0.851906f, 0.558165f, 0.828095f, 0.445445f, 0.762352f, 1.248239f, 1.768909f, 1.383049f, 1.421359f,
0.541511f, 0.712775f, 0.368606f, 0.740123f, 0.518664f, 0.828610f, 0.583797f, 0.606626f, 0.693321f, 1.030103f, 0.686786f, 0.991335f, 0.641273f, 0.910078f, 0.881937f, 0.764437f,
3.054081f, 3.457137f, 1.687934f, 3.581848f, 1.924103f, 2.643524f, 1.758426f, 1.931047f, 1.885434f, 2.409064f, 1.516416f, 2.313275f, 3.396882f, 4.145787f, 3.793105f, 3.474635f,
0.322177f, 0.414869f, 0.188516f, 0.493270f, 0.465117f, 0.726939f, 0.450026f, 0.609382f, 0.454861f, 0.661146f, 0.387316f, 0.728548f, 0.503093f, 0.698484f, 0.594761f, 0.671801f,
0.071499f, 0.089567f, 0.040551f, 0.084377f, 0.054786f, 0.083299f, 0.051380f, 0.055327f, 0.052210f, 0.073825f, 0.043091f, 0.064457f, 0.138691f, 0.187321f, 0.158925f, 0.142750f,
0.060786f, 0.076257f, 0.042792f, 0.075097f, 0.050137f, 0.076340f, 0.058363f, 0.053005f, 0.087252f, 0.123553f, 0.089386f, 0.112768f, 0.095861f, 0.129661f, 0.136346f, 0.103291f,
0.417736f, 0.450681f, 0.238771f, 0.442844f, 0.226634f, 0.296764f, 0.214203f, 0.205595f, 0.289120f, 0.352084f, 0.240485f, 0.320639f, 0.618736f, 0.719719f, 0.714535f, 0.572079f,
0.047472f, 0.058262f, 0.028728f, 0.065698f, 0.059018f, 0.087912f, 0.059056f, 0.069893f, 0.075140f, 0.104092f, 0.066170f, 0.108785f, 0.098718f, 0.130628f, 0.120697f, 0.119155f,
1.233989f, 1.596777f, 0.840017f, 1.182500f, 1.007141f, 1.581765f, 1.133674f, 0.825882f, 0.881732f, 1.287866f, 0.873466f, 0.883925f, 1.878006f, 2.620116f, 2.582936f, 1.569599f,
0.502380f, 0.651020f, 0.424487f, 0.503982f, 0.441360f, 0.694182f, 0.616660f, 0.378890f, 0.705627f, 1.032138f, 0.867640f, 0.740538f, 0.621597f, 0.868482f, 1.061159f, 0.543868f,
3.154243f, 3.515176f, 2.163948f, 2.715237f, 1.822738f, 2.465444f, 2.067745f, 1.342687f, 2.136199f, 2.687167f, 2.132679f, 1.923727f, 3.665521f, 4.404313f, 5.080741f, 2.752012f,
0.523034f, 0.663075f, 0.379893f, 0.587768f, 0.692594f, 1.065690f, 0.831823f, 0.666028f, 0.810084f, 1.159216f, 0.856237f, 0.952348f, 0.853345f, 1.166402f, 1.252264f, 0.836379f,
0.000805f, 0.001012f, 0.001961f, 0.004172f, 0.000505f, 0.000771f, 0.002035f, 0.002241f, 0.000013f, 0.000018f, 0.000045f, 0.000069f, 0.000482f, 0.000653f, 0.002371f, 0.002178f,
0.000435f, 0.000548f, 0.001317f, 0.002362f, 0.000294f, 0.000450f, 0.001471f, 0.001366f, 0.000014f, 0.000019f, 0.000060f, 0.000077f, 0.000212f, 0.000288f, 0.001294f, 0.001003f,
0.003943f, 0.004271f, 0.009680f, 0.018357f, 0.001753f, 0.002304f, 0.007114f, 0.006982f, 0.000059f, 0.000072f, 0.000211f, 0.000288f, 0.001802f, 0.002105f, 0.008938f, 0.007317f,
0.000032f, 0.000040f, 0.000084f, 0.000196f, 0.000033f, 0.000049f, 0.000141f, 0.000171f, 0.000001f, 0.000002f, 0.000004f, 0.000007f, 0.000021f, 0.000027f, 0.000109f, 0.000110f,
0.852619f, 1.157675f, 0.554463f, 1.016812f, 0.679720f, 1.120162f, 0.730919f, 0.693671f, 0.585080f, 0.896702f, 0.553688f, 0.729945f, 1.146452f, 1.678333f, 1.506306f, 1.192459f,
0.363346f, 0.494061f, 0.293287f, 0.453628f, 0.311801f, 0.514584f, 0.416170f, 0.333115f, 0.490115f, 0.752246f, 0.575710f, 0.640128f, 0.397202f, 0.582322f, 0.647776f, 0.432507f,
3.245825f, 3.795562f, 2.127246f, 3.477233f, 1.832106f, 2.600282f, 1.985474f, 1.679566f, 2.111090f, 2.786498f, 2.013407f, 2.365946f, 3.332582f, 4.201674f, 4.412789f, 3.113807f,
0.351859f, 0.468059f, 0.244141f, 0.492086f, 0.455107f, 0.734793f, 0.522165f, 0.544658f, 0.523365f, 0.785846f, 0.528456f, 0.765713f, 0.507200f, 0.727447f, 0.711035f, 0.618662f,
0.017202f, 0.019113f, 0.008463f, 0.022789f, 0.015635f, 0.021085f, 0.012720f, 0.017725f, 0.012570f, 0.015764f, 0.009000f, 0.017420f, 0.033251f, 0.039834f, 0.033054f, 0.038420f,
0.016241f, 0.018072f, 0.009918f, 0.022525f, 0.015890f, 0.021460f, 0.016046f, 0.018858f, 0.023328f, 0.029300f, 0.020732f, 0.033846f, 0.025523f, 0.030621f, 0.031493f, 0.030873f,
0.067885f, 0.064960f, 0.033661f, 0.080787f, 0.043687f, 0.050739f, 0.035819f, 0.044489f, 0.047015f, 0.050783f, 0.033925f, 0.058533f, 0.100198f, 0.103377f, 0.100380f, 0.104000f,
0.007309f, 0.007956f, 0.003837f, 0.011355f, 0.010778f, 0.014240f, 0.009356f, 0.014329f, 0.011576f, 0.014224f, 0.008844f, 0.018815f, 0.015146f, 0.017776f, 0.016064f, 0.020523f,
0.431695f, 0.495470f, 0.254933f, 0.464397f, 0.417934f, 0.582194f, 0.408111f, 0.384732f, 0.308671f, 0.399887f, 0.265263f, 0.347374f, 0.654706f, 0.810173f, 0.781151f, 0.614272f,
0.195181f, 0.224340f, 0.143067f, 0.219807f, 0.203399f, 0.283751f, 0.246533f, 0.196017f, 0.274329f, 0.355912f, 0.292623f, 0.323197f, 0.240656f, 0.298234f, 0.356402f, 0.236377f,
0.745347f, 0.736746f, 0.443590f, 0.720267f, 0.510905f, 0.612941f, 0.502788f, 0.422487f, 0.505124f, 0.563584f, 0.437476f, 0.510649f, 0.863143f, 0.919884f, 1.037878f, 0.727479f,
0.117095f, 0.131667f, 0.073780f, 0.147719f, 0.183924f, 0.251014f, 0.191630f, 0.198553f, 0.181481f, 0.230342f, 0.166405f, 0.239508f, 0.190378f, 0.230806f, 0.242359f, 0.209468f,
0.000014f, 0.000015f, 0.000029f, 0.000079f, 0.000010f, 0.000014f, 0.000035f, 0.000050f, 0.000000f, 0.000000f, 0.000001f, 0.000001f, 0.000008f, 0.000010f, 0.000035f, 0.000041f,
0.000008f, 0.000009f, 0.000021f, 0.000050f, 0.000007f, 0.000009f, 0.000028f, 0.000034f, 0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000004f, 0.000005f, 0.000021f, 0.000021f,
0.000045f, 0.000043f, 0.000096f, 0.000235f, 0.000024f, 0.000028f, 0.000084f, 0.000106f, 0.000001f, 0.000001f, 0.000002f, 0.000004f, 0.000021f, 0.000021f, 0.000088f, 0.000094f,
0.000000f, 0.000000f, 0.000001f, 0.000002f, 0.000000f, 0.000001f, 0.000002f, 0.000002f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000001f, 0.000001f,
0.128046f, 0.154208f, 0.072236f, 0.171425f, 0.121086f, 0.176992f, 0.112955f, 0.138720f, 0.087927f, 0.119526f, 0.072184f, 0.123145f, 0.171574f, 0.222783f, 0.195560f, 0.200337f,
0.060600f, 0.073087f, 0.042434f, 0.084932f, 0.061685f, 0.090296f, 0.071424f, 0.073981f, 0.081798f, 0.111355f, 0.083353f, 0.119931f, 0.066016f, 0.085843f, 0.093397f, 0.080696f,
0.329256f, 0.341502f, 0.187197f, 0.395973f, 0.220451f, 0.277517f, 0.207252f, 0.226873f, 0.214293f, 0.250882f, 0.177299f, 0.269606f, 0.336879f, 0.376724f, 0.386971f, 0.353352f,
0.033816f, 0.039899f, 0.020355f, 0.053091f, 0.051882f, 0.074298f, 0.051640f, 0.069703f, 0.050333f, 0.067034f, 0.044089f, 0.082668f, 0.048575f, 0.061794f, 0.059075f, 0.066514f,
0.090023f, 0.112131f, 0.040229f, 0.133719f, 0.060751f, 0.091843f, 0.044891f, 0.077221f, 0.079964f, 0.112426f, 0.052001f, 0.124257f, 0.191819f, 0.257605f, 0.173187f, 0.248503f,
0.069310f, 0.086456f, 0.038444f, 0.107777f, 0.050348f, 0.076225f, 0.046178f, 0.066996f, 0.121019f, 0.170394f, 0.097684f, 0.196867f, 0.120067f, 0.161478f, 0.134555f, 0.162838f,
0.488719f, 0.524263f, 0.220098f, 0.652109f, 0.233513f, 0.304033f, 0.173896f, 0.266631f, 0.411453f, 0.498209f, 0.269656f, 0.574342f, 0.795153f, 0.919670f, 0.723517f, 0.925367f,
0.053196f, 0.064916f, 0.025364f, 0.092662f, 0.058244f, 0.086266f, 0.045921f, 0.086819f, 0.102422f, 0.141080f, 0.071066f, 0.186641f, 0.121514f, 0.159878f, 0.117058f, 0.184609f,
1.156272f, 1.487703f, 0.620178f, 1.394640f, 0.831128f, 1.297905f, 0.737132f, 0.857843f, 1.005011f, 1.459581f, 0.784439f, 1.268125f, 1.933013f, 2.681523f, 2.094743f, 2.033475f,
0.426302f, 0.549291f, 0.283811f, 0.538285f, 0.329842f, 0.515834f, 0.363111f, 0.356401f, 0.728359f, 1.059331f, 0.705650f, 0.962122f, 0.579405f, 0.804930f, 0.779352f, 0.638087f,
2.746283f, 3.043131f, 1.484487f, 2.975570f, 1.397666f, 1.879739f, 1.249268f, 1.295884f, 2.262441f, 2.829786f, 1.779675f, 2.564434f, 3.505700f, 4.188328f, 3.828650f, 3.312850f,
0.436176f, 0.549818f, 0.249616f, 0.616951f, 0.508675f, 0.778243f, 0.481362f, 0.615696f, 0.821766f, 1.169246f, 0.684370f, 1.215978f, 0.781711f, 1.062413f, 0.903851f, 0.964355f,
0.000238f, 0.000298f, 0.000457f, 0.001553f, 0.000132f, 0.000200f, 0.000418f, 0.000735f, 0.000005f, 0.000006f, 0.000013f, 0.000031f, 0.000157f, 0.000211f, 0.000607f, 0.000890f,
0.000117f, 0.000146f, 0.000278f, 0.000796f, 0.000069f, 0.000105f, 0.000273f, 0.000406f, 0.000004f, 0.000006f, 0.000015f, 0.000031f, 0.000062f, 0.000084f, 0.000300f, 0.000371f,
0.001083f, 0.001167f, 0.002096f, 0.006349f, 0.000424f, 0.000554f, 0.001356f, 0.002127f, 0.000020f, 0.000024f, 0.000056f, 0.000121f, 0.000544f, 0.000632f, 0.002126f, 0.002780f,
0.000008f, 0.000010f, 0.000017f, 0.000065f, 0.000008f, 0.000011f, 0.000026f, 0.000050f, 0.000000f, 0.000000f, 0.000001f, 0.000003f, 0.000006f, 0.000008f, 0.000025f, 0.000040f,
0.661657f, 0.893281f, 0.339024f, 0.993186f, 0.464555f, 0.761221f, 0.393600f, 0.596723f, 0.552305f, 0.841657f, 0.411821f, 0.867293f, 0.977288f, 1.422553f, 1.011718f, 1.279448f,
0.255349f, 0.345238f, 0.162400f, 0.401260f, 0.192983f, 0.316682f, 0.202952f, 0.259507f, 0.418984f, 0.639415f, 0.387778f, 0.688777f, 0.306630f, 0.446981f, 0.394010f, 0.420251f,
2.340477f, 2.721314f, 1.208583f, 3.155916f, 1.163480f, 1.641920f, 0.993464f, 1.342510f, 1.851704f, 2.430228f, 1.391477f, 2.612053f, 2.639667f, 3.309131f, 2.753980f, 3.104362f,
0.243013f, 0.321430f, 0.132856f, 0.427775f, 0.276824f, 0.444405f, 0.250252f, 0.416991f, 0.439695f, 0.656460f, 0.349813f, 0.809702f, 0.384795f, 0.548751f, 0.425031f, 0.590767f,
0.265164f, 0.321549f, 0.126824f, 0.342577f, 0.280674f, 0.413098f, 0.221977f, 0.310301f, 0.227243f, 0.311047f, 0.158165f, 0.307131f, 0.621947f, 0.813162f, 0.601006f, 0.700808f,
0.282476f, 0.343039f, 0.167696f, 0.382049f, 0.321848f, 0.474386f, 0.315946f, 0.372500f, 0.475857f, 0.652288f, 0.411103f, 0.673292f, 0.538657f, 0.705284f, 0.646090f, 0.635406f,
1.090418f, 1.138793f, 0.525598f, 1.265492f, 0.817205f, 1.035861f, 0.651347f, 0.811587f, 0.885710f, 1.044105f, 0.621275f, 1.075344f, 1.952932f, 2.199022f, 1.901899f, 1.976769f,
0.129859f, 0.154279f, 0.066270f, 0.196745f, 0.223014f, 0.321576f, 0.188188f, 0.289134f, 0.241227f, 0.323490f, 0.179143f, 0.382337f, 0.326530f, 0.418260f, 0.336668f, 0.431474f,
3.542748f, 4.437703f, 2.033758f, 3.716616f, 3.994235f, 6.072541f, 3.791523f, 3.585741f, 2.970902f, 4.200562f, 2.481874f, 3.260507f, 6.519543f, 8.804924f, 7.561637f, 5.965224f,
1.807277f, 2.267103f, 1.287772f, 1.984840f, 2.193306f, 3.339372f, 2.584251f, 2.061285f, 2.979136f, 4.218305f, 3.089135f, 3.422791f, 2.703909f, 3.657036f, 3.892657f, 2.589972f,
6.373824f, 6.876020f, 3.687516f, 6.006625f, 5.087961f, 6.661924f, 4.867418f, 4.103099f, 5.066050f, 6.168897f, 4.265162f, 4.994468f, 8.956366f, 10.417400f, 10.469000f, 7.361467f,
1.107588f, 1.359241f, 0.678409f, 1.362611f, 2.026010f, 3.017718f, 2.051994f, 2.132914f, 2.013267f, 2.788821f, 1.794516f, 2.591103f, 2.185064f, 2.891166f, 2.704067f, 2.344554f,
0.001355f, 0.001650f, 0.002784f, 0.007689f, 0.001175f, 0.001737f, 0.003992f, 0.005706f, 0.000025f, 0.000035f, 0.000075f, 0.000149f, 0.000981f, 0.001288f, 0.004071f, 0.004853f,
0.000919f, 0.001120f, 0.002342f, 0.005456f, 0.000857f, 0.001269f, 0.003615f, 0.004358f, 0.000033f, 0.000046f, 0.000124f, 0.000208f, 0.000541f, 0.000711f, 0.002784f, 0.002800f,
0.004673f, 0.004899f, 0.009673f, 0.023814f, 0.002869f, 0.003651f, 0.009821f, 0.012512f, 0.000082f, 0.000097f, 0.000247f, 0.000438f, 0.002582f, 0.002919f, 0.010801f, 0.011478f,
0.000040f, 0.000048f, 0.000088f, 0.000266f, 0.000056f, 0.000082f, 0.000204f, 0.000321f, 0.000002f, 0.000002f, 0.000005f, 0.000011f, 0.000031f, 0.000040f, 0.000138f, 0.000180f,
1.844220f, 2.423983f, 1.011376f, 2.407777f, 2.030965f, 3.239950f, 1.841719f, 2.269049f, 1.485238f, 2.203505f, 1.185300f, 2.028565f, 2.998505f, 4.249250f, 3.322342f, 3.414370f,
0.984785f, 1.296245f, 0.670343f, 1.345980f, 1.167381f, 1.864993f, 1.313981f, 1.365361f, 1.558987f, 2.316269f, 1.544294f, 2.229096f, 1.301740f, 1.847398f, 1.790273f, 1.551756f,
4.941503f, 5.593647f, 2.731076f, 5.795430f, 3.853001f, 5.293635f, 3.521234f, 3.866905f, 3.771931f, 4.819485f, 3.033686f, 4.627853f, 6.134879f, 7.487426f, 6.850470f, 6.275303f,
0.561366f, 0.722875f, 0.328474f, 0.859481f, 1.003011f, 1.567624f, 0.970468f, 1.314116f, 0.979952f, 1.424370f, 0.834433f, 1.569582f, 0.978470f, 1.358486f, 1.156755f, 1.306591f,
0.178905f, 0.224114f, 0.101467f, 0.211129f, 0.169663f, 0.257961f, 0.159115f, 0.171337f, 0.161529f, 0.228401f, 0.133317f, 0.199418f, 0.387362f, 0.523185f, 0.443875f, 0.398699f,
0.128529f, 0.161242f, 0.090482f, 0.158789f, 0.131204f, 0.199776f, 0.152731f, 0.138709f, 0.228111f, 0.323016f, 0.233689f, 0.294819f, 0.226249f, 0.306023f, 0.321800f, 0.243786f,
0.785856f, 0.847832f, 0.449181f, 0.833090f, 0.527666f, 0.690947f, 0.498722f, 0.478680f, 0.672500f, 0.818956f, 0.559375f, 0.745814f, 1.299251f, 1.511300f, 1.500415f, 1.201280f,
0.096173f, 0.118033f, 0.058199f, 0.133096f, 0.147975f, 0.220423f, 0.148070f, 0.175242f, 0.188216f, 0.260739f, 0.165748f, 0.272495f, 0.223233f, 0.295391f, 0.272933f, 0.269447f,
2.354076f, 3.046165f, 1.602498f, 2.255850f, 2.377889f, 3.734594f, 2.676638f, 1.949930f, 2.079790f, 3.037760f, 2.060292f, 2.084964f, 3.999017f, 5.579262f, 5.500090f, 3.342297f,
0.809872f, 1.049489f, 0.684303f, 0.812455f, 0.880580f, 1.384998f, 1.230331f, 0.755944f, 1.406478f, 2.057290f, 1.729407f, 1.476064f, 1.118509f, 1.562758f, 1.909464f, 0.978644f,
4.524004f, 5.041676f, 3.103664f, 3.894355f, 3.235522f, 4.376382f, 3.670431f, 2.383388f, 3.788291f, 4.765366f, 3.782050f, 3.411498f, 5.868277f, 7.051039f, 8.133958f, 4.405805f,
0.807850f, 1.024151f, 0.586762f, 0.907835f, 1.323951f, 2.037155f, 1.590100f, 1.273169f, 1.547053f, 2.213805f, 1.635192f, 1.818739f, 1.471204f, 2.010928f, 2.158957f, 1.441953f,
0.011046f, 0.013892f, 0.026907f, 0.057244f, 0.008582f, 0.013100f, 0.034567f, 0.038058f, 0.000216f, 0.000306f, 0.000765f, 0.001170f, 0.007380f, 0.010007f, 0.036318f, 0.033354f,
0.005049f, 0.006359f, 0.015266f, 0.027393f, 0.004223f, 0.006455f, 0.021111f, 0.019604f, 0.000194f, 0.000276f, 0.000853f, 0.001100f, 0.002742f, 0.003724f, 0.016753f, 0.012976f,
0.040680f, 0.044063f, 0.099865f, 0.189379f, 0.022378f, 0.029419f, 0.090838f, 0.089146f, 0.000753f, 0.000921f, 0.002691f, 0.003668f, 0.020752f, 0.024235f, 0.102928f, 0.084258f,
0.000358f, 0.000441f, 0.000931f, 0.002177f, 0.000452f, 0.000675f, 0.001941f, 0.002349f, 0.000015f, 0.000021f, 0.000057f, 0.000096f, 0.000257f, 0.000341f, 0.001347f, 0.001360f,
2.268873f, 3.080648f, 1.475462f, 2.705801f, 2.238606f, 3.689167f, 2.407224f, 2.284553f, 1.925061f, 2.950375f, 1.821774f, 2.401704f, 3.405321f, 4.985176f, 4.474201f, 3.541979f,
0.817053f, 1.110992f, 0.659513f, 1.020069f, 0.867759f, 1.432117f, 1.158226f, 0.927078f, 1.362706f, 2.091528f, 1.600691f, 1.779797f, 0.996986f, 1.461639f, 1.625929f, 1.085601f,
6.493803f, 7.593641f, 4.255903f, 6.956772f, 4.536458f, 6.438529f, 4.916211f, 4.158755f, 5.222214f, 6.892972f, 4.980574f, 5.852651f, 7.442210f, 9.383036f, 9.854490f, 6.953648f,
0.758082f, 1.008436f, 0.526003f, 1.060201f, 1.213538f, 1.959316f, 1.392345f, 1.452324f, 1.394201f, 2.093431f, 1.407764f, 2.039797f, 1.219757f, 1.749427f, 1.709957f, 1.487810f,
0.307528f, 0.341696f, 0.151307f, 0.407411f, 0.345941f, 0.466527f, 0.281448f, 0.392183f, 0.277847f, 0.348468f, 0.198936f, 0.385073f, 0.663534f, 0.794895f, 0.659597f, 0.766680f,
0.245359f, 0.273015f, 0.149842f, 0.340286f, 0.297099f, 0.401241f, 0.300022f, 0.352599f, 0.435754f, 0.547302f, 0.387262f, 0.632226f, 0.430400f, 0.516354f, 0.531059f, 0.520615f,
0.912438f, 0.873129f, 0.452433f, 1.085863f, 0.726728f, 0.844045f, 0.595858f, 0.740084f, 0.781351f, 0.843960f, 0.563805f, 0.972763f, 1.503272f, 1.550968f, 1.506009f, 1.560311f,
0.105793f, 0.115164f, 0.055538f, 0.164359f, 0.193084f, 0.255107f, 0.167609f, 0.256696f, 0.207184f, 0.254573f, 0.158277f, 0.336728f, 0.244707f, 0.287206f, 0.259548f, 0.331577f,
5.884053f, 6.753321f, 3.474765f, 6.329786f, 7.050182f, 9.821097f, 6.884466f, 6.490088f, 5.201981f, 6.739235f, 4.470436f, 5.854240f, 9.960779f, 12.326070f, 11.884530f, 9.345616f,
2.248076f, 2.583929f, 1.647841f, 2.531727f, 2.899453f, 4.044869f, 3.514320f, 2.794215f, 3.906796f, 5.068638f, 4.167323f, 4.602734f, 3.093986f, 3.834232f, 4.582076f, 3.038970f,
7.637949f, 7.549820f, 4.545697f, 7.380948f, 6.479639f, 7.773731f, 6.376693f, 5.358263f, 6.400151f, 7.140869f, 5.543016f, 6.470158f, 9.872983f, 10.522010f, 11.871670f, 8.321199f,
1.292198f, 1.453015f, 0.814203f, 1.630152f, 2.512019f, 3.428332f, 2.617263f, 2.711813f, 2.476262f, 3.142958f, 2.270556f, 3.268020f, 2.345067f, 2.843065f, 2.985370f, 2.580217f,
0.001335f, 0.001489f, 0.002821f, 0.007765f, 0.001230f, 0.001665f, 0.004298f, 0.006124f, 0.000026f, 0.000033f, 0.000080f, 0.000159f, 0.000889f, 0.001069f, 0.003794f, 0.004509f,
0.000678f, 0.000757f, 0.001777f, 0.004127f, 0.000672f, 0.000911f, 0.002915f, 0.003503f, 0.000026f, 0.000033f, 0.000099f, 0.000166f, 0.000367f, 0.000442f, 0.001943f, 0.001948f,
0.003320f, 0.003190f, 0.007071f, 0.017352f, 0.002167f, 0.002526f, 0.007629f, 0.009689f, 0.000062f, 0.000067f, 0.000191f, 0.000336f, 0.001688f, 0.001748f, 0.007263f, 0.007693f,
0.000028f, 0.000030f, 0.000062f, 0.000189f, 0.000041f, 0.000055f, 0.000154f, 0.000242f, 0.000001f, 0.000001f, 0.000004f, 0.000008f, 0.000020f, 0.000023f, 0.000090f, 0.000118f,
2.434514f, 2.931919f, 1.373416f, 3.259274f, 2.849262f, 4.164769f, 2.657928f, 3.264215f, 2.066996f, 2.809832f, 1.696921f, 2.894926f, 3.641197f, 4.727967f, 4.150243f, 4.251624f,
0.973624f, 1.174248f, 0.681768f, 1.364562f, 1.226571f, 1.795477f, 1.420230f, 1.471067f, 1.624936f, 2.212104f, 1.655821f, 2.382470f, 1.183896f, 1.539475f, 1.674937f, 1.447164f,
4.706509f, 4.881550f, 2.675861f, 5.660183f, 3.900042f, 4.909610f, 3.666527f, 4.013643f, 3.787456f, 4.434120f, 3.133606f, 4.765061f, 5.375090f, 6.010839f, 6.174332f, 5.637927f,
0.520547f, 0.614187f, 0.313332f, 0.817251f, 0.988440f, 1.415498f, 0.983820f, 1.327955f, 0.957994f, 1.275863f, 0.839150f, 1.573429f, 0.834644f, 1.061774f, 1.015045f, 1.142875f,
0.277518f, 0.345670f, 0.124015f, 0.412220f, 0.231785f, 0.350409f, 0.171273f, 0.294619f, 0.304793f, 0.428525f, 0.198207f, 0.473622f, 0.660047f, 0.886414f, 0.595933f, 0.855096f,
0.180554f, 0.225220f, 0.100149f, 0.280762f, 0.162324f, 0.245754f, 0.148882f, 0.215999f, 0.389796f, 0.548831f, 0.314636f, 0.634101f, 0.349125f, 0.469539f, 0.391254f, 0.473494f,
1.132696f, 1.215077f, 0.510119f, 1.511383f, 0.669820f, 0.872101f, 0.498812f, 0.764816f, 1.179094f, 1.427709f, 0.772749f, 1.645882f, 2.057086f, 2.379213f, 1.871760f, 2.393953f,
0.132772f, 0.162024f, 0.063306f, 0.231276f, 0.179917f, 0.266478f, 0.141850f, 0.268184f, 0.316079f, 0.435380f, 0.219314f, 0.575983f, 0.338532f, 0.445412f, 0.326120f, 0.514312f,
2.717583f, 3.496545f, 1.457603f, 3.277817f, 2.417590f, 3.775356f, 2.144175f, 2.495299f, 2.920568f, 4.241551f, 2.279586f, 3.685179f, 5.071127f, 7.034793f, 5.495415f, 5.334683f,
0.846671f, 1.090937f, 0.563672f, 1.069080f, 0.810767f, 1.267943f, 0.892542f, 0.876050f, 1.788615f, 2.601374f, 1.732849f, 2.362661f, 1.284479f, 1.784443f, 1.727740f, 1.414570f,
4.852736f, 5.377272f, 2.623118f, 5.257891f, 3.056588f, 4.110845f, 2.732053f, 2.833999f, 4.943022f, 6.182568f, 3.888266f, 5.602821f, 6.914539f, 8.260934f, 7.551515f, 6.534168f,
0.829998f, 1.046245f, 0.474994f, 1.173993f, 1.197973f, 1.832831f, 1.133650f, 1.450017f, 1.933467f, 2.751024f, 1.610200f, 2.860978f, 1.660382f, 2.256602f, 1.919811f, 2.048323f,
0.004024f, 0.005032f, 0.007724f, 0.026249f, 0.002754f, 0.004179f, 0.008739f, 0.015370f, 0.000096f, 0.000135f, 0.000267f, 0.000653f, 0.002953f, 0.003982f, 0.011452f, 0.016801f,
0.001666f, 0.002086f, 0.003969f, 0.011375f, 0.001227f, 0.001865f, 0.004833f, 0.007170f, 0.000078f, 0.000110f, 0.000270f, 0.000556f, 0.000994f, 0.001342f, 0.004784f, 0.005919f,
0.013771f, 0.014831f, 0.026637f, 0.080691f, 0.006672f, 0.008721f, 0.021338f, 0.033452f, 0.000310f, 0.000377f, 0.000873f, 0.001901f, 0.007717f, 0.008961f, 0.030157f, 0.039436f,
0.000116f, 0.000142f, 0.000238f, 0.000889f, 0.000129f, 0.000192f, 0.000437f, 0.000844f, 0.000006f, 0.000008f, 0.000018f, 0.000048f, 0.000091f, 0.000121f, 0.000378f, 0.000610f,
2.169210f, 2.928578f, 1.111473f, 3.256115f, 1.884942f, 3.088674f, 1.597041f, 2.421218f, 2.238831f, 3.411753f, 1.669363f, 3.515675f, 3.576337f, 5.205761f, 3.702332f, 4.682079f,
0.707421f, 0.956449f, 0.449915f, 1.111654f, 0.661692f, 1.085822f, 0.695872f, 0.889785f, 1.435210f, 2.190284f, 1.328312f, 2.359371f, 0.948212f, 1.382229f, 1.218422f, 1.299568f,
5.768886f, 6.707586f, 2.978956f, 7.778807f, 3.549266f, 5.008778f, 3.030621f, 4.095411f, 5.643299f, 7.406420f, 4.240698f, 7.960556f, 7.262460f, 9.104343f, 7.576968f, 8.540965f,
0.645047f, 0.853192f, 0.352649f, 1.135470f, 0.909405f, 1.459930f, 0.822111f, 1.369872f, 1.443066f, 2.154481f, 1.148075f, 2.657419f, 1.140085f, 1.625861f, 1.259299f, 1.750347f,
0.062672f, 0.075999f, 0.029975f, 0.080969f, 0.061459f, 0.090456f, 0.048606f, 0.067946f, 0.047865f, 0.065517f, 0.033315f, 0.064693f, 0.236474f, 0.309177f, 0.228512f, 0.266458f,
0.081601f, 0.099096f, 0.048443f, 0.110365f, 0.086136f, 0.126960f, 0.084557f, 0.099692f, 0.122507f, 0.167928f, 0.105836f, 0.173335f, 0.250319f, 0.327753f, 0.300245f, 0.295280f,
0.311366f, 0.325179f, 0.150083f, 0.361358f, 0.216189f, 0.274034f, 0.172312f, 0.214703f, 0.225394f, 0.265702f, 0.158101f, 0.273651f, 0.897090f, 1.010134f, 0.873648f, 0.908040f,
0.044378f, 0.052723f, 0.022647f, 0.067235f, 0.070607f, 0.101813f, 0.059582f, 0.091542f, 0.073467f, 0.098521f, 0.054559f, 0.116443f, 0.179510f, 0.229939f, 0.185084f, 0.237203f,
1.338541f, 1.676678f, 0.768406f, 1.404233f, 1.398136f, 2.125624f, 1.327179f, 1.255148f, 1.000350f, 1.414396f, 0.835686f, 1.097865f, 3.962594f, 5.351655f, 4.595982f, 3.625678f,
0.834580f, 1.046923f, 0.594679f, 0.916577f, 0.938356f, 1.428673f, 1.105612f, 0.881873f, 1.226044f, 1.736016f, 1.271314f, 1.408628f, 2.008661f, 2.716714f, 2.891750f, 1.924021f,
2.909447f, 3.138682f, 1.683233f, 2.741832f, 2.151685f, 2.817309f, 2.058418f, 1.735189f, 2.060877f, 2.509517f, 1.735075f, 2.031757f, 6.576779f, 7.649637f, 7.687529f, 5.405624f,
0.605069f, 0.742545f, 0.370611f, 0.744387f, 1.025399f, 1.527320f, 1.038550f, 1.079505f, 0.980168f, 1.357750f, 0.873668f, 1.261490f, 1.920269f, 2.540803f, 2.376377f, 2.060432f,
0.002017f, 0.002456f, 0.004144f, 0.011445f, 0.001621f, 0.002395f, 0.005505f, 0.007869f, 0.000033f, 0.000046f, 0.000100f, 0.000198f, 0.002349f, 0.003083f, 0.009748f, 0.011622f,
0.001671f, 0.002038f, 0.004261f, 0.009926f, 0.001445f, 0.002139f, 0.006094f, 0.007346f, 0.000054f, 0.000075f, 0.000201f, 0.000337f, 0.001582f, 0.002079f, 0.008149f, 0.008194f,
0.008403f, 0.008811f, 0.017396f, 0.042826f, 0.004780f, 0.006083f, 0.016363f, 0.020846f, 0.000132f, 0.000156f, 0.000396f, 0.000702f, 0.007470f, 0.008445f, 0.031246f, 0.033205f,
0.000086f, 0.000103f, 0.000189f, 0.000573f, 0.000112f, 0.000163f, 0.000407f, 0.000640f, 0.000003f, 0.000004f, 0.000010f, 0.000021f, 0.000108f, 0.000138f, 0.000476f, 0.000624f,
0.568840f, 0.747665f, 0.311953f, 0.742666f, 0.580369f, 0.925849f, 0.526290f, 0.648404f, 0.408268f, 0.605708f, 0.325820f, 0.557620f, 1.487829f, 2.108437f, 1.648514f, 1.694177f,
0.371254f, 0.488671f, 0.252712f, 0.507421f, 0.407724f, 0.651375f, 0.458926f, 0.476872f, 0.523774f, 0.778199f, 0.518838f, 0.748911f, 0.789450f, 1.120369f, 1.085725f, 0.941074f,
1.841430f, 2.084449f, 1.017724f, 2.159642f, 1.330209f, 1.827573f, 1.215670f, 1.335009f, 1.252657f, 1.600550f, 1.007486f, 1.536908f, 3.677675f, 4.488486f, 4.106650f, 3.761855f,
0.250356f, 0.322386f, 0.146492f, 0.383309f, 0.414422f, 0.647708f, 0.400976f, 0.542964f, 0.389484f, 0.566119f, 0.331647f, 0.623834f, 0.701990f, 0.974628f, 0.829899f, 0.937397f,
0.040595f, 0.050853f, 0.023024f, 0.047907f, 0.035667f, 0.054229f, 0.033449f, 0.036018f, 0.032664f, 0.046187f, 0.026959f, 0.040326f, 0.141396f, 0.190975f, 0.162025f, 0.145534f,
0.035645f, 0.044718f, 0.025094f, 0.044037f, 0.033711f, 0.051330f, 0.039242f, 0.035639f, 0.056379f, 0.079836f, 0.057758f, 0.072867f, 0.100939f, 0.136530f, 0.143568f, 0.108763f,
0.215433f, 0.232423f, 0.123137f, 0.228381f, 0.134015f, 0.175484f, 0.126663f, 0.121573f, 0.164298f, 0.200079f, 0.136661f, 0.182210f, 0.572971f, 0.666485f, 0.661685f, 0.529766f,
0.031553f, 0.038725f, 0.019094f, 0.043667f, 0.044978f, 0.066999f, 0.045007f, 0.053266f, 0.055032f, 0.076237f, 0.048462f, 0.079674f, 0.117819f, 0.155903f, 0.144050f, 0.142210f,
0.853891f, 1.104931f, 0.581272f, 0.818261f, 0.799094f, 1.255018f, 0.899489f, 0.655278f, 0.672316f, 0.981991f, 0.666013f, 0.673989f, 2.333492f, 3.255590f, 3.209392f, 1.950285f,
0.359046f, 0.465277f, 0.303377f, 0.360191f, 0.361682f, 0.568863f, 0.505336f, 0.310490f, 0.555698f, 0.812834f, 0.683288f, 0.583192f, 0.797709f, 1.114543f, 1.361811f, 0.697959f,
1.982548f, 2.209407f, 1.360115f, 1.706618f, 1.313620f, 1.776808f, 1.490193f, 0.967654f, 1.479505f, 1.861098f, 1.477067f, 1.332350f, 4.136971f, 4.970785f, 5.734214f, 3.105970f,
0.423690f, 0.537132f, 0.307737f, 0.476129f, 0.643301f, 0.989842f, 0.772621f, 0.618625f, 0.723094f, 1.034734f, 0.764290f, 0.850081f, 1.241256f, 1.696622f, 1.821513f, 1.216577f,
0.015785f, 0.019853f, 0.038451f, 0.081804f, 0.011362f, 0.017344f, 0.045765f, 0.050387f, 0.000275f, 0.000390f, 0.000974f, 0.001490f, 0.016965f, 0.023004f, 0.083491f, 0.076678f,
0.008819f, 0.011108f, 0.026664f, 0.047845f, 0.006833f, 0.010445f, 0.034161f, 0.031722f, 0.000302f, 0.000429f, 0.001328f, 0.001713f, 0.007706f, 0.010464f, 0.047071f, 0.036461f,
0.070234f, 0.076075f, 0.172417f, 0.326961f, 0.035794f, 0.047056f, 0.145297f, 0.142590f, 0.001159f, 0.001417f, 0.004140f, 0.005644f, 0.057637f, 0.067311f, 0.285871f, 0.234018f,
0.000740f, 0.000912f, 0.001924f, 0.004499f, 0.000865f, 0.001293f, 0.003715f, 0.004496f, 0.000028f, 0.000039f, 0.000106f, 0.000178f, 0.000853f, 0.001133f, 0.004479f, 0.004521f,
0.671859f, 0.912241f, 0.436914f, 0.801242f, 0.614144f, 1.012094f, 0.660403f, 0.626749f, 0.508024f, 0.778605f, 0.480767f, 0.633811f, 1.622172f, 2.374758f, 2.131348f, 1.687271f,
0.295713f, 0.402097f, 0.238695f, 0.369190f, 0.290967f, 0.480201f, 0.388363f, 0.310857f, 0.439536f, 0.674615f, 0.516297f, 0.574067f, 0.580470f, 0.851003f, 0.946657f, 0.632064f,
2.323196f, 2.716669f, 1.522574f, 2.488826f, 1.503585f, 2.134017f, 1.629453f, 1.378398f, 1.664998f, 2.197685f, 1.587956f, 1.866000f, 4.283115f, 5.400092f, 5.671422f, 4.001940f,
0.324578f, 0.431769f, 0.225212f, 0.453933f, 0.481372f, 0.777199f, 0.552299f, 0.576091f, 0.531987f, 0.798793f, 0.537162f, 0.778327f, 0.840132f, 1.204953f, 1.177767f, 1.024759f,
0.048993f, 0.054436f, 0.024105f, 0.064906f, 0.051060f, 0.068858f, 0.041541f, 0.057885f, 0.039448f, 0.049475f, 0.028245f, 0.054672f, 0.170053f, 0.203719f, 0.169044f, 0.196488f,
0.047775f, 0.053160f, 0.029177f, 0.066259f, 0.053595f, 0.072382f, 0.054123f, 0.063607f, 0.075616f, 0.094973f, 0.067201f, 0.109710f, 0.134817f, 0.161741f, 0.166347f, 0.163076f,
0.175619f, 0.168053f, 0.087081f, 0.208999f, 0.129588f, 0.150508f, 0.106252f, 0.131970f, 0.134025f, 0.144765f, 0.096710f, 0.166858f, 0.465455f, 0.480223f, 0.466302f, 0.483116f,
0.024369f, 0.026528f, 0.012793f, 0.037860f, 0.041206f, 0.054442f, 0.035769f, 0.054781f, 0.042532f, 0.052260f, 0.032492f, 0.069125f, 0.090678f, 0.106427f, 0.096178f, 0.122869f,
1.498507f, 1.719886f, 0.884927f, 1.612023f, 1.663440f, 2.317217f, 1.624340f, 1.531290f, 1.180656f, 1.529555f, 1.014622f, 1.328694f, 4.080812f, 5.049844f, 4.868948f, 3.828787f,
0.699754f, 0.804294f, 0.512920f, 0.788045f, 0.836132f, 1.166443f, 1.013445f, 0.805784f, 1.083746f, 1.406041f, 1.156016f, 1.276799f, 1.549259f, 1.919924f, 2.294393f, 1.521710f,
2.350054f, 2.322939f, 1.398626f, 2.270980f, 1.847041f, 2.215926f, 1.817696f, 1.527389f, 1.754946f, 1.958053f, 1.519916f, 1.774142f, 4.886756f, 5.208001f, 5.876030f, 4.118681f,
0.475824f, 0.535042f, 0.299813f, 0.600269f, 0.856969f, 1.169567f, 0.892873f, 0.925128f, 0.812618f, 1.031403f, 0.745113f, 1.072444f, 1.389133f, 1.684130f, 1.768426f, 1.528428f,
0.001339f, 0.001494f, 0.002830f, 0.007791f, 0.001143f, 0.001548f, 0.003995f, 0.005692f, 0.000023f, 0.000029f, 0.000072f, 0.000142f, 0.001434f, 0.001725f, 0.006123f, 0.007277f,
0.000831f, 0.000928f, 0.002179f, 0.005061f, 0.000764f, 0.001035f, 0.003312f, 0.003980f, 0.000028f, 0.000036f, 0.000109f, 0.000181f, 0.000723f, 0.000871f, 0.003834f, 0.003843f,
0.004025f, 0.003867f, 0.008571f, 0.021034f, 0.002433f, 0.002837f, 0.008568f, 0.010881f, 0.000066f, 0.000072f, 0.000206f, 0.000363f, 0.003291f, 0.003409f, 0.014162f, 0.015002f,
0.000040f, 0.000044f, 0.000091f, 0.000274f, 0.000056f, 0.000074f, 0.000208f, 0.000325f, 0.000002f, 0.000002f, 0.000005f, 0.000011f, 0.000046f, 0.000054f, 0.000210f, 0.000275f,
0.506151f, 0.609565f, 0.285542f, 0.677624f, 0.548814f, 0.802202f, 0.511960f, 0.628740f, 0.382983f, 0.520620f, 0.314414f, 0.536386f, 1.217821f, 1.581298f, 1.388074f, 1.421982f,
0.247407f, 0.298387f, 0.173243f, 0.346748f, 0.288760f, 0.422693f, 0.334352f, 0.346320f, 0.367984f, 0.500954f, 0.374978f, 0.539535f, 0.483955f, 0.629309f, 0.684684f, 0.591574f,
1.182186f, 1.226153f, 0.672126f, 1.421731f, 0.907572f, 1.142506f, 0.853231f, 0.934007f, 0.847826f, 0.992583f, 0.701461f, 1.066664f, 2.171920f, 2.428808f, 2.494871f, 2.278125f,
0.156482f, 0.184631f, 0.094191f, 0.245674f, 0.275282f, 0.394219f, 0.273996f, 0.369838f, 0.256649f, 0.341806f, 0.224810f, 0.421525f, 0.403623f, 0.513460f, 0.490863f, 0.552679f,
0.041071f, 0.051157f, 0.018353f, 0.061006f, 0.031780f, 0.048045f, 0.023483f, 0.040395f, 0.040200f, 0.056519f, 0.026142f, 0.062467f, 0.157141f, 0.211034f, 0.141877f, 0.203578f,
0.032659f, 0.040738f, 0.018115f, 0.050785f, 0.027202f, 0.041183f, 0.024950f, 0.036197f, 0.062836f, 0.088472f, 0.050720f, 0.102218f, 0.101589f, 0.136628f, 0.113848f, 0.137779f,
0.202524f, 0.217254f, 0.091208f, 0.270233f, 0.110955f, 0.144462f, 0.082628f, 0.126691f, 0.187882f, 0.227497f, 0.123133f, 0.262261f, 0.591680f, 0.684334f, 0.538375f, 0.688574f,
0.028411f, 0.034670f, 0.013546f, 0.049489f, 0.035668f, 0.052828f, 0.028121f, 0.053166f, 0.060276f, 0.083027f, 0.041823f, 0.109840f, 0.116534f, 0.153325f, 0.112261f, 0.177043f,
0.642924f, 0.827210f, 0.344839f, 0.775464f, 0.529888f, 0.827484f, 0.469961f, 0.546920f, 0.615767f, 0.894281f, 0.480624f, 0.776976f, 1.929979f, 2.677314f, 2.091455f, 2.030283f,
0.244818f, 0.315449f, 0.162988f, 0.309129f, 0.217195f, 0.339667f, 0.239101f, 0.234684f, 0.460912f, 0.670354f, 0.446542f, 0.608840f, 0.597485f, 0.830047f, 0.803672f, 0.657998f,
1.387019f, 1.536943f, 0.749745f, 1.502821f, 0.809389f, 1.088558f, 0.723452f, 0.750447f, 1.259101f, 1.574842f, 0.990431f, 1.427167f, 3.179291f, 3.798360f, 3.472171f, 3.004397f,
0.283916f, 0.357887f, 0.162480f, 0.401585f, 0.379650f, 0.580844f, 0.359266f, 0.459526f, 0.589415f, 0.838646f, 0.490868f, 0.872166f, 0.913674f, 1.241762f, 1.056433f, 1.127151f,
0.003751f, 0.004691f, 0.007199f, 0.024466f, 0.002378f, 0.003609f, 0.007546f, 0.013272f, 0.000079f, 0.000112f, 0.000222f, 0.000542f, 0.004428f, 0.005970f, 0.017171f, 0.025191f,
0.001898f, 0.002377f, 0.004521f, 0.012959f, 0.001295f, 0.001968f, 0.005101f, 0.007567f, 0.000079f, 0.000112f, 0.000274f, 0.000564f, 0.001821f, 0.002459f, 0.008767f, 0.010848f,
0.015507f, 0.016701f, 0.029994f, 0.090863f, 0.006960f, 0.009098f, 0.022261f, 0.034899f, 0.000311f, 0.000378f, 0.000876f, 0.001908f, 0.013979f, 0.016232f, 0.054628f, 0.071438f,
0.000157f, 0.000192f, 0.000321f, 0.001198f, 0.000161f, 0.000239f, 0.000545f, 0.001054f, 0.000007f, 0.000010f, 0.000021f, 0.000058f, 0.000198f, 0.000262f, 0.000820f, 0.001322f,
0.418952f, 0.565613f, 0.214665f, 0.628872f, 0.337276f, 0.552662f, 0.285761f, 0.433233f, 0.385351f, 0.587236f, 0.287333f, 0.605123f, 1.111149f, 1.617403f, 1.150295f, 1.454697f,
0.166991f, 0.225776f, 0.106205f, 0.262412f, 0.144709f, 0.237464f, 0.152184f, 0.194592f, 0.301928f, 0.460774f, 0.279439f, 0.496345f, 0.360074f, 0.524887f, 0.462683f, 0.493498f,
1.346089f, 1.565121f, 0.695098f, 1.815076f, 0.767264f, 1.082775f, 0.655146f, 0.885327f, 1.173511f, 1.540148f, 0.881843f, 1.655379f, 2.726068f, 3.417444f, 2.844123f, 3.205973f,
0.180131f, 0.238257f, 0.098478f, 0.317084f, 0.235278f, 0.377707f, 0.212693f, 0.354407f, 0.359134f, 0.536183f, 0.285720f, 0.661349f, 0.512161f, 0.730387f, 0.565716f, 0.786309f,
0.413275f, 0.501156f, 0.197663f, 0.533929f, 0.325699f, 0.479367f, 0.257586f, 0.360079f, 0.273145f, 0.373876f, 0.190113f, 0.369170f, 0.943875f, 1.234065f, 0.912095f, 1.063556f,
0.646110f, 0.784636f, 0.383573f, 0.873864f, 0.548106f, 0.807876f, 0.538055f, 0.634365f, 0.839418f, 1.150644f, 0.725190f, 1.187694f, 1.199698f, 1.570812f, 1.438973f, 1.415178f,
2.034871f, 2.125147f, 0.980839f, 2.361585f, 1.135439f, 1.439245f, 0.904993f, 1.127634f, 1.274713f, 1.502677f, 0.894140f, 1.547635f, 3.548678f, 3.995850f, 3.455946f, 3.591992f,
0.215703f, 0.256266f, 0.110077f, 0.326804f, 0.275806f, 0.397700f, 0.232737f, 0.357579f, 0.309020f, 0.414401f, 0.229488f, 0.489786f, 0.528131f, 0.676496f, 0.544529f, 0.697869f,
5.277797f, 6.611053f, 3.029784f, 5.536817f, 4.430318f, 6.735530f, 4.205474f, 3.977226f, 3.413327f, 4.826105f, 2.851472f, 3.746059f, 9.457252f, 12.772430f, 10.968910f, 8.653157f,
3.951263f, 4.956586f, 2.815467f, 4.339471f, 3.570257f, 5.435820f, 4.206636f, 3.355353f, 5.023179f, 7.112567f, 5.208651f, 5.771236f, 5.756240f, 7.785313f, 8.286915f, 5.513684f,
11.369230f, 12.265020f, 6.577563f, 10.714240f, 6.757152f, 8.847479f, 6.464256f, 5.449189f, 6.969114f, 8.486245f, 5.867372f, 6.870641f, 15.556010f, 18.093640f, 18.183260f, 12.785890f,
1.758524f, 2.158075f, 1.077115f, 2.163427f, 2.394973f, 3.567285f, 2.425690f, 2.521346f, 2.465181f, 3.414822f, 2.197326f, 3.172722f, 3.378080f, 4.469704f, 4.180451f, 3.624650f,
0.004191f, 0.005102f, 0.008609f, 0.023777f, 0.002706f, 0.003998f, 0.009191f, 0.013137f, 0.000060f, 0.000082f, 0.000179f, 0.000356f, 0.002953f, 0.003877f, 0.012257f, 0.014614f,
0.004169f, 0.005083f, 0.010630f, 0.024760f, 0.002897f, 0.004287f, 0.012215f, 0.014725f, 0.000117f, 0.000161f, 0.000435f, 0.000728f, 0.002388f, 0.003140f, 0.012304f, 0.012372f,
0.017301f, 0.018141f, 0.035817f, 0.088174f, 0.007909f, 0.010065f, 0.027074f, 0.034492f, 0.000234f, 0.000278f, 0.000706f, 0.001250f, 0.009310f, 0.010525f, 0.038939f, 0.041381f,
0.000132f, 0.000157f, 0.000289f, 0.000878f, 0.000138f, 0.000200f, 0.000501f, 0.000787f, 0.000004f, 0.000006f, 0.000013f, 0.000028f, 0.000100f, 0.000128f, 0.000442f, 0.000579f,
2.653185f, 3.487261f, 1.455015f, 3.463946f, 2.175435f, 3.470419f, 1.972727f, 2.430455f, 1.647889f, 2.444814f, 1.315104f, 2.250716f, 4.200442f, 5.952542f, 4.654087f, 4.783004f,
2.079195f, 2.736787f, 1.415307f, 2.841792f, 1.835081f, 2.931702f, 2.065530f, 2.146298f, 2.538477f, 3.771550f, 2.514553f, 3.629606f, 2.676168f, 3.797953f, 3.680513f, 3.190161f,
8.512017f, 9.635371f, 4.704432f, 9.982953f, 4.941529f, 6.789163f, 4.516033f, 4.959361f, 5.010882f, 6.402522f, 4.030149f, 6.147945f, 10.289990f, 12.558600f, 11.490240f, 10.525520f,
0.860714f, 1.108347f, 0.503632f, 1.317798f, 1.145005f, 1.789548f, 1.107855f, 1.500152f, 1.158762f, 1.684273f, 0.986691f, 1.855982f, 1.460816f, 2.028165f, 1.726989f, 1.950687f,
0.410004f, 0.513613f, 0.232537f, 0.483853f, 0.289496f, 0.440158f, 0.271498f, 0.292352f, 0.285491f, 0.403684f, 0.235629f, 0.352459f, 0.864407f, 1.167500f, 0.990517f, 0.889706f,
0.432281f, 0.542304f, 0.304316f, 0.534054f, 0.328550f, 0.500262f, 0.382456f, 0.347343f, 0.591683f, 0.837851f, 0.606150f, 0.764711f, 0.740947f, 1.002201f, 1.053868f, 0.798378f,
2.156393f, 2.326456f, 1.232555f, 2.286002f, 1.078034f, 1.411621f, 1.018901f, 0.977955f, 1.423162f, 1.733095f, 1.183764f, 1.578310f, 3.471470f, 4.038043f, 4.008958f, 3.209699f,
0.234897f, 0.288288f, 0.142147f, 0.325080f, 0.269093f, 0.400838f, 0.269266f, 0.318678f, 0.354534f, 0.491143f, 0.312212f, 0.513287f, 0.530906f, 0.702517f, 0.649106f, 0.640815f,
5.156721f, 6.672776f, 3.510351f, 4.941551f, 3.878231f, 6.090955f, 4.365476f, 3.180249f, 3.513579f, 5.131965f, 3.480638f, 3.522319f, 8.529858f, 11.900500f, 11.731630f, 7.129081f,
2.603565f, 3.373883f, 2.199888f, 2.611869f, 2.107704f, 3.315050f, 2.944848f, 1.809383f, 3.487081f, 5.100639f, 4.287720f, 3.659605f, 3.501282f, 4.891919f, 5.977217f, 3.063460f,
11.865740f, 13.223510f, 8.140413f, 10.214270f, 6.318369f, 8.546254f, 7.167665f, 4.654310f, 7.662881f, 9.639290f, 7.650257f, 6.900712f, 14.987110f, 18.007780f, 20.773470f, 11.252070f,
1.886001f, 2.390975f, 1.369851f, 2.119424f, 2.301293f, 3.540984f, 2.763913f, 2.213022f, 2.785436f, 3.985909f, 2.944129f, 3.274602f, 3.344409f, 4.571335f, 4.907840f, 3.277914f,
0.050226f, 0.063169f, 0.122345f, 0.260287f, 0.029054f, 0.044350f, 0.117024f, 0.128843f, 0.000757f, 0.001074f, 0.002682f, 0.004102f, 0.032673f, 0.044305f, 0.160800f, 0.147678f,
0.033693f, 0.042437f, 0.101872f, 0.182794f, 0.020980f, 0.032071f, 0.104888f, 0.097398f, 0.000998f, 0.001419f, 0.004390f, 0.005663f, 0.017819f, 0.024198f, 0.108854f, 0.084317f,
0.221477f, 0.239895f, 0.543701f, 1.031040f, 0.090709f, 0.119251f, 0.368214f, 0.361354f, 0.003162f, 0.003867f, 0.011298f, 0.015402f, 0.110013f, 0.128478f, 0.545651f, 0.446676f,
0.001736f, 0.002139f, 0.004512f, 0.010551f, 0.001629f, 0.002437f, 0.007003f, 0.008474f, 0.000057f, 0.000079f, 0.000214f, 0.000360f, 0.001211f, 0.001609f, 0.006358f, 0.006418f,
4.799606f, 6.516847f, 3.121213f, 5.723891f, 3.525835f, 5.810489f, 3.791410f, 3.598202f, 3.140631f, 4.813376f, 2.972124f, 3.918248f, 7.014374f, 10.268600f, 9.216083f, 7.295866f,
2.536558f, 3.449097f, 2.047472f, 3.166824f, 2.005776f, 3.310259f, 2.677174f, 2.142888f, 3.262674f, 5.007665f, 3.832472f, 4.261300f, 3.013830f, 4.418450f, 4.915091f, 3.281709f,
16.448000f, 19.233760f, 10.779680f, 17.620650f, 8.554996f, 12.141980f, 9.271147f, 7.842713f, 10.201070f, 13.464730f, 9.729053f, 11.432570f, 18.354870f, 23.141570f, 24.304330f, 17.149930f,
1.709107f, 2.273534f, 1.185883f, 2.390240f, 2.037022f, 3.288870f, 2.337163f, 2.437843f, 2.424130f, 3.639896f, 2.447712f, 3.546642f, 2.677700f, 3.840472f, 3.753824f, 3.266151f,
0.508870f, 0.565409f, 0.250370f, 0.674148f, 0.426200f, 0.574762f, 0.346745f, 0.483170f, 0.354572f, 0.444694f, 0.253871f, 0.491409f, 1.069107f, 1.280759f, 1.062763f, 1.235299f,
0.595832f, 0.662992f, 0.363877f, 0.826353f, 0.537170f, 0.725463f, 0.542455f, 0.637517f, 0.816093f, 1.025003f, 0.725275f, 1.184052f, 1.017721f, 1.220967f, 1.255740f, 1.231043f,
1.807775f, 1.729893f, 0.896385f, 2.151374f, 1.072016f, 1.245074f, 0.878968f, 1.091719f, 1.193889f, 1.289555f, 0.861483f, 1.486363f, 2.900106f, 2.992122f, 2.905387f, 3.010146f,
0.186569f, 0.203093f, 0.097942f, 0.289851f, 0.253522f, 0.334958f, 0.220073f, 0.337046f, 0.281782f, 0.346234f, 0.215266f, 0.457970f, 0.420207f, 0.493185f, 0.445690f, 0.569377f,
9.306487f, 10.681360f, 5.495848f, 10.011480f, 8.302299f, 11.565330f, 8.107152f, 7.642733f, 6.345342f, 8.220473f, 5.453008f, 7.140963f, 15.340440f, 18.983190f, 18.303180f, 14.393040f,
5.218182f, 5.997755f, 3.824930f, 5.876586f, 5.010870f, 6.990392f, 6.073491f, 4.828995f, 6.993684f, 9.073535f, 7.460062f, 8.239505f, 6.992975f, 8.666067f, 10.356330f, 6.868628f,
14.464540f, 14.297640f, 8.608516f, 13.977840f, 9.136240f, 10.960900f, 8.991087f, 7.555109f, 9.347493f, 10.429320f, 8.095637f, 9.449739f, 18.205880f, 19.402690f, 21.891470f, 15.344370f,
2.178193f, 2.449274f, 1.372460f, 2.747863f, 3.152673f, 4.302678f, 3.284758f, 3.403421f, 3.219146f, 4.085853f, 2.951728f, 4.248434f, 3.849087f, 4.666479f, 4.900053f, 4.235052f,
0.004382f, 0.004888f, 0.009260f, 0.025494f, 0.003007f, 0.004071f, 0.010506f, 0.014969f, 0.000066f, 0.000083f, 0.000203f, 0.000402f, 0.002841f, 0.003417f, 0.012128f, 0.014414f,
0.003265f, 0.003647f, 0.008563f, 0.019883f, 0.002411f, 0.003269f, 0.010458f, 0.012567f, 0.000097f, 0.000122f, 0.000369f, 0.000616f, 0.001721f, 0.002072f, 0.009118f, 0.009139f,
0.013052f, 0.012540f, 0.027796f, 0.068211f, 0.006341f, 0.007394f, 0.022330f, 0.028357f, 0.000186f, 0.000202f, 0.000578f, 0.001020f, 0.006461f, 0.006692f, 0.027799f, 0.029448f,
0.000097f, 0.000106f, 0.000219f, 0.000661f, 0.000108f, 0.000143f, 0.000402f, 0.000630f, 0.000003f, 0.000004f, 0.000010f, 0.000023f, 0.000067f, 0.000079f, 0.000307f, 0.000401f,
3.718466f, 4.478201f, 2.097749f, 4.978200f, 3.240207f, 4.736215f, 3.022620f, 3.712096f, 2.434828f, 3.309855f, 1.998896f, 3.410092f, 5.415407f, 7.031718f, 6.172492f, 6.323272f,
2.182437f, 2.632148f, 1.528224f, 3.058748f, 2.047067f, 2.996535f, 2.370272f, 2.455115f, 2.809078f, 3.824135f, 2.862471f, 4.118651f, 2.584043f, 3.360151f, 3.655817f, 3.158667f,
8.607343f, 8.927460f, 4.893659f, 10.351440f, 5.310414f, 6.685071f, 4.992453f, 5.465095f, 5.341889f, 6.253954f, 4.419688f, 6.720718f, 9.571750f, 10.703870f, 10.995010f, 10.039800f,
0.847364f, 0.999792f, 0.510051f, 1.330347f, 1.197978f, 1.715567f, 1.192378f, 1.609465f, 1.202678f, 1.601734f, 1.053479f, 1.975303f, 1.322959f, 1.682972f, 1.608905f, 1.811522f,
0.845225f, 1.052795f, 0.377708f, 1.255483f, 0.525600f, 0.794595f, 0.388383f, 0.668085f, 0.715918f, 1.006551f, 0.465563f, 1.112476f, 1.957457f, 2.628779f, 1.767319f, 2.535902f,
0.807025f, 1.006670f, 0.447637f, 1.254928f, 0.540196f, 0.817844f, 0.495463f, 0.718821f, 1.343679f, 1.891892f, 1.084591f, 2.185829f, 1.519488f, 2.043563f, 1.702847f, 2.060777f,
4.130608f, 4.431027f, 1.860253f, 5.511567f, 1.818642f, 2.367863f, 1.354336f, 2.076569f, 3.316088f, 4.015294f, 2.173283f, 4.628886f, 7.304466f, 8.448302f, 6.646395f, 8.500643f,
0.430970f, 0.525918f, 0.205487f, 0.750708f, 0.434810f, 0.644006f, 0.342814f, 0.648130f, 0.791248f, 1.089896f, 0.549013f, 1.441871f, 1.069980f, 1.407789f, 1.030749f, 1.625557f,
7.911370f, 10.179070f, 4.243343f, 9.542314f, 5.240112f, 8.183059f, 4.647485f, 5.408544f, 6.557124f, 9.522932f, 5.118020f, 8.273793f, 14.375030f, 19.941400f, 15.577760f, 15.122130f,
3.617284f, 4.660877f, 2.408210f, 4.567494f, 2.579008f, 4.033264f, 2.839132f, 2.786672f, 5.893344f, 8.571322f, 5.709601f, 7.784782f, 5.343556f, 7.423452f, 7.187564f, 5.884748f,
16.915090f, 18.743450f, 9.143352f, 18.327330f, 7.932559f, 10.668600f, 7.090315f, 7.354888f, 13.287920f, 16.620090f, 10.452510f, 15.061610f, 23.468550f, 28.038330f, 25.630500f, 22.177540f,
2.575157f, 3.246088f, 1.473719f, 3.642438f, 2.767341f, 4.233875f, 2.618753f, 3.349569f, 4.626373f, 6.582611f, 3.852865f, 6.845708f, 5.016147f, 6.817377f, 5.799903f, 6.188149f,
0.024318f, 0.030411f, 0.046673f, 0.158622f, 0.012389f, 0.018804f, 0.039317f, 0.069151f, 0.000446f, 0.000629f, 0.001245f, 0.003041f, 0.017377f, 0.023430f, 0.067383f, 0.098859f,
0.014773f, 0.018501f, 0.035194f, 0.100880f, 0.008101f, 0.012314f, 0.031913f, 0.047340f, 0.000532f, 0.000752f, 0.001845f, 0.003802f, 0.008583f, 0.011589f, 0.041309f, 0.051115f,
0.099639f, 0.107311f, 0.192725f, 0.583830f, 0.035940f, 0.046980f, 0.114950f, 0.180208f, 0.001731f, 0.002104f, 0.004871f, 0.010609f, 0.054367f, 0.063130f, 0.212462f, 0.277839f,
0.000748f, 0.000917f, 0.001532f, 0.005723f, 0.000618f, 0.000920f, 0.002094f, 0.004048f, 0.000030f, 0.000041f, 0.000089f, 0.000238f, 0.000573f, 0.000757f, 0.002371f, 0.003824f,
6.098357f, 8.233190f, 3.124713f, 9.154001f, 3.945464f, 6.465054f, 3.342846f, 5.067970f, 4.854111f, 7.397176f, 3.619422f, 7.622495f, 9.790056f, 14.250530f, 10.134960f, 12.816970f,
2.918692f, 3.946138f, 1.856269f, 4.586483f, 2.032613f, 3.335475f, 2.137610f, 2.733280f, 4.566702f, 6.969276f, 4.226565f, 7.507295f, 3.809353f, 5.552975f, 4.894896f, 5.220894f,
19.418780f, 22.578560f, 10.027530f, 26.184420f, 8.895234f, 12.553090f, 7.595397f, 10.263990f, 14.650080f, 19.227170f, 11.008910f, 20.665710f, 23.803950f, 29.841040f, 24.834810f, 27.994470f,
1.932682f, 2.556324f, 1.056604f, 3.402083f, 2.028690f, 3.256792f, 1.833954f, 3.055892f, 3.334514f, 4.978391f, 2.652873f, 6.140537f, 3.326151f, 4.743382f, 3.673952f, 5.106563f,
};

static const float acceptor_me2x3acc4[16384] = {
0.034748f, 0.053536f, 0.000903f, 0.143367f, 0.038723f, 0.115762f, 0.066831f, 0.172192f, 0.000570f, 0.001446f, 0.000683f, 0.004695f, 0.103045f, 0.319651f, 0.153655f, 0.431369f,
0.031342f, 0.057415f, 0.000667f, 0.141258f, 0.049473f, 0.175853f, 0.069935f, 0.240318f, 0.019452f, 0.058702f, 0.019117f, 0.175139f, 0.108159f, 0.398928f, 0.132097f, 0.494599f,
0.001270f, 0.002731f, 0.000050f, 0.006952f, 0.001982f, 0.008271f, 0.005189f, 0.011695f, 0.000587f, 0.002081f, 0.001069f, 0.006425f, 0.005728f, 0.024805f, 0.012958f, 0.031821f,
0.055800f, 0.093433f, 0.001475f, 0.254089f, 0.136888f, 0.444747f, 0.240457f, 0.671810f, 0.045152f, 0.124550f, 0.055143f, 0.410743f, 0.239982f, 0.809049f, 0.364211f, 1.108744f,
0.031725f, 0.047173f, 0.000821f, 0.104089f, 0.043776f, 0.126302f, 0.075239f, 0.154798f, 0.000747f, 0.001829f, 0.000892f, 0.004895f, 0.122122f, 0.365610f, 0.181345f, 0.406533f,
0.035930f, 0.063523f, 0.000761f, 0.128773f, 0.070226f, 0.240910f, 0.098859f, 0.271266f, 0.032022f, 0.093267f, 0.031341f, 0.229277f, 0.160948f, 0.572919f, 0.195754f, 0.585271f,
0.017237f, 0.035780f, 0.000676f, 0.075049f, 0.033314f, 0.134182f, 0.086870f, 0.156333f, 0.011451f, 0.039159f, 0.020760f, 0.099604f, 0.100942f, 0.421881f, 0.227413f, 0.445931f,
0.061330f, 0.099109f, 0.001615f, 0.222078f, 0.186295f, 0.584149f, 0.325885f, 0.727045f, 0.071266f, 0.189723f, 0.086673f, 0.515528f, 0.342379f, 1.113986f, 0.517458f, 1.257883f,
0.004423f, 0.007235f, 0.000101f, 0.018111f, 0.004154f, 0.013185f, 0.006277f, 0.018334f, 0.000114f, 0.000307f, 0.000120f, 0.000931f, 0.015410f, 0.050752f, 0.020118f, 0.064025f,
0.005178f, 0.010071f, 0.000096f, 0.023162f, 0.006889f, 0.025998f, 0.008526f, 0.033212f, 0.005044f, 0.016160f, 0.004340f, 0.045071f, 0.020994f, 0.082213f, 0.022449f, 0.095285f,
0.002654f, 0.006061f, 0.000092f, 0.014423f, 0.003492f, 0.015471f, 0.008005f, 0.020450f, 0.001927f, 0.007249f, 0.003071f, 0.020920f, 0.014068f, 0.064682f, 0.027865f, 0.077567f,
0.011676f, 0.020757f, 0.000270f, 0.052768f, 0.024141f, 0.083276f, 0.037128f, 0.117591f, 0.014828f, 0.043427f, 0.015855f, 0.133877f, 0.058997f, 0.211174f, 0.078393f, 0.270532f,
0.065421f, 0.088787f, 0.001523f, 0.230012f, 0.084845f, 0.223429f, 0.131239f, 0.321508f, 0.001515f, 0.003387f, 0.001629f, 0.010641f, 0.255104f, 0.697073f, 0.340922f, 0.910024f,
0.077558f, 0.125152f, 0.001479f, 0.297870f, 0.142476f, 0.446105f, 0.180505f, 0.589759f, 0.068001f, 0.180770f, 0.059896f, 0.521745f, 0.351936f, 1.143423f, 0.385224f, 1.371411f,
0.051527f, 0.097624f, 0.001820f, 0.240414f, 0.093602f, 0.344106f, 0.219662f, 0.470700f, 0.033676f, 0.105110f, 0.054945f, 0.313901f, 0.305678f, 1.166054f, 0.619776f, 1.447082f,
0.105237f, 0.155220f, 0.002494f, 0.408352f, 0.300451f, 0.859873f, 0.473005f, 1.256520f, 0.120302f, 0.292315f, 0.131674f, 0.932566f, 0.595132f, 1.767350f, 0.809483f, 2.343045f,
0.043054f, 0.125193f, 0.001437f, 0.200584f, 0.037671f, 0.212547f, 0.083547f, 0.189157f, 0.000584f, 0.002795f, 0.000900f, 0.005431f, 0.094915f, 0.555685f, 0.181868f, 0.448661f,
0.040118f, 0.138704f, 0.001097f, 0.204170f, 0.049721f, 0.333559f, 0.090318f, 0.272725f, 0.020586f, 0.117250f, 0.025998f, 0.209295f, 0.102920f, 0.716435f, 0.161523f, 0.531438f,
0.001965f, 0.007975f, 0.000099f, 0.012147f, 0.002408f, 0.018966f, 0.008102f, 0.016045f, 0.000751f, 0.005025f, 0.001758f, 0.009282f, 0.006589f, 0.053856f, 0.019156f, 0.041335f,
0.062594f, 0.197808f, 0.002127f, 0.321844f, 0.120565f, 0.739290f, 0.272143f, 0.668136f, 0.041876f, 0.218012f, 0.065718f, 0.430155f, 0.200121f, 1.273318f, 0.390276f, 1.044022f,
0.051858f, 0.145530f, 0.001724f, 0.192122f, 0.056183f, 0.305933f, 0.124084f, 0.224335f, 0.001009f, 0.004666f, 0.001550f, 0.007470f, 0.148396f, 0.838482f, 0.283164f, 0.557812f,
0.060673f, 0.202451f, 0.001652f, 0.245544f, 0.093110f, 0.602838f, 0.168431f, 0.406123f, 0.044708f, 0.245758f, 0.056227f, 0.361459f, 0.202043f, 1.357374f, 0.315771f, 0.829620f,
0.035189f, 0.137859f, 0.001775f, 0.173005f, 0.053399f, 0.405931f, 0.178929f, 0.282959f, 0.019328f, 0.124745f, 0.045027f, 0.189840f, 0.153194f, 1.208391f, 0.443497f, 0.764190f,
0.090760f, 0.276809f, 0.003071f, 0.371096f, 0.216460f, 1.280997f, 0.486572f, 0.953900f, 0.087195f, 0.438109f, 0.136270f, 0.712247f, 0.376656f, 2.312943f, 0.731505f, 1.562580f,
0.045130f, 0.139328f, 0.001319f, 0.208679f, 0.033281f, 0.199370f, 0.064624f, 0.165862f, 0.000960f, 0.004882f, 0.001296f, 0.008868f, 0.116891f, 0.726591f, 0.196100f, 0.548404f,
0.054583f, 0.200362f, 0.001307f, 0.275703f, 0.057016f, 0.406110f, 0.090679f, 0.310397f, 0.043957f, 0.265821f, 0.048604f, 0.443564f, 0.164518f, 1.215922f, 0.226060f, 0.843146f,
0.033823f, 0.145773f, 0.001500f, 0.207546f, 0.034937f, 0.292173f, 0.102923f, 0.231062f, 0.020304f, 0.144162f, 0.041586f, 0.248904f, 0.133278f, 1.156537f, 0.339224f, 0.829794f,
0.107861f, 0.361900f, 0.003208f, 0.550441f, 0.175103f, 1.139995f, 0.346055f, 0.963106f, 0.113253f, 0.626001f, 0.155610f, 1.154623f, 0.405160f, 2.737056f, 0.691798f, 2.097866f,
0.081419f, 0.208546f, 0.002436f, 0.323237f, 0.082907f, 0.412052f, 0.164791f, 0.354749f, 0.001559f, 0.006578f, 0.002154f, 0.012364f, 0.236017f, 1.217171f, 0.405308f, 0.950699f,
0.099715f, 0.303683f, 0.002443f, 0.432441f, 0.143826f, 0.849924f, 0.234148f, 0.672256f, 0.072285f, 0.362665f, 0.081815f, 0.626259f, 0.336371f, 2.062579f, 0.473123f, 1.480089f,
0.080091f, 0.286386f, 0.003635f, 0.421960f, 0.114234f, 0.792587f, 0.344482f, 0.648657f, 0.043278f, 0.254939f, 0.090735f, 0.455512f, 0.353209f, 2.542926f, 0.920252f, 1.888100f,
0.118573f, 0.330074f, 0.003610f, 0.519534f, 0.265796f, 1.435677f, 0.537707f, 1.255187f, 0.112069f, 0.513936f, 0.157622f, 0.980969f, 0.498480f, 2.793865f, 0.871260f, 2.216052f,
0.004387f, 0.011568f, 0.000139f, 0.027394f, 0.005143f, 0.026314f, 0.010857f, 0.034613f, 0.000060f, 0.000259f, 0.000087f, 0.000742f, 0.010342f, 0.054906f, 0.018863f, 0.065523f,
0.004439f, 0.013917f, 0.000116f, 0.030279f, 0.007371f, 0.044842f, 0.012745f, 0.054190f, 0.002280f, 0.011776f, 0.002741f, 0.031068f, 0.012177f, 0.076868f, 0.018191f, 0.084276f,
0.000190f, 0.000701f, 0.000009f, 0.001577f, 0.000313f, 0.002233f, 0.001001f, 0.002792f, 0.000073f, 0.000442f, 0.000162f, 0.001207f, 0.000683f, 0.005060f, 0.001889f, 0.005740f,
0.007728f, 0.022146f, 0.000250f, 0.053258f, 0.019943f, 0.110897f, 0.042851f, 0.148134f, 0.005175f, 0.024431f, 0.007731f, 0.071249f, 0.026419f, 0.152441f, 0.049045f, 0.184739f,
0.006234f, 0.015866f, 0.000197f, 0.030958f, 0.009050f, 0.044688f, 0.019026f, 0.048434f, 0.000121f, 0.000509f, 0.000178f, 0.001205f, 0.019077f, 0.097751f, 0.034651f, 0.096116f,
0.007921f, 0.023967f, 0.000205f, 0.042964f, 0.016286f, 0.095620f, 0.028043f, 0.095211f, 0.005842f, 0.029122f, 0.006994f, 0.063307f, 0.028204f, 0.171832f, 0.041960f, 0.155227f,
0.004023f, 0.014291f, 0.000193f, 0.026508f, 0.008179f, 0.056383f, 0.026087f, 0.058090f, 0.002212f, 0.012944f, 0.004904f, 0.029116f, 0.018727f, 0.133955f, 0.051606f, 0.125209f,
0.013220f, 0.036565f, 0.000426f, 0.072454f, 0.042246f, 0.226720f, 0.090395f, 0.249532f, 0.012713f, 0.057928f, 0.018913f, 0.139193f, 0.058669f, 0.326712f, 0.108461f, 0.326231f,
0.005292f, 0.014816f, 0.000147f, 0.032799f, 0.005229f, 0.028406f, 0.009665f, 0.034929f, 0.000113f, 0.000520f, 0.000145f, 0.001395f, 0.014657f, 0.082623f, 0.023407f, 0.092171f,
0.006950f, 0.023136f, 0.000158f, 0.047055f, 0.009727f, 0.062831f, 0.014726f, 0.070979f, 0.005603f, 0.030724f, 0.005897f, 0.075776f, 0.022401f, 0.150140f, 0.029300f, 0.153878f,
0.003771f, 0.014740f, 0.000159f, 0.031019f, 0.005219f, 0.039584f, 0.014637f, 0.046269f, 0.002266f, 0.014591f, 0.004418f, 0.037235f, 0.015891f, 0.125054f, 0.038502f, 0.132614f,
0.015325f, 0.046630f, 0.000434f, 0.104826f, 0.033334f, 0.196802f, 0.062709f, 0.245744f, 0.016106f, 0.080735f, 0.021066f, 0.220096f, 0.061557f, 0.377111f, 0.100051f, 0.427214f,
0.012751f, 0.029619f, 0.000363f, 0.067854f, 0.017397f, 0.078410f, 0.032916f, 0.099776f, 0.000244f, 0.000935f, 0.000321f, 0.002598f, 0.039526f, 0.184855f, 0.064613f, 0.213406f,
0.016958f, 0.046835f, 0.000396f, 0.098573f, 0.032772f, 0.175623f, 0.050786f, 0.205314f, 0.012305f, 0.055985f, 0.013257f, 0.142889f, 0.061170f, 0.340149f, 0.081901f, 0.360770f,
0.011927f, 0.038677f, 0.000515f, 0.084227f, 0.022793f, 0.143415f, 0.065429f, 0.173479f, 0.006451f, 0.034462f, 0.012875f, 0.091011f, 0.056247f, 0.367231f, 0.139499f, 0.403008f,
0.022501f, 0.056801f, 0.000652f, 0.132142f, 0.067578f, 0.331019f, 0.130136f, 0.427748f, 0.021287f, 0.088525f, 0.028499f, 0.249745f, 0.101150f, 0.514115f, 0.168290f, 0.602723f,
0.057900f, 0.090182f, 0.001353f, 0.218290f, 0.056994f, 0.172248f, 0.088483f, 0.231589f, 0.000790f, 0.002027f, 0.000853f, 0.005950f, 0.100644f, 0.315616f, 0.134995f, 0.384985f,
0.060025f, 0.111161f, 0.001149f, 0.247203f, 0.083693f, 0.300743f, 0.106422f, 0.371487f, 0.031006f, 0.094596f, 0.027411f, 0.255103f, 0.121416f, 0.452721f, 0.133389f, 0.507343f,
0.002512f, 0.005461f, 0.000089f, 0.012566f, 0.003463f, 0.014611f, 0.008157f, 0.018674f, 0.000967f, 0.003464f, 0.001584f, 0.009666f, 0.006642f, 0.029078f, 0.013516f, 0.033717f,
0.108103f, 0.182989f, 0.002571f, 0.449802f, 0.234251f, 0.769401f, 0.370141f, 1.050505f, 0.072806f, 0.203029f, 0.079982f, 0.605198f, 0.272512f, 0.928766f, 0.372027f, 1.150468f,
0.077081f, 0.115868f, 0.001794f, 0.231091f, 0.093950f, 0.274028f, 0.145250f, 0.303571f, 0.001510f, 0.003740f, 0.001623f, 0.009045f, 0.173918f, 0.526372f, 0.232311f, 0.529033f,
0.100336f, 0.179331f, 0.001912f, 0.328594f, 0.173225f, 0.600749f, 0.219354f, 0.611428f, 0.074429f, 0.219149f, 0.065526f, 0.486951f, 0.263446f, 0.948031f, 0.288223f, 0.875383f,
0.049720f, 0.104338f, 0.001755f, 0.197815f, 0.084883f, 0.345634f, 0.199103f, 0.363984f, 0.027493f, 0.095045f, 0.044834f, 0.218518f, 0.170671f, 0.721111f, 0.345874f, 0.688956f,
0.173247f, 0.283029f, 0.004103f, 0.573235f, 0.464844f, 1.473518f, 0.731453f, 1.657697f, 0.167557f, 0.450950f, 0.183307f, 1.107573f, 0.566900f, 1.864676f, 0.770705f, 1.903163f,
0.068183f, 0.112754f, 0.001395f, 0.255132f, 0.056568f, 0.181513f, 0.076891f, 0.228134f, 0.001460f, 0.003978f, 0.001380f, 0.010914f, 0.139246f, 0.463628f, 0.163527f, 0.528660f,
0.091748f, 0.180398f, 0.001537f, 0.375018f, 0.107819f, 0.411354f, 0.120036f, 0.474991f, 0.074381f, 0.240935f, 0.057573f, 0.607385f, 0.218042f, 0.863197f, 0.209729f, 0.904278f,
0.048575f, 0.112141f, 0.001508f, 0.241212f, 0.056449f, 0.252863f, 0.116410f, 0.302112f, 0.029355f, 0.111644f, 0.042088f, 0.291213f, 0.150923f, 0.701512f, 0.268902f, 0.760399f,
0.209275f, 0.376114f, 0.004358f, 0.864246f, 0.382213f, 1.332879f, 0.528768f, 1.701208f, 0.221207f, 0.654941f, 0.212763f, 1.825000f, 0.619824f, 2.242863f, 0.740851f, 2.597122f,
0.119703f, 0.164232f, 0.002507f, 0.384569f, 0.137129f, 0.365062f, 0.190801f, 0.474822f, 0.002307f, 0.005215f, 0.002232f, 0.014809f, 0.273597f, 0.755783f, 0.328900f, 0.891834f,
0.163105f, 0.266074f, 0.002798f, 0.572406f, 0.264666f, 0.837758f, 0.301621f, 1.001079f, 0.119027f, 0.319878f, 0.094307f, 0.834502f, 0.433822f, 1.424887f, 0.427146f, 1.544732f,
0.111933f, 0.214390f, 0.003556f, 0.477221f, 0.179609f, 0.667509f, 0.379148f, 0.825317f, 0.060889f, 0.192126f, 0.089363f, 0.518614f, 0.389221f, 1.500981f, 0.709873f, 1.683689f,
0.223875f, 0.333816f, 0.004772f, 0.793791f, 0.564579f, 1.633467f, 0.799524f, 2.157533f, 0.213010f, 0.523242f, 0.209722f, 1.508841f, 0.742089f, 2.227872f, 0.907956f, 2.669687f,
0.048066f, 0.074055f, 0.001249f, 0.198315f, 0.060726f, 0.181539f, 0.104806f, 0.270035f, 0.000979f, 0.002484f, 0.001174f, 0.008067f, 0.165131f, 0.512242f, 0.246232f, 0.691271f,
0.040667f, 0.074498f, 0.000865f, 0.183287f, 0.072776f, 0.258684f, 0.102876f, 0.353513f, 0.031350f, 0.094608f, 0.030810f, 0.282267f, 0.162583f, 0.599661f, 0.198566f, 0.743472f,
0.001383f, 0.002974f, 0.000054f, 0.007570f, 0.002447f, 0.010211f, 0.006406f, 0.014438f, 0.000794f, 0.002815f, 0.001446f, 0.008690f, 0.007226f, 0.031293f, 0.016348f, 0.040144f,
0.067005f, 0.112194f, 0.001771f, 0.305108f, 0.186351f, 0.605451f, 0.327344f, 0.914561f, 0.067345f, 0.185766f, 0.082245f, 0.612624f, 0.333840f, 1.125471f, 0.506655f, 1.542378f,
0.054657f, 0.081271f, 0.001414f, 0.179326f, 0.085502f, 0.246690f, 0.146955f, 0.302347f, 0.001598f, 0.003915f, 0.001910f, 0.010475f, 0.243740f, 0.729712f, 0.361941f, 0.811388f,
0.058065f, 0.102657f, 0.001230f, 0.208103f, 0.128662f, 0.441375f, 0.181121f, 0.496990f, 0.064278f, 0.187213f, 0.062910f, 0.460225f, 0.301323f, 1.072603f, 0.366484f, 1.095726f,
0.023378f, 0.048527f, 0.000917f, 0.101787f, 0.051224f, 0.206322f, 0.133573f, 0.240380f, 0.019291f, 0.065969f, 0.034973f, 0.167798f, 0.158605f, 0.662877f, 0.357321f, 0.700664f,
0.091723f, 0.148223f, 0.002415f, 0.332128f, 0.315864f, 0.990429f, 0.552541f, 1.232711f, 0.132385f, 0.352435f, 0.161005f, 0.957658f, 0.593199f, 1.930070f, 0.896537f, 2.179383f,
0.006819f, 0.011155f, 0.000155f, 0.027924f, 0.007261f, 0.023047f, 0.010972f, 0.032047f, 0.000218f, 0.000587f, 0.000229f, 0.001783f, 0.027524f, 0.090652f, 0.035934f, 0.114359f,
0.007489f, 0.014565f, 0.000139f, 0.033498f, 0.011295f, 0.042626f, 0.013979f, 0.054455f, 0.009060f, 0.029030f, 0.007796f, 0.080965f, 0.035175f, 0.137744f, 0.037613f, 0.159644f,
0.003221f, 0.007356f, 0.000111f, 0.017506f, 0.004805f, 0.021289f, 0.011015f, 0.028141f, 0.002905f, 0.010929f, 0.004630f, 0.031540f, 0.019781f, 0.090952f, 0.039182f, 0.109070f,
0.015627f, 0.027781f, 0.000362f, 0.070625f, 0.036631f, 0.126359f, 0.056337f, 0.178427f, 0.024650f, 0.072194f, 0.026357f, 0.222561f, 0.091477f, 0.327431f, 0.121551f, 0.419466f,
0.095542f, 0.129665f, 0.002224f, 0.335913f, 0.140476f, 0.369926f, 0.217289f, 0.532313f, 0.002748f, 0.006144f, 0.002955f, 0.019303f, 0.431605f, 1.179362f, 0.576798f, 1.539650f,
0.106246f, 0.171445f, 0.002026f, 0.408052f, 0.221274f, 0.692827f, 0.280335f, 0.915931f, 0.115707f, 0.307590f, 0.101916f, 0.887778f, 0.558527f, 1.814631f, 0.611356f, 2.176452f,
0.059241f, 0.112239f, 0.002092f, 0.276405f, 0.122004f, 0.448516f, 0.286312f, 0.613521f, 0.048091f, 0.150103f, 0.078464f, 0.448266f, 0.407140f, 1.553093f, 0.825493f, 1.927401f,
0.133416f, 0.196781f, 0.003161f, 0.517691f, 0.431827f, 1.235862f, 0.679832f, 1.805948f, 0.189438f, 0.460304f, 0.207346f, 1.468499f, 0.874062f, 2.595684f, 1.188877f, 3.441199f,
0.098037f, 0.285071f, 0.003272f, 0.456743f, 0.097248f, 0.548692f, 0.215676f, 0.488310f, 0.001650f, 0.007906f, 0.002545f, 0.015361f, 0.250380f, 1.465869f, 0.479758f, 1.183545f,
0.085690f, 0.296261f, 0.002343f, 0.436093f, 0.120401f, 0.807715f, 0.218706f, 0.660406f, 0.054615f, 0.311068f, 0.068973f, 0.555267f, 0.254670f, 1.772783f, 0.399680f, 1.315017f,
0.003522f, 0.014297f, 0.000178f, 0.021775f, 0.004893f, 0.038544f, 0.016465f, 0.032608f, 0.001673f, 0.011190f, 0.003914f, 0.020667f, 0.013684f, 0.111843f, 0.039781f, 0.085842f,
0.123728f, 0.391001f, 0.004203f, 0.636179f, 0.270180f, 1.656716f, 0.609860f, 1.497263f, 0.102816f, 0.535269f, 0.161352f, 1.056127f, 0.458268f, 2.915840f, 0.893715f, 2.390764f,
0.147069f, 0.412726f, 0.004889f, 0.544859f, 0.180639f, 0.983634f, 0.398955f, 0.721281f, 0.003555f, 0.016437f, 0.005459f, 0.026314f, 0.487554f, 2.754826f, 0.930332f, 1.832686f,
0.161406f, 0.538568f, 0.004394f, 0.653204f, 0.280811f, 1.818109f, 0.507972f, 1.224834f, 0.147728f, 0.812054f, 0.185791f, 1.194362f, 0.622670f, 4.183233f, 0.973163f, 2.556772f,
0.078563f, 0.307789f, 0.003962f, 0.386256f, 0.135162f, 1.027470f, 0.452896f, 0.716210f, 0.053600f, 0.345938f, 0.124867f, 0.526458f, 0.396235f, 3.125486f, 1.147098f, 1.976566f,
0.223440f, 0.681473f, 0.007559f, 0.913597f, 0.604149f, 3.575324f, 1.358045f, 2.662378f, 0.266636f, 1.339699f, 0.416702f, 2.177989f, 1.074250f, 6.596684f, 2.086306f, 4.456592f,
0.114540f, 0.353616f, 0.003347f, 0.529629f, 0.095762f, 0.573656f, 0.185945f, 0.477243f, 0.003026f, 0.015391f, 0.004085f, 0.027955f, 0.343690f, 2.136368f, 0.576585f, 1.612452f,
0.129946f, 0.477003f, 0.003110f, 0.656367f, 0.153888f, 1.096095f, 0.244744f, 0.837765f, 0.129985f, 0.786052f, 0.143726f, 1.311654f, 0.453745f, 3.353545f, 0.623478f, 2.325417f,
0.067579f, 0.291259f, 0.002996f, 0.414685f, 0.079139f, 0.661825f, 0.233140f, 0.523396f, 0.050390f, 0.357776f, 0.103206f, 0.617721f, 0.308499f, 2.677043f, 0.785203f, 1.920729f,
0.237639f, 0.797337f, 0.007069f, 1.212732f, 0.437368f, 2.847447f, 0.864367f, 2.405620f, 0.309928f, 1.713113f, 0.425841f, 3.159738f, 1.034123f, 6.986022f, 1.765736f, 5.354563f,
0.195735f, 0.501354f, 0.005856f, 0.777079f, 0.225962f, 1.123040f, 0.449134f, 0.966860f, 0.004655f, 0.019643f, 0.006433f, 0.036920f, 0.657324f, 3.389908f, 1.128812f, 2.647764f,
0.224863f, 0.684821f, 0.005510f, 0.975177f, 0.367699f, 2.172877f, 0.598612f, 1.718659f, 0.202470f, 1.015826f, 0.229165f, 1.754154f, 0.878755f, 5.388393f, 1.236012f, 3.866665f,
0.151578f, 0.542007f, 0.006880f, 0.798592f, 0.245102f, 1.700590f, 0.739127f, 1.391771f, 0.101737f, 0.599305f, 0.213298f, 1.070805f, 0.774423f, 5.575450f, 2.017683f, 4.139721f,
0.247451f, 0.688834f, 0.007534f, 1.084222f, 0.628856f, 3.396720f, 1.272180f, 2.969694f, 0.290500f, 1.332204f, 0.408582f, 2.542825f, 1.205160f, 6.754638f, 2.106417f, 5.357679f,
0.036548f, 0.096374f, 0.001161f, 0.228224f, 0.048574f, 0.248534f, 0.102545f, 0.326916f, 0.000616f, 0.002675f, 0.000904f, 0.007683f, 0.099811f, 0.529920f, 0.182052f, 0.632388f,
0.034688f, 0.108758f, 0.000903f, 0.236618f, 0.065302f, 0.397278f, 0.112916f, 0.480098f, 0.022129f, 0.114302f, 0.026603f, 0.301566f, 0.110239f, 0.695906f, 0.164689f, 0.762973f,
0.001248f, 0.004596f, 0.000060f, 0.010346f, 0.002324f, 0.016601f, 0.007444f, 0.020758f, 0.000594f, 0.003600f, 0.001322f, 0.009829f, 0.005187f, 0.038446f, 0.014354f, 0.043614f,
0.055887f, 0.160162f, 0.001807f, 0.385161f, 0.163511f, 0.909242f, 0.351333f, 1.214542f, 0.046485f, 0.219465f, 0.069442f, 0.640018f, 0.221347f, 1.277185f, 0.410910f, 1.547782f,
0.064688f, 0.164627f, 0.002047f, 0.321223f, 0.106455f, 0.525684f, 0.223806f, 0.569742f, 0.001565f, 0.006563f, 0.002288f, 0.015528f, 0.229317f, 1.175016f, 0.416529f, 1.155369f,
0.077091f, 0.233270f, 0.001998f, 0.418168f, 0.179700f, 1.055092f, 0.309434f, 1.050583f, 0.070625f, 0.352060f, 0.084550f, 0.765334f, 0.318017f, 1.937496f, 0.473120f, 1.750265f,
0.032859f, 0.116740f, 0.001577f, 0.216533f, 0.075741f, 0.522139f, 0.241587f, 0.537948f, 0.022439f, 0.131334f, 0.049760f, 0.295410f, 0.177211f, 1.267632f, 0.488353f, 1.184868f,
0.119080f, 0.329354f, 0.003835f, 0.652608f, 0.431393f, 2.315159f, 0.923075f, 2.548111f, 0.142236f, 0.648089f, 0.211597f, 1.557277f, 0.612200f, 3.409179f, 1.131773f, 3.404161f,
0.049141f, 0.137581f, 0.001367f, 0.304565f, 0.055047f, 0.299039f, 0.101746f, 0.367704f, 0.001300f, 0.005994f, 0.001670f, 0.016091f, 0.157676f, 0.888814f, 0.251800f, 0.991527f,
0.060538f, 0.201523f, 0.001379f, 0.409859f, 0.096056f, 0.620445f, 0.145420f, 0.700907f, 0.060614f, 0.332406f, 0.063798f, 0.819822f, 0.226042f, 1.515019f, 0.295660f, 1.552737f,
0.027569f, 0.107753f, 0.001164f, 0.226753f, 0.043257f, 0.328054f, 0.121304f, 0.383456f, 0.020576f, 0.132488f, 0.040117f, 0.338096f, 0.134579f, 1.059049f, 0.326062f, 1.123078f,
0.123532f, 0.375874f, 0.003498f, 0.844982f, 0.304622f, 1.798483f, 0.573068f, 2.245746f, 0.161264f, 0.808348f, 0.210920f, 2.203670f, 0.574838f, 3.521594f, 0.934313f, 3.989481f,
0.112157f, 0.260519f, 0.003194f, 0.596819f, 0.173478f, 0.781881f, 0.328230f, 0.994930f, 0.002670f, 0.010217f, 0.003512f, 0.028383f, 0.402761f, 1.883615f, 0.658390f, 2.174535f,
0.139912f, 0.386412f, 0.003263f, 0.813280f, 0.306536f, 1.642707f, 0.475037f, 1.920426f, 0.126099f, 0.573728f, 0.135860f, 1.464324f, 0.584675f, 3.251192f, 0.782823f, 3.448284f,
0.082588f, 0.267809f, 0.003568f, 0.583215f, 0.178929f, 1.125826f, 0.513627f, 1.361829f, 0.055485f, 0.296402f, 0.110733f, 0.782757f, 0.451203f, 2.945847f, 1.119027f, 3.232841f,
0.171800f, 0.433695f, 0.004979f, 1.008952f, 0.584972f, 2.865365f, 1.126486f, 3.702668f, 0.201879f, 0.839562f, 0.270283f, 2.368544f, 0.894720f, 4.547585f, 1.488608f, 5.331366f,
0.112315f, 0.174936f, 0.002624f, 0.423442f, 0.125340f, 0.378802f, 0.194589f, 0.509301f, 0.001903f, 0.004884f, 0.002054f, 0.014336f, 0.226171f, 0.709267f, 0.303368f, 0.865157f,
0.109220f, 0.202267f, 0.002090f, 0.449806f, 0.172647f, 0.620391f, 0.219534f, 0.766327f, 0.070078f, 0.213797f, 0.061952f, 0.576560f, 0.255941f, 0.954321f, 0.281180f, 1.069463f,
0.003836f, 0.008340f, 0.000136f, 0.019190f, 0.005995f, 0.025295f, 0.014122f, 0.032329f, 0.001834f, 0.006571f, 0.003004f, 0.018335f, 0.011750f, 0.051442f, 0.023912f, 0.059649f,
0.182035f, 0.308137f, 0.004329f, 0.757427f, 0.447197f, 1.468827f, 0.706619f, 2.005471f, 0.152281f, 0.424653f, 0.167289f, 1.265825f, 0.531614f, 1.811832f, 0.725748f, 2.244328f,
0.186226f, 0.279935f, 0.004333f, 0.558310f, 0.257328f, 0.750561f, 0.397840f, 0.831481f, 0.004532f, 0.011223f, 0.004871f, 0.027144f, 0.486776f, 1.473256f, 0.650211f, 1.480701f,
0.227385f, 0.406406f, 0.004334f, 0.744671f, 0.445055f, 1.543465f, 0.563572f, 1.570903f, 0.209509f, 0.616881f, 0.184448f, 1.370716f, 0.691654f, 2.488973f, 0.756704f, 2.298240f,
0.094566f, 0.198447f, 0.003338f, 0.376238f, 0.183031f, 0.745277f, 0.429318f, 0.784845f, 0.064950f, 0.224536f, 0.105918f, 0.516234f, 0.376059f, 1.588903f, 0.762101f, 1.518051f,
0.363345f, 0.593586f, 0.008605f, 1.202224f, 1.105246f, 3.503541f, 1.739155f, 3.941460f, 0.436489f, 1.174731f, 0.477517f, 2.885242f, 1.377373f, 4.530528f, 1.872550f, 4.624039f,
0.147420f, 0.243786f, 0.003016f, 0.551624f, 0.138659f, 0.444923f, 0.188474f, 0.559201f, 0.003921f, 0.010682f, 0.003705f, 0.029311f, 0.348782f, 1.161290f, 0.409601f, 1.324180f,
0.186074f, 0.365866f, 0.003118f, 0.760576f, 0.247905f, 0.945813f, 0.275995f, 1.092131f, 0.187375f, 0.606943f, 0.145032f, 1.530071f, 0.512300f, 2.028117f, 0.492768f, 2.124639f,
0.082681f, 0.190876f, 0.002566f, 0.410569f, 0.108928f, 0.487946f, 0.224635f, 0.582982f, 0.062063f, 0.236037f, 0.088982f, 0.615682f, 0.297602f, 1.383298f, 0.530243f, 1.499415f,
0.392785f, 0.705923f, 0.008179f, 1.622093f, 0.813284f, 2.836143f, 1.125131f, 3.619886f, 0.515698f, 1.526855f, 0.496012f, 4.254597f, 1.347718f, 4.876787f, 1.610876f, 5.647072f,
0.245151f, 0.336346f, 0.005134f, 0.787594f, 0.318389f, 0.847607f, 0.443003f, 1.102448f, 0.005869f, 0.013266f, 0.005678f, 0.037670f, 0.649131f, 1.793157f, 0.780341f, 2.115949f,
0.313334f, 0.511144f, 0.005374f, 1.099626f, 0.576420f, 1.824561f, 0.656902f, 2.180261f, 0.284018f, 0.763276f, 0.225032f, 1.991249f, 0.965484f, 3.171128f, 0.950626f, 3.437847f,
0.180466f, 0.345655f, 0.005734f, 0.769410f, 0.328295f, 1.220097f, 0.693021f, 1.508545f, 0.121937f, 0.384753f, 0.178959f, 1.038580f, 0.726988f, 2.803536f, 1.325903f, 3.144798f,
0.398010f, 0.593467f, 0.008483f, 1.411221f, 1.137922f, 3.292290f, 1.611459f, 4.348559f, 0.470377f, 1.155443f, 0.463115f, 3.331882f, 1.528401f, 4.588510f, 1.870020f, 5.498469f,
0.005820f, 0.008967f, 0.000151f, 0.024014f, 0.009671f, 0.028912f, 0.016691f, 0.043006f, 0.000129f, 0.000328f, 0.000155f, 0.001065f, 0.022861f, 0.070915f, 0.034089f, 0.095700f,
0.008098f, 0.014834f, 0.000172f, 0.036497f, 0.019059f, 0.067747f, 0.026942f, 0.092582f, 0.006804f, 0.020533f, 0.006687f, 0.061262f, 0.037013f, 0.136516f, 0.045205f, 0.169255f,
0.000211f, 0.000453f, 0.000008f, 0.001153f, 0.000490f, 0.002045f, 0.001283f, 0.002891f, 0.000132f, 0.000467f, 0.000240f, 0.001442f, 0.001258f, 0.005447f, 0.002846f, 0.006988f,
0.010701f, 0.017918f, 0.000283f, 0.048728f, 0.039143f, 0.127175f, 0.068759f, 0.192104f, 0.011723f, 0.032337f, 0.014317f, 0.106641f, 0.060956f, 0.205501f, 0.092511f, 0.281625f,
0.007071f, 0.010513f, 0.000183f, 0.023198f, 0.014547f, 0.041972f, 0.025003f, 0.051441f, 0.000225f, 0.000552f, 0.000269f, 0.001477f, 0.036049f, 0.107923f, 0.053530f, 0.120002f,
0.012352f, 0.021838f, 0.000262f, 0.044269f, 0.035997f, 0.123488f, 0.050674f, 0.139048f, 0.014903f, 0.043407f, 0.014586f, 0.106708f, 0.073284f, 0.260864f, 0.089131f, 0.266487f,
0.003803f, 0.007894f, 0.000149f, 0.016557f, 0.010959f, 0.044140f, 0.028576f, 0.051426f, 0.003420f, 0.011696f, 0.006200f, 0.029750f, 0.029496f, 0.123276f, 0.066451f, 0.130303f,
0.015649f, 0.025289f, 0.000412f, 0.056666f, 0.070879f, 0.222251f, 0.123989f, 0.276618f, 0.024619f, 0.065540f, 0.029941f, 0.178090f, 0.115712f, 0.376487f, 0.174882f, 0.425119f,
0.000850f, 0.001390f, 0.000019f, 0.003481f, 0.001190f, 0.003779f, 0.001799f, 0.005254f, 0.000030f, 0.000080f, 0.000031f, 0.000242f, 0.003923f, 0.012919f, 0.005121f, 0.016298f,
0.001535f, 0.002986f, 0.000029f, 0.006867f, 0.003045f, 0.011492f, 0.003769f, 0.014681f, 0.002024f, 0.006486f, 0.001742f, 0.018089f, 0.008243f, 0.032281f, 0.008815f, 0.037414f,
0.000505f, 0.001153f, 0.000017f, 0.002744f, 0.000990f, 0.004389f, 0.002271f, 0.005801f, 0.000496f, 0.001867f, 0.000791f, 0.005388f, 0.003545f, 0.016299f, 0.007022f, 0.019546f,
0.002569f, 0.004567f, 0.000059f, 0.011611f, 0.007921f, 0.027323f, 0.012182f, 0.038582f, 0.004417f, 0.012937f, 0.004723f, 0.039882f, 0.017195f, 0.061546f, 0.022848f, 0.078846f,
0.012238f, 0.016609f, 0.000285f, 0.043028f, 0.023666f, 0.062322f, 0.036607f, 0.089680f, 0.000384f, 0.000858f, 0.000413f, 0.002695f, 0.063208f, 0.172716f, 0.084471f, 0.225479f,
0.022380f, 0.036113f, 0.000427f, 0.085952f, 0.061301f, 0.191940f, 0.077664f, 0.253748f, 0.026565f, 0.070619f, 0.023399f, 0.203823f, 0.134506f, 0.437005f, 0.147229f, 0.524139f,
0.009542f, 0.018078f, 0.000337f, 0.044520f, 0.025845f, 0.095014f, 0.060653f, 0.129969f, 0.008443f, 0.026352f, 0.013775f, 0.078696f, 0.074974f, 0.285999f, 0.152013f, 0.354927f,
0.022540f, 0.033245f, 0.000534f, 0.087461f, 0.095952f, 0.274608f, 0.151058f, 0.401281f, 0.034883f, 0.084761f, 0.038181f, 0.270412f, 0.168827f, 0.501363f, 0.229635f, 0.664677f,
0.009921f, 0.028847f, 0.000331f, 0.046219f, 0.012943f, 0.073027f, 0.028705f, 0.064990f, 0.000182f, 0.000872f, 0.000281f, 0.001694f, 0.028967f, 0.169592f, 0.055505f, 0.136929f,
0.014259f, 0.049299f, 0.000390f, 0.072568f, 0.026351f, 0.176776f, 0.047866f, 0.144536f, 0.009906f, 0.056420f, 0.012510f, 0.100711f, 0.048451f, 0.337271f, 0.076039f, 0.250181f,
0.000448f, 0.001819f, 0.000023f, 0.002771f, 0.000819f, 0.006450f, 0.002756f, 0.005457f, 0.000232f, 0.001552f, 0.000543f, 0.002866f, 0.001991f, 0.016271f, 0.005787f, 0.012488f,
0.016513f, 0.052185f, 0.000561f, 0.084908f, 0.047427f, 0.290815f, 0.107053f, 0.262825f, 0.014957f, 0.077866f, 0.023472f, 0.153636f, 0.069927f, 0.444928f, 0.136372f, 0.364807f,
0.015899f, 0.044618f, 0.000529f, 0.058903f, 0.025684f, 0.139857f, 0.056725f, 0.102554f, 0.000419f, 0.001937f, 0.000643f, 0.003101f, 0.060260f, 0.340488f, 0.114986f, 0.226514f,
0.028693f, 0.095742f, 0.000781f, 0.116121f, 0.065656f, 0.425092f, 0.118769f, 0.286378f, 0.028624f, 0.157346f, 0.035999f, 0.231424f, 0.126555f, 0.850222f, 0.197791f, 0.519652f,
0.010680f, 0.041839f, 0.000539f, 0.052506f, 0.024165f, 0.183697f, 0.080971f, 0.128048f, 0.007942f, 0.051255f, 0.018501f, 0.078002f, 0.061580f, 0.485744f, 0.178275f, 0.307186f,
0.031859f, 0.097166f, 0.001078f, 0.130263f, 0.113295f, 0.670473f, 0.254671f, 0.499270f, 0.041437f, 0.208200f, 0.064759f, 0.338478f, 0.175117f, 1.075348f, 0.340096f, 0.726484f,
0.011932f, 0.036837f, 0.000349f, 0.055173f, 0.013120f, 0.078597f, 0.025477f, 0.065387f, 0.000344f, 0.001748f, 0.000464f, 0.003174f, 0.040934f, 0.254442f, 0.068671f, 0.192043f,
0.022260f, 0.081713f, 0.000533f, 0.112438f, 0.034672f, 0.246954f, 0.055142f, 0.188751f, 0.024270f, 0.146767f, 0.026836f, 0.244904f, 0.088866f, 0.656795f, 0.122109f, 0.455435f,
0.008852f, 0.038152f, 0.000392f, 0.054320f, 0.013634f, 0.114020f, 0.040166f, 0.090171f, 0.007194f, 0.051081f, 0.014735f, 0.088194f, 0.046201f, 0.400914f, 0.117592f, 0.287648f,
0.032650f, 0.109550f, 0.000971f, 0.166623f, 0.079035f, 0.514549f, 0.156196f, 0.434708f, 0.046413f, 0.256546f, 0.063772f, 0.473184f, 0.162443f, 1.097383f, 0.277367f, 0.841109f,
0.020953f, 0.053668f, 0.000627f, 0.083184f, 0.031813f, 0.158113f, 0.063234f, 0.136125f, 0.000543f, 0.002292f, 0.000751f, 0.004308f, 0.080447f, 0.414876f, 0.138150f, 0.324048f,
0.039583f, 0.120549f, 0.000970f, 0.171660f, 0.085129f, 0.503062f, 0.138590f, 0.397902f, 0.038847f, 0.194901f, 0.043969f, 0.336560f, 0.176852f, 1.084433f, 0.248752f, 0.778180f,
0.020403f, 0.072956f, 0.000926f, 0.107493f, 0.043391f, 0.301062f, 0.130850f, 0.246390f, 0.014926f, 0.087925f, 0.031293f, 0.157100f, 0.119177f, 0.858012f, 0.310503f, 0.637066f,
0.034936f, 0.097253f, 0.001064f, 0.153076f, 0.116772f, 0.630737f, 0.236231f, 0.551443f, 0.044704f, 0.205007f, 0.062875f, 0.391304f, 0.194532f, 1.090306f, 0.340009f, 0.864815f,
0.002725f, 0.007186f, 0.000087f, 0.017018f, 0.004764f, 0.024374f, 0.010057f, 0.032061f, 0.000050f, 0.000217f, 0.000073f, 0.000624f, 0.008509f, 0.045177f, 0.015520f, 0.053912f,
0.004253f, 0.013336f, 0.000111f, 0.029014f, 0.010531f, 0.064070f, 0.018210f, 0.077427f, 0.002958f, 0.015276f, 0.003556f, 0.040304f, 0.015454f, 0.097559f, 0.023088f, 0.106961f,
0.000117f, 0.000431f, 0.000006f, 0.000970f, 0.000287f, 0.002047f, 0.000918f, 0.002560f, 0.000061f, 0.000368f, 0.000135f, 0.001004f, 0.000556f, 0.004121f, 0.001539f, 0.004675f,
0.005496f, 0.015751f, 0.000178f, 0.037880f, 0.021150f, 0.117609f, 0.045445f, 0.157100f, 0.004983f, 0.023525f, 0.007444f, 0.068606f, 0.024888f, 0.143606f, 0.046203f, 0.174032f,
0.005153f, 0.013114f, 0.000163f, 0.025589f, 0.011153f, 0.055077f, 0.023449f, 0.059693f, 0.000136f, 0.000570f, 0.000199f, 0.001348f, 0.020885f, 0.107015f, 0.037936f, 0.105226f,
0.010099f, 0.030557f, 0.000262f, 0.054778f, 0.030960f, 0.181781f, 0.053312f, 0.181004f, 0.010084f, 0.050267f, 0.012072f, 0.109274f, 0.047628f, 0.290172f, 0.070858f, 0.262131f,
0.003291f, 0.011694f, 0.000158f, 0.021690f, 0.009978f, 0.068788f, 0.031827f, 0.070871f, 0.002450f, 0.014339f, 0.005433f, 0.032252f, 0.020294f, 0.145170f, 0.055927f, 0.135692f,
0.012511f, 0.034604f, 0.000403f, 0.068567f, 0.059612f, 0.319920f, 0.127555f, 0.352110f, 0.016288f, 0.074217f, 0.024231f, 0.178334f, 0.073538f, 0.409513f, 0.135949f, 0.408910f,
0.003772f, 0.010561f, 0.000105f, 0.023379f, 0.005558f, 0.030191f, 0.010272f, 0.037123f, 0.000109f, 0.000502f, 0.000140f, 0.001346f, 0.013838f, 0.078004f, 0.022098f, 0.087018f,
0.007642f, 0.025438f, 0.000174f, 0.051736f, 0.015947f, 0.103007f, 0.024143f, 0.116365f, 0.008340f, 0.045734f, 0.008778f, 0.112795f, 0.032622f, 0.218644f, 0.042669f, 0.224087f,
0.002661f, 0.010401f, 0.000112f, 0.021887f, 0.005491f, 0.041646f, 0.015400f, 0.048680f, 0.002165f, 0.013938f, 0.004221f, 0.035570f, 0.014851f, 0.116871f, 0.035982f, 0.123937f,
0.012507f, 0.038055f, 0.000354f, 0.085549f, 0.040563f, 0.239481f, 0.076308f, 0.299038f, 0.017795f, 0.089201f, 0.023275f, 0.243176f, 0.066538f, 0.407626f, 0.108147f, 0.461784f,
0.008847f, 0.020550f, 0.000252f, 0.047077f, 0.017997f, 0.081116f, 0.034052f, 0.103219f, 0.000230f, 0.000878f, 0.000302f, 0.002440f, 0.036322f, 0.169870f, 0.059376f, 0.196106f,
0.018148f, 0.050122f, 0.000423f, 0.105492f, 0.052295f, 0.280247f, 0.081042f, 0.327626f, 0.017828f, 0.081114f, 0.019208f, 0.207027f, 0.086707f, 0.482148f, 0.116092f, 0.511377f,
0.008192f, 0.026563f, 0.000354f, 0.057847f, 0.023342f, 0.146866f, 0.067004f, 0.177653f, 0.005998f, 0.032044f, 0.011971f, 0.084622f, 0.051166f, 0.334055f, 0.126896f, 0.366600f,
0.017873f, 0.045120f, 0.000518f, 0.104967f, 0.080042f, 0.392070f, 0.154138f, 0.506638f, 0.022892f, 0.095202f, 0.030649f, 0.268580f, 0.106421f, 0.540906f, 0.177060f, 0.634131f,
0.013235f, 0.020614f, 0.000309f, 0.049898f, 0.019426f, 0.058708f, 0.030158f, 0.078934f, 0.000244f, 0.000627f, 0.000264f, 0.001841f, 0.030471f, 0.095555f, 0.040871f, 0.116557f,
0.021164f, 0.039195f, 0.000405f, 0.087162f, 0.044001f, 0.158112f, 0.055950f, 0.195305f, 0.014801f, 0.045156f, 0.013085f, 0.121774f, 0.056702f, 0.211423f, 0.062293f, 0.236932f,
0.000568f, 0.001236f, 0.000020f, 0.002843f, 0.001168f, 0.004930f, 0.002752f, 0.006300f, 0.000296f, 0.001061f, 0.000485f, 0.002961f, 0.001991f, 0.008715f, 0.004051f, 0.010105f,
0.028292f, 0.047890f, 0.000673f, 0.117718f, 0.091412f, 0.300244f, 0.144440f, 0.409939f, 0.025796f, 0.071936f, 0.028339f, 0.214430f, 0.094462f, 0.321943f, 0.128958f, 0.398793f,
0.023444f, 0.035240f, 0.000546f, 0.070285f, 0.042606f, 0.124271f, 0.065871f, 0.137669f, 0.000622f, 0.001540f, 0.000668f, 0.003724f, 0.070060f, 0.212041f, 0.093583f, 0.213113f,
0.047072f, 0.084131f, 0.000897f, 0.154157f, 0.121175f, 0.420237f, 0.153443f, 0.427708f, 0.047272f, 0.139190f, 0.041618f, 0.309281f, 0.163698f, 0.589081f, 0.179094f, 0.543940f,
0.014969f, 0.031413f, 0.000528f, 0.059557f, 0.038106f, 0.155162f, 0.089381f, 0.163400f, 0.011206f, 0.038740f, 0.018274f, 0.089068f, 0.068058f, 0.287556f, 0.137923f, 0.274733f,
0.060328f, 0.098556f, 0.001429f, 0.199612f, 0.241357f, 0.765081f, 0.379786f, 0.860711f, 0.078992f, 0.212592f, 0.086417f, 0.522145f, 0.261463f, 0.860017f, 0.355461f, 0.877767f,
0.017883f, 0.029573f, 0.000366f, 0.066917f, 0.022123f, 0.070986f, 0.030070f, 0.089219f, 0.000518f, 0.001412f, 0.000490f, 0.003875f, 0.048373f, 0.161060f, 0.056808f, 0.183651f,
0.037118f, 0.072984f, 0.000622f, 0.151721f, 0.065041f, 0.248146f, 0.072411f, 0.286535f, 0.040740f, 0.131965f, 0.031534f, 0.332677f, 0.116838f, 0.462544f, 0.112383f, 0.484557f,
0.012612f, 0.029116f, 0.000391f, 0.062627f, 0.021853f, 0.097891f, 0.045066f, 0.116957f, 0.010318f, 0.039243f, 0.014794f, 0.102362f, 0.051900f, 0.241238f, 0.092471f, 0.261488f,
0.062844f, 0.112944f, 0.001309f, 0.259526f, 0.171139f, 0.596807f, 0.236760f, 0.761729f, 0.089931f, 0.266264f, 0.086498f, 0.741946f, 0.246526f, 0.892066f, 0.294663f, 1.032967f,
0.030559f, 0.041927f, 0.000640f, 0.098177f, 0.052199f, 0.138964f, 0.072630f, 0.180745f, 0.000797f, 0.001802f, 0.000771f, 0.005118f, 0.092512f, 0.255554f, 0.111212f, 0.301557f,
0.064229f, 0.104777f, 0.001102f, 0.225406f, 0.155403f, 0.491903f, 0.177101f, 0.587799f, 0.063456f, 0.170534f, 0.050277f, 0.444892f, 0.226268f, 0.743177f, 0.222786f, 0.805684f,
0.028287f, 0.054179f, 0.000899f, 0.120600f, 0.067679f, 0.251527f, 0.142869f, 0.310992f, 0.020832f, 0.065733f, 0.030574f, 0.177435f, 0.130279f, 0.502405f, 0.237607f, 0.563561f,
0.065436f, 0.097571f, 0.001395f, 0.232017f, 0.246057f, 0.711905f, 0.348452f, 0.940306f, 0.084290f, 0.207053f, 0.082989f, 0.597065f, 0.287289f, 0.862488f, 0.351502f, 1.033530f,
0.068702f, 0.105849f, 0.001785f, 0.283457f, 0.080701f, 0.241255f, 0.139281f, 0.358862f, 0.001501f, 0.003809f, 0.001801f, 0.012371f, 0.174331f, 0.540782f, 0.259951f, 0.729786f,
0.065544f, 0.120069f, 0.001395f, 0.295407f, 0.109056f, 0.387642f, 0.154162f, 0.529745f, 0.054212f, 0.163605f, 0.053280f, 0.488120f, 0.193543f, 0.713851f, 0.236378f, 0.885047f,
0.002346f, 0.005046f, 0.000092f, 0.012846f, 0.003860f, 0.016110f, 0.010108f, 0.022779f, 0.001446f, 0.005125f, 0.002633f, 0.015822f, 0.009057f, 0.039221f, 0.020489f, 0.050315f,
0.088589f, 0.148335f, 0.002342f, 0.403393f, 0.229077f, 0.744266f, 0.402396f, 1.124248f, 0.095534f, 0.263524f, 0.116672f, 0.869057f, 0.326007f, 1.099065f, 0.494768f, 1.506190f,
0.077551f, 0.115313f, 0.002006f, 0.254439f, 0.112795f, 0.325435f, 0.193864f, 0.398858f, 0.002433f, 0.005960f, 0.002907f, 0.015947f, 0.255435f, 0.764723f, 0.379307f, 0.850318f,
0.092898f, 0.164241f, 0.001968f, 0.332945f, 0.191389f, 0.656561f, 0.269425f, 0.739291f, 0.110340f, 0.321373f, 0.107992f, 0.790029f, 0.356074f, 1.267495f, 0.433074f, 1.294821f,
0.039379f, 0.081743f, 0.001546f, 0.171458f, 0.080226f, 0.323135f, 0.209197f, 0.376477f, 0.034866f, 0.119229f, 0.063208f, 0.303270f, 0.197331f, 0.824729f, 0.444567f, 0.871743f,
0.120381f, 0.194535f, 0.003169f, 0.435899f, 0.385438f, 1.208588f, 0.674248f, 1.504237f, 0.186423f, 0.496294f, 0.226725f, 1.348561f, 0.575037f, 1.870974f, 0.869086f, 2.112654f,
0.005848f, 0.009565f, 0.000133f, 0.023946f, 0.005789f, 0.018375f, 0.008748f, 0.025551f, 0.000200f, 0.000540f, 0.000211f, 0.001640f, 0.017433f, 0.057417f, 0.022760f, 0.072433f,
0.007241f, 0.014084f, 0.000135f, 0.032391f, 0.010155f, 0.038323f, 0.012568f, 0.048957f, 0.009400f, 0.030118f, 0.008088f, 0.084000f, 0.025122f, 0.098377f, 0.026863f, 0.114018f,
0.003280f, 0.007489f, 0.000113f, 0.017822f, 0.004548f, 0.020152f, 0.010426f, 0.026637f, 0.003173f, 0.011938f, 0.005058f, 0.034452f, 0.014875f, 0.068392f, 0.029463f, 0.082016f,
0.012396f, 0.022037f, 0.000287f, 0.056021f, 0.027015f, 0.093191f, 0.041549f, 0.131592f, 0.020979f, 0.061443f, 0.022432f, 0.189418f, 0.053594f, 0.191834f, 0.071214f, 0.245756f,
0.141021f, 0.191387f, 0.003283f, 0.495810f, 0.192782f, 0.507665f, 0.298195f, 0.730515f, 0.004352f, 0.009731f, 0.004681f, 0.030570f, 0.470531f, 1.285729f, 0.628820f, 1.678511f,
0.176831f, 0.285344f, 0.003372f, 0.679139f, 0.342411f, 1.072117f, 0.433805f, 1.417360f, 0.206625f, 0.549281f, 0.181998f, 1.585355f, 0.686597f, 2.230722f, 0.751539f, 2.675507f,
0.103809f, 0.196678f, 0.003667f, 0.484350f, 0.198775f, 0.730745f, 0.466475f, 0.999580f, 0.090419f, 0.282217f, 0.147525f, 0.842808f, 0.526953f, 2.010137f, 1.068419f, 2.494596f,
0.182154f, 0.268667f, 0.004316f, 0.706808f, 0.548168f, 1.568825f, 0.862991f, 2.292503f, 0.277509f, 0.674301f, 0.303742f, 2.151212f, 0.881428f, 2.617557f, 1.198895f, 3.470197f,
0.130382f, 0.379123f, 0.004352f, 0.607434f, 0.120250f, 0.678470f, 0.266688f, 0.603806f, 0.002355f, 0.011281f, 0.003631f, 0.021919f, 0.245947f, 1.439914f, 0.471263f, 1.162589f,
0.128502f, 0.444281f, 0.003513f, 0.653976f, 0.167875f, 1.126198f, 0.304942f, 0.920805f, 0.087876f, 0.500514f, 0.110979f, 0.893436f, 0.282081f, 1.963595f, 0.442699f, 1.456558f,
0.005561f, 0.022573f, 0.000282f, 0.034380f, 0.007184f, 0.056583f, 0.024171f, 0.047869f, 0.002835f, 0.018956f, 0.006631f, 0.035012f, 0.015958f, 0.130430f, 0.046392f, 0.100108f,
0.152207f, 0.481002f, 0.005171f, 0.782617f, 0.309027f, 1.894924f, 0.697547f, 1.712545f, 0.135709f, 0.706514f, 0.212972f, 1.394006f, 0.416393f, 2.649398f, 0.812050f, 2.172302f,
0.194158f, 0.544872f, 0.006454f, 0.719313f, 0.221727f, 1.207371f, 0.489701f, 0.885344f, 0.005036f, 0.023283f, 0.007733f, 0.037273f, 0.475412f, 2.686219f, 0.907163f, 1.787044f,
0.240274f, 0.801731f, 0.006542f, 0.972383f, 0.388666f, 2.516416f, 0.703076f, 1.695272f, 0.235956f, 1.297037f, 0.296751f, 1.907670f, 0.684636f, 4.599538f, 1.070010f, 2.811215f,
0.123134f, 0.482405f, 0.006210f, 0.605389f, 0.196964f, 1.497278f, 0.659982f, 1.043695f, 0.090137f, 0.581751f, 0.209984f, 0.885323f, 0.458697f, 3.618184f, 1.327926f, 2.288150f,
0.272858f, 0.832194f, 0.009231f, 1.115656f, 0.685952f, 4.059429f, 1.541927f, 3.022869f, 0.349360f, 1.755342f, 0.545984f, 2.853712f, 0.968935f, 5.949973f, 1.881773f, 4.019687f,
0.091391f, 0.282149f, 0.002671f, 0.422588f, 0.071041f, 0.425570f, 0.137945f, 0.354046f, 0.002591f, 0.013177f, 0.003497f, 0.023932f, 0.202547f, 1.259029f, 0.339800f, 0.950269f,
0.116913f, 0.429163f, 0.002799f, 0.590538f, 0.128730f, 0.916902f, 0.204732f, 0.700804f, 0.125479f, 0.758807f, 0.138744f, 1.266190f, 0.301527f, 2.228531f, 0.414320f, 1.545309f,
0.064015f, 0.275900f, 0.002838f, 0.392817f, 0.069700f, 0.582893f, 0.205335f, 0.460974f, 0.051214f, 0.363631f, 0.104895f, 0.627832f, 0.215843f, 1.873014f, 0.549373f, 1.343852f,
0.175390f, 0.588478f, 0.005217f, 0.895061f, 0.300130f, 1.953969f, 0.593144f, 1.650779f, 0.245430f, 1.356603f, 0.337221f, 2.502177f, 0.563734f, 3.808305f, 0.962560f, 2.918944f,
0.268814f, 0.688538f, 0.008042f, 1.067205f, 0.288531f, 1.434010f, 0.573499f, 1.234584f, 0.006859f, 0.028944f, 0.009479f, 0.054403f, 0.666770f, 3.438624f, 1.145034f, 2.685814f,
0.348222f, 1.060511f, 0.008532f, 1.510154f, 0.529425f, 3.128579f, 0.861900f, 2.474581f, 0.336416f, 1.687858f, 0.380772f, 2.914637f, 1.005123f, 6.163265f, 1.413756f, 4.422707f,
0.247141f, 0.883718f, 0.011217f, 1.302068f, 0.371560f, 2.577997f, 1.120475f, 2.109846f, 0.177978f, 1.048421f, 0.373143f, 1.873260f, 0.932611f, 6.714328f, 2.429829f, 4.985328f,
0.314351f, 0.875064f, 0.009571f, 1.377347f, 0.742763f, 4.011981f, 1.502615f, 3.507605f, 0.395958f, 1.815828f, 0.556907f, 3.465935f, 1.130794f, 6.337835f, 1.976438f, 5.027077f,
0.055903f, 0.147414f, 0.001776f, 0.349092f, 0.069081f, 0.353459f, 0.145838f, 0.464931f, 0.001011f, 0.004391f, 0.001483f, 0.012609f, 0.112764f, 0.598692f, 0.205678f, 0.714458f,
0.059829f, 0.187583f, 0.001557f, 0.408114f, 0.104722f, 0.637092f, 0.181077f, 0.769907f, 0.040953f, 0.211527f, 0.049232f, 0.558080f, 0.140438f, 0.886540f, 0.209803f, 0.971980f,
0.002267f, 0.008346f, 0.000109f, 0.018788f, 0.003924f, 0.028030f, 0.012569f, 0.035048f, 0.001157f, 0.007015f, 0.002576f, 0.019151f, 0.006957f, 0.051567f, 0.019253f, 0.058498f,
0.079074f, 0.226610f, 0.002557f, 0.544960f, 0.215101f, 1.196120f, 0.462183f, 1.597747f, 0.070570f, 0.333170f, 0.105420f, 0.971612f, 0.231318f, 1.334717f, 0.429420f, 1.617503f,
0.098223f, 0.249969f, 0.003108f, 0.487745f, 0.150288f, 0.742136f, 0.315959f, 0.804336f, 0.002550f, 0.010691f, 0.003727f, 0.025298f, 0.257178f, 1.317779f, 0.467137f, 1.295745f,
0.131990f, 0.399392f, 0.003421f, 0.715964f, 0.286063f, 1.679594f, 0.492585f, 1.672416f, 0.129741f, 0.646749f, 0.155322f, 1.405951f, 0.402164f, 2.450162f, 0.598309f, 2.213388f,
0.059233f, 0.210441f, 0.002844f, 0.390333f, 0.126946f, 0.875127f, 0.404910f, 0.901624f, 0.043401f, 0.254020f, 0.096244f, 0.571367f, 0.235948f, 1.687789f, 0.650217f, 1.577593f,
0.167250f, 0.462584f, 0.005386f, 0.916600f, 0.563345f, 3.023307f, 1.205419f, 3.327512f, 0.214346f, 0.976654f, 0.318872f, 2.346779f, 0.635088f, 3.536640f, 1.174087f, 3.531434f,
0.045096f, 0.126257f, 0.001255f, 0.279497f, 0.046968f, 0.255152f, 0.086814f, 0.313740f, 0.001280f, 0.005902f, 0.001644f, 0.015844f, 0.106875f, 0.602452f, 0.170674f, 0.672072f,
0.062644f, 0.208535f, 0.001427f, 0.424118f, 0.092417f, 0.596939f, 0.139911f, 0.674352f, 0.067298f, 0.369063f, 0.070834f, 0.910229f, 0.172765f, 1.157936f, 0.225974f, 1.186763f,
0.030036f, 0.117396f, 0.001268f, 0.247045f, 0.043818f, 0.332309f, 0.122878f, 0.388431f, 0.024053f, 0.154874f, 0.046895f, 0.395223f, 0.108297f, 0.852224f, 0.262384f, 0.903748f,
0.104862f, 0.319067f, 0.002969f, 0.717278f, 0.240422f, 1.419450f, 0.452293f, 1.772451f, 0.146877f, 0.736236f, 0.192104f, 2.007083f, 0.360411f, 2.207968f, 0.585795f, 2.501323f,
0.177158f, 0.411504f, 0.005045f, 0.942708f, 0.254773f, 1.148284f, 0.482044f, 1.461171f, 0.004525f, 0.017315f, 0.005952f, 0.048103f, 0.469889f, 2.197559f, 0.768125f, 2.536968f,
0.249198f, 0.688241f, 0.005812f, 1.448538f, 0.507627f, 2.720343f, 0.786667f, 3.180249f, 0.240979f, 1.096413f, 0.259634f, 2.798374f, 0.769162f, 4.277067f, 1.029833f, 4.536348f,
0.154875f, 0.502211f, 0.006691f, 1.093677f, 0.311972f, 1.962934f, 0.895535f, 2.374418f, 0.111639f, 0.596377f, 0.222801f, 1.574948f, 0.624951f, 4.080229f, 1.549940f, 4.477739f,
0.251015f, 0.633667f, 0.007275f, 1.474169f, 0.794668f, 3.892519f, 1.530301f, 5.029972f, 0.316480f, 1.316159f, 0.423715f, 3.713104f, 0.965556f, 4.907626f, 1.606464f, 5.753460f,
0.142540f, 0.222013f, 0.003331f, 0.537393f, 0.147898f, 0.446976f, 0.229610f, 0.600962f, 0.002592f, 0.006650f, 0.002798f, 0.019521f, 0.212007f, 0.664847f, 0.284368f, 0.810974f,
0.156299f, 0.289453f, 0.002991f, 0.643693f, 0.229713f, 0.825454f, 0.292098f, 1.019627f, 0.107600f, 0.328272f, 0.095124f, 0.885271f, 0.270524f, 1.008699f, 0.297201f, 1.130401f,
0.005779f, 0.012566f, 0.000205f, 0.028913f, 0.008399f, 0.035435f, 0.019782f, 0.045289f, 0.002966f, 0.010623f, 0.004856f, 0.029641f, 0.013077f, 0.057248f, 0.026611f, 0.066381f,
0.213695f, 0.361729f, 0.005082f, 0.889162f, 0.488104f, 1.603190f, 0.771257f, 2.188924f, 0.191807f, 0.534876f, 0.210711f, 1.594384f, 0.460947f, 1.570984f, 0.629274f, 1.945988f,
0.234609f, 0.352664f, 0.005459f, 0.703363f, 0.301414f, 0.879152f, 0.466001f, 0.973936f, 0.006126f, 0.015170f, 0.006585f, 0.036691f, 0.452947f, 1.370869f, 0.605023f, 1.377797f,
0.323013f, 0.577323f, 0.006156f, 1.057848f, 0.587824f, 2.038589f, 0.744358f, 2.074828f, 0.319330f, 0.940241f, 0.281132f, 2.089226f, 0.725707f, 2.611516f, 0.793960f, 2.411393f,
0.141438f, 0.296807f, 0.004993f, 0.562720f, 0.254524f, 1.036386f, 0.597012f, 1.091410f, 0.104228f, 0.360326f, 0.169972f, 0.828430f, 0.415431f, 1.755258f, 0.841892f, 1.676989f,
0.423414f, 0.691719f, 0.010028f, 1.400978f, 1.197509f, 3.796009f, 1.884336f, 4.270484f, 0.545756f, 1.468803f, 0.597055f, 3.607508f, 1.185527f, 3.899498f, 1.611734f, 3.979983f,
0.112246f, 0.185620f, 0.002296f, 0.420010f, 0.098161f, 0.314974f, 0.133426f, 0.395875f, 0.003203f, 0.008727f, 0.003027f, 0.023945f, 0.196148f, 0.653087f, 0.230351f, 0.744693f,
0.159756f, 0.314118f, 0.002677f, 0.653001f, 0.197893f, 0.755007f, 0.220316f, 0.871807f, 0.172608f, 0.559111f, 0.133602f, 1.409489f, 0.324869f, 1.286109f, 0.312484f, 1.347318f,
0.074739f, 0.172542f, 0.002320f, 0.371132f, 0.091550f, 0.410099f, 0.188797f, 0.489972f, 0.060194f, 0.228929f, 0.086303f, 0.597142f, 0.198698f, 0.923574f, 0.354023f, 1.001101f,
0.276639f, 0.497183f, 0.005760f, 1.142443f, 0.532568f, 1.857208f, 0.736776f, 2.370431f, 0.389702f, 1.153812f, 0.374826f, 3.215110f, 0.701086f, 2.536916f, 0.837981f, 2.937619f,
0.321283f, 0.440799f, 0.006728f, 1.032181f, 0.387958f, 1.032813f, 0.539802f, 1.343339f, 0.008253f, 0.018654f, 0.007984f, 0.052970f, 0.628347f, 1.735744f, 0.755356f, 2.048200f,
0.463037f, 0.755356f, 0.007942f, 1.625000f, 0.791992f, 2.506922f, 0.902575f, 2.995648f, 0.450332f, 1.210233f, 0.356805f, 3.157279f, 1.053822f, 3.461273f, 1.037604f, 3.752396f,
0.280786f, 0.537802f, 0.008921f, 1.197120f, 0.474917f, 1.765012f, 1.002536f, 2.182286f, 0.203561f, 0.642304f, 0.298753f, 1.733797f, 0.835450f, 3.221805f, 1.523718f, 3.613981f,
0.482492f, 0.719436f, 0.010284f, 1.710767f, 1.282573f, 3.710801f, 1.816305f, 4.901341f, 0.611816f, 1.502875f, 0.602370f, 4.333752f, 1.368506f, 4.108479f, 1.674386f, 4.923241f,
0.051370f, 0.079146f, 0.001334f, 0.211948f, 0.057246f, 0.171137f, 0.098801f, 0.254563f, 0.000842f, 0.002137f, 0.001010f, 0.006941f, 0.152338f, 0.472559f, 0.227157f, 0.637719f,
0.088653f, 0.162402f, 0.001886f, 0.399558f, 0.139938f, 0.497414f, 0.197817f, 0.679758f, 0.055020f, 0.166043f, 0.054074f, 0.495394f, 0.305936f, 1.128395f, 0.373646f, 1.399008f,
0.002172f, 0.004671f, 0.000086f, 0.011890f, 0.003390f, 0.014146f, 0.008876f, 0.020003f, 0.001005f, 0.003560f, 0.001829f, 0.010989f, 0.009797f, 0.042427f, 0.022164f, 0.054427f,
0.097919f, 0.163957f, 0.002589f, 0.445876f, 0.240212f, 0.780443f, 0.421955f, 1.178895f, 0.079233f, 0.218560f, 0.096764f, 0.720773f, 0.421121f, 1.419722f, 0.639119f, 1.945627f,
0.048214f, 0.071691f, 0.001247f, 0.158188f, 0.066528f, 0.191947f, 0.114344f, 0.235253f, 0.001135f, 0.002780f, 0.001356f, 0.007439f, 0.185594f, 0.555632f, 0.275597f, 0.617824f,
0.104476f, 0.184710f, 0.002214f, 0.374440f, 0.204199f, 0.700505f, 0.287458f, 0.788773f, 0.093112f, 0.271195f, 0.091131f, 0.666678f, 0.467997f, 1.665902f, 0.569201f, 1.701816f,
0.030307f, 0.062911f, 0.001189f, 0.131957f, 0.058576f, 0.235931f, 0.152742f, 0.274877f, 0.020134f, 0.068852f, 0.036502f, 0.175133f, 0.177485f, 0.741787f, 0.399857f, 0.784072f,
0.110635f, 0.178786f, 0.002913f, 0.400610f, 0.336060f, 1.053758f, 0.587871f, 1.311531f, 0.128558f, 0.342246f, 0.156350f, 0.929972f, 0.617625f, 2.009541f, 0.933452f, 2.269120f,
0.005320f, 0.008703f, 0.000121f, 0.021786f, 0.004997f, 0.015860f, 0.007551f, 0.022054f, 0.000137f, 0.000369f, 0.000144f, 0.001120f, 0.018536f, 0.061050f, 0.024200f, 0.077016f,
0.011917f, 0.023179f, 0.000222f, 0.053308f, 0.015855f, 0.059835f, 0.019623f, 0.076438f, 0.011608f, 0.037193f, 0.009988f, 0.103732f, 0.048318f, 0.189215f, 0.051667f, 0.219299f,
0.003694f, 0.008435f, 0.000127f, 0.020072f, 0.004859f, 0.021531f, 0.011140f, 0.028461f, 0.002682f, 0.010089f, 0.004274f, 0.029115f, 0.019578f, 0.090019f, 0.038779f, 0.107951f,
0.016671f, 0.029637f, 0.000386f, 0.075344f, 0.034470f, 0.118904f, 0.053013f, 0.167900f, 0.021172f, 0.062006f, 0.022638f, 0.191153f, 0.084238f, 0.301520f, 0.111932f, 0.386273f,
0.090127f, 0.122316f, 0.002098f, 0.316875f, 0.116886f, 0.307805f, 0.180800f, 0.442923f, 0.002087f, 0.004666f, 0.002245f, 0.014660f, 0.351442f, 0.960317f, 0.469668f, 1.253688f,
0.204432f, 0.329883f, 0.003898f, 0.785145f, 0.375548f, 1.175873f, 0.475788f, 1.554527f, 0.179241f, 0.476486f, 0.157878f, 1.375250f, 0.927655f, 3.013910f, 1.015399f, 3.614856f,
0.082128f, 0.155601f, 0.002901f, 0.383191f, 0.149191f, 0.548465f, 0.350115f, 0.750240f, 0.053676f, 0.167534f, 0.087576f, 0.500320f, 0.487215f, 1.858553f, 0.987850f, 2.306479f,
0.172090f, 0.253824f, 0.004078f, 0.667758f, 0.491313f, 1.406109f, 0.773482f, 2.054727f, 0.196724f, 0.478008f, 0.215321f, 1.524981f, 0.973190f, 2.890061f, 1.323708f, 3.831467f,
0.081725f, 0.237638f, 0.002728f, 0.380746f, 0.071507f, 0.403453f, 0.158587f, 0.359054f, 0.001108f, 0.005306f, 0.001708f, 0.010309f, 0.180165f, 1.054789f, 0.345218f, 0.851639f,
0.145702f, 0.503747f, 0.003983f, 0.741510f, 0.180579f, 1.211426f, 0.328020f, 0.990489f, 0.074764f, 0.425830f, 0.094419f, 0.760121f, 0.373786f, 2.601962f, 0.586621f, 1.930086f,
0.004315f, 0.017515f, 0.000219f, 0.026676f, 0.005288f, 0.041651f, 0.017793f, 0.035237f, 0.001650f, 0.011037f, 0.003861f, 0.020384f, 0.014471f, 0.118274f, 0.042069f, 0.090778f,
0.141032f, 0.445686f, 0.004791f, 0.725155f, 0.271647f, 1.665712f, 0.613171f, 1.505394f, 0.094353f, 0.491208f, 0.148070f, 0.969192f, 0.450898f, 2.868945f, 0.879342f, 2.352314f,
0.101191f, 0.283975f, 0.003364f, 0.374889f, 0.109630f, 0.596970f, 0.242127f, 0.437748f, 0.001969f, 0.009105f, 0.003024f, 0.014576f, 0.289567f, 1.636138f, 0.552540f, 1.088463f,
0.226522f, 0.755846f, 0.006167f, 0.916731f, 0.347623f, 2.250680f, 0.628831f, 1.516250f, 0.166916f, 0.917531f, 0.209923f, 1.349497f, 0.754324f, 5.067717f, 1.178924f, 3.097364f,
0.079442f, 0.311230f, 0.004006f, 0.390574f, 0.120554f, 0.916428f, 0.403950f, 0.638807f, 0.043635f, 0.281624f, 0.101653f, 0.428583f, 0.345851f, 2.728057f, 1.001236f, 1.725231f,
0.210217f, 0.641143f, 0.007112f, 0.859530f, 0.501362f, 2.967034f, 1.126993f, 2.209413f, 0.201961f, 1.014744f, 0.315627f, 1.649699f, 0.872407f, 5.357218f, 1.694305f, 3.619233f,
0.069702f, 0.215191f, 0.002037f, 0.322302f, 0.051402f, 0.307924f, 0.099811f, 0.256172f, 0.001483f, 0.007541f, 0.002002f, 0.013696f, 0.180537f, 1.122211f, 0.302874f, 0.847004f,
0.161298f, 0.592089f, 0.003861f, 0.814728f, 0.168489f, 1.200092f, 0.267965f, 0.917252f, 0.129897f, 0.785525f, 0.143629f, 1.310774f, 0.486167f, 3.593166f, 0.668028f, 2.491575f,
0.060438f, 0.260484f, 0.002680f, 0.370868f, 0.062430f, 0.522090f, 0.183916f, 0.412889f, 0.036281f, 0.257605f, 0.074310f, 0.444771f, 0.238156f, 2.066636f, 0.606165f, 1.482773f,
0.197741f, 0.663470f, 0.005882f, 1.009122f, 0.321016f, 2.089949f, 0.634422f, 1.765659f, 0.207626f, 1.147645f, 0.285279f, 2.116766f, 0.742778f, 5.017836f, 1.268272f, 3.846011f,
0.144018f, 0.368888f, 0.004308f, 0.571761f, 0.146651f, 0.728863f, 0.291492f, 0.627501f, 0.002758f, 0.011636f, 0.003811f, 0.021870f, 0.417481f, 2.153005f, 0.716934f, 1.681653f,
0.337476f, 1.027783f, 0.008269f, 1.463550f, 0.486763f, 2.876474f, 0.792447f, 2.275176f, 0.244640f, 1.227400f, 0.276895f, 2.119506f, 1.138412f, 6.980571f, 1.601233f, 5.009199f,
0.163906f, 0.586090f, 0.007439f, 0.863544f, 0.233780f, 1.622035f, 0.704985f, 1.327482f, 0.088569f, 0.521736f, 0.185691f, 0.932208f, 0.722845f, 5.204118f, 1.883303f, 3.864011f,
0.248959f, 0.693031f, 0.007580f, 1.090827f, 0.558072f, 3.014382f, 1.128982f, 2.635422f, 0.235302f, 1.079074f, 0.330948f, 2.059666f, 1.046622f, 5.866068f, 1.829319f, 4.652879f,
0.008856f, 0.023354f, 0.000281f, 0.055305f, 0.010383f, 0.053124f, 0.021919f, 0.069878f, 0.000120f, 0.000522f, 0.000176f, 0.001499f, 0.020878f, 0.110846f, 0.038081f, 0.132280f,
0.017146f, 0.053757f, 0.000446f, 0.116957f, 0.028471f, 0.173210f, 0.049230f, 0.209319f, 0.008806f, 0.045486f, 0.010587f, 0.120006f, 0.047035f, 0.296917f, 0.070267f, 0.325532f,
0.000445f, 0.001637f, 0.000021f, 0.003685f, 0.000730f, 0.005215f, 0.002338f, 0.006521f, 0.000170f, 0.001032f, 0.000379f, 0.002818f, 0.001595f, 0.011819f, 0.004413f, 0.013407f,
0.018518f, 0.053070f, 0.000599f, 0.127624f, 0.047790f, 0.265748f, 0.102686f, 0.354980f, 0.012401f, 0.058546f, 0.018525f, 0.170736f, 0.063310f, 0.365302f, 0.117529f, 0.442698f,
0.012938f, 0.032928f, 0.000409f, 0.064249f, 0.018781f, 0.092743f, 0.039485f, 0.100516f, 0.000252f, 0.001057f, 0.000368f, 0.002500f, 0.039591f, 0.202866f, 0.071913f, 0.199474f,
0.031451f, 0.095168f, 0.000815f, 0.170602f, 0.064667f, 0.379685f, 0.111353f, 0.378062f, 0.023197f, 0.115636f, 0.027771f, 0.251377f, 0.111993f, 0.682308f, 0.166614f, 0.616373f,
0.009659f, 0.034315f, 0.000464f, 0.063649f, 0.019638f, 0.135380f, 0.062639f, 0.139479f, 0.005310f, 0.031081f, 0.011776f, 0.069909f, 0.044964f, 0.321639f, 0.123911f, 0.300639f,
0.032568f, 0.090076f, 0.001049f, 0.178483f, 0.104068f, 0.558505f, 0.222681f, 0.614702f, 0.031318f, 0.142700f, 0.046591f, 0.342890f, 0.144526f, 0.804827f, 0.267185f, 0.803643f,
0.008693f, 0.024338f, 0.000242f, 0.053878f, 0.008589f, 0.046662f, 0.015876f, 0.057376f, 0.000185f, 0.000854f, 0.000238f, 0.002292f, 0.024077f, 0.135721f, 0.038450f, 0.151406f,
0.021844f, 0.072716f, 0.000498f, 0.147890f, 0.030572f, 0.197474f, 0.046284f, 0.223083f, 0.017608f, 0.096564f, 0.018533f, 0.238159f, 0.070405f, 0.471879f, 0.092088f, 0.483627f,
0.007167f, 0.028014f, 0.000303f, 0.058951f, 0.009920f, 0.075229f, 0.027817f, 0.087934f, 0.004307f, 0.027731f, 0.008397f, 0.070766f, 0.030201f, 0.237664f, 0.073173f, 0.252033f,
0.029881f, 0.090920f, 0.000846f, 0.204393f, 0.064995f, 0.383730f, 0.122272f, 0.479159f, 0.031405f, 0.157420f, 0.041075f, 0.429149f, 0.120025f, 0.735301f, 0.195082f, 0.832994f,
0.023989f, 0.055722f, 0.000683f, 0.127653f, 0.032729f, 0.147513f, 0.061925f, 0.187708f, 0.000460f, 0.001759f, 0.000605f, 0.004888f, 0.074361f, 0.347767f, 0.121557f, 0.401479f,
0.061041f, 0.168583f, 0.001424f, 0.354816f, 0.117963f, 0.632156f, 0.182807f, 0.739030f, 0.044291f, 0.201517f, 0.047720f, 0.514332f, 0.220184f, 1.224373f, 0.294805f, 1.298596f,
0.025961f, 0.084183f, 0.001122f, 0.183327f, 0.049611f, 0.312156f, 0.142412f, 0.377592f, 0.014042f, 0.075011f, 0.028023f, 0.198093f, 0.122427f, 0.799313f, 0.303632f, 0.877184f,
0.050246f, 0.126841f, 0.001456f, 0.295085f, 0.150908f, 0.739193f, 0.290606f, 0.955196f, 0.047535f, 0.197684f, 0.063641f, 0.557701f, 0.225877f, 1.148062f, 0.375807f, 1.345931f,
0.127782f, 0.199026f, 0.002986f, 0.481751f, 0.125782f, 0.380139f, 0.195276f, 0.511099f, 0.001743f, 0.004473f, 0.001882f, 0.013131f, 0.222113f, 0.696541f, 0.297924f, 0.849634f,
0.253458f, 0.469385f, 0.004851f, 1.043829f, 0.353398f, 1.269904f, 0.449372f, 1.568625f, 0.130926f, 0.399438f, 0.115746f, 1.077188f, 0.512685f, 1.911640f, 0.563242f, 2.142285f,
0.006413f, 0.013944f, 0.000227f, 0.032086f, 0.008842f, 0.037306f, 0.020827f, 0.047680f, 0.002469f, 0.008845f, 0.004044f, 0.024682f, 0.016959f, 0.074245f, 0.034512f, 0.086090f,
0.283186f, 0.479359f, 0.006735f, 1.178306f, 0.613645f, 2.015529f, 0.969624f, 2.751912f, 0.190724f, 0.531856f, 0.209521f, 1.585381f, 0.713874f, 2.433002f, 0.974564f, 3.013776f,
0.174874f, 0.262870f, 0.004069f, 0.524276f, 0.213143f, 0.621687f, 0.329529f, 0.688712f, 0.003426f, 0.008485f, 0.003683f, 0.020521f, 0.394568f, 1.194181f, 0.527043f, 1.200216f,
0.435532f, 0.778429f, 0.008301f, 1.426341f, 0.751924f, 2.607695f, 0.952158f, 2.654051f, 0.323075f, 0.951268f, 0.284430f, 2.113730f, 1.143550f, 4.115159f, 1.251101f, 3.799810f,
0.130506f, 0.273866f, 0.004607f, 0.519226f, 0.222802f, 0.907221f, 0.522607f, 0.955387f, 0.072163f, 0.249473f, 0.117681f, 0.573567f, 0.447979f, 1.892776f, 0.907851f, 1.808375f,
0.466543f, 0.762177f, 0.011049f, 1.543681f, 1.251792f, 3.968081f, 1.969753f, 4.464063f, 0.451220f, 1.214377f, 0.493633f, 2.982617f, 1.526621f, 5.021444f, 2.075455f, 5.125087f,
0.122437f, 0.202472f, 0.002505f, 0.458143f, 0.101579f, 0.325944f, 0.138073f, 0.409663f, 0.002622f, 0.007143f, 0.002478f, 0.019599f, 0.250046f, 0.832541f, 0.293647f, 0.949318f,
0.315223f, 0.619803f, 0.005282f, 1.288471f, 0.370440f, 1.413313f, 0.412415f, 1.631953f, 0.255556f, 0.827795f, 0.197805f, 2.086826f, 0.749140f, 2.965734f, 0.720579f, 3.106879f,
0.100919f, 0.232980f, 0.003132f, 0.501134f, 0.117276f, 0.525340f, 0.241850f, 0.627659f, 0.060988f, 0.231947f, 0.087441f, 0.605016f, 0.313553f, 1.457440f, 0.558663f, 1.579780f,
0.446068f, 0.801683f, 0.009288f, 1.842133f, 0.814683f, 2.841020f, 1.127065f, 3.626110f, 0.471502f, 1.396001f, 0.453503f, 3.889971f, 1.321149f, 4.780644f, 1.579118f, 5.535743f,
0.246178f, 0.337756f, 0.005155f, 0.790894f, 0.282016f, 0.750777f, 0.392395f, 0.976506f, 0.004745f, 0.010725f, 0.004590f, 0.030455f, 0.562673f, 1.554324f, 0.676407f, 1.834123f,
0.641797f, 1.046969f, 0.011008f, 2.252348f, 1.041430f, 3.296475f, 1.186840f, 3.939125f, 0.468359f, 1.258679f, 0.371088f, 3.283665f, 1.707037f, 5.606756f, 1.680767f, 6.078332f,
0.266331f, 0.510116f, 0.008462f, 1.135492f, 0.427357f, 1.588259f, 0.902139f, 1.963745f, 0.144879f, 0.457142f, 0.212629f, 1.233982f, 0.926106f, 3.571408f, 1.689060f, 4.006140f,
0.546510f, 0.814892f, 0.011648f, 1.937755f, 1.378216f, 3.987519f, 1.951749f, 5.266839f, 0.519987f, 1.277306f, 0.511959f, 3.683292f, 1.811542f, 5.438547f, 2.216448f, 6.517078f,
0.065496f, 0.100910f, 0.001701f, 0.270230f, 0.082747f, 0.247371f, 0.142812f, 0.367959f, 0.001334f, 0.003385f, 0.001600f, 0.010992f, 0.225013f, 0.697999f, 0.335525f, 0.941950f,
0.106026f, 0.194227f, 0.002256f, 0.477858f, 0.189738f, 0.674427f, 0.268214f, 0.921661f, 0.081733f, 0.246658f, 0.080327f, 0.735912f, 0.423879f, 1.563407f, 0.517692f, 1.938345f,
0.002180f, 0.004688f, 0.000086f, 0.011934f, 0.003857f, 0.016097f, 0.010100f, 0.022762f, 0.001252f, 0.004438f, 0.002280f, 0.013700f, 0.011392f, 0.049334f, 0.025773f, 0.063288f,
0.108376f, 0.181466f, 0.002865f, 0.493493f, 0.301411f, 0.979280f, 0.529458f, 1.479246f, 0.108926f, 0.300465f, 0.133027f, 0.990882f, 0.539965f, 1.820380f, 0.819483f, 2.494700f,
0.076562f, 0.113843f, 0.001981f, 0.251196f, 0.119769f, 0.345557f, 0.205851f, 0.423520f, 0.002239f, 0.005484f, 0.002675f, 0.014673f, 0.341425f, 1.022161f, 0.506998f, 1.136571f,
0.155621f, 0.275133f, 0.003297f, 0.557743f, 0.344830f, 1.182939f, 0.485428f, 1.331996f, 0.172273f, 0.501754f, 0.168606f, 1.233461f, 0.807583f, 2.874709f, 0.982223f, 2.936684f,
0.037887f, 0.078646f, 0.001487f, 0.164961f, 0.083017f, 0.334375f, 0.216474f, 0.389572f, 0.031264f, 0.106912f, 0.056678f, 0.271941f, 0.257042f, 1.074289f, 0.579091f, 1.135529f,
0.152508f, 0.246452f, 0.004015f, 0.552232f, 0.525190f, 1.646796f, 0.918716f, 2.049640f, 0.220118f, 0.585997f, 0.267705f, 1.592308f, 0.986318f, 3.209146f, 1.490680f, 3.623682f,
0.007560f, 0.012367f, 0.000172f, 0.030960f, 0.008051f, 0.025553f, 0.012165f, 0.035531f, 0.000242f, 0.000651f, 0.000254f, 0.001976f, 0.030517f, 0.100508f, 0.039841f, 0.126793f,
0.015886f, 0.030898f, 0.000296f, 0.071061f, 0.023961f, 0.090426f, 0.029655f, 0.115518f, 0.019220f, 0.061583f, 0.016538f, 0.171755f, 0.074618f, 0.292204f, 0.079790f, 0.338662f,
0.004132f, 0.009436f, 0.000143f, 0.022456f, 0.006163f, 0.027309f, 0.014129f, 0.036098f, 0.003727f, 0.014020f, 0.005940f, 0.040458f, 0.025375f, 0.116670f, 0.050261f, 0.139911f,
0.020566f, 0.036562f, 0.000476f, 0.092946f, 0.048208f, 0.166296f, 0.074142f, 0.234820f, 0.032441f, 0.095011f, 0.034688f, 0.292903f, 0.120388f, 0.430918f, 0.159968f, 0.552042f,
0.121320f, 0.164649f, 0.002824f, 0.426543f, 0.178377f, 0.469733f, 0.275914f, 0.675932f, 0.003490f, 0.007802f, 0.003753f, 0.024511f, 0.548052f, 1.497556f, 0.732419f, 1.955049f,
0.258129f, 0.416532f, 0.004922f, 0.991375f, 0.537592f, 1.683245f, 0.681083f, 2.225283f, 0.281114f, 0.747300f, 0.247609f, 2.156884f, 1.356960f, 4.408703f, 1.485310f, 5.287758f,
0.087031f, 0.164891f, 0.003074f, 0.406070f, 0.179237f, 0.658921f, 0.420625f, 0.901332f, 0.070652f, 0.220519f, 0.115273f, 0.658553f, 0.598135f, 2.281671f, 1.212743f, 2.831572f,
0.201090f, 0.296598f, 0.004765f, 0.780288f, 0.650868f, 1.862747f, 1.024673f, 2.722006f, 0.285529f, 0.693790f, 0.312521f, 2.213388f, 1.317426f, 3.912331f, 1.791928f, 5.186730f,
0.171525f, 0.498758f, 0.005725f, 0.799113f, 0.170145f, 0.959987f, 0.377345f, 0.854343f, 0.002888f, 0.013832f, 0.004452f, 0.026875f, 0.438063f, 2.564671f, 0.839380f, 2.070720f,
0.286848f, 0.991741f, 0.007842f, 1.459831f, 0.403044f, 2.703844f, 0.732124f, 2.210724f, 0.182824f, 1.041307f, 0.230888f, 1.858769f, 0.852513f, 5.934431f, 1.337937f, 4.402048f,
0.007129f, 0.028940f, 0.000361f, 0.044077f, 0.009905f, 0.078021f, 0.033329f, 0.066005f, 0.003387f, 0.022650f, 0.007923f, 0.041835f, 0.027700f, 0.226395f, 0.080525f, 0.173762f,
0.256951f, 0.812012f, 0.008729f, 1.321187f, 0.561097f, 3.440588f, 1.266528f, 3.109445f, 0.213523f, 1.111621f, 0.335087f, 2.193314f, 0.951710f, 6.055478f, 1.856025f, 4.965025f,
0.264513f, 0.742313f, 0.008793f, 0.979963f, 0.324890f, 1.769126f, 0.717545f, 1.297269f, 0.006395f, 0.029563f, 0.009819f, 0.047327f, 0.876896f, 4.954725f, 1.673260f, 3.296199f,
0.555432f, 1.853330f, 0.015122f, 2.247819f, 0.966333f, 6.256512f, 1.748044f, 4.214921f, 0.508364f, 2.794457f, 0.639347f, 4.110062f, 2.142742f, 14.395420f, 3.348867f, 8.798411f,
0.163480f, 0.640469f, 0.008245f, 0.803749f, 0.281254f, 2.138033f, 0.942419f, 1.490340f, 0.111535f, 0.719853f, 0.259832f, 1.095491f, 0.824514f, 6.503736f, 2.386965f, 4.112981f,
0.477018f, 1.454864f, 0.016139f, 1.950421f, 1.289786f, 7.632889f, 2.899264f, 5.683860f, 0.569237f, 2.860098f, 0.889609f, 4.649746f, 2.293396f, 14.083130f, 4.454013f, 9.514291f,
0.163057f, 0.503403f, 0.004765f, 0.753973f, 0.136325f, 0.816648f, 0.264709f, 0.679396f, 0.004308f, 0.021911f, 0.005816f, 0.039796f, 0.489273f, 3.041305f, 0.820819f, 2.295465f,
0.353942f, 1.299248f, 0.008472f, 1.787794f, 0.419156f, 2.985512f, 0.666626f, 2.281880f, 0.354048f, 2.141027f, 0.391476f, 3.572646f, 1.235899f, 9.134291f, 1.698212f, 6.333906f,
0.111305f, 0.479715f, 0.004935f, 0.683003f, 0.130345f, 1.090051f, 0.383990f, 0.862054f, 0.082994f, 0.589270f, 0.169984f, 1.017411f, 0.508109f, 4.409193f, 1.293260f, 3.163514f,
0.401558f, 1.347330f, 0.011944f, 2.049259f, 0.739059f, 4.811579f, 1.460596f, 4.064985f, 0.523712f, 2.894796f, 0.719581f, 5.339285f, 1.747448f, 11.804890f, 2.983719f, 9.048072f,
0.319125f, 0.817405f, 0.009547f, 1.266945f, 0.368407f, 1.830998f, 0.732265f, 1.576364f, 0.007590f, 0.032025f, 0.010488f, 0.060195f, 1.071697f, 5.526889f, 1.840410f, 4.316900f,
0.701452f, 2.136273f, 0.017187f, 3.042026f, 1.147023f, 6.778208f, 1.867347f, 5.361292f, 0.631596f, 3.168830f, 0.714872f, 5.472015f, 2.741242f, 16.808890f, 3.855693f, 12.061910f,
0.285922f, 1.022392f, 0.012977f, 1.506390f, 0.462338f, 3.207837f, 1.394222f, 2.625310f, 0.191907f, 1.130475f, 0.402346f, 2.019868f, 1.460800f, 10.517020f, 3.805973f, 7.808792f,
0.478885f, 1.333079f, 0.014581f, 2.098260f, 1.217005f, 6.573562f, 2.462009f, 5.747151f, 0.562194f, 2.578171f, 0.790715f, 4.921046f, 2.332307f, 13.072030f, 4.076480f, 10.368540f,
0.068008f, 0.179333f, 0.002161f, 0.424679f, 0.090386f, 0.462472f, 0.190817f, 0.608325f, 0.001146f, 0.004978f, 0.001682f, 0.014296f, 0.185729f, 0.986077f, 0.338762f, 1.176748f,
0.123499f, 0.387210f, 0.003214f, 0.842431f, 0.232496f, 1.414429f, 0.402014f, 1.709295f, 0.078788f, 0.406949f, 0.094715f, 1.073668f, 0.392485f, 2.477635f, 0.586342f, 2.716415f,
0.002688f, 0.009894f, 0.000130f, 0.022274f, 0.005004f, 0.035740f, 0.016026f, 0.044690f, 0.001278f, 0.007751f, 0.002846f, 0.021161f, 0.011167f, 0.082770f, 0.030903f, 0.093895f,
0.123441f, 0.353758f, 0.003992f, 0.850729f, 0.361157f, 2.008296f, 0.776009f, 2.682631f, 0.102675f, 0.484745f, 0.153381f, 1.413646f, 0.488902f, 2.820993f, 0.907601f, 3.418677f,
0.123741f, 0.314913f, 0.003915f, 0.614463f, 0.203636f, 1.005572f, 0.428115f, 1.089852f, 0.002994f, 0.012553f, 0.004377f, 0.029704f, 0.438657f, 2.247671f, 0.796771f, 2.210088f,
0.282148f, 0.853759f, 0.007312f, 1.530478f, 0.657694f, 3.861588f, 1.132513f, 3.845086f, 0.258484f, 1.288525f, 0.309449f, 2.801089f, 1.163927f, 7.091150f, 1.731599f, 6.405891f,
0.072721f, 0.258361f, 0.003491f, 0.479218f, 0.167627f, 1.155567f, 0.534665f, 1.190554f, 0.049661f, 0.290661f, 0.110127f, 0.653784f, 0.392194f, 2.805447f, 1.080793f, 2.622279f,
0.270381f, 0.747826f, 0.008708f, 1.481800f, 0.979513f, 5.256758f, 2.095916f, 5.785693f, 0.322959f, 1.471539f, 0.480449f, 3.535925f, 1.390049f, 7.740819f, 2.569782f, 7.729423f,
0.074403f, 0.208307f, 0.002070f, 0.461134f, 0.083345f, 0.452767f, 0.154052f, 0.556732f, 0.001968f, 0.009075f, 0.002529f, 0.024363f, 0.238733f, 1.345731f, 0.381244f, 1.501246f,
0.175373f, 0.583794f, 0.003996f, 1.187322f, 0.278265f, 1.797371f, 0.421268f, 2.030461f, 0.175593f, 0.962948f, 0.184817f, 2.374946f, 0.654823f, 4.388866f, 0.856499f, 4.498131f,
0.048294f, 0.188755f, 0.002038f, 0.397210f, 0.075774f, 0.574662f, 0.212492f, 0.671712f, 0.036044f, 0.232082f, 0.070274f, 0.592252f, 0.235746f, 1.855169f, 0.571173f, 1.967329f,
0.222012f, 0.675518f, 0.006286f, 1.518599f, 0.547465f, 3.232227f, 1.029915f, 4.036046f, 0.289822f, 1.452760f, 0.379064f, 3.960428f, 1.033096f, 6.328996f, 1.679144f, 7.169880f,
0.194484f, 0.451747f, 0.005538f, 1.034901f, 0.300816f, 1.355804f, 0.569160f, 1.725236f, 0.004630f, 0.017716f, 0.006090f, 0.049217f, 0.698398f, 3.266243f, 1.141667f, 3.770707f,
0.464193f, 1.282018f, 0.010827f, 2.698257f, 1.017007f, 5.450084f, 1.576052f, 6.371486f, 0.418363f, 1.903483f, 0.450750f, 4.858256f, 1.939803f, 10.786630f, 2.597207f, 11.440530f,
0.165690f, 0.537281f, 0.007159f, 1.170050f, 0.358970f, 2.258642f, 1.030444f, 2.732114f, 0.111314f, 0.594645f, 0.222154f, 1.570374f, 0.905207f, 5.909986f, 2.245002f, 6.485756f,
0.353612f, 0.892665f, 0.010249f, 2.076706f, 1.204036f, 5.897723f, 2.318625f, 7.621128f, 0.415523f, 1.728053f, 0.556317f, 4.875126f, 1.841584f, 9.360204f, 3.063972f, 10.973440f,
0.228469f, 0.355850f, 0.005338f, 0.861353f, 0.254962f, 0.770548f, 0.395827f, 1.036006f, 0.003872f, 0.009935f, 0.004179f, 0.029162f, 0.460071f, 1.442771f, 0.617102f, 1.759878f,
0.425086f, 0.787227f, 0.008135f, 1.750652f, 0.671945f, 2.414572f, 0.854429f, 2.982555f, 0.272743f, 0.832102f, 0.241119f, 2.243980f, 0.996125f, 3.714232f, 1.094355f, 4.162365f,
0.009027f, 0.019628f, 0.000320f, 0.045163f, 0.014110f, 0.059531f, 0.033234f, 0.076086f, 0.004317f, 0.015465f, 0.007070f, 0.043152f, 0.027654f, 0.121068f, 0.056276f, 0.140382f,
0.439532f, 0.744011f, 0.010453f, 1.828843f, 1.079777f, 3.546552f, 1.706164f, 4.842304f, 0.367689f, 1.025344f, 0.403928f, 3.056394f, 1.283608f, 4.374752f, 1.752352f, 5.419034f,
0.389419f, 0.585374f, 0.009062f, 1.167486f, 0.538099f, 1.569504f, 0.831927f, 1.738717f, 0.009477f, 0.023469f, 0.010187f, 0.056761f, 1.017902f, 3.080736f, 1.359661f, 3.096305f,
0.909755f, 1.626011f, 0.017339f, 2.979391f, 1.780645f, 6.175327f, 2.254823f, 6.285104f, 0.838234f, 2.468109f, 0.737966f, 5.484169f, 2.767272f, 9.958257f, 3.027535f, 9.195146f,
0.228787f, 0.480110f, 0.008077f, 0.910245f, 0.442814f, 1.803075f, 1.038666f, 1.898804f, 0.157135f, 0.543229f, 0.256250f, 1.248944f, 0.909812f, 3.844090f, 1.843780f, 3.672677f,
0.901869f, 1.473358f, 0.021359f, 2.984075f, 2.743363f, 8.696243f, 4.316809f, 9.783213f, 1.083423f, 2.915835f, 1.185260f, 7.161545f, 3.418819f, 11.245360f, 4.647912f, 11.477460f,
0.244000f, 0.403500f, 0.004992f, 0.913016f, 0.229500f, 0.736410f, 0.311951f, 0.925556f, 0.006490f, 0.017680f, 0.006133f, 0.048513f, 0.577284f, 1.922098f, 0.677946f, 2.191703f,
0.589260f, 1.158626f, 0.009874f, 2.408598f, 0.785068f, 2.995209f, 0.874024f, 3.458570f, 0.593380f, 1.922073f, 0.459288f, 4.845439f, 1.622354f, 6.422654f, 1.560501f, 6.728320f,
0.158329f, 0.365516f, 0.004914f, 0.786215f, 0.208591f, 0.934387f, 0.430162f, 1.116375f, 0.118847f, 0.451995f, 0.170396f, 1.178993f, 0.569890f, 2.648930f, 1.015382f, 2.871286f,
0.771682f, 1.386885f, 0.016068f, 3.186829f, 1.597811f, 5.572000f, 2.210477f, 7.111771f, 1.013160f, 2.999720f, 0.974484f, 8.358749f, 2.647781f, 9.581130f, 3.164791f, 11.094460f,
0.464705f, 0.637574f, 0.009732f, 1.492953f, 0.603533f, 1.606712f, 0.839751f, 2.089787f, 0.011126f, 0.025147f, 0.010763f, 0.071407f, 1.230485f, 3.399085f, 1.479205f, 4.010964f,
1.136418f, 1.853848f, 0.019492f, 3.988188f, 2.090592f, 6.617425f, 2.382492f, 7.907496f, 1.030092f, 2.768295f, 0.816158f, 7.221979f, 3.501674f, 11.501230f, 3.447785f, 12.468580f,
0.395786f, 0.758065f, 0.012575f, 1.687414f, 0.719993f, 2.675827f, 1.519883f, 3.308429f, 0.267423f, 0.843812f, 0.392480f, 2.277738f, 1.594376f, 6.148508f, 2.907872f, 6.896939f,
0.895543f, 1.335328f, 0.019088f, 3.175316f, 2.560380f, 7.407813f, 3.625861f, 9.784469f, 1.058371f, 2.599802f, 1.042031f, 7.496895f, 3.438976f, 10.324370f, 4.207636f, 12.371820f,
0.027051f, 0.041678f, 0.000703f, 0.111610f, 0.044949f, 0.134375f, 0.077577f, 0.199880f, 0.000600f, 0.001524f, 0.000720f, 0.004948f, 0.106251f, 0.329596f, 0.158435f, 0.444790f,
0.072011f, 0.131915f, 0.001532f, 0.324550f, 0.169487f, 0.602446f, 0.239588f, 0.823293f, 0.060505f, 0.182594f, 0.059464f, 0.544775f, 0.329141f, 1.213983f, 0.401987f, 1.505122f,
0.001132f, 0.002435f, 0.000045f, 0.006198f, 0.002635f, 0.010995f, 0.006899f, 0.015547f, 0.000709f, 0.002512f, 0.001291f, 0.007755f, 0.006764f, 0.029293f, 0.015303f, 0.037578f,
0.059036f, 0.098851f, 0.001561f, 0.268823f, 0.215946f, 0.701605f, 0.379330f, 1.059806f, 0.064673f, 0.178397f, 0.078983f, 0.588324f, 0.336286f, 1.133719f, 0.510368f, 1.553682f,
0.033782f, 0.050231f, 0.000874f, 0.110836f, 0.069504f, 0.200533f, 0.119459f, 0.245777f, 0.001077f, 0.002637f, 0.001286f, 0.007057f, 0.172235f, 0.515637f, 0.255759f, 0.573352f,
0.112914f, 0.199628f, 0.002392f, 0.404683f, 0.329068f, 1.128867f, 0.463240f, 1.271110f, 0.136240f, 0.396807f, 0.133341f, 0.975471f, 0.669924f, 2.384690f, 0.814794f, 2.436100f,
0.021020f, 0.043634f, 0.000825f, 0.091523f, 0.060578f, 0.243996f, 0.157963f, 0.284274f, 0.018906f, 0.064652f, 0.034275f, 0.164450f, 0.163047f, 0.681442f, 0.367329f, 0.720288f,
0.088752f, 0.143422f, 0.002337f, 0.321370f, 0.401975f, 1.260442f, 0.703177f, 1.568775f, 0.139620f, 0.371695f, 0.169804f, 1.009994f, 0.656233f, 2.135159f, 0.991803f, 2.410965f,
0.003215f, 0.005258f, 0.000073f, 0.013164f, 0.004502f, 0.014289f, 0.006803f, 0.019869f, 0.000112f, 0.000302f, 0.000118f, 0.000916f, 0.014834f, 0.048858f, 0.019367f, 0.061635f,
0.011107f, 0.021603f, 0.000207f, 0.049684f, 0.022033f, 0.083153f, 0.027270f, 0.106227f, 0.014647f, 0.046930f, 0.012603f, 0.130889f, 0.059647f, 0.233577f, 0.063781f, 0.270713f,
0.002209f, 0.005045f, 0.000076f, 0.012006f, 0.004334f, 0.019203f, 0.009935f, 0.025382f, 0.002172f, 0.008170f, 0.003461f, 0.023576f, 0.015510f, 0.071314f, 0.030721f, 0.085520f,
0.011533f, 0.020503f, 0.000267f, 0.052122f, 0.035556f, 0.122650f, 0.054683f, 0.173190f, 0.019829f, 0.058073f, 0.021202f, 0.179028f, 0.077185f, 0.276274f, 0.102560f, 0.353930f,
0.053006f, 0.071937f, 0.001234f, 0.186360f, 0.102501f, 0.269924f, 0.158549f, 0.388412f, 0.001662f, 0.003716f, 0.001787f, 0.011673f, 0.273760f, 0.748050f, 0.365854f, 0.976575f,
0.185456f, 0.299262f, 0.003536f, 0.712265f, 0.507991f, 1.590563f, 0.643582f, 2.102756f, 0.220138f, 0.585203f, 0.193901f, 1.689035f, 1.114624f, 3.621362f, 1.220052f, 4.343428f,
0.047813f, 0.090588f, 0.001689f, 0.223087f, 0.129509f, 0.476109f, 0.303927f, 0.651266f, 0.042306f, 0.132047f, 0.069025f, 0.394342f, 0.375690f, 1.433125f, 0.761728f, 1.778519f,
0.115877f, 0.170913f, 0.002746f, 0.449636f, 0.493287f, 1.411758f, 0.776590f, 2.062982f, 0.179335f, 0.435756f, 0.196288f, 1.390184f, 0.867941f, 2.577505f, 1.180551f, 3.417099f,
0.059203f, 0.172150f, 0.001976f, 0.275819f, 0.077239f, 0.435794f, 0.171299f, 0.387836f, 0.001086f, 0.005204f, 0.001675f, 0.010110f, 0.172866f, 1.012057f, 0.331232f, 0.817137f,
0.162810f, 0.562895f, 0.004451f, 0.828576f, 0.300872f, 2.018416f, 0.546530f, 1.650303f, 0.113102f, 0.644193f, 0.142836f, 1.149908f, 0.553207f, 3.850932f, 0.868205f, 2.856548f,
0.003094f, 0.012560f, 0.000157f, 0.019130f, 0.005654f, 0.044536f, 0.019025f, 0.037677f, 0.001602f, 0.010715f, 0.003748f, 0.019790f, 0.013745f, 0.112337f, 0.039957f, 0.086221f,
0.116972f, 0.369653f, 0.003974f, 0.601446f, 0.335946f, 2.059988f, 0.758310f, 1.861722f, 0.105946f, 0.551566f, 0.166264f, 1.088282f, 0.495329f, 3.151651f, 0.965992f, 2.584111f,
0.097535f, 0.273716f, 0.003242f, 0.361346f, 0.157561f, 0.857970f, 0.347986f, 0.629134f, 0.002570f, 0.011881f, 0.003946f, 0.019021f, 0.369674f, 2.088768f, 0.705398f, 1.389582f,
0.336789f, 1.123775f, 0.009169f, 1.362975f, 0.770643f, 4.989518f, 1.394051f, 3.361365f, 0.335977f, 1.846852f, 0.422544f, 2.716334f, 1.485436f, 9.979487f, 2.321570f, 6.099414f,
0.075799f, 0.296958f, 0.003823f, 0.372664f, 0.171512f, 1.303799f, 0.574699f, 0.908828f, 0.056366f, 0.363788f, 0.131310f, 0.553622f, 0.437071f, 3.447598f, 1.265318f, 2.180271f,
0.231987f, 0.707542f, 0.007849f, 0.948545f, 0.824986f, 4.882228f, 1.854458f, 3.635570f, 0.301738f, 1.516068f, 0.471560f, 2.464716f, 1.275163f, 7.830437f, 2.476500f, 5.290092f,
0.057937f, 0.178869f, 0.001693f, 0.267901f, 0.063708f, 0.381640f, 0.123705f, 0.317498f, 0.001668f, 0.008486f, 0.002252f, 0.015412f, 0.198759f, 1.235480f, 0.333444f, 0.932495f,
0.206807f, 0.759143f, 0.004950f, 1.044598f, 0.322112f, 2.294300f, 0.512288f, 1.753574f, 0.225477f, 1.363522f, 0.249313f, 2.275254f, 0.825604f, 6.101882f, 1.134438f, 4.231171f,
0.049730f, 0.214331f, 0.002205f, 0.305158f, 0.076594f, 0.640542f, 0.225643f, 0.506566f, 0.040416f, 0.286962f, 0.082778f, 0.495457f, 0.259547f, 2.252257f, 0.660609f, 1.615953f,
0.188184f, 0.631406f, 0.005598f, 0.960354f, 0.455526f, 2.965664f, 0.900253f, 2.505493f, 0.267507f, 1.478634f, 0.367555f, 2.727256f, 0.936259f, 6.324903f, 1.598637f, 4.847836f,
0.116519f, 0.298452f, 0.003486f, 0.462588f, 0.176915f, 0.879274f, 0.351645f, 0.756995f, 0.003020f, 0.012745f, 0.004174f, 0.023955f, 0.447369f, 2.307143f, 0.768260f, 1.802046f,
0.421160f, 1.282645f, 0.010320f, 1.826471f, 0.905778f, 5.352594f, 1.474600f, 4.233688f, 0.413330f, 2.073752f, 0.467828f, 3.581008f, 1.881717f, 11.538410f, 2.646729f, 8.279866f,
0.131271f, 0.469394f, 0.005958f, 0.691603f, 0.279176f, 1.937009f, 0.841882f, 1.585258f, 0.096033f, 0.565703f, 0.201339f, 1.010767f, 0.766775f, 5.520387f, 1.997757f, 4.098838f,
0.230613f, 0.641961f, 0.007022f, 1.010443f, 0.770805f, 4.163448f, 1.559344f, 3.640030f, 0.295085f, 1.353233f, 0.415031f, 2.582964f, 1.284091f, 7.197025f, 2.244374f, 5.708574f,
0.017297f, 0.045611f, 0.000550f, 0.108012f, 0.030235f, 0.154702f, 0.063830f, 0.203491f, 0.000318f, 0.001380f, 0.000466f, 0.003963f, 0.054007f, 0.286733f, 0.098506f, 0.342177f,
0.051652f, 0.161946f, 0.001344f, 0.352337f, 0.127891f, 0.778045f, 0.221139f, 0.940244f, 0.035916f, 0.185512f, 0.043177f, 0.489443f, 0.187674f, 1.184727f, 0.280370f, 1.298904f,
0.000860f, 0.003164f, 0.000041f, 0.007123f, 0.002105f, 0.015033f, 0.006741f, 0.018798f, 0.000446f, 0.002702f, 0.000992f, 0.007376f, 0.004083f, 0.030264f, 0.011299f, 0.034332f,
0.041408f, 0.118668f, 0.001339f, 0.285376f, 0.159339f, 0.886041f, 0.342368f, 1.183551f, 0.037540f, 0.177234f, 0.056080f, 0.516863f, 0.187502f, 1.081897f, 0.348080f, 1.311118f,
0.033622f, 0.085565f, 0.001064f, 0.166957f, 0.072771f, 0.359352f, 0.152992f, 0.389470f, 0.000887f, 0.003718f, 0.001296f, 0.008797f, 0.136267f, 0.698228f, 0.247513f, 0.686554f,
0.126066f, 0.381466f, 0.003267f, 0.683830f, 0.386495f, 2.269271f, 0.665524f, 2.259574f, 0.125882f, 0.627512f, 0.150702f, 1.364130f, 0.594571f, 3.622386f, 0.884556f, 3.272334f,
0.024846f, 0.088271f, 0.001193f, 0.163728f, 0.075324f, 0.519261f, 0.240255f, 0.534982f, 0.018493f, 0.108239f, 0.041010f, 0.243463f, 0.153196f, 1.095847f, 0.422173f, 1.024299f,
0.096895f, 0.267993f, 0.003121f, 0.531023f, 0.461672f, 2.477658f, 0.987864f, 2.726960f, 0.126148f, 0.574783f, 0.187663f, 1.381131f, 0.569523f, 3.171523f, 1.052876f, 3.166854f,
0.019481f, 0.054540f, 0.000542f, 0.120737f, 0.028701f, 0.155915f, 0.053049f, 0.191716f, 0.000562f, 0.002590f, 0.000722f, 0.006953f, 0.071463f, 0.402836f, 0.114123f, 0.449389f,
0.075507f, 0.251354f, 0.001720f, 0.511204f, 0.157574f, 1.017802f, 0.238553f, 1.149794f, 0.082403f, 0.451894f, 0.086732f, 1.114520f, 0.322335f, 2.160407f, 0.421609f, 2.214192f,
0.015900f, 0.062143f, 0.000671f, 0.130772f, 0.032811f, 0.248833f, 0.092011f, 0.290856f, 0.012934f, 0.083281f, 0.025217f, 0.212525f, 0.088736f, 0.698291f, 0.214991f, 0.740509f,
0.076666f, 0.233274f, 0.002171f, 0.524411f, 0.248648f, 1.468014f, 0.467767f, 1.833093f, 0.109086f, 0.546803f, 0.142676f, 1.490662f, 0.407875f, 2.498739f, 0.662940f, 2.830727f,
0.052326f, 0.121542f, 0.001490f, 0.278439f, 0.106446f, 0.479764f, 0.201403f, 0.610491f, 0.001358f, 0.005195f, 0.001786f, 0.014433f, 0.214828f, 1.004700f, 0.351178f, 1.159874f,
0.205373f, 0.567203f, 0.004790f, 1.193788f, 0.591790f, 3.171369f, 0.917095f, 3.707527f, 0.201746f, 0.917912f, 0.217364f, 2.342786f, 0.981203f, 5.456160f, 1.313735f, 5.786919f,
0.056054f, 0.181767f, 0.002422f, 0.395839f, 0.159724f, 1.004988f, 0.458498f, 1.215660f, 0.041046f, 0.219270f, 0.081917f, 0.579062f, 0.350122f, 2.285902f, 0.868336f, 2.508602f,
0.125480f, 0.316764f, 0.003637f, 0.736923f, 0.561935f, 2.752523f, 1.082124f, 3.556852f, 0.160713f, 0.668363f, 0.215168f, 1.885563f, 0.747129f, 3.797427f, 1.243051f, 4.451917f,
0.091829f, 0.143027f, 0.002146f, 0.346204f, 0.134780f, 0.407334f, 0.209246f, 0.547662f, 0.001696f, 0.004352f, 0.001831f, 0.012775f, 0.211414f, 0.662988f, 0.283573f, 0.808706f,
0.280958f, 0.520312f, 0.005377f, 1.157081f, 0.584114f, 2.098959f, 0.742745f, 2.592701f, 0.196483f, 0.599445f, 0.173702f, 1.616558f, 0.752723f, 2.806664f, 0.826951f, 3.145296f,
0.004562f, 0.009920f, 0.000162f, 0.022825f, 0.009379f, 0.039571f, 0.022091f, 0.050575f, 0.002378f, 0.008519f, 0.003894f, 0.023771f, 0.015979f, 0.069955f, 0.032518f, 0.081116f,
0.233001f, 0.394408f, 0.005541f, 0.969490f, 0.752837f, 2.472709f, 1.189563f, 3.376127f, 0.212450f, 0.592441f, 0.233388f, 1.765975f, 0.777959f, 2.651415f, 1.062052f, 3.284326f,
0.167211f, 0.251352f, 0.003891f, 0.501302f, 0.303886f, 0.886360f, 0.469822f, 0.981921f, 0.004435f, 0.010984f, 0.004767f, 0.026565f, 0.499702f, 1.512376f, 0.667477f, 1.520019f,
0.642371f, 1.148113f, 0.012243f, 2.103725f, 1.653630f, 5.734835f, 2.093984f, 5.836782f, 0.645111f, 1.899476f, 0.567944f, 4.220659f, 2.233935f, 8.038998f, 2.444037f, 7.422961f,
0.123527f, 0.259222f, 0.004361f, 0.491462f, 0.314450f, 1.280397f, 0.737576f, 1.348376f, 0.092472f, 0.319685f, 0.150801f, 0.734992f, 0.561617f, 2.372914f, 1.138145f, 2.267102f,
0.510749f, 0.834396f, 0.012096f, 1.689950f, 2.043371f, 6.477323f, 3.215339f, 7.286943f, 0.668760f, 1.799846f, 0.731621f, 4.420579f, 2.213592f, 7.281063f, 3.009396f, 7.431344f,
0.100959f, 0.166954f, 0.002065f, 0.377773f, 0.124892f, 0.400749f, 0.169761f, 0.503681f, 0.002927f, 0.007973f, 0.002766f, 0.021879f, 0.273086f, 0.909255f, 0.320705f, 1.036793f,
0.400935f, 0.788333f, 0.006718f, 1.638818f, 0.702543f, 2.680360f, 0.782149f, 3.095014f, 0.440056f, 1.425425f, 0.340612f, 3.593418f, 1.262029f, 4.996181f, 1.213913f, 5.233959f,
0.082375f, 0.190170f, 0.002557f, 0.409051f, 0.142736f, 0.639385f, 0.294353f, 0.763916f, 0.067396f, 0.256318f, 0.096628f, 0.668583f, 0.338988f, 1.575665f, 0.603981f, 1.707930f,
0.421122f, 0.756850f, 0.008769f, 1.739114f, 1.146817f, 3.999264f, 1.586554f, 5.104424f, 0.602637f, 1.784260f, 0.579632f, 4.971859f, 1.651995f, 5.977826f, 1.974566f, 6.922019f,
0.197583f, 0.271083f, 0.004138f, 0.634772f, 0.337499f, 0.898481f, 0.469593f, 1.168619f, 0.005156f, 0.011654f, 0.004988f, 0.033092f, 0.598143f, 1.652306f, 0.719046f, 1.949743f,
0.794552f, 1.296160f, 0.013628f, 2.788432f, 1.922443f, 6.085177f, 2.190865f, 7.271485f, 0.784998f, 2.109624f, 0.621966f, 5.503626f, 2.799094f, 9.193611f, 2.756018f, 9.966871f,
0.211599f, 0.405285f, 0.006723f, 0.902144f, 0.506270f, 1.881534f, 1.068720f, 2.326354f, 0.155834f, 0.491709f, 0.228707f, 1.327291f, 0.974546f, 3.758213f, 1.777407f, 4.215683f,
0.502197f, 0.748817f, 0.010704f, 1.780633f, 1.888389f, 5.463577f, 2.674227f, 7.216462f, 0.646895f, 1.589044f, 0.636907f, 4.582231f, 2.204824f, 6.619242f, 2.697633f, 7.931919f,
0.101998f, 0.157147f, 0.002650f, 0.420830f, 0.119811f, 0.358175f, 0.206782f, 0.532778f, 0.002228f, 0.005656f, 0.002674f, 0.018367f, 0.258817f, 0.802862f, 0.385932f, 1.083463f,
0.186183f, 0.341066f, 0.003961f, 0.839124f, 0.309781f, 1.101124f, 0.437908f, 1.504779f, 0.153994f, 0.464731f, 0.151345f, 1.386539f, 0.549772f, 2.027744f, 0.671448f, 2.514040f,
0.004030f, 0.008667f, 0.000159f, 0.022064f, 0.006630f, 0.027671f, 0.017361f, 0.039127f, 0.002485f, 0.008804f, 0.004523f, 0.027177f, 0.015557f, 0.067369f, 0.035194f, 0.086424f,
0.156116f, 0.261403f, 0.004127f, 0.710878f, 0.403690f, 1.311582f, 0.709121f, 1.981203f, 0.168354f, 0.464395f, 0.205604f, 1.531494f, 0.574506f, 1.936825f, 0.871904f, 2.654280f,
0.118357f, 0.175989f, 0.003062f, 0.388321f, 0.172146f, 0.496674f, 0.295873f, 0.608732f, 0.003713f, 0.009096f, 0.004437f, 0.024338f, 0.389841f, 1.167109f, 0.578893f, 1.297743f,
0.271270f, 0.479596f, 0.005748f, 0.972226f, 0.558871f, 1.917210f, 0.786742f, 2.158789f, 0.322202f, 0.938433f, 0.315345f, 2.306947f, 1.039763f, 3.701186f, 1.264612f, 3.780979f,
0.069534f, 0.144338f, 0.002729f, 0.302751f, 0.141659f, 0.570573f, 0.369389f, 0.664761f, 0.061564f, 0.210528f, 0.111610f, 0.535498f, 0.348435f, 1.456260f, 0.784991f, 1.539275f,
0.218079f, 0.352414f, 0.005742f, 0.789664f, 0.698250f, 2.189446f, 1.221450f, 2.725034f, 0.337718f, 0.899072f, 0.410729f, 2.443016f, 1.041721f, 3.389407f, 1.574413f, 3.827228f,
0.007064f, 0.011555f, 0.000161f, 0.028926f, 0.006993f, 0.022197f, 0.010568f, 0.030866f, 0.000242f, 0.000653f, 0.000254f, 0.001981f, 0.021059f, 0.069360f, 0.027494f, 0.087499f,
0.016736f, 0.032551f, 0.000312f, 0.074865f, 0.023470f, 0.088575f, 0.029048f, 0.113154f, 0.021726f, 0.069612f, 0.018694f, 0.194148f, 0.058063f, 0.227377f, 0.062088f, 0.263528f,
0.004584f, 0.010467f, 0.000158f, 0.024908f, 0.006356f, 0.028164f, 0.014572f, 0.037228f, 0.004435f, 0.016685f, 0.007069f, 0.048150f, 0.020789f, 0.095585f, 0.041177f, 0.114626f,
0.017774f, 0.031598f, 0.000411f, 0.080328f, 0.038737f, 0.133625f, 0.059576f, 0.188687f, 0.030082f, 0.088102f, 0.032166f, 0.271603f, 0.076848f, 0.275069f, 0.102113f, 0.352386f,
0.195101f, 0.264781f, 0.004542f, 0.685947f, 0.266711f, 0.702348f, 0.412549f, 1.010659f, 0.006021f, 0.013463f, 0.006475f, 0.042294f, 0.650974f, 1.778789f, 0.869964f, 2.322198f,
0.468080f, 0.755320f, 0.008925f, 1.797715f, 0.906378f, 2.837946f, 1.148304f, 3.751820f, 0.546947f, 1.453974f, 0.481758f, 4.196512f, 1.817455f, 5.904830f, 1.989361f, 7.082198f,
0.166161f, 0.314812f, 0.005869f, 0.775273f, 0.318167f, 1.169664f, 0.746661f, 1.599974f, 0.144729f, 0.451729f, 0.236135f, 1.349037f, 0.843464f, 3.217515f, 1.710159f, 3.992962f,
0.299131f, 0.441203f, 0.007088f, 1.160713f, 0.900196f, 2.576308f, 1.417194f, 3.764724f, 0.455722f, 1.107330f, 0.498802f, 3.532697f, 1.447471f, 4.298524f, 1.968813f, 5.698721f,
0.248539f, 0.722697f, 0.008296f, 1.157911f, 0.229224f, 1.293321f, 0.508370f, 1.150995f, 0.004489f, 0.021505f, 0.006922f, 0.041782f, 0.468832f, 2.744811f, 0.898337f, 2.216165f,
0.468678f, 1.620392f, 0.012814f, 2.385199f, 0.612277f, 4.107500f, 1.112194f, 3.358385f, 0.320504f, 1.825490f, 0.404764f, 3.258565f, 1.028813f, 7.161679f, 1.614624f, 5.312397f,
0.012264f, 0.049783f, 0.000621f, 0.075823f, 0.015843f, 0.124790f, 0.053308f, 0.105571f, 0.006252f, 0.041807f, 0.014624f, 0.077216f, 0.035195f, 0.287656f, 0.102315f, 0.220782f,
0.344398f, 1.088357f, 0.011700f, 1.770816f, 0.699231f, 4.287616f, 1.578330f, 3.874950f, 0.307067f, 1.598618f, 0.481888f, 3.154198f, 0.942166f, 5.994754f, 1.837413f, 4.915236f,
0.380470f, 1.067726f, 0.012647f, 1.409556f, 0.434493f, 2.365950f, 0.959613f, 1.734909f, 0.009869f, 0.045625f, 0.015153f, 0.073040f, 0.931611f, 5.263882f, 1.777665f, 3.501870f,
0.900863f, 3.005941f, 0.024527f, 3.645769f, 1.457231f, 9.434829f, 2.636053f, 6.356106f, 0.884671f, 4.862997f, 1.112611f, 7.152453f, 2.566915f, 17.245110f, 4.011801f, 10.540130f,
0.279167f, 1.093697f, 0.014079f, 1.372523f, 0.446551f, 3.394589f, 1.496294f, 2.366237f, 0.204357f, 1.318930f, 0.476070f, 2.007182f, 1.039946f, 8.203052f, 3.010638f, 5.187633f,
0.634673f, 1.935697f, 0.021472f, 2.595037f, 1.595536f, 9.442302f, 3.586548f, 7.031247f, 0.812619f, 4.082957f, 1.269969f, 6.637784f, 2.253761f, 13.839740f, 4.377037f, 9.349862f,
0.141751f, 0.437624f, 0.004143f, 0.655452f, 0.110188f, 0.660077f, 0.213958f, 0.549139f, 0.004018f, 0.020437f, 0.005425f, 0.037120f, 0.314159f, 1.952805f, 0.527043f, 1.473906f,
0.346955f, 1.273597f, 0.008305f, 1.752499f, 0.382023f, 2.721027f, 0.607570f, 2.079730f, 0.372376f, 2.251859f, 0.411741f, 3.757587f, 0.894822f, 6.613461f, 1.229549f, 4.585910f,
0.114875f, 0.495102f, 0.005093f, 0.704910f, 0.125077f, 1.046000f, 0.368472f, 0.827218f, 0.091904f, 0.652536f, 0.188234f, 1.126643f, 0.387331f, 3.361121f, 0.985850f, 2.411541f,
0.322906f, 1.083431f, 0.009605f, 1.647875f, 0.552561f, 3.597402f, 1.092022f, 3.039207f, 0.451854f, 2.497608f, 0.620849f, 4.606694f, 1.037876f, 7.011374f, 1.772144f, 5.373994f,
0.477511f, 1.223094f, 0.014285f, 1.895746f, 0.512536f, 2.547325f, 1.018743f, 2.193072f, 0.012185f, 0.051416f, 0.016838f, 0.096640f, 1.184426f, 6.108250f, 2.033999f, 4.770986f,
1.183519f, 3.604410f, 0.028999f, 5.132634f, 1.799382f, 10.633250f, 2.929383f, 8.410478f, 1.143393f, 5.736607f, 1.294150f, 9.906118f, 3.416162f, 20.947390f, 4.805001f, 15.031670f,
0.507921f, 1.816209f, 0.023053f, 2.675998f, 0.763627f, 5.298275f, 2.302789f, 4.336136f, 0.365779f, 2.154706f, 0.766879f, 3.849908f, 1.916694f, 13.799230f, 4.993762f, 10.245800f,
0.662820f, 1.845102f, 0.020182f, 2.904182f, 1.566141f, 8.459394f, 3.168313f, 7.395901f, 0.834891f, 3.828733f, 1.174257f, 7.308038f, 2.384317f, 13.363530f, 4.167384f, 10.599760f,
0.113339f, 0.298867f, 0.003601f, 0.707749f, 0.140054f, 0.716603f, 0.295671f, 0.942602f, 0.002049f, 0.008902f, 0.003008f, 0.025563f, 0.228619f, 1.213789f, 0.416992f, 1.448491f,
0.232080f, 0.727646f, 0.006040f, 1.583099f, 0.406222f, 2.471319f, 0.702408f, 2.986516f, 0.158858f, 0.820527f, 0.190973f, 2.164824f, 0.544766f, 3.438942f, 0.813839f, 3.770366f,
0.005318f, 0.019576f, 0.000256f, 0.044069f, 0.009205f, 0.065747f, 0.029481f, 0.082211f, 0.002713f, 0.016455f, 0.006042f, 0.044921f, 0.016319f, 0.120957f, 0.045160f, 0.137215f,
0.190291f, 0.545340f, 0.006154f, 1.311451f, 0.517644f, 2.878475f, 1.112248f, 3.844995f, 0.169826f, 0.801776f, 0.253695f, 2.338193f, 0.556668f, 3.212009f, 1.033402f, 3.892537f,
0.204710f, 0.520973f, 0.006477f, 1.016531f, 0.313222f, 1.546720f, 0.658505f, 1.676355f, 0.005315f, 0.022283f, 0.007768f, 0.052725f, 0.535998f, 2.746446f, 0.973581f, 2.700523f,
0.526328f, 1.592630f, 0.013641f, 2.855003f, 1.140716f, 6.697604f, 1.964250f, 6.668982f, 0.517359f, 2.579000f, 0.619367f, 5.606415f, 1.603685f, 9.770345f, 2.385836f, 8.826180f,
0.142827f, 0.507432f, 0.006857f, 0.941204f, 0.306103f, 2.110180f, 0.976352f, 2.174070f, 0.104652f, 0.612514f, 0.232072f, 1.377729f, 0.568938f, 4.069737f, 1.567858f, 3.804023f,
0.413755f, 1.144372f, 0.013325f, 2.267547f, 1.393641f, 7.479260f, 2.982048f, 8.231824f, 0.530265f, 2.416114f, 0.788847f, 5.805621f, 1.571125f, 8.749180f, 2.904537f, 8.736301f,
0.074392f, 0.208277f, 0.002070f, 0.461067f, 0.077480f, 0.420907f, 0.143211f, 0.517555f, 0.002111f, 0.009736f, 0.002713f, 0.026136f, 0.176305f, 0.993823f, 0.281549f, 1.108671f,
0.197722f, 0.658191f, 0.004505f, 1.338629f, 0.291692f, 1.884098f, 0.441595f, 2.128435f, 0.212411f, 1.164860f, 0.223570f, 2.872926f, 0.545293f, 3.654753f, 0.713234f, 3.745741f,
0.057326f, 0.224058f, 0.002420f, 0.471502f, 0.083629f, 0.634234f, 0.234520f, 0.741345f, 0.045907f, 0.295586f, 0.089502f, 0.754308f, 0.206691f, 1.626523f, 0.500777f, 1.724860f,
0.205331f, 0.624764f, 0.005814f, 1.404502f, 0.470771f, 2.779425f, 0.885635f, 3.470637f, 0.287601f, 1.441624f, 0.376159f, 3.930069f, 0.705722f, 4.323423f, 1.147046f, 4.897842f,
0.334701f, 0.777445f, 0.009531f, 1.781037f, 0.481336f, 2.169427f, 0.910715f, 2.760556f, 0.008549f, 0.032713f, 0.011245f, 0.090879f, 0.887751f, 4.151799f, 1.451200f, 4.793035f,
0.900798f, 2.487844f, 0.021010f, 5.236153f, 1.834961f, 9.833456f, 2.843632f, 11.495920f, 0.871086f, 3.963300f, 0.938520f, 10.115520f, 2.780357f, 15.460680f, 3.722625f, 16.397930f,
0.338529f, 1.097745f, 0.014626f, 2.390588f, 0.681917f, 4.290633f, 1.957484f, 5.190065f, 0.244023f, 1.303577f, 0.487004f, 3.442564f, 1.366035f, 8.918672f, 3.387899f, 9.787559f,
0.562916f, 1.421035f, 0.016315f, 3.305911f, 1.782090f, 8.729203f, 3.431789f, 11.280010f, 0.709726f, 2.951564f, 0.950206f, 8.326855f, 2.165317f, 11.005640f, 3.602590f, 12.902470f,
0.315911f, 0.492045f, 0.007382f, 1.191019f, 0.327784f, 0.990630f, 0.508882f, 1.331906f, 0.005744f, 0.014739f, 0.006200f, 0.043265f, 0.469869f, 1.473495f, 0.630243f, 1.797355f,
0.662780f, 1.227417f, 0.012684f, 2.729557f, 0.974093f, 3.500311f, 1.238632f, 4.323694f, 0.456273f, 1.392028f, 0.403369f, 3.753965f, 1.147149f, 4.277354f, 1.260272f, 4.793429f,
0.014818f, 0.032220f, 0.000525f, 0.074138f, 0.021536f, 0.090862f, 0.050725f, 0.116129f, 0.007604f, 0.027239f, 0.012452f, 0.076005f, 0.033530f, 0.146793f, 0.068234f, 0.170212f,
0.562173f, 0.951609f, 0.013370f, 2.339139f, 1.284068f, 4.217548f, 2.028964f, 5.758451f, 0.504591f, 1.407111f, 0.554322f, 4.194381f, 1.212623f, 4.132823f, 1.655445f, 5.119355f,
0.534516f, 0.803483f, 0.012438f, 1.602488f, 0.686720f, 2.002994f, 1.061701f, 2.218943f, 0.013957f, 0.034563f, 0.015002f, 0.083593f, 1.031960f, 3.123284f, 1.378440f, 3.139069f,
1.408065f, 2.516644f, 0.026836f, 4.611326f, 2.562416f, 8.886530f, 3.244775f, 9.044503f, 1.392009f, 4.098657f, 1.225500f, 9.107265f, 3.163471f, 11.384010f, 3.460997f, 10.511640f,
0.372821f, 0.782366f, 0.013162f, 1.483296f, 0.670910f, 2.731851f, 1.573690f, 2.876891f, 0.274740f, 0.949797f, 0.448035f, 2.183691f, 1.095052f, 4.626756f, 2.219177f, 4.420442f,
1.145062f, 1.870655f, 0.027119f, 3.788743f, 3.238492f, 10.265760f, 5.095917f, 11.548910f, 1.475918f, 3.972166f, 1.614648f, 9.755985f, 3.206087f, 10.545630f, 4.358702f, 10.763290f,
0.202416f, 0.334733f, 0.004141f, 0.757415f, 0.177016f, 0.568001f, 0.240611f, 0.713892f, 0.005777f, 0.015737f, 0.005459f, 0.043181f, 0.353719f, 1.177728f, 0.415398f, 1.342923f,
0.551211f, 1.083812f, 0.009236f, 2.253072f, 0.682797f, 2.605024f, 0.760165f, 3.008023f, 0.595556f, 1.929121f, 0.460972f, 4.863206f, 1.120908f, 4.437506f, 1.078173f, 4.648695f,
0.155934f, 0.359988f, 0.004840f, 0.774324f, 0.191008f, 0.855623f, 0.393902f, 1.022270f, 0.125588f, 0.477633f, 0.180061f, 1.245867f, 0.414559f, 1.926930f, 0.738627f, 2.088680f,
0.592156f, 1.064237f, 0.012330f, 2.445438f, 1.139980f, 3.975419f, 1.577095f, 5.073990f, 0.834171f, 2.469776f, 0.802327f, 6.882054f, 1.500699f, 5.430357f, 1.793728f, 6.288077f,
0.663545f, 0.910382f, 0.013896f, 2.131764f, 0.801250f, 2.133068f, 1.114853f, 2.774398f, 0.017045f, 0.038526f, 0.016489f, 0.109399f, 1.297726f, 3.584831f, 1.560037f, 4.230146f,
1.829725f, 2.984846f, 0.031384f, 6.421307f, 3.129616f, 9.906284f, 3.566590f, 11.837520f, 1.779519f, 4.782325f, 1.409941f, 12.476220f, 4.164255f, 13.677470f, 4.100169f, 14.827860f,
0.670932f, 1.285065f, 0.021317f, 2.860491f, 1.134804f, 4.217458f, 2.395537f, 5.214523f, 0.486404f, 1.534771f, 0.713863f, 4.142871f, 1.996289f, 7.698433f, 3.640892f, 8.635528f,
1.182827f, 1.763694f, 0.025211f, 4.193938f, 3.144224f, 9.097016f, 4.452666f, 12.015620f, 1.499864f, 3.684293f, 1.476708f, 10.624180f, 3.354887f, 10.071920f, 4.104752f, 12.069310f,
0.021178f, 0.032628f, 0.000550f, 0.087376f, 0.023600f, 0.070552f, 0.040731f, 0.104944f, 0.000347f, 0.000881f, 0.000417f, 0.002861f, 0.062802f, 0.194815f, 0.093646f, 0.262902f,
0.020440f, 0.037443f, 0.000435f, 0.092122f, 0.032264f, 0.114683f, 0.045608f, 0.156724f, 0.012685f, 0.038283f, 0.012467f, 0.114217f, 0.070536f, 0.260161f, 0.086147f, 0.322554f,
0.000745f, 0.001601f, 0.000029f, 0.004076f, 0.001162f, 0.004850f, 0.003043f, 0.006858f, 0.000344f, 0.001220f, 0.000627f, 0.003767f, 0.003359f, 0.014546f, 0.007599f, 0.018660f,
0.037789f, 0.063274f, 0.000999f, 0.172072f, 0.092702f, 0.301187f, 0.162840f, 0.454957f, 0.030578f, 0.084346f, 0.037343f, 0.278160f, 0.162518f, 0.547897f, 0.246648f, 0.750853f,
0.023057f, 0.034285f, 0.000596f, 0.075649f, 0.031815f, 0.091794f, 0.054682f, 0.112504f, 0.000543f, 0.001330f, 0.000649f, 0.003558f, 0.088756f, 0.265718f, 0.131797f, 0.295459f,
0.027943f, 0.049401f, 0.000592f, 0.100145f, 0.054614f, 0.187353f, 0.076882f, 0.210961f, 0.024903f, 0.072532f, 0.024373f, 0.178306f, 0.125168f, 0.445553f, 0.152235f, 0.455158f,
0.012053f, 0.025020f, 0.000473f, 0.052480f, 0.023296f, 0.093831f, 0.060746f, 0.109321f, 0.008008f, 0.027383f, 0.014517f, 0.069652f, 0.070587f, 0.295014f, 0.159026f, 0.311831f,
0.049529f, 0.080038f, 0.001304f, 0.179343f, 0.150446f, 0.471741f, 0.263176f, 0.587140f, 0.057552f, 0.153215f, 0.069994f, 0.416326f, 0.276495f, 0.899622f, 0.417884f, 1.015830f,
0.002411f, 0.003943f, 0.000055f, 0.009872f, 0.002264f, 0.007187f, 0.003421f, 0.009993f, 0.000062f, 0.000167f, 0.000065f, 0.000507f, 0.008399f, 0.027663f, 0.010965f, 0.034897f,
0.003020f, 0.005874f, 0.000056f, 0.013509f, 0.004018f, 0.015163f, 0.004973f, 0.019370f, 0.002942f, 0.009425f, 0.002531f, 0.026287f, 0.012245f, 0.047950f, 0.013093f, 0.055573f,
0.001392f, 0.003178f, 0.000048f, 0.007564f, 0.001831f, 0.008114f, 0.004198f, 0.010725f, 0.001011f, 0.003802f, 0.001611f, 0.010971f, 0.007378f, 0.033922f, 0.014613f, 0.040679f,
0.007071f, 0.012571f, 0.000164f, 0.031959f, 0.014621f, 0.050436f, 0.022487f, 0.071219f, 0.008980f, 0.026301f, 0.009602f, 0.081082f, 0.035731f, 0.127897f, 0.047479f, 0.163846f,
0.040074f, 0.054387f, 0.000933f, 0.140895f, 0.051972f, 0.136863f, 0.080391f, 0.196941f, 0.000928f, 0.002075f, 0.000998f, 0.006518f, 0.156265f, 0.426996f, 0.208834f, 0.557440f,
0.050836f, 0.082032f, 0.000969f, 0.195243f, 0.093388f, 0.292406f, 0.118315f, 0.386566f, 0.044572f, 0.118488f, 0.039260f, 0.341985f, 0.230681f, 0.749472f, 0.252500f, 0.898910f,
0.030369f, 0.057538f, 0.001073f, 0.141695f, 0.055167f, 0.202810f, 0.129465f, 0.277421f, 0.019848f, 0.061950f, 0.032384f, 0.185007f, 0.180161f, 0.687250f, 0.365284f, 0.852882f,
0.071630f, 0.105650f, 0.001697f, 0.277944f, 0.204502f, 0.585272f, 0.321951f, 0.855250f, 0.081884f, 0.198964f, 0.089624f, 0.634751f, 0.405076f, 1.202946f, 0.550974f, 1.594793f,
0.039850f, 0.115875f, 0.001330f, 0.185656f, 0.034868f, 0.196729f, 0.077329f, 0.175079f, 0.000540f, 0.002587f, 0.000833f, 0.005027f, 0.087851f, 0.514328f, 0.168332f, 0.415269f,
0.039734f, 0.137374f, 0.001086f, 0.202212f, 0.049245f, 0.330360f, 0.089452f, 0.270110f, 0.020388f, 0.116125f, 0.025748f, 0.207288f, 0.101933f, 0.709564f, 0.159974f, 0.526341f,
0.001750f, 0.007103f, 0.000089f, 0.010818f, 0.002144f, 0.016890f, 0.007215f, 0.014289f, 0.000669f, 0.004475f, 0.001566f, 0.008266f, 0.005868f, 0.047962f, 0.017059f, 0.036812f,
0.064376f, 0.203439f, 0.002187f, 0.331006f, 0.123997f, 0.760335f, 0.279890f, 0.687155f, 0.043068f, 0.224218f, 0.067588f, 0.442400f, 0.205818f, 1.309565f, 0.401386f, 1.073742f,
0.057238f, 0.160628f, 0.001903f, 0.212053f, 0.062011f, 0.337672f, 0.136957f, 0.247609f, 0.001114f, 0.005150f, 0.001711f, 0.008245f, 0.163791f, 0.925470f, 0.312540f, 0.615681f,
0.071659f, 0.239107f, 0.001951f, 0.290002f, 0.109968f, 0.711988f, 0.198927f, 0.479656f, 0.052803f, 0.290255f, 0.066408f, 0.426904f, 0.238625f, 1.603139f, 0.372945f, 0.979831f,
0.037370f, 0.146404f, 0.001885f, 0.183729f, 0.056709f, 0.431093f, 0.190021f, 0.300499f, 0.020526f, 0.132478f, 0.047818f, 0.201608f, 0.162690f, 1.283295f, 0.470988f, 0.811559f,
0.111311f, 0.339490f, 0.003766f, 0.455128f, 0.265475f, 1.571068f, 0.596752f, 1.169902f, 0.106940f, 0.537315f, 0.167127f, 0.873529f, 0.461946f, 2.836690f, 0.897148f, 1.916413f,
0.037357f, 0.115331f, 0.001092f, 0.172737f, 0.027549f, 0.165031f, 0.053493f, 0.137295f, 0.000795f, 0.004041f, 0.001073f, 0.007340f, 0.096758f, 0.601446f, 0.162324f, 0.453949f,
0.048347f, 0.177470f, 0.001157f, 0.244203f, 0.050502f, 0.359710f, 0.080319f, 0.274933f, 0.038935f, 0.235450f, 0.043051f, 0.392885f, 0.145722f, 1.076999f, 0.200232f, 0.746814f,
0.026938f, 0.116100f, 0.001194f, 0.165300f, 0.027826f, 0.232701f, 0.081973f, 0.184029f, 0.016171f, 0.114817f, 0.033121f, 0.198239f, 0.106149f, 0.921121f, 0.270174f, 0.660887f,
0.099208f, 0.332869f, 0.002951f, 0.506286f, 0.161057f, 1.048546f, 0.318295f, 0.885847f, 0.104168f, 0.575784f, 0.143127f, 1.062001f, 0.372658f, 2.517494f, 0.636304f, 1.929579f,
0.075742f, 0.194005f, 0.002266f, 0.300700f, 0.077127f, 0.383322f, 0.153301f, 0.330014f, 0.001450f, 0.006119f, 0.002004f, 0.011502f, 0.219561f, 1.132304f, 0.377048f, 0.884412f,
0.099261f, 0.302299f, 0.002432f, 0.430469f, 0.143170f, 0.846048f, 0.233080f, 0.669190f, 0.071955f, 0.361011f, 0.081442f, 0.623404f, 0.334837f, 2.053173f, 0.470965f, 1.473340f,
0.071688f, 0.256338f, 0.003254f, 0.377688f, 0.102248f, 0.709429f, 0.308339f, 0.580600f, 0.038737f, 0.228191f, 0.081215f, 0.407720f, 0.316151f, 2.276124f, 0.823700f, 1.690002f,
0.122568f, 0.341193f, 0.003732f, 0.537037f, 0.274750f, 1.484044f, 0.555822f, 1.297474f, 0.115844f, 0.531251f, 0.162933f, 1.014017f, 0.515274f, 2.887989f, 0.900612f, 2.290710f,
0.004101f, 0.010815f, 0.000130f, 0.025610f, 0.004808f, 0.024600f, 0.010150f, 0.032358f, 0.000056f, 0.000242f, 0.000082f, 0.000694f, 0.009668f, 0.051330f, 0.017634f, 0.061255f,
0.004440f, 0.013922f, 0.000116f, 0.030289f, 0.007373f, 0.044858f, 0.012750f, 0.054209f, 0.002281f, 0.011780f, 0.002742f, 0.031079f, 0.012181f, 0.076895f, 0.018198f, 0.084306f,
0.000171f, 0.000630f, 0.000008f, 0.001419f, 0.000281f, 0.002008f, 0.000901f, 0.002511f, 0.000066f, 0.000398f, 0.000146f, 0.001085f, 0.000614f, 0.004551f, 0.001699f, 0.005163f,
0.008027f, 0.023005f, 0.000260f, 0.055324f, 0.020717f, 0.115199f, 0.044513f, 0.153880f, 0.005376f, 0.025379f, 0.008030f, 0.074012f, 0.027444f, 0.158355f, 0.050948f, 0.191905f,
0.006950f, 0.017688f, 0.000220f, 0.034513f, 0.010089f, 0.049820f, 0.021210f, 0.053995f, 0.000135f, 0.000568f, 0.000198f, 0.001343f, 0.021268f, 0.108975f, 0.038630f, 0.107152f,
0.009449f, 0.028591f, 0.000245f, 0.051253f, 0.019427f, 0.114066f, 0.033453f, 0.113579f, 0.006969f, 0.034740f, 0.008343f, 0.075520f, 0.033645f, 0.204981f, 0.050055f, 0.185172f,
0.004315f, 0.015330f, 0.000207f, 0.028434f, 0.008773f, 0.060479f, 0.027983f, 0.062310f, 0.002372f, 0.013885f, 0.005261f, 0.031231f, 0.020087f, 0.143686f, 0.055355f, 0.134305f,
0.016377f, 0.045296f, 0.000527f, 0.089752f, 0.052332f, 0.280850f, 0.111977f, 0.309109f, 0.015749f, 0.071758f, 0.023429f, 0.172425f, 0.072676f, 0.404715f, 0.134357f, 0.404120f,
0.004425f, 0.012387f, 0.000123f, 0.027422f, 0.004372f, 0.023750f, 0.008081f, 0.029203f, 0.000094f, 0.000434f, 0.000121f, 0.001166f, 0.012255f, 0.069079f, 0.019570f, 0.077062f,
0.006218f, 0.020699f, 0.000142f, 0.042097f, 0.008702f, 0.056211f, 0.013175f, 0.063501f, 0.005012f, 0.027487f, 0.005276f, 0.067792f, 0.020041f, 0.134321f, 0.026213f, 0.137665f,
0.003034f, 0.011858f, 0.000128f, 0.024953f, 0.004199f, 0.031843f, 0.011775f, 0.037221f, 0.001823f, 0.011738f, 0.003554f, 0.029954f, 0.012784f, 0.100598f, 0.030972f, 0.106680f,
0.014237f, 0.043320f, 0.000403f, 0.097385f, 0.030968f, 0.182832f, 0.058257f, 0.228300f, 0.014963f, 0.075004f, 0.019571f, 0.204472f, 0.057187f, 0.350341f, 0.092949f, 0.396888f,
0.011981f, 0.027830f, 0.000341f, 0.063756f, 0.016347f, 0.073676f, 0.030929f, 0.093751f, 0.000230f, 0.000879f, 0.000302f, 0.002441f, 0.037139f, 0.173692f, 0.060712f, 0.200519f,
0.017050f, 0.047089f, 0.000398f, 0.099109f, 0.032950f, 0.176577f, 0.051062f, 0.206429f, 0.012372f, 0.056289f, 0.013329f, 0.143666f, 0.061503f, 0.341997f, 0.082346f, 0.362730f,
0.010783f, 0.034966f, 0.000466f, 0.076147f, 0.020607f, 0.129657f, 0.059152f, 0.156836f, 0.005832f, 0.031156f, 0.011640f, 0.082280f, 0.050851f, 0.332001f, 0.126116f, 0.364346f,
0.023492f, 0.059304f, 0.000681f, 0.137965f, 0.070556f, 0.345605f, 0.135871f, 0.446597f, 0.022225f, 0.092426f, 0.029755f, 0.260750f, 0.105607f, 0.536770f, 0.175706f, 0.629282f,
0.045805f, 0.071343f, 0.001070f, 0.172689f, 0.045088f, 0.136266f, 0.069999f, 0.183210f, 0.000625f, 0.001604f, 0.000675f, 0.004707f, 0.079619f, 0.249684f, 0.106795f, 0.304561f,
0.050812f, 0.094100f, 0.000972f, 0.209261f, 0.070847f, 0.254584f, 0.090088f, 0.314470f, 0.026247f, 0.080077f, 0.023204f, 0.215949f, 0.102780f, 0.383235f, 0.112916f, 0.429474f,
0.001912f, 0.004157f, 0.000068f, 0.009565f, 0.002636f, 0.011121f, 0.006209f, 0.014214f, 0.000736f, 0.002637f, 0.001205f, 0.007358f, 0.005056f, 0.022133f, 0.010288f, 0.025664f,
0.095027f, 0.160855f, 0.002260f, 0.395395f, 0.205916f, 0.676336f, 0.325369f, 0.923438f, 0.064000f, 0.178471f, 0.070307f, 0.531994f, 0.239549f, 0.816424f, 0.327027f, 1.011310f,
0.072717f, 0.109308f, 0.001692f, 0.218007f, 0.088630f, 0.258513f, 0.137027f, 0.286384f, 0.001425f, 0.003528f, 0.001531f, 0.008533f, 0.164071f, 0.496571f, 0.219158f, 0.499080f,
0.101286f, 0.181028f, 0.001930f, 0.331704f, 0.174865f, 0.606435f, 0.221430f, 0.617215f, 0.075133f, 0.221223f, 0.066146f, 0.491560f, 0.265939f, 0.957005f, 0.290951f, 0.883668f,
0.045131f, 0.094707f, 0.001593f, 0.179555f, 0.077048f, 0.313729f, 0.180724f, 0.330385f, 0.024955f, 0.086271f, 0.040696f, 0.198347f, 0.154917f, 0.654547f, 0.313947f, 0.625360f,
0.181607f, 0.296686f, 0.004301f, 0.600895f, 0.487274f, 1.544620f, 0.766748f, 1.737687f, 0.175643f, 0.472710f, 0.192152f, 1.161017f, 0.594255f, 1.954654f, 0.807894f, 1.994998f,
0.048239f, 0.079773f, 0.000987f, 0.180506f, 0.040022f, 0.128420f, 0.054400f, 0.161405f, 0.001033f, 0.002814f, 0.000976f, 0.007722f, 0.098517f, 0.328017f, 0.115695f, 0.374026f,
0.069458f, 0.136572f, 0.001164f, 0.283911f, 0.081625f, 0.311419f, 0.090874f, 0.359596f, 0.056311f, 0.182402f, 0.043586f, 0.459825f, 0.165071f, 0.653490f, 0.158777f, 0.684591f,
0.033067f, 0.076338f, 0.001026f, 0.164201f, 0.038427f, 0.172132f, 0.079244f, 0.205657f, 0.019983f, 0.075999f, 0.028651f, 0.198238f, 0.102738f, 0.477542f, 0.183050f, 0.517628f,
0.164521f, 0.295681f, 0.003426f, 0.679425f, 0.300476f, 1.047840f, 0.415690f, 1.337401f, 0.173902f, 0.514880f, 0.167263f, 1.434720f, 0.487273f, 1.763222f, 0.582419f, 2.041722f,
0.095178f, 0.130584f, 0.001993f, 0.305777f, 0.109034f, 0.290267f, 0.151709f, 0.377539f, 0.001835f, 0.004147f, 0.001775f, 0.011775f, 0.217542f, 0.600936f, 0.261514f, 0.709112f,
0.138772f, 0.226380f, 0.002380f, 0.487011f, 0.225182f, 0.712776f, 0.256623f, 0.851732f, 0.101270f, 0.272156f, 0.080238f, 0.710006f, 0.369102f, 1.212313f, 0.363422f, 1.314279f,
0.085633f, 0.164016f, 0.002721f, 0.365091f, 0.137407f, 0.510668f, 0.290062f, 0.631397f, 0.046582f, 0.146983f, 0.068366f, 0.396759f, 0.297768f, 1.148304f, 0.543078f, 1.288082f,
0.197795f, 0.294929f, 0.004216f, 0.701319f, 0.498809f, 1.443178f, 0.706384f, 1.906194f, 0.188196f, 0.462287f, 0.185290f, 1.333070f, 0.655640f, 1.968339f, 0.802185f, 2.358685f,
0.045023f, 0.069367f, 0.001170f, 0.185761f, 0.056882f, 0.170047f, 0.098172f, 0.252941f, 0.000917f, 0.002327f, 0.001100f, 0.007556f, 0.154678f, 0.479817f, 0.230646f, 0.647513f,
0.040761f, 0.074670f, 0.000867f, 0.183711f, 0.072944f, 0.259282f, 0.103114f, 0.354330f, 0.031422f, 0.094827f, 0.030881f, 0.282920f, 0.162959f, 0.601048f, 0.199025f, 0.745192f,
0.001246f, 0.002680f, 0.000049f, 0.006823f, 0.002205f, 0.009203f, 0.005774f, 0.013012f, 0.000716f, 0.002537f, 0.001303f, 0.007832f, 0.006513f, 0.028203f, 0.014734f, 0.036180f,
0.069740f, 0.116774f, 0.001844f, 0.317564f, 0.193959f, 0.630170f, 0.340708f, 0.951900f, 0.070094f, 0.193351f, 0.085603f, 0.637636f, 0.347470f, 1.171421f, 0.527341f, 1.605349f,
0.061053f, 0.090781f, 0.001579f, 0.200309f, 0.095507f, 0.275555f, 0.164150f, 0.337724f, 0.001785f, 0.004373f, 0.002133f, 0.011701f, 0.272260f, 0.815095f, 0.404292f, 0.906328f,
0.069402f, 0.122701f, 0.001470f, 0.248736f, 0.153783f, 0.527555f, 0.216486f, 0.594030f, 0.076828f, 0.223767f, 0.075193f, 0.550086f, 0.360158f, 1.282033f, 0.438041f, 1.309671f,
0.025125f, 0.052155f, 0.000986f, 0.109396f, 0.055053f, 0.221744f, 0.143557f, 0.258349f, 0.020733f, 0.070900f, 0.037587f, 0.180341f, 0.170460f, 0.712427f, 0.384031f, 0.753039f,
0.113844f, 0.183972f, 0.002997f, 0.412231f, 0.392044f, 1.229302f, 0.685804f, 1.530018f, 0.164314f, 0.437436f, 0.199837f, 1.188628f, 0.736268f, 2.395567f, 1.112765f, 2.705011f,
0.005712f, 0.009344f, 0.000130f, 0.023392f, 0.006083f, 0.019307f, 0.009191f, 0.026846f, 0.000183f, 0.000492f, 0.000192f, 0.001493f, 0.023057f, 0.075940f, 0.030102f, 0.095800f,
0.006713f, 0.013056f, 0.000125f, 0.030027f, 0.010125f, 0.038210f, 0.012531f, 0.048813f, 0.008121f, 0.026022f, 0.006988f, 0.072576f, 0.031530f, 0.123473f, 0.033716f, 0.143104f,
0.002596f, 0.005929f, 0.000090f, 0.014110f, 0.003873f, 0.017160f, 0.008878f, 0.022682f, 0.002342f, 0.008809f, 0.003732f, 0.025422f, 0.015944f, 0.073309f, 0.031581f, 0.087913f,
0.014546f, 0.025860f, 0.000337f, 0.065740f, 0.034097f, 0.117619f, 0.052440f, 0.166086f, 0.022945f, 0.067201f, 0.024535f, 0.207167f, 0.085150f, 0.304784f, 0.113144f, 0.390454f,
0.089949f, 0.122074f, 0.002094f, 0.316248f, 0.132252f, 0.348269f, 0.204568f, 0.501149f, 0.002587f, 0.005785f, 0.002782f, 0.018173f, 0.406337f, 1.110318f, 0.543030f, 1.449513f,
0.107033f, 0.172715f, 0.002041f, 0.411073f, 0.222912f, 0.697956f, 0.282411f, 0.922712f, 0.116564f, 0.309867f, 0.102671f, 0.894350f, 0.562663f, 1.828066f, 0.615883f, 2.192565f,
0.053663f, 0.101670f, 0.001895f, 0.250378f, 0.110516f, 0.406283f, 0.259353f, 0.555751f, 0.043563f, 0.135969f, 0.071076f, 0.406056f, 0.368803f, 1.406851f, 0.747763f, 1.745914f,
0.139568f, 0.205856f, 0.003307f, 0.541564f, 0.451739f, 1.292851f, 0.711181f, 1.889226f, 0.198174f, 0.481530f, 0.216907f, 1.536216f, 0.914368f, 2.715378f, 1.243699f, 3.599883f,
0.139462f, 0.405527f, 0.004655f, 0.649738f, 0.138340f, 0.780540f, 0.306810f, 0.694644f, 0.002348f, 0.011246f, 0.003620f, 0.021851f, 0.356177f, 2.085267f, 0.682478f, 1.683648f,
0.130436f, 0.450967f, 0.003566f, 0.663818f, 0.183273f, 1.229499f, 0.332913f, 1.005266f, 0.083134f, 0.473506f, 0.104990f, 0.845224f, 0.387657f, 2.698520f, 0.608390f, 2.001711f,
0.004821f, 0.019568f, 0.000244f, 0.029804f, 0.006698f, 0.052756f, 0.022536f, 0.044631f, 0.002290f, 0.015316f, 0.005358f, 0.028288f, 0.018730f, 0.153083f, 0.054449f, 0.117494f,
0.195574f, 0.618049f, 0.006644f, 1.005598f, 0.427069f, 2.618743f, 0.963995f, 2.366700f, 0.162519f, 0.846091f, 0.255046f, 1.669403f, 0.724377f, 4.609021f, 1.412681f, 3.779042f,
0.249486f, 0.700140f, 0.008293f, 0.924288f, 0.306432f, 1.668617f, 0.676779f, 1.223567f, 0.006031f, 0.027883f, 0.009261f, 0.044638f, 0.827077f, 4.673232f, 1.578197f, 3.108932f,
0.292985f, 0.977613f, 0.007977f, 1.185702f, 0.509731f, 3.300248f, 0.922076f, 2.223329f, 0.268157f, 1.474048f, 0.337249f, 2.168017f, 1.130275f, 7.593442f, 1.766494f, 4.641075f,
0.128231f, 0.502373f, 0.006467f, 0.630448f, 0.220611f, 1.677038f, 0.739218f, 1.168998f, 0.087486f, 0.564641f, 0.203808f, 0.859286f, 0.646735f, 5.101424f, 1.872296f, 3.226155f,
0.421175f, 1.284548f, 0.014249f, 1.722093f, 1.138795f, 6.739335f, 2.559858f, 5.018472f, 0.502598f, 2.525277f, 0.785466f, 4.105417f, 2.024917f, 12.434470f, 3.932598f, 8.400489f,
0.145719f, 0.449876f, 0.004259f, 0.673803f, 0.121829f, 0.729814f, 0.236563f, 0.607156f, 0.003850f, 0.019581f, 0.005197f, 0.035565f, 0.437248f, 2.717923f, 0.733541f, 2.051389f,
0.176899f, 0.649360f, 0.004234f, 0.893534f, 0.209493f, 1.492150f, 0.333178f, 1.140477f, 0.176952f, 1.070079f, 0.195659f, 1.785598f, 0.617699f, 4.565292f, 0.848762f, 3.165668f,
0.082722f, 0.356526f, 0.003668f, 0.507610f, 0.096873f, 0.810130f, 0.285383f, 0.640682f, 0.061681f, 0.437948f, 0.126332f, 0.756144f, 0.377629f, 3.276929f, 0.961156f, 2.351136f,
0.335936f, 1.127149f, 0.009992f, 1.714369f, 0.618282f, 4.025272f, 1.221906f, 3.400686f, 0.438127f, 2.421728f, 0.601987f, 4.466739f, 1.461880f, 9.875737f, 2.496120f, 7.569437f,
0.279856f, 0.716822f, 0.008372f, 1.111044f, 0.323074f, 1.605690f, 0.642158f, 1.382389f, 0.006656f, 0.028085f, 0.009197f, 0.052787f, 0.939822f, 4.846792f, 1.613943f, 3.785695f,
0.344023f, 1.047724f, 0.008429f, 1.491946f, 0.562552f, 3.324337f, 0.915830f, 2.629418f, 0.309763f, 1.554136f, 0.350605f, 2.683722f, 1.344428f, 8.243831f, 1.891004f, 5.915703f,
0.208522f, 0.745627f, 0.009464f, 1.098605f, 0.337181f, 2.339465f, 1.016802f, 1.914631f, 0.139957f, 0.824452f, 0.293430f, 1.473084f, 1.065357f, 7.670029f, 2.775684f, 5.694927f,
0.393129f, 1.094359f, 0.011970f, 1.722516f, 0.999071f, 5.396407f, 2.021127f, 4.717985f, 0.461520f, 2.116487f, 0.649118f, 4.039814f, 1.914651f, 10.731170f, 3.346488f, 8.511804f,
0.052513f, 0.138472f, 0.001669f, 0.327918f, 0.069792f, 0.357100f, 0.147340f, 0.469721f, 0.000885f, 0.003844f, 0.001299f, 0.011039f, 0.143411f, 0.761404f, 0.261577f, 0.908631f,
0.053332f, 0.167212f, 0.001388f, 0.363794f, 0.100401f, 0.610804f, 0.173605f, 0.738139f, 0.034023f, 0.175736f, 0.040902f, 0.463651f, 0.169490f, 1.069937f, 0.253205f, 1.173051f,
0.001726f, 0.006354f, 0.000083f, 0.014303f, 0.003213f, 0.022951f, 0.010291f, 0.028697f, 0.000821f, 0.004978f, 0.001828f, 0.013588f, 0.007171f, 0.053150f, 0.019844f, 0.060295f,
0.089226f, 0.255706f, 0.002886f, 0.614930f, 0.261054f, 1.451651f, 0.560921f, 1.939079f, 0.074216f, 0.350387f, 0.110868f, 1.021822f, 0.353392f, 2.039091f, 0.656038f, 2.471114f,
0.110838f, 0.282074f, 0.003507f, 0.550387f, 0.182401f, 0.900711f, 0.383472f, 0.976202f, 0.002682f, 0.011244f, 0.003920f, 0.026606f, 0.392913f, 2.013283f, 0.713684f, 1.979620f,
0.141340f, 0.427685f, 0.003663f, 0.766683f, 0.329468f, 1.934437f, 0.567325f, 1.926171f, 0.129486f, 0.645478f, 0.155017f, 1.403187f, 0.583062f, 3.552265f, 0.867433f, 3.208989f,
0.054170f, 0.192456f, 0.002601f, 0.356974f, 0.124866f, 0.860791f, 0.398276f, 0.886853f, 0.036993f, 0.216516f, 0.082034f, 0.487009f, 0.292148f, 2.089801f, 0.805091f, 1.953357f,
0.226714f, 0.627051f, 0.007301f, 1.242487f, 0.821320f, 4.407785f, 1.757424f, 4.851297f, 0.270801f, 1.233884f, 0.402856f, 2.964869f, 1.165555f, 6.490668f, 2.154760f, 6.481113f,
0.063146f, 0.176789f, 0.001757f, 0.391362f, 0.070734f, 0.384261f, 0.130743f, 0.472495f, 0.001670f, 0.007702f, 0.002146f, 0.020677f, 0.202612f, 1.142115f, 0.323560f, 1.274100f,
0.083240f, 0.277095f, 0.001897f, 0.563555f, 0.132077f, 0.853111f, 0.199952f, 0.963746f, 0.083344f, 0.457058f, 0.087723f, 1.127254f, 0.310808f, 2.083150f, 0.406532f, 2.135012f,
0.034086f, 0.133223f, 0.001439f, 0.280351f, 0.053482f, 0.405597f, 0.149977f, 0.474095f, 0.025440f, 0.163804f, 0.049599f, 0.418012f, 0.166390f, 1.309380f, 0.403134f, 1.388543f,
0.176383f, 0.536685f, 0.004994f, 1.206494f, 0.434949f, 2.567934f, 0.818245f, 3.206550f, 0.230258f, 1.154186f, 0.301158f, 3.146473f, 0.820772f, 5.028249f, 1.334043f, 5.696313f,
0.161969f, 0.376222f, 0.004612f, 0.861880f, 0.250524f, 1.129133f, 0.474005f, 1.436801f, 0.003856f, 0.014754f, 0.005072f, 0.040988f, 0.581636f, 2.720173f, 0.950796f, 3.140297f,
0.216204f, 0.597116f, 0.005043f, 1.256747f, 0.473684f, 2.538445f, 0.734066f, 2.967599f, 0.194858f, 0.886571f, 0.209942f, 2.262794f, 0.903488f, 5.024009f, 1.209682f, 5.328570f,
0.114756f, 0.372118f, 0.004958f, 0.810370f, 0.248620f, 1.564322f, 0.713679f, 1.892246f, 0.077096f, 0.411847f, 0.153863f, 1.087631f, 0.626941f, 4.093221f, 1.554875f, 4.491996f,
0.275680f, 0.695932f, 0.007990f, 1.619024f, 0.938680f, 4.597934f, 1.807627f, 5.941520f, 0.323947f, 1.347210f, 0.433711f, 3.800705f, 1.435720f, 7.297324f, 2.388708f, 8.555025f,
0.136561f, 0.212699f, 0.003191f, 0.514849f, 0.152396f, 0.460573f, 0.236594f, 0.619243f, 0.002314f, 0.005938f, 0.002498f, 0.017431f, 0.274994f, 0.862375f, 0.368855f, 1.051916f,
0.142099f, 0.263157f, 0.002720f, 0.585214f, 0.224620f, 0.807152f, 0.285621f, 0.997019f, 0.091174f, 0.278158f, 0.080602f, 0.750126f, 0.332988f, 1.241607f, 0.365825f, 1.391410f,
0.004487f, 0.009757f, 0.000159f, 0.022450f, 0.007014f, 0.029592f, 0.016520f, 0.037821f, 0.002146f, 0.007687f, 0.003514f, 0.021450f, 0.013746f, 0.060181f, 0.027974f, 0.069782f,
0.245935f, 0.416301f, 0.005849f, 1.023305f, 0.604175f, 1.984428f, 0.954662f, 2.709448f, 0.205736f, 0.573718f, 0.226012f, 1.710166f, 0.718226f, 2.447836f, 0.980506f, 3.032150f,
0.270012f, 0.405882f, 0.006283f, 0.809502f, 0.373103f, 1.088250f, 0.576835f, 1.205578f, 0.006571f, 0.016273f, 0.007063f, 0.039357f, 0.705785f, 2.136096f, 0.942751f, 2.146892f,
0.352783f, 0.630531f, 0.006724f, 1.155342f, 0.690495f, 2.394655f, 0.874370f, 2.437224f, 0.325048f, 0.957078f, 0.286167f, 2.126639f, 1.073087f, 3.861591f, 1.174011f, 3.565673f,
0.131925f, 0.276846f, 0.004657f, 0.524875f, 0.255339f, 1.039707f, 0.598926f, 1.094907f, 0.090609f, 0.313242f, 0.147761f, 0.720179f, 0.524625f, 2.216617f, 1.063178f, 2.117775f,
0.585383f, 0.956324f, 0.013864f, 1.936896f, 1.780656f, 5.644538f, 2.801945f, 6.350066f, 0.703225f, 1.892604f, 0.769326f, 4.648400f, 2.219079f, 7.299112f, 3.016856f, 7.449766f,
0.160301f, 0.265087f, 0.003279f, 0.599824f, 0.150775f, 0.483799f, 0.204942f, 0.608063f, 0.004264f, 0.011615f, 0.004029f, 0.031872f, 0.379258f, 1.262762f, 0.445391f, 1.439884f,
0.216506f, 0.425702f, 0.003628f, 0.884966f, 0.288449f, 1.100499f, 0.321133f, 1.270746f, 0.218020f, 0.706207f, 0.168751f, 1.780309f, 0.596085f, 2.359809f, 0.573359f, 2.472117f,
0.086504f, 0.199702f, 0.002685f, 0.429554f, 0.113965f, 0.510509f, 0.235022f, 0.609939f, 0.064933f, 0.246951f, 0.093097f, 0.644151f, 0.311364f, 1.447262f, 0.554761f, 1.568748f,
0.474585f, 0.852936f, 0.009882f, 1.959905f, 0.982656f, 3.426788f, 1.359446f, 4.373750f, 0.623095f, 1.844832f, 0.599309f, 5.140643f, 1.628389f, 5.892409f, 1.946351f, 6.823110f,
0.299585f, 0.411029f, 0.006274f, 0.962473f, 0.389084f, 1.035810f, 0.541369f, 1.347238f, 0.007173f, 0.016212f, 0.006938f, 0.046035f, 0.793265f, 2.191312f, 0.953609f, 2.585777f,
0.409729f, 0.668394f, 0.007028f, 1.437919f, 0.753751f, 2.385876f, 0.858994f, 2.851003f, 0.371394f, 0.998093f, 0.294261f, 2.603844f, 1.262509f, 4.146705f, 1.243080f, 4.495478f,
0.212194f, 0.406424f, 0.006742f, 0.904679f, 0.386012f, 1.434601f, 0.814860f, 1.773760f, 0.143375f, 0.452396f, 0.210422f, 1.221171f, 0.854799f, 3.296421f, 1.559007f, 3.697680f,
0.540454f, 0.805862f, 0.011519f, 1.916283f, 1.545173f, 4.470566f, 2.188183f, 5.904863f, 0.638720f, 1.568963f, 0.628859f, 4.524327f, 2.075400f, 6.230690f, 2.539281f, 7.466313f,
0.012855f, 0.019806f, 0.000334f, 0.053039f, 0.021360f, 0.063857f, 0.036866f, 0.094986f, 0.000285f, 0.000724f, 0.000342f, 0.002352f, 0.050492f, 0.156629f, 0.075291f, 0.211371f,
0.019138f, 0.035059f, 0.000407f, 0.086256f, 0.045045f, 0.160112f, 0.063675f, 0.218807f, 0.016080f, 0.048528f, 0.015804f, 0.144785f, 0.087476f, 0.322641f, 0.106836f, 0.400017f,
0.000447f, 0.000962f, 0.000018f, 0.002449f, 0.001041f, 0.004345f, 0.002726f, 0.006144f, 0.000280f, 0.000993f, 0.000510f, 0.003065f, 0.002673f, 0.011577f, 0.006048f, 0.014851f,
0.026263f, 0.043975f, 0.000694f, 0.119588f, 0.096065f, 0.312114f, 0.168748f, 0.471462f, 0.028770f, 0.079361f, 0.035136f, 0.261720f, 0.149599f, 0.504343f, 0.227041f, 0.691166f,
0.018623f, 0.027691f, 0.000482f, 0.061099f, 0.038315f, 0.110546f, 0.065853f, 0.135487f, 0.000593f, 0.001454f, 0.000709f, 0.003890f, 0.094946f, 0.284251f, 0.140990f, 0.316067f,
0.034812f, 0.061546f, 0.000738f, 0.124764f, 0.101452f, 0.348030f, 0.142817f, 0.391884f, 0.042003f, 0.122336f, 0.041109f, 0.300738f, 0.206538f, 0.735201f, 0.251202f, 0.751051f,
0.009637f, 0.020004f, 0.000378f, 0.041959f, 0.027772f, 0.111859f, 0.072418f, 0.130325f, 0.008667f, 0.029640f, 0.015713f, 0.075391f, 0.074748f, 0.312404f, 0.168400f, 0.330213f,
0.045800f, 0.074012f, 0.001206f, 0.165842f, 0.207438f, 0.650446f, 0.362871f, 0.809559f, 0.072050f, 0.191812f, 0.087627f, 0.521203f, 0.338646f, 1.101839f, 0.511815f, 1.244168f,
0.001679f, 0.002747f, 0.000038f, 0.006876f, 0.002351f, 0.007464f, 0.003553f, 0.010378f, 0.000058f, 0.000158f, 0.000061f, 0.000478f, 0.007748f, 0.025519f, 0.010116f, 0.032193f,
0.003245f, 0.006310f, 0.000060f, 0.014513f, 0.006436f, 0.024290f, 0.007966f, 0.031030f, 0.004279f, 0.013709f, 0.003682f, 0.038235f, 0.017424f, 0.068231f, 0.018631f, 0.079079f,
0.000960f, 0.002191f, 0.000033f, 0.005215f, 0.001882f, 0.008341f, 0.004316f, 0.011026f, 0.000943f, 0.003549f, 0.001504f, 0.010241f, 0.006737f, 0.030977f, 0.013345f, 0.037148f,
0.005639f, 0.010025f, 0.000131f, 0.025485f, 0.017385f, 0.059970f, 0.026738f, 0.084682f, 0.009695f, 0.028395f, 0.010367f, 0.087536f, 0.037740f, 0.135085f, 0.050147f, 0.173055f,
0.027168f, 0.036871f, 0.000632f, 0.095518f, 0.052537f, 0.138349f, 0.081264f, 0.199079f, 0.000852f, 0.001904f, 0.000916f, 0.005983f, 0.140315f, 0.383411f, 0.187517f, 0.500540f,
0.053161f, 0.085783f, 0.001014f, 0.204170f, 0.145615f, 0.455933f, 0.184482f, 0.602752f, 0.063102f, 0.167748f, 0.055581f, 0.484160f, 0.319505f, 1.038059f, 0.349726f, 1.245038f,
0.020380f, 0.038613f, 0.000720f, 0.095091f, 0.055203f, 0.202941f, 0.129549f, 0.277602f, 0.018033f, 0.056285f, 0.029422f, 0.168088f, 0.160138f, 0.610869f, 0.324686f, 0.758094f,
0.055598f, 0.082005f, 0.001317f, 0.215737f, 0.236681f, 0.677367f, 0.372611f, 0.989827f, 0.086046f, 0.209077f, 0.094180f, 0.667016f, 0.416441f, 1.236697f, 0.566433f, 1.639538f,
0.033277f, 0.096762f, 0.001111f, 0.155033f, 0.043414f, 0.244952f, 0.096284f, 0.217995f, 0.000611f, 0.002925f, 0.000941f, 0.005683f, 0.097165f, 0.568859f, 0.186179f, 0.459297f,
0.051180f, 0.176947f, 0.001399f, 0.260464f, 0.094579f, 0.634492f, 0.171802f, 0.518775f, 0.035554f, 0.202503f, 0.044901f, 0.361475f, 0.173901f, 1.210546f, 0.272922f, 0.897960f,
0.001446f, 0.005871f, 0.000073f, 0.008942f, 0.002643f, 0.020818f, 0.008893f, 0.017612f, 0.000749f, 0.005009f, 0.001752f, 0.009251f, 0.006425f, 0.052511f, 0.018678f, 0.040303f,
0.061548f, 0.194502f, 0.002091f, 0.316465f, 0.176766f, 1.083912f, 0.399003f, 0.979590f, 0.055746f, 0.290220f, 0.087484f, 0.572626f, 0.260630f, 1.658317f, 0.508280f, 1.359692f,
0.063596f, 0.178471f, 0.002114f, 0.235608f, 0.102734f, 0.559421f, 0.226897f, 0.410213f, 0.001676f, 0.007747f, 0.002573f, 0.012402f, 0.241038f, 1.361937f, 0.459940f, 0.906048f,
0.122812f, 0.409791f, 0.003344f, 0.497017f, 0.281019f, 1.819458f, 0.508349f, 1.225742f, 0.122516f, 0.673466f, 0.154083f, 0.990528f, 0.541673f, 3.639081f, 0.846574f, 2.224188f,
0.041102f, 0.161025f, 0.002073f, 0.202076f, 0.093002f, 0.706982f, 0.311629f, 0.492810f, 0.030564f, 0.197263f, 0.071203f, 0.300200f, 0.237001f, 1.869452f, 0.686116f, 1.182246f,
0.141599f, 0.431866f, 0.004791f, 0.578969f, 0.503552f, 2.979994f, 1.131916f, 2.219064f, 0.184174f, 0.925371f, 0.287829f, 1.504403f, 0.778329f, 4.779509f, 1.511595f, 3.228943f,
0.035794f, 0.110505f, 0.001046f, 0.165509f, 0.039359f, 0.235776f, 0.076425f, 0.196150f, 0.001031f, 0.005242f, 0.001392f, 0.009522f, 0.122793f, 0.763277f, 0.206001f, 0.576093f,
0.071454f, 0.262293f, 0.001710f, 0.360921f, 0.111294f, 0.792708f, 0.177001f, 0.605881f, 0.077905f, 0.471113f, 0.086141f, 0.786127f, 0.285256f, 2.108272f, 0.391962f, 1.461919f,
0.025550f, 0.110119f, 0.001133f, 0.156784f, 0.039352f, 0.329098f, 0.115931f, 0.260263f, 0.020765f, 0.147435f, 0.042530f, 0.254556f, 0.133350f, 1.157164f, 0.339408f, 0.830244f,
0.108833f, 0.365162f, 0.003237f, 0.555403f, 0.263445f, 1.715136f, 0.520644f, 1.449005f, 0.154708f, 0.855140f, 0.212569f, 1.577257f, 0.541468f, 3.657889f, 0.924542f, 2.803655f,
0.070638f, 0.180933f, 0.002113f, 0.280438f, 0.107252f, 0.533049f, 0.213180f, 0.458918f, 0.001831f, 0.007726f, 0.002530f, 0.014523f, 0.271212f, 1.398677f, 0.465748f, 1.092468f,
0.142793f, 0.434876f, 0.003499f, 0.619259f, 0.307101f, 1.814778f, 0.499958f, 1.435417f, 0.140138f, 0.703098f, 0.158615f, 1.214128f, 0.637990f, 3.912058f, 0.897364f, 2.807259f,
0.066182f, 0.236652f, 0.003004f, 0.348683f, 0.140751f, 0.976574f, 0.424448f, 0.799233f, 0.048416f, 0.285208f, 0.101508f, 0.509594f, 0.386582f, 2.783191f, 1.007201f, 2.066494f,
0.130875f, 0.364319f, 0.003985f, 0.573436f, 0.437439f, 2.362796f, 0.884942f, 2.065751f, 0.167464f, 0.767972f, 0.235534f, 1.465856f, 0.728734f, 4.084379f, 1.273703f, 3.239669f,
0.009233f, 0.024347f, 0.000293f, 0.057656f, 0.016139f, 0.082579f, 0.034072f, 0.108622f, 0.000170f, 0.000737f, 0.000249f, 0.002115f, 0.028828f, 0.153057f, 0.052582f, 0.182652f,
0.015420f, 0.048346f, 0.000401f, 0.105184f, 0.038179f, 0.232271f, 0.066017f, 0.280692f, 0.010722f, 0.055381f, 0.012890f, 0.146114f, 0.056027f, 0.353678f, 0.083699f, 0.387763f,
0.000382f, 0.001405f, 0.000018f, 0.003162f, 0.000934f, 0.006674f, 0.002992f, 0.008345f, 0.000198f, 0.001199f, 0.000440f, 0.003274f, 0.001813f, 0.013435f, 0.005016f, 0.015241f,
0.020691f, 0.059298f, 0.000669f, 0.142601f, 0.079621f, 0.442749f, 0.171079f, 0.591413f, 0.018759f, 0.088563f, 0.028023f, 0.258273f, 0.093693f, 0.540617f, 0.173933f, 0.655157f,
0.020819f, 0.052983f, 0.000659f, 0.103382f, 0.045061f, 0.222516f, 0.094735f, 0.241166f, 0.000549f, 0.002302f, 0.000803f, 0.005447f, 0.084378f, 0.432353f, 0.153264f, 0.425124f,
0.043657f, 0.132103f, 0.001131f, 0.236813f, 0.133845f, 0.785858f, 0.230474f, 0.782500f, 0.043593f, 0.217310f, 0.052189f, 0.472404f, 0.205902f, 1.254448f, 0.306326f, 1.133223f,
0.012794f, 0.045456f, 0.000614f, 0.084313f, 0.038789f, 0.267398f, 0.123721f, 0.275494f, 0.009523f, 0.055739f, 0.021119f, 0.125373f, 0.078890f, 0.564315f, 0.217401f, 0.527471f,
0.056166f, 0.155344f, 0.001809f, 0.307812f, 0.267612f, 1.436193f, 0.572623f, 1.580703f, 0.073122f, 0.333177f, 0.108780f, 0.800583f, 0.330128f, 1.838398f, 0.610308f, 1.835691f,
0.011429f, 0.031999f, 0.000318f, 0.070837f, 0.016839f, 0.091476f, 0.031124f, 0.112481f, 0.000329f, 0.001520f, 0.000423f, 0.004079f, 0.041928f, 0.236346f, 0.066957f, 0.263659f,
0.024776f, 0.082475f, 0.000565f, 0.167738f, 0.051704f, 0.333965f, 0.078275f, 0.377275f, 0.027038f, 0.148277f, 0.028459f, 0.365700f, 0.105766f, 0.708880f, 0.138340f, 0.726528f,
0.007758f, 0.030321f, 0.000327f, 0.063807f, 0.016009f, 0.121411f, 0.044894f, 0.141916f, 0.006311f, 0.040635f, 0.012304f, 0.103696f, 0.043296f, 0.340712f, 0.104899f, 0.361311f,
0.042107f, 0.128120f, 0.001192f, 0.288020f, 0.136564f, 0.806272f, 0.256910f, 1.006783f, 0.059913f, 0.300318f, 0.078361f, 0.818710f, 0.224015f, 1.372372f, 0.364104f, 1.554709f,
0.030125f, 0.069975f, 0.000858f, 0.160305f, 0.061284f, 0.276213f, 0.115953f, 0.351476f, 0.000782f, 0.002991f, 0.001028f, 0.008309f, 0.123683f, 0.578434f, 0.202183f, 0.667772f,
0.066127f, 0.182630f, 0.001542f, 0.384380f, 0.190547f, 1.021129f, 0.295289f, 1.193763f, 0.064959f, 0.295553f, 0.069988f, 0.754339f, 0.315931f, 1.756794f, 0.423001f, 1.863293f,
0.026838f, 0.087029f, 0.001160f, 0.189525f, 0.076475f, 0.481181f, 0.219526f, 0.582050f, 0.019653f, 0.104985f, 0.039221f, 0.277251f, 0.167636f, 1.094474f, 0.415753f, 1.201101f,
0.067627f, 0.170719f, 0.001960f, 0.397164f, 0.302854f, 1.483469f, 0.583209f, 1.916961f, 0.086616f, 0.360213f, 0.115964f, 1.016222f, 0.402664f, 2.046619f, 0.669941f, 2.399355f,
0.037944f, 0.059100f, 0.000887f, 0.143054f, 0.055692f, 0.168313f, 0.086462f, 0.226298f, 0.000701f, 0.001798f, 0.000757f, 0.005279f, 0.087358f, 0.273951f, 0.117174f, 0.334163f,
0.064927f, 0.120240f, 0.001243f, 0.267392f, 0.134984f, 0.485052f, 0.171642f, 0.599151f, 0.045406f, 0.138527f, 0.040141f, 0.373573f, 0.173948f, 0.648597f, 0.191101f, 0.726852f,
0.001568f, 0.003409f, 0.000056f, 0.007844f, 0.003223f, 0.013598f, 0.007591f, 0.017379f, 0.000817f, 0.002927f, 0.001338f, 0.008168f, 0.005491f, 0.024039f, 0.011174f, 0.027874f,
0.090127f, 0.152561f, 0.002143f, 0.375009f, 0.291205f, 0.956469f, 0.460135f, 1.305921f, 0.082178f, 0.229162f, 0.090277f, 0.683097f, 0.300923f, 1.025595f, 0.410812f, 1.270411f,
0.080150f, 0.120481f, 0.001865f, 0.240290f, 0.145662f, 0.424860f, 0.225200f, 0.470665f, 0.002126f, 0.005265f, 0.002285f, 0.012733f, 0.239523f, 0.724929f, 0.319942f, 0.728592f,
0.172202f, 0.307777f, 0.003282f, 0.563950f, 0.443292f, 1.537351f, 0.561339f, 1.564680f, 0.172936f, 0.509197f, 0.152250f, 1.131442f, 0.598856f, 2.155033f, 0.655179f, 1.989891f,
0.049241f, 0.103333f, 0.001738f, 0.195910f, 0.125348f, 0.510400f, 0.294017f, 0.537498f, 0.036862f, 0.127435f, 0.060113f, 0.292987f, 0.223875f, 0.945906f, 0.453695f, 0.903727f,
0.229178f, 0.374402f, 0.005428f, 0.758298f, 0.916881f, 2.906440f, 1.442755f, 3.269725f, 0.300079f, 0.807609f, 0.328286f, 1.983558f, 0.993261f, 3.267086f, 1.350347f, 3.334519f,
0.045852f, 0.075825f, 0.000938f, 0.171572f, 0.056722f, 0.182007f, 0.077100f, 0.228755f, 0.001329f, 0.003621f, 0.001256f, 0.009937f, 0.124027f, 0.412953f, 0.145653f, 0.470877f,
0.101837f, 0.200236f, 0.001706f, 0.416258f, 0.178445f, 0.680808f, 0.198665f, 0.786130f, 0.111774f, 0.362056f, 0.086515f, 0.912724f, 0.320554f, 1.269024f, 0.308332f, 1.329419f,
0.031113f, 0.071827f, 0.000966f, 0.154498f, 0.053911f, 0.241495f, 0.111177f, 0.288530f, 0.025455f, 0.096811f, 0.036496f, 0.252523f, 0.128035f, 0.595127f, 0.228123f, 0.645083f,
0.179041f, 0.321777f, 0.003728f, 0.739390f, 0.487573f, 1.700299f, 0.674528f, 2.170161f, 0.256213f, 0.758584f, 0.246432f, 2.113801f, 0.702350f, 2.541491f, 0.839493f, 2.942917f,
0.088056f, 0.120813f, 0.001844f, 0.282897f, 0.150412f, 0.400424f, 0.209283f, 0.520816f, 0.002298f, 0.005194f, 0.002223f, 0.014748f, 0.266573f, 0.736380f, 0.320456f, 0.868938f,
0.198039f, 0.323062f, 0.003397f, 0.695005f, 0.479161f, 1.516705f, 0.546064f, 1.812387f, 0.195658f, 0.525815f, 0.155023f, 1.371756f, 0.697662f, 2.291469f, 0.686926f, 2.484201f,
0.078425f, 0.150211f, 0.002492f, 0.334363f, 0.187639f, 0.697355f, 0.396101f, 0.862220f, 0.057757f, 0.182243f, 0.084766f, 0.491936f, 0.361197f, 1.392911f, 0.658763f, 1.562464f,
0.209515f, 0.312404f, 0.004466f, 0.742876f, 0.787831f, 2.279390f, 1.115681f, 3.010690f, 0.269883f, 0.662945f, 0.265716f, 1.911695f, 0.919847f, 2.761531f, 1.125446f, 3.309177f,
0.056729f, 0.087402f, 0.001474f, 0.234057f, 0.066637f, 0.199210f, 0.115008f, 0.296320f, 0.001239f, 0.003146f, 0.001487f, 0.010215f, 0.143949f, 0.446536f, 0.214648f, 0.602600f,
0.057912f, 0.106089f, 0.001232f, 0.261010f, 0.096358f, 0.342506f, 0.136212f, 0.468063f, 0.047900f, 0.144555f, 0.047076f, 0.431285f, 0.171007f, 0.630732f, 0.208855f, 0.781995f,
0.001864f, 0.004009f, 0.000073f, 0.010206f, 0.003067f, 0.012799f, 0.008030f, 0.018098f, 0.001149f, 0.004072f, 0.002092f, 0.012570f, 0.007196f, 0.031161f, 0.016279f, 0.039974f,
0.081282f, 0.136099f, 0.002149f, 0.370119f, 0.210181f, 0.682875f, 0.369204f, 1.031513f, 0.087654f, 0.241787f, 0.107048f, 0.797372f, 0.299116f, 1.008407f, 0.453956f, 1.381950f,
0.076362f, 0.113545f, 0.001975f, 0.250538f, 0.111066f, 0.320446f, 0.190892f, 0.392744f, 0.002396f, 0.005868f, 0.002863f, 0.015702f, 0.251519f, 0.753000f, 0.373492f, 0.837283f,
0.097882f, 0.173051f, 0.002074f, 0.350806f, 0.201656f, 0.691782f, 0.283878f, 0.778950f, 0.116260f, 0.338612f, 0.113785f, 0.832410f, 0.375175f, 1.335490f, 0.456307f, 1.364281f,
0.037309f, 0.077445f, 0.001464f, 0.162443f, 0.076008f, 0.306144f, 0.198197f, 0.356681f, 0.033032f, 0.112960f, 0.059885f, 0.287324f, 0.186954f, 0.781363f, 0.421191f, 0.825905f,
0.131712f, 0.212846f, 0.003468f, 0.476931f, 0.421720f, 1.322354f, 0.737716f, 1.645832f, 0.203971f, 0.543010f, 0.248067f, 1.475502f, 0.629165f, 2.047091f, 0.950894f, 2.311521f,
0.004318f, 0.007064f, 0.000098f, 0.017683f, 0.004275f, 0.013570f, 0.006460f, 0.018868f, 0.000148f, 0.000399f, 0.000156f, 0.001211f, 0.012874f, 0.042400f, 0.016807f, 0.053489f,
0.005722f, 0.011129f, 0.000107f, 0.025595f, 0.008024f, 0.030282f, 0.009931f, 0.038685f, 0.007428f, 0.023799f, 0.006391f, 0.066376f, 0.019851f, 0.077737f, 0.021227f, 0.090096f,
0.002330f, 0.005321f, 0.000080f, 0.012663f, 0.003231f, 0.014318f, 0.007408f, 0.018926f, 0.002255f, 0.008483f, 0.003594f, 0.024479f, 0.010569f, 0.048594f, 0.020934f, 0.058274f,
0.010171f, 0.018082f, 0.000235f, 0.045968f, 0.022168f, 0.076468f, 0.034093f, 0.107978f, 0.017215f, 0.050417f, 0.018407f, 0.155427f, 0.043977f, 0.157411f, 0.058435f, 0.201656f,
0.117036f, 0.158835f, 0.002725f, 0.411481f, 0.159993f, 0.421320f, 0.247477f, 0.606266f, 0.003612f, 0.008076f, 0.003884f, 0.025371f, 0.390502f, 1.067047f, 0.521867f, 1.393023f,
0.157035f, 0.253400f, 0.002994f, 0.603110f, 0.304078f, 0.952094f, 0.385241f, 1.258687f, 0.183493f, 0.487789f, 0.161623f, 1.407875f, 0.609732f, 1.980993f, 0.667404f, 2.375985f,
0.082893f, 0.157051f, 0.002928f, 0.386763f, 0.158725f, 0.583513f, 0.372489f, 0.798183f, 0.072201f, 0.225355f, 0.117801f, 0.672998f, 0.420781f, 1.605131f, 0.853152f, 1.991980f,
0.167977f, 0.247758f, 0.003980f, 0.651800f, 0.505506f, 1.446729f, 0.795827f, 2.114085f, 0.255911f, 0.621823f, 0.280103f, 1.983790f, 0.812829f, 2.413841f, 1.105589f, 3.200123f,
0.163500f, 0.475424f, 0.005458f, 0.761728f, 0.150794f, 0.850807f, 0.334429f, 0.757178f, 0.002953f, 0.014147f, 0.004554f, 0.027486f, 0.308419f, 1.805664f, 0.590968f, 1.457896f,
0.172431f, 0.596158f, 0.004714f, 0.877537f, 0.225263f, 1.511188f, 0.409187f, 1.235582f, 0.117916f, 0.671615f, 0.148917f, 1.198857f, 0.378510f, 2.634850f, 0.594036f, 1.954482f,
0.006709f, 0.027236f, 0.000340f, 0.041482f, 0.008668f, 0.068271f, 0.029164f, 0.057757f, 0.003420f, 0.022872f, 0.008001f, 0.042244f, 0.019255f, 0.157372f, 0.055975f, 0.120786f,
0.212087f, 0.670234f, 0.007205f, 1.090506f, 0.430602f, 2.640406f, 0.971970f, 2.386277f, 0.189098f, 0.984464f, 0.296757f, 1.942423f, 0.580206f, 3.691699f, 1.131519f, 3.026908f,
0.290344f, 0.814802f, 0.009651f, 1.075659f, 0.331570f, 1.805502f, 0.732299f, 1.323942f, 0.007531f, 0.034817f, 0.011564f, 0.055739f, 0.710930f, 4.016970f, 1.356571f, 2.672345f,
0.384474f, 1.282890f, 0.010468f, 1.555959f, 0.621924f, 4.026641f, 1.125027f, 2.712689f, 0.377564f, 2.075453f, 0.474845f, 3.052558f, 1.095520f, 7.359949f, 1.712175f, 4.498365f,
0.177169f, 0.694097f, 0.008935f, 0.871049f, 0.283396f, 2.154321f, 0.949598f, 1.501694f, 0.129692f, 0.837037f, 0.302130f, 1.273825f, 0.659985f, 5.205933f, 1.910652f, 3.292246f,
0.453391f, 1.382802f, 0.015339f, 1.853814f, 1.139802f, 6.745290f, 2.562120f, 5.022906f, 0.580510f, 2.916739f, 0.907226f, 4.741828f, 1.610017f, 9.886685f, 3.126820f, 6.679253f,
0.102494f, 0.316427f, 0.002995f, 0.473928f, 0.079672f, 0.477272f, 0.154703f, 0.397058f, 0.002905f, 0.014777f, 0.003922f, 0.026840f, 0.227155f, 1.411987f, 0.381082f, 1.065716f,
0.140301f, 0.515016f, 0.003358f, 0.708673f, 0.154482f, 1.100326f, 0.245689f, 0.840998f, 0.150581f, 0.910604f, 0.166499f, 1.519488f, 0.361847f, 2.674343f, 0.497204f, 1.854445f,
0.069076f, 0.297712f, 0.003063f, 0.423874f, 0.075211f, 0.628976f, 0.221568f, 0.497419f, 0.055263f, 0.392380f, 0.113188f, 0.677468f, 0.232908f, 2.021095f, 0.592807f, 1.450098f,
0.218564f, 0.733337f, 0.006501f, 1.115389f, 0.374009f, 2.434956f, 0.739152f, 2.057133f, 0.305845f, 1.690543f, 0.420231f, 3.118111f, 0.702502f, 4.745755f, 1.199503f, 3.637469f,
0.338807f, 0.867817f, 0.010136f, 1.345081f, 0.363658f, 1.807393f, 0.722825f, 1.556041f, 0.008645f, 0.036481f, 0.011947f, 0.068569f, 0.840381f, 4.333962f, 1.443175f, 3.385138f,
0.469634f, 1.430273f, 0.011507f, 2.036691f, 0.714016f, 4.219402f, 1.162414f, 3.337378f, 0.453712f, 2.276354f, 0.513534f, 3.930866f, 1.355574f, 8.312176f, 1.906682f, 5.964747f,
0.299706f, 1.071679f, 0.013603f, 1.579009f, 0.450589f, 3.126320f, 1.358792f, 2.558597f, 0.215833f, 1.271414f, 0.452508f, 2.271691f, 1.130972f, 8.142423f, 2.946638f, 6.045676f,
0.440245f, 1.225516f, 0.013405f, 1.928956f, 1.040230f, 5.618725f, 2.104392f, 4.912354f, 0.554534f, 2.543042f, 0.779941f, 4.853995f, 1.583662f, 8.876052f, 2.767975f, 7.040354f,
0.070807f, 0.186714f, 0.002250f, 0.442159f, 0.087497f, 0.447690f, 0.184718f, 0.588881f, 0.001280f, 0.005561f, 0.001879f, 0.015970f, 0.142827f, 0.758302f, 0.260511f, 0.904930f,
0.081087f, 0.254235f, 0.002110f, 0.553125f, 0.141931f, 0.863464f, 0.245417f, 1.043471f, 0.055504f, 0.286687f, 0.066725f, 0.756376f, 0.190338f, 1.201546f, 0.284351f, 1.317343f,
0.002763f, 0.010171f, 0.000133f, 0.022896f, 0.004782f, 0.034159f, 0.015317f, 0.042713f, 0.001410f, 0.008549f, 0.003139f, 0.023339f, 0.008479f, 0.062843f, 0.023463f, 0.071291f,
0.111288f, 0.318931f, 0.003599f, 0.766975f, 0.302733f, 1.683417f, 0.650475f, 2.248666f, 0.099319f, 0.468902f, 0.148368f, 1.367444f, 0.325556f, 1.878477f, 0.604364f, 2.276470f,
0.148356f, 0.377556f, 0.004694f, 0.736695f, 0.226997f, 1.120930f, 0.477228f, 1.214878f, 0.003852f, 0.016149f, 0.005630f, 0.038210f, 0.388445f, 1.990388f, 0.705568f, 1.957108f,
0.213324f, 0.645503f, 0.005529f, 1.157151f, 0.462339f, 2.714581f, 0.796123f, 2.702980f, 0.209689f, 1.045285f, 0.251033f, 2.272315f, 0.649983f, 3.959982f, 0.966994f, 3.577306f,
0.086081f, 0.305827f, 0.004132f, 0.567259f, 0.184486f, 1.271795f, 0.588442f, 1.310301f, 0.063073f, 0.369159f, 0.139868f, 0.830350f, 0.342896f, 2.452809f, 0.944940f, 2.292665f,
0.280699f, 0.776362f, 0.009040f, 1.538344f, 0.945470f, 5.074062f, 2.023074f, 5.584614f, 0.359741f, 1.639134f, 0.535168f, 3.938635f, 1.065879f, 5.935598f, 1.970489f, 5.926860f,
0.051083f, 0.143017f, 0.001421f, 0.316600f, 0.053203f, 0.289023f, 0.098338f, 0.355388f, 0.001449f, 0.006685f, 0.001863f, 0.017947f, 0.121063f, 0.682425f, 0.193330f, 0.761288f,
0.075931f, 0.252764f, 0.001730f, 0.514071f, 0.112018f, 0.723546f, 0.169585f, 0.817379f, 0.081572f, 0.447339f, 0.085857f, 1.103284f, 0.209407f, 1.403527f, 0.273902f, 1.438469f,
0.032736f, 0.127949f, 0.001382f, 0.269253f, 0.047757f, 0.362181f, 0.133924f, 0.423347f, 0.026215f, 0.168795f, 0.051111f, 0.430750f, 0.118032f, 0.928832f, 0.285970f, 0.984988f,
0.131987f, 0.401599f, 0.003737f, 0.902815f, 0.302612f, 1.786617f, 0.569287f, 2.230929f, 0.184870f, 0.926677f, 0.241795f, 2.526252f, 0.453639f, 2.779100f, 0.737322f, 3.148338f,
0.225528f, 0.523857f, 0.006422f, 1.200095f, 0.324333f, 1.461799f, 0.613657f, 1.860113f, 0.005760f, 0.022043f, 0.007577f, 0.061236f, 0.598182f, 2.797557f, 0.977845f, 3.229633f,
0.339458f, 0.937524f, 0.007918f, 1.973202f, 0.691490f, 3.705658f, 1.071600f, 4.332143f, 0.328262f, 1.493537f, 0.353674f, 3.811952f, 1.047755f, 5.826232f, 1.402841f, 6.179425f,
0.189701f, 0.615141f, 0.008196f, 1.339609f, 0.382125f, 2.404333f, 1.096911f, 2.908346f, 0.136742f, 0.730483f, 0.272902f, 1.929102f, 0.765482f, 4.997738f, 1.898470f, 5.484635f,
0.355072f, 0.896350f, 0.010291f, 2.085279f, 1.124094f, 5.506144f, 2.164679f, 7.115123f, 0.447676f, 1.861766f, 0.599364f, 5.252353f, 1.365823f, 6.942058f, 2.272415f, 8.138528f,
0.152777f, 0.237957f, 0.003570f, 0.575986f, 0.158519f, 0.479076f, 0.246099f, 0.644120f, 0.002778f, 0.007128f, 0.002998f, 0.020923f, 0.227232f, 0.712593f, 0.304790f, 0.869215f,
0.179258f, 0.331972f, 0.003431f, 0.738247f, 0.263457f, 0.946708f, 0.335005f, 1.169404f, 0.123406f, 0.376494f, 0.109097f, 1.015313f, 0.310263f, 1.156871f, 0.340858f, 1.296451f,
0.005960f, 0.012958f, 0.000211f, 0.029817f, 0.008661f, 0.036543f, 0.020401f, 0.046705f, 0.003058f, 0.010955f, 0.005008f, 0.030568f, 0.013485f, 0.059038f, 0.027443f, 0.068456f,
0.254503f, 0.430806f, 0.006053f, 1.058960f, 0.581315f, 1.909341f, 0.918539f, 2.606928f, 0.228435f, 0.637018f, 0.250949f, 1.898853f, 0.548971f, 1.870985f, 0.749442f, 2.317601f,
0.299862f, 0.450752f, 0.006978f, 0.898992f, 0.385248f, 1.123675f, 0.595612f, 1.244822f, 0.007830f, 0.019390f, 0.008416f, 0.046896f, 0.578927f, 1.752155f, 0.773301f, 1.761010f,
0.441774f, 0.789586f, 0.008420f, 1.446783f, 0.803947f, 2.788109f, 1.018034f, 2.837672f, 0.436737f, 1.285935f, 0.384495f, 2.857363f, 0.992525f, 3.571683f, 1.085872f, 3.297981f,
0.173937f, 0.365007f, 0.006141f, 0.692021f, 0.313008f, 1.274526f, 0.734194f, 1.342194f, 0.128178f, 0.443121f, 0.209028f, 1.018786f, 0.510889f, 2.158581f, 1.035342f, 2.062327f,
0.601340f, 0.982393f, 0.014242f, 1.989695f, 1.700725f, 5.391163f, 2.676170f, 6.065021f, 0.775093f, 2.086021f, 0.847948f, 5.123449f, 1.683707f, 5.538139f, 2.289014f, 5.652446f,
0.107593f, 0.177926f, 0.002201f, 0.402601f, 0.094092f, 0.301918f, 0.127896f, 0.379466f, 0.003070f, 0.008365f, 0.002902f, 0.022953f, 0.188018f, 0.626016f, 0.220803f, 0.713825f,
0.163861f, 0.322189f, 0.002746f, 0.669780f, 0.202978f, 0.774406f, 0.225977f, 0.894207f, 0.177043f, 0.573477f, 0.137035f, 1.445705f, 0.333217f, 1.319155f, 0.320513f, 1.381936f,
0.068931f, 0.159133f, 0.002139f, 0.342290f, 0.084435f, 0.378228f, 0.174124f, 0.451894f, 0.055516f, 0.211138f, 0.079596f, 0.550735f, 0.183256f, 0.851799f, 0.326510f, 0.923300f,
0.294650f, 0.529553f, 0.006135f, 1.216823f, 0.567241f, 1.978125f, 0.784745f, 2.524762f, 0.415074f, 1.228933f, 0.399229f, 3.424434f, 0.746731f, 2.702086f, 0.892539f, 3.128878f,
0.346104f, 0.474854f, 0.007248f, 1.111926f, 0.417931f, 1.112607f, 0.581506f, 1.447123f, 0.008891f, 0.020095f, 0.008601f, 0.057062f, 0.676893f, 1.869844f, 0.813714f, 2.206440f,
0.533752f, 0.870713f, 0.009155f, 1.873168f, 0.912945f, 2.889776f, 1.040415f, 3.453139f, 0.519106f, 1.395058f, 0.411296f, 3.639454f, 1.214760f, 3.989875f, 1.196066f, 4.325457f,
0.291036f, 0.557433f, 0.009247f, 1.240818f, 0.492253f, 1.829441f, 1.039131f, 2.261946f, 0.210991f, 0.665750f, 0.309658f, 1.797086f, 0.865946f, 3.339411f, 1.579339f, 3.745902f,
0.577549f, 0.861173f, 0.012310f, 2.047808f, 1.535255f, 4.441873f, 2.174139f, 5.866963f, 0.732351f, 1.798959f, 0.721044f, 5.187552f, 1.638118f, 4.917897f, 2.004260f, 5.893177f,
0.094125f, 0.145017f, 0.002445f, 0.388349f, 0.104891f, 0.313573f, 0.181032f, 0.466432f, 0.001543f, 0.003916f, 0.001851f, 0.012718f, 0.279128f, 0.865865f, 0.416217f, 1.168486f,
0.084524f, 0.154838f, 0.001798f, 0.380947f, 0.133420f, 0.474244f, 0.188603f, 0.648095f, 0.052457f, 0.158309f, 0.051555f, 0.472318f, 0.291686f, 1.075835f, 0.356242f, 1.333843f,
0.003213f, 0.006910f, 0.000127f, 0.017591f, 0.005015f, 0.020929f, 0.013131f, 0.029594f, 0.001486f, 0.005266f, 0.002706f, 0.016258f, 0.014495f, 0.062770f, 0.032791f, 0.080523f,
0.120348f, 0.201513f, 0.003182f, 0.548009f, 0.295235f, 0.959213f, 0.518609f, 1.448934f, 0.097382f, 0.268624f, 0.118929f, 0.885874f, 0.517584f, 1.744925f, 0.785516f, 2.391295f,
0.105395f, 0.156715f, 0.002726f, 0.345794f, 0.145429f, 0.419590f, 0.249953f, 0.514257f, 0.002481f, 0.006077f, 0.002965f, 0.016262f, 0.405703f, 1.214597f, 0.602447f, 1.350546f,
0.118837f, 0.210100f, 0.002518f, 0.425909f, 0.232268f, 0.796795f, 0.326971f, 0.897196f, 0.105911f, 0.308473f, 0.103657f, 0.758318f, 0.532327f, 1.894893f, 0.647442f, 1.935744f,
0.053494f, 0.111042f, 0.002099f, 0.232913f, 0.103390f, 0.416433f, 0.269599f, 0.485177f, 0.035538f, 0.121529f, 0.064428f, 0.309121f, 0.313273f, 1.309302f, 0.705774f, 1.383939f,
0.162225f, 0.262154f, 0.004271f, 0.587417f, 0.492767f, 1.545130f, 0.861999f, 1.923105f, 0.188505f, 0.501837f, 0.229257f, 1.363623f, 0.905626f, 2.946601f, 1.368725f, 3.327223f,
0.011812f, 0.019321f, 0.000269f, 0.048368f, 0.011094f, 0.035213f, 0.016764f, 0.048963f, 0.000304f, 0.000819f, 0.000319f, 0.002486f, 0.041154f, 0.135540f, 0.053728f, 0.170987f,
0.013767f, 0.026777f, 0.000256f, 0.061584f, 0.018316f, 0.069124f, 0.022669f, 0.088305f, 0.013410f, 0.042967f, 0.011539f, 0.119836f, 0.055820f, 0.218590f, 0.059689f, 0.253344f,
0.006621f, 0.015121f, 0.000228f, 0.035982f, 0.008711f, 0.038599f, 0.019971f, 0.051021f, 0.004808f, 0.018086f, 0.007663f, 0.052193f, 0.035098f, 0.161373f, 0.069519f, 0.193520f,
0.024827f, 0.044137f, 0.000575f, 0.112204f, 0.051333f, 0.177076f, 0.078949f, 0.250043f, 0.031530f, 0.092341f, 0.033713f, 0.284671f, 0.125450f, 0.449035f, 0.166693f, 0.575251f,
0.183165f, 0.248582f, 0.004264f, 0.643982f, 0.237548f, 0.625551f, 0.367439f, 0.900149f, 0.004242f, 0.009484f, 0.004562f, 0.029793f, 0.714234f, 1.951647f, 0.954504f, 2.547863f,
0.216185f, 0.348849f, 0.004122f, 0.830285f, 0.397139f, 1.243476f, 0.503142f, 1.643900f, 0.189546f, 0.503880f, 0.166955f, 1.454315f, 0.980988f, 3.187186f, 1.073776f, 3.822681f,
0.134770f, 0.255337f, 0.004760f, 0.628808f, 0.244820f, 0.900018f, 0.574531f, 1.231128f, 0.088081f, 0.274919f, 0.143710f, 0.821015f, 0.799509f, 3.049845f, 1.621039f, 3.784882f,
0.234596f, 0.346018f, 0.005559f, 0.910301f, 0.669768f, 1.916836f, 1.054427f, 2.801046f, 0.268178f, 0.651630f, 0.293530f, 2.078885f, 1.326672f, 3.939791f, 1.804506f, 5.223135f,
0.124801f, 0.362896f, 0.004166f, 0.581434f, 0.109197f, 0.616111f, 0.242177f, 0.548309f, 0.001691f, 0.008103f, 0.002608f, 0.015743f, 0.275129f, 1.610763f, 0.527180f, 1.300533f,
0.115777f, 0.400284f, 0.003165f, 0.589214f, 0.143491f, 0.962616f, 0.260649f, 0.787057f, 0.059408f, 0.338370f, 0.075027f, 0.604003f, 0.297015f, 2.067555f, 0.466137f, 1.533673f,
0.005320f, 0.021597f, 0.000269f, 0.032893f, 0.006520f, 0.051359f, 0.021939f, 0.043449f, 0.002035f, 0.013609f, 0.004760f, 0.025135f, 0.017844f, 0.145839f, 0.051873f, 0.111934f,
0.144465f, 0.456535f, 0.004908f, 0.742807f, 0.278260f, 1.706261f, 0.628098f, 1.542040f, 0.096649f, 0.503166f, 0.151674f, 0.992785f, 0.461874f, 2.938784f, 0.900748f, 2.409576f,
0.184356f, 0.517364f, 0.006128f, 0.682998f, 0.199732f, 1.087600f, 0.441123f, 0.797518f, 0.003588f, 0.016588f, 0.005509f, 0.026556f, 0.527552f, 2.980826f, 1.006655f, 1.983036f,
0.214743f, 0.716540f, 0.005847f, 0.869059f, 0.329545f, 2.133639f, 0.596130f, 1.437402f, 0.158236f, 0.869817f, 0.199007f, 1.279319f, 0.715097f, 4.804183f, 1.117617f, 2.936293f,
0.116864f, 0.457840f, 0.005894f, 0.574561f, 0.177343f, 1.348128f, 0.594239f, 0.939728f, 0.064190f, 0.414288f, 0.149538f, 0.630475f, 0.508770f, 4.013158f, 1.472887f, 2.537932f,
0.256900f, 0.783522f, 0.008691f, 1.050406f, 0.612699f, 3.625924f, 1.377265f, 2.700058f, 0.246811f, 1.240088f, 0.385719f, 2.016048f, 1.066143f, 6.546897f, 2.070560f, 4.422957f,
0.128974f, 0.398180f, 0.003769f, 0.596374f, 0.095113f, 0.569770f, 0.184686f, 0.474010f, 0.002743f, 0.013953f, 0.003704f, 0.025342f, 0.334058f, 2.076493f, 0.560426f, 1.567261f,
0.155301f, 0.570077f, 0.003717f, 0.784438f, 0.162225f, 1.155476f, 0.258003f, 0.883151f, 0.125068f, 0.756321f, 0.138290f, 1.262043f, 0.468093f, 3.459582f, 0.643192f, 2.398945f,
0.090299f, 0.389182f, 0.004004f, 0.554105f, 0.093275f, 0.780040f, 0.274783f, 0.616886f, 0.054207f, 0.384881f, 0.111025f, 0.664521f, 0.355823f, 3.087706f, 0.905655f, 2.215372f,
0.245432f, 0.823486f, 0.007300f, 1.252504f, 0.398439f, 2.594006f, 0.787433f, 2.191504f, 0.257702f, 1.424437f, 0.354083f, 2.627292f, 0.921922f, 6.228046f, 1.574156f, 4.773598f,
0.243936f, 0.624817f, 0.007298f, 0.968441f, 0.248396f, 1.234537f, 0.493724f, 1.062852f, 0.004671f, 0.019708f, 0.006454f, 0.037044f, 0.707123f, 3.646729f, 1.214332f, 2.848360f,
0.297434f, 0.905838f, 0.007288f, 1.289901f, 0.429009f, 2.535183f, 0.698424f, 2.005228f, 0.215613f, 1.081771f, 0.244042f, 1.868029f, 1.003340f, 6.152333f, 1.411248f, 4.414862f,
0.224166f, 0.801566f, 0.010174f, 1.181025f, 0.319729f, 2.218374f, 0.964172f, 1.815529f, 0.121131f, 0.713551f, 0.253959f, 1.274933f, 0.988598f, 7.117406f, 2.575697f, 5.284609f,
0.282856f, 0.787391f, 0.008612f, 1.239350f, 0.634056f, 3.424809f, 1.282700f, 2.994251f, 0.267340f, 1.225996f, 0.376008f, 2.340102f, 1.189126f, 6.664769f, 2.078391f, 5.286396f,
0.010688f, 0.028185f, 0.000340f, 0.066744f, 0.012530f, 0.064112f, 0.026453f, 0.084332f, 0.000145f, 0.000630f, 0.000213f, 0.001809f, 0.025197f, 0.133774f, 0.045958f, 0.159641f,
0.010767f, 0.033758f, 0.000280f, 0.073446f, 0.017879f, 0.108771f, 0.030915f, 0.131447f, 0.005530f, 0.028564f, 0.006648f, 0.075361f, 0.029537f, 0.186457f, 0.044126f, 0.204426f,
0.000433f, 0.001595f, 0.000021f, 0.003590f, 0.000711f, 0.005082f, 0.002279f, 0.006354f, 0.000166f, 0.001006f, 0.000369f, 0.002746f, 0.001554f, 0.011517f, 0.004300f, 0.013065f,
0.014991f, 0.042962f, 0.000485f, 0.103315f, 0.038688f, 0.215131f, 0.083127f, 0.287366f, 0.010039f, 0.047395f, 0.014996f, 0.138216f, 0.051251f, 0.295722f, 0.095143f, 0.358377f,
0.018629f, 0.047409f, 0.000589f, 0.092506f, 0.027041f, 0.133532f, 0.056850f, 0.144724f, 0.000363f, 0.001522f, 0.000530f, 0.003600f, 0.057004f, 0.292087f, 0.103541f, 0.287203f,
0.023563f, 0.071299f, 0.000611f, 0.127814f, 0.048448f, 0.284457f, 0.083425f, 0.283242f, 0.017379f, 0.086633f, 0.020806f, 0.188330f, 0.083904f, 0.511181f, 0.124826f, 0.461782f,
0.011229f, 0.039894f, 0.000539f, 0.073997f, 0.022831f, 0.157389f, 0.072822f, 0.162154f, 0.006174f, 0.036133f, 0.013690f, 0.081275f, 0.052274f, 0.373928f, 0.144055f, 0.349514f,
0.031453f, 0.086994f, 0.001013f, 0.172378f, 0.100508f, 0.539399f, 0.215063f, 0.593673f, 0.030247f, 0.137818f, 0.044997f, 0.331159f, 0.139582f, 0.777294f, 0.258045f, 0.776150f,
0.012712f, 0.035590f, 0.000354f, 0.078787f, 0.012560f, 0.068234f, 0.023216f, 0.083902f, 0.000271f, 0.001248f, 0.000348f, 0.003351f, 0.035208f, 0.198468f, 0.056226f, 0.221404f,
0.016621f, 0.055330f, 0.000379f, 0.112531f, 0.023263f, 0.150260f, 0.035218f, 0.169746f, 0.013398f, 0.073477f, 0.014102f, 0.181218f, 0.053572f, 0.359057f, 0.070071f, 0.367996f,
0.008463f, 0.033077f, 0.000357f, 0.069607f, 0.011713f, 0.088827f, 0.032845f, 0.103828f, 0.005085f, 0.032743f, 0.009914f, 0.083557f, 0.035660f, 0.280623f, 0.086399f, 0.297589f,
0.029310f, 0.089183f, 0.000830f, 0.200488f, 0.063753f, 0.376398f, 0.119935f, 0.470004f, 0.030805f, 0.154412f, 0.040290f, 0.420949f, 0.117732f, 0.721252f, 0.191355f, 0.817079f,
0.032112f, 0.074589f, 0.000914f, 0.170874f, 0.043811f, 0.197459f, 0.082892f, 0.251262f, 0.000615f, 0.002355f, 0.000810f, 0.006542f, 0.099538f, 0.465515f, 0.162714f, 0.537413f,
0.042516f, 0.117422f, 0.000992f, 0.247138f, 0.082164f, 0.440312f, 0.127329f, 0.514751f, 0.030850f, 0.140361f, 0.033238f, 0.358244f, 0.153363f, 0.852804f, 0.205338f, 0.904502f,
0.028059f, 0.090988f, 0.001212f, 0.198148f, 0.053622f, 0.337390f, 0.153925f, 0.408116f, 0.015177f, 0.081075f, 0.030289f, 0.214107f, 0.132324f, 0.863929f, 0.328177f, 0.948095f,
0.045115f, 0.113890f, 0.001308f, 0.264955f, 0.135499f, 0.663716f, 0.260933f, 0.857664f, 0.042681f, 0.177499f, 0.057143f, 0.500755f, 0.202813f, 1.030836f, 0.337434f, 1.208502f,
0.191721f, 0.298614f, 0.004480f, 0.722810f, 0.188721f, 0.570353f, 0.292988f, 0.766843f, 0.002616f, 0.006712f, 0.002823f, 0.019702f, 0.333254f, 1.045077f, 0.447000f, 1.274774f,
0.197879f, 0.366455f, 0.003787f, 0.814932f, 0.275903f, 0.991431f, 0.350831f, 1.224647f, 0.102216f, 0.311847f, 0.090364f, 0.840975f, 0.400260f, 1.492443f, 0.439731f, 1.672511f,
0.007769f, 0.016893f, 0.000275f, 0.038871f, 0.010712f, 0.045195f, 0.025231f, 0.057764f, 0.002992f, 0.010716f, 0.004899f, 0.029901f, 0.020546f, 0.089947f, 0.041810f, 0.104297f,
0.285005f, 0.482438f, 0.006778f, 1.185875f, 0.617586f, 2.028476f, 0.975853f, 2.769590f, 0.191949f, 0.535273f, 0.210867f, 1.595565f, 0.718460f, 2.448631f, 0.980824f, 3.033136f,
0.313024f, 0.470537f, 0.007284f, 0.938452f, 0.381526f, 1.112817f, 0.589857f, 1.232793f, 0.006133f, 0.015188f, 0.006592f, 0.036733f, 0.706275f, 2.137579f, 0.943406f, 2.148382f,
0.405661f, 0.725040f, 0.007731f, 1.328514f, 0.700353f, 2.428843f, 0.886853f, 2.472020f, 0.300917f, 0.886024f, 0.264922f, 1.968757f, 1.065118f, 3.832916f, 1.165293f, 3.539196f,
0.188624f, 0.395829f, 0.006659f, 0.750456f, 0.322024f, 1.311238f, 0.755342f, 1.380854f, 0.104300f, 0.360572f, 0.170088f, 0.828996f, 0.647479f, 2.735695f, 1.312149f, 2.613706f,
0.560174f, 0.915141f, 0.013267f, 1.853486f, 1.503017f, 4.764444f, 2.365067f, 5.359967f, 0.541777f, 1.458094f, 0.592701f, 3.581205f, 1.833003f, 6.029209f, 2.491983f, 6.153653f,
0.222589f, 0.368093f, 0.004554f, 0.832899f, 0.184670f, 0.592563f, 0.251016f, 0.744762f, 0.004766f, 0.012985f, 0.004504f, 0.035630f, 0.454580f, 1.513550f, 0.533847f, 1.725850f,
0.298194f, 0.586321f, 0.004997f, 1.218867f, 0.350429f, 1.336965f, 0.390136f, 1.543795f, 0.241751f, 0.783077f, 0.187120f, 1.974095f, 0.708672f, 2.805524f, 0.681653f, 2.939045f,
0.148143f, 0.342000f, 0.004598f, 0.735633f, 0.172154f, 0.771166f, 0.355021f, 0.921364f, 0.089526f, 0.340484f, 0.128358f, 0.888125f, 0.460276f, 2.139430f, 0.820082f, 2.319018f,
0.543966f, 0.977628f, 0.011326f, 2.246425f, 0.993481f, 3.464537f, 1.374422f, 4.421930f, 0.574982f, 1.702381f, 0.553033f, 4.743701f, 1.611100f, 5.829849f, 1.925687f, 6.750669f,
0.409679f, 0.562078f, 0.008579f, 1.316171f, 0.469319f, 1.249410f, 0.653007f, 1.625059f, 0.007897f, 0.017848f, 0.007639f, 0.050682f, 0.936375f, 2.586638f, 1.125646f, 3.052266f,
0.555754f, 0.906605f, 0.009532f, 1.950383f, 0.901809f, 2.854528f, 1.027724f, 3.411019f, 0.405567f, 1.089932f, 0.321337f, 2.843435f, 1.478181f, 4.855077f, 1.455432f, 5.263429f,
0.357876f, 0.685455f, 0.011370f, 1.525788f, 0.574250f, 2.134182f, 1.212225f, 2.638732f, 0.194677f, 0.614273f, 0.285715f, 1.658131f, 1.244431f, 4.798987f, 2.269630f, 5.383147f,
0.610059f, 0.909648f, 0.013003f, 2.163079f, 1.538476f, 4.451192f, 2.178700f, 5.879272f, 0.580452f, 1.425832f, 0.571491f, 4.111588f, 2.022190f, 6.070946f, 2.474178f, 7.274890f,
0.118107f, 0.181966f, 0.003068f, 0.487296f, 0.149214f, 0.446075f, 0.257528f, 0.663527f, 0.002405f, 0.006104f, 0.002886f, 0.019821f, 0.405757f, 1.258675f, 0.605039f, 1.698583f,
0.099486f, 0.182247f, 0.002117f, 0.448382f, 0.178034f, 0.632826f, 0.251669f, 0.864810f, 0.076691f, 0.231443f, 0.075372f, 0.690518f, 0.397732f, 1.466970f, 0.485759f, 1.818781f,
0.003174f, 0.006826f, 0.000125f, 0.017377f, 0.005616f, 0.023438f, 0.014706f, 0.033142f, 0.001824f, 0.006462f, 0.003320f, 0.019948f, 0.016588f, 0.071833f, 0.037526f, 0.092150f,
0.131090f, 0.219500f, 0.003466f, 0.596924f, 0.364584f, 1.184527f, 0.640427f, 1.789282f, 0.131755f, 0.363440f, 0.160908f, 1.198561f, 0.653137f, 2.201914f, 0.991239f, 3.017566f,
0.164712f, 0.244915f, 0.004261f, 0.540408f, 0.257664f, 0.743411f, 0.442856f, 0.911137f, 0.004816f, 0.011797f, 0.005755f, 0.031567f, 0.734523f, 2.199020f, 1.090726f, 2.445156f,
0.174208f, 0.307994f, 0.003691f, 0.624359f, 0.386016f, 1.324228f, 0.543407f, 1.491088f, 0.192849f, 0.561683f, 0.188744f, 1.380784f, 0.904040f, 3.218060f, 1.099538f, 3.287437f,
0.065814f, 0.136616f, 0.002583f, 0.286555f, 0.144208f, 0.580843f, 0.376038f, 0.676727f, 0.054308f, 0.185717f, 0.098456f, 0.472390f, 0.446509f, 1.866151f, 1.005941f, 1.972532f,
0.220081f, 0.355649f, 0.005794f, 0.796913f, 0.757889f, 2.376452f, 1.325777f, 2.957786f, 0.317647f, 0.845638f, 0.386319f, 2.297821f, 1.423333f, 4.631042f, 2.151165f, 5.229249f,
0.016520f, 0.027023f, 0.000376f, 0.067647f, 0.017590f, 0.055832f, 0.026581f, 0.077635f, 0.000528f, 0.001423f, 0.000555f, 0.004319f, 0.066679f, 0.219609f, 0.087052f, 0.277042f,
0.018061f, 0.035129f, 0.000336f, 0.080793f, 0.027242f, 0.102809f, 0.033716f, 0.131337f, 0.021852f, 0.070016f, 0.018803f, 0.195276f, 0.084836f, 0.332220f, 0.090716f, 0.385040f,
0.007290f, 0.016648f, 0.000252f, 0.039618f, 0.010873f, 0.048181f, 0.024928f, 0.063686f, 0.006575f, 0.024735f, 0.010479f, 0.071379f, 0.044768f, 0.205838f, 0.088674f, 0.246842f,
0.030142f, 0.053586f, 0.000698f, 0.136226f, 0.070656f, 0.243730f, 0.108666f, 0.344163f, 0.047547f, 0.139253f, 0.050840f, 0.429291f, 0.176447f, 0.631572f, 0.234456f, 0.809096f,
0.242651f, 0.329315f, 0.005649f, 0.853128f, 0.356772f, 0.939512f, 0.551856f, 1.351930f, 0.006980f, 0.015605f, 0.007506f, 0.049025f, 1.096159f, 2.995259f, 1.464910f, 3.910292f,
0.268645f, 0.433501f, 0.005123f, 1.031763f, 0.559493f, 1.751819f, 0.708830f, 2.315940f, 0.292567f, 0.777744f, 0.257697f, 2.244754f, 1.412242f, 4.588310f, 1.545820f, 5.503177f,
0.140554f, 0.266296f, 0.004964f, 0.655796f, 0.289465f, 1.064145f, 0.679303f, 1.455635f, 0.114101f, 0.356134f, 0.186164f, 1.063552f, 0.965977f, 3.684857f, 1.958558f, 4.572937f,
0.269788f, 0.397923f, 0.006393f, 1.046853f, 0.873221f, 2.499107f, 1.374727f, 3.651911f, 0.383073f, 0.930806f, 0.419286f, 2.969535f, 1.767491f, 5.248880f, 2.404095f, 6.958644f,
0.257785f, 0.749584f, 0.008605f, 1.200988f, 0.255711f, 1.442767f, 0.567113f, 1.283994f, 0.004340f, 0.020788f, 0.006691f, 0.040390f, 0.658365f, 3.854449f, 1.261506f, 3.112089f,
0.224323f, 0.775567f, 0.006133f, 1.141626f, 0.315191f, 2.114476f, 0.572540f, 1.728843f, 0.142973f, 0.814329f, 0.180560f, 1.453606f, 0.666687f, 4.640879f, 1.046302f, 3.442516f,
0.008651f, 0.035119f, 0.000438f, 0.053488f, 0.012020f, 0.094680f, 0.040446f, 0.080099f, 0.004110f, 0.027487f, 0.009615f, 0.050767f, 0.033614f, 0.274735f, 0.097719f, 0.210864f,
0.259037f, 0.818601f, 0.008800f, 1.331908f, 0.565650f, 3.468510f, 1.276806f, 3.134679f, 0.215256f, 1.120642f, 0.337807f, 2.211113f, 0.959433f, 6.104620f, 1.871087f, 5.005318f,
0.474274f, 1.330970f, 0.015765f, 1.757078f, 0.582529f, 3.172053f, 1.286562f, 2.326009f, 0.011465f, 0.053006f, 0.017605f, 0.084858f, 1.572279f, 8.883849f, 3.000164f, 5.910103f,
0.518206f, 1.729118f, 0.014109f, 2.097169f, 0.901569f, 5.837197f, 1.630889f, 3.932434f, 0.474293f, 2.607170f, 0.596498f, 3.834603f, 1.999134f, 13.430630f, 3.124423f, 8.208736f,
0.236681f, 0.927248f, 0.011936f, 1.163639f, 0.407189f, 3.095367f, 1.364400f, 2.157661f, 0.161476f, 1.042178f, 0.376176f, 1.586013f, 1.193702f, 9.415873f, 3.455761f, 5.954624f,
0.573715f, 1.749780f, 0.019410f, 2.345792f, 1.551239f, 9.180155f, 3.486975f, 6.836038f, 0.684627f, 3.439870f, 1.069942f, 5.592298f, 2.758291f, 16.937930f, 5.356888f, 11.442940f,
0.296934f, 0.916720f, 0.008678f, 1.373018f, 0.248254f, 1.487154f, 0.482048f, 1.237211f, 0.007845f, 0.039901f, 0.010591f, 0.072471f, 0.890988f, 5.538353f, 1.494748f, 4.180146f,
0.335385f, 1.231128f, 0.008028f, 1.694060f, 0.397180f, 2.828980f, 0.631675f, 2.162240f, 0.335485f, 2.028772f, 0.370951f, 3.385331f, 1.171100f, 8.655377f, 1.609174f, 6.001817f,
0.163663f, 0.705375f, 0.007257f, 1.004291f, 0.191659f, 1.602815f, 0.564621f, 1.267568f, 0.122034f, 0.866466f, 0.249945f, 1.496005f, 0.747126f, 6.483298f, 1.901615f, 4.651645f,
0.490511f, 1.645789f, 0.014590f, 2.503209f, 0.902774f, 5.877436f, 1.784146f, 4.965456f, 0.639724f, 3.536048f, 0.878982f, 6.522038f, 2.134541f, 14.419900f, 3.644669f, 11.052390f,
0.531967f, 1.362576f, 0.015914f, 2.111937f, 0.614117f, 3.052188f, 1.220651f, 2.627724f, 0.012651f, 0.053385f, 0.017483f, 0.100342f, 1.786468f, 9.213063f, 3.067876f, 7.196069f,
0.608431f, 1.852979f, 0.014908f, 2.638619f, 0.994915f, 5.879341f, 1.619715f, 4.650324f, 0.547839f, 2.748607f, 0.620072f, 4.746365f, 2.377722f, 14.579840f, 3.344384f, 10.462370f,
0.384846f, 1.376122f, 0.017467f, 2.027575f, 0.622298f, 4.317692f, 1.876598f, 3.533622f, 0.258304f, 1.521599f, 0.541551f, 2.718708f, 1.966211f, 14.155720f, 5.122774f, 10.510500f,
0.535468f, 1.490592f, 0.016304f, 2.346184f, 1.360803f, 7.350275f, 2.752913f, 6.426218f, 0.628622f, 2.882800f, 0.884143f, 5.502503f, 2.607886f, 14.616580f, 4.558145f, 11.593660f,
0.080775f, 0.212998f, 0.002567f, 0.504403f, 0.107355f, 0.549292f, 0.226639f, 0.722525f, 0.001361f, 0.005913f, 0.001998f, 0.016980f, 0.220595f, 1.171192f, 0.402358f, 1.397657f,
0.076326f, 0.239307f, 0.001986f, 0.520645f, 0.143689f, 0.874156f, 0.248456f, 1.056391f, 0.048693f, 0.251506f, 0.058537f, 0.663556f, 0.242566f, 1.531246f, 0.362376f, 1.678819f,
0.002578f, 0.009489f, 0.000124f, 0.021361f, 0.004799f, 0.034276f, 0.015370f, 0.042859f, 0.001226f, 0.007434f, 0.002730f, 0.020294f, 0.010710f, 0.079379f, 0.029637f, 0.090049f,
0.098346f, 0.281840f, 0.003180f, 0.677779f, 0.287735f, 1.600016f, 0.618249f, 2.137262f, 0.081802f, 0.386198f, 0.122199f, 1.126257f, 0.389510f, 2.247496f, 0.723089f, 2.723672f,
0.175341f, 0.446230f, 0.005548f, 0.870691f, 0.288551f, 1.424890f, 0.606637f, 1.544314f, 0.004243f, 0.017788f, 0.006202f, 0.042090f, 0.621574f, 3.184937f, 1.129021f, 3.131683f,
0.208035f, 0.629498f, 0.005392f, 1.128459f, 0.484934f, 2.847243f, 0.835030f, 2.835076f, 0.190587f, 0.950061f, 0.228164f, 2.065311f, 0.858192f, 5.228478f, 1.276750f, 4.723220f,
0.083204f, 0.295605f, 0.003994f, 0.548299f, 0.191790f, 1.322146f, 0.611739f, 1.362176f, 0.056820f, 0.332560f, 0.126002f, 0.748029f, 0.448730f, 3.209862f, 1.236593f, 3.000289f,
0.256995f, 0.710801f, 0.008277f, 1.408436f, 0.931017f, 4.996497f, 1.992148f, 5.499245f, 0.306969f, 1.398683f, 0.456662f, 3.360863f, 1.321228f, 7.357573f, 2.442553f, 7.346742f,
0.107078f, 0.299786f, 0.002979f, 0.663643f, 0.119946f, 0.651601f, 0.221704f, 0.801222f, 0.002832f, 0.013061f, 0.003639f, 0.035062f, 0.343574f, 1.936714f, 0.548669f, 2.160525f,
0.131329f, 0.437177f, 0.002992f, 0.889132f, 0.208380f, 1.345970f, 0.315469f, 1.520521f, 0.131494f, 0.721108f, 0.138402f, 1.778490f, 0.490368f, 3.286625f, 0.641393f, 3.368448f,
0.056120f, 0.219342f, 0.002369f, 0.461577f, 0.088053f, 0.667784f, 0.246926f, 0.780561f, 0.041885f, 0.269690f, 0.081661f, 0.688225f, 0.273948f, 2.155792f, 0.663729f, 2.286128f,
0.214320f, 0.652115f, 0.006068f, 1.465986f, 0.528498f, 3.120245f, 0.994233f, 3.896215f, 0.279781f, 1.402429f, 0.365932f, 3.823217f, 0.997304f, 6.109725f, 1.620969f, 6.921476f,
0.256208f, 0.595121f, 0.007296f, 1.363354f, 0.396288f, 1.786105f, 0.749799f, 2.272786f, 0.006099f, 0.023339f, 0.008023f, 0.064837f, 0.920053f, 4.302871f, 1.504005f, 4.967440f,
0.318199f, 0.878809f, 0.007422f, 1.849625f, 0.697147f, 3.735971f, 1.080366f, 4.367582f, 0.286783f, 1.304816f, 0.308984f, 3.330280f, 1.329714f, 7.394115f, 1.780356f, 7.842356f,
0.176247f, 0.571515f, 0.007615f, 1.244602f, 0.381842f, 2.402555f, 1.096100f, 2.906195f, 0.118407f, 0.632534f, 0.236309f, 1.670433f, 0.962884f, 6.286551f, 2.388046f, 6.899008f,
0.312476f, 0.788820f, 0.009057f, 1.835120f, 1.063969f, 5.211633f, 2.048896f, 6.734552f, 0.367185f, 1.527026f, 0.491600f, 4.307996f, 1.627350f, 8.271319f, 2.707536f, 9.696888f,
0.337360f, 0.525452f, 0.007883f, 1.271883f, 0.376481f, 1.137800f, 0.584483f, 1.529778f, 0.005717f, 0.014670f, 0.006171f, 0.043061f, 0.679346f, 2.130412f, 0.911219f, 2.598656f,
0.326613f, 0.604862f, 0.006251f, 1.345106f, 0.516286f, 1.855226f, 0.656497f, 2.291634f, 0.209561f, 0.639342f, 0.185263f, 1.724152f, 0.765368f, 2.853814f, 0.840843f, 3.198135f,
0.010763f, 0.023402f, 0.000382f, 0.053847f, 0.016823f, 0.070978f, 0.039625f, 0.090717f, 0.005147f, 0.018439f, 0.008429f, 0.051450f, 0.032972f, 0.144348f, 0.067098f, 0.167377f,
0.435348f, 0.736927f, 0.010353f, 1.811432f, 1.069498f, 3.512789f, 1.689921f, 4.796205f, 0.364189f, 1.015583f, 0.400082f, 3.027297f, 1.271388f, 4.333105f, 1.735669f, 5.367445f,
0.686016f, 1.031218f, 0.015963f, 2.056689f, 0.947937f, 2.764900f, 1.465555f, 3.062993f, 0.016695f, 0.041343f, 0.017945f, 0.099992f, 1.793176f, 5.427146f, 2.395233f, 5.454574f,
0.833935f, 1.490497f, 0.015894f, 2.731084f, 1.632243f, 5.660666f, 2.066902f, 5.761294f, 0.768374f, 2.262413f, 0.676462f, 5.027110f, 2.536643f, 9.128320f, 2.775216f, 8.428808f,
0.325435f, 0.682926f, 0.011489f, 1.294767f, 0.629875f, 2.564762f, 1.477437f, 2.700930f, 0.223515f, 0.772709f, 0.364500f, 1.776545f, 1.294151f, 5.467978f, 2.622661f, 5.224153f,
1.065713f, 1.741024f, 0.025239f, 3.526195f, 3.241753f, 10.276100f, 5.101049f, 11.560540f, 1.280249f, 3.445559f, 1.400587f, 8.462591f, 4.039919f, 13.288310f, 5.492304f, 13.562590f,
0.436562f, 0.721937f, 0.008931f, 1.633558f, 0.410618f, 1.317576f, 0.558138f, 1.655995f, 0.011611f, 0.031633f, 0.010973f, 0.086800f, 1.032870f, 3.438996f, 1.212974f, 3.921370f,
0.548597f, 1.078674f, 0.009192f, 2.242390f, 0.730893f, 2.788520f, 0.813710f, 3.219906f, 0.552433f, 1.789437f, 0.427594f, 4.511072f, 1.510401f, 5.979449f, 1.452816f, 6.264023f,
0.228735f, 0.528054f, 0.007100f, 1.135830f, 0.301348f, 1.349892f, 0.621448f, 1.612807f, 0.171696f, 0.652990f, 0.246168f, 1.703270f, 0.823310f, 3.826862f, 1.466905f, 4.148096f,
0.926134f, 1.664471f, 0.019284f, 3.824675f, 1.917613f, 6.687239f, 2.652905f, 8.535197f, 1.215945f, 3.600116f, 1.169528f, 10.031760f, 3.177736f, 11.498800f, 3.798225f, 13.315020f,
0.761090f, 1.044214f, 0.015938f, 2.445147f, 0.988462f, 2.631460f, 1.375338f, 3.422636f, 0.018222f, 0.041185f, 0.017627f, 0.116950f, 2.015279f, 5.566996f, 2.422630f, 6.569126f,
0.968472f, 1.579877f, 0.016612f, 3.398794f, 1.781634f, 5.639470f, 2.030396f, 6.738889f, 0.877860f, 2.359183f, 0.695542f, 6.154681f, 2.984180f, 9.801525f, 2.938255f, 10.625920f,
0.523401f, 1.002493f, 0.016629f, 2.231499f, 0.952145f, 3.538612f, 2.009949f, 4.375189f, 0.353650f, 1.115889f, 0.519030f, 3.012164f, 2.108462f, 8.131014f, 3.845477f, 9.120766f,
0.983840f, 1.466988f, 0.020970f, 3.488393f, 2.812826f, 8.138200f, 3.983360f, 10.749190f, 1.162723f, 2.856134f, 1.144772f, 8.236065f, 3.778049f, 11.342320f, 4.622496f, 13.591640f,
0.055140f, 0.084953f, 0.001432f, 0.227500f, 0.091622f, 0.273903f, 0.158130f, 0.407425f, 0.001224f, 0.003106f, 0.001468f, 0.010086f, 0.216577f, 0.671831f, 0.322946f, 0.906637f,
0.076377f, 0.139914f, 0.001625f, 0.344231f, 0.179765f, 0.638979f, 0.254116f, 0.873218f, 0.064174f, 0.193667f, 0.063070f, 0.577811f, 0.349101f, 1.287600f, 0.426364f, 1.596394f,
0.001863f, 0.004007f, 0.000073f, 0.010201f, 0.004336f, 0.018097f, 0.011354f, 0.025589f, 0.001167f, 0.004135f, 0.002124f, 0.012764f, 0.011133f, 0.048212f, 0.025186f, 0.061848f,
0.080719f, 0.135157f, 0.002134f, 0.367557f, 0.295259f, 0.959291f, 0.518651f, 1.449052f, 0.088426f, 0.243919f, 0.107992f, 0.804403f, 0.459798f, 1.550112f, 0.697816f, 2.124318f,
0.082151f, 0.122153f, 0.002125f, 0.269531f, 0.169021f, 0.487658f, 0.290501f, 0.597681f, 0.002618f, 0.006413f, 0.003128f, 0.017160f, 0.418841f, 1.253929f, 0.621956f, 1.394281f,
0.142879f, 0.252605f, 0.003027f, 0.512075f, 0.416394f, 1.428440f, 0.586172f, 1.608431f, 0.172395f, 0.502110f, 0.168726f, 1.234336f, 0.847705f, 3.017527f, 1.031021f, 3.082580f,
0.041275f, 0.085678f, 0.001620f, 0.179712f, 0.118949f, 0.479102f, 0.310171f, 0.558191f, 0.037123f, 0.126949f, 0.067301f, 0.322908f, 0.320152f, 1.338054f, 0.721273f, 1.414330f,
0.144772f, 0.233951f, 0.003812f, 0.524220f, 0.655704f, 2.056039f, 1.147025f, 2.558993f, 0.227748f, 0.606311f, 0.276985f, 1.647506f, 1.070450f, 3.482881f, 1.617833f, 3.932776f,
0.007939f, 0.012987f, 0.000181f, 0.032512f, 0.011119f, 0.035292f, 0.016802f, 0.049074f, 0.000277f, 0.000745f, 0.000291f, 0.002262f, 0.036639f, 0.120670f, 0.047833f, 0.152228f,
0.014274f, 0.027763f, 0.000266f, 0.063852f, 0.028317f, 0.106865f, 0.035046f, 0.136519f, 0.018823f, 0.060313f, 0.016197f, 0.168214f, 0.076656f, 0.300184f, 0.081969f, 0.347911f,
0.004406f, 0.010061f, 0.000152f, 0.023942f, 0.008643f, 0.038295f, 0.019814f, 0.050620f, 0.004331f, 0.016292f, 0.006903f, 0.047017f, 0.030932f, 0.142219f, 0.061267f, 0.170549f,
0.019107f, 0.033967f, 0.000442f, 0.086351f, 0.058905f, 0.203197f, 0.090594f, 0.286927f, 0.032850f, 0.096210f, 0.035126f, 0.296597f, 0.127873f, 0.457707f, 0.169913f, 0.586361f,
0.119837f, 0.162637f, 0.002790f, 0.421332f, 0.231739f, 0.610255f, 0.358455f, 0.878139f, 0.003757f, 0.008400f, 0.004040f, 0.026390f, 0.618928f, 1.691225f, 0.827138f, 2.207883f,
0.218173f, 0.352057f, 0.004160f, 0.837920f, 0.597609f, 1.871164f, 0.757120f, 2.473716f, 0.258974f, 0.688443f, 0.228108f, 1.987009f, 1.311261f, 4.260229f, 1.435288f, 5.109679f,
0.087284f, 0.165370f, 0.003083f, 0.407250f, 0.236422f, 0.869147f, 0.554825f, 1.188899f, 0.077231f, 0.241054f, 0.126007f, 0.719879f, 0.685830f, 2.616198f, 1.390550f, 3.246723f,
0.175731f, 0.259194f, 0.004164f, 0.681886f, 0.748083f, 2.140969f, 1.177720f, 3.128568f, 0.271967f, 0.660835f, 0.297676f, 2.108252f, 1.316255f, 3.908856f, 1.790337f, 5.182123f,
0.100576f, 0.292453f, 0.003357f, 0.468570f, 0.131215f, 0.740340f, 0.291008f, 0.658867f, 0.001845f, 0.008840f, 0.002845f, 0.017176f, 0.293670f, 1.719313f, 0.562706f, 1.388176f,
0.143920f, 0.497586f, 0.003935f, 0.732440f, 0.265963f, 1.784230f, 0.483119f, 1.458827f, 0.099979f, 0.569451f, 0.126264f, 1.016491f, 0.489021f, 3.404129f, 0.767472f, 2.525118f,
0.004244f, 0.017229f, 0.000215f, 0.026241f, 0.007756f, 0.061091f, 0.026097f, 0.051683f, 0.002198f, 0.014698f, 0.005141f, 0.027146f, 0.018854f, 0.154095f, 0.054809f, 0.118271f,
0.133295f, 0.421235f, 0.004528f, 0.685371f, 0.382824f, 2.347437f, 0.864124f, 2.121506f, 0.120730f, 0.628531f, 0.189465f, 1.240140f, 0.564447f, 3.591429f, 1.100786f, 2.944695f,
0.197680f, 0.554755f, 0.006571f, 0.732358f, 0.319337f, 1.738891f, 0.705282f, 1.275098f, 0.005209f, 0.024081f, 0.007998f, 0.038551f, 0.749237f, 4.233415f, 1.429666f, 2.816338f,
0.355180f, 1.185142f, 0.009670f, 1.437405f, 0.812726f, 5.261986f, 1.470177f, 3.544923f, 0.354324f, 1.947705f, 0.445618f, 2.864668f, 1.566552f, 10.524450f, 2.448346f, 6.432491f,
0.124045f, 0.485972f, 0.006256f, 0.609865f, 0.280680f, 2.133670f, 0.940496f, 1.487299f, 0.092243f, 0.595341f, 0.214889f, 0.906004f, 0.715268f, 5.642004f, 2.070697f, 3.568019f,
0.315387f, 0.961905f, 0.010670f, 1.289550f, 1.121571f, 6.637404f, 2.521141f, 4.942568f, 0.410214f, 2.061099f, 0.641087f, 3.350789f, 1.733588f, 10.645500f, 3.366809f, 7.191896f,
0.119261f, 0.368192f, 0.003485f, 0.551460f, 0.131139f, 0.785585f, 0.254640f, 0.653553f, 0.003434f, 0.017467f, 0.004636f, 0.031726f, 0.409135f, 2.543170f, 0.686377f, 1.919492f,
0.221511f, 0.813119f, 0.005302f, 1.118870f, 0.345015f, 2.457425f, 0.548712f, 1.878254f, 0.241508f, 1.460469f, 0.267039f, 2.437026f, 0.884305f, 6.535729f, 1.215098f, 4.532009f,
0.082655f, 0.356238f, 0.003665f, 0.507201f, 0.127306f, 1.064642f, 0.375040f, 0.841960f, 0.067175f, 0.476958f, 0.137586f, 0.823497f, 0.431391f, 3.743466f, 1.097996f, 2.685867f,
0.259838f, 0.871822f, 0.007729f, 1.326022f, 0.628974f, 4.094880f, 1.243036f, 3.459493f, 0.369364f, 2.041644f, 0.507507f, 3.765695f, 1.292753f, 8.733195f, 2.207339f, 6.693715f,
0.219553f, 0.562363f, 0.006568f, 0.871639f, 0.333355f, 1.656787f, 0.662593f, 1.426379f, 0.005691f, 0.024015f, 0.007865f, 0.045138f, 0.842962f, 4.347273f, 1.447607f, 3.395535f,
0.412934f, 1.257591f, 0.010118f, 1.790794f, 0.888085f, 5.248040f, 1.445797f, 4.150990f, 0.405257f, 2.033245f, 0.458690f, 3.511059f, 1.844961f, 11.313030f, 2.595029f, 8.118132f,
0.199722f, 0.714160f, 0.009065f, 1.052242f, 0.424754f, 2.947067f, 1.280884f, 2.411895f, 0.146109f, 0.860691f, 0.306328f, 1.537834f, 1.166611f, 8.399009f, 3.039493f, 6.236189f,
0.291478f, 0.811391f, 0.008875f, 1.277126f, 0.974241f, 5.262293f, 1.970896f, 4.600731f, 0.372966f, 1.710387f, 0.524569f, 3.264677f, 1.622996f, 9.096512f, 2.836724f, 7.215219f,
0.023222f, 0.061236f, 0.000738f, 0.145013f, 0.040593f, 0.207698f, 0.085696f, 0.273201f, 0.000427f, 0.001853f, 0.000626f, 0.005321f, 0.072507f, 0.384959f, 0.132251f, 0.459396f,
0.036084f, 0.113135f, 0.000939f, 0.246141f, 0.089344f, 0.543540f, 0.154487f, 0.656852f, 0.025091f, 0.129598f, 0.030163f, 0.341923f, 0.131108f, 0.827647f, 0.195866f, 0.907410f,
0.000932f, 0.003430f, 0.000045f, 0.007722f, 0.002282f, 0.016297f, 0.007308f, 0.020378f, 0.000483f, 0.002929f, 0.001076f, 0.007996f, 0.004426f, 0.032808f, 0.012249f, 0.037218f,
0.037291f, 0.106868f, 0.001206f, 0.257000f, 0.143495f, 0.797939f, 0.308325f, 1.065867f, 0.033808f, 0.159611f, 0.050504f, 0.465469f, 0.168858f, 0.974320f, 0.313469f, 1.180749f,
0.053853f, 0.137052f, 0.001704f, 0.267418f, 0.116560f, 0.575583f, 0.245050f, 0.623824f, 0.001420f, 0.005955f, 0.002076f, 0.014090f, 0.218261f, 1.118368f, 0.396448f, 1.099668f,
0.105069f, 0.317932f, 0.002723f, 0.569935f, 0.322123f, 1.891316f, 0.554679f, 1.883234f, 0.104916f, 0.522997f, 0.125602f, 1.136930f, 0.495543f, 3.019065f, 0.737230f, 2.727315f,
0.032133f, 0.114162f, 0.001543f, 0.211752f, 0.097417f, 0.671566f, 0.310725f, 0.691899f, 0.023918f, 0.139987f, 0.053039f, 0.314874f, 0.198131f, 1.417272f, 0.546001f, 1.324738f,
0.104104f, 0.287933f, 0.003353f, 0.570532f, 0.496021f, 2.662000f, 1.061363f, 2.929851f, 0.135533f, 0.617548f, 0.201626f, 1.483890f, 0.611896f, 3.407490f, 1.131212f, 3.402474f,
0.031691f, 0.088725f, 0.000882f, 0.196411f, 0.046689f, 0.253638f, 0.086299f, 0.311878f, 0.000913f, 0.004213f, 0.001174f, 0.011310f, 0.116254f, 0.655322f, 0.185652f, 0.731052f,
0.063916f, 0.212766f, 0.001456f, 0.432724f, 0.133383f, 0.861549f, 0.201930f, 0.973278f, 0.069752f, 0.382520f, 0.073417f, 0.943419f, 0.272850f, 1.828742f, 0.356884f, 1.874270f,
0.020885f, 0.081627f, 0.000881f, 0.171774f, 0.043098f, 0.326851f, 0.120859f, 0.382051f, 0.016990f, 0.109393f, 0.033124f, 0.279160f, 0.116557f, 0.917231f, 0.282399f, 0.972686f,
0.083659f, 0.254549f, 0.002369f, 0.572239f, 0.271326f, 1.601903f, 0.510430f, 2.000279f, 0.119035f, 0.596674f, 0.155688f, 1.626616f, 0.445074f, 2.726634f, 0.723402f, 3.088900f,
0.077919f, 0.180990f, 0.002219f, 0.414628f, 0.158511f, 0.714425f, 0.299912f, 0.909092f, 0.002022f, 0.007736f, 0.002659f, 0.021492f, 0.319904f, 1.496117f, 0.522946f, 1.727189f,
0.159134f, 0.439499f, 0.003712f, 0.925011f, 0.458550f, 2.457346f, 0.710614f, 2.872789f, 0.156324f, 0.711247f, 0.168425f, 1.815315f, 0.760289f, 4.227723f, 1.017952f, 4.484013f,
0.067399f, 0.218555f, 0.002912f, 0.475952f, 0.192051f, 1.208387f, 0.551293f, 1.461697f, 0.049354f, 0.263648f, 0.098497f, 0.696258f, 0.420983f, 2.748543f, 1.044078f, 3.016316f,
0.125338f, 0.316405f, 0.003633f, 0.736089f, 0.561299f, 2.749410f, 1.080900f, 3.552829f, 0.160531f, 0.667607f, 0.214925f, 1.883430f, 0.746284f, 3.793132f, 1.241645f, 4.446882f,
0.153272f, 0.238728f, 0.003581f, 0.577853f, 0.224964f, 0.679885f, 0.349254f, 0.914109f, 0.002831f, 0.007264f, 0.003056f, 0.021324f, 0.352873f, 1.106601f, 0.473315f, 1.349820f,
0.244015f, 0.451897f, 0.004670f, 1.004939f, 0.507310f, 1.822971f, 0.645083f, 2.251791f, 0.170648f, 0.520625f, 0.150862f, 1.403999f, 0.653749f, 2.437621f, 0.718216f, 2.731727f,
0.006148f, 0.013369f, 0.000218f, 0.030762f, 0.012640f, 0.053331f, 0.029773f, 0.068162f, 0.003205f, 0.011481f, 0.005249f, 0.032036f, 0.021536f, 0.094280f, 0.043825f, 0.109322f,
0.260869f, 0.441582f, 0.006204f, 1.085446f, 0.842880f, 2.768458f, 1.331841f, 3.779928f, 0.237860f, 0.663300f, 0.261302f, 1.977194f, 0.871007f, 2.968538f, 1.189078f, 3.677147f,
0.332967f, 0.500516f, 0.007748f, 0.998242f, 0.605127f, 1.765006f, 0.935554f, 1.955297f, 0.008832f, 0.021872f, 0.009493f, 0.052898f, 0.995055f, 3.011591f, 1.329144f, 3.026810f,
0.665599f, 1.189628f, 0.012686f, 2.179794f, 1.713424f, 5.942204f, 2.169701f, 6.047837f, 0.668438f, 1.968160f, 0.588481f, 4.373276f, 2.314712f, 8.329684f, 2.532412f, 7.691372f,
0.198616f, 0.416796f, 0.007012f, 0.790209f, 0.505596f, 2.058718f, 1.185930f, 2.168020f, 0.148684f, 0.514013f, 0.242469f, 1.181775f, 0.903010f, 3.815349f, 1.829994f, 3.645217f,
0.682218f, 1.114521f, 0.016157f, 2.257302f, 2.729373f, 8.651895f, 4.294795f, 9.733322f, 0.893277f, 2.404092f, 0.977241f, 5.904659f, 2.956740f, 9.725466f, 4.019713f, 9.926201f,
0.204182f, 0.337654f, 0.004177f, 0.764023f, 0.252587f, 0.810490f, 0.343332f, 1.018664f, 0.005919f, 0.016126f, 0.005594f, 0.044249f, 0.552300f, 1.838913f, 0.648606f, 2.096850f,
0.421929f, 0.829613f, 0.007070f, 1.724632f, 0.739331f, 2.820713f, 0.823105f, 3.257079f, 0.463099f, 1.500065f, 0.358448f, 3.781581f, 1.328113f, 5.257798f, 1.277478f, 5.508027f,
0.134520f, 0.310552f, 0.004175f, 0.667988f, 0.233090f, 1.044129f, 0.480684f, 1.247491f, 0.110058f, 0.418572f, 0.157796f, 1.091810f, 0.553575f, 2.573092f, 0.986312f, 2.789083f,
0.571298f, 1.026750f, 0.011896f, 2.359299f, 1.555783f, 5.425439f, 2.152334f, 6.924710f, 0.817543f, 2.420544f, 0.786334f, 6.744870f, 2.241111f, 8.109575f, 2.678714f, 9.390476f,
0.365786f, 0.501857f, 0.007660f, 1.175156f, 0.624813f, 1.663362f, 0.869360f, 2.163469f, 0.009545f, 0.021575f, 0.009234f, 0.061263f, 1.107344f, 3.058922f, 1.331174f, 3.609568f,
0.765404f, 1.248610f, 0.013128f, 2.686139f, 1.851918f, 5.861942f, 2.110493f, 7.004731f, 0.756200f, 2.032233f, 0.599150f, 5.301726f, 2.696410f, 8.856344f, 2.654913f, 9.601237f,
0.316307f, 0.605835f, 0.010050f, 1.348559f, 0.756791f, 2.812588f, 1.597563f, 3.477522f, 0.232946f, 0.735026f, 0.341880f, 1.984085f, 1.456788f, 5.617918f, 2.656934f, 6.301762f,
0.623636f, 0.929893f, 0.013292f, 2.211219f, 2.345033f, 6.784760f, 3.320899f, 8.961521f, 0.803324f, 1.973301f, 0.790922f, 5.690290f, 2.737986f, 8.219883f, 3.349965f, 9.849988f,
0.161370f, 0.248620f, 0.004192f, 0.665793f, 0.189552f, 0.566667f, 0.327148f, 0.842904f, 0.003525f, 0.008948f, 0.004230f, 0.029058f, 0.409473f, 1.270203f, 0.610581f, 1.714140f,
0.153272f, 0.280776f, 0.003261f, 0.690794f, 0.255022f, 0.906482f, 0.360500f, 1.238783f, 0.126773f, 0.382582f, 0.124592f, 1.141445f, 0.452591f, 1.669305f, 0.552758f, 2.069640f,
0.005148f, 0.011072f, 0.000203f, 0.028187f, 0.008470f, 0.035349f, 0.022178f, 0.049983f, 0.003174f, 0.011246f, 0.005778f, 0.034718f, 0.019873f, 0.086061f, 0.044959f, 0.110403f,
0.165676f, 0.277410f, 0.004380f, 0.754409f, 0.428410f, 1.391897f, 0.752544f, 2.102523f, 0.178663f, 0.492833f, 0.218194f, 1.625276f, 0.609686f, 2.055427f, 0.925295f, 2.816816f,
0.223397f, 0.332176f, 0.005779f, 0.732949f, 0.324922f, 0.937464f, 0.558454f, 1.148971f, 0.007008f, 0.017168f, 0.008375f, 0.045937f, 0.735819f, 2.202899f, 1.092650f, 2.449469f,
0.266425f, 0.471030f, 0.005645f, 0.954862f, 0.548890f, 1.882969f, 0.772691f, 2.120233f, 0.316448f, 0.921673f, 0.309713f, 2.265746f, 1.021193f, 3.635084f, 1.242026f, 3.713451f,
0.105973f, 0.219978f, 0.004159f, 0.461408f, 0.215895f, 0.869582f, 0.562967f, 1.013129f, 0.093826f, 0.320855f, 0.170099f, 0.816125f, 0.531033f, 2.219413f, 1.196366f, 2.345932f,
0.276106f, 0.446185f, 0.007269f, 0.999781f, 0.884043f, 2.772022f, 1.546459f, 3.450123f, 0.427580f, 1.138301f, 0.520018f, 3.093064f, 1.318906f, 4.291274f, 1.993340f, 4.845592f,
0.013541f, 0.022151f, 0.000308f, 0.055452f, 0.013406f, 0.042552f, 0.020258f, 0.059169f, 0.000464f, 0.001251f, 0.000488f, 0.003798f, 0.040371f, 0.132962f, 0.052706f, 0.167735f,
0.016694f, 0.032470f, 0.000311f, 0.074678f, 0.023411f, 0.088353f, 0.028975f, 0.112871f, 0.021671f, 0.069438f, 0.018648f, 0.193663f, 0.057918f, 0.226808f, 0.061933f, 0.262869f,
0.007095f, 0.016202f, 0.000245f, 0.038555f, 0.009839f, 0.043595f, 0.022555f, 0.057625f, 0.006865f, 0.025827f, 0.010942f, 0.074531f, 0.032179f, 0.147954f, 0.063738f, 0.177428f,
0.022855f, 0.040631f, 0.000529f, 0.103292f, 0.049811f, 0.171826f, 0.076608f, 0.242630f, 0.038682f, 0.113289f, 0.041361f, 0.349250f, 0.098817f, 0.353706f, 0.131305f, 0.453127f,
0.342361f, 0.464635f, 0.007970f, 1.203693f, 0.468021f, 1.232473f, 0.723936f, 1.773492f, 0.010566f, 0.023624f, 0.011363f, 0.074216f, 1.142322f, 3.121399f, 1.526602f, 4.074966f,
0.427401f, 0.689678f, 0.008150f, 1.641481f, 0.827608f, 2.591310f, 1.048509f, 3.425763f, 0.499413f, 1.327614f, 0.439890f, 3.831807f, 1.659506f, 5.391662f, 1.816473f, 6.466709f,
0.235435f, 0.446059f, 0.008316f, 1.098489f, 0.450813f, 1.657303f, 1.057948f, 2.267011f, 0.205068f, 0.640057f, 0.334581f, 1.911457f, 1.195109f, 4.558915f, 2.423134f, 5.657650f,
0.352100f, 0.519329f, 0.008343f, 1.366247f, 1.059599f, 3.032509f, 1.668145f, 4.431364f, 0.536419f, 1.303412f, 0.587128f, 4.158251f, 1.703783f, 5.059687f, 2.317441f, 6.707825f,
0.327716f, 0.952929f, 0.010939f, 1.526789f, 0.302248f, 1.705338f, 0.670323f, 1.517670f, 0.005919f, 0.028355f, 0.009127f, 0.055093f, 0.618189f, 3.619232f, 1.184523f, 2.922174f,
0.321565f, 1.111769f, 0.008791f, 1.636512f, 0.420090f, 2.818201f, 0.763089f, 2.304225f, 0.219901f, 1.252489f, 0.277713f, 2.235737f, 0.705880f, 4.913707f, 1.107812f, 3.644894f,
0.013057f, 0.053004f, 0.000661f, 0.080728f, 0.016868f, 0.132862f, 0.056756f, 0.112400f, 0.006656f, 0.044511f, 0.015570f, 0.082210f, 0.037472f, 0.306262f, 0.108933f, 0.235062f,
0.304610f, 0.962620f, 0.010349f, 1.566235f, 0.618449f, 3.792271f, 1.395987f, 3.427280f, 0.271592f, 1.413931f, 0.426216f, 2.789796f, 0.833318f, 5.302185f, 1.625138f, 4.347383f,
0.598516f, 1.679634f, 0.019895f, 2.217365f, 0.683499f, 3.721864f, 1.509562f, 2.729176f, 0.015524f, 0.071772f, 0.023838f, 0.114900f, 1.465512f, 8.280586f, 2.796436f, 5.508774f,
0.737401f, 2.460514f, 0.020077f, 2.984245f, 1.192817f, 7.722882f, 2.157741f, 5.202792f, 0.724148f, 3.980608f, 0.910728f, 5.854642f, 2.101149f, 14.115990f, 3.283860f, 8.627622f,
0.354598f, 1.389210f, 0.017883f, 1.743374f, 0.567208f, 4.311796f, 1.900587f, 3.005586f, 0.259573f, 1.675301f, 0.604703f, 2.549515f, 1.320936f, 10.419490f, 3.824102f, 6.589314f,
0.669706f, 2.042546f, 0.022658f, 2.738280f, 1.683608f, 9.963509f, 3.784523f, 7.419365f, 0.857474f, 4.308332f, 1.340070f, 7.004183f, 2.378166f, 14.603680f, 4.618646f, 9.865965f,
0.226474f, 0.699190f, 0.006619f, 1.047212f, 0.176047f, 1.054601f, 0.341840f, 0.877357f, 0.006420f, 0.032653f, 0.008667f, 0.059306f, 0.501931f, 3.119988f, 0.842055f, 2.354852f,
0.288441f, 1.058807f, 0.006904f, 1.456942f, 0.317595f, 2.262129f, 0.505104f, 1.728985f, 0.309575f, 1.872085f, 0.342301f, 3.123874f, 0.743912f, 5.498108f, 1.022187f, 3.812501f,
0.148195f, 0.638711f, 0.006571f, 0.909377f, 0.161357f, 1.349404f, 0.475352f, 1.067161f, 0.118562f, 0.841811f, 0.242833f, 1.453438f, 0.499680f, 4.336049f, 1.271806f, 3.111035f,
0.346059f, 1.161114f, 0.010293f, 1.766029f, 0.592180f, 3.855339f, 1.170321f, 3.257121f, 0.484253f, 2.676688f, 0.665364f, 4.936998f, 1.112292f, 7.514095f, 1.899208f, 5.759314f,
0.698362f, 1.788778f, 0.020892f, 2.772533f, 0.749585f, 3.725469f, 1.489914f, 3.207373f, 0.017820f, 0.075196f, 0.024626f, 0.141337f, 1.732227f, 8.933331f, 2.974728f, 6.977579f,
0.900663f, 2.742971f, 0.022069f, 3.905956f, 1.369338f, 8.091951f, 2.229273f, 6.400409f, 0.870127f, 4.365582f, 0.984853f, 7.538598f, 2.599713f, 15.941050f, 3.656626f, 11.439170f,
0.599804f, 2.144759f, 0.027223f, 3.160083f, 0.901767f, 6.256728f, 2.719361f, 5.120539f, 0.431947f, 2.544490f, 0.905607f, 4.546352f, 2.263422f, 16.295490f, 5.897128f, 12.099260f,
0.650237f, 1.810075f, 0.019798f, 2.849049f, 1.536409f, 8.298802f, 3.108166f, 7.255498f, 0.819042f, 3.756049f, 1.151965f, 7.169303f, 2.339053f, 13.109840f, 4.088271f, 10.398530f,
0.118105f, 0.311436f, 0.003753f, 0.737513f, 0.145944f, 0.746739f, 0.308106f, 0.982243f, 0.002135f, 0.009276f, 0.003134f, 0.026638f, 0.238233f, 1.264835f, 0.434528f, 1.509407f,
0.125840f, 0.394549f, 0.003275f, 0.858399f, 0.220264f, 1.340016f, 0.380864f, 1.619369f, 0.086137f, 0.444912f, 0.103551f, 1.173826f, 0.295387f, 1.864686f, 0.441286f, 2.044394f,
0.004475f, 0.016472f, 0.000216f, 0.037080f, 0.007745f, 0.055320f, 0.024806f, 0.069173f, 0.002283f, 0.013846f, 0.005084f, 0.037797f, 0.013731f, 0.101774f, 0.037998f, 0.115454f,
0.133012f, 0.381186f, 0.004302f, 0.916689f, 0.361827f, 2.012021f, 0.777449f, 2.687608f, 0.118707f, 0.560433f, 0.177330f, 1.634370f, 0.389105f, 2.245157f, 0.722336f, 2.720839f,
0.254496f, 0.647674f, 0.008053f, 1.263753f, 0.389398f, 1.922885f, 0.818655f, 2.084046f, 0.006607f, 0.027702f, 0.009658f, 0.065547f, 0.666353f, 3.414385f, 1.210357f, 3.357294f,
0.340477f, 1.030260f, 0.008824f, 1.846879f, 0.737920f, 4.332628f, 1.270658f, 4.314113f, 0.334676f, 1.668335f, 0.400664f, 3.626746f, 1.037411f, 6.320360f, 1.543379f, 5.709587f,
0.143373f, 0.509373f, 0.006883f, 0.944803f, 0.307273f, 2.118249f, 0.980085f, 2.182383f, 0.105052f, 0.614856f, 0.232959f, 1.382997f, 0.571114f, 4.085299f, 1.573853f, 3.818569f,
0.345036f, 0.954307f, 0.011112f, 1.890938f, 1.162176f, 6.237056f, 2.486770f, 6.864629f, 0.442195f, 2.014830f, 0.657830f, 4.841386f, 1.310182f, 7.296059f, 2.422132f, 7.285319f,
0.093931f, 0.262980f, 0.002613f, 0.582163f, 0.097829f, 0.531455f, 0.180825f, 0.653487f, 0.002665f, 0.012293f, 0.003425f, 0.033001f, 0.222610f, 1.254843f, 0.355496f, 1.399856f,
0.129905f, 0.432437f, 0.002960f, 0.879491f, 0.191644f, 1.237869f, 0.290132f, 1.398400f, 0.139556f, 0.765323f, 0.146888f, 1.887537f, 0.358262f, 2.401204f, 0.468601f, 2.460984f,
0.058446f, 0.228432f, 0.002467f, 0.480706f, 0.085262f, 0.646615f, 0.239098f, 0.755817f, 0.046803f, 0.301357f, 0.091249f, 0.769034f, 0.210726f, 1.658276f, 0.510553f, 1.758533f,
0.173906f, 0.529147f, 0.004924f, 1.189549f, 0.398722f, 2.354047f, 0.750092f, 2.939472f, 0.243585f, 1.220990f, 0.318589f, 3.328590f, 0.597714f, 3.661743f, 0.971496f, 4.148250f,
0.386848f, 0.898572f, 0.011016f, 2.058525f, 0.556329f, 2.507427f, 1.052606f, 3.190655f, 0.009881f, 0.037810f, 0.012997f, 0.105038f, 1.026063f, 4.798655f, 1.677299f, 5.539796f,
0.541753f, 1.496225f, 0.012636f, 3.149097f, 1.103572f, 5.913980f, 1.710201f, 6.913809f, 0.523883f, 2.383585f, 0.564439f, 6.083619f, 1.672146f, 9.298273f, 2.238840f, 9.861945f,
0.315933f, 1.024474f, 0.013650f, 2.231023f, 0.636401f, 4.004245f, 1.826828f, 4.843643f, 0.227735f, 1.216567f, 0.454498f, 3.212782f, 1.274856f, 8.323376f, 3.161767f, 9.134267f,
0.436422f, 1.101710f, 0.012649f, 2.563031f, 1.381632f, 6.767642f, 2.660623f, 8.745250f, 0.550241f, 2.288311f, 0.736683f, 6.455706f, 1.678743f, 8.532534f, 2.793042f, 10.003120f,
0.409265f, 0.637447f, 0.009563f, 1.542972f, 0.424646f, 1.283367f, 0.659260f, 1.725493f, 0.007442f, 0.019095f, 0.008032f, 0.056049f, 0.608718f, 1.908922f, 0.816484f, 2.328484f,
0.446786f, 0.827413f, 0.008551f, 1.840018f, 0.656644f, 2.359590f, 0.834972f, 2.914640f, 0.307578f, 0.938378f, 0.271915f, 2.530581f, 0.773303f, 2.883402f, 0.849560f, 3.231292f,
0.015501f, 0.033704f, 0.000550f, 0.077553f, 0.022528f, 0.095046f, 0.053062f, 0.121478f, 0.007954f, 0.028493f, 0.013026f, 0.079506f, 0.035075f, 0.153554f, 0.071377f, 0.178052f,
0.488528f, 0.826947f, 0.011618f, 2.032708f, 1.115853f, 3.665042f, 1.763167f, 5.004085f, 0.438489f, 1.222777f, 0.481705f, 3.644910f, 1.053768f, 3.591417f, 1.438579f, 4.448712f,
0.826135f, 1.241844f, 0.019224f, 2.476768f, 1.061378f, 3.095779f, 1.640940f, 3.429545f, 0.021572f, 0.053420f, 0.023187f, 0.129200f, 1.594973f, 4.827273f, 2.130483f, 4.851669f,
1.132410f, 2.023963f, 0.021582f, 3.708572f, 2.060774f, 7.146823f, 2.609549f, 7.273870f, 1.119497f, 3.296267f, 0.985585f, 7.324345f, 2.544162f, 9.155376f, 2.783441f, 8.453790f,
0.465272f, 0.976374f, 0.016426f, 1.851119f, 0.837280f, 3.409287f, 1.963928f, 3.590293f, 0.342869f, 1.185325f, 0.559138f, 2.725196f, 1.366600f, 5.774083f, 2.769482f, 5.516609f,
1.187132f, 1.939383f, 0.028115f, 3.927942f, 3.357474f, 10.642930f, 5.283141f, 11.973220f, 1.530144f, 4.118104f, 1.673971f, 10.114420f, 3.323879f, 10.933080f, 4.518841f, 11.158740f,
0.317742f, 0.525447f, 0.006500f, 1.188950f, 0.277870f, 0.891617f, 0.377698f, 1.120629f, 0.009068f, 0.024703f, 0.008569f, 0.067784f, 0.555250f, 1.848734f, 0.652070f, 2.108049f,
0.450233f, 0.885267f, 0.007544f, 1.840327f, 0.557714f, 2.127805f, 0.620909f, 2.456977f, 0.486455f, 1.575721f, 0.376526f, 3.972306f, 0.915567f, 3.624590f, 0.880660f, 3.797091f,
0.197645f, 0.456282f, 0.006135f, 0.981451f, 0.242102f, 1.084496f, 0.499268f, 1.295720f, 0.159182f, 0.605397f, 0.228226f, 1.579128f, 0.525451f, 2.442370f, 0.936204f, 2.647388f,
0.623513f, 1.120592f, 0.012983f, 2.574932f, 1.200345f, 4.185930f, 1.660607f, 5.342674f, 0.878343f, 2.600558f, 0.844813f, 7.246480f, 1.580166f, 5.717911f, 1.888712f, 6.621050f,
0.953460f, 1.308144f, 0.019967f, 3.063171f, 1.151331f, 3.065045f, 1.601953f, 3.986583f, 0.024493f, 0.055359f, 0.023693f, 0.157198f, 1.864726f, 5.151109f, 2.241646f, 6.078375f,
1.368070f, 2.231744f, 0.023466f, 4.801158f, 2.339988f, 7.406847f, 2.666710f, 8.850816f, 1.330531f, 3.575705f, 1.054201f, 9.328364f, 3.113579f, 10.226530f, 3.065663f, 11.086670f,
0.778443f, 1.490985f, 0.024733f, 3.318859f, 1.316646f, 4.893268f, 2.779400f, 6.050104f, 0.564346f, 1.780705f, 0.828253f, 4.806729f, 2.316176f, 8.932038f, 4.224312f, 10.019290f,
1.140074f, 1.699945f, 0.024300f, 4.042348f, 3.030576f, 8.768203f, 4.291724f, 11.581320f, 1.445651f, 3.551124f, 1.423332f, 10.240170f, 3.233625f, 9.707871f, 3.956386f, 11.633060f,
};

static const float acceptor_me2x3acc5[16384] = {
0.008602f, 0.120562f, 0.000004f, 0.088841f, 0.006477f, 0.082328f, 0.000037f, 0.118493f, 0.001347f, 0.025650f, 0.000001f, 0.015608f, 0.008022f, 0.078301f, 0.000010f, 0.090715f,
0.010717f, 0.107252f, 0.000027f, 0.114039f, 0.009805f, 0.088994f, 0.000306f, 0.184821f, 0.014729f, 0.200307f, 0.000034f, 0.175875f, 0.015004f, 0.104573f, 0.000102f, 0.174814f,
0.000185f, 0.002733f, 0.000003f, 0.002511f, 0.000165f, 0.002207f, 0.000029f, 0.003960f, 0.000166f, 0.003334f, 0.000002f, 0.002529f, 0.000169f, 0.001734f, 0.000006f, 0.002506f,
0.016295f, 0.164076f, 0.000076f, 0.163631f, 0.022160f, 0.202370f, 0.001262f, 0.394198f, 0.024095f, 0.329686f, 0.000100f, 0.271508f, 0.044644f, 0.313057f, 0.000552f, 0.490855f,
0.008946f, 0.158159f, 0.000028f, 0.102085f, 0.007099f, 0.113822f, 0.000273f, 0.143496f, 0.001548f, 0.037199f, 0.000004f, 0.019827f, 0.006010f, 0.073990f, 0.000050f, 0.075084f,
0.039041f, 0.492823f, 0.000677f, 0.458992f, 0.037644f, 0.430968f, 0.007995f, 0.783978f, 0.059318f, 1.017524f, 0.000920f, 0.782561f, 0.039372f, 0.346120f, 0.001816f, 0.506814f,
0.005822f, 0.108483f, 0.000565f, 0.087313f, 0.005463f, 0.092327f, 0.006493f, 0.145141f, 0.005778f, 0.146299f, 0.000501f, 0.097233f, 0.003822f, 0.049596f, 0.000987f, 0.062757f,
0.030575f, 0.388328f, 0.000968f, 0.339225f, 0.043822f, 0.504779f, 0.016995f, 0.861261f, 0.049981f, 0.862619f, 0.001415f, 0.622252f, 0.060339f, 0.533702f, 0.005083f, 0.732984f,
0.000359f, 0.005415f, 0.000002f, 0.003942f, 0.000256f, 0.003504f, 0.000022f, 0.004983f, 0.000085f, 0.001739f, 0.000001f, 0.001045f, 0.000352f, 0.003695f, 0.000006f, 0.004230f,
0.000553f, 0.005954f, 0.000021f, 0.006254f, 0.000480f, 0.004682f, 0.000224f, 0.009606f, 0.001147f, 0.016780f, 0.000039f, 0.014555f, 0.000814f, 0.006100f, 0.000083f, 0.010074f,
0.000241f, 0.003826f, 0.000051f, 0.003473f, 0.000203f, 0.002928f, 0.000532f, 0.005191f, 0.000326f, 0.007042f, 0.000062f, 0.005279f, 0.000231f, 0.002551f, 0.000131f, 0.003641f,
0.000820f, 0.008879f, 0.000057f, 0.008748f, 0.001057f, 0.010378f, 0.000902f, 0.019971f, 0.001830f, 0.026922f, 0.000114f, 0.021903f, 0.002361f, 0.017801f, 0.000438f, 0.027573f,
0.021364f, 0.239581f, 0.000096f, 0.128936f, 0.017000f, 0.172901f, 0.000940f, 0.181746f, 0.003462f, 0.052760f, 0.000014f, 0.023447f, 0.022598f, 0.176486f, 0.000271f, 0.149328f,
0.047887f, 0.383459f, 0.001195f, 0.297774f, 0.046302f, 0.336264f, 0.014157f, 0.510028f, 0.068124f, 0.741289f, 0.001521f, 0.475352f, 0.076044f, 0.424067f, 0.005050f, 0.517738f,
0.014583f, 0.172370f, 0.002037f, 0.115672f, 0.013723f, 0.147108f, 0.023477f, 0.192819f, 0.013550f, 0.217648f, 0.001693f, 0.120609f, 0.015074f, 0.124085f, 0.005601f, 0.130917f,
0.098077f, 0.790184f, 0.004471f, 0.575534f, 0.140961f, 1.030003f, 0.078699f, 1.465299f, 0.150112f, 1.643474f, 0.006120f, 0.988473f, 0.304774f, 1.710042f, 0.036958f, 1.958200f,
0.023448f, 0.425815f, 0.000002f, 0.192385f, 0.012998f, 0.214069f, 0.000013f, 0.188907f, 0.002727f, 0.067285f, 0.000000f, 0.025103f, 0.014411f, 0.182256f, 0.000003f, 0.129462f,
0.030761f, 0.398883f, 0.000014f, 0.260041f, 0.020720f, 0.243668f, 0.000114f, 0.310269f, 0.031400f, 0.553300f, 0.000013f, 0.297863f, 0.028383f, 0.256310f, 0.000034f, 0.262706f,
0.000456f, 0.008735f, 0.000001f, 0.004921f, 0.000299f, 0.005193f, 0.000009f, 0.005715f, 0.000304f, 0.007914f, 0.000001f, 0.003682f, 0.000274f, 0.003654f, 0.000002f, 0.003236f,
0.038821f, 0.506482f, 0.000032f, 0.309696f, 0.038868f, 0.459901f, 0.000391f, 0.549263f, 0.042634f, 0.755866f, 0.000031f, 0.381658f, 0.070094f, 0.636866f, 0.000153f, 0.612247f,
0.042977f, 0.984438f, 0.000024f, 0.389587f, 0.025107f, 0.521579f, 0.000170f, 0.403164f, 0.005525f, 0.171969f, 0.000003f, 0.056199f, 0.019026f, 0.303508f, 0.000028f, 0.188840f,
0.197487f, 3.230102f, 0.000605f, 1.844500f, 0.140188f, 2.079541f, 0.005261f, 2.319395f, 0.222858f, 4.953288f, 0.000611f, 2.335689f, 0.131253f, 1.495054f, 0.001070f, 1.342229f,
0.025313f, 0.611129f, 0.000434f, 0.301575f, 0.017488f, 0.382910f, 0.003672f, 0.369067f, 0.018658f, 0.612116f, 0.000286f, 0.249434f, 0.010951f, 0.184127f, 0.000499f, 0.142852f,
0.128371f, 2.112536f, 0.000718f, 1.131464f, 0.135454f, 2.021639f, 0.009282f, 2.114878f, 0.155856f, 3.485356f, 0.000780f, 1.541498f, 0.166957f, 1.913410f, 0.002485f, 1.611210f,
0.012231f, 0.238836f, 0.000015f, 0.106602f, 0.006425f, 0.113788f, 0.000096f, 0.099199f, 0.002146f, 0.056951f, 0.000002f, 0.020990f, 0.007899f, 0.107416f, 0.000026f, 0.075377f,
0.019831f, 0.276523f, 0.000134f, 0.178091f, 0.012659f, 0.160084f, 0.001046f, 0.201374f, 0.030548f, 0.578822f, 0.000184f, 0.307833f, 0.019227f, 0.186706f, 0.000345f, 0.189050f,
0.007420f, 0.152711f, 0.000280f, 0.084993f, 0.004609f, 0.086040f, 0.002131f, 0.093531f, 0.007465f, 0.208790f, 0.000252f, 0.095957f, 0.004683f, 0.067119f, 0.000470f, 0.058730f,
0.024396f, 0.342259f, 0.000300f, 0.206747f, 0.023147f, 0.294523f, 0.003492f, 0.347495f, 0.040430f, 0.770787f, 0.000445f, 0.384484f, 0.046285f, 0.452216f, 0.001517f, 0.429475f,
0.062235f, 0.904301f, 0.000050f, 0.298389f, 0.036458f, 0.480456f, 0.000356f, 0.309648f, 0.007491f, 0.147907f, 0.000005f, 0.040301f, 0.043384f, 0.439010f, 0.000092f, 0.227747f,
0.146893f, 1.524084f, 0.000648f, 0.725647f, 0.104564f, 0.983940f, 0.005649f, 0.915019f, 0.155205f, 2.188273f, 0.000612f, 0.860354f, 0.153727f, 1.110782f, 0.001804f, 0.831482f,
0.038448f, 0.588839f, 0.000949f, 0.242278f, 0.026636f, 0.369973f, 0.008052f, 0.297325f, 0.026534f, 0.552221f, 0.000586f, 0.187624f, 0.026192f, 0.279358f, 0.001720f, 0.180711f,
0.249707f, 2.606741f, 0.002011f, 1.164096f, 0.264217f, 2.501532f, 0.026066f, 2.181934f, 0.283858f, 4.026763f, 0.002045f, 1.484930f, 0.511382f, 3.717760f, 0.010958f, 2.610235f,
0.000101f, 0.001933f, 0.000000f, 0.001329f, 0.000074f, 0.001281f, 0.000000f, 0.001721f, 0.000012f, 0.000312f, 0.000000f, 0.000177f, 0.000087f, 0.001166f, 0.000000f, 0.001261f,
0.000144f, 0.001961f, 0.000000f, 0.001946f, 0.000127f, 0.001579f, 0.000001f, 0.003061f, 0.000150f, 0.002782f, 0.000000f, 0.002280f, 0.000187f, 0.001776f, 0.000000f, 0.002771f,
0.000002f, 0.000050f, 0.000000f, 0.000043f, 0.000002f, 0.000039f, 0.000000f, 0.000066f, 0.000002f, 0.000047f, 0.000000f, 0.000033f, 0.000002f, 0.000030f, 0.000000f, 0.000040f,
0.000221f, 0.003041f, 0.000000f, 0.002831f, 0.000292f, 0.003639f, 0.000005f, 0.006617f, 0.000248f, 0.004640f, 0.000000f, 0.003567f, 0.000563f, 0.005389f, 0.000002f, 0.007887f,
0.000092f, 0.002219f, 0.000000f, 0.001337f, 0.000071f, 0.001550f, 0.000001f, 0.001824f, 0.000012f, 0.000396f, 0.000000f, 0.000197f, 0.000057f, 0.000964f, 0.000000f, 0.000913f,
0.000458f, 0.007888f, 0.000002f, 0.006857f, 0.000428f, 0.006694f, 0.000028f, 0.011366f, 0.000528f, 0.012368f, 0.000002f, 0.008879f, 0.000429f, 0.005145f, 0.000006f, 0.007033f,
0.000069f, 0.001748f, 0.000002f, 0.001314f, 0.000063f, 0.001444f, 0.000022f, 0.002119f, 0.000052f, 0.001791f, 0.000001f, 0.001111f, 0.000042f, 0.000742f, 0.000003f, 0.000877f,
0.000363f, 0.006299f, 0.000003f, 0.005137f, 0.000505f, 0.007946f, 0.000059f, 0.012656f, 0.000451f, 0.010627f, 0.000004f, 0.007156f, 0.000666f, 0.008041f, 0.000017f, 0.010309f,
0.000063f, 0.001291f, 0.000000f, 0.000877f, 0.000043f, 0.000811f, 0.000001f, 0.001076f, 0.000011f, 0.000315f, 0.000000f, 0.000177f, 0.000057f, 0.000818f, 0.000000f, 0.000874f,
0.000110f, 0.001619f, 0.000001f, 0.001587f, 0.000093f, 0.001235f, 0.000013f, 0.002366f, 0.000174f, 0.003465f, 0.000002f, 0.002805f, 0.000151f, 0.001540f, 0.000005f, 0.002374f,
0.000048f, 0.001047f, 0.000003f, 0.000887f, 0.000040f, 0.000778f, 0.000031f, 0.001287f, 0.000050f, 0.001464f, 0.000003f, 0.001025f, 0.000043f, 0.000649f, 0.000007f, 0.000864f,
0.000165f, 0.002447f, 0.000003f, 0.002250f, 0.000207f, 0.002775f, 0.000053f, 0.004985f, 0.000280f, 0.005634f, 0.000005f, 0.004279f, 0.000442f, 0.004556f, 0.000025f, 0.006587f,
0.000256f, 0.003928f, 0.000000f, 0.001973f, 0.000198f, 0.002751f, 0.000003f, 0.002699f, 0.000032f, 0.000657f, 0.000000f, 0.000272f, 0.000252f, 0.002687f, 0.000001f, 0.002122f,
0.000656f, 0.007170f, 0.000005f, 0.005197f, 0.000615f, 0.006102f, 0.000057f, 0.008639f, 0.000708f, 0.010527f, 0.000005f, 0.006301f, 0.000967f, 0.007365f, 0.000019f, 0.008393f,
0.000201f, 0.003246f, 0.000008f, 0.002033f, 0.000184f, 0.002688f, 0.000095f, 0.003289f, 0.000142f, 0.003112f, 0.000005f, 0.001610f, 0.000193f, 0.002170f, 0.000022f, 0.002137f,
0.001361f, 0.014975f, 0.000019f, 0.010182f, 0.001899f, 0.018943f, 0.000321f, 0.025155f, 0.001582f, 0.023655f, 0.000020f, 0.013280f, 0.003929f, 0.030101f, 0.000144f, 0.032175f,
0.048065f, 0.526778f, 0.000004f, 0.266123f, 0.027016f, 0.268534f, 0.000026f, 0.264972f, 0.004941f, 0.073584f, 0.000000f, 0.030697f, 0.029348f, 0.224004f, 0.000006f, 0.177918f,
0.062734f, 0.490950f, 0.000027f, 0.357880f, 0.042847f, 0.304108f, 0.000226f, 0.432986f, 0.056609f, 0.602015f, 0.000022f, 0.362382f, 0.057507f, 0.313418f, 0.000066f, 0.359197f,
0.000683f, 0.007895f, 0.000002f, 0.004974f, 0.000454f, 0.004760f, 0.000013f, 0.005856f, 0.000403f, 0.006324f, 0.000001f, 0.003289f, 0.000408f, 0.003281f, 0.000003f, 0.003249f,
0.070282f, 0.553397f, 0.000055f, 0.378366f, 0.071352f, 0.509538f, 0.000686f, 0.680450f, 0.068233f, 0.730084f, 0.000048f, 0.412199f, 0.126075f, 0.691333f, 0.000263f, 0.743139f,
0.076511f, 1.057705f, 0.000041f, 0.468043f, 0.045323f, 0.568246f, 0.000294f, 0.491136f, 0.008695f, 0.163336f, 0.000004f, 0.059684f, 0.033652f, 0.323977f, 0.000047f, 0.225394f,
0.349789f, 3.452846f, 0.001025f, 2.204672f, 0.251779f, 2.254072f, 0.009036f, 2.811121f, 0.348941f, 4.680688f, 0.000915f, 2.467946f, 0.230965f, 1.587759f, 0.001800f, 1.593892f,
0.032924f, 0.479731f, 0.000540f, 0.264707f, 0.023064f, 0.304791f, 0.004632f, 0.328483f, 0.021453f, 0.424770f, 0.000315f, 0.193544f, 0.014151f, 0.143598f, 0.000617f, 0.124573f,
0.201845f, 2.004687f, 0.001080f, 1.200571f, 0.215963f, 1.945295f, 0.014153f, 2.275472f, 0.216635f, 2.923780f, 0.001037f, 1.445922f, 0.260807f, 1.803920f, 0.003712f, 1.698502f,
0.033638f, 0.396442f, 0.000039f, 0.197856f, 0.017918f, 0.191521f, 0.000256f, 0.186694f, 0.005218f, 0.083567f, 0.000005f, 0.034440f, 0.021583f, 0.177140f, 0.000067f, 0.138993f,
0.054265f, 0.456663f, 0.000350f, 0.328859f, 0.035124f, 0.268072f, 0.002775f, 0.377060f, 0.073893f, 0.845016f, 0.000426f, 0.502503f, 0.052270f, 0.306330f, 0.000897f, 0.346826f,
0.014909f, 0.185199f, 0.000538f, 0.115254f, 0.009392f, 0.105805f, 0.004152f, 0.128608f, 0.013261f, 0.223837f, 0.000428f, 0.115029f, 0.009348f, 0.080868f, 0.000898f, 0.079123f,
0.059261f, 0.501765f, 0.000698f, 0.338914f, 0.057016f, 0.437829f, 0.008225f, 0.577615f, 0.086819f, 0.998931f, 0.000915f, 0.557165f, 0.111701f, 0.658656f, 0.003500f, 0.699447f,
0.123079f, 1.079335f, 0.000094f, 0.398228f, 0.073112f, 0.581482f, 0.000683f, 0.419041f, 0.013096f, 0.156059f, 0.000009f, 0.047547f, 0.085240f, 0.520577f, 0.000173f, 0.301973f,
0.289025f, 1.809827f, 0.001219f, 0.963514f, 0.208620f, 1.184776f, 0.010779f, 1.231976f, 0.269957f, 2.297126f, 0.001019f, 1.009868f, 0.300506f, 1.310460f, 0.003372f, 1.096863f,
0.055554f, 0.513486f, 0.001311f, 0.236238f, 0.039026f, 0.327145f, 0.011282f, 0.293972f, 0.033892f, 0.425696f, 0.000715f, 0.161726f, 0.037599f, 0.242025f, 0.002361f, 0.175060f,
0.436161f, 2.747941f, 0.003360f, 1.372153f, 0.467969f, 2.673960f, 0.044148f, 2.607925f, 0.438301f, 3.752500f, 0.003020f, 1.547302f, 0.887419f, 3.893656f, 0.018184f, 3.056753f,
0.016101f, 0.225655f, 0.000007f, 0.166283f, 0.010485f, 0.133276f, 0.000059f, 0.191823f, 0.002168f, 0.041288f, 0.000001f, 0.025124f, 0.012140f, 0.118493f, 0.000015f, 0.137278f,
0.019346f, 0.193609f, 0.000049f, 0.205861f, 0.015309f, 0.138948f, 0.000477f, 0.288567f, 0.022866f, 0.310968f, 0.000052f, 0.273038f, 0.021899f, 0.152627f, 0.000148f, 0.255145f,
0.000426f, 0.006296f, 0.000006f, 0.005785f, 0.000328f, 0.004398f, 0.000057f, 0.007892f, 0.000329f, 0.006605f, 0.000004f, 0.005012f, 0.000314f, 0.003231f, 0.000012f, 0.004667f,
0.028736f, 0.289346f, 0.000134f, 0.288562f, 0.033800f, 0.308668f, 0.001924f, 0.601256f, 0.036542f, 0.500003f, 0.000152f, 0.411769f, 0.063654f, 0.446359f, 0.000787f, 0.699866f,
0.012635f, 0.223371f, 0.000040f, 0.144177f, 0.008672f, 0.139038f, 0.000333f, 0.175286f, 0.001881f, 0.045182f, 0.000005f, 0.024082f, 0.006863f, 0.084488f, 0.000057f, 0.085737f,
0.053179f, 0.671292f, 0.000922f, 0.625209f, 0.044350f, 0.507735f, 0.009420f, 0.923626f, 0.069487f, 1.191965f, 0.001078f, 0.916721f, 0.043361f, 0.381185f, 0.002000f, 0.558158f,
0.010122f, 0.188602f, 0.000982f, 0.151797f, 0.008215f, 0.138831f, 0.009763f, 0.218245f, 0.008639f, 0.218738f, 0.000750f, 0.145377f, 0.005372f, 0.069713f, 0.001387f, 0.088214f,
0.040686f, 0.516739f, 0.001288f, 0.451398f, 0.050436f, 0.580958f, 0.019560f, 0.991240f, 0.057197f, 0.987163f, 0.001620f, 0.712093f, 0.064917f, 0.574194f, 0.005468f, 0.788597f,
0.000738f, 0.011118f, 0.000005f, 0.008093f, 0.000455f, 0.006223f, 0.000038f, 0.008848f, 0.000150f, 0.003070f, 0.000001f, 0.001845f, 0.000584f, 0.006134f, 0.000011f, 0.007021f,
0.001096f, 0.011790f, 0.000042f, 0.012384f, 0.000822f, 0.008018f, 0.000384f, 0.016451f, 0.001954f, 0.028575f, 0.000067f, 0.024786f, 0.001303f, 0.009766f, 0.000132f, 0.016128f,
0.000609f, 0.009669f, 0.000130f, 0.008777f, 0.000444f, 0.006400f, 0.001162f, 0.011347f, 0.000709f, 0.015306f, 0.000135f, 0.011473f, 0.000471f, 0.005213f, 0.000268f, 0.007440f,
0.001586f, 0.017175f, 0.000111f, 0.016921f, 0.001768f, 0.017363f, 0.001510f, 0.033413f, 0.003044f, 0.044787f, 0.000190f, 0.036437f, 0.003692f, 0.027840f, 0.000685f, 0.043124f,
0.036557f, 0.409966f, 0.000165f, 0.220633f, 0.025160f, 0.255895f, 0.001391f, 0.268986f, 0.005095f, 0.077642f, 0.000021f, 0.034505f, 0.031265f, 0.244170f, 0.000375f, 0.206597f,
0.079031f, 0.632848f, 0.001973f, 0.491437f, 0.066093f, 0.479992f, 0.020208f, 0.728026f, 0.096689f, 1.052124f, 0.002159f, 0.674674f, 0.101469f, 0.565852f, 0.006739f, 0.690842f,
0.030718f, 0.363083f, 0.004291f, 0.243655f, 0.025001f, 0.268012f, 0.042772f, 0.351291f, 0.024547f, 0.394273f, 0.003067f, 0.218487f, 0.025673f, 0.211327f, 0.009540f, 0.222961f,
0.158125f, 1.273972f, 0.007208f, 0.927903f, 0.196564f, 1.436292f, 0.109742f, 2.043291f, 0.208135f, 2.278732f, 0.008486f, 1.370551f, 0.397281f, 2.229089f, 0.048176f, 2.552569f,
0.056658f, 1.028896f, 0.000005f, 0.464860f, 0.027164f, 0.447379f, 0.000027f, 0.394795f, 0.005666f, 0.139820f, 0.000000f, 0.052165f, 0.028154f, 0.356059f, 0.000006f, 0.252918f,
0.071688f, 0.929572f, 0.000032f, 0.606009f, 0.041763f, 0.491142f, 0.000230f, 0.625386f, 0.062932f, 1.108910f, 0.000025f, 0.596969f, 0.053479f, 0.482939f, 0.000064f, 0.494989f,
0.001357f, 0.025982f, 0.000003f, 0.014638f, 0.000770f, 0.013360f, 0.000024f, 0.014701f, 0.000778f, 0.020245f, 0.000002f, 0.009418f, 0.000659f, 0.008787f, 0.000004f, 0.007783f,
0.088380f, 1.153063f, 0.000073f, 0.705056f, 0.076533f, 0.905576f, 0.000770f, 1.081535f, 0.083473f, 1.479898f, 0.000061f, 0.747242f, 0.129021f, 1.172263f, 0.000282f, 1.126947f,
0.078359f, 1.794891f, 0.000043f, 0.710321f, 0.039593f, 0.822511f, 0.000269f, 0.635775f, 0.008663f, 0.269648f, 0.000004f, 0.088120f, 0.028047f, 0.447413f, 0.000041f, 0.278377f,
0.347276f, 5.680052f, 0.001064f, 3.243506f, 0.213216f, 3.162828f, 0.008002f, 3.527628f, 0.337026f, 7.490797f, 0.000924f, 3.532234f, 0.186610f, 2.125599f, 0.001521f, 1.908320f,
0.056813f, 1.371618f, 0.000974f, 0.676855f, 0.033947f, 0.743309f, 0.007129f, 0.716435f, 0.036013f, 1.181496f, 0.000552f, 0.481453f, 0.019872f, 0.334123f, 0.000906f, 0.259224f,
0.220524f, 3.629038f, 0.001234f, 1.943696f, 0.201256f, 3.003745f, 0.013792f, 3.142278f, 0.230255f, 5.149119f, 0.001152f, 2.277344f, 0.231889f, 2.657565f, 0.003452f, 2.237836f,
0.032417f, 0.633031f, 0.000040f, 0.282546f, 0.014729f, 0.260852f, 0.000220f, 0.227407f, 0.004892f, 0.129814f, 0.000005f, 0.047846f, 0.016926f, 0.230188f, 0.000055f, 0.161531f,
0.050695f, 0.706874f, 0.000342f, 0.455253f, 0.027988f, 0.353940f, 0.002312f, 0.445231f, 0.067156f, 1.272492f, 0.000405f, 0.676744f, 0.039738f, 0.385885f, 0.000713f, 0.390730f,
0.024208f, 0.498250f, 0.000914f, 0.277305f, 0.013007f, 0.242799f, 0.006013f, 0.263939f, 0.020946f, 0.585845f, 0.000707f, 0.269248f, 0.012352f, 0.177054f, 0.001240f, 0.154926f,
0.060923f, 0.854707f, 0.000750f, 0.516300f, 0.049996f, 0.636141f, 0.007542f, 0.750556f, 0.086830f, 1.655372f, 0.000957f, 0.825733f, 0.093452f, 0.913055f, 0.003062f, 0.867140f,
0.137481f, 1.997666f, 0.000110f, 0.659164f, 0.069659f, 0.917984f, 0.000680f, 0.591631f, 0.014231f, 0.280994f, 0.000010f, 0.076564f, 0.077486f, 0.784103f, 0.000164f, 0.406772f,
0.312965f, 3.247172f, 0.001381f, 1.546044f, 0.192686f, 1.813164f, 0.010411f, 1.686159f, 0.284380f, 4.009555f, 0.001122f, 1.576419f, 0.264811f, 1.913435f, 0.003108f, 1.432312f,
0.104553f, 1.601243f, 0.002581f, 0.658830f, 0.062648f, 0.870165f, 0.018938f, 0.699299f, 0.062053f, 1.291432f, 0.001370f, 0.438780f, 0.057587f, 0.614199f, 0.003781f, 0.397313f,
0.519730f, 5.425572f, 0.004186f, 2.422905f, 0.475642f, 4.503246f, 0.046924f, 3.927908f, 0.508097f, 7.207789f, 0.003660f, 2.657981f, 0.860561f, 6.256299f, 0.018440f, 4.392540f,
0.010795f, 0.206582f, 0.000002f, 0.142097f, 0.006822f, 0.118399f, 0.000012f, 0.159069f, 0.001104f, 0.028706f, 0.000000f, 0.016305f, 0.007560f, 0.100752f, 0.000003f, 0.108957f,
0.014795f, 0.202168f, 0.000011f, 0.200656f, 0.011361f, 0.140795f, 0.000107f, 0.272943f, 0.013280f, 0.246609f, 0.000009f, 0.202119f, 0.015554f, 0.148024f, 0.000032f, 0.230983f,
0.000328f, 0.006620f, 0.000001f, 0.005678f, 0.000245f, 0.004487f, 0.000013f, 0.007517f, 0.000192f, 0.005275f, 0.000001f, 0.003736f, 0.000225f, 0.003155f, 0.000003f, 0.004255f,
0.022273f, 0.306228f, 0.000031f, 0.285075f, 0.025423f, 0.317006f, 0.000438f, 0.576404f, 0.021510f, 0.401888f, 0.000027f, 0.308943f, 0.045824f, 0.438762f, 0.000171f, 0.642170f,
0.007415f, 0.178996f, 0.000007f, 0.107846f, 0.004939f, 0.108118f, 0.000057f, 0.127234f, 0.000838f, 0.027497f, 0.000001f, 0.013681f, 0.003741f, 0.062882f, 0.000009f, 0.059565f,
0.035598f, 0.613575f, 0.000187f, 0.533425f, 0.028808f, 0.450341f, 0.001850f, 0.764702f, 0.035326f, 0.827418f, 0.000166f, 0.594005f, 0.026958f, 0.323600f, 0.000376f, 0.442305f,
0.006823f, 0.173590f, 0.000200f, 0.130416f, 0.005374f, 0.123997f, 0.001931f, 0.181954f, 0.004422f, 0.152899f, 0.000116f, 0.094857f, 0.003363f, 0.059595f, 0.000263f, 0.070392f,
0.027603f, 0.478706f, 0.000264f, 0.390346f, 0.033205f, 0.522265f, 0.003894f, 0.831795f, 0.029471f, 0.694531f, 0.000252f, 0.467661f, 0.040907f, 0.494052f, 0.001042f, 0.633374f,
0.007354f, 0.151331f, 0.000015f, 0.102834f, 0.004404f, 0.082195f, 0.000113f, 0.109094f, 0.001135f, 0.031733f, 0.000002f, 0.017806f, 0.005411f, 0.077553f, 0.000030f, 0.082854f,
0.012457f, 0.183043f, 0.000144f, 0.179477f, 0.009065f, 0.120807f, 0.001282f, 0.231362f, 0.016874f, 0.336937f, 0.000174f, 0.272811f, 0.013761f, 0.140825f, 0.000423f, 0.217091f,
0.006969f, 0.151159f, 0.000450f, 0.128082f, 0.004936f, 0.097092f, 0.003905f, 0.160688f, 0.006166f, 0.181740f, 0.000356f, 0.127164f, 0.005012f, 0.075701f, 0.000861f, 0.100848f,
0.018280f, 0.270266f, 0.000385f, 0.248553f, 0.019774f, 0.265141f, 0.005105f, 0.476268f, 0.026641f, 0.535243f, 0.000502f, 0.406479f, 0.039519f, 0.406894f, 0.002216f, 0.588325f,
0.025065f, 0.383805f, 0.000034f, 0.192808f, 0.016740f, 0.232474f, 0.000280f, 0.228104f, 0.002653f, 0.055204f, 0.000003f, 0.022900f, 0.019909f, 0.212311f, 0.000072f, 0.167685f,
0.061805f, 0.675776f, 0.000467f, 0.489850f, 0.050157f, 0.497377f, 0.004638f, 0.704191f, 0.057426f, 0.853248f, 0.000388f, 0.510734f, 0.073701f, 0.561207f, 0.001480f, 0.639573f,
0.024190f, 0.390418f, 0.001022f, 0.244562f, 0.019105f, 0.279656f, 0.009884f, 0.342160f, 0.014681f, 0.321978f, 0.000555f, 0.166550f, 0.018777f, 0.211054f, 0.002110f, 0.207855f,
0.125333f, 1.378813f, 0.001728f, 0.937432f, 0.151189f, 1.508467f, 0.025526f, 2.003158f, 0.125290f, 1.873024f, 0.001545f, 1.051567f, 0.292471f, 2.240724f, 0.010726f, 2.395137f,
0.100808f, 1.104836f, 0.000008f, 0.558152f, 0.049007f, 0.487126f, 0.000047f, 0.480664f, 0.008912f, 0.132724f, 0.000001f, 0.055369f, 0.049767f, 0.379853f, 0.000010f, 0.301702f,
0.126900f, 0.993102f, 0.000055f, 0.723927f, 0.074963f, 0.532056f, 0.000395f, 0.757535f, 0.098479f, 1.047279f, 0.000038f, 0.630409f, 0.094052f, 0.512589f, 0.000108f, 0.587459f,
0.001765f, 0.020384f, 0.000004f, 0.012841f, 0.001014f, 0.010628f, 0.000030f, 0.013077f, 0.000894f, 0.014040f, 0.000002f, 0.007304f, 0.000851f, 0.006849f, 0.000005f, 0.006783f,
0.138885f, 1.093567f, 0.000109f, 0.747688f, 0.121952f, 0.870877f, 0.001173f, 1.162992f, 0.115958f, 1.240735f, 0.000081f, 0.700508f, 0.201431f, 1.104547f, 0.000421f, 1.187317f,
0.121086f, 1.673918f, 0.000064f, 0.740722f, 0.062038f, 0.777817f, 0.000403f, 0.672269f, 0.011834f, 0.222305f, 0.000006f, 0.081232f, 0.043059f, 0.414545f, 0.000061f, 0.288403f,
0.533903f, 5.270271f, 0.001565f, 3.365115f, 0.332390f, 2.975744f, 0.011929f, 3.711140f, 0.458042f, 6.144178f, 0.001200f, 3.239588f, 0.285030f, 1.959426f, 0.002222f, 1.966995f,
0.064141f, 0.934582f, 0.001052f, 0.515685f, 0.038863f, 0.513562f, 0.007804f, 0.553484f, 0.035942f, 0.711659f, 0.000527f, 0.324263f, 0.022290f, 0.226182f, 0.000972f, 0.196215f,
0.300971f, 2.989191f, 0.001610f, 1.790173f, 0.278521f, 2.508791f, 0.018252f, 2.934611f, 0.277801f, 3.749299f, 0.001329f, 1.854174f, 0.314424f, 2.174768f, 0.004475f, 2.047678f,
0.077389f, 0.912062f, 0.000090f, 0.455191f, 0.035654f, 0.381095f, 0.000509f, 0.371489f, 0.010324f, 0.165339f, 0.000011f, 0.068140f, 0.040146f, 0.329495f, 0.000125f, 0.258539f,
0.120407f, 1.013273f, 0.000777f, 0.729695f, 0.067407f, 0.514463f, 0.005326f, 0.723625f, 0.141005f, 1.612480f, 0.000814f, 0.958889f, 0.093771f, 0.549553f, 0.001609f, 0.622202f,
0.042223f, 0.524487f, 0.001524f, 0.326400f, 0.023005f, 0.259164f, 0.010169f, 0.315017f, 0.032296f, 0.545162f, 0.001043f, 0.280156f, 0.021405f, 0.185166f, 0.002055f, 0.181169f,
0.128455f, 1.087634f, 0.001513f, 0.734636f, 0.106893f, 0.820840f, 0.015421f, 1.082911f, 0.161844f, 1.862157f, 0.001705f, 1.038639f, 0.195762f, 1.154328f, 0.006134f, 1.225818f,
0.236001f, 2.069598f, 0.000180f, 0.763592f, 0.121252f, 0.964357f, 0.001133f, 0.694957f, 0.021595f, 0.257345f, 0.000015f, 0.078406f, 0.132149f, 0.807055f, 0.000268f, 0.468151f,
0.534504f, 3.346979f, 0.002255f, 1.781862f, 0.333691f, 1.895066f, 0.017241f, 1.970562f, 0.429348f, 3.653416f, 0.001620f, 1.606124f, 0.449322f, 1.959424f, 0.005042f, 1.640049f,
0.131128f, 1.212017f, 0.003095f, 0.557609f, 0.079671f, 0.667871f, 0.023031f, 0.600148f, 0.068798f, 0.864128f, 0.001452f, 0.328290f, 0.071754f, 0.461878f, 0.004505f, 0.334084f,
0.787978f, 4.964491f, 0.006070f, 2.478963f, 0.731234f, 4.178248f, 0.068984f, 4.075063f, 0.680986f, 5.830240f, 0.004691f, 2.404035f, 1.296238f, 5.687396f, 0.026561f, 4.464946f,
0.000070f, 0.000975f, 0.000000f, 0.000719f, 0.000062f, 0.000785f, 0.000000f, 0.001129f, 0.000011f, 0.000204f, 0.000000f, 0.000124f, 0.000079f, 0.000767f, 0.000000f, 0.000889f,
0.000165f, 0.001654f, 0.000000f, 0.001759f, 0.000178f, 0.001618f, 0.000006f, 0.003360f, 0.000223f, 0.003034f, 0.000001f, 0.002664f, 0.000280f, 0.001954f, 0.000002f, 0.003266f,
0.000002f, 0.000024f, 0.000000f, 0.000022f, 0.000002f, 0.000023f, 0.000000f, 0.000041f, 0.000001f, 0.000029f, 0.000000f, 0.000022f, 0.000002f, 0.000018f, 0.000000f, 0.000027f,
0.000153f, 0.001545f, 0.000001f, 0.001541f, 0.000246f, 0.002246f, 0.000014f, 0.004375f, 0.000223f, 0.003049f, 0.000001f, 0.002511f, 0.000509f, 0.003571f, 0.000006f, 0.005600f,
0.000064f, 0.001138f, 0.000000f, 0.000735f, 0.000060f, 0.000965f, 0.000002f, 0.001217f, 0.000011f, 0.000263f, 0.000000f, 0.000140f, 0.000052f, 0.000645f, 0.000000f, 0.000654f,
0.000536f, 0.006763f, 0.000009f, 0.006299f, 0.000609f, 0.006969f, 0.000129f, 0.012677f, 0.000799f, 0.013710f, 0.000012f, 0.010544f, 0.000654f, 0.005753f, 0.000030f, 0.008424f,
0.000045f, 0.000844f, 0.000004f, 0.000680f, 0.000050f, 0.000847f, 0.000060f, 0.001331f, 0.000044f, 0.001118f, 0.000004f, 0.000743f, 0.000036f, 0.000468f, 0.000009f, 0.000592f,
0.000256f, 0.003254f, 0.000008f, 0.002842f, 0.000433f, 0.004984f, 0.000168f, 0.008503f, 0.000411f, 0.007096f, 0.000012f, 0.005119f, 0.000612f, 0.005416f, 0.000052f, 0.007439f,
0.000005f, 0.000072f, 0.000000f, 0.000053f, 0.000004f, 0.000055f, 0.000000f, 0.000078f, 0.000001f, 0.000023f, 0.000000f, 0.000014f, 0.000006f, 0.000060f, 0.000000f, 0.000068f,
0.000014f, 0.000151f, 0.000001f, 0.000159f, 0.000014f, 0.000140f, 0.000007f, 0.000288f, 0.000029f, 0.000419f, 0.000001f, 0.000364f, 0.000025f, 0.000188f, 0.000003f, 0.000310f,
0.000003f, 0.000055f, 0.000001f, 0.000050f, 0.000003f, 0.000050f, 0.000009f, 0.000088f, 0.000005f, 0.000100f, 0.000001f, 0.000075f, 0.000004f, 0.000045f, 0.000002f, 0.000064f,
0.000013f, 0.000138f, 0.000001f, 0.000136f, 0.000019f, 0.000190f, 0.000017f, 0.000366f, 0.000028f, 0.000411f, 0.000002f, 0.000334f, 0.000044f, 0.000335f, 0.000008f, 0.000519f,
0.000170f, 0.001909f, 0.000001f, 0.001027f, 0.000160f, 0.001623f, 0.000009f, 0.001706f, 0.000027f, 0.000413f, 0.000000f, 0.000183f, 0.000218f, 0.001703f, 0.000003f, 0.001441f,
0.000728f, 0.005827f, 0.000018f, 0.004525f, 0.000829f, 0.006021f, 0.000253f, 0.009132f, 0.001016f, 0.011059f, 0.000023f, 0.007092f, 0.001400f, 0.007805f, 0.000093f, 0.009529f,
0.000126f, 0.001485f, 0.000018f, 0.000997f, 0.000139f, 0.001494f, 0.000238f, 0.001958f, 0.000115f, 0.001841f, 0.000014f, 0.001020f, 0.000157f, 0.001295f, 0.000058f, 0.001366f,
0.000910f, 0.007331f, 0.000041f, 0.005340f, 0.001541f, 0.011260f, 0.000860f, 0.016019f, 0.001367f, 0.014971f, 0.000056f, 0.009004f, 0.003425f, 0.019216f, 0.000415f, 0.022005f,
0.000290f, 0.005262f, 0.000000f, 0.002377f, 0.000189f, 0.003117f, 0.000000f, 0.002751f, 0.000033f, 0.000816f, 0.000000f, 0.000305f, 0.000216f, 0.002728f, 0.000000f, 0.001938f,
0.000725f, 0.009402f, 0.000000f, 0.006129f, 0.000575f, 0.006767f, 0.000003f, 0.008617f, 0.000727f, 0.012804f, 0.000000f, 0.006893f, 0.000810f, 0.007317f, 0.000001f, 0.007500f,
0.000006f, 0.000117f, 0.000000f, 0.000066f, 0.000005f, 0.000082f, 0.000000f, 0.000090f, 0.000004f, 0.000104f, 0.000000f, 0.000048f, 0.000004f, 0.000059f, 0.000000f, 0.000052f,
0.000559f, 0.007289f, 0.000000f, 0.004457f, 0.000659f, 0.007799f, 0.000007f, 0.009314f, 0.000602f, 0.010680f, 0.000000f, 0.005393f, 0.001222f, 0.011101f, 0.000003f, 0.010672f,
0.000472f, 0.010822f, 0.000000f, 0.004283f, 0.000325f, 0.006756f, 0.000002f, 0.005222f, 0.000060f, 0.001856f, 0.000000f, 0.000607f, 0.000253f, 0.004041f, 0.000000f, 0.002514f,
0.004141f, 0.067726f, 0.000013f, 0.038674f, 0.003464f, 0.051377f, 0.000130f, 0.057303f, 0.004588f, 0.101968f, 0.000013f, 0.048082f, 0.003333f, 0.037967f, 0.000027f, 0.034086f,
0.000301f, 0.007267f, 0.000005f, 0.003586f, 0.000245f, 0.005365f, 0.000051f, 0.005171f, 0.000218f, 0.007146f, 0.000003f, 0.002912f, 0.000158f, 0.002652f, 0.000007f, 0.002057f,
0.001643f, 0.027045f, 0.000009f, 0.014485f, 0.002043f, 0.030497f, 0.000140f, 0.031903f, 0.001959f, 0.043809f, 0.000010f, 0.019376f, 0.002589f, 0.029669f, 0.000039f, 0.024984f,
0.000249f, 0.004868f, 0.000000f, 0.002173f, 0.000154f, 0.002733f, 0.000002f, 0.002383f, 0.000043f, 0.001140f, 0.000000f, 0.000420f, 0.000195f, 0.002652f, 0.000001f, 0.001861f,
0.000771f, 0.010750f, 0.000005f, 0.006923f, 0.000580f, 0.007333f, 0.000048f, 0.009224f, 0.001166f, 0.022093f, 0.000007f, 0.011749f, 0.000905f, 0.008791f, 0.000016f, 0.008901f,
0.000164f, 0.003367f, 0.000006f, 0.001874f, 0.000120f, 0.002235f, 0.000055f, 0.002430f, 0.000162f, 0.004519f, 0.000005f, 0.002077f, 0.000125f, 0.001792f, 0.000013f, 0.001568f,
0.000579f, 0.008124f, 0.000007f, 0.004907f, 0.000647f, 0.008238f, 0.000098f, 0.009719f, 0.000942f, 0.017963f, 0.000010f, 0.008960f, 0.001331f, 0.013001f, 0.000044f, 0.012347f,
0.000758f, 0.011008f, 0.000001f, 0.003632f, 0.000523f, 0.006891f, 0.000005f, 0.004441f, 0.000090f, 0.001768f, 0.000000f, 0.000482f, 0.000640f, 0.006473f, 0.000001f, 0.003358f,
0.003410f, 0.035384f, 0.000015f, 0.016847f, 0.002861f, 0.026917f, 0.000155f, 0.025032f, 0.003538f, 0.049880f, 0.000014f, 0.019611f, 0.004323f, 0.031235f, 0.000051f, 0.023381f,
0.000506f, 0.007753f, 0.000012f, 0.003190f, 0.000413f, 0.005740f, 0.000125f, 0.004613f, 0.000343f, 0.007139f, 0.000008f, 0.002425f, 0.000418f, 0.004455f, 0.000027f, 0.002882f,
0.003540f, 0.036952f, 0.000029f, 0.016502f, 0.004413f, 0.041784f, 0.000435f, 0.036446f, 0.003951f, 0.056044f, 0.000028f, 0.020667f, 0.008780f, 0.063832f, 0.000188f, 0.044817f,
0.000059f, 0.001127f, 0.000000f, 0.000775f, 0.000051f, 0.000880f, 0.000000f, 0.001182f, 0.000007f, 0.000179f, 0.000000f, 0.000102f, 0.000062f, 0.000823f, 0.000000f, 0.000890f,
0.000160f, 0.002181f, 0.000000f, 0.002164f, 0.000167f, 0.002069f, 0.000002f, 0.004011f, 0.000164f, 0.003037f, 0.000000f, 0.002489f, 0.000251f, 0.002392f, 0.000001f, 0.003732f,
0.000002f, 0.000032f, 0.000000f, 0.000027f, 0.000002f, 0.000029f, 0.000000f, 0.000049f, 0.000001f, 0.000029f, 0.000000f, 0.000020f, 0.000002f, 0.000023f, 0.000000f, 0.000031f,
0.000150f, 0.002065f, 0.000000f, 0.001922f, 0.000234f, 0.002912f, 0.000004f, 0.005294f, 0.000166f, 0.003093f, 0.000000f, 0.002378f, 0.000463f, 0.004431f, 0.000002f, 0.006486f,
0.000048f, 0.001151f, 0.000000f, 0.000693f, 0.000043f, 0.000947f, 0.000001f, 0.001115f, 0.000006f, 0.000202f, 0.000000f, 0.000100f, 0.000036f, 0.000606f, 0.000000f, 0.000574f,
0.000453f, 0.007802f, 0.000002f, 0.006783f, 0.000499f, 0.007802f, 0.000032f, 0.013248f, 0.000513f, 0.012012f, 0.000002f, 0.008624f, 0.000514f, 0.006165f, 0.000007f, 0.008426f,
0.000039f, 0.000981f, 0.000001f, 0.000737f, 0.000041f, 0.000955f, 0.000015f, 0.001401f, 0.000029f, 0.000986f, 0.000001f, 0.000612f, 0.000028f, 0.000504f, 0.000002f, 0.000596f,
0.000219f, 0.003805f, 0.000002f, 0.003102f, 0.000360f, 0.005655f, 0.000042f, 0.009007f, 0.000267f, 0.006302f, 0.000002f, 0.004243f, 0.000487f, 0.005882f, 0.000012f, 0.007541f,
0.000060f, 0.001241f, 0.000000f, 0.000843f, 0.000049f, 0.000918f, 0.000001f, 0.001219f, 0.000011f, 0.000297f, 0.000000f, 0.000167f, 0.000066f, 0.000953f, 0.000000f, 0.001018f,
0.000202f, 0.002969f, 0.000002f, 0.002911f, 0.000200f, 0.002669f, 0.000028f, 0.005112f, 0.000312f, 0.006239f, 0.000003f, 0.005051f, 0.000334f, 0.003422f, 0.000010f, 0.005275f,
0.000050f, 0.001089f, 0.000003f, 0.000923f, 0.000048f, 0.000953f, 0.000038f, 0.001578f, 0.000051f, 0.001495f, 0.000003f, 0.001046f, 0.000054f, 0.000817f, 0.000009f, 0.001089f,
0.000185f, 0.002740f, 0.000004f, 0.002520f, 0.000273f, 0.003662f, 0.000071f, 0.006577f, 0.000308f, 0.006194f, 0.000006f, 0.004704f, 0.000600f, 0.006179f, 0.000034f, 0.008934f,
0.000147f, 0.002256f, 0.000000f, 0.001133f, 0.000134f, 0.001861f, 0.000002f, 0.001826f, 0.000018f, 0.000370f, 0.000000f, 0.000154f, 0.000175f, 0.001869f, 0.000001f, 0.001476f,
0.000718f, 0.007853f, 0.000005f, 0.005693f, 0.000794f, 0.007875f, 0.000073f, 0.011149f, 0.000762f, 0.011321f, 0.000005f, 0.006776f, 0.001283f, 0.009770f, 0.000026f, 0.011135f,
0.000125f, 0.002016f, 0.000005f, 0.001263f, 0.000134f, 0.001967f, 0.000070f, 0.002407f, 0.000087f, 0.001898f, 0.000003f, 0.000982f, 0.000145f, 0.001633f, 0.000016f, 0.001608f,
0.000910f, 0.010015f, 0.000013f, 0.006809f, 0.001496f, 0.014927f, 0.000253f, 0.019823f, 0.001039f, 0.015532f, 0.000013f, 0.008720f, 0.003182f, 0.024382f, 0.000117f, 0.026062f,
0.000731f, 0.008016f, 0.000000f, 0.004049f, 0.000484f, 0.004815f, 0.000000f, 0.004751f, 0.000074f, 0.001099f, 0.000000f, 0.000459f, 0.000541f, 0.004128f, 0.000000f, 0.003279f,
0.001821f, 0.014248f, 0.000001f, 0.010386f, 0.001465f, 0.010400f, 0.000008f, 0.014807f, 0.001613f, 0.017154f, 0.000001f, 0.010326f, 0.002021f, 0.011017f, 0.000002f, 0.012626f,
0.000011f, 0.000130f, 0.000000f, 0.000082f, 0.000009f, 0.000092f, 0.000000f, 0.000114f, 0.000007f, 0.000102f, 0.000000f, 0.000053f, 0.000008f, 0.000065f, 0.000000f, 0.000065f,
0.001245f, 0.009806f, 0.000001f, 0.006705f, 0.001490f, 0.010639f, 0.000014f, 0.014208f, 0.001187f, 0.012702f, 0.000001f, 0.007172f, 0.002706f, 0.014838f, 0.000006f, 0.015950f,
0.001036f, 0.014317f, 0.000001f, 0.006336f, 0.000723f, 0.009064f, 0.000005f, 0.007834f, 0.000116f, 0.002171f, 0.000000f, 0.000793f, 0.000552f, 0.005312f, 0.000001f, 0.003695f,
0.009031f, 0.089143f, 0.000026f, 0.056918f, 0.007659f, 0.068572f, 0.000275f, 0.085518f, 0.008845f, 0.118645f, 0.000023f, 0.062557f, 0.007222f, 0.049649f, 0.000056f, 0.049841f,
0.000482f, 0.007024f, 0.000008f, 0.003876f, 0.000398f, 0.005258f, 0.000080f, 0.005667f, 0.000308f, 0.006106f, 0.000005f, 0.002782f, 0.000251f, 0.002547f, 0.000011f, 0.002209f,
0.003182f, 0.031601f, 0.000017f, 0.018925f, 0.004011f, 0.036133f, 0.000263f, 0.042266f, 0.003353f, 0.045251f, 0.000016f, 0.022379f, 0.004980f, 0.034442f, 0.000071f, 0.032429f,
0.000844f, 0.009950f, 0.000001f, 0.004966f, 0.000530f, 0.005664f, 0.000008f, 0.005521f, 0.000129f, 0.002059f, 0.000000f, 0.000849f, 0.000656f, 0.005385f, 0.000002f, 0.004225f,
0.002598f, 0.021859f, 0.000017f, 0.015742f, 0.001981f, 0.015120f, 0.000157f, 0.021268f, 0.003473f, 0.039713f, 0.000020f, 0.023616f, 0.003030f, 0.017760f, 0.000052f, 0.020108f,
0.000405f, 0.005028f, 0.000015f, 0.003129f, 0.000300f, 0.003384f, 0.000133f, 0.004114f, 0.000353f, 0.005966f, 0.000011f, 0.003066f, 0.000307f, 0.002659f, 0.000030f, 0.002602f,
0.001732f, 0.014665f, 0.000020f, 0.009905f, 0.001964f, 0.015078f, 0.000283f, 0.019893f, 0.002491f, 0.028665f, 0.000026f, 0.015988f, 0.003954f, 0.023316f, 0.000124f, 0.024760f,
0.001845f, 0.016178f, 0.000001f, 0.005969f, 0.001291f, 0.010270f, 0.000012f, 0.007401f, 0.000193f, 0.002297f, 0.000000f, 0.000700f, 0.001547f, 0.009451f, 0.000003f, 0.005482f,
0.008262f, 0.051737f, 0.000035f, 0.027544f, 0.007027f, 0.039909f, 0.000363f, 0.041499f, 0.007577f, 0.064474f, 0.000029f, 0.028344f, 0.010405f, 0.045374f, 0.000117f, 0.037978f,
0.000901f, 0.008325f, 0.000021f, 0.003830f, 0.000746f, 0.006250f, 0.000216f, 0.005616f, 0.000539f, 0.006776f, 0.000011f, 0.002574f, 0.000738f, 0.004752f, 0.000046f, 0.003438f,
0.007613f, 0.047964f, 0.000059f, 0.023951f, 0.009625f, 0.054997f, 0.000908f, 0.053638f, 0.007511f, 0.064308f, 0.000052f, 0.026517f, 0.018761f, 0.082317f, 0.000384f, 0.064624f,
0.023781f, 0.333295f, 0.000011f, 0.245602f, 0.016065f, 0.204207f, 0.000091f, 0.293913f, 0.003021f, 0.057538f, 0.000001f, 0.035012f, 0.019309f, 0.188469f, 0.000024f, 0.218348f,
0.029034f, 0.290563f, 0.000074f, 0.308950f, 0.023834f, 0.216322f, 0.000743f, 0.449256f, 0.032379f, 0.440337f, 0.000074f, 0.386627f, 0.035392f, 0.246666f, 0.000240f, 0.412348f,
0.000455f, 0.006727f, 0.000006f, 0.006181f, 0.000364f, 0.004874f, 0.000063f, 0.008748f, 0.000332f, 0.006659f, 0.000004f, 0.005053f, 0.000361f, 0.003718f, 0.000014f, 0.005370f,
0.042448f, 0.427418f, 0.000197f, 0.426261f, 0.051796f, 0.473001f, 0.002949f, 0.921360f, 0.050931f, 0.696888f, 0.000212f, 0.573911f, 0.101257f, 0.710043f, 0.001252f, 1.113306f,
0.021978f, 0.388527f, 0.000069f, 0.250778f, 0.015647f, 0.250878f, 0.000601f, 0.316283f, 0.003087f, 0.074150f, 0.000009f, 0.039522f, 0.012854f, 0.158253f, 0.000107f, 0.160593f,
0.093986f, 1.186412f, 0.001630f, 1.104968f, 0.081311f, 0.930884f, 0.017270f, 1.693382f, 0.115873f, 1.987662f, 0.001797f, 1.528677f, 0.082525f, 0.725477f, 0.003807f, 1.062296f,
0.012736f, 0.237314f, 0.001236f, 0.191002f, 0.010724f, 0.181216f, 0.012744f, 0.284876f, 0.010256f, 0.259689f, 0.000890f, 0.172595f, 0.007280f, 0.094462f, 0.001879f, 0.119530f,
0.070776f, 0.898912f, 0.002241f, 0.785246f, 0.091016f, 1.048397f, 0.035298f, 1.788790f, 0.093880f, 1.620279f, 0.002659f, 1.168793f, 0.121611f, 1.075645f, 0.010244f, 1.477288f,
0.001136f, 0.017128f, 0.000008f, 0.012469f, 0.000728f, 0.009945f, 0.000062f, 0.014141f, 0.000218f, 0.004462f, 0.000001f, 0.002682f, 0.000970f, 0.010177f, 0.000018f, 0.011648f,
0.001715f, 0.018455f, 0.000065f, 0.019386f, 0.001334f, 0.013021f, 0.000624f, 0.026715f, 0.002886f, 0.042205f, 0.000099f, 0.036608f, 0.002197f, 0.016462f, 0.000223f, 0.027187f,
0.000678f, 0.010775f, 0.000145f, 0.009781f, 0.000514f, 0.007399f, 0.001344f, 0.013118f, 0.000746f, 0.016095f, 0.000142f, 0.012065f, 0.000566f, 0.006257f, 0.000321f, 0.008929f,
0.002444f, 0.026463f, 0.000170f, 0.026072f, 0.002826f, 0.027753f, 0.002413f, 0.053406f, 0.004425f, 0.065109f, 0.000276f, 0.052971f, 0.006126f, 0.046193f, 0.001136f, 0.071551f,
0.068374f, 0.766772f, 0.000309f, 0.412657f, 0.048816f, 0.496496f, 0.002699f, 0.521895f, 0.008991f, 0.137016f, 0.000036f, 0.060891f, 0.062970f, 0.491786f, 0.000756f, 0.416108f,
0.150192f, 1.202675f, 0.003750f, 0.933935f, 0.130298f, 0.946275f, 0.039840f, 1.435260f, 0.173373f, 1.886560f, 0.003871f, 1.209757f, 0.207657f, 1.158021f, 0.013791f, 1.413814f,
0.041562f, 0.491255f, 0.005805f, 0.329667f, 0.035091f, 0.376174f, 0.060033f, 0.493063f, 0.031337f, 0.503330f, 0.003915f, 0.278920f, 0.037406f, 0.307907f, 0.013899f, 0.324859f,
0.295781f, 2.383040f, 0.013483f, 1.735698f, 0.381426f, 2.787073f, 0.212950f, 3.964934f, 0.367342f, 4.021788f, 0.014977f, 2.418917f, 0.800264f, 4.490169f, 0.097044f, 5.141772f,
0.080402f, 1.460075f, 0.000007f, 0.659669f, 0.039988f, 0.658589f, 0.000040f, 0.581179f, 0.007586f, 0.187209f, 0.000001f, 0.069845f, 0.043024f, 0.544114f, 0.000009f, 0.386499f,
0.103366f, 1.340347f, 0.000046f, 0.873803f, 0.062468f, 0.734641f, 0.000344f, 0.935441f, 0.085617f, 1.508638f, 0.000034f, 0.812157f, 0.083039f, 0.749877f, 0.000099f, 0.768588f,
0.001394f, 0.026672f, 0.000004f, 0.015027f, 0.000820f, 0.014228f, 0.000025f, 0.015656f, 0.000754f, 0.019609f, 0.000002f, 0.009122f, 0.000729f, 0.009714f, 0.000005f, 0.008604f,
0.125433f, 1.636474f, 0.000103f, 1.000644f, 0.112678f, 1.333262f, 0.001133f, 1.592323f, 0.111778f, 1.981721f, 0.000082f, 1.000627f, 0.197187f, 1.791617f, 0.000431f, 1.722358f,
0.130950f, 2.999523f, 0.000073f, 1.187050f, 0.068638f, 1.425905f, 0.000466f, 1.102179f, 0.013659f, 0.425174f, 0.000007f, 0.138945f, 0.050474f, 0.805169f, 0.000074f, 0.500969f,
0.589684f, 9.644877f, 0.001807f, 5.507559f, 0.375577f, 5.571272f, 0.014096f, 6.213863f, 0.539960f, 12.001270f, 0.001480f, 5.659115f, 0.341228f, 3.886778f, 0.002782f, 3.489471f,
0.068682f, 1.658172f, 0.001178f, 0.818261f, 0.042573f, 0.932180f, 0.008940f, 0.898478f, 0.041078f, 1.347669f, 0.000630f, 0.549167f, 0.025871f, 0.434977f, 0.001180f, 0.337471f,
0.368572f, 6.065380f, 0.002062f, 3.248589f, 0.348940f, 5.207915f, 0.023912f, 5.448106f, 0.363103f, 8.119961f, 0.001817f, 3.591284f, 0.417359f, 4.783155f, 0.006212f, 4.027714f,
0.047982f, 0.936977f, 0.000059f, 0.418209f, 0.022615f, 0.400527f, 0.000338f, 0.349174f, 0.006832f, 0.181293f, 0.000007f, 0.066820f, 0.026979f, 0.366903f, 0.000088f, 0.257468f,
0.076242f, 1.063106f, 0.000514f, 0.684679f, 0.043666f, 0.552203f, 0.003608f, 0.694631f, 0.095296f, 1.805692f, 0.000575f, 0.960314f, 0.064359f, 0.624966f, 0.001155f, 0.632811f,
0.025920f, 0.533498f, 0.000978f, 0.296922f, 0.014448f, 0.269692f, 0.006679f, 0.293173f, 0.021161f, 0.591866f, 0.000714f, 0.272015f, 0.014243f, 0.204153f, 0.001430f, 0.178638f,
0.090185f, 1.265242f, 0.001111f, 0.764290f, 0.076776f, 0.976886f, 0.011583f, 1.152587f, 0.121277f, 2.312099f, 0.001336f, 1.153321f, 0.148974f, 1.455516f, 0.004882f, 1.382322f,
0.247049f, 3.589733f, 0.000197f, 1.184494f, 0.129853f, 1.711233f, 0.001269f, 1.102871f, 0.024128f, 0.476422f, 0.000017f, 0.129814f, 0.149944f, 1.517317f, 0.000318f, 0.787145f,
0.571433f, 5.928908f, 0.002521f, 2.822872f, 0.364968f, 3.434322f, 0.019719f, 3.193760f, 0.489918f, 6.907490f, 0.001933f, 2.715787f, 0.520679f, 3.762247f, 0.006110f, 2.816250f,
0.135912f, 2.081510f, 0.003355f, 0.856436f, 0.084481f, 1.173431f, 0.025539f, 0.943016f, 0.076110f, 1.583972f, 0.001680f, 0.538174f, 0.080613f, 0.859795f, 0.005293f, 0.556184f,
0.934048f, 9.750728f, 0.007524f, 4.354396f, 0.886761f, 8.395597f, 0.087482f, 7.322970f, 0.861575f, 12.222170f, 0.006207f, 4.507109f, 1.665471f, 12.108020f, 0.035687f, 8.501024f,
0.020501f, 0.392336f, 0.000003f, 0.269869f, 0.013440f, 0.233264f, 0.000023f, 0.313391f, 0.001978f, 0.051439f, 0.000000f, 0.029218f, 0.015461f, 0.206055f, 0.000006f, 0.222836f,
0.028550f, 0.390130f, 0.000022f, 0.387213f, 0.022742f, 0.281850f, 0.000214f, 0.546391f, 0.024180f, 0.449013f, 0.000017f, 0.368009f, 0.032323f, 0.307605f, 0.000066f, 0.480000f,
0.000451f, 0.009096f, 0.000002f, 0.007801f, 0.000350f, 0.006395f, 0.000018f, 0.010714f, 0.000249f, 0.006838f, 0.000001f, 0.004843f, 0.000332f, 0.004668f, 0.000004f, 0.006295f,
0.042305f, 0.581652f, 0.000059f, 0.541474f, 0.050093f, 0.624627f, 0.000862f, 1.135742f, 0.038550f, 0.720242f, 0.000048f, 0.553671f, 0.093729f, 0.897451f, 0.000350f, 1.313508f,
0.016584f, 0.400332f, 0.000016f, 0.241202f, 0.011458f, 0.250847f, 0.000133f, 0.295199f, 0.001769f, 0.058025f, 0.000002f, 0.028869f, 0.009009f, 0.151449f, 0.000023f, 0.143461f,
0.080896f, 1.394358f, 0.000424f, 1.212217f, 0.067914f, 1.061653f, 0.004362f, 1.802742f, 0.075744f, 1.774133f, 0.000355f, 1.273654f, 0.065972f, 0.791915f, 0.000920f, 1.082411f,
0.011039f, 0.280855f, 0.000324f, 0.211003f, 0.009019f, 0.208115f, 0.003241f, 0.305389f, 0.006751f, 0.233409f, 0.000177f, 0.144805f, 0.005860f, 0.103832f, 0.000457f, 0.122643f,
0.061743f, 1.070773f, 0.000591f, 0.873128f, 0.077050f, 1.211865f, 0.009037f, 1.930098f, 0.062199f, 1.465801f, 0.000533f, 0.986994f, 0.098535f, 1.190050f, 0.002510f, 1.525644f,
0.014567f, 0.299773f, 0.000030f, 0.203705f, 0.009050f, 0.168907f, 0.000231f, 0.224182f, 0.002121f, 0.059310f, 0.000004f, 0.033281f, 0.011543f, 0.165435f, 0.000064f, 0.176743f,
0.025073f, 0.368426f, 0.000289f, 0.361247f, 0.018928f, 0.252245f, 0.002676f, 0.483083f, 0.032045f, 0.639881f, 0.000331f, 0.518098f, 0.029828f, 0.305240f, 0.000916f, 0.470547f,
0.009987f, 0.216611f, 0.000645f, 0.183542f, 0.007337f, 0.144334f, 0.005805f, 0.238872f, 0.008337f, 0.245727f, 0.000482f, 0.171936f, 0.007734f, 0.116820f, 0.001329f, 0.155624f,
0.036216f, 0.535438f, 0.000763f, 0.492422f, 0.040639f, 0.544917f, 0.010493f, 0.978822f, 0.049800f, 1.000515f, 0.000939f, 0.759821f, 0.084311f, 0.868089f, 0.004728f, 1.255162f,
0.060278f, 0.923023f, 0.000082f, 0.463689f, 0.041762f, 0.579976f, 0.000698f, 0.569075f, 0.006020f, 0.125263f, 0.000007f, 0.051963f, 0.051561f, 0.549842f, 0.000187f, 0.434270f,
0.151027f, 1.651333f, 0.001140f, 1.197002f, 0.127144f, 1.260815f, 0.011756f, 1.785075f, 0.132402f, 1.967260f, 0.000894f, 1.177554f, 0.193941f, 1.476789f, 0.003895f, 1.683007f,
0.042085f, 0.679224f, 0.001778f, 0.425474f, 0.034481f, 0.504711f, 0.017839f, 0.617515f, 0.024098f, 0.528523f, 0.000910f, 0.273390f, 0.035179f, 0.395404f, 0.003953f, 0.389411f,
0.301454f, 3.316340f, 0.004156f, 2.254725f, 0.377232f, 3.763779f, 0.063691f, 4.998083f, 0.284332f, 4.250615f, 0.003506f, 2.386411f, 0.757530f, 5.803716f, 0.027780f, 6.203661f,
0.129744f, 1.421973f, 0.000010f, 0.718367f, 0.065432f, 0.650384f, 0.000062f, 0.641755f, 0.010822f, 0.161175f, 0.000001f, 0.067238f, 0.068977f, 0.526469f, 0.000014f, 0.418153f,
0.165953f, 1.298726f, 0.000071f, 0.946713f, 0.101696f, 0.721797f, 0.000536f, 1.027687f, 0.121512f, 1.292232f, 0.000047f, 0.777858f, 0.132451f, 0.721867f, 0.000152f, 0.827305f,
0.001643f, 0.018979f, 0.000004f, 0.011955f, 0.000980f, 0.010265f, 0.000029f, 0.012631f, 0.000786f, 0.012334f, 0.000002f, 0.006416f, 0.000854f, 0.006867f, 0.000005f, 0.006801f,
0.178772f, 1.407638f, 0.000140f, 0.962423f, 0.162843f, 1.162885f, 0.001566f, 1.552948f, 0.140832f, 1.506883f, 0.000099f, 0.850773f, 0.279213f, 1.531066f, 0.000583f, 1.645798f,
0.183526f, 2.537102f, 0.000097f, 1.122688f, 0.097543f, 1.222970f, 0.000633f, 1.057016f, 0.016923f, 0.317912f, 0.000008f, 0.116168f, 0.070280f, 0.676612f, 0.000099f, 0.470726f,
0.822236f, 8.116466f, 0.002409f, 5.182435f, 0.531026f, 4.754053f, 0.019058f, 5.928923f, 0.665571f, 8.927964f, 0.001744f, 4.707370f, 0.472703f, 3.249577f, 0.003685f, 3.262129f,
0.070327f, 1.024716f, 0.001153f, 0.565419f, 0.044203f, 0.584135f, 0.008876f, 0.629543f, 0.037183f, 0.736228f, 0.000545f, 0.335458f, 0.026318f, 0.267059f, 0.001148f, 0.231676f,
0.456227f, 4.531163f, 0.002441f, 2.713632f, 0.437974f, 3.945073f, 0.028702f, 4.614675f, 0.397323f, 5.362419f, 0.001901f, 2.651924f, 0.513258f, 3.550037f, 0.007306f, 3.342579f,
0.103890f, 1.224385f, 0.000121f, 0.611065f, 0.049652f, 0.530714f, 0.000709f, 0.517338f, 0.013077f, 0.209423f, 0.000014f, 0.086308f, 0.058036f, 0.476329f, 0.000180f, 0.373752f,
0.164239f, 1.382134f, 0.001059f, 0.995325f, 0.095381f, 0.727967f, 0.007536f, 1.023933f, 0.181473f, 2.075260f, 0.001047f, 1.234089f, 0.137739f, 0.807230f, 0.002364f, 0.913944f,
0.041004f, 0.509343f, 0.001480f, 0.316975f, 0.023175f, 0.261087f, 0.010245f, 0.317354f, 0.029593f, 0.499524f, 0.000955f, 0.256702f, 0.022385f, 0.193643f, 0.002149f, 0.189463f,
0.172463f, 1.460255f, 0.002031f, 0.986320f, 0.148878f, 1.143243f, 0.021478f, 1.508248f, 0.205021f, 2.358939f, 0.002160f, 1.315725f, 0.283034f, 1.668933f, 0.008869f, 1.772294f,
0.384629f, 3.372989f, 0.000293f, 1.244486f, 0.204999f, 1.630427f, 0.001915f, 1.174955f, 0.033208f, 0.395730f, 0.000023f, 0.120568f, 0.231929f, 1.416433f, 0.000471f, 0.821634f,
0.885136f, 5.542582f, 0.003734f, 2.950754f, 0.573242f, 3.255501f, 0.029617f, 3.385194f, 0.670846f, 5.708378f, 0.002531f, 2.509532f, 0.801274f, 3.494230f, 0.008992f, 2.924690f,
0.154599f, 1.428958f, 0.003649f, 0.657416f, 0.097442f, 0.816842f, 0.028169f, 0.734013f, 0.076532f, 0.961266f, 0.001616f, 0.365194f, 0.091101f, 0.586412f, 0.005720f, 0.424161f,
1.284385f, 8.092000f, 0.009893f, 4.040650f, 1.236436f, 7.064961f, 0.116645f, 6.890487f, 1.047307f, 8.966483f, 0.007215f, 3.697230f, 2.275253f, 9.982943f, 0.046622f, 7.837207f,
0.033462f, 0.468986f, 0.000015f, 0.345591f, 0.025195f, 0.320254f, 0.000142f, 0.460938f, 0.005239f, 0.099778f, 0.000002f, 0.060715f, 0.031207f, 0.304591f, 0.000038f, 0.352880f,
0.033557f, 0.335829f, 0.000085f, 0.357081f, 0.030702f, 0.278659f, 0.000957f, 0.578717f, 0.046120f, 0.627206f, 0.000105f, 0.550703f, 0.046982f, 0.327442f, 0.000318f, 0.547381f,
0.000824f, 0.012165f, 0.000012f, 0.011178f, 0.000733f, 0.009824f, 0.000128f, 0.017631f, 0.000739f, 0.014840f, 0.000009f, 0.011260f, 0.000751f, 0.007721f, 0.000028f, 0.011154f,
0.059606f, 0.600177f, 0.000277f, 0.598553f, 0.081061f, 0.740257f, 0.004615f, 1.441949f, 0.088137f, 1.205971f, 0.000366f, 0.993158f, 0.163305f, 1.145141f, 0.002019f, 1.795514f,
0.031243f, 0.552327f, 0.000098f, 0.356504f, 0.024792f, 0.397494f, 0.000952f, 0.501123f, 0.005408f, 0.129908f, 0.000015f, 0.069241f, 0.020988f, 0.258389f, 0.000175f, 0.262211f,
0.109745f, 1.385344f, 0.001903f, 1.290245f, 0.105819f, 1.211467f, 0.022475f, 2.203793f, 0.166745f, 2.860302f, 0.002586f, 2.199811f, 0.110676f, 0.972957f, 0.005106f, 1.424674f,
0.023268f, 0.433556f, 0.002258f, 0.348947f, 0.021835f, 0.368988f, 0.025948f, 0.580058f, 0.023092f, 0.584686f, 0.002004f, 0.388594f, 0.015275f, 0.198210f, 0.003943f, 0.250811f,
0.100406f, 1.275229f, 0.003179f, 1.113979f, 0.143907f, 1.657641f, 0.055810f, 2.828290f, 0.164131f, 2.832749f, 0.004648f, 2.043411f, 0.198148f, 1.752619f, 0.016691f, 2.407043f,
0.001455f, 0.021936f, 0.000010f, 0.015969f, 0.001039f, 0.014196f, 0.000088f, 0.020184f, 0.000344f, 0.007043f, 0.000002f, 0.004234f, 0.001426f, 0.014970f, 0.000026f, 0.017133f,
0.001804f, 0.019414f, 0.000069f, 0.020393f, 0.001564f, 0.015266f, 0.000731f, 0.031321f, 0.003742f, 0.054715f, 0.000128f, 0.047460f, 0.002654f, 0.019890f, 0.000270f, 0.032848f,
0.001116f, 0.017735f, 0.000238f, 0.016099f, 0.000942f, 0.013572f, 0.002465f, 0.024064f, 0.001512f, 0.032647f, 0.000289f, 0.024472f, 0.001069f, 0.011828f, 0.000608f, 0.016880f,
0.003124f, 0.033821f, 0.000218f, 0.033321f, 0.004026f, 0.039532f, 0.003437f, 0.076073f, 0.006970f, 0.102551f, 0.000435f, 0.083433f, 0.008992f, 0.067806f, 0.001668f, 0.105030f,
0.073133f, 0.820138f, 0.000330f, 0.441377f, 0.058194f, 0.591875f, 0.003217f, 0.622154f, 0.011852f, 0.180609f, 0.000048f, 0.080264f, 0.077358f, 0.604149f, 0.000929f, 0.511180f,
0.131951f, 1.056615f, 0.003294f, 0.820512f, 0.127585f, 0.926572f, 0.039010f, 1.405375f, 0.187714f, 2.042612f, 0.004191f, 1.309825f, 0.209537f, 1.168509f, 0.013916f, 1.426619f,
0.057130f, 0.675266f, 0.007980f, 0.453151f, 0.053760f, 0.576302f, 0.091971f, 0.755377f, 0.053084f, 0.852644f, 0.006632f, 0.472493f, 0.059055f, 0.486110f, 0.021944f, 0.512873f,
0.315709f, 2.543596f, 0.014391f, 1.852640f, 0.453754f, 3.315575f, 0.253331f, 4.716789f, 0.483208f, 5.290335f, 0.019700f, 3.181888f, 0.981065f, 5.504616f, 0.118969f, 6.303434f,
0.076210f, 1.383946f, 0.000006f, 0.625273f, 0.042244f, 0.695748f, 0.000042f, 0.613970f, 0.008862f, 0.218685f, 0.000001f, 0.081588f, 0.046839f, 0.592354f, 0.000010f, 0.420765f,
0.080477f, 1.043539f, 0.000036f, 0.680307f, 0.054206f, 0.637471f, 0.000299f, 0.811712f, 0.082148f, 1.447517f, 0.000033f, 0.779254f, 0.074254f, 0.670547f, 0.000089f, 0.687279f,
0.001697f, 0.032490f, 0.000004f, 0.018304f, 0.001113f, 0.019316f, 0.000034f, 0.021255f, 0.001132f, 0.029437f, 0.000003f, 0.013695f, 0.001020f, 0.013590f, 0.000007f, 0.012037f,
0.118646f, 1.547923f, 0.000097f, 0.946499f, 0.118789f, 1.405560f, 0.001195f, 1.678669f, 0.130300f, 2.310095f, 0.000096f, 1.166432f, 0.214224f, 1.946404f, 0.000468f, 1.871161f,
0.125398f, 2.872369f, 0.000069f, 1.136729f, 0.073257f, 1.521851f, 0.000497f, 1.176343f, 0.016120f, 0.501767f, 0.000008f, 0.163975f, 0.055514f, 0.885569f, 0.000082f, 0.550994f,
0.463826f, 7.586342f, 0.001421f, 4.332064f, 0.329252f, 4.884091f, 0.012357f, 5.447422f, 0.523413f, 11.633490f, 0.001435f, 5.485691f, 0.308267f, 3.511341f, 0.002513f, 3.152411f,
0.084523f, 2.040633f, 0.001449f, 1.006995f, 0.058393f, 1.278583f, 0.012262f, 1.232356f, 0.062300f, 2.043928f, 0.000955f, 0.832889f, 0.036567f, 0.614822f, 0.001668f, 0.477001f,
0.352214f, 5.796186f, 0.001971f, 3.104411f, 0.371645f, 5.546792f, 0.025468f, 5.802612f, 0.427624f, 9.562807f, 0.002140f, 4.229424f, 0.458081f, 5.249843f, 0.006818f, 4.420695f,
0.041395f, 0.808343f, 0.000050f, 0.360795f, 0.021745f, 0.385117f, 0.000325f, 0.335739f, 0.007264f, 0.192750f, 0.000008f, 0.071042f, 0.026733f, 0.363551f, 0.000087f, 0.255116f,
0.054027f, 0.753340f, 0.000364f, 0.485178f, 0.034487f, 0.436121f, 0.002849f, 0.548608f, 0.083222f, 1.576905f, 0.000502f, 0.838638f, 0.052381f, 0.508650f, 0.000940f, 0.515035f,
0.028738f, 0.591489f, 0.001085f, 0.329198f, 0.017853f, 0.333254f, 0.008253f, 0.362269f, 0.028914f, 0.808695f, 0.000976f, 0.371667f, 0.018137f, 0.259967f, 0.001821f, 0.227476f,
0.077642f, 1.089273f, 0.000956f, 0.657993f, 0.073669f, 0.937348f, 0.011114f, 1.105938f, 0.128674f, 2.453108f, 0.001418f, 1.223659f, 0.147306f, 1.439222f, 0.004827f, 1.366847f,
0.177998f, 2.586402f, 0.000142f, 0.853428f, 0.104275f, 1.374158f, 0.001019f, 0.885630f, 0.021424f, 0.423031f, 0.000015f, 0.115266f, 0.124082f, 1.255619f, 0.000263f, 0.651382f,
0.338179f, 3.508781f, 0.001492f, 1.670601f, 0.240730f, 2.265250f, 0.013006f, 2.106578f, 0.357316f, 5.037893f, 0.001410f, 1.980726f, 0.353915f, 2.557269f, 0.004153f, 1.914257f,
0.125846f, 1.927346f, 0.003106f, 0.793005f, 0.087184f, 1.210967f, 0.026356f, 0.973181f, 0.086850f, 1.807489f, 0.001917f, 0.614117f, 0.085731f, 0.914373f, 0.005629f, 0.591490f,
0.671583f, 7.010795f, 0.005410f, 3.130820f, 0.710608f, 6.727836f, 0.070104f, 5.868283f, 0.763432f, 10.829930f, 0.005500f, 3.993699f, 1.375355f, 9.998865f, 0.029471f, 7.020191f,
0.000383f, 0.007329f, 0.000000f, 0.005041f, 0.000280f, 0.004856f, 0.000000f, 0.006525f, 0.000046f, 0.001184f, 0.000000f, 0.000673f, 0.000332f, 0.004421f, 0.000000f, 0.004781f,
0.000438f, 0.005986f, 0.000000f, 0.005941f, 0.000389f, 0.004820f, 0.000004f, 0.009344f, 0.000457f, 0.008490f, 0.000000f, 0.006959f, 0.000570f, 0.005421f, 0.000001f, 0.008459f,
0.000011f, 0.000218f, 0.000000f, 0.000187f, 0.000009f, 0.000171f, 0.000000f, 0.000287f, 0.000007f, 0.000202f, 0.000000f, 0.000143f, 0.000009f, 0.000129f, 0.000000f, 0.000174f,
0.000789f, 0.010843f, 0.000001f, 0.010094f, 0.001041f, 0.012977f, 0.000018f, 0.023596f, 0.000886f, 0.016546f, 0.000001f, 0.012720f, 0.002007f, 0.019215f, 0.000008f, 0.028122f,
0.000313f, 0.007555f, 0.000000f, 0.004552f, 0.000241f, 0.005276f, 0.000003f, 0.006209f, 0.000041f, 0.001350f, 0.000000f, 0.000671f, 0.000195f, 0.003283f, 0.000000f, 0.003110f,
0.001254f, 0.021614f, 0.000007f, 0.018791f, 0.001173f, 0.018342f, 0.000075f, 0.031145f, 0.001447f, 0.033892f, 0.000007f, 0.024331f, 0.001175f, 0.014099f, 0.000016f, 0.019271f,
0.000268f, 0.006812f, 0.000008f, 0.005117f, 0.000244f, 0.005626f, 0.000088f, 0.008255f, 0.000202f, 0.006976f, 0.000005f, 0.004328f, 0.000163f, 0.002892f, 0.000013f, 0.003416f,
0.001163f, 0.020166f, 0.000011f, 0.016444f, 0.001617f, 0.025437f, 0.000190f, 0.040513f, 0.001444f, 0.034020f, 0.000012f, 0.022908f, 0.002131f, 0.025741f, 0.000054f, 0.033000f,
0.000248f, 0.005097f, 0.000001f, 0.003463f, 0.000171f, 0.003201f, 0.000004f, 0.004248f, 0.000044f, 0.001243f, 0.000000f, 0.000697f, 0.000225f, 0.003231f, 0.000001f, 0.003451f,
0.000350f, 0.005145f, 0.000004f, 0.005045f, 0.000295f, 0.003926f, 0.000042f, 0.007519f, 0.000552f, 0.011013f, 0.000006f, 0.008917f, 0.000478f, 0.004896f, 0.000015f, 0.007547f,
0.000218f, 0.004733f, 0.000014f, 0.004010f, 0.000179f, 0.003515f, 0.000141f, 0.005817f, 0.000224f, 0.006617f, 0.000013f, 0.004630f, 0.000194f, 0.002932f, 0.000033f, 0.003905f,
0.000614f, 0.009085f, 0.000013f, 0.008355f, 0.000768f, 0.010304f, 0.000198f, 0.018509f, 0.001041f, 0.020920f, 0.000020f, 0.015887f, 0.001643f, 0.016916f, 0.000092f, 0.024459f,
0.000856f, 0.013106f, 0.000001f, 0.006584f, 0.000661f, 0.009178f, 0.000011f, 0.009006f, 0.000105f, 0.002192f, 0.000000f, 0.000909f, 0.000841f, 0.008967f, 0.000003f, 0.007082f,
0.001761f, 0.019260f, 0.000013f, 0.013961f, 0.001653f, 0.016389f, 0.000153f, 0.023204f, 0.001903f, 0.028276f, 0.000013f, 0.016926f, 0.002598f, 0.019782f, 0.000052f, 0.022545f,
0.000768f, 0.012394f, 0.000032f, 0.007764f, 0.000701f, 0.010265f, 0.000363f, 0.012559f, 0.000542f, 0.011886f, 0.000020f, 0.006148f, 0.000737f, 0.008287f, 0.000083f, 0.008161f,
0.004272f, 0.046992f, 0.000059f, 0.031949f, 0.005958f, 0.059440f, 0.001006f, 0.078933f, 0.004965f, 0.074227f, 0.000061f, 0.041673f, 0.012328f, 0.094453f, 0.000452f, 0.100962f,
0.159710f, 1.750391f, 0.000012f, 0.884281f, 0.089769f, 0.892292f, 0.000086f, 0.880455f, 0.016417f, 0.244506f, 0.000001f, 0.102001f, 0.097520f, 0.744327f, 0.000020f, 0.591189f,
0.167794f, 1.313134f, 0.000072f, 0.957216f, 0.114602f, 0.813393f, 0.000604f, 1.158100f, 0.151412f, 1.610197f, 0.000058f, 0.969257f, 0.153814f, 0.838294f, 0.000176f, 0.960737f,
0.002599f, 0.030023f, 0.000006f, 0.018913f, 0.001728f, 0.018099f, 0.000051f, 0.022269f, 0.001532f, 0.024046f, 0.000003f, 0.012509f, 0.001551f, 0.012476f, 0.000010f, 0.012357f,
0.219604f, 1.729144f, 0.000172f, 1.182242f, 0.222947f, 1.592101f, 0.002145f, 2.126134f, 0.213201f, 2.281218f, 0.000150f, 1.287956f, 0.393933f, 2.160139f, 0.000823f, 2.322011f,
0.228236f, 3.155193f, 0.000121f, 1.396198f, 0.135201f, 1.695108f, 0.000877f, 1.465087f, 0.025937f, 0.487239f, 0.000012f, 0.178042f, 0.100384f, 0.966440f, 0.000141f, 0.672363f,
0.839909f, 8.290918f, 0.002461f, 5.293824f, 0.604568f, 5.412442f, 0.021698f, 6.750020f, 0.837871f, 11.239190f, 0.002196f, 5.925992f, 0.554589f, 3.812501f, 0.004323f, 3.827228f,
0.112398f, 1.637717f, 0.001843f, 0.903661f, 0.078738f, 1.040500f, 0.015811f, 1.121383f, 0.073236f, 1.450089f, 0.001074f, 0.660725f, 0.048310f, 0.490219f, 0.002107f, 0.425269f,
0.566194f, 5.623335f, 0.003030f, 3.367714f, 0.605796f, 5.456735f, 0.039699f, 6.382914f, 0.607681f, 8.201478f, 0.002908f, 4.055949f, 0.731590f, 5.060165f, 0.010413f, 4.764457f,
0.116397f, 1.371782f, 0.000136f, 0.684627f, 0.062001f, 0.662706f, 0.000886f, 0.646004f, 0.018055f, 0.289160f, 0.000019f, 0.119170f, 0.074681f, 0.612945f, 0.000232f, 0.480947f,
0.151144f, 1.271934f, 0.000975f, 0.915966f, 0.097829f, 0.746655f, 0.007729f, 1.050219f, 0.205813f, 2.353608f, 0.001187f, 1.399613f, 0.145585f, 0.853216f, 0.002498f, 0.966010f,
0.059039f, 0.733372f, 0.002131f, 0.456393f, 0.037190f, 0.418979f, 0.016441f, 0.509275f, 0.052510f, 0.886374f, 0.001695f, 0.455503f, 0.037018f, 0.320230f, 0.003554f, 0.313318f,
0.192824f, 1.632645f, 0.002271f, 1.102760f, 0.185518f, 1.424608f, 0.026764f, 1.879445f, 0.282493f, 3.250326f, 0.002976f, 1.812906f, 0.363454f, 2.143136f, 0.011389f, 2.275864f,
0.359895f, 3.156085f, 0.000275f, 1.164458f, 0.213786f, 1.700312f, 0.001997f, 1.225318f, 0.038293f, 0.456332f, 0.000026f, 0.139032f, 0.249251f, 1.522219f, 0.000506f, 0.882998f,
0.680286f, 4.259843f, 0.002870f, 2.267851f, 0.491036f, 2.788643f, 0.025370f, 2.899737f, 0.635406f, 5.406813f, 0.002397f, 2.376957f, 0.707311f, 3.084469f, 0.007938f, 2.581718f,
0.185904f, 1.718307f, 0.004388f, 0.790536f, 0.130594f, 1.094744f, 0.037752f, 0.983736f, 0.113415f, 1.424530f, 0.002394f, 0.541192f, 0.125820f, 0.809900f, 0.007900f, 0.585814f,
1.199293f, 7.555896f, 0.009238f, 3.772952f, 1.286754f, 7.352474f, 0.121392f, 7.170900f, 1.205178f, 10.318090f, 0.008303f, 4.254550f, 2.440099f, 10.706220f, 0.050000f, 8.405024f,
0.087034f, 1.219811f, 0.000040f, 0.898866f, 0.056679f, 0.720443f, 0.000320f, 1.036924f, 0.011719f, 0.223186f, 0.000005f, 0.135809f, 0.065625f, 0.640528f, 0.000080f, 0.742076f,
0.084179f, 0.842437f, 0.000214f, 0.895748f, 0.066612f, 0.604594f, 0.002077f, 1.255617f, 0.099496f, 1.353093f, 0.000227f, 1.188050f, 0.095289f, 0.664113f, 0.000645f, 1.110191f,
0.002637f, 0.038949f, 0.000038f, 0.035789f, 0.002031f, 0.027204f, 0.000354f, 0.048824f, 0.002036f, 0.040862f, 0.000026f, 0.031004f, 0.001943f, 0.019987f, 0.000074f, 0.028874f,
0.146069f, 1.470788f, 0.000679f, 1.466806f, 0.171813f, 1.569007f, 0.009781f, 3.056274f, 0.185749f, 2.541591f, 0.000772f, 2.093087f, 0.323563f, 2.268913f, 0.004001f, 3.557524f,
0.061318f, 1.083997f, 0.000192f, 0.699675f, 0.042084f, 0.674737f, 0.001616f, 0.850644f, 0.009127f, 0.219262f, 0.000026f, 0.116867f, 0.033303f, 0.410010f, 0.000278f, 0.416074f,
0.207733f, 2.622260f, 0.003602f, 2.442250f, 0.173242f, 1.983360f, 0.036796f, 3.607952f, 0.271437f, 4.656163f, 0.004210f, 3.580977f, 0.169380f, 1.489019f, 0.007814f, 2.180329f,
0.056214f, 1.047435f, 0.005454f, 0.843027f, 0.045625f, 0.771020f, 0.054220f, 1.212062f, 0.047977f, 1.214795f, 0.004164f, 0.807377f, 0.029836f, 0.387164f, 0.007701f, 0.489911f,
0.185664f, 2.358075f, 0.005879f, 2.059901f, 0.230157f, 2.651134f, 0.089260f, 4.523403f, 0.261011f, 4.504802f, 0.007392f, 3.249552f, 0.296243f, 2.620267f, 0.024954f, 3.598667f,
0.004153f, 0.062583f, 0.000029f, 0.045559f, 0.002563f, 0.035029f, 0.000217f, 0.049807f, 0.000844f, 0.017280f, 0.000005f, 0.010387f, 0.003290f, 0.034531f, 0.000060f, 0.039522f,
0.004964f, 0.053421f, 0.000190f, 0.056114f, 0.003723f, 0.036333f, 0.001741f, 0.074543f, 0.008854f, 0.129479f, 0.000302f, 0.112311f, 0.005904f, 0.044251f, 0.000600f, 0.073079f,
0.003921f, 0.062285f, 0.000838f, 0.056539f, 0.002862f, 0.041228f, 0.007487f, 0.073096f, 0.004568f, 0.098605f, 0.000873f, 0.073913f, 0.003036f, 0.033585f, 0.001725f, 0.047930f,
0.008396f, 0.090913f, 0.000585f, 0.089570f, 0.009360f, 0.091911f, 0.007991f, 0.176867f, 0.016112f, 0.237073f, 0.001005f, 0.192876f, 0.019543f, 0.147368f, 0.003624f, 0.228269f,
0.173902f, 1.950198f, 0.000785f, 1.049546f, 0.119686f, 1.217290f, 0.006617f, 1.279562f, 0.024236f, 0.369343f, 0.000098f, 0.164139f, 0.148725f, 1.161514f, 0.001786f, 0.982776f,
0.302616f, 2.423231f, 0.007555f, 1.881756f, 0.253075f, 1.837931f, 0.077380f, 2.787677f, 0.370231f, 4.028677f, 0.008267f, 2.583389f, 0.388533f, 2.166700f, 0.025803f, 2.645298f,
0.167226f, 1.976593f, 0.023359f, 1.326434f, 0.136105f, 1.459031f, 0.232845f, 1.912395f, 0.133631f, 2.146388f, 0.016694f, 1.189421f, 0.139760f, 1.150442f, 0.051933f, 1.213782f,
0.707321f, 5.698726f, 0.032243f, 4.150692f, 0.879270f, 6.424811f, 0.490896f, 9.140038f, 0.931027f, 10.193210f, 0.037958f, 6.130739f, 1.777116f, 9.971146f, 0.215502f, 11.418140f,
0.255893f, 4.646945f, 0.000021f, 2.099511f, 0.122683f, 2.020562f, 0.000122f, 1.783066f, 0.025590f, 0.631487f, 0.000002f, 0.235599f, 0.127157f, 1.608119f, 0.000028f, 1.142289f,
0.260618f, 3.379430f, 0.000117f, 2.203128f, 0.151828f, 1.785531f, 0.000836f, 2.273571f, 0.228786f, 4.031407f, 0.000092f, 2.170261f, 0.194422f, 1.755708f, 0.000233f, 1.799517f,
0.007016f, 0.134293f, 0.000018f, 0.075657f, 0.003978f, 0.069054f, 0.000123f, 0.075985f, 0.004023f, 0.104638f, 0.000009f, 0.048679f, 0.003407f, 0.045416f, 0.000023f, 0.040226f,
0.375351f, 4.897059f, 0.000308f, 2.994374f, 0.325037f, 3.845984f, 0.003270f, 4.593281f, 0.354510f, 6.285129f, 0.000260f, 3.173539f, 0.547951f, 4.978604f, 0.001197f, 4.786143f,
0.317716f, 7.277588f, 0.000176f, 2.880077f, 0.160533f, 3.334966f, 0.001089f, 2.577822f, 0.035125f, 1.093320f, 0.000017f, 0.357292f, 0.113721f, 1.814088f, 0.000168f, 1.128710f,
1.133414f, 18.538130f, 0.003473f, 10.585920f, 0.695880f, 10.322600f, 0.026117f, 11.513210f, 1.099959f, 24.447910f, 0.003015f, 11.528250f, 0.609045f, 6.937374f, 0.004965f, 6.228234f,
0.263618f, 6.364472f, 0.004520f, 3.140688f, 0.157519f, 3.449041f, 0.033077f, 3.324341f, 0.167103f, 5.482283f, 0.002562f, 2.233999f, 0.092210f, 1.550369f, 0.004206f, 1.202832f,
0.840797f, 13.836530f, 0.004705f, 7.410783f, 0.767335f, 11.452460f, 0.052585f, 11.980650f, 0.877900f, 19.632190f, 0.004393f, 8.682894f, 0.884129f, 10.132570f, 0.013160f, 8.532258f,
0.152464f, 2.977270f, 0.000186f, 1.328871f, 0.069272f, 1.226837f, 0.001035f, 1.069538f, 0.023008f, 0.610541f, 0.000025f, 0.225029f, 0.079608f, 1.082620f, 0.000258f, 0.759711f,
0.191920f, 2.676085f, 0.001295f, 1.723496f, 0.105957f, 1.339948f, 0.008754f, 1.685556f, 0.254240f, 4.817398f, 0.001534f, 2.562017f, 0.150442f, 1.460885f, 0.002700f, 1.479224f,
0.130295f, 2.681759f, 0.004918f, 1.492554f, 0.070009f, 1.306834f, 0.032363f, 1.420613f, 0.112740f, 3.153231f, 0.003806f, 1.449190f, 0.066485f, 0.952971f, 0.006676f, 0.833868f,
0.269438f, 3.780045f, 0.003319f, 2.283398f, 0.221114f, 2.813411f, 0.033358f, 3.319424f, 0.384016f, 7.321081f, 0.004231f, 3.651901f, 0.413304f, 4.038094f, 0.013543f, 3.835029f,
0.546416f, 7.939687f, 0.000436f, 2.619836f, 0.276859f, 3.648513f, 0.002705f, 2.351427f, 0.056560f, 1.116807f, 0.000040f, 0.304304f, 0.307968f, 3.116403f, 0.000653f, 1.616709f,
1.001246f, 10.388430f, 0.004417f, 4.946142f, 0.616447f, 5.800721f, 0.033306f, 5.394401f, 0.909797f, 12.827470f, 0.003590f, 5.043320f, 0.847191f, 6.121511f, 0.009942f, 4.582289f,
0.475552f, 7.283118f, 0.011738f, 2.996635f, 0.284948f, 3.957874f, 0.086139f, 3.180704f, 0.282244f, 5.873969f, 0.006231f, 1.995754f, 0.261928f, 2.793634f, 0.017198f, 1.807147f,
1.942427f, 20.277410f, 0.015646f, 9.055308f, 1.777655f, 16.830320f, 0.175371f, 14.680070f, 1.898951f, 26.938220f, 0.013680f, 9.933878f, 3.216240f, 23.382140f, 0.068917f, 16.416580f,
0.056883f, 1.088580f, 0.000008f, 0.748780f, 0.035947f, 0.623901f, 0.000061f, 0.838213f, 0.005817f, 0.151265f, 0.000001f, 0.085920f, 0.039836f, 0.530911f, 0.000015f, 0.574148f,
0.062753f, 0.857523f, 0.000048f, 0.851110f, 0.048187f, 0.597201f, 0.000454f, 1.157724f, 0.056330f, 1.046022f, 0.000039f, 0.857313f, 0.065976f, 0.627865f, 0.000135f, 0.979746f,
0.001979f, 0.039924f, 0.000009f, 0.034243f, 0.001479f, 0.027059f, 0.000078f, 0.045332f, 0.001160f, 0.031809f, 0.000004f, 0.022529f, 0.001355f, 0.019028f, 0.000016f, 0.025659f,
0.110365f, 1.517399f, 0.000155f, 1.412583f, 0.125973f, 1.570806f, 0.002169f, 2.856154f, 0.106587f, 1.991408f, 0.000134f, 1.530853f, 0.227063f, 2.174119f, 0.000849f, 3.182036f,
0.035079f, 0.846770f, 0.000033f, 0.510183f, 0.023363f, 0.511470f, 0.000271f, 0.601901f, 0.003966f, 0.130079f, 0.000003f, 0.064718f, 0.017695f, 0.297473f, 0.000045f, 0.281783f,
0.135552f, 2.336435f, 0.000711f, 2.031233f, 0.109699f, 1.714855f, 0.007046f, 2.911913f, 0.134517f, 3.150729f, 0.000631f, 2.261914f, 0.102654f, 1.232236f, 0.001432f, 1.684254f,
0.036937f, 0.939777f, 0.001084f, 0.706043f, 0.029092f, 0.671292f, 0.010455f, 0.985059f, 0.023942f, 0.827762f, 0.000628f, 0.513536f, 0.018209f, 0.322633f, 0.001421f, 0.381085f,
0.122792f, 2.129497f, 0.001176f, 1.736431f, 0.147712f, 2.323267f, 0.017324f, 3.700193f, 0.131101f, 3.089584f, 0.001123f, 2.080365f, 0.181973f, 2.197762f, 0.004636f, 2.817530f,
0.040353f, 0.830410f, 0.000084f, 0.564288f, 0.024166f, 0.451037f, 0.000618f, 0.598639f, 0.006227f, 0.174129f, 0.000012f, 0.097710f, 0.029694f, 0.425561f, 0.000165f, 0.454650f,
0.055022f, 0.808507f, 0.000635f, 0.792753f, 0.040040f, 0.533608f, 0.005662f, 1.021930f, 0.074532f, 1.488257f, 0.000770f, 1.205011f, 0.060784f, 0.622030f, 0.001867f, 0.958898f,
0.043764f, 0.949245f, 0.002827f, 0.804327f, 0.030995f, 0.609719f, 0.024522f, 1.009087f, 0.038721f, 1.141290f, 0.002237f, 0.798563f, 0.031472f, 0.475389f, 0.005408f, 0.633302f,
0.094326f, 1.394578f, 0.001988f, 1.282541f, 0.102034f, 1.368137f, 0.026344f, 2.457553f, 0.137469f, 2.761867f, 0.002592f, 2.097443f, 0.203918f, 2.099586f, 0.011436f, 3.035774f,
0.116229f, 1.779769f, 0.000159f, 0.894084f, 0.077625f, 1.078020f, 0.001298f, 1.057757f, 0.012302f, 0.255988f, 0.000015f, 0.106192f, 0.092322f, 0.984521f, 0.000335f, 0.777583f,
0.230696f, 2.522436f, 0.001742f, 1.828438f, 0.187217f, 1.856532f, 0.017311f, 2.628497f, 0.214351f, 3.184877f, 0.001447f, 1.906390f, 0.275101f, 2.094787f, 0.005525f, 2.387302f,
0.128373f, 2.071868f, 0.005423f, 1.297843f, 0.101389f, 1.484080f, 0.052455f, 1.815776f, 0.077908f, 1.708669f, 0.002943f, 0.883847f, 0.099648f, 1.120019f, 0.011198f, 1.103045f,
0.546520f, 6.012353f, 0.007534f, 4.087699f, 0.659265f, 6.577716f, 0.111309f, 8.734830f, 0.546332f, 8.167377f, 0.006736f, 4.585388f, 1.275326f, 9.770743f, 0.046769f, 10.444060f,
0.465479f, 5.101561f, 0.000036f, 2.577259f, 0.226291f, 2.249298f, 0.000216f, 2.219458f, 0.041150f, 0.612852f, 0.000003f, 0.255664f, 0.229800f, 1.753963f, 0.000048f, 1.393102f,
0.471662f, 3.691165f, 0.000203f, 2.690694f, 0.278623f, 1.977547f, 0.001468f, 2.815609f, 0.366026f, 3.892528f, 0.000141f, 2.343104f, 0.349574f, 1.905194f, 0.000400f, 2.183471f,
0.009325f, 0.107715f, 0.000022f, 0.067854f, 0.005361f, 0.056163f, 0.000158f, 0.069103f, 0.004726f, 0.074194f, 0.000010f, 0.038595f, 0.004499f, 0.036191f, 0.000029f, 0.035843f,
0.603040f, 4.748285f, 0.000474f, 3.246474f, 0.529517f, 3.781362f, 0.005094f, 5.049732f, 0.503492f, 5.387295f, 0.000354f, 3.041620f, 0.874615f, 4.795963f, 0.001827f, 5.155353f,
0.501940f, 6.938935f, 0.000266f, 3.070534f, 0.257168f, 3.224305f, 0.001669f, 2.786776f, 0.049055f, 0.921526f, 0.000023f, 0.336735f, 0.178493f, 1.718424f, 0.000252f, 1.195526f,
1.781498f, 17.585550f, 0.005220f, 11.228530f, 1.109100f, 9.929297f, 0.039805f, 12.383120f, 1.528370f, 20.501550f, 0.004006f, 10.809680f, 0.951071f, 6.538103f, 0.007414f, 6.563358f,
0.304281f, 4.433594f, 0.004989f, 2.446374f, 0.184363f, 2.436303f, 0.037022f, 2.625688f, 0.170507f, 3.376060f, 0.002500f, 1.538282f, 0.105742f, 1.072989f, 0.004612f, 0.930829f,
1.173193f, 11.651950f, 0.006277f, 6.978144f, 1.085683f, 9.779338f, 0.071148f, 11.439200f, 1.082875f, 14.614870f, 0.005182f, 7.227621f, 1.225633f, 8.477305f, 0.017446f, 7.981905f,
0.372120f, 4.385581f, 0.000434f, 2.188750f, 0.171441f, 1.832463f, 0.002449f, 1.786278f, 0.049642f, 0.795022f, 0.000052f, 0.327648f, 0.193037f, 1.584352f, 0.000599f, 1.243164f,
0.466037f, 3.921870f, 0.003006f, 2.824282f, 0.260898f, 1.991226f, 0.020613f, 2.800788f, 0.545758f, 6.241099f, 0.003149f, 3.711376f, 0.362940f, 2.127043f, 0.006228f, 2.408233f,
0.232345f, 2.886136f, 0.008386f, 1.796105f, 0.126589f, 1.426123f, 0.055960f, 1.733471f, 0.177720f, 2.999908f, 0.005737f, 1.541636f, 0.117785f, 1.018928f, 0.011310f, 0.996932f,
0.580818f, 4.917810f, 0.006841f, 3.321704f, 0.483324f, 3.711482f, 0.069726f, 4.896451f, 0.731789f, 8.419866f, 0.007709f, 4.696274f, 0.885153f, 5.219370f, 0.027736f, 5.542615f,
0.958966f, 8.409609f, 0.000731f, 3.102780f, 0.492694f, 3.918571f, 0.004603f, 2.823890f, 0.087750f, 1.045697f, 0.000060f, 0.318596f, 0.536972f, 3.279388f, 0.001090f, 1.902284f,
1.748256f, 10.947300f, 0.007375f, 5.828113f, 1.091437f, 6.198381f, 0.056390f, 6.445314f, 1.404312f, 11.949590f, 0.005298f, 5.253310f, 1.469644f, 6.408884f, 0.016492f, 5.364272f,
0.609769f, 5.636092f, 0.014392f, 2.592979f, 0.370486f, 3.105718f, 0.107100f, 2.790794f, 0.319924f, 4.018347f, 0.006754f, 1.526607f, 0.333669f, 2.147816f, 0.020951f, 1.553551f,
3.010858f, 18.969280f, 0.023192f, 9.472097f, 2.794038f, 15.965050f, 0.263588f, 15.570780f, 2.602042f, 22.277300f, 0.017926f, 9.185796f, 4.952913f, 21.731490f, 0.101490f, 17.060520f,
0.019918f, 0.279155f, 0.000009f, 0.205706f, 0.017671f, 0.224620f, 0.000100f, 0.323293f, 0.003062f, 0.058311f, 0.000001f, 0.035483f, 0.022498f, 0.219594f, 0.000028f, 0.254408f,
0.038096f, 0.381252f, 0.000097f, 0.405378f, 0.041070f, 0.372765f, 0.001280f, 0.774155f, 0.051406f, 0.699096f, 0.000117f, 0.613824f, 0.064602f, 0.450242f, 0.000437f, 0.752665f,
0.000530f, 0.007832f, 0.000008f, 0.007197f, 0.000556f, 0.007453f, 0.000097f, 0.013376f, 0.000467f, 0.009381f, 0.000006f, 0.007118f, 0.000585f, 0.006021f, 0.000022f, 0.008698f,
0.041317f, 0.416025f, 0.000192f, 0.414899f, 0.066210f, 0.604632f, 0.003769f, 1.177765f, 0.059983f, 0.820749f, 0.000249f, 0.675914f, 0.137106f, 0.961429f, 0.001695f, 1.507465f,
0.016543f, 0.292460f, 0.000052f, 0.188771f, 0.015469f, 0.248010f, 0.000594f, 0.312667f, 0.002811f, 0.067536f, 0.000008f, 0.035997f, 0.013460f, 0.165715f, 0.000112f, 0.168166f,
0.110832f, 1.399058f, 0.001922f, 1.303017f, 0.125924f, 1.441644f, 0.026746f, 2.622511f, 0.165335f, 2.836110f, 0.002564f, 2.181205f, 0.135379f, 1.190118f, 0.006245f, 1.742657f,
0.013327f, 0.248314f, 0.001293f, 0.199855f, 0.014736f, 0.249021f, 0.017512f, 0.391467f, 0.012985f, 0.328784f, 0.001127f, 0.218517f, 0.010596f, 0.137499f, 0.002735f, 0.173988f,
0.061913f, 0.786345f, 0.001960f, 0.686913f, 0.104563f, 1.204436f, 0.040551f, 2.055025f, 0.099369f, 1.715007f, 0.002814f, 1.237125f, 0.147990f, 1.308973f, 0.012466f, 1.797740f,
0.001429f, 0.021535f, 0.000010f, 0.015677f, 0.001201f, 0.016422f, 0.000102f, 0.023350f, 0.000331f, 0.006788f, 0.000002f, 0.004081f, 0.001696f, 0.017801f, 0.000031f, 0.020373f,
0.003378f, 0.036352f, 0.000129f, 0.038185f, 0.003451f, 0.033683f, 0.001614f, 0.069107f, 0.006878f, 0.100589f, 0.000235f, 0.087251f, 0.006019f, 0.045109f, 0.000611f, 0.074497f,
0.001186f, 0.018833f, 0.000253f, 0.017095f, 0.001179f, 0.016983f, 0.003084f, 0.030111f, 0.001577f, 0.034038f, 0.000301f, 0.025514f, 0.001375f, 0.015212f, 0.000781f, 0.021710f,
0.003571f, 0.038667f, 0.000249f, 0.038096f, 0.005423f, 0.053257f, 0.004630f, 0.102484f, 0.007824f, 0.115114f, 0.000488f, 0.093653f, 0.012452f, 0.093895f, 0.002309f, 0.145441f,
0.042879f, 0.480855f, 0.000194f, 0.258784f, 0.040205f, 0.408908f, 0.002223f, 0.429827f, 0.006822f, 0.103968f, 0.000028f, 0.046204f, 0.054935f, 0.429032f, 0.000660f, 0.363011f,
0.147554f, 1.181550f, 0.003684f, 0.917530f, 0.168114f, 1.220908f, 0.051402f, 1.851809f, 0.206094f, 2.242613f, 0.004602f, 1.438076f, 0.283802f, 1.582653f, 0.018848f, 1.932242f,
0.036231f, 0.428241f, 0.005061f, 0.287380f, 0.040174f, 0.430657f, 0.068728f, 0.564475f, 0.033053f, 0.530901f, 0.004129f, 0.294199f, 0.045361f, 0.373392f, 0.016856f, 0.393950f,
0.215561f, 1.736722f, 0.009826f, 1.264949f, 0.365066f, 2.667531f, 0.203816f, 3.794871f, 0.323929f, 3.546486f, 0.013207f, 2.133045f, 0.811331f, 4.552264f, 0.098386f, 5.212878f,
0.069309f, 1.258625f, 0.000006f, 0.568653f, 0.045270f, 0.745586f, 0.000045f, 0.657950f, 0.007913f, 0.195267f, 0.000001f, 0.072851f, 0.051594f, 0.652494f, 0.000011f, 0.463484f,
0.139590f, 1.810065f, 0.000063f, 1.180023f, 0.110789f, 1.302910f, 0.000610f, 1.659035f, 0.139899f, 2.465142f, 0.000056f, 1.327081f, 0.156000f, 1.408746f, 0.000187f, 1.443898f,
0.001670f, 0.031961f, 0.000004f, 0.018006f, 0.001290f, 0.022390f, 0.000040f, 0.024637f, 0.001093f, 0.028431f, 0.000002f, 0.013226f, 0.001215f, 0.016192f, 0.000008f, 0.014342f,
0.125656f, 1.639386f, 0.000103f, 1.002425f, 0.148243f, 1.754082f, 0.001491f, 2.094910f, 0.135491f, 2.402121f, 0.000100f, 1.212899f, 0.274801f, 2.496798f, 0.000600f, 2.400278f,
0.101450f, 2.323818f, 0.000056f, 0.919642f, 0.069836f, 1.450783f, 0.000474f, 1.121409f, 0.012804f, 0.398562f, 0.000006f, 0.130248f, 0.054398f, 0.867766f, 0.000080f, 0.539917f,
0.715690f, 11.705830f, 0.002193f, 6.684436f, 0.598642f, 8.880186f, 0.022467f, 9.904427f, 0.792953f, 17.624340f, 0.002173f, 8.310636f, 0.576123f, 6.562377f, 0.004696f, 5.891570f,
0.073965f, 1.785715f, 0.001268f, 0.881200f, 0.060211f, 1.318392f, 0.012644f, 1.270726f, 0.053527f, 1.756087f, 0.000821f, 0.715595f, 0.038758f, 0.651650f, 0.001768f, 0.505574f,
0.331836f, 5.460834f, 0.001857f, 2.924797f, 0.412585f, 6.157819f, 0.028274f, 6.441820f, 0.395559f, 8.845758f, 0.001980f, 3.912289f, 0.522729f, 5.990750f, 0.007781f, 5.044585f,
0.062092f, 1.212519f, 0.000076f, 0.541194f, 0.038435f, 0.680697f, 0.000574f, 0.593421f, 0.010697f, 0.283870f, 0.000012f, 0.104627f, 0.048569f, 0.660505f, 0.000158f, 0.463498f,
0.154565f, 2.155221f, 0.001043f, 1.388040f, 0.116257f, 1.470199f, 0.009605f, 1.849403f, 0.233761f, 4.429342f, 0.001410f, 2.355638f, 0.181505f, 1.762535f, 0.003257f, 1.784660f,
0.046627f, 0.959677f, 0.001760f, 0.534116f, 0.034131f, 0.637122f, 0.015778f, 0.692592f, 0.046059f, 1.288237f, 0.001555f, 0.592059f, 0.035641f, 0.510875f, 0.003579f, 0.447026f,
0.135627f, 1.902761f, 0.001671f, 1.149394f, 0.151635f, 1.929376f, 0.022876f, 2.276389f, 0.220684f, 4.207239f, 0.002431f, 2.098655f, 0.311664f, 3.045043f, 0.010212f, 2.891916f,
0.159454f, 2.316941f, 0.000127f, 0.764515f, 0.110070f, 1.450521f, 0.001075f, 0.934845f, 0.018843f, 0.372070f, 0.000013f, 0.101380f, 0.134632f, 1.362370f, 0.000286f, 0.706762f,
0.577796f, 5.994922f, 0.002549f, 2.854302f, 0.484647f, 4.560494f, 0.026185f, 4.241048f, 0.599394f, 8.451022f, 0.002365f, 3.322651f, 0.732394f, 5.292025f, 0.008595f, 3.961373f,
0.121940f, 1.867516f, 0.003010f, 0.768388f, 0.099542f, 1.382628f, 0.030092f, 1.111135f, 0.082624f, 1.719544f, 0.001824f, 0.584237f, 0.100614f, 1.073115f, 0.006606f, 0.694177f,
0.700605f, 7.313769f, 0.005643f, 3.266119f, 0.873520f, 8.270234f, 0.086176f, 7.213623f, 0.781947f, 11.092580f, 0.005633f, 4.090556f, 1.737829f, 12.634060f, 0.037238f, 8.870358f,
0.016431f, 0.314450f, 0.000002f, 0.216294f, 0.014146f, 0.245529f, 0.000024f, 0.329869f, 0.001918f, 0.049884f, 0.000000f, 0.028335f, 0.017238f, 0.229743f, 0.000006f, 0.248453f,
0.035847f, 0.489845f, 0.000028f, 0.486181f, 0.037501f, 0.464761f, 0.000354f, 0.900978f, 0.036736f, 0.682163f, 0.000025f, 0.559097f, 0.056459f, 0.537289f, 0.000116f, 0.838408f,
0.000502f, 0.010133f, 0.000002f, 0.008692f, 0.000511f, 0.009357f, 0.000027f, 0.015676f, 0.000336f, 0.009217f, 0.000001f, 0.006528f, 0.000515f, 0.007235f, 0.000006f, 0.009757f,
0.039404f, 0.541761f, 0.000055f, 0.504338f, 0.061275f, 0.764059f, 0.001055f, 1.389268f, 0.043446f, 0.811713f, 0.000055f, 0.623988f, 0.121446f, 1.162842f, 0.000454f, 1.701934f,
0.011946f, 0.288365f, 0.000011f, 0.173741f, 0.010839f, 0.237297f, 0.000126f, 0.279253f, 0.001542f, 0.050573f, 0.000001f, 0.025162f, 0.009027f, 0.151759f, 0.000023f, 0.143755f,
0.091286f, 1.573446f, 0.000479f, 1.367911f, 0.100646f, 1.573338f, 0.006465f, 2.671610f, 0.103421f, 2.422389f, 0.000485f, 1.739038f, 0.103563f, 1.243145f, 0.001445f, 1.699165f,
0.011053f, 0.281214f, 0.000324f, 0.211272f, 0.011860f, 0.273665f, 0.004262f, 0.401579f, 0.008179f, 0.282782f, 0.000215f, 0.175435f, 0.008163f, 0.144627f, 0.000637f, 0.170830f,
0.051685f, 0.896335f, 0.000495f, 0.730888f, 0.084704f, 1.332260f, 0.009934f, 2.121849f, 0.062999f, 1.484664f, 0.000540f, 0.999695f, 0.114744f, 1.385811f, 0.002923f, 1.776609f,
0.017527f, 0.360682f, 0.000037f, 0.245094f, 0.014300f, 0.266895f, 0.000366f, 0.354237f, 0.003088f, 0.086345f, 0.000006f, 0.048451f, 0.019321f, 0.276900f, 0.000107f, 0.295828f,
0.047259f, 0.694444f, 0.000546f, 0.680913f, 0.046854f, 0.624414f, 0.006625f, 1.195835f, 0.073085f, 1.459374f, 0.000755f, 1.181625f, 0.078212f, 0.800377f, 0.002402f, 1.233832f,
0.016703f, 0.362281f, 0.001079f, 0.306973f, 0.016116f, 0.317025f, 0.012750f, 0.524677f, 0.016871f, 0.497277f, 0.000975f, 0.347945f, 0.017994f, 0.271798f, 0.003092f, 0.362083f,
0.050639f, 0.748672f, 0.001067f, 0.688526f, 0.074626f, 1.000634f, 0.019267f, 1.797415f, 0.084254f, 1.692726f, 0.001589f, 1.285506f, 0.163997f, 1.688544f, 0.009197f, 2.441453f,
0.036173f, 0.553907f, 0.000049f, 0.278261f, 0.032913f, 0.457085f, 0.000550f, 0.448493f, 0.004371f, 0.090955f, 0.000005f, 0.037731f, 0.043044f, 0.459017f, 0.000156f, 0.362535f,
0.141983f, 1.552442f, 0.001072f, 1.125319f, 0.156977f, 1.556662f, 0.014515f, 2.203937f, 0.150611f, 2.237807f, 0.001017f, 1.339497f, 0.253640f, 1.931367f, 0.005094f, 2.201063f,
0.035106f, 0.566593f, 0.001483f, 0.354920f, 0.037774f, 0.552920f, 0.019543f, 0.676500f, 0.024323f, 0.533460f, 0.000919f, 0.275944f, 0.040823f, 0.458843f, 0.004587f, 0.451889f,
0.210231f, 2.312784f, 0.002898f, 1.572424f, 0.345499f, 3.447166f, 0.058333f, 4.577639f, 0.239929f, 3.586807f, 0.002958f, 2.013731f, 0.734923f, 5.630513f, 0.026951f, 6.018523f,
0.178847f, 1.960126f, 0.000014f, 0.990237f, 0.118453f, 1.177401f, 0.000113f, 1.161781f, 0.018050f, 0.268826f, 0.000001f, 0.112146f, 0.132270f, 1.009558f, 0.000027f, 0.801851f,
0.358372f, 2.804569f, 0.000154f, 2.044405f, 0.288414f, 2.047038f, 0.001519f, 2.914550f, 0.317504f, 3.376520f, 0.000122f, 2.032493f, 0.397898f, 2.168561f, 0.000455f, 2.485306f,
0.003148f, 0.036366f, 0.000008f, 0.022908f, 0.002466f, 0.025832f, 0.000073f, 0.031784f, 0.001822f, 0.028597f, 0.000004f, 0.014876f, 0.002275f, 0.018304f, 0.000015f, 0.018128f,
0.286381f, 2.254940f, 0.000225f, 1.541736f, 0.342590f, 2.446487f, 0.003295f, 3.267104f, 0.272977f, 2.920812f, 0.000192f, 1.649065f, 0.622221f, 3.411958f, 0.001300f, 3.667637f,
0.227362f, 3.143109f, 0.000120f, 1.390851f, 0.158701f, 1.989753f, 0.001030f, 1.719750f, 0.025368f, 0.476551f, 0.000012f, 0.174136f, 0.121120f, 1.166076f, 0.000171f, 0.811251f,
1.595783f, 15.752310f, 0.004676f, 10.057990f, 1.353491f, 12.117230f, 0.048576f, 15.111760f, 1.562974f, 20.965730f, 0.004096f, 11.054420f, 1.276237f, 8.773441f, 0.009949f, 8.807330f,
0.121109f, 1.764647f, 0.001986f, 0.973699f, 0.099970f, 1.321082f, 0.020075f, 1.423775f, 0.077478f, 1.534076f, 0.001136f, 0.698993f, 0.063049f, 0.639775f, 0.002750f, 0.555011f,
0.656831f, 6.523526f, 0.003514f, 3.906822f, 0.828101f, 7.459156f, 0.054268f, 8.725209f, 0.692145f, 9.341435f, 0.003312f, 4.619701f, 1.027955f, 7.110029f, 0.014632f, 6.694530f,
0.214984f, 2.533666f, 0.000251f, 1.264499f, 0.134937f, 1.442294f, 0.001928f, 1.405943f, 0.032742f, 0.524368f, 0.000034f, 0.216105f, 0.167067f, 1.371209f, 0.000518f, 1.075921f,
0.532432f, 4.480611f, 0.003435f, 3.226652f, 0.406079f, 3.099282f, 0.032084f, 4.359340f, 0.711835f, 8.140288f, 0.004107f, 4.840761f, 0.621167f, 3.640407f, 0.010660f, 4.121661f,
0.117948f, 1.465124f, 0.004257f, 0.911778f, 0.087549f, 0.986304f, 0.038702f, 1.198866f, 0.102998f, 1.738602f, 0.003325f, 0.893458f, 0.089573f, 0.774873f, 0.008601f, 0.758146f,
0.414743f, 3.511649f, 0.004885f, 2.371922f, 0.470191f, 3.610631f, 0.067832f, 4.763402f, 0.596568f, 6.864031f, 0.006285f, 3.828490f, 0.946863f, 5.583251f, 0.029670f, 5.929033f,
0.396978f, 3.481285f, 0.000303f, 1.284443f, 0.277868f, 2.209978f, 0.002596f, 1.592605f, 0.041471f, 0.494202f, 0.000028f, 0.150570f, 0.333001f, 2.033698f, 0.000676f, 1.179693f,
1.431168f, 8.961746f, 0.006037f, 4.771045f, 1.217253f, 6.912901f, 0.062891f, 7.188299f, 1.312453f, 11.167950f, 0.004952f, 4.909682f, 1.802302f, 7.859551f, 0.020226f, 6.578488f,
0.221802f, 2.050110f, 0.005235f, 0.943187f, 0.183598f, 1.539067f, 0.053075f, 1.383004f, 0.132856f, 1.668711f, 0.002805f, 0.633959f, 0.181821f, 1.170377f, 0.011416f, 0.846553f,
1.540534f, 9.705809f, 0.011866f, 4.846487f, 1.947645f, 11.128780f, 0.183740f, 10.853950f, 1.519952f, 13.013020f, 0.010471f, 5.365775f, 3.796395f, 16.657130f, 0.077792f, 13.076840f,
0.086537f, 1.212838f, 0.000040f, 0.893728f, 0.058461f, 0.743095f, 0.000330f, 1.069527f, 0.010994f, 0.209378f, 0.000005f, 0.127407f, 0.070265f, 0.685824f, 0.000086f, 0.794553f,
0.085044f, 0.851095f, 0.000216f, 0.904954f, 0.069812f, 0.633635f, 0.002176f, 1.315928f, 0.094842f, 1.289801f, 0.000216f, 1.132478f, 0.103668f, 0.722514f, 0.000702f, 1.207820f,
0.001896f, 0.028015f, 0.000027f, 0.025742f, 0.001515f, 0.020299f, 0.000264f, 0.036430f, 0.001381f, 0.027731f, 0.000018f, 0.021041f, 0.001505f, 0.015481f, 0.000057f, 0.022365f,
0.145252f, 1.462557f, 0.000675f, 1.458597f, 0.177237f, 1.618534f, 0.010089f, 3.152748f, 0.174279f, 2.384640f, 0.000724f, 1.963833f, 0.346486f, 2.429654f, 0.004284f, 3.809556f,
0.071797f, 1.269254f, 0.000225f, 0.819252f, 0.051118f, 0.819577f, 0.001963f, 1.033244f, 0.010083f, 0.242237f, 0.000028f, 0.129112f, 0.041992f, 0.516986f, 0.000350f, 0.524632f,
0.247147f, 3.119800f, 0.004286f, 2.905635f, 0.213815f, 2.447862f, 0.045413f, 4.452933f, 0.304702f, 5.226774f, 0.004726f, 4.019825f, 0.217008f, 1.907722f, 0.010011f, 2.793425f,
0.047616f, 0.887217f, 0.004620f, 0.714076f, 0.040091f, 0.677490f, 0.047643f, 1.065031f, 0.038343f, 0.970869f, 0.003328f, 0.645259f, 0.027215f, 0.353152f, 0.007025f, 0.446873f,
0.217421f, 2.761408f, 0.006885f, 2.412234f, 0.279597f, 3.220617f, 0.108433f, 5.495063f, 0.288394f, 4.977408f, 0.008167f, 3.590468f, 0.373581f, 3.304323f, 0.031469f, 4.538148f,
0.004307f, 0.064904f, 0.000030f, 0.047248f, 0.002757f, 0.037686f, 0.000233f, 0.053584f, 0.000826f, 0.016908f, 0.000005f, 0.010164f, 0.003674f, 0.038564f, 0.000067f, 0.044138f,
0.005231f, 0.056292f, 0.000200f, 0.059131f, 0.004069f, 0.039717f, 0.001903f, 0.081486f, 0.008803f, 0.128734f, 0.000301f, 0.111665f, 0.006700f, 0.050214f, 0.000680f, 0.082927f,
0.002942f, 0.046728f, 0.000628f, 0.042417f, 0.002227f, 0.032086f, 0.005827f, 0.056888f, 0.003234f, 0.069798f, 0.000618f, 0.052320f, 0.002453f, 0.027133f, 0.001394f, 0.038723f,
0.008709f, 0.094295f, 0.000607f, 0.092902f, 0.010071f, 0.098892f, 0.008598f, 0.190303f, 0.015768f, 0.232006f, 0.000983f, 0.188754f, 0.021829f, 0.164600f, 0.004048f, 0.254961f,
0.218953f, 2.455414f, 0.000988f, 1.321439f, 0.156323f, 1.589916f, 0.008642f, 1.671251f, 0.028792f, 0.438764f, 0.000116f, 0.194990f, 0.201648f, 1.574832f, 0.002421f, 1.332491f,
0.387140f, 3.100065f, 0.009665f, 2.407350f, 0.335861f, 2.439157f, 0.102693f, 3.699584f, 0.446893f, 4.862875f, 0.009978f, 3.118319f, 0.535264f, 2.984962f, 0.035548f, 3.644304f,
0.152311f, 1.800301f, 0.021275f, 1.208129f, 0.128599f, 1.378563f, 0.220003f, 1.806924f, 0.114839f, 1.844551f, 0.014347f, 1.022158f, 0.137080f, 1.128384f, 0.050937f, 1.190509f,
0.890666f, 7.175890f, 0.040601f, 5.226591f, 1.148562f, 8.392530f, 0.641242f, 11.939340f, 1.106153f, 12.110540f, 0.045098f, 7.283925f, 2.409783f, 13.520950f, 0.292222f, 15.483080f,
0.244449f, 4.439133f, 0.000020f, 2.005620f, 0.121577f, 2.002337f, 0.000121f, 1.766984f, 0.023065f, 0.569180f, 0.000002f, 0.212354f, 0.130808f, 1.654294f, 0.000028f, 1.175089f,
0.252968f, 3.280229f, 0.000114f, 2.138457f, 0.152878f, 1.797888f, 0.000842f, 2.289305f, 0.209530f, 3.692088f, 0.000084f, 1.987592f, 0.203221f, 1.835173f, 0.000243f, 1.880965f,
0.004849f, 0.092803f, 0.000012f, 0.052283f, 0.002852f, 0.049503f, 0.000088f, 0.054472f, 0.002623f, 0.068227f, 0.000006f, 0.031740f, 0.002535f, 0.033797f, 0.000017f, 0.029935f,
0.358608f, 4.678624f, 0.000295f, 2.860809f, 0.322144f, 3.811753f, 0.003240f, 4.552398f, 0.319570f, 5.665674f, 0.000235f, 2.860759f, 0.563752f, 5.122175f, 0.001232f, 4.924164f,
0.357421f, 8.187070f, 0.000198f, 3.240001f, 0.187345f, 3.891947f, 0.001271f, 3.008350f, 0.037283f, 1.160494f, 0.000018f, 0.379244f, 0.137767f, 2.197674f, 0.000203f, 1.367374f,
1.295566f, 21.190300f, 0.003970f, 12.100400f, 0.825163f, 12.240380f, 0.030969f, 13.652180f, 1.186321f, 26.367410f, 0.003251f, 12.433370f, 0.749695f, 8.539457f, 0.006111f, 7.666553f,
0.214534f, 5.179471f, 0.003678f, 2.555923f, 0.132981f, 2.911762f, 0.027925f, 2.806488f, 0.128311f, 4.209583f, 0.001968f, 1.715381f, 0.080810f, 1.358696f, 0.003686f, 1.054125f,
0.945985f, 15.567560f, 0.005293f, 8.337912f, 0.895598f, 13.366770f, 0.061374f, 13.983250f, 0.931950f, 20.840900f, 0.004664f, 9.217482f, 1.071205f, 12.276570f, 0.015945f, 10.337640f,
0.151914f, 2.966531f, 0.000185f, 1.324078f, 0.071602f, 1.268096f, 0.001070f, 1.105507f, 0.021630f, 0.573985f, 0.000024f, 0.211555f, 0.085418f, 1.161638f, 0.000277f, 0.815160f,
0.194303f, 2.709322f, 0.001311f, 1.744902f, 0.111282f, 1.407288f, 0.009194f, 1.770265f, 0.242862f, 4.601803f, 0.001465f, 2.447357f, 0.164018f, 1.592725f, 0.002943f, 1.612719f,
0.093916f, 1.933003f, 0.003545f, 1.075828f, 0.052348f, 0.977164f, 0.024199f, 1.062241f, 0.076673f, 2.144486f, 0.002588f, 0.985581f, 0.051606f, 0.739701f, 0.005182f, 0.647253f,
0.268498f, 3.766863f, 0.003307f, 2.275436f, 0.228578f, 2.908375f, 0.034483f, 3.431469f, 0.361066f, 6.883554f, 0.003978f, 3.433654f, 0.443523f, 4.333346f, 0.014533f, 4.115433f,
0.660982f, 9.604382f, 0.000527f, 3.169131f, 0.347424f, 4.578428f, 0.003394f, 2.950747f, 0.064555f, 1.274673f, 0.000046f, 0.347319f, 0.401177f, 4.059604f, 0.000851f, 2.106017f,
1.230658f, 12.768690f, 0.005429f, 6.079429f, 0.786007f, 7.396268f, 0.042467f, 6.878186f, 1.055104f, 14.876190f, 0.004163f, 5.848807f, 1.121351f, 8.102497f, 0.013159f, 6.065167f,
0.416146f, 6.373316f, 0.010271f, 2.622297f, 0.258671f, 3.592895f, 0.078196f, 2.887392f, 0.233038f, 4.849918f, 0.005144f, 1.647820f, 0.246828f, 2.632581f, 0.016207f, 1.702964f,
2.349974f, 24.531870f, 0.018929f, 10.955230f, 2.231003f, 21.122500f, 0.220096f, 18.423870f, 2.167637f, 30.749770f, 0.015616f, 11.339440f, 4.190161f, 30.462570f, 0.089786f, 21.387740f,
0.072723f, 1.391724f, 0.000010f, 0.957299f, 0.047674f, 0.827452f, 0.000081f, 1.111685f, 0.007016f, 0.182468f, 0.000001f, 0.103643f, 0.054844f, 0.730935f, 0.000020f, 0.790461f,
0.081519f, 1.113958f, 0.000063f, 1.105627f, 0.064937f, 0.804781f, 0.000612f, 1.560136f, 0.069043f, 1.282089f, 0.000048f, 1.050793f, 0.092294f, 0.878320f, 0.000189f, 1.370567f,
0.001831f, 0.036924f, 0.000008f, 0.031670f, 0.001419f, 0.025961f, 0.000075f, 0.043492f, 0.001013f, 0.027757f, 0.000004f, 0.019660f, 0.001349f, 0.018951f, 0.000015f, 0.025555f,
0.141116f, 1.940192f, 0.000198f, 1.806172f, 0.167092f, 2.083541f, 0.002877f, 3.788447f, 0.128589f, 2.402480f, 0.000162f, 1.846857f, 0.312648f, 2.993590f, 0.001169f, 4.381412f,
0.052814f, 1.274878f, 0.000050f, 0.768120f, 0.036489f, 0.798836f, 0.000424f, 0.940076f, 0.005633f, 0.184784f, 0.000005f, 0.091936f, 0.028690f, 0.482297f, 0.000072f, 0.456859f,
0.207367f, 3.574268f, 0.001088f, 3.107372f, 0.174089f, 2.721419f, 0.011182f, 4.621110f, 0.194162f, 4.547776f, 0.000911f, 3.264857f, 0.169112f, 2.029978f, 0.002359f, 2.774629f,
0.040230f, 1.023552f, 0.001180f, 0.768982f, 0.032870f, 0.758457f, 0.011813f, 1.112966f, 0.024604f, 0.850639f, 0.000646f, 0.527729f, 0.021357f, 0.378406f, 0.001667f, 0.446963f,
0.184895f, 3.206509f, 0.001771f, 2.614646f, 0.230731f, 3.629017f, 0.027061f, 5.779820f, 0.186258f, 4.389449f, 0.001595f, 2.955626f, 0.295070f, 3.563692f, 0.007517f, 4.568652f,
0.053810f, 1.107351f, 0.000112f, 0.752478f, 0.033430f, 0.623935f, 0.000855f, 0.828118f, 0.007834f, 0.219088f, 0.000015f, 0.122938f, 0.042641f, 0.611109f, 0.000237f, 0.652881f,
0.074551f, 1.095486f, 0.000861f, 1.074140f, 0.056280f, 0.750032f, 0.007958f, 1.436411f, 0.095283f, 1.902636f, 0.000984f, 1.540525f, 0.088691f, 0.907608f, 0.002724f, 1.399135f,
0.042217f, 0.915700f, 0.002727f, 0.775903f, 0.031017f, 0.610154f, 0.024539f, 1.009806f, 0.035243f, 1.038785f, 0.002036f, 0.726840f, 0.032693f, 0.493843f, 0.005618f, 0.657885f,
0.125800f, 1.859893f, 0.002652f, 1.710474f, 0.141164f, 1.892819f, 0.036447f, 3.400028f, 0.172984f, 3.475381f, 0.003261f, 2.639307f, 0.292864f, 3.015385f, 0.016424f, 4.359921f,
0.188166f, 2.881324f, 0.000257f, 1.447459f, 0.130365f, 1.810463f, 0.002180f, 1.776433f, 0.018792f, 0.391024f, 0.000023f, 0.162210f, 0.160953f, 1.716396f, 0.000584f, 1.355624f,
0.379489f, 4.149336f, 0.002865f, 3.007729f, 0.319476f, 3.168075f, 0.029541f, 4.485392f, 0.332689f, 4.943172f, 0.002246f, 2.958863f, 0.487320f, 3.710755f, 0.009787f, 4.228924f,
0.150343f, 2.426456f, 0.006351f, 1.519962f, 0.123178f, 1.803027f, 0.063728f, 2.206008f, 0.086089f, 1.888091f, 0.003252f, 0.976657f, 0.125673f, 1.412537f, 0.014122f, 1.391129f,
0.884885f, 9.734753f, 0.012198f, 6.618498f, 1.107324f, 11.048160f, 0.186958f, 14.671330f, 0.834626f, 12.477220f, 0.010290f, 7.005050f, 2.223647f, 17.036170f, 0.081546f, 18.210170f,
0.403293f, 4.420010f, 0.000031f, 2.232946f, 0.203386f, 2.021630f, 0.000194f, 1.994810f, 0.033639f, 0.500991f, 0.000002f, 0.208999f, 0.214404f, 1.636457f, 0.000044f, 1.299772f,
0.415223f, 3.249480f, 0.000179f, 2.368725f, 0.254450f, 1.805974f, 0.001340f, 2.571326f, 0.304030f, 3.233231f, 0.000117f, 1.946241f, 0.331401f, 1.806149f, 0.000379f, 2.069959f,
0.005844f, 0.067511f, 0.000014f, 0.042528f, 0.003486f, 0.036516f, 0.000103f, 0.044930f, 0.002795f, 0.043876f, 0.000006f, 0.022824f, 0.003036f, 0.024426f, 0.000019f, 0.024192f,
0.522539f, 4.114426f, 0.000410f, 2.813095f, 0.475978f, 3.399031f, 0.004579f, 4.539157f, 0.411642f, 4.404512f, 0.000289f, 2.486749f, 0.816119f, 4.475198f, 0.001705f, 4.810552f,
0.512132f, 7.079840f, 0.000271f, 3.132886f, 0.272197f, 3.412724f, 0.001766f, 2.949628f, 0.047224f, 0.887141f, 0.000022f, 0.324170f, 0.196117f, 1.888100f, 0.000276f, 1.313571f,
1.846912f, 18.231260f, 0.005412f, 11.640820f, 1.192795f, 10.678590f, 0.042809f, 13.317590f, 1.495010f, 20.054050f, 0.003918f, 10.573730f, 1.061788f, 7.299222f, 0.008277f, 7.327417f,
0.224588f, 3.272417f, 0.003682f, 1.805658f, 0.141163f, 1.865428f, 0.028347f, 2.010436f, 0.118743f, 2.351134f, 0.001741f, 1.071281f, 0.084047f, 0.852849f, 0.003666f, 0.739855f,
1.197161f, 11.889990f, 0.006406f, 7.120701f, 1.149265f, 10.352060f, 0.075314f, 12.109130f, 1.042596f, 14.071240f, 0.004989f, 6.958775f, 1.346813f, 9.315468f, 0.019170f, 8.771086f,
0.336282f, 3.963213f, 0.000392f, 1.977955f, 0.160719f, 1.717868f, 0.002296f, 1.674572f, 0.042327f, 0.677882f, 0.000044f, 0.279371f, 0.187856f, 1.541828f, 0.000583f, 1.209797f,
0.427928f, 3.601171f, 0.002761f, 2.593335f, 0.248516f, 1.896730f, 0.019635f, 2.667873f, 0.472830f, 5.407121f, 0.002728f, 3.215437f, 0.358880f, 2.103249f, 0.006159f, 2.381294f,
0.151892f, 1.886771f, 0.005482f, 1.174178f, 0.085848f, 0.967150f, 0.037950f, 1.175583f, 0.109621f, 1.850397f, 0.003539f, 0.950909f, 0.082920f, 0.717315f, 0.007962f, 0.701830f,
0.524944f, 4.444718f, 0.006183f, 3.002158f, 0.453153f, 3.479800f, 0.065374f, 4.590800f, 0.624041f, 7.180129f, 0.006574f, 4.004797f, 0.861499f, 5.079893f, 0.026995f, 5.394501f,
1.052104f, 9.226384f, 0.000802f, 3.404134f, 0.560748f, 4.459825f, 0.005238f, 3.213941f, 0.090836f, 1.082471f, 0.000062f, 0.329800f, 0.634412f, 3.874472f, 0.001287f, 2.247476f,
1.948906f, 12.203740f, 0.008221f, 6.497015f, 1.262174f, 7.168010f, 0.065212f, 7.453570f, 1.477080f, 12.568790f, 0.005573f, 5.525524f, 1.764258f, 7.693647f, 0.019799f, 6.439626f,
0.483953f, 4.473174f, 0.011423f, 2.057959f, 0.305031f, 2.557020f, 0.088179f, 2.297735f, 0.239574f, 3.009122f, 0.005057f, 1.143193f, 0.285179f, 1.835688f, 0.017906f, 1.327783f,
3.303681f, 20.814150f, 0.025447f, 10.393310f, 3.180348f, 18.172410f, 0.300033f, 17.723630f, 2.693871f, 23.063490f, 0.018559f, 9.509973f, 5.852382f, 25.678010f, 0.119921f, 20.158780f,
0.005545f, 0.077720f, 0.000003f, 0.057271f, 0.004175f, 0.053072f, 0.000024f, 0.076386f, 0.000868f, 0.016535f, 0.000000f, 0.010062f, 0.005172f, 0.050477f, 0.000006f, 0.058479f,
0.005449f, 0.054528f, 0.000014f, 0.057979f, 0.004985f, 0.045246f, 0.000155f, 0.093966f, 0.007488f, 0.101839f, 0.000017f, 0.089417f, 0.007628f, 0.053166f, 0.000052f, 0.088878f,
0.000188f, 0.002775f, 0.000003f, 0.002550f, 0.000167f, 0.002241f, 0.000029f, 0.004022f, 0.000169f, 0.003385f, 0.000002f, 0.002569f, 0.000171f, 0.001761f, 0.000006f, 0.002544f,
0.008632f, 0.086920f, 0.000040f, 0.086685f, 0.011740f, 0.107207f, 0.000668f, 0.208829f, 0.012764f, 0.174653f, 0.000053f, 0.143833f, 0.023650f, 0.165844f, 0.000292f, 0.260033f,
0.007607f, 0.134479f, 0.000024f, 0.086800f, 0.006036f, 0.096780f, 0.000232f, 0.122012f, 0.001317f, 0.031629f, 0.000004f, 0.016858f, 0.005110f, 0.062912f, 0.000043f, 0.063842f,
0.026180f, 0.330479f, 0.000454f, 0.307793f, 0.025243f, 0.289000f, 0.005362f, 0.525723f, 0.039778f, 0.682335f, 0.000617f, 0.524773f, 0.026402f, 0.232102f, 0.001218f, 0.339861f,
0.007799f, 0.145310f, 0.000757f, 0.116952f, 0.007318f, 0.123669f, 0.008697f, 0.194411f, 0.007739f, 0.195962f, 0.000672f, 0.130240f, 0.005119f, 0.066432f, 0.001321f, 0.084061f,
0.021364f, 0.271339f, 0.000676f, 0.237029f, 0.030620f, 0.352707f, 0.011875f, 0.601794f, 0.034923f, 0.602742f, 0.000989f, 0.434790f, 0.042161f, 0.372916f, 0.003551f, 0.512162f,
0.000195f, 0.002932f, 0.000001f, 0.002134f, 0.000139f, 0.001897f, 0.000012f, 0.002698f, 0.000046f, 0.000941f, 0.000000f, 0.000566f, 0.000191f, 0.002001f, 0.000004f, 0.002290f,
0.000236f, 0.002542f, 0.000009f, 0.002671f, 0.000205f, 0.001999f, 0.000096f, 0.004102f, 0.000490f, 0.007166f, 0.000017f, 0.006215f, 0.000348f, 0.002605f, 0.000035f, 0.004302f,
0.000205f, 0.003263f, 0.000044f, 0.002962f, 0.000173f, 0.002497f, 0.000453f, 0.004428f, 0.000278f, 0.006007f, 0.000053f, 0.004503f, 0.000197f, 0.002176f, 0.000112f, 0.003106f,
0.000365f, 0.003951f, 0.000025f, 0.003892f, 0.000470f, 0.004618f, 0.000401f, 0.008886f, 0.000814f, 0.011979f, 0.000051f, 0.009746f, 0.001050f, 0.007920f, 0.000195f, 0.012269f,
0.018109f, 0.203080f, 0.000082f, 0.109292f, 0.014410f, 0.146558f, 0.000797f, 0.154056f, 0.002935f, 0.044722f, 0.000012f, 0.019875f, 0.019155f, 0.149597f, 0.000230f, 0.126577f,
0.032013f, 0.256346f, 0.000799f, 0.199065f, 0.030953f, 0.224796f, 0.009464f, 0.340958f, 0.045541f, 0.495559f, 0.001017f, 0.317777f, 0.050836f, 0.283492f, 0.003376f, 0.346112f,
0.019473f, 0.230169f, 0.002720f, 0.154460f, 0.018325f, 0.196437f, 0.031349f, 0.257476f, 0.018094f, 0.290630f, 0.002260f, 0.161053f, 0.020129f, 0.165694f, 0.007480f, 0.174817f,
0.068318f, 0.550421f, 0.003114f, 0.400902f, 0.098190f, 0.717473f, 0.054819f, 1.020689f, 0.104564f, 1.144801f, 0.004263f, 0.688544f, 0.212297f, 1.191170f, 0.025744f, 1.364030f,
0.014425f, 0.261958f, 0.000001f, 0.118354f, 0.007996f, 0.131693f, 0.000008f, 0.116214f, 0.001677f, 0.041393f, 0.000000f, 0.015443f, 0.008866f, 0.112123f, 0.000002f, 0.079644f,
0.014925f, 0.193531f, 0.000007f, 0.126167f, 0.010053f, 0.118223f, 0.000055f, 0.150537f, 0.015235f, 0.268451f, 0.000006f, 0.144518f, 0.013771f, 0.124357f, 0.000016f, 0.127460f,
0.000442f, 0.008466f, 0.000001f, 0.004769f, 0.000290f, 0.005033f, 0.000009f, 0.005538f, 0.000295f, 0.007670f, 0.000001f, 0.003568f, 0.000266f, 0.003541f, 0.000002f, 0.003136f,
0.019626f, 0.256052f, 0.000016f, 0.156567f, 0.019650f, 0.232503f, 0.000198f, 0.277680f, 0.021554f, 0.382128f, 0.000016f, 0.192947f, 0.035436f, 0.321968f, 0.000077f, 0.309521f,
0.034873f, 0.798797f, 0.000019f, 0.316121f, 0.020372f, 0.423222f, 0.000138f, 0.327137f, 0.004483f, 0.139540f, 0.000002f, 0.045601f, 0.015438f, 0.246274f, 0.000023f, 0.153230f,
0.126381f, 2.067081f, 0.000387f, 1.180375f, 0.089713f, 1.330788f, 0.003367f, 1.484281f, 0.142617f, 3.169823f, 0.000391f, 1.494708f, 0.083995f, 0.956749f, 0.000685f, 0.858950f,
0.032357f, 0.781184f, 0.000555f, 0.385492f, 0.022354f, 0.489460f, 0.004694f, 0.471764f, 0.023849f, 0.782446f, 0.000366f, 0.318842f, 0.013998f, 0.235363f, 0.000638f, 0.182603f,
0.085599f, 1.408657f, 0.000479f, 0.754470f, 0.090322f, 1.348046f, 0.006190f, 1.410219f, 0.103926f, 2.324065f, 0.000520f, 1.027884f, 0.111328f, 1.275878f, 0.001657f, 1.074369f,
0.006320f, 0.123410f, 0.000008f, 0.055083f, 0.003320f, 0.058796f, 0.000050f, 0.051257f, 0.001109f, 0.029427f, 0.000001f, 0.010846f, 0.004081f, 0.055503f, 0.000013f, 0.038949f,
0.008082f, 0.112687f, 0.000055f, 0.072575f, 0.005159f, 0.065236f, 0.000426f, 0.082063f, 0.012449f, 0.235879f, 0.000075f, 0.125446f, 0.007835f, 0.076086f, 0.000141f, 0.077041f,
0.006040f, 0.124307f, 0.000228f, 0.069184f, 0.003752f, 0.070036f, 0.001734f, 0.076134f, 0.006076f, 0.169954f, 0.000205f, 0.078109f, 0.003812f, 0.054634f, 0.000383f, 0.047806f,
0.010359f, 0.145331f, 0.000128f, 0.087790f, 0.009829f, 0.125061f, 0.001483f, 0.147554f, 0.017168f, 0.327294f, 0.000189f, 0.163261f, 0.019654f, 0.192021f, 0.000644f, 0.182365f,
0.050343f, 0.731501f, 0.000040f, 0.241371f, 0.029492f, 0.388647f, 0.000288f, 0.250479f, 0.006059f, 0.119644f, 0.000004f, 0.032600f, 0.035094f, 0.355121f, 0.000074f, 0.184228f,
0.093712f, 0.972309f, 0.000413f, 0.462936f, 0.066708f, 0.627718f, 0.003604f, 0.583748f, 0.099015f, 1.396038f, 0.000391f, 0.548874f, 0.098073f, 0.708638f, 0.001151f, 0.530455f,
0.048995f, 0.750363f, 0.001209f, 0.308736f, 0.033943f, 0.471459f, 0.010261f, 0.378883f, 0.033813f, 0.703700f, 0.000746f, 0.239091f, 0.033377f, 0.355988f, 0.002192f, 0.230281f,
0.165991f, 1.732819f, 0.001337f, 0.773827f, 0.175637f, 1.662882f, 0.017327f, 1.450431f, 0.188693f, 2.676773f, 0.001359f, 0.987100f, 0.339939f, 2.471364f, 0.007284f, 1.735142f,
0.000080f, 0.001532f, 0.000000f, 0.001054f, 0.000058f, 0.001015f, 0.000000f, 0.001364f, 0.000010f, 0.000247f, 0.000000f, 0.000141f, 0.000069f, 0.000924f, 0.000000f, 0.000999f,
0.000090f, 0.001226f, 0.000000f, 0.001217f, 0.000080f, 0.000987f, 0.000001f, 0.001913f, 0.000094f, 0.001739f, 0.000000f, 0.001425f, 0.000117f, 0.001110f, 0.000000f, 0.001732f,
0.000003f, 0.000063f, 0.000000f, 0.000054f, 0.000003f, 0.000049f, 0.000000f, 0.000082f, 0.000002f, 0.000058f, 0.000000f, 0.000041f, 0.000003f, 0.000037f, 0.000000f, 0.000050f,
0.000144f, 0.001980f, 0.000000f, 0.001844f, 0.000190f, 0.002370f, 0.000003f, 0.004310f, 0.000162f, 0.003022f, 0.000000f, 0.002323f, 0.000367f, 0.003510f, 0.000001f, 0.005137f,
0.000096f, 0.002320f, 0.000000f, 0.001398f, 0.000074f, 0.001620f, 0.000001f, 0.001907f, 0.000013f, 0.000414f, 0.000000f, 0.000206f, 0.000060f, 0.001008f, 0.000000f, 0.000955f,
0.000377f, 0.006503f, 0.000002f, 0.005653f, 0.000353f, 0.005518f, 0.000023f, 0.009371f, 0.000435f, 0.010197f, 0.000002f, 0.007320f, 0.000353f, 0.004242f, 0.000005f, 0.005798f,
0.000113f, 0.002879f, 0.000003f, 0.002163f, 0.000103f, 0.002378f, 0.000037f, 0.003489f, 0.000085f, 0.002949f, 0.000002f, 0.001829f, 0.000069f, 0.001223f, 0.000005f, 0.001444f,
0.000312f, 0.005412f, 0.000003f, 0.004413f, 0.000