#NEXUS

BEGIN TAXA;
	DIMENSIONS NTAX = 8;
	TAXLABELS
		'1' '2' '3' '4' '5' '6' '7' '8' ;
END;

BEGIN CHARACTERS;
	DIMENSIONS NCHAR = 2000;
	FORMAT
		DATATYPE = DNA
		GAP=-
		MISSING=?
	;

MATRIX
	'1'  CTATACCTAGTTTGGTTAAGGCTAATATAACTGAATACGTCACTATCTTAATACTATTCCCAACGAAGAAACTTACGTGTTATGAAACTTAATATAAAAACAAATAAAATAAATTTAAACTTGTGCCATTTTTTTTATTATGCCTAATATCCAATAATTTTATCTCACCCATAGATCACTACCATATTTCTTGAACTGTCTAAACTAATTAAAACTCCAACACCACATAATCGTATATACATTTCAATAAACCAACCTATTCCAATAGAACAAAACTAATATTCAATTATCTCATCATGCTATCTAATCTACTGAACATAGTCAGTCAGCCTTAAACACAGAATAGCAAATACTGTACAATCAAACACGATGTAATATATACTTAAAATAAAAGTACATGAAACATCAATTTTTGAAATATCACAAAATTACATGTAATATGACGAATGGCCTAAGTTGGCGACACTGATGAACTAAAATAATGGCAGAAGAGAGCTCTACAGGAACTCAAGTACATGTACTTGCTCGCACGCTGTTCACATCTGTTCCCGTTAAATCATCTCAACAATCTAAATTAATTCTAAATATAAACAGAGAGTTCTCTATTTTATGTTACAAGAGGATTCATAATATTCTAATTATCGCCATGCCTGAATACCTACAATTTAATAAATCAACCATCCCCATAAAAATAGTCATCATTTACTTTTTTGAGGAAGGACAAACATAACGAATCACAATTAAATAACATATATTATACAGAAACCAACTTAAAACCTCTTGACGAACCAATCTTAAATACTCAAATATACATTTAAAGATAGTAAGACGCAAAAAGCACAATTAACGCTCACTTCATTAATATTCCCAACCCAACTTATGAGCTTTACAGTTCCATAATGATACCCTCCTTTCTACTACAAATAAGTCCATCCTCAAGTTCATGGCAATAAAATTACATTTAATTCCTCTACTCAATCAAAGTCCTAAATAAGTTTTATTCAAATACCAGATGTCCACTCTTTTATCTATCTACCACTCCAGTACGAAATCGCACTATCTTCAACATGAATTCACACAACCATTGAATATTACTTTACGAAAACGAAGTATATTTTACTCCACAATAGATAAACGATAAAGCCTTACAATAAAACTCAAAATCTACCCAAATCTAAAAAGTGGTAACAATGATTTTCTGACATCACTATAAAAATTCTGTTCCATATGCCGTTAATTCAATGACTCAATTACACAAGTTATGTGTCGCTACATCAAACTCTTAAAACAAACCAACTAAACATTAGTGACTCACATTCAACGAAATAGAACCTACAAGGCGAAACCAAACCGAAAATATCAAACATAAACCTGACTCTATGATCCTGAAACATAACATCTACTGTAATGATATTCTAACTAGAAATTAAAAACAACATACTAAGCACATAAGTAAATAACCTTCAACTTACAATCTTTATATCAATTAAATCTGTCTATCTAAATAACAATTAACACGTCTTATAATTCCATCCAAATACTACCGTTAATACCTTGTGCTCTATCCAACGAGAGAGCAAAAAAACTTTCACAATCAATGAATGAACTTCGTAAATTCCTTTCAAAAATATAATATTGCGTCAGTATCTCACTTATACAACAATAATGAAAATTGGAATAATAACATAATAGGAGTAAAGTAATAAAGTACTAAAAAAAGCCAACTCTCCATACCCTTACTCTACTATAACAGACCAAATCCTATTCTAGCCATTAAGCGGTTATAAAGTACATGAACAATCCATACGTATTAAATAAAATCTGCCACCCTAACTTATTCATTTACTATTACACAACAAAAACTACTGCAAAAAATACAATAGAGTTTTTGCGCATTATGGCTATCTACACACGCATCTTCTAATACTAATCACACCCTAATATCTTATTCTTTAATTATACCTTATCAGTTAACTACACCGGCAAACTAGGATTGTTAC
	'2'  CTATACCTAGTTTGGTTAAGACTAATCTAATTGAATCCGTAACTATCTAAACATTATTCCCAACGACTAAACTTACGTGATACGAAACTTAAAATAATAACAAATAAAATAAATTTAAACCTATGCCATTTTTTTTATTATACCTAGTATCCATTGAATCTATCTCACCCGTAGATCAATATCACATTTCTTGTACTCTCAAAACTAAGTAAAACTGCTACACCCCATAATCGTCCATAAAGCTTAGTAGACCAACACATTCCTCTAGTACAAAAATGATACCCAATGTCTTTATCTTTTTTCCTAATCCTCTAAACGCAACCAGCCGACTTCAAACACAGAATAGTCCATACAGTACAATTAAAATCAATGTAACATATAATCAAAACCAAAGCACACTAAAAACCCATTTTCGAAACATCACAAAATTATATCTAATATGATGAATGGTCTAAATCGGAGACACTGCTGAGCTAGAAAAATGGCAGAACAGAACTCTACAGGAATTCAAGTACATGTACGTGCTCGTACGATGCTCACATCTATTCCTATTAAACCTTATCAACAACCTCAATTAATTCTAAATATAAACCAAGAGTTCTCTGTTTTAAGTTACAAAAGCGTAAATATTTTTCTACTTAAAGCCATGCCTGAATTCCTATAATTTAATAAGTCAATCATCACTTTAAAAATAGTCATCCTTTACTATCTTGCGGAGGCACAAACAAGATGAAACACAAATAAACGAAATATACTATACAGAAACAAACTAACTATATCTTGACAAACCAATGATATTTACTCAAATAAACATTTAAAGAAAGTAAGACGCAAAAGACACAATAAACGTTCACTTCATTAATATTCCCAACCCAACTTATGAACCTTACAGTTCTATAATGATACCCTCCTCTTCACTGCAAGTAAGTCCATTCACGAAATCATGGCAATAAAATAACATTTAACTCCTCTACTTACTCAAAGTCCCATATAAGTTTTATTTAATTCTCCGATGCCAACCCTTTTATCTATTTAAAACTCCAGCCAAAATTCGCGCTATCTTCAGCATTAAGACATACACCCGTTGACGCTTACTTTACGAACACTAAGTGTAGTATACCCCACAATAGATTAGAGATAAATCCTTACAATAATACATAAAATCTTCACAAATCCATAATGTGGTAATAATGATTCTTTTAAATCCCTATAAAAATTCTGTTCCATATGCCCATAATTCAATGTTTCAATTACAAACGTTATGTGTCGCTACACCAAACTCTTAAAACACACCAACTAAACATCAGTCATTCACATTTAACGAATTATAATCTACAAGGCGAAACCAAACAGAAAATATCGAACACAAACCTGCCTCTAAGATCCTGAAACATAACATCTTCCGTAATAATCGTCTCACTAAAAATTAAATGCAACATGATAAATACTTAAGTAAATCACTATCAAATTAAAATCTTTAAATCAATTAAAATTGATTATCTAAATAACATATCAAACGTTTTAGAATTCCATCAATATACCATCGTCCGAACCTTGTGCCCAATCCAACGAGAATCTAAAGGATCTTTCAAAATCAGTGAATCTAATTTGTACATTCCTTTTAAAAATATAAAATTGCATCAGTTTCTCGCTTATACAACATTGCTGAAAATTGGAATAATAACATAACAGGAGTAAAATAATAAAGTATTACAAAGAGCTCACTCTCCAAACCCTTACTCTACTATATCAGAACAAATCCTAATCTAGCCATCTAGCGGTTATCAAGCACATTAACAATCTATATGTTAAAAATATAATCTGCGGCCATTACTTACCAATTAACTCACACATAACTAAATTTATTACAAAATATACAATAGAGTTTTAGTTTATCATAAGAATCAAAACAAGACTCTTATACTGCTAGTCGCACCTTACAATCTTATTCTTTGATTATACCATATCACTCAGCTACACCGGCAACCTAGGTTCCTTAC
	'3'  TTATATTTAGTTTGATTAAGGCTAATCTAACTGAATACGTCACTATATTAACATTCTTCCCGACGAAAAAATTCACATGTTATAAAATTTAATATAACAACATATAAAATAGATCTAAACTTATGCCATTTTATGTATTATGCTTAATACCCAATAATTTTATTTAACCCATAAACCATCATCACATTTTCTTAAATCTCATAACTAACTAAGACTGCAACACCGCATAATCGTCCATAAAGCTTAGTAGACCAACACATTCATATAGTACAAAAATGATACCAAATGTCTTTATCTTTTTTCCTAATCCGCTAAACGCAATCAGCCGACTTCATACACAGAATAGTCTATACAGTACAATTAAAATCAATGTAACATATAATAAAAACCAAAGCACACGAACATACCCCTCTAAAAACATTACTAAATTACATTTTATATATAGACTGGTCTAAACAGGATACACAGCTTAGCTAAAAAAAAGGTAGAATAGAATTCAATAGAAATGCAAGTAAATATATATGCTCGTACCTTGACCACATCTATCAATGTCAAAGCATATTAACAATCTAAATTAGTTCTGAATATCAACAAAAGCTTAATTGTTTTATGTTAATAAAGAATAAATACTTTTCTAATTAAAGCCATACCTGAATTCCTATAATTTAATAAGTCAATCCTCACTTTAAAAATAGTCATCCTTTACTATCTTGCGGAGGAACAAACAGAATGAAACACAAATAAATGAAACATACTATACAGAAACAAACTAACTATATCCTGACAAACCGATGATAGTTACTCAAATATACATTTAACGATAGTTAGAAGCAAAAGTCACAATAAAAGTTCACTCCATTAATCTCCCCAACCCAACTTATCAGACTTACAGTTCTATAATGATTCCCTCCTCCACTCTATAAGTAAGTCCACTCACTAGCTCATGACGAAAAAATCCCAGATAACTCCTCTCCACTCTAAAAGTCTTAAATAAGTTTTATATAATTCTCCGACGCCAACCCTTTCACCTATTTAAAACTCCAGCAAAGTTTCGCAATATCTTCAGCATTAAAACATACATCCGTTGAAGCTTACTTTACGAACACTAAGTATAGTATACCCCACAACAGATTAAAGATAAATCCTTACAATAATACATAAAATCTACACAAATCCATAACGTGGTAATAATGATTCTTTACAATAACTATAAAAATTCTATTCCATACGCCCCTACTTTTGTGTTTTAAAAACATATGTTATGTAAAGCTACTTCACCCTCTTCATACAAAATTACTAAACATCAGTTACTCACATTAAAAGCATCATAACCTACAAGGCGATACTAAACTAACAATATCTAATCTAACCCTGATACTAAGACCCTGAAACATCCCATATTCTGTAATAATTATCTCACTAAAAATTAAATGCAACATGATAAATACCTAAGTAAATCACCATCAAATTAAAATCTTTAAATCAATTAAACTTGATTATCTAAATAACATATCAAACGTTTCAGAATTCCATCCAAATACCATCGCTCGAACCTTGTGCCTAATCCAATGAGAGTCTAAAGGATCTTTCAAAATCAGTGAGCCTAATCAGCATACACCTTAAAAAAACCCAAAATTTCTTCGGTCTCTCACTTACAAAACATCTCTGAAAGTTGGAGTAATAACATAAGAAGAGTAAATTAATACAATAATATAAAAAGTTCACTCTCTATATCCTGACCCTACCGCTACAGAACAAATCCTATTTCAGCCATCCAGCGGCTATAAAAAAGCTTAATGATCTATATGTAAAAAATATAACCTGCAGCCATAGCGTACCTATTAACTTACACATAACTAAAATTAGTACAAAACATACAATAGAGTTTCAGTTTATCATAAGAAACAAAACATGTCTCTTATAATGCTCGTCACACCTCACAATCTTATTCTTTAATTATACCTTACCACTCAGCTACACCGGCAAACTAGGATCCTTAC
	'4'  TTATATTTAGTTTGATTGAGCCTAATCTAACTGAATTCGTTACTATATTAACATTCTTCCCTACGAAAAAATTCACCTGTTATAAAATTTAATATAATAACCTATAAAATAGATCTAAACTTATGCCATTTTCTATATTATACTTATTACCCAATGATTATATCTAACCCATAAATCAACATCATATTTTCTTAAATCTCGTAACTAAATAAAACTACCACATCGCATAGTCGTGCAGAGAACTTAATAGACCAACACATTCCCATAGTACAACACTGATACCAAATATCTTTATCTTTTTCCCTAATCCCCTAAACGCAATCAGCCGACTTCAAACACAGAATAGTCCATACAGTACAATTAAAACCAATGTAACATATAATAAAAACAAAAGCACATGAACCTACCCCTTTAGAAACATCACTAAATTACATTTAAGATGTCGACTGGCCTAAACAGGAAACACTGCTTAGCTAAAAAAAAGGTAGAACAGAATTCTATAGAAATGCAAGCACATCTATGTGCTCGTAACTTGCCCACATCTATCAATGTAAAAGCTTATTAACAATCTAAATTAATTCTAAATATCAACAAAAGTTTCCCTGTTTTATGTTACAAAAGCATAAATATTCTTATACTTAACGCCATGCCTGAATTCCTATAATTTGATAAGTCAATCATCACCTTAGAAATAGTCATTTTTCACTATCCTGCGGAGGGACAAACAAAATGAAACTCAACTATATGCAACATACTATACAGAAACAAACTAACAACATCTCGACAAACCAATCATATATACTCAAATATACACTTAACGAGAGTAAGAAGCAAAAGGCACAATTAATGTTCACCTCATTAATATCCCCAACCCATCTAATGAAGCTTACATTTCTATAATGATTCTCTCCTCCATTCTATAAGTAAGTCCATTCACTAGTTCATGACAAAAATATTCCAGATAACTCCTCTACACTTTAAAAGTCTTAAATAAGTTTTATGTAAATCCCCGACGCCGACCCTTTTATCTATATACAACTCCAGCTAAGAGTCGCACTATCTTCAAAAATAAGACATACATACATTGACGCTTACTTTACGACCACTGAGTCTAGTATACACCACAATAGATTAGAGATAAAACCTTACAGTAATACAAAAAATCTACACAAATCTAAAACGTGGTAACAATAATTTTTTTTAATAACTATAAAAATACTATTCCATACGCCACTATTTTTGTGACTTAAACACATATGTTATGTAAAGCTACTTCAACGTCTTAATACAGAATAGCTCAACATCAGTTACTGACATTTAAAGTATCATAATCTACCAGGCGATACTAAACTAACAATATCTAATATAACCCTGGCACCAAGACCCTGAAACATACCATCTTCTGTAATAATCGCCTCAATAAAAATTAAATGCAACATGATACATACCTAAGTAAATGACATTCAAATTAAAATCTTTAAATCAATTAAACTTGATTATCTAAATGATATATAAAACGTTTTAGAATTCCTTCGAAATATCACCGTTCATACCTTGTGCTCAATCTAATAAGAGTTCAAAAGACCTTTCAAAATCAGTGAGCCTAATCAACAAACTCCTTAAAAAAACCTAAAATTACTTCGGTCTATCACCTATAAAATAACTCTGAAAAATAGAGTAATAACATAAAAAGAGTAAACTAATATAATAATAAAAACTGTTTACTCTCTAAAACCTGCCCCTACCACAACAGAACAAATCCTATTTCAGCCATCTAGTGGCTATAGAAAATCCTAATGATCTATATGTCAAAAATATAGTCTGCAACCATAACGTACCTATTTACTTACACATAACTAAAATTAGTACAAAATATACAATCAAGTTTATATTTATTATAAAAACCAAAACACAGCTCTTATAATGCTCGTCACACCCTACAATCTTATTCTTTGATTATACCTCATCATTCAGTTATACCGGCCAACTAGGTCCTTTAC
	'5'  TTGTAATTAGTTTGGTTAAGTCTAATATAATCGATTCCGTCACTATTTTAACATTTTTCTCAACGAAGAAATTCGTGTGATATGACATAAAGTATACTAACTAAAAAAACAAACCTAACCATATGCTATTTTATCTGTTAAGCATAGAGACCAATTATCTTAATTCATACATAGAACAAAATCATATTTATTGGAATATTAGCACTAGCTAAACTCATTACAACTCATAATCATTAACACATCTTAATATGCAACCCCATTCCTAGAGTAAACTCTCAACATTAAATATATTTATTATACTTTCCAATCTACTAAACCAATTCTATCAATATTAGACTCTTAATAGTTTATATATTACAGTCACAAATATTATAAAATATAATAAAATGAAAAGTACAATAAAGTACAATAATCGAAACATGATTAAAATCTATTTCATATAAAGACAGGCCCAAATCGGAGACATTCCTTAGCTGAAATAACGGTAGAATAGAATTCCGGAGAAAAACAAGTTTAGATAGCCGCCCGAACAATGAATATATCTCTCCAACTATAAACCTATTAACAAACTAAATCAATTCTGACTATTAACCGATTTTCCTATTTTTACAGTTAAAACAGTATGTATGGCATTTTAATTAAAGCCATGCATAAATTCCTGTAATTTGATAACTCACAATTCACAACAAAAACAGTCATTATTCAATTTTTCGCGGACAAATAACCCCCATAACACTCAACTAAATAAATTATCATATTCAGAAACTAACTAACAAGATCTTGACAAACCTACCTTAGACACACAAATATTCTTATAGCGAAAGTCAAACGCAGAAACCACTAATAACGTTAACTGCAATAATGTCTCCAACCCAATTAATAAAGTTTCCAGTTCTAGAATAATTCTCTCCTCCAAACTAACAGTAAGTCCTACTCCCAAACCATGGCCAGAAAATCTAAGCTTACTCGTCTACCCTGCAAAAATCTTAAAAAAGAAATATTAGCTTTTCAGACGACTTCTTATGTACCTATCTAAGACACCAGCCCAACTTAGCAATATATTCAACATGAATAAATATATCTATTGAAACTTTGCTTACAATAACTCAGTATATTCAACGCCACAAGATATAAAATCTAAAGACATCTATTAACACAAGATATCTTCACAAATCTATAACGTGGTAACGATAATATATTTTAATCTCTATAAAAATTATGATCCATACGCCGTTAATTAACTGGTTCAACACCAAGTGATATATTTCACTACCTCGACCCATTGACACAGATTGACAAACTACGAGCTCCTCACATTGAAATAAATACAAACTACCAGGCGATTCCGAACTAAAAATACCCAACCACAACCTGACTCTAAGAACCCTATATCTAGCATACTCTGTAATTATAATCTCATTAGAAATTAAACACAACATGATACATAAATAAGTAAACGACTCCCAAATTATAATACTTTTAACACTTAAATTTAATATTATGACGAAAATTTGACACATTTAAAAATTTCATCCTGAATTCATCCATAATACCCTGTGCCCCAACAATCTAGAGCCAAAAAAAACCTTCAAGATTACTTAAAGTAATTAATACATCTCTTAAAAAAACATAAACTTACCTCAGTTTTTCACCTAAACAATATCTCTGACTATTGGGGTAATAACATAATAAGAGTAGACTAAGAGAATAATACAAAGCGCTCACTCTCTATAACCTCACTCTACTATTACAGACCAACATCTAATTCAGCCACTTTGCAAATATTTAAAAAATTAATGAACCATATGTCTCAAATATAATCTGGAAGCCTAACTTAGACATTTATTTTTACGAAATTAGAATTAATATAAAAACTACAACCGACTTTCCCATTATAATAGTTAACAATACACGTTTCTTTTAAATGAAATCTCAACTTACAATCTTATTCTTTAATTATACCGTATCATTTAATTAAACCGGCCAACTAGGATCATTAC
	'6'  TTGTAATTAGTTTGGCTTAGTCTAATCTAATCGAATCTGTCACTATATTAATATTTTTCTCAACGGAAAGATTTATATGATATGACATATAGCCTACCAAATAAAAAAACAGAACTAACCATATGCCATTTTATATGTTAAACATAGTGACCAATTATCTTAATTTATCCCTAGACCAATATCACATTTATTGGAATATTAGTACTATCGAAATTCTACACACTTCATAATCATCAAAAGAGCTTAATACACAGCCTCATTCATAGAGCACACGCCCAACACTAAATATATTTATTATATTTTCCAATCTCCTAAACCAAAACCATCCATTTTAGCCCCTTAATGGCTAATTTATTACAACCACAAATATTATAAAACATAATAAAAAGCAAAGCACAACAAAGTCCAATAATAGAAACATGATTAAAATCTATATCATATAATGACAGGTCTAATTCGGAGACATTCCTTAGCTCAAATAACGGTAGAACAGAATTCCGGAGAAAGGCAAGATTAGGTAAACACCCGGACATTGAACATATCTCTCCATCTTCAAACCCATTAACAAACCAAATCAGTTCTAACTATTAACTGGTTTTCTTATTTTTACAGTTATGACAGTATCCATGAAATTTTAATCAAGGCCATGCATAAATTCCTGTAATTTAATAAATCAAAATTCACAGTGAAAACAGTCATTATTCAATTTATCGCGGACAAATAATCCCCATAACACTCAATTAAATGAATTATCATATTCAGAAACAAATTGACAAGATCTTGAAAAACCTTCCCTAAACACACAGATAATCTTTTAACGAAAGTTAAATGCAGAAACCACTAGTGACGTTAACTGCAATAACCTTTCCAACCCACTTAATAAGATTTCCAGTTCTAGAATAATTCACTCCTCCCAACTAATAGTATGTCCGAATACCAGCTCATGGCCAGTAATTCCAAGCTCATTCGTCTACCCTACAAGAATCTTAAACAAGGCATATAAGACTTTCAGACGACTTCCTATTTAACTATATAAAACACCAGCTCAAGTTAGCACTATCTTCAAAAAGAATGAATATACTTATTGAAACTTTGTTTACAATAACTAAGTACATTCAATGCCGCAAAATATCAAATCTAAACAAATCTATTAAGACAAGATATCTCCACAAATCTAAAACGTGGTAACGATAATATATTTTAATCCCTATAAAAATTATGTTCCATACGCCACTAATTCACTGATTAAACATCAAATGCTATATTTCACTACCCCGTCACATTGATACACATTCACAAACTACGAGACACTCACATTGAAATAAATACAAATTACAAGGCGATCCCCAACAAAAAATAACTAACCACAACCTGACACTAAGAACCCGATAAATAGCATATTCTGTAATTATAATCTTCTTAAAAATTAAACACAACATGACACATAATTAAGTAAACAGCTGTCAAATTATAATATTTTTAACTCTTAAACTTTATTTTATGACGTACATTTGACACGTTTTATAATTTCATCTCGAACTCATCATTAAAACCTTGTGCCCCAACAATTTAGAGCAAAAAAAAACTTTCAAGATTACTTAAAGTAATTAATATATCTCTTAAAAATACGTAAGTTTACTTCAGTCTTTCACTTAAACAATACCTCTGACTAATGGGGTAATAACATAACAAGAGTAGATTAATAGAATAATAGAAAGTGCACACTCTCTATACCCTCACTTTAATATTACAGCCCAACATCTACTTCAACCACTTTGCGAGTATTTAAAAGATTAATGAACTATATGTATCAAATATAATTTGGAAGCCTAACTTACCAATTTATTCCTACGAAATTAAAATTCGTACAAAAATTACAATCCAATTTCCAATTACTATAGATAACTATACACGCCTCTTCTAATTGATATCACAGCCTACGATCTTATTCTCTAATTATACCGTGTCATTTAATTAAACCGGCTAACTAGGAGCATTAC
	'7'  TTATAATTAGTTTGGTTAAGACTAATTTAACCGAATATGTCACTATATTAATATTTTTCTCGACGAATAGATTTGTATAATATAACAACTAGCTTAACAACCAAAAAAATATATATAACCATATGCCTTTTCATTTATTAAACTTAACGACCAATTATTATAATTTATTATTAGATCAATATCATATTTCCTGGAATATTGACCCTACCTAATCTAACAACATCACATAGTCATTAACAAATCTTAATCCACATCCCCATTCCTCGAGAACACCCCCATTACTAAGTTTGTTTATTATACTTTCCAATCCTCTAAACTCAAACTATCAATCTCAGACCCCTAATGGCTGTTTTGGTACATACAAAAATACTGTAAAATATAGTTAATAGAAGAGTACACCGAAGAACAATTTTAAAAACATGACCAAATTCTATCTTGTCTAACGACAAGTCTAAATTGGGGACACTAAATAGCTCAAACAAGGGTAGAATAGAATTCAGAAGAAAAGCAAGTTAAGTTAACCGCTCGGATGATGAACCCATCTATCTTTCTTTAAAATAATTAACAATCTAAAATAATCCTTACTATTAACCAACTCTCCTATGTTTGTAGTTACAACAGATTAAATAATACTACAGTCAAAGCCATTCATGAATCCCTGTAATTTACTAAATCAAAATTCACAATAGAAGTAGTCATATTTCAATTTTTGTCGGATAAATAAGCATAATAACACCCAATTAAATGAATTATAATATACAGAAACCAACCGACATAATCTTGTAACACCACTCCTAAGCACACAAATAACCGTTTACCGATAGCAAAATCCAGAAATTACCAATGAAGCTAACTGCATTAAACTATCCAACCCACTTATTCAAGTTTCCAGCTCTAATACAATTCTCTCCTCCATACTCATAGTAAGGCCAATCACAAACTCACGGCCAAGAACTATTAACTCACTCGTCTCCCAAGCGAGAATCCTAAAAAAGAACTATGCGATTTCCCGAAGACGTCCTATGTGACTATATAGGACACCAGCGCAAACTAGCAATATTTTCAATATGAATAAAAATAACTAGTGAAGCATGCATTACAATAACCAAATATATTTGACTCCACAAAATATAAATCCTAACACCATATATTAAAACAAAACACCTTCACAAATCAAAACCGAGGTAACGATAATGTCTTTTAATTACTATAAAAATCATATTCCGTATGCCCCTAATTAGCCGTTTCAACGTCAATTGTTATATATAACTACATCGTCACATTCACACAGATTGACATACTATCAGTTTATAACATTTAAATAAACATAGAATACAAGGCGGTCCTAAACAAACAATATCAAACCATAACCTGAAACCACGGACCTGAAGTGTTGCATCTCCTGTAATCTTGGCCTTCATAAGAATCAAACATAACATGATACATAACTAAGTAAACAATTTTCAAGTTATAGTACTTTTATCAATGAAACTTTATTATATGGCGAAAATTTGAAATGTTTTACATTATCATCCAAAACCCATCGTTATTACTTTGTGCTCAAGCTATTCAGAAATGAAAAATTCTTTCTAGATTTTTTAAAGTACTTACTTTATATCTTGTAAACATAAAACATTACTTCAGTTTCTCACTTAAATATTATCCCTGACATATGGTGTAATAACATAACAAGAGTAGACTAATATAATAATAGCAAATGCACACTCTCTATAACCTTCTTCTACTATAACAGATCAACATCTACTACACCCACTTTGTAGGTATTTAAAATATTAACGACCACTAAGTTTAAAATATAATCTGGTCGCCCCTCATACTTATTTAATGTTACCAAATTAAGATTAGTACAATAGTCACAACAAAATTTGTAATTATTATAACTAGCGATACATGACTCTTCTAACAGAGATCACAGCCTATCATCTTATTCTCTAATTATACCATATCAATTAATTAAACCGGCAGATTAGGAAGATTAC
	'8'  TTGTAATTAGTTTGGTTAAGTCTAATATAATCGAATATGTCACTATATTAATATTTTTCTCAACGAATAAATTTGTATTCTATAAAATCTAGACTAATAACCAAACAAATACATATAACCATATGCCCTTTCATATATTAACCTTAATGACCAATTATTTTAATTTATCATTAGATCAATATCATATTTTCTGGAATATTTAAACTACATAACACAACAACATCACATGGTCATAAATAAATCTTAATATACATCCCCATTCCTCGAGAACACCCCCATCATTAAGTTTATCTATCACACTTTCCAATCCACTAAACTCAAACTATCAATTTCAGACCTATAATGGTTAATTTGGTACATCAAAAAACACTGTAAAATATAATTAATAGAAAAGTACATCGAAGAACAAATACAAAAACATGACTAAACTCTATCTTGTCTAATGACAAGTCCAAATCGGGGACACTAAATAGCTAAAATACAGGTAGAATAGAATACAGAAGAAAGGCAGGTTCAGTTAATCGCCCGAACCATGAGCACATCTATATTTTTTAAAAATTATCAACAATCTAAAATACTACTCACTATCAACCAATTCTCCTATATTTATAGTTAAAATAGATTAAATAATTTTATAATCACTGCCATTCATGAATTCCTGCAATTTAATAAAACAAGATTCACAATAGAAGTAGCCATATTTAAATTTTTGTCGGATCAATAAACATAACAACACTCAAATAAATGAATTATAATCTACAGAAACCAACCGACATAATCACGTCACACCGCCCCTAAACACACAAATATCCGTTTACCGAGAGCACAATCCAGAAATTACCAGTAAAGATAACTGCATTAAACTGTCCAACCCACTTCTTCAAGTTTCCAGTTTTATTATAATCCTCTCCTCCATATCCATAGTAAGACCCTCCACAAATTCACGGCCAAGAGTTATTAGCTTACTCGTCTTCCCAGCAAGAATCCTGAAAAAGAAGTATAAGATTTCCCGACGACTTCCTATGTAACTATATAGGACACCAGCACAAATTAGCAATATTTTCAATATGAACAAATATAGCTATTGAAGCATTTATTACAATAACTAAATATATTTAACACCACAAAATATAAACCCTAACACCATATATTAAAACAAAAAATCTTCACAAATCAAAAACGCGGTAACGATAATGTATTCTAATCACTATAAAAATCATACTCCGTATACCAATAATTCACCGTATCAACATCAAGTGTTATATATAACTACCCCGTTAAATTCACACAGATTAGCATACTATCAGACATTAACATTCAAATCAATATAAAATACTAGGCGGTCCTGAACACACAATATCAAATCATAACCTGAAACCATGGGCCTGAACCATTGCATCTACTGTAATACTAGTCTTCATAAGAATTAAACAATACATGGTAACTAACTAAGTAAAAGATTCTCAAGTTCTAGTATTTTAAACTATGAAACTTAATTATATGATGAAAATTTGTCATGTTTTAAATTATCATCAAAAAATCATCATTATTACTCTGTGCTCAAACCATTCAGAAAAAAAAAATCCTTTCTAGATTTATTAAAGTACTTATTTCATATCTTATAAAGATAAAATCTTACATCAGTCTCTCACTTAAATATTATCCATGACACTTGGTGTAATAACATAACATGAGTAGATTAATATAATACTAGCAAGTGTAAACTCTCTATAACCTGTTTCTACCCTAACAGATCAACATCTACTCCACCAAATTTGTAGGTATTCAAAACATTAACAATAAATACGTTTAAAATATAATCTGGAAGCCTACCATCCCTATTTAATGTCACCAAATTAAAACTAGTACAATACTAACAACCGAATTTATAATTATTATAACCAACAACACATGTCTCTTTTAAGAGAGATCTCAACCTACCATCTTATTCTATAATTATACCTTATCAATTAATTAAACCGGCGAATTAGGAACATTAC;
END;

BEGIN TREES;
	TREE tree = ((1,2),(3,4),((5,6),(7,8)));
END;

BEGIN HYPHY;

/* test preamble */

	_testDescription 		= " fit the GTR+I+G gamma model to a simulated alignment with 8 sequences and 2000 sites";
	_expectedLL 			= -10902.8829038266;
	ExecuteAFile 			("../Shared/TestInstrumentation.bf");
	startTestTimer 			(_testDescription);
	
/* end test preamble */


global P=0.2;
P:<0.9999999999;
global alpha=0.4999999999999999;
alpha:>0.01;
alpha:<100;
global GT=1;
global CT=1;
global CG=1;
global AT=1;
global AC=1;
global beta:=(1-P)*alpha;
beta:>0.01;
beta:<200;
c.weights={5,1};
c.weights[0][0]:=P;
c.weights[1][0]:=(1-P)/4;
c.weights[2][0]:=(1-P)/4;
c.weights[3][0]:=(1-P)/4;
c.weights[4][0]:=(1-P)/4;



category c=(5,c.weights,MEAN,(1-P)*GammaDist(_x_,alpha,beta)*(_x_>0),(1-P)*CGammaDist(_x_,alpha,beta)*(_x_>0)+P,0,1e+25,(1-P)*CGammaDist(_x_,alpha+1,beta)*alpha/beta*(_x_>0));
GRM={4,4};
GRM[0][1]:=AC*mu*c;
GRM[0][2]:=mu*c;
GRM[0][3]:=AT*mu*c;
GRM[1][0]:=AC*mu*c;
GRM[1][2]:=CG*mu*c;
GRM[1][3]:=CT*mu*c;
GRM[2][0]:=mu*c;
GRM[2][1]:=CG*mu*c;
GRM[2][3]:=GT*mu*c;
GRM[3][0]:=AT*mu*c;
GRM[3][1]:=CT*mu*c;
GRM[3][2]:=GT*mu*c;

vectorOfFrequencies={
{         0.3985625}
{            0.2095}
{          0.094125}
{         0.2978125}
}
;
Model GRMModel=(GRM,vectorOfFrequencies);

UseModel (GRMModel);
Tree givenTree=((1,2),(3,4),((5,6),(7,8)));

givenTree.7.mu=0.05740982371030302;
givenTree.Node9.mu=0.04305817751849737;
givenTree.6.mu=0.06004715765808272;
givenTree.5.mu=0.05633624514408575;
givenTree.Node2.mu=0.0206913217817042;
givenTree.3.mu=0.04777525638115638;
givenTree.1.mu=0.08984604347037839;
givenTree.8.mu=0.05386807848950862;
givenTree.Node12.mu=0.06115352289304924;
givenTree.Node8.mu=0.1095519264881135;
givenTree.4.mu=0.05221556762638653;
givenTree.Node5.mu=0.03067076253306178;
givenTree.2.mu=0.06485966277329239;
DataSet ds = ReadDataFile(USE_NEXUS_FILE_DATA);
DataSetFilter filteredData = CreateFilter(ds,1,"0-1999","0-7");
LikelihoodFunction lf = (filteredData,givenTree);
USE_ADAPTIVE_VARIABLE_STEP	= 1;
/*
VERBOSITY_LEVEL			    = 100;
*/

Optimize(res_lf,lf);

/* test epilogue */
	timeMatrix = endTestTimer 				  (_testDescription);
	if (logTestResult (Abs (res_lf[1][0] - _expectedLL) < 0.01))
	{
		return timeMatrix;
	}
	return 0;
/* end test epilogue */

END;
