/* SPDX-License-Identifier: MIT */
/*
 * List of real HDMI EDIDs from popular monitors.
 * The current list (at the time of writing this comment) is based on the top
 * monitors used on ChromeOS.
 *
 * Copyright 2022 Google LLC.
 *
 * Authors: Mark Yacoub <markyacoub@chromium.org>
 */

#ifndef TESTS_CHAMELIUM_MONITOR_EDIDS_HDMI_EDIDS_H_
#define TESTS_CHAMELIUM_MONITOR_EDIDS_HDMI_EDIDS_H_

#include "monitor_edids_helper.h"

monitor_edid HDMI_EDIDS_4K[] = {
	{ .name = "4K_ACER_BX320HK_HDMI",
	  .edid = "00ffffffffffff0004729a0445540000"
		  "20190103804728782e88e5a8554da025"
		  "0e5054bfef80714f8140818081c09500"
		  "b300d1c001014dd000a0f0703e803020"
		  "3500c48f2100001a000000fd00174c1f"
		  "873c000a202020202020000000fc0042"
		  "58333230484b0a2020202020000000ff"
		  "005435373044303030383530310a018f"
		  "020349f35410050403020716011f1213"
		  "1420151106615d5e5f23090707830100"
		  "006d030c001000387820006001020367"
		  "d85dc40178c000e3050301e40f000001"
		  "681a00000101233c00023a801871382d"
		  "40582c4500c48f2100001e565e00a0a0"
		  "a0295030203500c48f2100001af45100"
		  "a0f070198030203500c48f2100001eda" },
	{ .name = "4K_HP_Spectre32_HDMI",
	  .edid = "00FFFFFFFFFFFF0022F01C3201010101"
		  "04190103804728782A87D5A8554D9F25"
		  "0E5054210800D1C0A9C081C0D100B300"
		  "9500A94081804DD000A0F0703E803020"
		  "3500C48F2100001A000000FD00183C1B"
		  "873C000A202020202020000000FC0048"
		  "502053706563747265203332000000FF"
		  "00434E43393430303030310A202001FB"
		  "02033DF15361605F5D101F0413031202"
		  "11010514070616152309070783010000"
		  "6C030C001000383C200040010367D85D"
		  "C401788000E40F030000E2002B047400"
		  "30F2705A80B0588A00C48F2100001A56"
		  "5E00A0A0A0295030203500C48F210000"
		  "1EEF5100A0F070198030203500C48F21"
		  "00001E000000000000000000000000A8" },

};

monitor_edid HDMI_EDIDS_NON_4K[] = {
	{ .name = "ACI_9155_ASUS_VH238_HDMI",
	  .edid = "00ffffffffffff000469c323fccc0000"
		  "2017010380331d782add45a3554fa027"
		  "125054bfef00714f814081809500b300"
		  "d1c001010101023a801871382d40582c"
		  "4500fd1e1100001e000000ff0044384c"
		  "4d54463035323437360a000000fd0032"
		  "4b1e5011000a202020202020000000fc"
		  "00415355532056483233380a202000be" },
	{ .name = "ACR_314_Acer_T232HL_HDMI",
	  .edid = "00ffffffffffff0004723a014c072030"
		  "0217010380331d782aee95a3544c9926"
		  "0f5054b30c00714f810081809500d1c0"
		  "81c0b3000101023a801871382d40582c"
		  "4500fe1f1100001e000000fd00384b1e"
		  "5311000a202020202020000000fc0041"
		  "6365722054323332484c0a20000000ff"
		  "004c57594141303031343330300a01e3"
		  "020322724f010203040590111213149f"
		  "0607151623097f078301000065030c00"
		  "1000023a80d072382d40102c9680fe1f"
		  "11000018011d8018711c1620582c2500"
		  "fe1f1100009e011d80d0721c1620102c"
		  "2580fe1f1100009e023a80d072382d40"
		  "102c2580fe1f1100001e000000000000"
		  "000000000000000000000000000000c6" },
	{ .name = "ACR_315_Acer_T272HL_HDMI",
	  .edid = "00ffffffffffff0004723b013c2a9034"
		  "31170103803c22782a2fa5a554509e27"
		  "105054b30c00714f81c0810081809500"
		  "b300d1c00101023a801871382d40582c"
		  "450056502100001e000000fd00324b1e"
		  "5311000a202020202020000000fc0041"
		  "6365722054323732484c0a20000000ff"
		  "004c575a4141303032343331300a0126"
		  "020322724f010203040590111213149f"
		  "0607151623097f078301000065030c00"
		  "1000023a801871382d40582c45005650"
		  "2100001e023a80d072382d40102c2580"
		  "56502100001e011d8018711c1620582c"
		  "250056502100009e011d80d0721c1620"
		  "102c258056502100009e000000000000"
		  "0000000000000000000000000000009e" },
	{ .name = "ACR_5429_H6510BD_HDMI",
	  .edid = "00ffffffffffff000472351534053033"
		  "21170103800000780a436ea5574f9d25"
		  "0d4e5e3fcf80317c457c617c813c8180"
		  "81c09500d1c0023a801871382d40582c"
		  "450000000000001e000000fd0017780f"
		  "6611000a202020202020000000fc0048"
		  "3635313042440a2020202020000000ff"
		  "004a465a3131303041383430310a0146"
		  "020329f14d0602151104130514901f20"
		  "212223091707830100006a030c001000"
		  "3828208000e30503018c0ad08a20e02d"
		  "10103e9600c48e21000018011d007251"
		  "d01e206e285500c48e2100001e011d80"
		  "18711c1620582c2500c48e2100009ef3"
		  "39801871382d40582c4500c48e210000"
		  "1e000000000000000000000000000073" },
	{ .name = "AMX_2150_DVX-2150_HDMI",
	  .edid = "00ffffffffffff0005b8660800000000"
		  "00150103803c22780a14e5a3564c9d25"
		  "0e5054a56f808180818f7140b300814f"
		  "714f01010101273c80a170b023403020"
		  "360056502100001a21399030621a2740"
		  "68b0360056502100001c000000fd0038"
		  "4b1e5311000a202020202020000000fc"
		  "004456582d323135300a20202020013d"
		  "02031ff14e8405030220221011131214"
		  "1f071623097f0767030c002000802c01"
		  "1d007251d01e20388815005650210000"
		  "1e011d8018711c1620582c2500565021"
		  "00009e8c0ad08a20e02d10103e960056"
		  "5021000018023a801871382d40582c45"
		  "0056502100001e000000000000000000"
		  "0000000000000000000000000000008b" },
	{ .name = "ATL_1_AT-HDVS-RX_HDMI",
	  .edid = "00ffffffffffff00068c010001000000"
		  "131701038010098cfa9c209c544f8f26"
		  "215256afcf008180a940d1c0a9c081c0"
		  "90408100b3009e20009051201f304880"
		  "3600100a0000001c283c80a070b02340"
		  "30203600100a0000001a000000fd0018"
		  "550f5c11000a202020202020000000fc"
		  "0041542d484456532d52580a2020013d"
		  "02032ef14c010602840510151113141f"
		  "20320907051557500007000907070907"
		  "0709070765030c001000830100000e1f"
		  "008051001e304080370010090000001c"
		  "662156aa51001e30468f330004030000"
		  "001e023a801871382d40582c45001009"
		  "0000001e011d007251d01e206e285500"
		  "10090000001e00000000000000000045" },
	{ .name = "CEI_0_Crestron_HDMI",
	  .edid = "00ffffffffffff000ca9000000000000"
		  "0113010380502d960eee91a3544c9926"
		  "0f5054210800d1dcd1e2d1dd81c081f6"
		  "3bb601010101023a801871382d40582c"
		  "450020c23100001e023a80d072382d40"
		  "102c458020c23100001e000000fc0043"
		  "72657374726f6e0a20202020000000fd"
		  "00173d1a440f000a2020202020200168"
		  "020323414a901f200514041311020126"
		  "0907070957078301000068030c001000"
		  "002d009a29a0d0518422305098360020"
		  "c23100001c662150b051001b30407036"
		  "0020c23100001e9e20009051201f3048"
		  "80360020c23100001c00000000000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000042" },
	{ .name = "CEI_31032_Crestron_HDMI",
	  .edid = "00ffffffffffff000ca9387900000000"
		  "0113010380502d960eee91a3544c9926"
		  "0f505421080001010101010101010101"
		  "010101010101011d007251d01e206e28"
		  "550020c23100001e023a801871382d40"
		  "582c450020c23100001e000000fc0043"
		  "72657374726f6e0a20202020000000fd"
		  "003b3d1e440f000a2020202020200104"
		  "02031961438410012309070783010000"
		  "68030c001000002d0000000000000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000037" },
	{ .name = "CVT_3_CVT_TV_HDMI",
	  .edid = "00ffffffffffff000ed4030000000000"
		  "1014010380643d008aee95a3544c9926"
		  "0f5054a54e0001010101010101010101"
		  "010101010101023a801871382d40582c"
		  "45003f432100001a000000fd0018550f"
		  "5010000a202020202020000000fc0043"
		  "5654205456200a0a0a0a0a0a00000000"
		  "000000000000000000000000000001f0"
		  "020323744f90050403070206011f1413"
		  "12161115230907038301000066030c00"
		  "100080011d00bc52d01e20b8285540c4"
		  "8e2100001e011d80d0721c1620102c25"
		  "80c48e2100009e8c0ad08a20e02d1010"
		  "3e9600138e210000188c0ad090204031"
		  "200c405500138e210000180000000000"
		  "000000000000000000000000000000a5" },
	{ .name = "DEL_16544_DELL_P2314T_HDMI",
	  .edid = "00ffffffffffff0010aca0404c455145"
		  "1018010380331d78eae595a656529d27"
		  "105054a54b00714f8180a9c0d1c00101"
		  "010101010101023a801871382d40582c"
		  "4500fd1e1100001e000000ff00445746"
		  "32583434464551454c0a000000fc0044"
		  "454c4c205032333134540a20000000fd"
		  "00384c1e5311000a2020202020200109"
		  "020326f14f9005040302071601061112"
		  "1513141f2309070765030c0010008301"
		  "0000e3050301023a801871382d40582c"
		  "4500fd1e1100001e011d8018711c1620"
		  "582c2500fd1e1100009e011d007251d0"
		  "1e206e285500fd1e1100001e8c0ad08a"
		  "20e02d10103e9600fd1e110000180000"
		  "000000000000000000000000000000c5" },
	{ .name = "DEL_16545_DELL_P2314T_HDMI",
	  .edid = "00ffffffffffff0010aca1404c385145"
		  "1018010380331d78eae595a656529d27"
		  "105054a54b00714f8180a9c0d1c00101"
		  "010101010101023a801871382d40582c"
		  "4500fd1e1100001e000000ff00445746"
		  "32583434464551384c0a000000fc0044"
		  "454c4c205032333134540a20000000fd"
		  "00384c1e5311000a2020202020200122"
		  "020326f14f9005040302071601061112"
		  "1513141f2309070765030c0020008301"
		  "0000e3050301023a801871382d40582c"
		  "4500fd1e1100001e011d8018711c1620"
		  "582c2500fd1e1100009e011d007251d0"
		  "1e206e285500fd1e1100001e8c0ad08a"
		  "20e02d10103e9600fd1e110000180000"
		  "000000000000000000000000000000b5" },
	{ .name = "DEL_40976_DELL_2405FPW_HDMI",
	  .edid = "00ffffffffffff0010ac10a053465630"
		  "0b10010380342178eeee50a3544c9b26"
		  "0f5054a54b008180a940714fb3000101"
		  "010101010101283c80a070b023403020"
		  "360007442100001a000000ff00543631"
		  "33333633493056465320000000fc0044"
		  "454c4c20323430354650570a000000fd"
		  "00384c1e5111000a20202020202000e9" },
	{ .name = "`",
	  .edid = "00ffffffffffff0010ac17a053575930"
		  "0511010380342178eeee91a3544c9926"
		  "0f5054a54b008180a940714fb3000101"
		  "010101010101283c80a070b023403020"
		  "360007442100001a000000ff00555935"
		  "34353732323059575320000000fc0044"
		  "454c4c20323430375746500a000000fd"
		  "00384c1e5311000a2020202020200068" },
	{ .name = "DEL_61462_DELL_U2410_HDMI",
	  .edid = "00ffffffffffff0010ac16f04c4e4332"
		  "1f13010380342078ea1ec5ae4f34b126"
		  "0e5054a54b008180a940d100714f0101"
		  "010101010101283c80a070b023403020"
		  "360006442100001a000000ff00463532"
		  "354d39375332434e4c0a000000fc0044"
		  "454c4c2055323431300a2020000000fd"
		  "00384c1e5111000a202020202020012e"
		  "020329f15090050403020716011f1213"
		  "14201511062309070767030c00100038"
		  "2d83010000e3050301023a801871382d"
		  "40582c450006442100001e011d801871"
		  "1c1620582c250006442100009e011d00"
		  "7251d01e206e28550006442100001e8c"
		  "0ad08a20e02d10103e96000644210000"
		  "1800000000000000000000000000003e" },
	{ .name = "DTV_0_DTV_HDMI",
	  .edid = "00ffffffffffff001296000001010101"
		  "0c180103803a20780a0dc9a057479827"
		  "12484ca14b008180d1c0590f01010101"
		  "010101010101023a801871382d40582c"
		  "450020c23100001e011d007251d01e20"
		  "6e28550044402100001e000000fc0020"
		  "202020204454560a20202020000000fd"
		  "0032550e4610000a2020202020200125"
		  "02032770521413121116150504030207"
		  "06011f10202122260907071507508301"
		  "000067030c001000b82d011d80d0721c"
		  "1620102c258044402100009e011d8018"
		  "711c1620582c2500444021000098011d"
		  "00bc52d01e20b828554044402100001e"
		  "011d007251d01e206e28550044402100"
		  "001e0000000000000000000000000093" },
	{ .name = "DTV_0_Kogan_TV_HDMI",
	  .edid = "00ffffffffffff001296000001010101"
		  "05170103800000780adebda355479926"
		  "0c474aa10800d1c00101010101010101"
		  "010101010101023a801871382d40582c"
		  "4500a2123200001e662150b051001b30"
		  "40703600f8ae2100001e000000fd0032"
		  "4c1f4b10000a202020202020000000fc"
		  "0020204b6f67616e2054560a20200115"
		  "020324744f90050403070206011f1413"
		  "12161115230907038301000067030c00"
		  "1000b82d011d00bc52d01e20b8285540"
		  "c48e2100001e011d80d0721c1620102c"
		  "2580c48e2100009e8c0ad08a20e02d10"
		  "103e9600138e210000188c0ad0902040"
		  "31200c405500138e2100001800000000"
		  "0000000000000000000000000000003e" },
	{ .name = "ELO_8705_HDMI",
	  .edid = "00ffffffffffff00158f01220c4b0000"
		  "2b17010381301b78eaf5c5a85337ae25"
		  "1250542308008180814081c001010101"
		  "010101010101d039801871382d40582c"
		  "4500dc0c1100001e662156aa51001e30"
		  "468f3300dc0c1100001e21399030621a"
		  "274068b03600dc0c1100001c9a29a0d0"
		  "5184223050983600dc0c1100001c00fe" },
	{ .name = "EXN_0_EXTRON_D_HDMI",
	  .edid = "00ffffffffffff00170e000001010101"
		  "0013010380000078ee00000000000000"
		  "000000a54b00d1c0a940714f90408180"
		  "010101010101023a801871382d40582c"
		  "450080387400001e302a7820511a1240"
		  "30701300781a5400001c000000fd0017"
		  "4c0e5c11000a202020202020000000fc"
		  "00455854524f4e20440a20202020010e"
		  "02031a414690050403020123091f4083"
		  "01000066030c00100000023a80187138"
		  "2d40582c450080387400001e00000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000000"
		  "0000000000000000000000000000002a" },
	{ .name = "EXN_0_Extron_HDMI_HDMI",
	  .edid = "00ffffffffffff00170e000000000000"
		  "00160103800000782a00000000000000"
		  "00000021000001010101010101010101"
		  "010101010101011d007251d01e206e28"
		  "550000d05200001e000000fd00173d0e"
		  "4c11000a202020202020000000fc0045"
		  "7874726f6e2048444d490a2000000010"
		  "000000000000000000000000000001db"
		  "02031ac0468402030607012309070783"
		  "01000066030c00100080000000000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000006d14" },
	{ .name = "EXN_0_ExtronScalerD_HDMI",
	  .edid = "00ffffffffffff00170e000000000000"
		  "0017010380000078ee00000000000000"
		  "00000021080081c0810081809500b300"
		  "a940d1c0d100011d007251d01e206e28"
		  "550000d05200001e000000fd00173d0e"
		  "4c11000a202020202020000000ff000a"
		  "202020202020202020202020000000fc"
		  "00457874726f6e5363616c657244011d"
		  "020328f053901f200514270413020311"
		  "12060715162221012309070783010000"
		  "67030c001000982d023a801871382d40"
		  "582c4500803874000018023a80d07238"
		  "2d40102c458080387400001800000000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000000"
		  "000000000000000000000000000000de" },
	{ .name = "GSM_1_LG_TV_HDMI",
	  .edid = "00ffffffffffff001e6d010001010101"
		  "0116010380a05a780aee91a3544c9926"
		  "0f5054a1080031404540614071408180"
		  "010101010101023a801871382d40582c"
		  "4500a05a0000001e662150b051001b30"
		  "40703600a05a0000001e000000fd003a"
		  "3e1e5310000a202020202020000000fc"
		  "004c472054560a202020202020200143"
		  "020322f14e109f041305140302122021"
		  "2215012615075009570767030c001000"
		  "801e011d8018711c1620582c250020c2"
		  "3100009e011d007251d01e206e285500"
		  "20c23100001e023a801871382d40582c"
		  "4500a05a0000001e011d00bc52d01e20"
		  "b8285540c48e2100001e000000000000"
		  "00000000000000000000000000000025" },
	{ .name = "GSM_22593_D2342P_HDMI",
	  .edid = "00ffffffffffff001e6d41589d000000"
		  "0c15010380331d78ead945a2554da027"
		  "125054a76b80714f81808140b3000101"
		  "010101010101023a801871382d40582c"
		  "4500fe221100001e000000fd00384b1e"
		  "530f000a202020202020000000fc0044"
		  "32333432500a202020202020000000ff"
		  "003131324e444b4430303135370a0094" },
	{ .name = "GSM_22594_D2342P_HDMI",
	  .edid = "00ffffffffffff001e6d425801010101"
		  "0113010380331d78ead945a2554da027"
		  "125054210800714081408180b3000101"
		  "010101010101023a801871382d40582c"
		  "4500fe221100001e000000fd00383d1e"
		  "530f000a202020202020000000fc0044"
		  "32333432500a202020202020000000ff"
		  "0053657269616c4e756d6265720a01a7"
		  "020334f14c101f841305140312202122"
		  "0123090707830100007a030c00100000"
		  "2d20c0100041050f0810181088105810"
		  "38104810023a801871382d40582c4500"
		  "fe221100001e011d8018711c1620582c"
		  "2500fe221100009e011d007251d01e20"
		  "6e285500fe221100001e000000000000"
		  "0000000000000000000000000000006d" },
	{ .name = "GSM_23155_22CV241_HDMI",
	  .edid = "00ffffffffffff001e6d735a01010101"
		  "32170103802f1a78eaebf5a656519c26"
		  "105054210800010181c0810081809500"
		  "0101a9c0b300023a801871382d40582c"
		  "45000f282100001e000000fd00383f1e"
		  "530f000a202020202020000000fc0032"
		  "3243563234310a2020202020000000ff"
		  "000a2020202020202020202020200143"
		  "02031df14a900403011412051f101323"
		  "0907078301000065030c001000023a80"
		  "1871382d40582c4500fe221100001e01"
		  "1d8018711c1620582c2500fe22110000"
		  "9e011d007251d01e206e285500fe2211"
		  "00001e8c0ad08a20e02d10103e9600fe"
		  "22110000180000000000000000000000"
		  "000000000000000000000000000000e6" },
	{ .name = "GSM_50200_LG_TV_HDMI",
	  .edid = "00ffffffffffff001e6d18c401010101"
		  "0113010380462778ead9b0a357499c25"
		  "11494ba10800a94081809040d1c00101"
		  "010101010101023a801871382d40582c"
		  "450008442100001e1b2150a051001e30"
		  "48883500bc882100001c000000fd002f"
		  "3f1c4b10000a202020202020000000fc"
		  "004c472054560a202020202020200187"
		  "020323f150850402010311121314101f"
		  "2021220716230907078301000065030c"
		  "003000011d008051d01c2040803500bc"
		  "882100001e8c0ad08a20e02d10103e96"
		  "00138e210000182a1200104143172028"
		  "60350000003200001c011d8018711c16"
		  "20582c2500c48e2100009e0000000000"
		  "0000000000000000000000000000000a" },
	{ .name = "",
	  .edid = "00ffffffffffff001e6d76c401010101"
		  "2514010380522e78eaac27a355499b25"
		  "10474aa1080081807140614045403140"
		  "81400101b300023a801871382d40582c"
		  "4500a20b3200001e1a3680a070381f40"
		  "30203500a20b32000018000000fd0038"
		  "3c1e530f000a202020202020000000fc"
		  "004d33373034430a202020202020013e"
		  "02031c714990050403011f1412132309"
		  "07078301000065030c001000023a8018"
		  "71382d40582c450006442100001e011d"
		  "8018711c1620582c250006442100009e"
		  "011d007251d01e206e28550006442100"
		  "001e011d80d0721c1620102c2580848a"
		  "4200009e023a80d072382d40102c4520"
		  "06442100001e00000000000000000056" },
	{ .name = "HEC_48_HDMI_HDMI",
	  .edid = "00ffffffffffff0020a3300001000000"
		  "23140103807341780acf74a3574cb023"
		  "09484c21080081c08140818001010101"
		  "010101010101023a801871382d40582c"
		  "450080884200001e1b2150a051001e30"
		  "48883500444a2100001c000000fc0048"
		  "444d490a2020202020202020000000fd"
		  "00324b0f450f000a202020202020016c"
		  "020328714b0102040590141f11202122"
		  "26090707177f18830100006c030c0030"
		  "00382d20a0020141011d80d0721c1620"
		  "102c2580c48e2100009e011d8018711c"
		  "1620582c2500c48e2100009e011d0072"
		  "51d01e206e285500c48e210000180000"
		  "00000000000000000000000000000000"
		  "00000000000000000000000000000095" },
	{ .name = "HWP_10346_HP_ZR24w_HDMI",
	  .edid = "00ffffffffffff0022f06a2801010101"
		  "11150103803623782efc81a4554d9d25"
		  "125054210800814081809500a940b300"
		  "d1c001010101283c80a070b023403020"
		  "360022602100001a000000fd003b3d18"
		  "5011000a202020202020000000fc0048"
		  "50205a523234770a20202020000000ff"
		  "00434e5431313737354e420a2020003d" },
	{ .name = "HWP_10581_HP_ZR2440w_HDMI",
	  .edid = "00ffffffffffff0022f0552901010101"
		  "0c170103803420782afc81a4554d9d25"
		  "125054210800d1c081c0814081809500"
		  "a940b3000101283c80a070b023403020"
		  "360006442100001a000000fd00183c18"
		  "5011000a202020202020000000fc0048"
		  "50205a5232343430770a2020000000ff"
		  "00434e34333132303836580a2020007f" },
	{ .name = "",
	  .edid = "00ffffffffffff0022f0562901010101"
		  "0b170103803420782afc81a4554d9d25"
		  "125054210800d1c081c0814081809500"
		  "a940b3000101283c80a070b023403020"
		  "360006442100001a000000fd00183c18"
		  "5011000a202020202020000000fc0048"
		  "50205a5232343430770a2020000000ff"
		  "00434e34333131315042560a2020015c"
		  "02031ff14c901f051404130302070612"
		  "0165030c001000230907078301000002"
		  "3a801871382d40582c45000644210000"
		  "1e023a80d072382d40102c4580064421"
		  "00001e011d007251d01e206e28550006"
		  "442100001e011d00bc52d01e20b82855"
		  "4006442100001e8c0ad08a20e02d1010"
		  "3e9600064421000018000000000000c1" },
	{ .name = "HWP_12442_HP_Z30i_HDMI",
	  .edid = "00ffffffffffff0022f09a3001010101"
		  "06180103804028782a1df5ae4f35b325"
		  "0d5054a10800d100b30095008100a940"
		  "8180d1c081c0e26800a0a0402e603020"
		  "360081902100001a000000fd00324618"
		  "621b000a202020202020000000fc0048"
		  "50205a3330690a2020202020000000ff"
		  "00434e34343036304742530a20200078" },
	{ .name = "HWP_12447_HP_Z24i_HDMI",
	  .edid = "00ffffffffffff0022f09f3001010101"
		  "1a180103803420782e3c50a7544da226"
		  "105054a1080081009500b3008180a940"
		  "81c0d1c00101283c80a070b023403020"
		  "360006442100001a000000fd00324c18"
		  "5e11000a202020202020000000fc0048"
		  "50205a3234690a2020202020000000ff"
		  "00434e4b343236304c47320a202000d6" },
	{ .name = "HWP_9846_HP_LP2465_HDMI",
	  .edid = "00ffffffffffff0022f0762601010101"
		  "1411010380342178eeef95a3544c9b26"
		  "0f5054a56b808140818081997100a900"
		  "a940b300d100283c80a070b023403020"
		  "360007442100001a000000fd0030551e"
		  "5e11000a202020202020000000fc0048"
		  "50204c50323436350a202020000000ff"
		  "00434e4b373230305739560a20200077" },
	{ .name = "HWP_9976_HP_LP2475w_HDMI",
	  .edid = "00ffffffffffff0022f0f82601010101"
		  "3213010380362378eece50a3544c9926"
		  "0f5054a56b8081408180a900a940b300"
		  "d10001010101283c80a070b023403020"
		  "360022602100001a000000fc00485020"
		  "4c5032343735770a2020000000fd0030"
		  "551e5e11000a202020202020000000ff"
		  "00434e433935303059354a0a20200141"
		  "02031e714b010204850610111314151f"
		  "230907078301000065030c001000011d"
		  "8018711c1620582c250006442100009e"
		  "011d80d0721c1620102c258006442100"
		  "009e011d007251d01e206e2855000644"
		  "2100001e011d00bc52d01e20b8285540"
		  "06442100001e00000000000000000000"
		  "000000000000000000000000000000ef" },
	{ .name = "IFS_65330_InFocus_3118D_HDMI",
	  .edid = "00ffffffffffff0024d332ff92010000"
		  "13160103800000780a3531a15a5a9725"
		  "1451587fef8081c08100d1c08bc09500"
		  "9040a940b300023a801871382d40582c"
		  "450000000000001e283c80a070b02340"
		  "3020360000000000001a000000fd0032"
		  "551f5a11000a202020202020000000fc"
		  "00496e466f6375732033313138440126"
		  "020324c14f0102030607111204130514"
		  "901f2021230907078301000067030c00"
		  "10008021011d00bc52d01e20b8285540"
		  "00000000001e011d8018711c1620582c"
		  "250000000000009e011d80d0721c1620"
		  "102c258000000000009e8c0ad08a20e0"
		  "2d10103e96000000000000188c0ad090"
		  "204031200c40550000000000001800c5" },
	{ .name = "JVC_37393_ILAFPJ_XH2_HDMI",
	  .edid = "00ffffffffffff002ac3119201010101"
		  "0011010380dd7d782a6be9ab544caf24"
		  "0b484a21080081800101010101010101"
		  "010101010101011d8018711c1620582c"
		  "2500a2e28400009e011d80d0721c1620"
		  "102c2580a2e28400009e000000fc0049"
		  "4c4146504a202d2d20584832000000fd"
		  "00173d0f440f000a202020202020017d"
		  "020319314c8594909f04130211061520"
		  "0167030c001000382d023a801871382d"
		  "40582c4500a2e28400001e023a80d072"
		  "382d40102c4580a2e28400001e011d00"
		  "7251d01e206e285500a2e28400001e01"
		  "1d00bc52d01e20b8285540a2e2840000"
		  "1e011d803e73382d407eb84590a2e284"
		  "00001e0000000000000000000000002f" },
	{ .name = "MEL_18545_MDT551S_HDMI",
	  .edid = "00ffffffffffff0034ac7148af000000"
		  "2b15010380794478eaf610a3554a9b25"
		  "10484e2000004540614081c08bc0d1c0"
		  "810095000101023a801871382d40582c"
		  "4500baac4200001e662150b051001b30"
		  "40703600baac4200001e000000fd0031"
		  "561f5c11000a202020202020000000fc"
		  "004d4454353531530a20202020200116"
		  "020322f14e90201f0504020701030911"
		  "121314230957078301000066030c0010"
		  "0000011d007251d01e206e285500baac"
		  "4200001e8c0ad08a20e02d10103e9600"
		  "baac42000018023a80d072382d40942c"
		  "4500baac4200001efa1c803e73382d40"
		  "7e2c4580baac4200001a011d8018711c"
		  "1620582c2500baac4200009e0000006b" },
};

#endif /* TESTS_CHAMELIUM_MONITOR_EDIDS_HDMI_EDIDS_H_ */
