/**********************************************************************
  Copyright(c) 2023-2024 Intel Corporation All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
    * Neither the name of Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************/

/* AES-GCM */
#include "aead_test.h"
const struct aead_test gcm_test_json[] = {
        /* Vectors from
          http://www.ieee802.org/1/files/public/docs2011/
          bn-randall-test-vectors-0511-v1.pdf
        */
        { 96, 128, 128, 1, "\xad\x7a\x2b\xd0\x3e\xac\x83\x5a\x6f\x62\x0f\xdc\xb5\x06\xb3\x45",
          "\x12\x15\x35\x24\xc0\x89\x5e\x81\xb2\xc2\x84\x65",
          "\xd6\x09\xb1\xf0\x56\x63\x7a\x0d\x46\xdf\x99\x8d\x88\xe5\x2e\x00\xb2\xc2"
          "\x84\x65\x12\x15\x35\x24\xc0\x89\x5e\x81",
          "\x08\x00\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e"
          "\x1f\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x00\x02",
          "\x70\x1a\xfa\x1c\xc0\x39\xc0\xd7\x65\x12\x8a\x66\x5d\xab\x69\x24\x38\x99"
          "\xbf\x73\x18\xcc\xdc\x81\xc9\x93\x1d\xa1\x7f\xbe\x8e\xdd\x7d\x17\xcb\x8b"
          "\x4c\x26\xfc\x81\xe3\x28\x4f\x2b\x7f\xba\x71\x3d",
          "\x4f\x8d\x55\xe7\xd3\xf0\x6f\xd5\xa1\x3c\x0c\x29\xb9\xd5\xb8\x80", 1, 224, 384 },
        { 96, 128, 128, 2, "\x07\x1b\x11\x3b\x0c\xa7\x43\xfe\xcc\xcf\x3d\x05\x1f\x73\x73\x82",
          "\xf0\x76\x1e\x8d\xcd\x3d\x00\x01\x76\xd4\x57\xed",
          "\xe2\x01\x06\xd7\xcd\x0d\xf0\x76\x1e\x8d\xcd\x3d\x88\xe5\x4c\x2a\x76\xd4"
          "\x57\xed",
          "\x08\x00\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e"
          "\x1f\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x00\x04",
          "\x13\xb4\xc7\x2b\x38\x9d\xc5\x01\x8e\x72\xa1\x71\xdd\x85\xa5\xd3\x75\x22"
          "\x74\xd3\xa0\x19\xfb\xca\xed\x09\xa4\x25\xcd\x9b\x2e\x1c\x9b\x72\xee\xe7"
          "\xc9\xde\x7d\x52\xb3\xf3",
          "\xd6\xa5\x28\x4f\x4a\x6d\x3f\xe2\x2a\x5d\x6c\x2b\x96\x04\x94\xc3", 1, 160, 336 },
        /* Vectors from http://csrc.nist.gov/groups/STM/cavp/gcmtestvectors.zip
        gcmEncryptExtIV128.rsp */
        { 96, 128, 128, 3, "\xc9\x39\xcc\x13\x39\x7c\x1d\x37\xde\x6a\xe0\xe1\xcb\x7c\x42\x3c",
          "\xb3\xd8\xcc\x01\x7c\xbb\x89\xb3\x9e\x0f\x67\xe2",
          "\x24\x82\x56\x02\xbd\x12\xa9\x84\xe0\x09\x2d\x3e\x44\x8e\xda\x5f",
          "\xc3\xb3\xc4\x1f\x11\x3a\x31\xb7\x3d\x9a\x5c\xd4\x32\x10\x30\x69",
          "\x93\xfe\x7d\x9e\x9b\xfd\x10\x34\x8a\x56\x06\xe5\xca\xfa\x73\x54",
          "\x00\x32\xa1\xdc\x85\xf1\xc9\x78\x69\x25\xa2\xe7\x1d\x82\x72\xdd", 1, 128, 128 },
        { 96, 128, 128, 4, "\x29\x8e\xfa\x1c\xcf\x29\xcf\x62\xae\x68\x24\xbf\xc1\x95\x57\xfc",
          "\x6f\x58\xa9\x3f\xe1\xd2\x07\xfa\xe4\xed\x2f\x6d",
          "\x02\x1f\xaf\xd2\x38\x46\x39\x73\xff\xe8\x02\x56\xe5\xb1\xc6\xb1",
          "\xcc\x38\xbc\xcd\x6b\xc5\x36\xad\x91\x9b\x13\x95\xf5\xd6\x38\x01\xf9\x9f"
          "\x80\x68\xd6\x5c\xa5\xac\x63\x87\x2d\xaf\x16\xb9\x39\x01",
          "\xdf\xce\x4e\x9c\xd2\x91\x10\x3d\x7f\xe4\xe6\x33\x51\xd9\xe7\x9d\x3d\xfd"
          "\x39\x1e\x32\x67\x10\x46\x58\x21\x2d\xa9\x65\x21\xb7\xdb",
          "\x54\x24\x65\xef\x59\x93\x16\xf7\x3a\x7a\x56\x05\x09\xa2\xd9\xf2", 1, 128, 256 },
        { 96, 128, 128, 5, "\x29\x8e\xfa\x1c\xcf\x29\xcf\x62\xae\x68\x24\xbf\xc1\x95\x57\xfc",
          "\x6f\x58\xa9\x3f\xe1\xd2\x07\xfa\xe4\xed\x2f\x6d",
          "\x02\x1f\xaf\xd2\x38\x46\x39\x73\xff\xe8\x02\x56\xe5\xb1\xc6\xb1",
          "\xcc\x38\xbc\xcd\x6b\xc5\x36\xad\x91\x9b\x13\x95\xf5\xd6\x38\x01\xf9\x9f"
          "\x80\x68\xd6\x5c\xa5\xac\x63\x87\x2d\xaf\x16\xb9\x39\x01",
          "\xdf\xce\x4e\x9c\xd2\x91\x10\x3d\x7f\xe4\xe6\x33\x51\xd9\xe7\x9d\x3d\xfd"
          "\x39\x1e\x32\x67\x10\x46\x58\x21\x2d\xa9\x65\x21\xb7\xdb",
          "\x54\x24\x65\xef\x59\x93\x16\xf7\x3a\x7a\x56\x05\x09\xa2\xd9\xf2", 1, 128, 256 },
        /* Vectors from
        http://csrc.nist.gov/groups/ST/toolkit/BCM/documents/proposedmodes/gcm/gcm-revised-spec.pdf
        */
        { 96, 128, 128, 6, "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "\x00",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x03\x88\xda\xce\x60\xb6\xa3\x92\xf3\x28\xc2\xb9\x71\xb2\xfe\x78",
          "\xab\x6e\x47\xd4\x2c\xec\x13\xbd\xf5\x3a\x67\xb2\x12\x57\xbd\xdf", 1, 0, 128 },
        { 96, 128, 128, 7, "\xfe\xff\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08",
          "\xca\xfe\xba\xbe\xfa\xce\xdb\xad\xde\xca\xf8\x88", "\x00",
          "\xd9\x31\x32\x25\xf8\x84\x06\xe5\xa5\x59\x09\xc5\xaf\xf5\x26\x9a\x86\xa7"
          "\xa9\x53\x15\x34\xf7\xda\x2e\x4c\x30\x3d\x8a\x31\x8a\x72\x1c\x3c\x0c\x95"
          "\x95\x68\x09\x53\x2f\xcf\x0e\x24\x49\xa6\xb5\x25\xb1\x6a\xed\xf5\xaa\x0d"
          "\xe6\x57\xba\x63\x7b\x39\x1a\xaf\xd2\x55",
          "\x42\x83\x1e\xc2\x21\x77\x74\x24\x4b\x72\x21\xb7\x84\xd0\xd4\x9c\xe3\xaa"
          "\x21\x2f\x2c\x02\xa4\xe0\x35\xc1\x7e\x23\x29\xac\xa1\x2e\x21\xd5\x14\xb2"
          "\x54\x66\x93\x1c\x7d\x8f\x6a\x5a\xac\x84\xaa\x05\x1b\xa3\x0b\x39\x6a\x0a"
          "\xac\x97\x3d\x58\xe0\x91\x47\x3f\x59\x85",
          "\x4d\x5c\x2a\xf3\x27\xcd\x64\xa6\x2c\xf3\x5a\xbd\x2b\xa6\xfa\xb4", 1, 0, 512 },
        { 96, 128, 128, 8, "\xfe\xff\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08",
          "\xca\xfe\xba\xbe\xfa\xce\xdb\xad\xde\xca\xf8\x88",
          "\xfe\xed\xfa\xce\xde\xad\xbe\xef\xfe\xed\xfa\xce\xde\xad\xbe\xef\xab\xad"
          "\xda\xd2",
          "\xd9\x31\x32\x25\xf8\x84\x06\xe5\xa5\x59\x09\xc5\xaf\xf5\x26\x9a\x86\xa7"
          "\xa9\x53\x15\x34\xf7\xda\x2e\x4c\x30\x3d\x8a\x31\x8a\x72\x1c\x3c\x0c\x95"
          "\x95\x68\x09\x53\x2f\xcf\x0e\x24\x49\xa6\xb5\x25\xb1\x6a\xed\xf5\xaa\x0d"
          "\xe6\x57\xba\x63\x7b\x39",
          "\x42\x83\x1e\xc2\x21\x77\x74\x24\x4b\x72\x21\xb7\x84\xd0\xd4\x9c\xe3\xaa"
          "\x21\x2f\x2c\x02\xa4\xe0\x35\xc1\x7e\x23\x29\xac\xa1\x2e\x21\xd5\x14\xb2"
          "\x54\x66\x93\x1c\x7d\x8f\x6a\x5a\xac\x84\xaa\x05\x1b\xa3\x0b\x39\x6a\x0a"
          "\xac\x97\x3d\x58\xe0\x91\x47\x3f\x59\x85",
          "\x5b\xc9\x4f\xbc\x32\x21\xa5\xdb\x94\xfa\xe9\x5a\xe7\x12\x1a\x47", 1, 160, 480 },
        { 96, 256, 128, 9,
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "\x00",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\xce\xa7\x40\x3d\x4d\x60\x6b\x6e\x07\x4e\xc5\xd3\xba\xf3\x9d\x18",
          "\xd0\xd1\xc8\xa7\x99\x99\x6b\xf0\x26\x5b\x98\xb5\xd4\x8a\xb9\x19", 1, 0, 128 },
        { 96, 256, 128, 10,
          "\xfe\xff\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08\xfe\xff"
          "\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08",
          "\xca\xfe\xba\xbe\xfa\xce\xdb\xad\xde\xca\xf8\x88", "\x00",
          "\xd9\x31\x32\x25\xf8\x84\x06\xe5\xa5\x59\x09\xc5\xaf\xf5\x26\x9a\x86\xa7"
          "\xa9\x53\x15\x34\xf7\xda\x2e\x4c\x30\x3d\x8a\x31\x8a\x72\x1c\x3c\x0c\x95"
          "\x95\x68\x09\x53\x2f\xcf\x0e\x24\x49\xa6\xb5\x25\xb1\x6a\xed\xf5\xaa\x0d"
          "\xe6\x57\xba\x63\x7b\x39\x1a\xaf\xd2\x55",
          "\x52\x2d\xc1\xf0\x99\x56\x7d\x07\xf4\x7f\x37\xa3\x2a\x84\x42\x7d\x64\x3a"
          "\x8c\xdc\xbf\xe5\xc0\xc9\x75\x98\xa2\xbd\x25\x55\xd1\xaa\x8c\xb0\x8e\x48"
          "\x59\x0d\xbb\x3d\xa7\xb0\x8b\x10\x56\x82\x88\x38\xc5\xf6\x1e\x63\x93\xba"
          "\x7a\x0a\xbc\xc9\xf6\x62\x89\x80\x15\xad",
          "\xb0\x94\xda\xc5\xd9\x34\x71\xbd\xec\x1a\x50\x22\x70\xe3\xcc\x6c", 1, 0, 512 },
        { 96, 256, 128, 11,
          "\xfe\xff\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08\xfe\xff"
          "\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08",
          "\xca\xfe\xba\xbe\xfa\xce\xdb\xad\xde\xca\xf8\x88",
          "\xfe\xed\xfa\xce\xde\xad\xbe\xef\xfe\xed\xfa\xce\xde\xad\xbe\xef\xab\xad"
          "\xda\xd2",
          "\xd9\x31\x32\x25\xf8\x84\x06\xe5\xa5\x59\x09\xc5\xaf\xf5\x26\x9a\x86\xa7"
          "\xa9\x53\x15\x34\xf7\xda\x2e\x4c\x30\x3d\x8a\x31\x8a\x72\x1c\x3c\x0c\x95"
          "\x95\x68\x09\x53\x2f\xcf\x0e\x24\x49\xa6\xb5\x25\xb1\x6a\xed\xf5\xaa\x0d"
          "\xe6\x57\xba\x63\x7b\x39",
          "\x52\x2d\xc1\xf0\x99\x56\x7d\x07\xf4\x7f\x37\xa3\x2a\x84\x42\x7d\x64\x3a"
          "\x8c\xdc\xbf\xe5\xc0\xc9\x75\x98\xa2\xbd\x25\x55\xd1\xaa\x8c\xb0\x8e\x48"
          "\x59\x0d\xbb\x3d\xa7\xb0\x8b\x10\x56\x82\x88\x38\xc5\xf6\x1e\x63\x93\xba"
          "\x7a\x0a\xbc\xc9\xf6\x62",
          "\x76\xfc\x6e\xce\x0f\x4e\x17\x68\xcd\xdf\x88\x53\xbb\x2d\x55\x1b", 1, 160, 480 },
        /* Vectors from https://tools.ietf.org/html/draft-mcgrew-gcm-test-01 case #7
         */
        { 96, 192, 128, 12,
          "\xfe\xff\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08\xfe\xff"
          "\xe9\x92\x86\x65\x73\x1c",
          "\xca\xfe\xba\xbe\xfa\xce\xdb\xad\xde\xca\xf8\x88", "\x00\x00\xa5\xf8\x00\x00\x00\x0a",
          "\x45\x00\x00\x28\xa4\xad\x40\x00\x40\x06\x78\x80\x0a\x01\x03\x8f\x0a\x01"
          "\x06\x12\x80\x23\x06\xb8\xcb\x71\x26\x02\xdd\x6b\xb0\x3e\x50\x10\x16\xd0"
          "\x75\x68\x00\x01",
          "\xa5\xb1\xf8\x06\x60\x29\xae\xa4\x0e\x59\x8b\x81\x22\xde\x02\x42\x09\x38"
          "\xb3\xab\x33\xf8\x28\xe6\x87\xb8\x85\x8b\x5b\xfb\xdb\xd0\x31\x5b\x27\x45"
          "\x21\x44\xcc\x77",
          "\x95\x45\x7b\x96\x52\x03\x7f\x53\x18\x02\x7b\x5b\x4c\xd7\xa6\x36", 1, 64, 320 },
        { 96, 256, 32, 13,
          "\xfe\xff\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08\xfe\xff"
          "\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08",
          "\xca\xfe\xba\xbe\xfa\xce\xdb\xad\xde\xca\xf8\x88",
          "\xfe\xed\xfa\xce\xde\xad\xbe\xef\xfe\xed\xfa\xce\xde\xad\xbe\xef\xab\xad"
          "\xda\xd2",
          "\xd9\x31\x32\x25\xf8\x84\x06\xe5\xa5\x59\x09\xc5\xaf\xf5\x26\x9a\x86\xa7"
          "\xa9\x53\x15\x34\xf7\xda\x2e\x4c\x30\x3d\x8a\x31\x8a\x72\x1c\x3c\x0c\x95"
          "\x95\x68\x09\x53\x2f\xcf\x0e\x24\x49\xa6\xb5\x25\xb1\x6a\xed\xf5\xaa\x0d"
          "\xe6\x57\xba\x63\x7b\x39",
          "\x52\x2d\xc1\xf0\x99\x56\x7d\x07\xf4\x7f\x37\xa3\x2a\x84\x42\x7d\x64\x3a"
          "\x8c\xdc\xbf\xe5\xc0\xc9\x75\x98\xa2\xbd\x25\x55\xd1\xaa\x8c\xb0\x8e\x48"
          "\x59\x0d\xbb\x3d\xa7\xb0\x8b\x10\x56\x82\x88\x38\xc5\xf6\x1e\x63\x93\xba"
          "\x7a\x0a\xbc\xc9\xf6\x62",
          "\x76\xfc\x6e\xce", 1, 160, 480 },
        { 96, 256, 64, 14,
          "\xfe\xff\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08\xfe\xff"
          "\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08",
          "\xca\xfe\xba\xbe\xfa\xce\xdb\xad\xde\xca\xf8\x88",
          "\xfe\xed\xfa\xce\xde\xad\xbe\xef\xfe\xed\xfa\xce\xde\xad\xbe\xef\xab\xad"
          "\xda\xd2",
          "\xd9\x31\x32\x25\xf8\x84\x06\xe5\xa5\x59\x09\xc5\xaf\xf5\x26\x9a\x86\xa7"
          "\xa9\x53\x15\x34\xf7\xda\x2e\x4c\x30\x3d\x8a\x31\x8a\x72\x1c\x3c\x0c\x95"
          "\x95\x68\x09\x53\x2f\xcf\x0e\x24\x49\xa6\xb5\x25\xb1\x6a\xed\xf5\xaa\x0d"
          "\xe6\x57\xba\x63\x7b\x39",
          "\x52\x2d\xc1\xf0\x99\x56\x7d\x07\xf4\x7f\x37\xa3\x2a\x84\x42\x7d\x64\x3a"
          "\x8c\xdc\xbf\xe5\xc0\xc9\x75\x98\xa2\xbd\x25\x55\xd1\xaa\x8c\xb0\x8e\x48"
          "\x59\x0d\xbb\x3d\xa7\xb0\x8b\x10\x56\x82\x88\x38\xc5\xf6\x1e\x63\x93\xba"
          "\x7a\x0a\xbc\xc9\xf6\x62",
          "\x76\xfc\x6e\xce\x0f\x4e\x17\x68", 1, 160, 480 },
        { 96, 256, 112, 15,
          "\xfe\xff\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08\xfe\xff"
          "\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08",
          "\xca\xfe\xba\xbe\xfa\xce\xdb\xad\xde\xca\xf8\x88",
          "\xfe\xed\xfa\xce\xde\xad\xbe\xef\xfe\xed\xfa\xce\xde\xad\xbe\xef\xab\xad"
          "\xda\xd2",
          "\xd9\x31\x32\x25\xf8\x84\x06\xe5\xa5\x59\x09\xc5\xaf\xf5\x26\x9a\x86\xa7"
          "\xa9\x53\x15\x34\xf7\xda\x2e\x4c\x30\x3d\x8a\x31\x8a\x72\x1c\x3c\x0c\x95"
          "\x95\x68\x09\x53\x2f\xcf\x0e\x24\x49\xa6\xb5\x25\xb1\x6a\xed\xf5\xaa\x0d"
          "\xe6\x57\xba\x63\x7b\x39",
          "\x52\x2d\xc1\xf0\x99\x56\x7d\x07\xf4\x7f\x37\xa3\x2a\x84\x42\x7d\x64\x3a"
          "\x8c\xdc\xbf\xe5\xc0\xc9\x75\x98\xa2\xbd\x25\x55\xd1\xaa\x8c\xb0\x8e\x48"
          "\x59\x0d\xbb\x3d\xa7\xb0\x8b\x10\x56\x82\x88\x38\xc5\xf6\x1e\x63\x93\xba"
          "\x7a\x0a\xbc\xc9\xf6\x62",
          "\x76\xfc\x6e\xce\x0f\x4e\x17\x68\xcd\xdf\x88\x53\xbb\x2d", 1, 160, 480 },
        { 96, 256, 120, 16,
          "\xfe\xff\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08\xfe\xff"
          "\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08",
          "\xca\xfe\xba\xbe\xfa\xce\xdb\xad\xde\xca\xf8\x88",
          "\xfe\xed\xfa\xce\xde\xad\xbe\xef\xfe\xed\xfa\xce\xde\xad\xbe\xef\xab\xad"
          "\xda\xd2",
          "\xd9\x31\x32\x25\xf8\x84\x06\xe5\xa5\x59\x09\xc5\xaf\xf5\x26\x9a\x86\xa7"
          "\xa9\x53\x15\x34\xf7\xda\x2e\x4c\x30\x3d\x8a\x31\x8a\x72\x1c\x3c\x0c\x95"
          "\x95\x68\x09\x53\x2f\xcf\x0e\x24\x49\xa6\xb5\x25\xb1\x6a\xed\xf5\xaa\x0d"
          "\xe6\x57\xba\x63\x7b\x39",
          "\x52\x2d\xc1\xf0\x99\x56\x7d\x07\xf4\x7f\x37\xa3\x2a\x84\x42\x7d\x64\x3a"
          "\x8c\xdc\xbf\xe5\xc0\xc9\x75\x98\xa2\xbd\x25\x55\xd1\xaa\x8c\xb0\x8e\x48"
          "\x59\x0d\xbb\x3d\xa7\xb0\x8b\x10\x56\x82\x88\x38\xc5\xf6\x1e\x63\x93\xba"
          "\x7a\x0a\xbc\xc9\xf6\x62",
          "\x76\xfc\x6e\xce\x0f\x4e\x17\x68\xcd\xdf\x88\x53\xbb\x2d\x55", 1, 160, 480 },
        { 96, 128, 128, 17, "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02\x03\x04\x05\x06\x07",
          "", "", "\x8d\xf7\xd8\xed\xb9\x91\x65\xfa\xad\x1b\x03\x8c\x53\xb3\x20\xe8", 1, 64, 0 },
        { 96, 128, 128, 18, "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x93\x6d\xa5\xcd\x62\x1e\xf1\x53\x43\xdb\x6b\x81\x3a\xae\x7e\x07",
          "\xfe\x8e\xc5\x55\x5f\x36\x08\xf7\x0e\xbc\x7f\xce\xe9\x59\x2e\x9b", 1, 0, 128 },
        { 96, 128, 128, 19, "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "", "", "",
          "\x43\x5b\x9b\xa1\x2d\x75\xa4\xbe\x8a\x97\x7e\xa3\xcd\x01\x18\x90", 1, 0, 0 },
        { 96, 128, 8, 20, "\xad\x7a\x2b\xd0\x3e\xac\x83\x5a\x6f\x62\x0f\xdc\xb5\x06\xb3\x45",
          "\x12\x15\x35\x24\xc0\x89\x5e\x81\xb2\xc2\x84\x65",
          "\xd6\x09\xb1\xf0\x56\x63\x7a\x0d\x46\xdf\x99\x8d\x88\xe5\x2e\x00\xb2\xc2"
          "\x84\x65\x12\x15\x35\x24\xc0\x89\x5e\x81",
          "\x08\x00\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e"
          "\x1f\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x00\x02",
          "\x70\x1a\xfa\x1c\xc0\x39\xc0\xd7\x65\x12\x8a\x66\x5d\xab\x69\x24\x38\x99"
          "\xbf\x73\x18\xcc\xdc\x81\xc9\x93\x1d\xa1\x7f\xbe\x8e\xdd\x7d\x17\xcb\x8b"
          "\x4c\x26\xfc\x81\xe3\x28\x4f\x2b\x7f\xba\x71\x3d",
          "\x4f", 1, 224, 384 },
        { 96, 128, 128, 21, "\x76\x80\xc5\xd3\xca\x61\x54\x75\x8e\x51\x0f\x4d\x25\xb9\x88\x20",
          "\xf8\xf1\x05\xf9\xc3\xdf\x49\x65\x78\x03\x21\xf8",
          "\xc9\x4c\x41\x01\x94\xc7\x65\xe3\xdc\xc7\x96\x43\x79\x75\x8e\xd3", "", "",
          "\x94\xdc\xa8\xed\xfc\xf9\x0b\xb7\x4b\x15\x3c\x8d\x48\xa1\x79\x30", 1, 128, 0 },
        /* Vectors from
           http://csrc.nist.gov/groups/ST/toolkit/BCM/
           documents/proposedmodes/gcm/gcm-revised-spec.pdf
        */
        { 64, 256, 128, 22,
          "\xfe\xff\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08\xfe\xff"
          "\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08",
          "\xca\xfe\xba\xbe\xfa\xce\xdb\xad",
          "\xfe\xed\xfa\xce\xde\xad\xbe\xef\xfe\xed\xfa\xce\xde\xad\xbe\xef\xab\xad"
          "\xda\xd2",
          "\xd9\x31\x32\x25\xf8\x84\x06\xe5\xa5\x59\x09\xc5\xaf\xf5\x26\x9a\x86\xa7"
          "\xa9\x53\x15\x34\xf7\xda\x2e\x4c\x30\x3d\x8a\x31\x8a\x72\x1c\x3c\x0c\x95"
          "\x95\x68\x09\x53\x2f\xcf\x0e\x24\x49\xa6\xb5\x25\xb1\x6a\xed\xf5\xaa\x0d"
          "\xe6\x57\xba\x63\x7b\x39",
          "\xc3\x76\x2d\xf1\xca\x78\x7d\x32\xae\x47\xc1\x3b\xf1\x98\x44\xcb\xaf\x1a"
          "\xe1\x4d\x0b\x97\x6a\xfa\xc5\x2f\xf7\xd7\x9b\xba\x9d\xe0\xfe\xb5\x82\xd3"
          "\x39\x34\xa4\xf0\x95\x4c\xc2\x36\x3b\xc7\x3f\x78\x62\xac\x43\x0e\x64\xab"
          "\xe4\x99\xf4\x7c\x9b\x1f",
          "\x3a\x33\x7d\xbf\x46\xa7\x92\xc4\x5e\x45\x49\x13\xfe\x2e\xa8\xf2", 1, 160, 480 },
        { 8, 128, 128, 23, "\x83\xf9\xd9\x7d\x4a\xb7\x59\xfd\xdc\xc3\xef\x54\xa0\xe2\xa8\xec",
          "\xcf", "\x6d\xd4\x9e\xae\xb4\x10\x3d\xac\x8f\x97\xe3\x23\x49\x46\xdd\x2d",
          "\x77\xe6\x32\x9c\xf9\x42\x4f\x71\xc8\x08\xdf\x91\x70\xbf\xd2\x98",
          "\x50\xde\x86\xa7\xa9\x2a\x8a\x5e\xa3\x3d\xb5\x69\x6b\x96\xcd\x77",
          "\xaa\x18\x1e\x84\xbc\x8b\x4b\xf5\xa6\x89\x27\xc4\x09\xd4\x22\xcb", 1, 128, 128 },
        { 8, 192, 128, 24,
          "\x8b\x1c\x63\xbc\xcb\x55\x79\xe5\x88\x7f\x5b\xf7\xb2\xbd\x0c\xbc\xff\x13"
          "\x6d\x40\xd7\xb6\x1a\xb2",
          "\xca", "\x8f\xbe\x5a\x21\xa6\x5b\xdd\xd0\x33\x16\x04\xc9\x17\x83\x9c\xf7",
          "\x22\x4f\x5f\x2a\x23\x7b\x30\x7c\x78\x42\xde\x75\xd9\xd1\xbb\x65",
          "\x83\x49\xe3\xa4\x8f\x5d\x89\xd9\x42\xc2\x4d\x80\xae\xfb\x1c\x5f",
          "\x3d\x49\xe3\xd4\x3f\x9a\x4a\x96\x4c\x6d\x84\x4d\x60\xb4\xef\x1e", 1, 128, 128 },
        { 1024, 128, 32, 25, "\x0e\x00\xc7\x65\x61\xd2\xbd\x9b\x40\xc3\xc1\x54\x27\xe2\xb0\x8f",
          "\x49\x2c\xad\xac\xcd\x3c\xa3\xfb\xc9\xcf\x9f\x06\xeb\x33\x25\xc4\xe1\x59"
          "\x85\x0b\x0d\xbe\x98\x19\x9b\x89\xb7\xaf\x52\x88\x06\x61\x0b\x6f\x63\x99"
          "\x8e\x1e\xae\x80\xc3\x48\xe7\x4c\xbb\x92\x1d\x83\x26\x63\x16\x31\xfc\x6a"
          "\x5d\x30\x4f\x39\x16\x6d\xaf\x7e\xa1\x5f\xa1\x97\x7f\x10\x18\x19\xad\xb5"
          "\x10\xb5\x0f\xe9\x93\x2e\x12\xc5\xa8\x5a\xa3\xfd\x1e\x73\xd8\xd7\x60\xaf"
          "\x21\x8b\xe8\x29\x90\x3a\x77\xc6\x33\x59\xd7\x5e\xdd\x91\xb4\xf6\xed\x54"
          "\x65\xa7\x26\x62\xf5\x05\x59\x99\xe0\x59\xe7\x65\x4a\x8e\xdc\x92\x1a\xa0"
          "\xd4\x96",
          "\xd8\xf1\x16\x3d\x8c\x84\x02\x92\xa2\xb2\xda\xcf\x4a\xc7\xc3\x6a\xff\x87"
          "\x33\xf1\x8f\xab\xb4\xfa\x55\x94\x54\x41\x25\xe0\x3d\x1e\x6e\x5d\x6d\x0f"
          "\xd6\x16\x56\xc8\xd8\xf3\x27\xc9\x28\x39\xae\x55\x39\xbb\x46\x9c\x92\x57"
          "\xf1\x09\xeb\xff\x85\xaa\xd7\xbd\x22\x0f\xda\xa9\x5c\x02\x2d\xbd\x0c\x7b"
          "\xb2\xd8\x78\xad\x50\x41\x22\xc9\x43\x04\x5d\x3c\x5e\xba\x8f\x1f\x56\xc0",
          "\xfe\xf0\x3c\x2d\x7f\xb1\x5b\xf0\xd2\xdf\x18\x00\x7d\x99\xf9\x67\xc8\x78"
          "\xad\x59\x35\x90\x34\xf7\xbb\x2c\x19\xaf\x12\x06\x85\xd7\x8e\x32\xf6\xb8"
          "\xb8\x3b\x03\x20\x19\x95\x6c\xa9\xc0\x19\x57\x21\x47\x6b\x85",
          "\x4f\x6c\xf4\x71\xbe\x7c\xbd\x25\x75\xcd\x5a\x17\x47\xae\xa8\xfe\x9d\xea"
          "\x83\xe5\x19\x36\xbe\xac\x3e\x68\xf6\x62\x06\x92\x20\x60\xc6\x97\xff\xa7"
          "\xaf\x80\xad\x6b\xb6\x8f\x2c\xf4\xfc\x97\x41\x6e\xe5\x2a\xbe",
          "\xe2\x0b\x66\x55", 1, 720, 408 },
        { 480, 256, 128, 26,
          "\xfe\xff\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08\xfe\xff"
          "\xe9\x92\x86\x65\x73\x1c\x6d\x6a\x8f\x94\x67\x30\x83\x08",
          "\x93\x13\x22\x5d\xf8\x84\x06\xe5\x55\x90\x9c\x5a\xff\x52\x69\xaa\x6a\x7a"
          "\x95\x38\x53\x4f\x7d\xa1\xe4\xc3\x03\xd2\xa3\x18\xa7\x28\xc3\xc0\xc9\x51"
          "\x56\x80\x95\x39\xfc\xf0\xe2\x42\x9a\x6b\x52\x54\x16\xae\xdb\xf5\xa0\xde"
          "\x6a\x57\xa6\x37\xb3\x9b",
          "\xfe\xed\xfa\xce\xde\xad\xbe\xef\xfe\xed\xfa\xce\xde\xad\xbe\xef\xab\xad"
          "\xda\xd2",
          "\xd9\x31\x32\x25\xf8\x84\x06\xe5\xa5\x59\x09\xc5\xaf\xf5\x26\x9a\x86\xa7"
          "\xa9\x53\x15\x34\xf7\xda\x2e\x4c\x30\x3d\x8a\x31\x8a\x72\x1c\x3c\x0c\x95"
          "\x95\x68\x09\x53\x2f\xcf\x0e\x24\x49\xa6\xb5\x25\xb1\x6a\xed\xf5\xaa\x0d"
          "\xe6\x57\xba\x63\x7b\x39",
          "\x5a\x8d\xef\x2f\x0c\x9e\x53\xf1\xf7\x5d\x78\x53\x65\x9e\x2a\x20\xee\xb2"
          "\xb2\x2a\xaf\xde\x64\x19\xa0\x58\xab\x4f\x6f\x74\x6b\xf4\x0f\xc0\xc3\xb7"
          "\x80\xf2\x44\x45\x2d\xa3\xeb\xf1\xc5\xd8\x2c\xde\xa2\x41\x89\x97\x20\x0e"
          "\xf8\x2e\x44\xae\x7e\x3f",
          "\xa4\x4a\x82\x66\xee\x1c\x8e\xb0\xc8\xb5\xd4\xcf\x5a\xe9\xf1\x9a", 1, 160, 480 },
        { 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0 }
};
