if(NOT USE_CODEC_OPUS)
    return()
endif()

if(NOT BUILD_CLIENT)
    return()
endif()

include(utils/disable_warnings)
include(utils/find_include_dirs)

set(INTERNAL_OPUS_DIR ${SOURCE_DIR}/thirdparty/opus-1.5.2)
set(INTERNAL_OPUSFILE_DIR ${SOURCE_DIR}/thirdparty/opusfile-0.12)

if(USE_INTERNAL_OPUS)
    file(GLOB_RECURSE OPUS_SOURCES ${INTERNAL_OPUS_DIR}/*.c)
    file(GLOB_RECURSE OPUSFILE_SOURCES ${INTERNAL_OPUSFILE_DIR}/*.c)
    disable_warnings(${OPUS_SOURCES} ${OPUSFILE_SOURCES})
    find_include_dirs(OPUS_INCLUDE_DIRS ${INTERNAL_OPUS_DIR})
    find_include_dirs(OPUSFILE_INCLUDE_DIRS ${INTERNAL_OPUSFILE_DIR})
    set(OPUS_DEFINITIONS OPUS_BUILD HAVE_LRINTF FLOATING_POINT FLOAT_APPROX USE_ALLOCA)
    list(APPEND CLIENT_LIBRARY_SOURCES ${OPUS_SOURCES} ${OPUSFILE_SOURCES})
else()
    find_package(PkgConfig REQUIRED)
    pkg_check_modules(OPUS REQUIRED opus)
    pkg_check_modules(OPUSFILE REQUIRED opusfile)
endif()

list(APPEND CLIENT_LIBRARIES ${OPUS_LIBRARIES} ${OPUSFILE_LIBRARIES})
list(APPEND CLIENT_INCLUDE_DIRS ${OPUS_INCLUDE_DIRS} ${OPUSFILE_INCLUDE_DIRS})
list(APPEND CLIENT_DEFINITIONS USE_CODEC_OPUS ${OPUS_DEFINITIONS} ${OPUSFILE_DEFINITIONS})
