#!/bin/sh -e
CURDIR=`pwd`
if [ -d /usr/share/doc/iqtree/examples ] ; then
  EXAMPLEDIR=/usr/share/doc/iqtree/examples
else
  EXAMPLEFILE=`find $CURDIR -name example.phy | head -n 1`
  EXAMPLEDIR=`dirname $EXAMPLEFILE`
fi

pkg=iqtree
if [ "$ADTTMP" = "" ] ; then
  ADTTMP=`mktemp -d /tmp/${pkg}-test.XXXXXX`
fi
cd $ADTTMP
cp -a $EXAMPLEDIR/example.phy* $EXAMPLEDIR/example.nex* .
find . -name "*.gz" -exec gunzip \{\} \;

PATHTOEXE=`which iqtree`
if [ "$PATHTOEXE" = "" ] ; then
  PATHTOEXE=`find $CURDIR -name iqtree -type f -executable`
fi
PATHTOEXEOMP=`which iqtree-omp`
if [ "$PATHTOEXEOMP" = "" ] ; then
  PATHTOEXE=`find $CURDIR -name iqtree-omp -type f -executable`
fi
#if [ "$PATHTOEXE" = "" ] ; then
#  PATHTOEXE=`find $CURDIR -name iqtree -type l`
#fi
echo "Executing tests using $PATHTOEXE ..."
time $PATHTOEXE -s example.phy
time $PATHTOEXE -s example.phy -pre myprefix
time $PATHTOEXE -s example.phy -nni1
time $PATHTOEXE -s example.phy -m TEST
time $PATHTOEXE -s example.phy -m TIM+I+G
time $PATHTOEXE -s example.phy -m TESTONLY
time $PATHTOEXE -s example.phy -m TIM+I+G -bb 1000
time $PATHTOEXE -s example.phy -m TIM+I+G -b 100
time $PATHTOEXE -s example.phy -m TIM+I+G -alrt 1000
time $PATHTOEXE -s example.phy -m TIM+I+G -lbp 1000
time $PATHTOEXE -s example.phy -m TIM+I+G -alrt 1000 -lbp 1000
time $PATHTOEXE -s example.phy -m TIM+I+G -bb 1000 -alrt 1000 -lbp 1000
time $PATHTOEXE -s example.phy -sp example.nex
time $PATHTOEXEOMP -s example.phy -omp 2
if [ $(nproc) -ge 3 ] ; then
  time $PATHTOEXEOMP -s example.phy -omp 3
fi
if [ -e example.treels ] ; then
  time $PATHTOEXE -s example.phy -z example.treels
  time $PATHTOEXE -s example.phy -z example.treels -n 1
  time $PATHTOEXE -s example.phy -z example.treels -n 1 -zb 1000
  time $PATHTOEXE -s example.phy -z example.treels -n 1 -zb 1000 -zw
fi
time $PATHTOEXE -s example.phy -m 010010+G
if [ -e mymodel ] ; then
  time $PATHTOEXE -s example.phy -m mymodel+G
fi
time $PATHTOEXE -s example.phy -m 'TN{2.0,3.0}+G8{0.5}+I{0.15}'
time $PATHTOEXE -s example.phy -m GTR+G+Fo
