package jalview.gui.structurechooser;

import static org.testng.Assert.*;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.structure.StructureImportSettings.TFType;

public class ThreeDBStructureChooserQuerySourceTest {

  @DataProvider(name = "threeDBStructData")
  public Object[][] beaconSourceScores() {
    return new Object[][] {
      { "AlphaFold DB", "PLDDT", 91.0, null, TFType.PLDDT },
      { "SwissModel", "QMEANDISCO", 0.65, "v1.2", TFType.QMEANDISCO },
      { "PDBe", null, null, null, null },  // null 
    };
  }

  @Test(dataProvider = "threeDBStructData", groups = { "Functional" })
  public void testCollectSelectedRows(
      String provider,
      String confType,
      Double score,
      String version,
      TFType expectedTFType
  ) {
    String[] columns = {
      "Model id", "Url", "Provider", "Page URL", "Model Format",
      "Model Category", "Confidence", "Confidence Score Type", "Confidence Score Version",
      "Uniprot Start", "Uniprot End", "Ref Sequence"
    };

    Object[][] data = new Object[1][columns.length];
    data[0][0] = "model1";
    data[0][1] = "https://structure.com";
    data[0][2] = provider;
    data[0][3] = "https://structure.com";
    data[0][4] = "PDB";
    data[0][5] = "Experimental";
    data[0][6] = score;
    data[0][7] = confType;
    data[0][8] = version;
    data[0][9] = 1;
    data[0][10] = 100;
    SequenceI seq = new Sequence("seq", "SEQUENCEA");
    seq.createDatasetSequence();
    data[0][11] = seq;

    JTable mockData = new JTable(new DefaultTableModel(data, columns));
    ThreeDBStructureChooserQuerySource query = new ThreeDBStructureChooserQuerySource();
    List<SequenceI> sequences = new ArrayList<>();

    PDBEntry[] result = query.collectSelectedRows(mockData, new int[]{0}, sequences);

    assertNotNull(result);
    assertEquals(result.length, 1);
    PDBEntry pdbEntry = result[0];

    assertEquals(pdbEntry.getId(), "model1");
    assertEquals(pdbEntry.getProvider(), provider);

    if (expectedTFType != null) {
      assertEquals(pdbEntry.getTempFacTypeTFType(), expectedTFType, "TFType mismatch");
    } else {
      assertNull(pdbEntry.getTempFacTypeTFType(), "TFType should be null");
    }

    if (score != null) {
      assertEquals(pdbEntry.getModelConfidence(), score);
    } else {
      assertNull(pdbEntry.getModelConfidence());
    }

    if (confType != null) {
      assertEquals(pdbEntry.getModelConfidenceType(), confType);
    }

    if (version != null) {
      assertEquals(pdbEntry.getModelConfidenceVersion(), version);
    }
  }
}
