 /***************************************************************************
                          chathistorydialog.h  -  chat logs browser
                             -------------------
    begin                : Sun Feb 22 2009
    copyright            : (C) 2009 by Dario Freddi
    email                : drf54321@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATHISTORYDIALOG_H
#define CHATHISTORYDIALOG_H

#include <QDomDocument>
#include <QHash>
#include <QMap>
#include <QMutex>
#include <QPoint>

#include <KDialog>

#include "ui_chathistorydialog.h"


// Forward declarations
class QSortFilterProxyModel;
class QStandardItemModel;
class QTimer;
class ChatMessageView;



class ChatHistoryDialog : public KDialog, private Ui::historyDialog
{
  Q_OBJECT

  public:
    // Constructor
                           ChatHistoryDialog( QWidget *parent = 0 );
    // Destructor
    virtual               ~ChatHistoryDialog();
    // Set the contact for whom the logs will be initially shown
    bool                   setInitialContact( const QString &account, const QString &handle = QString() );

  private slots:
    // Show on which dates there are logged chats with a certain contact
    void                   showAvailableDates(const QModelIndex &index);
    // Load and show the selected chats
    void                   showLogs( const QDate& day );
    // Set whether the dialog is loading chats or not
    void                   setLoading( bool isLoading = false );
    // Show the context menu for the chat message view
    void                   slotShowContextMenu( const QString &clickedUrl, const QPoint &point );
    // Change the account for which to show logs
    void                   slotAccountChanged( int index );

  private: // Private structures

    // Last chat date selected
    QDate                  lastSelectedDate_;
    // Mutex to watch over the most time-consuming activities
    QMutex                 logLoadingLock_;
    // View used to show the chat logs
    ChatMessageView       *chatView_;
    // Model for the list of contacts
    QStandardItemModel    *model_;
    // Filter for the list of contacts
    QSortFilterProxyModel *proxyModel_;
};



#endif /* CHATHISTORYDIALOG_H */
