/***************************************************************************
                          contactlistmodelfilter.h  -  description
                             -------------------
    begin                : Thu Jul 10 2008
    copyright            : (C) 2008 by Valerio Pilo
    email                : valerio@kmess.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTLISTMODELFILTER_H
#define CONTACTLISTMODELFILTER_H

#include <QSortFilterProxyModel>
#include "account.h"


// Forward declarations
class CurrentAccount;



/**
 * @brief Filtering class for the contact list model.
 *
 * This class serves as a filter for the contact list model: it reads the original list data,
 * sorts and filters out the list nodes according to the current visual options, and exposes a
 * different model with the changes applied.
 *
 * @author Valerio Pilo
 * @ingroup Root
 */
class ContactListModelFilter : public QSortFilterProxyModel
{
  Q_OBJECT


  public: // Public methods

    // The constructor
         ContactListModelFilter( QObject* parent = 0 );
    // Sets the given sourceModel to be processed by the proxy model.
    void setSourceModel( QAbstractItemModel *sourceModel );


  protected: // Protected methods

    // Determine if a row is visible or not
    bool filterAcceptsRow( int sourceRow, const QModelIndex& sourceParent ) const;


  public slots: // Public slots

    // Dumps the model contents to the debug output
    void dump( QModelIndex start = QModelIndex(), int depth = 1 ) const;


  private slots: // Private slots

    // Update the internal filter/sort options
    void updateOptions();


  private: // Private properties

    // Reference to the current account
    CurrentAccount *currentAccount_;
    // Whether or not to show the Allowed special group
    bool            showAllowed_;
    // Whether or not to show empty groups
    bool            showEmpty_;
    // Whether or not to show the contacts grouped by online status or group
    Account::ContactListDisplayMode showGroupsMode_;
    // Whether or not to show the offline contacts in groups
    bool            showOffline_;
    // Whether or not to show the Removed special group
    bool            showRemoved_;


};



#endif
