# Find Gwenhywfar
#
#  GWENHYWFAR_FOUND - system has Gwenhywfar with the minimum version needed
#  GWENHYWFAR_INCLUDE_DIRS - the Gwenhywfar include directories
#  GWENHYWFAR_LIBRARIES - The libraries needed to use Gwenhywfar
#  GWENHYWFAR_VERSION = The version of Gwenhywfar as defined in version.h

find_package(PkgConfig)

set(GWENHYWFAR_FOUND FALSE)

if(NOT GWENHYWFAR_MIN_VERSION)
  set(GWENHYWFAR_MIN_VERSION "4.0.0")
endif(NOT GWENHYWFAR_MIN_VERSION)

if(GWENHYWFAR_INCLUDE_DIRS AND GWENHYWFAR_LIBRARIES)
  # Already in cache, be silent
  set(GWENHYWFAR_FIND_QUIETLY TRUE)
endif(GWENHYWFAR_INCLUDE_DIRS AND GWENHYWFAR_LIBRARIES)

PKG_CHECK_MODULES(GWENHYWFAR_CORE gwenhywfar>=${GWENHYWFAR_MIN_VERSION})
PKG_CHECK_MODULES(GWENHYWFAR_QT4GUI gwengui-qt4>=${GWENHYWFAR_MIN_VERSION})

if (${GWENHYWFAR_CORE_FOUND} AND ${GWENHYWFAR_QT4GUI_FOUND})
  set(GWENHYWFAR_FOUND TRUE)
  set(GWENHYWFAR_INCLUDE_DIRS ${GWENHYWFAR_CORE_INCLUDE_DIRS})
  set(GWENHYWFAR_LIBRARIES ${GWENHYWFAR_QT4GUI_LIBRARIES} ${GWENHYWFAR_CORE_LIBRARIES})
  set(GWENHYWFAR_VERSION ${GWENHYWFAR_CORE_VERSION})
else (${GWENHYWFAR_CORE_FOUND} AND ${GWENHYWFAR_QT4GUI_FOUND})
  set(GWENHYWFAR_FOUND FALSE)
  unset(GWENHYWFAR_INCLUDE_DIRS)
  unset(GWENHYWFAR_LIBRARIES)
  unset(GWENHYWFAR_VERSION)
endif (${GWENHYWFAR_CORE_FOUND} AND ${GWENHYWFAR_QT4GUI_FOUND})

if (NOT ${GWENHYWFAR_QT4GUI_FOUND})
  message(WARNING "Gwenhywfar does not have the Qt4Banking frontend enabled")
endif (NOT ${GWENHYWFAR_QT4GUI_FOUND})

if (NOT ${GWENHYWFAR_CORE_VERSION} VERSION_EQUAL ${GWENHYWFAR_QT4GUI_VERSION})
  message(WARNING "Gwenhywfar libraries versions mismatch")
endif (NOT ${GWENHYWFAR_CORE_VERSION} VERSION_EQUAL ${GWENHYWFAR_QT4GUI_VERSION})

mark_as_advanced(GWENHYWFAR_INCLUDE_DIRS GWENHYWFAR_LIBRARIES)
