/* Wordpress.vala
 *
 * Copyright (C) 2010  Kushal Das <kushal@fedoraproject.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *
 */

using Soup;

public class Wordpress: Object {
    public string username {get;set;}
    public string password;
    public string server;
    public signal void password_error(string mesaage);
    public signal void get_old_posts(ValueArray v);
    

    public Wordpress(){
        this.username = "";
        this.password = "";
        this.server = "";
    }

    public bool set_details(string name, string pass, string serv) {
        if((this.username == name) & (this.password == pass) & (this.server == serv))
            return false;
            
        this.username = name;
        this.password = pass;
        this.server = serv;
        return true;
    }

    public string post(HashTable content, bool publish) {
    
        
        var message = xmlrpc_request_new(server,"metaWeblog.newPost",typeof(int),1,typeof(string),this.username,typeof(string),this.password,typeof(HashTable),content, typeof(bool), publish);
        var session = new SessionAsync();
        session.send_message(message);
        
        string data =message.response_body.flatten().data;
        Value v = Value(typeof(string));
                try{
            xmlrpc_parse_method_response(data, -1,v);
        }catch (Error e){ 
            password_error(e.message);
            return "None";
        }
        return v.get_string();
    }
    
    public string update(string pid,HashTable content, bool publish) {
        var message = xmlrpc_request_new(server,"metaWeblog.editPost",typeof(string),pid,typeof(string),this.username,typeof(string),this.password,typeof(HashTable),content, typeof(bool), publish);
        var session = new SessionAsync();
        session.send_message(message);
        
        string data =message.response_body.flatten().data;

        Value v = Value(typeof(bool));
                try{
            xmlrpc_parse_method_response(data, -1,v);
        }catch (Error e){ 
            password_error(e.message);
            return "None";
        }
        if (v.get_boolean())
            return "Post updated";
        else
            return "None";
    }
    
    
    public string upload_file(HashTable data) {
        var message = xmlrpc_request_new(server,"wp.uploadFile",typeof(int),1,typeof(string),this.username,typeof(string),this.password,typeof(HashTable),data);
        var session = new SessionAsync();
        session.send_message(message);
        
        string returndata =message.response_body.flatten().data;
        Value v = Value(typeof(HashTable));
        try{
            xmlrpc_parse_method_response(returndata, -1,v);
        }catch (Error e){ 
            password_error(e.message);
            return "";
        }
        HashTable<string, Value?> hash = (HashTable)v;
        var x = hash.lookup("url");
        
        return (string)x;
    }
    
    
    public void add_category(string category) {
        HashTable<string,Value?> hash = new HashTable<string, Value?>.full (str_hash, str_equal, g_free, g_free);
        hash.insert("name", category);
        var message = xmlrpc_request_new(server,"wp.newCategory",typeof(int),1,typeof(string),this.username,typeof(string),this.password,typeof(HashTable),hash);
        var session = new SessionSync();
        session.send_message(message);

    }
    
    public HashTable get_last_post(){
        var message = xmlrpc_request_new(server,"metaWeblog.getRecentPosts",typeof(int),1,typeof(string),this.username,typeof(string),this.password,typeof(int),1);
        var session = new SessionAsync();
        var return_code = session.send_message(message);
        if (return_code == 2){
            password_error("Please check your network");
            return new HashTable<string, string>.full (str_hash, str_equal, g_free, g_free);
        }
        
        string data =message.response_body.flatten().data;
        //stdout.printf("%d\n",(int)data.length);
        unowned ValueArray v3;
        Value v = Value(typeof(ValueArray));
        try{
            xmlrpc_parse_method_response(data, -1,v);
        }catch (Error e){ 
            password_error(e.message);
            return new HashTable<string, string>.full (str_hash, str_equal, g_free, g_free);
        }
        v3 = (ValueArray)v;
        var hash = (HashTable<string,Value?>)v3.get_nth(0);

        return hash;

    }

    public void delete_post(int id){
        Message message = xmlrpc_request_new(server,"metaWeblog.deletePost",typeof(int),1,typeof(int),id,typeof(string),this.username,typeof(string),this.password,typeof(bool),false);
        debug(message.request_body.flatten().data);
        var session = new SessionAsync();
        var return_code = session.send_message(message);
        if (return_code == 2){
            password_error("Please check your network");
            return;
        }

    
    }
    
    public HashTable get_post(string id){
        var message = xmlrpc_request_new(server,"metaWeblog.getPost",typeof(string),id,typeof(string),this.username,typeof(string),this.password);
        var session = new SessionAsync();
        var return_code = session.send_message(message);
        if (return_code == 2){
            password_error("Please check your network");
            return new HashTable<string, string>.full (str_hash, str_equal, g_free, g_free);
        }
        
        string data =message.response_body.flatten().data;
        //stdout.printf("%d\n",(int)data.length);
        Value v = Value(typeof(Value));
        try{
            xmlrpc_parse_method_response(data, -1,v);
        }catch (Error e){ 
            password_error(e.message);
            return new HashTable<string, string>.full (str_hash, str_equal, g_free, g_free);
        }

        var hash = (HashTable<string,Value?>)v;

        return hash;

    }


    public bool get_posts(){
        var message = xmlrpc_request_new(server,"metaWeblog.getRecentPosts",typeof(int),1,typeof(string),this.username,typeof(string),this.password,typeof(int),10);
        var session = new SessionAsync();
        var return_code = session.send_message(message);
        
        if (return_code == 2){
            password_error("Please check your network");
            return false;
        }
        
        string data =message.response_body.flatten().data;
        //stdout.printf("%d\n",(int)data.length);
        unowned ValueArray v3;
        Value v = Value(typeof(ValueArray));
        try{
            xmlrpc_parse_method_response(data, -1,v);
        }catch (Error e){ 
            password_error(e.message);
            return false;
;
        }
        v3 = (ValueArray)v;
        if (v3 != null){
            get_old_posts(v3);
            return false;
        }
        return true;
    }

    public string[] get_categories(){
        var message = xmlrpc_request_new(server,"wp.getCategories",typeof(int),1,typeof(string),this.username,typeof(string),this.password);
        var session = new SessionAsync();
        var return_code = session.send_message(message);
        //debug(return_code.to_string());
        if (return_code == 2){
            password_error("Please check your network");
            return {};
        }else if (return_code == 302){

            password_error("Error 302: may want to check username or url");
            return {};
        
        }
        string data = message.response_body.flatten().data;
        
        if(data.contains("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">")){
            password_error("Error 302: may want to check username or url");
            return {};
        }
        
        
        unowned ValueArray v3;
        Value v = Value(typeof(ValueArray));
        try {
            xmlrpc_parse_method_response(data, -1,v);
        }catch (Error e){ 
            password_error(e.message);
            return {};
        }
        v3 = (ValueArray)v;
        string[] result = {};
        for(int i = 0; i < v3.n_values; i++) {
            var hash = (HashTable<string,Value?>)v3.get_nth(i);

            var x = hash.lookup("description");
            result += x.get_string();
        }
        return result;
        
    }
   
        
    

}



