/*
    This file is part of libdjinterop.

    libdjinterop is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    libdjinterop is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with libdjinterop.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once
#ifndef DJINTEROP_DJINTEROP_HPP
#define DJINTEROP_DJINTEROP_HPP

#if __cplusplus < 201703L
#error This library needs at least a C++17 compliant compiler
#endif

#include <djinterop/album_art.hpp>
#include <djinterop/crate.hpp>
#include <djinterop/database.hpp>
#include <djinterop/engine/engine.hpp>
#include <djinterop/exceptions.hpp>
#include <djinterop/musical_key.hpp>
#include <djinterop/pad_color.hpp>
#include <djinterop/performance_data.hpp>
#include <djinterop/semantic_version.hpp>
#include <djinterop/track.hpp>
#include <djinterop/track_snapshot.hpp>

#endif  // DJINTEROP_DJINTEROP_HPP
