------------------------------------------------------------------------------
--                                                                          --
--                	        G N A T . RAVENSCAR                         --
--                                                                          --
--                      Copyright (C) 2008-2017, AdaCore                    --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.Ravenscar.Multiple_Queue_Sporadic_Server;

package Test_All.Multiple_Queue_Sporadic_Server is

   type Request_T is (REQ1, REQ2);

   type Param_T (R : Request_T := REQ1) is
      record
         Req : Request_T := R;
         case R is
            when REQ1 =>
               REQ1_I : Integer;
            when REQ2 =>
               REQ2_I : Integer;
         end case;
      end record;
   procedure Dispatch (Params : Param_T);
   package My_Sporadic_Server is new
     GNAT.Ravenscar.Multiple_Queue_Sporadic_Server
     (10, 20, System_Start_Up, 15, 2, Request_T, Param_T, Dispatch);

end Test_All.Multiple_Queue_Sporadic_Server;
