/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFFont;
import gnu.jpdf.PDFImage;
import gnu.jpdf.PDFPage;
import gnu.jpdf.PDFStream;
import gnu.jpdf.PDFStringHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PageFormat;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Map;

public class PDFGraphics
extends Graphics2D
implements Serializable {
    private static final double degrees_to_radians = Math.PI / 180;
    private static final int FILL = 1;
    private static final int STROKE = 2;
    private static final int CLIP = 3;
    private static final AffineTransform IDENTITY = new AffineTransform();
    private static final Stroke DEF_STROKE = new BasicStroke();
    private static final DecimalFormat df = new DecimalFormat("#.###");
    private Color background;
    private boolean child;
    private Area clip;
    protected Rectangle clipRectangle;
    private Composite composite;
    private final Graphics2D dg2 = new BufferedImage(2, 2, 1).createGraphics();
    private Font font;
    private boolean inStroke;
    private boolean inText;
    private int lineCap = 0;
    private int lineJoin = 0;
    private float lineWidth = 1.0f;
    private float lx;
    private float ly;
    private float miterLimit = 10.0f;
    private boolean newFont;
    private Stroke originalStroke;
    private AffineTransform oTransform;
    private PDFPage page;
    private Paint paint;
    private PDFFont pdffont;
    private String pre_np;
    private AffineTransform pTransform;
    private PrintWriter pw;
    private final RenderingHints rhints = new RenderingHints(null);
    private Stroke stroke;
    private AffineTransform transform;
    protected float trax;
    protected float tray;
    private float tx;
    private float ty;

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        this.rhints.putAll(map);
    }

    public void arc(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        double d7;
        double d8;
        boolean bl2 = true;
        double d9 = d5 % 360.0 * (Math.PI / 180);
        double d10 = Math.sin(d9);
        double d11 = Math.cos(d9);
        double d12 = d + d3 * d11;
        double d13 = d2 + d4 * d10;
        if (!bl) {
            while (d5 < d6) {
                d6 -= 360.0;
            }
            while (true) {
                double d14;
                d8 = d6 - d5;
                if (d14 < -90.0) {
                    d7 = d10;
                    d10 = -d11;
                    d11 = d7;
                    double d15 = d + d3 * d11;
                    double d16 = d2 + d4 * d10;
                    this.arc_add(bl2, d3, d4, d12, d13, d15, d16, d12 + d3 * d11, d13 + d4 * d10);
                    d12 = d15;
                    d13 = d16;
                    d5 -= 90.0;
                    bl2 = false;
                    continue;
                }
                break;
            }
        } else {
            while (d6 < d5) {
                d6 += 360.0;
            }
            while (true) {
                double d17;
                d8 = d6 - d5;
                if (!(d17 > 90.0)) break;
                d7 = d11;
                d11 = -d10;
                d10 = d7;
                double d18 = d + d3 * d11;
                double d19 = d2 + d4 * d10;
                this.arc_add(bl2, d3, d4, d12, d13, d18, d19, d12 + d3 * d11, d13 + d4 * d10);
                d12 = d18;
                d13 = d19;
                d5 += 90.0;
                bl2 = false;
            }
        }
        d7 = Math.tan(d8 * (Math.PI / 360));
        double d20 = d6 * (Math.PI / 180);
        double d21 = d12 - d7 * d3 * d10;
        double d22 = d13 + d7 * d4 * d11;
        this.arc_add(bl2, d3, d4, d12, d13, d + d3 * Math.cos(d20), d2 + d4 * Math.sin(d20), d21, d22);
    }

    private void arc_add(boolean bl, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d7 - d3;
        double d10 = d8 - d4;
        double d11 = d9 * d9 + d10 * d10;
        double d12 = d * d;
        double d13 = d2 * d2;
        double d14 = d12 + d13;
        double d15 = 0.0;
        double d16 = 0.0;
        if (d11 < d14 * 1.0E8) {
            d15 = d12 != 0.0 ? 1.3333333333333333 / (1.0 + Math.sqrt(1.0 + d11 / d12)) : 0.0;
            double d17 = d16 = d13 != 0.0 ? 1.3333333333333333 / (1.0 + Math.sqrt(1.0 + d11 / d13)) : 0.0;
        }
        if (bl) {
            this.moveto(d3, d4);
        }
        double d18 = d3 + (d7 - d3) * d15;
        double d19 = d4 + (d8 - d4) * d16;
        d3 = d5 + (d7 - d5) * d15;
        d4 = d6 + (d8 - d6) * d16;
        this.curveto(d18, d19, d3, d4, d5, d6);
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.closeBlock();
        this.pw.print("q 1 1 1 RG ");
        this.drawRect(n, n2, n3, n4);
        this.closeBlock("B Q");
    }

    @Override
    public void clip(Shape shape) {
        if (shape == null) {
            this.setClip(null);
            return;
        }
        shape = this.transform.createTransformedShape(shape);
        if (this.clip == null) {
            this.clip = new Area(shape);
        } else {
            this.clip.intersect(new Area(shape));
        }
    }

    public void clipPolygon(Polygon polygon) {
        this.closeBlock();
        this.polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        this.closeBlock("W");
        this.clipRectangle = polygon.getBounds();
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.setClip(n, n2, n3, n4);
    }

    void closeBlock() {
        this.closeBlock("S");
    }

    void closeBlock(String string) {
        if (this.inText) {
            this.pw.println("ET Q");
        }
        if (this.inStroke) {
            this.pw.println(string);
        }
        this.inText = false;
        this.inStroke = false;
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public Graphics create() {
        this.closeBlock();
        PDFGraphics pDFGraphics = this.createGraphic(this.page, this.pw);
        pDFGraphics.trax = this.trax;
        pDFGraphics.tray = this.tray;
        pDFGraphics.clipRectangle = new Rectangle(this.clipRectangle);
        return pDFGraphics;
    }

    protected PDFGraphics createGraphic(PDFPage pDFPage, PrintWriter printWriter) {
        PDFGraphics pDFGraphics = new PDFGraphics();
        pDFGraphics.init(pDFPage, printWriter);
        return pDFGraphics;
    }

    public void curveto(double d, double d2, double d3, double d4) {
        this.newPath();
        this.pw.println(this.cxy(d, d2) + this.cxy(d3, d4) + "v");
        this.lx = (float)d3;
        this.ly = (float)d4;
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        this.newPath();
        this.pw.println(this.cxy(d, d2) + this.cxy(d3, d4) + this.cxy(d5, d6) + "c");
        this.lx = (float)d5;
        this.ly = (float)d6;
    }

    public void curveto(int n, int n2, int n3, int n4) {
        this.newPath();
        this.pw.println(this.cxy(n, n2) + this.cxy(n3, n4) + "v");
        this.lx = n3;
        this.ly = n4;
    }

    public void curveto(int n, int n2, int n3, int n4, int n5, int n6) {
        this.newPath();
        this.pw.println(this.cxy(n, n2) + this.cxy(n3, n4) + this.cxy(n5, n6) + "c");
        this.lx = n5;
        this.ly = n6;
    }

    public void curveto2(double d, double d2, double d3, double d4) {
        this.newPath();
        this.pw.println(this.cxy(d, d2) + this.cxy(d3, d4) + "y");
        this.lx = (float)d3;
        this.ly = (float)d4;
    }

    public void curveto2(int n, int n2, int n3, int n4) {
        this.newPath();
        this.pw.println(this.cxy(n, n2) + this.cxy(n3, n4) + "y");
        this.lx = n3;
        this.ly = n4;
    }

    private String cwh(double d, double d2) {
        double d3 = d;
        double d4 = d2;
        d4 = -d2;
        return "" + df.format(d3) + " " + df.format(d4) + " ";
    }

    private String cwh(int n, int n2) {
        return this.cwh((double)n, (double)n2);
    }

    private String cxy(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        Point2D.Double double_2 = new Point2D.Double();
        this.transform.transform(double_, double_2);
        return "" + df.format(((Point2D)double_2).getX()) + " " + df.format(((Point2D)double_2).getY()) + " ";
    }

    private String cxy(int n, int n2) {
        return this.cxy((double)n, (double)n2);
    }

    @Override
    public void dispose() {
        this.closeBlock();
        if (this.child) {
            this.pw.println("Q");
        } else {
            this.pw.close();
        }
    }

    @Override
    public void draw(Shape shape) {
        this.followPath(shape, 2);
    }

    @Override
    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.arc(n += (n3 >>= 1), n2 += (n4 >>= 1), n3, n4, -n5, -n5 - n6, false);
    }

    @Override
    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        Shape shape = glyphVector.getOutline(f, f2);
        this.fill(shape);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImageOp != null) {
            bufferedImage2 = bufferedImageOp.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
            bufferedImage2 = bufferedImageOp.filter(bufferedImage, bufferedImage2);
        }
        this.drawImage((Image)bufferedImage2, n, n2, null);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.closeBlock();
        this.pw.print("q ");
        Color color2 = this.getColor();
        this.setColor(color);
        this.drawRect(n, n2, n3, n4);
        this.closeBlock("B Q");
        this.paint = color2;
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.closeBlock();
        PDFImage pDFImage = new PDFImage(image, n, n2, n3, n4, imageObserver);
        this.page.getPDFDocument().setImageName(pDFImage);
        this.page.getPDFDocument().add(pDFImage);
        this.page.addToProcset("/ImageC");
        this.page.addImageResource(pDFImage.getName() + " " + pDFImage.getSerialID() + " 0 R");
        this.pw.print("q " + pDFImage.getWidth() + " 0 0 " + pDFImage.getHeight() + " " + n + " " + ((int)this.page.getDimension().getHeight() - n2 - pDFImage.getHeight()) + " cm \n" + pDFImage.getName() + " Do\nQ\n");
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.moveto(n, n2);
        this.lineto(n3, n4);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawArc(n, n2, n3, n4, 0, 360);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.polygon(nArray, nArray2, n);
        this.closeBlock("s");
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.polygon(nArray, nArray2, n);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.newPath();
        this.pw.print(this.cxy(n, n2) + this.cwh(n3, n4) + "re ");
        this.lx = n;
        this.ly = n2;
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createDefaultRendering(), affineTransform);
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        BufferedImage object;
        if (renderedImage instanceof BufferedImage) {
            object = (BufferedImage)renderedImage;
        } else {
            ColorModel colorModel = renderedImage.getColorModel();
            int n = renderedImage.getWidth();
            int n2 = renderedImage.getHeight();
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
            boolean bl = colorModel.isAlphaPremultiplied();
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String[] stringArray = renderedImage.getPropertyNames();
            if (stringArray != null) {
                for (String string : stringArray) {
                    hashtable.put(string, renderedImage.getProperty(string));
                }
            }
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, bl, hashtable);
            renderedImage.copyData(writableRaster);
            object = bufferedImage;
        }
        this.drawImage(object, affineTransform, null);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    @Override
    public void drawString(String string, float f, float f2) {
        this.newTextBlock(f, f2);
        this.pw.println(PDFStringHelper.makePDFString(string) + " Tj");
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.newTextBlock(n, n2);
        this.pw.println(PDFStringHelper.makePDFString(string) + " Tj");
    }

    public void drawString(String string, float f, float f2, float f3) {
        if (f3 == 0.0f) {
            this.drawString(string, f, f2);
        } else {
            this.writeSaveState();
            Point2D.Double double_ = this.originWithRotation(f3);
            double d = -double_.getX();
            double d2 = this.flipY(double_.getY());
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
            AffineTransform affineTransform2 = AffineTransform.getRotateInstance(f3);
            affineTransform.concatenate(affineTransform2);
            Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
            Point2D.Double double_3 = new Point2D.Double();
            affineTransform.transform(double_2, double_3);
            this.writeTranslate(this.trax, -this.tray);
            this.writeTranslate(d += double_3.getX(), d2 -= double_3.getY());
            this.writeRotate(-f3);
            this.writeTranslate(-this.trax, this.tray);
            this.drawString(string, 0, 0);
            this.writeRestoreState();
        }
    }

    @Override
    public void fill(Shape shape) {
        this.followPath(shape, 1);
    }

    @Override
    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.closeBlock();
        this.drawArc(n, n2, n3, n4, n5, n6);
        this.lineto(n + (n3 >> 1), n2 + (n4 >> 1));
        this.closeBlock("b");
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.fillArc(n, n2, n3, n4, 0, 360);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.closeBlock();
        this.polygon(nArray, nArray2, n);
        this.closeBlock("b");
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.closeBlock();
        this.drawRect(n, n2, n3, n4);
        this.closeBlock("B");
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    private void followPath(Shape shape, int n) {
        if (shape == null) {
            return;
        }
        if (n == 2 && !(this.stroke instanceof BasicStroke)) {
            shape = this.stroke.createStrokedShape(shape);
            this.followPath(shape, 1);
            return;
        }
        PathIterator pathIterator = shape.getPathIterator(IDENTITY);
        int n2 = 0;
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            ++n2;
            int n3 = pathIterator.currentSegment(fArray);
            switch (n3) {
                case 4: {
                    this.pw.print("h ");
                    break;
                }
                case 3: {
                    this.curveto(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 1: {
                    this.lineto(fArray[0], fArray[1]);
                    break;
                }
                case 0: {
                    this.moveto(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.curveto(fArray[0], fArray[1], fArray[2], fArray[3]);
                }
            }
            pathIterator.next();
        }
        switch (n) {
            case 1: {
                if (n2 <= 0) break;
                if (pathIterator.getWindingRule() == 0) {
                    this.closeBlock("B*");
                    break;
                }
                this.closeBlock("B");
                break;
            }
            case 2: {
                if (n2 <= 0) break;
                this.closeBlock("S");
                break;
            }
            default: {
                if (n2 == 0) {
                    this.drawRect(0, 0, 0, 0);
                }
                if (pathIterator.getWindingRule() == 0) {
                    this.closeBlock("W*");
                    break;
                }
                this.closeBlock("W");
            }
        }
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public Shape getClip() {
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clipRectangle;
    }

    @Override
    public Color getColor() {
        return this.paint instanceof Color ? (Color)this.paint : Color.black;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.dg2.getDeviceConfiguration();
    }

    @Override
    public Font getFont() {
        if (this.font == null) {
            this.setFont(new Font("SansSerif", 0, 12));
        }
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        boolean bl = RenderingHints.VALUE_TEXT_ANTIALIAS_ON.equals(this.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
        boolean bl2 = RenderingHints.VALUE_FRACTIONALMETRICS_ON.equals(this.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS));
        return new FontRenderContext(new AffineTransform(), bl, bl2);
    }

    public PDFPage getPage() {
        return this.page;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.rhints.get(key);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.rhints;
    }

    @Override
    public Stroke getStroke() {
        return this.originalStroke;
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.oTransform);
    }

    public PrintWriter getWriter() {
        return this.pw;
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        if (bl) {
            shape = this.stroke.createStrokedShape(shape);
        }
        shape = this.transform.createTransformedShape(shape);
        Area area = new Area(shape);
        if (this.clip != null) {
            area.intersect(this.clip);
        }
        return area.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void init() {
        PageFormat pageFormat = this.page.getPageFormat();
        if (this.child) {
            this.pw.print("q ");
        }
        this.paint = Color.black;
        this.oTransform = new AffineTransform();
        this.pTransform = new AffineTransform();
        this.pTransform.translate(0.0, pageFormat.getHeight());
        this.pTransform.scale(1.0, -1.0);
        this.transform = new AffineTransform(this.oTransform);
        this.transform.concatenate(this.pTransform);
        this.setStroke(DEF_STROKE);
    }

    protected void init(PDFPage pDFPage) {
        this.page = pDFPage;
        this.child = false;
        PDFStream pDFStream = new PDFStream();
        pDFStream.setDeflate(true);
        pDFPage.getPDFDocument().add(pDFStream);
        pDFPage.add(pDFStream);
        this.pw = pDFStream.getWriter();
        this.clipRectangle = pDFPage.getImageableArea();
        this.init();
    }

    protected void init(PDFPage pDFPage, PrintWriter printWriter) {
        this.page = pDFPage;
        this.pw = printWriter;
        this.child = true;
        this.init();
    }

    public void lineto(double d, double d2) {
        this.newPath();
        this.pw.print(this.cxy(d, d2) + "l ");
        this.lx = (float)d;
        this.ly = (float)d2;
    }

    public void lineto(int n, int n2) {
        this.newPath();
        if (this.lx != (float)n && this.ly != (float)n2) {
            this.pw.print(this.cxy(n, n2) + "l ");
        }
        this.lx = n;
        this.ly = n2;
    }

    public void moveto(double d, double d2) {
        this.newPath();
        this.pw.print(this.cxy(d, d2) + "m ");
        this.lx = (float)d;
        this.ly = (float)d2;
    }

    public void moveto(int n, int n2) {
        this.newPath();
        if (this.lx != (float)n || this.ly != (float)n2) {
            this.pw.print(this.cxy(n, n2) + "m ");
        }
        this.lx = n;
        this.ly = n2;
    }

    void newPath() {
        if (this.inText) {
            this.closeBlock();
        }
        if (!this.inStroke) {
            if (this.pre_np != null) {
                this.pw.print(this.pre_np);
                this.pre_np = null;
            }
            this.pw.print("n ");
        }
        this.inText = false;
        this.inStroke = true;
        this.ly = -9999.0f;
        this.lx = -9999.0f;
    }

    void newTextBlock(float f, float f2) {
        if (this.inStroke) {
            this.closeBlock();
        }
        if (!this.inText) {
            this.getFont();
            this.pw.print("q BT ");
            this.ty = 0.0f;
            this.tx = 0.0f;
            this.pw.print(this.txy(f, f2) + "Td ");
        } else {
            this.pw.print(this.twh(f, f2, this.tx, this.ty) + "Td ");
        }
        this.tx = f;
        this.ty = f2;
        if (this.newFont || !this.inText) {
            this.pw.print(this.pdffont.getName() + " " + this.font.getSize() + " Tf ");
        }
        this.newFont = false;
        this.inStroke = false;
        this.inText = true;
    }

    public void polygon(int[] nArray, int[] nArray2, int n) {
        this.moveto(nArray[0], nArray2[0]);
        for (int i = 1; i < n; ++i) {
            this.lineto(nArray[i], nArray2[i]);
        }
    }

    @Override
    public void rotate(double d) {
        this.transform.rotate(d);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.transform.rotate(d, d2, d3);
    }

    @Override
    public void scale(double d, double d2) {
        this.transform.scale(d, d2);
        this.stroke = this.transformStroke(this.originalStroke);
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.clipRectangle = new Rectangle(n, n2, n3, n4);
        this.closeBlock();
        this.closeBlock("W n");
    }

    @Override
    public void setClip(Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void setColor(Color color) {
        this.setPaint(color);
    }

    @Override
    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setDefaultLineWidth() {
        this.closeBlock();
        this.pw.println("1 w");
    }

    @Override
    public void setFont(Font font) {
        if (this.font != font) {
            this.font = font;
            this.pdffont = this.page.getFont("/Type1", font.getName(), font.getStyle());
            this.newFont = true;
        }
    }

    private void setLineCap(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        if (this.lineCap != n2) {
            this.closeBlock();
            this.lineCap = n2;
            this.pw.println("" + n2 + " J");
        }
    }

    private void setLineJoin(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        if (this.lineJoin != n2) {
            this.closeBlock();
            this.lineJoin = n2;
            this.pw.println("" + n2 + " j");
        }
    }

    public void setLineWidth(float f) {
        if (f != this.lineWidth) {
            this.closeBlock();
            this.lineWidth = f;
            this.pw.println("" + f + " w");
        }
    }

    private void setMiterLimit(float f) {
        if (f != this.miterLimit) {
            this.closeBlock();
            this.miterLimit = f;
            this.pw.println("" + f + " M");
        }
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
        if (paint instanceof Color) {
            Color color = (Color)paint;
            double d = (double)color.getRed() / 255.0;
            double d2 = (double)color.getGreen() / 255.0;
            double d3 = (double)color.getBlue() / 255.0;
            this.closeBlock();
            this.pw.println("" + d + " " + d2 + " " + d3 + " rg " + d + " " + d2 + " " + d3 + " RG");
        }
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (object != null) {
            this.rhints.put(key, object);
        } else {
            this.rhints.remove(key);
        }
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this.rhints.clear();
        this.rhints.putAll(map);
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.originalStroke = stroke;
        this.stroke = this.transformStroke(stroke);
        if (this.stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)this.stroke;
            this.setLineCap(basicStroke.getEndCap());
            this.setLineJoin(basicStroke.getLineJoin());
            this.setLineWidth(basicStroke.getLineWidth());
            this.setMiterLimit(basicStroke.getMiterLimit());
        }
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.oTransform = affineTransform;
        this.transform = new AffineTransform(affineTransform);
        this.transform.concatenate(this.pTransform);
        this.stroke = this.transformStroke(this.originalStroke);
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public void shear(double d, double d2) {
        this.transform.shear(d, d2);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
        this.stroke = this.transformStroke(this.originalStroke);
    }

    private Stroke transformStroke(Stroke stroke) {
        if (!(stroke instanceof BasicStroke)) {
            return stroke;
        }
        BasicStroke basicStroke = (BasicStroke)stroke;
        float f = (float)Math.sqrt(Math.abs(this.transform.getDeterminant()));
        float[] fArray = basicStroke.getDashArray();
        if (fArray != null) {
            int n = 0;
            while (n < fArray.length) {
                int n2 = n++;
                fArray[n2] = fArray[n2] * f;
            }
        }
        return new BasicStroke(basicStroke.getLineWidth() * f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), fArray, basicStroke.getDashPhase() * f);
    }

    @Override
    public void translate(double d, double d2) {
        this.transform.translate(d, d2);
        this.trax = (float)d;
        this.tray = (float)d2;
    }

    @Override
    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    private String twh(float f, float f2, float f3, float f4) {
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        int n = (int)this.page.getPageFormat().getHeight();
        boolean bl = true;
        boolean bl2 = true;
        f6 = (float)n - f2;
        f8 = (float)n - f4;
        f5 = (float)bl * (f5 - f7);
        f6 = (float)bl2 * (f6 - f8);
        return "" + df.format(f5) + " " + df.format(f6) + " ";
    }

    private String txy(float f, float f2) {
        Point2D.Float float_ = new Point2D.Float(f, f2);
        Point2D.Float float_2 = new Point2D.Float();
        this.transform.transform(float_, float_2);
        return "" + df.format(((Point2D)float_2).getX()) + " " + df.format(((Point2D)float_2).getY()) + " ";
    }

    public void writeSaveState() {
        this.pw.print("q ");
    }

    public void writeRestoreState() {
        this.pw.print("Q ");
    }

    public void writeTranslate(double d, double d2) {
        this.pw.print("1 0 0 1 " + df.format(d) + " " + df.format(d2) + " cm ");
    }

    public void writeRotate(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        this.pw.print("" + df.format(d3) + " " + df.format(d2) + " " + df.format(-d2) + " " + df.format(d3) + " 0 0 cm ");
    }

    public void writeScale(double d, double d2) {
        this.pw.print("" + df.format(d) + " 0 0 " + df.format(d2) + " 0 0 cm ");
    }

    public double flipY(double d) {
        return this.page.getDimension().getHeight() - d;
    }

    public Point2D.Double originWithRotation(double d) {
        return new Point2D.Double(this.page.getDimension().getHeight() * Math.sin(d), this.page.getDimension().getHeight() * Math.cos(d));
    }
}

