/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/



#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Tab.h>
#include <Xm/ToggleB.h>
#include <Xm/Text.h>

#ifndef XMText_H
#include "XMText.h"
#endif

#ifndef EditorButton_H
#include "EditorButton.h"
#endif

#ifndef Netscape_H
#include "Netscape.h"
#endif

#ifndef InternalEditor_H
#include "InternalEditor.h"
#endif

#ifndef MetviewUI_H
#include "MetviewUI.h"
#endif

#ifndef EditorFactory_H
#include "EditorFactory.h"
#endif
#ifndef IconFactory_H
#include "IconFactory.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif

#ifndef EditorDrawerFactory_H
#include "EditorDrawerFactory.h"
#endif

#ifndef XPixmap_H
#include "XPixmap.h"
#endif


#ifndef EditorDrawer_H
#include "EditorDrawer.h"
#endif

#ifndef Dropping_H
#include "Dropping.h"
#endif

#ifndef EditorToolFactory_H
#include "EditorToolFactory.h"
#endif

#ifndef Confirm_H
#include "Confirm.h"
#endif

#ifndef Log_H
#include "Log.h"
#endif


InternalEditor::InternalEditor(const IconClass& c,const string& kind):
	Editor(c,kind)
{
	Widget top = MetviewUI::root();
	create(XtDisplay(top),"Metview",0,0);

	DropSite::install(main_);

	XPixmap p(c.pixmap());
	p.setLabel(icon_);

}

InternalEditor::~InternalEditor()
{
	// Not called

	//if(current_) current_->detach();
	//XtDestroyWidget(xd_rootwidget());
	//

}

void InternalEditor::edit()
{
	XtSetSensitive(name_,True);
	XtSetSensitive(stay_,True);

	if(drawers_.size() == 0)
	{
		drawers_ = EditorDrawerFactory::create(this);
		TabClose(drawer_);
		tools_ = EditorToolFactory::create(this);
	}

	XMText text(name_);
	text.set(current_->name());
	reset();
	for (map<string, EditorDrawer*>::iterator j = drawers_.begin(); 
		j != drawers_.end(); ++j) 
			(*j).second->edit(current_); 
}

void InternalEditor::updateDrawers()
{
	for (map<string, EditorDrawer*>::iterator j = drawers_.begin(); 
		j != drawers_.end(); ++j) 
			(*j).second->update();
}

void InternalEditor::raise()
{
	XtRealizeWidget(xd_rootwidget());
	XMapRaised(XtDisplay(xd_rootwidget()),XtWindow(xd_rootwidget()));
}	

IconObject* InternalEditor::copy(const string& name) 
{
	return IconFactory::create(name, class_);
}

void InternalEditor::closeCB(Widget,XtPointer)
{
	close();
	notifyObserverClose();	
	done();

	XUnmapWindow(XtDisplay(xd_rootwidget()),XtWindow(xd_rootwidget()));
	XmToggleButtonSetState(stay_,False,False);
}


void InternalEditor::resetCB(Widget,XtPointer)
{
	XMText text(name_);
	text.set(current_->name());
	reset();
}

void InternalEditor::applyCB(Widget w,XtPointer p)
{
  if( ! current_ ) //-- double click on 'apply' causes current_ to be 0!
    {
      //Log::error(0) << "ViewEditor::apply: current_ is null ptr!" << endl;
      cout << ">>>>> ViewEditor::apply: current_ is null ptr!" << endl;
      return;
    }

	bool stay = XmToggleButtonGetState(stay_);

	apply();
	current_->modified();

	// Rename if needed
	XMText text(name_);
	string n = text.get();

	if( n != current_->name())
	{
		current_->editor(0);
		current_->rename(n);
		current_->editor(this);
	}

	notifyObserverApply();

	// Close

	if(!stay)
		closeCB(w,p);

}

string InternalEditor::alternateEditor()
{
	return "TextEditor";
}

void InternalEditor::textEditorCB( Widget, XtPointer )
{
	startAlternate();
}

bool InternalEditor::modified()
{
	return true;
}

void InternalEditor::startAlternate()
{
	IconObjectH save = current_;

	if(modified() && !Confirm::ask(true,"Apply first?"))
		return;

	EditorObserver* o = observer_;
	observer_ = 0;

	XmToggleButtonSetState(stay_,False,False);
	applyCB(0,0); 

	Editor* e = EditorFactory::find(iconClass(),alternateEditor());
	e->edit(save);
	e->observer(o);
	if(temporary_) e->temporary();

}
void InternalEditor::drop(Dropping& d)
{
	IconObjectH o = d.object(*this);
	merge(o);
}

void InternalEditor::apply()
{
}

void InternalEditor::reset()
{
}

void InternalEditor::close()
{
}

Widget InternalEditor::main()
{
	return main_;
}

Widget InternalEditor::drawer()
{
	return drawer_;
}

Widget InternalEditor::tool()
{
	return tool_;
}

Widget InternalEditor::dropSite()
{
	return main_;
}

void InternalEditor::temporary()
{
	Editor::temporary();
	XtSetSensitive(name_,False);
	XtSetSensitive(stay_,False);
}

void InternalEditor::empty()
{
	closeCB(0,0);
}

void InternalEditor::help()
{
//	Netscape::showPage("app_help", iconClass().name() + ".html" );
	Netscape::showPage("app_help", iconClass().helpPage() + ".html" );
}

static EditorButtonMaker<InternalEditor> b1("Help",&InternalEditor::help,999);

