/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MotifDrop_H
#include "MotifDrop.h"
#endif

#include <Xm/AtomMgr.h>
#include <Xm/DragDrop.h>
#include <Xm/ScrolledWP.h>

#ifndef DropSite_H
#include "DropSite.h"
#endif

#ifndef Folder_H
#include "Folder.h"
#endif

#ifndef IconFactory_H
#include "IconFactory.h"
#endif


MotifDrop::MotifDrop(DropSite *owner):
	owner_(owner)
{
}

MotifDrop::~MotifDrop()
{
}

void MotifDrop::run()
{
	owner_->drop(*this);
	disable();
}

void MotifDrop::drop(const string& text)
{
	Folder* temp = Folder::folder("temporary");

	name_ = temp->uniqueName("Drop");

	Path p = temp->path().add(name_);
	p.saveText(text);

	enable();

}

IconObject* MotifDrop::object(DropSite&)
{
	return IconFactory::create(Folder::folder("temporary"),name_);
}

bool MotifDrop::copy()
{
	return true;
}

static void TransferProcCallback(Widget w, 
	XtPointer closure, 
	Atom *, Atom *type,
	XtPointer value, unsigned long *, int *)
{
	MotifDrop *md      = (MotifDrop*)closure;
	Display   *display = XtDisplay(w);
	Atom COMPOUND_TEXT = XmInternAtom(display,"COMPOUND_TEXT",False);
	Atom NULL_ATOM     = XmInternAtom(display,"NULL",False);

	if(*type != NULL_ATOM && (!value || (*type != COMPOUND_TEXT)))
	{
		Arg al[2];
		int n = 0;
		XtSetArg(al[n], XmNtransferStatus, XmTRANSFER_FAILURE); n++;
		XtSetArg(al[n], XmNnumDropTransfers, 0); n++;
		XtSetValues(w, al, n);
	}

	if(*type == COMPOUND_TEXT)
		if(value) 
			md->drop((char*)value);

	if (value) XtFree((char*)value);
}


static void DropProcCallback(Widget w,XtPointer,XmDropProcCallbackStruct *cb)
{
	Arg al[10];
	int n = 0;
	int t = 0;
	Display *display = XtDisplay(w);
	XmDropTransferEntryRec trans[2];

	if ( (cb->operations & XmDROP_COPY) == 0)
	{
		cb->operation      = XmDROP_NOOP;
		cb->dropSiteStatus = XmINVALID_DROP_SITE;
		XtSetArg(al[n], XmNtransferStatus, XmTRANSFER_FAILURE); n++;
	}
	else
	{
		MotifDrop* site = 0;
		XtVaGetValues(w,XmNuserData,&site,0);
		site->position(cb->x,cb->y);

		trans[t].target      = XmInternAtom(display,"COMPOUND_TEXT",False);
		trans[t].client_data = XtPointer(site);
		t++;
		cb->dropSiteStatus    = XmVALID_DROP_SITE;

		XtSetArg(al[n], XmNtransferProc, TransferProcCallback); n++;
	}

	XtSetArg(al[n], XmNdropTransfers, &trans); n++;
	XtSetArg(al[n], XmNnumDropTransfers, t);  n++;


	XmDropTransferStart(cb->dragContext, al,n);
}


void MotifDrop::addSite(DropSite* s,Widget w)
{
	// Motif Drop

	MotifDrop* d = new MotifDrop(s);

	int ac = 0;
	int t  = 0;
	Arg al[10];
	Display *display = XtDisplay(w);
	Atom    targets[3];

	targets[t++] = XmInternAtom(display, "COMPOUND_TEXT", False);
	XtSetArg(al[ac], XmNimportTargets, targets); ac++;
	XtSetArg(al[ac], XmNnumImportTargets, t);    ac++;
	XtSetArg(al[ac], XmNdragOperations, XmDROP_COPY); ac++;
	XtSetArg(al[ac], XmNdropProc, DropProcCallback); ac++;

	XmDropSiteRegister(w, al,ac);
	XtVaSetValues(w,XmNuserData,d,0);

	// Register clip window as well

	Widget clip, scroll;
	if(clip = XtParent(w))
		if(scroll = XtParent(clip))
			if(XmIsScrolledWindow(scroll))
			{
				XmDropSiteRegister(clip, al,ac);
				XtVaSetValues(clip,XmNuserData,d,0);
			}
}

void MotifDrop::removeSite(DropSite* s)
{
	// Should do something here
}
