/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ARRAYP_H
#define ARRAYP_H

#include <Xm/XmP.h>
#include <Xm/DrawingAP.h>

typedef struct _ArrayClassPart {
    int         ignore;
} ArrayClassPart;

typedef struct _ArrayClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    XmManagerClassPart  manager_class;
    XmDrawingAreaClassPart  drawing_area_class;
    ArrayClassPart     array_class;
} ArrayClassRec;

extern ArrayClassRec arrayClassRec;

typedef struct {
	int round;
	int rows;
	int cols;
} ArrayPart;


typedef struct _ArrayRec {
    CorePart        core;
    CompositePart   composite;
    ConstraintPart  constraint;
    XmManagerPart    manager;
    XmDrawingAreaPart   drawing_area;
    ArrayPart      array;
}  ArrayRec;


#define XtArrayNumChildren(w) (((ArrayWidget)w) -> composite.num_children)
#define XtArrayChild(w,i)     (((ArrayWidget)w) -> composite.children[i])

#endif /* ARRAYP_H */



