/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .NAME:
//  AnnotationView
//
// .AUTHOR:
//  Fernando Ii
//
// .SUMMARY:
//  Describes the AnnotationView class, which plots text and images
//
// .CLIENTS:
//  Page
//
// .RESPONSIBILITY:
//
// .COLLABORATORS:
//
// .ASCENDENT:
//  PlotModView, PlotModTable
//
// .DESCENDENT:
//
//
//
#ifndef AnnotationView_H
#define AnnotationView_H

#include "PlotModView.h"

class AnnotationView: public PlotModView
{
public:

  // -- Constructors
  AnnotationView( Page&, const MvRequest&, const MvRequest&,
                  const string &viewName  = "annotationview");

  AnnotationView(const AnnotationView&);
  virtual PlotModView *Clone() const { return new AnnotationView(*this); }

  // -- Destructor
  ~AnnotationView() {}

  // --  Methods overriden from PlotModView class
  virtual string Name();

  // Update the current view
  virtual void UpdateView ( MvRequest& ) {}
  virtual bool UpdateView ();

  // Decode the data Unit
  virtual void DecodeDataUnit ( MvIcon& ) {}

  // Draw the background
  virtual void DrawBackground ( ) {}
  //virtual bool EmptyShared() { return false; }

  // Draw the foreground
  virtual void DrawForeground ( ) {}

  // Describe the contents of the view
  virtual void DescribeYourself ( ObjectInfo& );

  // Process the drop request
  void Drop ( PmContext& context );

  MvIconList InsertDataRequest ( MvRequest& ) { return MvIconList(); }

protected:

  string viewName_;

private:

  // No assignment
  AnnotationView& operator=(const AnnotationView&);
};
#endif
