/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .NAME:
//  ThermoView
//
// .AUTHOR:
//  Fernando Ii    Apr-2014
//
// .SUMMARY:
//  Describes the ThermoView class, which handles the
//  matching issues related to the Thermo View
//
// .CLIENTS:
//  DropAction
//
// .RESPONSIBILITY:
//
//  - When receiving a drop or a request in a page associated
//    to a service view, call the service to process the request
//
//  - When the application is finished, pass the request sent
//    by the application to the presentable, which then should
//    perform the data matching
//
// .COLLABORATORS:
//  MvRequest - extracts information from the request
//  MvTask    - communication with METVIEW modules
//
// .DESCENDENT:
//
// .RELATED:
//  Presentable, SuperPage, Page, DataObject
//
// .ASCENDENT:
// CommonXSectView
//

#ifndef ThermoView_H
#define ThermoView_H

#include "CommonXSectView.h"

//---------------------------------------------------------------------
// ThermoView factory definition
class ThermoViewFactory : public PlotModViewFactory
{
    // --  Virtual Constructor - Builds a new ThermoView
    virtual PlotModView* Build(Page&, const MvRequest&, const MvRequest&);

public:
    // Constructors
    ThermoViewFactory() :
        PlotModViewFactory("ThermoView") {}
};

//---------------------------------------------------------------------
// ThermoView class definition
class ThermoView : public CommonXSectView
{
public:
    // -- Constructors
    ThermoView(Page&, const MvRequest&, const MvRequest&);
    ThermoView(const ThermoView&);
    virtual PlotModView* Clone() const { return new ThermoView(*this); }

    // -- Destructor
    ~ThermoView() {}

    // -- Methods
    // -- Overriden from CommonXSectView class
    virtual string Name();

    // Draw the background (axis )
    virtual void DrawBackground() {}

    // Describe the contents of the view
    virtual void DescribeYourself(ObjectInfo&);

    // Initialize some variable members
    virtual void SetVariables(const MvRequest&, bool);

    // Update view
    bool UpdateView();
    bool UpdateView(MvRequest&);

    // Update thermo grid
    void UpdateThermoGrid(MvRequest&);

    // Process a drop
    void Drop(PmContext&);

    // Check parameters consistency
    bool ConsistencyCheck(MvRequest&, MvRequest&, string&);

private:
    // No assignment
    ThermoView& operator=(const ThermoView&);

    void ApplicationInfo(const MvRequest&);

    bool SetThermoType(MvRequest&);

    // Variable members
    string type_;  // Tephigram, SkewT, Emagram
};

#endif
