/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit http://www.gnu.org/copyleft/gpl.html

   class definition for the packet extensions

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

#ifndef MTX_PACKET_EXTENSIONS_H
#define MTX_PACKET_EXTENSIONS_H

#include "common/common_pch.h"

#include <deque>

#include "merge/packet.h"

class multiple_timecodes_packet_extension_c: public packet_extension_c {
protected:
  std::deque<int64_t> m_timecodes;
  std::deque<int64_t> m_positions;

public:
  multiple_timecodes_packet_extension_c() {
  }

  virtual ~multiple_timecodes_packet_extension_c() {
  }

  virtual packet_extension_type_e get_type() const {
    return MULTIPLE_TIMECODES;
  }

  inline void add(int64_t timecode, int64_t position) {
    m_timecodes.push_back(timecode);
    m_positions.push_back(position);
  }

  inline bool empty() {
    return m_timecodes.empty();
  }

  inline bool get_next(int64_t &timecode, int64_t &position) {
    if (m_timecodes.empty())
      return false;

    timecode = m_timecodes.front();
    position = m_positions.front();

    m_timecodes.pop_front();
    m_positions.pop_front();

    return true;
  }
};

using multiple_timecodes_packet_extension_cptr = std::shared_ptr<multiple_timecodes_packet_extension_c>;

class subtitle_number_packet_extension_c: public packet_extension_c {
private:
  unsigned int m_number;

public:
  subtitle_number_packet_extension_c(unsigned int number)
    : m_number(number)
  {
  }

  virtual packet_extension_type_e get_type() const {
    return SUBTITLE_NUMBER;
  }

  unsigned int get_number() {
    return m_number;
  }
};

using subtitle_number_packet_extension_cptr = std::shared_ptr<subtitle_number_packet_extension_c>;

class before_adding_to_cluster_cb_packet_extension_c: public packet_extension_c {
public:
  using callback_t = std::function<void(packet_cptr const &, int64_t)>;

private:
  callback_t m_callback;

public:
  before_adding_to_cluster_cb_packet_extension_c(callback_t const &callback)
    : m_callback{callback}
  {
  }

  virtual packet_extension_type_e get_type() const {
    return BEFORE_ADDING_TO_CLUSTER_CB;
  }

  callback_t get_callback() const {
    return m_callback;
  }
};

using before_adding_to_cluster_cb_packet_extension_cptr = std::shared_ptr<before_adding_to_cluster_cb_packet_extension_c>;

#endif  // MTX_PACKET_EXTENSIONS_H
