/* This file generated from tools/Generate-Collation-Data.raku */
struct collation_key {
    MVMuint32 primary :16;
    MVMuint32 tertiary :5;
    MVMuint32 special :1;
    MVMuint32 secondary :9;
};
struct sub_node {
    MVMuint32 codepoint :18;
    MVMuint32 collation_key_link :14;
    MVMuint32 sub_node_link :13;
    MVMuint32 sub_node_elems :13;
    MVMuint32 collation_key_elems :5;
};
typedef struct sub_node sub_node;
#define main_nodes_elems 4793
#define starter_main_nodes_elems 3829
#define codepoint_sequence_no_max 3
#define special_collation_keys_elems 10631
/* Data from PropList.txt */
MVM_STATIC_INLINE MVMuint32 is_unified_ideograph (MVMCodepoint cp) {
    return
       (0x3400  <= cp && cp <= 0x4DBF ) /* 3400..4DBF Unified_Ideograph # Lo [6592] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DBF */
    || (0x4E00  <= cp && cp <= 0x9FFC ) /* 4E00..9FFC Unified_Ideograph # Lo [20989] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FFC */
    || (0xFA0E  <= cp && cp <= 0xFA0F ) /* FA0E..FA0F Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA0E..CJK COMPATIBILITY IDEOGRAPH-FA0F */
    || (0xFA11                   == cp) /* FA11..FA11 Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA11 */
    || (0xFA13  <= cp && cp <= 0xFA14 ) /* FA13..FA14 Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA13..CJK COMPATIBILITY IDEOGRAPH-FA14 */
    || (0xFA1F                   == cp) /* FA1F..FA1F Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA1F */
    || (0xFA21                   == cp) /* FA21..FA21 Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA21 */
    || (0xFA23  <= cp && cp <= 0xFA24 ) /* FA23..FA24 Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA23..CJK COMPATIBILITY IDEOGRAPH-FA24 */
    || (0xFA27  <= cp && cp <= 0xFA29 ) /* FA27..FA29 Unified_Ideograph # Lo   [3] CJK COMPATIBILITY IDEOGRAPH-FA27..CJK COMPATIBILITY IDEOGRAPH-FA29 */
    || (0x20000 <= cp && cp <= 0x2A6DD) /* 20000..2A6DD Unified_Ideograph # Lo [42718] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6DD */
    || (0x2A700 <= cp && cp <= 0x2B734) /* 2A700..2B734 Unified_Ideograph # Lo [4149] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B734 */
    || (0x2B740 <= cp && cp <= 0x2B81D) /* 2B740..2B81D Unified_Ideograph # Lo [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D */
    || (0x2B820 <= cp && cp <= 0x2CEA1) /* 2B820..2CEA1 Unified_Ideograph # Lo [5762] CJK UNIFIED IDEOGRAPH-2B820..CJK UNIFIED IDEOGRAPH-2CEA1 */
    || (0x2CEB0 <= cp && cp <= 0x2EBE0) /* 2CEB0..2EBE0 Unified_Ideograph # Lo [7473] CJK UNIFIED IDEOGRAPH-2CEB0..CJK UNIFIED IDEOGRAPH-2EBE0 */
    || (0x30000 <= cp && cp <= 0x3134A) /* 30000..3134A Unified_Ideograph # Lo [4939] CJK UNIFIED IDEOGRAPH-30000..CJK UNIFIED IDEOGRAPH-3134A */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Assigned_Block_Nushu (MVMCodepoint cp) {
    return
       (0x1B170 <= cp && cp <= 0x1B2FF) /* 1B170..1B2FF Nushu                              */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Block_Tangut (MVMCodepoint cp) {
    return
       (0x17000 <= cp && cp <= 0x187FF) /* 17000..187FF Tangut                             */
    || (0x18800 <= cp && cp <= 0x18AFF) /* 18800..18AFF Tangut Components                  */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Block_CJK_Unified_Ideographs_OR_CJK_Compatibility_Ideographs (MVMCodepoint cp) {
    return
       (0x4E00  <= cp && cp <= 0x9FFF ) /* 4E00..9FFF CJK Unified Ideographs             */
    || (0xF900  <= cp && cp <= 0xFAFF ) /* F900..FAFF CJK Compatibility Ideographs       */
    ;
}

sub_node main_nodes[4793] = {
{76,0,3829,1,0},{108,0,3830,1,0},{188,4,0,0,3},{189,7,0,0,3},{190,10,0,0,3},
{192,13,0,0,2},{193,15,0,0,2},{194,17,0,0,2},{195,19,0,0,2},{196,21,0,0,2},{197,
23,0,0,2},{198,25,0,0,3},{199,28,0,0,2},{200,30,0,0,2},{201,32,0,0,2},{202,34,0,
0,2},{203,36,0,0,2},{204,38,0,0,2},{205,40,0,0,2},{206,42,0,0,2},{207,44,0,0,2},
{208,46,0,0,2},{209,48,0,0,2},{210,50,0,0,2},{211,52,0,0,2},{212,54,0,0,2},{213,
56,0,0,2},{214,58,0,0,2},{216,60,0,0,2},{217,62,0,0,2},{218,64,0,0,2},{219,66,0,
0,2},{220,68,0,0,2},{221,70,0,0,2},{223,72,0,0,3},{224,75,0,0,2},{225,77,0,0,2},
{226,79,0,0,2},{227,81,0,0,2},{228,83,0,0,2},{229,85,0,0,2},{230,87,0,0,3},{231,
90,0,0,2},{232,92,0,0,2},{233,94,0,0,2},{234,96,0,0,2},{235,98,0,0,2},{236,100,
0,0,2},{237,102,0,0,2},{238,104,0,0,2},{239,106,0,0,2},{240,108,0,0,2},{241,110,
0,0,2},{242,112,0,0,2},{243,114,0,0,2},{244,116,0,0,2},{245,118,0,0,2},{246,120,
0,0,2},{248,122,0,0,2},{249,124,0,0,2},{250,126,0,0,2},{251,128,0,0,2},{252,130,
0,0,2},{253,132,0,0,2},{255,134,0,0,2},{256,136,0,0,2},{257,138,0,0,2},{258,140,
0,0,2},{259,142,0,0,2},{260,144,0,0,2},{261,146,0,0,2},{262,148,0,0,2},{263,150,
0,0,2},{264,152,0,0,2},{265,154,0,0,2},{266,156,0,0,2},{267,158,0,0,2},{268,160,
0,0,2},{269,162,0,0,2},{270,164,0,0,2},{271,166,0,0,2},{272,168,0,0,2},{273,170,
0,0,2},{274,172,0,0,2},{275,174,0,0,2},{276,176,0,0,2},{277,178,0,0,2},{278,180,
0,0,2},{279,182,0,0,2},{280,184,0,0,2},{281,186,0,0,2},{282,188,0,0,2},{283,190,
0,0,2},{284,192,0,0,2},{285,194,0,0,2},{286,196,0,0,2},{287,198,0,0,2},{288,200,
0,0,2},{289,202,0,0,2},{290,204,0,0,2},{291,206,0,0,2},{292,208,0,0,2},{293,210,
0,0,2},{294,212,0,0,2},{295,214,0,0,2},{296,216,0,0,2},{297,218,0,0,2},{298,220,
0,0,2},{299,222,0,0,2},{300,224,0,0,2},{301,226,0,0,2},{302,228,0,0,2},{303,230,
0,0,2},{304,232,0,0,2},{306,234,0,0,2},{307,236,0,0,2},{308,238,0,0,2},{309,240,
0,0,2},{310,242,0,0,2},{311,244,0,0,2},{313,246,0,0,2},{314,248,0,0,2},{315,250,
0,0,2},{316,252,0,0,2},{317,254,0,0,2},{318,256,0,0,2},{319,258,0,0,2},{320,260,
0,0,2},{321,262,0,0,2},{322,264,0,0,2},{323,266,0,0,2},{324,268,0,0,2},{325,270,
0,0,2},{326,272,0,0,2},{327,274,0,0,2},{328,276,0,0,2},{329,278,0,0,2},{332,280,
0,0,2},{333,282,0,0,2},{334,284,0,0,2},{335,286,0,0,2},{336,288,0,0,2},{337,290,
0,0,2},{338,292,0,0,3},{339,295,0,0,3},{340,298,0,0,2},{341,300,0,0,2},{342,302,
0,0,2},{343,304,0,0,2},{344,306,0,0,2},{345,308,0,0,2},{346,310,0,0,2},{347,312,
0,0,2},{348,314,0,0,2},{349,316,0,0,2},{350,318,0,0,2},{351,320,0,0,2},{352,322,
0,0,2},{353,324,0,0,2},{354,326,0,0,2},{355,328,0,0,2},{356,330,0,0,2},{357,332,
0,0,2},{360,334,0,0,2},{361,336,0,0,2},{362,338,0,0,2},{363,340,0,0,2},{364,342,
0,0,2},{365,344,0,0,2},{366,346,0,0,2},{367,348,0,0,2},{368,350,0,0,2},{369,352,
0,0,2},{370,354,0,0,2},{371,356,0,0,2},{372,358,0,0,2},{373,360,0,0,2},{374,362,
0,0,2},{375,364,0,0,2},{376,366,0,0,2},{377,368,0,0,2},{378,370,0,0,2},{379,372,
0,0,2},{380,374,0,0,2},{381,376,0,0,2},{382,378,0,0,2},{383,380,0,0,2},{397,382,
0,0,2},{416,384,0,0,2},{417,386,0,0,2},{431,388,0,0,2},{432,390,0,0,2},{446,392,
0,0,2},{452,394,0,0,3},{453,397,0,0,3},{454,400,0,0,3},{455,403,0,0,2},{456,405,
0,0,2},{457,407,0,0,2},{458,409,0,0,2},{459,411,0,0,2},{460,413,0,0,2},{461,415,
0,0,2},{462,417,0,0,2},{463,419,0,0,2},{464,421,0,0,2},{465,423,0,0,2},{466,425,
0,0,2},{467,427,0,0,2},{468,429,0,0,2},{469,431,0,0,3},{470,434,0,0,3},{471,437,
0,0,3},{472,440,0,0,3},{473,443,0,0,3},{474,446,0,0,3},{475,449,0,0,3},{476,452,
0,0,3},{478,455,0,0,3},{479,458,0,0,3},{480,461,0,0,3},{481,464,0,0,3},{482,467,
0,0,4},{483,471,0,0,4},{486,475,0,0,2},{487,477,0,0,2},{488,479,0,0,2},{489,481,
0,0,2},{490,483,0,0,2},{491,485,0,0,2},{492,487,0,0,3},{493,490,0,0,3},{494,493,
0,0,2},{495,495,0,0,2},{496,497,0,0,2},{497,499,0,0,2},{498,501,0,0,2},{499,503,
0,0,2},{500,505,0,0,2},{501,507,0,0,2},{504,509,0,0,2},{505,511,0,0,2},{506,513,
0,0,3},{507,516,0,0,3},{508,519,0,0,4},{509,523,0,0,4},{510,527,0,0,3},{511,530,
0,0,3},{512,533,0,0,2},{513,535,0,0,2},{514,537,0,0,2},{515,539,0,0,2},{516,541,
0,0,2},{517,543,0,0,2},{518,545,0,0,2},{519,547,0,0,2},{520,549,0,0,2},{521,551,
0,0,2},{522,553,0,0,2},{523,555,0,0,2},{524,557,0,0,2},{525,559,0,0,2},{526,561,
0,0,2},{527,563,0,0,2},{528,565,0,0,2},{529,567,0,0,2},{530,569,0,0,2},{531,571,
0,0,2},{532,573,0,0,2},{533,575,0,0,2},{534,577,0,0,2},{535,579,0,0,2},{536,581,
0,0,2},{537,583,0,0,2},{538,585,0,0,2},{539,587,0,0,2},{542,589,0,0,2},{543,591,
0,0,2},{550,593,0,0,2},{551,595,0,0,2},{552,597,0,0,2},{553,599,0,0,2},{554,601,
0,0,3},{555,604,0,0,3},{556,607,0,0,3},{557,610,0,0,3},{558,613,0,0,2},{559,615,
0,0,2},{560,617,0,0,3},{561,620,0,0,3},{562,623,0,0,2},{563,625,0,0,2},{568,627,
0,0,2},{569,629,0,0,2},{675,631,0,0,2},{676,633,0,0,2},{677,635,0,0,2},{678,637,
0,0,2},{679,639,0,0,2},{680,641,0,0,2},{681,643,0,0,2},{682,645,0,0,2},{683,647,
0,0,2},{776,0,3831,1,0},{901,651,0,0,2},{902,653,0,0,2},{904,655,0,0,2},{905,
657,0,0,2},{906,659,0,0,2},{908,661,0,0,2},{910,663,0,0,2},{911,665,0,0,2},{912,
667,0,0,3},{938,670,0,0,2},{939,672,0,0,2},{940,674,0,0,2},{941,676,0,0,2},{942,
678,0,0,2},{943,680,0,0,2},{944,682,0,0,3},{970,685,0,0,2},{971,687,0,0,2},{972,
689,0,0,2},{973,691,0,0,2},{974,693,0,0,2},{975,695,0,0,3},{979,698,0,0,2},{980,
700,0,0,2},{983,702,0,0,3},{1024,705,0,0,2},{1025,707,0,0,2},{1027,709,0,0,2},
{1031,711,0,0,2},{1036,713,0,0,2},{1037,715,0,0,2},{1038,717,0,0,2},{1104,719,0,
0,2},{1105,721,0,0,2},{1107,723,0,0,2},{1111,725,0,0,2},{1116,727,0,0,2},{1117,
729,0,0,2},{1118,731,0,0,2},{1142,733,0,0,2},{1143,735,0,0,2},{1168,737,0,0,2},
{1169,739,0,0,2},{1217,741,0,0,2},{1218,743,0,0,2},{1232,745,0,0,2},{1233,747,0,
0,2},{1234,749,0,0,2},{1235,751,0,0,2},{1238,753,0,0,2},{1239,755,0,0,2},{1242,
757,0,0,2},{1243,759,0,0,2},{1244,761,0,0,2},{1245,763,0,0,2},{1246,765,0,0,2},
{1247,767,0,0,2},{1250,769,0,0,2},{1251,771,0,0,2},{1252,773,0,0,2},{1253,775,0,
0,2},{1254,777,0,0,2},{1255,779,0,0,2},{1258,781,0,0,2},{1259,783,0,0,2},{1260,
785,0,0,2},{1261,787,0,0,2},{1262,789,0,0,2},{1263,791,0,0,2},{1264,793,0,0,2},
{1265,795,0,0,2},{1266,797,0,0,2},{1267,799,0,0,2},{1268,801,0,0,2},{1269,803,0,
0,2},{1272,805,0,0,2},{1273,807,0,0,2},{1415,809,0,0,2},{1488,0,3832,3,0},{1489,
0,3835,2,0},{1490,0,3837,1,0},{1491,0,3838,1,0},{1492,0,3839,1,0},{1493,0,3840,
2,0},{1494,0,3842,1,0},{1496,0,3843,1,0},{1497,0,3844,2,0},{1498,0,3846,1,0},
{1499,0,3847,2,0},{1500,0,3849,1,0},{1502,0,3850,1,0},{1504,0,3851,1,0},{1505,0,
3852,1,0},{1507,0,3853,1,0},{1508,0,3854,2,0},{1510,0,3856,1,0},{1511,0,3857,1,
0},{1512,0,3858,1,0},{1513,0,3859,3,0},{1514,0,3864,1,0},{1519,879,0,0,4},{1520,
883,0,0,2},{1521,885,0,0,2},{1522,887,3865,1,2},{1653,892,0,0,2},{1654,894,0,0,
2},{1655,896,0,0,2},{1656,898,0,0,2},{1728,900,0,0,2},{1730,902,0,0,2},{1747,
904,0,0,2},{1789,906,0,0,2},{1790,908,0,0,2},{1812,910,0,0,2},{1820,912,0,0,2},
{1831,914,0,0,2},{1837,916,0,0,2},{1838,918,0,0,2},{1839,920,0,0,2},{2024,922,0,
0,2},{2025,924,0,0,2},{2026,926,0,0,2},{2325,0,3866,1,0},{2326,0,3867,1,0},
{2327,0,3868,1,0},{2332,0,3869,1,0},{2337,0,3870,1,0},{2338,0,3871,1,0},{2345,
940,0,0,2},{2347,0,3872,1,0},{2351,0,3873,1,0},{2353,946,0,0,2},{2356,948,0,0,
2},{2465,0,3874,1,0},{2466,0,3875,1,0},{2479,0,3876,1,0},{2510,956,0,0,2},{2582,
0,3877,1,0},{2583,0,3878,1,0},{2588,0,3879,1,0},{2603,0,3880,1,0},{2610,0,3881,
1,0},{2616,0,3882,1,0},{2849,0,3883,1,0},{2850,0,3884,1,0},{3406,974,0,0,2},
{3412,976,0,0,2},{3413,978,0,0,2},{3414,980,0,0,2},{3450,982,0,0,2},{3451,984,0,
0,2},{3452,986,0,0,2},{3453,988,0,0,2},{3454,990,0,0,2},{3455,992,0,0,2},{3648,
0,3885,46,0},{3649,0,3931,46,0},{3650,0,3977,46,0},{3651,0,4023,46,0},{3652,0,
4069,46,0},{3661,0,4115,1,0},{3776,0,4116,45,0},{3777,0,4161,45,0},{3778,0,4206,
45,0},{3779,0,4251,45,0},{3780,0,4296,45,0},{3789,0,4341,1,0},{3804,1916,0,0,2},
{3805,1918,0,0,2},{3840,1920,0,0,3},{3904,0,4342,1,0},{3906,0,4343,1,0},{3916,0,
4344,1,0},{3921,0,4345,1,0},{3926,0,4346,1,0},{3931,0,4347,1,0},{3946,1935,0,0,
2},{3953,0,4348,3,0},{3984,0,4351,1,0},{3986,0,4352,1,0},{3996,0,4353,1,0},
{4001,0,4354,1,0},{4006,0,4355,1,0},{4011,0,4356,1,0},{4018,0,4357,2,0},{4019,0,
4360,2,0},{4026,1956,0,0,2},{4027,1958,0,0,2},{4028,1960,0,0,2},{4159,1962,0,0,
3},{5793,1965,0,0,2},{5796,1967,0,0,2},{5797,1969,0,0,2},{5799,1971,0,0,2},
{5801,1973,0,0,2},{5804,1975,0,0,2},{5805,1977,0,0,2},{5806,1979,0,0,2},{5811,
1981,0,0,2},{5812,1983,0,0,2},{5813,1985,0,0,2},{5814,1987,0,0,2},{5819,1989,0,
0,2},{5820,1991,0,0,2},{5821,1993,0,0,2},{5823,1995,0,0,2},{5824,1997,0,0,2},
{5826,1999,0,0,2},{5828,2001,0,0,2},{5830,2003,0,0,2},{5835,2005,0,0,2},{5836,
2007,0,0,2},{5837,2009,0,0,2},{5838,2011,0,0,2},{5840,2013,0,0,2},{5841,2015,0,
0,2},{5843,2017,0,0,2},{5844,2019,0,0,2},{5845,2021,0,0,2},{5848,2023,0,0,2},
{5849,2025,0,0,2},{5851,2027,0,0,2},{5853,2029,0,0,2},{5863,2031,0,0,2},{5864,
2033,0,0,2},{5865,2035,0,0,2},{5866,2037,0,0,2},{5870,2039,0,0,2},{5871,2041,0,
0,4},{5872,2045,0,0,2},{6429,2047,0,0,2},{6430,2049,0,0,2},{6581,0,4363,44,0},
{6582,0,4407,44,0},{6583,0,4451,44,0},{6586,0,4495,44,0},{6622,2403,0,0,2},
{6623,2405,0,0,3},{6740,2408,0,0,3},{7469,2411,0,0,3},{7545,2414,0,0,2},{7546,
2416,0,0,3},{7582,2419,0,0,2},{7635,2421,0,0,2},{7636,2423,0,0,3},{7637,2426,0,
0,2},{7638,2428,0,0,2},{7639,2430,0,0,2},{7640,2432,0,0,2},{7641,2434,0,0,2},
{7653,2436,0,0,2},{7661,2438,0,0,2},{7664,2440,0,0,2},{7666,2442,0,0,2},{7667,
2444,0,0,2},{7668,2446,0,0,2},{7680,2448,0,0,2},{7681,2450,0,0,2},{7682,2452,0,
0,2},{7683,2454,0,0,2},{7684,2456,0,0,2},{7685,2458,0,0,2},{7686,2460,0,0,2},
{7687,2462,0,0,2},{7688,2464,0,0,3},{7689,2467,0,0,3},{7690,2470,0,0,2},{7691,
2472,0,0,2},{7692,2474,0,0,2},{7693,2476,0,0,2},{7694,2478,0,0,2},{7695,2480,0,
0,2},{7696,2482,0,0,2},{7697,2484,0,0,2},{7698,2486,0,0,2},{7699,2488,0,0,2},
{7700,2490,0,0,3},{7701,2493,0,0,3},{7702,2496,0,0,3},{7703,2499,0,0,3},{7704,
2502,0,0,2},{7705,2504,0,0,2},{7706,2506,0,0,2},{7707,2508,0,0,2},{7708,2510,0,
0,3},{7709,2513,0,0,3},{7710,2516,0,0,2},{7711,2518,0,0,2},{7712,2520,0,0,2},
{7713,2522,0,0,2},{7714,2524,0,0,2},{7715,2526,0,0,2},{7716,2528,0,0,2},{7717,
2530,0,0,2},{7718,2532,0,0,2},{7719,2534,0,0,2},{7720,2536,0,0,2},{7721,2538,0,
0,2},{7722,2540,0,0,2},{7723,2542,0,0,2},{7724,2544,0,0,2},{7725,2546,0,0,2},
{7726,2548,0,0,3},{7727,2551,0,0,3},{7728,2554,0,0,2},{7729,2556,0,0,2},{7730,
2558,0,0,2},{7731,2560,0,0,2},{7732,2562,0,0,2},{7733,2564,0,0,2},{7734,2566,0,
0,2},{7735,2568,0,0,2},{7736,2570,0,0,3},{7737,2573,0,0,3},{7738,2576,0,0,2},
{7739,2578,0,0,2},{7740,2580,0,0,2},{7741,2582,0,0,2},{7742,2584,0,0,2},{7743,
2586,0,0,2},{7744,2588,0,0,2},{7745,2590,0,0,2},{7746,2592,0,0,2},{7747,2594,0,
0,2},{7748,2596,0,0,2},{7749,2598,0,0,2},{7750,2600,0,0,2},{7751,2602,0,0,2},
{7752,2604,0,0,2},{7753,2606,0,0,2},{7754,2608,0,0,2},{7755,2610,0,0,2},{7756,
2612,0,0,3},{7757,2615,0,0,3},{7758,2618,0,0,3},{7759,2621,0,0,3},{7760,2624,0,
0,3},{7761,2627,0,0,3},{7762,2630,0,0,3},{7763,2633,0,0,3},{7764,2636,0,0,2},
{7765,2638,0,0,2},{7766,2640,0,0,2},{7767,2642,0,0,2},{7768,2644,0,0,2},{7769,
2646,0,0,2},{7770,2648,0,0,2},{7771,2650,0,0,2},{7772,2652,0,0,3},{7773,2655,0,
0,3},{7774,2658,0,0,2},{7775,2660,0,0,2},{7776,2662,0,0,2},{7777,2664,0,0,2},
{7778,2666,0,0,2},{7779,2668,0,0,2},{7780,2670,0,0,3},{7781,2673,0,0,3},{7782,
2676,0,0,3},{7783,2679,0,0,3},{7784,2682,0,0,3},{7785,2685,0,0,3},{7786,2688,0,
0,2},{7787,2690,0,0,2},{7788,2692,0,0,2},{7789,2694,0,0,2},{7790,2696,0,0,2},
{7791,2698,0,0,2},{7792,2700,0,0,2},{7793,2702,0,0,2},{7794,2704,0,0,2},{7795,
2706,0,0,2},{7796,2708,0,0,2},{7797,2710,0,0,2},{7798,2712,0,0,2},{7799,2714,0,
0,2},{7800,2716,0,0,3},{7801,2719,0,0,3},{7802,2722,0,0,3},{7803,2725,0,0,3},
{7804,2728,0,0,2},{7805,2730,0,0,2},{7806,2732,0,0,2},{7807,2734,0,0,2},{7808,
2736,0,0,2},{7809,2738,0,0,2},{7810,2740,0,0,2},{7811,2742,0,0,2},{7812,2744,0,
0,2},{7813,2746,0,0,2},{7814,2748,0,0,2},{7815,2750,0,0,2},{7816,2752,0,0,2},
{7817,2754,0,0,2},{7818,2756,0,0,2},{7819,2758,0,0,2},{7820,2760,0,0,2},{7821,
2762,0,0,2},{7822,2764,0,0,2},{7823,2766,0,0,2},{7824,2768,0,0,2},{7825,2770,0,
0,2},{7826,2772,0,0,2},{7827,2774,0,0,2},{7828,2776,0,0,2},{7829,2778,0,0,2},
{7830,2780,0,0,2},{7831,2782,0,0,2},{7832,2784,0,0,2},{7833,2786,0,0,2},{7834,
2788,0,0,2},{7835,2790,0,0,3},{7838,2793,0,0,3},{7840,2796,0,0,2},{7841,2798,0,
0,2},{7842,2800,0,0,2},{7843,2802,0,0,2},{7844,2804,0,0,3},{7845,2807,0,0,3},
{7846,2810,0,0,3},{7847,2813,0,0,3},{7848,2816,0,0,3},{7849,2819,0,0,3},{7850,
2822,0,0,3},{7851,2825,0,0,3},{7852,2828,0,0,3},{7853,2831,0,0,3},{7854,2834,0,
0,3},{7855,2837,0,0,3},{7856,2840,0,0,3},{7857,2843,0,0,3},{7858,2846,0,0,3},
{7859,2849,0,0,3},{7860,2852,0,0,3},{7861,2855,0,0,3},{7862,2858,0,0,3},{7863,
2861,0,0,3},{7864,2864,0,0,2},{7865,2866,0,0,2},{7866,2868,0,0,2},{7867,2870,0,
0,2},{7868,2872,0,0,2},{7869,2874,0,0,2},{7870,2876,0,0,3},{7871,2879,0,0,3},
{7872,2882,0,0,3},{7873,2885,0,0,3},{7874,2888,0,0,3},{7875,2891,0,0,3},{7876,
2894,0,0,3},{7877,2897,0,0,3},{7878,2900,0,0,3},{7879,2903,0,0,3},{7880,2906,0,
0,2},{7881,2908,0,0,2},{7882,2910,0,0,2},{7883,2912,0,0,2},{7884,2914,0,0,2},
{7885,2916,0,0,2},{7886,2918,0,0,2},{7887,2920,0,0,2},{7888,2922,0,0,3},{7889,
2925,0,0,3},{7890,2928,0,0,3},{7891,2931,0,0,3},{7892,2934,0,0,3},{7893,2937,0,
0,3},{7894,2940,0,0,3},{7895,2943,0,0,3},{7896,2946,0,0,3},{7897,2949,0,0,3},
{7898,2952,0,0,3},{7899,2955,0,0,3},{7900,2958,0,0,3},{7901,2961,0,0,3},{7902,
2964,0,0,3},{7903,2967,0,0,3},{7904,2970,0,0,3},{7905,2973,0,0,3},{7906,2976,0,
0,3},{7907,2979,0,0,3},{7908,2982,0,0,2},{7909,2984,0,0,2},{7910,2986,0,0,2},
{7911,2988,0,0,2},{7912,2990,0,0,3},{7913,2993,0,0,3},{7914,2996,0,0,3},{7915,
2999,0,0,3},{7916,3002,0,0,3},{7917,3005,0,0,3},{7918,3008,0,0,3},{7919,3011,0,
0,3},{7920,3014,0,0,3},{7921,3017,0,0,3},{7922,3020,0,0,2},{7923,3022,0,0,2},
{7924,3024,0,0,2},{7925,3026,0,0,2},{7926,3028,0,0,2},{7927,3030,0,0,2},{7928,
3032,0,0,2},{7929,3034,0,0,2},{7930,3036,0,0,2},{7931,3038,0,0,2},{7936,3040,0,
0,2},{7937,3042,0,0,2},{7938,3044,0,0,3},{7939,3047,0,0,3},{7940,3050,0,0,3},
{7941,3053,0,0,3},{7942,3056,0,0,3},{7943,3059,0,0,3},{7944,3062,0,0,2},{7945,
3064,0,0,2},{7946,3066,0,0,3},{7947,3069,0,0,3},{7948,3072,0,0,3},{7949,3075,0,
0,3},{7950,3078,0,0,3},{7951,3081,0,0,3},{7952,3084,0,0,2},{7953,3086,0,0,2},
{7954,3088,0,0,3},{7955,3091,0,0,3},{7956,3094,0,0,3},{7957,3097,0,0,3},{7960,
3100,0,0,2},{7961,3102,0,0,2},{7962,3104,0,0,3},{7963,3107,0,0,3},{7964,3110,0,
0,3},{7965,3113,0,0,3},{7968,3116,0,0,2},{7969,3118,0,0,2},{7970,3120,0,0,3},
{7971,3123,0,0,3},{7972,3126,0,0,3},{7973,3129,0,0,3},{7974,3132,0,0,3},{7975,
3135,0,0,3},{7976,3138,0,0,2},{7977,3140,0,0,2},{7978,3142,0,0,3},{7979,3145,0,
0,3},{7980,3148,0,0,3},{7981,3151,0,0,3},{7982,3154,0,0,3},{7983,3157,0,0,3},
{7984,3160,0,0,2},{7985,3162,0,0,2},{7986,3164,0,0,3},{7987,3167,0,0,3},{7988,
3170,0,0,3},{7989,3173,0,0,3},{7990,3176,0,0,3},{7991,3179,0,0,3},{7992,3182,0,
0,2},{7993,3184,0,0,2},{7994,3186,0,0,3},{7995,3189,0,0,3},{7996,3192,0,0,3},
{7997,3195,0,0,3},{7998,3198,0,0,3},{7999,3201,0,0,3},{8000,3204,0,0,2},{8001,
3206,0,0,2},{8002,3208,0,0,3},{8003,3211,0,0,3},{8004,3214,0,0,3},{8005,3217,0,
0,3},{8008,3220,0,0,2},{8009,3222,0,0,2},{8010,3224,0,0,3},{8011,3227,0,0,3},
{8012,3230,0,0,3},{8013,3233,0,0,3},{8016,3236,0,0,2},{8017,3238,0,0,2},{8018,
3240,0,0,3},{8019,3243,0,0,3},{8020,3246,0,0,3},{8021,3249,0,0,3},{8022,3252,0,
0,3},{8023,3255,0,0,3},{8025,3258,0,0,2},{8027,3260,0,0,3},{8029,3263,0,0,3},
{8031,3266,0,0,3},{8032,3269,0,0,2},{8033,3271,0,0,2},{8034,3273,0,0,3},{8035,
3276,0,0,3},{8036,3279,0,0,3},{8037,3282,0,0,3},{8038,3285,0,0,3},{8039,3288,0,
0,3},{8040,3291,0,0,2},{8041,3293,0,0,2},{8042,3295,0,0,3},{8043,3298,0,0,3},
{8044,3301,0,0,3},{8045,3304,0,0,3},{8046,3307,0,0,3},{8047,3310,0,0,3},{8048,
3313,0,0,2},{8050,3315,0,0,2},{8052,3317,0,0,2},{8054,3319,0,0,2},{8056,3321,0,
0,2},{8058,3323,0,0,2},{8060,3325,0,0,2},{8064,3327,0,0,3},{8065,3330,0,0,3},
{8066,3333,0,0,4},{8067,3337,0,0,4},{8068,3341,0,0,4},{8069,3345,0,0,4},{8070,
3349,0,0,4},{8071,3353,0,0,4},{8072,3357,0,0,3},{8073,3360,0,0,3},{8074,3363,0,
0,4},{8075,3367,0,0,4},{8076,3371,0,0,4},{8077,3375,0,0,4},{8078,3379,0,0,4},
{8079,3383,0,0,4},{8080,3387,0,0,3},{8081,3390,0,0,3},{8082,3393,0,0,4},{8083,
3397,0,0,4},{8084,3401,0,0,4},{8085,3405,0,0,4},{8086,3409,0,0,4},{8087,3413,0,
0,4},{8088,3417,0,0,3},{8089,3420,0,0,3},{8090,3423,0,0,4},{8091,3427,0,0,4},
{8092,3431,0,0,4},{8093,3435,0,0,4},{8094,3439,0,0,4},{8095,3443,0,0,4},{8096,
3447,0,0,3},{8097,3450,0,0,3},{8098,3453,0,0,4},{8099,3457,0,0,4},{8100,3461,0,
0,4},{8101,3465,0,0,4},{8102,3469,0,0,4},{8103,3473,0,0,4},{8104,3477,0,0,3},
{8105,3480,0,0,3},{8106,3483,0,0,4},{8107,3487,0,0,4},{8108,3491,0,0,4},{8109,
3495,0,0,4},{8110,3499,0,0,4},{8111,3503,0,0,4},{8112,3507,0,0,2},{8113,3509,0,
0,2},{8114,3511,0,0,3},{8115,3514,0,0,2},{8116,3516,0,0,3},{8118,3519,0,0,2},
{8119,3521,0,0,3},{8120,3524,0,0,2},{8121,3526,0,0,2},{8122,3528,0,0,2},{8124,
3530,0,0,2},{8129,3532,0,0,2},{8130,3534,0,0,3},{8131,3537,0,0,2},{8132,3539,0,
0,3},{8134,3542,0,0,2},{8135,3544,0,0,3},{8136,3547,0,0,2},{8138,3549,0,0,2},
{8140,3551,0,0,2},{8141,3553,0,0,2},{8142,3555,0,0,2},{8143,3557,0,0,2},{8144,
3559,0,0,2},{8145,3561,0,0,2},{8146,3563,0,0,3},{8150,3566,0,0,2},{8151,3568,0,
0,3},{8152,3571,0,0,2},{8153,3573,0,0,2},{8154,3575,0,0,2},{8157,3577,0,0,2},
{8158,3579,0,0,2},{8159,3581,0,0,2},{8160,3583,0,0,2},{8161,3585,0,0,2},{8162,
3587,0,0,3},{8164,3590,0,0,2},{8165,3592,0,0,2},{8166,3594,0,0,2},{8167,3596,0,
0,3},{8168,3599,0,0,2},{8169,3601,0,0,2},{8170,3603,0,0,2},{8172,3605,0,0,2},
{8173,3607,0,0,2},{8178,3609,0,0,3},{8179,3612,0,0,2},{8180,3614,0,0,3},{8182,
3617,0,0,2},{8183,3619,0,0,3},{8184,3622,0,0,2},{8186,3624,0,0,2},{8188,3626,0,
0,2},{8229,3628,0,0,2},{8230,3630,0,0,3},{8243,3633,0,0,2},{8244,3635,0,0,3},
{8246,3638,0,0,2},{8247,3640,0,0,3},{8252,3643,0,0,2},{8263,3645,0,0,2},{8264,
3647,0,0,2},{8265,3649,0,0,2},{8279,3651,0,0,4},{8360,3655,0,0,2},{8448,3657,0,
0,3},{8449,3660,0,0,3},{8451,3663,0,0,2},{8453,3665,0,0,3},{8454,3668,0,0,3},
{8457,3671,0,0,2},{8463,3673,0,0,2},{8470,3675,0,0,2},{8480,3677,0,0,2},{8481,
3679,0,0,3},{8482,3682,0,0,2},{8507,3684,0,0,3},{8525,3687,0,0,3},{8528,3690,0,
0,3},{8529,3693,0,0,3},{8530,3696,0,0,4},{8531,3700,0,0,3},{8532,3703,0,0,3},
{8533,3706,0,0,3},{8534,3709,0,0,3},{8535,3712,0,0,3},{8536,3715,0,0,3},{8537,
3718,0,0,3},{8538,3721,0,0,3},{8539,3724,0,0,3},{8540,3727,0,0,3},{8541,3730,0,
0,3},{8542,3733,0,0,3},{8543,3736,0,0,2},{8545,3738,0,0,2},{8546,3740,0,0,3},
{8547,3743,0,0,2},{8549,3745,0,0,2},{8550,3747,0,0,3},{8551,3750,0,0,4},{8552,
3754,0,0,2},{8554,3756,0,0,2},{8555,3758,0,0,3},{8561,3761,0,0,2},{8562,3763,0,
0,3},{8563,3766,0,0,2},{8565,3768,0,0,2},{8566,3770,0,0,3},{8567,3773,0,0,4},
{8568,3777,0,0,2},{8570,3779,0,0,2},{8571,3781,0,0,3},{8585,3784,0,0,3},{8602,
3787,0,0,2},{8603,3789,0,0,2},{8622,3791,0,0,2},{8653,3793,0,0,2},{8654,3795,0,
0,2},{8655,3797,0,0,2},{8708,3799,0,0,2},{8713,3801,0,0,2},{8716,3803,0,0,2},
{8740,3805,0,0,2},{8742,3807,0,0,2},{8748,3809,0,0,2},{8749,3811,0,0,3},{8751,
3814,0,0,2},{8752,3816,0,0,3},{8769,3819,0,0,2},{8772,3821,0,0,2},{8775,3823,0,
0,2},{8777,3825,0,0,2},{8800,3827,0,0,2},{8802,3829,0,0,2},{8813,3831,0,0,2},
{8814,3833,0,0,2},{8815,3835,0,0,2},{8816,3837,0,0,2},{8817,3839,0,0,2},{8820,
3841,0,0,2},{8821,3843,0,0,2},{8824,3845,0,0,2},{8825,3847,0,0,2},{8832,3849,0,
0,2},{8833,3851,0,0,2},{8836,3853,0,0,2},{8837,3855,0,0,2},{8840,3857,0,0,2},
{8841,3859,0,0,2},{8876,3861,0,0,2},{8877,3863,0,0,2},{8878,3865,0,0,2},{8879,
3867,0,0,2},{8928,3869,0,0,2},{8929,3871,0,0,2},{8930,3873,0,0,2},{8931,3875,0,
0,2},{8938,3877,0,0,2},{8939,3879,0,0,2},{8940,3881,0,0,2},{8941,3883,0,0,2},
{9321,3885,0,0,2},{9322,3887,0,0,2},{9323,3889,0,0,2},{9324,3891,0,0,2},{9325,
3893,0,0,2},{9326,3895,0,0,2},{9327,3897,0,0,2},{9328,3899,0,0,2},{9329,3901,0,
0,2},{9330,3903,0,0,2},{9331,3905,0,0,2},{9332,3907,0,0,3},{9333,3910,0,0,3},
{9334,3913,0,0,3},{9335,3916,0,0,3},{9336,3919,0,0,3},{9337,3922,0,0,3},{9338,
3925,0,0,3},{9339,3928,0,0,3},{9340,3931,0,0,3},{9341,3934,0,0,4},{9342,3938,0,
0,4},{9343,3942,0,0,4},{9344,3946,0,0,4},{9345,3950,0,0,4},{9346,3954,0,0,4},
{9347,3958,0,0,4},{9348,3962,0,0,4},{9349,3966,0,0,4},{9350,3970,0,0,4},{9351,
3974,0,0,4},{9352,3978,0,0,2},{9353,3980,0,0,2},{9354,3982,0,0,2},{9355,3984,0,
0,2},{9356,3986,0,0,2},{9357,3988,0,0,2},{9358,3990,0,0,2},{9359,3992,0,0,2},
{9360,3994,0,0,2},{9361,3996,0,0,3},{9362,3999,0,0,3},{9363,4002,0,0,3},{9364,
4005,0,0,3},{9365,4008,0,0,3},{9366,4011,0,0,3},{9367,4014,0,0,3},{9368,4017,0,
0,3},{9369,4020,0,0,3},{9370,4023,0,0,3},{9371,4026,0,0,3},{9372,4029,0,0,3},
{9373,4032,0,0,3},{9374,4035,0,0,3},{9375,4038,0,0,3},{9376,4041,0,0,3},{9377,
4044,0,0,3},{9378,4047,0,0,3},{9379,4050,0,0,3},{9380,4053,0,0,3},{9381,4056,0,
0,3},{9382,4059,0,0,3},{9383,4062,0,0,3},{9384,4065,0,0,3},{9385,4068,0,0,3},
{9386,4071,0,0,3},{9387,4074,0,0,3},{9388,4077,0,0,3},{9389,4080,0,0,3},{9390,
4083,0,0,3},{9391,4086,0,0,3},{9392,4089,0,0,3},{9393,4092,0,0,3},{9394,4095,0,
0,3},{9395,4098,0,0,3},{9396,4101,0,0,3},{9397,4104,0,0,3},{9451,4107,0,0,2},
{9452,4109,0,0,2},{9453,4111,0,0,2},{9454,4113,0,0,2},{9455,4115,0,0,2},{9456,
4117,0,0,2},{9457,4119,0,0,2},{9458,4121,0,0,2},{9459,4123,0,0,2},{9460,4125,0,
0,2},{9470,4127,0,0,2},{10111,4129,0,0,2},{10121,4131,0,0,2},{10131,4133,0,0,2},
{10764,4135,0,0,4},{10868,4139,0,0,3},{10869,4142,0,0,2},{10870,4144,0,0,3},
{10973,0,4539,1,0},{11492,4149,0,0,3},{11765,4152,0,0,2},{11904,4154,0,0,3},
{11905,4157,0,0,3},{11906,4160,0,0,2},{11907,4162,0,0,2},{11908,4164,0,0,3},
{11909,4167,0,0,2},{11910,4169,0,0,3},{11911,4172,0,0,3},{11912,4175,0,0,3},
{11913,4178,0,0,2},{11914,4180,0,0,3},{11915,4183,0,0,3},{11916,4186,0,0,3},
{11917,4189,0,0,3},{11918,4192,0,0,3},{11919,4195,0,0,2},{11920,4197,0,0,2},
{11921,4199,0,0,3},{11922,4202,0,0,2},{11923,4204,0,0,2},{11924,4206,0,0,2},
{11925,4208,0,0,3},{11926,4211,0,0,2},{11927,4213,0,0,3},{11928,4216,0,0,2},
{11929,4218,0,0,2},{11931,4220,0,0,2},{11932,4222,0,0,3},{11933,4225,0,0,3},
{11934,4228,0,0,3},{11935,4231,0,0,2},{11936,4233,0,0,2},{11937,4235,0,0,2},
{11938,4237,0,0,2},{11939,4239,0,0,2},{11940,4241,0,0,2},{11941,4243,0,0,3},
{11942,4246,0,0,2},{11943,4248,0,0,3},{11944,4251,0,0,2},{11945,4253,0,0,3},
{11946,4256,0,0,3},{11947,4259,0,0,3},{11948,4262,0,0,3},{11949,4265,0,0,2},
{11950,4267,0,0,3},{11951,4270,0,0,2},{11952,4272,0,0,2},{11953,4274,0,0,2},
{11954,4276,0,0,2},{11955,4278,0,0,3},{11956,4281,0,0,3},{11957,4284,0,0,3},
{11958,4287,0,0,3},{11959,4290,0,0,3},{11960,4293,0,0,2},{11961,4295,0,0,2},
{11962,4297,0,0,2},{11963,4299,0,0,3},{11964,4302,0,0,3},{11965,4305,0,0,3},
{11966,4308,0,0,2},{11967,4310,0,0,3},{11968,4313,0,0,3},{11969,4316,0,0,2},
{11970,4318,0,0,2},{11971,4320,0,0,2},{11972,4322,0,0,2},{11973,4324,0,0,2},
{11974,4326,0,0,2},{11975,4328,0,0,3},{11976,4331,0,0,2},{11977,4333,0,0,2},
{11978,4335,0,0,3},{11979,4338,0,0,2},{11980,4340,0,0,2},{11981,4342,0,0,3},
{11982,4345,0,0,3},{11983,4348,0,0,3},{11984,4351,0,0,2},{11985,4353,0,0,2},
{11986,4355,0,0,2},{11987,4357,0,0,2},{11988,4359,0,0,2},{11989,4361,0,0,3},
{11990,4364,0,0,2},{11991,4366,0,0,3},{11992,4369,0,0,2},{11993,4371,0,0,2},
{11994,4373,0,0,2},{11995,4375,0,0,2},{11996,4377,0,0,2},{11997,4379,0,0,2},
{11998,4381,0,0,3},{11999,4384,0,0,2},{12000,4386,0,0,2},{12001,4388,0,0,3},
{12002,4391,0,0,2},{12003,4393,0,0,3},{12004,4396,0,0,3},{12005,4399,0,0,2},
{12006,4401,0,0,2},{12007,4403,0,0,3},{12008,4406,0,0,2},{12009,4408,0,0,2},
{12010,4410,0,0,2},{12011,4412,0,0,3},{12012,4415,0,0,2},{12013,4417,0,0,3},
{12014,4420,0,0,2},{12015,4422,0,0,3},{12016,4425,0,0,2},{12017,4427,0,0,3},
{12018,4430,0,0,3},{12019,4433,0,0,2},{12032,4435,0,0,2},{12033,4437,0,0,2},
{12034,4439,0,0,2},{12035,4441,0,0,2},{12036,4443,0,0,2},{12037,4445,0,0,2},
{12038,4447,0,0,2},{12039,4449,0,0,2},{12040,4451,0,0,2},{12041,4453,0,0,2},
{12042,4455,0,0,2},{12043,4457,0,0,2},{12044,4459,0,0,2},{12045,4461,0,0,2},
{12046,4463,0,0,2},{12047,4465,0,0,2},{12048,4467,0,0,2},{12049,4469,0,0,2},
{12050,4471,0,0,2},{12051,4473,0,0,2},{12052,4475,0,0,2},{12053,4477,0,0,2},
{12054,4479,0,0,2},{12055,4481,0,0,2},{12056,4483,0,0,2},{12057,4485,0,0,2},
{12058,4487,0,0,2},{12059,4489,0,0,2},{12060,4491,0,0,2},{12061,4493,0,0,2},
{12062,4495,0,0,2},{12063,4497,0,0,2},{12064,4499,0,0,2},{12065,4501,0,0,2},
{12066,4503,0,0,2},{12067,4505,0,0,2},{12068,4507,0,0,2},{12069,4509,0,0,2},
{12070,4511,0,0,2},{12071,4513,0,0,2},{12072,4515,0,0,2},{12073,4517,0,0,2},
{12074,4519,0,0,2},{12075,4521,0,0,2},{12076,4523,0,0,2},{12077,4525,0,0,2},
{12078,4527,0,0,2},{12079,4529,0,0,2},{12080,4531,0,0,2},{12081,4533,0,0,2},
{12082,4535,0,0,2},{12083,4537,0,0,2},{12084,4539,0,0,2},{12085,4541,0,0,2},
{12086,4543,0,0,2},{12087,4545,0,0,2},{12088,4547,0,0,2},{12089,4549,0,0,2},
{12090,4551,0,0,2},{12091,4553,0,0,2},{12092,4555,0,0,2},{12093,4557,0,0,2},
{12094,4559,0,0,2},{12095,4561,0,0,2},{12096,4563,0,0,2},{12097,4565,0,0,2},
{12098,4567,0,0,2},{12099,4569,0,0,2},{12100,4571,0,0,2},{12101,4573,0,0,2},
{12102,4575,0,0,2},{12103,4577,0,0,2},{12104,4579,0,0,2},{12105,4581,0,0,2},
{12106,4583,0,0,2},{12107,4585,0,0,2},{12108,4587,0,0,2},{12109,4589,0,0,2},
{12110,4591,0,0,2},{12111,4593,0,0,2},{12112,4595,0,0,2},{12113,4597,0,0,2},
{12114,4599,0,0,2},{12115,4601,0,0,2},{12116,4603,0,0,2},{12117,4605,0,0,2},
{12118,4607,0,0,2},{12119,4609,0,0,2},{12120,4611,0,0,2},{12121,4613,0,0,2},
{12122,4615,0,0,2},{12123,4617,0,0,2},{12124,4619,0,0,2},{12125,4621,0,0,2},
{12126,4623,0,0,2},{12127,4625,0,0,2},{12128,4627,0,0,2},{12129,4629,0,0,2},
{12130,4631,0,0,2},{12131,4633,0,0,2},{12132,4635,0,0,2},{12133,4637,0,0,2},
{12134,4639,0,0,2},{12135,4641,0,0,2},{12136,4643,0,0,2},{12137,4645,0,0,2},
{12138,4647,0,0,2},{12139,4649,0,0,2},{12140,4651,0,0,2},{12141,4653,0,0,2},
{12142,4655,0,0,2},{12143,4657,0,0,2},{12144,4659,0,0,2},{12145,4661,0,0,2},
{12146,4663,0,0,2},{12147,4665,0,0,2},{12148,4667,0,0,2},{12149,4669,0,0,2},
{12150,4671,0,0,2},{12151,4673,0,0,2},{12152,4675,0,0,2},{12153,4677,0,0,2},
{12154,4679,0,0,2},{12155,4681,0,0,2},{12156,4683,0,0,2},{12157,4685,0,0,2},
{12158,4687,0,0,2},{12159,4689,0,0,2},{12160,4691,0,0,2},{12161,4693,0,0,2},
{12162,4695,0,0,2},{12163,4697,0,0,2},{12164,4699,0,0,2},{12165,4701,0,0,2},
{12166,4703,0,0,2},{12167,4705,0,0,2},{12168,4707,0,0,2},{12169,4709,0,0,2},
{12170,4711,0,0,2},{12171,4713,0,0,2},{12172,4715,0,0,2},{12173,4717,0,0,2},
{12174,4719,0,0,2},{12175,4721,0,0,2},{12176,4723,0,0,2},{12177,4725,0,0,2},
{12178,4727,0,0,2},{12179,4729,0,0,2},{12180,4731,0,0,2},{12181,4733,0,0,2},
{12182,4735,0,0,2},{12183,4737,0,0,2},{12184,4739,0,0,2},{12185,4741,0,0,2},
{12186,4743,0,0,2},{12187,4745,0,0,2},{12188,4747,0,0,2},{12189,4749,0,0,2},
{12190,4751,0,0,2},{12191,4753,0,0,2},{12192,4755,0,0,2},{12193,4757,0,0,2},
{12194,4759,0,0,2},{12195,4761,0,0,2},{12196,4763,0,0,2},{12197,4765,0,0,2},
{12198,4767,0,0,2},{12199,4769,0,0,2},{12200,4771,0,0,2},{12201,4773,0,0,2},
{12202,4775,0,0,2},{12203,4777,0,0,2},{12204,4779,0,0,2},{12205,4781,0,0,2},
{12206,4783,0,0,2},{12207,4785,0,0,2},{12208,4787,0,0,2},{12209,4789,0,0,2},
{12210,4791,0,0,2},{12211,4793,0,0,2},{12212,4795,0,0,2},{12213,4797,0,0,2},
{12214,4799,0,0,2},{12215,4801,0,0,2},{12216,4803,0,0,2},{12217,4805,0,0,2},
{12218,4807,0,0,2},{12219,4809,0,0,2},{12220,4811,0,0,2},{12221,4813,0,0,2},
{12222,4815,0,0,2},{12223,4817,0,0,2},{12224,4819,0,0,2},{12225,4821,0,0,2},
{12226,4823,0,0,2},{12227,4825,0,0,2},{12228,4827,0,0,2},{12229,4829,0,0,2},
{12230,4831,0,0,2},{12231,4833,0,0,2},{12232,4835,0,0,2},{12233,4837,0,0,2},
{12234,4839,0,0,2},{12235,4841,0,0,2},{12236,4843,0,0,2},{12237,4845,0,0,2},
{12238,4847,0,0,2},{12239,4849,0,0,2},{12240,4851,0,0,2},{12241,4853,0,0,2},
{12242,4855,0,0,2},{12243,4857,0,0,2},{12244,4859,0,0,2},{12245,4861,0,0,2},
{12294,4863,0,0,2},{12338,4865,0,0,2},{12340,4867,0,0,2},{12344,4869,0,0,2},
{12345,4871,0,0,2},{12346,4873,0,0,2},{12348,4875,0,0,2},{12364,4877,0,0,2},
{12366,4879,0,0,2},{12368,4881,0,0,2},{12370,4883,0,0,2},{12372,4885,0,0,2},
{12374,4887,0,0,2},{12376,4889,0,0,2},{12378,4891,0,0,2},{12380,4893,0,0,2},
{12382,4895,0,0,2},{12384,4897,0,0,2},{12386,4899,0,0,2},{12389,4901,0,0,2},
{12391,4903,0,0,2},{12393,4905,0,0,2},{12400,4907,0,0,2},{12401,4909,0,0,2},
{12403,4911,0,0,2},{12404,4913,0,0,2},{12406,4915,0,0,2},{12407,4917,0,0,2},
{12409,4919,0,0,2},{12410,4921,0,0,2},{12412,4923,0,0,2},{12413,4925,0,0,2},
{12436,4927,0,0,2},{12446,4929,0,0,2},{12447,4931,0,0,2},{12460,4933,0,0,2},
{12462,4935,0,0,2},{12464,4937,0,0,2},{12466,4939,0,0,2},{12468,4941,0,0,2},
{12470,4943,0,0,2},{12472,4945,0,0,2},{12474,4947,0,0,2},{12476,4949,0,0,2},
{12478,4951,0,0,2},{12480,4953,0,0,2},{12482,4955,0,0,2},{12485,4957,0,0,2},
{12487,4959,0,0,2},{12489,4961,0,0,2},{12496,4963,0,0,2},{12497,4965,0,0,2},
{12499,4967,0,0,2},{12500,4969,0,0,2},{12502,4971,0,0,2},{12503,4973,0,0,2},
{12505,4975,0,0,2},{12506,4977,0,0,2},{12508,4979,0,0,2},{12509,4981,0,0,2},
{12532,4983,0,0,2},{12535,4985,0,0,2},{12536,4987,0,0,2},{12537,4989,0,0,2},
{12538,4991,0,0,2},{12542,4993,0,0,2},{12543,4995,0,0,2},{12690,4997,0,0,2},
{12691,4999,0,0,2},{12692,5001,0,0,2},{12693,5003,0,0,2},{12694,5005,0,0,2},
{12695,5007,0,0,2},{12696,5009,0,0,2},{12697,5011,0,0,2},{12698,5013,0,0,2},
{12699,5015,0,0,2},{12700,5017,0,0,2},{12701,5019,0,0,2},{12702,5021,0,0,2},
{12703,5023,0,0,2},{12704,5025,0,0,2},{12705,5027,0,0,2},{12706,5029,0,0,2},
{12707,5031,0,0,2},{12709,5033,0,0,2},{12711,5035,0,0,2},{12712,5037,0,0,2},
{12713,5039,0,0,2},{12714,5041,0,0,2},{12715,5043,0,0,2},{12718,5045,0,0,2},
{12719,5047,0,0,2},{12723,5049,0,0,2},{12800,5051,0,0,3},{12801,5054,0,0,3},
{12802,5057,0,0,3},{12803,5060,0,0,3},{12804,5063,0,0,3},{12805,5066,0,0,3},
{12806,5069,0,0,3},{12807,5072,0,0,3},{12808,5075,0,0,3},{12809,5078,0,0,3},
{12810,5081,0,0,3},{12811,5084,0,0,3},{12812,5087,0,0,3},{12813,5090,0,0,3},
{12814,5093,0,0,4},{12815,5097,0,0,4},{12816,5101,0,0,4},{12817,5105,0,0,4},
{12818,5109,0,0,4},{12819,5113,0,0,4},{12820,5117,0,0,4},{12821,5121,0,0,4},
{12822,5125,0,0,4},{12823,5129,0,0,4},{12824,5133,0,0,4},{12825,5137,0,0,4},
{12826,5141,0,0,4},{12827,5145,0,0,4},{12828,5149,0,0,4},{12829,5153,0,0,7},
{12830,5160,0,0,6},{12832,5166,0,0,4},{12833,5170,0,0,4},{12834,5174,0,0,4},
{12835,5178,0,0,4},{12836,5182,0,0,4},{12837,5186,0,0,4},{12838,5190,0,0,4},
{12839,5194,0,0,4},{12840,5198,0,0,4},{12841,5202,0,0,4},{12842,5206,0,0,4},
{12843,5210,0,0,4},{12844,5214,0,0,4},{12845,5218,0,0,4},{12846,5222,0,0,4},
{12847,5226,0,0,4},{12848,5230,0,0,4},{12849,5234,0,0,4},{12850,5238,0,0,4},
{12851,5242,0,0,4},{12852,5246,0,0,4},{12853,5250,0,0,4},{12854,5254,0,0,4},
{12855,5258,0,0,4},{12856,5262,0,0,4},{12857,5266,0,0,4},{12858,5270,0,0,4},
{12859,5274,0,0,4},{12860,5278,0,0,4},{12861,5282,0,0,4},{12862,5286,0,0,4},
{12863,5290,0,0,4},{12864,5294,0,0,4},{12865,5298,0,0,4},{12866,5302,0,0,4},
{12867,5306,0,0,4},{12868,5310,0,0,2},{12869,5312,0,0,2},{12870,5314,0,0,2},
{12871,5316,0,0,2},{12872,5318,0,0,2},{12873,5320,0,0,2},{12874,5322,0,0,2},
{12875,5324,0,0,2},{12876,5326,0,0,2},{12877,5328,0,0,2},{12878,5330,0,0,2},
{12879,5332,0,0,2},{12880,5334,0,0,3},{12881,5337,0,0,2},{12882,5339,0,0,2},
{12883,5341,0,0,2},{12884,5343,0,0,2},{12885,5345,0,0,2},{12886,5347,0,0,2},
{12887,5349,0,0,2},{12888,5351,0,0,2},{12889,5353,0,0,2},{12890,5355,0,0,2},
{12891,5357,0,0,2},{12892,5359,0,0,2},{12893,5361,0,0,2},{12894,5363,0,0,2},
{12895,5365,0,0,2},{12910,5367,0,0,2},{12911,5369,0,0,2},{12912,5371,0,0,2},
{12913,5373,0,0,2},{12914,5375,0,0,2},{12915,5377,0,0,2},{12916,5379,0,0,2},
{12917,5381,0,0,2},{12918,5383,0,0,2},{12919,5385,0,0,2},{12920,5387,0,0,2},
{12921,5389,0,0,2},{12922,5391,0,0,2},{12923,5393,0,0,2},{12924,5395,0,0,5},
{12925,5400,0,0,4},{12926,5404,0,0,2},{12928,5406,0,0,2},{12929,5408,0,0,2},
{12930,5410,0,0,2},{12931,5412,0,0,2},{12932,5414,0,0,2},{12933,5416,0,0,2},
{12934,5418,0,0,2},{12935,5420,0,0,2},{12936,5422,0,0,2},{12937,5424,0,0,2},
{12938,5426,0,0,2},{12939,5428,0,0,2},{12940,5430,0,0,2},{12941,5432,0,0,2},
{12942,5434,0,0,2},{12943,5436,0,0,2},{12944,5438,0,0,2},{12945,5440,0,0,2},
{12946,5442,0,0,2},{12947,5444,0,0,2},{12948,5446,0,0,2},{12949,5448,0,0,2},
{12950,5450,0,0,2},{12951,5452,0,0,2},{12952,5454,0,0,2},{12953,5456,0,0,2},
{12954,5458,0,0,2},{12955,5460,0,0,2},{12956,5462,0,0,2},{12957,5464,0,0,2},
{12958,5466,0,0,2},{12959,5468,0,0,2},{12960,5470,0,0,2},{12961,5472,0,0,2},
{12962,5474,0,0,2},{12963,5476,0,0,2},{12964,5478,0,0,2},{12965,5480,0,0,2},
{12966,5482,0,0,2},{12967,5484,0,0,2},{12968,5486,0,0,2},{12969,5488,0,0,2},
{12970,5490,0,0,2},{12971,5492,0,0,2},{12972,5494,0,0,2},{12973,5496,0,0,2},
{12974,5498,0,0,2},{12975,5500,0,0,2},{12976,5502,0,0,2},{12977,5504,0,0,2},
{12978,5506,0,0,2},{12979,5508,0,0,2},{12980,5510,0,0,2},{12981,5512,0,0,2},
{12982,5514,0,0,2},{12983,5516,0,0,2},{12984,5518,0,0,2},{12985,5520,0,0,2},
{12986,5522,0,0,2},{12987,5524,0,0,2},{12988,5526,0,0,2},{12989,5528,0,0,2},
{12990,5530,0,0,2},{12991,5532,0,0,2},{12992,5534,0,0,3},{12993,5537,0,0,3},
{12994,5540,0,0,3},{12995,5543,0,0,3},{12996,5546,0,0,3},{12997,5549,0,0,3},
{12998,5552,0,0,3},{12999,5555,0,0,3},{13000,5558,0,0,3},{13001,5561,0,0,4},
{13002,5565,0,0,4},{13003,5569,0,0,4},{13004,5573,0,0,2},{13005,5575,0,0,3},
{13006,5578,0,0,2},{13007,5580,0,0,3},{13055,5583,0,0,4},{13056,5587,0,0,5},
{13057,5592,0,0,4},{13058,5596,0,0,5},{13059,5601,0,0,3},{13060,5604,0,0,5},
{13061,5609,0,0,3},{13062,5612,0,0,3},{13063,5615,0,0,6},{13064,5621,0,0,4},
{13065,5625,0,0,3},{13066,5628,0,0,3},{13067,5631,0,0,3},{13068,5634,0,0,4},
{13069,5638,0,0,4},{13070,5642,0,0,4},{13071,5646,0,0,4},{13072,5650,0,0,4},
{13073,5654,0,0,4},{13074,5658,0,0,4},{13075,5662,0,0,6},{13076,5668,0,0,2},
{13077,5670,0,0,6},{13078,5676,0,0,6},{13079,5682,0,0,5},{13080,5687,0,0,4},
{13081,5691,0,0,6},{13082,5697,0,0,6},{13083,5703,0,0,4},{13084,5707,0,0,3},
{13085,5710,0,0,3},{13086,5713,0,0,4},{13087,5717,0,0,4},{13088,5721,0,0,5},
{13089,5726,0,0,5},{13090,5731,0,0,3},{13091,5734,0,0,3},{13092,5737,0,0,4},
{13093,5741,0,0,3},{13094,5744,0,0,3},{13095,5747,0,0,2},{13096,5749,0,0,2},
{13097,5751,0,0,3},{13098,5754,0,0,3},{13099,5757,0,0,6},{13100,5763,0,0,4},
{13101,5767,0,0,5},{13102,5772,0,0,6},{13103,5778,0,0,4},{13104,5782,0,0,3},
{13105,5785,0,0,3},{13106,5788,0,0,6},{13107,5794,0,0,4},{13108,5798,0,0,6},
{13109,5804,0,0,3},{13110,5807,0,0,5},{13111,5812,0,0,3},{13112,5815,0,0,4},
{13113,5819,0,0,3},{13114,5822,0,0,4},{13115,5826,0,0,5},{13116,5831,0,0,4},
{13117,5835,0,0,5},{13118,5840,0,0,4},{13119,5844,0,0,2},{13120,5846,0,0,5},
{13121,5851,0,0,3},{13122,5854,0,0,3},{13123,5857,0,0,4},{13124,5861,0,0,3},
{13125,5864,0,0,3},{13126,5867,0,0,3},{13127,5870,0,0,5},{13128,5875,0,0,4},
{13129,5879,0,0,2},{13130,5881,0,0,6},{13131,5887,0,0,3},{13132,5890,0,0,5},
{13133,5895,0,0,4},{13134,5899,0,0,4},{13135,5903,0,0,3},{13136,5906,0,0,3},
{13137,5909,0,0,4},{13138,5913,0,0,2},{13139,5915,0,0,4},{13140,5919,0,0,5},
{13141,5924,0,0,2},{13142,5926,0,0,6},{13143,5932,0,0,3},{13144,5935,0,0,3},
{13145,5938,0,0,3},{13146,5941,0,0,3},{13147,5944,0,0,3},{13148,5947,0,0,3},
{13149,5950,0,0,3},{13150,5953,0,0,3},{13151,5956,0,0,3},{13152,5959,0,0,3},
{13153,5962,0,0,3},{13154,5965,0,0,4},{13155,5969,0,0,4},{13156,5973,0,0,4},
{13157,5977,0,0,4},{13158,5981,0,0,4},{13159,5985,0,0,4},{13160,5989,0,0,4},
{13161,5993,0,0,4},{13162,5997,0,0,4},{13163,6001,0,0,4},{13164,6005,0,0,4},
{13165,6009,0,0,4},{13166,6013,0,0,4},{13167,6017,0,0,4},{13168,6021,0,0,4},
{13169,6025,0,0,3},{13170,6028,0,0,2},{13171,6030,0,0,2},{13172,6032,0,0,3},
{13173,6035,0,0,2},{13174,6037,0,0,2},{13175,6039,0,0,2},{13176,6041,0,0,3},
{13177,6044,0,0,3},{13178,6047,0,0,2},{13179,6049,0,0,4},{13180,6053,0,0,4},
{13181,6057,0,0,4},{13182,6061,0,0,4},{13183,6065,0,0,8},{13184,6073,0,0,2},
{13185,6075,0,0,2},{13186,6077,0,0,2},{13187,6079,0,0,2},{13188,6081,0,0,2},
{13189,6083,0,0,2},{13190,6085,0,0,2},{13191,6087,0,0,2},{13192,6089,0,0,3},
{13193,6092,0,0,4},{13194,6096,0,0,2},{13195,6098,0,0,2},{13196,6100,0,0,2},
{13197,6102,0,0,2},{13198,6104,0,0,2},{13199,6106,0,0,2},{13200,6108,0,0,2},
{13201,6110,0,0,3},{13202,6113,0,0,3},{13203,6116,0,0,3},{13204,6119,0,0,3},
{13205,6122,0,0,2},{13206,6124,0,0,2},{13207,6126,0,0,2},{13208,6128,0,0,2},
{13209,6130,0,0,2},{13210,6132,0,0,2},{13211,6134,0,0,2},{13212,6136,0,0,2},
{13213,6138,0,0,2},{13214,6140,0,0,2},{13215,6142,0,0,3},{13216,6145,0,0,3},
{13217,6148,0,0,2},{13218,6150,0,0,3},{13219,6153,0,0,3},{13220,6156,0,0,3},
{13221,6159,0,0,2},{13222,6161,0,0,3},{13223,6164,0,0,3},{13224,6167,0,0,4},
{13225,6171,0,0,2},{13226,6173,0,0,3},{13227,6176,0,0,3},{13228,6179,0,0,3},
{13229,6182,0,0,3},{13230,6185,0,0,5},{13231,6190,0,0,6},{13232,6196,0,0,2},
{13233,6198,0,0,2},{13234,6200,0,0,2},{13235,6202,0,0,2},{13236,6204,0,0,2},
{13237,6206,0,0,2},{13238,6208,0,0,2},{13239,6210,0,0,2},{13240,6212,0,0,2},
{13241,6214,0,0,2},{13242,6216,0,0,2},{13243,6218,0,0,2},{13244,6220,0,0,2},
{13245,6222,0,0,2},{13246,6224,0,0,2},{13247,6226,0,0,2},{13248,6228,0,0,2},
{13249,6230,0,0,2},{13250,6232,0,0,4},{13251,6236,0,0,2},{13252,6238,0,0,2},
{13253,6240,0,0,2},{13254,6242,0,0,4},{13255,6246,0,0,3},{13256,6249,0,0,2},
{13257,6251,0,0,2},{13258,6253,0,0,2},{13259,6255,0,0,2},{13260,6257,0,0,2},
{13261,6259,0,0,2},{13262,6261,0,0,2},{13263,6263,0,0,2},{13264,6265,0,0,2},
{13265,6267,0,0,2},{13266,6269,0,0,3},{13267,6272,0,0,2},{13268,6274,0,0,2},
{13269,6276,0,0,3},{13270,6279,0,0,3},{13271,6282,0,0,2},{13272,6284,0,0,4},
{13273,6288,0,0,3},{13274,6291,0,0,2},{13275,6293,0,0,2},{13276,6295,0,0,2},
{13277,6297,0,0,2},{13278,6299,0,0,3},{13279,6302,0,0,3},{13280,6305,0,0,3},
{13281,6308,0,0,3},{13282,6311,0,0,3},{13283,6314,0,0,3},{13284,6317,0,0,3},
{13285,6320,0,0,3},{13286,6323,0,0,3},{13287,6326,0,0,3},{13288,6329,0,0,3},
{13289,6332,0,0,4},{13290,6336,0,0,4},{13291,6340,0,0,4},{13292,6344,0,0,4},
{13293,6348,0,0,4},{13294,6352,0,0,4},{13295,6356,0,0,4},{13296,6360,0,0,4},
{13297,6364,0,0,4},{13298,6368,0,0,4},{13299,6372,0,0,4},{13300,6376,0,0,4},
{13301,6380,0,0,4},{13302,6384,0,0,4},{13303,6388,0,0,4},{13304,6392,0,0,4},
{13305,6396,0,0,4},{13306,6400,0,0,4},{13307,6404,0,0,4},{13308,6408,0,0,4},
{13309,6412,0,0,4},{13310,6416,0,0,4},{13311,6420,0,0,3},{13470,6423,0,0,2},
{13497,6425,0,0,2},{13499,6427,0,0,2},{13535,6429,0,0,2},{13589,6431,0,0,2},
{14062,6433,0,0,2},{14076,6435,0,0,2},{14209,6437,0,0,2},{14383,6439,0,0,2},
{14434,6441,0,0,2},{14460,6443,0,0,2},{14535,6445,0,0,2},{14563,6447,0,0,2},
{14620,6449,0,0,2},{14650,6451,0,0,2},{14894,6453,0,0,2},{14956,6455,0,0,2},
{15076,6457,0,0,2},{15112,6459,0,0,2},{15129,6461,0,0,2},{15177,6463,0,0,2},
{15261,6465,0,0,2},{15384,6467,0,0,2},{15438,6469,0,0,2},{15667,6471,0,0,2},
{15766,6473,0,0,2},{16044,6475,0,0,2},{16056,6477,0,0,2},{16155,6479,0,0,2},
{16380,6481,0,0,2},{16392,6483,0,0,2},{16408,6485,0,0,2},{16441,6487,0,0,2},
{16454,6489,0,0,2},{16534,6491,0,0,2},{16611,6493,0,0,2},{16687,6495,0,0,2},
{16898,6497,0,0,2},{16935,6499,0,0,2},{17056,6501,0,0,2},{17153,6503,0,0,2},
{17204,6505,0,0,2},{17241,6507,0,0,2},{17365,6509,0,0,2},{17369,6511,0,0,2},
{17419,6513,0,0,2},{17515,6515,0,0,2},{17707,6517,0,0,2},{17757,6519,0,0,2},
{17761,6521,0,0,2},{17771,6523,0,0,2},{17879,6525,0,0,2},{17913,6527,0,0,2},
{17973,6529,0,0,2},{18110,6531,0,0,2},{18119,6533,0,0,2},{18837,6535,0,0,2},
{18918,6537,0,0,2},{19054,6539,0,0,2},{19062,6541,0,0,2},{19122,6543,0,0,2},
{19251,6545,0,0,2},{19406,6547,0,0,2},{19662,6549,0,0,2},{19693,6551,0,0,2},
{19704,6553,0,0,2},{19798,6555,0,0,2},{19981,6557,0,0,2},{20006,6559,0,0,2},
{20018,6561,0,0,2},{20024,6563,0,0,2},{20025,6565,0,0,2},{20029,6567,0,0,2},
{20033,6569,0,0,2},{20098,6571,0,0,2},{20102,6573,0,0,2},{20142,6575,0,0,2},
{20160,6577,0,0,2},{20172,6579,0,0,2},{20196,6581,0,0,2},{20320,6583,0,0,2},
{20352,6585,0,0,2},{20358,6587,0,0,2},{20363,6589,0,0,2},{20398,6591,0,0,2},
{20411,6593,0,0,2},{20415,6595,0,0,2},{20482,6597,0,0,2},{20523,6599,0,0,2},
{20602,6601,0,0,2},{20633,6603,0,0,2},{20687,6605,0,0,2},{20698,6607,0,0,2},
{20711,6609,0,0,2},{20800,6611,0,0,2},{20805,6613,0,0,2},{20813,6615,0,0,2},
{20820,6617,0,0,2},{20836,6619,0,0,2},{20839,6621,0,0,2},{20840,6623,0,0,2},
{20841,6625,0,0,2},{20845,6627,0,0,2},{20855,6629,0,0,2},{20864,6631,0,0,2},
{20877,6633,0,0,2},{20882,6635,0,0,2},{20885,6637,0,0,2},{20887,6639,0,0,2},
{20900,6641,0,0,2},{20908,6643,0,0,2},{20917,6645,0,0,2},{20919,6647,0,0,2},
{20937,6649,0,0,2},{20940,6651,0,0,2},{20956,6653,0,0,2},{20958,6655,0,0,2},
{20981,6657,0,0,2},{20995,6659,0,0,2},{20999,6661,0,0,2},{21015,6663,0,0,2},
{21033,6665,0,0,2},{21050,6667,0,0,2},{21051,6669,0,0,2},{21062,6671,0,0,2},
{21106,6673,0,0,2},{21111,6675,0,0,2},{21129,6677,0,0,2},{21147,6679,0,0,2},
{21155,6681,0,0,2},{21171,6683,0,0,2},{21191,6685,0,0,2},{21193,6687,0,0,2},
{21202,6689,0,0,2},{21214,6691,0,0,2},{21220,6693,0,0,2},{21237,6695,0,0,2},
{21242,6697,0,0,2},{21253,6699,0,0,2},{21254,6701,0,0,2},{21271,6703,0,0,2},
{21311,6705,0,0,2},{21321,6707,0,0,2},{21329,6709,0,0,2},{21338,6711,0,0,2},
{21363,6713,0,0,2},{21365,6715,0,0,2},{21373,6717,0,0,2},{21375,6719,0,0,2},
{21443,6721,0,0,2},{21450,6723,0,0,2},{21471,6725,0,0,2},{21477,6727,0,0,2},
{21483,6729,0,0,2},{21489,6731,0,0,2},{21510,6733,0,0,2},{21519,6735,0,0,2},
{21533,6737,0,0,2},{21560,6739,0,0,2},{21570,6741,0,0,2},{21576,6743,0,0,2},
{21608,6745,0,0,2},{21662,6747,0,0,2},{21666,6749,0,0,2},{21693,6751,0,0,2},
{21750,6753,0,0,2},{21776,6755,0,0,2},{21843,6757,0,0,2},{21845,6759,0,0,2},
{21859,6761,0,0,2},{21892,6763,0,0,2},{21895,6765,0,0,2},{21913,6767,0,0,2},
{21917,6769,0,0,2},{21931,6771,0,0,2},{21939,6773,0,0,2},{21952,6775,0,0,2},
{21954,6777,0,0,2},{21986,6779,0,0,2},{22022,6781,0,0,2},{22097,6783,0,0,2},
{22120,6785,0,0,2},{22132,6787,0,0,2},{22265,6789,0,0,2},{22294,6791,0,0,2},
{22295,6793,0,0,2},{22411,6795,0,0,2},{22478,6797,0,0,2},{22516,6799,0,0,2},
{22541,6801,0,0,2},{22577,6803,0,0,2},{22578,6805,0,0,2},{22592,6807,0,0,2},
{22618,6809,0,0,2},{22622,6811,0,0,2},{22696,6813,0,0,2},{22700,6815,0,0,2},
{22707,6817,0,0,2},{22744,6819,0,0,2},{22751,6821,0,0,2},{22766,6823,0,0,2},
{22770,6825,0,0,2},{22775,6827,0,0,2},{22790,6829,0,0,2},{22810,6831,0,0,2},
{22818,6833,0,0,2},{22852,6835,0,0,2},{22856,6837,0,0,2},{22865,6839,0,0,2},
{22868,6841,0,0,2},{22882,6843,0,0,2},{22899,6845,0,0,2},{23000,6847,0,0,2},
{23020,6849,0,0,2},{23067,6851,0,0,2},{23079,6853,0,0,2},{23138,6855,0,0,2},
{23142,6857,0,0,2},{23221,6859,0,0,2},{23304,6861,0,0,2},{23336,6863,0,0,2},
{23358,6865,0,0,2},{23429,6867,0,0,2},{23491,6869,0,0,2},{23512,6871,0,0,2},
{23527,6873,0,0,2},{23534,6875,0,0,2},{23539,6877,0,0,2},{23551,6879,0,0,2},
{23558,6881,0,0,2},{23586,6883,0,0,2},{23615,6885,0,0,2},{23648,6887,0,0,2},
{23650,6889,0,0,2},{23652,6891,0,0,2},{23653,6893,0,0,2},{23662,6895,0,0,2},
{23693,6897,0,0,2},{23744,6899,0,0,2},{23833,6901,0,0,2},{23875,6903,0,0,2},
{23888,6905,0,0,2},{23915,6907,0,0,2},{23918,6909,0,0,2},{23932,6911,0,0,2},
{23986,6913,0,0,2},{23994,6915,0,0,2},{24033,6917,0,0,2},{24034,6919,0,0,2},
{24061,6921,0,0,2},{24104,6923,0,0,2},{24125,6925,0,0,2},{24169,6927,0,0,2},
{24180,6929,0,0,2},{24230,6931,0,0,2},{24240,6933,0,0,2},{24243,6935,0,0,2},
{24246,6937,0,0,2},{24265,6939,0,0,2},{24266,6941,0,0,2},{24274,6943,0,0,2},
{24275,6945,0,0,2},{24281,6947,0,0,2},{24300,6949,0,0,2},{24318,6951,0,0,2},
{24324,6953,0,0,2},{24354,6955,0,0,2},{24403,6957,0,0,2},{24418,6959,0,0,2},
{24425,6961,0,0,2},{24427,6963,0,0,2},{24459,6965,0,0,2},{24474,6967,0,0,2},
{24489,6969,0,0,2},{24493,6971,0,0,2},{24525,6973,0,0,2},{24535,6975,0,0,2},
{24565,6977,0,0,2},{24569,6979,0,0,2},{24594,6981,0,0,2},{24604,6983,0,0,2},
{24693,6985,0,0,2},{24705,6987,0,0,2},{24724,6989,0,0,2},{24775,6991,0,0,2},
{24792,6993,0,0,2},{24801,6995,0,0,2},{24840,6997,0,0,2},{24900,6999,0,0,2},
{24904,7001,0,0,2},{24908,7003,0,0,2},{24910,7005,0,0,2},{24928,7007,0,0,2},
{24936,7009,0,0,2},{24954,7011,0,0,2},{24974,7013,0,0,2},{24976,7015,0,0,2},
{24996,7017,0,0,2},{25007,7019,0,0,2},{25010,7021,0,0,2},{25054,7023,0,0,2},
{25074,7025,0,0,2},{25078,7027,0,0,2},{25088,7029,0,0,2},{25104,7031,0,0,2},
{25115,7033,0,0,2},{25134,7035,0,0,2},{25140,7037,0,0,2},{25181,7039,0,0,2},
{25265,7041,0,0,2},{25289,7043,0,0,2},{25295,7045,0,0,2},{25299,7047,0,0,2},
{25300,7049,0,0,2},{25340,7051,0,0,2},{25342,7053,0,0,2},{25405,7055,0,0,2},
{25424,7057,0,0,2},{25448,7059,0,0,2},{25467,7061,0,0,2},{25475,7063,0,0,2},
{25504,7065,0,0,2},{25513,7067,0,0,2},{25540,7069,0,0,2},{25541,7071,0,0,2},
{25572,7073,0,0,2},{25628,7075,0,0,2},{25634,7077,0,0,2},{25682,7079,0,0,2},
{25705,7081,0,0,2},{25719,7083,0,0,2},{25726,7085,0,0,2},{25754,7087,0,0,2},
{25757,7089,0,0,2},{25796,7091,0,0,2},{25935,7093,0,0,2},{25942,7095,0,0,2},
{25964,7097,0,0,2},{25976,7099,0,0,2},{26009,7101,0,0,2},{26053,7103,0,0,2},
{26082,7105,0,0,2},{26083,7107,0,0,2},{26131,7109,0,0,2},{26185,7111,0,0,2},
{26228,7113,0,0,2},{26248,7115,0,0,2},{26257,7117,0,0,2},{26268,7119,0,0,2},
{26292,7121,0,0,2},{26310,7123,0,0,2},{26356,7125,0,0,2},{26360,7127,0,0,2},
{26368,7129,0,0,2},{26391,7131,0,0,2},{26395,7133,0,0,2},{26401,7135,0,0,2},
{26446,7137,0,0,2},{26451,7139,0,0,2},{26454,7141,0,0,2},{26462,7143,0,0,2},
{26491,7145,0,0,2},{26501,7147,0,0,2},{26519,7149,0,0,2},{26611,7151,0,0,2},
{26618,7153,0,0,2},{26647,7155,0,0,2},{26655,7157,0,0,2},{26706,7159,0,0,2},
{26753,7161,0,0,2},{26757,7163,0,0,2},{26766,7165,0,0,2},{26792,7167,0,0,2},
{26900,7169,0,0,2},{26946,7171,0,0,2},{27043,7173,0,0,2},{27114,7175,0,0,2},
{27138,7177,0,0,2},{27155,7179,0,0,2},{27304,7181,0,0,2},{27347,7183,0,0,2},
{27355,7185,0,0,2},{27396,7187,0,0,2},{27425,7189,0,0,2},{27476,7191,0,0,2},
{27506,7193,0,0,2},{27511,7195,0,0,2},{27513,7197,0,0,2},{27551,7199,0,0,2},
{27566,7201,0,0,2},{27578,7203,0,0,2},{27579,7205,0,0,2},{27726,7207,0,0,2},
{27751,7209,0,0,2},{27784,7211,0,0,2},{27839,7213,0,0,2},{27852,7215,0,0,2},
{27853,7217,0,0,2},{27877,7219,0,0,2},{27926,7221,0,0,2},{27931,7223,0,0,2},
{27934,7225,0,0,2},{27956,7227,0,0,2},{27966,7229,0,0,2},{27969,7231,0,0,2},
{28009,7233,0,0,2},{28010,7235,0,0,2},{28023,7237,0,0,2},{28024,7239,0,0,2},
{28037,7241,0,0,2},{28107,7243,0,0,2},{28122,7245,0,0,2},{28138,7247,0,0,2},
{28153,7249,0,0,2},{28186,7251,0,0,2},{28207,7253,0,0,2},{28270,7255,0,0,2},
{28316,7257,0,0,2},{28346,7259,0,0,2},{28359,7261,0,0,2},{28363,7263,0,0,2},
{28369,7265,0,0,2},{28379,7267,0,0,2},{28431,7269,0,0,2},{28450,7271,0,0,2},
{28451,7273,0,0,2},{28526,7275,0,0,2},{28614,7277,0,0,2},{28651,7279,0,0,2},
{28670,7281,0,0,2},{28699,7283,0,0,2},{28702,7285,0,0,2},{28729,7287,0,0,2},
{28746,7289,0,0,2},{28784,7291,0,0,2},{28791,7293,0,0,2},{28797,7295,0,0,2},
{28825,7297,0,0,2},{28845,7299,0,0,2},{28872,7301,0,0,2},{28889,7303,0,0,2},
{28997,7305,0,0,2},{29001,7307,0,0,2},{29038,7309,0,0,2},{29084,7311,0,0,2},
{29134,7313,0,0,2},{29136,7315,0,0,2},{29200,7317,0,0,2},{29211,7319,0,0,2},
{29224,7321,0,0,2},{29227,7323,0,0,2},{29237,7325,0,0,2},{29264,7327,0,0,2},
{29282,7329,0,0,2},{29312,7331,0,0,2},{29333,7333,0,0,2},{29359,7335,0,0,2},
{29376,7337,0,0,2},{29436,7339,0,0,2},{29482,7341,0,0,2},{29557,7343,0,0,2},
{29562,7345,0,0,2},{29575,7347,0,0,2},{29579,7349,0,0,2},{29605,7351,0,0,2},
{29618,7353,0,0,2},{29662,7355,0,0,2},{29702,7357,0,0,2},{29705,7359,0,0,2},
{29730,7361,0,0,2},{29767,7363,0,0,2},{29788,7365,0,0,2},{29801,7367,0,0,2},
{29809,7369,0,0,2},{29829,7371,0,0,2},{29833,7373,0,0,2},{29848,7375,0,0,2},
{29898,7377,0,0,2},{29958,7379,0,0,2},{29988,7381,0,0,2},{30011,7383,0,0,2},
{30014,7385,0,0,2},{30041,7387,0,0,2},{30053,7389,0,0,2},{30064,7391,0,0,2},
{30178,7393,0,0,2},{30224,7395,0,0,2},{30237,7397,0,0,2},{30239,7399,0,0,2},
{30274,7401,0,0,2},{30313,7403,0,0,2},{30410,7405,0,0,2},{30427,7407,0,0,2},
{30439,7409,0,0,2},{30452,7411,0,0,2},{30465,7413,0,0,2},{30494,7415,0,0,2},
{30495,7417,0,0,2},{30528,7419,0,0,2},{30538,7421,0,0,2},{30603,7423,0,0,2},
{30631,7425,0,0,2},{30798,7427,0,0,2},{30827,7429,0,0,2},{30860,7431,0,0,2},
{30865,7433,0,0,2},{30922,7435,0,0,2},{30924,7437,0,0,2},{30971,7439,0,0,2},
{31018,7441,0,0,2},{31036,7443,0,0,2},{31038,7445,0,0,2},{31048,7447,0,0,2},
{31049,7449,0,0,2},{31056,7451,0,0,2},{31062,7453,0,0,2},{31069,7455,0,0,2},
{31070,7457,0,0,2},{31077,7459,0,0,2},{31103,7461,0,0,2},{31117,7463,0,0,2},
{31118,7465,0,0,2},{31119,7467,0,0,2},{31150,7469,0,0,2},{31178,7471,0,0,2},
{31211,7473,0,0,2},{31260,7475,0,0,2},{31296,7477,0,0,2},{31306,7479,0,0,2},
{31311,7481,0,0,2},{31361,7483,0,0,2},{31409,7485,0,0,2},{31435,7487,0,0,2},
{31470,7489,0,0,2},{31520,7491,0,0,2},{31680,7493,0,0,2},{31686,7495,0,0,2},
{31689,7497,0,0,2},{31806,7499,0,0,2},{31840,7501,0,0,2},{31867,7503,0,0,2},
{31890,7505,0,0,2},{31934,7507,0,0,2},{31954,7509,0,0,2},{31958,7511,0,0,2},
{31971,7513,0,0,2},{31975,7515,0,0,2},{31976,7517,0,0,2},{32000,7519,0,0,2},
{32016,7521,0,0,2},{32034,7523,0,0,2},{32047,7525,0,0,2},{32091,7527,0,0,2},
{32099,7529,0,0,2},{32160,7531,0,0,2},{32190,7533,0,0,2},{32199,7535,0,0,2},
{32244,7537,0,0,2},{32258,7539,0,0,2},{32265,7541,0,0,2},{32311,7543,0,0,2},
{32321,7545,0,0,2},{32325,7547,0,0,2},{32574,7549,0,0,2},{32626,7551,0,0,2},
{32633,7553,0,0,2},{32634,7555,0,0,2},{32645,7557,0,0,2},{32661,7559,0,0,2},
{32666,7561,0,0,2},{32701,7563,0,0,2},{32762,7565,0,0,2},{32769,7567,0,0,2},
{32773,7569,0,0,2},{32838,7571,0,0,2},{32864,7573,0,0,2},{32879,7575,0,0,2},
{32880,7577,0,0,2},{32894,7579,0,0,2},{32907,7581,0,0,2},{32941,7583,0,0,2},
{32946,7585,0,0,2},{33027,7587,0,0,2},{33086,7589,0,0,2},{33240,7591,0,0,2},
{33256,7593,0,0,2},{33261,7595,0,0,2},{33281,7597,0,0,2},{33284,7599,0,0,2},
{33304,7601,0,0,2},{33391,7603,0,0,2},{33401,7605,0,0,2},{33419,7607,0,0,2},
{33425,7609,0,0,2},{33437,7611,0,0,2},{33457,7613,0,0,2},{33459,7615,0,0,2},
{33469,7617,0,0,2},{33509,7619,0,0,2},{33510,7621,0,0,2},{33565,7623,0,0,2},
{33571,7625,0,0,2},{33590,7627,0,0,2},{33618,7629,0,0,2},{33619,7631,0,0,2},
{33635,7633,0,0,2},{33709,7635,0,0,2},{33725,7637,0,0,2},{33737,7639,0,0,2},
{33738,7641,0,0,2},{33740,7643,0,0,2},{33756,7645,0,0,2},{33767,7647,0,0,2},
{33775,7649,0,0,2},{33777,7651,0,0,2},{33853,7653,0,0,2},{33865,7655,0,0,2},
{33879,7657,0,0,2},{34030,7659,0,0,2},{34033,7661,0,0,2},{34035,7663,0,0,2},
{34044,7665,0,0,2},{34070,7667,0,0,2},{34148,7669,0,0,2},{34253,7671,0,0,2},
{34298,7673,0,0,2},{34310,7675,0,0,2},{34322,7677,0,0,2},{34349,7679,0,0,2},
{34367,7681,0,0,2},{34384,7683,0,0,2},{34396,7685,0,0,2},{34407,7687,0,0,2},
{34409,7689,0,0,2},{34440,7691,0,0,2},{34473,7693,0,0,2},{34530,7695,0,0,2},
{34574,7697,0,0,2},{34600,7699,0,0,2},{34667,7701,0,0,2},{34681,7703,0,0,2},
{34694,7705,0,0,2},{34746,7707,0,0,2},{34785,7709,0,0,2},{34817,7711,0,0,2},
{34847,7713,0,0,2},{34892,7715,0,0,2},{34912,7717,0,0,2},{34915,7719,0,0,2},
{35010,7721,0,0,2},{35023,7723,0,0,2},{35031,7725,0,0,2},{35038,7727,0,0,2},
{35041,7729,0,0,2},{35064,7731,0,0,2},{35066,7733,0,0,2},{35088,7735,0,0,2},
{35137,7737,0,0,2},{35172,7739,0,0,2},{35206,7741,0,0,2},{35211,7743,0,0,2},
{35222,7745,0,0,2},{35488,7747,0,0,2},{35498,7749,0,0,2},{35519,7751,0,0,2},
{35531,7753,0,0,2},{35538,7755,0,0,2},{35542,7757,0,0,2},{35565,7759,0,0,2},
{35576,7761,0,0,2},{35582,7763,0,0,2},{35585,7765,0,0,2},{35641,7767,0,0,2},
{35672,7769,0,0,2},{35712,7771,0,0,2},{35722,7773,0,0,2},{35912,7775,0,0,2},
{35925,7777,0,0,2},{36011,7779,0,0,2},{36033,7781,0,0,2},{36034,7783,0,0,2},
{36040,7785,0,0,2},{36051,7787,0,0,2},{36104,7789,0,0,2},{36123,7791,0,0,2},
{36215,7793,0,0,2},{36284,7795,0,0,2},{36299,7797,0,0,2},{36335,7799,0,0,2},
{36336,7801,0,0,2},{36554,7803,0,0,2},{36564,7805,0,0,2},{36646,7807,0,0,2},
{36650,7809,0,0,2},{36664,7811,0,0,2},{36667,7813,0,0,2},{36706,7815,0,0,2},
{36766,7817,0,0,2},{36784,7819,0,0,2},{36790,7821,0,0,2},{36899,7823,0,0,2},
{36920,7825,0,0,2},{36978,7827,0,0,2},{36988,7829,0,0,2},{37007,7831,0,0,2},
{37012,7833,0,0,2},{37070,7835,0,0,2},{37086,7837,0,0,2},{37105,7839,0,0,2},
{37117,7841,0,0,2},{37137,7843,0,0,2},{37147,7845,0,0,2},{37226,7847,0,0,2},
{37273,7849,0,0,2},{37300,7851,0,0,2},{37324,7853,0,0,2},{37327,7855,0,0,2},
{37329,7857,0,0,2},{37428,7859,0,0,2},{37432,7861,0,0,2},{37494,7863,0,0,2},
{37500,7865,0,0,2},{37591,7867,0,0,2},{37592,7869,0,0,2},{37636,7871,0,0,2},
{37706,7873,0,0,2},{37881,7875,0,0,2},{37909,7877,0,0,2},{38283,7879,0,0,2},
{38317,7881,0,0,2},{38327,7883,0,0,2},{38446,7885,0,0,2},{38475,7887,0,0,2},
{38477,7889,0,0,2},{38517,7891,0,0,2},{38520,7893,0,0,2},{38524,7895,0,0,2},
{38534,7897,0,0,2},{38563,7899,0,0,2},{38583,7901,0,0,2},{38584,7903,0,0,2},
{38595,7905,0,0,2},{38626,7907,0,0,2},{38627,7909,0,0,2},{38646,7911,0,0,2},
{38647,7913,0,0,2},{38691,7915,0,0,2},{38706,7917,0,0,2},{38728,7919,0,0,2},
{38742,7921,0,0,2},{38875,7923,0,0,2},{38880,7925,0,0,2},{38911,7927,0,0,2},
{38923,7929,0,0,2},{38936,7931,0,0,2},{38953,7933,0,0,2},{38971,7935,0,0,2},
{39006,7937,0,0,2},{39138,7939,0,0,2},{39151,7941,0,0,2},{39164,7943,0,0,2},
{39208,7945,0,0,2},{39209,7947,0,0,2},{39335,7949,0,0,2},{39362,7951,0,0,2},
{39409,7953,0,0,2},{39422,7955,0,0,2},{39530,7957,0,0,2},{39698,7959,0,0,2},
{39791,7961,0,0,2},{40000,7963,0,0,2},{40023,7965,0,0,2},{40189,7967,0,0,2},
{40295,7969,0,0,2},{40372,7971,0,0,2},{40442,7973,0,0,2},{40478,7975,0,0,2},
{40575,7977,0,0,2},{40599,7979,0,0,2},{40607,7981,0,0,2},{40635,7983,0,0,2},
{40654,7985,0,0,2},{40697,7987,0,0,2},{40702,7989,0,0,2},{40709,7991,0,0,2},
{40719,7993,0,0,2},{40726,7995,0,0,2},{40763,7997,0,0,2},{40771,7999,0,0,2},
{40845,8001,0,0,2},{40846,8003,0,0,2},{40860,8005,0,0,2},{42515,8007,0,0,2},
{42516,8009,0,0,2},{42517,8011,0,0,2},{42518,8013,0,0,2},{42519,8015,0,0,2},
{42520,8017,0,0,2},{42521,8019,0,0,2},{42522,8021,0,0,2},{42523,8023,0,0,2},
{42524,8025,0,0,2},{42525,8027,0,0,2},{42526,8029,0,0,2},{42527,8031,0,0,2},
{42614,8033,0,0,2},{42792,8035,0,0,2},{42793,8037,0,0,2},{42802,8039,0,0,2},
{42803,8041,0,0,2},{42804,8043,0,0,2},{42805,8045,0,0,2},{42806,8047,0,0,2},
{42807,8049,0,0,2},{42808,8051,0,0,2},{42809,8053,0,0,2},{42810,8055,0,0,3},
{42811,8058,0,0,3},{42812,8061,0,0,2},{42813,8063,0,0,2},{42830,8065,0,0,2},
{42831,8067,0,0,2},{42848,8069,0,0,2},{42849,8071,0,0,2},{42873,8073,0,0,2},
{42874,8075,0,0,2},{42875,8077,0,0,2},{42876,8079,0,0,2},{42877,8081,0,0,2},
{42882,8083,0,0,2},{42883,8085,0,0,2},{42884,8087,0,0,2},{42885,8089,0,0,2},
{42886,8091,0,0,2},{42887,8093,0,0,2},{42906,8095,0,0,2},{42907,8097,0,0,2},
{42908,8099,0,0,2},{42909,8101,0,0,2},{42910,8103,0,0,2},{42911,8105,0,0,2},
{42912,8107,0,0,2},{42913,8109,0,0,2},{42914,8111,0,0,2},{42915,8113,0,0,2},
{42916,8115,0,0,2},{42917,8117,0,0,2},{42918,8119,0,0,2},{42919,8121,0,0,2},
{42920,8123,0,0,2},{42921,8125,0,0,2},{43000,8127,0,0,2},{43001,8129,0,0,3},
{43701,0,4540,48,0},{43702,0,4588,48,0},{43705,0,4636,48,0},{43707,0,4684,48,0},
{43708,0,4732,48,0},{43878,8612,0,0,2},{43879,8614,0,0,2},{64014,8616,0,0,2},
{64015,8618,0,0,2},{64017,8620,0,0,2},{64019,8622,0,0,2},{64020,8624,0,0,2},
{64031,8626,0,0,2},{64033,8628,0,0,2},{64035,8630,0,0,2},{64036,8632,0,0,2},
{64039,8634,0,0,2},{64040,8636,0,0,2},{64041,8638,0,0,2},{64256,8640,0,0,2},
{64257,8642,0,0,2},{64258,8644,0,0,2},{64259,8646,0,0,3},{64260,8649,0,0,3},
{64261,8652,0,0,3},{64262,8655,0,0,2},{64275,8657,0,0,2},{64276,8659,0,0,2},
{64277,8661,0,0,2},{64278,8663,0,0,2},{64279,8665,0,0,2},{64335,8667,0,0,2},
{64420,8669,0,0,2},{64421,8671,0,0,2},{64432,8673,0,0,2},{64433,8675,0,0,2},
{64477,8677,0,0,2},{64490,8679,0,0,2},{64491,8681,0,0,2},{64492,8683,0,0,2},
{64493,8685,0,0,2},{64494,8687,0,0,2},{64495,8689,0,0,2},{64496,8691,0,0,2},
{64497,8693,0,0,2},{64498,8695,0,0,2},{64499,8697,0,0,2},{64500,8699,0,0,2},
{64501,8701,0,0,2},{64502,8703,0,0,2},{64503,8705,0,0,2},{64504,8707,0,0,2},
{64505,8709,0,0,2},{64506,8711,0,0,2},{64507,8713,0,0,2},{64512,8715,0,0,2},
{64513,8717,0,0,2},{64514,8719,0,0,2},{64515,8721,0,0,2},{64516,8723,0,0,2},
{64517,8725,0,0,2},{64518,8727,0,0,2},{64519,8729,0,0,2},{64520,8731,0,0,2},
{64521,8733,0,0,2},{64522,8735,0,0,2},{64523,8737,0,0,2},{64524,8739,0,0,2},
{64525,8741,0,0,2},{64526,8743,0,0,2},{64527,8745,0,0,2},{64528,8747,0,0,2},
{64529,8749,0,0,2},{64530,8751,0,0,2},{64531,8753,0,0,2},{64532,8755,0,0,2},
{64533,8757,0,0,2},{64534,8759,0,0,2},{64535,8761,0,0,2},{64536,8763,0,0,2},
{64537,8765,0,0,2},{64538,8767,0,0,2},{64539,8769,0,0,2},{64540,8771,0,0,2},
{64541,8773,0,0,2},{64542,8775,0,0,2},{64543,8777,0,0,2},{64544,8779,0,0,2},
{64545,8781,0,0,2},{64546,8783,0,0,2},{64547,8785,0,0,2},{64548,8787,0,0,2},
{64549,8789,0,0,2},{64550,8791,0,0,2},{64551,8793,0,0,2},{64552,8795,0,0,2},
{64553,8797,0,0,2},{64554,8799,0,0,2},{64555,8801,0,0,2},{64556,8803,0,0,2},
{64557,8805,0,0,2},{64558,8807,0,0,2},{64559,8809,0,0,2},{64560,8811,0,0,2},
{64561,8813,0,0,2},{64562,8815,0,0,2},{64563,8817,0,0,2},{64564,8819,0,0,2},
{64565,8821,0,0,2},{64566,8823,0,0,2},{64567,8825,0,0,2},{64568,8827,0,0,2},
{64569,8829,0,0,2},{64570,8831,0,0,2},{64571,8833,0,0,2},{64572,8835,0,0,2},
{64573,8837,0,0,2},{64574,8839,0,0,2},{64575,8841,0,0,2},{64576,8843,0,0,2},
{64577,8845,0,0,2},{64578,8847,0,0,2},{64579,8849,0,0,2},{64580,8851,0,0,2},
{64581,8853,0,0,2},{64582,8855,0,0,2},{64583,8857,0,0,2},{64584,8859,0,0,2},
{64585,8861,0,0,2},{64586,8863,0,0,2},{64587,8865,0,0,2},{64588,8867,0,0,2},
{64589,8869,0,0,2},{64590,8871,0,0,2},{64591,8873,0,0,2},{64592,8875,0,0,2},
{64593,8877,0,0,2},{64594,8879,0,0,2},{64595,8881,0,0,2},{64596,8883,0,0,2},
{64597,8885,0,0,2},{64598,8887,0,0,2},{64599,8889,0,0,2},{64600,8891,0,0,2},
{64601,8893,0,0,2},{64602,8895,0,0,2},{64603,8897,0,0,2},{64604,8899,0,0,2},
{64605,8901,0,0,2},{64606,8903,0,0,2},{64607,8905,0,0,2},{64608,8907,0,0,2},
{64609,8909,0,0,2},{64610,8911,0,0,2},{64611,8913,0,0,2},{64612,8915,0,0,2},
{64613,8917,0,0,2},{64614,8919,0,0,2},{64615,8921,0,0,2},{64616,8923,0,0,2},
{64617,8925,0,0,2},{64618,8927,0,0,2},{64619,8929,0,0,2},{64620,8931,0,0,2},
{64621,8933,0,0,2},{64622,8935,0,0,2},{64623,8937,0,0,2},{64624,8939,0,0,2},
{64625,8941,0,0,2},{64626,8943,0,0,2},{64627,8945,0,0,2},{64628,8947,0,0,2},
{64629,8949,0,0,2},{64630,8951,0,0,2},{64631,8953,0,0,2},{64632,8955,0,0,2},
{64633,8957,0,0,2},{64634,8959,0,0,2},{64635,8961,0,0,2},{64636,8963,0,0,2},
{64637,8965,0,0,2},{64638,8967,0,0,2},{64639,8969,0,0,2},{64640,8971,0,0,2},
{64641,8973,0,0,2},{64642,8975,0,0,2},{64643,8977,0,0,2},{64644,8979,0,0,2},
{64645,8981,0,0,2},{64646,8983,0,0,2},{64647,8985,0,0,2},{64648,8987,0,0,2},
{64649,8989,0,0,2},{64650,8991,0,0,2},{64651,8993,0,0,2},{64652,8995,0,0,2},
{64653,8997,0,0,2},{64654,8999,0,0,2},{64655,9001,0,0,2},{64656,9003,0,0,2},
{64657,9005,0,0,2},{64658,9007,0,0,2},{64659,9009,0,0,2},{64660,9011,0,0,2},
{64661,9013,0,0,2},{64662,9015,0,0,2},{64663,9017,0,0,2},{64664,9019,0,0,2},
{64665,9021,0,0,2},{64666,9023,0,0,2},{64667,9025,0,0,2},{64668,9027,0,0,2},
{64669,9029,0,0,2},{64670,9031,0,0,2},{64671,9033,0,0,2},{64672,9035,0,0,2},
{64673,9037,0,0,2},{64674,9039,0,0,2},{64675,9041,0,0,2},{64676,9043,0,0,2},
{64677,9045,0,0,2},{64678,9047,0,0,2},{64679,9049,0,0,2},{64680,9051,0,0,2},
{64681,9053,0,0,2},{64682,9055,0,0,2},{64683,9057,0,0,2},{64684,9059,0,0,2},
{64685,9061,0,0,2},{64686,9063,0,0,2},{64687,9065,0,0,2},{64688,9067,0,0,2},
{64689,9069,0,0,2},{64690,9071,0,0,2},{64691,9073,0,0,2},{64692,9075,0,0,2},
{64693,9077,0,0,2},{64694,9079,0,0,2},{64695,9081,0,0,2},{64696,9083,0,0,2},
{64697,9085,0,0,2},{64698,9087,0,0,2},{64699,9089,0,0,2},{64700,9091,0,0,2},
{64701,9093,0,0,2},{64702,9095,0,0,2},{64703,9097,0,0,2},{64704,9099,0,0,2},
{64705,9101,0,0,2},{64706,9103,0,0,2},{64707,9105,0,0,2},{64708,9107,0,0,2},
{64709,9109,0,0,2},{64710,9111,0,0,2},{64711,9113,0,0,2},{64712,9115,0,0,2},
{64713,9117,0,0,2},{64714,9119,0,0,2},{64715,9121,0,0,2},{64716,9123,0,0,2},
{64717,9125,0,0,2},{64718,9127,0,0,2},{64719,9129,0,0,2},{64720,9131,0,0,2},
{64721,9133,0,0,2},{64722,9135,0,0,2},{64723,9137,0,0,2},{64724,9139,0,0,2},
{64725,9141,0,0,2},{64726,9143,0,0,2},{64727,9145,0,0,2},{64728,9147,0,0,2},
{64729,9149,0,0,2},{64730,9151,0,0,2},{64731,9153,0,0,2},{64732,9155,0,0,2},
{64733,9157,0,0,2},{64734,9159,0,0,2},{64735,9161,0,0,2},{64736,9163,0,0,2},
{64737,9165,0,0,2},{64738,9167,0,0,2},{64739,9169,0,0,2},{64740,9171,0,0,2},
{64741,9173,0,0,2},{64742,9175,0,0,2},{64743,9177,0,0,2},{64744,9179,0,0,2},
{64745,9181,0,0,2},{64746,9183,0,0,2},{64747,9185,0,0,2},{64748,9187,0,0,2},
{64749,9189,0,0,2},{64750,9191,0,0,2},{64751,9193,0,0,2},{64752,9195,0,0,2},
{64753,9197,0,0,2},{64754,9199,0,0,2},{64755,9201,0,0,2},{64756,9203,0,0,2},
{64757,9205,0,0,2},{64758,9207,0,0,2},{64759,9209,0,0,2},{64760,9211,0,0,2},
{64761,9213,0,0,2},{64762,9215,0,0,2},{64763,9217,0,0,2},{64764,9219,0,0,2},
{64765,9221,0,0,2},{64766,9223,0,0,2},{64767,9225,0,0,2},{64768,9227,0,0,2},
{64769,9229,0,0,2},{64770,9231,0,0,2},{64771,9233,0,0,2},{64772,9235,0,0,2},
{64773,9237,0,0,2},{64774,9239,0,0,2},{64775,9241,0,0,2},{64776,9243,0,0,2},
{64777,9245,0,0,2},{64778,9247,0,0,2},{64779,9249,0,0,2},{64780,9251,0,0,2},
{64781,9253,0,0,2},{64782,9255,0,0,2},{64783,9257,0,0,2},{64784,9259,0,0,2},
{64785,9261,0,0,2},{64786,9263,0,0,2},{64787,9265,0,0,2},{64788,9267,0,0,2},
{64789,9269,0,0,2},{64790,9271,0,0,2},{64791,9273,0,0,2},{64792,9275,0,0,2},
{64793,9277,0,0,2},{64794,9279,0,0,2},{64795,9281,0,0,2},{64796,9283,0,0,2},
{64797,9285,0,0,2},{64798,9287,0,0,2},{64799,9289,0,0,2},{64800,9291,0,0,2},
{64801,9293,0,0,2},{64802,9295,0,0,2},{64803,9297,0,0,2},{64804,9299,0,0,2},
{64805,9301,0,0,2},{64806,9303,0,0,2},{64807,9305,0,0,2},{64808,9307,0,0,2},
{64809,9309,0,0,2},{64810,9311,0,0,2},{64811,9313,0,0,2},{64812,9315,0,0,2},
{64813,9317,0,0,2},{64814,9319,0,0,2},{64815,9321,0,0,2},{64816,9323,0,0,2},
{64817,9325,0,0,2},{64818,9327,0,0,2},{64819,9329,0,0,2},{64820,9331,0,0,2},
{64821,9333,0,0,2},{64822,9335,0,0,2},{64823,9337,0,0,2},{64824,9339,0,0,2},
{64825,9341,0,0,2},{64826,9343,0,0,2},{64827,9345,0,0,2},{64828,9347,0,0,2},
{64829,9349,0,0,2},{64848,9351,0,0,3},{64849,9354,0,0,3},{64850,9357,0,0,3},
{64851,9360,0,0,3},{64852,9363,0,0,3},{64853,9366,0,0,3},{64854,9369,0,0,3},
{64855,9372,0,0,3},{64856,9375,0,0,3},{64857,9378,0,0,3},{64858,9381,0,0,3},
{64859,9384,0,0,3},{64860,9387,0,0,3},{64861,9390,0,0,3},{64862,9393,0,0,3},
{64863,9396,0,0,3},{64864,9399,0,0,3},{64865,9402,0,0,3},{64866,9405,0,0,3},
{64867,9408,0,0,3},{64868,9411,0,0,3},{64869,9414,0,0,3},{64870,9417,0,0,3},
{64871,9420,0,0,3},{64872,9423,0,0,3},{64873,9426,0,0,3},{64874,9429,0,0,3},
{64875,9432,0,0,3},{64876,9435,0,0,3},{64877,9438,0,0,3},{64878,9441,0,0,3},
{64879,9444,0,0,3},{64880,9447,0,0,3},{64881,9450,0,0,3},{64882,9453,0,0,3},
{64883,9456,0,0,3},{64884,9459,0,0,3},{64885,9462,0,0,3},{64886,9465,0,0,3},
{64887,9468,0,0,3},{64888,9471,0,0,3},{64889,9474,0,0,3},{64890,9477,0,0,3},
{64891,9480,0,0,3},{64892,9483,0,0,3},{64893,9486,0,0,3},{64894,9489,0,0,3},
{64895,9492,0,0,3},{64896,9495,0,0,3},{64897,9498,0,0,3},{64898,9501,0,0,3},
{64899,9504,0,0,3},{64900,9507,0,0,3},{64901,9510,0,0,3},{64902,9513,0,0,3},
{64903,9516,0,0,3},{64904,9519,0,0,3},{64905,9522,0,0,3},{64906,9525,0,0,3},
{64907,9528,0,0,3},{64908,9531,0,0,3},{64909,9534,0,0,3},{64910,9537,0,0,3},
{64911,9540,0,0,3},{64914,9543,0,0,3},{64915,9546,0,0,3},{64916,9549,0,0,3},
{64917,9552,0,0,3},{64918,9555,0,0,3},{64919,9558,0,0,3},{64920,9561,0,0,3},
{64921,9564,0,0,3},{64922,9567,0,0,3},{64923,9570,0,0,3},{64924,9573,0,0,3},
{64925,9576,0,0,3},{64926,9579,0,0,3},{64927,9582,0,0,3},{64928,9585,0,0,3},
{64929,9588,0,0,3},{64930,9591,0,0,3},{64931,9594,0,0,3},{64932,9597,0,0,3},
{64933,9600,0,0,3},{64934,9603,0,0,3},{64935,9606,0,0,3},{64936,9609,0,0,3},
{64937,9612,0,0,3},{64938,9615,0,0,3},{64939,9618,0,0,3},{64940,9621,0,0,3},
{64941,9624,0,0,3},{64942,9627,0,0,3},{64943,9630,0,0,3},{64944,9633,0,0,3},
{64945,9636,0,0,3},{64946,9639,0,0,3},{64947,9642,0,0,3},{64948,9645,0,0,3},
{64949,9648,0,0,3},{64950,9651,0,0,3},{64951,9654,0,0,3},{64952,9657,0,0,3},
{64953,9660,0,0,3},{64954,9663,0,0,3},{64955,9666,0,0,3},{64956,9669,0,0,3},
{64957,9672,0,0,3},{64958,9675,0,0,3},{64959,9678,0,0,3},{64960,9681,0,0,3},
{64961,9684,0,0,3},{64962,9687,0,0,3},{64963,9690,0,0,3},{64964,9693,0,0,3},
{64965,9696,0,0,3},{64966,9699,0,0,3},{64967,9702,0,0,3},{65008,9705,0,0,3},
{65009,9708,0,0,3},{65010,9711,0,0,4},{65011,9715,0,0,4},{65012,9719,0,0,4},
{65013,9723,0,0,4},{65014,9727,0,0,4},{65015,9731,0,0,4},{65016,9735,0,0,4},
{65017,9739,0,0,3},{65018,9742,0,0,18},{65019,9760,0,0,8},{65020,9768,0,0,4},
{65049,9772,0,0,3},{65072,9775,0,0,2},{65269,9777,0,0,2},{65270,9779,0,0,2},
{65271,9781,0,0,2},{65272,9783,0,0,2},{65273,9785,0,0,2},{65274,9787,0,0,2},
{65275,9789,0,0,2},{65276,9791,0,0,2},{67968,9793,0,0,2},{67969,9795,0,0,2},
{67970,9797,0,0,2},{67971,9799,0,0,2},{67972,9801,0,0,2},{67973,9803,0,0,2},
{67974,9805,0,0,2},{67975,9807,0,0,2},{67976,9809,0,0,2},{67977,9811,0,0,2},
{67978,9813,0,0,2},{67979,9815,0,0,2},{67980,9817,0,0,2},{67981,9819,0,0,2},
{67982,9821,0,0,2},{67983,9823,0,0,2},{67984,9825,0,0,2},{67985,9827,0,0,2},
{67986,9829,0,0,2},{67987,9831,0,0,2},{67988,9833,0,0,2},{67989,9835,0,0,2},
{67990,9837,0,0,2},{67991,9839,0,0,2},{67992,9841,0,0,2},{67993,9843,0,0,2},
{67994,9845,0,0,2},{67995,9847,0,0,2},{67996,9849,0,0,2},{67997,9851,0,0,2},
{68016,9853,0,0,2},{68296,9855,0,0,2},{68398,9857,0,0,2},{68609,9859,0,0,2},
{68612,9861,0,0,2},{68616,9863,0,0,2},{68618,9865,0,0,2},{68620,9867,0,0,2},
{68622,9869,0,0,2},{68624,9871,0,0,2},{68626,9873,0,0,2},{68629,9875,0,0,2},
{68631,9877,0,0,2},{68633,9879,0,0,2},{68635,9881,0,0,2},{68637,9883,0,0,2},
{68639,9885,0,0,2},{68645,9887,0,0,2},{68647,9889,0,0,2},{68649,9891,0,0,2},
{68651,9893,0,0,2},{68654,9895,0,0,2},{68659,9897,0,0,2},{68661,9899,0,0,2},
{68663,9901,0,0,2},{68665,9903,0,0,2},{68667,9905,0,0,2},{68672,9907,0,0,2},
{68674,9909,0,0,2},{68676,9911,0,0,2},{68678,9913,0,0,2},{68737,9915,0,0,2},
{68746,9917,0,0,2},{68747,9919,0,0,2},{68753,9921,0,0,2},{68764,9923,0,0,2},
{68766,9925,0,0,2},{68767,9927,0,0,2},{68771,9929,0,0,2},{68779,9931,0,0,2},
{68781,9933,0,0,2},{68801,9935,0,0,2},{68810,9937,0,0,2},{68811,9939,0,0,2},
{68817,9941,0,0,2},{68828,9943,0,0,2},{68830,9945,0,0,2},{68831,9947,0,0,2},
{68835,9949,0,0,2},{68843,9951,0,0,2},{68845,9953,0,0,2},{69392,9955,0,0,2},
{69395,9957,0,0,2},{69399,9959,0,0,2},{69404,9961,0,0,2},{69415,9963,0,0,2},
{69445,9965,0,0,2},{69622,9967,0,0,2},{69786,9969,0,0,2},{69788,9971,0,0,2},
{69803,9973,0,0,2},{71128,9975,0,0,2},{71129,9977,0,0,2},{71130,9979,0,0,2},
{71131,9981,0,0,2},{71132,9983,0,0,2},{71133,9985,0,0,2},{71429,9987,0,0,2},
{71446,9989,0,0,2},{71450,9991,0,0,2},{93844,9993,0,0,2},{93845,9995,0,0,2},
{93846,9997,0,0,2},{119127,0,4780,1,0},{119128,0,4781,1,0},{119225,0,4787,1,0},
{119226,0,4790,1,0},{126129,10034,0,0,2},{126130,10036,0,0,2},{126255,10038,0,0,
2},{126256,10040,0,0,2},{126257,10042,0,0,2},{126258,10044,0,0,2},{126259,10046,
0,0,2},{126260,10048,0,0,2},{126261,10050,0,0,2},{126262,10052,0,0,2},{127232,
10054,0,0,2},{127233,10056,0,0,2},{127234,10058,0,0,2},{127235,10060,0,0,2},
{127236,10062,0,0,2},{127237,10064,0,0,2},{127238,10066,0,0,2},{127239,10068,0,
0,2},{127240,10070,0,0,2},{127241,10072,0,0,2},{127242,10074,0,0,2},{127248,
10076,0,0,3},{127249,10079,0,0,3},{127250,10082,0,0,3},{127251,10085,0,0,3},
{127252,10088,0,0,3},{127253,10091,0,0,3},{127254,10094,0,0,3},{127255,10097,0,
0,3},{127256,10100,0,0,3},{127257,10103,0,0,3},{127258,10106,0,0,3},{127259,
10109,0,0,3},{127260,10112,0,0,3},{127261,10115,0,0,3},{127262,10118,0,0,3},
{127263,10121,0,0,3},{127264,10124,0,0,3},{127265,10127,0,0,3},{127266,10130,0,
0,3},{127267,10133,0,0,3},{127268,10136,0,0,3},{127269,10139,0,0,3},{127270,
10142,0,0,3},{127271,10145,0,0,3},{127272,10148,0,0,3},{127273,10151,0,0,3},
{127274,10154,0,0,3},{127277,10157,0,0,2},{127278,10159,0,0,2},{127306,10161,0,
0,2},{127307,10163,0,0,2},{127308,10165,0,0,2},{127309,10167,0,0,2},{127310,
10169,0,0,3},{127311,10172,0,0,2},{127338,10174,0,0,2},{127339,10176,0,0,2},
{127340,10178,0,0,2},{127371,10180,0,0,2},{127372,10182,0,0,2},{127373,10184,0,
0,2},{127374,10186,0,0,2},{127375,10188,0,0,2},{127376,10190,0,0,2},{127377,
10192,0,0,2},{127378,10194,0,0,4},{127379,10198,0,0,4},{127380,10202,0,0,2},
{127381,10204,0,0,3},{127382,10207,0,0,2},{127383,10209,0,0,2},{127384,10211,0,
0,3},{127385,10214,0,0,3},{127386,10217,0,0,2},{127387,10219,0,0,2},{127388,
10221,0,0,7},{127389,10228,0,0,2},{127390,10230,0,0,2},{127391,10232,0,0,2},
{127392,10234,0,0,3},{127393,10237,0,0,3},{127394,10240,0,0,4},{127395,10244,0,
0,3},{127396,10247,0,0,4},{127398,10251,0,0,2},{127399,10253,0,0,3},{127400,
10256,0,0,6},{127401,10262,0,0,8},{127402,10270,0,0,3},{127403,10273,0,0,3},
{127404,10276,0,0,3},{127488,10279,0,0,2},{127489,10281,0,0,2},{127504,10283,0,
0,2},{127505,10285,0,0,2},{127506,10287,0,0,2},{127507,10289,0,0,2},{127508,
10291,0,0,2},{127509,10293,0,0,2},{127510,10295,0,0,2},{127511,10297,0,0,2},
{127512,10299,0,0,2},{127513,10301,0,0,2},{127514,10303,0,0,2},{127515,10305,0,
0,2},{127516,10307,0,0,2},{127517,10309,0,0,2},{127518,10311,0,0,2},{127519,
10313,0,0,2},{127520,10315,0,0,2},{127521,10317,0,0,2},{127522,10319,0,0,2},
{127523,10321,0,0,2},{127524,10323,0,0,2},{127525,10325,0,0,2},{127526,10327,0,
0,2},{127527,10329,0,0,2},{127528,10331,0,0,2},{127529,10333,0,0,2},{127530,
10335,0,0,2},{127531,10337,0,0,2},{127532,10339,0,0,2},{127533,10341,0,0,2},
{127534,10343,0,0,2},{127535,10345,0,0,2},{127536,10347,0,0,2},{127537,10349,0,
0,2},{127538,10351,0,0,2},{127539,10353,0,0,2},{127540,10355,0,0,2},{127541,
10357,0,0,2},{127542,10359,0,0,2},{127543,10361,0,0,2},{127544,10363,0,0,2},
{127545,10365,0,0,2},{127546,10367,0,0,2},{127547,10369,0,0,2},{127552,10371,0,
0,4},{127553,10375,0,0,4},{127554,10379,0,0,4},{127555,10383,0,0,4},{127556,
10387,0,0,4},{127557,10391,0,0,4},{127558,10395,0,0,4},{127559,10399,0,0,4},
{127560,10403,0,0,4},{127568,10407,0,0,2},{127569,10409,0,0,2},{131362,10411,0,
0,2},{132380,10413,0,0,2},{132389,10415,0,0,2},{132427,10417,0,0,2},{132666,
10419,0,0,2},{133124,10421,0,0,2},{133342,10423,0,0,2},{133676,10425,0,0,2},
{133987,10427,0,0,2},{136420,10429,0,0,2},{136872,10431,0,0,2},{136938,10433,0,
0,2},{137672,10435,0,0,2},{138008,10437,0,0,2},{138507,10439,0,0,2},{138724,
10441,0,0,2},{138726,10443,0,0,2},{139651,10445,0,0,2},{139679,10447,0,0,2},
{140081,10449,0,0,2},{141012,10451,0,0,2},{141380,10453,0,0,2},{141386,10455,0,
0,2},{142092,10457,0,0,2},{142321,10459,0,0,2},{143370,10461,0,0,2},{144056,
10463,0,0,2},{144223,10465,0,0,2},{144275,10467,0,0,2},{144284,10469,0,0,2},
{144323,10471,0,0,2},{144341,10473,0,0,2},{144493,10475,0,0,2},{145059,10477,0,
0,2},{145575,10479,0,0,2},{146061,10481,0,0,2},{146170,10483,0,0,2},{146620,
10485,0,0,2},{146718,10487,0,0,2},{147153,10489,0,0,2},{147294,10491,0,0,2},
{147342,10493,0,0,2},{148067,10495,0,0,2},{148206,10497,0,0,2},{148395,10499,0,
0,2},{149000,10501,0,0,2},{149301,10503,0,0,2},{149524,10505,0,0,2},{150582,
10507,0,0,2},{150674,10509,0,0,2},{151457,10511,0,0,2},{151480,10513,0,0,2},
{151620,10515,0,0,2},{151794,10517,0,0,2},{151795,10519,0,0,2},{151833,10521,0,
0,2},{151859,10523,0,0,2},{152137,10525,0,0,2},{152605,10527,0,0,2},{153126,
10529,0,0,2},{153242,10531,0,0,2},{153285,10533,0,0,2},{153980,10535,0,0,2},
{154279,10537,0,0,2},{154539,10539,0,0,2},{154752,10541,0,0,2},{154832,10543,0,
0,2},{155526,10545,0,0,2},{156122,10547,0,0,2},{156200,10549,0,0,2},{156231,
10551,0,0,2},{156377,10553,0,0,2},{156478,10555,0,0,2},{156890,10557,0,0,2},
{156963,10559,0,0,2},{157096,10561,0,0,2},{157607,10563,0,0,2},{157621,10565,0,
0,2},{158524,10567,0,0,2},{158774,10569,0,0,2},{158933,10571,0,0,2},{159083,
10573,0,0,2},{159532,10575,0,0,2},{159665,10577,0,0,2},{159954,10579,0,0,2},
{160714,10581,0,0,2},{161383,10583,0,0,2},{161966,10585,0,0,2},{162150,10587,0,
0,2},{162984,10589,0,0,2},{163539,10591,0,0,2},{163631,10593,0,0,2},{165330,
10595,0,0,2},{165357,10597,0,0,2},{165678,10599,0,0,2},{166906,10601,0,0,2},
{167287,10603,0,0,2},{168261,10605,0,0,2},{168415,10607,0,0,2},{168474,10609,0,
0,2},{168970,10611,0,0,2},{169110,10613,0,0,2},{169398,10615,0,0,2},{170800,
10617,0,0,2},{172238,10619,0,0,2},{172293,10621,0,0,2},{172558,10623,0,0,2},
{172689,10625,0,0,2},{172946,10627,0,0,2},{173568,10629,0,0,2},{183,0,0,0,2},
{183,2,0,0,2},{769,649,0,0,2},{1463,811,0,0,2},{1464,813,0,0,2},{1468,815,0,0,
2},{1468,817,0,0,2},{1471,819,0,0,2},{1468,821,0,0,2},{1468,823,0,0,2},{1468,
825,0,0,2},{1465,827,0,0,2},{1468,829,0,0,2},{1468,831,0,0,2},{1468,833,0,0,2},
{1460,835,0,0,2},{1468,837,0,0,2},{1468,839,0,0,2},{1468,841,0,0,2},{1471,843,0,
0,2},{1468,845,0,0,2},{1468,847,0,0,2},{1468,849,0,0,2},{1468,851,0,0,2},{1468,
853,0,0,2},{1468,855,0,0,2},{1471,857,0,0,2},{1468,859,0,0,2},{1468,861,0,0,2},
{1468,863,0,0,2},{1468,865,3860,2,2},{1473,867,0,0,3},{1474,870,0,0,3},{1473,
873,0,0,2},{1474,875,0,0,2},{1468,877,0,0,2},{1463,889,0,0,3},{2364,928,0,0,2},
{2364,930,0,0,2},{2364,932,0,0,2},{2364,934,0,0,2},{2364,936,0,0,2},{2364,938,0,
0,2},{2364,942,0,0,2},{2364,944,0,0,2},{2492,950,0,0,2},{2492,952,0,0,2},{2492,
954,0,0,2},{2620,958,0,0,2},{2620,960,0,0,2},{2620,962,0,0,2},{2620,964,0,0,2},
{2620,966,0,0,2},{2620,968,0,0,2},{2876,970,0,0,2},{2876,972,0,0,2},{3585,994,0,
0,2},{3586,996,0,0,2},{3587,998,0,0,2},{3588,1000,0,0,2},{3589,1002,0,0,2},
{3590,1004,0,0,2},{3591,1006,0,0,2},{3592,1008,0,0,2},{3593,1010,0,0,2},{3594,
1012,0,0,2},{3595,1014,0,0,2},{3596,1016,0,0,2},{3597,1018,0,0,2},{3598,1020,0,
0,2},{3599,1022,0,0,2},{3600,1024,0,0,2},{3601,1026,0,0,2},{3602,1028,0,0,2},
{3603,1030,0,0,2},{3604,1032,0,0,2},{3605,1034,0,0,2},{3606,1036,0,0,2},{3607,
1038,0,0,2},{3608,1040,0,0,2},{3609,1042,0,0,2},{3610,1044,0,0,2},{3611,1046,0,
0,2},{3612,1048,0,0,2},{3613,1050,0,0,2},{3614,1052,0,0,2},{3615,1054,0,0,2},
{3616,1056,0,0,2},{3617,1058,0,0,2},{3618,1060,0,0,2},{3619,1062,0,0,2},{3620,
1064,0,0,2},{3621,1066,0,0,2},{3622,1068,0,0,2},{3623,1070,0,0,2},{3624,1072,0,
0,2},{3625,1074,0,0,2},{3626,1076,0,0,2},{3627,1078,0,0,2},{3628,1080,0,0,2},
{3629,1082,0,0,2},{3630,1084,0,0,2},{3585,1086,0,0,2},{3586,1088,0,0,2},{3587,
1090,0,0,2},{3588,1092,0,0,2},{3589,1094,0,0,2},{3590,1096,0,0,2},{3591,1098,0,
0,2},{3592,1100,0,0,2},{3593,1102,0,0,2},{3594,1104,0,0,2},{3595,1106,0,0,2},
{3596,1108,0,0,2},{3597,1110,0,0,2},{3598,1112,0,0,2},{3599,1114,0,0,2},{3600,
1116,0,0,2},{3601,1118,0,0,2},{3602,1120,0,0,2},{3603,1122,0,0,2},{3604,1124,0,
0,2},{3605,1126,0,0,2},{3606,1128,0,0,2},{3607,1130,0,0,2},{3608,1132,0,0,2},
{3609,1134,0,0,2},{3610,1136,0,0,2},{3611,1138,0,0,2},{3612,1140,0,0,2},{3613,
1142,0,0,2},{3614,1144,0,0,2},{3615,1146,0,0,2},{3616,1148,0,0,2},{3617,1150,0,
0,2},{3618,1152,0,0,2},{3619,1154,0,0,2},{3620,1156,0,0,2},{3621,1158,0,0,2},
{3622,1160,0,0,2},{3623,1162,0,0,2},{3624,1164,0,0,2},{3625,1166,0,0,2},{3626,
1168,0,0,2},{3627,1170,0,0,2},{3628,1172,0,0,2},{3629,1174,0,0,2},{3630,1176,0,
0,2},{3585,1178,0,0,2},{3586,1180,0,0,2},{3587,1182,0,0,2},{3588,1184,0,0,2},
{3589,1186,0,0,2},{3590,1188,0,0,2},{3591,1190,0,0,2},{3592,1192,0,0,2},{3593,
1194,0,0,2},{3594,1196,0,0,2},{3595,1198,0,0,2},{3596,1200,0,0,2},{3597,1202,0,
0,2},{3598,1204,0,0,2},{3599,1206,0,0,2},{3600,1208,0,0,2},{3601,1210,0,0,2},
{3602,1212,0,0,2},{3603,1214,0,0,2},{3604,1216,0,0,2},{3605,1218,0,0,2},{3606,
1220,0,0,2},{3607,1222,0,0,2},{3608,1224,0,0,2},{3609,1226,0,0,2},{3610,1228,0,
0,2},{3611,1230,0,0,2},{3612,1232,0,0,2},{3613,1234,0,0,2},{3614,1236,0,0,2},
{3615,1238,0,0,2},{3616,1240,0,0,2},{3617,1242,0,0,2},{3618,1244,0,0,2},{3619,
1246,0,0,2},{3620,1248,0,0,2},{3621,1250,0,0,2},{3622,1252,0,0,2},{3623,1254,0,
0,2},{3624,1256,0,0,2},{3625,1258,0,0,2},{3626,1260,0,0,2},{3627,1262,0,0,2},
{3628,1264,0,0,2},{3629,1266,0,0,2},{3630,1268,0,0,2},{3585,1270,0,0,2},{3586,
1272,0,0,2},{3587,1274,0,0,2},{3588,1276,0,0,2},{3589,1278,0,0,2},{3590,1280,0,
0,2},{3591,1282,0,0,2},{3592,1284,0,0,2},{3593,1286,0,0,2},{3594,1288,0,0,2},
{3595,1290,0,0,2},{3596,1292,0,0,2},{3597,1294,0,0,2},{3598,1296,0,0,2},{3599,
1298,0,0,2},{3600,1300,0,0,2},{3601,1302,0,0,2},{3602,1304,0,0,2},{3603,1306,0,
0,2},{3604,1308,0,0,2},{3605,1310,0,0,2},{3606,1312,0,0,2},{3607,1314,0,0,2},
{3608,1316,0,0,2},{3609,1318,0,0,2},{3610,1320,0,0,2},{3611,1322,0,0,2},{3612,
1324,0,0,2},{3613,1326,0,0,2},{3614,1328,0,0,2},{3615,1330,0,0,2},{3616,1332,0,
0,2},{3617,1334,0,0,2},{3618,1336,0,0,2},{3619,1338,0,0,2},{3620,1340,0,0,2},
{3621,1342,0,0,2},{3622,1344,0,0,2},{3623,1346,0,0,2},{3624,1348,0,0,2},{3625,
1350,0,0,2},{3626,1352,0,0,2},{3627,1354,0,0,2},{3628,1356,0,0,2},{3629,1358,0,
0,2},{3630,1360,0,0,2},{3585,1362,0,0,2},{3586,1364,0,0,2},{3587,1366,0,0,2},
{3588,1368,0,0,2},{3589,1370,0,0,2},{3590,1372,0,0,2},{3591,1374,0,0,2},{3592,
1376,0,0,2},{3593,1378,0,0,2},{3594,1380,0,0,2},{3595,1382,0,0,2},{3596,1384,0,
0,2},{3597,1386,0,0,2},{3598,1388,0,0,2},{3599,1390,0,0,2},{3600,1392,0,0,2},
{3601,1394,0,0,2},{3602,1396,0,0,2},{3603,1398,0,0,2},{3604,1400,0,0,2},{3605,
1402,0,0,2},{3606,1404,0,0,2},{3607,1406,0,0,2},{3608,1408,0,0,2},{3609,1410,0,
0,2},{3610,1412,0,0,2},{3611,1414,0,0,2},{3612,1416,0,0,2},{3613,1418,0,0,2},
{3614,1420,0,0,2},{3615,1422,0,0,2},{3616,1424,0,0,2},{3617,1426,0,0,2},{3618,
1428,0,0,2},{3619,1430,0,0,2},{3620,1432,0,0,2},{3621,1434,0,0,2},{3622,1436,0,
0,2},{3623,1438,0,0,2},{3624,1440,0,0,2},{3625,1442,0,0,2},{3626,1444,0,0,2},
{3627,1446,0,0,2},{3628,1448,0,0,2},{3629,1450,0,0,2},{3630,1452,0,0,2},{3634,
1454,0,0,1},{3713,1455,0,0,2},{3714,1457,0,0,2},{3716,1459,0,0,2},{3718,1461,0,
0,2},{3719,1463,0,0,2},{3720,1465,0,0,2},{3721,1467,0,0,2},{3722,1469,0,0,2},
{3724,1471,0,0,2},{3725,1473,0,0,2},{3726,1475,0,0,2},{3727,1477,0,0,2},{3728,
1479,0,0,2},{3729,1481,0,0,2},{3730,1483,0,0,2},{3731,1485,0,0,2},{3732,1487,0,
0,2},{3733,1489,0,0,2},{3734,1491,0,0,2},{3735,1493,0,0,2},{3736,1495,0,0,2},
{3737,1497,0,0,2},{3738,1499,0,0,2},{3739,1501,0,0,2},{3740,1503,0,0,2},{3741,
1505,0,0,2},{3742,1507,0,0,2},{3743,1509,0,0,2},{3744,1511,0,0,2},{3745,1513,0,
0,2},{3746,1515,0,0,2},{3747,1517,0,0,2},{3749,1519,0,0,2},{3751,1521,0,0,2},
{3752,1523,0,0,2},{3753,1525,0,0,2},{3754,1527,0,0,2},{3755,1529,0,0,2},{3756,
1531,0,0,2},{3757,1533,0,0,2},{3758,1535,0,0,2},{3804,1537,0,0,3},{3805,1540,0,
0,3},{3806,1543,0,0,2},{3807,1545,0,0,2},{3713,1547,0,0,2},{3714,1549,0,0,2},
{3716,1551,0,0,2},{3718,1553,0,0,2},{3719,1555,0,0,2},{3720,1557,0,0,2},{3721,
1559,0,0,2},{3722,1561,0,0,2},{3724,1563,0,0,2},{3725,1565,0,0,2},{3726,1567,0,
0,2},{3727,1569,0,0,2},{3728,1571,0,0,2},{3729,1573,0,0,2},{3730,1575,0,0,2},
{3731,1577,0,0,2},{3732,1579,0,0,2},{3733,1581,0,0,2},{3734,1583,0,0,2},{3735,
1585,0,0,2},{3736,1587,0,0,2},{3737,1589,0,0,2},{3738,1591,0,0,2},{3739,1593,0,
0,2},{3740,1595,0,0,2},{3741,1597,0,0,2},{3742,1599,0,0,2},{3743,1601,0,0,2},
{3744,1603,0,0,2},{3745,1605,0,0,2},{3746,1607,0,0,2},{3747,1609,0,0,2},{3749,
1611,0,0,2},{3751,1613,0,0,2},{3752,1615,0,0,2},{3753,1617,0,0,2},{3754,1619,0,
0,2},{3755,1621,0,0,2},{3756,1623,0,0,2},{3757,1625,0,0,2},{3758,1627,0,0,2},
{3804,1629,0,0,3},{3805,1632,0,0,3},{3806,1635,0,0,2},{3807,1637,0,0,2},{3713,
1639,0,0,2},{3714,1641,0,0,2},{3716,1643,0,0,2},{3718,1645,0,0,2},{3719,1647,0,
0,2},{3720,1649,0,0,2},{3721,1651,0,0,2},{3722,1653,0,0,2},{3724,1655,0,0,2},
{3725,1657,0,0,2},{3726,1659,0,0,2},{3727,1661,0,0,2},{3728,1663,0,0,2},{3729,
1665,0,0,2},{3730,1667,0,0,2},{3731,1669,0,0,2},{3732,1671,0,0,2},{3733,1673,0,
0,2},{3734,1675,0,0,2},{3735,1677,0,0,2},{3736,1679,0,0,2},{3737,1681,0,0,2},
{3738,1683,0,0,2},{3739,1685,0,0,2},{3740,1687,0,0,2},{3741,1689,0,0,2},{3742,
1691,0,0,2},{3743,1693,0,0,2},{3744,1695,0,0,2},{3745,1697,0,0,2},{3746,1699,0,
0,2},{3747,1701,0,0,2},{3749,1703,0,0,2},{3751,1705,0,0,2},{3752,1707,0,0,2},
{3753,1709,0,0,2},{3754,1711,0,0,2},{3755,1713,0,0,2},{3756,1715,0,0,2},{3757,
1717,0,0,2},{3758,1719,0,0,2},{3804,1721,0,0,3},{3805,1724,0,0,3},{3806,1727,0,
0,2},{3807,1729,0,0,2},{3713,1731,0,0,2},{3714,1733,0,0,2},{3716,1735,0,0,2},
{3718,1737,0,0,2},{3719,1739,0,0,2},{3720,1741,0,0,2},{3721,1743,0,0,2},{3722,
1745,0,0,2},{3724,1747,0,0,2},{3725,1749,0,0,2},{3726,1751,0,0,2},{3727,1753,0,
0,2},{3728,1755,0,0,2},{3729,1757,0,0,2},{3730,1759,0,0,2},{3731,1761,0,0,2},
{3732,1763,0,0,2},{3733,1765,0,0,2},{3734,1767,0,0,2},{3735,1769,0,0,2},{3736,
1771,0,0,2},{3737,1773,0,0,2},{3738,1775,0,0,2},{3739,1777,0,0,2},{3740,1779,0,
0,2},{3741,1781,0,0,2},{3742,1783,0,0,2},{3743,1785,0,0,2},{3744,1787,0,0,2},
{3745,1789,0,0,2},{3746,1791,0,0,2},{3747,1793,0,0,2},{3749,1795,0,0,2},{3751,
1797,0,0,2},{3752,1799,0,0,2},{3753,1801,0,0,2},{3754,1803,0,0,2},{3755,1805,0,
0,2},{3756,1807,0,0,2},{3757,1809,0,0,2},{3758,1811,0,0,2},{3804,1813,0,0,3},
{3805,1816,0,0,3},{3806,1819,0,0,2},{3807,1821,0,0,2},{3713,1823,0,0,2},{3714,
1825,0,0,2},{3716,1827,0,0,2},{3718,1829,0,0,2},{3719,1831,0,0,2},{3720,1833,0,
0,2},{3721,1835,0,0,2},{3722,1837,0,0,2},{3724,1839,0,0,2},{3725,1841,0,0,2},
{3726,1843,0,0,2},{3727,1845,0,0,2},{3728,1847,0,0,2},{3729,1849,0,0,2},{3730,
1851,0,0,2},{3731,1853,0,0,2},{3732,1855,0,0,2},{3733,1857,0,0,2},{3734,1859,0,
0,2},{3735,1861,0,0,2},{3736,1863,0,0,2},{3737,1865,0,0,2},{3738,1867,0,0,2},
{3739,1869,0,0,2},{3740,1871,0,0,2},{3741,1873,0,0,2},{3742,1875,0,0,2},{3743,
1877,0,0,2},{3744,1879,0,0,2},{3745,1881,0,0,2},{3746,1883,0,0,2},{3747,1885,0,
0,2},{3749,1887,0,0,2},{3751,1889,0,0,2},{3752,1891,0,0,2},{3753,1893,0,0,2},
{3754,1895,0,0,2},{3755,1897,0,0,2},{3756,1899,0,0,2},{3757,1901,0,0,2},{3758,
1903,0,0,2},{3804,1905,0,0,3},{3805,1908,0,0,3},{3806,1911,0,0,2},{3807,1913,0,
0,2},{3762,1915,0,0,1},{4021,1923,0,0,2},{4023,1925,0,0,2},{4023,1927,0,0,2},
{4023,1929,0,0,2},{4023,1931,0,0,2},{4023,1933,0,0,2},{3954,1937,0,0,1},{3956,
1938,0,0,1},{3968,1939,0,0,1},{4021,1940,0,0,2},{4023,1942,0,0,2},{4023,1944,0,
0,2},{4023,1946,0,0,2},{4023,1948,0,0,2},{4023,1950,0,0,2},{3953,0,4358,1,0},
{3968,1952,0,0,1},{3968,1953,0,0,1},{3953,0,4361,1,0},{3968,1954,0,0,1},{3968,
1955,0,0,1},{6528,2051,0,0,2},{6529,2053,0,0,2},{6530,2055,0,0,2},{6531,2057,0,
0,2},{6532,2059,0,0,2},{6533,2061,0,0,2},{6534,2063,0,0,2},{6535,2065,0,0,2},
{6536,2067,0,0,2},{6537,2069,0,0,2},{6538,2071,0,0,2},{6539,2073,0,0,2},{6540,
2075,0,0,2},{6541,2077,0,0,2},{6542,2079,0,0,2},{6543,2081,0,0,2},{6544,2083,0,
0,2},{6545,2085,0,0,2},{6546,2087,0,0,2},{6547,2089,0,0,2},{6548,2091,0,0,2},
{6549,2093,0,0,2},{6550,2095,0,0,2},{6551,2097,0,0,2},{6552,2099,0,0,2},{6553,
2101,0,0,2},{6554,2103,0,0,2},{6555,2105,0,0,2},{6556,2107,0,0,2},{6557,2109,0,
0,2},{6558,2111,0,0,2},{6559,2113,0,0,2},{6560,2115,0,0,2},{6561,2117,0,0,2},
{6562,2119,0,0,2},{6563,2121,0,0,2},{6564,2123,0,0,2},{6565,2125,0,0,2},{6566,
2127,0,0,2},{6567,2129,0,0,2},{6568,2131,0,0,2},{6569,2133,0,0,2},{6570,2135,0,
0,2},{6571,2137,0,0,2},{6528,2139,0,0,2},{6529,2141,0,0,2},{6530,2143,0,0,2},
{6531,2145,0,0,2},{6532,2147,0,0,2},{6533,2149,0,0,2},{6534,2151,0,0,2},{6535,
2153,0,0,2},{6536,2155,0,0,2},{6537,2157,0,0,2},{6538,2159,0,0,2},{6539,2161,0,
0,2},{6540,2163,0,0,2},{6541,2165,0,0,2},{6542,2167,0,0,2},{6543,2169,0,0,2},
{6544,2171,0,0,2},{6545,2173,0,0,2},{6546,2175,0,0,2},{6547,2177,0,0,2},{6548,
2179,0,0,2},{6549,2181,0,0,2},{6550,2183,0,0,2},{6551,2185,0,0,2},{6552,2187,0,
0,2},{6553,2189,0,0,2},{6554,2191,0,0,2},{6555,2193,0,0,2},{6556,2195,0,0,2},
{6557,2197,0,0,2},{6558,2199,0,0,2},{6559,2201,0,0,2},{6560,2203,0,0,2},{6561,
2205,0,0,2},{6562,2207,0,0,2},{6563,2209,0,0,2},{6564,2211,0,0,2},{6565,2213,0,
0,2},{6566,2215,0,0,2},{6567,2217,0,0,2},{6568,2219,0,0,2},{6569,2221,0,0,2},
{6570,2223,0,0,2},{6571,2225,0,0,2},{6528,2227,0,0,2},{6529,2229,0,0,2},{6530,
2231,0,0,2},{6531,2233,0,0,2},{6532,2235,0,0,2},{6533,2237,0,0,2},{6534,2239,0,
0,2},{6535,2241,0,0,2},{6536,2243,0,0,2},{6537,2245,0,0,2},{6538,2247,0,0,2},
{6539,2249,0,0,2},{6540,2251,0,0,2},{6541,2253,0,0,2},{6542,2255,0,0,2},{6543,
2257,0,0,2},{6544,2259,0,0,2},{6545,2261,0,0,2},{6546,2263,0,0,2},{6547,2265,0,
0,2},{6548,2267,0,0,2},{6549,2269,0,0,2},{6550,2271,0,0,2},{6551,2273,0,0,2},
{6552,2275,0,0,2},{6553,2277,0,0,2},{6554,2279,0,0,2},{6555,2281,0,0,2},{6556,
2283,0,0,2},{6557,2285,0,0,2},{6558,2287,0,0,2},{6559,2289,0,0,2},{6560,2291,0,
0,2},{6561,2293,0,0,2},{6562,2295,0,0,2},{6563,2297,0,0,2},{6564,2299,0,0,2},
{6565,2301,0,0,2},{6566,2303,0,0,2},{6567,2305,0,0,2},{6568,2307,0,0,2},{6569,
2309,0,0,2},{6570,2311,0,0,2},{6571,2313,0,0,2},{6528,2315,0,0,2},{6529,2317,0,
0,2},{6530,2319,0,0,2},{6531,2321,0,0,2},{6532,2323,0,0,2},{6533,2325,0,0,2},
{6534,2327,0,0,2},{6535,2329,0,0,2},{6536,2331,0,0,2},{6537,2333,0,0,2},{6538,
2335,0,0,2},{6539,2337,0,0,2},{6540,2339,0,0,2},{6541,2341,0,0,2},{6542,2343,0,
0,2},{6543,2345,0,0,2},{6544,2347,0,0,2},{6545,2349,0,0,2},{6546,2351,0,0,2},
{6547,2353,0,0,2},{6548,2355,0,0,2},{6549,2357,0,0,2},{6550,2359,0,0,2},{6551,
2361,0,0,2},{6552,2363,0,0,2},{6553,2365,0,0,2},{6554,2367,0,0,2},{6555,2369,0,
0,2},{6556,2371,0,0,2},{6557,2373,0,0,2},{6558,2375,0,0,2},{6559,2377,0,0,2},
{6560,2379,0,0,2},{6561,2381,0,0,2},{6562,2383,0,0,2},{6563,2385,0,0,2},{6564,
2387,0,0,2},{6565,2389,0,0,2},{6566,2391,0,0,2},{6567,2393,0,0,2},{6568,2395,0,
0,2},{6569,2397,0,0,2},{6570,2399,0,0,2},{6571,2401,0,0,2},{824,4147,0,0,2},
{43648,8132,0,0,2},{43649,8134,0,0,2},{43650,8136,0,0,2},{43651,8138,0,0,2},
{43652,8140,0,0,2},{43653,8142,0,0,2},{43654,8144,0,0,2},{43655,8146,0,0,2},
{43656,8148,0,0,2},{43657,8150,0,0,2},{43658,8152,0,0,2},{43659,8154,0,0,2},
{43660,8156,0,0,2},{43661,8158,0,0,2},{43662,8160,0,0,2},{43663,8162,0,0,2},
{43664,8164,0,0,2},{43665,8166,0,0,2},{43666,8168,0,0,2},{43667,8170,0,0,2},
{43668,8172,0,0,2},{43669,8174,0,0,2},{43670,8176,0,0,2},{43671,8178,0,0,2},
{43672,8180,0,0,2},{43673,8182,0,0,2},{43674,8184,0,0,2},{43675,8186,0,0,2},
{43676,8188,0,0,2},{43677,8190,0,0,2},{43678,8192,0,0,2},{43679,8194,0,0,2},
{43680,8196,0,0,2},{43681,8198,0,0,2},{43682,8200,0,0,2},{43683,8202,0,0,2},
{43684,8204,0,0,2},{43685,8206,0,0,2},{43686,8208,0,0,2},{43687,8210,0,0,2},
{43688,8212,0,0,2},{43689,8214,0,0,2},{43690,8216,0,0,2},{43691,8218,0,0,2},
{43692,8220,0,0,2},{43693,8222,0,0,2},{43694,8224,0,0,2},{43695,8226,0,0,2},
{43648,8228,0,0,2},{43649,8230,0,0,2},{43650,8232,0,0,2},{43651,8234,0,0,2},
{43652,8236,0,0,2},{43653,8238,0,0,2},{43654,8240,0,0,2},{43655,8242,0,0,2},
{43656,8244,0,0,2},{43657,8246,0,0,2},{43658,8248,0,0,2},{43659,8250,0,0,2},
{43660,8252,0,0,2},{43661,8254,0,0,2},{43662,8256,0,0,2},{43663,8258,0,0,2},
{43664,8260,0,0,2},{43665,8262,0,0,2},{43666,8264,0,0,2},{43667,8266,0,0,2},
{43668,8268,0,0,2},{43669,8270,0,0,2},{43670,8272,0,0,2},{43671,8274,0,0,2},
{43672,8276,0,0,2},{43673,8278,0,0,2},{43674,8280,0,0,2},{43675,8282,0,0,2},
{43676,8284,0,0,2},{43677,8286,0,0,2},{43678,8288,0,0,2},{43679,8290,0,0,2},
{43680,8292,0,0,2},{43681,8294,0,0,2},{43682,8296,0,0,2},{43683,8298,0,0,2},
{43684,8300,0,0,2},{43685,8302,0,0,2},{43686,8304,0,0,2},{43687,8306,0,0,2},
{43688,8308,0,0,2},{43689,8310,0,0,2},{43690,8312,0,0,2},{43691,8314,0,0,2},
{43692,8316,0,0,2},{43693,8318,0,0,2},{43694,8320,0,0,2},{43695,8322,0,0,2},
{43648,8324,0,0,2},{43649,8326,0,0,2},{43650,8328,0,0,2},{43651,8330,0,0,2},
{43652,8332,0,0,2},{43653,8334,0,0,2},{43654,8336,0,0,2},{43655,8338,0,0,2},
{43656,8340,0,0,2},{43657,8342,0,0,2},{43658,8344,0,0,2},{43659,8346,0,0,2},
{43660,8348,0,0,2},{43661,8350,0,0,2},{43662,8352,0,0,2},{43663,8354,0,0,2},
{43664,8356,0,0,2},{43665,8358,0,0,2},{43666,8360,0,0,2},{43667,8362,0,0,2},
{43668,8364,0,0,2},{43669,8366,0,0,2},{43670,8368,0,0,2},{43671,8370,0,0,2},
{43672,8372,0,0,2},{43673,8374,0,0,2},{43674,8376,0,0,2},{43675,8378,0,0,2},
{43676,8380,0,0,2},{43677,8382,0,0,2},{43678,8384,0,0,2},{43679,8386,0,0,2},
{43680,8388,0,0,2},{43681,8390,0,0,2},{43682,8392,0,0,2},{43683,8394,0,0,2},
{43684,8396,0,0,2},{43685,8398,0,0,2},{43686,8400,0,0,2},{43687,8402,0,0,2},
{43688,8404,0,0,2},{43689,8406,0,0,2},{43690,8408,0,0,2},{43691,8410,0,0,2},
{43692,8412,0,0,2},{43693,8414,0,0,2},{43694,8416,0,0,2},{43695,8418,0,0,2},
{43648,8420,0,0,2},{43649,8422,0,0,2},{43650,8424,0,0,2},{43651,8426,0,0,2},
{43652,8428,0,0,2},{43653,8430,0,0,2},{43654,8432,0,0,2},{43655,8434,0,0,2},
{43656,8436,0,0,2},{43657,8438,0,0,2},{43658,8440,0,0,2},{43659,8442,0,0,2},
{43660,8444,0,0,2},{43661,8446,0,0,2},{43662,8448,0,0,2},{43663,8450,0,0,2},
{43664,8452,0,0,2},{43665,8454,0,0,2},{43666,8456,0,0,2},{43667,8458,0,0,2},
{43668,8460,0,0,2},{43669,8462,0,0,2},{43670,8464,0,0,2},{43671,8466,0,0,2},
{43672,8468,0,0,2},{43673,8470,0,0,2},{43674,8472,0,0,2},{43675,8474,0,0,2},
{43676,8476,0,0,2},{43677,8478,0,0,2},{43678,8480,0,0,2},{43679,8482,0,0,2},
{43680,8484,0,0,2},{43681,8486,0,0,2},{43682,8488,0,0,2},{43683,8490,0,0,2},
{43684,8492,0,0,2},{43685,8494,0,0,2},{43686,8496,0,0,2},{43687,8498,0,0,2},
{43688,8500,0,0,2},{43689,8502,0,0,2},{43690,8504,0,0,2},{43691,8506,0,0,2},
{43692,8508,0,0,2},{43693,8510,0,0,2},{43694,8512,0,0,2},{43695,8514,0,0,2},
{43648,8516,0,0,2},{43649,8518,0,0,2},{43650,8520,0,0,2},{43651,8522,0,0,2},
{43652,8524,0,0,2},{43653,8526,0,0,2},{43654,8528,0,0,2},{43655,8530,0,0,2},
{43656,8532,0,0,2},{43657,8534,0,0,2},{43658,8536,0,0,2},{43659,8538,0,0,2},
{43660,8540,0,0,2},{43661,8542,0,0,2},{43662,8544,0,0,2},{43663,8546,0,0,2},
{43664,8548,0,0,2},{43665,8550,0,0,2},{43666,8552,0,0,2},{43667,8554,0,0,2},
{43668,8556,0,0,2},{43669,8558,0,0,2},{43670,8560,0,0,2},{43671,8562,0,0,2},
{43672,8564,0,0,2},{43673,8566,0,0,2},{43674,8568,0,0,2},{43675,8570,0,0,2},
{43676,8572,0,0,2},{43677,8574,0,0,2},{43678,8576,0,0,2},{43679,8578,0,0,2},
{43680,8580,0,0,2},{43681,8582,0,0,2},{43682,8584,0,0,2},{43683,8586,0,0,2},
{43684,8588,0,0,2},{43685,8590,0,0,2},{43686,8592,0,0,2},{43687,8594,0,0,2},
{43688,8596,0,0,2},{43689,8598,0,0,2},{43690,8600,0,0,2},{43691,8602,0,0,2},
{43692,8604,0,0,2},{43693,8606,0,0,2},{43694,8608,0,0,2},{43695,8610,0,0,2},
{119141,9999,0,0,2},{119141,10001,4782,5,2},{119150,10003,0,0,3},{119151,10006,
0,0,3},{119152,10009,0,0,3},{119153,10012,0,0,3},{119154,10015,0,0,3},{119141,
10018,4788,2,2},{119150,10020,0,0,3},{119151,10023,0,0,3},{119141,10026,4791,2,
2},{119150,10028,0,0,3},{119151,10031,0,0,3}};

struct collation_key special_collation_keys[10631] = {
{8406,8,0,32},{0,2,0,280},{8406,2,0,32},{0,2,0,280},{8089,30,0,32},{1654,30,1,
32},{8092,30,0,32},{8089,30,0,32},{1654,30,1,32},{8090,30,0,32},{8091,30,0,32},
{1654,30,1,32},{8092,30,0,32},{8098,8,0,32},{0,2,0,37},{8098,8,0,32},{0,2,0,36},
{8098,8,0,32},{0,2,0,39},{8098,8,0,32},{0,2,0,45},{8098,8,0,32},{0,2,0,43},
{8098,8,0,32},{0,2,0,41},{8098,10,0,32},{0,4,0,280},{8199,10,0,32},{8150,8,0,
32},{0,2,0,48},{8199,8,0,32},{0,2,0,37},{8199,8,0,32},{0,2,0,36},{8199,8,0,32},
{0,2,0,39},{8199,8,0,32},{0,2,0,43},{8336,8,0,32},{0,2,0,37},{8336,8,0,32},{0,2,
0,36},{8336,8,0,32},{0,2,0,39},{8336,8,0,32},{0,2,0,43},{8171,10,0,32},{0,4,0,
280},{8472,8,0,32},{0,2,0,45},{8508,8,0,32},{0,2,0,37},{8508,8,0,32},{0,2,0,36},
{8508,8,0,32},{0,2,0,39},{8508,8,0,32},{0,2,0,45},{8508,8,0,32},{0,2,0,43},
{8508,8,0,32},{0,2,0,47},{8727,8,0,32},{0,2,0,37},{8727,8,0,32},{0,2,0,36},
{8727,8,0,32},{0,2,0,39},{8727,8,0,32},{0,2,0,43},{8816,8,0,32},{0,2,0,36},
{8658,4,0,32},{0,4,0,280},{8658,4,0,32},{8098,2,0,32},{0,2,0,37},{8098,2,0,32},
{0,2,0,36},{8098,2,0,32},{0,2,0,39},{8098,2,0,32},{0,2,0,45},{8098,2,0,32},{0,2,
0,43},{8098,2,0,32},{0,2,0,41},{8098,4,0,32},{0,4,0,280},{8199,4,0,32},{8150,2,
0,32},{0,2,0,48},{8199,2,0,32},{0,2,0,37},{8199,2,0,32},{0,2,0,36},{8199,2,0,
32},{0,2,0,39},{8199,2,0,32},{0,2,0,43},{8336,2,0,32},{0,2,0,37},{8336,2,0,32},
{0,2,0,36},{8336,2,0,32},{0,2,0,39},{8336,2,0,32},{0,2,0,43},{8171,4,0,32},{0,4,
0,280},{8472,2,0,32},{0,2,0,45},{8508,2,0,32},{0,2,0,37},{8508,2,0,32},{0,2,0,
36},{8508,2,0,32},{0,2,0,39},{8508,2,0,32},{0,2,0,45},{8508,2,0,32},{0,2,0,43},
{8508,2,0,32},{0,2,0,47},{8727,2,0,32},{0,2,0,37},{8727,2,0,32},{0,2,0,36},
{8727,2,0,32},{0,2,0,39},{8727,2,0,32},{0,2,0,43},{8816,2,0,32},{0,2,0,36},
{8816,2,0,32},{0,2,0,43},{8098,8,0,32},{0,2,0,50},{8098,2,0,32},{0,2,0,50},
{8098,8,0,32},{0,2,0,38},{8098,2,0,32},{0,2,0,38},{8098,8,0,32},{0,2,0,49},
{8098,2,0,32},{0,2,0,49},{8150,8,0,32},{0,2,0,36},{8150,2,0,32},{0,2,0,36},
{8150,8,0,32},{0,2,0,39},{8150,2,0,32},{0,2,0,39},{8150,8,0,32},{0,2,0,46},
{8150,2,0,32},{0,2,0,46},{8150,8,0,32},{0,2,0,40},{8150,2,0,32},{0,2,0,40},
{8171,8,0,32},{0,2,0,40},{8171,2,0,32},{0,2,0,40},{8171,8,0,32},{0,2,0,57},
{8171,2,0,32},{0,2,0,57},{8199,8,0,32},{0,2,0,50},{8199,2,0,32},{0,2,0,50},
{8199,8,0,32},{0,2,0,38},{8199,2,0,32},{0,2,0,38},{8199,8,0,32},{0,2,0,46},
{8199,2,0,32},{0,2,0,46},{8199,8,0,32},{0,2,0,49},{8199,2,0,32},{0,2,0,49},
{8199,8,0,32},{0,2,0,40},{8199,2,0,32},{0,2,0,40},{8273,8,0,32},{0,2,0,39},
{8273,2,0,32},{0,2,0,39},{8273,8,0,32},{0,2,0,38},{8273,2,0,32},{0,2,0,38},
{8273,8,0,32},{0,2,0,46},{8273,2,0,32},{0,2,0,46},{8273,8,0,32},{0,2,0,48},
{8273,2,0,32},{0,2,0,48},{8309,8,0,32},{0,2,0,39},{8309,2,0,32},{0,2,0,39},
{8309,8,0,32},{0,2,0,57},{8309,2,0,32},{0,2,0,57},{8336,8,0,32},{0,2,0,45},
{8336,2,0,32},{0,2,0,45},{8336,8,0,32},{0,2,0,50},{8336,2,0,32},{0,2,0,50},
{8336,8,0,32},{0,2,0,38},{8336,2,0,32},{0,2,0,38},{8336,8,0,32},{0,2,0,49},
{8336,2,0,32},{0,2,0,49},{8336,8,0,32},{0,2,0,46},{8336,10,0,32},{8363,10,0,32},
{8336,4,0,32},{8363,4,0,32},{8363,8,0,32},{0,2,0,39},{8363,2,0,32},{0,2,0,39},
{8388,8,0,32},{0,2,0,48},{8388,2,0,32},{0,2,0,48},{8406,8,0,32},{0,2,0,36},
{8406,2,0,32},{0,2,0,36},{8406,8,0,32},{0,2,0,48},{8406,2,0,32},{0,2,0,48},
{8406,8,0,32},{0,2,0,40},{8406,2,0,32},{0,2,0,40},{8406,8,0,32},{0,2,0,280},
{8406,2,0,32},{0,2,0,280},{8406,8,0,32},{0,2,0,57},{8406,2,0,32},{0,2,0,57},
{8472,8,0,32},{0,2,0,36},{8472,2,0,32},{0,2,0,36},{8472,8,0,32},{0,2,0,48},
{8472,2,0,32},{0,2,0,48},{8472,8,0,32},{0,2,0,40},{8472,2,0,32},{0,2,0,40},
{8931,4,0,32},{8472,4,0,32},{8508,8,0,32},{0,2,0,50},{8508,2,0,32},{0,2,0,50},
{8508,8,0,32},{0,2,0,38},{8508,2,0,32},{0,2,0,38},{8508,8,0,32},{0,2,0,44},
{8508,2,0,32},{0,2,0,44},{8508,10,0,32},{0,4,0,280},{8199,10,0,32},{8508,4,0,
32},{0,4,0,280},{8199,4,0,32},{8595,8,0,32},{0,2,0,36},{8595,2,0,32},{0,2,0,36},
{8595,8,0,32},{0,2,0,48},{8595,2,0,32},{0,2,0,48},{8595,8,0,32},{0,2,0,40},
{8595,2,0,32},{0,2,0,40},{8658,8,0,32},{0,2,0,36},{8658,2,0,32},{0,2,0,36},
{8658,8,0,32},{0,2,0,39},{8658,2,0,32},{0,2,0,39},{8658,8,0,32},{0,2,0,48},
{8658,2,0,32},{0,2,0,48},{8658,8,0,32},{0,2,0,40},{8658,2,0,32},{0,2,0,40},
{8695,8,0,32},{0,2,0,48},{8695,2,0,32},{0,2,0,48},{8695,8,0,32},{0,2,0,40},
{8695,2,0,32},{0,2,0,40},{8727,8,0,32},{0,2,0,45},{8727,2,0,32},{0,2,0,45},
{8727,8,0,32},{0,2,0,50},{8727,2,0,32},{0,2,0,50},{8727,8,0,32},{0,2,0,38},
{8727,2,0,32},{0,2,0,38},{8727,8,0,32},{0,2,0,41},{8727,2,0,32},{0,2,0,41},
{8727,8,0,32},{0,2,0,44},{8727,2,0,32},{0,2,0,44},{8727,8,0,32},{0,2,0,49},
{8727,2,0,32},{0,2,0,49},{8793,8,0,32},{0,2,0,39},{8793,2,0,32},{0,2,0,39},
{8816,8,0,32},{0,2,0,39},{8816,2,0,32},{0,2,0,39},{8816,8,0,32},{0,2,0,43},
{8838,8,0,32},{0,2,0,36},{8838,2,0,32},{0,2,0,36},{8838,8,0,32},{0,2,0,46},
{8838,2,0,32},{0,2,0,46},{8838,8,0,32},{0,2,0,40},{8838,2,0,32},{0,2,0,40},
{8658,4,0,32},{0,4,0,281},{8838,4,0,32},{8793,4,0,32},{8508,8,0,32},{0,2,0,63},
{8508,2,0,32},{0,2,0,63},{8727,8,0,32},{0,2,0,63},{8727,2,0,32},{0,2,0,63},
{8695,4,0,32},{8658,4,0,32},{8171,10,0,32},{8838,10,0,32},{0,4,0,40},{8171,10,0,
32},{8838,4,0,32},{0,4,0,40},{8171,4,0,32},{8838,4,0,32},{0,4,0,40},{8406,10,0,
32},{8363,10,0,32},{8406,10,0,32},{8363,4,0,32},{8406,4,0,32},{8363,4,0,32},
{8472,10,0,32},{8363,10,0,32},{8472,10,0,32},{8363,4,0,32},{8472,4,0,32},{8363,
4,0,32},{8098,8,0,32},{0,2,0,40},{8098,2,0,32},{0,2,0,40},{8336,8,0,32},{0,2,0,
40},{8336,2,0,32},{0,2,0,40},{8508,8,0,32},{0,2,0,40},{8508,2,0,32},{0,2,0,40},
{8727,8,0,32},{0,2,0,40},{8727,2,0,32},{0,2,0,40},{8727,8,0,32},{0,2,0,43},{0,2,
0,50},{8727,2,0,32},{0,2,0,43},{0,2,0,50},{8727,8,0,32},{0,2,0,43},{0,2,0,36},
{8727,2,0,32},{0,2,0,43},{0,2,0,36},{8727,8,0,32},{0,2,0,43},{0,2,0,40},{8727,2,
0,32},{0,2,0,43},{0,2,0,40},{8727,8,0,32},{0,2,0,43},{0,2,0,37},{8727,2,0,32},
{0,2,0,43},{0,2,0,37},{8098,8,0,32},{0,2,0,43},{0,2,0,50},{8098,2,0,32},{0,2,0,
43},{0,2,0,50},{8098,8,0,32},{0,2,0,46},{0,2,0,50},{8098,2,0,32},{0,2,0,46},{0,
2,0,50},{8098,10,0,32},{0,4,0,280},{8199,10,0,32},{0,2,0,50},{8098,4,0,32},{0,4,
0,280},{8199,4,0,32},{0,2,0,50},{8273,8,0,32},{0,2,0,40},{8273,2,0,32},{0,2,0,
40},{8388,8,0,32},{0,2,0,40},{8388,2,0,32},{0,2,0,40},{8508,8,0,32},{0,2,0,49},
{8508,2,0,32},{0,2,0,49},{8508,8,0,32},{0,2,0,49},{0,2,0,50},{8508,2,0,32},{0,2,
0,49},{0,2,0,50},{8867,8,0,32},{0,2,0,40},{8867,2,0,32},{0,2,0,40},{8363,2,0,
32},{0,2,0,40},{8171,10,0,32},{8838,10,0,32},{8171,10,0,32},{8838,4,0,32},{8171,
4,0,32},{8838,4,0,32},{8273,8,0,32},{0,2,0,36},{8273,2,0,32},{0,2,0,36},{8472,8,
0,32},{0,2,0,37},{8472,2,0,32},{0,2,0,37},{8098,8,0,32},{0,2,0,41},{0,2,0,36},
{8098,2,0,32},{0,2,0,41},{0,2,0,36},{8098,10,0,32},{0,4,0,280},{8199,10,0,32},
{0,2,0,36},{8098,4,0,32},{0,4,0,280},{8199,4,0,32},{0,2,0,36},{8508,8,0,32},{0,
2,0,47},{0,2,0,36},{8508,2,0,32},{0,2,0,47},{0,2,0,36},{8098,8,0,32},{0,2,0,60},
{8098,2,0,32},{0,2,0,60},{8098,8,0,32},{0,2,0,62},{8098,2,0,32},{0,2,0,62},
{8199,8,0,32},{0,2,0,60},{8199,2,0,32},{0,2,0,60},{8199,8,0,32},{0,2,0,62},
{8199,2,0,32},{0,2,0,62},{8336,8,0,32},{0,2,0,60},{8336,2,0,32},{0,2,0,60},
{8336,8,0,32},{0,2,0,62},{8336,2,0,32},{0,2,0,62},{8508,8,0,32},{0,2,0,60},
{8508,2,0,32},{0,2,0,60},{8508,8,0,32},{0,2,0,62},{8508,2,0,32},{0,2,0,62},
{8595,8,0,32},{0,2,0,60},{8595,2,0,32},{0,2,0,60},{8595,8,0,32},{0,2,0,62},
{8595,2,0,32},{0,2,0,62},{8727,8,0,32},{0,2,0,60},{8727,2,0,32},{0,2,0,60},
{8727,8,0,32},{0,2,0,62},{8727,2,0,32},{0,2,0,62},{8658,8,0,32},{0,2,0,69},
{8658,2,0,32},{0,2,0,69},{8695,8,0,32},{0,2,0,69},{8695,2,0,32},{0,2,0,69},
{8309,8,0,32},{0,2,0,40},{8309,2,0,32},{0,2,0,40},{8098,8,0,32},{0,2,0,46},
{8098,2,0,32},{0,2,0,46},{8199,8,0,32},{0,2,0,48},{8199,2,0,32},{0,2,0,48},
{8508,8,0,32},{0,2,0,43},{0,2,0,50},{8508,2,0,32},{0,2,0,43},{0,2,0,50},{8508,8,
0,32},{0,2,0,45},{0,2,0,50},{8508,2,0,32},{0,2,0,45},{0,2,0,50},{8508,8,0,32},
{0,2,0,46},{8508,2,0,32},{0,2,0,46},{8508,8,0,32},{0,2,0,46},{0,2,0,50},{8508,2,
0,32},{0,2,0,46},{0,2,0,50},{8816,8,0,32},{0,2,0,50},{8816,2,0,32},{0,2,0,50},
{8171,4,0,32},{8124,4,0,32},{8576,4,0,32},{8555,4,0,32},{8171,4,0,32},{8838,4,0,
32},{8171,4,0,32},{8867,4,0,32},{8171,4,0,32},{8857,4,0,32},{8695,4,0,32},{8658,
4,0,32},{8695,4,0,32},{8676,4,0,32},{8695,4,0,32},{8165,4,0,32},{8258,4,0,32},
{8503,4,0,32},{8406,4,0,32},{8658,4,0,32},{8406,4,0,32},{8838,4,0,32},{0,2,0,
43},{0,2,0,36},{1211,2,1,32},{0,2,0,36},{8990,8,0,32},{0,2,0,36},{8995,8,0,32},
{0,2,0,36},{9001,8,0,32},{0,2,0,36},{9003,8,0,32},{0,2,0,36},{9011,8,0,32},{0,2,
0,36},{9025,8,0,32},{0,2,0,36},{9030,8,0,32},{0,2,0,36},{9003,2,0,32},{0,2,0,
43},{0,2,0,36},{9003,8,0,32},{0,2,0,43},{9025,8,0,32},{0,2,0,43},{8990,2,0,32},
{0,2,0,36},{8995,2,0,32},{0,2,0,36},{9001,2,0,32},{0,2,0,36},{9003,2,0,32},{0,2,
0,36},{9025,2,0,32},{0,2,0,43},{0,2,0,36},{9003,2,0,32},{0,2,0,43},{9025,2,0,
32},{0,2,0,43},{9011,2,0,32},{0,2,0,36},{9025,2,0,32},{0,2,0,36},{9030,2,0,32},
{0,2,0,36},{9005,10,0,32},{8990,4,0,32},{9003,4,0,32},{9025,10,0,32},{0,2,0,36},
{9025,10,0,32},{0,2,0,43},{9005,4,0,32},{8990,4,0,32},{9003,4,0,32},{9151,8,0,
32},{0,2,0,37},{9151,8,0,32},{0,2,0,43},{9115,8,0,32},{0,2,0,36},{9197,8,0,32},
{0,2,0,43},{9211,8,0,32},{0,2,0,36},{9189,8,0,32},{0,2,0,37},{9346,8,0,32},{0,2,
0,38},{9151,2,0,32},{0,2,0,37},{9151,2,0,32},{0,2,0,43},{9115,2,0,32},{0,2,0,
36},{9197,2,0,32},{0,2,0,43},{9211,2,0,32},{0,2,0,36},{9189,2,0,32},{0,2,0,37},
{9346,2,0,32},{0,2,0,38},{9532,8,0,32},{0,2,0,60},{9532,2,0,32},{0,2,0,60},
{9115,10,0,32},{0,4,0,281},{9115,4,0,32},{0,4,0,281},{9159,8,0,32},{0,2,0,38},
{9159,2,0,32},{0,2,0,38},{9095,8,0,32},{0,2,0,38},{9095,2,0,32},{0,2,0,38},
{9095,8,0,32},{0,2,0,43},{9095,2,0,32},{0,2,0,43},{9151,8,0,32},{0,2,0,38},
{9151,2,0,32},{0,2,0,38},{9099,8,0,32},{0,2,0,43},{9099,2,0,32},{0,2,0,43},
{9159,8,0,32},{0,2,0,43},{9159,2,0,32},{0,2,0,43},{9169,8,0,32},{0,2,0,43},
{9169,2,0,32},{0,2,0,43},{9189,8,0,32},{0,2,0,50},{9189,2,0,32},{0,2,0,50},
{9189,8,0,32},{0,2,0,43},{9189,2,0,32},{0,2,0,43},{9292,8,0,32},{0,2,0,43},
{9292,2,0,32},{0,2,0,43},{9296,8,0,32},{0,2,0,43},{9296,2,0,32},{0,2,0,43},
{9482,8,0,32},{0,2,0,43},{9482,2,0,32},{0,2,0,43},{9346,8,0,32},{0,2,0,50},
{9346,2,0,32},{0,2,0,50},{9346,8,0,32},{0,2,0,43},{9346,2,0,32},{0,2,0,43},
{9346,8,0,32},{0,2,0,44},{9346,2,0,32},{0,2,0,44},{9417,8,0,32},{0,2,0,43},
{9417,2,0,32},{0,2,0,43},{9465,8,0,32},{0,2,0,43},{9465,2,0,32},{0,2,0,43},
{9722,4,0,32},{9752,4,0,32},{9758,2,0,32},{0,2,0,89},{9758,2,0,32},{0,2,0,90},
{9758,2,0,32},{0,2,0,95},{9759,2,0,32},{0,2,0,95},{9759,2,0,32},{0,2,0,96},
{9760,2,0,32},{0,2,0,95},{9761,2,0,32},{0,2,0,95},{9762,2,0,32},{0,2,0,95},
{9763,2,0,32},{0,2,0,91},{9763,2,0,32},{0,2,0,95},{9764,2,0,32},{0,2,0,95},
{9766,2,0,32},{0,2,0,95},{9767,2,0,32},{0,2,0,86},{9767,2,0,32},{0,2,0,95},
{9768,25,0,32},{0,2,0,95},{9768,2,0,32},{0,2,0,95},{9768,2,0,32},{0,2,0,96},
{9769,2,0,32},{0,2,0,95},{9770,2,0,32},{0,2,0,95},{9771,2,0,32},{0,2,0,95},
{9772,2,0,32},{0,2,0,95},{9774,25,0,32},{0,2,0,95},{9774,2,0,32},{0,2,0,95},
{9774,2,0,32},{0,2,0,96},{9775,2,0,32},{0,2,0,95},{9776,2,0,32},{0,2,0,95},
{9777,2,0,32},{0,2,0,95},{9778,2,0,32},{0,2,0,95},{9778,2,0,32},{0,2,0,95},{0,2,
0,94},{9778,2,0,32},{0,2,0,95},{0,2,0,93},{9778,2,0,32},{0,2,0,94},{9778,2,0,
32},{0,2,0,93},{9779,2,0,32},{0,2,0,95},{9767,4,0,32},{9762,4,0,32},{9763,4,0,
32},{9762,4,0,32},{9763,4,0,32},{9763,4,0,32},{9763,4,0,32},{9767,4,0,32},{9767,
4,0,32},{9767,4,0,32},{9767,4,0,32},{9767,4,0,32},{0,2,0,89},{9842,4,0,32},
{9828,4,0,32},{10024,4,0,32},{9828,4,0,32},{10028,4,0,32},{9828,4,0,32},{10039,
4,0,32},{9828,4,0,32},{10023,2,0,32},{0,2,0,131},{10020,2,0,32},{0,2,0,131},
{10053,2,0,32},{0,2,0,131},{9828,4,0,32},{0,4,0,281},{10004,4,0,32},{0,4,0,281},
{10058,4,0,32},{0,4,0,281},{10066,4,0,32},{0,4,0,281},{10076,4,0,32},{0,4,0,
281},{10057,4,0,32},{0,4,0,282},{10058,4,0,32},{0,4,0,282},{10060,4,0,32},{0,4,
0,282},{10181,4,0,32},{0,4,0,280},{10182,4,0,32},{0,4,0,280},{10184,4,0,32},{0,
4,0,280},{10739,2,0,32},{0,2,0,194},{10740,2,0,32},{0,2,0,194},{10741,2,0,32},
{0,2,0,194},{10747,2,0,32},{0,2,0,194},{10755,2,0,32},{0,2,0,194},{10757,2,0,
32},{0,2,0,194},{10763,2,0,32},{0,2,0,194},{10765,2,0,32},{0,2,0,194},{10770,2,
0,32},{0,2,0,194},{10772,2,0,32},{0,2,0,194},{10774,2,0,32},{0,2,0,194},{10840,
2,0,32},{0,2,0,194},{10841,2,0,32},{0,2,0,194},{10853,2,0,32},{0,2,0,194},
{10843,4,0,32},{10876,4,0,32},{10896,2,0,32},{0,2,0,194},{10897,2,0,32},{0,2,0,
194},{10902,2,0,32},{0,2,0,194},{10916,2,0,32},{0,2,0,194},{10923,2,0,32},{0,2,
0,194},{10892,2,0,32},{0,2,0,194},{11031,2,0,32},{0,2,0,194},{11032,2,0,32},{0,
2,0,194},{11314,4,0,32},{11343,4,0,32},{11312,4,0,32},{11343,4,0,32},{11313,4,0,
32},{11343,4,0,32},{11322,4,0,32},{11343,4,0,32},{11301,4,0,32},{11343,4,0,32},
{11306,4,0,32},{11343,4,0,32},{11314,4,0,32},{11343,4,0,32},{11315,4,0,32},
{11343,4,0,32},{11321,4,0,32},{11343,4,0,32},{11287,4,0,32},{11343,4,0,32},
{12823,2,0,32},{12881,2,0,32},{12824,2,0,32},{12881,2,0,32},{12825,2,0,32},
{12881,2,0,32},{12826,2,0,32},{12881,2,0,32},{12827,2,0,32},{12881,2,0,32},
{12828,2,0,32},{12881,2,0,32},{12829,2,0,32},{12881,2,0,32},{12830,2,0,32},
{12881,2,0,32},{12831,2,0,32},{12881,2,0,32},{12832,2,0,32},{12881,2,0,32},
{12833,2,0,32},{12881,2,0,32},{12834,2,0,32},{12881,2,0,32},{12835,2,0,32},
{12881,2,0,32},{12836,2,0,32},{12881,2,0,32},{12837,2,0,32},{12881,2,0,32},
{12838,2,0,32},{12881,2,0,32},{12839,2,0,32},{12881,2,0,32},{12840,2,0,32},
{12881,2,0,32},{12841,2,0,32},{12881,2,0,32},{12842,2,0,32},{12881,2,0,32},
{12843,2,0,32},{12881,2,0,32},{12844,2,0,32},{12881,2,0,32},{12845,2,0,32},
{12881,2,0,32},{12846,2,0,32},{12881,2,0,32},{12847,2,0,32},{12881,2,0,32},
{12848,2,0,32},{12881,2,0,32},{12849,2,0,32},{12881,2,0,32},{12850,2,0,32},
{12881,2,0,32},{12851,2,0,32},{12881,2,0,32},{12852,2,0,32},{12881,2,0,32},
{12853,2,0,32},{12881,2,0,32},{12854,2,0,32},{12881,2,0,32},{12855,2,0,32},
{12881,2,0,32},{12856,2,0,32},{12881,2,0,32},{12857,2,0,32},{12881,2,0,32},
{12858,2,0,32},{12881,2,0,32},{12859,2,0,32},{12881,2,0,32},{12860,2,0,32},
{12881,2,0,32},{12861,2,0,32},{12881,2,0,32},{12862,2,0,32},{12881,2,0,32},
{12863,2,0,32},{12881,2,0,32},{12864,2,0,32},{12881,2,0,32},{12865,2,0,32},
{12881,2,0,32},{12866,2,0,32},{12881,2,0,32},{12867,2,0,32},{12881,2,0,32},
{12868,2,0,32},{12881,2,0,32},{12823,2,0,32},{12882,2,0,32},{12824,2,0,32},
{12882,2,0,32},{12825,2,0,32},{12882,2,0,32},{12826,2,0,32},{12882,2,0,32},
{12827,2,0,32},{12882,2,0,32},{12828,2,0,32},{12882,2,0,32},{12829,2,0,32},
{12882,2,0,32},{12830,2,0,32},{12882,2,0,32},{12831,2,0,32},{12882,2,0,32},
{12832,2,0,32},{12882,2,0,32},{12833,2,0,32},{12882,2,0,32},{12834,2,0,32},
{12882,2,0,32},{12835,2,0,32},{12882,2,0,32},{12836,2,0,32},{12882,2,0,32},
{12837,2,0,32},{12882,2,0,32},{12838,2,0,32},{12882,2,0,32},{12839,2,0,32},
{12882,2,0,32},{12840,2,0,32},{12882,2,0,32},{12841,2,0,32},{12882,2,0,32},
{12842,2,0,32},{12882,2,0,32},{12843,2,0,32},{12882,2,0,32},{12844,2,0,32},
{12882,2,0,32},{12845,2,0,32},{12882,2,0,32},{12846,2,0,32},{12882,2,0,32},
{12847,2,0,32},{12882,2,0,32},{12848,2,0,32},{12882,2,0,32},{12849,2,0,32},
{12882,2,0,32},{12850,2,0,32},{12882,2,0,32},{12851,2,0,32},{12882,2,0,32},
{12852,2,0,32},{12882,2,0,32},{12853,2,0,32},{12882,2,0,32},{12854,2,0,32},
{12882,2,0,32},{12855,2,0,32},{12882,2,0,32},{12856,2,0,32},{12882,2,0,32},
{12857,2,0,32},{12882,2,0,32},{12858,2,0,32},{12882,2,0,32},{12859,2,0,32},
{12882,2,0,32},{12860,2,0,32},{12882,2,0,32},{12861,2,0,32},{12882,2,0,32},
{12862,2,0,32},{12882,2,0,32},{12863,2,0,32},{12882,2,0,32},{12864,2,0,32},
{12882,2,0,32},{12865,2,0,32},{12882,2,0,32},{12866,2,0,32},{12882,2,0,32},
{12867,2,0,32},{12882,2,0,32},{12868,2,0,32},{12882,2,0,32},{12823,2,0,32},
{12883,2,0,32},{12824,2,0,32},{12883,2,0,32},{12825,2,0,32},{12883,2,0,32},
{12826,2,0,32},{12883,2,0,32},{12827,2,0,32},{12883,2,0,32},{12828,2,0,32},
{12883,2,0,32},{12829,2,0,32},{12883,2,0,32},{12830,2,0,32},{12883,2,0,32},
{12831,2,0,32},{12883,2,0,32},{12832,2,0,32},{12883,2,0,32},{12833,2,0,32},
{12883,2,0,32},{12834,2,0,32},{12883,2,0,32},{12835,2,0,32},{12883,2,0,32},
{12836,2,0,32},{12883,2,0,32},{12837,2,0,32},{12883,2,0,32},{12838,2,0,32},
{12883,2,0,32},{12839,2,0,32},{12883,2,0,32},{12840,2,0,32},{12883,2,0,32},
{12841,2,0,32},{12883,2,0,32},{12842,2,0,32},{12883,2,0,32},{12843,2,0,32},
{12883,2,0,32},{12844,2,0,32},{12883,2,0,32},{12845,2,0,32},{12883,2,0,32},
{12846,2,0,32},{12883,2,0,32},{12847,2,0,32},{12883,2,0,32},{12848,2,0,32},
{12883,2,0,32},{12849,2,0,32},{12883,2,0,32},{12850,2,0,32},{12883,2,0,32},
{12851,2,0,32},{12883,2,0,32},{12852,2,0,32},{12883,2,0,32},{12853,2,0,32},
{12883,2,0,32},{12854,2,0,32},{12883,2,0,32},{12855,2,0,32},{12883,2,0,32},
{12856,2,0,32},{12883,2,0,32},{12857,2,0,32},{12883,2,0,32},{12858,2,0,32},
{12883,2,0,32},{12859,2,0,32},{12883,2,0,32},{12860,2,0,32},{12883,2,0,32},
{12861,2,0,32},{12883,2,0,32},{12862,2,0,32},{12883,2,0,32},{12863,2,0,32},
{12883,2,0,32},{12864,2,0,32},{12883,2,0,32},{12865,2,0,32},{12883,2,0,32},
{12866,2,0,32},{12883,2,0,32},{12867,2,0,32},{12883,2,0,32},{12868,2,0,32},
{12883,2,0,32},{12823,2,0,32},{12884,2,0,32},{12824,2,0,32},{12884,2,0,32},
{12825,2,0,32},{12884,2,0,32},{12826,2,0,32},{12884,2,0,32},{12827,2,0,32},
{12884,2,0,32},{12828,2,0,32},{12884,2,0,32},{12829,2,0,32},{12884,2,0,32},
{12830,2,0,32},{12884,2,0,32},{12831,2,0,32},{12884,2,0,32},{12832,2,0,32},
{12884,2,0,32},{12833,2,0,32},{12884,2,0,32},{12834,2,0,32},{12884,2,0,32},
{12835,2,0,32},{12884,2,0,32},{12836,2,0,32},{12884,2,0,32},{12837,2,0,32},
{12884,2,0,32},{12838,2,0,32},{12884,2,0,32},{12839,2,0,32},{12884,2,0,32},
{12840,2,0,32},{12884,2,0,32},{12841,2,0,32},{12884,2,0,32},{12842,2,0,32},
{12884,2,0,32},{12843,2,0,32},{12884,2,0,32},{12844,2,0,32},{12884,2,0,32},
{12845,2,0,32},{12884,2,0,32},{12846,2,0,32},{12884,2,0,32},{12847,2,0,32},
{12884,2,0,32},{12848,2,0,32},{12884,2,0,32},{12849,2,0,32},{12884,2,0,32},
{12850,2,0,32},{12884,2,0,32},{12851,2,0,32},{12884,2,0,32},{12852,2,0,32},
{12884,2,0,32},{12853,2,0,32},{12884,2,0,32},{12854,2,0,32},{12884,2,0,32},
{12855,2,0,32},{12884,2,0,32},{12856,2,0,32},{12884,2,0,32},{12857,2,0,32},
{12884,2,0,32},{12858,2,0,32},{12884,2,0,32},{12859,2,0,32},{12884,2,0,32},
{12860,2,0,32},{12884,2,0,32},{12861,2,0,32},{12884,2,0,32},{12862,2,0,32},
{12884,2,0,32},{12863,2,0,32},{12884,2,0,32},{12864,2,0,32},{12884,2,0,32},
{12865,2,0,32},{12884,2,0,32},{12866,2,0,32},{12884,2,0,32},{12867,2,0,32},
{12884,2,0,32},{12868,2,0,32},{12884,2,0,32},{12823,2,0,32},{12885,2,0,32},
{12824,2,0,32},{12885,2,0,32},{12825,2,0,32},{12885,2,0,32},{12826,2,0,32},
{12885,2,0,32},{12827,2,0,32},{12885,2,0,32},{12828,2,0,32},{12885,2,0,32},
{12829,2,0,32},{12885,2,0,32},{12830,2,0,32},{12885,2,0,32},{12831,2,0,32},
{12885,2,0,32},{12832,2,0,32},{12885,2,0,32},{12833,2,0,32},{12885,2,0,32},
{12834,2,0,32},{12885,2,0,32},{12835,2,0,32},{12885,2,0,32},{12836,2,0,32},
{12885,2,0,32},{12837,2,0,32},{12885,2,0,32},{12838,2,0,32},{12885,2,0,32},
{12839,2,0,32},{12885,2,0,32},{12840,2,0,32},{12885,2,0,32},{12841,2,0,32},
{12885,2,0,32},{12842,2,0,32},{12885,2,0,32},{12843,2,0,32},{12885,2,0,32},
{12844,2,0,32},{12885,2,0,32},{12845,2,0,32},{12885,2,0,32},{12846,2,0,32},
{12885,2,0,32},{12847,2,0,32},{12885,2,0,32},{12848,2,0,32},{12885,2,0,32},
{12849,2,0,32},{12885,2,0,32},{12850,2,0,32},{12885,2,0,32},{12851,2,0,32},
{12885,2,0,32},{12852,2,0,32},{12885,2,0,32},{12853,2,0,32},{12885,2,0,32},
{12854,2,0,32},{12885,2,0,32},{12855,2,0,32},{12885,2,0,32},{12856,2,0,32},
{12885,2,0,32},{12857,2,0,32},{12885,2,0,32},{12858,2,0,32},{12885,2,0,32},
{12859,2,0,32},{12885,2,0,32},{12860,2,0,32},{12885,2,0,32},{12861,2,0,32},
{12885,2,0,32},{12862,2,0,32},{12885,2,0,32},{12863,2,0,32},{12885,2,0,32},
{12864,2,0,32},{12885,2,0,32},{12865,2,0,32},{12885,2,0,32},{12866,2,0,32},
{12885,2,0,32},{12867,2,0,32},{12885,2,0,32},{12868,2,0,32},{12885,2,0,32},
{12873,2,0,32},{12888,2,0,32},{12945,2,0,32},{12889,2,0,32},{12945,2,0,32},
{12890,2,0,32},{12945,2,0,32},{12891,2,0,32},{12945,2,0,32},{12892,2,0,32},
{12945,2,0,32},{12893,2,0,32},{12945,2,0,32},{12894,2,0,32},{12945,2,0,32},
{12896,2,0,32},{12945,2,0,32},{12897,2,0,32},{12945,2,0,32},{12900,2,0,32},
{12945,2,0,32},{12898,2,0,32},{12945,2,0,32},{12901,2,0,32},{12945,2,0,32},
{12902,2,0,32},{12945,2,0,32},{12903,2,0,32},{12945,2,0,32},{12904,2,0,32},
{12945,2,0,32},{12905,2,0,32},{12945,2,0,32},{12906,2,0,32},{12945,2,0,32},
{12907,2,0,32},{12945,2,0,32},{12908,2,0,32},{12945,2,0,32},{12909,2,0,32},
{12945,2,0,32},{12910,2,0,32},{12945,2,0,32},{12911,2,0,32},{12945,2,0,32},
{12912,2,0,32},{12945,2,0,32},{12913,2,0,32},{12945,2,0,32},{12914,2,0,32},
{12945,2,0,32},{12915,2,0,32},{12945,2,0,32},{12916,2,0,32},{12945,2,0,32},
{12917,2,0,32},{12945,2,0,32},{12918,2,0,32},{12945,2,0,32},{12919,2,0,32},
{12945,2,0,32},{12920,2,0,32},{12945,2,0,32},{12921,2,0,32},{12945,2,0,32},
{12922,2,0,32},{12945,2,0,32},{12923,2,0,32},{12945,2,0,32},{12924,2,0,32},
{12945,2,0,32},{12925,2,0,32},{12945,2,0,32},{12895,2,0,32},{12945,2,0,32},
{12926,2,0,32},{12945,2,0,32},{12927,2,0,32},{12945,2,0,32},{12928,2,0,32},
{12945,2,0,32},{12929,2,0,32},{12945,2,0,32},{12926,4,0,32},{12911,4,0,32},
{12945,2,0,32},{12926,4,0,32},{12919,4,0,32},{12945,2,0,32},{12887,2,0,32},
{12945,2,0,32},{12899,2,0,32},{12945,2,0,32},{12888,2,0,32},{12946,2,0,32},
{12889,2,0,32},{12946,2,0,32},{12890,2,0,32},{12946,2,0,32},{12891,2,0,32},
{12946,2,0,32},{12892,2,0,32},{12946,2,0,32},{12893,2,0,32},{12946,2,0,32},
{12894,2,0,32},{12946,2,0,32},{12896,2,0,32},{12946,2,0,32},{12897,2,0,32},
{12946,2,0,32},{12900,2,0,32},{12946,2,0,32},{12898,2,0,32},{12946,2,0,32},
{12901,2,0,32},{12946,2,0,32},{12902,2,0,32},{12946,2,0,32},{12903,2,0,32},
{12946,2,0,32},{12904,2,0,32},{12946,2,0,32},{12905,2,0,32},{12946,2,0,32},
{12906,2,0,32},{12946,2,0,32},{12907,2,0,32},{12946,2,0,32},{12908,2,0,32},
{12946,2,0,32},{12909,2,0,32},{12946,2,0,32},{12910,2,0,32},{12946,2,0,32},
{12911,2,0,32},{12946,2,0,32},{12912,2,0,32},{12946,2,0,32},{12913,2,0,32},
{12946,2,0,32},{12914,2,0,32},{12946,2,0,32},{12915,2,0,32},{12946,2,0,32},
{12916,2,0,32},{12946,2,0,32},{12917,2,0,32},{12946,2,0,32},{12918,2,0,32},
{12946,2,0,32},{12919,2,0,32},{12946,2,0,32},{12920,2,0,32},{12946,2,0,32},
{12921,2,0,32},{12946,2,0,32},{12922,2,0,32},{12946,2,0,32},{12923,2,0,32},
{12946,2,0,32},{12924,2,0,32},{12946,2,0,32},{12925,2,0,32},{12946,2,0,32},
{12895,2,0,32},{12946,2,0,32},{12926,2,0,32},{12946,2,0,32},{12927,2,0,32},
{12946,2,0,32},{12928,2,0,32},{12946,2,0,32},{12929,2,0,32},{12946,2,0,32},
{12926,4,0,32},{12911,4,0,32},{12946,2,0,32},{12926,4,0,32},{12919,4,0,32},
{12946,2,0,32},{12887,2,0,32},{12946,2,0,32},{12899,2,0,32},{12946,2,0,32},
{12888,2,0,32},{12947,2,0,32},{12889,2,0,32},{12947,2,0,32},{12890,2,0,32},
{12947,2,0,32},{12891,2,0,32},{12947,2,0,32},{12892,2,0,32},{12947,2,0,32},
{12893,2,0,32},{12947,2,0,32},{12894,2,0,32},{12947,2,0,32},{12896,2,0,32},
{12947,2,0,32},{12897,2,0,32},{12947,2,0,32},{12900,2,0,32},{12947,2,0,32},
{12898,2,0,32},{12947,2,0,32},{12901,2,0,32},{12947,2,0,32},{12902,2,0,32},
{12947,2,0,32},{12903,2,0,32},{12947,2,0,32},{12904,2,0,32},{12947,2,0,32},
{12905,2,0,32},{12947,2,0,32},{12906,2,0,32},{12947,2,0,32},{12907,2,0,32},
{12947,2,0,32},{12908,2,0,32},{12947,2,0,32},{12909,2,0,32},{12947,2,0,32},
{12910,2,0,32},{12947,2,0,32},{12911,2,0,32},{12947,2,0,32},{12912,2,0,32},
{12947,2,0,32},{12913,2,0,32},{12947,2,0,32},{12914,2,0,32},{12947,2,0,32},
{12915,2,0,32},{12947,2,0,32},{12916,2,0,32},{12947,2,0,32},{12917,2,0,32},
{12947,2,0,32},{12918,2,0,32},{12947,2,0,32},{12919,2,0,32},{12947,2,0,32},
{12920,2,0,32},{12947,2,0,32},{12921,2,0,32},{12947,2,0,32},{12922,2,0,32},
{12947,2,0,32},{12923,2,0,32},{12947,2,0,32},{12924,2,0,32},{12947,2,0,32},
{12925,2,0,32},{12947,2,0,32},{12895,2,0,32},{12947,2,0,32},{12926,2,0,32},
{12947,2,0,32},{12927,2,0,32},{12947,2,0,32},{12928,2,0,32},{12947,2,0,32},
{12929,2,0,32},{12947,2,0,32},{12926,4,0,32},{12911,4,0,32},{12947,2,0,32},
{12926,4,0,32},{12919,4,0,32},{12947,2,0,32},{12887,2,0,32},{12947,2,0,32},
{12899,2,0,32},{12947,2,0,32},{12888,2,0,32},{12948,2,0,32},{12889,2,0,32},
{12948,2,0,32},{12890,2,0,32},{12948,2,0,32},{12891,2,0,32},{12948,2,0,32},
{12892,2,0,32},{12948,2,0,32},{12893,2,0,32},{12948,2,0,32},{12894,2,0,32},
{12948,2,0,32},{12896,2,0,32},{12948,2,0,32},{12897,2,0,32},{12948,2,0,32},
{12900,2,0,32},{12948,2,0,32},{12898,2,0,32},{12948,2,0,32},{12901,2,0,32},
{12948,2,0,32},{12902,2,0,32},{12948,2,0,32},{12903,2,0,32},{12948,2,0,32},
{12904,2,0,32},{12948,2,0,32},{12905,2,0,32},{12948,2,0,32},{12906,2,0,32},
{12948,2,0,32},{12907,2,0,32},{12948,2,0,32},{12908,2,0,32},{12948,2,0,32},
{12909,2,0,32},{12948,2,0,32},{12910,2,0,32},{12948,2,0,32},{12911,2,0,32},
{12948,2,0,32},{12912,2,0,32},{12948,2,0,32},{12913,2,0,32},{12948,2,0,32},
{12914,2,0,32},{12948,2,0,32},{12915,2,0,32},{12948,2,0,32},{12916,2,0,32},
{12948,2,0,32},{12917,2,0,32},{12948,2,0,32},{12918,2,0,32},{12948,2,0,32},
{12919,2,0,32},{12948,2,0,32},{12920,2,0,32},{12948,2,0,32},{12921,2,0,32},
{12948,2,0,32},{12922,2,0,32},{12948,2,0,32},{12923,2,0,32},{12948,2,0,32},
{12924,2,0,32},{12948,2,0,32},{12925,2,0,32},{12948,2,0,32},{12895,2,0,32},
{12948,2,0,32},{12926,2,0,32},{12948,2,0,32},{12927,2,0,32},{12948,2,0,32},
{12928,2,0,32},{12948,2,0,32},{12929,2,0,32},{12948,2,0,32},{12926,4,0,32},
{12911,4,0,32},{12948,2,0,32},{12926,4,0,32},{12919,4,0,32},{12948,2,0,32},
{12887,2,0,32},{12948,2,0,32},{12899,2,0,32},{12948,2,0,32},{12888,2,0,32},
{12949,2,0,32},{12889,2,0,32},{12949,2,0,32},{12890,2,0,32},{12949,2,0,32},
{12891,2,0,32},{12949,2,0,32},{12892,2,0,32},{12949,2,0,32},{12893,2,0,32},
{12949,2,0,32},{12894,2,0,32},{12949,2,0,32},{12896,2,0,32},{12949,2,0,32},
{12897,2,0,32},{12949,2,0,32},{12900,2,0,32},{12949,2,0,32},{12898,2,0,32},
{12949,2,0,32},{12901,2,0,32},{12949,2,0,32},{12902,2,0,32},{12949,2,0,32},
{12903,2,0,32},{12949,2,0,32},{12904,2,0,32},{12949,2,0,32},{12905,2,0,32},
{12949,2,0,32},{12906,2,0,32},{12949,2,0,32},{12907,2,0,32},{12949,2,0,32},
{12908,2,0,32},{12949,2,0,32},{12909,2,0,32},{12949,2,0,32},{12910,2,0,32},
{12949,2,0,32},{12911,2,0,32},{12949,2,0,32},{12912,2,0,32},{12949,2,0,32},
{12913,2,0,32},{12949,2,0,32},{12914,2,0,32},{12949,2,0,32},{12915,2,0,32},
{12949,2,0,32},{12916,2,0,32},{12949,2,0,32},{12917,2,0,32},{12949,2,0,32},
{12918,2,0,32},{12949,2,0,32},{12919,2,0,32},{12949,2,0,32},{12920,2,0,32},
{12949,2,0,32},{12921,2,0,32},{12949,2,0,32},{12922,2,0,32},{12949,2,0,32},
{12923,2,0,32},{12949,2,0,32},{12924,2,0,32},{12949,2,0,32},{12925,2,0,32},
{12949,2,0,32},{12895,2,0,32},{12949,2,0,32},{12926,2,0,32},{12949,2,0,32},
{12927,2,0,32},{12949,2,0,32},{12928,2,0,32},{12949,2,0,32},{12929,2,0,32},
{12949,2,0,32},{12926,4,0,32},{12911,4,0,32},{12949,2,0,32},{12926,4,0,32},
{12919,4,0,32},{12949,2,0,32},{12887,2,0,32},{12949,2,0,32},{12899,2,0,32},
{12949,2,0,32},{12934,2,0,32},{12926,4,0,32},{12911,4,0,32},{12926,4,0,32},
{12919,4,0,32},{13087,4,0,32},{13110,4,0,32},{0,4,0,196},{13017,2,0,32},{13082,
2,0,32},{13022,2,0,32},{13086,2,0,32},{13038,2,0,32},{13086,2,0,32},{13046,2,0,
32},{13086,2,0,32},{13054,2,0,32},{13086,2,0,32},{13062,2,0,32},{13086,2,0,32},
{13074,4,0,32},{0,4,0,281},{13099,2,0,32},{13103,2,0,32},{13101,2,0,32},{13018,
2,0,32},{13082,2,0,32},{13023,2,0,32},{13086,2,0,32},{13039,2,0,32},{13086,2,0,
32},{13047,2,0,32},{13086,2,0,32},{13055,2,0,32},{13086,2,0,32},{13063,2,0,32},
{13086,2,0,32},{13105,2,0,32},{13104,2,0,32},{13107,2,0,32},{13106,2,0,32},
{13065,4,0,32},{0,4,0,281},{13073,4,0,32},{0,4,0,281},{13075,4,0,32},{0,4,0,
281},{13769,4,0,32},{13826,4,0,32},{13769,4,0,32},{15413,4,0,32},{0,4,0,280},
{15414,4,0,32},{0,4,0,280},{15414,4,0,32},{0,4,0,281},{15415,4,0,32},{0,4,0,
280},{15416,4,0,32},{0,4,0,280},{15416,4,0,32},{0,4,0,281},{15416,4,0,32},{0,4,
0,282},{15416,4,0,32},{0,4,0,283},{15421,4,0,32},{0,4,0,280},{15421,4,0,32},{0,
4,0,281},{15421,4,0,32},{0,4,0,282},{15421,4,0,32},{0,4,0,283},{15425,4,0,32},
{0,4,0,280},{15425,4,0,32},{0,4,0,281},{15425,4,0,32},{0,4,0,282},{15426,4,0,
32},{0,4,0,280},{15426,4,0,32},{0,4,0,281},{15427,4,0,32},{0,4,0,280},{15429,4,
0,32},{0,4,0,280},{15430,4,0,32},{0,4,0,280},{15434,4,0,32},{0,4,0,280},{15434,
4,0,32},{0,4,0,282},{15434,4,0,32},{0,4,0,283},{15434,4,0,32},{0,4,0,284},
{15436,4,0,32},{0,4,0,280},{15436,4,0,32},{0,4,0,281},{15437,4,0,32},{0,4,0,
280},{15437,4,0,32},{0,4,0,281},{15432,4,0,32},{0,4,0,280},{15440,4,0,32},{0,4,
0,280},{15440,4,0,32},{0,4,0,281},{15441,4,0,32},{0,4,0,280},{15442,4,0,32},{0,
4,0,280},{15458,4,0,32},{0,4,0,280},{15458,4,0,32},{0,4,0,281},{15424,4,0,32},
{0,4,0,280},{15434,4,0,32},{0,4,0,281},{15430,4,0,32},{15441,4,0,32},{15440,4,0,
32},{0,4,0,280},{15440,4,0,32},{0,4,0,280},{15415,4,0,32},{15415,4,0,32},{13404,
4,0,32},{13434,4,0,32},{13407,4,0,32},{13435,4,0,32},{14046,2,0,32},{14095,2,0,
32},{14047,2,0,32},{14095,2,0,32},{14048,2,0,32},{14095,2,0,32},{14049,2,0,32},
{14095,2,0,32},{14050,2,0,32},{14095,2,0,32},{14051,2,0,32},{14095,2,0,32},
{14052,2,0,32},{14095,2,0,32},{14053,2,0,32},{14095,2,0,32},{14054,2,0,32},
{14095,2,0,32},{14055,2,0,32},{14095,2,0,32},{14056,2,0,32},{14095,2,0,32},
{14057,2,0,32},{14095,2,0,32},{14058,2,0,32},{14095,2,0,32},{14059,2,0,32},
{14095,2,0,32},{14060,2,0,32},{14095,2,0,32},{14061,2,0,32},{14095,2,0,32},
{14062,2,0,32},{14095,2,0,32},{14063,2,0,32},{14095,2,0,32},{14064,2,0,32},
{14095,2,0,32},{14065,2,0,32},{14095,2,0,32},{14066,2,0,32},{14095,2,0,32},
{14067,2,0,32},{14095,2,0,32},{14068,2,0,32},{14095,2,0,32},{14069,2,0,32},
{14095,2,0,32},{14070,2,0,32},{14095,2,0,32},{14071,2,0,32},{14095,2,0,32},
{14072,2,0,32},{14095,2,0,32},{14073,2,0,32},{14095,2,0,32},{14074,2,0,32},
{14095,2,0,32},{14075,2,0,32},{14095,2,0,32},{14076,2,0,32},{14095,2,0,32},
{14077,2,0,32},{14095,2,0,32},{14078,2,0,32},{14095,2,0,32},{14079,2,0,32},
{14095,2,0,32},{14080,2,0,32},{14095,2,0,32},{14081,2,0,32},{14095,2,0,32},
{14082,2,0,32},{14095,2,0,32},{14083,2,0,32},{14095,2,0,32},{14084,2,0,32},
{14095,2,0,32},{14085,2,0,32},{14095,2,0,32},{14086,2,0,32},{14095,2,0,32},
{14087,2,0,32},{14095,2,0,32},{14088,2,0,32},{14095,2,0,32},{14089,2,0,32},
{14095,2,0,32},{14046,2,0,32},{14096,2,0,32},{14047,2,0,32},{14096,2,0,32},
{14048,2,0,32},{14096,2,0,32},{14049,2,0,32},{14096,2,0,32},{14050,2,0,32},
{14096,2,0,32},{14051,2,0,32},{14096,2,0,32},{14052,2,0,32},{14096,2,0,32},
{14053,2,0,32},{14096,2,0,32},{14054,2,0,32},{14096,2,0,32},{14055,2,0,32},
{14096,2,0,32},{14056,2,0,32},{14096,2,0,32},{14057,2,0,32},{14096,2,0,32},
{14058,2,0,32},{14096,2,0,32},{14059,2,0,32},{14096,2,0,32},{14060,2,0,32},
{14096,2,0,32},{14061,2,0,32},{14096,2,0,32},{14062,2,0,32},{14096,2,0,32},
{14063,2,0,32},{14096,2,0,32},{14064,2,0,32},{14096,2,0,32},{14065,2,0,32},
{14096,2,0,32},{14066,2,0,32},{14096,2,0,32},{14067,2,0,32},{14096,2,0,32},
{14068,2,0,32},{14096,2,0,32},{14069,2,0,32},{14096,2,0,32},{14070,2,0,32},
{14096,2,0,32},{14071,2,0,32},{14096,2,0,32},{14072,2,0,32},{14096,2,0,32},
{14073,2,0,32},{14096,2,0,32},{14074,2,0,32},{14096,2,0,32},{14075,2,0,32},
{14096,2,0,32},{14076,2,0,32},{14096,2,0,32},{14077,2,0,32},{14096,2,0,32},
{14078,2,0,32},{14096,2,0,32},{14079,2,0,32},{14096,2,0,32},{14080,2,0,32},
{14096,2,0,32},{14081,2,0,32},{14096,2,0,32},{14082,2,0,32},{14096,2,0,32},
{14083,2,0,32},{14096,2,0,32},{14084,2,0,32},{14096,2,0,32},{14085,2,0,32},
{14096,2,0,32},{14086,2,0,32},{14096,2,0,32},{14087,2,0,32},{14096,2,0,32},
{14088,2,0,32},{14096,2,0,32},{14089,2,0,32},{14096,2,0,32},{14046,2,0,32},
{14097,2,0,32},{14047,2,0,32},{14097,2,0,32},{14048,2,0,32},{14097,2,0,32},
{14049,2,0,32},{14097,2,0,32},{14050,2,0,32},{14097,2,0,32},{14051,2,0,32},
{14097,2,0,32},{14052,2,0,32},{14097,2,0,32},{14053,2,0,32},{14097,2,0,32},
{14054,2,0,32},{14097,2,0,32},{14055,2,0,32},{14097,2,0,32},{14056,2,0,32},
{14097,2,0,32},{14057,2,0,32},{14097,2,0,32},{14058,2,0,32},{14097,2,0,32},
{14059,2,0,32},{14097,2,0,32},{14060,2,0,32},{14097,2,0,32},{14061,2,0,32},
{14097,2,0,32},{14062,2,0,32},{14097,2,0,32},{14063,2,0,32},{14097,2,0,32},
{14064,2,0,32},{14097,2,0,32},{14065,2,0,32},{14097,2,0,32},{14066,2,0,32},
{14097,2,0,32},{14067,2,0,32},{14097,2,0,32},{14068,2,0,32},{14097,2,0,32},
{14069,2,0,32},{14097,2,0,32},{14070,2,0,32},{14097,2,0,32},{14071,2,0,32},
{14097,2,0,32},{14072,2,0,32},{14097,2,0,32},{14073,2,0,32},{14097,2,0,32},
{14074,2,0,32},{14097,2,0,32},{14075,2,0,32},{14097,2,0,32},{14076,2,0,32},
{14097,2,0,32},{14077,2,0,32},{14097,2,0,32},{14078,2,0,32},{14097,2,0,32},
{14079,2,0,32},{14097,2,0,32},{14080,2,0,32},{14097,2,0,32},{14081,2,0,32},
{14097,2,0,32},{14082,2,0,32},{14097,2,0,32},{14083,2,0,32},{14097,2,0,32},
{14084,2,0,32},{14097,2,0,32},{14085,2,0,32},{14097,2,0,32},{14086,2,0,32},
{14097,2,0,32},{14087,2,0,32},{14097,2,0,32},{14088,2,0,32},{14097,2,0,32},
{14089,2,0,32},{14097,2,0,32},{14046,2,0,32},{14100,2,0,32},{14047,2,0,32},
{14100,2,0,32},{14048,2,0,32},{14100,2,0,32},{14049,2,0,32},{14100,2,0,32},
{14050,2,0,32},{14100,2,0,32},{14051,2,0,32},{14100,2,0,32},{14052,2,0,32},
{14100,2,0,32},{14053,2,0,32},{14100,2,0,32},{14054,2,0,32},{14100,2,0,32},
{14055,2,0,32},{14100,2,0,32},{14056,2,0,32},{14100,2,0,32},{14057,2,0,32},
{14100,2,0,32},{14058,2,0,32},{14100,2,0,32},{14059,2,0,32},{14100,2,0,32},
{14060,2,0,32},{14100,2,0,32},{14061,2,0,32},{14100,2,0,32},{14062,2,0,32},
{14100,2,0,32},{14063,2,0,32},{14100,2,0,32},{14064,2,0,32},{14100,2,0,32},
{14065,2,0,32},{14100,2,0,32},{14066,2,0,32},{14100,2,0,32},{14067,2,0,32},
{14100,2,0,32},{14068,2,0,32},{14100,2,0,32},{14069,2,0,32},{14100,2,0,32},
{14070,2,0,32},{14100,2,0,32},{14071,2,0,32},{14100,2,0,32},{14072,2,0,32},
{14100,2,0,32},{14073,2,0,32},{14100,2,0,32},{14074,2,0,32},{14100,2,0,32},
{14075,2,0,32},{14100,2,0,32},{14076,2,0,32},{14100,2,0,32},{14077,2,0,32},
{14100,2,0,32},{14078,2,0,32},{14100,2,0,32},{14079,2,0,32},{14100,2,0,32},
{14080,2,0,32},{14100,2,0,32},{14081,2,0,32},{14100,2,0,32},{14082,2,0,32},
{14100,2,0,32},{14083,2,0,32},{14100,2,0,32},{14084,2,0,32},{14100,2,0,32},
{14085,2,0,32},{14100,2,0,32},{14086,2,0,32},{14100,2,0,32},{14087,2,0,32},
{14100,2,0,32},{14088,2,0,32},{14100,2,0,32},{14089,2,0,32},{14100,2,0,32},
{14074,4,0,32},{14096,4,0,32},{14074,4,0,32},{14096,4,0,32},{14107,4,0,32},
{14154,4,0,32},{14192,4,0,32},{14154,4,0,32},{8098,20,0,32},{0,20,0,280},{8199,
20,0,32},{8273,4,0,32},{0,4,0,281},{8695,4,0,32},{0,4,0,280},{8309,4,0,32},
{8171,20,0,32},{0,20,0,280},{8098,4,0,32},{0,4,0,280},{8098,4,0,32},{0,4,0,280},
{8199,4,0,32},{8098,4,0,32},{8508,4,0,32},{8098,4,0,32},{8775,4,0,32},{8150,4,0,
32},{0,4,0,48},{8171,4,0,32},{0,4,0,281},{8171,4,0,32},{0,4,0,280},{8658,4,0,
32},{0,4,0,281},{8508,4,0,32},{0,4,0,52},{8727,4,0,32},{0,4,0,52},{8098,4,0,32},
{0,4,0,43},{8508,4,0,32},{0,4,0,43},{8727,4,0,32},{0,4,0,43},{8098,8,0,32},{0,2,
0,68},{8098,2,0,32},{0,2,0,68},{8124,8,0,32},{0,2,0,46},{8124,2,0,32},{0,2,0,
46},{8124,8,0,32},{0,2,0,66},{8124,2,0,32},{0,2,0,66},{8124,8,0,32},{0,2,0,73},
{8124,2,0,32},{0,2,0,73},{8150,8,0,32},{0,2,0,48},{0,2,0,36},{8150,2,0,32},{0,2,
0,48},{0,2,0,36},{8171,8,0,32},{0,2,0,46},{8171,2,0,32},{0,2,0,46},{8171,8,0,
32},{0,2,0,66},{8171,2,0,32},{0,2,0,66},{8171,8,0,32},{0,2,0,73},{8171,2,0,32},
{0,2,0,73},{8171,8,0,32},{0,2,0,48},{8171,2,0,32},{0,2,0,48},{8171,8,0,32},{0,2,
0,70},{8171,2,0,32},{0,2,0,70},{8199,8,0,32},{0,2,0,50},{0,2,0,37},{8199,2,0,
32},{0,2,0,50},{0,2,0,37},{8199,8,0,32},{0,2,0,50},{0,2,0,36},{8199,2,0,32},{0,
2,0,50},{0,2,0,36},{8199,8,0,32},{0,2,0,70},{8199,2,0,32},{0,2,0,70},{8199,8,0,
32},{0,2,0,72},{8199,2,0,32},{0,2,0,72},{8199,8,0,32},{0,2,0,48},{0,2,0,38},
{8199,2,0,32},{0,2,0,48},{0,2,0,38},{8258,8,0,32},{0,2,0,46},{8258,2,0,32},{0,2,
0,46},{8273,8,0,32},{0,2,0,50},{8273,2,0,32},{0,2,0,50},{8309,8,0,32},{0,2,0,
46},{8309,2,0,32},{0,2,0,46},{8309,8,0,32},{0,2,0,66},{8309,2,0,32},{0,2,0,66},
{8309,8,0,32},{0,2,0,43},{8309,2,0,32},{0,2,0,43},{8309,8,0,32},{0,2,0,48},
{8309,2,0,32},{0,2,0,48},{8309,8,0,32},{0,2,0,71},{8309,2,0,32},{0,2,0,71},
{8336,8,0,32},{0,2,0,72},{8336,2,0,32},{0,2,0,72},{8336,8,0,32},{0,2,0,43},{0,2,
0,36},{8336,2,0,32},{0,2,0,43},{0,2,0,36},{8388,8,0,32},{0,2,0,36},{8388,2,0,
32},{0,2,0,36},{8388,8,0,32},{0,2,0,66},{8388,2,0,32},{0,2,0,66},{8388,8,0,32},
{0,2,0,73},{8388,2,0,32},{0,2,0,73},{8406,8,0,32},{0,2,0,66},{8406,2,0,32},{0,2,
0,66},{8406,8,0,32},{0,2,0,66},{0,2,0,50},{8406,2,0,32},{0,2,0,66},{0,2,0,50},
{8406,8,0,32},{0,2,0,73},{8406,2,0,32},{0,2,0,73},{8406,8,0,32},{0,2,0,70},
{8406,2,0,32},{0,2,0,70},{8457,8,0,32},{0,2,0,36},{8457,2,0,32},{0,2,0,36},
{8457,8,0,32},{0,2,0,46},{8457,2,0,32},{0,2,0,46},{8457,8,0,32},{0,2,0,66},
{8457,2,0,32},{0,2,0,66},{8472,8,0,32},{0,2,0,46},{8472,2,0,32},{0,2,0,46},
{8472,8,0,32},{0,2,0,66},{8472,2,0,32},{0,2,0,66},{8472,8,0,32},{0,2,0,73},
{8472,2,0,32},{0,2,0,73},{8472,8,0,32},{0,2,0,70},{8472,2,0,32},{0,2,0,70},
{8508,8,0,32},{0,2,0,45},{0,2,0,36},{8508,2,0,32},{0,2,0,45},{0,2,0,36},{8508,8,
0,32},{0,2,0,45},{0,2,0,43},{8508,2,0,32},{0,2,0,45},{0,2,0,43},{8508,8,0,32},
{0,2,0,50},{0,2,0,37},{8508,2,0,32},{0,2,0,50},{0,2,0,37},{8508,8,0,32},{0,2,0,
50},{0,2,0,36},{8508,2,0,32},{0,2,0,50},{0,2,0,36},{8555,8,0,32},{0,2,0,36},
{8555,2,0,32},{0,2,0,36},{8555,8,0,32},{0,2,0,46},{8555,2,0,32},{0,2,0,46},
{8595,8,0,32},{0,2,0,46},{8595,2,0,32},{0,2,0,46},{8595,8,0,32},{0,2,0,66},
{8595,2,0,32},{0,2,0,66},{8595,8,0,32},{0,2,0,66},{0,2,0,50},{8595,2,0,32},{0,2,
0,66},{0,2,0,50},{8595,8,0,32},{0,2,0,73},{8595,2,0,32},{0,2,0,73},{8658,8,0,
32},{0,2,0,46},{8658,2,0,32},{0,2,0,46},{8658,8,0,32},{0,2,0,66},{8658,2,0,32},
{0,2,0,66},{8658,8,0,32},{0,2,0,36},{0,2,0,46},{8658,2,0,32},{0,2,0,36},{0,2,0,
46},{8658,8,0,32},{0,2,0,40},{0,2,0,46},{8658,2,0,32},{0,2,0,40},{0,2,0,46},
{8658,8,0,32},{0,2,0,66},{0,2,0,46},{8658,2,0,32},{0,2,0,66},{0,2,0,46},{8695,8,
0,32},{0,2,0,46},{8695,2,0,32},{0,2,0,46},{8695,8,0,32},{0,2,0,66},{8695,2,0,
32},{0,2,0,66},{8695,8,0,32},{0,2,0,73},{8695,2,0,32},{0,2,0,73},{8695,8,0,32},
{0,2,0,70},{8695,2,0,32},{0,2,0,70},{8727,8,0,32},{0,2,0,67},{8727,2,0,32},{0,2,
0,67},{8727,8,0,32},{0,2,0,72},{8727,2,0,32},{0,2,0,72},{8727,8,0,32},{0,2,0,
70},{8727,2,0,32},{0,2,0,70},{8727,8,0,32},{0,2,0,45},{0,2,0,36},{8727,2,0,32},
{0,2,0,45},{0,2,0,36},{8727,8,0,32},{0,2,0,50},{0,2,0,43},{8727,2,0,32},{0,2,0,
50},{0,2,0,43},{8775,8,0,32},{0,2,0,45},{8775,2,0,32},{0,2,0,45},{8775,8,0,32},
{0,2,0,66},{8775,2,0,32},{0,2,0,66},{8793,8,0,32},{0,2,0,37},{8793,2,0,32},{0,2,
0,37},{8793,8,0,32},{0,2,0,36},{8793,2,0,32},{0,2,0,36},{8793,8,0,32},{0,2,0,
43},{8793,2,0,32},{0,2,0,43},{8793,8,0,32},{0,2,0,46},{8793,2,0,32},{0,2,0,46},
{8793,8,0,32},{0,2,0,66},{8793,2,0,32},{0,2,0,66},{8804,8,0,32},{0,2,0,46},
{8804,2,0,32},{0,2,0,46},{8804,8,0,32},{0,2,0,43},{8804,2,0,32},{0,2,0,43},
{8816,8,0,32},{0,2,0,46},{8816,2,0,32},{0,2,0,46},{8838,8,0,32},{0,2,0,39},
{8838,2,0,32},{0,2,0,39},{8838,8,0,32},{0,2,0,66},{8838,2,0,32},{0,2,0,66},
{8838,8,0,32},{0,2,0,73},{8838,2,0,32},{0,2,0,73},{8309,2,0,32},{0,2,0,73},
{8695,2,0,32},{0,2,0,43},{8793,2,0,32},{0,2,0,41},{8816,2,0,32},{0,2,0,41},
{8098,4,0,32},{8933,4,0,32},{8658,4,0,32},{0,4,0,281},{0,2,0,46},{8658,10,0,32},
{0,4,0,280},{8658,10,0,32},{8098,8,0,32},{0,2,0,66},{8098,2,0,32},{0,2,0,66},
{8098,8,0,32},{0,2,0,59},{8098,2,0,32},{0,2,0,59},{8098,8,0,32},{0,2,0,39},{0,2,
0,36},{8098,2,0,32},{0,2,0,39},{0,2,0,36},{8098,8,0,32},{0,2,0,39},{0,2,0,37},
{8098,2,0,32},{0,2,0,39},{0,2,0,37},{8098,8,0,32},{0,2,0,39},{0,2,0,59},{8098,2,
0,32},{0,2,0,39},{0,2,0,59},{8098,8,0,32},{0,2,0,39},{0,2,0,45},{8098,2,0,32},
{0,2,0,39},{0,2,0,45},{8098,8,0,32},{0,2,0,66},{0,2,0,39},{8098,2,0,32},{0,2,0,
66},{0,2,0,39},{8098,8,0,32},{0,2,0,38},{0,2,0,36},{8098,2,0,32},{0,2,0,38},{0,
2,0,36},{8098,8,0,32},{0,2,0,38},{0,2,0,37},{8098,2,0,32},{0,2,0,38},{0,2,0,37},
{8098,8,0,32},{0,2,0,38},{0,2,0,59},{8098,2,0,32},{0,2,0,38},{0,2,0,59},{8098,8,
0,32},{0,2,0,38},{0,2,0,45},{8098,2,0,32},{0,2,0,38},{0,2,0,45},{8098,8,0,32},
{0,2,0,66},{0,2,0,38},{8098,2,0,32},{0,2,0,66},{0,2,0,38},{8199,8,0,32},{0,2,0,
66},{8199,2,0,32},{0,2,0,66},{8199,8,0,32},{0,2,0,59},{8199,2,0,32},{0,2,0,59},
{8199,8,0,32},{0,2,0,45},{8199,2,0,32},{0,2,0,45},{8199,8,0,32},{0,2,0,39},{0,2,
0,36},{8199,2,0,32},{0,2,0,39},{0,2,0,36},{8199,8,0,32},{0,2,0,39},{0,2,0,37},
{8199,2,0,32},{0,2,0,39},{0,2,0,37},{8199,8,0,32},{0,2,0,39},{0,2,0,59},{8199,2,
0,32},{0,2,0,39},{0,2,0,59},{8199,8,0,32},{0,2,0,39},{0,2,0,45},{8199,2,0,32},
{0,2,0,39},{0,2,0,45},{8199,8,0,32},{0,2,0,66},{0,2,0,39},{8199,2,0,32},{0,2,0,
66},{0,2,0,39},{8336,8,0,32},{0,2,0,59},{8336,2,0,32},{0,2,0,59},{8336,8,0,32},
{0,2,0,66},{8336,2,0,32},{0,2,0,66},{8508,8,0,32},{0,2,0,66},{8508,2,0,32},{0,2,
0,66},{8508,8,0,32},{0,2,0,59},{8508,2,0,32},{0,2,0,59},{8508,8,0,32},{0,2,0,
39},{0,2,0,36},{8508,2,0,32},{0,2,0,39},{0,2,0,36},{8508,8,0,32},{0,2,0,39},{0,
2,0,37},{8508,2,0,32},{0,2,0,39},{0,2,0,37},{8508,8,0,32},{0,2,0,39},{0,2,0,59},
{8508,2,0,32},{0,2,0,39},{0,2,0,59},{8508,8,0,32},{0,2,0,39},{0,2,0,45},{8508,2,
0,32},{0,2,0,39},{0,2,0,45},{8508,8,0,32},{0,2,0,66},{0,2,0,39},{8508,2,0,32},
{0,2,0,66},{0,2,0,39},{8508,8,0,32},{0,2,0,63},{0,2,0,36},{8508,2,0,32},{0,2,0,
63},{0,2,0,36},{8508,8,0,32},{0,2,0,63},{0,2,0,37},{8508,2,0,32},{0,2,0,63},{0,
2,0,37},{8508,8,0,32},{0,2,0,63},{0,2,0,59},{8508,2,0,32},{0,2,0,63},{0,2,0,59},
{8508,8,0,32},{0,2,0,63},{0,2,0,45},{8508,2,0,32},{0,2,0,63},{0,2,0,45},{8508,8,
0,32},{0,2,0,63},{0,2,0,66},{8508,2,0,32},{0,2,0,63},{0,2,0,66},{8727,8,0,32},
{0,2,0,66},{8727,2,0,32},{0,2,0,66},{8727,8,0,32},{0,2,0,59},{8727,2,0,32},{0,2,
0,59},{8727,8,0,32},{0,2,0,63},{0,2,0,36},{8727,2,0,32},{0,2,0,63},{0,2,0,36},
{8727,8,0,32},{0,2,0,63},{0,2,0,37},{8727,2,0,32},{0,2,0,63},{0,2,0,37},{8727,8,
0,32},{0,2,0,63},{0,2,0,59},{8727,2,0,32},{0,2,0,63},{0,2,0,59},{8727,8,0,32},
{0,2,0,63},{0,2,0,45},{8727,2,0,32},{0,2,0,63},{0,2,0,45},{8727,8,0,32},{0,2,0,
63},{0,2,0,66},{8727,2,0,32},{0,2,0,63},{0,2,0,66},{8816,8,0,32},{0,2,0,37},
{8816,2,0,32},{0,2,0,37},{8816,8,0,32},{0,2,0,66},{8816,2,0,32},{0,2,0,66},
{8816,8,0,32},{0,2,0,59},{8816,2,0,32},{0,2,0,59},{8816,8,0,32},{0,2,0,45},
{8816,2,0,32},{0,2,0,45},{8406,10,0,32},{8406,10,0,32},{8406,4,0,32},{8406,4,0,
32},{8990,2,0,32},{0,2,0,34},{8990,2,0,32},{0,2,0,35},{8990,2,0,32},{0,2,0,34},
{0,2,0,37},{8990,2,0,32},{0,2,0,35},{0,2,0,37},{8990,2,0,32},{0,2,0,34},{0,2,0,
36},{8990,2,0,32},{0,2,0,35},{0,2,0,36},{8990,2,0,32},{0,2,0,34},{0,2,0,42},
{8990,2,0,32},{0,2,0,35},{0,2,0,42},{8990,8,0,32},{0,2,0,34},{8990,8,0,32},{0,2,
0,35},{8990,8,0,32},{0,2,0,34},{0,2,0,37},{8990,8,0,32},{0,2,0,35},{0,2,0,37},
{8990,8,0,32},{0,2,0,34},{0,2,0,36},{8990,8,0,32},{0,2,0,35},{0,2,0,36},{8990,8,
0,32},{0,2,0,34},{0,2,0,42},{8990,8,0,32},{0,2,0,35},{0,2,0,42},{8995,2,0,32},
{0,2,0,34},{8995,2,0,32},{0,2,0,35},{8995,2,0,32},{0,2,0,34},{0,2,0,37},{8995,2,
0,32},{0,2,0,35},{0,2,0,37},{8995,2,0,32},{0,2,0,34},{0,2,0,36},{8995,2,0,32},
{0,2,0,35},{0,2,0,36},{8995,8,0,32},{0,2,0,34},{8995,8,0,32},{0,2,0,35},{8995,8,
0,32},{0,2,0,34},{0,2,0,37},{8995,8,0,32},{0,2,0,35},{0,2,0,37},{8995,8,0,32},
{0,2,0,34},{0,2,0,36},{8995,8,0,32},{0,2,0,35},{0,2,0,36},{9001,2,0,32},{0,2,0,
34},{9001,2,0,32},{0,2,0,35},{9001,2,0,32},{0,2,0,34},{0,2,0,37},{9001,2,0,32},
{0,2,0,35},{0,2,0,37},{9001,2,0,32},{0,2,0,34},{0,2,0,36},{9001,2,0,32},{0,2,0,
35},{0,2,0,36},{9001,2,0,32},{0,2,0,34},{0,2,0,42},{9001,2,0,32},{0,2,0,35},{0,
2,0,42},{9001,8,0,32},{0,2,0,34},{9001,8,0,32},{0,2,0,35},{9001,8,0,32},{0,2,0,
34},{0,2,0,37},{9001,8,0,32},{0,2,0,35},{0,2,0,37},{9001,8,0,32},{0,2,0,34},{0,
2,0,36},{9001,8,0,32},{0,2,0,35},{0,2,0,36},{9001,8,0,32},{0,2,0,34},{0,2,0,42},
{9001,8,0,32},{0,2,0,35},{0,2,0,42},{9003,2,0,32},{0,2,0,34},{9003,2,0,32},{0,2,
0,35},{9003,2,0,32},{0,2,0,34},{0,2,0,37},{9003,2,0,32},{0,2,0,35},{0,2,0,37},
{9003,2,0,32},{0,2,0,34},{0,2,0,36},{9003,2,0,32},{0,2,0,35},{0,2,0,36},{9003,2,
0,32},{0,2,0,34},{0,2,0,42},{9003,2,0,32},{0,2,0,35},{0,2,0,42},{9003,8,0,32},
{0,2,0,34},{9003,8,0,32},{0,2,0,35},{9003,8,0,32},{0,2,0,34},{0,2,0,37},{9003,8,
0,32},{0,2,0,35},{0,2,0,37},{9003,8,0,32},{0,2,0,34},{0,2,0,36},{9003,8,0,32},
{0,2,0,35},{0,2,0,36},{9003,8,0,32},{0,2,0,34},{0,2,0,42},{9003,8,0,32},{0,2,0,
35},{0,2,0,42},{9011,2,0,32},{0,2,0,34},{9011,2,0,32},{0,2,0,35},{9011,2,0,32},
{0,2,0,34},{0,2,0,37},{9011,2,0,32},{0,2,0,35},{0,2,0,37},{9011,2,0,32},{0,2,0,
34},{0,2,0,36},{9011,2,0,32},{0,2,0,35},{0,2,0,36},{9011,8,0,32},{0,2,0,34},
{9011,8,0,32},{0,2,0,35},{9011,8,0,32},{0,2,0,34},{0,2,0,37},{9011,8,0,32},{0,2,
0,35},{0,2,0,37},{9011,8,0,32},{0,2,0,34},{0,2,0,36},{9011,8,0,32},{0,2,0,35},
{0,2,0,36},{9025,2,0,32},{0,2,0,34},{9025,2,0,32},{0,2,0,35},{9025,2,0,32},{0,2,
0,34},{0,2,0,37},{9025,2,0,32},{0,2,0,35},{0,2,0,37},{9025,2,0,32},{0,2,0,34},
{0,2,0,36},{9025,2,0,32},{0,2,0,35},{0,2,0,36},{9025,2,0,32},{0,2,0,34},{0,2,0,
42},{9025,2,0,32},{0,2,0,35},{0,2,0,42},{9025,8,0,32},{0,2,0,35},{9025,8,0,32},
{0,2,0,35},{0,2,0,37},{9025,8,0,32},{0,2,0,35},{0,2,0,36},{9025,8,0,32},{0,2,0,
35},{0,2,0,42},{9030,2,0,32},{0,2,0,34},{9030,2,0,32},{0,2,0,35},{9030,2,0,32},
{0,2,0,34},{0,2,0,37},{9030,2,0,32},{0,2,0,35},{0,2,0,37},{9030,2,0,32},{0,2,0,
34},{0,2,0,36},{9030,2,0,32},{0,2,0,35},{0,2,0,36},{9030,2,0,32},{0,2,0,34},{0,
2,0,42},{9030,2,0,32},{0,2,0,35},{0,2,0,42},{9030,8,0,32},{0,2,0,34},{9030,8,0,
32},{0,2,0,35},{9030,8,0,32},{0,2,0,34},{0,2,0,37},{9030,8,0,32},{0,2,0,35},{0,
2,0,37},{9030,8,0,32},{0,2,0,34},{0,2,0,36},{9030,8,0,32},{0,2,0,35},{0,2,0,36},
{9030,8,0,32},{0,2,0,34},{0,2,0,42},{9030,8,0,32},{0,2,0,35},{0,2,0,42},{8990,2,
0,32},{0,2,0,37},{8995,2,0,32},{0,2,0,37},{9001,2,0,32},{0,2,0,37},{9003,2,0,
32},{0,2,0,37},{9011,2,0,32},{0,2,0,37},{9025,2,0,32},{0,2,0,37},{9030,2,0,32},
{0,2,0,37},{8990,2,0,32},{0,2,0,34},{0,2,0,76},{8990,2,0,32},{0,2,0,35},{0,2,0,
76},{8990,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{8990,2,0,32},{0,2,0,35},{0,
2,0,37},{0,2,0,76},{8990,2,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{8990,2,0,32},
{0,2,0,35},{0,2,0,36},{0,2,0,76},{8990,2,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},
{8990,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{8990,8,0,32},{0,2,0,34},{0,2,0,
76},{8990,8,0,32},{0,2,0,35},{0,2,0,76},{8990,8,0,32},{0,2,0,34},{0,2,0,37},{0,
2,0,76},{8990,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{8990,8,0,32},{0,2,0,34},
{0,2,0,36},{0,2,0,76},{8990,8,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{8990,8,0,
32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{8990,8,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,
76},{9001,2,0,32},{0,2,0,34},{0,2,0,76},{9001,2,0,32},{0,2,0,35},{0,2,0,76},
{9001,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{9001,2,0,32},{0,2,0,35},{0,2,0,
37},{0,2,0,76},{9001,2,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{9001,2,0,32},{0,
2,0,35},{0,2,0,36},{0,2,0,76},{9001,2,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},
{9001,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{9001,8,0,32},{0,2,0,34},{0,2,0,
76},{9001,8,0,32},{0,2,0,35},{0,2,0,76},{9001,8,0,32},{0,2,0,34},{0,2,0,37},{0,
2,0,76},{9001,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{9001,8,0,32},{0,2,0,34},
{0,2,0,36},{0,2,0,76},{9001,8,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{9001,8,0,
32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{9001,8,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,
76},{9030,2,0,32},{0,2,0,34},{0,2,0,76},{9030,2,0,32},{0,2,0,35},{0,2,0,76},
{9030,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{9030,2,0,32},{0,2,0,35},{0,2,0,
37},{0,2,0,76},{9030,2,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{9030,2,0,32},{0,
2,0,35},{0,2,0,36},{0,2,0,76},{9030,2,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},
{9030,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{9030,8,0,32},{0,2,0,34},{0,2,0,
76},{9030,8,0,32},{0,2,0,35},{0,2,0,76},{9030,8,0,32},{0,2,0,34},{0,2,0,37},{0,
2,0,76},{9030,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{9030,8,0,32},{0,2,0,34},
{0,2,0,36},{0,2,0,76},{9030,8,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{9030,8,0,
32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{9030,8,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,
76},{8990,2,0,32},{0,2,0,38},{8990,2,0,32},{0,2,0,50},{8990,2,0,32},{0,2,0,37},
{0,2,0,76},{8990,2,0,32},{0,2,0,76},{8990,2,0,32},{0,2,0,36},{0,2,0,76},{8990,2,
0,32},{0,2,0,42},{8990,2,0,32},{0,2,0,42},{0,2,0,76},{8990,8,0,32},{0,2,0,38},
{8990,8,0,32},{0,2,0,50},{8990,8,0,32},{0,2,0,37},{8990,8,0,32},{0,2,0,76},
{1211,2,1,32},{0,2,0,42},{9001,2,0,32},{0,2,0,37},{0,2,0,76},{9001,2,0,32},{0,2,
0,76},{9001,2,0,32},{0,2,0,36},{0,2,0,76},{9001,2,0,32},{0,2,0,42},{9001,2,0,
32},{0,2,0,42},{0,2,0,76},{8995,8,0,32},{0,2,0,37},{9001,8,0,32},{0,2,0,37},
{9001,8,0,32},{0,2,0,76},{1216,2,1,32},{0,2,0,37},{1216,2,1,32},{0,2,0,36},
{1216,2,1,32},{0,2,0,42},{9003,2,0,32},{0,2,0,38},{9003,2,0,32},{0,2,0,50},
{9003,2,0,32},{0,2,0,43},{0,2,0,37},{9003,2,0,32},{0,2,0,42},{9003,2,0,32},{0,2,
0,43},{0,2,0,42},{9003,8,0,32},{0,2,0,38},{9003,8,0,32},{0,2,0,50},{9003,8,0,
32},{0,2,0,37},{1217,2,1,32},{0,2,0,37},{1217,2,1,32},{0,2,0,36},{1217,2,1,32},
{0,2,0,42},{9025,2,0,32},{0,2,0,38},{9025,2,0,32},{0,2,0,50},{9025,2,0,32},{0,2,
0,43},{0,2,0,37},{9017,2,0,32},{0,2,0,34},{9017,2,0,32},{0,2,0,35},{9025,2,0,
32},{0,2,0,42},{9025,2,0,32},{0,2,0,43},{0,2,0,42},{9025,8,0,32},{0,2,0,38},
{9025,8,0,32},{0,2,0,50},{9025,8,0,32},{0,2,0,37},{9017,8,0,32},{0,2,0,35},
{1211,2,1,32},{0,2,0,37},{9030,2,0,32},{0,2,0,37},{0,2,0,76},{9030,2,0,32},{0,2,
0,76},{9030,2,0,32},{0,2,0,36},{0,2,0,76},{9030,2,0,32},{0,2,0,42},{9030,2,0,
32},{0,2,0,42},{0,2,0,76},{9011,8,0,32},{0,2,0,37},{9030,8,0,32},{0,2,0,37},
{9030,8,0,32},{0,2,0,76},{638,4,1,32},{638,4,1,32},{638,4,1,32},{638,4,1,32},
{638,4,1,32},{959,4,1,32},{959,4,1,32},{959,4,1,32},{959,4,1,32},{959,4,1,32},
{960,4,1,32},{960,4,1,32},{960,4,1,32},{960,4,1,32},{960,4,1,32},{615,4,1,32},
{615,4,1,32},{621,4,1,32},{621,4,1,32},{621,4,1,32},{615,4,1,32},{615,4,1,32},
{621,4,1,32},{959,4,1,32},{959,4,1,32},{959,4,1,32},{959,4,1,32},{8595,10,0,32},
{8658,4,0,32},{8098,4,0,32},{934,4,1,32},{8150,4,0,32},{8098,4,0,32},{934,4,1,
32},{8658,4,0,32},{1322,4,1,32},{8150,10,0,32},{8150,4,0,32},{934,4,1,32},{8508,
4,0,32},{8150,4,0,32},{934,4,1,32},{8727,4,0,32},{1322,4,1,32},{8258,10,0,32},
{8309,2,0,32},{0,2,0,57},{8472,10,0,32},{8508,4,0,32},{8658,20,0,32},{8457,20,0,
32},{8695,10,0,32},{8199,10,0,32},{8406,10,0,32},{8695,20,0,32},{8457,20,0,32},
{8258,10,0,32},{8098,10,0,32},{8804,10,0,32},{8098,10,0,32},{934,4,1,32},{8658,
10,0,32},{8089,30,0,32},{1654,30,1,32},{8095,30,0,32},{8089,30,0,32},{1654,30,1,
32},{8097,30,0,32},{8089,30,0,32},{1654,30,1,32},{8089,30,0,32},{8088,30,0,32},
{8089,30,0,32},{1654,30,1,32},{8091,30,0,32},{8090,30,0,32},{1654,30,1,32},
{8091,30,0,32},{8089,30,0,32},{1654,30,1,32},{8093,30,0,32},{8090,30,0,32},
{1654,30,1,32},{8093,30,0,32},{8091,30,0,32},{1654,30,1,32},{8093,30,0,32},
{8092,30,0,32},{1654,30,1,32},{8093,30,0,32},{8089,30,0,32},{1654,30,1,32},
{8094,30,0,32},{8093,30,0,32},{1654,30,1,32},{8094,30,0,32},{8089,30,0,32},
{1654,30,1,32},{8096,30,0,32},{8091,30,0,32},{1654,30,1,32},{8096,30,0,32},
{8093,30,0,32},{1654,30,1,32},{8096,30,0,32},{8095,30,0,32},{1654,30,1,32},
{8096,30,0,32},{8089,30,0,32},{1654,30,1,32},{8336,10,0,32},{8336,10,0,32},
{8336,10,0,32},{8336,10,0,32},{8336,10,0,32},{8336,10,0,32},{8775,10,0,32},
{8775,10,0,32},{8336,10,0,32},{8775,10,0,32},{8336,10,0,32},{8336,10,0,32},
{8775,10,0,32},{8336,10,0,32},{8336,10,0,32},{8336,10,0,32},{8336,10,0,32},
{8804,10,0,32},{8804,10,0,32},{8336,10,0,32},{8804,10,0,32},{8336,10,0,32},
{8336,10,0,32},{8336,4,0,32},{8336,4,0,32},{8336,4,0,32},{8336,4,0,32},{8336,4,
0,32},{8336,4,0,32},{8775,4,0,32},{8775,4,0,32},{8336,4,0,32},{8775,4,0,32},
{8336,4,0,32},{8336,4,0,32},{8775,4,0,32},{8336,4,0,32},{8336,4,0,32},{8336,4,0,
32},{8336,4,0,32},{8804,4,0,32},{8804,4,0,32},{8336,4,0,32},{8804,4,0,32},{8336,
4,0,32},{8336,4,0,32},{8088,30,0,32},{1654,30,1,32},{8091,30,0,32},{1516,2,1,
32},{0,2,0,47},{1517,2,1,32},{0,2,0,47},{1520,2,1,32},{0,2,0,47},{1574,2,1,32},
{0,2,0,47},{1578,2,1,32},{0,2,0,47},{1576,2,1,32},{0,2,0,47},{1625,2,1,32},{0,2,
0,47},{1629,2,1,32},{0,2,0,47},{1631,2,1,32},{0,2,0,47},{1670,2,1,32},{0,2,0,
47},{1671,2,1,32},{0,2,0,47},{1676,4,1,32},{1676,4,1,32},{1676,4,1,32},{1676,4,
1,32},{1676,4,1,32},{1677,4,1,32},{1677,4,1,32},{1677,4,1,32},{1677,4,1,32},
{1677,4,1,32},{1689,2,1,32},{0,2,0,47},{1695,2,1,32},{0,2,0,47},{1696,2,1,32},
{0,2,0,47},{1698,2,1,32},{0,2,0,47},{1643,2,1,32},{0,2,0,47},{1721,2,1,32},{0,2,
0,47},{1702,2,1,32},{0,2,0,47},{1642,2,1,32},{0,2,0,47},{1644,2,1,32},{0,2,0,
47},{1723,2,1,32},{0,2,0,47},{1724,2,1,32},{0,2,0,47},{1732,2,1,32},{0,2,0,47},
{1733,2,1,32},{0,2,0,47},{1734,2,1,32},{0,2,0,47},{1735,2,1,32},{0,2,0,47},
{1736,2,1,32},{0,2,0,47},{1737,2,1,32},{0,2,0,47},{1742,2,1,32},{0,2,0,47},
{1743,2,1,32},{0,2,0,47},{1744,2,1,32},{0,2,0,47},{1745,2,1,32},{0,2,0,47},
{1770,2,1,32},{0,2,0,47},{1776,2,1,32},{0,2,0,47},{1777,2,1,32},{0,2,0,47},
{1779,2,1,32},{0,2,0,47},{1738,2,1,32},{0,2,0,47},{1739,2,1,32},{0,2,0,47},
{1753,2,1,32},{0,2,0,47},{1754,2,1,32},{0,2,0,47},{1782,2,1,32},{0,2,0,47},
{1783,2,1,32},{0,2,0,47},{1784,2,1,32},{0,2,0,47},{1785,2,1,32},{0,2,0,47},
{8089,6,0,32},{8088,6,0,32},{8089,6,0,32},{8089,6,0,32},{8089,6,0,32},{8090,6,0,
32},{8089,6,0,32},{8091,6,0,32},{8089,6,0,32},{8092,6,0,32},{8089,6,0,32},{8093,
6,0,32},{8089,6,0,32},{8094,6,0,32},{8089,6,0,32},{8095,6,0,32},{8089,6,0,32},
{8096,6,0,32},{8089,6,0,32},{8097,6,0,32},{8090,6,0,32},{8088,6,0,32},{808,4,1,
32},{8089,4,0,32},{809,4,1,32},{808,4,1,32},{8090,4,0,32},{809,4,1,32},{808,4,1,
32},{8091,4,0,32},{809,4,1,32},{808,4,1,32},{8092,4,0,32},{809,4,1,32},{808,4,1,
32},{8093,4,0,32},{809,4,1,32},{808,4,1,32},{8094,4,0,32},{809,4,1,32},{808,4,1,
32},{8095,4,0,32},{809,4,1,32},{808,4,1,32},{8096,4,0,32},{809,4,1,32},{808,4,1,
32},{8097,4,0,32},{809,4,1,32},{808,4,1,32},{8089,4,0,32},{8088,4,0,32},{809,4,
1,32},{808,4,1,32},{8089,4,0,32},{8089,4,0,32},{809,4,1,32},{808,4,1,32},{8089,
4,0,32},{8090,4,0,32},{809,4,1,32},{808,4,1,32},{8089,4,0,32},{8091,4,0,32},
{809,4,1,32},{808,4,1,32},{8089,4,0,32},{8092,4,0,32},{809,4,1,32},{808,4,1,32},
{8089,4,0,32},{8093,4,0,32},{809,4,1,32},{808,4,1,32},{8089,4,0,32},{8094,4,0,
32},{809,4,1,32},{808,4,1,32},{8089,4,0,32},{8095,4,0,32},{809,4,1,32},{808,4,1,
32},{8089,4,0,32},{8096,4,0,32},{809,4,1,32},{808,4,1,32},{8089,4,0,32},{8097,4,
0,32},{809,4,1,32},{808,4,1,32},{8090,4,0,32},{8088,4,0,32},{809,4,1,32},{8089,
4,0,32},{638,4,1,32},{8090,4,0,32},{638,4,1,32},{8091,4,0,32},{638,4,1,32},
{8092,4,0,32},{638,4,1,32},{8093,4,0,32},{638,4,1,32},{8094,4,0,32},{638,4,1,
32},{8095,4,0,32},{638,4,1,32},{8096,4,0,32},{638,4,1,32},{8097,4,0,32},{638,4,
1,32},{8089,4,0,32},{8088,4,0,32},{638,4,1,32},{8089,4,0,32},{8089,4,0,32},{638,
4,1,32},{8089,4,0,32},{8090,4,0,32},{638,4,1,32},{8089,4,0,32},{8091,4,0,32},
{638,4,1,32},{8089,4,0,32},{8092,4,0,32},{638,4,1,32},{8089,4,0,32},{8093,4,0,
32},{638,4,1,32},{8089,4,0,32},{8094,4,0,32},{638,4,1,32},{8089,4,0,32},{8095,4,
0,32},{638,4,1,32},{8089,4,0,32},{8096,4,0,32},{638,4,1,32},{8089,4,0,32},{8097,
4,0,32},{638,4,1,32},{8090,4,0,32},{8088,4,0,32},{638,4,1,32},{808,4,1,32},
{8098,4,0,32},{809,4,1,32},{808,4,1,32},{8124,4,0,32},{809,4,1,32},{808,4,1,32},
{8150,4,0,32},{809,4,1,32},{808,4,1,32},{8171,4,0,32},{809,4,1,32},{808,4,1,32},
{8199,4,0,32},{809,4,1,32},{808,4,1,32},{8258,4,0,32},{809,4,1,32},{808,4,1,32},
{8273,4,0,32},{809,4,1,32},{808,4,1,32},{8309,4,0,32},{809,4,1,32},{808,4,1,32},
{8336,4,0,32},{809,4,1,32},{808,4,1,32},{8363,4,0,32},{809,4,1,32},{808,4,1,32},
{8388,4,0,32},{809,4,1,32},{808,4,1,32},{8406,4,0,32},{809,4,1,32},{808,4,1,32},
{8457,4,0,32},{809,4,1,32},{808,4,1,32},{8472,4,0,32},{809,4,1,32},{808,4,1,32},
{8508,4,0,32},{809,4,1,32},{808,4,1,32},{8555,4,0,32},{809,4,1,32},{808,4,1,32},
{8576,4,0,32},{809,4,1,32},{808,4,1,32},{8595,4,0,32},{809,4,1,32},{808,4,1,32},
{8658,4,0,32},{809,4,1,32},{808,4,1,32},{8695,4,0,32},{809,4,1,32},{808,4,1,32},
{8727,4,0,32},{809,4,1,32},{808,4,1,32},{8775,4,0,32},{809,4,1,32},{808,4,1,32},
{8793,4,0,32},{809,4,1,32},{808,4,1,32},{8804,4,0,32},{809,4,1,32},{808,4,1,32},
{8816,4,0,32},{809,4,1,32},{808,4,1,32},{8838,4,0,32},{809,4,1,32},{8089,6,0,
32},{8089,6,0,32},{8089,6,0,32},{8090,6,0,32},{8089,6,0,32},{8091,6,0,32},{8089,
6,0,32},{8092,6,0,32},{8089,6,0,32},{8093,6,0,32},{8089,6,0,32},{8094,6,0,32},
{8089,6,0,32},{8095,6,0,32},{8089,6,0,32},{8096,6,0,32},{8089,6,0,32},{8097,6,0,
32},{8090,6,0,32},{8088,6,0,32},{8089,6,0,32},{8088,6,0,32},{8089,6,0,32},{8088,
6,0,32},{8089,6,0,32},{8088,6,0,32},{8089,6,0,32},{8088,6,0,32},{1676,4,1,32},
{1676,4,1,32},{1676,4,1,32},{1676,4,1,32},{576,4,1,32},{576,4,1,32},{1643,4,1,
32},{1643,4,1,32},{1643,4,1,32},{1643,4,1,32},{1643,4,1,32},{1643,4,1,32},{3522,
2,1,32},{0,2,0,47},{9046,4,0,32},{9035,4,0,32},{9045,4,0,32},{9322,4,0,32},
{9331,4,0,32},{64320,4,0,32},{52790,0,0,0},{0,4,0,280},{64320,4,0,32},{54146,0,
0,0},{0,4,0,280},{64320,4,0,32},{52827,0,0,0},{64320,4,0,32},{52826,0,0,0},
{64320,4,0,32},{52825,0,0,0},{0,4,0,280},{64320,4,0,32},{52923,0,0,0},{64320,4,
0,32},{53634,0,0,0},{0,4,0,280},{64320,4,0,32},{53728,0,0,0},{0,4,0,280},{64320,
4,0,32},{53760,0,0,0},{0,4,0,280},{64320,4,0,32},{53762,0,0,0},{64320,4,0,32},
{54108,0,0,0},{0,4,0,280},{64320,4,0,32},{54121,0,0,0},{0,4,0,280},{64320,4,0,
32},{56335,0,0,0},{0,4,0,280},{64320,4,0,32},{56335,0,0,0},{0,4,0,281},{64320,4,
0,32},{56354,0,0,0},{0,4,0,280},{64320,4,0,32},{56355,0,0,0},{64320,4,0,32},
{56354,0,0,0},{64320,4,0,32},{56355,0,0,0},{0,4,0,280},{64320,4,0,32},{56819,0,
0,0},{64320,4,0,32},{56954,0,0,0},{64320,4,0,32},{57169,0,0,0},{64320,4,0,32},
{57168,0,0,0},{0,4,0,280},{64320,4,0,32},{57284,0,0,0},{64320,4,0,32},{57283,0,
0,0},{0,4,0,280},{64320,4,0,32},{57932,0,0,0},{64320,4,0,32},{58677,0,0,0},
{64320,4,0,32},{58849,0,0,0},{64320,4,0,32},{58853,0,0,0},{0,4,0,280},{64320,4,
0,32},{59144,0,0,0},{0,4,0,280},{64320,4,0,32},{60282,0,0,0},{0,4,0,280},{64320,
4,0,32},{60365,0,0,0},{64320,4,0,32},{60433,0,0,0},{64320,4,0,32},{60469,0,0,0},
{64320,4,0,32},{60474,0,0,0},{64320,4,0,32},{61548,0,0,0},{64320,4,0,32},{61995,
0,0,0},{64320,4,0,32},{61995,0,0,0},{0,4,0,280},{64320,4,0,32},{52780,0,0,0},
{64320,4,0,32},{62043,0,0,0},{0,4,0,280},{64320,4,0,32},{62125,0,0,0},{64320,4,
0,32},{62347,0,0,0},{0,4,0,280},{64320,4,0,32},{62859,0,0,0},{0,4,0,280},{64320,
4,0,32},{63214,0,0,0},{0,4,0,280},{64320,4,0,32},{63802,0,0,0},{0,4,0,280},
{64320,4,0,32},{63803,0,0,0},{64320,4,0,32},{64249,0,0,0},{0,4,0,280},{64320,4,
0,32},{64761,0,0,0},{64320,4,0,32},{65183,0,0,0},{64320,4,0,32},{65363,0,0,0},
{64320,4,0,32},{65362,0,0,0},{64320,4,0,32},{65363,0,0,0},{0,4,0,280},{64320,4,
0,32},{65363,0,0,0},{0,4,0,281},{64320,4,0,32},{65362,0,0,0},{0,4,0,280},{64320,
4,0,32},{65418,0,0,0},{0,4,0,280},{64320,4,0,32},{65418,0,0,0},{0,4,0,281},
{64320,4,0,32},{65419,0,0,0},{64321,4,0,32},{32770,0,0,0},{64321,4,0,32},{32896,
0,0,0},{64321,4,0,32},{32895,0,0,0},{0,4,0,280},{64321,4,0,32},{32905,0,0,0},{0,
4,0,280},{64321,4,0,32},{33276,0,0,0},{0,4,0,280},{64321,4,0,32},{33401,0,0,0},
{64321,4,0,32},{33401,0,0,0},{0,4,0,280},{64321,4,0,32},{33401,0,0,0},{0,4,0,
281},{64321,4,0,32},{34382,0,0,0},{64321,4,0,32},{34916,0,0,0},{64321,4,0,32},
{35200,0,0,0},{64321,4,0,32},{35199,0,0,0},{64321,4,0,32},{35265,0,0,0},{64321,
4,0,32},{35282,0,0,0},{64321,4,0,32},{35282,0,0,0},{0,4,0,280},{64321,4,0,32},
{35744,0,0,0},{64321,4,0,32},{36125,0,0,0},{64321,4,0,32},{36275,0,0,0},{0,4,0,
280},{64321,4,0,32},{36710,0,0,0},{64321,4,0,32},{36790,0,0,0},{64321,4,0,32},
{36790,0,0,0},{0,4,0,280},{64321,4,0,32},{36790,0,0,0},{0,4,0,281},{64321,4,0,
32},{37009,0,0,0},{0,4,0,280},{64321,4,0,32},{38021,0,0,0},{64321,4,0,32},
{38263,0,0,0},{64321,4,0,32},{38264,0,0,0},{64321,4,0,32},{38271,0,0,0},{64321,
4,0,32},{38376,0,0,0},{64321,4,0,32},{38428,0,0,0},{0,4,0,280},{64321,4,0,32},
{38429,0,0,0},{64321,4,0,32},{38632,0,0,0},{0,4,0,280},{64321,4,0,32},{38738,0,
0,0},{64321,4,0,32},{38886,0,0,0},{64321,4,0,32},{39029,0,0,0},{64321,4,0,32},
{39118,0,0,0},{64321,4,0,32},{39134,0,0,0},{64321,4,0,32},{39135,0,0,0},{64321,
4,0,32},{39136,0,0,0},{0,4,0,280},{64321,4,0,32},{39136,0,0,0},{64321,4,0,32},
{39267,0,0,0},{64321,4,0,32},{39318,0,0,0},{0,4,0,280},{64321,4,0,32},{39532,0,
0,0},{64321,4,0,32},{39592,0,0,0},{0,4,0,280},{64321,4,0,32},{39740,0,0,0},{0,4,
0,280},{64321,4,0,32},{40060,0,0,0},{64321,4,0,32},{40479,0,0,0},{64321,4,0,32},
{40565,0,0,0},{0,4,0,280},{64321,4,0,32},{40614,0,0,0},{64321,4,0,32},{40644,0,
0,0},{64321,4,0,32},{40702,0,0,0},{64321,4,0,32},{40778,0,0,0},{0,4,0,280},
{64321,4,0,32},{40784,0,0,0},{64321,4,0,32},{40786,0,0,0},{0,4,0,280},{64321,4,
0,32},{40831,0,0,0},{64321,4,0,32},{40845,0,0,0},{0,4,0,280},{64321,4,0,32},
{40857,0,0,0},{64321,4,0,32},{40860,0,0,0},{0,4,0,280},{64321,4,0,32},{40860,0,
0,0},{0,4,0,281},{64321,4,0,32},{40863,0,0,0},{64320,4,0,32},{52736,0,0,0},
{64320,4,0,32},{52776,0,0,0},{64320,4,0,32},{52790,0,0,0},{64320,4,0,32},{52799,
0,0,0},{64320,4,0,32},{52825,0,0,0},{64320,4,0,32},{52869,0,0,0},{64320,4,0,32},
{52876,0,0,0},{64320,4,0,32},{52896,0,0,0},{64320,4,0,32},{52922,0,0,0},{64320,
4,0,32},{53567,0,0,0},{64320,4,0,32},{53605,0,0,0},{64320,4,0,32},{53611,0,0,0},
{64320,4,0,32},{53634,0,0,0},{64320,4,0,32},{53654,0,0,0},{64320,4,0,32},{53675,
0,0,0},{64320,4,0,32},{53728,0,0,0},{64320,4,0,32},{53749,0,0,0},{64320,4,0,32},
{53760,0,0,0},{64320,4,0,32},{53915,0,0,0},{64320,4,0,32},{54009,0,0,0},{64320,
4,0,32},{54037,0,0,0},{64320,4,0,32},{54042,0,0,0},{64320,4,0,32},{54072,0,0,0},
{64320,4,0,32},{54081,0,0,0},{64320,4,0,32},{54108,0,0,0},{64320,4,0,32},{54121,
0,0,0},{64320,4,0,32},{54146,0,0,0},{64320,4,0,32},{54198,0,0,0},{64320,4,0,32},
{54216,0,0,0},{64320,4,0,32},{54243,0,0,0},{64320,4,0,32},{54999,0,0,0},{64320,
4,0,32},{55071,0,0,0},{64320,4,0,32},{55531,0,0,0},{64320,4,0,32},{55554,0,0,0},
{64320,4,0,32},{55562,0,0,0},{64320,4,0,32},{55573,0,0,0},{64320,4,0,32},{55591,
0,0,0},{64320,4,0,32},{55667,0,0,0},{64320,4,0,32},{56144,0,0,0},{64320,4,0,32},
{56192,0,0,0},{64320,4,0,32},{56312,0,0,0},{64320,4,0,32},{56335,0,0,0},{64320,
4,0,32},{56354,0,0,0},{64320,4,0,32},{56376,0,0,0},{64320,4,0,32},{56430,0,0,0},
{64320,4,0,32},{56433,0,0,0},{64320,4,0,32},{56795,0,0,0},{64320,4,0,32},{56805,
0,0,0},{64320,4,0,32},{56817,0,0,0},{64320,4,0,32},{56830,0,0,0},{64320,4,0,32},
{56946,0,0,0},{64320,4,0,32},{56954,0,0,0},{64320,4,0,32},{56959,0,0,0},{64320,
4,0,32},{57076,0,0,0},{64320,4,0,32},{57086,0,0,0},{64320,4,0,32},{57099,0,0,0},
{64320,4,0,32},{57107,0,0,0},{64320,4,0,32},{57168,0,0,0},{64320,4,0,32},{57185,
0,0,0},{64320,4,0,32},{57203,0,0,0},{64320,4,0,32},{57283,0,0,0},{64320,4,0,32},
{57864,0,0,0},{64320,4,0,32},{57910,0,0,0},{64320,4,0,32},{57931,0,0,0},{64320,
4,0,32},{58671,0,0,0},{64320,4,0,32},{58676,0,0,0},{64320,4,0,32},{58759,0,0,0},
{64320,4,0,32},{58775,0,0,0},{64320,4,0,32},{58788,0,0,0},{64320,4,0,32},{58809,
0,0,0},{64320,4,0,32},{58848,0,0,0},{64320,4,0,32},{58853,0,0,0},{64320,4,0,32},
{59120,0,0,0},{64320,4,0,32},{59144,0,0,0},{64320,4,0,32},{59176,0,0,0},{64320,
4,0,32},{60192,0,0,0},{64320,4,0,32},{60258,0,0,0},{64320,4,0,32},{60281,0,0,0},
{64320,4,0,32},{60339,0,0,0},{64320,4,0,32},{60363,0,0,0},{64320,4,0,32},{60372,
0,0,0},{64320,4,0,32},{60379,0,0,0},{64320,4,0,32},{60431,0,0,0},{64320,4,0,32},
{60436,0,0,0},{64320,4,0,32},{60468,0,0,0},{64320,4,0,32},{61547,0,0,0},{64320,
4,0,32},{61994,0,0,0},{64320,4,0,32},{62006,0,0,0},{64320,4,0,32},{62011,0,0,0},
{64320,4,0,32},{62015,0,0,0},{64320,4,0,32},{62023,0,0,0},{64320,4,0,32},{62041,
0,0,0},{64320,4,0,32},{62043,0,0,0},{64320,4,0,32},{62124,0,0,0},{64320,4,0,32},
{62340,0,0,0},{64320,4,0,32},{62345,0,0,0},{64320,4,0,32},{62684,0,0,0},{64320,
4,0,32},{62694,0,0,0},{64320,4,0,32},{62744,0,0,0},{64320,4,0,32},{62751,0,0,0},
{64320,4,0,32},{62760,0,0,0},{64320,4,0,32},{62768,0,0,0},{64320,4,0,32},{62859,
0,0,0},{64320,4,0,32},{62866,0,0,0},{64320,4,0,32},{63094,0,0,0},{64320,4,0,32},
{63101,0,0,0},{64320,4,0,32},{63150,0,0,0},{64320,4,0,32},{63167,0,0,0},{64320,
4,0,32},{63214,0,0,0},{64320,4,0,32},{63451,0,0,0},{64320,4,0,32},{63458,0,0,0},
{64320,4,0,32},{63475,0,0,0},{64320,4,0,32},{63802,0,0,0},{64320,4,0,32},{63928,
0,0,0},{64320,4,0,32},{63934,0,0,0},{64320,4,0,32},{64116,0,0,0},{64320,4,0,32},
{64203,0,0,0},{64320,4,0,32},{64249,0,0,0},{64320,4,0,32},{64627,0,0,0},{64320,
4,0,32},{64760,0,0,0},{64320,4,0,32},{65334,0,0,0},{64320,4,0,32},{65361,0,0,0},
{64320,4,0,32},{65418,0,0,0},{64320,4,0,32},{65469,0,0,0},{64321,4,0,32},{32769,
0,0,0},{64321,4,0,32},{32780,0,0,0},{64321,4,0,32},{32786,0,0,0},{64321,4,0,32},
{32819,0,0,0},{64321,4,0,32},{32895,0,0,0},{64321,4,0,32},{32905,0,0,0},{64321,
4,0,32},{33251,0,0,0},{64321,4,0,32},{33258,0,0,0},{64321,4,0,32},{33267,0,0,0},
{64321,4,0,32},{33276,0,0,0},{64321,4,0,32},{33292,0,0,0},{64321,4,0,32},{33307,
0,0,0},{64321,4,0,32},{33311,0,0,0},{64321,4,0,32},{33390,0,0,0},{64321,4,0,32},
{33394,0,0,0},{64321,4,0,32},{33400,0,0,0},{64321,4,0,32},{34381,0,0,0},{64321,
4,0,32},{34411,0,0,0},{64321,4,0,32},{34880,0,0,0},{64321,4,0,32},{34892,0,0,0},
{64321,4,0,32},{34915,0,0,0},{64321,4,0,32},{35198,0,0,0},{64321,4,0,32},{35211,
0,0,0},{64321,4,0,32},{35282,0,0,0},{64321,4,0,32},{35328,0,0,0},{64321,4,0,32},
{35895,0,0,0},{64321,4,0,32},{35910,0,0,0},{64321,4,0,32},{35925,0,0,0},{64321,
4,0,32},{35960,0,0,0},{64321,4,0,32},{35997,0,0,0},{64321,4,0,32},{36196,0,0,0},
{64321,4,0,32},{36208,0,0,0},{64321,4,0,32},{36275,0,0,0},{64321,4,0,32},{36523,
0,0,0},{64321,4,0,32},{36554,0,0,0},{64321,4,0,32},{36763,0,0,0},{64321,4,0,32},
{36784,0,0,0},{64321,4,0,32},{36789,0,0,0},{64321,4,0,32},{37009,0,0,0},{64321,
4,0,32},{37193,0,0,0},{64321,4,0,32},{37318,0,0,0},{64321,4,0,32},{37324,0,0,0},
{64321,4,0,32},{37329,0,0,0},{64321,4,0,32},{38263,0,0,0},{64321,4,0,32},{38272,
0,0,0},{64321,4,0,32},{38428,0,0,0},{64321,4,0,32},{38582,0,0,0},{64321,4,0,32},
{38585,0,0,0},{64321,4,0,32},{38632,0,0,0},{64321,4,0,32},{38737,0,0,0},{64321,
4,0,32},{38750,0,0,0},{64321,4,0,32},{38754,0,0,0},{64321,4,0,32},{38761,0,0,0},
{64321,4,0,32},{38859,0,0,0},{64321,4,0,32},{38893,0,0,0},{64321,4,0,32},{38899,
0,0,0},{64321,4,0,32},{38913,0,0,0},{64321,4,0,32},{39080,0,0,0},{64321,4,0,32},
{39131,0,0,0},{64321,4,0,32},{39135,0,0,0},{64321,4,0,32},{39318,0,0,0},{64321,
4,0,32},{39321,0,0,0},{64321,4,0,32},{39340,0,0,0},{64321,4,0,32},{39592,0,0,0},
{64321,4,0,32},{39640,0,0,0},{64321,4,0,32},{39647,0,0,0},{64321,4,0,32},{39717,
0,0,0},{64321,4,0,32},{39727,0,0,0},{64321,4,0,32},{39730,0,0,0},{64321,4,0,32},
{39740,0,0,0},{64321,4,0,32},{39770,0,0,0},{64321,4,0,32},{40165,0,0,0},{64321,
4,0,32},{40565,0,0,0},{64321,4,0,32},{40575,0,0,0},{64321,4,0,32},{40613,0,0,0},
{64321,4,0,32},{40635,0,0,0},{64321,4,0,32},{40643,0,0,0},{64321,4,0,32},{40653,
0,0,0},{64321,4,0,32},{40657,0,0,0},{64321,4,0,32},{40697,0,0,0},{64321,4,0,32},
{40701,0,0,0},{64321,4,0,32},{40718,0,0,0},{64321,4,0,32},{40723,0,0,0},{64321,
4,0,32},{40736,0,0,0},{64321,4,0,32},{40763,0,0,0},{64321,4,0,32},{40778,0,0,0},
{64321,4,0,32},{40786,0,0,0},{64321,4,0,32},{40845,0,0,0},{64321,4,0,32},{40860,
0,0,0},{64321,4,0,32},{40864,0,0,0},{17126,4,0,32},{17148,4,0,32},{8028,2,0,32},
{0,2,0,55},{8029,2,0,32},{0,2,0,55},{64320,4,0,32},{54081,0,0,0},{64320,4,0,32},
{54084,0,0,0},{64320,4,0,32},{54085,0,0,0},{17145,4,0,32},{17127,4,0,32},{17120,
14,0,32},{0,2,0,55},{17121,14,0,32},{0,2,0,55},{17122,14,0,32},{0,2,0,55},
{17123,14,0,32},{0,2,0,55},{17124,14,0,32},{0,2,0,55},{17125,14,0,32},{0,2,0,
55},{17126,14,0,32},{0,2,0,55},{17127,14,0,32},{0,2,0,55},{17128,14,0,32},{0,2,
0,55},{17129,14,0,32},{0,2,0,55},{17130,14,0,32},{0,2,0,55},{17131,14,0,32},{0,
2,0,55},{17132,14,0,32},{0,2,0,55},{17133,14,0,32},{0,2,0,55},{17134,14,0,32},
{0,2,0,55},{17140,14,0,32},{0,2,0,55},{17140,14,0,32},{0,2,0,56},{17141,14,0,
32},{0,2,0,55},{17141,14,0,32},{0,2,0,56},{17142,14,0,32},{0,2,0,55},{17142,14,
0,32},{0,2,0,56},{17143,14,0,32},{0,2,0,55},{17143,14,0,32},{0,2,0,56},{17144,
14,0,32},{0,2,0,55},{17144,14,0,32},{0,2,0,56},{17116,14,0,32},{0,2,0,55},{8031,
2,0,32},{0,2,0,55},{17152,22,0,32},{17154,22,0,32},{17120,17,0,32},{0,2,0,55},
{17121,17,0,32},{0,2,0,55},{17122,17,0,32},{0,2,0,55},{17123,17,0,32},{0,2,0,
55},{17124,17,0,32},{0,2,0,55},{17125,17,0,32},{0,2,0,55},{17126,17,0,32},{0,2,
0,55},{17127,17,0,32},{0,2,0,55},{17128,17,0,32},{0,2,0,55},{17129,17,0,32},{0,
2,0,55},{17130,17,0,32},{0,2,0,55},{17131,17,0,32},{0,2,0,55},{17132,17,0,32},
{0,2,0,55},{17133,17,0,32},{0,2,0,55},{17134,17,0,32},{0,2,0,55},{17140,17,0,
32},{0,2,0,55},{17140,17,0,32},{0,2,0,56},{17141,17,0,32},{0,2,0,55},{17141,17,
0,32},{0,2,0,56},{17142,17,0,32},{0,2,0,55},{17142,17,0,32},{0,2,0,56},{17143,
17,0,32},{0,2,0,55},{17143,17,0,32},{0,2,0,56},{17144,17,0,32},{0,2,0,55},
{17144,17,0,32},{0,2,0,56},{17116,17,0,32},{0,2,0,55},{17158,17,0,32},{0,2,0,
55},{17159,17,0,32},{0,2,0,55},{17160,17,0,32},{0,2,0,55},{17161,17,0,32},{0,2,
0,55},{8033,2,0,32},{0,2,0,55},{17124,22,0,32},{17134,22,0,32},{64320,20,0,32},
{52736,0,0,0},{64320,20,0,32},{52876,0,0,0},{64320,20,0,32},{52745,0,0,0},
{64320,20,0,32},{55003,0,0,0},{64320,20,0,32},{52746,0,0,0},{64320,20,0,32},
{52781,0,0,0},{64320,20,0,32},{52747,0,0,0},{64320,20,0,32},{62770,0,0,0},
{64320,20,0,32},{52825,0,0,0},{64320,20,0,32},{52761,0,0,0},{64320,20,0,32},
{52737,0,0,0},{64320,20,0,32},{55593,0,0,0},{64320,20,0,32},{55088,0,0,0},
{64320,20,0,32},{52922,0,0,0},{17449,4,0,32},{0,4,0,281},{17475,4,0,32},{0,4,0,
281},{17465,4,0,32},{0,4,0,281},{17460,4,0,32},{0,4,0,281},{17486,4,0,32},{0,4,
0,281},{17482,4,0,32},{0,4,0,281},{17500,4,0,32},{0,4,0,282},{17481,4,0,32},{0,
4,0,281},{17499,4,0,32},{0,4,0,281},{17500,4,0,32},{0,4,0,281},{17487,4,0,32},
{0,4,0,281},{17489,4,0,32},{0,4,0,281},{17499,22,0,32},{0,22,0,281},{808,4,1,
32},{16757,4,0,32},{809,4,1,32},{808,4,1,32},{16759,4,0,32},{809,4,1,32},{808,4,
1,32},{16760,4,0,32},{809,4,1,32},{808,4,1,32},{16762,4,0,32},{809,4,1,32},{808,
4,1,32},{16763,4,0,32},{809,4,1,32},{808,4,1,32},{16764,4,0,32},{809,4,1,32},
{808,4,1,32},{16766,4,0,32},{809,4,1,32},{808,4,1,32},{16768,4,0,32},{809,4,1,
32},{808,4,1,32},{16769,4,0,32},{809,4,1,32},{808,4,1,32},{16771,4,0,32},{809,4,
1,32},{808,4,1,32},{16772,4,0,32},{809,4,1,32},{808,4,1,32},{16773,4,0,32},{809,
4,1,32},{808,4,1,32},{16774,4,0,32},{809,4,1,32},{808,4,1,32},{16775,4,0,32},
{809,4,1,32},{808,4,1,32},{16757,4,0,32},{16883,4,0,32},{809,4,1,32},{808,4,1,
32},{16759,4,0,32},{16883,4,0,32},{809,4,1,32},{808,4,1,32},{16760,4,0,32},
{16883,4,0,32},{809,4,1,32},{808,4,1,32},{16762,4,0,32},{16883,4,0,32},{809,4,1,
32},{808,4,1,32},{16763,4,0,32},{16883,4,0,32},{809,4,1,32},{808,4,1,32},{16764,
4,0,32},{16883,4,0,32},{809,4,1,32},{808,4,1,32},{16766,4,0,32},{16883,4,0,32},
{809,4,1,32},{808,4,1,32},{16768,4,0,32},{16883,4,0,32},{809,4,1,32},{808,4,1,
32},{16769,4,0,32},{16883,4,0,32},{809,4,1,32},{808,4,1,32},{16771,4,0,32},
{16883,4,0,32},{809,4,1,32},{808,4,1,32},{16772,4,0,32},{16883,4,0,32},{809,4,1,
32},{808,4,1,32},{16773,4,0,32},{16883,4,0,32},{809,4,1,32},{808,4,1,32},{16774,
4,0,32},{16883,4,0,32},{809,4,1,32},{808,4,1,32},{16775,4,0,32},{16883,4,0,32},
{809,4,1,32},{808,4,1,32},{16769,4,0,32},{16896,4,0,32},{809,4,1,32},{808,4,1,
32},{16768,4,0,32},{16891,4,0,32},{16769,4,0,32},{16887,4,0,32},{16980,4,0,32},
{809,4,1,32},{808,4,1,32},{16768,4,0,32},{16891,4,0,32},{16775,4,0,32},{16896,4,
0,32},{809,4,1,32},{808,4,1,32},{64320,4,0,32},{52736,0,0,0},{809,4,1,32},{808,
4,1,32},{64320,4,0,32},{52876,0,0,0},{809,4,1,32},{808,4,1,32},{64320,4,0,32},
{52745,0,0,0},{809,4,1,32},{808,4,1,32},{64320,4,0,32},{55003,0,0,0},{809,4,1,
32},{808,4,1,32},{64320,4,0,32},{52884,0,0,0},{809,4,1,32},{808,4,1,32},{64320,
4,0,32},{53613,0,0,0},{809,4,1,32},{808,4,1,32},{64320,4,0,32},{52739,0,0,0},
{809,4,1,32},{808,4,1,32},{64320,4,0,32},{53611,0,0,0},{809,4,1,32},{808,4,1,
32},{64320,4,0,32},{52829,0,0,0},{809,4,1,32},{808,4,1,32},{64320,4,0,32},
{54081,0,0,0},{809,4,1,32},{808,4,1,32},{64320,4,0,32},{59144,0,0,0},{809,4,1,
32},{808,4,1,32},{64320,4,0,32},{61547,0,0,0},{809,4,1,32},{808,4,1,32},{64320,
4,0,32},{60468,0,0,0},{809,4,1,32},{808,4,1,32},{64320,4,0,32},{59176,0,0,0},
{809,4,1,32},{808,4,1,32},{64321,4,0,32},{37329,0,0,0},{809,4,1,32},{808,4,1,
32},{64320,4,0,32},{55071,0,0,0},{809,4,1,32},{808,4,1,32},{64320,4,0,32},
{58853,0,0,0},{809,4,1,32},{808,4,1,32},{64320,4,0,32},{59434,0,0,0},{809,4,1,
32},{808,4,1,32},{64320,4,0,32},{59145,0,0,0},{809,4,1,32},{808,4,1,32},{64320,
4,0,32},{63806,0,0,0},{809,4,1,32},{808,4,1,32},{64320,4,0,32},{54285,0,0,0},
{809,4,1,32},{808,4,1,32},{64320,4,0,32},{62073,0,0,0},{809,4,1,32},{808,4,1,
32},{64321,4,0,32},{36001,0,0,0},{809,4,1,32},{808,4,1,32},{64320,4,0,32},
{63837,0,0,0},{809,4,1,32},{808,4,1,32},{64320,4,0,32},{53940,0,0,0},{809,4,1,
32},{808,4,1,32},{64320,4,0,32},{52963,0,0,0},{809,4,1,32},{808,4,1,32},{64320,
4,0,32},{54396,0,0,0},{809,4,1,32},{808,4,1,32},{64320,4,0,32},{56166,0,0,0},
{809,4,1,32},{808,4,1,32},{64320,4,0,32},{63203,0,0,0},{809,4,1,32},{808,4,1,
32},{64320,4,0,32},{52993,0,0,0},{809,4,1,32},{808,4,1,32},{64321,4,0,32},
{36039,0,0,0},{809,4,1,32},{808,4,1,32},{64320,4,0,32},{54100,0,0,0},{809,4,1,
32},{808,4,1,32},{64320,4,0,32},{63853,0,0,0},{809,4,1,32},{808,4,1,32},{64320,
4,0,32},{53009,0,0,0},{809,4,1,32},{808,4,1,32},{64321,4,0,32},{33258,0,0,0},
{809,4,1,32},{808,4,1,32},{64321,4,0,32},{33267,0,0,0},{809,4,1,32},{64320,6,0,
32},{54607,0,0,0},{64320,6,0,32},{56956,0,0,0},{64320,6,0,32},{58759,0,0,0},
{64320,6,0,32},{64399,0,0,0},{8089,6,0,32},{8088,6,0,32},{8090,6,0,32},{8088,6,
0,32},{8091,6,0,32},{8088,6,0,32},{8092,6,0,32},{8088,6,0,32},{8093,6,0,32},
{8088,6,0,32},{8094,6,0,32},{8088,6,0,32},{8095,6,0,32},{8088,6,0,32},{8096,6,0,
32},{8088,6,0,32},{8555,29,0,32},{8695,29,0,32},{8199,29,0,32},{8090,6,0,32},
{8089,6,0,32},{8090,6,0,32},{8090,6,0,32},{8090,6,0,32},{8091,6,0,32},{8090,6,0,
32},{8092,6,0,32},{8090,6,0,32},{8093,6,0,32},{8090,6,0,32},{8094,6,0,32},{8090,
6,0,32},{8095,6,0,32},{8090,6,0,32},{8096,6,0,32},{8090,6,0,32},{8097,6,0,32},
{8091,6,0,32},{8088,6,0,32},{8091,6,0,32},{8089,6,0,32},{8091,6,0,32},{8090,6,0,
32},{8091,6,0,32},{8091,6,0,32},{8091,6,0,32},{8092,6,0,32},{8091,6,0,32},{8093,
6,0,32},{16757,6,0,32},{16883,6,0,32},{16759,6,0,32},{16883,6,0,32},{16760,6,0,
32},{16883,6,0,32},{16762,6,0,32},{16883,6,0,32},{16763,6,0,32},{16883,6,0,32},
{16764,6,0,32},{16883,6,0,32},{16766,6,0,32},{16883,6,0,32},{16768,6,0,32},
{16883,6,0,32},{16769,6,0,32},{16883,6,0,32},{16771,6,0,32},{16883,6,0,32},
{16772,6,0,32},{16883,6,0,32},{16773,6,0,32},{16883,6,0,32},{16774,6,0,32},
{16883,6,0,32},{16775,6,0,32},{16883,6,0,32},{16771,6,0,32},{16883,6,0,32},
{16992,6,0,32},{16757,6,0,32},{16891,6,0,32},{16769,6,0,32},{16896,6,0,32},
{16768,6,0,32},{16902,6,0,32},{16768,6,0,32},{16896,6,0,32},{64320,6,0,32},
{52736,0,0,0},{64320,6,0,32},{52876,0,0,0},{64320,6,0,32},{52745,0,0,0},{64320,
6,0,32},{55003,0,0,0},{64320,6,0,32},{52884,0,0,0},{64320,6,0,32},{53613,0,0,0},
{64320,6,0,32},{52739,0,0,0},{64320,6,0,32},{53611,0,0,0},{64320,6,0,32},{52829,
0,0,0},{64320,6,0,32},{54081,0,0,0},{64320,6,0,32},{59144,0,0,0},{64320,6,0,32},
{61547,0,0,0},{64320,6,0,32},{60468,0,0,0},{64320,6,0,32},{59176,0,0,0},{64321,
6,0,32},{37329,0,0,0},{64320,6,0,32},{55071,0,0,0},{64320,6,0,32},{58853,0,0,0},
{64320,6,0,32},{59434,0,0,0},{64320,6,0,32},{59145,0,0,0},{64320,6,0,32},{63806,
0,0,0},{64320,6,0,32},{54285,0,0,0},{64320,6,0,32},{62073,0,0,0},{64321,6,0,32},
{36001,0,0,0},{64320,6,0,32},{63837,0,0,0},{64320,6,0,32},{53940,0,0,0},{64320,
6,0,32},{63960,0,0,0},{64320,6,0,32},{62775,0,0,0},{64320,6,0,32},{55667,0,0,0},
{64321,6,0,32},{36969,0,0,0},{64320,6,0,32},{53546,0,0,0},{64320,6,0,32},{54128,
0,0,0},{64320,6,0,32},{60648,0,0,0},{64321,6,0,32},{38917,0,0,0},{64320,6,0,32},
{53009,0,0,0},{64320,6,0,32},{53657,0,0,0},{64320,6,0,32},{60259,0,0,0},{64320,
6,0,32},{52746,0,0,0},{64320,6,0,32},{52781,0,0,0},{64320,6,0,32},{52747,0,0,0},
{64320,6,0,32},{56806,0,0,0},{64320,6,0,32},{54259,0,0,0},{64320,6,0,32},{54075,
0,0,0},{64320,6,0,32},{56215,0,0,0},{64320,6,0,32},{56166,0,0,0},{64320,6,0,32},
{63203,0,0,0},{64320,6,0,32},{52993,0,0,0},{64321,6,0,32},{36039,0,0,0},{64320,
6,0,32},{54100,0,0,0},{64320,6,0,32},{55580,0,0,0},{8091,6,0,32},{8094,6,0,32},
{8091,6,0,32},{8095,6,0,32},{8091,6,0,32},{8096,6,0,32},{8091,6,0,32},{8097,6,0,
32},{8092,6,0,32},{8088,6,0,32},{8092,6,0,32},{8089,6,0,32},{8092,6,0,32},{8090,
6,0,32},{8092,6,0,32},{8091,6,0,32},{8092,6,0,32},{8092,6,0,32},{8092,6,0,32},
{8093,6,0,32},{8092,6,0,32},{8094,6,0,32},{8092,6,0,32},{8095,6,0,32},{8092,6,0,
32},{8096,6,0,32},{8092,6,0,32},{8097,6,0,32},{8093,6,0,32},{8088,6,0,32},{8089,
4,0,32},{64320,4,0,32},{59144,0,0,0},{8090,4,0,32},{64320,4,0,32},{59144,0,0,0},
{8091,4,0,32},{64320,4,0,32},{59144,0,0,0},{8092,4,0,32},{64320,4,0,32},{59144,
0,0,0},{8093,4,0,32},{64320,4,0,32},{59144,0,0,0},{8094,4,0,32},{64320,4,0,32},
{59144,0,0,0},{8095,4,0,32},{64320,4,0,32},{59144,0,0,0},{8096,4,0,32},{64320,4,
0,32},{59144,0,0,0},{8097,4,0,32},{64320,4,0,32},{59144,0,0,0},{8089,4,0,32},
{8088,4,0,32},{64320,4,0,32},{59144,0,0,0},{8089,4,0,32},{8089,4,0,32},{64320,4,
0,32},{59144,0,0,0},{8089,4,0,32},{8090,4,0,32},{64320,4,0,32},{59144,0,0,0},
{8309,29,0,32},{8273,28,0,32},{8199,28,0,32},{8595,28,0,32},{8273,28,0,32},
{8199,28,0,32},{8775,29,0,32},{8406,29,0,32},{8695,29,0,32},{8171,29,0,32},
{64320,28,0,32},{52964,0,0,0},{64320,28,0,32},{54412,0,0,0},{17114,28,0,32},
{17140,28,0,32},{0,28,0,56},{8032,28,0,32},{17134,28,0,32},{17114,28,0,32},
{17155,28,0,32},{17142,28,0,32},{17114,28,0,32},{17114,28,0,32},{17162,28,0,32},
{17143,28,0,32},{0,28,0,56},{17114,28,0,32},{17114,28,0,32},{8032,28,0,32},
{17155,28,0,32},{17115,28,0,32},{17136,28,0,32},{17162,28,0,32},{17122,28,0,32},
{0,28,0,55},{17115,28,0,32},{17162,28,0,32},{17131,28,0,32},{17116,28,0,32},
{17119,28,0,32},{17162,28,0,32},{17118,28,0,32},{17127,28,0,32},{17122,28,0,32},
{8032,28,0,32},{17134,28,0,32},{0,28,0,55},{17118,28,0,32},{8032,28,0,32},
{17120,28,0,32},{8032,28,0,32},{17119,28,0,32},{17162,28,0,32},{17127,28,0,32},
{17119,28,0,32},{8032,28,0,32},{17147,28,0,32},{17120,28,0,32},{17115,28,0,32},
{17154,28,0,32},{17120,28,0,32},{17153,28,0,32},{17132,28,0,32},{17134,28,0,32},
{17120,28,0,32},{17157,28,0,32},{17154,28,0,32},{8032,28,0,32},{17120,28,0,32},
{0,28,0,55},{17157,28,0,32},{17162,28,0,32},{17120,28,0,32},{0,28,0,55},{17162,
28,0,32},{17145,28,0,32},{17121,28,0,32},{0,28,0,55},{17120,28,0,32},{0,28,0,
55},{17121,28,0,32},{0,28,0,55},{17136,28,0,32},{8032,28,0,32},{17121,28,0,32},
{17151,28,0,32},{17154,28,0,32},{8032,28,0,32},{17121,28,0,32},{0,28,0,55},
{17155,28,0,32},{17130,28,0,32},{0,28,0,55},{8032,28,0,32},{17121,28,0,32},
{17157,28,0,32},{17121,28,0,32},{17157,28,0,32},{17122,28,0,32},{0,28,0,55},
{17153,28,0,32},{17147,28,0,32},{17121,28,0,32},{17157,28,0,32},{17148,28,0,32},
{8032,28,0,32},{17134,28,0,32},{17155,28,0,32},{17121,28,0,32},{17157,28,0,32},
{17158,28,0,32},{17132,28,0,32},{17134,28,0,32},{17122,28,0,32},{0,28,0,55},
{17153,28,0,32},{17147,28,0,32},{17122,28,0,32},{0,28,0,55},{17153,28,0,32},
{17147,28,0,32},{17134,28,0,32},{17162,28,0,32},{17122,28,0,32},{17155,28,0,32},
{17128,28,0,32},{0,28,0,55},{17115,28,0,32},{17157,28,0,32},{17122,28,0,32},
{17157,28,0,32},{8032,28,0,32},{17138,28,0,32},{17123,28,0,32},{8032,28,0,32},
{17127,28,0,32},{17124,28,0,32},{17155,28,0,32},{17135,28,0,32},{17124,28,0,32},
{8032,28,0,32},{17144,28,0,32},{0,28,0,56},{17125,28,0,32},{17115,28,0,32},
{17122,28,0,32},{17155,28,0,32},{17125,28,0,32},{17162,28,0,32},{17131,28,0,32},
{8032,28,0,32},{17147,28,0,32},{17126,28,0,32},{17154,28,0,32},{17162,28,0,32},
{17122,28,0,32},{0,28,0,55},{17128,28,0,32},{17162,28,0,32},{17131,28,0,32},
{17128,28,0,32},{17162,28,0,32},{17134,28,0,32},{17130,28,0,32},{0,28,0,55},
{8032,28,0,32},{17127,28,0,32},{17133,28,0,32},{0,28,0,55},{17126,28,0,32},
{17134,28,0,32},{0,28,0,55},{17155,28,0,32},{17134,28,0,32},{17162,28,0,32},
{17135,28,0,32},{17139,28,0,32},{17139,28,0,32},{17132,28,0,32},{17134,28,0,32},
{17140,28,0,32},{17115,28,0,32},{17132,28,0,32},{17140,28,0,32},{0,28,0,56},
{8032,28,0,32},{17128,28,0,32},{17162,28,0,32},{17134,28,0,32},{17140,28,0,32},
{0,28,0,56},{8032,28,0,32},{17132,28,0,32},{17140,28,0,32},{0,28,0,55},{8032,28,
0,32},{17156,28,0,32},{17155,28,0,32},{17141,28,0,32},{0,28,0,56},{17114,28,0,
32},{17127,28,0,32},{17134,28,0,32},{17155,28,0,32},{17141,28,0,32},{0,28,0,56},
{17122,28,0,32},{17155,28,0,32},{17141,28,0,32},{0,28,0,56},{17124,28,0,32},
{17141,28,0,32},{0,28,0,55},{17155,28,0,32},{17142,28,0,32},{17114,28,0,32},
{17153,28,0,32},{17132,28,0,32},{17134,28,0,32},{0,28,0,55},{17142,28,0,32},
{17115,28,0,32},{8032,28,0,32},{17134,28,0,32},{17142,28,0,32},{0,28,0,55},
{17132,28,0,32},{17126,28,0,32},{17118,28,0,32},{17155,28,0,32},{17142,28,0,32},
{17153,28,0,32},{17162,28,0,32},{17143,28,0,32},{17122,28,0,32},{17130,28,0,32},
{8032,28,0,32},{17155,28,0,32},{17143,28,0,32},{0,28,0,56},{17129,28,0,32},
{17143,28,0,32},{0,28,0,56},{17136,28,0,32},{17141,28,0,32},{17143,28,0,32},
{17155,28,0,32},{17132,28,0,32},{17143,28,0,32},{0,28,0,56},{17162,28,0,32},
{17127,28,0,32},{17143,28,0,32},{0,28,0,56},{8032,28,0,32},{17126,28,0,32},{0,
28,0,55},{17143,28,0,32},{0,28,0,55},{8032,28,0,32},{17130,28,0,32},{17144,28,0,
32},{0,28,0,56},{17115,28,0,32},{17162,28,0,32},{17134,28,0,32},{17144,28,0,32},
{0,28,0,55},{17155,28,0,32},{17134,28,0,32},{17144,28,0,32},{17162,28,0,32},
{17144,28,0,32},{0,28,0,56},{17162,28,0,32},{17134,28,0,32},{0,28,0,55},{17144,
28,0,32},{8032,28,0,32},{17155,28,0,32},{17144,28,0,32},{8032,28,0,32},{17162,
28,0,32},{17145,28,0,32},{17115,28,0,32},{17122,28,0,32},{17157,28,0,32},{17145,
28,0,32},{17115,28,0,32},{17155,28,0,32},{17145,28,0,32},{17132,28,0,32},{17140,
28,0,32},{17145,28,0,32},{17155,28,0,32},{17122,28,0,32},{17145,28,0,32},{17162,
28,0,32},{17126,28,0,32},{17152,28,0,32},{17162,28,0,32},{17146,28,0,32},{17122,
28,0,32},{17157,28,0,32},{17162,28,0,32},{17146,28,0,32},{17154,28,0,32},{17146,
28,0,32},{17154,28,0,32},{17140,28,0,32},{0,28,0,55},{8032,28,0,32},{17155,28,0,
32},{17148,28,0,32},{17120,28,0,32},{0,28,0,55},{17148,28,0,32},{17120,28,0,32},
{0,28,0,55},{17134,28,0,32},{17162,28,0,32},{17148,28,0,32},{8032,28,0,32},
{17134,28,0,32},{17155,28,0,32},{17150,28,0,32},{8032,28,0,32},{17134,28,0,32},
{0,28,0,55},{17150,28,0,32},{8032,28,0,32},{17155,28,0,32},{17151,28,0,32},
{17114,28,0,32},{17162,28,0,32},{17154,28,0,32},{17132,28,0,32},{17134,28,0,32},
{17155,28,0,32},{17154,28,0,32},{17153,28,0,32},{17155,28,0,32},{17141,28,0,32},
{0,28,0,56},{8032,28,0,32},{17155,28,0,32},{8032,28,0,32},{17142,28,0,32},{0,28,
0,55},{17155,28,0,32},{17156,28,0,32},{17147,28,0,32},{17156,28,0,32},{17162,28,
0,32},{17134,28,0,32},{17123,28,0,32},{0,28,0,55},{17162,28,0,32},{17158,28,0,
32},{17132,28,0,32},{17134,28,0,32},{8088,4,0,32},{64320,4,0,32},{61625,0,0,0},
{8089,4,0,32},{64320,4,0,32},{61625,0,0,0},{8090,4,0,32},{64320,4,0,32},{61625,
0,0,0},{8091,4,0,32},{64320,4,0,32},{61625,0,0,0},{8092,4,0,32},{64320,4,0,32},
{61625,0,0,0},{8093,4,0,32},{64320,4,0,32},{61625,0,0,0},{8094,4,0,32},{64320,4,
0,32},{61625,0,0,0},{8095,4,0,32},{64320,4,0,32},{61625,0,0,0},{8096,4,0,32},
{64320,4,0,32},{61625,0,0,0},{8097,4,0,32},{64320,4,0,32},{61625,0,0,0},{8089,4,
0,32},{8088,4,0,32},{64320,4,0,32},{61625,0,0,0},{8089,4,0,32},{8089,4,0,32},
{64320,4,0,32},{61625,0,0,0},{8089,4,0,32},{8090,4,0,32},{64320,4,0,32},{61625,
0,0,0},{8089,4,0,32},{8091,4,0,32},{64320,4,0,32},{61625,0,0,0},{8089,4,0,32},
{8092,4,0,32},{64320,4,0,32},{61625,0,0,0},{8089,4,0,32},{8093,4,0,32},{64320,4,
0,32},{61625,0,0,0},{8089,4,0,32},{8094,4,0,32},{64320,4,0,32},{61625,0,0,0},
{8089,4,0,32},{8095,4,0,32},{64320,4,0,32},{61625,0,0,0},{8089,4,0,32},{8096,4,
0,32},{64320,4,0,32},{61625,0,0,0},{8089,4,0,32},{8097,4,0,32},{64320,4,0,32},
{61625,0,0,0},{8090,4,0,32},{8088,4,0,32},{64320,4,0,32},{61625,0,0,0},{8090,4,
0,32},{8089,4,0,32},{64320,4,0,32},{61625,0,0,0},{8090,4,0,32},{8090,4,0,32},
{64320,4,0,32},{61625,0,0,0},{8090,4,0,32},{8091,4,0,32},{64320,4,0,32},{61625,
0,0,0},{8090,4,0,32},{8092,4,0,32},{64320,4,0,32},{61625,0,0,0},{8309,28,0,32},
{8555,29,0,32},{8098,28,0,32},{8171,28,0,32},{8098,28,0,32},{8098,29,0,32},
{8727,29,0,32},{8124,28,0,32},{8098,28,0,32},{8595,28,0,32},{8508,28,0,32},
{8775,29,0,32},{8555,28,0,32},{8150,28,0,32},{8171,28,0,32},{8457,28,0,32},
{8171,28,0,32},{8457,28,0,32},{8090,28,0,32},{8171,28,0,32},{8457,28,0,32},
{8091,28,0,32},{8336,29,0,32},{8727,29,0,32},{64320,28,0,32},{56947,0,0,0},
{64320,28,0,32},{57872,0,0,0},{64320,28,0,32},{58925,0,0,0},{64320,28,0,32},
{54412,0,0,0},{64320,28,0,32},{55591,0,0,0},{64320,28,0,32},{60259,0,0,0},
{64320,28,0,32},{58894,0,0,0},{64320,28,0,32},{60603,0,0,0},{64320,28,0,32},
{59434,0,0,0},{64320,28,0,32},{57103,0,0,0},{64320,28,0,32},{53018,0,0,0},
{64320,28,0,32},{63806,0,0,0},{8555,28,0,32},{8098,29,0,32},{8472,28,0,32},
{8098,29,0,32},{9008,28,0,32},{8098,29,0,32},{8457,28,0,32},{8098,29,0,32},
{8388,28,0,32},{8098,29,0,32},{8388,29,0,32},{8124,29,0,32},{8457,29,0,32},
{8124,29,0,32},{8273,29,0,32},{8124,29,0,32},{8150,28,0,32},{8098,28,0,32},
{8406,28,0,32},{8388,28,0,32},{8150,28,0,32},{8098,28,0,32},{8406,28,0,32},
{8555,28,0,32},{8258,29,0,32},{8472,28,0,32},{8258,29,0,32},{9008,28,0,32},
{8258,29,0,32},{9008,28,0,32},{8273,28,0,32},{8457,28,0,32},{8273,28,0,32},
{8388,28,0,32},{8273,28,0,32},{8309,29,0,32},{8838,28,0,32},{8388,28,0,32},
{8309,29,0,32},{8838,28,0,32},{8457,29,0,32},{8309,29,0,32},{8838,28,0,32},
{8273,29,0,32},{8309,29,0,32},{8838,28,0,32},{8695,29,0,32},{8309,29,0,32},
{8838,28,0,32},{9008,28,0,32},{8406,28,0,32},{8457,28,0,32},{8406,28,0,32},
{8171,28,0,32},{8406,28,0,32},{8388,28,0,32},{8406,28,0,32},{8258,28,0,32},
{8457,28,0,32},{8472,28,0,32},{8457,28,0,32},{9008,28,0,32},{8457,28,0,32},
{8457,28,0,32},{8457,28,0,32},{8150,28,0,32},{8457,28,0,32},{8388,28,0,32},
{8457,28,0,32},{8457,28,0,32},{8457,28,0,32},{8090,28,0,32},{8150,28,0,32},
{8457,28,0,32},{8090,28,0,32},{8457,28,0,32},{8090,28,0,32},{8388,28,0,32},
{8457,28,0,32},{8090,28,0,32},{8457,28,0,32},{8457,28,0,32},{8091,28,0,32},
{8150,28,0,32},{8457,28,0,32},{8091,28,0,32},{8457,28,0,32},{8091,28,0,32},
{8388,28,0,32},{8457,28,0,32},{8091,28,0,32},{8457,28,0,32},{1653,28,1,32},
{8658,28,0,32},{8457,28,0,32},{1653,28,1,32},{8658,28,0,32},{8090,28,0,32},
{8555,29,0,32},{8098,28,0,32},{8388,28,0,32},{8555,29,0,32},{8098,28,0,32},
{8457,29,0,32},{8555,29,0,32},{8098,28,0,32},{8273,29,0,32},{8555,29,0,32},
{8098,28,0,32},{8595,28,0,32},{8098,28,0,32},{8171,28,0,32},{8595,28,0,32},
{8098,28,0,32},{8171,28,0,32},{1653,28,1,32},{8658,28,0,32},{8595,28,0,32},
{8098,28,0,32},{8171,28,0,32},{1653,28,1,32},{8658,28,0,32},{8090,28,0,32},
{8555,28,0,32},{8658,28,0,32},{8472,28,0,32},{8658,28,0,32},{9008,28,0,32},
{8658,28,0,32},{8457,28,0,32},{8658,28,0,32},{8555,28,0,32},{8775,29,0,32},
{8472,28,0,32},{8775,29,0,32},{9008,28,0,32},{8775,29,0,32},{8457,28,0,32},
{8775,29,0,32},{8388,28,0,32},{8775,29,0,32},{8457,29,0,32},{8775,29,0,32},
{8555,28,0,32},{8793,29,0,32},{8472,28,0,32},{8793,29,0,32},{9008,28,0,32},
{8793,29,0,32},{8457,28,0,32},{8793,29,0,32},{8388,28,0,32},{8793,29,0,32},
{8457,29,0,32},{8793,29,0,32},{8388,28,0,32},{9030,29,0,32},{8457,29,0,32},
{9030,29,0,32},{8098,28,0,32},{638,28,1,32},{8457,28,0,32},{638,28,1,32},{8124,
29,0,32},{8576,28,0,32},{8150,28,0,32},{8150,28,0,32},{8150,28,0,32},{8171,28,0,
32},{8150,29,0,32},{1653,28,1,32},{8388,28,0,32},{8273,28,0,32},{8150,29,0,32},
{8508,28,0,32},{638,28,1,32},{8171,28,0,32},{8124,29,0,32},{8273,29,0,32},{8816,
28,0,32},{8309,28,0,32},{8098,28,0,32},{8309,29,0,32},{8555,29,0,32},{8336,28,0,
32},{8472,28,0,32},{8388,29,0,32},{8388,29,0,32},{8388,29,0,32},{8457,29,0,32},
{8388,28,0,32},{8695,28,0,32},{8406,28,0,32},{8457,28,0,32},{8406,28,0,32},
{8472,28,0,32},{8406,28,0,32},{8508,28,0,32},{8273,28,0,32},{8406,28,0,32},
{8804,28,0,32},{8457,28,0,32},{8124,28,0,32},{8457,28,0,32},{8336,28,0,32},
{8406,28,0,32},{8457,28,0,32},{8508,28,0,32},{8406,28,0,32},{8555,29,0,32},
{8309,29,0,32},{8555,28,0,32},{638,28,1,32},{8457,28,0,32},{638,28,1,32},{8555,
29,0,32},{8555,29,0,32},{8457,29,0,32},{8555,29,0,32},{8595,29,0,32},{8658,28,0,
32},{8595,28,0,32},{8658,29,0,32},{8775,28,0,32},{8793,29,0,32},{8124,28,0,32},
{8775,29,0,32},{1653,28,1,32},{8457,28,0,32},{8098,29,0,32},{1653,28,1,32},
{8457,28,0,32},{8089,4,0,32},{64320,4,0,32},{58853,0,0,0},{8090,4,0,32},{64320,
4,0,32},{58853,0,0,0},{8091,4,0,32},{64320,4,0,32},{58853,0,0,0},{8092,4,0,32},
{64320,4,0,32},{58853,0,0,0},{8093,4,0,32},{64320,4,0,32},{58853,0,0,0},{8094,4,
0,32},{64320,4,0,32},{58853,0,0,0},{8095,4,0,32},{64320,4,0,32},{58853,0,0,0},
{8096,4,0,32},{64320,4,0,32},{58853,0,0,0},{8097,4,0,32},{64320,4,0,32},{58853,
0,0,0},{8089,4,0,32},{8088,4,0,32},{64320,4,0,32},{58853,0,0,0},{8089,4,0,32},
{8089,4,0,32},{64320,4,0,32},{58853,0,0,0},{8089,4,0,32},{8090,4,0,32},{64320,4,
0,32},{58853,0,0,0},{8089,4,0,32},{8091,4,0,32},{64320,4,0,32},{58853,0,0,0},
{8089,4,0,32},{8092,4,0,32},{64320,4,0,32},{58853,0,0,0},{8089,4,0,32},{8093,4,
0,32},{64320,4,0,32},{58853,0,0,0},{8089,4,0,32},{8094,4,0,32},{64320,4,0,32},
{58853,0,0,0},{8089,4,0,32},{8095,4,0,32},{64320,4,0,32},{58853,0,0,0},{8089,4,
0,32},{8096,4,0,32},{64320,4,0,32},{58853,0,0,0},{8089,4,0,32},{8097,4,0,32},
{64320,4,0,32},{58853,0,0,0},{8090,4,0,32},{8088,4,0,32},{64320,4,0,32},{58853,
0,0,0},{8090,4,0,32},{8089,4,0,32},{64320,4,0,32},{58853,0,0,0},{8090,4,0,32},
{8090,4,0,32},{64320,4,0,32},{58853,0,0,0},{8090,4,0,32},{8091,4,0,32},{64320,4,
0,32},{58853,0,0,0},{8090,4,0,32},{8092,4,0,32},{64320,4,0,32},{58853,0,0,0},
{8090,4,0,32},{8093,4,0,32},{64320,4,0,32},{58853,0,0,0},{8090,4,0,32},{8094,4,
0,32},{64320,4,0,32},{58853,0,0,0},{8090,4,0,32},{8095,4,0,32},{64320,4,0,32},
{58853,0,0,0},{8090,4,0,32},{8096,4,0,32},{64320,4,0,32},{58853,0,0,0},{8090,4,
0,32},{8097,4,0,32},{64320,4,0,32},{58853,0,0,0},{8091,4,0,32},{8088,4,0,32},
{64320,4,0,32},{58853,0,0,0},{8091,4,0,32},{8089,4,0,32},{64320,4,0,32},{58853,
0,0,0},{8273,28,0,32},{8098,28,0,32},{8406,28,0,32},{64384,2,0,32},{46238,0,0,
0},{64384,2,0,32},{46265,0,0,0},{64384,2,0,32},{46267,0,0,0},{64384,2,0,32},
{46303,0,0,0},{64384,2,0,32},{46357,0,0,0},{64384,2,0,32},{46830,0,0,0},{64384,
2,0,32},{46844,0,0,0},{64384,2,0,32},{46977,0,0,0},{64384,2,0,32},{47151,0,0,0},
{64384,2,0,32},{47202,0,0,0},{64384,2,0,32},{47228,0,0,0},{64384,2,0,32},{47303,
0,0,0},{64384,2,0,32},{47331,0,0,0},{64384,2,0,32},{47388,0,0,0},{64384,2,0,32},
{47418,0,0,0},{64384,2,0,32},{47662,0,0,0},{64384,2,0,32},{47724,0,0,0},{64384,
2,0,32},{47844,0,0,0},{64384,2,0,32},{47880,0,0,0},{64384,2,0,32},{47897,0,0,0},
{64384,2,0,32},{47945,0,0,0},{64384,2,0,32},{48029,0,0,0},{64384,2,0,32},{48152,
0,0,0},{64384,2,0,32},{48206,0,0,0},{64384,2,0,32},{48435,0,0,0},{64384,2,0,32},
{48534,0,0,0},{64384,2,0,32},{48812,0,0,0},{64384,2,0,32},{48824,0,0,0},{64384,
2,0,32},{48923,0,0,0},{64384,2,0,32},{49148,0,0,0},{64384,2,0,32},{49160,0,0,0},
{64384,2,0,32},{49176,0,0,0},{64384,2,0,32},{49209,0,0,0},{64384,2,0,32},{49222,
0,0,0},{64384,2,0,32},{49302,0,0,0},{64384,2,0,32},{49379,0,0,0},{64384,2,0,32},
{49455,0,0,0},{64384,2,0,32},{49666,0,0,0},{64384,2,0,32},{49703,0,0,0},{64384,
2,0,32},{49824,0,0,0},{64384,2,0,32},{49921,0,0,0},{64384,2,0,32},{49972,0,0,0},
{64384,2,0,32},{50009,0,0,0},{64384,2,0,32},{50133,0,0,0},{64384,2,0,32},{50137,
0,0,0},{64384,2,0,32},{50187,0,0,0},{64384,2,0,32},{50283,0,0,0},{64384,2,0,32},
{50475,0,0,0},{64384,2,0,32},{50525,0,0,0},{64384,2,0,32},{50529,0,0,0},{64384,
2,0,32},{50539,0,0,0},{64384,2,0,32},{50647,0,0,0},{64384,2,0,32},{50681,0,0,0},
{64384,2,0,32},{50741,0,0,0},{64384,2,0,32},{50878,0,0,0},{64384,2,0,32},{50887,
0,0,0},{64384,2,0,32},{51605,0,0,0},{64384,2,0,32},{51686,0,0,0},{64384,2,0,32},
{51822,0,0,0},{64384,2,0,32},{51830,0,0,0},{64384,2,0,32},{51890,0,0,0},{64384,
2,0,32},{52019,0,0,0},{64384,2,0,32},{52174,0,0,0},{64384,2,0,32},{52430,0,0,0},
{64384,2,0,32},{52461,0,0,0},{64384,2,0,32},{52472,0,0,0},{64384,2,0,32},{52566,
0,0,0},{64320,2,0,32},{52749,0,0,0},{64320,2,0,32},{52774,0,0,0},{64320,2,0,32},
{52786,0,0,0},{64320,2,0,32},{52792,0,0,0},{64320,2,0,32},{52793,0,0,0},{64320,
2,0,32},{52797,0,0,0},{64320,2,0,32},{52801,0,0,0},{64320,2,0,32},{52866,0,0,0},
{64320,2,0,32},{52870,0,0,0},{64320,2,0,32},{52910,0,0,0},{64320,2,0,32},{52928,
0,0,0},{64320,2,0,32},{52940,0,0,0},{64320,2,0,32},{52964,0,0,0},{64320,2,0,32},
{53088,0,0,0},{64320,2,0,32},{53120,0,0,0},{64320,2,0,32},{53126,0,0,0},{64320,
2,0,32},{53131,0,0,0},{64320,2,0,32},{53166,0,0,0},{64320,2,0,32},{53179,0,0,0},
{64320,2,0,32},{53183,0,0,0},{64320,2,0,32},{53250,0,0,0},{64320,2,0,32},{53291,
0,0,0},{64320,2,0,32},{53370,0,0,0},{64320,2,0,32},{53401,0,0,0},{64320,2,0,32},
{53455,0,0,0},{64320,2,0,32},{53466,0,0,0},{64320,2,0,32},{53479,0,0,0},{64320,
2,0,32},{53568,0,0,0},{64320,2,0,32},{53573,0,0,0},{64320,2,0,32},{53581,0,0,0},
{64320,2,0,32},{53588,0,0,0},{64320,2,0,32},{53604,0,0,0},{64320,2,0,32},{53607,
0,0,0},{64320,2,0,32},{53608,0,0,0},{64320,2,0,32},{53609,0,0,0},{64320,2,0,32},
{53613,0,0,0},{64320,2,0,32},{53623,0,0,0},{64320,2,0,32},{53632,0,0,0},{64320,
2,0,32},{53645,0,0,0},{64320,2,0,32},{53650,0,0,0},{64320,2,0,32},{53653,0,0,0},
{64320,2,0,32},{53655,0,0,0},{64320,2,0,32},{53668,0,0,0},{64320,2,0,32},{53676,
0,0,0},{64320,2,0,32},{53685,0,0,0},{64320,2,0,32},{53687,0,0,0},{64320,2,0,32},
{53705,0,0,0},{64320,2,0,32},{53708,0,0,0},{64320,2,0,32},{53724,0,0,0},{64320,
2,0,32},{53726,0,0,0},{64320,2,0,32},{53749,0,0,0},{64320,2,0,32},{53763,0,0,0},
{64320,2,0,32},{53767,0,0,0},{64320,2,0,32},{53783,0,0,0},{64320,2,0,32},{53801,
0,0,0},{64320,2,0,32},{53818,0,0,0},{64320,2,0,32},{53819,0,0,0},{64320,2,0,32},
{53830,0,0,0},{64320,2,0,32},{53874,0,0,0},{64320,2,0,32},{53879,0,0,0},{64320,
2,0,32},{53897,0,0,0},{64320,2,0,32},{53915,0,0,0},{64320,2,0,32},{53923,0,0,0},
{64320,2,0,32},{53939,0,0,0},{64320,2,0,32},{53959,0,0,0},{64320,2,0,32},{53961,
0,0,0},{64320,2,0,32},{53970,0,0,0},{64320,2,0,32},{53982,0,0,0},{64320,2,0,32},
{53988,0,0,0},{64320,2,0,32},{54005,0,0,0},{64320,2,0,32},{54010,0,0,0},{64320,
2,0,32},{54021,0,0,0},{64320,2,0,32},{54022,0,0,0},{64320,2,0,32},{54039,0,0,0},
{64320,2,0,32},{54079,0,0,0},{64320,2,0,32},{54089,0,0,0},{64320,2,0,32},{54097,
0,0,0},{64320,2,0,32},{54106,0,0,0},{64320,2,0,32},{54131,0,0,0},{64320,2,0,32},
{54133,0,0,0},{64320,2,0,32},{54141,0,0,0},{64320,2,0,32},{54143,0,0,0},{64320,
2,0,32},{54211,0,0,0},{64320,2,0,32},{54218,0,0,0},{64320,2,0,32},{54239,0,0,0},
{64320,2,0,32},{54245,0,0,0},{64320,2,0,32},{54251,0,0,0},{64320,2,0,32},{54257,
0,0,0},{64320,2,0,32},{54278,0,0,0},{64320,2,0,32},{54287,0,0,0},{64320,2,0,32},
{54301,0,0,0},{64320,2,0,32},{54328,0,0,0},{64320,2,0,32},{54338,0,0,0},{64320,
2,0,32},{54344,0,0,0},{64320,2,0,32},{54376,0,0,0},{64320,2,0,32},{54430,0,0,0},
{64320,2,0,32},{54434,0,0,0},{64320,2,0,32},{54461,0,0,0},{64320,2,0,32},{54518,
0,0,0},{64320,2,0,32},{54544,0,0,0},{64320,2,0,32},{54611,0,0,0},{64320,2,0,32},
{54613,0,0,0},{64320,2,0,32},{54627,0,0,0},{64320,2,0,32},{54660,0,0,0},{64320,
2,0,32},{54663,0,0,0},{64320,2,0,32},{54681,0,0,0},{64320,2,0,32},{54685,0,0,0},
{64320,2,0,32},{54699,0,0,0},{64320,2,0,32},{54707,0,0,0},{64320,2,0,32},{54720,
0,0,0},{64320,2,0,32},{54722,0,0,0},{64320,2,0,32},{54754,0,0,0},{64320,2,0,32},
{54790,0,0,0},{64320,2,0,32},{54865,0,0,0},{64320,2,0,32},{54888,0,0,0},{64320,
2,0,32},{54900,0,0,0},{64320,2,0,32},{55033,0,0,0},{64320,2,0,32},{55062,0,0,0},
{64320,2,0,32},{55063,0,0,0},{64320,2,0,32},{55179,0,0,0},{64320,2,0,32},{55246,
0,0,0},{64320,2,0,32},{55284,0,0,0},{64320,2,0,32},{55309,0,0,0},{64320,2,0,32},
{55345,0,0,0},{64320,2,0,32},{55346,0,0,0},{64320,2,0,32},{55360,0,0,0},{64320,
2,0,32},{55386,0,0,0},{64320,2,0,32},{55390,0,0,0},{64320,2,0,32},{55464,0,0,0},
{64320,2,0,32},{55468,0,0,0},{64320,2,0,32},{55475,0,0,0},{64320,2,0,32},{55512,
0,0,0},{64320,2,0,32},{55519,0,0,0},{64320,2,0,32},{55534,0,0,0},{64320,2,0,32},
{55538,0,0,0},{64320,2,0,32},{55543,0,0,0},{64320,2,0,32},{55558,0,0,0},{64320,
2,0,32},{55578,0,0,0},{64320,2,0,32},{55586,0,0,0},{64320,2,0,32},{55620,0,0,0},
{64320,2,0,32},{55624,0,0,0},{64320,2,0,32},{55633,0,0,0},{64320,2,0,32},{55636,
0,0,0},{64320,2,0,32},{55650,0,0,0},{64320,2,0,32},{55667,0,0,0},{64320,2,0,32},
{55768,0,0,0},{64320,2,0,32},{55788,0,0,0},{64320,2,0,32},{55835,0,0,0},{64320,
2,0,32},{55847,0,0,0},{64320,2,0,32},{55906,0,0,0},{64320,2,0,32},{55910,0,0,0},
{64320,2,0,32},{55989,0,0,0},{64320,2,0,32},{56072,0,0,0},{64320,2,0,32},{56104,
0,0,0},{64320,2,0,32},{56126,0,0,0},{64320,2,0,32},{56197,0,0,0},{64320,2,0,32},
{56259,0,0,0},{64320,2,0,32},{56280,0,0,0},{64320,2,0,32},{56295,0,0,0},{64320,
2,0,32},{56302,0,0,0},{64320,2,0,32},{56307,0,0,0},{64320,2,0,32},{56319,0,0,0},
{64320,2,0,32},{56326,0,0,0},{64320,2,0,32},{56354,0,0,0},{64320,2,0,32},{56383,
0,0,0},{64320,2,0,32},{56416,0,0,0},{64320,2,0,32},{56418,0,0,0},{64320,2,0,32},
{56420,0,0,0},{64320,2,0,32},{56421,0,0,0},{64320,2,0,32},{56430,0,0,0},{64320,
2,0,32},{56461,0,0,0},{64320,2,0,32},{56512,0,0,0},{64320,2,0,32},{56601,0,0,0},
{64320,2,0,32},{56643,0,0,0},{64320,2,0,32},{56656,0,0,0},{64320,2,0,32},{56683,
0,0,0},{64320,2,0,32},{56686,0,0,0},{64320,2,0,32},{56700,0,0,0},{64320,2,0,32},
{56754,0,0,0},{64320,2,0,32},{56762,0,0,0},{64320,2,0,32},{56801,0,0,0},{64320,
2,0,32},{56802,0,0,0},{64320,2,0,32},{56829,0,0,0},{64320,2,0,32},{56872,0,0,0},
{64320,2,0,32},{56893,0,0,0},{64320,2,0,32},{56937,0,0,0},{64320,2,0,32},{56948,
0,0,0},{64320,2,0,32},{56998,0,0,0},{64320,2,0,32},{57008,0,0,0},{64320,2,0,32},
{57011,0,0,0},{64320,2,0,32},{57014,0,0,0},{64320,2,0,32},{57033,0,0,0},{64320,
2,0,32},{57034,0,0,0},{64320,2,0,32},{57042,0,0,0},{64320,2,0,32},{57043,0,0,0},
{64320,2,0,32},{57049,0,0,0},{64320,2,0,32},{57068,0,0,0},{64320,2,0,32},{57086,
0,0,0},{64320,2,0,32},{57092,0,0,0},{64320,2,0,32},{57122,0,0,0},{64320,2,0,32},
{57171,0,0,0},{64320,2,0,32},{57186,0,0,0},{64320,2,0,32},{57193,0,0,0},{64320,
2,0,32},{57195,0,0,0},{64320,2,0,32},{57227,0,0,0},{64320,2,0,32},{57242,0,0,0},
{64320,2,0,32},{57257,0,0,0},{64320,2,0,32},{57261,0,0,0},{64320,2,0,32},{57293,
0,0,0},{64320,2,0,32},{57303,0,0,0},{64320,2,0,32},{57333,0,0,0},{64320,2,0,32},
{57337,0,0,0},{64320,2,0,32},{57362,0,0,0},{64320,2,0,32},{57372,0,0,0},{64320,
2,0,32},{57461,0,0,0},{64320,2,0,32},{57473,0,0,0},{64320,2,0,32},{57492,0,0,0},
{64320,2,0,32},{57543,0,0,0},{64320,2,0,32},{57560,0,0,0},{64320,2,0,32},{57569,
0,0,0},{64320,2,0,32},{57608,0,0,0},{64320,2,0,32},{57668,0,0,0},{64320,2,0,32},
{57672,0,0,0},{64320,2,0,32},{57676,0,0,0},{64320,2,0,32},{57678,0,0,0},{64320,
2,0,32},{57696,0,0,0},{64320,2,0,32},{57704,0,0,0},{64320,2,0,32},{57722,0,0,0},
{64320,2,0,32},{57742,0,0,0},{64320,2,0,32},{57744,0,0,0},{64320,2,0,32},{57764,
0,0,0},{64320,2,0,32},{57775,0,0,0},{64320,2,0,32},{57778,0,0,0},{64320,2,0,32},
{57822,0,0,0},{64320,2,0,32},{57842,0,0,0},{64320,2,0,32},{57846,0,0,0},{64320,
2,0,32},{57856,0,0,0},{64320,2,0,32},{57872,0,0,0},{64320,2,0,32},{57883,0,0,0},
{64320,2,0,32},{57902,0,0,0},{64320,2,0,32},{57908,0,0,0},{64320,2,0,32},{57949,
0,0,0},{64320,2,0,32},{58033,0,0,0},{64320,2,0,32},{58057,0,0,0},{64320,2,0,32},
{58063,0,0,0},{64320,2,0,32},{58067,0,0,0},{64320,2,0,32},{58068,0,0,0},{64320,
2,0,32},{58108,0,0,0},{64320,2,0,32},{58110,0,0,0},{64320,2,0,32},{58173,0,0,0},
{64320,2,0,32},{58192,0,0,0},{64320,2,0,32},{58216,0,0,0},{64320,2,0,32},{58235,
0,0,0},{64320,2,0,32},{58243,0,0,0},{64320,2,0,32},{58272,0,0,0},{64320,2,0,32},
{58281,0,0,0},{64320,2,0,32},{58308,0,0,0},{64320,2,0,32},{58309,0,0,0},{64320,
2,0,32},{58340,0,0,0},{64320,2,0,32},{58396,0,0,0},{64320,2,0,32},{58402,0,0,0},
{64320,2,0,32},{58450,0,0,0},{64320,2,0,32},{58473,0,0,0},{64320,2,0,32},{58487,
0,0,0},{64320,2,0,32},{58494,0,0,0},{64320,2,0,32},{58522,0,0,0},{64320,2,0,32},
{58525,0,0,0},{64320,2,0,32},{58564,0,0,0},{64320,2,0,32},{58703,0,0,0},{64320,
2,0,32},{58710,0,0,0},{64320,2,0,32},{58732,0,0,0},{64320,2,0,32},{58744,0,0,0},
{64320,2,0,32},{58777,0,0,0},{64320,2,0,32},{58821,0,0,0},{64320,2,0,32},{58850,
0,0,0},{64320,2,0,32},{58851,0,0,0},{64320,2,0,32},{58899,0,0,0},{64320,2,0,32},
{58953,0,0,0},{64320,2,0,32},{58996,0,0,0},{64320,2,0,32},{59016,0,0,0},{64320,
2,0,32},{59025,0,0,0},{64320,2,0,32},{59036,0,0,0},{64320,2,0,32},{59060,0,0,0},
{64320,2,0,32},{59078,0,0,0},{64320,2,0,32},{59124,0,0,0},{64320,2,0,32},{59128,
0,0,0},{64320,2,0,32},{59136,0,0,0},{64320,2,0,32},{59159,0,0,0},{64320,2,0,32},
{59163,0,0,0},{64320,2,0,32},{59169,0,0,0},{64320,2,0,32},{59214,0,0,0},{64320,
2,0,32},{59219,0,0,0},{64320,2,0,32},{59222,0,0,0},{64320,2,0,32},{59230,0,0,0},
{64320,2,0,32},{59259,0,0,0},{64320,2,0,32},{59269,0,0,0},{64320,2,0,32},{59287,
0,0,0},{64320,2,0,32},{59379,0,0,0},{64320,2,0,32},{59386,0,0,0},{64320,2,0,32},
{59415,0,0,0},{64320,2,0,32},{59423,0,0,0},{64320,2,0,32},{59474,0,0,0},{64320,
2,0,32},{59521,0,0,0},{64320,2,0,32},{59525,0,0,0},{64320,2,0,32},{59534,0,0,0},
{64320,2,0,32},{59560,0,0,0},{64320,2,0,32},{59668,0,0,0},{64320,2,0,32},{59714,
0,0,0},{64320,2,0,32},{59811,0,0,0},{64320,2,0,32},{59882,0,0,0},{64320,2,0,32},
{59906,0,0,0},{64320,2,0,32},{59923,0,0,0},{64320,2,0,32},{60072,0,0,0},{64320,
2,0,32},{60115,0,0,0},{64320,2,0,32},{60123,0,0,0},{64320,2,0,32},{60164,0,0,0},
{64320,2,0,32},{60193,0,0,0},{64320,2,0,32},{60244,0,0,0},{64320,2,0,32},{60274,
0,0,0},{64320,2,0,32},{60279,0,0,0},{64320,2,0,32},{60281,0,0,0},{64320,2,0,32},
{60319,0,0,0},{64320,2,0,32},{60334,0,0,0},{64320,2,0,32},{60346,0,0,0},{64320,
2,0,32},{60347,0,0,0},{64320,2,0,32},{60494,0,0,0},{64320,2,0,32},{60519,0,0,0},
{64320,2,0,32},{60552,0,0,0},{64320,2,0,32},{60607,0,0,0},{64320,2,0,32},{60620,
0,0,0},{64320,2,0,32},{60621,0,0,0},{64320,2,0,32},{60645,0,0,0},{64320,2,0,32},
{60694,0,0,0},{64320,2,0,32},{60699,0,0,0},{64320,2,0,32},{60702,0,0,0},{64320,
2,0,32},{60724,0,0,0},{64320,2,0,32},{60734,0,0,0},{64320,2,0,32},{60737,0,0,0},
{64320,2,0,32},{60777,0,0,0},{64320,2,0,32},{60778,0,0,0},{64320,2,0,32},{60791,
0,0,0},{64320,2,0,32},{60792,0,0,0},{64320,2,0,32},{60805,0,0,0},{64320,2,0,32},
{60875,0,0,0},{64320,2,0,32},{60890,0,0,0},{64320,2,0,32},{60906,0,0,0},{64320,
2,0,32},{60921,0,0,0},{64320,2,0,32},{60954,0,0,0},{64320,2,0,32},{60975,0,0,0},
{64320,2,0,32},{61038,0,0,0},{64320,2,0,32},{61084,0,0,0},{64320,2,0,32},{61114,
0,0,0},{64320,2,0,32},{61127,0,0,0},{64320,2,0,32},{61131,0,0,0},{64320,2,0,32},
{61137,0,0,0},{64320,2,0,32},{61147,0,0,0},{64320,2,0,32},{61199,0,0,0},{64320,
2,0,32},{61218,0,0,0},{64320,2,0,32},{61219,0,0,0},{64320,2,0,32},{61294,0,0,0},
{64320,2,0,32},{61382,0,0,0},{64320,2,0,32},{61419,0,0,0},{64320,2,0,32},{61438,
0,0,0},{64320,2,0,32},{61467,0,0,0},{64320,2,0,32},{61470,0,0,0},{64320,2,0,32},
{61497,0,0,0},{64320,2,0,32},{61514,0,0,0},{64320,2,0,32},{61552,0,0,0},{64320,
2,0,32},{61559,0,0,0},{64320,2,0,32},{61565,0,0,0},{64320,2,0,32},{61593,0,0,0},
{64320,2,0,32},{61613,0,0,0},{64320,2,0,32},{61640,0,0,0},{64320,2,0,32},{61657,
0,0,0},{64320,2,0,32},{61765,0,0,0},{64320,2,0,32},{61769,0,0,0},{64320,2,0,32},
{61806,0,0,0},{64320,2,0,32},{61852,0,0,0},{64320,2,0,32},{61902,0,0,0},{64320,
2,0,32},{61904,0,0,0},{64320,2,0,32},{61968,0,0,0},{64320,2,0,32},{61979,0,0,0},
{64320,2,0,32},{61992,0,0,0},{64320,2,0,32},{61995,0,0,0},{64320,2,0,32},{62005,
0,0,0},{64320,2,0,32},{62032,0,0,0},{64320,2,0,32},{62050,0,0,0},{64320,2,0,32},
{62080,0,0,0},{64320,2,0,32},{62101,0,0,0},{64320,2,0,32},{62127,0,0,0},{64320,
2,0,32},{62144,0,0,0},{64320,2,0,32},{62204,0,0,0},{64320,2,0,32},{62250,0,0,0},
{64320,2,0,32},{62325,0,0,0},{64320,2,0,32},{62330,0,0,0},{64320,2,0,32},{62343,
0,0,0},{64320,2,0,32},{62347,0,0,0},{64320,2,0,32},{62373,0,0,0},{64320,2,0,32},
{62386,0,0,0},{64320,2,0,32},{62430,0,0,0},{64320,2,0,32},{62470,0,0,0},{64320,
2,0,32},{62473,0,0,0},{64320,2,0,32},{62498,0,0,0},{64320,2,0,32},{62535,0,0,0},
{64320,2,0,32},{62556,0,0,0},{64320,2,0,32},{62569,0,0,0},{64320,2,0,32},{62577,
0,0,0},{64320,2,0,32},{62597,0,0,0},{64320,2,0,32},{62601,0,0,0},{64320,2,0,32},
{62616,0,0,0},{64320,2,0,32},{62666,0,0,0},{64320,2,0,32},{62726,0,0,0},{64320,
2,0,32},{62756,0,0,0},{64320,2,0,32},{62779,0,0,0},{64320,2,0,32},{62782,0,0,0},
{64320,2,0,32},{62809,0,0,0},{64320,2,0,32},{62821,0,0,0},{64320,2,0,32},{62832,
0,0,0},{64320,2,0,32},{62946,0,0,0},{64320,2,0,32},{62992,0,0,0},{64320,2,0,32},
{63005,0,0,0},{64320,2,0,32},{63007,0,0,0},{64320,2,0,32},{63042,0,0,0},{64320,
2,0,32},{63081,0,0,0},{64320,2,0,32},{63178,0,0,0},{64320,2,0,32},{63195,0,0,0},
{64320,2,0,32},{63207,0,0,0},{64320,2,0,32},{63220,0,0,0},{64320,2,0,32},{63233,
0,0,0},{64320,2,0,32},{63262,0,0,0},{64320,2,0,32},{63263,0,0,0},{64320,2,0,32},
{63296,0,0,0},{64320,2,0,32},{63306,0,0,0},{64320,2,0,32},{63371,0,0,0},{64320,
2,0,32},{63399,0,0,0},{64320,2,0,32},{63566,0,0,0},{64320,2,0,32},{63595,0,0,0},
{64320,2,0,32},{63628,0,0,0},{64320,2,0,32},{63633,0,0,0},{64320,2,0,32},{63690,
0,0,0},{64320,2,0,32},{63692,0,0,0},{64320,2,0,32},{63739,0,0,0},{64320,2,0,32},
{63786,0,0,0},{64320,2,0,32},{63804,0,0,0},{64320,2,0,32},{63806,0,0,0},{64320,
2,0,32},{63816,0,0,0},{64320,2,0,32},{63817,0,0,0},{64320,2,0,32},{63824,0,0,0},
{64320,2,0,32},{63830,0,0,0},{64320,2,0,32},{63837,0,0,0},{64320,2,0,32},{63838,
0,0,0},{64320,2,0,32},{63845,0,0,0},{64320,2,0,32},{63871,0,0,0},{64320,2,0,32},
{63885,0,0,0},{64320,2,0,32},{63886,0,0,0},{64320,2,0,32},{63887,0,0,0},{64320,
2,0,32},{63918,0,0,0},{64320,2,0,32},{63946,0,0,0},{64320,2,0,32},{63979,0,0,0},
{64320,2,0,32},{64028,0,0,0},{64320,2,0,32},{64064,0,0,0},{64320,2,0,32},{64074,
0,0,0},{64320,2,0,32},{64079,0,0,0},{64320,2,0,32},{64129,0,0,0},{64320,2,0,32},
{64177,0,0,0},{64320,2,0,32},{64203,0,0,0},{64320,2,0,32},{64238,0,0,0},{64320,
2,0,32},{64288,0,0,0},{64320,2,0,32},{64448,0,0,0},{64320,2,0,32},{64454,0,0,0},
{64320,2,0,32},{64457,0,0,0},{64320,2,0,32},{64574,0,0,0},{64320,2,0,32},{64608,
0,0,0},{64320,2,0,32},{64635,0,0,0},{64320,2,0,32},{64658,0,0,0},{64320,2,0,32},
{64702,0,0,0},{64320,2,0,32},{64722,0,0,0},{64320,2,0,32},{64726,0,0,0},{64320,
2,0,32},{64739,0,0,0},{64320,2,0,32},{64743,0,0,0},{64320,2,0,32},{64744,0,0,0},
{64320,2,0,32},{64768,0,0,0},{64320,2,0,32},{64784,0,0,0},{64320,2,0,32},{64802,
0,0,0},{64320,2,0,32},{64815,0,0,0},{64320,2,0,32},{64859,0,0,0},{64320,2,0,32},
{64867,0,0,0},{64320,2,0,32},{64928,0,0,0},{64320,2,0,32},{64958,0,0,0},{64320,
2,0,32},{64967,0,0,0},{64320,2,0,32},{65012,0,0,0},{64320,2,0,32},{65026,0,0,0},
{64320,2,0,32},{65033,0,0,0},{64320,2,0,32},{65079,0,0,0},{64320,2,0,32},{65089,
0,0,0},{64320,2,0,32},{65093,0,0,0},{64320,2,0,32},{65342,0,0,0},{64320,2,0,32},
{65394,0,0,0},{64320,2,0,32},{65401,0,0,0},{64320,2,0,32},{65402,0,0,0},{64320,
2,0,32},{65413,0,0,0},{64320,2,0,32},{65429,0,0,0},{64320,2,0,32},{65434,0,0,0},
{64320,2,0,32},{65469,0,0,0},{64320,2,0,32},{65530,0,0,0},{64321,2,0,32},{32769,
0,0,0},{64321,2,0,32},{32773,0,0,0},{64321,2,0,32},{32838,0,0,0},{64321,2,0,32},
{32864,0,0,0},{64321,2,0,32},{32879,0,0,0},{64321,2,0,32},{32880,0,0,0},{64321,
2,0,32},{32894,0,0,0},{64321,2,0,32},{32907,0,0,0},{64321,2,0,32},{32941,0,0,0},
{64321,2,0,32},{32946,0,0,0},{64321,2,0,32},{33027,0,0,0},{64321,2,0,32},{33086,
0,0,0},{64321,2,0,32},{33240,0,0,0},{64321,2,0,32},{33256,0,0,0},{64321,2,0,32},
{33261,0,0,0},{64321,2,0,32},{33281,0,0,0},{64321,2,0,32},{33284,0,0,0},{64321,
2,0,32},{33304,0,0,0},{64321,2,0,32},{33391,0,0,0},{64321,2,0,32},{33401,0,0,0},
{64321,2,0,32},{33419,0,0,0},{64321,2,0,32},{33425,0,0,0},{64321,2,0,32},{33437,
0,0,0},{64321,2,0,32},{33457,0,0,0},{64321,2,0,32},{33459,0,0,0},{64321,2,0,32},
{33469,0,0,0},{64321,2,0,32},{33509,0,0,0},{64321,2,0,32},{33510,0,0,0},{64321,
2,0,32},{33565,0,0,0},{64321,2,0,32},{33571,0,0,0},{64321,2,0,32},{33590,0,0,0},
{64321,2,0,32},{33618,0,0,0},{64321,2,0,32},{33619,0,0,0},{64321,2,0,32},{33635,
0,0,0},{64321,2,0,32},{33709,0,0,0},{64321,2,0,32},{33725,0,0,0},{64321,2,0,32},
{33737,0,0,0},{64321,2,0,32},{33738,0,0,0},{64321,2,0,32},{33740,0,0,0},{64321,
2,0,32},{33756,0,0,0},{64321,2,0,32},{33767,0,0,0},{64321,2,0,32},{33775,0,0,0},
{64321,2,0,32},{33777,0,0,0},{64321,2,0,32},{33853,0,0,0},{64321,2,0,32},{33865,
0,0,0},{64321,2,0,32},{33879,0,0,0},{64321,2,0,32},{34030,0,0,0},{64321,2,0,32},
{34033,0,0,0},{64321,2,0,32},{34035,0,0,0},{64321,2,0,32},{34044,0,0,0},{64321,
2,0,32},{34070,0,0,0},{64321,2,0,32},{34148,0,0,0},{64321,2,0,32},{34253,0,0,0},
{64321,2,0,32},{34298,0,0,0},{64321,2,0,32},{34310,0,0,0},{64321,2,0,32},{34322,
0,0,0},{64321,2,0,32},{34349,0,0,0},{64321,2,0,32},{34367,0,0,0},{64321,2,0,32},
{34384,0,0,0},{64321,2,0,32},{34396,0,0,0},{64321,2,0,32},{34407,0,0,0},{64321,
2,0,32},{34409,0,0,0},{64321,2,0,32},{34440,0,0,0},{64321,2,0,32},{34473,0,0,0},
{64321,2,0,32},{34530,0,0,0},{64321,2,0,32},{34574,0,0,0},{64321,2,0,32},{34600,
0,0,0},{64321,2,0,32},{34667,0,0,0},{64321,2,0,32},{34681,0,0,0},{64321,2,0,32},
{34694,0,0,0},{64321,2,0,32},{34746,0,0,0},{64321,2,0,32},{34785,0,0,0},{64321,
2,0,32},{34817,0,0,0},{64321,2,0,32},{34847,0,0,0},{64321,2,0,32},{34892,0,0,0},
{64321,2,0,32},{34912,0,0,0},{64321,2,0,32},{34915,0,0,0},{64321,2,0,32},{35010,
0,0,0},{64321,2,0,32},{35023,0,0,0},{64321,2,0,32},{35031,0,0,0},{64321,2,0,32},
{35038,0,0,0},{64321,2,0,32},{35041,0,0,0},{64321,2,0,32},{35064,0,0,0},{64321,
2,0,32},{35066,0,0,0},{64321,2,0,32},{35088,0,0,0},{64321,2,0,32},{35137,0,0,0},
{64321,2,0,32},{35172,0,0,0},{64321,2,0,32},{35206,0,0,0},{64321,2,0,32},{35211,
0,0,0},{64321,2,0,32},{35222,0,0,0},{64321,2,0,32},{35488,0,0,0},{64321,2,0,32},
{35498,0,0,0},{64321,2,0,32},{35519,0,0,0},{64321,2,0,32},{35531,0,0,0},{64321,
2,0,32},{35538,0,0,0},{64321,2,0,32},{35542,0,0,0},{64321,2,0,32},{35565,0,0,0},
{64321,2,0,32},{35576,0,0,0},{64321,2,0,32},{35582,0,0,0},{64321,2,0,32},{35585,
0,0,0},{64321,2,0,32},{35641,0,0,0},{64321,2,0,32},{35672,0,0,0},{64321,2,0,32},
{35712,0,0,0},{64321,2,0,32},{35722,0,0,0},{64321,2,0,32},{35912,0,0,0},{64321,
2,0,32},{35925,0,0,0},{64321,2,0,32},{36011,0,0,0},{64321,2,0,32},{36033,0,0,0},
{64321,2,0,32},{36034,0,0,0},{64321,2,0,32},{36040,0,0,0},{64321,2,0,32},{36051,
0,0,0},{64321,2,0,32},{36104,0,0,0},{64321,2,0,32},{36123,0,0,0},{64321,2,0,32},
{36215,0,0,0},{64321,2,0,32},{36284,0,0,0},{64321,2,0,32},{36299,0,0,0},{64321,
2,0,32},{36335,0,0,0},{64321,2,0,32},{36336,0,0,0},{64321,2,0,32},{36554,0,0,0},
{64321,2,0,32},{36564,0,0,0},{64321,2,0,32},{36646,0,0,0},{64321,2,0,32},{36650,
0,0,0},{64321,2,0,32},{36664,0,0,0},{64321,2,0,32},{36667,0,0,0},{64321,2,0,32},
{36706,0,0,0},{64321,2,0,32},{36766,0,0,0},{64321,2,0,32},{36784,0,0,0},{64321,
2,0,32},{36790,0,0,0},{64321,2,0,32},{36899,0,0,0},{64321,2,0,32},{36920,0,0,0},
{64321,2,0,32},{36978,0,0,0},{64321,2,0,32},{36988,0,0,0},{64321,2,0,32},{37007,
0,0,0},{64321,2,0,32},{37012,0,0,0},{64321,2,0,32},{37070,0,0,0},{64321,2,0,32},
{37086,0,0,0},{64321,2,0,32},{37105,0,0,0},{64321,2,0,32},{37117,0,0,0},{64321,
2,0,32},{37137,0,0,0},{64321,2,0,32},{37147,0,0,0},{64321,2,0,32},{37226,0,0,0},
{64321,2,0,32},{37273,0,0,0},{64321,2,0,32},{37300,0,0,0},{64321,2,0,32},{37324,
0,0,0},{64321,2,0,32},{37327,0,0,0},{64321,2,0,32},{37329,0,0,0},{64321,2,0,32},
{37428,0,0,0},{64321,2,0,32},{37432,0,0,0},{64321,2,0,32},{37494,0,0,0},{64321,
2,0,32},{37500,0,0,0},{64321,2,0,32},{37591,0,0,0},{64321,2,0,32},{37592,0,0,0},
{64321,2,0,32},{37636,0,0,0},{64321,2,0,32},{37706,0,0,0},{64321,2,0,32},{37881,
0,0,0},{64321,2,0,32},{37909,0,0,0},{64321,2,0,32},{38283,0,0,0},{64321,2,0,32},
{38317,0,0,0},{64321,2,0,32},{38327,0,0,0},{64321,2,0,32},{38446,0,0,0},{64321,
2,0,32},{38475,0,0,0},{64321,2,0,32},{38477,0,0,0},{64321,2,0,32},{38517,0,0,0},
{64321,2,0,32},{38520,0,0,0},{64321,2,0,32},{38524,0,0,0},{64321,2,0,32},{38534,
0,0,0},{64321,2,0,32},{38563,0,0,0},{64321,2,0,32},{38583,0,0,0},{64321,2,0,32},
{38584,0,0,0},{64321,2,0,32},{38595,0,0,0},{64321,2,0,32},{38626,0,0,0},{64321,
2,0,32},{38627,0,0,0},{64321,2,0,32},{38646,0,0,0},{64321,2,0,32},{38647,0,0,0},
{64321,2,0,32},{38691,0,0,0},{64321,2,0,32},{38706,0,0,0},{64321,2,0,32},{38728,
0,0,0},{64321,2,0,32},{38742,0,0,0},{64321,2,0,32},{38875,0,0,0},{64321,2,0,32},
{38880,0,0,0},{64321,2,0,32},{38911,0,0,0},{64321,2,0,32},{38923,0,0,0},{64321,
2,0,32},{38936,0,0,0},{64321,2,0,32},{38953,0,0,0},{64321,2,0,32},{38971,0,0,0},
{64321,2,0,32},{39006,0,0,0},{64321,2,0,32},{39138,0,0,0},{64321,2,0,32},{39151,
0,0,0},{64321,2,0,32},{39164,0,0,0},{64321,2,0,32},{39208,0,0,0},{64321,2,0,32},
{39209,0,0,0},{64321,2,0,32},{39335,0,0,0},{64321,2,0,32},{39362,0,0,0},{64321,
2,0,32},{39409,0,0,0},{64321,2,0,32},{39422,0,0,0},{64321,2,0,32},{39530,0,0,0},
{64321,2,0,32},{39698,0,0,0},{64321,2,0,32},{39791,0,0,0},{64321,2,0,32},{40000,
0,0,0},{64321,2,0,32},{40023,0,0,0},{64321,2,0,32},{40189,0,0,0},{64321,2,0,32},
{40295,0,0,0},{64321,2,0,32},{40372,0,0,0},{64321,2,0,32},{40442,0,0,0},{64321,
2,0,32},{40478,0,0,0},{64321,2,0,32},{40575,0,0,0},{64321,2,0,32},{40599,0,0,0},
{64321,2,0,32},{40607,0,0,0},{64321,2,0,32},{40635,0,0,0},{64321,2,0,32},{40654,
0,0,0},{64321,2,0,32},{40697,0,0,0},{64321,2,0,32},{40702,0,0,0},{64321,2,0,32},
{40709,0,0,0},{64321,2,0,32},{40719,0,0,0},{64321,2,0,32},{40726,0,0,0},{64321,
2,0,32},{40763,0,0,0},{64321,2,0,32},{40771,0,0,0},{64321,2,0,32},{40845,0,0,0},
{64321,2,0,32},{40846,0,0,0},{64321,2,0,32},{40860,0,0,0},{15557,4,0,32},{15812,
4,0,32},{15575,4,0,32},{15812,4,0,32},{15596,4,0,32},{15812,4,0,32},{15616,4,0,
32},{15813,4,0,32},{15627,4,0,32},{15812,4,0,32},{15633,4,0,32},{15813,4,0,32},
{15635,4,0,32},{15813,4,0,32},{15641,4,0,32},{15812,4,0,32},{15678,4,0,32},
{15812,4,0,32},{15725,4,0,32},{15812,4,0,32},{15748,4,0,32},{15812,4,0,32},
{15754,4,0,32},{15813,4,0,32},{15761,4,0,32},{15812,4,0,32},{9197,4,0,32},{0,4,
0,43},{8695,10,0,32},{8838,4,0,32},{8695,4,0,32},{8838,4,0,32},{8098,10,0,32},
{8098,10,0,32},{8098,4,0,32},{8098,4,0,32},{8098,10,0,32},{8508,10,0,32},{8098,
4,0,32},{8508,4,0,32},{8098,10,0,32},{8727,10,0,32},{8098,4,0,32},{8727,4,0,32},
{8098,10,0,32},{8775,10,0,32},{8098,4,0,32},{8775,4,0,32},{8098,10,0,32},{0,4,0,
280},{8775,10,0,32},{8098,4,0,32},{0,4,0,280},{8775,4,0,32},{8098,10,0,32},
{8816,10,0,32},{8098,4,0,32},{8816,4,0,32},{8508,10,0,32},{8508,10,0,32},{8508,
4,0,32},{8508,4,0,32},{8775,10,0,32},{8816,10,0,32},{8775,4,0,32},{8816,4,0,32},
{8171,10,0,32},{0,4,0,281},{8171,4,0,32},{0,4,0,281},{8258,10,0,32},{0,4,0,281},
{8258,4,0,32},{0,4,0,281},{8273,10,0,32},{0,4,0,281},{8595,10,0,32},{0,4,0,281},
{8595,4,0,32},{0,4,0,281},{8658,10,0,32},{0,4,0,281},{8658,4,0,32},{0,4,0,281},
{8695,10,0,32},{0,4,0,281},{8695,4,0,32},{0,4,0,281},{8098,10,0,32},{0,4,0,43},
{8098,4,0,32},{0,4,0,43},{8508,10,0,32},{0,4,0,43},{8508,4,0,32},{0,4,0,43},
{8727,10,0,32},{0,4,0,43},{8727,4,0,32},{0,4,0,43},{8273,10,0,32},{0,4,0,53},
{8273,4,0,32},{0,4,0,53},{8388,10,0,32},{0,4,0,53},{8388,4,0,32},{0,4,0,53},
{8472,10,0,32},{0,4,0,53},{8472,4,0,32},{0,4,0,53},{8595,10,0,32},{0,4,0,53},
{8595,4,0,32},{0,4,0,53},{8658,10,0,32},{0,4,0,53},{8658,4,0,32},{0,4,0,53},
{8309,20,0,32},{0,20,0,57},{8508,20,0,32},{0,20,0,280},{8199,20,0,32},{12950,2,
0,32},{13003,2,0,32},{12951,2,0,32},{13003,2,0,32},{12952,2,0,32},{13003,2,0,
32},{12953,2,0,32},{13003,2,0,32},{12954,2,0,32},{13003,2,0,32},{12955,2,0,32},
{13003,2,0,32},{12956,2,0,32},{13003,2,0,32},{12957,2,0,32},{13003,2,0,32},
{12958,2,0,32},{13003,2,0,32},{12959,2,0,32},{13003,2,0,32},{12960,2,0,32},
{13003,2,0,32},{12961,2,0,32},{13003,2,0,32},{12962,2,0,32},{13003,2,0,32},
{12963,2,0,32},{13003,2,0,32},{12964,2,0,32},{13003,2,0,32},{12965,2,0,32},
{13003,2,0,32},{12966,2,0,32},{13003,2,0,32},{12967,2,0,32},{13003,2,0,32},
{12968,2,0,32},{13003,2,0,32},{12969,2,0,32},{13003,2,0,32},{12970,2,0,32},
{13003,2,0,32},{12971,2,0,32},{13003,2,0,32},{12972,2,0,32},{13003,2,0,32},
{12973,2,0,32},{13003,2,0,32},{12974,2,0,32},{13003,2,0,32},{12975,2,0,32},
{13003,2,0,32},{12976,2,0,32},{13003,2,0,32},{12977,2,0,32},{13003,2,0,32},
{12978,2,0,32},{13003,2,0,32},{12979,2,0,32},{13003,2,0,32},{12980,2,0,32},
{13003,2,0,32},{12981,2,0,32},{13003,2,0,32},{12982,2,0,32},{13003,2,0,32},
{12983,2,0,32},{13003,2,0,32},{12984,2,0,32},{13003,2,0,32},{12985,2,0,32},
{13003,2,0,32},{12986,2,0,32},{13003,2,0,32},{12987,2,0,32},{13003,2,0,32},
{12988,2,0,32},{13003,2,0,32},{12989,2,0,32},{13003,2,0,32},{12990,2,0,32},
{13003,2,0,32},{12991,2,0,32},{13003,2,0,32},{12992,2,0,32},{13003,2,0,32},
{12993,2,0,32},{13003,2,0,32},{12994,2,0,32},{13003,2,0,32},{12995,2,0,32},
{13003,2,0,32},{12996,2,0,32},{13003,2,0,32},{12997,2,0,32},{13003,2,0,32},
{12950,2,0,32},{13004,2,0,32},{12951,2,0,32},{13004,2,0,32},{12952,2,0,32},
{13004,2,0,32},{12953,2,0,32},{13004,2,0,32},{12954,2,0,32},{13004,2,0,32},
{12955,2,0,32},{13004,2,0,32},{12956,2,0,32},{13004,2,0,32},{12957,2,0,32},
{13004,2,0,32},{12958,2,0,32},{13004,2,0,32},{12959,2,0,32},{13004,2,0,32},
{12960,2,0,32},{13004,2,0,32},{12961,2,0,32},{13004,2,0,32},{12962,2,0,32},
{13004,2,0,32},{12963,2,0,32},{13004,2,0,32},{12964,2,0,32},{13004,2,0,32},
{12965,2,0,32},{13004,2,0,32},{12966,2,0,32},{13004,2,0,32},{12967,2,0,32},
{13004,2,0,32},{12968,2,0,32},{13004,2,0,32},{12969,2,0,32},{13004,2,0,32},
{12970,2,0,32},{13004,2,0,32},{12971,2,0,32},{13004,2,0,32},{12972,2,0,32},
{13004,2,0,32},{12973,2,0,32},{13004,2,0,32},{12974,2,0,32},{13004,2,0,32},
{12975,2,0,32},{13004,2,0,32},{12976,2,0,32},{13004,2,0,32},{12977,2,0,32},
{13004,2,0,32},{12978,2,0,32},{13004,2,0,32},{12979,2,0,32},{13004,2,0,32},
{12980,2,0,32},{13004,2,0,32},{12981,2,0,32},{13004,2,0,32},{12982,2,0,32},
{13004,2,0,32},{12983,2,0,32},{13004,2,0,32},{12984,2,0,32},{13004,2,0,32},
{12985,2,0,32},{13004,2,0,32},{12986,2,0,32},{13004,2,0,32},{12987,2,0,32},
{13004,2,0,32},{12988,2,0,32},{13004,2,0,32},{12989,2,0,32},{13004,2,0,32},
{12990,2,0,32},{13004,2,0,32},{12991,2,0,32},{13004,2,0,32},{12992,2,0,32},
{13004,2,0,32},{12993,2,0,32},{13004,2,0,32},{12994,2,0,32},{13004,2,0,32},
{12995,2,0,32},{13004,2,0,32},{12996,2,0,32},{13004,2,0,32},{12997,2,0,32},
{13004,2,0,32},{12950,2,0,32},{13007,2,0,32},{12951,2,0,32},{13007,2,0,32},
{12952,2,0,32},{13007,2,0,32},{12953,2,0,32},{13007,2,0,32},{12954,2,0,32},
{13007,2,0,32},{12955,2,0,32},{13007,2,0,32},{12956,2,0,32},{13007,2,0,32},
{12957,2,0,32},{13007,2,0,32},{12958,2,0,32},{13007,2,0,32},{12959,2,0,32},
{13007,2,0,32},{12960,2,0,32},{13007,2,0,32},{12961,2,0,32},{13007,2,0,32},
{12962,2,0,32},{13007,2,0,32},{12963,2,0,32},{13007,2,0,32},{12964,2,0,32},
{13007,2,0,32},{12965,2,0,32},{13007,2,0,32},{12966,2,0,32},{13007,2,0,32},
{12967,2,0,32},{13007,2,0,32},{12968,2,0,32},{13007,2,0,32},{12969,2,0,32},
{13007,2,0,32},{12970,2,0,32},{13007,2,0,32},{12971,2,0,32},{13007,2,0,32},
{12972,2,0,32},{13007,2,0,32},{12973,2,0,32},{13007,2,0,32},{12974,2,0,32},
{13007,2,0,32},{12975,2,0,32},{13007,2,0,32},{12976,2,0,32},{13007,2,0,32},
{12977,2,0,32},{13007,2,0,32},{12978,2,0,32},{13007,2,0,32},{12979,2,0,32},
{13007,2,0,32},{12980,2,0,32},{13007,2,0,32},{12981,2,0,32},{13007,2,0,32},
{12982,2,0,32},{13007,2,0,32},{12983,2,0,32},{13007,2,0,32},{12984,2,0,32},
{13007,2,0,32},{12985,2,0,32},{13007,2,0,32},{12986,2,0,32},{13007,2,0,32},
{12987,2,0,32},{13007,2,0,32},{12988,2,0,32},{13007,2,0,32},{12989,2,0,32},
{13007,2,0,32},{12990,2,0,32},{13007,2,0,32},{12991,2,0,32},{13007,2,0,32},
{12992,2,0,32},{13007,2,0,32},{12993,2,0,32},{13007,2,0,32},{12994,2,0,32},
{13007,2,0,32},{12995,2,0,32},{13007,2,0,32},{12996,2,0,32},{13007,2,0,32},
{12997,2,0,32},{13007,2,0,32},{12950,2,0,32},{13009,2,0,32},{12951,2,0,32},
{13009,2,0,32},{12952,2,0,32},{13009,2,0,32},{12953,2,0,32},{13009,2,0,32},
{12954,2,0,32},{13009,2,0,32},{12955,2,0,32},{13009,2,0,32},{12956,2,0,32},
{13009,2,0,32},{12957,2,0,32},{13009,2,0,32},{12958,2,0,32},{13009,2,0,32},
{12959,2,0,32},{13009,2,0,32},{12960,2,0,32},{13009,2,0,32},{12961,2,0,32},
{13009,2,0,32},{12962,2,0,32},{13009,2,0,32},{12963,2,0,32},{13009,2,0,32},
{12964,2,0,32},{13009,2,0,32},{12965,2,0,32},{13009,2,0,32},{12966,2,0,32},
{13009,2,0,32},{12967,2,0,32},{13009,2,0,32},{12968,2,0,32},{13009,2,0,32},
{12969,2,0,32},{13009,2,0,32},{12970,2,0,32},{13009,2,0,32},{12971,2,0,32},
{13009,2,0,32},{12972,2,0,32},{13009,2,0,32},{12973,2,0,32},{13009,2,0,32},
{12974,2,0,32},{13009,2,0,32},{12975,2,0,32},{13009,2,0,32},{12976,2,0,32},
{13009,2,0,32},{12977,2,0,32},{13009,2,0,32},{12978,2,0,32},{13009,2,0,32},
{12979,2,0,32},{13009,2,0,32},{12980,2,0,32},{13009,2,0,32},{12981,2,0,32},
{13009,2,0,32},{12982,2,0,32},{13009,2,0,32},{12983,2,0,32},{13009,2,0,32},
{12984,2,0,32},{13009,2,0,32},{12985,2,0,32},{13009,2,0,32},{12986,2,0,32},
{13009,2,0,32},{12987,2,0,32},{13009,2,0,32},{12988,2,0,32},{13009,2,0,32},
{12989,2,0,32},{13009,2,0,32},{12990,2,0,32},{13009,2,0,32},{12991,2,0,32},
{13009,2,0,32},{12992,2,0,32},{13009,2,0,32},{12993,2,0,32},{13009,2,0,32},
{12994,2,0,32},{13009,2,0,32},{12995,2,0,32},{13009,2,0,32},{12996,2,0,32},
{13009,2,0,32},{12997,2,0,32},{13009,2,0,32},{12950,2,0,32},{13010,2,0,32},
{12951,2,0,32},{13010,2,0,32},{12952,2,0,32},{13010,2,0,32},{12953,2,0,32},
{13010,2,0,32},{12954,2,0,32},{13010,2,0,32},{12955,2,0,32},{13010,2,0,32},
{12956,2,0,32},{13010,2,0,32},{12957,2,0,32},{13010,2,0,32},{12958,2,0,32},
{13010,2,0,32},{12959,2,0,32},{13010,2,0,32},{12960,2,0,32},{13010,2,0,32},
{12961,2,0,32},{13010,2,0,32},{12962,2,0,32},{13010,2,0,32},{12963,2,0,32},
{13010,2,0,32},{12964,2,0,32},{13010,2,0,32},{12965,2,0,32},{13010,2,0,32},
{12966,2,0,32},{13010,2,0,32},{12967,2,0,32},{13010,2,0,32},{12968,2,0,32},
{13010,2,0,32},{12969,2,0,32},{13010,2,0,32},{12970,2,0,32},{13010,2,0,32},
{12971,2,0,32},{13010,2,0,32},{12972,2,0,32},{13010,2,0,32},{12973,2,0,32},
{13010,2,0,32},{12974,2,0,32},{13010,2,0,32},{12975,2,0,32},{13010,2,0,32},
{12976,2,0,32},{13010,2,0,32},{12977,2,0,32},{13010,2,0,32},{12978,2,0,32},
{13010,2,0,32},{12979,2,0,32},{13010,2,0,32},{12980,2,0,32},{13010,2,0,32},
{12981,2,0,32},{13010,2,0,32},{12982,2,0,32},{13010,2,0,32},{12983,2,0,32},
{13010,2,0,32},{12984,2,0,32},{13010,2,0,32},{12985,2,0,32},{13010,2,0,32},
{12986,2,0,32},{13010,2,0,32},{12987,2,0,32},{13010,2,0,32},{12988,2,0,32},
{13010,2,0,32},{12989,2,0,32},{13010,2,0,32},{12990,2,0,32},{13010,2,0,32},
{12991,2,0,32},{13010,2,0,32},{12992,2,0,32},{13010,2,0,32},{12993,2,0,32},
{13010,2,0,32},{12994,2,0,32},{13010,2,0,32},{12995,2,0,32},{13010,2,0,32},
{12996,2,0,32},{13010,2,0,32},{12997,2,0,32},{13010,2,0,32},{8171,4,0,32},{8853,
4,0,32},{8695,4,0,32},{8666,4,0,32},{64321,2,0,32},{64014,0,0,0},{64321,2,0,32},
{64015,0,0,0},{64321,2,0,32},{64017,0,0,0},{64321,2,0,32},{64019,0,0,0},{64321,
2,0,32},{64020,0,0,0},{64321,2,0,32},{64031,0,0,0},{64321,2,0,32},{64033,0,0,0},
{64321,2,0,32},{64035,0,0,0},{64321,2,0,32},{64036,0,0,0},{64321,2,0,32},{64039,
0,0,0},{64321,2,0,32},{64040,0,0,0},{64321,2,0,32},{64041,0,0,0},{8258,4,0,32},
{8258,4,0,32},{8258,4,0,32},{8336,4,0,32},{8258,4,0,32},{8406,4,0,32},{8258,4,0,
32},{8258,4,0,32},{8336,4,0,32},{8258,4,0,32},{8258,4,0,32},{8406,4,0,32},{8658,
4,0,32},{0,4,0,281},{8695,4,0,32},{8658,4,0,32},{8695,4,0,32},{9737,4,0,32},
{9740,4,0,32},{9737,4,0,32},{9722,4,0,32},{9737,4,0,32},{9728,4,0,32},{9748,4,0,
32},{9740,4,0,32},{9737,4,0,32},{9730,4,0,32},{9758,4,0,32},{9769,4,0,32},
{10023,26,0,32},{0,26,0,131},{10023,25,0,32},{0,25,0,131},{10053,26,0,32},{0,26,
0,131},{10053,25,0,32},{0,25,0,131},{10028,26,0,32},{9828,26,0,32},{9838,26,0,
32},{9842,26,0,32},{9838,25,0,32},{9842,25,0,32},{9838,26,0,32},{10023,26,0,32},
{9838,25,0,32},{10023,25,0,32},{9838,26,0,32},{10024,26,0,32},{9838,25,0,32},
{10024,25,0,32},{9838,26,0,32},{10028,26,0,32},{9838,25,0,32},{10028,25,0,32},
{9838,26,0,32},{10027,26,0,32},{9838,25,0,32},{10027,25,0,32},{9838,26,0,32},
{10029,26,0,32},{9838,25,0,32},{10029,25,0,32},{9838,26,0,32},{10043,26,0,32},
{9838,25,0,32},{10043,25,0,32},{9838,23,0,32},{10043,23,0,32},{9838,26,0,32},
{10038,26,0,32},{9838,25,0,32},{10038,25,0,32},{9838,23,0,32},{10038,23,0,32},
{9838,26,0,32},{9871,26,0,32},{9838,26,0,32},{9881,26,0,32},{9838,26,0,32},
{10004,26,0,32},{9838,26,0,32},{10038,26,0,32},{9838,26,0,32},{10039,26,0,32},
{9844,26,0,32},{9871,26,0,32},{9844,26,0,32},{9881,26,0,32},{9844,26,0,32},
{9882,26,0,32},{9844,26,0,32},{10004,26,0,32},{9844,26,0,32},{10038,26,0,32},
{9844,26,0,32},{10039,26,0,32},{9861,26,0,32},{9871,26,0,32},{9861,26,0,32},
{9881,26,0,32},{9861,26,0,32},{9882,26,0,32},{9861,26,0,32},{10004,26,0,32},
{9861,26,0,32},{10038,26,0,32},{9861,26,0,32},{10039,26,0,32},{9862,26,0,32},
{9871,26,0,32},{9862,26,0,32},{10004,26,0,32},{9862,26,0,32},{10038,26,0,32},
{9862,26,0,32},{10039,26,0,32},{9871,26,0,32},{9881,26,0,32},{9871,26,0,32},
{10004,26,0,32},{9881,26,0,32},{9871,26,0,32},{9881,26,0,32},{10004,26,0,32},
{9882,26,0,32},{9871,26,0,32},{9882,26,0,32},{9881,26,0,32},{9882,26,0,32},
{10004,26,0,32},{9926,26,0,32},{9871,26,0,32},{9926,26,0,32},{9881,26,0,32},
{9926,26,0,32},{9882,26,0,32},{9926,26,0,32},{10004,26,0,32},{9937,26,0,32},
{9881,26,0,32},{9937,26,0,32},{10004,26,0,32},{9938,26,0,32},{9871,26,0,32},
{9938,26,0,32},{9881,26,0,32},{9938,26,0,32},{9882,26,0,32},{9938,26,0,32},
{10004,26,0,32},{9943,26,0,32},{9881,26,0,32},{9943,26,0,32},{10004,26,0,32},
{9944,26,0,32},{10004,26,0,32},{9947,26,0,32},{9871,26,0,32},{9947,26,0,32},
{10004,26,0,32},{9948,26,0,32},{9871,26,0,32},{9948,26,0,32},{10004,26,0,32},
{9956,26,0,32},{9871,26,0,32},{9956,26,0,32},{9881,26,0,32},{9956,26,0,32},
{9882,26,0,32},{9956,26,0,32},{10004,26,0,32},{9956,26,0,32},{10038,26,0,32},
{9956,26,0,32},{10039,26,0,32},{9968,26,0,32},{9881,26,0,32},{9968,26,0,32},
{10004,26,0,32},{9968,26,0,32},{10038,26,0,32},{9968,26,0,32},{10039,26,0,32},
{9974,26,0,32},{9842,26,0,32},{9974,26,0,32},{9871,26,0,32},{9974,26,0,32},
{9881,26,0,32},{9974,26,0,32},{9882,26,0,32},{9974,26,0,32},{9996,26,0,32},
{9974,26,0,32},{10004,26,0,32},{9974,26,0,32},{10038,26,0,32},{9974,26,0,32},
{10039,26,0,32},{9996,26,0,32},{9871,26,0,32},{9996,26,0,32},{9881,26,0,32},
{9996,26,0,32},{9882,26,0,32},{9996,26,0,32},{10004,26,0,32},{9996,26,0,32},
{10038,26,0,32},{9996,26,0,32},{10039,26,0,32},{10004,26,0,32},{9871,26,0,32},
{10004,26,0,32},{9881,26,0,32},{10004,26,0,32},{9882,26,0,32},{10004,26,0,32},
{10004,26,0,32},{10004,26,0,32},{10038,26,0,32},{10004,26,0,32},{10039,26,0,32},
{10008,26,0,32},{9871,26,0,32},{10008,26,0,32},{9881,26,0,32},{10008,26,0,32},
{9882,26,0,32},{10008,26,0,32},{10004,26,0,32},{10008,26,0,32},{10038,26,0,32},
{10008,26,0,32},{10039,26,0,32},{10018,26,0,32},{9871,26,0,32},{10018,26,0,32},
{10004,26,0,32},{10018,26,0,32},{10038,26,0,32},{10018,26,0,32},{10039,26,0,32},
{10039,26,0,32},{9871,26,0,32},{10039,26,0,32},{9881,26,0,32},{10039,26,0,32},
{9882,26,0,32},{10039,26,0,32},{10004,26,0,32},{10039,26,0,32},{10038,26,0,32},
{10039,26,0,32},{10039,26,0,32},{9893,26,0,32},{0,26,0,152},{9907,26,0,32},{0,
26,0,152},{10038,26,0,32},{0,26,0,152},{0,26,0,112},{0,26,0,128},{0,26,0,115},
{0,26,0,128},{0,26,0,118},{0,26,0,128},{0,26,0,122},{0,26,0,128},{0,26,0,125},
{0,26,0,128},{0,26,0,128},{0,26,0,152},{9838,25,0,32},{9907,25,0,32},{9838,25,0,
32},{9908,25,0,32},{9838,25,0,32},{10004,25,0,32},{9838,25,0,32},{10008,25,0,
32},{9838,25,0,32},{10038,25,0,32},{9838,25,0,32},{10039,25,0,32},{9844,25,0,
32},{9907,25,0,32},{9844,25,0,32},{9908,25,0,32},{9844,25,0,32},{10004,25,0,32},
{9844,25,0,32},{10008,25,0,32},{9844,25,0,32},{10038,25,0,32},{9844,25,0,32},
{10039,25,0,32},{9861,25,0,32},{9907,25,0,32},{9861,25,0,32},{9908,25,0,32},
{9861,25,0,32},{10004,25,0,32},{9861,25,0,32},{10008,25,0,32},{9861,25,0,32},
{10038,25,0,32},{9861,25,0,32},{10039,25,0,32},{9862,25,0,32},{9907,25,0,32},
{9862,25,0,32},{9908,25,0,32},{9862,25,0,32},{10004,25,0,32},{9862,25,0,32},
{10008,25,0,32},{9862,25,0,32},{10038,25,0,32},{9862,25,0,32},{10039,25,0,32},
{9956,25,0,32},{10038,25,0,32},{9956,25,0,32},{10039,25,0,32},{9968,25,0,32},
{10038,25,0,32},{9968,25,0,32},{10039,25,0,32},{9974,25,0,32},{9842,25,0,32},
{9974,25,0,32},{9996,25,0,32},{9974,25,0,32},{10004,25,0,32},{9974,25,0,32},
{10038,25,0,32},{9974,25,0,32},{10039,25,0,32},{9996,25,0,32},{10004,25,0,32},
{9996,25,0,32},{10038,25,0,32},{9996,25,0,32},{10039,25,0,32},{10004,25,0,32},
{9842,25,0,32},{10004,25,0,32},{10004,25,0,32},{10008,25,0,32},{9907,25,0,32},
{10008,25,0,32},{9908,25,0,32},{10008,25,0,32},{10004,25,0,32},{10008,25,0,32},
{10008,25,0,32},{10008,25,0,32},{10038,25,0,32},{10008,25,0,32},{10039,25,0,32},
{10038,25,0,32},{0,25,0,152},{10039,25,0,32},{9907,25,0,32},{10039,25,0,32},
{9908,25,0,32},{10039,25,0,32},{10004,25,0,32},{10039,25,0,32},{10008,25,0,32},
{10039,25,0,32},{10038,25,0,32},{10039,25,0,32},{10039,25,0,32},{9838,23,0,32},
{9871,23,0,32},{9838,23,0,32},{9881,23,0,32},{9838,23,0,32},{9882,23,0,32},
{9838,23,0,32},{10004,23,0,32},{9838,23,0,32},{10018,23,0,32},{9844,23,0,32},
{9871,23,0,32},{9844,23,0,32},{9881,23,0,32},{9844,23,0,32},{9882,23,0,32},
{9844,23,0,32},{10004,23,0,32},{9844,23,0,32},{10018,23,0,32},{9861,23,0,32},
{9871,23,0,32},{9861,23,0,32},{9881,23,0,32},{9861,23,0,32},{9882,23,0,32},
{9861,23,0,32},{10004,23,0,32},{9861,23,0,32},{10018,23,0,32},{9862,23,0,32},
{10004,23,0,32},{9871,23,0,32},{9881,23,0,32},{9871,23,0,32},{10004,23,0,32},
{9881,23,0,32},{9871,23,0,32},{9881,23,0,32},{10004,23,0,32},{9882,23,0,32},
{9871,23,0,32},{9882,23,0,32},{10004,23,0,32},{9926,23,0,32},{9871,23,0,32},
{9926,23,0,32},{9881,23,0,32},{9926,23,0,32},{9882,23,0,32},{9926,23,0,32},
{10004,23,0,32},{9937,23,0,32},{9881,23,0,32},{9937,23,0,32},{9882,23,0,32},
{9937,23,0,32},{10004,23,0,32},{9938,23,0,32},{9871,23,0,32},{9938,23,0,32},
{9881,23,0,32},{9938,23,0,32},{9882,23,0,32},{9938,23,0,32},{10004,23,0,32},
{9943,23,0,32},{9881,23,0,32},{9944,23,0,32},{10004,23,0,32},{9947,23,0,32},
{9871,23,0,32},{9947,23,0,32},{10004,23,0,32},{9948,23,0,32},{9871,23,0,32},
{9948,23,0,32},{10004,23,0,32},{9956,23,0,32},{9871,23,0,32},{9956,23,0,32},
{9881,23,0,32},{9956,23,0,32},{9882,23,0,32},{9956,23,0,32},{10004,23,0,32},
{9968,23,0,32},{9881,23,0,32},{9968,23,0,32},{10004,23,0,32},{9974,23,0,32},
{9871,23,0,32},{9974,23,0,32},{9881,23,0,32},{9974,23,0,32},{9882,23,0,32},
{9974,23,0,32},{9996,23,0,32},{9974,23,0,32},{10004,23,0,32},{9996,23,0,32},
{9871,23,0,32},{9996,23,0,32},{9881,23,0,32},{9996,23,0,32},{9882,23,0,32},
{9996,23,0,32},{10004,23,0,32},{9996,23,0,32},{10018,23,0,32},{10004,23,0,32},
{9871,23,0,32},{10004,23,0,32},{9881,23,0,32},{10004,23,0,32},{9882,23,0,32},
{10004,23,0,32},{10004,23,0,32},{10008,23,0,32},{9871,23,0,32},{10008,23,0,32},
{9881,23,0,32},{10008,23,0,32},{9882,23,0,32},{10008,23,0,32},{10004,23,0,32},
{10008,23,0,32},{10018,23,0,32},{10018,23,0,32},{9871,23,0,32},{10018,23,0,32},
{10004,23,0,32},{10018,23,0,32},{0,23,0,152},{10039,23,0,32},{9871,23,0,32},
{10039,23,0,32},{9881,23,0,32},{10039,23,0,32},{9882,23,0,32},{10039,23,0,32},
{10004,23,0,32},{10039,23,0,32},{10018,23,0,32},{9838,24,0,32},{10004,24,0,32},
{9838,24,0,32},{10018,24,0,32},{9844,24,0,32},{10004,24,0,32},{9844,24,0,32},
{10018,24,0,32},{9861,24,0,32},{10004,24,0,32},{9861,24,0,32},{10018,24,0,32},
{9862,24,0,32},{10004,24,0,32},{9862,24,0,32},{10018,24,0,32},{9926,24,0,32},
{10004,24,0,32},{9926,24,0,32},{10018,24,0,32},{9927,24,0,32},{10004,24,0,32},
{9927,24,0,32},{10018,24,0,32},{9974,24,0,32},{9996,24,0,32},{9974,24,0,32},
{10004,24,0,32},{9996,24,0,32},{10004,24,0,32},{10008,24,0,32},{10004,24,0,32},
{10008,24,0,32},{10018,24,0,32},{10039,24,0,32},{10004,24,0,32},{10039,24,0,32},
{10018,24,0,32},{0,24,0,118},{0,24,0,128},{0,24,0,122},{0,24,0,128},{0,24,0,
125},{0,24,0,128},{9943,26,0,32},{10038,26,0,32},{9943,26,0,32},{10039,26,0,32},
{9947,26,0,32},{10038,26,0,32},{9947,26,0,32},{10039,26,0,32},{9948,26,0,32},
{10038,26,0,32},{9948,26,0,32},{10039,26,0,32},{9926,26,0,32},{10038,26,0,32},
{9926,26,0,32},{10039,26,0,32},{9927,26,0,32},{10038,26,0,32},{9927,26,0,32},
{10039,26,0,32},{9881,26,0,32},{10038,26,0,32},{9881,26,0,32},{10039,26,0,32},
{9871,26,0,32},{10038,26,0,32},{9871,26,0,32},{10039,26,0,32},{9882,26,0,32},
{10038,26,0,32},{9882,26,0,32},{10039,26,0,32},{9937,26,0,32},{10038,26,0,32},
{9937,26,0,32},{10039,26,0,32},{9938,26,0,32},{10038,26,0,32},{9938,26,0,32},
{10039,26,0,32},{9927,26,0,32},{9871,26,0,32},{9927,26,0,32},{9881,26,0,32},
{9927,26,0,32},{9882,26,0,32},{9927,26,0,32},{10004,26,0,32},{9927,26,0,32},
{9907,26,0,32},{9926,26,0,32},{9907,26,0,32},{9937,26,0,32},{9907,26,0,32},
{9938,26,0,32},{9907,26,0,32},{9943,25,0,32},{10038,25,0,32},{9943,25,0,32},
{10039,25,0,32},{9947,25,0,32},{10038,25,0,32},{9947,25,0,32},{10039,25,0,32},
{9948,25,0,32},{10038,25,0,32},{9948,25,0,32},{10039,25,0,32},{9926,25,0,32},
{10038,25,0,32},{9926,25,0,32},{10039,25,0,32},{9927,25,0,32},{10038,25,0,32},
{9927,25,0,32},{10039,25,0,32},{9881,25,0,32},{10038,25,0,32},{9881,25,0,32},
{10039,25,0,32},{9871,25,0,32},{10038,25,0,32},{9871,25,0,32},{10039,25,0,32},
{9882,25,0,32},{10038,25,0,32},{9882,25,0,32},{10039,25,0,32},{9937,25,0,32},
{10038,25,0,32},{9937,25,0,32},{10039,25,0,32},{9938,25,0,32},{10038,25,0,32},
{9938,25,0,32},{10039,25,0,32},{9927,25,0,32},{9871,25,0,32},{9927,25,0,32},
{9881,25,0,32},{9927,25,0,32},{9882,25,0,32},{9927,25,0,32},{10004,25,0,32},
{9927,25,0,32},{9907,25,0,32},{9926,25,0,32},{9907,25,0,32},{9937,25,0,32},
{9907,25,0,32},{9938,25,0,32},{9907,25,0,32},{9927,23,0,32},{9871,23,0,32},
{9927,23,0,32},{9881,23,0,32},{9927,23,0,32},{9882,23,0,32},{9927,23,0,32},
{10004,23,0,32},{9926,23,0,32},{10018,23,0,32},{9927,23,0,32},{10018,23,0,32},
{9943,23,0,32},{10004,23,0,32},{9926,24,0,32},{9871,24,0,32},{9926,24,0,32},
{9881,24,0,32},{9926,24,0,32},{9882,24,0,32},{9927,24,0,32},{9871,24,0,32},
{9927,24,0,32},{9881,24,0,32},{9927,24,0,32},{9882,24,0,32},{9943,24,0,32},
{10004,24,0,32},{9944,24,0,32},{10004,24,0,32},{9842,25,0,32},{0,25,0,109},
{9842,26,0,32},{0,26,0,109},{9861,23,0,32},{9871,23,0,32},{10004,23,0,32},{9861,
25,0,32},{9881,25,0,32},{9871,25,0,32},{9861,23,0,32},{9881,23,0,32},{9871,23,0,
32},{9861,23,0,32},{9881,23,0,32},{10004,23,0,32},{9861,23,0,32},{9882,23,0,32},
{10004,23,0,32},{9861,23,0,32},{10004,23,0,32},{9871,23,0,32},{9861,23,0,32},
{10004,23,0,32},{9881,23,0,32},{9861,23,0,32},{10004,23,0,32},{9882,23,0,32},
{9871,25,0,32},{10004,25,0,32},{9881,25,0,32},{9871,23,0,32},{10004,23,0,32},
{9881,23,0,32},{9881,25,0,32},{10004,25,0,32},{10039,25,0,32},{9881,25,0,32},
{10004,25,0,32},{10038,25,0,32},{9926,23,0,32},{9881,23,0,32},{9871,23,0,32},
{9926,23,0,32},{9871,23,0,32},{9881,23,0,32},{9926,25,0,32},{9871,25,0,32},
{10038,25,0,32},{9926,25,0,32},{10004,25,0,32},{9881,25,0,32},{9926,23,0,32},
{10004,23,0,32},{9881,23,0,32},{9926,23,0,32},{10004,23,0,32},{9871,23,0,32},
{9926,25,0,32},{10004,25,0,32},{10004,25,0,32},{9926,23,0,32},{10004,23,0,32},
{10004,23,0,32},{9937,25,0,32},{9881,25,0,32},{9881,25,0,32},{9937,23,0,32},
{9881,23,0,32},{9881,23,0,32},{9937,25,0,32},{10004,25,0,32},{10004,25,0,32},
{9927,25,0,32},{9881,25,0,32},{10004,25,0,32},{9927,23,0,32},{9881,23,0,32},
{10004,23,0,32},{9927,25,0,32},{9871,25,0,32},{10039,25,0,32},{9927,25,0,32},
{10004,25,0,32},{9882,25,0,32},{9927,23,0,32},{10004,23,0,32},{9882,23,0,32},
{9927,25,0,32},{10004,25,0,32},{10004,25,0,32},{9927,23,0,32},{10004,23,0,32},
{10004,23,0,32},{9938,25,0,32},{9881,25,0,32},{10038,25,0,32},{9938,25,0,32},
{9882,25,0,32},{10004,25,0,32},{9938,23,0,32},{9882,23,0,32},{10004,23,0,32},
{9943,25,0,32},{10004,25,0,32},{9881,25,0,32},{9943,23,0,32},{10004,23,0,32},
{9881,23,0,32},{9943,23,0,32},{10004,23,0,32},{10004,23,0,32},{9943,25,0,32},
{10004,25,0,32},{10039,25,0,32},{9947,25,0,32},{9871,25,0,32},{10004,25,0,32},
{9947,25,0,32},{10004,25,0,32},{10004,25,0,32},{9947,23,0,32},{10004,23,0,32},
{10004,23,0,32},{9947,25,0,32},{10004,25,0,32},{10038,25,0,32},{9948,25,0,32},
{10004,25,0,32},{10004,25,0,32},{9948,25,0,32},{10004,25,0,32},{10039,25,0,32},
{9948,25,0,32},{10004,25,0,32},{10038,25,0,32},{9956,25,0,32},{9882,25,0,32},
{10004,25,0,32},{9956,23,0,32},{9882,23,0,32},{10004,23,0,32},{9968,25,0,32},
{10004,25,0,32},{9881,25,0,32},{9968,25,0,32},{10004,25,0,32},{10004,25,0,32},
{9996,25,0,32},{9881,25,0,32},{10004,25,0,32},{9996,25,0,32},{9881,25,0,32},
{10039,25,0,32},{9996,25,0,32},{9881,25,0,32},{10038,25,0,32},{9996,23,0,32},
{9871,23,0,32},{9871,23,0,32},{9996,25,0,32},{9871,25,0,32},{9871,25,0,32},
{9996,25,0,32},{9882,25,0,32},{10004,25,0,32},{9996,23,0,32},{9882,23,0,32},
{10004,23,0,32},{9996,25,0,32},{10004,25,0,32},{9881,25,0,32},{9996,23,0,32},
{10004,23,0,32},{9881,23,0,32},{10004,23,0,32},{9881,23,0,32},{9871,23,0,32},
{10004,23,0,32},{9881,23,0,32},{10004,23,0,32},{10004,25,0,32},{9881,25,0,32},
{10039,25,0,32},{10004,23,0,32},{9871,23,0,32},{9881,23,0,32},{10004,23,0,32},
{9871,23,0,32},{10004,23,0,32},{10004,23,0,32},{9882,23,0,32},{9871,23,0,32},
{10004,23,0,32},{9882,23,0,32},{10004,23,0,32},{10004,23,0,32},{9871,23,0,32},
{9882,23,0,32},{10018,23,0,32},{10004,23,0,32},{9871,23,0,32},{10018,23,0,32},
{10004,23,0,32},{10004,23,0,32},{10008,23,0,32},{9881,23,0,32},{10004,23,0,32},
{10008,25,0,32},{9881,25,0,32},{10038,25,0,32},{10008,25,0,32},{9871,25,0,32},
{10004,25,0,32},{10008,23,0,32},{9871,23,0,32},{10004,23,0,32},{10008,25,0,32},
{9871,25,0,32},{10038,25,0,32},{10008,25,0,32},{10004,25,0,32},{10039,25,0,32},
{10008,25,0,32},{10004,25,0,32},{10038,25,0,32},{10039,25,0,32},{10004,25,0,32},
{10004,25,0,32},{10039,23,0,32},{10004,23,0,32},{10004,23,0,32},{9844,25,0,32},
{9882,25,0,32},{10039,25,0,32},{9861,25,0,32},{9871,25,0,32},{10039,25,0,32},
{9861,25,0,32},{9871,25,0,32},{10038,25,0,32},{9861,25,0,32},{9882,25,0,32},
{10039,25,0,32},{9861,25,0,32},{9882,25,0,32},{10038,25,0,32},{9861,25,0,32},
{10004,25,0,32},{10039,25,0,32},{9861,25,0,32},{10004,25,0,32},{10038,25,0,32},
{9871,25,0,32},{10004,25,0,32},{10039,25,0,32},{9871,25,0,32},{9881,25,0,32},
{10038,25,0,32},{9871,25,0,32},{10004,25,0,32},{10038,25,0,32},{9926,25,0,32},
{9882,25,0,32},{10038,25,0,32},{9937,25,0,32},{9881,25,0,32},{10039,25,0,32},
{9927,25,0,32},{9881,25,0,32},{10039,25,0,32},{9938,25,0,32},{9881,25,0,32},
{10039,25,0,32},{9996,25,0,32},{9871,25,0,32},{10039,25,0,32},{9996,25,0,32},
{10004,25,0,32},{10039,25,0,32},{10039,25,0,32},{9881,25,0,32},{10039,25,0,32},
{10039,25,0,32},{9871,25,0,32},{10039,25,0,32},{10039,25,0,32},{10004,25,0,32},
{10039,25,0,32},{10004,25,0,32},{10004,25,0,32},{10039,25,0,32},{9968,25,0,32},
{10004,25,0,32},{10039,25,0,32},{10008,25,0,32},{9881,25,0,32},{10039,25,0,32},
{9968,23,0,32},{10004,23,0,32},{9881,23,0,32},{9996,23,0,32},{9881,23,0,32},
{10004,23,0,32},{9947,25,0,32},{10004,25,0,32},{10039,25,0,32},{9974,25,0,32},
{10004,25,0,32},{10039,25,0,32},{10008,23,0,32},{9871,23,0,32},{9881,23,0,32},
{10004,25,0,32},{9882,25,0,32},{10039,25,0,32},{9996,23,0,32},{9871,23,0,32},
{10004,23,0,32},{9974,25,0,32},{10004,25,0,32},{10004,25,0,32},{9996,25,0,32},
{9871,25,0,32},{10004,25,0,32},{10008,25,0,32},{9871,25,0,32},{9881,25,0,32},
{9871,25,0,32},{9881,25,0,32},{10039,25,0,32},{9881,25,0,32},{9871,25,0,32},
{10039,25,0,32},{10004,25,0,32},{9871,25,0,32},{10039,25,0,32},{9956,25,0,32},
{10004,25,0,32},{10039,25,0,32},{9844,25,0,32},{9881,25,0,32},{10039,25,0,32},
{9974,23,0,32},{10004,23,0,32},{10004,23,0,32},{9947,23,0,32},{9871,23,0,32},
{10004,23,0,32},{9937,23,0,32},{10004,23,0,32},{10004,23,0,32},{9926,25,0,32},
{9882,25,0,32},{10039,25,0,32},{10008,25,0,32},{9871,25,0,32},{10039,25,0,32},
{9937,26,0,32},{9996,26,0,32},{10053,26,0,32},{9968,26,0,32},{9996,26,0,32},
{10053,26,0,32},{9842,26,0,32},{9996,26,0,32},{9996,26,0,32},{10018,26,0,32},
{9842,26,0,32},{9974,26,0,32},{9844,26,0,32},{9907,26,0,32},{10004,26,0,32},
{9881,26,0,32},{10004,26,0,32},{9892,26,0,32},{9937,26,0,32},{9996,26,0,32},
{9947,26,0,32},{10004,26,0,32},{9907,26,0,32},{9926,26,0,32},{10024,26,0,32},
{9996,26,0,32},{9947,26,0,32},{9996,26,0,32},{10039,26,0,32},{10018,26,0,32},
{10024,26,0,32},{9926,26,0,32},{9996,26,0,32},{10004,26,0,32},{9937,26,0,32},
{9996,26,0,32},{10038,26,0,32},{9937,26,0,32},{9996,26,0,32},{10038,26,0,32},
{521,26,1,32},{9842,26,0,32},{9996,26,0,32},{9996,26,0,32},{10018,26,0,32},{521,
26,1,32},{9947,26,0,32},{9996,26,0,32},{10039,26,0,32},{10018,26,0,32},{521,26,
1,32},{10024,26,0,32},{9926,26,0,32},{9996,26,0,32},{10004,26,0,32},{9871,26,0,
32},{9996,26,0,32},{521,26,1,32},{9871,26,0,32},{9996,26,0,32},{9842,26,0,32},
{9996,26,0,32},{10018,26,0,32},{9907,26,0,32},{10040,26,0,32},{9842,26,0,32},
{9996,26,0,32},{638,22,1,32},{638,22,1,32},{638,22,1,32},{638,22,1,32},{638,22,
1,32},{9996,26,0,32},{9829,26,0,32},{9996,25,0,32},{9829,25,0,32},{9996,26,0,
32},{9830,26,0,32},{9996,25,0,32},{9830,25,0,32},{9996,26,0,32},{9834,26,0,32},
{9996,25,0,32},{9834,25,0,32},{9996,26,0,32},{9842,26,0,32},{9996,25,0,32},
{9842,25,0,32},{22998,4,0,32},{0,4,0,280},{22999,4,0,32},{0,4,0,280},{23000,4,0,
32},{0,4,0,280},{23001,4,0,32},{0,4,0,280},{23002,4,0,32},{0,4,0,280},{23003,4,
0,32},{0,4,0,280},{23004,4,0,32},{0,4,0,280},{23004,4,0,32},{0,4,0,281},{23005,
4,0,32},{0,4,0,280},{23006,4,0,32},{0,4,0,280},{23007,4,0,32},{0,4,0,280},
{23007,4,0,32},{0,4,0,281},{23008,4,0,32},{0,4,0,280},{23008,4,0,32},{0,4,0,
281},{23009,4,0,32},{0,4,0,280},{23009,4,0,32},{0,4,0,281},{23010,4,0,32},{0,4,
0,280},{23011,4,0,32},{0,4,0,280},{23012,4,0,32},{0,4,0,280},{23013,4,0,32},{0,
4,0,281},{23013,4,0,32},{0,4,0,282},{23014,4,0,32},{0,4,0,280},{23015,4,0,32},
{0,4,0,280},{23016,4,0,32},{0,4,0,280},{23017,4,0,32},{0,4,0,280},{23017,4,0,
32},{0,4,0,281},{23018,4,0,32},{0,4,0,280},{23018,4,0,32},{0,4,0,281},{23019,4,
0,32},{0,4,0,280},{23020,4,0,32},{0,4,0,280},{23013,4,0,32},{0,4,0,280},{20601,
4,0,32},{0,4,0,281},{20418,4,0,32},{0,4,0,280},{15500,4,0,32},{0,4,0,280},
{15502,4,0,32},{0,4,0,280},{15505,4,0,32},{0,4,0,280},{15506,4,0,32},{0,4,0,
280},{15507,4,0,32},{0,4,0,280},{15508,4,0,32},{0,4,0,280},{15509,4,0,32},{0,4,
0,280},{15510,4,0,32},{0,4,0,280},{15512,4,0,32},{0,4,0,280},{15513,4,0,32},{0,
4,0,280},{15514,4,0,32},{0,4,0,280},{15515,4,0,32},{0,4,0,280},{15516,4,0,32},
{0,4,0,280},{15517,4,0,32},{0,4,0,280},{15522,4,0,32},{0,4,0,280},{15523,4,0,
32},{0,4,0,280},{15524,4,0,32},{0,4,0,280},{15525,4,0,32},{0,4,0,280},{15527,4,
0,32},{0,4,0,280},{15531,4,0,32},{0,4,0,280},{15532,4,0,32},{0,4,0,280},{15533,
4,0,32},{0,4,0,280},{15534,4,0,32},{0,4,0,280},{15535,4,0,32},{0,4,0,280},
{15539,4,0,32},{0,4,0,280},{15540,4,0,32},{0,4,0,280},{15541,4,0,32},{0,4,0,
280},{15542,4,0,32},{0,4,0,280},{15459,10,0,32},{0,4,0,280},{15467,10,0,32},{0,
4,0,280},{15467,10,0,32},{0,4,0,281},{15472,10,0,32},{0,4,0,280},{15482,10,0,
32},{0,4,0,280},{15483,10,0,32},{0,4,0,280},{15483,10,0,32},{0,4,0,281},{15486,
10,0,32},{0,4,0,280},{15493,10,0,32},{0,4,0,280},{15494,10,0,32},{0,4,0,280},
{15459,4,0,32},{0,4,0,280},{15467,4,0,32},{0,4,0,280},{15467,4,0,32},{0,4,0,
281},{15472,4,0,32},{0,4,0,280},{15482,4,0,32},{0,4,0,280},{15483,4,0,32},{0,4,
0,280},{15483,4,0,32},{0,4,0,281},{15486,4,0,32},{0,4,0,280},{15493,4,0,32},{0,
4,0,280},{15494,4,0,32},{0,4,0,280},{20641,4,0,32},{0,4,0,281},{20643,4,0,32},
{0,4,0,281},{20645,4,0,32},{0,4,0,281},{20648,4,0,32},{0,4,0,281},{20643,4,0,
32},{20646,4,0,32},{20666,4,0,32},{0,4,0,281},{20578,4,0,32},{20581,4,0,32},
{11613,2,0,32},{0,2,0,194},{11614,2,0,32},{0,2,0,194},{11623,2,0,32},{0,2,0,
194},{12105,4,0,32},{0,4,0,280},{12105,4,0,32},{0,4,0,281},{12106,4,0,32},{0,4,
0,280},{12107,4,0,32},{0,4,0,280},{12153,4,0,32},{0,4,0,280},{12154,4,0,32},{0,
4,0,280},{12457,4,0,32},{0,4,0,280},{12473,4,0,32},{0,4,0,280},{12460,4,0,32},
{0,4,0,280},{8089,4,0,32},{0,4,0,280},{8090,4,0,32},{0,4,0,280},{8091,2,0,32},
{0,2,0,280},{4722,2,1,32},{0,0,0,0},{4723,2,1,32},{0,0,0,0},{4723,2,1,32},{0,0,
0,0},{0,0,0,0},{4723,2,1,32},{0,0,0,0},{0,0,0,0},{4723,2,1,32},{0,0,0,0},{0,0,0,
0},{4723,2,1,32},{0,0,0,0},{0,0,0,0},{4723,2,1,32},{0,0,0,0},{0,0,0,0},{4775,2,
1,32},{0,0,0,0},{4775,2,1,32},{0,0,0,0},{0,0,0,0},{4775,2,1,32},{0,0,0,0},{0,0,
0,0},{4776,2,1,32},{0,0,0,0},{4776,2,1,32},{0,0,0,0},{0,0,0,0},{4776,2,1,32},{0,
0,0,0},{0,0,0,0},{8089,4,0,32},{0,4,0,280},{8090,4,0,32},{0,4,0,280},{8090,4,0,
32},{0,4,0,280},{8091,4,0,32},{0,4,0,280},{8092,4,0,32},{0,4,0,280},{8093,4,0,
32},{0,4,0,280},{8094,4,0,32},{0,4,0,280},{8095,4,0,32},{0,4,0,280},{8096,4,0,
32},{0,4,0,280},{8097,4,0,32},{0,4,0,280},{8088,4,0,32},{638,4,1,32},{8088,4,0,
32},{547,4,1,32},{8089,4,0,32},{547,4,1,32},{8090,4,0,32},{547,4,1,32},{8091,4,
0,32},{547,4,1,32},{8092,4,0,32},{547,4,1,32},{8093,4,0,32},{547,4,1,32},{8094,
4,0,32},{547,4,1,32},{8095,4,0,32},{547,4,1,32},{8096,4,0,32},{547,4,1,32},
{8097,4,0,32},{547,4,1,32},{808,4,1,32},{8098,10,0,32},{809,4,1,32},{808,4,1,
32},{8124,10,0,32},{809,4,1,32},{808,4,1,32},{8150,10,0,32},{809,4,1,32},{808,4,
1,32},{8171,10,0,32},{809,4,1,32},{808,4,1,32},{8199,10,0,32},{809,4,1,32},{808,
4,1,32},{8258,10,0,32},{809,4,1,32},{808,4,1,32},{8273,10,0,32},{809,4,1,32},
{808,4,1,32},{8309,10,0,32},{809,4,1,32},{808,4,1,32},{8336,10,0,32},{809,4,1,
32},{808,4,1,32},{8363,10,0,32},{809,4,1,32},{808,4,1,32},{8388,10,0,32},{809,4,
1,32},{808,4,1,32},{8406,10,0,32},{809,4,1,32},{808,4,1,32},{8457,10,0,32},{809,
4,1,32},{808,4,1,32},{8472,10,0,32},{809,4,1,32},{808,4,1,32},{8508,10,0,32},
{809,4,1,32},{808,4,1,32},{8555,10,0,32},{809,4,1,32},{808,4,1,32},{8576,10,0,
32},{809,4,1,32},{808,4,1,32},{8595,10,0,32},{809,4,1,32},{808,4,1,32},{8658,10,
0,32},{809,4,1,32},{808,4,1,32},{8695,10,0,32},{809,4,1,32},{808,4,1,32},{8727,
10,0,32},{809,4,1,32},{808,4,1,32},{8775,10,0,32},{809,4,1,32},{808,4,1,32},
{8793,10,0,32},{809,4,1,32},{808,4,1,32},{8804,10,0,32},{809,4,1,32},{808,4,1,
32},{8816,10,0,32},{809,4,1,32},{808,4,1,32},{8838,10,0,32},{809,4,1,32},{906,4,
1,32},{8658,10,0,32},{907,4,1,32},{8150,12,0,32},{8171,12,0,32},{8793,12,0,32},
{8838,12,0,32},{8309,29,0,32},{8775,29,0,32},{8457,29,0,32},{8775,29,0,32},
{8658,29,0,32},{8171,29,0,32},{8658,29,0,32},{8658,29,0,32},{8555,29,0,32},
{8555,29,0,32},{8775,29,0,32},{8793,29,0,32},{8150,29,0,32},{8457,20,0,32},
{8150,20,0,32},{8457,20,0,32},{8171,20,0,32},{8457,20,0,32},{8595,20,0,32},
{8336,29,0,32},{8150,29,0,32},{8555,29,0,32},{8098,29,0,32},{8658,29,0,32},
{8098,29,0,32},{8098,29,0,32},{8124,29,0,32},{8793,29,0,32},{8150,29,0,32},
{8171,29,0,32},{8363,29,0,32},{8150,29,0,32},{8406,29,0,32},{8150,29,0,32},
{8508,29,0,32},{8508,29,0,32},{8406,29,0,32},{8258,29,0,32},{8595,29,0,32},
{8199,29,0,32},{8199,29,0,32},{8336,29,0,32},{8171,29,0,32},{8472,29,0,32},
{8199,29,0,32},{8793,29,0,32},{8472,29,0,32},{8273,29,0,32},{8508,29,0,32},
{8388,29,0,32},{8658,29,0,32},{8508,29,0,32},{8658,29,0,32},{8727,29,0,32},
{8555,29,0,32},{615,28,1,32},{8775,29,0,32},{8658,29,0,32},{8091,28,0,32},{8171,
29,0,32},{8090,28,0,32},{8472,28,0,32},{8171,28,0,32},{521,28,1,32},{8658,29,0,
32},{8150,28,0,32},{8595,28,0,32},{8090,28,0,32},{8388,29,0,32},{8092,28,0,32},
{8388,29,0,32},{8096,28,0,32},{8388,29,0,32},{8093,28,0,32},{638,28,1,32},{8089,
28,0,32},{8095,28,0,32},{638,28,1,32},{8089,28,0,32},{8090,28,0,32},{8090,28,0,
32},{638,28,1,32},{8090,28,0,32},{8094,28,0,32},{8088,28,0,32},{8555,29,0,32},
{8089,28,0,32},{8090,28,0,32},{8088,28,0,32},{8555,29,0,32},{8309,29,0,32},
{8150,28,0,32},{8309,29,0,32},{8171,28,0,32},{8595,29,0,32},{8309,29,0,32},
{8336,28,0,32},{521,28,1,32},{8595,29,0,32},{8199,28,0,32},{8658,28,0,32},{8406,
29,0,32},{8508,28,0,32},{8658,28,0,32},{8658,28,0,32},{8406,28,0,32},{8199,28,0,
32},{8658,28,0,32},{8658,28,0,32},{8658,29,0,32},{8309,29,0,32},{8775,29,0,32},
{8727,29,0,32},{8309,29,0,32},{8171,29,0,32},{8775,29,0,32},{8508,29,0,32},
{8171,29,0,32},{17144,28,0,32},{17120,28,0,32},{17124,28,0,32},{17124,28,0,32},
{64320,28,0,32},{57931,0,0,0},{64320,28,0,32},{56151,0,0,0},{64320,28,0,32},
{54220,0,0,0},{17133,28,0,32},{0,28,0,55},{64320,28,0,32},{52876,0,0,0},{64320,
28,0,32},{55578,0,0,0},{64321,28,0,32},{35299,0,0,0},{64320,28,0,32},{55593,0,0,
0},{64320,28,0,32},{52900,0,0,0},{64320,28,0,32},{58912,0,0,0},{64320,28,0,32},
{61729,0,0,0},{64320,28,0,32},{58777,0,0,0},{64320,28,0,32},{53837,0,0,0},
{64320,28,0,32},{57228,0,0,0},{64320,28,0,32},{53645,0,0,0},{64320,28,0,32},
{58800,0,0,0},{64320,28,0,32},{53789,0,0,0},{64320,28,0,32},{64834,0,0,0},
{64320,28,0,32},{62751,0,0,0},{64321,28,0,32},{36009,0,0,0},{64320,28,0,32},
{55536,0,0,0},{64320,28,0,32},{54329,0,0,0},{64320,28,0,32},{61204,0,0,0},
{64320,28,0,32},{58005,0,0,0},{64320,28,0,32},{58197,0,0,0},{64320,28,0,32},
{52736,0,0,0},{64320,28,0,32},{52745,0,0,0},{64321,28,0,32},{36938,0,0,0},
{64320,28,0,32},{56806,0,0,0},{64320,28,0,32},{52781,0,0,0},{64320,28,0,32},
{54259,0,0,0},{64320,28,0,32},{58119,0,0,0},{64321,28,0,32},{36208,0,0,0},
{64320,28,0,32},{57939,0,0,0},{64320,28,0,32},{63873,0,0,0},{64320,28,0,32},
{64122,0,0,0},{64320,28,0,32},{54280,0,0,0},{64320,28,0,32},{61056,0,0,0},
{64320,28,0,32},{59145,0,0,0},{64320,28,0,32},{59144,0,0,0},{64320,28,0,32},
{62771,0,0,0},{64320,28,0,32},{53874,0,0,0},{64320,28,0,32},{54710,0,0,0},
{64321,28,0,32},{37197,0,0,0},{906,4,1,32},{64320,4,0,32},{59180,0,0,0},{907,4,
1,32},{906,4,1,32},{64320,4,0,32},{52745,0,0,0},{907,4,1,32},{906,4,1,32},
{64320,4,0,32},{52876,0,0,0},{907,4,1,32},{906,4,1,32},{64320,4,0,32},{56201,0,
0,0},{907,4,1,32},{906,4,1,32},{64320,4,0,32},{61625,0,0,0},{907,4,1,32},{906,4,
1,32},{64320,4,0,32},{57939,0,0,0},{907,4,1,32},{906,4,1,32},{64320,4,0,32},
{63191,0,0,0},{907,4,1,32},{906,4,1,32},{64320,4,0,32},{53981,0,0,0},{907,4,1,
32},{906,4,1,32},{64320,4,0,32},{58711,0,0,0},{907,4,1,32},{64320,6,0,32},
{57239,0,0,0},{64320,6,0,32},{54255,0,0,0},{64388,2,0,32},{33058,0,0,0},{64388,
2,0,32},{34076,0,0,0},{64388,2,0,32},{34085,0,0,0},{64388,2,0,32},{34123,0,0,0},
{64388,2,0,32},{34362,0,0,0},{64388,2,0,32},{34820,0,0,0},{64388,2,0,32},{35038,
0,0,0},{64388,2,0,32},{35372,0,0,0},{64388,2,0,32},{35683,0,0,0},{64388,2,0,32},
{38116,0,0,0},{64388,2,0,32},{38568,0,0,0},{64388,2,0,32},{38634,0,0,0},{64388,
2,0,32},{39368,0,0,0},{64388,2,0,32},{39704,0,0,0},{64388,2,0,32},{40203,0,0,0},
{64388,2,0,32},{40420,0,0,0},{64388,2,0,32},{40422,0,0,0},{64388,2,0,32},{41347,
0,0,0},{64388,2,0,32},{41375,0,0,0},{64388,2,0,32},{41777,0,0,0},{64388,2,0,32},
{42708,0,0,0},{64388,2,0,32},{43076,0,0,0},{64388,2,0,32},{43082,0,0,0},{64388,
2,0,32},{43788,0,0,0},{64388,2,0,32},{44017,0,0,0},{64388,2,0,32},{45066,0,0,0},
{64388,2,0,32},{45752,0,0,0},{64388,2,0,32},{45919,0,0,0},{64388,2,0,32},{45971,
0,0,0},{64388,2,0,32},{45980,0,0,0},{64388,2,0,32},{46019,0,0,0},{64388,2,0,32},
{46037,0,0,0},{64388,2,0,32},{46189,0,0,0},{64388,2,0,32},{46755,0,0,0},{64388,
2,0,32},{47271,0,0,0},{64388,2,0,32},{47757,0,0,0},{64388,2,0,32},{47866,0,0,0},
{64388,2,0,32},{48316,0,0,0},{64388,2,0,32},{48414,0,0,0},{64388,2,0,32},{48849,
0,0,0},{64388,2,0,32},{48990,0,0,0},{64388,2,0,32},{49038,0,0,0},{64388,2,0,32},
{49763,0,0,0},{64388,2,0,32},{49902,0,0,0},{64388,2,0,32},{50091,0,0,0},{64388,
2,0,32},{50696,0,0,0},{64388,2,0,32},{50997,0,0,0},{64388,2,0,32},{51220,0,0,0},
{64388,2,0,32},{52278,0,0,0},{64388,2,0,32},{52370,0,0,0},{64388,2,0,32},{53153,
0,0,0},{64388,2,0,32},{53176,0,0,0},{64388,2,0,32},{53316,0,0,0},{64388,2,0,32},
{53490,0,0,0},{64388,2,0,32},{53491,0,0,0},{64388,2,0,32},{53529,0,0,0},{64388,
2,0,32},{53555,0,0,0},{64388,2,0,32},{53833,0,0,0},{64388,2,0,32},{54301,0,0,0},
{64388,2,0,32},{54822,0,0,0},{64388,2,0,32},{54938,0,0,0},{64388,2,0,32},{54981,
0,0,0},{64388,2,0,32},{55676,0,0,0},{64388,2,0,32},{55975,0,0,0},{64388,2,0,32},
{56235,0,0,0},{64388,2,0,32},{56448,0,0,0},{64388,2,0,32},{56528,0,0,0},{64388,
2,0,32},{57222,0,0,0},{64388,2,0,32},{57818,0,0,0},{64388,2,0,32},{57896,0,0,0},
{64388,2,0,32},{57927,0,0,0},{64388,2,0,32},{58073,0,0,0},{64388,2,0,32},{58174,
0,0,0},{64388,2,0,32},{58586,0,0,0},{64388,2,0,32},{58659,0,0,0},{64388,2,0,32},
{58792,0,0,0},{64388,2,0,32},{59303,0,0,0},{64388,2,0,32},{59317,0,0,0},{64388,
2,0,32},{60220,0,0,0},{64388,2,0,32},{60470,0,0,0},{64388,2,0,32},{60629,0,0,0},
{64388,2,0,32},{60779,0,0,0},{64388,2,0,32},{61228,0,0,0},{64388,2,0,32},{61361,
0,0,0},{64388,2,0,32},{61650,0,0,0},{64388,2,0,32},{62410,0,0,0},{64388,2,0,32},
{63079,0,0,0},{64388,2,0,32},{63662,0,0,0},{64388,2,0,32},{63846,0,0,0},{64388,
2,0,32},{64680,0,0,0},{64388,2,0,32},{65235,0,0,0},{64388,2,0,32},{65327,0,0,0},
{64389,2,0,32},{34258,0,0,0},{64389,2,0,32},{34285,0,0,0},{64389,2,0,32},{34606,
0,0,0},{64389,2,0,32},{35834,0,0,0},{64389,2,0,32},{36215,0,0,0},{64389,2,0,32},
{37189,0,0,0},{64389,2,0,32},{37343,0,0,0},{64389,2,0,32},{37402,0,0,0},{64389,
2,0,32},{37898,0,0,0},{64389,2,0,32},{38038,0,0,0},{64389,2,0,32},{38326,0,0,0},
{64389,2,0,32},{39728,0,0,0},{64389,2,0,32},{41166,0,0,0},{64389,2,0,32},{41221,
0,0,0},{64389,2,0,32},{41486,0,0,0},{64389,2,0,32},{41617,0,0,0},{64389,2,0,32},
{41874,0,0,0},{64389,2,0,32},{42496,0,0,0}};
