// Copyright 2019, Collabora, Ltd.
// SPDX-License-Identifier: BSL-1.0
/*!
 * @file
 * @brief  Documentation for the compositor.
 * @author Jakob Bornecrantz <jakob@collabora.com>
 * @author Lubosz Sarnecki <lubosz.sarnecki@collabora.com>
 * @ingroup comp
 */

#pragma once


/*!
 * @defgroup comp Compositor
 * @ingroup xrt
 *
 * @brief All of the compositor code.
 */

/*!
 * @defgroup comp_main Main compositor code
 * @ingroup comp
 *
 * @brief  Main compositor code.
 */

/*!
 * @defgroup comp_util Compositor utility code
 * @ingroup comp
 *
 * @brief General compositor utility code.
 */

/*!
 * @defgroup comp_client Compositor client code
 * @ingroup comp
 *
 * @brief Glue code between client program to the main compositor.
 */

/*!
 * @dir compositor
 * @ingroup xrt
 *
 * @brief All of the compositor code.
 */

/*!
 * @dir compositor/client
 * @ingroup comp
 *
 * @brief Compositor client code.
 */

/*!
 * @dir compositor/main
 * @ingroup comp
 *
 * @brief Main compositor code.
 */
