/*
   Copyright 2008 Brain Research Institute, Melbourne, Australia

   Written by J-Donald Tournier, 27/06/08.

   This file is part of MRtrix.

   MRtrix is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   MRtrix is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with MRtrix.  If not, see <http://www.gnu.org/licenses/>.

 */

#include "file/dicom/element.h"

namespace MR {
  namespace File {
    namespace Dicom {

      UnorderedMap<guint32, const gchar*>::Type Element::dict;


      void Element::init_dict()
      {
        info ("initialising DICOM dictionary");

        /* the following was generated by running the following command on the dicom dictionary file:

           awk '{ print "dict[0x"$1$2"UL] =  \""$3$4"\";" }' dict.txt 

         */


        dict[0x00020000UL] =  "ULFileMetaInformationGroupLength";
        dict[0x00020001UL] =  "OBFileMetaInformationVersion";
        dict[0x00020002UL] =  "UIMediaStorageSOPClassUID";
        dict[0x00020003UL] =  "UIMediaStorageSOPInstanceUID";
        dict[0x00020010UL] =  "UITransferSyntaxUID";
        dict[0x00020012UL] =  "UIImplementationClassUID";
        dict[0x00020013UL] =  "SHImplementationVersionName";
        dict[0x00020016UL] =  "AESourceApplicationEntityTitle";
        dict[0x00020100UL] =  "UIPrivateInformationCreatorUID";
        dict[0x00020102UL] =  "OBPrivateInformation";
        dict[0x00041130UL] =  "CSFileSetID";
        dict[0x00041141UL] =  "CSFileSetDescriptorFileID";
        dict[0x00041142UL] =  "CSSpecificCharacterSetOfFileSetDescriptorFile";
        dict[0x00041200UL] =  "ULOffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity";
        dict[0x00041202UL] =  "ULOffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity";
        dict[0x00041212UL] =  "USFileSetConsistencyFlag";
        dict[0x00041220UL] =  "SQDirectoryRecordSequence";
        dict[0x00041400UL] =  "ULOffsetOfTheNextDirectoryRecord";
        dict[0x00041410UL] =  "USRecordInUseFlag";
        dict[0x00041420UL] =  "ULOffsetOfReferencedLowerLevelDirectoryEntity";
        dict[0x00041430UL] =  "CSDirectoryRecordType";
        dict[0x00041432UL] =  "UIPrivateRecordUID";
        dict[0x00041500UL] =  "CSReferencedFileID";
        dict[0x00041510UL] =  "UIReferencedSOPClassUIDInFile";
        dict[0x00041511UL] =  "UIReferencedSOPInstanceUIDInFile";
        dict[0x00041512UL] =  "UIReferencedTransferSyntaxUIDInFile";
        dict[0x0004151AUL] =  "UIReferencedRelatedGeneralSOPClassUIDInFile";
        dict[0x00080005UL] =  "CSSpecificCharacterSet";
        dict[0x00080006UL] =  "SQLanguageCodeSequence";
        dict[0x00080008UL] =  "CSImageType";
        dict[0x00080012UL] =  "DAInstanceCreationDate";
        dict[0x00080013UL] =  "TMInstanceCreationTime";
        dict[0x00080014UL] =  "UIInstanceCreatorUID";
        dict[0x00080016UL] =  "UISOPClassUID";
        dict[0x00080018UL] =  "UISOPInstanceUID";
        dict[0x0008001AUL] =  "UIRelatedGeneralSOPClassUID";
        dict[0x0008001BUL] =  "UIOriginalSpecializedSOPClassUID";
        dict[0x00080020UL] =  "DAStudyDate";
        dict[0x00080021UL] =  "DASeriesDate";
        dict[0x00080022UL] =  "DAAcquisitionDate";
        dict[0x00080023UL] =  "DAContentDate";
        dict[0x0008002AUL] =  "DTAcquisitionDateTime";
        dict[0x00080030UL] =  "TMStudyTime";
        dict[0x00080031UL] =  "TMSeriesTime";
        dict[0x00080032UL] =  "TMAcquisitionTime";
        dict[0x00080033UL] =  "TMContentTime";
        dict[0x00080050UL] =  "SHAccessionNumber";
        dict[0x00080051UL] =  "SQIssuerOfAccessionNumberSequence";
        dict[0x00080052UL] =  "CSQueryRetrieveLevel";
        dict[0x00080054UL] =  "AERetrieveAETitle";
        dict[0x00080056UL] =  "CSInstanceAvailability";
        dict[0x00080058UL] =  "UIFailedSOPInstanceUIDList";
        dict[0x00080060UL] =  "CSModality";
        dict[0x00080061UL] =  "CSModalitiesInStudy";
        dict[0x00080062UL] =  "UISOPClassesInStudy";
        dict[0x00080064UL] =  "CSConversionType";
        dict[0x00080068UL] =  "CSPresentationIntentType";
        dict[0x00080070UL] =  "LOManufacturer";
        dict[0x00080080UL] =  "LOInstitutionName";
        dict[0x00080081UL] =  "STInstitutionAddress";
        dict[0x00080082UL] =  "SQInstitutionCodeSequence";
        dict[0x00080090UL] =  "PNReferringPhysicianName";
        dict[0x00080092UL] =  "STReferringPhysicianAddress";
        dict[0x00080094UL] =  "SHReferringPhysicianTelephoneNumbers";
        dict[0x00080096UL] =  "SQReferringPhysicianIdentificationSequence";
        dict[0x00080100UL] =  "SHCodeValue";
        dict[0x00080102UL] =  "SHCodingSchemeDesignator";
        dict[0x00080103UL] =  "SHCodingSchemeVersion";
        dict[0x00080104UL] =  "LOCodeMeaning";
        dict[0x00080105UL] =  "CSMappingResource";
        dict[0x00080106UL] =  "DTContextGroupVersion";
        dict[0x00080107UL] =  "DTContextGroupLocalVersion";
        dict[0x0008010BUL] =  "CSContextGroupExtensionFlag";
        dict[0x0008010CUL] =  "UICodingSchemeUID";
        dict[0x0008010DUL] =  "UIContextGroupExtensionCreatorUID";
        dict[0x0008010FUL] =  "CSContextIdentifier";
        dict[0x00080110UL] =  "SQCodingSchemeIdentificationSequence";
        dict[0x00080112UL] =  "LOCodingSchemeRegistry";
        dict[0x00080114UL] =  "STCodingSchemeExternalID";
        dict[0x00080115UL] =  "STCodingSchemeName";
        dict[0x00080116UL] =  "STCodingSchemeResponsibleOrganization";
        dict[0x00080117UL] =  "UIContextUID";
        dict[0x00080201UL] =  "SHTimezoneOffsetFromUTC";
        dict[0x00081010UL] =  "SHStationName";
        dict[0x00081030UL] =  "LOStudyDescription";
        dict[0x00081032UL] =  "SQProcedureCodeSequence";
        dict[0x0008103EUL] =  "LOSeriesDescription";
        dict[0x0008103FUL] =  "SQSeriesDescriptionCodeSequence";
        dict[0x00081040UL] =  "LOInstitutionalDepartmentName";
        dict[0x00081048UL] =  "PNPhysiciansOfRecord";
        dict[0x00081049UL] =  "SQPhysiciansOfRecordIdentificationSequence";
        dict[0x00081050UL] =  "PNPerformingPhysicianName";
        dict[0x00081052UL] =  "SQPerformingPhysicianIdentificationSequence";
        dict[0x00081060UL] =  "PNNameOfPhysiciansReadingStudy";
        dict[0x00081062UL] =  "SQPhysiciansReadingStudyIdentificationSequence";
        dict[0x00081070UL] =  "PNOperatorsName";
        dict[0x00081072UL] =  "SQOperatorIdentificationSequence";
        dict[0x00081080UL] =  "LOAdmittingDiagnosesDescription";
        dict[0x00081084UL] =  "SQAdmittingDiagnosesCodeSequence";
        dict[0x00081090UL] =  "LOManufacturerModelName";
        dict[0x00081110UL] =  "SQReferencedStudySequence";
        dict[0x00081111UL] =  "SQReferencedPerformedProcedureStepSequence";
        dict[0x00081115UL] =  "SQReferencedSeriesSequence";
        dict[0x00081120UL] =  "SQReferencedPatientSequence";
        dict[0x00081125UL] =  "SQReferencedVisitSequence";
        dict[0x00081134UL] =  "SQReferencedStereometricInstanceSequence";
        dict[0x0008113AUL] =  "SQReferencedWaveformSequence";
        dict[0x00081140UL] =  "SQReferencedImageSequence";
        dict[0x0008114AUL] =  "SQReferencedInstanceSequence";
        dict[0x0008114BUL] =  "SQReferencedRealWorldValueMappingInstanceSequence";
        dict[0x00081150UL] =  "UIReferencedSOPClassUID";
        dict[0x00081155UL] =  "UIReferencedSOPInstanceUID";
        dict[0x0008115AUL] =  "UISOPClassesSupported";
        dict[0x00081160UL] =  "ISReferencedFrameNumber";
        dict[0x00081161UL] =  "ULSimpleFrameList";
        dict[0x00081162UL] =  "ULCalculatedFrameList";
        dict[0x00081163UL] =  "FDTimeRange";
        dict[0x00081164UL] =  "SQFrameExtractionSequence";
        dict[0x00081167UL] =  "UIMultiFrameSourceSOPInstanceUID";
        dict[0x00081195UL] =  "UITransactionUID";
        dict[0x00081197UL] =  "USFailureReason";
        dict[0x00081198UL] =  "SQFailedSOPSequence";
        dict[0x00081199UL] =  "SQReferencedSOPSequence";
        dict[0x00081200UL] =  "SQStudiesContainingOtherReferencedInstancesSequence";
        dict[0x00081250UL] =  "SQRelatedSeriesSequenceired";
        dict[0x00082111UL] =  "STDerivationDescription";
        dict[0x00082112UL] =  "SQSourceImageSequence";
        dict[0x00082120UL] =  "SHStageName";
        dict[0x00082122UL] =  "ISStageNumber";
        dict[0x00082124UL] =  "ISNumberOfStages";
        dict[0x00082127UL] =  "SHViewName";
        dict[0x00082128UL] =  "ISViewNumber";
        dict[0x00082129UL] =  "ISNumberOfEventTimers";
        dict[0x0008212AUL] =  "ISNumberOfViewsInStage";
        dict[0x00082130UL] =  "DSEventElapsedTimes";
        dict[0x00082132UL] =  "LOEventTimerNames";
        dict[0x00082133UL] =  "SQEventTimerSequence";
        dict[0x00082134UL] =  "FDEventTimeOffset";
        dict[0x00082135UL] =  "SQEventCodeSequence";
        dict[0x00082142UL] =  "ISStartTrim";
        dict[0x00082143UL] =  "ISStopTrim";
        dict[0x00082144UL] =  "ISRecommendedDisplayFrameRate";
        dict[0x00082218UL] =  "SQAnatomicRegionSequence";
        dict[0x00082220UL] =  "SQAnatomicRegionModifierSequence";
        dict[0x00082228UL] =  "SQPrimaryAnatomicStructureSequence";
        dict[0x00082229UL] =  "SQAnatomicStructureSpaceOrRegionSequence";
        dict[0x00082230UL] =  "SQPrimaryAnatomicStructureModifierSequence";
        dict[0x00083001UL] =  "SQAlternateRepresentationSequence";
        dict[0x00083010UL] =  "UIIrradiationEventUID";
        dict[0x00089007UL] =  "CSFrameType";
        dict[0x00089092UL] =  "SQReferencedImageEvidenceSequence";
        dict[0x00089121UL] =  "SQReferencedRawDataSequence";
        dict[0x00089123UL] =  "UICreatorVersionUID";
        dict[0x00089124UL] =  "SQDerivationImageSequence";
        dict[0x00089154UL] =  "SQSourceImageEvidenceSequence";
        dict[0x00089205UL] =  "CSPixelPresentation";
        dict[0x00089206UL] =  "CSVolumetricProperties";
        dict[0x00089207UL] =  "CSVolumeBasedCalculationTechnique";
        dict[0x00089208UL] =  "CSComplexImageComponent";
        dict[0x00089209UL] =  "CSAcquisitionContrast";
        dict[0x00089215UL] =  "SQDerivationCodeSequence";
        dict[0x00089237UL] =  "SQReferencedPresentationStateSequence";
        dict[0x00089410UL] =  "SQReferencedOtherPlaneSequence";
        dict[0x00089458UL] =  "SQFrameDisplaySequence";
        dict[0x00089459UL] =  "FLRecommendedDisplayFrameRateInFloat";
        dict[0x00089460UL] =  "CSSkipFrameRangeFlag";
        dict[0x00100010UL] =  "PNPatientName";
        dict[0x00100020UL] =  "LOPatientID";
        dict[0x00100021UL] =  "LOIssuerOfPatientID";
        dict[0x00100022UL] =  "CSTypeOfPatientID";
        dict[0x00100024UL] =  "SQIssuerOfPatientIDQualifiersSequence";
        dict[0x00100030UL] =  "DAPatientBirthDate";
        dict[0x00100032UL] =  "TMPatientBirthTime";
        dict[0x00100040UL] =  "CSPatientSex";
        dict[0x00100050UL] =  "SQPatientInsurancePlanCodeSequence";
        dict[0x00100101UL] =  "SQPatientPrimaryLanguageCodeSequence";
        dict[0x00100102UL] =  "SQPatientPrimaryLanguageModifierCodeSequence";
        dict[0x00101000UL] =  "LOOtherPatientIDs";
        dict[0x00101001UL] =  "PNOtherPatientNames";
        dict[0x00101002UL] =  "SQOtherPatientIDsSequence";
        dict[0x00101005UL] =  "PNPatientBirthName";
        dict[0x00101010UL] =  "ASPatientAge";
        dict[0x00101020UL] =  "DSPatientSize";
        dict[0x00101021UL] =  "SQPatientSizeCodeSequence";
        dict[0x00101030UL] =  "DSPatientWeight";
        dict[0x00101040UL] =  "LOPatientAddress";
        dict[0x00101060UL] =  "PNPatientMotherBirthName";
        dict[0x00101080UL] =  "LOMilitaryRank";
        dict[0x00101081UL] =  "LOBranchOfService";
        dict[0x00101090UL] =  "LOMedicalRecordLocator";
        dict[0x00102000UL] =  "LOMedicalAlerts";
        dict[0x00102110UL] =  "LOAllergies";
        dict[0x00102150UL] =  "LOCountryOfResidence";
        dict[0x00102152UL] =  "LORegionOfResidence";
        dict[0x00102154UL] =  "SHPatientTelephoneNumbers";
        dict[0x00102160UL] =  "SHEthnicGroup";
        dict[0x00102180UL] =  "SHOccupation";
        dict[0x001021A0UL] =  "CSSmokingStatus";
        dict[0x001021B0UL] =  "LTAdditionalPatientHistory";
        dict[0x001021C0UL] =  "USPregnancyStatus";
        dict[0x001021D0UL] =  "DALastMenstrualDate";
        dict[0x001021F0UL] =  "LOPatientReligiousPreference";
        dict[0x00102201UL] =  "LOPatientSpeciesDescription";
        dict[0x00102202UL] =  "SQPatientSpeciesCodeSequence";
        dict[0x00102203UL] =  "CSPatientSexNeutered";
        dict[0x00102210UL] =  "CSAnatomicalOrientationType";
        dict[0x00102292UL] =  "LOPatientBreedDescription";
        dict[0x00102293UL] =  "SQPatientBreedCodeSequence";
        dict[0x00102294UL] =  "SQBreedRegistrationSequence";
        dict[0x00102295UL] =  "LOBreedRegistrationNumber";
        dict[0x00102296UL] =  "SQBreedRegistryCodeSequence";
        dict[0x00102297UL] =  "PNResponsiblePerson";
        dict[0x00102298UL] =  "CSResponsiblePersonRole";
        dict[0x00102299UL] =  "LOResponsibleOrganization";
        dict[0x00104000UL] =  "LTPatientComments";
        dict[0x00109431UL] =  "FLExaminedBodyThickness";
        dict[0x00120010UL] =  "LOClinicalTrialSponsorName";
        dict[0x00120020UL] =  "LOClinicalTrialProtocolID";
        dict[0x00120021UL] =  "LOClinicalTrialProtocolName";
        dict[0x00120030UL] =  "LOClinicalTrialSiteID";
        dict[0x00120031UL] =  "LOClinicalTrialSiteName";
        dict[0x00120040UL] =  "LOClinicalTrialSubjectID";
        dict[0x00120042UL] =  "LOClinicalTrialSubjectReadingID";
        dict[0x00120050UL] =  "LOClinicalTrialTimePointID";
        dict[0x00120051UL] =  "STClinicalTrialTimePointDescription";
        dict[0x00120060UL] =  "LOClinicalTrialCoordinatingCenterName";
        dict[0x00120062UL] =  "CSPatientIdentityRemoved";
        dict[0x00120063UL] =  "LODeidentificationMethod";
        dict[0x00120064UL] =  "SQDeidentificationMethodCodeSequence";
        dict[0x00120071UL] =  "LOClinicalTrialSeriesID";
        dict[0x00120072UL] =  "LOClinicalTrialSeriesDescription";
        dict[0x00120081UL] =  "LOClinicalTrialProtocolEthicsCommitteeName";
        dict[0x00120082UL] =  "LOClinicalTrialProtocolEthicsCommitteeApprovalNumber";
        dict[0x00120083UL] =  "SQConsentForClinicalTrialUseSequence";
        dict[0x00120084UL] =  "CSDistributionType";
        dict[0x00120085UL] =  "CSConsentForDistributionFlag";
        dict[0x00140023UL] =  "STCADFileFormat";
        dict[0x00140024UL] =  "STComponentReferenceSystem";
        dict[0x00140025UL] =  "STComponentManufacturingProcedure";
        dict[0x00140028UL] =  "STComponentManufacturer";
        dict[0x00140030UL] =  "DSMaterialThickness";
        dict[0x00140032UL] =  "DSMaterialPipeDiameter";
        dict[0x00140034UL] =  "DSMaterialIsolationDiameter";
        dict[0x00140042UL] =  "STMaterialGrade";
        dict[0x00140044UL] =  "STMaterialPropertiesFileID";
        dict[0x00140045UL] =  "STMaterialPropertiesFileFormat";
        dict[0x00140046UL] =  "LTMaterialNotes";
        dict[0x00140050UL] =  "CSComponentShape";
        dict[0x00140052UL] =  "CSCurvatureType";
        dict[0x00140054UL] =  "DSOuterDiameter";
        dict[0x00140056UL] =  "DSInnerDiameter";
        dict[0x00141010UL] =  "STActualEnvironmentalConditions";
        dict[0x00141020UL] =  "DAExpiryDate";
        dict[0x00141040UL] =  "STEnvironmentalConditions";
        dict[0x00142002UL] =  "SQEvaluatorSequence";
        dict[0x00142004UL] =  "ISEvaluatorNumber";
        dict[0x00142006UL] =  "PNEvaluatorName";
        dict[0x00142008UL] =  "ISEvaluationAttempt";
        dict[0x00142012UL] =  "SQIndicationSequence";
        dict[0x00142014UL] =  "ISIndicationNumber";
        dict[0x00142016UL] =  "SHIndicationLabel";
        dict[0x00142018UL] =  "STIndicationDescription";
        dict[0x0014201AUL] =  "CSIndicationType";
        dict[0x0014201CUL] =  "CSIndicationDisposition";
        dict[0x0014201EUL] =  "SQIndicationROISequence";
        dict[0x00142030UL] =  "SQIndicationPhysicalPropertySequence";
        dict[0x00142032UL] =  "SHPropertyLabel";
        dict[0x00142202UL] =  "ISCoordinateSystemNumberOfAxes";
        dict[0x00142204UL] =  "SQCoordinateSystemAxesSequence";
        dict[0x00142206UL] =  "STCoordinateSystemAxisDescription";
        dict[0x00142208UL] =  "CSCoordinateSystemDataSetMapping";
        dict[0x0014220AUL] =  "ISCoordinateSystemAxisNumber";
        dict[0x0014220CUL] =  "CSCoordinateSystemAxisType";
        dict[0x0014220EUL] =  "CSCoordinateSystemAxisUnits";
        dict[0x00142210UL] =  "OBCoordinateSystemAxisValues";
        dict[0x00142220UL] =  "SQCoordinateSystemTransformSequence";
        dict[0x00142222UL] =  "STTransformDescription";
        dict[0x00142224UL] =  "ISTransformNumberOfAxes";
        dict[0x00142226UL] =  "ISTransformOrderOfAxes";
        dict[0x00142228UL] =  "CSTransformedAxisUnits";
        dict[0x0014222AUL] =  "DSCoordinateSystemTransformRotationAndScaleMatrix";
        dict[0x0014222CUL] =  "DSCoordinateSystemTransformTranslationMatrix";
        dict[0x00143011UL] =  "DSInternalDetectorFrameTime";
        dict[0x00143012UL] =  "DSNumberOfFramesIntegrated";
        dict[0x00143020UL] =  "SQDetectorTemperatureSequence";
        dict[0x00143022UL] =  "DSSensorName";
        dict[0x00143024UL] =  "DSHorizontalOffsetOfSensor";
        dict[0x00143026UL] =  "DSVerticalOffsetOfSensor";
        dict[0x00143028UL] =  "DSSensorTemperature";
        dict[0x00143040UL] =  "SQDarkCurrentSequence";
        dict[0x00143050UL] =  "OBDarkCurrentCounts";
        dict[0x00143060UL] =  "SQGainCorrectionReferenceSequence";
        dict[0x00143070UL] =  "OBAirCounts";
        dict[0x00143071UL] =  "DSKVUsedInGainCalibration";
        dict[0x00143072UL] =  "DSMAUsedInGainCalibration";
        dict[0x00143073UL] =  "DSNumberOfFramesUsedForIntegration";
        dict[0x00143074UL] =  "LOFilterMaterialUsedInGainCalibration";
        dict[0x00143075UL] =  "DSFilterThicknessUsedInGainCalibration";
        dict[0x00143076UL] =  "DADateOfGainCalibration";
        dict[0x00143077UL] =  "TMTimeOfGainCalibration";
        dict[0x00143080UL] =  "OBBadPixelImage";
        dict[0x00143099UL] =  "LTCalibrationNotes";
        dict[0x00144002UL] =  "SQPulserEquipmentSequence";
        dict[0x00144004UL] =  "CSPulserType";
        dict[0x00144006UL] =  "LTPulserNotes";
        dict[0x00144008UL] =  "SQReceiverEquipmentSequence";
        dict[0x0014400AUL] =  "CSAmplifierType";
        dict[0x0014400CUL] =  "LTReceiverNotes";
        dict[0x0014400EUL] =  "SQPreAmplifierEquipmentSequence";
        dict[0x0014400FUL] =  "LTPreAmplifierNotes";
        dict[0x00144010UL] =  "SQTransmitTransducerSequence";
        dict[0x00144011UL] =  "SQReceiveTransducerSequence";
        dict[0x00144012UL] =  "USNumberOfElements";
        dict[0x00144013UL] =  "CSElementShape";
        dict[0x00144014UL] =  "DSElementDimensionA";
        dict[0x00144015UL] =  "DSElementDimensionB";
        dict[0x00144016UL] =  "DSElementPitch";
        dict[0x00144017UL] =  "DSMeasuredBeamDimensionA";
        dict[0x00144018UL] =  "DSMeasuredBeamDimensionB";
        dict[0x00144019UL] =  "DSLocationOfMeasuredBeamDiameter";
        dict[0x0014401AUL] =  "DSNominalFrequency";
        dict[0x0014401BUL] =  "DSMeasuredCenterFrequency";
        dict[0x0014401CUL] =  "DSMeasuredBandwidth";
        dict[0x00144020UL] =  "SQPulserSettingsSequence";
        dict[0x00144022UL] =  "DSPulseWidth";
        dict[0x00144024UL] =  "DSExcitationFrequency";
        dict[0x00144026UL] =  "CSModulationType";
        dict[0x00144028UL] =  "DSDamping";
        dict[0x00144030UL] =  "SQReceiverSettingsSequence";
        dict[0x00144031UL] =  "DSAcquiredSoundpathLength";
        dict[0x00144032UL] =  "CSAcquisitionCompressionType";
        dict[0x00144033UL] =  "ISAcquisitionSampleSize";
        dict[0x00144034UL] =  "DSRectifierSmoothing";
        dict[0x00144035UL] =  "SQDACSequence";
        dict[0x00144036UL] =  "CSDACType";
        dict[0x00144038UL] =  "DSDACGainPoints";
        dict[0x0014403AUL] =  "DSDACTimePoints";
        dict[0x0014403CUL] =  "DSDACAmplitude";
        dict[0x00144040UL] =  "SQPreAmplifierSettingsSequence";
        dict[0x00144050UL] =  "SQTransmitTransducerSettingsSequence";
        dict[0x00144051UL] =  "SQReceiveTransducerSettingsSequence";
        dict[0x00144052UL] =  "DSIncidentAngle";
        dict[0x00144054UL] =  "STCouplingTechnique";
        dict[0x00144056UL] =  "STCouplingMedium";
        dict[0x00144057UL] =  "DSCouplingVelocity";
        dict[0x00144058UL] =  "DSCrystalCenterLocationX";
        dict[0x00144059UL] =  "DSCrystalCenterLocationZ";
        dict[0x0014405AUL] =  "DSSoundPathLength";
        dict[0x0014405CUL] =  "STDelayLawIdentifier";
        dict[0x00144060UL] =  "SQGateSettingsSequence";
        dict[0x00144062UL] =  "DSGateThreshold";
        dict[0x00144064UL] =  "DSVelocityOfSound";
        dict[0x00144070UL] =  "SQCalibrationSettingsSequence";
        dict[0x00144072UL] =  "STCalibrationProcedure";
        dict[0x00144074UL] =  "SHProcedureVersion";
        dict[0x00144076UL] =  "DAProcedureCreationDate";
        dict[0x00144078UL] =  "DAProcedureExpirationDate";
        dict[0x0014407AUL] =  "DAProcedureLastModifiedDate";
        dict[0x0014407CUL] =  "TMCalibrationTime";
        dict[0x0014407EUL] =  "DACalibrationDate";
        dict[0x00145002UL] =  "ISLINACEnergy";
        dict[0x00145004UL] =  "ISLINACOutput";
        dict[0x00180010UL] =  "LOContrastBolusAgent";
        dict[0x00180012UL] =  "SQContrastBolusAgentSequence";
        dict[0x00180014UL] =  "SQContrastBolusAdministrationRouteSequence";
        dict[0x00180015UL] =  "CSBodyPartExamined";
        dict[0x00180020UL] =  "CSScanningSequence";
        dict[0x00180021UL] =  "CSSequenceVariant";
        dict[0x00180022UL] =  "CSScanOptions";
        dict[0x00180023UL] =  "CSMRAcquisitionType";
        dict[0x00180024UL] =  "SHSequenceName";
        dict[0x00180025UL] =  "CSAngioFlag";
        dict[0x00180026UL] =  "SQInterventionDrugInformationSequence";
        dict[0x00180027UL] =  "TMInterventionDrugStopTime";
        dict[0x00180028UL] =  "DSInterventionDrugDose";
        dict[0x00180029UL] =  "SQInterventionDrugCodeSequence";
        dict[0x0018002AUL] =  "SQAdditionalDrugSequence";
        dict[0x00180031UL] =  "LORadiopharmaceutical";
        dict[0x00180034UL] =  "LOInterventionDrugName";
        dict[0x00180035UL] =  "TMInterventionDrugStartTime";
        dict[0x00180036UL] =  "SQInterventionSequence";
        dict[0x00180038UL] =  "CSInterventionStatus";
        dict[0x0018003AUL] =  "STInterventionDescription";
        dict[0x00180040UL] =  "ISCineRate";
        dict[0x00180042UL] =  "CSInitialCineRunState";
        dict[0x00180050UL] =  "DSSliceThickness";
        dict[0x00180060UL] =  "DSKVP";
        dict[0x00180070UL] =  "ISCountsAccumulated";
        dict[0x00180071UL] =  "CSAcquisitionTerminationCondition";
        dict[0x00180072UL] =  "DSEffectiveDuration";
        dict[0x00180073UL] =  "CSAcquisitionStartCondition";
        dict[0x00180074UL] =  "ISAcquisitionStartConditionData";
        dict[0x00180075UL] =  "ISAcquisitionTerminationConditionData";
        dict[0x00180080UL] =  "DSRepetitionTime";
        dict[0x00180081UL] =  "DSEchoTime";
        dict[0x00180082UL] =  "DSInversionTime";
        dict[0x00180083UL] =  "DSNumberOfAverages";
        dict[0x00180084UL] =  "DSImagingFrequency";
        dict[0x00180085UL] =  "SHImagedNucleus";
        dict[0x00180086UL] =  "ISEchoNumbers";
        dict[0x00180087UL] =  "DSMagneticFieldStrength";
        dict[0x00180088UL] =  "DSSpacingBetweenSlices";
        dict[0x00180089UL] =  "ISNumberOfPhaseEncodingSteps";
        dict[0x00180090UL] =  "DSDataCollectionDiameter";
        dict[0x00180091UL] =  "ISEchoTrainLength";
        dict[0x00180093UL] =  "DSPercentSampling";
        dict[0x00180094UL] =  "DSPercentPhaseFieldOfView";
        dict[0x00180095UL] =  "DSPixelBandwidth";
        dict[0x00181000UL] =  "LODeviceSerialNumber";
        dict[0x00181002UL] =  "UIDeviceUID";
        dict[0x00181003UL] =  "LODeviceID";
        dict[0x00181004UL] =  "LOPlateID";
        dict[0x00181005UL] =  "LOGeneratorID";
        dict[0x00181006UL] =  "LOGridID";
        dict[0x00181007UL] =  "LOCassetteID";
        dict[0x00181008UL] =  "LOGantryID";
        dict[0x00181010UL] =  "LOSecondaryCaptureDeviceID";
        dict[0x00181012UL] =  "DADateOfSecondaryCapture";
        dict[0x00181014UL] =  "TMTimeOfSecondaryCapture";
        dict[0x00181016UL] =  "LOSecondaryCaptureDeviceManufacturer";
        dict[0x00181018UL] =  "LOSecondaryCaptureDeviceManufacturerModelName";
        dict[0x00181019UL] =  "LOSecondaryCaptureDeviceSoftwareVersions";
        dict[0x00181020UL] =  "LOSoftwareVersions";
        dict[0x00181022UL] =  "SHVideoImageFormatAcquired";
        dict[0x00181023UL] =  "LODigitalImageFormatAcquired";
        dict[0x00181030UL] =  "LOProtocolName";
        dict[0x00181040UL] =  "LOContrastBolusRoute";
        dict[0x00181041UL] =  "DSContrastBolusVolume";
        dict[0x00181042UL] =  "TMContrastBolusStartTime";
        dict[0x00181043UL] =  "TMContrastBolusStopTime";
        dict[0x00181044UL] =  "DSContrastBolusTotalDose";
        dict[0x00181045UL] =  "ISSyringeCounts";
        dict[0x00181046UL] =  "DSContrastFlowRate";
        dict[0x00181047UL] =  "DSContrastFlowDuration";
        dict[0x00181048UL] =  "CSContrastBolusIngredient";
        dict[0x00181049UL] =  "DSContrastBolusIngredientConcentration";
        dict[0x00181050UL] =  "DSSpatialResolution";
        dict[0x00181060UL] =  "DSTriggerTime";
        dict[0x00181061UL] =  "LOTriggerSourceOrType";
        dict[0x00181062UL] =  "ISNominalInterval";
        dict[0x00181063UL] =  "DSFrameTime";
        dict[0x00181064UL] =  "LOCardiacFramingType";
        dict[0x00181065UL] =  "DSFrameTimeVector";
        dict[0x00181066UL] =  "DSFrameDelay";
        dict[0x00181067UL] =  "DSImageTriggerDelay";
        dict[0x00181068UL] =  "DSMultiplexGroupTimeOffset";
        dict[0x00181069UL] =  "DSTriggerTimeOffset";
        dict[0x0018106AUL] =  "CSSynchronizationTrigger";
        dict[0x0018106CUL] =  "USSynchronizationChannel";
        dict[0x0018106EUL] =  "ULTriggerSamplePosition";
        dict[0x00181070UL] =  "LORadiopharmaceuticalRoute";
        dict[0x00181071UL] =  "DSRadiopharmaceuticalVolume";
        dict[0x00181072UL] =  "TMRadiopharmaceuticalStartTime";
        dict[0x00181073UL] =  "TMRadiopharmaceuticalStopTime";
        dict[0x00181074UL] =  "DSRadionuclideTotalDose";
        dict[0x00181075UL] =  "DSRadionuclideHalfLife";
        dict[0x00181076UL] =  "DSRadionuclidePositronFraction";
        dict[0x00181077UL] =  "DSRadiopharmaceuticalSpecificActivity";
        dict[0x00181078UL] =  "DTRadiopharmaceuticalStartDateTime";
        dict[0x00181079UL] =  "DTRadiopharmaceuticalStopDateTime";
        dict[0x00181080UL] =  "CSBeatRejectionFlag";
        dict[0x00181081UL] =  "ISLowRRValue";
        dict[0x00181082UL] =  "ISHighRRValue";
        dict[0x00181083UL] =  "ISIntervalsAcquired";
        dict[0x00181084UL] =  "ISIntervalsRejected";
        dict[0x00181085UL] =  "LOPVCRejection";
        dict[0x00181086UL] =  "ISSkipBeats";
        dict[0x00181088UL] =  "ISHeartRate";
        dict[0x00181090UL] =  "ISCardiacNumberOfImages";
        dict[0x00181094UL] =  "ISTriggerWindow";
        dict[0x00181100UL] =  "DSReconstructionDiameter";
        dict[0x00181110UL] =  "DSDistanceSourceToDetector";
        dict[0x00181111UL] =  "DSDistanceSourceToPatient";
        dict[0x00181114UL] =  "DSEstimatedRadiographicMagnificationFactor";
        dict[0x00181120UL] =  "DSGantryDetectorTilt";
        dict[0x00181121UL] =  "DSGantryDetectorSlew";
        dict[0x00181130UL] =  "DSTableHeight";
        dict[0x00181131UL] =  "DSTableTraverse";
        dict[0x00181134UL] =  "CSTableMotion";
        dict[0x00181135UL] =  "DSTableVerticalIncrement";
        dict[0x00181136UL] =  "DSTableLateralIncrement";
        dict[0x00181137UL] =  "DSTableLongitudinalIncrement";
        dict[0x00181138UL] =  "DSTableAngle";
        dict[0x0018113AUL] =  "CSTableType";
        dict[0x00181140UL] =  "CSRotationDirection";
        dict[0x00181142UL] =  "DSRadialPosition";
        dict[0x00181143UL] =  "DSScanArc";
        dict[0x00181144UL] =  "DSAngularStep";
        dict[0x00181145UL] =  "DSCenterOfRotationOffset";
        dict[0x00181147UL] =  "CSFieldOfViewShape";
        dict[0x00181149UL] =  "ISFieldOfViewDimensions";
        dict[0x00181150UL] =  "ISExposureTime";
        dict[0x00181151UL] =  "ISXRayTubeCurrent";
        dict[0x00181152UL] =  "ISExposure";
        dict[0x00181153UL] =  "ISExposureInuAs";
        dict[0x00181154UL] =  "DSAveragePulseWidth";
        dict[0x00181155UL] =  "CSRadiationSetting";
        dict[0x00181156UL] =  "CSRectificationType";
        dict[0x0018115AUL] =  "CSRadiationMode";
        dict[0x0018115EUL] =  "DSImageAndFluoroscopyAreaDoseProduct";
        dict[0x00181160UL] =  "SHFilterType";
        dict[0x00181161UL] =  "LOTypeOfFilters";
        dict[0x00181162UL] =  "DSIntensifierSize";
        dict[0x00181164UL] =  "DSImagerPixelSpacing";
        dict[0x00181166UL] =  "CSGrid";
        dict[0x00181170UL] =  "ISGeneratorPower";
        dict[0x00181180UL] =  "SHCollimatorGridName";
        dict[0x00181181UL] =  "CSCollimatorType";
        dict[0x00181182UL] =  "ISFocalDistance";
        dict[0x00181183UL] =  "DSXFocusCenter";
        dict[0x00181184UL] =  "DSYFocusCenter";
        dict[0x00181190UL] =  "DSFocalSpots";
        dict[0x00181191UL] =  "CSAnodeTargetMaterial";
        dict[0x001811A0UL] =  "DSBodyPartThickness";
        dict[0x001811A2UL] =  "DSCompressionForce";
        dict[0x00181200UL] =  "DADateOfLastCalibration";
        dict[0x00181201UL] =  "TMTimeOfLastCalibration";
        dict[0x00181210UL] =  "SHConvolutionKernel";
        dict[0x00181242UL] =  "ISActualFrameDuration";
        dict[0x00181243UL] =  "ISCountRate";
        dict[0x00181244UL] =  "USPreferredPlaybackSequencing";
        dict[0x00181250UL] =  "SHReceiveCoilName";
        dict[0x00181251UL] =  "SHTransmitCoilName";
        dict[0x00181260UL] =  "SHPlateType";
        dict[0x00181261UL] =  "LOPhosphorType";
        dict[0x00181300UL] =  "DSScanVelocity";
        dict[0x00181301UL] =  "CSWholeBodyTechnique";
        dict[0x00181302UL] =  "ISScanLength";
        dict[0x00181310UL] =  "USAcquisitionMatrix";
        dict[0x00181312UL] =  "CSInPlanePhaseEncodingDirection";
        dict[0x00181314UL] =  "DSFlipAngle";
        dict[0x00181315UL] =  "CSVariableFlipAngleFlag";
        dict[0x00181316UL] =  "DSSAR";
        dict[0x00181318UL] =  "DSdBdt";
        dict[0x00181400UL] =  "LOAcquisitionDeviceProcessingDescription";
        dict[0x00181401UL] =  "LOAcquisitionDeviceProcessingCode";
        dict[0x00181402UL] =  "CSCassetteOrientation";
        dict[0x00181403UL] =  "CSCassetteSize";
        dict[0x00181404UL] =  "USExposuresOnPlate";
        dict[0x00181405UL] =  "ISRelativeXRayExposure";
        dict[0x00181411UL] =  "DSExposureIndex";
        dict[0x00181412UL] =  "DSTargetExposureIndex";
        dict[0x00181413UL] =  "DSDeviationIndex";
        dict[0x00181450UL] =  "DSColumnAngulation";
        dict[0x00181460UL] =  "DSTomoLayerHeight";
        dict[0x00181470UL] =  "DSTomoAngle";
        dict[0x00181480UL] =  "DSTomoTime";
        dict[0x00181490UL] =  "CSTomoType";
        dict[0x00181491UL] =  "CSTomoClass";
        dict[0x00181495UL] =  "ISNumberOfTomosynthesisSourceImages";
        dict[0x00181500UL] =  "CSPositionerMotion";
        dict[0x00181508UL] =  "CSPositionerType";
        dict[0x00181510UL] =  "DSPositionerPrimaryAngle";
        dict[0x00181511UL] =  "DSPositionerSecondaryAngle";
        dict[0x00181520UL] =  "DSPositionerPrimaryAngleIncrement";
        dict[0x00181521UL] =  "DSPositionerSecondaryAngleIncrement";
        dict[0x00181530UL] =  "DSDetectorPrimaryAngle";
        dict[0x00181531UL] =  "DSDetectorSecondaryAngle";
        dict[0x00181600UL] =  "CSShutterShape";
        dict[0x00181602UL] =  "ISShutterLeftVerticalEdge";
        dict[0x00181604UL] =  "ISShutterRightVerticalEdge";
        dict[0x00181606UL] =  "ISShutterUpperHorizontalEdge";
        dict[0x00181608UL] =  "ISShutterLowerHorizontalEdge";
        dict[0x00181610UL] =  "ISCenterOfCircularShutter";
        dict[0x00181612UL] =  "ISRadiusOfCircularShutter";
        dict[0x00181620UL] =  "ISVerticesOfThePolygonalShutter";
        dict[0x00181622UL] =  "USShutterPresentationValue";
        dict[0x00181623UL] =  "USShutterOverlayGroup";
        dict[0x00181624UL] =  "USShutterPresentationColorCIELabValue";
        dict[0x00181700UL] =  "CSCollimatorShape";
        dict[0x00181702UL] =  "ISCollimatorLeftVerticalEdge";
        dict[0x00181704UL] =  "ISCollimatorRightVerticalEdge";
        dict[0x00181706UL] =  "ISCollimatorUpperHorizontalEdge";
        dict[0x00181708UL] =  "ISCollimatorLowerHorizontalEdge";
        dict[0x00181710UL] =  "ISCenterOfCircularCollimator";
        dict[0x00181712UL] =  "ISRadiusOfCircularCollimator";
        dict[0x00181720UL] =  "ISVerticesOfThePolygonalCollimator";
        dict[0x00181800UL] =  "CSAcquisitionTimeSynchronized";
        dict[0x00181801UL] =  "SHTimeSource";
        dict[0x00181802UL] =  "CSTimeDistributionProtocol";
        dict[0x00181803UL] =  "LONTPSourceAddress";
        dict[0x00182001UL] =  "ISPageNumberVector";
        dict[0x00182002UL] =  "SHFrameLabelVector";
        dict[0x00182003UL] =  "DSFramePrimaryAngleVector";
        dict[0x00182004UL] =  "DSFrameSecondaryAngleVector";
        dict[0x00182005UL] =  "DSSliceLocationVector";
        dict[0x00182006UL] =  "SHDisplayWindowLabelVector";
        dict[0x00182010UL] =  "DSNominalScannedPixelSpacing";
        dict[0x00182020UL] =  "CSDigitizingDeviceTransportDirection";
        dict[0x00182030UL] =  "DSRotationOfScannedFilm";
        dict[0x00183100UL] =  "CSIVUSAcquisition";
        dict[0x00183101UL] =  "DSIVUSPullbackRate";
        dict[0x00183102UL] =  "DSIVUSGatedRate";
        dict[0x00183103UL] =  "ISIVUSPullbackStartFrameNumber";
        dict[0x00183104UL] =  "ISIVUSPullbackStopFrameNumber";
        dict[0x00183105UL] =  "ISLesionNumber";
        dict[0x00185000UL] =  "SHOutputPower";
        dict[0x00185010UL] =  "LOTransducerData";
        dict[0x00185012UL] =  "DSFocusDepth";
        dict[0x00185020UL] =  "LOProcessingFunction";
        dict[0x00185022UL] =  "DSMechanicalIndex";
        dict[0x00185024UL] =  "DSBoneThermalIndex";
        dict[0x00185026UL] =  "DSCranialThermalIndex";
        dict[0x00185027UL] =  "DSSoftTissueThermalIndex";
        dict[0x00185028UL] =  "DSSoftTissueFocusThermalIndex";
        dict[0x00185029UL] =  "DSSoftTissueSurfaceThermalIndex";
        dict[0x00185050UL] =  "ISDepthOfScanField";
        dict[0x00185100UL] =  "CSPatientPosition";
        dict[0x00185101UL] =  "CSViewPosition";
        dict[0x00185104UL] =  "SQProjectionEponymousNameCodeSequence";
        dict[0x00186000UL] =  "DSSensitivity";
        dict[0x00186011UL] =  "SQSequenceOfUltrasoundRegions";
        dict[0x00186012UL] =  "USRegionSpatialFormat";
        dict[0x00186014UL] =  "USRegionDataType";
        dict[0x00186016UL] =  "ULRegionFlags";
        dict[0x00186018UL] =  "ULRegionLocationMinX0";
        dict[0x0018601AUL] =  "ULRegionLocationMinY0";
        dict[0x0018601CUL] =  "ULRegionLocationMaxX1";
        dict[0x0018601EUL] =  "ULRegionLocationMaxY1";
        dict[0x00186020UL] =  "SLReferencePixelX0";
        dict[0x00186022UL] =  "SLReferencePixelY0";
        dict[0x00186024UL] =  "USPhysicalUnitsXDirection";
        dict[0x00186026UL] =  "USPhysicalUnitsYDirection";
        dict[0x00186028UL] =  "FDReferencePixelPhysicalValuX";
        dict[0x0018602AUL] =  "FDReferencePixelPhysicalValuY";
        dict[0x0018602CUL] =  "FDPhysicalDeltaX";
        dict[0x0018602EUL] =  "FDPhysicalDeltaY";
        dict[0x00186030UL] =  "ULTransducerFrequency";
        dict[0x00186031UL] =  "CSTransducerType";
        dict[0x00186032UL] =  "ULPulseRepetitionFrequency";
        dict[0x00186034UL] =  "FDDopplerCorrectionAngle";
        dict[0x00186036UL] =  "FDteeringAngle";
        dict[0x00186039UL] =  "SLDopplerSampleVolumeXPosiion";
        dict[0x0018603BUL] =  "SLDopplerSampleVolumeYPosiion";
        dict[0x0018603DUL] =  "SLTMLinePositionX0";
        dict[0x0018603FUL] =  "SLTMLinePositionY0";
        dict[0x00186041UL] =  "SLTMLinePositionX1";
        dict[0x00186043UL] =  "SLTMLinePositionY1";
        dict[0x00186044UL] =  "USPixelComponentOrganization";
        dict[0x00186046UL] =  "ULPixelComponentMask";
        dict[0x00186048UL] =  "ULPixelComponentRangeStart";
        dict[0x0018604AUL] =  "ULPixelComponentRangeStop";
        dict[0x0018604CUL] =  "USPixelComponentPhysicalUnits";
        dict[0x0018604EUL] =  "USPixelComponentDataType";
        dict[0x00186050UL] =  "ULNumberOfTableBreakPoints";
        dict[0x00186052UL] =  "ULTableOfXBreakPoints";
        dict[0x00186054UL] =  "FDTableOfYBreakPoints";
        dict[0x00186056UL] =  "ULNumberOfTableEntries";
        dict[0x00186058UL] =  "ULTableOfPixelValues";
        dict[0x0018605AUL] =  "FLTableOfParameterValues";
        dict[0x00186060UL] =  "FLRWaveTimeVector";
        dict[0x00187000UL] =  "CSDetectorConditionsNominalFlag";
        dict[0x00187001UL] =  "DSDetectorTemperature";
        dict[0x00187004UL] =  "CSDetectorType";
        dict[0x00187005UL] =  "CSDetectorConfiguration";
        dict[0x00187006UL] =  "LTDetectorDescription";
        dict[0x00187008UL] =  "LTDetectorMode";
        dict[0x0018700AUL] =  "SHDetectorID";
        dict[0x0018700CUL] =  "DADateOfLastDetectorCalibration";
        dict[0x0018700EUL] =  "TMTimeOfLastDetectorCalibration";
        dict[0x00187010UL] =  "ISExposuresOnDetectorSinceLastCalibration";
        dict[0x00187011UL] =  "ISExposuresOnDetectorSinceManufactured";
        dict[0x00187012UL] =  "DSDetectorTimeSinceLastExposure";
        dict[0x00187014UL] =  "DSDetectorActiveTime";
        dict[0x00187016UL] =  "DSDetectorActivationOffsetFromExposure";
        dict[0x0018701AUL] =  "DSDetectorBinning";
        dict[0x00187020UL] =  "DSDetectorElementPhysicalSize";
        dict[0x00187022UL] =  "DSDetectorElementSpacing";
        dict[0x00187024UL] =  "CSDetectorActiveShape";
        dict[0x00187026UL] =  "DSDetectorActiveDimensions";
        dict[0x00187028UL] =  "DSDetectorActiveOrigin";
        dict[0x0018702AUL] =  "LODetectorManufacturerName";
        dict[0x0018702BUL] =  "LODetectorManufacturerModelName";
        dict[0x00187030UL] =  "DSFieldOfViewOrigin";
        dict[0x00187032UL] =  "DSFieldOfViewRotation";
        dict[0x00187034UL] =  "CSFieldOfViewHorizontalFlip";
        dict[0x00187036UL] =  "FLPixelDataAreaOriginRelativeToFOV";
        dict[0x00187038UL] =  "FLPixelDataAreaRotationAngleRelativeToFOV";
        dict[0x00187040UL] =  "LTGridAbsorbingMaterial";
        dict[0x00187041UL] =  "LTGridSpacingMaterial";
        dict[0x00187042UL] =  "DSGridThickness";
        dict[0x00187044UL] =  "DSGridPitch";
        dict[0x00187046UL] =  "ISGridAspectRatio";
        dict[0x00187048UL] =  "DSGridPeriod";
        dict[0x0018704CUL] =  "DSGridFocalDistance";
        dict[0x00187050UL] =  "CSFilterMaterial";
        dict[0x00187052UL] =  "DSFilterThicknessMinimum";
        dict[0x00187054UL] =  "DSFilterThicknessMaximum";
        dict[0x00187056UL] =  "FLFilterBeamPathLengthMinimum";
        dict[0x00187058UL] =  "FLFilterBeamPathLengthMaximum";
        dict[0x00187060UL] =  "CSExposureControlMode";
        dict[0x00187062UL] =  "LTExposureControlModeDescription";
        dict[0x00187064UL] =  "CSExposureStatus";
        dict[0x00187065UL] =  "DSPhototimerSetting";
        dict[0x00188150UL] =  "DSExposureTimeInuS";
        dict[0x00188151UL] =  "DSXRayTubeCurrentInuA";
        dict[0x00189004UL] =  "CSContentQualification";
        dict[0x00189005UL] =  "SHPulseSequenceName";
        dict[0x00189006UL] =  "SQMRImagingModifierSequence";
        dict[0x00189008UL] =  "CSEchoPulseSequence";
        dict[0x00189009UL] =  "CSInversionRecovery";
        dict[0x00189010UL] =  "CSFlowCompensation";
        dict[0x00189011UL] =  "CSMultipleSpinEcho";
        dict[0x00189012UL] =  "CSMultiPlanarExcitation";
        dict[0x00189014UL] =  "CSPhaseContrast";
        dict[0x00189015UL] =  "CSTimeOfFlightContrast";
        dict[0x00189016UL] =  "CSSpoiling";
        dict[0x00189017UL] =  "CSSteadyStatePulseSequence";
        dict[0x00189018UL] =  "CSEchoPlanarPulseSequence";
        dict[0x00189019UL] =  "FDTagAngleFirstAxis";
        dict[0x00189020UL] =  "CSMagnetizationTransfer";
        dict[0x00189021UL] =  "CST2Preparation";
        dict[0x00189022UL] =  "CSBloodSignalNulling";
        dict[0x00189024UL] =  "CSSaturationRecovery";
        dict[0x00189025UL] =  "CSSpectrallySelectedSuppression";
        dict[0x00189026UL] =  "CSSpectrallySelectedExcitation";
        dict[0x00189027UL] =  "CSSpatialPresaturation";
        dict[0x00189028UL] =  "CSTagging";
        dict[0x00189029UL] =  "CSOversamplingPhase";
        dict[0x00189030UL] =  "FDTagSpacingFirstDimension";
        dict[0x00189032UL] =  "CSGeometryOfKSpaceTraversal";
        dict[0x00189033UL] =  "CSSegmentedKSpaceTraversal";
        dict[0x00189034UL] =  "CSRectilinearPhaseEncodeReordering";
        dict[0x00189035UL] =  "FDTagThickness";
        dict[0x00189036UL] =  "CSPartialFourierDirection";
        dict[0x00189037UL] =  "CSCardiacSynchronizationTechnique";
        dict[0x00189041UL] =  "LOReceiveCoilManufacturerName";
        dict[0x00189042UL] =  "SQMRReceiveCoilSequence";
        dict[0x00189043UL] =  "CSReceiveCoilType";
        dict[0x00189044UL] =  "CSQuadratureReceiveCoil";
        dict[0x00189045UL] =  "SQMultiCoilDefinitionSequence";
        dict[0x00189046UL] =  "LOMultiCoilConfiguration";
        dict[0x00189047UL] =  "SHMultiCoilElementName";
        dict[0x00189048UL] =  "CSMultiCoilElementUsed";
        dict[0x00189049UL] =  "SQMRTransmitCoilSequence";
        dict[0x00189050UL] =  "LOTransmitCoilManufacturerName";
        dict[0x00189051UL] =  "CSTransmitCoilType";
        dict[0x00189052UL] =  "FDSpectralWidth";
        dict[0x00189053UL] =  "FDChemicalShiftReference";
        dict[0x00189054UL] =  "CSVolumeLocalizationTechnique";
        dict[0x00189058UL] =  "USMRAcquisitionFrequencyEncodingSteps";
        dict[0x00189059UL] =  "CSDecoupling";
        dict[0x00189060UL] =  "CSDecoupledNucleus";
        dict[0x00189061UL] =  "FDDecouplingFrequency";
        dict[0x00189062UL] =  "CSDecouplingMethod";
        dict[0x00189063UL] =  "FDDecouplingChemicalShiftReference";
        dict[0x00189064UL] =  "CSKSpaceFiltering";
        dict[0x00189065UL] =  "CSTimeDomainFiltering";
        dict[0x00189066UL] =  "USNumberOfZeroFills";
        dict[0x00189067UL] =  "CSBaselineCorrection";
        dict[0x00189069UL] =  "FDParallelReductionFactorInPlane";
        dict[0x00189070UL] =  "FDCardiacRRIntervalSpecified";
        dict[0x00189073UL] =  "FDAcquisitionDuration";
        dict[0x00189074UL] =  "DTFrameAcquisitionDateTime";
        dict[0x00189075UL] =  "CSDiffusionDirectionality";
        dict[0x00189076UL] =  "SQDiffusionGradientDirectionSequence";
        dict[0x00189077UL] =  "CSParallelAcquisition";
        dict[0x00189078UL] =  "CSParallelAcquisitionTechnique";
        dict[0x00189079UL] =  "FDInversionTimes";
        dict[0x00189080UL] =  "STMetaboliteMapDescription";
        dict[0x00189081UL] =  "CSPartialFourier";
        dict[0x00189082UL] =  "FDEffectiveEchoTime";
        dict[0x00189083UL] =  "SQMetaboliteMapCodeSequence";
        dict[0x00189084UL] =  "SQChemicalShiftSequence";
        dict[0x00189085UL] =  "CSCardiacSignalSource";
        dict[0x00189087UL] =  "FDDiffusionBValue";
        dict[0x00189089UL] =  "FDDiffusionGradientOrientation";
        dict[0x00189090UL] =  "FDVelocityEncodingDirection";
        dict[0x00189091UL] =  "FDVelocityEncodingMinimumValue";
        dict[0x00189092UL] =  "SQVelocityEncodingAcquisitionSequence";
        dict[0x00189093UL] =  "USNumberOfKSpaceTrajectories";
        dict[0x00189094UL] =  "CSCoverageOfKSpace";
        dict[0x00189095UL] =  "ULSpectroscopyAcquisitionPhaseRows";
        dict[0x00189098UL] =  "FDTransmitterFrequency";
        dict[0x00189100UL] =  "CSResonantNucleus";
        dict[0x00189101UL] =  "CSFrequencyCorrection";
        dict[0x00189103UL] =  "SQMRSpectroscopyFOVGeometrySequence";
        dict[0x00189104UL] =  "FDSlabThickness";
        dict[0x00189105UL] =  "FDSlabOrientation";
        dict[0x00189106UL] =  "FDMidSlabPosition";
        dict[0x00189107UL] =  "SQMRSpatialSaturationSequence";
        dict[0x00189112UL] =  "SQMRTimingAndRelatedParametersSequence";
        dict[0x00189114UL] =  "SQMREchoSequence";
        dict[0x00189115UL] =  "SQMRModifierSequence";
        dict[0x00189117UL] =  "SQMRDiffusionSequence";
        dict[0x00189118UL] =  "SQCardiacSynchronizationSequence";
        dict[0x00189119UL] =  "SQMRAveragesSequence";
        dict[0x00189125UL] =  "SQMRFOVGeometrySequence";
        dict[0x00189126UL] =  "SQVolumeLocalizationSequence";
        dict[0x00189127UL] =  "ULSpectroscopyAcquisitionDataColumns";
        dict[0x00189147UL] =  "CSDiffusionAnisotropyType";
        dict[0x00189151UL] =  "DTFrameReferenceDateTime";
        dict[0x00189152UL] =  "SQMRMetaboliteMapSequence";
        dict[0x00189155UL] =  "FDParallelReductionFactorOutOfPlane";
        dict[0x00189159UL] =  "ULSpectroscopyAcquisitionOutOfPlanePhaseSteps";
        dict[0x00189168UL] =  "FDarallelReductionFactorSecndInPlane";
        dict[0x00189169UL] =  "CSCardiacBeatRejectionTechnique";
        dict[0x00189170UL] =  "CSRespiratoryMotionCompensationTechnique";
        dict[0x00189171UL] =  "CSRespiratorySignalSource";
        dict[0x00189172UL] =  "CSBulkMotionCompensationTechnique";
        dict[0x00189173UL] =  "CSBulkMotionSignalSource";
        dict[0x00189178UL] =  "CSOperatingMode";
        dict[0x00189179UL] =  "CSSpecificAbsorptionRateDefinition";
        dict[0x00189180UL] =  "CSGradientOutputType";
        dict[0x00189181UL] =  "FDSpecificAbsorptionRateValue";
        dict[0x00189182UL] =  "FDGradientOutput";
        dict[0x00189183UL] =  "CSFlowCompensationDirection";
        dict[0x00189184UL] =  "FDTaggingDelay";
        dict[0x00189185UL] =  "STRespiratoryMotionCompensationTechniqueDescription";
        dict[0x00189186UL] =  "SHRespiratorySignalSourceIDationLimitInHzrationLimitInHz";
        dict[0x00189197UL] =  "SQMRVelocityEncodingSequence";
        dict[0x00189198UL] =  "CSFirstOrderPhaseCorrection";
        dict[0x00189199UL] =  "CSWaterReferencedPhaseCorrection";
        dict[0x00189200UL] =  "CSMRSpectroscopyAcquisitionType";
        dict[0x00189214UL] =  "CSRespiratoryCyclePosition";
        dict[0x00189217UL] =  "FDVelocityEncodingMaximumValue";
        dict[0x00189218UL] =  "FDTagSpacingSecondDimension";
        dict[0x00189219UL] =  "SSTagAngleSecondAxis";
        dict[0x00189220UL] =  "FDFrameAcquisitionDuration";
        dict[0x00189226UL] =  "SQMRImageFrameTypeSequence";
        dict[0x00189227UL] =  "SQMRSpectroscopyFrameTypeSequence";
        dict[0x00189231UL] =  "USMRAcquisitionPhaseEncodingStepsInPlane";
        dict[0x00189232UL] =  "USMRAcquisitionPhaseEncodingStepsOutOfPlane";
        dict[0x00189234UL] =  "ULSpectroscopyAcquisitionPhaseColumns";
        dict[0x00189236UL] =  "CSCardiacCyclePosition";
        dict[0x00189239UL] =  "SQSpecificAbsorptionRateSequence";
        dict[0x00189240UL] =  "USRFEchoTrainLength";
        dict[0x00189241UL] =  "USGradientEchoTrainLength";
        dict[0x00189250UL] =  "CSArterialSpinLabelingContrast";
        dict[0x00189251UL] =  "SQMRArterialSpinLabelingSequence";
        dict[0x00189252UL] =  "LOASLTechniqueDescription";
        dict[0x00189253UL] =  "USASLSlabNumber";
        dict[0x00189254UL] =  "FDASLSlabThickness";
        dict[0x00189255UL] =  "FDASLSlabOrientation";
        dict[0x00189256UL] =  "FDASLMidSlabPosition";
        dict[0x00189257UL] =  "CSASLContext";
        dict[0x00189258UL] =  "ULASLPulseTrainDuration";
        dict[0x00189259UL] =  "CSASLCrusherFlag";
        dict[0x0018925AUL] =  "FDASLCrusherFlow";
        dict[0x0018925BUL] =  "LOASLCrusherDescription";
        dict[0x0018925CUL] =  "CSASLBolusCutoffFlag";
        dict[0x0018925DUL] =  "SQASLBolusCutoffTimingSequence";
        dict[0x0018925EUL] =  "LOASLBolusCutoffTechnique";
        dict[0x0018925FUL] =  "ULASLBolusCutoffDelayTime";
        dict[0x00189260UL] =  "SQASLSlabSequence";
        dict[0x00189295UL] =  "FDChemicalShiftMinimumIntegrationLimitInppm";
        dict[0x00189296UL] =  "FDChemicalShiftMaximumIntegrationLimitInppm";
        dict[0x00189301UL] =  "SQCTAcquisitionTypeSequence";
        dict[0x00189302UL] =  "CSAcquisitionType";
        dict[0x00189303UL] =  "FDTubeAngle";
        dict[0x00189304UL] =  "SQCTAcquisitionDetailsSequence";
        dict[0x00189305UL] =  "FDRevolutionTime";
        dict[0x00189306UL] =  "FDSingleCollimationWidth";
        dict[0x00189307UL] =  "FDTotalCollimationWidth";
        dict[0x00189308UL] =  "SQCTTableDynamicsSequence";
        dict[0x00189309UL] =  "FDTableSpeed";
        dict[0x00189310UL] =  "FDTableFeedPerRotation";
        dict[0x00189311UL] =  "FDSpiralPitchFactor";
        dict[0x00189312UL] =  "SQCTGeometrySequence";
        dict[0x00189313UL] =  "FDDataCollectionCenterPatient";
        dict[0x00189314UL] =  "SQCTReconstructionSequence";
        dict[0x00189315UL] =  "CSReconstructionAlgorithm";
        dict[0x00189316UL] =  "CSConvolutionKernelGroup";
        dict[0x00189317UL] =  "FDReconstructionFieldOfView";
        dict[0x00189318UL] =  "FDReconstructionTargetCenterPatient";
        dict[0x00189319UL] =  "FDReconstructionAngle";
        dict[0x00189320UL] =  "SHImageFilter";
        dict[0x00189321UL] =  "SQCTExposureSequence";
        dict[0x00189322UL] =  "FDReconstructionPixelSpacing";
        dict[0x00189323UL] =  "CSExposureModulationType";
        dict[0x00189324UL] =  "FDEstimatedDoseSaving";
        dict[0x00189325UL] =  "SQCTXRayDetailsSequence";
        dict[0x00189326UL] =  "SQCTPositionSequence";
        dict[0x00189327UL] =  "FDTablePosition";
        dict[0x00189328UL] =  "FDExposureTimeInms";
        dict[0x00189329UL] =  "SQCTImageFrameTypeSequence";
        dict[0x00189330UL] =  "FDXRayTubeCurrentInmA";
        dict[0x00189332UL] =  "FDExposureInmAs";
        dict[0x00189333UL] =  "CSConstantVolumeFlag";
        dict[0x00189334UL] =  "CSFluoroscopyFlag";
        dict[0x00189335UL] =  "FDDistanceSourceToDataCollectionCenter";
        dict[0x00189337UL] =  "USContrastBolusAgentNumber";
        dict[0x00189338UL] =  "SQContrastBolusIngredientCodeSequence";
        dict[0x00189340UL] =  "SQContrastAdministrationProfileSequence";
        dict[0x00189341UL] =  "SQContrastBolusUsageSequence";
        dict[0x00189342UL] =  "CSContrastBolusAgentAdministered";
        dict[0x00189343UL] =  "CSContrastBolusAgentDetected";
        dict[0x00189344UL] =  "CSContrastBolusAgentPhase";
        dict[0x00189345UL] =  "FDCTDIvol";
        dict[0x00189346UL] =  "SQCTDIPhantomTypeCodeSequence";
        dict[0x00189351UL] =  "FLCalciumScoringMassFactorPatient";
        dict[0x00189352UL] =  "FLCalciumScoringMassFactorDevice";
        dict[0x00189353UL] =  "FLEnergyWeightingFactor";
        dict[0x00189360UL] =  "SQCTAdditionalXRaySourceSequence";
        dict[0x00189401UL] =  "SQProjectionPixelCalibrationSequence";
        dict[0x00189402UL] =  "FLDistanceSourceToIsocenter";
        dict[0x00189403UL] =  "FLDistanceObjectToTableTop";
        dict[0x00189404UL] =  "FLObjectPixelSpacingInCenterOfBeam";
        dict[0x00189405UL] =  "SQPositionerPositionSequence";
        dict[0x00189406UL] =  "SQTablePositionSequence";
        dict[0x00189407UL] =  "SQCollimatorShapeSequence";
        dict[0x00189410UL] =  "CSPlanesInAcquisition";
        dict[0x00189412UL] =  "SQXAXRFFrameCharacteristicsSequence";
        dict[0x00189417UL] =  "SQFrameAcquisitionSequence";
        dict[0x00189420UL] =  "CSXRayReceptorType";
        dict[0x00189423UL] =  "LOAcquisitionProtocolName";
        dict[0x00189424UL] =  "LTAcquisitionProtocolDescription";
        dict[0x00189425UL] =  "CSContrastBolusIngredientOpaque";
        dict[0x00189426UL] =  "FLDistanceReceptorPlaneToDetectorHousing";
        dict[0x00189427UL] =  "CSIntensifierActiveShape";
        dict[0x00189428UL] =  "FLIntensifierActiveDimensions";
        dict[0x00189429UL] =  "FLPhysicalDetectorSize";
        dict[0x00189430UL] =  "FLPositionOfIsocenterProjection";
        dict[0x00189432UL] =  "SQFieldOfViewSequence";
        dict[0x00189433UL] =  "LOFieldOfViewDescription";
        dict[0x00189434UL] =  "SQExposureControlSensingRegionsSequence";
        dict[0x00189435UL] =  "CSExposureControlSensingRegionShape";
        dict[0x00189436UL] =  "SSExposureControlSensingRegionLeftVerticalEdge";
        dict[0x00189437UL] =  "SSExposureControlSensingRegionRightVerticalEdge";
        dict[0x00189438UL] =  "SSExposureControlSensingRegionUpperHorizontalEdge";
        dict[0x00189439UL] =  "SSExposureControlSensingRegionLowerHorizontalEdge";
        dict[0x00189440UL] =  "SSCenterOfCircularExposureControlSensingRegion";
        dict[0x00189441UL] =  "USRadiusOfCircularExposureControlSensingRegion";
        dict[0x00189442UL] =  "SSVerticesOfThePolygonalExposureControlSensingRegion";
        dict[0x00189447UL] =  "FLColumnAngulationPatient";
        dict[0x00189449UL] =  "FLBeamAngle";
        dict[0x00189451UL] =  "SQFrameDetectorParametersSequence";
        dict[0x00189452UL] =  "FLCalculatedAnatomyThickness";
        dict[0x00189455UL] =  "SQCalibrationSequence";
        dict[0x00189456UL] =  "SQObjectThicknessSequence";
        dict[0x00189457UL] =  "CSPlaneIdentification";
        dict[0x00189461UL] =  "FLFieldOfViewDimensionsInFloat";
        dict[0x00189462UL] =  "SQIsocenterReferenceSystemSequence";
        dict[0x00189463UL] =  "FLPositionerIsocenterPrimaryAngle";
        dict[0x00189464UL] =  "FLPositionerIsocenterSecondaryAngle";
        dict[0x00189465UL] =  "FLPositionerIsocenterDetectorRotationAngle";
        dict[0x00189466UL] =  "FLTableXPositionToIsocenter";
        dict[0x00189467UL] =  "FLTableYPositionToIsocenter";
        dict[0x00189468UL] =  "FLTableZPositionToIsocenter";
        dict[0x00189469UL] =  "FLTableHorizontalRotationAngle";
        dict[0x00189470UL] =  "FLTableHeadTiltAngle";
        dict[0x00189471UL] =  "FLTableCradleTiltAngle";
        dict[0x00189472UL] =  "SQFrameDisplayShutterSequence";
        dict[0x00189473UL] =  "FLAcquiredImageAreaDoseProduct";
        dict[0x00189474UL] =  "CSCArmPositionerTabletopRelationship";
        dict[0x00189476UL] =  "SQXRayGeometrySequence";
        dict[0x00189477UL] =  "SQIrradiationEventIdentificationSequence";
        dict[0x00189504UL] =  "SQXRay3DFrameTypeSequence";
        dict[0x00189506UL] =  "SQContributingSourcesSequence";
        dict[0x00189507UL] =  "SQXRay3DAcquisitionSequence";
        dict[0x00189508UL] =  "FLPrimaryPositionerScanArc";
        dict[0x00189509UL] =  "FLSecondaryPositionerScanArc";
        dict[0x00189510UL] =  "FLPrimaryPositionerScanStartAngle";
        dict[0x00189511UL] =  "FLSecondaryPositionerScanStartAngle";
        dict[0x00189514UL] =  "FLPrimaryPositionerIncrement";
        dict[0x00189515UL] =  "FLSecondaryPositionerIncrement";
        dict[0x00189516UL] =  "DTStartAcquisitionDateTime";
        dict[0x00189517UL] =  "DTEndAcquisitionDateTime";
        dict[0x00189524UL] =  "LOApplicationName";
        dict[0x00189525UL] =  "LOApplicationVersion";
        dict[0x00189526UL] =  "LOApplicationManufacturer";
        dict[0x00189527UL] =  "CSAlgorithmType";
        dict[0x00189528UL] =  "LOAlgorithmDescription";
        dict[0x00189530UL] =  "SQXRay3DReconstructionSequence";
        dict[0x00189531UL] =  "LOReconstructionDescription";
        dict[0x00189538UL] =  "SQPerProjectionAcquisitionSequence";
        dict[0x00189601UL] =  "SQDiffusionBMatrixSequence";
        dict[0x00189602UL] =  "FDDiffusionBValueXX";
        dict[0x00189603UL] =  "FDDiffusionBValueXY";
        dict[0x00189604UL] =  "FDDiffusionBValueXZ";
        dict[0x00189605UL] =  "FDDiffusionBValueYY";
        dict[0x00189606UL] =  "FDDiffusionBValueYZ";
        dict[0x00189607UL] =  "FDDiffusionBValueZZ";
        dict[0x00189701UL] =  "DTDecayCorrectionDateTime";
        dict[0x00189715UL] =  "FDStartDensityThreshold";
        dict[0x00189716UL] =  "FDStartRelativeDensityDifferenceThreshold";
        dict[0x00189717UL] =  "FDStartCardiacTriggerCountThreshold";
        dict[0x00189718UL] =  "FDStartRespiratoryTriggerCountThreshold";
        dict[0x00189719UL] =  "FDTerminationCountsThreshold";
        dict[0x00189720UL] =  "FDTerminationDensityThreshold";
        dict[0x00189721UL] =  "FDTerminationRelativeDensityThreshold";
        dict[0x00189722UL] =  "FDTerminationTimeThreshold";
        dict[0x00189723UL] =  "FDTerminationCardiacTriggerCountThreshold";
        dict[0x00189724UL] =  "FDTerminationRespiratoryTriggerCountThreshold";
        dict[0x00189725UL] =  "CSDetectorGeometry";
        dict[0x00189726UL] =  "FDTransverseDetectorSeparation";
        dict[0x00189727UL] =  "FDAxialDetectorDimension";
        dict[0x00189729UL] =  "USRadiopharmaceuticalAgentNumber";
        dict[0x00189732UL] =  "SQPETFrameAcquisitionSequence";
        dict[0x00189733UL] =  "SQPETDetectorMotionDetailsSequence";
        dict[0x00189734UL] =  "SQPETTableDynamicsSequence";
        dict[0x00189735UL] =  "SQPETPositionSequence";
        dict[0x00189736UL] =  "SQPETFrameCorrectionFactorsSequence";
        dict[0x00189737UL] =  "SQRadiopharmaceuticalUsageSequence";
        dict[0x00189738UL] =  "CSAttenuationCorrectionSource";
        dict[0x00189739UL] =  "USNumberOfIterations";
        dict[0x00189740UL] =  "USNumberOfSubsets";
        dict[0x00189749UL] =  "SQPETReconstructionSequence";
        dict[0x00189751UL] =  "SQPETFrameTypeSequence";
        dict[0x00189755UL] =  "CSTimeOfFlightInformationUsed";
        dict[0x00189756UL] =  "CSReconstructionType";
        dict[0x00189758UL] =  "CSDecayCorrected";
        dict[0x00189759UL] =  "CSAttenuationCorrected";
        dict[0x00189760UL] =  "CSScatterCorrected";
        dict[0x00189761UL] =  "CSDeadTimeCorrected";
        dict[0x00189762UL] =  "CSGantryMotionCorrected";
        dict[0x00189763UL] =  "CSPatientMotionCorrected";
        dict[0x00189764UL] =  "CSCountLossNormalizationCorrected";
        dict[0x00189765UL] =  "CSRandomsCorrected";
        dict[0x00189766UL] =  "CSNonUniformRadialSamplingCorrected";
        dict[0x00189767UL] =  "CSSensitivityCalibrated";
        dict[0x00189768UL] =  "CSDetectorNormalizationCorrection";
        dict[0x00189769UL] =  "CSIterativeReconstructionMethod";
        dict[0x00189770UL] =  "CSAttenuationCorrectionTemporalRelationship";
        dict[0x00189771UL] =  "SQPatientPhysiologicalStateSequence";
        dict[0x00189772UL] =  "SQPatientPhysiologicalStateCodeSequence";
        dict[0x00189801UL] =  "FDDepthsOfFocus";
        dict[0x00189803UL] =  "SQExcludedIntervalsSequence";
        dict[0x00189804UL] =  "DTExclusionStartDatetime";
        dict[0x00189805UL] =  "FDExclusionDuration";
        dict[0x00189806UL] =  "SQUSImageDescriptionSequence";
        dict[0x00189807UL] =  "SQImageDataTypeSequence";
        dict[0x00189808UL] =  "CSDataType";
        dict[0x00189809UL] =  "SQTransducerScanPatternCodeSequence";
        dict[0x0018980BUL] =  "CSAliasedDataType";
        dict[0x0018980CUL] =  "CSPositionMeasuringDeviceUsed";
        dict[0x0018980DUL] =  "SQTransducerGeometryCodeSequence";
        dict[0x0018980EUL] =  "SQTransducerBeamSteeringCodeSequence";
        dict[0x0018980FUL] =  "SQTransducerApplicationCodeSequence";
        dict[0x0018A001UL] =  "SQContributingEquipmentSequence";
        dict[0x0018A002UL] =  "DTContributionDateTime";
        dict[0x0018A003UL] =  "STContributionDescription";
        dict[0x0020000DUL] =  "UIStudyInstanceUID";
        dict[0x0020000EUL] =  "UISeriesInstanceUID";
        dict[0x00200010UL] =  "SHStudyID";
        dict[0x00200011UL] =  "ISSeriesNumber";
        dict[0x00200012UL] =  "ISAcquisitionNumber";
        dict[0x00200013UL] =  "ISInstanceNumber";
        dict[0x00200019UL] =  "ISItemNumber";
        dict[0x00200020UL] =  "CSPatientOrientation";
        dict[0x00200032UL] =  "DSImagePositionPatient";
        dict[0x00200037UL] =  "DSImageOrientationPatient";
        dict[0x00200052UL] =  "UIFrameOfReferenceUID";
        dict[0x00200060UL] =  "CSLaterality";
        dict[0x00200062UL] =  "CSImageLaterality";
        dict[0x00200100UL] =  "ISTemporalPositionIdentifier";
        dict[0x00200105UL] =  "ISNumberOfTemporalPositions";
        dict[0x00200110UL] =  "DSTemporalResolution";
        dict[0x00200200UL] =  "UISynchronizationFrameOfReferenceUID";
        dict[0x00200242UL] =  "UISOPInstanceUIDOfConcatenationSource";
        dict[0x00201002UL] =  "ISImagesInAcquisition";
        dict[0x00201040UL] =  "LOPositionReferenceIndicator";
        dict[0x00201041UL] =  "DSSliceLocation";
        dict[0x00201200UL] =  "ISNumberOfPatientRelatedStudies";
        dict[0x00201202UL] =  "ISNumberOfPatientRelatedSeries";
        dict[0x00201204UL] =  "ISNumberOfPatientRelatedInstances";
        dict[0x00201206UL] =  "ISNumberOfStudyRelatedSeries";
        dict[0x00201208UL] =  "ISNumberOfStudyRelatedInstances";
        dict[0x00201209UL] =  "ISNumberOfSeriesRelatedInstances";
        dict[0x00204000UL] =  "LTImageComments";
        dict[0x00209056UL] =  "SHStackID";
        dict[0x00209057UL] =  "ULInStackPositionNumber";
        dict[0x00209071UL] =  "SQFrameAnatomySequence";
        dict[0x00209072UL] =  "CSFrameLaterality";
        dict[0x00209111UL] =  "SQFrameContentSequence";
        dict[0x00209113UL] =  "SQPlanePositionSequence";
        dict[0x00209116UL] =  "SQPlaneOrientationSequence";
        dict[0x00209128UL] =  "ULTemporalPositionIndex";
        dict[0x00209153UL] =  "FDNominalCardiacTriggerDelayTime";
        dict[0x00209154UL] =  "FLNominalCardiacTriggerTimePriorToRPeak";
        dict[0x00209155UL] =  "FLActualCardiacTriggerTimePriorToRPeak";
        dict[0x00209156UL] =  "USFrameAcquisitionNumber";
        dict[0x00209157UL] =  "ULDimensionIndexValues";
        dict[0x00209158UL] =  "LTFrameComments";
        dict[0x00209161UL] =  "UIConcatenationUID";
        dict[0x00209162UL] =  "USInConcatenationNumber";
        dict[0x00209163UL] =  "USInConcatenationTotalNumber";
        dict[0x00209164UL] =  "UIDimensionOrganizationUID";
        dict[0x00209165UL] =  "ATDimensionIndexPointer";
        dict[0x00209167UL] =  "ATFunctionalGroupPointer";
        dict[0x00209213UL] =  "LODimensionIndexPrivateCreator";
        dict[0x00209221UL] =  "SQDimensionOrganizationSequence";
        dict[0x00209222UL] =  "SQDimensionIndexSequence";
        dict[0x00209228UL] =  "ULConcatenationFrameOffsetNumber";
        dict[0x00209238UL] =  "LOFunctionalGroupPrivateCreator";
        dict[0x00209241UL] =  "FLNominalPercentageOfCardiacPhase";
        dict[0x00209245UL] =  "FLNominalPercentageOfRespiratoryPhase";
        dict[0x00209246UL] =  "FLStartingRespiratoryAmplitude";
        dict[0x00209247UL] =  "CSStartingRespiratoryPhase";
        dict[0x00209248UL] =  "FLEndingRespiratoryAmplitude";
        dict[0x00209249UL] =  "CSEndingRespiratoryPhase";
        dict[0x00209250UL] =  "CSRespiratoryTriggerType";
        dict[0x00209251UL] =  "FDRRIntervalTimeNominal";
        dict[0x00209252UL] =  "FDActualCardiacTriggerDelayTime";
        dict[0x00209253UL] =  "SQRespiratorySynchronizationSequence";
        dict[0x00209254UL] =  "FDRespiratoryIntervalTime";
        dict[0x00209255UL] =  "FDNominalRespiratoryTriggerDelayTime";
        dict[0x00209256UL] =  "FDRespiratoryTriggerDelayThreshold";
        dict[0x00209257UL] =  "FDActualRespiratoryTriggerDelayTime";
        dict[0x00209301UL] =  "FDImagePositionVolume";
        dict[0x00209302UL] =  "FDImageOrientationVolume";
        dict[0x00209307UL] =  "CSUltrasoundAcquisitionGeometry";
        dict[0x00209308UL] =  "FDApexPosition";
        dict[0x00209309UL] =  "FDVolumeToTransducerMappingMatrix";
        dict[0x0020930AUL] =  "FDVolumeToTableMappingMatrix";
        dict[0x0020930CUL] =  "CSPatientFrameOfReferenceSource";
        dict[0x0020930DUL] =  "FDTemporalPositionTimeOffset";
        dict[0x0020930EUL] =  "SQPlanePositionVolumeSequence";
        dict[0x0020930FUL] =  "SQPlaneOrientationVolumeSequence";
        dict[0x00209310UL] =  "SQTemporalPositionSequence";
        dict[0x00209311UL] =  "CSDimensionOrganizationType";
        dict[0x00209312UL] =  "UIVolumeFrameOfReferenceUID";
        dict[0x00209313UL] =  "UITableFrameOfReferenceUID";
        dict[0x00209421UL] =  "LODimensionDescriptionLabel";
        dict[0x00209450UL] =  "SQPatientOrientationInFrameSequence";
        dict[0x00209453UL] =  "LOFrameLabel";
        dict[0x00209518UL] =  "USAcquisitionIndex";
        dict[0x00209529UL] =  "SQContributingSOPInstancesReferenceSequence";
        dict[0x00209536UL] =  "USReconstructionIndex";
        dict[0x00220001UL] =  "USLightPathFilterPassThroughWavelength";
        dict[0x00220002UL] =  "USLightPathFilterPassBand";
        dict[0x00220003UL] =  "USImagePathFilterPassThroughWavelength";
        dict[0x00220004UL] =  "USImagePathFilterPassBand";
        dict[0x00220005UL] =  "CSPatientEyeMovementCommanded";
        dict[0x00220006UL] =  "SQPatientEyeMovementCommandCodeSequence";
        dict[0x00220007UL] =  "FLSphericalLensPower";
        dict[0x00220008UL] =  "FLCylinderLensPower";
        dict[0x00220009UL] =  "FLCylinderAxis";
        dict[0x0022000AUL] =  "FLEmmetropicMagnification";
        dict[0x0022000BUL] =  "FLIntraOcularPressure";
        dict[0x0022000CUL] =  "FLHorizontalFieldOfView";
        dict[0x0022000DUL] =  "CSPupilDilated";
        dict[0x0022000EUL] =  "FLDegreeOfDilation";
        dict[0x00220010UL] =  "FLStereoBaselineAngle";
        dict[0x00220011UL] =  "FLStereoBaselineDisplacement";
        dict[0x00220012UL] =  "FLStereoHorizontalPixelOffset";
        dict[0x00220013UL] =  "FLStereoVerticalPixelOffset";
        dict[0x00220014UL] =  "FLStereoRotation";
        dict[0x00220015UL] =  "SQAcquisitionDeviceTypeCodeSequence";
        dict[0x00220016UL] =  "SQIlluminationTypeCodeSequence";
        dict[0x00220017UL] =  "SQLightPathFilterTypeStackCodeSequence";
        dict[0x00220018UL] =  "SQImagePathFilterTypeStackCodeSequence";
        dict[0x00220019UL] =  "SQLensesCodeSequence";
        dict[0x0022001AUL] =  "SQChannelDescriptionCodeSequence";
        dict[0x0022001BUL] =  "SQRefractiveStateSequence";
        dict[0x0022001CUL] =  "SQMydriaticAgentCodeSequence";
        dict[0x0022001DUL] =  "SQRelativeImagePositionCodeSequence";
        dict[0x0022001EUL] =  "FLCameraAngleOfView";
        dict[0x00220020UL] =  "SQStereoPairsSequence";
        dict[0x00220021UL] =  "SQLeftImageSequence";
        dict[0x00220022UL] =  "SQRightImageSequence";
        dict[0x00220030UL] =  "FLAxialLengthOfTheEye";
        dict[0x00220031UL] =  "SQOphthalmicFrameLocationSequence";
        dict[0x00220032UL] =  "FLReferenceCoordinates";
        dict[0x00220035UL] =  "FLDepthSpatialResolution";
        dict[0x00220036UL] =  "FLMaximumDepthDistortion";
        dict[0x00220037UL] =  "FLAlongScanSpatialResolution";
        dict[0x00220038UL] =  "FLMaximumAlongScanDistortion";
        dict[0x00220039UL] =  "CSOphthalmicImageOrientation";
        dict[0x00220041UL] =  "FLDepthOfTransverseImage";
        dict[0x00220042UL] =  "SQMydriaticAgentConcentrationUnitsSequence";
        dict[0x00220048UL] =  "FLAcrossScanSpatialResolution";
        dict[0x00220049UL] =  "FLMaximumAcrossScanDistortion";
        dict[0x0022004EUL] =  "DSMydriaticAgentConcentration";
        dict[0x00220055UL] =  "FLIlluminationWaveLength";
        dict[0x00220056UL] =  "FLIlluminationPower";
        dict[0x00220057UL] =  "FLIlluminationBandwidth";
        dict[0x00220058UL] =  "SQMydriaticAgentSequence";
        dict[0x00221007UL] =  "SQOphthalmicAxialMeasurementsRightEyeSequence";
        dict[0x00221008UL] =  "SQOphthalmicAxialMeasurementsLeftEyeSequence";
        dict[0x00221010UL] =  "CSOphthalmicAxialLengthMeasurementsType";
        dict[0x00221019UL] =  "FLOphthalmicAxialLength";
        dict[0x00221024UL] =  "SQLensStatusCodeSequence";
        dict[0x00221025UL] =  "SQVitreousStatusCodeSequence";
        dict[0x00221028UL] =  "SQIOLFormulaCodeSequence";
        dict[0x00221029UL] =  "LOIOLFormulaDetail";
        dict[0x00221033UL] =  "FLKeratometerIndex";
        dict[0x00221035UL] =  "SQSourceOfOphthalmicAxialLengthCodeSequence";
        dict[0x00221037UL] =  "FLTargetRefraction";
        dict[0x00221039UL] =  "CSRefractiveProcedureOccurred";
        dict[0x00221040UL] =  "SQRefractiveSurgeryTypeCodeSequence";
        dict[0x00221044UL] =  "SQOphthalmicUltrasoundAxialMeasurementsTypeCodeSequence";
        dict[0x00221050UL] =  "SQOphthalmicAxialLengthMeasurementsSequence";
        dict[0x00221053UL] =  "FLIOLPower";
        dict[0x00221054UL] =  "FLPredictedRefractiveError";
        dict[0x00221059UL] =  "FLOphthalmicAxialLengthVelocity";
        dict[0x00221065UL] =  "LOLensStatusDescription";
        dict[0x00221066UL] =  "LOVitreousStatusDescription";
        dict[0x00221090UL] =  "SQIOLPowerSequence";
        dict[0x00221092UL] =  "SQLensConstantSequence";
        dict[0x00221093UL] =  "LOIOLManufacturer";
        dict[0x00221094UL] =  "LOLensConstantDescription";
        dict[0x00221096UL] =  "SQKeratometryMeasurementTypeCodeSequence";
        dict[0x00221100UL] =  "SQReferencedOphthalmicAxialMeasurementsSequence";
        dict[0x00221101UL] =  "SQOphthalmicAxialLengthMeasurementsSegmentNameCodeSequence";
        dict[0x00221103UL] =  "SQRefractiveErrorBeforeRefractiveSurgeryCodeSequence";
        dict[0x00221121UL] =  "FLIOLPowerForExactEmmetropia";
        dict[0x00221122UL] =  "FLIOLPowerForExactTargetRefraction";
        dict[0x00221125UL] =  "SQAnteriorChamberDepthDefinitionCodeSequence";
        dict[0x00221130UL] =  "FLLensThickness";
        dict[0x00221131UL] =  "FLAnteriorChamberDepth";
        dict[0x00221132UL] =  "SQSourceOfLensThicknessDataCodeSequence";
        dict[0x00221133UL] =  "SQSourceOfAnteriorChamberDepthDataCodeSequence";
        dict[0x00221135UL] =  "SQSourceOfRefractiveErrorDataCodeSequence";
        dict[0x00221140UL] =  "CSOphthalmicAxialLengthMeasurementModified";
        dict[0x00221150UL] =  "SQOphthalmicAxialLengthDataSourceCodeSequence";
        dict[0x00221153UL] =  "SQOphthalmicAxialLengthAcquisitionMethodCodeSequence";
        dict[0x00221155UL] =  "FLSignalToNoiseRatio";
        dict[0x00221159UL] =  "LOOphthalmicAxialLengthDataSourceDescription";
        dict[0x00221210UL] =  "SQOphthalmicAxialLengthMeasurementsTotalLengthSequence";
        dict[0x00221211UL] =  "SQOphthalmicAxialLengthMeasurementsSegmentalLengthSequence";
        dict[0x00221212UL] =  "SQOphthalmicAxialLengthMeasurementsLengthSummationSequence";
        dict[0x00221220UL] =  "SQUltrasoundOphthalmicAxialLengthMeasurementsSequence";
        dict[0x00221225UL] =  "SQOpticalOphthalmicAxialLengthMeasurementsSequence";
        dict[0x00221230UL] =  "SQUltrasoundSelectedOphthalmicAxialLengthSequence";
        dict[0x00221250UL] =  "SQOphthalmicAxialLengthSelectionMethodCodeSequence";
        dict[0x00221255UL] =  "SQOpticalSelectedOphthalmicAxialLengthSequence";
        dict[0x00221257UL] =  "SQSelectedSegmentalOphthalmicAxialLengthSequence";
        dict[0x00221260UL] =  "SQSelectedTotalOphthalmicAxialLengthSequence";
        dict[0x00221262UL] =  "SQOphthalmicAxialLengthQualityMetricSequence";
        dict[0x00221273UL] =  "LOOphthalmicAxialLengthQualityMetricTypeDescription";
        dict[0x00221300UL] =  "SQIntraocularLensCalculationsRightEyeSequence";
        dict[0x00221310UL] =  "SQIntraocularLensCalculationsLeftEyeSequence";
        dict[0x00221330UL] =  "SQReferencedOphthalmicAxialLengthMeasurementQCImageSequence";
        dict[0x00240010UL] =  "FLVisualFieldHorizontalExtent";
        dict[0x00240011UL] =  "FLVisualFieldVerticalExtent";
        dict[0x00240012UL] =  "CSVisualFieldShape";
        dict[0x00240016UL] =  "SQScreeningTestModeCodeSequence";
        dict[0x00240018UL] =  "FLMaximumStimulusLuminance";
        dict[0x00240020UL] =  "FLBackgroundLuminance";
        dict[0x00240021UL] =  "SQStimulusColorCodeSequence";
        dict[0x00240024UL] =  "SQBackgroundIlluminationColorCodeSequence";
        dict[0x00240025UL] =  "FLStimulusArea";
        dict[0x00240028UL] =  "FLStimulusPresentationTime";
        dict[0x00240032UL] =  "SQFixationSequence";
        dict[0x00240033UL] =  "SQFixationMonitoringCodeSequence";
        dict[0x00240034UL] =  "SQVisualFieldCatchTrialSequence";
        dict[0x00240035UL] =  "USFixationCheckedQuantity";
        dict[0x00240036UL] =  "USPatientNotProperlyFixatedQuantity";
        dict[0x00240037UL] =  "CSPresentedVisualStimuliDataFlag";
        dict[0x00240038UL] =  "USNumberOfVisualStimuli";
        dict[0x00240039UL] =  "CSExcessiveFixationLossesDataFlag";
        dict[0x00240040UL] =  "CSExcessiveFixationLosses";
        dict[0x00240042UL] =  "USStimuliRetestingQuantity";
        dict[0x00240044UL] =  "LTCommentsOnPatientPerformanceOfVisualField";
        dict[0x00240045UL] =  "CSFalseNegativesEstimateFlag";
        dict[0x00240046UL] =  "FLFalseNegativesEstimate";
        dict[0x00240048UL] =  "USNegativeCatchTrialsQuantity";
        dict[0x00240050UL] =  "USFalseNegativesQuantity";
        dict[0x00240051UL] =  "CSExcessiveFalseNegativesDataFlag";
        dict[0x00240052UL] =  "CSExcessiveFalseNegatives";
        dict[0x00240053UL] =  "CSFalsePositivesEstimateFlag";
        dict[0x00240054UL] =  "FLFalsePositivesEstimate";
        dict[0x00240055UL] =  "CSCatchTrialsDataFlag";
        dict[0x00240056UL] =  "USPositiveCatchTrialsQuantity";
        dict[0x00240057UL] =  "CSTestPointNormalsDataFlag";
        dict[0x00240058UL] =  "SQTestPointNormalsSequence";
        dict[0x00240059UL] =  "CSGlobalDeviationProbabilityNormalsFlag";
        dict[0x00240060UL] =  "USFalsePositivesQuantity";
        dict[0x00240061UL] =  "CSExcessiveFalsePositivesDataFlag";
        dict[0x00240062UL] =  "CSExcessiveFalsePositives";
        dict[0x00240063UL] =  "CSVisualFieldTestNormalsFlag";
        dict[0x00240064UL] =  "SQResultsNormalsSequence";
        dict[0x00240065UL] =  "SQAgeCorrectedSensitivityDeviationAlgorithmSequence";
        dict[0x00240066UL] =  "FLGlobalDeviationFromNormal";
        dict[0x00240067UL] =  "SQGeneralizedDefectSensitivityDeviationAlgorithmSequence";
        dict[0x00240068UL] =  "FLLocalizedDeviationfromNormal";
        dict[0x00240069UL] =  "LOPatientReliabilityIndicator";
        dict[0x00240070UL] =  "FLVisualFieldMeanSensitivity";
        dict[0x00240071UL] =  "FLGlobalDeviationProbability";
        dict[0x00240072UL] =  "CSLocalDeviationProbabilityNormalsFlag";
        dict[0x00240073UL] =  "FLLocalizedDeviationProbability";
        dict[0x00240074UL] =  "CSShortTermFluctuationCalculated";
        dict[0x00240075UL] =  "FLShortTermFluctuation";
        dict[0x00240076UL] =  "CSShortTermFluctuationProbabilityCalculated";
        dict[0x00240077UL] =  "FLShortTermFluctuationProbability";
        dict[0x00240078UL] =  "CSCorrectedLocalizedDeviationFromNormalCalculated";
        dict[0x00240079UL] =  "FLCorrectedLocalizedDeviationFromNormal";
        dict[0x00240080UL] =  "CSCorrectedLocalizedDeviationFromNormalProbabilityCalculated";
        dict[0x00240081UL] =  "FLCorrectedLocalizedDeviationFromNormalProbability";
        dict[0x00240083UL] =  "SQGlobalDeviationProbabilitySequence";
        dict[0x00240085UL] =  "SQLocalizedDeviationProbabilitySequence";
        dict[0x00240086UL] =  "CSFovealSensitivityMeasured";
        dict[0x00240087UL] =  "FLFovealSensitivity";
        dict[0x00240088UL] =  "FLVisualFieldTestDuration";
        dict[0x00240089UL] =  "SQVisualFieldTestPointSequence";
        dict[0x00240090UL] =  "FLVisualFieldTestPointXCoordinate";
        dict[0x00240091UL] =  "FLVisualFieldTestPointYCoordinate";
        dict[0x00240092UL] =  "FLAgeCorrectedSensitivityDeviationValue";
        dict[0x00240093UL] =  "CSStimulusResults";
        dict[0x00240094UL] =  "FLSensitivityValue";
        dict[0x00240095UL] =  "CSRetestStimulusSeen";
        dict[0x00240096UL] =  "FLRetestSensitivityValue";
        dict[0x00240097UL] =  "SQVisualFieldTestPointNormalsSequence";
        dict[0x00240098UL] =  "FLQuantifiedDefect";
        dict[0x00240100UL] =  "FLAgeCorrectedSensitivityDeviationProbabilityValue";
        dict[0x00240102UL] =  "CSGeneralizedDefectCorrectedSensitivityDeviationFlag";
        dict[0x00240103UL] =  "FLGeneralizedDefectCorrectedSensitivityDeviationValue";
        dict[0x00240104UL] =  "FLGeneralizedDefectCorrectedSensitivityDeviationProbabilityValue";
        dict[0x00240105UL] =  "FLMinimumSensitivityValue";
        dict[0x00240106UL] =  "CSBlindSpotLocalized";
        dict[0x00240107UL] =  "FLBlindSpotXCoordinate";
        dict[0x00240108UL] =  "FLBlindSpotYCoordinate";
        dict[0x00240110UL] =  "SQVisualAcuityMeasurementSequence";
        dict[0x00240112UL] =  "SQRefractiveParametersUsedOnPatientSequence";
        dict[0x00240113UL] =  "CSMeasurementLaterality";
        dict[0x00240114UL] =  "SQOphthalmicPatientClinicalInformationLeftEyeSequence";
        dict[0x00240115UL] =  "SQOphthalmicPatientClinicalInformationRightEyeSequence";
        dict[0x00240117UL] =  "CSFovealPointNormativeDataFlag";
        dict[0x00240118UL] =  "FLFovealPointProbabilityValue";
        dict[0x00240120UL] =  "CSScreeningBaselineMeasured";
        dict[0x00240122UL] =  "SQScreeningBaselineMeasuredSequence";
        dict[0x00240124UL] =  "CSScreeningBaselineType";
        dict[0x00240126UL] =  "FLScreeningBaselineValue";
        dict[0x00240202UL] =  "LOAlgorithmSource";
        dict[0x00240306UL] =  "LODataSetName";
        dict[0x00240307UL] =  "LODataSetVersion";
        dict[0x00240308UL] =  "LODataSetSource";
        dict[0x00240309UL] =  "LODataSetDescription";
        dict[0x00240317UL] =  "SQVisualFieldTestReliabilityGlobalIndexSequence";
        dict[0x00240320UL] =  "SQVisualFieldGlobalResultsIndexSequence";
        dict[0x00240325UL] =  "SQDataObservationSequence";
        dict[0x00240338UL] =  "CSIndexNormalsFlag";
        dict[0x00240341UL] =  "FLIndexProbability";
        dict[0x00240344UL] =  "SQIndexProbabilitySequence";
        dict[0x00280002UL] =  "USSamplesPerPixel";
        dict[0x00280003UL] =  "USSamplesPerPixelUsed";
        dict[0x00280004UL] =  "CSPhotometricInterpretation";
        dict[0x00280006UL] =  "USPlanarConfiguration";
        dict[0x00280008UL] =  "ISNumberOfFrames";
        dict[0x00280009UL] =  "ATFrameIncrementPointer";
        dict[0x0028000AUL] =  "ATFrameDimensionPointer";
        dict[0x00280010UL] =  "USRows";
        dict[0x00280011UL] =  "USColumns";
        dict[0x00280014UL] =  "USUltrasoundColorDataPresent";
        dict[0x00280030UL] =  "DSPixelSpacing";
        dict[0x00280031UL] =  "DSZoomFactor";
        dict[0x00280032UL] =  "DSZoomCenter";
        dict[0x00280034UL] =  "ISPixelAspectRatio";
        dict[0x00280051UL] =  "CSCorrectedImage";
        dict[0x00280100UL] =  "USBitsAllocated";
        dict[0x00280101UL] =  "USBitsStored";
        dict[0x00280102UL] =  "USHighBit";
        dict[0x00280103UL] =  "USPixelRepresentation";
        dict[0x00280106UL] =  "USSmallestImagePixelValue";
        dict[0x00280107UL] =  "USLargestImagePixelValue";
        dict[0x00280108UL] =  "USSmallestPixelValueInSeries";
        dict[0x00280109UL] =  "USLargestPixelValueInSeries";
        dict[0x00280120UL] =  "USPixelPaddingValue";
        dict[0x00280121UL] =  "USPixelPaddingRangeLimit";
        dict[0x00280300UL] =  "CSQualityControlImage";
        dict[0x00280301UL] =  "CSBurnedInAnnotation";
        dict[0x00280302UL] =  "CSRecognizableVisualFeatures";
        dict[0x00280303UL] =  "CSLongitudinalTemporalInformationModified";
        dict[0x00280A02UL] =  "CSPixelSpacingCalibrationType";
        dict[0x00280A04UL] =  "LOPixelSpacingCalibrationDescription";
        dict[0x00281040UL] =  "CSPixelIntensityRelationship";
        dict[0x00281041UL] =  "SSPixelIntensityRelationshipSign";
        dict[0x00281050UL] =  "DSWindowCenter";
        dict[0x00281051UL] =  "DSWindowWidth";
        dict[0x00281052UL] =  "DSRescaleIntercept";
        dict[0x00281053UL] =  "DSRescaleSlope";
        dict[0x00281054UL] =  "LORescaleType";
        dict[0x00281055UL] =  "LOWindowCenterWidthExplanation";
        dict[0x00281056UL] =  "CSVOILUTFunction";
        dict[0x00281090UL] =  "CSRecommendedViewingMode";
        dict[0x00281101UL] =  "USRedPaletteColorLookupTableDescriptor";
        dict[0x00281102UL] =  "USGreenPaletteColorLookupTableDescriptor";
        dict[0x00281103UL] =  "USBluePaletteColorLookupTableDescriptor";
        dict[0x00281104UL] =  "USAlphaPaletteColorLookupTableDescriptor";
        dict[0x00281199UL] =  "UIPaletteColorLookupTableUID";
        dict[0x00281201UL] =  "OWRedPaletteColorLookupTableData";
        dict[0x00281202UL] =  "OWGreenPaletteColorLookupTableData";
        dict[0x00281203UL] =  "OWBluePaletteColorLookupTableData";
        dict[0x00281204UL] =  "OWAlphaPaletteColorLookupTableData";
        dict[0x00281221UL] =  "OWSegmentedRedPaletteColorLookupTableData";
        dict[0x00281222UL] =  "OWSegmentedGreenPaletteColorLookupTableData";
        dict[0x00281223UL] =  "OWSegmentedBluePaletteColorLookupTableData";
        dict[0x00281300UL] =  "CSBreastImplantPresent";
        dict[0x00281350UL] =  "CSPartialView";
        dict[0x00281351UL] =  "STPartialViewDescription";
        dict[0x00281352UL] =  "SQPartialViewCodeSequence";
        dict[0x0028135AUL] =  "CSSpatialLocationsPreserved";
        dict[0x00281401UL] =  "SQDataFrameAssignmentSequence";
        dict[0x00281402UL] =  "CSDataPathAssignment";
        dict[0x00281403UL] =  "USBitsMappedToColorLookupTable";
        dict[0x00281404UL] =  "SQBlendingLUT1Sequence";
        dict[0x00281405UL] =  "CSBlendingLUT1TransferFunction";
        dict[0x00281406UL] =  "FDBlendingWeightConstant";
        dict[0x00281407UL] =  "USBlendingLookupTableDescriptor";
        dict[0x00281408UL] =  "OWBlendingLookupTableData";
        dict[0x0028140BUL] =  "SQEnhancedPaletteColorLookupTableSequence";
        dict[0x0028140CUL] =  "SQBlendingLUT2Sequence";
        dict[0x0028140DUL] =  "CSBlendingLUT2TransferFunction";
        dict[0x0028140EUL] =  "CSDataPathID";
        dict[0x0028140FUL] =  "CSRGBLUTTransferFunction";
        dict[0x00281410UL] =  "CSAlphaLUTTransferFunction";
        dict[0x00282000UL] =  "OBICCProfile";
        dict[0x00282110UL] =  "CSLossyImageCompression";
        dict[0x00282112UL] =  "DSLossyImageCompressionRatio";
        dict[0x00282114UL] =  "CSLossyImageCompressionMethod";
        dict[0x00283000UL] =  "SQModalityLUTSequence";
        dict[0x00283002UL] =  "USLUTDescriptor";
        dict[0x00283003UL] =  "LOLUTExplanation";
        dict[0x00283004UL] =  "LOModalityLUTType";
        dict[0x00283006UL] =  "USLUTData";
        dict[0x00283010UL] =  "SQVOILUTSequence";
        dict[0x00283110UL] =  "SQSoftcopyVOILUTSequences";
        dict[0x00286010UL] =  "USRepresentativeFrameNumber";
        dict[0x00286020UL] =  "USFrameNumbersOfInterest";
        dict[0x00286022UL] =  "LOFrameOfInterestDescription";
        dict[0x00286023UL] =  "CSFrameOfInterestType";
        dict[0x00286040UL] =  "USRWavePointer";
        dict[0x00286100UL] =  "SQMaskSubtractionSequence";
        dict[0x00286101UL] =  "CSMaskOperation";
        dict[0x00286102UL] =  "USApplicableFrameRange";
        dict[0x00286110UL] =  "USMaskFrameNumbers";
        dict[0x00286112UL] =  "USContrastFrameAveraging";
        dict[0x00286114UL] =  "FLMaskSubPixelShift";
        dict[0x00286120UL] =  "SSTIDOffset";
        dict[0x00286190UL] =  "STMaskOperationExplanation";
        dict[0x00287FE0UL] =  "UTPixelDataProviderURL";
        dict[0x00289001UL] =  "ULDataPointRows";
        dict[0x00289002UL] =  "ULDataPointColumns";
        dict[0x00289003UL] =  "CSSignalDomainColumnsue";
        dict[0x00289108UL] =  "CSDataRepresentation";
        dict[0x00289110UL] =  "SQPixelMeasuresSequence";
        dict[0x00289132UL] =  "SQFrameVOILUTSequence";
        dict[0x00289145UL] =  "SQPixelValueTransformationSequence";
        dict[0x00289235UL] =  "CSSignalDomainRows";
        dict[0x00289411UL] =  "FLDisplayFilterPercentage";
        dict[0x00289415UL] =  "SQFramePixelShiftSequence";
        dict[0x00289416UL] =  "USSubtractionItemID";
        dict[0x00289422UL] =  "SQPixelIntensityRelationshipLUTSequence";
        dict[0x00289443UL] =  "SQFramePixelDataPropertiesSequence";
        dict[0x00289444UL] =  "CSGeometricalProperties";
        dict[0x00289445UL] =  "FLGeometricMaximumDistortion";
        dict[0x00289446UL] =  "CSImageProcessingApplied";
        dict[0x00289454UL] =  "CSMaskSelectionMode";
        dict[0x00289474UL] =  "CSLUTFunction";
        dict[0x00289478UL] =  "FLMaskVisibilityPercentage";
        dict[0x00289501UL] =  "SQPixelShiftSequence";
        dict[0x00289502UL] =  "SQRegionPixelShiftSequence";
        dict[0x00289503UL] =  "SSVerticesOfTheRegion";
        dict[0x00289505UL] =  "SQMultiFramePresentationSequence";
        dict[0x00289506UL] =  "USPixelShiftFrameRange";
        dict[0x00289507UL] =  "USLUTFrameRange";
        dict[0x00289520UL] =  "DSImageToEquipmentMappingMatrix";
        dict[0x00289537UL] =  "CSEquipmentCoordinateSystemIdentification";
        dict[0x00290010UL] =  "LOPrivateCreatorCode";
        dict[0x00290011UL] =  "LOAnotherPrivateCreatorCode";
        dict[0x00291008UL] =  "CSCSAImageHeaderType";
        dict[0x00291009UL] =  "LOCSAImageHeaderVersion";
        dict[0x00291010UL] =  "OBCSAImageHeaderInfo";
        dict[0x00291018UL] =  "CSCSASeriesHeaderType";
        dict[0x00291019UL] =  "LOCSASeriesHeaderVersion";
        dict[0x00291020UL] =  "OBCSASeriesHeaderInfo";
        dict[0x00291131UL] =  "LOPMTFInformation1";
        dict[0x00291132UL] =  "ULPMTFInformation2";
        dict[0x00291133UL] =  "ULPMTFInformation3";
        dict[0x00291134UL] =  "CSPMTFInformation4";
        dict[0x7fe11010UL] =  "OBCSAData";
        dict[0x00321031UL] =  "SQRequestingPhysicianIdentificationSequence";
        dict[0x00321032UL] =  "PNRequestingPhysician";
        dict[0x00321033UL] =  "LORequestingService";
        dict[0x00321034UL] =  "SQRequestingServiceCodeSequence";
        dict[0x00321060UL] =  "LORequestedProcedureDescription";
        dict[0x00321064UL] =  "SQRequestedProcedureCodeSequence";
        dict[0x00321070UL] =  "LORequestedContrastAgent";
        dict[0x00380004UL] =  "SQReferencedPatientAliasSequence";
        dict[0x00380008UL] =  "CSVisitStatusID";
        dict[0x00380010UL] =  "LOAdmissionID";
        dict[0x00380014UL] =  "SQIssuerOfAdmissionIDSequence";
        dict[0x00380016UL] =  "LORouteOfAdmissionsesidence";
        dict[0x00380020UL] =  "DAAdmittingDate";
        dict[0x00380021UL] =  "TMAdmittingTime";
        dict[0x00380050UL] =  "LOSpecialNeeds";
        dict[0x00380060UL] =  "LOServiceEpisodeID";
        dict[0x00380062UL] =  "LOServiceEpisodeDescription";
        dict[0x00380064UL] =  "SQIssuerOfServiceEpisodeIDSequence";
        dict[0x00380100UL] =  "SQPertinentDocumentsSequence";
        dict[0x00380300UL] =  "LOCurrentPatientLocation";
        dict[0x00380400UL] =  "LOPatientInstitutionResidence";
        dict[0x00380500UL] =  "LOPatientState";
        dict[0x00380502UL] =  "SQPatientClinicalTrialParticipationSequence";
        dict[0x00384000UL] =  "LTVisitComments";
        dict[0x003A0004UL] =  "CSWaveformOriginality";
        dict[0x003A0005UL] =  "USNumberOfWaveformChannels";
        dict[0x003A0010UL] =  "ULNumberOfWaveformSamples";
        dict[0x003A001AUL] =  "DSSamplingFrequency";
        dict[0x003A0020UL] =  "SHMultiplexGroupLabel";
        dict[0x003A0200UL] =  "SQChannelDefinitionSequence";
        dict[0x003A0202UL] =  "ISWaveformChannelNumber";
        dict[0x003A0203UL] =  "SHChannelLabel";
        dict[0x003A0205UL] =  "CSChannelStatus";
        dict[0x003A0208UL] =  "SQChannelSourceSequence";
        dict[0x003A0209UL] =  "SQChannelSourceModifiersSequence";
        dict[0x003A020AUL] =  "SQSourceWaveformSequence";
        dict[0x003A020CUL] =  "LOChannelDerivationDescription";
        dict[0x003A0210UL] =  "DSChannelSensitivity";
        dict[0x003A0211UL] =  "SQChannelSensitivityUnitsSequence";
        dict[0x003A0212UL] =  "DSChannelSensitivityCorrectionFactor";
        dict[0x003A0213UL] =  "DSChannelBaseline";
        dict[0x003A0214UL] =  "DSChannelTimeSkew";
        dict[0x003A0215UL] =  "DSChannelSampleSkew";
        dict[0x003A0218UL] =  "DSChannelOffset";
        dict[0x003A021AUL] =  "USWaveformBitsStored";
        dict[0x003A0220UL] =  "DSFilterLowFrequency";
        dict[0x003A0221UL] =  "DSFilterHighFrequency";
        dict[0x003A0222UL] =  "DSNotchFilterFrequency";
        dict[0x003A0223UL] =  "DSNotchFilterBandwidth";
        dict[0x003A0230UL] =  "FLWaveformDataDisplayScale";
        dict[0x003A0231UL] =  "USWaveformDisplayBackgroundCIELabValue";
        dict[0x003A0240UL] =  "SQWaveformPresentationGroupSequence";
        dict[0x003A0241UL] =  "USPresentationGroupNumber";
        dict[0x003A0242UL] =  "SQChannelDisplaySequence";
        dict[0x003A0244UL] =  "USChannelRecommendedDisplayCIELabValue";
        dict[0x003A0245UL] =  "FLChannelPosition";
        dict[0x003A0246UL] =  "CSDisplayShadingFlag";
        dict[0x003A0247UL] =  "FLFractionalChannelDisplayScale";
        dict[0x003A0248UL] =  "FLAbsoluteChannelDisplayScale";
        dict[0x003A0300UL] =  "SQMultiplexedAudioChannelsDescriptionCodeSequence";
        dict[0x003A0301UL] =  "ISChannelIdentificationCode";
        dict[0x003A0302UL] =  "CSChannelMode";
        dict[0x00400001UL] =  "AEScheduledStationAETitle";
        dict[0x00400002UL] =  "DAScheduledProcedureStepStartDate";
        dict[0x00400003UL] =  "TMScheduledProcedureStepStartTime";
        dict[0x00400004UL] =  "DAScheduledProcedureStepEndDate";
        dict[0x00400005UL] =  "TMScheduledProcedureStepEndTime";
        dict[0x00400006UL] =  "PNScheduledPerformingPhysicianName";
        dict[0x00400007UL] =  "LOScheduledProcedureStepDescription";
        dict[0x00400008UL] =  "SQScheduledProtocolCodeSequence";
        dict[0x00400009UL] =  "SHScheduledProcedureStepID";
        dict[0x0040000AUL] =  "SQStageCodeSequence";
        dict[0x0040000BUL] =  "SQScheduledPerformingPhysicianIdentificationSequence";
        dict[0x00400010UL] =  "SHScheduledStationName";
        dict[0x00400011UL] =  "SHScheduledProcedureStepLocation";
        dict[0x00400012UL] =  "LOPreMedication";
        dict[0x00400020UL] =  "CSScheduledProcedureStepStatus";
        dict[0x00400026UL] =  "SQOrderPlacerIdentifierSequence";
        dict[0x00400027UL] =  "SQOrderFillerIdentifierSequence";
        dict[0x00400031UL] =  "UTLocalNamespaceEntityID";
        dict[0x00400032UL] =  "UTUniversalEntityID";
        dict[0x00400033UL] =  "CSUniversalEntityIDType";
        dict[0x00400035UL] =  "CSIdentifierTypeCode";
        dict[0x00400036UL] =  "SQAssigningFacilitySequence";
        dict[0x00400039UL] =  "SQAssigningJurisdictionCodeSequence";
        dict[0x0040003AUL] =  "SQAssigningAgencyOrDepartmentCodeSequence";
        dict[0x00400100UL] =  "SQScheduledProcedureStepSequence";
        dict[0x00400220UL] =  "SQReferencedNonImageCompositeSOPInstanceSequence";
        dict[0x00400241UL] =  "AEPerformedStationAETitle";
        dict[0x00400242UL] =  "SHPerformedStationName";
        dict[0x00400243UL] =  "SHPerformedLocation";
        dict[0x00400244UL] =  "DAPerformedProcedureStepStartDate";
        dict[0x00400245UL] =  "TMPerformedProcedureStepStartTime";
        dict[0x00400250UL] =  "DAPerformedProcedureStepEndDate";
        dict[0x00400251UL] =  "TMPerformedProcedureStepEndTime";
        dict[0x00400252UL] =  "CSPerformedProcedureStepStatus";
        dict[0x00400253UL] =  "SHPerformedProcedureStepID";
        dict[0x00400254UL] =  "LOPerformedProcedureStepDescription";
        dict[0x00400255UL] =  "LOPerformedProcedureTypeDescription";
        dict[0x00400260UL] =  "SQPerformedProtocolCodeSequence";
        dict[0x00400261UL] =  "CSPerformedProtocolType";
        dict[0x00400270UL] =  "SQScheduledStepAttributesSequence";
        dict[0x00400275UL] =  "SQRequestAttributesSequence";
        dict[0x00400280UL] =  "STCommentsOnThePerformedProcedureStep";
        dict[0x00400281UL] =  "SQPerformedProcedureStepDiscontinuationReasonCodeSequence";
        dict[0x00400293UL] =  "SQQuantitySequence";
        dict[0x00400294UL] =  "DSQuantity";
        dict[0x00400295UL] =  "SQMeasuringUnitsSequence";
        dict[0x00400296UL] =  "SQBillingItemSequence";
        dict[0x00400300UL] =  "USTotalTimeOfFluoroscopy";
        dict[0x00400301UL] =  "USTotalNumberOfExposures";
        dict[0x00400302UL] =  "USEntranceDose";
        dict[0x00400303UL] =  "USExposedArea";
        dict[0x00400306UL] =  "DSDistanceSourceToEntrance";
        dict[0x0040030EUL] =  "SQExposureDoseSequence";
        dict[0x00400310UL] =  "STCommentsOnRadiationDose";
        dict[0x00400312UL] =  "DSXRayOutput";
        dict[0x00400314UL] =  "DSHalfValueLayer";
        dict[0x00400316UL] =  "DSOrganDose";
        dict[0x00400318UL] =  "CSOrganExposed";
        dict[0x00400320UL] =  "SQBillingProcedureStepSequence";
        dict[0x00400321UL] =  "SQFilmConsumptionSequence";
        dict[0x00400324UL] =  "SQBillingSuppliesAndDevicesSequence";
        dict[0x00400340UL] =  "SQPerformedSeriesSequence";
        dict[0x00400400UL] =  "LTCommentsOnTheScheduledProcedureStep";
        dict[0x00400440UL] =  "SQProtocolContextSequence";
        dict[0x00400441UL] =  "SQContentItemModifierSequence";
        dict[0x00400500UL] =  "SQScheduledSpecimenSequence";
        dict[0x00400512UL] =  "LOContainerIdentifier";
        dict[0x00400513UL] =  "SQIssuerOfTheContainerIdentifierSequence";
        dict[0x00400515UL] =  "SQAlternateContainerIdentifierSequence";
        dict[0x00400518UL] =  "SQContainerTypeCodeSequence";
        dict[0x0040051AUL] =  "LOContainerDescription";
        dict[0x00400520UL] =  "SQContainerComponentSequence";
        dict[0x00400551UL] =  "LOSpecimenIdentifiernceTrial";
        dict[0x00400554UL] =  "UISpecimenUID";
        dict[0x00400555UL] =  "SQAcquisitionContextSequence";
        dict[0x00400556UL] =  "STAcquisitionContextDescription";
        dict[0x00400560UL] =  "SQSpecimenDescriptionSequence";
        dict[0x00400562UL] =  "SQIssuerOfTheSpecimenIdentifierSequence";
        dict[0x0040059AUL] =  "SQSpecimenTypeCodeSequence";
        dict[0x00400600UL] =  "LOSpecimenShortDescription";
        dict[0x00400602UL] =  "UTSpecimenDetailedDescription";
        dict[0x00400610UL] =  "SQSpecimenPreparationSequence";
        dict[0x00400612UL] =  "SQSpecimenPreparationStepContentItemSequence";
        dict[0x00400620UL] =  "SQSpecimenLocalizationContentItemSequence";
        dict[0x0040071AUL] =  "SQImageCenterPointCoordinatesSequence";
        dict[0x0040072AUL] =  "DSXOffsetInSlideCoordinateSystem";
        dict[0x0040073AUL] =  "DSYOffsetInSlideCoordinateSystem";
        dict[0x0040074AUL] =  "DSZOffsetInSlideCoordinateSystem";
        dict[0x004008EAUL] =  "SQMeasurementUnitsCodeSequence";
        dict[0x00401001UL] =  "SHRequestedProcedureID";
        dict[0x00401002UL] =  "LOReasonForTheRequestedProcedure";
        dict[0x00401003UL] =  "SHRequestedProcedurePriority";
        dict[0x00401004UL] =  "LOPatientTransportArrangements";
        dict[0x00401005UL] =  "LORequestedProcedureLocation";
        dict[0x00401008UL] =  "LOConfidentialityCode";
        dict[0x00401009UL] =  "SHReportingPriority";
        dict[0x0040100AUL] =  "SQReasonForRequestedProcedureCodeSequence";
        dict[0x00401010UL] =  "PNNamesOfIntendedRecipientsOfResults";
        dict[0x00401011UL] =  "SQIntendedRecipientsOfResultsIdentificationSequence";
        dict[0x00401012UL] =  "SQReasonForPerformedProcedureCodeSequence";
        dict[0x00401101UL] =  "SQPersonIdentificationCodeSequence";
        dict[0x00401102UL] =  "STPersonAddress";
        dict[0x00401103UL] =  "LOPersonTelephoneNumbers";
        dict[0x00401400UL] =  "LTRequestedProcedureComments";
        dict[0x00402004UL] =  "DAIssueDateOfImagingServiceRequest";
        dict[0x00402005UL] =  "TMIssueTimeOfImagingServiceRequest";
        dict[0x00402008UL] =  "PNOrderEnteredBy";
        dict[0x00402009UL] =  "SHOrderEntererLocation";
        dict[0x00402010UL] =  "SHOrderCallbackPhoneNumber";
        dict[0x00402016UL] =  "LOPlacerOrderNumberImagingServiceRequest";
        dict[0x00402017UL] =  "LOFillerOrderNumberImagingServiceRequest";
        dict[0x00402400UL] =  "LTImagingServiceRequestComments";
        dict[0x00403001UL] =  "LOConfidentialityConstraintOnPatientDataDescription";
        dict[0x00404001UL] =  "CSGeneralPurposeScheduledProcedureStepStatus";
        dict[0x00404002UL] =  "CSGeneralPurposePerformedProcedureStepStatus";
        dict[0x00404003UL] =  "CSGeneralPurposeScheduledProcedureStepPriority";
        dict[0x00404004UL] =  "SQScheduledProcessingApplicationsCodeSequence";
        dict[0x00404005UL] =  "DTScheduledProcedureStepStartDateTime";
        dict[0x00404006UL] =  "CSMultipleCopiesFlag";
        dict[0x00404007UL] =  "SQPerformedProcessingApplicationsCodeSequence";
        dict[0x00404009UL] =  "SQHumanPerformerCodeSequence";
        dict[0x00404010UL] =  "DTScheduledProcedureStepModificationDateTime";
        dict[0x00404011UL] =  "DTExpectedCompletionDateTime";
        dict[0x00404015UL] =  "SQResultingGeneralPurposePerformedProcedureStepsSequence";
        dict[0x00404016UL] =  "SQReferencedGeneralPurposeScheduledProcedureStepSequence";
        dict[0x00404018UL] =  "SQScheduledWorkitemCodeSequence";
        dict[0x00404019UL] =  "SQPerformedWorkitemCodeSequence";
        dict[0x00404020UL] =  "CSInputAvailabilityFlag";
        dict[0x00404021UL] =  "SQInputInformationSequence";
        dict[0x00404022UL] =  "SQRelevantInformationSequence";
        dict[0x00404023UL] =  "UIReferencedGeneralPurposeScheduledProcedureStepTransactionUID";
        dict[0x00404025UL] =  "SQScheduledStationNameCodeSequence";
        dict[0x00404026UL] =  "SQScheduledStationClassCodeSequence";
        dict[0x00404027UL] =  "SQScheduledStationGeographicLocationCodeSequence";
        dict[0x00404028UL] =  "SQPerformedStationNameCodeSequence";
        dict[0x00404029UL] =  "SQPerformedStationClassCodeSequence";
        dict[0x00404030UL] =  "SQPerformedStationGeographicLocationCodeSequence";
        dict[0x00404031UL] =  "SQRequestedSubsequentWorkitemCodeSequence";
        dict[0x00404032UL] =  "SQNonDICOMOutputCodeSequence";
        dict[0x00404033UL] =  "SQOutputInformationSequence";
        dict[0x00404034UL] =  "SQScheduledHumanPerformersSequence";
        dict[0x00404035UL] =  "SQActualHumanPerformersSequence";
        dict[0x00404036UL] =  "LOHumanPerformerOrganization";
        dict[0x00404037UL] =  "PNHumanPerformerName";
        dict[0x00404040UL] =  "CSRawDataHandling";
        dict[0x00404041UL] =  "CSInputReadinessState";
        dict[0x00404050UL] =  "DTPerformedProcedureStepStartDateTime";
        dict[0x00404051UL] =  "DTPerformedProcedureStepEndDateTime";
        dict[0x00404052UL] =  "DTProcedureStepCancellationDateTime";
        dict[0x00408302UL] =  "DSEntranceDoseInmGy";
        dict[0x00409094UL] =  "SQReferencedImageRealWorldValueMappingSequence";
        dict[0x00409096UL] =  "SQRealWorldValueMappingSequence";
        dict[0x00409098UL] =  "SQPixelValueMappingCodeSequence";
        dict[0x00409210UL] =  "SHLUTLabel";
        dict[0x00409211UL] =  "USRealWorldValueLastValueMapped";
        dict[0x00409212UL] =  "FDRealWorldValueLUTData";
        dict[0x00409216UL] =  "USRealWorldValueFirstValueMapped";
        dict[0x00409224UL] =  "FDRealWorldValueIntercept";
        dict[0x00409225UL] =  "FDRealWorldValueSlope";
        dict[0x0040A010UL] =  "CSRelationshipType";
        dict[0x0040A027UL] =  "LOVerifyingOrganizationentifierCodeSequenceTrial";
        dict[0x0040A030UL] =  "DTVerificationDateTime";
        dict[0x0040A032UL] =  "DTObservationDateTime";
        dict[0x0040A040UL] =  "CSValueType";
        dict[0x0040A043UL] =  "SQConceptNameCodeSequence";
        dict[0x0040A050UL] =  "CSContinuityOfContent";
        dict[0x0040A073UL] =  "SQVerifyingObserverSequence";
        dict[0x0040A075UL] =  "PNVerifyingObserverNameierCodeSequenceTrial";
        dict[0x0040A078UL] =  "SQAuthorObserverSequence";
        dict[0x0040A07AUL] =  "SQParticipantSequence";
        dict[0x0040A07CUL] =  "SQCustodialOrganizationSequence";
        dict[0x0040A080UL] =  "CSParticipationType";
        dict[0x0040A082UL] =  "DTParticipationDateTime";
        dict[0x0040A084UL] =  "CSObserverType";
        dict[0x0040A088UL] =  "SQVerifyingObserverIdentificationCodeSequence";
        dict[0x0040A0B0UL] =  "USReferencedWaveformChannels";
        dict[0x0040A120UL] =  "DTDateTime";
        dict[0x0040A121UL] =  "DADate";
        dict[0x0040A122UL] =  "TMTime";
        dict[0x0040A123UL] =  "PNPersonName";
        dict[0x0040A124UL] =  "UIUID";
        dict[0x0040A130UL] =  "CSTemporalRangeType";
        dict[0x0040A132UL] =  "ULReferencedSamplePositions";
        dict[0x0040A136UL] =  "USReferencedFrameNumbers";
        dict[0x0040A138UL] =  "DSReferencedTimeOffsets";
        dict[0x0040A13AUL] =  "DTReferencedDateTime";
        dict[0x0040A160UL] =  "UTTextValue";
        dict[0x0040A168UL] =  "SQConceptCodeSequence";
        dict[0x0040A170UL] =  "SQPurposeOfReferenceCodeSequence";
        dict[0x0040A180UL] =  "USAnnotationGroupNumber";
        dict[0x0040A195UL] =  "SQModifierCodeSequence";
        dict[0x0040A300UL] =  "SQMeasuredValueSequence";
        dict[0x0040A301UL] =  "SQNumericValueQualifierCodeSequence";
        dict[0x0040A30AUL] =  "DSNumericValue";
        dict[0x0040A360UL] =  "SQPredecessorDocumentsSequence";
        dict[0x0040A370UL] =  "SQReferencedRequestSequence";
        dict[0x0040A372UL] =  "SQPerformedProcedureCodeSequence";
        dict[0x0040A375UL] =  "SQCurrentRequestedProcedureEvidenceSequence";
        dict[0x0040A385UL] =  "SQPertinentOtherEvidenceSequence";
        dict[0x0040A390UL] =  "SQHL7StructuredDocumentReferenceSequencealeSequenceTrial";
        dict[0x0040A491UL] =  "CSCompletionFlag";
        dict[0x0040A492UL] =  "LOCompletionFlagDescription";
        dict[0x0040A493UL] =  "CSVerificationFlag";
        dict[0x0040A494UL] =  "CSArchiveRequested";
        dict[0x0040A496UL] =  "CSPreliminaryFlag";
        dict[0x0040A504UL] =  "SQContentTemplateSequence";
        dict[0x0040A525UL] =  "SQIdenticalDocumentsSequencelagTrial";
        dict[0x0040A730UL] =  "SQContentSequenceenceTrialall";
        dict[0x0040B020UL] =  "SQWaveformAnnotationSequence";
        dict[0x0040DB00UL] =  "CSTemplateIdentifierionUID";
        dict[0x0040DB73UL] =  "ULReferencedContentItemIdentifier";
        dict[0x0040E001UL] =  "STHL7InstanceIdentifier";
        dict[0x0040E004UL] =  "DTHL7DocumentEffectiveTime";
        dict[0x0040E006UL] =  "SQHL7DocumentTypeCodeSequence";
        dict[0x0040E008UL] =  "SQDocumentClassCodeSequence";
        dict[0x0040E010UL] =  "UTRetrieveURI";
        dict[0x0040E011UL] =  "UIRetrieveLocationUID";
        dict[0x0040E020UL] =  "CSTypeOfInstances";
        dict[0x0040E021UL] =  "SQDICOMRetrievalSequence";
        dict[0x0040E022UL] =  "SQDICOMMediaRetrievalSequence";
        dict[0x0040E023UL] =  "SQWADORetrievalSequence";
        dict[0x0040E024UL] =  "SQXDSRetrievalSequence";
        dict[0x0040E030UL] =  "UIRepositoryUniqueID";
        dict[0x0040E031UL] =  "UIHomeCommunityID";
        dict[0x00420010UL] =  "STDocumentTitle";
        dict[0x00420011UL] =  "OBEncapsulatedDocument";
        dict[0x00420012UL] =  "LOMIMETypeOfEncapsulatedDocument";
        dict[0x00420013UL] =  "SQSourceInstanceSequence";
        dict[0x00420014UL] =  "LOListOfMIMETypes";
        dict[0x00440001UL] =  "STProductPackageIdentifier";
        dict[0x00440002UL] =  "CSSubstanceAdministrationApproval";
        dict[0x00440003UL] =  "LTApprovalStatusFurtherDescription";
        dict[0x00440004UL] =  "DTApprovalStatusDateTime";
        dict[0x00440007UL] =  "SQProductTypeCodeSequence";
        dict[0x00440008UL] =  "LOProductName";
        dict[0x00440009UL] =  "LTProductDescription";
        dict[0x0044000AUL] =  "LOProductLotIdentifier";
        dict[0x0044000BUL] =  "DTProductExpirationDateTime";
        dict[0x00440010UL] =  "DTSubstanceAdministrationDateTime";
        dict[0x00440011UL] =  "LOSubstanceAdministrationNotes";
        dict[0x00440012UL] =  "LOSubstanceAdministrationDeviceID";
        dict[0x00440013UL] =  "SQProductParameterSequence";
        dict[0x00440019UL] =  "SQSubstanceAdministrationParameterSequence";
        dict[0x00460012UL] =  "LOLensDescription";
        dict[0x00460014UL] =  "SQRightLensSequence";
        dict[0x00460015UL] =  "SQLeftLensSequence";
        dict[0x00460016UL] =  "SQUnspecifiedLateralityLensSequence";
        dict[0x00460018UL] =  "SQCylinderSequence";
        dict[0x00460028UL] =  "SQPrismSequence";
        dict[0x00460030UL] =  "FDHorizontalPrismPower";
        dict[0x00460032UL] =  "CSHorizontalPrismBase";
        dict[0x00460034UL] =  "FDVerticalPrismPower";
        dict[0x00460036UL] =  "CSVerticalPrismBase";
        dict[0x00460038UL] =  "CSLensSegmentType";
        dict[0x00460040UL] =  "FDOpticalTransmittance";
        dict[0x00460042UL] =  "FDChannelWidth";
        dict[0x00460044UL] =  "FDPupilSize";
        dict[0x00460046UL] =  "FDCornealSize";
        dict[0x00460050UL] =  "SQAutorefractionRightEyeSequence";
        dict[0x00460052UL] =  "SQAutorefractionLeftEyeSequence";
        dict[0x00460060UL] =  "FDDistancePupillaryDistance";
        dict[0x00460062UL] =  "FDNearPupillaryDistance";
        dict[0x00460063UL] =  "FDIntermediatePupillaryDistance";
        dict[0x00460064UL] =  "FDOtherPupillaryDistance";
        dict[0x00460070UL] =  "SQKeratometryRightEyeSequence";
        dict[0x00460071UL] =  "SQKeratometryLeftEyeSequence";
        dict[0x00460074UL] =  "SQSteepKeratometricAxisSequence";
        dict[0x00460075UL] =  "FDRadiusOfCurvature";
        dict[0x00460076UL] =  "FDKeratometricPower";
        dict[0x00460077UL] =  "FDKeratometricAxis";
        dict[0x00460080UL] =  "SQFlatKeratometricAxisSequence";
        dict[0x00460092UL] =  "CSBackgroundColor";
        dict[0x00460094UL] =  "CSOptotype";
        dict[0x00460095UL] =  "CSOptotypePresentation";
        dict[0x00460097UL] =  "SQSubjectiveRefractionRightEyeSequence";
        dict[0x00460098UL] =  "SQSubjectiveRefractionLeftEyeSequence";
        dict[0x00460100UL] =  "SQAddNearSequence";
        dict[0x00460101UL] =  "SQAddIntermediateSequence";
        dict[0x00460102UL] =  "SQAddOtherSequence";
        dict[0x00460104UL] =  "FDAddPower";
        dict[0x00460106UL] =  "FDViewingDistance";
        dict[0x00460121UL] =  "SQVisualAcuityTypeCodeSequence";
        dict[0x00460122UL] =  "SQVisualAcuityRightEyeSequence";
        dict[0x00460123UL] =  "SQVisualAcuityLeftEyeSequence";
        dict[0x00460124UL] =  "SQVisualAcuityBothEyesOpenSequence";
        dict[0x00460125UL] =  "CSViewingDistanceType";
        dict[0x00460135UL] =  "SSVisualAcuityModifiers";
        dict[0x00460137UL] =  "FDDecimalVisualAcuity";
        dict[0x00460139UL] =  "LOOptotypeDetailedDefinition";
        dict[0x00460145UL] =  "SQReferencedRefractiveMeasurementsSequence";
        dict[0x00460146UL] =  "FDSpherePower";
        dict[0x00460147UL] =  "FDCylinderPower";
        dict[0x00480001UL] =  "FLImagedVolumeWidth";
        dict[0x00480002UL] =  "FLImagedVolumeHeight";
        dict[0x00480003UL] =  "FLImagedVolumeDepth";
        dict[0x00480006UL] =  "ULTotalPixelMatrixColumns";
        dict[0x00480007UL] =  "ULTotalPixelMatrixRows";
        dict[0x00480008UL] =  "SQTotalPixelMatrixOriginSequence";
        dict[0x00480010UL] =  "CSSpecimenLabelInImage";
        dict[0x00480011UL] =  "CSFocusMethod";
        dict[0x00480012UL] =  "CSExtendedDepthOfField";
        dict[0x00480013UL] =  "USNumberOfFocalPlanes";
        dict[0x00480014UL] =  "FLDistanceBetweenFocalPlanes";
        dict[0x00480015UL] =  "USRecommendedAbsentPixelCIELabValue";
        dict[0x00480100UL] =  "SQIlluminatorTypeCodeSequence";
        dict[0x00480102UL] =  "DSImageOrientationSlide";
        dict[0x00480105UL] =  "SQOpticalPathSequence";
        dict[0x00480106UL] =  "SHOpticalPathIdentifier";
        dict[0x00480107UL] =  "STOpticalPathDescription";
        dict[0x00480108UL] =  "SQIlluminationColorCodeSequence";
        dict[0x00480110UL] =  "SQSpecimenReferenceSequence";
        dict[0x00480111UL] =  "DSCondenserLensPower";
        dict[0x00480112UL] =  "DSObjectiveLensPower";
        dict[0x00480113UL] =  "DSObjectiveLensNumericalAperture";
        dict[0x00480120UL] =  "SQPaletteColorLookupTableSequence";
        dict[0x00480200UL] =  "SQReferencedImageNavigationSequence";
        dict[0x00480201UL] =  "USTopLeftHandCornerOfLocalizerArea";
        dict[0x00480202UL] =  "USBottomRightHandCornerOfLocalizerArea";
        dict[0x00480207UL] =  "SQOpticalPathIdentificationSequence";
        dict[0x0048021AUL] =  "SQPlanePositionSlideSequence";
        dict[0x0048021EUL] =  "SLRowPositionInTotalImagePixelMatrix";
        dict[0x0048021FUL] =  "SLColumnPositionInTotalImagePixelMatrix";
        dict[0x00480301UL] =  "CSPixelOriginInterpretation";
        dict[0x00500004UL] =  "CSCalibrationImage";
        dict[0x00500010UL] =  "SQDeviceSequence";
        dict[0x00500012UL] =  "SQContainerComponentTypeCodeSequence";
        dict[0x00500013UL] =  "FDContainerComponentThickness";
        dict[0x00500014UL] =  "DSDeviceLength";
        dict[0x00500015UL] =  "FDContainerComponentWidth";
        dict[0x00500016UL] =  "DSDeviceDiameter";
        dict[0x00500017UL] =  "CSDeviceDiameterUnits";
        dict[0x00500018UL] =  "DSDeviceVolume";
        dict[0x00500019UL] =  "DSInterMarkerDistance";
        dict[0x0050001AUL] =  "CSContainerComponentMaterial";
        dict[0x0050001BUL] =  "LOContainerComponentID";
        dict[0x0050001CUL] =  "FDContainerComponentLength";
        dict[0x0050001DUL] =  "FDContainerComponentDiameter";
        dict[0x0050001EUL] =  "LOContainerComponentDescription";
        dict[0x00500020UL] =  "LODeviceDescription";
        dict[0x00520001UL] =  "FLContrastBolusIngredientPercentByVolume";
        dict[0x00520002UL] =  "FDOCTFocalDistance";
        dict[0x00520003UL] =  "FDBeamSpotSize";
        dict[0x00520004UL] =  "FDEffectiveRefractiveIndex";
        dict[0x00520006UL] =  "CSOCTAcquisitionDomain";
        dict[0x00520007UL] =  "FDOCTOpticalCenterWavelength";
        dict[0x00520008UL] =  "FDAxialResolution";
        dict[0x00520009UL] =  "FDRangingDepth";
        dict[0x00520011UL] =  "FDALineRate";
        dict[0x00520012UL] =  "USALinesPerFrame";
        dict[0x00520013UL] =  "FDCatheterRotationalRate";
        dict[0x00520014UL] =  "FDALinePixelSpacing";
        dict[0x00520016UL] =  "SQModeOfPercutaneousAccessSequence";
        dict[0x00520025UL] =  "SQIntravascularOCTFrameTypeSequence";
        dict[0x00520026UL] =  "CSOCTZOffsetApplied";
        dict[0x00520027UL] =  "SQIntravascularFrameContentSequence";
        dict[0x00520028UL] =  "FDIntravascularLongitudinalDistance";
        dict[0x00520029UL] =  "SQIntravascularOCTFrameContentSequence";
        dict[0x00520030UL] =  "SSOCTZOffsetCorrection";
        dict[0x00520031UL] =  "CSCatheterDirectionOfRotation";
        dict[0x00520033UL] =  "FDSeamLineLocation";
        dict[0x00520034UL] =  "FDFirstALineLocation";
        dict[0x00520036UL] =  "USSeamLineIndex";
        dict[0x00520038UL] =  "USNumberOfPaddedAlines";
        dict[0x00520039UL] =  "CSInterpolationType";
        dict[0x0052003AUL] =  "CSRefractiveIndexApplied";
        dict[0x00540010UL] =  "USEnergyWindowVector";
        dict[0x00540011UL] =  "USNumberOfEnergyWindows";
        dict[0x00540012UL] =  "SQEnergyWindowInformationSequence";
        dict[0x00540013UL] =  "SQEnergyWindowRangeSequence";
        dict[0x00540014UL] =  "DSEnergyWindowLowerLimit";
        dict[0x00540015UL] =  "DSEnergyWindowUpperLimit";
        dict[0x00540016UL] =  "SQRadiopharmaceuticalInformationSequence";
        dict[0x00540017UL] =  "ISResidualSyringeCounts";
        dict[0x00540018UL] =  "SHEnergyWindowName";
        dict[0x00540020UL] =  "USDetectorVector";
        dict[0x00540021UL] =  "USNumberOfDetectors";
        dict[0x00540022UL] =  "SQDetectorInformationSequence";
        dict[0x00540030UL] =  "USPhaseVector";
        dict[0x00540031UL] =  "USNumberOfPhases";
        dict[0x00540032UL] =  "SQPhaseInformationSequence";
        dict[0x00540033UL] =  "USNumberOfFramesInPhase";
        dict[0x00540036UL] =  "ISPhaseDelay";
        dict[0x00540038UL] =  "ISPauseBetweenFrames";
        dict[0x00540039UL] =  "CSPhaseDescription";
        dict[0x00540050UL] =  "USRotationVector";
        dict[0x00540051UL] =  "USNumberOfRotations";
        dict[0x00540052UL] =  "SQRotationInformationSequence";
        dict[0x00540053UL] =  "USNumberOfFramesInRotation";
        dict[0x00540060UL] =  "USRRIntervalVector";
        dict[0x00540061UL] =  "USNumberOfRRIntervals";
        dict[0x00540062UL] =  "SQGatedInformationSequence";
        dict[0x00540063UL] =  "SQDataInformationSequence";
        dict[0x00540070UL] =  "USTimeSlotVector";
        dict[0x00540071UL] =  "USNumberOfTimeSlots";
        dict[0x00540072UL] =  "SQTimeSlotInformationSequence";
        dict[0x00540073UL] =  "DSTimeSlotTime";
        dict[0x00540080UL] =  "USSliceVector";
        dict[0x00540081UL] =  "USNumberOfSlices";
        dict[0x00540090UL] =  "USAngularViewVector";
        dict[0x00540100UL] =  "USTimeSliceVector";
        dict[0x00540101UL] =  "USNumberOfTimeSlices";
        dict[0x00540200UL] =  "DSStartAngle";
        dict[0x00540202UL] =  "CSTypeOfDetectorMotion";
        dict[0x00540210UL] =  "ISTriggerVector";
        dict[0x00540211UL] =  "USNumberOfTriggersInPhase";
        dict[0x00540220UL] =  "SQViewCodeSequence";
        dict[0x00540222UL] =  "SQViewModifierCodeSequence";
        dict[0x00540300UL] =  "SQRadionuclideCodeSequence";
        dict[0x00540302UL] =  "SQAdministrationRouteCodeSequence";
        dict[0x00540304UL] =  "SQRadiopharmaceuticalCodeSequence";
        dict[0x00540306UL] =  "SQCalibrationDataSequence";
        dict[0x00540308UL] =  "USEnergyWindowNumber";
        dict[0x00540400UL] =  "SHImageID";
        dict[0x00540410UL] =  "SQPatientOrientationCodeSequence";
        dict[0x00540412UL] =  "SQPatientOrientationModifierCodeSequence";
        dict[0x00540414UL] =  "SQPatientGantryRelationshipCodeSequence";
        dict[0x00540500UL] =  "CSSliceProgressionDirection";
        dict[0x00541000UL] =  "CSSeriesType";
        dict[0x00541001UL] =  "CSUnits";
        dict[0x00541002UL] =  "CSCountsSource";
        dict[0x00541004UL] =  "CSReprojectionMethod";
        dict[0x00541006UL] =  "CSSUVType";
        dict[0x00541100UL] =  "CSRandomsCorrectionMethod";
        dict[0x00541101UL] =  "LOAttenuationCorrectionMethod";
        dict[0x00541102UL] =  "CSDecayCorrection";
        dict[0x00541103UL] =  "LOReconstructionMethod";
        dict[0x00541104UL] =  "LODetectorLinesOfResponseUsed";
        dict[0x00541105UL] =  "LOScatterCorrectionMethod";
        dict[0x00541200UL] =  "DSAxialAcceptance";
        dict[0x00541201UL] =  "ISAxialMash";
        dict[0x00541202UL] =  "ISTransverseMash";
        dict[0x00541203UL] =  "DSDetectorElementSize";
        dict[0x00541210UL] =  "DSCoincidenceWindowWidth";
        dict[0x00541220UL] =  "CSSecondaryCountsType";
        dict[0x00541300UL] =  "DSFrameReferenceTime";
        dict[0x00541310UL] =  "ISPrimaryPromptsCountsAccumulated";
        dict[0x00541311UL] =  "ISSecondaryCountsAccumulated";
        dict[0x00541320UL] =  "DSSliceSensitivityFactor";
        dict[0x00541321UL] =  "DSDecayFactor";
        dict[0x00541322UL] =  "DSDoseCalibrationFactor";
        dict[0x00541323UL] =  "DSScatterFractionFactor";
        dict[0x00541324UL] =  "DSDeadTimeFactor";
        dict[0x00541330UL] =  "USImageIndex";
        dict[0x00603000UL] =  "SQHistogramSequence";
        dict[0x00603002UL] =  "USHistogramNumberOfBins";
        dict[0x00603004UL] =  "USHistogramFirstBinValue";
        dict[0x00603006UL] =  "USHistogramLastBinValue";
        dict[0x00603008UL] =  "USHistogramBinWidth";
        dict[0x00603010UL] =  "LOHistogramExplanation";
        dict[0x00603020UL] =  "ULHistogramData";
        dict[0x00620001UL] =  "CSSegmentationType";
        dict[0x00620002UL] =  "SQSegmentSequence";
        dict[0x00620003UL] =  "SQSegmentedPropertyCategoryCodeSequence";
        dict[0x00620004UL] =  "USSegmentNumber";
        dict[0x00620005UL] =  "LOSegmentLabel";
        dict[0x00620006UL] =  "STSegmentDescription";
        dict[0x00620008UL] =  "CSSegmentAlgorithmType";
        dict[0x00620009UL] =  "LOSegmentAlgorithmName";
        dict[0x0062000AUL] =  "SQSegmentIdentificationSequence";
        dict[0x0062000BUL] =  "USReferencedSegmentNumber";
        dict[0x0062000CUL] =  "USRecommendedDisplayGrayscaleValue";
        dict[0x0062000DUL] =  "USRecommendedDisplayCIELabValue";
        dict[0x0062000EUL] =  "USMaximumFractionalValue";
        dict[0x0062000FUL] =  "SQSegmentedPropertyTypeCodeSequence";
        dict[0x00620010UL] =  "CSSegmentationFractionalType";
        dict[0x00640002UL] =  "SQDeformableRegistrationSequence";
        dict[0x00640003UL] =  "UISourceFrameOfReferenceUID";
        dict[0x00640005UL] =  "SQDeformableRegistrationGridSequence";
        dict[0x00640007UL] =  "ULGridDimensions";
        dict[0x00640008UL] =  "FDGridResolution";
        dict[0x00640009UL] =  "OFVectorGridData";
        dict[0x0064000FUL] =  "SQPreDeformationMatrixRegistrationSequence";
        dict[0x00640010UL] =  "SQPostDeformationMatrixRegistrationSequence";
        dict[0x00660001UL] =  "ULNumberOfSurfaces";
        dict[0x00660002UL] =  "SQSurfaceSequence";
        dict[0x00660003UL] =  "ULSurfaceNumber";
        dict[0x00660004UL] =  "LTSurfaceComments";
        dict[0x00660009UL] =  "CSSurfaceProcessing";
        dict[0x0066000AUL] =  "FLSurfaceProcessingRatio";
        dict[0x0066000BUL] =  "LOSurfaceProcessingDescription";
        dict[0x0066000CUL] =  "FLRecommendedPresentationOpacity";
        dict[0x0066000DUL] =  "CSRecommendedPresentationType";
        dict[0x0066000EUL] =  "CSFiniteVolume";
        dict[0x00660010UL] =  "CSManifold";
        dict[0x00660011UL] =  "SQSurfacePointsSequence";
        dict[0x00660012UL] =  "SQSurfacePointsNormalsSequence";
        dict[0x00660013UL] =  "SQSurfaceMeshPrimitivesSequence";
        dict[0x00660015UL] =  "ULNumberOfSurfacePoints";
        dict[0x00660016UL] =  "OFPointCoordinatesData";
        dict[0x00660017UL] =  "FLPointPositionAccuracy";
        dict[0x00660018UL] =  "FLMeanPointDistance";
        dict[0x00660019UL] =  "FLMaximumPointDistance";
        dict[0x0066001AUL] =  "FLPointsBoundingBoxCoordinates";
        dict[0x0066001BUL] =  "FLAxisOfRotation";
        dict[0x0066001CUL] =  "FLCenterOfRotation";
        dict[0x0066001EUL] =  "ULNumberOfVectors";
        dict[0x0066001FUL] =  "USVectorDimensionality";
        dict[0x00660020UL] =  "FLVectorAccuracy";
        dict[0x00660021UL] =  "OFVectorCoordinateData";
        dict[0x00660023UL] =  "OWTrianglePointIndexList";
        dict[0x00660024UL] =  "OWEdgePointIndexList";
        dict[0x00660025UL] =  "OWVertexPointIndexList";
        dict[0x00660026UL] =  "SQTriangleStripSequence";
        dict[0x00660027UL] =  "SQTriangleFanSequence";
        dict[0x00660028UL] =  "SQLineSequence";
        dict[0x00660029UL] =  "OWPrimitivePointIndexList";
        dict[0x0066002AUL] =  "ULSurfaceCount";
        dict[0x0066002BUL] =  "SQReferencedSurfaceSequence";
        dict[0x0066002CUL] =  "ULReferencedSurfaceNumber";
        dict[0x0066002DUL] =  "SQSegmentSurfaceGenerationAlgorithmIdentificationSequence";
        dict[0x0066002EUL] =  "SQSegmentSurfaceSourceInstanceSequence";
        dict[0x0066002FUL] =  "SQAlgorithmFamilyCodeSequence";
        dict[0x00660030UL] =  "SQAlgorithmNameCodeSequence";
        dict[0x00660031UL] =  "LOAlgorithmVersion";
        dict[0x00660032UL] =  "LTAlgorithmParameters";
        dict[0x00660034UL] =  "SQFacetSequence";
        dict[0x00660035UL] =  "SQSurfaceProcessingAlgorithmIdentificationSequence";
        dict[0x00660036UL] =  "LOAlgorithmName";
        dict[0x00686210UL] =  "LOImplantSize";
        dict[0x00686221UL] =  "LOImplantTemplateVersion";
        dict[0x00686222UL] =  "SQReplacedImplantTemplateSequence";
        dict[0x00686223UL] =  "CSImplantType";
        dict[0x00686224UL] =  "SQDerivationImplantTemplateSequence";
        dict[0x00686225UL] =  "SQOriginalImplantTemplateSequence";
        dict[0x00686226UL] =  "DTEffectiveDateTime";
        dict[0x00686230UL] =  "SQImplantTargetAnatomySequence";
        dict[0x00686260UL] =  "SQInformationFromManufacturerSequence";
        dict[0x00686265UL] =  "SQNotificationFromManufacturerSequencerSequence";
        dict[0x00686270UL] =  "DTInformationIssueDateTime";
        dict[0x00686280UL] =  "STInformationSummary";
        dict[0x006862A0UL] =  "SQImplantRegulatoryDisapprovalCodeSequence";
        dict[0x006862A5UL] =  "FDOverallTemplateSpatialTolerance";
        dict[0x006862C0UL] =  "SQHPGLDocumentSequence";
        dict[0x006862D0UL] =  "USHPGLDocumentID";
        dict[0x006862D5UL] =  "LOHPGLDocumentLabel";
        dict[0x006862E0UL] =  "SQViewOrientationCodeSequence";
        dict[0x006862F0UL] =  "FDViewOrientationModifier";
        dict[0x006862F2UL] =  "FDHPGLDocumentScaling";
        dict[0x00686300UL] =  "OBHPGLDocument";
        dict[0x00686310UL] =  "USHPGLContourPenNumber";
        dict[0x00686320UL] =  "SQHPGLPenSequence";
        dict[0x00686330UL] =  "USHPGLPenNumber";
        dict[0x00686340UL] =  "LOHPGLPenLabel";
        dict[0x00686345UL] =  "STHPGLPenDescription";
        dict[0x00686346UL] =  "FDRecommendedRotationPoint";
        dict[0x00686347UL] =  "FDBoundingRectangle";
        dict[0x00686350UL] =  "USImplantTemplate3DModelSurfaceNumber";
        dict[0x00686360UL] =  "SQSurfaceModelDescriptionSequence";
        dict[0x00686380UL] =  "LOSurfaceModelLabel";
        dict[0x00686390UL] =  "FDSurfaceModelScalingFactor";
        dict[0x006863A0UL] =  "SQMaterialsCodeSequence";
        dict[0x006863A4UL] =  "SQCoatingMaterialsCodeSequence";
        dict[0x006863A8UL] =  "SQImplantTypeCodeSequence";
        dict[0x006863ACUL] =  "SQFixationMethodCodeSequence";
        dict[0x006863B0UL] =  "SQMatingFeatureSetsSequence";
        dict[0x006863C0UL] =  "USMatingFeatureSetID";
        dict[0x006863D0UL] =  "LOMatingFeatureSetLabel";
        dict[0x006863E0UL] =  "SQMatingFeatureSequence";
        dict[0x006863F0UL] =  "USMatingFeatureID";
        dict[0x00686400UL] =  "SQMatingFeatureDegreeOfFreedomSequence";
        dict[0x00686410UL] =  "USDegreeOfFreedomID";
        dict[0x00686420UL] =  "CSDegreeOfFreedomType";
        dict[0x00686430UL] =  "SQTwoDMatingFeatureCoordinatesSequence";
        dict[0x00686440UL] =  "USReferencedHPGLDocumentID";
        dict[0x00686450UL] =  "FDTwoDMatingPoint";
        dict[0x00686460UL] =  "FDTwoDMatingAxes";
        dict[0x00686470UL] =  "SQTwoDDegreeOfFreedomSequence";
        dict[0x00686490UL] =  "FDThreeDDegreeOfFreedomAxis";
        dict[0x006864A0UL] =  "FDRangeOfFreedom";
        dict[0x006864C0UL] =  "FDThreeDMatingPoint";
        dict[0x006864D0UL] =  "FDThreeDMatingAxes";
        dict[0x006864F0UL] =  "FDTwoDDegreeOfFreedomAxis";
        dict[0x00686500UL] =  "SQPlanningLandmarkPointSequence";
        dict[0x00686510UL] =  "SQPlanningLandmarkLineSequence";
        dict[0x00686520UL] =  "SQPlanningLandmarkPlaneSequence";
        dict[0x00686530UL] =  "USPlanningLandmarkID";
        dict[0x00686540UL] =  "LOPlanningLandmarkDescription";
        dict[0x00686545UL] =  "SQPlanningLandmarkIdentificationCodeSequence";
        dict[0x00686550UL] =  "SQTwoDPointCoordinatesSequence";
        dict[0x00686560UL] =  "FDTwoDPointCoordinates";
        dict[0x00686590UL] =  "FDThreeDPointCoordinates";
        dict[0x006865A0UL] =  "SQTwoDLineCoordinatesSequence";
        dict[0x006865B0UL] =  "FDTwoDLineCoordinates";
        dict[0x006865D0UL] =  "FDThreeDLineCoordinates";
        dict[0x006865E0UL] =  "SQTwoDPlaneCoordinatesSequence";
        dict[0x006865F0UL] =  "FDTwoDPlaneIntersection";
        dict[0x00686610UL] =  "FDThreeDPlaneOrigin";
        dict[0x00686620UL] =  "FDThreeDPlaneNormal";
        dict[0x00700001UL] =  "SQGraphicAnnotationSequence";
        dict[0x00700002UL] =  "CSGraphicLayer";
        dict[0x00700003UL] =  "CSBoundingBoxAnnotationUnits";
        dict[0x00700004UL] =  "CSAnchorPointAnnotationUnits";
        dict[0x00700005UL] =  "CSGraphicAnnotationUnits";
        dict[0x00700006UL] =  "STUnformattedTextValue";
        dict[0x00700008UL] =  "SQTextObjectSequence";
        dict[0x00700009UL] =  "SQGraphicObjectSequence";
        dict[0x00700010UL] =  "FLBoundingBoxTopLeftHandCorner";
        dict[0x00700011UL] =  "FLBoundingBoxBottomRightHandCorner";
        dict[0x00700012UL] =  "CSBoundingBoxTextHorizontalJustification";
        dict[0x00700014UL] =  "FLAnchorPoint";
        dict[0x00700015UL] =  "CSAnchorPointVisibility";
        dict[0x00700020UL] =  "USGraphicDimensions";
        dict[0x00700021UL] =  "USNumberOfGraphicPoints";
        dict[0x00700022UL] =  "FLGraphicData";
        dict[0x00700023UL] =  "CSGraphicType";
        dict[0x00700024UL] =  "CSGraphicFilled";
        dict[0x00700041UL] =  "CSImageHorizontalFlip";
        dict[0x00700042UL] =  "USImageRotationCornerTrialandCornerTrial";
        dict[0x00700052UL] =  "SLDisplayedAreaTopLeftHandCorner";
        dict[0x00700053UL] =  "SLDisplayedAreaBottomRightHandCorner";
        dict[0x0070005AUL] =  "SQDisplayedAreaSelectionSequence";
        dict[0x00700060UL] =  "SQGraphicLayerSequence";
        dict[0x00700062UL] =  "ISGraphicLayerOrder";
        dict[0x00700066UL] =  "USGraphicLayerRecommendedDisplayGrayscaleValueDisplayRGBValue";
        dict[0x00700068UL] =  "LOGraphicLayerDescription";
        dict[0x00700080UL] =  "CSContentLabel";
        dict[0x00700081UL] =  "LOContentDescription";
        dict[0x00700082UL] =  "DAPresentationCreationDate";
        dict[0x00700083UL] =  "TMPresentationCreationTime";
        dict[0x00700084UL] =  "PNContentCreatorName";
        dict[0x00700086UL] =  "SQContentCreatorIdentificationCodeSequence";
        dict[0x00700087UL] =  "SQAlternateContentDescriptionSequence";
        dict[0x00700100UL] =  "CSPresentationSizeMode";
        dict[0x00700101UL] =  "DSPresentationPixelSpacing";
        dict[0x00700102UL] =  "ISPresentationPixelAspectRatio";
        dict[0x00700103UL] =  "FLPresentationPixelMagnificationRatio";
        dict[0x00700207UL] =  "LOGraphicGroupLabel";
        dict[0x00700208UL] =  "STGraphicGroupDescription";
        dict[0x00700209UL] =  "SQCompoundGraphicSequence";
        dict[0x00700226UL] =  "ULCompoundGraphicInstanceID";
        dict[0x00700227UL] =  "LOFontName";
        dict[0x00700228UL] =  "CSFontNameType";
        dict[0x00700229UL] =  "LOCSSFontName";
        dict[0x00700230UL] =  "FDRotationAngle";
        dict[0x00700231UL] =  "SQTextStyleSequence";
        dict[0x00700232UL] =  "SQLineStyleSequence";
        dict[0x00700233UL] =  "SQFillStyleSequence";
        dict[0x00700234UL] =  "SQGraphicGroupSequence";
        dict[0x00700241UL] =  "USTextColorCIELabValue";
        dict[0x00700242UL] =  "CSHorizontalAlignment";
        dict[0x00700243UL] =  "CSVerticalAlignment";
        dict[0x00700244UL] =  "CSShadowStyle";
        dict[0x00700245UL] =  "FLShadowOffsetX";
        dict[0x00700246UL] =  "FLShadowOffsetY";
        dict[0x00700247UL] =  "USShadowColorCIELabValue";
        dict[0x00700248UL] =  "CSUnderlined";
        dict[0x00700249UL] =  "CSBold";
        dict[0x00700250UL] =  "CSItalic";
        dict[0x00700251UL] =  "USPatternOnColorCIELabValue";
        dict[0x00700252UL] =  "USPatternOffColorCIELabValue";
        dict[0x00700253UL] =  "FLLineThickness";
        dict[0x00700254UL] =  "CSLineDashingStyle";
        dict[0x00700255UL] =  "ULLinePattern";
        dict[0x00700256UL] =  "OBFillPattern";
        dict[0x00700257UL] =  "CSFillMode";
        dict[0x00700258UL] =  "FLShadowOpacity";
        dict[0x00700261UL] =  "FLGapLength";
        dict[0x00700262UL] =  "FLDiameterOfVisibility";
        dict[0x00700273UL] =  "FLRotationPoint";
        dict[0x00700274UL] =  "CSTickAlignment";
        dict[0x00700278UL] =  "CSShowTickLabel";
        dict[0x00700279UL] =  "CSTickLabelAlignment";
        dict[0x00700282UL] =  "CSCompoundGraphicUnits";
        dict[0x00700284UL] =  "FLPatternOnOpacity";
        dict[0x00700285UL] =  "FLPatternOffOpacity";
        dict[0x00700287UL] =  "SQMajorTicksSequence";
        dict[0x00700288UL] =  "FLTickPosition";
        dict[0x00700289UL] =  "SHTickLabel";
        dict[0x00700294UL] =  "CSCompoundGraphicType";
        dict[0x00700295UL] =  "ULGraphicGroupID";
        dict[0x00700306UL] =  "CSShapeType";
        dict[0x00700308UL] =  "SQRegistrationSequence";
        dict[0x00700309UL] =  "SQMatrixRegistrationSequence";
        dict[0x0070030AUL] =  "SQMatrixSequence";
        dict[0x0070030CUL] =  "CSFrameOfReferenceTransformationMatrixType";
        dict[0x0070030DUL] =  "SQRegistrationTypeCodeSequence";
        dict[0x0070030FUL] =  "STFiducialDescription";
        dict[0x00700310UL] =  "SHFiducialIdentifier";
        dict[0x00700311UL] =  "SQFiducialIdentifierCodeSequence";
        dict[0x00700312UL] =  "FDContourUncertaintyRadius";
        dict[0x00700314UL] =  "SQUsedFiducialsSequence";
        dict[0x00700318UL] =  "SQGraphicCoordinatesDataSequence";
        dict[0x0070031AUL] =  "UIFiducialUID";
        dict[0x0070031CUL] =  "SQFiducialSetSequence";
        dict[0x0070031EUL] =  "SQFiducialSequence";
        dict[0x00700401UL] =  "USGraphicLayerRecommendedDisplayCIELabValue";
        dict[0x00700402UL] =  "SQBlendingSequence";
        dict[0x00700403UL] =  "FLRelativeOpacity";
        dict[0x00700404UL] =  "SQReferencedSpatialRegistrationSequence";
        dict[0x00700405UL] =  "CSBlendingPosition";
        dict[0x00720002UL] =  "SHHangingProtocolName";
        dict[0x00720004UL] =  "LOHangingProtocolDescription";
        dict[0x00720006UL] =  "CSHangingProtocolLevel";
        dict[0x00720008UL] =  "LOHangingProtocolCreator";
        dict[0x0072000AUL] =  "DTHangingProtocolCreationDateTime";
        dict[0x0072000CUL] =  "SQHangingProtocolDefinitionSequence";
        dict[0x0072000EUL] =  "SQHangingProtocolUserIdentificationCodeSequence";
        dict[0x00720010UL] =  "LOHangingProtocolUserGroupName";
        dict[0x00720012UL] =  "SQSourceHangingProtocolSequence";
        dict[0x00720014UL] =  "USNumberOfPriorsReferenced";
        dict[0x00720020UL] =  "SQImageSetsSequence";
        dict[0x00720022UL] =  "SQImageSetSelectorSequence";
        dict[0x00720024UL] =  "CSImageSetSelectorUsageFlag";
        dict[0x00720026UL] =  "ATSelectorAttribute";
        dict[0x00720028UL] =  "USSelectorValueNumber";
        dict[0x00720030UL] =  "SQTimeBasedImageSetsSequence";
        dict[0x00720032UL] =  "USImageSetNumber";
        dict[0x00720034UL] =  "CSImageSetSelectorCategory";
        dict[0x00720038UL] =  "USRelativeTime";
        dict[0x0072003AUL] =  "CSRelativeTimeUnits";
        dict[0x0072003CUL] =  "SSAbstractPriorValue";
        dict[0x0072003EUL] =  "SQAbstractPriorCodeSequence";
        dict[0x00720040UL] =  "LOImageSetLabel";
        dict[0x00720050UL] =  "CSSelectorAttributeVR";
        dict[0x00720052UL] =  "ATSelectorSequencePointer";
        dict[0x00720054UL] =  "LOSelectorSequencePointerPrivateCreator";
        dict[0x00720056UL] =  "LOSelectorAttributePrivateCreator";
        dict[0x00720060UL] =  "ATSelectorATValue";
        dict[0x00720062UL] =  "CSSelectorCSValue";
        dict[0x00720064UL] =  "ISSelectorISValue";
        dict[0x00720066UL] =  "LOSelectorLOValue";
        dict[0x00720068UL] =  "LTSelectorLTValue";
        dict[0x0072006AUL] =  "PNSelectorPNValue";
        dict[0x0072006CUL] =  "SHSelectorSHValue";
        dict[0x0072006EUL] =  "STSelectorSTValue";
        dict[0x00720070UL] =  "UTSelectorUTValue";
        dict[0x00720072UL] =  "DSSelectorDSValue";
        dict[0x00720074UL] =  "FDSelectorFDValue";
        dict[0x00720076UL] =  "FLSelectorFLValue";
        dict[0x00720078UL] =  "ULSelectorULValue";
        dict[0x0072007AUL] =  "USSelectorUSValue";
        dict[0x0072007CUL] =  "SLSelectorSLValue";
        dict[0x0072007EUL] =  "SSSelectorSSValue";
        dict[0x00720080UL] =  "SQSelectorCodeSequenceValue";
        dict[0x00720100UL] =  "USNumberOfScreens";
        dict[0x00720102UL] =  "SQNominalScreenDefinitionSequence";
        dict[0x00720104UL] =  "USNumberOfVerticalPixels";
        dict[0x00720106UL] =  "USNumberOfHorizontalPixels";
        dict[0x00720108UL] =  "FDDisplayEnvironmentSpatialPosition";
        dict[0x0072010AUL] =  "USScreenMinimumGrayscaleBitDepth";
        dict[0x0072010CUL] =  "USScreenMinimumColorBitDepth";
        dict[0x0072010EUL] =  "USApplicationMaximumRepaintTime";
        dict[0x00720200UL] =  "SQDisplaySetsSequence";
        dict[0x00720202UL] =  "USDisplaySetNumber";
        dict[0x00720203UL] =  "LODisplaySetLabel";
        dict[0x00720204UL] =  "USDisplaySetPresentationGroup";
        dict[0x00720206UL] =  "LODisplaySetPresentationGroupDescription";
        dict[0x00720208UL] =  "CSPartialDataDisplayHandling";
        dict[0x00720210UL] =  "SQSynchronizedScrollingSequence";
        dict[0x00720212UL] =  "USDisplaySetScrollingGroup";
        dict[0x00720214UL] =  "SQNavigationIndicatorSequence";
        dict[0x00720216UL] =  "USNavigationDisplaySet";
        dict[0x00720218UL] =  "USReferenceDisplaySets";
        dict[0x00720300UL] =  "SQImageBoxesSequence";
        dict[0x00720302UL] =  "USImageBoxNumber";
        dict[0x00720304UL] =  "CSImageBoxLayoutType";
        dict[0x00720306UL] =  "USImageBoxTileHorizontalDimension";
        dict[0x00720308UL] =  "USImageBoxTileVerticalDimension";
        dict[0x00720310UL] =  "CSImageBoxScrollDirection";
        dict[0x00720312UL] =  "CSImageBoxSmallScrollType";
        dict[0x00720314UL] =  "USImageBoxSmallScrollAmount";
        dict[0x00720316UL] =  "CSImageBoxLargeScrollType";
        dict[0x00720318UL] =  "USImageBoxLargeScrollAmount";
        dict[0x00720320UL] =  "USImageBoxOverlapPriority";
        dict[0x00720330UL] =  "FDCineRelativeToRealTime";
        dict[0x00720400UL] =  "SQFilterOperationsSequence";
        dict[0x00720402UL] =  "CSFilterByCategory";
        dict[0x00720404UL] =  "CSFilterByAttributePresence";
        dict[0x00720406UL] =  "CSFilterByOperator";
        dict[0x00720420UL] =  "USStructuredDisplayBackgroundCIELabValue";
        dict[0x00720421UL] =  "USEmptyImageBoxCIELabValue";
        dict[0x00720422UL] =  "SQStructuredDisplayImageBoxSequence";
        dict[0x00720424UL] =  "SQStructuredDisplayTextBoxSequence";
        dict[0x00720427UL] =  "SQReferencedFirstFrameSequence";
        dict[0x00720430UL] =  "SQImageBoxSynchronizationSequence";
        dict[0x00720432UL] =  "USSynchronizedImageBoxList";
        dict[0x00720434UL] =  "CSTypeOfSynchronization";
        dict[0x00720500UL] =  "CSBlendingOperationType";
        dict[0x00720510UL] =  "CSReformattingOperationType";
        dict[0x00720512UL] =  "FDReformattingThickness";
        dict[0x00720514UL] =  "FDReformattingInterval";
        dict[0x00720516UL] =  "CSReformattingOperationInitialViewDirection";
        dict[0x00720520UL] =  "CSThreeDRenderingType";
        dict[0x00720600UL] =  "SQSortingOperationsSequence";
        dict[0x00720602UL] =  "CSSortByCategory";
        dict[0x00720604UL] =  "CSSortingDirection";
        dict[0x00720700UL] =  "CSDisplaySetPatientOrientation";
        dict[0x00720702UL] =  "CSVOIType";
        dict[0x00720704UL] =  "CSPseudoColorType";
        dict[0x00720705UL] =  "SQPseudoColorPaletteInstanceReferenceSequence";
        dict[0x00720706UL] =  "CSShowGrayscaleInverted";
        dict[0x00720710UL] =  "CSShowImageTrueSizeFlag";
        dict[0x00720712UL] =  "CSShowGraphicAnnotationFlag";
        dict[0x00720714UL] =  "CSShowPatientDemographicsFlag";
        dict[0x00720716UL] =  "CSShowAcquisitionTechniquesFlag";
        dict[0x00720717UL] =  "CSDisplaySetHorizontalJustification";
        dict[0x00720718UL] =  "CSDisplaySetVerticalJustification";
        dict[0x00740120UL] =  "FDContinuationStartMeterset";
        dict[0x00740121UL] =  "FDContinuationEndMeterset";
        dict[0x00741000UL] =  "CSProcedureStepState";
        dict[0x00741002UL] =  "SQProcedureStepProgressInformationSequence";
        dict[0x00741004UL] =  "DSProcedureStepProgress";
        dict[0x00741006UL] =  "STProcedureStepProgressDescription";
        dict[0x00741008UL] =  "SQProcedureStepCommunicationsURISequence";
        dict[0x0074100aUL] =  "STContactURI";
        dict[0x0074100cUL] =  "LOContactDisplayName";
        dict[0x0074100eUL] =  "SQProcedureStepDiscontinuationReasonCodeSequence";
        dict[0x00741020UL] =  "SQBeamTaskSequence";
        dict[0x00741022UL] =  "CSBeamTaskType";
        dict[0x00741026UL] =  "FDTableTopVerticalAdjustedPosition";
        dict[0x00741027UL] =  "FDTableTopLongitudinalAdjustedPosition";
        dict[0x00741028UL] =  "FDTableTopLateralAdjustedPosition";
        dict[0x0074102AUL] =  "FDPatientSupportAdjustedAngle";
        dict[0x0074102BUL] =  "FDTableTopEccentricAdjustedAngle";
        dict[0x0074102CUL] =  "FDTableTopPitchAdjustedAngle";
        dict[0x0074102DUL] =  "FDTableTopRollAdjustedAngle";
        dict[0x00741030UL] =  "SQDeliveryVerificationImageSequence";
        dict[0x00741032UL] =  "CSVerificationImageTiming";
        dict[0x00741034UL] =  "CSDoubleExposureFlag";
        dict[0x00741036UL] =  "CSDoubleExposureOrdering";
        dict[0x00741040UL] =  "RelatedReferenceRTImageSequenc";
        dict[0x00741042UL] =  "SQGeneralMachineVerificationSequence";
        dict[0x00741044UL] =  "SQConventionalMachineVerificationSequence";
        dict[0x00741046UL] =  "SQIonMachineVerificationSequence";
        dict[0x00741048UL] =  "SQFailedAttributesSequence";
        dict[0x0074104AUL] =  "SQOverriddenAttributesSequence";
        dict[0x0074104CUL] =  "SQConventionalControlPointVerificationSequence";
        dict[0x0074104EUL] =  "SQIonControlPointVerificationSequence";
        dict[0x00741050UL] =  "SQAttributeOccurrenceSequence";
        dict[0x00741052UL] =  "ATAttributeOccurrencePointer";
        dict[0x00741054UL] =  "ULAttributeItemSelector";
        dict[0x00741056UL] =  "LOAttributeOccurrencePrivateCreator";
        dict[0x00741057UL] =  "ISSelectorSequencePointerItems";
        dict[0x00741200UL] =  "CSScheduledProcedureStepPriority";
        dict[0x00741202UL] =  "LOWorklistLabel";
        dict[0x00741204UL] =  "LOProcedureStepLabel";
        dict[0x00741210UL] =  "SQScheduledProcessingParametersSequence";
        dict[0x00741212UL] =  "SQPerformedProcessingParametersSequence";
        dict[0x00741216UL] =  "SQUnifiedProcedureStepPerformedProcedureSequence";
        dict[0x00741224UL] =  "SQReplacedProcedureStepSequence";
        dict[0x00741230UL] =  "LODeletionLock";
        dict[0x00741234UL] =  "AEReceivingAE";
        dict[0x00741236UL] =  "AERequestingAE";
        dict[0x00741238UL] =  "LTReasonForCancellation";
        dict[0x00741242UL] =  "CSSCPStatus";
        dict[0x00741244UL] =  "CSSubscriptionListStatus";
        dict[0x00741246UL] =  "CSUnifiedProcedureStepListStatus";
        dict[0x00741324UL] =  "ULBeamOrderIndex";
        dict[0x00741338UL] =  "FDDoubleExposureMeterset";
        dict[0x0074133AUL] =  "FDDoubleExposureFieldDelta";
        dict[0x00760001UL] =  "LOImplantAssemblyTemplateName";
        dict[0x00760003UL] =  "LOImplantAssemblyTemplateIssuer";
        dict[0x00760006UL] =  "LOImplantAssemblyTemplateVersion";
        dict[0x00760008UL] =  "SQReplacedImplantAssemblyTemplateSequence";
        dict[0x0076000AUL] =  "CSImplantAssemblyTemplateType";
        dict[0x0076000CUL] =  "SQOriginalImplantAssemblyTemplateSequence";
        dict[0x0076000EUL] =  "SQDerivationImplantAssemblyTemplateSequence";
        dict[0x00760010UL] =  "SQImplantAssemblyTemplateTargetAnatomySequence";
        dict[0x00760020UL] =  "SQProcedureTypeCodeSequence";
        dict[0x00760030UL] =  "LOSurgicalTechnique";
        dict[0x00760032UL] =  "SQComponentTypesSequence";
        dict[0x00760034UL] =  "CSComponentTypeCodeSequence";
        dict[0x00760036UL] =  "CSExclusiveComponentType";
        dict[0x00760038UL] =  "CSMandatoryComponentType";
        dict[0x00760040UL] =  "SQComponentSequence";
        dict[0x00760055UL] =  "USComponentID";
        dict[0x00760060UL] =  "SQComponentAssemblySequence";
        dict[0x00760070UL] =  "USComponent1ReferencedID";
        dict[0x00760080UL] =  "USComponent1ReferencedMatingFeatureSetID";
        dict[0x00760090UL] =  "USComponent1ReferencedMatingFeatureID";
        dict[0x007600A0UL] =  "USComponent2ReferencedID";
        dict[0x007600B0UL] =  "USComponent2ReferencedMatingFeatureSetID";
        dict[0x007600C0UL] =  "USComponent2ReferencedMatingFeatureID";
        dict[0x00780001UL] =  "LOImplantTemplateGroupName";
        dict[0x00780010UL] =  "STImplantTemplateGroupDescription";
        dict[0x00780020UL] =  "LOImplantTemplateGroupIssuer";
        dict[0x00780024UL] =  "LOImplantTemplateGroupVersion";
        dict[0x00780026UL] =  "SQReplacedImplantTemplateGroupSequence";
        dict[0x00780028UL] =  "SQImplantTemplateGroupTargetAnatomySequence";
        dict[0x0078002AUL] =  "SQImplantTemplateGroupMembersSequence";
        dict[0x0078002EUL] =  "USImplantTemplateGroupMemberID";
        dict[0x00780050UL] =  "FDThreeDImplantTemplateGroupMemberMatchingPoint";
        dict[0x00780060UL] =  "FDThreeDImplantTemplateGroupMemberMatchingAxes";
        dict[0x00780070UL] =  "SQImplantTemplateGroupMemberMatching2DCoordinatesSequence";
        dict[0x00780090UL] =  "FDTwoDImplantTemplateGroupMemberMatchingPoint";
        dict[0x007800A0UL] =  "FDTwoDImplantTemplateGroupMemberMatchingAxes";
        dict[0x007800B0UL] =  "SQImplantTemplateGroupVariationDimensionSequence";
        dict[0x007800B2UL] =  "LOImplantTemplateGroupVariationDimensionName";
        dict[0x007800B4UL] =  "SQImplantTemplateGroupVariationDimensionRankSequence";
        dict[0x007800B6UL] =  "USReferencedImplantTemplateGroupMemberID";
        dict[0x007800B8UL] =  "USImplantTemplateGroupVariationDimensionRank";
        dict[0x00880130UL] =  "SHStorageMediaFileSetID";
        dict[0x00880140UL] =  "UIStorageMediaFileSetUID";
        dict[0x00880200UL] =  "SQIconImageSequence";
        dict[0x01000410UL] =  "CSSOPInstanceStatus";
        dict[0x01000420UL] =  "DTSOPAuthorizationDateTime";
        dict[0x01000424UL] =  "LTSOPAuthorizationComment";
        dict[0x01000426UL] =  "LOAuthorizationEquipmentCertificationNumber";
        dict[0x04000005UL] =  "USMACIDNumber";
        dict[0x04000010UL] =  "UIMACCalculationTransferSyntaxUID";
        dict[0x04000015UL] =  "CSMACAlgorithm";
        dict[0x04000020UL] =  "ATDataElementsSigned";
        dict[0x04000100UL] =  "UIDigitalSignatureUID";
        dict[0x04000105UL] =  "DTDigitalSignatureDateTime";
        dict[0x04000110UL] =  "CSCertificateType";
        dict[0x04000115UL] =  "OBCertificateOfSigner";
        dict[0x04000120UL] =  "OBSignature";
        dict[0x04000305UL] =  "CSCertifiedTimestampType";
        dict[0x04000310UL] =  "OBCertifiedTimestamp";
        dict[0x04000401UL] =  "SQDigitalSignaturePurposeCodeSequence";
        dict[0x04000402UL] =  "SQReferencedDigitalSignatureSequence";
        dict[0x04000403UL] =  "SQReferencedSOPInstanceMACSequence";
        dict[0x04000404UL] =  "OBMAC";
        dict[0x04000500UL] =  "SQEncryptedAttributesSequence";
        dict[0x04000510UL] =  "UIEncryptedContentTransferSyntaxUID";
        dict[0x04000520UL] =  "OBEncryptedContent";
        dict[0x04000550UL] =  "SQModifiedAttributesSequence";
        dict[0x04000561UL] =  "SQOriginalAttributesSequence";
        dict[0x04000562UL] =  "DTAttributeModificationDateTime";
        dict[0x04000563UL] =  "LOModifyingSystem";
        dict[0x04000564UL] =  "LOSourceOfPreviousValuesReasonForTheAttributeModif";
        dict[0x04000565UL] =  "icationCS";
        dict[0x20000010UL] =  "ISNumberOfCopies";
        dict[0x2000001EUL] =  "SQPrinterConfigurationSequence";
        dict[0x20000020UL] =  "CSPrintPriority";
        dict[0x20000030UL] =  "CSMediumType";
        dict[0x20000040UL] =  "CSFilmDestination";
        dict[0x20000050UL] =  "LOFilmSessionLabel";
        dict[0x20000060UL] =  "ISMemoryAllocation";
        dict[0x20000061UL] =  "ISMaximumMemoryAllocationag";
        dict[0x200000A0UL] =  "USMemoryBitDepth";
        dict[0x200000A1UL] =  "USPrintingBitDepth";
        dict[0x200000A2UL] =  "SQMediaInstalledSequence";
        dict[0x200000A4UL] =  "SQOtherMediaAvailableSequence";
        dict[0x200000A8UL] =  "SQSupportedImageDisplayFormatsSequence";
        dict[0x20000500UL] =  "SQReferencedFilmBoxSequenceence";
        dict[0x20100010UL] =  "STImageDisplayFormat";
        dict[0x20100030UL] =  "CSAnnotationDisplayFormatID";
        dict[0x20100040UL] =  "CSFilmOrientation";
        dict[0x20100050UL] =  "CSFilmSizeID";
        dict[0x20100052UL] =  "CSPrinterResolutionID";
        dict[0x20100054UL] =  "CSDefaultPrinterResolutionID";
        dict[0x20100060UL] =  "CSMagnificationType";
        dict[0x20100080UL] =  "CSSmoothingType";
        dict[0x201000A6UL] =  "CSDefaultMagnificationType";
        dict[0x201000A7UL] =  "CSOtherMagnificationTypesAvailable";
        dict[0x201000A8UL] =  "CSDefaultSmoothingType";
        dict[0x201000A9UL] =  "CSOtherSmoothingTypesAvailable";
        dict[0x20100100UL] =  "CSBorderDensity";
        dict[0x20100110UL] =  "CSEmptyImageDensity";
        dict[0x20100120UL] =  "USMinDensity";
        dict[0x20100130UL] =  "USMaxDensity";
        dict[0x20100140UL] =  "CSTrim";
        dict[0x20100150UL] =  "STConfigurationInformation";
        dict[0x20100152UL] =  "LTConfigurationInformationDescription";
        dict[0x20100154UL] =  "ISMaximumCollatedFilms";
        dict[0x2010015EUL] =  "USIllumination";
        dict[0x20100160UL] =  "USReflectedAmbientLight";
        dict[0x20100376UL] =  "DSPrinterPixelSpacing";
        dict[0x20100500UL] =  "SQReferencedFilmSessionSequence";
        dict[0x20100510UL] =  "SQReferencedImageBoxSequence";
        dict[0x20100520UL] =  "SQReferencedBasicAnnotationBoxSequence";
        dict[0x20200010UL] =  "USImageBoxPosition";
        dict[0x20200020UL] =  "CSPolarity";
        dict[0x20200030UL] =  "DSRequestedImageSize";
        dict[0x20200040UL] =  "CSRequestedDecimateCropBehavior";
        dict[0x20200050UL] =  "CSRequestedResolutionID";
        dict[0x202000A0UL] =  "CSRequestedImageSizeFlag";
        dict[0x202000A2UL] =  "CSDecimateCropResult";
        dict[0x20200110UL] =  "SQBasicGrayscaleImageSequence";
        dict[0x20200111UL] =  "SQBasicColorImageSequencexSequenceence";
        dict[0x20300010UL] =  "USAnnotationPosition";
        dict[0x20300020UL] =  "LOTextString";
        dict[0x20500010UL] =  "SQPresentationLUTSequence";
        dict[0x20500020UL] =  "CSPresentationLUTShape";
        dict[0x20500500UL] =  "SQReferencedPresentationLUTSequence";
        dict[0x21000020UL] =  "CSExecutionStatus";
        dict[0x21000030UL] =  "CSExecutionStatusInfo";
        dict[0x21000040UL] =  "DACreationDate";
        dict[0x21000050UL] =  "TMCreationTime";
        dict[0x21000070UL] =  "AEOriginator";
        dict[0x21000160UL] =  "SHOwnerID";
        dict[0x21000170UL] =  "ISNumberOfFilmsePullStoredPrint";
        dict[0x21100010UL] =  "CSPrinterStatus";
        dict[0x21100020UL] =  "CSPrinterStatusInfo";
        dict[0x21100030UL] =  "LOPrinterNamesSequence";
        dict[0x22000001UL] =  "CSLabelUsingInformationExtractedFromInstances";
        dict[0x22000002UL] =  "UTLabelText";
        dict[0x22000003UL] =  "CSLabelStyleSelection";
        dict[0x22000004UL] =  "LTMediaDisposition";
        dict[0x22000005UL] =  "LTBarcodeValue";
        dict[0x22000006UL] =  "CSBarcodeSymbology";
        dict[0x22000007UL] =  "CSAllowMediaSplitting";
        dict[0x22000008UL] =  "CSIncludeNonDICOMObjects";
        dict[0x22000009UL] =  "CSIncludeDisplayApplication";
        dict[0x2200000AUL] =  "CSPreserveCompositeInstancesAfterMediaCreation";
        dict[0x2200000BUL] =  "USTotalNumberOfPiecesOfMediaCreated";
        dict[0x2200000CUL] =  "LORequestedMediaApplicationProfile";
        dict[0x2200000DUL] =  "SQReferencedStorageMediaSequence";
        dict[0x2200000EUL] =  "ATFailureAttributes";
        dict[0x2200000FUL] =  "CSAllowLossyCompression";
        dict[0x22000020UL] =  "CSRequestPriority";
        dict[0x30020002UL] =  "SHRTImageLabel";
        dict[0x30020003UL] =  "LORTImageName";
        dict[0x30020004UL] =  "STRTImageDescription";
        dict[0x3002000AUL] =  "CSReportedValuesOrigin";
        dict[0x3002000CUL] =  "CSRTImagePlane";
        dict[0x3002000DUL] =  "DSXRayImageReceptorTranslation";
        dict[0x3002000EUL] =  "DSXRayImageReceptorAngle";
        dict[0x30020010UL] =  "DSRTImageOrientation";
        dict[0x30020011UL] =  "DSImagePlanePixelSpacing";
        dict[0x30020012UL] =  "DSRTImagePosition";
        dict[0x30020020UL] =  "SHRadiationMachineName";
        dict[0x30020022UL] =  "DSRadiationMachineSAD";
        dict[0x30020024UL] =  "DSRadiationMachineSSD";
        dict[0x30020026UL] =  "DSRTImageSID";
        dict[0x30020028UL] =  "DSSourceToReferenceObjectDistance";
        dict[0x30020029UL] =  "ISFractionNumber";
        dict[0x30020030UL] =  "SQExposureSequence";
        dict[0x30020032UL] =  "DSMetersetExposure";
        dict[0x30020034UL] =  "DSDiaphragmPosition";
        dict[0x30020040UL] =  "SQFluenceMapSequence";
        dict[0x30020041UL] =  "CSFluenceDataSource";
        dict[0x30020042UL] =  "DSFluenceDataScalePrimaryFluenceModeSeque";
        dict[0x30020050UL] =  "nceSQ";
        dict[0x30020051UL] =  "CSFluenceMode";
        dict[0x30020052UL] =  "SHFluenceModeID";
        dict[0x30040001UL] =  "CSDVHType";
        dict[0x30040002UL] =  "CSDoseUnits";
        dict[0x30040004UL] =  "CSDoseType";
        dict[0x30040006UL] =  "LODoseComment";
        dict[0x30040008UL] =  "DSNormalizationPoint";
        dict[0x3004000AUL] =  "CSDoseSummationType";
        dict[0x3004000CUL] =  "DSGridFrameOffsetVector";
        dict[0x3004000EUL] =  "DSDoseGridScaling";
        dict[0x30040010UL] =  "SQRTDoseROISequence";
        dict[0x30040012UL] =  "DSDoseValue";
        dict[0x30040014UL] =  "CSTissueHeterogeneityCorrection";
        dict[0x30040040UL] =  "DSDVHNormalizationPoint";
        dict[0x30040042UL] =  "DSDVHNormalizationDoseValue";
        dict[0x30040050UL] =  "SQDVHSequence";
        dict[0x30040052UL] =  "DSDVHDoseScaling";
        dict[0x30040054UL] =  "CSDVHVolumeUnits";
        dict[0x30040056UL] =  "ISDVHNumberOfBins";
        dict[0x30040058UL] =  "DSDVHData";
        dict[0x30040060UL] =  "SQDVHReferencedROISequence";
        dict[0x30040062UL] =  "CSDVHROIContributionType";
        dict[0x30040070UL] =  "DSDVHMinimumDose";
        dict[0x30040072UL] =  "DSDVHMaximumDose";
        dict[0x30040074UL] =  "DSDVHMeanDose";
        dict[0x30060002UL] =  "SHStructureSetLabel";
        dict[0x30060004UL] =  "LOStructureSetName";
        dict[0x30060006UL] =  "STStructureSetDescription";
        dict[0x30060008UL] =  "DAStructureSetDate";
        dict[0x30060009UL] =  "TMStructureSetTime";
        dict[0x30060010UL] =  "SQReferencedFrameOfReferenceSequence";
        dict[0x30060012UL] =  "SQRTReferencedStudySequence";
        dict[0x30060014UL] =  "SQRTReferencedSeriesSequence";
        dict[0x30060016UL] =  "SQContourImageSequence";
        dict[0x30060020UL] =  "SQStructureSetROISequence";
        dict[0x30060022UL] =  "ISROINumber";
        dict[0x30060024UL] =  "UIReferencedFrameOfReferenceUID";
        dict[0x30060026UL] =  "LOROIName";
        dict[0x30060028UL] =  "STROIDescription";
        dict[0x3006002AUL] =  "ISROIDisplayColor";
        dict[0x3006002CUL] =  "DSROIVolume";
        dict[0x30060030UL] =  "SQRTRelatedROISequence";
        dict[0x30060033UL] =  "CSRTROIRelationship";
        dict[0x30060036UL] =  "CSROIGenerationAlgorithm";
        dict[0x30060038UL] =  "LOROIGenerationDescription";
        dict[0x30060039UL] =  "SQROIContourSequence";
        dict[0x30060040UL] =  "SQContourSequence";
        dict[0x30060042UL] =  "CSContourGeometricType";
        dict[0x30060044UL] =  "DSContourSlabThickness";
        dict[0x30060045UL] =  "DSContourOffsetVector";
        dict[0x30060046UL] =  "ISNumberOfContourPoints";
        dict[0x30060048UL] =  "ISContourNumber";
        dict[0x30060049UL] =  "ISAttachedContours";
        dict[0x30060050UL] =  "DSContourData";
        dict[0x30060080UL] =  "SQRTROIObservationsSequence";
        dict[0x30060082UL] =  "ISObservationNumber";
        dict[0x30060084UL] =  "ISReferencedROINumber";
        dict[0x30060085UL] =  "SHROIObservationLabel";
        dict[0x30060086UL] =  "SQRTROIIdentificationCodeSequence";
        dict[0x30060088UL] =  "STROIObservationDescription";
        dict[0x300600A0UL] =  "SQRelatedRTROIObservationsSequence";
        dict[0x300600A4UL] =  "CSRTROIInterpretedType";
        dict[0x300600A6UL] =  "PNROIInterpreter";
        dict[0x300600B0UL] =  "SQROIPhysicalPropertiesSequence";
        dict[0x300600B2UL] =  "CSROIPhysicalProperty";
        dict[0x300600B4UL] =  "DSROIPhysicalPropertyValue";
        dict[0x300600B6UL] =  "SQROIElementalCompositionSequence";
        dict[0x300600B7UL] =  "USROIElementalCompositionAtomicNumber";
        dict[0x300600B8UL] =  "FLROIElementalCompositionAtomicMassFraction";
        dict[0x300600C0UL] =  "SQFrameOfReferenceRelationshipSequence";
        dict[0x300600C2UL] =  "UIRelatedFrameOfReferenceUID";
        dict[0x300600C4UL] =  "CSFrameOfReferenceTransformationType";
        dict[0x300600C6UL] =  "DSFrameOfReferenceTransformationMatrix";
        dict[0x300600C8UL] =  "LOFrameOfReferenceTransformationComment";
        dict[0x30080010UL] =  "SQMeasuredDoseReferenceSequence";
        dict[0x30080012UL] =  "STMeasuredDoseDescription";
        dict[0x30080014UL] =  "CSMeasuredDoseType";
        dict[0x30080016UL] =  "DSMeasuredDoseValue";
        dict[0x30080020UL] =  "SQTreatmentSessionBeamSequence";
        dict[0x30080022UL] =  "ISCurrentFractionNumber";
        dict[0x30080024UL] =  "DATreatmentControlPointDate";
        dict[0x30080025UL] =  "TMTreatmentControlPointTime";
        dict[0x3008002AUL] =  "CSTreatmentTerminationStatus";
        dict[0x3008002BUL] =  "SHTreatmentTerminationCode";
        dict[0x3008002CUL] =  "CSTreatmentVerificationStatus";
        dict[0x30080030UL] =  "SQReferencedTreatmentRecordSequence";
        dict[0x30080032UL] =  "DSSpecifiedPrimaryMeterset";
        dict[0x30080033UL] =  "DSSpecifiedSecondaryMeterset";
        dict[0x30080036UL] =  "DSDeliveredPrimaryMeterset";
        dict[0x30080037UL] =  "DSDeliveredSecondaryMeterset";
        dict[0x3008003AUL] =  "DSSpecifiedTreatmentTime";
        dict[0x3008003BUL] =  "DSDeliveredTreatmentTime";
        dict[0x30080040UL] =  "SQControlPointDeliverySequence";
        dict[0x30080042UL] =  "DSSpecifiedMeterset";
        dict[0x30080044UL] =  "DSDeliveredMeterset";
        dict[0x30080048UL] =  "DSDoseRateDelivered";
        dict[0x30080050UL] =  "SQTreatmentSummaryCalculatedDoseReferenceSequence";
        dict[0x30080052UL] =  "DSCumulativeDosetoDoseReference";
        dict[0x30080054UL] =  "DAFirstTreatmentDate";
        dict[0x30080056UL] =  "DAMostRecentTreatmentDate";
        dict[0x3008005AUL] =  "ISNumberofFractionsDelivered";
        dict[0x30080060UL] =  "SQOverrideSequence";
        dict[0x30080062UL] =  "ATOverrideParameterPointer";
        dict[0x30080064UL] =  "ISMeasuredDoseReferenceNumber";
        dict[0x30080066UL] =  "STOverrideReason";
        dict[0x30080070UL] =  "SQCalculatedDoseReferenceSequence";
        dict[0x30080072UL] =  "ISCalculatedDoseReferenceNumber";
        dict[0x30080074UL] =  "STCalculatedDoseReferenceDescription";
        dict[0x30080076UL] =  "DSCalculatedDoseReferenceDoseValue";
        dict[0x30080078UL] =  "DSStartMeterset";
        dict[0x3008007AUL] =  "DSEndMeterset";
        dict[0x30080080UL] =  "SQReferencedMeasuredDoseReferenceSequence";
        dict[0x30080082UL] =  "ISReferencedMeasuredDoseReferenceNumber";
        dict[0x30080090UL] =  "SQReferencedCalculatedDoseReferenceSequence";
        dict[0x30080092UL] =  "ISReferencedCalculatedDoseReferenceNumber";
        dict[0x300800A0UL] =  "SQBeamLimitingDeviceLeafPairsSequence";
        dict[0x300800B0UL] =  "SQRecordedWedgeSequence";
        dict[0x300800C0UL] =  "SQRecordedCompensatorSequence";
        dict[0x300800D0UL] =  "SQRecordedBlockSequence";
        dict[0x300800E0UL] =  "SQTreatmentSummaryMeasuredDoseReferenceSequence";
        dict[0x30080100UL] =  "SQRecordedSourceSequence";
        dict[0x30080105UL] =  "LOSourceSerialNumber";
        dict[0x30080110UL] =  "SQTreatmentSessionApplicationSetupSequence";
        dict[0x30080116UL] =  "CSApplicationSetupCheck";
        dict[0x30080120UL] =  "SQRecordedBrachyAccessoryDeviceSequence";
        dict[0x30080122UL] =  "ISReferencedBrachyAccessoryDeviceNumber";
        dict[0x30080130UL] =  "SQRecordedChannelSequence";
        dict[0x30080132UL] =  "DSSpecifiedChannelTotalTime";
        dict[0x30080134UL] =  "DSDeliveredChannelTotalTime";
        dict[0x30080136UL] =  "ISSpecifiedNumberofPulses";
        dict[0x30080138UL] =  "ISDeliveredNumberofPulses";
        dict[0x3008013AUL] =  "DSSpecifiedPulseRepetitionInterval";
        dict[0x3008013CUL] =  "DSDeliveredPulseRepetitionInterval";
        dict[0x30080140UL] =  "SQRecordedSourceApplicatorSequence";
        dict[0x30080142UL] =  "ISReferencedSourceApplicatorNumber";
        dict[0x30080150UL] =  "SQRecordedChannelShieldSequence";
        dict[0x30080152UL] =  "ISReferencedChannelShieldNumber";
        dict[0x30080160UL] =  "SQBrachyControlPointDeliveredSequence";
        dict[0x30080162UL] =  "DASafePositionExitDate";
        dict[0x30080164UL] =  "TMSafePositionExitTime";
        dict[0x30080166UL] =  "DASafePositionReturnDate";
        dict[0x30080168UL] =  "TMSafePositionReturnTime";
        dict[0x30080200UL] =  "CSCurrentTreatmentStatus";
        dict[0x30080202UL] =  "STTreatmentStatusComment";
        dict[0x30080220UL] =  "SQFractionGroupSummarySequence";
        dict[0x30080223UL] =  "ISReferencedFractionNumber";
        dict[0x30080224UL] =  "CSFractionGroupType";
        dict[0x30080230UL] =  "CSBeamStopperPosition";
        dict[0x30080240UL] =  "SQFractionStatusSummarySequence";
        dict[0x30080250UL] =  "DATreatmentDate";
        dict[0x30080251UL] =  "TMTreatmentTime";
        dict[0x300A0002UL] =  "SHRTPlanLabel";
        dict[0x300A0003UL] =  "LORTPlanName";
        dict[0x300A0004UL] =  "STRTPlanDescription";
        dict[0x300A0006UL] =  "DARTPlanDate";
        dict[0x300A0007UL] =  "TMRTPlanTime";
        dict[0x300A0009UL] =  "LOTreatmentProtocols";
        dict[0x300A000AUL] =  "CSPlanIntent";
        dict[0x300A000BUL] =  "LOTreatmentSites";
        dict[0x300A000CUL] =  "CSRTPlanGeometry";
        dict[0x300A000EUL] =  "STPrescriptionDescription";
        dict[0x300A0010UL] =  "SQDoseReferenceSequence";
        dict[0x300A0012UL] =  "ISDoseReferenceNumber";
        dict[0x300A0013UL] =  "UIDoseReferenceUID";
        dict[0x300A0014UL] =  "CSDoseReferenceStructureType";
        dict[0x300A0015UL] =  "CSNominalBeamEnergyUnit";
        dict[0x300A0016UL] =  "LODoseReferenceDescription";
        dict[0x300A0018UL] =  "DSDoseReferencePointCoordinates";
        dict[0x300A001AUL] =  "DSNominalPriorDose";
        dict[0x300A0020UL] =  "CSDoseReferenceType";
        dict[0x300A0021UL] =  "DSConstraintWeight";
        dict[0x300A0022UL] =  "DSDeliveryWarningDose";
        dict[0x300A0023UL] =  "DSDeliveryMaximumDose";
        dict[0x300A0025UL] =  "DSTargetMinimumDose";
        dict[0x300A0026UL] =  "DSTargetPrescriptionDose";
        dict[0x300A0027UL] =  "DSTargetMaximumDose";
        dict[0x300A0028UL] =  "DSTargetUnderdoseVolumeFraction";
        dict[0x300A002AUL] =  "DSOrganAtRiskFullVolumeDose";
        dict[0x300A002BUL] =  "DSOrganAtRiskLimitDose";
        dict[0x300A002CUL] =  "DSOrganAtRiskMaximumDose";
        dict[0x300A002DUL] =  "DSOrganAtRiskOverdoseVolumeFraction";
        dict[0x300A0040UL] =  "SQToleranceTableSequence";
        dict[0x300A0042UL] =  "ISToleranceTableNumber";
        dict[0x300A0043UL] =  "SHToleranceTableLabel";
        dict[0x300A0044UL] =  "DSGantryAngleTolerance";
        dict[0x300A0046UL] =  "DSBeamLimitingDeviceAngleTolerance";
        dict[0x300A0048UL] =  "SQBeamLimitingDeviceToleranceSequence";
        dict[0x300A004AUL] =  "DSBeamLimitingDevicePositionTolerance";
        dict[0x300A004BUL] =  "FLSnoutPositionTolerance";
        dict[0x300A004CUL] =  "DSPatientSupportAngleTolerance";
        dict[0x300A004EUL] =  "DSTableTopEccentricAngleTolerance";
        dict[0x300A004FUL] =  "FLTableTopPitchAngleTolerance";
        dict[0x300A0050UL] =  "FLTableTopRollAngleTolerance";
        dict[0x300A0051UL] =  "DSTableTopVerticalPositionTolerance";
        dict[0x300A0052UL] =  "DSTableTopLongitudinalPositionTolerance";
        dict[0x300A0053UL] =  "DSTableTopLateralPositionTolerance";
        dict[0x300A0055UL] =  "CSRTPlanRelationship";
        dict[0x300A0070UL] =  "SQFractionGroupSequence";
        dict[0x300A0071UL] =  "ISFractionGroupNumber";
        dict[0x300A0072UL] =  "LOFractionGroupDescription";
        dict[0x300A0078UL] =  "ISNumberOfFractionsPlanned";
        dict[0x300A0079UL] =  "ISNumberOfFractionPatternDigitsPerDay";
        dict[0x300A007AUL] =  "ISRepeatFractionCycleLength";
        dict[0x300A007BUL] =  "LTFractionPattern";
        dict[0x300A0080UL] =  "ISNumberOfBeams";
        dict[0x300A0082UL] =  "DSBeamDoseSpecificationPoint";
        dict[0x300A0084UL] =  "DSBeamDose";
        dict[0x300A0086UL] =  "DSBeamMeterset";
        dict[0x300A0088UL] =  "FLBeamDosePointDepth";
        dict[0x300A0089UL] =  "FLBeamDosePointEquivalentDepth";
        dict[0x300A008AUL] =  "FLBeamDosePointSSD";
        dict[0x300A00A0UL] =  "ISNumberOfBrachyApplicationSetups";
        dict[0x300A00A2UL] =  "DSBrachyApplicationSetupDoseSpecificationPoint";
        dict[0x300A00A4UL] =  "DSBrachyApplicationSetupDose";
        dict[0x300A00B0UL] =  "SQBeamSequence";
        dict[0x300A00B2UL] =  "SHTreatmentMachineName";
        dict[0x300A00B3UL] =  "CSPrimaryDosimeterUnit";
        dict[0x300A00B4UL] =  "DSSourceAxisDistance";
        dict[0x300A00B6UL] =  "SQBeamLimitingDeviceSequence";
        dict[0x300A00B8UL] =  "CSRTBeamLimitingDeviceType";
        dict[0x300A00BAUL] =  "DSSourceToBeamLimitingDeviceDistance";
        dict[0x300A00BBUL] =  "FLIsocenterToBeamLimitingDeviceDistance";
        dict[0x300A00BCUL] =  "ISNumberOfLeafJawPairs";
        dict[0x300A00BEUL] =  "DSLeafPositionBoundaries";
        dict[0x300A00C0UL] =  "ISBeamNumber";
        dict[0x300A00C2UL] =  "LOBeamName";
        dict[0x300A00C3UL] =  "STBeamDescription";
        dict[0x300A00C4UL] =  "CSBeamType";
        dict[0x300A00C6UL] =  "CSRadiationType";
        dict[0x300A00C7UL] =  "CSHighDoseTechniqueType";
        dict[0x300A00C8UL] =  "ISReferenceImageNumber";
        dict[0x300A00CAUL] =  "SQPlannedVerificationImageSequence";
        dict[0x300A00CCUL] =  "LOImagingDeviceSpecificAcquisitionParameters";
        dict[0x300A00CEUL] =  "CSTreatmentDeliveryType";
        dict[0x300A00D0UL] =  "ISNumberOfWedges";
        dict[0x300A00D1UL] =  "SQWedgeSequence";
        dict[0x300A00D2UL] =  "ISWedgeNumber";
        dict[0x300A00D3UL] =  "CSWedgeType";
        dict[0x300A00D4UL] =  "SHWedgeID";
        dict[0x300A00D5UL] =  "ISWedgeAngle";
        dict[0x300A00D6UL] =  "DSWedgeFactor";
        dict[0x300A00D7UL] =  "FLTotalWedgeTrayWaterEquivalentThickness";
        dict[0x300A00D8UL] =  "DSWedgeOrientation";
        dict[0x300A00D9UL] =  "FLIsocenterToWedgeTrayDistance";
        dict[0x300A00DAUL] =  "DSSourceToWedgeTrayDistance";
        dict[0x300A00DBUL] =  "FLWedgeThinEdgePosition";
        dict[0x300A00DCUL] =  "SHBolusID";
        dict[0x300A00DDUL] =  "STBolusDescription";
        dict[0x300A00E0UL] =  "ISNumberOfCompensators";
        dict[0x300A00E1UL] =  "SHMaterialID";
        dict[0x300A00E2UL] =  "DSTotalCompensatorTrayFactor";
        dict[0x300A00E3UL] =  "SQCompensatorSequence";
        dict[0x300A00E4UL] =  "ISCompensatorNumber";
        dict[0x300A00E5UL] =  "SHCompensatorID";
        dict[0x300A00E6UL] =  "DSSourceToCompensatorTrayDistance";
        dict[0x300A00E7UL] =  "ISCompensatorRows";
        dict[0x300A00E8UL] =  "ISCompensatorColumns";
        dict[0x300A00E9UL] =  "DSCompensatorPixelSpacing";
        dict[0x300A00EAUL] =  "DSCompensatorPosition";
        dict[0x300A00EBUL] =  "DSCompensatorTransmissionData";
        dict[0x300A00ECUL] =  "DSCompensatorThicknessData";
        dict[0x300A00EDUL] =  "ISNumberOfBoli";
        dict[0x300A00EEUL] =  "CSCompensatorType";
        dict[0x300A00F0UL] =  "ISNumberOfBlocks";
        dict[0x300A00F2UL] =  "DSTotalBlockTrayFactor";
        dict[0x300A00F3UL] =  "FLTotalBlockTrayWaterEquivalentThickness";
        dict[0x300A00F4UL] =  "SQBlockSequence";
        dict[0x300A00F5UL] =  "SHBlockTrayID";
        dict[0x300A00F6UL] =  "DSSourceToBlockTrayDistance";
        dict[0x300A00F7UL] =  "FLIsocenterToBlockTrayDistance";
        dict[0x300A00F8UL] =  "CSBlockType";
        dict[0x300A00F9UL] =  "LOAccessoryCode";
        dict[0x300A00FAUL] =  "CSBlockDivergence";
        dict[0x300A00FBUL] =  "CSBlockMountingPosition";
        dict[0x300A00FCUL] =  "ISBlockNumber";
        dict[0x300A00FEUL] =  "LOBlockName";
        dict[0x300A0100UL] =  "DSBlockThickness";
        dict[0x300A0102UL] =  "DSBlockTransmission";
        dict[0x300A0104UL] =  "ISBlockNumberOfPoints";
        dict[0x300A0106UL] =  "DSBlockData";
        dict[0x300A0107UL] =  "SQApplicatorSequence";
        dict[0x300A0108UL] =  "SHApplicatorID";
        dict[0x300A0109UL] =  "CSApplicatorType";
        dict[0x300A010AUL] =  "LOApplicatorDescription";
        dict[0x300A010CUL] =  "DSCumulativeDoseReferenceCoefficient";
        dict[0x300A010EUL] =  "DSFinalCumulativeMetersetWeight";
        dict[0x300A0110UL] =  "ISNumberOfControlPoints";
        dict[0x300A0111UL] =  "SQControlPointSequence";
        dict[0x300A0112UL] =  "ISControlPointIndex";
        dict[0x300A0114UL] =  "DSNominalBeamEnergy";
        dict[0x300A0115UL] =  "DSDoseRateSet";
        dict[0x300A0116UL] =  "SQWedgePositionSequence";
        dict[0x300A0118UL] =  "CSWedgePosition";
        dict[0x300A011AUL] =  "SQBeamLimitingDevicePositionSequence";
        dict[0x300A011CUL] =  "DSLeafJawPositions";
        dict[0x300A011EUL] =  "DSGantryAngle";
        dict[0x300A011FUL] =  "CSGantryRotationDirection";
        dict[0x300A0120UL] =  "DSBeamLimitingDeviceAngle";
        dict[0x300A0121UL] =  "CSBeamLimitingDeviceRotationDirection";
        dict[0x300A0122UL] =  "DSPatientSupportAngle";
        dict[0x300A0123UL] =  "CSPatientSupportRotationDirection";
        dict[0x300A0124UL] =  "DSTableTopEccentricAxisDistance";
        dict[0x300A0125UL] =  "DSTableTopEccentricAngle";
        dict[0x300A0126UL] =  "CSTableTopEccentricRotationDirection";
        dict[0x300A0128UL] =  "DSTableTopVerticalPosition";
        dict[0x300A0129UL] =  "DSTableTopLongitudinalPosition";
        dict[0x300A012AUL] =  "DSTableTopLateralPosition";
        dict[0x300A012CUL] =  "DSIsocenterPosition";
        dict[0x300A012EUL] =  "DSSurfaceEntryPoint";
        dict[0x300A0130UL] =  "DSSourceToSurfaceDistance";
        dict[0x300A0134UL] =  "DSCumulativeMetersetWeight";
        dict[0x300A0140UL] =  "FLTableTopPitchAngle";
        dict[0x300A0142UL] =  "CSTableTopPitchRotationDirection";
        dict[0x300A0144UL] =  "FLTableTopRollAngle";
        dict[0x300A0146UL] =  "CSTableTopRollRotationDirection";
        dict[0x300A0148UL] =  "FLHeadFixationAngle";
        dict[0x300A014AUL] =  "FLGantryPitchAngle";
        dict[0x300A014CUL] =  "CSGantryPitchRotationDirection";
        dict[0x300A014EUL] =  "FLGantryPitchAngleTolerance";
        dict[0x300A0180UL] =  "SQPatientSetupSequence";
        dict[0x300A0182UL] =  "ISPatientSetupNumber";
        dict[0x300A0183UL] =  "LOPatientSetupLabel";
        dict[0x300A0184UL] =  "LOPatientAdditionalPosition";
        dict[0x300A0190UL] =  "SQFixationDeviceSequence";
        dict[0x300A0192UL] =  "CSFixationDeviceType";
        dict[0x300A0194UL] =  "SHFixationDeviceLabel";
        dict[0x300A0196UL] =  "STFixationDeviceDescription";
        dict[0x300A0198UL] =  "SHFixationDevicePosition";
        dict[0x300A0199UL] =  "FLFixationDevicePitchAngle";
        dict[0x300A019AUL] =  "FLFixationDeviceRollAngle";
        dict[0x300A01A0UL] =  "SQShieldingDeviceSequence";
        dict[0x300A01A2UL] =  "CSShieldingDeviceType";
        dict[0x300A01A4UL] =  "SHShieldingDeviceLabel";
        dict[0x300A01A6UL] =  "STShieldingDeviceDescription";
        dict[0x300A01A8UL] =  "SHShieldingDevicePosition";
        dict[0x300A01B0UL] =  "CSSetupTechnique";
        dict[0x300A01B2UL] =  "STSetupTechniqueDescription";
        dict[0x300A01B4UL] =  "SQSetupDeviceSequence";
        dict[0x300A01B6UL] =  "CSSetupDeviceType";
        dict[0x300A01B8UL] =  "SHSetupDeviceLabel";
        dict[0x300A01BAUL] =  "STSetupDeviceDescription";
        dict[0x300A01BCUL] =  "DSSetupDeviceParameter";
        dict[0x300A01D0UL] =  "STSetupReferenceDescription";
        dict[0x300A01D2UL] =  "DSTableTopVerticalSetupDisplacement";
        dict[0x300A01D4UL] =  "DSTableTopLongitudinalSetupDisplacement";
        dict[0x300A01D6UL] =  "DSTableTopLateralSetupDisplacement";
        dict[0x300A0200UL] =  "CSBrachyTreatmentTechnique";
        dict[0x300A0202UL] =  "CSBrachyTreatmentType";
        dict[0x300A0206UL] =  "SQTreatmentMachineSequence";
        dict[0x300A0210UL] =  "SQSourceSequence";
        dict[0x300A0212UL] =  "ISSourceNumber";
        dict[0x300A0214UL] =  "CSSourceType";
        dict[0x300A0216UL] =  "LOSourceManufacturer";
        dict[0x300A0218UL] =  "DSActiveSourceDiameter";
        dict[0x300A021AUL] =  "DSActiveSourceLength";
        dict[0x300A0222UL] =  "DSSourceEncapsulationNominalThickness";
        dict[0x300A0224UL] =  "DSSourceEncapsulationNominalTransmission";
        dict[0x300A0226UL] =  "LOSourceIsotopeName";
        dict[0x300A0228UL] =  "DSSourceIsotopeHalfLife";
        dict[0x300A0229UL] =  "CSSourceStrengthUnits";
        dict[0x300A022AUL] =  "DSReferenceAirKermaRate";
        dict[0x300A022BUL] =  "DSSourceStrength";
        dict[0x300A022CUL] =  "DASourceStrengthReferenceDate";
        dict[0x300A022EUL] =  "TMSourceStrengthReferenceTime";
        dict[0x300A0230UL] =  "SQApplicationSetupSequence";
        dict[0x300A0232UL] =  "CSApplicationSetupType";
        dict[0x300A0234UL] =  "ISApplicationSetupNumber";
        dict[0x300A0236UL] =  "LOApplicationSetupName";
        dict[0x300A0238UL] =  "LOApplicationSetupManufacturer";
        dict[0x300A0240UL] =  "ISTemplateNumber";
        dict[0x300A0242UL] =  "SHTemplateType";
        dict[0x300A0244UL] =  "LOTemplateName";
        dict[0x300A0250UL] =  "DSTotalReferenceAirKerma";
        dict[0x300A0260UL] =  "SQBrachyAccessoryDeviceSequence";
        dict[0x300A0262UL] =  "ISBrachyAccessoryDeviceNumber";
        dict[0x300A0263UL] =  "SHBrachyAccessoryDeviceID";
        dict[0x300A0264UL] =  "CSBrachyAccessoryDeviceType";
        dict[0x300A0266UL] =  "LOBrachyAccessoryDeviceName";
        dict[0x300A026AUL] =  "DSBrachyAccessoryDeviceNominalThickness";
        dict[0x300A026CUL] =  "DSBrachyAccessoryDeviceNominalTransmission";
        dict[0x300A0280UL] =  "SQChannelSequence";
        dict[0x300A0282UL] =  "ISChannelNumber";
        dict[0x300A0284UL] =  "DSChannelLength";
        dict[0x300A0286UL] =  "DSChannelTotalTime";
        dict[0x300A0288UL] =  "CSSourceMovementType";
        dict[0x300A028AUL] =  "ISNumberOfPulses";
        dict[0x300A028CUL] =  "DSPulseRepetitionInterval";
        dict[0x300A0290UL] =  "ISSourceApplicatorNumber";
        dict[0x300A0291UL] =  "SHSourceApplicatorID";
        dict[0x300A0292UL] =  "CSSourceApplicatorType";
        dict[0x300A0294UL] =  "LOSourceApplicatorName";
        dict[0x300A0296UL] =  "DSSourceApplicatorLength";
        dict[0x300A0298UL] =  "LOSourceApplicatorManufacturer";
        dict[0x300A029CUL] =  "DSSourceApplicatorWallNominalThickness";
        dict[0x300A029EUL] =  "DSSourceApplicatorWallNominalTransmission";
        dict[0x300A02A0UL] =  "DSSourceApplicatorStepSize";
        dict[0x300A02A2UL] =  "ISTransferTubeNumber";
        dict[0x300A02A4UL] =  "DSTransferTubeLength";
        dict[0x300A02B0UL] =  "SQChannelShieldSequence";
        dict[0x300A02B2UL] =  "ISChannelShieldNumber";
        dict[0x300A02B3UL] =  "SHChannelShieldID";
        dict[0x300A02B4UL] =  "LOChannelShieldName";
        dict[0x300A02B8UL] =  "DSChannelShieldNominalThickness";
        dict[0x300A02BAUL] =  "DSChannelShieldNominalTransmission";
        dict[0x300A02C8UL] =  "DSFinalCumulativeTimeWeight";
        dict[0x300A02D0UL] =  "SQBrachyControlPointSequence";
        dict[0x300A02D2UL] =  "DSControlPointRelativePosition";
        dict[0x300A02D4UL] =  "DSControlPoint3DPosition";
        dict[0x300A02D6UL] =  "DSCumulativeTimeWeight";
        dict[0x300A02E0UL] =  "CSCompensatorDivergence";
        dict[0x300A02E1UL] =  "CSCompensatorMountingPosition";
        dict[0x300A02E2UL] =  "DSSourceToCompensatorDistance";
        dict[0x300A02E3UL] =  "FLTotalCompensatorTrayWaterEquivalentThicknessrEquivalentThickness";
        dict[0x300A02E4UL] =  "FLIsocenterToCompensatorTrayDistance";
        dict[0x300A02E5UL] =  "FLCompensatorColumnOffset";
        dict[0x300A02E6UL] =  "FLIsocenterToCompensatorDistances";
        dict[0x300A02E7UL] =  "FLCompensatorRelativeStoppingPowerRatio";
        dict[0x300A02E8UL] =  "FLCompensatorMillingToolDiameter";
        dict[0x300A02EAUL] =  "SQIonRangeCompensatorSequence";
        dict[0x300A02EBUL] =  "LTCompensatorDescription";
        dict[0x300A0302UL] =  "ISRadiationMassNumber";
        dict[0x300A0304UL] =  "ISRadiationAtomicNumber";
        dict[0x300A0306UL] =  "SSRadiationChargeState";
        dict[0x300A0308UL] =  "CSScanMode";
        dict[0x300A030AUL] =  "FLVirtualSourceAxisDistances";
        dict[0x300A030CUL] =  "SQSnoutSequence";
        dict[0x300A030DUL] =  "FLSnoutPosition";
        dict[0x300A030FUL] =  "SHSnoutID";
        dict[0x300A0312UL] =  "ISNumberOfRangeShifters";
        dict[0x300A0314UL] =  "SQRangeShifterSequence";
        dict[0x300A0316UL] =  "ISRangeShifterNumber";
        dict[0x300A0318UL] =  "SHRangeShifterID";
        dict[0x300A0320UL] =  "CSRangeShifterType";
        dict[0x300A0322UL] =  "LORangeShifterDescription";
        dict[0x300A0330UL] =  "ISNumberOfLateralSpreadingDevices";
        dict[0x300A0332UL] =  "SQLateralSpreadingDeviceSequence";
        dict[0x300A0334UL] =  "ISLateralSpreadingDeviceNumber";
        dict[0x300A0336UL] =  "SHLateralSpreadingDeviceID";
        dict[0x300A0338UL] =  "CSLateralSpreadingDeviceType";
        dict[0x300A033AUL] =  "LOLateralSpreadingDeviceDescription";
        dict[0x300A033CUL] =  "FLLateralSpreadingDeviceWaterEquivalentThickness";
        dict[0x300A0340UL] =  "ISNumberOfRangeModulators";
        dict[0x300A0342UL] =  "SQRangeModulatorSequence";
        dict[0x300A0344UL] =  "ISRangeModulatorNumber";
        dict[0x300A0346UL] =  "SHRangeModulatorID";
        dict[0x300A0348UL] =  "CSRangeModulatorType";
        dict[0x300A034AUL] =  "LORangeModulatorDescription";
        dict[0x300A034CUL] =  "SHBeamCurrentModulationID";
        dict[0x300A0350UL] =  "CSPatientSupportType";
        dict[0x300A0352UL] =  "SHPatientSupportID";
        dict[0x300A0354UL] =  "LOPatientSupportAccessoryCode";
        dict[0x300A0356UL] =  "FLFixationLightAzimuthalAngle";
        dict[0x300A0358UL] =  "FLFixationLightPolarAngle";
        dict[0x300A035AUL] =  "FLMetersetRate";
        dict[0x300A0360UL] =  "SQRangeShifterSettingsSequence";
        dict[0x300A0362UL] =  "LORangeShifterSetting";
        dict[0x300A0364UL] =  "FLIsocenterToRangeShifterDistance";
        dict[0x300A0366UL] =  "FLRangeShifterWaterEquivalentThickness";
        dict[0x300A0370UL] =  "SQLateralSpreadingDeviceSettingsSequence";
        dict[0x300A0372UL] =  "LOLateralSpreadingDeviceSetting";
        dict[0x300A0374UL] =  "FLIsocenterToLateralSpreadingDeviceDistance";
        dict[0x300A0380UL] =  "SQRangeModulatorSettingsSequence";
        dict[0x300A0382UL] =  "FLRangeModulatorGatingStartValue";
        dict[0x300A0384UL] =  "FLRangeModulatorGatingStopValue";
        dict[0x300A0386UL] =  "FLRangeModulatorGatingStartWaterEquivalentThickness";
        dict[0x300A0388UL] =  "FLRangeModulatorGatingStopWaterEquivalentThickness";
        dict[0x300A038AUL] =  "FLIsocenterToRangeModulatorDistance";
        dict[0x300A0390UL] =  "SHScanSpotTuneID";
        dict[0x300A0392UL] =  "ISNumberOfScanSpotPositions";
        dict[0x300A0394UL] =  "FLScanSpotPositionMap";
        dict[0x300A0396UL] =  "FLScanSpotMetersetWeights";
        dict[0x300A0398UL] =  "FLScanningSpotSize";
        dict[0x300A039AUL] =  "ISNumberOfPaintings";
        dict[0x300A03A0UL] =  "SQIonToleranceTableSequence";
        dict[0x300A03A2UL] =  "SQIonBeamSequence";
        dict[0x300A03A4UL] =  "SQIonBeamLimitingDeviceSequence";
        dict[0x300A03A6UL] =  "SQIonBlockSequence";
        dict[0x300A03A8UL] =  "SQIonControlPointSequence";
        dict[0x300A03AAUL] =  "SQIonWedgeSequence";
        dict[0x300A03ACUL] =  "SQIonWedgePositionSequence";
        dict[0x300A0401UL] =  "SQReferencedSetupImageSequence";
        dict[0x300A0402UL] =  "STSetupImageComment";
        dict[0x300A0410UL] =  "SQMotionSynchronizationSequence";
        dict[0x300A0412UL] =  "FLControlPointOrientation";
        dict[0x300A0420UL] =  "SQGeneralAccessorySequence";
        dict[0x300A0421UL] =  "SHGeneralAccessoryID";
        dict[0x300A0422UL] =  "STGeneralAccessoryDescription";
        dict[0x300A0423UL] =  "CSGeneralAccessoryType";
        dict[0x300A0424UL] =  "ISGeneralAccessoryNumber";
        dict[0x300A0431UL] =  "SQApplicatorGeometrySequence";
        dict[0x300A0432UL] =  "CSApplicatorApertureShape";
        dict[0x300A0433UL] =  "FLApplicatorOpening";
        dict[0x300A0434UL] =  "FLApplicatorOpeningX";
        dict[0x300A0435UL] =  "FLApplicatorOpeningY";
        dict[0x300A0436UL] =  "FLSourceToApplicatorMountingPositionDistance";
        dict[0x300C0002UL] =  "SQReferencedRTPlanSequence";
        dict[0x300C0004UL] =  "SQReferencedBeamSequence";
        dict[0x300C0006UL] =  "ISReferencedBeamNumber";
        dict[0x300C0007UL] =  "ISReferencedReferenceImageNumber";
        dict[0x300C0008UL] =  "DSStartCumulativeMetersetWeight";
        dict[0x300C0009UL] =  "DSEndCumulativeMetersetWeight";
        dict[0x300C000AUL] =  "SQReferencedBrachyApplicationSetupSequence";
        dict[0x300C000CUL] =  "ISReferencedBrachyApplicationSetupNumber";
        dict[0x300C000EUL] =  "ISReferencedSourceNumber";
        dict[0x300C0020UL] =  "SQReferencedFractionGroupSequence";
        dict[0x300C0022UL] =  "ISReferencedFractionGroupNumber";
        dict[0x300C0040UL] =  "SQReferencedVerificationImageSequence";
        dict[0x300C0042UL] =  "SQReferencedReferenceImageSequence";
        dict[0x300C0050UL] =  "SQReferencedDoseReferenceSequence";
        dict[0x300C0051UL] =  "ISReferencedDoseReferenceNumber";
        dict[0x300C0055UL] =  "SQBrachyReferencedDoseReferenceSequence";
        dict[0x300C0060UL] =  "SQReferencedStructureSetSequence";
        dict[0x300C006AUL] =  "ISReferencedPatientSetupNumber";
        dict[0x300C0080UL] =  "SQReferencedDoseSequence";
        dict[0x300C00A0UL] =  "ISReferencedToleranceTableNumber";
        dict[0x300C00B0UL] =  "SQReferencedBolusSequence";
        dict[0x300C00C0UL] =  "ISReferencedWedgeNumber";
        dict[0x300C00D0UL] =  "ISReferencedCompensatorNumber";
        dict[0x300C00E0UL] =  "ISReferencedBlockNumber";
        dict[0x300C00F0UL] =  "ISReferencedControlPointIndex";
        dict[0x300C00F2UL] =  "SQReferencedControlPointSequence";
        dict[0x300C00F4UL] =  "ISReferencedStartControlPointIndex";
        dict[0x300C00F6UL] =  "ISReferencedStopControlPointIndex";
        dict[0x300C0100UL] =  "ISReferencedRangeShifterNumber";
        dict[0x300C0102UL] =  "ISReferencedLateralSpreadingDeviceNumber";
        dict[0x300C0104UL] =  "ISReferencedRangeModulatorNumber";
        dict[0x300E0002UL] =  "CSApprovalStatus";
        dict[0x300E0004UL] =  "DAReviewDate";
        dict[0x300E0005UL] =  "TMReviewTime";
        dict[0x300E0008UL] =  "PNReviewerName";
        dict[0x40100001UL] =  "CSLowEnergyDetectors";
        dict[0x40100002UL] =  "CSHighEnergyDetectors";
        dict[0x40100004UL] =  "SQDetectorGeometrySequence";
        dict[0x40101001UL] =  "SQThreatROIVoxelSequence";
        dict[0x40101004UL] =  "FLThreatROIBase";
        dict[0x40101005UL] =  "FLThreatROIExtents";
        dict[0x40101006UL] =  "OBThreatROIBitmap";
        dict[0x40101007UL] =  "SHRouteSegmentID";
        dict[0x40101008UL] =  "CSGantryType";
        dict[0x40101009UL] =  "CSOOIOwnerType";
        dict[0x4010100AUL] =  "SQRouteSegmentSequence";
        dict[0x40101010UL] =  "USPotentialThreatObjectID";
        dict[0x40101011UL] =  "SQThreatSequence";
        dict[0x40101012UL] =  "CSThreatCategory";
        dict[0x40101013UL] =  "LTThreatCategoryDescription";
        dict[0x40101014UL] =  "CSATDAbilityAssessment";
        dict[0x40101015UL] =  "CSATDAssessmentFlag";
        dict[0x40101016UL] =  "FLATDAssessmentProbability";
        dict[0x40101017UL] =  "FLMass";
        dict[0x40101018UL] =  "FLDensity";
        dict[0x40101019UL] =  "FLZEffective";
        dict[0x4010101AUL] =  "SHBoardingPassID";
        dict[0x4010101BUL] =  "FLCenterOfMass";
        dict[0x4010101CUL] =  "FLCenterOfPTO";
        dict[0x4010101DUL] =  "FLBoundingPolygon";
        dict[0x4010101EUL] =  "SHRouteSegmentStartLocationID";
        dict[0x4010101FUL] =  "SHRouteSegmentEndLocationID";
        dict[0x40101020UL] =  "CSRouteSegmentLocationIDType";
        dict[0x40101021UL] =  "CSAbortReason";
        dict[0x40101023UL] =  "FLVolumeOfPTO";
        dict[0x40101024UL] =  "CSAbortFlag";
        dict[0x40101025UL] =  "DTRouteSegmentStartTime";
        dict[0x40101026UL] =  "DTRouteSegmentEndTime";
        dict[0x40101027UL] =  "CSTDRType";
        dict[0x40101028UL] =  "CSInternationalRouteSegment";
        dict[0x40101029UL] =  "LOThreatDetectionAlgorithmandVersion";
        dict[0x4010102AUL] =  "SHAssignedLocation";
        dict[0x4010102BUL] =  "DTAlarmDecisionTime";
        dict[0x40101031UL] =  "CSAlarmDecision";
        dict[0x40101033UL] =  "USNumberOfTotalObjects";
        dict[0x40101034UL] =  "USNumberOfAlarmObjects";
        dict[0x40101037UL] =  "SQPTORepresentationSequence";
        dict[0x40101038UL] =  "SQATDAssessmentSequence";
        dict[0x40101039UL] =  "CSTIPType";
        dict[0x4010103AUL] =  "CSDICOSVersion";
        dict[0x40101041UL] =  "DTOOIOwnerCreationTime";
        dict[0x40101042UL] =  "CSOOIType";
        dict[0x40101043UL] =  "FLOOISize";
        dict[0x40101044UL] =  "CSAcquisitionStatus";
        dict[0x40101045UL] =  "SQBasisMaterialsCodeSequence";
        dict[0x40101046UL] =  "CSPhantomType";
        dict[0x40101047UL] =  "SQOOIOwnerSequence";
        dict[0x40101048UL] =  "CSScanType";
        dict[0x40101051UL] =  "LOItineraryID";
        dict[0x40101052UL] =  "SHItineraryIDType";
        dict[0x40101053UL] =  "LOItineraryIDAssigningAuthority";
        dict[0x40101054UL] =  "SHRouteID";
        dict[0x40101055UL] =  "SHRouteIDAssigningAuthority";
        dict[0x40101056UL] =  "CSInboundArrivalType";
        dict[0x40101058UL] =  "SHCarrierID";
        dict[0x40101059UL] =  "CSCarrierIDAssigningAuthority";
        dict[0x40101060UL] =  "FLSourceOrientation";
        dict[0x40101061UL] =  "FLSourcePosition";
        dict[0x40101062UL] =  "FLBeltHeight";
        dict[0x40101064UL] =  "SQAlgorithmRoutingCodeSequence";
        dict[0x40101067UL] =  "CSTransportClassification";
        dict[0x40101068UL] =  "LTOOITypeDescriptor";
        dict[0x40101069UL] =  "FLTotalProcessingTime";
        dict[0x4010106CUL] =  "OBDetectorCalibrationData";
        dict[0x4FFE0001UL] =  "SQMACParametersSequence";
        dict[0x52009229UL] =  "SQSharedFunctionalGroupsSequence";
        dict[0x52009230UL] =  "SQPerFrameFunctionalGroupsSequence";
        dict[0x54000100UL] =  "SQWaveformSequence";
        dict[0x54000110UL] =  "OBChannelMinimumValue";
        dict[0x54000112UL] =  "OBChannelMaximumValue";
        dict[0x54001004UL] =  "USWaveformBitsAllocated";
        dict[0x54001006UL] =  "CSWaveformSampleInterpretation";
        dict[0x5400100AUL] =  "OBWaveformPaddingValue";
        dict[0x54001010UL] =  "OBWaveformData";
        dict[0x56000010UL] =  "OFFirstOrderPhaseCorrectionAngle";
        dict[0x56000020UL] =  "OFSpectroscopyData";
        dict[0x7FE00010UL] =  "OWPixelData";
        dict[0xFFFAFFFAUL] =  "SQDigitalSignaturesSequence";
        dict[0xFFFCFFFCUL] =  "OBDataSetTrailingPadding";
        dict[0xFFFEE000UL] =  "UNItem";
        dict[0xFFFEE00DUL] =  "UNItemDelimitationItem";
        dict[0xFFFEE0DDUL] =  "UNSequenceDelimitationItem";

      }
    }
  }
}

