/*
This file is part of Msc-generator.
Copyright (C) 2008-2021 Zoltan Turanyi
Distributed under GNU Affero General Public License.

Msc-generator is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Msc-generator is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with Msc-generator.  If not, see <http://www.gnu.org/licenses/>.
*/

/** @file commandline.h All that is needed to perform a command-line action.
* @ingroup libcgencommon_files  */

#if !defined(COMMANDLINE_H)
#define COMMANDLINE_H

#include <list>
#include <string>
#include <variant>
#include "version.h"
#include "cgencommon.h"

std::string VersionText(char a=LIBMSCGEN_MAJOR, char b = LIBMSCGEN_MINOR, char c = LIBMSCGEN_SUPERMINOR);
std::string ReadFile(FILE *in, bool till_zero=false);
std::string version(const LanguageCollection &languages);
std::string licence(const LanguageCollection &languages);

using LoadDataSet = std::map<std::string, std::string>;
/** Unpack the load data string by language type.*/
LoadDataSet SplitLoadData(std::string *load_data, MscError *Error=nullptr, const FileLineCol *opt_pos=nullptr);
/** Pack the updated load data back to a string.*/
std::string PackLoadData(const LoadDataSet &ldset);


/** A function that opens a text file of utf8 name. Returns nullptr if file not found. */
typedef FILE*(OpenNamedFileFunction)(const char*, bool, bool); //write, binary

struct GUIInit {
    LanguageCollection &languages;
    std::vector<std::pair<std::string, std::string>> &design_files;
    Chart::FileReadProcedure *file_read_proc = nullptr;
    void *file_read_proc_param = nullptr;
    OpenNamedFileFunction *file_open_proc = nullptr;
    std::string copyright_text;
    std::string file_to_open_path;
    std::string file_to_open_name;
    std::string type;
    std::string *load_data = nullptr;
    std::string settings_dir;
};


std::variant<int, GUIInit>
do_main(const std::vector<std::string> &args,
        LanguageCollection &languages,
        std::vector<std::pair<std::string, std::string>> &design_files,
        OpenNamedFileFunction ReadNamedFile,
        Chart::FileReadProcedure file_read_proc, void *file_read_proc_param,
        std::string csh_textformat,
        std::string settings_dir,
        bool display_only = false,
        ProgressBase::ProgressCallback cb = nullptr, void *param = nullptr,
        std::string *load_data = nullptr);

#endif /* COMMANDLINE_H */
