/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableCauseMatcher<T extends Throwable>
extends TypeSafeMatcher<T> {
    private final Matcher<T> fMatcher;

    public ThrowableCauseMatcher(Matcher<T> matcher) {
        this.fMatcher = matcher;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("exception with cause ");
        description.appendDescriptionOf(this.fMatcher);
    }

    @Override
    protected boolean matchesSafely(T item) {
        return this.fMatcher.matches(((Throwable)item).getCause());
    }

    @Override
    protected void describeMismatchSafely(T item, Description description) {
        description.appendText("cause ");
        this.fMatcher.describeMismatch(((Throwable)item).getCause(), description);
    }

    @Factory
    public static <T extends Throwable> Matcher<T> hasCause(Matcher<T> matcher) {
        return new ThrowableCauseMatcher<T>(matcher);
    }
}

