/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Color;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;
import org.netbeans.api.autoupdate.UpdateElement;

/**
 *
 * @author  Jiri Rechtacek
 */
public class ValidationWarningPanel extends javax.swing.JPanel {
    
    /** Creates new form ValidationWarningPanel */
    public ValidationWarningPanel (List<UpdateElement> signedVerified, List<UpdateElement> signedUnverified, List<UpdateElement> unsigned, List<UpdateElement> modified, int total) {
        pluginModelRoot = new DefaultMutableTreeNode("Third-party Plugins");
        pluginsModel = new DefaultTreeModel(pluginModelRoot);
        initComponents ();
        tPlugins.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        taHead.setBackground( new Color(0,0,0,0) );
        taHead.setBorder(BorderFactory.createEmptyBorder());
        taWarning.setBackground( new Color(0,0,0,0) );
        taWarning.setBorder(BorderFactory.createEmptyBorder());
        postInitComponents (signedVerified, signedUnverified, unsigned, modified, total);
    }
    
    private void postInitComponents (List<UpdateElement> signedVerified, List<UpdateElement> signedUnverified, List<UpdateElement> unsigned, List<UpdateElement> modified, int total) {
        DefaultMutableTreeNode signedAndValidNode = new DefaultMutableTreeNode("Signed and Valid (" + signedVerified.size() + ")");
        DefaultMutableTreeNode selfSignedNode = new DefaultMutableTreeNode("Self signed (" + signedUnverified.size() + ")");
        DefaultMutableTreeNode unsignedNode = new DefaultMutableTreeNode("Unsigned (" + unsigned.size() + ")");
        
        for (UpdateElement el : signedVerified) {
            signedAndValidNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        }
        pluginModelRoot.add(signedAndValidNode);
        
        for (UpdateElement el : signedUnverified) {
            selfSignedNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        }       
        pluginModelRoot.add(selfSignedNode);
        
        for (UpdateElement el : unsigned) {
            unsignedNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        } 
        pluginModelRoot.add(unsignedNode);
        
        pluginsModel.reload();
        
        int requiresAttention = signedVerified.size() + signedUnverified.size() + unsigned.size();

        if (requiresAttention > 1) {
            taHead.setText(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taHead_NotTrustedTextPl",
                    requiresAttention, total));
        } else {
            taHead.setText(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taHead_NotTrustedTextSg", 
                    requiresAttention, total));
        }
    }
    
    public String getSelectedNode() {
        Object o = tPlugins.getLastSelectedPathComponent();
        return o == null ? "" : o.toString();
    }
    
    public void addSelectionListener(TreeSelectionListener tsl) {
        tPlugins.getSelectionModel().addTreeSelectionListener(tsl);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        taHead = new javax.swing.JTextArea();
        spPlugins = new javax.swing.JScrollPane();
        tPlugins = new javax.swing.JTree();
        taWarning = new javax.swing.JTextArea();

        taHead.setEditable(false);
        taHead.setLineWrap(true);
        taHead.setWrapStyleWord(true);
        taHead.setOpaque(false);

        tPlugins.setModel(pluginsModel);
        spPlugins.setViewportView(tPlugins);

        taWarning.setEditable(false);
        taWarning.setLineWrap(true);
        taWarning.setText(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taWarning_Text")); // NOI18N
        taWarning.setWrapStyleWord(true);
        taWarning.setOpaque(false);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(spPlugins, javax.swing.GroupLayout.DEFAULT_SIZE, 398, Short.MAX_VALUE)
                    .addComponent(taHead)
                    .addComponent(taWarning, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(taHead, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(spPlugins, javax.swing.GroupLayout.DEFAULT_SIZE, 196, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(taWarning, javax.swing.GroupLayout.PREFERRED_SIZE, 58, Short.MAX_VALUE)
                .addContainerGap())
        );

        taHead.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taHead_ACN")); // NOI18N
        taHead.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taHead_ACN")); // NOI18N
        taWarning.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taWarning_Text_ACN")); // NOI18N
        taWarning.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taWarning_Text_ACD")); // NOI18N

        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_ACD")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane spPlugins;
    private javax.swing.JTree tPlugins;
    private javax.swing.JTextArea taHead;
    private javax.swing.JTextArea taWarning;
    // End of variables declaration//GEN-END:variables
    
    private final DefaultMutableTreeNode pluginModelRoot;
    private final DefaultTreeModel pluginsModel;
}
