/***************************************************************************
 *   Copyright (C) 2011 by Francesco Cecconi                               *
 *   francesco.cecconi@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef VULNERABILITY_H
#define VULNERABILITY_H

#include <QtCore/QObject>
#include <QtCore/QHash>
#include <QtWebKit/QWebView>

// local include

class nmapClass;

class vulnerability : public QObject
{
    Q_OBJECT

public:
    vulnerability(nmapClass* parent);
    ~vulnerability();
     /**
     * Update the combo with search url
     **/
    void updateComboWebV();
    
    
private:
    QHash<QString, QString> getDefaultUrlList() const;
    void setupActions();
    
protected:
    nmapClass* _ui;
    QList<QWebView*> _webViewList;
    QHash<QString, QAction*> _collections;
    
public slots:
    /**
     * Search Vulnerability with comboVulnRis string
     **/
    void searchVulnerability();
    void tabWebBack();
    void tabWebForward();
    void tabWebStop();
    void callVulnCheck();
    void objVulnButton();
    
private slots:
    void vulnPostScan();
    void addUrlToBookmarks(const QString urlName, const QString urlAddr);
    void callSearchHistoryVuln();
    void removeUrlToBookmarks();
    void closeVulnTab(int index);
    void startAddUrl_ui();
    void updateFontHostVuln();
    void updateComboVuln(const QString& value);
};

#endif // VULNERABILITY_H
