if (typeof test === 'undefined') require('../test');

test('pow', function () {
  var MAX_POWER = 1e6;

  function t(expected, n, exp) {
    test.areEqual(String(expected), String(new Big(n).pow(exp)))
  }

  Big.DP = 20;
  Big.RM = 1;

  t(4, 2, 2);
  t(2147483648, 2, 31);
  t(0.25, 2, -2);
  t(0.0625, 2, -4);
  t(1, 1, 1);
  t(1, 1, 100);
  t(0, 0, 1000);

  t('4096', '8', 4);
  t('-1.331', '-1.1', 3);
  t('5.125696', '-2.264', 2);
  t('6.7266e-7', '6.7266E-7', 1);
  t('1', '-1', 8);
  t('4142779.6499215776', '21.06', 5);
  t('731.1616', '-5.2', 4);
  t('1', '61818', 0);
  t('3.2', '3.2', 1);
  t('5.4139923025768140625e-41', '-1.945E-7', 6);
  t('1280630.81718016', '5.8', 8);
  t('3965.318943552', '15.828', 3);
  t('53.721', '53.721', 1);
  t('1', '-1.9', 0);
  t('4.58357323731267363492522744606954913014016e-39', '-0.0000161306', 8);
  t('-8560814308.6108448224', '-96.94', 5);
  t('4.4127502627834341562081e-74', '-6.77E-10', 8);
  t('79327261142.56790234534719652175488087744161', '23.0371', 8);
  t('3.101121e-38', '1.761E-19', 2);
  t('1', '-1', 4);
  t('6.23201296e-28', '-1.58E-7', 4);
  t('-8.50893402176e-19', '-9.476E-7', 3);
  t('16', '4', 2);
  t('90368789.0625', '-97.5', 4);
  t('1', '-112.8', 0);
  t('4.122181458338334221291398681640625e+27', '40042.5', 6);
  t('5.94467302491009e+21', '1290.0', 7);
  t('5.6599836943004175019970957e+25', '141437', 5);
  t('9', '3', 2);
  t('69.75757441', '1.7', 8);
  t('1e-42', '0.0000010', 7);
  t('8', '8', 1);
  t('-2.5090696333749305038864384e+25', '-664', 9);
  t('24794.911296', '5.4', 6);
  t('7077398515.1515538432', '93.32', 5);
  t('-1.4520042511984659693722813984375e-130', '-2.8295E-19', 7);
  t('4', '4', 1);
  t('372088627687.312953646321', '781.019', 4);
  t('-5.3864523289963490660381317787272961329536e-23', '-0.000658806', 7);
  t('-1.8', '-1.8', 1);
  t('1', '-5.9', 0);
  t('1', '2', 0);
  t('-6.4097340625', '-1.45', 5);
  t('170859375', '15', 7);
  t('595732589817199.440265999920799232', '43.82', 9);
  t('1.7080198121677824e+36', '-4200', 10);
  t('1', '658.8', 0);
  t('136.460505366756569881', '2.269', 6);
  t('-1', '-1', 3);
  t('236007.159691873761', '-22.041', 4);
  t('1', '-1.1', 0);
  t('287803125756.085809269657829376', '18.76', 9);
  t('4.1069049025e-34', '-2.02655E-17', 2);
  t('-8', '-2', 3);
  t('-5.0787635527751e-52', '-5.51E-11', 5);
  t('-8', '-2', 3);
  t('1704883919.2576', '203.2', 4);
  t('22106814.0740608', '11.2', 7);
  t('3.7481851264119295287828498195966142655968201e+23', '227.71', 10);
  t('-3', '-3', 1);
  t('5.308416e-54', '4.8E-14', 4);
  t('1', '-1', 8);
  t('1', '-4.1', 0);
  t('398', '398', 1);
  t('1', '1.17981E-18', 0);
  t('255896509713547.45824', '761.4', 5);
  t('16807', '7', 5);
  t('1', '232.6', 0);
  t('2.67066142562472466573674890357652039841e+30', '-6358.1', 8);
  t('390625', '-5', 8);
  t('85766121', '21.0', 6);
  t('2206809.987903620081317314341735861401', '4.309', 10);
  t('6.1917364224e-80', '-1.2E-8', 10);
  t('64', '-2', 6);
  t('-1', '-1', 7);
  t('-39.8778220049', '-2.09', 5);
  t('892496818.033068251283537321', '-31.029', 6);
  t('1.1289646949223432899980166202016362758071452681629968849e+25', '320.087', 10);
  t('1932991.455312009', '124.569', 3);
  t('635307227133823.258624', '-293.2', 6);
  t('784', '-28', 2);
  t('-43361725294765860565.175323475675341312', '-152.02', 9);
  t('1589.6036888689492933115234375', '4.36775', 5);
  t('1', '-18.4', 0);
  t('20832.8532313216810321678408500840248440324096', '3.46612', 8);
  t('6.5536', '-1.6', 4);
  t('174729381067.247616', '5590.56', 3);
  t('-4.084101e-14', '-0.0021', 5);
  t('7.46848810699576790739263937619996819197249e+21', '153.93', 10);
  t('2.09881105970752e-16', '0.0000059428', 3);
  t('23298085122481', '-169', 6);
  t('1', '-4.095E-11', 0);
  t('30016915.773120638290557721', '17.629', 6);
  t('16807', '7', 5);
  t('130666515.5580240243056896', '-10.34', 8);
  t('-5.97080224872032e-91', '-9.02E-19', 5);
  t('-3450.25251', '-5.1', 5);
  t('43046721', '-9', 8);
  t('1', '1', 1);
  t('3545.66529682492339392399', '5.1279', 5);
  t('3396.171616714297', '15.0313', 3);
  t('4.622674003397519975764019459730496e+33', '-408146', 6);
  t('1', '918.0', 0);
  t('7.59375', '1.5', 5);
  t('-67822.3072849', '-4.90', 7);
  t('3.7588592026706176e-104', '-1.18E-13', 8);
  t('1', '1', 3);
  t('5237990.22862336', '47.84', 4);
  t('11698.5856', '10.4', 4);
  t('110075314176', '24', 8);
  t('3.24210716131761936e-27', '2.38620E-7', 4);
  t('9', '3', 2);
  t('14641', '121', 2);
  t('62.81386652381601821841', '2.81523', 4);
  t('1', '8', 0);
  t('4.29981696e-160', '-1.2E-20', 8);
  t('1.692652673311521044295612689449216e-7', '-0.14242', 8);
  t('1', '-19.5', 0);
  t('1', '8621.8', 0);
  t('7.907e-7', '7.907E-7', 1);
  t('1.61051', '1.1', 5);
  t('1.553e-14', '1.553E-14', 1);
  t('858461358961485360081', '171171', 4);
  t('64', '-2', 6);
  t('-2.9', '-2.9', 1);
  t('-2.0661046784e-179', '-1.4E-20', 9);
  t('39.0625', '-2.5', 4);
  t('-391460020121.8781037', '-45.3', 7);
  t('-80.1', '-80.1', 1);
  t('3.5831808', '1.2', 7);
  t('41.08469075197275390625', '-1.45', 10);
  t('-128', '-2', 7);
  t('-5277043158.170301334052958483', '-12.03', 9);
  t('100.31024025', '10.0155', 2);
  t('262144', '4', 9);
  t('-2.66450474490105494016e-70', '-1.86E-8', 9);
  t('1.58541338622748269695158625134808009096449e+21', '-131.83', 10);
  t('1.69e-14', '1.3E-7', 2);
  t('81', '-3', 4);
  t('1.3979045762098993055105649e+25', '327', 10);
  t('-2.8334269484119140625e-17', '-0.0145', 9);
  t('8455365204.69607', '96.7', 5);
  t('4.826809', '-1.3', 6);
  t('-4.2027e-14', '-4.2027E-14', 1);
  t('-3671885391606530844.02199', '-5163.9', 5);
  t('1.4833', '1.4833', 1);
  t('1078702060.96', '32843.6', 2);
  t('16384', '4', 7);
  t('0.000041046707114327285209693732389121', '-0.185729', 6);
  t('9.04141586678594150656e-76', '1.73404E-19', 4);
  t('7', '7', 1);
  t('-5.408864751631992324037382349788164206309e+39', '-25989', 9);
  t('3.6213725246884329693766314512921496510839580087890625e-58', '0.00000180255', 10);
  t('51.58686976', '-2.68', 4);
  t('32562222.2784028467808485507564561204461862636001', '5.6399', 10);
  t('1.5269627878770126091369423832739776731492122624e-24', '-0.0041532', 10);
  t('2.27128515349184346452713121698128944001e-82', '-6.849E-9', 10);
  t('788.12330352545906108118941549114886272', '2.59298', 7);
  t('-128', '-2', 7);
  t('2.43585613160298150834272926486523151679435546875e+29', '1841.55', 9);
  t('3573226485.213841', '39.1', 6);
  t('5.0912', '5.0912', 1);
  t('1.302260124847515625e-102', '1.0450E-17', 6);
  t('-1097881.796860068547323829', '-4.69', 9);
  t('24.137569', '1.70', 6);
  t('67.937289638464', '-2.02', 6);
  t('-91125', '-45.0', 3);
  t('3.5658406477912053139330818066558837890625e-96', '1.17225E-12', 8);
  t('5.11226325150500959599107782635087831282590275214649e-160', '-1.17723E-16', 10);
  t('67.937289638464', '-2.02', 6);
  t('-3125', '-5', 5);
  t('-3125', '-5', 5);
  t('-2983765.0756983032103435524997723277', '-8.4133', 7);
  t('4535877.137495584829386816', '-12.866', 6);
  t('256', '-2', 8);
  t('-7.9', '-7.9', 1);
  t('4.18161601', '1.430', 4);
  t('2.3591116836e-38', '-1.53594E-19', 2);
  t('6648326359.9150104576', '9.6', 10);
  t('65536', '-4', 8);
  t('22777216155500625', '-12285', 4);
  t('1', '-1.14E-9', 0);
  t('1', '7.4', 0);
  t('1.21', '1.1', 2);
  t('0.248', '0.248', 1);
  t('-2187', '-3', 7);
  t('1.48996e-23', '-3.86E-12', 2);
  t('2.49173e-14', '2.49173E-14', 1);
  t('-2738.124199', '-13.99', 3);
  t('-2.7044661231722633428249e-63', '-3.0649E-13', 5);
  t('0.0000998001', '-0.00999', 2);
  t('9', '3', 2);
  t('-331.370935156703232', '-3.192', 5);
  t('2.611824102393094023763', '1.147', 7);
  t('-527', '-527', 1);
  t('27', '3', 3);
  t('2.313441e-34', '3.90E-9', 4);
  t('1', '-8.00148E-16', 0);
  t('6.427669793976056365481141274099681e+25', '-1682.7', 8);
  t('-27', '-3', 3);
  t('256', '-2', 8);
  t('59049', '-3', 10);
  t('8.7713801081173367580884490451432713332434379776e+26', '494.66', 10);
  t('20234327779106168.4159474599729911316138226499265176167424', '42.7178', 10);
  t('-27', '-3', 3);
  t('0.009411328144', '-0.097012', 2);
  t('349044.64', '-590.8', 2);
  t('4750.104241', '-4.1', 6);
  t('-173928970714601588962.8103429', '-778.9', 7);
  t('3656158440062976', '-36', 10);
  t('6.12220032e+22', '1800', 7);
  t('1', '3.4', 0);
  t('9.70097321773035876225154576358130561e-37', '0.000031503', 8);
  t('-12.812904', '-2.34', 3);
  t('-1.7340444960685031988323168e+25', '-111638', 5);
  t('282475249', '7', 10);
  t('-81.746504', '-4.34', 3);
  t('-7.219028320823404915424e-24', '-0.000023534', 5);
  t('41.0338673', '1.7', 7);
  t('2.0415562993764162403236821478431932029075456e-128', '6.4896E-15', 9);
  t('82955.444920574689', '43.6129', 3);
  t('-160578147647843', '-107', 7);
  t('3450.25251', '5.1', 5);
  t('82854921260716023991.1435387164164096', '308.88', 8);
  t('1', '-285', 0);
  t('390625', '-5', 8);
  t('1.8189597967773564082837969e-101', '1.6217E-17', 6);
  t('2.825761e-74', '4.1E-19', 4);
  t('1355738723022659.5905381376', '-32.6', 10);
  t('1', '26.5', 0);
  t('1', '-1', 4);
  t('9', '3', 2);
  t('8.02677619844494861156679981606477327016984576e-140', '4.10268E-18', 8);
  t('6', '6', 1);
  t('-97.65625', '-2.5', 5);
  t('47524', '218', 2);
  t('4.70681', '4.70681', 1);
  t('3588.01', '59.9', 2);
  t('1', '-52.1233', 0);
  t('150837370166.726828752896', '-72.960', 6);
  t('1', '-202722', 0);
  t('531441', '9.0', 6);
  t('1', '1', 8);
  t('16', '-2', 4);
  t('10.5413504', '1.4', 7);
  t('-43003385433558549', '-350349', 3);
  t('11656', '11656.0', 1);
  t('2.5937424601e-80', '-1.1E-8', 10);
  t('380008', '380008', 1);
  t('1', '1', 10);
  t('65248.283129848297112850803864372537279713', '3.4273', 9);
  t('-1147575293595.98432', '-258.2', 5);
  t('1.3689e-20', '1.17E-10', 2);
  t('5.9969536e-41', '-8.80E-11', 4);
  t('36', '6', 2);
  t('8.38561807e-52', '9.43E-18', 3);
  t('4248380.5456', '45.4', 4);
  t('15400296222.263289476715621650663041', '-18.769', 8);
  t('2381343457183.27934976', '1242.24', 4);
  t('1', '1', 4);
  t('4.78918476762052235286361700161e+21', '512.9', 8);
  t('2089309226.032466059985824', '73.114', 5);
  t('2641.807540224', '2.4', 9);
  t('1', '430.260', 0);
  t('6.1917364224', '1.2', 10);
  t('19407735094418288.17030696889622168576', '42.54', 10);
  t('1', '-10.7661', 0);
  t('-3125', '-5', 5);
  t('481.890304', '2.8', 6);
  t('3.341488431860881e-53', '-7.603E-14', 4);
  t('1', '2.8', 0);
  t('14214.495945642721', '-10.919', 4);
  t('40353607', '7', 9);
  t('2.033478055981629545259599e-91', '7.2719E-19', 5);
  t('1.0007101809887004032e-16', '0.00518', 7);
  t('82653950016', '66', 6);
  t('287365339.799', '659.9', 3);
  t('1.2675964125399273523216299738998904467161547776e+26', '-407.66', 10);
  t('64', '-2', 6);
  t('41933.25113121', '-14.31', 4);
  t('-300763', '-67', 3);
  t('2187', '3.00', 7);
  t('1085328071.651663', '1027.670', 3);
  t('3.02024876193621053068500168512434520049e-112', '7.047E-12', 10);
  t('-50817457664', '-3704', 3);
  t('1.2167e-14', '0.0000230', 3);
  t('-47932.2', '-47932.2', 1);
  t('-2187', '-3', 7);
  t('-10.611843208841110742516870554084117001', '-1.3001', 9);
  t('1', '-1', 2);
  t('-80473337380004.2860993293', '-604.13', 5);
  t('574015339044', '-757638', 2);
  t('1', '1', 5);
  t('2.53295162119140625e-13', '0.055', 10);
  t('-6.12220032e-20', '-0.00180', 7);
  t('-27', '-3', 3);
  t('11040808032', '102', 5);
  t('416336.3127196737601536', '5.04', 8);
  t('269175550798.26432', '193.2', 5);
  t('-1.528', '-1.528', 1);
  t('4.782969e-127', '9.0E-19', 7);
  t('-7.51e-8', '-7.51E-8', 1);
  t('1024', '-2', 10);
  t('607.850029476310544160862292358275390625', '2.0385', 9);
  t('-11.8', '-11.8', 1);
  t('1.076079329936225357094692222242816e+27', '32011.6', 6);
  t('-351982550989147112', '-706058', 3);
  t('1', '1', 0);
  t('9', '-3', 2);
  t('86.44348156327976252176', '-3.04918', 4);
  t('1.382898042825325230836148576046154775429376e+34', '18518.2', 8);
  t('193.180743258112', '5.7808', 3);
  t('-38.98', '-38.98', 1);
  t('456976', '-26', 4);
  t('-5.156993509526072073746875e+24', '-87595', 5);
  t('-3311111.840687797824457', '-20.137', 5);
  t('-3854601532649', '-329', 5);
  t('1', '-8011', 0);
  t('1', '2', 0);
  t('1', '-0.0185', 0);
  t('245925124', '15682', 2);
  t('-5.774467426440121643433984e-21', '-0.00564', 9);
  t('1207.269217792', '2.2', 9);
  t('4552.045708313044707921', '-4.071', 6);
  t('1', '-29.2', 0);
  t('-4.3847739074110089716547584e-136', '-4.604E-20', 7);
  t('-7776', '-6', 5);
  t('3.0745786029631524271923429376e+28', '498376', 5);
  t('-322.687697779', '-1.9', 9);
  t('-31084123244.396440017759765625', '-14.65', 9);
  t('1.4641e-56', '1.1E-14', 4);
  t('-172.10368', '-2.8', 5);
  t('3894161181.1810745401', '-9.1', 10);
  t('1296', '-6', 4);
  t('1', '6.2', 0);
  t('2.91506581425215873264648192e+26', '872', 9);
  t('1.85843153221037962890625e-175', '3.85E-20', 9);
  t('2534495.8401', '-39.9', 4);
  t('-1.85738630687872790421037608793067224429e-7', '-0.17869', 9);
  t('20711912.837890625', '6.5', 9);
  t('216270112.515625', '24.5', 6);
  t('1.61051e-30', '0.0000011', 5);
  t('192541.45824', '11.40', 5);
  t('1', '-6.91E-13', 0);
  t('2313060.765625', '-11.5', 6);
  t('31653832624.2576', '421.8', 4);
  t('0.000008916100448256', '-0.144', 6);
  t('1', '6.074', 0);
  t('200476.12231936', '-4.6', 8);
  t('-2097152', '-8', 7);
  t('1', '1', 7);
  t('1.024e-37', '-3.200E-19', 2);
  t('-7.56680642578125e-40', '-0.0000450', 9);
  t('22363441', '-4729', 2);
  t('0.326940373369', '0.83', 6);
  t('0.0653', '0.0653', 1);
  t('67937289.638464', '-20.2', 6);
  t('1', '-6935.7', 0);
  t('37366.9453125', '4.5', 7);
  t('84736910327822.09024', '610.4', 5);
  t('89.3871739', '1.9', 7);
  t('-74088', '-42', 3);
  t('2.6', '2.6', 1);
  t('-2.74625e-52', '-6.5E-18', 3);
  t('7.25211296602410832237035188113814152676619241652224e-20', '0.0121912', 10);
  t('-0.231616946283203125', '-0.85', 9);
  t('136117620759552651.464603466304', '-717.22', 6);
  t('7149.24299', '5.9', 5);
  t('-105748.898523294431279732941', '-5.221', 7);
  t('4', '-2', 2);
  t('2.177e-10', '2.177E-10', 1);
  t('729', '3', 6);
  t('62050623946302131.87381413659819', '250.59', 7);
  t('39413.40648961', '-14.09', 4);
  t('1', '1', 0);
  t('6561', '3.0', 8);
  t('0.000039304', '0.034', 3);
  t('343', '7', 3);
  t('256', '4', 4);
  t('187914065609.1136', '658.4', 4);
  t('-2017403668.061600505811231934445020891', '-10.811', 9);
  t('1', '-1', 2);
  t('-1', '-1.0', 7);
  t('-5', '-5', 1);
  t('-9892530380752880769', '-129', 9);
  t('6.6241549228613285241719980684340096e-106', '9.4286E-16', 7);
  t('3.43333904131263903194677248e-46', '0.00000888', 9);
  t('-9.7699019384092441818970744182751232e-92', '-9.9668E-14', 7);
  t('22518.75390625', '-3.5', 8);
  t('9.90817568487338826820891768064226576961e-66', '-7.49030E-9', 8);
  t('-2', '-2', 1);
  t('3.7805311079775207424e-77', '1.832E-13', 6);
  t('-14326936981.650438436683776', '-107.456', 5);
  t('31509057.52576', '31.6', 5);
  t('-1729271944.97024', '-70.4', 5);
  t('4.182119424e-81', '8.4E-17', 5);
  t('5406147534197334.84011776', '-92.6', 8);
  t('-0.00000363167', '-0.00000363167', 1);
  t('9536.7431640625', '-2.5', 10);
  t('11094619561', '-105331', 2);
  t('3.0073480681463454661678314208984375e-137', '6.775E-16', 9);
  t('1.5374535781262326309644119647446644001e+29', '-4449.9', 8);
  t('9.70138473177843532176348676096e+29', '99496', 6);
  t('127.45506816', '-3.36', 4);
  t('1', '-84.7', 0);
  t('1.7499128828948144488585826444218125390625e+40', '-107245', 8);
  t('3577.714596', '-59.814', 2);
  t('-13012.5', '-13012.5', 1);
  t('-1', '-1', 1);
  t('16', '2', 4);
  t('254016', '504.0', 2);
  t('-1607.369262344', '-11.714', 3);
  t('1', '1.251E-11', 0);
  t('208.5136', '3.8', 4);
  t('387420489', '9', 9);
  t('1', '4.2', 0);
  t('6104030772588134.765625', '-427.5', 6);
  t('161.29', '12.7', 2);
  t('9', '3', 2);
  t('-2181835737885608.101460104333373352538009179', '-50.619', 9);
  t('-3997.92155722610103', '-3.27', 7);
  t('2565164201769', '-117', 6);
  t('-512', '-8', 3);
  t('6.04380441302073327515625e+23', '-9195', 6);
  t('1', '1', 5);
  t('-9.2389579776e-25', '-0.0000156', 5);
  t('7.997656216391946134348627101293601e+33', '17293', 8);
  t('39520792565978809.524305593609', '-583.63', 6);
  t('16', '-2', 4);
  t('7807.4896', '-9.4', 4);
  t('248832', '12.0', 5);
  t('496981290961', '-89', 6);
  t('-4.3606774182392e-44', '-3.5198E-15', 3);
  t('16777216', '64', 4);
  t('1', '1.0', 6);
  t('1', '91.4', 0);
  t('9.851127637605409e-117', '-4.63E-20', 6);
  t('1', '-1.4E-9', 0);
  t('-4.52470110728381829e-7', '-0.00767709', 3);
  t('282475249', '7.0', 10);
  t('16651779441254092864', '1598', 6);
  t('729', '3', 6);
  t('6.90946358996746999370693799867018948630842395035736169049e-104', '-4.82997E-11', 10);
  t('684.84796416', '26.1696', 2);
  t('-1', '-1', 5);
  t('1', '-6', 0);
  t('0.0000078310985281', '-0.23', 8);
  t('2.274064', '-1.508', 2);
  t('3.04122555034158459939649e-47', '-0.0000223', 10);
  t('696452982073287.871843324909094936562277581368328192', '44.5872', 9);
  t('-7.5151448e-29', '-4.22E-10', 3);
  t('1', '6', 0);
  t('-12.708', '-12.708', 1);
  t('70', '70', 1);
  t('2187', '3', 7);
  t('-1.628413597910449e-174', '-4.9E-20', 9);
  t('-6.312457192887951173182283446626151709594241e-66', '-5.6961E-8', 9);
  t('0.000299069043583441159212021318210939', '0.4059', 9);
  t('15.995353981724701', '1.741', 5);
  t('1', '97857', 0);
  t('0.221585791441', '-0.470729', 2);
  t('1', '52.0023', 0);
  t('-26015680550432', '-482', 5);
  t('22903.7956', '151.34', 2);
  t('6.561e-17', '-8.1E-9', 2);
  t('-93189625398108974.44387339079552', '-265.58', 7);
  t('-3086125724460522.34468469084288', '-163.22', 7);
  t('0.0000051', '0.0000051', 1);
  t('19683', '3', 9);
  t('-2.4507253464874125175251e+22', '-30051', 5);
  t('-38.907147732329430154371456512', '-1.502', 9);
  t('4.68733667816790896452997907438948199465216e+41', '161758', 8);
  t('64', '-2', 6);
  t('27541696650101.74182563635028557824', '-22.08', 10);
  t('1.352771823277379852935844331805603817270014056494234420224e-23', '-0.00516562', 10);
  t('1', '1', 4);
  t('-2350072823968', '-298', 5);
  t('8941.5936', '-94.56', 2);
  t('97241.5', '97241.5', 1);
  t('6.93207873781332929149e-50', '9.49E-8', 7);
  t('-59049', '-9', 5);
  t('-8882.144880086754771640625', '-3.665', 7);
  t('8100981934880.472', '20083.8', 3);
  t('16', '4.0', 2);
  t('6.561e-49', '-9.00E-13', 4);
  t('-446592952.353220867168501', '-53.701', 5);
  t('-3.2466525536194576823494051652634346881e-125', '-1.47210E-14', 9);
  t('3.89751', '3.89751', 1);
  t('3.8443359375e-107', '1.5E-12', 9);
  t('493.039', '7.9', 3);
  t('-16807', '-7', 5);
  t('-4.7471727261300877329502034895519256591796875e+34', '-7127.5', 9);
  t('49', '-7', 2);
  t('1.27e-12', '1.27E-12', 1);
  t('30373391.06115737305088', '11.72', 7);
  t('1', '-1', 6);
  t('-19349.17632', '-7.2', 5);
  t('361', '19.0', 2);
  t('1', '0', 0);
  t('-10077696', '-6', 9);
  t('42180.533641', '5.9', 6);
  t('38.443359375', '1.5', 9);
  t('1643032', '118', 3);
  t('16', '-2', 4);
  t('1962.49', '-44.3', 2);
  t('640.09', '-25.3', 2);
  t('8693.75638483077329986588967330173480782272550321318049', '-2.47697', 10);
  t('8105445187812500000', '6050', 5);
  t('3106365092236328976', '41982', 4);
  t('1.9e-18', '1.9E-18', 1);
  t('1388437454689.837102639637015104', '105.622', 6);
  t('217.67', '217.67', 1);
  t('-1', '-1', 1);
  t('-40.84101', '-2.1', 5);
  t('1.542564e-12', '-0.0000012420', 2);
  t('-1.18009517625e-37', '-4.9050E-13', 3);
  t('5549069137356750625', '-48535', 4);
  t('1172.7599043051', '4.11', 5);
  t('1.024e-39', '-3.2E-20', 2);
  t('64', '-2', 6);
  t('9765625', '-5', 10);
  t('10174708482.4576', '317.6', 4);
  t('4596.544052624786837880243001942570369016159210753', '2.55233', 9);
  t('4096', '8', 4);
  t('729', '-3', 6);
  t('19034163', '267.0', 3);
  t('7.13342911662882601e-183', '-6.1E-19', 10);
  t('-8', '-2', 3);
  t('7.458836077824580594735138491702651752566987e+24', '580.27', 9);
  t('-1.488656882033767469315065509517197312e-126', '-1.0452E-14', 9);
  t('-22512044836648447.5871232', '-216.8', 7);
  t('1', '1.0', 2);
  t('-1048576', '-16.0', 5);
  t('2.96566225198439749053708901e+26', '196981', 5);
  t('387361397731.0852349972153162834577841407848071071001', '-14.4149', 10);
  t('2.5937424601', '1.1', 10);
  t('1', '-132.84', 0);
  t('1', '4642.2', 0);
  t('-7.3499661205554469210497482752e+28', '-1612', 9);
  t('2.56745903401e-35', '-5.06701E-18', 2);
  t('-8.0416926477372443174045490389e-14', '-0.013469', 7);
  t('481.890304', '2.8', 6);
  t('-2.0079766520165347109375e+22', '-1535', 7);
  t('-3.34255384e-7', '-0.00694', 3);
  t('65536', '-4', 8);
  t('15700.150160096030724096', '5.004', 6);
  t('3', '3', 1);
  t('-1024', '-4.0', 5);
  t('1', '-0.0000026', 0);
  t('3.75e-11', '3.75E-11', 1);
  t('-2.197e-33', '-1.3E-11', 3);
  t('850260.560009615038237114368', '7.032', 7);
  t('1.165611915415579117119882256009e-48', '-1.02587E-8', 6);
  t('1.874746414628249416823686235041e+30', '-6083', 8);
  t('3541035030023585410.9685579776', '-71.6', 10);
  t('159873594510682.812023861622308942042241', '59.631', 8);
  t('964', '964', 1);
  t('1', '7', 0);
  t('1', '1', 7);
  t('959554720546.9939335182868736', '-31.46', 8);
  t('390625', '5', 8);
  t('8.58117156760783434066136732224e-67', '9.7482E-12', 6);
  t('1', '1.10E-19', 0);
  t('2.7206534396294947e-38', '0.000067', 9);
  t('-2.7993930117296371229848579851719540736e+30', '-22365.6', 7);
  t('5531947943217503125', '5605', 5);
  t('2.77921878692682183940201e+33', '2210', 10);
  t('-1.34775901066369285240390603125e+29', '-669765', 5);
  t('1', '1', 8);
  t('-187.539', '-187.539', 1);
  t('114983.567789585767578125', '3.65', 9);
  t('1', '1', 6);
  t('9.5563709286130016454092290324007041e+28', '-67615.9', 6);
  t('2.39576999392237432790890516398336', '-1.1154', 8);
  t('-23.924567789936824982851522063', '-1.423', 9);
  t('39.4384', '-6.28', 2);
  t('46411484401953', '33', 9);
  t('3864', '3864', 1);
  t('20554002898923904', '214', 7);
  t('1', '-481', 0);
  t('1073741824', '8', 10);
  t('64', '-2', 6);
  t('-15633814.156853823', '-6.3', 9);
  t('7.9', '7.9', 1);
  t('-284.68', '-284.68', 1);
  t('1', '92.6', 0);
  t('256', '4', 4);
  t('-4233837892.359375', '-1617.75', 3);
  t('1.01054975167057821704275308297863156222443369140625e+40', '10010.5', 10);
  t('4.15867265447116306999621451776e-171', '-9.16E-18', 10);
  t('14796.346375', '24.55', 3);
  t('0.000003596774583043934673428448834277192142749696', '-0.208684', 8);
  t('19619412024963200000', '7220', 5);
  t('203.33219575276960518721', '3.77617', 4);
  t('2187', '3', 7);
  t('-512', '-2', 9);
  t('1', '2.4E-15', 0);
  t('-79', '-79', 1);
  t('-281399112371155271', '-311', 7);
  t('2.0441457156547956272121e-32', '-0.000005229', 6);
  t('164546156906.7655853425459503979807203014092043691201', '13.2321', 10);
  t('-46.13', '-46.13', 1);
  t('191707312997281', '-61', 8);
  t('1019.4513038883292709315124224', '3.99644', 5);
  t('1', '3', 0);
  t('1', '-44.4', 0);
  t('545516.0701056', '6.6', 7);
  t('-4177', '-4177', 1);
  t('358050', '358050', 1);
  t('229.97659811731444699830505796029057408', '2.17462', 7);
  t('2.6108288368639387032909799e-70', '1.21159E-14', 5);
  t('4325169905.757', '1629.3', 3);
  t('122.5', '122.50', 1);
  t('1', '-0.0001858', 0);
  t('3.17145729137553882999930496108165023687245824e+34', '2819.2', 10);
  t('-1', '-1', 3);
  t('-49.358166606568', '-3.6682', 3);
  t('-3.0228559084421978498330001408', '-1.17120', 7);
  t('24.76099', '1.9', 5);
  t('-17.576', '-2.6', 3);
  t('-20', '-20', 1);
  t('-1', '-1', 1);
  t('30804.095140913337149030892729572601', '2.811', 10);
  t('15625', '-5', 6);
  t('117649', '7', 6);
  t('27', '3', 3);
  t('-65939.264', '-40.4', 3);
  t('4.56976e-27', '2.6E-7', 4);
  t('3052847.6176', '41.8', 4);
  t('18440755681.001536', '51.4', 6);
  t('693.43957', '3.7', 5);
  t('-10187688835060.27636096761856', '-72.16', 7);
  t('-290.1', '-290.1', 1);
  t('-2097152', '-8', 7);
  t('63.582', '63.582', 1);
  t('-92713.643576', '-45.26', 3);
  t('58778272623218534616.288838935169', '1971.83', 6);
  t('606071.1605323', '6.7', 7);
  t('49478904727733663575.051582184770446498259493718971258958961046708278746324459568256251259157238318185790764612200843144821137580796334089638532287323488178607687532035618686192601481827902773410791645057647691925965756808571011539462511641266331263543939501901006735272661302011976870015625991111560481188335365459566760212844848008439578745211448299643484693328447464460429576345111356618402802188681216', '-1.60380', 96);
  t('1.17647340482075248419254427344376045314316013640615098803852731448350843468375614975229837000370025634765625e+81', '-1312.5', 26);
  t('7.0251816660378376802360594609084621021532608383100803495211258733288152327693358768741786747381360859889479870288549139760601303377485234176e+87', '-2391.76', 26);
  t('85.717123455378345835968064', '2.0998', 6);
  t('7.8189586726154755713303078223442071754329e+40', '187', 18);
  t('9.145283009860369082115124525217171723626500086794105722560960199131059600008740516579605574000306840952542591838726900925804876261491646795282472377021036430500854987560433039755667787412917103148092128371355207976203112911565783359385741850905996481e+41', '-6.4113', 52);
  t('2.05766289512932241998482631797034621069017517962263802542480365981262536498089637707776e+86', '26', 61);
  t('98190573319064.214163360748608660888346857427032348178060040012159036566957731914573312588336568078808326155328828092023492584783227218123097647282496144318320115860427194595696623235777670393347299594686642872330179664094829207439052010438267983369137644871417464586087393161049', '-1.6293', 66);
  t('1.392598192044227355988772015943279484446048049140235246881310663971517522995991944491655264930301742862780134225258915488062891063359354742689683631308848403923615202977361e+171', '109', 84);
  t('1.5469996446227372120183605762031536360861258626528255060075983309687394111102266369973688377324297491658050323998067994446097153176237864040180207896595918522219595889946775556217e+64', '13.37', 57);
  t('417.53905413413116367045797', '1.3', 23);
  t('1.624290817967129588779052613030846258081e+39', '79677', 8);
  t('-6.3573488855626874208656330920509964477352567129457629687143164320289038602869782661489925857813432230614125728607177734375e-576', '-0.00000000000000935', 41);
  t('4.64886146511675512184781529230310759569090675635563199653956477629674515058124652544e-866', '0.0000000000014', 73);
  t('6.613998972307900952958925063693292646912001305426127894831260851822286968476028114198011923029274945784114379928252947652708965396453170282038903005249536e-263', '0.00000908', 52);
  t('17179869184', '2', 34);
  t('9.7756260861181096053516970094092017016032995016954767790504110039917368643756356818044285001644705953440430468819149794081183248976623767084182482857941562203266736374606395800621259352114936429301555533971456e+141', '131.6', 67);
  t('4294967296', '2', 32);
  t('131621703842267136', '-6', 22);
  t('7.9228162514264337593543950336e+28', '2', 96);
  t('-1', '-1', 41);
  t('5.0096959237841976223015468271587016074738912992534254294320102857326166341642003475731604090433896328441157235303061782495282575910872792923981113856240569836427242032573810996210128117467500761653330557379347005097932959928243111015057764620250811725789666461853189934772359267843261626881e+197', '140.9', 92);
  t('2.404907604760405225358828131112281116032698930082119547604265954848982041717359046106827774346003151904701415424e+111', '32', 74);
  t('2.69721605590607563262106870407286853611938890184108047911269431464974473521e+22', '-2.7', 52);
  t('18.174', '18.174', 1);
  t('1.36891479058588375991326027382088315966463695625337436471480190078368997177499076593800206155688941388250484440597994042813512732765695774566001e+43', '2.7', 100);
  t('1.25668660115116491467662710973545031109788152235501170924313646703423681882164573441433515503588152722789494580469301248e+72', '34.2', 47);
  t('1.56438420672167084519979701497174364597412396629019101951505612890666817698608365177006994887516584111152450449887451995069033040411213741933147153316594951835865202053237255800944727011696760985308614176976019463960094165747239428884158901702435389388132623055120422260406418255249330452909476806656e+299', '1308', 96);
  t('-3.3612593878633377323120299366598552550657318092430645826641551765299195886060921308858703945250378295445932063495284056402608601041200858277129191414584253234377130155413110017511561906751453442173764185430889086682955797697564561876544299009572864e-463', '-0.00000030640', 71);
  t('-1.366174308182025187777528918308146941320736787278460889575749404867695325446359807161410602138908197731224033169833047036778978022709170976735608988099868310813030127497812540494011203545816852288666658682985428600019476831917843e+58', '-4.83', 85);
  t('2.966806088806219456880539423158152815514806645521282752514016241570099725287916962770395912230014801025390625e+28', '-5.15', 40);
  t('8589934592', '2', 33);
  t('3.92012913845865034844198476089476040042936801910400390625e+28', '-10.5', 28);
  t('6.26204859896956162110746451442214931102399028194694661966016701109504299345041406486245804277657094315831017177064948219797627444240188709011456e+72', '10.6', 71);
  t('-7.4010922571797388655581604684527426699437277457499992187268655958229686891933340740793991046504324130585438416249947232728346081088006867719609592595610095069331022367447133421906806310032697675369409918188139600222703781482594772971289070262621142441874895437059567046831661495957273728351051362944953711082346089727330717918651409489163662706555003193741825901442633007312863953564385259087744338361955671878877893732351367361843585968017578125e+364', '-31956.5', 81);
  t('6.192736416792149755132475219493405669399778858602560762871794455317449717448580836229845787580888290473782381059983387805505374173265513677435445890655671110840202944429668728225878544903602239e-270', '0.000319', 77);
  t('2.321827472731847506187210910989207010589651530892302311791322352855446782760907718473019283821056753242967949096791603718944064726033664384082861996009850744961116407128920163494805886357836270766853975184523023642990429569615539676822828070446559161161124635674389704743948383107212919966543969471039720464085404567773913503635201792672811032312063265454094042341369554833714443413857449688164664657173315113983032808001e+220', '159.83', 100);
  t('4.953736650985698001275587761883016173298229503362193331584010106486052779761329981195411366329068322677550960044762649449732919438910119549694010717647780952298320287365138145210431380601324547389442337520392258009e+27', '-2.797', 62);
  t('-338678221586896.02233451034424755534030583977124338116841050703894756829829935320421996887', '-2.47', 37);
  t('-3.181403788572786716059998378326698266679069780899509454959934125355133265193e-226', '-0.0000057', 43);
  t('2.2481244795444847556680083178853571141700204725943661497539185751725919215990484669445118877448657555202573745174750533635052209260608084995835891707958259234271442982681066779696130155696868114346639852814575962457281749995256623713554214237458259176913852401064878760784275382146658972801541462348779288776844691139086889351786721e+179', '229.03', 76);
  t('1.09544203269304121665791452848994634135137143229447033238750572549632571476402641497730897157401184093614916314911584167715115647604065370616785146866296916632437569033863034458711783186506727022529378159297811462454675308057682780534190256280910865229376785975491743196806996272790525705427972427376758443312371576466422700240638756574402393677191376501159420836822933903938571935476091044876631814554274289087939783553959776485376e+31', '-2.0436', 100);
  t('-18437563379.178327736384102280592359424', '-2.4', 27);
  t('-2.565217290810806995636762133271387046711787821113755094865559403845937698002650308359872294490245896048511431844327060222279092126522644090602653932364773936569690704345703125e-1286', '-0.00000000000000000245', 73);
  t('-9.9938258857146531850367031e-85', '-0.0000000231', 11);
  t('2.45673281757908854552870925433471410070214400334169452520459965621921664416713287959754208329284439619509099451538227140937811535553399003066102795766261859069268099803838998995339331311912275460846260697085073312049264485545427543086425664188963659692922005683716104197951717376e+78', '-6.08', 100);
  t('-1.270210714458885172439348525985048001607770314656078008119108251089872343340175575576722621917724609375e+24', '-4.15', 39);
  t('1209.5', '1209.5', 1);
  t('1220703125', '5.0', 13);
  t('2.2282376678496302739664556233420633e-74', '0.000000006553', 9);
  t('-2.0143178310003212256300583293456672172631020531521918361472772972889521239226102046625809514969363623444910359830312781808037277269448486731571232348276098930038993446113250228220070581715505392835999598313673094262893473819122138457089550860895343281662272401621942844086800579631762991581889839022236592407099699255051163050728007905851774204682372669170991112060985568225152641619715730738207580551834481069203501503809308865543720800327e-380', '-0.000067223', 91);
  t('2.218088039378445352751296336694731578146959285984085545221611060271486214348079661041003283535646898758718143100202167951881147633680620698026648392938984778649e+159', '893', 54);
  t('2.10030968607618842407969732186669026418164521383378412734005003194384320968659491239802049483617846390172315534146347011074332799904332281963786542263761412332465321180532568441958976108339460464558490863953503079336356338135760894630619724493454777575270501253639608281424341291617698518141921861556244699796561591915201261004739209197698527393965924844797945393999012105081714167479170123104969e-75', '-0.16053', 94);
  t('2.5812157101662325924336748344070521698410946762506012782923924916938485004644329931151074914373301798478548152505612780265485671672098712055026947247254600014458282820627468534250894082132928621697659949721616819635951012296371246281717642419683893063297904005186874144169940879165882368e+286', '25488', 65);
  t('-15.625', '-2.5', 3);
  t('2.9729685996261878754343622542880008372085710279050331084451543295302017053107644303792930816e+59', '-72.2', 32);
  t('8.15730721', '1.3', 8);
  t('1027.334860999330573407176938442293022889', '-1.47', 18);
  t('1.20109289910050514343148045475506579676136202628631781424931463646123976128634333627993215283736800191296195442718065238702508520055513255346146658609301480565930380776363581062628797012612519067602295957218821773367819208495782017345400726347727499503218384384326417098721424389373157748956399698521853695814977704822352568748499324367082691064737392226159651276162776412093080580234527587890625e+315', '8679.5', 80);
  t('-6.00774319642841528092711102659123449286352750007573133369794363392e-33', '-0.22', 49);
  t('-4.399348626310072691340857398671747903319767685984244866658805429802943497233040561059795990923598510826890908258017493538766494536483606174431755682553269424176946343755577041745496403493430254087811474250251864009392456889456030217048416123130922140883015639602300329038985615284964386359900403921860549312983015992252637174331659470716194350399038561704290046291e+177', '-81.31', 93);
  t('-2.8207084178214872249481823288498698761858927113247705134064774975584407746875292397517412079545141630385439164566258891612557809688920433687345470043533104587152797682527671453716396264049694524828296706083384902442044310310028264740195536658201877924115112455928789057407729309051948428713154253269588754827200494136242524139799015813072692354239567376152196027070283776e-140', '-0.022816', 85);
  t('-3.05410827582876268390180635074883196222812916959850956275590047122226930793718597160851022493537771838978253152932907298258251555751167476560688772053768410645587233357374279876239597797393798828125e-247', '-0.000000217485', 37);
  t('5.94029530519133658573841651381893916937282220672559984930445801765696530117833330901747112098660456061962952244422396324466169433806822249922825538552986841011e-19', '0.491', 59);
  t('6.30523820693302485362185385323378612453984181696300485861970499164041182778517073604560519798249286847423997356860449832519236757706844668669858983416671702949907296869514603475482872905487176008793424936405673085021973514041591620544995041842415714193527926259387876594710020672351902248919941484928131103515625e+217', '-207.5', 94);
  t('1.3437482898194084408359108790569717431056936319064040016470306278420649755238589129250716839755182586596297106623509972801915917688676116852207e-198', '0.0047', 85);
  t('-7.2125976851811538835264180669311252876757309817127885777282268797579465235996423577991265862898834402822899090972405912847104748143261578733778979456054998346007864343435284069799588577484912513898046820531311312862161018665360468415091050892814436289818311468501837802070896183140379745282036670643116477155731121958797307187300620339307163520531060733946755523082115115646976e+279', '-767.6', 97);
  t('-3.6014175419419889979825978713404525121917028354184157603813105843373968813713708575013260529677555144144724689493141661197266911743582631754736205113266715503341523389605232359965730457026715491821102337726896541765297511282920487936650122950956509166185123335946923710632464810273024751e+116', '-23.51', 85);
  t('864441744884.215763637320205869663958329635842919446190153261333597518371076208416885489806126587561695103959519298009135858834566699504679568405218950836778578735139166130606578479646072479355927241854902595925015466294859320621226069690609744261681250304', '1.404', 81);
  t('2.1740698194376449374483147468467027620784304276072222988616865620688896e+52', '808.4', 18);
  t('3.8358611506121121577937e+22', '113', 11);
  t('7.708142065054490966774434895299862856570563111111152865942369472254266622057906176e-375', '0.0000000000000002582', 24);
  t('1.697054670829812124918589801369405630774787179949418285317226086899030607907838200923128944336540480137932154797404155642362243064347816887752994688507537824596616056930370261936449615792564115353680658971035397858675806419291627327666883921628766762017e+153', '35.3', 99);
  t('-4.710128697246244834921603689e+27', '-9', 29);
  t('3.2505902718449668133084058626546515621706592677748264541998335302067693284031047914414370910433910917853346703702752017311701370087768406221174636457161634693311184118695477205673579866365261461786447054994132502457715569269165081396243597525386428206972507983546973520886724081775555138991647659604473279e+52', '6.8159', 63);
  t('10125003344964.40019736846338763496828575459544161517257186895064610033021488387585533013795387142569984', '1.4', 89);
  t('2.42345584530855605369352607812401621812969514892052587699595659920444177232215830190610734163995767659717739085262295176867928060719223680015363045876418329825526462245791557686517318912084055326038644410192581225881763601238326486032097397313474568621301371994854117791159281618952104825018353797567777238802251899860635626775962501422496596274647502903894924414615487350912292031481351426623112873751676007424245517123533625171075882961511452925284934841852786866383531618051093655741591513417469573410554311639321196001e-979', '-0.000000000163623', 100);
  t('-1.4631650542473900277009650505078819321358806229e+27', '-26.90', 19);
  t('0.000005295825289418576524939548312590198218162176', '0.468', 16);
  t('3.05549283928318655080789264037405744521084525112150000840590011398025015062827701972944507923133274963552582295751430636384831621423236859444282002625831436173279343347208611168256e-1317', '0.0000000000000000000436', 68);
  t('6.8737496584907426626313819245031248376837843308744720028536801727310422590256416090562808800210844531270544472690018733914673078562856645346395894509829890694096382823686071373178326267458718358846285479617141539840116621230393837804338664073754005311299301249174709116759875425996420794047622228612301608179896688165566947248834248141957503280864708798493297587091913325875132574818764391975237904072613078649529818121345346997223704868660928398187111003322117526971179779471513066563912173514255531973497213908454568244522179614576040541056831042204810866674499062704103999143936e+424', '147892459.992', 52);
  t('-2.8146479662541597081274416178733121860079696712353521349953087140279328650573199835200989048752954416072723266612561673395327067860385419926496980826273624648819979832189443473160998127180490840670643347268997115172483666046588726408061842543063557107507571471460449079090247848491631453237051551777817536688202337705039020111356944014738131800368308453481235885327559176247859131329636754873006899345889798004981220291943445182637375840333548122722503521409219604293110110218239977642014577818005413689988750976249287035141420798845245155557117360125630350198594871668428356167381408479509575844631810711980641599329408885428661560190538079795413218925648499321738196539353823363150418207529405972685060870280312509298991051194276419276281665021145145231388777163604743396002252126683136e+708', '-928355316.6', 79);
  t('4.1550056575303757228119633897485161478257545991080710781246444078890480445595483297162130879326322767394020818992612209273113282741423297800374026062917889514219222760102972249776783705399405702208500983661432328199077976712616889331132073633345739451305161947343186063845584853370234906486236182246156880042982439581300028796255911192143593205953934116870666334468549426713036166883165227311236788431588170407270107831386834377236415331046139978378131343210669779889432793552847716954802965953947383085829332369100621026610341613919587586441133939688279844321511780619910499072915827001583773089715651976020809993294119257087611233862264828674135126902550664589266837280471718998978964104111815396251418310806010610004963036079972123625916091809522896488981728056893575146362581153784045875486607998050213627823201e-26', '-0.433918499439', 70);
  t('-2.13825209215512828440269455240169347772084407562319954177735966744864590012014618496355742013223900851293500036195697397558882293948621657334016332630442341312358031641684225772703692879077286212410249112292259617578818732032e+224', '-203479518', 27);
  t('4.07921626152759874706750636234610711277511981267140799487233110013700434628310396204835945123342429644616677263924098409140271398300308140751898877152374852101672423561384671338353950413166856702896620695812471792217562634286857498132969913812033679861984845959241689697235821203390602245450598886660048044481023188506388871537857616153846606889656647661553925800233006508370220964183808519443488054785371171178458637493447718543668982370416902695149696323193977948327786874993513535986236378654219637640158954029160466244562872094676729043997615005949784734421964950592990177655538750040478391007794104382875758798061808214848367338145330473927905182075863984150597953008335668923177942931986912633579578368880902417004108428955078125e-349', '0.0000007725113250445', 57);
  t('5.444517870735015415413993718908291383296e+39', '8', 44);
  t('-33338.549041729', '-33338.549041729', 1);
  t('2.7214030202002235259872217354276868322505756236796101744750922254072943468398158090938361760503196297567571421573431913968089480080443473498108606049915577803053551131894096917430267992139228904833591260925102332702863889641131058350845466180073805176058062062511496305436593986927276878340795001904960142635221849217162104418149855782368706167456898339731322626805338533602069310753044118499679070391659043014863756212342671519561753648641528938961249781667596503442752009505056776106357574462890625e+355', '25403380.775', 48);
  t('7.488967886646769020135665775188919173982517766411546419429833806092666779946692720558606535250488757150058796202968413241639517383652620019580992048245618242802791919565261399799275748008372859035772846386750851749482155871108863512939378067436886935381752737141129513585362569208124557454386670272939418822453438670913670149714787757724915875534683373244734438381987473430196456436990814262346701710120113213932002664424213764208834743329181661358839573220074737883074138029822996500442023856383570524772344040729242866145735668954219795903770313321694206678450634108956120637363083442475459132238765735069225942833258958556032448438304510175681777905847909119739292131657606066356382458693278659384332038729633098815077443043626686315515128390302721e+430', '5400237.28783', 64);
  t('-134217728', '-8.00', 9);
  t('6.4919612772480684272077477598407081955951769084986853540654908040236664132468736e+31', '4.6', 48);
  t('-2.19516244547091597952961625454695348245614659050655334765404613313384017646438800510561124115050347626607557413049526710505947787909678168881471450760692589194458296975014469481607782428972426101228030076378151928725802874208326366011927330053807955414428037618766935246244704158022651997839e-412', '-0.000000000027838959', 39);
  t('-408518.488', '-74.2', 3);
  t('2.6122383559387081296537383480965114437482497294603331038492821930754511334614082451247995976011754175948033208350877260508339210350470971773483611262598975948388081226982520139805939801386768827832059816233575763932242012655210850575522139572300856461682889553829554870249034765972111622144e-53', '0.119534', 57);
  t('4.9850229727065564838552075936058884072483546836617925693918734591757063770692197370714015506959425473376386516711436607268208277636503475437445688665069491061323537515635105084625953963084527783397499370629700852265394871597666675552871197319798769732286411073611671053518019648674881861991039408411419655406435532953187363560760310907326462424912442938917143874903625529560559341987014054017728254155646042683657020960066518571091535493426634709747560461439105274695605741238558071638728063086433086290881426724576410242527931842535143281385481835738259965154613661873378195341787543569962613719963795456e-148', '-0.02709904', 94);
  t('1.56946509471456053067919046607778209965771259504948582489855492239980383980825548822368765834159376513519684340813231776441618746842197628264511664812727788324193189716236172201170988327488959873357917098281e-1180', '0.00000000000121', 99);
  t('1.88522188856624562372708154656751441041381726119427387599765763695834615013232142421520586436232009071932931843172032205056661409003338693915273301223126561630347970098203184279906247655542800284362476149094060315694708604230353242909365032002466875120342181047689475694706227284673985251088619705863125778538982501735383260557349198668384156297528069830916927729430864813333996813440323955895348081117644429414429531206777610934118661932545955356203081687958272101e+350', '1396953.01', 57);
  t('-7.4641079962956705920034912695642465787383566977879750308559196923222402311665962335871104200586964218306687527948988363660881738310704671349709669487610144905689251123467238632699575375039822099609504292687413249132266915915320573775450823119373280252201183083672896166447786672561808861768782076443312543759437244643146889964363933455672502577964296155349186564340392078021387512970362139779496580009767098175116221996336815276032e+365', '-425417.2', 65);
  t('1.915651048048760989675223006710502095760272088541579446290639477213455428121307995153274075329786132157611746651e+72', '363227.051', 13);
  t('-7.65032026817518248876564402449082201253180407179105772287243705588834467106246226864795794350056707139677395342984049031608196167e-158', '-0.0000000000008205956327', 13);
  t('1.5286700631942576193765185769276826401e+37', '7', 44);
  t('1073741824', '8', 10);
  t('-7.492788722116264058568890205770570774859100309722464309788118049412229345772411480224300523702767256086276612012745150464681862935165491623598382139203570285583278591609354972796097254467143774807748614976801272704624819215123157317922738427454525033948883547809409740884056108275497786621497433099431568320476275959806764951584862378486525479494452910448127181400467328943711415916384184330110378180608e+38', '-2.6742', 91);
  t('-9.9615483925456314514941835282258027490657130453558630944504898425429565393128463181577359582035968e+22', '-34.13672', 15);
  t('1.399922200750534682219817715626042346444265577310152832656021878942015248035909712686518235139333930615671437276362060231490721869741275050613538630628001507198150040959125681675660226363983554975062957910826317184614904091530578807538850671607301864207908455029708464592014690257839027200102495492869235566493012545340996194182688131148892605629158333606816661843824439253963260085811270982958376407623291015625e+181', '8668.79595', 46);
  t('1.1972515182562019788602740026717047105681e+40', '9', 42);
  t('2.202115503151472939378975945429179012130502358719841711078827390192395746343741047199171734327335651520251442046215323779489495715592781811364085280202651471923814503516348966730262218625708815960745017538450289188340543284914566286787264564178893226078936128988787471928557990525062334846282320996222324625945765877847033774462855391128649374296526404082041033729448885939056214542657236719090328218184247313009075703142241933320700374462796901110200768625476731302618344824136736084289091354487089946804741870143078521211017751418875276281149037837553896673998109493098384421833504725859181031374464775140113274356212635994412769954920908641601e+645', '-116623347', 80);
  t('2.809433795080632851709145012225734908409054034941321241601987773815883609706743541544402166343924517939889529050536360240983658675834106822309237371584880050176e+67', '29.26', 46);
  t('1.07868398780558185107374474403020532661797776728251416174497323943011899689646635171198704732611201406021634948916076829493438856010253804362200645063540951721664626993793950535311074968979486772512114485903108974813153787515086384110800820767447561947653627148706348696137405309393089297059509877094341371443072935310278087678490134404105182181366232864420501488011018398616532312274978834403446637210442398221579810182631353067504903643457223517919753185513169702647264458151237138501509960401271778857785196059943376161475076004628662470655380785641707995265694079267410121449453510909358494365516418648346056999086350031787200888670260526532745451073436638759925695050423663041216049456771565033256332270529303132799570858912705564112506445240662496492805855959005388730223329638719134014885120936603994232094072118708951475531280218682408087208751084100846868818757315278245976624833064394058879581085028991210887627047410825276390136344004466080305862737728217342821469057995832117084467798274844185879951131300757779959691834097216917003287899924056620049926974974109199191606737920319507952408320236800792559969771048293815035062609730066303408711203037138390978875350456123554886388685750150167745416719567226420868939694324912807423373360490897739135611243033809540137389420138490212707060759530504538976563026719537360751101833747910242549437103469735149162329286577965743319935974856372834520558206976e-156', '-0.0256152689843076', 98);
  t('2.88578006478481109681709292955455719460704031113277109068984071037918062293570113975476734737301949530731913632979303450186466568369318518876187546075767065504326813e-502', '0.000000000000027853', 37);
  t('-1.130764362193076554708917348657069436161383119992010510285626112959278426786936465605907875370782367006311207257151205709430547608789956273155866459033031412425747753017041228269946019068798157376004812291000927158419091251680264057450083682494989856683271885476193403159681085354715517423876371812000883161101039915298940406738346701704184093773206563783365396974283025554248166993067633181013835776e+229', '-495.16', 85);
  t('1.4079204473765793611205659398747988324553877949122198881761823569037754286497795555255078328593539192688183469346829895557363028984266513451480429352198565079209701785014261786299007878956587947295766448428517173439894654471188272662954572295701492355589193513351750151274620765557903307460230125360124013361832687856567900491820049531825904083512531047613995244068915188374911719721681159419255851678650464403431153812796388113981457279816536052532029022159116363377812871507097009696999094856073325011666162559051661029942614061375069471909443382620314251546452011990276242995027453796323946493608369520697971319607477108850805623943653859336240552463433942656966057268476396727643619402363764661755104039596942016778012443861853146848694945561138583599984515041713806683288152679908819567129262792401029872485370102439410128369121641465473638876158320127373102022232994888209825736760912929558531292428824599483050405979156494140625e+234', '-219.5259075', 100);
  t('-3.077228040283419501485435148888847716813106712632276671229710377509021026817676725408321326107948661263691709915698886286976007892051135335651197784824163323643144277812710153968406419716183905139635176333083510237302643593683953953477494067043109636077672667948180821005422658784541128359007025402810248257138220199195378601727145592714535208968044372704483391015842523268884989073259915535384596690721656759730286732238685451797332150695395077171985430070293527840123294365665570804795301448909420756992e+418', '-5398620298.48', 43);
  t('2591500643510.8703986391408896', '35.620', 8);
  t('3.477283234494247174955772981135213481734078932418183722882598073322692286025940951446621170551672753962398590460771481424186923218942154108093532866071869012357999740676113816609494789228401437424825811561820654792528325225812752470383184957891230592748660748903040466372367629077067239697577276390325455061343687182891385586253067945740768918704902176664219044850100644662536723412908533903648591296570565588579797033639391045393005317694425271135677214884155349799855536719234969547130129e-1361', '0.00000000000000000041249830', 74);
  t('-3.35390966929685775566428232543003229321430942684482327393890454463616e+26', '-6156.933746', 7);
  t('-4911940958770.721866380729238693889243243167048192', '-25.7122', 9);
  t('-7.2098871027996882164550848582893324736206875895159968045387594761033704208535510362468505731281582425298017917320284602282447985874106953873551e-295', '-0.0000000000001626351', 23);
  t('2.09670982511886308779364382461226064522913244291274975553909045464953985730555995547122852179186171376596687978705841751285402054060384366505333092240660435368377833186306191605049e+179', '2093', 54);
  t('-1.3120135409024675389197377e-32', '-0.0000000000235855553', 3);
  t('3.06580286249339590556181770635869764259023245764469206004664101e-78', '0.0061', 35);
  t('-4.429293345196932276984549040219058245905488651609667018402382745119170674779904528756935495114384894434070998056621967747005022674509457845620395626349316891933712941619646377506486625368600115937614507993729672492431012578899815005421568e+37', '-32.051870380', 25);
  t('1.299270565684257922619246441017034698039805547412943905460754496572097300952165266370194652051376805296279609746312644347199238836765289306640625e+56', '-18.85', 44);
  t('1.566108714385843340192620380546546555641735293434509574033302065853656477829384746549085411912657151882140111651595251043453318950397645765893613409097202898027341727466585518405768283017471302953847629952837298920882176e+24', '41.0192888808596', 15);
  t('2.61958676888190130160363553014940478261307337527924200329289138176e+65', '-1866', 20);
  t('3.23590932372253866812859949454563891250217856922745576253641197253435665205998361592799809e+89', '2474977', 14);
  t('-9.7368504802272205153595678239454304952368475046930119079817985916928e+67', '-12', 63);
  t('3.44552147465294110719732986332367243247925798357929806000836849e+62', '-7', 74);
  t('-1.452398236000580121072066902680504451473423787336338424980953647832201352052465847557295963455561081881743103593061176242491787910639717141192177431170020387387239122306327928120484949004627255099437140135623570858068768556995906899604425201341758241176605224609375e-198', '-0.0000000003794433436895', 21);
  t('128', '2', 7);
  t('5.65251025822228531444194278761233641822281792819659230058333528631972497846690920646507426317458140864925211864848848044857090776165664263450974899867329254381660849739991179791628529582217569168185463633540183106805961127540063207424e+251', '-96880334819820', 18);
  t('1.14107582607108828738727786705842372956085739834768525725464902794127546836243697599408154971875430236598124720627825695807225748800206865776759209466523560191022176894495595957948456740052589766169910566748987526231116768317131023909655394007055203701522554585739267475902349909475429549403555539653461493158398661311247261808161537169043101921093658271479583004747121113491003276556799338354235965632672999762610653218768326389269215399799820616040039956676066934784e-213', '-0.00000054573252549798', 34);
  t('2.694661255697411397638382996364833318896569132107254175704475656993408149148787257876989709118912535228351106752665777548202167498537778413043897904425246334243516040510224069308160416421621694293323335359415777019643686364603342500176348207942392201863311693577378702165646022467014567507350758519739242895637828787757898674096128347546314083698792347687986627552406389069409804518896369803168004318670513348178554684863589395170672076476692813070782506346023243347685532106534664790313142896989018262863589145173454075951584755268325058105333073378797737002280203168643844576066486206631537822243062881472854331833497932080918039317893726556287893765343937829144478219032999389426126114377441753098232009323368937575158666282216495169817356507116769115165201637431411429901795895447411017897288700508354934492324978841890388723566094744246181121450362989343657238605524996170413474765724415123048917997930643380598337786915363082241543058132144906707064242590005607032784044327110468761297341884902367668493103410518314292043153000929758576269862004120759966136121319405434151364177997201999380295579576988910231518865392237933271936797413045669678563984190093867545214722525723761e-162', '0.0119276152381013', 84);
  t('6.819668312352580735571062160710567114849175817831511892010723043920379092031215450236971346081546538898709343868035480833649809755005794379226534646933878314382300734811205288513924832344426178927991401393582816473921386210239936761734834845537558625877346857367488344220978330978463797202471868399404300493221286022793154457818428986435946448801449065938442082235318928992721704504378480165785082979441671849270351366472512862482347465713408854026594512160429600282728718794411008926422853751208126199019311146437195308261518055169159585380164716319779975316169881503852676219525036820498468552310784e+393', '510194.414', 69);
  t('1.214529036103353599078303402353988354368901290518483617131872964733929620706476271152496337890625e+43', '6.5', 53);
  t('-6.347837933056513353722482549802422893506022350398412637063463118408446866348060970316579990161491662971791431669434501980107126871004910084045827612746953888709955252364570683937894037212845688709149304388261135750051460016927221140392539241810645976791531257356157419153359404750948111183767643741377517979124849570287898660377838281034265223482576628270475748463593328028769895760141786535396100135700043132605861966879736164432625165034941381798797087075873047582570991477092202474033008636487673565486409112008997813187783434059853722747545465564823272494338930887139620822174942289758209743101745474476030369348174618632813079185886197394019109147868498920361931074940617039630508529285432884170952988080710596227749489369515496826666987363170244800209006727739277360232390906096945537367274422272e-1224', '-0.0000000000000007921325322', 81);
  t('4.427788351999056892908779661304294204303506505740727156388644268519265092320054815319679560671232535269063116229417433542825837713401836579398864981866891524018752289794372972338646723907744000865693630274469282762772410301411230122599123677701587004286800853942816776387032063244935274501241310871747398849676492965589671571039172675061157921330595997693266588428933017692954803972839671865559553974412513763174029378195757001005995534096180268496099336902456639779966934268998934512369301143425326651935144496827467217523298707659499118081164646205877729620930792063706409045131266902206188922084763864137797951942027404778289235617846011440638260873801319970320165240018403702195879801694584203559689412731527544179035983805204513123788649219706079228081e-76', '0.0355539787671237', 52);
  t('-1.2019514515640847575586926976222420288880922930930392632826439389028070216309009753873171550956237644053737905713930601182266550298694556856644221165736835506561041710133625619715943531598437067853105931820970146527606676211927176997675395162032067921680902917533169975496828556060791015625e-332', '-0.00000000000050893518745', 27);
  t('-1.3089738102615705488950036718911116878301386483323342409513651601949943841095689259436086715966084434967103664037924413474102289403813212913777522181382481044473580351805322191321973e+181', '-78533', 37);
  t('3.96435664551023166009432527884162006067853796367737813024190430384615252569493823212334015555476045223745267710440584785405114790003193045416759973795409712664077896837596687988358977963017261551575085886339378601753188813933464452096512526061746367179589942239837535849629855994642069316614543080293743786862266272667077293905812061925850138605681557967339405649099920095406780826427052068862402508544030914598887413326170889080842118181707782092869110288450380556681201356803298480762937106754408669544846715047370740072553230754652098629105895209895679440213970887252806092019885007412267948350528687016986211524428725145096245261205664457425524504259402407667126129396321622738877790982973827629236592975050954770759254867539024593007061691314559144608057254973749886498871153697476316002651798291357530399789489708421091129587128561305692205004611764864589809192513065786225109359726736441344e-1183', '0.000000000000000440688901534', 77);
  t('2.678568043734091619878005678603454046890065730319059041066922617779738732552013071823964867731789481610691269440500962742418256182423074462657908268651743482014494029327824586172450705847083812144127819545703393146264767652584905037972471212033862288363332136481985535835026012527790465668040492097675469321915742224501044837369992177682352931842218853184230289300338298905895371981623996281414258096442423897257161265043380604655709475991898216307163238525390625e-458', '-0.0000106265', 92);
  t('1.726146302297509640766292449752859764903022078656430010248920859830072010352007366328438911617657425649650367170506346895173396486476847725257574613405822496736182549233608967999820941307875511369188178896525716609263902445331754066625178138893213646783862066055205225450522717549872978272577099559202040965374304210695726239275248389809683461472065386641615538014939133369785455245219942798762563171967930161818698263654632146616677273270255164005761339575073597428814125346630365394507885993312732399706334184762774047407763728952601184374357825368624589796928083783689318973871597143367328054205245865104545174016228334760205754534111255523758589108503454315120311926536799827472005648122589642825287832641320048477707961989609306835298991026782291839544666294097047274554107822412948625252397092571160782378777183761424371215388093802134334984812532390805884157055020448204417356561101547571620503859926648120658212095674300954695082023275140281418952276189324248672101519574402708232154221216402609706003426735616605880789673740701217723552955825804146586105232550363059826111286997462404300893227116277343564362324133906878692598854932115522796052836850267098160405721244179608199869338374556585830298585958747040887791760204298688011390939627724800498866877415562066410814257206608746120224395781406201422214508056640625e+222', '260.387665955795', 92);
  t('1.252453015827223091648143056289e+30', '47', 18);
  t('4.593884321465082753417847006029094939767153045428871371185146539475234934788078659649525017869031479813190380591953477672897146298354193774199686172307595609685062957351072442717423824419651156326307969688849329e+172', '34973.7', 38);
  t('6.4993779802563991313942147088910855038980304493628711994552936552675080091715543868582664478495863312478503560216160496462563144213423384672637506819444007554298505039521124189159003567749810227911510054190116940785207230365438230686589958633589792785739898681640625e+25', '19.527362557915', 20);
  t('22876792454961', '3', 28);
  t('429643228077338878294.90980773552148447232', '13385.0992', 5);
  t('-7316.89', '-7316.89', 1);
  t('6.87914590155026303370980110789497161335603936645395950008039524549423998547430459718690832485899591715423495939905041962091003793736119955958518759896414837384978971473726237305516963629287255286872328980051210041042418780821291070799434690334936525030793157741585829279074161542016174895927147907012499623328711921362945061656483581268375800046383063714806105729927399779641951702986991589688809363278120544452733946185051027375853021790353396740959054941411469330354238589831745170722278547542572570113574396538111546572410672138305451026720042576080626158546636278154541296219048542847365418147562911738603614657265796029784007988955899036541413836373006221312e+589', '120217094.2', 73);
  t('1.239574795810526079748489147215724813987666305795348774093301305206857104388667872792722298696320762041716833793171380166642565938543813063965908215730138726274640558732378376081345774829243873301016011042987213064608498952230404692092930689186546931537772947407974492191946655043420261314494731696589682500096515708673465576418083366037746066181944261200756080966915362706737228961228094676733386508269067016989638785370510316351486703825902385195520744639816051326954756067123576368987864531312848054804595825163440506228252295842312598308190174979485478767598866319117877799314143909178603119708443578223570915610468469949806392232326089217551025083863958495966830034713358088911166327675839869180039029601144061805857957059401720225647922270097400056178339656509407631860651339114653575907071912293895974822551650560599072628850817170660484929519400346271419914740172937356080849208976491109534798334462570451085006567233874961401450283993130878770062700272556416772479998171111870509759292224746999678148420295642269858123285894535197188590937033092112714248284586801385841210089015311172545935949730111157433149124120743103281523326976e-1070', '0.00000000000025873908155486', 85);
  t('5234016485162380478.15409743331356736233224871362317808951664029477472141754368438049197212877764328120319129016485361', '2.41', 49);
  t('2.3587523476214488265105602233384822170431351571499949327792901375176219636953224670476463392373342279772850838452001851364491120595912397303760903286261541146631936830192308870389073374785895767836490477131403524578795077182693968484924474587814719179230245985331005838316256612823429831217004241217996728082675400098261089625533152223187450996066900095561520954236869900406302680423400482744491187930028993448348081190342732950402585676045621897388802838551757987655079454177981594526914994900926245046947484718071152759157721281932920908780781390332713691860960870572770040761154320419837824189071690254844854593343459633607733189681415999534694236173627509165089552965354274533408153893430075897901955566030923516936720199506503090119996175174794124435874644332511673899164593545913859009450879811276894036262929185905062064201251350256407499186307953211211742221462225577354600131030662462776599229715013951102968270099539931356477033894609326532954524810067603029689715219319863214513567526378103385141785789916386486343106420900301324775823843071160771421983879429528958998947915991010621806091931816141987852367290525737e+34', '2.386282102713', 91);
  t('936715201610276565.121219177846759965092294037184459655112420506770954861339939295097568524612228771176779451285540872548572669139410080641220337509779355970915039117791045026675942372796217903566744371329096278047272159067195543527515016330528461268617826559677152033625945241108753484887834868554776141004652395753058963525578493344234441729097555557721919163232938285249196150226085243092573393734731092201479606268037047533934826431548289543047983548470548923290980238572301772673775072264037139381648624711690145835765678758822594470249537696766900852116381823037280731383416971641039263361', '-2.368146093671', 48);
  t('1.3458439131498195323786528583479606393575536164255741666418955356844345324579594678199724544070952537313508949217012282459611297214665778807265341646101943507184150142509791982872347949683325035172100020000154912216772842085357404197730651656947685019039027437632994864578420850298458434675021508281598421364790325204120523582697615926276683088910375524563225657663644596592216948974056331399590460267403223032587644165524444425820025328591360851973651333314015380853968023632372287350054207185599371069878908668849043723938217393218749026137508121697823922573029674248393275179922555863853082171000692921875494766992093057203484510278165328340192460964396895589377301082266621542097676974077616873128400267882521248810555224844925459156239671725294657022129911051697181823809807228700964467590836700654852334498610034031401231488158553123767644737259941517947087785101465826866359735042387848014989852599568750748869928849235262872434098103652425750975704592582899579447794113208368377654003816485721230449311530271585346790530790428425713522163601027306457750920785462406436356452477565333325504326467125792987644672393798828125e-410', '0.0000087069115374365', 81);
  t('-6.1929235359377507312281131012038351587368950153152975357535571845644005480462974619161439022738726479946690750026534164068777632032187658972625047122850721897565751294389171057608669479324287486532007867156146673581246410700360784140288599508760017944860321480468003345825664794759524541276131175689087951776415011273003161501760326678723814154494949608727351108658698662447773169903947201447280945550901147241628131791799019695838180988668491614860985218842845383323542953554350520436926580209264504224289641207101059908641550039414260263864284289634535580271422536744706681662746231304579346896472244224610217365387765143127793708245503177386221263366770715991973516535247445600197317181214103464901242633208165352628228359009946968657720259318250928483525927379586656228952459195584561227411138226350339186199256456210254130733123824550545306156294840068619857494045273956142065000283386051662650884544228310001e+238', '-1527.186030801', 75);
  t('-9.18448171920669942200338050009727274073573579465100492416464784644248864677562331387086995022599687737054074140424187879986024804042070022603490146718362719056788563440317890910682257768632925460866552260450415793672740716743856864948011399578402033107962721324762764871499139470157293091799845778141752390211181570286270362089589942764421437922022663206638528993662330911966459538905107421403529415706249287725923857606476849002798755812680628308770502507877888997449832630062999974358780733e+247', '-11613.6333', 61);
  t('9.00534500151871393968393182204789895254808009774083925739583913139744428258820018895294210766290738563245192706173741434367174311803991979819858136383571385689405915210566734194237574513700408103748220971184119700751936043969773600887138954770719916145764591788895536769504424586656704372424183902701252759414411596149470601541857251360631738659563583649636774213282738217476649973300597538010960389409378261220341346226990122343134167832094311982679300076141215464857703660864924210486350832131660412093540844768322422730252869897097733912901747800467318861862225211148617574307735346975751376032341961536913141883210606579274491424216450106329517468829186737530608281956211322014174714075245950188408511119277135829814966934159576369452442208992213257734675865633857771370587246881314008195421762766997418140893877428847481759362859431583598206066370359444199841730507231732351726597037154719568424203772133372253713759753114003013627088700294122141177777020252868547836359305587452020511868681628046227604546542259628717458912576794483424426690392370814102629028715884512020934842234539838799872e+1097', '181614013181552', 77);
  t('-1.23528311430017745980681640966956076652030679452919906158752021718722301574640224534929754544956717572460637538159556600593377996815523698860198279346656557673391582603822239136397525796715515594924893485174002763423256737401358209070784994372919823627795438659925045145838110381445677693346919667629645750108678235386703421232818567784359923933722891257791623191263321196551881442530246560410717585179292007822202786185443194364605326148507122824090647294413224330381273679824886549106621139051707355050164555704989028861454165044951508278420052199256381844433504794321028008032654947772671808005663922922038567755972745149376920700771177235017180770498424038993156220009935199044697962770631826942473822311984815669248e+475', '-61431287.1198', 61);
  t('2.648409294963988844015616e-24', '0.0000000138355056', 3);
  t('2.40863472207038829716951461596425356200891165327233287498341065017430044564718221477455813374032856667895504085743031089347856425830213625711815509685491800628989456526993157007511653813393067316060298253585492583958097263354394562221211900373157618798878275619835293896301261289133749847496154802330721946407650402052956106639135229248180394944200385403412146150497882700273381421471626181859523581299015700836664867216504968658889499860010034200157321932124862289179191239642591047175122517733014555125735104472403712501002006088016431555682009e+357', '6337.73', 94);
  t('-3502571449.82200575261531309080576', '-2.6', 23);
  t('3.476476818948845998001030650476295453181247545559522084788918535203260597551626095245998397584095580303926090518042805770647508288690085639158825885044253780231438163844934309393e-520', '0.00000000000021393', 41);
  t('3.01264602077503396553028159046697775952364093583950024836015253833440897836386470207048971682950128610418919156549188373312577357571717925360563881487841993249907698003381917913550805575200795765716052288892628051588664016510473689746879884622780863018244491731859793637242017876542348273336934204544690232710638389609197987886252503990407378825398639153993405459244929392649916196490420428591295051414371300821828051366484998485944752317128395695896528773542603956895037622256170062938519314235861903738115128360302046928256980541146446559607826088951046677218861706599854555915276720853351646088067836131525708447208119772629571725216339427934609234459201358526789418029470210806603721281e+161', '2312.83553970261', 48);
  t('9.005184717176930478102791782076862228006327352615805784783146333035706197635879005693552412099811970184378799956879273e-246', '0.00000003753', 33);
  t('1', '1', 25);
  t('4.05129929545010159177895753388178150581456809338867612606558959308891452424132880822384248894555509941430703770187352267719278049966852159867408411313868048284652990968283076525530668485093689102888375971926511478236021580486207199815304541755517361681744424769768925178687424398875682126555432767026580854082660116786254097997542073404521882149466694962687119267533030305371904385001716197248516783116746628128159682519599799144439980293050507629744383718958560423968444215424641122740550965524020102239043491734038919336670135222799567722578231175799352527458223575143415900224592903685252952681818992387167675100469288777308071037639375810753979067339068471e+77', '6.310711', 97);
  t('-1.1809125003067061836785344667120764389443931749265317457525459548456128442105786285468877390219672806038351135283671645849621670658638427296075188535296e+27', '-7.46960', 31);
  t('-7804725.584345565904628551916716032', '-1.8', 27);
  t('652.68343537143736977925527144667849979675453569710942641839519790994481', '-1.1', 68);
  t('6.347632690470980780771578675552276637061059382774318001265539984506213934765263884921639481863522855446850248190640384975242547827559674641143687363586046653926918728263293566118669512822042487976415052111413256676605941161792519436820477099825895274456934341461395679285131684015935258759683653353217057215413375333241770058757608263160466756836580028579606957497117342564425931824695481220509415164212500845154298184282125397297745919183962458931412844756465334244299196320609660981439919849161615207060803762786556888490763055537968954854206553722868857068202003810763342647095974540704073677096870053573460935331503249667563019861185471271460943390068145540005687872827e-1245', '0.000000000000000002992906323', 71);
  t('2.15563894172196024093920977150538929699155317817435721941139671042584098028409386483275286853014376052273085179955316467499415655783131107622838141170698636978879185262823690153018555305556315588279210146398953033272874508316308577279223442110325742384869562140427172170238905749958161250632960545305389673718773669576798283170556914818983685326769736551061354350641792755121899728402406494468077316475802887495468901294965903992610334661015465862948472103491723924769010992037621122249854108885083324606934823928420467636542974980236452139793226916820487035909041906512281298939379459990899889643386394707926539730879629157307711871371840222169925653434081781148892704580585587764074713326028394355564539751395890997165055128928791058726295150819453922316393488593599284988720811174363504621711710563117496721630026298161236567852610043373993852510501083512789025524730162959143248393084069076712374797747281972636928788000180283289392557e+413', '324425.0251253', 75);
  t('1', '-3', 0);
  t('4.26825223812027400796974891518773732342988745354489429495479078935112929549619739019072139340757097296812815466676129830954465240517595242384015591919845376e+55', '3.6', 100);
  t('1.143346541001259437465016483752642875340200408207372315398374410086504054045958634479945641547514904516533919702060746490155830653988883705469429546657675670673347514271976875109918113055399954802405065425692486675365016543448426931378922954782957026636988416e+190', '-388997.14', 34);
  t('1.391479860226959780852496779461260634580951060711489905798047445581119629509685004732118558920853318033429289719854192097911392274604744812177542476869031306237630906988638098552100901480110526866015997536096860367785128698535455722265589251495705036009334110148089566472594008624482378925581538366245059147829461639938451131334656e+162', '785.994', 56);
  t('-2.039429275458086101347617297850948854294429450037773018607110681185721614063201210356599410953e+93', '-27753', 21);
  t('1.8072708076715752612606017458825273480777271963492548142293548724970849500539908571180569517655791008990836891664536992680448e+43', '64022.984420938', 9);
  t('-155568095557812224', '-14', 15);
  t('2.18753957001465798602093911444285519704647324430365134831536108015616e+44', '4954.46', 12);

  t('506006218906684823229.56892808849303', '907.27', 7);
  t('-7', '-7', 1);
  t('-901', '-901', 1);
  t('1.016984074247269470395836690098169093010136836967e+39', '21584.7', 9);
  t('-2.137188356786572105085597593380951428481871335229083554584070474976079844687257680784073933135806738155' +
        '846154867946651092729083821725815874768375163982851482102962410568100645181922392637169148087702583906275806' +
        '254987676848814681203987550808366160736707783273633323341494160195050788402536450819951456112231044987896082' +
        '054284953492245429169226582932327802987445013148530522433068163661483119195972210188504560615278918448219025' +
        '00302159789434488225792e+125', '-43837.525307806238', 27);
  t('6.6067183217034216835242910438119195789788339709493349261334009277024675568767116522521737472677079426635' +
        '748603259327817717050761351617610783486587612028204471198915744801916514515768618923473461233676712402753179' +
        '616115705829361991013069927369820940249862144e+28', '-63581.52864975395137421365938883267810362492', 6);
  t('3.4979655423042386318207008930737637967359866053138998526505479068249644854876701482811561341347105355107' +
        '695596776164641704434681969517211923069874207364828070027467521475982678466251216378786468053405366050900916' +
        '905682920934733855175647035328921497719019616796867272653837232009633511918699584196136643032274244642212313' +
        '884180837128156688381283842300678798685499010807063746785776492193558002382725297304258913361e+62', '8606583' +
        '55.93419774133511168973596889241553275604551215135281', 7);
  t('243', '3', 5);
  t('1.1341259418236998571758990926811782086077524757263871423863079766086030645673726799115988350322336274469' +
        '528121736526520039192242333771040454545272536238688950013853620343757910936524944674880346697808001951639020' +
        '756685105416346426508389541123017097529060283829118103883424462596062875341251599735321937114348037712815556' +
        '934333412355272212045907182873831909566029976608100685207198148793211027456e+142', '-77969657.57799062937836', 18);
  t('-3.002868635110885376257819498476291928435426781135644398581841720946695913529443732738563280115637723690' +
        '527669601811845008088443533185638348230873897655818695558823986816170233733475974743919539739293881958257711' +
        '082964428156108562084141530748801048154746755861630902751665438161045606541506565311391326592002987029794247' +
        '9155862011879884534002975129045737955826661617772520189976935251896803639204375428428030749e+58', '-3144155.' +
        '647351179442684823966727126493552586749', 9);
  t('1.2017535763663944855319855165568672417473424918240625939835372525654871294098024731568097136162414533196' +
        '302209237255696285222881479316995572849461193750229851490507274307754777241507309897136938873682646559601827' +
        '818522406048398360528045183412226195227922260847969487653141933223147699460606337223535312433317282585307625' +
        '14582945950418550784e+31', '27540.61485935537676544614263765574563131573245204', 7);
  t('33715.504067877824494301254520391898692874566929517185069539454439093971130103103995461456226946881594407' +
        '231961561136789085959653748072704542114811853522742743643494246976010868257225332083632035616264964911458078' +
        '6938367825230347818905248996593031355662611333376', '-3.68110925219710489918033269313682', 8);
  t('-1.157385562678413511184308898769846329872668259271078544423253372613586833033423503791374542602879075132' +
        '311305638124240471079826030985837104460703581522437292662638238646090030670166015625e+186', '-7784665', 27);
  t('5.7216584769709576633639728428105243709762039786762015993329350164736e+39', '-8697220540.1137988', 4);
  t('3605.080945893673836738483946060969335788919921875', '2.48435', 9);
  t('-1.362404507662848650537496030549874060243136512349225493914817345823216048548172723419966950986850374951' +
        '739062406422122991421171819900345266361503090008226665166641608549693639479556058501083403734722051283642171' +
        '702315664077013568676066027004539719689871686866966504316666900974963459985167975529154752566435990494883222' +
        '43247996920458277719083301674288561258518312772229949771006312491204843363917607453589630126953125e+161', '-' +
        '3009460118.872263767875045', 17);
  t('-3.843371297315665982931203359606126137800390271392237908468836564381335317605019011842110932416054439429' +
        '378863667709490793077731714107684101027634234502991961374605763957702424230907755584087764579064955483406351' +
        '493859629284536525094600819056677481423671987511092619602892825089212125285973667322259735000675496129438960' +
        '5594296221696e+157', '-271616.155606', 29);
  t('8.880125173267286184293229956929e+30', '-143903', 6);
  t('4.4911854404409149925571757890570413318443326899494030577850505583635288027204483770002925339061413234579' +
        '0751503571600332872e+26', '765808758.66956931514481639498062905791538', 3);
  t('-1.128193052103617375313057818469912250487118062091774976e+29', '-646363.29196', 5);
  t('-38528.42458277771128223673975490918109', '-38528.42458277771128223673975490918109', 1);
  t('4.4731752932054401250767895500165212172045977003048118078740540509372027814009045673824755086223811265665' +
        '9162732461713512251836889602737214995151906586537236627456e+105', '5932.48', 28);
  t('1', '-13.97065588562499', 0);
  t('2.5693800113130673596912052579425172401156285606894961933662611589081996263592777487294665112945054695374' +
        '79575614097255886064905027804073982599354300474897943e+129', '62080.7', 27);
  t('5.8184614940398660397269861002282485754727820202610984176867121393228080929668759435750127783038726637982' +
        '733623328431481036051105505754347945097758662358771120575735317995690686375214099713422708363500801239117100' +
        '825191190580442024497060759059174441880072773407853158923191005671440255110099432788599963091463491081295880' +
        '09524947393206783018441414022970002633906397294399684375635228021017590940658971148436650082905540838555648e' +
        '+102', '6398.880593717242', 27);
  t('134971356455.75897529253431118705664765245378061900400303221733155570426158512526184604071289685694603714' +
        '4900053640398406244356726653396169868958721875222540716653887768486266703330919098362921', '4.1528548909',
        18);
  t('-1.77396388128500114222945974047586725531284545911409446577e+56', '-913', 19);
  t('-1.234934401068907372254145669800965657224014404194120877473524432765749324191815980973795365542372548417' +
        '270938366077639126652036699333110108213095940749940674117006576189505444008333197068723155539463584326235225' +
        '64358319794505880365894233180227408889879677018966524371664896e+230', '-90520083747.46', 21);
  t('1', '-562610.16179592649796590823394093366548', 0);
  t('553995165458.66639955830015026176', '14.94', 10);
  t('1.4941893958492691882112550397099333090864242597784459064194649425760971480442163767897353189803927503362' +
        '856448046387436008075500742061282723456500292550169543216112640021419198404623695509050987637232549016751357' +
        '87504979910497931539962354019230845564318816091666473025536e+126', '-32698949771.110178432792', 12);
  t('1150494087127674.2926708823617505372960241390892442547940194260102743306128298973371802547471453755938653' +
        '944600792141533514422490556963535378521856840746722206160260148176604222079226186281680715577736316488196108' +
        '040509176925372372483300649927835887344415603493563915019264675154039059770309142781930141352329958156926976',
        '-8.7358521345995835476', 16);

  Big.DP = 1000;

  t('5.5626846462680034577255817933310101605480399511558295763833185422180110870347954896357078975312775514101' +
        '683493275895275128810854038836502721400309634442970528269449838300058261990253686064590901798039126173562593' +
        '355209381270166265416453973718012279499214790991212515897719252957621869994522193843748736289511290126272884' +
        '996414561770466127838448395124802899527144151299810833802858809753719892490239782222290074816037776586657834' +
        '841586939662825734294051183140794537141608771803070715941051121170285190347786926570042246331102750604036185' +
        '540464179153763503857127117918822547579033069472418242684328083352174724579376695971173152319349449321466491' +
        '373527284227385153411689217559966957882267024615e-309', 2, -1024);

  t('1.79769313486231590772930519078902473361797697894230657273430081157732675805500963132708477322407536021120' +
        '113879871393357658789768814416622492847430639474124377767893424865485276302219601246094119453082952085005768' +
        '838150682342462881473913110540827237163350510684586298239947245938479716304835356329624224137216e+308', 2, 1024);

  // Test limit for exponent.
  t(1, 1, MAX_POWER);

  t(2, 2, 1);
  t('16', 2, 4);
  t('0.0625', 2, -4);

  // As negative exponents involve a division, the result depends on the
  // decimal places and rounding mode specified:

  Big.DP = 40;
  Big.RM = 0;

  t('0', '41', -25);
  t('0', '-26403', -25);
  t('-1.83965573171075e-25', '-28.5112', -17);
  t('1.3846500590693220280355384e-15', '72', -8);
  t('0', '388528.736', -15);
  t('3.934117957191277521704056558e-13', '9', -13);
  t('0', '65', -30);
  t('0', '-43284153', -10);
  t('0', '825797.7867', -9);
  t('1.45171e-35', '14.49674917', -30);
  t('4.11323023e-32', '713.2735', -11);
  t('6.75896391888332043299090622098e-11', '-2.8992', -22);
  t('0', '9006558087', -9);
  t('2.35898248759e-29', '9', -30);
  t('4.2316349570524877e-24', '-835', -8);
  t('2.306295e-33', '-18', -26);
  t('2.735111227791253388712174e-16', '6', -20);
  t('2.11e-38', '-5855.32565', -10);
  t('0', '-3338', -20);

  Big.DP = 101;
  Big.RM = 1;

  t('2.59086221967070203169073279093835370593438251373865163612424184820637293172653704e-21', '7280902.7', -3);
  t('0', '-864898946', -18);
  t('-6.92056804675353e-87', '-4243081.8', -13);
  t('4.535096358699077993843952445171547362594555572598969066238446195262298595680218449724146e-14', '28041.71', -3);
  t('3.935198147655009521015158343912785620124855179789168611080864740903996079598197380173314783859e-8', '-71', -4);
  t('0', '-22174.6', -24);
  t('-2.99258857055507737893205013175602880569082447633970771174973412126870110482831422782576004e-12', '-44.287279', -7);
  t('0', '470977.3', -28);
  t('0', '1491202647', -13);
  t('7.6416831024439568243705975297501568471970365586580909307933089678e-37', '-63.95', -20);
  t('0', '4669863', -27);
  t('0', '68895.202', -25);
  t('2.739979564368301888555652244200021058884694833454583774293368045917370205983074157e-20', '8174.2993', -5);
  t('0', '-84777.31264', -24);
  t('-1.61732012052302022569648421623255682672403613813784e-51', '-8072.642', -13);
  t('9.226701330968798029567410873712667474511623e-59', '86', -30);
  t('-4.52671289980544818356121416933990316474525113390656357838131753149833770190909867e-21', '-805.966', -7);
  t('0', '-62548432.8', -25);
  t('1.2208830071779439347812238188621035387222053043582168736013775635140091964690008930489382362e-10', '-90503', -2);

  Big.DP = 99;
  Big.RM = 2;

  t('3.50565137890907848896561225350273375702045873464e-52', '282', -21);
  t('2.5679471225603104166379068675724780241775210532444313569170923793768408333314758e-20', '91', -10);
  t('-1.41295214664272077547931481358044650743763505172248724988734056104337e-30', '-57', -17);
  t('-1.6987939248665576039846745813760545846750230030808816733060274510838e-32', '-47', -19);
  t('2.5752032499330351923455285237362946185406503583972342814435847681120726508860096355483248328e-8', '78.94', -4);
  t('0', '171036487', -28);
  t('-2.69509379734942915218278341741127616464435811759556667850711208302182540858969514716020661667e-7', '-3710446', -1);
  t('0', '186138.741', -19);
  t('4.37024265074487259941007405227545667043223030296145105953223847971330338431363825001208e-13', '-5.922', -16);
  t('0', '-68229265', -23);
  t('4.928268737732714614617566124770385834839673627880400464580256256e-35', '-522257', -6);
  t('-2.022506359274224265530332563554654257153128338531e-51', '-7935', -13);
  t('4.113745803364219006888865973815476523221392611155744131624798603545707151167823836246769e-12', '-79', -6);
  t('1.58e-97', '7449', -25);
  t('1.118728735197209316850322750834837614213911286885421936356799842846357177424981773587541512e-9', '19', -7);
  t('2.30221163139014605760922065192648652054327053388946752033272296649e-32', '-433', -12);
  t('-2.267272190443616852157926557261723579010324347431719319355102519288715860877837553741191e-12', '-7612', -3);
  t('-7.116521605575577249405567849234479247439447514e-54', '-804088', -9);
  t('8.903896183702542287639673e-75', '-294', -30);
  t('8.07793566946316088741610050849573099185363389551639556884765625e-28', '8', -30);
  t('0', '-81529053.21', -19);
  t('6.5536e-12', '-5', -16);
  t('0', '-393954461', -21);
  t('8.6647113997049045695e-80', '-80579504', -10);
  t('9.90263871916064254974009912780157486232613002968707056446243636671e-34', '-562.8', -12);
  t('4.3492544377486037018080360300067123809538178904353011549513518579352205e-29', '-53325', -6);
  t('-2.4321805935844144232493980416059793684e-61', '-323865', -11);
  t('7.85857243441531254691813393990245178596730427987853282250959743319065590613e-25', '-52.694', -14);
  t('2.0976497180691992906625338620920916459004443120221572748409028790029453e-29', '-62', -16);
  t('2.364680619496191078868743412738756777204213983827334426304480201936157926992330323938307469e-8', '-6503', -2);
  t('-1.6469853898171534943494115141107888422500959997099727812322359810844298906326507134302e-14', '-34', -9);
  t('-2.8509481595561976509829554676872915624841643712635341972335222140599199298237e-23', '-32285.1', -5);
  t('1.146039e-93', '2086', -28);
  t('1.4679476870451975270004793115264473958785611246906228067920825392511892301766856e-20', '21', -15);
  t('-2.7632000420131244245e-80', '-884.33', -27);
  t('0', '465056.3', -25);
  t('-3.385374643100272485246768762282984762e-63', '-8732826', -9);
  t('8.1099148118448025737743300061125240950246836242140801097075869941095902018e-26', '-24.771', -18);
  t('0', '41616', -24);
  t('-4.600396873004638534957365480807567e-66', '-693.02361', -23);
  t('4.743101317987169079986565102514233588322445597602857643390328860354941191426667037e-18', '-54', -10);
  t('0', '-28456394.82', -20);
  t('0', '65420941.8', -28);
  t('6.936158419792753387019531369763661408e-63', '8063848', -9);
  t('7.76868869438579094965029841442548135292087504293659500457724060495468797e-28', '8.0104161', -30);
  t('1.418903330951799073514333098017321859067165230705198534199808126932321545716946e-21', '8899161', -3);
  t('5.5856834219770636694175782782449695904056e-59', '-668794', -10);
  t('4.71680980075571e-85', '-186379', -16);
  t('8.28459140195479963018738579860475551841921130300932e-49', '-2719', -14);
  t('2.67077966735439243101042271765185051646201817465563634664049302592659362084276452403367853161e-7', '1935', -2);
  t('0', '2554338', -24);
  t('0.025540033620655455476185589070642885151916557690202314061872180456116463869710334413505216200293094', '6.257333', -2);
  t('1.950390958369440429127151141521415628594542650755102593292842679774e-33', '282908.755', -6);
  t('7.055018227999164719047034313928978751513528911694565147012740459916e-32', '19.86', -24);
  t('-1.7926074978022214012194558178183164876939431544374262895950448410755196050436473373785e-14', '-92', -7);
  t('4.17170159620302267465579950126198740043495589902397687214801e-40', '422', -15);
  t('9.094947017729282379150390625e-13', '32', -8);
  t('3.840702799092530418345764876794193332866602413557110156e-45', '-597', -16);
  t('2.86244662448576320862533497809376104296326075367736978e-46', '56.45', -26);
  t('-1.9579266376951475915762057927633263263525293205616726853270204e-38', '-32.2350348', -25);
  t('1.25868312332880899610888409696274260282720434321518772464e-43', '52', -25);
  t('0', '262233', -24);

  Big.DP = 0;
  Big.RM = 2;

  t('0', '-8645', -30);
  t('0', '7.24173993', -23);

  test.isException(function () {new Big(9).pow(undefined)}, ".pow(undefined)");
  test.isException(function () {new Big(9).pow(null)}, ".pow(null)");
  test.isException(function () {new Big(9).pow(NaN)}, ".pow(NaN)");
  test.isException(function () {new Big(9).pow('NaN')}, ".pow('NaN')");
  test.isException(function () {new Big(9).pow([])}, ".pow([])");
  test.isException(function () {new Big(9).pow({})}, ".pow({})");
  test.isException(function () {new Big(9).pow('')}, ".pow('')");
  test.isException(function () {Big(9).pow(' ')}, ".pow(' ')");
  test.isException(function () {new Big(9).pow('hello')}, ".pow('hello')");
  test.isException(function () {new Big(9).pow('\t')}, ".pow('\t')");
  test.isException(function () {new Big(9).pow(new Date)}, ".pow(new Date)");
  test.isException(function () {new Big(9).pow(new RegExp)}, ".pow(new RegExp)");
  test.isException(function () {new Big(9).pow(function () {})}, ".pow(function () {})");
  test.isException(function () {new Big(9).pow(-23.000001)}, ".pow(-23.000001)");
  test.isException(function () {new Big(9).pow(MAX_POWER + 0.02)}, ".pow(MAX_POWER + 0.02)");
  test.isException(function () {new Big(9).pow(MAX_POWER + 1)}, ".pow(MAX_POWER + 1)");
  test.isException(function () {new Big(9).pow(-MAX_POWER - 0.3)}, ".pow(-MAX_POWER - 0.3)");
  test.isException(function () {new Big(9).pow(-MAX_POWER - 1)}, ".pow(-MAX_POWER - 1)");
  test.isException(function () {new Big(9).pow(' 0.1')}, ".pow(' 0.1')");
  test.isException(function () {new Big(9).pow('7.5 ')}, ".pow('7.5 ')");
  test.isException(function () {Big(9).pow(' 0 ')}, ".pow(' 0 ')");
  test.isException(function () {new Big(9).pow('+1')}, ".pow('+1')");
  test.isException(function () {new Big(9).pow(' +1.2')}, ".pow(' +1.2')");
  test.isException(function () {new Big(9).pow('- 99')}, ".pow('- 99')");
  test.isException(function () {new Big(9).pow('9.9.9')}, ".pow('9.9.9')");
  test.isException(function () {new Big(9).pow('10.1.0')}, ".pow('10.1.0')");
  test.isException(function () {new Big(9).pow('234.')}, ".pow('234.')");
  test.isException(function () {new Big(9).pow('.5')}, ".pow('.5')");
  test.isException(function () {new Big(9).pow('0x16')}, ".pow('0x16')");
  test.isException(function () {new Big(9).pow('1e')}, ".pow('1e')");
  test.isException(function () {new Big(9).pow('8 e')}, ".pow('8 e')");
  test.isException(function () {new Big(9).pow('77-e')}, ".pow('77-e')");
  test.isException(function () {new Big(9).pow('123e.0')}, ".pow('123e.0')");
  test.isException(function () {new Big(9).pow('4e1.')}, ".pow('4e1.')");
  test.isException(function () {Big(9).pow(Infinity)}, ".pow(Infinity)");
  test.isException(function () {new Big(9).pow('-Infinity')}, ".pow('-Infinity')");

  // ROUND_UP

  Big.DP = 38;
  Big.RM = 3;

  t('1.38465005906932202803554e-15', '72', -8);
  t('3.9341179571912775217040566e-13', '9', -13);
  t('1.452e-35', '14.49674917', -30);
  t('4.113231e-32', '713.2735', -11);
  t('6.758963918883320432990906221e-11', '-2.8992', -22);
  t('2.358982488e-29', '9', -30);
  t('4.23163495705249e-24', '-835', -8);
  t('2.3063e-33', '-18', -26);
  t('2.7351112277912533887122e-16', '6', -20);
  t('3e-38', '-5855.32565', -10);

  Big.DP = 99;

  t('2.590862219670702031690732790938353705934382513738651636124241848206372931726538e-21', '7280902.7', -3);
  t('1e-99', '-864898946', -18);
  t('-6.920568046754e-87', '-4243081.8', -13);
  t('4.5350963586990779938439524451715473625945555725989690662384461952622985956802184497242e-14', '28041.71', -3);
  t('3.9351981476550095210151583439127856201248551797891686110808647409039960795981973801733147839e-8', '-71', -4);
  t('1e-99', '-22174.6', -24);
  t('-2.992588570555077378932050131756028805690824476339707711749734121268701104828314227825761e-12', '-44.287279', -7);
  t('1e-99', '470977.3', -28);
  t('1e-99', '1491202647', -13);
  t('7.64168310244395682437059752975015684719703655865809093079330897e-37', '-63.95', -20);
  t('2.7399795643683018885556522442000210588846948334545837742933680459173702059830742e-20', '8174.2993', -5);
  t('-1.617320120523020225696484216232556826724036138138e-51', '-8072.642', -13);
  t('9.2267013309687980295674108737126674745117e-59', '86', -30);
  t('-4.526712899805448183561214169339903164745251133906563578381317531498337701909099e-21', '-805.966', -7);
  t('-1e-99', '-62548432.8', -25);
  t('1.22088300717794393478122381886210353872220530435821687360137756351400919646900089304893824e-10', '-90503', -2);

/*
 * Notes:
 *
 *   n to the power of 1 is n
 *   Anything to the power of 0 is 1
 *   Math.pow(2, null) = 1                  // NaN for Big
 *   Math.pow(2, undefined) = NaN
 *   Math.pow(2, NaN) = NaN
 *   Math.pow(2, 'rferf') = NaN
 *   Math.pow(2, []) = 1                    // NaN for Big
 *   Math.pow(2, {}) = NaN                  // NaN for Big
 *   Math.pow(2, 1e4) = Infinity
 *   Math.pow(2, -1e4) = 0
 *   Math.pow(2, 1e-16) = 1
 *   Math.pow(2, -1e-17) = 1
 *   A negative number to a non-integer power is NaN
 *   0 to negative power is Infinity
 *
 *   --------------------------------------------------------------------------------
 *
 *   http://es5.github.com/#x15.8.2.13
 *   15.8.2.13 pow (x, y)
 *   Returns an implementation-dependent approximation to the result of raising x to the power y.
 *
 *   If y is NaN, the result is NaN.
 *   If y is +0, the result is 1, even if x is NaN.
 *   If y is -0, the result is 1, even if x is NaN.
 *   If x is NaN and y is nonzero, the result is NaN.
 *   If abs(x)>1 and y is +8, the result is +8.
 *   If abs(x)>1 and y is -8, the result is +0.
 *   If abs(x)==1 and y is +8, the result is NaN.
 *   If abs(x)==1 and y is -8, the result is NaN.
 *   If abs(x)<1 and y is +8, the result is +0.
 *   If abs(x)<1 and y is -8, the result is +8.
 *   If x is +8 and y>0, the result is +8.
 *   If x is +8 and y<0, the result is +0.
 *   If x is -8 and y>0 and y is an odd integer, the result is -8.
 *   If x is -8 and y>0 and y is not an odd integer, the result is +8.
 *   If x is -8 and y<0 and y is an odd integer, the result is -0.
 *   If x is -8 and y<0 and y is not an odd integer, the result is +0.
 *   If x is +0 and y>0, the result is +0.
 *   If x is +0 and y<0, the result is +8.
 *   If x is -0 and y>0 and y is an odd integer, the result is -0.
 *   If x is -0 and y>0 and y is not an odd integer, the result is +0.
 *   If x is -0 and y<0 and y is an odd integer, the result is -8.
 *   If x is -0 and y<0 and y is not an odd integer, the result is +8.
 *   If x<0 and x is finite and y is finite and y is not an integer, the result is NaN.
*/
});
