/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.mail;

import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.db.Criteria;

public abstract class Email {
    public static final String SENDER_EMAIL = "sender.email";
    public static final String SENDER_NAME = "sender.name";
    public static final String RECEIVER_EMAIL = "receiver.email";
    public static final String RECEIVER_NAME = "receiver.name";
    public static final String EMAIL_SUBJECT = "email.subject";
    public static final String EMAIL_BODY = "email.body";
    public static final String CONTENT_TYPE = "content.type";
    public static final String MAIL_SERVER = "mail.server";
    public static final String MAIL_HOST = "mail.host";
    public static final String MAIL_SMTP_FROM = "mail.smtp.from";
    public static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String SMTP = "SMTP";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String ATTACHMENTS = "attachments";
    public static final String FILE_SERVER = "file.server";
    public static final String KOI8_R = "koi8-r";
    public static final String ISO_8859_1 = "iso-8859-1";
    public static final String US_ASCII = "us-ascii";
    protected MimeMessage message;
    protected String charset = null;
    private Vector toList;
    private Vector ccList;
    private Vector bccList;
    private Vector replyList;

    public void setCharset(String charset) {
        this.charset = charset;
    }

    private Session getMailSession() {
        Properties properties = System.getProperties();
        ((Hashtable)properties).put(MAIL_TRANSPORT_PROTOCOL, SMTP);
        ((Hashtable)properties).put(MAIL_HOST, TurbineResources.getString(MAIL_SERVER));
        String mailSMTPFrom = TurbineResources.getString(MAIL_SMTP_FROM);
        if (mailSMTPFrom != null && !mailSMTPFrom.equals("")) {
            ((Hashtable)properties).put(MAIL_SMTP_FROM, mailSMTPFrom);
        }
        return Session.getDefaultInstance(properties, null);
    }

    protected void initialize(Criteria criteria) throws MessagingException {
        this.init();
        this.initCriteria(criteria);
    }

    protected void init() throws MessagingException {
        this.message = new MimeMessage(this.getMailSession());
        this.toList = new Vector();
        this.ccList = new Vector();
        this.bccList = new Vector();
        this.replyList = new Vector();
        this.setSentDate(new Date());
    }

    protected void initCriteria(Criteria criteria) throws MessagingException {
        if (criteria.containsKey(SENDER_EMAIL) && criteria.containsKey(SENDER_NAME)) {
            this.setFrom(criteria.getString(SENDER_EMAIL), criteria.getString(SENDER_NAME));
        }
        if (criteria.containsKey(RECEIVER_EMAIL) && criteria.containsKey(RECEIVER_NAME)) {
            this.addTo(criteria.getString(RECEIVER_EMAIL), criteria.getString(RECEIVER_NAME));
        }
        if (criteria.containsKey(EMAIL_SUBJECT)) {
            this.setSubject(criteria.getString(EMAIL_SUBJECT));
        } else {
            this.setSubject("no subject available");
        }
    }

    public Email setFrom(String email, String name) throws MessagingException {
        try {
            if (name == null || name.trim().equals("")) {
                name = email;
            }
            this.message.setFrom(new InternetAddress(email, name));
        }
        catch (Exception e) {
            throw new MessagingException("cannot set from", e);
        }
        return this;
    }

    public Email addTo(String email, String name) throws MessagingException {
        try {
            if (name == null || name.trim().equals("")) {
                name = email;
            }
            this.toList.addElement(new InternetAddress(email, name));
        }
        catch (Exception e) {
            throw new MessagingException("cannot add to", e);
        }
        return this;
    }

    public Email addCc(String email, String name) throws MessagingException {
        try {
            if (name == null || name.trim().equals("")) {
                name = email;
            }
            this.ccList.addElement(new InternetAddress(email, name));
        }
        catch (Exception e) {
            throw new MessagingException("cannot add cc", e);
        }
        return this;
    }

    public Email addBcc(String email, String name) throws MessagingException {
        try {
            if (name == null || name.trim().equals("")) {
                name = email;
            }
            this.bccList.addElement(new InternetAddress(email, name));
        }
        catch (Exception e) {
            throw new MessagingException("cannot add bcc", e);
        }
        return this;
    }

    public Email addReplyTo(String email, String name) throws MessagingException {
        try {
            if (name == null || name.trim().equals("")) {
                name = email;
            }
            this.replyList.addElement(new InternetAddress(email, name));
        }
        catch (Exception e) {
            throw new MessagingException("cannot add replyTo", e);
        }
        return this;
    }

    public Email setSubject(String subject) throws MessagingException {
        if (this.charset != null) {
            this.message.setSubject(subject, this.charset);
        } else {
            this.message.setSubject(subject);
        }
        return this;
    }

    public Email setSentDate(Date date) throws MessagingException {
        this.message.setSentDate(date);
        return this;
    }

    public abstract Email setMsg(String var1) throws MessagingException;

    public void send() throws MessagingException {
        InternetAddress[] foo = new InternetAddress[]{};
        this.message.setRecipients(Message.RecipientType.TO, this.toInternetAddressArray(this.toList));
        this.message.setRecipients(Message.RecipientType.CC, this.toInternetAddressArray(this.ccList));
        this.message.setRecipients(Message.RecipientType.BCC, this.toInternetAddressArray(this.bccList));
        this.message.setReplyTo(this.toInternetAddressArray(this.replyList));
        Transport.send(this.message);
    }

    private InternetAddress[] toInternetAddressArray(Vector v) {
        int size = v.size();
        InternetAddress[] ia = new InternetAddress[size];
        int i = 0;
        while (i < size) {
            ia[i] = (InternetAddress)v.elementAt(i);
            ++i;
        }
        return ia;
    }
}

