/* OpenCP Module Player
 * copyright (c) 1994-'10 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 * copyright (c) 2004-'22 Stian Skjelstad <stian.skjelstad@gmail.com>
 *
 * VGA fonts for graphic mode screen output
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -ss040613   Stian Skjelstad <stian@nixia.no>
 *    -patched in the analyser characters, so wo don't need to track fonts all
 *     the time.
 */

#include "config.h"
#include "types.h"
#include "pfonts.h"

unsigned char plFont88[256][8]=
{
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/* 00 */
  {0x7E,0x81,0xA5,0x81,0xBD,0x99,0x81,0x7E},
  {0x7E,0xFF,0xDB,0xFF,0xC3,0xE7,0xFF,0x7E},
  {0x6C,0xFE,0xFE,0xFE,0x7C,0x38,0x10,0x00},
  {0x10,0x38,0x7C,0xFE,0x7C,0x38,0x10,0x00},
  {0x38,0x7C,0x38,0xFE,0xFE,0x7C,0x38,0x7C},
  {0x10,0x10,0x38,0x7C,0xFE,0x7C,0x38,0x7C},
  {0x00,0x00,0x18,0x3C,0x3C,0x18,0x00,0x00},
  {0xFF,0xFF,0xE7,0xC3,0xC3,0xE7,0xFF,0xFF},
  {0x00,0x3C,0x66,0x42,0x42,0x66,0x3C,0x00},
  {0xFF,0xC3,0x99,0xBD,0xBD,0x99,0xC3,0xFF},
  {0x0F,0x07,0x0F,0x7D,0xCC,0xCC,0xCC,0x78},
  {0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18},
  {0x3F,0x33,0x3F,0x30,0x30,0x70,0xF0,0xE0},
  {0x7F,0x63,0x7F,0x63,0x63,0x67,0xE6,0xC0},
  {0x99,0x5A,0x3C,0xE7,0xE7,0x3C,0x5A,0x99},
  {0x80,0xE0,0xF8,0xFE,0xF8,0xE0,0x80,0x00},/* 10 */
  {0x02,0x0E,0x3E,0xFE,0x3E,0x0E,0x02,0x00},
  {0x18,0x3C,0x7E,0x18,0x18,0x7E,0x3C,0x18},
  {0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x00},
  {0x7F,0xDB,0xDB,0x7B,0x1B,0x1B,0x1B,0x00},
  {0x3C,0x62,0x38,0x6C,0x38,0x8C,0x78,0x00},
  {0x00,0x00,0x00,0x00,0x7E,0x7E,0x7E,0x00},
  {0x18,0x3C,0x7E,0x18,0x7E,0x3C,0x18,0xFF},
  {0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x00},
  {0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00},
  {0x00,0x18,0x0C,0xFE,0x0C,0x18,0x00,0x00},
  {0x00,0x30,0x60,0xFE,0x60,0x30,0x00,0x00},
  {0x00,0x00,0xC0,0xC0,0xC0,0xFE,0x00,0x00},
  {0x00,0x24,0x66,0xFF,0x66,0x24,0x00,0x00},
  {0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x00,0x00},
  {0x00,0xFF,0xFF,0x7E,0x3C,0x18,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/* 20 */
  {0x30,0x78,0x78,0x30,0x30,0x00,0x30,0x00},
  {0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00},
  {0x6C,0x6C,0xFE,0x6C,0xFE,0x6C,0x6C,0x00},
  {0x30,0x7C,0xC0,0x78,0x0C,0xF8,0x30,0x00},
  {0x00,0xC6,0xCC,0x18,0x30,0x66,0xC6,0x00},
  {0x38,0x6C,0x38,0x76,0xDC,0xCC,0x76,0x00},
  {0x60,0x60,0xC0,0x00,0x00,0x00,0x00,0x00},
  {0x18,0x30,0x60,0x60,0x60,0x30,0x18,0x00},
  {0x60,0x30,0x18,0x18,0x18,0x30,0x60,0x00},
  {0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00},
  {0x00,0x30,0x30,0xFC,0x30,0x30,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x60},
  {0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00},
  {0x06,0x0C,0x18,0x30,0x60,0xC0,0x80,0x00},
  {0x7C,0xC6,0xCE,0xDE,0xF6,0xE6,0x7C,0x00},/* 30 */
  {0x30,0x70,0x30,0x30,0x30,0x30,0xFC,0x00},
  {0x78,0xCC,0x0C,0x38,0x60,0xCC,0xFC,0x00},
  {0x78,0xCC,0x0C,0x38,0x0C,0xCC,0x78,0x00},
  {0x1C,0x3C,0x6C,0xCC,0xFE,0x0C,0x1E,0x00},
  {0xFC,0xC0,0xF8,0x0C,0x0C,0xCC,0x78,0x00},
  {0x38,0x60,0xC0,0xF8,0xCC,0xCC,0x78,0x00},
  {0xFC,0xCC,0x0C,0x18,0x30,0x30,0x30,0x00},
  {0x78,0xCC,0xCC,0x78,0xCC,0xCC,0x78,0x00},
  {0x78,0xCC,0xCC,0x7C,0x0C,0x18,0x70,0x00},
  {0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x00},
  {0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x60},
  {0x18,0x30,0x60,0xC0,0x60,0x30,0x18,0x00},
  {0x00,0x00,0xFC,0x00,0x00,0xFC,0x00,0x00},
  {0x60,0x30,0x18,0x0C,0x18,0x30,0x60,0x00},
  {0x78,0xCC,0x0C,0x18,0x30,0x00,0x30,0x00},
  {0x7C,0xC6,0xDE,0xDE,0xDE,0xC0,0x78,0x00},/* 40 */
  {0x30,0x78,0xCC,0xCC,0xFC,0xCC,0xCC,0x00},
  {0xFC,0x66,0x66,0x7C,0x66,0x66,0xFC,0x00},
  {0x3C,0x66,0xC0,0xC0,0xC0,0x66,0x3C,0x00},
  {0xF8,0x6C,0x66,0x66,0x66,0x6C,0xF8,0x00},
  {0xFE,0x62,0x68,0x78,0x68,0x62,0xFE,0x00},
  {0xFE,0x62,0x68,0x78,0x68,0x60,0xF0,0x00},
  {0x3C,0x66,0xC0,0xC0,0xCE,0x66,0x3E,0x00},
  {0xCC,0xCC,0xCC,0xFC,0xCC,0xCC,0xCC,0x00},
  {0x78,0x30,0x30,0x30,0x30,0x30,0x78,0x00},
  {0x1E,0x0C,0x0C,0x0C,0xCC,0xCC,0x78,0x00},
  {0xE6,0x66,0x6C,0x78,0x6C,0x66,0xE6,0x00},
  {0xF0,0x60,0x60,0x60,0x62,0x66,0xFE,0x00},
  {0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0x00},
  {0xC6,0xE6,0xF6,0xDE,0xCE,0xC6,0xC6,0x00},
  {0x38,0x6C,0xC6,0xC6,0xC6,0x6C,0x38,0x00},
  {0xFC,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00},/* 50 */
  {0x78,0xCC,0xCC,0xCC,0xDC,0x78,0x1C,0x00},
  {0xFC,0x66,0x66,0x7C,0x6C,0x66,0xE6,0x00},
  {0x78,0xCC,0xE0,0x70,0x1C,0xCC,0x78,0x00},
  {0xFC,0xB4,0x30,0x30,0x30,0x30,0x78,0x00},
  {0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xFC,0x00},
  {0xCC,0xCC,0xCC,0xCC,0xCC,0x78,0x30,0x00},
  {0xC6,0xC6,0xC6,0xD6,0xFE,0xEE,0xC6,0x00},
  {0xC6,0xC6,0x6C,0x38,0x38,0x6C,0xC6,0x00},
  {0xCC,0xCC,0xCC,0x78,0x30,0x30,0x78,0x00},
  {0xFE,0xC6,0x8C,0x18,0x32,0x66,0xFE,0x00},
  {0x78,0x60,0x60,0x60,0x60,0x60,0x78,0x00},
  {0xC0,0x60,0x30,0x18,0x0C,0x06,0x02,0x00},
  {0x78,0x18,0x18,0x18,0x18,0x18,0x78,0x00},
  {0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF},
  {0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00},/* 60 */
  {0x00,0x00,0x78,0x0C,0x7C,0xCC,0x76,0x00},
  {0xE0,0x60,0x60,0x7C,0x66,0x66,0xDC,0x00},
  {0x00,0x00,0x78,0xCC,0xC0,0xCC,0x78,0x00},
  {0x1C,0x0C,0x0C,0x7C,0xCC,0xCC,0x76,0x00},
  {0x00,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00},
  {0x38,0x6C,0x60,0xF0,0x60,0x60,0xF0,0x00},
  {0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0xF8},
  {0xE0,0x60,0x6C,0x76,0x66,0x66,0xE6,0x00},
  {0x30,0x00,0x70,0x30,0x30,0x30,0x78,0x00},
  {0x0C,0x00,0x0C,0x0C,0x0C,0xCC,0xCC,0x78},
  {0xE0,0x60,0x66,0x6C,0x78,0x6C,0xE6,0x00},
  {0x70,0x30,0x30,0x30,0x30,0x30,0x78,0x00},
  {0x00,0x00,0xCC,0xFE,0xFE,0xD6,0xC6,0x00},
  {0x00,0x00,0xF8,0xCC,0xCC,0xCC,0xCC,0x00},
  {0x00,0x00,0x78,0xCC,0xCC,0xCC,0x78,0x00},
  {0x00,0x00,0xDC,0x66,0x66,0x7C,0x60,0xF0},/* 70 */
  {0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0x1E},
  {0x00,0x00,0xDC,0x76,0x66,0x60,0xF0,0x00},
  {0x00,0x00,0x7C,0xC0,0x78,0x0C,0xF8,0x00},
  {0x10,0x30,0x7C,0x30,0x30,0x34,0x18,0x00},
  {0x00,0x00,0xCC,0xCC,0xCC,0xCC,0x76,0x00},
  {0x00,0x00,0xCC,0xCC,0xCC,0x78,0x30,0x00},
  {0x00,0x00,0xC6,0xD6,0xFE,0xFE,0x6C,0x00},
  {0x00,0x00,0xC6,0x6C,0x38,0x6C,0xC6,0x00},
  {0x00,0x00,0xCC,0xCC,0xCC,0x7C,0x0C,0xF8},
  {0x00,0x00,0xFC,0x98,0x30,0x64,0xFC,0x00},
  {0x1C,0x30,0x30,0xE0,0x30,0x30,0x1C,0x00},
  {0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00},
  {0xE0,0x30,0x30,0x1C,0x30,0x30,0xE0,0x00},
  {0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0x00},
  {0x78,0xCC,0xC0,0xCC,0x78,0x18,0x0C,0x78},/* 80 */
  {0x00,0xCC,0x00,0xCC,0xCC,0xCC,0x7E,0x00},
  {0x1C,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00},
  {0x7E,0xC3,0x3C,0x06,0x3E,0x66,0x3F,0x00},
  {0xCC,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00},
  {0xE0,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00},
  {0x30,0x30,0x78,0x0C,0x7C,0xCC,0x7E,0x00},
  {0x00,0x00,0x78,0xC0,0xC0,0x78,0x0C,0x38},
  {0x7E,0xC3,0x3C,0x66,0x7E,0x60,0x3C,0x00},
  {0xCC,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00},
  {0xE0,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00},
  {0xCC,0x00,0x70,0x30,0x30,0x30,0x78,0x00},
  {0x7C,0xC6,0x38,0x18,0x18,0x18,0x3C,0x00},
  {0xE0,0x00,0x70,0x30,0x30,0x30,0x78,0x00},
  {0xC6,0x38,0x6C,0xC6,0xFE,0xC6,0xC6,0x00},
  {0x30,0x30,0x00,0x78,0xCC,0xFC,0xCC,0x00},
  {0x1C,0x00,0xFC,0x60,0x78,0x60,0xFC,0x00},/* 90 */
  {0x00,0x00,0x7F,0x0C,0x7F,0xCC,0x7F,0x00},
  {0x3E,0x6C,0xCC,0xFE,0xCC,0xCC,0xCE,0x00},
  {0x78,0xCC,0x00,0x78,0xCC,0xCC,0x78,0x00},
  {0x00,0xCC,0x00,0x78,0xCC,0xCC,0x78,0x00},
  {0x00,0xE0,0x00,0x78,0xCC,0xCC,0x78,0x00},
  {0x78,0xCC,0x00,0xCC,0xCC,0xCC,0x7E,0x00},
  {0x00,0xE0,0x00,0xCC,0xCC,0xCC,0x7E,0x00},
  {0x00,0xCC,0x00,0xCC,0xCC,0x7C,0x0C,0xF8},
  {0xC3,0x18,0x3C,0x66,0x66,0x3C,0x18,0x00},
  {0xCC,0x00,0xCC,0xCC,0xCC,0xCC,0x78,0x00},
  {0x18,0x18,0x7E,0xC0,0x7E,0x18,0x18,0x00},
  {0x38,0x6C,0x64,0xF0,0x60,0xE6,0xFC,0x00},
  {0xCC,0xCC,0x78,0xFC,0x30,0xFC,0x30,0x00},
  {0xF8,0xCC,0xCC,0xFA,0xC6,0xCF,0xC6,0xC7},
  {0x0E,0x1B,0x18,0x3C,0x18,0x18,0xD8,0x70},
  {0x1C,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00},/* A0 */
  {0x38,0x00,0x70,0x30,0x30,0x30,0x78,0x00},
  {0x00,0x1C,0x00,0x78,0xCC,0xCC,0x78,0x00},
  {0x00,0x1C,0x00,0xCC,0xCC,0xCC,0x7E,0x00},
  {0x00,0xF8,0x00,0xF8,0xCC,0xCC,0xCC,0x00},
  {0xFC,0x00,0xCC,0xEC,0xFC,0xDC,0xCC,0x00},
  {0x3C,0x6C,0x6C,0x3E,0x00,0x7E,0x00,0x00},
  {0x38,0x6C,0x6C,0x38,0x00,0x7C,0x00,0x00},
  {0x30,0x00,0x30,0x60,0xC0,0xCC,0x78,0x00},
  {0x00,0x00,0x00,0xFC,0xC0,0xC0,0x00,0x00},
  {0x00,0x00,0x00,0xFC,0x0C,0x0C,0x00,0x00},
  {0xC3,0xC6,0xCC,0xDE,0x33,0x66,0xCC,0x0F},
  {0xC3,0xC6,0xCC,0xDB,0x37,0x6F,0xCF,0x03},
  {0x30,0x00,0x30,0x30,0x78,0x78,0x30,0x00},
  {0x00,0x33,0x66,0xCC,0x66,0x33,0x00,0x00},
  {0x00,0xCC,0x66,0x33,0x66,0xCC,0x00,0x00},
  {0x22,0x88,0x22,0x88,0x22,0x88,0x22,0x88},/* B0 */
  {0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA},
  {0xDB,0x77,0xDB,0xEE,0xDB,0x77,0xDB,0xEE},
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0xF8,0x18,0x18,0x18},
  /*{0x18,0x18,0xF8,0x18,0xF8,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x36,0x36,0x36,0x36,0xF6,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe},
  /*{0x00,0x00,0x00,0x00,0xFE,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe},
  /*{0x00,0x00,0xF8,0x18,0xF8,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe},
  {0x36,0x36,0xF6,0x06,0xF6,0x36,0x36,0x36},
  {0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},
  {0x00,0x00,0xFE,0x06,0xF6,0x36,0x36,0x36},
  {0x36,0x36,0xF6,0x06,0xFE,0x00,0x00,0x00},
  /*{0x36,0x36,0x36,0x36,0xFE,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe},
  /*{0x18,0x18,0xF8,0x18,0xF8,0x00,0x00,0x00},*/{0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe},
  {0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x1F,0x00,0x00,0x00},/* C0 */
  {0x18,0x18,0x18,0x18,0xFF,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0xFF,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x1F,0x18,0x18,0x18},
  {0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00},
  {0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18},
  /*{0x18,0x18,0x1F,0x18,0x1F,0x18,0x18,0x18},*/{0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36},*/{0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  {0x36,0x36,0x37,0x30,0x3F,0x00,0x00,0x00},
  {0x00,0x00,0x3F,0x30,0x37,0x36,0x36,0x36},
  {0x36,0x36,0xF7,0x00,0xFF,0x00,0x00,0x00},
  {0x00,0x00,0xFF,0x00,0xF7,0x36,0x36,0x36},
  {0x36,0x36,0x37,0x30,0x37,0x36,0x36,0x36},
  {0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00},
  {0x36,0x36,0xF7,0x00,0xF7,0x36,0x36,0x36},
  /*{0x18,0x18,0xFF,0x00,0xFF,0x00,0x00,0x00},*/{0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0xFF,0x00,0x00,0x00},*/{0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/* D0 */
  /*{0x00,0x00,0xFF,0x00,0xFF,0x18,0x18,0x18},*/{0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x00,0x00,0x00,0x00,0xFF,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00},
  /*{0x36,0x36,0x36,0x36,0x3F,0x00,0x00,0x00},*/{0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00},
  /*{0x18,0x18,0x1F,0x18,0x1F,0x00,0x00,0x00},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00},
  /*{0x00,0x00,0x1F,0x18,0x1F,0x18,0x18,0x18},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00},
  /*{0x00,0x00,0x00,0x00,0x3F,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00},
  /*{0x36,0x36,0x36,0x36,0xFF,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  {0x18,0x18,0xFF,0x18,0xFF,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x1F,0x18,0x18,0x18},
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
  {0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF},
  {0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0},
  {0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F},
  {0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x76,0xDC,0xC8,0xDC,0x76,0x00},/* E0 */
  {0x78,0xCC,0xCC,0xD8,0xC6,0xC6,0xCC,0x00},
  {0xFC,0xCC,0xC0,0xC0,0xC0,0xC0,0xC0,0x00},
  {0x00,0xFE,0x6C,0x6C,0x6C,0x6C,0x6C,0x00},
  {0xFC,0xCC,0x60,0x30,0x60,0xCC,0xFC,0x00},
  {0x00,0x00,0x7E,0xD8,0xD8,0xD8,0x70,0x00},
  {0x00,0x66,0x66,0x66,0x66,0x7C,0x60,0xC0},
  {0x00,0x76,0xDC,0x18,0x18,0x18,0x18,0x00},
  {0xFC,0x30,0x78,0xCC,0xCC,0x78,0x30,0xFC},
  {0x38,0x6C,0xC6,0xFE,0xC6,0x6C,0x38,0x00},
  {0x38,0x6C,0xC6,0xC6,0x6C,0x6C,0xEE,0x00},
  {0x1C,0x30,0x18,0x7C,0xCC,0xCC,0x78,0x00},
  {0x00,0x00,0x7E,0xDB,0xDB,0x7E,0x00,0x00},
  {0x06,0x0C,0x7E,0xDB,0xDB,0x7E,0x60,0xC0},
  {0x38,0x60,0xC0,0xF8,0xC0,0x60,0x38,0x00},
  {0x78,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x00},
  {0x00,0xFC,0x00,0xFC,0x00,0xFC,0x00,0x00},/* F0 */
  {0x30,0x30,0xFC,0x30,0x30,0x00,0xFC,0x00},
  {0x60,0x30,0x18,0x30,0x60,0x00,0xFC,0x00},
  {0x18,0x30,0x60,0x30,0x18,0x00,0xFC,0x00},
  {0x0E,0x1B,0x1B,0x18,0x18,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x18,0xD8,0xD8,0x70},
  {0x30,0x30,0x00,0xFC,0x00,0x30,0x30,0x00},
  {0x00,0x76,0xDC,0x00,0x76,0xDC,0x00,0x00},
  {0x38,0x6C,0x6C,0x38,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00},
  {0x0F,0x0C,0x0C,0x0C,0xEC,0x6C,0x3C,0x1C},
  {0x78,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00},
  {0x70,0x18,0x30,0x60,0x78,0x00,0x00,0x00},
  {0x00,0x00,0x3C,0x3C,0x3C,0x3C,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

unsigned char plFont816[256][16]=
{
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0000
  {0x00,0x00,0x7E,0x81,0xA5,0x81,0x81,0xBD,0x99,0x81,0x81,0x7E,0x00,0x00,0x00,0x00}, // 263a
  {0x00,0x00,0x7E,0xFF,0xDB,0xFF,0xFF,0xC3,0xE7,0xFF,0xFF,0x7E,0x00,0x00,0x00,0x00}, // 263b
  {0x00,0x00,0x00,0x00,0x6C,0xFE,0xFE,0xFE,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00,0x00}, // 2665
  {0x00,0x00,0x00,0x00,0x10,0x38,0x7C,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00,0x00,0x00}, // 2666
  {0x00,0x00,0x00,0x18,0x3C,0x3C,0xE7,0xE7,0xE7,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 2663
  {0x00,0x00,0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x7E,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 2660
  {0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x3C,0x3C,0x18,0x00,0x00,0x00,0x00,0x00,0x00}, // 2022
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0xC3,0xC3,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}, // 25d8
  {0x00,0x00,0x00,0x00,0x00,0x3C,0x66,0x42,0x42,0x66,0x3C,0x00,0x00,0x00,0x00,0x00}, // 25cb
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0x99,0xBD,0xBD,0x99,0xC3,0xFF,0xFF,0xFF,0xFF,0xFF}, // 25d9
  {0x00,0x00,0x1E,0x0E,0x1A,0x32,0x78,0xCC,0xCC,0xCC,0xCC,0x78,0x00,0x00,0x00,0x00}, // 2642
  {0x00,0x00,0x3C,0x66,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18,0x18,0x00,0x00,0x00,0x00}, // 2640
  {0x00,0x00,0x3F,0x33,0x3F,0x30,0x30,0x30,0x30,0x70,0xF0,0xE0,0x00,0x00,0x00,0x00}, // 266a
  {0x00,0x00,0x7F,0x63,0x7F,0x63,0x63,0x63,0x63,0x67,0xE7,0xE6,0xC0,0x00,0x00,0x00}, // 266b
  {0x00,0x00,0x00,0x18,0x18,0xDB,0x3C,0xE7,0x3C,0xDB,0x18,0x18,0x00,0x00,0x00,0x00}, // 263c

  {0x00,0x80,0xC0,0xE0,0xF0,0xF8,0xFE,0xF8,0xF0,0xE0,0xC0,0x80,0x00,0x00,0x00,0x00}, // 25ba
  {0x00,0x02,0x06,0x0E,0x1E,0x3E,0xFE,0x3E,0x1E,0x0E,0x06,0x02,0x00,0x00,0x00,0x00}, // 25c4
  {0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00,0x00,0x00,0x00}, // 2195
  {0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x66,0x00,0x00,0x00,0x00}, // 203c
  {0x00,0x00,0x7F,0xDB,0xDB,0xDB,0x7B,0x1B,0x1B,0x1B,0x1B,0x1B,0x00,0x00,0x00,0x00}, // 00b6
  {0x00,0x7C,0xC6,0x60,0x38,0x6C,0xC6,0xC6,0x6C,0x38,0x0C,0xC6,0x7C,0x00,0x00,0x00}, // 00a7
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0xFE,0xFE,0x00,0x00,0x00,0x00}, // 25ac
  {0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x7E,0x3C,0x18,0x7E,0x00,0x00,0x00,0x00}, // 21a8
  {0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00}, // 2191
  {0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00,0x00,0x00}, // 2193
  {0x00,0x00,0x00,0x00,0x00,0x18,0x0C,0xFE,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00}, // 2192
  {0x00,0x00,0x00,0x00,0x00,0x30,0x60,0xFE,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00}, // 2190
  {0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0xC0,0xFE,0x00,0x00,0x00,0x00,0x00,0x00}, // 221f
  {0x00,0x00,0x00,0x00,0x00,0x28,0x6C,0xFE,0x6C,0x28,0x00,0x00,0x00,0x00,0x00,0x00}, // 2194
  {0x00,0x00,0x00,0x00,0x10,0x38,0x38,0x7C,0x7C,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00}, // 25b2
  {0x00,0x00,0x00,0x00,0xFE,0xFE,0x7C,0x7C,0x38,0x38,0x10,0x00,0x00,0x00,0x00,0x00}, // 25bc

  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0020
  {0x00,0x00,0x18,0x3C,0x3C,0x3C,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00}, // 0021
  {0x00,0x66,0x66,0x66,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0022
  {0x00,0x00,0x00,0x6C,0x6C,0xFE,0x6C,0x6C,0x6C,0xFE,0x6C,0x6C,0x00,0x00,0x00,0x00}, // 0023
  {0x18,0x18,0x7C,0xC6,0xC2,0xC0,0x7C,0x06,0x06,0x86,0xC6,0x7C,0x18,0x18,0x00,0x00}, // 0024
  {0x00,0x00,0x00,0x00,0xC2,0xC6,0x0C,0x18,0x30,0x60,0xC6,0x86,0x00,0x00,0x00,0x00}, // 0025
  {0x00,0x00,0x38,0x6C,0x6C,0x38,0x76,0xDC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 0026
  {0x00,0x30,0x30,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0027
  {0x00,0x00,0x0C,0x18,0x30,0x30,0x30,0x30,0x30,0x30,0x18,0x0C,0x00,0x00,0x00,0x00}, // 0028
  {0x00,0x00,0x30,0x18,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x18,0x30,0x00,0x00,0x00,0x00}, // 0029
  {0x00,0x00,0x00,0x00,0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00,0x00,0x00,0x00,0x00}, // 002a
  {0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00}, // 002b
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x30,0x00,0x00,0x00}, // 002c
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 002d
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00}, // 002e
  {0x00,0x00,0x00,0x00,0x02,0x06,0x0C,0x18,0x30,0x60,0xC0,0x80,0x00,0x00,0x00,0x00}, // 002f

  {0x00,0x00,0x7C,0xC6,0xC6,0xCE,0xDE,0xF6,0xE6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0030
  {0x00,0x00,0x18,0x38,0x78,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00,0x00,0x00}, // 0031
  {0x00,0x00,0x7C,0xC6,0x06,0x0C,0x18,0x30,0x60,0xC0,0xC6,0xFE,0x00,0x00,0x00,0x00}, // 0032
  {0x00,0x00,0x7C,0xC6,0x06,0x06,0x3C,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0033
  {0x00,0x00,0x0C,0x1C,0x3C,0x6C,0xCC,0xFE,0x0C,0x0C,0x0C,0x1E,0x00,0x00,0x00,0x00}, // 0034
  {0x00,0x00,0xFE,0xC0,0xC0,0xC0,0xFC,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0035
  {0x00,0x00,0x38,0x60,0xC0,0xC0,0xFC,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0036
  {0x00,0x00,0xFE,0xC6,0x06,0x06,0x0C,0x18,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00}, // 0037
  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x7C,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0038
  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x7E,0x06,0x06,0x06,0x0C,0x78,0x00,0x00,0x00,0x00}, // 0039
  {0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00}, // 003a
  {0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x30,0x00,0x00,0x00,0x00}, // 003b
  {0x00,0x00,0x00,0x06,0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x06,0x00,0x00,0x00,0x00}, // 003c
  {0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 003d
  {0x00,0x00,0x00,0x60,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x60,0x00,0x00,0x00,0x00}, // 003e
  {0x00,0x00,0x7C,0xC6,0xC6,0x0C,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00}, // 003f

  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xDE,0xDE,0xDE,0xDC,0xC0,0x7C,0x00,0x00,0x00,0x00}, // 0040
  {0x00,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 0041
  {0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x66,0x66,0x66,0x66,0xFC,0x00,0x00,0x00,0x00}, // 0042
  {0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xC0,0xC0,0xC2,0x66,0x3C,0x00,0x00,0x00,0x00}, // 0043
  {0x00,0x00,0xF8,0x6C,0x66,0x66,0x66,0x66,0x66,0x66,0x6C,0xF8,0x00,0x00,0x00,0x00}, // 0044
  {0x00,0x00,0xFE,0x66,0x62,0x68,0x78,0x68,0x60,0x62,0x66,0xFE,0x00,0x00,0x00,0x00}, // 0045
  {0x00,0x00,0xFE,0x66,0x62,0x68,0x78,0x68,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00}, // 0046
  {0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xDE,0xC6,0xC6,0x66,0x3A,0x00,0x00,0x00,0x00}, // 0047
  {0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 0048
  {0x00,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 0049
  {0x00,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x0C,0xCC,0xCC,0xCC,0x78,0x00,0x00,0x00,0x00}, // 004a
  {0x00,0x00,0xE6,0x66,0x66,0x6C,0x78,0x78,0x6C,0x66,0x66,0xE6,0x00,0x00,0x00,0x00}, // 004b
  {0x00,0x00,0xF0,0x60,0x60,0x60,0x60,0x60,0x60,0x62,0x66,0xFE,0x00,0x00,0x00,0x00}, // 004c
  {0x00,0x00,0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 004d
  {0x00,0x00,0xC6,0xE6,0xF6,0xFE,0xDE,0xCE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 004e
  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 004f

  {0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00}, // 0050
  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xD6,0xDE,0x7C,0x0C,0x0E,0x00,0x00}, // 0051
  {0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x6C,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,0x00}, // 0052
  {0x00,0x00,0x7C,0xC6,0xC6,0x60,0x38,0x0C,0x06,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0053
  {0x00,0x00,0x7E,0x7E,0x5A,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 0054
  {0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0055
  {0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x6C,0x38,0x10,0x00,0x00,0x00,0x00}, // 0056
  {0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xD6,0xD6,0xD6,0xFE,0xEE,0x6C,0x00,0x00,0x00,0x00}, // 0057
  {0x00,0x00,0xC6,0xC6,0x6C,0x7C,0x38,0x38,0x7C,0x6C,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 0058
  {0x00,0x00,0x66,0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 0059
  {0x00,0x00,0xFE,0xC6,0x86,0x0C,0x18,0x30,0x60,0xC2,0xC6,0xFE,0x00,0x00,0x00,0x00}, // 005a
  {0x00,0x00,0x3C,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3C,0x00,0x00,0x00,0x00}, // 005b
  {0x00,0x00,0x00,0x80,0xC0,0xE0,0x70,0x38,0x1C,0x0E,0x06,0x02,0x00,0x00,0x00,0x00}, // 005c
  {0x00,0x00,0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x00,0x00,0x00,0x00}, // 005d
  {0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 005e
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00}, // 005f

  {0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0060
  {0x00,0x00,0x00,0x00,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 0061
  {0x00,0x00,0xE0,0x60,0x60,0x78,0x6C,0x66,0x66,0x66,0x66,0x7C,0x00,0x00,0x00,0x00}, // 0062
  {0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC0,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0063
  {0x00,0x00,0x1C,0x0C,0x0C,0x3C,0x6C,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 0064
  {0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0065
  {0x00,0x00,0x38,0x6C,0x64,0x60,0xF0,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00}, // 0066
  {0x00,0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0xCC,0xCC,0xCC,0x7C,0x0C,0xCC,0x78,0x00}, // 0067
  {0x00,0x00,0xE0,0x60,0x60,0x6C,0x76,0x66,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,0x00}, // 0068
  {0x00,0x00,0x18,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 0069
  {0x00,0x00,0x06,0x06,0x00,0x0E,0x06,0x06,0x06,0x06,0x06,0x06,0x66,0x66,0x3C,0x00}, // 006a
  {0x00,0x00,0xE0,0x60,0x60,0x66,0x6C,0x78,0x78,0x6C,0x66,0xE6,0x00,0x00,0x00,0x00}, // 006b
  {0x00,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 006c
  {0x00,0x00,0x00,0x00,0x00,0xEC,0xFE,0xD6,0xD6,0xD6,0xD6,0xC6,0x00,0x00,0x00,0x00}, // 006d
  {0x00,0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00}, // 006e
  {0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 006f

  {0x00,0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00}, // 0070
  {0x00,0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0xCC,0xCC,0xCC,0x7C,0x0C,0x0C,0x1E,0x00}, // 0071
  {0x00,0x00,0x00,0x00,0x00,0xDC,0x76,0x66,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00}, // 0072
  {0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0x60,0x38,0x0C,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0073
  {0x00,0x00,0x10,0x30,0x30,0xFC,0x30,0x30,0x30,0x30,0x36,0x1C,0x00,0x00,0x00,0x00}, // 0074
  {0x00,0x00,0x00,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 0075
  {0x00,0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0x00,0x00,0x00,0x00}, // 0076
  {0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xD6,0xD6,0xD6,0xFE,0x6C,0x00,0x00,0x00,0x00}, // 0077
  {0x00,0x00,0x00,0x00,0x00,0xC6,0x6C,0x38,0x38,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00}, // 0078
  {0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0xF8,0x00}, // 0079
  {0x00,0x00,0x00,0x00,0x00,0xFE,0xCC,0x18,0x30,0x60,0xC6,0xFE,0x00,0x00,0x00,0x00}, // 007a
  {0x00,0x00,0x0E,0x18,0x18,0x18,0x70,0x18,0x18,0x18,0x18,0x0E,0x00,0x00,0x00,0x00}, // 007b
  {0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00}, // 00a6
  {0x00,0x00,0x70,0x18,0x18,0x18,0x0E,0x18,0x18,0x18,0x18,0x70,0x00,0x00,0x00,0x00}, // 007d
  {0x00,0x00,0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 007e
  {0x00,0x00,0x00,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xC6,0xFE,0x00,0x00,0x00,0x00,0x00}, // 2302

  {0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xC0,0xC2,0x66,0x3C,0x0C,0x06,0x7C,0x00,0x00}, // 00c7
  {0x00,0x00,0xCC,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00fc
  {0x00,0x0C,0x18,0x30,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00e9
  {0x00,0x10,0x38,0x6C,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00e2
  {0x00,0x00,0xCC,0x00,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00e4
  {0x00,0x60,0x30,0x18,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00e0
  {0x00,0x38,0x6C,0x38,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00e5
  {0x00,0x00,0x00,0x00,0x3C,0x66,0x60,0x60,0x66,0x3C,0x0C,0x06,0x3C,0x00,0x00,0x00}, // 00e7
  {0x00,0x10,0x38,0x6C,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00ea
  {0x00,0x00,0xC6,0x00,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00eb
  {0x00,0x60,0x30,0x18,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00e8
  {0x00,0x00,0x66,0x00,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 00ef
  {0x00,0x18,0x3C,0x66,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 00ee
  {0x00,0x60,0x30,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 00ec
  {0x00,0xC6,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 00c4
  {0x38,0x6C,0x38,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 00c5

  {0x18,0x30,0x60,0x00,0xFE,0x66,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00}, // 00c9
  {0x00,0x00,0x00,0x00,0x6C,0xFE,0xB2,0x32,0x7E,0xD8,0xD8,0x6E,0x00,0x00,0x00,0x00}, // 00e6
  {0x00,0x00,0x3E,0x6C,0xCC,0xCC,0xFE,0xCC,0xCC,0xCC,0xCC,0xCE,0x00,0x00,0x00,0x00}, // 00c6
  {0x00,0x10,0x38,0x6C,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00f4
  {0x00,0x00,0xC6,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00f6
  {0x00,0x60,0x30,0x18,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00f2
  {0x00,0x30,0x78,0xCC,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00fb
  {0x00,0x60,0x30,0x18,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00f9
  {0x00,0x00,0xC6,0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0x78,0x00}, // 00ff
  {0x00,0xC6,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00d6
  {0x00,0xC6,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00dc
  {0x00,0x18,0x18,0x3C,0x66,0x60,0x60,0x60,0x66,0x3C,0x18,0x18,0x00,0x00,0x00,0x00}, // 00a2
  {0x00,0x38,0x6C,0x64,0x60,0xF0,0x60,0x60,0x60,0x60,0xE6,0xFC,0x00,0x00,0x00,0x00}, // 00a3
  {0x00,0x00,0x66,0x66,0x3C,0x18,0x7E,0x18,0x7E,0x18,0x18,0x18,0x00,0x00,0x00,0x00}, // 00a5
  {0x00,0xF8,0xCC,0xCC,0xF8,0xC4,0xCC,0xDE,0xCC,0xCC,0xCC,0xC6,0x00,0x00,0x00,0x00}, // 20a7
  {0x00,0x0E,0x1B,0x18,0x18,0x18,0x7E,0x18,0x18,0x18,0x18,0x18,0xD8,0x70,0x00,0x00}, // 0192

  {0x00,0x18,0x30,0x60,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00e1
  {0x00,0x0C,0x18,0x30,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 00ed
  {0x00,0x18,0x30,0x60,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00f3
  {0x00,0x18,0x30,0x60,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00fa
  {0x00,0x00,0x76,0xDC,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00}, // 00f1
  {0x76,0xDC,0x00,0xC6,0xE6,0xF6,0xFE,0xDE,0xCE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 00d1
  {0x00,0x3C,0x6C,0x6C,0x3E,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 00aa
  {0x00,0x38,0x6C,0x6C,0x38,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 00ba
  {0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x60,0xC0,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00bf
  {0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xC0,0xC0,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00}, // 2310
  {0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00,0x00}, // 00ac
  {0x00,0xC0,0xC0,0xC2,0xC6,0xCC,0x18,0x30,0x60,0xDC,0x86,0x0C,0x18,0x3E,0x00,0x00}, // 00bd
  {0x00,0xC0,0xC0,0xC2,0xC6,0xCC,0x18,0x30,0x66,0xCE,0x9E,0x3E,0x06,0x06,0x00,0x00}, // 00bc
  {0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x18,0x3C,0x3C,0x3C,0x18,0x00,0x00,0x00,0x00}, // 00a1
  {0x00,0x00,0x00,0x00,0x00,0x36,0x6C,0xD8,0x6C,0x36,0x00,0x00,0x00,0x00,0x00,0x00}, // 00ab
  {0x00,0x00,0x00,0x00,0x00,0xD8,0x6C,0x36,0x6C,0xD8,0x00,0x00,0x00,0x00,0x00,0x00}, // 00bb

  {0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44}, // 2591
  {0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA}, // 2592
  {0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77}, // 2593
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 2502
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 2524
  /*{0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2561
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe}, // 2562
  /*{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe}, // 2556
  /*{0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 2555
  {0x36,0x36,0x36,0x36,0x36,0xF6,0x06,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 2563
  {0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 2551
  {0x00,0x00,0x00,0x00,0x00,0xFE,0x06,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 2557
  {0x36,0x36,0x36,0x36,0x36,0xF6,0x06,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 255d
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 255c
  /*{0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 255b
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 2510

  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2514
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2534
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 252c
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 251c
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2500
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 253c
  /*{0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 255e
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 255f
  {0x36,0x36,0x36,0x36,0x36,0x37,0x30,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 255a
  {0x00,0x00,0x00,0x00,0x00,0x3F,0x30,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 2554
  {0x36,0x36,0x36,0x36,0x36,0xF7,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2569
  {0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xF7,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 2566
  {0x36,0x36,0x36,0x36,0x36,0x37,0x30,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 2560
  {0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2550
  {0x36,0x36,0x36,0x36,0x36,0xF7,0x00,0xF7,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 256c
  /*{0x18,0x18,0x18,0x18,0x18,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 2567

  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2568
  /*{0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2564
  /*{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2565
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2559
  /*{0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00}, // 2558
  /*{0x00,0x00,0x00,0x00,0x00,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00}, // 2552
  /*{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00}, // 2553
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFF,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 256b
  {0x18,0x18,0x18,0x18,0x18,0xFF,0x18,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 256a
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2518
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 250c
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}, // 2588
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}, // 2584
  {0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0}, // 258c
  {0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F}, // 2590
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2580

  {0x00,0x00,0x00,0x00,0x00,0x76,0xDC,0xD8,0xD8,0xD8,0xDC,0x76,0x00,0x00,0x00,0x00}, // 03b1
  {0x00,0x00,0x78,0xCC,0xCC,0xCC,0xD8,0xCC,0xC6,0xC6,0xC6,0xCC,0x00,0x00,0x00,0x00}, // 00df
  {0x00,0x00,0xFE,0xC6,0xC6,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0x00,0x00,0x00,0x00}, // 0393
  {0x00,0x00,0x00,0x00,0xFE,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00}, // 03c0
  {0x00,0x00,0x00,0xFE,0xC6,0x60,0x30,0x18,0x30,0x60,0xC6,0xFE,0x00,0x00,0x00,0x00}, // 03a3
  {0x00,0x00,0x00,0x00,0x00,0x7E,0xD8,0xD8,0xD8,0xD8,0xD8,0x70,0x00,0x00,0x00,0x00}, // 03c3
  {0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0xC0,0x00,0x00,0x00}, // 00b5
  {0x00,0x00,0x00,0x00,0x76,0xDC,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00}, // 03c4
  {0x00,0x00,0x00,0x7E,0x18,0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x00,0x00,0x00,0x00}, // 03a6
  {0x00,0x00,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0x6C,0x38,0x00,0x00,0x00,0x00}, // 0398
  {0x00,0x00,0x38,0x6C,0xC6,0xC6,0xC6,0x6C,0x6C,0x6C,0x6C,0xEE,0x00,0x00,0x00,0x00}, // 03a9
  {0x00,0x00,0x1E,0x30,0x18,0x0C,0x3E,0x66,0x66,0x66,0x66,0x3C,0x00,0x00,0x00,0x00}, // 03b4
  {0x00,0x00,0x00,0x00,0x00,0x7E,0xDB,0xDB,0xDB,0x7E,0x00,0x00,0x00,0x00,0x00,0x00}, // 221e
  {0x00,0x00,0x00,0x03,0x06,0x7E,0xDB,0xDB,0xF3,0x7E,0x60,0xC0,0x00,0x00,0x00,0x00}, // 03c6
  {0x00,0x00,0x1C,0x30,0x60,0x60,0x7C,0x60,0x60,0x60,0x30,0x1C,0x00,0x00,0x00,0x00}, // 03b5
  {0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 2229

  {0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0xFE,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00}, // 2261
  {0x00,0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,0xFF,0x00,0x00,0x00,0x00}, // 00b1
  {0x00,0x00,0x00,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x00,0x7E,0x00,0x00,0x00,0x00}, // 2265
  {0x00,0x00,0x00,0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x00,0x7E,0x00,0x00,0x00,0x00}, // 2264
  {0x00,0x00,0x0E,0x1B,0x1B,0x1B,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 2320
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xD8,0xD8,0xD8,0x70,0x00,0x00,0x00,0x00}, // 2321
  {0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x7E,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00}, // 00f7
  {0x00,0x00,0x00,0x00,0x00,0x76,0xDC,0x00,0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00}, // 2248
  {0x00,0x38,0x6C,0x6C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 00b0
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2219
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 00b7
  {0x00,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0xEC,0x6C,0x6C,0x3C,0x1C,0x00,0x00,0x00,0x00}, // 221a
  {0x00,0xD8,0x6C,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 207f
  {0x00,0x70,0xD8,0x30,0x60,0xC8,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 00b2
  {0x00,0x00,0x00,0x00,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00}, // 25a0
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}  // 00a0
};

const struct FontData_8x8_t plFont_8x8_latin1_addons[41] =
{
	{0x007c, {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00}},
	{0x00a4, {0x82,0x54,0x6c,0x82,0x6c,0x54,0x82,0x00}},
	{0x00a8, {0x00,0xc6,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00a9, {0x38,0x44,0x9A,0xA2,0x9A,0x44,0x38,0x00}},
	{0x00ad, {0x00,0x00,0x00,0xfe,0x00,0x00,0x00,0x00}},
	{0x00ae, {0x7c,0x82,0xba,0xba,0xb2,0xaa,0x7c,0x00}},
	{0x00af, {0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00b3, {0x70,0x08,0x30,0x08,0x70,0x00,0x00,0x00}},
	{0x00b4, {0x18,0x30,0x60,0x00,0x00,0x00,0x00,0x00}},
	{0x00b8, {0x00,0x00,0x00,0x00,0x00,0x10,0x20,0x00}},
	{0x00b9, {0x20,0x60,0x20,0x20,0x70,0x00,0x00,0x00}},
	{0x00be, {0xe3,0xe6,0x6c,0xdb,0x37,0x6f,0xcf,0x03}},
	{0x00c0, {0xe0,0x00,0x78,0xcc,0xfc,0xcc,0xcc,0x00}},
	{0x00c1, {0x1c,0x00,0x78,0xcc,0xfc,0xcc,0xcc,0x00}},
	{0x00c2, {0x30,0x48,0x00,0x78,0xcc,0xfc,0xcc,0x00}},
	{0x00c3, {0x76,0xdc,0x00,0x78,0xcc,0xfc,0xcc,0x00}},
	{0x00c8, {0xe0,0x00,0xfc,0x60,0x78,0x60,0xfc,0x00}},
	{0x00ca, {0x30,0x48,0xfc,0x60,0x78,0x60,0xfc,0x00}},
	{0x00cb, {0x6c,0x00,0xfc,0x60,0x78,0x60,0xfc,0x00}},
	{0x00cc, {0xe0,0x00,0x78,0x30,0x30,0x30,0x78,0x00}},
	{0x00cd, {0x1c,0x00,0x78,0x30,0x30,0x30,0x78,0x00}},
	{0x00ce, {0x30,0x48,0x78,0x30,0x30,0x30,0x78,0x00}},
	{0x00cf, {0xcc,0x00,0x78,0x30,0x30,0x30,0x78,0x00}},
	{0x00d0, {0xf8,0x6c,0x66,0xf6,0x66,0x6c,0xf8,0x00}},
	{0x00d2, {0xe0,0x00,0x38,0x6C,0xC6,0x6C,0x38,0x00}},
	{0x00d3, {0x1c,0x00,0x38,0x6C,0xC6,0x6C,0x38,0x00}},
	{0x00d4, {0x30,0x48,0x38,0x6C,0xC6,0x6C,0x38,0x00}},
	{0x00d5, {0x76,0xdc,0x38,0x6C,0xC6,0x6c,0x38,0x00}},
	{0x00d7, {0x00,0x44,0x28,0x10,0x28,0x44,0x00,0x00}},
	{0x00d8, {0x0c,0x38,0x6c,0xd6,0x6c,0x38,0x60,0x00}},
	{0x00d9, {0xe0,0x00,0xCC,0xCC,0xCC,0xCC,0x78,0x00}},
	{0x00da, {0x1c,0x00,0xCC,0xCC,0xCC,0xCC,0x78,0x00}},
	{0x00db, {0x30,0x48,0x00,0xCC,0xCC,0xCC,0x78,0x00}},
	{0x00dd, {0x00,0xe0,0x00,0xCC,0xCC,0x7C,0x0C,0xF8}},
	{0x00de, {0x60,0x60,0x7c,0x66,0x7c,0x60,0x60,0x00}},
	{0x00e3, {0xfe,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00}},
	{0x00f0, {0x0c,0x1e,0x0c,0x7c,0xa6,0xac,0x38,0x00}},
	{0x00f5, {0x76,0xdc,0x00,0x78,0xcc,0xcc,0x78,0x00}},
	{0x00f8, {0x00,0x04,0x38,0x54,0x64,0x78,0x80,0x00}},
	{0x00fd, {0xe0,0x00,0xCC,0xCC,0xCC,0x7C,0x0C,0xF8}},
	{0x00fe, {0x60,0x7c,0x66,0x66,0x66,0x7c,0x60,0x00}}
};


const struct FontData_8x16_t plFont_8x16_latin1_addons[41] =
{
	{0x007c, {0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00}},
	{0x00a4, {0x00,0x00,0x00,0x82,0x44,0x7C,0xC6,0xC6,0xC6,0xC6,0x7C,0x44,0x82,0x00,0x00,0x00}},
	{0x00a8, {0x00,0xC6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00a9, {0x00,0x00,0x00,0x00,0x38,0x44,0x9A,0xA2,0xA2,0x9A,0x44,0x38,0x00,0x00,0x00,0x00}},
	{0x00ad, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00ae, {0x00,0x00,0x00,0x10,0x6C,0x82,0xB2,0xAA,0xB2,0xAA,0xAA,0x82,0x6C,0x10,0x00,0x00}},
	{0x00af, {0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00b3, {0x70,0x08,0x30,0x08,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00b4, {0x18,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00b8, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x20,0x00,0x00}},
	{0x00b9, {0x20,0x60,0x20,0x20,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00be, {0xE0,0x10,0x60,0x12,0x16,0xEC,0x18,0x30,0x66,0xCE,0x9E,0x3E,0x06,0x06,0x00,0x00}},
	{0x00c0, {0x30,0x18,0x0C,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}},
	{0x00c1, {0x18,0x30,0x60,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}},
	{0x00c2, {0x10,0x38,0x6C,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}},
	{0x00c3, {0x76,0xDC,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}},
	{0x00c8, {0x30,0x18,0x0C,0x00,0xFE,0x66,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00}},
	{0x00ca, {0x10,0x38,0x6C,0x00,0xFE,0x66,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00}},
	{0x00cb, {0x00,0xC6,0x00,0x00,0xFE,0x66,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00}},
	{0x00cc, {0x30,0x18,0x0C,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}},
	{0x00cd, {0x18,0x30,0x60,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}},
	{0x00ce, {0x10,0x38,0x6C,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}},
	{0x00cf, {0x00,0xC6,0x00,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}},
	{0x00d0, {0x00,0x00,0xF8,0x6C,0x66,0x66,0xF6,0xF6,0x66,0x66,0x6C,0xF8,0x00,0x00,0x00,0x00}},
	{0x00d2, {0x30,0x18,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00d3, {0x18,0x30,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00d4, {0x10,0x6C,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00d5, {0x76,0xDC,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00d7, {0x00,0x00,0x00,0x00,0x00,0xC6,0x6C,0x38,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,0x00}},
	{0x00d8, {0x00,0x02,0x7C,0xCE,0xD6,0xD6,0xD6,0xD6,0xD6,0xE6,0xC6,0x7C,0x80,0x00,0x00,0x00}},
	{0x00d9, {0x30,0x18,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00da, {0x08,0x30,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00db, {0x10,0x6C,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00dd, {0x18,0x30,0x60,0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}},
	{0x00de, {0x00,0x00,0x00,0x00,0x60,0x7C,0x66,0x66,0x66,0x66,0x7C,0x60,0x00,0x00,0x00,0x00}},
	{0x00e3, {0x00,0x76,0xDC,0x00,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}},
	{0x00f0, {0x00,0x00,0x18,0x3C,0x0C,0x7E,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00f5, {0x00,0x76,0xDC,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00f8, {0x00,0x00,0x00,0x00,0x04,0x7C,0xCE,0xD6,0xD6,0xD6,0xE6,0x7C,0x40,0x00,0x00,0x00}},
	{0x00fd, {0x00,0x18,0x30,0x60,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0x78,0x00}},
	{0x00fe, {0x00,0x60,0x60,0x7C,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0x00,0x00,0x00,0x00}}
};

