!***********************************************************************
! This file is part of OpenMolcas.                                     *
!                                                                      *
! OpenMolcas is free software; you can redistribute it and/or modify   *
! it under the terms of the GNU Lesser General Public License, v. 2.1. *
! OpenMolcas is distributed in the hope that it will be useful, but it *
! is provided "as is" and without any express or implied warranties.   *
! For more details see the full text of the license in the file        *
! LICENSE or in <http://www.gnu.org/licenses/>.                        *
!                                                                      *
! Copyright (C) 1986, Per E. M. Siegbahn                               *
!               2021, Ignacio Fdez. Galvan                             *
!***********************************************************************
! 2021: Remove GOTOs

subroutine LOOP4(KM,ISTOP,IT1,IT2)

use guga_global, only: BS3, BS4, COUP, IA, IB, ICOUP, ICOUP1, IWAY, IY, J1, J2, K0, K1, K2, K3
use Definitions, only: iwp

implicit none
integer(kind=iwp), intent(in) :: KM, IT1, IT2
integer(kind=iwp), intent(out) :: ISTOP
integer(kind=iwp) :: IDIF, IWAYKM, KM1

ISTOP = 0
! STOP THE LOOP
KM1 = KM+1
IDIF = IA(J2(KM1))-IA(J1(KM1))
if ((IDIF < 0) .or. (IDIF > 1)) then
  ISTOP = 1
else if (IDIF /= 0) then
  ! CASE E-F
  IWAYKM = IWAY(KM)
  if (IWAYKM == 1) then
    IWAY(KM) = 2
    if ((K0(IT1+J1(KM1)) == 0) .or. (K2(IT2+J2(KM1)) == 0)) then
      IWAYKM = 2
    else
      COUP(KM) = COUP(KM1)
      J2(KM) = K0(IT1+J1(KM1))
      J1(KM) = J2(KM)
      ICOUP(KM) = ICOUP(KM1)+IY(IT2+J2(KM1),2)
      ICOUP1(KM) = ICOUP1(KM1)
    end if
  end if
  if (IWAYKM == 2) then
    IWAY(KM) = 3
    if ((K1(IT1+J1(KM1)) == 0) .or. (K3(IT2+J2(KM1)) == 0)) then
      IWAYKM = 3
    else
      COUP(KM) = COUP(KM1)*BS3(IB(J1(KM1))+1)
      J2(KM) = K1(IT1+J1(KM1))
      J1(KM) = J2(KM)
      ICOUP(KM) = ICOUP(KM1)+IY(IT2+J2(KM1),3)
      ICOUP1(KM) = ICOUP1(KM1)+IY(IT1+J1(KM1),1)
    end if
  end if
  if (IWAYKM == 3) ISTOP = 1
else
  ! CASE G-H
  IWAYKM = IWAY(KM)
  if (IWAYKM == 1) then
    IWAY(KM) = 2
    if ((K0(IT1+J1(KM1)) == 0) .or. (K1(IT2+J2(KM1)) == 0)) then
      IWAYKM = 2
    else
      COUP(KM) = COUP(KM1)
      J2(KM) = K0(IT1+J1(KM1))
      J1(KM) = J2(KM)
      ICOUP(KM) = ICOUP(KM1)+IY(IT2+J2(KM1),1)
      ICOUP1(KM) = ICOUP1(KM1)
    end if
  end if
  if (IWAYKM == 2) then
    IWAY(KM) = 3
    if ((K2(IT1+J1(KM1)) == 0) .or. (K3(IT2+J2(KM1)) == 0)) then
      IWAYKM = 3
    else
      COUP(KM) = COUP(KM1)*BS4(IB(J1(KM1))+1)
      J2(KM) = K2(IT1+J1(KM1))
      J1(KM) = J2(KM)
      ICOUP(KM) = ICOUP(KM1)+IY(IT2+J2(KM1),3)
      ICOUP1(KM) = ICOUP1(KM1)+IY(IT1+J1(KM1),2)
    end if
  end if
  if (IWAYKM == 3) ISTOP = 1
end if

return

end subroutine LOOP4
